/*
   Copyright (c) 2015 Broadcom
   All Rights Reserved

    <:label-BRCM:2015:DUAL/GPL:standard
    
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License, version 2, as published by
    the Free Software Foundation (the "GPL").
    
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
    
    
    A copy of the GPL is available at http://www.broadcom.com/licenses/GPLv2.php, or by
    writing to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
    
:>
*/

#include "ru.h"

#if RU_INCLUDE_FIELD_DB
/******************************************************************************
 * Field: UNIMAC_RDP_IPG_HD_BKP_CNTL_RESERVED0
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_IPG_HD_BKP_CNTL_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    UNIMAC_RDP_IPG_HD_BKP_CNTL_RESERVED0_FIELD_MASK,
    0,
    UNIMAC_RDP_IPG_HD_BKP_CNTL_RESERVED0_FIELD_WIDTH,
    UNIMAC_RDP_IPG_HD_BKP_CNTL_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_IPG_HD_BKP_CNTL_IPG_CONFIG_RX
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_IPG_HD_BKP_CNTL_IPG_CONFIG_RX_FIELD =
{
    "IPG_CONFIG_RX",
#if RU_INCLUDE_DESC
    "",
    "The programmable Rx IPG below which the packets received are dropped graciously. The value is in Bytes for 1/2.5G and Nibbles for 10/100M.",
#endif
    UNIMAC_RDP_IPG_HD_BKP_CNTL_IPG_CONFIG_RX_FIELD_MASK,
    0,
    UNIMAC_RDP_IPG_HD_BKP_CNTL_IPG_CONFIG_RX_FIELD_WIDTH,
    UNIMAC_RDP_IPG_HD_BKP_CNTL_IPG_CONFIG_RX_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_IPG_HD_BKP_CNTL_HD_FC_BKOFF_OK
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_IPG_HD_BKP_CNTL_HD_FC_BKOFF_OK_FIELD =
{
    "HD_FC_BKOFF_OK",
#if RU_INCLUDE_DESC
    "",
    "Register bit 1 refers to the application of backoff algorithm during HD backpressure.",
#endif
    UNIMAC_RDP_IPG_HD_BKP_CNTL_HD_FC_BKOFF_OK_FIELD_MASK,
    0,
    UNIMAC_RDP_IPG_HD_BKP_CNTL_HD_FC_BKOFF_OK_FIELD_WIDTH,
    UNIMAC_RDP_IPG_HD_BKP_CNTL_HD_FC_BKOFF_OK_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_IPG_HD_BKP_CNTL_HD_FC_ENA
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_IPG_HD_BKP_CNTL_HD_FC_ENA_FIELD =
{
    "HD_FC_ENA",
#if RU_INCLUDE_DESC
    "",
    "When set, enables back-pressure in half-duplex mode.",
#endif
    UNIMAC_RDP_IPG_HD_BKP_CNTL_HD_FC_ENA_FIELD_MASK,
    0,
    UNIMAC_RDP_IPG_HD_BKP_CNTL_HD_FC_ENA_FIELD_WIDTH,
    UNIMAC_RDP_IPG_HD_BKP_CNTL_HD_FC_ENA_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_COMMAND_CONFIG_ETH_SPEED_BIT2
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_COMMAND_CONFIG_ETH_SPEED_BIT2_FIELD =
{
    "ETH_SPEED_BIT2",
#if RU_INCLUDE_DESC
    "",
    "This is bit 2 for ETH_SPEED. See ETH_SPEED below.",
#endif
    UNIMAC_RDP_COMMAND_CONFIG_ETH_SPEED_BIT2_FIELD_MASK,
    0,
    UNIMAC_RDP_COMMAND_CONFIG_ETH_SPEED_BIT2_FIELD_WIDTH,
    UNIMAC_RDP_COMMAND_CONFIG_ETH_SPEED_BIT2_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_COMMAND_CONFIG_RUNT_FILTER_DIS
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_COMMAND_CONFIG_RUNT_FILTER_DIS_FIELD =
{
    "RUNT_FILTER_DIS",
#if RU_INCLUDE_DESC
    "",
    "When set, disable runt filtering.",
#endif
    UNIMAC_RDP_COMMAND_CONFIG_RUNT_FILTER_DIS_FIELD_MASK,
    0,
    UNIMAC_RDP_COMMAND_CONFIG_RUNT_FILTER_DIS_FIELD_WIDTH,
    UNIMAC_RDP_COMMAND_CONFIG_RUNT_FILTER_DIS_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_COMMAND_CONFIG_OOB_EFC_DISAB
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_COMMAND_CONFIG_OOB_EFC_DISAB_FIELD =
{
    "OOB_EFC_DISAB",
#if RU_INCLUDE_DESC
    "",
    "When this bit is set, out-of-band egress flow control will be disabled. When this bit is 0 (out-of-band egress flow control enabled) and input pin ext_tx_flow_control is 1, frame transmissions may be stopped - see OOB_EFC_MODE for details.\n"
    "Out-of-band egress flow control operation is similar to halting the transmit datapath due to reception of a Pause Frame with a non-zero timer value. This bit however has no effect on regular Rx Pause Frame based egress flow control.",
#endif
    UNIMAC_RDP_COMMAND_CONFIG_OOB_EFC_DISAB_FIELD_MASK,
    0,
    UNIMAC_RDP_COMMAND_CONFIG_OOB_EFC_DISAB_FIELD_WIDTH,
    UNIMAC_RDP_COMMAND_CONFIG_OOB_EFC_DISAB_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_COMMAND_CONFIG_IGNORE_TX_PAUSE
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_COMMAND_CONFIG_IGNORE_TX_PAUSE_FIELD =
{
    "IGNORE_TX_PAUSE",
#if RU_INCLUDE_DESC
    "",
    "Ignores the back pressure signaling from the system and hence no Tx pause generation, when set.",
#endif
    UNIMAC_RDP_COMMAND_CONFIG_IGNORE_TX_PAUSE_FIELD_MASK,
    0,
    UNIMAC_RDP_COMMAND_CONFIG_IGNORE_TX_PAUSE_FIELD_WIDTH,
    UNIMAC_RDP_COMMAND_CONFIG_IGNORE_TX_PAUSE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_COMMAND_CONFIG_FD_TX_URUN_FIX_EN
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_COMMAND_CONFIG_FD_TX_URUN_FIX_EN_FIELD =
{
    "FD_TX_URUN_FIX_EN",
#if RU_INCLUDE_DESC
    "",
    "Tx Underflow detection can be improved by accounting for residue bytes in 128b to 8b convertor. The fix is valid only for full duplex mode and can be enabled by setting this bit.",
#endif
    UNIMAC_RDP_COMMAND_CONFIG_FD_TX_URUN_FIX_EN_FIELD_MASK,
    0,
    UNIMAC_RDP_COMMAND_CONFIG_FD_TX_URUN_FIX_EN_FIELD_WIDTH,
    UNIMAC_RDP_COMMAND_CONFIG_FD_TX_URUN_FIX_EN_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_COMMAND_CONFIG_RESERVED0
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_COMMAND_CONFIG_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    UNIMAC_RDP_COMMAND_CONFIG_RESERVED0_FIELD_MASK,
    0,
    UNIMAC_RDP_COMMAND_CONFIG_RESERVED0_FIELD_WIDTH,
    UNIMAC_RDP_COMMAND_CONFIG_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_COMMAND_CONFIG_LINE_LOOPBACK
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_COMMAND_CONFIG_LINE_LOOPBACK_FIELD =
{
    "LINE_LOOPBACK",
#if RU_INCLUDE_DESC
    "",
    "Enable Line Loopback i.e. MAC FIFO side loopback (RX to TX) when set to '1', normal operation when set to '0' (Reset value).",
#endif
    UNIMAC_RDP_COMMAND_CONFIG_LINE_LOOPBACK_FIELD_MASK,
    0,
    UNIMAC_RDP_COMMAND_CONFIG_LINE_LOOPBACK_FIELD_WIDTH,
    UNIMAC_RDP_COMMAND_CONFIG_LINE_LOOPBACK_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_COMMAND_CONFIG_NO_LGTH_CHECK
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_COMMAND_CONFIG_NO_LGTH_CHECK_FIELD =
{
    "NO_LGTH_CHECK",
#if RU_INCLUDE_DESC
    "",
    "Payload Length Check Disable. When set to '0', the Core checks the frame's payload length with the Frame\n"
    "Length/Type field, when set to '1'(Reset value), the payload length check is disabled.",
#endif
    UNIMAC_RDP_COMMAND_CONFIG_NO_LGTH_CHECK_FIELD_MASK,
    0,
    UNIMAC_RDP_COMMAND_CONFIG_NO_LGTH_CHECK_FIELD_WIDTH,
    UNIMAC_RDP_COMMAND_CONFIG_NO_LGTH_CHECK_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_COMMAND_CONFIG_CNTL_FRM_ENA
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_COMMAND_CONFIG_CNTL_FRM_ENA_FIELD =
{
    "CNTL_FRM_ENA",
#if RU_INCLUDE_DESC
    "",
    "MAC Control Frame Enable. When set to '1', MAC Control frames with any \n"
    "Opcode other than 0x0001 are accepted and forward to the Client interface. \n"
    "When set to '0' (Reset value), MAC Control frames with any Opcode other \n"
    "than 0x0001 are silently discarded.",
#endif
    UNIMAC_RDP_COMMAND_CONFIG_CNTL_FRM_ENA_FIELD_MASK,
    0,
    UNIMAC_RDP_COMMAND_CONFIG_CNTL_FRM_ENA_FIELD_WIDTH,
    UNIMAC_RDP_COMMAND_CONFIG_CNTL_FRM_ENA_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_COMMAND_CONFIG_ENA_EXT_CONFIG
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_COMMAND_CONFIG_ENA_EXT_CONFIG_FIELD =
{
    "ENA_EXT_CONFIG",
#if RU_INCLUDE_DESC
    "",
    "Enable Configuration with External Pins. When set to '0' (Reset value) \n"
    "the Core speed and Mode is programmed with the register bits ETH_SPEED(2:0) \n"
    "and HD_ENA. When set to '1', the Core is configured with the pins \n"
    "set_speed(1:0) and set_duplex.",
#endif
    UNIMAC_RDP_COMMAND_CONFIG_ENA_EXT_CONFIG_FIELD_MASK,
    0,
    UNIMAC_RDP_COMMAND_CONFIG_ENA_EXT_CONFIG_FIELD_WIDTH,
    UNIMAC_RDP_COMMAND_CONFIG_ENA_EXT_CONFIG_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_COMMAND_CONFIG_EN_INTERNAL_TX_CRS
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_COMMAND_CONFIG_EN_INTERNAL_TX_CRS_FIELD =
{
    "EN_INTERNAL_TX_CRS",
#if RU_INCLUDE_DESC
    "",
    "If enabled, then CRS input to Unimac is ORed with tds[8] (tx data valid output). This is helpful when TX CRS is disabled inside PHY.",
#endif
    UNIMAC_RDP_COMMAND_CONFIG_EN_INTERNAL_TX_CRS_FIELD_MASK,
    0,
    UNIMAC_RDP_COMMAND_CONFIG_EN_INTERNAL_TX_CRS_FIELD_WIDTH,
    UNIMAC_RDP_COMMAND_CONFIG_EN_INTERNAL_TX_CRS_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_COMMAND_CONFIG_BYPASS_OOB_EFC_SYNCHRONIZER
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_COMMAND_CONFIG_BYPASS_OOB_EFC_SYNCHRONIZER_FIELD =
{
    "BYPASS_OOB_EFC_SYNCHRONIZER",
#if RU_INCLUDE_DESC
    "",
    "1=> bypass the OOB external flow control signal synchronizer, to e.g. reduce latency. In this case it is assumed/required that Unimac input ext_tx_flow_control is already in tx_clk clock domain (so there is no need to synchronize it)\n"
    "0=> locally synchronize the OOB egress flow control signal to tx_clk. In this case it is assumed/required that ext_tx_flow_control is glitchless (e.g. registered in its native clock domain).",
#endif
    UNIMAC_RDP_COMMAND_CONFIG_BYPASS_OOB_EFC_SYNCHRONIZER_FIELD_MASK,
    0,
    UNIMAC_RDP_COMMAND_CONFIG_BYPASS_OOB_EFC_SYNCHRONIZER_FIELD_WIDTH,
    UNIMAC_RDP_COMMAND_CONFIG_BYPASS_OOB_EFC_SYNCHRONIZER_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_COMMAND_CONFIG_OOB_EFC_MODE
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_COMMAND_CONFIG_OOB_EFC_MODE_FIELD =
{
    "OOB_EFC_MODE",
#if RU_INCLUDE_DESC
    "",
    "0=> strict/full OOB egress backpressure mode:\n"
    "- pause frames and PFC frames, as well as regular packets, are all affected by Unimac input ext_tx_flow_control, as long as OOB_EFC_DISAB is 0\n"
    "- in this mode, OOB backpressure will be active as long as ext_tx_flow_control is asserted and i_oob_efc_disab is 0, regardless of whether the MAC operates in half duplex mode or full duplex mode\n"
    "1=> legacy mode:\n"
    "- ext_tx_flow_control does not affect (does not prevent) transmission of Pause and PFC frames, i.e. in this mode OOB egress backpressure may only affect transmission of regular packets\n"
    "- OOB egress backpressure is fully disabled (ignored) when the MAC operates in half duplex mode.",
#endif
    UNIMAC_RDP_COMMAND_CONFIG_OOB_EFC_MODE_FIELD_MASK,
    0,
    UNIMAC_RDP_COMMAND_CONFIG_OOB_EFC_MODE_FIELD_WIDTH,
    UNIMAC_RDP_COMMAND_CONFIG_OOB_EFC_MODE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_COMMAND_CONFIG_SW_OVERRIDE_RX
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_COMMAND_CONFIG_SW_OVERRIDE_RX_FIELD =
{
    "SW_OVERRIDE_RX",
#if RU_INCLUDE_DESC
    "",
    "If set, enables the SW programmed Rx pause capability config bits to overwrite the auto negotiated Rx pause capabilities when ena_ext_config (autoconfig) is set.\n"
    "If cleared, and when ena_ext_config (autoconfig) is set, then SW programmed Rx pause capability config bits has no effect over auto negotiated capabilities.",
#endif
    UNIMAC_RDP_COMMAND_CONFIG_SW_OVERRIDE_RX_FIELD_MASK,
    0,
    UNIMAC_RDP_COMMAND_CONFIG_SW_OVERRIDE_RX_FIELD_WIDTH,
    UNIMAC_RDP_COMMAND_CONFIG_SW_OVERRIDE_RX_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_COMMAND_CONFIG_SW_OVERRIDE_TX
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_COMMAND_CONFIG_SW_OVERRIDE_TX_FIELD =
{
    "SW_OVERRIDE_TX",
#if RU_INCLUDE_DESC
    "",
    "If set, enables the SW programmed Tx pause capability config bits to overwrite the auto negotiated Tx pause capabilities when ena_ext_config (autoconfig) is set.\n"
    "If cleared, and when ena_ext_config (autoconfig) is set, then SW programmed Tx pause capability config bits has no effect over auto negotiated capabilities.",
#endif
    UNIMAC_RDP_COMMAND_CONFIG_SW_OVERRIDE_TX_FIELD_MASK,
    0,
    UNIMAC_RDP_COMMAND_CONFIG_SW_OVERRIDE_TX_FIELD_WIDTH,
    UNIMAC_RDP_COMMAND_CONFIG_SW_OVERRIDE_TX_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_COMMAND_CONFIG_MAC_LOOP_CON
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_COMMAND_CONFIG_MAC_LOOP_CON_FIELD =
{
    "MAC_LOOP_CON",
#if RU_INCLUDE_DESC
    "",
    "Transmit packets to PHY while in MAC local loopback, when set to '1', otherwise transmit to PHY is disabled (normal operation),\n"
    "when set to '0' (Reset value).",
#endif
    UNIMAC_RDP_COMMAND_CONFIG_MAC_LOOP_CON_FIELD_MASK,
    0,
    UNIMAC_RDP_COMMAND_CONFIG_MAC_LOOP_CON_FIELD_WIDTH,
    UNIMAC_RDP_COMMAND_CONFIG_MAC_LOOP_CON_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_COMMAND_CONFIG_LOOP_ENA
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_COMMAND_CONFIG_LOOP_ENA_FIELD =
{
    "LOOP_ENA",
#if RU_INCLUDE_DESC
    "",
    "Enable GMII/MII loopback (TX to RX) when set to '1', normal operation when set to '0' (Reset value).",
#endif
    UNIMAC_RDP_COMMAND_CONFIG_LOOP_ENA_FIELD_MASK,
    0,
    UNIMAC_RDP_COMMAND_CONFIG_LOOP_ENA_FIELD_WIDTH,
    UNIMAC_RDP_COMMAND_CONFIG_LOOP_ENA_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_COMMAND_CONFIG_FCS_CORRUPT_URUN_EN
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_COMMAND_CONFIG_FCS_CORRUPT_URUN_EN_FIELD =
{
    "FCS_CORRUPT_URUN_EN",
#if RU_INCLUDE_DESC
    "",
    "Corrupt Tx FCS, on underrun, when set to '1', No FCS corruption when set to '0' (Reset value).",
#endif
    UNIMAC_RDP_COMMAND_CONFIG_FCS_CORRUPT_URUN_EN_FIELD_MASK,
    0,
    UNIMAC_RDP_COMMAND_CONFIG_FCS_CORRUPT_URUN_EN_FIELD_WIDTH,
    UNIMAC_RDP_COMMAND_CONFIG_FCS_CORRUPT_URUN_EN_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_COMMAND_CONFIG_SW_RESET
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_COMMAND_CONFIG_SW_RESET_FIELD =
{
    "SW_RESET",
#if RU_INCLUDE_DESC
    "",
    "Software Reset Command. When asserted, the TX and RX are \n"
    "disabled. Config registers are not affected by sw reset. Write a 0 to de-assert the sw reset.",
#endif
    UNIMAC_RDP_COMMAND_CONFIG_SW_RESET_FIELD_MASK,
    0,
    UNIMAC_RDP_COMMAND_CONFIG_SW_RESET_FIELD_WIDTH,
    UNIMAC_RDP_COMMAND_CONFIG_SW_RESET_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_COMMAND_CONFIG_OVERFLOW_EN
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_COMMAND_CONFIG_OVERFLOW_EN_FIELD =
{
    "OVERFLOW_EN",
#if RU_INCLUDE_DESC
    "",
    "If set, enables Rx FIFO overflow logic. In this case, the RXFIFO_STAT[1] register bit is not operational (always set to 0).\n"
    "If cleared, disables RX FIFO overflow logic. In this case, the RXFIFO_STAT[1] register bit is operational (Sticky set when overrun occurs, clearable only by SW_Reset).",
#endif
    UNIMAC_RDP_COMMAND_CONFIG_OVERFLOW_EN_FIELD_MASK,
    0,
    UNIMAC_RDP_COMMAND_CONFIG_OVERFLOW_EN_FIELD_WIDTH,
    UNIMAC_RDP_COMMAND_CONFIG_OVERFLOW_EN_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_COMMAND_CONFIG_RX_LOW_LATENCY_EN
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_COMMAND_CONFIG_RX_LOW_LATENCY_EN_FIELD =
{
    "RX_LOW_LATENCY_EN",
#if RU_INCLUDE_DESC
    "",
    "This works only when runt filter is disabled. It reduces the receive latency by 48 MAC clock time.",
#endif
    UNIMAC_RDP_COMMAND_CONFIG_RX_LOW_LATENCY_EN_FIELD_MASK,
    0,
    UNIMAC_RDP_COMMAND_CONFIG_RX_LOW_LATENCY_EN_FIELD_WIDTH,
    UNIMAC_RDP_COMMAND_CONFIG_RX_LOW_LATENCY_EN_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_COMMAND_CONFIG_HD_ENA
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_COMMAND_CONFIG_HD_ENA_FIELD =
{
    "HD_ENA",
#if RU_INCLUDE_DESC
    "",
    "Half duplex enable. When set to '1', enables half duplex mode, when set \n"
    "to '0', the MAC operates in full duplex mode.\n"
    "Ignored at ethernet speeds 1G/2.5G or when the register ENA_EXT_CONFIG is set to '1'.",
#endif
    UNIMAC_RDP_COMMAND_CONFIG_HD_ENA_FIELD_MASK,
    0,
    UNIMAC_RDP_COMMAND_CONFIG_HD_ENA_FIELD_WIDTH,
    UNIMAC_RDP_COMMAND_CONFIG_HD_ENA_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_COMMAND_CONFIG_TX_ADDR_INS
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_COMMAND_CONFIG_TX_ADDR_INS_FIELD =
{
    "TX_ADDR_INS",
#if RU_INCLUDE_DESC
    "",
    "Set MAC address on transmit. If enabled (Set to '1') the MAC overwrites \n"
    "the source MAC address with the programmed MAC address in registers MAC_0 \n"
    "and MAC_1. If disabled (Set to reset value '0'), the source MAC address \n"
    "received from the transmit application transmitted is not modified by the MAC.",
#endif
    UNIMAC_RDP_COMMAND_CONFIG_TX_ADDR_INS_FIELD_MASK,
    0,
    UNIMAC_RDP_COMMAND_CONFIG_TX_ADDR_INS_FIELD_WIDTH,
    UNIMAC_RDP_COMMAND_CONFIG_TX_ADDR_INS_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_COMMAND_CONFIG_PAUSE_IGNORE
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_COMMAND_CONFIG_PAUSE_IGNORE_FIELD =
{
    "PAUSE_IGNORE",
#if RU_INCLUDE_DESC
    "",
    "Ignore Pause Frame Quanta. If enabled (Set to '1') received pause frames \n"
    "are ignored by the MAC. When disabled (Set to reset value '0') the transmit \n"
    "process is stopped for the amount of time specified in the pause quanta \n"
    "received within the pause frame.",
#endif
    UNIMAC_RDP_COMMAND_CONFIG_PAUSE_IGNORE_FIELD_MASK,
    0,
    UNIMAC_RDP_COMMAND_CONFIG_PAUSE_IGNORE_FIELD_WIDTH,
    UNIMAC_RDP_COMMAND_CONFIG_PAUSE_IGNORE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_COMMAND_CONFIG_PAUSE_FWD
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_COMMAND_CONFIG_PAUSE_FWD_FIELD =
{
    "PAUSE_FWD",
#if RU_INCLUDE_DESC
    "",
    "Terminate/Forward Pause Frames. If enabled (Set to '1') pause frames are \n"
    "forwarded to the user application.  If disabled (Set to reset value '0'), \n"
    "pause frames are terminated and discarded in the MAC.",
#endif
    UNIMAC_RDP_COMMAND_CONFIG_PAUSE_FWD_FIELD_MASK,
    0,
    UNIMAC_RDP_COMMAND_CONFIG_PAUSE_FWD_FIELD_WIDTH,
    UNIMAC_RDP_COMMAND_CONFIG_PAUSE_FWD_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_COMMAND_CONFIG_CRC_FWD
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_COMMAND_CONFIG_CRC_FWD_FIELD =
{
    "CRC_FWD",
#if RU_INCLUDE_DESC
    "",
    "Terminate/Forward Received CRC. If enabled (1) the CRC field of received \n"
    "frames are transmitted to the user application.\n"
    "If disabled (Set to reset value '0') the CRC field is stripped from the frame.\n"
    "Note: If padding function (bit PAD_EN set to '1') is enabled. CRC_FWD is \n"
    "ignored and the CRC field is checked and always terminated and removed.",
#endif
    UNIMAC_RDP_COMMAND_CONFIG_CRC_FWD_FIELD_MASK,
    0,
    UNIMAC_RDP_COMMAND_CONFIG_CRC_FWD_FIELD_WIDTH,
    UNIMAC_RDP_COMMAND_CONFIG_CRC_FWD_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_COMMAND_CONFIG_PAD_EN
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_COMMAND_CONFIG_PAD_EN_FIELD =
{
    "PAD_EN",
#if RU_INCLUDE_DESC
    "",
    "Enable/Disable Frame Padding. If enabled (Set to '1'), then padding is removed from the received frame before it is transmitted to the user\n"
    "application. If disabled (set to reset value '0'), then no padding is removed on receive by the MAC. \n"
    "This bit has no effect on Tx padding and hence Transmit always pad runts to guarantee a minimum frame size of 64 octets.",
#endif
    UNIMAC_RDP_COMMAND_CONFIG_PAD_EN_FIELD_MASK,
    0,
    UNIMAC_RDP_COMMAND_CONFIG_PAD_EN_FIELD_WIDTH,
    UNIMAC_RDP_COMMAND_CONFIG_PAD_EN_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_COMMAND_CONFIG_PROMIS_EN
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_COMMAND_CONFIG_PROMIS_EN_FIELD =
{
    "PROMIS_EN",
#if RU_INCLUDE_DESC
    "",
    "Enable/Disable MAC promiscuous operation. When asserted (Set to '1'), \n"
    "all frames are received without Unicast address filtering.",
#endif
    UNIMAC_RDP_COMMAND_CONFIG_PROMIS_EN_FIELD_MASK,
    0,
    UNIMAC_RDP_COMMAND_CONFIG_PROMIS_EN_FIELD_WIDTH,
    UNIMAC_RDP_COMMAND_CONFIG_PROMIS_EN_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_COMMAND_CONFIG_ETH_SPEED
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_COMMAND_CONFIG_ETH_SPEED_FIELD =
{
    "ETH_SPEED",
#if RU_INCLUDE_DESC
    "",
    "Set MAC speed. Bit 1:0 for ETH_SPEED[2:0]. Bit 2 is in ETH_SPEED_BIT2. Ignored when the register bit ENA_EXT_CONFIG is set to '1'.  When the Register bit ENA_EXT_CONFIG is set to '0', used to set the core mode of operation: 000: Enable 10Mbps Ethernet mode 001: Enable 100Mbps Ethernet mode 010: Enable Gigabit Ethernet mode 011: Enable 2.5Gigabit Ethernet mode 101: Enable 5Gigabit Ethernet mode 100 Enable 10Gigabit Ethernet mode",
#endif
    UNIMAC_RDP_COMMAND_CONFIG_ETH_SPEED_FIELD_MASK,
    0,
    UNIMAC_RDP_COMMAND_CONFIG_ETH_SPEED_FIELD_WIDTH,
    UNIMAC_RDP_COMMAND_CONFIG_ETH_SPEED_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_COMMAND_CONFIG_RX_ENA
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_COMMAND_CONFIG_RX_ENA_FIELD =
{
    "RX_ENA",
#if RU_INCLUDE_DESC
    "",
    "Enable/Disable MAC receive path. When set to '0' (Reset value), the MAC \n"
    "receive function is disable.  When set to '1', the MAC receive function is enabled.",
#endif
    UNIMAC_RDP_COMMAND_CONFIG_RX_ENA_FIELD_MASK,
    0,
    UNIMAC_RDP_COMMAND_CONFIG_RX_ENA_FIELD_WIDTH,
    UNIMAC_RDP_COMMAND_CONFIG_RX_ENA_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_COMMAND_CONFIG_TX_ENA
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_COMMAND_CONFIG_TX_ENA_FIELD =
{
    "TX_ENA",
#if RU_INCLUDE_DESC
    "",
    "Enable/Disable MAC transmit path for data packets & pause/pfc packets sent in the normal data path.\n"
    "Pause/pfc packets generated internally are allowed if ignore_tx_pause is not set. When set to '0' (Reset value), the MAC \n"
    "transmit function is disable.  When set to '1', the MAC transmit function is enabled.",
#endif
    UNIMAC_RDP_COMMAND_CONFIG_TX_ENA_FIELD_MASK,
    0,
    UNIMAC_RDP_COMMAND_CONFIG_TX_ENA_FIELD_WIDTH,
    UNIMAC_RDP_COMMAND_CONFIG_TX_ENA_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_MAC_0_MAC_ADDR0
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_MAC_0_MAC_ADDR0_FIELD =
{
    "MAC_ADDR0",
#if RU_INCLUDE_DESC
    "",
    "Register bit 0 corresponds to bit 16 of the MAC address, register bit 1 corresponds to bit 17 of the MAC address, and so on.",
#endif
    UNIMAC_RDP_MAC_0_MAC_ADDR0_FIELD_MASK,
    0,
    UNIMAC_RDP_MAC_0_MAC_ADDR0_FIELD_WIDTH,
    UNIMAC_RDP_MAC_0_MAC_ADDR0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_MAC_1_RESERVED0
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_MAC_1_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    UNIMAC_RDP_MAC_1_RESERVED0_FIELD_MASK,
    0,
    UNIMAC_RDP_MAC_1_RESERVED0_FIELD_WIDTH,
    UNIMAC_RDP_MAC_1_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_MAC_1_MAC_ADDR1
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_MAC_1_MAC_ADDR1_FIELD =
{
    "MAC_ADDR1",
#if RU_INCLUDE_DESC
    "",
    "Register bit 0 corresponds to bit 0 of the MAC address, register bit 1 corresponds to bit 1 of the MAC address, and so on.\n"
    "Bits 16 to 31 are reserved.",
#endif
    UNIMAC_RDP_MAC_1_MAC_ADDR1_FIELD_MASK,
    0,
    UNIMAC_RDP_MAC_1_MAC_ADDR1_FIELD_WIDTH,
    UNIMAC_RDP_MAC_1_MAC_ADDR1_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_FRM_LENGTH_RESERVED0
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_FRM_LENGTH_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    UNIMAC_RDP_FRM_LENGTH_RESERVED0_FIELD_MASK,
    0,
    UNIMAC_RDP_FRM_LENGTH_RESERVED0_FIELD_WIDTH,
    UNIMAC_RDP_FRM_LENGTH_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_FRM_LENGTH_MAXFR
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_FRM_LENGTH_MAXFR_FIELD =
{
    "MAXFR",
#if RU_INCLUDE_DESC
    "",
    "Defines a 14-bit maximum frame length used by the MAC receive logic to check frames.",
#endif
    UNIMAC_RDP_FRM_LENGTH_MAXFR_FIELD_MASK,
    0,
    UNIMAC_RDP_FRM_LENGTH_MAXFR_FIELD_WIDTH,
    UNIMAC_RDP_FRM_LENGTH_MAXFR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_PAUSE_QUANT_RESERVED0
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_PAUSE_QUANT_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    UNIMAC_RDP_PAUSE_QUANT_RESERVED0_FIELD_MASK,
    0,
    UNIMAC_RDP_PAUSE_QUANT_RESERVED0_FIELD_WIDTH,
    UNIMAC_RDP_PAUSE_QUANT_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_PAUSE_QUANT_PAUSE_QUANT
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_PAUSE_QUANT_PAUSE_QUANT_FIELD =
{
    "PAUSE_QUANT",
#if RU_INCLUDE_DESC
    "",
    "16-bit value, sets, in increments of 512 Ethernet bit times, the pause quanta used in \n"
    "each Pause Frame sent to the remote Ethernet device.",
#endif
    UNIMAC_RDP_PAUSE_QUANT_PAUSE_QUANT_FIELD_MASK,
    0,
    UNIMAC_RDP_PAUSE_QUANT_PAUSE_QUANT_FIELD_WIDTH,
    UNIMAC_RDP_PAUSE_QUANT_PAUSE_QUANT_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_TX_TS_SEQ_ID_RESERVED0
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_TX_TS_SEQ_ID_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    UNIMAC_RDP_TX_TS_SEQ_ID_RESERVED0_FIELD_MASK,
    0,
    UNIMAC_RDP_TX_TS_SEQ_ID_RESERVED0_FIELD_WIDTH,
    UNIMAC_RDP_TX_TS_SEQ_ID_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_TX_TS_SEQ_ID_TSTS_VALID
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_TX_TS_SEQ_ID_TSTS_VALID_FIELD =
{
    "TSTS_VALID",
#if RU_INCLUDE_DESC
    "",
    "Indicates that a timestamp was captured and is valid. if the cpu reads an empty fifo the VALID bit will be 0.",
#endif
    UNIMAC_RDP_TX_TS_SEQ_ID_TSTS_VALID_FIELD_MASK,
    0,
    UNIMAC_RDP_TX_TS_SEQ_ID_TSTS_VALID_FIELD_WIDTH,
    UNIMAC_RDP_TX_TS_SEQ_ID_TSTS_VALID_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_TX_TS_SEQ_ID_TSTS_SEQ_ID
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_TX_TS_SEQ_ID_TSTS_SEQ_ID_FIELD =
{
    "TSTS_SEQ_ID",
#if RU_INCLUDE_DESC
    "",
    "Every read of this register will fetch out one seq_id from the transmit FIFO.(One seq_id per one read command on the sbus).\n"
    "Every 49 bit val_bit + seq_id + timestamp is read in two steps, i.e., one read from 0x10f (val_bit + seq_id) followed by another read from 0x1c7 (timestamp).\n"
    "Timestamp read without a preceding seq_id read will fetch stale timestamp value.",
#endif
    UNIMAC_RDP_TX_TS_SEQ_ID_TSTS_SEQ_ID_FIELD_MASK,
    0,
    UNIMAC_RDP_TX_TS_SEQ_ID_TSTS_SEQ_ID_FIELD_WIDTH,
    UNIMAC_RDP_TX_TS_SEQ_ID_TSTS_SEQ_ID_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_SFD_OFFSET_RESERVED0
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_SFD_OFFSET_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    UNIMAC_RDP_SFD_OFFSET_RESERVED0_FIELD_MASK,
    0,
    UNIMAC_RDP_SFD_OFFSET_RESERVED0_FIELD_WIDTH,
    UNIMAC_RDP_SFD_OFFSET_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_SFD_OFFSET_SFD_OFFSET
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_SFD_OFFSET_SFD_OFFSET_FIELD =
{
    "SFD_OFFSET",
#if RU_INCLUDE_DESC
    "",
    "Defines the length of the EFM preamble between 5 and 15 Bytes. When set to 0, 1, 2, 3 or 4,\n"
    "the Preamble EFM length is set to 5 Bytes.",
#endif
    UNIMAC_RDP_SFD_OFFSET_SFD_OFFSET_FIELD_MASK,
    0,
    UNIMAC_RDP_SFD_OFFSET_SFD_OFFSET_FIELD_WIDTH,
    UNIMAC_RDP_SFD_OFFSET_SFD_OFFSET_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_MAC_MODE_RESERVED0
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_MAC_MODE_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    UNIMAC_RDP_MAC_MODE_RESERVED0_FIELD_MASK,
    0,
    UNIMAC_RDP_MAC_MODE_RESERVED0_FIELD_WIDTH,
    UNIMAC_RDP_MAC_MODE_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_MAC_MODE_MAC_SPEED_BIT2
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_MAC_MODE_MAC_SPEED_BIT2_FIELD =
{
    "MAC_SPEED_BIT2",
#if RU_INCLUDE_DESC
    "",
    "Bit 2 of MAC_SPEED[2:0]",
#endif
    UNIMAC_RDP_MAC_MODE_MAC_SPEED_BIT2_FIELD_MASK,
    0,
    UNIMAC_RDP_MAC_MODE_MAC_SPEED_BIT2_FIELD_WIDTH,
    UNIMAC_RDP_MAC_MODE_MAC_SPEED_BIT2_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_MAC_MODE_LINK_STATUS
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_MAC_MODE_LINK_STATUS_FIELD =
{
    "LINK_STATUS",
#if RU_INCLUDE_DESC
    "",
    "Link Status Indication. Set to '0', when link_status input is low.\n"
    "Set to '1', when link_status input is High.",
#endif
    UNIMAC_RDP_MAC_MODE_LINK_STATUS_FIELD_MASK,
    0,
    UNIMAC_RDP_MAC_MODE_LINK_STATUS_FIELD_WIDTH,
    UNIMAC_RDP_MAC_MODE_LINK_STATUS_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_MAC_MODE_MAC_TX_PAUSE
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_MAC_MODE_MAC_TX_PAUSE_FIELD =
{
    "MAC_TX_PAUSE",
#if RU_INCLUDE_DESC
    "",
    "MAC Pause Enabled in Transmit. \n"
    "0: MAC Pause Disabled in Transmit\n"
    "1: MAC Pause Enabled in Transmit",
#endif
    UNIMAC_RDP_MAC_MODE_MAC_TX_PAUSE_FIELD_MASK,
    0,
    UNIMAC_RDP_MAC_MODE_MAC_TX_PAUSE_FIELD_WIDTH,
    UNIMAC_RDP_MAC_MODE_MAC_TX_PAUSE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_MAC_MODE_MAC_RX_PAUSE
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_MAC_MODE_MAC_RX_PAUSE_FIELD =
{
    "MAC_RX_PAUSE",
#if RU_INCLUDE_DESC
    "",
    "MAC Pause Enabled in Receive. \n"
    "0: MAC Pause Disabled in Receive\n"
    "1: MAC Pause Enabled in Receive",
#endif
    UNIMAC_RDP_MAC_MODE_MAC_RX_PAUSE_FIELD_MASK,
    0,
    UNIMAC_RDP_MAC_MODE_MAC_RX_PAUSE_FIELD_WIDTH,
    UNIMAC_RDP_MAC_MODE_MAC_RX_PAUSE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_MAC_MODE_MAC_DUPLEX
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_MAC_MODE_MAC_DUPLEX_FIELD =
{
    "MAC_DUPLEX",
#if RU_INCLUDE_DESC
    "",
    "MAC Duplex. \n"
    "0: Full Duplex Mode enabled\n"
    "1: Half Duplex Mode enabled",
#endif
    UNIMAC_RDP_MAC_MODE_MAC_DUPLEX_FIELD_MASK,
    0,
    UNIMAC_RDP_MAC_MODE_MAC_DUPLEX_FIELD_WIDTH,
    UNIMAC_RDP_MAC_MODE_MAC_DUPLEX_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_MAC_MODE_MAC_SPEED
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_MAC_MODE_MAC_SPEED_FIELD =
{
    "MAC_SPEED",
#if RU_INCLUDE_DESC
    "",
    "MAC Speed[2:0]. Bit 2 is in MAC_SPEED_BIT2.\n"
    "000: 10Mbps Ethernet Mode enabled\n"
    "001: 100Mbps Ethernet Mode enabled\n"
    "010: Gigabit Ethernet Mode enabled\n"
    "011: 2.5Gigabit Ethernet Mode enabled\n"
    "101: 5Gigabit Ethernet Mode enabled\n"
    "100: 10Gigabit Ethernet Mode enabled",
#endif
    UNIMAC_RDP_MAC_MODE_MAC_SPEED_FIELD_MASK,
    0,
    UNIMAC_RDP_MAC_MODE_MAC_SPEED_FIELD_WIDTH,
    UNIMAC_RDP_MAC_MODE_MAC_SPEED_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_TAG_0_RESERVED0
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_TAG_0_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    UNIMAC_RDP_TAG_0_RESERVED0_FIELD_MASK,
    0,
    UNIMAC_RDP_TAG_0_RESERVED0_FIELD_WIDTH,
    UNIMAC_RDP_TAG_0_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_TAG_0_CONFIG_OUTER_TPID_ENABLE
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_TAG_0_CONFIG_OUTER_TPID_ENABLE_FIELD =
{
    "CONFIG_OUTER_TPID_ENABLE",
#if RU_INCLUDE_DESC
    "",
    "If cleared then disable outer TPID detection",
#endif
    UNIMAC_RDP_TAG_0_CONFIG_OUTER_TPID_ENABLE_FIELD_MASK,
    0,
    UNIMAC_RDP_TAG_0_CONFIG_OUTER_TPID_ENABLE_FIELD_WIDTH,
    UNIMAC_RDP_TAG_0_CONFIG_OUTER_TPID_ENABLE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_TAG_0_FRM_TAG_0
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_TAG_0_FRM_TAG_0_FIELD =
{
    "FRM_TAG_0",
#if RU_INCLUDE_DESC
    "",
    "Outer tag of the programmable VLAN tag",
#endif
    UNIMAC_RDP_TAG_0_FRM_TAG_0_FIELD_MASK,
    0,
    UNIMAC_RDP_TAG_0_FRM_TAG_0_FIELD_WIDTH,
    UNIMAC_RDP_TAG_0_FRM_TAG_0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_TAG_1_RESERVED0
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_TAG_1_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    UNIMAC_RDP_TAG_1_RESERVED0_FIELD_MASK,
    0,
    UNIMAC_RDP_TAG_1_RESERVED0_FIELD_WIDTH,
    UNIMAC_RDP_TAG_1_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_TAG_1_CONFIG_INNER_TPID_ENABLE
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_TAG_1_CONFIG_INNER_TPID_ENABLE_FIELD =
{
    "CONFIG_INNER_TPID_ENABLE",
#if RU_INCLUDE_DESC
    "",
    "If cleared then disable inner TPID detection",
#endif
    UNIMAC_RDP_TAG_1_CONFIG_INNER_TPID_ENABLE_FIELD_MASK,
    0,
    UNIMAC_RDP_TAG_1_CONFIG_INNER_TPID_ENABLE_FIELD_WIDTH,
    UNIMAC_RDP_TAG_1_CONFIG_INNER_TPID_ENABLE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_TAG_1_FRM_TAG_1
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_TAG_1_FRM_TAG_1_FIELD =
{
    "FRM_TAG_1",
#if RU_INCLUDE_DESC
    "",
    "inner tag of the programmable VLAN tag",
#endif
    UNIMAC_RDP_TAG_1_FRM_TAG_1_FIELD_MASK,
    0,
    UNIMAC_RDP_TAG_1_FRM_TAG_1_FIELD_WIDTH,
    UNIMAC_RDP_TAG_1_FRM_TAG_1_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_RX_PAUSE_QUANTA_SCALE_RESERVED0
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_RX_PAUSE_QUANTA_SCALE_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    UNIMAC_RDP_RX_PAUSE_QUANTA_SCALE_RESERVED0_FIELD_MASK,
    0,
    UNIMAC_RDP_RX_PAUSE_QUANTA_SCALE_RESERVED0_FIELD_WIDTH,
    UNIMAC_RDP_RX_PAUSE_QUANTA_SCALE_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_RX_PAUSE_QUANTA_SCALE_SCALE_FIX
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_RX_PAUSE_QUANTA_SCALE_SCALE_FIX_FIELD =
{
    "SCALE_FIX",
#if RU_INCLUDE_DESC
    "",
    "If set, then receive pause quanta is ignored and a fixed quanta value programmed in SCALE_VALUE is loaded into the pause timer.\n"
    "If set, then SCALE_CONTROL is ignored.\n"
    "If cleared, then SCALE_CONTROL takes into effect.",
#endif
    UNIMAC_RDP_RX_PAUSE_QUANTA_SCALE_SCALE_FIX_FIELD_MASK,
    0,
    UNIMAC_RDP_RX_PAUSE_QUANTA_SCALE_SCALE_FIX_FIELD_WIDTH,
    UNIMAC_RDP_RX_PAUSE_QUANTA_SCALE_SCALE_FIX_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_RX_PAUSE_QUANTA_SCALE_SCALE_CONTROL
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_RX_PAUSE_QUANTA_SCALE_SCALE_CONTROL_FIELD =
{
    "SCALE_CONTROL",
#if RU_INCLUDE_DESC
    "",
    "If clear, then subtract the scale_value from the received pause quanta. \n"
    "If set, then add the scale_value from the received pause quanta.",
#endif
    UNIMAC_RDP_RX_PAUSE_QUANTA_SCALE_SCALE_CONTROL_FIELD_MASK,
    0,
    UNIMAC_RDP_RX_PAUSE_QUANTA_SCALE_SCALE_CONTROL_FIELD_WIDTH,
    UNIMAC_RDP_RX_PAUSE_QUANTA_SCALE_SCALE_CONTROL_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_RX_PAUSE_QUANTA_SCALE_SCALE_VALUE
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_RX_PAUSE_QUANTA_SCALE_SCALE_VALUE_FIELD =
{
    "SCALE_VALUE",
#if RU_INCLUDE_DESC
    "",
    "The pause timer is loaded with the value obtained after adding or subtracting the scale_value from the received pause quanta.",
#endif
    UNIMAC_RDP_RX_PAUSE_QUANTA_SCALE_SCALE_VALUE_FIELD_MASK,
    0,
    UNIMAC_RDP_RX_PAUSE_QUANTA_SCALE_SCALE_VALUE_FIELD_WIDTH,
    UNIMAC_RDP_RX_PAUSE_QUANTA_SCALE_SCALE_VALUE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_TX_PREAMBLE_RESERVED0
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_TX_PREAMBLE_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    UNIMAC_RDP_TX_PREAMBLE_RESERVED0_FIELD_MASK,
    0,
    UNIMAC_RDP_TX_PREAMBLE_RESERVED0_FIELD_WIDTH,
    UNIMAC_RDP_TX_PREAMBLE_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_TX_PREAMBLE_TX_PREAMBLE
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_TX_PREAMBLE_TX_PREAMBLE_FIELD =
{
    "TX_PREAMBLE",
#if RU_INCLUDE_DESC
    "",
    "Set the transmit preamble excluding SFD to be programmable from min of 2 bytes to the max allowable of 7 bytes, with granularity of 1 byte.",
#endif
    UNIMAC_RDP_TX_PREAMBLE_TX_PREAMBLE_FIELD_MASK,
    0,
    UNIMAC_RDP_TX_PREAMBLE_TX_PREAMBLE_FIELD_WIDTH,
    UNIMAC_RDP_TX_PREAMBLE_TX_PREAMBLE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_TX_IPG_LENGTH_RESERVED0
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_TX_IPG_LENGTH_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    UNIMAC_RDP_TX_IPG_LENGTH_RESERVED0_FIELD_MASK,
    0,
    UNIMAC_RDP_TX_IPG_LENGTH_RESERVED0_FIELD_WIDTH,
    UNIMAC_RDP_TX_IPG_LENGTH_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_TX_IPG_LENGTH_TX_MIN_PKT_SIZE
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_TX_IPG_LENGTH_TX_MIN_PKT_SIZE_FIELD =
{
    "TX_MIN_PKT_SIZE",
#if RU_INCLUDE_DESC
    "",
    "Min. TX packet size without FCS, also without preamble+SFD.\n"
    "Padding will be appended if needed to ensure this size.\n"
    "Valid values are: 14..125",
#endif
    UNIMAC_RDP_TX_IPG_LENGTH_TX_MIN_PKT_SIZE_FIELD_MASK,
    0,
    UNIMAC_RDP_TX_IPG_LENGTH_TX_MIN_PKT_SIZE_FIELD_WIDTH,
    UNIMAC_RDP_TX_IPG_LENGTH_TX_MIN_PKT_SIZE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_TX_IPG_LENGTH_RESERVED1
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_TX_IPG_LENGTH_RESERVED1_FIELD =
{
    "RESERVED1",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    UNIMAC_RDP_TX_IPG_LENGTH_RESERVED1_FIELD_MASK,
    0,
    UNIMAC_RDP_TX_IPG_LENGTH_RESERVED1_FIELD_WIDTH,
    UNIMAC_RDP_TX_IPG_LENGTH_RESERVED1_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_TX_IPG_LENGTH_TX_IPG_LENGTH
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_TX_IPG_LENGTH_TX_IPG_LENGTH_FIELD =
{
    "TX_IPG_LENGTH",
#if RU_INCLUDE_DESC
    "",
    "Set the Transmit minimum IPG from 8 to 64 Byte-times. If a value below 8 or above 64 is\n"
    "programmed, the minimum IPG is set to 12 byte-times.",
#endif
    UNIMAC_RDP_TX_IPG_LENGTH_TX_IPG_LENGTH_FIELD_MASK,
    0,
    UNIMAC_RDP_TX_IPG_LENGTH_TX_IPG_LENGTH_FIELD_WIDTH,
    UNIMAC_RDP_TX_IPG_LENGTH_TX_IPG_LENGTH_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_PFC_XOFF_TIMER_RESERVED0
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_PFC_XOFF_TIMER_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    UNIMAC_RDP_PFC_XOFF_TIMER_RESERVED0_FIELD_MASK,
    0,
    UNIMAC_RDP_PFC_XOFF_TIMER_RESERVED0_FIELD_WIDTH,
    UNIMAC_RDP_PFC_XOFF_TIMER_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_PFC_XOFF_TIMER_PFC_XOFF_TIMER
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_PFC_XOFF_TIMER_PFC_XOFF_TIMER_FIELD =
{
    "PFC_XOFF_TIMER",
#if RU_INCLUDE_DESC
    "",
    "Time value sent in the Timer Field for classes in XOFF state (Unit is 512 bit-times).",
#endif
    UNIMAC_RDP_PFC_XOFF_TIMER_PFC_XOFF_TIMER_FIELD_MASK,
    0,
    UNIMAC_RDP_PFC_XOFF_TIMER_PFC_XOFF_TIMER_FIELD_WIDTH,
    UNIMAC_RDP_PFC_XOFF_TIMER_PFC_XOFF_TIMER_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_UMAC_EEE_CTRL_RESERVED0
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_UMAC_EEE_CTRL_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    UNIMAC_RDP_UMAC_EEE_CTRL_RESERVED0_FIELD_MASK,
    0,
    UNIMAC_RDP_UMAC_EEE_CTRL_RESERVED0_FIELD_WIDTH,
    UNIMAC_RDP_UMAC_EEE_CTRL_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_UMAC_EEE_CTRL_LP_IDLE_PREDICTION_MODE
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_UMAC_EEE_CTRL_LP_IDLE_PREDICTION_MODE_FIELD =
{
    "LP_IDLE_PREDICTION_MODE",
#if RU_INCLUDE_DESC
    "",
    "When set to 1, enables LP_IDLE Prediction. When set to 0, disables LP_IDLE Prediction.\n"
    "It is an experimental feature and not recommended to use for the production SW.",
#endif
    UNIMAC_RDP_UMAC_EEE_CTRL_LP_IDLE_PREDICTION_MODE_FIELD_MASK,
    0,
    UNIMAC_RDP_UMAC_EEE_CTRL_LP_IDLE_PREDICTION_MODE_FIELD_WIDTH,
    UNIMAC_RDP_UMAC_EEE_CTRL_LP_IDLE_PREDICTION_MODE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_UMAC_EEE_CTRL_DIS_EEE_10M
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_UMAC_EEE_CTRL_DIS_EEE_10M_FIELD =
{
    "DIS_EEE_10M",
#if RU_INCLUDE_DESC
    "",
    "When this bit is set and link is established at 10Mbps, LPI is not supported (saving is achieved by reduced PHY's output swing). UNIMAC ignores EEE feature on both Tx & Rx in 10Mbps.\n"
    "When cleared, Unimac doesn't differentiate between speeds for EEE feature.",
#endif
    UNIMAC_RDP_UMAC_EEE_CTRL_DIS_EEE_10M_FIELD_MASK,
    0,
    UNIMAC_RDP_UMAC_EEE_CTRL_DIS_EEE_10M_FIELD_WIDTH,
    UNIMAC_RDP_UMAC_EEE_CTRL_DIS_EEE_10M_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_UMAC_EEE_CTRL_EEE_TXCLK_DIS
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_UMAC_EEE_CTRL_EEE_TXCLK_DIS_FIELD =
{
    "EEE_TXCLK_DIS",
#if RU_INCLUDE_DESC
    "",
    "If enabled, UNIMAC will shut down TXCLK to PHY, when in LPI state.",
#endif
    UNIMAC_RDP_UMAC_EEE_CTRL_EEE_TXCLK_DIS_FIELD_MASK,
    0,
    UNIMAC_RDP_UMAC_EEE_CTRL_EEE_TXCLK_DIS_FIELD_WIDTH,
    UNIMAC_RDP_UMAC_EEE_CTRL_EEE_TXCLK_DIS_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_UMAC_EEE_CTRL_RX_FIFO_CHECK
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_UMAC_EEE_CTRL_RX_FIFO_CHECK_FIELD =
{
    "RX_FIFO_CHECK",
#if RU_INCLUDE_DESC
    "",
    "If enabled, lpi_rx_detect is set whenever the LPI_IDLES are being received on the RX line and Unimac Rx FIFO is empty.\n"
    "By default, lpi_rx_detect is set only when whenever the LPI_IDLES are being received on the RX line.",
#endif
    UNIMAC_RDP_UMAC_EEE_CTRL_RX_FIFO_CHECK_FIELD_MASK,
    0,
    UNIMAC_RDP_UMAC_EEE_CTRL_RX_FIFO_CHECK_FIELD_WIDTH,
    UNIMAC_RDP_UMAC_EEE_CTRL_RX_FIFO_CHECK_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_UMAC_EEE_CTRL_EEE_EN
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_UMAC_EEE_CTRL_EEE_EN_FIELD =
{
    "EEE_EN",
#if RU_INCLUDE_DESC
    "",
    "If set, the TX LPI policy control engine is enabled and the MAC inserts LPI_idle codes if the link is idle. The rx_lpi_detect assertion is independent of this configuration. Reset default depends on EEE_en_strap input, which if tied to 1, defaults to enabled, otherwise if tied to 0, defaults to disabled.",
#endif
    UNIMAC_RDP_UMAC_EEE_CTRL_EEE_EN_FIELD_MASK,
    0,
    UNIMAC_RDP_UMAC_EEE_CTRL_EEE_EN_FIELD_WIDTH,
    UNIMAC_RDP_UMAC_EEE_CTRL_EEE_EN_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_UMAC_EEE_CTRL_RESERVED1
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_UMAC_EEE_CTRL_RESERVED1_FIELD =
{
    "RESERVED1",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    UNIMAC_RDP_UMAC_EEE_CTRL_RESERVED1_FIELD_MASK,
    0,
    UNIMAC_RDP_UMAC_EEE_CTRL_RESERVED1_FIELD_WIDTH,
    UNIMAC_RDP_UMAC_EEE_CTRL_RESERVED1_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_MII_EEE_DELAY_ENTRY_TIMER_MII_EEE_LPI_TIMER
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_MII_EEE_DELAY_ENTRY_TIMER_MII_EEE_LPI_TIMER_FIELD =
{
    "MII_EEE_LPI_TIMER",
#if RU_INCLUDE_DESC
    "",
    "This is the duration for which condition to move to LPI state must be satisfied, at the end of which MAC transitions to LPI State. The decrement unit is 1 micro-second.\n"
    "This register is meant for 10/100 Mbps speed.",
#endif
    UNIMAC_RDP_MII_EEE_DELAY_ENTRY_TIMER_MII_EEE_LPI_TIMER_FIELD_MASK,
    0,
    UNIMAC_RDP_MII_EEE_DELAY_ENTRY_TIMER_MII_EEE_LPI_TIMER_FIELD_WIDTH,
    UNIMAC_RDP_MII_EEE_DELAY_ENTRY_TIMER_MII_EEE_LPI_TIMER_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_GMII_EEE_DELAY_ENTRY_TIMER_GMII_EEE_LPI_TIMER
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_GMII_EEE_DELAY_ENTRY_TIMER_GMII_EEE_LPI_TIMER_FIELD =
{
    "GMII_EEE_LPI_TIMER",
#if RU_INCLUDE_DESC
    "",
    "This is the duration for which condition to move to LPI state must be satisfied, at the end of which MAC transitions to LPI State. The decrement unit is 1 micro-second.\n"
    "This register is meant for 1000 Mbps speed.",
#endif
    UNIMAC_RDP_GMII_EEE_DELAY_ENTRY_TIMER_GMII_EEE_LPI_TIMER_FIELD_MASK,
    0,
    UNIMAC_RDP_GMII_EEE_DELAY_ENTRY_TIMER_GMII_EEE_LPI_TIMER_FIELD_WIDTH,
    UNIMAC_RDP_GMII_EEE_DELAY_ENTRY_TIMER_GMII_EEE_LPI_TIMER_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_UMAC_EEE_REF_COUNT_RESERVED0
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_UMAC_EEE_REF_COUNT_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    UNIMAC_RDP_UMAC_EEE_REF_COUNT_RESERVED0_FIELD_MASK,
    0,
    UNIMAC_RDP_UMAC_EEE_REF_COUNT_RESERVED0_FIELD_WIDTH,
    UNIMAC_RDP_UMAC_EEE_REF_COUNT_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_UMAC_EEE_REF_COUNT_EEE_REF_COUNT
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_UMAC_EEE_REF_COUNT_EEE_REF_COUNT_FIELD =
{
    "EEE_REF_COUNT",
#if RU_INCLUDE_DESC
    "",
    "This field controls clock divider used to generate ~1us reference pulses used by EEE timers. It specifies integer number of timer clock cycles contained within 1us.",
#endif
    UNIMAC_RDP_UMAC_EEE_REF_COUNT_EEE_REF_COUNT_FIELD_MASK,
    0,
    UNIMAC_RDP_UMAC_EEE_REF_COUNT_EEE_REF_COUNT_FIELD_WIDTH,
    UNIMAC_RDP_UMAC_EEE_REF_COUNT_EEE_REF_COUNT_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_UMAC_TIMESTAMP_ADJUST_RESERVED0
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_UMAC_TIMESTAMP_ADJUST_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    UNIMAC_RDP_UMAC_TIMESTAMP_ADJUST_RESERVED0_FIELD_MASK,
    0,
    UNIMAC_RDP_UMAC_TIMESTAMP_ADJUST_RESERVED0_FIELD_WIDTH,
    UNIMAC_RDP_UMAC_TIMESTAMP_ADJUST_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_UMAC_TIMESTAMP_ADJUST_AUTO_ADJUST
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_UMAC_TIMESTAMP_ADJUST_AUTO_ADJUST_FIELD =
{
    "AUTO_ADJUST",
#if RU_INCLUDE_DESC
    "",
    "Enables MAC Rx timestamp offset balancing at MAC TX timestamp.",
#endif
    UNIMAC_RDP_UMAC_TIMESTAMP_ADJUST_AUTO_ADJUST_FIELD_MASK,
    0,
    UNIMAC_RDP_UMAC_TIMESTAMP_ADJUST_AUTO_ADJUST_FIELD_WIDTH,
    UNIMAC_RDP_UMAC_TIMESTAMP_ADJUST_AUTO_ADJUST_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_UMAC_TIMESTAMP_ADJUST_EN_1588
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_UMAC_TIMESTAMP_ADJUST_EN_1588_FIELD =
{
    "EN_1588",
#if RU_INCLUDE_DESC
    "",
    "Enables 1588 one step timestamp feature.",
#endif
    UNIMAC_RDP_UMAC_TIMESTAMP_ADJUST_EN_1588_FIELD_MASK,
    0,
    UNIMAC_RDP_UMAC_TIMESTAMP_ADJUST_EN_1588_FIELD_WIDTH,
    UNIMAC_RDP_UMAC_TIMESTAMP_ADJUST_EN_1588_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_UMAC_TIMESTAMP_ADJUST_ADJUST
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_UMAC_TIMESTAMP_ADJUST_ADJUST_FIELD =
{
    "ADJUST",
#if RU_INCLUDE_DESC
    "",
    "Offset adjustment to outgoing TIMESTAMP to adjust for pipeline stalling and/or jitter asymmetry. The value is in 2's compliment format and is of 1ns granularity.",
#endif
    UNIMAC_RDP_UMAC_TIMESTAMP_ADJUST_ADJUST_FIELD_MASK,
    0,
    UNIMAC_RDP_UMAC_TIMESTAMP_ADJUST_ADJUST_FIELD_WIDTH,
    UNIMAC_RDP_UMAC_TIMESTAMP_ADJUST_ADJUST_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_UMAC_RX_PKT_DROP_STATUS_RESERVED0
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_UMAC_RX_PKT_DROP_STATUS_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    UNIMAC_RDP_UMAC_RX_PKT_DROP_STATUS_RESERVED0_FIELD_MASK,
    0,
    UNIMAC_RDP_UMAC_RX_PKT_DROP_STATUS_RESERVED0_FIELD_WIDTH,
    UNIMAC_RDP_UMAC_RX_PKT_DROP_STATUS_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_UMAC_RX_PKT_DROP_STATUS_RX_IPG_INVAL
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_UMAC_RX_PKT_DROP_STATUS_RX_IPG_INVAL_FIELD =
{
    "RX_IPG_INVAL",
#if RU_INCLUDE_DESC
    "",
    "Debug status, set if MAC receives an IPG less than programmed RX IPG or less than four bytes. Sticky bit. Clears when SW writes 0 into the field or by sw_reset.",
#endif
    UNIMAC_RDP_UMAC_RX_PKT_DROP_STATUS_RX_IPG_INVAL_FIELD_MASK,
    0,
    UNIMAC_RDP_UMAC_RX_PKT_DROP_STATUS_RX_IPG_INVAL_FIELD_WIDTH,
    UNIMAC_RDP_UMAC_RX_PKT_DROP_STATUS_RX_IPG_INVAL_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_UMAC_SYMMETRIC_IDLE_THRESHOLD_RESERVED0
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_UMAC_SYMMETRIC_IDLE_THRESHOLD_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    UNIMAC_RDP_UMAC_SYMMETRIC_IDLE_THRESHOLD_RESERVED0_FIELD_MASK,
    0,
    UNIMAC_RDP_UMAC_SYMMETRIC_IDLE_THRESHOLD_RESERVED0_FIELD_WIDTH,
    UNIMAC_RDP_UMAC_SYMMETRIC_IDLE_THRESHOLD_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_UMAC_SYMMETRIC_IDLE_THRESHOLD_THRESHOLD_VALUE
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_UMAC_SYMMETRIC_IDLE_THRESHOLD_THRESHOLD_VALUE_FIELD =
{
    "THRESHOLD_VALUE",
#if RU_INCLUDE_DESC
    "",
    "If LPI_Prediction is enabled then this register defines the number of IDLEs to be received by the UniMAC before allowing LP_IDLE to be sent to Link Partner.\n"
    "It is an experimental feature and not recommended to use for the production SW.",
#endif
    UNIMAC_RDP_UMAC_SYMMETRIC_IDLE_THRESHOLD_THRESHOLD_VALUE_FIELD_MASK,
    0,
    UNIMAC_RDP_UMAC_SYMMETRIC_IDLE_THRESHOLD_THRESHOLD_VALUE_FIELD_WIDTH,
    UNIMAC_RDP_UMAC_SYMMETRIC_IDLE_THRESHOLD_THRESHOLD_VALUE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_MII_EEE_WAKE_TIMER_RESERVED0
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_MII_EEE_WAKE_TIMER_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    UNIMAC_RDP_MII_EEE_WAKE_TIMER_RESERVED0_FIELD_MASK,
    0,
    UNIMAC_RDP_MII_EEE_WAKE_TIMER_RESERVED0_FIELD_WIDTH,
    UNIMAC_RDP_MII_EEE_WAKE_TIMER_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_MII_EEE_WAKE_TIMER_MII_EEE_WAKE_TIMER
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_MII_EEE_WAKE_TIMER_MII_EEE_WAKE_TIMER_FIELD =
{
    "MII_EEE_WAKE_TIMER",
#if RU_INCLUDE_DESC
    "",
    "This is the duration for which MAC must wait to go back to ACTIVE state from LPI state when it receives packet for transmission. The decrement unit is 1 micro-second.\n"
    "This register is meant for 100 Mbps speed.",
#endif
    UNIMAC_RDP_MII_EEE_WAKE_TIMER_MII_EEE_WAKE_TIMER_FIELD_MASK,
    0,
    UNIMAC_RDP_MII_EEE_WAKE_TIMER_MII_EEE_WAKE_TIMER_FIELD_WIDTH,
    UNIMAC_RDP_MII_EEE_WAKE_TIMER_MII_EEE_WAKE_TIMER_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_GMII_EEE_WAKE_TIMER_RESERVED0
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_GMII_EEE_WAKE_TIMER_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    UNIMAC_RDP_GMII_EEE_WAKE_TIMER_RESERVED0_FIELD_MASK,
    0,
    UNIMAC_RDP_GMII_EEE_WAKE_TIMER_RESERVED0_FIELD_WIDTH,
    UNIMAC_RDP_GMII_EEE_WAKE_TIMER_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_GMII_EEE_WAKE_TIMER_GMII_EEE_WAKE_TIMER
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_GMII_EEE_WAKE_TIMER_GMII_EEE_WAKE_TIMER_FIELD =
{
    "GMII_EEE_WAKE_TIMER",
#if RU_INCLUDE_DESC
    "",
    "This is the duration for which MAC must wait to go back to ACTIVE state from LPI state when it receives packet for transmission. The decrement unit is 1 micro-second.\n"
    "This register is meant for 1000 Mbps speed.",
#endif
    UNIMAC_RDP_GMII_EEE_WAKE_TIMER_GMII_EEE_WAKE_TIMER_FIELD_MASK,
    0,
    UNIMAC_RDP_GMII_EEE_WAKE_TIMER_GMII_EEE_WAKE_TIMER_FIELD_WIDTH,
    UNIMAC_RDP_GMII_EEE_WAKE_TIMER_GMII_EEE_WAKE_TIMER_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_UMAC_REV_ID_RESERVED0
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_UMAC_REV_ID_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    UNIMAC_RDP_UMAC_REV_ID_RESERVED0_FIELD_MASK,
    0,
    UNIMAC_RDP_UMAC_REV_ID_RESERVED0_FIELD_WIDTH,
    UNIMAC_RDP_UMAC_REV_ID_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_UMAC_REV_ID_REVISION_ID_MAJOR
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_UMAC_REV_ID_REVISION_ID_MAJOR_FIELD =
{
    "REVISION_ID_MAJOR",
#if RU_INCLUDE_DESC
    "",
    "Unimac version id field before decimal.",
#endif
    UNIMAC_RDP_UMAC_REV_ID_REVISION_ID_MAJOR_FIELD_MASK,
    0,
    UNIMAC_RDP_UMAC_REV_ID_REVISION_ID_MAJOR_FIELD_WIDTH,
    UNIMAC_RDP_UMAC_REV_ID_REVISION_ID_MAJOR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_UMAC_REV_ID_REVISION_ID_MINOR
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_UMAC_REV_ID_REVISION_ID_MINOR_FIELD =
{
    "REVISION_ID_MINOR",
#if RU_INCLUDE_DESC
    "",
    "Unimac version id field after decimal.",
#endif
    UNIMAC_RDP_UMAC_REV_ID_REVISION_ID_MINOR_FIELD_MASK,
    0,
    UNIMAC_RDP_UMAC_REV_ID_REVISION_ID_MINOR_FIELD_WIDTH,
    UNIMAC_RDP_UMAC_REV_ID_REVISION_ID_MINOR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_UMAC_REV_ID_PATCH
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_UMAC_REV_ID_PATCH_FIELD =
{
    "PATCH",
#if RU_INCLUDE_DESC
    "",
    "Unimac revision patch number.",
#endif
    UNIMAC_RDP_UMAC_REV_ID_PATCH_FIELD_MASK,
    0,
    UNIMAC_RDP_UMAC_REV_ID_PATCH_FIELD_WIDTH,
    UNIMAC_RDP_UMAC_REV_ID_PATCH_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_GMII_2P5G_EEE_DELAY_ENTRY_TIMER_GMII_2P5G_EEE_LPI_TIMER
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_GMII_2P5G_EEE_DELAY_ENTRY_TIMER_GMII_2P5G_EEE_LPI_TIMER_FIELD =
{
    "GMII_2P5G_EEE_LPI_TIMER",
#if RU_INCLUDE_DESC
    "",
    "This is the duration for which condition to move to LPI state must be satisfied, at the end of which MAC transitions to LPI State. The decrement unit is 1 micro-second.\n"
    "This register is meant for 2.5 Gbps speed.",
#endif
    UNIMAC_RDP_GMII_2P5G_EEE_DELAY_ENTRY_TIMER_GMII_2P5G_EEE_LPI_TIMER_FIELD_MASK,
    0,
    UNIMAC_RDP_GMII_2P5G_EEE_DELAY_ENTRY_TIMER_GMII_2P5G_EEE_LPI_TIMER_FIELD_WIDTH,
    UNIMAC_RDP_GMII_2P5G_EEE_DELAY_ENTRY_TIMER_GMII_2P5G_EEE_LPI_TIMER_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_GMII_5G_EEE_DELAY_ENTRY_TIMER_GMII_5G_EEE_LPI_TIMER
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_GMII_5G_EEE_DELAY_ENTRY_TIMER_GMII_5G_EEE_LPI_TIMER_FIELD =
{
    "GMII_5G_EEE_LPI_TIMER",
#if RU_INCLUDE_DESC
    "",
    "This is the duration for which condition to move to LPI state must be satisfied, at the end of which MAC transitions to LPI State. The decrement unit is 1 micro-second.\n"
    "This register is meant for 5 Gbps speed.",
#endif
    UNIMAC_RDP_GMII_5G_EEE_DELAY_ENTRY_TIMER_GMII_5G_EEE_LPI_TIMER_FIELD_MASK,
    0,
    UNIMAC_RDP_GMII_5G_EEE_DELAY_ENTRY_TIMER_GMII_5G_EEE_LPI_TIMER_FIELD_WIDTH,
    UNIMAC_RDP_GMII_5G_EEE_DELAY_ENTRY_TIMER_GMII_5G_EEE_LPI_TIMER_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_GMII_10G_EEE_DELAY_ENTRY_TIMER_GMII_10G_EEE_LPI_TIMER
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_GMII_10G_EEE_DELAY_ENTRY_TIMER_GMII_10G_EEE_LPI_TIMER_FIELD =
{
    "GMII_10G_EEE_LPI_TIMER",
#if RU_INCLUDE_DESC
    "",
    "This is the duration for which condition to move to LPI state must be satisfied, at the end of which MAC transitions to LPI State. The decrement unit is 1 micro-second.\n"
    "This register is meant for 10 Gbps speed.",
#endif
    UNIMAC_RDP_GMII_10G_EEE_DELAY_ENTRY_TIMER_GMII_10G_EEE_LPI_TIMER_FIELD_MASK,
    0,
    UNIMAC_RDP_GMII_10G_EEE_DELAY_ENTRY_TIMER_GMII_10G_EEE_LPI_TIMER_FIELD_WIDTH,
    UNIMAC_RDP_GMII_10G_EEE_DELAY_ENTRY_TIMER_GMII_10G_EEE_LPI_TIMER_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_GMII_2P5G_EEE_WAKE_TIMER_RESERVED0
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_GMII_2P5G_EEE_WAKE_TIMER_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    UNIMAC_RDP_GMII_2P5G_EEE_WAKE_TIMER_RESERVED0_FIELD_MASK,
    0,
    UNIMAC_RDP_GMII_2P5G_EEE_WAKE_TIMER_RESERVED0_FIELD_WIDTH,
    UNIMAC_RDP_GMII_2P5G_EEE_WAKE_TIMER_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_GMII_2P5G_EEE_WAKE_TIMER_GMII_2P5G_EEE_WAKE_TIMER
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_GMII_2P5G_EEE_WAKE_TIMER_GMII_2P5G_EEE_WAKE_TIMER_FIELD =
{
    "GMII_2P5G_EEE_WAKE_TIMER",
#if RU_INCLUDE_DESC
    "",
    "This is the duration for which MAC must wait to go back to ACTIVE state from LPI state when it receives packet for transmission. The decrement unit is 1 micro-second.\n"
    "This register is meant for 2.5 Gbps speed.",
#endif
    UNIMAC_RDP_GMII_2P5G_EEE_WAKE_TIMER_GMII_2P5G_EEE_WAKE_TIMER_FIELD_MASK,
    0,
    UNIMAC_RDP_GMII_2P5G_EEE_WAKE_TIMER_GMII_2P5G_EEE_WAKE_TIMER_FIELD_WIDTH,
    UNIMAC_RDP_GMII_2P5G_EEE_WAKE_TIMER_GMII_2P5G_EEE_WAKE_TIMER_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_GMII_5G_EEE_WAKE_TIMER_RESERVED0
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_GMII_5G_EEE_WAKE_TIMER_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    UNIMAC_RDP_GMII_5G_EEE_WAKE_TIMER_RESERVED0_FIELD_MASK,
    0,
    UNIMAC_RDP_GMII_5G_EEE_WAKE_TIMER_RESERVED0_FIELD_WIDTH,
    UNIMAC_RDP_GMII_5G_EEE_WAKE_TIMER_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_GMII_5G_EEE_WAKE_TIMER_GMII_5G_EEE_WAKE_TIMER
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_GMII_5G_EEE_WAKE_TIMER_GMII_5G_EEE_WAKE_TIMER_FIELD =
{
    "GMII_5G_EEE_WAKE_TIMER",
#if RU_INCLUDE_DESC
    "",
    "This is the duration for which MAC must wait to go back to ACTIVE state from LPI state when it receives packet for transmission. The decrement unit is 1 micro-second.\n"
    "This register is meant for 5 Gbps speed.",
#endif
    UNIMAC_RDP_GMII_5G_EEE_WAKE_TIMER_GMII_5G_EEE_WAKE_TIMER_FIELD_MASK,
    0,
    UNIMAC_RDP_GMII_5G_EEE_WAKE_TIMER_GMII_5G_EEE_WAKE_TIMER_FIELD_WIDTH,
    UNIMAC_RDP_GMII_5G_EEE_WAKE_TIMER_GMII_5G_EEE_WAKE_TIMER_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_GMII_10G_EEE_WAKE_TIMER_RESERVED0
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_GMII_10G_EEE_WAKE_TIMER_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    UNIMAC_RDP_GMII_10G_EEE_WAKE_TIMER_RESERVED0_FIELD_MASK,
    0,
    UNIMAC_RDP_GMII_10G_EEE_WAKE_TIMER_RESERVED0_FIELD_WIDTH,
    UNIMAC_RDP_GMII_10G_EEE_WAKE_TIMER_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_GMII_10G_EEE_WAKE_TIMER_GMII_10G_EEE_WAKE_TIMER
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_GMII_10G_EEE_WAKE_TIMER_GMII_10G_EEE_WAKE_TIMER_FIELD =
{
    "GMII_10G_EEE_WAKE_TIMER",
#if RU_INCLUDE_DESC
    "",
    "This is the duration for which MAC must wait to go back to ACTIVE state from LPI state when it receives packet for transmission. The decrement unit is 1 micro-second.\n"
    "This register is meant for 10 Gbps speed.",
#endif
    UNIMAC_RDP_GMII_10G_EEE_WAKE_TIMER_GMII_10G_EEE_WAKE_TIMER_FIELD_MASK,
    0,
    UNIMAC_RDP_GMII_10G_EEE_WAKE_TIMER_GMII_10G_EEE_WAKE_TIMER_FIELD_WIDTH,
    UNIMAC_RDP_GMII_10G_EEE_WAKE_TIMER_GMII_10G_EEE_WAKE_TIMER_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_ACTIVE_EEE_DELAY_ENTRY_TIMER_ACTIVE_EEE_LPI_TIMER
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_ACTIVE_EEE_DELAY_ENTRY_TIMER_ACTIVE_EEE_LPI_TIMER_FIELD =
{
    "ACTIVE_EEE_LPI_TIMER",
#if RU_INCLUDE_DESC
    "",
    "Currently selected EEE LPI timer.\n",
#endif
    UNIMAC_RDP_ACTIVE_EEE_DELAY_ENTRY_TIMER_ACTIVE_EEE_LPI_TIMER_FIELD_MASK,
    0,
    UNIMAC_RDP_ACTIVE_EEE_DELAY_ENTRY_TIMER_ACTIVE_EEE_LPI_TIMER_FIELD_WIDTH,
    UNIMAC_RDP_ACTIVE_EEE_DELAY_ENTRY_TIMER_ACTIVE_EEE_LPI_TIMER_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_ACTIVE_EEE_WAKE_TIMER_RESERVED0
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_ACTIVE_EEE_WAKE_TIMER_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    UNIMAC_RDP_ACTIVE_EEE_WAKE_TIMER_RESERVED0_FIELD_MASK,
    0,
    UNIMAC_RDP_ACTIVE_EEE_WAKE_TIMER_RESERVED0_FIELD_WIDTH,
    UNIMAC_RDP_ACTIVE_EEE_WAKE_TIMER_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_ACTIVE_EEE_WAKE_TIMER_ACTIVE_EEE_WAKE_TIME
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_ACTIVE_EEE_WAKE_TIMER_ACTIVE_EEE_WAKE_TIME_FIELD =
{
    "ACTIVE_EEE_WAKE_TIME",
#if RU_INCLUDE_DESC
    "",
    "Currently selected wake timer.\n",
#endif
    UNIMAC_RDP_ACTIVE_EEE_WAKE_TIMER_ACTIVE_EEE_WAKE_TIME_FIELD_MASK,
    0,
    UNIMAC_RDP_ACTIVE_EEE_WAKE_TIMER_ACTIVE_EEE_WAKE_TIME_FIELD_WIDTH,
    UNIMAC_RDP_ACTIVE_EEE_WAKE_TIMER_ACTIVE_EEE_WAKE_TIME_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_MAC_PFC_TYPE_RESERVED0
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_MAC_PFC_TYPE_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    UNIMAC_RDP_MAC_PFC_TYPE_RESERVED0_FIELD_MASK,
    0,
    UNIMAC_RDP_MAC_PFC_TYPE_RESERVED0_FIELD_WIDTH,
    UNIMAC_RDP_MAC_PFC_TYPE_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_MAC_PFC_TYPE_PFC_ETH_TYPE
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_MAC_PFC_TYPE_PFC_ETH_TYPE_FIELD =
{
    "PFC_ETH_TYPE",
#if RU_INCLUDE_DESC
    "",
    "Ethertype for PFC packets. The default value (0x8808) is the standard value.",
#endif
    UNIMAC_RDP_MAC_PFC_TYPE_PFC_ETH_TYPE_FIELD_MASK,
    0,
    UNIMAC_RDP_MAC_PFC_TYPE_PFC_ETH_TYPE_FIELD_WIDTH,
    UNIMAC_RDP_MAC_PFC_TYPE_PFC_ETH_TYPE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_MAC_PFC_OPCODE_RESERVED0
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_MAC_PFC_OPCODE_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    UNIMAC_RDP_MAC_PFC_OPCODE_RESERVED0_FIELD_MASK,
    0,
    UNIMAC_RDP_MAC_PFC_OPCODE_RESERVED0_FIELD_WIDTH,
    UNIMAC_RDP_MAC_PFC_OPCODE_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_MAC_PFC_OPCODE_PFC_OPCODE
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_MAC_PFC_OPCODE_PFC_OPCODE_FIELD =
{
    "PFC_OPCODE",
#if RU_INCLUDE_DESC
    "",
    "PFC opcode. The default value (0x0101) is the standard value.",
#endif
    UNIMAC_RDP_MAC_PFC_OPCODE_PFC_OPCODE_FIELD_MASK,
    0,
    UNIMAC_RDP_MAC_PFC_OPCODE_PFC_OPCODE_FIELD_WIDTH,
    UNIMAC_RDP_MAC_PFC_OPCODE_PFC_OPCODE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_MAC_PFC_DA_0_PFC_MACDA_0
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_MAC_PFC_DA_0_PFC_MACDA_0_FIELD =
{
    "PFC_MACDA_0",
#if RU_INCLUDE_DESC
    "",
    "Lower 32 bits of DA for PFC.",
#endif
    UNIMAC_RDP_MAC_PFC_DA_0_PFC_MACDA_0_FIELD_MASK,
    0,
    UNIMAC_RDP_MAC_PFC_DA_0_PFC_MACDA_0_FIELD_WIDTH,
    UNIMAC_RDP_MAC_PFC_DA_0_PFC_MACDA_0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_MAC_PFC_DA_1_RESERVED0
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_MAC_PFC_DA_1_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    UNIMAC_RDP_MAC_PFC_DA_1_RESERVED0_FIELD_MASK,
    0,
    UNIMAC_RDP_MAC_PFC_DA_1_RESERVED0_FIELD_WIDTH,
    UNIMAC_RDP_MAC_PFC_DA_1_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_MAC_PFC_DA_1_PFC_MACDA_1
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_MAC_PFC_DA_1_PFC_MACDA_1_FIELD =
{
    "PFC_MACDA_1",
#if RU_INCLUDE_DESC
    "",
    "Upper 16 bits of DA for PFC.",
#endif
    UNIMAC_RDP_MAC_PFC_DA_1_PFC_MACDA_1_FIELD_MASK,
    0,
    UNIMAC_RDP_MAC_PFC_DA_1_PFC_MACDA_1_FIELD_WIDTH,
    UNIMAC_RDP_MAC_PFC_DA_1_PFC_MACDA_1_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_MACSEC_PROG_TX_CRC_MACSEC_PROG_TX_CRC
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_MACSEC_PROG_TX_CRC_MACSEC_PROG_TX_CRC_FIELD =
{
    "MACSEC_PROG_TX_CRC",
#if RU_INCLUDE_DESC
    "",
    "The transmitted CRC can be corrupted by replacing the FCS of the transmitted frame by the FCS programmed in this register.\n"
    "This is enabled and controlled by MACSEC_CNTRL register.",
#endif
    UNIMAC_RDP_MACSEC_PROG_TX_CRC_MACSEC_PROG_TX_CRC_FIELD_MASK,
    0,
    UNIMAC_RDP_MACSEC_PROG_TX_CRC_MACSEC_PROG_TX_CRC_FIELD_WIDTH,
    UNIMAC_RDP_MACSEC_PROG_TX_CRC_MACSEC_PROG_TX_CRC_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_MACSEC_CNTRL_RESERVED0
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_MACSEC_CNTRL_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    UNIMAC_RDP_MACSEC_CNTRL_RESERVED0_FIELD_MASK,
    0,
    UNIMAC_RDP_MACSEC_CNTRL_RESERVED0_FIELD_WIDTH,
    UNIMAC_RDP_MACSEC_CNTRL_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_MACSEC_CNTRL_DIS_PAUSE_DATA_VAR_IPG
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_MACSEC_CNTRL_DIS_PAUSE_DATA_VAR_IPG_FIELD =
{
    "DIS_PAUSE_DATA_VAR_IPG",
#if RU_INCLUDE_DESC
    "",
    "When this bit is 1, IPG between pause and data frame is as per the original design, i.e., 13B or 12B, fixed. It should be noted, that as number of preamble bytes reduces from 7, the IPG also increases. \n"
    "When this bit is 0, IPG between pause and data frame is variable and equals programmed IPG or programmed IPG + 1.",
#endif
    UNIMAC_RDP_MACSEC_CNTRL_DIS_PAUSE_DATA_VAR_IPG_FIELD_MASK,
    0,
    UNIMAC_RDP_MACSEC_CNTRL_DIS_PAUSE_DATA_VAR_IPG_FIELD_WIDTH,
    UNIMAC_RDP_MACSEC_CNTRL_DIS_PAUSE_DATA_VAR_IPG_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_MACSEC_CNTRL_TX_CRC_PROGRAM
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_MACSEC_CNTRL_TX_CRC_PROGRAM_FIELD =
{
    "TX_CRC_PROGRAM",
#if RU_INCLUDE_DESC
    "",
    "If CRC corruption feature in enabled (TX_CRC_CORUPT_EN set), then in case where this bit when set, replaces the transmitted FCS with the programmed FCS.\n"
    "When cleared, corrupts the CRC of the transmitted packet internally.",
#endif
    UNIMAC_RDP_MACSEC_CNTRL_TX_CRC_PROGRAM_FIELD_MASK,
    0,
    UNIMAC_RDP_MACSEC_CNTRL_TX_CRC_PROGRAM_FIELD_WIDTH,
    UNIMAC_RDP_MACSEC_CNTRL_TX_CRC_PROGRAM_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_MACSEC_CNTRL_TX_CRC_CORUPT_EN
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_MACSEC_CNTRL_TX_CRC_CORUPT_EN_FIELD =
{
    "TX_CRC_CORUPT_EN",
#if RU_INCLUDE_DESC
    "",
    "Setting this field enables the CRC corruption on the transmitted packets. The options of how to corrupt, depends on\n"
    "the field 2 of this register (TX_CRC_PROGRAM). The CRC corruption happens only on the frames for which TXCRCER is asserted by the system.",
#endif
    UNIMAC_RDP_MACSEC_CNTRL_TX_CRC_CORUPT_EN_FIELD_MASK,
    0,
    UNIMAC_RDP_MACSEC_CNTRL_TX_CRC_CORUPT_EN_FIELD_WIDTH,
    UNIMAC_RDP_MACSEC_CNTRL_TX_CRC_CORUPT_EN_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_MACSEC_CNTRL_TX_LAUNCH_EN
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_MACSEC_CNTRL_TX_LAUNCH_EN_FIELD =
{
    "TX_LAUNCH_EN",
#if RU_INCLUDE_DESC
    "",
    "Set the bit 0 (Tx_Launch_en) logic 0, if the tx_launch function is to be disabled. If set, then the launch_enable signal assertion/deassertion causes the packet transmit enabled/disabled. The launch_enable is per packet basis.",
#endif
    UNIMAC_RDP_MACSEC_CNTRL_TX_LAUNCH_EN_FIELD_MASK,
    0,
    UNIMAC_RDP_MACSEC_CNTRL_TX_LAUNCH_EN_FIELD_WIDTH,
    UNIMAC_RDP_MACSEC_CNTRL_TX_LAUNCH_EN_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_TS_STATUS_RESERVED0
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_TS_STATUS_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    UNIMAC_RDP_TS_STATUS_RESERVED0_FIELD_MASK,
    0,
    UNIMAC_RDP_TS_STATUS_RESERVED0_FIELD_WIDTH,
    UNIMAC_RDP_TS_STATUS_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_TS_STATUS_WORD_AVAIL
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_TS_STATUS_WORD_AVAIL_FIELD =
{
    "WORD_AVAIL",
#if RU_INCLUDE_DESC
    "",
    "Indicates number of cells filled in the TX timestamp FIFO.",
#endif
    UNIMAC_RDP_TS_STATUS_WORD_AVAIL_FIELD_MASK,
    0,
    UNIMAC_RDP_TS_STATUS_WORD_AVAIL_FIELD_WIDTH,
    UNIMAC_RDP_TS_STATUS_WORD_AVAIL_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_TS_STATUS_TX_TS_FIFO_EMPTY
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_TS_STATUS_TX_TS_FIFO_EMPTY_FIELD =
{
    "TX_TS_FIFO_EMPTY",
#if RU_INCLUDE_DESC
    "",
    "Read-only field assertion shows that the transmit timestamp FIFO is empty.",
#endif
    UNIMAC_RDP_TS_STATUS_TX_TS_FIFO_EMPTY_FIELD_MASK,
    0,
    UNIMAC_RDP_TS_STATUS_TX_TS_FIFO_EMPTY_FIELD_WIDTH,
    UNIMAC_RDP_TS_STATUS_TX_TS_FIFO_EMPTY_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_TS_STATUS_TX_TS_FIFO_FULL
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_TS_STATUS_TX_TS_FIFO_FULL_FIELD =
{
    "TX_TS_FIFO_FULL",
#if RU_INCLUDE_DESC
    "",
    "Read-only field assertion shows that the transmit timestamp FIFO is full.",
#endif
    UNIMAC_RDP_TS_STATUS_TX_TS_FIFO_FULL_FIELD_MASK,
    0,
    UNIMAC_RDP_TS_STATUS_TX_TS_FIFO_FULL_FIELD_WIDTH,
    UNIMAC_RDP_TS_STATUS_TX_TS_FIFO_FULL_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_TX_TS_DATA_TX_TS_DATA
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_TX_TS_DATA_TX_TS_DATA_FIELD =
{
    "TX_TS_DATA",
#if RU_INCLUDE_DESC
    "",
    "Every read of this register will fetch out one timestamp value corresponding to the preceding seq_id read from the transmit FIFO.\n"
    "Every 49 bit, val_bit + seq_id + timestamp is read in two steps, i.e., one read from 0x10f (val_bit + seq_id) followed by another read from 0x1c7 (timestamp).\n"
    "Timestamp read without a preceding seq_id read will fetch stale timestamp value.",
#endif
    UNIMAC_RDP_TX_TS_DATA_TX_TS_DATA_FIELD_MASK,
    0,
    UNIMAC_RDP_TX_TS_DATA_TX_TS_DATA_FIELD_WIDTH,
    UNIMAC_RDP_TX_TS_DATA_TX_TS_DATA_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_PAUSE_REFRESH_CTRL_RESERVED0
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_PAUSE_REFRESH_CTRL_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    UNIMAC_RDP_PAUSE_REFRESH_CTRL_RESERVED0_FIELD_MASK,
    0,
    UNIMAC_RDP_PAUSE_REFRESH_CTRL_RESERVED0_FIELD_WIDTH,
    UNIMAC_RDP_PAUSE_REFRESH_CTRL_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_PAUSE_REFRESH_CTRL_ENABLE
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_PAUSE_REFRESH_CTRL_ENABLE_FIELD =
{
    "ENABLE",
#if RU_INCLUDE_DESC
    "",
    "Enable extra pause frames.",
#endif
    UNIMAC_RDP_PAUSE_REFRESH_CTRL_ENABLE_FIELD_MASK,
    0,
    UNIMAC_RDP_PAUSE_REFRESH_CTRL_ENABLE_FIELD_WIDTH,
    UNIMAC_RDP_PAUSE_REFRESH_CTRL_ENABLE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_PAUSE_REFRESH_CTRL_REFRESH_TIMER
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_PAUSE_REFRESH_CTRL_REFRESH_TIMER_FIELD =
{
    "REFRESH_TIMER",
#if RU_INCLUDE_DESC
    "",
    "Timer expiry time, represented in 512 bit time units. Note that the actual expiry time depends on the port speed. Values of 0 and 1 are illegal.",
#endif
    UNIMAC_RDP_PAUSE_REFRESH_CTRL_REFRESH_TIMER_FIELD_MASK,
    0,
    UNIMAC_RDP_PAUSE_REFRESH_CTRL_REFRESH_TIMER_FIELD_WIDTH,
    UNIMAC_RDP_PAUSE_REFRESH_CTRL_REFRESH_TIMER_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_FLUSH_CONTROL_RESERVED0
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_FLUSH_CONTROL_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    UNIMAC_RDP_FLUSH_CONTROL_RESERVED0_FIELD_MASK,
    0,
    UNIMAC_RDP_FLUSH_CONTROL_RESERVED0_FIELD_WIDTH,
    UNIMAC_RDP_FLUSH_CONTROL_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_FLUSH_CONTROL_FLUSH
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_FLUSH_CONTROL_FLUSH_FIELD =
{
    "FLUSH",
#if RU_INCLUDE_DESC
    "",
    "Flush enable bit to drop out all packets in Tx FIFO without egressing any packets when set.",
#endif
    UNIMAC_RDP_FLUSH_CONTROL_FLUSH_FIELD_MASK,
    0,
    UNIMAC_RDP_FLUSH_CONTROL_FLUSH_FIELD_WIDTH,
    UNIMAC_RDP_FLUSH_CONTROL_FLUSH_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_RXFIFO_STAT_RESERVED0
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_RXFIFO_STAT_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    UNIMAC_RDP_RXFIFO_STAT_RESERVED0_FIELD_MASK,
    0,
    UNIMAC_RDP_RXFIFO_STAT_RESERVED0_FIELD_WIDTH,
    UNIMAC_RDP_RXFIFO_STAT_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_RXFIFO_STAT_RXFIFO_OVERRUN
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_RXFIFO_STAT_RXFIFO_OVERRUN_FIELD =
{
    "RXFIFO_OVERRUN",
#if RU_INCLUDE_DESC
    "",
    "RXFIFO Overrun occurred.",
#endif
    UNIMAC_RDP_RXFIFO_STAT_RXFIFO_OVERRUN_FIELD_MASK,
    0,
    UNIMAC_RDP_RXFIFO_STAT_RXFIFO_OVERRUN_FIELD_WIDTH,
    UNIMAC_RDP_RXFIFO_STAT_RXFIFO_OVERRUN_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_RXFIFO_STAT_RXFIFO_UNDERRUN
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_RXFIFO_STAT_RXFIFO_UNDERRUN_FIELD =
{
    "RXFIFO_UNDERRUN",
#if RU_INCLUDE_DESC
    "",
    "RXFIFO Underrun occurred.",
#endif
    UNIMAC_RDP_RXFIFO_STAT_RXFIFO_UNDERRUN_FIELD_MASK,
    0,
    UNIMAC_RDP_RXFIFO_STAT_RXFIFO_UNDERRUN_FIELD_WIDTH,
    UNIMAC_RDP_RXFIFO_STAT_RXFIFO_UNDERRUN_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_TXFIFO_STAT_RESERVED0
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_TXFIFO_STAT_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    UNIMAC_RDP_TXFIFO_STAT_RESERVED0_FIELD_MASK,
    0,
    UNIMAC_RDP_TXFIFO_STAT_RESERVED0_FIELD_WIDTH,
    UNIMAC_RDP_TXFIFO_STAT_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_TXFIFO_STAT_TXFIFO_OVERRUN
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_TXFIFO_STAT_TXFIFO_OVERRUN_FIELD =
{
    "TXFIFO_OVERRUN",
#if RU_INCLUDE_DESC
    "",
    "TXFIFO Overrun occurred.",
#endif
    UNIMAC_RDP_TXFIFO_STAT_TXFIFO_OVERRUN_FIELD_MASK,
    0,
    UNIMAC_RDP_TXFIFO_STAT_TXFIFO_OVERRUN_FIELD_WIDTH,
    UNIMAC_RDP_TXFIFO_STAT_TXFIFO_OVERRUN_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_TXFIFO_STAT_TXFIFO_UNDERRUN
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_TXFIFO_STAT_TXFIFO_UNDERRUN_FIELD =
{
    "TXFIFO_UNDERRUN",
#if RU_INCLUDE_DESC
    "",
    "TXFIFO Underrun occurred.",
#endif
    UNIMAC_RDP_TXFIFO_STAT_TXFIFO_UNDERRUN_FIELD_MASK,
    0,
    UNIMAC_RDP_TXFIFO_STAT_TXFIFO_UNDERRUN_FIELD_WIDTH,
    UNIMAC_RDP_TXFIFO_STAT_TXFIFO_UNDERRUN_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_MAC_PFC_CTRL_RESERVED0
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_MAC_PFC_CTRL_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    UNIMAC_RDP_MAC_PFC_CTRL_RESERVED0_FIELD_MASK,
    0,
    UNIMAC_RDP_MAC_PFC_CTRL_RESERVED0_FIELD_WIDTH,
    UNIMAC_RDP_MAC_PFC_CTRL_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_MAC_PFC_CTRL_PFC_STATS_EN
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_MAC_PFC_CTRL_PFC_STATS_EN_FIELD =
{
    "PFC_STATS_EN",
#if RU_INCLUDE_DESC
    "",
    "When clear, none of PFC related counters should increment. \n"
    "Otherwise, PFC counters is in full function. \n"
    "Note: it is programming requirement to set this bit when PFC function is enable.",
#endif
    UNIMAC_RDP_MAC_PFC_CTRL_PFC_STATS_EN_FIELD_MASK,
    0,
    UNIMAC_RDP_MAC_PFC_CTRL_PFC_STATS_EN_FIELD_WIDTH,
    UNIMAC_RDP_MAC_PFC_CTRL_PFC_STATS_EN_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_MAC_PFC_CTRL_RX_PASS_PFC_FRM
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_MAC_PFC_CTRL_RX_PASS_PFC_FRM_FIELD =
{
    "RX_PASS_PFC_FRM",
#if RU_INCLUDE_DESC
    "",
    "When set, MAC pass PFC frame to the system. Otherwise, PFC frame is discarded.",
#endif
    UNIMAC_RDP_MAC_PFC_CTRL_RX_PASS_PFC_FRM_FIELD_MASK,
    0,
    UNIMAC_RDP_MAC_PFC_CTRL_RX_PASS_PFC_FRM_FIELD_WIDTH,
    UNIMAC_RDP_MAC_PFC_CTRL_RX_PASS_PFC_FRM_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_MAC_PFC_CTRL_RESERVED1
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_MAC_PFC_CTRL_RESERVED1_FIELD =
{
    "RESERVED1",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    UNIMAC_RDP_MAC_PFC_CTRL_RESERVED1_FIELD_MASK,
    0,
    UNIMAC_RDP_MAC_PFC_CTRL_RESERVED1_FIELD_WIDTH,
    UNIMAC_RDP_MAC_PFC_CTRL_RESERVED1_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_MAC_PFC_CTRL_FORCE_PFC_XON
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_MAC_PFC_CTRL_FORCE_PFC_XON_FIELD =
{
    "FORCE_PFC_XON",
#if RU_INCLUDE_DESC
    "",
    "Instructs MAC to send Xon message to all classes of service.",
#endif
    UNIMAC_RDP_MAC_PFC_CTRL_FORCE_PFC_XON_FIELD_MASK,
    0,
    UNIMAC_RDP_MAC_PFC_CTRL_FORCE_PFC_XON_FIELD_WIDTH,
    UNIMAC_RDP_MAC_PFC_CTRL_FORCE_PFC_XON_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_MAC_PFC_CTRL_PFC_RX_ENBL
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_MAC_PFC_CTRL_PFC_RX_ENBL_FIELD =
{
    "PFC_RX_ENBL",
#if RU_INCLUDE_DESC
    "",
    "Enables the PFC-Rx functionality.",
#endif
    UNIMAC_RDP_MAC_PFC_CTRL_PFC_RX_ENBL_FIELD_MASK,
    0,
    UNIMAC_RDP_MAC_PFC_CTRL_PFC_RX_ENBL_FIELD_WIDTH,
    UNIMAC_RDP_MAC_PFC_CTRL_PFC_RX_ENBL_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_MAC_PFC_CTRL_PFC_TX_ENBL
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_MAC_PFC_CTRL_PFC_TX_ENBL_FIELD =
{
    "PFC_TX_ENBL",
#if RU_INCLUDE_DESC
    "",
    "Enables the PFC-Tx functionality.",
#endif
    UNIMAC_RDP_MAC_PFC_CTRL_PFC_TX_ENBL_FIELD_MASK,
    0,
    UNIMAC_RDP_MAC_PFC_CTRL_PFC_TX_ENBL_FIELD_WIDTH,
    UNIMAC_RDP_MAC_PFC_CTRL_PFC_TX_ENBL_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_MAC_PFC_REFRESH_CTRL_PFC_REFRESH_TIMER
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_MAC_PFC_REFRESH_CTRL_PFC_REFRESH_TIMER_FIELD =
{
    "PFC_REFRESH_TIMER",
#if RU_INCLUDE_DESC
    "",
    "PFC refresh counter value.",
#endif
    UNIMAC_RDP_MAC_PFC_REFRESH_CTRL_PFC_REFRESH_TIMER_FIELD_MASK,
    0,
    UNIMAC_RDP_MAC_PFC_REFRESH_CTRL_PFC_REFRESH_TIMER_FIELD_WIDTH,
    UNIMAC_RDP_MAC_PFC_REFRESH_CTRL_PFC_REFRESH_TIMER_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_MAC_PFC_REFRESH_CTRL_RESERVED0
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_MAC_PFC_REFRESH_CTRL_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    UNIMAC_RDP_MAC_PFC_REFRESH_CTRL_RESERVED0_FIELD_MASK,
    0,
    UNIMAC_RDP_MAC_PFC_REFRESH_CTRL_RESERVED0_FIELD_WIDTH,
    UNIMAC_RDP_MAC_PFC_REFRESH_CTRL_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_MAC_PFC_REFRESH_CTRL_PFC_REFRESH_EN
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_MAC_PFC_REFRESH_CTRL_PFC_REFRESH_EN_FIELD =
{
    "PFC_REFRESH_EN",
#if RU_INCLUDE_DESC
    "",
    "Enables the PFC refresh functionality on the Tx side. When enabled, the MAC sends Xoff message on refresh counter becoming 0",
#endif
    UNIMAC_RDP_MAC_PFC_REFRESH_CTRL_PFC_REFRESH_EN_FIELD_MASK,
    0,
    UNIMAC_RDP_MAC_PFC_REFRESH_CTRL_PFC_REFRESH_EN_FIELD_WIDTH,
    UNIMAC_RDP_MAC_PFC_REFRESH_CTRL_PFC_REFRESH_EN_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_GR64_COUNT
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_GR64_COUNT_FIELD =
{
    "COUNT",
#if RU_INCLUDE_DESC
    "",
    "Receive 64 Bytes frame counter.",
#endif
    UNIMAC_RDP_GR64_COUNT_FIELD_MASK,
    0,
    UNIMAC_RDP_GR64_COUNT_FIELD_WIDTH,
    UNIMAC_RDP_GR64_COUNT_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_GR64_UPPER_COUNT_U8
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_GR64_UPPER_COUNT_U8_FIELD =
{
    "COUNT_U8",
#if RU_INCLUDE_DESC
    "",
    "Upper 8 bits of 40-bit counter.",
#endif
    UNIMAC_RDP_GR64_UPPER_COUNT_U8_FIELD_MASK,
    0,
    UNIMAC_RDP_GR64_UPPER_COUNT_U8_FIELD_WIDTH,
    UNIMAC_RDP_GR64_UPPER_COUNT_U8_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_GR127_COUNT
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_GR127_COUNT_FIELD =
{
    "COUNT",
#if RU_INCLUDE_DESC
    "",
    "Receive 65 bytes to 127 bytes frame counter.",
#endif
    UNIMAC_RDP_GR127_COUNT_FIELD_MASK,
    0,
    UNIMAC_RDP_GR127_COUNT_FIELD_WIDTH,
    UNIMAC_RDP_GR127_COUNT_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_GR127_UPPER_COUNT_U8
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_GR127_UPPER_COUNT_U8_FIELD =
{
    "COUNT_U8",
#if RU_INCLUDE_DESC
    "",
    "Upper 8 bits of 40-bit counter.",
#endif
    UNIMAC_RDP_GR127_UPPER_COUNT_U8_FIELD_MASK,
    0,
    UNIMAC_RDP_GR127_UPPER_COUNT_U8_FIELD_WIDTH,
    UNIMAC_RDP_GR127_UPPER_COUNT_U8_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_GR255_COUNT
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_GR255_COUNT_FIELD =
{
    "COUNT",
#if RU_INCLUDE_DESC
    "",
    "Receive 128 bytes to 255 bytes frame counter.",
#endif
    UNIMAC_RDP_GR255_COUNT_FIELD_MASK,
    0,
    UNIMAC_RDP_GR255_COUNT_FIELD_WIDTH,
    UNIMAC_RDP_GR255_COUNT_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_GR255_UPPER_COUNT_U8
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_GR255_UPPER_COUNT_U8_FIELD =
{
    "COUNT_U8",
#if RU_INCLUDE_DESC
    "",
    "Upper 8 bits of 40-bit counter.",
#endif
    UNIMAC_RDP_GR255_UPPER_COUNT_U8_FIELD_MASK,
    0,
    UNIMAC_RDP_GR255_UPPER_COUNT_U8_FIELD_WIDTH,
    UNIMAC_RDP_GR255_UPPER_COUNT_U8_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_GR511_COUNT
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_GR511_COUNT_FIELD =
{
    "COUNT",
#if RU_INCLUDE_DESC
    "",
    "Receive 256 bytes to 511 bytes frame counter.",
#endif
    UNIMAC_RDP_GR511_COUNT_FIELD_MASK,
    0,
    UNIMAC_RDP_GR511_COUNT_FIELD_WIDTH,
    UNIMAC_RDP_GR511_COUNT_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_GR511_UPPER_COUNT_U8
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_GR511_UPPER_COUNT_U8_FIELD =
{
    "COUNT_U8",
#if RU_INCLUDE_DESC
    "",
    "Upper 8 bits of 40-bit counter.",
#endif
    UNIMAC_RDP_GR511_UPPER_COUNT_U8_FIELD_MASK,
    0,
    UNIMAC_RDP_GR511_UPPER_COUNT_U8_FIELD_WIDTH,
    UNIMAC_RDP_GR511_UPPER_COUNT_U8_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_GR1023_COUNT
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_GR1023_COUNT_FIELD =
{
    "COUNT",
#if RU_INCLUDE_DESC
    "",
    "Receive 512 bytes to 1023 bytes frame counter.",
#endif
    UNIMAC_RDP_GR1023_COUNT_FIELD_MASK,
    0,
    UNIMAC_RDP_GR1023_COUNT_FIELD_WIDTH,
    UNIMAC_RDP_GR1023_COUNT_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_GR1023_UPPER_COUNT_U8
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_GR1023_UPPER_COUNT_U8_FIELD =
{
    "COUNT_U8",
#if RU_INCLUDE_DESC
    "",
    "Upper 8 bits of 40-bit counter.",
#endif
    UNIMAC_RDP_GR1023_UPPER_COUNT_U8_FIELD_MASK,
    0,
    UNIMAC_RDP_GR1023_UPPER_COUNT_U8_FIELD_WIDTH,
    UNIMAC_RDP_GR1023_UPPER_COUNT_U8_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_GR1518_COUNT
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_GR1518_COUNT_FIELD =
{
    "COUNT",
#if RU_INCLUDE_DESC
    "",
    "Receive 1024 bytes to 1518 bytes frame counter.",
#endif
    UNIMAC_RDP_GR1518_COUNT_FIELD_MASK,
    0,
    UNIMAC_RDP_GR1518_COUNT_FIELD_WIDTH,
    UNIMAC_RDP_GR1518_COUNT_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_GR1518_UPPER_COUNT_U8
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_GR1518_UPPER_COUNT_U8_FIELD =
{
    "COUNT_U8",
#if RU_INCLUDE_DESC
    "",
    "Upper 8 bits of 40-bit counter.",
#endif
    UNIMAC_RDP_GR1518_UPPER_COUNT_U8_FIELD_MASK,
    0,
    UNIMAC_RDP_GR1518_UPPER_COUNT_U8_FIELD_WIDTH,
    UNIMAC_RDP_GR1518_UPPER_COUNT_U8_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_GRMGV_COUNT
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_GRMGV_COUNT_FIELD =
{
    "COUNT",
#if RU_INCLUDE_DESC
    "",
    "Receive 1519 bytes to 1522 bytes good VLAN frame counter.",
#endif
    UNIMAC_RDP_GRMGV_COUNT_FIELD_MASK,
    0,
    UNIMAC_RDP_GRMGV_COUNT_FIELD_WIDTH,
    UNIMAC_RDP_GRMGV_COUNT_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_GRMGV_UPPER_COUNT_U8
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_GRMGV_UPPER_COUNT_U8_FIELD =
{
    "COUNT_U8",
#if RU_INCLUDE_DESC
    "",
    "Upper 8 bits of 40-bit counter.",
#endif
    UNIMAC_RDP_GRMGV_UPPER_COUNT_U8_FIELD_MASK,
    0,
    UNIMAC_RDP_GRMGV_UPPER_COUNT_U8_FIELD_WIDTH,
    UNIMAC_RDP_GRMGV_UPPER_COUNT_U8_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_GR2047_COUNT
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_GR2047_COUNT_FIELD =
{
    "COUNT",
#if RU_INCLUDE_DESC
    "",
    "Receive 1519 bytes to 2047 bytes frame counter.",
#endif
    UNIMAC_RDP_GR2047_COUNT_FIELD_MASK,
    0,
    UNIMAC_RDP_GR2047_COUNT_FIELD_WIDTH,
    UNIMAC_RDP_GR2047_COUNT_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_GR2047_UPPER_COUNT_U8
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_GR2047_UPPER_COUNT_U8_FIELD =
{
    "COUNT_U8",
#if RU_INCLUDE_DESC
    "",
    "Upper 8 bits of 40-bit counter.",
#endif
    UNIMAC_RDP_GR2047_UPPER_COUNT_U8_FIELD_MASK,
    0,
    UNIMAC_RDP_GR2047_UPPER_COUNT_U8_FIELD_WIDTH,
    UNIMAC_RDP_GR2047_UPPER_COUNT_U8_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_GR4095_COUNT
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_GR4095_COUNT_FIELD =
{
    "COUNT",
#if RU_INCLUDE_DESC
    "",
    "Receive 2048 bytes to 4096 bytes frame counter.",
#endif
    UNIMAC_RDP_GR4095_COUNT_FIELD_MASK,
    0,
    UNIMAC_RDP_GR4095_COUNT_FIELD_WIDTH,
    UNIMAC_RDP_GR4095_COUNT_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_GR4095_UPPER_COUNT_U8
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_GR4095_UPPER_COUNT_U8_FIELD =
{
    "COUNT_U8",
#if RU_INCLUDE_DESC
    "",
    "Upper 8 bits of 40-bit counter.",
#endif
    UNIMAC_RDP_GR4095_UPPER_COUNT_U8_FIELD_MASK,
    0,
    UNIMAC_RDP_GR4095_UPPER_COUNT_U8_FIELD_WIDTH,
    UNIMAC_RDP_GR4095_UPPER_COUNT_U8_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_GR9216_COUNT
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_GR9216_COUNT_FIELD =
{
    "COUNT",
#if RU_INCLUDE_DESC
    "",
    "Receive 4096 bytes to 9216 bytes frame counter.",
#endif
    UNIMAC_RDP_GR9216_COUNT_FIELD_MASK,
    0,
    UNIMAC_RDP_GR9216_COUNT_FIELD_WIDTH,
    UNIMAC_RDP_GR9216_COUNT_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_GR9216_UPPER_COUNT_U8
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_GR9216_UPPER_COUNT_U8_FIELD =
{
    "COUNT_U8",
#if RU_INCLUDE_DESC
    "",
    "Upper 8 bits of 40-bit counter.",
#endif
    UNIMAC_RDP_GR9216_UPPER_COUNT_U8_FIELD_MASK,
    0,
    UNIMAC_RDP_GR9216_UPPER_COUNT_U8_FIELD_WIDTH,
    UNIMAC_RDP_GR9216_UPPER_COUNT_U8_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_GRPKT_COUNT
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_GRPKT_COUNT_FIELD =
{
    "COUNT",
#if RU_INCLUDE_DESC
    "",
    "Receive packet counter.",
#endif
    UNIMAC_RDP_GRPKT_COUNT_FIELD_MASK,
    0,
    UNIMAC_RDP_GRPKT_COUNT_FIELD_WIDTH,
    UNIMAC_RDP_GRPKT_COUNT_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_GRPKT_UPPER_COUNT_U8
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_GRPKT_UPPER_COUNT_U8_FIELD =
{
    "COUNT_U8",
#if RU_INCLUDE_DESC
    "",
    "Upper 8 bits of 40-bit counter.",
#endif
    UNIMAC_RDP_GRPKT_UPPER_COUNT_U8_FIELD_MASK,
    0,
    UNIMAC_RDP_GRPKT_UPPER_COUNT_U8_FIELD_WIDTH,
    UNIMAC_RDP_GRPKT_UPPER_COUNT_U8_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_GRBYT_COUNT
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_GRBYT_COUNT_FIELD =
{
    "COUNT",
#if RU_INCLUDE_DESC
    "",
    "Receive byte counter.",
#endif
    UNIMAC_RDP_GRBYT_COUNT_FIELD_MASK,
    0,
    UNIMAC_RDP_GRBYT_COUNT_FIELD_WIDTH,
    UNIMAC_RDP_GRBYT_COUNT_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_GRBYT_UPPER_COUNT_U16
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_GRBYT_UPPER_COUNT_U16_FIELD =
{
    "COUNT_U16",
#if RU_INCLUDE_DESC
    "",
    "Upper 16 bits of 48-bit counter.",
#endif
    UNIMAC_RDP_GRBYT_UPPER_COUNT_U16_FIELD_MASK,
    0,
    UNIMAC_RDP_GRBYT_UPPER_COUNT_U16_FIELD_WIDTH,
    UNIMAC_RDP_GRBYT_UPPER_COUNT_U16_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_GRMCA_COUNT
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_GRMCA_COUNT_FIELD =
{
    "COUNT",
#if RU_INCLUDE_DESC
    "",
    "Receive multicast packet counter.",
#endif
    UNIMAC_RDP_GRMCA_COUNT_FIELD_MASK,
    0,
    UNIMAC_RDP_GRMCA_COUNT_FIELD_WIDTH,
    UNIMAC_RDP_GRMCA_COUNT_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_GRMCA_UPPER_COUNT_U8
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_GRMCA_UPPER_COUNT_U8_FIELD =
{
    "COUNT_U8",
#if RU_INCLUDE_DESC
    "",
    "Upper 8 bits of 40-bit counter.",
#endif
    UNIMAC_RDP_GRMCA_UPPER_COUNT_U8_FIELD_MASK,
    0,
    UNIMAC_RDP_GRMCA_UPPER_COUNT_U8_FIELD_WIDTH,
    UNIMAC_RDP_GRMCA_UPPER_COUNT_U8_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_GRBCA_COUNT
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_GRBCA_COUNT_FIELD =
{
    "COUNT",
#if RU_INCLUDE_DESC
    "",
    "Receive broadcast packet counter.",
#endif
    UNIMAC_RDP_GRBCA_COUNT_FIELD_MASK,
    0,
    UNIMAC_RDP_GRBCA_COUNT_FIELD_WIDTH,
    UNIMAC_RDP_GRBCA_COUNT_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_GRBCA_UPPER_COUNT_U8
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_GRBCA_UPPER_COUNT_U8_FIELD =
{
    "COUNT_U8",
#if RU_INCLUDE_DESC
    "",
    "Upper 8 bits of 40-bit counter.",
#endif
    UNIMAC_RDP_GRBCA_UPPER_COUNT_U8_FIELD_MASK,
    0,
    UNIMAC_RDP_GRBCA_UPPER_COUNT_U8_FIELD_WIDTH,
    UNIMAC_RDP_GRBCA_UPPER_COUNT_U8_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_GRFCS_COUNT
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_GRFCS_COUNT_FIELD =
{
    "COUNT",
#if RU_INCLUDE_DESC
    "",
    "Receive FCS error counter.",
#endif
    UNIMAC_RDP_GRFCS_COUNT_FIELD_MASK,
    0,
    UNIMAC_RDP_GRFCS_COUNT_FIELD_WIDTH,
    UNIMAC_RDP_GRFCS_COUNT_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_GRFCS_UPPER_COUNT_U8
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_GRFCS_UPPER_COUNT_U8_FIELD =
{
    "COUNT_U8",
#if RU_INCLUDE_DESC
    "",
    "Upper 8 bits of 40-bit counter.",
#endif
    UNIMAC_RDP_GRFCS_UPPER_COUNT_U8_FIELD_MASK,
    0,
    UNIMAC_RDP_GRFCS_UPPER_COUNT_U8_FIELD_WIDTH,
    UNIMAC_RDP_GRFCS_UPPER_COUNT_U8_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_GRXCF_COUNT
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_GRXCF_COUNT_FIELD =
{
    "COUNT",
#if RU_INCLUDE_DESC
    "",
    "Receive control frame packet counter.",
#endif
    UNIMAC_RDP_GRXCF_COUNT_FIELD_MASK,
    0,
    UNIMAC_RDP_GRXCF_COUNT_FIELD_WIDTH,
    UNIMAC_RDP_GRXCF_COUNT_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_GRXCF_UPPER_COUNT_U8
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_GRXCF_UPPER_COUNT_U8_FIELD =
{
    "COUNT_U8",
#if RU_INCLUDE_DESC
    "",
    "Upper 8 bits of 40-bit counter.",
#endif
    UNIMAC_RDP_GRXCF_UPPER_COUNT_U8_FIELD_MASK,
    0,
    UNIMAC_RDP_GRXCF_UPPER_COUNT_U8_FIELD_WIDTH,
    UNIMAC_RDP_GRXCF_UPPER_COUNT_U8_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_GRXPF_COUNT
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_GRXPF_COUNT_FIELD =
{
    "COUNT",
#if RU_INCLUDE_DESC
    "",
    "Receive pause frame packet counter.",
#endif
    UNIMAC_RDP_GRXPF_COUNT_FIELD_MASK,
    0,
    UNIMAC_RDP_GRXPF_COUNT_FIELD_WIDTH,
    UNIMAC_RDP_GRXPF_COUNT_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_GRXPF_UPPER_COUNT_U8
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_GRXPF_UPPER_COUNT_U8_FIELD =
{
    "COUNT_U8",
#if RU_INCLUDE_DESC
    "",
    "Upper 8 bits of 40-bit counter.",
#endif
    UNIMAC_RDP_GRXPF_UPPER_COUNT_U8_FIELD_MASK,
    0,
    UNIMAC_RDP_GRXPF_UPPER_COUNT_U8_FIELD_WIDTH,
    UNIMAC_RDP_GRXPF_UPPER_COUNT_U8_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_GRXUO_COUNT
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_GRXUO_COUNT_FIELD =
{
    "COUNT",
#if RU_INCLUDE_DESC
    "",
    "Receive unknown op code packet counter.",
#endif
    UNIMAC_RDP_GRXUO_COUNT_FIELD_MASK,
    0,
    UNIMAC_RDP_GRXUO_COUNT_FIELD_WIDTH,
    UNIMAC_RDP_GRXUO_COUNT_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_GRXUO_UPPER_COUNT_U8
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_GRXUO_UPPER_COUNT_U8_FIELD =
{
    "COUNT_U8",
#if RU_INCLUDE_DESC
    "",
    "Upper 8 bits of 40-bit counter.",
#endif
    UNIMAC_RDP_GRXUO_UPPER_COUNT_U8_FIELD_MASK,
    0,
    UNIMAC_RDP_GRXUO_UPPER_COUNT_U8_FIELD_WIDTH,
    UNIMAC_RDP_GRXUO_UPPER_COUNT_U8_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_GRALN_COUNT
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_GRALN_COUNT_FIELD =
{
    "COUNT",
#if RU_INCLUDE_DESC
    "",
    "Receive alignmenet error counter.",
#endif
    UNIMAC_RDP_GRALN_COUNT_FIELD_MASK,
    0,
    UNIMAC_RDP_GRALN_COUNT_FIELD_WIDTH,
    UNIMAC_RDP_GRALN_COUNT_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_GRALN_UPPER_COUNT_U8
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_GRALN_UPPER_COUNT_U8_FIELD =
{
    "COUNT_U8",
#if RU_INCLUDE_DESC
    "",
    "Upper 8 bits of 40-bit counter.",
#endif
    UNIMAC_RDP_GRALN_UPPER_COUNT_U8_FIELD_MASK,
    0,
    UNIMAC_RDP_GRALN_UPPER_COUNT_U8_FIELD_WIDTH,
    UNIMAC_RDP_GRALN_UPPER_COUNT_U8_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_GRFLR_COUNT
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_GRFLR_COUNT_FIELD =
{
    "COUNT",
#if RU_INCLUDE_DESC
    "",
    "Receive frame length out of range counter.",
#endif
    UNIMAC_RDP_GRFLR_COUNT_FIELD_MASK,
    0,
    UNIMAC_RDP_GRFLR_COUNT_FIELD_WIDTH,
    UNIMAC_RDP_GRFLR_COUNT_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_GRFLR_UPPER_COUNT_U8
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_GRFLR_UPPER_COUNT_U8_FIELD =
{
    "COUNT_U8",
#if RU_INCLUDE_DESC
    "",
    "Upper 8 bits of 40-bit counter.",
#endif
    UNIMAC_RDP_GRFLR_UPPER_COUNT_U8_FIELD_MASK,
    0,
    UNIMAC_RDP_GRFLR_UPPER_COUNT_U8_FIELD_WIDTH,
    UNIMAC_RDP_GRFLR_UPPER_COUNT_U8_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_GRCDE_COUNT
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_GRCDE_COUNT_FIELD =
{
    "COUNT",
#if RU_INCLUDE_DESC
    "",
    "Receive code error packet counter.",
#endif
    UNIMAC_RDP_GRCDE_COUNT_FIELD_MASK,
    0,
    UNIMAC_RDP_GRCDE_COUNT_FIELD_WIDTH,
    UNIMAC_RDP_GRCDE_COUNT_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_GRCDE_UPPER_COUNT_U8
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_GRCDE_UPPER_COUNT_U8_FIELD =
{
    "COUNT_U8",
#if RU_INCLUDE_DESC
    "",
    "Upper 8 bits of 40-bit counter.",
#endif
    UNIMAC_RDP_GRCDE_UPPER_COUNT_U8_FIELD_MASK,
    0,
    UNIMAC_RDP_GRCDE_UPPER_COUNT_U8_FIELD_WIDTH,
    UNIMAC_RDP_GRCDE_UPPER_COUNT_U8_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_GRFCR_COUNT
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_GRFCR_COUNT_FIELD =
{
    "COUNT",
#if RU_INCLUDE_DESC
    "",
    "Receive carrier sense error packet counter.",
#endif
    UNIMAC_RDP_GRFCR_COUNT_FIELD_MASK,
    0,
    UNIMAC_RDP_GRFCR_COUNT_FIELD_WIDTH,
    UNIMAC_RDP_GRFCR_COUNT_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_GRFCR_UPPER_COUNT_U8
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_GRFCR_UPPER_COUNT_U8_FIELD =
{
    "COUNT_U8",
#if RU_INCLUDE_DESC
    "",
    "Upper 8 bits of 40-bit counter.",
#endif
    UNIMAC_RDP_GRFCR_UPPER_COUNT_U8_FIELD_MASK,
    0,
    UNIMAC_RDP_GRFCR_UPPER_COUNT_U8_FIELD_WIDTH,
    UNIMAC_RDP_GRFCR_UPPER_COUNT_U8_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_GROVR_COUNT
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_GROVR_COUNT_FIELD =
{
    "COUNT",
#if RU_INCLUDE_DESC
    "",
    "Receive oversize packet counter.",
#endif
    UNIMAC_RDP_GROVR_COUNT_FIELD_MASK,
    0,
    UNIMAC_RDP_GROVR_COUNT_FIELD_WIDTH,
    UNIMAC_RDP_GROVR_COUNT_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_GROVR_UPPER_COUNT_U8
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_GROVR_UPPER_COUNT_U8_FIELD =
{
    "COUNT_U8",
#if RU_INCLUDE_DESC
    "",
    "Upper 8 bits of 40-bit counter.",
#endif
    UNIMAC_RDP_GROVR_UPPER_COUNT_U8_FIELD_MASK,
    0,
    UNIMAC_RDP_GROVR_UPPER_COUNT_U8_FIELD_WIDTH,
    UNIMAC_RDP_GROVR_UPPER_COUNT_U8_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_GRJBR_COUNT
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_GRJBR_COUNT_FIELD =
{
    "COUNT",
#if RU_INCLUDE_DESC
    "",
    "Receive jabber counter.",
#endif
    UNIMAC_RDP_GRJBR_COUNT_FIELD_MASK,
    0,
    UNIMAC_RDP_GRJBR_COUNT_FIELD_WIDTH,
    UNIMAC_RDP_GRJBR_COUNT_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_GRJBR_UPPER_COUNT_U8
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_GRJBR_UPPER_COUNT_U8_FIELD =
{
    "COUNT_U8",
#if RU_INCLUDE_DESC
    "",
    "Upper 8 bits of 40-bit counter.",
#endif
    UNIMAC_RDP_GRJBR_UPPER_COUNT_U8_FIELD_MASK,
    0,
    UNIMAC_RDP_GRJBR_UPPER_COUNT_U8_FIELD_WIDTH,
    UNIMAC_RDP_GRJBR_UPPER_COUNT_U8_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_GRMTUE_COUNT
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_GRMTUE_COUNT_FIELD =
{
    "COUNT",
#if RU_INCLUDE_DESC
    "",
    "Receive MTU error packet counter.",
#endif
    UNIMAC_RDP_GRMTUE_COUNT_FIELD_MASK,
    0,
    UNIMAC_RDP_GRMTUE_COUNT_FIELD_WIDTH,
    UNIMAC_RDP_GRMTUE_COUNT_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_GRMTUE_UPPER_COUNT_U8
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_GRMTUE_UPPER_COUNT_U8_FIELD =
{
    "COUNT_U8",
#if RU_INCLUDE_DESC
    "",
    "Upper 8 bits of 40-bit counter.",
#endif
    UNIMAC_RDP_GRMTUE_UPPER_COUNT_U8_FIELD_MASK,
    0,
    UNIMAC_RDP_GRMTUE_UPPER_COUNT_U8_FIELD_WIDTH,
    UNIMAC_RDP_GRMTUE_UPPER_COUNT_U8_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_GRPOK_COUNT
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_GRPOK_COUNT_FIELD =
{
    "COUNT",
#if RU_INCLUDE_DESC
    "",
    "Receive good packet counter.",
#endif
    UNIMAC_RDP_GRPOK_COUNT_FIELD_MASK,
    0,
    UNIMAC_RDP_GRPOK_COUNT_FIELD_WIDTH,
    UNIMAC_RDP_GRPOK_COUNT_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_GRPOK_UPPER_COUNT_U8
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_GRPOK_UPPER_COUNT_U8_FIELD =
{
    "COUNT_U8",
#if RU_INCLUDE_DESC
    "",
    "Upper 8 bits of 40-bit counter.",
#endif
    UNIMAC_RDP_GRPOK_UPPER_COUNT_U8_FIELD_MASK,
    0,
    UNIMAC_RDP_GRPOK_UPPER_COUNT_U8_FIELD_WIDTH,
    UNIMAC_RDP_GRPOK_UPPER_COUNT_U8_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_GRUC_COUNT
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_GRUC_COUNT_FIELD =
{
    "COUNT",
#if RU_INCLUDE_DESC
    "",
    "Received unicast packet counter.",
#endif
    UNIMAC_RDP_GRUC_COUNT_FIELD_MASK,
    0,
    UNIMAC_RDP_GRUC_COUNT_FIELD_WIDTH,
    UNIMAC_RDP_GRUC_COUNT_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_GRUC_UPPER_COUNT_U8
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_GRUC_UPPER_COUNT_U8_FIELD =
{
    "COUNT_U8",
#if RU_INCLUDE_DESC
    "",
    "Upper 8 bits of 40-bit counter.",
#endif
    UNIMAC_RDP_GRUC_UPPER_COUNT_U8_FIELD_MASK,
    0,
    UNIMAC_RDP_GRUC_UPPER_COUNT_U8_FIELD_WIDTH,
    UNIMAC_RDP_GRUC_UPPER_COUNT_U8_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_GRPPP_COUNT
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_GRPPP_COUNT_FIELD =
{
    "COUNT",
#if RU_INCLUDE_DESC
    "",
    "Receive PPP packet counter.",
#endif
    UNIMAC_RDP_GRPPP_COUNT_FIELD_MASK,
    0,
    UNIMAC_RDP_GRPPP_COUNT_FIELD_WIDTH,
    UNIMAC_RDP_GRPPP_COUNT_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_GRPPP_UPPER_COUNT_U8
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_GRPPP_UPPER_COUNT_U8_FIELD =
{
    "COUNT_U8",
#if RU_INCLUDE_DESC
    "",
    "Upper 8 bits of 40-bit counter.",
#endif
    UNIMAC_RDP_GRPPP_UPPER_COUNT_U8_FIELD_MASK,
    0,
    UNIMAC_RDP_GRPPP_UPPER_COUNT_U8_FIELD_WIDTH,
    UNIMAC_RDP_GRPPP_UPPER_COUNT_U8_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_GRCRC_COUNT
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_GRCRC_COUNT_FIELD =
{
    "COUNT",
#if RU_INCLUDE_DESC
    "",
    "Receive CRC match packet counter.",
#endif
    UNIMAC_RDP_GRCRC_COUNT_FIELD_MASK,
    0,
    UNIMAC_RDP_GRCRC_COUNT_FIELD_WIDTH,
    UNIMAC_RDP_GRCRC_COUNT_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_GRCRC_UPPER_COUNT_U8
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_GRCRC_UPPER_COUNT_U8_FIELD =
{
    "COUNT_U8",
#if RU_INCLUDE_DESC
    "",
    "Upper 8 bits of 40-bit counter.",
#endif
    UNIMAC_RDP_GRCRC_UPPER_COUNT_U8_FIELD_MASK,
    0,
    UNIMAC_RDP_GRCRC_UPPER_COUNT_U8_FIELD_WIDTH,
    UNIMAC_RDP_GRCRC_UPPER_COUNT_U8_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_TR64_COUNT
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_TR64_COUNT_FIELD =
{
    "COUNT",
#if RU_INCLUDE_DESC
    "",
    "Transmit 64 bytes frame counter.",
#endif
    UNIMAC_RDP_TR64_COUNT_FIELD_MASK,
    0,
    UNIMAC_RDP_TR64_COUNT_FIELD_WIDTH,
    UNIMAC_RDP_TR64_COUNT_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_TR64_UPPER_COUNT_U8
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_TR64_UPPER_COUNT_U8_FIELD =
{
    "COUNT_U8",
#if RU_INCLUDE_DESC
    "",
    "Upper 8 bits of 40-bit counter.",
#endif
    UNIMAC_RDP_TR64_UPPER_COUNT_U8_FIELD_MASK,
    0,
    UNIMAC_RDP_TR64_UPPER_COUNT_U8_FIELD_WIDTH,
    UNIMAC_RDP_TR64_UPPER_COUNT_U8_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_TR127_COUNT
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_TR127_COUNT_FIELD =
{
    "COUNT",
#if RU_INCLUDE_DESC
    "",
    "Transmit 65 bytes to 127 bytes frame counter.",
#endif
    UNIMAC_RDP_TR127_COUNT_FIELD_MASK,
    0,
    UNIMAC_RDP_TR127_COUNT_FIELD_WIDTH,
    UNIMAC_RDP_TR127_COUNT_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_TR127_UPPER_COUNT_U8
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_TR127_UPPER_COUNT_U8_FIELD =
{
    "COUNT_U8",
#if RU_INCLUDE_DESC
    "",
    "Upper 8 bits of 40-bit counter.",
#endif
    UNIMAC_RDP_TR127_UPPER_COUNT_U8_FIELD_MASK,
    0,
    UNIMAC_RDP_TR127_UPPER_COUNT_U8_FIELD_WIDTH,
    UNIMAC_RDP_TR127_UPPER_COUNT_U8_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_TR255_COUNT
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_TR255_COUNT_FIELD =
{
    "COUNT",
#if RU_INCLUDE_DESC
    "",
    "Transmit 128 bytes to 255 bytes frame counter.",
#endif
    UNIMAC_RDP_TR255_COUNT_FIELD_MASK,
    0,
    UNIMAC_RDP_TR255_COUNT_FIELD_WIDTH,
    UNIMAC_RDP_TR255_COUNT_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_TR255_UPPER_COUNT_U8
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_TR255_UPPER_COUNT_U8_FIELD =
{
    "COUNT_U8",
#if RU_INCLUDE_DESC
    "",
    "Upper 8 bits of 40-bit counter.",
#endif
    UNIMAC_RDP_TR255_UPPER_COUNT_U8_FIELD_MASK,
    0,
    UNIMAC_RDP_TR255_UPPER_COUNT_U8_FIELD_WIDTH,
    UNIMAC_RDP_TR255_UPPER_COUNT_U8_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_TR511_COUNT
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_TR511_COUNT_FIELD =
{
    "COUNT",
#if RU_INCLUDE_DESC
    "",
    "Transmit 256 bytes to 511 bytes frame counter.",
#endif
    UNIMAC_RDP_TR511_COUNT_FIELD_MASK,
    0,
    UNIMAC_RDP_TR511_COUNT_FIELD_WIDTH,
    UNIMAC_RDP_TR511_COUNT_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_TR511_UPPER_COUNT_U8
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_TR511_UPPER_COUNT_U8_FIELD =
{
    "COUNT_U8",
#if RU_INCLUDE_DESC
    "",
    "Upper 8 bits of 40-bit counter.",
#endif
    UNIMAC_RDP_TR511_UPPER_COUNT_U8_FIELD_MASK,
    0,
    UNIMAC_RDP_TR511_UPPER_COUNT_U8_FIELD_WIDTH,
    UNIMAC_RDP_TR511_UPPER_COUNT_U8_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_TR1023_COUNT
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_TR1023_COUNT_FIELD =
{
    "COUNT",
#if RU_INCLUDE_DESC
    "",
    "Transmit 512 bytes to 1023 bytes frame counter.",
#endif
    UNIMAC_RDP_TR1023_COUNT_FIELD_MASK,
    0,
    UNIMAC_RDP_TR1023_COUNT_FIELD_WIDTH,
    UNIMAC_RDP_TR1023_COUNT_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_TR1023_UPPER_COUNT_U8
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_TR1023_UPPER_COUNT_U8_FIELD =
{
    "COUNT_U8",
#if RU_INCLUDE_DESC
    "",
    "Upper 8 bits of 40-bit counter.",
#endif
    UNIMAC_RDP_TR1023_UPPER_COUNT_U8_FIELD_MASK,
    0,
    UNIMAC_RDP_TR1023_UPPER_COUNT_U8_FIELD_WIDTH,
    UNIMAC_RDP_TR1023_UPPER_COUNT_U8_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_TR1518_COUNT
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_TR1518_COUNT_FIELD =
{
    "COUNT",
#if RU_INCLUDE_DESC
    "",
    "Transmit 1024 bytes to 1518 bytes frame counter.",
#endif
    UNIMAC_RDP_TR1518_COUNT_FIELD_MASK,
    0,
    UNIMAC_RDP_TR1518_COUNT_FIELD_WIDTH,
    UNIMAC_RDP_TR1518_COUNT_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_TR1518_UPPER_COUNT_U8
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_TR1518_UPPER_COUNT_U8_FIELD =
{
    "COUNT_U8",
#if RU_INCLUDE_DESC
    "",
    "Upper 8 bits of 40-bit counter.",
#endif
    UNIMAC_RDP_TR1518_UPPER_COUNT_U8_FIELD_MASK,
    0,
    UNIMAC_RDP_TR1518_UPPER_COUNT_U8_FIELD_WIDTH,
    UNIMAC_RDP_TR1518_UPPER_COUNT_U8_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_TRMGV_COUNT
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_TRMGV_COUNT_FIELD =
{
    "COUNT",
#if RU_INCLUDE_DESC
    "",
    "Transmit 1519 bytes to 1522 bytes good VLAN frame counter.",
#endif
    UNIMAC_RDP_TRMGV_COUNT_FIELD_MASK,
    0,
    UNIMAC_RDP_TRMGV_COUNT_FIELD_WIDTH,
    UNIMAC_RDP_TRMGV_COUNT_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_TRMGV_UPPER_COUNT_U8
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_TRMGV_UPPER_COUNT_U8_FIELD =
{
    "COUNT_U8",
#if RU_INCLUDE_DESC
    "",
    "Upper 8 bits of 40-bit counter.",
#endif
    UNIMAC_RDP_TRMGV_UPPER_COUNT_U8_FIELD_MASK,
    0,
    UNIMAC_RDP_TRMGV_UPPER_COUNT_U8_FIELD_WIDTH,
    UNIMAC_RDP_TRMGV_UPPER_COUNT_U8_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_TR2047_COUNT
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_TR2047_COUNT_FIELD =
{
    "COUNT",
#if RU_INCLUDE_DESC
    "",
    "Transmit 1519 bytes to 2047 bytes Frame Counter.",
#endif
    UNIMAC_RDP_TR2047_COUNT_FIELD_MASK,
    0,
    UNIMAC_RDP_TR2047_COUNT_FIELD_WIDTH,
    UNIMAC_RDP_TR2047_COUNT_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_TR2047_UPPER_COUNT_U8
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_TR2047_UPPER_COUNT_U8_FIELD =
{
    "COUNT_U8",
#if RU_INCLUDE_DESC
    "",
    "Upper 8 bits of 40-bit counter.",
#endif
    UNIMAC_RDP_TR2047_UPPER_COUNT_U8_FIELD_MASK,
    0,
    UNIMAC_RDP_TR2047_UPPER_COUNT_U8_FIELD_WIDTH,
    UNIMAC_RDP_TR2047_UPPER_COUNT_U8_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_TR4095_COUNT
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_TR4095_COUNT_FIELD =
{
    "COUNT",
#if RU_INCLUDE_DESC
    "",
    "Transmit 2048 bytes to 4095 bytes frame counter.",
#endif
    UNIMAC_RDP_TR4095_COUNT_FIELD_MASK,
    0,
    UNIMAC_RDP_TR4095_COUNT_FIELD_WIDTH,
    UNIMAC_RDP_TR4095_COUNT_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_TR4095_UPPER_COUNT_U8
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_TR4095_UPPER_COUNT_U8_FIELD =
{
    "COUNT_U8",
#if RU_INCLUDE_DESC
    "",
    "Upper 8 bits of 40-bit counter.",
#endif
    UNIMAC_RDP_TR4095_UPPER_COUNT_U8_FIELD_MASK,
    0,
    UNIMAC_RDP_TR4095_UPPER_COUNT_U8_FIELD_WIDTH,
    UNIMAC_RDP_TR4095_UPPER_COUNT_U8_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_TR9216_COUNT
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_TR9216_COUNT_FIELD =
{
    "COUNT",
#if RU_INCLUDE_DESC
    "",
    "Transmit 4096 bytes to 9216 bytes Frame Counter.",
#endif
    UNIMAC_RDP_TR9216_COUNT_FIELD_MASK,
    0,
    UNIMAC_RDP_TR9216_COUNT_FIELD_WIDTH,
    UNIMAC_RDP_TR9216_COUNT_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_TR9216_UPPER_COUNT_U8
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_TR9216_UPPER_COUNT_U8_FIELD =
{
    "COUNT_U8",
#if RU_INCLUDE_DESC
    "",
    "Upper 8 bits of 40-bit counter.",
#endif
    UNIMAC_RDP_TR9216_UPPER_COUNT_U8_FIELD_MASK,
    0,
    UNIMAC_RDP_TR9216_UPPER_COUNT_U8_FIELD_WIDTH,
    UNIMAC_RDP_TR9216_UPPER_COUNT_U8_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_GTPKT_COUNT
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_GTPKT_COUNT_FIELD =
{
    "COUNT",
#if RU_INCLUDE_DESC
    "",
    "Transmit packet counter.",
#endif
    UNIMAC_RDP_GTPKT_COUNT_FIELD_MASK,
    0,
    UNIMAC_RDP_GTPKT_COUNT_FIELD_WIDTH,
    UNIMAC_RDP_GTPKT_COUNT_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_GTPKT_UPPER_COUNT_U8
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_GTPKT_UPPER_COUNT_U8_FIELD =
{
    "COUNT_U8",
#if RU_INCLUDE_DESC
    "",
    "Upper 8 bits of 40-bit counter.",
#endif
    UNIMAC_RDP_GTPKT_UPPER_COUNT_U8_FIELD_MASK,
    0,
    UNIMAC_RDP_GTPKT_UPPER_COUNT_U8_FIELD_WIDTH,
    UNIMAC_RDP_GTPKT_UPPER_COUNT_U8_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_GTMCA_COUNT
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_GTMCA_COUNT_FIELD =
{
    "COUNT",
#if RU_INCLUDE_DESC
    "",
    "Transmit multicast packet counter.",
#endif
    UNIMAC_RDP_GTMCA_COUNT_FIELD_MASK,
    0,
    UNIMAC_RDP_GTMCA_COUNT_FIELD_WIDTH,
    UNIMAC_RDP_GTMCA_COUNT_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_GTMCA_UPPER_COUNT_U8
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_GTMCA_UPPER_COUNT_U8_FIELD =
{
    "COUNT_U8",
#if RU_INCLUDE_DESC
    "",
    "Upper 8 bits of 40-bit counter.",
#endif
    UNIMAC_RDP_GTMCA_UPPER_COUNT_U8_FIELD_MASK,
    0,
    UNIMAC_RDP_GTMCA_UPPER_COUNT_U8_FIELD_WIDTH,
    UNIMAC_RDP_GTMCA_UPPER_COUNT_U8_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_GTBCA_COUNT
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_GTBCA_COUNT_FIELD =
{
    "COUNT",
#if RU_INCLUDE_DESC
    "",
    "Transmit broadcast packet counter.",
#endif
    UNIMAC_RDP_GTBCA_COUNT_FIELD_MASK,
    0,
    UNIMAC_RDP_GTBCA_COUNT_FIELD_WIDTH,
    UNIMAC_RDP_GTBCA_COUNT_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_GTBCA_UPPER_COUNT_U8
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_GTBCA_UPPER_COUNT_U8_FIELD =
{
    "COUNT_U8",
#if RU_INCLUDE_DESC
    "",
    "Upper 8 bits of 40-bit counter.",
#endif
    UNIMAC_RDP_GTBCA_UPPER_COUNT_U8_FIELD_MASK,
    0,
    UNIMAC_RDP_GTBCA_UPPER_COUNT_U8_FIELD_WIDTH,
    UNIMAC_RDP_GTBCA_UPPER_COUNT_U8_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_GTXPF_COUNT
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_GTXPF_COUNT_FIELD =
{
    "COUNT",
#if RU_INCLUDE_DESC
    "",
    "Transmit pause frame packet counter.",
#endif
    UNIMAC_RDP_GTXPF_COUNT_FIELD_MASK,
    0,
    UNIMAC_RDP_GTXPF_COUNT_FIELD_WIDTH,
    UNIMAC_RDP_GTXPF_COUNT_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_GTXPF_UPPER_COUNT_U8
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_GTXPF_UPPER_COUNT_U8_FIELD =
{
    "COUNT_U8",
#if RU_INCLUDE_DESC
    "",
    "Upper 8 bits of 40-bit counter.",
#endif
    UNIMAC_RDP_GTXPF_UPPER_COUNT_U8_FIELD_MASK,
    0,
    UNIMAC_RDP_GTXPF_UPPER_COUNT_U8_FIELD_WIDTH,
    UNIMAC_RDP_GTXPF_UPPER_COUNT_U8_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_GTXCF_COUNT
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_GTXCF_COUNT_FIELD =
{
    "COUNT",
#if RU_INCLUDE_DESC
    "",
    "Transmit control frame packet counter.",
#endif
    UNIMAC_RDP_GTXCF_COUNT_FIELD_MASK,
    0,
    UNIMAC_RDP_GTXCF_COUNT_FIELD_WIDTH,
    UNIMAC_RDP_GTXCF_COUNT_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_GTXCF_UPPER_COUNT_U8
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_GTXCF_UPPER_COUNT_U8_FIELD =
{
    "COUNT_U8",
#if RU_INCLUDE_DESC
    "",
    "Upper 8 bits of 40-bit counter.",
#endif
    UNIMAC_RDP_GTXCF_UPPER_COUNT_U8_FIELD_MASK,
    0,
    UNIMAC_RDP_GTXCF_UPPER_COUNT_U8_FIELD_WIDTH,
    UNIMAC_RDP_GTXCF_UPPER_COUNT_U8_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_GTFCS_COUNT
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_GTFCS_COUNT_FIELD =
{
    "COUNT",
#if RU_INCLUDE_DESC
    "",
    "Transmit FCS error counter.",
#endif
    UNIMAC_RDP_GTFCS_COUNT_FIELD_MASK,
    0,
    UNIMAC_RDP_GTFCS_COUNT_FIELD_WIDTH,
    UNIMAC_RDP_GTFCS_COUNT_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_GTFCS_UPPER_COUNT_U8
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_GTFCS_UPPER_COUNT_U8_FIELD =
{
    "COUNT_U8",
#if RU_INCLUDE_DESC
    "",
    "Upper 8 bits of 40-bit counter.",
#endif
    UNIMAC_RDP_GTFCS_UPPER_COUNT_U8_FIELD_MASK,
    0,
    UNIMAC_RDP_GTFCS_UPPER_COUNT_U8_FIELD_WIDTH,
    UNIMAC_RDP_GTFCS_UPPER_COUNT_U8_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_GTOVR_COUNT
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_GTOVR_COUNT_FIELD =
{
    "COUNT",
#if RU_INCLUDE_DESC
    "",
    "Transmit oversize packet counter.",
#endif
    UNIMAC_RDP_GTOVR_COUNT_FIELD_MASK,
    0,
    UNIMAC_RDP_GTOVR_COUNT_FIELD_WIDTH,
    UNIMAC_RDP_GTOVR_COUNT_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_GTOVR_UPPER_COUNT_U8
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_GTOVR_UPPER_COUNT_U8_FIELD =
{
    "COUNT_U8",
#if RU_INCLUDE_DESC
    "",
    "Upper 8 bits of 40-bit counter.",
#endif
    UNIMAC_RDP_GTOVR_UPPER_COUNT_U8_FIELD_MASK,
    0,
    UNIMAC_RDP_GTOVR_UPPER_COUNT_U8_FIELD_WIDTH,
    UNIMAC_RDP_GTOVR_UPPER_COUNT_U8_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_GTDRF_COUNT
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_GTDRF_COUNT_FIELD =
{
    "COUNT",
#if RU_INCLUDE_DESC
    "",
    "Transmit deferral packet counter.",
#endif
    UNIMAC_RDP_GTDRF_COUNT_FIELD_MASK,
    0,
    UNIMAC_RDP_GTDRF_COUNT_FIELD_WIDTH,
    UNIMAC_RDP_GTDRF_COUNT_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_GTDRF_UPPER_COUNT_U8
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_GTDRF_UPPER_COUNT_U8_FIELD =
{
    "COUNT_U8",
#if RU_INCLUDE_DESC
    "",
    "Upper 8 bits of 40-bit counter.",
#endif
    UNIMAC_RDP_GTDRF_UPPER_COUNT_U8_FIELD_MASK,
    0,
    UNIMAC_RDP_GTDRF_UPPER_COUNT_U8_FIELD_WIDTH,
    UNIMAC_RDP_GTDRF_UPPER_COUNT_U8_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_GTEDF_COUNT
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_GTEDF_COUNT_FIELD =
{
    "COUNT",
#if RU_INCLUDE_DESC
    "",
    "Transmit excessive deferral packet counter.",
#endif
    UNIMAC_RDP_GTEDF_COUNT_FIELD_MASK,
    0,
    UNIMAC_RDP_GTEDF_COUNT_FIELD_WIDTH,
    UNIMAC_RDP_GTEDF_COUNT_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_GTEDF_UPPER_COUNT_U8
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_GTEDF_UPPER_COUNT_U8_FIELD =
{
    "COUNT_U8",
#if RU_INCLUDE_DESC
    "",
    "Upper 8 bits of 40-bit counter.",
#endif
    UNIMAC_RDP_GTEDF_UPPER_COUNT_U8_FIELD_MASK,
    0,
    UNIMAC_RDP_GTEDF_UPPER_COUNT_U8_FIELD_WIDTH,
    UNIMAC_RDP_GTEDF_UPPER_COUNT_U8_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_GTSCL_COUNT
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_GTSCL_COUNT_FIELD =
{
    "COUNT",
#if RU_INCLUDE_DESC
    "",
    "Transmit single collision packet counter.",
#endif
    UNIMAC_RDP_GTSCL_COUNT_FIELD_MASK,
    0,
    UNIMAC_RDP_GTSCL_COUNT_FIELD_WIDTH,
    UNIMAC_RDP_GTSCL_COUNT_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_GTSCL_UPPER_COUNT_U8
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_GTSCL_UPPER_COUNT_U8_FIELD =
{
    "COUNT_U8",
#if RU_INCLUDE_DESC
    "",
    "Upper 8 bits of 40-bit counter.",
#endif
    UNIMAC_RDP_GTSCL_UPPER_COUNT_U8_FIELD_MASK,
    0,
    UNIMAC_RDP_GTSCL_UPPER_COUNT_U8_FIELD_WIDTH,
    UNIMAC_RDP_GTSCL_UPPER_COUNT_U8_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_GTMCL_COUNT
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_GTMCL_COUNT_FIELD =
{
    "COUNT",
#if RU_INCLUDE_DESC
    "",
    "Transmit multiple collision packet counter.",
#endif
    UNIMAC_RDP_GTMCL_COUNT_FIELD_MASK,
    0,
    UNIMAC_RDP_GTMCL_COUNT_FIELD_WIDTH,
    UNIMAC_RDP_GTMCL_COUNT_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_GTMCL_UPPER_COUNT_U8
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_GTMCL_UPPER_COUNT_U8_FIELD =
{
    "COUNT_U8",
#if RU_INCLUDE_DESC
    "",
    "Upper 8 bits of 40-bit counter.",
#endif
    UNIMAC_RDP_GTMCL_UPPER_COUNT_U8_FIELD_MASK,
    0,
    UNIMAC_RDP_GTMCL_UPPER_COUNT_U8_FIELD_WIDTH,
    UNIMAC_RDP_GTMCL_UPPER_COUNT_U8_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_GTLCL_COUNT
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_GTLCL_COUNT_FIELD =
{
    "COUNT",
#if RU_INCLUDE_DESC
    "",
    "Transmit late collision packet counter.",
#endif
    UNIMAC_RDP_GTLCL_COUNT_FIELD_MASK,
    0,
    UNIMAC_RDP_GTLCL_COUNT_FIELD_WIDTH,
    UNIMAC_RDP_GTLCL_COUNT_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_GTLCL_UPPER_COUNT_U8
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_GTLCL_UPPER_COUNT_U8_FIELD =
{
    "COUNT_U8",
#if RU_INCLUDE_DESC
    "",
    "Upper 8 bits of 40-bit counter.",
#endif
    UNIMAC_RDP_GTLCL_UPPER_COUNT_U8_FIELD_MASK,
    0,
    UNIMAC_RDP_GTLCL_UPPER_COUNT_U8_FIELD_WIDTH,
    UNIMAC_RDP_GTLCL_UPPER_COUNT_U8_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_GTXCL_COUNT
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_GTXCL_COUNT_FIELD =
{
    "COUNT",
#if RU_INCLUDE_DESC
    "",
    "Transmit excessive collision packet counter.",
#endif
    UNIMAC_RDP_GTXCL_COUNT_FIELD_MASK,
    0,
    UNIMAC_RDP_GTXCL_COUNT_FIELD_WIDTH,
    UNIMAC_RDP_GTXCL_COUNT_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_GTXCL_UPPER_COUNT_U8
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_GTXCL_UPPER_COUNT_U8_FIELD =
{
    "COUNT_U8",
#if RU_INCLUDE_DESC
    "",
    "Upper 8 bits of 40-bit counter.",
#endif
    UNIMAC_RDP_GTXCL_UPPER_COUNT_U8_FIELD_MASK,
    0,
    UNIMAC_RDP_GTXCL_UPPER_COUNT_U8_FIELD_WIDTH,
    UNIMAC_RDP_GTXCL_UPPER_COUNT_U8_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_GTFRG_COUNT
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_GTFRG_COUNT_FIELD =
{
    "COUNT",
#if RU_INCLUDE_DESC
    "",
    "Transmit fragments packet counter.",
#endif
    UNIMAC_RDP_GTFRG_COUNT_FIELD_MASK,
    0,
    UNIMAC_RDP_GTFRG_COUNT_FIELD_WIDTH,
    UNIMAC_RDP_GTFRG_COUNT_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_GTFRG_UPPER_COUNT_U8
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_GTFRG_UPPER_COUNT_U8_FIELD =
{
    "COUNT_U8",
#if RU_INCLUDE_DESC
    "",
    "Upper 8 bits of 40-bit counter.",
#endif
    UNIMAC_RDP_GTFRG_UPPER_COUNT_U8_FIELD_MASK,
    0,
    UNIMAC_RDP_GTFRG_UPPER_COUNT_U8_FIELD_WIDTH,
    UNIMAC_RDP_GTFRG_UPPER_COUNT_U8_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_GTNCL_COUNT
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_GTNCL_COUNT_FIELD =
{
    "COUNT",
#if RU_INCLUDE_DESC
    "",
    "Transmit total collision counter.",
#endif
    UNIMAC_RDP_GTNCL_COUNT_FIELD_MASK,
    0,
    UNIMAC_RDP_GTNCL_COUNT_FIELD_WIDTH,
    UNIMAC_RDP_GTNCL_COUNT_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_GTNCL_UPPER_COUNT_U8
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_GTNCL_UPPER_COUNT_U8_FIELD =
{
    "COUNT_U8",
#if RU_INCLUDE_DESC
    "",
    "Upper 8 bits of 40-bit counter.",
#endif
    UNIMAC_RDP_GTNCL_UPPER_COUNT_U8_FIELD_MASK,
    0,
    UNIMAC_RDP_GTNCL_UPPER_COUNT_U8_FIELD_WIDTH,
    UNIMAC_RDP_GTNCL_UPPER_COUNT_U8_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_GTJBR_COUNT
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_GTJBR_COUNT_FIELD =
{
    "COUNT",
#if RU_INCLUDE_DESC
    "",
    "Transmit jabber counter.",
#endif
    UNIMAC_RDP_GTJBR_COUNT_FIELD_MASK,
    0,
    UNIMAC_RDP_GTJBR_COUNT_FIELD_WIDTH,
    UNIMAC_RDP_GTJBR_COUNT_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_GTJBR_UPPER_COUNT_U8
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_GTJBR_UPPER_COUNT_U8_FIELD =
{
    "COUNT_U8",
#if RU_INCLUDE_DESC
    "",
    "Upper 8 bits of 40-bit counter.",
#endif
    UNIMAC_RDP_GTJBR_UPPER_COUNT_U8_FIELD_MASK,
    0,
    UNIMAC_RDP_GTJBR_UPPER_COUNT_U8_FIELD_WIDTH,
    UNIMAC_RDP_GTJBR_UPPER_COUNT_U8_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_GTBYT_COUNT
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_GTBYT_COUNT_FIELD =
{
    "COUNT",
#if RU_INCLUDE_DESC
    "",
    "Transmit byte counter.",
#endif
    UNIMAC_RDP_GTBYT_COUNT_FIELD_MASK,
    0,
    UNIMAC_RDP_GTBYT_COUNT_FIELD_WIDTH,
    UNIMAC_RDP_GTBYT_COUNT_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_GTBYT_UPPER_COUNT_U16
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_GTBYT_UPPER_COUNT_U16_FIELD =
{
    "COUNT_U16",
#if RU_INCLUDE_DESC
    "",
    "Upper 16 bits of 48-bit counter.",
#endif
    UNIMAC_RDP_GTBYT_UPPER_COUNT_U16_FIELD_MASK,
    0,
    UNIMAC_RDP_GTBYT_UPPER_COUNT_U16_FIELD_WIDTH,
    UNIMAC_RDP_GTBYT_UPPER_COUNT_U16_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_GTPOK_COUNT
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_GTPOK_COUNT_FIELD =
{
    "COUNT",
#if RU_INCLUDE_DESC
    "",
    "Transmitted good packets counter.",
#endif
    UNIMAC_RDP_GTPOK_COUNT_FIELD_MASK,
    0,
    UNIMAC_RDP_GTPOK_COUNT_FIELD_WIDTH,
    UNIMAC_RDP_GTPOK_COUNT_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_GTPOK_UPPER_COUNT_U8
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_GTPOK_UPPER_COUNT_U8_FIELD =
{
    "COUNT_U8",
#if RU_INCLUDE_DESC
    "",
    "Upper 8 bits of 40-bit counter.",
#endif
    UNIMAC_RDP_GTPOK_UPPER_COUNT_U8_FIELD_MASK,
    0,
    UNIMAC_RDP_GTPOK_UPPER_COUNT_U8_FIELD_WIDTH,
    UNIMAC_RDP_GTPOK_UPPER_COUNT_U8_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_GTUC_COUNT
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_GTUC_COUNT_FIELD =
{
    "COUNT",
#if RU_INCLUDE_DESC
    "",
    "Transmitted Unicast packets counter.",
#endif
    UNIMAC_RDP_GTUC_COUNT_FIELD_MASK,
    0,
    UNIMAC_RDP_GTUC_COUNT_FIELD_WIDTH,
    UNIMAC_RDP_GTUC_COUNT_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_GTUC_UPPER_COUNT_U8
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_GTUC_UPPER_COUNT_U8_FIELD =
{
    "COUNT_U8",
#if RU_INCLUDE_DESC
    "",
    "Upper 8 bits of 40-bit counter.",
#endif
    UNIMAC_RDP_GTUC_UPPER_COUNT_U8_FIELD_MASK,
    0,
    UNIMAC_RDP_GTUC_UPPER_COUNT_U8_FIELD_WIDTH,
    UNIMAC_RDP_GTUC_UPPER_COUNT_U8_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_RRPKT_COUNT
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_RRPKT_COUNT_FIELD =
{
    "COUNT",
#if RU_INCLUDE_DESC
    "",
    "RX RUNT packet counter.",
#endif
    UNIMAC_RDP_RRPKT_COUNT_FIELD_MASK,
    0,
    UNIMAC_RDP_RRPKT_COUNT_FIELD_WIDTH,
    UNIMAC_RDP_RRPKT_COUNT_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_RRPKT_UPPER_COUNT_U8
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_RRPKT_UPPER_COUNT_U8_FIELD =
{
    "COUNT_U8",
#if RU_INCLUDE_DESC
    "",
    "Upper 8 bits of 40-bit counter.",
#endif
    UNIMAC_RDP_RRPKT_UPPER_COUNT_U8_FIELD_MASK,
    0,
    UNIMAC_RDP_RRPKT_UPPER_COUNT_U8_FIELD_WIDTH,
    UNIMAC_RDP_RRPKT_UPPER_COUNT_U8_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_RRUND_COUNT
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_RRUND_COUNT_FIELD =
{
    "COUNT",
#if RU_INCLUDE_DESC
    "",
    "RX RUNT packet with valid FCS counter.",
#endif
    UNIMAC_RDP_RRUND_COUNT_FIELD_MASK,
    0,
    UNIMAC_RDP_RRUND_COUNT_FIELD_WIDTH,
    UNIMAC_RDP_RRUND_COUNT_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_RRUND_UPPER_COUNT_U8
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_RRUND_UPPER_COUNT_U8_FIELD =
{
    "COUNT_U8",
#if RU_INCLUDE_DESC
    "",
    "Upper 8 bits of 40-bit counter.",
#endif
    UNIMAC_RDP_RRUND_UPPER_COUNT_U8_FIELD_MASK,
    0,
    UNIMAC_RDP_RRUND_UPPER_COUNT_U8_FIELD_WIDTH,
    UNIMAC_RDP_RRUND_UPPER_COUNT_U8_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_RRFRG_COUNT
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_RRFRG_COUNT_FIELD =
{
    "COUNT",
#if RU_INCLUDE_DESC
    "",
    "RX RUNT packet with invalid FCS or alignment error counter.",
#endif
    UNIMAC_RDP_RRFRG_COUNT_FIELD_MASK,
    0,
    UNIMAC_RDP_RRFRG_COUNT_FIELD_WIDTH,
    UNIMAC_RDP_RRFRG_COUNT_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_RRFRG_UPPER_COUNT_U8
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_RRFRG_UPPER_COUNT_U8_FIELD =
{
    "COUNT_U8",
#if RU_INCLUDE_DESC
    "",
    "Upper 8 bits of 40-bit counter.",
#endif
    UNIMAC_RDP_RRFRG_UPPER_COUNT_U8_FIELD_MASK,
    0,
    UNIMAC_RDP_RRFRG_UPPER_COUNT_U8_FIELD_WIDTH,
    UNIMAC_RDP_RRFRG_UPPER_COUNT_U8_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_RRBYT_COUNT
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_RRBYT_COUNT_FIELD =
{
    "COUNT",
#if RU_INCLUDE_DESC
    "",
    "RX RUNT packet byte counter.",
#endif
    UNIMAC_RDP_RRBYT_COUNT_FIELD_MASK,
    0,
    UNIMAC_RDP_RRBYT_COUNT_FIELD_WIDTH,
    UNIMAC_RDP_RRBYT_COUNT_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_RRBYT_UPPER_COUNT_U16
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_RRBYT_UPPER_COUNT_U16_FIELD =
{
    "COUNT_U16",
#if RU_INCLUDE_DESC
    "",
    "Upper 16 bits of 48-bit counter.",
#endif
    UNIMAC_RDP_RRBYT_UPPER_COUNT_U16_FIELD_MASK,
    0,
    UNIMAC_RDP_RRBYT_UPPER_COUNT_U16_FIELD_WIDTH,
    UNIMAC_RDP_RRBYT_UPPER_COUNT_U16_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_MIB_CNTRL_RESERVED0
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_MIB_CNTRL_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    UNIMAC_RDP_MIB_CNTRL_RESERVED0_FIELD_MASK,
    0,
    UNIMAC_RDP_MIB_CNTRL_RESERVED0_FIELD_WIDTH,
    UNIMAC_RDP_MIB_CNTRL_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_MIB_CNTRL_TX_CNT_RST
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_MIB_CNTRL_TX_CNT_RST_FIELD =
{
    "TX_CNT_RST",
#if RU_INCLUDE_DESC
    "",
    "Active high. When this bit is set, TX statistics counters will be reseted.",
#endif
    UNIMAC_RDP_MIB_CNTRL_TX_CNT_RST_FIELD_MASK,
    0,
    UNIMAC_RDP_MIB_CNTRL_TX_CNT_RST_FIELD_WIDTH,
    UNIMAC_RDP_MIB_CNTRL_TX_CNT_RST_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_MIB_CNTRL_RUNT_CNT_RST
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_MIB_CNTRL_RUNT_CNT_RST_FIELD =
{
    "RUNT_CNT_RST",
#if RU_INCLUDE_DESC
    "",
    "Active high. When this bit is set, Runt statistics counters will be reseted.",
#endif
    UNIMAC_RDP_MIB_CNTRL_RUNT_CNT_RST_FIELD_MASK,
    0,
    UNIMAC_RDP_MIB_CNTRL_RUNT_CNT_RST_FIELD_WIDTH,
    UNIMAC_RDP_MIB_CNTRL_RUNT_CNT_RST_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_MIB_CNTRL_RX_CNT_RST
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_MIB_CNTRL_RX_CNT_RST_FIELD =
{
    "RX_CNT_RST",
#if RU_INCLUDE_DESC
    "",
    "Active high. When this bit is set, RX statistics counters will be reseted.",
#endif
    UNIMAC_RDP_MIB_CNTRL_RX_CNT_RST_FIELD_MASK,
    0,
    UNIMAC_RDP_MIB_CNTRL_RX_CNT_RST_FIELD_WIDTH,
    UNIMAC_RDP_MIB_CNTRL_RX_CNT_RST_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_MIB_READ_DATA_DATA32
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_MIB_READ_DATA_DATA32_FIELD =
{
    "DATA32",
#if RU_INCLUDE_DESC
    "",
    "32-bit data holder.",
#endif
    UNIMAC_RDP_MIB_READ_DATA_DATA32_FIELD_MASK,
    0,
    UNIMAC_RDP_MIB_READ_DATA_DATA32_FIELD_WIDTH,
    UNIMAC_RDP_MIB_READ_DATA_DATA32_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_MIB_WRITE_DATA_DATA32
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_MIB_WRITE_DATA_DATA32_FIELD =
{
    "DATA32",
#if RU_INCLUDE_DESC
    "",
    "32-bit data holder.",
#endif
    UNIMAC_RDP_MIB_WRITE_DATA_DATA32_FIELD_MASK,
    0,
    UNIMAC_RDP_MIB_WRITE_DATA_DATA32_FIELD_WIDTH,
    UNIMAC_RDP_MIB_WRITE_DATA_DATA32_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_PSW_MS_RESERVED0
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_PSW_MS_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    UNIMAC_RDP_PSW_MS_RESERVED0_FIELD_MASK,
    0,
    UNIMAC_RDP_PSW_MS_RESERVED0_FIELD_WIDTH,
    UNIMAC_RDP_PSW_MS_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_PSW_MS_PSW_47_32
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_PSW_MS_PSW_47_32_FIELD =
{
    "PSW_47_32",
#if RU_INCLUDE_DESC
    "",
    "Magic Packet Optional password bytes 0-1 (password bits [47:32])."
    "Bits [47:40] correspond to password byte 0, which is the first password byte received from the wire.",
#endif
    UNIMAC_RDP_PSW_MS_PSW_47_32_FIELD_MASK,
    0,
    UNIMAC_RDP_PSW_MS_PSW_47_32_FIELD_WIDTH,
    UNIMAC_RDP_PSW_MS_PSW_47_32_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_PSW_LS_PSW_31_0
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_PSW_LS_PSW_31_0_FIELD =
{
    "PSW_31_0",
#if RU_INCLUDE_DESC
    "",
    "Magic Packet Optional Password bytes 2-5 (password bits [31:0]).",
#endif
    UNIMAC_RDP_PSW_LS_PSW_31_0_FIELD_MASK,
    0,
    UNIMAC_RDP_PSW_LS_PSW_31_0_FIELD_WIDTH,
    UNIMAC_RDP_PSW_LS_PSW_31_0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_CONTROL_AUTOCONFIG_EN
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_CONTROL_AUTOCONFIG_EN_FIELD =
{
    "AUTOCONFIG_EN",
#if RU_INCLUDE_DESC
    "",
    "When set XIB will set N and M for clock swallower automatically based on the XGMII clock/data rate."
    "Note: This is only applicable to case when the internal serdes is source of the clock used to generate XIB?s GMII clocks."
    "Note: The default is the value to which i_autoconfig_en_strap is tied.",
#endif
    UNIMAC_RDP_CONTROL_AUTOCONFIG_EN_FIELD_MASK,
    0,
    UNIMAC_RDP_CONTROL_AUTOCONFIG_EN_FIELD_WIDTH,
    UNIMAC_RDP_CONTROL_AUTOCONFIG_EN_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_CONTROL_GMII_TX_CLK_GATE_EN
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_CONTROL_GMII_TX_CLK_GATE_EN_FIELD =
{
    "GMII_TX_CLK_GATE_EN",
#if RU_INCLUDE_DESC
    "",
    "When set XIB will gate GMII TX clock if the TX FIFO occupancy becomes greater or equal to its XOFF threshold. It will re-enable the clock when the TX FIFO occupancy is equal or below its XON threshold."
    "Should not be enabled when TX_BACKPRESSURE_EN = 1.",
#endif
    UNIMAC_RDP_CONTROL_GMII_TX_CLK_GATE_EN_FIELD_MASK,
    0,
    UNIMAC_RDP_CONTROL_GMII_TX_CLK_GATE_EN_FIELD_WIDTH,
    UNIMAC_RDP_CONTROL_GMII_TX_CLK_GATE_EN_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_CONTROL_XGMII_SEL_OVRD
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_CONTROL_XGMII_SEL_OVRD_FIELD =
{
    "XGMII_SEL_OVRD",
#if RU_INCLUDE_DESC
    "",
    "When set enables XGMII_SEL to select XIB PHY interface. When 0 interface is selected based on the HW pin.",
#endif
    UNIMAC_RDP_CONTROL_XGMII_SEL_OVRD_FIELD_MASK,
    0,
    UNIMAC_RDP_CONTROL_XGMII_SEL_OVRD_FIELD_WIDTH,
    UNIMAC_RDP_CONTROL_XGMII_SEL_OVRD_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_CONTROL_MIN_RX_IPG
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_CONTROL_MIN_RX_IPG_FIELD =
{
    "MIN_RX_IPG",
#if RU_INCLUDE_DESC
    "",
    "This value guaranties minimum IPG between any two of received packets. When set to 0 minimum RX IPG is not enforced that is it equals XGMII IPG (plus/minus IDLEs inserted/deleted in clock compensation purposes).",
#endif
    UNIMAC_RDP_CONTROL_MIN_RX_IPG_FIELD_MASK,
    0,
    UNIMAC_RDP_CONTROL_MIN_RX_IPG_FIELD_WIDTH,
    UNIMAC_RDP_CONTROL_MIN_RX_IPG_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_CONTROL_TX_IPG
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_CONTROL_TX_IPG_FIELD =
{
    "TX_IPG",
#if RU_INCLUDE_DESC
    "",
    "An average number of XGMII IDLE characters that will be inserted between two packets on TX. The actual number of IDLEs between any two packets can be larger or smaller than this number, depending on the programmed IDLE insertion algorithm. Note that IEEE 802.3 specifies 5B as minimum IPG (TERMINATE + 4B of IDLE).",
#endif
    UNIMAC_RDP_CONTROL_TX_IPG_FIELD_MASK,
    0,
    UNIMAC_RDP_CONTROL_TX_IPG_FIELD_WIDTH,
    UNIMAC_RDP_CONTROL_TX_IPG_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_CONTROL_STRICT_PREAMBLE_DIS
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_CONTROL_STRICT_PREAMBLE_DIS_FIELD =
{
    "STRICT_PREAMBLE_DIS",
#if RU_INCLUDE_DESC
    "",
    "When this bit is set XIB will support packets with shorter or longer than standard (i.e. less or more than 6B of 0x55) preamble. XIB will accept any number of preamble bytes (0x55) until SFD is detected. If SFD is not detected but instead SOP or EFD, current data are discarded and XIB restarts the parsing."
    "When cleared packets with non-standard preamble are discarded.",
#endif
    UNIMAC_RDP_CONTROL_STRICT_PREAMBLE_DIS_FIELD_MASK,
    0,
    UNIMAC_RDP_CONTROL_STRICT_PREAMBLE_DIS_FIELD_WIDTH,
    UNIMAC_RDP_CONTROL_STRICT_PREAMBLE_DIS_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_CONTROL_GMII_RX_CLK_GATE_EN
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_CONTROL_GMII_RX_CLK_GATE_EN_FIELD =
{
    "GMII_RX_CLK_GATE_EN",
#if RU_INCLUDE_DESC
    "",
    "When set XIB will gate GMII RX clock if RX FIFO becomes empty in the middle of the packet, in order to prevent packet corruption.",
#endif
    UNIMAC_RDP_CONTROL_GMII_RX_CLK_GATE_EN_FIELD_MASK,
    0,
    UNIMAC_RDP_CONTROL_GMII_RX_CLK_GATE_EN_FIELD_WIDTH,
    UNIMAC_RDP_CONTROL_GMII_RX_CLK_GATE_EN_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_CONTROL_RX_START_THRESHOLD
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_CONTROL_RX_START_THRESHOLD_FIELD =
{
    "RX_START_THRESHOLD",
#if RU_INCLUDE_DESC
    "",
    "Packet receive in GMII clock domain starts only when at least RX_START_THRESHOLD words are available in XIB RX FIFO.",
#endif
    UNIMAC_RDP_CONTROL_RX_START_THRESHOLD_FIELD_MASK,
    0,
    UNIMAC_RDP_CONTROL_RX_START_THRESHOLD_FIELD_WIDTH,
    UNIMAC_RDP_CONTROL_RX_START_THRESHOLD_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_CONTROL_DIC_DIS
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_CONTROL_DIC_DIS_FIELD =
{
    "DIC_DIS",
#if RU_INCLUDE_DESC
    "",
    "When cleared GIB TX deploys DIC (Deficit Idle Counter) algorithm. This algorithms maintains 10Gbps data rate by inserting more or less idles than specified via TX_IPG."
    "When set minimum of TX_IPG IDLEs are insert between packets leading to data rate that is lower than 10Gbps due to the SOP alignment rules.",
#endif
    UNIMAC_RDP_CONTROL_DIC_DIS_FIELD_MASK,
    0,
    UNIMAC_RDP_CONTROL_DIC_DIS_FIELD_WIDTH,
    UNIMAC_RDP_CONTROL_DIC_DIS_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_CONTROL_XGMII_SEL
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_CONTROL_XGMII_SEL_FIELD =
{
    "XGMII_SEL",
#if RU_INCLUDE_DESC
    "",
    "When cleared XIB is by bypassed that is PHY's GMII interfaces is passed through. This bit is valid only when XGMII_SEL_OVRD = 1.",
#endif
    UNIMAC_RDP_CONTROL_XGMII_SEL_FIELD_MASK,
    0,
    UNIMAC_RDP_CONTROL_XGMII_SEL_FIELD_WIDTH,
    UNIMAC_RDP_CONTROL_XGMII_SEL_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_CONTROL_STANDARD_MUX_EN
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_CONTROL_STANDARD_MUX_EN_FIELD =
{
    "STANDARD_MUX_EN",
#if RU_INCLUDE_DESC
    "",
    "When set glitch-less clock muxes behave as a regular clock muxes."
    "This is debug only feature.",
#endif
    UNIMAC_RDP_CONTROL_STANDARD_MUX_EN_FIELD_MASK,
    0,
    UNIMAC_RDP_CONTROL_STANDARD_MUX_EN_FIELD_WIDTH,
    UNIMAC_RDP_CONTROL_STANDARD_MUX_EN_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_CONTROL_LINK_DOWN_RST_EN
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_CONTROL_LINK_DOWN_RST_EN_FIELD =
{
    "LINK_DOWN_RST_EN",
#if RU_INCLUDE_DESC
    "",
    "When set MAC flushes its RX and TX pipe when the loss of link is detected. It stays in reset until valid link status is indicated by PHY.",
#endif
    UNIMAC_RDP_CONTROL_LINK_DOWN_RST_EN_FIELD_MASK,
    0,
    UNIMAC_RDP_CONTROL_LINK_DOWN_RST_EN_FIELD_WIDTH,
    UNIMAC_RDP_CONTROL_LINK_DOWN_RST_EN_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_CONTROL_TX_FLUSH_EN
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_CONTROL_TX_FLUSH_EN_FIELD =
{
    "TX_FLUSH_EN",
#if RU_INCLUDE_DESC
    "",
    "When set MAC transmit pipe is flushed (control registers are not affected). Must be cleared by SW.",
#endif
    UNIMAC_RDP_CONTROL_TX_FLUSH_EN_FIELD_MASK,
    0,
    UNIMAC_RDP_CONTROL_TX_FLUSH_EN_FIELD_WIDTH,
    UNIMAC_RDP_CONTROL_TX_FLUSH_EN_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_CONTROL_RX_FLUSH_EN
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_CONTROL_RX_FLUSH_EN_FIELD =
{
    "RX_FLUSH_EN",
#if RU_INCLUDE_DESC
    "",
    "When set MAC receive pipe is flushed (control registers are not affected). Must be cleared by SW.",
#endif
    UNIMAC_RDP_CONTROL_RX_FLUSH_EN_FIELD_MASK,
    0,
    UNIMAC_RDP_CONTROL_RX_FLUSH_EN_FIELD_WIDTH,
    UNIMAC_RDP_CONTROL_RX_FLUSH_EN_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_CONTROL_XIB_TX_EN
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_CONTROL_XIB_TX_EN_FIELD =
{
    "XIB_TX_EN",
#if RU_INCLUDE_DESC
    "",
    "When set enables transmit MAC. When cleared all data received from the system are ignored and no data are transmitted to the wire (IDLEs are transmit instead).",
#endif
    UNIMAC_RDP_CONTROL_XIB_TX_EN_FIELD_MASK,
    0,
    UNIMAC_RDP_CONTROL_XIB_TX_EN_FIELD_WIDTH,
    UNIMAC_RDP_CONTROL_XIB_TX_EN_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_CONTROL_XIB_RX_EN
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_CONTROL_XIB_RX_EN_FIELD =
{
    "XIB_RX_EN",
#if RU_INCLUDE_DESC
    "",
    "When set enables receive MAC. When cleared, all data received from PHY are ignored by RX MAC and no data are passed to the system.",
#endif
    UNIMAC_RDP_CONTROL_XIB_RX_EN_FIELD_MASK,
    0,
    UNIMAC_RDP_CONTROL_XIB_RX_EN_FIELD_WIDTH,
    UNIMAC_RDP_CONTROL_XIB_RX_EN_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_EXTENDED_CONTROL_TX_BACKPRESSURE_EN
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_EXTENDED_CONTROL_TX_BACKPRESSURE_EN_FIELD =
{
    "TX_BACKPRESSURE_EN",
#if RU_INCLUDE_DESC
    "",
    "When set enables asserting backpressure toward MAC (in between packets) when TX XOFF THRESHOLD is crossed."
    "Should not be enabled when TX clock gating is enabled.",
#endif
    UNIMAC_RDP_EXTENDED_CONTROL_TX_BACKPRESSURE_EN_FIELD_MASK,
    0,
    UNIMAC_RDP_EXTENDED_CONTROL_TX_BACKPRESSURE_EN_FIELD_WIDTH,
    UNIMAC_RDP_EXTENDED_CONTROL_TX_BACKPRESSURE_EN_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_EXTENDED_CONTROL_TX_XON_THRESHOLD
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_EXTENDED_CONTROL_TX_XON_THRESHOLD_FIELD =
{
    "TX_XON_THRESHOLD",
#if RU_INCLUDE_DESC
    "",
    "TX XON threshold. When FIFO occupancy drops below this threshold, XIB de-asserts backpressure toward switch port.",
#endif
    UNIMAC_RDP_EXTENDED_CONTROL_TX_XON_THRESHOLD_FIELD_MASK,
    0,
    UNIMAC_RDP_EXTENDED_CONTROL_TX_XON_THRESHOLD_FIELD_WIDTH,
    UNIMAC_RDP_EXTENDED_CONTROL_TX_XON_THRESHOLD_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_EXTENDED_CONTROL_TX_XOFF_THRESHOLD
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_EXTENDED_CONTROL_TX_XOFF_THRESHOLD_FIELD =
{
    "TX_XOFF_THRESHOLD",
#if RU_INCLUDE_DESC
    "",
    "TX XOFF threshold. When TX FIFO depth is equal or larger than this threshold XIB asserts backpressure toward the switch port until FIFO occupancy falls below TX_XON_THERSHOLD.",
#endif
    UNIMAC_RDP_EXTENDED_CONTROL_TX_XOFF_THRESHOLD_FIELD_MASK,
    0,
    UNIMAC_RDP_EXTENDED_CONTROL_TX_XOFF_THRESHOLD_FIELD_WIDTH,
    UNIMAC_RDP_EXTENDED_CONTROL_TX_XOFF_THRESHOLD_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_EXTENDED_CONTROL_TX_START_THRESHOLD
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_EXTENDED_CONTROL_TX_START_THRESHOLD_FIELD =
{
    "TX_START_THRESHOLD",
#if RU_INCLUDE_DESC
    "",
    "Packet transmission in XGMII clock domain starts only when at least TX_START_THRESHOLD words are available in XIB TX FIFO. This threshold is applicable to cases where TX FIFO may become empty due to the link down or the other faults.",
#endif
    UNIMAC_RDP_EXTENDED_CONTROL_TX_START_THRESHOLD_FIELD_MASK,
    0,
    UNIMAC_RDP_EXTENDED_CONTROL_TX_START_THRESHOLD_FIELD_WIDTH,
    UNIMAC_RDP_EXTENDED_CONTROL_TX_START_THRESHOLD_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_EXTENDED_CONTROL_RESERVED0
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_EXTENDED_CONTROL_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    UNIMAC_RDP_EXTENDED_CONTROL_RESERVED0_FIELD_MASK,
    0,
    UNIMAC_RDP_EXTENDED_CONTROL_RESERVED0_FIELD_WIDTH,
    UNIMAC_RDP_EXTENDED_CONTROL_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_TX_IDLE_STUFFING_CONTROL_RESERVED0
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_TX_IDLE_STUFFING_CONTROL_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    UNIMAC_RDP_TX_IDLE_STUFFING_CONTROL_RESERVED0_FIELD_MASK,
    0,
    UNIMAC_RDP_TX_IDLE_STUFFING_CONTROL_RESERVED0_FIELD_WIDTH,
    UNIMAC_RDP_TX_IDLE_STUFFING_CONTROL_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_TX_IDLE_STUFFING_CONTROL_TX_IDLE_STUFFING_CTRL
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_TX_IDLE_STUFFING_CONTROL_TX_IDLE_STUFFING_CTRL_FIELD =
{
    "TX_IDLE_STUFFING_CTRL",
#if RU_INCLUDE_DESC
    "",
    "This field controls the IDLE time. Idle time is inserted NX times when N equals to the packet size in bytes, including regular idle, preamble, SOP and EOP."
    "4'b0000: No IDLE stuffing"
    "When the link speed is 10Gbps, available settings are:"
    "4'b0001: 1X. This provides 1/2 rate, i.e. 5Gbps"
    "4'b0010: 3X. This provides 1/4 rate, i.e. 2.5Gbps"
    "4'b0011: 9X. This provides 1/10 rate, i.e. 1Gbps"
    "4'b0100: 99X. This provides 1/100 rate, i.e. 100Mbps"
    "4'b0101: 999X. This provides 1/1000 rate, i.e. 10Mbps"
    "When the link speed is 5Gbps, available settings are:"
    "4'b0001: 1X. This provides 1/2 rate, i.e. 2.5Gbps"
    "4'b0110: 4X. This provides 1/5 rate, i.e. 1Gbps"
    "4'b0111: 49X. This provides 1/50 rate, i.e. 100Mbps"
    "4'b1000: 499X. This provides 1/500 rate, i.e. 10Mbps"
    "When the link speed is 2.5Gbps, available settings are:"
    "4'b1001: 1.5X. This provides 1/2.5 rate. i.e. 1Gbps"
    "4'b1010: 24X. This provides 1/25 rate, i.e. 100Mbps"
    "4'b1011: 249X. This provides 1/250 rate, i.e. 10Mbps"
    "4'b1100 - 4'b1111: Reserved",
#endif
    UNIMAC_RDP_TX_IDLE_STUFFING_CONTROL_TX_IDLE_STUFFING_CTRL_FIELD_MASK,
    0,
    UNIMAC_RDP_TX_IDLE_STUFFING_CONTROL_TX_IDLE_STUFFING_CTRL_FIELD_WIDTH,
    UNIMAC_RDP_TX_IDLE_STUFFING_CONTROL_TX_IDLE_STUFFING_CTRL_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_ACTUAL_DATA_RATE_RESERVED0
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_ACTUAL_DATA_RATE_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    UNIMAC_RDP_ACTUAL_DATA_RATE_RESERVED0_FIELD_MASK,
    0,
    UNIMAC_RDP_ACTUAL_DATA_RATE_RESERVED0_FIELD_WIDTH,
    UNIMAC_RDP_ACTUAL_DATA_RATE_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_ACTUAL_DATA_RATE_ACTUAL_DATA_RATE
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_ACTUAL_DATA_RATE_ACTUAL_DATA_RATE_FIELD =
{
    "ACTUAL_DATA_RATE",
#if RU_INCLUDE_DESC
    "",
    "Actual Data Rate. Accounts for IDLE stuffing. Encoded as:"
    "3'b000 - 10Mbps"
    "3'b001 - 100Mbps"
    "3'b010 - 1Gbps"
    "3'b011 - 2.5Gbps"
    "3'b100 - 10Gbps"
    "3'b101 - 5Gbps"
    "3'b110 - 3'b111 - Reserved",
#endif
    UNIMAC_RDP_ACTUAL_DATA_RATE_ACTUAL_DATA_RATE_FIELD_MASK,
    0,
    UNIMAC_RDP_ACTUAL_DATA_RATE_ACTUAL_DATA_RATE_FIELD_WIDTH,
    UNIMAC_RDP_ACTUAL_DATA_RATE_ACTUAL_DATA_RATE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_GMII_CLOCK_SWALLOWER_CONTROL_RESERVED0
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_GMII_CLOCK_SWALLOWER_CONTROL_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    UNIMAC_RDP_GMII_CLOCK_SWALLOWER_CONTROL_RESERVED0_FIELD_MASK,
    0,
    UNIMAC_RDP_GMII_CLOCK_SWALLOWER_CONTROL_RESERVED0_FIELD_WIDTH,
    UNIMAC_RDP_GMII_CLOCK_SWALLOWER_CONTROL_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_GMII_CLOCK_SWALLOWER_CONTROL_MDIV
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_GMII_CLOCK_SWALLOWER_CONTROL_MDIV_FIELD =
{
    "MDIV",
#if RU_INCLUDE_DESC
    "",
    "GMII clock swallower dividend. Must be <= NDIV. Used only during XGMII to/from GMII conversion.",
#endif
    UNIMAC_RDP_GMII_CLOCK_SWALLOWER_CONTROL_MDIV_FIELD_MASK,
    0,
    UNIMAC_RDP_GMII_CLOCK_SWALLOWER_CONTROL_MDIV_FIELD_WIDTH,
    UNIMAC_RDP_GMII_CLOCK_SWALLOWER_CONTROL_MDIV_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_GMII_CLOCK_SWALLOWER_CONTROL_RESERVED1
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_GMII_CLOCK_SWALLOWER_CONTROL_RESERVED1_FIELD =
{
    "RESERVED1",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    UNIMAC_RDP_GMII_CLOCK_SWALLOWER_CONTROL_RESERVED1_FIELD_MASK,
    0,
    UNIMAC_RDP_GMII_CLOCK_SWALLOWER_CONTROL_RESERVED1_FIELD_WIDTH,
    UNIMAC_RDP_GMII_CLOCK_SWALLOWER_CONTROL_RESERVED1_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_GMII_CLOCK_SWALLOWER_CONTROL_NDIV
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_GMII_CLOCK_SWALLOWER_CONTROL_NDIV_FIELD =
{
    "NDIV",
#if RU_INCLUDE_DESC
    "",
    "GMII clock swallower divisor. GMII clock swallower produces MDIV output clocks for every NDIV input clocks resulting in average MAC GMII RX and TX clock frequency of MDIV/NDIV*INPUT_CLOCK_FREQUENCY. Used only during XGMII to/from GMII conversion.",
#endif
    UNIMAC_RDP_GMII_CLOCK_SWALLOWER_CONTROL_NDIV_FIELD_MASK,
    0,
    UNIMAC_RDP_GMII_CLOCK_SWALLOWER_CONTROL_NDIV_FIELD_WIDTH,
    UNIMAC_RDP_GMII_CLOCK_SWALLOWER_CONTROL_NDIV_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_XGMII_DATA_RATE_STATUS_RESERVED0
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_XGMII_DATA_RATE_STATUS_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    UNIMAC_RDP_XGMII_DATA_RATE_STATUS_RESERVED0_FIELD_MASK,
    0,
    UNIMAC_RDP_XGMII_DATA_RATE_STATUS_RESERVED0_FIELD_WIDTH,
    UNIMAC_RDP_XGMII_DATA_RATE_STATUS_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_XGMII_DATA_RATE_STATUS_XGMII_DATA_RATE
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_XGMII_DATA_RATE_STATUS_XGMII_DATA_RATE_FIELD =
{
    "XGMII_DATA_RATE",
#if RU_INCLUDE_DESC
    "",
    "Indicates data rate over XGMII interface. Used to select GMII operating clocks."
    "Encoded as:"
    "2'b00 - 2.5Gbps"
    "2'b01 - 5Gbps"
    "2'b10 - 10Gbps"
    "2'b11 - Reserved"
    "VAlid only wehn XGMII_SEL=1.",
#endif
    UNIMAC_RDP_XGMII_DATA_RATE_STATUS_XGMII_DATA_RATE_FIELD_MASK,
    0,
    UNIMAC_RDP_XGMII_DATA_RATE_STATUS_XGMII_DATA_RATE_FIELD_WIDTH,
    UNIMAC_RDP_XGMII_DATA_RATE_STATUS_XGMII_DATA_RATE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_STATUS_RESERVED0
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_STATUS_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    UNIMAC_RDP_STATUS_RESERVED0_FIELD_MASK,
    0,
    UNIMAC_RDP_STATUS_RESERVED0_FIELD_WIDTH,
    UNIMAC_RDP_STATUS_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_STATUS_RX_FAULT_STATUS
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_STATUS_RX_FAULT_STATUS_FIELD =
{
    "RX_FAULT_STATUS",
#if RU_INCLUDE_DESC
    "",
    "Received faults status encoded as:"
    "2'b00 - No Fault"
    "2'b01 - Local Fault"
    "2'b10 - Remote Fault"
    "2'b11 - Link Interruption"
    "Cleared on read.",
#endif
    UNIMAC_RDP_STATUS_RX_FAULT_STATUS_FIELD_MASK,
    0,
    UNIMAC_RDP_STATUS_RX_FAULT_STATUS_FIELD_WIDTH,
    UNIMAC_RDP_STATUS_RX_FAULT_STATUS_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_STATUS_TX_FIFO_OVERRUN
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_STATUS_TX_FIFO_OVERRUN_FIELD =
{
    "TX_FIFO_OVERRUN",
#if RU_INCLUDE_DESC
    "",
    "When set indicates that TX FIFO had overflow."
    "Cleared on read.",
#endif
    UNIMAC_RDP_STATUS_TX_FIFO_OVERRUN_FIELD_MASK,
    0,
    UNIMAC_RDP_STATUS_TX_FIFO_OVERRUN_FIELD_WIDTH,
    UNIMAC_RDP_STATUS_TX_FIFO_OVERRUN_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_STATUS_TX_FIFO_UNDERRUN
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_STATUS_TX_FIFO_UNDERRUN_FIELD =
{
    "TX_FIFO_UNDERRUN",
#if RU_INCLUDE_DESC
    "",
    "When set indicates that TX FIFO become empty in the middle of the frame."
    "Cleared on read.",
#endif
    UNIMAC_RDP_STATUS_TX_FIFO_UNDERRUN_FIELD_MASK,
    0,
    UNIMAC_RDP_STATUS_TX_FIFO_UNDERRUN_FIELD_WIDTH,
    UNIMAC_RDP_STATUS_TX_FIFO_UNDERRUN_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_STATUS_RX_FIFO_UNDERRUN
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_STATUS_RX_FIFO_UNDERRUN_FIELD =
{
    "RX_FIFO_UNDERRUN",
#if RU_INCLUDE_DESC
    "",
    "When set indicates that RX FIFO become empty in the middle of the frame."
    "Cleared on read.",
#endif
    UNIMAC_RDP_STATUS_RX_FIFO_UNDERRUN_FIELD_MASK,
    0,
    UNIMAC_RDP_STATUS_RX_FIFO_UNDERRUN_FIELD_WIDTH,
    UNIMAC_RDP_STATUS_RX_FIFO_UNDERRUN_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_STATUS_RX_FIFO_OVERRUN
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_STATUS_RX_FIFO_OVERRUN_FIELD =
{
    "RX_FIFO_OVERRUN",
#if RU_INCLUDE_DESC
    "",
    "When set indicates that RX FIFO had overflow."
    "Cleared on read.",
#endif
    UNIMAC_RDP_STATUS_RX_FIFO_OVERRUN_FIELD_MASK,
    0,
    UNIMAC_RDP_STATUS_RX_FIFO_OVERRUN_FIELD_WIDTH,
    UNIMAC_RDP_STATUS_RX_FIFO_OVERRUN_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_RX_DISCARD_PACKET_COUNTER_PKT_COUNT
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_RX_DISCARD_PACKET_COUNTER_PKT_COUNT_FIELD =
{
    "PKT_COUNT",
#if RU_INCLUDE_DESC
    "",
    "This counter is a free running counter that counts received packets that are discarded by XIB due to framing or other irregularities.",
#endif
    UNIMAC_RDP_RX_DISCARD_PACKET_COUNTER_PKT_COUNT_FIELD_MASK,
    0,
    UNIMAC_RDP_RX_DISCARD_PACKET_COUNTER_PKT_COUNT_FIELD_WIDTH,
    UNIMAC_RDP_RX_DISCARD_PACKET_COUNTER_PKT_COUNT_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_TX_DISCARD_PACKET_COUNTER_PKT_COUNT
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_TX_DISCARD_PACKET_COUNTER_PKT_COUNT_FIELD =
{
    "PKT_COUNT",
#if RU_INCLUDE_DESC
    "",
    "This counter is a free running counter that counts transmitted packets that are discarded by XIB due to framing or other irregularities.",
#endif
    UNIMAC_RDP_TX_DISCARD_PACKET_COUNTER_PKT_COUNT_FIELD_MASK,
    0,
    UNIMAC_RDP_TX_DISCARD_PACKET_COUNTER_PKT_COUNT_FIELD_WIDTH,
    UNIMAC_RDP_TX_DISCARD_PACKET_COUNTER_PKT_COUNT_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_REV_RESERVED0
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_REV_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    UNIMAC_RDP_REV_RESERVED0_FIELD_MASK,
    0,
    UNIMAC_RDP_REV_RESERVED0_FIELD_WIDTH,
    UNIMAC_RDP_REV_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_REV_SYS_PORT_REV
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_REV_SYS_PORT_REV_FIELD =
{
    "SYS_PORT_REV",
#if RU_INCLUDE_DESC
    "",
    "XUMAC revision code.",
#endif
    UNIMAC_RDP_REV_SYS_PORT_REV_FIELD_MASK,
    0,
    UNIMAC_RDP_REV_SYS_PORT_REV_FIELD_WIDTH,
    UNIMAC_RDP_REV_SYS_PORT_REV_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_UMAC_RXERR_MASK_RESERVED0
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_UMAC_RXERR_MASK_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    UNIMAC_RDP_UMAC_RXERR_MASK_RESERVED0_FIELD_MASK,
    0,
    UNIMAC_RDP_UMAC_RXERR_MASK_RESERVED0_FIELD_WIDTH,
    UNIMAC_RDP_UMAC_RXERR_MASK_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_UMAC_RXERR_MASK_MAC_RXERR_MASK
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_UMAC_RXERR_MASK_MAC_RXERR_MASK_FIELD =
{
    "MAC_RXERR_MASK",
#if RU_INCLUDE_DESC
    "",
    "Mask for RSV[33:16].\n"
    "The effective MAC_RXERR will be: |(RSV[33:16] & UMAC_RXERR_MASK)",
#endif
    UNIMAC_RDP_UMAC_RXERR_MASK_MAC_RXERR_MASK_FIELD_MASK,
    0,
    UNIMAC_RDP_UMAC_RXERR_MASK_MAC_RXERR_MASK_FIELD_WIDTH,
    UNIMAC_RDP_UMAC_RXERR_MASK_MAC_RXERR_MASK_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_MIB_MAX_PKT_SIZE_RESERVED0
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_MIB_MAX_PKT_SIZE_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    UNIMAC_RDP_MIB_MAX_PKT_SIZE_RESERVED0_FIELD_MASK,
    0,
    UNIMAC_RDP_MIB_MAX_PKT_SIZE_RESERVED0_FIELD_WIDTH,
    UNIMAC_RDP_MIB_MAX_PKT_SIZE_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_RDP_MIB_MAX_PKT_SIZE_MAX_PKT_SIZE
 ******************************************************************************/
const ru_field_rec UNIMAC_RDP_MIB_MAX_PKT_SIZE_MAX_PKT_SIZE_FIELD =
{
    "MAX_PKT_SIZE",
#if RU_INCLUDE_DESC
    "",
    "This value is used by MIB counters to differentiate regular size packets from oversized packets (used for statistics counting only).\n",
#endif
    UNIMAC_RDP_MIB_MAX_PKT_SIZE_MAX_PKT_SIZE_FIELD_MASK,
    0,
    UNIMAC_RDP_MIB_MAX_PKT_SIZE_MAX_PKT_SIZE_FIELD_WIDTH,
    UNIMAC_RDP_MIB_MAX_PKT_SIZE_MAX_PKT_SIZE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

#endif /* RU_INCLUDE_FIELD_DB */

/******************************************************************************
 * Register: UNIMAC_RDP_IPG_HD_BKP_CNTL
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_IPG_HD_BKP_CNTL_FIELDS[] =
{
    &UNIMAC_RDP_IPG_HD_BKP_CNTL_RESERVED0_FIELD,
    &UNIMAC_RDP_IPG_HD_BKP_CNTL_IPG_CONFIG_RX_FIELD,
    &UNIMAC_RDP_IPG_HD_BKP_CNTL_HD_FC_BKOFF_OK_FIELD,
    &UNIMAC_RDP_IPG_HD_BKP_CNTL_HD_FC_ENA_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_IPG_HD_BKP_CNTL_REG = 
{
    "IPG_HD_BKP_CNTL",
#if RU_INCLUDE_DESC
    "The control register for HD-BackPressure.",
    "",
#endif
    UNIMAC_RDP_IPG_HD_BKP_CNTL_REG_OFFSET,
    0,
    0,
    858,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    4,
    UNIMAC_RDP_IPG_HD_BKP_CNTL_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_COMMAND_CONFIG
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_COMMAND_CONFIG_FIELDS[] =
{
    &UNIMAC_RDP_COMMAND_CONFIG_ETH_SPEED_BIT2_FIELD,
    &UNIMAC_RDP_COMMAND_CONFIG_RUNT_FILTER_DIS_FIELD,
    &UNIMAC_RDP_COMMAND_CONFIG_OOB_EFC_DISAB_FIELD,
    &UNIMAC_RDP_COMMAND_CONFIG_IGNORE_TX_PAUSE_FIELD,
    &UNIMAC_RDP_COMMAND_CONFIG_FD_TX_URUN_FIX_EN_FIELD,
    &UNIMAC_RDP_COMMAND_CONFIG_RESERVED0_FIELD,
    &UNIMAC_RDP_COMMAND_CONFIG_LINE_LOOPBACK_FIELD,
    &UNIMAC_RDP_COMMAND_CONFIG_NO_LGTH_CHECK_FIELD,
    &UNIMAC_RDP_COMMAND_CONFIG_CNTL_FRM_ENA_FIELD,
    &UNIMAC_RDP_COMMAND_CONFIG_ENA_EXT_CONFIG_FIELD,
    &UNIMAC_RDP_COMMAND_CONFIG_EN_INTERNAL_TX_CRS_FIELD,
    &UNIMAC_RDP_COMMAND_CONFIG_BYPASS_OOB_EFC_SYNCHRONIZER_FIELD,
    &UNIMAC_RDP_COMMAND_CONFIG_OOB_EFC_MODE_FIELD,
    &UNIMAC_RDP_COMMAND_CONFIG_SW_OVERRIDE_RX_FIELD,
    &UNIMAC_RDP_COMMAND_CONFIG_SW_OVERRIDE_TX_FIELD,
    &UNIMAC_RDP_COMMAND_CONFIG_MAC_LOOP_CON_FIELD,
    &UNIMAC_RDP_COMMAND_CONFIG_LOOP_ENA_FIELD,
    &UNIMAC_RDP_COMMAND_CONFIG_FCS_CORRUPT_URUN_EN_FIELD,
    &UNIMAC_RDP_COMMAND_CONFIG_SW_RESET_FIELD,
    &UNIMAC_RDP_COMMAND_CONFIG_OVERFLOW_EN_FIELD,
    &UNIMAC_RDP_COMMAND_CONFIG_RX_LOW_LATENCY_EN_FIELD,
    &UNIMAC_RDP_COMMAND_CONFIG_HD_ENA_FIELD,
    &UNIMAC_RDP_COMMAND_CONFIG_TX_ADDR_INS_FIELD,
    &UNIMAC_RDP_COMMAND_CONFIG_PAUSE_IGNORE_FIELD,
    &UNIMAC_RDP_COMMAND_CONFIG_PAUSE_FWD_FIELD,
    &UNIMAC_RDP_COMMAND_CONFIG_CRC_FWD_FIELD,
    &UNIMAC_RDP_COMMAND_CONFIG_PAD_EN_FIELD,
    &UNIMAC_RDP_COMMAND_CONFIG_PROMIS_EN_FIELD,
    &UNIMAC_RDP_COMMAND_CONFIG_ETH_SPEED_FIELD,
    &UNIMAC_RDP_COMMAND_CONFIG_RX_ENA_FIELD,
    &UNIMAC_RDP_COMMAND_CONFIG_TX_ENA_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_COMMAND_CONFIG_REG = 
{
    "COMMAND_CONFIG",
#if RU_INCLUDE_DESC
    "Command register. Used by the host processor to control and configure the core",
    "",
#endif
    UNIMAC_RDP_COMMAND_CONFIG_REG_OFFSET,
    0,
    0,
    859,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    31,
    UNIMAC_RDP_COMMAND_CONFIG_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_MAC_0
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_MAC_0_FIELDS[] =
{
    &UNIMAC_RDP_MAC_0_MAC_ADDR0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_MAC_0_REG = 
{
    "MAC_0",
#if RU_INCLUDE_DESC
    "Core MAC address bits 47 to 16.",
    "",
#endif
    UNIMAC_RDP_MAC_0_REG_OFFSET,
    0,
    0,
    860,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_MAC_0_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_MAC_1
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_MAC_1_FIELDS[] =
{
    &UNIMAC_RDP_MAC_1_RESERVED0_FIELD,
    &UNIMAC_RDP_MAC_1_MAC_ADDR1_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_MAC_1_REG = 
{
    "MAC_1",
#if RU_INCLUDE_DESC
    "Core MAC address bits 15 to 0.",
    "",
#endif
    UNIMAC_RDP_MAC_1_REG_OFFSET,
    0,
    0,
    861,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    2,
    UNIMAC_RDP_MAC_1_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_FRM_LENGTH
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_FRM_LENGTH_FIELDS[] =
{
    &UNIMAC_RDP_FRM_LENGTH_RESERVED0_FIELD,
    &UNIMAC_RDP_FRM_LENGTH_MAXFR_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_FRM_LENGTH_REG = 
{
    "FRM_LENGTH",
#if RU_INCLUDE_DESC
    "Maximum Frame Length.",
    "",
#endif
    UNIMAC_RDP_FRM_LENGTH_REG_OFFSET,
    0,
    0,
    862,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    2,
    UNIMAC_RDP_FRM_LENGTH_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_PAUSE_QUANT
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_PAUSE_QUANT_FIELDS[] =
{
    &UNIMAC_RDP_PAUSE_QUANT_RESERVED0_FIELD,
    &UNIMAC_RDP_PAUSE_QUANT_PAUSE_QUANT_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_PAUSE_QUANT_REG = 
{
    "PAUSE_QUANT",
#if RU_INCLUDE_DESC
    "Receive Pause Quanta.",
    "",
#endif
    UNIMAC_RDP_PAUSE_QUANT_REG_OFFSET,
    0,
    0,
    863,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    2,
    UNIMAC_RDP_PAUSE_QUANT_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_TX_TS_SEQ_ID
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_TX_TS_SEQ_ID_FIELDS[] =
{
    &UNIMAC_RDP_TX_TS_SEQ_ID_RESERVED0_FIELD,
    &UNIMAC_RDP_TX_TS_SEQ_ID_TSTS_VALID_FIELD,
    &UNIMAC_RDP_TX_TS_SEQ_ID_TSTS_SEQ_ID_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_TX_TS_SEQ_ID_REG = 
{
    "TX_TS_SEQ_ID",
#if RU_INCLUDE_DESC
    "Transmit Two Step Timestamp Sequence ID",
    "",
#endif
    UNIMAC_RDP_TX_TS_SEQ_ID_REG_OFFSET,
    0,
    0,
    864,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    3,
    UNIMAC_RDP_TX_TS_SEQ_ID_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_SFD_OFFSET
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_SFD_OFFSET_FIELDS[] =
{
    &UNIMAC_RDP_SFD_OFFSET_RESERVED0_FIELD,
    &UNIMAC_RDP_SFD_OFFSET_SFD_OFFSET_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_SFD_OFFSET_REG = 
{
    "SFD_OFFSET",
#if RU_INCLUDE_DESC
    "EFM Preamble Length.",
    "",
#endif
    UNIMAC_RDP_SFD_OFFSET_REG_OFFSET,
    0,
    0,
    865,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    2,
    UNIMAC_RDP_SFD_OFFSET_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_MAC_MODE
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_MAC_MODE_FIELDS[] =
{
    &UNIMAC_RDP_MAC_MODE_RESERVED0_FIELD,
    &UNIMAC_RDP_MAC_MODE_MAC_SPEED_BIT2_FIELD,
    &UNIMAC_RDP_MAC_MODE_LINK_STATUS_FIELD,
    &UNIMAC_RDP_MAC_MODE_MAC_TX_PAUSE_FIELD,
    &UNIMAC_RDP_MAC_MODE_MAC_RX_PAUSE_FIELD,
    &UNIMAC_RDP_MAC_MODE_MAC_DUPLEX_FIELD,
    &UNIMAC_RDP_MAC_MODE_MAC_SPEED_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_MAC_MODE_REG = 
{
    "MAC_MODE",
#if RU_INCLUDE_DESC
    "MAC Mode Status. MAC Speed and Duplex Mode configuration from register COMMAND CONFIG, when ENA_EXT_CONFIG is set to '0' or from signals set_speed(1:0), set_duplex, tx_pause_en, rx_pause_en and link_stat.",
    "",
#endif
    UNIMAC_RDP_MAC_MODE_REG_OFFSET,
    0,
    0,
    866,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    7,
    UNIMAC_RDP_MAC_MODE_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_TAG_0
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_TAG_0_FIELDS[] =
{
    &UNIMAC_RDP_TAG_0_RESERVED0_FIELD,
    &UNIMAC_RDP_TAG_0_CONFIG_OUTER_TPID_ENABLE_FIELD,
    &UNIMAC_RDP_TAG_0_FRM_TAG_0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_TAG_0_REG = 
{
    "TAG_0",
#if RU_INCLUDE_DESC
    "Programmable VLAN outer tag",
    "",
#endif
    UNIMAC_RDP_TAG_0_REG_OFFSET,
    0,
    0,
    867,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    3,
    UNIMAC_RDP_TAG_0_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_TAG_1
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_TAG_1_FIELDS[] =
{
    &UNIMAC_RDP_TAG_1_RESERVED0_FIELD,
    &UNIMAC_RDP_TAG_1_CONFIG_INNER_TPID_ENABLE_FIELD,
    &UNIMAC_RDP_TAG_1_FRM_TAG_1_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_TAG_1_REG = 
{
    "TAG_1",
#if RU_INCLUDE_DESC
    "Programmable VLAN inner tag",
    "",
#endif
    UNIMAC_RDP_TAG_1_REG_OFFSET,
    0,
    0,
    868,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    3,
    UNIMAC_RDP_TAG_1_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_RX_PAUSE_QUANTA_SCALE
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_RX_PAUSE_QUANTA_SCALE_FIELDS[] =
{
    &UNIMAC_RDP_RX_PAUSE_QUANTA_SCALE_RESERVED0_FIELD,
    &UNIMAC_RDP_RX_PAUSE_QUANTA_SCALE_SCALE_FIX_FIELD,
    &UNIMAC_RDP_RX_PAUSE_QUANTA_SCALE_SCALE_CONTROL_FIELD,
    &UNIMAC_RDP_RX_PAUSE_QUANTA_SCALE_SCALE_VALUE_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_RX_PAUSE_QUANTA_SCALE_REG = 
{
    "RX_PAUSE_QUANTA_SCALE",
#if RU_INCLUDE_DESC
    "programmable Rx pause quanta scaler. Static register. Affects Xoff values only",
    "",
#endif
    UNIMAC_RDP_RX_PAUSE_QUANTA_SCALE_REG_OFFSET,
    0,
    0,
    869,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    4,
    UNIMAC_RDP_RX_PAUSE_QUANTA_SCALE_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_TX_PREAMBLE
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_TX_PREAMBLE_FIELDS[] =
{
    &UNIMAC_RDP_TX_PREAMBLE_RESERVED0_FIELD,
    &UNIMAC_RDP_TX_PREAMBLE_TX_PREAMBLE_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_TX_PREAMBLE_REG = 
{
    "TX_PREAMBLE",
#if RU_INCLUDE_DESC
    "Programmable Preamble at Tx.",
    "",
#endif
    UNIMAC_RDP_TX_PREAMBLE_REG_OFFSET,
    0,
    0,
    870,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    2,
    UNIMAC_RDP_TX_PREAMBLE_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_TX_IPG_LENGTH
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_TX_IPG_LENGTH_FIELDS[] =
{
    &UNIMAC_RDP_TX_IPG_LENGTH_RESERVED0_FIELD,
    &UNIMAC_RDP_TX_IPG_LENGTH_TX_MIN_PKT_SIZE_FIELD,
    &UNIMAC_RDP_TX_IPG_LENGTH_RESERVED1_FIELD,
    &UNIMAC_RDP_TX_IPG_LENGTH_TX_IPG_LENGTH_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_TX_IPG_LENGTH_REG = 
{
    "TX_IPG_LENGTH",
#if RU_INCLUDE_DESC
    "Programmable Inter-Packet-Gap (IPG).",
    "",
#endif
    UNIMAC_RDP_TX_IPG_LENGTH_REG_OFFSET,
    0,
    0,
    871,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    4,
    UNIMAC_RDP_TX_IPG_LENGTH_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_PFC_XOFF_TIMER
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_PFC_XOFF_TIMER_FIELDS[] =
{
    &UNIMAC_RDP_PFC_XOFF_TIMER_RESERVED0_FIELD,
    &UNIMAC_RDP_PFC_XOFF_TIMER_PFC_XOFF_TIMER_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_PFC_XOFF_TIMER_REG = 
{
    "PFC_XOFF_TIMER",
#if RU_INCLUDE_DESC
    "XOFF Timer value for PFC Tx packet",
    "",
#endif
    UNIMAC_RDP_PFC_XOFF_TIMER_REG_OFFSET,
    0,
    0,
    872,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    2,
    UNIMAC_RDP_PFC_XOFF_TIMER_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_UMAC_EEE_CTRL
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_UMAC_EEE_CTRL_FIELDS[] =
{
    &UNIMAC_RDP_UMAC_EEE_CTRL_RESERVED0_FIELD,
    &UNIMAC_RDP_UMAC_EEE_CTRL_LP_IDLE_PREDICTION_MODE_FIELD,
    &UNIMAC_RDP_UMAC_EEE_CTRL_DIS_EEE_10M_FIELD,
    &UNIMAC_RDP_UMAC_EEE_CTRL_EEE_TXCLK_DIS_FIELD,
    &UNIMAC_RDP_UMAC_EEE_CTRL_RX_FIFO_CHECK_FIELD,
    &UNIMAC_RDP_UMAC_EEE_CTRL_EEE_EN_FIELD,
    &UNIMAC_RDP_UMAC_EEE_CTRL_RESERVED1_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_UMAC_EEE_CTRL_REG = 
{
    "UMAC_EEE_CTRL",
#if RU_INCLUDE_DESC
    "control configs for EEE feature",
    "",
#endif
    UNIMAC_RDP_UMAC_EEE_CTRL_REG_OFFSET,
    0,
    0,
    873,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    7,
    UNIMAC_RDP_UMAC_EEE_CTRL_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_MII_EEE_DELAY_ENTRY_TIMER
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_MII_EEE_DELAY_ENTRY_TIMER_FIELDS[] =
{
    &UNIMAC_RDP_MII_EEE_DELAY_ENTRY_TIMER_MII_EEE_LPI_TIMER_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_MII_EEE_DELAY_ENTRY_TIMER_REG = 
{
    "MII_EEE_DELAY_ENTRY_TIMER",
#if RU_INCLUDE_DESC
    "MII_EEE LPI timer",
    "",
#endif
    UNIMAC_RDP_MII_EEE_DELAY_ENTRY_TIMER_REG_OFFSET,
    0,
    0,
    874,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_MII_EEE_DELAY_ENTRY_TIMER_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_GMII_EEE_DELAY_ENTRY_TIMER
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_GMII_EEE_DELAY_ENTRY_TIMER_FIELDS[] =
{
    &UNIMAC_RDP_GMII_EEE_DELAY_ENTRY_TIMER_GMII_EEE_LPI_TIMER_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_GMII_EEE_DELAY_ENTRY_TIMER_REG = 
{
    "GMII_EEE_DELAY_ENTRY_TIMER",
#if RU_INCLUDE_DESC
    "GMII_EEE LPI timer",
    "",
#endif
    UNIMAC_RDP_GMII_EEE_DELAY_ENTRY_TIMER_REG_OFFSET,
    0,
    0,
    875,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_GMII_EEE_DELAY_ENTRY_TIMER_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_UMAC_EEE_REF_COUNT
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_UMAC_EEE_REF_COUNT_FIELDS[] =
{
    &UNIMAC_RDP_UMAC_EEE_REF_COUNT_RESERVED0_FIELD,
    &UNIMAC_RDP_UMAC_EEE_REF_COUNT_EEE_REF_COUNT_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_UMAC_EEE_REF_COUNT_REG = 
{
    "UMAC_EEE_REF_COUNT",
#if RU_INCLUDE_DESC
    "clock divider for 1 us quanta count in EEE",
    "",
#endif
    UNIMAC_RDP_UMAC_EEE_REF_COUNT_REG_OFFSET,
    0,
    0,
    876,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    2,
    UNIMAC_RDP_UMAC_EEE_REF_COUNT_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_UMAC_TIMESTAMP_ADJUST
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_UMAC_TIMESTAMP_ADJUST_FIELDS[] =
{
    &UNIMAC_RDP_UMAC_TIMESTAMP_ADJUST_RESERVED0_FIELD,
    &UNIMAC_RDP_UMAC_TIMESTAMP_ADJUST_AUTO_ADJUST_FIELD,
    &UNIMAC_RDP_UMAC_TIMESTAMP_ADJUST_EN_1588_FIELD,
    &UNIMAC_RDP_UMAC_TIMESTAMP_ADJUST_ADJUST_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_UMAC_TIMESTAMP_ADJUST_REG = 
{
    "UMAC_TIMESTAMP_ADJUST",
#if RU_INCLUDE_DESC
    "1588_one_step_timestamp control",
    "",
#endif
    UNIMAC_RDP_UMAC_TIMESTAMP_ADJUST_REG_OFFSET,
    0,
    0,
    877,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    4,
    UNIMAC_RDP_UMAC_TIMESTAMP_ADJUST_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_UMAC_RX_PKT_DROP_STATUS
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_UMAC_RX_PKT_DROP_STATUS_FIELDS[] =
{
    &UNIMAC_RDP_UMAC_RX_PKT_DROP_STATUS_RESERVED0_FIELD,
    &UNIMAC_RDP_UMAC_RX_PKT_DROP_STATUS_RX_IPG_INVAL_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_UMAC_RX_PKT_DROP_STATUS_REG = 
{
    "UMAC_RX_PKT_DROP_STATUS",
#if RU_INCLUDE_DESC
    "sticky status for Rx packet drop due to invalid IPG",
    "",
#endif
    UNIMAC_RDP_UMAC_RX_PKT_DROP_STATUS_REG_OFFSET,
    0,
    0,
    878,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    2,
    UNIMAC_RDP_UMAC_RX_PKT_DROP_STATUS_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_UMAC_SYMMETRIC_IDLE_THRESHOLD
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_UMAC_SYMMETRIC_IDLE_THRESHOLD_FIELDS[] =
{
    &UNIMAC_RDP_UMAC_SYMMETRIC_IDLE_THRESHOLD_RESERVED0_FIELD,
    &UNIMAC_RDP_UMAC_SYMMETRIC_IDLE_THRESHOLD_THRESHOLD_VALUE_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_UMAC_SYMMETRIC_IDLE_THRESHOLD_REG = 
{
    "UMAC_SYMMETRIC_IDLE_THRESHOLD",
#if RU_INCLUDE_DESC
    "RX IDLE threshold for LPI prediction",
    "",
#endif
    UNIMAC_RDP_UMAC_SYMMETRIC_IDLE_THRESHOLD_REG_OFFSET,
    0,
    0,
    879,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    2,
    UNIMAC_RDP_UMAC_SYMMETRIC_IDLE_THRESHOLD_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_MII_EEE_WAKE_TIMER
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_MII_EEE_WAKE_TIMER_FIELDS[] =
{
    &UNIMAC_RDP_MII_EEE_WAKE_TIMER_RESERVED0_FIELD,
    &UNIMAC_RDP_MII_EEE_WAKE_TIMER_MII_EEE_WAKE_TIMER_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_MII_EEE_WAKE_TIMER_REG = 
{
    "MII_EEE_WAKE_TIMER",
#if RU_INCLUDE_DESC
    "MII_EEE Wake timer",
    "",
#endif
    UNIMAC_RDP_MII_EEE_WAKE_TIMER_REG_OFFSET,
    0,
    0,
    880,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    2,
    UNIMAC_RDP_MII_EEE_WAKE_TIMER_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_GMII_EEE_WAKE_TIMER
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_GMII_EEE_WAKE_TIMER_FIELDS[] =
{
    &UNIMAC_RDP_GMII_EEE_WAKE_TIMER_RESERVED0_FIELD,
    &UNIMAC_RDP_GMII_EEE_WAKE_TIMER_GMII_EEE_WAKE_TIMER_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_GMII_EEE_WAKE_TIMER_REG = 
{
    "GMII_EEE_WAKE_TIMER",
#if RU_INCLUDE_DESC
    "GMII_EEE Wake timer",
    "",
#endif
    UNIMAC_RDP_GMII_EEE_WAKE_TIMER_REG_OFFSET,
    0,
    0,
    881,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    2,
    UNIMAC_RDP_GMII_EEE_WAKE_TIMER_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_UMAC_REV_ID
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_UMAC_REV_ID_FIELDS[] =
{
    &UNIMAC_RDP_UMAC_REV_ID_RESERVED0_FIELD,
    &UNIMAC_RDP_UMAC_REV_ID_REVISION_ID_MAJOR_FIELD,
    &UNIMAC_RDP_UMAC_REV_ID_REVISION_ID_MINOR_FIELD,
    &UNIMAC_RDP_UMAC_REV_ID_PATCH_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_UMAC_REV_ID_REG = 
{
    "UMAC_REV_ID",
#if RU_INCLUDE_DESC
    "UNIMAC_REV_ID",
    "",
#endif
    UNIMAC_RDP_UMAC_REV_ID_REG_OFFSET,
    0,
    0,
    882,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    4,
    UNIMAC_RDP_UMAC_REV_ID_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_GMII_2P5G_EEE_DELAY_ENTRY_TIMER
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_GMII_2P5G_EEE_DELAY_ENTRY_TIMER_FIELDS[] =
{
    &UNIMAC_RDP_GMII_2P5G_EEE_DELAY_ENTRY_TIMER_GMII_2P5G_EEE_LPI_TIMER_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_GMII_2P5G_EEE_DELAY_ENTRY_TIMER_REG = 
{
    "GMII_2P5G_EEE_DELAY_ENTRY_TIMER",
#if RU_INCLUDE_DESC
    "2P5G EEE LPI timer",
    "",
#endif
    UNIMAC_RDP_GMII_2P5G_EEE_DELAY_ENTRY_TIMER_REG_OFFSET,
    0,
    0,
    883,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_GMII_2P5G_EEE_DELAY_ENTRY_TIMER_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_GMII_5G_EEE_DELAY_ENTRY_TIMER
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_GMII_5G_EEE_DELAY_ENTRY_TIMER_FIELDS[] =
{
    &UNIMAC_RDP_GMII_5G_EEE_DELAY_ENTRY_TIMER_GMII_5G_EEE_LPI_TIMER_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_GMII_5G_EEE_DELAY_ENTRY_TIMER_REG = 
{
    "GMII_5G_EEE_DELAY_ENTRY_TIMER",
#if RU_INCLUDE_DESC
    "5G EEE LPI timer",
    "",
#endif
    UNIMAC_RDP_GMII_5G_EEE_DELAY_ENTRY_TIMER_REG_OFFSET,
    0,
    0,
    884,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_GMII_5G_EEE_DELAY_ENTRY_TIMER_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_GMII_10G_EEE_DELAY_ENTRY_TIMER
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_GMII_10G_EEE_DELAY_ENTRY_TIMER_FIELDS[] =
{
    &UNIMAC_RDP_GMII_10G_EEE_DELAY_ENTRY_TIMER_GMII_10G_EEE_LPI_TIMER_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_GMII_10G_EEE_DELAY_ENTRY_TIMER_REG = 
{
    "GMII_10G_EEE_DELAY_ENTRY_TIMER",
#if RU_INCLUDE_DESC
    "10G EEE LPI timer",
    "",
#endif
    UNIMAC_RDP_GMII_10G_EEE_DELAY_ENTRY_TIMER_REG_OFFSET,
    0,
    0,
    885,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_GMII_10G_EEE_DELAY_ENTRY_TIMER_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_GMII_2P5G_EEE_WAKE_TIMER
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_GMII_2P5G_EEE_WAKE_TIMER_FIELDS[] =
{
    &UNIMAC_RDP_GMII_2P5G_EEE_WAKE_TIMER_RESERVED0_FIELD,
    &UNIMAC_RDP_GMII_2P5G_EEE_WAKE_TIMER_GMII_2P5G_EEE_WAKE_TIMER_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_GMII_2P5G_EEE_WAKE_TIMER_REG = 
{
    "GMII_2P5G_EEE_WAKE_TIMER",
#if RU_INCLUDE_DESC
    "2P5G EEE Wake timer",
    "",
#endif
    UNIMAC_RDP_GMII_2P5G_EEE_WAKE_TIMER_REG_OFFSET,
    0,
    0,
    886,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    2,
    UNIMAC_RDP_GMII_2P5G_EEE_WAKE_TIMER_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_GMII_5G_EEE_WAKE_TIMER
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_GMII_5G_EEE_WAKE_TIMER_FIELDS[] =
{
    &UNIMAC_RDP_GMII_5G_EEE_WAKE_TIMER_RESERVED0_FIELD,
    &UNIMAC_RDP_GMII_5G_EEE_WAKE_TIMER_GMII_5G_EEE_WAKE_TIMER_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_GMII_5G_EEE_WAKE_TIMER_REG = 
{
    "GMII_5G_EEE_WAKE_TIMER",
#if RU_INCLUDE_DESC
    "5G EEE Wake timer",
    "",
#endif
    UNIMAC_RDP_GMII_5G_EEE_WAKE_TIMER_REG_OFFSET,
    0,
    0,
    887,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    2,
    UNIMAC_RDP_GMII_5G_EEE_WAKE_TIMER_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_GMII_10G_EEE_WAKE_TIMER
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_GMII_10G_EEE_WAKE_TIMER_FIELDS[] =
{
    &UNIMAC_RDP_GMII_10G_EEE_WAKE_TIMER_RESERVED0_FIELD,
    &UNIMAC_RDP_GMII_10G_EEE_WAKE_TIMER_GMII_10G_EEE_WAKE_TIMER_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_GMII_10G_EEE_WAKE_TIMER_REG = 
{
    "GMII_10G_EEE_WAKE_TIMER",
#if RU_INCLUDE_DESC
    "10G EEE Wake timer",
    "",
#endif
    UNIMAC_RDP_GMII_10G_EEE_WAKE_TIMER_REG_OFFSET,
    0,
    0,
    888,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    2,
    UNIMAC_RDP_GMII_10G_EEE_WAKE_TIMER_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_ACTIVE_EEE_DELAY_ENTRY_TIMER
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_ACTIVE_EEE_DELAY_ENTRY_TIMER_FIELDS[] =
{
    &UNIMAC_RDP_ACTIVE_EEE_DELAY_ENTRY_TIMER_ACTIVE_EEE_LPI_TIMER_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_ACTIVE_EEE_DELAY_ENTRY_TIMER_REG = 
{
    "ACTIVE_EEE_DELAY_ENTRY_TIMER",
#if RU_INCLUDE_DESC
    "Active EEE LPI timer",
    "",
#endif
    UNIMAC_RDP_ACTIVE_EEE_DELAY_ENTRY_TIMER_REG_OFFSET,
    0,
    0,
    889,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_ACTIVE_EEE_DELAY_ENTRY_TIMER_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_ACTIVE_EEE_WAKE_TIMER
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_ACTIVE_EEE_WAKE_TIMER_FIELDS[] =
{
    &UNIMAC_RDP_ACTIVE_EEE_WAKE_TIMER_RESERVED0_FIELD,
    &UNIMAC_RDP_ACTIVE_EEE_WAKE_TIMER_ACTIVE_EEE_WAKE_TIME_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_ACTIVE_EEE_WAKE_TIMER_REG = 
{
    "ACTIVE_EEE_WAKE_TIMER",
#if RU_INCLUDE_DESC
    "Active EEE Wake timer",
    "",
#endif
    UNIMAC_RDP_ACTIVE_EEE_WAKE_TIMER_REG_OFFSET,
    0,
    0,
    890,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    2,
    UNIMAC_RDP_ACTIVE_EEE_WAKE_TIMER_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_MAC_PFC_TYPE
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_MAC_PFC_TYPE_FIELDS[] =
{
    &UNIMAC_RDP_MAC_PFC_TYPE_RESERVED0_FIELD,
    &UNIMAC_RDP_MAC_PFC_TYPE_PFC_ETH_TYPE_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_MAC_PFC_TYPE_REG = 
{
    "MAC_PFC_TYPE",
#if RU_INCLUDE_DESC
    "PFC ethertype",
    "",
#endif
    UNIMAC_RDP_MAC_PFC_TYPE_REG_OFFSET,
    0,
    0,
    891,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    2,
    UNIMAC_RDP_MAC_PFC_TYPE_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_MAC_PFC_OPCODE
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_MAC_PFC_OPCODE_FIELDS[] =
{
    &UNIMAC_RDP_MAC_PFC_OPCODE_RESERVED0_FIELD,
    &UNIMAC_RDP_MAC_PFC_OPCODE_PFC_OPCODE_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_MAC_PFC_OPCODE_REG = 
{
    "MAC_PFC_OPCODE",
#if RU_INCLUDE_DESC
    "PFC opcode",
    "",
#endif
    UNIMAC_RDP_MAC_PFC_OPCODE_REG_OFFSET,
    0,
    0,
    892,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    2,
    UNIMAC_RDP_MAC_PFC_OPCODE_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_MAC_PFC_DA_0
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_MAC_PFC_DA_0_FIELDS[] =
{
    &UNIMAC_RDP_MAC_PFC_DA_0_PFC_MACDA_0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_MAC_PFC_DA_0_REG = 
{
    "MAC_PFC_DA_0",
#if RU_INCLUDE_DESC
    "lower 32 bits of DA for PFC",
    "",
#endif
    UNIMAC_RDP_MAC_PFC_DA_0_REG_OFFSET,
    0,
    0,
    893,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_MAC_PFC_DA_0_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_MAC_PFC_DA_1
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_MAC_PFC_DA_1_FIELDS[] =
{
    &UNIMAC_RDP_MAC_PFC_DA_1_RESERVED0_FIELD,
    &UNIMAC_RDP_MAC_PFC_DA_1_PFC_MACDA_1_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_MAC_PFC_DA_1_REG = 
{
    "MAC_PFC_DA_1",
#if RU_INCLUDE_DESC
    "upper 16 bits of DA for PFC",
    "",
#endif
    UNIMAC_RDP_MAC_PFC_DA_1_REG_OFFSET,
    0,
    0,
    894,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    2,
    UNIMAC_RDP_MAC_PFC_DA_1_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_MACSEC_PROG_TX_CRC
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_MACSEC_PROG_TX_CRC_FIELDS[] =
{
    &UNIMAC_RDP_MACSEC_PROG_TX_CRC_MACSEC_PROG_TX_CRC_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_MACSEC_PROG_TX_CRC_REG = 
{
    "MACSEC_PROG_TX_CRC",
#if RU_INCLUDE_DESC
    "Programmable CRC value to corrupt the Tx CRC to be used in MACSEC",
    "",
#endif
    UNIMAC_RDP_MACSEC_PROG_TX_CRC_REG_OFFSET,
    0,
    0,
    895,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_MACSEC_PROG_TX_CRC_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_MACSEC_CNTRL
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_MACSEC_CNTRL_FIELDS[] =
{
    &UNIMAC_RDP_MACSEC_CNTRL_RESERVED0_FIELD,
    &UNIMAC_RDP_MACSEC_CNTRL_DIS_PAUSE_DATA_VAR_IPG_FIELD,
    &UNIMAC_RDP_MACSEC_CNTRL_TX_CRC_PROGRAM_FIELD,
    &UNIMAC_RDP_MACSEC_CNTRL_TX_CRC_CORUPT_EN_FIELD,
    &UNIMAC_RDP_MACSEC_CNTRL_TX_LAUNCH_EN_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_MACSEC_CNTRL_REG = 
{
    "MACSEC_CNTRL",
#if RU_INCLUDE_DESC
    "Miscellaneous control for MACSEC",
    "",
#endif
    UNIMAC_RDP_MACSEC_CNTRL_REG_OFFSET,
    0,
    0,
    896,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    5,
    UNIMAC_RDP_MACSEC_CNTRL_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_TS_STATUS
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_TS_STATUS_FIELDS[] =
{
    &UNIMAC_RDP_TS_STATUS_RESERVED0_FIELD,
    &UNIMAC_RDP_TS_STATUS_WORD_AVAIL_FIELD,
    &UNIMAC_RDP_TS_STATUS_TX_TS_FIFO_EMPTY_FIELD,
    &UNIMAC_RDP_TS_STATUS_TX_TS_FIFO_FULL_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_TS_STATUS_REG = 
{
    "TS_STATUS",
#if RU_INCLUDE_DESC
    "Timestamp status",
    "",
#endif
    UNIMAC_RDP_TS_STATUS_REG_OFFSET,
    0,
    0,
    897,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    4,
    UNIMAC_RDP_TS_STATUS_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_TX_TS_DATA
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_TX_TS_DATA_FIELDS[] =
{
    &UNIMAC_RDP_TX_TS_DATA_TX_TS_DATA_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_TX_TS_DATA_REG = 
{
    "TX_TS_DATA",
#if RU_INCLUDE_DESC
    "Transmit Timestamp data",
    "",
#endif
    UNIMAC_RDP_TX_TS_DATA_REG_OFFSET,
    0,
    0,
    898,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_TX_TS_DATA_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_PAUSE_REFRESH_CTRL
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_PAUSE_REFRESH_CTRL_FIELDS[] =
{
    &UNIMAC_RDP_PAUSE_REFRESH_CTRL_RESERVED0_FIELD,
    &UNIMAC_RDP_PAUSE_REFRESH_CTRL_ENABLE_FIELD,
    &UNIMAC_RDP_PAUSE_REFRESH_CTRL_REFRESH_TIMER_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_PAUSE_REFRESH_CTRL_REG = 
{
    "PAUSE_REFRESH_CTRL",
#if RU_INCLUDE_DESC
    "PAUSE frame refresh timer control register",
    "",
#endif
    UNIMAC_RDP_PAUSE_REFRESH_CTRL_REG_OFFSET,
    0,
    0,
    899,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    3,
    UNIMAC_RDP_PAUSE_REFRESH_CTRL_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_FLUSH_CONTROL
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_FLUSH_CONTROL_FIELDS[] =
{
    &UNIMAC_RDP_FLUSH_CONTROL_RESERVED0_FIELD,
    &UNIMAC_RDP_FLUSH_CONTROL_FLUSH_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_FLUSH_CONTROL_REG = 
{
    "FLUSH_CONTROL",
#if RU_INCLUDE_DESC
    "Flush enable control register",
    "",
#endif
    UNIMAC_RDP_FLUSH_CONTROL_REG_OFFSET,
    0,
    0,
    900,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    2,
    UNIMAC_RDP_FLUSH_CONTROL_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_RXFIFO_STAT
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_RXFIFO_STAT_FIELDS[] =
{
    &UNIMAC_RDP_RXFIFO_STAT_RESERVED0_FIELD,
    &UNIMAC_RDP_RXFIFO_STAT_RXFIFO_OVERRUN_FIELD,
    &UNIMAC_RDP_RXFIFO_STAT_RXFIFO_UNDERRUN_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_RXFIFO_STAT_REG = 
{
    "RXFIFO_STAT",
#if RU_INCLUDE_DESC
    "RXFIFO status register",
    "",
#endif
    UNIMAC_RDP_RXFIFO_STAT_REG_OFFSET,
    0,
    0,
    901,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    3,
    UNIMAC_RDP_RXFIFO_STAT_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_TXFIFO_STAT
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_TXFIFO_STAT_FIELDS[] =
{
    &UNIMAC_RDP_TXFIFO_STAT_RESERVED0_FIELD,
    &UNIMAC_RDP_TXFIFO_STAT_TXFIFO_OVERRUN_FIELD,
    &UNIMAC_RDP_TXFIFO_STAT_TXFIFO_UNDERRUN_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_TXFIFO_STAT_REG = 
{
    "TXFIFO_STAT",
#if RU_INCLUDE_DESC
    "TXFIFO status register",
    "",
#endif
    UNIMAC_RDP_TXFIFO_STAT_REG_OFFSET,
    0,
    0,
    902,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    3,
    UNIMAC_RDP_TXFIFO_STAT_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_MAC_PFC_CTRL
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_MAC_PFC_CTRL_FIELDS[] =
{
    &UNIMAC_RDP_MAC_PFC_CTRL_RESERVED0_FIELD,
    &UNIMAC_RDP_MAC_PFC_CTRL_PFC_STATS_EN_FIELD,
    &UNIMAC_RDP_MAC_PFC_CTRL_RX_PASS_PFC_FRM_FIELD,
    &UNIMAC_RDP_MAC_PFC_CTRL_RESERVED1_FIELD,
    &UNIMAC_RDP_MAC_PFC_CTRL_FORCE_PFC_XON_FIELD,
    &UNIMAC_RDP_MAC_PFC_CTRL_PFC_RX_ENBL_FIELD,
    &UNIMAC_RDP_MAC_PFC_CTRL_PFC_TX_ENBL_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_MAC_PFC_CTRL_REG = 
{
    "MAC_PFC_CTRL",
#if RU_INCLUDE_DESC
    "PFC control register",
    "",
#endif
    UNIMAC_RDP_MAC_PFC_CTRL_REG_OFFSET,
    0,
    0,
    903,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    7,
    UNIMAC_RDP_MAC_PFC_CTRL_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_MAC_PFC_REFRESH_CTRL
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_MAC_PFC_REFRESH_CTRL_FIELDS[] =
{
    &UNIMAC_RDP_MAC_PFC_REFRESH_CTRL_PFC_REFRESH_TIMER_FIELD,
    &UNIMAC_RDP_MAC_PFC_REFRESH_CTRL_RESERVED0_FIELD,
    &UNIMAC_RDP_MAC_PFC_REFRESH_CTRL_PFC_REFRESH_EN_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_MAC_PFC_REFRESH_CTRL_REG = 
{
    "MAC_PFC_REFRESH_CTRL",
#if RU_INCLUDE_DESC
    "PFC refresh control register",
    "",
#endif
    UNIMAC_RDP_MAC_PFC_REFRESH_CTRL_REG_OFFSET,
    0,
    0,
    904,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    3,
    UNIMAC_RDP_MAC_PFC_REFRESH_CTRL_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_GR64
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_GR64_FIELDS[] =
{
    &UNIMAC_RDP_GR64_COUNT_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_GR64_REG = 
{
    "GR64",
#if RU_INCLUDE_DESC
    "Receive 64B Frame Counter",
    "",
#endif
    UNIMAC_RDP_GR64_REG_OFFSET,
    0,
    0,
    905,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_GR64_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_GR64_UPPER
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_GR64_UPPER_FIELDS[] =
{
    &UNIMAC_RDP_GR64_UPPER_COUNT_U8_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_GR64_UPPER_REG = 
{
    "GR64_UPPER",
#if RU_INCLUDE_DESC
    "RRFRG upper 8 bits",
    "",
#endif
    UNIMAC_RDP_GR64_UPPER_REG_OFFSET,
    0,
    0,
    906,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_GR64_UPPER_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_GR127
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_GR127_FIELDS[] =
{
    &UNIMAC_RDP_GR127_COUNT_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_GR127_REG = 
{
    "GR127",
#if RU_INCLUDE_DESC
    "Receive 65B to 127B Frame Counter",
    "",
#endif
    UNIMAC_RDP_GR127_REG_OFFSET,
    0,
    0,
    907,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_GR127_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_GR127_UPPER
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_GR127_UPPER_FIELDS[] =
{
    &UNIMAC_RDP_GR127_UPPER_COUNT_U8_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_GR127_UPPER_REG = 
{
    "GR127_UPPER",
#if RU_INCLUDE_DESC
    "RRFRG upper 8 bits",
    "",
#endif
    UNIMAC_RDP_GR127_UPPER_REG_OFFSET,
    0,
    0,
    908,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_GR127_UPPER_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_GR255
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_GR255_FIELDS[] =
{
    &UNIMAC_RDP_GR255_COUNT_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_GR255_REG = 
{
    "GR255",
#if RU_INCLUDE_DESC
    "Receive 128B to 255B Frame Counter",
    "",
#endif
    UNIMAC_RDP_GR255_REG_OFFSET,
    0,
    0,
    909,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_GR255_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_GR255_UPPER
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_GR255_UPPER_FIELDS[] =
{
    &UNIMAC_RDP_GR255_UPPER_COUNT_U8_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_GR255_UPPER_REG = 
{
    "GR255_UPPER",
#if RU_INCLUDE_DESC
    "RRFRG upper 8 bits",
    "",
#endif
    UNIMAC_RDP_GR255_UPPER_REG_OFFSET,
    0,
    0,
    910,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_GR255_UPPER_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_GR511
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_GR511_FIELDS[] =
{
    &UNIMAC_RDP_GR511_COUNT_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_GR511_REG = 
{
    "GR511",
#if RU_INCLUDE_DESC
    "Receive 256B to 511B Frame Counter",
    "",
#endif
    UNIMAC_RDP_GR511_REG_OFFSET,
    0,
    0,
    911,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_GR511_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_GR511_UPPER
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_GR511_UPPER_FIELDS[] =
{
    &UNIMAC_RDP_GR511_UPPER_COUNT_U8_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_GR511_UPPER_REG = 
{
    "GR511_UPPER",
#if RU_INCLUDE_DESC
    "RRFRG upper 8 bits",
    "",
#endif
    UNIMAC_RDP_GR511_UPPER_REG_OFFSET,
    0,
    0,
    912,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_GR511_UPPER_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_GR1023
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_GR1023_FIELDS[] =
{
    &UNIMAC_RDP_GR1023_COUNT_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_GR1023_REG = 
{
    "GR1023",
#if RU_INCLUDE_DESC
    "Receive 512B to 1023B Frame Counter",
    "",
#endif
    UNIMAC_RDP_GR1023_REG_OFFSET,
    0,
    0,
    913,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_GR1023_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_GR1023_UPPER
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_GR1023_UPPER_FIELDS[] =
{
    &UNIMAC_RDP_GR1023_UPPER_COUNT_U8_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_GR1023_UPPER_REG = 
{
    "GR1023_UPPER",
#if RU_INCLUDE_DESC
    "RRFRG upper 8 bits",
    "",
#endif
    UNIMAC_RDP_GR1023_UPPER_REG_OFFSET,
    0,
    0,
    914,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_GR1023_UPPER_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_GR1518
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_GR1518_FIELDS[] =
{
    &UNIMAC_RDP_GR1518_COUNT_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_GR1518_REG = 
{
    "GR1518",
#if RU_INCLUDE_DESC
    "Receive 1024B to 1518B Frame Counter",
    "",
#endif
    UNIMAC_RDP_GR1518_REG_OFFSET,
    0,
    0,
    915,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_GR1518_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_GR1518_UPPER
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_GR1518_UPPER_FIELDS[] =
{
    &UNIMAC_RDP_GR1518_UPPER_COUNT_U8_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_GR1518_UPPER_REG = 
{
    "GR1518_UPPER",
#if RU_INCLUDE_DESC
    "RRFRG upper 8 bits",
    "",
#endif
    UNIMAC_RDP_GR1518_UPPER_REG_OFFSET,
    0,
    0,
    916,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_GR1518_UPPER_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_GRMGV
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_GRMGV_FIELDS[] =
{
    &UNIMAC_RDP_GRMGV_COUNT_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_GRMGV_REG = 
{
    "GRMGV",
#if RU_INCLUDE_DESC
    "Receive 1519B to 1522B Good VLAN Frame Counter",
    "",
#endif
    UNIMAC_RDP_GRMGV_REG_OFFSET,
    0,
    0,
    917,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_GRMGV_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_GRMGV_UPPER
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_GRMGV_UPPER_FIELDS[] =
{
    &UNIMAC_RDP_GRMGV_UPPER_COUNT_U8_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_GRMGV_UPPER_REG = 
{
    "GRMGV_UPPER",
#if RU_INCLUDE_DESC
    "RRFRG upper 8 bits",
    "",
#endif
    UNIMAC_RDP_GRMGV_UPPER_REG_OFFSET,
    0,
    0,
    918,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_GRMGV_UPPER_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_GR2047
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_GR2047_FIELDS[] =
{
    &UNIMAC_RDP_GR2047_COUNT_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_GR2047_REG = 
{
    "GR2047",
#if RU_INCLUDE_DESC
    "Receive 1519B to 2047B Frame Counter",
    "",
#endif
    UNIMAC_RDP_GR2047_REG_OFFSET,
    0,
    0,
    919,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_GR2047_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_GR2047_UPPER
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_GR2047_UPPER_FIELDS[] =
{
    &UNIMAC_RDP_GR2047_UPPER_COUNT_U8_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_GR2047_UPPER_REG = 
{
    "GR2047_UPPER",
#if RU_INCLUDE_DESC
    "RRFRG upper 8 bits",
    "",
#endif
    UNIMAC_RDP_GR2047_UPPER_REG_OFFSET,
    0,
    0,
    920,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_GR2047_UPPER_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_GR4095
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_GR4095_FIELDS[] =
{
    &UNIMAC_RDP_GR4095_COUNT_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_GR4095_REG = 
{
    "GR4095",
#if RU_INCLUDE_DESC
    "Receive 2048B to 4095B Frame Counter",
    "",
#endif
    UNIMAC_RDP_GR4095_REG_OFFSET,
    0,
    0,
    921,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_GR4095_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_GR4095_UPPER
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_GR4095_UPPER_FIELDS[] =
{
    &UNIMAC_RDP_GR4095_UPPER_COUNT_U8_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_GR4095_UPPER_REG = 
{
    "GR4095_UPPER",
#if RU_INCLUDE_DESC
    "RRFRG upper 8 bits",
    "",
#endif
    UNIMAC_RDP_GR4095_UPPER_REG_OFFSET,
    0,
    0,
    922,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_GR4095_UPPER_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_GR9216
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_GR9216_FIELDS[] =
{
    &UNIMAC_RDP_GR9216_COUNT_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_GR9216_REG = 
{
    "GR9216",
#if RU_INCLUDE_DESC
    "Receive 4096B to 9216B Frame Counter",
    "",
#endif
    UNIMAC_RDP_GR9216_REG_OFFSET,
    0,
    0,
    923,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_GR9216_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_GR9216_UPPER
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_GR9216_UPPER_FIELDS[] =
{
    &UNIMAC_RDP_GR9216_UPPER_COUNT_U8_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_GR9216_UPPER_REG = 
{
    "GR9216_UPPER",
#if RU_INCLUDE_DESC
    "RRFRG upper 8 bits",
    "",
#endif
    UNIMAC_RDP_GR9216_UPPER_REG_OFFSET,
    0,
    0,
    924,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_GR9216_UPPER_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_GRPKT
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_GRPKT_FIELDS[] =
{
    &UNIMAC_RDP_GRPKT_COUNT_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_GRPKT_REG = 
{
    "GRPKT",
#if RU_INCLUDE_DESC
    "Receive Packet Counter",
    "",
#endif
    UNIMAC_RDP_GRPKT_REG_OFFSET,
    0,
    0,
    925,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_GRPKT_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_GRPKT_UPPER
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_GRPKT_UPPER_FIELDS[] =
{
    &UNIMAC_RDP_GRPKT_UPPER_COUNT_U8_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_GRPKT_UPPER_REG = 
{
    "GRPKT_UPPER",
#if RU_INCLUDE_DESC
    "RRFRG upper 8 bits",
    "",
#endif
    UNIMAC_RDP_GRPKT_UPPER_REG_OFFSET,
    0,
    0,
    926,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_GRPKT_UPPER_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_GRBYT
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_GRBYT_FIELDS[] =
{
    &UNIMAC_RDP_GRBYT_COUNT_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_GRBYT_REG = 
{
    "GRBYT",
#if RU_INCLUDE_DESC
    "Receive Byte Counter",
    "",
#endif
    UNIMAC_RDP_GRBYT_REG_OFFSET,
    0,
    0,
    927,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_GRBYT_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_GRBYT_UPPER
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_GRBYT_UPPER_FIELDS[] =
{
    &UNIMAC_RDP_GRBYT_UPPER_COUNT_U16_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_GRBYT_UPPER_REG = 
{
    "GRBYT_UPPER",
#if RU_INCLUDE_DESC
    "RRBYT upper 16 bits",
    "",
#endif
    UNIMAC_RDP_GRBYT_UPPER_REG_OFFSET,
    0,
    0,
    928,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_GRBYT_UPPER_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_GRMCA
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_GRMCA_FIELDS[] =
{
    &UNIMAC_RDP_GRMCA_COUNT_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_GRMCA_REG = 
{
    "GRMCA",
#if RU_INCLUDE_DESC
    "Receive Multicast Frame Counter",
    "",
#endif
    UNIMAC_RDP_GRMCA_REG_OFFSET,
    0,
    0,
    929,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_GRMCA_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_GRMCA_UPPER
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_GRMCA_UPPER_FIELDS[] =
{
    &UNIMAC_RDP_GRMCA_UPPER_COUNT_U8_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_GRMCA_UPPER_REG = 
{
    "GRMCA_UPPER",
#if RU_INCLUDE_DESC
    "RRFRG upper 8 bits",
    "",
#endif
    UNIMAC_RDP_GRMCA_UPPER_REG_OFFSET,
    0,
    0,
    930,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_GRMCA_UPPER_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_GRBCA
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_GRBCA_FIELDS[] =
{
    &UNIMAC_RDP_GRBCA_COUNT_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_GRBCA_REG = 
{
    "GRBCA",
#if RU_INCLUDE_DESC
    "Receive Broadcast Frame Counter",
    "",
#endif
    UNIMAC_RDP_GRBCA_REG_OFFSET,
    0,
    0,
    931,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_GRBCA_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_GRBCA_UPPER
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_GRBCA_UPPER_FIELDS[] =
{
    &UNIMAC_RDP_GRBCA_UPPER_COUNT_U8_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_GRBCA_UPPER_REG = 
{
    "GRBCA_UPPER",
#if RU_INCLUDE_DESC
    "RRFRG upper 8 bits",
    "",
#endif
    UNIMAC_RDP_GRBCA_UPPER_REG_OFFSET,
    0,
    0,
    932,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_GRBCA_UPPER_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_GRFCS
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_GRFCS_FIELDS[] =
{
    &UNIMAC_RDP_GRFCS_COUNT_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_GRFCS_REG = 
{
    "GRFCS",
#if RU_INCLUDE_DESC
    "Receive FCS Error Counter",
    "",
#endif
    UNIMAC_RDP_GRFCS_REG_OFFSET,
    0,
    0,
    933,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_GRFCS_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_GRFCS_UPPER
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_GRFCS_UPPER_FIELDS[] =
{
    &UNIMAC_RDP_GRFCS_UPPER_COUNT_U8_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_GRFCS_UPPER_REG = 
{
    "GRFCS_UPPER",
#if RU_INCLUDE_DESC
    "RRFRG upper 8 bits",
    "",
#endif
    UNIMAC_RDP_GRFCS_UPPER_REG_OFFSET,
    0,
    0,
    934,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_GRFCS_UPPER_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_GRXCF
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_GRXCF_FIELDS[] =
{
    &UNIMAC_RDP_GRXCF_COUNT_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_GRXCF_REG = 
{
    "GRXCF",
#if RU_INCLUDE_DESC
    "Receive Control Frame Packet Counter",
    "",
#endif
    UNIMAC_RDP_GRXCF_REG_OFFSET,
    0,
    0,
    935,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_GRXCF_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_GRXCF_UPPER
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_GRXCF_UPPER_FIELDS[] =
{
    &UNIMAC_RDP_GRXCF_UPPER_COUNT_U8_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_GRXCF_UPPER_REG = 
{
    "GRXCF_UPPER",
#if RU_INCLUDE_DESC
    "RRFRG upper 8 bits",
    "",
#endif
    UNIMAC_RDP_GRXCF_UPPER_REG_OFFSET,
    0,
    0,
    936,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_GRXCF_UPPER_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_GRXPF
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_GRXPF_FIELDS[] =
{
    &UNIMAC_RDP_GRXPF_COUNT_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_GRXPF_REG = 
{
    "GRXPF",
#if RU_INCLUDE_DESC
    "Receive Pause Frame Packet Counter",
    "",
#endif
    UNIMAC_RDP_GRXPF_REG_OFFSET,
    0,
    0,
    937,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_GRXPF_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_GRXPF_UPPER
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_GRXPF_UPPER_FIELDS[] =
{
    &UNIMAC_RDP_GRXPF_UPPER_COUNT_U8_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_GRXPF_UPPER_REG = 
{
    "GRXPF_UPPER",
#if RU_INCLUDE_DESC
    "RRFRG upper 8 bits",
    "",
#endif
    UNIMAC_RDP_GRXPF_UPPER_REG_OFFSET,
    0,
    0,
    938,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_GRXPF_UPPER_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_GRXUO
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_GRXUO_FIELDS[] =
{
    &UNIMAC_RDP_GRXUO_COUNT_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_GRXUO_REG = 
{
    "GRXUO",
#if RU_INCLUDE_DESC
    "Receive Unknown OP Code Packet Counter",
    "",
#endif
    UNIMAC_RDP_GRXUO_REG_OFFSET,
    0,
    0,
    939,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_GRXUO_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_GRXUO_UPPER
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_GRXUO_UPPER_FIELDS[] =
{
    &UNIMAC_RDP_GRXUO_UPPER_COUNT_U8_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_GRXUO_UPPER_REG = 
{
    "GRXUO_UPPER",
#if RU_INCLUDE_DESC
    "RRFRG upper 8 bits",
    "",
#endif
    UNIMAC_RDP_GRXUO_UPPER_REG_OFFSET,
    0,
    0,
    940,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_GRXUO_UPPER_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_GRALN
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_GRALN_FIELDS[] =
{
    &UNIMAC_RDP_GRALN_COUNT_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_GRALN_REG = 
{
    "GRALN",
#if RU_INCLUDE_DESC
    "Receive Alignmenet Error Counter",
    "",
#endif
    UNIMAC_RDP_GRALN_REG_OFFSET,
    0,
    0,
    941,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_GRALN_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_GRALN_UPPER
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_GRALN_UPPER_FIELDS[] =
{
    &UNIMAC_RDP_GRALN_UPPER_COUNT_U8_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_GRALN_UPPER_REG = 
{
    "GRALN_UPPER",
#if RU_INCLUDE_DESC
    "RRFRG upper 8 bits",
    "",
#endif
    UNIMAC_RDP_GRALN_UPPER_REG_OFFSET,
    0,
    0,
    942,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_GRALN_UPPER_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_GRFLR
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_GRFLR_FIELDS[] =
{
    &UNIMAC_RDP_GRFLR_COUNT_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_GRFLR_REG = 
{
    "GRFLR",
#if RU_INCLUDE_DESC
    "Receive Frame Length Out Of Range Counter",
    "",
#endif
    UNIMAC_RDP_GRFLR_REG_OFFSET,
    0,
    0,
    943,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_GRFLR_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_GRFLR_UPPER
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_GRFLR_UPPER_FIELDS[] =
{
    &UNIMAC_RDP_GRFLR_UPPER_COUNT_U8_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_GRFLR_UPPER_REG = 
{
    "GRFLR_UPPER",
#if RU_INCLUDE_DESC
    "RRFRG upper 8 bits",
    "",
#endif
    UNIMAC_RDP_GRFLR_UPPER_REG_OFFSET,
    0,
    0,
    944,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_GRFLR_UPPER_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_GRCDE
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_GRCDE_FIELDS[] =
{
    &UNIMAC_RDP_GRCDE_COUNT_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_GRCDE_REG = 
{
    "GRCDE",
#if RU_INCLUDE_DESC
    "Receive Code Error Packet Counter",
    "",
#endif
    UNIMAC_RDP_GRCDE_REG_OFFSET,
    0,
    0,
    945,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_GRCDE_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_GRCDE_UPPER
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_GRCDE_UPPER_FIELDS[] =
{
    &UNIMAC_RDP_GRCDE_UPPER_COUNT_U8_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_GRCDE_UPPER_REG = 
{
    "GRCDE_UPPER",
#if RU_INCLUDE_DESC
    "RRFRG upper 8 bits",
    "",
#endif
    UNIMAC_RDP_GRCDE_UPPER_REG_OFFSET,
    0,
    0,
    946,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_GRCDE_UPPER_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_GRFCR
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_GRFCR_FIELDS[] =
{
    &UNIMAC_RDP_GRFCR_COUNT_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_GRFCR_REG = 
{
    "GRFCR",
#if RU_INCLUDE_DESC
    "Receive Carrier Sense Error Packet Counter",
    "",
#endif
    UNIMAC_RDP_GRFCR_REG_OFFSET,
    0,
    0,
    947,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_GRFCR_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_GRFCR_UPPER
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_GRFCR_UPPER_FIELDS[] =
{
    &UNIMAC_RDP_GRFCR_UPPER_COUNT_U8_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_GRFCR_UPPER_REG = 
{
    "GRFCR_UPPER",
#if RU_INCLUDE_DESC
    "RRFRG upper 8 bits",
    "",
#endif
    UNIMAC_RDP_GRFCR_UPPER_REG_OFFSET,
    0,
    0,
    948,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_GRFCR_UPPER_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_GROVR
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_GROVR_FIELDS[] =
{
    &UNIMAC_RDP_GROVR_COUNT_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_GROVR_REG = 
{
    "GROVR",
#if RU_INCLUDE_DESC
    "Receive Oversize Packet Counter",
    "",
#endif
    UNIMAC_RDP_GROVR_REG_OFFSET,
    0,
    0,
    949,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_GROVR_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_GROVR_UPPER
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_GROVR_UPPER_FIELDS[] =
{
    &UNIMAC_RDP_GROVR_UPPER_COUNT_U8_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_GROVR_UPPER_REG = 
{
    "GROVR_UPPER",
#if RU_INCLUDE_DESC
    "RRFRG upper 8 bits",
    "",
#endif
    UNIMAC_RDP_GROVR_UPPER_REG_OFFSET,
    0,
    0,
    950,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_GROVR_UPPER_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_GRJBR
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_GRJBR_FIELDS[] =
{
    &UNIMAC_RDP_GRJBR_COUNT_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_GRJBR_REG = 
{
    "GRJBR",
#if RU_INCLUDE_DESC
    "Receive Jabber Counter",
    "",
#endif
    UNIMAC_RDP_GRJBR_REG_OFFSET,
    0,
    0,
    951,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_GRJBR_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_GRJBR_UPPER
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_GRJBR_UPPER_FIELDS[] =
{
    &UNIMAC_RDP_GRJBR_UPPER_COUNT_U8_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_GRJBR_UPPER_REG = 
{
    "GRJBR_UPPER",
#if RU_INCLUDE_DESC
    "RRFRG upper 8 bits",
    "",
#endif
    UNIMAC_RDP_GRJBR_UPPER_REG_OFFSET,
    0,
    0,
    952,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_GRJBR_UPPER_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_GRMTUE
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_GRMTUE_FIELDS[] =
{
    &UNIMAC_RDP_GRMTUE_COUNT_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_GRMTUE_REG = 
{
    "GRMTUE",
#if RU_INCLUDE_DESC
    "Receive MTU Error Packet Counter",
    "",
#endif
    UNIMAC_RDP_GRMTUE_REG_OFFSET,
    0,
    0,
    953,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_GRMTUE_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_GRMTUE_UPPER
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_GRMTUE_UPPER_FIELDS[] =
{
    &UNIMAC_RDP_GRMTUE_UPPER_COUNT_U8_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_GRMTUE_UPPER_REG = 
{
    "GRMTUE_UPPER",
#if RU_INCLUDE_DESC
    "RRFRG upper 8 bits",
    "",
#endif
    UNIMAC_RDP_GRMTUE_UPPER_REG_OFFSET,
    0,
    0,
    954,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_GRMTUE_UPPER_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_GRPOK
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_GRPOK_FIELDS[] =
{
    &UNIMAC_RDP_GRPOK_COUNT_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_GRPOK_REG = 
{
    "GRPOK",
#if RU_INCLUDE_DESC
    "Receive Good Packet Counter",
    "",
#endif
    UNIMAC_RDP_GRPOK_REG_OFFSET,
    0,
    0,
    955,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_GRPOK_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_GRPOK_UPPER
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_GRPOK_UPPER_FIELDS[] =
{
    &UNIMAC_RDP_GRPOK_UPPER_COUNT_U8_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_GRPOK_UPPER_REG = 
{
    "GRPOK_UPPER",
#if RU_INCLUDE_DESC
    "RRFRG upper 8 bits",
    "",
#endif
    UNIMAC_RDP_GRPOK_UPPER_REG_OFFSET,
    0,
    0,
    956,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_GRPOK_UPPER_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_GRUC
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_GRUC_FIELDS[] =
{
    &UNIMAC_RDP_GRUC_COUNT_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_GRUC_REG = 
{
    "GRUC",
#if RU_INCLUDE_DESC
    "Receive Unicast Packet Counter",
    "",
#endif
    UNIMAC_RDP_GRUC_REG_OFFSET,
    0,
    0,
    957,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_GRUC_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_GRUC_UPPER
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_GRUC_UPPER_FIELDS[] =
{
    &UNIMAC_RDP_GRUC_UPPER_COUNT_U8_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_GRUC_UPPER_REG = 
{
    "GRUC_UPPER",
#if RU_INCLUDE_DESC
    "RRFRG upper 8 bits",
    "",
#endif
    UNIMAC_RDP_GRUC_UPPER_REG_OFFSET,
    0,
    0,
    958,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_GRUC_UPPER_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_GRPPP
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_GRPPP_FIELDS[] =
{
    &UNIMAC_RDP_GRPPP_COUNT_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_GRPPP_REG = 
{
    "GRPPP",
#if RU_INCLUDE_DESC
    "Receive PPP Packet Counter",
    "",
#endif
    UNIMAC_RDP_GRPPP_REG_OFFSET,
    0,
    0,
    959,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_GRPPP_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_GRPPP_UPPER
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_GRPPP_UPPER_FIELDS[] =
{
    &UNIMAC_RDP_GRPPP_UPPER_COUNT_U8_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_GRPPP_UPPER_REG = 
{
    "GRPPP_UPPER",
#if RU_INCLUDE_DESC
    "RRFRG upper 8 bits",
    "",
#endif
    UNIMAC_RDP_GRPPP_UPPER_REG_OFFSET,
    0,
    0,
    960,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_GRPPP_UPPER_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_GRCRC
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_GRCRC_FIELDS[] =
{
    &UNIMAC_RDP_GRCRC_COUNT_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_GRCRC_REG = 
{
    "GRCRC",
#if RU_INCLUDE_DESC
    "Receive CRC Match Packet Counter",
    "",
#endif
    UNIMAC_RDP_GRCRC_REG_OFFSET,
    0,
    0,
    961,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_GRCRC_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_GRCRC_UPPER
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_GRCRC_UPPER_FIELDS[] =
{
    &UNIMAC_RDP_GRCRC_UPPER_COUNT_U8_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_GRCRC_UPPER_REG = 
{
    "GRCRC_UPPER",
#if RU_INCLUDE_DESC
    "RRFRG upper 8 bits",
    "",
#endif
    UNIMAC_RDP_GRCRC_UPPER_REG_OFFSET,
    0,
    0,
    962,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_GRCRC_UPPER_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_TR64
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_TR64_FIELDS[] =
{
    &UNIMAC_RDP_TR64_COUNT_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_TR64_REG = 
{
    "TR64",
#if RU_INCLUDE_DESC
    "Transmit 64B Frame Counter",
    "",
#endif
    UNIMAC_RDP_TR64_REG_OFFSET,
    0,
    0,
    963,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_TR64_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_TR64_UPPER
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_TR64_UPPER_FIELDS[] =
{
    &UNIMAC_RDP_TR64_UPPER_COUNT_U8_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_TR64_UPPER_REG = 
{
    "TR64_UPPER",
#if RU_INCLUDE_DESC
    "RRFRG upper 8 bits",
    "",
#endif
    UNIMAC_RDP_TR64_UPPER_REG_OFFSET,
    0,
    0,
    964,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_TR64_UPPER_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_TR127
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_TR127_FIELDS[] =
{
    &UNIMAC_RDP_TR127_COUNT_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_TR127_REG = 
{
    "TR127",
#if RU_INCLUDE_DESC
    "Transmit 65B to 127B Frame Counter",
    "",
#endif
    UNIMAC_RDP_TR127_REG_OFFSET,
    0,
    0,
    965,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_TR127_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_TR127_UPPER
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_TR127_UPPER_FIELDS[] =
{
    &UNIMAC_RDP_TR127_UPPER_COUNT_U8_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_TR127_UPPER_REG = 
{
    "TR127_UPPER",
#if RU_INCLUDE_DESC
    "RRFRG upper 8 bits",
    "",
#endif
    UNIMAC_RDP_TR127_UPPER_REG_OFFSET,
    0,
    0,
    966,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_TR127_UPPER_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_TR255
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_TR255_FIELDS[] =
{
    &UNIMAC_RDP_TR255_COUNT_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_TR255_REG = 
{
    "TR255",
#if RU_INCLUDE_DESC
    "Transmit 128B to 255B Frame Counter",
    "",
#endif
    UNIMAC_RDP_TR255_REG_OFFSET,
    0,
    0,
    967,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_TR255_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_TR255_UPPER
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_TR255_UPPER_FIELDS[] =
{
    &UNIMAC_RDP_TR255_UPPER_COUNT_U8_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_TR255_UPPER_REG = 
{
    "TR255_UPPER",
#if RU_INCLUDE_DESC
    "RRFRG upper 8 bits",
    "",
#endif
    UNIMAC_RDP_TR255_UPPER_REG_OFFSET,
    0,
    0,
    968,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_TR255_UPPER_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_TR511
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_TR511_FIELDS[] =
{
    &UNIMAC_RDP_TR511_COUNT_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_TR511_REG = 
{
    "TR511",
#if RU_INCLUDE_DESC
    "Transmit 256B to 511B Frame Counter",
    "",
#endif
    UNIMAC_RDP_TR511_REG_OFFSET,
    0,
    0,
    969,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_TR511_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_TR511_UPPER
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_TR511_UPPER_FIELDS[] =
{
    &UNIMAC_RDP_TR511_UPPER_COUNT_U8_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_TR511_UPPER_REG = 
{
    "TR511_UPPER",
#if RU_INCLUDE_DESC
    "RRFRG upper 8 bits",
    "",
#endif
    UNIMAC_RDP_TR511_UPPER_REG_OFFSET,
    0,
    0,
    970,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_TR511_UPPER_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_TR1023
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_TR1023_FIELDS[] =
{
    &UNIMAC_RDP_TR1023_COUNT_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_TR1023_REG = 
{
    "TR1023",
#if RU_INCLUDE_DESC
    "Transmit 512B to 1023B Frame Counter",
    "",
#endif
    UNIMAC_RDP_TR1023_REG_OFFSET,
    0,
    0,
    971,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_TR1023_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_TR1023_UPPER
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_TR1023_UPPER_FIELDS[] =
{
    &UNIMAC_RDP_TR1023_UPPER_COUNT_U8_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_TR1023_UPPER_REG = 
{
    "TR1023_UPPER",
#if RU_INCLUDE_DESC
    "RRFRG upper 8 bits",
    "",
#endif
    UNIMAC_RDP_TR1023_UPPER_REG_OFFSET,
    0,
    0,
    972,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_TR1023_UPPER_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_TR1518
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_TR1518_FIELDS[] =
{
    &UNIMAC_RDP_TR1518_COUNT_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_TR1518_REG = 
{
    "TR1518",
#if RU_INCLUDE_DESC
    "Transmit 1024B to 1518B Frame Counter",
    "",
#endif
    UNIMAC_RDP_TR1518_REG_OFFSET,
    0,
    0,
    973,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_TR1518_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_TR1518_UPPER
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_TR1518_UPPER_FIELDS[] =
{
    &UNIMAC_RDP_TR1518_UPPER_COUNT_U8_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_TR1518_UPPER_REG = 
{
    "TR1518_UPPER",
#if RU_INCLUDE_DESC
    "RRFRG upper 8 bits",
    "",
#endif
    UNIMAC_RDP_TR1518_UPPER_REG_OFFSET,
    0,
    0,
    974,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_TR1518_UPPER_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_TRMGV
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_TRMGV_FIELDS[] =
{
    &UNIMAC_RDP_TRMGV_COUNT_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_TRMGV_REG = 
{
    "TRMGV",
#if RU_INCLUDE_DESC
    "Transmit 1519B to 1522B Good VLAN Frame Counter",
    "",
#endif
    UNIMAC_RDP_TRMGV_REG_OFFSET,
    0,
    0,
    975,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_TRMGV_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_TRMGV_UPPER
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_TRMGV_UPPER_FIELDS[] =
{
    &UNIMAC_RDP_TRMGV_UPPER_COUNT_U8_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_TRMGV_UPPER_REG = 
{
    "TRMGV_UPPER",
#if RU_INCLUDE_DESC
    "RRFRG upper 8 bits",
    "",
#endif
    UNIMAC_RDP_TRMGV_UPPER_REG_OFFSET,
    0,
    0,
    976,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_TRMGV_UPPER_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_TR2047
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_TR2047_FIELDS[] =
{
    &UNIMAC_RDP_TR2047_COUNT_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_TR2047_REG = 
{
    "TR2047",
#if RU_INCLUDE_DESC
    "Transmit 1519B to 2047B Frame Counter",
    "",
#endif
    UNIMAC_RDP_TR2047_REG_OFFSET,
    0,
    0,
    977,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_TR2047_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_TR2047_UPPER
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_TR2047_UPPER_FIELDS[] =
{
    &UNIMAC_RDP_TR2047_UPPER_COUNT_U8_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_TR2047_UPPER_REG = 
{
    "TR2047_UPPER",
#if RU_INCLUDE_DESC
    "RRFRG upper 8 bits",
    "",
#endif
    UNIMAC_RDP_TR2047_UPPER_REG_OFFSET,
    0,
    0,
    978,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_TR2047_UPPER_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_TR4095
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_TR4095_FIELDS[] =
{
    &UNIMAC_RDP_TR4095_COUNT_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_TR4095_REG = 
{
    "TR4095",
#if RU_INCLUDE_DESC
    "Transmit 2048B to 4095B Frame Counter",
    "",
#endif
    UNIMAC_RDP_TR4095_REG_OFFSET,
    0,
    0,
    979,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_TR4095_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_TR4095_UPPER
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_TR4095_UPPER_FIELDS[] =
{
    &UNIMAC_RDP_TR4095_UPPER_COUNT_U8_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_TR4095_UPPER_REG = 
{
    "TR4095_UPPER",
#if RU_INCLUDE_DESC
    "RRFRG upper 8 bits",
    "",
#endif
    UNIMAC_RDP_TR4095_UPPER_REG_OFFSET,
    0,
    0,
    980,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_TR4095_UPPER_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_TR9216
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_TR9216_FIELDS[] =
{
    &UNIMAC_RDP_TR9216_COUNT_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_TR9216_REG = 
{
    "TR9216",
#if RU_INCLUDE_DESC
    "Transmit 4096B to 9216B Frame Counter",
    "",
#endif
    UNIMAC_RDP_TR9216_REG_OFFSET,
    0,
    0,
    981,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_TR9216_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_TR9216_UPPER
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_TR9216_UPPER_FIELDS[] =
{
    &UNIMAC_RDP_TR9216_UPPER_COUNT_U8_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_TR9216_UPPER_REG = 
{
    "TR9216_UPPER",
#if RU_INCLUDE_DESC
    "RRFRG upper 8 bits",
    "",
#endif
    UNIMAC_RDP_TR9216_UPPER_REG_OFFSET,
    0,
    0,
    982,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_TR9216_UPPER_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_GTPKT
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_GTPKT_FIELDS[] =
{
    &UNIMAC_RDP_GTPKT_COUNT_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_GTPKT_REG = 
{
    "GTPKT",
#if RU_INCLUDE_DESC
    "Transmit Packet Counter",
    "",
#endif
    UNIMAC_RDP_GTPKT_REG_OFFSET,
    0,
    0,
    983,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_GTPKT_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_GTPKT_UPPER
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_GTPKT_UPPER_FIELDS[] =
{
    &UNIMAC_RDP_GTPKT_UPPER_COUNT_U8_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_GTPKT_UPPER_REG = 
{
    "GTPKT_UPPER",
#if RU_INCLUDE_DESC
    "RRFRG upper 8 bits",
    "",
#endif
    UNIMAC_RDP_GTPKT_UPPER_REG_OFFSET,
    0,
    0,
    984,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_GTPKT_UPPER_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_GTMCA
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_GTMCA_FIELDS[] =
{
    &UNIMAC_RDP_GTMCA_COUNT_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_GTMCA_REG = 
{
    "GTMCA",
#if RU_INCLUDE_DESC
    "Transmit Multicast Packet Counter",
    "",
#endif
    UNIMAC_RDP_GTMCA_REG_OFFSET,
    0,
    0,
    985,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_GTMCA_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_GTMCA_UPPER
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_GTMCA_UPPER_FIELDS[] =
{
    &UNIMAC_RDP_GTMCA_UPPER_COUNT_U8_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_GTMCA_UPPER_REG = 
{
    "GTMCA_UPPER",
#if RU_INCLUDE_DESC
    "RRFRG upper 8 bits",
    "",
#endif
    UNIMAC_RDP_GTMCA_UPPER_REG_OFFSET,
    0,
    0,
    986,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_GTMCA_UPPER_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_GTBCA
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_GTBCA_FIELDS[] =
{
    &UNIMAC_RDP_GTBCA_COUNT_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_GTBCA_REG = 
{
    "GTBCA",
#if RU_INCLUDE_DESC
    "Transmit Broadcast Packet Counter",
    "",
#endif
    UNIMAC_RDP_GTBCA_REG_OFFSET,
    0,
    0,
    987,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_GTBCA_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_GTBCA_UPPER
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_GTBCA_UPPER_FIELDS[] =
{
    &UNIMAC_RDP_GTBCA_UPPER_COUNT_U8_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_GTBCA_UPPER_REG = 
{
    "GTBCA_UPPER",
#if RU_INCLUDE_DESC
    "RRFRG upper 8 bits",
    "",
#endif
    UNIMAC_RDP_GTBCA_UPPER_REG_OFFSET,
    0,
    0,
    988,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_GTBCA_UPPER_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_GTXPF
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_GTXPF_FIELDS[] =
{
    &UNIMAC_RDP_GTXPF_COUNT_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_GTXPF_REG = 
{
    "GTXPF",
#if RU_INCLUDE_DESC
    "Transmit Pause Frame Packet Counter",
    "",
#endif
    UNIMAC_RDP_GTXPF_REG_OFFSET,
    0,
    0,
    989,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_GTXPF_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_GTXPF_UPPER
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_GTXPF_UPPER_FIELDS[] =
{
    &UNIMAC_RDP_GTXPF_UPPER_COUNT_U8_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_GTXPF_UPPER_REG = 
{
    "GTXPF_UPPER",
#if RU_INCLUDE_DESC
    "RRFRG upper 8 bits",
    "",
#endif
    UNIMAC_RDP_GTXPF_UPPER_REG_OFFSET,
    0,
    0,
    990,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_GTXPF_UPPER_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_GTXCF
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_GTXCF_FIELDS[] =
{
    &UNIMAC_RDP_GTXCF_COUNT_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_GTXCF_REG = 
{
    "GTXCF",
#if RU_INCLUDE_DESC
    "Transmit Control Frame Packet Counter",
    "",
#endif
    UNIMAC_RDP_GTXCF_REG_OFFSET,
    0,
    0,
    991,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_GTXCF_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_GTXCF_UPPER
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_GTXCF_UPPER_FIELDS[] =
{
    &UNIMAC_RDP_GTXCF_UPPER_COUNT_U8_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_GTXCF_UPPER_REG = 
{
    "GTXCF_UPPER",
#if RU_INCLUDE_DESC
    "RRFRG upper 8 bits",
    "",
#endif
    UNIMAC_RDP_GTXCF_UPPER_REG_OFFSET,
    0,
    0,
    992,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_GTXCF_UPPER_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_GTFCS
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_GTFCS_FIELDS[] =
{
    &UNIMAC_RDP_GTFCS_COUNT_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_GTFCS_REG = 
{
    "GTFCS",
#if RU_INCLUDE_DESC
    "Transmit FCS Error Counter",
    "",
#endif
    UNIMAC_RDP_GTFCS_REG_OFFSET,
    0,
    0,
    993,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_GTFCS_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_GTFCS_UPPER
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_GTFCS_UPPER_FIELDS[] =
{
    &UNIMAC_RDP_GTFCS_UPPER_COUNT_U8_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_GTFCS_UPPER_REG = 
{
    "GTFCS_UPPER",
#if RU_INCLUDE_DESC
    "RRFRG upper 8 bits",
    "",
#endif
    UNIMAC_RDP_GTFCS_UPPER_REG_OFFSET,
    0,
    0,
    994,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_GTFCS_UPPER_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_GTOVR
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_GTOVR_FIELDS[] =
{
    &UNIMAC_RDP_GTOVR_COUNT_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_GTOVR_REG = 
{
    "GTOVR",
#if RU_INCLUDE_DESC
    "Transmit Oversize Packet Counter",
    "",
#endif
    UNIMAC_RDP_GTOVR_REG_OFFSET,
    0,
    0,
    995,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_GTOVR_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_GTOVR_UPPER
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_GTOVR_UPPER_FIELDS[] =
{
    &UNIMAC_RDP_GTOVR_UPPER_COUNT_U8_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_GTOVR_UPPER_REG = 
{
    "GTOVR_UPPER",
#if RU_INCLUDE_DESC
    "RRFRG upper 8 bits",
    "",
#endif
    UNIMAC_RDP_GTOVR_UPPER_REG_OFFSET,
    0,
    0,
    996,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_GTOVR_UPPER_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_GTDRF
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_GTDRF_FIELDS[] =
{
    &UNIMAC_RDP_GTDRF_COUNT_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_GTDRF_REG = 
{
    "GTDRF",
#if RU_INCLUDE_DESC
    "Transmit Deferral Packet Counter",
    "",
#endif
    UNIMAC_RDP_GTDRF_REG_OFFSET,
    0,
    0,
    997,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_GTDRF_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_GTDRF_UPPER
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_GTDRF_UPPER_FIELDS[] =
{
    &UNIMAC_RDP_GTDRF_UPPER_COUNT_U8_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_GTDRF_UPPER_REG = 
{
    "GTDRF_UPPER",
#if RU_INCLUDE_DESC
    "RRFRG upper 8 bits",
    "",
#endif
    UNIMAC_RDP_GTDRF_UPPER_REG_OFFSET,
    0,
    0,
    998,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_GTDRF_UPPER_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_GTEDF
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_GTEDF_FIELDS[] =
{
    &UNIMAC_RDP_GTEDF_COUNT_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_GTEDF_REG = 
{
    "GTEDF",
#if RU_INCLUDE_DESC
    "Transmit Excessive Deferral Packet Counter",
    "",
#endif
    UNIMAC_RDP_GTEDF_REG_OFFSET,
    0,
    0,
    999,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_GTEDF_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_GTEDF_UPPER
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_GTEDF_UPPER_FIELDS[] =
{
    &UNIMAC_RDP_GTEDF_UPPER_COUNT_U8_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_GTEDF_UPPER_REG = 
{
    "GTEDF_UPPER",
#if RU_INCLUDE_DESC
    "RRFRG upper 8 bits",
    "",
#endif
    UNIMAC_RDP_GTEDF_UPPER_REG_OFFSET,
    0,
    0,
    1000,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_GTEDF_UPPER_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_GTSCL
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_GTSCL_FIELDS[] =
{
    &UNIMAC_RDP_GTSCL_COUNT_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_GTSCL_REG = 
{
    "GTSCL",
#if RU_INCLUDE_DESC
    "Transmit Single Collision Packet Counter",
    "",
#endif
    UNIMAC_RDP_GTSCL_REG_OFFSET,
    0,
    0,
    1001,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_GTSCL_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_GTSCL_UPPER
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_GTSCL_UPPER_FIELDS[] =
{
    &UNIMAC_RDP_GTSCL_UPPER_COUNT_U8_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_GTSCL_UPPER_REG = 
{
    "GTSCL_UPPER",
#if RU_INCLUDE_DESC
    "RRFRG upper 8 bits",
    "",
#endif
    UNIMAC_RDP_GTSCL_UPPER_REG_OFFSET,
    0,
    0,
    1002,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_GTSCL_UPPER_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_GTMCL
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_GTMCL_FIELDS[] =
{
    &UNIMAC_RDP_GTMCL_COUNT_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_GTMCL_REG = 
{
    "GTMCL",
#if RU_INCLUDE_DESC
    "Transmit Multiple Collision Packet Counter",
    "",
#endif
    UNIMAC_RDP_GTMCL_REG_OFFSET,
    0,
    0,
    1003,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_GTMCL_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_GTMCL_UPPER
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_GTMCL_UPPER_FIELDS[] =
{
    &UNIMAC_RDP_GTMCL_UPPER_COUNT_U8_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_GTMCL_UPPER_REG = 
{
    "GTMCL_UPPER",
#if RU_INCLUDE_DESC
    "RRFRG upper 8 bits",
    "",
#endif
    UNIMAC_RDP_GTMCL_UPPER_REG_OFFSET,
    0,
    0,
    1004,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_GTMCL_UPPER_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_GTLCL
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_GTLCL_FIELDS[] =
{
    &UNIMAC_RDP_GTLCL_COUNT_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_GTLCL_REG = 
{
    "GTLCL",
#if RU_INCLUDE_DESC
    "Transmit Late Collision Packet Counter",
    "",
#endif
    UNIMAC_RDP_GTLCL_REG_OFFSET,
    0,
    0,
    1005,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_GTLCL_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_GTLCL_UPPER
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_GTLCL_UPPER_FIELDS[] =
{
    &UNIMAC_RDP_GTLCL_UPPER_COUNT_U8_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_GTLCL_UPPER_REG = 
{
    "GTLCL_UPPER",
#if RU_INCLUDE_DESC
    "RRFRG upper 8 bits",
    "",
#endif
    UNIMAC_RDP_GTLCL_UPPER_REG_OFFSET,
    0,
    0,
    1006,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_GTLCL_UPPER_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_GTXCL
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_GTXCL_FIELDS[] =
{
    &UNIMAC_RDP_GTXCL_COUNT_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_GTXCL_REG = 
{
    "GTXCL",
#if RU_INCLUDE_DESC
    "Transmit Excessive Collision Packet Counter",
    "",
#endif
    UNIMAC_RDP_GTXCL_REG_OFFSET,
    0,
    0,
    1007,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_GTXCL_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_GTXCL_UPPER
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_GTXCL_UPPER_FIELDS[] =
{
    &UNIMAC_RDP_GTXCL_UPPER_COUNT_U8_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_GTXCL_UPPER_REG = 
{
    "GTXCL_UPPER",
#if RU_INCLUDE_DESC
    "RRFRG upper 8 bits",
    "",
#endif
    UNIMAC_RDP_GTXCL_UPPER_REG_OFFSET,
    0,
    0,
    1008,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_GTXCL_UPPER_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_GTFRG
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_GTFRG_FIELDS[] =
{
    &UNIMAC_RDP_GTFRG_COUNT_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_GTFRG_REG = 
{
    "GTFRG",
#if RU_INCLUDE_DESC
    "Transmit Fragments Packet Counter",
    "",
#endif
    UNIMAC_RDP_GTFRG_REG_OFFSET,
    0,
    0,
    1009,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_GTFRG_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_GTFRG_UPPER
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_GTFRG_UPPER_FIELDS[] =
{
    &UNIMAC_RDP_GTFRG_UPPER_COUNT_U8_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_GTFRG_UPPER_REG = 
{
    "GTFRG_UPPER",
#if RU_INCLUDE_DESC
    "RRFRG upper 8 bits",
    "",
#endif
    UNIMAC_RDP_GTFRG_UPPER_REG_OFFSET,
    0,
    0,
    1010,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_GTFRG_UPPER_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_GTNCL
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_GTNCL_FIELDS[] =
{
    &UNIMAC_RDP_GTNCL_COUNT_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_GTNCL_REG = 
{
    "GTNCL",
#if RU_INCLUDE_DESC
    "Transmit Total Collision Counter",
    "",
#endif
    UNIMAC_RDP_GTNCL_REG_OFFSET,
    0,
    0,
    1011,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_GTNCL_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_GTNCL_UPPER
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_GTNCL_UPPER_FIELDS[] =
{
    &UNIMAC_RDP_GTNCL_UPPER_COUNT_U8_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_GTNCL_UPPER_REG = 
{
    "GTNCL_UPPER",
#if RU_INCLUDE_DESC
    "RRFRG upper 8 bits",
    "",
#endif
    UNIMAC_RDP_GTNCL_UPPER_REG_OFFSET,
    0,
    0,
    1012,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_GTNCL_UPPER_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_GTJBR
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_GTJBR_FIELDS[] =
{
    &UNIMAC_RDP_GTJBR_COUNT_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_GTJBR_REG = 
{
    "GTJBR",
#if RU_INCLUDE_DESC
    "Transmit Jabber Counter",
    "",
#endif
    UNIMAC_RDP_GTJBR_REG_OFFSET,
    0,
    0,
    1013,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_GTJBR_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_GTJBR_UPPER
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_GTJBR_UPPER_FIELDS[] =
{
    &UNIMAC_RDP_GTJBR_UPPER_COUNT_U8_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_GTJBR_UPPER_REG = 
{
    "GTJBR_UPPER",
#if RU_INCLUDE_DESC
    "RRFRG upper 8 bits",
    "",
#endif
    UNIMAC_RDP_GTJBR_UPPER_REG_OFFSET,
    0,
    0,
    1014,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_GTJBR_UPPER_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_GTBYT
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_GTBYT_FIELDS[] =
{
    &UNIMAC_RDP_GTBYT_COUNT_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_GTBYT_REG = 
{
    "GTBYT",
#if RU_INCLUDE_DESC
    "Transmit Byte Counter",
    "",
#endif
    UNIMAC_RDP_GTBYT_REG_OFFSET,
    0,
    0,
    1015,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_GTBYT_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_GTBYT_UPPER
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_GTBYT_UPPER_FIELDS[] =
{
    &UNIMAC_RDP_GTBYT_UPPER_COUNT_U16_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_GTBYT_UPPER_REG = 
{
    "GTBYT_UPPER",
#if RU_INCLUDE_DESC
    "RRBYT upper 16 bits",
    "",
#endif
    UNIMAC_RDP_GTBYT_UPPER_REG_OFFSET,
    0,
    0,
    1016,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_GTBYT_UPPER_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_GTPOK
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_GTPOK_FIELDS[] =
{
    &UNIMAC_RDP_GTPOK_COUNT_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_GTPOK_REG = 
{
    "GTPOK",
#if RU_INCLUDE_DESC
    "Transmit Good Packet Counter",
    "",
#endif
    UNIMAC_RDP_GTPOK_REG_OFFSET,
    0,
    0,
    1017,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_GTPOK_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_GTPOK_UPPER
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_GTPOK_UPPER_FIELDS[] =
{
    &UNIMAC_RDP_GTPOK_UPPER_COUNT_U8_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_GTPOK_UPPER_REG = 
{
    "GTPOK_UPPER",
#if RU_INCLUDE_DESC
    "RRFRG upper 8 bits",
    "",
#endif
    UNIMAC_RDP_GTPOK_UPPER_REG_OFFSET,
    0,
    0,
    1018,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_GTPOK_UPPER_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_GTUC
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_GTUC_FIELDS[] =
{
    &UNIMAC_RDP_GTUC_COUNT_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_GTUC_REG = 
{
    "GTUC",
#if RU_INCLUDE_DESC
    "Transmit Unicast Packet Counter",
    "",
#endif
    UNIMAC_RDP_GTUC_REG_OFFSET,
    0,
    0,
    1019,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_GTUC_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_GTUC_UPPER
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_GTUC_UPPER_FIELDS[] =
{
    &UNIMAC_RDP_GTUC_UPPER_COUNT_U8_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_GTUC_UPPER_REG = 
{
    "GTUC_UPPER",
#if RU_INCLUDE_DESC
    "RRFRG upper 8 bits",
    "",
#endif
    UNIMAC_RDP_GTUC_UPPER_REG_OFFSET,
    0,
    0,
    1020,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_GTUC_UPPER_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_RRPKT
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_RRPKT_FIELDS[] =
{
    &UNIMAC_RDP_RRPKT_COUNT_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_RRPKT_REG = 
{
    "RRPKT",
#if RU_INCLUDE_DESC
    "Receive RUNT Packet Counter",
    "",
#endif
    UNIMAC_RDP_RRPKT_REG_OFFSET,
    0,
    0,
    1021,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_RRPKT_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_RRPKT_UPPER
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_RRPKT_UPPER_FIELDS[] =
{
    &UNIMAC_RDP_RRPKT_UPPER_COUNT_U8_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_RRPKT_UPPER_REG = 
{
    "RRPKT_UPPER",
#if RU_INCLUDE_DESC
    "RRFRG upper 8 bits",
    "",
#endif
    UNIMAC_RDP_RRPKT_UPPER_REG_OFFSET,
    0,
    0,
    1022,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_RRPKT_UPPER_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_RRUND
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_RRUND_FIELDS[] =
{
    &UNIMAC_RDP_RRUND_COUNT_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_RRUND_REG = 
{
    "RRUND",
#if RU_INCLUDE_DESC
    "Receive RUNT Packet and Contain a Valid FCS",
    "",
#endif
    UNIMAC_RDP_RRUND_REG_OFFSET,
    0,
    0,
    1023,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_RRUND_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_RRUND_UPPER
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_RRUND_UPPER_FIELDS[] =
{
    &UNIMAC_RDP_RRUND_UPPER_COUNT_U8_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_RRUND_UPPER_REG = 
{
    "RRUND_UPPER",
#if RU_INCLUDE_DESC
    "RRFRG upper 8 bits",
    "",
#endif
    UNIMAC_RDP_RRUND_UPPER_REG_OFFSET,
    0,
    0,
    1024,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_RRUND_UPPER_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_RRFRG
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_RRFRG_FIELDS[] =
{
    &UNIMAC_RDP_RRFRG_COUNT_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_RRFRG_REG = 
{
    "RRFRG",
#if RU_INCLUDE_DESC
    "Receive RUNT Packet and Contain Invalid FCS or Alignment Error",
    "",
#endif
    UNIMAC_RDP_RRFRG_REG_OFFSET,
    0,
    0,
    1025,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_RRFRG_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_RRFRG_UPPER
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_RRFRG_UPPER_FIELDS[] =
{
    &UNIMAC_RDP_RRFRG_UPPER_COUNT_U8_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_RRFRG_UPPER_REG = 
{
    "RRFRG_UPPER",
#if RU_INCLUDE_DESC
    "RRFRG upper 8 bits",
    "",
#endif
    UNIMAC_RDP_RRFRG_UPPER_REG_OFFSET,
    0,
    0,
    1026,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_RRFRG_UPPER_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_RRBYT
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_RRBYT_FIELDS[] =
{
    &UNIMAC_RDP_RRBYT_COUNT_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_RRBYT_REG = 
{
    "RRBYT",
#if RU_INCLUDE_DESC
    "Receive RUNT Packet Byte Counter",
    "",
#endif
    UNIMAC_RDP_RRBYT_REG_OFFSET,
    0,
    0,
    1027,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_RRBYT_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_RRBYT_UPPER
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_RRBYT_UPPER_FIELDS[] =
{
    &UNIMAC_RDP_RRBYT_UPPER_COUNT_U16_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_RRBYT_UPPER_REG = 
{
    "RRBYT_UPPER",
#if RU_INCLUDE_DESC
    "RRBYT upper 16 bits",
    "",
#endif
    UNIMAC_RDP_RRBYT_UPPER_REG_OFFSET,
    0,
    0,
    1028,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_RRBYT_UPPER_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_MIB_CNTRL
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_MIB_CNTRL_FIELDS[] =
{
    &UNIMAC_RDP_MIB_CNTRL_RESERVED0_FIELD,
    &UNIMAC_RDP_MIB_CNTRL_TX_CNT_RST_FIELD,
    &UNIMAC_RDP_MIB_CNTRL_RUNT_CNT_RST_FIELD,
    &UNIMAC_RDP_MIB_CNTRL_RX_CNT_RST_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_MIB_CNTRL_REG = 
{
    "MIB_CNTRL",
#if RU_INCLUDE_DESC
    "MIB Control Register",
    "",
#endif
    UNIMAC_RDP_MIB_CNTRL_REG_OFFSET,
    0,
    0,
    1029,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    4,
    UNIMAC_RDP_MIB_CNTRL_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_MIB_READ_DATA
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_MIB_READ_DATA_FIELDS[] =
{
    &UNIMAC_RDP_MIB_READ_DATA_DATA32_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_MIB_READ_DATA_REG = 
{
    "MIB_READ_DATA",
#if RU_INCLUDE_DESC
    "MIB write data",
    "",
#endif
    UNIMAC_RDP_MIB_READ_DATA_REG_OFFSET,
    0,
    0,
    1030,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_MIB_READ_DATA_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_MIB_WRITE_DATA
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_MIB_WRITE_DATA_FIELDS[] =
{
    &UNIMAC_RDP_MIB_WRITE_DATA_DATA32_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_MIB_WRITE_DATA_REG = 
{
    "MIB_WRITE_DATA",
#if RU_INCLUDE_DESC
    "MIB write data",
    "",
#endif
    UNIMAC_RDP_MIB_WRITE_DATA_REG_OFFSET,
    0,
    0,
    1031,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_MIB_WRITE_DATA_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_PSW_MS
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_PSW_MS_FIELDS[] =
{
    &UNIMAC_RDP_PSW_MS_RESERVED0_FIELD,
    &UNIMAC_RDP_PSW_MS_PSW_47_32_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_PSW_MS_REG = 
{
    "PSW_MS",
#if RU_INCLUDE_DESC
    "Magic Packet Optional Password bytes 0-1",
    "",
#endif
    UNIMAC_RDP_PSW_MS_REG_OFFSET,
    0,
    0,
    1032,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    2,
    UNIMAC_RDP_PSW_MS_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_PSW_LS
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_PSW_LS_FIELDS[] =
{
    &UNIMAC_RDP_PSW_LS_PSW_31_0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_PSW_LS_REG = 
{
    "PSW_LS",
#if RU_INCLUDE_DESC
    "Magic Packet Optional Password bytes 2-5",
    "",
#endif
    UNIMAC_RDP_PSW_LS_REG_OFFSET,
    0,
    0,
    1033,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_PSW_LS_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_CONTROL
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_CONTROL_FIELDS[] =
{
    &UNIMAC_RDP_CONTROL_AUTOCONFIG_EN_FIELD,
    &UNIMAC_RDP_CONTROL_GMII_TX_CLK_GATE_EN_FIELD,
    &UNIMAC_RDP_CONTROL_XGMII_SEL_OVRD_FIELD,
    &UNIMAC_RDP_CONTROL_MIN_RX_IPG_FIELD,
    &UNIMAC_RDP_CONTROL_TX_IPG_FIELD,
    &UNIMAC_RDP_CONTROL_STRICT_PREAMBLE_DIS_FIELD,
    &UNIMAC_RDP_CONTROL_GMII_RX_CLK_GATE_EN_FIELD,
    &UNIMAC_RDP_CONTROL_RX_START_THRESHOLD_FIELD,
    &UNIMAC_RDP_CONTROL_DIC_DIS_FIELD,
    &UNIMAC_RDP_CONTROL_XGMII_SEL_FIELD,
    &UNIMAC_RDP_CONTROL_STANDARD_MUX_EN_FIELD,
    &UNIMAC_RDP_CONTROL_LINK_DOWN_RST_EN_FIELD,
    &UNIMAC_RDP_CONTROL_TX_FLUSH_EN_FIELD,
    &UNIMAC_RDP_CONTROL_RX_FLUSH_EN_FIELD,
    &UNIMAC_RDP_CONTROL_XIB_TX_EN_FIELD,
    &UNIMAC_RDP_CONTROL_XIB_RX_EN_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_CONTROL_REG = 
{
    "CONTROL",
#if RU_INCLUDE_DESC
    "XIB Control Register",
    "",
#endif
    UNIMAC_RDP_CONTROL_REG_OFFSET,
    0,
    0,
    1034,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    16,
    UNIMAC_RDP_CONTROL_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_EXTENDED_CONTROL
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_EXTENDED_CONTROL_FIELDS[] =
{
    &UNIMAC_RDP_EXTENDED_CONTROL_TX_BACKPRESSURE_EN_FIELD,
    &UNIMAC_RDP_EXTENDED_CONTROL_TX_XON_THRESHOLD_FIELD,
    &UNIMAC_RDP_EXTENDED_CONTROL_TX_XOFF_THRESHOLD_FIELD,
    &UNIMAC_RDP_EXTENDED_CONTROL_TX_START_THRESHOLD_FIELD,
    &UNIMAC_RDP_EXTENDED_CONTROL_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_EXTENDED_CONTROL_REG = 
{
    "EXTENDED_CONTROL",
#if RU_INCLUDE_DESC
    "XIB Extended Control Register",
    "",
#endif
    UNIMAC_RDP_EXTENDED_CONTROL_REG_OFFSET,
    0,
    0,
    1035,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    5,
    UNIMAC_RDP_EXTENDED_CONTROL_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_TX_IDLE_STUFFING_CONTROL
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_TX_IDLE_STUFFING_CONTROL_FIELDS[] =
{
    &UNIMAC_RDP_TX_IDLE_STUFFING_CONTROL_RESERVED0_FIELD,
    &UNIMAC_RDP_TX_IDLE_STUFFING_CONTROL_TX_IDLE_STUFFING_CTRL_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_TX_IDLE_STUFFING_CONTROL_REG = 
{
    "TX_IDLE_STUFFING_CONTROL",
#if RU_INCLUDE_DESC
    "XIB Tx Idle Stuffing Control Register",
    "",
#endif
    UNIMAC_RDP_TX_IDLE_STUFFING_CONTROL_REG_OFFSET,
    0,
    0,
    1036,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    2,
    UNIMAC_RDP_TX_IDLE_STUFFING_CONTROL_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_ACTUAL_DATA_RATE
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_ACTUAL_DATA_RATE_FIELDS[] =
{
    &UNIMAC_RDP_ACTUAL_DATA_RATE_RESERVED0_FIELD,
    &UNIMAC_RDP_ACTUAL_DATA_RATE_ACTUAL_DATA_RATE_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_ACTUAL_DATA_RATE_REG = 
{
    "ACTUAL_DATA_RATE",
#if RU_INCLUDE_DESC
    "XIB Actual Data Rate Register",
    "",
#endif
    UNIMAC_RDP_ACTUAL_DATA_RATE_REG_OFFSET,
    0,
    0,
    1037,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    2,
    UNIMAC_RDP_ACTUAL_DATA_RATE_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_GMII_CLOCK_SWALLOWER_CONTROL
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_GMII_CLOCK_SWALLOWER_CONTROL_FIELDS[] =
{
    &UNIMAC_RDP_GMII_CLOCK_SWALLOWER_CONTROL_RESERVED0_FIELD,
    &UNIMAC_RDP_GMII_CLOCK_SWALLOWER_CONTROL_MDIV_FIELD,
    &UNIMAC_RDP_GMII_CLOCK_SWALLOWER_CONTROL_RESERVED1_FIELD,
    &UNIMAC_RDP_GMII_CLOCK_SWALLOWER_CONTROL_NDIV_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_GMII_CLOCK_SWALLOWER_CONTROL_REG = 
{
    "GMII_CLOCK_SWALLOWER_CONTROL",
#if RU_INCLUDE_DESC
    "XIB GMII Clock Swallower Control Register",
    "",
#endif
    UNIMAC_RDP_GMII_CLOCK_SWALLOWER_CONTROL_REG_OFFSET,
    0,
    0,
    1038,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    4,
    UNIMAC_RDP_GMII_CLOCK_SWALLOWER_CONTROL_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_XGMII_DATA_RATE_STATUS
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_XGMII_DATA_RATE_STATUS_FIELDS[] =
{
    &UNIMAC_RDP_XGMII_DATA_RATE_STATUS_RESERVED0_FIELD,
    &UNIMAC_RDP_XGMII_DATA_RATE_STATUS_XGMII_DATA_RATE_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_XGMII_DATA_RATE_STATUS_REG = 
{
    "XGMII_DATA_RATE_STATUS",
#if RU_INCLUDE_DESC
    "XIB XGMII Data Rate Status Register",
    "",
#endif
    UNIMAC_RDP_XGMII_DATA_RATE_STATUS_REG_OFFSET,
    0,
    0,
    1039,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    2,
    UNIMAC_RDP_XGMII_DATA_RATE_STATUS_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_STATUS
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_STATUS_FIELDS[] =
{
    &UNIMAC_RDP_STATUS_RESERVED0_FIELD,
    &UNIMAC_RDP_STATUS_RX_FAULT_STATUS_FIELD,
    &UNIMAC_RDP_STATUS_TX_FIFO_OVERRUN_FIELD,
    &UNIMAC_RDP_STATUS_TX_FIFO_UNDERRUN_FIELD,
    &UNIMAC_RDP_STATUS_RX_FIFO_UNDERRUN_FIELD,
    &UNIMAC_RDP_STATUS_RX_FIFO_OVERRUN_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_STATUS_REG = 
{
    "STATUS",
#if RU_INCLUDE_DESC
    "XIB Status Register",
    "",
#endif
    UNIMAC_RDP_STATUS_REG_OFFSET,
    0,
    0,
    1040,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    6,
    UNIMAC_RDP_STATUS_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_RX_DISCARD_PACKET_COUNTER
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_RX_DISCARD_PACKET_COUNTER_FIELDS[] =
{
    &UNIMAC_RDP_RX_DISCARD_PACKET_COUNTER_PKT_COUNT_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_RX_DISCARD_PACKET_COUNTER_REG = 
{
    "RX_DISCARD_PACKET_COUNTER",
#if RU_INCLUDE_DESC
    "XIB Receive Discard Packet Counter Register",
    "",
#endif
    UNIMAC_RDP_RX_DISCARD_PACKET_COUNTER_REG_OFFSET,
    0,
    0,
    1041,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_RX_DISCARD_PACKET_COUNTER_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_TX_DISCARD_PACKET_COUNTER
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_TX_DISCARD_PACKET_COUNTER_FIELDS[] =
{
    &UNIMAC_RDP_TX_DISCARD_PACKET_COUNTER_PKT_COUNT_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_TX_DISCARD_PACKET_COUNTER_REG = 
{
    "TX_DISCARD_PACKET_COUNTER",
#if RU_INCLUDE_DESC
    "XIB Transmit Discard Packet Counter Register",
    "",
#endif
    UNIMAC_RDP_TX_DISCARD_PACKET_COUNTER_REG_OFFSET,
    0,
    0,
    1042,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_RDP_TX_DISCARD_PACKET_COUNTER_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_REV
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_REV_FIELDS[] =
{
    &UNIMAC_RDP_REV_RESERVED0_FIELD,
    &UNIMAC_RDP_REV_SYS_PORT_REV_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_REV_REG = 
{
    "REV",
#if RU_INCLUDE_DESC
    "XUMAC Revision Register",
    "",
#endif
    UNIMAC_RDP_REV_REG_OFFSET,
    0,
    0,
    1043,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    2,
    UNIMAC_RDP_REV_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_UMAC_RXERR_MASK
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_UMAC_RXERR_MASK_FIELDS[] =
{
    &UNIMAC_RDP_UMAC_RXERR_MASK_RESERVED0_FIELD,
    &UNIMAC_RDP_UMAC_RXERR_MASK_MAC_RXERR_MASK_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_UMAC_RXERR_MASK_REG = 
{
    "UMAC_RXERR_MASK",
#if RU_INCLUDE_DESC
    "UniMAC RXERR Mask Register",
    "",
#endif
    UNIMAC_RDP_UMAC_RXERR_MASK_REG_OFFSET,
    0,
    0,
    1044,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    2,
    UNIMAC_RDP_UMAC_RXERR_MASK_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_RDP_MIB_MAX_PKT_SIZE
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_RDP_MIB_MAX_PKT_SIZE_FIELDS[] =
{
    &UNIMAC_RDP_MIB_MAX_PKT_SIZE_RESERVED0_FIELD,
    &UNIMAC_RDP_MIB_MAX_PKT_SIZE_MAX_PKT_SIZE_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_RDP_MIB_MAX_PKT_SIZE_REG = 
{
    "MIB_MAX_PKT_SIZE",
#if RU_INCLUDE_DESC
    "MIB Max Packet Size Register",
    "",
#endif
    UNIMAC_RDP_MIB_MAX_PKT_SIZE_REG_OFFSET,
    0,
    0,
    1045,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    2,
    UNIMAC_RDP_MIB_MAX_PKT_SIZE_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Block: UNIMAC_RDP
 ******************************************************************************/
static const ru_reg_rec *UNIMAC_RDP_REGS[] =
{
    &UNIMAC_RDP_IPG_HD_BKP_CNTL_REG,
    &UNIMAC_RDP_COMMAND_CONFIG_REG,
    &UNIMAC_RDP_MAC_0_REG,
    &UNIMAC_RDP_MAC_1_REG,
    &UNIMAC_RDP_FRM_LENGTH_REG,
    &UNIMAC_RDP_PAUSE_QUANT_REG,
    &UNIMAC_RDP_TX_TS_SEQ_ID_REG,
    &UNIMAC_RDP_SFD_OFFSET_REG,
    &UNIMAC_RDP_MAC_MODE_REG,
    &UNIMAC_RDP_TAG_0_REG,
    &UNIMAC_RDP_TAG_1_REG,
    &UNIMAC_RDP_RX_PAUSE_QUANTA_SCALE_REG,
    &UNIMAC_RDP_TX_PREAMBLE_REG,
    &UNIMAC_RDP_TX_IPG_LENGTH_REG,
    &UNIMAC_RDP_PFC_XOFF_TIMER_REG,
    &UNIMAC_RDP_UMAC_EEE_CTRL_REG,
    &UNIMAC_RDP_MII_EEE_DELAY_ENTRY_TIMER_REG,
    &UNIMAC_RDP_GMII_EEE_DELAY_ENTRY_TIMER_REG,
    &UNIMAC_RDP_UMAC_EEE_REF_COUNT_REG,
    &UNIMAC_RDP_UMAC_TIMESTAMP_ADJUST_REG,
    &UNIMAC_RDP_UMAC_RX_PKT_DROP_STATUS_REG,
    &UNIMAC_RDP_UMAC_SYMMETRIC_IDLE_THRESHOLD_REG,
    &UNIMAC_RDP_MII_EEE_WAKE_TIMER_REG,
    &UNIMAC_RDP_GMII_EEE_WAKE_TIMER_REG,
    &UNIMAC_RDP_UMAC_REV_ID_REG,
    &UNIMAC_RDP_GMII_2P5G_EEE_DELAY_ENTRY_TIMER_REG,
    &UNIMAC_RDP_GMII_5G_EEE_DELAY_ENTRY_TIMER_REG,
    &UNIMAC_RDP_GMII_10G_EEE_DELAY_ENTRY_TIMER_REG,
    &UNIMAC_RDP_GMII_2P5G_EEE_WAKE_TIMER_REG,
    &UNIMAC_RDP_GMII_5G_EEE_WAKE_TIMER_REG,
    &UNIMAC_RDP_GMII_10G_EEE_WAKE_TIMER_REG,
    &UNIMAC_RDP_ACTIVE_EEE_DELAY_ENTRY_TIMER_REG,
    &UNIMAC_RDP_ACTIVE_EEE_WAKE_TIMER_REG,
    &UNIMAC_RDP_MAC_PFC_TYPE_REG,
    &UNIMAC_RDP_MAC_PFC_OPCODE_REG,
    &UNIMAC_RDP_MAC_PFC_DA_0_REG,
    &UNIMAC_RDP_MAC_PFC_DA_1_REG,
    &UNIMAC_RDP_MACSEC_PROG_TX_CRC_REG,
    &UNIMAC_RDP_MACSEC_CNTRL_REG,
    &UNIMAC_RDP_TS_STATUS_REG,
    &UNIMAC_RDP_TX_TS_DATA_REG,
    &UNIMAC_RDP_PAUSE_REFRESH_CTRL_REG,
    &UNIMAC_RDP_FLUSH_CONTROL_REG,
    &UNIMAC_RDP_RXFIFO_STAT_REG,
    &UNIMAC_RDP_TXFIFO_STAT_REG,
    &UNIMAC_RDP_MAC_PFC_CTRL_REG,
    &UNIMAC_RDP_MAC_PFC_REFRESH_CTRL_REG,
    &UNIMAC_RDP_GR64_REG,
    &UNIMAC_RDP_GR64_UPPER_REG,
    &UNIMAC_RDP_GR127_REG,
    &UNIMAC_RDP_GR127_UPPER_REG,
    &UNIMAC_RDP_GR255_REG,
    &UNIMAC_RDP_GR255_UPPER_REG,
    &UNIMAC_RDP_GR511_REG,
    &UNIMAC_RDP_GR511_UPPER_REG,
    &UNIMAC_RDP_GR1023_REG,
    &UNIMAC_RDP_GR1023_UPPER_REG,
    &UNIMAC_RDP_GR1518_REG,
    &UNIMAC_RDP_GR1518_UPPER_REG,
    &UNIMAC_RDP_GRMGV_REG,
    &UNIMAC_RDP_GRMGV_UPPER_REG,
    &UNIMAC_RDP_GR2047_REG,
    &UNIMAC_RDP_GR2047_UPPER_REG,
    &UNIMAC_RDP_GR4095_REG,
    &UNIMAC_RDP_GR4095_UPPER_REG,
    &UNIMAC_RDP_GR9216_REG,
    &UNIMAC_RDP_GR9216_UPPER_REG,
    &UNIMAC_RDP_GRPKT_REG,
    &UNIMAC_RDP_GRPKT_UPPER_REG,
    &UNIMAC_RDP_GRBYT_REG,
    &UNIMAC_RDP_GRBYT_UPPER_REG,
    &UNIMAC_RDP_GRMCA_REG,
    &UNIMAC_RDP_GRMCA_UPPER_REG,
    &UNIMAC_RDP_GRBCA_REG,
    &UNIMAC_RDP_GRBCA_UPPER_REG,
    &UNIMAC_RDP_GRFCS_REG,
    &UNIMAC_RDP_GRFCS_UPPER_REG,
    &UNIMAC_RDP_GRXCF_REG,
    &UNIMAC_RDP_GRXCF_UPPER_REG,
    &UNIMAC_RDP_GRXPF_REG,
    &UNIMAC_RDP_GRXPF_UPPER_REG,
    &UNIMAC_RDP_GRXUO_REG,
    &UNIMAC_RDP_GRXUO_UPPER_REG,
    &UNIMAC_RDP_GRALN_REG,
    &UNIMAC_RDP_GRALN_UPPER_REG,
    &UNIMAC_RDP_GRFLR_REG,
    &UNIMAC_RDP_GRFLR_UPPER_REG,
    &UNIMAC_RDP_GRCDE_REG,
    &UNIMAC_RDP_GRCDE_UPPER_REG,
    &UNIMAC_RDP_GRFCR_REG,
    &UNIMAC_RDP_GRFCR_UPPER_REG,
    &UNIMAC_RDP_GROVR_REG,
    &UNIMAC_RDP_GROVR_UPPER_REG,
    &UNIMAC_RDP_GRJBR_REG,
    &UNIMAC_RDP_GRJBR_UPPER_REG,
    &UNIMAC_RDP_GRMTUE_REG,
    &UNIMAC_RDP_GRMTUE_UPPER_REG,
    &UNIMAC_RDP_GRPOK_REG,
    &UNIMAC_RDP_GRPOK_UPPER_REG,
    &UNIMAC_RDP_GRUC_REG,
    &UNIMAC_RDP_GRUC_UPPER_REG,
    &UNIMAC_RDP_GRPPP_REG,
    &UNIMAC_RDP_GRPPP_UPPER_REG,
    &UNIMAC_RDP_GRCRC_REG,
    &UNIMAC_RDP_GRCRC_UPPER_REG,
    &UNIMAC_RDP_TR64_REG,
    &UNIMAC_RDP_TR64_UPPER_REG,
    &UNIMAC_RDP_TR127_REG,
    &UNIMAC_RDP_TR127_UPPER_REG,
    &UNIMAC_RDP_TR255_REG,
    &UNIMAC_RDP_TR255_UPPER_REG,
    &UNIMAC_RDP_TR511_REG,
    &UNIMAC_RDP_TR511_UPPER_REG,
    &UNIMAC_RDP_TR1023_REG,
    &UNIMAC_RDP_TR1023_UPPER_REG,
    &UNIMAC_RDP_TR1518_REG,
    &UNIMAC_RDP_TR1518_UPPER_REG,
    &UNIMAC_RDP_TRMGV_REG,
    &UNIMAC_RDP_TRMGV_UPPER_REG,
    &UNIMAC_RDP_TR2047_REG,
    &UNIMAC_RDP_TR2047_UPPER_REG,
    &UNIMAC_RDP_TR4095_REG,
    &UNIMAC_RDP_TR4095_UPPER_REG,
    &UNIMAC_RDP_TR9216_REG,
    &UNIMAC_RDP_TR9216_UPPER_REG,
    &UNIMAC_RDP_GTPKT_REG,
    &UNIMAC_RDP_GTPKT_UPPER_REG,
    &UNIMAC_RDP_GTMCA_REG,
    &UNIMAC_RDP_GTMCA_UPPER_REG,
    &UNIMAC_RDP_GTBCA_REG,
    &UNIMAC_RDP_GTBCA_UPPER_REG,
    &UNIMAC_RDP_GTXPF_REG,
    &UNIMAC_RDP_GTXPF_UPPER_REG,
    &UNIMAC_RDP_GTXCF_REG,
    &UNIMAC_RDP_GTXCF_UPPER_REG,
    &UNIMAC_RDP_GTFCS_REG,
    &UNIMAC_RDP_GTFCS_UPPER_REG,
    &UNIMAC_RDP_GTOVR_REG,
    &UNIMAC_RDP_GTOVR_UPPER_REG,
    &UNIMAC_RDP_GTDRF_REG,
    &UNIMAC_RDP_GTDRF_UPPER_REG,
    &UNIMAC_RDP_GTEDF_REG,
    &UNIMAC_RDP_GTEDF_UPPER_REG,
    &UNIMAC_RDP_GTSCL_REG,
    &UNIMAC_RDP_GTSCL_UPPER_REG,
    &UNIMAC_RDP_GTMCL_REG,
    &UNIMAC_RDP_GTMCL_UPPER_REG,
    &UNIMAC_RDP_GTLCL_REG,
    &UNIMAC_RDP_GTLCL_UPPER_REG,
    &UNIMAC_RDP_GTXCL_REG,
    &UNIMAC_RDP_GTXCL_UPPER_REG,
    &UNIMAC_RDP_GTFRG_REG,
    &UNIMAC_RDP_GTFRG_UPPER_REG,
    &UNIMAC_RDP_GTNCL_REG,
    &UNIMAC_RDP_GTNCL_UPPER_REG,
    &UNIMAC_RDP_GTJBR_REG,
    &UNIMAC_RDP_GTJBR_UPPER_REG,
    &UNIMAC_RDP_GTBYT_REG,
    &UNIMAC_RDP_GTBYT_UPPER_REG,
    &UNIMAC_RDP_GTPOK_REG,
    &UNIMAC_RDP_GTPOK_UPPER_REG,
    &UNIMAC_RDP_GTUC_REG,
    &UNIMAC_RDP_GTUC_UPPER_REG,
    &UNIMAC_RDP_RRPKT_REG,
    &UNIMAC_RDP_RRPKT_UPPER_REG,
    &UNIMAC_RDP_RRUND_REG,
    &UNIMAC_RDP_RRUND_UPPER_REG,
    &UNIMAC_RDP_RRFRG_REG,
    &UNIMAC_RDP_RRFRG_UPPER_REG,
    &UNIMAC_RDP_RRBYT_REG,
    &UNIMAC_RDP_RRBYT_UPPER_REG,
    &UNIMAC_RDP_MIB_CNTRL_REG,
    &UNIMAC_RDP_MIB_READ_DATA_REG,
    &UNIMAC_RDP_MIB_WRITE_DATA_REG,
    &UNIMAC_RDP_PSW_MS_REG,
    &UNIMAC_RDP_PSW_LS_REG,
    &UNIMAC_RDP_CONTROL_REG,
    &UNIMAC_RDP_EXTENDED_CONTROL_REG,
    &UNIMAC_RDP_TX_IDLE_STUFFING_CONTROL_REG,
    &UNIMAC_RDP_ACTUAL_DATA_RATE_REG,
    &UNIMAC_RDP_GMII_CLOCK_SWALLOWER_CONTROL_REG,
    &UNIMAC_RDP_XGMII_DATA_RATE_STATUS_REG,
    &UNIMAC_RDP_STATUS_REG,
    &UNIMAC_RDP_RX_DISCARD_PACKET_COUNTER_REG,
    &UNIMAC_RDP_TX_DISCARD_PACKET_COUNTER_REG,
    &UNIMAC_RDP_REV_REG,
    &UNIMAC_RDP_UMAC_RXERR_MASK_REG,
    &UNIMAC_RDP_MIB_MAX_PKT_SIZE_REG,
};

unsigned long UNIMAC_RDP_ADDRS[] =
{
    0x828a8004,
    0x828a9004,
    0x828aa004,
    0x828ab004,
};

const ru_block_rec UNIMAC_RDP_BLOCK = 
{
    "UNIMAC_RDP",
    UNIMAC_RDP_ADDRS,
    4,
    188,
    UNIMAC_RDP_REGS
};

/* End of file XRDP_UNIMAC_RDP.c */
