/*
   Copyright (c) 2015 Broadcom
   All Rights Reserved

    <:label-BRCM:2015:DUAL/GPL:standard
    
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License, version 2, as published by
    the Free Software Foundation (the "GPL").
    
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
    
    
    A copy of the GPL is available at http://www.broadcom.com/licenses/GPLv2.php, or by
    writing to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
    
:>
*/

#include "ru.h"

#if RU_INCLUDE_FIELD_DB
/******************************************************************************
 * Field: UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_CFG_MAC_CRC_FWD
 ******************************************************************************/
const ru_field_rec UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_CFG_MAC_CRC_FWD_FIELD =
{
    "MAC_CRC_FWD",
#if RU_INCLUDE_DESC
    "mac_crc_fwd",
    "Forward CRC",
#endif
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_CFG_MAC_CRC_FWD_FIELD_MASK,
    0,
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_CFG_MAC_CRC_FWD_FIELD_WIDTH,
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_CFG_MAC_CRC_FWD_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_CFG_MAC_CRC_OWRT
 ******************************************************************************/
const ru_field_rec UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_CFG_MAC_CRC_OWRT_FIELD =
{
    "MAC_CRC_OWRT",
#if RU_INCLUDE_DESC
    "mac_crc_owrt",
    "Overwrite CRC",
#endif
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_CFG_MAC_CRC_OWRT_FIELD_MASK,
    0,
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_CFG_MAC_CRC_OWRT_FIELD_WIDTH,
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_CFG_MAC_CRC_OWRT_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_CFG_RESERVED0
 ******************************************************************************/
const ru_field_rec UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_CFG_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_CFG_RESERVED0_FIELD_MASK,
    0,
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_CFG_RESERVED0_FIELD_WIDTH,
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_CFG_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG1_MAX_PKT_SIZE
 ******************************************************************************/
const ru_field_rec UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG1_MAX_PKT_SIZE_FIELD =
{
    "MAX_PKT_SIZE",
#if RU_INCLUDE_DESC
    "max_pkt_size",
    "Max Packet Size - Used fro statistics",
#endif
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG1_MAX_PKT_SIZE_FIELD_MASK,
    0,
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG1_MAX_PKT_SIZE_FIELD_WIDTH,
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG1_MAX_PKT_SIZE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG1_RESERVED0
 ******************************************************************************/
const ru_field_rec UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG1_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG1_RESERVED0_FIELD_MASK,
    0,
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG1_RESERVED0_FIELD_WIDTH,
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG1_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG1_RXFIFO_CONGESTION_THRESHOLD
 ******************************************************************************/
const ru_field_rec UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG1_RXFIFO_CONGESTION_THRESHOLD_FIELD =
{
    "RXFIFO_CONGESTION_THRESHOLD",
#if RU_INCLUDE_DESC
    "rxfifo_congestion_threshold",
    "RX FIFO Threshold - This is the fifo located between the UNIMAC IP and BBH. Once the threshold is reached, rx_fifo_congestion output is set."
    "This configuration is in 16-byte resolution (the number of bytes in a FIFO line)."
    "Max value is: 0x100.",
#endif
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG1_RXFIFO_CONGESTION_THRESHOLD_FIELD_MASK,
    0,
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG1_RXFIFO_CONGESTION_THRESHOLD_FIELD_WIDTH,
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG1_RXFIFO_CONGESTION_THRESHOLD_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG1_RESERVED1
 ******************************************************************************/
const ru_field_rec UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG1_RESERVED1_FIELD =
{
    "RESERVED1",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG1_RESERVED1_FIELD_MASK,
    0,
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG1_RESERVED1_FIELD_WIDTH,
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG1_RESERVED1_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG2_RXFIFO_PAUSE_THRESHOLD
 ******************************************************************************/
const ru_field_rec UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG2_RXFIFO_PAUSE_THRESHOLD_FIELD =
{
    "RXFIFO_PAUSE_THRESHOLD",
#if RU_INCLUDE_DESC
    "rxfifo_pause_threshold",
    "RX FIFO Threshold - This is the fifo located between the UNIMAC IP and BBH. Once the threshold is reached, pause is sent. This configuration is in 16-byte resolution (the number of bytes in a FIFO line)."
    "Max Value is 0x100.",
#endif
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG2_RXFIFO_PAUSE_THRESHOLD_FIELD_MASK,
    0,
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG2_RXFIFO_PAUSE_THRESHOLD_FIELD_WIDTH,
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG2_RXFIFO_PAUSE_THRESHOLD_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG2_RESERVED0
 ******************************************************************************/
const ru_field_rec UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG2_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG2_RESERVED0_FIELD_MASK,
    0,
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG2_RESERVED0_FIELD_WIDTH,
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG2_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG2_BACKPRESSURE_ENABLE_INT
 ******************************************************************************/
const ru_field_rec UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG2_BACKPRESSURE_ENABLE_INT_FIELD =
{
    "BACKPRESSURE_ENABLE_INT",
#if RU_INCLUDE_DESC
    "backpressure_enable_int",
    "Backpressure enable for internal unimac",
#endif
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG2_BACKPRESSURE_ENABLE_INT_FIELD_MASK,
    0,
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG2_BACKPRESSURE_ENABLE_INT_FIELD_WIDTH,
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG2_BACKPRESSURE_ENABLE_INT_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG2_BACKPRESSURE_ENABLE_EXT
 ******************************************************************************/
const ru_field_rec UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG2_BACKPRESSURE_ENABLE_EXT_FIELD =
{
    "BACKPRESSURE_ENABLE_EXT",
#if RU_INCLUDE_DESC
    "backpressure_enable_ext",
    "Backpressure enable for external switch",
#endif
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG2_BACKPRESSURE_ENABLE_EXT_FIELD_MASK,
    0,
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG2_BACKPRESSURE_ENABLE_EXT_FIELD_WIDTH,
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG2_BACKPRESSURE_ENABLE_EXT_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG2_FIFO_OVERRUN_CTL_EN
 ******************************************************************************/
const ru_field_rec UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG2_FIFO_OVERRUN_CTL_EN_FIELD =
{
    "FIFO_OVERRUN_CTL_EN",
#if RU_INCLUDE_DESC
    "fifo_overrun_ctl_en",
    "Enable the mechanism for always receiving data from UNIMAC IP and dropping overrun words in the unimac_glue FIFO.",
#endif
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG2_FIFO_OVERRUN_CTL_EN_FIELD_MASK,
    0,
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG2_FIFO_OVERRUN_CTL_EN_FIELD_WIDTH,
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG2_FIFO_OVERRUN_CTL_EN_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG2_REMOTE_LOOPBACK_EN
 ******************************************************************************/
const ru_field_rec UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG2_REMOTE_LOOPBACK_EN_FIELD =
{
    "REMOTE_LOOPBACK_EN",
#if RU_INCLUDE_DESC
    "remote_loopback_en",
    "When setting this bit, RX recovered clock will also input the clk25/pll_ref_clk in the UNIMAC.",
#endif
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG2_REMOTE_LOOPBACK_EN_FIELD_MASK,
    0,
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG2_REMOTE_LOOPBACK_EN_FIELD_WIDTH,
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG2_REMOTE_LOOPBACK_EN_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG2_RESERVED1
 ******************************************************************************/
const ru_field_rec UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG2_RESERVED1_FIELD =
{
    "RESERVED1",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG2_RESERVED1_FIELD_MASK,
    0,
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG2_RESERVED1_FIELD_WIDTH,
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG2_RESERVED1_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_PORT_RATE
 ******************************************************************************/
const ru_field_rec UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_PORT_RATE_FIELD =
{
    "PORT_RATE",
#if RU_INCLUDE_DESC
    "port_data_rate",
    "Port data rate, to be used in LED block.                                 encoded as:"
    "3b000:   10Mb/s"
    "3b001:  100Mb/s"
    "3b010: 1000Mb/s"
    "3b011: 2500Mb/s"
    "3b100:   10Gb/s or higher"
    "3b101:    5Gb/s"
    "3b110: reserved"
    "3b111: reserved"
    ""
    "",
#endif
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_PORT_RATE_FIELD_MASK,
    0,
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_PORT_RATE_FIELD_WIDTH,
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_PORT_RATE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_LPI_TX_DETECT
 ******************************************************************************/
const ru_field_rec UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_LPI_TX_DETECT_FIELD =
{
    "LPI_TX_DETECT",
#if RU_INCLUDE_DESC
    "lpi_tx_detect",
    "Transmit LPI State - Set to 1 whenever LPI_IDLES are being Sent out on the TX Line",
#endif
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_LPI_TX_DETECT_FIELD_MASK,
    0,
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_LPI_TX_DETECT_FIELD_WIDTH,
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_LPI_TX_DETECT_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_LPI_RX_DETECT
 ******************************************************************************/
const ru_field_rec UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_LPI_RX_DETECT_FIELD =
{
    "LPI_RX_DETECT",
#if RU_INCLUDE_DESC
    "lpi_rx_detect",
    "Receive LPI State - Set to 1 whenever LPI_IDLES are being received on the RX Line",
#endif
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_LPI_RX_DETECT_FIELD_MASK,
    0,
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_LPI_RX_DETECT_FIELD_WIDTH,
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_LPI_RX_DETECT_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_PP_STATS
 ******************************************************************************/
const ru_field_rec UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_PP_STATS_FIELD =
{
    "PP_STATS",
#if RU_INCLUDE_DESC
    "pp_stats",
    "The XOFF/XON status of the receiving PPP control frame"
    "",
#endif
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_PP_STATS_FIELD_MASK,
    0,
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_PP_STATS_FIELD_WIDTH,
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_PP_STATS_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_PP_STATS_VALID
 ******************************************************************************/
const ru_field_rec UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_PP_STATS_VALID_FIELD =
{
    "PP_STATS_VALID",
#if RU_INCLUDE_DESC
    "pp_stats_valid",
    "MAC to indicate a PPP control frame is received"
    "",
#endif
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_PP_STATS_VALID_FIELD_MASK,
    0,
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_PP_STATS_VALID_FIELD_WIDTH,
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_PP_STATS_VALID_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_RESERVED0
 ******************************************************************************/
const ru_field_rec UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_RESERVED0_FIELD_MASK,
    0,
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_RESERVED0_FIELD_WIDTH,
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_DEBUG_DEBUG_SEL
 ******************************************************************************/
const ru_field_rec UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_DEBUG_DEBUG_SEL_FIELD =
{
    "DEBUG_SEL",
#if RU_INCLUDE_DESC
    "debug_sel",
    "Select which debug bus to output.",
#endif
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_DEBUG_DEBUG_SEL_FIELD_MASK,
    0,
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_DEBUG_DEBUG_SEL_FIELD_WIDTH,
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_DEBUG_DEBUG_SEL_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_DEBUG_RESERVED0
 ******************************************************************************/
const ru_field_rec UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_DEBUG_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_DEBUG_RESERVED0_FIELD_MASK,
    0,
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_DEBUG_RESERVED0_FIELD_WIDTH,
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_DEBUG_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_RST_UNIMAC_RST
 ******************************************************************************/
const ru_field_rec UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_RST_UNIMAC_RST_FIELD =
{
    "UNIMAC_RST",
#if RU_INCLUDE_DESC
    "unimac_rst",
    "Synchronous UNIMAC reset",
#endif
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_RST_UNIMAC_RST_FIELD_MASK,
    0,
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_RST_UNIMAC_RST_FIELD_WIDTH,
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_RST_UNIMAC_RST_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_RST_RESERVED0
 ******************************************************************************/
const ru_field_rec UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_RST_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_RST_RESERVED0_FIELD_MASK,
    0,
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_RST_RESERVED0_FIELD_WIDTH,
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_RST_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_OVERRUN_COUNTER_OVERRUN_COUNTER
 ******************************************************************************/
const ru_field_rec UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_OVERRUN_COUNTER_OVERRUN_COUNTER_FIELD =
{
    "OVERRUN_COUNTER",
#if RU_INCLUDE_DESC
    "overrun_counter",
    "This registers holds the number of 128-bit lines that were received from the UNIMAC IP, but were thrown due to the fact that the unimac_glue FIFO was full. This field stops counting when it reaches 0xff and will be cleared upon read.",
#endif
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_OVERRUN_COUNTER_OVERRUN_COUNTER_FIELD_MASK,
    0,
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_OVERRUN_COUNTER_OVERRUN_COUNTER_FIELD_WIDTH,
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_OVERRUN_COUNTER_OVERRUN_COUNTER_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_1588_TSI_SIGN_EXT
 ******************************************************************************/
const ru_field_rec UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_1588_TSI_SIGN_EXT_FIELD =
{
    "TSI_SIGN_EXT",
#if RU_INCLUDE_DESC
    "tsi_sign_ext",
    "The MAC logic will need to evaluate this bit in order to determine how to sign extend the Timestamp (TSe)."
    "If the bit is a zero, the TSe MUST be sign extended with zeros."
    "If the bit is a one, the TSe MUST be sign extended based on the Msbit of the TSe. That is, if the Msbit of the TSe is zero, the TSe is signed extended with zeros. If the Msbit of the TSe is one, the TSe is sign extended with one. (from unimac spec)"
    "",
#endif
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_1588_TSI_SIGN_EXT_FIELD_MASK,
    0,
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_1588_TSI_SIGN_EXT_FIELD_WIDTH,
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_1588_TSI_SIGN_EXT_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_1588_OSTS_TIMER_DIS
 ******************************************************************************/
const ru_field_rec UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_1588_OSTS_TIMER_DIS_FIELD =
{
    "OSTS_TIMER_DIS",
#if RU_INCLUDE_DESC
    "osts_timer_disable",
    "This active high signal is used to disable the OSTS time-stamping function in the MAC when asserted during the time the CPU Is initializing the local counters.(from unimac spec)",
#endif
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_1588_OSTS_TIMER_DIS_FIELD_MASK,
    0,
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_1588_OSTS_TIMER_DIS_FIELD_WIDTH,
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_1588_OSTS_TIMER_DIS_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_1588_EGR_1588_TS_MODE
 ******************************************************************************/
const ru_field_rec UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_1588_EGR_1588_TS_MODE_FIELD =
{
    "EGR_1588_TS_MODE",
#if RU_INCLUDE_DESC
    "egr_1588_timestamping_mode",
    "When set to 0, enables legacy sign-extension of 32-bit timestamp, when 1, enables 48-bit time-stamping. (from unimac spec)",
#endif
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_1588_EGR_1588_TS_MODE_FIELD_MASK,
    0,
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_1588_EGR_1588_TS_MODE_FIELD_WIDTH,
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_1588_EGR_1588_TS_MODE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_1588_RESERVED0
 ******************************************************************************/
const ru_field_rec UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_1588_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_1588_RESERVED0_FIELD_MASK,
    0,
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_1588_RESERVED0_FIELD_WIDTH,
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_1588_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_MISC_UNIMAC_TOP_UNIMAC_INTS_ISR_GEN_INT
 ******************************************************************************/
const ru_field_rec UNIMAC_MISC_UNIMAC_TOP_UNIMAC_INTS_ISR_GEN_INT_FIELD =
{
    "GEN_INT",
#if RU_INCLUDE_DESC
    "general_int",
    "general interrupt",
#endif
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_INTS_ISR_GEN_INT_FIELD_MASK,
    0,
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_INTS_ISR_GEN_INT_FIELD_WIDTH,
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_INTS_ISR_GEN_INT_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_MISC_UNIMAC_TOP_UNIMAC_INTS_ISR_RESERVED0
 ******************************************************************************/
const ru_field_rec UNIMAC_MISC_UNIMAC_TOP_UNIMAC_INTS_ISR_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_INTS_ISR_RESERVED0_FIELD_MASK,
    0,
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_INTS_ISR_RESERVED0_FIELD_WIDTH,
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_INTS_ISR_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_MISC_UNIMAC_TOP_UNIMAC_INTS_IER_VALUE
 ******************************************************************************/
const ru_field_rec UNIMAC_MISC_UNIMAC_TOP_UNIMAC_INTS_IER_VALUE_FIELD =
{
    "VALUE",
#if RU_INCLUDE_DESC
    "Value",
    "The bit description is the same like for the ISR.",
#endif
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_INTS_IER_VALUE_FIELD_MASK,
    0,
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_INTS_IER_VALUE_FIELD_WIDTH,
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_INTS_IER_VALUE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_MISC_UNIMAC_TOP_UNIMAC_INTS_IER_RESERVED0
 ******************************************************************************/
const ru_field_rec UNIMAC_MISC_UNIMAC_TOP_UNIMAC_INTS_IER_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_INTS_IER_RESERVED0_FIELD_MASK,
    0,
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_INTS_IER_RESERVED0_FIELD_WIDTH,
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_INTS_IER_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_MISC_UNIMAC_TOP_UNIMAC_INTS_ITR_VALUE
 ******************************************************************************/
const ru_field_rec UNIMAC_MISC_UNIMAC_TOP_UNIMAC_INTS_ITR_VALUE_FIELD =
{
    "VALUE",
#if RU_INCLUDE_DESC
    "Value",
    "The bit description is the same like for the ISR.",
#endif
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_INTS_ITR_VALUE_FIELD_MASK,
    0,
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_INTS_ITR_VALUE_FIELD_WIDTH,
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_INTS_ITR_VALUE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_MISC_UNIMAC_TOP_UNIMAC_INTS_ITR_RESERVED0
 ******************************************************************************/
const ru_field_rec UNIMAC_MISC_UNIMAC_TOP_UNIMAC_INTS_ITR_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_INTS_ITR_RESERVED0_FIELD_MASK,
    0,
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_INTS_ITR_RESERVED0_FIELD_WIDTH,
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_INTS_ITR_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: UNIMAC_MISC_UNIMAC_TOP_UNIMAC_INTS_ISM_VALUE
 ******************************************************************************/
const ru_field_rec UNIMAC_MISC_UNIMAC_TOP_UNIMAC_INTS_ISM_VALUE_FIELD =
{
    "VALUE",
#if RU_INCLUDE_DESC
    "Value",
    "The bit description is the same like for the ISR.",
#endif
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_INTS_ISM_VALUE_FIELD_MASK,
    0,
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_INTS_ISM_VALUE_FIELD_WIDTH,
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_INTS_ISM_VALUE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: UNIMAC_MISC_UNIMAC_TOP_UNIMAC_INTS_ISM_RESERVED0
 ******************************************************************************/
const ru_field_rec UNIMAC_MISC_UNIMAC_TOP_UNIMAC_INTS_ISM_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_INTS_ISM_RESERVED0_FIELD_MASK,
    0,
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_INTS_ISM_RESERVED0_FIELD_WIDTH,
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_INTS_ISM_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

#endif /* RU_INCLUDE_FIELD_DB */

/******************************************************************************
 * Register: UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_CFG
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_CFG_FIELDS[] =
{
    &UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_CFG_MAC_CRC_FWD_FIELD,
    &UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_CFG_MAC_CRC_OWRT_FIELD,
    &UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_CFG_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_CFG_REG = 
{
    "UNIMAC_TOP_UNIMAC_MISC_UNIMAC_CFG",
#if RU_INCLUDE_DESC
    "UNIMAC_CFG Register",
    "Interface static configuration values",
#endif
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_CFG_REG_OFFSET,
    0,
    0,
    1046,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    3,
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_CFG_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG1
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG1_FIELDS[] =
{
    &UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG1_MAX_PKT_SIZE_FIELD,
    &UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG1_RESERVED0_FIELD,
    &UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG1_RXFIFO_CONGESTION_THRESHOLD_FIELD,
    &UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG1_RESERVED1_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG1_REG = 
{
    "UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG1",
#if RU_INCLUDE_DESC
    "UNIMAC_EXT_CFG1 Register",
    "Configure additional parameters that influence UNIMAC external logic.",
#endif
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG1_REG_OFFSET,
    0,
    0,
    1047,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    4,
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG1_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG2
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG2_FIELDS[] =
{
    &UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG2_RXFIFO_PAUSE_THRESHOLD_FIELD,
    &UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG2_RESERVED0_FIELD,
    &UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG2_BACKPRESSURE_ENABLE_INT_FIELD,
    &UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG2_BACKPRESSURE_ENABLE_EXT_FIELD,
    &UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG2_FIFO_OVERRUN_CTL_EN_FIELD,
    &UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG2_REMOTE_LOOPBACK_EN_FIELD,
    &UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG2_RESERVED1_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG2_REG = 
{
    "UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG2",
#if RU_INCLUDE_DESC
    "UNIMAC_EXT_CFG2 Register",
    "Configure additional parameters that influence UNIMAC external logic.",
#endif
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG2_REG_OFFSET,
    0,
    0,
    1048,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    7,
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG2_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_FIELDS[] =
{
    &UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_PORT_RATE_FIELD,
    &UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_LPI_TX_DETECT_FIELD,
    &UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_LPI_RX_DETECT_FIELD,
    &UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_PP_STATS_FIELD,
    &UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_PP_STATS_VALID_FIELD,
    &UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_REG = 
{
    "UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT",
#if RU_INCLUDE_DESC
    "UNIMAC_STAT Register",
    "This registers holds status indications of the UNIMAC",
#endif
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_REG_OFFSET,
    0,
    0,
    1049,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    6,
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_DEBUG
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_DEBUG_FIELDS[] =
{
    &UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_DEBUG_DEBUG_SEL_FIELD,
    &UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_DEBUG_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_DEBUG_REG = 
{
    "UNIMAC_TOP_UNIMAC_MISC_UNIMAC_DEBUG",
#if RU_INCLUDE_DESC
    "UNIMAC_DEBUG Register",
    "This register holds all debug related configurations",
#endif
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_DEBUG_REG_OFFSET,
    0,
    0,
    1050,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    2,
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_DEBUG_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_RST
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_RST_FIELDS[] =
{
    &UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_RST_UNIMAC_RST_FIELD,
    &UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_RST_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_RST_REG = 
{
    "UNIMAC_TOP_UNIMAC_MISC_UNIMAC_RST",
#if RU_INCLUDE_DESC
    "UNIMAC_RST Register",
    "This is a synchronous reset to the UNIMAC core",
#endif
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_RST_REG_OFFSET,
    0,
    0,
    1051,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    2,
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_RST_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_OVERRUN_COUNTER
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_OVERRUN_COUNTER_FIELDS[] =
{
    &UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_OVERRUN_COUNTER_OVERRUN_COUNTER_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_OVERRUN_COUNTER_REG = 
{
    "UNIMAC_TOP_UNIMAC_MISC_UNIMAC_OVERRUN_COUNTER",
#if RU_INCLUDE_DESC
    "UNIMAC_OVERRUN_COUNTER Register",
    "This registers holds the number of 128-bit lines that were received from the UNIMAC IP, but were thrown due to the fact that the unimac_glue FIFO was full.",
#endif
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_OVERRUN_COUNTER_REG_OFFSET,
    0,
    0,
    1052,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_OVERRUN_COUNTER_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_1588
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_1588_FIELDS[] =
{
    &UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_1588_TSI_SIGN_EXT_FIELD,
    &UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_1588_OSTS_TIMER_DIS_FIELD,
    &UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_1588_EGR_1588_TS_MODE_FIELD,
    &UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_1588_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_1588_REG = 
{
    "UNIMAC_TOP_UNIMAC_MISC_UNIMAC_1588",
#if RU_INCLUDE_DESC
    "UNIMAC_1588 Register",
    "1588 configurations",
#endif
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_1588_REG_OFFSET,
    0,
    0,
    1053,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    4,
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_1588_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_MISC_UNIMAC_TOP_UNIMAC_INTS_ISR
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_MISC_UNIMAC_TOP_UNIMAC_INTS_ISR_FIELDS[] =
{
    &UNIMAC_MISC_UNIMAC_TOP_UNIMAC_INTS_ISR_GEN_INT_FIELD,
    &UNIMAC_MISC_UNIMAC_TOP_UNIMAC_INTS_ISR_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_MISC_UNIMAC_TOP_UNIMAC_INTS_ISR_REG = 
{
    "UNIMAC_TOP_UNIMAC_INTS_ISR",
#if RU_INCLUDE_DESC
    "ISR Register",
    "This register provides status bits for all the general interrupt sources.",
#endif
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_INTS_ISR_REG_OFFSET,
    0,
    0,
    1054,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    2,
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_INTS_ISR_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_MISC_UNIMAC_TOP_UNIMAC_INTS_IER
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_MISC_UNIMAC_TOP_UNIMAC_INTS_IER_FIELDS[] =
{
    &UNIMAC_MISC_UNIMAC_TOP_UNIMAC_INTS_IER_VALUE_FIELD,
    &UNIMAC_MISC_UNIMAC_TOP_UNIMAC_INTS_IER_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_MISC_UNIMAC_TOP_UNIMAC_INTS_IER_REG = 
{
    "UNIMAC_TOP_UNIMAC_INTS_IER",
#if RU_INCLUDE_DESC
    "IER Register",
    "This register provides enable bits for all the general interrupt sources."
    "The bit description is the same like for the ISR.",
#endif
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_INTS_IER_REG_OFFSET,
    0,
    0,
    1055,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    2,
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_INTS_IER_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_MISC_UNIMAC_TOP_UNIMAC_INTS_ITR
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_MISC_UNIMAC_TOP_UNIMAC_INTS_ITR_FIELDS[] =
{
    &UNIMAC_MISC_UNIMAC_TOP_UNIMAC_INTS_ITR_VALUE_FIELD,
    &UNIMAC_MISC_UNIMAC_TOP_UNIMAC_INTS_ITR_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_MISC_UNIMAC_TOP_UNIMAC_INTS_ITR_REG = 
{
    "UNIMAC_TOP_UNIMAC_INTS_ITR",
#if RU_INCLUDE_DESC
    "ITR Register",
    "This register enables alarm interrupt testing. Writing 1 to a bit in this register sets the corresponding bit in the ISR register. Read always returns 0."
    "The bit description is the same like for the ISR.",
#endif
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_INTS_ITR_REG_OFFSET,
    0,
    0,
    1056,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    2,
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_INTS_ITR_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: UNIMAC_MISC_UNIMAC_TOP_UNIMAC_INTS_ISM
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *UNIMAC_MISC_UNIMAC_TOP_UNIMAC_INTS_ISM_FIELDS[] =
{
    &UNIMAC_MISC_UNIMAC_TOP_UNIMAC_INTS_ISM_VALUE_FIELD,
    &UNIMAC_MISC_UNIMAC_TOP_UNIMAC_INTS_ISM_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec UNIMAC_MISC_UNIMAC_TOP_UNIMAC_INTS_ISM_REG = 
{
    "UNIMAC_TOP_UNIMAC_INTS_ISM",
#if RU_INCLUDE_DESC
    "ISM Register",
    "This read only register provides masked status bits. Each bit corresponds to logical AND operation between the corresponding bits of the ISR and IER registers.The bit description is the same like for the ISR.",
#endif
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_INTS_ISM_REG_OFFSET,
    0,
    0,
    1057,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    2,
    UNIMAC_MISC_UNIMAC_TOP_UNIMAC_INTS_ISM_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Block: UNIMAC_MISC
 ******************************************************************************/
static const ru_reg_rec *UNIMAC_MISC_REGS[] =
{
    &UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_CFG_REG,
    &UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG1_REG,
    &UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG2_REG,
    &UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_REG,
    &UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_DEBUG_REG,
    &UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_RST_REG,
    &UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_OVERRUN_COUNTER_REG,
    &UNIMAC_MISC_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_1588_REG,
    &UNIMAC_MISC_UNIMAC_TOP_UNIMAC_INTS_ISR_REG,
    &UNIMAC_MISC_UNIMAC_TOP_UNIMAC_INTS_IER_REG,
    &UNIMAC_MISC_UNIMAC_TOP_UNIMAC_INTS_ITR_REG,
    &UNIMAC_MISC_UNIMAC_TOP_UNIMAC_INTS_ISM_REG,
};

unsigned long UNIMAC_MISC_ADDRS[] =
{
    0x828b0000,
    0x828b0400,
    0x828b0800,
    0x828b0c00,
};

const ru_block_rec UNIMAC_MISC_BLOCK = 
{
    "UNIMAC_MISC",
    UNIMAC_MISC_ADDRS,
    4,
    12,
    UNIMAC_MISC_REGS
};

/* End of file XRDP_UNIMAC_MISC.c */
