/*
   Copyright (c) 2015 Broadcom
   All Rights Reserved

    <:label-BRCM:2015:DUAL/GPL:standard
    
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License, version 2, as published by
    the Free Software Foundation (the "GPL").
    
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
    
    
    A copy of the GPL is available at http://www.broadcom.com/licenses/GPLv2.php, or by
    writing to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
    
:>
*/

#include "ru.h"

#if RU_INCLUDE_FIELD_DB
/******************************************************************************
 * Field: RNR_REGS_CFG_GLOBAL_CTRL_EN
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_GLOBAL_CTRL_EN_FIELD =
{
    "EN",
#if RU_INCLUDE_DESC
    "enable",
    "Runner enable. When reset runner pipe is halted, instruction memory and context memory can be accessed by the CPU. The CPU can reset or set this bit"
    "The firmware can reset this bit by writing to the disable bit at the runner I/O control register.",
#endif
    RNR_REGS_CFG_GLOBAL_CTRL_EN_FIELD_MASK,
    0,
    RNR_REGS_CFG_GLOBAL_CTRL_EN_FIELD_WIDTH,
    RNR_REGS_CFG_GLOBAL_CTRL_EN_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_GLOBAL_CTRL_DMA_ILLEGAL_STATUS
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_GLOBAL_CTRL_DMA_ILLEGAL_STATUS_FIELD =
{
    "DMA_ILLEGAL_STATUS",
#if RU_INCLUDE_DESC
    "dma_illegal",
    "Notifies about DMA illegal access (>16 cycles on UBUS). Sticky bit. cleared by writing 1 to this bit.",
#endif
    RNR_REGS_CFG_GLOBAL_CTRL_DMA_ILLEGAL_STATUS_FIELD_MASK,
    0,
    RNR_REGS_CFG_GLOBAL_CTRL_DMA_ILLEGAL_STATUS_FIELD_WIDTH,
    RNR_REGS_CFG_GLOBAL_CTRL_DMA_ILLEGAL_STATUS_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_GLOBAL_CTRL_PREDICTION_OVERRUN_STATUS
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_GLOBAL_CTRL_PREDICTION_OVERRUN_STATUS_FIELD =
{
    "PREDICTION_OVERRUN_STATUS",
#if RU_INCLUDE_DESC
    "prediction_overrun_status",
    "Notifies about prediction FIFO overwrite status. Sticky bit. cleared by writing 1 to this bit.",
#endif
    RNR_REGS_CFG_GLOBAL_CTRL_PREDICTION_OVERRUN_STATUS_FIELD_MASK,
    0,
    RNR_REGS_CFG_GLOBAL_CTRL_PREDICTION_OVERRUN_STATUS_FIELD_WIDTH,
    RNR_REGS_CFG_GLOBAL_CTRL_PREDICTION_OVERRUN_STATUS_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_GLOBAL_CTRL_GDMA_CHKSUM_DEST_ILLEGAL
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_GLOBAL_CTRL_GDMA_CHKSUM_DEST_ILLEGAL_FIELD =
{
    "GDMA_CHKSUM_DEST_ILLEGAL",
#if RU_INCLUDE_DESC
    "gdma_chksum_dest_illegal",
    "GDMA checksum write back destination if out of bounds. checksum desc is ignored."
    "Sticky bit. cleared by writing 1 to this bit.",
#endif
    RNR_REGS_CFG_GLOBAL_CTRL_GDMA_CHKSUM_DEST_ILLEGAL_FIELD_MASK,
    0,
    RNR_REGS_CFG_GLOBAL_CTRL_GDMA_CHKSUM_DEST_ILLEGAL_FIELD_WIDTH,
    RNR_REGS_CFG_GLOBAL_CTRL_GDMA_CHKSUM_DEST_ILLEGAL_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_GLOBAL_CTRL_GDMA_CHKSUM_LEN_ILLEGAL
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_GLOBAL_CTRL_GDMA_CHKSUM_LEN_ILLEGAL_FIELD =
{
    "GDMA_CHKSUM_LEN_ILLEGAL",
#if RU_INCLUDE_DESC
    "gdma_chksum_len_illegal",
    "GDMA checksum length is out of bounds. Checksum desc is ignored."
    "Sticky bit. cleared by writing 1 to this bit.",
#endif
    RNR_REGS_CFG_GLOBAL_CTRL_GDMA_CHKSUM_LEN_ILLEGAL_FIELD_MASK,
    0,
    RNR_REGS_CFG_GLOBAL_CTRL_GDMA_CHKSUM_LEN_ILLEGAL_FIELD_WIDTH,
    RNR_REGS_CFG_GLOBAL_CTRL_GDMA_CHKSUM_LEN_ILLEGAL_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_GLOBAL_CTRL_GDMA_TOTAL_DESCS_ILLEGAL
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_GLOBAL_CTRL_GDMA_TOTAL_DESCS_ILLEGAL_FIELD =
{
    "GDMA_TOTAL_DESCS_ILLEGAL",
#if RU_INCLUDE_DESC
    "gdma_total_desc_illegal",
    "Total length of GDMA descriptors exceeds configured value of 32B or 64B."
    "The data is written according to all descs which are bounded in 32B or 64B. The crossing descriptor is ignored."
    "Sticky bit. cleared by writing 1 to this bit.",
#endif
    RNR_REGS_CFG_GLOBAL_CTRL_GDMA_TOTAL_DESCS_ILLEGAL_FIELD_MASK,
    0,
    RNR_REGS_CFG_GLOBAL_CTRL_GDMA_TOTAL_DESCS_ILLEGAL_FIELD_WIDTH,
    RNR_REGS_CFG_GLOBAL_CTRL_GDMA_TOTAL_DESCS_ILLEGAL_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_GLOBAL_CTRL_GDMA_INCOMPLETE_ILLEGAL
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_GLOBAL_CTRL_GDMA_INCOMPLETE_ILLEGAL_FIELD =
{
    "GDMA_INCOMPLETE_ILLEGAL",
#if RU_INCLUDE_DESC
    "gdma_incomplete_illegal",
    "Total byte count according to all read descs is less than GDMA command BC."
    "GDMA writes all the data which is described by the descriptors."
    "Sticky bit. cleared by writing 1 to this bit.",
#endif
    RNR_REGS_CFG_GLOBAL_CTRL_GDMA_INCOMPLETE_ILLEGAL_FIELD_MASK,
    0,
    RNR_REGS_CFG_GLOBAL_CTRL_GDMA_INCOMPLETE_ILLEGAL_FIELD_WIDTH,
    RNR_REGS_CFG_GLOBAL_CTRL_GDMA_INCOMPLETE_ILLEGAL_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_GLOBAL_CTRL_GDMA_CHKSUM_OVERLAP_ILLEGAL
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_GLOBAL_CTRL_GDMA_CHKSUM_OVERLAP_ILLEGAL_FIELD =
{
    "GDMA_CHKSUM_OVERLAP_ILLEGAL",
#if RU_INCLUDE_DESC
    "gdma_chksum_overlap_illegal",
    "GDMA checksum length or destination overlaps with another checksum descriptor. The second checksum desc is ignored."
    "Sticky bit. cleared by writing 1 to this bit.",
#endif
    RNR_REGS_CFG_GLOBAL_CTRL_GDMA_CHKSUM_OVERLAP_ILLEGAL_FIELD_MASK,
    0,
    RNR_REGS_CFG_GLOBAL_CTRL_GDMA_CHKSUM_OVERLAP_ILLEGAL_FIELD_WIDTH,
    RNR_REGS_CFG_GLOBAL_CTRL_GDMA_CHKSUM_OVERLAP_ILLEGAL_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_GLOBAL_CTRL_MICRO_SEC_VAL
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_GLOBAL_CTRL_MICRO_SEC_VAL_FIELD =
{
    "MICRO_SEC_VAL",
#if RU_INCLUDE_DESC
    "Micro_sec_val",
    "",
#endif
    RNR_REGS_CFG_GLOBAL_CTRL_MICRO_SEC_VAL_FIELD_MASK,
    0,
    RNR_REGS_CFG_GLOBAL_CTRL_MICRO_SEC_VAL_FIELD_WIDTH,
    RNR_REGS_CFG_GLOBAL_CTRL_MICRO_SEC_VAL_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_GLOBAL_CTRL_RESERVED0
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_GLOBAL_CTRL_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    RNR_REGS_CFG_GLOBAL_CTRL_RESERVED0_FIELD_MASK,
    0,
    RNR_REGS_CFG_GLOBAL_CTRL_RESERVED0_FIELD_WIDTH,
    RNR_REGS_CFG_GLOBAL_CTRL_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_CPU_WAKEUP_THREAD_NUM
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_CPU_WAKEUP_THREAD_NUM_FIELD =
{
    "THREAD_NUM",
#if RU_INCLUDE_DESC
    "Thread_Number",
    "The thread number to be invoked by the CPU.",
#endif
    RNR_REGS_CFG_CPU_WAKEUP_THREAD_NUM_FIELD_MASK,
    0,
    RNR_REGS_CFG_CPU_WAKEUP_THREAD_NUM_FIELD_WIDTH,
    RNR_REGS_CFG_CPU_WAKEUP_THREAD_NUM_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_CPU_WAKEUP_RESERVED0
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_CPU_WAKEUP_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    RNR_REGS_CFG_CPU_WAKEUP_RESERVED0_FIELD_MASK,
    0,
    RNR_REGS_CFG_CPU_WAKEUP_RESERVED0_FIELD_WIDTH,
    RNR_REGS_CFG_CPU_WAKEUP_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_INT_CTRL_INT0_STS
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_INT_CTRL_INT0_STS_FIELD =
{
    "INT0_STS",
#if RU_INCLUDE_DESC
    "Interrupt_0_status",
    "While any of this field bits is set interrupt line 0 is set. SW can write '1' to clear any bit. Write of '0' is ignored.",
#endif
    RNR_REGS_CFG_INT_CTRL_INT0_STS_FIELD_MASK,
    0,
    RNR_REGS_CFG_INT_CTRL_INT0_STS_FIELD_WIDTH,
    RNR_REGS_CFG_INT_CTRL_INT0_STS_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_INT_CTRL_INT1_STS
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_INT_CTRL_INT1_STS_FIELD =
{
    "INT1_STS",
#if RU_INCLUDE_DESC
    "Interrupt_1_status",
    "While any of this field bits is set interrupt line 0 is set. SW can write '1' to clear any bit. Write of '0' is ignored.",
#endif
    RNR_REGS_CFG_INT_CTRL_INT1_STS_FIELD_MASK,
    0,
    RNR_REGS_CFG_INT_CTRL_INT1_STS_FIELD_WIDTH,
    RNR_REGS_CFG_INT_CTRL_INT1_STS_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_INT_CTRL_INT2_STS
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_INT_CTRL_INT2_STS_FIELD =
{
    "INT2_STS",
#if RU_INCLUDE_DESC
    "Interrupt2_status",
    "While this bit is set interrupt line 2 is set. SW can write '1' to clear any bit. Write of '0' is ignored.",
#endif
    RNR_REGS_CFG_INT_CTRL_INT2_STS_FIELD_MASK,
    0,
    RNR_REGS_CFG_INT_CTRL_INT2_STS_FIELD_WIDTH,
    RNR_REGS_CFG_INT_CTRL_INT2_STS_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_INT_CTRL_INT3_STS
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_INT_CTRL_INT3_STS_FIELD =
{
    "INT3_STS",
#if RU_INCLUDE_DESC
    "Interrupt3_status",
    "While this bit is set interrupt line 3 is set. SW can write '1' to clear any bit. Write of '0' is ignored.",
#endif
    RNR_REGS_CFG_INT_CTRL_INT3_STS_FIELD_MASK,
    0,
    RNR_REGS_CFG_INT_CTRL_INT3_STS_FIELD_WIDTH,
    RNR_REGS_CFG_INT_CTRL_INT3_STS_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_INT_CTRL_INT4_STS
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_INT_CTRL_INT4_STS_FIELD =
{
    "INT4_STS",
#if RU_INCLUDE_DESC
    "Interrupt4_status",
    "While this bit is set interrupt line 4 is set. SW can write '1' to clear any bit. Write of '0' is ignored.",
#endif
    RNR_REGS_CFG_INT_CTRL_INT4_STS_FIELD_MASK,
    0,
    RNR_REGS_CFG_INT_CTRL_INT4_STS_FIELD_WIDTH,
    RNR_REGS_CFG_INT_CTRL_INT4_STS_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_INT_CTRL_INT5_STS
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_INT_CTRL_INT5_STS_FIELD =
{
    "INT5_STS",
#if RU_INCLUDE_DESC
    "Interrupt5_status",
    "While this bit is set interrupt line 5 is set. SW can write '1' to clear any bit. Write of '0' is ignored.",
#endif
    RNR_REGS_CFG_INT_CTRL_INT5_STS_FIELD_MASK,
    0,
    RNR_REGS_CFG_INT_CTRL_INT5_STS_FIELD_WIDTH,
    RNR_REGS_CFG_INT_CTRL_INT5_STS_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_INT_CTRL_INT6_STS
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_INT_CTRL_INT6_STS_FIELD =
{
    "INT6_STS",
#if RU_INCLUDE_DESC
    "Interrupt6_status",
    "While this bit is set interrupt line 6 is set. SW can write '1' to clear any bit. Write of '0' is ignored.",
#endif
    RNR_REGS_CFG_INT_CTRL_INT6_STS_FIELD_MASK,
    0,
    RNR_REGS_CFG_INT_CTRL_INT6_STS_FIELD_WIDTH,
    RNR_REGS_CFG_INT_CTRL_INT6_STS_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_INT_CTRL_INT7_STS
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_INT_CTRL_INT7_STS_FIELD =
{
    "INT7_STS",
#if RU_INCLUDE_DESC
    "Interrupt7_status",
    "While this bit is set interrupt line 6 is set. SW can write '1' to clear any bit. Write of '0' is ignored.",
#endif
    RNR_REGS_CFG_INT_CTRL_INT7_STS_FIELD_MASK,
    0,
    RNR_REGS_CFG_INT_CTRL_INT7_STS_FIELD_WIDTH,
    RNR_REGS_CFG_INT_CTRL_INT7_STS_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_INT_CTRL_INT8_STS
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_INT_CTRL_INT8_STS_FIELD =
{
    "INT8_STS",
#if RU_INCLUDE_DESC
    "Interrupt8_status",
    "While this bit is set interrupt line 8 is set. SW can write '1' to clear any bit. Write of '0' is ignored.",
#endif
    RNR_REGS_CFG_INT_CTRL_INT8_STS_FIELD_MASK,
    0,
    RNR_REGS_CFG_INT_CTRL_INT8_STS_FIELD_WIDTH,
    RNR_REGS_CFG_INT_CTRL_INT8_STS_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_INT_CTRL_INT9_STS
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_INT_CTRL_INT9_STS_FIELD =
{
    "INT9_STS",
#if RU_INCLUDE_DESC
    "Interrupt9_status",
    "While this bit is set interrupt line 9 is set. SW can write '1' to clear any bit. Write of '0' is ignored.",
#endif
    RNR_REGS_CFG_INT_CTRL_INT9_STS_FIELD_MASK,
    0,
    RNR_REGS_CFG_INT_CTRL_INT9_STS_FIELD_WIDTH,
    RNR_REGS_CFG_INT_CTRL_INT9_STS_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_INT_CTRL_RESERVED0
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_INT_CTRL_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    RNR_REGS_CFG_INT_CTRL_RESERVED0_FIELD_MASK,
    0,
    RNR_REGS_CFG_INT_CTRL_RESERVED0_FIELD_WIDTH,
    RNR_REGS_CFG_INT_CTRL_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_INT_CTRL_FIT_FAIL_STS
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_INT_CTRL_FIT_FAIL_STS_FIELD =
{
    "FIT_FAIL_STS",
#if RU_INCLUDE_DESC
    "Fit_fail_status",
    "",
#endif
    RNR_REGS_CFG_INT_CTRL_FIT_FAIL_STS_FIELD_MASK,
    0,
    RNR_REGS_CFG_INT_CTRL_FIT_FAIL_STS_FIELD_WIDTH,
    RNR_REGS_CFG_INT_CTRL_FIT_FAIL_STS_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_INT_MASK_INT0_MASK
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_INT_MASK_INT0_MASK_FIELD =
{
    "INT0_MASK",
#if RU_INCLUDE_DESC
    "Interrupt_0_mask",
    "Mask INT0 causes",
#endif
    RNR_REGS_CFG_INT_MASK_INT0_MASK_FIELD_MASK,
    0,
    RNR_REGS_CFG_INT_MASK_INT0_MASK_FIELD_WIDTH,
    RNR_REGS_CFG_INT_MASK_INT0_MASK_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_INT_MASK_INT1_MASK
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_INT_MASK_INT1_MASK_FIELD =
{
    "INT1_MASK",
#if RU_INCLUDE_DESC
    "Interrupt_1_mask",
    "INT1 mask cause",
#endif
    RNR_REGS_CFG_INT_MASK_INT1_MASK_FIELD_MASK,
    0,
    RNR_REGS_CFG_INT_MASK_INT1_MASK_FIELD_WIDTH,
    RNR_REGS_CFG_INT_MASK_INT1_MASK_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_INT_MASK_INT2_MASK
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_INT_MASK_INT2_MASK_FIELD =
{
    "INT2_MASK",
#if RU_INCLUDE_DESC
    "Interrupt_2_mask",
    "INT2 mask cause",
#endif
    RNR_REGS_CFG_INT_MASK_INT2_MASK_FIELD_MASK,
    0,
    RNR_REGS_CFG_INT_MASK_INT2_MASK_FIELD_WIDTH,
    RNR_REGS_CFG_INT_MASK_INT2_MASK_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_INT_MASK_INT3_MASK
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_INT_MASK_INT3_MASK_FIELD =
{
    "INT3_MASK",
#if RU_INCLUDE_DESC
    "Interrupt_3_mask",
    "INT3 mask cause",
#endif
    RNR_REGS_CFG_INT_MASK_INT3_MASK_FIELD_MASK,
    0,
    RNR_REGS_CFG_INT_MASK_INT3_MASK_FIELD_WIDTH,
    RNR_REGS_CFG_INT_MASK_INT3_MASK_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_INT_MASK_INT4_MASK
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_INT_MASK_INT4_MASK_FIELD =
{
    "INT4_MASK",
#if RU_INCLUDE_DESC
    "Interrupt_4_mask",
    "INT4 mask cause",
#endif
    RNR_REGS_CFG_INT_MASK_INT4_MASK_FIELD_MASK,
    0,
    RNR_REGS_CFG_INT_MASK_INT4_MASK_FIELD_WIDTH,
    RNR_REGS_CFG_INT_MASK_INT4_MASK_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_INT_MASK_INT5_MASK
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_INT_MASK_INT5_MASK_FIELD =
{
    "INT5_MASK",
#if RU_INCLUDE_DESC
    "Interrupt_5_mask",
    "INT5 mask cause",
#endif
    RNR_REGS_CFG_INT_MASK_INT5_MASK_FIELD_MASK,
    0,
    RNR_REGS_CFG_INT_MASK_INT5_MASK_FIELD_WIDTH,
    RNR_REGS_CFG_INT_MASK_INT5_MASK_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_INT_MASK_INT6_MASK
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_INT_MASK_INT6_MASK_FIELD =
{
    "INT6_MASK",
#if RU_INCLUDE_DESC
    "Interrupt_6_mask",
    "INT6 mask cause",
#endif
    RNR_REGS_CFG_INT_MASK_INT6_MASK_FIELD_MASK,
    0,
    RNR_REGS_CFG_INT_MASK_INT6_MASK_FIELD_WIDTH,
    RNR_REGS_CFG_INT_MASK_INT6_MASK_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_INT_MASK_INT7_MASK
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_INT_MASK_INT7_MASK_FIELD =
{
    "INT7_MASK",
#if RU_INCLUDE_DESC
    "Inerrupt_7_mask",
    "INT7 mask cause",
#endif
    RNR_REGS_CFG_INT_MASK_INT7_MASK_FIELD_MASK,
    0,
    RNR_REGS_CFG_INT_MASK_INT7_MASK_FIELD_WIDTH,
    RNR_REGS_CFG_INT_MASK_INT7_MASK_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_INT_MASK_INT8_MASK
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_INT_MASK_INT8_MASK_FIELD =
{
    "INT8_MASK",
#if RU_INCLUDE_DESC
    "Interrupt_8_mask",
    "INT8 mask cause",
#endif
    RNR_REGS_CFG_INT_MASK_INT8_MASK_FIELD_MASK,
    0,
    RNR_REGS_CFG_INT_MASK_INT8_MASK_FIELD_WIDTH,
    RNR_REGS_CFG_INT_MASK_INT8_MASK_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_INT_MASK_INT9_MASK
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_INT_MASK_INT9_MASK_FIELD =
{
    "INT9_MASK",
#if RU_INCLUDE_DESC
    "Interrupt_9_mask",
    "INT9 mask cause",
#endif
    RNR_REGS_CFG_INT_MASK_INT9_MASK_FIELD_MASK,
    0,
    RNR_REGS_CFG_INT_MASK_INT9_MASK_FIELD_WIDTH,
    RNR_REGS_CFG_INT_MASK_INT9_MASK_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_INT_MASK_RESERVED0
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_INT_MASK_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    RNR_REGS_CFG_INT_MASK_RESERVED0_FIELD_MASK,
    0,
    RNR_REGS_CFG_INT_MASK_RESERVED0_FIELD_WIDTH,
    RNR_REGS_CFG_INT_MASK_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_GEN_CFG_DISABLE_DMA_OLD_FLOW_CONTROL
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_GEN_CFG_DISABLE_DMA_OLD_FLOW_CONTROL_FIELD =
{
    "DISABLE_DMA_OLD_FLOW_CONTROL",
#if RU_INCLUDE_DESC
    "DISABLE_DMA_OLD_FLOW_CONTROL",
    "Disable DMA old flow control. When set to 1, DMA will not check read FIFO occupancy when issuing READ requests, relying instead on DMA backpressure mechanism vs read dispatcher block.",
#endif
    RNR_REGS_CFG_GEN_CFG_DISABLE_DMA_OLD_FLOW_CONTROL_FIELD_MASK,
    0,
    RNR_REGS_CFG_GEN_CFG_DISABLE_DMA_OLD_FLOW_CONTROL_FIELD_WIDTH,
    RNR_REGS_CFG_GEN_CFG_DISABLE_DMA_OLD_FLOW_CONTROL_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_GEN_CFG_TEST_FIT_FAIL
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_GEN_CFG_TEST_FIT_FAIL_FIELD =
{
    "TEST_FIT_FAIL",
#if RU_INCLUDE_DESC
    "TEST_FIT_FAIL",
    "set to 1 to test fit fail interrupt.",
#endif
    RNR_REGS_CFG_GEN_CFG_TEST_FIT_FAIL_FIELD_MASK,
    0,
    RNR_REGS_CFG_GEN_CFG_TEST_FIT_FAIL_FIELD_WIDTH,
    RNR_REGS_CFG_GEN_CFG_TEST_FIT_FAIL_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_GEN_CFG_ZERO_DATA_MEM
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_GEN_CFG_ZERO_DATA_MEM_FIELD =
{
    "ZERO_DATA_MEM",
#if RU_INCLUDE_DESC
    "ZERO_DATA_MEM",
    "Trigger self-zeroing mechanism for data memory."
    "",
#endif
    RNR_REGS_CFG_GEN_CFG_ZERO_DATA_MEM_FIELD_MASK,
    0,
    RNR_REGS_CFG_GEN_CFG_ZERO_DATA_MEM_FIELD_WIDTH,
    RNR_REGS_CFG_GEN_CFG_ZERO_DATA_MEM_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_GEN_CFG_ZERO_CONTEXT_MEM
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_GEN_CFG_ZERO_CONTEXT_MEM_FIELD =
{
    "ZERO_CONTEXT_MEM",
#if RU_INCLUDE_DESC
    "ZERO_CONTEXT_MEM",
    "Trigger self-zeroing mechanism for context memory."
    "",
#endif
    RNR_REGS_CFG_GEN_CFG_ZERO_CONTEXT_MEM_FIELD_MASK,
    0,
    RNR_REGS_CFG_GEN_CFG_ZERO_CONTEXT_MEM_FIELD_WIDTH,
    RNR_REGS_CFG_GEN_CFG_ZERO_CONTEXT_MEM_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_GEN_CFG_ZERO_DATA_MEM_DONE
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_GEN_CFG_ZERO_DATA_MEM_DONE_FIELD =
{
    "ZERO_DATA_MEM_DONE",
#if RU_INCLUDE_DESC
    "ZERO_DATA_MEM_DONE",
    "Goes high when zeroing is done. Reset to 0 when config ZERO_DATA_MEM is set to 1",
#endif
    RNR_REGS_CFG_GEN_CFG_ZERO_DATA_MEM_DONE_FIELD_MASK,
    0,
    RNR_REGS_CFG_GEN_CFG_ZERO_DATA_MEM_DONE_FIELD_WIDTH,
    RNR_REGS_CFG_GEN_CFG_ZERO_DATA_MEM_DONE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_GEN_CFG_ZERO_CONTEXT_MEM_DONE
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_GEN_CFG_ZERO_CONTEXT_MEM_DONE_FIELD =
{
    "ZERO_CONTEXT_MEM_DONE",
#if RU_INCLUDE_DESC
    "ZERO_CONTEXT_MEM_DONE",
    "Goes high when zeroing is done. Reset to 0 when config ZERO_CONTEXT_MEM is set to 1",
#endif
    RNR_REGS_CFG_GEN_CFG_ZERO_CONTEXT_MEM_DONE_FIELD_MASK,
    0,
    RNR_REGS_CFG_GEN_CFG_ZERO_CONTEXT_MEM_DONE_FIELD_WIDTH,
    RNR_REGS_CFG_GEN_CFG_ZERO_CONTEXT_MEM_DONE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_GEN_CFG_CHICKEN_DISABLE_SKIP_JMP
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_GEN_CFG_CHICKEN_DISABLE_SKIP_JMP_FIELD =
{
    "CHICKEN_DISABLE_SKIP_JMP",
#if RU_INCLUDE_DESC
    "CHICKEN_DISABLE_SKIP_JMP",
    "When set to 1, skip jump functionality is disabled",
#endif
    RNR_REGS_CFG_GEN_CFG_CHICKEN_DISABLE_SKIP_JMP_FIELD_MASK,
    0,
    RNR_REGS_CFG_GEN_CFG_CHICKEN_DISABLE_SKIP_JMP_FIELD_WIDTH,
    RNR_REGS_CFG_GEN_CFG_CHICKEN_DISABLE_SKIP_JMP_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_GEN_CFG_CHICKEN_DISABLE_ALU_LOAD_BALANCING
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_GEN_CFG_CHICKEN_DISABLE_ALU_LOAD_BALANCING_FIELD =
{
    "CHICKEN_DISABLE_ALU_LOAD_BALANCING",
#if RU_INCLUDE_DESC
    "CHICKEN_DISABLE_ALU_LOAD_BALANCING",
    "When set to 1, ALU load balancing functionality is disabled",
#endif
    RNR_REGS_CFG_GEN_CFG_CHICKEN_DISABLE_ALU_LOAD_BALANCING_FIELD_MASK,
    0,
    RNR_REGS_CFG_GEN_CFG_CHICKEN_DISABLE_ALU_LOAD_BALANCING_FIELD_WIDTH,
    RNR_REGS_CFG_GEN_CFG_CHICKEN_DISABLE_ALU_LOAD_BALANCING_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_GEN_CFG_GDMA_DESC_OFFSET
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_GEN_CFG_GDMA_DESC_OFFSET_FIELD =
{
    "GDMA_DESC_OFFSET",
#if RU_INCLUDE_DESC
    "gdma_desc_offset",
    "Configure descriptor offset for GATHER DMA command",
#endif
    RNR_REGS_CFG_GEN_CFG_GDMA_DESC_OFFSET_FIELD_MASK,
    0,
    RNR_REGS_CFG_GEN_CFG_GDMA_DESC_OFFSET_FIELD_WIDTH,
    RNR_REGS_CFG_GEN_CFG_GDMA_DESC_OFFSET_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_GEN_CFG_BBTX_TCAM_DEST_SEL
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_GEN_CFG_BBTX_TCAM_DEST_SEL_FIELD =
{
    "BBTX_TCAM_DEST_SEL",
#if RU_INCLUDE_DESC
    "BBTX_TCAM_DEST_SEL",
    "Select destination TCAM for Runner",
#endif
    RNR_REGS_CFG_GEN_CFG_BBTX_TCAM_DEST_SEL_FIELD_MASK,
    0,
    RNR_REGS_CFG_GEN_CFG_BBTX_TCAM_DEST_SEL_FIELD_WIDTH,
    RNR_REGS_CFG_GEN_CFG_BBTX_TCAM_DEST_SEL_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_GEN_CFG_BBTX_HASH_DEST_SEL
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_GEN_CFG_BBTX_HASH_DEST_SEL_FIELD =
{
    "BBTX_HASH_DEST_SEL",
#if RU_INCLUDE_DESC
    "BBTX_HASH_DEST_SEL",
    "Select destination HASH for Runner",
#endif
    RNR_REGS_CFG_GEN_CFG_BBTX_HASH_DEST_SEL_FIELD_MASK,
    0,
    RNR_REGS_CFG_GEN_CFG_BBTX_HASH_DEST_SEL_FIELD_WIDTH,
    RNR_REGS_CFG_GEN_CFG_BBTX_HASH_DEST_SEL_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_GEN_CFG_BBTX_NATC_DEST_SEL
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_GEN_CFG_BBTX_NATC_DEST_SEL_FIELD =
{
    "BBTX_NATC_DEST_SEL",
#if RU_INCLUDE_DESC
    "BBTX_NATC_DEST_SEL",
    "Select destination NATC for Runner",
#endif
    RNR_REGS_CFG_GEN_CFG_BBTX_NATC_DEST_SEL_FIELD_MASK,
    0,
    RNR_REGS_CFG_GEN_CFG_BBTX_NATC_DEST_SEL_FIELD_WIDTH,
    RNR_REGS_CFG_GEN_CFG_BBTX_NATC_DEST_SEL_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_GEN_CFG_BBTX_CNPL_DEST_SEL
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_GEN_CFG_BBTX_CNPL_DEST_SEL_FIELD =
{
    "BBTX_CNPL_DEST_SEL",
#if RU_INCLUDE_DESC
    "BBTX_CNPL_DEST_SEL",
    "Select destination CNPL for Runner",
#endif
    RNR_REGS_CFG_GEN_CFG_BBTX_CNPL_DEST_SEL_FIELD_MASK,
    0,
    RNR_REGS_CFG_GEN_CFG_BBTX_CNPL_DEST_SEL_FIELD_WIDTH,
    RNR_REGS_CFG_GEN_CFG_BBTX_CNPL_DEST_SEL_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_GEN_CFG_GDMA_GDESC_BUFFER_SIZE
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_GEN_CFG_GDMA_GDESC_BUFFER_SIZE_FIELD =
{
    "GDMA_GDESC_BUFFER_SIZE",
#if RU_INCLUDE_DESC
    "GDMA_GDESC_BUFFER_SIZE",
    "0 - GDMA prefetches 32B when reading descriptors from the data memory"
    "1 - GDMA prefetches 64B when reading descriptors from the data memory"
    ""
    "if 0 is set then total number of gather descriptors per GDMA command isnt allowed to exceed 32B.",
#endif
    RNR_REGS_CFG_GEN_CFG_GDMA_GDESC_BUFFER_SIZE_FIELD_MASK,
    0,
    RNR_REGS_CFG_GEN_CFG_GDMA_GDESC_BUFFER_SIZE_FIELD_WIDTH,
    RNR_REGS_CFG_GEN_CFG_GDMA_GDESC_BUFFER_SIZE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_GEN_CFG_CHICKEN_ENABLE_OLD_UNIQUE_ID_MODE
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_GEN_CFG_CHICKEN_ENABLE_OLD_UNIQUE_ID_MODE_FIELD =
{
    "CHICKEN_ENABLE_OLD_UNIQUE_ID_MODE",
#if RU_INCLUDE_DESC
    "CHICKEN_ENABLE_OLD_UNIQUE_ID_MODE",
    "When set to 1, use old mode for unique ID assignment",
#endif
    RNR_REGS_CFG_GEN_CFG_CHICKEN_ENABLE_OLD_UNIQUE_ID_MODE_FIELD_MASK,
    0,
    RNR_REGS_CFG_GEN_CFG_CHICKEN_ENABLE_OLD_UNIQUE_ID_MODE_FIELD_WIDTH,
    RNR_REGS_CFG_GEN_CFG_CHICKEN_ENABLE_OLD_UNIQUE_ID_MODE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_GEN_CFG_CHICKEN_ENABLE_DMA_OLD_MODE
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_GEN_CFG_CHICKEN_ENABLE_DMA_OLD_MODE_FIELD =
{
    "CHICKEN_ENABLE_DMA_OLD_MODE",
#if RU_INCLUDE_DESC
    "CHICKEN_ENABLE_DMA_OLD_MODE",
    "When set to 1, use old mode for 40 bit address calculation",
#endif
    RNR_REGS_CFG_GEN_CFG_CHICKEN_ENABLE_DMA_OLD_MODE_FIELD_MASK,
    0,
    RNR_REGS_CFG_GEN_CFG_CHICKEN_ENABLE_DMA_OLD_MODE_FIELD_WIDTH,
    RNR_REGS_CFG_GEN_CFG_CHICKEN_ENABLE_DMA_OLD_MODE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_GEN_CFG_CHICKEN_DISABLE_BRANCH_SIZE_SIX
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_GEN_CFG_CHICKEN_DISABLE_BRANCH_SIZE_SIX_FIELD =
{
    "CHICKEN_DISABLE_BRANCH_SIZE_SIX",
#if RU_INCLUDE_DESC
    "CHICKEN_DISABLE_BRANCH_SIZE_SIX",
    "When set to 1, branch pipe limited to 4 stages",
#endif
    RNR_REGS_CFG_GEN_CFG_CHICKEN_DISABLE_BRANCH_SIZE_SIX_FIELD_MASK,
    0,
    RNR_REGS_CFG_GEN_CFG_CHICKEN_DISABLE_BRANCH_SIZE_SIX_FIELD_WIDTH,
    RNR_REGS_CFG_GEN_CFG_CHICKEN_DISABLE_BRANCH_SIZE_SIX_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_GEN_CFG_RESERVED0
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_GEN_CFG_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    RNR_REGS_CFG_GEN_CFG_RESERVED0_FIELD_MASK,
    0,
    RNR_REGS_CFG_GEN_CFG_RESERVED0_FIELD_WIDTH,
    RNR_REGS_CFG_GEN_CFG_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_CAM_CFG_STOP_VALUE
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_CAM_CFG_STOP_VALUE_FIELD =
{
    "STOP_VALUE",
#if RU_INCLUDE_DESC
    "Stop_Value",
    "CAM operation is stopped when reaching an entry with a value matching this field."
    "For a 32-bit or 64-bit CAM entries, this value is concatenated.",
#endif
    RNR_REGS_CFG_CAM_CFG_STOP_VALUE_FIELD_MASK,
    0,
    RNR_REGS_CFG_CAM_CFG_STOP_VALUE_FIELD_WIDTH,
    RNR_REGS_CFG_CAM_CFG_STOP_VALUE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_CAM_CFG_RESERVED0
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_CAM_CFG_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    RNR_REGS_CFG_CAM_CFG_RESERVED0_FIELD_MASK,
    0,
    RNR_REGS_CFG_CAM_CFG_RESERVED0_FIELD_WIDTH,
    RNR_REGS_CFG_CAM_CFG_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_DDR_CFG_DMA_BASE
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_DDR_CFG_DMA_BASE_FIELD =
{
    "DMA_BASE",
#if RU_INCLUDE_DESC
    "DMA_base_address",
    "DMA base address for ADDR_CALC",
#endif
    RNR_REGS_CFG_DDR_CFG_DMA_BASE_FIELD_MASK,
    0,
    RNR_REGS_CFG_DDR_CFG_DMA_BASE_FIELD_WIDTH,
    RNR_REGS_CFG_DDR_CFG_DMA_BASE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_DDR_CFG_DMA_BUF_SIZE
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_DDR_CFG_DMA_BUF_SIZE_FIELD =
{
    "DMA_BUF_SIZE",
#if RU_INCLUDE_DESC
    "DMA_buffer_size",
    "3 bits indicating buffer size",
#endif
    RNR_REGS_CFG_DDR_CFG_DMA_BUF_SIZE_FIELD_MASK,
    0,
    RNR_REGS_CFG_DDR_CFG_DMA_BUF_SIZE_FIELD_WIDTH,
    RNR_REGS_CFG_DDR_CFG_DMA_BUF_SIZE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_DDR_CFG_DMA_BUF_SIZE_MODE
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_DDR_CFG_DMA_BUF_SIZE_MODE_FIELD =
{
    "DMA_BUF_SIZE_MODE",
#if RU_INCLUDE_DESC
    "DMA_buffer_size_mode",
    "Determine old buffer  mode or new mode."
    "Old mode: 128, 256, 512, 1024, 2048"
    "New mode: 128, 320, 640, 1280, 2560",
#endif
    RNR_REGS_CFG_DDR_CFG_DMA_BUF_SIZE_MODE_FIELD_MASK,
    0,
    RNR_REGS_CFG_DDR_CFG_DMA_BUF_SIZE_MODE_FIELD_WIDTH,
    RNR_REGS_CFG_DDR_CFG_DMA_BUF_SIZE_MODE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_DDR_CFG_DMA_STATIC_OFFSET
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_DDR_CFG_DMA_STATIC_OFFSET_FIELD =
{
    "DMA_STATIC_OFFSET",
#if RU_INCLUDE_DESC
    "DMA_static_offset",
    "DMA static offset",
#endif
    RNR_REGS_CFG_DDR_CFG_DMA_STATIC_OFFSET_FIELD_MASK,
    0,
    RNR_REGS_CFG_DDR_CFG_DMA_STATIC_OFFSET_FIELD_WIDTH,
    RNR_REGS_CFG_DDR_CFG_DMA_STATIC_OFFSET_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_PSRAM_CFG_DMA_BASE
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_PSRAM_CFG_DMA_BASE_FIELD =
{
    "DMA_BASE",
#if RU_INCLUDE_DESC
    "DMA_base_address",
    "DMA base address for ADDR_CALC",
#endif
    RNR_REGS_CFG_PSRAM_CFG_DMA_BASE_FIELD_MASK,
    0,
    RNR_REGS_CFG_PSRAM_CFG_DMA_BASE_FIELD_WIDTH,
    RNR_REGS_CFG_PSRAM_CFG_DMA_BASE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_PSRAM_CFG_DMA_BUF_SIZE
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_PSRAM_CFG_DMA_BUF_SIZE_FIELD =
{
    "DMA_BUF_SIZE",
#if RU_INCLUDE_DESC
    "DMA_buffer_size",
    "3 bits indicating buffer size",
#endif
    RNR_REGS_CFG_PSRAM_CFG_DMA_BUF_SIZE_FIELD_MASK,
    0,
    RNR_REGS_CFG_PSRAM_CFG_DMA_BUF_SIZE_FIELD_WIDTH,
    RNR_REGS_CFG_PSRAM_CFG_DMA_BUF_SIZE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_PSRAM_CFG_DMA_BUF_SIZE_MODE
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_PSRAM_CFG_DMA_BUF_SIZE_MODE_FIELD =
{
    "DMA_BUF_SIZE_MODE",
#if RU_INCLUDE_DESC
    "DMA_buffer_size_mode",
    "Determine old buffer  mode or new mode"
    "Old mode: 128, 256, 512, 1024, 2048"
    "New mode: 128, 320, 640, 1280, 2560",
#endif
    RNR_REGS_CFG_PSRAM_CFG_DMA_BUF_SIZE_MODE_FIELD_MASK,
    0,
    RNR_REGS_CFG_PSRAM_CFG_DMA_BUF_SIZE_MODE_FIELD_WIDTH,
    RNR_REGS_CFG_PSRAM_CFG_DMA_BUF_SIZE_MODE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_PSRAM_CFG_DMA_STATIC_OFFSET
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_PSRAM_CFG_DMA_STATIC_OFFSET_FIELD =
{
    "DMA_STATIC_OFFSET",
#if RU_INCLUDE_DESC
    "DMA_static_offset",
    "DMA static offset",
#endif
    RNR_REGS_CFG_PSRAM_CFG_DMA_STATIC_OFFSET_FIELD_MASK,
    0,
    RNR_REGS_CFG_PSRAM_CFG_DMA_STATIC_OFFSET_FIELD_WIDTH,
    RNR_REGS_CFG_PSRAM_CFG_DMA_STATIC_OFFSET_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_RAMRD_RANGE_MASK_CFG_MASK0
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_RAMRD_RANGE_MASK_CFG_MASK0_FIELD =
{
    "MASK0",
#if RU_INCLUDE_DESC
    "MASK0",
    "Mask 0 for range serach. according to the number of 1 in the mask the cam machine can differ between the Key and TAG",
#endif
    RNR_REGS_CFG_RAMRD_RANGE_MASK_CFG_MASK0_FIELD_MASK,
    0,
    RNR_REGS_CFG_RAMRD_RANGE_MASK_CFG_MASK0_FIELD_WIDTH,
    RNR_REGS_CFG_RAMRD_RANGE_MASK_CFG_MASK0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_RAMRD_RANGE_MASK_CFG_MASK1
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_RAMRD_RANGE_MASK_CFG_MASK1_FIELD =
{
    "MASK1",
#if RU_INCLUDE_DESC
    "MASK1",
    "Mask 0 for range serach. according to the number of 1 in the mask the cam machine can differ between the Key and TAG",
#endif
    RNR_REGS_CFG_RAMRD_RANGE_MASK_CFG_MASK1_FIELD_MASK,
    0,
    RNR_REGS_CFG_RAMRD_RANGE_MASK_CFG_MASK1_FIELD_WIDTH,
    RNR_REGS_CFG_RAMRD_RANGE_MASK_CFG_MASK1_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_SCH_CFG_SCHEDULER_MODE
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_SCH_CFG_SCHEDULER_MODE_FIELD =
{
    "SCHEDULER_MODE",
#if RU_INCLUDE_DESC
    "MODE",
    "Configure priority mode for scheduler operation",
#endif
    RNR_REGS_CFG_SCH_CFG_SCHEDULER_MODE_FIELD_MASK,
    0,
    RNR_REGS_CFG_SCH_CFG_SCHEDULER_MODE_FIELD_WIDTH,
    RNR_REGS_CFG_SCH_CFG_SCHEDULER_MODE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_SCH_CFG_RESERVED0
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_SCH_CFG_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    RNR_REGS_CFG_SCH_CFG_RESERVED0_FIELD_MASK,
    0,
    RNR_REGS_CFG_SCH_CFG_RESERVED0_FIELD_WIDTH,
    RNR_REGS_CFG_SCH_CFG_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_BKPT_CFG_BKPT_0_EN
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_BKPT_CFG_BKPT_0_EN_FIELD =
{
    "BKPT_0_EN",
#if RU_INCLUDE_DESC
    "BKPT_0_EN",
    "Enable breakpoint 0",
#endif
    RNR_REGS_CFG_BKPT_CFG_BKPT_0_EN_FIELD_MASK,
    0,
    RNR_REGS_CFG_BKPT_CFG_BKPT_0_EN_FIELD_WIDTH,
    RNR_REGS_CFG_BKPT_CFG_BKPT_0_EN_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_BKPT_CFG_BKPT_0_USE_THREAD
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_BKPT_CFG_BKPT_0_USE_THREAD_FIELD =
{
    "BKPT_0_USE_THREAD",
#if RU_INCLUDE_DESC
    "BKPT_0_USE_THREAD",
    "Enable breakpoint for given thread only",
#endif
    RNR_REGS_CFG_BKPT_CFG_BKPT_0_USE_THREAD_FIELD_MASK,
    0,
    RNR_REGS_CFG_BKPT_CFG_BKPT_0_USE_THREAD_FIELD_WIDTH,
    RNR_REGS_CFG_BKPT_CFG_BKPT_0_USE_THREAD_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_BKPT_CFG_BKPT_1_EN
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_BKPT_CFG_BKPT_1_EN_FIELD =
{
    "BKPT_1_EN",
#if RU_INCLUDE_DESC
    "BKPT_1_EN",
    "Enable breakpoint 1",
#endif
    RNR_REGS_CFG_BKPT_CFG_BKPT_1_EN_FIELD_MASK,
    0,
    RNR_REGS_CFG_BKPT_CFG_BKPT_1_EN_FIELD_WIDTH,
    RNR_REGS_CFG_BKPT_CFG_BKPT_1_EN_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_BKPT_CFG_BKPT_1_USE_THREAD
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_BKPT_CFG_BKPT_1_USE_THREAD_FIELD =
{
    "BKPT_1_USE_THREAD",
#if RU_INCLUDE_DESC
    "BKPT_1_USE_THREAD",
    "Enable breakpoint for given thread only",
#endif
    RNR_REGS_CFG_BKPT_CFG_BKPT_1_USE_THREAD_FIELD_MASK,
    0,
    RNR_REGS_CFG_BKPT_CFG_BKPT_1_USE_THREAD_FIELD_WIDTH,
    RNR_REGS_CFG_BKPT_CFG_BKPT_1_USE_THREAD_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_BKPT_CFG_BKPT_2_EN
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_BKPT_CFG_BKPT_2_EN_FIELD =
{
    "BKPT_2_EN",
#if RU_INCLUDE_DESC
    "BKPT_2_EN",
    "Enable breakpoint 2",
#endif
    RNR_REGS_CFG_BKPT_CFG_BKPT_2_EN_FIELD_MASK,
    0,
    RNR_REGS_CFG_BKPT_CFG_BKPT_2_EN_FIELD_WIDTH,
    RNR_REGS_CFG_BKPT_CFG_BKPT_2_EN_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_BKPT_CFG_BKPT_2_USE_THREAD
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_BKPT_CFG_BKPT_2_USE_THREAD_FIELD =
{
    "BKPT_2_USE_THREAD",
#if RU_INCLUDE_DESC
    "BKPT_2_USE_THREAD",
    "Enable breakpoint for given thread only",
#endif
    RNR_REGS_CFG_BKPT_CFG_BKPT_2_USE_THREAD_FIELD_MASK,
    0,
    RNR_REGS_CFG_BKPT_CFG_BKPT_2_USE_THREAD_FIELD_WIDTH,
    RNR_REGS_CFG_BKPT_CFG_BKPT_2_USE_THREAD_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_BKPT_CFG_BKPT_3_EN
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_BKPT_CFG_BKPT_3_EN_FIELD =
{
    "BKPT_3_EN",
#if RU_INCLUDE_DESC
    "BKPT_3_EN",
    "Enable breakpoint 3",
#endif
    RNR_REGS_CFG_BKPT_CFG_BKPT_3_EN_FIELD_MASK,
    0,
    RNR_REGS_CFG_BKPT_CFG_BKPT_3_EN_FIELD_WIDTH,
    RNR_REGS_CFG_BKPT_CFG_BKPT_3_EN_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_BKPT_CFG_BKPT_3_USE_THREAD
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_BKPT_CFG_BKPT_3_USE_THREAD_FIELD =
{
    "BKPT_3_USE_THREAD",
#if RU_INCLUDE_DESC
    "BKPT_3_USE_THREAD",
    "Enable breakpoint for given thread only",
#endif
    RNR_REGS_CFG_BKPT_CFG_BKPT_3_USE_THREAD_FIELD_MASK,
    0,
    RNR_REGS_CFG_BKPT_CFG_BKPT_3_USE_THREAD_FIELD_WIDTH,
    RNR_REGS_CFG_BKPT_CFG_BKPT_3_USE_THREAD_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_BKPT_CFG_BKPT_4_EN
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_BKPT_CFG_BKPT_4_EN_FIELD =
{
    "BKPT_4_EN",
#if RU_INCLUDE_DESC
    "BKPT_4_EN",
    "Enable breakpoint 4",
#endif
    RNR_REGS_CFG_BKPT_CFG_BKPT_4_EN_FIELD_MASK,
    0,
    RNR_REGS_CFG_BKPT_CFG_BKPT_4_EN_FIELD_WIDTH,
    RNR_REGS_CFG_BKPT_CFG_BKPT_4_EN_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_BKPT_CFG_BKPT_4_USE_THREAD
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_BKPT_CFG_BKPT_4_USE_THREAD_FIELD =
{
    "BKPT_4_USE_THREAD",
#if RU_INCLUDE_DESC
    "BKPT_4_USE_THREAD",
    "Enable breakpoint for given thread only",
#endif
    RNR_REGS_CFG_BKPT_CFG_BKPT_4_USE_THREAD_FIELD_MASK,
    0,
    RNR_REGS_CFG_BKPT_CFG_BKPT_4_USE_THREAD_FIELD_WIDTH,
    RNR_REGS_CFG_BKPT_CFG_BKPT_4_USE_THREAD_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_BKPT_CFG_BKPT_5_EN
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_BKPT_CFG_BKPT_5_EN_FIELD =
{
    "BKPT_5_EN",
#if RU_INCLUDE_DESC
    "BKPT_5_EN",
    "Enable breakpoint 5",
#endif
    RNR_REGS_CFG_BKPT_CFG_BKPT_5_EN_FIELD_MASK,
    0,
    RNR_REGS_CFG_BKPT_CFG_BKPT_5_EN_FIELD_WIDTH,
    RNR_REGS_CFG_BKPT_CFG_BKPT_5_EN_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_BKPT_CFG_BKPT_5_USE_THREAD
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_BKPT_CFG_BKPT_5_USE_THREAD_FIELD =
{
    "BKPT_5_USE_THREAD",
#if RU_INCLUDE_DESC
    "BKPT_5_USE_THREAD",
    "Enable breakpoint for given thread only",
#endif
    RNR_REGS_CFG_BKPT_CFG_BKPT_5_USE_THREAD_FIELD_MASK,
    0,
    RNR_REGS_CFG_BKPT_CFG_BKPT_5_USE_THREAD_FIELD_WIDTH,
    RNR_REGS_CFG_BKPT_CFG_BKPT_5_USE_THREAD_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_BKPT_CFG_BKPT_6_EN
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_BKPT_CFG_BKPT_6_EN_FIELD =
{
    "BKPT_6_EN",
#if RU_INCLUDE_DESC
    "BKPT_6_EN",
    "Enable breakpoint 6",
#endif
    RNR_REGS_CFG_BKPT_CFG_BKPT_6_EN_FIELD_MASK,
    0,
    RNR_REGS_CFG_BKPT_CFG_BKPT_6_EN_FIELD_WIDTH,
    RNR_REGS_CFG_BKPT_CFG_BKPT_6_EN_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_BKPT_CFG_BKPT_6_USE_THREAD
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_BKPT_CFG_BKPT_6_USE_THREAD_FIELD =
{
    "BKPT_6_USE_THREAD",
#if RU_INCLUDE_DESC
    "BKPT_6_USE_THREAD",
    "Enable breakpoint for given thread only",
#endif
    RNR_REGS_CFG_BKPT_CFG_BKPT_6_USE_THREAD_FIELD_MASK,
    0,
    RNR_REGS_CFG_BKPT_CFG_BKPT_6_USE_THREAD_FIELD_WIDTH,
    RNR_REGS_CFG_BKPT_CFG_BKPT_6_USE_THREAD_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_BKPT_CFG_BKPT_7_EN
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_BKPT_CFG_BKPT_7_EN_FIELD =
{
    "BKPT_7_EN",
#if RU_INCLUDE_DESC
    "BKPT_7_EN",
    "Enable breakpoint 7",
#endif
    RNR_REGS_CFG_BKPT_CFG_BKPT_7_EN_FIELD_MASK,
    0,
    RNR_REGS_CFG_BKPT_CFG_BKPT_7_EN_FIELD_WIDTH,
    RNR_REGS_CFG_BKPT_CFG_BKPT_7_EN_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_BKPT_CFG_BKPT_7_USE_THREAD
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_BKPT_CFG_BKPT_7_USE_THREAD_FIELD =
{
    "BKPT_7_USE_THREAD",
#if RU_INCLUDE_DESC
    "BKPT_7_USE_THREAD",
    "Enable breakpoint for given thread only",
#endif
    RNR_REGS_CFG_BKPT_CFG_BKPT_7_USE_THREAD_FIELD_MASK,
    0,
    RNR_REGS_CFG_BKPT_CFG_BKPT_7_USE_THREAD_FIELD_WIDTH,
    RNR_REGS_CFG_BKPT_CFG_BKPT_7_USE_THREAD_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_BKPT_CFG_STEP_MODE
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_BKPT_CFG_STEP_MODE_FIELD =
{
    "STEP_MODE",
#if RU_INCLUDE_DESC
    "STEP_MODE",
    "Configure step mode",
#endif
    RNR_REGS_CFG_BKPT_CFG_STEP_MODE_FIELD_MASK,
    0,
    RNR_REGS_CFG_BKPT_CFG_STEP_MODE_FIELD_WIDTH,
    RNR_REGS_CFG_BKPT_CFG_STEP_MODE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_BKPT_CFG_RESERVED0
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_BKPT_CFG_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    RNR_REGS_CFG_BKPT_CFG_RESERVED0_FIELD_MASK,
    0,
    RNR_REGS_CFG_BKPT_CFG_RESERVED0_FIELD_WIDTH,
    RNR_REGS_CFG_BKPT_CFG_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_BKPT_CFG_NEW_FLAGS_VAL
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_BKPT_CFG_NEW_FLAGS_VAL_FIELD =
{
    "NEW_FLAGS_VAL",
#if RU_INCLUDE_DESC
    "NEW_FLAGS_VAL",
    "Value for new flags",
#endif
    RNR_REGS_CFG_BKPT_CFG_NEW_FLAGS_VAL_FIELD_MASK,
    0,
    RNR_REGS_CFG_BKPT_CFG_NEW_FLAGS_VAL_FIELD_WIDTH,
    RNR_REGS_CFG_BKPT_CFG_NEW_FLAGS_VAL_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_BKPT_CFG_ENABLE_BREAKPOINT_ON_FIT_FAIL
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_BKPT_CFG_ENABLE_BREAKPOINT_ON_FIT_FAIL_FIELD =
{
    "ENABLE_BREAKPOINT_ON_FIT_FAIL",
#if RU_INCLUDE_DESC
    "ENABLE_BREAKPOINT_ON_FIT_FAIL",
    "When set to 1, Runner will break on fit_fail",
#endif
    RNR_REGS_CFG_BKPT_CFG_ENABLE_BREAKPOINT_ON_FIT_FAIL_FIELD_MASK,
    0,
    RNR_REGS_CFG_BKPT_CFG_ENABLE_BREAKPOINT_ON_FIT_FAIL_FIELD_WIDTH,
    RNR_REGS_CFG_BKPT_CFG_ENABLE_BREAKPOINT_ON_FIT_FAIL_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_BKPT_CFG_RESERVED1
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_BKPT_CFG_RESERVED1_FIELD =
{
    "RESERVED1",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    RNR_REGS_CFG_BKPT_CFG_RESERVED1_FIELD_MASK,
    0,
    RNR_REGS_CFG_BKPT_CFG_RESERVED1_FIELD_WIDTH,
    RNR_REGS_CFG_BKPT_CFG_RESERVED1_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_BKPT_IMM_ENABLE
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_BKPT_IMM_ENABLE_FIELD =
{
    "ENABLE",
#if RU_INCLUDE_DESC
    "ENABLE_IMM",
    "Enable immediate breakpoint",
#endif
    RNR_REGS_CFG_BKPT_IMM_ENABLE_FIELD_MASK,
    0,
    RNR_REGS_CFG_BKPT_IMM_ENABLE_FIELD_WIDTH,
    RNR_REGS_CFG_BKPT_IMM_ENABLE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_BKPT_IMM_RESERVED0
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_BKPT_IMM_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    RNR_REGS_CFG_BKPT_IMM_RESERVED0_FIELD_MASK,
    0,
    RNR_REGS_CFG_BKPT_IMM_RESERVED0_FIELD_WIDTH,
    RNR_REGS_CFG_BKPT_IMM_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_BKPT_STS_BKPT_ADDR
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_BKPT_STS_BKPT_ADDR_FIELD =
{
    "BKPT_ADDR",
#if RU_INCLUDE_DESC
    "BKPT_ADDR",
    "Breakpoint address",
#endif
    RNR_REGS_CFG_BKPT_STS_BKPT_ADDR_FIELD_MASK,
    0,
    RNR_REGS_CFG_BKPT_STS_BKPT_ADDR_FIELD_WIDTH,
    RNR_REGS_CFG_BKPT_STS_BKPT_ADDR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_BKPT_STS_ACTIVE
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_BKPT_STS_ACTIVE_FIELD =
{
    "ACTIVE",
#if RU_INCLUDE_DESC
    "ACTIVE",
    "Breakpoint active indication",
#endif
    RNR_REGS_CFG_BKPT_STS_ACTIVE_FIELD_MASK,
    0,
    RNR_REGS_CFG_BKPT_STS_ACTIVE_FIELD_WIDTH,
    RNR_REGS_CFG_BKPT_STS_ACTIVE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_BKPT_STS_DATA_BKPT_ADDR
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_BKPT_STS_DATA_BKPT_ADDR_FIELD =
{
    "DATA_BKPT_ADDR",
#if RU_INCLUDE_DESC
    "DATA_BKPT_ADDR",
    "Data address when triggered by breakpoint",
#endif
    RNR_REGS_CFG_BKPT_STS_DATA_BKPT_ADDR_FIELD_MASK,
    0,
    RNR_REGS_CFG_BKPT_STS_DATA_BKPT_ADDR_FIELD_WIDTH,
    RNR_REGS_CFG_BKPT_STS_DATA_BKPT_ADDR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_BKPT_STS_REASON_PC_ADDR
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_BKPT_STS_REASON_PC_ADDR_FIELD =
{
    "REASON_PC_ADDR",
#if RU_INCLUDE_DESC
    "REASON_PC_ADDR",
    "Set to 1 when reason for breakpoint is match on PC address",
#endif
    RNR_REGS_CFG_BKPT_STS_REASON_PC_ADDR_FIELD_MASK,
    0,
    RNR_REGS_CFG_BKPT_STS_REASON_PC_ADDR_FIELD_WIDTH,
    RNR_REGS_CFG_BKPT_STS_REASON_PC_ADDR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_BKPT_STS_REASON_STEP_MODE
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_BKPT_STS_REASON_STEP_MODE_FIELD =
{
    "REASON_STEP_MODE",
#if RU_INCLUDE_DESC
    "REASON_STEP_MODE",
    "Set to 1 when reason for breakpoint is step mode",
#endif
    RNR_REGS_CFG_BKPT_STS_REASON_STEP_MODE_FIELD_MASK,
    0,
    RNR_REGS_CFG_BKPT_STS_REASON_STEP_MODE_FIELD_WIDTH,
    RNR_REGS_CFG_BKPT_STS_REASON_STEP_MODE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_BKPT_STS_REASON_DATA_ADDR
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_BKPT_STS_REASON_DATA_ADDR_FIELD =
{
    "REASON_DATA_ADDR",
#if RU_INCLUDE_DESC
    "REASON_DATA_ADDR",
    "Set to 1 when reason for breakpoint is write to a data address",
#endif
    RNR_REGS_CFG_BKPT_STS_REASON_DATA_ADDR_FIELD_MASK,
    0,
    RNR_REGS_CFG_BKPT_STS_REASON_DATA_ADDR_FIELD_WIDTH,
    RNR_REGS_CFG_BKPT_STS_REASON_DATA_ADDR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_BKPT_STS_REASON_FIT_FAIL
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_BKPT_STS_REASON_FIT_FAIL_FIELD =
{
    "REASON_FIT_FAIL",
#if RU_INCLUDE_DESC
    "REASON_FIT_FAIL",
    "Set to 1 when reason for breakpoint is FIT fail",
#endif
    RNR_REGS_CFG_BKPT_STS_REASON_FIT_FAIL_FIELD_MASK,
    0,
    RNR_REGS_CFG_BKPT_STS_REASON_FIT_FAIL_FIELD_WIDTH,
    RNR_REGS_CFG_BKPT_STS_REASON_FIT_FAIL_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_BKPT_STS_RESERVED0
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_BKPT_STS_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    RNR_REGS_CFG_BKPT_STS_RESERVED0_FIELD_MASK,
    0,
    RNR_REGS_CFG_BKPT_STS_RESERVED0_FIELD_WIDTH,
    RNR_REGS_CFG_BKPT_STS_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_PC_STS_CURRENT_PC_ADDR
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_PC_STS_CURRENT_PC_ADDR_FIELD =
{
    "CURRENT_PC_ADDR",
#if RU_INCLUDE_DESC
    "CURRENT_PC",
    "Current program counter address",
#endif
    RNR_REGS_CFG_PC_STS_CURRENT_PC_ADDR_FIELD_MASK,
    0,
    RNR_REGS_CFG_PC_STS_CURRENT_PC_ADDR_FIELD_WIDTH,
    RNR_REGS_CFG_PC_STS_CURRENT_PC_ADDR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_PC_STS_RESERVED0
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_PC_STS_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    RNR_REGS_CFG_PC_STS_RESERVED0_FIELD_MASK,
    0,
    RNR_REGS_CFG_PC_STS_RESERVED0_FIELD_WIDTH,
    RNR_REGS_CFG_PC_STS_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_PC_STS_PC_RET
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_PC_STS_PC_RET_FIELD =
{
    "PC_RET",
#if RU_INCLUDE_DESC
    "PC_RET",
    "Call stack return address",
#endif
    RNR_REGS_CFG_PC_STS_PC_RET_FIELD_MASK,
    0,
    RNR_REGS_CFG_PC_STS_PC_RET_FIELD_WIDTH,
    RNR_REGS_CFG_PC_STS_PC_RET_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_PC_STS_RESERVED1
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_PC_STS_RESERVED1_FIELD =
{
    "RESERVED1",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    RNR_REGS_CFG_PC_STS_RESERVED1_FIELD_MASK,
    0,
    RNR_REGS_CFG_PC_STS_RESERVED1_FIELD_WIDTH,
    RNR_REGS_CFG_PC_STS_RESERVED1_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_EXT_ACC_CFG_ADDR_BASE
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_EXT_ACC_CFG_ADDR_BASE_FIELD =
{
    "ADDR_BASE",
#if RU_INCLUDE_DESC
    "address_base",
    "address base for calculation."
    "See description under start_thread field",
#endif
    RNR_REGS_CFG_EXT_ACC_CFG_ADDR_BASE_FIELD_MASK,
    0,
    RNR_REGS_CFG_EXT_ACC_CFG_ADDR_BASE_FIELD_WIDTH,
    RNR_REGS_CFG_EXT_ACC_CFG_ADDR_BASE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_EXT_ACC_CFG_RESERVED0
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_EXT_ACC_CFG_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    RNR_REGS_CFG_EXT_ACC_CFG_RESERVED0_FIELD_MASK,
    0,
    RNR_REGS_CFG_EXT_ACC_CFG_RESERVED0_FIELD_WIDTH,
    RNR_REGS_CFG_EXT_ACC_CFG_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_EXT_ACC_CFG_ADDR_STEP_0
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_EXT_ACC_CFG_ADDR_STEP_0_FIELD =
{
    "ADDR_STEP_0",
#if RU_INCLUDE_DESC
    "address_step_0",
    "address step 0 for thread base address calculation. See description under start_thread field.",
#endif
    RNR_REGS_CFG_EXT_ACC_CFG_ADDR_STEP_0_FIELD_MASK,
    0,
    RNR_REGS_CFG_EXT_ACC_CFG_ADDR_STEP_0_FIELD_WIDTH,
    RNR_REGS_CFG_EXT_ACC_CFG_ADDR_STEP_0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_EXT_ACC_CFG_ADDR_STEP_1
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_EXT_ACC_CFG_ADDR_STEP_1_FIELD =
{
    "ADDR_STEP_1",
#if RU_INCLUDE_DESC
    "address_step_1",
    "address step 1 for thread base address calculation. See description under start_thread field.",
#endif
    RNR_REGS_CFG_EXT_ACC_CFG_ADDR_STEP_1_FIELD_MASK,
    0,
    RNR_REGS_CFG_EXT_ACC_CFG_ADDR_STEP_1_FIELD_WIDTH,
    RNR_REGS_CFG_EXT_ACC_CFG_ADDR_STEP_1_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_EXT_ACC_CFG_START_THREAD
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_EXT_ACC_CFG_START_THREAD_FIELD =
{
    "START_THREAD",
#if RU_INCLUDE_DESC
    "start_thread",
    "start thread for calculation."
    ""
    "Address for external accelerator will be calculated as follows:"
    "<adjusted_thread>=<current_thread>-<start_thread>"
    ""
    "acc_thread_address = address_base + adjusted_thread*(2^step_0) + adjusted_thread*(2^step_1)"
    ""
    "Note that if step_0 or step_1 are set to 0, the operands of the equation will still be non-zero."
    "So if total_step is required to be an exact power N of 2, then both step_0 and step_1 should be set to (N-1)."
    "For example if total step is 256 (2^8), then both step_0 and step_1 should be set to 7."
    ""
    "In any case, the resulting address should be always aligned to 8-bytes (64-bits)",
#endif
    RNR_REGS_CFG_EXT_ACC_CFG_START_THREAD_FIELD_MASK,
    0,
    RNR_REGS_CFG_EXT_ACC_CFG_START_THREAD_FIELD_WIDTH,
    RNR_REGS_CFG_EXT_ACC_CFG_START_THREAD_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_EXT_ACC_CFG_RESERVED1
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_EXT_ACC_CFG_RESERVED1_FIELD =
{
    "RESERVED1",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    RNR_REGS_CFG_EXT_ACC_CFG_RESERVED1_FIELD_MASK,
    0,
    RNR_REGS_CFG_EXT_ACC_CFG_RESERVED1_FIELD_WIDTH,
    RNR_REGS_CFG_EXT_ACC_CFG_RESERVED1_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_FIT_FAIL_CFG_START_ADDR
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_FIT_FAIL_CFG_START_ADDR_FIELD =
{
    "START_ADDR",
#if RU_INCLUDE_DESC
    "start_addr",
    "If (current PC >= start_addr) AND (current PC <= stop_addr), fit fail will not be checked. START_ADDR value should be even.",
#endif
    RNR_REGS_CFG_FIT_FAIL_CFG_START_ADDR_FIELD_MASK,
    0,
    RNR_REGS_CFG_FIT_FAIL_CFG_START_ADDR_FIELD_WIDTH,
    RNR_REGS_CFG_FIT_FAIL_CFG_START_ADDR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_FIT_FAIL_CFG_STOP_ADDR
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_FIT_FAIL_CFG_STOP_ADDR_FIELD =
{
    "STOP_ADDR",
#if RU_INCLUDE_DESC
    "stop_addr",
    "If (current PC >= start_addr) AND (current PC <= stop_addr), fit fail will not be checked. STOP_ADDR value should be even.",
#endif
    RNR_REGS_CFG_FIT_FAIL_CFG_STOP_ADDR_FIELD_MASK,
    0,
    RNR_REGS_CFG_FIT_FAIL_CFG_STOP_ADDR_FIELD_WIDTH,
    RNR_REGS_CFG_FIT_FAIL_CFG_STOP_ADDR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_FIT_FAIL_CFG_RESERVED0
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_FIT_FAIL_CFG_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    RNR_REGS_CFG_FIT_FAIL_CFG_RESERVED0_FIELD_MASK,
    0,
    RNR_REGS_CFG_FIT_FAIL_CFG_RESERVED0_FIELD_WIDTH,
    RNR_REGS_CFG_FIT_FAIL_CFG_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_DATA_BKPT_CFG_BKPT_0_EN
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_DATA_BKPT_CFG_BKPT_0_EN_FIELD =
{
    "BKPT_0_EN",
#if RU_INCLUDE_DESC
    "BKPT_0_EN",
    "Enable breakpoint 0",
#endif
    RNR_REGS_CFG_DATA_BKPT_CFG_BKPT_0_EN_FIELD_MASK,
    0,
    RNR_REGS_CFG_DATA_BKPT_CFG_BKPT_0_EN_FIELD_WIDTH,
    RNR_REGS_CFG_DATA_BKPT_CFG_BKPT_0_EN_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_DATA_BKPT_CFG_BKPT_0_USE_THREAD
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_DATA_BKPT_CFG_BKPT_0_USE_THREAD_FIELD =
{
    "BKPT_0_USE_THREAD",
#if RU_INCLUDE_DESC
    "BKPT_0_USE_THREAD",
    "Enable breakpoint for given thread only",
#endif
    RNR_REGS_CFG_DATA_BKPT_CFG_BKPT_0_USE_THREAD_FIELD_MASK,
    0,
    RNR_REGS_CFG_DATA_BKPT_CFG_BKPT_0_USE_THREAD_FIELD_WIDTH,
    RNR_REGS_CFG_DATA_BKPT_CFG_BKPT_0_USE_THREAD_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_DATA_BKPT_CFG_BKPT_1_EN
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_DATA_BKPT_CFG_BKPT_1_EN_FIELD =
{
    "BKPT_1_EN",
#if RU_INCLUDE_DESC
    "BKPT_1_EN",
    "Enable breakpoint 1",
#endif
    RNR_REGS_CFG_DATA_BKPT_CFG_BKPT_1_EN_FIELD_MASK,
    0,
    RNR_REGS_CFG_DATA_BKPT_CFG_BKPT_1_EN_FIELD_WIDTH,
    RNR_REGS_CFG_DATA_BKPT_CFG_BKPT_1_EN_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_DATA_BKPT_CFG_BKPT_1_USE_THREAD
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_DATA_BKPT_CFG_BKPT_1_USE_THREAD_FIELD =
{
    "BKPT_1_USE_THREAD",
#if RU_INCLUDE_DESC
    "BKPT_1_USE_THREAD",
    "Enable breakpoint for given thread only",
#endif
    RNR_REGS_CFG_DATA_BKPT_CFG_BKPT_1_USE_THREAD_FIELD_MASK,
    0,
    RNR_REGS_CFG_DATA_BKPT_CFG_BKPT_1_USE_THREAD_FIELD_WIDTH,
    RNR_REGS_CFG_DATA_BKPT_CFG_BKPT_1_USE_THREAD_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_DATA_BKPT_CFG_BKPT_2_EN
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_DATA_BKPT_CFG_BKPT_2_EN_FIELD =
{
    "BKPT_2_EN",
#if RU_INCLUDE_DESC
    "BKPT_2_EN",
    "Enable breakpoint 2",
#endif
    RNR_REGS_CFG_DATA_BKPT_CFG_BKPT_2_EN_FIELD_MASK,
    0,
    RNR_REGS_CFG_DATA_BKPT_CFG_BKPT_2_EN_FIELD_WIDTH,
    RNR_REGS_CFG_DATA_BKPT_CFG_BKPT_2_EN_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_DATA_BKPT_CFG_BKPT_2_USE_THREAD
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_DATA_BKPT_CFG_BKPT_2_USE_THREAD_FIELD =
{
    "BKPT_2_USE_THREAD",
#if RU_INCLUDE_DESC
    "BKPT_2_USE_THREAD",
    "Enable breakpoint for given thread only",
#endif
    RNR_REGS_CFG_DATA_BKPT_CFG_BKPT_2_USE_THREAD_FIELD_MASK,
    0,
    RNR_REGS_CFG_DATA_BKPT_CFG_BKPT_2_USE_THREAD_FIELD_WIDTH,
    RNR_REGS_CFG_DATA_BKPT_CFG_BKPT_2_USE_THREAD_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_DATA_BKPT_CFG_BKPT_3_EN
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_DATA_BKPT_CFG_BKPT_3_EN_FIELD =
{
    "BKPT_3_EN",
#if RU_INCLUDE_DESC
    "BKPT_3_EN",
    "Enable breakpoint 3",
#endif
    RNR_REGS_CFG_DATA_BKPT_CFG_BKPT_3_EN_FIELD_MASK,
    0,
    RNR_REGS_CFG_DATA_BKPT_CFG_BKPT_3_EN_FIELD_WIDTH,
    RNR_REGS_CFG_DATA_BKPT_CFG_BKPT_3_EN_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_DATA_BKPT_CFG_BKPT_3_USE_THREAD
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_DATA_BKPT_CFG_BKPT_3_USE_THREAD_FIELD =
{
    "BKPT_3_USE_THREAD",
#if RU_INCLUDE_DESC
    "BKPT_3_USE_THREAD",
    "Enable breakpoint for given thread only",
#endif
    RNR_REGS_CFG_DATA_BKPT_CFG_BKPT_3_USE_THREAD_FIELD_MASK,
    0,
    RNR_REGS_CFG_DATA_BKPT_CFG_BKPT_3_USE_THREAD_FIELD_WIDTH,
    RNR_REGS_CFG_DATA_BKPT_CFG_BKPT_3_USE_THREAD_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_DATA_BKPT_CFG_RESERVED0
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_DATA_BKPT_CFG_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    RNR_REGS_CFG_DATA_BKPT_CFG_RESERVED0_FIELD_MASK,
    0,
    RNR_REGS_CFG_DATA_BKPT_CFG_RESERVED0_FIELD_WIDTH,
    RNR_REGS_CFG_DATA_BKPT_CFG_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_STALL_CNT1_TOTAL_STALL_CNT
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_STALL_CNT1_TOTAL_STALL_CNT_FIELD =
{
    "TOTAL_STALL_CNT",
#if RU_INCLUDE_DESC
    "TOTAL_STALL_CNT",
    "Count total stall cycles in profiling window",
#endif
    RNR_REGS_CFG_STALL_CNT1_TOTAL_STALL_CNT_FIELD_MASK,
    0,
    RNR_REGS_CFG_STALL_CNT1_TOTAL_STALL_CNT_FIELD_WIDTH,
    RNR_REGS_CFG_STALL_CNT1_TOTAL_STALL_CNT_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_STALL_CNT1_RESERVED0
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_STALL_CNT1_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    RNR_REGS_CFG_STALL_CNT1_RESERVED0_FIELD_MASK,
    0,
    RNR_REGS_CFG_STALL_CNT1_RESERVED0_FIELD_WIDTH,
    RNR_REGS_CFG_STALL_CNT1_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_STALL_CNT2_STALL_ON_ALU_B_FULL_CNT
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_STALL_CNT2_STALL_ON_ALU_B_FULL_CNT_FIELD =
{
    "STALL_ON_ALU_B_FULL_CNT",
#if RU_INCLUDE_DESC
    "STALL_ON_ALU_B_FULL_CNT",
    "Count stalls due to ALU B FIFO full",
#endif
    RNR_REGS_CFG_STALL_CNT2_STALL_ON_ALU_B_FULL_CNT_FIELD_MASK,
    0,
    RNR_REGS_CFG_STALL_CNT2_STALL_ON_ALU_B_FULL_CNT_FIELD_WIDTH,
    RNR_REGS_CFG_STALL_CNT2_STALL_ON_ALU_B_FULL_CNT_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_STALL_CNT2_STALL_ON_ALU_A_FULL_CNT
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_STALL_CNT2_STALL_ON_ALU_A_FULL_CNT_FIELD =
{
    "STALL_ON_ALU_A_FULL_CNT",
#if RU_INCLUDE_DESC
    "STALL_ON_ALU_A_FULL_CNT",
    "Count stalls due to ALU A FIFO full",
#endif
    RNR_REGS_CFG_STALL_CNT2_STALL_ON_ALU_A_FULL_CNT_FIELD_MASK,
    0,
    RNR_REGS_CFG_STALL_CNT2_STALL_ON_ALU_A_FULL_CNT_FIELD_WIDTH,
    RNR_REGS_CFG_STALL_CNT2_STALL_ON_ALU_A_FULL_CNT_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_STALL_CNT3_STALL_ON_JMPREG
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_STALL_CNT3_STALL_ON_JMPREG_FIELD =
{
    "STALL_ON_JMPREG",
#if RU_INCLUDE_DESC
    "STALL_ON_JMPREG",
    "Count stalls due to jump on address from register",
#endif
    RNR_REGS_CFG_STALL_CNT3_STALL_ON_JMPREG_FIELD_MASK,
    0,
    RNR_REGS_CFG_STALL_CNT3_STALL_ON_JMPREG_FIELD_WIDTH,
    RNR_REGS_CFG_STALL_CNT3_STALL_ON_JMPREG_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_STALL_CNT3_STALL_ON_MEMIO_FULL_CNT
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_STALL_CNT3_STALL_ON_MEMIO_FULL_CNT_FIELD =
{
    "STALL_ON_MEMIO_FULL_CNT",
#if RU_INCLUDE_DESC
    "STALL_ON_MEMIO_FULL_CNT",
    "Count stalls due to MEMIO FIFO full",
#endif
    RNR_REGS_CFG_STALL_CNT3_STALL_ON_MEMIO_FULL_CNT_FIELD_MASK,
    0,
    RNR_REGS_CFG_STALL_CNT3_STALL_ON_MEMIO_FULL_CNT_FIELD_WIDTH,
    RNR_REGS_CFG_STALL_CNT3_STALL_ON_MEMIO_FULL_CNT_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_STALL_CNT4_STALL_ON_WAW_CNT
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_STALL_CNT4_STALL_ON_WAW_CNT_FIELD =
{
    "STALL_ON_WAW_CNT",
#if RU_INCLUDE_DESC
    "STALL_ON_WAW_CNT",
    "Count stalls due to WAW on conditional",
#endif
    RNR_REGS_CFG_STALL_CNT4_STALL_ON_WAW_CNT_FIELD_MASK,
    0,
    RNR_REGS_CFG_STALL_CNT4_STALL_ON_WAW_CNT_FIELD_WIDTH,
    RNR_REGS_CFG_STALL_CNT4_STALL_ON_WAW_CNT_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_STALL_CNT4_STALL_ON_SUPER_CMD
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_STALL_CNT4_STALL_ON_SUPER_CMD_FIELD =
{
    "STALL_ON_SUPER_CMD",
#if RU_INCLUDE_DESC
    "STALL_ON_SUPER_CMD",
    "Count stalls due to super command",
#endif
    RNR_REGS_CFG_STALL_CNT4_STALL_ON_SUPER_CMD_FIELD_MASK,
    0,
    RNR_REGS_CFG_STALL_CNT4_STALL_ON_SUPER_CMD_FIELD_WIDTH,
    RNR_REGS_CFG_STALL_CNT4_STALL_ON_SUPER_CMD_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_STALL_CNT5_STALL_ON_SUPER_CMD_WHEN_FULL
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_STALL_CNT5_STALL_ON_SUPER_CMD_WHEN_FULL_FIELD =
{
    "STALL_ON_SUPER_CMD_WHEN_FULL",
#if RU_INCLUDE_DESC
    "STALL_ON_SUPER_CMD_WHEN_FULL",
    "Count stalls due to super command full stall",
#endif
    RNR_REGS_CFG_STALL_CNT5_STALL_ON_SUPER_CMD_WHEN_FULL_FIELD_MASK,
    0,
    RNR_REGS_CFG_STALL_CNT5_STALL_ON_SUPER_CMD_WHEN_FULL_FIELD_WIDTH,
    RNR_REGS_CFG_STALL_CNT5_STALL_ON_SUPER_CMD_WHEN_FULL_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_STALL_CNT5_STALL_ON_CS_CNT
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_STALL_CNT5_STALL_ON_CS_CNT_FIELD =
{
    "STALL_ON_CS_CNT",
#if RU_INCLUDE_DESC
    "STALL_ON_CS_CNT",
    "Count stall cycles due to CS event",
#endif
    RNR_REGS_CFG_STALL_CNT5_STALL_ON_CS_CNT_FIELD_MASK,
    0,
    RNR_REGS_CFG_STALL_CNT5_STALL_ON_CS_CNT_FIELD_WIDTH,
    RNR_REGS_CFG_STALL_CNT5_STALL_ON_CS_CNT_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_STALL_CNT6_ACTIVE_CYCLES_CNT
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_STALL_CNT6_ACTIVE_CYCLES_CNT_FIELD =
{
    "ACTIVE_CYCLES_CNT",
#if RU_INCLUDE_DESC
    "ACTIVE_CYCLES_CNT",
    "Count active cycles of a task",
#endif
    RNR_REGS_CFG_STALL_CNT6_ACTIVE_CYCLES_CNT_FIELD_MASK,
    0,
    RNR_REGS_CFG_STALL_CNT6_ACTIVE_CYCLES_CNT_FIELD_WIDTH,
    RNR_REGS_CFG_STALL_CNT6_ACTIVE_CYCLES_CNT_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_STALL_CNT7_STALL_ON_JMP_FULL_CNT
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_STALL_CNT7_STALL_ON_JMP_FULL_CNT_FIELD =
{
    "STALL_ON_JMP_FULL_CNT",
#if RU_INCLUDE_DESC
    "STALL_ON_JMP_FULL_CNT",
    "Count stalls due to branch FIFO full",
#endif
    RNR_REGS_CFG_STALL_CNT7_STALL_ON_JMP_FULL_CNT_FIELD_MASK,
    0,
    RNR_REGS_CFG_STALL_CNT7_STALL_ON_JMP_FULL_CNT_FIELD_WIDTH,
    RNR_REGS_CFG_STALL_CNT7_STALL_ON_JMP_FULL_CNT_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_STALL_CNT7_STALL_ON_SKIP_JMP_CNT
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_STALL_CNT7_STALL_ON_SKIP_JMP_CNT_FIELD =
{
    "STALL_ON_SKIP_JMP_CNT",
#if RU_INCLUDE_DESC
    "STALL_ON_SKIP_JMP_CNT",
    "Count stalls due wit conditional on skip jump",
#endif
    RNR_REGS_CFG_STALL_CNT7_STALL_ON_SKIP_JMP_CNT_FIELD_MASK,
    0,
    RNR_REGS_CFG_STALL_CNT7_STALL_ON_SKIP_JMP_CNT_FIELD_WIDTH,
    RNR_REGS_CFG_STALL_CNT7_STALL_ON_SKIP_JMP_CNT_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_PROFILING_STS_TRACE_WRITE_PNT
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_PROFILING_STS_TRACE_WRITE_PNT_FIELD =
{
    "TRACE_WRITE_PNT",
#if RU_INCLUDE_DESC
    "Trace_write_pointer",
    "Trace write pointer",
#endif
    RNR_REGS_CFG_PROFILING_STS_TRACE_WRITE_PNT_FIELD_MASK,
    0,
    RNR_REGS_CFG_PROFILING_STS_TRACE_WRITE_PNT_FIELD_WIDTH,
    RNR_REGS_CFG_PROFILING_STS_TRACE_WRITE_PNT_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_PROFILING_STS_IDLE_NO_ACTIVE_TASK
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_PROFILING_STS_IDLE_NO_ACTIVE_TASK_FIELD =
{
    "IDLE_NO_ACTIVE_TASK",
#if RU_INCLUDE_DESC
    "IDLE_no_active_task",
    "No active task",
#endif
    RNR_REGS_CFG_PROFILING_STS_IDLE_NO_ACTIVE_TASK_FIELD_MASK,
    0,
    RNR_REGS_CFG_PROFILING_STS_IDLE_NO_ACTIVE_TASK_FIELD_WIDTH,
    RNR_REGS_CFG_PROFILING_STS_IDLE_NO_ACTIVE_TASK_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_PROFILING_STS_CURR_THREAD_NUM
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_PROFILING_STS_CURR_THREAD_NUM_FIELD =
{
    "CURR_THREAD_NUM",
#if RU_INCLUDE_DESC
    "CURR_thread_num",
    "Current thread num",
#endif
    RNR_REGS_CFG_PROFILING_STS_CURR_THREAD_NUM_FIELD_MASK,
    0,
    RNR_REGS_CFG_PROFILING_STS_CURR_THREAD_NUM_FIELD_WIDTH,
    RNR_REGS_CFG_PROFILING_STS_CURR_THREAD_NUM_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_PROFILING_STS_PROFILING_ACTIVE
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_PROFILING_STS_PROFILING_ACTIVE_FIELD =
{
    "PROFILING_ACTIVE",
#if RU_INCLUDE_DESC
    "Profiling_active",
    "Status of profiling ON/OFF",
#endif
    RNR_REGS_CFG_PROFILING_STS_PROFILING_ACTIVE_FIELD_MASK,
    0,
    RNR_REGS_CFG_PROFILING_STS_PROFILING_ACTIVE_FIELD_WIDTH,
    RNR_REGS_CFG_PROFILING_STS_PROFILING_ACTIVE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_PROFILING_STS_TRACE_FIFO_OVERRUN
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_PROFILING_STS_TRACE_FIFO_OVERRUN_FIELD =
{
    "TRACE_FIFO_OVERRUN",
#if RU_INCLUDE_DESC
    "TRACE_FIFO_OVERRUN",
    "Sticky bit, indicating trace event FIFO overrun. Cleared by writing bit [31] of PROFILING_CFG_1 register",
#endif
    RNR_REGS_CFG_PROFILING_STS_TRACE_FIFO_OVERRUN_FIELD_MASK,
    0,
    RNR_REGS_CFG_PROFILING_STS_TRACE_FIFO_OVERRUN_FIELD_WIDTH,
    RNR_REGS_CFG_PROFILING_STS_TRACE_FIFO_OVERRUN_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_PROFILING_STS_SINGLE_MODE_PROFILING_STATUS
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_PROFILING_STS_SINGLE_MODE_PROFILING_STATUS_FIELD =
{
    "SINGLE_MODE_PROFILING_STATUS",
#if RU_INCLUDE_DESC
    "SINGLE_MODE_PROFILING_STATUS",
    "Shows the status of profiling window in single mode",
#endif
    RNR_REGS_CFG_PROFILING_STS_SINGLE_MODE_PROFILING_STATUS_FIELD_MASK,
    0,
    RNR_REGS_CFG_PROFILING_STS_SINGLE_MODE_PROFILING_STATUS_FIELD_WIDTH,
    RNR_REGS_CFG_PROFILING_STS_SINGLE_MODE_PROFILING_STATUS_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_PROFILING_STS_RESERVED0
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_PROFILING_STS_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    RNR_REGS_CFG_PROFILING_STS_RESERVED0_FIELD_MASK,
    0,
    RNR_REGS_CFG_PROFILING_STS_RESERVED0_FIELD_WIDTH,
    RNR_REGS_CFG_PROFILING_STS_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_PROFILING_CFG_0_TRACE_BASE_ADDR
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_PROFILING_CFG_0_TRACE_BASE_ADDR_FIELD =
{
    "TRACE_BASE_ADDR",
#if RU_INCLUDE_DESC
    "TRACE_BASE_ADDR",
    "Base address for trace buffer",
#endif
    RNR_REGS_CFG_PROFILING_CFG_0_TRACE_BASE_ADDR_FIELD_MASK,
    0,
    RNR_REGS_CFG_PROFILING_CFG_0_TRACE_BASE_ADDR_FIELD_WIDTH,
    RNR_REGS_CFG_PROFILING_CFG_0_TRACE_BASE_ADDR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_PROFILING_CFG_0_RESERVED0
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_PROFILING_CFG_0_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    RNR_REGS_CFG_PROFILING_CFG_0_RESERVED0_FIELD_MASK,
    0,
    RNR_REGS_CFG_PROFILING_CFG_0_RESERVED0_FIELD_WIDTH,
    RNR_REGS_CFG_PROFILING_CFG_0_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_PROFILING_CFG_0_TRACE_MAX_ADDR
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_PROFILING_CFG_0_TRACE_MAX_ADDR_FIELD =
{
    "TRACE_MAX_ADDR",
#if RU_INCLUDE_DESC
    "TRACE_MAX_ADDR",
    "Trace buffer MAX address",
#endif
    RNR_REGS_CFG_PROFILING_CFG_0_TRACE_MAX_ADDR_FIELD_MASK,
    0,
    RNR_REGS_CFG_PROFILING_CFG_0_TRACE_MAX_ADDR_FIELD_WIDTH,
    RNR_REGS_CFG_PROFILING_CFG_0_TRACE_MAX_ADDR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_PROFILING_CFG_0_RESERVED1
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_PROFILING_CFG_0_RESERVED1_FIELD =
{
    "RESERVED1",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    RNR_REGS_CFG_PROFILING_CFG_0_RESERVED1_FIELD_MASK,
    0,
    RNR_REGS_CFG_PROFILING_CFG_0_RESERVED1_FIELD_WIDTH,
    RNR_REGS_CFG_PROFILING_CFG_0_RESERVED1_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_PROFILING_CFG_1_TRACE_WRAPAROUND
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_PROFILING_CFG_1_TRACE_WRAPAROUND_FIELD =
{
    "TRACE_WRAPAROUND",
#if RU_INCLUDE_DESC
    "TRACE_WRAPAROUND",
    "Wraparound when writing trace buffer",
#endif
    RNR_REGS_CFG_PROFILING_CFG_1_TRACE_WRAPAROUND_FIELD_MASK,
    0,
    RNR_REGS_CFG_PROFILING_CFG_1_TRACE_WRAPAROUND_FIELD_WIDTH,
    RNR_REGS_CFG_PROFILING_CFG_1_TRACE_WRAPAROUND_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_PROFILING_CFG_1_TRACE_MODE
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_PROFILING_CFG_1_TRACE_MODE_FIELD =
{
    "TRACE_MODE",
#if RU_INCLUDE_DESC
    "TRACE_MODE",
    "Select all tasks or single task mode",
#endif
    RNR_REGS_CFG_PROFILING_CFG_1_TRACE_MODE_FIELD_MASK,
    0,
    RNR_REGS_CFG_PROFILING_CFG_1_TRACE_MODE_FIELD_WIDTH,
    RNR_REGS_CFG_PROFILING_CFG_1_TRACE_MODE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_PROFILING_CFG_1_TRACE_DISABLE_IDLE_IN
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_PROFILING_CFG_1_TRACE_DISABLE_IDLE_IN_FIELD =
{
    "TRACE_DISABLE_IDLE_IN",
#if RU_INCLUDE_DESC
    "TRACE_DISABLE_IDLE_IN",
    "Select whether to log IDLE in context swap events",
#endif
    RNR_REGS_CFG_PROFILING_CFG_1_TRACE_DISABLE_IDLE_IN_FIELD_MASK,
    0,
    RNR_REGS_CFG_PROFILING_CFG_1_TRACE_DISABLE_IDLE_IN_FIELD_WIDTH,
    RNR_REGS_CFG_PROFILING_CFG_1_TRACE_DISABLE_IDLE_IN_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_PROFILING_CFG_1_TRACE_DISABLE_WAKEUP_LOG
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_PROFILING_CFG_1_TRACE_DISABLE_WAKEUP_LOG_FIELD =
{
    "TRACE_DISABLE_WAKEUP_LOG",
#if RU_INCLUDE_DESC
    "TRACE_DISABLE_WAKEUP_LOG",
    "Enable/disable logging of scheduler events (wakeups). Relevant only for single task mode",
#endif
    RNR_REGS_CFG_PROFILING_CFG_1_TRACE_DISABLE_WAKEUP_LOG_FIELD_MASK,
    0,
    RNR_REGS_CFG_PROFILING_CFG_1_TRACE_DISABLE_WAKEUP_LOG_FIELD_WIDTH,
    RNR_REGS_CFG_PROFILING_CFG_1_TRACE_DISABLE_WAKEUP_LOG_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_PROFILING_CFG_1_TRACE_TASK
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_PROFILING_CFG_1_TRACE_TASK_FIELD =
{
    "TRACE_TASK",
#if RU_INCLUDE_DESC
    "TRACE_TASK",
    "Select task for single task operation (tracer)",
#endif
    RNR_REGS_CFG_PROFILING_CFG_1_TRACE_TASK_FIELD_MASK,
    0,
    RNR_REGS_CFG_PROFILING_CFG_1_TRACE_TASK_FIELD_WIDTH,
    RNR_REGS_CFG_PROFILING_CFG_1_TRACE_TASK_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_PROFILING_CFG_1_IDLE_COUNTER_SOURCE_SEL
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_PROFILING_CFG_1_IDLE_COUNTER_SOURCE_SEL_FIELD =
{
    "IDLE_COUNTER_SOURCE_SEL",
#if RU_INCLUDE_DESC
    "IDLE_COUNTER_SOURCE_SEL",
    "Select mode for IDLE counter",
#endif
    RNR_REGS_CFG_PROFILING_CFG_1_IDLE_COUNTER_SOURCE_SEL_FIELD_MASK,
    0,
    RNR_REGS_CFG_PROFILING_CFG_1_IDLE_COUNTER_SOURCE_SEL_FIELD_WIDTH,
    RNR_REGS_CFG_PROFILING_CFG_1_IDLE_COUNTER_SOURCE_SEL_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_PROFILING_CFG_1_COUNTERS_SELECTED_TASK_MODE
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_PROFILING_CFG_1_COUNTERS_SELECTED_TASK_MODE_FIELD =
{
    "COUNTERS_SELECTED_TASK_MODE",
#if RU_INCLUDE_DESC
    "COUNTERS_SELECTED_TASK_MODE",
    "Enable single selected task mode (counters)",
#endif
    RNR_REGS_CFG_PROFILING_CFG_1_COUNTERS_SELECTED_TASK_MODE_FIELD_MASK,
    0,
    RNR_REGS_CFG_PROFILING_CFG_1_COUNTERS_SELECTED_TASK_MODE_FIELD_WIDTH,
    RNR_REGS_CFG_PROFILING_CFG_1_COUNTERS_SELECTED_TASK_MODE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_PROFILING_CFG_1_COUNTERS_TASK
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_PROFILING_CFG_1_COUNTERS_TASK_FIELD =
{
    "COUNTERS_TASK",
#if RU_INCLUDE_DESC
    "COUNTERS_TASK",
    "Select task for single task operation (counters)",
#endif
    RNR_REGS_CFG_PROFILING_CFG_1_COUNTERS_TASK_FIELD_MASK,
    0,
    RNR_REGS_CFG_PROFILING_CFG_1_COUNTERS_TASK_FIELD_WIDTH,
    RNR_REGS_CFG_PROFILING_CFG_1_COUNTERS_TASK_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_PROFILING_CFG_1_PROFILING_WINDOW_MODE
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_PROFILING_CFG_1_PROFILING_WINDOW_MODE_FIELD =
{
    "PROFILING_WINDOW_MODE",
#if RU_INCLUDE_DESC
    "PROFILING_WINDOW_MODE",
    "Choose profiling window mode",
#endif
    RNR_REGS_CFG_PROFILING_CFG_1_PROFILING_WINDOW_MODE_FIELD_MASK,
    0,
    RNR_REGS_CFG_PROFILING_CFG_1_PROFILING_WINDOW_MODE_FIELD_WIDTH,
    RNR_REGS_CFG_PROFILING_CFG_1_PROFILING_WINDOW_MODE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_PROFILING_CFG_1_SINGLE_MODE_START_OPTION
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_PROFILING_CFG_1_SINGLE_MODE_START_OPTION_FIELD =
{
    "SINGLE_MODE_START_OPTION",
#if RU_INCLUDE_DESC
    "SINGLE_MODE_START_OPTION",
    "Choose start window option in case of single runner profiling window mode",
#endif
    RNR_REGS_CFG_PROFILING_CFG_1_SINGLE_MODE_START_OPTION_FIELD_MASK,
    0,
    RNR_REGS_CFG_PROFILING_CFG_1_SINGLE_MODE_START_OPTION_FIELD_WIDTH,
    RNR_REGS_CFG_PROFILING_CFG_1_SINGLE_MODE_START_OPTION_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_PROFILING_CFG_1_SINGLE_MODE_STOP_OPTION
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_PROFILING_CFG_1_SINGLE_MODE_STOP_OPTION_FIELD =
{
    "SINGLE_MODE_STOP_OPTION",
#if RU_INCLUDE_DESC
    "SINGLE_MODE_STOP_OPTION",
    "Choose stop window option in case of single runner profiling window mode",
#endif
    RNR_REGS_CFG_PROFILING_CFG_1_SINGLE_MODE_STOP_OPTION_FIELD_MASK,
    0,
    RNR_REGS_CFG_PROFILING_CFG_1_SINGLE_MODE_STOP_OPTION_FIELD_WIDTH,
    RNR_REGS_CFG_PROFILING_CFG_1_SINGLE_MODE_STOP_OPTION_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_PROFILING_CFG_1_WINDOW_MANUAL_START
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_PROFILING_CFG_1_WINDOW_MANUAL_START_FIELD =
{
    "WINDOW_MANUAL_START",
#if RU_INCLUDE_DESC
    "WINDOW_MANUAL_START",
    "write 1 to start profiling window manually (if appropriate option is configured in SINGLE_MODE_START_OPTION)",
#endif
    RNR_REGS_CFG_PROFILING_CFG_1_WINDOW_MANUAL_START_FIELD_MASK,
    0,
    RNR_REGS_CFG_PROFILING_CFG_1_WINDOW_MANUAL_START_FIELD_WIDTH,
    RNR_REGS_CFG_PROFILING_CFG_1_WINDOW_MANUAL_START_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_PROFILING_CFG_1_WINDOW_MANUAL_STOP
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_PROFILING_CFG_1_WINDOW_MANUAL_STOP_FIELD =
{
    "WINDOW_MANUAL_STOP",
#if RU_INCLUDE_DESC
    "WINDOW_MANUAL_STOP",
    "write 1 to stop profiling window manually (if appropriate option is configured in SINGLE_MODE_START_OPTION)",
#endif
    RNR_REGS_CFG_PROFILING_CFG_1_WINDOW_MANUAL_STOP_FIELD_MASK,
    0,
    RNR_REGS_CFG_PROFILING_CFG_1_WINDOW_MANUAL_STOP_FIELD_WIDTH,
    RNR_REGS_CFG_PROFILING_CFG_1_WINDOW_MANUAL_STOP_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_PROFILING_CFG_1_TRACER_ENABLE
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_PROFILING_CFG_1_TRACER_ENABLE_FIELD =
{
    "TRACER_ENABLE",
#if RU_INCLUDE_DESC
    "TRACER_ENABLE",
    "Enable tracer logic (writing trace to memory)",
#endif
    RNR_REGS_CFG_PROFILING_CFG_1_TRACER_ENABLE_FIELD_MASK,
    0,
    RNR_REGS_CFG_PROFILING_CFG_1_TRACER_ENABLE_FIELD_WIDTH,
    RNR_REGS_CFG_PROFILING_CFG_1_TRACER_ENABLE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_PROFILING_CFG_1_RESERVED0
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_PROFILING_CFG_1_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    RNR_REGS_CFG_PROFILING_CFG_1_RESERVED0_FIELD_MASK,
    0,
    RNR_REGS_CFG_PROFILING_CFG_1_RESERVED0_FIELD_WIDTH,
    RNR_REGS_CFG_PROFILING_CFG_1_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_PROFILING_CFG_1_PROFILING_WINDOW_RESET
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_PROFILING_CFG_1_PROFILING_WINDOW_RESET_FIELD =
{
    "PROFILING_WINDOW_RESET",
#if RU_INCLUDE_DESC
    "PROFILING_WINDOW_RESET",
    "write 1 to reset profiling window",
#endif
    RNR_REGS_CFG_PROFILING_CFG_1_PROFILING_WINDOW_RESET_FIELD_MASK,
    0,
    RNR_REGS_CFG_PROFILING_CFG_1_PROFILING_WINDOW_RESET_FIELD_WIDTH,
    RNR_REGS_CFG_PROFILING_CFG_1_PROFILING_WINDOW_RESET_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_PROFILING_CFG_1_PROFILING_WINDOW_ENABLE
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_PROFILING_CFG_1_PROFILING_WINDOW_ENABLE_FIELD =
{
    "PROFILING_WINDOW_ENABLE",
#if RU_INCLUDE_DESC
    "PROFILING_WINDOW_ENABLE",
    "Enable single profiling window. If enabled, will start looking for start condition as specified by START_OPTION field",
#endif
    RNR_REGS_CFG_PROFILING_CFG_1_PROFILING_WINDOW_ENABLE_FIELD_MASK,
    0,
    RNR_REGS_CFG_PROFILING_CFG_1_PROFILING_WINDOW_ENABLE_FIELD_WIDTH,
    RNR_REGS_CFG_PROFILING_CFG_1_PROFILING_WINDOW_ENABLE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_PROFILING_CFG_1_RESERVED1
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_PROFILING_CFG_1_RESERVED1_FIELD =
{
    "RESERVED1",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    RNR_REGS_CFG_PROFILING_CFG_1_RESERVED1_FIELD_MASK,
    0,
    RNR_REGS_CFG_PROFILING_CFG_1_RESERVED1_FIELD_WIDTH,
    RNR_REGS_CFG_PROFILING_CFG_1_RESERVED1_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_PROFILING_CFG_1_TRACE_RESET_EVENT_FIFO
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_PROFILING_CFG_1_TRACE_RESET_EVENT_FIFO_FIELD =
{
    "TRACE_RESET_EVENT_FIFO",
#if RU_INCLUDE_DESC
    "TRACE_RESET_EVENT_FIFO",
    "Apply software reset to event FIFO",
#endif
    RNR_REGS_CFG_PROFILING_CFG_1_TRACE_RESET_EVENT_FIFO_FIELD_MASK,
    0,
    RNR_REGS_CFG_PROFILING_CFG_1_TRACE_RESET_EVENT_FIFO_FIELD_WIDTH,
    RNR_REGS_CFG_PROFILING_CFG_1_TRACE_RESET_EVENT_FIFO_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_PROFILING_CFG_1_TRACE_CLEAR_FIFO_OVERRUN
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_PROFILING_CFG_1_TRACE_CLEAR_FIFO_OVERRUN_FIELD =
{
    "TRACE_CLEAR_FIFO_OVERRUN",
#if RU_INCLUDE_DESC
    "TRACE_CLEAR_FIFO_OVERRUN",
    "Write 1 to clear event FIFO overrun sticky bit",
#endif
    RNR_REGS_CFG_PROFILING_CFG_1_TRACE_CLEAR_FIFO_OVERRUN_FIELD_MASK,
    0,
    RNR_REGS_CFG_PROFILING_CFG_1_TRACE_CLEAR_FIFO_OVERRUN_FIELD_WIDTH,
    RNR_REGS_CFG_PROFILING_CFG_1_TRACE_CLEAR_FIFO_OVERRUN_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_PROFILING_COUNTER_VAL
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_PROFILING_COUNTER_VAL_FIELD =
{
    "VAL",
#if RU_INCLUDE_DESC
    "value",
    "Current 32-bit value of counter",
#endif
    RNR_REGS_CFG_PROFILING_COUNTER_VAL_FIELD_MASK,
    0,
    RNR_REGS_CFG_PROFILING_COUNTER_VAL_FIELD_WIDTH,
    RNR_REGS_CFG_PROFILING_COUNTER_VAL_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_PROFILING_CFG_2_TRIGGER_ON_SECOND
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_PROFILING_CFG_2_TRIGGER_ON_SECOND_FIELD =
{
    "TRIGGER_ON_SECOND",
#if RU_INCLUDE_DESC
    "TRIGGER_ON_SECOND",
    "Dont start profiling window when encountering start PC for first time",
#endif
    RNR_REGS_CFG_PROFILING_CFG_2_TRIGGER_ON_SECOND_FIELD_MASK,
    0,
    RNR_REGS_CFG_PROFILING_CFG_2_TRIGGER_ON_SECOND_FIELD_WIDTH,
    RNR_REGS_CFG_PROFILING_CFG_2_TRIGGER_ON_SECOND_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_PROFILING_CFG_2_PC_START
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_PROFILING_CFG_2_PC_START_FIELD =
{
    "PC_START",
#if RU_INCLUDE_DESC
    "PC_START",
    "Configure PC value to start profiling",
#endif
    RNR_REGS_CFG_PROFILING_CFG_2_PC_START_FIELD_MASK,
    0,
    RNR_REGS_CFG_PROFILING_CFG_2_PC_START_FIELD_WIDTH,
    RNR_REGS_CFG_PROFILING_CFG_2_PC_START_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_PROFILING_CFG_2_PC_STOP_OR_CYCLE_COUNT
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_PROFILING_CFG_2_PC_STOP_OR_CYCLE_COUNT_FIELD =
{
    "PC_STOP_OR_CYCLE_COUNT",
#if RU_INCLUDE_DESC
    "PC_STOP_OR_CYCLE_COUNT",
    "Configure PC value to stop profiling, or number of cycles to count - as selected by STOP_OPTION field in PROGFILING_CFG_1 register",
#endif
    RNR_REGS_CFG_PROFILING_CFG_2_PC_STOP_OR_CYCLE_COUNT_FIELD_MASK,
    0,
    RNR_REGS_CFG_PROFILING_CFG_2_PC_STOP_OR_CYCLE_COUNT_FIELD_WIDTH,
    RNR_REGS_CFG_PROFILING_CFG_2_PC_STOP_OR_CYCLE_COUNT_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_EXEC_CMDS_CNT_EXEC_COUNTER
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_EXEC_CMDS_CNT_EXEC_COUNTER_FIELD =
{
    "EXEC_COUNTER",
#if RU_INCLUDE_DESC
    "EXEC_COUNTER",
    "Count executed commands",
#endif
    RNR_REGS_CFG_EXEC_CMDS_CNT_EXEC_COUNTER_FIELD_MASK,
    0,
    RNR_REGS_CFG_EXEC_CMDS_CNT_EXEC_COUNTER_FIELD_WIDTH,
    RNR_REGS_CFG_EXEC_CMDS_CNT_EXEC_COUNTER_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_IDLE_CNT1_IDLE_CNT
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_IDLE_CNT1_IDLE_CNT_FIELD =
{
    "IDLE_CNT",
#if RU_INCLUDE_DESC
    "IDLE",
    "IDLE countReserved",
#endif
    RNR_REGS_CFG_IDLE_CNT1_IDLE_CNT_FIELD_MASK,
    0,
    RNR_REGS_CFG_IDLE_CNT1_IDLE_CNT_FIELD_WIDTH,
    RNR_REGS_CFG_IDLE_CNT1_IDLE_CNT_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_JMP_CNT_UNTAKEN_JMP_CNT
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_JMP_CNT_UNTAKEN_JMP_CNT_FIELD =
{
    "UNTAKEN_JMP_CNT",
#if RU_INCLUDE_DESC
    "UNTAKEN_JMP_CNT",
    "Counts jumps with prediction miss, when prediction was dont jump",
#endif
    RNR_REGS_CFG_JMP_CNT_UNTAKEN_JMP_CNT_FIELD_MASK,
    0,
    RNR_REGS_CFG_JMP_CNT_UNTAKEN_JMP_CNT_FIELD_WIDTH,
    RNR_REGS_CFG_JMP_CNT_UNTAKEN_JMP_CNT_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_JMP_CNT_TAKEN_JMP_CNT
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_JMP_CNT_TAKEN_JMP_CNT_FIELD =
{
    "TAKEN_JMP_CNT",
#if RU_INCLUDE_DESC
    "TAKEN_JMP_CNT",
    "Counts jumps with prediction miss, when prediction was jump",
#endif
    RNR_REGS_CFG_JMP_CNT_TAKEN_JMP_CNT_FIELD_MASK,
    0,
    RNR_REGS_CFG_JMP_CNT_TAKEN_JMP_CNT_FIELD_WIDTH,
    RNR_REGS_CFG_JMP_CNT_TAKEN_JMP_CNT_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: RNR_REGS_CFG_METAL_FIX_REG_METAL_FIX
 ******************************************************************************/
const ru_field_rec RNR_REGS_CFG_METAL_FIX_REG_METAL_FIX_FIELD =
{
    "METAL_FIX",
#if RU_INCLUDE_DESC
    "Metal_fix",
    "32 bit register for metal fix."
    "In 4912 B0, Runner 6 is connected to i_tm_CAM_no_tst_lgc input of HASH and TCAM, as follows:"
    "HASH: {ECO_metal_fix_reg[15:12],8b0,  ECO_metal_fix_reg[11:8]}"
    "TCAM: {ECO_metal_fix_reg[7:4],8b0,  ECO_metal_fix_reg[3:0]}"
    ""
    "It is also connected to i_lvm_ll_no_tst_lgc as follows:"
    "TCAM: i_scan_testmode ? i_lvm_ll_no_tst_lgc : ECO_metal_fix_reg[16];"
    "HASH = i_scan_testmode ? i_lvm_ll_no_tst_lgc : ECO_metal_fix_reg[17];"
    "",
#endif
    RNR_REGS_CFG_METAL_FIX_REG_METAL_FIX_FIELD_MASK,
    0,
    RNR_REGS_CFG_METAL_FIX_REG_METAL_FIX_FIELD_WIDTH,
    RNR_REGS_CFG_METAL_FIX_REG_METAL_FIX_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

#endif /* RU_INCLUDE_FIELD_DB */

/******************************************************************************
 * Register: RNR_REGS_CFG_GLOBAL_CTRL
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_REGS_CFG_GLOBAL_CTRL_FIELDS[] =
{
    &RNR_REGS_CFG_GLOBAL_CTRL_EN_FIELD,
    &RNR_REGS_CFG_GLOBAL_CTRL_DMA_ILLEGAL_STATUS_FIELD,
    &RNR_REGS_CFG_GLOBAL_CTRL_PREDICTION_OVERRUN_STATUS_FIELD,
    &RNR_REGS_CFG_GLOBAL_CTRL_GDMA_CHKSUM_DEST_ILLEGAL_FIELD,
    &RNR_REGS_CFG_GLOBAL_CTRL_GDMA_CHKSUM_LEN_ILLEGAL_FIELD,
    &RNR_REGS_CFG_GLOBAL_CTRL_GDMA_TOTAL_DESCS_ILLEGAL_FIELD,
    &RNR_REGS_CFG_GLOBAL_CTRL_GDMA_INCOMPLETE_ILLEGAL_FIELD,
    &RNR_REGS_CFG_GLOBAL_CTRL_GDMA_CHKSUM_OVERLAP_ILLEGAL_FIELD,
    &RNR_REGS_CFG_GLOBAL_CTRL_MICRO_SEC_VAL_FIELD,
    &RNR_REGS_CFG_GLOBAL_CTRL_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_REGS_CFG_GLOBAL_CTRL_REG = 
{
    "CFG_GLOBAL_CTRL",
#if RU_INCLUDE_DESC
    "GLOBAL_CONTROL Register",
    "Global control",
#endif
    RNR_REGS_CFG_GLOBAL_CTRL_REG_OFFSET,
    0,
    0,
    250,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    10,
    RNR_REGS_CFG_GLOBAL_CTRL_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_REGS_CFG_CPU_WAKEUP
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_REGS_CFG_CPU_WAKEUP_FIELDS[] =
{
    &RNR_REGS_CFG_CPU_WAKEUP_THREAD_NUM_FIELD,
    &RNR_REGS_CFG_CPU_WAKEUP_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_REGS_CFG_CPU_WAKEUP_REG = 
{
    "CFG_CPU_WAKEUP",
#if RU_INCLUDE_DESC
    "CPU_WAKEUP Register",
    "Writing to this register generates a request towards the runner scheduler.",
#endif
    RNR_REGS_CFG_CPU_WAKEUP_REG_OFFSET,
    0,
    0,
    251,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    2,
    RNR_REGS_CFG_CPU_WAKEUP_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_REGS_CFG_INT_CTRL
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_REGS_CFG_INT_CTRL_FIELDS[] =
{
    &RNR_REGS_CFG_INT_CTRL_INT0_STS_FIELD,
    &RNR_REGS_CFG_INT_CTRL_INT1_STS_FIELD,
    &RNR_REGS_CFG_INT_CTRL_INT2_STS_FIELD,
    &RNR_REGS_CFG_INT_CTRL_INT3_STS_FIELD,
    &RNR_REGS_CFG_INT_CTRL_INT4_STS_FIELD,
    &RNR_REGS_CFG_INT_CTRL_INT5_STS_FIELD,
    &RNR_REGS_CFG_INT_CTRL_INT6_STS_FIELD,
    &RNR_REGS_CFG_INT_CTRL_INT7_STS_FIELD,
    &RNR_REGS_CFG_INT_CTRL_INT8_STS_FIELD,
    &RNR_REGS_CFG_INT_CTRL_INT9_STS_FIELD,
    &RNR_REGS_CFG_INT_CTRL_RESERVED0_FIELD,
    &RNR_REGS_CFG_INT_CTRL_FIT_FAIL_STS_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_REGS_CFG_INT_CTRL_REG = 
{
    "CFG_INT_CTRL",
#if RU_INCLUDE_DESC
    "INTERRUPT_CONTROL Register",
    "Interrupt control - UNUSED in 6858",
#endif
    RNR_REGS_CFG_INT_CTRL_REG_OFFSET,
    0,
    0,
    252,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    12,
    RNR_REGS_CFG_INT_CTRL_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_REGS_CFG_INT_MASK
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_REGS_CFG_INT_MASK_FIELDS[] =
{
    &RNR_REGS_CFG_INT_MASK_INT0_MASK_FIELD,
    &RNR_REGS_CFG_INT_MASK_INT1_MASK_FIELD,
    &RNR_REGS_CFG_INT_MASK_INT2_MASK_FIELD,
    &RNR_REGS_CFG_INT_MASK_INT3_MASK_FIELD,
    &RNR_REGS_CFG_INT_MASK_INT4_MASK_FIELD,
    &RNR_REGS_CFG_INT_MASK_INT5_MASK_FIELD,
    &RNR_REGS_CFG_INT_MASK_INT6_MASK_FIELD,
    &RNR_REGS_CFG_INT_MASK_INT7_MASK_FIELD,
    &RNR_REGS_CFG_INT_MASK_INT8_MASK_FIELD,
    &RNR_REGS_CFG_INT_MASK_INT9_MASK_FIELD,
    &RNR_REGS_CFG_INT_MASK_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_REGS_CFG_INT_MASK_REG = 
{
    "CFG_INT_MASK",
#if RU_INCLUDE_DESC
    "INTERRUPT_MASK Register",
    "Interrupt mask -  UNUSED in 6858",
#endif
    RNR_REGS_CFG_INT_MASK_REG_OFFSET,
    0,
    0,
    253,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    11,
    RNR_REGS_CFG_INT_MASK_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_REGS_CFG_GEN_CFG
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_REGS_CFG_GEN_CFG_FIELDS[] =
{
    &RNR_REGS_CFG_GEN_CFG_DISABLE_DMA_OLD_FLOW_CONTROL_FIELD,
    &RNR_REGS_CFG_GEN_CFG_TEST_FIT_FAIL_FIELD,
    &RNR_REGS_CFG_GEN_CFG_ZERO_DATA_MEM_FIELD,
    &RNR_REGS_CFG_GEN_CFG_ZERO_CONTEXT_MEM_FIELD,
    &RNR_REGS_CFG_GEN_CFG_ZERO_DATA_MEM_DONE_FIELD,
    &RNR_REGS_CFG_GEN_CFG_ZERO_CONTEXT_MEM_DONE_FIELD,
    &RNR_REGS_CFG_GEN_CFG_CHICKEN_DISABLE_SKIP_JMP_FIELD,
    &RNR_REGS_CFG_GEN_CFG_CHICKEN_DISABLE_ALU_LOAD_BALANCING_FIELD,
    &RNR_REGS_CFG_GEN_CFG_GDMA_DESC_OFFSET_FIELD,
    &RNR_REGS_CFG_GEN_CFG_BBTX_TCAM_DEST_SEL_FIELD,
    &RNR_REGS_CFG_GEN_CFG_BBTX_HASH_DEST_SEL_FIELD,
    &RNR_REGS_CFG_GEN_CFG_BBTX_NATC_DEST_SEL_FIELD,
    &RNR_REGS_CFG_GEN_CFG_BBTX_CNPL_DEST_SEL_FIELD,
    &RNR_REGS_CFG_GEN_CFG_GDMA_GDESC_BUFFER_SIZE_FIELD,
    &RNR_REGS_CFG_GEN_CFG_CHICKEN_ENABLE_OLD_UNIQUE_ID_MODE_FIELD,
    &RNR_REGS_CFG_GEN_CFG_CHICKEN_ENABLE_DMA_OLD_MODE_FIELD,
    &RNR_REGS_CFG_GEN_CFG_CHICKEN_DISABLE_BRANCH_SIZE_SIX_FIELD,
    &RNR_REGS_CFG_GEN_CFG_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_REGS_CFG_GEN_CFG_REG = 
{
    "CFG_GEN_CFG",
#if RU_INCLUDE_DESC
    "GENERAL_CONFIGURATION Register",
    "General configuration",
#endif
    RNR_REGS_CFG_GEN_CFG_REG_OFFSET,
    0,
    0,
    254,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    18,
    RNR_REGS_CFG_GEN_CFG_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_REGS_CFG_CAM_CFG
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_REGS_CFG_CAM_CFG_FIELDS[] =
{
    &RNR_REGS_CFG_CAM_CFG_STOP_VALUE_FIELD,
    &RNR_REGS_CFG_CAM_CFG_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_REGS_CFG_CAM_CFG_REG = 
{
    "CFG_CAM_CFG",
#if RU_INCLUDE_DESC
    "CAM_CONFIGURATION Register",
    "CAM configuration",
#endif
    RNR_REGS_CFG_CAM_CFG_REG_OFFSET,
    0,
    0,
    255,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    2,
    RNR_REGS_CFG_CAM_CFG_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_REGS_CFG_DDR_CFG
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_REGS_CFG_DDR_CFG_FIELDS[] =
{
    &RNR_REGS_CFG_DDR_CFG_DMA_BASE_FIELD,
    &RNR_REGS_CFG_DDR_CFG_DMA_BUF_SIZE_FIELD,
    &RNR_REGS_CFG_DDR_CFG_DMA_BUF_SIZE_MODE_FIELD,
    &RNR_REGS_CFG_DDR_CFG_DMA_STATIC_OFFSET_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_REGS_CFG_DDR_CFG_REG = 
{
    "CFG_DDR_CFG",
#if RU_INCLUDE_DESC
    "DMA_DDR_CONFIG Register",
    "DMA DDR config Register. Contains configurations such as buffer size and ddr base address that are used for DDR address calculations (from buffer number) when DMA instruction addr_calc flag is set.",
#endif
    RNR_REGS_CFG_DDR_CFG_REG_OFFSET,
    0,
    0,
    256,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    4,
    RNR_REGS_CFG_DDR_CFG_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_REGS_CFG_PSRAM_CFG
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_REGS_CFG_PSRAM_CFG_FIELDS[] =
{
    &RNR_REGS_CFG_PSRAM_CFG_DMA_BASE_FIELD,
    &RNR_REGS_CFG_PSRAM_CFG_DMA_BUF_SIZE_FIELD,
    &RNR_REGS_CFG_PSRAM_CFG_DMA_BUF_SIZE_MODE_FIELD,
    &RNR_REGS_CFG_PSRAM_CFG_DMA_STATIC_OFFSET_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_REGS_CFG_PSRAM_CFG_REG = 
{
    "CFG_PSRAM_CFG",
#if RU_INCLUDE_DESC
    "DMA_PSRAM_CONFIG Register",
    "DMA PSRAM config Register. Contains configurations such as buffer size and ddr base address that are used for DDR address calculations (from buffer number) when DMA instruction addr_calc flag is set.",
#endif
    RNR_REGS_CFG_PSRAM_CFG_REG_OFFSET,
    0,
    0,
    257,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    4,
    RNR_REGS_CFG_PSRAM_CFG_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_REGS_CFG_RAMRD_RANGE_MASK_CFG
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_REGS_CFG_RAMRD_RANGE_MASK_CFG_FIELDS[] =
{
    &RNR_REGS_CFG_RAMRD_RANGE_MASK_CFG_MASK0_FIELD,
    &RNR_REGS_CFG_RAMRD_RANGE_MASK_CFG_MASK1_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_REGS_CFG_RAMRD_RANGE_MASK_CFG_REG = 
{
    "CFG_RAMRD_RANGE_MASK_CFG",
#if RU_INCLUDE_DESC
    "RAMRD_MASK_CONFIG Register",
    "Ramrd mask for range search. The register holds 2 mask that can be chosen by runner core for range seraches.",
#endif
    RNR_REGS_CFG_RAMRD_RANGE_MASK_CFG_REG_OFFSET,
    0,
    0,
    258,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    2,
    RNR_REGS_CFG_RAMRD_RANGE_MASK_CFG_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_REGS_CFG_SCH_CFG
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_REGS_CFG_SCH_CFG_FIELDS[] =
{
    &RNR_REGS_CFG_SCH_CFG_SCHEDULER_MODE_FIELD,
    &RNR_REGS_CFG_SCH_CFG_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_REGS_CFG_SCH_CFG_REG = 
{
    "CFG_SCH_CFG",
#if RU_INCLUDE_DESC
    "SCHEDULER_CONFIG Register",
    "scheduler configuration",
#endif
    RNR_REGS_CFG_SCH_CFG_REG_OFFSET,
    0,
    0,
    259,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    2,
    RNR_REGS_CFG_SCH_CFG_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_REGS_CFG_BKPT_CFG
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_REGS_CFG_BKPT_CFG_FIELDS[] =
{
    &RNR_REGS_CFG_BKPT_CFG_BKPT_0_EN_FIELD,
    &RNR_REGS_CFG_BKPT_CFG_BKPT_0_USE_THREAD_FIELD,
    &RNR_REGS_CFG_BKPT_CFG_BKPT_1_EN_FIELD,
    &RNR_REGS_CFG_BKPT_CFG_BKPT_1_USE_THREAD_FIELD,
    &RNR_REGS_CFG_BKPT_CFG_BKPT_2_EN_FIELD,
    &RNR_REGS_CFG_BKPT_CFG_BKPT_2_USE_THREAD_FIELD,
    &RNR_REGS_CFG_BKPT_CFG_BKPT_3_EN_FIELD,
    &RNR_REGS_CFG_BKPT_CFG_BKPT_3_USE_THREAD_FIELD,
    &RNR_REGS_CFG_BKPT_CFG_BKPT_4_EN_FIELD,
    &RNR_REGS_CFG_BKPT_CFG_BKPT_4_USE_THREAD_FIELD,
    &RNR_REGS_CFG_BKPT_CFG_BKPT_5_EN_FIELD,
    &RNR_REGS_CFG_BKPT_CFG_BKPT_5_USE_THREAD_FIELD,
    &RNR_REGS_CFG_BKPT_CFG_BKPT_6_EN_FIELD,
    &RNR_REGS_CFG_BKPT_CFG_BKPT_6_USE_THREAD_FIELD,
    &RNR_REGS_CFG_BKPT_CFG_BKPT_7_EN_FIELD,
    &RNR_REGS_CFG_BKPT_CFG_BKPT_7_USE_THREAD_FIELD,
    &RNR_REGS_CFG_BKPT_CFG_STEP_MODE_FIELD,
    &RNR_REGS_CFG_BKPT_CFG_RESERVED0_FIELD,
    &RNR_REGS_CFG_BKPT_CFG_NEW_FLAGS_VAL_FIELD,
    &RNR_REGS_CFG_BKPT_CFG_ENABLE_BREAKPOINT_ON_FIT_FAIL_FIELD,
    &RNR_REGS_CFG_BKPT_CFG_RESERVED1_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_REGS_CFG_BKPT_CFG_REG = 
{
    "CFG_BKPT_CFG",
#if RU_INCLUDE_DESC
    "BKPT_CFG Register",
    "breakpoint configuration",
#endif
    RNR_REGS_CFG_BKPT_CFG_REG_OFFSET,
    0,
    0,
    260,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    21,
    RNR_REGS_CFG_BKPT_CFG_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_REGS_CFG_BKPT_IMM
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_REGS_CFG_BKPT_IMM_FIELDS[] =
{
    &RNR_REGS_CFG_BKPT_IMM_ENABLE_FIELD,
    &RNR_REGS_CFG_BKPT_IMM_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_REGS_CFG_BKPT_IMM_REG = 
{
    "CFG_BKPT_IMM",
#if RU_INCLUDE_DESC
    "BKPT_IMMEDIATE Register",
    "break point immediate",
#endif
    RNR_REGS_CFG_BKPT_IMM_REG_OFFSET,
    0,
    0,
    261,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    2,
    RNR_REGS_CFG_BKPT_IMM_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_REGS_CFG_BKPT_STS
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_REGS_CFG_BKPT_STS_FIELDS[] =
{
    &RNR_REGS_CFG_BKPT_STS_BKPT_ADDR_FIELD,
    &RNR_REGS_CFG_BKPT_STS_ACTIVE_FIELD,
    &RNR_REGS_CFG_BKPT_STS_DATA_BKPT_ADDR_FIELD,
    &RNR_REGS_CFG_BKPT_STS_REASON_PC_ADDR_FIELD,
    &RNR_REGS_CFG_BKPT_STS_REASON_STEP_MODE_FIELD,
    &RNR_REGS_CFG_BKPT_STS_REASON_DATA_ADDR_FIELD,
    &RNR_REGS_CFG_BKPT_STS_REASON_FIT_FAIL_FIELD,
    &RNR_REGS_CFG_BKPT_STS_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_REGS_CFG_BKPT_STS_REG = 
{
    "CFG_BKPT_STS",
#if RU_INCLUDE_DESC
    "BKPT_STS Register",
    "breakpoint status",
#endif
    RNR_REGS_CFG_BKPT_STS_REG_OFFSET,
    0,
    0,
    262,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    8,
    RNR_REGS_CFG_BKPT_STS_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_REGS_CFG_PC_STS
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_REGS_CFG_PC_STS_FIELDS[] =
{
    &RNR_REGS_CFG_PC_STS_CURRENT_PC_ADDR_FIELD,
    &RNR_REGS_CFG_PC_STS_RESERVED0_FIELD,
    &RNR_REGS_CFG_PC_STS_PC_RET_FIELD,
    &RNR_REGS_CFG_PC_STS_RESERVED1_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_REGS_CFG_PC_STS_REG = 
{
    "CFG_PC_STS",
#if RU_INCLUDE_DESC
    "PC_STS Register",
    "Program counterstatus",
#endif
    RNR_REGS_CFG_PC_STS_REG_OFFSET,
    0,
    0,
    263,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    4,
    RNR_REGS_CFG_PC_STS_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_REGS_CFG_EXT_ACC_CFG
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_REGS_CFG_EXT_ACC_CFG_FIELDS[] =
{
    &RNR_REGS_CFG_EXT_ACC_CFG_ADDR_BASE_FIELD,
    &RNR_REGS_CFG_EXT_ACC_CFG_RESERVED0_FIELD,
    &RNR_REGS_CFG_EXT_ACC_CFG_ADDR_STEP_0_FIELD,
    &RNR_REGS_CFG_EXT_ACC_CFG_ADDR_STEP_1_FIELD,
    &RNR_REGS_CFG_EXT_ACC_CFG_START_THREAD_FIELD,
    &RNR_REGS_CFG_EXT_ACC_CFG_RESERVED1_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_REGS_CFG_EXT_ACC_CFG_REG = 
{
    "CFG_EXT_ACC_CFG",
#if RU_INCLUDE_DESC
    "EXTERNAL_ACC_CONFIG Register",
    "Configure parameters for address calculation in external accelerator command",
#endif
    RNR_REGS_CFG_EXT_ACC_CFG_REG_OFFSET,
    0,
    0,
    264,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    6,
    RNR_REGS_CFG_EXT_ACC_CFG_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_REGS_CFG_FIT_FAIL_CFG
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_REGS_CFG_FIT_FAIL_CFG_FIELDS[] =
{
    &RNR_REGS_CFG_FIT_FAIL_CFG_START_ADDR_FIELD,
    &RNR_REGS_CFG_FIT_FAIL_CFG_STOP_ADDR_FIELD,
    &RNR_REGS_CFG_FIT_FAIL_CFG_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_REGS_CFG_FIT_FAIL_CFG_REG = 
{
    "CFG_FIT_FAIL_CFG",
#if RU_INCLUDE_DESC
    "FIT_FAIL_CONFIG Register",
    "Configure exclusion addresses for fit fail. Fit fail will not be triggered if program counter is between two configured addresses.",
#endif
    RNR_REGS_CFG_FIT_FAIL_CFG_REG_OFFSET,
    0,
    0,
    265,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    3,
    RNR_REGS_CFG_FIT_FAIL_CFG_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_REGS_CFG_DATA_BKPT_CFG
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_REGS_CFG_DATA_BKPT_CFG_FIELDS[] =
{
    &RNR_REGS_CFG_DATA_BKPT_CFG_BKPT_0_EN_FIELD,
    &RNR_REGS_CFG_DATA_BKPT_CFG_BKPT_0_USE_THREAD_FIELD,
    &RNR_REGS_CFG_DATA_BKPT_CFG_BKPT_1_EN_FIELD,
    &RNR_REGS_CFG_DATA_BKPT_CFG_BKPT_1_USE_THREAD_FIELD,
    &RNR_REGS_CFG_DATA_BKPT_CFG_BKPT_2_EN_FIELD,
    &RNR_REGS_CFG_DATA_BKPT_CFG_BKPT_2_USE_THREAD_FIELD,
    &RNR_REGS_CFG_DATA_BKPT_CFG_BKPT_3_EN_FIELD,
    &RNR_REGS_CFG_DATA_BKPT_CFG_BKPT_3_USE_THREAD_FIELD,
    &RNR_REGS_CFG_DATA_BKPT_CFG_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_REGS_CFG_DATA_BKPT_CFG_REG = 
{
    "CFG_DATA_BKPT_CFG",
#if RU_INCLUDE_DESC
    "DATA_BKPT_CFG Register",
    "Data breakpoint configuration",
#endif
    RNR_REGS_CFG_DATA_BKPT_CFG_REG_OFFSET,
    0,
    0,
    266,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    9,
    RNR_REGS_CFG_DATA_BKPT_CFG_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_REGS_CFG_STALL_CNT1
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_REGS_CFG_STALL_CNT1_FIELDS[] =
{
    &RNR_REGS_CFG_STALL_CNT1_TOTAL_STALL_CNT_FIELD,
    &RNR_REGS_CFG_STALL_CNT1_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_REGS_CFG_STALL_CNT1_REG = 
{
    "CFG_STALL_CNT1",
#if RU_INCLUDE_DESC
    "STALL_CNT1 Register",
    "Stall counters",
#endif
    RNR_REGS_CFG_STALL_CNT1_REG_OFFSET,
    0,
    0,
    267,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    2,
    RNR_REGS_CFG_STALL_CNT1_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_REGS_CFG_STALL_CNT2
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_REGS_CFG_STALL_CNT2_FIELDS[] =
{
    &RNR_REGS_CFG_STALL_CNT2_STALL_ON_ALU_B_FULL_CNT_FIELD,
    &RNR_REGS_CFG_STALL_CNT2_STALL_ON_ALU_A_FULL_CNT_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_REGS_CFG_STALL_CNT2_REG = 
{
    "CFG_STALL_CNT2",
#if RU_INCLUDE_DESC
    "STALL_CNT2 Register",
    "Stall counters",
#endif
    RNR_REGS_CFG_STALL_CNT2_REG_OFFSET,
    0,
    0,
    268,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    2,
    RNR_REGS_CFG_STALL_CNT2_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_REGS_CFG_STALL_CNT3
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_REGS_CFG_STALL_CNT3_FIELDS[] =
{
    &RNR_REGS_CFG_STALL_CNT3_STALL_ON_JMPREG_FIELD,
    &RNR_REGS_CFG_STALL_CNT3_STALL_ON_MEMIO_FULL_CNT_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_REGS_CFG_STALL_CNT3_REG = 
{
    "CFG_STALL_CNT3",
#if RU_INCLUDE_DESC
    "STALL_CNT3 Register",
    "Stall counters",
#endif
    RNR_REGS_CFG_STALL_CNT3_REG_OFFSET,
    0,
    0,
    269,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    2,
    RNR_REGS_CFG_STALL_CNT3_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_REGS_CFG_STALL_CNT4
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_REGS_CFG_STALL_CNT4_FIELDS[] =
{
    &RNR_REGS_CFG_STALL_CNT4_STALL_ON_WAW_CNT_FIELD,
    &RNR_REGS_CFG_STALL_CNT4_STALL_ON_SUPER_CMD_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_REGS_CFG_STALL_CNT4_REG = 
{
    "CFG_STALL_CNT4",
#if RU_INCLUDE_DESC
    "STALL_CNT4 Register",
    "Stall counters",
#endif
    RNR_REGS_CFG_STALL_CNT4_REG_OFFSET,
    0,
    0,
    270,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    2,
    RNR_REGS_CFG_STALL_CNT4_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_REGS_CFG_STALL_CNT5
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_REGS_CFG_STALL_CNT5_FIELDS[] =
{
    &RNR_REGS_CFG_STALL_CNT5_STALL_ON_SUPER_CMD_WHEN_FULL_FIELD,
    &RNR_REGS_CFG_STALL_CNT5_STALL_ON_CS_CNT_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_REGS_CFG_STALL_CNT5_REG = 
{
    "CFG_STALL_CNT5",
#if RU_INCLUDE_DESC
    "STALL_CNT5 Register",
    "Stall counters",
#endif
    RNR_REGS_CFG_STALL_CNT5_REG_OFFSET,
    0,
    0,
    271,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    2,
    RNR_REGS_CFG_STALL_CNT5_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_REGS_CFG_STALL_CNT6
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_REGS_CFG_STALL_CNT6_FIELDS[] =
{
    &RNR_REGS_CFG_STALL_CNT6_ACTIVE_CYCLES_CNT_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_REGS_CFG_STALL_CNT6_REG = 
{
    "CFG_STALL_CNT6",
#if RU_INCLUDE_DESC
    "STALL_CNT6 Register",
    "Stall counters",
#endif
    RNR_REGS_CFG_STALL_CNT6_REG_OFFSET,
    0,
    0,
    272,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    RNR_REGS_CFG_STALL_CNT6_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_REGS_CFG_STALL_CNT7
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_REGS_CFG_STALL_CNT7_FIELDS[] =
{
    &RNR_REGS_CFG_STALL_CNT7_STALL_ON_JMP_FULL_CNT_FIELD,
    &RNR_REGS_CFG_STALL_CNT7_STALL_ON_SKIP_JMP_CNT_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_REGS_CFG_STALL_CNT7_REG = 
{
    "CFG_STALL_CNT7",
#if RU_INCLUDE_DESC
    "STALL_CNT7 Register",
    "Stall counters",
#endif
    RNR_REGS_CFG_STALL_CNT7_REG_OFFSET,
    0,
    0,
    273,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    2,
    RNR_REGS_CFG_STALL_CNT7_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_REGS_CFG_PROFILING_STS
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_REGS_CFG_PROFILING_STS_FIELDS[] =
{
    &RNR_REGS_CFG_PROFILING_STS_TRACE_WRITE_PNT_FIELD,
    &RNR_REGS_CFG_PROFILING_STS_IDLE_NO_ACTIVE_TASK_FIELD,
    &RNR_REGS_CFG_PROFILING_STS_CURR_THREAD_NUM_FIELD,
    &RNR_REGS_CFG_PROFILING_STS_PROFILING_ACTIVE_FIELD,
    &RNR_REGS_CFG_PROFILING_STS_TRACE_FIFO_OVERRUN_FIELD,
    &RNR_REGS_CFG_PROFILING_STS_SINGLE_MODE_PROFILING_STATUS_FIELD,
    &RNR_REGS_CFG_PROFILING_STS_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_REGS_CFG_PROFILING_STS_REG = 
{
    "CFG_PROFILING_STS",
#if RU_INCLUDE_DESC
    "PROFILING_STS Register",
    "profiling status",
#endif
    RNR_REGS_CFG_PROFILING_STS_REG_OFFSET,
    0,
    0,
    274,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    7,
    RNR_REGS_CFG_PROFILING_STS_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_REGS_CFG_PROFILING_CFG_0
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_REGS_CFG_PROFILING_CFG_0_FIELDS[] =
{
    &RNR_REGS_CFG_PROFILING_CFG_0_TRACE_BASE_ADDR_FIELD,
    &RNR_REGS_CFG_PROFILING_CFG_0_RESERVED0_FIELD,
    &RNR_REGS_CFG_PROFILING_CFG_0_TRACE_MAX_ADDR_FIELD,
    &RNR_REGS_CFG_PROFILING_CFG_0_RESERVED1_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_REGS_CFG_PROFILING_CFG_0_REG = 
{
    "CFG_PROFILING_CFG_0",
#if RU_INCLUDE_DESC
    "PROFILING_CFG_0 Register",
    "profiling confuguration 0",
#endif
    RNR_REGS_CFG_PROFILING_CFG_0_REG_OFFSET,
    0,
    0,
    275,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    4,
    RNR_REGS_CFG_PROFILING_CFG_0_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_REGS_CFG_PROFILING_CFG_1
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_REGS_CFG_PROFILING_CFG_1_FIELDS[] =
{
    &RNR_REGS_CFG_PROFILING_CFG_1_TRACE_WRAPAROUND_FIELD,
    &RNR_REGS_CFG_PROFILING_CFG_1_TRACE_MODE_FIELD,
    &RNR_REGS_CFG_PROFILING_CFG_1_TRACE_DISABLE_IDLE_IN_FIELD,
    &RNR_REGS_CFG_PROFILING_CFG_1_TRACE_DISABLE_WAKEUP_LOG_FIELD,
    &RNR_REGS_CFG_PROFILING_CFG_1_TRACE_TASK_FIELD,
    &RNR_REGS_CFG_PROFILING_CFG_1_IDLE_COUNTER_SOURCE_SEL_FIELD,
    &RNR_REGS_CFG_PROFILING_CFG_1_COUNTERS_SELECTED_TASK_MODE_FIELD,
    &RNR_REGS_CFG_PROFILING_CFG_1_COUNTERS_TASK_FIELD,
    &RNR_REGS_CFG_PROFILING_CFG_1_PROFILING_WINDOW_MODE_FIELD,
    &RNR_REGS_CFG_PROFILING_CFG_1_SINGLE_MODE_START_OPTION_FIELD,
    &RNR_REGS_CFG_PROFILING_CFG_1_SINGLE_MODE_STOP_OPTION_FIELD,
    &RNR_REGS_CFG_PROFILING_CFG_1_WINDOW_MANUAL_START_FIELD,
    &RNR_REGS_CFG_PROFILING_CFG_1_WINDOW_MANUAL_STOP_FIELD,
    &RNR_REGS_CFG_PROFILING_CFG_1_TRACER_ENABLE_FIELD,
    &RNR_REGS_CFG_PROFILING_CFG_1_RESERVED0_FIELD,
    &RNR_REGS_CFG_PROFILING_CFG_1_PROFILING_WINDOW_RESET_FIELD,
    &RNR_REGS_CFG_PROFILING_CFG_1_PROFILING_WINDOW_ENABLE_FIELD,
    &RNR_REGS_CFG_PROFILING_CFG_1_RESERVED1_FIELD,
    &RNR_REGS_CFG_PROFILING_CFG_1_TRACE_RESET_EVENT_FIFO_FIELD,
    &RNR_REGS_CFG_PROFILING_CFG_1_TRACE_CLEAR_FIFO_OVERRUN_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_REGS_CFG_PROFILING_CFG_1_REG = 
{
    "CFG_PROFILING_CFG_1",
#if RU_INCLUDE_DESC
    "PROFILING_CFG_1 Register",
    "profiling confuguration 1",
#endif
    RNR_REGS_CFG_PROFILING_CFG_1_REG_OFFSET,
    0,
    0,
    276,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    20,
    RNR_REGS_CFG_PROFILING_CFG_1_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_REGS_CFG_PROFILING_COUNTER
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_REGS_CFG_PROFILING_COUNTER_FIELDS[] =
{
    &RNR_REGS_CFG_PROFILING_COUNTER_VAL_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_REGS_CFG_PROFILING_COUNTER_REG = 
{
    "CFG_PROFILING_COUNTER",
#if RU_INCLUDE_DESC
    "PROFILING_COUNTER Register",
    "Display profiling counter value",
#endif
    RNR_REGS_CFG_PROFILING_COUNTER_REG_OFFSET,
    0,
    0,
    277,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    RNR_REGS_CFG_PROFILING_COUNTER_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_REGS_CFG_PROFILING_CFG_2
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_REGS_CFG_PROFILING_CFG_2_FIELDS[] =
{
    &RNR_REGS_CFG_PROFILING_CFG_2_TRIGGER_ON_SECOND_FIELD,
    &RNR_REGS_CFG_PROFILING_CFG_2_PC_START_FIELD,
    &RNR_REGS_CFG_PROFILING_CFG_2_PC_STOP_OR_CYCLE_COUNT_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_REGS_CFG_PROFILING_CFG_2_REG = 
{
    "CFG_PROFILING_CFG_2",
#if RU_INCLUDE_DESC
    "PROFILING_CFG_2 Register",
    "profiling confuguration 2",
#endif
    RNR_REGS_CFG_PROFILING_CFG_2_REG_OFFSET,
    0,
    0,
    278,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    3,
    RNR_REGS_CFG_PROFILING_CFG_2_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_REGS_CFG_EXEC_CMDS_CNT
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_REGS_CFG_EXEC_CMDS_CNT_FIELDS[] =
{
    &RNR_REGS_CFG_EXEC_CMDS_CNT_EXEC_COUNTER_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_REGS_CFG_EXEC_CMDS_CNT_REG = 
{
    "CFG_EXEC_CMDS_CNT",
#if RU_INCLUDE_DESC
    "EXEC_CMDS_CNT Register",
    "Count all executed commands in profiling window",
#endif
    RNR_REGS_CFG_EXEC_CMDS_CNT_REG_OFFSET,
    0,
    0,
    279,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    RNR_REGS_CFG_EXEC_CMDS_CNT_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_REGS_CFG_IDLE_CNT1
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_REGS_CFG_IDLE_CNT1_FIELDS[] =
{
    &RNR_REGS_CFG_IDLE_CNT1_IDLE_CNT_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_REGS_CFG_IDLE_CNT1_REG = 
{
    "CFG_IDLE_CNT1",
#if RU_INCLUDE_DESC
    "IDLE_CNT1 Register",
    "idle count",
#endif
    RNR_REGS_CFG_IDLE_CNT1_REG_OFFSET,
    0,
    0,
    280,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    RNR_REGS_CFG_IDLE_CNT1_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_REGS_CFG_JMP_CNT
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_REGS_CFG_JMP_CNT_FIELDS[] =
{
    &RNR_REGS_CFG_JMP_CNT_UNTAKEN_JMP_CNT_FIELD,
    &RNR_REGS_CFG_JMP_CNT_TAKEN_JMP_CNT_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_REGS_CFG_JMP_CNT_REG = 
{
    "CFG_JMP_CNT",
#if RU_INCLUDE_DESC
    "JUMP_CNT Register",
    "Mispredicted jumps count",
#endif
    RNR_REGS_CFG_JMP_CNT_REG_OFFSET,
    0,
    0,
    281,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    2,
    RNR_REGS_CFG_JMP_CNT_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_REGS_CFG_METAL_FIX_REG
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_REGS_CFG_METAL_FIX_REG_FIELDS[] =
{
    &RNR_REGS_CFG_METAL_FIX_REG_METAL_FIX_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_REGS_CFG_METAL_FIX_REG_REG = 
{
    "CFG_METAL_FIX_REG",
#if RU_INCLUDE_DESC
    "METAL_FIX Register",
    "32 bit register for metal fixes.",
#endif
    RNR_REGS_CFG_METAL_FIX_REG_REG_OFFSET,
    0,
    0,
    282,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    RNR_REGS_CFG_METAL_FIX_REG_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Block: RNR_REGS
 ******************************************************************************/
static const ru_reg_rec *RNR_REGS_REGS[] =
{
    &RNR_REGS_CFG_GLOBAL_CTRL_REG,
    &RNR_REGS_CFG_CPU_WAKEUP_REG,
    &RNR_REGS_CFG_INT_CTRL_REG,
    &RNR_REGS_CFG_INT_MASK_REG,
    &RNR_REGS_CFG_GEN_CFG_REG,
    &RNR_REGS_CFG_CAM_CFG_REG,
    &RNR_REGS_CFG_DDR_CFG_REG,
    &RNR_REGS_CFG_PSRAM_CFG_REG,
    &RNR_REGS_CFG_RAMRD_RANGE_MASK_CFG_REG,
    &RNR_REGS_CFG_SCH_CFG_REG,
    &RNR_REGS_CFG_BKPT_CFG_REG,
    &RNR_REGS_CFG_BKPT_IMM_REG,
    &RNR_REGS_CFG_BKPT_STS_REG,
    &RNR_REGS_CFG_PC_STS_REG,
    &RNR_REGS_CFG_EXT_ACC_CFG_REG,
    &RNR_REGS_CFG_FIT_FAIL_CFG_REG,
    &RNR_REGS_CFG_DATA_BKPT_CFG_REG,
    &RNR_REGS_CFG_STALL_CNT1_REG,
    &RNR_REGS_CFG_STALL_CNT2_REG,
    &RNR_REGS_CFG_STALL_CNT3_REG,
    &RNR_REGS_CFG_STALL_CNT4_REG,
    &RNR_REGS_CFG_STALL_CNT5_REG,
    &RNR_REGS_CFG_STALL_CNT6_REG,
    &RNR_REGS_CFG_STALL_CNT7_REG,
    &RNR_REGS_CFG_PROFILING_STS_REG,
    &RNR_REGS_CFG_PROFILING_CFG_0_REG,
    &RNR_REGS_CFG_PROFILING_CFG_1_REG,
    &RNR_REGS_CFG_PROFILING_COUNTER_REG,
    &RNR_REGS_CFG_PROFILING_CFG_2_REG,
    &RNR_REGS_CFG_EXEC_CMDS_CNT_REG,
    &RNR_REGS_CFG_IDLE_CNT1_REG,
    &RNR_REGS_CFG_JMP_CNT_REG,
    &RNR_REGS_CFG_METAL_FIX_REG_REG,
};

unsigned long RNR_REGS_ADDRS[] =
{
    0x82800000,
    0x82801000,
    0x82802000,
    0x82803000,
    0x82804000,
    0x82805000,
    0x82806000,
    0x82807000,
};

const ru_block_rec RNR_REGS_BLOCK = 
{
    "RNR_REGS",
    RNR_REGS_ADDRS,
    8,
    33,
    RNR_REGS_REGS
};

/* End of file XRDP_RNR_REGS.c */
