/*
   Copyright (c) 2015 Broadcom
   All Rights Reserved

    <:label-BRCM:2015:DUAL/GPL:standard
    
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License, version 2, as published by
    the Free Software Foundation (the "GPL").
    
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
    
    
    A copy of the GPL is available at http://www.broadcom.com/licenses/GPLv2.php, or by
    writing to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
    
:>
*/

#include "ru.h"

#if RU_INCLUDE_FIELD_DB
/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_ENG_CFG
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_ENG_CFG_FIELD =
{
    "CFG",
#if RU_INCLUDE_DESC
    "CFG",
    "/* eng_cnfg[0] - IP filters on IPV6 on LSByte not MSByte                                */"
    "/* eng_cnfg[1] - Free                                                                   */"
    "/* eng_cnfg[2] - enable LLC_SNAP at result word                                         */"
    "/* eng_cnfg[3] - defines the protocol of ppp_code_1 (1 - IPv6, 0 - IPv4) PPPOE CODE1 is IPv4 instead of IPv6 */"
    "/* eng_cnfg[4] -  disables ip hdr length error check - 0                                */"
    "/* eng_cnfg[5] - Disable ip_ver_err check -> 1-ip versions is always 4                  */"
    "/* eng_cnfg[6] - enables checking if ip_version matches the IP version according to L2 - 0 */"
    "/* eng_cnfg[7] - enable ICMP(next_prot=1) over IPV6                                     */"
    "/* eng_cnfg[8]  -  ipv6 route with non zero segment orred with ip_hdr_len_err           */"
    "/* eng_cnfg[9]  - enable detection of ipv6_hop_by_hop  not directly after ipv6 header   */"
    "/* eng_cnfg[10] - Select MAC Mode for result                                            */"
    "/* eng_cnfg[11] - Select IPv6 MCAST control filter FF0::/116 instead of FF02::/112      */"
    "/* eng_cnfg[12] - Free                                                                  */"
    "/* eng_cnfg[13] - ipv4 length error is assered also when packet is padded               */"
    "/* eng_cnfg[14] - ipv6 length error is assered also when packet is padded               */"
    "/* eng_cnfg[15] - enable old mode of AH at IPV6                                         */"
    "/* eng_cnfg[16] - enable old mode of AH at IPV4                                         */"
    "/* eng_cnfg[17] - Free                                                                  */"
    "/* eng_cnfg[18] - dont allow 0xFFFF as valid ipv4 header cksum results                  */"
    "/* eng_cnfg[19] - Disable IPV4_OVER_6 as qualifier for l4_fast_path_protocol            */"
    "/* eng_cnfg[20] - Disable IPV6_OVER_4 as qualifier for l4_fast_path_protocol            */"
    "/* eng_cnfg[21] - YL mode                                                               */"
    "/* eng_cnfg[22] - Enable MC BC bits at IC Key                                           */"
    "/* eng_cnfg[23] - mask L2/L3 valid key logic                                            */"
    "/* ************************************************************************************ */"
    ""
    "",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_ENG_CFG_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_ENG_CFG_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_ENG_CFG_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_PARSER_MISC_CFG_EXCEPTION_EN
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_PARSER_MISC_CFG_EXCEPTION_EN_FIELD =
{
    "EXCEPTION_EN",
#if RU_INCLUDE_DESC
    "EXCEPTION_EN",
    "Enable Exception:"
    "exception_en[0] - IP header length error"
    "exception_en[1] - IPv4 header checksum error"
    "exception_en[2] - Ethernet multicast"
    "exception_en[3] - ip_mcast_match - Multicast Layer 3 Identified by the following filters on IP-DA:"
    "IPv4: 224.0.0.0/28,"
    "IPv6: 0xFF00::/116 and 0xFF30/116"
    "exception_en[4] - ip_fragment: any fragment: first middle or last"
    "exception_en[5] - ip_version_err"
    "exception_en[6] - ip_mcast_control_match - Set when Multicast Layer 3 Control:"
    "Identified IPv4 DA: IPv4 224.0.0.0/8"
    "IPv6: 0xFF02::/112"
    "exception_en[7] - eth_brdcst"
    "exception_en[8] - error: not enough bytes in the header to complete parsing of the packet"
    "exception_en[9] - ip_length_error"
    ""
    "exception_en[10]- eth_ipv4_mcast -"
    "multicast Layer 2 Identified by the following DA filter:"
    "01:00:5e:::/23 or 33:33::::/32"
    "exception_en[11]- not 5 tupple valid"
    "exception_en[12]- udp_1588_flag"
    "exception_en[13]- DHCP identified"
    "exception_en[14]- DOS attack"
    "exception_en[15]- Domain Name Server request"
    "exception_en[16]- GRE withe unrecgonized version (not 0 or 1)",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_PARSER_MISC_CFG_EXCEPTION_EN_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_PARSER_MISC_CFG_EXCEPTION_EN_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_PARSER_MISC_CFG_EXCEPTION_EN_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_PARSER_MISC_CFG_PROFILE_US
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_PARSER_MISC_CFG_PROFILE_US_FIELD =
{
    "PROFILE_US",
#if RU_INCLUDE_DESC
    "PROFILE_US",
    "Profile US - Not Applicable for 63146, 4912",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_PARSER_MISC_CFG_PROFILE_US_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_PARSER_MISC_CFG_PROFILE_US_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_PARSER_MISC_CFG_PROFILE_US_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_PARSER_MISC_CFG_DISABLE_L2TP_SOURCE_PORT_CHECK
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_PARSER_MISC_CFG_DISABLE_L2TP_SOURCE_PORT_CHECK_FIELD =
{
    "DISABLE_L2TP_SOURCE_PORT_CHECK",
#if RU_INCLUDE_DESC
    "DISABLE_L2TP_SOURCE_PORT_CHECK",
    "Disable checking source port number for L2TP identification",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_PARSER_MISC_CFG_DISABLE_L2TP_SOURCE_PORT_CHECK_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_PARSER_MISC_CFG_DISABLE_L2TP_SOURCE_PORT_CHECK_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_PARSER_MISC_CFG_DISABLE_L2TP_SOURCE_PORT_CHECK_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_PARSER_MISC_CFG_TCP_FLAGS_FILT
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_PARSER_MISC_CFG_TCP_FLAGS_FILT_FIELD =
{
    "TCP_FLAGS_FILT",
#if RU_INCLUDE_DESC
    "TCP_FLAGS_TCP_FILTER",
    "Defines which TCP falgs set will cause TCP_FLAG bit in summary word to be set",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_PARSER_MISC_CFG_TCP_FLAGS_FILT_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_PARSER_MISC_CFG_TCP_FLAGS_FILT_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_PARSER_MISC_CFG_TCP_FLAGS_FILT_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_0_1_VID_0
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_0_1_VID_0_FIELD =
{
    "VID_0",
#if RU_INCLUDE_DESC
    "VID_0",
    "VLAN ID Filter for first VLAN of register",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_0_1_VID_0_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_0_1_VID_0_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_0_1_VID_0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_0_1_RESERVED0
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_0_1_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_0_1_RESERVED0_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_0_1_RESERVED0_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_0_1_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_0_1_VID_0_EN
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_0_1_VID_0_EN_FIELD =
{
    "VID_0_EN",
#if RU_INCLUDE_DESC
    "VID_0_Enable",
    "VLAND ID Filter 0 Enable",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_0_1_VID_0_EN_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_0_1_VID_0_EN_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_0_1_VID_0_EN_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_0_1_VID_1
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_0_1_VID_1_FIELD =
{
    "VID_1",
#if RU_INCLUDE_DESC
    "VID_1",
    "VLAN ID Filter 1 for second VLAN of register",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_0_1_VID_1_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_0_1_VID_1_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_0_1_VID_1_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_0_1_RESERVED1
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_0_1_RESERVED1_FIELD =
{
    "RESERVED1",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_0_1_RESERVED1_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_0_1_RESERVED1_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_0_1_RESERVED1_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_0_1_VID_1_EN
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_0_1_VID_1_EN_FIELD =
{
    "VID_1_EN",
#if RU_INCLUDE_DESC
    "VID_1_Enable",
    "VLAND ID Filter 1 Enable",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_0_1_VID_1_EN_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_0_1_VID_1_EN_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_0_1_VID_1_EN_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_2_3_VID_2
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_2_3_VID_2_FIELD =
{
    "VID_2",
#if RU_INCLUDE_DESC
    "VID_2",
    "VLAN ID Filter for first VLAN of register",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_2_3_VID_2_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_2_3_VID_2_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_2_3_VID_2_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_2_3_RESERVED0
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_2_3_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_2_3_RESERVED0_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_2_3_RESERVED0_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_2_3_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_2_3_VID_2_EN
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_2_3_VID_2_EN_FIELD =
{
    "VID_2_EN",
#if RU_INCLUDE_DESC
    "VID_2_Enable",
    "VLAND ID Filter 2 Enable",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_2_3_VID_2_EN_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_2_3_VID_2_EN_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_2_3_VID_2_EN_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_2_3_VID_3
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_2_3_VID_3_FIELD =
{
    "VID_3",
#if RU_INCLUDE_DESC
    "VID_3",
    "VLAN ID Filter 3 ofr second VLAN of register",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_2_3_VID_3_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_2_3_VID_3_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_2_3_VID_3_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_2_3_RESERVED1
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_2_3_RESERVED1_FIELD =
{
    "RESERVED1",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_2_3_RESERVED1_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_2_3_RESERVED1_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_2_3_RESERVED1_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_2_3_VID_3_EN
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_2_3_VID_3_EN_FIELD =
{
    "VID_3_EN",
#if RU_INCLUDE_DESC
    "VID_3_Enable",
    "VLAND ID Filter 3 Enable",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_2_3_VID_3_EN_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_2_3_VID_3_EN_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_2_3_VID_3_EN_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_4_5_VID_4
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_4_5_VID_4_FIELD =
{
    "VID_4",
#if RU_INCLUDE_DESC
    "VID_4",
    "VLAN ID Filter for first VLAN of register",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_4_5_VID_4_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_4_5_VID_4_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_4_5_VID_4_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_4_5_RESERVED0
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_4_5_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_4_5_RESERVED0_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_4_5_RESERVED0_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_4_5_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_4_5_VID_4_EN
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_4_5_VID_4_EN_FIELD =
{
    "VID_4_EN",
#if RU_INCLUDE_DESC
    "VID_4_Enable",
    "VLAND ID Filter 4 Enable",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_4_5_VID_4_EN_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_4_5_VID_4_EN_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_4_5_VID_4_EN_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_4_5_VID_5
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_4_5_VID_5_FIELD =
{
    "VID_5",
#if RU_INCLUDE_DESC
    "VID_5",
    "VLAN ID Filter 5 ofr second VLAN of register",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_4_5_VID_5_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_4_5_VID_5_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_4_5_VID_5_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_4_5_RESERVED1
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_4_5_RESERVED1_FIELD =
{
    "RESERVED1",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_4_5_RESERVED1_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_4_5_RESERVED1_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_4_5_RESERVED1_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_4_5_VID_5_EN
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_4_5_VID_5_EN_FIELD =
{
    "VID_5_EN",
#if RU_INCLUDE_DESC
    "VID_5_Enable",
    "VLAND ID Filter 5 Enable",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_4_5_VID_5_EN_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_4_5_VID_5_EN_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_4_5_VID_5_EN_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_6_7_VID_6
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_6_7_VID_6_FIELD =
{
    "VID_6",
#if RU_INCLUDE_DESC
    "VID_6",
    "VLAN ID Filter for first VLAN of register",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_6_7_VID_6_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_6_7_VID_6_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_6_7_VID_6_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_6_7_RESERVED0
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_6_7_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_6_7_RESERVED0_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_6_7_RESERVED0_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_6_7_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_6_7_VID_6_EN
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_6_7_VID_6_EN_FIELD =
{
    "VID_6_EN",
#if RU_INCLUDE_DESC
    "VID_6_Enable",
    "VLAND ID Filter 6 Enable",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_6_7_VID_6_EN_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_6_7_VID_6_EN_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_6_7_VID_6_EN_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_6_7_VID_7
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_6_7_VID_7_FIELD =
{
    "VID_7",
#if RU_INCLUDE_DESC
    "VID_7",
    "VLAN ID Filter 7 ofr second VLAN of register",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_6_7_VID_7_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_6_7_VID_7_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_6_7_VID_7_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_6_7_RESERVED1
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_6_7_RESERVED1_FIELD =
{
    "RESERVED1",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_6_7_RESERVED1_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_6_7_RESERVED1_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_6_7_RESERVED1_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_6_7_VID_7_EN
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_6_7_VID_7_EN_FIELD =
{
    "VID_7_EN",
#if RU_INCLUDE_DESC
    "VID_7_Enable",
    "VLAND ID Filter 7 Enable",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_6_7_VID_7_EN_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_6_7_VID_7_EN_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_6_7_VID_7_EN_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_IP_FILTER0_CFG_IP_ADDRESS
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_IP_FILTER0_CFG_IP_ADDRESS_FIELD =
{
    "IP_ADDRESS",
#if RU_INCLUDE_DESC
    "IP_address",
    "32-bit address to match SIP or DIP (according to predefined configuration in IP_FILTERS_CFG register)",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_IP_FILTER0_CFG_IP_ADDRESS_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_IP_FILTER0_CFG_IP_ADDRESS_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_IP_FILTER0_CFG_IP_ADDRESS_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_IP_FILTER1_CFG_IP_ADDRESS
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_IP_FILTER1_CFG_IP_ADDRESS_FIELD =
{
    "IP_ADDRESS",
#if RU_INCLUDE_DESC
    "IP_address",
    "32-bit address to match SIP or DIP (according to predefined configuration in IP_FILTERS_CFG register)",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_IP_FILTER1_CFG_IP_ADDRESS_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_IP_FILTER1_CFG_IP_ADDRESS_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_IP_FILTER1_CFG_IP_ADDRESS_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_IP_FILTER0_MASK_CFG_IP_ADDRESS_MASK
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_IP_FILTER0_MASK_CFG_IP_ADDRESS_MASK_FIELD =
{
    "IP_ADDRESS_MASK",
#if RU_INCLUDE_DESC
    "IP_address_mask",
    "32-bit address mask",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_IP_FILTER0_MASK_CFG_IP_ADDRESS_MASK_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_IP_FILTER0_MASK_CFG_IP_ADDRESS_MASK_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_IP_FILTER0_MASK_CFG_IP_ADDRESS_MASK_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_IP_FILTER1_MASK_CFG_IP_ADDRESS_MASK
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_IP_FILTER1_MASK_CFG_IP_ADDRESS_MASK_FIELD =
{
    "IP_ADDRESS_MASK",
#if RU_INCLUDE_DESC
    "IP_address_mask",
    "32-bit address mask",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_IP_FILTER1_MASK_CFG_IP_ADDRESS_MASK_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_IP_FILTER1_MASK_CFG_IP_ADDRESS_MASK_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_IP_FILTER1_MASK_CFG_IP_ADDRESS_MASK_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_IP_FILTERS_CFG_IP_FILTER0_DIP_EN
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_IP_FILTERS_CFG_IP_FILTER0_DIP_EN_FIELD =
{
    "IP_FILTER0_DIP_EN",
#if RU_INCLUDE_DESC
    "IP_FILTER0_DIP_EN",
    "IP Filter0 DIP or SIP selection."
    "The default is SIP, when the field is set -> DIP selection is enabled",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_IP_FILTERS_CFG_IP_FILTER0_DIP_EN_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_IP_FILTERS_CFG_IP_FILTER0_DIP_EN_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_IP_FILTERS_CFG_IP_FILTER0_DIP_EN_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_IP_FILTERS_CFG_IP_FILTER1_DIP_EN
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_IP_FILTERS_CFG_IP_FILTER1_DIP_EN_FIELD =
{
    "IP_FILTER1_DIP_EN",
#if RU_INCLUDE_DESC
    "IP_FILTER1_DIP_EN",
    "IP Filter1 DIP or SIP selection."
    "The default is SIP, when the field is set -> DIP selection is enabled",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_IP_FILTERS_CFG_IP_FILTER1_DIP_EN_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_IP_FILTERS_CFG_IP_FILTER1_DIP_EN_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_IP_FILTERS_CFG_IP_FILTER1_DIP_EN_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_IP_FILTERS_CFG_IP_FILTER2_DIP_EN
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_IP_FILTERS_CFG_IP_FILTER2_DIP_EN_FIELD =
{
    "IP_FILTER2_DIP_EN",
#if RU_INCLUDE_DESC
    "IP_FILTER2_DIP_EN",
    "IP Filter2 DIP or SIP selection."
    "The default is SIP, when the field is set -> DIP selection is enabled",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_IP_FILTERS_CFG_IP_FILTER2_DIP_EN_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_IP_FILTERS_CFG_IP_FILTER2_DIP_EN_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_IP_FILTERS_CFG_IP_FILTER2_DIP_EN_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_IP_FILTERS_CFG_IP_FILTER3_DIP_EN
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_IP_FILTERS_CFG_IP_FILTER3_DIP_EN_FIELD =
{
    "IP_FILTER3_DIP_EN",
#if RU_INCLUDE_DESC
    "IP_FILTER3_DIP_EN",
    "IP Filter3 DIP or SIP selection."
    "The default is SIP, when the field is set -> DIP selection is enabled",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_IP_FILTERS_CFG_IP_FILTER3_DIP_EN_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_IP_FILTERS_CFG_IP_FILTER3_DIP_EN_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_IP_FILTERS_CFG_IP_FILTER3_DIP_EN_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_IP_FILTERS_CFG_IP_FILTER0_VALID
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_IP_FILTERS_CFG_IP_FILTER0_VALID_FIELD =
{
    "IP_FILTER0_VALID",
#if RU_INCLUDE_DESC
    "IP_FILTER0_VALID",
    "IP Filter0 valid bit."
    ""
    "When the bit valid is set, the IP filter/mask can be applied by hardware.",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_IP_FILTERS_CFG_IP_FILTER0_VALID_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_IP_FILTERS_CFG_IP_FILTER0_VALID_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_IP_FILTERS_CFG_IP_FILTER0_VALID_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_IP_FILTERS_CFG_IP_FILTER1_VALID
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_IP_FILTERS_CFG_IP_FILTER1_VALID_FIELD =
{
    "IP_FILTER1_VALID",
#if RU_INCLUDE_DESC
    "IP_FILTER1_VALID",
    "IP Filter1 valid bit."
    ""
    "When the bit valid is set, the IP filter/mask can be applied by hardware.",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_IP_FILTERS_CFG_IP_FILTER1_VALID_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_IP_FILTERS_CFG_IP_FILTER1_VALID_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_IP_FILTERS_CFG_IP_FILTER1_VALID_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_IP_FILTERS_CFG_IP_FILTER2_VALID
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_IP_FILTERS_CFG_IP_FILTER2_VALID_FIELD =
{
    "IP_FILTER2_VALID",
#if RU_INCLUDE_DESC
    "IP_FILTER2_VALID",
    "IP Filter2 valid bit."
    ""
    "When the bit valid is set, the IP filter/mask can be applied by hardware.",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_IP_FILTERS_CFG_IP_FILTER2_VALID_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_IP_FILTERS_CFG_IP_FILTER2_VALID_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_IP_FILTERS_CFG_IP_FILTER2_VALID_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_IP_FILTERS_CFG_IP_FILTER3_VALID
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_IP_FILTERS_CFG_IP_FILTER3_VALID_FIELD =
{
    "IP_FILTER3_VALID",
#if RU_INCLUDE_DESC
    "IP_FILTER3_VALID",
    "IP Filter3 valid bit."
    ""
    "When the bit valid is set, the IP filter/mask can be applied by hardware.",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_IP_FILTERS_CFG_IP_FILTER3_VALID_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_IP_FILTERS_CFG_IP_FILTER3_VALID_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_IP_FILTERS_CFG_IP_FILTER3_VALID_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_IP_FILTERS_CFG_RESERVED0
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_IP_FILTERS_CFG_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_IP_FILTERS_CFG_RESERVED0_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_IP_FILTERS_CFG_RESERVED0_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_IP_FILTERS_CFG_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_SNAP_ORG_CODE_CODE
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_SNAP_ORG_CODE_CODE_FIELD =
{
    "CODE",
#if RU_INCLUDE_DESC
    "Organization_Code",
    "Used defined SNAP organization code",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_SNAP_ORG_CODE_CODE_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_SNAP_ORG_CODE_CODE_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_SNAP_ORG_CODE_CODE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_SNAP_ORG_CODE_EN_RFC1042
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_SNAP_ORG_CODE_EN_RFC1042_FIELD =
{
    "EN_RFC1042",
#if RU_INCLUDE_DESC
    "RFC1042_ethernet_encapsulation_enable",
    "enable RFC1042 0x00000 organization code",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_SNAP_ORG_CODE_EN_RFC1042_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_SNAP_ORG_CODE_EN_RFC1042_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_SNAP_ORG_CODE_EN_RFC1042_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_SNAP_ORG_CODE_EN_8021Q
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_SNAP_ORG_CODE_EN_8021Q_FIELD =
{
    "EN_8021Q",
#if RU_INCLUDE_DESC
    "802.1Q_ehternet_encapsulation",
    "enables 802.1Q 0x0000f8 organization code",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_SNAP_ORG_CODE_EN_8021Q_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_SNAP_ORG_CODE_EN_8021Q_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_SNAP_ORG_CODE_EN_8021Q_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_SNAP_ORG_CODE_RESERVED0
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_SNAP_ORG_CODE_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_SNAP_ORG_CODE_RESERVED0_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_SNAP_ORG_CODE_RESERVED0_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_SNAP_ORG_CODE_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_PPP_IP_PROT_CODE_PPP_CODE_0
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_PPP_IP_PROT_CODE_PPP_CODE_0_FIELD =
{
    "PPP_CODE_0",
#if RU_INCLUDE_DESC
    "PPP_Protocol_Code_0",
    "PPP Protocol code to identify L3 is IP",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_PPP_IP_PROT_CODE_PPP_CODE_0_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_PPP_IP_PROT_CODE_PPP_CODE_0_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_PPP_IP_PROT_CODE_PPP_CODE_0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_PPP_IP_PROT_CODE_PPP_CODE_1
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_PPP_IP_PROT_CODE_PPP_CODE_1_FIELD =
{
    "PPP_CODE_1",
#if RU_INCLUDE_DESC
    "PPP_Protocol_Code_1",
    "PPP Protocol code to identify L3 is IP",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_PPP_IP_PROT_CODE_PPP_CODE_1_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_PPP_IP_PROT_CODE_PPP_CODE_1_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_PPP_IP_PROT_CODE_PPP_CODE_1_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_ETHTYPE_ETHTYPE_QTAG_0
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_ETHTYPE_ETHTYPE_QTAG_0_FIELD =
{
    "ETHTYPE_QTAG_0",
#if RU_INCLUDE_DESC
    "Ethertyp_for_Qtag_0",
    "Ethertype to identify VLAN QTAG",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_ETHTYPE_ETHTYPE_QTAG_0_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_ETHTYPE_ETHTYPE_QTAG_0_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_ETHTYPE_ETHTYPE_QTAG_0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_ETHTYPE_ETHTYPE_QTAG_1
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_ETHTYPE_ETHTYPE_QTAG_1_FIELD =
{
    "ETHTYPE_QTAG_1",
#if RU_INCLUDE_DESC
    "Ethertyp_for_Qtag_1",
    "Ethertype to identify VLAN QTAG",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_ETHTYPE_ETHTYPE_QTAG_1_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_ETHTYPE_ETHTYPE_QTAG_1_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_ETHTYPE_ETHTYPE_QTAG_1_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_0_1_ETHYPE_0
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_0_1_ETHYPE_0_FIELD =
{
    "ETHYPE_0",
#if RU_INCLUDE_DESC
    "User_Ethertype_0",
    "User Ethertype 0",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_0_1_ETHYPE_0_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_0_1_ETHYPE_0_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_0_1_ETHYPE_0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_0_1_ETHYPE_1
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_0_1_ETHYPE_1_FIELD =
{
    "ETHYPE_1",
#if RU_INCLUDE_DESC
    "User_Ethertype_1",
    "User Ethertype 1",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_0_1_ETHYPE_1_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_0_1_ETHYPE_1_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_0_1_ETHYPE_1_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_2_3_ETHYPE_2
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_2_3_ETHYPE_2_FIELD =
{
    "ETHYPE_2",
#if RU_INCLUDE_DESC
    "User_Ethertype_2",
    "User Ethertype 2",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_2_3_ETHYPE_2_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_2_3_ETHYPE_2_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_2_3_ETHYPE_2_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_2_3_ETHYPE_3
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_2_3_ETHYPE_3_FIELD =
{
    "ETHYPE_3",
#if RU_INCLUDE_DESC
    "User_Ethertype_3",
    "User Ethertype 3",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_2_3_ETHYPE_3_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_2_3_ETHYPE_3_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_2_3_ETHYPE_3_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_CONFIG_ETHTYPE_USER_PROT_0
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_CONFIG_ETHTYPE_USER_PROT_0_FIELD =
{
    "ETHTYPE_USER_PROT_0",
#if RU_INCLUDE_DESC
    "User_Ethertype_0_protocol",
    "Pointer to L3 protocol for User Ethertype 0 (0 - None, 1-IPv4, 2-IPv6)",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_CONFIG_ETHTYPE_USER_PROT_0_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_CONFIG_ETHTYPE_USER_PROT_0_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_CONFIG_ETHTYPE_USER_PROT_0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_CONFIG_ETHTYPE_USER_PROT_1
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_CONFIG_ETHTYPE_USER_PROT_1_FIELD =
{
    "ETHTYPE_USER_PROT_1",
#if RU_INCLUDE_DESC
    "User_Ethertype_1",
    "Pointer to L3 protocol for User Ethertype 1 (0 - None, 1-IPv4, 2-IPv6)",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_CONFIG_ETHTYPE_USER_PROT_1_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_CONFIG_ETHTYPE_USER_PROT_1_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_CONFIG_ETHTYPE_USER_PROT_1_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_CONFIG_ETHTYPE_USER_PROT_2
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_CONFIG_ETHTYPE_USER_PROT_2_FIELD =
{
    "ETHTYPE_USER_PROT_2",
#if RU_INCLUDE_DESC
    "User_Ethertype_2",
    "Pointer to L3 protocol for User Ethertype 2 (0 - None, 1-IPv4, 2-IPv6)",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_CONFIG_ETHTYPE_USER_PROT_2_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_CONFIG_ETHTYPE_USER_PROT_2_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_CONFIG_ETHTYPE_USER_PROT_2_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_CONFIG_ETHTYPE_USER_PROT_3
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_CONFIG_ETHTYPE_USER_PROT_3_FIELD =
{
    "ETHTYPE_USER_PROT_3",
#if RU_INCLUDE_DESC
    "User_Ethertype_3",
    "Pointer to L3 protocol for User Ethertype 3 (0 - None, 1-IPv4, 2-IPv6)",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_CONFIG_ETHTYPE_USER_PROT_3_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_CONFIG_ETHTYPE_USER_PROT_3_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_CONFIG_ETHTYPE_USER_PROT_3_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_CONFIG_ETHTYPE_USER_EN
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_CONFIG_ETHTYPE_USER_EN_FIELD =
{
    "ETHTYPE_USER_EN",
#if RU_INCLUDE_DESC
    "User_Ethertype_Enable",
    "Enable user Ethertype 3-0 (LSB is for user ethertype 0)",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_CONFIG_ETHTYPE_USER_EN_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_CONFIG_ETHTYPE_USER_EN_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_CONFIG_ETHTYPE_USER_EN_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_CONFIG_RESERVED0
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_CONFIG_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_CONFIG_RESERVED0_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_CONFIG_RESERVED0_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_CONFIG_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_CONFIG_ETHTYPE_USER_OFFSET_0
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_CONFIG_ETHTYPE_USER_OFFSET_0_FIELD =
{
    "ETHTYPE_USER_OFFSET_0",
#if RU_INCLUDE_DESC
    "User_Ethertype_0_L3_Offset",
    "4 byte offset for User Ethertype 0 L3",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_CONFIG_ETHTYPE_USER_OFFSET_0_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_CONFIG_ETHTYPE_USER_OFFSET_0_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_CONFIG_ETHTYPE_USER_OFFSET_0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_CONFIG_ETHTYPE_USER_OFFSET_1
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_CONFIG_ETHTYPE_USER_OFFSET_1_FIELD =
{
    "ETHTYPE_USER_OFFSET_1",
#if RU_INCLUDE_DESC
    "User_Ethertype_1_L3_Offset",
    "4 byte offset for User Ethertype 1 L3",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_CONFIG_ETHTYPE_USER_OFFSET_1_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_CONFIG_ETHTYPE_USER_OFFSET_1_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_CONFIG_ETHTYPE_USER_OFFSET_1_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_CONFIG_ETHTYPE_USER_OFFSET_2
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_CONFIG_ETHTYPE_USER_OFFSET_2_FIELD =
{
    "ETHTYPE_USER_OFFSET_2",
#if RU_INCLUDE_DESC
    "User_Ethertype_2_L3_Offset",
    "4 byte offset for User Ethertype 2 L3",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_CONFIG_ETHTYPE_USER_OFFSET_2_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_CONFIG_ETHTYPE_USER_OFFSET_2_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_CONFIG_ETHTYPE_USER_OFFSET_2_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_CONFIG_ETHTYPE_USER_OFFSET_3
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_CONFIG_ETHTYPE_USER_OFFSET_3_FIELD =
{
    "ETHTYPE_USER_OFFSET_3",
#if RU_INCLUDE_DESC
    "User_Ethertype_2_L3_Offset",
    "4 byte offset for User Ethertype 3 L3",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_CONFIG_ETHTYPE_USER_OFFSET_3_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_CONFIG_ETHTYPE_USER_OFFSET_3_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_CONFIG_ETHTYPE_USER_OFFSET_3_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_IPV6_HDR_EXT_FLTR_MASK_CFG_HOP_BY_HOP_MATCH
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_IPV6_HDR_EXT_FLTR_MASK_CFG_HOP_BY_HOP_MATCH_FIELD =
{
    "HOP_BY_HOP_MATCH",
#if RU_INCLUDE_DESC
    "hop_by_hop_match",
    "hop by hop match filter mask",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_IPV6_HDR_EXT_FLTR_MASK_CFG_HOP_BY_HOP_MATCH_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_IPV6_HDR_EXT_FLTR_MASK_CFG_HOP_BY_HOP_MATCH_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_IPV6_HDR_EXT_FLTR_MASK_CFG_HOP_BY_HOP_MATCH_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_IPV6_HDR_EXT_FLTR_MASK_CFG_ROUTING_EH
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_IPV6_HDR_EXT_FLTR_MASK_CFG_ROUTING_EH_FIELD =
{
    "ROUTING_EH",
#if RU_INCLUDE_DESC
    "routing_eh",
    "Routing extension header option match filter mask",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_IPV6_HDR_EXT_FLTR_MASK_CFG_ROUTING_EH_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_IPV6_HDR_EXT_FLTR_MASK_CFG_ROUTING_EH_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_IPV6_HDR_EXT_FLTR_MASK_CFG_ROUTING_EH_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_IPV6_HDR_EXT_FLTR_MASK_CFG_DEST_OPT_EH
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_IPV6_HDR_EXT_FLTR_MASK_CFG_DEST_OPT_EH_FIELD =
{
    "DEST_OPT_EH",
#if RU_INCLUDE_DESC
    "dest_opt_eh",
    "Destination Options extension header option match filter mask",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_IPV6_HDR_EXT_FLTR_MASK_CFG_DEST_OPT_EH_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_IPV6_HDR_EXT_FLTR_MASK_CFG_DEST_OPT_EH_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_IPV6_HDR_EXT_FLTR_MASK_CFG_DEST_OPT_EH_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_IPV6_HDR_EXT_FLTR_MASK_CFG_AH_MATCH
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_IPV6_HDR_EXT_FLTR_MASK_CFG_AH_MATCH_FIELD =
{
    "AH_MATCH",
#if RU_INCLUDE_DESC
    "ah_match",
    "Destination Options extension header option match filter mask",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_IPV6_HDR_EXT_FLTR_MASK_CFG_AH_MATCH_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_IPV6_HDR_EXT_FLTR_MASK_CFG_AH_MATCH_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_IPV6_HDR_EXT_FLTR_MASK_CFG_AH_MATCH_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_IPV6_HDR_EXT_FLTR_MASK_CFG_RESERVED0
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_IPV6_HDR_EXT_FLTR_MASK_CFG_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_IPV6_HDR_EXT_FLTR_MASK_CFG_RESERVED0_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_IPV6_HDR_EXT_FLTR_MASK_CFG_RESERVED0_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_IPV6_HDR_EXT_FLTR_MASK_CFG_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_NEST_QTAG_NEST_0_PROFILE_0
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_NEST_QTAG_NEST_0_PROFILE_0_FIELD =
{
    "QTAG_NEST_0_PROFILE_0",
#if RU_INCLUDE_DESC
    "QTAG_NEST_0_PROFILE_0",
    "Set to enable Ethertype_qTag 0 as outer (LSB)  2nd VLAN (2nd), 3rd VLAN (MSB)",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_NEST_QTAG_NEST_0_PROFILE_0_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_NEST_QTAG_NEST_0_PROFILE_0_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_NEST_QTAG_NEST_0_PROFILE_0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_NEST_QTAG_NEST_0_PROFILE_1
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_NEST_QTAG_NEST_0_PROFILE_1_FIELD =
{
    "QTAG_NEST_0_PROFILE_1",
#if RU_INCLUDE_DESC
    "QTAG_NEST_0_PROFILE_1",
    "Set to enable Ethertype_qTag 0 as outer (LSB)  2nd VLAN (2nd), 3rd VLAN (MSB)",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_NEST_QTAG_NEST_0_PROFILE_1_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_NEST_QTAG_NEST_0_PROFILE_1_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_NEST_QTAG_NEST_0_PROFILE_1_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_NEST_QTAG_NEST_0_PROFILE_2
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_NEST_QTAG_NEST_0_PROFILE_2_FIELD =
{
    "QTAG_NEST_0_PROFILE_2",
#if RU_INCLUDE_DESC
    "QTAG_NEST_0_PROFILE_2",
    "Set to enable Ethertype_qTag 0 as outer (LSB)  2nd VLAN (2nd), 3rd VLAN (MSB)",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_NEST_QTAG_NEST_0_PROFILE_2_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_NEST_QTAG_NEST_0_PROFILE_2_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_NEST_QTAG_NEST_0_PROFILE_2_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_NEST_QTAG_NEST_1_PROFILE_0
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_NEST_QTAG_NEST_1_PROFILE_0_FIELD =
{
    "QTAG_NEST_1_PROFILE_0",
#if RU_INCLUDE_DESC
    "QTAG_NEST_1_PROFILE_0",
    "Set to enable Ethertype_qTag 0 as outer (LSB)  2nd VLAN (2nd), 3rd VLAN (MSB)",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_NEST_QTAG_NEST_1_PROFILE_0_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_NEST_QTAG_NEST_1_PROFILE_0_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_NEST_QTAG_NEST_1_PROFILE_0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_NEST_QTAG_NEST_1_PROFILE_1
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_NEST_QTAG_NEST_1_PROFILE_1_FIELD =
{
    "QTAG_NEST_1_PROFILE_1",
#if RU_INCLUDE_DESC
    "QTAG_NEST_1_PROFILE_1",
    "Set to enable Ethertype_qTag 0 as outer (LSB)  2nd VLAN (2nd), 3rd VLAN (MSB)",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_NEST_QTAG_NEST_1_PROFILE_1_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_NEST_QTAG_NEST_1_PROFILE_1_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_NEST_QTAG_NEST_1_PROFILE_1_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_NEST_QTAG_NEST_1_PROFILE_2
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_NEST_QTAG_NEST_1_PROFILE_2_FIELD =
{
    "QTAG_NEST_1_PROFILE_2",
#if RU_INCLUDE_DESC
    "QTAG_NEST_1_PROFILE_2",
    "Set to enable Ethertype_qTag 0 as outer (LSB)  2nd VLAN (2nd), 3rd VLAN (MSB)",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_NEST_QTAG_NEST_1_PROFILE_2_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_NEST_QTAG_NEST_1_PROFILE_2_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_NEST_QTAG_NEST_1_PROFILE_2_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_NEST_RESERVED0
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_NEST_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_NEST_RESERVED0_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_NEST_RESERVED0_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_NEST_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_NEST_MAX_NUM_OF_VLANS
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_NEST_MAX_NUM_OF_VLANS_FIELD =
{
    "MAX_NUM_OF_VLANS",
#if RU_INCLUDE_DESC
    "MAX_NUM_OF_VLANS",
    "Max number of VLAN tags allowed in the packet.",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_NEST_MAX_NUM_OF_VLANS_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_NEST_MAX_NUM_OF_VLANS_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_NEST_MAX_NUM_OF_VLANS_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_HARD_NEST_0_HARD_NEST_PROFILE
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_HARD_NEST_0_HARD_NEST_PROFILE_FIELD =
{
    "HARD_NEST_PROFILE",
#if RU_INCLUDE_DESC
    "HARD_NEST_PROFILE",
    "bit 2-0: Enable 8100 as VLAN for outer, 2nd, and inner VLANs (inner is bit 2)."
    "bit 5-3: Enable 88a8 as VLAN for outer, 2nd, and inner VLANs."
    "bit 8-6: Enable 9100 as VLAN for outer, 2nd, and inner VLANs."
    "bit 11-9: Enable 9200 as VLAN for outer, 2nd, and inner VLANs.",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_HARD_NEST_0_HARD_NEST_PROFILE_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_HARD_NEST_0_HARD_NEST_PROFILE_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_HARD_NEST_0_HARD_NEST_PROFILE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_HARD_NEST_0_RESERVED0
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_HARD_NEST_0_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_HARD_NEST_0_RESERVED0_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_HARD_NEST_0_RESERVED0_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_HARD_NEST_0_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_HARD_NEST_1_HARD_NEST_PROFILE
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_HARD_NEST_1_HARD_NEST_PROFILE_FIELD =
{
    "HARD_NEST_PROFILE",
#if RU_INCLUDE_DESC
    "HARD_NEST_PROFILE",
    "Hard Nest Profile",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_HARD_NEST_1_HARD_NEST_PROFILE_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_HARD_NEST_1_HARD_NEST_PROFILE_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_HARD_NEST_1_HARD_NEST_PROFILE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_HARD_NEST_1_RESERVED0
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_HARD_NEST_1_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_HARD_NEST_1_RESERVED0_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_HARD_NEST_1_RESERVED0_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_HARD_NEST_1_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_HARD_NEST_2_HARD_NEST_PROFILE
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_HARD_NEST_2_HARD_NEST_PROFILE_FIELD =
{
    "HARD_NEST_PROFILE",
#if RU_INCLUDE_DESC
    "HARD_NEST_PROFILE",
    "Hard Nest Profile",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_HARD_NEST_2_HARD_NEST_PROFILE_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_HARD_NEST_2_HARD_NEST_PROFILE_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_HARD_NEST_2_HARD_NEST_PROFILE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_HARD_NEST_2_RESERVED0
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_HARD_NEST_2_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_HARD_NEST_2_RESERVED0_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_HARD_NEST_2_RESERVED0_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_HARD_NEST_2_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_IP_PROT_USER_IP_PROT_0
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_IP_PROT_USER_IP_PROT_0_FIELD =
{
    "USER_IP_PROT_0",
#if RU_INCLUDE_DESC
    "USER_IP_protocol_0",
    "User defined IP protocol 0 (value to be matched to IP protocol field)",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_IP_PROT_USER_IP_PROT_0_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_IP_PROT_USER_IP_PROT_0_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_IP_PROT_USER_IP_PROT_0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_IP_PROT_USER_IP_PROT_1
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_IP_PROT_USER_IP_PROT_1_FIELD =
{
    "USER_IP_PROT_1",
#if RU_INCLUDE_DESC
    "USER_IP_protocol_1",
    "User defined IP protocol 1 (value to be matched to IP protocol field)",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_IP_PROT_USER_IP_PROT_1_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_IP_PROT_USER_IP_PROT_1_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_IP_PROT_USER_IP_PROT_1_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_IP_PROT_USER_IP_PROT_2
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_IP_PROT_USER_IP_PROT_2_FIELD =
{
    "USER_IP_PROT_2",
#if RU_INCLUDE_DESC
    "USER_IP_protocol_2",
    "User defined IP protocol 2 (value to be matched to IP protocol field)",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_IP_PROT_USER_IP_PROT_2_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_IP_PROT_USER_IP_PROT_2_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_IP_PROT_USER_IP_PROT_2_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_IP_PROT_USER_IP_PROT_3
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_IP_PROT_USER_IP_PROT_3_FIELD =
{
    "USER_IP_PROT_3",
#if RU_INCLUDE_DESC
    "USER__IP_protocol_3",
    "User defined IP protocol 3 (value to be matched to IP protocol field)",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_IP_PROT_USER_IP_PROT_3_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_IP_PROT_USER_IP_PROT_3_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_IP_PROT_USER_IP_PROT_3_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT0_VAL_L_DA_FILT_LSB
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT0_VAL_L_DA_FILT_LSB_FIELD =
{
    "DA_FILT_LSB",
#if RU_INCLUDE_DESC
    "DA_FILT_LSB",
    "DA Filter bits 31:0",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT0_VAL_L_DA_FILT_LSB_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT0_VAL_L_DA_FILT_LSB_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT0_VAL_L_DA_FILT_LSB_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT0_VAL_H_DA_FILT_MSB
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT0_VAL_H_DA_FILT_MSB_FIELD =
{
    "DA_FILT_MSB",
#if RU_INCLUDE_DESC
    "DA_FILT_MSB",
    "Current DA Filter bits 47:32",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT0_VAL_H_DA_FILT_MSB_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT0_VAL_H_DA_FILT_MSB_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT0_VAL_H_DA_FILT_MSB_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT0_VAL_H_RESERVED0
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT0_VAL_H_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT0_VAL_H_RESERVED0_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT0_VAL_H_RESERVED0_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT0_VAL_H_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT1_VAL_L_DA_FILT_LSB
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT1_VAL_L_DA_FILT_LSB_FIELD =
{
    "DA_FILT_LSB",
#if RU_INCLUDE_DESC
    "DA_FILT_LSB",
    "DA Filter bits 31:0",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT1_VAL_L_DA_FILT_LSB_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT1_VAL_L_DA_FILT_LSB_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT1_VAL_L_DA_FILT_LSB_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT1_VAL_H_DA_FILT_MSB
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT1_VAL_H_DA_FILT_MSB_FIELD =
{
    "DA_FILT_MSB",
#if RU_INCLUDE_DESC
    "DA_FILT_MSB",
    "Current DA Filter bits 47:32",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT1_VAL_H_DA_FILT_MSB_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT1_VAL_H_DA_FILT_MSB_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT1_VAL_H_DA_FILT_MSB_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT1_VAL_H_RESERVED0
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT1_VAL_H_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT1_VAL_H_RESERVED0_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT1_VAL_H_RESERVED0_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT1_VAL_H_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT2_VAL_L_DA_FILT_LSB
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT2_VAL_L_DA_FILT_LSB_FIELD =
{
    "DA_FILT_LSB",
#if RU_INCLUDE_DESC
    "DA_FILT_LSB",
    "DA Filter bits 31:0",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT2_VAL_L_DA_FILT_LSB_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT2_VAL_L_DA_FILT_LSB_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT2_VAL_L_DA_FILT_LSB_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT2_VAL_H_DA_FILT_MSB
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT2_VAL_H_DA_FILT_MSB_FIELD =
{
    "DA_FILT_MSB",
#if RU_INCLUDE_DESC
    "DA_FILT_MSB",
    "Current DA Filter bits 47:32",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT2_VAL_H_DA_FILT_MSB_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT2_VAL_H_DA_FILT_MSB_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT2_VAL_H_DA_FILT_MSB_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT2_VAL_H_RESERVED0
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT2_VAL_H_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT2_VAL_H_RESERVED0_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT2_VAL_H_RESERVED0_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT2_VAL_H_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT3_VAL_L_DA_FILT_LSB
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT3_VAL_L_DA_FILT_LSB_FIELD =
{
    "DA_FILT_LSB",
#if RU_INCLUDE_DESC
    "DA_FILT_LSB",
    "DA Filter bits 31:0",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT3_VAL_L_DA_FILT_LSB_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT3_VAL_L_DA_FILT_LSB_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT3_VAL_L_DA_FILT_LSB_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT3_VAL_H_DA_FILT_MSB
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT3_VAL_H_DA_FILT_MSB_FIELD =
{
    "DA_FILT_MSB",
#if RU_INCLUDE_DESC
    "DA_FILT_MSB",
    "Current DA Filter bits 47:32",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT3_VAL_H_DA_FILT_MSB_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT3_VAL_H_DA_FILT_MSB_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT3_VAL_H_DA_FILT_MSB_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT3_VAL_H_RESERVED0
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT3_VAL_H_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT3_VAL_H_RESERVED0_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT3_VAL_H_RESERVED0_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT3_VAL_H_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT4_VAL_L_DA_FILT_LSB
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT4_VAL_L_DA_FILT_LSB_FIELD =
{
    "DA_FILT_LSB",
#if RU_INCLUDE_DESC
    "DA_FILT_LSB",
    "DA Filter bits 31:0",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT4_VAL_L_DA_FILT_LSB_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT4_VAL_L_DA_FILT_LSB_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT4_VAL_L_DA_FILT_LSB_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT4_VAL_H_DA_FILT_MSB
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT4_VAL_H_DA_FILT_MSB_FIELD =
{
    "DA_FILT_MSB",
#if RU_INCLUDE_DESC
    "DA_FILT_MSB",
    "Current DA Filter bits 47:32",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT4_VAL_H_DA_FILT_MSB_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT4_VAL_H_DA_FILT_MSB_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT4_VAL_H_DA_FILT_MSB_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT4_VAL_H_RESERVED0
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT4_VAL_H_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT4_VAL_H_RESERVED0_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT4_VAL_H_RESERVED0_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT4_VAL_H_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT5_VAL_L_DA_FILT_LSB
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT5_VAL_L_DA_FILT_LSB_FIELD =
{
    "DA_FILT_LSB",
#if RU_INCLUDE_DESC
    "DA_FILT_LSB",
    "DA Filter bits 31:0",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT5_VAL_L_DA_FILT_LSB_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT5_VAL_L_DA_FILT_LSB_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT5_VAL_L_DA_FILT_LSB_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT5_VAL_H_DA_FILT_MSB
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT5_VAL_H_DA_FILT_MSB_FIELD =
{
    "DA_FILT_MSB",
#if RU_INCLUDE_DESC
    "DA_FILT_MSB",
    "Current DA Filter bits 47:32",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT5_VAL_H_DA_FILT_MSB_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT5_VAL_H_DA_FILT_MSB_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT5_VAL_H_DA_FILT_MSB_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT5_VAL_H_RESERVED0
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT5_VAL_H_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT5_VAL_H_RESERVED0_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT5_VAL_H_RESERVED0_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT5_VAL_H_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT6_VAL_L_DA_FILT_LSB
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT6_VAL_L_DA_FILT_LSB_FIELD =
{
    "DA_FILT_LSB",
#if RU_INCLUDE_DESC
    "DA_FILT_LSB",
    "DA Filter bits 31:0",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT6_VAL_L_DA_FILT_LSB_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT6_VAL_L_DA_FILT_LSB_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT6_VAL_L_DA_FILT_LSB_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT6_VAL_H_DA_FILT_MSB
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT6_VAL_H_DA_FILT_MSB_FIELD =
{
    "DA_FILT_MSB",
#if RU_INCLUDE_DESC
    "DA_FILT_MSB",
    "Current DA Filter bits 47:32",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT6_VAL_H_DA_FILT_MSB_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT6_VAL_H_DA_FILT_MSB_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT6_VAL_H_DA_FILT_MSB_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT6_VAL_H_RESERVED0
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT6_VAL_H_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT6_VAL_H_RESERVED0_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT6_VAL_H_RESERVED0_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT6_VAL_H_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT7_VAL_L_DA_FILT_LSB
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT7_VAL_L_DA_FILT_LSB_FIELD =
{
    "DA_FILT_LSB",
#if RU_INCLUDE_DESC
    "DA_FILT_LSB",
    "DA Filter bits 31:0",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT7_VAL_L_DA_FILT_LSB_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT7_VAL_L_DA_FILT_LSB_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT7_VAL_L_DA_FILT_LSB_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT7_VAL_H_DA_FILT_MSB
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT7_VAL_H_DA_FILT_MSB_FIELD =
{
    "DA_FILT_MSB",
#if RU_INCLUDE_DESC
    "DA_FILT_MSB",
    "Current DA Filter bits 47:32",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT7_VAL_H_DA_FILT_MSB_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT7_VAL_H_DA_FILT_MSB_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT7_VAL_H_DA_FILT_MSB_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT7_VAL_H_RESERVED0
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT7_VAL_H_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT7_VAL_H_RESERVED0_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT7_VAL_H_RESERVED0_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT7_VAL_H_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT8_VAL_L_DA_FILT_LSB
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT8_VAL_L_DA_FILT_LSB_FIELD =
{
    "DA_FILT_LSB",
#if RU_INCLUDE_DESC
    "DA_FILT_LSB",
    "DA Filter bits 31:0",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT8_VAL_L_DA_FILT_LSB_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT8_VAL_L_DA_FILT_LSB_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT8_VAL_L_DA_FILT_LSB_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT8_VAL_H_DA_FILT_MSB
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT8_VAL_H_DA_FILT_MSB_FIELD =
{
    "DA_FILT_MSB",
#if RU_INCLUDE_DESC
    "DA_FILT_MSB",
    "Current DA Filter bits 47:32",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT8_VAL_H_DA_FILT_MSB_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT8_VAL_H_DA_FILT_MSB_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT8_VAL_H_DA_FILT_MSB_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT8_VAL_H_RESERVED0
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT8_VAL_H_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT8_VAL_H_RESERVED0_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT8_VAL_H_RESERVED0_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT8_VAL_H_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT0_MASK_L_DA_FILT_MASK_L
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT0_MASK_L_DA_FILT_MASK_L_FIELD =
{
    "DA_FILT_MASK_L",
#if RU_INCLUDE_DESC
    "DA_FILT_MASK_L",
    "Current DA Filter mask bits 31:0",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT0_MASK_L_DA_FILT_MASK_L_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT0_MASK_L_DA_FILT_MASK_L_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT0_MASK_L_DA_FILT_MASK_L_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT0_MASK_H_DA_FILT_MASK_MSB
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT0_MASK_H_DA_FILT_MASK_MSB_FIELD =
{
    "DA_FILT_MASK_MSB",
#if RU_INCLUDE_DESC
    "DA_FILT_MASK_MSB",
    "Current DA Filter mask bits 47:32",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT0_MASK_H_DA_FILT_MASK_MSB_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT0_MASK_H_DA_FILT_MASK_MSB_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT0_MASK_H_DA_FILT_MASK_MSB_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT0_MASK_H_RESERVED0
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT0_MASK_H_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT0_MASK_H_RESERVED0_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT0_MASK_H_RESERVED0_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT0_MASK_H_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT1_MASK_L_DA_FILT_MASK_L
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT1_MASK_L_DA_FILT_MASK_L_FIELD =
{
    "DA_FILT_MASK_L",
#if RU_INCLUDE_DESC
    "DA_FILT_MASK_L",
    "Current DA Filter mask bits 31:0",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT1_MASK_L_DA_FILT_MASK_L_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT1_MASK_L_DA_FILT_MASK_L_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT1_MASK_L_DA_FILT_MASK_L_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT1_MASK_H_DA_FILT_MASK_MSB
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT1_MASK_H_DA_FILT_MASK_MSB_FIELD =
{
    "DA_FILT_MASK_MSB",
#if RU_INCLUDE_DESC
    "DA_FILT_MASK_MSB",
    "Current DA Filter mask bits 47:32",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT1_MASK_H_DA_FILT_MASK_MSB_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT1_MASK_H_DA_FILT_MASK_MSB_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT1_MASK_H_DA_FILT_MASK_MSB_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT1_MASK_H_RESERVED0
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT1_MASK_H_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT1_MASK_H_RESERVED0_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT1_MASK_H_RESERVED0_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT1_MASK_H_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_0_DA_FILT0_VALID
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_0_DA_FILT0_VALID_FIELD =
{
    "DA_FILT0_VALID",
#if RU_INCLUDE_DESC
    "DA_FILT0_VALID",
    "DA Filter0 valid bit",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_0_DA_FILT0_VALID_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_0_DA_FILT0_VALID_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_0_DA_FILT0_VALID_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_0_DA_FILT1_VALID
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_0_DA_FILT1_VALID_FIELD =
{
    "DA_FILT1_VALID",
#if RU_INCLUDE_DESC
    "DA_FILT1_VALID",
    "DA Filter1 valid bit",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_0_DA_FILT1_VALID_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_0_DA_FILT1_VALID_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_0_DA_FILT1_VALID_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_0_DA_FILT2_VALID
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_0_DA_FILT2_VALID_FIELD =
{
    "DA_FILT2_VALID",
#if RU_INCLUDE_DESC
    "DA_FILT2_VALID",
    "DA Filter2 valid bit",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_0_DA_FILT2_VALID_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_0_DA_FILT2_VALID_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_0_DA_FILT2_VALID_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_0_DA_FILT3_VALID
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_0_DA_FILT3_VALID_FIELD =
{
    "DA_FILT3_VALID",
#if RU_INCLUDE_DESC
    "DA_FILT3_VALID",
    "DA Filter3 valid bit",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_0_DA_FILT3_VALID_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_0_DA_FILT3_VALID_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_0_DA_FILT3_VALID_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_0_DA_FILT4_VALID
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_0_DA_FILT4_VALID_FIELD =
{
    "DA_FILT4_VALID",
#if RU_INCLUDE_DESC
    "DA_FILT4_VALID",
    "DA Filter4 valid bit",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_0_DA_FILT4_VALID_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_0_DA_FILT4_VALID_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_0_DA_FILT4_VALID_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_0_DA_FILT5_VALID
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_0_DA_FILT5_VALID_FIELD =
{
    "DA_FILT5_VALID",
#if RU_INCLUDE_DESC
    "DA_FILT5_VALID",
    "DA Filter5 valid bit",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_0_DA_FILT5_VALID_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_0_DA_FILT5_VALID_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_0_DA_FILT5_VALID_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_0_DA_FILT6_VALID
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_0_DA_FILT6_VALID_FIELD =
{
    "DA_FILT6_VALID",
#if RU_INCLUDE_DESC
    "DA_FILT6_VALID",
    "DA Filter6 valid bit",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_0_DA_FILT6_VALID_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_0_DA_FILT6_VALID_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_0_DA_FILT6_VALID_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_0_DA_FILT7_VALID
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_0_DA_FILT7_VALID_FIELD =
{
    "DA_FILT7_VALID",
#if RU_INCLUDE_DESC
    "DA_FILT7_VALID",
    "DA Filter7 valid bit",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_0_DA_FILT7_VALID_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_0_DA_FILT7_VALID_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_0_DA_FILT7_VALID_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_0_DA_FILT8_VALID
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_0_DA_FILT8_VALID_FIELD =
{
    "DA_FILT8_VALID",
#if RU_INCLUDE_DESC
    "DA_FILT8_VALID",
    "DA Filter8 valid bit",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_0_DA_FILT8_VALID_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_0_DA_FILT8_VALID_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_0_DA_FILT8_VALID_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_0_RESERVED0
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_0_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_0_RESERVED0_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_0_RESERVED0_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_0_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_1_DA_FILT0_VALID
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_1_DA_FILT0_VALID_FIELD =
{
    "DA_FILT0_VALID",
#if RU_INCLUDE_DESC
    "DA_FILT0_VALID",
    "DA Filter0 valid bit",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_1_DA_FILT0_VALID_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_1_DA_FILT0_VALID_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_1_DA_FILT0_VALID_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_1_DA_FILT1_VALID
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_1_DA_FILT1_VALID_FIELD =
{
    "DA_FILT1_VALID",
#if RU_INCLUDE_DESC
    "DA_FILT1_VALID",
    "DA Filter1 valid bit",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_1_DA_FILT1_VALID_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_1_DA_FILT1_VALID_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_1_DA_FILT1_VALID_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_1_DA_FILT2_VALID
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_1_DA_FILT2_VALID_FIELD =
{
    "DA_FILT2_VALID",
#if RU_INCLUDE_DESC
    "DA_FILT2_VALID",
    "DA Filter2 valid bit",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_1_DA_FILT2_VALID_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_1_DA_FILT2_VALID_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_1_DA_FILT2_VALID_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_1_DA_FILT3_VALID
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_1_DA_FILT3_VALID_FIELD =
{
    "DA_FILT3_VALID",
#if RU_INCLUDE_DESC
    "DA_FILT3_VALID",
    "DA Filter3 valid bit",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_1_DA_FILT3_VALID_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_1_DA_FILT3_VALID_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_1_DA_FILT3_VALID_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_1_DA_FILT4_VALID
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_1_DA_FILT4_VALID_FIELD =
{
    "DA_FILT4_VALID",
#if RU_INCLUDE_DESC
    "DA_FILT4_VALID",
    "DA Filter4 valid bit",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_1_DA_FILT4_VALID_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_1_DA_FILT4_VALID_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_1_DA_FILT4_VALID_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_1_DA_FILT5_VALID
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_1_DA_FILT5_VALID_FIELD =
{
    "DA_FILT5_VALID",
#if RU_INCLUDE_DESC
    "DA_FILT5_VALID",
    "DA Filter5 valid bit",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_1_DA_FILT5_VALID_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_1_DA_FILT5_VALID_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_1_DA_FILT5_VALID_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_1_DA_FILT6_VALID
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_1_DA_FILT6_VALID_FIELD =
{
    "DA_FILT6_VALID",
#if RU_INCLUDE_DESC
    "DA_FILT6_VALID",
    "DA Filter6 valid bit",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_1_DA_FILT6_VALID_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_1_DA_FILT6_VALID_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_1_DA_FILT6_VALID_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_1_DA_FILT7_VALID
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_1_DA_FILT7_VALID_FIELD =
{
    "DA_FILT7_VALID",
#if RU_INCLUDE_DESC
    "DA_FILT7_VALID",
    "DA Filter7 valid bit",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_1_DA_FILT7_VALID_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_1_DA_FILT7_VALID_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_1_DA_FILT7_VALID_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_1_DA_FILT8_VALID
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_1_DA_FILT8_VALID_FIELD =
{
    "DA_FILT8_VALID",
#if RU_INCLUDE_DESC
    "DA_FILT8_VALID",
    "DA Filter8 valid bit",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_1_DA_FILT8_VALID_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_1_DA_FILT8_VALID_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_1_DA_FILT8_VALID_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_1_RESERVED0
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_1_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_1_RESERVED0_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_1_RESERVED0_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_1_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_2_DA_FILT0_VALID
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_2_DA_FILT0_VALID_FIELD =
{
    "DA_FILT0_VALID",
#if RU_INCLUDE_DESC
    "DA_FILT0_VALID",
    "DA Filter0 valid bit",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_2_DA_FILT0_VALID_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_2_DA_FILT0_VALID_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_2_DA_FILT0_VALID_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_2_DA_FILT1_VALID
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_2_DA_FILT1_VALID_FIELD =
{
    "DA_FILT1_VALID",
#if RU_INCLUDE_DESC
    "DA_FILT1_VALID",
    "DA Filter1 valid bit",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_2_DA_FILT1_VALID_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_2_DA_FILT1_VALID_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_2_DA_FILT1_VALID_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_2_DA_FILT2_VALID
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_2_DA_FILT2_VALID_FIELD =
{
    "DA_FILT2_VALID",
#if RU_INCLUDE_DESC
    "DA_FILT2_VALID",
    "DA Filter2 valid bit",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_2_DA_FILT2_VALID_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_2_DA_FILT2_VALID_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_2_DA_FILT2_VALID_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_2_DA_FILT3_VALID
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_2_DA_FILT3_VALID_FIELD =
{
    "DA_FILT3_VALID",
#if RU_INCLUDE_DESC
    "DA_FILT3_VALID",
    "DA Filter3 valid bit",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_2_DA_FILT3_VALID_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_2_DA_FILT3_VALID_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_2_DA_FILT3_VALID_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_2_DA_FILT4_VALID
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_2_DA_FILT4_VALID_FIELD =
{
    "DA_FILT4_VALID",
#if RU_INCLUDE_DESC
    "DA_FILT4_VALID",
    "DA Filter4 valid bit",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_2_DA_FILT4_VALID_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_2_DA_FILT4_VALID_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_2_DA_FILT4_VALID_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_2_DA_FILT5_VALID
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_2_DA_FILT5_VALID_FIELD =
{
    "DA_FILT5_VALID",
#if RU_INCLUDE_DESC
    "DA_FILT5_VALID",
    "DA Filter5 valid bit",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_2_DA_FILT5_VALID_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_2_DA_FILT5_VALID_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_2_DA_FILT5_VALID_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_2_DA_FILT6_VALID
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_2_DA_FILT6_VALID_FIELD =
{
    "DA_FILT6_VALID",
#if RU_INCLUDE_DESC
    "DA_FILT6_VALID",
    "DA Filter6 valid bit",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_2_DA_FILT6_VALID_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_2_DA_FILT6_VALID_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_2_DA_FILT6_VALID_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_2_DA_FILT7_VALID
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_2_DA_FILT7_VALID_FIELD =
{
    "DA_FILT7_VALID",
#if RU_INCLUDE_DESC
    "DA_FILT7_VALID",
    "DA Filter7 valid bit",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_2_DA_FILT7_VALID_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_2_DA_FILT7_VALID_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_2_DA_FILT7_VALID_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_2_DA_FILT8_VALID
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_2_DA_FILT8_VALID_FIELD =
{
    "DA_FILT8_VALID",
#if RU_INCLUDE_DESC
    "DA_FILT8_VALID",
    "DA Filter8 valid bit",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_2_DA_FILT8_VALID_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_2_DA_FILT8_VALID_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_2_DA_FILT8_VALID_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_2_RESERVED0
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_2_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_2_RESERVED0_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_2_RESERVED0_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_2_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_GRE_PROTOCOL_CFG_GRE_PROTOCOL
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_GRE_PROTOCOL_CFG_GRE_PROTOCOL_FIELD =
{
    "GRE_PROTOCOL",
#if RU_INCLUDE_DESC
    "GRE_PROTOCOL",
    "GRE_PROTOCOL",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_GRE_PROTOCOL_CFG_GRE_PROTOCOL_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_GRE_PROTOCOL_CFG_GRE_PROTOCOL_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_GRE_PROTOCOL_CFG_GRE_PROTOCOL_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_GRE_PROTOCOL_CFG_RESERVED0
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_GRE_PROTOCOL_CFG_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_GRE_PROTOCOL_CFG_RESERVED0_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_GRE_PROTOCOL_CFG_RESERVED0_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_GRE_PROTOCOL_CFG_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_PROP_TAG_CFG_SIZE_PROFILE_0
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_PROP_TAG_CFG_SIZE_PROFILE_0_FIELD =
{
    "SIZE_PROFILE_0",
#if RU_INCLUDE_DESC
    "SIZE_PROFILE_0",
    "profile 0 tag size, valid values are 0,2,4,6,8"
    "",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_PROP_TAG_CFG_SIZE_PROFILE_0_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_PROP_TAG_CFG_SIZE_PROFILE_0_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_PROP_TAG_CFG_SIZE_PROFILE_0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_PROP_TAG_CFG_SIZE_PROFILE_1
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_PROP_TAG_CFG_SIZE_PROFILE_1_FIELD =
{
    "SIZE_PROFILE_1",
#if RU_INCLUDE_DESC
    "SIZE_PROFILE_1",
    "profile 1 tag size, valid values are 0,2,4,6,8"
    "",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_PROP_TAG_CFG_SIZE_PROFILE_1_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_PROP_TAG_CFG_SIZE_PROFILE_1_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_PROP_TAG_CFG_SIZE_PROFILE_1_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_PROP_TAG_CFG_SIZE_PROFILE_2
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_PROP_TAG_CFG_SIZE_PROFILE_2_FIELD =
{
    "SIZE_PROFILE_2",
#if RU_INCLUDE_DESC
    "SIZE_PROFILE_2",
    "profile 2 tag size, valid values are 0,2,4,6,8"
    "",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_PROP_TAG_CFG_SIZE_PROFILE_2_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_PROP_TAG_CFG_SIZE_PROFILE_2_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_PROP_TAG_CFG_SIZE_PROFILE_2_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_PROP_TAG_CFG_PRE_DA_DPROFILE_0
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_PROP_TAG_CFG_PRE_DA_DPROFILE_0_FIELD =
{
    "PRE_DA_DPROFILE_0",
#if RU_INCLUDE_DESC
    "PRE_DA_DPROFILE_0",
    "Pre-DA Profile 0",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_PROP_TAG_CFG_PRE_DA_DPROFILE_0_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_PROP_TAG_CFG_PRE_DA_DPROFILE_0_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_PROP_TAG_CFG_PRE_DA_DPROFILE_0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_PROP_TAG_CFG_PRE_DA_DPROFILE_1
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_PROP_TAG_CFG_PRE_DA_DPROFILE_1_FIELD =
{
    "PRE_DA_DPROFILE_1",
#if RU_INCLUDE_DESC
    "PRE_DA_DPROFILE_1",
    "Pre-DA Profile 1",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_PROP_TAG_CFG_PRE_DA_DPROFILE_1_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_PROP_TAG_CFG_PRE_DA_DPROFILE_1_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_PROP_TAG_CFG_PRE_DA_DPROFILE_1_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_PROP_TAG_CFG_PRE_DA_DPROFILE_2
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_PROP_TAG_CFG_PRE_DA_DPROFILE_2_FIELD =
{
    "PRE_DA_DPROFILE_2",
#if RU_INCLUDE_DESC
    "PRE_DA_DPROFILE_2",
    "Pre-DA Profile 2",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_PROP_TAG_CFG_PRE_DA_DPROFILE_2_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_PROP_TAG_CFG_PRE_DA_DPROFILE_2_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_PROP_TAG_CFG_PRE_DA_DPROFILE_2_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_PROP_TAG_CFG_RESERVED0
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_PROP_TAG_CFG_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_PROP_TAG_CFG_RESERVED0_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_PROP_TAG_CFG_RESERVED0_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_PROP_TAG_CFG_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_DOS_ATTACK_MASK
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_DOS_ATTACK_MASK_FIELD =
{
    "MASK",
#if RU_INCLUDE_DESC
    "MASK",
    "mask bit per DOS Attack reason. 1 - Attack is enabled. 0 - Attack is disabled",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DOS_ATTACK_MASK_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DOS_ATTACK_MASK_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DOS_ATTACK_MASK_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_DOS_ATTACK_RESERVED0
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_DOS_ATTACK_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DOS_ATTACK_RESERVED0_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DOS_ATTACK_RESERVED0_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DOS_ATTACK_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_ICMP_MAX_SIZE_V4_SIZE
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_ICMP_MAX_SIZE_V4_SIZE_FIELD =
{
    "V4_SIZE",
#if RU_INCLUDE_DESC
    "V4",
    "Max Size for ICMPV4 packet. See DOS Attack detection details",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_ICMP_MAX_SIZE_V4_SIZE_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_ICMP_MAX_SIZE_V4_SIZE_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_ICMP_MAX_SIZE_V4_SIZE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_ICMP_MAX_SIZE_RESERVED0
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_ICMP_MAX_SIZE_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_ICMP_MAX_SIZE_RESERVED0_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_ICMP_MAX_SIZE_RESERVED0_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_ICMP_MAX_SIZE_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_ICMP_MAX_SIZE_V6_SIZE
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_ICMP_MAX_SIZE_V6_SIZE_FIELD =
{
    "V6_SIZE",
#if RU_INCLUDE_DESC
    "V6",
    "Max Size for ICMPv6 packet. See DOS Attack detection details",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_ICMP_MAX_SIZE_V6_SIZE_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_ICMP_MAX_SIZE_V6_SIZE_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_ICMP_MAX_SIZE_V6_SIZE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_ICMP_MAX_SIZE_RESERVED1
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_ICMP_MAX_SIZE_RESERVED1_FIELD =
{
    "RESERVED1",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_ICMP_MAX_SIZE_RESERVED1_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_ICMP_MAX_SIZE_RESERVED1_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_ICMP_MAX_SIZE_RESERVED1_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_KEY_CFG_L2_TOS_MASK
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_KEY_CFG_L2_TOS_MASK_FIELD =
{
    "L2_TOS_MASK",
#if RU_INCLUDE_DESC
    "L2_TOS_MASK",
    "Mask for L2 KEY TOS Field. Value is ANDed with TOS field",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_KEY_CFG_L2_TOS_MASK_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_KEY_CFG_L2_TOS_MASK_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_KEY_CFG_L2_TOS_MASK_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_KEY_CFG_L3_TOS_MASK
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_KEY_CFG_L3_TOS_MASK_FIELD =
{
    "L3_TOS_MASK",
#if RU_INCLUDE_DESC
    "L3_TOS_MASK",
    "Mask for L3 KEY TOS Field. Value is ANDed with TOS field",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_KEY_CFG_L3_TOS_MASK_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_KEY_CFG_L3_TOS_MASK_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_KEY_CFG_L3_TOS_MASK_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_KEY_CFG_L2_EXCLUDE_SMAC
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_KEY_CFG_L2_EXCLUDE_SMAC_FIELD =
{
    "L2_EXCLUDE_SMAC",
#if RU_INCLUDE_DESC
    "L2_EXCLUDE_SMAC",
    "Excludes Ethernet Source MAC from L2 Key (field will be set to 0)",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_KEY_CFG_L2_EXCLUDE_SMAC_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_KEY_CFG_L2_EXCLUDE_SMAC_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_KEY_CFG_L2_EXCLUDE_SMAC_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_KEY_CFG_TCP_PURE_ACK_MASK
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_KEY_CFG_TCP_PURE_ACK_MASK_FIELD =
{
    "TCP_PURE_ACK_MASK",
#if RU_INCLUDE_DESC
    "TCP_PURE_ACK_MASK",
    "Mask for Pure ACK field at the result.",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_KEY_CFG_TCP_PURE_ACK_MASK_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_KEY_CFG_TCP_PURE_ACK_MASK_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_KEY_CFG_TCP_PURE_ACK_MASK_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_KEY_CFG_INCUDE_DEI_IN_VLANS_CRC
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_KEY_CFG_INCUDE_DEI_IN_VLANS_CRC_FIELD =
{
    "INCUDE_DEI_IN_VLANS_CRC",
#if RU_INCLUDE_DESC
    "INCUDE_DEI_IN_VLANS_CRC",
    "Controls whether DEI bit of VLAN TAG is included or masked before CRC, if masked value of bit is 0",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_KEY_CFG_INCUDE_DEI_IN_VLANS_CRC_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_KEY_CFG_INCUDE_DEI_IN_VLANS_CRC_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_KEY_CFG_INCUDE_DEI_IN_VLANS_CRC_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_KEY_CFG_KEY_SIZE
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_KEY_CFG_KEY_SIZE_FIELD =
{
    "KEY_SIZE",
#if RU_INCLUDE_DESC
    "KEY_SIZE",
    "Selects 32 Byte or 16 Byte key result mode",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_KEY_CFG_KEY_SIZE_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_KEY_CFG_KEY_SIZE_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_KEY_CFG_KEY_SIZE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_KEY_CFG_MAX_NUM_OF_VLANS_IN_CRC
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_KEY_CFG_MAX_NUM_OF_VLANS_IN_CRC_FIELD =
{
    "MAX_NUM_OF_VLANS_IN_CRC",
#if RU_INCLUDE_DESC
    "MAX_NUM_OF_VLANS_IN_CRC",
    "Max number of VLANs in CRC",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_KEY_CFG_MAX_NUM_OF_VLANS_IN_CRC_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_KEY_CFG_MAX_NUM_OF_VLANS_IN_CRC_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_KEY_CFG_MAX_NUM_OF_VLANS_IN_CRC_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_KEY_CFG_L3_TCP_PURE_ACK_MASK
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_KEY_CFG_L3_TCP_PURE_ACK_MASK_FIELD =
{
    "L3_TCP_PURE_ACK_MASK",
#if RU_INCLUDE_DESC
    "L3_TCP_PURE_ACK_MASK",
    "Mask pure_ack at L3 Key. 1 is allow. 0 is blocked.",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_KEY_CFG_L3_TCP_PURE_ACK_MASK_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_KEY_CFG_L3_TCP_PURE_ACK_MASK_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_KEY_CFG_L3_TCP_PURE_ACK_MASK_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_PARSER_CORE_CONFIGURATION_KEY_CFG_RSRV
 ******************************************************************************/
const ru_field_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_KEY_CFG_RSRV_FIELD =
{
    "RSRV",
#if RU_INCLUDE_DESC
    "RSRVD",
    "Reserved",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_KEY_CFG_RSRV_FIELD_MASK,
    0,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_KEY_CFG_RSRV_FIELD_WIDTH,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_KEY_CFG_RSRV_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_DMA_ARB_CFG_USE_FIFO_FOR_DDR_ONLY
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_DMA_ARB_CFG_USE_FIFO_FOR_DDR_ONLY_FIELD =
{
    "USE_FIFO_FOR_DDR_ONLY",
#if RU_INCLUDE_DESC
    "USE_FIFO_FOR_DDR_ONLY",
    "Select whether to use DDR FIFO only for DDR accesses",
#endif
    RNR_QUAD_GENERAL_CONFIG_DMA_ARB_CFG_USE_FIFO_FOR_DDR_ONLY_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_DMA_ARB_CFG_USE_FIFO_FOR_DDR_ONLY_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_DMA_ARB_CFG_USE_FIFO_FOR_DDR_ONLY_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_DMA_ARB_CFG_TOKEN_ARBITER_IS_RR
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_DMA_ARB_CFG_TOKEN_ARBITER_IS_RR_FIELD =
{
    "TOKEN_ARBITER_IS_RR",
#if RU_INCLUDE_DESC
    "TOKEN_ARBITER_IS_RR",
    "Scheduling policy for token arbiter",
#endif
    RNR_QUAD_GENERAL_CONFIG_DMA_ARB_CFG_TOKEN_ARBITER_IS_RR_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_DMA_ARB_CFG_TOKEN_ARBITER_IS_RR_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_DMA_ARB_CFG_TOKEN_ARBITER_IS_RR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_DMA_ARB_CFG_CHICKEN_NO_FLOWCTRL
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_DMA_ARB_CFG_CHICKEN_NO_FLOWCTRL_FIELD =
{
    "CHICKEN_NO_FLOWCTRL",
#if RU_INCLUDE_DESC
    "CHICKEN_NO_FLOWCTRL",
    "chicken bit to disable external flow control. Packetw wil always be sent, no matter what token count says",
#endif
    RNR_QUAD_GENERAL_CONFIG_DMA_ARB_CFG_CHICKEN_NO_FLOWCTRL_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_DMA_ARB_CFG_CHICKEN_NO_FLOWCTRL_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_DMA_ARB_CFG_CHICKEN_NO_FLOWCTRL_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_DMA_ARB_CFG_FLOW_CTRL_CLEAR_TOKEN
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_DMA_ARB_CFG_FLOW_CTRL_CLEAR_TOKEN_FIELD =
{
    "FLOW_CTRL_CLEAR_TOKEN",
#if RU_INCLUDE_DESC
    "FLOW_CTRL_CLEAR_TOKEN",
    "Clear token count of external flow control block",
#endif
    RNR_QUAD_GENERAL_CONFIG_DMA_ARB_CFG_FLOW_CTRL_CLEAR_TOKEN_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_DMA_ARB_CFG_FLOW_CTRL_CLEAR_TOKEN_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_DMA_ARB_CFG_FLOW_CTRL_CLEAR_TOKEN_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_DMA_ARB_CFG_DDR_CONGEST_THRESHOLD
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_DMA_ARB_CFG_DDR_CONGEST_THRESHOLD_FIELD =
{
    "DDR_CONGEST_THRESHOLD",
#if RU_INCLUDE_DESC
    "DDR_CONGEST_THRESHOLD",
    "Set DDR congestion threshold",
#endif
    RNR_QUAD_GENERAL_CONFIG_DMA_ARB_CFG_DDR_CONGEST_THRESHOLD_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_DMA_ARB_CFG_DDR_CONGEST_THRESHOLD_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_DMA_ARB_CFG_DDR_CONGEST_THRESHOLD_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_DMA_ARB_CFG_PSRAM_CONGEST_THRESHOLD
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_DMA_ARB_CFG_PSRAM_CONGEST_THRESHOLD_FIELD =
{
    "PSRAM_CONGEST_THRESHOLD",
#if RU_INCLUDE_DESC
    "PSRAM_CONGEST_THRESHOLD",
    "Set PSRAM congestion threshold",
#endif
    RNR_QUAD_GENERAL_CONFIG_DMA_ARB_CFG_PSRAM_CONGEST_THRESHOLD_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_DMA_ARB_CFG_PSRAM_CONGEST_THRESHOLD_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_DMA_ARB_CFG_PSRAM_CONGEST_THRESHOLD_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_DMA_ARB_CFG_RESERVED0
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_DMA_ARB_CFG_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    RNR_QUAD_GENERAL_CONFIG_DMA_ARB_CFG_RESERVED0_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_DMA_ARB_CFG_RESERVED0_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_DMA_ARB_CFG_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_DMA_ARB_CFG_ENABLE_REPLY_THRESHOLD
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_DMA_ARB_CFG_ENABLE_REPLY_THRESHOLD_FIELD =
{
    "ENABLE_REPLY_THRESHOLD",
#if RU_INCLUDE_DESC
    "ENABLE_REPLY_THRESHOLD",
    "Enable reply FIFO occupancy threshold mechanism",
#endif
    RNR_QUAD_GENERAL_CONFIG_DMA_ARB_CFG_ENABLE_REPLY_THRESHOLD_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_DMA_ARB_CFG_ENABLE_REPLY_THRESHOLD_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_DMA_ARB_CFG_ENABLE_REPLY_THRESHOLD_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_DMA_ARB_CFG_DDR_REPLY_THRESHOLD
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_DMA_ARB_CFG_DDR_REPLY_THRESHOLD_FIELD =
{
    "DDR_REPLY_THRESHOLD",
#if RU_INCLUDE_DESC
    "DDR_REPLY_THRESHOLD",
    "Set max reply FIFO occupancy for DDR transactions",
#endif
    RNR_QUAD_GENERAL_CONFIG_DMA_ARB_CFG_DDR_REPLY_THRESHOLD_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_DMA_ARB_CFG_DDR_REPLY_THRESHOLD_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_DMA_ARB_CFG_DDR_REPLY_THRESHOLD_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_DMA_ARB_CFG_PSRAM_REPLY_THRESHOLD
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_DMA_ARB_CFG_PSRAM_REPLY_THRESHOLD_FIELD =
{
    "PSRAM_REPLY_THRESHOLD",
#if RU_INCLUDE_DESC
    "PSRAM_REPLY_THRESHOLD",
    "Set max reply FIFO occupancy for PSRAM transactions",
#endif
    RNR_QUAD_GENERAL_CONFIG_DMA_ARB_CFG_PSRAM_REPLY_THRESHOLD_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_DMA_ARB_CFG_PSRAM_REPLY_THRESHOLD_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_DMA_ARB_CFG_PSRAM_REPLY_THRESHOLD_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_PSRAM0_BASE_VAL
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_PSRAM0_BASE_VAL_FIELD =
{
    "VAL",
#if RU_INCLUDE_DESC
    "VAL",
    "Value for base/mask",
#endif
    RNR_QUAD_GENERAL_CONFIG_PSRAM0_BASE_VAL_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_PSRAM0_BASE_VAL_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_PSRAM0_BASE_VAL_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_PSRAM1_BASE_VAL
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_PSRAM1_BASE_VAL_FIELD =
{
    "VAL",
#if RU_INCLUDE_DESC
    "VAL",
    "Value for base/mask",
#endif
    RNR_QUAD_GENERAL_CONFIG_PSRAM1_BASE_VAL_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_PSRAM1_BASE_VAL_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_PSRAM1_BASE_VAL_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_PSRAM2_BASE_VAL
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_PSRAM2_BASE_VAL_FIELD =
{
    "VAL",
#if RU_INCLUDE_DESC
    "VAL",
    "Value for base/mask",
#endif
    RNR_QUAD_GENERAL_CONFIG_PSRAM2_BASE_VAL_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_PSRAM2_BASE_VAL_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_PSRAM2_BASE_VAL_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_PSRAM3_BASE_VAL
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_PSRAM3_BASE_VAL_FIELD =
{
    "VAL",
#if RU_INCLUDE_DESC
    "VAL",
    "Value for base/mask",
#endif
    RNR_QUAD_GENERAL_CONFIG_PSRAM3_BASE_VAL_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_PSRAM3_BASE_VAL_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_PSRAM3_BASE_VAL_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_DDR0_BASE_VAL
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_DDR0_BASE_VAL_FIELD =
{
    "VAL",
#if RU_INCLUDE_DESC
    "VAL",
    "Value for base/mask",
#endif
    RNR_QUAD_GENERAL_CONFIG_DDR0_BASE_VAL_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_DDR0_BASE_VAL_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_DDR0_BASE_VAL_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_DDR1_BASE_VAL
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_DDR1_BASE_VAL_FIELD =
{
    "VAL",
#if RU_INCLUDE_DESC
    "VAL",
    "Value for base/mask",
#endif
    RNR_QUAD_GENERAL_CONFIG_DDR1_BASE_VAL_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_DDR1_BASE_VAL_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_DDR1_BASE_VAL_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_PSRAM0_MASK_VAL
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_PSRAM0_MASK_VAL_FIELD =
{
    "VAL",
#if RU_INCLUDE_DESC
    "VAL",
    "Value for base/mask",
#endif
    RNR_QUAD_GENERAL_CONFIG_PSRAM0_MASK_VAL_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_PSRAM0_MASK_VAL_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_PSRAM0_MASK_VAL_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_PSRAM1_MASK_VAL
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_PSRAM1_MASK_VAL_FIELD =
{
    "VAL",
#if RU_INCLUDE_DESC
    "VAL",
    "Value for base/mask",
#endif
    RNR_QUAD_GENERAL_CONFIG_PSRAM1_MASK_VAL_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_PSRAM1_MASK_VAL_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_PSRAM1_MASK_VAL_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_PSRAM2_MASK_VAL
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_PSRAM2_MASK_VAL_FIELD =
{
    "VAL",
#if RU_INCLUDE_DESC
    "VAL",
    "Value for base/mask",
#endif
    RNR_QUAD_GENERAL_CONFIG_PSRAM2_MASK_VAL_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_PSRAM2_MASK_VAL_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_PSRAM2_MASK_VAL_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_PSRAM3_MASK_VAL
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_PSRAM3_MASK_VAL_FIELD =
{
    "VAL",
#if RU_INCLUDE_DESC
    "VAL",
    "Value for base/mask",
#endif
    RNR_QUAD_GENERAL_CONFIG_PSRAM3_MASK_VAL_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_PSRAM3_MASK_VAL_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_PSRAM3_MASK_VAL_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_DDR0_MASK_VAL
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_DDR0_MASK_VAL_FIELD =
{
    "VAL",
#if RU_INCLUDE_DESC
    "VAL",
    "Value for base/mask",
#endif
    RNR_QUAD_GENERAL_CONFIG_DDR0_MASK_VAL_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_DDR0_MASK_VAL_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_DDR0_MASK_VAL_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_DDR1_MASK_VAL
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_DDR1_MASK_VAL_FIELD =
{
    "VAL",
#if RU_INCLUDE_DESC
    "VAL",
    "Value for base/mask",
#endif
    RNR_QUAD_GENERAL_CONFIG_DDR1_MASK_VAL_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_DDR1_MASK_VAL_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_DDR1_MASK_VAL_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_PROFILING_CONFIG_COUNTER_LSB_SEL
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_PROFILING_CONFIG_COUNTER_LSB_SEL_FIELD =
{
    "COUNTER_LSB_SEL",
#if RU_INCLUDE_DESC
    "COUNTER_LSB_SEL",
    "Select which 12-bits from 32-bit counter value to be recorded by tracer",
#endif
    RNR_QUAD_GENERAL_CONFIG_PROFILING_CONFIG_COUNTER_LSB_SEL_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_PROFILING_CONFIG_COUNTER_LSB_SEL_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_PROFILING_CONFIG_COUNTER_LSB_SEL_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_PROFILING_CONFIG_RESERVED0
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_PROFILING_CONFIG_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    RNR_QUAD_GENERAL_CONFIG_PROFILING_CONFIG_RESERVED0_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_PROFILING_CONFIG_RESERVED0_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_PROFILING_CONFIG_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_PROFILING_CONFIG_ENABLE_TRACE_CORE_0
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_PROFILING_CONFIG_ENABLE_TRACE_CORE_0_FIELD =
{
    "ENABLE_TRACE_CORE_0",
#if RU_INCLUDE_DESC
    "ENABLE_TRACE_CORE_0",
    "Enable tracing for core 0",
#endif
    RNR_QUAD_GENERAL_CONFIG_PROFILING_CONFIG_ENABLE_TRACE_CORE_0_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_PROFILING_CONFIG_ENABLE_TRACE_CORE_0_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_PROFILING_CONFIG_ENABLE_TRACE_CORE_0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_PROFILING_CONFIG_ENABLE_TRACE_CORE_1
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_PROFILING_CONFIG_ENABLE_TRACE_CORE_1_FIELD =
{
    "ENABLE_TRACE_CORE_1",
#if RU_INCLUDE_DESC
    "ENABLE_TRACE_CORE_1",
    "Enable tracing for core 1",
#endif
    RNR_QUAD_GENERAL_CONFIG_PROFILING_CONFIG_ENABLE_TRACE_CORE_1_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_PROFILING_CONFIG_ENABLE_TRACE_CORE_1_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_PROFILING_CONFIG_ENABLE_TRACE_CORE_1_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_PROFILING_CONFIG_ENABLE_TRACE_CORE_2
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_PROFILING_CONFIG_ENABLE_TRACE_CORE_2_FIELD =
{
    "ENABLE_TRACE_CORE_2",
#if RU_INCLUDE_DESC
    "ENABLE_TRACE_CORE_2",
    "Enable tracing for core 2",
#endif
    RNR_QUAD_GENERAL_CONFIG_PROFILING_CONFIG_ENABLE_TRACE_CORE_2_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_PROFILING_CONFIG_ENABLE_TRACE_CORE_2_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_PROFILING_CONFIG_ENABLE_TRACE_CORE_2_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_PROFILING_CONFIG_ENABLE_TRACE_CORE_3
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_PROFILING_CONFIG_ENABLE_TRACE_CORE_3_FIELD =
{
    "ENABLE_TRACE_CORE_3",
#if RU_INCLUDE_DESC
    "ENABLE_TRACE_CORE_3",
    "Enable tracing for core 3",
#endif
    RNR_QUAD_GENERAL_CONFIG_PROFILING_CONFIG_ENABLE_TRACE_CORE_3_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_PROFILING_CONFIG_ENABLE_TRACE_CORE_3_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_PROFILING_CONFIG_ENABLE_TRACE_CORE_3_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_PROFILING_CONFIG_ENABLE_TRACE_CORE_4
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_PROFILING_CONFIG_ENABLE_TRACE_CORE_4_FIELD =
{
    "ENABLE_TRACE_CORE_4",
#if RU_INCLUDE_DESC
    "ENABLE_TRACE_CORE_4",
    "Enable tracing for core 4",
#endif
    RNR_QUAD_GENERAL_CONFIG_PROFILING_CONFIG_ENABLE_TRACE_CORE_4_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_PROFILING_CONFIG_ENABLE_TRACE_CORE_4_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_PROFILING_CONFIG_ENABLE_TRACE_CORE_4_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_PROFILING_CONFIG_ENABLE_TRACE_CORE_5
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_PROFILING_CONFIG_ENABLE_TRACE_CORE_5_FIELD =
{
    "ENABLE_TRACE_CORE_5",
#if RU_INCLUDE_DESC
    "ENABLE_TRACE_CORE_5",
    "Enable tracing for core 5",
#endif
    RNR_QUAD_GENERAL_CONFIG_PROFILING_CONFIG_ENABLE_TRACE_CORE_5_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_PROFILING_CONFIG_ENABLE_TRACE_CORE_5_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_PROFILING_CONFIG_ENABLE_TRACE_CORE_5_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_PROFILING_CONFIG_ENABLE_TRACE_CORE_6
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_PROFILING_CONFIG_ENABLE_TRACE_CORE_6_FIELD =
{
    "ENABLE_TRACE_CORE_6",
#if RU_INCLUDE_DESC
    "ENABLE_TRACE_CORE_6",
    "Enable tracing for core 6",
#endif
    RNR_QUAD_GENERAL_CONFIG_PROFILING_CONFIG_ENABLE_TRACE_CORE_6_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_PROFILING_CONFIG_ENABLE_TRACE_CORE_6_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_PROFILING_CONFIG_ENABLE_TRACE_CORE_6_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_PROFILING_CONFIG_ENABLE_TRACE_CORE_7
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_PROFILING_CONFIG_ENABLE_TRACE_CORE_7_FIELD =
{
    "ENABLE_TRACE_CORE_7",
#if RU_INCLUDE_DESC
    "ENABLE_TRACE_CORE_7",
    "Enable tracing for core 7",
#endif
    RNR_QUAD_GENERAL_CONFIG_PROFILING_CONFIG_ENABLE_TRACE_CORE_7_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_PROFILING_CONFIG_ENABLE_TRACE_CORE_7_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_PROFILING_CONFIG_ENABLE_TRACE_CORE_7_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_PROFILING_CONFIG_RESERVED1
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_PROFILING_CONFIG_RESERVED1_FIELD =
{
    "RESERVED1",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    RNR_QUAD_GENERAL_CONFIG_PROFILING_CONFIG_RESERVED1_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_PROFILING_CONFIG_RESERVED1_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_PROFILING_CONFIG_RESERVED1_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_BKPT_0_CFG_ADDR
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_BKPT_0_CFG_ADDR_FIELD =
{
    "ADDR",
#if RU_INCLUDE_DESC
    "ADDR",
    "Breakpoint address",
#endif
    RNR_QUAD_GENERAL_CONFIG_BKPT_0_CFG_ADDR_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_BKPT_0_CFG_ADDR_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_BKPT_0_CFG_ADDR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_BKPT_0_CFG_RESERVED0
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_BKPT_0_CFG_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    RNR_QUAD_GENERAL_CONFIG_BKPT_0_CFG_RESERVED0_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_BKPT_0_CFG_RESERVED0_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_BKPT_0_CFG_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_BKPT_0_CFG_THREAD
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_BKPT_0_CFG_THREAD_FIELD =
{
    "THREAD",
#if RU_INCLUDE_DESC
    "THREAD",
    "Breakpoint address",
#endif
    RNR_QUAD_GENERAL_CONFIG_BKPT_0_CFG_THREAD_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_BKPT_0_CFG_THREAD_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_BKPT_0_CFG_THREAD_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_BKPT_0_CFG_RESERVED1
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_BKPT_0_CFG_RESERVED1_FIELD =
{
    "RESERVED1",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    RNR_QUAD_GENERAL_CONFIG_BKPT_0_CFG_RESERVED1_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_BKPT_0_CFG_RESERVED1_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_BKPT_0_CFG_RESERVED1_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_BKPT_1_CFG_ADDR
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_BKPT_1_CFG_ADDR_FIELD =
{
    "ADDR",
#if RU_INCLUDE_DESC
    "ADDR",
    "Breakpoint address",
#endif
    RNR_QUAD_GENERAL_CONFIG_BKPT_1_CFG_ADDR_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_BKPT_1_CFG_ADDR_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_BKPT_1_CFG_ADDR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_BKPT_1_CFG_RESERVED0
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_BKPT_1_CFG_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    RNR_QUAD_GENERAL_CONFIG_BKPT_1_CFG_RESERVED0_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_BKPT_1_CFG_RESERVED0_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_BKPT_1_CFG_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_BKPT_1_CFG_THREAD
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_BKPT_1_CFG_THREAD_FIELD =
{
    "THREAD",
#if RU_INCLUDE_DESC
    "THREAD",
    "Breakpoint address",
#endif
    RNR_QUAD_GENERAL_CONFIG_BKPT_1_CFG_THREAD_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_BKPT_1_CFG_THREAD_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_BKPT_1_CFG_THREAD_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_BKPT_1_CFG_RESERVED1
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_BKPT_1_CFG_RESERVED1_FIELD =
{
    "RESERVED1",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    RNR_QUAD_GENERAL_CONFIG_BKPT_1_CFG_RESERVED1_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_BKPT_1_CFG_RESERVED1_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_BKPT_1_CFG_RESERVED1_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_BKPT_2_CFG_ADDR
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_BKPT_2_CFG_ADDR_FIELD =
{
    "ADDR",
#if RU_INCLUDE_DESC
    "ADDR",
    "Breakpoint address",
#endif
    RNR_QUAD_GENERAL_CONFIG_BKPT_2_CFG_ADDR_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_BKPT_2_CFG_ADDR_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_BKPT_2_CFG_ADDR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_BKPT_2_CFG_RESERVED0
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_BKPT_2_CFG_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    RNR_QUAD_GENERAL_CONFIG_BKPT_2_CFG_RESERVED0_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_BKPT_2_CFG_RESERVED0_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_BKPT_2_CFG_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_BKPT_2_CFG_THREAD
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_BKPT_2_CFG_THREAD_FIELD =
{
    "THREAD",
#if RU_INCLUDE_DESC
    "THREAD",
    "Breakpoint address",
#endif
    RNR_QUAD_GENERAL_CONFIG_BKPT_2_CFG_THREAD_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_BKPT_2_CFG_THREAD_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_BKPT_2_CFG_THREAD_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_BKPT_2_CFG_RESERVED1
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_BKPT_2_CFG_RESERVED1_FIELD =
{
    "RESERVED1",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    RNR_QUAD_GENERAL_CONFIG_BKPT_2_CFG_RESERVED1_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_BKPT_2_CFG_RESERVED1_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_BKPT_2_CFG_RESERVED1_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_BKPT_3_CFG_ADDR
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_BKPT_3_CFG_ADDR_FIELD =
{
    "ADDR",
#if RU_INCLUDE_DESC
    "ADDR",
    "Breakpoint address",
#endif
    RNR_QUAD_GENERAL_CONFIG_BKPT_3_CFG_ADDR_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_BKPT_3_CFG_ADDR_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_BKPT_3_CFG_ADDR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_BKPT_3_CFG_RESERVED0
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_BKPT_3_CFG_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    RNR_QUAD_GENERAL_CONFIG_BKPT_3_CFG_RESERVED0_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_BKPT_3_CFG_RESERVED0_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_BKPT_3_CFG_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_BKPT_3_CFG_THREAD
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_BKPT_3_CFG_THREAD_FIELD =
{
    "THREAD",
#if RU_INCLUDE_DESC
    "THREAD",
    "Breakpoint address",
#endif
    RNR_QUAD_GENERAL_CONFIG_BKPT_3_CFG_THREAD_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_BKPT_3_CFG_THREAD_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_BKPT_3_CFG_THREAD_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_BKPT_3_CFG_RESERVED1
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_BKPT_3_CFG_RESERVED1_FIELD =
{
    "RESERVED1",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    RNR_QUAD_GENERAL_CONFIG_BKPT_3_CFG_RESERVED1_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_BKPT_3_CFG_RESERVED1_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_BKPT_3_CFG_RESERVED1_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_BKPT_4_CFG_ADDR
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_BKPT_4_CFG_ADDR_FIELD =
{
    "ADDR",
#if RU_INCLUDE_DESC
    "ADDR",
    "Breakpoint address",
#endif
    RNR_QUAD_GENERAL_CONFIG_BKPT_4_CFG_ADDR_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_BKPT_4_CFG_ADDR_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_BKPT_4_CFG_ADDR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_BKPT_4_CFG_RESERVED0
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_BKPT_4_CFG_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    RNR_QUAD_GENERAL_CONFIG_BKPT_4_CFG_RESERVED0_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_BKPT_4_CFG_RESERVED0_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_BKPT_4_CFG_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_BKPT_4_CFG_THREAD
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_BKPT_4_CFG_THREAD_FIELD =
{
    "THREAD",
#if RU_INCLUDE_DESC
    "THREAD",
    "Breakpoint address",
#endif
    RNR_QUAD_GENERAL_CONFIG_BKPT_4_CFG_THREAD_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_BKPT_4_CFG_THREAD_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_BKPT_4_CFG_THREAD_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_BKPT_4_CFG_RESERVED1
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_BKPT_4_CFG_RESERVED1_FIELD =
{
    "RESERVED1",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    RNR_QUAD_GENERAL_CONFIG_BKPT_4_CFG_RESERVED1_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_BKPT_4_CFG_RESERVED1_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_BKPT_4_CFG_RESERVED1_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_BKPT_5_CFG_ADDR
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_BKPT_5_CFG_ADDR_FIELD =
{
    "ADDR",
#if RU_INCLUDE_DESC
    "ADDR",
    "Breakpoint address",
#endif
    RNR_QUAD_GENERAL_CONFIG_BKPT_5_CFG_ADDR_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_BKPT_5_CFG_ADDR_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_BKPT_5_CFG_ADDR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_BKPT_5_CFG_RESERVED0
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_BKPT_5_CFG_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    RNR_QUAD_GENERAL_CONFIG_BKPT_5_CFG_RESERVED0_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_BKPT_5_CFG_RESERVED0_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_BKPT_5_CFG_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_BKPT_5_CFG_THREAD
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_BKPT_5_CFG_THREAD_FIELD =
{
    "THREAD",
#if RU_INCLUDE_DESC
    "THREAD",
    "Breakpoint address",
#endif
    RNR_QUAD_GENERAL_CONFIG_BKPT_5_CFG_THREAD_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_BKPT_5_CFG_THREAD_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_BKPT_5_CFG_THREAD_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_BKPT_5_CFG_RESERVED1
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_BKPT_5_CFG_RESERVED1_FIELD =
{
    "RESERVED1",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    RNR_QUAD_GENERAL_CONFIG_BKPT_5_CFG_RESERVED1_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_BKPT_5_CFG_RESERVED1_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_BKPT_5_CFG_RESERVED1_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_BKPT_6_CFG_ADDR
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_BKPT_6_CFG_ADDR_FIELD =
{
    "ADDR",
#if RU_INCLUDE_DESC
    "ADDR",
    "Breakpoint address",
#endif
    RNR_QUAD_GENERAL_CONFIG_BKPT_6_CFG_ADDR_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_BKPT_6_CFG_ADDR_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_BKPT_6_CFG_ADDR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_BKPT_6_CFG_RESERVED0
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_BKPT_6_CFG_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    RNR_QUAD_GENERAL_CONFIG_BKPT_6_CFG_RESERVED0_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_BKPT_6_CFG_RESERVED0_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_BKPT_6_CFG_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_BKPT_6_CFG_THREAD
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_BKPT_6_CFG_THREAD_FIELD =
{
    "THREAD",
#if RU_INCLUDE_DESC
    "THREAD",
    "Breakpoint address",
#endif
    RNR_QUAD_GENERAL_CONFIG_BKPT_6_CFG_THREAD_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_BKPT_6_CFG_THREAD_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_BKPT_6_CFG_THREAD_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_BKPT_6_CFG_RESERVED1
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_BKPT_6_CFG_RESERVED1_FIELD =
{
    "RESERVED1",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    RNR_QUAD_GENERAL_CONFIG_BKPT_6_CFG_RESERVED1_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_BKPT_6_CFG_RESERVED1_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_BKPT_6_CFG_RESERVED1_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_BKPT_7_CFG_ADDR
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_BKPT_7_CFG_ADDR_FIELD =
{
    "ADDR",
#if RU_INCLUDE_DESC
    "ADDR",
    "Breakpoint address",
#endif
    RNR_QUAD_GENERAL_CONFIG_BKPT_7_CFG_ADDR_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_BKPT_7_CFG_ADDR_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_BKPT_7_CFG_ADDR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_BKPT_7_CFG_RESERVED0
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_BKPT_7_CFG_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    RNR_QUAD_GENERAL_CONFIG_BKPT_7_CFG_RESERVED0_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_BKPT_7_CFG_RESERVED0_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_BKPT_7_CFG_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_BKPT_7_CFG_THREAD
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_BKPT_7_CFG_THREAD_FIELD =
{
    "THREAD",
#if RU_INCLUDE_DESC
    "THREAD",
    "Breakpoint address",
#endif
    RNR_QUAD_GENERAL_CONFIG_BKPT_7_CFG_THREAD_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_BKPT_7_CFG_THREAD_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_BKPT_7_CFG_THREAD_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_BKPT_7_CFG_RESERVED1
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_BKPT_7_CFG_RESERVED1_FIELD =
{
    "RESERVED1",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    RNR_QUAD_GENERAL_CONFIG_BKPT_7_CFG_RESERVED1_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_BKPT_7_CFG_RESERVED1_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_BKPT_7_CFG_RESERVED1_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_BKPT_GEN_CFG_HANDLER_ADDR
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_BKPT_GEN_CFG_HANDLER_ADDR_FIELD =
{
    "HANDLER_ADDR",
#if RU_INCLUDE_DESC
    "HANDLER_ADDR",
    "Breakpoint handler routine address",
#endif
    RNR_QUAD_GENERAL_CONFIG_BKPT_GEN_CFG_HANDLER_ADDR_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_BKPT_GEN_CFG_HANDLER_ADDR_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_BKPT_GEN_CFG_HANDLER_ADDR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_BKPT_GEN_CFG_RESERVED0
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_BKPT_GEN_CFG_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    RNR_QUAD_GENERAL_CONFIG_BKPT_GEN_CFG_RESERVED0_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_BKPT_GEN_CFG_RESERVED0_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_BKPT_GEN_CFG_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_BKPT_GEN_CFG_UPDATE_PC_VALUE
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_BKPT_GEN_CFG_UPDATE_PC_VALUE_FIELD =
{
    "UPDATE_PC_VALUE",
#if RU_INCLUDE_DESC
    "UPDATE_PC_VALUE",
    "New PC to be updated by breakpoint handler routine",
#endif
    RNR_QUAD_GENERAL_CONFIG_BKPT_GEN_CFG_UPDATE_PC_VALUE_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_BKPT_GEN_CFG_UPDATE_PC_VALUE_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_BKPT_GEN_CFG_UPDATE_PC_VALUE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_BKPT_GEN_CFG_RESERVED1
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_BKPT_GEN_CFG_RESERVED1_FIELD =
{
    "RESERVED1",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    RNR_QUAD_GENERAL_CONFIG_BKPT_GEN_CFG_RESERVED1_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_BKPT_GEN_CFG_RESERVED1_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_BKPT_GEN_CFG_RESERVED1_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_POWERSAVE_CONFIG_TIME_COUNTER
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_POWERSAVE_CONFIG_TIME_COUNTER_FIELD =
{
    "TIME_COUNTER",
#if RU_INCLUDE_DESC
    "TIME_COUNTER",
    "Select how many clocks to wait in IDLE condition before enetrin powersave state",
#endif
    RNR_QUAD_GENERAL_CONFIG_POWERSAVE_CONFIG_TIME_COUNTER_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_POWERSAVE_CONFIG_TIME_COUNTER_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_POWERSAVE_CONFIG_TIME_COUNTER_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_POWERSAVE_CONFIG_ENABLE_POWERSAVE_CORE_0
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_POWERSAVE_CONFIG_ENABLE_POWERSAVE_CORE_0_FIELD =
{
    "ENABLE_POWERSAVE_CORE_0",
#if RU_INCLUDE_DESC
    "ENABLE_POWERSAVE_CORE_0",
    "Enable powersavingfor core 0",
#endif
    RNR_QUAD_GENERAL_CONFIG_POWERSAVE_CONFIG_ENABLE_POWERSAVE_CORE_0_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_POWERSAVE_CONFIG_ENABLE_POWERSAVE_CORE_0_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_POWERSAVE_CONFIG_ENABLE_POWERSAVE_CORE_0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_POWERSAVE_CONFIG_ENABLE_POWERSAVE_CORE_1
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_POWERSAVE_CONFIG_ENABLE_POWERSAVE_CORE_1_FIELD =
{
    "ENABLE_POWERSAVE_CORE_1",
#if RU_INCLUDE_DESC
    "ENABLE_POWERSAVE_CORE_1",
    "Enable powersave for core 1",
#endif
    RNR_QUAD_GENERAL_CONFIG_POWERSAVE_CONFIG_ENABLE_POWERSAVE_CORE_1_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_POWERSAVE_CONFIG_ENABLE_POWERSAVE_CORE_1_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_POWERSAVE_CONFIG_ENABLE_POWERSAVE_CORE_1_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_POWERSAVE_CONFIG_ENABLE_POWERSAVE_CORE_2
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_POWERSAVE_CONFIG_ENABLE_POWERSAVE_CORE_2_FIELD =
{
    "ENABLE_POWERSAVE_CORE_2",
#if RU_INCLUDE_DESC
    "ENABLE_POWERSAVE_CORE_2",
    "Enable powersave for core 2",
#endif
    RNR_QUAD_GENERAL_CONFIG_POWERSAVE_CONFIG_ENABLE_POWERSAVE_CORE_2_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_POWERSAVE_CONFIG_ENABLE_POWERSAVE_CORE_2_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_POWERSAVE_CONFIG_ENABLE_POWERSAVE_CORE_2_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_POWERSAVE_CONFIG_ENABLE_POWERSAVE_CORE_3
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_POWERSAVE_CONFIG_ENABLE_POWERSAVE_CORE_3_FIELD =
{
    "ENABLE_POWERSAVE_CORE_3",
#if RU_INCLUDE_DESC
    "ENABLE_POWERSAVE_CORE_3",
    "Enable powersave for core 3",
#endif
    RNR_QUAD_GENERAL_CONFIG_POWERSAVE_CONFIG_ENABLE_POWERSAVE_CORE_3_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_POWERSAVE_CONFIG_ENABLE_POWERSAVE_CORE_3_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_POWERSAVE_CONFIG_ENABLE_POWERSAVE_CORE_3_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_POWERSAVE_CONFIG_ENABLE_POWERSAVE_CORE_4
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_POWERSAVE_CONFIG_ENABLE_POWERSAVE_CORE_4_FIELD =
{
    "ENABLE_POWERSAVE_CORE_4",
#if RU_INCLUDE_DESC
    "ENABLE_POWERSAVE_CORE_4",
    "Enable powersave for core 4",
#endif
    RNR_QUAD_GENERAL_CONFIG_POWERSAVE_CONFIG_ENABLE_POWERSAVE_CORE_4_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_POWERSAVE_CONFIG_ENABLE_POWERSAVE_CORE_4_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_POWERSAVE_CONFIG_ENABLE_POWERSAVE_CORE_4_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_POWERSAVE_CONFIG_ENABLE_POWERSAVE_CORE_5
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_POWERSAVE_CONFIG_ENABLE_POWERSAVE_CORE_5_FIELD =
{
    "ENABLE_POWERSAVE_CORE_5",
#if RU_INCLUDE_DESC
    "ENABLE_POWERSAVE_CORE_5",
    "Enable powersave for core 5",
#endif
    RNR_QUAD_GENERAL_CONFIG_POWERSAVE_CONFIG_ENABLE_POWERSAVE_CORE_5_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_POWERSAVE_CONFIG_ENABLE_POWERSAVE_CORE_5_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_POWERSAVE_CONFIG_ENABLE_POWERSAVE_CORE_5_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_POWERSAVE_CONFIG_ENABLE_POWERSAVE_CORE_6
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_POWERSAVE_CONFIG_ENABLE_POWERSAVE_CORE_6_FIELD =
{
    "ENABLE_POWERSAVE_CORE_6",
#if RU_INCLUDE_DESC
    "ENABLE_POWERSAVE_CORE_6",
    "Enable powersave for core 6",
#endif
    RNR_QUAD_GENERAL_CONFIG_POWERSAVE_CONFIG_ENABLE_POWERSAVE_CORE_6_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_POWERSAVE_CONFIG_ENABLE_POWERSAVE_CORE_6_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_POWERSAVE_CONFIG_ENABLE_POWERSAVE_CORE_6_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_POWERSAVE_CONFIG_ENABLE_POWERSAVE_CORE_7
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_POWERSAVE_CONFIG_ENABLE_POWERSAVE_CORE_7_FIELD =
{
    "ENABLE_POWERSAVE_CORE_7",
#if RU_INCLUDE_DESC
    "ENABLE_POWERSAVE_CORE_7",
    "Enable powersave for core 7",
#endif
    RNR_QUAD_GENERAL_CONFIG_POWERSAVE_CONFIG_ENABLE_POWERSAVE_CORE_7_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_POWERSAVE_CONFIG_ENABLE_POWERSAVE_CORE_7_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_POWERSAVE_CONFIG_ENABLE_POWERSAVE_CORE_7_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_POWERSAVE_CONFIG_RESERVED0
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_POWERSAVE_CONFIG_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    RNR_QUAD_GENERAL_CONFIG_POWERSAVE_CONFIG_RESERVED0_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_POWERSAVE_CONFIG_RESERVED0_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_POWERSAVE_CONFIG_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_POWERSAVE_STATUS_CORE_0_STATUS
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_POWERSAVE_STATUS_CORE_0_STATUS_FIELD =
{
    "CORE_0_STATUS",
#if RU_INCLUDE_DESC
    "STATUS_CORE_0",
    "Core 0 status",
#endif
    RNR_QUAD_GENERAL_CONFIG_POWERSAVE_STATUS_CORE_0_STATUS_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_POWERSAVE_STATUS_CORE_0_STATUS_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_POWERSAVE_STATUS_CORE_0_STATUS_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_POWERSAVE_STATUS_CORE_1_STATUS
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_POWERSAVE_STATUS_CORE_1_STATUS_FIELD =
{
    "CORE_1_STATUS",
#if RU_INCLUDE_DESC
    "STATUS_CORE_1",
    "Core 0 status",
#endif
    RNR_QUAD_GENERAL_CONFIG_POWERSAVE_STATUS_CORE_1_STATUS_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_POWERSAVE_STATUS_CORE_1_STATUS_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_POWERSAVE_STATUS_CORE_1_STATUS_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_POWERSAVE_STATUS_CORE_2_STATUS
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_POWERSAVE_STATUS_CORE_2_STATUS_FIELD =
{
    "CORE_2_STATUS",
#if RU_INCLUDE_DESC
    "STATUS_CORE_2",
    "Core 2 status",
#endif
    RNR_QUAD_GENERAL_CONFIG_POWERSAVE_STATUS_CORE_2_STATUS_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_POWERSAVE_STATUS_CORE_2_STATUS_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_POWERSAVE_STATUS_CORE_2_STATUS_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_POWERSAVE_STATUS_CORE_3_STATUS
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_POWERSAVE_STATUS_CORE_3_STATUS_FIELD =
{
    "CORE_3_STATUS",
#if RU_INCLUDE_DESC
    "STATUS_CORE_3",
    "Core 3 status",
#endif
    RNR_QUAD_GENERAL_CONFIG_POWERSAVE_STATUS_CORE_3_STATUS_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_POWERSAVE_STATUS_CORE_3_STATUS_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_POWERSAVE_STATUS_CORE_3_STATUS_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_POWERSAVE_STATUS_CORE_4_STATUS
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_POWERSAVE_STATUS_CORE_4_STATUS_FIELD =
{
    "CORE_4_STATUS",
#if RU_INCLUDE_DESC
    "STATUS_CORE_4",
    "Core 4 status",
#endif
    RNR_QUAD_GENERAL_CONFIG_POWERSAVE_STATUS_CORE_4_STATUS_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_POWERSAVE_STATUS_CORE_4_STATUS_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_POWERSAVE_STATUS_CORE_4_STATUS_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_POWERSAVE_STATUS_CORE_5_STATUS
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_POWERSAVE_STATUS_CORE_5_STATUS_FIELD =
{
    "CORE_5_STATUS",
#if RU_INCLUDE_DESC
    "STATUS_CORE_5",
    "Core 5 status",
#endif
    RNR_QUAD_GENERAL_CONFIG_POWERSAVE_STATUS_CORE_5_STATUS_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_POWERSAVE_STATUS_CORE_5_STATUS_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_POWERSAVE_STATUS_CORE_5_STATUS_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_POWERSAVE_STATUS_CORE_6_STATUS
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_POWERSAVE_STATUS_CORE_6_STATUS_FIELD =
{
    "CORE_6_STATUS",
#if RU_INCLUDE_DESC
    "STATUS_CORE_6",
    "Core 6 status",
#endif
    RNR_QUAD_GENERAL_CONFIG_POWERSAVE_STATUS_CORE_6_STATUS_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_POWERSAVE_STATUS_CORE_6_STATUS_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_POWERSAVE_STATUS_CORE_6_STATUS_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_POWERSAVE_STATUS_CORE_7_STATUS
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_POWERSAVE_STATUS_CORE_7_STATUS_FIELD =
{
    "CORE_7_STATUS",
#if RU_INCLUDE_DESC
    "STATUS_CORE_7",
    "Core 7 status",
#endif
    RNR_QUAD_GENERAL_CONFIG_POWERSAVE_STATUS_CORE_7_STATUS_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_POWERSAVE_STATUS_CORE_7_STATUS_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_POWERSAVE_STATUS_CORE_7_STATUS_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_POWERSAVE_STATUS_RESERVED0
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_POWERSAVE_STATUS_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    RNR_QUAD_GENERAL_CONFIG_POWERSAVE_STATUS_RESERVED0_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_POWERSAVE_STATUS_RESERVED0_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_POWERSAVE_STATUS_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_0_CFG_DATA_ADDR_START
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_0_CFG_DATA_ADDR_START_FIELD =
{
    "DATA_ADDR_START",
#if RU_INCLUDE_DESC
    "DATA_ADDR_START",
    "Data address start. Address is physical address to 64-bit wide memory.",
#endif
    RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_0_CFG_DATA_ADDR_START_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_0_CFG_DATA_ADDR_START_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_0_CFG_DATA_ADDR_START_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_0_CFG_DATA_ADDR_STOP
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_0_CFG_DATA_ADDR_STOP_FIELD =
{
    "DATA_ADDR_STOP",
#if RU_INCLUDE_DESC
    "DATA_ADDR_STOP",
    "Data address stop. Address is physical address to 64-bit wide memory.",
#endif
    RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_0_CFG_DATA_ADDR_STOP_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_0_CFG_DATA_ADDR_STOP_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_0_CFG_DATA_ADDR_STOP_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_0_CFG_THREAD
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_0_CFG_THREAD_FIELD =
{
    "THREAD",
#if RU_INCLUDE_DESC
    "THREAD",
    "Breakpoint address",
#endif
    RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_0_CFG_THREAD_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_0_CFG_THREAD_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_0_CFG_THREAD_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_0_CFG_RESERVED0
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_0_CFG_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_0_CFG_RESERVED0_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_0_CFG_RESERVED0_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_0_CFG_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_1_CFG_DATA_ADDR_START
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_1_CFG_DATA_ADDR_START_FIELD =
{
    "DATA_ADDR_START",
#if RU_INCLUDE_DESC
    "DATA_ADDR_START",
    "Data address start. Address is physical address to 64-bit wide memory.",
#endif
    RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_1_CFG_DATA_ADDR_START_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_1_CFG_DATA_ADDR_START_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_1_CFG_DATA_ADDR_START_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_1_CFG_DATA_ADDR_STOP
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_1_CFG_DATA_ADDR_STOP_FIELD =
{
    "DATA_ADDR_STOP",
#if RU_INCLUDE_DESC
    "DATA_ADDR_STOP",
    "Data address stop. Address is physical address to 64-bit wide memory.",
#endif
    RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_1_CFG_DATA_ADDR_STOP_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_1_CFG_DATA_ADDR_STOP_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_1_CFG_DATA_ADDR_STOP_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_1_CFG_THREAD
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_1_CFG_THREAD_FIELD =
{
    "THREAD",
#if RU_INCLUDE_DESC
    "THREAD",
    "Breakpoint address",
#endif
    RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_1_CFG_THREAD_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_1_CFG_THREAD_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_1_CFG_THREAD_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_1_CFG_RESERVED0
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_1_CFG_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_1_CFG_RESERVED0_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_1_CFG_RESERVED0_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_1_CFG_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_2_CFG_DATA_ADDR_START
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_2_CFG_DATA_ADDR_START_FIELD =
{
    "DATA_ADDR_START",
#if RU_INCLUDE_DESC
    "DATA_ADDR_START",
    "Data address start. Address is physical address to 64-bit wide memory.",
#endif
    RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_2_CFG_DATA_ADDR_START_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_2_CFG_DATA_ADDR_START_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_2_CFG_DATA_ADDR_START_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_2_CFG_DATA_ADDR_STOP
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_2_CFG_DATA_ADDR_STOP_FIELD =
{
    "DATA_ADDR_STOP",
#if RU_INCLUDE_DESC
    "DATA_ADDR_STOP",
    "Data address stop. Address is physical address to 64-bit wide memory.",
#endif
    RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_2_CFG_DATA_ADDR_STOP_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_2_CFG_DATA_ADDR_STOP_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_2_CFG_DATA_ADDR_STOP_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_2_CFG_THREAD
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_2_CFG_THREAD_FIELD =
{
    "THREAD",
#if RU_INCLUDE_DESC
    "THREAD",
    "Breakpoint address",
#endif
    RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_2_CFG_THREAD_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_2_CFG_THREAD_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_2_CFG_THREAD_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_2_CFG_RESERVED0
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_2_CFG_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_2_CFG_RESERVED0_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_2_CFG_RESERVED0_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_2_CFG_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_3_CFG_DATA_ADDR_START
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_3_CFG_DATA_ADDR_START_FIELD =
{
    "DATA_ADDR_START",
#if RU_INCLUDE_DESC
    "DATA_ADDR_START",
    "Data address start. Address is physical address to 64-bit wide memory.",
#endif
    RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_3_CFG_DATA_ADDR_START_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_3_CFG_DATA_ADDR_START_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_3_CFG_DATA_ADDR_START_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_3_CFG_DATA_ADDR_STOP
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_3_CFG_DATA_ADDR_STOP_FIELD =
{
    "DATA_ADDR_STOP",
#if RU_INCLUDE_DESC
    "DATA_ADDR_STOP",
    "Data address stop. Address is physical address to 64-bit wide memory.",
#endif
    RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_3_CFG_DATA_ADDR_STOP_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_3_CFG_DATA_ADDR_STOP_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_3_CFG_DATA_ADDR_STOP_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_3_CFG_THREAD
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_3_CFG_THREAD_FIELD =
{
    "THREAD",
#if RU_INCLUDE_DESC
    "THREAD",
    "Breakpoint address",
#endif
    RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_3_CFG_THREAD_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_3_CFG_THREAD_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_3_CFG_THREAD_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_3_CFG_RESERVED0
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_3_CFG_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_3_CFG_RESERVED0_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_3_CFG_RESERVED0_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_3_CFG_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_UBUS_COUNTER_CONTROL_ENABLE_STATISTICS
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_UBUS_COUNTER_CONTROL_ENABLE_STATISTICS_FIELD =
{
    "ENABLE_STATISTICS",
#if RU_INCLUDE_DESC
    "ENABLE_STATISTICS",
    "Enable statistics",
#endif
    RNR_QUAD_GENERAL_CONFIG_UBUS_COUNTER_CONTROL_ENABLE_STATISTICS_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_UBUS_COUNTER_CONTROL_ENABLE_STATISTICS_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_UBUS_COUNTER_CONTROL_ENABLE_STATISTICS_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_UBUS_COUNTER_CONTROL_RESERVED0
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_UBUS_COUNTER_CONTROL_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    RNR_QUAD_GENERAL_CONFIG_UBUS_COUNTER_CONTROL_RESERVED0_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_UBUS_COUNTER_CONTROL_RESERVED0_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_UBUS_COUNTER_CONTROL_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_UBUS_COUNTER_CONTROL_SW_RESET
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_UBUS_COUNTER_CONTROL_SW_RESET_FIELD =
{
    "SW_RESET",
#if RU_INCLUDE_DESC
    "SW_RESET",
    "Writing 1 resets all the counters",
#endif
    RNR_QUAD_GENERAL_CONFIG_UBUS_COUNTER_CONTROL_SW_RESET_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_UBUS_COUNTER_CONTROL_SW_RESET_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_UBUS_COUNTER_CONTROL_SW_RESET_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_UBUS_COUNTER_CONTROL_RESERVED1
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_UBUS_COUNTER_CONTROL_RESERVED1_FIELD =
{
    "RESERVED1",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    RNR_QUAD_GENERAL_CONFIG_UBUS_COUNTER_CONTROL_RESERVED1_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_UBUS_COUNTER_CONTROL_RESERVED1_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_UBUS_COUNTER_CONTROL_RESERVED1_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_UBUS_COUNTER_CONTROL_DEST_PID
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_UBUS_COUNTER_CONTROL_DEST_PID_FIELD =
{
    "DEST_PID",
#if RU_INCLUDE_DESC
    "DEST_PID",
    "Destination PID,controls which destination PID transactions are counted (e.g. can be programmed either to PSRAM or DDR)"
    "",
#endif
    RNR_QUAD_GENERAL_CONFIG_UBUS_COUNTER_CONTROL_DEST_PID_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_UBUS_COUNTER_CONTROL_DEST_PID_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_UBUS_COUNTER_CONTROL_DEST_PID_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_UBUS_COUNTER_CONTROL_MASTER_SELECT
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_UBUS_COUNTER_CONTROL_MASTER_SELECT_FIELD =
{
    "MASTER_SELECT",
#if RU_INCLUDE_DESC
    "MASTER_SELECT",
    "Selects which master is measured"
    ""
    "",
#endif
    RNR_QUAD_GENERAL_CONFIG_UBUS_COUNTER_CONTROL_MASTER_SELECT_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_UBUS_COUNTER_CONTROL_MASTER_SELECT_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_UBUS_COUNTER_CONTROL_MASTER_SELECT_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_UBUS_COUNTER_CONTROL_RESERVED2
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_UBUS_COUNTER_CONTROL_RESERVED2_FIELD =
{
    "RESERVED2",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    RNR_QUAD_GENERAL_CONFIG_UBUS_COUNTER_CONTROL_RESERVED2_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_UBUS_COUNTER_CONTROL_RESERVED2_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_UBUS_COUNTER_CONTROL_RESERVED2_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_UBUS_DOWN_COUNTER_DOWNCNT_VALUE
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_UBUS_DOWN_COUNTER_DOWNCNT_VALUE_FIELD =
{
    "DOWNCNT_VALUE",
#if RU_INCLUDE_DESC
    "DOWNCNT_VALUE",
    "Set the size of the window."
    "When Statistics are enabled this counter counts down, while it is not 0 the statistics are collected - i.e below statistics are updated as long as this counter counts down."
    "",
#endif
    RNR_QUAD_GENERAL_CONFIG_UBUS_DOWN_COUNTER_DOWNCNT_VALUE_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_UBUS_DOWN_COUNTER_DOWNCNT_VALUE_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_UBUS_DOWN_COUNTER_DOWNCNT_VALUE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_UBUS_DOWN_COUNTER_RESERVED0
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_UBUS_DOWN_COUNTER_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    RNR_QUAD_GENERAL_CONFIG_UBUS_DOWN_COUNTER_RESERVED0_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_UBUS_DOWN_COUNTER_RESERVED0_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_UBUS_DOWN_COUNTER_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_ALL_XFERS_CNT_COUNTER_VALUE
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_ALL_XFERS_CNT_COUNTER_VALUE_FIELD =
{
    "COUNTER_VALUE",
#if RU_INCLUDE_DESC
    "COUNTER_VALUE",
    "Value"
    "",
#endif
    RNR_QUAD_GENERAL_CONFIG_ALL_XFERS_CNT_COUNTER_VALUE_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_ALL_XFERS_CNT_COUNTER_VALUE_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_ALL_XFERS_CNT_COUNTER_VALUE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_READ_XFERS_CNT_COUNTER_VALUE
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_READ_XFERS_CNT_COUNTER_VALUE_FIELD =
{
    "COUNTER_VALUE",
#if RU_INCLUDE_DESC
    "COUNTER_VALUE",
    "Value"
    "",
#endif
    RNR_QUAD_GENERAL_CONFIG_READ_XFERS_CNT_COUNTER_VALUE_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_READ_XFERS_CNT_COUNTER_VALUE_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_READ_XFERS_CNT_COUNTER_VALUE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_READ_DATA_CNT_COUNTER_VALUE
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_READ_DATA_CNT_COUNTER_VALUE_FIELD =
{
    "COUNTER_VALUE",
#if RU_INCLUDE_DESC
    "COUNTER_VALUE",
    "Value"
    "",
#endif
    RNR_QUAD_GENERAL_CONFIG_READ_DATA_CNT_COUNTER_VALUE_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_READ_DATA_CNT_COUNTER_VALUE_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_READ_DATA_CNT_COUNTER_VALUE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_GENERAL_CONFIG_WRITE_DATA_CNT_COUNTER_VALUE
 ******************************************************************************/
const ru_field_rec RNR_QUAD_GENERAL_CONFIG_WRITE_DATA_CNT_COUNTER_VALUE_FIELD =
{
    "COUNTER_VALUE",
#if RU_INCLUDE_DESC
    "COUNTER_VALUE",
    "Value"
    "",
#endif
    RNR_QUAD_GENERAL_CONFIG_WRITE_DATA_CNT_COUNTER_VALUE_FIELD_MASK,
    0,
    RNR_QUAD_GENERAL_CONFIG_WRITE_DATA_CNT_COUNTER_VALUE_FIELD_WIDTH,
    RNR_QUAD_GENERAL_CONFIG_WRITE_DATA_CNT_COUNTER_VALUE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_DEBUG_FIFO_CONFIG_PSRAM_HDR_SW_RST
 ******************************************************************************/
const ru_field_rec RNR_QUAD_DEBUG_FIFO_CONFIG_PSRAM_HDR_SW_RST_FIELD =
{
    "PSRAM_HDR_SW_RST",
#if RU_INCLUDE_DESC
    "PSRAM_HDR_SW_RST",
    "Apply software reset to PSRAM header FIFO in EC arbiter",
#endif
    RNR_QUAD_DEBUG_FIFO_CONFIG_PSRAM_HDR_SW_RST_FIELD_MASK,
    0,
    RNR_QUAD_DEBUG_FIFO_CONFIG_PSRAM_HDR_SW_RST_FIELD_WIDTH,
    RNR_QUAD_DEBUG_FIFO_CONFIG_PSRAM_HDR_SW_RST_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_DEBUG_FIFO_CONFIG_PSRAM_DATA_SW_RST
 ******************************************************************************/
const ru_field_rec RNR_QUAD_DEBUG_FIFO_CONFIG_PSRAM_DATA_SW_RST_FIELD =
{
    "PSRAM_DATA_SW_RST",
#if RU_INCLUDE_DESC
    "PSRAM_DATA_SW_RST",
    "Apply software reset to PSRAM data FIFO in EC arbiter",
#endif
    RNR_QUAD_DEBUG_FIFO_CONFIG_PSRAM_DATA_SW_RST_FIELD_MASK,
    0,
    RNR_QUAD_DEBUG_FIFO_CONFIG_PSRAM_DATA_SW_RST_FIELD_WIDTH,
    RNR_QUAD_DEBUG_FIFO_CONFIG_PSRAM_DATA_SW_RST_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_DEBUG_FIFO_CONFIG_DDR_HDR_SW_RST
 ******************************************************************************/
const ru_field_rec RNR_QUAD_DEBUG_FIFO_CONFIG_DDR_HDR_SW_RST_FIELD =
{
    "DDR_HDR_SW_RST",
#if RU_INCLUDE_DESC
    "DDR_HDR_SW_RST",
    "Apply software reset to DDR header FIFO in EC arbiter",
#endif
    RNR_QUAD_DEBUG_FIFO_CONFIG_DDR_HDR_SW_RST_FIELD_MASK,
    0,
    RNR_QUAD_DEBUG_FIFO_CONFIG_DDR_HDR_SW_RST_FIELD_WIDTH,
    RNR_QUAD_DEBUG_FIFO_CONFIG_DDR_HDR_SW_RST_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_DEBUG_FIFO_CONFIG_RESERVED0
 ******************************************************************************/
const ru_field_rec RNR_QUAD_DEBUG_FIFO_CONFIG_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    RNR_QUAD_DEBUG_FIFO_CONFIG_RESERVED0_FIELD_MASK,
    0,
    RNR_QUAD_DEBUG_FIFO_CONFIG_RESERVED0_FIELD_WIDTH,
    RNR_QUAD_DEBUG_FIFO_CONFIG_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_DEBUG_FIFO_CONFIG_PSRAM_HDR_SW_RD_ADDR
 ******************************************************************************/
const ru_field_rec RNR_QUAD_DEBUG_FIFO_CONFIG_PSRAM_HDR_SW_RD_ADDR_FIELD =
{
    "PSRAM_HDR_SW_RD_ADDR",
#if RU_INCLUDE_DESC
    "PSRAM_HDR_SW_RD_ADDR",
    "Software read address for PSRAM header FIFO",
#endif
    RNR_QUAD_DEBUG_FIFO_CONFIG_PSRAM_HDR_SW_RD_ADDR_FIELD_MASK,
    0,
    RNR_QUAD_DEBUG_FIFO_CONFIG_PSRAM_HDR_SW_RD_ADDR_FIELD_WIDTH,
    RNR_QUAD_DEBUG_FIFO_CONFIG_PSRAM_HDR_SW_RD_ADDR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_DEBUG_FIFO_CONFIG_PSRAM_DATA_SW_RD_ADDR
 ******************************************************************************/
const ru_field_rec RNR_QUAD_DEBUG_FIFO_CONFIG_PSRAM_DATA_SW_RD_ADDR_FIELD =
{
    "PSRAM_DATA_SW_RD_ADDR",
#if RU_INCLUDE_DESC
    "PSRAM_DATA_SW_RD_ADDR",
    "Software read address for PSRAM data FIFO",
#endif
    RNR_QUAD_DEBUG_FIFO_CONFIG_PSRAM_DATA_SW_RD_ADDR_FIELD_MASK,
    0,
    RNR_QUAD_DEBUG_FIFO_CONFIG_PSRAM_DATA_SW_RD_ADDR_FIELD_WIDTH,
    RNR_QUAD_DEBUG_FIFO_CONFIG_PSRAM_DATA_SW_RD_ADDR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_DEBUG_FIFO_CONFIG_DDR_HDR_SW_RD_ADDR
 ******************************************************************************/
const ru_field_rec RNR_QUAD_DEBUG_FIFO_CONFIG_DDR_HDR_SW_RD_ADDR_FIELD =
{
    "DDR_HDR_SW_RD_ADDR",
#if RU_INCLUDE_DESC
    "DDR_HDR_SW_RD_ADDR",
    "Software read address for DDR header FIFO",
#endif
    RNR_QUAD_DEBUG_FIFO_CONFIG_DDR_HDR_SW_RD_ADDR_FIELD_MASK,
    0,
    RNR_QUAD_DEBUG_FIFO_CONFIG_DDR_HDR_SW_RD_ADDR_FIELD_WIDTH,
    RNR_QUAD_DEBUG_FIFO_CONFIG_DDR_HDR_SW_RD_ADDR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_DEBUG_FIFO_CONFIG_RESERVED1
 ******************************************************************************/
const ru_field_rec RNR_QUAD_DEBUG_FIFO_CONFIG_RESERVED1_FIELD =
{
    "RESERVED1",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    RNR_QUAD_DEBUG_FIFO_CONFIG_RESERVED1_FIELD_MASK,
    0,
    RNR_QUAD_DEBUG_FIFO_CONFIG_RESERVED1_FIELD_WIDTH,
    RNR_QUAD_DEBUG_FIFO_CONFIG_RESERVED1_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_DEBUG_PSRAM_HDR_FIFO_STATUS_FULL
 ******************************************************************************/
const ru_field_rec RNR_QUAD_DEBUG_PSRAM_HDR_FIFO_STATUS_FULL_FIELD =
{
    "FULL",
#if RU_INCLUDE_DESC
    "FULL",
    "FIFO full indication",
#endif
    RNR_QUAD_DEBUG_PSRAM_HDR_FIFO_STATUS_FULL_FIELD_MASK,
    0,
    RNR_QUAD_DEBUG_PSRAM_HDR_FIFO_STATUS_FULL_FIELD_WIDTH,
    RNR_QUAD_DEBUG_PSRAM_HDR_FIFO_STATUS_FULL_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_DEBUG_PSRAM_HDR_FIFO_STATUS_EMPTY
 ******************************************************************************/
const ru_field_rec RNR_QUAD_DEBUG_PSRAM_HDR_FIFO_STATUS_EMPTY_FIELD =
{
    "EMPTY",
#if RU_INCLUDE_DESC
    "EMPTY",
    "FIFO empty indication",
#endif
    RNR_QUAD_DEBUG_PSRAM_HDR_FIFO_STATUS_EMPTY_FIELD_MASK,
    0,
    RNR_QUAD_DEBUG_PSRAM_HDR_FIFO_STATUS_EMPTY_FIELD_WIDTH,
    RNR_QUAD_DEBUG_PSRAM_HDR_FIFO_STATUS_EMPTY_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_DEBUG_PSRAM_HDR_FIFO_STATUS_RESERVED0
 ******************************************************************************/
const ru_field_rec RNR_QUAD_DEBUG_PSRAM_HDR_FIFO_STATUS_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    RNR_QUAD_DEBUG_PSRAM_HDR_FIFO_STATUS_RESERVED0_FIELD_MASK,
    0,
    RNR_QUAD_DEBUG_PSRAM_HDR_FIFO_STATUS_RESERVED0_FIELD_WIDTH,
    RNR_QUAD_DEBUG_PSRAM_HDR_FIFO_STATUS_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_DEBUG_PSRAM_HDR_FIFO_STATUS_PUSH_WR_CNTR
 ******************************************************************************/
const ru_field_rec RNR_QUAD_DEBUG_PSRAM_HDR_FIFO_STATUS_PUSH_WR_CNTR_FIELD =
{
    "PUSH_WR_CNTR",
#if RU_INCLUDE_DESC
    "PUSH_WR_CNTR",
    "Push write counter value",
#endif
    RNR_QUAD_DEBUG_PSRAM_HDR_FIFO_STATUS_PUSH_WR_CNTR_FIELD_MASK,
    0,
    RNR_QUAD_DEBUG_PSRAM_HDR_FIFO_STATUS_PUSH_WR_CNTR_FIELD_WIDTH,
    RNR_QUAD_DEBUG_PSRAM_HDR_FIFO_STATUS_PUSH_WR_CNTR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_DEBUG_PSRAM_HDR_FIFO_STATUS_RESERVED1
 ******************************************************************************/
const ru_field_rec RNR_QUAD_DEBUG_PSRAM_HDR_FIFO_STATUS_RESERVED1_FIELD =
{
    "RESERVED1",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    RNR_QUAD_DEBUG_PSRAM_HDR_FIFO_STATUS_RESERVED1_FIELD_MASK,
    0,
    RNR_QUAD_DEBUG_PSRAM_HDR_FIFO_STATUS_RESERVED1_FIELD_WIDTH,
    RNR_QUAD_DEBUG_PSRAM_HDR_FIFO_STATUS_RESERVED1_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_DEBUG_PSRAM_HDR_FIFO_STATUS_POP_RD_CNTR
 ******************************************************************************/
const ru_field_rec RNR_QUAD_DEBUG_PSRAM_HDR_FIFO_STATUS_POP_RD_CNTR_FIELD =
{
    "POP_RD_CNTR",
#if RU_INCLUDE_DESC
    "POP_RD_CNTR",
    "Pop read counter value",
#endif
    RNR_QUAD_DEBUG_PSRAM_HDR_FIFO_STATUS_POP_RD_CNTR_FIELD_MASK,
    0,
    RNR_QUAD_DEBUG_PSRAM_HDR_FIFO_STATUS_POP_RD_CNTR_FIELD_WIDTH,
    RNR_QUAD_DEBUG_PSRAM_HDR_FIFO_STATUS_POP_RD_CNTR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_DEBUG_PSRAM_HDR_FIFO_STATUS_RESERVED2
 ******************************************************************************/
const ru_field_rec RNR_QUAD_DEBUG_PSRAM_HDR_FIFO_STATUS_RESERVED2_FIELD =
{
    "RESERVED2",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    RNR_QUAD_DEBUG_PSRAM_HDR_FIFO_STATUS_RESERVED2_FIELD_MASK,
    0,
    RNR_QUAD_DEBUG_PSRAM_HDR_FIFO_STATUS_RESERVED2_FIELD_WIDTH,
    RNR_QUAD_DEBUG_PSRAM_HDR_FIFO_STATUS_RESERVED2_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_DEBUG_PSRAM_HDR_FIFO_STATUS_USED_WORDS
 ******************************************************************************/
const ru_field_rec RNR_QUAD_DEBUG_PSRAM_HDR_FIFO_STATUS_USED_WORDS_FIELD =
{
    "USED_WORDS",
#if RU_INCLUDE_DESC
    "USED_WORDS",
    "Used words value",
#endif
    RNR_QUAD_DEBUG_PSRAM_HDR_FIFO_STATUS_USED_WORDS_FIELD_MASK,
    0,
    RNR_QUAD_DEBUG_PSRAM_HDR_FIFO_STATUS_USED_WORDS_FIELD_WIDTH,
    RNR_QUAD_DEBUG_PSRAM_HDR_FIFO_STATUS_USED_WORDS_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_DEBUG_PSRAM_HDR_FIFO_STATUS_RESERVED3
 ******************************************************************************/
const ru_field_rec RNR_QUAD_DEBUG_PSRAM_HDR_FIFO_STATUS_RESERVED3_FIELD =
{
    "RESERVED3",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    RNR_QUAD_DEBUG_PSRAM_HDR_FIFO_STATUS_RESERVED3_FIELD_MASK,
    0,
    RNR_QUAD_DEBUG_PSRAM_HDR_FIFO_STATUS_RESERVED3_FIELD_WIDTH,
    RNR_QUAD_DEBUG_PSRAM_HDR_FIFO_STATUS_RESERVED3_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_DEBUG_PSRAM_DATA_FIFO_STATUS_FULL
 ******************************************************************************/
const ru_field_rec RNR_QUAD_DEBUG_PSRAM_DATA_FIFO_STATUS_FULL_FIELD =
{
    "FULL",
#if RU_INCLUDE_DESC
    "FULL",
    "FIFO full indication",
#endif
    RNR_QUAD_DEBUG_PSRAM_DATA_FIFO_STATUS_FULL_FIELD_MASK,
    0,
    RNR_QUAD_DEBUG_PSRAM_DATA_FIFO_STATUS_FULL_FIELD_WIDTH,
    RNR_QUAD_DEBUG_PSRAM_DATA_FIFO_STATUS_FULL_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_DEBUG_PSRAM_DATA_FIFO_STATUS_EMPTY
 ******************************************************************************/
const ru_field_rec RNR_QUAD_DEBUG_PSRAM_DATA_FIFO_STATUS_EMPTY_FIELD =
{
    "EMPTY",
#if RU_INCLUDE_DESC
    "EMPTY",
    "FIFO empty indication",
#endif
    RNR_QUAD_DEBUG_PSRAM_DATA_FIFO_STATUS_EMPTY_FIELD_MASK,
    0,
    RNR_QUAD_DEBUG_PSRAM_DATA_FIFO_STATUS_EMPTY_FIELD_WIDTH,
    RNR_QUAD_DEBUG_PSRAM_DATA_FIFO_STATUS_EMPTY_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_DEBUG_PSRAM_DATA_FIFO_STATUS_ALMOST_FULL
 ******************************************************************************/
const ru_field_rec RNR_QUAD_DEBUG_PSRAM_DATA_FIFO_STATUS_ALMOST_FULL_FIELD =
{
    "ALMOST_FULL",
#if RU_INCLUDE_DESC
    "ALMOST_FULL",
    "Almost FIFO full indication",
#endif
    RNR_QUAD_DEBUG_PSRAM_DATA_FIFO_STATUS_ALMOST_FULL_FIELD_MASK,
    0,
    RNR_QUAD_DEBUG_PSRAM_DATA_FIFO_STATUS_ALMOST_FULL_FIELD_WIDTH,
    RNR_QUAD_DEBUG_PSRAM_DATA_FIFO_STATUS_ALMOST_FULL_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_DEBUG_PSRAM_DATA_FIFO_STATUS_RESERVED0
 ******************************************************************************/
const ru_field_rec RNR_QUAD_DEBUG_PSRAM_DATA_FIFO_STATUS_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    RNR_QUAD_DEBUG_PSRAM_DATA_FIFO_STATUS_RESERVED0_FIELD_MASK,
    0,
    RNR_QUAD_DEBUG_PSRAM_DATA_FIFO_STATUS_RESERVED0_FIELD_WIDTH,
    RNR_QUAD_DEBUG_PSRAM_DATA_FIFO_STATUS_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_DEBUG_PSRAM_DATA_FIFO_STATUS_PUSH_WR_CNTR
 ******************************************************************************/
const ru_field_rec RNR_QUAD_DEBUG_PSRAM_DATA_FIFO_STATUS_PUSH_WR_CNTR_FIELD =
{
    "PUSH_WR_CNTR",
#if RU_INCLUDE_DESC
    "PUSH_WR_CNTR",
    "Push write counter value",
#endif
    RNR_QUAD_DEBUG_PSRAM_DATA_FIFO_STATUS_PUSH_WR_CNTR_FIELD_MASK,
    0,
    RNR_QUAD_DEBUG_PSRAM_DATA_FIFO_STATUS_PUSH_WR_CNTR_FIELD_WIDTH,
    RNR_QUAD_DEBUG_PSRAM_DATA_FIFO_STATUS_PUSH_WR_CNTR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_DEBUG_PSRAM_DATA_FIFO_STATUS_RESERVED1
 ******************************************************************************/
const ru_field_rec RNR_QUAD_DEBUG_PSRAM_DATA_FIFO_STATUS_RESERVED1_FIELD =
{
    "RESERVED1",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    RNR_QUAD_DEBUG_PSRAM_DATA_FIFO_STATUS_RESERVED1_FIELD_MASK,
    0,
    RNR_QUAD_DEBUG_PSRAM_DATA_FIFO_STATUS_RESERVED1_FIELD_WIDTH,
    RNR_QUAD_DEBUG_PSRAM_DATA_FIFO_STATUS_RESERVED1_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_DEBUG_PSRAM_DATA_FIFO_STATUS_POP_RD_CNTR
 ******************************************************************************/
const ru_field_rec RNR_QUAD_DEBUG_PSRAM_DATA_FIFO_STATUS_POP_RD_CNTR_FIELD =
{
    "POP_RD_CNTR",
#if RU_INCLUDE_DESC
    "POP_RD_CNTR",
    "Pop read counter value",
#endif
    RNR_QUAD_DEBUG_PSRAM_DATA_FIFO_STATUS_POP_RD_CNTR_FIELD_MASK,
    0,
    RNR_QUAD_DEBUG_PSRAM_DATA_FIFO_STATUS_POP_RD_CNTR_FIELD_WIDTH,
    RNR_QUAD_DEBUG_PSRAM_DATA_FIFO_STATUS_POP_RD_CNTR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_DEBUG_PSRAM_DATA_FIFO_STATUS_RESERVED2
 ******************************************************************************/
const ru_field_rec RNR_QUAD_DEBUG_PSRAM_DATA_FIFO_STATUS_RESERVED2_FIELD =
{
    "RESERVED2",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    RNR_QUAD_DEBUG_PSRAM_DATA_FIFO_STATUS_RESERVED2_FIELD_MASK,
    0,
    RNR_QUAD_DEBUG_PSRAM_DATA_FIFO_STATUS_RESERVED2_FIELD_WIDTH,
    RNR_QUAD_DEBUG_PSRAM_DATA_FIFO_STATUS_RESERVED2_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_DEBUG_PSRAM_DATA_FIFO_STATUS_USED_WORDS
 ******************************************************************************/
const ru_field_rec RNR_QUAD_DEBUG_PSRAM_DATA_FIFO_STATUS_USED_WORDS_FIELD =
{
    "USED_WORDS",
#if RU_INCLUDE_DESC
    "USED_WORDS",
    "Used words value",
#endif
    RNR_QUAD_DEBUG_PSRAM_DATA_FIFO_STATUS_USED_WORDS_FIELD_MASK,
    0,
    RNR_QUAD_DEBUG_PSRAM_DATA_FIFO_STATUS_USED_WORDS_FIELD_WIDTH,
    RNR_QUAD_DEBUG_PSRAM_DATA_FIFO_STATUS_USED_WORDS_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_DEBUG_PSRAM_DATA_FIFO_STATUS_RESERVED3
 ******************************************************************************/
const ru_field_rec RNR_QUAD_DEBUG_PSRAM_DATA_FIFO_STATUS_RESERVED3_FIELD =
{
    "RESERVED3",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    RNR_QUAD_DEBUG_PSRAM_DATA_FIFO_STATUS_RESERVED3_FIELD_MASK,
    0,
    RNR_QUAD_DEBUG_PSRAM_DATA_FIFO_STATUS_RESERVED3_FIELD_WIDTH,
    RNR_QUAD_DEBUG_PSRAM_DATA_FIFO_STATUS_RESERVED3_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_DEBUG_DDR_HDR_FIFO_STATUS_FULL
 ******************************************************************************/
const ru_field_rec RNR_QUAD_DEBUG_DDR_HDR_FIFO_STATUS_FULL_FIELD =
{
    "FULL",
#if RU_INCLUDE_DESC
    "FULL",
    "FIFO full indication",
#endif
    RNR_QUAD_DEBUG_DDR_HDR_FIFO_STATUS_FULL_FIELD_MASK,
    0,
    RNR_QUAD_DEBUG_DDR_HDR_FIFO_STATUS_FULL_FIELD_WIDTH,
    RNR_QUAD_DEBUG_DDR_HDR_FIFO_STATUS_FULL_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_DEBUG_DDR_HDR_FIFO_STATUS_EMPTY
 ******************************************************************************/
const ru_field_rec RNR_QUAD_DEBUG_DDR_HDR_FIFO_STATUS_EMPTY_FIELD =
{
    "EMPTY",
#if RU_INCLUDE_DESC
    "EMPTY",
    "FIFO empty indication",
#endif
    RNR_QUAD_DEBUG_DDR_HDR_FIFO_STATUS_EMPTY_FIELD_MASK,
    0,
    RNR_QUAD_DEBUG_DDR_HDR_FIFO_STATUS_EMPTY_FIELD_WIDTH,
    RNR_QUAD_DEBUG_DDR_HDR_FIFO_STATUS_EMPTY_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_DEBUG_DDR_HDR_FIFO_STATUS_RESERVED0
 ******************************************************************************/
const ru_field_rec RNR_QUAD_DEBUG_DDR_HDR_FIFO_STATUS_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    RNR_QUAD_DEBUG_DDR_HDR_FIFO_STATUS_RESERVED0_FIELD_MASK,
    0,
    RNR_QUAD_DEBUG_DDR_HDR_FIFO_STATUS_RESERVED0_FIELD_WIDTH,
    RNR_QUAD_DEBUG_DDR_HDR_FIFO_STATUS_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_DEBUG_DDR_HDR_FIFO_STATUS_PUSH_WR_CNTR
 ******************************************************************************/
const ru_field_rec RNR_QUAD_DEBUG_DDR_HDR_FIFO_STATUS_PUSH_WR_CNTR_FIELD =
{
    "PUSH_WR_CNTR",
#if RU_INCLUDE_DESC
    "PUSH_WR_CNTR",
    "Push write counter value",
#endif
    RNR_QUAD_DEBUG_DDR_HDR_FIFO_STATUS_PUSH_WR_CNTR_FIELD_MASK,
    0,
    RNR_QUAD_DEBUG_DDR_HDR_FIFO_STATUS_PUSH_WR_CNTR_FIELD_WIDTH,
    RNR_QUAD_DEBUG_DDR_HDR_FIFO_STATUS_PUSH_WR_CNTR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_DEBUG_DDR_HDR_FIFO_STATUS_RESERVED1
 ******************************************************************************/
const ru_field_rec RNR_QUAD_DEBUG_DDR_HDR_FIFO_STATUS_RESERVED1_FIELD =
{
    "RESERVED1",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    RNR_QUAD_DEBUG_DDR_HDR_FIFO_STATUS_RESERVED1_FIELD_MASK,
    0,
    RNR_QUAD_DEBUG_DDR_HDR_FIFO_STATUS_RESERVED1_FIELD_WIDTH,
    RNR_QUAD_DEBUG_DDR_HDR_FIFO_STATUS_RESERVED1_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_DEBUG_DDR_HDR_FIFO_STATUS_POP_RD_CNTR
 ******************************************************************************/
const ru_field_rec RNR_QUAD_DEBUG_DDR_HDR_FIFO_STATUS_POP_RD_CNTR_FIELD =
{
    "POP_RD_CNTR",
#if RU_INCLUDE_DESC
    "POP_RD_CNTR",
    "Pop read counter value",
#endif
    RNR_QUAD_DEBUG_DDR_HDR_FIFO_STATUS_POP_RD_CNTR_FIELD_MASK,
    0,
    RNR_QUAD_DEBUG_DDR_HDR_FIFO_STATUS_POP_RD_CNTR_FIELD_WIDTH,
    RNR_QUAD_DEBUG_DDR_HDR_FIFO_STATUS_POP_RD_CNTR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_DEBUG_DDR_HDR_FIFO_STATUS_RESERVED2
 ******************************************************************************/
const ru_field_rec RNR_QUAD_DEBUG_DDR_HDR_FIFO_STATUS_RESERVED2_FIELD =
{
    "RESERVED2",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    RNR_QUAD_DEBUG_DDR_HDR_FIFO_STATUS_RESERVED2_FIELD_MASK,
    0,
    RNR_QUAD_DEBUG_DDR_HDR_FIFO_STATUS_RESERVED2_FIELD_WIDTH,
    RNR_QUAD_DEBUG_DDR_HDR_FIFO_STATUS_RESERVED2_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_DEBUG_DDR_HDR_FIFO_STATUS_USED_WORDS
 ******************************************************************************/
const ru_field_rec RNR_QUAD_DEBUG_DDR_HDR_FIFO_STATUS_USED_WORDS_FIELD =
{
    "USED_WORDS",
#if RU_INCLUDE_DESC
    "USED_WORDS",
    "Used words value",
#endif
    RNR_QUAD_DEBUG_DDR_HDR_FIFO_STATUS_USED_WORDS_FIELD_MASK,
    0,
    RNR_QUAD_DEBUG_DDR_HDR_FIFO_STATUS_USED_WORDS_FIELD_WIDTH,
    RNR_QUAD_DEBUG_DDR_HDR_FIFO_STATUS_USED_WORDS_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_DEBUG_DDR_HDR_FIFO_STATUS_RESERVED3
 ******************************************************************************/
const ru_field_rec RNR_QUAD_DEBUG_DDR_HDR_FIFO_STATUS_RESERVED3_FIELD =
{
    "RESERVED3",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    RNR_QUAD_DEBUG_DDR_HDR_FIFO_STATUS_RESERVED3_FIELD_MASK,
    0,
    RNR_QUAD_DEBUG_DDR_HDR_FIFO_STATUS_RESERVED3_FIELD_WIDTH,
    RNR_QUAD_DEBUG_DDR_HDR_FIFO_STATUS_RESERVED3_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_DEBUG_DDR_DATA_FIFO_STATUS_FULL
 ******************************************************************************/
const ru_field_rec RNR_QUAD_DEBUG_DDR_DATA_FIFO_STATUS_FULL_FIELD =
{
    "FULL",
#if RU_INCLUDE_DESC
    "FULL",
    "FIFO full indication",
#endif
    RNR_QUAD_DEBUG_DDR_DATA_FIFO_STATUS_FULL_FIELD_MASK,
    0,
    RNR_QUAD_DEBUG_DDR_DATA_FIFO_STATUS_FULL_FIELD_WIDTH,
    RNR_QUAD_DEBUG_DDR_DATA_FIFO_STATUS_FULL_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_DEBUG_DDR_DATA_FIFO_STATUS_EMPTY
 ******************************************************************************/
const ru_field_rec RNR_QUAD_DEBUG_DDR_DATA_FIFO_STATUS_EMPTY_FIELD =
{
    "EMPTY",
#if RU_INCLUDE_DESC
    "EMPTY",
    "FIFO empty indication",
#endif
    RNR_QUAD_DEBUG_DDR_DATA_FIFO_STATUS_EMPTY_FIELD_MASK,
    0,
    RNR_QUAD_DEBUG_DDR_DATA_FIFO_STATUS_EMPTY_FIELD_WIDTH,
    RNR_QUAD_DEBUG_DDR_DATA_FIFO_STATUS_EMPTY_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_DEBUG_DDR_DATA_FIFO_STATUS_ALMOST_FULL
 ******************************************************************************/
const ru_field_rec RNR_QUAD_DEBUG_DDR_DATA_FIFO_STATUS_ALMOST_FULL_FIELD =
{
    "ALMOST_FULL",
#if RU_INCLUDE_DESC
    "ALMOST_FULL",
    "Almost FIFO full indication",
#endif
    RNR_QUAD_DEBUG_DDR_DATA_FIFO_STATUS_ALMOST_FULL_FIELD_MASK,
    0,
    RNR_QUAD_DEBUG_DDR_DATA_FIFO_STATUS_ALMOST_FULL_FIELD_WIDTH,
    RNR_QUAD_DEBUG_DDR_DATA_FIFO_STATUS_ALMOST_FULL_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_DEBUG_DDR_DATA_FIFO_STATUS_RESERVED0
 ******************************************************************************/
const ru_field_rec RNR_QUAD_DEBUG_DDR_DATA_FIFO_STATUS_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    RNR_QUAD_DEBUG_DDR_DATA_FIFO_STATUS_RESERVED0_FIELD_MASK,
    0,
    RNR_QUAD_DEBUG_DDR_DATA_FIFO_STATUS_RESERVED0_FIELD_WIDTH,
    RNR_QUAD_DEBUG_DDR_DATA_FIFO_STATUS_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_DEBUG_DDR_DATA_FIFO_STATUS_WR_CNTR
 ******************************************************************************/
const ru_field_rec RNR_QUAD_DEBUG_DDR_DATA_FIFO_STATUS_WR_CNTR_FIELD =
{
    "WR_CNTR",
#if RU_INCLUDE_DESC
    "WR_CNTR",
    "rite counter value",
#endif
    RNR_QUAD_DEBUG_DDR_DATA_FIFO_STATUS_WR_CNTR_FIELD_MASK,
    0,
    RNR_QUAD_DEBUG_DDR_DATA_FIFO_STATUS_WR_CNTR_FIELD_WIDTH,
    RNR_QUAD_DEBUG_DDR_DATA_FIFO_STATUS_WR_CNTR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_DEBUG_DDR_DATA_FIFO_STATUS_RESERVED1
 ******************************************************************************/
const ru_field_rec RNR_QUAD_DEBUG_DDR_DATA_FIFO_STATUS_RESERVED1_FIELD =
{
    "RESERVED1",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    RNR_QUAD_DEBUG_DDR_DATA_FIFO_STATUS_RESERVED1_FIELD_MASK,
    0,
    RNR_QUAD_DEBUG_DDR_DATA_FIFO_STATUS_RESERVED1_FIELD_WIDTH,
    RNR_QUAD_DEBUG_DDR_DATA_FIFO_STATUS_RESERVED1_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_DEBUG_DDR_DATA_FIFO_STATUS_RD_CNTR
 ******************************************************************************/
const ru_field_rec RNR_QUAD_DEBUG_DDR_DATA_FIFO_STATUS_RD_CNTR_FIELD =
{
    "RD_CNTR",
#if RU_INCLUDE_DESC
    "RD_CNTR",
    "Read counter value",
#endif
    RNR_QUAD_DEBUG_DDR_DATA_FIFO_STATUS_RD_CNTR_FIELD_MASK,
    0,
    RNR_QUAD_DEBUG_DDR_DATA_FIFO_STATUS_RD_CNTR_FIELD_WIDTH,
    RNR_QUAD_DEBUG_DDR_DATA_FIFO_STATUS_RD_CNTR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_DEBUG_DDR_DATA_FIFO_STATUS_RESERVED2
 ******************************************************************************/
const ru_field_rec RNR_QUAD_DEBUG_DDR_DATA_FIFO_STATUS_RESERVED2_FIELD =
{
    "RESERVED2",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    RNR_QUAD_DEBUG_DDR_DATA_FIFO_STATUS_RESERVED2_FIELD_MASK,
    0,
    RNR_QUAD_DEBUG_DDR_DATA_FIFO_STATUS_RESERVED2_FIELD_WIDTH,
    RNR_QUAD_DEBUG_DDR_DATA_FIFO_STATUS_RESERVED2_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_DEBUG_DDR_DATA_FIFO_STATUS2_READ_ADDR
 ******************************************************************************/
const ru_field_rec RNR_QUAD_DEBUG_DDR_DATA_FIFO_STATUS2_READ_ADDR_FIELD =
{
    "READ_ADDR",
#if RU_INCLUDE_DESC
    "READ_ADDR",
    "Current read address",
#endif
    RNR_QUAD_DEBUG_DDR_DATA_FIFO_STATUS2_READ_ADDR_FIELD_MASK,
    0,
    RNR_QUAD_DEBUG_DDR_DATA_FIFO_STATUS2_READ_ADDR_FIELD_WIDTH,
    RNR_QUAD_DEBUG_DDR_DATA_FIFO_STATUS2_READ_ADDR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_DEBUG_DDR_DATA_FIFO_STATUS2_USED_WORDS
 ******************************************************************************/
const ru_field_rec RNR_QUAD_DEBUG_DDR_DATA_FIFO_STATUS2_USED_WORDS_FIELD =
{
    "USED_WORDS",
#if RU_INCLUDE_DESC
    "USED_WORDS",
    "Used words",
#endif
    RNR_QUAD_DEBUG_DDR_DATA_FIFO_STATUS2_USED_WORDS_FIELD_MASK,
    0,
    RNR_QUAD_DEBUG_DDR_DATA_FIFO_STATUS2_USED_WORDS_FIELD_WIDTH,
    RNR_QUAD_DEBUG_DDR_DATA_FIFO_STATUS2_USED_WORDS_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_DEBUG_DDR_DATA_FIFO_STATUS2_RESERVED0
 ******************************************************************************/
const ru_field_rec RNR_QUAD_DEBUG_DDR_DATA_FIFO_STATUS2_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    RNR_QUAD_DEBUG_DDR_DATA_FIFO_STATUS2_RESERVED0_FIELD_MASK,
    0,
    RNR_QUAD_DEBUG_DDR_DATA_FIFO_STATUS2_RESERVED0_FIELD_WIDTH,
    RNR_QUAD_DEBUG_DDR_DATA_FIFO_STATUS2_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_DEBUG_PSRAM_HDR_FIFO_DATA1_DATA
 ******************************************************************************/
const ru_field_rec RNR_QUAD_DEBUG_PSRAM_HDR_FIFO_DATA1_DATA_FIELD =
{
    "DATA",
#if RU_INCLUDE_DESC
    "DATA",
    "Data",
#endif
    RNR_QUAD_DEBUG_PSRAM_HDR_FIFO_DATA1_DATA_FIELD_MASK,
    0,
    RNR_QUAD_DEBUG_PSRAM_HDR_FIFO_DATA1_DATA_FIELD_WIDTH,
    RNR_QUAD_DEBUG_PSRAM_HDR_FIFO_DATA1_DATA_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_DEBUG_PSRAM_HDR_FIFO_DATA2_DATA
 ******************************************************************************/
const ru_field_rec RNR_QUAD_DEBUG_PSRAM_HDR_FIFO_DATA2_DATA_FIELD =
{
    "DATA",
#if RU_INCLUDE_DESC
    "DATA",
    "Data",
#endif
    RNR_QUAD_DEBUG_PSRAM_HDR_FIFO_DATA2_DATA_FIELD_MASK,
    0,
    RNR_QUAD_DEBUG_PSRAM_HDR_FIFO_DATA2_DATA_FIELD_WIDTH,
    RNR_QUAD_DEBUG_PSRAM_HDR_FIFO_DATA2_DATA_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_DEBUG_PSRAM_DATA_FIFO_DATA1_DATA
 ******************************************************************************/
const ru_field_rec RNR_QUAD_DEBUG_PSRAM_DATA_FIFO_DATA1_DATA_FIELD =
{
    "DATA",
#if RU_INCLUDE_DESC
    "DATA",
    "Data",
#endif
    RNR_QUAD_DEBUG_PSRAM_DATA_FIFO_DATA1_DATA_FIELD_MASK,
    0,
    RNR_QUAD_DEBUG_PSRAM_DATA_FIFO_DATA1_DATA_FIELD_WIDTH,
    RNR_QUAD_DEBUG_PSRAM_DATA_FIFO_DATA1_DATA_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_DEBUG_PSRAM_DATA_FIFO_DATA2_DATA
 ******************************************************************************/
const ru_field_rec RNR_QUAD_DEBUG_PSRAM_DATA_FIFO_DATA2_DATA_FIELD =
{
    "DATA",
#if RU_INCLUDE_DESC
    "DATA",
    "Data",
#endif
    RNR_QUAD_DEBUG_PSRAM_DATA_FIFO_DATA2_DATA_FIELD_MASK,
    0,
    RNR_QUAD_DEBUG_PSRAM_DATA_FIFO_DATA2_DATA_FIELD_WIDTH,
    RNR_QUAD_DEBUG_PSRAM_DATA_FIFO_DATA2_DATA_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_DEBUG_DDR_HDR_FIFO_DATA1_DATA
 ******************************************************************************/
const ru_field_rec RNR_QUAD_DEBUG_DDR_HDR_FIFO_DATA1_DATA_FIELD =
{
    "DATA",
#if RU_INCLUDE_DESC
    "DATA",
    "Data",
#endif
    RNR_QUAD_DEBUG_DDR_HDR_FIFO_DATA1_DATA_FIELD_MASK,
    0,
    RNR_QUAD_DEBUG_DDR_HDR_FIFO_DATA1_DATA_FIELD_WIDTH,
    RNR_QUAD_DEBUG_DDR_HDR_FIFO_DATA1_DATA_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_DEBUG_DDR_HDR_FIFO_DATA2_DATA
 ******************************************************************************/
const ru_field_rec RNR_QUAD_DEBUG_DDR_HDR_FIFO_DATA2_DATA_FIELD =
{
    "DATA",
#if RU_INCLUDE_DESC
    "DATA",
    "Data",
#endif
    RNR_QUAD_DEBUG_DDR_HDR_FIFO_DATA2_DATA_FIELD_MASK,
    0,
    RNR_QUAD_DEBUG_DDR_HDR_FIFO_DATA2_DATA_FIELD_WIDTH,
    RNR_QUAD_DEBUG_DDR_HDR_FIFO_DATA2_DATA_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_EXT_FLOWCTRL_CONFIG_TOKEN_VAL_VAL
 ******************************************************************************/
const ru_field_rec RNR_QUAD_EXT_FLOWCTRL_CONFIG_TOKEN_VAL_VAL_FIELD =
{
    "VAL",
#if RU_INCLUDE_DESC
    "VAL",
    "Value",
#endif
    RNR_QUAD_EXT_FLOWCTRL_CONFIG_TOKEN_VAL_VAL_FIELD_MASK,
    0,
    RNR_QUAD_EXT_FLOWCTRL_CONFIG_TOKEN_VAL_VAL_FIELD_WIDTH,
    RNR_QUAD_EXT_FLOWCTRL_CONFIG_TOKEN_VAL_VAL_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_EXT_FLOWCTRL_CONFIG2_TOKEN_VAL_2_VAL
 ******************************************************************************/
const ru_field_rec RNR_QUAD_EXT_FLOWCTRL_CONFIG2_TOKEN_VAL_2_VAL_FIELD =
{
    "VAL",
#if RU_INCLUDE_DESC
    "VAL",
    "Value",
#endif
    RNR_QUAD_EXT_FLOWCTRL_CONFIG2_TOKEN_VAL_2_VAL_FIELD_MASK,
    0,
    RNR_QUAD_EXT_FLOWCTRL_CONFIG2_TOKEN_VAL_2_VAL_FIELD_WIDTH,
    RNR_QUAD_EXT_FLOWCTRL_CONFIG2_TOKEN_VAL_2_VAL_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_UBUS_DECODE_CFG_PSRAM_UBUS_DECODE_VAL
 ******************************************************************************/
const ru_field_rec RNR_QUAD_UBUS_DECODE_CFG_PSRAM_UBUS_DECODE_VAL_FIELD =
{
    "VAL",
#if RU_INCLUDE_DESC
    "VAL",
    "Value",
#endif
    RNR_QUAD_UBUS_DECODE_CFG_PSRAM_UBUS_DECODE_VAL_FIELD_MASK,
    0,
    RNR_QUAD_UBUS_DECODE_CFG_PSRAM_UBUS_DECODE_VAL_FIELD_WIDTH,
    RNR_QUAD_UBUS_DECODE_CFG_PSRAM_UBUS_DECODE_VAL_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_UBUS_DECODE_CFG_DDR_UBUS_DECODE_VAL
 ******************************************************************************/
const ru_field_rec RNR_QUAD_UBUS_DECODE_CFG_DDR_UBUS_DECODE_VAL_FIELD =
{
    "VAL",
#if RU_INCLUDE_DESC
    "VAL",
    "Value",
#endif
    RNR_QUAD_UBUS_DECODE_CFG_DDR_UBUS_DECODE_VAL_FIELD_MASK,
    0,
    RNR_QUAD_UBUS_DECODE_CFG_DDR_UBUS_DECODE_VAL_FIELD_WIDTH,
    RNR_QUAD_UBUS_DECODE_CFG_DDR_UBUS_DECODE_VAL_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_UBUS_DECODE_CFG2_PSRAM_UBUS_DECODE2_VAL
 ******************************************************************************/
const ru_field_rec RNR_QUAD_UBUS_DECODE_CFG2_PSRAM_UBUS_DECODE2_VAL_FIELD =
{
    "VAL",
#if RU_INCLUDE_DESC
    "VAL",
    "Value",
#endif
    RNR_QUAD_UBUS_DECODE_CFG2_PSRAM_UBUS_DECODE2_VAL_FIELD_MASK,
    0,
    RNR_QUAD_UBUS_DECODE_CFG2_PSRAM_UBUS_DECODE2_VAL_FIELD_WIDTH,
    RNR_QUAD_UBUS_DECODE_CFG2_PSRAM_UBUS_DECODE2_VAL_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: RNR_QUAD_UBUS_DECODE_CFG2_DDR_UBUS_DECODE2_VAL
 ******************************************************************************/
const ru_field_rec RNR_QUAD_UBUS_DECODE_CFG2_DDR_UBUS_DECODE2_VAL_FIELD =
{
    "VAL",
#if RU_INCLUDE_DESC
    "VAL",
    "Value",
#endif
    RNR_QUAD_UBUS_DECODE_CFG2_DDR_UBUS_DECODE2_VAL_FIELD_MASK,
    0,
    RNR_QUAD_UBUS_DECODE_CFG2_DDR_UBUS_DECODE2_VAL_FIELD_WIDTH,
    RNR_QUAD_UBUS_DECODE_CFG2_DDR_UBUS_DECODE2_VAL_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

#endif /* RU_INCLUDE_FIELD_DB */

/******************************************************************************
 * Register: RNR_QUAD_PARSER_CORE_CONFIGURATION_ENG
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_QUAD_PARSER_CORE_CONFIGURATION_ENG_FIELDS[] =
{
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_ENG_CFG_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_ENG_REG = 
{
    "PARSER_CORE_CONFIGURATION_ENG",
#if RU_INCLUDE_DESC
    "ENG Register",
    "Engineering Configuration reserved for Broadcom use",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_ENG_REG_OFFSET,
    0,
    0,
    283,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_ENG_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_QUAD_PARSER_CORE_CONFIGURATION_PARSER_MISC_CFG
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_QUAD_PARSER_CORE_CONFIGURATION_PARSER_MISC_CFG_FIELDS[] =
{
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_PARSER_MISC_CFG_EXCEPTION_EN_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_PARSER_MISC_CFG_PROFILE_US_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_PARSER_MISC_CFG_DISABLE_L2TP_SOURCE_PORT_CHECK_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_PARSER_MISC_CFG_TCP_FLAGS_FILT_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_PARSER_MISC_CFG_REG = 
{
    "PARSER_CORE_CONFIGURATION_PARSER_MISC_CFG",
#if RU_INCLUDE_DESC
    "PARSER_MISC_CFG Register",
    "Parser Miscellaneous Configuration",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_PARSER_MISC_CFG_REG_OFFSET,
    0,
    0,
    284,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    4,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_PARSER_MISC_CFG_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_0_1
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_0_1_FIELDS[] =
{
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_0_1_VID_0_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_0_1_RESERVED0_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_0_1_VID_0_EN_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_0_1_VID_1_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_0_1_RESERVED1_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_0_1_VID_1_EN_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_0_1_REG = 
{
    "PARSER_CORE_CONFIGURATION_VID_0_1",
#if RU_INCLUDE_DESC
    "VID_CONFIGURATION_0_1 Register",
    "Config VID Filter 0 & 1",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_0_1_REG_OFFSET,
    0,
    0,
    285,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    6,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_0_1_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_2_3
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_2_3_FIELDS[] =
{
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_2_3_VID_2_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_2_3_RESERVED0_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_2_3_VID_2_EN_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_2_3_VID_3_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_2_3_RESERVED1_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_2_3_VID_3_EN_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_2_3_REG = 
{
    "PARSER_CORE_CONFIGURATION_VID_2_3",
#if RU_INCLUDE_DESC
    "VID_CONFIGURATION_2_3 Register",
    "Config VID Filter 2 & 3",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_2_3_REG_OFFSET,
    0,
    0,
    286,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    6,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_2_3_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_4_5
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_4_5_FIELDS[] =
{
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_4_5_VID_4_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_4_5_RESERVED0_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_4_5_VID_4_EN_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_4_5_VID_5_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_4_5_RESERVED1_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_4_5_VID_5_EN_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_4_5_REG = 
{
    "PARSER_CORE_CONFIGURATION_VID_4_5",
#if RU_INCLUDE_DESC
    "VID_CONFIGURATION_4_5 Register",
    "Config VID Filter 4 & 5",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_4_5_REG_OFFSET,
    0,
    0,
    287,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    6,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_4_5_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_6_7
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_6_7_FIELDS[] =
{
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_6_7_VID_6_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_6_7_RESERVED0_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_6_7_VID_6_EN_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_6_7_VID_7_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_6_7_RESERVED1_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_6_7_VID_7_EN_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_6_7_REG = 
{
    "PARSER_CORE_CONFIGURATION_VID_6_7",
#if RU_INCLUDE_DESC
    "VID_CONFIGURATION_6_7 Register",
    "Config VID Filter 6 & 7",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_6_7_REG_OFFSET,
    0,
    0,
    288,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    6,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_6_7_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_QUAD_PARSER_CORE_CONFIGURATION_IP_FILTER0_CFG
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_QUAD_PARSER_CORE_CONFIGURATION_IP_FILTER0_CFG_FIELDS[] =
{
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_IP_FILTER0_CFG_IP_ADDRESS_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_IP_FILTER0_CFG_REG = 
{
    "PARSER_CORE_CONFIGURATION_IP_FILTER0_CFG",
#if RU_INCLUDE_DESC
    "IP_FILTER0_CFG Register",
    "Config the IP Address filtering."
    "Notice that the enable bit is located in the IP_FILTERS_CFG[4]",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_IP_FILTER0_CFG_REG_OFFSET,
    0,
    0,
    289,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_IP_FILTER0_CFG_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_QUAD_PARSER_CORE_CONFIGURATION_IP_FILTER1_CFG
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_QUAD_PARSER_CORE_CONFIGURATION_IP_FILTER1_CFG_FIELDS[] =
{
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_IP_FILTER1_CFG_IP_ADDRESS_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_IP_FILTER1_CFG_REG = 
{
    "PARSER_CORE_CONFIGURATION_IP_FILTER1_CFG",
#if RU_INCLUDE_DESC
    "IP_FILTER1_CFG Register",
    "Config the IP Address filtering."
    "Notice that the enable bit is located in the IP_FILTERS_CFG[5]",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_IP_FILTER1_CFG_REG_OFFSET,
    0,
    0,
    290,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_IP_FILTER1_CFG_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_QUAD_PARSER_CORE_CONFIGURATION_IP_FILTER0_MASK_CFG
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_QUAD_PARSER_CORE_CONFIGURATION_IP_FILTER0_MASK_CFG_FIELDS[] =
{
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_IP_FILTER0_MASK_CFG_IP_ADDRESS_MASK_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_IP_FILTER0_MASK_CFG_REG = 
{
    "PARSER_CORE_CONFIGURATION_IP_FILTER0_MASK_CFG",
#if RU_INCLUDE_DESC
    "IP_FILTER0_MASK_CFG Register",
    "Config the IP Address masking."
    "Notice that the enable bit is located in the IP_FILTERS_CFG[4]",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_IP_FILTER0_MASK_CFG_REG_OFFSET,
    0,
    0,
    291,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_IP_FILTER0_MASK_CFG_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_QUAD_PARSER_CORE_CONFIGURATION_IP_FILTER1_MASK_CFG
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_QUAD_PARSER_CORE_CONFIGURATION_IP_FILTER1_MASK_CFG_FIELDS[] =
{
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_IP_FILTER1_MASK_CFG_IP_ADDRESS_MASK_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_IP_FILTER1_MASK_CFG_REG = 
{
    "PARSER_CORE_CONFIGURATION_IP_FILTER1_MASK_CFG",
#if RU_INCLUDE_DESC
    "IP_FILTER1_MASK_CFG Register",
    "Config the IP Address masking."
    "Notice that the enable bit is located in the IP_FILTERS_CFG[5]",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_IP_FILTER1_MASK_CFG_REG_OFFSET,
    0,
    0,
    292,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_IP_FILTER1_MASK_CFG_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_QUAD_PARSER_CORE_CONFIGURATION_IP_FILTERS_CFG
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_QUAD_PARSER_CORE_CONFIGURATION_IP_FILTERS_CFG_FIELDS[] =
{
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_IP_FILTERS_CFG_IP_FILTER0_DIP_EN_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_IP_FILTERS_CFG_IP_FILTER1_DIP_EN_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_IP_FILTERS_CFG_IP_FILTER2_DIP_EN_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_IP_FILTERS_CFG_IP_FILTER3_DIP_EN_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_IP_FILTERS_CFG_IP_FILTER0_VALID_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_IP_FILTERS_CFG_IP_FILTER1_VALID_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_IP_FILTERS_CFG_IP_FILTER2_VALID_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_IP_FILTERS_CFG_IP_FILTER3_VALID_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_IP_FILTERS_CFG_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_IP_FILTERS_CFG_REG = 
{
    "PARSER_CORE_CONFIGURATION_IP_FILTERS_CFG",
#if RU_INCLUDE_DESC
    "IP_FILTERS_CFG Register",
    "IP Address Filters (0..3) configurations:"
    ""
    "(1) SIP or DIP selection config per each filter"
    "(1) Valid bit per each filter",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_IP_FILTERS_CFG_REG_OFFSET,
    0,
    0,
    293,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    9,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_IP_FILTERS_CFG_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_QUAD_PARSER_CORE_CONFIGURATION_SNAP_ORG_CODE
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_QUAD_PARSER_CORE_CONFIGURATION_SNAP_ORG_CODE_FIELDS[] =
{
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_SNAP_ORG_CODE_CODE_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_SNAP_ORG_CODE_EN_RFC1042_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_SNAP_ORG_CODE_EN_8021Q_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_SNAP_ORG_CODE_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_SNAP_ORG_CODE_REG = 
{
    "PARSER_CORE_CONFIGURATION_SNAP_ORG_CODE",
#if RU_INCLUDE_DESC
    "SNAP_ORGANIZATION_CODE Register",
    "Identifies SNAP tunneling organization code",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_SNAP_ORG_CODE_REG_OFFSET,
    0,
    0,
    294,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    4,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_SNAP_ORG_CODE_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_QUAD_PARSER_CORE_CONFIGURATION_PPP_IP_PROT_CODE
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_QUAD_PARSER_CORE_CONFIGURATION_PPP_IP_PROT_CODE_FIELDS[] =
{
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_PPP_IP_PROT_CODE_PPP_CODE_0_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_PPP_IP_PROT_CODE_PPP_CODE_1_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_PPP_IP_PROT_CODE_REG = 
{
    "PARSER_CORE_CONFIGURATION_PPP_IP_PROT_CODE",
#if RU_INCLUDE_DESC
    "PPP_IP_PROTOCOL_CODE Register",
    "PPP Protocol Code to indicate L3 is IP",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_PPP_IP_PROT_CODE_REG_OFFSET,
    0,
    0,
    295,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    2,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_PPP_IP_PROT_CODE_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_ETHTYPE
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_ETHTYPE_FIELDS[] =
{
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_ETHTYPE_ETHTYPE_QTAG_0_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_ETHTYPE_ETHTYPE_QTAG_1_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_ETHTYPE_REG = 
{
    "PARSER_CORE_CONFIGURATION_QTAG_ETHTYPE",
#if RU_INCLUDE_DESC
    "QTAG_ETHERTYPE Register",
    "Ethertype values to identify the presence of VLAN QTAG",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_ETHTYPE_REG_OFFSET,
    0,
    0,
    296,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    2,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_ETHTYPE_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_0_1
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_0_1_FIELDS[] =
{
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_0_1_ETHYPE_0_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_0_1_ETHYPE_1_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_0_1_REG = 
{
    "PARSER_CORE_CONFIGURATION_USER_ETHTYPE_0_1",
#if RU_INCLUDE_DESC
    "USER_ETHERTYPE_CONFIGURTION_0_1 Register",
    "Configures user Ethertype values",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_0_1_REG_OFFSET,
    0,
    0,
    297,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    2,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_0_1_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_2_3
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_2_3_FIELDS[] =
{
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_2_3_ETHYPE_2_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_2_3_ETHYPE_3_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_2_3_REG = 
{
    "PARSER_CORE_CONFIGURATION_USER_ETHTYPE_2_3",
#if RU_INCLUDE_DESC
    "USER_ETHERTYPE_CONFIGURTION_2_3 Register",
    "Configures user Ethertype values",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_2_3_REG_OFFSET,
    0,
    0,
    298,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    2,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_2_3_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_CONFIG
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_CONFIG_FIELDS[] =
{
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_CONFIG_ETHTYPE_USER_PROT_0_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_CONFIG_ETHTYPE_USER_PROT_1_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_CONFIG_ETHTYPE_USER_PROT_2_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_CONFIG_ETHTYPE_USER_PROT_3_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_CONFIG_ETHTYPE_USER_EN_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_CONFIG_RESERVED0_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_CONFIG_ETHTYPE_USER_OFFSET_0_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_CONFIG_ETHTYPE_USER_OFFSET_1_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_CONFIG_ETHTYPE_USER_OFFSET_2_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_CONFIG_ETHTYPE_USER_OFFSET_3_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_CONFIG_REG = 
{
    "PARSER_CORE_CONFIGURATION_USER_ETHTYPE_CONFIG",
#if RU_INCLUDE_DESC
    "USER_ETHERTYPE_CONFIGURATION Register",
    "Configure protocol and enables user Ethertype",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_CONFIG_REG_OFFSET,
    0,
    0,
    299,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    10,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_CONFIG_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_QUAD_PARSER_CORE_CONFIGURATION_IPV6_HDR_EXT_FLTR_MASK_CFG
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_QUAD_PARSER_CORE_CONFIGURATION_IPV6_HDR_EXT_FLTR_MASK_CFG_FIELDS[] =
{
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_IPV6_HDR_EXT_FLTR_MASK_CFG_HOP_BY_HOP_MATCH_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_IPV6_HDR_EXT_FLTR_MASK_CFG_ROUTING_EH_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_IPV6_HDR_EXT_FLTR_MASK_CFG_DEST_OPT_EH_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_IPV6_HDR_EXT_FLTR_MASK_CFG_AH_MATCH_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_IPV6_HDR_EXT_FLTR_MASK_CFG_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_IPV6_HDR_EXT_FLTR_MASK_CFG_REG = 
{
    "PARSER_CORE_CONFIGURATION_IPV6_HDR_EXT_FLTR_MASK_CFG",
#if RU_INCLUDE_DESC
    "IPV6_HDR_EXT_FLTR_MASK_CFG Register",
    "IPV6 Header Extension Filter Mask register",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_IPV6_HDR_EXT_FLTR_MASK_CFG_REG_OFFSET,
    0,
    0,
    300,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    5,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_IPV6_HDR_EXT_FLTR_MASK_CFG_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_NEST
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_NEST_FIELDS[] =
{
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_NEST_QTAG_NEST_0_PROFILE_0_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_NEST_QTAG_NEST_0_PROFILE_1_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_NEST_QTAG_NEST_0_PROFILE_2_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_NEST_QTAG_NEST_1_PROFILE_0_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_NEST_QTAG_NEST_1_PROFILE_1_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_NEST_QTAG_NEST_1_PROFILE_2_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_NEST_RESERVED0_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_NEST_MAX_NUM_OF_VLANS_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_NEST_REG = 
{
    "PARSER_CORE_CONFIGURATION_QTAG_NEST",
#if RU_INCLUDE_DESC
    "QTAG_NESTING Register",
    "Qtag Nesting config",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_NEST_REG_OFFSET,
    0,
    0,
    301,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    8,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_NEST_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_HARD_NEST_0
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_HARD_NEST_0_FIELDS[] =
{
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_HARD_NEST_0_HARD_NEST_PROFILE_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_HARD_NEST_0_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_HARD_NEST_0_REG = 
{
    "PARSER_CORE_CONFIGURATION_QTAG_HARD_NEST_0",
#if RU_INCLUDE_DESC
    "QTAG_HARD_NEST_PROFILE_0 Register",
    "QTAG Hard Nest Profile 0",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_HARD_NEST_0_REG_OFFSET,
    0,
    0,
    302,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    2,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_HARD_NEST_0_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_HARD_NEST_1
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_HARD_NEST_1_FIELDS[] =
{
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_HARD_NEST_1_HARD_NEST_PROFILE_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_HARD_NEST_1_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_HARD_NEST_1_REG = 
{
    "PARSER_CORE_CONFIGURATION_QTAG_HARD_NEST_1",
#if RU_INCLUDE_DESC
    "QTAG_HARD_NEST_PROFILE_1 Register",
    "QTAG Hard Nest Profile 1",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_HARD_NEST_1_REG_OFFSET,
    0,
    0,
    303,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    2,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_HARD_NEST_1_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_HARD_NEST_2
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_HARD_NEST_2_FIELDS[] =
{
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_HARD_NEST_2_HARD_NEST_PROFILE_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_HARD_NEST_2_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_HARD_NEST_2_REG = 
{
    "PARSER_CORE_CONFIGURATION_QTAG_HARD_NEST_2",
#if RU_INCLUDE_DESC
    "QTAG_HARD_NEST_PROFILE_2 Register",
    "QTAG Hard Nest Profile 2",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_HARD_NEST_2_REG_OFFSET,
    0,
    0,
    304,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    2,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_HARD_NEST_2_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_IP_PROT
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_IP_PROT_FIELDS[] =
{
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_IP_PROT_USER_IP_PROT_0_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_IP_PROT_USER_IP_PROT_1_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_IP_PROT_USER_IP_PROT_2_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_IP_PROT_USER_IP_PROT_3_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_IP_PROT_REG = 
{
    "PARSER_CORE_CONFIGURATION_USER_IP_PROT",
#if RU_INCLUDE_DESC
    "USER_DEFINED_IP_PROTOCL Register",
    "IP Protocols to be matched to IP Protocol field and to be indicated in the output summary word",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_IP_PROT_REG_OFFSET,
    0,
    0,
    305,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    4,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_IP_PROT_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT0_VAL_L
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT0_VAL_L_FIELDS[] =
{
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT0_VAL_L_DA_FILT_LSB_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT0_VAL_L_REG = 
{
    "PARSER_CORE_CONFIGURATION_DA_FILT0_VAL_L",
#if RU_INCLUDE_DESC
    "DA_FILT0_VAL_L Register",
    "Config DA filter 31:0",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT0_VAL_L_REG_OFFSET,
    0,
    0,
    306,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT0_VAL_L_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT0_VAL_H
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT0_VAL_H_FIELDS[] =
{
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT0_VAL_H_DA_FILT_MSB_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT0_VAL_H_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT0_VAL_H_REG = 
{
    "PARSER_CORE_CONFIGURATION_DA_FILT0_VAL_H",
#if RU_INCLUDE_DESC
    "DA_FILT0_VAL_H Register",
    "Config DA filter0 47:32",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT0_VAL_H_REG_OFFSET,
    0,
    0,
    307,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    2,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT0_VAL_H_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT1_VAL_L
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT1_VAL_L_FIELDS[] =
{
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT1_VAL_L_DA_FILT_LSB_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT1_VAL_L_REG = 
{
    "PARSER_CORE_CONFIGURATION_DA_FILT1_VAL_L",
#if RU_INCLUDE_DESC
    "DA_FILT1_VAL_L Register",
    "Config DA filter1 31:0",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT1_VAL_L_REG_OFFSET,
    0,
    0,
    308,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT1_VAL_L_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT1_VAL_H
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT1_VAL_H_FIELDS[] =
{
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT1_VAL_H_DA_FILT_MSB_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT1_VAL_H_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT1_VAL_H_REG = 
{
    "PARSER_CORE_CONFIGURATION_DA_FILT1_VAL_H",
#if RU_INCLUDE_DESC
    "DA_FILT1_VAL_H Register",
    "Config DA filter1 47:32",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT1_VAL_H_REG_OFFSET,
    0,
    0,
    309,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    2,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT1_VAL_H_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT2_VAL_L
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT2_VAL_L_FIELDS[] =
{
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT2_VAL_L_DA_FILT_LSB_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT2_VAL_L_REG = 
{
    "PARSER_CORE_CONFIGURATION_DA_FILT2_VAL_L",
#if RU_INCLUDE_DESC
    "DA_FILT2_VAL_L Register",
    "Config DA filter2 31:0",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT2_VAL_L_REG_OFFSET,
    0,
    0,
    310,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT2_VAL_L_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT2_VAL_H
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT2_VAL_H_FIELDS[] =
{
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT2_VAL_H_DA_FILT_MSB_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT2_VAL_H_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT2_VAL_H_REG = 
{
    "PARSER_CORE_CONFIGURATION_DA_FILT2_VAL_H",
#if RU_INCLUDE_DESC
    "DA_FILT2_VAL_H Register",
    "Config DA filter2 47:32",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT2_VAL_H_REG_OFFSET,
    0,
    0,
    311,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    2,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT2_VAL_H_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT3_VAL_L
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT3_VAL_L_FIELDS[] =
{
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT3_VAL_L_DA_FILT_LSB_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT3_VAL_L_REG = 
{
    "PARSER_CORE_CONFIGURATION_DA_FILT3_VAL_L",
#if RU_INCLUDE_DESC
    "DA_FILT3_VAL_L Register",
    "Config DA filter3 31:0",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT3_VAL_L_REG_OFFSET,
    0,
    0,
    312,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT3_VAL_L_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT3_VAL_H
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT3_VAL_H_FIELDS[] =
{
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT3_VAL_H_DA_FILT_MSB_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT3_VAL_H_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT3_VAL_H_REG = 
{
    "PARSER_CORE_CONFIGURATION_DA_FILT3_VAL_H",
#if RU_INCLUDE_DESC
    "DA_FILT3_VAL_H Register",
    "Config DA filter3 47:32",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT3_VAL_H_REG_OFFSET,
    0,
    0,
    313,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    2,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT3_VAL_H_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT4_VAL_L
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT4_VAL_L_FIELDS[] =
{
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT4_VAL_L_DA_FILT_LSB_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT4_VAL_L_REG = 
{
    "PARSER_CORE_CONFIGURATION_DA_FILT4_VAL_L",
#if RU_INCLUDE_DESC
    "DA_FILT4_VAL_L Register",
    "Config DA filter4 31:0",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT4_VAL_L_REG_OFFSET,
    0,
    0,
    314,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT4_VAL_L_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT4_VAL_H
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT4_VAL_H_FIELDS[] =
{
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT4_VAL_H_DA_FILT_MSB_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT4_VAL_H_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT4_VAL_H_REG = 
{
    "PARSER_CORE_CONFIGURATION_DA_FILT4_VAL_H",
#if RU_INCLUDE_DESC
    "DA_FILT4_VAL_H Register",
    "Config DA Filter4 47:32",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT4_VAL_H_REG_OFFSET,
    0,
    0,
    315,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    2,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT4_VAL_H_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT5_VAL_L
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT5_VAL_L_FIELDS[] =
{
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT5_VAL_L_DA_FILT_LSB_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT5_VAL_L_REG = 
{
    "PARSER_CORE_CONFIGURATION_DA_FILT5_VAL_L",
#if RU_INCLUDE_DESC
    "DA_FILT5_VAL_L Register",
    "Config DA filter5 31:0",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT5_VAL_L_REG_OFFSET,
    0,
    0,
    316,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT5_VAL_L_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT5_VAL_H
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT5_VAL_H_FIELDS[] =
{
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT5_VAL_H_DA_FILT_MSB_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT5_VAL_H_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT5_VAL_H_REG = 
{
    "PARSER_CORE_CONFIGURATION_DA_FILT5_VAL_H",
#if RU_INCLUDE_DESC
    "DA_FILT5_VAL_H Register",
    "Config DA Filter5 47:32",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT5_VAL_H_REG_OFFSET,
    0,
    0,
    317,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    2,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT5_VAL_H_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT6_VAL_L
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT6_VAL_L_FIELDS[] =
{
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT6_VAL_L_DA_FILT_LSB_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT6_VAL_L_REG = 
{
    "PARSER_CORE_CONFIGURATION_DA_FILT6_VAL_L",
#if RU_INCLUDE_DESC
    "DA_FILT6_VAL_L Register",
    "Config DA filter6 31:0",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT6_VAL_L_REG_OFFSET,
    0,
    0,
    318,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT6_VAL_L_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT6_VAL_H
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT6_VAL_H_FIELDS[] =
{
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT6_VAL_H_DA_FILT_MSB_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT6_VAL_H_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT6_VAL_H_REG = 
{
    "PARSER_CORE_CONFIGURATION_DA_FILT6_VAL_H",
#if RU_INCLUDE_DESC
    "DA_FILT6_VAL_H Register",
    "Config DA Filter6 47:32",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT6_VAL_H_REG_OFFSET,
    0,
    0,
    319,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    2,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT6_VAL_H_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT7_VAL_L
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT7_VAL_L_FIELDS[] =
{
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT7_VAL_L_DA_FILT_LSB_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT7_VAL_L_REG = 
{
    "PARSER_CORE_CONFIGURATION_DA_FILT7_VAL_L",
#if RU_INCLUDE_DESC
    "DA_FILT7_VAL_L Register",
    "Config DA filter7 31:0",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT7_VAL_L_REG_OFFSET,
    0,
    0,
    320,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT7_VAL_L_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT7_VAL_H
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT7_VAL_H_FIELDS[] =
{
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT7_VAL_H_DA_FILT_MSB_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT7_VAL_H_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT7_VAL_H_REG = 
{
    "PARSER_CORE_CONFIGURATION_DA_FILT7_VAL_H",
#if RU_INCLUDE_DESC
    "DA_FILT7_VAL_H Register",
    "Config DA Filter7 47:32",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT7_VAL_H_REG_OFFSET,
    0,
    0,
    321,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    2,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT7_VAL_H_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT8_VAL_L
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT8_VAL_L_FIELDS[] =
{
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT8_VAL_L_DA_FILT_LSB_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT8_VAL_L_REG = 
{
    "PARSER_CORE_CONFIGURATION_DA_FILT8_VAL_L",
#if RU_INCLUDE_DESC
    "DA_FILT8_VAL_L Register",
    "Config DA filter8 31:0",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT8_VAL_L_REG_OFFSET,
    0,
    0,
    322,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT8_VAL_L_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT8_VAL_H
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT8_VAL_H_FIELDS[] =
{
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT8_VAL_H_DA_FILT_MSB_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT8_VAL_H_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT8_VAL_H_REG = 
{
    "PARSER_CORE_CONFIGURATION_DA_FILT8_VAL_H",
#if RU_INCLUDE_DESC
    "DA_FILT8_VAL_H Register",
    "Config DA Filter8 47:32",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT8_VAL_H_REG_OFFSET,
    0,
    0,
    323,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    2,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT8_VAL_H_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT0_MASK_L
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT0_MASK_L_FIELDS[] =
{
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT0_MASK_L_DA_FILT_MASK_L_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT0_MASK_L_REG = 
{
    "PARSER_CORE_CONFIGURATION_DA_FILT0_MASK_L",
#if RU_INCLUDE_DESC
    "DA_FILT0_MASK_L Register",
    "Config DA Filter mask 15:0",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT0_MASK_L_REG_OFFSET,
    0,
    0,
    324,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT0_MASK_L_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT0_MASK_H
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT0_MASK_H_FIELDS[] =
{
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT0_MASK_H_DA_FILT_MASK_MSB_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT0_MASK_H_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT0_MASK_H_REG = 
{
    "PARSER_CORE_CONFIGURATION_DA_FILT0_MASK_H",
#if RU_INCLUDE_DESC
    "DA_FILT0_MASK_H Register",
    "Config DA Filter0 mask 47:32",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT0_MASK_H_REG_OFFSET,
    0,
    0,
    325,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    2,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT0_MASK_H_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT1_MASK_L
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT1_MASK_L_FIELDS[] =
{
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT1_MASK_L_DA_FILT_MASK_L_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT1_MASK_L_REG = 
{
    "PARSER_CORE_CONFIGURATION_DA_FILT1_MASK_L",
#if RU_INCLUDE_DESC
    "DA_FILT1_MASK_L Register",
    "Config DA Filter1 mask 31:0",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT1_MASK_L_REG_OFFSET,
    0,
    0,
    326,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT1_MASK_L_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT1_MASK_H
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT1_MASK_H_FIELDS[] =
{
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT1_MASK_H_DA_FILT_MASK_MSB_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT1_MASK_H_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT1_MASK_H_REG = 
{
    "PARSER_CORE_CONFIGURATION_DA_FILT1_MASK_H",
#if RU_INCLUDE_DESC
    "DA_FILT1_MASK_H Register",
    "Config DA Filter1 mask 47:32",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT1_MASK_H_REG_OFFSET,
    0,
    0,
    327,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    2,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT1_MASK_H_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_0
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_0_FIELDS[] =
{
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_0_DA_FILT0_VALID_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_0_DA_FILT1_VALID_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_0_DA_FILT2_VALID_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_0_DA_FILT3_VALID_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_0_DA_FILT4_VALID_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_0_DA_FILT5_VALID_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_0_DA_FILT6_VALID_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_0_DA_FILT7_VALID_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_0_DA_FILT8_VALID_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_0_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_0_REG = 
{
    "PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_0",
#if RU_INCLUDE_DESC
    "DA_FILT_VALID_CFG_PROFILE_0 Register",
    "Valid configuration of all DA filters: there is a dedicated bit per each DA filter that says if the current DA filter is valid or not. Used for on-the-fly DA filter value (mask) modifications, since the DA filter parameters are not assigned on single SW register.",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_0_REG_OFFSET,
    0,
    0,
    328,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    10,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_0_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_1
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_1_FIELDS[] =
{
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_1_DA_FILT0_VALID_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_1_DA_FILT1_VALID_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_1_DA_FILT2_VALID_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_1_DA_FILT3_VALID_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_1_DA_FILT4_VALID_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_1_DA_FILT5_VALID_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_1_DA_FILT6_VALID_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_1_DA_FILT7_VALID_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_1_DA_FILT8_VALID_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_1_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_1_REG = 
{
    "PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_1",
#if RU_INCLUDE_DESC
    "DA_FILT_VALID_CFG_PROFILE_1 Register",
    "Valid configuration of all DA filters: there is a dedicated bit per each DA filter that says if the current DA filter is valid or not. Used for on-the-fly DA filter value (mask) modifications, since the DA filter parameters are not assigned on single SW register.",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_1_REG_OFFSET,
    0,
    0,
    329,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    10,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_1_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_2
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_2_FIELDS[] =
{
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_2_DA_FILT0_VALID_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_2_DA_FILT1_VALID_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_2_DA_FILT2_VALID_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_2_DA_FILT3_VALID_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_2_DA_FILT4_VALID_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_2_DA_FILT5_VALID_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_2_DA_FILT6_VALID_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_2_DA_FILT7_VALID_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_2_DA_FILT8_VALID_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_2_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_2_REG = 
{
    "PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_2",
#if RU_INCLUDE_DESC
    "DA_FILT_VALID_CFG_PROFILE_2 Register",
    "Valid configuration of all DA filters: there is a dedicated bit per each DA filter that says if the current DA filter is valid or not. Used for on-the-fly DA filter value (mask) modifications, since the DA filter parameters are not assigned on single SW register.",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_2_REG_OFFSET,
    0,
    0,
    330,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    10,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_2_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_QUAD_PARSER_CORE_CONFIGURATION_GRE_PROTOCOL_CFG
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_QUAD_PARSER_CORE_CONFIGURATION_GRE_PROTOCOL_CFG_FIELDS[] =
{
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_GRE_PROTOCOL_CFG_GRE_PROTOCOL_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_GRE_PROTOCOL_CFG_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_GRE_PROTOCOL_CFG_REG = 
{
    "PARSER_CORE_CONFIGURATION_GRE_PROTOCOL_CFG",
#if RU_INCLUDE_DESC
    "GRE_PROTOCOL_CFG Register",
    "GRE Protocol",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_GRE_PROTOCOL_CFG_REG_OFFSET,
    0,
    0,
    331,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    2,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_GRE_PROTOCOL_CFG_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_QUAD_PARSER_CORE_CONFIGURATION_PROP_TAG_CFG
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_QUAD_PARSER_CORE_CONFIGURATION_PROP_TAG_CFG_FIELDS[] =
{
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_PROP_TAG_CFG_SIZE_PROFILE_0_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_PROP_TAG_CFG_SIZE_PROFILE_1_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_PROP_TAG_CFG_SIZE_PROFILE_2_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_PROP_TAG_CFG_PRE_DA_DPROFILE_0_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_PROP_TAG_CFG_PRE_DA_DPROFILE_1_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_PROP_TAG_CFG_PRE_DA_DPROFILE_2_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_PROP_TAG_CFG_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_PROP_TAG_CFG_REG = 
{
    "PARSER_CORE_CONFIGURATION_PROP_TAG_CFG",
#if RU_INCLUDE_DESC
    "PROP_TAG_CFG Register",
    "Prop Tag Configuration",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_PROP_TAG_CFG_REG_OFFSET,
    0,
    0,
    332,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    7,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_PROP_TAG_CFG_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_QUAD_PARSER_CORE_CONFIGURATION_DOS_ATTACK
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_QUAD_PARSER_CORE_CONFIGURATION_DOS_ATTACK_FIELDS[] =
{
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_DOS_ATTACK_MASK_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_DOS_ATTACK_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_DOS_ATTACK_REG = 
{
    "PARSER_CORE_CONFIGURATION_DOS_ATTACK",
#if RU_INCLUDE_DESC
    "DOS_ATTACK Register",
    "Control the detection of the following DOS Attacks:"
    "MAC Spoof MACDA = MACSA"
    "IP_LAND IPDA=IPSA in an IP(v4/v6) datagram."
    "TCP_BLAT  DPort=SPort in a TCP header carried in an unfragmented IP datagram or in the first fragment of a fragmented IP datagram."
    "UDP_BLAT  DPport=SPort in a UDP header carried in an unfragmented IP datagram or in the first fragment of a fragmented IP datagram."
    "TCP_NULLScan  Seq_Num=0 & All TCP_FLAGs=0, in a TCP header carried in an unfragmented IP datagram or in the first fragment of a fragmented"
    "TCP_XMASScan  Seq_Num=0 & FIN=1 & URG=1 & PSH=1 in a TCP header carried in an unfragmented IP datagram or in the first fragment of a fragmented IP datagram."
    "TCP_SYNFINScanSYN=1 & FIN=1 in a TCP header carried in an unfragmented IP datagram or in the first fragment of a fragmented IP datagram."
    "TCP_SYNErrorSYN=1 & ACK=0 & SRC_Port<1024 in a TCP header carried in an unfragmented IP datagram or in the first fragment of a fragmented IP datagram."
    "TCP_ShortHDRThe length of a TCP header carried in an unfragmented IP datagram or the first fragment of a fragmented IP datagram is less than MIN_TCP_Header_Size (20B) ."
    "TCP_FragErrorThe Fragment_Offset=1 in any fragment of a fragmented IP datagram carring part of TCP data."
    "ICMPv4_FragmentThe ICMPv4 protocol data unit carrier in a fragmented IPv4 datagram."
    "ICMPv6_FragmentThe ICMPv6 protocol data unit carrier in a fragmented IPv6 datagram."
    "ICMPv4_LongPingThe ICMPv4 Ping(Echo Request) protocol data unit carried in an unfragmented IPv4 datagram with its Payload Length indicating a value greater than the MAX_ICMPv4_Size + size of IPv4 heater."
    "ICMPv6_LongPingThe ICMPv6 Ping(Echo Request) protocol data unit carried in an unfragmented IPv6 datagram with its Payload Length indicating a value greater than the MAX_ICMPv6_Size."
    "",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DOS_ATTACK_REG_OFFSET,
    0,
    0,
    333,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    2,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_DOS_ATTACK_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_QUAD_PARSER_CORE_CONFIGURATION_ICMP_MAX_SIZE
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_QUAD_PARSER_CORE_CONFIGURATION_ICMP_MAX_SIZE_FIELDS[] =
{
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_ICMP_MAX_SIZE_V4_SIZE_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_ICMP_MAX_SIZE_RESERVED0_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_ICMP_MAX_SIZE_V6_SIZE_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_ICMP_MAX_SIZE_RESERVED1_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_ICMP_MAX_SIZE_REG = 
{
    "PARSER_CORE_CONFIGURATION_ICMP_MAX_SIZE",
#if RU_INCLUDE_DESC
    "ICMP_MAX_SIZE Register",
    "Sets the MAX ICMPV4/V6 packet sizes for the purpose of detection of ICMP DOS attacks",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_ICMP_MAX_SIZE_REG_OFFSET,
    0,
    0,
    334,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    4,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_ICMP_MAX_SIZE_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_QUAD_PARSER_CORE_CONFIGURATION_KEY_CFG
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_QUAD_PARSER_CORE_CONFIGURATION_KEY_CFG_FIELDS[] =
{
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_KEY_CFG_L2_TOS_MASK_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_KEY_CFG_L3_TOS_MASK_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_KEY_CFG_L2_EXCLUDE_SMAC_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_KEY_CFG_TCP_PURE_ACK_MASK_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_KEY_CFG_INCUDE_DEI_IN_VLANS_CRC_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_KEY_CFG_KEY_SIZE_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_KEY_CFG_MAX_NUM_OF_VLANS_IN_CRC_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_KEY_CFG_L3_TCP_PURE_ACK_MASK_FIELD,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_KEY_CFG_RSRV_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_QUAD_PARSER_CORE_CONFIGURATION_KEY_CFG_REG = 
{
    "PARSER_CORE_CONFIGURATION_KEY_CFG",
#if RU_INCLUDE_DESC
    "KEY_CFG Register",
    "Misc Result Key configurations",
#endif
    RNR_QUAD_PARSER_CORE_CONFIGURATION_KEY_CFG_REG_OFFSET,
    0,
    0,
    335,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    9,
    RNR_QUAD_PARSER_CORE_CONFIGURATION_KEY_CFG_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_QUAD_GENERAL_CONFIG_DMA_ARB_CFG
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_QUAD_GENERAL_CONFIG_DMA_ARB_CFG_FIELDS[] =
{
    &RNR_QUAD_GENERAL_CONFIG_DMA_ARB_CFG_USE_FIFO_FOR_DDR_ONLY_FIELD,
    &RNR_QUAD_GENERAL_CONFIG_DMA_ARB_CFG_TOKEN_ARBITER_IS_RR_FIELD,
    &RNR_QUAD_GENERAL_CONFIG_DMA_ARB_CFG_CHICKEN_NO_FLOWCTRL_FIELD,
    &RNR_QUAD_GENERAL_CONFIG_DMA_ARB_CFG_FLOW_CTRL_CLEAR_TOKEN_FIELD,
    &RNR_QUAD_GENERAL_CONFIG_DMA_ARB_CFG_DDR_CONGEST_THRESHOLD_FIELD,
    &RNR_QUAD_GENERAL_CONFIG_DMA_ARB_CFG_PSRAM_CONGEST_THRESHOLD_FIELD,
    &RNR_QUAD_GENERAL_CONFIG_DMA_ARB_CFG_RESERVED0_FIELD,
    &RNR_QUAD_GENERAL_CONFIG_DMA_ARB_CFG_ENABLE_REPLY_THRESHOLD_FIELD,
    &RNR_QUAD_GENERAL_CONFIG_DMA_ARB_CFG_DDR_REPLY_THRESHOLD_FIELD,
    &RNR_QUAD_GENERAL_CONFIG_DMA_ARB_CFG_PSRAM_REPLY_THRESHOLD_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_QUAD_GENERAL_CONFIG_DMA_ARB_CFG_REG = 
{
    "GENERAL_CONFIG_DMA_ARB_CFG",
#if RU_INCLUDE_DESC
    "DMA_ARB_CFG Register",
    "DMA arbiter Configuration",
#endif
    RNR_QUAD_GENERAL_CONFIG_DMA_ARB_CFG_REG_OFFSET,
    0,
    0,
    336,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    10,
    RNR_QUAD_GENERAL_CONFIG_DMA_ARB_CFG_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_QUAD_GENERAL_CONFIG_PSRAM0_BASE
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_QUAD_GENERAL_CONFIG_PSRAM0_BASE_FIELDS[] =
{
    &RNR_QUAD_GENERAL_CONFIG_PSRAM0_BASE_VAL_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_QUAD_GENERAL_CONFIG_PSRAM0_BASE_REG = 
{
    "GENERAL_CONFIG_PSRAM0_BASE",
#if RU_INCLUDE_DESC
    "PSRAM0_BASE Register",
    "Configure PSRAM0 base"
    "",
#endif
    RNR_QUAD_GENERAL_CONFIG_PSRAM0_BASE_REG_OFFSET,
    0,
    0,
    337,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    RNR_QUAD_GENERAL_CONFIG_PSRAM0_BASE_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_QUAD_GENERAL_CONFIG_PSRAM1_BASE
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_QUAD_GENERAL_CONFIG_PSRAM1_BASE_FIELDS[] =
{
    &RNR_QUAD_GENERAL_CONFIG_PSRAM1_BASE_VAL_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_QUAD_GENERAL_CONFIG_PSRAM1_BASE_REG = 
{
    "GENERAL_CONFIG_PSRAM1_BASE",
#if RU_INCLUDE_DESC
    "PSRAM1_BASE Register",
    "Configure PSRAM1 base"
    "",
#endif
    RNR_QUAD_GENERAL_CONFIG_PSRAM1_BASE_REG_OFFSET,
    0,
    0,
    338,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    RNR_QUAD_GENERAL_CONFIG_PSRAM1_BASE_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_QUAD_GENERAL_CONFIG_PSRAM2_BASE
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_QUAD_GENERAL_CONFIG_PSRAM2_BASE_FIELDS[] =
{
    &RNR_QUAD_GENERAL_CONFIG_PSRAM2_BASE_VAL_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_QUAD_GENERAL_CONFIG_PSRAM2_BASE_REG = 
{
    "GENERAL_CONFIG_PSRAM2_BASE",
#if RU_INCLUDE_DESC
    "PSRAM2_BASE Register",
    "Configure PSRAM2 base"
    "",
#endif
    RNR_QUAD_GENERAL_CONFIG_PSRAM2_BASE_REG_OFFSET,
    0,
    0,
    339,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    RNR_QUAD_GENERAL_CONFIG_PSRAM2_BASE_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_QUAD_GENERAL_CONFIG_PSRAM3_BASE
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_QUAD_GENERAL_CONFIG_PSRAM3_BASE_FIELDS[] =
{
    &RNR_QUAD_GENERAL_CONFIG_PSRAM3_BASE_VAL_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_QUAD_GENERAL_CONFIG_PSRAM3_BASE_REG = 
{
    "GENERAL_CONFIG_PSRAM3_BASE",
#if RU_INCLUDE_DESC
    "PSRAM3_BASE Register",
    "Configure PSRAM3 base"
    "",
#endif
    RNR_QUAD_GENERAL_CONFIG_PSRAM3_BASE_REG_OFFSET,
    0,
    0,
    340,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    RNR_QUAD_GENERAL_CONFIG_PSRAM3_BASE_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_QUAD_GENERAL_CONFIG_DDR0_BASE
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_QUAD_GENERAL_CONFIG_DDR0_BASE_FIELDS[] =
{
    &RNR_QUAD_GENERAL_CONFIG_DDR0_BASE_VAL_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_QUAD_GENERAL_CONFIG_DDR0_BASE_REG = 
{
    "GENERAL_CONFIG_DDR0_BASE",
#if RU_INCLUDE_DESC
    "DDR0_BASE Register",
    "Configure DDR0 base"
    "",
#endif
    RNR_QUAD_GENERAL_CONFIG_DDR0_BASE_REG_OFFSET,
    0,
    0,
    341,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    RNR_QUAD_GENERAL_CONFIG_DDR0_BASE_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_QUAD_GENERAL_CONFIG_DDR1_BASE
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_QUAD_GENERAL_CONFIG_DDR1_BASE_FIELDS[] =
{
    &RNR_QUAD_GENERAL_CONFIG_DDR1_BASE_VAL_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_QUAD_GENERAL_CONFIG_DDR1_BASE_REG = 
{
    "GENERAL_CONFIG_DDR1_BASE",
#if RU_INCLUDE_DESC
    "DDR1_BASE Register",
    "Configure DDR1 base"
    "",
#endif
    RNR_QUAD_GENERAL_CONFIG_DDR1_BASE_REG_OFFSET,
    0,
    0,
    342,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    RNR_QUAD_GENERAL_CONFIG_DDR1_BASE_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_QUAD_GENERAL_CONFIG_PSRAM0_MASK
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_QUAD_GENERAL_CONFIG_PSRAM0_MASK_FIELDS[] =
{
    &RNR_QUAD_GENERAL_CONFIG_PSRAM0_MASK_VAL_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_QUAD_GENERAL_CONFIG_PSRAM0_MASK_REG = 
{
    "GENERAL_CONFIG_PSRAM0_MASK",
#if RU_INCLUDE_DESC
    "PSRAM0_MASK Register",
    "Configure PSRAM0 mask"
    "",
#endif
    RNR_QUAD_GENERAL_CONFIG_PSRAM0_MASK_REG_OFFSET,
    0,
    0,
    343,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    RNR_QUAD_GENERAL_CONFIG_PSRAM0_MASK_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_QUAD_GENERAL_CONFIG_PSRAM1_MASK
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_QUAD_GENERAL_CONFIG_PSRAM1_MASK_FIELDS[] =
{
    &RNR_QUAD_GENERAL_CONFIG_PSRAM1_MASK_VAL_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_QUAD_GENERAL_CONFIG_PSRAM1_MASK_REG = 
{
    "GENERAL_CONFIG_PSRAM1_MASK",
#if RU_INCLUDE_DESC
    "PSRAM1_MASK Register",
    "Configure PSRAM1 mask"
    "",
#endif
    RNR_QUAD_GENERAL_CONFIG_PSRAM1_MASK_REG_OFFSET,
    0,
    0,
    344,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    RNR_QUAD_GENERAL_CONFIG_PSRAM1_MASK_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_QUAD_GENERAL_CONFIG_PSRAM2_MASK
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_QUAD_GENERAL_CONFIG_PSRAM2_MASK_FIELDS[] =
{
    &RNR_QUAD_GENERAL_CONFIG_PSRAM2_MASK_VAL_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_QUAD_GENERAL_CONFIG_PSRAM2_MASK_REG = 
{
    "GENERAL_CONFIG_PSRAM2_MASK",
#if RU_INCLUDE_DESC
    "PSRAM2_MASK Register",
    "Configure PSRAM2 mask"
    "",
#endif
    RNR_QUAD_GENERAL_CONFIG_PSRAM2_MASK_REG_OFFSET,
    0,
    0,
    345,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    RNR_QUAD_GENERAL_CONFIG_PSRAM2_MASK_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_QUAD_GENERAL_CONFIG_PSRAM3_MASK
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_QUAD_GENERAL_CONFIG_PSRAM3_MASK_FIELDS[] =
{
    &RNR_QUAD_GENERAL_CONFIG_PSRAM3_MASK_VAL_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_QUAD_GENERAL_CONFIG_PSRAM3_MASK_REG = 
{
    "GENERAL_CONFIG_PSRAM3_MASK",
#if RU_INCLUDE_DESC
    "PSRAM3_MASK Register",
    "Configure PSRAM3 mask"
    "",
#endif
    RNR_QUAD_GENERAL_CONFIG_PSRAM3_MASK_REG_OFFSET,
    0,
    0,
    346,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    RNR_QUAD_GENERAL_CONFIG_PSRAM3_MASK_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_QUAD_GENERAL_CONFIG_DDR0_MASK
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_QUAD_GENERAL_CONFIG_DDR0_MASK_FIELDS[] =
{
    &RNR_QUAD_GENERAL_CONFIG_DDR0_MASK_VAL_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_QUAD_GENERAL_CONFIG_DDR0_MASK_REG = 
{
    "GENERAL_CONFIG_DDR0_MASK",
#if RU_INCLUDE_DESC
    "DDR0_MASK Register",
    "Configure DDR0 mask"
    "",
#endif
    RNR_QUAD_GENERAL_CONFIG_DDR0_MASK_REG_OFFSET,
    0,
    0,
    347,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    RNR_QUAD_GENERAL_CONFIG_DDR0_MASK_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_QUAD_GENERAL_CONFIG_DDR1_MASK
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_QUAD_GENERAL_CONFIG_DDR1_MASK_FIELDS[] =
{
    &RNR_QUAD_GENERAL_CONFIG_DDR1_MASK_VAL_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_QUAD_GENERAL_CONFIG_DDR1_MASK_REG = 
{
    "GENERAL_CONFIG_DDR1_MASK",
#if RU_INCLUDE_DESC
    "DDR1_MASK Register",
    "Configure DDR1 mask"
    "",
#endif
    RNR_QUAD_GENERAL_CONFIG_DDR1_MASK_REG_OFFSET,
    0,
    0,
    348,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    RNR_QUAD_GENERAL_CONFIG_DDR1_MASK_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_QUAD_GENERAL_CONFIG_PROFILING_CONFIG
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_QUAD_GENERAL_CONFIG_PROFILING_CONFIG_FIELDS[] =
{
    &RNR_QUAD_GENERAL_CONFIG_PROFILING_CONFIG_COUNTER_LSB_SEL_FIELD,
    &RNR_QUAD_GENERAL_CONFIG_PROFILING_CONFIG_RESERVED0_FIELD,
    &RNR_QUAD_GENERAL_CONFIG_PROFILING_CONFIG_ENABLE_TRACE_CORE_0_FIELD,
    &RNR_QUAD_GENERAL_CONFIG_PROFILING_CONFIG_ENABLE_TRACE_CORE_1_FIELD,
    &RNR_QUAD_GENERAL_CONFIG_PROFILING_CONFIG_ENABLE_TRACE_CORE_2_FIELD,
    &RNR_QUAD_GENERAL_CONFIG_PROFILING_CONFIG_ENABLE_TRACE_CORE_3_FIELD,
    &RNR_QUAD_GENERAL_CONFIG_PROFILING_CONFIG_ENABLE_TRACE_CORE_4_FIELD,
    &RNR_QUAD_GENERAL_CONFIG_PROFILING_CONFIG_ENABLE_TRACE_CORE_5_FIELD,
    &RNR_QUAD_GENERAL_CONFIG_PROFILING_CONFIG_ENABLE_TRACE_CORE_6_FIELD,
    &RNR_QUAD_GENERAL_CONFIG_PROFILING_CONFIG_ENABLE_TRACE_CORE_7_FIELD,
    &RNR_QUAD_GENERAL_CONFIG_PROFILING_CONFIG_RESERVED1_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_QUAD_GENERAL_CONFIG_PROFILING_CONFIG_REG = 
{
    "GENERAL_CONFIG_PROFILING_CONFIG",
#if RU_INCLUDE_DESC
    "PROFILING_CONFIG Register",
    "Profiling configuration",
#endif
    RNR_QUAD_GENERAL_CONFIG_PROFILING_CONFIG_REG_OFFSET,
    0,
    0,
    349,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    11,
    RNR_QUAD_GENERAL_CONFIG_PROFILING_CONFIG_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_QUAD_GENERAL_CONFIG_BKPT_0_CFG
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_QUAD_GENERAL_CONFIG_BKPT_0_CFG_FIELDS[] =
{
    &RNR_QUAD_GENERAL_CONFIG_BKPT_0_CFG_ADDR_FIELD,
    &RNR_QUAD_GENERAL_CONFIG_BKPT_0_CFG_RESERVED0_FIELD,
    &RNR_QUAD_GENERAL_CONFIG_BKPT_0_CFG_THREAD_FIELD,
    &RNR_QUAD_GENERAL_CONFIG_BKPT_0_CFG_RESERVED1_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_QUAD_GENERAL_CONFIG_BKPT_0_CFG_REG = 
{
    "GENERAL_CONFIG_BKPT_0_CFG",
#if RU_INCLUDE_DESC
    "BKPT_CFG_0 Register",
    "Breakpoint 0 configuration.",
#endif
    RNR_QUAD_GENERAL_CONFIG_BKPT_0_CFG_REG_OFFSET,
    0,
    0,
    350,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    4,
    RNR_QUAD_GENERAL_CONFIG_BKPT_0_CFG_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_QUAD_GENERAL_CONFIG_BKPT_1_CFG
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_QUAD_GENERAL_CONFIG_BKPT_1_CFG_FIELDS[] =
{
    &RNR_QUAD_GENERAL_CONFIG_BKPT_1_CFG_ADDR_FIELD,
    &RNR_QUAD_GENERAL_CONFIG_BKPT_1_CFG_RESERVED0_FIELD,
    &RNR_QUAD_GENERAL_CONFIG_BKPT_1_CFG_THREAD_FIELD,
    &RNR_QUAD_GENERAL_CONFIG_BKPT_1_CFG_RESERVED1_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_QUAD_GENERAL_CONFIG_BKPT_1_CFG_REG = 
{
    "GENERAL_CONFIG_BKPT_1_CFG",
#if RU_INCLUDE_DESC
    "BKPT_CFG_1 Register",
    "Breakpoint 1 configuration.",
#endif
    RNR_QUAD_GENERAL_CONFIG_BKPT_1_CFG_REG_OFFSET,
    0,
    0,
    351,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    4,
    RNR_QUAD_GENERAL_CONFIG_BKPT_1_CFG_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_QUAD_GENERAL_CONFIG_BKPT_2_CFG
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_QUAD_GENERAL_CONFIG_BKPT_2_CFG_FIELDS[] =
{
    &RNR_QUAD_GENERAL_CONFIG_BKPT_2_CFG_ADDR_FIELD,
    &RNR_QUAD_GENERAL_CONFIG_BKPT_2_CFG_RESERVED0_FIELD,
    &RNR_QUAD_GENERAL_CONFIG_BKPT_2_CFG_THREAD_FIELD,
    &RNR_QUAD_GENERAL_CONFIG_BKPT_2_CFG_RESERVED1_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_QUAD_GENERAL_CONFIG_BKPT_2_CFG_REG = 
{
    "GENERAL_CONFIG_BKPT_2_CFG",
#if RU_INCLUDE_DESC
    "BKPT_CFG_2 Register",
    "Breakpoint 2 configuration.",
#endif
    RNR_QUAD_GENERAL_CONFIG_BKPT_2_CFG_REG_OFFSET,
    0,
    0,
    352,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    4,
    RNR_QUAD_GENERAL_CONFIG_BKPT_2_CFG_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_QUAD_GENERAL_CONFIG_BKPT_3_CFG
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_QUAD_GENERAL_CONFIG_BKPT_3_CFG_FIELDS[] =
{
    &RNR_QUAD_GENERAL_CONFIG_BKPT_3_CFG_ADDR_FIELD,
    &RNR_QUAD_GENERAL_CONFIG_BKPT_3_CFG_RESERVED0_FIELD,
    &RNR_QUAD_GENERAL_CONFIG_BKPT_3_CFG_THREAD_FIELD,
    &RNR_QUAD_GENERAL_CONFIG_BKPT_3_CFG_RESERVED1_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_QUAD_GENERAL_CONFIG_BKPT_3_CFG_REG = 
{
    "GENERAL_CONFIG_BKPT_3_CFG",
#if RU_INCLUDE_DESC
    "BKPT_CFG_3 Register",
    "Breakpoint 3 configuration.",
#endif
    RNR_QUAD_GENERAL_CONFIG_BKPT_3_CFG_REG_OFFSET,
    0,
    0,
    353,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    4,
    RNR_QUAD_GENERAL_CONFIG_BKPT_3_CFG_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_QUAD_GENERAL_CONFIG_BKPT_4_CFG
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_QUAD_GENERAL_CONFIG_BKPT_4_CFG_FIELDS[] =
{
    &RNR_QUAD_GENERAL_CONFIG_BKPT_4_CFG_ADDR_FIELD,
    &RNR_QUAD_GENERAL_CONFIG_BKPT_4_CFG_RESERVED0_FIELD,
    &RNR_QUAD_GENERAL_CONFIG_BKPT_4_CFG_THREAD_FIELD,
    &RNR_QUAD_GENERAL_CONFIG_BKPT_4_CFG_RESERVED1_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_QUAD_GENERAL_CONFIG_BKPT_4_CFG_REG = 
{
    "GENERAL_CONFIG_BKPT_4_CFG",
#if RU_INCLUDE_DESC
    "BKPT_CFG_4 Register",
    "Breakpoint 4 configuration.",
#endif
    RNR_QUAD_GENERAL_CONFIG_BKPT_4_CFG_REG_OFFSET,
    0,
    0,
    354,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    4,
    RNR_QUAD_GENERAL_CONFIG_BKPT_4_CFG_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_QUAD_GENERAL_CONFIG_BKPT_5_CFG
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_QUAD_GENERAL_CONFIG_BKPT_5_CFG_FIELDS[] =
{
    &RNR_QUAD_GENERAL_CONFIG_BKPT_5_CFG_ADDR_FIELD,
    &RNR_QUAD_GENERAL_CONFIG_BKPT_5_CFG_RESERVED0_FIELD,
    &RNR_QUAD_GENERAL_CONFIG_BKPT_5_CFG_THREAD_FIELD,
    &RNR_QUAD_GENERAL_CONFIG_BKPT_5_CFG_RESERVED1_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_QUAD_GENERAL_CONFIG_BKPT_5_CFG_REG = 
{
    "GENERAL_CONFIG_BKPT_5_CFG",
#if RU_INCLUDE_DESC
    "BKPT_CFG_5 Register",
    "Breakpoint 5 configuration.",
#endif
    RNR_QUAD_GENERAL_CONFIG_BKPT_5_CFG_REG_OFFSET,
    0,
    0,
    355,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    4,
    RNR_QUAD_GENERAL_CONFIG_BKPT_5_CFG_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_QUAD_GENERAL_CONFIG_BKPT_6_CFG
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_QUAD_GENERAL_CONFIG_BKPT_6_CFG_FIELDS[] =
{
    &RNR_QUAD_GENERAL_CONFIG_BKPT_6_CFG_ADDR_FIELD,
    &RNR_QUAD_GENERAL_CONFIG_BKPT_6_CFG_RESERVED0_FIELD,
    &RNR_QUAD_GENERAL_CONFIG_BKPT_6_CFG_THREAD_FIELD,
    &RNR_QUAD_GENERAL_CONFIG_BKPT_6_CFG_RESERVED1_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_QUAD_GENERAL_CONFIG_BKPT_6_CFG_REG = 
{
    "GENERAL_CONFIG_BKPT_6_CFG",
#if RU_INCLUDE_DESC
    "BKPT_CFG_6 Register",
    "Breakpoint 6 configuration.",
#endif
    RNR_QUAD_GENERAL_CONFIG_BKPT_6_CFG_REG_OFFSET,
    0,
    0,
    356,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    4,
    RNR_QUAD_GENERAL_CONFIG_BKPT_6_CFG_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_QUAD_GENERAL_CONFIG_BKPT_7_CFG
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_QUAD_GENERAL_CONFIG_BKPT_7_CFG_FIELDS[] =
{
    &RNR_QUAD_GENERAL_CONFIG_BKPT_7_CFG_ADDR_FIELD,
    &RNR_QUAD_GENERAL_CONFIG_BKPT_7_CFG_RESERVED0_FIELD,
    &RNR_QUAD_GENERAL_CONFIG_BKPT_7_CFG_THREAD_FIELD,
    &RNR_QUAD_GENERAL_CONFIG_BKPT_7_CFG_RESERVED1_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_QUAD_GENERAL_CONFIG_BKPT_7_CFG_REG = 
{
    "GENERAL_CONFIG_BKPT_7_CFG",
#if RU_INCLUDE_DESC
    "BKPT_CFG_7 Register",
    "Breakpoint 7 configuration.",
#endif
    RNR_QUAD_GENERAL_CONFIG_BKPT_7_CFG_REG_OFFSET,
    0,
    0,
    357,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    4,
    RNR_QUAD_GENERAL_CONFIG_BKPT_7_CFG_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_QUAD_GENERAL_CONFIG_BKPT_GEN_CFG
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_QUAD_GENERAL_CONFIG_BKPT_GEN_CFG_FIELDS[] =
{
    &RNR_QUAD_GENERAL_CONFIG_BKPT_GEN_CFG_HANDLER_ADDR_FIELD,
    &RNR_QUAD_GENERAL_CONFIG_BKPT_GEN_CFG_RESERVED0_FIELD,
    &RNR_QUAD_GENERAL_CONFIG_BKPT_GEN_CFG_UPDATE_PC_VALUE_FIELD,
    &RNR_QUAD_GENERAL_CONFIG_BKPT_GEN_CFG_RESERVED1_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_QUAD_GENERAL_CONFIG_BKPT_GEN_CFG_REG = 
{
    "GENERAL_CONFIG_BKPT_GEN_CFG",
#if RU_INCLUDE_DESC
    "BKPT_CFG_GEN Register",
    "Breakpoint general configuration.",
#endif
    RNR_QUAD_GENERAL_CONFIG_BKPT_GEN_CFG_REG_OFFSET,
    0,
    0,
    358,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    4,
    RNR_QUAD_GENERAL_CONFIG_BKPT_GEN_CFG_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_QUAD_GENERAL_CONFIG_POWERSAVE_CONFIG
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_QUAD_GENERAL_CONFIG_POWERSAVE_CONFIG_FIELDS[] =
{
    &RNR_QUAD_GENERAL_CONFIG_POWERSAVE_CONFIG_TIME_COUNTER_FIELD,
    &RNR_QUAD_GENERAL_CONFIG_POWERSAVE_CONFIG_ENABLE_POWERSAVE_CORE_0_FIELD,
    &RNR_QUAD_GENERAL_CONFIG_POWERSAVE_CONFIG_ENABLE_POWERSAVE_CORE_1_FIELD,
    &RNR_QUAD_GENERAL_CONFIG_POWERSAVE_CONFIG_ENABLE_POWERSAVE_CORE_2_FIELD,
    &RNR_QUAD_GENERAL_CONFIG_POWERSAVE_CONFIG_ENABLE_POWERSAVE_CORE_3_FIELD,
    &RNR_QUAD_GENERAL_CONFIG_POWERSAVE_CONFIG_ENABLE_POWERSAVE_CORE_4_FIELD,
    &RNR_QUAD_GENERAL_CONFIG_POWERSAVE_CONFIG_ENABLE_POWERSAVE_CORE_5_FIELD,
    &RNR_QUAD_GENERAL_CONFIG_POWERSAVE_CONFIG_ENABLE_POWERSAVE_CORE_6_FIELD,
    &RNR_QUAD_GENERAL_CONFIG_POWERSAVE_CONFIG_ENABLE_POWERSAVE_CORE_7_FIELD,
    &RNR_QUAD_GENERAL_CONFIG_POWERSAVE_CONFIG_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_QUAD_GENERAL_CONFIG_POWERSAVE_CONFIG_REG = 
{
    "GENERAL_CONFIG_POWERSAVE_CONFIG",
#if RU_INCLUDE_DESC
    "POWERSAVE_CONFIG Register",
    "Powersaving  configuration",
#endif
    RNR_QUAD_GENERAL_CONFIG_POWERSAVE_CONFIG_REG_OFFSET,
    0,
    0,
    359,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    10,
    RNR_QUAD_GENERAL_CONFIG_POWERSAVE_CONFIG_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_QUAD_GENERAL_CONFIG_POWERSAVE_STATUS
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_QUAD_GENERAL_CONFIG_POWERSAVE_STATUS_FIELDS[] =
{
    &RNR_QUAD_GENERAL_CONFIG_POWERSAVE_STATUS_CORE_0_STATUS_FIELD,
    &RNR_QUAD_GENERAL_CONFIG_POWERSAVE_STATUS_CORE_1_STATUS_FIELD,
    &RNR_QUAD_GENERAL_CONFIG_POWERSAVE_STATUS_CORE_2_STATUS_FIELD,
    &RNR_QUAD_GENERAL_CONFIG_POWERSAVE_STATUS_CORE_3_STATUS_FIELD,
    &RNR_QUAD_GENERAL_CONFIG_POWERSAVE_STATUS_CORE_4_STATUS_FIELD,
    &RNR_QUAD_GENERAL_CONFIG_POWERSAVE_STATUS_CORE_5_STATUS_FIELD,
    &RNR_QUAD_GENERAL_CONFIG_POWERSAVE_STATUS_CORE_6_STATUS_FIELD,
    &RNR_QUAD_GENERAL_CONFIG_POWERSAVE_STATUS_CORE_7_STATUS_FIELD,
    &RNR_QUAD_GENERAL_CONFIG_POWERSAVE_STATUS_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_QUAD_GENERAL_CONFIG_POWERSAVE_STATUS_REG = 
{
    "GENERAL_CONFIG_POWERSAVE_STATUS",
#if RU_INCLUDE_DESC
    "POWERSAVE_STATUS Register",
    "Powersave status indications",
#endif
    RNR_QUAD_GENERAL_CONFIG_POWERSAVE_STATUS_REG_OFFSET,
    0,
    0,
    360,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    9,
    RNR_QUAD_GENERAL_CONFIG_POWERSAVE_STATUS_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_0_CFG
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_0_CFG_FIELDS[] =
{
    &RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_0_CFG_DATA_ADDR_START_FIELD,
    &RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_0_CFG_DATA_ADDR_STOP_FIELD,
    &RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_0_CFG_THREAD_FIELD,
    &RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_0_CFG_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_0_CFG_REG = 
{
    "GENERAL_CONFIG_DATA_BKPT_0_CFG",
#if RU_INCLUDE_DESC
    "DATA_BKPT_CFG_0 Register",
    "DATA Breakpoint 0 configuration.",
#endif
    RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_0_CFG_REG_OFFSET,
    0,
    0,
    361,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    4,
    RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_0_CFG_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_1_CFG
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_1_CFG_FIELDS[] =
{
    &RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_1_CFG_DATA_ADDR_START_FIELD,
    &RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_1_CFG_DATA_ADDR_STOP_FIELD,
    &RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_1_CFG_THREAD_FIELD,
    &RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_1_CFG_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_1_CFG_REG = 
{
    "GENERAL_CONFIG_DATA_BKPT_1_CFG",
#if RU_INCLUDE_DESC
    "DATA_BKPT_CFG_1 Register",
    "DATA Breakpoint 1 configuration.",
#endif
    RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_1_CFG_REG_OFFSET,
    0,
    0,
    362,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    4,
    RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_1_CFG_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_2_CFG
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_2_CFG_FIELDS[] =
{
    &RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_2_CFG_DATA_ADDR_START_FIELD,
    &RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_2_CFG_DATA_ADDR_STOP_FIELD,
    &RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_2_CFG_THREAD_FIELD,
    &RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_2_CFG_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_2_CFG_REG = 
{
    "GENERAL_CONFIG_DATA_BKPT_2_CFG",
#if RU_INCLUDE_DESC
    "DATA_BKPT_CFG_2 Register",
    "DATA Breakpoint 2 configuration.",
#endif
    RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_2_CFG_REG_OFFSET,
    0,
    0,
    363,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    4,
    RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_2_CFG_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_3_CFG
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_3_CFG_FIELDS[] =
{
    &RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_3_CFG_DATA_ADDR_START_FIELD,
    &RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_3_CFG_DATA_ADDR_STOP_FIELD,
    &RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_3_CFG_THREAD_FIELD,
    &RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_3_CFG_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_3_CFG_REG = 
{
    "GENERAL_CONFIG_DATA_BKPT_3_CFG",
#if RU_INCLUDE_DESC
    "DATA_BKPT_CFG_3 Register",
    "DATA Breakpoint 3 configuration.",
#endif
    RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_3_CFG_REG_OFFSET,
    0,
    0,
    364,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    4,
    RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_3_CFG_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_QUAD_GENERAL_CONFIG_UBUS_COUNTER_CONTROL
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_QUAD_GENERAL_CONFIG_UBUS_COUNTER_CONTROL_FIELDS[] =
{
    &RNR_QUAD_GENERAL_CONFIG_UBUS_COUNTER_CONTROL_ENABLE_STATISTICS_FIELD,
    &RNR_QUAD_GENERAL_CONFIG_UBUS_COUNTER_CONTROL_RESERVED0_FIELD,
    &RNR_QUAD_GENERAL_CONFIG_UBUS_COUNTER_CONTROL_SW_RESET_FIELD,
    &RNR_QUAD_GENERAL_CONFIG_UBUS_COUNTER_CONTROL_RESERVED1_FIELD,
    &RNR_QUAD_GENERAL_CONFIG_UBUS_COUNTER_CONTROL_DEST_PID_FIELD,
    &RNR_QUAD_GENERAL_CONFIG_UBUS_COUNTER_CONTROL_MASTER_SELECT_FIELD,
    &RNR_QUAD_GENERAL_CONFIG_UBUS_COUNTER_CONTROL_RESERVED2_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_QUAD_GENERAL_CONFIG_UBUS_COUNTER_CONTROL_REG = 
{
    "GENERAL_CONFIG_UBUS_COUNTER_CONTROL",
#if RU_INCLUDE_DESC
    "UBUS_COUNTER_CONTROL Register",
    "UBUS Counters Control",
#endif
    RNR_QUAD_GENERAL_CONFIG_UBUS_COUNTER_CONTROL_REG_OFFSET,
    0,
    0,
    365,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    7,
    RNR_QUAD_GENERAL_CONFIG_UBUS_COUNTER_CONTROL_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_QUAD_GENERAL_CONFIG_UBUS_DOWN_COUNTER
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_QUAD_GENERAL_CONFIG_UBUS_DOWN_COUNTER_FIELDS[] =
{
    &RNR_QUAD_GENERAL_CONFIG_UBUS_DOWN_COUNTER_DOWNCNT_VALUE_FIELD,
    &RNR_QUAD_GENERAL_CONFIG_UBUS_DOWN_COUNTER_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_QUAD_GENERAL_CONFIG_UBUS_DOWN_COUNTER_REG = 
{
    "GENERAL_CONFIG_UBUS_DOWN_COUNTER",
#if RU_INCLUDE_DESC
    "UBUS_DOWN_COUNTER Register",
    "When Statistics are enabled this counter counts down, while its not 0 the statistics are collected - i.e below statistics are updated as long as this counter counts down.",
#endif
    RNR_QUAD_GENERAL_CONFIG_UBUS_DOWN_COUNTER_REG_OFFSET,
    0,
    0,
    366,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    2,
    RNR_QUAD_GENERAL_CONFIG_UBUS_DOWN_COUNTER_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_QUAD_GENERAL_CONFIG_ALL_XFERS_CNT
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_QUAD_GENERAL_CONFIG_ALL_XFERS_CNT_FIELDS[] =
{
    &RNR_QUAD_GENERAL_CONFIG_ALL_XFERS_CNT_COUNTER_VALUE_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_QUAD_GENERAL_CONFIG_ALL_XFERS_CNT_REG = 
{
    "GENERAL_CONFIG_ALL_XFERS_CNT",
#if RU_INCLUDE_DESC
    "ALL_XFERS_CNT Register",
    "Count all issued master UBUS transactions (read,write etc) - 32 bit"
    ""
    "Count 1 for each of the following transactions:"
    "For UBUS 4 , count ubus4_rd (code = 4),ubus4_wr (code = 0), ubus4_wr_rply (code = 2)"
    "For UBUS 4.1 count ubus4_rd (code = 4),ubus4_wr (code = 0), ubus4_wr_sync (code = 2)"
    ""
    ""
    "",
#endif
    RNR_QUAD_GENERAL_CONFIG_ALL_XFERS_CNT_REG_OFFSET,
    0,
    0,
    367,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    RNR_QUAD_GENERAL_CONFIG_ALL_XFERS_CNT_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_QUAD_GENERAL_CONFIG_READ_XFERS_CNT
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_QUAD_GENERAL_CONFIG_READ_XFERS_CNT_FIELDS[] =
{
    &RNR_QUAD_GENERAL_CONFIG_READ_XFERS_CNT_COUNTER_VALUE_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_QUAD_GENERAL_CONFIG_READ_XFERS_CNT_REG = 
{
    "GENERAL_CONFIG_READ_XFERS_CNT",
#if RU_INCLUDE_DESC
    "READ_XFERS_CNT Register",
    "count only UBUS master read transactions   - 32 bit"
    "For UBUS 4, 4.1 , count ubus4_rd (code = 4)"
    "",
#endif
    RNR_QUAD_GENERAL_CONFIG_READ_XFERS_CNT_REG_OFFSET,
    0,
    0,
    368,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    RNR_QUAD_GENERAL_CONFIG_READ_XFERS_CNT_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_QUAD_GENERAL_CONFIG_READ_DATA_CNT
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_QUAD_GENERAL_CONFIG_READ_DATA_CNT_FIELDS[] =
{
    &RNR_QUAD_GENERAL_CONFIG_READ_DATA_CNT_COUNTER_VALUE_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_QUAD_GENERAL_CONFIG_READ_DATA_CNT_REG = 
{
    "GENERAL_CONFIG_READ_DATA_CNT",
#if RU_INCLUDE_DESC
    "READ_DATA_CNT Register",
    "accumulate dlen of all read transaction - 32 bit"
    "Add dlen value of transaction of the following type:"
    "For UBUS 4, 4.1 , count ubus4_rd (code = 4)"
    "",
#endif
    RNR_QUAD_GENERAL_CONFIG_READ_DATA_CNT_REG_OFFSET,
    0,
    0,
    369,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    RNR_QUAD_GENERAL_CONFIG_READ_DATA_CNT_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_QUAD_GENERAL_CONFIG_WRITE_DATA_CNT
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_QUAD_GENERAL_CONFIG_WRITE_DATA_CNT_FIELDS[] =
{
    &RNR_QUAD_GENERAL_CONFIG_WRITE_DATA_CNT_COUNTER_VALUE_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_QUAD_GENERAL_CONFIG_WRITE_DATA_CNT_REG = 
{
    "GENERAL_CONFIG_WRITE_DATA_CNT",
#if RU_INCLUDE_DESC
    "WRITE_DATA_CNT Register",
    "Accumulate dlen of all write transactions - 32 bit"
    ""
    "Add dlen value of transaction of the following type:"
    ""
    "For UBUS 4.0 - ubus4_wr (code = 0), ubus4_wr_rply (code = 2)"
    "For UBUS 4.1 - ubus4_wr (code = 0), ubus4_wr_sync (code = 2)"
    ""
    "",
#endif
    RNR_QUAD_GENERAL_CONFIG_WRITE_DATA_CNT_REG_OFFSET,
    0,
    0,
    370,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    RNR_QUAD_GENERAL_CONFIG_WRITE_DATA_CNT_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_QUAD_DEBUG_FIFO_CONFIG
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_QUAD_DEBUG_FIFO_CONFIG_FIELDS[] =
{
    &RNR_QUAD_DEBUG_FIFO_CONFIG_PSRAM_HDR_SW_RST_FIELD,
    &RNR_QUAD_DEBUG_FIFO_CONFIG_PSRAM_DATA_SW_RST_FIELD,
    &RNR_QUAD_DEBUG_FIFO_CONFIG_DDR_HDR_SW_RST_FIELD,
    &RNR_QUAD_DEBUG_FIFO_CONFIG_RESERVED0_FIELD,
    &RNR_QUAD_DEBUG_FIFO_CONFIG_PSRAM_HDR_SW_RD_ADDR_FIELD,
    &RNR_QUAD_DEBUG_FIFO_CONFIG_PSRAM_DATA_SW_RD_ADDR_FIELD,
    &RNR_QUAD_DEBUG_FIFO_CONFIG_DDR_HDR_SW_RD_ADDR_FIELD,
    &RNR_QUAD_DEBUG_FIFO_CONFIG_RESERVED1_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_QUAD_DEBUG_FIFO_CONFIG_REG = 
{
    "DEBUG_FIFO_CONFIG",
#if RU_INCLUDE_DESC
    "FIFO_CONFIG Register",
    "FIFOs configuration",
#endif
    RNR_QUAD_DEBUG_FIFO_CONFIG_REG_OFFSET,
    0,
    0,
    371,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    8,
    RNR_QUAD_DEBUG_FIFO_CONFIG_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_QUAD_DEBUG_PSRAM_HDR_FIFO_STATUS
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_QUAD_DEBUG_PSRAM_HDR_FIFO_STATUS_FIELDS[] =
{
    &RNR_QUAD_DEBUG_PSRAM_HDR_FIFO_STATUS_FULL_FIELD,
    &RNR_QUAD_DEBUG_PSRAM_HDR_FIFO_STATUS_EMPTY_FIELD,
    &RNR_QUAD_DEBUG_PSRAM_HDR_FIFO_STATUS_RESERVED0_FIELD,
    &RNR_QUAD_DEBUG_PSRAM_HDR_FIFO_STATUS_PUSH_WR_CNTR_FIELD,
    &RNR_QUAD_DEBUG_PSRAM_HDR_FIFO_STATUS_RESERVED1_FIELD,
    &RNR_QUAD_DEBUG_PSRAM_HDR_FIFO_STATUS_POP_RD_CNTR_FIELD,
    &RNR_QUAD_DEBUG_PSRAM_HDR_FIFO_STATUS_RESERVED2_FIELD,
    &RNR_QUAD_DEBUG_PSRAM_HDR_FIFO_STATUS_USED_WORDS_FIELD,
    &RNR_QUAD_DEBUG_PSRAM_HDR_FIFO_STATUS_RESERVED3_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_QUAD_DEBUG_PSRAM_HDR_FIFO_STATUS_REG = 
{
    "DEBUG_PSRAM_HDR_FIFO_STATUS",
#if RU_INCLUDE_DESC
    "PSRAM_HDR_FIFO_STATUS Register",
    "PSRAM Header FIFO status",
#endif
    RNR_QUAD_DEBUG_PSRAM_HDR_FIFO_STATUS_REG_OFFSET,
    0,
    0,
    372,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    9,
    RNR_QUAD_DEBUG_PSRAM_HDR_FIFO_STATUS_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_QUAD_DEBUG_PSRAM_DATA_FIFO_STATUS
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_QUAD_DEBUG_PSRAM_DATA_FIFO_STATUS_FIELDS[] =
{
    &RNR_QUAD_DEBUG_PSRAM_DATA_FIFO_STATUS_FULL_FIELD,
    &RNR_QUAD_DEBUG_PSRAM_DATA_FIFO_STATUS_EMPTY_FIELD,
    &RNR_QUAD_DEBUG_PSRAM_DATA_FIFO_STATUS_ALMOST_FULL_FIELD,
    &RNR_QUAD_DEBUG_PSRAM_DATA_FIFO_STATUS_RESERVED0_FIELD,
    &RNR_QUAD_DEBUG_PSRAM_DATA_FIFO_STATUS_PUSH_WR_CNTR_FIELD,
    &RNR_QUAD_DEBUG_PSRAM_DATA_FIFO_STATUS_RESERVED1_FIELD,
    &RNR_QUAD_DEBUG_PSRAM_DATA_FIFO_STATUS_POP_RD_CNTR_FIELD,
    &RNR_QUAD_DEBUG_PSRAM_DATA_FIFO_STATUS_RESERVED2_FIELD,
    &RNR_QUAD_DEBUG_PSRAM_DATA_FIFO_STATUS_USED_WORDS_FIELD,
    &RNR_QUAD_DEBUG_PSRAM_DATA_FIFO_STATUS_RESERVED3_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_QUAD_DEBUG_PSRAM_DATA_FIFO_STATUS_REG = 
{
    "DEBUG_PSRAM_DATA_FIFO_STATUS",
#if RU_INCLUDE_DESC
    "PSRAM_DATA_FIFO_STATUS Register",
    "PSRAM Data FIFO status",
#endif
    RNR_QUAD_DEBUG_PSRAM_DATA_FIFO_STATUS_REG_OFFSET,
    0,
    0,
    373,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    10,
    RNR_QUAD_DEBUG_PSRAM_DATA_FIFO_STATUS_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_QUAD_DEBUG_DDR_HDR_FIFO_STATUS
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_QUAD_DEBUG_DDR_HDR_FIFO_STATUS_FIELDS[] =
{
    &RNR_QUAD_DEBUG_DDR_HDR_FIFO_STATUS_FULL_FIELD,
    &RNR_QUAD_DEBUG_DDR_HDR_FIFO_STATUS_EMPTY_FIELD,
    &RNR_QUAD_DEBUG_DDR_HDR_FIFO_STATUS_RESERVED0_FIELD,
    &RNR_QUAD_DEBUG_DDR_HDR_FIFO_STATUS_PUSH_WR_CNTR_FIELD,
    &RNR_QUAD_DEBUG_DDR_HDR_FIFO_STATUS_RESERVED1_FIELD,
    &RNR_QUAD_DEBUG_DDR_HDR_FIFO_STATUS_POP_RD_CNTR_FIELD,
    &RNR_QUAD_DEBUG_DDR_HDR_FIFO_STATUS_RESERVED2_FIELD,
    &RNR_QUAD_DEBUG_DDR_HDR_FIFO_STATUS_USED_WORDS_FIELD,
    &RNR_QUAD_DEBUG_DDR_HDR_FIFO_STATUS_RESERVED3_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_QUAD_DEBUG_DDR_HDR_FIFO_STATUS_REG = 
{
    "DEBUG_DDR_HDR_FIFO_STATUS",
#if RU_INCLUDE_DESC
    "DDR_HDR_FIFO_STATUS Register",
    "DDR Header FIFO status",
#endif
    RNR_QUAD_DEBUG_DDR_HDR_FIFO_STATUS_REG_OFFSET,
    0,
    0,
    374,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    9,
    RNR_QUAD_DEBUG_DDR_HDR_FIFO_STATUS_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_QUAD_DEBUG_DDR_DATA_FIFO_STATUS
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_QUAD_DEBUG_DDR_DATA_FIFO_STATUS_FIELDS[] =
{
    &RNR_QUAD_DEBUG_DDR_DATA_FIFO_STATUS_FULL_FIELD,
    &RNR_QUAD_DEBUG_DDR_DATA_FIFO_STATUS_EMPTY_FIELD,
    &RNR_QUAD_DEBUG_DDR_DATA_FIFO_STATUS_ALMOST_FULL_FIELD,
    &RNR_QUAD_DEBUG_DDR_DATA_FIFO_STATUS_RESERVED0_FIELD,
    &RNR_QUAD_DEBUG_DDR_DATA_FIFO_STATUS_WR_CNTR_FIELD,
    &RNR_QUAD_DEBUG_DDR_DATA_FIFO_STATUS_RESERVED1_FIELD,
    &RNR_QUAD_DEBUG_DDR_DATA_FIFO_STATUS_RD_CNTR_FIELD,
    &RNR_QUAD_DEBUG_DDR_DATA_FIFO_STATUS_RESERVED2_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_QUAD_DEBUG_DDR_DATA_FIFO_STATUS_REG = 
{
    "DEBUG_DDR_DATA_FIFO_STATUS",
#if RU_INCLUDE_DESC
    "DDR_DATA_FIFO_STATUS Register",
    "DDR Data FIFO status",
#endif
    RNR_QUAD_DEBUG_DDR_DATA_FIFO_STATUS_REG_OFFSET,
    0,
    0,
    375,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    8,
    RNR_QUAD_DEBUG_DDR_DATA_FIFO_STATUS_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_QUAD_DEBUG_DDR_DATA_FIFO_STATUS2
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_QUAD_DEBUG_DDR_DATA_FIFO_STATUS2_FIELDS[] =
{
    &RNR_QUAD_DEBUG_DDR_DATA_FIFO_STATUS2_READ_ADDR_FIELD,
    &RNR_QUAD_DEBUG_DDR_DATA_FIFO_STATUS2_USED_WORDS_FIELD,
    &RNR_QUAD_DEBUG_DDR_DATA_FIFO_STATUS2_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_QUAD_DEBUG_DDR_DATA_FIFO_STATUS2_REG = 
{
    "DEBUG_DDR_DATA_FIFO_STATUS2",
#if RU_INCLUDE_DESC
    "DDR_DATA_FIFO_STATUS2 Register",
    "DDR Data FIFO status 2",
#endif
    RNR_QUAD_DEBUG_DDR_DATA_FIFO_STATUS2_REG_OFFSET,
    0,
    0,
    376,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    3,
    RNR_QUAD_DEBUG_DDR_DATA_FIFO_STATUS2_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_QUAD_DEBUG_PSRAM_HDR_FIFO_DATA1
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_QUAD_DEBUG_PSRAM_HDR_FIFO_DATA1_FIELDS[] =
{
    &RNR_QUAD_DEBUG_PSRAM_HDR_FIFO_DATA1_DATA_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_QUAD_DEBUG_PSRAM_HDR_FIFO_DATA1_REG = 
{
    "DEBUG_PSRAM_HDR_FIFO_DATA1",
#if RU_INCLUDE_DESC
    "PSRAM_HDR_FIFO_DATA1 Register",
    "Read contents of FIFO memory",
#endif
    RNR_QUAD_DEBUG_PSRAM_HDR_FIFO_DATA1_REG_OFFSET,
    0,
    0,
    377,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    RNR_QUAD_DEBUG_PSRAM_HDR_FIFO_DATA1_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_QUAD_DEBUG_PSRAM_HDR_FIFO_DATA2
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_QUAD_DEBUG_PSRAM_HDR_FIFO_DATA2_FIELDS[] =
{
    &RNR_QUAD_DEBUG_PSRAM_HDR_FIFO_DATA2_DATA_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_QUAD_DEBUG_PSRAM_HDR_FIFO_DATA2_REG = 
{
    "DEBUG_PSRAM_HDR_FIFO_DATA2",
#if RU_INCLUDE_DESC
    "PSRAM_HDR_FIFO_DATA2 Register",
    "Read contents of FIFO memory",
#endif
    RNR_QUAD_DEBUG_PSRAM_HDR_FIFO_DATA2_REG_OFFSET,
    0,
    0,
    378,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    RNR_QUAD_DEBUG_PSRAM_HDR_FIFO_DATA2_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_QUAD_DEBUG_PSRAM_DATA_FIFO_DATA1
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_QUAD_DEBUG_PSRAM_DATA_FIFO_DATA1_FIELDS[] =
{
    &RNR_QUAD_DEBUG_PSRAM_DATA_FIFO_DATA1_DATA_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_QUAD_DEBUG_PSRAM_DATA_FIFO_DATA1_REG = 
{
    "DEBUG_PSRAM_DATA_FIFO_DATA1",
#if RU_INCLUDE_DESC
    "PSRAM_DATA_FIFO_DATA1 Register",
    "Read contents of FIFO memory",
#endif
    RNR_QUAD_DEBUG_PSRAM_DATA_FIFO_DATA1_REG_OFFSET,
    0,
    0,
    379,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    RNR_QUAD_DEBUG_PSRAM_DATA_FIFO_DATA1_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_QUAD_DEBUG_PSRAM_DATA_FIFO_DATA2
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_QUAD_DEBUG_PSRAM_DATA_FIFO_DATA2_FIELDS[] =
{
    &RNR_QUAD_DEBUG_PSRAM_DATA_FIFO_DATA2_DATA_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_QUAD_DEBUG_PSRAM_DATA_FIFO_DATA2_REG = 
{
    "DEBUG_PSRAM_DATA_FIFO_DATA2",
#if RU_INCLUDE_DESC
    "PSRAM_DATA_FIFO_DATA2 Register",
    "Read contents of FIFO memory",
#endif
    RNR_QUAD_DEBUG_PSRAM_DATA_FIFO_DATA2_REG_OFFSET,
    0,
    0,
    380,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    RNR_QUAD_DEBUG_PSRAM_DATA_FIFO_DATA2_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_QUAD_DEBUG_DDR_HDR_FIFO_DATA1
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_QUAD_DEBUG_DDR_HDR_FIFO_DATA1_FIELDS[] =
{
    &RNR_QUAD_DEBUG_DDR_HDR_FIFO_DATA1_DATA_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_QUAD_DEBUG_DDR_HDR_FIFO_DATA1_REG = 
{
    "DEBUG_DDR_HDR_FIFO_DATA1",
#if RU_INCLUDE_DESC
    "DDR_HDR_FIFO_DATA1 Register",
    "Read contents of FIFO memory",
#endif
    RNR_QUAD_DEBUG_DDR_HDR_FIFO_DATA1_REG_OFFSET,
    0,
    0,
    381,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    RNR_QUAD_DEBUG_DDR_HDR_FIFO_DATA1_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_QUAD_DEBUG_DDR_HDR_FIFO_DATA2
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_QUAD_DEBUG_DDR_HDR_FIFO_DATA2_FIELDS[] =
{
    &RNR_QUAD_DEBUG_DDR_HDR_FIFO_DATA2_DATA_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_QUAD_DEBUG_DDR_HDR_FIFO_DATA2_REG = 
{
    "DEBUG_DDR_HDR_FIFO_DATA2",
#if RU_INCLUDE_DESC
    "DDR_HDR_FIFO_DATA2 Register",
    "Read contents of FIFO memory",
#endif
    RNR_QUAD_DEBUG_DDR_HDR_FIFO_DATA2_REG_OFFSET,
    0,
    0,
    382,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    RNR_QUAD_DEBUG_DDR_HDR_FIFO_DATA2_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_QUAD_EXT_FLOWCTRL_CONFIG_TOKEN_VAL
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_QUAD_EXT_FLOWCTRL_CONFIG_TOKEN_VAL_FIELDS[] =
{
    &RNR_QUAD_EXT_FLOWCTRL_CONFIG_TOKEN_VAL_VAL_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_QUAD_EXT_FLOWCTRL_CONFIG_TOKEN_VAL_REG = 
{
    "EXT_FLOWCTRL_CONFIG_TOKEN_VAL",
#if RU_INCLUDE_DESC
    "TOKEN %i Register",
    "Token value for flow control",
#endif
    RNR_QUAD_EXT_FLOWCTRL_CONFIG_TOKEN_VAL_REG_OFFSET,
    RNR_QUAD_EXT_FLOWCTRL_CONFIG_TOKEN_VAL_REG_RAM_CNT,
    4,
    383,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    RNR_QUAD_EXT_FLOWCTRL_CONFIG_TOKEN_VAL_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_QUAD_EXT_FLOWCTRL_CONFIG2_TOKEN_VAL_2
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_QUAD_EXT_FLOWCTRL_CONFIG2_TOKEN_VAL_2_FIELDS[] =
{
    &RNR_QUAD_EXT_FLOWCTRL_CONFIG2_TOKEN_VAL_2_VAL_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_QUAD_EXT_FLOWCTRL_CONFIG2_TOKEN_VAL_2_REG = 
{
    "EXT_FLOWCTRL_CONFIG2_TOKEN_VAL_2",
#if RU_INCLUDE_DESC
    "TOKEN2 %i Register",
    "Token value for flow control",
#endif
    RNR_QUAD_EXT_FLOWCTRL_CONFIG2_TOKEN_VAL_2_REG_OFFSET,
    RNR_QUAD_EXT_FLOWCTRL_CONFIG2_TOKEN_VAL_2_REG_RAM_CNT,
    4,
    384,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    RNR_QUAD_EXT_FLOWCTRL_CONFIG2_TOKEN_VAL_2_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_QUAD_UBUS_DECODE_CFG_PSRAM_UBUS_DECODE
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_QUAD_UBUS_DECODE_CFG_PSRAM_UBUS_DECODE_FIELDS[] =
{
    &RNR_QUAD_UBUS_DECODE_CFG_PSRAM_UBUS_DECODE_VAL_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_QUAD_UBUS_DECODE_CFG_PSRAM_UBUS_DECODE_REG = 
{
    "UBUS_DECODE_CFG_PSRAM_UBUS_DECODE",
#if RU_INCLUDE_DESC
    "PSRAM_UBUS_DECODE %i Register",
    "Decode for PSRAM Queue",
#endif
    RNR_QUAD_UBUS_DECODE_CFG_PSRAM_UBUS_DECODE_REG_OFFSET,
    RNR_QUAD_UBUS_DECODE_CFG_PSRAM_UBUS_DECODE_REG_RAM_CNT,
    4,
    385,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    RNR_QUAD_UBUS_DECODE_CFG_PSRAM_UBUS_DECODE_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_QUAD_UBUS_DECODE_CFG_DDR_UBUS_DECODE
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_QUAD_UBUS_DECODE_CFG_DDR_UBUS_DECODE_FIELDS[] =
{
    &RNR_QUAD_UBUS_DECODE_CFG_DDR_UBUS_DECODE_VAL_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_QUAD_UBUS_DECODE_CFG_DDR_UBUS_DECODE_REG = 
{
    "UBUS_DECODE_CFG_DDR_UBUS_DECODE",
#if RU_INCLUDE_DESC
    "DDR_UBUS_DECODE %i Register",
    "Decode for DDR Queue",
#endif
    RNR_QUAD_UBUS_DECODE_CFG_DDR_UBUS_DECODE_REG_OFFSET,
    RNR_QUAD_UBUS_DECODE_CFG_DDR_UBUS_DECODE_REG_RAM_CNT,
    4,
    386,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    RNR_QUAD_UBUS_DECODE_CFG_DDR_UBUS_DECODE_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_QUAD_UBUS_DECODE_CFG2_PSRAM_UBUS_DECODE2
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_QUAD_UBUS_DECODE_CFG2_PSRAM_UBUS_DECODE2_FIELDS[] =
{
    &RNR_QUAD_UBUS_DECODE_CFG2_PSRAM_UBUS_DECODE2_VAL_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_QUAD_UBUS_DECODE_CFG2_PSRAM_UBUS_DECODE2_REG = 
{
    "UBUS_DECODE_CFG2_PSRAM_UBUS_DECODE2",
#if RU_INCLUDE_DESC
    "PSRAM_UBUS_DECODE2 %i Register",
    "Decode for PSRAM Queue",
#endif
    RNR_QUAD_UBUS_DECODE_CFG2_PSRAM_UBUS_DECODE2_REG_OFFSET,
    RNR_QUAD_UBUS_DECODE_CFG2_PSRAM_UBUS_DECODE2_REG_RAM_CNT,
    4,
    387,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    RNR_QUAD_UBUS_DECODE_CFG2_PSRAM_UBUS_DECODE2_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: RNR_QUAD_UBUS_DECODE_CFG2_DDR_UBUS_DECODE2
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *RNR_QUAD_UBUS_DECODE_CFG2_DDR_UBUS_DECODE2_FIELDS[] =
{
    &RNR_QUAD_UBUS_DECODE_CFG2_DDR_UBUS_DECODE2_VAL_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec RNR_QUAD_UBUS_DECODE_CFG2_DDR_UBUS_DECODE2_REG = 
{
    "UBUS_DECODE_CFG2_DDR_UBUS_DECODE2",
#if RU_INCLUDE_DESC
    "DDR_UBUS_DECODE2 %i Register",
    "Decode for DDR Queue",
#endif
    RNR_QUAD_UBUS_DECODE_CFG2_DDR_UBUS_DECODE2_REG_OFFSET,
    RNR_QUAD_UBUS_DECODE_CFG2_DDR_UBUS_DECODE2_REG_RAM_CNT,
    4,
    388,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    RNR_QUAD_UBUS_DECODE_CFG2_DDR_UBUS_DECODE2_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Block: RNR_QUAD
 ******************************************************************************/
static const ru_reg_rec *RNR_QUAD_REGS[] =
{
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_ENG_REG,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_PARSER_MISC_CFG_REG,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_0_1_REG,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_2_3_REG,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_4_5_REG,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_VID_6_7_REG,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_IP_FILTER0_CFG_REG,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_IP_FILTER1_CFG_REG,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_IP_FILTER0_MASK_CFG_REG,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_IP_FILTER1_MASK_CFG_REG,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_IP_FILTERS_CFG_REG,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_SNAP_ORG_CODE_REG,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_PPP_IP_PROT_CODE_REG,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_ETHTYPE_REG,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_0_1_REG,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_2_3_REG,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_ETHTYPE_CONFIG_REG,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_IPV6_HDR_EXT_FLTR_MASK_CFG_REG,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_NEST_REG,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_HARD_NEST_0_REG,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_HARD_NEST_1_REG,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_QTAG_HARD_NEST_2_REG,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_USER_IP_PROT_REG,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT0_VAL_L_REG,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT0_VAL_H_REG,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT1_VAL_L_REG,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT1_VAL_H_REG,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT2_VAL_L_REG,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT2_VAL_H_REG,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT3_VAL_L_REG,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT3_VAL_H_REG,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT4_VAL_L_REG,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT4_VAL_H_REG,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT5_VAL_L_REG,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT5_VAL_H_REG,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT6_VAL_L_REG,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT6_VAL_H_REG,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT7_VAL_L_REG,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT7_VAL_H_REG,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT8_VAL_L_REG,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT8_VAL_H_REG,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT0_MASK_L_REG,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT0_MASK_H_REG,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT1_MASK_L_REG,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT1_MASK_H_REG,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_0_REG,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_1_REG,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_DA_FILT_VALID_CFG_2_REG,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_GRE_PROTOCOL_CFG_REG,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_PROP_TAG_CFG_REG,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_DOS_ATTACK_REG,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_ICMP_MAX_SIZE_REG,
    &RNR_QUAD_PARSER_CORE_CONFIGURATION_KEY_CFG_REG,
    &RNR_QUAD_GENERAL_CONFIG_DMA_ARB_CFG_REG,
    &RNR_QUAD_GENERAL_CONFIG_PSRAM0_BASE_REG,
    &RNR_QUAD_GENERAL_CONFIG_PSRAM1_BASE_REG,
    &RNR_QUAD_GENERAL_CONFIG_PSRAM2_BASE_REG,
    &RNR_QUAD_GENERAL_CONFIG_PSRAM3_BASE_REG,
    &RNR_QUAD_GENERAL_CONFIG_DDR0_BASE_REG,
    &RNR_QUAD_GENERAL_CONFIG_DDR1_BASE_REG,
    &RNR_QUAD_GENERAL_CONFIG_PSRAM0_MASK_REG,
    &RNR_QUAD_GENERAL_CONFIG_PSRAM1_MASK_REG,
    &RNR_QUAD_GENERAL_CONFIG_PSRAM2_MASK_REG,
    &RNR_QUAD_GENERAL_CONFIG_PSRAM3_MASK_REG,
    &RNR_QUAD_GENERAL_CONFIG_DDR0_MASK_REG,
    &RNR_QUAD_GENERAL_CONFIG_DDR1_MASK_REG,
    &RNR_QUAD_GENERAL_CONFIG_PROFILING_CONFIG_REG,
    &RNR_QUAD_GENERAL_CONFIG_BKPT_0_CFG_REG,
    &RNR_QUAD_GENERAL_CONFIG_BKPT_1_CFG_REG,
    &RNR_QUAD_GENERAL_CONFIG_BKPT_2_CFG_REG,
    &RNR_QUAD_GENERAL_CONFIG_BKPT_3_CFG_REG,
    &RNR_QUAD_GENERAL_CONFIG_BKPT_4_CFG_REG,
    &RNR_QUAD_GENERAL_CONFIG_BKPT_5_CFG_REG,
    &RNR_QUAD_GENERAL_CONFIG_BKPT_6_CFG_REG,
    &RNR_QUAD_GENERAL_CONFIG_BKPT_7_CFG_REG,
    &RNR_QUAD_GENERAL_CONFIG_BKPT_GEN_CFG_REG,
    &RNR_QUAD_GENERAL_CONFIG_POWERSAVE_CONFIG_REG,
    &RNR_QUAD_GENERAL_CONFIG_POWERSAVE_STATUS_REG,
    &RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_0_CFG_REG,
    &RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_1_CFG_REG,
    &RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_2_CFG_REG,
    &RNR_QUAD_GENERAL_CONFIG_DATA_BKPT_3_CFG_REG,
    &RNR_QUAD_GENERAL_CONFIG_UBUS_COUNTER_CONTROL_REG,
    &RNR_QUAD_GENERAL_CONFIG_UBUS_DOWN_COUNTER_REG,
    &RNR_QUAD_GENERAL_CONFIG_ALL_XFERS_CNT_REG,
    &RNR_QUAD_GENERAL_CONFIG_READ_XFERS_CNT_REG,
    &RNR_QUAD_GENERAL_CONFIG_READ_DATA_CNT_REG,
    &RNR_QUAD_GENERAL_CONFIG_WRITE_DATA_CNT_REG,
    &RNR_QUAD_DEBUG_FIFO_CONFIG_REG,
    &RNR_QUAD_DEBUG_PSRAM_HDR_FIFO_STATUS_REG,
    &RNR_QUAD_DEBUG_PSRAM_DATA_FIFO_STATUS_REG,
    &RNR_QUAD_DEBUG_DDR_HDR_FIFO_STATUS_REG,
    &RNR_QUAD_DEBUG_DDR_DATA_FIFO_STATUS_REG,
    &RNR_QUAD_DEBUG_DDR_DATA_FIFO_STATUS2_REG,
    &RNR_QUAD_DEBUG_PSRAM_HDR_FIFO_DATA1_REG,
    &RNR_QUAD_DEBUG_PSRAM_HDR_FIFO_DATA2_REG,
    &RNR_QUAD_DEBUG_PSRAM_DATA_FIFO_DATA1_REG,
    &RNR_QUAD_DEBUG_PSRAM_DATA_FIFO_DATA2_REG,
    &RNR_QUAD_DEBUG_DDR_HDR_FIFO_DATA1_REG,
    &RNR_QUAD_DEBUG_DDR_HDR_FIFO_DATA2_REG,
    &RNR_QUAD_EXT_FLOWCTRL_CONFIG_TOKEN_VAL_REG,
    &RNR_QUAD_EXT_FLOWCTRL_CONFIG2_TOKEN_VAL_2_REG,
    &RNR_QUAD_UBUS_DECODE_CFG_PSRAM_UBUS_DECODE_REG,
    &RNR_QUAD_UBUS_DECODE_CFG_DDR_UBUS_DECODE_REG,
    &RNR_QUAD_UBUS_DECODE_CFG2_PSRAM_UBUS_DECODE2_REG,
    &RNR_QUAD_UBUS_DECODE_CFG2_DDR_UBUS_DECODE2_REG,
};

unsigned long RNR_QUAD_ADDRS[] =
{
    0x82808400,
};

const ru_block_rec RNR_QUAD_BLOCK = 
{
    "RNR_QUAD",
    RNR_QUAD_ADDRS,
    1,
    106,
    RNR_QUAD_REGS
};

/* End of file XRDP_RNR_QUAD.c */
