/*
   Copyright (c) 2015 Broadcom
   All Rights Reserved

    <:label-BRCM:2015:DUAL/GPL:standard
    
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License, version 2, as published by
    the Free Software Foundation (the "GPL").
    
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
    
    
    A copy of the GPL is available at http://www.broadcom.com/licenses/GPLv2.php, or by
    writing to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
    
:>
*/

#include "ru.h"

#if RU_INCLUDE_FIELD_DB
/******************************************************************************
 * Field: QM_GLOBAL_CFG_QM_ENABLE_CTRL_FPM_PREFETCH_ENABLE
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_QM_ENABLE_CTRL_FPM_PREFETCH_ENABLE_FIELD =
{
    "FPM_PREFETCH_ENABLE",
#if RU_INCLUDE_DESC
    "FPM_PREFETCH_ENABLE",
    "FPM Prefetch Enable. Setting this bit to 1 will start filling up the FPM pool prefetch FIFOs."
    "Seeting this bit to 0, will stop FPM prefetches.",
#endif
    QM_GLOBAL_CFG_QM_ENABLE_CTRL_FPM_PREFETCH_ENABLE_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_QM_ENABLE_CTRL_FPM_PREFETCH_ENABLE_FIELD_WIDTH,
    QM_GLOBAL_CFG_QM_ENABLE_CTRL_FPM_PREFETCH_ENABLE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_QM_ENABLE_CTRL_REORDER_CREDIT_ENABLE
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_QM_ENABLE_CTRL_REORDER_CREDIT_ENABLE_FIELD =
{
    "REORDER_CREDIT_ENABLE",
#if RU_INCLUDE_DESC
    "REORDER_CREDIT_ENABLE",
    "When this bit is set the QM will send credits to the REORDER block."
    "Disabling this bit will stop sending credits to the reorder.",
#endif
    QM_GLOBAL_CFG_QM_ENABLE_CTRL_REORDER_CREDIT_ENABLE_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_QM_ENABLE_CTRL_REORDER_CREDIT_ENABLE_FIELD_WIDTH,
    QM_GLOBAL_CFG_QM_ENABLE_CTRL_REORDER_CREDIT_ENABLE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_QM_ENABLE_CTRL_DQM_POP_ENABLE
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_QM_ENABLE_CTRL_DQM_POP_ENABLE_FIELD =
{
    "DQM_POP_ENABLE",
#if RU_INCLUDE_DESC
    "DQM_POP_ENABLE",
    "When this bit is set the QM will pop PDs from the DQM and place them in the runner SRAM",
#endif
    QM_GLOBAL_CFG_QM_ENABLE_CTRL_DQM_POP_ENABLE_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_QM_ENABLE_CTRL_DQM_POP_ENABLE_FIELD_WIDTH,
    QM_GLOBAL_CFG_QM_ENABLE_CTRL_DQM_POP_ENABLE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_QM_ENABLE_CTRL_RESERVED0
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_QM_ENABLE_CTRL_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    QM_GLOBAL_CFG_QM_ENABLE_CTRL_RESERVED0_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_QM_ENABLE_CTRL_RESERVED0_FIELD_WIDTH,
    QM_GLOBAL_CFG_QM_ENABLE_CTRL_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_QM_ENABLE_CTRL_RMT_FIXED_ARB_ENABLE
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_QM_ENABLE_CTRL_RMT_FIXED_ARB_ENABLE_FIELD =
{
    "RMT_FIXED_ARB_ENABLE",
#if RU_INCLUDE_DESC
    "RMT_FIXED_ARB_ENABLE",
    "When this bit is set Fixed arbitration will be done in pops from the remote FIFOs (Non delayed highest priority). If this bit is cleared RR arbitration is done",
#endif
    QM_GLOBAL_CFG_QM_ENABLE_CTRL_RMT_FIXED_ARB_ENABLE_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_QM_ENABLE_CTRL_RMT_FIXED_ARB_ENABLE_FIELD_WIDTH,
    QM_GLOBAL_CFG_QM_ENABLE_CTRL_RMT_FIXED_ARB_ENABLE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_QM_ENABLE_CTRL_DQM_PUSH_FIXED_ARB_ENABLE
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_QM_ENABLE_CTRL_DQM_PUSH_FIXED_ARB_ENABLE_FIELD =
{
    "DQM_PUSH_FIXED_ARB_ENABLE",
#if RU_INCLUDE_DESC
    "DQM_PUSH_FIXED_ARB_ENABLE",
    "When this bit is set Fixed arbitration will be done in DQM pushes (CPU highest priority, then non-delayed queues and then normal queues. If this bit is cleared RR arbitration is done.",
#endif
    QM_GLOBAL_CFG_QM_ENABLE_CTRL_DQM_PUSH_FIXED_ARB_ENABLE_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_QM_ENABLE_CTRL_DQM_PUSH_FIXED_ARB_ENABLE_FIELD_WIDTH,
    QM_GLOBAL_CFG_QM_ENABLE_CTRL_DQM_PUSH_FIXED_ARB_ENABLE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_QM_ENABLE_CTRL_RESERVED1
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_QM_ENABLE_CTRL_RESERVED1_FIELD =
{
    "RESERVED1",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    QM_GLOBAL_CFG_QM_ENABLE_CTRL_RESERVED1_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_QM_ENABLE_CTRL_RESERVED1_FIELD_WIDTH,
    QM_GLOBAL_CFG_QM_ENABLE_CTRL_RESERVED1_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_QM_SW_RST_CTRL_FPM_PREFETCH0_SW_RST
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_QM_SW_RST_CTRL_FPM_PREFETCH0_SW_RST_FIELD =
{
    "FPM_PREFETCH0_SW_RST",
#if RU_INCLUDE_DESC
    "FPM_PREFETCH0_SW_RST",
    "FPM Prefetch FIFO0 SW reset.",
#endif
    QM_GLOBAL_CFG_QM_SW_RST_CTRL_FPM_PREFETCH0_SW_RST_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_QM_SW_RST_CTRL_FPM_PREFETCH0_SW_RST_FIELD_WIDTH,
    QM_GLOBAL_CFG_QM_SW_RST_CTRL_FPM_PREFETCH0_SW_RST_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_QM_SW_RST_CTRL_FPM_PREFETCH1_SW_RST
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_QM_SW_RST_CTRL_FPM_PREFETCH1_SW_RST_FIELD =
{
    "FPM_PREFETCH1_SW_RST",
#if RU_INCLUDE_DESC
    "FPM_PREFETCH1_SW_RST",
    "FPM Prefetch FIFO1 SW reset.",
#endif
    QM_GLOBAL_CFG_QM_SW_RST_CTRL_FPM_PREFETCH1_SW_RST_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_QM_SW_RST_CTRL_FPM_PREFETCH1_SW_RST_FIELD_WIDTH,
    QM_GLOBAL_CFG_QM_SW_RST_CTRL_FPM_PREFETCH1_SW_RST_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_QM_SW_RST_CTRL_FPM_PREFETCH2_SW_RST
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_QM_SW_RST_CTRL_FPM_PREFETCH2_SW_RST_FIELD =
{
    "FPM_PREFETCH2_SW_RST",
#if RU_INCLUDE_DESC
    "FPM_PREFETCH2_SW_RST",
    "FPM Prefetch FIFO2 SW reset.",
#endif
    QM_GLOBAL_CFG_QM_SW_RST_CTRL_FPM_PREFETCH2_SW_RST_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_QM_SW_RST_CTRL_FPM_PREFETCH2_SW_RST_FIELD_WIDTH,
    QM_GLOBAL_CFG_QM_SW_RST_CTRL_FPM_PREFETCH2_SW_RST_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_QM_SW_RST_CTRL_FPM_PREFETCH3_SW_RST
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_QM_SW_RST_CTRL_FPM_PREFETCH3_SW_RST_FIELD =
{
    "FPM_PREFETCH3_SW_RST",
#if RU_INCLUDE_DESC
    "FPM_PREFETCH3_SW_RST",
    "FPM Prefetch FIFO3 SW reset.",
#endif
    QM_GLOBAL_CFG_QM_SW_RST_CTRL_FPM_PREFETCH3_SW_RST_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_QM_SW_RST_CTRL_FPM_PREFETCH3_SW_RST_FIELD_WIDTH,
    QM_GLOBAL_CFG_QM_SW_RST_CTRL_FPM_PREFETCH3_SW_RST_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_QM_SW_RST_CTRL_NORMAL_RMT_SW_RST
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_QM_SW_RST_CTRL_NORMAL_RMT_SW_RST_FIELD =
{
    "NORMAL_RMT_SW_RST",
#if RU_INCLUDE_DESC
    "NORMAL_RMT_SW_RST",
    "Normal Remote FIFO SW reset.",
#endif
    QM_GLOBAL_CFG_QM_SW_RST_CTRL_NORMAL_RMT_SW_RST_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_QM_SW_RST_CTRL_NORMAL_RMT_SW_RST_FIELD_WIDTH,
    QM_GLOBAL_CFG_QM_SW_RST_CTRL_NORMAL_RMT_SW_RST_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_QM_SW_RST_CTRL_NON_DELAYED_RMT_SW_RST
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_QM_SW_RST_CTRL_NON_DELAYED_RMT_SW_RST_FIELD =
{
    "NON_DELAYED_RMT_SW_RST",
#if RU_INCLUDE_DESC
    "NON_DELAYED_RMT_SW_RST",
    "Non-delayed Remote FIFO SW reset.",
#endif
    QM_GLOBAL_CFG_QM_SW_RST_CTRL_NON_DELAYED_RMT_SW_RST_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_QM_SW_RST_CTRL_NON_DELAYED_RMT_SW_RST_FIELD_WIDTH,
    QM_GLOBAL_CFG_QM_SW_RST_CTRL_NON_DELAYED_RMT_SW_RST_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_QM_SW_RST_CTRL_PRE_CM_FIFO_SW_RST
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_QM_SW_RST_CTRL_PRE_CM_FIFO_SW_RST_FIELD =
{
    "PRE_CM_FIFO_SW_RST",
#if RU_INCLUDE_DESC
    "PRE_CM_FIFO_SW_RST",
    "Pre Copy Machine FIFO SW reset.",
#endif
    QM_GLOBAL_CFG_QM_SW_RST_CTRL_PRE_CM_FIFO_SW_RST_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_QM_SW_RST_CTRL_PRE_CM_FIFO_SW_RST_FIELD_WIDTH,
    QM_GLOBAL_CFG_QM_SW_RST_CTRL_PRE_CM_FIFO_SW_RST_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_QM_SW_RST_CTRL_CM_RD_PD_FIFO_SW_RST
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_QM_SW_RST_CTRL_CM_RD_PD_FIFO_SW_RST_FIELD =
{
    "CM_RD_PD_FIFO_SW_RST",
#if RU_INCLUDE_DESC
    "CM_RD_PD_FIFO_SW_RST",
    "Copy Machine RD PD FIFO SW reset.",
#endif
    QM_GLOBAL_CFG_QM_SW_RST_CTRL_CM_RD_PD_FIFO_SW_RST_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_QM_SW_RST_CTRL_CM_RD_PD_FIFO_SW_RST_FIELD_WIDTH,
    QM_GLOBAL_CFG_QM_SW_RST_CTRL_CM_RD_PD_FIFO_SW_RST_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_QM_SW_RST_CTRL_CM_WR_PD_FIFO_SW_RST
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_QM_SW_RST_CTRL_CM_WR_PD_FIFO_SW_RST_FIELD =
{
    "CM_WR_PD_FIFO_SW_RST",
#if RU_INCLUDE_DESC
    "CM_WR_PD_FIFO_SW_RST",
    "Pre Copy Machine FIFO SW reset.",
#endif
    QM_GLOBAL_CFG_QM_SW_RST_CTRL_CM_WR_PD_FIFO_SW_RST_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_QM_SW_RST_CTRL_CM_WR_PD_FIFO_SW_RST_FIELD_WIDTH,
    QM_GLOBAL_CFG_QM_SW_RST_CTRL_CM_WR_PD_FIFO_SW_RST_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_QM_SW_RST_CTRL_BB0_OUTPUT_FIFO_SW_RST
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_QM_SW_RST_CTRL_BB0_OUTPUT_FIFO_SW_RST_FIELD =
{
    "BB0_OUTPUT_FIFO_SW_RST",
#if RU_INCLUDE_DESC
    "BB0_OUTPUT_FIFO_SW_RST",
    "BB0 OUTPUT FIFO SW reset.",
#endif
    QM_GLOBAL_CFG_QM_SW_RST_CTRL_BB0_OUTPUT_FIFO_SW_RST_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_QM_SW_RST_CTRL_BB0_OUTPUT_FIFO_SW_RST_FIELD_WIDTH,
    QM_GLOBAL_CFG_QM_SW_RST_CTRL_BB0_OUTPUT_FIFO_SW_RST_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_QM_SW_RST_CTRL_BB1_OUTPUT_FIFO_SW_RST
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_QM_SW_RST_CTRL_BB1_OUTPUT_FIFO_SW_RST_FIELD =
{
    "BB1_OUTPUT_FIFO_SW_RST",
#if RU_INCLUDE_DESC
    "BB1_OUTPUT_FIFO_SW_RST",
    "BB1 Output FIFO SW reset.",
#endif
    QM_GLOBAL_CFG_QM_SW_RST_CTRL_BB1_OUTPUT_FIFO_SW_RST_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_QM_SW_RST_CTRL_BB1_OUTPUT_FIFO_SW_RST_FIELD_WIDTH,
    QM_GLOBAL_CFG_QM_SW_RST_CTRL_BB1_OUTPUT_FIFO_SW_RST_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_QM_SW_RST_CTRL_BB1_INPUT_FIFO_SW_RST
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_QM_SW_RST_CTRL_BB1_INPUT_FIFO_SW_RST_FIELD =
{
    "BB1_INPUT_FIFO_SW_RST",
#if RU_INCLUDE_DESC
    "BB1_INPUT_FIFO_SW_RST",
    "BB1 Input FIFO SW reset.",
#endif
    QM_GLOBAL_CFG_QM_SW_RST_CTRL_BB1_INPUT_FIFO_SW_RST_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_QM_SW_RST_CTRL_BB1_INPUT_FIFO_SW_RST_FIELD_WIDTH,
    QM_GLOBAL_CFG_QM_SW_RST_CTRL_BB1_INPUT_FIFO_SW_RST_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_QM_SW_RST_CTRL_TM_FIFO_PTR_SW_RST
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_QM_SW_RST_CTRL_TM_FIFO_PTR_SW_RST_FIELD =
{
    "TM_FIFO_PTR_SW_RST",
#if RU_INCLUDE_DESC
    "TM_FIFO_PTR_SW_RST",
    "TM FIFOs Pointers SW reset.",
#endif
    QM_GLOBAL_CFG_QM_SW_RST_CTRL_TM_FIFO_PTR_SW_RST_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_QM_SW_RST_CTRL_TM_FIFO_PTR_SW_RST_FIELD_WIDTH,
    QM_GLOBAL_CFG_QM_SW_RST_CTRL_TM_FIFO_PTR_SW_RST_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_QM_SW_RST_CTRL_NON_DELAYED_OUT_FIFO_SW_RST
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_QM_SW_RST_CTRL_NON_DELAYED_OUT_FIFO_SW_RST_FIELD =
{
    "NON_DELAYED_OUT_FIFO_SW_RST",
#if RU_INCLUDE_DESC
    "NON_DELAYED_OUT_FIFO_SW_RST",
    "Non delayed output FIFO Pointers SW reset.",
#endif
    QM_GLOBAL_CFG_QM_SW_RST_CTRL_NON_DELAYED_OUT_FIFO_SW_RST_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_QM_SW_RST_CTRL_NON_DELAYED_OUT_FIFO_SW_RST_FIELD_WIDTH,
    QM_GLOBAL_CFG_QM_SW_RST_CTRL_NON_DELAYED_OUT_FIFO_SW_RST_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_QM_SW_RST_CTRL_RESERVED0
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_QM_SW_RST_CTRL_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    QM_GLOBAL_CFG_QM_SW_RST_CTRL_RESERVED0_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_QM_SW_RST_CTRL_RESERVED0_FIELD_WIDTH,
    QM_GLOBAL_CFG_QM_SW_RST_CTRL_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_QM_GENERAL_CTRL_DROP_CNT_PKTS_READ_CLEAR_ENABLE
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_QM_GENERAL_CTRL_DROP_CNT_PKTS_READ_CLEAR_ENABLE_FIELD =
{
    "DROP_CNT_PKTS_READ_CLEAR_ENABLE",
#if RU_INCLUDE_DESC
    "DROP_CNT_PKTS_READ_CLEAR_ENABLE",
    "Indicates whether the Drop/max_occupancy packets counter is read clear.",
#endif
    QM_GLOBAL_CFG_QM_GENERAL_CTRL_DROP_CNT_PKTS_READ_CLEAR_ENABLE_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_QM_GENERAL_CTRL_DROP_CNT_PKTS_READ_CLEAR_ENABLE_FIELD_WIDTH,
    QM_GLOBAL_CFG_QM_GENERAL_CTRL_DROP_CNT_PKTS_READ_CLEAR_ENABLE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_QM_GENERAL_CTRL_DROP_CNT_BYTES_READ_CLEAR_ENABLE
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_QM_GENERAL_CTRL_DROP_CNT_BYTES_READ_CLEAR_ENABLE_FIELD =
{
    "DROP_CNT_BYTES_READ_CLEAR_ENABLE",
#if RU_INCLUDE_DESC
    "DROP_CNT_BYTES_READ_CLEAR_ENABLE",
    "Indicates whether the Drop/max_occupancy bytes counter is read clear.",
#endif
    QM_GLOBAL_CFG_QM_GENERAL_CTRL_DROP_CNT_BYTES_READ_CLEAR_ENABLE_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_QM_GENERAL_CTRL_DROP_CNT_BYTES_READ_CLEAR_ENABLE_FIELD_WIDTH,
    QM_GLOBAL_CFG_QM_GENERAL_CTRL_DROP_CNT_BYTES_READ_CLEAR_ENABLE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_QM_GENERAL_CTRL_DROP_CNT_MAX_OCCUPANCY_PKTS_SELECT
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_QM_GENERAL_CTRL_DROP_CNT_MAX_OCCUPANCY_PKTS_SELECT_FIELD =
{
    "DROP_CNT_MAX_OCCUPANCY_PKTS_SELECT",
#if RU_INCLUDE_DESC
    "DROP_CNT_MAX_OCCUPANCY_PKTS_SELECT",
    "This bit defines the functionality of the drop packets counter."
    "0 - Functions as the drop packets counter"
    "1 - Functions as the max packets occupancy holder",
#endif
    QM_GLOBAL_CFG_QM_GENERAL_CTRL_DROP_CNT_MAX_OCCUPANCY_PKTS_SELECT_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_QM_GENERAL_CTRL_DROP_CNT_MAX_OCCUPANCY_PKTS_SELECT_FIELD_WIDTH,
    QM_GLOBAL_CFG_QM_GENERAL_CTRL_DROP_CNT_MAX_OCCUPANCY_PKTS_SELECT_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_QM_GENERAL_CTRL_DROP_CNT_MAX_OCCUPANCY_BYTES_SELECT
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_QM_GENERAL_CTRL_DROP_CNT_MAX_OCCUPANCY_BYTES_SELECT_FIELD =
{
    "DROP_CNT_MAX_OCCUPANCY_BYTES_SELECT",
#if RU_INCLUDE_DESC
    "DROP_CNT_MAX_OCCUPANCY_BYTES_SELECT",
    "This bit defines the functionality of the drop bytes counter."
    "0 - Functions as the drop bytes counter"
    "1 - Functions as the max bytes occupancy holder",
#endif
    QM_GLOBAL_CFG_QM_GENERAL_CTRL_DROP_CNT_MAX_OCCUPANCY_BYTES_SELECT_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_QM_GENERAL_CTRL_DROP_CNT_MAX_OCCUPANCY_BYTES_SELECT_FIELD_WIDTH,
    QM_GLOBAL_CFG_QM_GENERAL_CTRL_DROP_CNT_MAX_OCCUPANCY_BYTES_SELECT_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_QM_GENERAL_CTRL_FREE_WITH_CONTEXT_LAST_SEARCH
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_QM_GENERAL_CTRL_FREE_WITH_CONTEXT_LAST_SEARCH_FIELD =
{
    "FREE_WITH_CONTEXT_LAST_SEARCH",
#if RU_INCLUDE_DESC
    "FREE_WITH_CONTEXT_LAST_SEARCH",
    "Indicates The value to put in the last_search field of the SBPM free with context message",
#endif
    QM_GLOBAL_CFG_QM_GENERAL_CTRL_FREE_WITH_CONTEXT_LAST_SEARCH_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_QM_GENERAL_CTRL_FREE_WITH_CONTEXT_LAST_SEARCH_FIELD_WIDTH,
    QM_GLOBAL_CFG_QM_GENERAL_CTRL_FREE_WITH_CONTEXT_LAST_SEARCH_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_QM_GENERAL_CTRL_WRED_DISABLE
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_QM_GENERAL_CTRL_WRED_DISABLE_FIELD =
{
    "WRED_DISABLE",
#if RU_INCLUDE_DESC
    "WRED_DISABLE",
    "Disables WRED influence on drop condition",
#endif
    QM_GLOBAL_CFG_QM_GENERAL_CTRL_WRED_DISABLE_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_QM_GENERAL_CTRL_WRED_DISABLE_FIELD_WIDTH,
    QM_GLOBAL_CFG_QM_GENERAL_CTRL_WRED_DISABLE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_QM_GENERAL_CTRL_DDR_PD_CONGESTION_DISABLE
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_QM_GENERAL_CTRL_DDR_PD_CONGESTION_DISABLE_FIELD =
{
    "DDR_PD_CONGESTION_DISABLE",
#if RU_INCLUDE_DESC
    "DDR_PD_CONGESTION_DISABLE",
    "Disables DDR_PD_CONGESTION influence on drop/bp"
    "condition",
#endif
    QM_GLOBAL_CFG_QM_GENERAL_CTRL_DDR_PD_CONGESTION_DISABLE_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_QM_GENERAL_CTRL_DDR_PD_CONGESTION_DISABLE_FIELD_WIDTH,
    QM_GLOBAL_CFG_QM_GENERAL_CTRL_DDR_PD_CONGESTION_DISABLE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_QM_GENERAL_CTRL_DDR_BYTE_CONGESTION_DISABLE
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_QM_GENERAL_CTRL_DDR_BYTE_CONGESTION_DISABLE_FIELD =
{
    "DDR_BYTE_CONGESTION_DISABLE",
#if RU_INCLUDE_DESC
    "DDR_BYTE_CONGESTION_DISABLE",
    "Disables DDR_BYTE_CONGESTION influence on drop/bp condition",
#endif
    QM_GLOBAL_CFG_QM_GENERAL_CTRL_DDR_BYTE_CONGESTION_DISABLE_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_QM_GENERAL_CTRL_DDR_BYTE_CONGESTION_DISABLE_FIELD_WIDTH,
    QM_GLOBAL_CFG_QM_GENERAL_CTRL_DDR_BYTE_CONGESTION_DISABLE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_QM_GENERAL_CTRL_DDR_OCCUPANCY_DISABLE
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_QM_GENERAL_CTRL_DDR_OCCUPANCY_DISABLE_FIELD =
{
    "DDR_OCCUPANCY_DISABLE",
#if RU_INCLUDE_DESC
    "DDR_OCCUPANCY_DISABLE",
    "Disables DDR_OCCUPANCY influence on drop/bp condition",
#endif
    QM_GLOBAL_CFG_QM_GENERAL_CTRL_DDR_OCCUPANCY_DISABLE_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_QM_GENERAL_CTRL_DDR_OCCUPANCY_DISABLE_FIELD_WIDTH,
    QM_GLOBAL_CFG_QM_GENERAL_CTRL_DDR_OCCUPANCY_DISABLE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_QM_GENERAL_CTRL_DDR_FPM_CONGESTION_DISABLE
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_QM_GENERAL_CTRL_DDR_FPM_CONGESTION_DISABLE_FIELD =
{
    "DDR_FPM_CONGESTION_DISABLE",
#if RU_INCLUDE_DESC
    "DDR_FPM_CONGESTION_DISABLE",
    "Disables DDR_FPM_CONGESTION influence on drop/bp condition",
#endif
    QM_GLOBAL_CFG_QM_GENERAL_CTRL_DDR_FPM_CONGESTION_DISABLE_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_QM_GENERAL_CTRL_DDR_FPM_CONGESTION_DISABLE_FIELD_WIDTH,
    QM_GLOBAL_CFG_QM_GENERAL_CTRL_DDR_FPM_CONGESTION_DISABLE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_QM_GENERAL_CTRL_FPM_UG_DISABLE
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_QM_GENERAL_CTRL_FPM_UG_DISABLE_FIELD =
{
    "FPM_UG_DISABLE",
#if RU_INCLUDE_DESC
    "FPM_UG_DISABLE",
    "Disables FPM_UG influence on drop condition",
#endif
    QM_GLOBAL_CFG_QM_GENERAL_CTRL_FPM_UG_DISABLE_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_QM_GENERAL_CTRL_FPM_UG_DISABLE_FIELD_WIDTH,
    QM_GLOBAL_CFG_QM_GENERAL_CTRL_FPM_UG_DISABLE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_QM_GENERAL_CTRL_QUEUE_OCCUPANCY_DDR_COPY_DECISION_DISABLE
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_QM_GENERAL_CTRL_QUEUE_OCCUPANCY_DDR_COPY_DECISION_DISABLE_FIELD =
{
    "QUEUE_OCCUPANCY_DDR_COPY_DECISION_DISABLE",
#if RU_INCLUDE_DESC
    "QUEUE_OCCUPANCY_DDR_COPY_DECISION_DISABLE",
    "Disables QUEUE_OCCUPANCY_DDR_COPY_DECISION influence on copy condition",
#endif
    QM_GLOBAL_CFG_QM_GENERAL_CTRL_QUEUE_OCCUPANCY_DDR_COPY_DECISION_DISABLE_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_QM_GENERAL_CTRL_QUEUE_OCCUPANCY_DDR_COPY_DECISION_DISABLE_FIELD_WIDTH,
    QM_GLOBAL_CFG_QM_GENERAL_CTRL_QUEUE_OCCUPANCY_DDR_COPY_DECISION_DISABLE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_QM_GENERAL_CTRL_PSRAM_OCCUPANCY_DDR_COPY_DECISION_DISABLE
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_QM_GENERAL_CTRL_PSRAM_OCCUPANCY_DDR_COPY_DECISION_DISABLE_FIELD =
{
    "PSRAM_OCCUPANCY_DDR_COPY_DECISION_DISABLE",
#if RU_INCLUDE_DESC
    "PSRAM_OCCUPANCY_DDR_COPY_DECISION_DISABLE",
    "Disables PSRAM_OCCUPANCY_DDR_COPY_DECISION influence on copy condition",
#endif
    QM_GLOBAL_CFG_QM_GENERAL_CTRL_PSRAM_OCCUPANCY_DDR_COPY_DECISION_DISABLE_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_QM_GENERAL_CTRL_PSRAM_OCCUPANCY_DDR_COPY_DECISION_DISABLE_FIELD_WIDTH,
    QM_GLOBAL_CFG_QM_GENERAL_CTRL_PSRAM_OCCUPANCY_DDR_COPY_DECISION_DISABLE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_QM_GENERAL_CTRL_DONT_SEND_MC_BIT_TO_BBH
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_QM_GENERAL_CTRL_DONT_SEND_MC_BIT_TO_BBH_FIELD =
{
    "DONT_SEND_MC_BIT_TO_BBH",
#if RU_INCLUDE_DESC
    "DONT_SEND_MC_BIT_TO_BBH",
    "When set, the multicast bit of the PD will not be sent to BBH TX",
#endif
    QM_GLOBAL_CFG_QM_GENERAL_CTRL_DONT_SEND_MC_BIT_TO_BBH_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_QM_GENERAL_CTRL_DONT_SEND_MC_BIT_TO_BBH_FIELD_WIDTH,
    QM_GLOBAL_CFG_QM_GENERAL_CTRL_DONT_SEND_MC_BIT_TO_BBH_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_QM_GENERAL_CTRL_CLOSE_AGGREGATION_ON_TIMEOUT_DISABLE
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_QM_GENERAL_CTRL_CLOSE_AGGREGATION_ON_TIMEOUT_DISABLE_FIELD =
{
    "CLOSE_AGGREGATION_ON_TIMEOUT_DISABLE",
#if RU_INCLUDE_DESC
    "CLOSE_AGGREGATION_ON_TIMEOUT_DISABLE",
    "When set, aggregations are not closed automatically when queue open aggregation time expired.",
#endif
    QM_GLOBAL_CFG_QM_GENERAL_CTRL_CLOSE_AGGREGATION_ON_TIMEOUT_DISABLE_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_QM_GENERAL_CTRL_CLOSE_AGGREGATION_ON_TIMEOUT_DISABLE_FIELD_WIDTH,
    QM_GLOBAL_CFG_QM_GENERAL_CTRL_CLOSE_AGGREGATION_ON_TIMEOUT_DISABLE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_QM_GENERAL_CTRL_FPM_CONGESTION_BUF_RELEASE_MECHANISM_DISABLE
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_QM_GENERAL_CTRL_FPM_CONGESTION_BUF_RELEASE_MECHANISM_DISABLE_FIELD =
{
    "FPM_CONGESTION_BUF_RELEASE_MECHANISM_DISABLE",
#if RU_INCLUDE_DESC
    "FPM_CONGESTION_BUF_RELEASE_MECHANISM_DISABLE",
    "When cleared, given that there is an FPM congestion situation and all prefetch FPM buffers are full then a min pool size buffer will be freed each 1us. This is done due to the fact that exclusive indication is received only togeter with buffer allocation reply and if this will not be done then a deadlock could occur."
    "Setting this bit will disable this mechanism.",
#endif
    QM_GLOBAL_CFG_QM_GENERAL_CTRL_FPM_CONGESTION_BUF_RELEASE_MECHANISM_DISABLE_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_QM_GENERAL_CTRL_FPM_CONGESTION_BUF_RELEASE_MECHANISM_DISABLE_FIELD_WIDTH,
    QM_GLOBAL_CFG_QM_GENERAL_CTRL_FPM_CONGESTION_BUF_RELEASE_MECHANISM_DISABLE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_QM_GENERAL_CTRL_FPM_BUFFER_GLOBAL_RES_ENABLE
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_QM_GENERAL_CTRL_FPM_BUFFER_GLOBAL_RES_ENABLE_FIELD =
{
    "FPM_BUFFER_GLOBAL_RES_ENABLE",
#if RU_INCLUDE_DESC
    "FPM_BUFFER_GLOBAL_RES_ENABLE",
    "FPM over subscription mechanism."
    "Each queue will have one out of 8 reserved byte threshold profiles. Each profile defines 8 bit threshold with 512byte resolution."
    "Once the global FPM counter pass configurable threshold the system goes to buffer reservation congestion state. In this state any PD entering a queue which passes the reserved byte threshold will be dropped."
    "",
#endif
    QM_GLOBAL_CFG_QM_GENERAL_CTRL_FPM_BUFFER_GLOBAL_RES_ENABLE_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_QM_GENERAL_CTRL_FPM_BUFFER_GLOBAL_RES_ENABLE_FIELD_WIDTH,
    QM_GLOBAL_CFG_QM_GENERAL_CTRL_FPM_BUFFER_GLOBAL_RES_ENABLE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_QM_GENERAL_CTRL_QM_PRESERVE_PD_WITH_FPM
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_QM_GENERAL_CTRL_QM_PRESERVE_PD_WITH_FPM_FIELD =
{
    "QM_PRESERVE_PD_WITH_FPM",
#if RU_INCLUDE_DESC
    "QM_PRESERVE_PD_WITH_FPM",
    "Dont drop pd with fpm allocation.",
#endif
    QM_GLOBAL_CFG_QM_GENERAL_CTRL_QM_PRESERVE_PD_WITH_FPM_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_QM_GENERAL_CTRL_QM_PRESERVE_PD_WITH_FPM_FIELD_WIDTH,
    QM_GLOBAL_CFG_QM_GENERAL_CTRL_QM_PRESERVE_PD_WITH_FPM_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_QM_GENERAL_CTRL_QM_RESIDUE_PER_QUEUE
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_QM_GENERAL_CTRL_QM_RESIDUE_PER_QUEUE_FIELD =
{
    "QM_RESIDUE_PER_QUEUE",
#if RU_INCLUDE_DESC
    "QM_RESIDUE_PER_QUEUE",
    "Updated definition:"
    "1 - Use full residue memory - reset value"
    "0 - Debug only - use half size or no residue in projects where the full residue is 32B/q"
    ""
    ""
    "OLD Definition (perior 63146A0)"
    "6878:"
    "1 for 32B/Queue"
    "0 debug - no residue"
    ""
    "Other projects:"
    "0 for 64B/Queue"
    "1 for 128B/Queue",
#endif
    QM_GLOBAL_CFG_QM_GENERAL_CTRL_QM_RESIDUE_PER_QUEUE_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_QM_GENERAL_CTRL_QM_RESIDUE_PER_QUEUE_FIELD_WIDTH,
    QM_GLOBAL_CFG_QM_GENERAL_CTRL_QM_RESIDUE_PER_QUEUE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_QM_GENERAL_CTRL_GHOST_RPT_UPDATE_AFTER_CLOSE_AGG_EN
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_QM_GENERAL_CTRL_GHOST_RPT_UPDATE_AFTER_CLOSE_AGG_EN_FIELD =
{
    "GHOST_RPT_UPDATE_AFTER_CLOSE_AGG_EN",
#if RU_INCLUDE_DESC
    "GHOST_RPT_UPDATE_AFTER_CLOSE_AGG_EN",
    "Controls the timing of updating the overhead counters with packets which goes through aggregation."
    ""
    "0 - updates when the packets enters QM"
    "1 - updates when aggregation is done.",
#endif
    QM_GLOBAL_CFG_QM_GENERAL_CTRL_GHOST_RPT_UPDATE_AFTER_CLOSE_AGG_EN_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_QM_GENERAL_CTRL_GHOST_RPT_UPDATE_AFTER_CLOSE_AGG_EN_FIELD_WIDTH,
    QM_GLOBAL_CFG_QM_GENERAL_CTRL_GHOST_RPT_UPDATE_AFTER_CLOSE_AGG_EN_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_QM_GENERAL_CTRL_FPM_UG_FLOW_CTRL_DISABLE
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_QM_GENERAL_CTRL_FPM_UG_FLOW_CTRL_DISABLE_FIELD =
{
    "FPM_UG_FLOW_CTRL_DISABLE",
#if RU_INCLUDE_DESC
    "FPM_UG_FLOW_CTRL_DISABLE",
    "Disables FPM_UG influence on flow control wake up messages to FW.",
#endif
    QM_GLOBAL_CFG_QM_GENERAL_CTRL_FPM_UG_FLOW_CTRL_DISABLE_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_QM_GENERAL_CTRL_FPM_UG_FLOW_CTRL_DISABLE_FIELD_WIDTH,
    QM_GLOBAL_CFG_QM_GENERAL_CTRL_FPM_UG_FLOW_CTRL_DISABLE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_QM_GENERAL_CTRL_DDR_WRITE_MULTI_SLAVE_EN
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_QM_GENERAL_CTRL_DDR_WRITE_MULTI_SLAVE_EN_FIELD =
{
    "DDR_WRITE_MULTI_SLAVE_EN",
#if RU_INCLUDE_DESC
    "DDR_WRITE_MULTI_SLAVE_EN",
    "Enables to write packet transaction to multiple slave (unlimited), if disable only one ubus slave allowed.",
#endif
    QM_GLOBAL_CFG_QM_GENERAL_CTRL_DDR_WRITE_MULTI_SLAVE_EN_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_QM_GENERAL_CTRL_DDR_WRITE_MULTI_SLAVE_EN_FIELD_WIDTH,
    QM_GLOBAL_CFG_QM_GENERAL_CTRL_DDR_WRITE_MULTI_SLAVE_EN_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_QM_GENERAL_CTRL_DDR_PD_CONGESTION_AGG_PRIORITY
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_QM_GENERAL_CTRL_DDR_PD_CONGESTION_AGG_PRIORITY_FIELD =
{
    "DDR_PD_CONGESTION_AGG_PRIORITY",
#if RU_INCLUDE_DESC
    "DDR_PD_CONGESTION_AGG_PRIORITY",
    "global priority bit to aggregated PDs which go through reprocessing."
    "",
#endif
    QM_GLOBAL_CFG_QM_GENERAL_CTRL_DDR_PD_CONGESTION_AGG_PRIORITY_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_QM_GENERAL_CTRL_DDR_PD_CONGESTION_AGG_PRIORITY_FIELD_WIDTH,
    QM_GLOBAL_CFG_QM_GENERAL_CTRL_DDR_PD_CONGESTION_AGG_PRIORITY_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_QM_GENERAL_CTRL_PSRAM_OCCUPANCY_DROP_DISABLE
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_QM_GENERAL_CTRL_PSRAM_OCCUPANCY_DROP_DISABLE_FIELD =
{
    "PSRAM_OCCUPANCY_DROP_DISABLE",
#if RU_INCLUDE_DESC
    "PSRAM_OCCUPANCY_DROP_DISABLE",
    "Disables PSRAM_OCCUPANCY_DROP influence on drop condition",
#endif
    QM_GLOBAL_CFG_QM_GENERAL_CTRL_PSRAM_OCCUPANCY_DROP_DISABLE_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_QM_GENERAL_CTRL_PSRAM_OCCUPANCY_DROP_DISABLE_FIELD_WIDTH,
    QM_GLOBAL_CFG_QM_GENERAL_CTRL_PSRAM_OCCUPANCY_DROP_DISABLE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_QM_GENERAL_CTRL_QM_DDR_WRITE_ALIGNMENT
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_QM_GENERAL_CTRL_QM_DDR_WRITE_ALIGNMENT_FIELD =
{
    "QM_DDR_WRITE_ALIGNMENT",
#if RU_INCLUDE_DESC
    "QM_DDR_WRITE_ALIGNMENT",
    "0 According to length"
    "1 8-byte aligned",
#endif
    QM_GLOBAL_CFG_QM_GENERAL_CTRL_QM_DDR_WRITE_ALIGNMENT_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_QM_GENERAL_CTRL_QM_DDR_WRITE_ALIGNMENT_FIELD_WIDTH,
    QM_GLOBAL_CFG_QM_GENERAL_CTRL_QM_DDR_WRITE_ALIGNMENT_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_QM_GENERAL_CTRL_EXCLUSIVE_DONT_DROP
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_QM_GENERAL_CTRL_EXCLUSIVE_DONT_DROP_FIELD =
{
    "EXCLUSIVE_DONT_DROP",
#if RU_INCLUDE_DESC
    "EXCLUSIVE_DONT_DROP",
    "Controls if the exclusive indication in PD marks the PD as dont drop or as dont drop if the fpm in exclusive state"
    "1 - global dont drop"
    "0 - FPM exclusive state dont drop",
#endif
    QM_GLOBAL_CFG_QM_GENERAL_CTRL_EXCLUSIVE_DONT_DROP_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_QM_GENERAL_CTRL_EXCLUSIVE_DONT_DROP_FIELD_WIDTH,
    QM_GLOBAL_CFG_QM_GENERAL_CTRL_EXCLUSIVE_DONT_DROP_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_QM_GENERAL_CTRL_DQMOL_JIRA_973_FIX_ENABLE
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_QM_GENERAL_CTRL_DQMOL_JIRA_973_FIX_ENABLE_FIELD =
{
    "DQMOL_JIRA_973_FIX_ENABLE",
#if RU_INCLUDE_DESC
    "DQMOL_JIRA_973_FIX_ENABLE",
    "chicken bit for DQMOL bug:"
    "REPIN_D is full, QSM is locked by hw_push, prefetch locks UBUS."
    "prefetch waits to QSM to unload repin_d but hw_push locks UBUS but cant since adjusted reqout_h is full because HOL is read req(offload or FPM req)."
    ""
    "previously - EXCLUSIVE_DONT_DROP_BP_EN"
    ""
    "when set 1 backpressure will be applied when the DONT_DROP pd should be dropped."
    "for example, 0 fpm buffers available and the PD should be copied to DDR.",
#endif
    QM_GLOBAL_CFG_QM_GENERAL_CTRL_DQMOL_JIRA_973_FIX_ENABLE_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_QM_GENERAL_CTRL_DQMOL_JIRA_973_FIX_ENABLE_FIELD_WIDTH,
    QM_GLOBAL_CFG_QM_GENERAL_CTRL_DQMOL_JIRA_973_FIX_ENABLE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_QM_GENERAL_CTRL_GPON_DBR_CEIL
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_QM_GENERAL_CTRL_GPON_DBR_CEIL_FIELD =
{
    "GPON_DBR_CEIL",
#if RU_INCLUDE_DESC
    "GPON_DBR_CEIL",
    "If the bit enable, QM round up to 4 every packet length added ghost counters.",
#endif
    QM_GLOBAL_CFG_QM_GENERAL_CTRL_GPON_DBR_CEIL_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_QM_GENERAL_CTRL_GPON_DBR_CEIL_FIELD_WIDTH,
    QM_GLOBAL_CFG_QM_GENERAL_CTRL_GPON_DBR_CEIL_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_QM_GENERAL_CTRL_DROP_CNT_WRED_DROPS
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_QM_GENERAL_CTRL_DROP_CNT_WRED_DROPS_FIELD =
{
    "DROP_CNT_WRED_DROPS",
#if RU_INCLUDE_DESC
    "DROP_CNT_WRED_DROPS",
    "Drop counter counts WRED drops by color per queue."
    "In order to enable this feature the drop counter should be configured to count drops. if the drop counter is configured count max occupancy per queue, it will override WRED drops count."
    "color 0 - is written in dropped bytes field (word0)"
    "color 1 - is written in dropped pkts field (word1)",
#endif
    QM_GLOBAL_CFG_QM_GENERAL_CTRL_DROP_CNT_WRED_DROPS_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_QM_GENERAL_CTRL_DROP_CNT_WRED_DROPS_FIELD_WIDTH,
    QM_GLOBAL_CFG_QM_GENERAL_CTRL_DROP_CNT_WRED_DROPS_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_QM_GENERAL_CTRL_SAME_SEC_LVL_BIT_AGG_EN
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_QM_GENERAL_CTRL_SAME_SEC_LVL_BIT_AGG_EN_FIELD =
{
    "SAME_SEC_LVL_BIT_AGG_EN",
#if RU_INCLUDE_DESC
    "SAME_SEC_LVL_BIT_AGG_EN",
    "Uses bit 126 in aggregated PD to mark aggregation where all packets have the same second level queue."
    "If set to 0, then aggregated PDs in DRAM bit 126 is the 9th bit of the fourth second level queue"
    "if set to 1, then aggregated PDs in DRAM bit 126 is same second level queue.",
#endif
    QM_GLOBAL_CFG_QM_GENERAL_CTRL_SAME_SEC_LVL_BIT_AGG_EN_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_QM_GENERAL_CTRL_SAME_SEC_LVL_BIT_AGG_EN_FIELD_WIDTH,
    QM_GLOBAL_CFG_QM_GENERAL_CTRL_SAME_SEC_LVL_BIT_AGG_EN_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_QM_GENERAL_CTRL_RESERVED0
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_QM_GENERAL_CTRL_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    QM_GLOBAL_CFG_QM_GENERAL_CTRL_RESERVED0_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_QM_GENERAL_CTRL_RESERVED0_FIELD_WIDTH,
    QM_GLOBAL_CFG_QM_GENERAL_CTRL_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_FPM_CONTROL_FPM_POOL_BP_ENABLE
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_FPM_CONTROL_FPM_POOL_BP_ENABLE_FIELD =
{
    "FPM_POOL_BP_ENABLE",
#if RU_INCLUDE_DESC
    "FPM_POOL_BP_ENABLE",
    "This field indicates whether crossing the per pool FPM buffer prefetch FIFO occupancy thresholds will result in dropping packets or in applying back pressure to the re-order."
    "0 - drop packets"
    "1 - apply back pressure",
#endif
    QM_GLOBAL_CFG_FPM_CONTROL_FPM_POOL_BP_ENABLE_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_FPM_CONTROL_FPM_POOL_BP_ENABLE_FIELD_WIDTH,
    QM_GLOBAL_CFG_FPM_CONTROL_FPM_POOL_BP_ENABLE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_FPM_CONTROL_FPM_CONGESTION_BP_ENABLE
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_FPM_CONTROL_FPM_CONGESTION_BP_ENABLE_FIELD =
{
    "FPM_CONGESTION_BP_ENABLE",
#if RU_INCLUDE_DESC
    "FPM_CONGESTION_BP_ENABLE",
    "This field indicates whether crossing the FPM congestion threshold will result in dropping packets or in applying back pressure to the re-order."
    "0 - drop packets"
    "1 - apply back pressure",
#endif
    QM_GLOBAL_CFG_FPM_CONTROL_FPM_CONGESTION_BP_ENABLE_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_FPM_CONTROL_FPM_CONGESTION_BP_ENABLE_FIELD_WIDTH,
    QM_GLOBAL_CFG_FPM_CONTROL_FPM_CONGESTION_BP_ENABLE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_FPM_CONTROL_FPM_FORCE_BP_LVL
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_FPM_CONTROL_FPM_FORCE_BP_LVL_FIELD =
{
    "FPM_FORCE_BP_LVL",
#if RU_INCLUDE_DESC
    "FPM_FORCE_BP_LVL",
    "Min pool occupancy which forces BP even if QM is working in drop mode. The purpose of this reg is to solve cases when exclusive_dont_drop packets exist in QM + pools are shallow. BP_EN = MIN(POOL0,POOL1,POOL2,POOL3) < FPM_FORCE_BP_LVL."
    "When set to 0, BP isnt applied. It isnt recommended since a packet of an exclusive dont drop queue can receive dirty/used FPM buffer.",
#endif
    QM_GLOBAL_CFG_FPM_CONTROL_FPM_FORCE_BP_LVL_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_FPM_CONTROL_FPM_FORCE_BP_LVL_FIELD_WIDTH,
    QM_GLOBAL_CFG_FPM_CONTROL_FPM_FORCE_BP_LVL_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_FPM_CONTROL_FPM_PREFETCH_GRANULARITY
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_FPM_CONTROL_FPM_PREFETCH_GRANULARITY_FIELD =
{
    "FPM_PREFETCH_GRANULARITY",
#if RU_INCLUDE_DESC
    "FPM_PREFETCH_GRANULARITY",
    "FPM_PREFETCH_MIN_POOL_SIZE granularity"
    ""
    "0 - 256B"
    "1 - 320B",
#endif
    QM_GLOBAL_CFG_FPM_CONTROL_FPM_PREFETCH_GRANULARITY_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_FPM_CONTROL_FPM_PREFETCH_GRANULARITY_FIELD_WIDTH,
    QM_GLOBAL_CFG_FPM_CONTROL_FPM_PREFETCH_GRANULARITY_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_FPM_CONTROL_FPM_PREFETCH_MIN_POOL_SIZE
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_FPM_CONTROL_FPM_PREFETCH_MIN_POOL_SIZE_FIELD =
{
    "FPM_PREFETCH_MIN_POOL_SIZE",
#if RU_INCLUDE_DESC
    "FPM_PREFETCH_MIN_POOL_SIZE",
    "FPM prefetch minimum pool size."
    "The supported FPM pool sizes are derived from this value:"
    "* FPM_PREFETCH_MIN_POOL_SIZEx1"
    "* FPM_PREFETCH_MIN_POOL_SIZEx2"
    "* FPM_PREFETCH_MIN_POOL_SIZEx4"
    "* FPM_PREFETCH_MIN_POOL_SIZEx8"
    ""
    "The optional values for this field (also depend on FPM_PREFETCH_GRANULARITY value) :"
    "0 - 256Byte  or 320Byte"
    "1 - 512Byte  or 640Byte"
    "2 - 1024Byte or 1280Byte"
    "3 - 2048Byte or 2560Byte"
    ""
    ""
    "",
#endif
    QM_GLOBAL_CFG_FPM_CONTROL_FPM_PREFETCH_MIN_POOL_SIZE_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_FPM_CONTROL_FPM_PREFETCH_MIN_POOL_SIZE_FIELD_WIDTH,
    QM_GLOBAL_CFG_FPM_CONTROL_FPM_PREFETCH_MIN_POOL_SIZE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_FPM_CONTROL_RESERVED0
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_FPM_CONTROL_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    QM_GLOBAL_CFG_FPM_CONTROL_RESERVED0_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_FPM_CONTROL_RESERVED0_FIELD_WIDTH,
    QM_GLOBAL_CFG_FPM_CONTROL_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_FPM_CONTROL_FPM_PREFETCH_PENDING_REQ_LIMIT
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_FPM_CONTROL_FPM_PREFETCH_PENDING_REQ_LIMIT_FIELD =
{
    "FPM_PREFETCH_PENDING_REQ_LIMIT",
#if RU_INCLUDE_DESC
    "FPM_PREFETCH_PENDING_REQ_LIMIT",
    "The allowed on the fly FPM prefetch pending Alloc requests to the FPM.",
#endif
    QM_GLOBAL_CFG_FPM_CONTROL_FPM_PREFETCH_PENDING_REQ_LIMIT_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_FPM_CONTROL_FPM_PREFETCH_PENDING_REQ_LIMIT_FIELD_WIDTH,
    QM_GLOBAL_CFG_FPM_CONTROL_FPM_PREFETCH_PENDING_REQ_LIMIT_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_FPM_CONTROL_RESERVED1
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_FPM_CONTROL_RESERVED1_FIELD =
{
    "RESERVED1",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    QM_GLOBAL_CFG_FPM_CONTROL_RESERVED1_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_FPM_CONTROL_RESERVED1_FIELD_WIDTH,
    QM_GLOBAL_CFG_FPM_CONTROL_RESERVED1_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_FPM_CONTROL_FPM_OVERRIDE_BB_ID_EN
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_FPM_CONTROL_FPM_OVERRIDE_BB_ID_EN_FIELD =
{
    "FPM_OVERRIDE_BB_ID_EN",
#if RU_INCLUDE_DESC
    "FPM_OVERRIDE_BB_ID_EN",
    "Enable FPM BB ID override with non default value",
#endif
    QM_GLOBAL_CFG_FPM_CONTROL_FPM_OVERRIDE_BB_ID_EN_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_FPM_CONTROL_FPM_OVERRIDE_BB_ID_EN_FIELD_WIDTH,
    QM_GLOBAL_CFG_FPM_CONTROL_FPM_OVERRIDE_BB_ID_EN_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_FPM_CONTROL_FPM_OVERRIDE_BB_ID_VALUE
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_FPM_CONTROL_FPM_OVERRIDE_BB_ID_VALUE_FIELD =
{
    "FPM_OVERRIDE_BB_ID_VALUE",
#if RU_INCLUDE_DESC
    "FPM_OVERRIDE_BB_ID_VALUE",
    "Value to override the default FPM BB ID."
    "",
#endif
    QM_GLOBAL_CFG_FPM_CONTROL_FPM_OVERRIDE_BB_ID_VALUE_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_FPM_CONTROL_FPM_OVERRIDE_BB_ID_VALUE_FIELD_WIDTH,
    QM_GLOBAL_CFG_FPM_CONTROL_FPM_OVERRIDE_BB_ID_VALUE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_FPM_CONTROL_RESERVED2
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_FPM_CONTROL_RESERVED2_FIELD =
{
    "RESERVED2",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    QM_GLOBAL_CFG_FPM_CONTROL_RESERVED2_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_FPM_CONTROL_RESERVED2_FIELD_WIDTH,
    QM_GLOBAL_CFG_FPM_CONTROL_RESERVED2_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_DDR_BYTE_CONGESTION_CONTROL_DDR_BYTE_CONGESTION_DROP_ENABLE
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_DDR_BYTE_CONGESTION_CONTROL_DDR_BYTE_CONGESTION_DROP_ENABLE_FIELD =
{
    "DDR_BYTE_CONGESTION_DROP_ENABLE",
#if RU_INCLUDE_DESC
    "DDR_BYTE_CONGESTION_DROP_ENABLE",
    "This field indicates whether crossing the DDR bytes thresholds (the number of bytes waiting to be copied to DDR) will result in dropping packets or in applying back pressure to the re-order."
    "0 - apply back pressure"
    "1 - drop packets"
    "",
#endif
    QM_GLOBAL_CFG_DDR_BYTE_CONGESTION_CONTROL_DDR_BYTE_CONGESTION_DROP_ENABLE_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_DDR_BYTE_CONGESTION_CONTROL_DDR_BYTE_CONGESTION_DROP_ENABLE_FIELD_WIDTH,
    QM_GLOBAL_CFG_DDR_BYTE_CONGESTION_CONTROL_DDR_BYTE_CONGESTION_DROP_ENABLE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_DDR_BYTE_CONGESTION_CONTROL_RESERVED0
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_DDR_BYTE_CONGESTION_CONTROL_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    QM_GLOBAL_CFG_DDR_BYTE_CONGESTION_CONTROL_RESERVED0_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_DDR_BYTE_CONGESTION_CONTROL_RESERVED0_FIELD_WIDTH,
    QM_GLOBAL_CFG_DDR_BYTE_CONGESTION_CONTROL_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_DDR_BYTE_CONGESTION_LOWER_THR_DDR_BYTES_LOWER_THR
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_DDR_BYTE_CONGESTION_LOWER_THR_DDR_BYTES_LOWER_THR_FIELD =
{
    "DDR_BYTES_LOWER_THR",
#if RU_INCLUDE_DESC
    "DDR_BYTES_LOWER_THR",
    "DDR copy bytes Lower Threshold."
    "When working in packet drop mode (DDR_BYTES_CONGESTION_DROP_ENABLE=1), Then:"
    "* If (DDR copy bytes counter) > (DDR_BYTES_HIGHER_THR), then all packets are dropped."
    "* If (DDR_BYTES_MID_THR) < (DDR copy bytes counter) <= (DDR_BYTES_HIGHER_THR), then packets in low/high priority are dropped (only exclusive packets are not dropped)."
    "* If (DDR_BYTES_LOWER_THR) < (DDR copy bytes counter) <= (DDR_BYTES_MID_THR), then packets in low priority are dropped."
    "* If (DDR copy bytes counter) <=  (DDR_BYTES_LOWER_THR), then no packets are dropped."
    "When working in backpressure mode (DDR_BYTES_CONGESTION_DROP_ENABLE=0), Then if (DDR copy bytes counter) > (DDR_BYTES_HIGHER_THR), then backpressure is applied to re-order (in this case DDR_BYTES_LOWER_THR and DDR_BYTES_MID_THR are dont care).",
#endif
    QM_GLOBAL_CFG_DDR_BYTE_CONGESTION_LOWER_THR_DDR_BYTES_LOWER_THR_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_DDR_BYTE_CONGESTION_LOWER_THR_DDR_BYTES_LOWER_THR_FIELD_WIDTH,
    QM_GLOBAL_CFG_DDR_BYTE_CONGESTION_LOWER_THR_DDR_BYTES_LOWER_THR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_DDR_BYTE_CONGESTION_LOWER_THR_RESERVED0
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_DDR_BYTE_CONGESTION_LOWER_THR_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    QM_GLOBAL_CFG_DDR_BYTE_CONGESTION_LOWER_THR_RESERVED0_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_DDR_BYTE_CONGESTION_LOWER_THR_RESERVED0_FIELD_WIDTH,
    QM_GLOBAL_CFG_DDR_BYTE_CONGESTION_LOWER_THR_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_DDR_BYTE_CONGESTION_MID_THR_DDR_BYTES_MID_THR
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_DDR_BYTE_CONGESTION_MID_THR_DDR_BYTES_MID_THR_FIELD =
{
    "DDR_BYTES_MID_THR",
#if RU_INCLUDE_DESC
    "DDR_BYTES_MID_THR",
    "DDR copy bytes Lower Threshold."
    "When working in packet drop mode (DDR_BYTES_CONGESTION_DROP_ENABLE=1), Then:"
    "* If (DDR copy bytes counter) > (DDR_BYTES_HIGHER_THR), then all packets are dropped."
    "* If (DDR_BYTES_MID_THR) < (DDR copy bytes counter) <= (DDR_BYTES_HIGHER_THR), then packets in low/high priority are dropped (only exclusive packets are not dropped)."
    "* If (DDR_BYTES_LOWER_THR) < (DDR copy bytes counter) <= (DDR_BYTES_MID_THR), then packets in low priority are dropped."
    "* If (DDR copy bytes counter) <=  (DDR_BYTES_LOWER_THR), then no packets are dropped."
    "When working in backpressure mode (DDR_BYTES_CONGESTION_DROP_ENABLE=0), Then if (DDR copy bytes counter) > (DDR_BYTES_HIGHER_THR), then backpressure is applied to re-order (in this case DDR_BYTES_LOWER_THR and DDR_BYTES_MID_THR are dont care).",
#endif
    QM_GLOBAL_CFG_DDR_BYTE_CONGESTION_MID_THR_DDR_BYTES_MID_THR_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_DDR_BYTE_CONGESTION_MID_THR_DDR_BYTES_MID_THR_FIELD_WIDTH,
    QM_GLOBAL_CFG_DDR_BYTE_CONGESTION_MID_THR_DDR_BYTES_MID_THR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_DDR_BYTE_CONGESTION_MID_THR_RESERVED0
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_DDR_BYTE_CONGESTION_MID_THR_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    QM_GLOBAL_CFG_DDR_BYTE_CONGESTION_MID_THR_RESERVED0_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_DDR_BYTE_CONGESTION_MID_THR_RESERVED0_FIELD_WIDTH,
    QM_GLOBAL_CFG_DDR_BYTE_CONGESTION_MID_THR_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_DDR_BYTE_CONGESTION_HIGHER_THR_DDR_BYTES_HIGHER_THR
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_DDR_BYTE_CONGESTION_HIGHER_THR_DDR_BYTES_HIGHER_THR_FIELD =
{
    "DDR_BYTES_HIGHER_THR",
#if RU_INCLUDE_DESC
    "DDR_BYTES_HIGHER_THR",
    "DDR copy bytes Lower Threshold."
    "When working in packet drop mode (DDR_BYTES_CONGESTION_DROP_ENABLE=1), Then:"
    "* If (DDR copy bytes counter) > (DDR_BYTES_HIGHER_THR), then all packets are dropped."
    "* If (DDR_BYTES_MID_THR) < (DDR copy bytes counter) <= (DDR_BYTES_HIGHER_THR), then packets in low/high priority are dropped (only exclusive packets are not dropped)."
    "* If (DDR_BYTES_LOWER_THR) < (DDR copy bytes counter) <= (DDR_BYTES_MID_THR), then packets in low priority are dropped."
    "* If (DDR copy bytes counter) <=  (DDR_BYTES_LOWER_THR), then no packets are dropped."
    "When working in backpressure mode (DDR_BYTES_CONGESTION_DROP_ENABLE=0), Then if (DDR copy bytes counter) > (DDR_BYTES_HIGHER_THR), then backpressure is applied to re-order (in this case DDR_BYTES_LOWER_THR and DDR_BYTES_MID_THR are dont care).",
#endif
    QM_GLOBAL_CFG_DDR_BYTE_CONGESTION_HIGHER_THR_DDR_BYTES_HIGHER_THR_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_DDR_BYTE_CONGESTION_HIGHER_THR_DDR_BYTES_HIGHER_THR_FIELD_WIDTH,
    QM_GLOBAL_CFG_DDR_BYTE_CONGESTION_HIGHER_THR_DDR_BYTES_HIGHER_THR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_DDR_BYTE_CONGESTION_HIGHER_THR_RESERVED0
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_DDR_BYTE_CONGESTION_HIGHER_THR_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    QM_GLOBAL_CFG_DDR_BYTE_CONGESTION_HIGHER_THR_RESERVED0_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_DDR_BYTE_CONGESTION_HIGHER_THR_RESERVED0_FIELD_WIDTH,
    QM_GLOBAL_CFG_DDR_BYTE_CONGESTION_HIGHER_THR_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_DDR_PD_CONGESTION_CONTROL_DDR_PD_CONGESTION_DROP_ENABLE
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_DDR_PD_CONGESTION_CONTROL_DDR_PD_CONGESTION_DROP_ENABLE_FIELD =
{
    "DDR_PD_CONGESTION_DROP_ENABLE",
#if RU_INCLUDE_DESC
    "DDR_PD_CONGESTION_DROP_ENABLE",
    "This field indicates whether crossing the DDR Pipe thresholds will result in dropping packets or in applying back pressure to the re-order."
    "0 - apply back pressure"
    "1 - drop packets"
    "",
#endif
    QM_GLOBAL_CFG_DDR_PD_CONGESTION_CONTROL_DDR_PD_CONGESTION_DROP_ENABLE_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_DDR_PD_CONGESTION_CONTROL_DDR_PD_CONGESTION_DROP_ENABLE_FIELD_WIDTH,
    QM_GLOBAL_CFG_DDR_PD_CONGESTION_CONTROL_DDR_PD_CONGESTION_DROP_ENABLE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_DDR_PD_CONGESTION_CONTROL_RESERVED0
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_DDR_PD_CONGESTION_CONTROL_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    QM_GLOBAL_CFG_DDR_PD_CONGESTION_CONTROL_RESERVED0_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_DDR_PD_CONGESTION_CONTROL_RESERVED0_FIELD_WIDTH,
    QM_GLOBAL_CFG_DDR_PD_CONGESTION_CONTROL_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_DDR_PD_CONGESTION_CONTROL_DDR_PIPE_LOWER_THR
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_DDR_PD_CONGESTION_CONTROL_DDR_PIPE_LOWER_THR_FIELD =
{
    "DDR_PIPE_LOWER_THR",
#if RU_INCLUDE_DESC
    "DDR_PIPE_LOWER_THR",
    "DDR copy Pipe Lower Threshold."
    "When working in packet drop mode (DDR_PD_CONGESTION_DROP_ENABLE=1), Then:"
    "* If (DDR copy pipe occupancy) > (DDR_PIPE_HIGHER_THR), then packets in low/high priority are dropped (only exclusive packets are not dropped)."
    "* If (DDR_PIPE_LOWER_THR) < (DDR copy pipe occupancy) <= (DDR_PIPE_HIGHER_THR), then packets in low priority are dropped."
    "* If (DDR copy pipe occupancy) <=  (DDR_PIPE_LOWER_THR), then no packets are dropped."
    "When working in backpressure mode (DDR_PD_CONGESTION_DROP_ENABLE=0), Then if (DDR copy pipe occupancy) > (DDR_PIPE_HIGHER_THR), then backpressure is applied to re-order (in this case DDR_PIPE_LOWER_THR is dont care).",
#endif
    QM_GLOBAL_CFG_DDR_PD_CONGESTION_CONTROL_DDR_PIPE_LOWER_THR_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_DDR_PD_CONGESTION_CONTROL_DDR_PIPE_LOWER_THR_FIELD_WIDTH,
    QM_GLOBAL_CFG_DDR_PD_CONGESTION_CONTROL_DDR_PIPE_LOWER_THR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_DDR_PD_CONGESTION_CONTROL_DDR_PIPE_HIGHER_THR
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_DDR_PD_CONGESTION_CONTROL_DDR_PIPE_HIGHER_THR_FIELD =
{
    "DDR_PIPE_HIGHER_THR",
#if RU_INCLUDE_DESC
    "DDR_PIPE_HIGHER_THR",
    "DDR copy Pipe Lower Threshold."
    "When working in packet drop mode (DDR_PD_CONGESTION_DROP_ENABLE=1), Then:"
    "* If (DDR copy pipe occupancy) > (DDR_PIPE_HIGHER_THR), then packets in low/high priority are dropped (only exclusive packets are not dropped)."
    "* If (DDR_PIPE_LOWER_THR) < (DDR copy pipe occupancy) <= (DDR_PIPE_HIGHER_THR), then packets in low priority are dropped."
    "* If (DDR copy pipe occupancy) <= (DDR_PIPE_LOWER_THR), then no packets are dropped."
    "When working in backpressure mode (DDR_PD_CONGESTION_DROP_ENABLE=0), Then if (DDR copy pipe occupancy) > (DDR_PIPE_HIGHER_THR), then backpressure is applied to re-order (in this case DDR_PIPE_LOWER_THR is dont care)."
    "IMPORTANT: recommended maximum value is 0x7B in order to avoid performance degradation when working with aggregation timeout enable",
#endif
    QM_GLOBAL_CFG_DDR_PD_CONGESTION_CONTROL_DDR_PIPE_HIGHER_THR_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_DDR_PD_CONGESTION_CONTROL_DDR_PIPE_HIGHER_THR_FIELD_WIDTH,
    QM_GLOBAL_CFG_DDR_PD_CONGESTION_CONTROL_DDR_PIPE_HIGHER_THR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_DDR_PD_CONGESTION_CONTROL_RESERVED1
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_DDR_PD_CONGESTION_CONTROL_RESERVED1_FIELD =
{
    "RESERVED1",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    QM_GLOBAL_CFG_DDR_PD_CONGESTION_CONTROL_RESERVED1_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_DDR_PD_CONGESTION_CONTROL_RESERVED1_FIELD_WIDTH,
    QM_GLOBAL_CFG_DDR_PD_CONGESTION_CONTROL_RESERVED1_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_QM_PD_CONGESTION_CONTROL_TOTAL_PD_THR
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_QM_PD_CONGESTION_CONTROL_TOTAL_PD_THR_FIELD =
{
    "TOTAL_PD_THR",
#if RU_INCLUDE_DESC
    "TOTAL_PD_THR",
    "If the number of PDs for a certain queue exceeds this value, then PDs will be dropped.",
#endif
    QM_GLOBAL_CFG_QM_PD_CONGESTION_CONTROL_TOTAL_PD_THR_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_QM_PD_CONGESTION_CONTROL_TOTAL_PD_THR_FIELD_WIDTH,
    QM_GLOBAL_CFG_QM_PD_CONGESTION_CONTROL_TOTAL_PD_THR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_QM_PD_CONGESTION_CONTROL_RESERVED0
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_QM_PD_CONGESTION_CONTROL_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    QM_GLOBAL_CFG_QM_PD_CONGESTION_CONTROL_RESERVED0_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_QM_PD_CONGESTION_CONTROL_RESERVED0_FIELD_WIDTH,
    QM_GLOBAL_CFG_QM_PD_CONGESTION_CONTROL_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_ABS_DROP_QUEUE_ABS_DROP_QUEUE
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_ABS_DROP_QUEUE_ABS_DROP_QUEUE_FIELD =
{
    "ABS_DROP_QUEUE",
#if RU_INCLUDE_DESC
    "ABS_DROP_QUEUE",
    "Absolute address drop queue."
    "Absolute address PDs which are dropped will be redirected into this configured queue. FW will be responsible for reclaiming their DDR space.",
#endif
    QM_GLOBAL_CFG_ABS_DROP_QUEUE_ABS_DROP_QUEUE_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_ABS_DROP_QUEUE_ABS_DROP_QUEUE_FIELD_WIDTH,
    QM_GLOBAL_CFG_ABS_DROP_QUEUE_ABS_DROP_QUEUE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_ABS_DROP_QUEUE_RESERVED0
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_ABS_DROP_QUEUE_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    QM_GLOBAL_CFG_ABS_DROP_QUEUE_RESERVED0_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_ABS_DROP_QUEUE_RESERVED0_FIELD_WIDTH,
    QM_GLOBAL_CFG_ABS_DROP_QUEUE_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_ABS_DROP_QUEUE_ABS_DROP_QUEUE_EN
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_ABS_DROP_QUEUE_ABS_DROP_QUEUE_EN_FIELD =
{
    "ABS_DROP_QUEUE_EN",
#if RU_INCLUDE_DESC
    "ABS_DROP_QUEUE_EN",
    "Absolute address drop queue enable."
    "Enables the mechanism in which absolute address PDs which are dropped are be redirected into this configured queue. FW will be responsible for reclaiming their DDR space.",
#endif
    QM_GLOBAL_CFG_ABS_DROP_QUEUE_ABS_DROP_QUEUE_EN_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_ABS_DROP_QUEUE_ABS_DROP_QUEUE_EN_FIELD_WIDTH,
    QM_GLOBAL_CFG_ABS_DROP_QUEUE_ABS_DROP_QUEUE_EN_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_ABS_DROP_QUEUE_RESERVED1
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_ABS_DROP_QUEUE_RESERVED1_FIELD =
{
    "RESERVED1",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    QM_GLOBAL_CFG_ABS_DROP_QUEUE_RESERVED1_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_ABS_DROP_QUEUE_RESERVED1_FIELD_WIDTH,
    QM_GLOBAL_CFG_ABS_DROP_QUEUE_RESERVED1_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_AGGREGATION_CTRL_MAX_AGG_BYTES
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_AGGREGATION_CTRL_MAX_AGG_BYTES_FIELD =
{
    "MAX_AGG_BYTES",
#if RU_INCLUDE_DESC
    "MAX_AGG_BYTES",
    "This field indicates the maximum number of bytes in an aggregated PD.",
#endif
    QM_GLOBAL_CFG_AGGREGATION_CTRL_MAX_AGG_BYTES_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_AGGREGATION_CTRL_MAX_AGG_BYTES_FIELD_WIDTH,
    QM_GLOBAL_CFG_AGGREGATION_CTRL_MAX_AGG_BYTES_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_AGGREGATION_CTRL_MAX_AGG_PKTS
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_AGGREGATION_CTRL_MAX_AGG_PKTS_FIELD =
{
    "MAX_AGG_PKTS",
#if RU_INCLUDE_DESC
    "MAX_AGG_PKTS",
    "This field indicates the maximum number of packets in an aggregated PD",
#endif
    QM_GLOBAL_CFG_AGGREGATION_CTRL_MAX_AGG_PKTS_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_AGGREGATION_CTRL_MAX_AGG_PKTS_FIELD_WIDTH,
    QM_GLOBAL_CFG_AGGREGATION_CTRL_MAX_AGG_PKTS_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_AGGREGATION_CTRL_AGG_OVR_512B_EN
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_AGGREGATION_CTRL_AGG_OVR_512B_EN_FIELD =
{
    "AGG_OVR_512B_EN",
#if RU_INCLUDE_DESC
    "AGG_OVER_512BYTE_ENABLE",
    "This feature, when enabled, allows QM to aggregate more than 512 in each aggregation."
    "Max PD size allowed to be added to an aggregation will still remain 512 due to limitation in the PD struct."
    "Note that the default value once this feature is enabled in 640Byte. This needs to be configured in the MAX_AGG_BYTES."
    "MAX_PACKET_SIZE will still be 512"
    "",
#endif
    QM_GLOBAL_CFG_AGGREGATION_CTRL_AGG_OVR_512B_EN_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_AGGREGATION_CTRL_AGG_OVR_512B_EN_FIELD_WIDTH,
    QM_GLOBAL_CFG_AGGREGATION_CTRL_AGG_OVR_512B_EN_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_AGGREGATION_CTRL_MAX_AGG_PKT_SIZE
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_AGGREGATION_CTRL_MAX_AGG_PKT_SIZE_FIELD =
{
    "MAX_AGG_PKT_SIZE",
#if RU_INCLUDE_DESC
    "MAX_PACKET_SIZE_TO_BE_AGG",
    "This indicates the maximum Packet size that can be aggregated."
    "With current PD limitation max Packet can be 512."
    "This is true even if the AGG_OVER_512BYTE_ENABLE is set to 1b1.",
#endif
    QM_GLOBAL_CFG_AGGREGATION_CTRL_MAX_AGG_PKT_SIZE_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_AGGREGATION_CTRL_MAX_AGG_PKT_SIZE_FIELD_WIDTH,
    QM_GLOBAL_CFG_AGGREGATION_CTRL_MAX_AGG_PKT_SIZE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_AGGREGATION_CTRL_MIN_AGG_PKT_SIZE
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_AGGREGATION_CTRL_MIN_AGG_PKT_SIZE_FIELD =
{
    "MIN_AGG_PKT_SIZE",
#if RU_INCLUDE_DESC
    "MIN_PACKET_SIZE_TO_BE_AGG",
    "This indicates the minimum Packet size that can be aggregated."
    "This is for the design to understand if the current accumulated agg size has enough space for another Packet. if it hasnt, it will close the agg. if it has it will agg and leave the aggregation open."
    ""
    ""
    "Note!!"
    "You must config this value aligned to be to 8 (e.g for 60 byte min packet configure 64)",
#endif
    QM_GLOBAL_CFG_AGGREGATION_CTRL_MIN_AGG_PKT_SIZE_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_AGGREGATION_CTRL_MIN_AGG_PKT_SIZE_FIELD_WIDTH,
    QM_GLOBAL_CFG_AGGREGATION_CTRL_MIN_AGG_PKT_SIZE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_AGGREGATION_CTRL2_AGG_POOL_SEL_EN
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_AGGREGATION_CTRL2_AGG_POOL_SEL_EN_FIELD =
{
    "AGG_POOL_SEL_EN",
#if RU_INCLUDE_DESC
    "AGG_POOL_SELECTION_ENALBE",
    "Enable pool selection for aggregarion according to AGG_POOL_SEL configuration and not according to min_buffer_size config",
#endif
    QM_GLOBAL_CFG_AGGREGATION_CTRL2_AGG_POOL_SEL_EN_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_AGGREGATION_CTRL2_AGG_POOL_SEL_EN_FIELD_WIDTH,
    QM_GLOBAL_CFG_AGGREGATION_CTRL2_AGG_POOL_SEL_EN_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_AGGREGATION_CTRL2_RESERVED0
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_AGGREGATION_CTRL2_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    QM_GLOBAL_CFG_AGGREGATION_CTRL2_RESERVED0_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_AGGREGATION_CTRL2_RESERVED0_FIELD_WIDTH,
    QM_GLOBAL_CFG_AGGREGATION_CTRL2_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_AGGREGATION_CTRL2_AGG_POOL_SEL
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_AGGREGATION_CTRL2_AGG_POOL_SEL_FIELD =
{
    "AGG_POOL_SEL",
#if RU_INCLUDE_DESC
    "AGG_POOL_SELECTION",
    "This register sets the the size of the pool to use for Agg Packets."
    "Since the design can now support max AGG of any size up to 640 (and even till 1024) there should be an explicit configuration to which pool to use."
    ""
    "-> POOL0 - Use 8 buffers"
    "-> POOL1 - Use 4 buffers"
    "-> POOL2 - Use 2 buffers"
    "-> POOL3 - Use 1 buffers"
    ""
    "This configuration needs to take into account the min_buffer_size and max_agg_size in order to make sure that the correct pool is chosen for agg"
    ""
    "e.g. min buffer size is 256 and max_agg_byte is 1016. will require pool of 4 buffers",
#endif
    QM_GLOBAL_CFG_AGGREGATION_CTRL2_AGG_POOL_SEL_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_AGGREGATION_CTRL2_AGG_POOL_SEL_FIELD_WIDTH,
    QM_GLOBAL_CFG_AGGREGATION_CTRL2_AGG_POOL_SEL_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_AGGREGATION_CTRL2_RESERVED1
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_AGGREGATION_CTRL2_RESERVED1_FIELD =
{
    "RESERVED1",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    QM_GLOBAL_CFG_AGGREGATION_CTRL2_RESERVED1_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_AGGREGATION_CTRL2_RESERVED1_FIELD_WIDTH,
    QM_GLOBAL_CFG_AGGREGATION_CTRL2_RESERVED1_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_FPM_BASE_ADDR_FPM_BASE_ADDR
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_FPM_BASE_ADDR_FPM_BASE_ADDR_FIELD =
{
    "FPM_BASE_ADDR",
#if RU_INCLUDE_DESC
    "FPM_BASE_ADDR",
    "FPM Base Address. This is the 32-bit MSBs out of the 40-bit address."
    "Multiply this field by 256 to get the 40-bit address."
    "Example:"
    "If desired base address is 0x0080_0000"
    "The FPM_BASE_ADDR field should be configured to: 0x0000_8000.",
#endif
    QM_GLOBAL_CFG_FPM_BASE_ADDR_FPM_BASE_ADDR_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_FPM_BASE_ADDR_FPM_BASE_ADDR_FIELD_WIDTH,
    QM_GLOBAL_CFG_FPM_BASE_ADDR_FPM_BASE_ADDR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_FPM_COHERENT_BASE_ADDR_FPM_BASE_ADDR
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_FPM_COHERENT_BASE_ADDR_FPM_BASE_ADDR_FIELD =
{
    "FPM_BASE_ADDR",
#if RU_INCLUDE_DESC
    "FPM_BASE_ADDR",
    "FPM Base Address. This is the 32-bit MSBs out of the 40-bit address."
    "Multiply this field by 256 to get the 40-bit address."
    "Example:"
    "If desired base address is 0x0080_0000"
    "The FPM_BASE_ADDR field should be configured to: 0x0000_8000.",
#endif
    QM_GLOBAL_CFG_FPM_COHERENT_BASE_ADDR_FPM_BASE_ADDR_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_FPM_COHERENT_BASE_ADDR_FPM_BASE_ADDR_FIELD_WIDTH,
    QM_GLOBAL_CFG_FPM_COHERENT_BASE_ADDR_FPM_BASE_ADDR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_DDR_SOP_OFFSET_DDR_SOP_OFFSET0
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_DDR_SOP_OFFSET_DDR_SOP_OFFSET0_FIELD =
{
    "DDR_SOP_OFFSET0",
#if RU_INCLUDE_DESC
    "DDR_SOP_OFFSET0",
    "DDR SOP Offset option 0"
    "",
#endif
    QM_GLOBAL_CFG_DDR_SOP_OFFSET_DDR_SOP_OFFSET0_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_DDR_SOP_OFFSET_DDR_SOP_OFFSET0_FIELD_WIDTH,
    QM_GLOBAL_CFG_DDR_SOP_OFFSET_DDR_SOP_OFFSET0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_DDR_SOP_OFFSET_RESERVED0
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_DDR_SOP_OFFSET_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    QM_GLOBAL_CFG_DDR_SOP_OFFSET_RESERVED0_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_DDR_SOP_OFFSET_RESERVED0_FIELD_WIDTH,
    QM_GLOBAL_CFG_DDR_SOP_OFFSET_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_DDR_SOP_OFFSET_DDR_SOP_OFFSET1
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_DDR_SOP_OFFSET_DDR_SOP_OFFSET1_FIELD =
{
    "DDR_SOP_OFFSET1",
#if RU_INCLUDE_DESC
    "DDR_SOP_OFFSET1",
    "DDR SOP Offset option 1"
    "",
#endif
    QM_GLOBAL_CFG_DDR_SOP_OFFSET_DDR_SOP_OFFSET1_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_DDR_SOP_OFFSET_DDR_SOP_OFFSET1_FIELD_WIDTH,
    QM_GLOBAL_CFG_DDR_SOP_OFFSET_DDR_SOP_OFFSET1_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_DDR_SOP_OFFSET_RESERVED1
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_DDR_SOP_OFFSET_RESERVED1_FIELD =
{
    "RESERVED1",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    QM_GLOBAL_CFG_DDR_SOP_OFFSET_RESERVED1_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_DDR_SOP_OFFSET_RESERVED1_FIELD_WIDTH,
    QM_GLOBAL_CFG_DDR_SOP_OFFSET_RESERVED1_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_EPON_OVERHEAD_CTRL_EPON_LINE_RATE
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_EPON_OVERHEAD_CTRL_EPON_LINE_RATE_FIELD =
{
    "EPON_LINE_RATE",
#if RU_INCLUDE_DESC
    "EPON_LINE_RATE",
    "EPON Line Rate"
    "0 - 1G"
    "1 - 10G",
#endif
    QM_GLOBAL_CFG_EPON_OVERHEAD_CTRL_EPON_LINE_RATE_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_EPON_OVERHEAD_CTRL_EPON_LINE_RATE_FIELD_WIDTH,
    QM_GLOBAL_CFG_EPON_OVERHEAD_CTRL_EPON_LINE_RATE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_EPON_OVERHEAD_CTRL_EPON_CRC_ADD_DISABLE
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_EPON_OVERHEAD_CTRL_EPON_CRC_ADD_DISABLE_FIELD =
{
    "EPON_CRC_ADD_DISABLE",
#if RU_INCLUDE_DESC
    "EPON_CRC_ADD_DISABLE",
    "If this bit is not set then 4-bytes will be added to the ghost reporting accumulated bytes and to the byte overhead calculation input",
#endif
    QM_GLOBAL_CFG_EPON_OVERHEAD_CTRL_EPON_CRC_ADD_DISABLE_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_EPON_OVERHEAD_CTRL_EPON_CRC_ADD_DISABLE_FIELD_WIDTH,
    QM_GLOBAL_CFG_EPON_OVERHEAD_CTRL_EPON_CRC_ADD_DISABLE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_EPON_OVERHEAD_CTRL_MAC_FLOW_OVERWRITE_CRC_EN
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_EPON_OVERHEAD_CTRL_MAC_FLOW_OVERWRITE_CRC_EN_FIELD =
{
    "MAC_FLOW_OVERWRITE_CRC_EN",
#if RU_INCLUDE_DESC
    "MAC_FLOW_OVERWRITE_CRC_EN",
    "Enables to overwrite CRC addition specified MAC FLOW in the field below.",
#endif
    QM_GLOBAL_CFG_EPON_OVERHEAD_CTRL_MAC_FLOW_OVERWRITE_CRC_EN_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_EPON_OVERHEAD_CTRL_MAC_FLOW_OVERWRITE_CRC_EN_FIELD_WIDTH,
    QM_GLOBAL_CFG_EPON_OVERHEAD_CTRL_MAC_FLOW_OVERWRITE_CRC_EN_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_EPON_OVERHEAD_CTRL_MAC_FLOW_OVERWRITE_CRC
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_EPON_OVERHEAD_CTRL_MAC_FLOW_OVERWRITE_CRC_FIELD =
{
    "MAC_FLOW_OVERWRITE_CRC",
#if RU_INCLUDE_DESC
    "MAC_FLOW_OVERWRITE_CRC",
    "MAC flow ID to force disable CRC addition",
#endif
    QM_GLOBAL_CFG_EPON_OVERHEAD_CTRL_MAC_FLOW_OVERWRITE_CRC_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_EPON_OVERHEAD_CTRL_MAC_FLOW_OVERWRITE_CRC_FIELD_WIDTH,
    QM_GLOBAL_CFG_EPON_OVERHEAD_CTRL_MAC_FLOW_OVERWRITE_CRC_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_EPON_OVERHEAD_CTRL_RESERVED0
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_EPON_OVERHEAD_CTRL_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    QM_GLOBAL_CFG_EPON_OVERHEAD_CTRL_RESERVED0_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_EPON_OVERHEAD_CTRL_RESERVED0_FIELD_WIDTH,
    QM_GLOBAL_CFG_EPON_OVERHEAD_CTRL_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_EPON_OVERHEAD_CTRL_FEC_IPG_LENGTH
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_EPON_OVERHEAD_CTRL_FEC_IPG_LENGTH_FIELD =
{
    "FEC_IPG_LENGTH",
#if RU_INCLUDE_DESC
    "FEC_IPG_LENGTH",
    "FEC IPG Length",
#endif
    QM_GLOBAL_CFG_EPON_OVERHEAD_CTRL_FEC_IPG_LENGTH_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_EPON_OVERHEAD_CTRL_FEC_IPG_LENGTH_FIELD_WIDTH,
    QM_GLOBAL_CFG_EPON_OVERHEAD_CTRL_FEC_IPG_LENGTH_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_EPON_OVERHEAD_CTRL_RESERVED1
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_EPON_OVERHEAD_CTRL_RESERVED1_FIELD =
{
    "RESERVED1",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    QM_GLOBAL_CFG_EPON_OVERHEAD_CTRL_RESERVED1_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_EPON_OVERHEAD_CTRL_RESERVED1_FIELD_WIDTH,
    QM_GLOBAL_CFG_EPON_OVERHEAD_CTRL_RESERVED1_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_DQM_FULL_Q_FULL
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_DQM_FULL_Q_FULL_FIELD =
{
    "Q_FULL",
#if RU_INCLUDE_DESC
    "Q_FULL",
    "Queue Full indication."
    "This is a 1-bit indication per queue."
    "This register consists of a batch of 32 queues.",
#endif
    QM_GLOBAL_CFG_DQM_FULL_Q_FULL_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_DQM_FULL_Q_FULL_FIELD_WIDTH,
    QM_GLOBAL_CFG_DQM_FULL_Q_FULL_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_DQM_NOT_EMPTY_Q_NOT_EMPTY
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_DQM_NOT_EMPTY_Q_NOT_EMPTY_FIELD =
{
    "Q_NOT_EMPTY",
#if RU_INCLUDE_DESC
    "Q_NOT_EMPTY",
    "Queue Not empty indication."
    "This is a 1-bit indication per queue."
    "This register consists of a batch of 32 queues.",
#endif
    QM_GLOBAL_CFG_DQM_NOT_EMPTY_Q_NOT_EMPTY_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_DQM_NOT_EMPTY_Q_NOT_EMPTY_FIELD_WIDTH,
    QM_GLOBAL_CFG_DQM_NOT_EMPTY_Q_NOT_EMPTY_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_DQM_POP_READY_POP_READY
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_DQM_POP_READY_POP_READY_FIELD =
{
    "POP_READY",
#if RU_INCLUDE_DESC
    "POP_READY",
    "Queue pop ready indication."
    "This is a 1-bit indication per queue."
    "This register consists of a batch of 32 queues.",
#endif
    QM_GLOBAL_CFG_DQM_POP_READY_POP_READY_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_DQM_POP_READY_POP_READY_FIELD_WIDTH,
    QM_GLOBAL_CFG_DQM_POP_READY_POP_READY_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_AGGREGATION_CONTEXT_VALID_CONTEXT_VALID
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_AGGREGATION_CONTEXT_VALID_CONTEXT_VALID_FIELD =
{
    "CONTEXT_VALID",
#if RU_INCLUDE_DESC
    "CONTEXT_VALID",
    "QM ingress aggregation context valid indication."
    "This is a 1-bit indication per queue."
    "This register consists of a batch of 32 queues.",
#endif
    QM_GLOBAL_CFG_AGGREGATION_CONTEXT_VALID_CONTEXT_VALID_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_AGGREGATION_CONTEXT_VALID_CONTEXT_VALID_FIELD_WIDTH,
    QM_GLOBAL_CFG_AGGREGATION_CONTEXT_VALID_CONTEXT_VALID_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_QM_AGGREGATION_TIMER_CTRL_PRESCALER_GRANULARITY
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_QM_AGGREGATION_TIMER_CTRL_PRESCALER_GRANULARITY_FIELD =
{
    "PRESCALER_GRANULARITY",
#if RU_INCLUDE_DESC
    "PRESCALER_GRANULARITY",
    "defines the granularity of the prescaler counter:"
    "0 = 10bits"
    "1 = 11bits"
    "2 = 12bits"
    "3 = 13bits"
    "4 = 14bits"
    "5 = 15bits"
    "6 = 16bits"
    "debug:"
    "7 = 5bits"
    ""
    "",
#endif
    QM_GLOBAL_CFG_QM_AGGREGATION_TIMER_CTRL_PRESCALER_GRANULARITY_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_QM_AGGREGATION_TIMER_CTRL_PRESCALER_GRANULARITY_FIELD_WIDTH,
    QM_GLOBAL_CFG_QM_AGGREGATION_TIMER_CTRL_PRESCALER_GRANULARITY_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_QM_AGGREGATION_TIMER_CTRL_AGGREGATION_TIMEOUT_VALUE
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_QM_AGGREGATION_TIMER_CTRL_AGGREGATION_TIMEOUT_VALUE_FIELD =
{
    "AGGREGATION_TIMEOUT_VALUE",
#if RU_INCLUDE_DESC
    "AGGREGATION_TIMEOUT_VALUE",
    "Aggregation timeout value, counted in prescaler counters cycles."
    "valid values = [1..7]"
    "0 - isnt supported"
    ""
    "",
#endif
    QM_GLOBAL_CFG_QM_AGGREGATION_TIMER_CTRL_AGGREGATION_TIMEOUT_VALUE_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_QM_AGGREGATION_TIMER_CTRL_AGGREGATION_TIMEOUT_VALUE_FIELD_WIDTH,
    QM_GLOBAL_CFG_QM_AGGREGATION_TIMER_CTRL_AGGREGATION_TIMEOUT_VALUE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_QM_AGGREGATION_TIMER_CTRL_PD_OCCUPANCY_EN
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_QM_AGGREGATION_TIMER_CTRL_PD_OCCUPANCY_EN_FIELD =
{
    "PD_OCCUPANCY_EN",
#if RU_INCLUDE_DESC
    "PD_OCCUPANCY_EN",
    "If set, aggregation of queues with PD occupancy more than encoded on PD_OCCUPANCY_VALUE arent closed even if the timer is expired."
    "If not set, then aggregation is closed after queues timer expires",
#endif
    QM_GLOBAL_CFG_QM_AGGREGATION_TIMER_CTRL_PD_OCCUPANCY_EN_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_QM_AGGREGATION_TIMER_CTRL_PD_OCCUPANCY_EN_FIELD_WIDTH,
    QM_GLOBAL_CFG_QM_AGGREGATION_TIMER_CTRL_PD_OCCUPANCY_EN_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_QM_AGGREGATION_TIMER_CTRL_PD_OCCUPANCY_VALUE
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_QM_AGGREGATION_TIMER_CTRL_PD_OCCUPANCY_VALUE_FIELD =
{
    "PD_OCCUPANCY_VALUE",
#if RU_INCLUDE_DESC
    "PD_OCCUPANCY_VALUE",
    "if PD_OCCUPANCY_EN == 1 then"
    "Aggregations of queues with more than byte_occupacny of (PD_OCCUPNACY > 0) ?2 ^ (PD_OCCUPANCY + 5):0 are not closed on timeout.",
#endif
    QM_GLOBAL_CFG_QM_AGGREGATION_TIMER_CTRL_PD_OCCUPANCY_VALUE_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_QM_AGGREGATION_TIMER_CTRL_PD_OCCUPANCY_VALUE_FIELD_WIDTH,
    QM_GLOBAL_CFG_QM_AGGREGATION_TIMER_CTRL_PD_OCCUPANCY_VALUE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_QM_AGGREGATION_TIMER_CTRL_RESERVED0
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_QM_AGGREGATION_TIMER_CTRL_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    QM_GLOBAL_CFG_QM_AGGREGATION_TIMER_CTRL_RESERVED0_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_QM_AGGREGATION_TIMER_CTRL_RESERVED0_FIELD_WIDTH,
    QM_GLOBAL_CFG_QM_AGGREGATION_TIMER_CTRL_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_QM_FPM_UG_GBL_CNT_FPM_GBL_CNT
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_QM_FPM_UG_GBL_CNT_FPM_GBL_CNT_FIELD =
{
    "FPM_GBL_CNT",
#if RU_INCLUDE_DESC
    "FPM_GBL_CNT",
    "FPM global counter",
#endif
    QM_GLOBAL_CFG_QM_FPM_UG_GBL_CNT_FPM_GBL_CNT_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_QM_FPM_UG_GBL_CNT_FPM_GBL_CNT_FIELD_WIDTH,
    QM_GLOBAL_CFG_QM_FPM_UG_GBL_CNT_FPM_GBL_CNT_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_QM_FPM_UG_GBL_CNT_RESERVED0
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_QM_FPM_UG_GBL_CNT_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    QM_GLOBAL_CFG_QM_FPM_UG_GBL_CNT_RESERVED0_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_QM_FPM_UG_GBL_CNT_RESERVED0_FIELD_WIDTH,
    QM_GLOBAL_CFG_QM_FPM_UG_GBL_CNT_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_QM_EGRESS_FLUSH_QUEUE_QUEUE_NUM
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_QM_EGRESS_FLUSH_QUEUE_QUEUE_NUM_FIELD =
{
    "QUEUE_NUM",
#if RU_INCLUDE_DESC
    "QUEUE_NUM",
    "Queue num",
#endif
    QM_GLOBAL_CFG_QM_EGRESS_FLUSH_QUEUE_QUEUE_NUM_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_QM_EGRESS_FLUSH_QUEUE_QUEUE_NUM_FIELD_WIDTH,
    QM_GLOBAL_CFG_QM_EGRESS_FLUSH_QUEUE_QUEUE_NUM_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_QM_EGRESS_FLUSH_QUEUE_FLUSH_EN
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_QM_EGRESS_FLUSH_QUEUE_FLUSH_EN_FIELD =
{
    "FLUSH_EN",
#if RU_INCLUDE_DESC
    "FLUSH_EN",
    "flush queue enable",
#endif
    QM_GLOBAL_CFG_QM_EGRESS_FLUSH_QUEUE_FLUSH_EN_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_QM_EGRESS_FLUSH_QUEUE_FLUSH_EN_FIELD_WIDTH,
    QM_GLOBAL_CFG_QM_EGRESS_FLUSH_QUEUE_FLUSH_EN_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_QM_EGRESS_FLUSH_QUEUE_RESERVED0
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_QM_EGRESS_FLUSH_QUEUE_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    QM_GLOBAL_CFG_QM_EGRESS_FLUSH_QUEUE_RESERVED0_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_QM_EGRESS_FLUSH_QUEUE_RESERVED0_FIELD_WIDTH,
    QM_GLOBAL_CFG_QM_EGRESS_FLUSH_QUEUE_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_DDR_SPARE_ROOM_DDR_HEADROOM
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_DDR_SPARE_ROOM_DDR_HEADROOM_FIELD =
{
    "DDR_HEADROOM",
#if RU_INCLUDE_DESC
    "DDR_HEADROOM",
    "DDR headroom space",
#endif
    QM_GLOBAL_CFG_DDR_SPARE_ROOM_DDR_HEADROOM_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_DDR_SPARE_ROOM_DDR_HEADROOM_FIELD_WIDTH,
    QM_GLOBAL_CFG_DDR_SPARE_ROOM_DDR_HEADROOM_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_DDR_SPARE_ROOM_RESERVED0
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_DDR_SPARE_ROOM_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    QM_GLOBAL_CFG_DDR_SPARE_ROOM_RESERVED0_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_DDR_SPARE_ROOM_RESERVED0_FIELD_WIDTH,
    QM_GLOBAL_CFG_DDR_SPARE_ROOM_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_DDR_SPARE_ROOM_DDR_TAILROOM
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_DDR_SPARE_ROOM_DDR_TAILROOM_FIELD =
{
    "DDR_TAILROOM",
#if RU_INCLUDE_DESC
    "DDR_TAILROOM",
    "DDR tailroom in bytes"
    "",
#endif
    QM_GLOBAL_CFG_DDR_SPARE_ROOM_DDR_TAILROOM_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_DDR_SPARE_ROOM_DDR_TAILROOM_FIELD_WIDTH,
    QM_GLOBAL_CFG_DDR_SPARE_ROOM_DDR_TAILROOM_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_DDR_SPARE_ROOM_RESERVED1
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_DDR_SPARE_ROOM_RESERVED1_FIELD =
{
    "RESERVED1",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    QM_GLOBAL_CFG_DDR_SPARE_ROOM_RESERVED1_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_DDR_SPARE_ROOM_RESERVED1_FIELD_WIDTH,
    QM_GLOBAL_CFG_DDR_SPARE_ROOM_RESERVED1_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_DUMMY_SPARE_ROOM_PROFILE_ID_DUMMY_PROFILE_0
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_DUMMY_SPARE_ROOM_PROFILE_ID_DUMMY_PROFILE_0_FIELD =
{
    "DUMMY_PROFILE_0",
#if RU_INCLUDE_DESC
    "DUMMY_PROFILE_0",
    "DDR dummy spare room profile 0",
#endif
    QM_GLOBAL_CFG_DUMMY_SPARE_ROOM_PROFILE_ID_DUMMY_PROFILE_0_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_DUMMY_SPARE_ROOM_PROFILE_ID_DUMMY_PROFILE_0_FIELD_WIDTH,
    QM_GLOBAL_CFG_DUMMY_SPARE_ROOM_PROFILE_ID_DUMMY_PROFILE_0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_DUMMY_SPARE_ROOM_PROFILE_ID_RESERVED0
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_DUMMY_SPARE_ROOM_PROFILE_ID_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    QM_GLOBAL_CFG_DUMMY_SPARE_ROOM_PROFILE_ID_RESERVED0_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_DUMMY_SPARE_ROOM_PROFILE_ID_RESERVED0_FIELD_WIDTH,
    QM_GLOBAL_CFG_DUMMY_SPARE_ROOM_PROFILE_ID_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_DUMMY_SPARE_ROOM_PROFILE_ID_DUMMY_PROFILE_1
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_DUMMY_SPARE_ROOM_PROFILE_ID_DUMMY_PROFILE_1_FIELD =
{
    "DUMMY_PROFILE_1",
#if RU_INCLUDE_DESC
    "DUMMY_PROFILE_1",
    "DDR dummy spare room profile 1",
#endif
    QM_GLOBAL_CFG_DUMMY_SPARE_ROOM_PROFILE_ID_DUMMY_PROFILE_1_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_DUMMY_SPARE_ROOM_PROFILE_ID_DUMMY_PROFILE_1_FIELD_WIDTH,
    QM_GLOBAL_CFG_DUMMY_SPARE_ROOM_PROFILE_ID_DUMMY_PROFILE_1_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_DUMMY_SPARE_ROOM_PROFILE_ID_RESERVED1
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_DUMMY_SPARE_ROOM_PROFILE_ID_RESERVED1_FIELD =
{
    "RESERVED1",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    QM_GLOBAL_CFG_DUMMY_SPARE_ROOM_PROFILE_ID_RESERVED1_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_DUMMY_SPARE_ROOM_PROFILE_ID_RESERVED1_FIELD_WIDTH,
    QM_GLOBAL_CFG_DUMMY_SPARE_ROOM_PROFILE_ID_RESERVED1_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_DQM_UBUS_CTRL_TKN_REQOUT_H
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_DQM_UBUS_CTRL_TKN_REQOUT_H_FIELD =
{
    "TKN_REQOUT_H",
#if RU_INCLUDE_DESC
    "TKN_REQOUT_H",
    "token reqout hspace. less then this values FSM stays at idle",
#endif
    QM_GLOBAL_CFG_DQM_UBUS_CTRL_TKN_REQOUT_H_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_DQM_UBUS_CTRL_TKN_REQOUT_H_FIELD_WIDTH,
    QM_GLOBAL_CFG_DQM_UBUS_CTRL_TKN_REQOUT_H_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_DQM_UBUS_CTRL_TKN_REQOUT_D
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_DQM_UBUS_CTRL_TKN_REQOUT_D_FIELD =
{
    "TKN_REQOUT_D",
#if RU_INCLUDE_DESC
    "TKN_REQOUT_D",
    "token reqout dspace. less then this values FSM stays at idle",
#endif
    QM_GLOBAL_CFG_DQM_UBUS_CTRL_TKN_REQOUT_D_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_DQM_UBUS_CTRL_TKN_REQOUT_D_FIELD_WIDTH,
    QM_GLOBAL_CFG_DQM_UBUS_CTRL_TKN_REQOUT_D_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_DQM_UBUS_CTRL_OFFLOAD_REQOUT_H
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_DQM_UBUS_CTRL_OFFLOAD_REQOUT_H_FIELD =
{
    "OFFLOAD_REQOUT_H",
#if RU_INCLUDE_DESC
    "OFFLOAD_REQOUT_H",
    "offload reqout hspace. less then this values FSM stays at idle",
#endif
    QM_GLOBAL_CFG_DQM_UBUS_CTRL_OFFLOAD_REQOUT_H_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_DQM_UBUS_CTRL_OFFLOAD_REQOUT_H_FIELD_WIDTH,
    QM_GLOBAL_CFG_DQM_UBUS_CTRL_OFFLOAD_REQOUT_H_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_DQM_UBUS_CTRL_OFFLOAD_REQOUT_D
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_DQM_UBUS_CTRL_OFFLOAD_REQOUT_D_FIELD =
{
    "OFFLOAD_REQOUT_D",
#if RU_INCLUDE_DESC
    "OFFLOAD_REQOUT_D",
    "offload reqout dspace. less then this values FSM stays at idle"
    ""
    "IMPORTANT: RDPDEVEL-1057"
    "The correct value should be 4 however the reset value is 5. The correct value must to be written by SW.",
#endif
    QM_GLOBAL_CFG_DQM_UBUS_CTRL_OFFLOAD_REQOUT_D_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_DQM_UBUS_CTRL_OFFLOAD_REQOUT_D_FIELD_WIDTH,
    QM_GLOBAL_CFG_DQM_UBUS_CTRL_OFFLOAD_REQOUT_D_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_MEM_AUTO_INIT_MEM_INIT_EN
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_MEM_AUTO_INIT_MEM_INIT_EN_FIELD =
{
    "MEM_INIT_EN",
#if RU_INCLUDE_DESC
    "MEMORY_INIT_EN",
    "Memory auto init enable",
#endif
    QM_GLOBAL_CFG_MEM_AUTO_INIT_MEM_INIT_EN_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_MEM_AUTO_INIT_MEM_INIT_EN_FIELD_WIDTH,
    QM_GLOBAL_CFG_MEM_AUTO_INIT_MEM_INIT_EN_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_MEM_AUTO_INIT_RESERVED0
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_MEM_AUTO_INIT_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    QM_GLOBAL_CFG_MEM_AUTO_INIT_RESERVED0_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_MEM_AUTO_INIT_RESERVED0_FIELD_WIDTH,
    QM_GLOBAL_CFG_MEM_AUTO_INIT_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_MEM_AUTO_INIT_MEM_SEL_INIT
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_MEM_AUTO_INIT_MEM_SEL_INIT_FIELD =
{
    "MEM_SEL_INIT",
#if RU_INCLUDE_DESC
    "MEMORY_SELECT_INIT",
    "Select which memory to AUTO INIT"
    ""
    "3b000: qm_total_valid_counter"
    "3b001: qm_drop_counter"
    "3b010: qm_dqm_valid_counter"
    "3b011: qm_epon_rpt_cnt_counter"
    "3b111: All memoires",
#endif
    QM_GLOBAL_CFG_MEM_AUTO_INIT_MEM_SEL_INIT_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_MEM_AUTO_INIT_MEM_SEL_INIT_FIELD_WIDTH,
    QM_GLOBAL_CFG_MEM_AUTO_INIT_MEM_SEL_INIT_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_MEM_AUTO_INIT_RESERVED1
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_MEM_AUTO_INIT_RESERVED1_FIELD =
{
    "RESERVED1",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    QM_GLOBAL_CFG_MEM_AUTO_INIT_RESERVED1_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_MEM_AUTO_INIT_RESERVED1_FIELD_WIDTH,
    QM_GLOBAL_CFG_MEM_AUTO_INIT_RESERVED1_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_MEM_AUTO_INIT_MEM_SIZE_INIT
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_MEM_AUTO_INIT_MEM_SIZE_INIT_FIELD =
{
    "MEM_SIZE_INIT",
#if RU_INCLUDE_DESC
    "MEMORY_SELECT_SIZE",
    "What is the size of the memory (according to the Number of Qs)"
    ""
    "2b00: 96"
    "2b01: 128"
    "2b10: 160"
    "2b11: 288",
#endif
    QM_GLOBAL_CFG_MEM_AUTO_INIT_MEM_SIZE_INIT_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_MEM_AUTO_INIT_MEM_SIZE_INIT_FIELD_WIDTH,
    QM_GLOBAL_CFG_MEM_AUTO_INIT_MEM_SIZE_INIT_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_MEM_AUTO_INIT_RESERVED2
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_MEM_AUTO_INIT_RESERVED2_FIELD =
{
    "RESERVED2",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    QM_GLOBAL_CFG_MEM_AUTO_INIT_RESERVED2_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_MEM_AUTO_INIT_RESERVED2_FIELD_WIDTH,
    QM_GLOBAL_CFG_MEM_AUTO_INIT_RESERVED2_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_MEM_AUTO_INIT_STS_MEM_INIT_DONE
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_MEM_AUTO_INIT_STS_MEM_INIT_DONE_FIELD =
{
    "MEM_INIT_DONE",
#if RU_INCLUDE_DESC
    "MEMORY_INIT_DONE",
    "Memory auto init done"
    "Bit is asserted when init is done."
    "Bit is de-asserted when init starts",
#endif
    QM_GLOBAL_CFG_MEM_AUTO_INIT_STS_MEM_INIT_DONE_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_MEM_AUTO_INIT_STS_MEM_INIT_DONE_FIELD_WIDTH,
    QM_GLOBAL_CFG_MEM_AUTO_INIT_STS_MEM_INIT_DONE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_MEM_AUTO_INIT_STS_RESERVED0
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_MEM_AUTO_INIT_STS_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    QM_GLOBAL_CFG_MEM_AUTO_INIT_STS_RESERVED0_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_MEM_AUTO_INIT_STS_RESERVED0_FIELD_WIDTH,
    QM_GLOBAL_CFG_MEM_AUTO_INIT_STS_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_SIZE_TOKENS_POOL_0_NUM_OF_TKNS
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_SIZE_TOKENS_POOL_0_NUM_OF_TKNS_FIELD =
{
    "POOL_0_NUM_OF_TKNS",
#if RU_INCLUDE_DESC
    "POOL_0_NUMBER_OF_TOKENS",
    "Number of tokens used for each buffer in pool0",
#endif
    QM_GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_SIZE_TOKENS_POOL_0_NUM_OF_TKNS_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_SIZE_TOKENS_POOL_0_NUM_OF_TKNS_FIELD_WIDTH,
    QM_GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_SIZE_TOKENS_POOL_0_NUM_OF_TKNS_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_SIZE_TOKENS_RESERVED0
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_SIZE_TOKENS_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    QM_GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_SIZE_TOKENS_RESERVED0_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_SIZE_TOKENS_RESERVED0_FIELD_WIDTH,
    QM_GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_SIZE_TOKENS_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_SIZE_TOKENS_POOL_1_NUM_OF_TKNS
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_SIZE_TOKENS_POOL_1_NUM_OF_TKNS_FIELD =
{
    "POOL_1_NUM_OF_TKNS",
#if RU_INCLUDE_DESC
    "POOL_1_NUMBER_OF_TOKENS",
    "Number of tokens used for each buffer in pool1",
#endif
    QM_GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_SIZE_TOKENS_POOL_1_NUM_OF_TKNS_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_SIZE_TOKENS_POOL_1_NUM_OF_TKNS_FIELD_WIDTH,
    QM_GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_SIZE_TOKENS_POOL_1_NUM_OF_TKNS_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_SIZE_TOKENS_RESERVED1
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_SIZE_TOKENS_RESERVED1_FIELD =
{
    "RESERVED1",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    QM_GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_SIZE_TOKENS_RESERVED1_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_SIZE_TOKENS_RESERVED1_FIELD_WIDTH,
    QM_GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_SIZE_TOKENS_RESERVED1_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_SIZE_TOKENS_POOL_2_NUM_OF_TKNS
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_SIZE_TOKENS_POOL_2_NUM_OF_TKNS_FIELD =
{
    "POOL_2_NUM_OF_TKNS",
#if RU_INCLUDE_DESC
    "POOL_2_NUMBER_OF_TOKENS",
    "Number of tokens used for each buffer in pool2",
#endif
    QM_GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_SIZE_TOKENS_POOL_2_NUM_OF_TKNS_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_SIZE_TOKENS_POOL_2_NUM_OF_TKNS_FIELD_WIDTH,
    QM_GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_SIZE_TOKENS_POOL_2_NUM_OF_TKNS_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_SIZE_TOKENS_RESERVED2
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_SIZE_TOKENS_RESERVED2_FIELD =
{
    "RESERVED2",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    QM_GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_SIZE_TOKENS_RESERVED2_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_SIZE_TOKENS_RESERVED2_FIELD_WIDTH,
    QM_GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_SIZE_TOKENS_RESERVED2_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_SIZE_TOKENS_POOL_3_NUM_OF_TKNS
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_SIZE_TOKENS_POOL_3_NUM_OF_TKNS_FIELD =
{
    "POOL_3_NUM_OF_TKNS",
#if RU_INCLUDE_DESC
    "POOL_3_NUMBER_OF_TOKENS",
    "Number of tokens used for each buffer in pool3",
#endif
    QM_GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_SIZE_TOKENS_POOL_3_NUM_OF_TKNS_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_SIZE_TOKENS_POOL_3_NUM_OF_TKNS_FIELD_WIDTH,
    QM_GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_SIZE_TOKENS_POOL_3_NUM_OF_TKNS_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_SIZE_TOKENS_RESERVED3
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_SIZE_TOKENS_RESERVED3_FIELD =
{
    "RESERVED3",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    QM_GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_SIZE_TOKENS_RESERVED3_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_SIZE_TOKENS_RESERVED3_FIELD_WIDTH,
    QM_GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_SIZE_TOKENS_RESERVED3_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_0_1_SIZE_BYTE_POOL_0_NUM_OF_BYTES
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_0_1_SIZE_BYTE_POOL_0_NUM_OF_BYTES_FIELD =
{
    "POOL_0_NUM_OF_BYTES",
#if RU_INCLUDE_DESC
    "POOL_0_NUMBER_OF_BYTES",
    "Number of bytes used for each buffer in pool0 - Up to 16K",
#endif
    QM_GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_0_1_SIZE_BYTE_POOL_0_NUM_OF_BYTES_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_0_1_SIZE_BYTE_POOL_0_NUM_OF_BYTES_FIELD_WIDTH,
    QM_GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_0_1_SIZE_BYTE_POOL_0_NUM_OF_BYTES_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_0_1_SIZE_BYTE_RESERVED0
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_0_1_SIZE_BYTE_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    QM_GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_0_1_SIZE_BYTE_RESERVED0_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_0_1_SIZE_BYTE_RESERVED0_FIELD_WIDTH,
    QM_GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_0_1_SIZE_BYTE_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_0_1_SIZE_BYTE_POOL_1_NUM_OF_BYTES
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_0_1_SIZE_BYTE_POOL_1_NUM_OF_BYTES_FIELD =
{
    "POOL_1_NUM_OF_BYTES",
#if RU_INCLUDE_DESC
    "POOL_1_NUMBER_OF_BYTES",
    "Number of Bytes used for each buffer in pool1",
#endif
    QM_GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_0_1_SIZE_BYTE_POOL_1_NUM_OF_BYTES_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_0_1_SIZE_BYTE_POOL_1_NUM_OF_BYTES_FIELD_WIDTH,
    QM_GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_0_1_SIZE_BYTE_POOL_1_NUM_OF_BYTES_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_0_1_SIZE_BYTE_RESERVED1
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_0_1_SIZE_BYTE_RESERVED1_FIELD =
{
    "RESERVED1",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    QM_GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_0_1_SIZE_BYTE_RESERVED1_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_0_1_SIZE_BYTE_RESERVED1_FIELD_WIDTH,
    QM_GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_0_1_SIZE_BYTE_RESERVED1_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_2_3_SIZE_BYTE_POOL_2_NUM_OF_BYTES
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_2_3_SIZE_BYTE_POOL_2_NUM_OF_BYTES_FIELD =
{
    "POOL_2_NUM_OF_BYTES",
#if RU_INCLUDE_DESC
    "POOL_2_NUMBER_OF_BYTES",
    "Number of bytes used for each buffer in pool0 - Up to 16K",
#endif
    QM_GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_2_3_SIZE_BYTE_POOL_2_NUM_OF_BYTES_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_2_3_SIZE_BYTE_POOL_2_NUM_OF_BYTES_FIELD_WIDTH,
    QM_GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_2_3_SIZE_BYTE_POOL_2_NUM_OF_BYTES_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_2_3_SIZE_BYTE_RESERVED0
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_2_3_SIZE_BYTE_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    QM_GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_2_3_SIZE_BYTE_RESERVED0_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_2_3_SIZE_BYTE_RESERVED0_FIELD_WIDTH,
    QM_GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_2_3_SIZE_BYTE_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_2_3_SIZE_BYTE_POOL_3_NUM_OF_BYTES
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_2_3_SIZE_BYTE_POOL_3_NUM_OF_BYTES_FIELD =
{
    "POOL_3_NUM_OF_BYTES",
#if RU_INCLUDE_DESC
    "POOL_3_NUMBER_OF_BYTES",
    "Number of Bytes used for each buffer in pool1",
#endif
    QM_GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_2_3_SIZE_BYTE_POOL_3_NUM_OF_BYTES_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_2_3_SIZE_BYTE_POOL_3_NUM_OF_BYTES_FIELD_WIDTH,
    QM_GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_2_3_SIZE_BYTE_POOL_3_NUM_OF_BYTES_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_2_3_SIZE_BYTE_RESERVED1
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_2_3_SIZE_BYTE_RESERVED1_FIELD =
{
    "RESERVED1",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    QM_GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_2_3_SIZE_BYTE_RESERVED1_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_2_3_SIZE_BYTE_RESERVED1_FIELD_WIDTH,
    QM_GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_2_3_SIZE_BYTE_RESERVED1_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_MC_CTRL_RESERVED0
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_MC_CTRL_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    QM_GLOBAL_CFG_MC_CTRL_RESERVED0_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_MC_CTRL_RESERVED0_FIELD_WIDTH,
    QM_GLOBAL_CFG_MC_CTRL_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_MC_CTRL_MC_HEADERS_POOL_SEL
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_MC_CTRL_MC_HEADERS_POOL_SEL_FIELD =
{
    "MC_HEADERS_POOL_SEL",
#if RU_INCLUDE_DESC
    "MC_HEADERS_POOL_SELECTION",
    "This register sets the size of the pool to use for MC headers."
    "Since the 256K FPM PD Format does not have a field indicating the pool size, there should be an explicit configuration for which pool to use."
    ""
    "-> POOL0 - Use 8 buffers"
    "-> POOL1 - Use 4 buffers"
    "-> POOL2 - Use 2 buffers"
    "-> POOL3 - Use 1 buffers"
    ""
    "This configuration needs to take into account the min_buffer_size in order to make sure that the correct pool is chosen for multicast headers.",
#endif
    QM_GLOBAL_CFG_MC_CTRL_MC_HEADERS_POOL_SEL_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_MC_CTRL_MC_HEADERS_POOL_SEL_FIELD_WIDTH,
    QM_GLOBAL_CFG_MC_CTRL_MC_HEADERS_POOL_SEL_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG_MC_CTRL_RESERVED1
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG_MC_CTRL_RESERVED1_FIELD =
{
    "RESERVED1",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    QM_GLOBAL_CFG_MC_CTRL_RESERVED1_FIELD_MASK,
    0,
    QM_GLOBAL_CFG_MC_CTRL_RESERVED1_FIELD_WIDTH,
    QM_GLOBAL_CFG_MC_CTRL_RESERVED1_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_FPM_POOLS_THR_FPM_LOWER_THR
 ******************************************************************************/
const ru_field_rec QM_FPM_POOLS_THR_FPM_LOWER_THR_FIELD =
{
    "FPM_LOWER_THR",
#if RU_INCLUDE_DESC
    "FPM_LOWER_THR",
    "FPM Lower Threshold."
    "When working in packet drop mode (FPM_BP_ENABLE=0), Then:"
    "* If (FPM pool occupancy) <= (FPM_LOWER_THR), then packets in low/high priority are dropped (only exclusive packets are not dropped)."
    "* If (FPM_LOWER_THR) < (FPM pool occupancy) <= (FPM_HIGHER_THR), then packets in low priority are dropped."
    "* If (FPM pool occupancy) > (FPM_HIGHER_THR), then no packets are dropped."
    "When working in backpressure mode (FPM_BP_ENABLE=1), Then if (FPM pool occupancy) < (FPM_LOWER_THR), then backpressure is applied to re-order (in this case FPM_HIGHER_THR is dont care).",
#endif
    QM_FPM_POOLS_THR_FPM_LOWER_THR_FIELD_MASK,
    0,
    QM_FPM_POOLS_THR_FPM_LOWER_THR_FIELD_WIDTH,
    QM_FPM_POOLS_THR_FPM_LOWER_THR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_FPM_POOLS_THR_RESERVED0
 ******************************************************************************/
const ru_field_rec QM_FPM_POOLS_THR_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    QM_FPM_POOLS_THR_RESERVED0_FIELD_MASK,
    0,
    QM_FPM_POOLS_THR_RESERVED0_FIELD_WIDTH,
    QM_FPM_POOLS_THR_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_FPM_POOLS_THR_FPM_HIGHER_THR
 ******************************************************************************/
const ru_field_rec QM_FPM_POOLS_THR_FPM_HIGHER_THR_FIELD =
{
    "FPM_HIGHER_THR",
#if RU_INCLUDE_DESC
    "FPM_HIGHER_THR",
    "FPM Higher Threshold."
    "When working in packet drop mode (FPM_BP_ENABLE=0), Then:"
    "* If (FPM pool occupancy) <= (FPM_LOWER_THR), then packets in low/high priority are dropped (only exclusive packets are not dropped)."
    "* If (FPM_LOWER_THR) < (FPM pool occupancy) <= (FPM_HIGHER_THR), then packets in low priority are dropped."
    "* If (FPM pool occupancy) > (FPM_HIGHER_THR), then no packets are dropped."
    "When working in backpressure mode (FPM_BP_ENABLE=1), Then if (FPM pool occupancy) < (FPM_LOWER_THR), then backpressure is applied to re-order (in this case FPM_HIGHER_THR is dont care).",
#endif
    QM_FPM_POOLS_THR_FPM_HIGHER_THR_FIELD_MASK,
    0,
    QM_FPM_POOLS_THR_FPM_HIGHER_THR_FIELD_WIDTH,
    QM_FPM_POOLS_THR_FPM_HIGHER_THR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_FPM_POOLS_THR_RESERVED1
 ******************************************************************************/
const ru_field_rec QM_FPM_POOLS_THR_RESERVED1_FIELD =
{
    "RESERVED1",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    QM_FPM_POOLS_THR_RESERVED1_FIELD_MASK,
    0,
    QM_FPM_POOLS_THR_RESERVED1_FIELD_WIDTH,
    QM_FPM_POOLS_THR_RESERVED1_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_FPM_USR_GRP_LOWER_THR_FPM_GRP_LOWER_THR
 ******************************************************************************/
const ru_field_rec QM_FPM_USR_GRP_LOWER_THR_FPM_GRP_LOWER_THR_FIELD =
{
    "FPM_GRP_LOWER_THR",
#if RU_INCLUDE_DESC
    "FPM_GRP_LOWER_THR",
    "FPM group Lower Threshold."
    "* If (FPM User Group Counter) > (FPM_GRP_HIGHER_THR), all packets in this user group are dropped."
    "* If (FPM_GRP_MID_THR) < (FPM User Group Counter) <= (FPM_GRP_HIGHER_THR), then packets in low/high priority are dropped (only exclusive packets are not dropped)."
    "* If (FPM_GRP_LOWER_THR) < (FPM User Group Counter) <= (FPM_GRP_MID_THR), then packets in low priority are dropped."
    "* If (FPM User Group Counter) <= (FPM_GRP_LOWER_THR), then no packets are dropped.",
#endif
    QM_FPM_USR_GRP_LOWER_THR_FPM_GRP_LOWER_THR_FIELD_MASK,
    0,
    QM_FPM_USR_GRP_LOWER_THR_FPM_GRP_LOWER_THR_FIELD_WIDTH,
    QM_FPM_USR_GRP_LOWER_THR_FPM_GRP_LOWER_THR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_FPM_USR_GRP_LOWER_THR_RESERVED0
 ******************************************************************************/
const ru_field_rec QM_FPM_USR_GRP_LOWER_THR_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    QM_FPM_USR_GRP_LOWER_THR_RESERVED0_FIELD_MASK,
    0,
    QM_FPM_USR_GRP_LOWER_THR_RESERVED0_FIELD_WIDTH,
    QM_FPM_USR_GRP_LOWER_THR_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_FPM_USR_GRP_MID_THR_FPM_GRP_MID_THR
 ******************************************************************************/
const ru_field_rec QM_FPM_USR_GRP_MID_THR_FPM_GRP_MID_THR_FIELD =
{
    "FPM_GRP_MID_THR",
#if RU_INCLUDE_DESC
    "FPM_GRP_MID_THR",
    "FPM group Lower Threshold."
    "* If (FPM User Group Counter) > (FPM_GRP_HIGHER_THR), all packets in this user group are dropped."
    "* If (FPM_GRP_MID_THR) < (FPM User Group Counter) <= (FPM_GRP_HIGHER_THR), then packets in low/high priority are dropped (only exclusive packets are not dropped)."
    "* If (FPM_GRP_LOWER_THR) < (FPM User Group Counter) <= (FPM_GRP_MID_THR), then packets in low priority are dropped."
    "* If (FPM User Group Counter) <= (FPM_GRP_LOWER_THR), then no packets are dropped.",
#endif
    QM_FPM_USR_GRP_MID_THR_FPM_GRP_MID_THR_FIELD_MASK,
    0,
    QM_FPM_USR_GRP_MID_THR_FPM_GRP_MID_THR_FIELD_WIDTH,
    QM_FPM_USR_GRP_MID_THR_FPM_GRP_MID_THR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_FPM_USR_GRP_MID_THR_RESERVED0
 ******************************************************************************/
const ru_field_rec QM_FPM_USR_GRP_MID_THR_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    QM_FPM_USR_GRP_MID_THR_RESERVED0_FIELD_MASK,
    0,
    QM_FPM_USR_GRP_MID_THR_RESERVED0_FIELD_WIDTH,
    QM_FPM_USR_GRP_MID_THR_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_FPM_USR_GRP_HIGHER_THR_FPM_GRP_HIGHER_THR
 ******************************************************************************/
const ru_field_rec QM_FPM_USR_GRP_HIGHER_THR_FPM_GRP_HIGHER_THR_FIELD =
{
    "FPM_GRP_HIGHER_THR",
#if RU_INCLUDE_DESC
    "FPM_GRP_HIGHER_THR",
    "FPM group Lower Threshold."
    "* If (FPM User Group Counter) > (FPM_GRP_HIGHER_THR), all packets in this user group are dropped."
    "* If (FPM_GRP_MID_THR) < (FPM User Group Counter) <= (FPM_GRP_HIGHER_THR), then packets in low/high priority are dropped (only exclusive packets are not dropped)."
    "* If (FPM_GRP_LOWER_THR) < (FPM User Group Counter) <= (FPM_GRP_MID_THR), then packets in low priority are dropped."
    "* If (FPM User Group Counter) <= (FPM_GRP_LOWER_THR), then no packets are dropped.",
#endif
    QM_FPM_USR_GRP_HIGHER_THR_FPM_GRP_HIGHER_THR_FIELD_MASK,
    0,
    QM_FPM_USR_GRP_HIGHER_THR_FPM_GRP_HIGHER_THR_FIELD_WIDTH,
    QM_FPM_USR_GRP_HIGHER_THR_FPM_GRP_HIGHER_THR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_FPM_USR_GRP_HIGHER_THR_RESERVED0
 ******************************************************************************/
const ru_field_rec QM_FPM_USR_GRP_HIGHER_THR_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    QM_FPM_USR_GRP_HIGHER_THR_RESERVED0_FIELD_MASK,
    0,
    QM_FPM_USR_GRP_HIGHER_THR_RESERVED0_FIELD_WIDTH,
    QM_FPM_USR_GRP_HIGHER_THR_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_FPM_USR_GRP_CNT_FPM_UG_CNT
 ******************************************************************************/
const ru_field_rec QM_FPM_USR_GRP_CNT_FPM_UG_CNT_FIELD =
{
    "FPM_UG_CNT",
#if RU_INCLUDE_DESC
    "FPM_UG_CNT",
    "FPM user group counter",
#endif
    QM_FPM_USR_GRP_CNT_FPM_UG_CNT_FIELD_MASK,
    0,
    QM_FPM_USR_GRP_CNT_FPM_UG_CNT_FIELD_WIDTH,
    QM_FPM_USR_GRP_CNT_FPM_UG_CNT_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_FPM_USR_GRP_CNT_RESERVED0
 ******************************************************************************/
const ru_field_rec QM_FPM_USR_GRP_CNT_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    QM_FPM_USR_GRP_CNT_RESERVED0_FIELD_MASK,
    0,
    QM_FPM_USR_GRP_CNT_RESERVED0_FIELD_WIDTH,
    QM_FPM_USR_GRP_CNT_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_RUNNER_GRP_RNR_CONFIG_RNR_BB_ID
 ******************************************************************************/
const ru_field_rec QM_RUNNER_GRP_RNR_CONFIG_RNR_BB_ID_FIELD =
{
    "RNR_BB_ID",
#if RU_INCLUDE_DESC
    "RNR_BB_ID",
    "Runner BB ID associated with this configuration.",
#endif
    QM_RUNNER_GRP_RNR_CONFIG_RNR_BB_ID_FIELD_MASK,
    0,
    QM_RUNNER_GRP_RNR_CONFIG_RNR_BB_ID_FIELD_WIDTH,
    QM_RUNNER_GRP_RNR_CONFIG_RNR_BB_ID_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_RUNNER_GRP_RNR_CONFIG_RESERVED0
 ******************************************************************************/
const ru_field_rec QM_RUNNER_GRP_RNR_CONFIG_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    QM_RUNNER_GRP_RNR_CONFIG_RESERVED0_FIELD_MASK,
    0,
    QM_RUNNER_GRP_RNR_CONFIG_RESERVED0_FIELD_WIDTH,
    QM_RUNNER_GRP_RNR_CONFIG_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_RUNNER_GRP_RNR_CONFIG_RNR_TASK
 ******************************************************************************/
const ru_field_rec QM_RUNNER_GRP_RNR_CONFIG_RNR_TASK_FIELD =
{
    "RNR_TASK",
#if RU_INCLUDE_DESC
    "RNR_TASK",
    "Runner Task number to be woken up when the update FIFO is written to.",
#endif
    QM_RUNNER_GRP_RNR_CONFIG_RNR_TASK_FIELD_MASK,
    0,
    QM_RUNNER_GRP_RNR_CONFIG_RNR_TASK_FIELD_WIDTH,
    QM_RUNNER_GRP_RNR_CONFIG_RNR_TASK_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_RUNNER_GRP_RNR_CONFIG_RESERVED1
 ******************************************************************************/
const ru_field_rec QM_RUNNER_GRP_RNR_CONFIG_RESERVED1_FIELD =
{
    "RESERVED1",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    QM_RUNNER_GRP_RNR_CONFIG_RESERVED1_FIELD_MASK,
    0,
    QM_RUNNER_GRP_RNR_CONFIG_RESERVED1_FIELD_WIDTH,
    QM_RUNNER_GRP_RNR_CONFIG_RESERVED1_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_RUNNER_GRP_RNR_CONFIG_RNR_ENABLE
 ******************************************************************************/
const ru_field_rec QM_RUNNER_GRP_RNR_CONFIG_RNR_ENABLE_FIELD =
{
    "RNR_ENABLE",
#if RU_INCLUDE_DESC
    "RNR_ENABLE",
    "Enable this runner interface",
#endif
    QM_RUNNER_GRP_RNR_CONFIG_RNR_ENABLE_FIELD_MASK,
    0,
    QM_RUNNER_GRP_RNR_CONFIG_RNR_ENABLE_FIELD_WIDTH,
    QM_RUNNER_GRP_RNR_CONFIG_RNR_ENABLE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_RUNNER_GRP_RNR_CONFIG_RESERVED2
 ******************************************************************************/
const ru_field_rec QM_RUNNER_GRP_RNR_CONFIG_RESERVED2_FIELD =
{
    "RESERVED2",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    QM_RUNNER_GRP_RNR_CONFIG_RESERVED2_FIELD_MASK,
    0,
    QM_RUNNER_GRP_RNR_CONFIG_RESERVED2_FIELD_WIDTH,
    QM_RUNNER_GRP_RNR_CONFIG_RESERVED2_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_RUNNER_GRP_QUEUE_CONFIG_START_QUEUE
 ******************************************************************************/
const ru_field_rec QM_RUNNER_GRP_QUEUE_CONFIG_START_QUEUE_FIELD =
{
    "START_QUEUE",
#if RU_INCLUDE_DESC
    "START_QUEUE",
    "Indicates the Queue that starts this runner group. Queues belonging to the runner group are defined by the following equation:"
    "START_QUEUE <= runner_queues <= END_QUEUE",
#endif
    QM_RUNNER_GRP_QUEUE_CONFIG_START_QUEUE_FIELD_MASK,
    0,
    QM_RUNNER_GRP_QUEUE_CONFIG_START_QUEUE_FIELD_WIDTH,
    QM_RUNNER_GRP_QUEUE_CONFIG_START_QUEUE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_RUNNER_GRP_QUEUE_CONFIG_RESERVED0
 ******************************************************************************/
const ru_field_rec QM_RUNNER_GRP_QUEUE_CONFIG_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    QM_RUNNER_GRP_QUEUE_CONFIG_RESERVED0_FIELD_MASK,
    0,
    QM_RUNNER_GRP_QUEUE_CONFIG_RESERVED0_FIELD_WIDTH,
    QM_RUNNER_GRP_QUEUE_CONFIG_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_RUNNER_GRP_QUEUE_CONFIG_END_QUEUE
 ******************************************************************************/
const ru_field_rec QM_RUNNER_GRP_QUEUE_CONFIG_END_QUEUE_FIELD =
{
    "END_QUEUE",
#if RU_INCLUDE_DESC
    "END_QUEUE",
    "Indicates the Queue that ends this runner group."
    "Queues belonging to the runner group are defined by the following equation:"
    "START_QUEUE <= runner_queues <= END_QUEUE",
#endif
    QM_RUNNER_GRP_QUEUE_CONFIG_END_QUEUE_FIELD_MASK,
    0,
    QM_RUNNER_GRP_QUEUE_CONFIG_END_QUEUE_FIELD_WIDTH,
    QM_RUNNER_GRP_QUEUE_CONFIG_END_QUEUE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_RUNNER_GRP_QUEUE_CONFIG_RESERVED1
 ******************************************************************************/
const ru_field_rec QM_RUNNER_GRP_QUEUE_CONFIG_RESERVED1_FIELD =
{
    "RESERVED1",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    QM_RUNNER_GRP_QUEUE_CONFIG_RESERVED1_FIELD_MASK,
    0,
    QM_RUNNER_GRP_QUEUE_CONFIG_RESERVED1_FIELD_WIDTH,
    QM_RUNNER_GRP_QUEUE_CONFIG_RESERVED1_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_RUNNER_GRP_PDFIFO_CONFIG_RESERVED0
 ******************************************************************************/
const ru_field_rec QM_RUNNER_GRP_PDFIFO_CONFIG_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    QM_RUNNER_GRP_PDFIFO_CONFIG_RESERVED0_FIELD_MASK,
    0,
    QM_RUNNER_GRP_PDFIFO_CONFIG_RESERVED0_FIELD_WIDTH,
    QM_RUNNER_GRP_PDFIFO_CONFIG_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_RUNNER_GRP_PDFIFO_CONFIG_BASE_ADDR
 ******************************************************************************/
const ru_field_rec QM_RUNNER_GRP_PDFIFO_CONFIG_BASE_ADDR_FIELD =
{
    "BASE_ADDR",
#if RU_INCLUDE_DESC
    "BASE_ADDR",
    "PD FIFO Base Address. This is an 8-byte address (Byte_addr = BASE_ADDR*8).",
#endif
    QM_RUNNER_GRP_PDFIFO_CONFIG_BASE_ADDR_FIELD_MASK,
    0,
    QM_RUNNER_GRP_PDFIFO_CONFIG_BASE_ADDR_FIELD_WIDTH,
    QM_RUNNER_GRP_PDFIFO_CONFIG_BASE_ADDR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_RUNNER_GRP_PDFIFO_CONFIG_RESERVED1
 ******************************************************************************/
const ru_field_rec QM_RUNNER_GRP_PDFIFO_CONFIG_RESERVED1_FIELD =
{
    "RESERVED1",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    QM_RUNNER_GRP_PDFIFO_CONFIG_RESERVED1_FIELD_MASK,
    0,
    QM_RUNNER_GRP_PDFIFO_CONFIG_RESERVED1_FIELD_WIDTH,
    QM_RUNNER_GRP_PDFIFO_CONFIG_RESERVED1_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_RUNNER_GRP_PDFIFO_CONFIG_SIZE
 ******************************************************************************/
const ru_field_rec QM_RUNNER_GRP_PDFIFO_CONFIG_SIZE_FIELD =
{
    "SIZE",
#if RU_INCLUDE_DESC
    "SIZE",
    "PD FIFO Size"
    "0 - 2 entries"
    "1 - 4 entries"
    "2 - 8 entries",
#endif
    QM_RUNNER_GRP_PDFIFO_CONFIG_SIZE_FIELD_MASK,
    0,
    QM_RUNNER_GRP_PDFIFO_CONFIG_SIZE_FIELD_WIDTH,
    QM_RUNNER_GRP_PDFIFO_CONFIG_SIZE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_RUNNER_GRP_PDFIFO_CONFIG_RESERVED2
 ******************************************************************************/
const ru_field_rec QM_RUNNER_GRP_PDFIFO_CONFIG_RESERVED2_FIELD =
{
    "RESERVED2",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    QM_RUNNER_GRP_PDFIFO_CONFIG_RESERVED2_FIELD_MASK,
    0,
    QM_RUNNER_GRP_PDFIFO_CONFIG_RESERVED2_FIELD_WIDTH,
    QM_RUNNER_GRP_PDFIFO_CONFIG_RESERVED2_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_RUNNER_GRP_UPDATE_FIFO_CONFIG_RESERVED0
 ******************************************************************************/
const ru_field_rec QM_RUNNER_GRP_UPDATE_FIFO_CONFIG_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    QM_RUNNER_GRP_UPDATE_FIFO_CONFIG_RESERVED0_FIELD_MASK,
    0,
    QM_RUNNER_GRP_UPDATE_FIFO_CONFIG_RESERVED0_FIELD_WIDTH,
    QM_RUNNER_GRP_UPDATE_FIFO_CONFIG_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_RUNNER_GRP_UPDATE_FIFO_CONFIG_BASE_ADDR
 ******************************************************************************/
const ru_field_rec QM_RUNNER_GRP_UPDATE_FIFO_CONFIG_BASE_ADDR_FIELD =
{
    "BASE_ADDR",
#if RU_INCLUDE_DESC
    "BASE_ADDR",
    "PD FIFO Base Address. This is an 8-byte address (Byte_addr = BASE_ADDR*8).",
#endif
    QM_RUNNER_GRP_UPDATE_FIFO_CONFIG_BASE_ADDR_FIELD_MASK,
    0,
    QM_RUNNER_GRP_UPDATE_FIFO_CONFIG_BASE_ADDR_FIELD_WIDTH,
    QM_RUNNER_GRP_UPDATE_FIFO_CONFIG_BASE_ADDR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_RUNNER_GRP_UPDATE_FIFO_CONFIG_RESERVED1
 ******************************************************************************/
const ru_field_rec QM_RUNNER_GRP_UPDATE_FIFO_CONFIG_RESERVED1_FIELD =
{
    "RESERVED1",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    QM_RUNNER_GRP_UPDATE_FIFO_CONFIG_RESERVED1_FIELD_MASK,
    0,
    QM_RUNNER_GRP_UPDATE_FIFO_CONFIG_RESERVED1_FIELD_WIDTH,
    QM_RUNNER_GRP_UPDATE_FIFO_CONFIG_RESERVED1_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_RUNNER_GRP_UPDATE_FIFO_CONFIG_SIZE
 ******************************************************************************/
const ru_field_rec QM_RUNNER_GRP_UPDATE_FIFO_CONFIG_SIZE_FIELD =
{
    "SIZE",
#if RU_INCLUDE_DESC
    "SIZE",
    "PD FIFO Size"
    "0 - 8 entries"
    "1 - 16 entries"
    "2 - 32 entries"
    "3 - 64 entries"
    "4 - 128 entries"
    "5 - 256 entries",
#endif
    QM_RUNNER_GRP_UPDATE_FIFO_CONFIG_SIZE_FIELD_MASK,
    0,
    QM_RUNNER_GRP_UPDATE_FIFO_CONFIG_SIZE_FIELD_WIDTH,
    QM_RUNNER_GRP_UPDATE_FIFO_CONFIG_SIZE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_RUNNER_GRP_UPDATE_FIFO_CONFIG_RESERVED2
 ******************************************************************************/
const ru_field_rec QM_RUNNER_GRP_UPDATE_FIFO_CONFIG_RESERVED2_FIELD =
{
    "RESERVED2",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    QM_RUNNER_GRP_UPDATE_FIFO_CONFIG_RESERVED2_FIELD_MASK,
    0,
    QM_RUNNER_GRP_UPDATE_FIFO_CONFIG_RESERVED2_FIELD_WIDTH,
    QM_RUNNER_GRP_UPDATE_FIFO_CONFIG_RESERVED2_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_INTR_CTRL_ISR_QM_DQM_POP_ON_EMPTY
 ******************************************************************************/
const ru_field_rec QM_INTR_CTRL_ISR_QM_DQM_POP_ON_EMPTY_FIELD =
{
    "QM_DQM_POP_ON_EMPTY",
#if RU_INCLUDE_DESC
    "QM_DQM_POP_ON_EMPTY",
    "HW tried to pop a PD from the DQM of an empty queue.",
#endif
    QM_INTR_CTRL_ISR_QM_DQM_POP_ON_EMPTY_FIELD_MASK,
    0,
    QM_INTR_CTRL_ISR_QM_DQM_POP_ON_EMPTY_FIELD_WIDTH,
    QM_INTR_CTRL_ISR_QM_DQM_POP_ON_EMPTY_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_INTR_CTRL_ISR_QM_DQM_PUSH_ON_FULL
 ******************************************************************************/
const ru_field_rec QM_INTR_CTRL_ISR_QM_DQM_PUSH_ON_FULL_FIELD =
{
    "QM_DQM_PUSH_ON_FULL",
#if RU_INCLUDE_DESC
    "QM_DQM_PUSH_ON_FULL",
    "HW tried to pop a PD into the DQM of a full queue.",
#endif
    QM_INTR_CTRL_ISR_QM_DQM_PUSH_ON_FULL_FIELD_MASK,
    0,
    QM_INTR_CTRL_ISR_QM_DQM_PUSH_ON_FULL_FIELD_WIDTH,
    QM_INTR_CTRL_ISR_QM_DQM_PUSH_ON_FULL_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_INTR_CTRL_ISR_QM_CPU_POP_ON_EMPTY
 ******************************************************************************/
const ru_field_rec QM_INTR_CTRL_ISR_QM_CPU_POP_ON_EMPTY_FIELD =
{
    "QM_CPU_POP_ON_EMPTY",
#if RU_INCLUDE_DESC
    "QM_CPU_POP_ON_EMPTY",
    "CPU tried to pop a PD from the DQM of an empty queue.",
#endif
    QM_INTR_CTRL_ISR_QM_CPU_POP_ON_EMPTY_FIELD_MASK,
    0,
    QM_INTR_CTRL_ISR_QM_CPU_POP_ON_EMPTY_FIELD_WIDTH,
    QM_INTR_CTRL_ISR_QM_CPU_POP_ON_EMPTY_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_INTR_CTRL_ISR_QM_CPU_PUSH_ON_FULL
 ******************************************************************************/
const ru_field_rec QM_INTR_CTRL_ISR_QM_CPU_PUSH_ON_FULL_FIELD =
{
    "QM_CPU_PUSH_ON_FULL",
#if RU_INCLUDE_DESC
    "QM_CPU_PUSH_ON_FULL",
    "CPU tried to push a PD into the DQM of a full queue.",
#endif
    QM_INTR_CTRL_ISR_QM_CPU_PUSH_ON_FULL_FIELD_MASK,
    0,
    QM_INTR_CTRL_ISR_QM_CPU_PUSH_ON_FULL_FIELD_WIDTH,
    QM_INTR_CTRL_ISR_QM_CPU_PUSH_ON_FULL_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_INTR_CTRL_ISR_QM_NORMAL_QUEUE_PD_NO_CREDIT
 ******************************************************************************/
const ru_field_rec QM_INTR_CTRL_ISR_QM_NORMAL_QUEUE_PD_NO_CREDIT_FIELD =
{
    "QM_NORMAL_QUEUE_PD_NO_CREDIT",
#if RU_INCLUDE_DESC
    "QM_NORMAL_QUEUE_PD_NO_CREDIT",
    "A PD arrived to the Normal queue without having any credits",
#endif
    QM_INTR_CTRL_ISR_QM_NORMAL_QUEUE_PD_NO_CREDIT_FIELD_MASK,
    0,
    QM_INTR_CTRL_ISR_QM_NORMAL_QUEUE_PD_NO_CREDIT_FIELD_WIDTH,
    QM_INTR_CTRL_ISR_QM_NORMAL_QUEUE_PD_NO_CREDIT_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_INTR_CTRL_ISR_QM_NON_DELAYED_QUEUE_PD_NO_CREDIT
 ******************************************************************************/
const ru_field_rec QM_INTR_CTRL_ISR_QM_NON_DELAYED_QUEUE_PD_NO_CREDIT_FIELD =
{
    "QM_NON_DELAYED_QUEUE_PD_NO_CREDIT",
#if RU_INCLUDE_DESC
    "QM_NON_DELAYED_QUEUE_PD_NO_CREDIT",
    "A PD arrived to the NON-delayed queue without having any credits",
#endif
    QM_INTR_CTRL_ISR_QM_NON_DELAYED_QUEUE_PD_NO_CREDIT_FIELD_MASK,
    0,
    QM_INTR_CTRL_ISR_QM_NON_DELAYED_QUEUE_PD_NO_CREDIT_FIELD_WIDTH,
    QM_INTR_CTRL_ISR_QM_NON_DELAYED_QUEUE_PD_NO_CREDIT_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_INTR_CTRL_ISR_QM_NON_VALID_QUEUE
 ******************************************************************************/
const ru_field_rec QM_INTR_CTRL_ISR_QM_NON_VALID_QUEUE_FIELD =
{
    "QM_NON_VALID_QUEUE",
#if RU_INCLUDE_DESC
    "QM_NON_VALID_QUEUE",
    "A PD arrived with a non valid queue number (>287)",
#endif
    QM_INTR_CTRL_ISR_QM_NON_VALID_QUEUE_FIELD_MASK,
    0,
    QM_INTR_CTRL_ISR_QM_NON_VALID_QUEUE_FIELD_WIDTH,
    QM_INTR_CTRL_ISR_QM_NON_VALID_QUEUE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_INTR_CTRL_ISR_QM_AGG_COHERENT_INCONSISTENCY
 ******************************************************************************/
const ru_field_rec QM_INTR_CTRL_ISR_QM_AGG_COHERENT_INCONSISTENCY_FIELD =
{
    "QM_AGG_COHERENT_INCONSISTENCY",
#if RU_INCLUDE_DESC
    "QM_AGG_COHERENT_INCONSISTENCY",
    "An aggregation of PDs was done in which the coherent bit of the PD differs between them (The coherent bit of the first aggregated PD was used)",
#endif
    QM_INTR_CTRL_ISR_QM_AGG_COHERENT_INCONSISTENCY_FIELD_MASK,
    0,
    QM_INTR_CTRL_ISR_QM_AGG_COHERENT_INCONSISTENCY_FIELD_WIDTH,
    QM_INTR_CTRL_ISR_QM_AGG_COHERENT_INCONSISTENCY_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_INTR_CTRL_ISR_QM_FORCE_COPY_ON_NON_DELAYED
 ******************************************************************************/
const ru_field_rec QM_INTR_CTRL_ISR_QM_FORCE_COPY_ON_NON_DELAYED_FIELD =
{
    "QM_FORCE_COPY_ON_NON_DELAYED",
#if RU_INCLUDE_DESC
    "QM_FORCE_COPY_ON_NON_DELAYED",
    "A PD with force copy bit set was received on the non-delayed queue (in this queue the copy machine is bypassed)",
#endif
    QM_INTR_CTRL_ISR_QM_FORCE_COPY_ON_NON_DELAYED_FIELD_MASK,
    0,
    QM_INTR_CTRL_ISR_QM_FORCE_COPY_ON_NON_DELAYED_FIELD_WIDTH,
    QM_INTR_CTRL_ISR_QM_FORCE_COPY_ON_NON_DELAYED_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_INTR_CTRL_ISR_QM_FPM_POOL_SIZE_NONEXISTENT
 ******************************************************************************/
const ru_field_rec QM_INTR_CTRL_ISR_QM_FPM_POOL_SIZE_NONEXISTENT_FIELD =
{
    "QM_FPM_POOL_SIZE_NONEXISTENT",
#if RU_INCLUDE_DESC
    "QM_FPM_POOL_SIZE_NONEXISTENT",
    "A PD was marked to be copied, but there does not exist an FPM pool buffer large enough to hold it.",
#endif
    QM_INTR_CTRL_ISR_QM_FPM_POOL_SIZE_NONEXISTENT_FIELD_MASK,
    0,
    QM_INTR_CTRL_ISR_QM_FPM_POOL_SIZE_NONEXISTENT_FIELD_WIDTH,
    QM_INTR_CTRL_ISR_QM_FPM_POOL_SIZE_NONEXISTENT_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_INTR_CTRL_ISR_QM_TARGET_MEM_ABS_CONTRADICTION
 ******************************************************************************/
const ru_field_rec QM_INTR_CTRL_ISR_QM_TARGET_MEM_ABS_CONTRADICTION_FIELD =
{
    "QM_TARGET_MEM_ABS_CONTRADICTION",
#if RU_INCLUDE_DESC
    "QM_TARGET_MEM_ABS_CONTRADICTION",
    "A PD was marked with a target_mem=1 (located in PSRAM) and on the other hand, the absolute address indication was set.",
#endif
    QM_INTR_CTRL_ISR_QM_TARGET_MEM_ABS_CONTRADICTION_FIELD_MASK,
    0,
    QM_INTR_CTRL_ISR_QM_TARGET_MEM_ABS_CONTRADICTION_FIELD_WIDTH,
    QM_INTR_CTRL_ISR_QM_TARGET_MEM_ABS_CONTRADICTION_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_INTR_CTRL_ISR_QM_1588_DROP
 ******************************************************************************/
const ru_field_rec QM_INTR_CTRL_ISR_QM_1588_DROP_FIELD =
{
    "QM_1588_DROP",
#if RU_INCLUDE_DESC
    "QM_1588_DROP",
    "1588 Packet is dropped when the QM PD occupancy exceeds threshold (64K)",
#endif
    QM_INTR_CTRL_ISR_QM_1588_DROP_FIELD_MASK,
    0,
    QM_INTR_CTRL_ISR_QM_1588_DROP_FIELD_WIDTH,
    QM_INTR_CTRL_ISR_QM_1588_DROP_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_INTR_CTRL_ISR_QM_1588_MULTICAST_CONTRADICTION
 ******************************************************************************/
const ru_field_rec QM_INTR_CTRL_ISR_QM_1588_MULTICAST_CONTRADICTION_FIELD =
{
    "QM_1588_MULTICAST_CONTRADICTION",
#if RU_INCLUDE_DESC
    "QM_1588_MULTICAST_CONTRADICTION",
    "A PD was marked as a 1588 and multicast together.",
#endif
    QM_INTR_CTRL_ISR_QM_1588_MULTICAST_CONTRADICTION_FIELD_MASK,
    0,
    QM_INTR_CTRL_ISR_QM_1588_MULTICAST_CONTRADICTION_FIELD_WIDTH,
    QM_INTR_CTRL_ISR_QM_1588_MULTICAST_CONTRADICTION_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_INTR_CTRL_ISR_QM_BYTE_DROP_CNT_OVERRUN
 ******************************************************************************/
const ru_field_rec QM_INTR_CTRL_ISR_QM_BYTE_DROP_CNT_OVERRUN_FIELD =
{
    "QM_BYTE_DROP_CNT_OVERRUN",
#if RU_INCLUDE_DESC
    "QM_BYTE_DROP_CNT_OVERRUN",
    "The byte drop counter of one of the queues reached its maximum value and a new value was pushed.",
#endif
    QM_INTR_CTRL_ISR_QM_BYTE_DROP_CNT_OVERRUN_FIELD_MASK,
    0,
    QM_INTR_CTRL_ISR_QM_BYTE_DROP_CNT_OVERRUN_FIELD_WIDTH,
    QM_INTR_CTRL_ISR_QM_BYTE_DROP_CNT_OVERRUN_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_INTR_CTRL_ISR_QM_PKT_DROP_CNT_OVERRUN
 ******************************************************************************/
const ru_field_rec QM_INTR_CTRL_ISR_QM_PKT_DROP_CNT_OVERRUN_FIELD =
{
    "QM_PKT_DROP_CNT_OVERRUN",
#if RU_INCLUDE_DESC
    "QM_PKT_DROP_CNT_OVERRUN",
    "The Packet drop counter of one of the queues reached its maximum value and a new value was pushed.",
#endif
    QM_INTR_CTRL_ISR_QM_PKT_DROP_CNT_OVERRUN_FIELD_MASK,
    0,
    QM_INTR_CTRL_ISR_QM_PKT_DROP_CNT_OVERRUN_FIELD_WIDTH,
    QM_INTR_CTRL_ISR_QM_PKT_DROP_CNT_OVERRUN_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_INTR_CTRL_ISR_QM_TOTAL_BYTE_CNT_UNDERRUN
 ******************************************************************************/
const ru_field_rec QM_INTR_CTRL_ISR_QM_TOTAL_BYTE_CNT_UNDERRUN_FIELD =
{
    "QM_TOTAL_BYTE_CNT_UNDERRUN",
#if RU_INCLUDE_DESC
    "QM_TOTAL_BYTE_CNT_UNDERRUN",
    "The Total byte counter was decremented to a negative value.",
#endif
    QM_INTR_CTRL_ISR_QM_TOTAL_BYTE_CNT_UNDERRUN_FIELD_MASK,
    0,
    QM_INTR_CTRL_ISR_QM_TOTAL_BYTE_CNT_UNDERRUN_FIELD_WIDTH,
    QM_INTR_CTRL_ISR_QM_TOTAL_BYTE_CNT_UNDERRUN_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_INTR_CTRL_ISR_QM_TOTAL_PKT_CNT_UNDERRUN
 ******************************************************************************/
const ru_field_rec QM_INTR_CTRL_ISR_QM_TOTAL_PKT_CNT_UNDERRUN_FIELD =
{
    "QM_TOTAL_PKT_CNT_UNDERRUN",
#if RU_INCLUDE_DESC
    "QM_TOTAL_PKT_CNT_UNDERRUN",
    "The Total PD counter was decremented to a negative value.",
#endif
    QM_INTR_CTRL_ISR_QM_TOTAL_PKT_CNT_UNDERRUN_FIELD_MASK,
    0,
    QM_INTR_CTRL_ISR_QM_TOTAL_PKT_CNT_UNDERRUN_FIELD_WIDTH,
    QM_INTR_CTRL_ISR_QM_TOTAL_PKT_CNT_UNDERRUN_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_INTR_CTRL_ISR_QM_FPM_UG0_UNDERRUN
 ******************************************************************************/
const ru_field_rec QM_INTR_CTRL_ISR_QM_FPM_UG0_UNDERRUN_FIELD =
{
    "QM_FPM_UG0_UNDERRUN",
#if RU_INCLUDE_DESC
    "QM_FPM_UG0_UNDERRUN",
    "The UG0 counter was decremented to a negative value.",
#endif
    QM_INTR_CTRL_ISR_QM_FPM_UG0_UNDERRUN_FIELD_MASK,
    0,
    QM_INTR_CTRL_ISR_QM_FPM_UG0_UNDERRUN_FIELD_WIDTH,
    QM_INTR_CTRL_ISR_QM_FPM_UG0_UNDERRUN_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_INTR_CTRL_ISR_QM_FPM_UG1_UNDERRUN
 ******************************************************************************/
const ru_field_rec QM_INTR_CTRL_ISR_QM_FPM_UG1_UNDERRUN_FIELD =
{
    "QM_FPM_UG1_UNDERRUN",
#if RU_INCLUDE_DESC
    "QM_FPM_UG1_UNDERRUN",
    "The UG1 counter was decremented to a negative value.",
#endif
    QM_INTR_CTRL_ISR_QM_FPM_UG1_UNDERRUN_FIELD_MASK,
    0,
    QM_INTR_CTRL_ISR_QM_FPM_UG1_UNDERRUN_FIELD_WIDTH,
    QM_INTR_CTRL_ISR_QM_FPM_UG1_UNDERRUN_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_INTR_CTRL_ISR_QM_FPM_UG2_UNDERRUN
 ******************************************************************************/
const ru_field_rec QM_INTR_CTRL_ISR_QM_FPM_UG2_UNDERRUN_FIELD =
{
    "QM_FPM_UG2_UNDERRUN",
#if RU_INCLUDE_DESC
    "QM_FPM_UG2_UNDERRUN",
    "The UG2 counter was decremented to a negative value.",
#endif
    QM_INTR_CTRL_ISR_QM_FPM_UG2_UNDERRUN_FIELD_MASK,
    0,
    QM_INTR_CTRL_ISR_QM_FPM_UG2_UNDERRUN_FIELD_WIDTH,
    QM_INTR_CTRL_ISR_QM_FPM_UG2_UNDERRUN_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_INTR_CTRL_ISR_QM_FPM_UG3_UNDERRUN
 ******************************************************************************/
const ru_field_rec QM_INTR_CTRL_ISR_QM_FPM_UG3_UNDERRUN_FIELD =
{
    "QM_FPM_UG3_UNDERRUN",
#if RU_INCLUDE_DESC
    "QM_FPM_UG3_UNDERRUN",
    "The UG3 counter was decremented to a negative value.",
#endif
    QM_INTR_CTRL_ISR_QM_FPM_UG3_UNDERRUN_FIELD_MASK,
    0,
    QM_INTR_CTRL_ISR_QM_FPM_UG3_UNDERRUN_FIELD_WIDTH,
    QM_INTR_CTRL_ISR_QM_FPM_UG3_UNDERRUN_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_INTR_CTRL_ISR_QM_TIMER_WRAPAROUND
 ******************************************************************************/
const ru_field_rec QM_INTR_CTRL_ISR_QM_TIMER_WRAPAROUND_FIELD =
{
    "QM_TIMER_WRAPAROUND",
#if RU_INCLUDE_DESC
    "QM_TIMER_WRAPAROUND",
    "QM aggregation timers wraps around. In this case it isnt guaranteed that the aggregation will be closed on pre-defined timeout expiration. However the aggregation should be closed eventually."
    "",
#endif
    QM_INTR_CTRL_ISR_QM_TIMER_WRAPAROUND_FIELD_MASK,
    0,
    QM_INTR_CTRL_ISR_QM_TIMER_WRAPAROUND_FIELD_WIDTH,
    QM_INTR_CTRL_ISR_QM_TIMER_WRAPAROUND_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_INTR_CTRL_ISR_QM_COPY_PLEN_ZERO
 ******************************************************************************/
const ru_field_rec QM_INTR_CTRL_ISR_QM_COPY_PLEN_ZERO_FIELD =
{
    "QM_COPY_PLEN_ZERO",
#if RU_INCLUDE_DESC
    "QM_COPY_PLEN_ZERO",
    "Packet with length = 0 is copied to DDR. FW/SW should take care that zero length packets arent copied to DDR."
    "",
#endif
    QM_INTR_CTRL_ISR_QM_COPY_PLEN_ZERO_FIELD_MASK,
    0,
    QM_INTR_CTRL_ISR_QM_COPY_PLEN_ZERO_FIELD_WIDTH,
    QM_INTR_CTRL_ISR_QM_COPY_PLEN_ZERO_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_INTR_CTRL_ISR_RESERVED0
 ******************************************************************************/
const ru_field_rec QM_INTR_CTRL_ISR_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    QM_INTR_CTRL_ISR_RESERVED0_FIELD_MASK,
    0,
    QM_INTR_CTRL_ISR_RESERVED0_FIELD_WIDTH,
    QM_INTR_CTRL_ISR_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_INTR_CTRL_ISM_ISM
 ******************************************************************************/
const ru_field_rec QM_INTR_CTRL_ISM_ISM_FIELD =
{
    "ISM",
#if RU_INCLUDE_DESC
    "Interrupt_status_masked",
    "Status Masked of corresponding interrupt source in the ISR",
#endif
    QM_INTR_CTRL_ISM_ISM_FIELD_MASK,
    0,
    QM_INTR_CTRL_ISM_ISM_FIELD_WIDTH,
    QM_INTR_CTRL_ISM_ISM_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_INTR_CTRL_ISM_RESERVED0
 ******************************************************************************/
const ru_field_rec QM_INTR_CTRL_ISM_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    QM_INTR_CTRL_ISM_RESERVED0_FIELD_MASK,
    0,
    QM_INTR_CTRL_ISM_RESERVED0_FIELD_WIDTH,
    QM_INTR_CTRL_ISM_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_INTR_CTRL_IER_IEM
 ******************************************************************************/
const ru_field_rec QM_INTR_CTRL_IER_IEM_FIELD =
{
    "IEM",
#if RU_INCLUDE_DESC
    "Interrupt_enable_mask",
    "Each bit in the mask controls the corresponding interrupt source in the IER",
#endif
    QM_INTR_CTRL_IER_IEM_FIELD_MASK,
    0,
    QM_INTR_CTRL_IER_IEM_FIELD_WIDTH,
    QM_INTR_CTRL_IER_IEM_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_INTR_CTRL_IER_RESERVED0
 ******************************************************************************/
const ru_field_rec QM_INTR_CTRL_IER_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    QM_INTR_CTRL_IER_RESERVED0_FIELD_MASK,
    0,
    QM_INTR_CTRL_IER_RESERVED0_FIELD_WIDTH,
    QM_INTR_CTRL_IER_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_INTR_CTRL_ITR_IST
 ******************************************************************************/
const ru_field_rec QM_INTR_CTRL_ITR_IST_FIELD =
{
    "IST",
#if RU_INCLUDE_DESC
    "Interrupt_simulation_test",
    "Each bit in the mask tests the corresponding interrupt source in the ISR",
#endif
    QM_INTR_CTRL_ITR_IST_FIELD_MASK,
    0,
    QM_INTR_CTRL_ITR_IST_FIELD_WIDTH,
    QM_INTR_CTRL_ITR_IST_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_INTR_CTRL_ITR_RESERVED0
 ******************************************************************************/
const ru_field_rec QM_INTR_CTRL_ITR_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    QM_INTR_CTRL_ITR_RESERVED0_FIELD_MASK,
    0,
    QM_INTR_CTRL_ITR_RESERVED0_FIELD_WIDTH,
    QM_INTR_CTRL_ITR_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_CLK_GATE_CLK_GATE_CNTRL_BYPASS_CLK_GATE
 ******************************************************************************/
const ru_field_rec QM_CLK_GATE_CLK_GATE_CNTRL_BYPASS_CLK_GATE_FIELD =
{
    "BYPASS_CLK_GATE",
#if RU_INCLUDE_DESC
    "BYPASS_CLOCK_GATE",
    "If set to 1b1 will disable the clock gate logic such to always enable the clock",
#endif
    QM_CLK_GATE_CLK_GATE_CNTRL_BYPASS_CLK_GATE_FIELD_MASK,
    0,
    QM_CLK_GATE_CLK_GATE_CNTRL_BYPASS_CLK_GATE_FIELD_WIDTH,
    QM_CLK_GATE_CLK_GATE_CNTRL_BYPASS_CLK_GATE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_CLK_GATE_CLK_GATE_CNTRL_RESERVED0
 ******************************************************************************/
const ru_field_rec QM_CLK_GATE_CLK_GATE_CNTRL_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    QM_CLK_GATE_CLK_GATE_CNTRL_RESERVED0_FIELD_MASK,
    0,
    QM_CLK_GATE_CLK_GATE_CNTRL_RESERVED0_FIELD_WIDTH,
    QM_CLK_GATE_CLK_GATE_CNTRL_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_CLK_GATE_CLK_GATE_CNTRL_TIMER_VAL
 ******************************************************************************/
const ru_field_rec QM_CLK_GATE_CLK_GATE_CNTRL_TIMER_VAL_FIELD =
{
    "TIMER_VAL",
#if RU_INCLUDE_DESC
    "TIMER_VALUE",
    "For how long should the clock stay active once all conditions for clock disable are met."
    ""
    "",
#endif
    QM_CLK_GATE_CLK_GATE_CNTRL_TIMER_VAL_FIELD_MASK,
    0,
    QM_CLK_GATE_CLK_GATE_CNTRL_TIMER_VAL_FIELD_WIDTH,
    QM_CLK_GATE_CLK_GATE_CNTRL_TIMER_VAL_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_CLK_GATE_CLK_GATE_CNTRL_KEEP_ALIVE_EN
 ******************************************************************************/
const ru_field_rec QM_CLK_GATE_CLK_GATE_CNTRL_KEEP_ALIVE_EN_FIELD =
{
    "KEEP_ALIVE_EN",
#if RU_INCLUDE_DESC
    "KEEP_ALIVE_ENABLE",
    "Enables the keep alive logic which will periodically enable the clock to assure that no deadlock of clock being removed completely will occur",
#endif
    QM_CLK_GATE_CLK_GATE_CNTRL_KEEP_ALIVE_EN_FIELD_MASK,
    0,
    QM_CLK_GATE_CLK_GATE_CNTRL_KEEP_ALIVE_EN_FIELD_WIDTH,
    QM_CLK_GATE_CLK_GATE_CNTRL_KEEP_ALIVE_EN_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_CLK_GATE_CLK_GATE_CNTRL_RESERVED1
 ******************************************************************************/
const ru_field_rec QM_CLK_GATE_CLK_GATE_CNTRL_RESERVED1_FIELD =
{
    "RESERVED1",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    QM_CLK_GATE_CLK_GATE_CNTRL_RESERVED1_FIELD_MASK,
    0,
    QM_CLK_GATE_CLK_GATE_CNTRL_RESERVED1_FIELD_WIDTH,
    QM_CLK_GATE_CLK_GATE_CNTRL_RESERVED1_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_CLK_GATE_CLK_GATE_CNTRL_KEEP_ALIVE_INTRVL
 ******************************************************************************/
const ru_field_rec QM_CLK_GATE_CLK_GATE_CNTRL_KEEP_ALIVE_INTRVL_FIELD =
{
    "KEEP_ALIVE_INTRVL",
#if RU_INCLUDE_DESC
    "KEEP_ALIVE_INTERVAL",
    "If the KEEP alive option is enabled the field will determine for how many cycles should the clock be active",
#endif
    QM_CLK_GATE_CLK_GATE_CNTRL_KEEP_ALIVE_INTRVL_FIELD_MASK,
    0,
    QM_CLK_GATE_CLK_GATE_CNTRL_KEEP_ALIVE_INTRVL_FIELD_WIDTH,
    QM_CLK_GATE_CLK_GATE_CNTRL_KEEP_ALIVE_INTRVL_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_CLK_GATE_CLK_GATE_CNTRL_RESERVED2
 ******************************************************************************/
const ru_field_rec QM_CLK_GATE_CLK_GATE_CNTRL_RESERVED2_FIELD =
{
    "RESERVED2",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    QM_CLK_GATE_CLK_GATE_CNTRL_RESERVED2_FIELD_MASK,
    0,
    QM_CLK_GATE_CLK_GATE_CNTRL_RESERVED2_FIELD_WIDTH,
    QM_CLK_GATE_CLK_GATE_CNTRL_RESERVED2_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_CLK_GATE_CLK_GATE_CNTRL_KEEP_ALIVE_CYC
 ******************************************************************************/
const ru_field_rec QM_CLK_GATE_CLK_GATE_CNTRL_KEEP_ALIVE_CYC_FIELD =
{
    "KEEP_ALIVE_CYC",
#if RU_INCLUDE_DESC
    "KEEP_ALIVE_CYCLE",
    "If the KEEP alive option is enabled this field will determine for how many cycles should the clock be disabled (minus the KEEP_ALIVE_INTERVAL)"
    ""
    "So KEEP_ALIVE_CYCLE must be larger than KEEP_ALIVE_INTERVAL.",
#endif
    QM_CLK_GATE_CLK_GATE_CNTRL_KEEP_ALIVE_CYC_FIELD_MASK,
    0,
    QM_CLK_GATE_CLK_GATE_CNTRL_KEEP_ALIVE_CYC_FIELD_WIDTH,
    QM_CLK_GATE_CLK_GATE_CNTRL_KEEP_ALIVE_CYC_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_CPU_INDR_PORT_CPU_PD_INDIRECT_CTRL_QUEUE_NUM
 ******************************************************************************/
const ru_field_rec QM_CPU_INDR_PORT_CPU_PD_INDIRECT_CTRL_QUEUE_NUM_FIELD =
{
    "QUEUE_NUM",
#if RU_INCLUDE_DESC
    "QUEUE_NUM",
    "Queue Number",
#endif
    QM_CPU_INDR_PORT_CPU_PD_INDIRECT_CTRL_QUEUE_NUM_FIELD_MASK,
    0,
    QM_CPU_INDR_PORT_CPU_PD_INDIRECT_CTRL_QUEUE_NUM_FIELD_WIDTH,
    QM_CPU_INDR_PORT_CPU_PD_INDIRECT_CTRL_QUEUE_NUM_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_CPU_INDR_PORT_CPU_PD_INDIRECT_CTRL_RESERVED0
 ******************************************************************************/
const ru_field_rec QM_CPU_INDR_PORT_CPU_PD_INDIRECT_CTRL_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    QM_CPU_INDR_PORT_CPU_PD_INDIRECT_CTRL_RESERVED0_FIELD_MASK,
    0,
    QM_CPU_INDR_PORT_CPU_PD_INDIRECT_CTRL_RESERVED0_FIELD_WIDTH,
    QM_CPU_INDR_PORT_CPU_PD_INDIRECT_CTRL_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_CPU_INDR_PORT_CPU_PD_INDIRECT_CTRL_CMD
 ******************************************************************************/
const ru_field_rec QM_CPU_INDR_PORT_CPU_PD_INDIRECT_CTRL_CMD_FIELD =
{
    "CMD",
#if RU_INCLUDE_DESC
    "CMD",
    "Command:"
    "00 - Nothing"
    "01 - Write"
    "10 - Read"
    "11 - Read No commit (entry not popped)"
    ""
    "Will trigger a read/write from the selected RAM"
    ""
    "IMPORTANT: Read is for debug purpose only. shouldnt be used during regular QM work on the requested queue (HW pop)."
    "Popping the same queue both from CPU and HW could cause to race condition which will cause to incorrect data output. It could occur when there is only one entry in the queue which is accessed both from the CPU and the HW.",
#endif
    QM_CPU_INDR_PORT_CPU_PD_INDIRECT_CTRL_CMD_FIELD_MASK,
    0,
    QM_CPU_INDR_PORT_CPU_PD_INDIRECT_CTRL_CMD_FIELD_WIDTH,
    QM_CPU_INDR_PORT_CPU_PD_INDIRECT_CTRL_CMD_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_CPU_INDR_PORT_CPU_PD_INDIRECT_CTRL_RESERVED1
 ******************************************************************************/
const ru_field_rec QM_CPU_INDR_PORT_CPU_PD_INDIRECT_CTRL_RESERVED1_FIELD =
{
    "RESERVED1",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    QM_CPU_INDR_PORT_CPU_PD_INDIRECT_CTRL_RESERVED1_FIELD_MASK,
    0,
    QM_CPU_INDR_PORT_CPU_PD_INDIRECT_CTRL_RESERVED1_FIELD_WIDTH,
    QM_CPU_INDR_PORT_CPU_PD_INDIRECT_CTRL_RESERVED1_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_CPU_INDR_PORT_CPU_PD_INDIRECT_CTRL_DONE
 ******************************************************************************/
const ru_field_rec QM_CPU_INDR_PORT_CPU_PD_INDIRECT_CTRL_DONE_FIELD =
{
    "DONE",
#if RU_INCLUDE_DESC
    "DONE",
    "Indicates that read/write to DQM is done",
#endif
    QM_CPU_INDR_PORT_CPU_PD_INDIRECT_CTRL_DONE_FIELD_MASK,
    0,
    QM_CPU_INDR_PORT_CPU_PD_INDIRECT_CTRL_DONE_FIELD_WIDTH,
    QM_CPU_INDR_PORT_CPU_PD_INDIRECT_CTRL_DONE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_CPU_INDR_PORT_CPU_PD_INDIRECT_CTRL_ERROR
 ******************************************************************************/
const ru_field_rec QM_CPU_INDR_PORT_CPU_PD_INDIRECT_CTRL_ERROR_FIELD =
{
    "ERROR",
#if RU_INCLUDE_DESC
    "ERROR",
    "Indicates that that an error occured (write on full or read on empty)",
#endif
    QM_CPU_INDR_PORT_CPU_PD_INDIRECT_CTRL_ERROR_FIELD_MASK,
    0,
    QM_CPU_INDR_PORT_CPU_PD_INDIRECT_CTRL_ERROR_FIELD_WIDTH,
    QM_CPU_INDR_PORT_CPU_PD_INDIRECT_CTRL_ERROR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_CPU_INDR_PORT_CPU_PD_INDIRECT_CTRL_RESERVED2
 ******************************************************************************/
const ru_field_rec QM_CPU_INDR_PORT_CPU_PD_INDIRECT_CTRL_RESERVED2_FIELD =
{
    "RESERVED2",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    QM_CPU_INDR_PORT_CPU_PD_INDIRECT_CTRL_RESERVED2_FIELD_MASK,
    0,
    QM_CPU_INDR_PORT_CPU_PD_INDIRECT_CTRL_RESERVED2_FIELD_WIDTH,
    QM_CPU_INDR_PORT_CPU_PD_INDIRECT_CTRL_RESERVED2_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_CPU_INDR_PORT_CPU_PD_INDIRECT_WR_DATA_0_DATA
 ******************************************************************************/
const ru_field_rec QM_CPU_INDR_PORT_CPU_PD_INDIRECT_WR_DATA_0_DATA_FIELD =
{
    "DATA",
#if RU_INCLUDE_DESC
    "DATA",
    "Data",
#endif
    QM_CPU_INDR_PORT_CPU_PD_INDIRECT_WR_DATA_0_DATA_FIELD_MASK,
    0,
    QM_CPU_INDR_PORT_CPU_PD_INDIRECT_WR_DATA_0_DATA_FIELD_WIDTH,
    QM_CPU_INDR_PORT_CPU_PD_INDIRECT_WR_DATA_0_DATA_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_CPU_INDR_PORT_CPU_PD_INDIRECT_WR_DATA_1_DATA
 ******************************************************************************/
const ru_field_rec QM_CPU_INDR_PORT_CPU_PD_INDIRECT_WR_DATA_1_DATA_FIELD =
{
    "DATA",
#if RU_INCLUDE_DESC
    "DATA",
    "Data",
#endif
    QM_CPU_INDR_PORT_CPU_PD_INDIRECT_WR_DATA_1_DATA_FIELD_MASK,
    0,
    QM_CPU_INDR_PORT_CPU_PD_INDIRECT_WR_DATA_1_DATA_FIELD_WIDTH,
    QM_CPU_INDR_PORT_CPU_PD_INDIRECT_WR_DATA_1_DATA_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_CPU_INDR_PORT_CPU_PD_INDIRECT_WR_DATA_2_DATA
 ******************************************************************************/
const ru_field_rec QM_CPU_INDR_PORT_CPU_PD_INDIRECT_WR_DATA_2_DATA_FIELD =
{
    "DATA",
#if RU_INCLUDE_DESC
    "DATA",
    "Data",
#endif
    QM_CPU_INDR_PORT_CPU_PD_INDIRECT_WR_DATA_2_DATA_FIELD_MASK,
    0,
    QM_CPU_INDR_PORT_CPU_PD_INDIRECT_WR_DATA_2_DATA_FIELD_WIDTH,
    QM_CPU_INDR_PORT_CPU_PD_INDIRECT_WR_DATA_2_DATA_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_CPU_INDR_PORT_CPU_PD_INDIRECT_WR_DATA_3_DATA
 ******************************************************************************/
const ru_field_rec QM_CPU_INDR_PORT_CPU_PD_INDIRECT_WR_DATA_3_DATA_FIELD =
{
    "DATA",
#if RU_INCLUDE_DESC
    "DATA",
    "Data",
#endif
    QM_CPU_INDR_PORT_CPU_PD_INDIRECT_WR_DATA_3_DATA_FIELD_MASK,
    0,
    QM_CPU_INDR_PORT_CPU_PD_INDIRECT_WR_DATA_3_DATA_FIELD_WIDTH,
    QM_CPU_INDR_PORT_CPU_PD_INDIRECT_WR_DATA_3_DATA_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_CPU_INDR_PORT_CPU_PD_INDIRECT_RD_DATA_0_DATA
 ******************************************************************************/
const ru_field_rec QM_CPU_INDR_PORT_CPU_PD_INDIRECT_RD_DATA_0_DATA_FIELD =
{
    "DATA",
#if RU_INCLUDE_DESC
    "DATA",
    "Data",
#endif
    QM_CPU_INDR_PORT_CPU_PD_INDIRECT_RD_DATA_0_DATA_FIELD_MASK,
    0,
    QM_CPU_INDR_PORT_CPU_PD_INDIRECT_RD_DATA_0_DATA_FIELD_WIDTH,
    QM_CPU_INDR_PORT_CPU_PD_INDIRECT_RD_DATA_0_DATA_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_CPU_INDR_PORT_CPU_PD_INDIRECT_RD_DATA_1_DATA
 ******************************************************************************/
const ru_field_rec QM_CPU_INDR_PORT_CPU_PD_INDIRECT_RD_DATA_1_DATA_FIELD =
{
    "DATA",
#if RU_INCLUDE_DESC
    "DATA",
    "Data",
#endif
    QM_CPU_INDR_PORT_CPU_PD_INDIRECT_RD_DATA_1_DATA_FIELD_MASK,
    0,
    QM_CPU_INDR_PORT_CPU_PD_INDIRECT_RD_DATA_1_DATA_FIELD_WIDTH,
    QM_CPU_INDR_PORT_CPU_PD_INDIRECT_RD_DATA_1_DATA_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_CPU_INDR_PORT_CPU_PD_INDIRECT_RD_DATA_2_DATA
 ******************************************************************************/
const ru_field_rec QM_CPU_INDR_PORT_CPU_PD_INDIRECT_RD_DATA_2_DATA_FIELD =
{
    "DATA",
#if RU_INCLUDE_DESC
    "DATA",
    "Data",
#endif
    QM_CPU_INDR_PORT_CPU_PD_INDIRECT_RD_DATA_2_DATA_FIELD_MASK,
    0,
    QM_CPU_INDR_PORT_CPU_PD_INDIRECT_RD_DATA_2_DATA_FIELD_WIDTH,
    QM_CPU_INDR_PORT_CPU_PD_INDIRECT_RD_DATA_2_DATA_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_CPU_INDR_PORT_CPU_PD_INDIRECT_RD_DATA_3_DATA
 ******************************************************************************/
const ru_field_rec QM_CPU_INDR_PORT_CPU_PD_INDIRECT_RD_DATA_3_DATA_FIELD =
{
    "DATA",
#if RU_INCLUDE_DESC
    "DATA",
    "Data",
#endif
    QM_CPU_INDR_PORT_CPU_PD_INDIRECT_RD_DATA_3_DATA_FIELD_MASK,
    0,
    QM_CPU_INDR_PORT_CPU_PD_INDIRECT_RD_DATA_3_DATA_FIELD_WIDTH,
    QM_CPU_INDR_PORT_CPU_PD_INDIRECT_RD_DATA_3_DATA_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_QUEUE_CONTEXT_CONTEXT_WRED_PROFILE
 ******************************************************************************/
const ru_field_rec QM_QUEUE_CONTEXT_CONTEXT_WRED_PROFILE_FIELD =
{
    "WRED_PROFILE",
#if RU_INCLUDE_DESC
    "WRED_PROFILE",
    "Defines to which WRED Profile this queue belongs to.",
#endif
    QM_QUEUE_CONTEXT_CONTEXT_WRED_PROFILE_FIELD_MASK,
    0,
    QM_QUEUE_CONTEXT_CONTEXT_WRED_PROFILE_FIELD_WIDTH,
    QM_QUEUE_CONTEXT_CONTEXT_WRED_PROFILE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_QUEUE_CONTEXT_CONTEXT_COPY_DEC_PROFILE
 ******************************************************************************/
const ru_field_rec QM_QUEUE_CONTEXT_CONTEXT_COPY_DEC_PROFILE_FIELD =
{
    "COPY_DEC_PROFILE",
#if RU_INCLUDE_DESC
    "COPY_DEC_PROFILE",
    "Defines to which Copy Decision Profile this queue belongs to.",
#endif
    QM_QUEUE_CONTEXT_CONTEXT_COPY_DEC_PROFILE_FIELD_MASK,
    0,
    QM_QUEUE_CONTEXT_CONTEXT_COPY_DEC_PROFILE_FIELD_WIDTH,
    QM_QUEUE_CONTEXT_CONTEXT_COPY_DEC_PROFILE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_QUEUE_CONTEXT_CONTEXT_COPY_TO_DDR
 ******************************************************************************/
const ru_field_rec QM_QUEUE_CONTEXT_CONTEXT_COPY_TO_DDR_FIELD =
{
    "COPY_TO_DDR",
#if RU_INCLUDE_DESC
    "COPY_TO_DDR",
    "Defines this queue to always copy to DDR.",
#endif
    QM_QUEUE_CONTEXT_CONTEXT_COPY_TO_DDR_FIELD_MASK,
    0,
    QM_QUEUE_CONTEXT_CONTEXT_COPY_TO_DDR_FIELD_WIDTH,
    QM_QUEUE_CONTEXT_CONTEXT_COPY_TO_DDR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_QUEUE_CONTEXT_CONTEXT_DDR_COPY_DISABLE
 ******************************************************************************/
const ru_field_rec QM_QUEUE_CONTEXT_CONTEXT_DDR_COPY_DISABLE_FIELD =
{
    "DDR_COPY_DISABLE",
#if RU_INCLUDE_DESC
    "DDR_COPY_DISABLE",
    "Defines this queue never to copy to DDR.",
#endif
    QM_QUEUE_CONTEXT_CONTEXT_DDR_COPY_DISABLE_FIELD_MASK,
    0,
    QM_QUEUE_CONTEXT_CONTEXT_DDR_COPY_DISABLE_FIELD_WIDTH,
    QM_QUEUE_CONTEXT_CONTEXT_DDR_COPY_DISABLE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_QUEUE_CONTEXT_CONTEXT_AGGREGATION_DISABLE
 ******************************************************************************/
const ru_field_rec QM_QUEUE_CONTEXT_CONTEXT_AGGREGATION_DISABLE_FIELD =
{
    "AGGREGATION_DISABLE",
#if RU_INCLUDE_DESC
    "AGGREGATION_DISABLE",
    "Defines this queue never to aggregated PDs.",
#endif
    QM_QUEUE_CONTEXT_CONTEXT_AGGREGATION_DISABLE_FIELD_MASK,
    0,
    QM_QUEUE_CONTEXT_CONTEXT_AGGREGATION_DISABLE_FIELD_WIDTH,
    QM_QUEUE_CONTEXT_CONTEXT_AGGREGATION_DISABLE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_QUEUE_CONTEXT_CONTEXT_FPM_UG
 ******************************************************************************/
const ru_field_rec QM_QUEUE_CONTEXT_CONTEXT_FPM_UG_FIELD =
{
    "FPM_UG",
#if RU_INCLUDE_DESC
    "FPM_UG",
    "Defines to which FPM UG this queue belongs to.",
#endif
    QM_QUEUE_CONTEXT_CONTEXT_FPM_UG_FIELD_MASK,
    0,
    QM_QUEUE_CONTEXT_CONTEXT_FPM_UG_FIELD_WIDTH,
    QM_QUEUE_CONTEXT_CONTEXT_FPM_UG_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_QUEUE_CONTEXT_CONTEXT_EXCLUSIVE_PRIORITY
 ******************************************************************************/
const ru_field_rec QM_QUEUE_CONTEXT_CONTEXT_EXCLUSIVE_PRIORITY_FIELD =
{
    "EXCLUSIVE_PRIORITY",
#if RU_INCLUDE_DESC
    "EXCLUSIVE_PRIORITY",
    "Defines this queue with exclusive priority.",
#endif
    QM_QUEUE_CONTEXT_CONTEXT_EXCLUSIVE_PRIORITY_FIELD_MASK,
    0,
    QM_QUEUE_CONTEXT_CONTEXT_EXCLUSIVE_PRIORITY_FIELD_WIDTH,
    QM_QUEUE_CONTEXT_CONTEXT_EXCLUSIVE_PRIORITY_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_QUEUE_CONTEXT_CONTEXT_Q_802_1AE
 ******************************************************************************/
const ru_field_rec QM_QUEUE_CONTEXT_CONTEXT_Q_802_1AE_FIELD =
{
    "Q_802_1AE",
#if RU_INCLUDE_DESC
    "Q_802_1AE",
    "Defines this queue as 802.1AE for EPON packet overhead calculations.",
#endif
    QM_QUEUE_CONTEXT_CONTEXT_Q_802_1AE_FIELD_MASK,
    0,
    QM_QUEUE_CONTEXT_CONTEXT_Q_802_1AE_FIELD_WIDTH,
    QM_QUEUE_CONTEXT_CONTEXT_Q_802_1AE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_QUEUE_CONTEXT_CONTEXT_SCI
 ******************************************************************************/
const ru_field_rec QM_QUEUE_CONTEXT_CONTEXT_SCI_FIELD =
{
    "SCI",
#if RU_INCLUDE_DESC
    "SCI",
    "Configures SCI for EPON packet overhead calculations.",
#endif
    QM_QUEUE_CONTEXT_CONTEXT_SCI_FIELD_MASK,
    0,
    QM_QUEUE_CONTEXT_CONTEXT_SCI_FIELD_WIDTH,
    QM_QUEUE_CONTEXT_CONTEXT_SCI_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_QUEUE_CONTEXT_CONTEXT_FEC_ENABLE
 ******************************************************************************/
const ru_field_rec QM_QUEUE_CONTEXT_CONTEXT_FEC_ENABLE_FIELD =
{
    "FEC_ENABLE",
#if RU_INCLUDE_DESC
    "FEC_ENABLE",
    "FEC enable configuration for EPON packet overhead calculations.",
#endif
    QM_QUEUE_CONTEXT_CONTEXT_FEC_ENABLE_FIELD_MASK,
    0,
    QM_QUEUE_CONTEXT_CONTEXT_FEC_ENABLE_FIELD_WIDTH,
    QM_QUEUE_CONTEXT_CONTEXT_FEC_ENABLE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_QUEUE_CONTEXT_CONTEXT_RES_PROFILE
 ******************************************************************************/
const ru_field_rec QM_QUEUE_CONTEXT_CONTEXT_RES_PROFILE_FIELD =
{
    "RES_PROFILE",
#if RU_INCLUDE_DESC
    "RES_PROFILE",
    "FPM reservation profile."
    "Once the QM goes over global FPM reservation threshold."
    "Queue with more bytes the defined in the profile will be dropped."
    "Profile 0 means no drop due to FPM reservation for the queues with this profile.",
#endif
    QM_QUEUE_CONTEXT_CONTEXT_RES_PROFILE_FIELD_MASK,
    0,
    QM_QUEUE_CONTEXT_CONTEXT_RES_PROFILE_FIELD_WIDTH,
    QM_QUEUE_CONTEXT_CONTEXT_RES_PROFILE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_QUEUE_CONTEXT_CONTEXT_SPARE_ROOM_0
 ******************************************************************************/
const ru_field_rec QM_QUEUE_CONTEXT_CONTEXT_SPARE_ROOM_0_FIELD =
{
    "SPARE_ROOM_0",
#if RU_INCLUDE_DESC
    "SPARE_ROOM_0",
    "Select 1 out of 4 headroom and tailroom pairs. if PDs SOP select is set to 0. This profile is chosen",
#endif
    QM_QUEUE_CONTEXT_CONTEXT_SPARE_ROOM_0_FIELD_MASK,
    0,
    QM_QUEUE_CONTEXT_CONTEXT_SPARE_ROOM_0_FIELD_WIDTH,
    QM_QUEUE_CONTEXT_CONTEXT_SPARE_ROOM_0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_QUEUE_CONTEXT_CONTEXT_SPARE_ROOM_1
 ******************************************************************************/
const ru_field_rec QM_QUEUE_CONTEXT_CONTEXT_SPARE_ROOM_1_FIELD =
{
    "SPARE_ROOM_1",
#if RU_INCLUDE_DESC
    "SPARE_ROOM_1",
    "Select 1 out of 4 headroom and tailroom pairs. if PDs SOP select is set to 1. This profile is chosen",
#endif
    QM_QUEUE_CONTEXT_CONTEXT_SPARE_ROOM_1_FIELD_MASK,
    0,
    QM_QUEUE_CONTEXT_CONTEXT_SPARE_ROOM_1_FIELD_WIDTH,
    QM_QUEUE_CONTEXT_CONTEXT_SPARE_ROOM_1_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_QUEUE_CONTEXT_CONTEXT_RESERVED0
 ******************************************************************************/
const ru_field_rec QM_QUEUE_CONTEXT_CONTEXT_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    QM_QUEUE_CONTEXT_CONTEXT_RESERVED0_FIELD_MASK,
    0,
    QM_QUEUE_CONTEXT_CONTEXT_RESERVED0_FIELD_WIDTH,
    QM_QUEUE_CONTEXT_CONTEXT_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_WRED_PROFILE_COLOR_MIN_THR_0_MIN_THR
 ******************************************************************************/
const ru_field_rec QM_WRED_PROFILE_COLOR_MIN_THR_0_MIN_THR_FIELD =
{
    "MIN_THR",
#if RU_INCLUDE_DESC
    "MIN_THR",
    "WRED Color Min Threshold."
    "This field represents the higher 24-bits of the queue occupancy byte threshold."
    "byte_threshold = THR*64.",
#endif
    QM_WRED_PROFILE_COLOR_MIN_THR_0_MIN_THR_FIELD_MASK,
    0,
    QM_WRED_PROFILE_COLOR_MIN_THR_0_MIN_THR_FIELD_WIDTH,
    QM_WRED_PROFILE_COLOR_MIN_THR_0_MIN_THR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_WRED_PROFILE_COLOR_MIN_THR_0_FLW_CTRL_EN
 ******************************************************************************/
const ru_field_rec QM_WRED_PROFILE_COLOR_MIN_THR_0_FLW_CTRL_EN_FIELD =
{
    "FLW_CTRL_EN",
#if RU_INCLUDE_DESC
    "FLW_CTRL_EN",
    "0 - flow control disable. regular WRED profile"
    "1 - flow control enable. no WRED drop, wake up appropriate runner task when crossed.",
#endif
    QM_WRED_PROFILE_COLOR_MIN_THR_0_FLW_CTRL_EN_FIELD_MASK,
    0,
    QM_WRED_PROFILE_COLOR_MIN_THR_0_FLW_CTRL_EN_FIELD_WIDTH,
    QM_WRED_PROFILE_COLOR_MIN_THR_0_FLW_CTRL_EN_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_WRED_PROFILE_COLOR_MIN_THR_0_RESERVED0
 ******************************************************************************/
const ru_field_rec QM_WRED_PROFILE_COLOR_MIN_THR_0_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    QM_WRED_PROFILE_COLOR_MIN_THR_0_RESERVED0_FIELD_MASK,
    0,
    QM_WRED_PROFILE_COLOR_MIN_THR_0_RESERVED0_FIELD_WIDTH,
    QM_WRED_PROFILE_COLOR_MIN_THR_0_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_WRED_PROFILE_COLOR_MIN_THR_1_MIN_THR
 ******************************************************************************/
const ru_field_rec QM_WRED_PROFILE_COLOR_MIN_THR_1_MIN_THR_FIELD =
{
    "MIN_THR",
#if RU_INCLUDE_DESC
    "MIN_THR",
    "WRED Color Min Threshold."
    "This field represents the higher 24-bits of the queue occupancy byte threshold."
    "byte_threshold = THR*64.",
#endif
    QM_WRED_PROFILE_COLOR_MIN_THR_1_MIN_THR_FIELD_MASK,
    0,
    QM_WRED_PROFILE_COLOR_MIN_THR_1_MIN_THR_FIELD_WIDTH,
    QM_WRED_PROFILE_COLOR_MIN_THR_1_MIN_THR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_WRED_PROFILE_COLOR_MIN_THR_1_FLW_CTRL_EN
 ******************************************************************************/
const ru_field_rec QM_WRED_PROFILE_COLOR_MIN_THR_1_FLW_CTRL_EN_FIELD =
{
    "FLW_CTRL_EN",
#if RU_INCLUDE_DESC
    "FLW_CTRL_EN",
    "0 - flow control disable. regular WRED profile"
    "1 - flow control enable. no WRED drop, wake up appropriate runner task when crossed.",
#endif
    QM_WRED_PROFILE_COLOR_MIN_THR_1_FLW_CTRL_EN_FIELD_MASK,
    0,
    QM_WRED_PROFILE_COLOR_MIN_THR_1_FLW_CTRL_EN_FIELD_WIDTH,
    QM_WRED_PROFILE_COLOR_MIN_THR_1_FLW_CTRL_EN_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_WRED_PROFILE_COLOR_MIN_THR_1_RESERVED0
 ******************************************************************************/
const ru_field_rec QM_WRED_PROFILE_COLOR_MIN_THR_1_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    QM_WRED_PROFILE_COLOR_MIN_THR_1_RESERVED0_FIELD_MASK,
    0,
    QM_WRED_PROFILE_COLOR_MIN_THR_1_RESERVED0_FIELD_WIDTH,
    QM_WRED_PROFILE_COLOR_MIN_THR_1_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_WRED_PROFILE_COLOR_MAX_THR_0_MAX_THR
 ******************************************************************************/
const ru_field_rec QM_WRED_PROFILE_COLOR_MAX_THR_0_MAX_THR_FIELD =
{
    "MAX_THR",
#if RU_INCLUDE_DESC
    "MAX_THR",
    "WRED Color Max Threshold."
    "This field represents the higher 24-bits of the queue occupancy byte threshold."
    "byte_threshold = THR*64.",
#endif
    QM_WRED_PROFILE_COLOR_MAX_THR_0_MAX_THR_FIELD_MASK,
    0,
    QM_WRED_PROFILE_COLOR_MAX_THR_0_MAX_THR_FIELD_WIDTH,
    QM_WRED_PROFILE_COLOR_MAX_THR_0_MAX_THR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_WRED_PROFILE_COLOR_MAX_THR_0_RESERVED0
 ******************************************************************************/
const ru_field_rec QM_WRED_PROFILE_COLOR_MAX_THR_0_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    QM_WRED_PROFILE_COLOR_MAX_THR_0_RESERVED0_FIELD_MASK,
    0,
    QM_WRED_PROFILE_COLOR_MAX_THR_0_RESERVED0_FIELD_WIDTH,
    QM_WRED_PROFILE_COLOR_MAX_THR_0_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_WRED_PROFILE_COLOR_MAX_THR_1_MAX_THR
 ******************************************************************************/
const ru_field_rec QM_WRED_PROFILE_COLOR_MAX_THR_1_MAX_THR_FIELD =
{
    "MAX_THR",
#if RU_INCLUDE_DESC
    "MAX_THR",
    "WRED Color Max Threshold."
    "This field represents the higher 24-bits of the queue occupancy byte threshold."
    "byte_threshold = THR*64.",
#endif
    QM_WRED_PROFILE_COLOR_MAX_THR_1_MAX_THR_FIELD_MASK,
    0,
    QM_WRED_PROFILE_COLOR_MAX_THR_1_MAX_THR_FIELD_WIDTH,
    QM_WRED_PROFILE_COLOR_MAX_THR_1_MAX_THR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_WRED_PROFILE_COLOR_MAX_THR_1_RESERVED0
 ******************************************************************************/
const ru_field_rec QM_WRED_PROFILE_COLOR_MAX_THR_1_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    QM_WRED_PROFILE_COLOR_MAX_THR_1_RESERVED0_FIELD_MASK,
    0,
    QM_WRED_PROFILE_COLOR_MAX_THR_1_RESERVED0_FIELD_WIDTH,
    QM_WRED_PROFILE_COLOR_MAX_THR_1_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_WRED_PROFILE_COLOR_SLOPE_0_SLOPE_MANTISSA
 ******************************************************************************/
const ru_field_rec QM_WRED_PROFILE_COLOR_SLOPE_0_SLOPE_MANTISSA_FIELD =
{
    "SLOPE_MANTISSA",
#if RU_INCLUDE_DESC
    "SLOPE_MANTISSA",
    "WRED Color slope mantissa.",
#endif
    QM_WRED_PROFILE_COLOR_SLOPE_0_SLOPE_MANTISSA_FIELD_MASK,
    0,
    QM_WRED_PROFILE_COLOR_SLOPE_0_SLOPE_MANTISSA_FIELD_WIDTH,
    QM_WRED_PROFILE_COLOR_SLOPE_0_SLOPE_MANTISSA_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_WRED_PROFILE_COLOR_SLOPE_0_SLOPE_EXP
 ******************************************************************************/
const ru_field_rec QM_WRED_PROFILE_COLOR_SLOPE_0_SLOPE_EXP_FIELD =
{
    "SLOPE_EXP",
#if RU_INCLUDE_DESC
    "SLOPE_EXP",
    "WRED Color slope exponent.",
#endif
    QM_WRED_PROFILE_COLOR_SLOPE_0_SLOPE_EXP_FIELD_MASK,
    0,
    QM_WRED_PROFILE_COLOR_SLOPE_0_SLOPE_EXP_FIELD_WIDTH,
    QM_WRED_PROFILE_COLOR_SLOPE_0_SLOPE_EXP_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_WRED_PROFILE_COLOR_SLOPE_0_RESERVED0
 ******************************************************************************/
const ru_field_rec QM_WRED_PROFILE_COLOR_SLOPE_0_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    QM_WRED_PROFILE_COLOR_SLOPE_0_RESERVED0_FIELD_MASK,
    0,
    QM_WRED_PROFILE_COLOR_SLOPE_0_RESERVED0_FIELD_WIDTH,
    QM_WRED_PROFILE_COLOR_SLOPE_0_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_WRED_PROFILE_COLOR_SLOPE_1_SLOPE_MANTISSA
 ******************************************************************************/
const ru_field_rec QM_WRED_PROFILE_COLOR_SLOPE_1_SLOPE_MANTISSA_FIELD =
{
    "SLOPE_MANTISSA",
#if RU_INCLUDE_DESC
    "SLOPE_MANTISSA",
    "WRED Color slope mantissa.",
#endif
    QM_WRED_PROFILE_COLOR_SLOPE_1_SLOPE_MANTISSA_FIELD_MASK,
    0,
    QM_WRED_PROFILE_COLOR_SLOPE_1_SLOPE_MANTISSA_FIELD_WIDTH,
    QM_WRED_PROFILE_COLOR_SLOPE_1_SLOPE_MANTISSA_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_WRED_PROFILE_COLOR_SLOPE_1_SLOPE_EXP
 ******************************************************************************/
const ru_field_rec QM_WRED_PROFILE_COLOR_SLOPE_1_SLOPE_EXP_FIELD =
{
    "SLOPE_EXP",
#if RU_INCLUDE_DESC
    "SLOPE_EXP",
    "WRED Color slope exponent.",
#endif
    QM_WRED_PROFILE_COLOR_SLOPE_1_SLOPE_EXP_FIELD_MASK,
    0,
    QM_WRED_PROFILE_COLOR_SLOPE_1_SLOPE_EXP_FIELD_WIDTH,
    QM_WRED_PROFILE_COLOR_SLOPE_1_SLOPE_EXP_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_WRED_PROFILE_COLOR_SLOPE_1_RESERVED0
 ******************************************************************************/
const ru_field_rec QM_WRED_PROFILE_COLOR_SLOPE_1_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    QM_WRED_PROFILE_COLOR_SLOPE_1_RESERVED0_FIELD_MASK,
    0,
    QM_WRED_PROFILE_COLOR_SLOPE_1_RESERVED0_FIELD_WIDTH,
    QM_WRED_PROFILE_COLOR_SLOPE_1_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_COPY_DECISION_PROFILE_THR_QUEUE_OCCUPANCY_THR
 ******************************************************************************/
const ru_field_rec QM_COPY_DECISION_PROFILE_THR_QUEUE_OCCUPANCY_THR_FIELD =
{
    "QUEUE_OCCUPANCY_THR",
#if RU_INCLUDE_DESC
    "QUEUE_OCCUPANCY_THR",
    "Queue Occupancy Threshold."
    "When passing this threhold, packets will be copied to the DDR",
#endif
    QM_COPY_DECISION_PROFILE_THR_QUEUE_OCCUPANCY_THR_FIELD_MASK,
    0,
    QM_COPY_DECISION_PROFILE_THR_QUEUE_OCCUPANCY_THR_FIELD_WIDTH,
    QM_COPY_DECISION_PROFILE_THR_QUEUE_OCCUPANCY_THR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_COPY_DECISION_PROFILE_THR_RESERVED0
 ******************************************************************************/
const ru_field_rec QM_COPY_DECISION_PROFILE_THR_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    QM_COPY_DECISION_PROFILE_THR_RESERVED0_FIELD_MASK,
    0,
    QM_COPY_DECISION_PROFILE_THR_RESERVED0_FIELD_WIDTH,
    QM_COPY_DECISION_PROFILE_THR_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_COPY_DECISION_PROFILE_THR_PSRAM_THR
 ******************************************************************************/
const ru_field_rec QM_COPY_DECISION_PROFILE_THR_PSRAM_THR_FIELD =
{
    "PSRAM_THR",
#if RU_INCLUDE_DESC
    "PSRAM_THR",
    "Indicates which of the two PSRAM threshold crossing indications coming from the SBPM will be used for the copy decision. when going over the chosen threshold, packets will be copied to the DDR."
    "0 - Lower threshold"
    "1 - Higher threshold",
#endif
    QM_COPY_DECISION_PROFILE_THR_PSRAM_THR_FIELD_MASK,
    0,
    QM_COPY_DECISION_PROFILE_THR_PSRAM_THR_FIELD_WIDTH,
    QM_COPY_DECISION_PROFILE_THR_PSRAM_THR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_TOTAL_VALID_COUNTER_COUNTER_DATA
 ******************************************************************************/
const ru_field_rec QM_TOTAL_VALID_COUNTER_COUNTER_DATA_FIELD =
{
    "DATA",
#if RU_INCLUDE_DESC
    "DATA",
    "DATA",
#endif
    QM_TOTAL_VALID_COUNTER_COUNTER_DATA_FIELD_MASK,
    0,
    QM_TOTAL_VALID_COUNTER_COUNTER_DATA_FIELD_WIDTH,
    QM_TOTAL_VALID_COUNTER_COUNTER_DATA_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_DQM_VALID_COUNTER_COUNTER_DATA
 ******************************************************************************/
const ru_field_rec QM_DQM_VALID_COUNTER_COUNTER_DATA_FIELD =
{
    "DATA",
#if RU_INCLUDE_DESC
    "DATA",
    "DATA",
#endif
    QM_DQM_VALID_COUNTER_COUNTER_DATA_FIELD_MASK,
    0,
    QM_DQM_VALID_COUNTER_COUNTER_DATA_FIELD_WIDTH,
    QM_DQM_VALID_COUNTER_COUNTER_DATA_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_DROP_COUNTER_COUNTER_DATA
 ******************************************************************************/
const ru_field_rec QM_DROP_COUNTER_COUNTER_DATA_FIELD =
{
    "DATA",
#if RU_INCLUDE_DESC
    "DATA",
    "DATA",
#endif
    QM_DROP_COUNTER_COUNTER_DATA_FIELD_MASK,
    0,
    QM_DROP_COUNTER_COUNTER_DATA_FIELD_WIDTH,
    QM_DROP_COUNTER_COUNTER_DATA_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_EPON_RPT_CNT_COUNTER_DATA
 ******************************************************************************/
const ru_field_rec QM_EPON_RPT_CNT_COUNTER_DATA_FIELD =
{
    "DATA",
#if RU_INCLUDE_DESC
    "DATA",
    "DATA",
#endif
    QM_EPON_RPT_CNT_COUNTER_DATA_FIELD_MASK,
    0,
    QM_EPON_RPT_CNT_COUNTER_DATA_FIELD_WIDTH,
    QM_EPON_RPT_CNT_COUNTER_DATA_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_EPON_RPT_CNT_QUEUE_STATUS_STATUS_BIT_VECTOR
 ******************************************************************************/
const ru_field_rec QM_EPON_RPT_CNT_QUEUE_STATUS_STATUS_BIT_VECTOR_FIELD =
{
    "STATUS_BIT_VECTOR",
#if RU_INCLUDE_DESC
    "STATUS_BIT_VECTOR",
    "Status bit vector - a bit per queue indicates if the queue has been updated.",
#endif
    QM_EPON_RPT_CNT_QUEUE_STATUS_STATUS_BIT_VECTOR_FIELD_MASK,
    0,
    QM_EPON_RPT_CNT_QUEUE_STATUS_STATUS_BIT_VECTOR_FIELD_WIDTH,
    QM_EPON_RPT_CNT_QUEUE_STATUS_STATUS_BIT_VECTOR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_RD_DATA_POOL0_DATA
 ******************************************************************************/
const ru_field_rec QM_RD_DATA_POOL0_DATA_FIELD =
{
    "DATA",
#if RU_INCLUDE_DESC
    "DATA",
    "DATA",
#endif
    QM_RD_DATA_POOL0_DATA_FIELD_MASK,
    0,
    QM_RD_DATA_POOL0_DATA_FIELD_WIDTH,
    QM_RD_DATA_POOL0_DATA_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_RD_DATA_POOL1_DATA
 ******************************************************************************/
const ru_field_rec QM_RD_DATA_POOL1_DATA_FIELD =
{
    "DATA",
#if RU_INCLUDE_DESC
    "DATA",
    "DATA",
#endif
    QM_RD_DATA_POOL1_DATA_FIELD_MASK,
    0,
    QM_RD_DATA_POOL1_DATA_FIELD_WIDTH,
    QM_RD_DATA_POOL1_DATA_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_RD_DATA_POOL2_DATA
 ******************************************************************************/
const ru_field_rec QM_RD_DATA_POOL2_DATA_FIELD =
{
    "DATA",
#if RU_INCLUDE_DESC
    "DATA",
    "DATA",
#endif
    QM_RD_DATA_POOL2_DATA_FIELD_MASK,
    0,
    QM_RD_DATA_POOL2_DATA_FIELD_WIDTH,
    QM_RD_DATA_POOL2_DATA_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_RD_DATA_POOL3_DATA
 ******************************************************************************/
const ru_field_rec QM_RD_DATA_POOL3_DATA_FIELD =
{
    "DATA",
#if RU_INCLUDE_DESC
    "DATA",
    "DATA",
#endif
    QM_RD_DATA_POOL3_DATA_FIELD_MASK,
    0,
    QM_RD_DATA_POOL3_DATA_FIELD_WIDTH,
    QM_RD_DATA_POOL3_DATA_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_PDFIFO_PTR_WR_PTR
 ******************************************************************************/
const ru_field_rec QM_PDFIFO_PTR_WR_PTR_FIELD =
{
    "WR_PTR",
#if RU_INCLUDE_DESC
    "WR_PTR",
    "PDFIFO WR pointers",
#endif
    QM_PDFIFO_PTR_WR_PTR_FIELD_MASK,
    0,
    QM_PDFIFO_PTR_WR_PTR_FIELD_WIDTH,
    QM_PDFIFO_PTR_WR_PTR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_PDFIFO_PTR_RESERVED0
 ******************************************************************************/
const ru_field_rec QM_PDFIFO_PTR_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    QM_PDFIFO_PTR_RESERVED0_FIELD_MASK,
    0,
    QM_PDFIFO_PTR_RESERVED0_FIELD_WIDTH,
    QM_PDFIFO_PTR_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_PDFIFO_PTR_RD_PTR
 ******************************************************************************/
const ru_field_rec QM_PDFIFO_PTR_RD_PTR_FIELD =
{
    "RD_PTR",
#if RU_INCLUDE_DESC
    "RD_PTR",
    "PDFIFO RD pointers",
#endif
    QM_PDFIFO_PTR_RD_PTR_FIELD_MASK,
    0,
    QM_PDFIFO_PTR_RD_PTR_FIELD_WIDTH,
    QM_PDFIFO_PTR_RD_PTR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_PDFIFO_PTR_RESERVED1
 ******************************************************************************/
const ru_field_rec QM_PDFIFO_PTR_RESERVED1_FIELD =
{
    "RESERVED1",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    QM_PDFIFO_PTR_RESERVED1_FIELD_MASK,
    0,
    QM_PDFIFO_PTR_RESERVED1_FIELD_WIDTH,
    QM_PDFIFO_PTR_RESERVED1_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_UPDATE_FIFO_PTR_WR_PTR
 ******************************************************************************/
const ru_field_rec QM_UPDATE_FIFO_PTR_WR_PTR_FIELD =
{
    "WR_PTR",
#if RU_INCLUDE_DESC
    "WR_PTR",
    "UF WR pointers",
#endif
    QM_UPDATE_FIFO_PTR_WR_PTR_FIELD_MASK,
    0,
    QM_UPDATE_FIFO_PTR_WR_PTR_FIELD_WIDTH,
    QM_UPDATE_FIFO_PTR_WR_PTR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_UPDATE_FIFO_PTR_RD_PTR
 ******************************************************************************/
const ru_field_rec QM_UPDATE_FIFO_PTR_RD_PTR_FIELD =
{
    "RD_PTR",
#if RU_INCLUDE_DESC
    "RD_PTR",
    "UF RD pointers",
#endif
    QM_UPDATE_FIFO_PTR_RD_PTR_FIELD_MASK,
    0,
    QM_UPDATE_FIFO_PTR_RD_PTR_FIELD_WIDTH,
    QM_UPDATE_FIFO_PTR_RD_PTR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_UPDATE_FIFO_PTR_RESERVED0
 ******************************************************************************/
const ru_field_rec QM_UPDATE_FIFO_PTR_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    QM_UPDATE_FIFO_PTR_RESERVED0_FIELD_MASK,
    0,
    QM_UPDATE_FIFO_PTR_RESERVED0_FIELD_WIDTH,
    QM_UPDATE_FIFO_PTR_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_RD_DATA_DATA
 ******************************************************************************/
const ru_field_rec QM_RD_DATA_DATA_FIELD =
{
    "DATA",
#if RU_INCLUDE_DESC
    "DATA",
    "DATA",
#endif
    QM_RD_DATA_DATA_FIELD_MASK,
    0,
    QM_RD_DATA_DATA_FIELD_WIDTH,
    QM_RD_DATA_DATA_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_POP_POP
 ******************************************************************************/
const ru_field_rec QM_POP_POP_FIELD =
{
    "POP",
#if RU_INCLUDE_DESC
    "POP",
    "Pop FIFO entry",
#endif
    QM_POP_POP_FIELD_MASK,
    0,
    QM_POP_POP_FIELD_WIDTH,
    QM_POP_POP_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_POP_RESERVED0
 ******************************************************************************/
const ru_field_rec QM_POP_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    QM_POP_RESERVED0_FIELD_MASK,
    0,
    QM_POP_RESERVED0_FIELD_WIDTH,
    QM_POP_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_CM_COMMON_INPUT_FIFO_DATA_DATA
 ******************************************************************************/
const ru_field_rec QM_CM_COMMON_INPUT_FIFO_DATA_DATA_FIELD =
{
    "DATA",
#if RU_INCLUDE_DESC
    "DATA",
    "DATA",
#endif
    QM_CM_COMMON_INPUT_FIFO_DATA_DATA_FIELD_MASK,
    0,
    QM_CM_COMMON_INPUT_FIFO_DATA_DATA_FIELD_WIDTH,
    QM_CM_COMMON_INPUT_FIFO_DATA_DATA_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_NORMAL_RMT_FIFO_DATA_DATA
 ******************************************************************************/
const ru_field_rec QM_NORMAL_RMT_FIFO_DATA_DATA_FIELD =
{
    "DATA",
#if RU_INCLUDE_DESC
    "DATA",
    "DATA",
#endif
    QM_NORMAL_RMT_FIFO_DATA_DATA_FIELD_MASK,
    0,
    QM_NORMAL_RMT_FIFO_DATA_DATA_FIELD_WIDTH,
    QM_NORMAL_RMT_FIFO_DATA_DATA_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_NON_DELAYED_RMT_FIFO_DATA_DATA
 ******************************************************************************/
const ru_field_rec QM_NON_DELAYED_RMT_FIFO_DATA_DATA_FIELD =
{
    "DATA",
#if RU_INCLUDE_DESC
    "DATA",
    "DATA",
#endif
    QM_NON_DELAYED_RMT_FIFO_DATA_DATA_FIELD_MASK,
    0,
    QM_NON_DELAYED_RMT_FIFO_DATA_DATA_FIELD_WIDTH,
    QM_NON_DELAYED_RMT_FIFO_DATA_DATA_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_EGRESS_DATA_FIFO_DATA_DATA
 ******************************************************************************/
const ru_field_rec QM_EGRESS_DATA_FIFO_DATA_DATA_FIELD =
{
    "DATA",
#if RU_INCLUDE_DESC
    "DATA",
    "DATA",
#endif
    QM_EGRESS_DATA_FIFO_DATA_DATA_FIELD_MASK,
    0,
    QM_EGRESS_DATA_FIFO_DATA_DATA_FIELD_WIDTH,
    QM_EGRESS_DATA_FIFO_DATA_DATA_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_EGRESS_RR_FIFO_DATA_DATA
 ******************************************************************************/
const ru_field_rec QM_EGRESS_RR_FIFO_DATA_DATA_FIELD =
{
    "DATA",
#if RU_INCLUDE_DESC
    "DATA",
    "DATA",
#endif
    QM_EGRESS_RR_FIFO_DATA_DATA_FIELD_MASK,
    0,
    QM_EGRESS_RR_FIFO_DATA_DATA_FIELD_WIDTH,
    QM_EGRESS_RR_FIFO_DATA_DATA_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_EGRESS_BB_INPUT_FIFO_DATA_DATA
 ******************************************************************************/
const ru_field_rec QM_EGRESS_BB_INPUT_FIFO_DATA_DATA_FIELD =
{
    "DATA",
#if RU_INCLUDE_DESC
    "DATA",
    "DATA",
#endif
    QM_EGRESS_BB_INPUT_FIFO_DATA_DATA_FIELD_MASK,
    0,
    QM_EGRESS_BB_INPUT_FIFO_DATA_DATA_FIELD_WIDTH,
    QM_EGRESS_BB_INPUT_FIFO_DATA_DATA_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_EGRESS_BB_OUTPUT_FIFO_DATA_DATA
 ******************************************************************************/
const ru_field_rec QM_EGRESS_BB_OUTPUT_FIFO_DATA_DATA_FIELD =
{
    "DATA",
#if RU_INCLUDE_DESC
    "DATA",
    "DATA",
#endif
    QM_EGRESS_BB_OUTPUT_FIFO_DATA_DATA_FIELD_MASK,
    0,
    QM_EGRESS_BB_OUTPUT_FIFO_DATA_DATA_FIELD_WIDTH,
    QM_EGRESS_BB_OUTPUT_FIFO_DATA_DATA_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_BB_OUTPUT_FIFO_DATA_DATA
 ******************************************************************************/
const ru_field_rec QM_BB_OUTPUT_FIFO_DATA_DATA_FIELD =
{
    "DATA",
#if RU_INCLUDE_DESC
    "DATA",
    "DATA",
#endif
    QM_BB_OUTPUT_FIFO_DATA_DATA_FIELD_MASK,
    0,
    QM_BB_OUTPUT_FIFO_DATA_DATA_FIELD_WIDTH,
    QM_BB_OUTPUT_FIFO_DATA_DATA_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_NON_DELAYED_OUT_FIFO_DATA_DATA
 ******************************************************************************/
const ru_field_rec QM_NON_DELAYED_OUT_FIFO_DATA_DATA_FIELD =
{
    "DATA",
#if RU_INCLUDE_DESC
    "DATA",
    "DATA",
#endif
    QM_NON_DELAYED_OUT_FIFO_DATA_DATA_FIELD_MASK,
    0,
    QM_NON_DELAYED_OUT_FIFO_DATA_DATA_FIELD_WIDTH,
    QM_NON_DELAYED_OUT_FIFO_DATA_DATA_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_CONTEXT_DATA_DATA
 ******************************************************************************/
const ru_field_rec QM_CONTEXT_DATA_DATA_FIELD =
{
    "DATA",
#if RU_INCLUDE_DESC
    "DATA",
    "DATA",
#endif
    QM_CONTEXT_DATA_DATA_FIELD_MASK,
    0,
    QM_CONTEXT_DATA_DATA_FIELD_WIDTH,
    QM_CONTEXT_DATA_DATA_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_FPM_BUFFER_RESERVATION_DATA_DATA
 ******************************************************************************/
const ru_field_rec QM_FPM_BUFFER_RESERVATION_DATA_DATA_FIELD =
{
    "DATA",
#if RU_INCLUDE_DESC
    "DATA",
    "DATA",
#endif
    QM_FPM_BUFFER_RESERVATION_DATA_DATA_FIELD_MASK,
    0,
    QM_FPM_BUFFER_RESERVATION_DATA_DATA_FIELD_WIDTH,
    QM_FPM_BUFFER_RESERVATION_DATA_DATA_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_FPM_BUFFER_RESERVATION_DATA_RESERVED0
 ******************************************************************************/
const ru_field_rec QM_FPM_BUFFER_RESERVATION_DATA_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    QM_FPM_BUFFER_RESERVATION_DATA_RESERVED0_FIELD_MASK,
    0,
    QM_FPM_BUFFER_RESERVATION_DATA_RESERVED0_FIELD_WIDTH,
    QM_FPM_BUFFER_RESERVATION_DATA_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_PORT_CFG_EN_BYTE
 ******************************************************************************/
const ru_field_rec QM_PORT_CFG_EN_BYTE_FIELD =
{
    "EN_BYTE",
#if RU_INCLUDE_DESC
    "EN_BYTE",
    "Enable flow control on byte occupancy",
#endif
    QM_PORT_CFG_EN_BYTE_FIELD_MASK,
    0,
    QM_PORT_CFG_EN_BYTE_FIELD_WIDTH,
    QM_PORT_CFG_EN_BYTE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_PORT_CFG_EN_UG
 ******************************************************************************/
const ru_field_rec QM_PORT_CFG_EN_UG_FIELD =
{
    "EN_UG",
#if RU_INCLUDE_DESC
    "EN_UG",
    "Enable flow control according to byte occupancy",
#endif
    QM_PORT_CFG_EN_UG_FIELD_MASK,
    0,
    QM_PORT_CFG_EN_UG_FIELD_WIDTH,
    QM_PORT_CFG_EN_UG_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_PORT_CFG_RESERVED0
 ******************************************************************************/
const ru_field_rec QM_PORT_CFG_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    QM_PORT_CFG_RESERVED0_FIELD_MASK,
    0,
    QM_PORT_CFG_RESERVED0_FIELD_WIDTH,
    QM_PORT_CFG_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_PORT_CFG_BBH_RX_BB_ID
 ******************************************************************************/
const ru_field_rec QM_PORT_CFG_BBH_RX_BB_ID_FIELD =
{
    "BBH_RX_BB_ID",
#if RU_INCLUDE_DESC
    "BBH_RX_BB_ID",
    "BB ID to send Xoff/Xon."
    "Design assumption:"
    "if WAN == 0 then BB_ID == PDs MAC_FLOW",
#endif
    QM_PORT_CFG_BBH_RX_BB_ID_FIELD_MASK,
    0,
    QM_PORT_CFG_BBH_RX_BB_ID_FIELD_WIDTH,
    QM_PORT_CFG_BBH_RX_BB_ID_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_PORT_CFG_RESERVED1
 ******************************************************************************/
const ru_field_rec QM_PORT_CFG_RESERVED1_FIELD =
{
    "RESERVED1",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    QM_PORT_CFG_RESERVED1_FIELD_MASK,
    0,
    QM_PORT_CFG_RESERVED1_FIELD_WIDTH,
    QM_PORT_CFG_RESERVED1_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_FC_UG_MASK_UG0_EN
 ******************************************************************************/
const ru_field_rec QM_FC_UG_MASK_UG0_EN_FIELD =
{
    "UG0_EN",
#if RU_INCLUDE_DESC
    "UG0_EN",
    "UG0 participates in FC",
#endif
    QM_FC_UG_MASK_UG0_EN_FIELD_MASK,
    0,
    QM_FC_UG_MASK_UG0_EN_FIELD_WIDTH,
    QM_FC_UG_MASK_UG0_EN_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_FC_UG_MASK_UG1_EN
 ******************************************************************************/
const ru_field_rec QM_FC_UG_MASK_UG1_EN_FIELD =
{
    "UG1_EN",
#if RU_INCLUDE_DESC
    "UG1_EN",
    "UG1 participates in FC",
#endif
    QM_FC_UG_MASK_UG1_EN_FIELD_MASK,
    0,
    QM_FC_UG_MASK_UG1_EN_FIELD_WIDTH,
    QM_FC_UG_MASK_UG1_EN_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_FC_UG_MASK_UG2_EN
 ******************************************************************************/
const ru_field_rec QM_FC_UG_MASK_UG2_EN_FIELD =
{
    "UG2_EN",
#if RU_INCLUDE_DESC
    "UG2_EN",
    "UG2 participates in FC",
#endif
    QM_FC_UG_MASK_UG2_EN_FIELD_MASK,
    0,
    QM_FC_UG_MASK_UG2_EN_FIELD_WIDTH,
    QM_FC_UG_MASK_UG2_EN_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_FC_UG_MASK_UG3_EN
 ******************************************************************************/
const ru_field_rec QM_FC_UG_MASK_UG3_EN_FIELD =
{
    "UG3_EN",
#if RU_INCLUDE_DESC
    "UG3_EN",
    "UG3 participates in FC",
#endif
    QM_FC_UG_MASK_UG3_EN_FIELD_MASK,
    0,
    QM_FC_UG_MASK_UG3_EN_FIELD_WIDTH,
    QM_FC_UG_MASK_UG3_EN_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_FC_UG_MASK_RESERVED0
 ******************************************************************************/
const ru_field_rec QM_FC_UG_MASK_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    QM_FC_UG_MASK_RESERVED0_FIELD_MASK,
    0,
    QM_FC_UG_MASK_RESERVED0_FIELD_WIDTH,
    QM_FC_UG_MASK_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_FC_QUEUE_MASK_QUEUE_VEC
 ******************************************************************************/
const ru_field_rec QM_FC_QUEUE_MASK_QUEUE_VEC_FIELD =
{
    "QUEUE_VEC",
#if RU_INCLUDE_DESC
    "QUEUE_VEC",
    "each bit represents queue."
    "1 - fc is enabled for this queue (unmasked)"
    "0 - fc is disabled for this queue (masked)",
#endif
    QM_FC_QUEUE_MASK_QUEUE_VEC_FIELD_MASK,
    0,
    QM_FC_QUEUE_MASK_QUEUE_VEC_FIELD_WIDTH,
    QM_FC_QUEUE_MASK_QUEUE_VEC_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_DBG_STATUS
 ******************************************************************************/
const ru_field_rec QM_DBG_STATUS_FIELD =
{
    "STATUS",
#if RU_INCLUDE_DESC
    "STATUS",
    "1 - exceeds thr"
    "0 - below thr",
#endif
    QM_DBG_STATUS_FIELD_MASK,
    0,
    QM_DBG_STATUS_FIELD_WIDTH,
    QM_DBG_STATUS_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_UG_OCCUPANCY_STATUS_QUEUE
 ******************************************************************************/
const ru_field_rec QM_UG_OCCUPANCY_STATUS_QUEUE_FIELD =
{
    "QUEUE",
#if RU_INCLUDE_DESC
    "QUEUE",
    "queue",
#endif
    QM_UG_OCCUPANCY_STATUS_QUEUE_FIELD_MASK,
    0,
    QM_UG_OCCUPANCY_STATUS_QUEUE_FIELD_WIDTH,
    QM_UG_OCCUPANCY_STATUS_QUEUE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_QUEUE_OCCUPANCY_STATUS_STATUS
 ******************************************************************************/
const ru_field_rec QM_QUEUE_OCCUPANCY_STATUS_STATUS_FIELD =
{
    "STATUS",
#if RU_INCLUDE_DESC
    "STATUS",
    "1 - exceeds thr"
    "0 - below thr",
#endif
    QM_QUEUE_OCCUPANCY_STATUS_STATUS_FIELD_MASK,
    0,
    QM_QUEUE_OCCUPANCY_STATUS_STATUS_FIELD_WIDTH,
    QM_QUEUE_OCCUPANCY_STATUS_STATUS_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_DEBUG_SEL_SELECT
 ******************************************************************************/
const ru_field_rec QM_DEBUG_SEL_SELECT_FIELD =
{
    "SELECT",
#if RU_INCLUDE_DESC
    "SELECT",
    "Counter",
#endif
    QM_DEBUG_SEL_SELECT_FIELD_MASK,
    0,
    QM_DEBUG_SEL_SELECT_FIELD_WIDTH,
    QM_DEBUG_SEL_SELECT_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_DEBUG_SEL_RESERVED0
 ******************************************************************************/
const ru_field_rec QM_DEBUG_SEL_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    QM_DEBUG_SEL_RESERVED0_FIELD_MASK,
    0,
    QM_DEBUG_SEL_RESERVED0_FIELD_WIDTH,
    QM_DEBUG_SEL_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_DEBUG_SEL_ENABLE
 ******************************************************************************/
const ru_field_rec QM_DEBUG_SEL_ENABLE_FIELD =
{
    "ENABLE",
#if RU_INCLUDE_DESC
    "ENABLE",
    "Enable register controlled debug select",
#endif
    QM_DEBUG_SEL_ENABLE_FIELD_MASK,
    0,
    QM_DEBUG_SEL_ENABLE_FIELD_WIDTH,
    QM_DEBUG_SEL_ENABLE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_DEBUG_BUS_LSB_DATA
 ******************************************************************************/
const ru_field_rec QM_DEBUG_BUS_LSB_DATA_FIELD =
{
    "DATA",
#if RU_INCLUDE_DESC
    "DATA",
    "Data",
#endif
    QM_DEBUG_BUS_LSB_DATA_FIELD_MASK,
    0,
    QM_DEBUG_BUS_LSB_DATA_FIELD_WIDTH,
    QM_DEBUG_BUS_LSB_DATA_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_DEBUG_BUS_MSB_DATA
 ******************************************************************************/
const ru_field_rec QM_DEBUG_BUS_MSB_DATA_FIELD =
{
    "DATA",
#if RU_INCLUDE_DESC
    "DATA",
    "Data",
#endif
    QM_DEBUG_BUS_MSB_DATA_FIELD_MASK,
    0,
    QM_DEBUG_BUS_MSB_DATA_FIELD_WIDTH,
    QM_DEBUG_BUS_MSB_DATA_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_QM_SPARE_CONFIG_DATA
 ******************************************************************************/
const ru_field_rec QM_QM_SPARE_CONFIG_DATA_FIELD =
{
    "DATA",
#if RU_INCLUDE_DESC
    "DATA",
    "Data",
#endif
    QM_QM_SPARE_CONFIG_DATA_FIELD_MASK,
    0,
    QM_QM_SPARE_CONFIG_DATA_FIELD_WIDTH,
    QM_QM_SPARE_CONFIG_DATA_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_GOOD_LVL1_PKTS_CNT_COUNTER
 ******************************************************************************/
const ru_field_rec QM_GOOD_LVL1_PKTS_CNT_COUNTER_FIELD =
{
    "COUNTER",
#if RU_INCLUDE_DESC
    "COUNTER",
    "Counter",
#endif
    QM_GOOD_LVL1_PKTS_CNT_COUNTER_FIELD_MASK,
    0,
    QM_GOOD_LVL1_PKTS_CNT_COUNTER_FIELD_WIDTH,
    QM_GOOD_LVL1_PKTS_CNT_COUNTER_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_GOOD_LVL1_BYTES_CNT_COUNTER
 ******************************************************************************/
const ru_field_rec QM_GOOD_LVL1_BYTES_CNT_COUNTER_FIELD =
{
    "COUNTER",
#if RU_INCLUDE_DESC
    "COUNTER",
    "Counter",
#endif
    QM_GOOD_LVL1_BYTES_CNT_COUNTER_FIELD_MASK,
    0,
    QM_GOOD_LVL1_BYTES_CNT_COUNTER_FIELD_WIDTH,
    QM_GOOD_LVL1_BYTES_CNT_COUNTER_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_GOOD_LVL2_PKTS_CNT_COUNTER
 ******************************************************************************/
const ru_field_rec QM_GOOD_LVL2_PKTS_CNT_COUNTER_FIELD =
{
    "COUNTER",
#if RU_INCLUDE_DESC
    "COUNTER",
    "Counter",
#endif
    QM_GOOD_LVL2_PKTS_CNT_COUNTER_FIELD_MASK,
    0,
    QM_GOOD_LVL2_PKTS_CNT_COUNTER_FIELD_WIDTH,
    QM_GOOD_LVL2_PKTS_CNT_COUNTER_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_GOOD_LVL2_BYTES_CNT_COUNTER
 ******************************************************************************/
const ru_field_rec QM_GOOD_LVL2_BYTES_CNT_COUNTER_FIELD =
{
    "COUNTER",
#if RU_INCLUDE_DESC
    "COUNTER",
    "Counter",
#endif
    QM_GOOD_LVL2_BYTES_CNT_COUNTER_FIELD_MASK,
    0,
    QM_GOOD_LVL2_BYTES_CNT_COUNTER_FIELD_WIDTH,
    QM_GOOD_LVL2_BYTES_CNT_COUNTER_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_COPIED_PKTS_CNT_COUNTER
 ******************************************************************************/
const ru_field_rec QM_COPIED_PKTS_CNT_COUNTER_FIELD =
{
    "COUNTER",
#if RU_INCLUDE_DESC
    "COUNTER",
    "Counter",
#endif
    QM_COPIED_PKTS_CNT_COUNTER_FIELD_MASK,
    0,
    QM_COPIED_PKTS_CNT_COUNTER_FIELD_WIDTH,
    QM_COPIED_PKTS_CNT_COUNTER_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_COPIED_BYTES_CNT_COUNTER
 ******************************************************************************/
const ru_field_rec QM_COPIED_BYTES_CNT_COUNTER_FIELD =
{
    "COUNTER",
#if RU_INCLUDE_DESC
    "COUNTER",
    "Counter",
#endif
    QM_COPIED_BYTES_CNT_COUNTER_FIELD_MASK,
    0,
    QM_COPIED_BYTES_CNT_COUNTER_FIELD_WIDTH,
    QM_COPIED_BYTES_CNT_COUNTER_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_AGG_PKTS_CNT_COUNTER
 ******************************************************************************/
const ru_field_rec QM_AGG_PKTS_CNT_COUNTER_FIELD =
{
    "COUNTER",
#if RU_INCLUDE_DESC
    "COUNTER",
    "Counter",
#endif
    QM_AGG_PKTS_CNT_COUNTER_FIELD_MASK,
    0,
    QM_AGG_PKTS_CNT_COUNTER_FIELD_WIDTH,
    QM_AGG_PKTS_CNT_COUNTER_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_AGG_BYTES_CNT_COUNTER
 ******************************************************************************/
const ru_field_rec QM_AGG_BYTES_CNT_COUNTER_FIELD =
{
    "COUNTER",
#if RU_INCLUDE_DESC
    "COUNTER",
    "Counter",
#endif
    QM_AGG_BYTES_CNT_COUNTER_FIELD_MASK,
    0,
    QM_AGG_BYTES_CNT_COUNTER_FIELD_WIDTH,
    QM_AGG_BYTES_CNT_COUNTER_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_AGG_1_PKTS_CNT_COUNTER
 ******************************************************************************/
const ru_field_rec QM_AGG_1_PKTS_CNT_COUNTER_FIELD =
{
    "COUNTER",
#if RU_INCLUDE_DESC
    "COUNTER",
    "Counter",
#endif
    QM_AGG_1_PKTS_CNT_COUNTER_FIELD_MASK,
    0,
    QM_AGG_1_PKTS_CNT_COUNTER_FIELD_WIDTH,
    QM_AGG_1_PKTS_CNT_COUNTER_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_AGG_2_PKTS_CNT_COUNTER
 ******************************************************************************/
const ru_field_rec QM_AGG_2_PKTS_CNT_COUNTER_FIELD =
{
    "COUNTER",
#if RU_INCLUDE_DESC
    "COUNTER",
    "Counter",
#endif
    QM_AGG_2_PKTS_CNT_COUNTER_FIELD_MASK,
    0,
    QM_AGG_2_PKTS_CNT_COUNTER_FIELD_WIDTH,
    QM_AGG_2_PKTS_CNT_COUNTER_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_AGG_3_PKTS_CNT_COUNTER
 ******************************************************************************/
const ru_field_rec QM_AGG_3_PKTS_CNT_COUNTER_FIELD =
{
    "COUNTER",
#if RU_INCLUDE_DESC
    "COUNTER",
    "Counter",
#endif
    QM_AGG_3_PKTS_CNT_COUNTER_FIELD_MASK,
    0,
    QM_AGG_3_PKTS_CNT_COUNTER_FIELD_WIDTH,
    QM_AGG_3_PKTS_CNT_COUNTER_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_AGG_4_PKTS_CNT_COUNTER
 ******************************************************************************/
const ru_field_rec QM_AGG_4_PKTS_CNT_COUNTER_FIELD =
{
    "COUNTER",
#if RU_INCLUDE_DESC
    "COUNTER",
    "Counter",
#endif
    QM_AGG_4_PKTS_CNT_COUNTER_FIELD_MASK,
    0,
    QM_AGG_4_PKTS_CNT_COUNTER_FIELD_WIDTH,
    QM_AGG_4_PKTS_CNT_COUNTER_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_WRED_DROP_CNT_COUNTER
 ******************************************************************************/
const ru_field_rec QM_WRED_DROP_CNT_COUNTER_FIELD =
{
    "COUNTER",
#if RU_INCLUDE_DESC
    "COUNTER",
    "Counter",
#endif
    QM_WRED_DROP_CNT_COUNTER_FIELD_MASK,
    0,
    QM_WRED_DROP_CNT_COUNTER_FIELD_WIDTH,
    QM_WRED_DROP_CNT_COUNTER_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_FPM_CONGESTION_DROP_CNT_COUNTER
 ******************************************************************************/
const ru_field_rec QM_FPM_CONGESTION_DROP_CNT_COUNTER_FIELD =
{
    "COUNTER",
#if RU_INCLUDE_DESC
    "COUNTER",
    "Counter",
#endif
    QM_FPM_CONGESTION_DROP_CNT_COUNTER_FIELD_MASK,
    0,
    QM_FPM_CONGESTION_DROP_CNT_COUNTER_FIELD_WIDTH,
    QM_FPM_CONGESTION_DROP_CNT_COUNTER_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_DDR_PD_CONGESTION_DROP_CNT_COUNTER
 ******************************************************************************/
const ru_field_rec QM_DDR_PD_CONGESTION_DROP_CNT_COUNTER_FIELD =
{
    "COUNTER",
#if RU_INCLUDE_DESC
    "COUNTER",
    "Counter",
#endif
    QM_DDR_PD_CONGESTION_DROP_CNT_COUNTER_FIELD_MASK,
    0,
    QM_DDR_PD_CONGESTION_DROP_CNT_COUNTER_FIELD_WIDTH,
    QM_DDR_PD_CONGESTION_DROP_CNT_COUNTER_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_DDR_BYTE_CONGESTION_DROP_CNT_COUNTER
 ******************************************************************************/
const ru_field_rec QM_DDR_BYTE_CONGESTION_DROP_CNT_COUNTER_FIELD =
{
    "COUNTER",
#if RU_INCLUDE_DESC
    "COUNTER",
    "Counter",
#endif
    QM_DDR_BYTE_CONGESTION_DROP_CNT_COUNTER_FIELD_MASK,
    0,
    QM_DDR_BYTE_CONGESTION_DROP_CNT_COUNTER_FIELD_WIDTH,
    QM_DDR_BYTE_CONGESTION_DROP_CNT_COUNTER_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_QM_PD_CONGESTION_DROP_CNT_COUNTER
 ******************************************************************************/
const ru_field_rec QM_QM_PD_CONGESTION_DROP_CNT_COUNTER_FIELD =
{
    "COUNTER",
#if RU_INCLUDE_DESC
    "COUNTER",
    "Counter",
#endif
    QM_QM_PD_CONGESTION_DROP_CNT_COUNTER_FIELD_MASK,
    0,
    QM_QM_PD_CONGESTION_DROP_CNT_COUNTER_FIELD_WIDTH,
    QM_QM_PD_CONGESTION_DROP_CNT_COUNTER_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_QM_ABS_REQUEUE_CNT_COUNTER
 ******************************************************************************/
const ru_field_rec QM_QM_ABS_REQUEUE_CNT_COUNTER_FIELD =
{
    "COUNTER",
#if RU_INCLUDE_DESC
    "COUNTER",
    "Counter",
#endif
    QM_QM_ABS_REQUEUE_CNT_COUNTER_FIELD_MASK,
    0,
    QM_QM_ABS_REQUEUE_CNT_COUNTER_FIELD_WIDTH,
    QM_QM_ABS_REQUEUE_CNT_COUNTER_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_FPM_PREFETCH_FIFO0_STATUS_USED_WORDS
 ******************************************************************************/
const ru_field_rec QM_FPM_PREFETCH_FIFO0_STATUS_USED_WORDS_FIELD =
{
    "USED_WORDS",
#if RU_INCLUDE_DESC
    "USED_WORDS",
    "Used words",
#endif
    QM_FPM_PREFETCH_FIFO0_STATUS_USED_WORDS_FIELD_MASK,
    0,
    QM_FPM_PREFETCH_FIFO0_STATUS_USED_WORDS_FIELD_WIDTH,
    QM_FPM_PREFETCH_FIFO0_STATUS_USED_WORDS_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_FPM_PREFETCH_FIFO0_STATUS_EMPTY
 ******************************************************************************/
const ru_field_rec QM_FPM_PREFETCH_FIFO0_STATUS_EMPTY_FIELD =
{
    "EMPTY",
#if RU_INCLUDE_DESC
    "EMPTY",
    "Empty",
#endif
    QM_FPM_PREFETCH_FIFO0_STATUS_EMPTY_FIELD_MASK,
    0,
    QM_FPM_PREFETCH_FIFO0_STATUS_EMPTY_FIELD_WIDTH,
    QM_FPM_PREFETCH_FIFO0_STATUS_EMPTY_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_FPM_PREFETCH_FIFO0_STATUS_FULL
 ******************************************************************************/
const ru_field_rec QM_FPM_PREFETCH_FIFO0_STATUS_FULL_FIELD =
{
    "FULL",
#if RU_INCLUDE_DESC
    "FULL",
    "Full",
#endif
    QM_FPM_PREFETCH_FIFO0_STATUS_FULL_FIELD_MASK,
    0,
    QM_FPM_PREFETCH_FIFO0_STATUS_FULL_FIELD_WIDTH,
    QM_FPM_PREFETCH_FIFO0_STATUS_FULL_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_FPM_PREFETCH_FIFO0_STATUS_RESERVED0
 ******************************************************************************/
const ru_field_rec QM_FPM_PREFETCH_FIFO0_STATUS_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    QM_FPM_PREFETCH_FIFO0_STATUS_RESERVED0_FIELD_MASK,
    0,
    QM_FPM_PREFETCH_FIFO0_STATUS_RESERVED0_FIELD_WIDTH,
    QM_FPM_PREFETCH_FIFO0_STATUS_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_FPM_PREFETCH_FIFO1_STATUS_USED_WORDS
 ******************************************************************************/
const ru_field_rec QM_FPM_PREFETCH_FIFO1_STATUS_USED_WORDS_FIELD =
{
    "USED_WORDS",
#if RU_INCLUDE_DESC
    "USED_WORDS",
    "Used words",
#endif
    QM_FPM_PREFETCH_FIFO1_STATUS_USED_WORDS_FIELD_MASK,
    0,
    QM_FPM_PREFETCH_FIFO1_STATUS_USED_WORDS_FIELD_WIDTH,
    QM_FPM_PREFETCH_FIFO1_STATUS_USED_WORDS_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_FPM_PREFETCH_FIFO1_STATUS_EMPTY
 ******************************************************************************/
const ru_field_rec QM_FPM_PREFETCH_FIFO1_STATUS_EMPTY_FIELD =
{
    "EMPTY",
#if RU_INCLUDE_DESC
    "EMPTY",
    "Empty",
#endif
    QM_FPM_PREFETCH_FIFO1_STATUS_EMPTY_FIELD_MASK,
    0,
    QM_FPM_PREFETCH_FIFO1_STATUS_EMPTY_FIELD_WIDTH,
    QM_FPM_PREFETCH_FIFO1_STATUS_EMPTY_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_FPM_PREFETCH_FIFO1_STATUS_FULL
 ******************************************************************************/
const ru_field_rec QM_FPM_PREFETCH_FIFO1_STATUS_FULL_FIELD =
{
    "FULL",
#if RU_INCLUDE_DESC
    "FULL",
    "Full",
#endif
    QM_FPM_PREFETCH_FIFO1_STATUS_FULL_FIELD_MASK,
    0,
    QM_FPM_PREFETCH_FIFO1_STATUS_FULL_FIELD_WIDTH,
    QM_FPM_PREFETCH_FIFO1_STATUS_FULL_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_FPM_PREFETCH_FIFO1_STATUS_RESERVED0
 ******************************************************************************/
const ru_field_rec QM_FPM_PREFETCH_FIFO1_STATUS_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    QM_FPM_PREFETCH_FIFO1_STATUS_RESERVED0_FIELD_MASK,
    0,
    QM_FPM_PREFETCH_FIFO1_STATUS_RESERVED0_FIELD_WIDTH,
    QM_FPM_PREFETCH_FIFO1_STATUS_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_FPM_PREFETCH_FIFO2_STATUS_USED_WORDS
 ******************************************************************************/
const ru_field_rec QM_FPM_PREFETCH_FIFO2_STATUS_USED_WORDS_FIELD =
{
    "USED_WORDS",
#if RU_INCLUDE_DESC
    "USED_WORDS",
    "Used words",
#endif
    QM_FPM_PREFETCH_FIFO2_STATUS_USED_WORDS_FIELD_MASK,
    0,
    QM_FPM_PREFETCH_FIFO2_STATUS_USED_WORDS_FIELD_WIDTH,
    QM_FPM_PREFETCH_FIFO2_STATUS_USED_WORDS_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_FPM_PREFETCH_FIFO2_STATUS_EMPTY
 ******************************************************************************/
const ru_field_rec QM_FPM_PREFETCH_FIFO2_STATUS_EMPTY_FIELD =
{
    "EMPTY",
#if RU_INCLUDE_DESC
    "EMPTY",
    "Empty",
#endif
    QM_FPM_PREFETCH_FIFO2_STATUS_EMPTY_FIELD_MASK,
    0,
    QM_FPM_PREFETCH_FIFO2_STATUS_EMPTY_FIELD_WIDTH,
    QM_FPM_PREFETCH_FIFO2_STATUS_EMPTY_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_FPM_PREFETCH_FIFO2_STATUS_FULL
 ******************************************************************************/
const ru_field_rec QM_FPM_PREFETCH_FIFO2_STATUS_FULL_FIELD =
{
    "FULL",
#if RU_INCLUDE_DESC
    "FULL",
    "Full",
#endif
    QM_FPM_PREFETCH_FIFO2_STATUS_FULL_FIELD_MASK,
    0,
    QM_FPM_PREFETCH_FIFO2_STATUS_FULL_FIELD_WIDTH,
    QM_FPM_PREFETCH_FIFO2_STATUS_FULL_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_FPM_PREFETCH_FIFO2_STATUS_RESERVED0
 ******************************************************************************/
const ru_field_rec QM_FPM_PREFETCH_FIFO2_STATUS_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    QM_FPM_PREFETCH_FIFO2_STATUS_RESERVED0_FIELD_MASK,
    0,
    QM_FPM_PREFETCH_FIFO2_STATUS_RESERVED0_FIELD_WIDTH,
    QM_FPM_PREFETCH_FIFO2_STATUS_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_FPM_PREFETCH_FIFO3_STATUS_USED_WORDS
 ******************************************************************************/
const ru_field_rec QM_FPM_PREFETCH_FIFO3_STATUS_USED_WORDS_FIELD =
{
    "USED_WORDS",
#if RU_INCLUDE_DESC
    "USED_WORDS",
    "Used words",
#endif
    QM_FPM_PREFETCH_FIFO3_STATUS_USED_WORDS_FIELD_MASK,
    0,
    QM_FPM_PREFETCH_FIFO3_STATUS_USED_WORDS_FIELD_WIDTH,
    QM_FPM_PREFETCH_FIFO3_STATUS_USED_WORDS_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_FPM_PREFETCH_FIFO3_STATUS_EMPTY
 ******************************************************************************/
const ru_field_rec QM_FPM_PREFETCH_FIFO3_STATUS_EMPTY_FIELD =
{
    "EMPTY",
#if RU_INCLUDE_DESC
    "EMPTY",
    "Empty",
#endif
    QM_FPM_PREFETCH_FIFO3_STATUS_EMPTY_FIELD_MASK,
    0,
    QM_FPM_PREFETCH_FIFO3_STATUS_EMPTY_FIELD_WIDTH,
    QM_FPM_PREFETCH_FIFO3_STATUS_EMPTY_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_FPM_PREFETCH_FIFO3_STATUS_FULL
 ******************************************************************************/
const ru_field_rec QM_FPM_PREFETCH_FIFO3_STATUS_FULL_FIELD =
{
    "FULL",
#if RU_INCLUDE_DESC
    "FULL",
    "Full",
#endif
    QM_FPM_PREFETCH_FIFO3_STATUS_FULL_FIELD_MASK,
    0,
    QM_FPM_PREFETCH_FIFO3_STATUS_FULL_FIELD_WIDTH,
    QM_FPM_PREFETCH_FIFO3_STATUS_FULL_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_FPM_PREFETCH_FIFO3_STATUS_RESERVED0
 ******************************************************************************/
const ru_field_rec QM_FPM_PREFETCH_FIFO3_STATUS_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    QM_FPM_PREFETCH_FIFO3_STATUS_RESERVED0_FIELD_MASK,
    0,
    QM_FPM_PREFETCH_FIFO3_STATUS_RESERVED0_FIELD_WIDTH,
    QM_FPM_PREFETCH_FIFO3_STATUS_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_NORMAL_RMT_FIFO_STATUS_USED_WORDS
 ******************************************************************************/
const ru_field_rec QM_NORMAL_RMT_FIFO_STATUS_USED_WORDS_FIELD =
{
    "USED_WORDS",
#if RU_INCLUDE_DESC
    "USED_WORDS",
    "Used words",
#endif
    QM_NORMAL_RMT_FIFO_STATUS_USED_WORDS_FIELD_MASK,
    0,
    QM_NORMAL_RMT_FIFO_STATUS_USED_WORDS_FIELD_WIDTH,
    QM_NORMAL_RMT_FIFO_STATUS_USED_WORDS_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_NORMAL_RMT_FIFO_STATUS_EMPTY
 ******************************************************************************/
const ru_field_rec QM_NORMAL_RMT_FIFO_STATUS_EMPTY_FIELD =
{
    "EMPTY",
#if RU_INCLUDE_DESC
    "EMPTY",
    "Empty",
#endif
    QM_NORMAL_RMT_FIFO_STATUS_EMPTY_FIELD_MASK,
    0,
    QM_NORMAL_RMT_FIFO_STATUS_EMPTY_FIELD_WIDTH,
    QM_NORMAL_RMT_FIFO_STATUS_EMPTY_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_NORMAL_RMT_FIFO_STATUS_FULL
 ******************************************************************************/
const ru_field_rec QM_NORMAL_RMT_FIFO_STATUS_FULL_FIELD =
{
    "FULL",
#if RU_INCLUDE_DESC
    "FULL",
    "Full",
#endif
    QM_NORMAL_RMT_FIFO_STATUS_FULL_FIELD_MASK,
    0,
    QM_NORMAL_RMT_FIFO_STATUS_FULL_FIELD_WIDTH,
    QM_NORMAL_RMT_FIFO_STATUS_FULL_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_NORMAL_RMT_FIFO_STATUS_RESERVED0
 ******************************************************************************/
const ru_field_rec QM_NORMAL_RMT_FIFO_STATUS_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    QM_NORMAL_RMT_FIFO_STATUS_RESERVED0_FIELD_MASK,
    0,
    QM_NORMAL_RMT_FIFO_STATUS_RESERVED0_FIELD_WIDTH,
    QM_NORMAL_RMT_FIFO_STATUS_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_NON_DELAYED_RMT_FIFO_STATUS_USED_WORDS
 ******************************************************************************/
const ru_field_rec QM_NON_DELAYED_RMT_FIFO_STATUS_USED_WORDS_FIELD =
{
    "USED_WORDS",
#if RU_INCLUDE_DESC
    "USED_WORDS",
    "Used words",
#endif
    QM_NON_DELAYED_RMT_FIFO_STATUS_USED_WORDS_FIELD_MASK,
    0,
    QM_NON_DELAYED_RMT_FIFO_STATUS_USED_WORDS_FIELD_WIDTH,
    QM_NON_DELAYED_RMT_FIFO_STATUS_USED_WORDS_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_NON_DELAYED_RMT_FIFO_STATUS_EMPTY
 ******************************************************************************/
const ru_field_rec QM_NON_DELAYED_RMT_FIFO_STATUS_EMPTY_FIELD =
{
    "EMPTY",
#if RU_INCLUDE_DESC
    "EMPTY",
    "Empty",
#endif
    QM_NON_DELAYED_RMT_FIFO_STATUS_EMPTY_FIELD_MASK,
    0,
    QM_NON_DELAYED_RMT_FIFO_STATUS_EMPTY_FIELD_WIDTH,
    QM_NON_DELAYED_RMT_FIFO_STATUS_EMPTY_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_NON_DELAYED_RMT_FIFO_STATUS_FULL
 ******************************************************************************/
const ru_field_rec QM_NON_DELAYED_RMT_FIFO_STATUS_FULL_FIELD =
{
    "FULL",
#if RU_INCLUDE_DESC
    "FULL",
    "Full",
#endif
    QM_NON_DELAYED_RMT_FIFO_STATUS_FULL_FIELD_MASK,
    0,
    QM_NON_DELAYED_RMT_FIFO_STATUS_FULL_FIELD_WIDTH,
    QM_NON_DELAYED_RMT_FIFO_STATUS_FULL_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_NON_DELAYED_RMT_FIFO_STATUS_RESERVED0
 ******************************************************************************/
const ru_field_rec QM_NON_DELAYED_RMT_FIFO_STATUS_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    QM_NON_DELAYED_RMT_FIFO_STATUS_RESERVED0_FIELD_MASK,
    0,
    QM_NON_DELAYED_RMT_FIFO_STATUS_RESERVED0_FIELD_WIDTH,
    QM_NON_DELAYED_RMT_FIFO_STATUS_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_NON_DELAYED_OUT_FIFO_STATUS_USED_WORDS
 ******************************************************************************/
const ru_field_rec QM_NON_DELAYED_OUT_FIFO_STATUS_USED_WORDS_FIELD =
{
    "USED_WORDS",
#if RU_INCLUDE_DESC
    "USED_WORDS",
    "Used words",
#endif
    QM_NON_DELAYED_OUT_FIFO_STATUS_USED_WORDS_FIELD_MASK,
    0,
    QM_NON_DELAYED_OUT_FIFO_STATUS_USED_WORDS_FIELD_WIDTH,
    QM_NON_DELAYED_OUT_FIFO_STATUS_USED_WORDS_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_NON_DELAYED_OUT_FIFO_STATUS_EMPTY
 ******************************************************************************/
const ru_field_rec QM_NON_DELAYED_OUT_FIFO_STATUS_EMPTY_FIELD =
{
    "EMPTY",
#if RU_INCLUDE_DESC
    "EMPTY",
    "Empty",
#endif
    QM_NON_DELAYED_OUT_FIFO_STATUS_EMPTY_FIELD_MASK,
    0,
    QM_NON_DELAYED_OUT_FIFO_STATUS_EMPTY_FIELD_WIDTH,
    QM_NON_DELAYED_OUT_FIFO_STATUS_EMPTY_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_NON_DELAYED_OUT_FIFO_STATUS_FULL
 ******************************************************************************/
const ru_field_rec QM_NON_DELAYED_OUT_FIFO_STATUS_FULL_FIELD =
{
    "FULL",
#if RU_INCLUDE_DESC
    "FULL",
    "Full",
#endif
    QM_NON_DELAYED_OUT_FIFO_STATUS_FULL_FIELD_MASK,
    0,
    QM_NON_DELAYED_OUT_FIFO_STATUS_FULL_FIELD_WIDTH,
    QM_NON_DELAYED_OUT_FIFO_STATUS_FULL_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_NON_DELAYED_OUT_FIFO_STATUS_RESERVED0
 ******************************************************************************/
const ru_field_rec QM_NON_DELAYED_OUT_FIFO_STATUS_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    QM_NON_DELAYED_OUT_FIFO_STATUS_RESERVED0_FIELD_MASK,
    0,
    QM_NON_DELAYED_OUT_FIFO_STATUS_RESERVED0_FIELD_WIDTH,
    QM_NON_DELAYED_OUT_FIFO_STATUS_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_PRE_CM_FIFO_STATUS_USED_WORDS
 ******************************************************************************/
const ru_field_rec QM_PRE_CM_FIFO_STATUS_USED_WORDS_FIELD =
{
    "USED_WORDS",
#if RU_INCLUDE_DESC
    "USED_WORDS",
    "Used words",
#endif
    QM_PRE_CM_FIFO_STATUS_USED_WORDS_FIELD_MASK,
    0,
    QM_PRE_CM_FIFO_STATUS_USED_WORDS_FIELD_WIDTH,
    QM_PRE_CM_FIFO_STATUS_USED_WORDS_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_PRE_CM_FIFO_STATUS_EMPTY
 ******************************************************************************/
const ru_field_rec QM_PRE_CM_FIFO_STATUS_EMPTY_FIELD =
{
    "EMPTY",
#if RU_INCLUDE_DESC
    "EMPTY",
    "Empty",
#endif
    QM_PRE_CM_FIFO_STATUS_EMPTY_FIELD_MASK,
    0,
    QM_PRE_CM_FIFO_STATUS_EMPTY_FIELD_WIDTH,
    QM_PRE_CM_FIFO_STATUS_EMPTY_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_PRE_CM_FIFO_STATUS_FULL
 ******************************************************************************/
const ru_field_rec QM_PRE_CM_FIFO_STATUS_FULL_FIELD =
{
    "FULL",
#if RU_INCLUDE_DESC
    "FULL",
    "Full",
#endif
    QM_PRE_CM_FIFO_STATUS_FULL_FIELD_MASK,
    0,
    QM_PRE_CM_FIFO_STATUS_FULL_FIELD_WIDTH,
    QM_PRE_CM_FIFO_STATUS_FULL_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_PRE_CM_FIFO_STATUS_RESERVED0
 ******************************************************************************/
const ru_field_rec QM_PRE_CM_FIFO_STATUS_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    QM_PRE_CM_FIFO_STATUS_RESERVED0_FIELD_MASK,
    0,
    QM_PRE_CM_FIFO_STATUS_RESERVED0_FIELD_WIDTH,
    QM_PRE_CM_FIFO_STATUS_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_CM_RD_PD_FIFO_STATUS_USED_WORDS
 ******************************************************************************/
const ru_field_rec QM_CM_RD_PD_FIFO_STATUS_USED_WORDS_FIELD =
{
    "USED_WORDS",
#if RU_INCLUDE_DESC
    "USED_WORDS",
    "Used words",
#endif
    QM_CM_RD_PD_FIFO_STATUS_USED_WORDS_FIELD_MASK,
    0,
    QM_CM_RD_PD_FIFO_STATUS_USED_WORDS_FIELD_WIDTH,
    QM_CM_RD_PD_FIFO_STATUS_USED_WORDS_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_CM_RD_PD_FIFO_STATUS_EMPTY
 ******************************************************************************/
const ru_field_rec QM_CM_RD_PD_FIFO_STATUS_EMPTY_FIELD =
{
    "EMPTY",
#if RU_INCLUDE_DESC
    "EMPTY",
    "Empty",
#endif
    QM_CM_RD_PD_FIFO_STATUS_EMPTY_FIELD_MASK,
    0,
    QM_CM_RD_PD_FIFO_STATUS_EMPTY_FIELD_WIDTH,
    QM_CM_RD_PD_FIFO_STATUS_EMPTY_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_CM_RD_PD_FIFO_STATUS_FULL
 ******************************************************************************/
const ru_field_rec QM_CM_RD_PD_FIFO_STATUS_FULL_FIELD =
{
    "FULL",
#if RU_INCLUDE_DESC
    "FULL",
    "Full",
#endif
    QM_CM_RD_PD_FIFO_STATUS_FULL_FIELD_MASK,
    0,
    QM_CM_RD_PD_FIFO_STATUS_FULL_FIELD_WIDTH,
    QM_CM_RD_PD_FIFO_STATUS_FULL_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_CM_RD_PD_FIFO_STATUS_RESERVED0
 ******************************************************************************/
const ru_field_rec QM_CM_RD_PD_FIFO_STATUS_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    QM_CM_RD_PD_FIFO_STATUS_RESERVED0_FIELD_MASK,
    0,
    QM_CM_RD_PD_FIFO_STATUS_RESERVED0_FIELD_WIDTH,
    QM_CM_RD_PD_FIFO_STATUS_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_CM_WR_PD_FIFO_STATUS_USED_WORDS
 ******************************************************************************/
const ru_field_rec QM_CM_WR_PD_FIFO_STATUS_USED_WORDS_FIELD =
{
    "USED_WORDS",
#if RU_INCLUDE_DESC
    "USED_WORDS",
    "Used words",
#endif
    QM_CM_WR_PD_FIFO_STATUS_USED_WORDS_FIELD_MASK,
    0,
    QM_CM_WR_PD_FIFO_STATUS_USED_WORDS_FIELD_WIDTH,
    QM_CM_WR_PD_FIFO_STATUS_USED_WORDS_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_CM_WR_PD_FIFO_STATUS_EMPTY
 ******************************************************************************/
const ru_field_rec QM_CM_WR_PD_FIFO_STATUS_EMPTY_FIELD =
{
    "EMPTY",
#if RU_INCLUDE_DESC
    "EMPTY",
    "Empty",
#endif
    QM_CM_WR_PD_FIFO_STATUS_EMPTY_FIELD_MASK,
    0,
    QM_CM_WR_PD_FIFO_STATUS_EMPTY_FIELD_WIDTH,
    QM_CM_WR_PD_FIFO_STATUS_EMPTY_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_CM_WR_PD_FIFO_STATUS_FULL
 ******************************************************************************/
const ru_field_rec QM_CM_WR_PD_FIFO_STATUS_FULL_FIELD =
{
    "FULL",
#if RU_INCLUDE_DESC
    "FULL",
    "Full",
#endif
    QM_CM_WR_PD_FIFO_STATUS_FULL_FIELD_MASK,
    0,
    QM_CM_WR_PD_FIFO_STATUS_FULL_FIELD_WIDTH,
    QM_CM_WR_PD_FIFO_STATUS_FULL_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_CM_WR_PD_FIFO_STATUS_RESERVED0
 ******************************************************************************/
const ru_field_rec QM_CM_WR_PD_FIFO_STATUS_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    QM_CM_WR_PD_FIFO_STATUS_RESERVED0_FIELD_MASK,
    0,
    QM_CM_WR_PD_FIFO_STATUS_RESERVED0_FIELD_WIDTH,
    QM_CM_WR_PD_FIFO_STATUS_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_CM_COMMON_INPUT_FIFO_STATUS_USED_WORDS
 ******************************************************************************/
const ru_field_rec QM_CM_COMMON_INPUT_FIFO_STATUS_USED_WORDS_FIELD =
{
    "USED_WORDS",
#if RU_INCLUDE_DESC
    "USED_WORDS",
    "Used words",
#endif
    QM_CM_COMMON_INPUT_FIFO_STATUS_USED_WORDS_FIELD_MASK,
    0,
    QM_CM_COMMON_INPUT_FIFO_STATUS_USED_WORDS_FIELD_WIDTH,
    QM_CM_COMMON_INPUT_FIFO_STATUS_USED_WORDS_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_CM_COMMON_INPUT_FIFO_STATUS_EMPTY
 ******************************************************************************/
const ru_field_rec QM_CM_COMMON_INPUT_FIFO_STATUS_EMPTY_FIELD =
{
    "EMPTY",
#if RU_INCLUDE_DESC
    "EMPTY",
    "Empty",
#endif
    QM_CM_COMMON_INPUT_FIFO_STATUS_EMPTY_FIELD_MASK,
    0,
    QM_CM_COMMON_INPUT_FIFO_STATUS_EMPTY_FIELD_WIDTH,
    QM_CM_COMMON_INPUT_FIFO_STATUS_EMPTY_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_CM_COMMON_INPUT_FIFO_STATUS_FULL
 ******************************************************************************/
const ru_field_rec QM_CM_COMMON_INPUT_FIFO_STATUS_FULL_FIELD =
{
    "FULL",
#if RU_INCLUDE_DESC
    "FULL",
    "Full",
#endif
    QM_CM_COMMON_INPUT_FIFO_STATUS_FULL_FIELD_MASK,
    0,
    QM_CM_COMMON_INPUT_FIFO_STATUS_FULL_FIELD_WIDTH,
    QM_CM_COMMON_INPUT_FIFO_STATUS_FULL_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_CM_COMMON_INPUT_FIFO_STATUS_RESERVED0
 ******************************************************************************/
const ru_field_rec QM_CM_COMMON_INPUT_FIFO_STATUS_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    QM_CM_COMMON_INPUT_FIFO_STATUS_RESERVED0_FIELD_MASK,
    0,
    QM_CM_COMMON_INPUT_FIFO_STATUS_RESERVED0_FIELD_WIDTH,
    QM_CM_COMMON_INPUT_FIFO_STATUS_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_BB0_OUTPUT_FIFO_STATUS_USED_WORDS
 ******************************************************************************/
const ru_field_rec QM_BB0_OUTPUT_FIFO_STATUS_USED_WORDS_FIELD =
{
    "USED_WORDS",
#if RU_INCLUDE_DESC
    "USED_WORDS",
    "Used words",
#endif
    QM_BB0_OUTPUT_FIFO_STATUS_USED_WORDS_FIELD_MASK,
    0,
    QM_BB0_OUTPUT_FIFO_STATUS_USED_WORDS_FIELD_WIDTH,
    QM_BB0_OUTPUT_FIFO_STATUS_USED_WORDS_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_BB0_OUTPUT_FIFO_STATUS_EMPTY
 ******************************************************************************/
const ru_field_rec QM_BB0_OUTPUT_FIFO_STATUS_EMPTY_FIELD =
{
    "EMPTY",
#if RU_INCLUDE_DESC
    "EMPTY",
    "Empty",
#endif
    QM_BB0_OUTPUT_FIFO_STATUS_EMPTY_FIELD_MASK,
    0,
    QM_BB0_OUTPUT_FIFO_STATUS_EMPTY_FIELD_WIDTH,
    QM_BB0_OUTPUT_FIFO_STATUS_EMPTY_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_BB0_OUTPUT_FIFO_STATUS_FULL
 ******************************************************************************/
const ru_field_rec QM_BB0_OUTPUT_FIFO_STATUS_FULL_FIELD =
{
    "FULL",
#if RU_INCLUDE_DESC
    "FULL",
    "Full",
#endif
    QM_BB0_OUTPUT_FIFO_STATUS_FULL_FIELD_MASK,
    0,
    QM_BB0_OUTPUT_FIFO_STATUS_FULL_FIELD_WIDTH,
    QM_BB0_OUTPUT_FIFO_STATUS_FULL_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_BB0_OUTPUT_FIFO_STATUS_RESERVED0
 ******************************************************************************/
const ru_field_rec QM_BB0_OUTPUT_FIFO_STATUS_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    QM_BB0_OUTPUT_FIFO_STATUS_RESERVED0_FIELD_MASK,
    0,
    QM_BB0_OUTPUT_FIFO_STATUS_RESERVED0_FIELD_WIDTH,
    QM_BB0_OUTPUT_FIFO_STATUS_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_BB1_OUTPUT_FIFO_STATUS_USED_WORDS
 ******************************************************************************/
const ru_field_rec QM_BB1_OUTPUT_FIFO_STATUS_USED_WORDS_FIELD =
{
    "USED_WORDS",
#if RU_INCLUDE_DESC
    "USED_WORDS",
    "Used words",
#endif
    QM_BB1_OUTPUT_FIFO_STATUS_USED_WORDS_FIELD_MASK,
    0,
    QM_BB1_OUTPUT_FIFO_STATUS_USED_WORDS_FIELD_WIDTH,
    QM_BB1_OUTPUT_FIFO_STATUS_USED_WORDS_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_BB1_OUTPUT_FIFO_STATUS_EMPTY
 ******************************************************************************/
const ru_field_rec QM_BB1_OUTPUT_FIFO_STATUS_EMPTY_FIELD =
{
    "EMPTY",
#if RU_INCLUDE_DESC
    "EMPTY",
    "Empty",
#endif
    QM_BB1_OUTPUT_FIFO_STATUS_EMPTY_FIELD_MASK,
    0,
    QM_BB1_OUTPUT_FIFO_STATUS_EMPTY_FIELD_WIDTH,
    QM_BB1_OUTPUT_FIFO_STATUS_EMPTY_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_BB1_OUTPUT_FIFO_STATUS_FULL
 ******************************************************************************/
const ru_field_rec QM_BB1_OUTPUT_FIFO_STATUS_FULL_FIELD =
{
    "FULL",
#if RU_INCLUDE_DESC
    "FULL",
    "Full",
#endif
    QM_BB1_OUTPUT_FIFO_STATUS_FULL_FIELD_MASK,
    0,
    QM_BB1_OUTPUT_FIFO_STATUS_FULL_FIELD_WIDTH,
    QM_BB1_OUTPUT_FIFO_STATUS_FULL_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_BB1_OUTPUT_FIFO_STATUS_RESERVED0
 ******************************************************************************/
const ru_field_rec QM_BB1_OUTPUT_FIFO_STATUS_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    QM_BB1_OUTPUT_FIFO_STATUS_RESERVED0_FIELD_MASK,
    0,
    QM_BB1_OUTPUT_FIFO_STATUS_RESERVED0_FIELD_WIDTH,
    QM_BB1_OUTPUT_FIFO_STATUS_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_BB1_INPUT_FIFO_STATUS_USED_WORDS
 ******************************************************************************/
const ru_field_rec QM_BB1_INPUT_FIFO_STATUS_USED_WORDS_FIELD =
{
    "USED_WORDS",
#if RU_INCLUDE_DESC
    "USED_WORDS",
    "Used words",
#endif
    QM_BB1_INPUT_FIFO_STATUS_USED_WORDS_FIELD_MASK,
    0,
    QM_BB1_INPUT_FIFO_STATUS_USED_WORDS_FIELD_WIDTH,
    QM_BB1_INPUT_FIFO_STATUS_USED_WORDS_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_BB1_INPUT_FIFO_STATUS_EMPTY
 ******************************************************************************/
const ru_field_rec QM_BB1_INPUT_FIFO_STATUS_EMPTY_FIELD =
{
    "EMPTY",
#if RU_INCLUDE_DESC
    "EMPTY",
    "Empty",
#endif
    QM_BB1_INPUT_FIFO_STATUS_EMPTY_FIELD_MASK,
    0,
    QM_BB1_INPUT_FIFO_STATUS_EMPTY_FIELD_WIDTH,
    QM_BB1_INPUT_FIFO_STATUS_EMPTY_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_BB1_INPUT_FIFO_STATUS_FULL
 ******************************************************************************/
const ru_field_rec QM_BB1_INPUT_FIFO_STATUS_FULL_FIELD =
{
    "FULL",
#if RU_INCLUDE_DESC
    "FULL",
    "Full",
#endif
    QM_BB1_INPUT_FIFO_STATUS_FULL_FIELD_MASK,
    0,
    QM_BB1_INPUT_FIFO_STATUS_FULL_FIELD_WIDTH,
    QM_BB1_INPUT_FIFO_STATUS_FULL_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_BB1_INPUT_FIFO_STATUS_RESERVED0
 ******************************************************************************/
const ru_field_rec QM_BB1_INPUT_FIFO_STATUS_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    QM_BB1_INPUT_FIFO_STATUS_RESERVED0_FIELD_MASK,
    0,
    QM_BB1_INPUT_FIFO_STATUS_RESERVED0_FIELD_WIDTH,
    QM_BB1_INPUT_FIFO_STATUS_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_EGRESS_DATA_FIFO_STATUS_USED_WORDS
 ******************************************************************************/
const ru_field_rec QM_EGRESS_DATA_FIFO_STATUS_USED_WORDS_FIELD =
{
    "USED_WORDS",
#if RU_INCLUDE_DESC
    "USED_WORDS",
    "Used words",
#endif
    QM_EGRESS_DATA_FIFO_STATUS_USED_WORDS_FIELD_MASK,
    0,
    QM_EGRESS_DATA_FIFO_STATUS_USED_WORDS_FIELD_WIDTH,
    QM_EGRESS_DATA_FIFO_STATUS_USED_WORDS_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_EGRESS_DATA_FIFO_STATUS_EMPTY
 ******************************************************************************/
const ru_field_rec QM_EGRESS_DATA_FIFO_STATUS_EMPTY_FIELD =
{
    "EMPTY",
#if RU_INCLUDE_DESC
    "EMPTY",
    "Empty",
#endif
    QM_EGRESS_DATA_FIFO_STATUS_EMPTY_FIELD_MASK,
    0,
    QM_EGRESS_DATA_FIFO_STATUS_EMPTY_FIELD_WIDTH,
    QM_EGRESS_DATA_FIFO_STATUS_EMPTY_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_EGRESS_DATA_FIFO_STATUS_FULL
 ******************************************************************************/
const ru_field_rec QM_EGRESS_DATA_FIFO_STATUS_FULL_FIELD =
{
    "FULL",
#if RU_INCLUDE_DESC
    "FULL",
    "Full",
#endif
    QM_EGRESS_DATA_FIFO_STATUS_FULL_FIELD_MASK,
    0,
    QM_EGRESS_DATA_FIFO_STATUS_FULL_FIELD_WIDTH,
    QM_EGRESS_DATA_FIFO_STATUS_FULL_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_EGRESS_DATA_FIFO_STATUS_RESERVED0
 ******************************************************************************/
const ru_field_rec QM_EGRESS_DATA_FIFO_STATUS_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    QM_EGRESS_DATA_FIFO_STATUS_RESERVED0_FIELD_MASK,
    0,
    QM_EGRESS_DATA_FIFO_STATUS_RESERVED0_FIELD_WIDTH,
    QM_EGRESS_DATA_FIFO_STATUS_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_EGRESS_RR_FIFO_STATUS_USED_WORDS
 ******************************************************************************/
const ru_field_rec QM_EGRESS_RR_FIFO_STATUS_USED_WORDS_FIELD =
{
    "USED_WORDS",
#if RU_INCLUDE_DESC
    "USED_WORDS",
    "Used words",
#endif
    QM_EGRESS_RR_FIFO_STATUS_USED_WORDS_FIELD_MASK,
    0,
    QM_EGRESS_RR_FIFO_STATUS_USED_WORDS_FIELD_WIDTH,
    QM_EGRESS_RR_FIFO_STATUS_USED_WORDS_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_EGRESS_RR_FIFO_STATUS_EMPTY
 ******************************************************************************/
const ru_field_rec QM_EGRESS_RR_FIFO_STATUS_EMPTY_FIELD =
{
    "EMPTY",
#if RU_INCLUDE_DESC
    "EMPTY",
    "Empty",
#endif
    QM_EGRESS_RR_FIFO_STATUS_EMPTY_FIELD_MASK,
    0,
    QM_EGRESS_RR_FIFO_STATUS_EMPTY_FIELD_WIDTH,
    QM_EGRESS_RR_FIFO_STATUS_EMPTY_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_EGRESS_RR_FIFO_STATUS_FULL
 ******************************************************************************/
const ru_field_rec QM_EGRESS_RR_FIFO_STATUS_FULL_FIELD =
{
    "FULL",
#if RU_INCLUDE_DESC
    "FULL",
    "Full",
#endif
    QM_EGRESS_RR_FIFO_STATUS_FULL_FIELD_MASK,
    0,
    QM_EGRESS_RR_FIFO_STATUS_FULL_FIELD_WIDTH,
    QM_EGRESS_RR_FIFO_STATUS_FULL_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_EGRESS_RR_FIFO_STATUS_RESERVED0
 ******************************************************************************/
const ru_field_rec QM_EGRESS_RR_FIFO_STATUS_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    QM_EGRESS_RR_FIFO_STATUS_RESERVED0_FIELD_MASK,
    0,
    QM_EGRESS_RR_FIFO_STATUS_RESERVED0_FIELD_WIDTH,
    QM_EGRESS_RR_FIFO_STATUS_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_BB_ROUTE_OVR_OVR_EN
 ******************************************************************************/
const ru_field_rec QM_BB_ROUTE_OVR_OVR_EN_FIELD =
{
    "OVR_EN",
#if RU_INCLUDE_DESC
    "OVR_EN",
    "BB rout address decode Override enable",
#endif
    QM_BB_ROUTE_OVR_OVR_EN_FIELD_MASK,
    0,
    QM_BB_ROUTE_OVR_OVR_EN_FIELD_WIDTH,
    QM_BB_ROUTE_OVR_OVR_EN_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_BB_ROUTE_OVR_RESERVED0
 ******************************************************************************/
const ru_field_rec QM_BB_ROUTE_OVR_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    QM_BB_ROUTE_OVR_RESERVED0_FIELD_MASK,
    0,
    QM_BB_ROUTE_OVR_RESERVED0_FIELD_WIDTH,
    QM_BB_ROUTE_OVR_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_BB_ROUTE_OVR_DEST_ID
 ******************************************************************************/
const ru_field_rec QM_BB_ROUTE_OVR_DEST_ID_FIELD =
{
    "DEST_ID",
#if RU_INCLUDE_DESC
    "DEST_ID",
    "Destination ID",
#endif
    QM_BB_ROUTE_OVR_DEST_ID_FIELD_MASK,
    0,
    QM_BB_ROUTE_OVR_DEST_ID_FIELD_WIDTH,
    QM_BB_ROUTE_OVR_DEST_ID_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_BB_ROUTE_OVR_RESERVED1
 ******************************************************************************/
const ru_field_rec QM_BB_ROUTE_OVR_RESERVED1_FIELD =
{
    "RESERVED1",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    QM_BB_ROUTE_OVR_RESERVED1_FIELD_MASK,
    0,
    QM_BB_ROUTE_OVR_RESERVED1_FIELD_WIDTH,
    QM_BB_ROUTE_OVR_RESERVED1_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_BB_ROUTE_OVR_ROUTE_ADDR
 ******************************************************************************/
const ru_field_rec QM_BB_ROUTE_OVR_ROUTE_ADDR_FIELD =
{
    "ROUTE_ADDR",
#if RU_INCLUDE_DESC
    "ROUTE_ADDR",
    "Route Address",
#endif
    QM_BB_ROUTE_OVR_ROUTE_ADDR_FIELD_MASK,
    0,
    QM_BB_ROUTE_OVR_ROUTE_ADDR_FIELD_WIDTH,
    QM_BB_ROUTE_OVR_ROUTE_ADDR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_BB_ROUTE_OVR_RESERVED2
 ******************************************************************************/
const ru_field_rec QM_BB_ROUTE_OVR_RESERVED2_FIELD =
{
    "RESERVED2",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    QM_BB_ROUTE_OVR_RESERVED2_FIELD_MASK,
    0,
    QM_BB_ROUTE_OVR_RESERVED2_FIELD_WIDTH,
    QM_BB_ROUTE_OVR_RESERVED2_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_QM_INGRESS_STAT_STAT
 ******************************************************************************/
const ru_field_rec QM_QM_INGRESS_STAT_STAT_FIELD =
{
    "STAT",
#if RU_INCLUDE_DESC
    "STAT",
    "Stat",
#endif
    QM_QM_INGRESS_STAT_STAT_FIELD_MASK,
    0,
    QM_QM_INGRESS_STAT_STAT_FIELD_WIDTH,
    QM_QM_INGRESS_STAT_STAT_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_QM_EGRESS_STAT_STAT
 ******************************************************************************/
const ru_field_rec QM_QM_EGRESS_STAT_STAT_FIELD =
{
    "STAT",
#if RU_INCLUDE_DESC
    "STAT",
    "Stat",
#endif
    QM_QM_EGRESS_STAT_STAT_FIELD_MASK,
    0,
    QM_QM_EGRESS_STAT_STAT_FIELD_WIDTH,
    QM_QM_EGRESS_STAT_STAT_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_QM_CM_STAT_STAT
 ******************************************************************************/
const ru_field_rec QM_QM_CM_STAT_STAT_FIELD =
{
    "STAT",
#if RU_INCLUDE_DESC
    "STAT",
    "Stat",
#endif
    QM_QM_CM_STAT_STAT_FIELD_MASK,
    0,
    QM_QM_CM_STAT_STAT_FIELD_WIDTH,
    QM_QM_CM_STAT_STAT_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_QM_FPM_PREFETCH_STAT_STAT
 ******************************************************************************/
const ru_field_rec QM_QM_FPM_PREFETCH_STAT_STAT_FIELD =
{
    "STAT",
#if RU_INCLUDE_DESC
    "STAT",
    "Stat",
#endif
    QM_QM_FPM_PREFETCH_STAT_STAT_FIELD_MASK,
    0,
    QM_QM_FPM_PREFETCH_STAT_STAT_FIELD_WIDTH,
    QM_QM_FPM_PREFETCH_STAT_STAT_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_QM_CONNECT_ACK_COUNTER_CONNECT_ACK_COUNTER
 ******************************************************************************/
const ru_field_rec QM_QM_CONNECT_ACK_COUNTER_CONNECT_ACK_COUNTER_FIELD =
{
    "CONNECT_ACK_COUNTER",
#if RU_INCLUDE_DESC
    "CONNECT_ACK_COUNTER",
    "Pending SBPM Connect ACKs counter",
#endif
    QM_QM_CONNECT_ACK_COUNTER_CONNECT_ACK_COUNTER_FIELD_MASK,
    0,
    QM_QM_CONNECT_ACK_COUNTER_CONNECT_ACK_COUNTER_FIELD_WIDTH,
    QM_QM_CONNECT_ACK_COUNTER_CONNECT_ACK_COUNTER_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_QM_CONNECT_ACK_COUNTER_RESERVED0
 ******************************************************************************/
const ru_field_rec QM_QM_CONNECT_ACK_COUNTER_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    QM_QM_CONNECT_ACK_COUNTER_RESERVED0_FIELD_MASK,
    0,
    QM_QM_CONNECT_ACK_COUNTER_RESERVED0_FIELD_WIDTH,
    QM_QM_CONNECT_ACK_COUNTER_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_QM_DDR_WR_REPLY_COUNTER_DDR_WR_REPLY_COUNTER
 ******************************************************************************/
const ru_field_rec QM_QM_DDR_WR_REPLY_COUNTER_DDR_WR_REPLY_COUNTER_FIELD =
{
    "DDR_WR_REPLY_COUNTER",
#if RU_INCLUDE_DESC
    "DDR_WR_REPLY_COUNTER",
    "Pending DDR WR Replies counter",
#endif
    QM_QM_DDR_WR_REPLY_COUNTER_DDR_WR_REPLY_COUNTER_FIELD_MASK,
    0,
    QM_QM_DDR_WR_REPLY_COUNTER_DDR_WR_REPLY_COUNTER_FIELD_WIDTH,
    QM_QM_DDR_WR_REPLY_COUNTER_DDR_WR_REPLY_COUNTER_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_QM_DDR_WR_REPLY_COUNTER_RESERVED0
 ******************************************************************************/
const ru_field_rec QM_QM_DDR_WR_REPLY_COUNTER_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    QM_QM_DDR_WR_REPLY_COUNTER_RESERVED0_FIELD_MASK,
    0,
    QM_QM_DDR_WR_REPLY_COUNTER_RESERVED0_FIELD_WIDTH,
    QM_QM_DDR_WR_REPLY_COUNTER_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_QM_DDR_PIPE_BYTE_COUNTER_COUNTER
 ******************************************************************************/
const ru_field_rec QM_QM_DDR_PIPE_BYTE_COUNTER_COUNTER_FIELD =
{
    "COUNTER",
#if RU_INCLUDE_DESC
    "DDR_PIPE_BYTE_COUNTER",
    "Pending bytes to be copied to the DDR",
#endif
    QM_QM_DDR_PIPE_BYTE_COUNTER_COUNTER_FIELD_MASK,
    0,
    QM_QM_DDR_PIPE_BYTE_COUNTER_COUNTER_FIELD_WIDTH,
    QM_QM_DDR_PIPE_BYTE_COUNTER_COUNTER_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_QM_DDR_PIPE_BYTE_COUNTER_RESERVED0
 ******************************************************************************/
const ru_field_rec QM_QM_DDR_PIPE_BYTE_COUNTER_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    QM_QM_DDR_PIPE_BYTE_COUNTER_RESERVED0_FIELD_MASK,
    0,
    QM_QM_DDR_PIPE_BYTE_COUNTER_RESERVED0_FIELD_WIDTH,
    QM_QM_DDR_PIPE_BYTE_COUNTER_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_QM_ABS_REQUEUE_VALID_COUNTER_COUNTER
 ******************************************************************************/
const ru_field_rec QM_QM_ABS_REQUEUE_VALID_COUNTER_COUNTER_FIELD =
{
    "COUNTER",
#if RU_INCLUDE_DESC
    "COUNTER",
    "Counter",
#endif
    QM_QM_ABS_REQUEUE_VALID_COUNTER_COUNTER_FIELD_MASK,
    0,
    QM_QM_ABS_REQUEUE_VALID_COUNTER_COUNTER_FIELD_WIDTH,
    QM_QM_ABS_REQUEUE_VALID_COUNTER_COUNTER_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_QM_ABS_REQUEUE_VALID_COUNTER_RESERVED0
 ******************************************************************************/
const ru_field_rec QM_QM_ABS_REQUEUE_VALID_COUNTER_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    QM_QM_ABS_REQUEUE_VALID_COUNTER_RESERVED0_FIELD_MASK,
    0,
    QM_QM_ABS_REQUEUE_VALID_COUNTER_RESERVED0_FIELD_WIDTH,
    QM_QM_ABS_REQUEUE_VALID_COUNTER_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_QM_ILLEGAL_PD_CAPTURE_PD
 ******************************************************************************/
const ru_field_rec QM_QM_ILLEGAL_PD_CAPTURE_PD_FIELD =
{
    "PD",
#if RU_INCLUDE_DESC
    "PD",
    "PD",
#endif
    QM_QM_ILLEGAL_PD_CAPTURE_PD_FIELD_MASK,
    0,
    QM_QM_ILLEGAL_PD_CAPTURE_PD_FIELD_WIDTH,
    QM_QM_ILLEGAL_PD_CAPTURE_PD_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_QM_INGRESS_PROCESSED_PD_CAPTURE_PD
 ******************************************************************************/
const ru_field_rec QM_QM_INGRESS_PROCESSED_PD_CAPTURE_PD_FIELD =
{
    "PD",
#if RU_INCLUDE_DESC
    "PD",
    "PD",
#endif
    QM_QM_INGRESS_PROCESSED_PD_CAPTURE_PD_FIELD_MASK,
    0,
    QM_QM_INGRESS_PROCESSED_PD_CAPTURE_PD_FIELD_WIDTH,
    QM_QM_INGRESS_PROCESSED_PD_CAPTURE_PD_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_QM_CM_PROCESSED_PD_CAPTURE_PD
 ******************************************************************************/
const ru_field_rec QM_QM_CM_PROCESSED_PD_CAPTURE_PD_FIELD =
{
    "PD",
#if RU_INCLUDE_DESC
    "PD",
    "PD",
#endif
    QM_QM_CM_PROCESSED_PD_CAPTURE_PD_FIELD_MASK,
    0,
    QM_QM_CM_PROCESSED_PD_CAPTURE_PD_FIELD_WIDTH,
    QM_QM_CM_PROCESSED_PD_CAPTURE_PD_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_FPM_POOL_DROP_CNT_COUNTER
 ******************************************************************************/
const ru_field_rec QM_FPM_POOL_DROP_CNT_COUNTER_FIELD =
{
    "COUNTER",
#if RU_INCLUDE_DESC
    "COUNTER",
    "Counter",
#endif
    QM_FPM_POOL_DROP_CNT_COUNTER_FIELD_MASK,
    0,
    QM_FPM_POOL_DROP_CNT_COUNTER_FIELD_WIDTH,
    QM_FPM_POOL_DROP_CNT_COUNTER_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_FPM_GRP_DROP_CNT_COUNTER
 ******************************************************************************/
const ru_field_rec QM_FPM_GRP_DROP_CNT_COUNTER_FIELD =
{
    "COUNTER",
#if RU_INCLUDE_DESC
    "COUNTER",
    "Counter",
#endif
    QM_FPM_GRP_DROP_CNT_COUNTER_FIELD_MASK,
    0,
    QM_FPM_GRP_DROP_CNT_COUNTER_FIELD_WIDTH,
    QM_FPM_GRP_DROP_CNT_COUNTER_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_FPM_BUFFER_RES_DROP_CNT_COUNTER
 ******************************************************************************/
const ru_field_rec QM_FPM_BUFFER_RES_DROP_CNT_COUNTER_FIELD =
{
    "COUNTER",
#if RU_INCLUDE_DESC
    "COUNTER",
    "Counter",
#endif
    QM_FPM_BUFFER_RES_DROP_CNT_COUNTER_FIELD_MASK,
    0,
    QM_FPM_BUFFER_RES_DROP_CNT_COUNTER_FIELD_WIDTH,
    QM_FPM_BUFFER_RES_DROP_CNT_COUNTER_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_PSRAM_EGRESS_CONG_DRP_CNT_COUNTER
 ******************************************************************************/
const ru_field_rec QM_PSRAM_EGRESS_CONG_DRP_CNT_COUNTER_FIELD =
{
    "COUNTER",
#if RU_INCLUDE_DESC
    "COUNTER",
    "Counter",
#endif
    QM_PSRAM_EGRESS_CONG_DRP_CNT_COUNTER_FIELD_MASK,
    0,
    QM_PSRAM_EGRESS_CONG_DRP_CNT_COUNTER_FIELD_WIDTH,
    QM_PSRAM_EGRESS_CONG_DRP_CNT_COUNTER_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: QM_BACKPRESSURE_STATUS
 ******************************************************************************/
const ru_field_rec QM_BACKPRESSURE_STATUS_FIELD =
{
    "STATUS",
#if RU_INCLUDE_DESC
    "STATUS",
    "STATUS:"
    ""
    "Back pressure sets the relevant register per bp reason. SW should write-clear in order to unset:"
    ""
    "0x1 - fpm exclusive threshold"
    "0x2 - fpm prefetch occupancy"
    "0x4 - DDR byte on the fly byte count threshold is exceeded"
    "0x8 - PD count in copy machine is exceeded"
    ""
    "Any permutation of the above may occur. especially if the value isnt cleared every time."
    ""
    ""
    "A write of 0xFFFF_FFFF in order at reset this indication."
    ""
    "",
#endif
    QM_BACKPRESSURE_STATUS_FIELD_MASK,
    0,
    QM_BACKPRESSURE_STATUS_FIELD_WIDTH,
    QM_BACKPRESSURE_STATUS_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_BACKPRESSURE_R1
 ******************************************************************************/
const ru_field_rec QM_BACKPRESSURE_R1_FIELD =
{
    "R1",
#if RU_INCLUDE_DESC
    "R1",
    "reserved",
#endif
    QM_BACKPRESSURE_R1_FIELD_MASK,
    0,
    QM_BACKPRESSURE_R1_FIELD_WIDTH,
    QM_BACKPRESSURE_R1_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG2_BBHTX_FIFO_ADDR_ADDR
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG2_BBHTX_FIFO_ADDR_ADDR_FIELD =
{
    "ADDR",
#if RU_INCLUDE_DESC
    "ADDR",
    "ADDR",
#endif
    QM_GLOBAL_CFG2_BBHTX_FIFO_ADDR_ADDR_FIELD_MASK,
    0,
    QM_GLOBAL_CFG2_BBHTX_FIFO_ADDR_ADDR_FIELD_WIDTH,
    QM_GLOBAL_CFG2_BBHTX_FIFO_ADDR_ADDR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG2_BBHTX_FIFO_ADDR_BBHTX_REQ_OTF
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG2_BBHTX_FIFO_ADDR_BBHTX_REQ_OTF_FIELD =
{
    "BBHTX_REQ_OTF",
#if RU_INCLUDE_DESC
    "BBHTX_REQ_OTF",
    "BBHTX_REQ_OTF",
#endif
    QM_GLOBAL_CFG2_BBHTX_FIFO_ADDR_BBHTX_REQ_OTF_FIELD_MASK,
    0,
    QM_GLOBAL_CFG2_BBHTX_FIFO_ADDR_BBHTX_REQ_OTF_FIELD_WIDTH,
    QM_GLOBAL_CFG2_BBHTX_FIFO_ADDR_BBHTX_REQ_OTF_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_GLOBAL_CFG2_BBHTX_FIFO_ADDR_RESERVED0
 ******************************************************************************/
const ru_field_rec QM_GLOBAL_CFG2_BBHTX_FIFO_ADDR_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    QM_GLOBAL_CFG2_BBHTX_FIFO_ADDR_RESERVED0_FIELD_MASK,
    0,
    QM_GLOBAL_CFG2_BBHTX_FIFO_ADDR_RESERVED0_FIELD_WIDTH,
    QM_GLOBAL_CFG2_BBHTX_FIFO_ADDR_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: QM_DATA_DATA
 ******************************************************************************/
const ru_field_rec QM_DATA_DATA_FIELD =
{
    "DATA",
#if RU_INCLUDE_DESC
    "DATA",
    "DATA",
#endif
    QM_DATA_DATA_FIELD_MASK,
    0,
    QM_DATA_DATA_FIELD_WIDTH,
    QM_DATA_DATA_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

#endif /* RU_INCLUDE_FIELD_DB */

/******************************************************************************
 * Register: QM_GLOBAL_CFG_QM_ENABLE_CTRL
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_GLOBAL_CFG_QM_ENABLE_CTRL_FIELDS[] =
{
    &QM_GLOBAL_CFG_QM_ENABLE_CTRL_FPM_PREFETCH_ENABLE_FIELD,
    &QM_GLOBAL_CFG_QM_ENABLE_CTRL_REORDER_CREDIT_ENABLE_FIELD,
    &QM_GLOBAL_CFG_QM_ENABLE_CTRL_DQM_POP_ENABLE_FIELD,
    &QM_GLOBAL_CFG_QM_ENABLE_CTRL_RESERVED0_FIELD,
    &QM_GLOBAL_CFG_QM_ENABLE_CTRL_RMT_FIXED_ARB_ENABLE_FIELD,
    &QM_GLOBAL_CFG_QM_ENABLE_CTRL_DQM_PUSH_FIXED_ARB_ENABLE_FIELD,
    &QM_GLOBAL_CFG_QM_ENABLE_CTRL_RESERVED1_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_GLOBAL_CFG_QM_ENABLE_CTRL_REG = 
{
    "GLOBAL_CFG_QM_ENABLE_CTRL",
#if RU_INCLUDE_DESC
    "QM_ENABLE_CTRL Register",
    "QM Enable register",
#endif
    QM_GLOBAL_CFG_QM_ENABLE_CTRL_REG_OFFSET,
    0,
    0,
    0,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    7,
    QM_GLOBAL_CFG_QM_ENABLE_CTRL_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_GLOBAL_CFG_QM_SW_RST_CTRL
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_GLOBAL_CFG_QM_SW_RST_CTRL_FIELDS[] =
{
    &QM_GLOBAL_CFG_QM_SW_RST_CTRL_FPM_PREFETCH0_SW_RST_FIELD,
    &QM_GLOBAL_CFG_QM_SW_RST_CTRL_FPM_PREFETCH1_SW_RST_FIELD,
    &QM_GLOBAL_CFG_QM_SW_RST_CTRL_FPM_PREFETCH2_SW_RST_FIELD,
    &QM_GLOBAL_CFG_QM_SW_RST_CTRL_FPM_PREFETCH3_SW_RST_FIELD,
    &QM_GLOBAL_CFG_QM_SW_RST_CTRL_NORMAL_RMT_SW_RST_FIELD,
    &QM_GLOBAL_CFG_QM_SW_RST_CTRL_NON_DELAYED_RMT_SW_RST_FIELD,
    &QM_GLOBAL_CFG_QM_SW_RST_CTRL_PRE_CM_FIFO_SW_RST_FIELD,
    &QM_GLOBAL_CFG_QM_SW_RST_CTRL_CM_RD_PD_FIFO_SW_RST_FIELD,
    &QM_GLOBAL_CFG_QM_SW_RST_CTRL_CM_WR_PD_FIFO_SW_RST_FIELD,
    &QM_GLOBAL_CFG_QM_SW_RST_CTRL_BB0_OUTPUT_FIFO_SW_RST_FIELD,
    &QM_GLOBAL_CFG_QM_SW_RST_CTRL_BB1_OUTPUT_FIFO_SW_RST_FIELD,
    &QM_GLOBAL_CFG_QM_SW_RST_CTRL_BB1_INPUT_FIFO_SW_RST_FIELD,
    &QM_GLOBAL_CFG_QM_SW_RST_CTRL_TM_FIFO_PTR_SW_RST_FIELD,
    &QM_GLOBAL_CFG_QM_SW_RST_CTRL_NON_DELAYED_OUT_FIFO_SW_RST_FIELD,
    &QM_GLOBAL_CFG_QM_SW_RST_CTRL_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_GLOBAL_CFG_QM_SW_RST_CTRL_REG = 
{
    "GLOBAL_CFG_QM_SW_RST_CTRL",
#if RU_INCLUDE_DESC
    "QM_SW_RST_CTRL Register",
    "QM soft reset register",
#endif
    QM_GLOBAL_CFG_QM_SW_RST_CTRL_REG_OFFSET,
    0,
    0,
    1,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    15,
    QM_GLOBAL_CFG_QM_SW_RST_CTRL_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_GLOBAL_CFG_QM_GENERAL_CTRL
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_GLOBAL_CFG_QM_GENERAL_CTRL_FIELDS[] =
{
    &QM_GLOBAL_CFG_QM_GENERAL_CTRL_DROP_CNT_PKTS_READ_CLEAR_ENABLE_FIELD,
    &QM_GLOBAL_CFG_QM_GENERAL_CTRL_DROP_CNT_BYTES_READ_CLEAR_ENABLE_FIELD,
    &QM_GLOBAL_CFG_QM_GENERAL_CTRL_DROP_CNT_MAX_OCCUPANCY_PKTS_SELECT_FIELD,
    &QM_GLOBAL_CFG_QM_GENERAL_CTRL_DROP_CNT_MAX_OCCUPANCY_BYTES_SELECT_FIELD,
    &QM_GLOBAL_CFG_QM_GENERAL_CTRL_FREE_WITH_CONTEXT_LAST_SEARCH_FIELD,
    &QM_GLOBAL_CFG_QM_GENERAL_CTRL_WRED_DISABLE_FIELD,
    &QM_GLOBAL_CFG_QM_GENERAL_CTRL_DDR_PD_CONGESTION_DISABLE_FIELD,
    &QM_GLOBAL_CFG_QM_GENERAL_CTRL_DDR_BYTE_CONGESTION_DISABLE_FIELD,
    &QM_GLOBAL_CFG_QM_GENERAL_CTRL_DDR_OCCUPANCY_DISABLE_FIELD,
    &QM_GLOBAL_CFG_QM_GENERAL_CTRL_DDR_FPM_CONGESTION_DISABLE_FIELD,
    &QM_GLOBAL_CFG_QM_GENERAL_CTRL_FPM_UG_DISABLE_FIELD,
    &QM_GLOBAL_CFG_QM_GENERAL_CTRL_QUEUE_OCCUPANCY_DDR_COPY_DECISION_DISABLE_FIELD,
    &QM_GLOBAL_CFG_QM_GENERAL_CTRL_PSRAM_OCCUPANCY_DDR_COPY_DECISION_DISABLE_FIELD,
    &QM_GLOBAL_CFG_QM_GENERAL_CTRL_DONT_SEND_MC_BIT_TO_BBH_FIELD,
    &QM_GLOBAL_CFG_QM_GENERAL_CTRL_CLOSE_AGGREGATION_ON_TIMEOUT_DISABLE_FIELD,
    &QM_GLOBAL_CFG_QM_GENERAL_CTRL_FPM_CONGESTION_BUF_RELEASE_MECHANISM_DISABLE_FIELD,
    &QM_GLOBAL_CFG_QM_GENERAL_CTRL_FPM_BUFFER_GLOBAL_RES_ENABLE_FIELD,
    &QM_GLOBAL_CFG_QM_GENERAL_CTRL_QM_PRESERVE_PD_WITH_FPM_FIELD,
    &QM_GLOBAL_CFG_QM_GENERAL_CTRL_QM_RESIDUE_PER_QUEUE_FIELD,
    &QM_GLOBAL_CFG_QM_GENERAL_CTRL_GHOST_RPT_UPDATE_AFTER_CLOSE_AGG_EN_FIELD,
    &QM_GLOBAL_CFG_QM_GENERAL_CTRL_FPM_UG_FLOW_CTRL_DISABLE_FIELD,
    &QM_GLOBAL_CFG_QM_GENERAL_CTRL_DDR_WRITE_MULTI_SLAVE_EN_FIELD,
    &QM_GLOBAL_CFG_QM_GENERAL_CTRL_DDR_PD_CONGESTION_AGG_PRIORITY_FIELD,
    &QM_GLOBAL_CFG_QM_GENERAL_CTRL_PSRAM_OCCUPANCY_DROP_DISABLE_FIELD,
    &QM_GLOBAL_CFG_QM_GENERAL_CTRL_QM_DDR_WRITE_ALIGNMENT_FIELD,
    &QM_GLOBAL_CFG_QM_GENERAL_CTRL_EXCLUSIVE_DONT_DROP_FIELD,
    &QM_GLOBAL_CFG_QM_GENERAL_CTRL_DQMOL_JIRA_973_FIX_ENABLE_FIELD,
    &QM_GLOBAL_CFG_QM_GENERAL_CTRL_GPON_DBR_CEIL_FIELD,
    &QM_GLOBAL_CFG_QM_GENERAL_CTRL_DROP_CNT_WRED_DROPS_FIELD,
    &QM_GLOBAL_CFG_QM_GENERAL_CTRL_SAME_SEC_LVL_BIT_AGG_EN_FIELD,
    &QM_GLOBAL_CFG_QM_GENERAL_CTRL_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_GLOBAL_CFG_QM_GENERAL_CTRL_REG = 
{
    "GLOBAL_CFG_QM_GENERAL_CTRL",
#if RU_INCLUDE_DESC
    "QM_GENERAL_CTRL Register",
    "QM Enable register",
#endif
    QM_GLOBAL_CFG_QM_GENERAL_CTRL_REG_OFFSET,
    0,
    0,
    2,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    31,
    QM_GLOBAL_CFG_QM_GENERAL_CTRL_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_GLOBAL_CFG_FPM_CONTROL
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_GLOBAL_CFG_FPM_CONTROL_FIELDS[] =
{
    &QM_GLOBAL_CFG_FPM_CONTROL_FPM_POOL_BP_ENABLE_FIELD,
    &QM_GLOBAL_CFG_FPM_CONTROL_FPM_CONGESTION_BP_ENABLE_FIELD,
    &QM_GLOBAL_CFG_FPM_CONTROL_FPM_FORCE_BP_LVL_FIELD,
    &QM_GLOBAL_CFG_FPM_CONTROL_FPM_PREFETCH_GRANULARITY_FIELD,
    &QM_GLOBAL_CFG_FPM_CONTROL_FPM_PREFETCH_MIN_POOL_SIZE_FIELD,
    &QM_GLOBAL_CFG_FPM_CONTROL_RESERVED0_FIELD,
    &QM_GLOBAL_CFG_FPM_CONTROL_FPM_PREFETCH_PENDING_REQ_LIMIT_FIELD,
    &QM_GLOBAL_CFG_FPM_CONTROL_RESERVED1_FIELD,
    &QM_GLOBAL_CFG_FPM_CONTROL_FPM_OVERRIDE_BB_ID_EN_FIELD,
    &QM_GLOBAL_CFG_FPM_CONTROL_FPM_OVERRIDE_BB_ID_VALUE_FIELD,
    &QM_GLOBAL_CFG_FPM_CONTROL_RESERVED2_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_GLOBAL_CFG_FPM_CONTROL_REG = 
{
    "GLOBAL_CFG_FPM_CONTROL",
#if RU_INCLUDE_DESC
    "FPM_CONTROL Register",
    "FPM Control Register"
    ""
    "Additonal FPM registers can be found below - Enhancement registers",
#endif
    QM_GLOBAL_CFG_FPM_CONTROL_REG_OFFSET,
    0,
    0,
    3,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    11,
    QM_GLOBAL_CFG_FPM_CONTROL_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_GLOBAL_CFG_DDR_BYTE_CONGESTION_CONTROL
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_GLOBAL_CFG_DDR_BYTE_CONGESTION_CONTROL_FIELDS[] =
{
    &QM_GLOBAL_CFG_DDR_BYTE_CONGESTION_CONTROL_DDR_BYTE_CONGESTION_DROP_ENABLE_FIELD,
    &QM_GLOBAL_CFG_DDR_BYTE_CONGESTION_CONTROL_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_GLOBAL_CFG_DDR_BYTE_CONGESTION_CONTROL_REG = 
{
    "GLOBAL_CFG_DDR_BYTE_CONGESTION_CONTROL",
#if RU_INCLUDE_DESC
    "DDR_BYTE_CONGESTION_CONTROL Register",
    "DDR Byte Congestion Control Register",
#endif
    QM_GLOBAL_CFG_DDR_BYTE_CONGESTION_CONTROL_REG_OFFSET,
    0,
    0,
    4,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    2,
    QM_GLOBAL_CFG_DDR_BYTE_CONGESTION_CONTROL_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_GLOBAL_CFG_DDR_BYTE_CONGESTION_LOWER_THR
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_GLOBAL_CFG_DDR_BYTE_CONGESTION_LOWER_THR_FIELDS[] =
{
    &QM_GLOBAL_CFG_DDR_BYTE_CONGESTION_LOWER_THR_DDR_BYTES_LOWER_THR_FIELD,
    &QM_GLOBAL_CFG_DDR_BYTE_CONGESTION_LOWER_THR_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_GLOBAL_CFG_DDR_BYTE_CONGESTION_LOWER_THR_REG = 
{
    "GLOBAL_CFG_DDR_BYTE_CONGESTION_LOWER_THR",
#if RU_INCLUDE_DESC
    "DDR_BYTE_CONGESTION_LOWER_THR Register",
    "DDR Byte Congestion Lower Threshold",
#endif
    QM_GLOBAL_CFG_DDR_BYTE_CONGESTION_LOWER_THR_REG_OFFSET,
    0,
    0,
    5,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    2,
    QM_GLOBAL_CFG_DDR_BYTE_CONGESTION_LOWER_THR_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_GLOBAL_CFG_DDR_BYTE_CONGESTION_MID_THR
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_GLOBAL_CFG_DDR_BYTE_CONGESTION_MID_THR_FIELDS[] =
{
    &QM_GLOBAL_CFG_DDR_BYTE_CONGESTION_MID_THR_DDR_BYTES_MID_THR_FIELD,
    &QM_GLOBAL_CFG_DDR_BYTE_CONGESTION_MID_THR_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_GLOBAL_CFG_DDR_BYTE_CONGESTION_MID_THR_REG = 
{
    "GLOBAL_CFG_DDR_BYTE_CONGESTION_MID_THR",
#if RU_INCLUDE_DESC
    "DDR_BYTE_CONGESTION_MID_THR Register",
    "DDR Byte Congestion Middle Threshold",
#endif
    QM_GLOBAL_CFG_DDR_BYTE_CONGESTION_MID_THR_REG_OFFSET,
    0,
    0,
    6,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    2,
    QM_GLOBAL_CFG_DDR_BYTE_CONGESTION_MID_THR_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_GLOBAL_CFG_DDR_BYTE_CONGESTION_HIGHER_THR
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_GLOBAL_CFG_DDR_BYTE_CONGESTION_HIGHER_THR_FIELDS[] =
{
    &QM_GLOBAL_CFG_DDR_BYTE_CONGESTION_HIGHER_THR_DDR_BYTES_HIGHER_THR_FIELD,
    &QM_GLOBAL_CFG_DDR_BYTE_CONGESTION_HIGHER_THR_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_GLOBAL_CFG_DDR_BYTE_CONGESTION_HIGHER_THR_REG = 
{
    "GLOBAL_CFG_DDR_BYTE_CONGESTION_HIGHER_THR",
#if RU_INCLUDE_DESC
    "DDR_BYTE_CONGESTION_HIGHER_THR Register",
    "DDR Byte Congestion Higher Threshold",
#endif
    QM_GLOBAL_CFG_DDR_BYTE_CONGESTION_HIGHER_THR_REG_OFFSET,
    0,
    0,
    7,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    2,
    QM_GLOBAL_CFG_DDR_BYTE_CONGESTION_HIGHER_THR_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_GLOBAL_CFG_DDR_PD_CONGESTION_CONTROL
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_GLOBAL_CFG_DDR_PD_CONGESTION_CONTROL_FIELDS[] =
{
    &QM_GLOBAL_CFG_DDR_PD_CONGESTION_CONTROL_DDR_PD_CONGESTION_DROP_ENABLE_FIELD,
    &QM_GLOBAL_CFG_DDR_PD_CONGESTION_CONTROL_RESERVED0_FIELD,
    &QM_GLOBAL_CFG_DDR_PD_CONGESTION_CONTROL_DDR_PIPE_LOWER_THR_FIELD,
    &QM_GLOBAL_CFG_DDR_PD_CONGESTION_CONTROL_DDR_PIPE_HIGHER_THR_FIELD,
    &QM_GLOBAL_CFG_DDR_PD_CONGESTION_CONTROL_RESERVED1_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_GLOBAL_CFG_DDR_PD_CONGESTION_CONTROL_REG = 
{
    "GLOBAL_CFG_DDR_PD_CONGESTION_CONTROL",
#if RU_INCLUDE_DESC
    "DDR_PD_CONGESTION_CONTROL Register",
    "DDR PD Congestion Control Register",
#endif
    QM_GLOBAL_CFG_DDR_PD_CONGESTION_CONTROL_REG_OFFSET,
    0,
    0,
    8,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    5,
    QM_GLOBAL_CFG_DDR_PD_CONGESTION_CONTROL_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_GLOBAL_CFG_QM_PD_CONGESTION_CONTROL
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_GLOBAL_CFG_QM_PD_CONGESTION_CONTROL_FIELDS[] =
{
    &QM_GLOBAL_CFG_QM_PD_CONGESTION_CONTROL_TOTAL_PD_THR_FIELD,
    &QM_GLOBAL_CFG_QM_PD_CONGESTION_CONTROL_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_GLOBAL_CFG_QM_PD_CONGESTION_CONTROL_REG = 
{
    "GLOBAL_CFG_QM_PD_CONGESTION_CONTROL",
#if RU_INCLUDE_DESC
    "QM_PD_CONGESTION_CONTROL Register",
    "QM PD Congestion Control Register",
#endif
    QM_GLOBAL_CFG_QM_PD_CONGESTION_CONTROL_REG_OFFSET,
    0,
    0,
    9,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    2,
    QM_GLOBAL_CFG_QM_PD_CONGESTION_CONTROL_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_GLOBAL_CFG_ABS_DROP_QUEUE
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_GLOBAL_CFG_ABS_DROP_QUEUE_FIELDS[] =
{
    &QM_GLOBAL_CFG_ABS_DROP_QUEUE_ABS_DROP_QUEUE_FIELD,
    &QM_GLOBAL_CFG_ABS_DROP_QUEUE_RESERVED0_FIELD,
    &QM_GLOBAL_CFG_ABS_DROP_QUEUE_ABS_DROP_QUEUE_EN_FIELD,
    &QM_GLOBAL_CFG_ABS_DROP_QUEUE_RESERVED1_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_GLOBAL_CFG_ABS_DROP_QUEUE_REG = 
{
    "GLOBAL_CFG_ABS_DROP_QUEUE",
#if RU_INCLUDE_DESC
    "ABS_DROP_QUEUE Register",
    "Absolute Adress drop queue",
#endif
    QM_GLOBAL_CFG_ABS_DROP_QUEUE_REG_OFFSET,
    0,
    0,
    10,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    4,
    QM_GLOBAL_CFG_ABS_DROP_QUEUE_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_GLOBAL_CFG_AGGREGATION_CTRL
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_GLOBAL_CFG_AGGREGATION_CTRL_FIELDS[] =
{
    &QM_GLOBAL_CFG_AGGREGATION_CTRL_MAX_AGG_BYTES_FIELD,
    &QM_GLOBAL_CFG_AGGREGATION_CTRL_MAX_AGG_PKTS_FIELD,
    &QM_GLOBAL_CFG_AGGREGATION_CTRL_AGG_OVR_512B_EN_FIELD,
    &QM_GLOBAL_CFG_AGGREGATION_CTRL_MAX_AGG_PKT_SIZE_FIELD,
    &QM_GLOBAL_CFG_AGGREGATION_CTRL_MIN_AGG_PKT_SIZE_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_GLOBAL_CFG_AGGREGATION_CTRL_REG = 
{
    "GLOBAL_CFG_AGGREGATION_CTRL",
#if RU_INCLUDE_DESC
    "AGGREGATION_CTRL Register",
    "Aggregation Control register",
#endif
    QM_GLOBAL_CFG_AGGREGATION_CTRL_REG_OFFSET,
    0,
    0,
    11,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    5,
    QM_GLOBAL_CFG_AGGREGATION_CTRL_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_GLOBAL_CFG_AGGREGATION_CTRL2
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_GLOBAL_CFG_AGGREGATION_CTRL2_FIELDS[] =
{
    &QM_GLOBAL_CFG_AGGREGATION_CTRL2_AGG_POOL_SEL_EN_FIELD,
    &QM_GLOBAL_CFG_AGGREGATION_CTRL2_RESERVED0_FIELD,
    &QM_GLOBAL_CFG_AGGREGATION_CTRL2_AGG_POOL_SEL_FIELD,
    &QM_GLOBAL_CFG_AGGREGATION_CTRL2_RESERVED1_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_GLOBAL_CFG_AGGREGATION_CTRL2_REG = 
{
    "GLOBAL_CFG_AGGREGATION_CTRL2",
#if RU_INCLUDE_DESC
    "AGGREGATION_CTRL_2 Register",
    "Aggregation Control 2nd register",
#endif
    QM_GLOBAL_CFG_AGGREGATION_CTRL2_REG_OFFSET,
    0,
    0,
    12,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    4,
    QM_GLOBAL_CFG_AGGREGATION_CTRL2_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_GLOBAL_CFG_FPM_BASE_ADDR
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_GLOBAL_CFG_FPM_BASE_ADDR_FIELDS[] =
{
    &QM_GLOBAL_CFG_FPM_BASE_ADDR_FPM_BASE_ADDR_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_GLOBAL_CFG_FPM_BASE_ADDR_REG = 
{
    "GLOBAL_CFG_FPM_BASE_ADDR",
#if RU_INCLUDE_DESC
    "FPM_BASE_ADDR Register",
    "FPM Base Address",
#endif
    QM_GLOBAL_CFG_FPM_BASE_ADDR_REG_OFFSET,
    0,
    0,
    13,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    QM_GLOBAL_CFG_FPM_BASE_ADDR_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_GLOBAL_CFG_FPM_COHERENT_BASE_ADDR
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_GLOBAL_CFG_FPM_COHERENT_BASE_ADDR_FIELDS[] =
{
    &QM_GLOBAL_CFG_FPM_COHERENT_BASE_ADDR_FPM_BASE_ADDR_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_GLOBAL_CFG_FPM_COHERENT_BASE_ADDR_REG = 
{
    "GLOBAL_CFG_FPM_COHERENT_BASE_ADDR",
#if RU_INCLUDE_DESC
    "FPM_COHERENT_BASE_ADDR Register",
    "FPM Base Address for PDs that have the coherent bit set",
#endif
    QM_GLOBAL_CFG_FPM_COHERENT_BASE_ADDR_REG_OFFSET,
    0,
    0,
    14,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    QM_GLOBAL_CFG_FPM_COHERENT_BASE_ADDR_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_GLOBAL_CFG_DDR_SOP_OFFSET
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_GLOBAL_CFG_DDR_SOP_OFFSET_FIELDS[] =
{
    &QM_GLOBAL_CFG_DDR_SOP_OFFSET_DDR_SOP_OFFSET0_FIELD,
    &QM_GLOBAL_CFG_DDR_SOP_OFFSET_RESERVED0_FIELD,
    &QM_GLOBAL_CFG_DDR_SOP_OFFSET_DDR_SOP_OFFSET1_FIELD,
    &QM_GLOBAL_CFG_DDR_SOP_OFFSET_RESERVED1_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_GLOBAL_CFG_DDR_SOP_OFFSET_REG = 
{
    "GLOBAL_CFG_DDR_SOP_OFFSET",
#if RU_INCLUDE_DESC
    "DDR_SOP_OFFSET Register",
    "DDR SOP Offset options",
#endif
    QM_GLOBAL_CFG_DDR_SOP_OFFSET_REG_OFFSET,
    0,
    0,
    15,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    4,
    QM_GLOBAL_CFG_DDR_SOP_OFFSET_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_GLOBAL_CFG_EPON_OVERHEAD_CTRL
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_GLOBAL_CFG_EPON_OVERHEAD_CTRL_FIELDS[] =
{
    &QM_GLOBAL_CFG_EPON_OVERHEAD_CTRL_EPON_LINE_RATE_FIELD,
    &QM_GLOBAL_CFG_EPON_OVERHEAD_CTRL_EPON_CRC_ADD_DISABLE_FIELD,
    &QM_GLOBAL_CFG_EPON_OVERHEAD_CTRL_MAC_FLOW_OVERWRITE_CRC_EN_FIELD,
    &QM_GLOBAL_CFG_EPON_OVERHEAD_CTRL_MAC_FLOW_OVERWRITE_CRC_FIELD,
    &QM_GLOBAL_CFG_EPON_OVERHEAD_CTRL_RESERVED0_FIELD,
    &QM_GLOBAL_CFG_EPON_OVERHEAD_CTRL_FEC_IPG_LENGTH_FIELD,
    &QM_GLOBAL_CFG_EPON_OVERHEAD_CTRL_RESERVED1_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_GLOBAL_CFG_EPON_OVERHEAD_CTRL_REG = 
{
    "GLOBAL_CFG_EPON_OVERHEAD_CTRL",
#if RU_INCLUDE_DESC
    "EPON_OVERHEAD_CTRL Register",
    "EPON Ghost reporting configuration",
#endif
    QM_GLOBAL_CFG_EPON_OVERHEAD_CTRL_REG_OFFSET,
    0,
    0,
    16,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    7,
    QM_GLOBAL_CFG_EPON_OVERHEAD_CTRL_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_GLOBAL_CFG_DQM_FULL
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_GLOBAL_CFG_DQM_FULL_FIELDS[] =
{
    &QM_GLOBAL_CFG_DQM_FULL_Q_FULL_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_GLOBAL_CFG_DQM_FULL_REG = 
{
    "GLOBAL_CFG_DQM_FULL",
#if RU_INCLUDE_DESC
    "DQM_FULL %i Register",
    "Queue Full indication"
    "Each register includes a batch of 32 queues non-empty indication."
    "9 Batches are need for 288 queues."
    "First Batch is for queues 31-0 and so on until the last batch representing queues 287-256.",
#endif
    QM_GLOBAL_CFG_DQM_FULL_REG_OFFSET,
    QM_GLOBAL_CFG_DQM_FULL_REG_RAM_CNT,
    4,
    17,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    QM_GLOBAL_CFG_DQM_FULL_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_GLOBAL_CFG_DQM_NOT_EMPTY
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_GLOBAL_CFG_DQM_NOT_EMPTY_FIELDS[] =
{
    &QM_GLOBAL_CFG_DQM_NOT_EMPTY_Q_NOT_EMPTY_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_GLOBAL_CFG_DQM_NOT_EMPTY_REG = 
{
    "GLOBAL_CFG_DQM_NOT_EMPTY",
#if RU_INCLUDE_DESC
    "DQM_NOT_EMPTY %i Register",
    "Queue Not Empty indication"
    "Each register includes a batch of 32 queues non-empty indication."
    "9 Batches are need for 288 queues."
    "First Batch is for queues 31-0 and so on until the last batch representing queues 287-256.",
#endif
    QM_GLOBAL_CFG_DQM_NOT_EMPTY_REG_OFFSET,
    QM_GLOBAL_CFG_DQM_NOT_EMPTY_REG_RAM_CNT,
    4,
    18,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    QM_GLOBAL_CFG_DQM_NOT_EMPTY_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_GLOBAL_CFG_DQM_POP_READY
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_GLOBAL_CFG_DQM_POP_READY_FIELDS[] =
{
    &QM_GLOBAL_CFG_DQM_POP_READY_POP_READY_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_GLOBAL_CFG_DQM_POP_READY_REG = 
{
    "GLOBAL_CFG_DQM_POP_READY",
#if RU_INCLUDE_DESC
    "DQM_POP_READY %i Register",
    "Queue pop ready indication (Some queues may be non-empty, but due to PD offload they are not immediatly ready to be popped. Pop can be issued, but in this case the result could be delayed)."
    "Each register includes a batch of 32 queues non-empty indication."
    "9 Batches are need for 288 queues."
    "First Batch is for queues 31-0 and so on until the last batch representing queues 287-256.",
#endif
    QM_GLOBAL_CFG_DQM_POP_READY_REG_OFFSET,
    QM_GLOBAL_CFG_DQM_POP_READY_REG_RAM_CNT,
    4,
    19,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    QM_GLOBAL_CFG_DQM_POP_READY_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_GLOBAL_CFG_AGGREGATION_CONTEXT_VALID
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_GLOBAL_CFG_AGGREGATION_CONTEXT_VALID_FIELDS[] =
{
    &QM_GLOBAL_CFG_AGGREGATION_CONTEXT_VALID_CONTEXT_VALID_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_GLOBAL_CFG_AGGREGATION_CONTEXT_VALID_REG = 
{
    "GLOBAL_CFG_AGGREGATION_CONTEXT_VALID",
#if RU_INCLUDE_DESC
    "AGGREGATION_CONTEXT_VALID %i Register",
    "Aggregation context valid."
    "This indicates that the queue is in the process of packet aggregation."
    "Each register includes a batch of 32 queues aggregation valid indication."
    "9 Batches are need for 288 queues."
    "First Batch is for queues 31-0 and so on until the last batch representing queues 287-256.",
#endif
    QM_GLOBAL_CFG_AGGREGATION_CONTEXT_VALID_REG_OFFSET,
    QM_GLOBAL_CFG_AGGREGATION_CONTEXT_VALID_REG_RAM_CNT,
    4,
    20,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    QM_GLOBAL_CFG_AGGREGATION_CONTEXT_VALID_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_GLOBAL_CFG_QM_AGGREGATION_TIMER_CTRL
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_GLOBAL_CFG_QM_AGGREGATION_TIMER_CTRL_FIELDS[] =
{
    &QM_GLOBAL_CFG_QM_AGGREGATION_TIMER_CTRL_PRESCALER_GRANULARITY_FIELD,
    &QM_GLOBAL_CFG_QM_AGGREGATION_TIMER_CTRL_AGGREGATION_TIMEOUT_VALUE_FIELD,
    &QM_GLOBAL_CFG_QM_AGGREGATION_TIMER_CTRL_PD_OCCUPANCY_EN_FIELD,
    &QM_GLOBAL_CFG_QM_AGGREGATION_TIMER_CTRL_PD_OCCUPANCY_VALUE_FIELD,
    &QM_GLOBAL_CFG_QM_AGGREGATION_TIMER_CTRL_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_GLOBAL_CFG_QM_AGGREGATION_TIMER_CTRL_REG = 
{
    "GLOBAL_CFG_QM_AGGREGATION_TIMER_CTRL",
#if RU_INCLUDE_DESC
    "QM_AGGREGATION_TIMER_CTRL Register",
    "Open aggregation will be forced to close after internal timer expiration."
    "The first byte (0-7bits) controls the granularity of the internal counter (valid value 0x0-0x3)"
    "The second byte (8-15bits) controls the timout value (valid values 0x0-0x7), which is counted according to granularity cycles."
    "the 16bit is enable for the mechanism",
#endif
    QM_GLOBAL_CFG_QM_AGGREGATION_TIMER_CTRL_REG_OFFSET,
    0,
    0,
    21,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    5,
    QM_GLOBAL_CFG_QM_AGGREGATION_TIMER_CTRL_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_GLOBAL_CFG_QM_FPM_UG_GBL_CNT
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_GLOBAL_CFG_QM_FPM_UG_GBL_CNT_FIELDS[] =
{
    &QM_GLOBAL_CFG_QM_FPM_UG_GBL_CNT_FPM_GBL_CNT_FIELD,
    &QM_GLOBAL_CFG_QM_FPM_UG_GBL_CNT_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_GLOBAL_CFG_QM_FPM_UG_GBL_CNT_REG = 
{
    "GLOBAL_CFG_QM_FPM_UG_GBL_CNT",
#if RU_INCLUDE_DESC
    "QM_FPM_UG_GBL_CNT Register",
    "FPM global user group counter:"
    "UG0-3 + UG7"
    ""
    "",
#endif
    QM_GLOBAL_CFG_QM_FPM_UG_GBL_CNT_REG_OFFSET,
    0,
    0,
    22,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    2,
    QM_GLOBAL_CFG_QM_FPM_UG_GBL_CNT_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_GLOBAL_CFG_QM_EGRESS_FLUSH_QUEUE
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_GLOBAL_CFG_QM_EGRESS_FLUSH_QUEUE_FIELDS[] =
{
    &QM_GLOBAL_CFG_QM_EGRESS_FLUSH_QUEUE_QUEUE_NUM_FIELD,
    &QM_GLOBAL_CFG_QM_EGRESS_FLUSH_QUEUE_FLUSH_EN_FIELD,
    &QM_GLOBAL_CFG_QM_EGRESS_FLUSH_QUEUE_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_GLOBAL_CFG_QM_EGRESS_FLUSH_QUEUE_REG = 
{
    "GLOBAL_CFG_QM_EGRESS_FLUSH_QUEUE",
#if RU_INCLUDE_DESC
    "QM_EGRESS_FLUSH_QUEUE Register",
    "0-8b: queue to flush"
    "9b:   enable flush"
    ""
    ""
    ""
    "",
#endif
    QM_GLOBAL_CFG_QM_EGRESS_FLUSH_QUEUE_REG_OFFSET,
    0,
    0,
    23,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    3,
    QM_GLOBAL_CFG_QM_EGRESS_FLUSH_QUEUE_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_GLOBAL_CFG_DDR_SPARE_ROOM
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_GLOBAL_CFG_DDR_SPARE_ROOM_FIELDS[] =
{
    &QM_GLOBAL_CFG_DDR_SPARE_ROOM_DDR_HEADROOM_FIELD,
    &QM_GLOBAL_CFG_DDR_SPARE_ROOM_RESERVED0_FIELD,
    &QM_GLOBAL_CFG_DDR_SPARE_ROOM_DDR_TAILROOM_FIELD,
    &QM_GLOBAL_CFG_DDR_SPARE_ROOM_RESERVED1_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_GLOBAL_CFG_DDR_SPARE_ROOM_REG = 
{
    "GLOBAL_CFG_DDR_SPARE_ROOM",
#if RU_INCLUDE_DESC
    "DDR_SPARE_ROOM %i Register",
    "DDR_SPARE_ROOM",
#endif
    QM_GLOBAL_CFG_DDR_SPARE_ROOM_REG_OFFSET,
    QM_GLOBAL_CFG_DDR_SPARE_ROOM_REG_RAM_CNT,
    4,
    24,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    4,
    QM_GLOBAL_CFG_DDR_SPARE_ROOM_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_GLOBAL_CFG_DUMMY_SPARE_ROOM_PROFILE_ID
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_GLOBAL_CFG_DUMMY_SPARE_ROOM_PROFILE_ID_FIELDS[] =
{
    &QM_GLOBAL_CFG_DUMMY_SPARE_ROOM_PROFILE_ID_DUMMY_PROFILE_0_FIELD,
    &QM_GLOBAL_CFG_DUMMY_SPARE_ROOM_PROFILE_ID_RESERVED0_FIELD,
    &QM_GLOBAL_CFG_DUMMY_SPARE_ROOM_PROFILE_ID_DUMMY_PROFILE_1_FIELD,
    &QM_GLOBAL_CFG_DUMMY_SPARE_ROOM_PROFILE_ID_RESERVED1_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_GLOBAL_CFG_DUMMY_SPARE_ROOM_PROFILE_ID_REG = 
{
    "GLOBAL_CFG_DUMMY_SPARE_ROOM_PROFILE_ID",
#if RU_INCLUDE_DESC
    "DUMMY_SPARE_ROOM_PROFILE_ID Register",
    "DUMMY_SPARE_ROOM_PROFILE_ID",
#endif
    QM_GLOBAL_CFG_DUMMY_SPARE_ROOM_PROFILE_ID_REG_OFFSET,
    0,
    0,
    25,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    4,
    QM_GLOBAL_CFG_DUMMY_SPARE_ROOM_PROFILE_ID_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_GLOBAL_CFG_DQM_UBUS_CTRL
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_GLOBAL_CFG_DQM_UBUS_CTRL_FIELDS[] =
{
    &QM_GLOBAL_CFG_DQM_UBUS_CTRL_TKN_REQOUT_H_FIELD,
    &QM_GLOBAL_CFG_DQM_UBUS_CTRL_TKN_REQOUT_D_FIELD,
    &QM_GLOBAL_CFG_DQM_UBUS_CTRL_OFFLOAD_REQOUT_H_FIELD,
    &QM_GLOBAL_CFG_DQM_UBUS_CTRL_OFFLOAD_REQOUT_D_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_GLOBAL_CFG_DQM_UBUS_CTRL_REG = 
{
    "GLOBAL_CFG_DQM_UBUS_CTRL",
#if RU_INCLUDE_DESC
    "DQM_UBUS_CTRL Register",
    "Dont TOUCH.",
#endif
    QM_GLOBAL_CFG_DQM_UBUS_CTRL_REG_OFFSET,
    0,
    0,
    26,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    4,
    QM_GLOBAL_CFG_DQM_UBUS_CTRL_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_GLOBAL_CFG_MEM_AUTO_INIT
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_GLOBAL_CFG_MEM_AUTO_INIT_FIELDS[] =
{
    &QM_GLOBAL_CFG_MEM_AUTO_INIT_MEM_INIT_EN_FIELD,
    &QM_GLOBAL_CFG_MEM_AUTO_INIT_RESERVED0_FIELD,
    &QM_GLOBAL_CFG_MEM_AUTO_INIT_MEM_SEL_INIT_FIELD,
    &QM_GLOBAL_CFG_MEM_AUTO_INIT_RESERVED1_FIELD,
    &QM_GLOBAL_CFG_MEM_AUTO_INIT_MEM_SIZE_INIT_FIELD,
    &QM_GLOBAL_CFG_MEM_AUTO_INIT_RESERVED2_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_GLOBAL_CFG_MEM_AUTO_INIT_REG = 
{
    "GLOBAL_CFG_MEM_AUTO_INIT",
#if RU_INCLUDE_DESC
    "MEMORY_AUTO_INIT Register",
    "Memory init mechanism:"
    "2b00: qm_total_valid_counter"
    "2b01: qm_drop_counter"
    "2b10: qm_dqm_valid_counter"
    "2b11: qm_epon_rpt_cnt_counter"
    "",
#endif
    QM_GLOBAL_CFG_MEM_AUTO_INIT_REG_OFFSET,
    0,
    0,
    27,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    6,
    QM_GLOBAL_CFG_MEM_AUTO_INIT_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_GLOBAL_CFG_MEM_AUTO_INIT_STS
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_GLOBAL_CFG_MEM_AUTO_INIT_STS_FIELDS[] =
{
    &QM_GLOBAL_CFG_MEM_AUTO_INIT_STS_MEM_INIT_DONE_FIELD,
    &QM_GLOBAL_CFG_MEM_AUTO_INIT_STS_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_GLOBAL_CFG_MEM_AUTO_INIT_STS_REG = 
{
    "GLOBAL_CFG_MEM_AUTO_INIT_STS",
#if RU_INCLUDE_DESC
    "MEMORY_AUTO_INIT_STATUS Register",
    "Memory init status"
    ""
    "",
#endif
    QM_GLOBAL_CFG_MEM_AUTO_INIT_STS_REG_OFFSET,
    0,
    0,
    28,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    2,
    QM_GLOBAL_CFG_MEM_AUTO_INIT_STS_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_SIZE_TOKENS
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_SIZE_TOKENS_FIELDS[] =
{
    &QM_GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_SIZE_TOKENS_POOL_0_NUM_OF_TKNS_FIELD,
    &QM_GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_SIZE_TOKENS_RESERVED0_FIELD,
    &QM_GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_SIZE_TOKENS_POOL_1_NUM_OF_TKNS_FIELD,
    &QM_GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_SIZE_TOKENS_RESERVED1_FIELD,
    &QM_GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_SIZE_TOKENS_POOL_2_NUM_OF_TKNS_FIELD,
    &QM_GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_SIZE_TOKENS_RESERVED2_FIELD,
    &QM_GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_SIZE_TOKENS_POOL_3_NUM_OF_TKNS_FIELD,
    &QM_GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_SIZE_TOKENS_RESERVED3_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_SIZE_TOKENS_REG = 
{
    "GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_SIZE_TOKENS",
#if RU_INCLUDE_DESC
    "FPM_MPM_ENHANCEMENT_POOL_SIZES_TOKENS Register",
    "Enhancement support for FPM and MPM"
    "Configures the amount of Tokens per"
    "pool"
    "FPM:"
    "pool 0: 8"
    "pool 1: 4"
    "pool 2: 2"
    "pool 3: 1"
    ""
    "MPM:"
    "Values can be: 1,2,3,4,5,8,10,20,40",
#endif
    QM_GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_SIZE_TOKENS_REG_OFFSET,
    0,
    0,
    29,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    8,
    QM_GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_SIZE_TOKENS_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_0_1_SIZE_BYTE
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_0_1_SIZE_BYTE_FIELDS[] =
{
    &QM_GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_0_1_SIZE_BYTE_POOL_0_NUM_OF_BYTES_FIELD,
    &QM_GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_0_1_SIZE_BYTE_RESERVED0_FIELD,
    &QM_GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_0_1_SIZE_BYTE_POOL_1_NUM_OF_BYTES_FIELD,
    &QM_GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_0_1_SIZE_BYTE_RESERVED1_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_0_1_SIZE_BYTE_REG = 
{
    "GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_0_1_SIZE_BYTE",
#if RU_INCLUDE_DESC
    "FPM_MPM_ENHANCEMENT_POOL_0_1_SIZES_BYTES Register",
    "Enhancement support for FPM and MPM"
    "Configures the amount of Bytes per pool"
    "",
#endif
    QM_GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_0_1_SIZE_BYTE_REG_OFFSET,
    0,
    0,
    30,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    4,
    QM_GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_0_1_SIZE_BYTE_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_2_3_SIZE_BYTE
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_2_3_SIZE_BYTE_FIELDS[] =
{
    &QM_GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_2_3_SIZE_BYTE_POOL_2_NUM_OF_BYTES_FIELD,
    &QM_GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_2_3_SIZE_BYTE_RESERVED0_FIELD,
    &QM_GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_2_3_SIZE_BYTE_POOL_3_NUM_OF_BYTES_FIELD,
    &QM_GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_2_3_SIZE_BYTE_RESERVED1_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_2_3_SIZE_BYTE_REG = 
{
    "GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_2_3_SIZE_BYTE",
#if RU_INCLUDE_DESC
    "FPM_MPM_ENHANCEMENT_POOL_2_3_SIZES_BYTES Register",
    "Enhancement support for FPM and MPM"
    "Configures the amount of Bytes per pool"
    "",
#endif
    QM_GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_2_3_SIZE_BYTE_REG_OFFSET,
    0,
    0,
    31,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    4,
    QM_GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_2_3_SIZE_BYTE_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_GLOBAL_CFG_MC_CTRL
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_GLOBAL_CFG_MC_CTRL_FIELDS[] =
{
    &QM_GLOBAL_CFG_MC_CTRL_RESERVED0_FIELD,
    &QM_GLOBAL_CFG_MC_CTRL_MC_HEADERS_POOL_SEL_FIELD,
    &QM_GLOBAL_CFG_MC_CTRL_RESERVED1_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_GLOBAL_CFG_MC_CTRL_REG = 
{
    "GLOBAL_CFG_MC_CTRL",
#if RU_INCLUDE_DESC
    "MC_CTRL Register",
    "Multicast Control register",
#endif
    QM_GLOBAL_CFG_MC_CTRL_REG_OFFSET,
    0,
    0,
    32,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    3,
    QM_GLOBAL_CFG_MC_CTRL_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_FPM_POOLS_THR
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_FPM_POOLS_THR_FIELDS[] =
{
    &QM_FPM_POOLS_THR_FPM_LOWER_THR_FIELD,
    &QM_FPM_POOLS_THR_RESERVED0_FIELD,
    &QM_FPM_POOLS_THR_FPM_HIGHER_THR_FIELD,
    &QM_FPM_POOLS_THR_RESERVED1_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_FPM_POOLS_THR_REG = 
{
    "FPM_POOLS_THR",
#if RU_INCLUDE_DESC
    "THR Register",
    "Hold 2 thresholds per FPM pool for priority management",
#endif
    QM_FPM_POOLS_THR_REG_OFFSET,
    QM_FPM_POOLS_THR_REG_RAM_CNT,
    32,
    33,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    4,
    QM_FPM_POOLS_THR_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_FPM_USR_GRP_LOWER_THR
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_FPM_USR_GRP_LOWER_THR_FIELDS[] =
{
    &QM_FPM_USR_GRP_LOWER_THR_FPM_GRP_LOWER_THR_FIELD,
    &QM_FPM_USR_GRP_LOWER_THR_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_FPM_USR_GRP_LOWER_THR_REG = 
{
    "FPM_USR_GRP_LOWER_THR",
#if RU_INCLUDE_DESC
    "LOWER_THR Register",
    "Holds FPM user group lower threshold.",
#endif
    QM_FPM_USR_GRP_LOWER_THR_REG_OFFSET,
    QM_FPM_USR_GRP_LOWER_THR_REG_RAM_CNT,
    32,
    34,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    2,
    QM_FPM_USR_GRP_LOWER_THR_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_FPM_USR_GRP_MID_THR
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_FPM_USR_GRP_MID_THR_FIELDS[] =
{
    &QM_FPM_USR_GRP_MID_THR_FPM_GRP_MID_THR_FIELD,
    &QM_FPM_USR_GRP_MID_THR_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_FPM_USR_GRP_MID_THR_REG = 
{
    "FPM_USR_GRP_MID_THR",
#if RU_INCLUDE_DESC
    "MID_THR Register",
    "Holds FPM user group middle threshold."
    "*IMPORTANT* if buffer reservations is enabled, the following should be honored:"
    "HIGHER_THR-MID_THR > 16",
#endif
    QM_FPM_USR_GRP_MID_THR_REG_OFFSET,
    QM_FPM_USR_GRP_MID_THR_REG_RAM_CNT,
    32,
    35,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    2,
    QM_FPM_USR_GRP_MID_THR_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_FPM_USR_GRP_HIGHER_THR
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_FPM_USR_GRP_HIGHER_THR_FIELDS[] =
{
    &QM_FPM_USR_GRP_HIGHER_THR_FPM_GRP_HIGHER_THR_FIELD,
    &QM_FPM_USR_GRP_HIGHER_THR_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_FPM_USR_GRP_HIGHER_THR_REG = 
{
    "FPM_USR_GRP_HIGHER_THR",
#if RU_INCLUDE_DESC
    "HIGHER_THR Register",
    "Holds FPM user group higher threshold."
    "*IMPORTANT* if buffer reservations is enabled, the following should be honored:"
    "HIGHER_THR-MID_THR > 16",
#endif
    QM_FPM_USR_GRP_HIGHER_THR_REG_OFFSET,
    QM_FPM_USR_GRP_HIGHER_THR_REG_RAM_CNT,
    32,
    36,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    2,
    QM_FPM_USR_GRP_HIGHER_THR_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_FPM_USR_GRP_CNT
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_FPM_USR_GRP_CNT_FIELDS[] =
{
    &QM_FPM_USR_GRP_CNT_FPM_UG_CNT_FIELD,
    &QM_FPM_USR_GRP_CNT_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_FPM_USR_GRP_CNT_REG = 
{
    "FPM_USR_GRP_CNT",
#if RU_INCLUDE_DESC
    "CNT Register",
    "FPM user group buffer counter",
#endif
    QM_FPM_USR_GRP_CNT_REG_OFFSET,
    QM_FPM_USR_GRP_CNT_REG_RAM_CNT,
    32,
    37,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    2,
    QM_FPM_USR_GRP_CNT_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_RUNNER_GRP_RNR_CONFIG
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_RUNNER_GRP_RNR_CONFIG_FIELDS[] =
{
    &QM_RUNNER_GRP_RNR_CONFIG_RNR_BB_ID_FIELD,
    &QM_RUNNER_GRP_RNR_CONFIG_RESERVED0_FIELD,
    &QM_RUNNER_GRP_RNR_CONFIG_RNR_TASK_FIELD,
    &QM_RUNNER_GRP_RNR_CONFIG_RESERVED1_FIELD,
    &QM_RUNNER_GRP_RNR_CONFIG_RNR_ENABLE_FIELD,
    &QM_RUNNER_GRP_RNR_CONFIG_RESERVED2_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_RUNNER_GRP_RNR_CONFIG_REG = 
{
    "RUNNER_GRP_RNR_CONFIG",
#if RU_INCLUDE_DESC
    "RNR_CONFIG Register",
    "Runners Configurations",
#endif
    QM_RUNNER_GRP_RNR_CONFIG_REG_OFFSET,
    QM_RUNNER_GRP_RNR_CONFIG_REG_RAM_CNT,
    16,
    38,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    6,
    QM_RUNNER_GRP_RNR_CONFIG_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_RUNNER_GRP_QUEUE_CONFIG
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_RUNNER_GRP_QUEUE_CONFIG_FIELDS[] =
{
    &QM_RUNNER_GRP_QUEUE_CONFIG_START_QUEUE_FIELD,
    &QM_RUNNER_GRP_QUEUE_CONFIG_RESERVED0_FIELD,
    &QM_RUNNER_GRP_QUEUE_CONFIG_END_QUEUE_FIELD,
    &QM_RUNNER_GRP_QUEUE_CONFIG_RESERVED1_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_RUNNER_GRP_QUEUE_CONFIG_REG = 
{
    "RUNNER_GRP_QUEUE_CONFIG",
#if RU_INCLUDE_DESC
    "QUEUE_CONFIG Register",
    "Consecutive queues which are associated with this runner",
#endif
    QM_RUNNER_GRP_QUEUE_CONFIG_REG_OFFSET,
    QM_RUNNER_GRP_QUEUE_CONFIG_REG_RAM_CNT,
    16,
    39,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    4,
    QM_RUNNER_GRP_QUEUE_CONFIG_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_RUNNER_GRP_PDFIFO_CONFIG
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_RUNNER_GRP_PDFIFO_CONFIG_FIELDS[] =
{
    &QM_RUNNER_GRP_PDFIFO_CONFIG_RESERVED0_FIELD,
    &QM_RUNNER_GRP_PDFIFO_CONFIG_BASE_ADDR_FIELD,
    &QM_RUNNER_GRP_PDFIFO_CONFIG_RESERVED1_FIELD,
    &QM_RUNNER_GRP_PDFIFO_CONFIG_SIZE_FIELD,
    &QM_RUNNER_GRP_PDFIFO_CONFIG_RESERVED2_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_RUNNER_GRP_PDFIFO_CONFIG_REG = 
{
    "RUNNER_GRP_PDFIFO_CONFIG",
#if RU_INCLUDE_DESC
    "PDFIFO_CONFIG Register",
    "head of the queue PD FIFO attributes",
#endif
    QM_RUNNER_GRP_PDFIFO_CONFIG_REG_OFFSET,
    QM_RUNNER_GRP_PDFIFO_CONFIG_REG_RAM_CNT,
    16,
    40,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    5,
    QM_RUNNER_GRP_PDFIFO_CONFIG_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_RUNNER_GRP_UPDATE_FIFO_CONFIG
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_RUNNER_GRP_UPDATE_FIFO_CONFIG_FIELDS[] =
{
    &QM_RUNNER_GRP_UPDATE_FIFO_CONFIG_RESERVED0_FIELD,
    &QM_RUNNER_GRP_UPDATE_FIFO_CONFIG_BASE_ADDR_FIELD,
    &QM_RUNNER_GRP_UPDATE_FIFO_CONFIG_RESERVED1_FIELD,
    &QM_RUNNER_GRP_UPDATE_FIFO_CONFIG_SIZE_FIELD,
    &QM_RUNNER_GRP_UPDATE_FIFO_CONFIG_RESERVED2_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_RUNNER_GRP_UPDATE_FIFO_CONFIG_REG = 
{
    "RUNNER_GRP_UPDATE_FIFO_CONFIG",
#if RU_INCLUDE_DESC
    "UPDATE_FIFO_CONFIG Register",
    "Update FIFO attributes",
#endif
    QM_RUNNER_GRP_UPDATE_FIFO_CONFIG_REG_OFFSET,
    QM_RUNNER_GRP_UPDATE_FIFO_CONFIG_REG_RAM_CNT,
    16,
    41,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    5,
    QM_RUNNER_GRP_UPDATE_FIFO_CONFIG_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_INTR_CTRL_ISR
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_INTR_CTRL_ISR_FIELDS[] =
{
    &QM_INTR_CTRL_ISR_QM_DQM_POP_ON_EMPTY_FIELD,
    &QM_INTR_CTRL_ISR_QM_DQM_PUSH_ON_FULL_FIELD,
    &QM_INTR_CTRL_ISR_QM_CPU_POP_ON_EMPTY_FIELD,
    &QM_INTR_CTRL_ISR_QM_CPU_PUSH_ON_FULL_FIELD,
    &QM_INTR_CTRL_ISR_QM_NORMAL_QUEUE_PD_NO_CREDIT_FIELD,
    &QM_INTR_CTRL_ISR_QM_NON_DELAYED_QUEUE_PD_NO_CREDIT_FIELD,
    &QM_INTR_CTRL_ISR_QM_NON_VALID_QUEUE_FIELD,
    &QM_INTR_CTRL_ISR_QM_AGG_COHERENT_INCONSISTENCY_FIELD,
    &QM_INTR_CTRL_ISR_QM_FORCE_COPY_ON_NON_DELAYED_FIELD,
    &QM_INTR_CTRL_ISR_QM_FPM_POOL_SIZE_NONEXISTENT_FIELD,
    &QM_INTR_CTRL_ISR_QM_TARGET_MEM_ABS_CONTRADICTION_FIELD,
    &QM_INTR_CTRL_ISR_QM_1588_DROP_FIELD,
    &QM_INTR_CTRL_ISR_QM_1588_MULTICAST_CONTRADICTION_FIELD,
    &QM_INTR_CTRL_ISR_QM_BYTE_DROP_CNT_OVERRUN_FIELD,
    &QM_INTR_CTRL_ISR_QM_PKT_DROP_CNT_OVERRUN_FIELD,
    &QM_INTR_CTRL_ISR_QM_TOTAL_BYTE_CNT_UNDERRUN_FIELD,
    &QM_INTR_CTRL_ISR_QM_TOTAL_PKT_CNT_UNDERRUN_FIELD,
    &QM_INTR_CTRL_ISR_QM_FPM_UG0_UNDERRUN_FIELD,
    &QM_INTR_CTRL_ISR_QM_FPM_UG1_UNDERRUN_FIELD,
    &QM_INTR_CTRL_ISR_QM_FPM_UG2_UNDERRUN_FIELD,
    &QM_INTR_CTRL_ISR_QM_FPM_UG3_UNDERRUN_FIELD,
    &QM_INTR_CTRL_ISR_QM_TIMER_WRAPAROUND_FIELD,
    &QM_INTR_CTRL_ISR_QM_COPY_PLEN_ZERO_FIELD,
    &QM_INTR_CTRL_ISR_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_INTR_CTRL_ISR_REG = 
{
    "INTR_CTRL_ISR",
#if RU_INCLUDE_DESC
    "INTERRUPT_STATUS_REGISTER Register",
    "This register contains the current active QM interrupts. Each asserted bit represents an active interrupt source. The interrupt remains active until the software clears it by writing 1 to the corresponding bit.",
#endif
    QM_INTR_CTRL_ISR_REG_OFFSET,
    0,
    0,
    42,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    24,
    QM_INTR_CTRL_ISR_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_INTR_CTRL_ISM
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_INTR_CTRL_ISM_FIELDS[] =
{
    &QM_INTR_CTRL_ISM_ISM_FIELD,
    &QM_INTR_CTRL_ISM_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_INTR_CTRL_ISM_REG = 
{
    "INTR_CTRL_ISM",
#if RU_INCLUDE_DESC
    "INTERRUPT_STATUS_MASKED_REGISTER Register",
    "This register provides only the  enabled interrupts for each of the interrupt sources depicted in the ISR register.",
#endif
    QM_INTR_CTRL_ISM_REG_OFFSET,
    0,
    0,
    43,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    2,
    QM_INTR_CTRL_ISM_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_INTR_CTRL_IER
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_INTR_CTRL_IER_FIELDS[] =
{
    &QM_INTR_CTRL_IER_IEM_FIELD,
    &QM_INTR_CTRL_IER_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_INTR_CTRL_IER_REG = 
{
    "INTR_CTRL_IER",
#if RU_INCLUDE_DESC
    "INTERRUPT_ENABLE_REGISTER Register",
    "This register provides an enable mask for each of the interrupt sources depicted in the ISR register.",
#endif
    QM_INTR_CTRL_IER_REG_OFFSET,
    0,
    0,
    44,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    2,
    QM_INTR_CTRL_IER_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_INTR_CTRL_ITR
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_INTR_CTRL_ITR_FIELDS[] =
{
    &QM_INTR_CTRL_ITR_IST_FIELD,
    &QM_INTR_CTRL_ITR_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_INTR_CTRL_ITR_REG = 
{
    "INTR_CTRL_ITR",
#if RU_INCLUDE_DESC
    "INTERRUPT_TEST_REGISTER Register",
    "This register enables testing by simulating interrupt sources. When the software sets a bit in the ITR, the corresponding bit in the ISR shows an active interrupt. The interrupt remains active until software clears the bit in the ITR",
#endif
    QM_INTR_CTRL_ITR_REG_OFFSET,
    0,
    0,
    45,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    2,
    QM_INTR_CTRL_ITR_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_CLK_GATE_CLK_GATE_CNTRL
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_CLK_GATE_CLK_GATE_CNTRL_FIELDS[] =
{
    &QM_CLK_GATE_CLK_GATE_CNTRL_BYPASS_CLK_GATE_FIELD,
    &QM_CLK_GATE_CLK_GATE_CNTRL_RESERVED0_FIELD,
    &QM_CLK_GATE_CLK_GATE_CNTRL_TIMER_VAL_FIELD,
    &QM_CLK_GATE_CLK_GATE_CNTRL_KEEP_ALIVE_EN_FIELD,
    &QM_CLK_GATE_CLK_GATE_CNTRL_RESERVED1_FIELD,
    &QM_CLK_GATE_CLK_GATE_CNTRL_KEEP_ALIVE_INTRVL_FIELD,
    &QM_CLK_GATE_CLK_GATE_CNTRL_RESERVED2_FIELD,
    &QM_CLK_GATE_CLK_GATE_CNTRL_KEEP_ALIVE_CYC_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_CLK_GATE_CLK_GATE_CNTRL_REG = 
{
    "CLK_GATE_CLK_GATE_CNTRL",
#if RU_INCLUDE_DESC
    "CLOCK_GATE_CONTROL Register",
    "Clock Gate control register including timer config and bypass control",
#endif
    QM_CLK_GATE_CLK_GATE_CNTRL_REG_OFFSET,
    0,
    0,
    46,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    8,
    QM_CLK_GATE_CLK_GATE_CNTRL_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_CPU_INDR_PORT_CPU_PD_INDIRECT_CTRL
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_CPU_INDR_PORT_CPU_PD_INDIRECT_CTRL_FIELDS[] =
{
    &QM_CPU_INDR_PORT_CPU_PD_INDIRECT_CTRL_QUEUE_NUM_FIELD,
    &QM_CPU_INDR_PORT_CPU_PD_INDIRECT_CTRL_RESERVED0_FIELD,
    &QM_CPU_INDR_PORT_CPU_PD_INDIRECT_CTRL_CMD_FIELD,
    &QM_CPU_INDR_PORT_CPU_PD_INDIRECT_CTRL_RESERVED1_FIELD,
    &QM_CPU_INDR_PORT_CPU_PD_INDIRECT_CTRL_DONE_FIELD,
    &QM_CPU_INDR_PORT_CPU_PD_INDIRECT_CTRL_ERROR_FIELD,
    &QM_CPU_INDR_PORT_CPU_PD_INDIRECT_CTRL_RESERVED2_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_CPU_INDR_PORT_CPU_PD_INDIRECT_CTRL_REG = 
{
    "CPU_INDR_PORT_CPU_PD_INDIRECT_CTRL",
#if RU_INCLUDE_DESC
    "CPU_PD_INDIRECT_CTRL Register",
    "CPU PD Indirect Access Control",
#endif
    QM_CPU_INDR_PORT_CPU_PD_INDIRECT_CTRL_REG_OFFSET,
    QM_CPU_INDR_PORT_CPU_PD_INDIRECT_CTRL_REG_RAM_CNT,
    64,
    47,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    7,
    QM_CPU_INDR_PORT_CPU_PD_INDIRECT_CTRL_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_CPU_INDR_PORT_CPU_PD_INDIRECT_WR_DATA_0
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_CPU_INDR_PORT_CPU_PD_INDIRECT_WR_DATA_0_FIELDS[] =
{
    &QM_CPU_INDR_PORT_CPU_PD_INDIRECT_WR_DATA_0_DATA_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_CPU_INDR_PORT_CPU_PD_INDIRECT_WR_DATA_0_REG = 
{
    "CPU_INDR_PORT_CPU_PD_INDIRECT_WR_DATA_0",
#if RU_INCLUDE_DESC
    "CPU_PD_INDIRECT_WR_DATA %i Register",
    "CPU PD Indirect Write data to DQM."
    "First entry represents PD[127:96] and so on until the last entry representing PD[31:0].",
#endif
    QM_CPU_INDR_PORT_CPU_PD_INDIRECT_WR_DATA_0_REG_OFFSET,
    QM_CPU_INDR_PORT_CPU_PD_INDIRECT_WR_DATA_0_REG_RAM_CNT,
    64,
    48,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    QM_CPU_INDR_PORT_CPU_PD_INDIRECT_WR_DATA_0_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_CPU_INDR_PORT_CPU_PD_INDIRECT_WR_DATA_1
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_CPU_INDR_PORT_CPU_PD_INDIRECT_WR_DATA_1_FIELDS[] =
{
    &QM_CPU_INDR_PORT_CPU_PD_INDIRECT_WR_DATA_1_DATA_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_CPU_INDR_PORT_CPU_PD_INDIRECT_WR_DATA_1_REG = 
{
    "CPU_INDR_PORT_CPU_PD_INDIRECT_WR_DATA_1",
#if RU_INCLUDE_DESC
    "CPU_PD_INDIRECT_WR_DATA %i Register",
    "CPU PD Indirect Write data to DQM."
    "First entry represents PD[127:96] and so on until the last entry representing PD[31:0].",
#endif
    QM_CPU_INDR_PORT_CPU_PD_INDIRECT_WR_DATA_1_REG_OFFSET,
    QM_CPU_INDR_PORT_CPU_PD_INDIRECT_WR_DATA_1_REG_RAM_CNT,
    64,
    49,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    QM_CPU_INDR_PORT_CPU_PD_INDIRECT_WR_DATA_1_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_CPU_INDR_PORT_CPU_PD_INDIRECT_WR_DATA_2
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_CPU_INDR_PORT_CPU_PD_INDIRECT_WR_DATA_2_FIELDS[] =
{
    &QM_CPU_INDR_PORT_CPU_PD_INDIRECT_WR_DATA_2_DATA_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_CPU_INDR_PORT_CPU_PD_INDIRECT_WR_DATA_2_REG = 
{
    "CPU_INDR_PORT_CPU_PD_INDIRECT_WR_DATA_2",
#if RU_INCLUDE_DESC
    "CPU_PD_INDIRECT_WR_DATA %i Register",
    "CPU PD Indirect Write data to DQM."
    "First entry represents PD[127:96] and so on until the last entry representing PD[31:0].",
#endif
    QM_CPU_INDR_PORT_CPU_PD_INDIRECT_WR_DATA_2_REG_OFFSET,
    QM_CPU_INDR_PORT_CPU_PD_INDIRECT_WR_DATA_2_REG_RAM_CNT,
    64,
    50,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    QM_CPU_INDR_PORT_CPU_PD_INDIRECT_WR_DATA_2_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_CPU_INDR_PORT_CPU_PD_INDIRECT_WR_DATA_3
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_CPU_INDR_PORT_CPU_PD_INDIRECT_WR_DATA_3_FIELDS[] =
{
    &QM_CPU_INDR_PORT_CPU_PD_INDIRECT_WR_DATA_3_DATA_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_CPU_INDR_PORT_CPU_PD_INDIRECT_WR_DATA_3_REG = 
{
    "CPU_INDR_PORT_CPU_PD_INDIRECT_WR_DATA_3",
#if RU_INCLUDE_DESC
    "CPU_PD_INDIRECT_WR_DATA %i Register",
    "CPU PD Indirect Write data to DQM."
    "First entry represents PD[127:96] and so on until the last entry representing PD[31:0].",
#endif
    QM_CPU_INDR_PORT_CPU_PD_INDIRECT_WR_DATA_3_REG_OFFSET,
    QM_CPU_INDR_PORT_CPU_PD_INDIRECT_WR_DATA_3_REG_RAM_CNT,
    64,
    51,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    QM_CPU_INDR_PORT_CPU_PD_INDIRECT_WR_DATA_3_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_CPU_INDR_PORT_CPU_PD_INDIRECT_RD_DATA_0
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_CPU_INDR_PORT_CPU_PD_INDIRECT_RD_DATA_0_FIELDS[] =
{
    &QM_CPU_INDR_PORT_CPU_PD_INDIRECT_RD_DATA_0_DATA_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_CPU_INDR_PORT_CPU_PD_INDIRECT_RD_DATA_0_REG = 
{
    "CPU_INDR_PORT_CPU_PD_INDIRECT_RD_DATA_0",
#if RU_INCLUDE_DESC
    "CPU_PD_INDIRECT_RD_DATA %i Register",
    "CPU PD Indirect Read data from DQM."
    "First entry represents PD[127:96] and so on until the last entry representing PD[31:0].",
#endif
    QM_CPU_INDR_PORT_CPU_PD_INDIRECT_RD_DATA_0_REG_OFFSET,
    QM_CPU_INDR_PORT_CPU_PD_INDIRECT_RD_DATA_0_REG_RAM_CNT,
    64,
    52,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    QM_CPU_INDR_PORT_CPU_PD_INDIRECT_RD_DATA_0_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_CPU_INDR_PORT_CPU_PD_INDIRECT_RD_DATA_1
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_CPU_INDR_PORT_CPU_PD_INDIRECT_RD_DATA_1_FIELDS[] =
{
    &QM_CPU_INDR_PORT_CPU_PD_INDIRECT_RD_DATA_1_DATA_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_CPU_INDR_PORT_CPU_PD_INDIRECT_RD_DATA_1_REG = 
{
    "CPU_INDR_PORT_CPU_PD_INDIRECT_RD_DATA_1",
#if RU_INCLUDE_DESC
    "CPU_PD_INDIRECT_RD_DATA %i Register",
    "CPU PD Indirect Read data from DQM."
    "First entry represents PD[127:96] and so on until the last entry representing PD[31:0].",
#endif
    QM_CPU_INDR_PORT_CPU_PD_INDIRECT_RD_DATA_1_REG_OFFSET,
    QM_CPU_INDR_PORT_CPU_PD_INDIRECT_RD_DATA_1_REG_RAM_CNT,
    64,
    53,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    QM_CPU_INDR_PORT_CPU_PD_INDIRECT_RD_DATA_1_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_CPU_INDR_PORT_CPU_PD_INDIRECT_RD_DATA_2
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_CPU_INDR_PORT_CPU_PD_INDIRECT_RD_DATA_2_FIELDS[] =
{
    &QM_CPU_INDR_PORT_CPU_PD_INDIRECT_RD_DATA_2_DATA_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_CPU_INDR_PORT_CPU_PD_INDIRECT_RD_DATA_2_REG = 
{
    "CPU_INDR_PORT_CPU_PD_INDIRECT_RD_DATA_2",
#if RU_INCLUDE_DESC
    "CPU_PD_INDIRECT_RD_DATA %i Register",
    "CPU PD Indirect Read data from DQM."
    "First entry represents PD[127:96] and so on until the last entry representing PD[31:0].",
#endif
    QM_CPU_INDR_PORT_CPU_PD_INDIRECT_RD_DATA_2_REG_OFFSET,
    QM_CPU_INDR_PORT_CPU_PD_INDIRECT_RD_DATA_2_REG_RAM_CNT,
    64,
    54,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    QM_CPU_INDR_PORT_CPU_PD_INDIRECT_RD_DATA_2_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_CPU_INDR_PORT_CPU_PD_INDIRECT_RD_DATA_3
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_CPU_INDR_PORT_CPU_PD_INDIRECT_RD_DATA_3_FIELDS[] =
{
    &QM_CPU_INDR_PORT_CPU_PD_INDIRECT_RD_DATA_3_DATA_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_CPU_INDR_PORT_CPU_PD_INDIRECT_RD_DATA_3_REG = 
{
    "CPU_INDR_PORT_CPU_PD_INDIRECT_RD_DATA_3",
#if RU_INCLUDE_DESC
    "CPU_PD_INDIRECT_RD_DATA %i Register",
    "CPU PD Indirect Read data from DQM."
    "First entry represents PD[127:96] and so on until the last entry representing PD[31:0].",
#endif
    QM_CPU_INDR_PORT_CPU_PD_INDIRECT_RD_DATA_3_REG_OFFSET,
    QM_CPU_INDR_PORT_CPU_PD_INDIRECT_RD_DATA_3_REG_RAM_CNT,
    64,
    55,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    QM_CPU_INDR_PORT_CPU_PD_INDIRECT_RD_DATA_3_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_QUEUE_CONTEXT_CONTEXT
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_QUEUE_CONTEXT_CONTEXT_FIELDS[] =
{
    &QM_QUEUE_CONTEXT_CONTEXT_WRED_PROFILE_FIELD,
    &QM_QUEUE_CONTEXT_CONTEXT_COPY_DEC_PROFILE_FIELD,
    &QM_QUEUE_CONTEXT_CONTEXT_COPY_TO_DDR_FIELD,
    &QM_QUEUE_CONTEXT_CONTEXT_DDR_COPY_DISABLE_FIELD,
    &QM_QUEUE_CONTEXT_CONTEXT_AGGREGATION_DISABLE_FIELD,
    &QM_QUEUE_CONTEXT_CONTEXT_FPM_UG_FIELD,
    &QM_QUEUE_CONTEXT_CONTEXT_EXCLUSIVE_PRIORITY_FIELD,
    &QM_QUEUE_CONTEXT_CONTEXT_Q_802_1AE_FIELD,
    &QM_QUEUE_CONTEXT_CONTEXT_SCI_FIELD,
    &QM_QUEUE_CONTEXT_CONTEXT_FEC_ENABLE_FIELD,
    &QM_QUEUE_CONTEXT_CONTEXT_RES_PROFILE_FIELD,
    &QM_QUEUE_CONTEXT_CONTEXT_SPARE_ROOM_0_FIELD,
    &QM_QUEUE_CONTEXT_CONTEXT_SPARE_ROOM_1_FIELD,
    &QM_QUEUE_CONTEXT_CONTEXT_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_QUEUE_CONTEXT_CONTEXT_REG = 
{
    "QUEUE_CONTEXT_CONTEXT",
#if RU_INCLUDE_DESC
    "QUEUE_CONTEXT %i Register",
    "This RAM holds all queue attributes."
    "Not all of the 32-bits in the address space are implemented."
    "WRED Profile            3:0"
    "Copy decision profile 6:4"
    "Copy to DDR         7"
    "DDR copy disable 8"
    "Aggregation Disable 9"
    "FPM User Group         11:10"
    "Exclusive Priority 12"
    "802.1AE                 13"
    "SCI                 14"
    "FEC Enable         15"
    "",
#endif
    QM_QUEUE_CONTEXT_CONTEXT_REG_OFFSET,
    QM_QUEUE_CONTEXT_CONTEXT_REG_RAM_CNT,
    4,
    56,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    14,
    QM_QUEUE_CONTEXT_CONTEXT_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_WRED_PROFILE_COLOR_MIN_THR_0
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_WRED_PROFILE_COLOR_MIN_THR_0_FIELDS[] =
{
    &QM_WRED_PROFILE_COLOR_MIN_THR_0_MIN_THR_FIELD,
    &QM_WRED_PROFILE_COLOR_MIN_THR_0_FLW_CTRL_EN_FIELD,
    &QM_WRED_PROFILE_COLOR_MIN_THR_0_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_WRED_PROFILE_COLOR_MIN_THR_0_REG = 
{
    "WRED_PROFILE_COLOR_MIN_THR_0",
#if RU_INCLUDE_DESC
    "COLOR_MIN_THR %i Register",
    "WRED Color min thresholds",
#endif
    QM_WRED_PROFILE_COLOR_MIN_THR_0_REG_OFFSET,
    QM_WRED_PROFILE_COLOR_MIN_THR_0_REG_RAM_CNT,
    48,
    57,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    3,
    QM_WRED_PROFILE_COLOR_MIN_THR_0_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_WRED_PROFILE_COLOR_MIN_THR_1
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_WRED_PROFILE_COLOR_MIN_THR_1_FIELDS[] =
{
    &QM_WRED_PROFILE_COLOR_MIN_THR_1_MIN_THR_FIELD,
    &QM_WRED_PROFILE_COLOR_MIN_THR_1_FLW_CTRL_EN_FIELD,
    &QM_WRED_PROFILE_COLOR_MIN_THR_1_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_WRED_PROFILE_COLOR_MIN_THR_1_REG = 
{
    "WRED_PROFILE_COLOR_MIN_THR_1",
#if RU_INCLUDE_DESC
    "COLOR_MIN_THR %i Register",
    "WRED Color min thresholds",
#endif
    QM_WRED_PROFILE_COLOR_MIN_THR_1_REG_OFFSET,
    QM_WRED_PROFILE_COLOR_MIN_THR_1_REG_RAM_CNT,
    48,
    58,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    3,
    QM_WRED_PROFILE_COLOR_MIN_THR_1_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_WRED_PROFILE_COLOR_MAX_THR_0
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_WRED_PROFILE_COLOR_MAX_THR_0_FIELDS[] =
{
    &QM_WRED_PROFILE_COLOR_MAX_THR_0_MAX_THR_FIELD,
    &QM_WRED_PROFILE_COLOR_MAX_THR_0_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_WRED_PROFILE_COLOR_MAX_THR_0_REG = 
{
    "WRED_PROFILE_COLOR_MAX_THR_0",
#if RU_INCLUDE_DESC
    "COLOR_MAX_THR %i Register",
    "WRED Color max thresholds",
#endif
    QM_WRED_PROFILE_COLOR_MAX_THR_0_REG_OFFSET,
    QM_WRED_PROFILE_COLOR_MAX_THR_0_REG_RAM_CNT,
    48,
    59,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    2,
    QM_WRED_PROFILE_COLOR_MAX_THR_0_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_WRED_PROFILE_COLOR_MAX_THR_1
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_WRED_PROFILE_COLOR_MAX_THR_1_FIELDS[] =
{
    &QM_WRED_PROFILE_COLOR_MAX_THR_1_MAX_THR_FIELD,
    &QM_WRED_PROFILE_COLOR_MAX_THR_1_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_WRED_PROFILE_COLOR_MAX_THR_1_REG = 
{
    "WRED_PROFILE_COLOR_MAX_THR_1",
#if RU_INCLUDE_DESC
    "COLOR_MAX_THR %i Register",
    "WRED Color max thresholds",
#endif
    QM_WRED_PROFILE_COLOR_MAX_THR_1_REG_OFFSET,
    QM_WRED_PROFILE_COLOR_MAX_THR_1_REG_RAM_CNT,
    48,
    60,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    2,
    QM_WRED_PROFILE_COLOR_MAX_THR_1_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_WRED_PROFILE_COLOR_SLOPE_0
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_WRED_PROFILE_COLOR_SLOPE_0_FIELDS[] =
{
    &QM_WRED_PROFILE_COLOR_SLOPE_0_SLOPE_MANTISSA_FIELD,
    &QM_WRED_PROFILE_COLOR_SLOPE_0_SLOPE_EXP_FIELD,
    &QM_WRED_PROFILE_COLOR_SLOPE_0_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_WRED_PROFILE_COLOR_SLOPE_0_REG = 
{
    "WRED_PROFILE_COLOR_SLOPE_0",
#if RU_INCLUDE_DESC
    "COLOR_SLOPE %i Register",
    "WRED Color slopes",
#endif
    QM_WRED_PROFILE_COLOR_SLOPE_0_REG_OFFSET,
    QM_WRED_PROFILE_COLOR_SLOPE_0_REG_RAM_CNT,
    48,
    61,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    3,
    QM_WRED_PROFILE_COLOR_SLOPE_0_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_WRED_PROFILE_COLOR_SLOPE_1
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_WRED_PROFILE_COLOR_SLOPE_1_FIELDS[] =
{
    &QM_WRED_PROFILE_COLOR_SLOPE_1_SLOPE_MANTISSA_FIELD,
    &QM_WRED_PROFILE_COLOR_SLOPE_1_SLOPE_EXP_FIELD,
    &QM_WRED_PROFILE_COLOR_SLOPE_1_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_WRED_PROFILE_COLOR_SLOPE_1_REG = 
{
    "WRED_PROFILE_COLOR_SLOPE_1",
#if RU_INCLUDE_DESC
    "COLOR_SLOPE %i Register",
    "WRED Color slopes",
#endif
    QM_WRED_PROFILE_COLOR_SLOPE_1_REG_OFFSET,
    QM_WRED_PROFILE_COLOR_SLOPE_1_REG_RAM_CNT,
    48,
    62,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    3,
    QM_WRED_PROFILE_COLOR_SLOPE_1_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_COPY_DECISION_PROFILE_THR
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_COPY_DECISION_PROFILE_THR_FIELDS[] =
{
    &QM_COPY_DECISION_PROFILE_THR_QUEUE_OCCUPANCY_THR_FIELD,
    &QM_COPY_DECISION_PROFILE_THR_RESERVED0_FIELD,
    &QM_COPY_DECISION_PROFILE_THR_PSRAM_THR_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_COPY_DECISION_PROFILE_THR_REG = 
{
    "COPY_DECISION_PROFILE_THR",
#if RU_INCLUDE_DESC
    "THR Register",
    "DDR Pipe and PSRAM threshold configurations for DDR copy decision logic",
#endif
    QM_COPY_DECISION_PROFILE_THR_REG_OFFSET,
    QM_COPY_DECISION_PROFILE_THR_REG_RAM_CNT,
    32,
    63,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    3,
    QM_COPY_DECISION_PROFILE_THR_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_TOTAL_VALID_COUNTER_COUNTER
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_TOTAL_VALID_COUNTER_COUNTER_FIELDS[] =
{
    &QM_TOTAL_VALID_COUNTER_COUNTER_DATA_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_TOTAL_VALID_COUNTER_COUNTER_REG = 
{
    "TOTAL_VALID_COUNTER_COUNTER",
#if RU_INCLUDE_DESC
    "COUNTER %i Register",
    "Counter."
    "word0:{15b0,pkt_cnt[16:0]}"
    "word1:{2b0,byte_cnt[29:0]}"
    "word2:{14b0,res_cnt[17:0]}"
    "word3: reserved"
    ""
    "There are three words per queue starting at queue0 up to queue 159.",
#endif
    QM_TOTAL_VALID_COUNTER_COUNTER_REG_OFFSET,
    QM_TOTAL_VALID_COUNTER_COUNTER_REG_RAM_CNT,
    4,
    64,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    QM_TOTAL_VALID_COUNTER_COUNTER_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_DQM_VALID_COUNTER_COUNTER
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_DQM_VALID_COUNTER_COUNTER_FIELDS[] =
{
    &QM_DQM_VALID_COUNTER_COUNTER_DATA_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_DQM_VALID_COUNTER_COUNTER_REG = 
{
    "DQM_VALID_COUNTER_COUNTER",
#if RU_INCLUDE_DESC
    "COUNTER %i Register",
    "Counter."
    "word0:{15`b0,pkt_cnt[16:0]}"
    "word1:{2`b0,byte_cnt[29:0]}"
    ""
    "There are two words per queue starting at queue0 up to queue 159.",
#endif
    QM_DQM_VALID_COUNTER_COUNTER_REG_OFFSET,
    QM_DQM_VALID_COUNTER_COUNTER_REG_RAM_CNT,
    4,
    65,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    QM_DQM_VALID_COUNTER_COUNTER_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_DROP_COUNTER_COUNTER
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_DROP_COUNTER_COUNTER_FIELDS[] =
{
    &QM_DROP_COUNTER_COUNTER_DATA_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_DROP_COUNTER_COUNTER_REG = 
{
    "DROP_COUNTER_COUNTER",
#if RU_INCLUDE_DESC
    "COUNTER %i Register",
    "Counter."
    "word0 - 0x0:{6`b0,pkt_cnt[25:0]}"
    "word1 - 0x4:{byte_cnt[31:0]}"
    ""
    "in WRED drop mode:"
    "word0 - 0x0: color1 dropped packets"
    "word1 - 0x4: color0 dropped packets"
    ""
    ""
    "There are two words per queue starting at queue0 up to queue 159.",
#endif
    QM_DROP_COUNTER_COUNTER_REG_OFFSET,
    QM_DROP_COUNTER_COUNTER_REG_RAM_CNT,
    4,
    66,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    QM_DROP_COUNTER_COUNTER_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_EPON_RPT_CNT_COUNTER
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_EPON_RPT_CNT_COUNTER_FIELDS[] =
{
    &QM_EPON_RPT_CNT_COUNTER_DATA_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_EPON_RPT_CNT_COUNTER_REG = 
{
    "EPON_RPT_CNT_COUNTER",
#if RU_INCLUDE_DESC
    "COUNTER %i Register",
    "Counter - For each of the 32-queues in a batch, this counter stores a 32-bit accumulated and overhead byte counter per queue."
    "word0: {accumulated_bytes[31:0]}"
    "word1: {accumulated_overhead[31:0}"
    ""
    "There are two words per queue starting at queue0 up to queue 159.",
#endif
    QM_EPON_RPT_CNT_COUNTER_REG_OFFSET,
    QM_EPON_RPT_CNT_COUNTER_REG_RAM_CNT,
    4,
    67,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    QM_EPON_RPT_CNT_COUNTER_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_EPON_RPT_CNT_QUEUE_STATUS
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_EPON_RPT_CNT_QUEUE_STATUS_FIELDS[] =
{
    &QM_EPON_RPT_CNT_QUEUE_STATUS_STATUS_BIT_VECTOR_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_EPON_RPT_CNT_QUEUE_STATUS_REG = 
{
    "EPON_RPT_CNT_QUEUE_STATUS",
#if RU_INCLUDE_DESC
    "QUEUE_STATUS %i Register",
    "Status bit vector - For each of the 32-queues in a batch, this status indicates which queue counter has been updated.",
#endif
    QM_EPON_RPT_CNT_QUEUE_STATUS_REG_OFFSET,
    QM_EPON_RPT_CNT_QUEUE_STATUS_REG_RAM_CNT,
    4,
    68,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    QM_EPON_RPT_CNT_QUEUE_STATUS_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_RD_DATA_POOL0
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_RD_DATA_POOL0_FIELDS[] =
{
    &QM_RD_DATA_POOL0_DATA_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_RD_DATA_POOL0_REG = 
{
    "RD_DATA_POOL0",
#if RU_INCLUDE_DESC
    "RD_DATA_POOL0 Register",
    "Read the head of the FIFO",
#endif
    QM_RD_DATA_POOL0_REG_OFFSET,
    0,
    0,
    69,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    QM_RD_DATA_POOL0_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_RD_DATA_POOL1
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_RD_DATA_POOL1_FIELDS[] =
{
    &QM_RD_DATA_POOL1_DATA_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_RD_DATA_POOL1_REG = 
{
    "RD_DATA_POOL1",
#if RU_INCLUDE_DESC
    "RD_DATA_POOL1 Register",
    "Read the head of the FIFO",
#endif
    QM_RD_DATA_POOL1_REG_OFFSET,
    0,
    0,
    70,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    QM_RD_DATA_POOL1_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_RD_DATA_POOL2
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_RD_DATA_POOL2_FIELDS[] =
{
    &QM_RD_DATA_POOL2_DATA_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_RD_DATA_POOL2_REG = 
{
    "RD_DATA_POOL2",
#if RU_INCLUDE_DESC
    "RD_DATA_POOL2 Register",
    "Read the head of the FIFO",
#endif
    QM_RD_DATA_POOL2_REG_OFFSET,
    0,
    0,
    71,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    QM_RD_DATA_POOL2_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_RD_DATA_POOL3
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_RD_DATA_POOL3_FIELDS[] =
{
    &QM_RD_DATA_POOL3_DATA_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_RD_DATA_POOL3_REG = 
{
    "RD_DATA_POOL3",
#if RU_INCLUDE_DESC
    "RD_DATA_POOL3 Register",
    "Read the head of the FIFO",
#endif
    QM_RD_DATA_POOL3_REG_OFFSET,
    0,
    0,
    72,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    QM_RD_DATA_POOL3_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_PDFIFO_PTR
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_PDFIFO_PTR_FIELDS[] =
{
    &QM_PDFIFO_PTR_WR_PTR_FIELD,
    &QM_PDFIFO_PTR_RESERVED0_FIELD,
    &QM_PDFIFO_PTR_RD_PTR_FIELD,
    &QM_PDFIFO_PTR_RESERVED1_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_PDFIFO_PTR_REG = 
{
    "PDFIFO_PTR",
#if RU_INCLUDE_DESC
    "PDFIFO_PTR %i Register",
    "PDFIFO per queue rd/wr pointers",
#endif
    QM_PDFIFO_PTR_REG_OFFSET,
    QM_PDFIFO_PTR_REG_RAM_CNT,
    4,
    73,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    4,
    QM_PDFIFO_PTR_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_UPDATE_FIFO_PTR
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_UPDATE_FIFO_PTR_FIELDS[] =
{
    &QM_UPDATE_FIFO_PTR_WR_PTR_FIELD,
    &QM_UPDATE_FIFO_PTR_RD_PTR_FIELD,
    &QM_UPDATE_FIFO_PTR_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_UPDATE_FIFO_PTR_REG = 
{
    "UPDATE_FIFO_PTR",
#if RU_INCLUDE_DESC
    "UPDATE_FIFO_PTR %i Register",
    "Update FIFO rd/wr pointers",
#endif
    QM_UPDATE_FIFO_PTR_REG_OFFSET,
    QM_UPDATE_FIFO_PTR_REG_RAM_CNT,
    4,
    74,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    3,
    QM_UPDATE_FIFO_PTR_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_RD_DATA
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_RD_DATA_FIELDS[] =
{
    &QM_RD_DATA_DATA_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_RD_DATA_REG = 
{
    "RD_DATA",
#if RU_INCLUDE_DESC
    "RD_DATA %i Register",
    "Debug - Read the head of the FIFO",
#endif
    QM_RD_DATA_REG_OFFSET,
    QM_RD_DATA_REG_RAM_CNT,
    4,
    75,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    QM_RD_DATA_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_POP
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_POP_FIELDS[] =
{
    &QM_POP_POP_FIELD,
    &QM_POP_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_POP_REG = 
{
    "POP",
#if RU_INCLUDE_DESC
    "POP Register",
    "Pop an entry in the FIFO",
#endif
    QM_POP_REG_OFFSET,
    0,
    0,
    76,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    2,
    QM_POP_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_CM_COMMON_INPUT_FIFO_DATA
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_CM_COMMON_INPUT_FIFO_DATA_FIELDS[] =
{
    &QM_CM_COMMON_INPUT_FIFO_DATA_DATA_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_CM_COMMON_INPUT_FIFO_DATA_REG = 
{
    "CM_COMMON_INPUT_FIFO_DATA",
#if RU_INCLUDE_DESC
    "DATA %i Register",
    "CM Common Input FIFO - debug access",
#endif
    QM_CM_COMMON_INPUT_FIFO_DATA_REG_OFFSET,
    QM_CM_COMMON_INPUT_FIFO_DATA_REG_RAM_CNT,
    4,
    77,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    QM_CM_COMMON_INPUT_FIFO_DATA_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_NORMAL_RMT_FIFO_DATA
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_NORMAL_RMT_FIFO_DATA_FIELDS[] =
{
    &QM_NORMAL_RMT_FIFO_DATA_DATA_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_NORMAL_RMT_FIFO_DATA_REG = 
{
    "NORMAL_RMT_FIFO_DATA",
#if RU_INCLUDE_DESC
    "DATA %i Register",
    "Normal Remote FIFO - debug access",
#endif
    QM_NORMAL_RMT_FIFO_DATA_REG_OFFSET,
    QM_NORMAL_RMT_FIFO_DATA_REG_RAM_CNT,
    4,
    78,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    QM_NORMAL_RMT_FIFO_DATA_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_NON_DELAYED_RMT_FIFO_DATA
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_NON_DELAYED_RMT_FIFO_DATA_FIELDS[] =
{
    &QM_NON_DELAYED_RMT_FIFO_DATA_DATA_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_NON_DELAYED_RMT_FIFO_DATA_REG = 
{
    "NON_DELAYED_RMT_FIFO_DATA",
#if RU_INCLUDE_DESC
    "DATA %i Register",
    "Non-delayed Remote FIFO - debug access",
#endif
    QM_NON_DELAYED_RMT_FIFO_DATA_REG_OFFSET,
    QM_NON_DELAYED_RMT_FIFO_DATA_REG_RAM_CNT,
    4,
    79,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    QM_NON_DELAYED_RMT_FIFO_DATA_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_EGRESS_DATA_FIFO_DATA
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_EGRESS_DATA_FIFO_DATA_FIELDS[] =
{
    &QM_EGRESS_DATA_FIFO_DATA_DATA_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_EGRESS_DATA_FIFO_DATA_REG = 
{
    "EGRESS_DATA_FIFO_DATA",
#if RU_INCLUDE_DESC
    "DATA %i Register",
    "Egress data FIFO - debug access",
#endif
    QM_EGRESS_DATA_FIFO_DATA_REG_OFFSET,
    QM_EGRESS_DATA_FIFO_DATA_REG_RAM_CNT,
    4,
    80,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    QM_EGRESS_DATA_FIFO_DATA_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_EGRESS_RR_FIFO_DATA
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_EGRESS_RR_FIFO_DATA_FIELDS[] =
{
    &QM_EGRESS_RR_FIFO_DATA_DATA_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_EGRESS_RR_FIFO_DATA_REG = 
{
    "EGRESS_RR_FIFO_DATA",
#if RU_INCLUDE_DESC
    "DATA %i Register",
    "Egress RR FIFO - debug access",
#endif
    QM_EGRESS_RR_FIFO_DATA_REG_OFFSET,
    QM_EGRESS_RR_FIFO_DATA_REG_RAM_CNT,
    4,
    81,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    QM_EGRESS_RR_FIFO_DATA_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_EGRESS_BB_INPUT_FIFO_DATA
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_EGRESS_BB_INPUT_FIFO_DATA_FIELDS[] =
{
    &QM_EGRESS_BB_INPUT_FIFO_DATA_DATA_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_EGRESS_BB_INPUT_FIFO_DATA_REG = 
{
    "EGRESS_BB_INPUT_FIFO_DATA",
#if RU_INCLUDE_DESC
    "DATA %i Register",
    "Egress BB Input FIFO - debug access",
#endif
    QM_EGRESS_BB_INPUT_FIFO_DATA_REG_OFFSET,
    QM_EGRESS_BB_INPUT_FIFO_DATA_REG_RAM_CNT,
    4,
    82,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    QM_EGRESS_BB_INPUT_FIFO_DATA_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_EGRESS_BB_OUTPUT_FIFO_DATA
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_EGRESS_BB_OUTPUT_FIFO_DATA_FIELDS[] =
{
    &QM_EGRESS_BB_OUTPUT_FIFO_DATA_DATA_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_EGRESS_BB_OUTPUT_FIFO_DATA_REG = 
{
    "EGRESS_BB_OUTPUT_FIFO_DATA",
#if RU_INCLUDE_DESC
    "DATA %i Register",
    "Egress BB Output FIFO - debug access",
#endif
    QM_EGRESS_BB_OUTPUT_FIFO_DATA_REG_OFFSET,
    QM_EGRESS_BB_OUTPUT_FIFO_DATA_REG_RAM_CNT,
    4,
    83,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    QM_EGRESS_BB_OUTPUT_FIFO_DATA_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_BB_OUTPUT_FIFO_DATA
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_BB_OUTPUT_FIFO_DATA_FIELDS[] =
{
    &QM_BB_OUTPUT_FIFO_DATA_DATA_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_BB_OUTPUT_FIFO_DATA_REG = 
{
    "BB_OUTPUT_FIFO_DATA",
#if RU_INCLUDE_DESC
    "DATA %i Register",
    "QM BB Output FIFO - debug access",
#endif
    QM_BB_OUTPUT_FIFO_DATA_REG_OFFSET,
    QM_BB_OUTPUT_FIFO_DATA_REG_RAM_CNT,
    4,
    84,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    QM_BB_OUTPUT_FIFO_DATA_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_NON_DELAYED_OUT_FIFO_DATA
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_NON_DELAYED_OUT_FIFO_DATA_FIELDS[] =
{
    &QM_NON_DELAYED_OUT_FIFO_DATA_DATA_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_NON_DELAYED_OUT_FIFO_DATA_REG = 
{
    "NON_DELAYED_OUT_FIFO_DATA",
#if RU_INCLUDE_DESC
    "DATA %i Register",
    "Non delayed output FIFO - debug access",
#endif
    QM_NON_DELAYED_OUT_FIFO_DATA_REG_OFFSET,
    QM_NON_DELAYED_OUT_FIFO_DATA_REG_RAM_CNT,
    4,
    85,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    QM_NON_DELAYED_OUT_FIFO_DATA_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_CONTEXT_DATA
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_CONTEXT_DATA_FIELDS[] =
{
    &QM_CONTEXT_DATA_DATA_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_CONTEXT_DATA_REG = 
{
    "CONTEXT_DATA",
#if RU_INCLUDE_DESC
    "DATA %i Register",
    "Aggregation context - debug access",
#endif
    QM_CONTEXT_DATA_REG_OFFSET,
    QM_CONTEXT_DATA_REG_RAM_CNT,
    4,
    86,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    QM_CONTEXT_DATA_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_FPM_BUFFER_RESERVATION_DATA
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_FPM_BUFFER_RESERVATION_DATA_FIELDS[] =
{
    &QM_FPM_BUFFER_RESERVATION_DATA_DATA_FIELD,
    &QM_FPM_BUFFER_RESERVATION_DATA_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_FPM_BUFFER_RESERVATION_DATA_REG = 
{
    "FPM_BUFFER_RESERVATION_DATA",
#if RU_INCLUDE_DESC
    "PROFILE %i Register",
    "Reserved FPM buffers in units of min. FPM buffer."
    "entry0 -> profile0"
    "..."
    "entry7 -> profile7",
#endif
    QM_FPM_BUFFER_RESERVATION_DATA_REG_OFFSET,
    QM_FPM_BUFFER_RESERVATION_DATA_REG_RAM_CNT,
    4,
    87,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    2,
    QM_FPM_BUFFER_RESERVATION_DATA_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_PORT_CFG
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_PORT_CFG_FIELDS[] =
{
    &QM_PORT_CFG_EN_BYTE_FIELD,
    &QM_PORT_CFG_EN_UG_FIELD,
    &QM_PORT_CFG_RESERVED0_FIELD,
    &QM_PORT_CFG_BBH_RX_BB_ID_FIELD,
    &QM_PORT_CFG_RESERVED1_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_PORT_CFG_REG = 
{
    "PORT_CFG",
#if RU_INCLUDE_DESC
    "PORT_CFG %i Register",
    "En -enable"
    "WAN or LAN"
    "BB_ID",
#endif
    QM_PORT_CFG_REG_OFFSET,
    QM_PORT_CFG_REG_RAM_CNT,
    4,
    88,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    5,
    QM_PORT_CFG_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_FC_UG_MASK
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_FC_UG_MASK_FIELDS[] =
{
    &QM_FC_UG_MASK_UG0_EN_FIELD,
    &QM_FC_UG_MASK_UG1_EN_FIELD,
    &QM_FC_UG_MASK_UG2_EN_FIELD,
    &QM_FC_UG_MASK_UG3_EN_FIELD,
    &QM_FC_UG_MASK_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_FC_UG_MASK_REG = 
{
    "FC_UG_MASK",
#if RU_INCLUDE_DESC
    "FC_UG_MASK Register",
    "Bit per UG:"
    "0 - UG is ignored during FC eval. drop enabled."
    "1 - FC is sent according to UG thresholds",
#endif
    QM_FC_UG_MASK_REG_OFFSET,
    0,
    0,
    89,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    5,
    QM_FC_UG_MASK_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_FC_QUEUE_MASK
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_FC_QUEUE_MASK_FIELDS[] =
{
    &QM_FC_QUEUE_MASK_QUEUE_VEC_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_FC_QUEUE_MASK_REG = 
{
    "FC_QUEUE_MASK",
#if RU_INCLUDE_DESC
    "FC_QUEUE_MASK %i Register",
    "FC queue mask. 1 bit per queue."
    "if 1 - FC is enable (unmasked)"
    "if 0 - FC is disable (masked)",
#endif
    QM_FC_QUEUE_MASK_REG_OFFSET,
    QM_FC_QUEUE_MASK_REG_RAM_CNT,
    4,
    90,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    QM_FC_QUEUE_MASK_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_DBG
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_DBG_FIELDS[] =
{
    &QM_DBG_STATUS_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_DBG_REG = 
{
    "DBG",
#if RU_INCLUDE_DESC
    "DBG Register",
    "dbg",
#endif
    QM_DBG_REG_OFFSET,
    0,
    0,
    91,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    QM_DBG_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_UG_OCCUPANCY_STATUS
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_UG_OCCUPANCY_STATUS_FIELDS[] =
{
    &QM_UG_OCCUPANCY_STATUS_QUEUE_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_UG_OCCUPANCY_STATUS_REG = 
{
    "UG_OCCUPANCY_STATUS",
#if RU_INCLUDE_DESC
    "UG_OCCUPANCY_STATUS Register",
    "4b per port (bit per UG)",
#endif
    QM_UG_OCCUPANCY_STATUS_REG_OFFSET,
    0,
    0,
    92,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    QM_UG_OCCUPANCY_STATUS_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_QUEUE_OCCUPANCY_STATUS
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_QUEUE_OCCUPANCY_STATUS_FIELDS[] =
{
    &QM_QUEUE_OCCUPANCY_STATUS_STATUS_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_QUEUE_OCCUPANCY_STATUS_REG = 
{
    "QUEUE_OCCUPANCY_STATUS",
#if RU_INCLUDE_DESC
    "QUEUE_OCCUPANCY_STATUS %i Register",
    "16B per queue x queues per port",
#endif
    QM_QUEUE_OCCUPANCY_STATUS_REG_OFFSET,
    QM_QUEUE_OCCUPANCY_STATUS_REG_RAM_CNT,
    4,
    93,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    QM_QUEUE_OCCUPANCY_STATUS_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_DEBUG_SEL
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_DEBUG_SEL_FIELDS[] =
{
    &QM_DEBUG_SEL_SELECT_FIELD,
    &QM_DEBUG_SEL_RESERVED0_FIELD,
    &QM_DEBUG_SEL_ENABLE_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_DEBUG_SEL_REG = 
{
    "DEBUG_SEL",
#if RU_INCLUDE_DESC
    "DEBUG_SEL Register",
    "Controls Debug bus select:"
    ""
    "5h1:  qm_dbg_bus = qm_bb_input_dbg_bus;"
    "5h2:  qm_dbg_bus = qm_bb_output_dbg_bus;"
    "5h3:  qm_dbg_bus = qm_cm_dbg_bus;"
    "5h4:  qm_dbg_bus = qm_ddr_write_dbg_bus;"
    "5h5:  qm_dbg_bus = qm_counters_dbg_bus;"
    "5h6:  qm_dbg_bus = qm_cpu_if_dbg_bus;"
    "5h7:  qm_dbg_bus = qm_dqm_push_dbg_bus;"
    "5h8:  qm_dbg_bus = qm_egress_dbg_bus;"
    "5h9:  qm_dbg_bus = qm_fpm_prefetch_dbg_bus;"
    "5ha:  qm_dbg_bus = qm_ingress_dbg_bus;"
    "5hb:  qm_dbg_bus = qm_rmt_fifos_dbg_bus;"
    "5hc:  qm_dbg_bus = {19b0,bbh_debug_0};"
    "5hd:  qm_dbg_bus = {19b0,bbh_debug_1};"
    "5he:  qm_dbg_bus = {19b0,bbh_debug_2};"
    "5hf:  qm_dbg_bus = {19b0,bbh_debug_3};"
    "5h10: qm_dbg_bus = {19b0,bbh_debug_4};"
    "5h11: qm_dbg_bus = {19b0,bbh_debug_5};"
    "5h12: qm_dbg_bus = {19b0,bbh_debug_6};"
    "5h13: qm_dbg_bus = {19b0,bbh_debug_7};"
    "5h14: qm_dbg_bus = {19b0,bbh_debug_8};"
    "5h15: qm_dbg_bus = {19b0,bbh_debug_9};"
    "5h16: qm_dbg_bus = {19b0,dma_debug_vec};"
    "5h17: qm_dbg_bus = {8b0,dqm_diag_r};"
    "",
#endif
    QM_DEBUG_SEL_REG_OFFSET,
    0,
    0,
    94,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    3,
    QM_DEBUG_SEL_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_DEBUG_BUS_LSB
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_DEBUG_BUS_LSB_FIELDS[] =
{
    &QM_DEBUG_BUS_LSB_DATA_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_DEBUG_BUS_LSB_REG = 
{
    "DEBUG_BUS_LSB",
#if RU_INCLUDE_DESC
    "DEBUG_BUS_LSB Register",
    "Debug Bus sampling",
#endif
    QM_DEBUG_BUS_LSB_REG_OFFSET,
    0,
    0,
    95,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    QM_DEBUG_BUS_LSB_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_DEBUG_BUS_MSB
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_DEBUG_BUS_MSB_FIELDS[] =
{
    &QM_DEBUG_BUS_MSB_DATA_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_DEBUG_BUS_MSB_REG = 
{
    "DEBUG_BUS_MSB",
#if RU_INCLUDE_DESC
    "DEBUG_BUS_MSB Register",
    "Debug Bus sampling",
#endif
    QM_DEBUG_BUS_MSB_REG_OFFSET,
    0,
    0,
    96,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    QM_DEBUG_BUS_MSB_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_QM_SPARE_CONFIG
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_QM_SPARE_CONFIG_FIELDS[] =
{
    &QM_QM_SPARE_CONFIG_DATA_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_QM_SPARE_CONFIG_REG = 
{
    "QM_SPARE_CONFIG",
#if RU_INCLUDE_DESC
    "QM_SPARE_CONFIG Register",
    "Spare configuration for ECO purposes",
#endif
    QM_QM_SPARE_CONFIG_REG_OFFSET,
    0,
    0,
    97,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    QM_QM_SPARE_CONFIG_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_GOOD_LVL1_PKTS_CNT
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_GOOD_LVL1_PKTS_CNT_FIELDS[] =
{
    &QM_GOOD_LVL1_PKTS_CNT_COUNTER_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_GOOD_LVL1_PKTS_CNT_REG = 
{
    "GOOD_LVL1_PKTS_CNT",
#if RU_INCLUDE_DESC
    "GOOD_LVL1_PKTS_CNT Register",
    "Counts the total number of non-dropped and non-reprocessing packets from all queues",
#endif
    QM_GOOD_LVL1_PKTS_CNT_REG_OFFSET,
    0,
    0,
    98,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    QM_GOOD_LVL1_PKTS_CNT_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_GOOD_LVL1_BYTES_CNT
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_GOOD_LVL1_BYTES_CNT_FIELDS[] =
{
    &QM_GOOD_LVL1_BYTES_CNT_COUNTER_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_GOOD_LVL1_BYTES_CNT_REG = 
{
    "GOOD_LVL1_BYTES_CNT",
#if RU_INCLUDE_DESC
    "GOOD_LVL1_BYTES_CNT Register",
    "Counts the total number of non-dropped and non-reprocessing bytes from all queues",
#endif
    QM_GOOD_LVL1_BYTES_CNT_REG_OFFSET,
    0,
    0,
    99,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    QM_GOOD_LVL1_BYTES_CNT_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_GOOD_LVL2_PKTS_CNT
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_GOOD_LVL2_PKTS_CNT_FIELDS[] =
{
    &QM_GOOD_LVL2_PKTS_CNT_COUNTER_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_GOOD_LVL2_PKTS_CNT_REG = 
{
    "GOOD_LVL2_PKTS_CNT",
#if RU_INCLUDE_DESC
    "GOOD_LVL2_PKTS_CNT Register",
    "Counts the total number of non-dropped and reprocessing packets from all queues",
#endif
    QM_GOOD_LVL2_PKTS_CNT_REG_OFFSET,
    0,
    0,
    100,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    QM_GOOD_LVL2_PKTS_CNT_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_GOOD_LVL2_BYTES_CNT
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_GOOD_LVL2_BYTES_CNT_FIELDS[] =
{
    &QM_GOOD_LVL2_BYTES_CNT_COUNTER_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_GOOD_LVL2_BYTES_CNT_REG = 
{
    "GOOD_LVL2_BYTES_CNT",
#if RU_INCLUDE_DESC
    "GOOD_LVL2_BYTES_CNT Register",
    "Counts the total number of non-dropped and reprocessing bytes from all queues",
#endif
    QM_GOOD_LVL2_BYTES_CNT_REG_OFFSET,
    0,
    0,
    101,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    QM_GOOD_LVL2_BYTES_CNT_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_COPIED_PKTS_CNT
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_COPIED_PKTS_CNT_FIELDS[] =
{
    &QM_COPIED_PKTS_CNT_COUNTER_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_COPIED_PKTS_CNT_REG = 
{
    "COPIED_PKTS_CNT",
#if RU_INCLUDE_DESC
    "COPIED_PKTS_CNT Register",
    "Counts the total number of copied packets to the DDR from all queues",
#endif
    QM_COPIED_PKTS_CNT_REG_OFFSET,
    0,
    0,
    102,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    QM_COPIED_PKTS_CNT_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_COPIED_BYTES_CNT
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_COPIED_BYTES_CNT_FIELDS[] =
{
    &QM_COPIED_BYTES_CNT_COUNTER_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_COPIED_BYTES_CNT_REG = 
{
    "COPIED_BYTES_CNT",
#if RU_INCLUDE_DESC
    "COPIED_BYTES_CNT Register",
    "Counts the total number of copied bytes to the DDR from all queues",
#endif
    QM_COPIED_BYTES_CNT_REG_OFFSET,
    0,
    0,
    103,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    QM_COPIED_BYTES_CNT_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_AGG_PKTS_CNT
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_AGG_PKTS_CNT_FIELDS[] =
{
    &QM_AGG_PKTS_CNT_COUNTER_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_AGG_PKTS_CNT_REG = 
{
    "AGG_PKTS_CNT",
#if RU_INCLUDE_DESC
    "AGG_PKTS_CNT Register",
    "Counts the total number of aggregated packets from all queues",
#endif
    QM_AGG_PKTS_CNT_REG_OFFSET,
    0,
    0,
    104,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    QM_AGG_PKTS_CNT_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_AGG_BYTES_CNT
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_AGG_BYTES_CNT_FIELDS[] =
{
    &QM_AGG_BYTES_CNT_COUNTER_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_AGG_BYTES_CNT_REG = 
{
    "AGG_BYTES_CNT",
#if RU_INCLUDE_DESC
    "AGG_BYTES_CNT Register",
    "Counts the total number of aggregated bytes from all queues",
#endif
    QM_AGG_BYTES_CNT_REG_OFFSET,
    0,
    0,
    105,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    QM_AGG_BYTES_CNT_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_AGG_1_PKTS_CNT
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_AGG_1_PKTS_CNT_FIELDS[] =
{
    &QM_AGG_1_PKTS_CNT_COUNTER_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_AGG_1_PKTS_CNT_REG = 
{
    "AGG_1_PKTS_CNT",
#if RU_INCLUDE_DESC
    "AGG_1_PKTS_CNT Register",
    "Counts the total number of packets aggregated in a 1-packet PD from all queues",
#endif
    QM_AGG_1_PKTS_CNT_REG_OFFSET,
    0,
    0,
    106,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    QM_AGG_1_PKTS_CNT_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_AGG_2_PKTS_CNT
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_AGG_2_PKTS_CNT_FIELDS[] =
{
    &QM_AGG_2_PKTS_CNT_COUNTER_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_AGG_2_PKTS_CNT_REG = 
{
    "AGG_2_PKTS_CNT",
#if RU_INCLUDE_DESC
    "AGG_2_PKTS_CNT Register",
    "Counts the total number of packets aggregated in a 2-packet PD from all queues",
#endif
    QM_AGG_2_PKTS_CNT_REG_OFFSET,
    0,
    0,
    107,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    QM_AGG_2_PKTS_CNT_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_AGG_3_PKTS_CNT
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_AGG_3_PKTS_CNT_FIELDS[] =
{
    &QM_AGG_3_PKTS_CNT_COUNTER_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_AGG_3_PKTS_CNT_REG = 
{
    "AGG_3_PKTS_CNT",
#if RU_INCLUDE_DESC
    "AGG_3_PKTS_CNT Register",
    "Counts the total number of packets aggregated in a 3-packet PD from all queues",
#endif
    QM_AGG_3_PKTS_CNT_REG_OFFSET,
    0,
    0,
    108,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    QM_AGG_3_PKTS_CNT_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_AGG_4_PKTS_CNT
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_AGG_4_PKTS_CNT_FIELDS[] =
{
    &QM_AGG_4_PKTS_CNT_COUNTER_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_AGG_4_PKTS_CNT_REG = 
{
    "AGG_4_PKTS_CNT",
#if RU_INCLUDE_DESC
    "AGG_4_PKTS_CNT Register",
    "Counts the total number of packets aggregated in a 4-packet PD from all queues",
#endif
    QM_AGG_4_PKTS_CNT_REG_OFFSET,
    0,
    0,
    109,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    QM_AGG_4_PKTS_CNT_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_WRED_DROP_CNT
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_WRED_DROP_CNT_FIELDS[] =
{
    &QM_WRED_DROP_CNT_COUNTER_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_WRED_DROP_CNT_REG = 
{
    "WRED_DROP_CNT",
#if RU_INCLUDE_DESC
    "WRED_DROP_CNT Register",
    "Counts the total number of packets dropped from all queues due to WRED",
#endif
    QM_WRED_DROP_CNT_REG_OFFSET,
    0,
    0,
    110,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    QM_WRED_DROP_CNT_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_FPM_CONGESTION_DROP_CNT
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_FPM_CONGESTION_DROP_CNT_FIELDS[] =
{
    &QM_FPM_CONGESTION_DROP_CNT_COUNTER_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_FPM_CONGESTION_DROP_CNT_REG = 
{
    "FPM_CONGESTION_DROP_CNT",
#if RU_INCLUDE_DESC
    "FPM_CONGESTION_DROP_CNT Register",
    "Counts the total number of packets dropped from all queues due to FPM congestion indication",
#endif
    QM_FPM_CONGESTION_DROP_CNT_REG_OFFSET,
    0,
    0,
    111,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    QM_FPM_CONGESTION_DROP_CNT_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_DDR_PD_CONGESTION_DROP_CNT
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_DDR_PD_CONGESTION_DROP_CNT_FIELDS[] =
{
    &QM_DDR_PD_CONGESTION_DROP_CNT_COUNTER_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_DDR_PD_CONGESTION_DROP_CNT_REG = 
{
    "DDR_PD_CONGESTION_DROP_CNT",
#if RU_INCLUDE_DESC
    "DDR_PD_CONGESTION_DROP_CNT Register",
    "Counts the total number of packets dropped from all queues due to DDR PD congestion",
#endif
    QM_DDR_PD_CONGESTION_DROP_CNT_REG_OFFSET,
    0,
    0,
    112,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    QM_DDR_PD_CONGESTION_DROP_CNT_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_DDR_BYTE_CONGESTION_DROP_CNT
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_DDR_BYTE_CONGESTION_DROP_CNT_FIELDS[] =
{
    &QM_DDR_BYTE_CONGESTION_DROP_CNT_COUNTER_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_DDR_BYTE_CONGESTION_DROP_CNT_REG = 
{
    "DDR_BYTE_CONGESTION_DROP_CNT",
#if RU_INCLUDE_DESC
    "DDR_BYTE_CONGESTION_DROP_CNT Register",
    "Counts the total number of packets dropped from all queues due to DDR byte congestion (number of bytes waiting to be copied exceeded the thresholds)",
#endif
    QM_DDR_BYTE_CONGESTION_DROP_CNT_REG_OFFSET,
    0,
    0,
    113,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    QM_DDR_BYTE_CONGESTION_DROP_CNT_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_QM_PD_CONGESTION_DROP_CNT
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_QM_PD_CONGESTION_DROP_CNT_FIELDS[] =
{
    &QM_QM_PD_CONGESTION_DROP_CNT_COUNTER_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_QM_PD_CONGESTION_DROP_CNT_REG = 
{
    "QM_PD_CONGESTION_DROP_CNT",
#if RU_INCLUDE_DESC
    "QM_PD_CONGESTION_DROP_CNT Register",
    "Counts the total number of packets dropped from all queues due to QM PD congestion (this value is limited by the DQM)",
#endif
    QM_QM_PD_CONGESTION_DROP_CNT_REG_OFFSET,
    0,
    0,
    114,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    QM_QM_PD_CONGESTION_DROP_CNT_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_QM_ABS_REQUEUE_CNT
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_QM_ABS_REQUEUE_CNT_FIELDS[] =
{
    &QM_QM_ABS_REQUEUE_CNT_COUNTER_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_QM_ABS_REQUEUE_CNT_REG = 
{
    "QM_ABS_REQUEUE_CNT",
#if RU_INCLUDE_DESC
    "QM_ABS_REQUEUE_CNT Register",
    "Counts the total number of packets requeued due to absolute address drops from all queues",
#endif
    QM_QM_ABS_REQUEUE_CNT_REG_OFFSET,
    0,
    0,
    115,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    QM_QM_ABS_REQUEUE_CNT_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_FPM_PREFETCH_FIFO0_STATUS
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_FPM_PREFETCH_FIFO0_STATUS_FIELDS[] =
{
    &QM_FPM_PREFETCH_FIFO0_STATUS_USED_WORDS_FIELD,
    &QM_FPM_PREFETCH_FIFO0_STATUS_EMPTY_FIELD,
    &QM_FPM_PREFETCH_FIFO0_STATUS_FULL_FIELD,
    &QM_FPM_PREFETCH_FIFO0_STATUS_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_FPM_PREFETCH_FIFO0_STATUS_REG = 
{
    "FPM_PREFETCH_FIFO0_STATUS",
#if RU_INCLUDE_DESC
    "FPM_PREFETCH_FIFO0_STATUS Register",
    "Holds the FIFO Status",
#endif
    QM_FPM_PREFETCH_FIFO0_STATUS_REG_OFFSET,
    0,
    0,
    116,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    4,
    QM_FPM_PREFETCH_FIFO0_STATUS_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_FPM_PREFETCH_FIFO1_STATUS
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_FPM_PREFETCH_FIFO1_STATUS_FIELDS[] =
{
    &QM_FPM_PREFETCH_FIFO1_STATUS_USED_WORDS_FIELD,
    &QM_FPM_PREFETCH_FIFO1_STATUS_EMPTY_FIELD,
    &QM_FPM_PREFETCH_FIFO1_STATUS_FULL_FIELD,
    &QM_FPM_PREFETCH_FIFO1_STATUS_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_FPM_PREFETCH_FIFO1_STATUS_REG = 
{
    "FPM_PREFETCH_FIFO1_STATUS",
#if RU_INCLUDE_DESC
    "FPM_PREFETCH_FIFO1_STATUS Register",
    "Holds the FIFO Status",
#endif
    QM_FPM_PREFETCH_FIFO1_STATUS_REG_OFFSET,
    0,
    0,
    117,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    4,
    QM_FPM_PREFETCH_FIFO1_STATUS_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_FPM_PREFETCH_FIFO2_STATUS
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_FPM_PREFETCH_FIFO2_STATUS_FIELDS[] =
{
    &QM_FPM_PREFETCH_FIFO2_STATUS_USED_WORDS_FIELD,
    &QM_FPM_PREFETCH_FIFO2_STATUS_EMPTY_FIELD,
    &QM_FPM_PREFETCH_FIFO2_STATUS_FULL_FIELD,
    &QM_FPM_PREFETCH_FIFO2_STATUS_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_FPM_PREFETCH_FIFO2_STATUS_REG = 
{
    "FPM_PREFETCH_FIFO2_STATUS",
#if RU_INCLUDE_DESC
    "FPM_PREFETCH_FIFO2_STATUS Register",
    "Holds the FIFO Status",
#endif
    QM_FPM_PREFETCH_FIFO2_STATUS_REG_OFFSET,
    0,
    0,
    118,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    4,
    QM_FPM_PREFETCH_FIFO2_STATUS_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_FPM_PREFETCH_FIFO3_STATUS
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_FPM_PREFETCH_FIFO3_STATUS_FIELDS[] =
{
    &QM_FPM_PREFETCH_FIFO3_STATUS_USED_WORDS_FIELD,
    &QM_FPM_PREFETCH_FIFO3_STATUS_EMPTY_FIELD,
    &QM_FPM_PREFETCH_FIFO3_STATUS_FULL_FIELD,
    &QM_FPM_PREFETCH_FIFO3_STATUS_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_FPM_PREFETCH_FIFO3_STATUS_REG = 
{
    "FPM_PREFETCH_FIFO3_STATUS",
#if RU_INCLUDE_DESC
    "FPM_PREFETCH_FIFO3_STATUS Register",
    "Holds the FIFO Status",
#endif
    QM_FPM_PREFETCH_FIFO3_STATUS_REG_OFFSET,
    0,
    0,
    119,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    4,
    QM_FPM_PREFETCH_FIFO3_STATUS_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_NORMAL_RMT_FIFO_STATUS
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_NORMAL_RMT_FIFO_STATUS_FIELDS[] =
{
    &QM_NORMAL_RMT_FIFO_STATUS_USED_WORDS_FIELD,
    &QM_NORMAL_RMT_FIFO_STATUS_EMPTY_FIELD,
    &QM_NORMAL_RMT_FIFO_STATUS_FULL_FIELD,
    &QM_NORMAL_RMT_FIFO_STATUS_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_NORMAL_RMT_FIFO_STATUS_REG = 
{
    "NORMAL_RMT_FIFO_STATUS",
#if RU_INCLUDE_DESC
    "NORMAL_RMT_FIFO_STATUS Register",
    "Holds the FIFO Status",
#endif
    QM_NORMAL_RMT_FIFO_STATUS_REG_OFFSET,
    0,
    0,
    120,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    4,
    QM_NORMAL_RMT_FIFO_STATUS_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_NON_DELAYED_RMT_FIFO_STATUS
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_NON_DELAYED_RMT_FIFO_STATUS_FIELDS[] =
{
    &QM_NON_DELAYED_RMT_FIFO_STATUS_USED_WORDS_FIELD,
    &QM_NON_DELAYED_RMT_FIFO_STATUS_EMPTY_FIELD,
    &QM_NON_DELAYED_RMT_FIFO_STATUS_FULL_FIELD,
    &QM_NON_DELAYED_RMT_FIFO_STATUS_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_NON_DELAYED_RMT_FIFO_STATUS_REG = 
{
    "NON_DELAYED_RMT_FIFO_STATUS",
#if RU_INCLUDE_DESC
    "NON_DELAYED_RMT_FIFO_STATUS Register",
    "Holds the FIFO Status",
#endif
    QM_NON_DELAYED_RMT_FIFO_STATUS_REG_OFFSET,
    0,
    0,
    121,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    4,
    QM_NON_DELAYED_RMT_FIFO_STATUS_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_NON_DELAYED_OUT_FIFO_STATUS
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_NON_DELAYED_OUT_FIFO_STATUS_FIELDS[] =
{
    &QM_NON_DELAYED_OUT_FIFO_STATUS_USED_WORDS_FIELD,
    &QM_NON_DELAYED_OUT_FIFO_STATUS_EMPTY_FIELD,
    &QM_NON_DELAYED_OUT_FIFO_STATUS_FULL_FIELD,
    &QM_NON_DELAYED_OUT_FIFO_STATUS_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_NON_DELAYED_OUT_FIFO_STATUS_REG = 
{
    "NON_DELAYED_OUT_FIFO_STATUS",
#if RU_INCLUDE_DESC
    "NON_DELAYED_OUT_FIFO_STATUS Register",
    "Holds the FIFO Status",
#endif
    QM_NON_DELAYED_OUT_FIFO_STATUS_REG_OFFSET,
    0,
    0,
    122,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    4,
    QM_NON_DELAYED_OUT_FIFO_STATUS_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_PRE_CM_FIFO_STATUS
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_PRE_CM_FIFO_STATUS_FIELDS[] =
{
    &QM_PRE_CM_FIFO_STATUS_USED_WORDS_FIELD,
    &QM_PRE_CM_FIFO_STATUS_EMPTY_FIELD,
    &QM_PRE_CM_FIFO_STATUS_FULL_FIELD,
    &QM_PRE_CM_FIFO_STATUS_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_PRE_CM_FIFO_STATUS_REG = 
{
    "PRE_CM_FIFO_STATUS",
#if RU_INCLUDE_DESC
    "PRE_CM_FIFO_STATUS Register",
    "Holds the FIFO Status",
#endif
    QM_PRE_CM_FIFO_STATUS_REG_OFFSET,
    0,
    0,
    123,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    4,
    QM_PRE_CM_FIFO_STATUS_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_CM_RD_PD_FIFO_STATUS
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_CM_RD_PD_FIFO_STATUS_FIELDS[] =
{
    &QM_CM_RD_PD_FIFO_STATUS_USED_WORDS_FIELD,
    &QM_CM_RD_PD_FIFO_STATUS_EMPTY_FIELD,
    &QM_CM_RD_PD_FIFO_STATUS_FULL_FIELD,
    &QM_CM_RD_PD_FIFO_STATUS_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_CM_RD_PD_FIFO_STATUS_REG = 
{
    "CM_RD_PD_FIFO_STATUS",
#if RU_INCLUDE_DESC
    "CM_RD_PD_FIFO_STATUS Register",
    "Holds the FIFO Status",
#endif
    QM_CM_RD_PD_FIFO_STATUS_REG_OFFSET,
    0,
    0,
    124,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    4,
    QM_CM_RD_PD_FIFO_STATUS_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_CM_WR_PD_FIFO_STATUS
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_CM_WR_PD_FIFO_STATUS_FIELDS[] =
{
    &QM_CM_WR_PD_FIFO_STATUS_USED_WORDS_FIELD,
    &QM_CM_WR_PD_FIFO_STATUS_EMPTY_FIELD,
    &QM_CM_WR_PD_FIFO_STATUS_FULL_FIELD,
    &QM_CM_WR_PD_FIFO_STATUS_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_CM_WR_PD_FIFO_STATUS_REG = 
{
    "CM_WR_PD_FIFO_STATUS",
#if RU_INCLUDE_DESC
    "CM_WR_PD_FIFO_STATUS Register",
    "Holds the FIFO Status",
#endif
    QM_CM_WR_PD_FIFO_STATUS_REG_OFFSET,
    0,
    0,
    125,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    4,
    QM_CM_WR_PD_FIFO_STATUS_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_CM_COMMON_INPUT_FIFO_STATUS
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_CM_COMMON_INPUT_FIFO_STATUS_FIELDS[] =
{
    &QM_CM_COMMON_INPUT_FIFO_STATUS_USED_WORDS_FIELD,
    &QM_CM_COMMON_INPUT_FIFO_STATUS_EMPTY_FIELD,
    &QM_CM_COMMON_INPUT_FIFO_STATUS_FULL_FIELD,
    &QM_CM_COMMON_INPUT_FIFO_STATUS_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_CM_COMMON_INPUT_FIFO_STATUS_REG = 
{
    "CM_COMMON_INPUT_FIFO_STATUS",
#if RU_INCLUDE_DESC
    "CM_COMMON_INPUT_FIFO_STATUS Register",
    "Holds the FIFO Status",
#endif
    QM_CM_COMMON_INPUT_FIFO_STATUS_REG_OFFSET,
    0,
    0,
    126,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    4,
    QM_CM_COMMON_INPUT_FIFO_STATUS_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_BB0_OUTPUT_FIFO_STATUS
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_BB0_OUTPUT_FIFO_STATUS_FIELDS[] =
{
    &QM_BB0_OUTPUT_FIFO_STATUS_USED_WORDS_FIELD,
    &QM_BB0_OUTPUT_FIFO_STATUS_EMPTY_FIELD,
    &QM_BB0_OUTPUT_FIFO_STATUS_FULL_FIELD,
    &QM_BB0_OUTPUT_FIFO_STATUS_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_BB0_OUTPUT_FIFO_STATUS_REG = 
{
    "BB0_OUTPUT_FIFO_STATUS",
#if RU_INCLUDE_DESC
    "BB0_OUTPUT_FIFO_STATUS Register",
    "Holds the FIFO Status",
#endif
    QM_BB0_OUTPUT_FIFO_STATUS_REG_OFFSET,
    0,
    0,
    127,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    4,
    QM_BB0_OUTPUT_FIFO_STATUS_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_BB1_OUTPUT_FIFO_STATUS
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_BB1_OUTPUT_FIFO_STATUS_FIELDS[] =
{
    &QM_BB1_OUTPUT_FIFO_STATUS_USED_WORDS_FIELD,
    &QM_BB1_OUTPUT_FIFO_STATUS_EMPTY_FIELD,
    &QM_BB1_OUTPUT_FIFO_STATUS_FULL_FIELD,
    &QM_BB1_OUTPUT_FIFO_STATUS_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_BB1_OUTPUT_FIFO_STATUS_REG = 
{
    "BB1_OUTPUT_FIFO_STATUS",
#if RU_INCLUDE_DESC
    "BB1_OUTPUT_FIFO_STATUS Register",
    "Holds the FIFO Status",
#endif
    QM_BB1_OUTPUT_FIFO_STATUS_REG_OFFSET,
    0,
    0,
    128,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    4,
    QM_BB1_OUTPUT_FIFO_STATUS_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_BB1_INPUT_FIFO_STATUS
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_BB1_INPUT_FIFO_STATUS_FIELDS[] =
{
    &QM_BB1_INPUT_FIFO_STATUS_USED_WORDS_FIELD,
    &QM_BB1_INPUT_FIFO_STATUS_EMPTY_FIELD,
    &QM_BB1_INPUT_FIFO_STATUS_FULL_FIELD,
    &QM_BB1_INPUT_FIFO_STATUS_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_BB1_INPUT_FIFO_STATUS_REG = 
{
    "BB1_INPUT_FIFO_STATUS",
#if RU_INCLUDE_DESC
    "BB1_INPUT_FIFO_STATUS Register",
    "Holds the FIFO Status",
#endif
    QM_BB1_INPUT_FIFO_STATUS_REG_OFFSET,
    0,
    0,
    129,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    4,
    QM_BB1_INPUT_FIFO_STATUS_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_EGRESS_DATA_FIFO_STATUS
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_EGRESS_DATA_FIFO_STATUS_FIELDS[] =
{
    &QM_EGRESS_DATA_FIFO_STATUS_USED_WORDS_FIELD,
    &QM_EGRESS_DATA_FIFO_STATUS_EMPTY_FIELD,
    &QM_EGRESS_DATA_FIFO_STATUS_FULL_FIELD,
    &QM_EGRESS_DATA_FIFO_STATUS_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_EGRESS_DATA_FIFO_STATUS_REG = 
{
    "EGRESS_DATA_FIFO_STATUS",
#if RU_INCLUDE_DESC
    "EGRESS_DATA_FIFO_STATUS Register",
    "Holds the FIFO Status",
#endif
    QM_EGRESS_DATA_FIFO_STATUS_REG_OFFSET,
    0,
    0,
    130,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    4,
    QM_EGRESS_DATA_FIFO_STATUS_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_EGRESS_RR_FIFO_STATUS
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_EGRESS_RR_FIFO_STATUS_FIELDS[] =
{
    &QM_EGRESS_RR_FIFO_STATUS_USED_WORDS_FIELD,
    &QM_EGRESS_RR_FIFO_STATUS_EMPTY_FIELD,
    &QM_EGRESS_RR_FIFO_STATUS_FULL_FIELD,
    &QM_EGRESS_RR_FIFO_STATUS_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_EGRESS_RR_FIFO_STATUS_REG = 
{
    "EGRESS_RR_FIFO_STATUS",
#if RU_INCLUDE_DESC
    "EGRESS_RR_FIFO_STATUS Register",
    "Holds the FIFO Status",
#endif
    QM_EGRESS_RR_FIFO_STATUS_REG_OFFSET,
    0,
    0,
    131,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    4,
    QM_EGRESS_RR_FIFO_STATUS_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_BB_ROUTE_OVR
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_BB_ROUTE_OVR_FIELDS[] =
{
    &QM_BB_ROUTE_OVR_OVR_EN_FIELD,
    &QM_BB_ROUTE_OVR_RESERVED0_FIELD,
    &QM_BB_ROUTE_OVR_DEST_ID_FIELD,
    &QM_BB_ROUTE_OVR_RESERVED1_FIELD,
    &QM_BB_ROUTE_OVR_ROUTE_ADDR_FIELD,
    &QM_BB_ROUTE_OVR_RESERVED2_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_BB_ROUTE_OVR_REG = 
{
    "BB_ROUTE_OVR",
#if RU_INCLUDE_DESC
    "BB_ROUTE_OVR %i Register",
    "BB ROUTE Override:"
    "0 - for QM_TOP"
    "1 - for RNR_GRID",
#endif
    QM_BB_ROUTE_OVR_REG_OFFSET,
    QM_BB_ROUTE_OVR_REG_RAM_CNT,
    4,
    132,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    6,
    QM_BB_ROUTE_OVR_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_QM_INGRESS_STAT
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_QM_INGRESS_STAT_FIELDS[] =
{
    &QM_QM_INGRESS_STAT_STAT_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_QM_INGRESS_STAT_REG = 
{
    "QM_INGRESS_STAT",
#if RU_INCLUDE_DESC
    "QM_INGRESS_STAT Register",
    "Holds the Ingress Status",
#endif
    QM_QM_INGRESS_STAT_REG_OFFSET,
    0,
    0,
    133,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    QM_QM_INGRESS_STAT_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_QM_EGRESS_STAT
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_QM_EGRESS_STAT_FIELDS[] =
{
    &QM_QM_EGRESS_STAT_STAT_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_QM_EGRESS_STAT_REG = 
{
    "QM_EGRESS_STAT",
#if RU_INCLUDE_DESC
    "QM_EGRESS_STAT Register",
    "Holds the Egress Status",
#endif
    QM_QM_EGRESS_STAT_REG_OFFSET,
    0,
    0,
    134,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    QM_QM_EGRESS_STAT_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_QM_CM_STAT
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_QM_CM_STAT_FIELDS[] =
{
    &QM_QM_CM_STAT_STAT_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_QM_CM_STAT_REG = 
{
    "QM_CM_STAT",
#if RU_INCLUDE_DESC
    "QM_CM_STAT Register",
    "Holds the CM Status",
#endif
    QM_QM_CM_STAT_REG_OFFSET,
    0,
    0,
    135,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    QM_QM_CM_STAT_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_QM_FPM_PREFETCH_STAT
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_QM_FPM_PREFETCH_STAT_FIELDS[] =
{
    &QM_QM_FPM_PREFETCH_STAT_STAT_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_QM_FPM_PREFETCH_STAT_REG = 
{
    "QM_FPM_PREFETCH_STAT",
#if RU_INCLUDE_DESC
    "QM_FPM_PREFETCH_STAT Register",
    "Holds the FPM Prefetch Status",
#endif
    QM_QM_FPM_PREFETCH_STAT_REG_OFFSET,
    0,
    0,
    136,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    QM_QM_FPM_PREFETCH_STAT_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_QM_CONNECT_ACK_COUNTER
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_QM_CONNECT_ACK_COUNTER_FIELDS[] =
{
    &QM_QM_CONNECT_ACK_COUNTER_CONNECT_ACK_COUNTER_FIELD,
    &QM_QM_CONNECT_ACK_COUNTER_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_QM_CONNECT_ACK_COUNTER_REG = 
{
    "QM_CONNECT_ACK_COUNTER",
#if RU_INCLUDE_DESC
    "QM_CONNECT_ACK_COUNTER Register",
    "QM connect ack counter",
#endif
    QM_QM_CONNECT_ACK_COUNTER_REG_OFFSET,
    0,
    0,
    137,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    2,
    QM_QM_CONNECT_ACK_COUNTER_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_QM_DDR_WR_REPLY_COUNTER
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_QM_DDR_WR_REPLY_COUNTER_FIELDS[] =
{
    &QM_QM_DDR_WR_REPLY_COUNTER_DDR_WR_REPLY_COUNTER_FIELD,
    &QM_QM_DDR_WR_REPLY_COUNTER_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_QM_DDR_WR_REPLY_COUNTER_REG = 
{
    "QM_DDR_WR_REPLY_COUNTER",
#if RU_INCLUDE_DESC
    "QM_DDR_WR_REPLY_COUNTER Register",
    "QM DDR WR reply Counter",
#endif
    QM_QM_DDR_WR_REPLY_COUNTER_REG_OFFSET,
    0,
    0,
    138,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    2,
    QM_QM_DDR_WR_REPLY_COUNTER_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_QM_DDR_PIPE_BYTE_COUNTER
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_QM_DDR_PIPE_BYTE_COUNTER_FIELDS[] =
{
    &QM_QM_DDR_PIPE_BYTE_COUNTER_COUNTER_FIELD,
    &QM_QM_DDR_PIPE_BYTE_COUNTER_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_QM_DDR_PIPE_BYTE_COUNTER_REG = 
{
    "QM_DDR_PIPE_BYTE_COUNTER",
#if RU_INCLUDE_DESC
    "QM_DDR_PIPE_BYTE_COUNTER Register",
    "QM DDR pipe byte counter",
#endif
    QM_QM_DDR_PIPE_BYTE_COUNTER_REG_OFFSET,
    0,
    0,
    139,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    2,
    QM_QM_DDR_PIPE_BYTE_COUNTER_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_QM_ABS_REQUEUE_VALID_COUNTER
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_QM_ABS_REQUEUE_VALID_COUNTER_FIELDS[] =
{
    &QM_QM_ABS_REQUEUE_VALID_COUNTER_COUNTER_FIELD,
    &QM_QM_ABS_REQUEUE_VALID_COUNTER_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_QM_ABS_REQUEUE_VALID_COUNTER_REG = 
{
    "QM_ABS_REQUEUE_VALID_COUNTER",
#if RU_INCLUDE_DESC
    "QM_ABS_REQUEUE_VALID_COUNTER Register",
    "Indicates the number of PDs currently in the Absolute address drop queue.",
#endif
    QM_QM_ABS_REQUEUE_VALID_COUNTER_REG_OFFSET,
    0,
    0,
    140,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    2,
    QM_QM_ABS_REQUEUE_VALID_COUNTER_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_QM_ILLEGAL_PD_CAPTURE
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_QM_ILLEGAL_PD_CAPTURE_FIELDS[] =
{
    &QM_QM_ILLEGAL_PD_CAPTURE_PD_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_QM_ILLEGAL_PD_CAPTURE_REG = 
{
    "QM_ILLEGAL_PD_CAPTURE",
#if RU_INCLUDE_DESC
    "QM_ILLEGAL_PD_CAPTURE %i Register",
    "PD captured when an illegal PD was detected and the relevant interrupt was generated.",
#endif
    QM_QM_ILLEGAL_PD_CAPTURE_REG_OFFSET,
    QM_QM_ILLEGAL_PD_CAPTURE_REG_RAM_CNT,
    4,
    141,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    QM_QM_ILLEGAL_PD_CAPTURE_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_QM_INGRESS_PROCESSED_PD_CAPTURE
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_QM_INGRESS_PROCESSED_PD_CAPTURE_FIELDS[] =
{
    &QM_QM_INGRESS_PROCESSED_PD_CAPTURE_PD_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_QM_INGRESS_PROCESSED_PD_CAPTURE_REG = 
{
    "QM_INGRESS_PROCESSED_PD_CAPTURE",
#if RU_INCLUDE_DESC
    "QM_INGRESS_PROCESSED_PD_CAPTURE %i Register",
    "Last ingress processed PD capture",
#endif
    QM_QM_INGRESS_PROCESSED_PD_CAPTURE_REG_OFFSET,
    QM_QM_INGRESS_PROCESSED_PD_CAPTURE_REG_RAM_CNT,
    4,
    142,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    QM_QM_INGRESS_PROCESSED_PD_CAPTURE_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_QM_CM_PROCESSED_PD_CAPTURE
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_QM_CM_PROCESSED_PD_CAPTURE_FIELDS[] =
{
    &QM_QM_CM_PROCESSED_PD_CAPTURE_PD_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_QM_CM_PROCESSED_PD_CAPTURE_REG = 
{
    "QM_CM_PROCESSED_PD_CAPTURE",
#if RU_INCLUDE_DESC
    "QM_CM_PROCESSED_PD_CAPTURE %i Register",
    "Last copy machine processed PD capture",
#endif
    QM_QM_CM_PROCESSED_PD_CAPTURE_REG_OFFSET,
    QM_QM_CM_PROCESSED_PD_CAPTURE_REG_RAM_CNT,
    4,
    143,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    QM_QM_CM_PROCESSED_PD_CAPTURE_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_FPM_POOL_DROP_CNT
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_FPM_POOL_DROP_CNT_FIELDS[] =
{
    &QM_FPM_POOL_DROP_CNT_COUNTER_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_FPM_POOL_DROP_CNT_REG = 
{
    "FPM_POOL_DROP_CNT",
#if RU_INCLUDE_DESC
    "FPM_POOL_DROP_CNT %i Register",
    "Counts the total number of packets dropped for all queues due to FPM pool priority thresholds. Counter per pool",
#endif
    QM_FPM_POOL_DROP_CNT_REG_OFFSET,
    QM_FPM_POOL_DROP_CNT_REG_RAM_CNT,
    4,
    144,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    QM_FPM_POOL_DROP_CNT_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_FPM_GRP_DROP_CNT
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_FPM_GRP_DROP_CNT_FIELDS[] =
{
    &QM_FPM_GRP_DROP_CNT_COUNTER_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_FPM_GRP_DROP_CNT_REG = 
{
    "FPM_GRP_DROP_CNT",
#if RU_INCLUDE_DESC
    "FPM_GRP_DROP_CNT %i Register",
    "Counts the total number of packets dropped from all queues due to FPM user group priority thresholds. Counter per UG (0-3)",
#endif
    QM_FPM_GRP_DROP_CNT_REG_OFFSET,
    QM_FPM_GRP_DROP_CNT_REG_RAM_CNT,
    4,
    145,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    QM_FPM_GRP_DROP_CNT_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_FPM_BUFFER_RES_DROP_CNT
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_FPM_BUFFER_RES_DROP_CNT_FIELDS[] =
{
    &QM_FPM_BUFFER_RES_DROP_CNT_COUNTER_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_FPM_BUFFER_RES_DROP_CNT_REG = 
{
    "FPM_BUFFER_RES_DROP_CNT",
#if RU_INCLUDE_DESC
    "FPM_BUFFER_RES_DROP_CNT Register",
    "Counts the total number of packets dropped from all queues due to buffer reservation mechanism.",
#endif
    QM_FPM_BUFFER_RES_DROP_CNT_REG_OFFSET,
    0,
    0,
    146,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    QM_FPM_BUFFER_RES_DROP_CNT_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_PSRAM_EGRESS_CONG_DRP_CNT
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_PSRAM_EGRESS_CONG_DRP_CNT_FIELDS[] =
{
    &QM_PSRAM_EGRESS_CONG_DRP_CNT_COUNTER_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_PSRAM_EGRESS_CONG_DRP_CNT_REG = 
{
    "PSRAM_EGRESS_CONG_DRP_CNT",
#if RU_INCLUDE_DESC
    "PSRAM_EGRESS_CONG_DRP_CNT Register",
    "Counts the total number of packets dropped from all queues due to psram egress congestion.",
#endif
    QM_PSRAM_EGRESS_CONG_DRP_CNT_REG_OFFSET,
    0,
    0,
    147,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    QM_PSRAM_EGRESS_CONG_DRP_CNT_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_BACKPRESSURE
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_BACKPRESSURE_FIELDS[] =
{
    &QM_BACKPRESSURE_STATUS_FIELD,
    &QM_BACKPRESSURE_R1_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_BACKPRESSURE_REG = 
{
    "BACKPRESSURE",
#if RU_INCLUDE_DESC
    "BACKPRESSURE Register",
    "Back pressure sets the relevant register per bp reason. SW should unset by write clear the corresponding bit:"
    ""
    "0x1 - fpm exclusive threshold"
    "0x2 - fpm prefetch occupancy"
    "0x4 - DDR byte on the fly byte count threshold is exceeded"
    "0x8 - PD count in copy machine is exceeded"
    ""
    "A write of 0xFFFF_FFFF in order at reset this indication."
    ""
    "",
#endif
    QM_BACKPRESSURE_REG_OFFSET,
    0,
    0,
    148,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    2,
    QM_BACKPRESSURE_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_GLOBAL_CFG2_BBHTX_FIFO_ADDR
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_GLOBAL_CFG2_BBHTX_FIFO_ADDR_FIELDS[] =
{
    &QM_GLOBAL_CFG2_BBHTX_FIFO_ADDR_ADDR_FIELD,
    &QM_GLOBAL_CFG2_BBHTX_FIFO_ADDR_BBHTX_REQ_OTF_FIELD,
    &QM_GLOBAL_CFG2_BBHTX_FIFO_ADDR_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_GLOBAL_CFG2_BBHTX_FIFO_ADDR_REG = 
{
    "GLOBAL_CFG2_BBHTX_FIFO_ADDR",
#if RU_INCLUDE_DESC
    "BBHTX_FIFO_ADDR Register",
    "QMs BBH TX FIFO address."
    "bit 10:5 of BBs target address to QM. relevant only for project where the BBHTX_SDMA are external to QM",
#endif
    QM_GLOBAL_CFG2_BBHTX_FIFO_ADDR_REG_OFFSET,
    0,
    0,
    149,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    3,
    QM_GLOBAL_CFG2_BBHTX_FIFO_ADDR_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: QM_DATA
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *QM_DATA_FIELDS[] =
{
    &QM_DATA_DATA_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec QM_DATA_REG = 
{
    "DATA",
#if RU_INCLUDE_DESC
    "DATA %i Register",
    "CM Residue - debug access",
#endif
    QM_DATA_REG_OFFSET,
    QM_DATA_REG_RAM_CNT,
    4,
    150,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    QM_DATA_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Block: QM
 ******************************************************************************/
static const ru_reg_rec *QM_REGS[] =
{
    &QM_GLOBAL_CFG_QM_ENABLE_CTRL_REG,
    &QM_GLOBAL_CFG_QM_SW_RST_CTRL_REG,
    &QM_GLOBAL_CFG_QM_GENERAL_CTRL_REG,
    &QM_GLOBAL_CFG_FPM_CONTROL_REG,
    &QM_GLOBAL_CFG_DDR_BYTE_CONGESTION_CONTROL_REG,
    &QM_GLOBAL_CFG_DDR_BYTE_CONGESTION_LOWER_THR_REG,
    &QM_GLOBAL_CFG_DDR_BYTE_CONGESTION_MID_THR_REG,
    &QM_GLOBAL_CFG_DDR_BYTE_CONGESTION_HIGHER_THR_REG,
    &QM_GLOBAL_CFG_DDR_PD_CONGESTION_CONTROL_REG,
    &QM_GLOBAL_CFG_QM_PD_CONGESTION_CONTROL_REG,
    &QM_GLOBAL_CFG_ABS_DROP_QUEUE_REG,
    &QM_GLOBAL_CFG_AGGREGATION_CTRL_REG,
    &QM_GLOBAL_CFG_AGGREGATION_CTRL2_REG,
    &QM_GLOBAL_CFG_FPM_BASE_ADDR_REG,
    &QM_GLOBAL_CFG_FPM_COHERENT_BASE_ADDR_REG,
    &QM_GLOBAL_CFG_DDR_SOP_OFFSET_REG,
    &QM_GLOBAL_CFG_EPON_OVERHEAD_CTRL_REG,
    &QM_GLOBAL_CFG_DQM_FULL_REG,
    &QM_GLOBAL_CFG_DQM_NOT_EMPTY_REG,
    &QM_GLOBAL_CFG_DQM_POP_READY_REG,
    &QM_GLOBAL_CFG_AGGREGATION_CONTEXT_VALID_REG,
    &QM_GLOBAL_CFG_QM_AGGREGATION_TIMER_CTRL_REG,
    &QM_GLOBAL_CFG_QM_FPM_UG_GBL_CNT_REG,
    &QM_GLOBAL_CFG_QM_EGRESS_FLUSH_QUEUE_REG,
    &QM_GLOBAL_CFG_DDR_SPARE_ROOM_REG,
    &QM_GLOBAL_CFG_DUMMY_SPARE_ROOM_PROFILE_ID_REG,
    &QM_GLOBAL_CFG_DQM_UBUS_CTRL_REG,
    &QM_GLOBAL_CFG_MEM_AUTO_INIT_REG,
    &QM_GLOBAL_CFG_MEM_AUTO_INIT_STS_REG,
    &QM_GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_SIZE_TOKENS_REG,
    &QM_GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_0_1_SIZE_BYTE_REG,
    &QM_GLOBAL_CFG_FPM_MPM_ENHANCEMENT_POOL_2_3_SIZE_BYTE_REG,
    &QM_GLOBAL_CFG_MC_CTRL_REG,
    &QM_FPM_POOLS_THR_REG,
    &QM_FPM_USR_GRP_LOWER_THR_REG,
    &QM_FPM_USR_GRP_MID_THR_REG,
    &QM_FPM_USR_GRP_HIGHER_THR_REG,
    &QM_FPM_USR_GRP_CNT_REG,
    &QM_RUNNER_GRP_RNR_CONFIG_REG,
    &QM_RUNNER_GRP_QUEUE_CONFIG_REG,
    &QM_RUNNER_GRP_PDFIFO_CONFIG_REG,
    &QM_RUNNER_GRP_UPDATE_FIFO_CONFIG_REG,
    &QM_INTR_CTRL_ISR_REG,
    &QM_INTR_CTRL_ISM_REG,
    &QM_INTR_CTRL_IER_REG,
    &QM_INTR_CTRL_ITR_REG,
    &QM_CLK_GATE_CLK_GATE_CNTRL_REG,
    &QM_CPU_INDR_PORT_CPU_PD_INDIRECT_CTRL_REG,
    &QM_CPU_INDR_PORT_CPU_PD_INDIRECT_WR_DATA_0_REG,
    &QM_CPU_INDR_PORT_CPU_PD_INDIRECT_WR_DATA_1_REG,
    &QM_CPU_INDR_PORT_CPU_PD_INDIRECT_WR_DATA_2_REG,
    &QM_CPU_INDR_PORT_CPU_PD_INDIRECT_WR_DATA_3_REG,
    &QM_CPU_INDR_PORT_CPU_PD_INDIRECT_RD_DATA_0_REG,
    &QM_CPU_INDR_PORT_CPU_PD_INDIRECT_RD_DATA_1_REG,
    &QM_CPU_INDR_PORT_CPU_PD_INDIRECT_RD_DATA_2_REG,
    &QM_CPU_INDR_PORT_CPU_PD_INDIRECT_RD_DATA_3_REG,
    &QM_QUEUE_CONTEXT_CONTEXT_REG,
    &QM_WRED_PROFILE_COLOR_MIN_THR_0_REG,
    &QM_WRED_PROFILE_COLOR_MIN_THR_1_REG,
    &QM_WRED_PROFILE_COLOR_MAX_THR_0_REG,
    &QM_WRED_PROFILE_COLOR_MAX_THR_1_REG,
    &QM_WRED_PROFILE_COLOR_SLOPE_0_REG,
    &QM_WRED_PROFILE_COLOR_SLOPE_1_REG,
    &QM_COPY_DECISION_PROFILE_THR_REG,
    &QM_TOTAL_VALID_COUNTER_COUNTER_REG,
    &QM_DQM_VALID_COUNTER_COUNTER_REG,
    &QM_DROP_COUNTER_COUNTER_REG,
    &QM_EPON_RPT_CNT_COUNTER_REG,
    &QM_EPON_RPT_CNT_QUEUE_STATUS_REG,
    &QM_RD_DATA_POOL0_REG,
    &QM_RD_DATA_POOL1_REG,
    &QM_RD_DATA_POOL2_REG,
    &QM_RD_DATA_POOL3_REG,
    &QM_PDFIFO_PTR_REG,
    &QM_UPDATE_FIFO_PTR_REG,
    &QM_RD_DATA_REG,
    &QM_POP_REG,
    &QM_CM_COMMON_INPUT_FIFO_DATA_REG,
    &QM_NORMAL_RMT_FIFO_DATA_REG,
    &QM_NON_DELAYED_RMT_FIFO_DATA_REG,
    &QM_EGRESS_DATA_FIFO_DATA_REG,
    &QM_EGRESS_RR_FIFO_DATA_REG,
    &QM_EGRESS_BB_INPUT_FIFO_DATA_REG,
    &QM_EGRESS_BB_OUTPUT_FIFO_DATA_REG,
    &QM_BB_OUTPUT_FIFO_DATA_REG,
    &QM_NON_DELAYED_OUT_FIFO_DATA_REG,
    &QM_CONTEXT_DATA_REG,
    &QM_FPM_BUFFER_RESERVATION_DATA_REG,
    &QM_PORT_CFG_REG,
    &QM_FC_UG_MASK_REG,
    &QM_FC_QUEUE_MASK_REG,
    &QM_DBG_REG,
    &QM_UG_OCCUPANCY_STATUS_REG,
    &QM_QUEUE_OCCUPANCY_STATUS_REG,
    &QM_DEBUG_SEL_REG,
    &QM_DEBUG_BUS_LSB_REG,
    &QM_DEBUG_BUS_MSB_REG,
    &QM_QM_SPARE_CONFIG_REG,
    &QM_GOOD_LVL1_PKTS_CNT_REG,
    &QM_GOOD_LVL1_BYTES_CNT_REG,
    &QM_GOOD_LVL2_PKTS_CNT_REG,
    &QM_GOOD_LVL2_BYTES_CNT_REG,
    &QM_COPIED_PKTS_CNT_REG,
    &QM_COPIED_BYTES_CNT_REG,
    &QM_AGG_PKTS_CNT_REG,
    &QM_AGG_BYTES_CNT_REG,
    &QM_AGG_1_PKTS_CNT_REG,
    &QM_AGG_2_PKTS_CNT_REG,
    &QM_AGG_3_PKTS_CNT_REG,
    &QM_AGG_4_PKTS_CNT_REG,
    &QM_WRED_DROP_CNT_REG,
    &QM_FPM_CONGESTION_DROP_CNT_REG,
    &QM_DDR_PD_CONGESTION_DROP_CNT_REG,
    &QM_DDR_BYTE_CONGESTION_DROP_CNT_REG,
    &QM_QM_PD_CONGESTION_DROP_CNT_REG,
    &QM_QM_ABS_REQUEUE_CNT_REG,
    &QM_FPM_PREFETCH_FIFO0_STATUS_REG,
    &QM_FPM_PREFETCH_FIFO1_STATUS_REG,
    &QM_FPM_PREFETCH_FIFO2_STATUS_REG,
    &QM_FPM_PREFETCH_FIFO3_STATUS_REG,
    &QM_NORMAL_RMT_FIFO_STATUS_REG,
    &QM_NON_DELAYED_RMT_FIFO_STATUS_REG,
    &QM_NON_DELAYED_OUT_FIFO_STATUS_REG,
    &QM_PRE_CM_FIFO_STATUS_REG,
    &QM_CM_RD_PD_FIFO_STATUS_REG,
    &QM_CM_WR_PD_FIFO_STATUS_REG,
    &QM_CM_COMMON_INPUT_FIFO_STATUS_REG,
    &QM_BB0_OUTPUT_FIFO_STATUS_REG,
    &QM_BB1_OUTPUT_FIFO_STATUS_REG,
    &QM_BB1_INPUT_FIFO_STATUS_REG,
    &QM_EGRESS_DATA_FIFO_STATUS_REG,
    &QM_EGRESS_RR_FIFO_STATUS_REG,
    &QM_BB_ROUTE_OVR_REG,
    &QM_QM_INGRESS_STAT_REG,
    &QM_QM_EGRESS_STAT_REG,
    &QM_QM_CM_STAT_REG,
    &QM_QM_FPM_PREFETCH_STAT_REG,
    &QM_QM_CONNECT_ACK_COUNTER_REG,
    &QM_QM_DDR_WR_REPLY_COUNTER_REG,
    &QM_QM_DDR_PIPE_BYTE_COUNTER_REG,
    &QM_QM_ABS_REQUEUE_VALID_COUNTER_REG,
    &QM_QM_ILLEGAL_PD_CAPTURE_REG,
    &QM_QM_INGRESS_PROCESSED_PD_CAPTURE_REG,
    &QM_QM_CM_PROCESSED_PD_CAPTURE_REG,
    &QM_FPM_POOL_DROP_CNT_REG,
    &QM_FPM_GRP_DROP_CNT_REG,
    &QM_FPM_BUFFER_RES_DROP_CNT_REG,
    &QM_PSRAM_EGRESS_CONG_DRP_CNT_REG,
    &QM_BACKPRESSURE_REG,
    &QM_GLOBAL_CFG2_BBHTX_FIFO_ADDR_REG,
    &QM_DATA_REG,
};

unsigned long QM_ADDRS[] =
{
    0x82c00000,
};

const ru_block_rec QM_BLOCK = 
{
    "QM",
    QM_ADDRS,
    1,
    151,
    QM_REGS
};

/* End of file XRDP_QM.c */
