/*
   Copyright (c) 2015 Broadcom
   All Rights Reserved

    <:label-BRCM:2015:DUAL/GPL:standard
    
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License, version 2, as published by
    the Free Software Foundation (the "GPL").
    
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
    
    
    A copy of the GPL is available at http://www.broadcom.com/licenses/GPLv2.php, or by
    writing to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
    
:>
*/

#include "ru.h"

#if RU_INCLUDE_FIELD_DB
/******************************************************************************
 * Field: NATC_TBL_DDR_KEY_BASE_ADDRESS_LOWER_BAR
 ******************************************************************************/
const ru_field_rec NATC_TBL_DDR_KEY_BASE_ADDRESS_LOWER_BAR_FIELD =
{
    "BAR",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    NATC_TBL_DDR_KEY_BASE_ADDRESS_LOWER_BAR_FIELD_MASK,
    0,
    NATC_TBL_DDR_KEY_BASE_ADDRESS_LOWER_BAR_FIELD_WIDTH,
    NATC_TBL_DDR_KEY_BASE_ADDRESS_LOWER_BAR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: NATC_TBL_DDR_KEY_BASE_ADDRESS_LOWER_ZEROS
 ******************************************************************************/
const ru_field_rec NATC_TBL_DDR_KEY_BASE_ADDRESS_LOWER_ZEROS_FIELD =
{
    "ZEROS",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    NATC_TBL_DDR_KEY_BASE_ADDRESS_LOWER_ZEROS_FIELD_MASK,
    0,
    NATC_TBL_DDR_KEY_BASE_ADDRESS_LOWER_ZEROS_FIELD_WIDTH,
    NATC_TBL_DDR_KEY_BASE_ADDRESS_LOWER_ZEROS_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: NATC_TBL_DDR_KEY_BASE_ADDRESS_UPPER_ZEROS
 ******************************************************************************/
const ru_field_rec NATC_TBL_DDR_KEY_BASE_ADDRESS_UPPER_ZEROS_FIELD =
{
    "ZEROS",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    NATC_TBL_DDR_KEY_BASE_ADDRESS_UPPER_ZEROS_FIELD_MASK,
    0,
    NATC_TBL_DDR_KEY_BASE_ADDRESS_UPPER_ZEROS_FIELD_WIDTH,
    NATC_TBL_DDR_KEY_BASE_ADDRESS_UPPER_ZEROS_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: NATC_TBL_DDR_KEY_BASE_ADDRESS_UPPER_BAR
 ******************************************************************************/
const ru_field_rec NATC_TBL_DDR_KEY_BASE_ADDRESS_UPPER_BAR_FIELD =
{
    "BAR",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    NATC_TBL_DDR_KEY_BASE_ADDRESS_UPPER_BAR_FIELD_MASK,
    0,
    NATC_TBL_DDR_KEY_BASE_ADDRESS_UPPER_BAR_FIELD_WIDTH,
    NATC_TBL_DDR_KEY_BASE_ADDRESS_UPPER_BAR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: NATC_TBL_DDR_RESULT_BASE_ADDRESS_LOWER_BAR
 ******************************************************************************/
const ru_field_rec NATC_TBL_DDR_RESULT_BASE_ADDRESS_LOWER_BAR_FIELD =
{
    "BAR",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    NATC_TBL_DDR_RESULT_BASE_ADDRESS_LOWER_BAR_FIELD_MASK,
    0,
    NATC_TBL_DDR_RESULT_BASE_ADDRESS_LOWER_BAR_FIELD_WIDTH,
    NATC_TBL_DDR_RESULT_BASE_ADDRESS_LOWER_BAR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: NATC_TBL_DDR_RESULT_BASE_ADDRESS_LOWER_ZEROS
 ******************************************************************************/
const ru_field_rec NATC_TBL_DDR_RESULT_BASE_ADDRESS_LOWER_ZEROS_FIELD =
{
    "ZEROS",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    NATC_TBL_DDR_RESULT_BASE_ADDRESS_LOWER_ZEROS_FIELD_MASK,
    0,
    NATC_TBL_DDR_RESULT_BASE_ADDRESS_LOWER_ZEROS_FIELD_WIDTH,
    NATC_TBL_DDR_RESULT_BASE_ADDRESS_LOWER_ZEROS_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: NATC_TBL_DDR_RESULT_BASE_ADDRESS_UPPER_ZEROS
 ******************************************************************************/
const ru_field_rec NATC_TBL_DDR_RESULT_BASE_ADDRESS_UPPER_ZEROS_FIELD =
{
    "ZEROS",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    NATC_TBL_DDR_RESULT_BASE_ADDRESS_UPPER_ZEROS_FIELD_MASK,
    0,
    NATC_TBL_DDR_RESULT_BASE_ADDRESS_UPPER_ZEROS_FIELD_WIDTH,
    NATC_TBL_DDR_RESULT_BASE_ADDRESS_UPPER_ZEROS_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: NATC_TBL_DDR_RESULT_BASE_ADDRESS_UPPER_BAR
 ******************************************************************************/
const ru_field_rec NATC_TBL_DDR_RESULT_BASE_ADDRESS_UPPER_BAR_FIELD =
{
    "BAR",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    NATC_TBL_DDR_RESULT_BASE_ADDRESS_UPPER_BAR_FIELD_MASK,
    0,
    NATC_TBL_DDR_RESULT_BASE_ADDRESS_UPPER_BAR_FIELD_WIDTH,
    NATC_TBL_DDR_RESULT_BASE_ADDRESS_UPPER_BAR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: NATC_KEY_MASK_KEY_MASK
 ******************************************************************************/
const ru_field_rec NATC_KEY_MASK_KEY_MASK_FIELD =
{
    "KEY_MASK",
#if RU_INCLUDE_DESC
    "",
    "Specifies the key mask for each bit in the key."
    "For 16-byte key, there are corresponding 4 KEY_MASK registers."
    "For 32-byte key, there are corresponding 8 KEY_MASK registers."
    "Each bit in each KEY_MASK register corresponds to one bit in the key."
    "0 enables the compare and 1 disables the compare."
    "bit 0 of KEY_MASK register[0] corresponds to key bit 0."
    "bit 1 of KEY_MASK register[0] corresponds to key bit 1."
    "bit 2 of KEY_MASK register[0] corresponds to key bit 2."
    "......................"
    "bit 31 of KEY_MASK register [0] corresponds to key bit 31."
    "bit 0 of KEY_MASK register[1] corresponds to key bit 32."
    "bit 1 of KEY_MASK register[1] corresponds to key bit 33."
    "bit 2 of KEY_MASK register[1] corresponds to key bit 34."
    "......................"
    "bit 31 of KEY_MASK register [1] corresponds to key bit 63."
    "......................"
    "bit 0 of KEY_MASK register[7] corresponds to key bit 224."
    "bit 1 of KEY_MASK register[7] corresponds to key bit 225."
    "bit 2 of KEY_MASK register[7] corresponds to key bit 226."
    "......................"
    "bit 31 of KEY_MASK register [7] corresponds to key bit 255.",
#endif
    NATC_KEY_MASK_KEY_MASK_FIELD_MASK,
    0,
    NATC_KEY_MASK_KEY_MASK_FIELD_WIDTH,
    NATC_KEY_MASK_KEY_MASK_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

#endif /* RU_INCLUDE_FIELD_DB */

/******************************************************************************
 * Register: NATC_TBL_DDR_KEY_BASE_ADDRESS_LOWER
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *NATC_TBL_DDR_KEY_BASE_ADDRESS_LOWER_FIELDS[] =
{
    &NATC_TBL_DDR_KEY_BASE_ADDRESS_LOWER_BAR_FIELD,
    &NATC_TBL_DDR_KEY_BASE_ADDRESS_LOWER_ZEROS_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec NATC_TBL_DDR_KEY_BASE_ADDRESS_LOWER_REG = 
{
    "DDR_KEY_BASE_ADDRESS_LOWER",
#if RU_INCLUDE_DESC
    "Lower 32-bit of NAT table 7 key base address NAT table 7 in DDR",
    "Lower 32-bit of the base address of DDR key table"
    "Address must be 64-bit aligned (bit 2 through 0 are zero's)"
    "In order maximum number of key fetches,"
    "for 16-byte key, bit 3 should be 0 to align at 16 byte boundary"
    "for 32-byte key, bit 3 and 4 should be 0 to align at 32 bytes boundary",
#endif
    NATC_TBL_DDR_KEY_BASE_ADDRESS_LOWER_REG_OFFSET,
    0,
    0,
    1262,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    2,
    NATC_TBL_DDR_KEY_BASE_ADDRESS_LOWER_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: NATC_TBL_DDR_KEY_BASE_ADDRESS_UPPER
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *NATC_TBL_DDR_KEY_BASE_ADDRESS_UPPER_FIELDS[] =
{
    &NATC_TBL_DDR_KEY_BASE_ADDRESS_UPPER_ZEROS_FIELD,
    &NATC_TBL_DDR_KEY_BASE_ADDRESS_UPPER_BAR_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec NATC_TBL_DDR_KEY_BASE_ADDRESS_UPPER_REG = 
{
    "DDR_KEY_BASE_ADDRESS_UPPER",
#if RU_INCLUDE_DESC
    "Upper 32-bit of NAT table 7 key base address NAT table 7 in DDR",
    "Upper 8-bit of the base address of DDR key table"
    "For 32-bit system this field should be left as 0",
#endif
    NATC_TBL_DDR_KEY_BASE_ADDRESS_UPPER_REG_OFFSET,
    0,
    0,
    1263,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    2,
    NATC_TBL_DDR_KEY_BASE_ADDRESS_UPPER_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: NATC_TBL_DDR_RESULT_BASE_ADDRESS_LOWER
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *NATC_TBL_DDR_RESULT_BASE_ADDRESS_LOWER_FIELDS[] =
{
    &NATC_TBL_DDR_RESULT_BASE_ADDRESS_LOWER_BAR_FIELD,
    &NATC_TBL_DDR_RESULT_BASE_ADDRESS_LOWER_ZEROS_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec NATC_TBL_DDR_RESULT_BASE_ADDRESS_LOWER_REG = 
{
    "DDR_RESULT_BASE_ADDRESS_LOWER",
#if RU_INCLUDE_DESC
    "Lower 32-bit of NAT table 7 result base address NAT table 7 in DDR",
    "Lower 32-bit of the base address of DDR context table"
    "Address must be 64-bit aligned (bit 2 through 0 are zero's)",
#endif
    NATC_TBL_DDR_RESULT_BASE_ADDRESS_LOWER_REG_OFFSET,
    0,
    0,
    1264,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    2,
    NATC_TBL_DDR_RESULT_BASE_ADDRESS_LOWER_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: NATC_TBL_DDR_RESULT_BASE_ADDRESS_UPPER
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *NATC_TBL_DDR_RESULT_BASE_ADDRESS_UPPER_FIELDS[] =
{
    &NATC_TBL_DDR_RESULT_BASE_ADDRESS_UPPER_ZEROS_FIELD,
    &NATC_TBL_DDR_RESULT_BASE_ADDRESS_UPPER_BAR_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec NATC_TBL_DDR_RESULT_BASE_ADDRESS_UPPER_REG = 
{
    "DDR_RESULT_BASE_ADDRESS_UPPER",
#if RU_INCLUDE_DESC
    "Upper 32-bit of NAT table 7 result base address NAT table 7 in DDR",
    "Upper 8-bit of the base address of DDR context table"
    "For 32-bit system this field should be left as 0",
#endif
    NATC_TBL_DDR_RESULT_BASE_ADDRESS_UPPER_REG_OFFSET,
    0,
    0,
    1265,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    2,
    NATC_TBL_DDR_RESULT_BASE_ADDRESS_UPPER_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: NATC_KEY_MASK
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *NATC_KEY_MASK_FIELDS[] =
{
    &NATC_KEY_MASK_KEY_MASK_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec NATC_KEY_MASK_REG = 
{
    "MASK",
#if RU_INCLUDE_DESC
    "NAT table 7 key mask register",
    "NAT Cache key Mask Register",
#endif
    NATC_KEY_MASK_REG_OFFSET,
    NATC_KEY_MASK_REG_RAM_CNT,
    4,
    1266,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    NATC_KEY_MASK_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Block: NATC_TBL
 ******************************************************************************/
static const ru_reg_rec *NATC_TBL_REGS[] =
{
    &NATC_TBL_DDR_KEY_BASE_ADDRESS_LOWER_REG,
    &NATC_TBL_DDR_KEY_BASE_ADDRESS_UPPER_REG,
    &NATC_TBL_DDR_RESULT_BASE_ADDRESS_LOWER_REG,
    &NATC_TBL_DDR_RESULT_BASE_ADDRESS_UPPER_REG,
};

unsigned long NATC_TBL_ADDRS[] =
{
    0x829502d0,
    0x829502e0,
    0x829502f0,
    0x82950300,
    0x82950310,
    0x82950320,
    0x82950330,
    0x82950340,
};

const ru_block_rec NATC_TBL_BLOCK = 
{
    "NATC_TBL",
    NATC_TBL_ADDRS,
    8,
    4,
    NATC_TBL_REGS
};

/******************************************************************************
 * Block: NATC_KEY
 ******************************************************************************/
static const ru_reg_rec *NATC_KEY_REGS[] =
{
    &NATC_KEY_MASK_REG,
};

unsigned long NATC_KEY_ADDRS[] =
{
    0x829503b0,
    0x829503d0,
    0x829503f0,
    0x82950410,
    0x82950430,
    0x82950450,
    0x82950470,
    0x82950490,
};

const ru_block_rec NATC_KEY_BLOCK = 
{
    "NATC_KEY",
    NATC_KEY_ADDRS,
    8,
    1,
    NATC_KEY_REGS
};

/* End of file XRDP_NATC_CFG.c */
