/*
   Copyright (c) 2015 Broadcom
   All Rights Reserved

    <:label-BRCM:2015:DUAL/GPL:standard
    
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License, version 2, as published by
    the Free Software Foundation (the "GPL").
    
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
    
    
    A copy of the GPL is available at http://www.broadcom.com/licenses/GPLv2.php, or by
    writing to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
    
:>
*/

#include "ru.h"

#if RU_INCLUDE_FIELD_DB
/******************************************************************************
 * Field: CNPL_MEMORY_DATA_DATA
 ******************************************************************************/
const ru_field_rec CNPL_MEMORY_DATA_DATA_FIELD =
{
    "DATA",
#if RU_INCLUDE_DESC
    "data",
    "data",
#endif
    CNPL_MEMORY_DATA_DATA_FIELD_MASK,
    0,
    CNPL_MEMORY_DATA_DATA_FIELD_WIDTH,
    CNPL_MEMORY_DATA_DATA_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: CNPL_COUNTERS_CONFIGURATIONS_CN_LOC_PROF_BA
 ******************************************************************************/
const ru_field_rec CNPL_COUNTERS_CONFIGURATIONS_CN_LOC_PROF_BA_FIELD =
{
    "BA",
#if RU_INCLUDE_DESC
    "base_address",
    "counters group base address (in 8B resolution: 0 is 0x0, 1 is 0x8, ...)",
#endif
    CNPL_COUNTERS_CONFIGURATIONS_CN_LOC_PROF_BA_FIELD_MASK,
    0,
    CNPL_COUNTERS_CONFIGURATIONS_CN_LOC_PROF_BA_FIELD_WIDTH,
    CNPL_COUNTERS_CONFIGURATIONS_CN_LOC_PROF_BA_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: CNPL_COUNTERS_CONFIGURATIONS_CN_LOC_PROF_CN0_BYTS
 ******************************************************************************/
const ru_field_rec CNPL_COUNTERS_CONFIGURATIONS_CN_LOC_PROF_CN0_BYTS_FIELD =
{
    "CN0_BYTS",
#if RU_INCLUDE_DESC
    "cntr0_bytes",
    "number of bytes that will hold each sub-counter."
    "0: 1B"
    "1: 2B"
    "2: 4B",
#endif
    CNPL_COUNTERS_CONFIGURATIONS_CN_LOC_PROF_CN0_BYTS_FIELD_MASK,
    0,
    CNPL_COUNTERS_CONFIGURATIONS_CN_LOC_PROF_CN0_BYTS_FIELD_WIDTH,
    CNPL_COUNTERS_CONFIGURATIONS_CN_LOC_PROF_CN0_BYTS_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: CNPL_COUNTERS_CONFIGURATIONS_CN_LOC_PROF_DOUBLLE
 ******************************************************************************/
const ru_field_rec CNPL_COUNTERS_CONFIGURATIONS_CN_LOC_PROF_DOUBLLE_FIELD =
{
    "DOUBLLE",
#if RU_INCLUDE_DESC
    "doublle",
    "1:each counter of the group is double sub-cntr"
    "0:each counter of the group is single",
#endif
    CNPL_COUNTERS_CONFIGURATIONS_CN_LOC_PROF_DOUBLLE_FIELD_MASK,
    0,
    CNPL_COUNTERS_CONFIGURATIONS_CN_LOC_PROF_DOUBLLE_FIELD_WIDTH,
    CNPL_COUNTERS_CONFIGURATIONS_CN_LOC_PROF_DOUBLLE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: CNPL_COUNTERS_CONFIGURATIONS_CN_LOC_PROF_WRAP
 ******************************************************************************/
const ru_field_rec CNPL_COUNTERS_CONFIGURATIONS_CN_LOC_PROF_WRAP_FIELD =
{
    "WRAP",
#if RU_INCLUDE_DESC
    "wrap",
    "1:wrap at max value"
    "0:freeze at max value",
#endif
    CNPL_COUNTERS_CONFIGURATIONS_CN_LOC_PROF_WRAP_FIELD_MASK,
    0,
    CNPL_COUNTERS_CONFIGURATIONS_CN_LOC_PROF_WRAP_FIELD_WIDTH,
    CNPL_COUNTERS_CONFIGURATIONS_CN_LOC_PROF_WRAP_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: CNPL_COUNTERS_CONFIGURATIONS_CN_LOC_PROF_CLR
 ******************************************************************************/
const ru_field_rec CNPL_COUNTERS_CONFIGURATIONS_CN_LOC_PROF_CLR_FIELD =
{
    "CLR",
#if RU_INCLUDE_DESC
    "clear",
    "1:read clear when reading"
    "0:read no-clear when reading",
#endif
    CNPL_COUNTERS_CONFIGURATIONS_CN_LOC_PROF_CLR_FIELD_MASK,
    0,
    CNPL_COUNTERS_CONFIGURATIONS_CN_LOC_PROF_CLR_FIELD_WIDTH,
    CNPL_COUNTERS_CONFIGURATIONS_CN_LOC_PROF_CLR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: CNPL_COUNTERS_CONFIGURATIONS_CN_LOC_PROF_RESERVED0
 ******************************************************************************/
const ru_field_rec CNPL_COUNTERS_CONFIGURATIONS_CN_LOC_PROF_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    CNPL_COUNTERS_CONFIGURATIONS_CN_LOC_PROF_RESERVED0_FIELD_MASK,
    0,
    CNPL_COUNTERS_CONFIGURATIONS_CN_LOC_PROF_RESERVED0_FIELD_WIDTH,
    CNPL_COUNTERS_CONFIGURATIONS_CN_LOC_PROF_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: CNPL_POLICERS_CONFIGURATIONS_PL_LOC_PROF0_BK_BA
 ******************************************************************************/
const ru_field_rec CNPL_POLICERS_CONFIGURATIONS_PL_LOC_PROF0_BK_BA_FIELD =
{
    "BK_BA",
#if RU_INCLUDE_DESC
    "bkts_base_address",
    "buckets base address(in 8B resolution: 0 is 0x0, 1 is 0x8, ...)",
#endif
    CNPL_POLICERS_CONFIGURATIONS_PL_LOC_PROF0_BK_BA_FIELD_MASK,
    0,
    CNPL_POLICERS_CONFIGURATIONS_PL_LOC_PROF0_BK_BA_FIELD_WIDTH,
    CNPL_POLICERS_CONFIGURATIONS_PL_LOC_PROF0_BK_BA_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: CNPL_POLICERS_CONFIGURATIONS_PL_LOC_PROF0_PA_BA
 ******************************************************************************/
const ru_field_rec CNPL_POLICERS_CONFIGURATIONS_PL_LOC_PROF0_PA_BA_FIELD =
{
    "PA_BA",
#if RU_INCLUDE_DESC
    "params_base_address",
    "params base address(in 8B resolution: 0 is 0x0, 1 is 0x8, ...)",
#endif
    CNPL_POLICERS_CONFIGURATIONS_PL_LOC_PROF0_PA_BA_FIELD_MASK,
    0,
    CNPL_POLICERS_CONFIGURATIONS_PL_LOC_PROF0_PA_BA_FIELD_WIDTH,
    CNPL_POLICERS_CONFIGURATIONS_PL_LOC_PROF0_PA_BA_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: CNPL_POLICERS_CONFIGURATIONS_PL_LOC_PROF0_DOUBLLE
 ******************************************************************************/
const ru_field_rec CNPL_POLICERS_CONFIGURATIONS_PL_LOC_PROF0_DOUBLLE_FIELD =
{
    "DOUBLLE",
#if RU_INCLUDE_DESC
    "doublle",
    "1:each policer is dual bucket"
    "0:each policer is single bucket",
#endif
    CNPL_POLICERS_CONFIGURATIONS_PL_LOC_PROF0_DOUBLLE_FIELD_MASK,
    0,
    CNPL_POLICERS_CONFIGURATIONS_PL_LOC_PROF0_DOUBLLE_FIELD_WIDTH,
    CNPL_POLICERS_CONFIGURATIONS_PL_LOC_PROF0_DOUBLLE_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: CNPL_POLICERS_CONFIGURATIONS_PL_LOC_PROF0_FC
 ******************************************************************************/
const ru_field_rec CNPL_POLICERS_CONFIGURATIONS_PL_LOC_PROF0_FC_FIELD =
{
    "FC",
#if RU_INCLUDE_DESC
    "flow_control",
    "1:the policers are flow control type"
    "0:the policers are normal"
    ""
    "When it is fc, the double field has no effect.",
#endif
    CNPL_POLICERS_CONFIGURATIONS_PL_LOC_PROF0_FC_FIELD_MASK,
    0,
    CNPL_POLICERS_CONFIGURATIONS_PL_LOC_PROF0_FC_FIELD_WIDTH,
    CNPL_POLICERS_CONFIGURATIONS_PL_LOC_PROF0_FC_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: CNPL_POLICERS_CONFIGURATIONS_PL_LOC_PROF0_N
 ******************************************************************************/
const ru_field_rec CNPL_POLICERS_CONFIGURATIONS_PL_LOC_PROF0_N_FIELD =
{
    "N",
#if RU_INCLUDE_DESC
    "N",
    "period in 8k cycles quanta (16.384us for 500MHz)",
#endif
    CNPL_POLICERS_CONFIGURATIONS_PL_LOC_PROF0_N_FIELD_MASK,
    0,
    CNPL_POLICERS_CONFIGURATIONS_PL_LOC_PROF0_N_FIELD_WIDTH,
    CNPL_POLICERS_CONFIGURATIONS_PL_LOC_PROF0_N_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: CNPL_POLICERS_CONFIGURATIONS_PL_LOC_PROF1_PL_ST
 ******************************************************************************/
const ru_field_rec CNPL_POLICERS_CONFIGURATIONS_PL_LOC_PROF1_PL_ST_FIELD =
{
    "PL_ST",
#if RU_INCLUDE_DESC
    "pl_start",
    "Index of 1st policer of the group."
    "In default: pol_start>pol_end, so the group is not valid",
#endif
    CNPL_POLICERS_CONFIGURATIONS_PL_LOC_PROF1_PL_ST_FIELD_MASK,
    0,
    CNPL_POLICERS_CONFIGURATIONS_PL_LOC_PROF1_PL_ST_FIELD_WIDTH,
    CNPL_POLICERS_CONFIGURATIONS_PL_LOC_PROF1_PL_ST_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: CNPL_POLICERS_CONFIGURATIONS_PL_LOC_PROF1_PL_END
 ******************************************************************************/
const ru_field_rec CNPL_POLICERS_CONFIGURATIONS_PL_LOC_PROF1_PL_END_FIELD =
{
    "PL_END",
#if RU_INCLUDE_DESC
    "pl_end",
    "Index of last policer of the group."
    "In default: pol_start>pol_end, so the group is not valid",
#endif
    CNPL_POLICERS_CONFIGURATIONS_PL_LOC_PROF1_PL_END_FIELD_MASK,
    0,
    CNPL_POLICERS_CONFIGURATIONS_PL_LOC_PROF1_PL_END_FIELD_WIDTH,
    CNPL_POLICERS_CONFIGURATIONS_PL_LOC_PROF1_PL_END_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: CNPL_POLICERS_CONFIGURATIONS_PL_LOC_PROF1_RESERVED0
 ******************************************************************************/
const ru_field_rec CNPL_POLICERS_CONFIGURATIONS_PL_LOC_PROF1_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    CNPL_POLICERS_CONFIGURATIONS_PL_LOC_PROF1_RESERVED0_FIELD_MASK,
    0,
    CNPL_POLICERS_CONFIGURATIONS_PL_LOC_PROF1_RESERVED0_FIELD_WIDTH,
    CNPL_POLICERS_CONFIGURATIONS_PL_LOC_PROF1_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: CNPL_POLICERS_CONFIGURATIONS_PL_CALC_TYPE_VEC
 ******************************************************************************/
const ru_field_rec CNPL_POLICERS_CONFIGURATIONS_PL_CALC_TYPE_VEC_FIELD =
{
    "VEC",
#if RU_INCLUDE_DESC
    "vector",
    "32b vector for 32 policers",
#endif
    CNPL_POLICERS_CONFIGURATIONS_PL_CALC_TYPE_VEC_FIELD_MASK,
    0,
    CNPL_POLICERS_CONFIGURATIONS_PL_CALC_TYPE_VEC_FIELD_WIDTH,
    CNPL_POLICERS_CONFIGURATIONS_PL_CALC_TYPE_VEC_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: CNPL_POLICERS_CONFIGURATIONS_PER_UP_EN
 ******************************************************************************/
const ru_field_rec CNPL_POLICERS_CONFIGURATIONS_PER_UP_EN_FIELD =
{
    "EN",
#if RU_INCLUDE_DESC
    "enable",
    "1:enable periodic update"
    "0:disable periodic update",
#endif
    CNPL_POLICERS_CONFIGURATIONS_PER_UP_EN_FIELD_MASK,
    0,
    CNPL_POLICERS_CONFIGURATIONS_PER_UP_EN_FIELD_WIDTH,
    CNPL_POLICERS_CONFIGURATIONS_PER_UP_EN_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: CNPL_POLICERS_CONFIGURATIONS_PER_UP_MTU
 ******************************************************************************/
const ru_field_rec CNPL_POLICERS_CONFIGURATIONS_PER_UP_MTU_FIELD =
{
    "MTU",
#if RU_INCLUDE_DESC
    "mtu",
    "MTU for calculation of bucket size",
#endif
    CNPL_POLICERS_CONFIGURATIONS_PER_UP_MTU_FIELD_MASK,
    0,
    CNPL_POLICERS_CONFIGURATIONS_PER_UP_MTU_FIELD_WIDTH,
    CNPL_POLICERS_CONFIGURATIONS_PER_UP_MTU_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: CNPL_POLICERS_CONFIGURATIONS_PER_UP_RESERVED0
 ******************************************************************************/
const ru_field_rec CNPL_POLICERS_CONFIGURATIONS_PER_UP_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    CNPL_POLICERS_CONFIGURATIONS_PER_UP_RESERVED0_FIELD_MASK,
    0,
    CNPL_POLICERS_CONFIGURATIONS_PER_UP_RESERVED0_FIELD_WIDTH,
    CNPL_POLICERS_CONFIGURATIONS_PER_UP_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: CNPL_POLICERS_CONFIGURATIONS_PL_SIZE_PROF_PRF0
 ******************************************************************************/
const ru_field_rec CNPL_POLICERS_CONFIGURATIONS_PL_SIZE_PROF_PRF0_FIELD =
{
    "PRF0",
#if RU_INCLUDE_DESC
    "prof0",
    "16b profile",
#endif
    CNPL_POLICERS_CONFIGURATIONS_PL_SIZE_PROF_PRF0_FIELD_MASK,
    0,
    CNPL_POLICERS_CONFIGURATIONS_PL_SIZE_PROF_PRF0_FIELD_WIDTH,
    CNPL_POLICERS_CONFIGURATIONS_PL_SIZE_PROF_PRF0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: CNPL_POLICERS_CONFIGURATIONS_PL_SIZE_PROF_PRF1
 ******************************************************************************/
const ru_field_rec CNPL_POLICERS_CONFIGURATIONS_PL_SIZE_PROF_PRF1_FIELD =
{
    "PRF1",
#if RU_INCLUDE_DESC
    "prof1",
    "16b profile",
#endif
    CNPL_POLICERS_CONFIGURATIONS_PL_SIZE_PROF_PRF1_FIELD_MASK,
    0,
    CNPL_POLICERS_CONFIGURATIONS_PL_SIZE_PROF_PRF1_FIELD_WIDTH,
    CNPL_POLICERS_CONFIGURATIONS_PL_SIZE_PROF_PRF1_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: CNPL_BUF_MNG_COUNTERS_CFG_STAT_ORDR_NXTLVL
 ******************************************************************************/
const ru_field_rec CNPL_BUF_MNG_COUNTERS_CFG_STAT_ORDR_NXTLVL_FIELD =
{
    "NXTLVL",
#if RU_INCLUDE_DESC
    "nxt_level",
    "the address is counter"
    "bits[ 4:0] are next-level after this counter."
    "If msb=1, then nxt_level is not valid"
    "",
#endif
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_ORDR_NXTLVL_FIELD_MASK,
    0,
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_ORDR_NXTLVL_FIELD_WIDTH,
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_ORDR_NXTLVL_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: CNPL_BUF_MNG_COUNTERS_CFG_STAT_ORDR_RESERVED0
 ******************************************************************************/
const ru_field_rec CNPL_BUF_MNG_COUNTERS_CFG_STAT_ORDR_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_ORDR_RESERVED0_FIELD_MASK,
    0,
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_ORDR_RESERVED0_FIELD_WIDTH,
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_ORDR_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: CNPL_BUF_MNG_COUNTERS_CFG_STAT_RSRV_THR_THR
 ******************************************************************************/
const ru_field_rec CNPL_BUF_MNG_COUNTERS_CFG_STAT_RSRV_THR_THR_FIELD =
{
    "THR",
#if RU_INCLUDE_DESC
    "threshold",
    "threshold",
#endif
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_RSRV_THR_THR_FIELD_MASK,
    0,
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_RSRV_THR_THR_FIELD_WIDTH,
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_RSRV_THR_THR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: CNPL_BUF_MNG_COUNTERS_CFG_STAT_RSRV_THR_RESERVED0
 ******************************************************************************/
const ru_field_rec CNPL_BUF_MNG_COUNTERS_CFG_STAT_RSRV_THR_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_RSRV_THR_RESERVED0_FIELD_MASK,
    0,
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_RSRV_THR_RESERVED0_FIELD_WIDTH,
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_RSRV_THR_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: CNPL_BUF_MNG_COUNTERS_CFG_STAT_HIPRI_THR_THR
 ******************************************************************************/
const ru_field_rec CNPL_BUF_MNG_COUNTERS_CFG_STAT_HIPRI_THR_THR_FIELD =
{
    "THR",
#if RU_INCLUDE_DESC
    "threshold",
    "threshold",
#endif
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_HIPRI_THR_THR_FIELD_MASK,
    0,
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_HIPRI_THR_THR_FIELD_WIDTH,
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_HIPRI_THR_THR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: CNPL_BUF_MNG_COUNTERS_CFG_STAT_HIPRI_THR_RESERVED0
 ******************************************************************************/
const ru_field_rec CNPL_BUF_MNG_COUNTERS_CFG_STAT_HIPRI_THR_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_HIPRI_THR_RESERVED0_FIELD_MASK,
    0,
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_HIPRI_THR_RESERVED0_FIELD_WIDTH,
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_HIPRI_THR_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: CNPL_BUF_MNG_COUNTERS_CFG_STAT_MAX_THR_THR
 ******************************************************************************/
const ru_field_rec CNPL_BUF_MNG_COUNTERS_CFG_STAT_MAX_THR_THR_FIELD =
{
    "THR",
#if RU_INCLUDE_DESC
    "threshold",
    "threshold",
#endif
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_MAX_THR_THR_FIELD_MASK,
    0,
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_MAX_THR_THR_FIELD_WIDTH,
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_MAX_THR_THR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: CNPL_BUF_MNG_COUNTERS_CFG_STAT_MAX_THR_RESERVED0
 ******************************************************************************/
const ru_field_rec CNPL_BUF_MNG_COUNTERS_CFG_STAT_MAX_THR_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_MAX_THR_RESERVED0_FIELD_MASK,
    0,
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_MAX_THR_RESERVED0_FIELD_WIDTH,
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_MAX_THR_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: CNPL_BUF_MNG_COUNTERS_CFG_STAT_HI_WMRK_CFG_CTR0
 ******************************************************************************/
const ru_field_rec CNPL_BUF_MNG_COUNTERS_CFG_STAT_HI_WMRK_CFG_CTR0_FIELD =
{
    "CTR0",
#if RU_INCLUDE_DESC
    "cntr0",
    "counter to get its high-watermark"
    "",
#endif
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_HI_WMRK_CFG_CTR0_FIELD_MASK,
    0,
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_HI_WMRK_CFG_CTR0_FIELD_WIDTH,
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_HI_WMRK_CFG_CTR0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: CNPL_BUF_MNG_COUNTERS_CFG_STAT_HI_WMRK_CFG_RESERVED0
 ******************************************************************************/
const ru_field_rec CNPL_BUF_MNG_COUNTERS_CFG_STAT_HI_WMRK_CFG_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_HI_WMRK_CFG_RESERVED0_FIELD_MASK,
    0,
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_HI_WMRK_CFG_RESERVED0_FIELD_WIDTH,
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_HI_WMRK_CFG_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: CNPL_BUF_MNG_COUNTERS_CFG_STAT_HI_WMRK_CFG_CTR1
 ******************************************************************************/
const ru_field_rec CNPL_BUF_MNG_COUNTERS_CFG_STAT_HI_WMRK_CFG_CTR1_FIELD =
{
    "CTR1",
#if RU_INCLUDE_DESC
    "cntr1",
    "counter to get its high-watermark"
    "",
#endif
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_HI_WMRK_CFG_CTR1_FIELD_MASK,
    0,
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_HI_WMRK_CFG_CTR1_FIELD_WIDTH,
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_HI_WMRK_CFG_CTR1_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: CNPL_BUF_MNG_COUNTERS_CFG_STAT_HI_WMRK_CFG_RESERVED1
 ******************************************************************************/
const ru_field_rec CNPL_BUF_MNG_COUNTERS_CFG_STAT_HI_WMRK_CFG_RESERVED1_FIELD =
{
    "RESERVED1",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_HI_WMRK_CFG_RESERVED1_FIELD_MASK,
    0,
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_HI_WMRK_CFG_RESERVED1_FIELD_WIDTH,
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_HI_WMRK_CFG_RESERVED1_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: CNPL_BUF_MNG_COUNTERS_CFG_STAT_HI_WMRK_CFG_CTR2
 ******************************************************************************/
const ru_field_rec CNPL_BUF_MNG_COUNTERS_CFG_STAT_HI_WMRK_CFG_CTR2_FIELD =
{
    "CTR2",
#if RU_INCLUDE_DESC
    "cntr2",
    "counter to get its high-watermark"
    "",
#endif
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_HI_WMRK_CFG_CTR2_FIELD_MASK,
    0,
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_HI_WMRK_CFG_CTR2_FIELD_WIDTH,
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_HI_WMRK_CFG_CTR2_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: CNPL_BUF_MNG_COUNTERS_CFG_STAT_HI_WMRK_CFG_RESERVED2
 ******************************************************************************/
const ru_field_rec CNPL_BUF_MNG_COUNTERS_CFG_STAT_HI_WMRK_CFG_RESERVED2_FIELD =
{
    "RESERVED2",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_HI_WMRK_CFG_RESERVED2_FIELD_MASK,
    0,
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_HI_WMRK_CFG_RESERVED2_FIELD_WIDTH,
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_HI_WMRK_CFG_RESERVED2_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: CNPL_BUF_MNG_COUNTERS_CFG_STAT_HI_WMRK_VAL_VAL
 ******************************************************************************/
const ru_field_rec CNPL_BUF_MNG_COUNTERS_CFG_STAT_HI_WMRK_VAL_VAL_FIELD =
{
    "VAL",
#if RU_INCLUDE_DESC
    "value",
    "value",
#endif
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_HI_WMRK_VAL_VAL_FIELD_MASK,
    0,
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_HI_WMRK_VAL_VAL_FIELD_WIDTH,
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_HI_WMRK_VAL_VAL_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: CNPL_BUF_MNG_COUNTERS_CFG_STAT_HI_WMRK_VAL_RESERVED0
 ******************************************************************************/
const ru_field_rec CNPL_BUF_MNG_COUNTERS_CFG_STAT_HI_WMRK_VAL_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_HI_WMRK_VAL_RESERVED0_FIELD_MASK,
    0,
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_HI_WMRK_VAL_RESERVED0_FIELD_WIDTH,
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_HI_WMRK_VAL_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNTR_INIT_IDX
 ******************************************************************************/
const ru_field_rec CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNTR_INIT_IDX_FIELD =
{
    "IDX",
#if RU_INCLUDE_DESC
    "index",
    "counter index",
#endif
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNTR_INIT_IDX_FIELD_MASK,
    0,
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNTR_INIT_IDX_FIELD_WIDTH,
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNTR_INIT_IDX_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_write
#endif
};

/******************************************************************************
 * Field: CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNTR_INIT_RESERVED0
 ******************************************************************************/
const ru_field_rec CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNTR_INIT_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNTR_INIT_RESERVED0_FIELD_MASK,
    0,
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNTR_INIT_RESERVED0_FIELD_WIDTH,
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNTR_INIT_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_write
#endif
};

/******************************************************************************
 * Field: CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNTR_INIT_VAL
 ******************************************************************************/
const ru_field_rec CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNTR_INIT_VAL_FIELD =
{
    "VAL",
#if RU_INCLUDE_DESC
    "value",
    "counter value",
#endif
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNTR_INIT_VAL_FIELD_MASK,
    0,
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNTR_INIT_VAL_FIELD_WIDTH,
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNTR_INIT_VAL_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_write
#endif
};

/******************************************************************************
 * Field: CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNTR_INIT_RESERVED1
 ******************************************************************************/
const ru_field_rec CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNTR_INIT_RESERVED1_FIELD =
{
    "RESERVED1",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNTR_INIT_RESERVED1_FIELD_MASK,
    0,
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNTR_INIT_RESERVED1_FIELD_WIDTH,
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNTR_INIT_RESERVED1_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_write
#endif
};

/******************************************************************************
 * Field: CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNTR_NEG_ST_VAL
 ******************************************************************************/
const ru_field_rec CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNTR_NEG_ST_VAL_FIELD =
{
    "VAL",
#if RU_INCLUDE_DESC
    "value",
    "if bit=0, the counter should have goen negative",
#endif
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNTR_NEG_ST_VAL_FIELD_MASK,
    0,
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNTR_NEG_ST_VAL_FIELD_WIDTH,
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNTR_NEG_ST_VAL_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNTR_NEG_ST_RESERVED0
 ******************************************************************************/
const ru_field_rec CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNTR_NEG_ST_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNTR_NEG_ST_RESERVED0_FIELD_MASK,
    0,
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNTR_NEG_ST_RESERVED0_FIELD_WIDTH,
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNTR_NEG_ST_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNTR_NEG_ST_CLR_VAL
 ******************************************************************************/
const ru_field_rec CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNTR_NEG_ST_CLR_VAL_FIELD =
{
    "VAL",
#if RU_INCLUDE_DESC
    "value",
    "if bit=1, it clears corresponding bit in cntr_neg_st register",
#endif
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNTR_NEG_ST_CLR_VAL_FIELD_MASK,
    0,
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNTR_NEG_ST_CLR_VAL_FIELD_WIDTH,
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNTR_NEG_ST_CLR_VAL_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_write
#endif
};

/******************************************************************************
 * Field: CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNTR_NEG_ST_CLR_RESERVED0
 ******************************************************************************/
const ru_field_rec CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNTR_NEG_ST_CLR_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNTR_NEG_ST_CLR_RESERVED0_FIELD_MASK,
    0,
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNTR_NEG_ST_CLR_RESERVED0_FIELD_WIDTH,
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNTR_NEG_ST_CLR_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_write
#endif
};

/******************************************************************************
 * Field: CNPL_BUF_MNG_COUNTERS_CFG_STAT_CAPT_CFG_MOD
 ******************************************************************************/
const ru_field_rec CNPL_BUF_MNG_COUNTERS_CFG_STAT_CAPT_CFG_MOD_FIELD =
{
    "MOD",
#if RU_INCLUDE_DESC
    "mode",
    "mode",
#endif
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_CAPT_CFG_MOD_FIELD_MASK,
    0,
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_CAPT_CFG_MOD_FIELD_WIDTH,
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_CAPT_CFG_MOD_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: CNPL_BUF_MNG_COUNTERS_CFG_STAT_CAPT_CFG_RESERVED0
 ******************************************************************************/
const ru_field_rec CNPL_BUF_MNG_COUNTERS_CFG_STAT_CAPT_CFG_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_CAPT_CFG_RESERVED0_FIELD_MASK,
    0,
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_CAPT_CFG_RESERVED0_FIELD_WIDTH,
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_CAPT_CFG_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNT_NEG_CAP_CNT_IDX
 ******************************************************************************/
const ru_field_rec CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNT_NEG_CAP_CNT_IDX_FIELD =
{
    "IDX",
#if RU_INCLUDE_DESC
    "index",
    "counter index",
#endif
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNT_NEG_CAP_CNT_IDX_FIELD_MASK,
    0,
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNT_NEG_CAP_CNT_IDX_FIELD_WIDTH,
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNT_NEG_CAP_CNT_IDX_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNT_NEG_CAP_CNT_RESERVED0
 ******************************************************************************/
const ru_field_rec CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNT_NEG_CAP_CNT_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNT_NEG_CAP_CNT_RESERVED0_FIELD_MASK,
    0,
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNT_NEG_CAP_CNT_RESERVED0_FIELD_WIDTH,
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNT_NEG_CAP_CNT_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNT_NEG_CAP_CNT_VAL
 ******************************************************************************/
const ru_field_rec CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNT_NEG_CAP_CNT_VAL_FIELD =
{
    "VAL",
#if RU_INCLUDE_DESC
    "value",
    "value",
#endif
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNT_NEG_CAP_CNT_VAL_FIELD_MASK,
    0,
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNT_NEG_CAP_CNT_VAL_FIELD_WIDTH,
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNT_NEG_CAP_CNT_VAL_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNT_NEG_CAP_CNT_RESERVED1
 ******************************************************************************/
const ru_field_rec CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNT_NEG_CAP_CNT_RESERVED1_FIELD =
{
    "RESERVED1",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNT_NEG_CAP_CNT_RESERVED1_FIELD_MASK,
    0,
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNT_NEG_CAP_CNT_RESERVED1_FIELD_WIDTH,
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNT_NEG_CAP_CNT_RESERVED1_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNT_NEG_CAP_CMD_IDX
 ******************************************************************************/
const ru_field_rec CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNT_NEG_CAP_CMD_IDX_FIELD =
{
    "IDX",
#if RU_INCLUDE_DESC
    "index",
    "command index inside cnpl (pointer to bacif array)",
#endif
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNT_NEG_CAP_CMD_IDX_FIELD_MASK,
    0,
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNT_NEG_CAP_CMD_IDX_FIELD_WIDTH,
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNT_NEG_CAP_CMD_IDX_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNT_NEG_CAP_CMD_CMD
 ******************************************************************************/
const ru_field_rec CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNT_NEG_CAP_CMD_CMD_FIELD =
{
    "CMD",
#if RU_INCLUDE_DESC
    "command",
    "copy of command as seen on bb_data[31:8]."
    "This can be compare to bacif debug info."
    "bit 63:60 are always 4h4 for this command, relevant params are in bit 27:11, and 10:8 are reserved.",
#endif
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNT_NEG_CAP_CMD_CMD_FIELD_MASK,
    0,
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNT_NEG_CAP_CMD_CMD_FIELD_WIDTH,
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNT_NEG_CAP_CMD_CMD_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: CNPL_BUF_MNG_COUNTERS_CFG_STAT_CTRS_VAL_VAL
 ******************************************************************************/
const ru_field_rec CNPL_BUF_MNG_COUNTERS_CFG_STAT_CTRS_VAL_VAL_FIELD =
{
    "VAL",
#if RU_INCLUDE_DESC
    "value",
    "value",
#endif
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_CTRS_VAL_VAL_FIELD_MASK,
    0,
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_CTRS_VAL_VAL_FIELD_WIDTH,
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_CTRS_VAL_VAL_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: CNPL_BUF_MNG_COUNTERS_CFG_STAT_CTRS_VAL_RESERVED0
 ******************************************************************************/
const ru_field_rec CNPL_BUF_MNG_COUNTERS_CFG_STAT_CTRS_VAL_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_CTRS_VAL_RESERVED0_FIELD_MASK,
    0,
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_CTRS_VAL_RESERVED0_FIELD_WIDTH,
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_CTRS_VAL_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: CNPL_SW_IF_SW_CMD_VAL
 ******************************************************************************/
const ru_field_rec CNPL_SW_IF_SW_CMD_VAL_FIELD =
{
    "VAL",
#if RU_INCLUDE_DESC
    "value",
    "value of register",
#endif
    CNPL_SW_IF_SW_CMD_VAL_FIELD_MASK,
    0,
    CNPL_SW_IF_SW_CMD_VAL_FIELD_WIDTH,
    CNPL_SW_IF_SW_CMD_VAL_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: CNPL_SW_IF_SW_STAT_CN_RD_ST
 ******************************************************************************/
const ru_field_rec CNPL_SW_IF_SW_STAT_CN_RD_ST_FIELD =
{
    "CN_RD_ST",
#if RU_INCLUDE_DESC
    "cnt_rd_status",
    "0: DONE (ready)"
    "1: PROC(not ready)",
#endif
    CNPL_SW_IF_SW_STAT_CN_RD_ST_FIELD_MASK,
    0,
    CNPL_SW_IF_SW_STAT_CN_RD_ST_FIELD_WIDTH,
    CNPL_SW_IF_SW_STAT_CN_RD_ST_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: CNPL_SW_IF_SW_STAT_PL_PLC_ST
 ******************************************************************************/
const ru_field_rec CNPL_SW_IF_SW_STAT_PL_PLC_ST_FIELD =
{
    "PL_PLC_ST",
#if RU_INCLUDE_DESC
    "pl_plc_status",
    "0: DONE (ready)"
    "1: PROC(not ready)",
#endif
    CNPL_SW_IF_SW_STAT_PL_PLC_ST_FIELD_MASK,
    0,
    CNPL_SW_IF_SW_STAT_PL_PLC_ST_FIELD_WIDTH,
    CNPL_SW_IF_SW_STAT_PL_PLC_ST_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: CNPL_SW_IF_SW_STAT_PL_RD_ST
 ******************************************************************************/
const ru_field_rec CNPL_SW_IF_SW_STAT_PL_RD_ST_FIELD =
{
    "PL_RD_ST",
#if RU_INCLUDE_DESC
    "pl_rd_status",
    "0: DONE (ready)"
    "1: PROC(not ready)",
#endif
    CNPL_SW_IF_SW_STAT_PL_RD_ST_FIELD_MASK,
    0,
    CNPL_SW_IF_SW_STAT_PL_RD_ST_FIELD_WIDTH,
    CNPL_SW_IF_SW_STAT_PL_RD_ST_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: CNPL_SW_IF_SW_STAT_RESERVED0
 ******************************************************************************/
const ru_field_rec CNPL_SW_IF_SW_STAT_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    CNPL_SW_IF_SW_STAT_RESERVED0_FIELD_MASK,
    0,
    CNPL_SW_IF_SW_STAT_RESERVED0_FIELD_WIDTH,
    CNPL_SW_IF_SW_STAT_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: CNPL_SW_IF_SW_PL_RSLT_RESERVED0
 ******************************************************************************/
const ru_field_rec CNPL_SW_IF_SW_PL_RSLT_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    CNPL_SW_IF_SW_PL_RSLT_RESERVED0_FIELD_MASK,
    0,
    CNPL_SW_IF_SW_PL_RSLT_RESERVED0_FIELD_WIDTH,
    CNPL_SW_IF_SW_PL_RSLT_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: CNPL_SW_IF_SW_PL_RSLT_COL
 ******************************************************************************/
const ru_field_rec CNPL_SW_IF_SW_PL_RSLT_COL_FIELD =
{
    "COL",
#if RU_INCLUDE_DESC
    "color",
    "red, yellow, green, non-active",
#endif
    CNPL_SW_IF_SW_PL_RSLT_COL_FIELD_MASK,
    0,
    CNPL_SW_IF_SW_PL_RSLT_COL_FIELD_WIDTH,
    CNPL_SW_IF_SW_PL_RSLT_COL_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: CNPL_SW_IF_SW_PL_RD_RD
 ******************************************************************************/
const ru_field_rec CNPL_SW_IF_SW_PL_RD_RD_FIELD =
{
    "RD",
#if RU_INCLUDE_DESC
    "read_data",
    "value of read data",
#endif
    CNPL_SW_IF_SW_PL_RD_RD_FIELD_MASK,
    0,
    CNPL_SW_IF_SW_PL_RD_RD_FIELD_WIDTH,
    CNPL_SW_IF_SW_PL_RD_RD_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: CNPL_SW_IF_SW_CNT_RD_RD
 ******************************************************************************/
const ru_field_rec CNPL_SW_IF_SW_CNT_RD_RD_FIELD =
{
    "RD",
#if RU_INCLUDE_DESC
    "read_data",
    "value of read data",
#endif
    CNPL_SW_IF_SW_CNT_RD_RD_FIELD_MASK,
    0,
    CNPL_SW_IF_SW_CNT_RD_RD_FIELD_WIDTH,
    CNPL_SW_IF_SW_CNT_RD_RD_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: CNPL_MISC_ARB_PRM_SW_PRIO
 ******************************************************************************/
const ru_field_rec CNPL_MISC_ARB_PRM_SW_PRIO_FIELD =
{
    "SW_PRIO",
#if RU_INCLUDE_DESC
    "sw_prio",
    "0: fixed lower"
    "1: rr with fw (default)"
    "2: fixed higher",
#endif
    CNPL_MISC_ARB_PRM_SW_PRIO_FIELD_MASK,
    0,
    CNPL_MISC_ARB_PRM_SW_PRIO_FIELD_WIDTH,
    CNPL_MISC_ARB_PRM_SW_PRIO_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: CNPL_MISC_ARB_PRM_RESERVED0
 ******************************************************************************/
const ru_field_rec CNPL_MISC_ARB_PRM_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    CNPL_MISC_ARB_PRM_RESERVED0_FIELD_MASK,
    0,
    CNPL_MISC_ARB_PRM_RESERVED0_FIELD_WIDTH,
    CNPL_MISC_ARB_PRM_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: CNPL_MISC_COL_AWR_EN_EN
 ******************************************************************************/
const ru_field_rec CNPL_MISC_COL_AWR_EN_EN_FIELD =
{
    "EN",
#if RU_INCLUDE_DESC
    "en",
    "0: dis"
    "1: en",
#endif
    CNPL_MISC_COL_AWR_EN_EN_FIELD_MASK,
    0,
    CNPL_MISC_COL_AWR_EN_EN_FIELD_WIDTH,
    CNPL_MISC_COL_AWR_EN_EN_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: CNPL_MISC_COL_AWR_EN_RESERVED0
 ******************************************************************************/
const ru_field_rec CNPL_MISC_COL_AWR_EN_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    CNPL_MISC_COL_AWR_EN_RESERVED0_FIELD_MASK,
    0,
    CNPL_MISC_COL_AWR_EN_RESERVED0_FIELD_WIDTH,
    CNPL_MISC_COL_AWR_EN_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: CNPL_PM_COUNTERS_ENG_CMDS_VAL
 ******************************************************************************/
const ru_field_rec CNPL_PM_COUNTERS_ENG_CMDS_VAL_FIELD =
{
    "VAL",
#if RU_INCLUDE_DESC
    "value",
    "value",
#endif
    CNPL_PM_COUNTERS_ENG_CMDS_VAL_FIELD_MASK,
    0,
    CNPL_PM_COUNTERS_ENG_CMDS_VAL_FIELD_WIDTH,
    CNPL_PM_COUNTERS_ENG_CMDS_VAL_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: CNPL_PM_COUNTERS_CMD_WAIT_VAL
 ******************************************************************************/
const ru_field_rec CNPL_PM_COUNTERS_CMD_WAIT_VAL_FIELD =
{
    "VAL",
#if RU_INCLUDE_DESC
    "value",
    "value",
#endif
    CNPL_PM_COUNTERS_CMD_WAIT_VAL_FIELD_MASK,
    0,
    CNPL_PM_COUNTERS_CMD_WAIT_VAL_FIELD_WIDTH,
    CNPL_PM_COUNTERS_CMD_WAIT_VAL_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: CNPL_PM_COUNTERS_TOT_CYC_VAL
 ******************************************************************************/
const ru_field_rec CNPL_PM_COUNTERS_TOT_CYC_VAL_FIELD =
{
    "VAL",
#if RU_INCLUDE_DESC
    "value",
    "value",
#endif
    CNPL_PM_COUNTERS_TOT_CYC_VAL_FIELD_MASK,
    0,
    CNPL_PM_COUNTERS_TOT_CYC_VAL_FIELD_WIDTH,
    CNPL_PM_COUNTERS_TOT_CYC_VAL_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: CNPL_PM_COUNTERS_GNT_CYC_VAL
 ******************************************************************************/
const ru_field_rec CNPL_PM_COUNTERS_GNT_CYC_VAL_FIELD =
{
    "VAL",
#if RU_INCLUDE_DESC
    "value",
    "value",
#endif
    CNPL_PM_COUNTERS_GNT_CYC_VAL_FIELD_MASK,
    0,
    CNPL_PM_COUNTERS_GNT_CYC_VAL_FIELD_WIDTH,
    CNPL_PM_COUNTERS_GNT_CYC_VAL_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: CNPL_PM_COUNTERS_ARB_CYC_VAL
 ******************************************************************************/
const ru_field_rec CNPL_PM_COUNTERS_ARB_CYC_VAL_FIELD =
{
    "VAL",
#if RU_INCLUDE_DESC
    "value",
    "value",
#endif
    CNPL_PM_COUNTERS_ARB_CYC_VAL_FIELD_MASK,
    0,
    CNPL_PM_COUNTERS_ARB_CYC_VAL_FIELD_WIDTH,
    CNPL_PM_COUNTERS_ARB_CYC_VAL_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: CNPL_PM_COUNTERS_PL_UP_ERR_VAL
 ******************************************************************************/
const ru_field_rec CNPL_PM_COUNTERS_PL_UP_ERR_VAL_FIELD =
{
    "VAL",
#if RU_INCLUDE_DESC
    "value",
    "value",
#endif
    CNPL_PM_COUNTERS_PL_UP_ERR_VAL_FIELD_MASK,
    0,
    CNPL_PM_COUNTERS_PL_UP_ERR_VAL_FIELD_WIDTH,
    CNPL_PM_COUNTERS_PL_UP_ERR_VAL_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: CNPL_PM_COUNTERS_GEN_CFG_RD_CLR
 ******************************************************************************/
const ru_field_rec CNPL_PM_COUNTERS_GEN_CFG_RD_CLR_FIELD =
{
    "RD_CLR",
#if RU_INCLUDE_DESC
    "rd_clr",
    "read clear bit",
#endif
    CNPL_PM_COUNTERS_GEN_CFG_RD_CLR_FIELD_MASK,
    0,
    CNPL_PM_COUNTERS_GEN_CFG_RD_CLR_FIELD_WIDTH,
    CNPL_PM_COUNTERS_GEN_CFG_RD_CLR_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: CNPL_PM_COUNTERS_GEN_CFG_WRAP
 ******************************************************************************/
const ru_field_rec CNPL_PM_COUNTERS_GEN_CFG_WRAP_FIELD =
{
    "WRAP",
#if RU_INCLUDE_DESC
    "wrap",
    "read clear bit",
#endif
    CNPL_PM_COUNTERS_GEN_CFG_WRAP_FIELD_MASK,
    0,
    CNPL_PM_COUNTERS_GEN_CFG_WRAP_FIELD_WIDTH,
    CNPL_PM_COUNTERS_GEN_CFG_WRAP_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: CNPL_PM_COUNTERS_GEN_CFG_RESERVED0
 ******************************************************************************/
const ru_field_rec CNPL_PM_COUNTERS_GEN_CFG_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    CNPL_PM_COUNTERS_GEN_CFG_RESERVED0_FIELD_MASK,
    0,
    CNPL_PM_COUNTERS_GEN_CFG_RESERVED0_FIELD_WIDTH,
    CNPL_PM_COUNTERS_GEN_CFG_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: CNPL_DEBUG_DBGSEL_VS
 ******************************************************************************/
const ru_field_rec CNPL_DEBUG_DBGSEL_VS_FIELD =
{
    "VS",
#if RU_INCLUDE_DESC
    "vector_select",
    "selects th debug vector",
#endif
    CNPL_DEBUG_DBGSEL_VS_FIELD_MASK,
    0,
    CNPL_DEBUG_DBGSEL_VS_FIELD_WIDTH,
    CNPL_DEBUG_DBGSEL_VS_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: CNPL_DEBUG_DBGSEL_RESERVED0
 ******************************************************************************/
const ru_field_rec CNPL_DEBUG_DBGSEL_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    CNPL_DEBUG_DBGSEL_RESERVED0_FIELD_MASK,
    0,
    CNPL_DEBUG_DBGSEL_RESERVED0_FIELD_WIDTH,
    CNPL_DEBUG_DBGSEL_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_rw
#endif
};

/******************************************************************************
 * Field: CNPL_DEBUG_DBGBUS_VB
 ******************************************************************************/
const ru_field_rec CNPL_DEBUG_DBGBUS_VB_FIELD =
{
    "VB",
#if RU_INCLUDE_DESC
    "dbg_bus",
    "debug vector",
#endif
    CNPL_DEBUG_DBGBUS_VB_FIELD_MASK,
    0,
    CNPL_DEBUG_DBGBUS_VB_FIELD_WIDTH,
    CNPL_DEBUG_DBGBUS_VB_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: CNPL_DEBUG_DBGBUS_RESERVED0
 ******************************************************************************/
const ru_field_rec CNPL_DEBUG_DBGBUS_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    CNPL_DEBUG_DBGBUS_RESERVED0_FIELD_MASK,
    0,
    CNPL_DEBUG_DBGBUS_RESERVED0_FIELD_WIDTH,
    CNPL_DEBUG_DBGBUS_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: CNPL_DEBUG_REQ_VEC_REQ
 ******************************************************************************/
const ru_field_rec CNPL_DEBUG_REQ_VEC_REQ_FIELD =
{
    "REQ",
#if RU_INCLUDE_DESC
    "all_requests",
    "still more commands for arbitration",
#endif
    CNPL_DEBUG_REQ_VEC_REQ_FIELD_MASK,
    0,
    CNPL_DEBUG_REQ_VEC_REQ_FIELD_WIDTH,
    CNPL_DEBUG_REQ_VEC_REQ_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: CNPL_DEBUG_REQ_VEC_RESERVED0
 ******************************************************************************/
const ru_field_rec CNPL_DEBUG_REQ_VEC_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    CNPL_DEBUG_REQ_VEC_RESERVED0_FIELD_MASK,
    0,
    CNPL_DEBUG_REQ_VEC_RESERVED0_FIELD_WIDTH,
    CNPL_DEBUG_REQ_VEC_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: CNPL_DEBUG_POL_UP_ST_ITR_NUM
 ******************************************************************************/
const ru_field_rec CNPL_DEBUG_POL_UP_ST_ITR_NUM_FIELD =
{
    "ITR_NUM",
#if RU_INCLUDE_DESC
    "itr_num",
    "number of iteration we are(each represent 8192 cycles)",
#endif
    CNPL_DEBUG_POL_UP_ST_ITR_NUM_FIELD_MASK,
    0,
    CNPL_DEBUG_POL_UP_ST_ITR_NUM_FIELD_WIDTH,
    CNPL_DEBUG_POL_UP_ST_ITR_NUM_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: CNPL_DEBUG_POL_UP_ST_POL_NUM
 ******************************************************************************/
const ru_field_rec CNPL_DEBUG_POL_UP_ST_POL_NUM_FIELD =
{
    "POL_NUM",
#if RU_INCLUDE_DESC
    "pol_num",
    "number of policer now updated."
    "(80 means we finished updated of all policers for this period)",
#endif
    CNPL_DEBUG_POL_UP_ST_POL_NUM_FIELD_MASK,
    0,
    CNPL_DEBUG_POL_UP_ST_POL_NUM_FIELD_WIDTH,
    CNPL_DEBUG_POL_UP_ST_POL_NUM_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

/******************************************************************************
 * Field: CNPL_DEBUG_POL_UP_ST_RESERVED0
 ******************************************************************************/
const ru_field_rec CNPL_DEBUG_POL_UP_ST_RESERVED0_FIELD =
{
    "RESERVED0",
#if RU_INCLUDE_DESC
    "",
    "",
#endif
    CNPL_DEBUG_POL_UP_ST_RESERVED0_FIELD_MASK,
    0,
    CNPL_DEBUG_POL_UP_ST_RESERVED0_FIELD_WIDTH,
    CNPL_DEBUG_POL_UP_ST_RESERVED0_FIELD_SHIFT,
#if RU_INCLUDE_ACCESS
    ru_access_read
#endif
};

#endif /* RU_INCLUDE_FIELD_DB */

/******************************************************************************
 * Register: CNPL_MEMORY_DATA
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *CNPL_MEMORY_DATA_FIELDS[] =
{
    &CNPL_MEMORY_DATA_DATA_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec CNPL_MEMORY_DATA_REG = 
{
    "MEMORY_DATA",
#if RU_INCLUDE_DESC
    "MEM_ENTRY %i Register",
    "mem_entry",
#endif
    CNPL_MEMORY_DATA_REG_OFFSET,
    CNPL_MEMORY_DATA_REG_RAM_CNT,
    4,
    1201,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    CNPL_MEMORY_DATA_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: CNPL_COUNTERS_CONFIGURATIONS_CN_LOC_PROF
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *CNPL_COUNTERS_CONFIGURATIONS_CN_LOC_PROF_FIELDS[] =
{
    &CNPL_COUNTERS_CONFIGURATIONS_CN_LOC_PROF_BA_FIELD,
    &CNPL_COUNTERS_CONFIGURATIONS_CN_LOC_PROF_CN0_BYTS_FIELD,
    &CNPL_COUNTERS_CONFIGURATIONS_CN_LOC_PROF_DOUBLLE_FIELD,
    &CNPL_COUNTERS_CONFIGURATIONS_CN_LOC_PROF_WRAP_FIELD,
    &CNPL_COUNTERS_CONFIGURATIONS_CN_LOC_PROF_CLR_FIELD,
    &CNPL_COUNTERS_CONFIGURATIONS_CN_LOC_PROF_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec CNPL_COUNTERS_CONFIGURATIONS_CN_LOC_PROF_REG = 
{
    "COUNTERS_CONFIGURATIONS_CN_LOC_PROF",
#if RU_INCLUDE_DESC
    "CNT_LOC_PROFILE %i Register",
    "location profiles",
#endif
    CNPL_COUNTERS_CONFIGURATIONS_CN_LOC_PROF_REG_OFFSET,
    CNPL_COUNTERS_CONFIGURATIONS_CN_LOC_PROF_REG_RAM_CNT,
    4,
    1202,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    6,
    CNPL_COUNTERS_CONFIGURATIONS_CN_LOC_PROF_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: CNPL_POLICERS_CONFIGURATIONS_PL_LOC_PROF0
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *CNPL_POLICERS_CONFIGURATIONS_PL_LOC_PROF0_FIELDS[] =
{
    &CNPL_POLICERS_CONFIGURATIONS_PL_LOC_PROF0_BK_BA_FIELD,
    &CNPL_POLICERS_CONFIGURATIONS_PL_LOC_PROF0_PA_BA_FIELD,
    &CNPL_POLICERS_CONFIGURATIONS_PL_LOC_PROF0_DOUBLLE_FIELD,
    &CNPL_POLICERS_CONFIGURATIONS_PL_LOC_PROF0_FC_FIELD,
    &CNPL_POLICERS_CONFIGURATIONS_PL_LOC_PROF0_N_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec CNPL_POLICERS_CONFIGURATIONS_PL_LOC_PROF0_REG = 
{
    "POLICERS_CONFIGURATIONS_PL_LOC_PROF0",
#if RU_INCLUDE_DESC
    "PL_LOC_PROFILE0 %i Register",
    "1st reg for location profiles",
#endif
    CNPL_POLICERS_CONFIGURATIONS_PL_LOC_PROF0_REG_OFFSET,
    CNPL_POLICERS_CONFIGURATIONS_PL_LOC_PROF0_REG_RAM_CNT,
    4,
    1203,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    5,
    CNPL_POLICERS_CONFIGURATIONS_PL_LOC_PROF0_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: CNPL_POLICERS_CONFIGURATIONS_PL_LOC_PROF1
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *CNPL_POLICERS_CONFIGURATIONS_PL_LOC_PROF1_FIELDS[] =
{
    &CNPL_POLICERS_CONFIGURATIONS_PL_LOC_PROF1_PL_ST_FIELD,
    &CNPL_POLICERS_CONFIGURATIONS_PL_LOC_PROF1_PL_END_FIELD,
    &CNPL_POLICERS_CONFIGURATIONS_PL_LOC_PROF1_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec CNPL_POLICERS_CONFIGURATIONS_PL_LOC_PROF1_REG = 
{
    "POLICERS_CONFIGURATIONS_PL_LOC_PROF1",
#if RU_INCLUDE_DESC
    "PL_LOC_PROFILE1 %i Register",
    "2nd reg for location profiles",
#endif
    CNPL_POLICERS_CONFIGURATIONS_PL_LOC_PROF1_REG_OFFSET,
    CNPL_POLICERS_CONFIGURATIONS_PL_LOC_PROF1_REG_RAM_CNT,
    4,
    1204,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    3,
    CNPL_POLICERS_CONFIGURATIONS_PL_LOC_PROF1_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: CNPL_POLICERS_CONFIGURATIONS_PL_CALC_TYPE
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *CNPL_POLICERS_CONFIGURATIONS_PL_CALC_TYPE_FIELDS[] =
{
    &CNPL_POLICERS_CONFIGURATIONS_PL_CALC_TYPE_VEC_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec CNPL_POLICERS_CONFIGURATIONS_PL_CALC_TYPE_REG = 
{
    "POLICERS_CONFIGURATIONS_PL_CALC_TYPE",
#if RU_INCLUDE_DESC
    "PL_CALC_TYPE %i Register",
    "calculation type register."
    "0:green, yellow, red"
    "1:red, yellow, green"
    ""
    "3 registers support up to 96 policers. Currently we have only 80 policers.",
#endif
    CNPL_POLICERS_CONFIGURATIONS_PL_CALC_TYPE_REG_OFFSET,
    CNPL_POLICERS_CONFIGURATIONS_PL_CALC_TYPE_REG_RAM_CNT,
    4,
    1205,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    CNPL_POLICERS_CONFIGURATIONS_PL_CALC_TYPE_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: CNPL_POLICERS_CONFIGURATIONS_PER_UP
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *CNPL_POLICERS_CONFIGURATIONS_PER_UP_FIELDS[] =
{
    &CNPL_POLICERS_CONFIGURATIONS_PER_UP_EN_FIELD,
    &CNPL_POLICERS_CONFIGURATIONS_PER_UP_MTU_FIELD,
    &CNPL_POLICERS_CONFIGURATIONS_PER_UP_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec CNPL_POLICERS_CONFIGURATIONS_PER_UP_REG = 
{
    "POLICERS_CONFIGURATIONS_PER_UP",
#if RU_INCLUDE_DESC
    "PL_PERIODIC_UPDATE Register",
    "periodic update parameters",
#endif
    CNPL_POLICERS_CONFIGURATIONS_PER_UP_REG_OFFSET,
    0,
    0,
    1206,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    3,
    CNPL_POLICERS_CONFIGURATIONS_PER_UP_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: CNPL_POLICERS_CONFIGURATIONS_PL_SIZE_PROF
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *CNPL_POLICERS_CONFIGURATIONS_PL_SIZE_PROF_FIELDS[] =
{
    &CNPL_POLICERS_CONFIGURATIONS_PL_SIZE_PROF_PRF0_FIELD,
    &CNPL_POLICERS_CONFIGURATIONS_PL_SIZE_PROF_PRF1_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec CNPL_POLICERS_CONFIGURATIONS_PL_SIZE_PROF_REG = 
{
    "POLICERS_CONFIGURATIONS_PL_SIZE_PROF",
#if RU_INCLUDE_DESC
    "PL_SIZE_PROFILE %i Register",
    "8 profiles, 16b each, for calculation of bucket size",
#endif
    CNPL_POLICERS_CONFIGURATIONS_PL_SIZE_PROF_REG_OFFSET,
    CNPL_POLICERS_CONFIGURATIONS_PL_SIZE_PROF_REG_RAM_CNT,
    4,
    1207,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    2,
    CNPL_POLICERS_CONFIGURATIONS_PL_SIZE_PROF_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: CNPL_BUF_MNG_COUNTERS_CFG_STAT_ORDR
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *CNPL_BUF_MNG_COUNTERS_CFG_STAT_ORDR_FIELDS[] =
{
    &CNPL_BUF_MNG_COUNTERS_CFG_STAT_ORDR_NXTLVL_FIELD,
    &CNPL_BUF_MNG_COUNTERS_CFG_STAT_ORDR_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec CNPL_BUF_MNG_COUNTERS_CFG_STAT_ORDR_REG = 
{
    "BUF_MNG_COUNTERS_CFG_STAT_ORDR",
#if RU_INCLUDE_DESC
    "CNTRS_ORDER %i Register",
    "order of counters for buffer management engine",
#endif
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_ORDR_REG_OFFSET,
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_ORDR_REG_RAM_CNT,
    4,
    1208,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    2,
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_ORDR_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: CNPL_BUF_MNG_COUNTERS_CFG_STAT_RSRV_THR
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *CNPL_BUF_MNG_COUNTERS_CFG_STAT_RSRV_THR_FIELDS[] =
{
    &CNPL_BUF_MNG_COUNTERS_CFG_STAT_RSRV_THR_THR_FIELD,
    &CNPL_BUF_MNG_COUNTERS_CFG_STAT_RSRV_THR_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec CNPL_BUF_MNG_COUNTERS_CFG_STAT_RSRV_THR_REG = 
{
    "BUF_MNG_COUNTERS_CFG_STAT_RSRV_THR",
#if RU_INCLUDE_DESC
    "RSRV_THR %i Register",
    "reserved threshold",
#endif
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_RSRV_THR_REG_OFFSET,
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_RSRV_THR_REG_RAM_CNT,
    4,
    1209,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    2,
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_RSRV_THR_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: CNPL_BUF_MNG_COUNTERS_CFG_STAT_HIPRI_THR
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *CNPL_BUF_MNG_COUNTERS_CFG_STAT_HIPRI_THR_FIELDS[] =
{
    &CNPL_BUF_MNG_COUNTERS_CFG_STAT_HIPRI_THR_THR_FIELD,
    &CNPL_BUF_MNG_COUNTERS_CFG_STAT_HIPRI_THR_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec CNPL_BUF_MNG_COUNTERS_CFG_STAT_HIPRI_THR_REG = 
{
    "BUF_MNG_COUNTERS_CFG_STAT_HIPRI_THR",
#if RU_INCLUDE_DESC
    "HIPRI_THR %i Register",
    "high priority threshold",
#endif
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_HIPRI_THR_REG_OFFSET,
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_HIPRI_THR_REG_RAM_CNT,
    4,
    1210,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    2,
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_HIPRI_THR_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: CNPL_BUF_MNG_COUNTERS_CFG_STAT_MAX_THR
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *CNPL_BUF_MNG_COUNTERS_CFG_STAT_MAX_THR_FIELDS[] =
{
    &CNPL_BUF_MNG_COUNTERS_CFG_STAT_MAX_THR_THR_FIELD,
    &CNPL_BUF_MNG_COUNTERS_CFG_STAT_MAX_THR_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec CNPL_BUF_MNG_COUNTERS_CFG_STAT_MAX_THR_REG = 
{
    "BUF_MNG_COUNTERS_CFG_STAT_MAX_THR",
#if RU_INCLUDE_DESC
    "MNG_MAX_THR %i Register",
    "max threshold",
#endif
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_MAX_THR_REG_OFFSET,
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_MAX_THR_REG_RAM_CNT,
    4,
    1211,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    2,
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_MAX_THR_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: CNPL_BUF_MNG_COUNTERS_CFG_STAT_HI_WMRK_CFG
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *CNPL_BUF_MNG_COUNTERS_CFG_STAT_HI_WMRK_CFG_FIELDS[] =
{
    &CNPL_BUF_MNG_COUNTERS_CFG_STAT_HI_WMRK_CFG_CTR0_FIELD,
    &CNPL_BUF_MNG_COUNTERS_CFG_STAT_HI_WMRK_CFG_RESERVED0_FIELD,
    &CNPL_BUF_MNG_COUNTERS_CFG_STAT_HI_WMRK_CFG_CTR1_FIELD,
    &CNPL_BUF_MNG_COUNTERS_CFG_STAT_HI_WMRK_CFG_RESERVED1_FIELD,
    &CNPL_BUF_MNG_COUNTERS_CFG_STAT_HI_WMRK_CFG_CTR2_FIELD,
    &CNPL_BUF_MNG_COUNTERS_CFG_STAT_HI_WMRK_CFG_RESERVED2_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec CNPL_BUF_MNG_COUNTERS_CFG_STAT_HI_WMRK_CFG_REG = 
{
    "BUF_MNG_COUNTERS_CFG_STAT_HI_WMRK_CFG",
#if RU_INCLUDE_DESC
    "HI_WATERMARK_CFG Register",
    "3 counter numbers to get the high watermark of.",
#endif
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_HI_WMRK_CFG_REG_OFFSET,
    0,
    0,
    1212,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    6,
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_HI_WMRK_CFG_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: CNPL_BUF_MNG_COUNTERS_CFG_STAT_HI_WMRK_VAL
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *CNPL_BUF_MNG_COUNTERS_CFG_STAT_HI_WMRK_VAL_FIELDS[] =
{
    &CNPL_BUF_MNG_COUNTERS_CFG_STAT_HI_WMRK_VAL_VAL_FIELD,
    &CNPL_BUF_MNG_COUNTERS_CFG_STAT_HI_WMRK_VAL_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec CNPL_BUF_MNG_COUNTERS_CFG_STAT_HI_WMRK_VAL_REG = 
{
    "BUF_MNG_COUNTERS_CFG_STAT_HI_WMRK_VAL",
#if RU_INCLUDE_DESC
    "HI_WATERMARK_VAL %i Register",
    "hi-watermark counters  values",
#endif
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_HI_WMRK_VAL_REG_OFFSET,
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_HI_WMRK_VAL_REG_RAM_CNT,
    4,
    1213,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    2,
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_HI_WMRK_VAL_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNTR_INIT
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNTR_INIT_FIELDS[] =
{
    &CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNTR_INIT_IDX_FIELD,
    &CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNTR_INIT_RESERVED0_FIELD,
    &CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNTR_INIT_VAL_FIELD,
    &CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNTR_INIT_RESERVED1_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNTR_INIT_REG = 
{
    "BUF_MNG_COUNTERS_CFG_STAT_CNTR_INIT",
#if RU_INCLUDE_DESC
    "CNTR_INIT Register",
    "initialize counter with a value",
#endif
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNTR_INIT_REG_OFFSET,
    0,
    0,
    1214,
#if RU_INCLUDE_ACCESS
    ru_access_write,
#endif
#if RU_INCLUDE_FIELD_DB
    4,
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNTR_INIT_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNTR_NEG_ST
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNTR_NEG_ST_FIELDS[] =
{
    &CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNTR_NEG_ST_VAL_FIELD,
    &CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNTR_NEG_ST_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNTR_NEG_ST_REG = 
{
    "BUF_MNG_COUNTERS_CFG_STAT_CNTR_NEG_ST",
#if RU_INCLUDE_DESC
    "CNTR_NEG_STAT Register",
    "16b vector."
    "If bit=1, the counter got a wrong decrement command that was supposed to turn it negative",
#endif
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNTR_NEG_ST_REG_OFFSET,
    0,
    0,
    1215,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    2,
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNTR_NEG_ST_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNTR_NEG_ST_CLR
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNTR_NEG_ST_CLR_FIELDS[] =
{
    &CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNTR_NEG_ST_CLR_VAL_FIELD,
    &CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNTR_NEG_ST_CLR_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNTR_NEG_ST_CLR_REG = 
{
    "BUF_MNG_COUNTERS_CFG_STAT_CNTR_NEG_ST_CLR",
#if RU_INCLUDE_DESC
    "CNTR_NEG_STAT_CLR Register",
    "16b vector."
    "If bit=1, it clears corresponding bit in cntr_neg_stat register",
#endif
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNTR_NEG_ST_CLR_REG_OFFSET,
    0,
    0,
    1216,
#if RU_INCLUDE_ACCESS
    ru_access_write,
#endif
#if RU_INCLUDE_FIELD_DB
    2,
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNTR_NEG_ST_CLR_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: CNPL_BUF_MNG_COUNTERS_CFG_STAT_CAPT_CFG
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *CNPL_BUF_MNG_COUNTERS_CFG_STAT_CAPT_CFG_FIELDS[] =
{
    &CNPL_BUF_MNG_COUNTERS_CFG_STAT_CAPT_CFG_MOD_FIELD,
    &CNPL_BUF_MNG_COUNTERS_CFG_STAT_CAPT_CFG_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec CNPL_BUF_MNG_COUNTERS_CFG_STAT_CAPT_CFG_REG = 
{
    "BUF_MNG_COUNTERS_CFG_STAT_CAPT_CFG",
#if RU_INCLUDE_DESC
    "CAPTURE_CONFIG Register",
    "capture configuration"
    "0: capture last negative cmd/cntrs"
    "1: capture last cmd/cntrs",
#endif
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_CAPT_CFG_REG_OFFSET,
    0,
    0,
    1217,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    2,
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_CAPT_CFG_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNT_NEG_CAP_CNT
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNT_NEG_CAP_CNT_FIELDS[] =
{
    &CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNT_NEG_CAP_CNT_IDX_FIELD,
    &CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNT_NEG_CAP_CNT_RESERVED0_FIELD,
    &CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNT_NEG_CAP_CNT_VAL_FIELD,
    &CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNT_NEG_CAP_CNT_RESERVED1_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNT_NEG_CAP_CNT_REG = 
{
    "BUF_MNG_COUNTERS_CFG_STAT_CNT_NEG_CAP_CNT",
#if RU_INCLUDE_DESC
    "CNTR_NEG_CAPT_CNTR %i Register",
    "3 counters capturing values of  counters before last corrupt command (supposed to turn one of these counters negative)."
    "order:"
    "0:lvl0"
    "4:lvl1"
    "8:lvl2",
#endif
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNT_NEG_CAP_CNT_REG_OFFSET,
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNT_NEG_CAP_CNT_REG_RAM_CNT,
    4,
    1218,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    4,
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNT_NEG_CAP_CNT_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNT_NEG_CAP_CMD
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNT_NEG_CAP_CMD_FIELDS[] =
{
    &CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNT_NEG_CAP_CMD_IDX_FIELD,
    &CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNT_NEG_CAP_CMD_CMD_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNT_NEG_CAP_CMD_REG = 
{
    "BUF_MNG_COUNTERS_CFG_STAT_CNT_NEG_CAP_CMD",
#if RU_INCLUDE_DESC
    "CNTR_NEG_CAPT_CMD Register",
    "last corrupt command (supposed to turn one of the counters negative).",
#endif
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNT_NEG_CAP_CMD_REG_OFFSET,
    0,
    0,
    1219,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    2,
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNT_NEG_CAP_CMD_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: CNPL_BUF_MNG_COUNTERS_CFG_STAT_CTRS_VAL
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *CNPL_BUF_MNG_COUNTERS_CFG_STAT_CTRS_VAL_FIELDS[] =
{
    &CNPL_BUF_MNG_COUNTERS_CFG_STAT_CTRS_VAL_VAL_FIELD,
    &CNPL_BUF_MNG_COUNTERS_CFG_STAT_CTRS_VAL_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec CNPL_BUF_MNG_COUNTERS_CFG_STAT_CTRS_VAL_REG = 
{
    "BUF_MNG_COUNTERS_CFG_STAT_CTRS_VAL",
#if RU_INCLUDE_DESC
    "CNTRS_VAL %i Register",
    "counters current values",
#endif
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_CTRS_VAL_REG_OFFSET,
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_CTRS_VAL_REG_RAM_CNT,
    4,
    1220,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    2,
    CNPL_BUF_MNG_COUNTERS_CFG_STAT_CTRS_VAL_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: CNPL_SW_IF_SW_CMD
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *CNPL_SW_IF_SW_CMD_FIELDS[] =
{
    &CNPL_SW_IF_SW_CMD_VAL_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec CNPL_SW_IF_SW_CMD_REG = 
{
    "SW_IF_SW_CMD",
#if RU_INCLUDE_DESC
    "COMMAND Register",
    "command register",
#endif
    CNPL_SW_IF_SW_CMD_REG_OFFSET,
    0,
    0,
    1221,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    CNPL_SW_IF_SW_CMD_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: CNPL_SW_IF_SW_STAT
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *CNPL_SW_IF_SW_STAT_FIELDS[] =
{
    &CNPL_SW_IF_SW_STAT_CN_RD_ST_FIELD,
    &CNPL_SW_IF_SW_STAT_PL_PLC_ST_FIELD,
    &CNPL_SW_IF_SW_STAT_PL_RD_ST_FIELD,
    &CNPL_SW_IF_SW_STAT_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec CNPL_SW_IF_SW_STAT_REG = 
{
    "SW_IF_SW_STAT",
#if RU_INCLUDE_DESC
    "STATUS Register",
    "status register",
#endif
    CNPL_SW_IF_SW_STAT_REG_OFFSET,
    0,
    0,
    1222,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    4,
    CNPL_SW_IF_SW_STAT_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: CNPL_SW_IF_SW_PL_RSLT
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *CNPL_SW_IF_SW_PL_RSLT_FIELDS[] =
{
    &CNPL_SW_IF_SW_PL_RSLT_RESERVED0_FIELD,
    &CNPL_SW_IF_SW_PL_RSLT_COL_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec CNPL_SW_IF_SW_PL_RSLT_REG = 
{
    "SW_IF_SW_PL_RSLT",
#if RU_INCLUDE_DESC
    "PL_RSLT Register",
    "rdata register - policer command result",
#endif
    CNPL_SW_IF_SW_PL_RSLT_REG_OFFSET,
    0,
    0,
    1223,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    2,
    CNPL_SW_IF_SW_PL_RSLT_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: CNPL_SW_IF_SW_PL_RD
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *CNPL_SW_IF_SW_PL_RD_FIELDS[] =
{
    &CNPL_SW_IF_SW_PL_RD_RD_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec CNPL_SW_IF_SW_PL_RD_REG = 
{
    "SW_IF_SW_PL_RD",
#if RU_INCLUDE_DESC
    "PL_RDX %i Register",
    "rdata register - policer read command result. 2 register for 2 buckets. If the group has only one bucket per policer - the policers are returned in the registers as a full line: the even policers are in reg0 (0,2,4,..), and the odd are in reg1.",
#endif
    CNPL_SW_IF_SW_PL_RD_REG_OFFSET,
    CNPL_SW_IF_SW_PL_RD_REG_RAM_CNT,
    4,
    1224,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    CNPL_SW_IF_SW_PL_RD_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: CNPL_SW_IF_SW_CNT_RD
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *CNPL_SW_IF_SW_CNT_RD_FIELDS[] =
{
    &CNPL_SW_IF_SW_CNT_RD_RD_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec CNPL_SW_IF_SW_CNT_RD_REG = 
{
    "SW_IF_SW_CNT_RD",
#if RU_INCLUDE_DESC
    "CNT_RDX %i Register",
    "rdata register - counters read command result. 8 register for 32B batch. In read of single counter (burst size=1) the output will be in reg0 (the 32b where the counter is). In read of burst of counters, the counters are returned in the registers as a full line: addr[2:0]=0 section of line in reg0,2,4,6  and the addr[2:0]=4 are in reg1,3,5,7 (this means that if the start of burst is at addr[2:0]=4 section of line, the wanted output should be from reg1).",
#endif
    CNPL_SW_IF_SW_CNT_RD_REG_OFFSET,
    CNPL_SW_IF_SW_CNT_RD_REG_RAM_CNT,
    4,
    1225,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    CNPL_SW_IF_SW_CNT_RD_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: CNPL_MISC_ARB_PRM
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *CNPL_MISC_ARB_PRM_FIELDS[] =
{
    &CNPL_MISC_ARB_PRM_SW_PRIO_FIELD,
    &CNPL_MISC_ARB_PRM_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec CNPL_MISC_ARB_PRM_REG = 
{
    "MISC_ARB_PRM",
#if RU_INCLUDE_DESC
    "ARBITER_PARAM Register",
    "arbiter sw priorities",
#endif
    CNPL_MISC_ARB_PRM_REG_OFFSET,
    0,
    0,
    1226,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    2,
    CNPL_MISC_ARB_PRM_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: CNPL_MISC_COL_AWR_EN
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *CNPL_MISC_COL_AWR_EN_FIELDS[] =
{
    &CNPL_MISC_COL_AWR_EN_EN_FIELD,
    &CNPL_MISC_COL_AWR_EN_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec CNPL_MISC_COL_AWR_EN_REG = 
{
    "MISC_COL_AWR_EN",
#if RU_INCLUDE_DESC
    "COLOR_AWARE_ENABLE Register",
    "color aware enable",
#endif
    CNPL_MISC_COL_AWR_EN_REG_OFFSET,
    0,
    0,
    1227,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    2,
    CNPL_MISC_COL_AWR_EN_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: CNPL_PM_COUNTERS_ENG_CMDS
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *CNPL_PM_COUNTERS_ENG_CMDS_FIELDS[] =
{
    &CNPL_PM_COUNTERS_ENG_CMDS_VAL_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec CNPL_PM_COUNTERS_ENG_CMDS_REG = 
{
    "PM_COUNTERS_ENG_CMDS",
#if RU_INCLUDE_DESC
    "ENG_CMDS_CNTR %i Register",
    "Number of commands that were processed by the engine."
    "order:"
    "0-5: counters"
    "6-8: policers"
    "9-14: reserved"
    "15: buf-mng cntr"
    "16-19: reserved"
    "20: sw counter read"
    "21: sw policer"
    "22:sw policer rd"
    "",
#endif
    CNPL_PM_COUNTERS_ENG_CMDS_REG_OFFSET,
    CNPL_PM_COUNTERS_ENG_CMDS_REG_RAM_CNT,
    4,
    1228,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    CNPL_PM_COUNTERS_ENG_CMDS_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: CNPL_PM_COUNTERS_CMD_WAIT
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *CNPL_PM_COUNTERS_CMD_WAIT_FIELDS[] =
{
    &CNPL_PM_COUNTERS_CMD_WAIT_VAL_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec CNPL_PM_COUNTERS_CMD_WAIT_REG = 
{
    "PM_COUNTERS_CMD_WAIT",
#if RU_INCLUDE_DESC
    "CMD_WAITS_CNTR %i Register",
    "Number of wait cycles that the command waited until there was an idle engine.",
#endif
    CNPL_PM_COUNTERS_CMD_WAIT_REG_OFFSET,
    CNPL_PM_COUNTERS_CMD_WAIT_REG_RAM_CNT,
    4,
    1229,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    CNPL_PM_COUNTERS_CMD_WAIT_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: CNPL_PM_COUNTERS_TOT_CYC
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *CNPL_PM_COUNTERS_TOT_CYC_FIELDS[] =
{
    &CNPL_PM_COUNTERS_TOT_CYC_VAL_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec CNPL_PM_COUNTERS_TOT_CYC_REG = 
{
    "PM_COUNTERS_TOT_CYC",
#if RU_INCLUDE_DESC
    "TOT_CYC_CNTR Register",
    "Number of cycles from last read clear",
#endif
    CNPL_PM_COUNTERS_TOT_CYC_REG_OFFSET,
    0,
    0,
    1230,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    CNPL_PM_COUNTERS_TOT_CYC_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: CNPL_PM_COUNTERS_GNT_CYC
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *CNPL_PM_COUNTERS_GNT_CYC_FIELDS[] =
{
    &CNPL_PM_COUNTERS_GNT_CYC_VAL_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec CNPL_PM_COUNTERS_GNT_CYC_REG = 
{
    "PM_COUNTERS_GNT_CYC",
#if RU_INCLUDE_DESC
    "GNT_CYC_CNTR Register",
    "Number of cycles that there was gnt from mem arbiter",
#endif
    CNPL_PM_COUNTERS_GNT_CYC_REG_OFFSET,
    0,
    0,
    1231,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    CNPL_PM_COUNTERS_GNT_CYC_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: CNPL_PM_COUNTERS_ARB_CYC
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *CNPL_PM_COUNTERS_ARB_CYC_FIELDS[] =
{
    &CNPL_PM_COUNTERS_ARB_CYC_VAL_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec CNPL_PM_COUNTERS_ARB_CYC_REG = 
{
    "PM_COUNTERS_ARB_CYC",
#if RU_INCLUDE_DESC
    "ARB_CYC_CNTR Register",
    "Number of cycles that there was gnt with request of more than one agent",
#endif
    CNPL_PM_COUNTERS_ARB_CYC_REG_OFFSET,
    0,
    0,
    1232,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    CNPL_PM_COUNTERS_ARB_CYC_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: CNPL_PM_COUNTERS_PL_UP_ERR
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *CNPL_PM_COUNTERS_PL_UP_ERR_FIELDS[] =
{
    &CNPL_PM_COUNTERS_PL_UP_ERR_VAL_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec CNPL_PM_COUNTERS_PL_UP_ERR_REG = 
{
    "PM_COUNTERS_PL_UP_ERR",
#if RU_INCLUDE_DESC
    "POL_UP_ERR_CNTR %i Register",
    "errors in policer update: the update period finished, and not all policers have been updated yet.",
#endif
    CNPL_PM_COUNTERS_PL_UP_ERR_REG_OFFSET,
    CNPL_PM_COUNTERS_PL_UP_ERR_REG_RAM_CNT,
    4,
    1233,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    1,
    CNPL_PM_COUNTERS_PL_UP_ERR_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: CNPL_PM_COUNTERS_GEN_CFG
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *CNPL_PM_COUNTERS_GEN_CFG_FIELDS[] =
{
    &CNPL_PM_COUNTERS_GEN_CFG_RD_CLR_FIELD,
    &CNPL_PM_COUNTERS_GEN_CFG_WRAP_FIELD,
    &CNPL_PM_COUNTERS_GEN_CFG_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec CNPL_PM_COUNTERS_GEN_CFG_REG = 
{
    "PM_COUNTERS_GEN_CFG",
#if RU_INCLUDE_DESC
    "GENERAL_CONFIG Register",
    "bits rd_clr and wrap for the pm counters(above)",
#endif
    CNPL_PM_COUNTERS_GEN_CFG_REG_OFFSET,
    0,
    0,
    1234,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    3,
    CNPL_PM_COUNTERS_GEN_CFG_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: CNPL_DEBUG_DBGSEL
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *CNPL_DEBUG_DBGSEL_FIELDS[] =
{
    &CNPL_DEBUG_DBGSEL_VS_FIELD,
    &CNPL_DEBUG_DBGSEL_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec CNPL_DEBUG_DBGSEL_REG = 
{
    "DEBUG_DBGSEL",
#if RU_INCLUDE_DESC
    "DBG_MUX_SEL Register",
    "selects the debug vecore",
#endif
    CNPL_DEBUG_DBGSEL_REG_OFFSET,
    0,
    0,
    1235,
#if RU_INCLUDE_ACCESS
    ru_access_rw,
#endif
#if RU_INCLUDE_FIELD_DB
    2,
    CNPL_DEBUG_DBGSEL_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: CNPL_DEBUG_DBGBUS
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *CNPL_DEBUG_DBGBUS_FIELDS[] =
{
    &CNPL_DEBUG_DBGBUS_VB_FIELD,
    &CNPL_DEBUG_DBGBUS_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec CNPL_DEBUG_DBGBUS_REG = 
{
    "DEBUG_DBGBUS",
#if RU_INCLUDE_DESC
    "DBG_BUS Register",
    "the debug bus",
#endif
    CNPL_DEBUG_DBGBUS_REG_OFFSET,
    0,
    0,
    1236,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    2,
    CNPL_DEBUG_DBGBUS_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: CNPL_DEBUG_REQ_VEC
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *CNPL_DEBUG_REQ_VEC_FIELDS[] =
{
    &CNPL_DEBUG_REQ_VEC_REQ_FIELD,
    &CNPL_DEBUG_REQ_VEC_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec CNPL_DEBUG_REQ_VEC_REG = 
{
    "DEBUG_REQ_VEC",
#if RU_INCLUDE_DESC
    "REQUEST_VECTOR Register",
    "vector of all the requests of the clients (tx fifo not empty)",
#endif
    CNPL_DEBUG_REQ_VEC_REG_OFFSET,
    0,
    0,
    1237,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    2,
    CNPL_DEBUG_REQ_VEC_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Register: CNPL_DEBUG_POL_UP_ST
 ******************************************************************************/
#if RU_INCLUDE_FIELD_DB
static const ru_field_rec *CNPL_DEBUG_POL_UP_ST_FIELDS[] =
{
    &CNPL_DEBUG_POL_UP_ST_ITR_NUM_FIELD,
    &CNPL_DEBUG_POL_UP_ST_POL_NUM_FIELD,
    &CNPL_DEBUG_POL_UP_ST_RESERVED0_FIELD,
};

#endif /* RU_INCLUDE_FIELD_DB */

const ru_reg_rec CNPL_DEBUG_POL_UP_ST_REG = 
{
    "DEBUG_POL_UP_ST",
#if RU_INCLUDE_DESC
    "POLICER_UPDATE_STATUS %i Register",
    "which counter is updated, and where are we in the period cycle",
#endif
    CNPL_DEBUG_POL_UP_ST_REG_OFFSET,
    CNPL_DEBUG_POL_UP_ST_REG_RAM_CNT,
    4,
    1238,
#if RU_INCLUDE_ACCESS
    ru_access_read,
#endif
#if RU_INCLUDE_FIELD_DB
    3,
    CNPL_DEBUG_POL_UP_ST_FIELDS
#endif /* RU_INCLUDE_FIELD_DB */
};

/******************************************************************************
 * Block: CNPL
 ******************************************************************************/
static const ru_reg_rec *CNPL_REGS[] =
{
    &CNPL_MEMORY_DATA_REG,
    &CNPL_COUNTERS_CONFIGURATIONS_CN_LOC_PROF_REG,
    &CNPL_POLICERS_CONFIGURATIONS_PL_LOC_PROF0_REG,
    &CNPL_POLICERS_CONFIGURATIONS_PL_LOC_PROF1_REG,
    &CNPL_POLICERS_CONFIGURATIONS_PL_CALC_TYPE_REG,
    &CNPL_POLICERS_CONFIGURATIONS_PER_UP_REG,
    &CNPL_POLICERS_CONFIGURATIONS_PL_SIZE_PROF_REG,
    &CNPL_BUF_MNG_COUNTERS_CFG_STAT_ORDR_REG,
    &CNPL_BUF_MNG_COUNTERS_CFG_STAT_RSRV_THR_REG,
    &CNPL_BUF_MNG_COUNTERS_CFG_STAT_HIPRI_THR_REG,
    &CNPL_BUF_MNG_COUNTERS_CFG_STAT_MAX_THR_REG,
    &CNPL_BUF_MNG_COUNTERS_CFG_STAT_HI_WMRK_CFG_REG,
    &CNPL_BUF_MNG_COUNTERS_CFG_STAT_HI_WMRK_VAL_REG,
    &CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNTR_INIT_REG,
    &CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNTR_NEG_ST_REG,
    &CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNTR_NEG_ST_CLR_REG,
    &CNPL_BUF_MNG_COUNTERS_CFG_STAT_CAPT_CFG_REG,
    &CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNT_NEG_CAP_CNT_REG,
    &CNPL_BUF_MNG_COUNTERS_CFG_STAT_CNT_NEG_CAP_CMD_REG,
    &CNPL_BUF_MNG_COUNTERS_CFG_STAT_CTRS_VAL_REG,
    &CNPL_SW_IF_SW_CMD_REG,
    &CNPL_SW_IF_SW_STAT_REG,
    &CNPL_SW_IF_SW_PL_RSLT_REG,
    &CNPL_SW_IF_SW_PL_RD_REG,
    &CNPL_SW_IF_SW_CNT_RD_REG,
    &CNPL_MISC_ARB_PRM_REG,
    &CNPL_MISC_COL_AWR_EN_REG,
    &CNPL_PM_COUNTERS_ENG_CMDS_REG,
    &CNPL_PM_COUNTERS_CMD_WAIT_REG,
    &CNPL_PM_COUNTERS_TOT_CYC_REG,
    &CNPL_PM_COUNTERS_GNT_CYC_REG,
    &CNPL_PM_COUNTERS_ARB_CYC_REG,
    &CNPL_PM_COUNTERS_PL_UP_ERR_REG,
    &CNPL_PM_COUNTERS_GEN_CFG_REG,
    &CNPL_DEBUG_DBGSEL_REG,
    &CNPL_DEBUG_DBGBUS_REG,
    &CNPL_DEBUG_REQ_VEC_REG,
    &CNPL_DEBUG_POL_UP_ST_REG,
};

unsigned long CNPL_ADDRS[] =
{
    0x82948000,
};

const ru_block_rec CNPL_BLOCK = 
{
    "CNPL",
    CNPL_ADDRS,
    1,
    38,
    CNPL_REGS
};

/* End of file XRDP_CNPL.c */
