/*
 * <:copyright-BRCM:2019:DUAL/GPL:standard
 * 
 *    Copyright (c) 2019 Broadcom 
 *    All Rights Reserved
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License, version 2, as published by
 * the Free Software Foundation (the "GPL").
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * 
 * A copy of the GPL is available at http://www.broadcom.com/licenses/GPLv2.php, or by
 * writing to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 * 
 * :>
 */


/*******************************************************************
 * bdmf_trace.c
 *
 * Data path builder - built-in trace
 *
 * This file is Copyright (c) 2011, Broadlight Communications.
 * This file is licensed under GNU Public License, except that if
 * you have entered in to a signed, written license agreement with
 * Broadlight covering this file, that agreement applies to this
 * file instead of the GNU Public License.
 *
 * This file is free software: you can redistribute and/or modify it
 * under the terms of the GNU Public License, Version 2, as published
 * by the Free Software Foundation, unless a different license
 * applies as provided above.
 *
 * This program is distributed in the hope that it will be useful,
 * but AS-IS and WITHOUT ANY WARRANTY; without even the implied
 * warranties of MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
 * TITLE or NONINFRINGEMENT. Redistribution, except as permitted by
 * the GNU Public License or another license agreement between you
 * and Broadlight, is prohibited.
 *
 * You should have received a copy of the GNU Public License,
 * Version 2 along with this file; if not, see
 * <http://www.gnu.org/licenses>.
 *
 * Author: Igor Ternovsky
 *******************************************************************/

#include <bdmf_dev.h>

/** Global trace level (\ref bdmf_trace_level_t) */
int bdmf_global_trace_level = bdmf_trace_level_error;

/** Initialise tracer.
 * \return
 *     0    - OK\n
 */
int bdmf_trace_init(void)
{
    bdmf_global_trace_level = bdmf_trace_level_error;
    return 0;
}

/* Get the current trace level
 * \param[in]   drv     Object type or NULL for global level.
 * \return:\n
 *  >=0     - trace level\n
 *  <0      - error code
 */
bdmf_trace_level_t bdmf_trace_level(bdmf_type_handle drv)
{
    if (!drv)
        return bdmf_global_trace_level;
    return drv->trace_level;
}


/* Set trace level
 * \param[in]   drv         Object type handle or NULL for global level.
 *                          Global level is applied as a default to all existing and future
 *                          object types.
 * \param[in]   level       New trace level
 * \return: old trace level
 */
bdmf_trace_level_t bdmf_trace_level_set(bdmf_type_handle drv, bdmf_trace_level_t level)
{
    bdmf_trace_level_t old_level;
    if (!drv)
    {
        struct bdmf_type *drv_next=NULL;
        while((drv_next = bdmf_type_get_next(drv_next)))
            drv_next->trace_level = level;
        old_level = bdmf_global_trace_level;
        bdmf_global_trace_level = level;
        /* replace for all objects */
    }
    else
    {
        old_level = drv->trace_level;
        drv->trace_level = level;
    }
    return old_level;
}


/* Print trace
 * \param[in]   fmt         printf-like format
 */
void bdmf_trace(const char *fmt, ...)
{
    va_list ap;
    va_start(ap, fmt);
    bdmf_vprint(fmt, ap);
    va_end(ap);
}

/*
 * Exports
 */
EXPORT_SYMBOL(bdmf_trace_level);
EXPORT_SYMBOL(bdmf_trace_level_set);
EXPORT_SYMBOL(bdmf_trace);
EXPORT_SYMBOL(bdmf_global_trace_level);
