/*
   Copyright (c) 2015 Broadcom
   All Rights Reserved

    <:label-BRCM:2015:DUAL/GPL:standard
    
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License, version 2, as published by
    the Free Software Foundation (the "GPL").
    
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
    
    
    A copy of the GPL is available at http://www.broadcom.com/licenses/GPLv2.php, or by
    writing to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
    
:>
*/



/* This is an automated file. Do not edit its contents. */


#ifndef _RDD_DATA_STRUCTURES_AUTO_H_
#define _RDD_DATA_STRUCTURES_AUTO_H_

#define NUM_OF_RUNNER_CORES       7
#define INVALID_TABLE_ADDRESS         0xFFFFFF

#ifdef __clang__
    #define ALIGNMENT(x) __attribute__((align_value((x))))
    #else
    #define ALIGNMENT(x)
    #endif
    


/* >>>MCAST_RESOLUTION_STRUCT */
typedef union
    {
    uint8_t word_8[8];
    uint16_t word_16[4];
    uint32_t word_32[2];
    uint64_t dword_64[1];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	egress_ports_vector	;
        uint8_t	iptv_repl_0_sop    	;
        uint32_t	pool_num           	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	replications       	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	ingress_vport      	;
        uint32_t	reserved1          	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	tc                 	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#else
        uint32_t	egress_ports_vector	;
        uint32_t	tc                 	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved1          	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	ingress_vport      	;
        uint32_t	replications       	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	pool_num           	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	iptv_repl_0_sop    	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) MCAST_RESOLUTION_STRUCT;

#define RDD_MCAST_RESOLUTION_EGRESS_PORTS_VECTOR_READ_G(r, g, idx)                                GROUP_MREAD_32((g), (idx)*sizeof(MCAST_RESOLUTION_STRUCT), (r))
#define RDD_MCAST_RESOLUTION_EGRESS_PORTS_VECTOR_WRITE_G(v, g, idx)                               GROUP_MWRITE_32((g), (idx)*sizeof(MCAST_RESOLUTION_STRUCT), (v))
#define RDD_MCAST_RESOLUTION_EGRESS_PORTS_VECTOR_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_32((g), (idx)*sizeof(MCAST_RESOLUTION_STRUCT), (r), core_id)
#define RDD_MCAST_RESOLUTION_EGRESS_PORTS_VECTOR_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_32((g), (idx)*sizeof(MCAST_RESOLUTION_STRUCT), (v), core_id)
#define RDD_MCAST_RESOLUTION_EGRESS_PORTS_VECTOR_READ(r, p)                                       MREAD_32((uint8_t *)(p), (r))
#define RDD_MCAST_RESOLUTION_EGRESS_PORTS_VECTOR_WRITE(v, p)                                      MWRITE_32((uint8_t *)(p), (v))
#define RDD_MCAST_RESOLUTION_IPTV_REPL_0_SOP_READ_G(r, g, idx)                                    GROUP_MREAD_8((g), (idx)*sizeof(MCAST_RESOLUTION_STRUCT) + 4, (r))
#define RDD_MCAST_RESOLUTION_IPTV_REPL_0_SOP_WRITE_G(v, g, idx)                                   GROUP_MWRITE_8((g), (idx)*sizeof(MCAST_RESOLUTION_STRUCT) + 4, (v))
#define RDD_MCAST_RESOLUTION_IPTV_REPL_0_SOP_READ_CORE(r, g, idx, core_id)                        CORE_MREAD_8((g), (idx)*sizeof(MCAST_RESOLUTION_STRUCT) + 4, (r), core_id)
#define RDD_MCAST_RESOLUTION_IPTV_REPL_0_SOP_WRITE_CORE(v, g, idx, core_id)                       CORE_MWRITE_8((g), (idx)*sizeof(MCAST_RESOLUTION_STRUCT) + 4, (v), core_id)
#define RDD_MCAST_RESOLUTION_IPTV_REPL_0_SOP_READ(r, p)                                           MREAD_8((uint8_t *)(p) + 4, (r))
#define RDD_MCAST_RESOLUTION_IPTV_REPL_0_SOP_WRITE(v, p)                                          MWRITE_8((uint8_t *)(p) + 4, (v))
#define RDD_MCAST_RESOLUTION_POOL_NUM_READ_G(r, g, idx)                                           GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(MCAST_RESOLUTION_STRUCT) + 5, 6, 2, (r))
#define RDD_MCAST_RESOLUTION_POOL_NUM_WRITE_G(v, g, idx)                                          GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(MCAST_RESOLUTION_STRUCT) + 5, 6, 2, (v))
#define RDD_MCAST_RESOLUTION_POOL_NUM_READ_CORE(r, g, idx, core_id)                               CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(MCAST_RESOLUTION_STRUCT) + 5, 6, 2, (r), core_id)
#define RDD_MCAST_RESOLUTION_POOL_NUM_WRITE_CORE(v, g, idx, core_id)                              CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(MCAST_RESOLUTION_STRUCT) + 5, 6, 2, (v), core_id)
#define RDD_MCAST_RESOLUTION_POOL_NUM_READ(r, p)                                                  RDP_FIELD_MREAD_8((uint8_t *)(p) + 5, 6, 2, (r))
#define RDD_MCAST_RESOLUTION_POOL_NUM_WRITE(v, p)                                                 RDP_FIELD_MWRITE_8((uint8_t *)(p) + 5, 6, 2, (v))
#define RDD_MCAST_RESOLUTION_REPLICATIONS_READ_G(r, g, idx)                                       GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(MCAST_RESOLUTION_STRUCT) + 5, 0, 6, (r))
#define RDD_MCAST_RESOLUTION_REPLICATIONS_WRITE_G(v, g, idx)                                      GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(MCAST_RESOLUTION_STRUCT) + 5, 0, 6, (v))
#define RDD_MCAST_RESOLUTION_REPLICATIONS_READ_CORE(r, g, idx, core_id)                           CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(MCAST_RESOLUTION_STRUCT) + 5, 0, 6, (r), core_id)
#define RDD_MCAST_RESOLUTION_REPLICATIONS_WRITE_CORE(v, g, idx, core_id)                          CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(MCAST_RESOLUTION_STRUCT) + 5, 0, 6, (v), core_id)
#define RDD_MCAST_RESOLUTION_REPLICATIONS_READ(r, p)                                              RDP_FIELD_MREAD_8((uint8_t *)(p) + 5, 0, 6, (r))
#define RDD_MCAST_RESOLUTION_REPLICATIONS_WRITE(v, p)                                             RDP_FIELD_MWRITE_8((uint8_t *)(p) + 5, 0, 6, (v))
#define RDD_MCAST_RESOLUTION_INGRESS_VPORT_READ_G(r, g, idx)                                      GROUP_MREAD_8((g), (idx)*sizeof(MCAST_RESOLUTION_STRUCT) + 6, (r))
#define RDD_MCAST_RESOLUTION_INGRESS_VPORT_WRITE_G(v, g, idx)                                     GROUP_MWRITE_8((g), (idx)*sizeof(MCAST_RESOLUTION_STRUCT) + 6, (v))
#define RDD_MCAST_RESOLUTION_INGRESS_VPORT_READ_CORE(r, g, idx, core_id)                          CORE_MREAD_8((g), (idx)*sizeof(MCAST_RESOLUTION_STRUCT) + 6, (r), core_id)
#define RDD_MCAST_RESOLUTION_INGRESS_VPORT_WRITE_CORE(v, g, idx, core_id)                         CORE_MWRITE_8((g), (idx)*sizeof(MCAST_RESOLUTION_STRUCT) + 6, (v), core_id)
#define RDD_MCAST_RESOLUTION_INGRESS_VPORT_READ(r, p)                                             MREAD_8((uint8_t *)(p) + 6, (r))
#define RDD_MCAST_RESOLUTION_INGRESS_VPORT_WRITE(v, p)                                            MWRITE_8((uint8_t *)(p) + 6, (v))
#define RDD_MCAST_RESOLUTION_TC_READ_G(r, g, idx)                                                 GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(MCAST_RESOLUTION_STRUCT) + 7, 0, 3, (r))
#define RDD_MCAST_RESOLUTION_TC_WRITE_G(v, g, idx)                                                GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(MCAST_RESOLUTION_STRUCT) + 7, 0, 3, (v))
#define RDD_MCAST_RESOLUTION_TC_READ_CORE(r, g, idx, core_id)                                     CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(MCAST_RESOLUTION_STRUCT) + 7, 0, 3, (r), core_id)
#define RDD_MCAST_RESOLUTION_TC_WRITE_CORE(v, g, idx, core_id)                                    CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(MCAST_RESOLUTION_STRUCT) + 7, 0, 3, (v), core_id)
#define RDD_MCAST_RESOLUTION_TC_READ(r, p)                                                        RDP_FIELD_MREAD_8((uint8_t *)(p) + 7, 0, 3, (r))
#define RDD_MCAST_RESOLUTION_TC_WRITE(v, p)                                                       RDP_FIELD_MWRITE_8((uint8_t *)(p) + 7, 0, 3, (v))
/* <<<MCAST_RESOLUTION_STRUCT */


/* >>>ACTION_STRUCT */
typedef union
    {
    uint8_t word_8[2];
    uint16_t word_16[1];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
	/* Union WORD 0 */
	union{
		/* Sub Union 0 */
		struct{
        uint16_t	type             	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	natc_rollback    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	priority         	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint8_t	reason_or_counter	; /* This is a field union */
		};
		/* Sub Union 1 */
		struct{
        uint16_t	reservedSU1_type           	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	reservedSU1_natc_rollback  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	needed_priority            	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of priority union */
        uint16_t	reserved_priority          	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of priority union */
        uint8_t	trap_reason                	; /* Member of reason_or_counter union */
		};
		/* Sub Union 2 */
		struct{
        uint16_t	reservedSU2_type           	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	reservedSU2_natc_rollback  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	reservedSU2_priority       	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	drop_counter               	; /* Member of reason_or_counter union */
		};
	};
#else
	/* Union WORD 0 */
	union{
		/* Sub Union 0 */
		struct{
        uint8_t	reason_or_counter	; /* This is a field union */
        uint16_t	priority         	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint16_t	natc_rollback    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	type             	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 1 */
		struct{
        uint8_t	trap_reason                	; /* Member of reason_or_counter union */
        uint16_t	reserved_priority          	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of priority union */
        uint16_t	needed_priority            	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of priority union */
        uint16_t	reservedSU1_natc_rollback  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	reservedSU1_type           	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 2 */
		struct{
        uint8_t	drop_counter               	; /* Member of reason_or_counter union */
        uint16_t	reservedSU2_priority       	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	reservedSU2_natc_rollback  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	reservedSU2_type           	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(2))) ACTION_STRUCT;

#define RDD_ACTION_TYPE_READ_G(r, g, idx)                                             GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(ACTION_STRUCT), 6, 2, (r))
#define RDD_ACTION_TYPE_WRITE_G(v, g, idx)                                            GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(ACTION_STRUCT), 6, 2, (v))
#define RDD_ACTION_TYPE_READ_CORE(r, g, idx, core_id)                                 CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(ACTION_STRUCT), 6, 2, (r), core_id)
#define RDD_ACTION_TYPE_WRITE_CORE(v, g, idx, core_id)                                CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(ACTION_STRUCT), 6, 2, (v), core_id)
#define RDD_ACTION_TYPE_READ(r, p)                                                    RDP_FIELD_MREAD_8((uint8_t *)(p), 6, 2, (r))
#define RDD_ACTION_TYPE_WRITE(v, p)                                                   RDP_FIELD_MWRITE_8((uint8_t *)(p), 6, 2, (v))
#define RDD_ACTION_NATC_ROLLBACK_READ_G(r, g, idx)                                    GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(ACTION_STRUCT), 5, 1, (r))
#define RDD_ACTION_NATC_ROLLBACK_WRITE_G(v, g, idx)                                   GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(ACTION_STRUCT), 5, 1, (v))
#define RDD_ACTION_NATC_ROLLBACK_READ_CORE(r, g, idx, core_id)                        CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(ACTION_STRUCT), 5, 1, (r), core_id)
#define RDD_ACTION_NATC_ROLLBACK_WRITE_CORE(v, g, idx, core_id)                       CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(ACTION_STRUCT), 5, 1, (v), core_id)
#define RDD_ACTION_NATC_ROLLBACK_READ(r, p)                                           RDP_FIELD_MREAD_8((uint8_t *)(p), 5, 1, (r))
#define RDD_ACTION_NATC_ROLLBACK_WRITE(v, p)                                          RDP_FIELD_MWRITE_8((uint8_t *)(p), 5, 1, (v))
#define RDD_ACTION_PRIORITY_READ_G(r, g, idx)                                         GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(ACTION_STRUCT), 0, 5, (r))
#define RDD_ACTION_PRIORITY_WRITE_G(v, g, idx)                                        GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(ACTION_STRUCT), 0, 5, (v))
#define RDD_ACTION_PRIORITY_READ_CORE(r, g, idx, core_id)                             CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(ACTION_STRUCT), 0, 5, (r), core_id)
#define RDD_ACTION_PRIORITY_WRITE_CORE(v, g, idx, core_id)                            CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(ACTION_STRUCT), 0, 5, (v), core_id)
#define RDD_ACTION_PRIORITY_READ(r, p)                                                RDP_FIELD_MREAD_8((uint8_t *)(p), 0, 5, (r))
#define RDD_ACTION_PRIORITY_WRITE(v, p)                                               RDP_FIELD_MWRITE_8((uint8_t *)(p), 0, 5, (v))
#define RDD_ACTION_NEEDED_PRIORITY_READ_G(r, g, idx)                                  GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(ACTION_STRUCT), 2, 3, (r))
#define RDD_ACTION_NEEDED_PRIORITY_WRITE_G(v, g, idx)                                 GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(ACTION_STRUCT), 2, 3, (v))
#define RDD_ACTION_NEEDED_PRIORITY_READ_CORE(r, g, idx, core_id)                      CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(ACTION_STRUCT), 2, 3, (r), core_id)
#define RDD_ACTION_NEEDED_PRIORITY_WRITE_CORE(v, g, idx, core_id)                     CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(ACTION_STRUCT), 2, 3, (v), core_id)
#define RDD_ACTION_NEEDED_PRIORITY_READ(r, p)                                         RDP_FIELD_MREAD_8((uint8_t *)(p), 2, 3, (r))
#define RDD_ACTION_NEEDED_PRIORITY_WRITE(v, p)                                        RDP_FIELD_MWRITE_8((uint8_t *)(p), 2, 3, (v))
#define RDD_ACTION_REASON_OR_COUNTER_READ_G(r, g, idx)                                GROUP_MREAD_8((g), (idx)*sizeof(ACTION_STRUCT) + 1, (r))
#define RDD_ACTION_REASON_OR_COUNTER_WRITE_G(v, g, idx)                               GROUP_MWRITE_8((g), (idx)*sizeof(ACTION_STRUCT) + 1, (v))
#define RDD_ACTION_REASON_OR_COUNTER_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_8((g), (idx)*sizeof(ACTION_STRUCT) + 1, (r), core_id)
#define RDD_ACTION_REASON_OR_COUNTER_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_8((g), (idx)*sizeof(ACTION_STRUCT) + 1, (v), core_id)
#define RDD_ACTION_REASON_OR_COUNTER_READ(r, p)                                       MREAD_8((uint8_t *)(p) + 1, (r))
#define RDD_ACTION_REASON_OR_COUNTER_WRITE(v, p)                                      MWRITE_8((uint8_t *)(p) + 1, (v))
#define RDD_ACTION_TRAP_REASON_READ_G(r, g, idx)                                      GROUP_MREAD_8((g), (idx)*sizeof(ACTION_STRUCT) + 1, (r))
#define RDD_ACTION_TRAP_REASON_WRITE_G(v, g, idx)                                     GROUP_MWRITE_8((g), (idx)*sizeof(ACTION_STRUCT) + 1, (v))
#define RDD_ACTION_TRAP_REASON_READ_CORE(r, g, idx, core_id)                          CORE_MREAD_8((g), (idx)*sizeof(ACTION_STRUCT) + 1, (r), core_id)
#define RDD_ACTION_TRAP_REASON_WRITE_CORE(v, g, idx, core_id)                         CORE_MWRITE_8((g), (idx)*sizeof(ACTION_STRUCT) + 1, (v), core_id)
#define RDD_ACTION_TRAP_REASON_READ(r, p)                                             MREAD_8((uint8_t *)(p) + 1, (r))
#define RDD_ACTION_TRAP_REASON_WRITE(v, p)                                            MWRITE_8((uint8_t *)(p) + 1, (v))
#define RDD_ACTION_DROP_COUNTER_READ_G(r, g, idx)                                     GROUP_MREAD_8((g), (idx)*sizeof(ACTION_STRUCT) + 1, (r))
#define RDD_ACTION_DROP_COUNTER_WRITE_G(v, g, idx)                                    GROUP_MWRITE_8((g), (idx)*sizeof(ACTION_STRUCT) + 1, (v))
#define RDD_ACTION_DROP_COUNTER_READ_CORE(r, g, idx, core_id)                         CORE_MREAD_8((g), (idx)*sizeof(ACTION_STRUCT) + 1, (r), core_id)
#define RDD_ACTION_DROP_COUNTER_WRITE_CORE(v, g, idx, core_id)                        CORE_MWRITE_8((g), (idx)*sizeof(ACTION_STRUCT) + 1, (v), core_id)
#define RDD_ACTION_DROP_COUNTER_READ(r, p)                                            MREAD_8((uint8_t *)(p) + 1, (r))
#define RDD_ACTION_DROP_COUNTER_WRITE(v, p)                                           MWRITE_8((uint8_t *)(p) + 1, (v))
/* <<<ACTION_STRUCT */


/* >>>VLAN_TAG_STRUCT */
typedef union
    {
    uint8_t word_8[2];
    uint16_t word_16[1];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint16_t	pbits     	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	cfi       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	vid       	:12	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#else
        uint16_t	vid       	:12	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	cfi       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	pbits     	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(2))) VLAN_TAG_STRUCT;

#define RDD_VLAN_TAG_PBITS_READ_G(r, g, idx)                                GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(VLAN_TAG_STRUCT), 5, 3, (r))
#define RDD_VLAN_TAG_PBITS_WRITE_G(v, g, idx)                               GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(VLAN_TAG_STRUCT), 5, 3, (v))
#define RDD_VLAN_TAG_PBITS_READ_CORE(r, g, idx, core_id)                    CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(VLAN_TAG_STRUCT), 5, 3, (r), core_id)
#define RDD_VLAN_TAG_PBITS_WRITE_CORE(v, g, idx, core_id)                   CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(VLAN_TAG_STRUCT), 5, 3, (v), core_id)
#define RDD_VLAN_TAG_PBITS_READ(r, p)                                       RDP_FIELD_MREAD_8((uint8_t *)(p), 5, 3, (r))
#define RDD_VLAN_TAG_PBITS_WRITE(v, p)                                      RDP_FIELD_MWRITE_8((uint8_t *)(p), 5, 3, (v))
#define RDD_VLAN_TAG_CFI_READ_G(r, g, idx)                                  GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(VLAN_TAG_STRUCT), 4, 1, (r))
#define RDD_VLAN_TAG_CFI_WRITE_G(v, g, idx)                                 GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(VLAN_TAG_STRUCT), 4, 1, (v))
#define RDD_VLAN_TAG_CFI_READ_CORE(r, g, idx, core_id)                      CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(VLAN_TAG_STRUCT), 4, 1, (r), core_id)
#define RDD_VLAN_TAG_CFI_WRITE_CORE(v, g, idx, core_id)                     CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(VLAN_TAG_STRUCT), 4, 1, (v), core_id)
#define RDD_VLAN_TAG_CFI_READ(r, p)                                         RDP_FIELD_MREAD_8((uint8_t *)(p), 4, 1, (r))
#define RDD_VLAN_TAG_CFI_WRITE(v, p)                                        RDP_FIELD_MWRITE_8((uint8_t *)(p), 4, 1, (v))
#define RDD_VLAN_TAG_VID_READ_G(r, g, idx)                                  GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(VLAN_TAG_STRUCT), 0, 12, (r))
#define RDD_VLAN_TAG_VID_WRITE_G(v, g, idx)                                 GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(VLAN_TAG_STRUCT), 0, 12, (v))
#define RDD_VLAN_TAG_VID_READ_CORE(r, g, idx, core_id)                      CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(VLAN_TAG_STRUCT), 0, 12, (r), core_id)
#define RDD_VLAN_TAG_VID_WRITE_CORE(v, g, idx, core_id)                     CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(VLAN_TAG_STRUCT), 0, 12, (v), core_id)
#define RDD_VLAN_TAG_VID_READ(r, p)                                         RDP_FIELD_MREAD_16((uint8_t *)(p), 0, 12, (r))
#define RDD_VLAN_TAG_VID_WRITE(v, p)                                        RDP_FIELD_MWRITE_16((uint8_t *)(p), 0, 12, (v))
/* <<<VLAN_TAG_STRUCT */


/* >>>CPU_RECYCLE_DESCRIPTOR_STRUCT */
typedef union
    {
    uint8_t word_8[8];
    uint16_t word_16[4];
    uint32_t word_32[2];
    uint64_t dword_64[1];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	skb_ptr_low   	;
        uint32_t	reserved0     	:22	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	from_feed_ring	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	abs           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	skb_ptr_hi    	;
#else
        uint32_t	skb_ptr_low   	;
        uint8_t	skb_ptr_hi    	;
        uint32_t	abs           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	from_feed_ring	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved0     	:22	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) CPU_RECYCLE_DESCRIPTOR_STRUCT;

#define RDD_CPU_RECYCLE_DESCRIPTOR_SKB_PTR_LOW_READ_G(r, g, idx)                                   GROUP_MREAD_32((g), (idx)*sizeof(CPU_RECYCLE_DESCRIPTOR_STRUCT), (r))
#define RDD_CPU_RECYCLE_DESCRIPTOR_SKB_PTR_LOW_WRITE_G(v, g, idx)                                  GROUP_MWRITE_32((g), (idx)*sizeof(CPU_RECYCLE_DESCRIPTOR_STRUCT), (v))
#define RDD_CPU_RECYCLE_DESCRIPTOR_SKB_PTR_LOW_READ_CORE(r, g, idx, core_id)                       CORE_MREAD_32((g), (idx)*sizeof(CPU_RECYCLE_DESCRIPTOR_STRUCT), (r), core_id)
#define RDD_CPU_RECYCLE_DESCRIPTOR_SKB_PTR_LOW_WRITE_CORE(v, g, idx, core_id)                      CORE_MWRITE_32((g), (idx)*sizeof(CPU_RECYCLE_DESCRIPTOR_STRUCT), (v), core_id)
#define RDD_CPU_RECYCLE_DESCRIPTOR_SKB_PTR_LOW_READ(r, p)                                          MREAD_32((uint8_t *)(p), (r))
#define RDD_CPU_RECYCLE_DESCRIPTOR_SKB_PTR_LOW_WRITE(v, p)                                         MWRITE_32((uint8_t *)(p), (v))
#define RDD_CPU_RECYCLE_DESCRIPTOR_FROM_FEED_RING_READ_G(r, g, idx)                                GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(CPU_RECYCLE_DESCRIPTOR_STRUCT) + 6, 1, 1, (r))
#define RDD_CPU_RECYCLE_DESCRIPTOR_FROM_FEED_RING_WRITE_G(v, g, idx)                               GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(CPU_RECYCLE_DESCRIPTOR_STRUCT) + 6, 1, 1, (v))
#define RDD_CPU_RECYCLE_DESCRIPTOR_FROM_FEED_RING_READ_CORE(r, g, idx, core_id)                    CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(CPU_RECYCLE_DESCRIPTOR_STRUCT) + 6, 1, 1, (r), core_id)
#define RDD_CPU_RECYCLE_DESCRIPTOR_FROM_FEED_RING_WRITE_CORE(v, g, idx, core_id)                   CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(CPU_RECYCLE_DESCRIPTOR_STRUCT) + 6, 1, 1, (v), core_id)
#define RDD_CPU_RECYCLE_DESCRIPTOR_FROM_FEED_RING_READ(r, p)                                       RDP_FIELD_MREAD_8((uint8_t *)(p) + 6, 1, 1, (r))
#define RDD_CPU_RECYCLE_DESCRIPTOR_FROM_FEED_RING_WRITE(v, p)                                      RDP_FIELD_MWRITE_8((uint8_t *)(p) + 6, 1, 1, (v))
#define RDD_CPU_RECYCLE_DESCRIPTOR_ABS_READ_G(r, g, idx)                                           GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(CPU_RECYCLE_DESCRIPTOR_STRUCT) + 6, 0, 1, (r))
#define RDD_CPU_RECYCLE_DESCRIPTOR_ABS_WRITE_G(v, g, idx)                                          GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(CPU_RECYCLE_DESCRIPTOR_STRUCT) + 6, 0, 1, (v))
#define RDD_CPU_RECYCLE_DESCRIPTOR_ABS_READ_CORE(r, g, idx, core_id)                               CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(CPU_RECYCLE_DESCRIPTOR_STRUCT) + 6, 0, 1, (r), core_id)
#define RDD_CPU_RECYCLE_DESCRIPTOR_ABS_WRITE_CORE(v, g, idx, core_id)                              CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(CPU_RECYCLE_DESCRIPTOR_STRUCT) + 6, 0, 1, (v), core_id)
#define RDD_CPU_RECYCLE_DESCRIPTOR_ABS_READ(r, p)                                                  RDP_FIELD_MREAD_8((uint8_t *)(p) + 6, 0, 1, (r))
#define RDD_CPU_RECYCLE_DESCRIPTOR_ABS_WRITE(v, p)                                                 RDP_FIELD_MWRITE_8((uint8_t *)(p) + 6, 0, 1, (v))
#define RDD_CPU_RECYCLE_DESCRIPTOR_SKB_PTR_HI_READ_G(r, g, idx)                                    GROUP_MREAD_8((g), (idx)*sizeof(CPU_RECYCLE_DESCRIPTOR_STRUCT) + 7, (r))
#define RDD_CPU_RECYCLE_DESCRIPTOR_SKB_PTR_HI_WRITE_G(v, g, idx)                                   GROUP_MWRITE_8((g), (idx)*sizeof(CPU_RECYCLE_DESCRIPTOR_STRUCT) + 7, (v))
#define RDD_CPU_RECYCLE_DESCRIPTOR_SKB_PTR_HI_READ_CORE(r, g, idx, core_id)                        CORE_MREAD_8((g), (idx)*sizeof(CPU_RECYCLE_DESCRIPTOR_STRUCT) + 7, (r), core_id)
#define RDD_CPU_RECYCLE_DESCRIPTOR_SKB_PTR_HI_WRITE_CORE(v, g, idx, core_id)                       CORE_MWRITE_8((g), (idx)*sizeof(CPU_RECYCLE_DESCRIPTOR_STRUCT) + 7, (v), core_id)
#define RDD_CPU_RECYCLE_DESCRIPTOR_SKB_PTR_HI_READ(r, p)                                           MREAD_8((uint8_t *)(p) + 7, (r))
#define RDD_CPU_RECYCLE_DESCRIPTOR_SKB_PTR_HI_WRITE(v, p)                                          MWRITE_8((uint8_t *)(p) + 7, (v))
/* <<<CPU_RECYCLE_DESCRIPTOR_STRUCT */


/* >>>PROCESSING_CPU_RX_DESCRIPTOR_STRUCT */
typedef union
    {
    uint8_t word_8[16];
    uint16_t word_16[8];
    uint32_t word_32[4];
    uint64_t dword_64[2];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
	/* Union WORD 0 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	valid                      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	headroom                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	dont_agg_or_is_chksum_verified	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	mc_copy                    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reprocess                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	color                      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	force_copy                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	type_or_service_queue_wlan_frw_type	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	reason_or_forwarding       	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	first_level_q              	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	flag_1588_or_dsl_rx        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	coherent_or_forwarding     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	metadata_1_2_or_spdtest_stream_id_or_spu_session	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	reserved90                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 1 */
		struct{
        uint32_t	reservedSU1_valid                    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_headroom                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	dont_agg                             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of dont_agg_or_is_chksum_verified union */
        uint32_t	reservedSU1_mc_copy                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_reprocess                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_color                    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_force_copy               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	type                                 	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of type_or_service_queue_wlan_frw_type union */
        uint32_t	cpu_redirect_0                       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of reason_or_forwarding union */
        uint32_t	cpu_reason                           	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of reason_or_forwarding union */
        uint32_t	reservedSU1_first_level_q            	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	flag_1588                            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of flag_1588_or_dsl_rx union */
        uint32_t	coherent                             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of coherent_or_forwarding union */
        uint32_t	metadata_1_2                         	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of metadata_1_2_or_spdtest_stream_id_or_spu_session union */
        uint32_t	reservedSU1_reserved90               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 2 */
		struct{
        uint32_t	reservedSU2_valid                    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_headroom                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_chksum_verified                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of dont_agg_or_is_chksum_verified union */
        uint32_t	reservedSU2_mc_copy                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_reprocess                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_color                    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_force_copy               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_type_or_service_queue_wlan_frw_type	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	tc                                   	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of reason_or_forwarding union */
        uint32_t	metadata_0_0                         	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of reason_or_forwarding union */
        uint32_t	reservedSU2_first_level_q            	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	dsl_rx                               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of flag_1588_or_dsl_rx union */
        uint32_t	ucast                                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of coherent_or_forwarding union */
        uint32_t	spdtest_stream_id                    	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of metadata_1_2_or_spdtest_stream_id_or_spu_session union */
        uint32_t	tcpspdtest_is_upload                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of metadata_1_2_or_spdtest_stream_id_or_spu_session union */
        uint32_t	reservedSU2_reserved90               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 3 */
		struct{
        uint32_t	reservedSU3_valid                    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_headroom                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_dont_agg_or_is_chksum_verified	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_mc_copy                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_reprocess                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_color                    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_force_copy               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	service_queue_is_wlan                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of type_or_service_queue_wlan_frw_type union */
        uint32_t	service_queue_wlan_frw_type          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of type_or_service_queue_wlan_frw_type union */
        uint32_t	cpu_redirect_1                       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of reason_or_forwarding union */
        uint32_t	wan_flow_1                           	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of reason_or_forwarding union */
        uint32_t	reservedSU3_first_level_q            	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_flag_1588_or_dsl_rx      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_coherent_or_forwarding   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	crypto_session_id_lo                 	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of metadata_1_2_or_spdtest_stream_id_or_spu_session union */
        uint32_t	reservedSU3_reserved90               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 4 */
		struct{
        uint32_t	reservedSU4_valid                    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_headroom                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_dont_agg_or_is_chksum_verified	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_mc_copy                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_reprocess                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_color                    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_force_copy               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_type_or_service_queue_wlan_frw_type	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	dhd_flow_priority                    	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of reason_or_forwarding union */
        uint32_t	reserved0                            	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of reason_or_forwarding union */
        uint32_t	reservedSU4_first_level_q            	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_flag_1588_or_dsl_rx      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_coherent_or_forwarding   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	gdx_pd_data_3_0                      	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of metadata_1_2_or_spdtest_stream_id_or_spu_session union */
        uint32_t	reservedSU4_reserved90               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
	/* Union WORD 1 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	num_of_avail_dhd_repl_or_metadata_1_or_cpu_redirect	:10	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	priority                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ingress_cong_or_service_queue_wlan	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	abs                        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_spu_resp                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_hw_cso                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	wlan_tid                   	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	packet_length              	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 1 */
		struct{
        uint32_t	metadata_1_0                         	:10	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of num_of_avail_dhd_repl_or_metadata_1_or_cpu_redirect union */
        uint32_t	reservedSU1_priority                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ingress_cong                         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ingress_cong_or_service_queue_wlan union */
        uint32_t	reservedSU1_abs                      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_is_spu_resp              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_is_hw_cso                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_wlan_tid                 	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_packet_length            	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 2 */
		struct{
        uint32_t	spdtest_l3_l4_hdr_len                	:10	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of num_of_avail_dhd_repl_or_metadata_1_or_cpu_redirect union */
        uint32_t	reservedSU2_priority                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_ingress_cong_or_service_queue_wlan	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_abs                      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_is_spu_resp              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_is_hw_cso                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_wlan_tid                 	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_packet_length            	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 3 */
		struct{
        uint8_t	egress_queue                         	; /* Member of num_of_avail_dhd_repl_or_metadata_1_or_cpu_redirect union */
        uint32_t	wan_flow_0                           	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of num_of_avail_dhd_repl_or_metadata_1_or_cpu_redirect union */
        uint32_t	reservedSU3_priority                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_ingress_cong_or_service_queue_wlan	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_abs                      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_is_spu_resp              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_is_hw_cso                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_wlan_tid                 	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_packet_length            	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 4 */
		struct{
        uint32_t	gdx_pd_data_13_4                     	:10	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of num_of_avail_dhd_repl_or_metadata_1_or_cpu_redirect union */
        uint32_t	reservedSU4_priority                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_ingress_cong_or_service_queue_wlan	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_abs                      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_is_spu_resp              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_is_hw_cso                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_wlan_tid                 	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_packet_length            	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
	/* Union WORD 2 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	drop                       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	target_mem_1               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	metadata_1_1               	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_emac                    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	vport_or_flow              	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	metadata_0_1               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ssid_or_metadata_2_or_cpu_redirect_or_spu_session	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	bn1_or_abs3                	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
		};
		/* Sub Union 1 */
		struct{
        uint32_t	reservedSU1_drop                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_target_mem_1             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_metadata_1_1             	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_is_emac                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	flow                                 	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of vport_or_flow union */
        uint32_t	reservedSU1_metadata_0_1             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ssid                                 	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ssid_or_metadata_2_or_cpu_redirect_or_spu_session union */
        uint32_t	bn1_first                            	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of bn1_or_abs3 union */
		};
		/* Sub Union 2 */
		struct{
        uint32_t	reservedSU2_drop                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_target_mem_1             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_metadata_1_1             	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_is_emac                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	source_port                          	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of vport_or_flow union */
        uint32_t	reservedSU2_metadata_0_1             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved2                            	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ssid_or_metadata_2_or_cpu_redirect_or_spu_session union */
        uint32_t	metadata_2                           	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ssid_or_metadata_2_or_cpu_redirect_or_spu_session union */
        uint32_t	reserved4                            	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of bn1_or_abs3 union */
        uint32_t	abs3                                 	:11	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of bn1_or_abs3 union */
		};
		/* Sub Union 3 */
		struct{
        uint32_t	reservedSU3_drop                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_target_mem_1             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_metadata_1_1             	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_is_emac                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	port_id                              	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of vport_or_flow union */
        uint32_t	reservedSU3_metadata_0_1             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	omci_enc_key_index                   	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ssid_or_metadata_2_or_cpu_redirect_or_spu_session union */
        uint32_t	reserved3                            	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ssid_or_metadata_2_or_cpu_redirect_or_spu_session union */
        uint32_t	reservedSU3_bn1_or_abs3              	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 4 */
		struct{
        uint32_t	reservedSU4_drop                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_target_mem_1             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_metadata_1_1             	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_is_emac                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_vport_or_flow            	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_metadata_0_1             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	crypto_session_id_hi                 	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ssid_or_metadata_2_or_cpu_redirect_or_spu_session union */
        uint32_t	reserved7                            	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ssid_or_metadata_2_or_cpu_redirect_or_spu_session union */
        uint32_t	reservedSU4_bn1_or_abs3              	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 5 */
		struct{
        uint32_t	reservedSU5_drop                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU5_target_mem_1             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU5_metadata_1_1             	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU5_is_emac                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU5_vport_or_flow            	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU5_metadata_0_1             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_gdx_tx                            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ssid_or_metadata_2_or_cpu_redirect_or_spu_session union */
        uint32_t	is_gdx_rx                            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ssid_or_metadata_2_or_cpu_redirect_or_spu_session union */
        uint32_t	gdx_pd_data_15_14                    	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ssid_or_metadata_2_or_cpu_redirect_or_spu_session union */
        uint32_t	reservedSU5_bn1_or_abs3              	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
	/* Union WORD 3 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	agg_pd                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	target_mem_0               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	payload_offset_sop         	:30	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
		};
		/* Sub Union 1 */
		struct{
        uint32_t	reservedSU1_agg_pd                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_target_mem_0             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	sop_fpm                              	:10	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of payload_offset_sop union */
        uint32_t	bn_fpm                               	:20	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of payload_offset_sop union */
		};
		/* Sub Union 2 */
		struct{
        uint32_t	reservedSU2_agg_pd                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_target_mem_0             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	bn_num                               	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of payload_offset_sop union */
        uint32_t	sop                                  	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of payload_offset_sop union */
        uint16_t	bn0_first                            	; /* Member of payload_offset_sop union */
		};
		/* Sub Union 3 */
		struct{
        uint32_t	reservedSU3_agg_pd                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_target_mem_0             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved5                            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of payload_offset_sop union */
        uint32_t	abs0                                 	:29	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of payload_offset_sop union */
		};
		/* Sub Union 4 */
		struct{
        uint32_t	reservedSU4_agg_pd                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_target_mem_0             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved6                            	:10	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of payload_offset_sop union */
        uint32_t	fpm_pool                             	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of payload_offset_sop union */
        uint32_t	fpm_num                              	:18	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of payload_offset_sop union */
		};
	};
#else
	/* Union WORD 0 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	reserved90                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	metadata_1_2_or_spdtest_stream_id_or_spu_session	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	coherent_or_forwarding     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	flag_1588_or_dsl_rx        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	first_level_q              	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reason_or_forwarding       	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	type_or_service_queue_wlan_frw_type	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	force_copy                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	color                      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reprocess                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	mc_copy                    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	dont_agg_or_is_chksum_verified	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	headroom                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	valid                      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 1 */
		struct{
        uint32_t	reservedSU1_reserved90               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	metadata_1_2                         	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of metadata_1_2_or_spdtest_stream_id_or_spu_session union */
        uint32_t	coherent                             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of coherent_or_forwarding union */
        uint32_t	flag_1588                            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of flag_1588_or_dsl_rx union */
        uint32_t	reservedSU1_first_level_q            	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	cpu_reason                           	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of reason_or_forwarding union */
        uint32_t	cpu_redirect_0                       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of reason_or_forwarding union */
        uint32_t	type                                 	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of type_or_service_queue_wlan_frw_type union */
        uint32_t	reservedSU1_force_copy               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_color                    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_reprocess                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_mc_copy                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	dont_agg                             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of dont_agg_or_is_chksum_verified union */
        uint32_t	reservedSU1_headroom                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_valid                    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 2 */
		struct{
        uint32_t	reservedSU2_reserved90               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	tcpspdtest_is_upload                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of metadata_1_2_or_spdtest_stream_id_or_spu_session union */
        uint32_t	spdtest_stream_id                    	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of metadata_1_2_or_spdtest_stream_id_or_spu_session union */
        uint32_t	ucast                                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of coherent_or_forwarding union */
        uint32_t	dsl_rx                               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of flag_1588_or_dsl_rx union */
        uint32_t	reservedSU2_first_level_q            	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	metadata_0_0                         	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of reason_or_forwarding union */
        uint32_t	tc                                   	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of reason_or_forwarding union */
        uint32_t	reservedSU2_type_or_service_queue_wlan_frw_type	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_force_copy               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_color                    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_reprocess                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_mc_copy                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_chksum_verified                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of dont_agg_or_is_chksum_verified union */
        uint32_t	reservedSU2_headroom                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_valid                    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 3 */
		struct{
        uint32_t	reservedSU3_reserved90               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	crypto_session_id_lo                 	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of metadata_1_2_or_spdtest_stream_id_or_spu_session union */
        uint32_t	reservedSU3_coherent_or_forwarding   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_flag_1588_or_dsl_rx      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_first_level_q            	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	wan_flow_1                           	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of reason_or_forwarding union */
        uint32_t	cpu_redirect_1                       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of reason_or_forwarding union */
        uint32_t	service_queue_wlan_frw_type          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of type_or_service_queue_wlan_frw_type union */
        uint32_t	service_queue_is_wlan                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of type_or_service_queue_wlan_frw_type union */
        uint32_t	reservedSU3_force_copy               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_color                    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_reprocess                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_mc_copy                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_dont_agg_or_is_chksum_verified	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_headroom                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_valid                    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 4 */
		struct{
        uint32_t	reservedSU4_reserved90               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	gdx_pd_data_3_0                      	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of metadata_1_2_or_spdtest_stream_id_or_spu_session union */
        uint32_t	reservedSU4_coherent_or_forwarding   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_flag_1588_or_dsl_rx      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_first_level_q            	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved0                            	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of reason_or_forwarding union */
        uint32_t	dhd_flow_priority                    	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of reason_or_forwarding union */
        uint32_t	reservedSU4_type_or_service_queue_wlan_frw_type	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_force_copy               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_color                    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_reprocess                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_mc_copy                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_dont_agg_or_is_chksum_verified	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_headroom                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_valid                    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
	/* Union WORD 1 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	packet_length              	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	wlan_tid                   	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_hw_cso                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_spu_resp                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	abs                        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ingress_cong_or_service_queue_wlan	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	priority                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	num_of_avail_dhd_repl_or_metadata_1_or_cpu_redirect	:10	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
		};
		/* Sub Union 1 */
		struct{
        uint32_t	reservedSU1_packet_length            	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_wlan_tid                 	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_is_hw_cso                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_is_spu_resp              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_abs                      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ingress_cong                         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ingress_cong_or_service_queue_wlan union */
        uint32_t	reservedSU1_priority                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	metadata_1_0                         	:10	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of num_of_avail_dhd_repl_or_metadata_1_or_cpu_redirect union */
		};
		/* Sub Union 2 */
		struct{
        uint32_t	reservedSU2_packet_length            	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_wlan_tid                 	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_is_hw_cso                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_is_spu_resp              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_abs                      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_ingress_cong_or_service_queue_wlan	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_priority                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	spdtest_l3_l4_hdr_len                	:10	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of num_of_avail_dhd_repl_or_metadata_1_or_cpu_redirect union */
		};
		/* Sub Union 3 */
		struct{
        uint32_t	reservedSU3_packet_length            	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_wlan_tid                 	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_is_hw_cso                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_is_spu_resp              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_abs                      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_ingress_cong_or_service_queue_wlan	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_priority                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	wan_flow_0                           	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of num_of_avail_dhd_repl_or_metadata_1_or_cpu_redirect union */
        uint8_t	egress_queue                         	; /* Member of num_of_avail_dhd_repl_or_metadata_1_or_cpu_redirect union */
		};
		/* Sub Union 4 */
		struct{
        uint32_t	reservedSU4_packet_length            	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_wlan_tid                 	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_is_hw_cso                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_is_spu_resp              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_abs                      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_ingress_cong_or_service_queue_wlan	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_priority                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	gdx_pd_data_13_4                     	:10	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of num_of_avail_dhd_repl_or_metadata_1_or_cpu_redirect union */
		};
	};
	/* Union WORD 2 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	bn1_or_abs3                	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	ssid_or_metadata_2_or_cpu_redirect_or_spu_session	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	metadata_0_1               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	vport_or_flow              	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	is_emac                    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	metadata_1_1               	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	target_mem_1               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	drop                       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 1 */
		struct{
        uint32_t	bn1_first                            	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of bn1_or_abs3 union */
        uint32_t	ssid                                 	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ssid_or_metadata_2_or_cpu_redirect_or_spu_session union */
        uint32_t	reservedSU1_metadata_0_1             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	flow                                 	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of vport_or_flow union */
        uint32_t	reservedSU1_is_emac                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_metadata_1_1             	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_target_mem_1             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_drop                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 2 */
		struct{
        uint32_t	abs3                                 	:11	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of bn1_or_abs3 union */
        uint32_t	reserved4                            	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of bn1_or_abs3 union */
        uint32_t	metadata_2                           	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ssid_or_metadata_2_or_cpu_redirect_or_spu_session union */
        uint32_t	reserved2                            	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ssid_or_metadata_2_or_cpu_redirect_or_spu_session union */
        uint32_t	reservedSU2_metadata_0_1             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	source_port                          	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of vport_or_flow union */
        uint32_t	reservedSU2_is_emac                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_metadata_1_1             	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_target_mem_1             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_drop                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 3 */
		struct{
        uint32_t	reservedSU3_bn1_or_abs3              	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved3                            	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ssid_or_metadata_2_or_cpu_redirect_or_spu_session union */
        uint32_t	omci_enc_key_index                   	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ssid_or_metadata_2_or_cpu_redirect_or_spu_session union */
        uint32_t	reservedSU3_metadata_0_1             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	port_id                              	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of vport_or_flow union */
        uint32_t	reservedSU3_is_emac                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_metadata_1_1             	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_target_mem_1             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_drop                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 4 */
		struct{
        uint32_t	reservedSU4_bn1_or_abs3              	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved7                            	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ssid_or_metadata_2_or_cpu_redirect_or_spu_session union */
        uint32_t	crypto_session_id_hi                 	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ssid_or_metadata_2_or_cpu_redirect_or_spu_session union */
        uint32_t	reservedSU4_metadata_0_1             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_vport_or_flow            	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_is_emac                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_metadata_1_1             	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_target_mem_1             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_drop                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 5 */
		struct{
        uint32_t	reservedSU5_bn1_or_abs3              	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	gdx_pd_data_15_14                    	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ssid_or_metadata_2_or_cpu_redirect_or_spu_session union */
        uint32_t	is_gdx_rx                            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ssid_or_metadata_2_or_cpu_redirect_or_spu_session union */
        uint32_t	is_gdx_tx                            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ssid_or_metadata_2_or_cpu_redirect_or_spu_session union */
        uint32_t	reservedSU5_metadata_0_1             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU5_vport_or_flow            	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU5_is_emac                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU5_metadata_1_1             	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU5_target_mem_1             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU5_drop                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
	/* Union WORD 3 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	payload_offset_sop         	:30	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	target_mem_0               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	agg_pd                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 1 */
		struct{
        uint32_t	bn_fpm                               	:20	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of payload_offset_sop union */
        uint32_t	sop_fpm                              	:10	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of payload_offset_sop union */
        uint32_t	reservedSU1_target_mem_0             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_agg_pd                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 2 */
		struct{
        uint16_t	bn0_first                            	; /* Member of payload_offset_sop union */
        uint32_t	sop                                  	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of payload_offset_sop union */
        uint32_t	bn_num                               	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of payload_offset_sop union */
        uint32_t	reservedSU2_target_mem_0             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_agg_pd                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 3 */
		struct{
        uint32_t	abs0                                 	:29	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of payload_offset_sop union */
        uint32_t	reserved5                            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of payload_offset_sop union */
        uint32_t	reservedSU3_target_mem_0             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_agg_pd                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 4 */
		struct{
        uint32_t	fpm_num                              	:18	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of payload_offset_sop union */
        uint32_t	fpm_pool                             	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of payload_offset_sop union */
        uint32_t	reserved6                            	:10	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of payload_offset_sop union */
        uint32_t	reservedSU4_target_mem_0             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_agg_pd                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) PROCESSING_CPU_RX_DESCRIPTOR_STRUCT;

#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_VALID_READ_G(r, g, idx)                                                      GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 7, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_VALID_WRITE_G(v, g, idx)                                                     GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 7, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_VALID_READ_CORE(r, g, idx, core_id)                                          CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 7, 1, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_VALID_WRITE_CORE(v, g, idx, core_id)                                         CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 7, 1, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_VALID_READ(r, p)                                                             RDP_FIELD_MREAD_8((uint8_t *)(p), 7, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_VALID_WRITE(v, p)                                                            RDP_FIELD_MWRITE_8((uint8_t *)(p), 7, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_HEADROOM_READ_G(r, g, idx)                                                   GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 6, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_HEADROOM_WRITE_G(v, g, idx)                                                  GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 6, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_HEADROOM_READ_CORE(r, g, idx, core_id)                                       CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 6, 1, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_HEADROOM_WRITE_CORE(v, g, idx, core_id)                                      CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 6, 1, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_HEADROOM_READ(r, p)                                                          RDP_FIELD_MREAD_8((uint8_t *)(p), 6, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_HEADROOM_WRITE(v, p)                                                         RDP_FIELD_MWRITE_8((uint8_t *)(p), 6, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_DONT_AGG_OR_IS_CHKSUM_VERIFIED_READ_G(r, g, idx)                             GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 5, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_DONT_AGG_OR_IS_CHKSUM_VERIFIED_WRITE_G(v, g, idx)                            GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 5, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_DONT_AGG_OR_IS_CHKSUM_VERIFIED_READ_CORE(r, g, idx, core_id)                 CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 5, 1, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_DONT_AGG_OR_IS_CHKSUM_VERIFIED_WRITE_CORE(v, g, idx, core_id)                CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 5, 1, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_DONT_AGG_OR_IS_CHKSUM_VERIFIED_READ(r, p)                                    RDP_FIELD_MREAD_8((uint8_t *)(p), 5, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_DONT_AGG_OR_IS_CHKSUM_VERIFIED_WRITE(v, p)                                   RDP_FIELD_MWRITE_8((uint8_t *)(p), 5, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_DONT_AGG_READ_G(r, g, idx)                                                   GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 5, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_DONT_AGG_WRITE_G(v, g, idx)                                                  GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 5, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_DONT_AGG_READ_CORE(r, g, idx, core_id)                                       CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 5, 1, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_DONT_AGG_WRITE_CORE(v, g, idx, core_id)                                      CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 5, 1, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_DONT_AGG_READ(r, p)                                                          RDP_FIELD_MREAD_8((uint8_t *)(p), 5, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_DONT_AGG_WRITE(v, p)                                                         RDP_FIELD_MWRITE_8((uint8_t *)(p), 5, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_IS_CHKSUM_VERIFIED_READ_G(r, g, idx)                                         GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 5, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_IS_CHKSUM_VERIFIED_WRITE_G(v, g, idx)                                        GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 5, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_IS_CHKSUM_VERIFIED_READ_CORE(r, g, idx, core_id)                             CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 5, 1, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_IS_CHKSUM_VERIFIED_WRITE_CORE(v, g, idx, core_id)                            CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 5, 1, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_IS_CHKSUM_VERIFIED_READ(r, p)                                                RDP_FIELD_MREAD_8((uint8_t *)(p), 5, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_IS_CHKSUM_VERIFIED_WRITE(v, p)                                               RDP_FIELD_MWRITE_8((uint8_t *)(p), 5, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_MC_COPY_READ_G(r, g, idx)                                                    GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 4, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_MC_COPY_WRITE_G(v, g, idx)                                                   GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 4, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_MC_COPY_READ_CORE(r, g, idx, core_id)                                        CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 4, 1, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_MC_COPY_WRITE_CORE(v, g, idx, core_id)                                       CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 4, 1, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_MC_COPY_READ(r, p)                                                           RDP_FIELD_MREAD_8((uint8_t *)(p), 4, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_MC_COPY_WRITE(v, p)                                                          RDP_FIELD_MWRITE_8((uint8_t *)(p), 4, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_REPROCESS_READ_G(r, g, idx)                                                  GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 3, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_REPROCESS_WRITE_G(v, g, idx)                                                 GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 3, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_REPROCESS_READ_CORE(r, g, idx, core_id)                                      CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 3, 1, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_REPROCESS_WRITE_CORE(v, g, idx, core_id)                                     CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 3, 1, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_REPROCESS_READ(r, p)                                                         RDP_FIELD_MREAD_8((uint8_t *)(p), 3, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_REPROCESS_WRITE(v, p)                                                        RDP_FIELD_MWRITE_8((uint8_t *)(p), 3, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_COLOR_READ_G(r, g, idx)                                                      GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 2, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_COLOR_WRITE_G(v, g, idx)                                                     GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 2, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_COLOR_READ_CORE(r, g, idx, core_id)                                          CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 2, 1, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_COLOR_WRITE_CORE(v, g, idx, core_id)                                         CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 2, 1, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_COLOR_READ(r, p)                                                             RDP_FIELD_MREAD_8((uint8_t *)(p), 2, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_COLOR_WRITE(v, p)                                                            RDP_FIELD_MWRITE_8((uint8_t *)(p), 2, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FORCE_COPY_READ_G(r, g, idx)                                                 GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 1, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FORCE_COPY_WRITE_G(v, g, idx)                                                GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 1, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FORCE_COPY_READ_CORE(r, g, idx, core_id)                                     CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 1, 1, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FORCE_COPY_WRITE_CORE(v, g, idx, core_id)                                    CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 1, 1, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FORCE_COPY_READ(r, p)                                                        RDP_FIELD_MREAD_8((uint8_t *)(p), 1, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FORCE_COPY_WRITE(v, p)                                                       RDP_FIELD_MWRITE_8((uint8_t *)(p), 1, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_TYPE_OR_SERVICE_QUEUE_WLAN_FRW_TYPE_READ_G(r, g, idx)                        GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 7, 2, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_TYPE_OR_SERVICE_QUEUE_WLAN_FRW_TYPE_WRITE_G(v, g, idx)                       GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 7, 2, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_TYPE_OR_SERVICE_QUEUE_WLAN_FRW_TYPE_READ_CORE(r, g, idx, core_id)            CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 7, 2, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_TYPE_OR_SERVICE_QUEUE_WLAN_FRW_TYPE_WRITE_CORE(v, g, idx, core_id)           CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 7, 2, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_TYPE_OR_SERVICE_QUEUE_WLAN_FRW_TYPE_READ(r, p)                               RDP_FIELD_MREAD_16((uint8_t *)(p), 7, 2, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_TYPE_OR_SERVICE_QUEUE_WLAN_FRW_TYPE_WRITE(v, p)                              RDP_FIELD_MWRITE_16((uint8_t *)(p), 7, 2, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_TYPE_READ_G(r, g, idx)                                                       GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 7, 2, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_TYPE_WRITE_G(v, g, idx)                                                      GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 7, 2, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_TYPE_READ_CORE(r, g, idx, core_id)                                           CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 7, 2, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_TYPE_WRITE_CORE(v, g, idx, core_id)                                          CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 7, 2, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_TYPE_READ(r, p)                                                              RDP_FIELD_MREAD_16((uint8_t *)(p), 7, 2, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_TYPE_WRITE(v, p)                                                             RDP_FIELD_MWRITE_16((uint8_t *)(p), 7, 2, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SERVICE_QUEUE_IS_WLAN_READ_G(r, g, idx)                                      GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 0, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SERVICE_QUEUE_IS_WLAN_WRITE_G(v, g, idx)                                     GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 0, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SERVICE_QUEUE_IS_WLAN_READ_CORE(r, g, idx, core_id)                          CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 0, 1, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SERVICE_QUEUE_IS_WLAN_WRITE_CORE(v, g, idx, core_id)                         CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 0, 1, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SERVICE_QUEUE_IS_WLAN_READ(r, p)                                             RDP_FIELD_MREAD_8((uint8_t *)(p), 0, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SERVICE_QUEUE_IS_WLAN_WRITE(v, p)                                            RDP_FIELD_MWRITE_8((uint8_t *)(p), 0, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SERVICE_QUEUE_WLAN_FRW_TYPE_READ_G(r, g, idx)                                GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 7, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SERVICE_QUEUE_WLAN_FRW_TYPE_WRITE_G(v, g, idx)                               GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 7, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SERVICE_QUEUE_WLAN_FRW_TYPE_READ_CORE(r, g, idx, core_id)                    CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 7, 1, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SERVICE_QUEUE_WLAN_FRW_TYPE_WRITE_CORE(v, g, idx, core_id)                   CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 7, 1, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SERVICE_QUEUE_WLAN_FRW_TYPE_READ(r, p)                                       RDP_FIELD_MREAD_8((uint8_t *)(p) + 1, 7, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SERVICE_QUEUE_WLAN_FRW_TYPE_WRITE(v, p)                                      RDP_FIELD_MWRITE_8((uint8_t *)(p) + 1, 7, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_REASON_OR_FORWARDING_READ_G(r, g, idx)                                       GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 0, 7, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_REASON_OR_FORWARDING_WRITE_G(v, g, idx)                                      GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 0, 7, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_REASON_OR_FORWARDING_READ_CORE(r, g, idx, core_id)                           CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 0, 7, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_REASON_OR_FORWARDING_WRITE_CORE(v, g, idx, core_id)                          CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 0, 7, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_REASON_OR_FORWARDING_READ(r, p)                                              RDP_FIELD_MREAD_8((uint8_t *)(p) + 1, 0, 7, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_REASON_OR_FORWARDING_WRITE(v, p)                                             RDP_FIELD_MWRITE_8((uint8_t *)(p) + 1, 0, 7, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_CPU_REDIRECT_0_READ_G(r, g, idx)                                             GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 6, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_CPU_REDIRECT_0_WRITE_G(v, g, idx)                                            GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 6, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_CPU_REDIRECT_0_READ_CORE(r, g, idx, core_id)                                 CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 6, 1, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_CPU_REDIRECT_0_WRITE_CORE(v, g, idx, core_id)                                CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 6, 1, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_CPU_REDIRECT_0_READ(r, p)                                                    RDP_FIELD_MREAD_8((uint8_t *)(p) + 1, 6, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_CPU_REDIRECT_0_WRITE(v, p)                                                   RDP_FIELD_MWRITE_8((uint8_t *)(p) + 1, 6, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_CPU_REASON_READ_G(r, g, idx)                                                 GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 0, 6, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_CPU_REASON_WRITE_G(v, g, idx)                                                GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 0, 6, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_CPU_REASON_READ_CORE(r, g, idx, core_id)                                     CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 0, 6, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_CPU_REASON_WRITE_CORE(v, g, idx, core_id)                                    CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 0, 6, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_CPU_REASON_READ(r, p)                                                        RDP_FIELD_MREAD_8((uint8_t *)(p) + 1, 0, 6, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_CPU_REASON_WRITE(v, p)                                                       RDP_FIELD_MWRITE_8((uint8_t *)(p) + 1, 0, 6, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_TC_READ_G(r, g, idx)                                                         GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 4, 3, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_TC_WRITE_G(v, g, idx)                                                        GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 4, 3, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_TC_READ_CORE(r, g, idx, core_id)                                             CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 4, 3, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_TC_WRITE_CORE(v, g, idx, core_id)                                            CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 4, 3, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_TC_READ(r, p)                                                                RDP_FIELD_MREAD_8((uint8_t *)(p) + 1, 4, 3, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_TC_WRITE(v, p)                                                               RDP_FIELD_MWRITE_8((uint8_t *)(p) + 1, 4, 3, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_0_0_READ_G(r, g, idx)                                               GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 0, 4, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_0_0_WRITE_G(v, g, idx)                                              GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 0, 4, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_0_0_READ_CORE(r, g, idx, core_id)                                   CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 0, 4, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_0_0_WRITE_CORE(v, g, idx, core_id)                                  CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 0, 4, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_0_0_READ(r, p)                                                      RDP_FIELD_MREAD_8((uint8_t *)(p) + 1, 0, 4, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_0_0_WRITE(v, p)                                                     RDP_FIELD_MWRITE_8((uint8_t *)(p) + 1, 0, 4, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_CPU_REDIRECT_1_READ_G(r, g, idx)                                             GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 6, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_CPU_REDIRECT_1_WRITE_G(v, g, idx)                                            GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 6, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_CPU_REDIRECT_1_READ_CORE(r, g, idx, core_id)                                 CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 6, 1, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_CPU_REDIRECT_1_WRITE_CORE(v, g, idx, core_id)                                CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 6, 1, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_CPU_REDIRECT_1_READ(r, p)                                                    RDP_FIELD_MREAD_8((uint8_t *)(p) + 1, 6, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_CPU_REDIRECT_1_WRITE(v, p)                                                   RDP_FIELD_MWRITE_8((uint8_t *)(p) + 1, 6, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_WAN_FLOW_1_READ_G(r, g, idx)                                                 GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 0, 6, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_WAN_FLOW_1_WRITE_G(v, g, idx)                                                GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 0, 6, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_WAN_FLOW_1_READ_CORE(r, g, idx, core_id)                                     CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 0, 6, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_WAN_FLOW_1_WRITE_CORE(v, g, idx, core_id)                                    CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 0, 6, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_WAN_FLOW_1_READ(r, p)                                                        RDP_FIELD_MREAD_8((uint8_t *)(p) + 1, 0, 6, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_WAN_FLOW_1_WRITE(v, p)                                                       RDP_FIELD_MWRITE_8((uint8_t *)(p) + 1, 0, 6, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_DHD_FLOW_PRIORITY_READ_G(r, g, idx)                                          GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 5, 2, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_DHD_FLOW_PRIORITY_WRITE_G(v, g, idx)                                         GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 5, 2, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_DHD_FLOW_PRIORITY_READ_CORE(r, g, idx, core_id)                              CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 5, 2, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_DHD_FLOW_PRIORITY_WRITE_CORE(v, g, idx, core_id)                             CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 5, 2, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_DHD_FLOW_PRIORITY_READ(r, p)                                                 RDP_FIELD_MREAD_8((uint8_t *)(p) + 1, 5, 2, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_DHD_FLOW_PRIORITY_WRITE(v, p)                                                RDP_FIELD_MWRITE_8((uint8_t *)(p) + 1, 5, 2, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FIRST_LEVEL_Q_READ_G(r, g, idx)                                              GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 2, 7, 9, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FIRST_LEVEL_Q_WRITE_G(v, g, idx)                                             GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 2, 7, 9, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FIRST_LEVEL_Q_READ_CORE(r, g, idx, core_id)                                  CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 2, 7, 9, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FIRST_LEVEL_Q_WRITE_CORE(v, g, idx, core_id)                                 CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 2, 7, 9, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FIRST_LEVEL_Q_READ(r, p)                                                     RDP_FIELD_MREAD_16((uint8_t *)(p) + 2, 7, 9, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FIRST_LEVEL_Q_WRITE(v, p)                                                    RDP_FIELD_MWRITE_16((uint8_t *)(p) + 2, 7, 9, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FLAG_1588_OR_DSL_RX_READ_G(r, g, idx)                                        GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 6, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FLAG_1588_OR_DSL_RX_WRITE_G(v, g, idx)                                       GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 6, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FLAG_1588_OR_DSL_RX_READ_CORE(r, g, idx, core_id)                            CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 6, 1, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FLAG_1588_OR_DSL_RX_WRITE_CORE(v, g, idx, core_id)                           CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 6, 1, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FLAG_1588_OR_DSL_RX_READ(r, p)                                               RDP_FIELD_MREAD_8((uint8_t *)(p) + 3, 6, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FLAG_1588_OR_DSL_RX_WRITE(v, p)                                              RDP_FIELD_MWRITE_8((uint8_t *)(p) + 3, 6, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FLAG_1588_READ_G(r, g, idx)                                                  GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 6, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FLAG_1588_WRITE_G(v, g, idx)                                                 GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 6, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FLAG_1588_READ_CORE(r, g, idx, core_id)                                      CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 6, 1, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FLAG_1588_WRITE_CORE(v, g, idx, core_id)                                     CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 6, 1, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FLAG_1588_READ(r, p)                                                         RDP_FIELD_MREAD_8((uint8_t *)(p) + 3, 6, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FLAG_1588_WRITE(v, p)                                                        RDP_FIELD_MWRITE_8((uint8_t *)(p) + 3, 6, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_DSL_RX_READ_G(r, g, idx)                                                     GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 6, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_DSL_RX_WRITE_G(v, g, idx)                                                    GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 6, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_DSL_RX_READ_CORE(r, g, idx, core_id)                                         CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 6, 1, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_DSL_RX_WRITE_CORE(v, g, idx, core_id)                                        CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 6, 1, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_DSL_RX_READ(r, p)                                                            RDP_FIELD_MREAD_8((uint8_t *)(p) + 3, 6, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_DSL_RX_WRITE(v, p)                                                           RDP_FIELD_MWRITE_8((uint8_t *)(p) + 3, 6, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_COHERENT_OR_FORWARDING_READ_G(r, g, idx)                                     GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 5, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_COHERENT_OR_FORWARDING_WRITE_G(v, g, idx)                                    GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 5, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_COHERENT_OR_FORWARDING_READ_CORE(r, g, idx, core_id)                         CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 5, 1, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_COHERENT_OR_FORWARDING_WRITE_CORE(v, g, idx, core_id)                        CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 5, 1, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_COHERENT_OR_FORWARDING_READ(r, p)                                            RDP_FIELD_MREAD_8((uint8_t *)(p) + 3, 5, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_COHERENT_OR_FORWARDING_WRITE(v, p)                                           RDP_FIELD_MWRITE_8((uint8_t *)(p) + 3, 5, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_COHERENT_READ_G(r, g, idx)                                                   GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 5, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_COHERENT_WRITE_G(v, g, idx)                                                  GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 5, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_COHERENT_READ_CORE(r, g, idx, core_id)                                       CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 5, 1, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_COHERENT_WRITE_CORE(v, g, idx, core_id)                                      CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 5, 1, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_COHERENT_READ(r, p)                                                          RDP_FIELD_MREAD_8((uint8_t *)(p) + 3, 5, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_COHERENT_WRITE(v, p)                                                         RDP_FIELD_MWRITE_8((uint8_t *)(p) + 3, 5, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_UCAST_READ_G(r, g, idx)                                                      GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 5, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_UCAST_WRITE_G(v, g, idx)                                                     GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 5, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_UCAST_READ_CORE(r, g, idx, core_id)                                          CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 5, 1, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_UCAST_WRITE_CORE(v, g, idx, core_id)                                         CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 5, 1, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_UCAST_READ(r, p)                                                             RDP_FIELD_MREAD_8((uint8_t *)(p) + 3, 5, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_UCAST_WRITE(v, p)                                                            RDP_FIELD_MWRITE_8((uint8_t *)(p) + 3, 5, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_1_2_OR_SPDTEST_STREAM_ID_OR_SPU_SESSION_READ_G(r, g, idx)           GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 1, 4, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_1_2_OR_SPDTEST_STREAM_ID_OR_SPU_SESSION_WRITE_G(v, g, idx)          GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 1, 4, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_1_2_OR_SPDTEST_STREAM_ID_OR_SPU_SESSION_READ_CORE(r, g, idx, core_id)CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 1, 4, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_1_2_OR_SPDTEST_STREAM_ID_OR_SPU_SESSION_WRITE_CORE(v, g, idx, core_id)CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 1, 4, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_1_2_OR_SPDTEST_STREAM_ID_OR_SPU_SESSION_READ(r, p)                  RDP_FIELD_MREAD_8((uint8_t *)(p) + 3, 1, 4, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_1_2_OR_SPDTEST_STREAM_ID_OR_SPU_SESSION_WRITE(v, p)                 RDP_FIELD_MWRITE_8((uint8_t *)(p) + 3, 1, 4, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_1_2_READ_G(r, g, idx)                                               GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 1, 4, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_1_2_WRITE_G(v, g, idx)                                              GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 1, 4, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_1_2_READ_CORE(r, g, idx, core_id)                                   CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 1, 4, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_1_2_WRITE_CORE(v, g, idx, core_id)                                  CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 1, 4, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_1_2_READ(r, p)                                                      RDP_FIELD_MREAD_8((uint8_t *)(p) + 3, 1, 4, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_1_2_WRITE(v, p)                                                     RDP_FIELD_MWRITE_8((uint8_t *)(p) + 3, 1, 4, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SPDTEST_STREAM_ID_READ_G(r, g, idx)                                          GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 2, 3, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SPDTEST_STREAM_ID_WRITE_G(v, g, idx)                                         GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 2, 3, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SPDTEST_STREAM_ID_READ_CORE(r, g, idx, core_id)                              CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 2, 3, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SPDTEST_STREAM_ID_WRITE_CORE(v, g, idx, core_id)                             CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 2, 3, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SPDTEST_STREAM_ID_READ(r, p)                                                 RDP_FIELD_MREAD_8((uint8_t *)(p) + 3, 2, 3, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SPDTEST_STREAM_ID_WRITE(v, p)                                                RDP_FIELD_MWRITE_8((uint8_t *)(p) + 3, 2, 3, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_TCPSPDTEST_IS_UPLOAD_READ_G(r, g, idx)                                       GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 1, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_TCPSPDTEST_IS_UPLOAD_WRITE_G(v, g, idx)                                      GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 1, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_TCPSPDTEST_IS_UPLOAD_READ_CORE(r, g, idx, core_id)                           CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 1, 1, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_TCPSPDTEST_IS_UPLOAD_WRITE_CORE(v, g, idx, core_id)                          CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 1, 1, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_TCPSPDTEST_IS_UPLOAD_READ(r, p)                                              RDP_FIELD_MREAD_8((uint8_t *)(p) + 3, 1, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_TCPSPDTEST_IS_UPLOAD_WRITE(v, p)                                             RDP_FIELD_MWRITE_8((uint8_t *)(p) + 3, 1, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_CRYPTO_SESSION_ID_LO_READ_G(r, g, idx)                                       GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 1, 4, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_CRYPTO_SESSION_ID_LO_WRITE_G(v, g, idx)                                      GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 1, 4, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_CRYPTO_SESSION_ID_LO_READ_CORE(r, g, idx, core_id)                           CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 1, 4, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_CRYPTO_SESSION_ID_LO_WRITE_CORE(v, g, idx, core_id)                          CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 1, 4, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_CRYPTO_SESSION_ID_LO_READ(r, p)                                              RDP_FIELD_MREAD_8((uint8_t *)(p) + 3, 1, 4, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_CRYPTO_SESSION_ID_LO_WRITE(v, p)                                             RDP_FIELD_MWRITE_8((uint8_t *)(p) + 3, 1, 4, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_GDX_PD_DATA_3_0_READ_G(r, g, idx)                                            GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 1, 4, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_GDX_PD_DATA_3_0_WRITE_G(v, g, idx)                                           GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 1, 4, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_GDX_PD_DATA_3_0_READ_CORE(r, g, idx, core_id)                                CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 1, 4, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_GDX_PD_DATA_3_0_WRITE_CORE(v, g, idx, core_id)                               CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 1, 4, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_GDX_PD_DATA_3_0_READ(r, p)                                                   RDP_FIELD_MREAD_8((uint8_t *)(p) + 3, 1, 4, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_GDX_PD_DATA_3_0_WRITE(v, p)                                                  RDP_FIELD_MWRITE_8((uint8_t *)(p) + 3, 1, 4, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_NUM_OF_AVAIL_DHD_REPL_OR_METADATA_1_OR_CPU_REDIRECT_READ_G(r, g, idx)        GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 4, 6, 10, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_NUM_OF_AVAIL_DHD_REPL_OR_METADATA_1_OR_CPU_REDIRECT_WRITE_G(v, g, idx)       GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 4, 6, 10, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_NUM_OF_AVAIL_DHD_REPL_OR_METADATA_1_OR_CPU_REDIRECT_READ_CORE(r, g, idx, core_id)CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 4, 6, 10, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_NUM_OF_AVAIL_DHD_REPL_OR_METADATA_1_OR_CPU_REDIRECT_WRITE_CORE(v, g, idx, core_id)CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 4, 6, 10, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_NUM_OF_AVAIL_DHD_REPL_OR_METADATA_1_OR_CPU_REDIRECT_READ(r, p)               RDP_FIELD_MREAD_16((uint8_t *)(p) + 4, 6, 10, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_NUM_OF_AVAIL_DHD_REPL_OR_METADATA_1_OR_CPU_REDIRECT_WRITE(v, p)              RDP_FIELD_MWRITE_16((uint8_t *)(p) + 4, 6, 10, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_1_0_READ_G(r, g, idx)                                               GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 4, 6, 10, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_1_0_WRITE_G(v, g, idx)                                              GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 4, 6, 10, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_1_0_READ_CORE(r, g, idx, core_id)                                   CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 4, 6, 10, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_1_0_WRITE_CORE(v, g, idx, core_id)                                  CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 4, 6, 10, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_1_0_READ(r, p)                                                      RDP_FIELD_MREAD_16((uint8_t *)(p) + 4, 6, 10, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_1_0_WRITE(v, p)                                                     RDP_FIELD_MWRITE_16((uint8_t *)(p) + 4, 6, 10, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SPDTEST_L3_L4_HDR_LEN_READ_G(r, g, idx)                                      GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 4, 6, 10, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SPDTEST_L3_L4_HDR_LEN_WRITE_G(v, g, idx)                                     GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 4, 6, 10, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SPDTEST_L3_L4_HDR_LEN_READ_CORE(r, g, idx, core_id)                          CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 4, 6, 10, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SPDTEST_L3_L4_HDR_LEN_WRITE_CORE(v, g, idx, core_id)                         CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 4, 6, 10, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SPDTEST_L3_L4_HDR_LEN_READ(r, p)                                             RDP_FIELD_MREAD_16((uint8_t *)(p) + 4, 6, 10, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SPDTEST_L3_L4_HDR_LEN_WRITE(v, p)                                            RDP_FIELD_MWRITE_16((uint8_t *)(p) + 4, 6, 10, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_EGRESS_QUEUE_READ_G(r, g, idx)                                               GROUP_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 4, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_EGRESS_QUEUE_WRITE_G(v, g, idx)                                              GROUP_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 4, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_EGRESS_QUEUE_READ_CORE(r, g, idx, core_id)                                   CORE_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 4, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_EGRESS_QUEUE_WRITE_CORE(v, g, idx, core_id)                                  CORE_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 4, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_EGRESS_QUEUE_READ(r, p)                                                      MREAD_8((uint8_t *)(p) + 4, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_EGRESS_QUEUE_WRITE(v, p)                                                     MWRITE_8((uint8_t *)(p) + 4, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_WAN_FLOW_0_READ_G(r, g, idx)                                                 GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 5, 6, 2, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_WAN_FLOW_0_WRITE_G(v, g, idx)                                                GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 5, 6, 2, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_WAN_FLOW_0_READ_CORE(r, g, idx, core_id)                                     CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 5, 6, 2, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_WAN_FLOW_0_WRITE_CORE(v, g, idx, core_id)                                    CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 5, 6, 2, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_WAN_FLOW_0_READ(r, p)                                                        RDP_FIELD_MREAD_8((uint8_t *)(p) + 5, 6, 2, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_WAN_FLOW_0_WRITE(v, p)                                                       RDP_FIELD_MWRITE_8((uint8_t *)(p) + 5, 6, 2, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_GDX_PD_DATA_13_4_READ_G(r, g, idx)                                           GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 4, 6, 10, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_GDX_PD_DATA_13_4_WRITE_G(v, g, idx)                                          GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 4, 6, 10, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_GDX_PD_DATA_13_4_READ_CORE(r, g, idx, core_id)                               CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 4, 6, 10, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_GDX_PD_DATA_13_4_WRITE_CORE(v, g, idx, core_id)                              CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 4, 6, 10, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_GDX_PD_DATA_13_4_READ(r, p)                                                  RDP_FIELD_MREAD_16((uint8_t *)(p) + 4, 6, 10, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_GDX_PD_DATA_13_4_WRITE(v, p)                                                 RDP_FIELD_MWRITE_16((uint8_t *)(p) + 4, 6, 10, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_PRIORITY_READ_G(r, g, idx)                                                   GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 5, 5, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_PRIORITY_WRITE_G(v, g, idx)                                                  GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 5, 5, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_PRIORITY_READ_CORE(r, g, idx, core_id)                                       CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 5, 5, 1, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_PRIORITY_WRITE_CORE(v, g, idx, core_id)                                      CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 5, 5, 1, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_PRIORITY_READ(r, p)                                                          RDP_FIELD_MREAD_8((uint8_t *)(p) + 5, 5, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_PRIORITY_WRITE(v, p)                                                         RDP_FIELD_MWRITE_8((uint8_t *)(p) + 5, 5, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_INGRESS_CONG_OR_SERVICE_QUEUE_WLAN_READ_G(r, g, idx)                         GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 5, 4, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_INGRESS_CONG_OR_SERVICE_QUEUE_WLAN_WRITE_G(v, g, idx)                        GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 5, 4, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_INGRESS_CONG_OR_SERVICE_QUEUE_WLAN_READ_CORE(r, g, idx, core_id)             CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 5, 4, 1, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_INGRESS_CONG_OR_SERVICE_QUEUE_WLAN_WRITE_CORE(v, g, idx, core_id)            CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 5, 4, 1, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_INGRESS_CONG_OR_SERVICE_QUEUE_WLAN_READ(r, p)                                RDP_FIELD_MREAD_8((uint8_t *)(p) + 5, 4, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_INGRESS_CONG_OR_SERVICE_QUEUE_WLAN_WRITE(v, p)                               RDP_FIELD_MWRITE_8((uint8_t *)(p) + 5, 4, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_INGRESS_CONG_READ_G(r, g, idx)                                               GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 5, 4, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_INGRESS_CONG_WRITE_G(v, g, idx)                                              GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 5, 4, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_INGRESS_CONG_READ_CORE(r, g, idx, core_id)                                   CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 5, 4, 1, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_INGRESS_CONG_WRITE_CORE(v, g, idx, core_id)                                  CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 5, 4, 1, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_INGRESS_CONG_READ(r, p)                                                      RDP_FIELD_MREAD_8((uint8_t *)(p) + 5, 4, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_INGRESS_CONG_WRITE(v, p)                                                     RDP_FIELD_MWRITE_8((uint8_t *)(p) + 5, 4, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_ABS_READ_G(r, g, idx)                                                        GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 5, 3, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_ABS_WRITE_G(v, g, idx)                                                       GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 5, 3, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_ABS_READ_CORE(r, g, idx, core_id)                                            CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 5, 3, 1, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_ABS_WRITE_CORE(v, g, idx, core_id)                                           CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 5, 3, 1, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_ABS_READ(r, p)                                                               RDP_FIELD_MREAD_8((uint8_t *)(p) + 5, 3, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_ABS_WRITE(v, p)                                                              RDP_FIELD_MWRITE_8((uint8_t *)(p) + 5, 3, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_IS_SPU_RESP_READ_G(r, g, idx)                                                GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 5, 2, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_IS_SPU_RESP_WRITE_G(v, g, idx)                                               GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 5, 2, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_IS_SPU_RESP_READ_CORE(r, g, idx, core_id)                                    CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 5, 2, 1, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_IS_SPU_RESP_WRITE_CORE(v, g, idx, core_id)                                   CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 5, 2, 1, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_IS_SPU_RESP_READ(r, p)                                                       RDP_FIELD_MREAD_8((uint8_t *)(p) + 5, 2, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_IS_SPU_RESP_WRITE(v, p)                                                      RDP_FIELD_MWRITE_8((uint8_t *)(p) + 5, 2, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_IS_HW_CSO_READ_G(r, g, idx)                                                  GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 5, 1, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_IS_HW_CSO_WRITE_G(v, g, idx)                                                 GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 5, 1, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_IS_HW_CSO_READ_CORE(r, g, idx, core_id)                                      CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 5, 1, 1, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_IS_HW_CSO_WRITE_CORE(v, g, idx, core_id)                                     CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 5, 1, 1, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_IS_HW_CSO_READ(r, p)                                                         RDP_FIELD_MREAD_8((uint8_t *)(p) + 5, 1, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_IS_HW_CSO_WRITE(v, p)                                                        RDP_FIELD_MWRITE_8((uint8_t *)(p) + 5, 1, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_WLAN_TID_READ_G(r, g, idx)                                                   GROUP_RDP_FIELD_MREAD_32((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 4, 14, 3, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_WLAN_TID_WRITE_G(v, g, idx)                                                  GROUP_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 4, 14, 3, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_WLAN_TID_READ_CORE(r, g, idx, core_id)                                       CORE_RDP_FIELD_MREAD_32((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 4, 14, 3, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_WLAN_TID_WRITE_CORE(v, g, idx, core_id)                                      CORE_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 4, 14, 3, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_WLAN_TID_READ(r, p)                                                          RDP_FIELD_MREAD_32((uint8_t *)(p) + 4, 14, 3, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_WLAN_TID_WRITE(v, p)                                                         RDP_FIELD_MWRITE_32((uint8_t *)(p) + 4, 14, 3, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_PACKET_LENGTH_READ_G(r, g, idx)                                              GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 6, 0, 14, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_PACKET_LENGTH_WRITE_G(v, g, idx)                                             GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 6, 0, 14, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_PACKET_LENGTH_READ_CORE(r, g, idx, core_id)                                  CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 6, 0, 14, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_PACKET_LENGTH_WRITE_CORE(v, g, idx, core_id)                                 CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 6, 0, 14, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_PACKET_LENGTH_READ(r, p)                                                     RDP_FIELD_MREAD_16((uint8_t *)(p) + 6, 0, 14, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_PACKET_LENGTH_WRITE(v, p)                                                    RDP_FIELD_MWRITE_16((uint8_t *)(p) + 6, 0, 14, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_DROP_READ_G(r, g, idx)                                                       GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 7, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_DROP_WRITE_G(v, g, idx)                                                      GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 7, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_DROP_READ_CORE(r, g, idx, core_id)                                           CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 7, 1, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_DROP_WRITE_CORE(v, g, idx, core_id)                                          CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 7, 1, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_DROP_READ(r, p)                                                              RDP_FIELD_MREAD_8((uint8_t *)(p) + 8, 7, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_DROP_WRITE(v, p)                                                             RDP_FIELD_MWRITE_8((uint8_t *)(p) + 8, 7, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_TARGET_MEM_1_READ_G(r, g, idx)                                               GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 6, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_TARGET_MEM_1_WRITE_G(v, g, idx)                                              GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 6, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_TARGET_MEM_1_READ_CORE(r, g, idx, core_id)                                   CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 6, 1, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_TARGET_MEM_1_WRITE_CORE(v, g, idx, core_id)                                  CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 6, 1, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_TARGET_MEM_1_READ(r, p)                                                      RDP_FIELD_MREAD_8((uint8_t *)(p) + 8, 6, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_TARGET_MEM_1_WRITE(v, p)                                                     RDP_FIELD_MWRITE_8((uint8_t *)(p) + 8, 6, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_1_1_READ_G(r, g, idx)                                               GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 4, 2, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_1_1_WRITE_G(v, g, idx)                                              GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 4, 2, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_1_1_READ_CORE(r, g, idx, core_id)                                   CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 4, 2, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_1_1_WRITE_CORE(v, g, idx, core_id)                                  CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 4, 2, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_1_1_READ(r, p)                                                      RDP_FIELD_MREAD_8((uint8_t *)(p) + 8, 4, 2, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_1_1_WRITE(v, p)                                                     RDP_FIELD_MWRITE_8((uint8_t *)(p) + 8, 4, 2, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_IS_EMAC_READ_G(r, g, idx)                                                    GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 3, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_IS_EMAC_WRITE_G(v, g, idx)                                                   GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 3, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_IS_EMAC_READ_CORE(r, g, idx, core_id)                                        CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 3, 1, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_IS_EMAC_WRITE_CORE(v, g, idx, core_id)                                       CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 3, 1, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_IS_EMAC_READ(r, p)                                                           RDP_FIELD_MREAD_8((uint8_t *)(p) + 8, 3, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_IS_EMAC_WRITE(v, p)                                                          RDP_FIELD_MWRITE_8((uint8_t *)(p) + 8, 3, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_VPORT_OR_FLOW_READ_G(r, g, idx)                                              GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 3, 8, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_VPORT_OR_FLOW_WRITE_G(v, g, idx)                                             GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 3, 8, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_VPORT_OR_FLOW_READ_CORE(r, g, idx, core_id)                                  CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 3, 8, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_VPORT_OR_FLOW_WRITE_CORE(v, g, idx, core_id)                                 CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 3, 8, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_VPORT_OR_FLOW_READ(r, p)                                                     RDP_FIELD_MREAD_16((uint8_t *)(p) + 8, 3, 8, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_VPORT_OR_FLOW_WRITE(v, p)                                                    RDP_FIELD_MWRITE_16((uint8_t *)(p) + 8, 3, 8, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FLOW_READ_G(r, g, idx)                                                       GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 3, 8, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FLOW_WRITE_G(v, g, idx)                                                      GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 3, 8, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FLOW_READ_CORE(r, g, idx, core_id)                                           CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 3, 8, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FLOW_WRITE_CORE(v, g, idx, core_id)                                          CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 3, 8, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FLOW_READ(r, p)                                                              RDP_FIELD_MREAD_16((uint8_t *)(p) + 8, 3, 8, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FLOW_WRITE(v, p)                                                             RDP_FIELD_MWRITE_16((uint8_t *)(p) + 8, 3, 8, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SOURCE_PORT_READ_G(r, g, idx)                                                GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 3, 8, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SOURCE_PORT_WRITE_G(v, g, idx)                                               GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 3, 8, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SOURCE_PORT_READ_CORE(r, g, idx, core_id)                                    CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 3, 8, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SOURCE_PORT_WRITE_CORE(v, g, idx, core_id)                                   CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 3, 8, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SOURCE_PORT_READ(r, p)                                                       RDP_FIELD_MREAD_16((uint8_t *)(p) + 8, 3, 8, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SOURCE_PORT_WRITE(v, p)                                                      RDP_FIELD_MWRITE_16((uint8_t *)(p) + 8, 3, 8, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_PORT_ID_READ_G(r, g, idx)                                                    GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 3, 8, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_PORT_ID_WRITE_G(v, g, idx)                                                   GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 3, 8, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_PORT_ID_READ_CORE(r, g, idx, core_id)                                        CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 3, 8, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_PORT_ID_WRITE_CORE(v, g, idx, core_id)                                       CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 3, 8, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_PORT_ID_READ(r, p)                                                           RDP_FIELD_MREAD_16((uint8_t *)(p) + 8, 3, 8, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_PORT_ID_WRITE(v, p)                                                          RDP_FIELD_MWRITE_16((uint8_t *)(p) + 8, 3, 8, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_0_1_READ_G(r, g, idx)                                               GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 9, 2, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_0_1_WRITE_G(v, g, idx)                                              GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 9, 2, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_0_1_READ_CORE(r, g, idx, core_id)                                   CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 9, 2, 1, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_0_1_WRITE_CORE(v, g, idx, core_id)                                  CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 9, 2, 1, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_0_1_READ(r, p)                                                      RDP_FIELD_MREAD_8((uint8_t *)(p) + 9, 2, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_0_1_WRITE(v, p)                                                     RDP_FIELD_MWRITE_8((uint8_t *)(p) + 9, 2, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SSID_OR_METADATA_2_OR_CPU_REDIRECT_OR_SPU_SESSION_READ_G(r, g, idx)          GROUP_RDP_FIELD_MREAD_32((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 14, 4, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SSID_OR_METADATA_2_OR_CPU_REDIRECT_OR_SPU_SESSION_WRITE_G(v, g, idx)         GROUP_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 14, 4, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SSID_OR_METADATA_2_OR_CPU_REDIRECT_OR_SPU_SESSION_READ_CORE(r, g, idx, core_id)CORE_RDP_FIELD_MREAD_32((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 14, 4, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SSID_OR_METADATA_2_OR_CPU_REDIRECT_OR_SPU_SESSION_WRITE_CORE(v, g, idx, core_id)CORE_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 14, 4, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SSID_OR_METADATA_2_OR_CPU_REDIRECT_OR_SPU_SESSION_READ(r, p)                 RDP_FIELD_MREAD_32((uint8_t *)(p) + 8, 14, 4, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SSID_OR_METADATA_2_OR_CPU_REDIRECT_OR_SPU_SESSION_WRITE(v, p)                RDP_FIELD_MWRITE_32((uint8_t *)(p) + 8, 14, 4, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SSID_READ_G(r, g, idx)                                                       GROUP_RDP_FIELD_MREAD_32((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 14, 4, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SSID_WRITE_G(v, g, idx)                                                      GROUP_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 14, 4, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SSID_READ_CORE(r, g, idx, core_id)                                           CORE_RDP_FIELD_MREAD_32((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 14, 4, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SSID_WRITE_CORE(v, g, idx, core_id)                                          CORE_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 14, 4, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SSID_READ(r, p)                                                              RDP_FIELD_MREAD_32((uint8_t *)(p) + 8, 14, 4, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SSID_WRITE(v, p)                                                             RDP_FIELD_MWRITE_32((uint8_t *)(p) + 8, 14, 4, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_2_READ_G(r, g, idx)                                                 GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 10, 6, 2, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_2_WRITE_G(v, g, idx)                                                GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 10, 6, 2, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_2_READ_CORE(r, g, idx, core_id)                                     CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 10, 6, 2, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_2_WRITE_CORE(v, g, idx, core_id)                                    CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 10, 6, 2, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_2_READ(r, p)                                                        RDP_FIELD_MREAD_8((uint8_t *)(p) + 10, 6, 2, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_2_WRITE(v, p)                                                       RDP_FIELD_MWRITE_8((uint8_t *)(p) + 10, 6, 2, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_OMCI_ENC_KEY_INDEX_READ_G(r, g, idx)                                         GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 9, 0, 2, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_OMCI_ENC_KEY_INDEX_WRITE_G(v, g, idx)                                        GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 9, 0, 2, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_OMCI_ENC_KEY_INDEX_READ_CORE(r, g, idx, core_id)                             CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 9, 0, 2, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_OMCI_ENC_KEY_INDEX_WRITE_CORE(v, g, idx, core_id)                            CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 9, 0, 2, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_OMCI_ENC_KEY_INDEX_READ(r, p)                                                RDP_FIELD_MREAD_8((uint8_t *)(p) + 9, 0, 2, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_OMCI_ENC_KEY_INDEX_WRITE(v, p)                                               RDP_FIELD_MWRITE_8((uint8_t *)(p) + 9, 0, 2, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_CRYPTO_SESSION_ID_HI_READ_G(r, g, idx)                                       GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 9, 0, 2, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_CRYPTO_SESSION_ID_HI_WRITE_G(v, g, idx)                                      GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 9, 0, 2, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_CRYPTO_SESSION_ID_HI_READ_CORE(r, g, idx, core_id)                           CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 9, 0, 2, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_CRYPTO_SESSION_ID_HI_WRITE_CORE(v, g, idx, core_id)                          CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 9, 0, 2, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_CRYPTO_SESSION_ID_HI_READ(r, p)                                              RDP_FIELD_MREAD_8((uint8_t *)(p) + 9, 0, 2, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_CRYPTO_SESSION_ID_HI_WRITE(v, p)                                             RDP_FIELD_MWRITE_8((uint8_t *)(p) + 9, 0, 2, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_IS_GDX_TX_READ_G(r, g, idx)                                                  GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 9, 1, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_IS_GDX_TX_WRITE_G(v, g, idx)                                                 GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 9, 1, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_IS_GDX_TX_READ_CORE(r, g, idx, core_id)                                      CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 9, 1, 1, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_IS_GDX_TX_WRITE_CORE(v, g, idx, core_id)                                     CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 9, 1, 1, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_IS_GDX_TX_READ(r, p)                                                         RDP_FIELD_MREAD_8((uint8_t *)(p) + 9, 1, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_IS_GDX_TX_WRITE(v, p)                                                        RDP_FIELD_MWRITE_8((uint8_t *)(p) + 9, 1, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_IS_GDX_RX_READ_G(r, g, idx)                                                  GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 9, 0, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_IS_GDX_RX_WRITE_G(v, g, idx)                                                 GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 9, 0, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_IS_GDX_RX_READ_CORE(r, g, idx, core_id)                                      CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 9, 0, 1, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_IS_GDX_RX_WRITE_CORE(v, g, idx, core_id)                                     CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 9, 0, 1, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_IS_GDX_RX_READ(r, p)                                                         RDP_FIELD_MREAD_8((uint8_t *)(p) + 9, 0, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_IS_GDX_RX_WRITE(v, p)                                                        RDP_FIELD_MWRITE_8((uint8_t *)(p) + 9, 0, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_GDX_PD_DATA_15_14_READ_G(r, g, idx)                                          GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 10, 6, 2, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_GDX_PD_DATA_15_14_WRITE_G(v, g, idx)                                         GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 10, 6, 2, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_GDX_PD_DATA_15_14_READ_CORE(r, g, idx, core_id)                              CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 10, 6, 2, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_GDX_PD_DATA_15_14_WRITE_CORE(v, g, idx, core_id)                             CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 10, 6, 2, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_GDX_PD_DATA_15_14_READ(r, p)                                                 RDP_FIELD_MREAD_8((uint8_t *)(p) + 10, 6, 2, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_GDX_PD_DATA_15_14_WRITE(v, p)                                                RDP_FIELD_MWRITE_8((uint8_t *)(p) + 10, 6, 2, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_BN1_OR_ABS3_READ_G(r, g, idx)                                                GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 10, 0, 14, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_BN1_OR_ABS3_WRITE_G(v, g, idx)                                               GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 10, 0, 14, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_BN1_OR_ABS3_READ_CORE(r, g, idx, core_id)                                    CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 10, 0, 14, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_BN1_OR_ABS3_WRITE_CORE(v, g, idx, core_id)                                   CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 10, 0, 14, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_BN1_OR_ABS3_READ(r, p)                                                       RDP_FIELD_MREAD_16((uint8_t *)(p) + 10, 0, 14, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_BN1_OR_ABS3_WRITE(v, p)                                                      RDP_FIELD_MWRITE_16((uint8_t *)(p) + 10, 0, 14, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_BN1_FIRST_READ_G(r, g, idx)                                                  GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 10, 0, 14, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_BN1_FIRST_WRITE_G(v, g, idx)                                                 GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 10, 0, 14, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_BN1_FIRST_READ_CORE(r, g, idx, core_id)                                      CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 10, 0, 14, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_BN1_FIRST_WRITE_CORE(v, g, idx, core_id)                                     CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 10, 0, 14, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_BN1_FIRST_READ(r, p)                                                         RDP_FIELD_MREAD_16((uint8_t *)(p) + 10, 0, 14, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_BN1_FIRST_WRITE(v, p)                                                        RDP_FIELD_MWRITE_16((uint8_t *)(p) + 10, 0, 14, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_ABS3_READ_G(r, g, idx)                                                       GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 10, 0, 11, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_ABS3_WRITE_G(v, g, idx)                                                      GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 10, 0, 11, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_ABS3_READ_CORE(r, g, idx, core_id)                                           CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 10, 0, 11, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_ABS3_WRITE_CORE(v, g, idx, core_id)                                          CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 10, 0, 11, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_ABS3_READ(r, p)                                                              RDP_FIELD_MREAD_16((uint8_t *)(p) + 10, 0, 11, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_ABS3_WRITE(v, p)                                                             RDP_FIELD_MWRITE_16((uint8_t *)(p) + 10, 0, 11, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_AGG_PD_READ_G(r, g, idx)                                                     GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 12, 7, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_AGG_PD_WRITE_G(v, g, idx)                                                    GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 12, 7, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_AGG_PD_READ_CORE(r, g, idx, core_id)                                         CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 12, 7, 1, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_AGG_PD_WRITE_CORE(v, g, idx, core_id)                                        CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 12, 7, 1, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_AGG_PD_READ(r, p)                                                            RDP_FIELD_MREAD_8((uint8_t *)(p) + 12, 7, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_AGG_PD_WRITE(v, p)                                                           RDP_FIELD_MWRITE_8((uint8_t *)(p) + 12, 7, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_TARGET_MEM_0_READ_G(r, g, idx)                                               GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 12, 6, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_TARGET_MEM_0_WRITE_G(v, g, idx)                                              GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 12, 6, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_TARGET_MEM_0_READ_CORE(r, g, idx, core_id)                                   CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 12, 6, 1, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_TARGET_MEM_0_WRITE_CORE(v, g, idx, core_id)                                  CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 12, 6, 1, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_TARGET_MEM_0_READ(r, p)                                                      RDP_FIELD_MREAD_8((uint8_t *)(p) + 12, 6, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_TARGET_MEM_0_WRITE(v, p)                                                     RDP_FIELD_MWRITE_8((uint8_t *)(p) + 12, 6, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_PAYLOAD_OFFSET_SOP_READ_G(r, g, idx)                                         GROUP_RDP_FIELD_MREAD_32((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 12, 0, 30, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_PAYLOAD_OFFSET_SOP_WRITE_G(v, g, idx)                                        GROUP_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 12, 0, 30, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_PAYLOAD_OFFSET_SOP_READ_CORE(r, g, idx, core_id)                             CORE_RDP_FIELD_MREAD_32((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 12, 0, 30, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_PAYLOAD_OFFSET_SOP_WRITE_CORE(v, g, idx, core_id)                            CORE_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 12, 0, 30, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_PAYLOAD_OFFSET_SOP_READ(r, p)                                                RDP_FIELD_MREAD_32((uint8_t *)(p) + 12, 0, 30, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_PAYLOAD_OFFSET_SOP_WRITE(v, p)                                               RDP_FIELD_MWRITE_32((uint8_t *)(p) + 12, 0, 30, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SOP_FPM_READ_G(r, g, idx)                                                    GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 12, 4, 10, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SOP_FPM_WRITE_G(v, g, idx)                                                   GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 12, 4, 10, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SOP_FPM_READ_CORE(r, g, idx, core_id)                                        CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 12, 4, 10, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SOP_FPM_WRITE_CORE(v, g, idx, core_id)                                       CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 12, 4, 10, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SOP_FPM_READ(r, p)                                                           RDP_FIELD_MREAD_16((uint8_t *)(p) + 12, 4, 10, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SOP_FPM_WRITE(v, p)                                                          RDP_FIELD_MWRITE_16((uint8_t *)(p) + 12, 4, 10, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_BN_FPM_READ_G(r, g, idx)                                                     GROUP_RDP_FIELD_MREAD_32((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 12, 0, 20, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_BN_FPM_WRITE_G(v, g, idx)                                                    GROUP_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 12, 0, 20, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_BN_FPM_READ_CORE(r, g, idx, core_id)                                         CORE_RDP_FIELD_MREAD_32((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 12, 0, 20, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_BN_FPM_WRITE_CORE(v, g, idx, core_id)                                        CORE_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 12, 0, 20, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_BN_FPM_READ(r, p)                                                            RDP_FIELD_MREAD_32((uint8_t *)(p) + 12, 0, 20, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_BN_FPM_WRITE(v, p)                                                           RDP_FIELD_MWRITE_32((uint8_t *)(p) + 12, 0, 20, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_BN_NUM_READ_G(r, g, idx)                                                     GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 12, 7, 7, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_BN_NUM_WRITE_G(v, g, idx)                                                    GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 12, 7, 7, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_BN_NUM_READ_CORE(r, g, idx, core_id)                                         CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 12, 7, 7, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_BN_NUM_WRITE_CORE(v, g, idx, core_id)                                        CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 12, 7, 7, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_BN_NUM_READ(r, p)                                                            RDP_FIELD_MREAD_16((uint8_t *)(p) + 12, 7, 7, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_BN_NUM_WRITE(v, p)                                                           RDP_FIELD_MWRITE_16((uint8_t *)(p) + 12, 7, 7, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SOP_READ_G(r, g, idx)                                                        GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 13, 0, 7, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SOP_WRITE_G(v, g, idx)                                                       GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 13, 0, 7, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SOP_READ_CORE(r, g, idx, core_id)                                            CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 13, 0, 7, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SOP_WRITE_CORE(v, g, idx, core_id)                                           CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 13, 0, 7, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SOP_READ(r, p)                                                               RDP_FIELD_MREAD_8((uint8_t *)(p) + 13, 0, 7, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SOP_WRITE(v, p)                                                              RDP_FIELD_MWRITE_8((uint8_t *)(p) + 13, 0, 7, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_BN0_FIRST_READ_G(r, g, idx)                                                  GROUP_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 14, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_BN0_FIRST_WRITE_G(v, g, idx)                                                 GROUP_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 14, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_BN0_FIRST_READ_CORE(r, g, idx, core_id)                                      CORE_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 14, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_BN0_FIRST_WRITE_CORE(v, g, idx, core_id)                                     CORE_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 14, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_BN0_FIRST_READ(r, p)                                                         MREAD_16((uint8_t *)(p) + 14, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_BN0_FIRST_WRITE(v, p)                                                        MWRITE_16((uint8_t *)(p) + 14, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_ABS0_READ_G(r, g, idx)                                                       GROUP_RDP_FIELD_MREAD_32((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 12, 0, 29, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_ABS0_WRITE_G(v, g, idx)                                                      GROUP_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 12, 0, 29, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_ABS0_READ_CORE(r, g, idx, core_id)                                           CORE_RDP_FIELD_MREAD_32((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 12, 0, 29, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_ABS0_WRITE_CORE(v, g, idx, core_id)                                          CORE_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 12, 0, 29, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_ABS0_READ(r, p)                                                              RDP_FIELD_MREAD_32((uint8_t *)(p) + 12, 0, 29, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_ABS0_WRITE(v, p)                                                             RDP_FIELD_MWRITE_32((uint8_t *)(p) + 12, 0, 29, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FPM_POOL_READ_G(r, g, idx)                                                   GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 13, 2, 2, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FPM_POOL_WRITE_G(v, g, idx)                                                  GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 13, 2, 2, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FPM_POOL_READ_CORE(r, g, idx, core_id)                                       CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 13, 2, 2, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FPM_POOL_WRITE_CORE(v, g, idx, core_id)                                      CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 13, 2, 2, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FPM_POOL_READ(r, p)                                                          RDP_FIELD_MREAD_8((uint8_t *)(p) + 13, 2, 2, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FPM_POOL_WRITE(v, p)                                                         RDP_FIELD_MWRITE_8((uint8_t *)(p) + 13, 2, 2, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FPM_NUM_READ_G(r, g, idx)                                                    GROUP_RDP_FIELD_MREAD_32((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 12, 0, 18, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FPM_NUM_WRITE_G(v, g, idx)                                                   GROUP_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 12, 0, 18, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FPM_NUM_READ_CORE(r, g, idx, core_id)                                        CORE_RDP_FIELD_MREAD_32((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 12, 0, 18, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FPM_NUM_WRITE_CORE(v, g, idx, core_id)                                       CORE_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 12, 0, 18, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FPM_NUM_READ(r, p)                                                           RDP_FIELD_MREAD_32((uint8_t *)(p) + 12, 0, 18, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FPM_NUM_WRITE(v, p)                                                          RDP_FIELD_MWRITE_32((uint8_t *)(p) + 12, 0, 18, (v))
/* <<<PROCESSING_CPU_RX_DESCRIPTOR_STRUCT */


/* >>>CPU_RING_INTERRUPT_COUNTER_ENTRY_STRUCT */
typedef union
    {
    uint8_t word_8[8];
    uint16_t word_16[4];
    uint32_t word_32[2];
    uint64_t dword_64[1];
        struct {
        uint32_t	counter   	;
        uint32_t	max_size  	;
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) CPU_RING_INTERRUPT_COUNTER_ENTRY_STRUCT;

#define RDD_CPU_RING_INTERRUPT_COUNTER_ENTRY_COUNTER_READ_G(r, g, idx)                                 GROUP_MREAD_32((g), (idx)*sizeof(CPU_RING_INTERRUPT_COUNTER_ENTRY_STRUCT), (r))
#define RDD_CPU_RING_INTERRUPT_COUNTER_ENTRY_COUNTER_WRITE_G(v, g, idx)                                GROUP_MWRITE_32((g), (idx)*sizeof(CPU_RING_INTERRUPT_COUNTER_ENTRY_STRUCT), (v))
#define RDD_CPU_RING_INTERRUPT_COUNTER_ENTRY_COUNTER_READ_CORE(r, g, idx, core_id)                     CORE_MREAD_32((g), (idx)*sizeof(CPU_RING_INTERRUPT_COUNTER_ENTRY_STRUCT), (r), core_id)
#define RDD_CPU_RING_INTERRUPT_COUNTER_ENTRY_COUNTER_WRITE_CORE(v, g, idx, core_id)                    CORE_MWRITE_32((g), (idx)*sizeof(CPU_RING_INTERRUPT_COUNTER_ENTRY_STRUCT), (v), core_id)
#define RDD_CPU_RING_INTERRUPT_COUNTER_ENTRY_COUNTER_READ(r, p)                                        MREAD_32((uint8_t *)(p), (r))
#define RDD_CPU_RING_INTERRUPT_COUNTER_ENTRY_COUNTER_WRITE(v, p)                                       MWRITE_32((uint8_t *)(p), (v))
#define RDD_CPU_RING_INTERRUPT_COUNTER_ENTRY_MAX_SIZE_READ_G(r, g, idx)                                GROUP_MREAD_32((g), (idx)*sizeof(CPU_RING_INTERRUPT_COUNTER_ENTRY_STRUCT) + 4, (r))
#define RDD_CPU_RING_INTERRUPT_COUNTER_ENTRY_MAX_SIZE_WRITE_G(v, g, idx)                               GROUP_MWRITE_32((g), (idx)*sizeof(CPU_RING_INTERRUPT_COUNTER_ENTRY_STRUCT) + 4, (v))
#define RDD_CPU_RING_INTERRUPT_COUNTER_ENTRY_MAX_SIZE_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_32((g), (idx)*sizeof(CPU_RING_INTERRUPT_COUNTER_ENTRY_STRUCT) + 4, (r), core_id)
#define RDD_CPU_RING_INTERRUPT_COUNTER_ENTRY_MAX_SIZE_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_32((g), (idx)*sizeof(CPU_RING_INTERRUPT_COUNTER_ENTRY_STRUCT) + 4, (v), core_id)
#define RDD_CPU_RING_INTERRUPT_COUNTER_ENTRY_MAX_SIZE_READ(r, p)                                       MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_CPU_RING_INTERRUPT_COUNTER_ENTRY_MAX_SIZE_WRITE(v, p)                                      MWRITE_32((uint8_t *)(p) + 4, (v))
/* <<<CPU_RING_INTERRUPT_COUNTER_ENTRY_STRUCT */


/* >>>CPU_RX_METER_ENTRY_STRUCT */
typedef union
    {
    uint8_t word_8[8];
    uint16_t word_16[4];
    uint32_t word_32[2];
    uint64_t dword_64[1];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint16_t	current_budget  	;
        uint16_t	budget_limit    	;
        uint16_t	allocated_budget	;
        uint8_t	budget_residue  	;
        uint8_t	current_cycle   	;
#else
        uint16_t	budget_limit    	;
        uint16_t	current_budget  	;
        uint8_t	current_cycle   	;
        uint8_t	budget_residue  	;
        uint16_t	allocated_budget	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) CPU_RX_METER_ENTRY_STRUCT;

#define RDD_CPU_RX_METER_ENTRY_CURRENT_BUDGET_READ_G(r, g, idx)                                  GROUP_MREAD_16((g), (idx)*sizeof(CPU_RX_METER_ENTRY_STRUCT), (r))
#define RDD_CPU_RX_METER_ENTRY_CURRENT_BUDGET_WRITE_G(v, g, idx)                                 GROUP_MWRITE_16((g), (idx)*sizeof(CPU_RX_METER_ENTRY_STRUCT), (v))
#define RDD_CPU_RX_METER_ENTRY_CURRENT_BUDGET_READ_CORE(r, g, idx, core_id)                      CORE_MREAD_16((g), (idx)*sizeof(CPU_RX_METER_ENTRY_STRUCT), (r), core_id)
#define RDD_CPU_RX_METER_ENTRY_CURRENT_BUDGET_WRITE_CORE(v, g, idx, core_id)                     CORE_MWRITE_16((g), (idx)*sizeof(CPU_RX_METER_ENTRY_STRUCT), (v), core_id)
#define RDD_CPU_RX_METER_ENTRY_CURRENT_BUDGET_READ(r, p)                                         MREAD_16((uint8_t *)(p), (r))
#define RDD_CPU_RX_METER_ENTRY_CURRENT_BUDGET_WRITE(v, p)                                        MWRITE_16((uint8_t *)(p), (v))
#define RDD_CPU_RX_METER_ENTRY_BUDGET_LIMIT_READ_G(r, g, idx)                                    GROUP_MREAD_16((g), (idx)*sizeof(CPU_RX_METER_ENTRY_STRUCT) + 2, (r))
#define RDD_CPU_RX_METER_ENTRY_BUDGET_LIMIT_WRITE_G(v, g, idx)                                   GROUP_MWRITE_16((g), (idx)*sizeof(CPU_RX_METER_ENTRY_STRUCT) + 2, (v))
#define RDD_CPU_RX_METER_ENTRY_BUDGET_LIMIT_READ_CORE(r, g, idx, core_id)                        CORE_MREAD_16((g), (idx)*sizeof(CPU_RX_METER_ENTRY_STRUCT) + 2, (r), core_id)
#define RDD_CPU_RX_METER_ENTRY_BUDGET_LIMIT_WRITE_CORE(v, g, idx, core_id)                       CORE_MWRITE_16((g), (idx)*sizeof(CPU_RX_METER_ENTRY_STRUCT) + 2, (v), core_id)
#define RDD_CPU_RX_METER_ENTRY_BUDGET_LIMIT_READ(r, p)                                           MREAD_16((uint8_t *)(p) + 2, (r))
#define RDD_CPU_RX_METER_ENTRY_BUDGET_LIMIT_WRITE(v, p)                                          MWRITE_16((uint8_t *)(p) + 2, (v))
#define RDD_CPU_RX_METER_ENTRY_ALLOCATED_BUDGET_READ_G(r, g, idx)                                GROUP_MREAD_16((g), (idx)*sizeof(CPU_RX_METER_ENTRY_STRUCT) + 4, (r))
#define RDD_CPU_RX_METER_ENTRY_ALLOCATED_BUDGET_WRITE_G(v, g, idx)                               GROUP_MWRITE_16((g), (idx)*sizeof(CPU_RX_METER_ENTRY_STRUCT) + 4, (v))
#define RDD_CPU_RX_METER_ENTRY_ALLOCATED_BUDGET_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_16((g), (idx)*sizeof(CPU_RX_METER_ENTRY_STRUCT) + 4, (r), core_id)
#define RDD_CPU_RX_METER_ENTRY_ALLOCATED_BUDGET_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_16((g), (idx)*sizeof(CPU_RX_METER_ENTRY_STRUCT) + 4, (v), core_id)
#define RDD_CPU_RX_METER_ENTRY_ALLOCATED_BUDGET_READ(r, p)                                       MREAD_16((uint8_t *)(p) + 4, (r))
#define RDD_CPU_RX_METER_ENTRY_ALLOCATED_BUDGET_WRITE(v, p)                                      MWRITE_16((uint8_t *)(p) + 4, (v))
#define RDD_CPU_RX_METER_ENTRY_BUDGET_RESIDUE_READ_G(r, g, idx)                                  GROUP_MREAD_8((g), (idx)*sizeof(CPU_RX_METER_ENTRY_STRUCT) + 6, (r))
#define RDD_CPU_RX_METER_ENTRY_BUDGET_RESIDUE_WRITE_G(v, g, idx)                                 GROUP_MWRITE_8((g), (idx)*sizeof(CPU_RX_METER_ENTRY_STRUCT) + 6, (v))
#define RDD_CPU_RX_METER_ENTRY_BUDGET_RESIDUE_READ_CORE(r, g, idx, core_id)                      CORE_MREAD_8((g), (idx)*sizeof(CPU_RX_METER_ENTRY_STRUCT) + 6, (r), core_id)
#define RDD_CPU_RX_METER_ENTRY_BUDGET_RESIDUE_WRITE_CORE(v, g, idx, core_id)                     CORE_MWRITE_8((g), (idx)*sizeof(CPU_RX_METER_ENTRY_STRUCT) + 6, (v), core_id)
#define RDD_CPU_RX_METER_ENTRY_BUDGET_RESIDUE_READ(r, p)                                         MREAD_8((uint8_t *)(p) + 6, (r))
#define RDD_CPU_RX_METER_ENTRY_BUDGET_RESIDUE_WRITE(v, p)                                        MWRITE_8((uint8_t *)(p) + 6, (v))
#define RDD_CPU_RX_METER_ENTRY_CURRENT_CYCLE_READ_G(r, g, idx)                                   GROUP_MREAD_8((g), (idx)*sizeof(CPU_RX_METER_ENTRY_STRUCT) + 7, (r))
#define RDD_CPU_RX_METER_ENTRY_CURRENT_CYCLE_WRITE_G(v, g, idx)                                  GROUP_MWRITE_8((g), (idx)*sizeof(CPU_RX_METER_ENTRY_STRUCT) + 7, (v))
#define RDD_CPU_RX_METER_ENTRY_CURRENT_CYCLE_READ_CORE(r, g, idx, core_id)                       CORE_MREAD_8((g), (idx)*sizeof(CPU_RX_METER_ENTRY_STRUCT) + 7, (r), core_id)
#define RDD_CPU_RX_METER_ENTRY_CURRENT_CYCLE_WRITE_CORE(v, g, idx, core_id)                      CORE_MWRITE_8((g), (idx)*sizeof(CPU_RX_METER_ENTRY_STRUCT) + 7, (v), core_id)
#define RDD_CPU_RX_METER_ENTRY_CURRENT_CYCLE_READ(r, p)                                          MREAD_8((uint8_t *)(p) + 7, (r))
#define RDD_CPU_RX_METER_ENTRY_CURRENT_CYCLE_WRITE(v, p)                                         MWRITE_8((uint8_t *)(p) + 7, (v))
/* <<<CPU_RX_METER_ENTRY_STRUCT */


/* >>>CPU_REDIRECT_MODE_ENTRY_STRUCT */
typedef union
    {
    uint8_t word_8[1];
        struct {
        uint8_t	mode      	;
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } CPU_REDIRECT_MODE_ENTRY_STRUCT;

#define RDD_CPU_REDIRECT_MODE_ENTRY_MODE_READ_G(r, g, idx)                                GROUP_MREAD_8((g), (idx)*sizeof(CPU_REDIRECT_MODE_ENTRY_STRUCT), (r))
#define RDD_CPU_REDIRECT_MODE_ENTRY_MODE_WRITE_G(v, g, idx)                               GROUP_MWRITE_8((g), (idx)*sizeof(CPU_REDIRECT_MODE_ENTRY_STRUCT), (v))
#define RDD_CPU_REDIRECT_MODE_ENTRY_MODE_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_8((g), (idx)*sizeof(CPU_REDIRECT_MODE_ENTRY_STRUCT), (r), core_id)
#define RDD_CPU_REDIRECT_MODE_ENTRY_MODE_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_8((g), (idx)*sizeof(CPU_REDIRECT_MODE_ENTRY_STRUCT), (v), core_id)
#define RDD_CPU_REDIRECT_MODE_ENTRY_MODE_READ(r, p)                                       MREAD_8((uint8_t *)(p), (r))
#define RDD_CPU_REDIRECT_MODE_ENTRY_MODE_WRITE(v, p)                                      MWRITE_8((uint8_t *)(p), (v))
/* <<<CPU_REDIRECT_MODE_ENTRY_STRUCT */


/* >>>CSO_CONTEXT_ENTRY_STRUCT */
#define RDD_CSO_CONTEXT_ENTRY_PARSER_RESULT_NUMBER	24
typedef union
    {
    uint8_t word_8[176];
    uint16_t word_16[88];
    uint32_t word_32[44];
    uint64_t dword_64[22];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	reserved                                                     	;
        uint16_t	reserved1                                                    	;
        uint16_t	csum_value                                                   	;
        uint16_t	cam_result                                                   	;
        uint16_t	reserved2                                                    	;
        uint32_t	crc_result                                                   	;
        uint32_t	saved_pkt_desc_0                                             	;
        uint32_t	saved_pkt_desc_1                                             	;
        uint32_t	saved_pkt_desc_2                                             	;
        uint32_t	saved_pkt_desc_3                                             	;
        uint32_t	parser_result[RDD_CSO_CONTEXT_ENTRY_PARSER_RESULT_NUMBER];
        uint32_t	saved_ret_address                                            	;
        uint32_t	good_csum_packets                                            	;
        uint32_t	no_cso_support_packets                                       	;
        uint32_t	forward_cso_packets                                          	;
        uint32_t	forward_cso_ver_error                                        	;
        uint32_t	bad_ipv4_hdr_csum_packets                                    	;
        uint32_t	bad_tcp_udp_csum_packets                                     	;
        uint32_t	invalid_offload_result                                       	;
        uint32_t	offload_req_id_mismatch                                      	;
        uint32_t	wakeup_reenable                                              	;
        uint16_t	saved_buffer_number                                          	;
        uint16_t	saved_packet_length                                          	;
        uint32_t	offload_req_id                                               	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved3                                                    	:25	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#else
        uint32_t	reserved                                                     	;
        uint16_t	csum_value                                                   	;
        uint16_t	reserved1                                                    	;
        uint16_t	reserved2                                                    	;
        uint16_t	cam_result                                                   	;
        uint32_t	crc_result                                                   	;
        uint32_t	saved_pkt_desc_0                                             	;
        uint32_t	saved_pkt_desc_1                                             	;
        uint32_t	saved_pkt_desc_2                                             	;
        uint32_t	saved_pkt_desc_3                                             	;
        uint32_t	parser_result[RDD_CSO_CONTEXT_ENTRY_PARSER_RESULT_NUMBER];
        uint32_t	saved_ret_address                                            	;
        uint32_t	good_csum_packets                                            	;
        uint32_t	no_cso_support_packets                                       	;
        uint32_t	forward_cso_packets                                          	;
        uint32_t	forward_cso_ver_error                                        	;
        uint32_t	bad_ipv4_hdr_csum_packets                                    	;
        uint32_t	bad_tcp_udp_csum_packets                                     	;
        uint32_t	invalid_offload_result                                       	;
        uint32_t	offload_req_id_mismatch                                      	;
        uint32_t	wakeup_reenable                                              	;
        uint16_t	saved_packet_length                                          	;
        uint16_t	saved_buffer_number                                          	;
        uint32_t	reserved3                                                    	:25	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	offload_req_id                                               	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) CSO_CONTEXT_ENTRY_STRUCT;

#define RDD_CSO_CONTEXT_ENTRY_CSUM_VALUE_READ_G(r, g, idx)                                               GROUP_MREAD_16((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 6, (r))
#define RDD_CSO_CONTEXT_ENTRY_CSUM_VALUE_WRITE_G(v, g, idx)                                              GROUP_MWRITE_16((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 6, (v))
#define RDD_CSO_CONTEXT_ENTRY_CSUM_VALUE_READ_CORE(r, g, idx, core_id)                                   CORE_MREAD_16((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 6, (r), core_id)
#define RDD_CSO_CONTEXT_ENTRY_CSUM_VALUE_WRITE_CORE(v, g, idx, core_id)                                  CORE_MWRITE_16((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 6, (v), core_id)
#define RDD_CSO_CONTEXT_ENTRY_CSUM_VALUE_READ(r, p)                                                      MREAD_16((uint8_t *)(p) + 6, (r))
#define RDD_CSO_CONTEXT_ENTRY_CSUM_VALUE_WRITE(v, p)                                                     MWRITE_16((uint8_t *)(p) + 6, (v))
#define RDD_CSO_CONTEXT_ENTRY_CAM_RESULT_READ_G(r, g, idx)                                               GROUP_MREAD_16((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 8, (r))
#define RDD_CSO_CONTEXT_ENTRY_CAM_RESULT_WRITE_G(v, g, idx)                                              GROUP_MWRITE_16((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 8, (v))
#define RDD_CSO_CONTEXT_ENTRY_CAM_RESULT_READ_CORE(r, g, idx, core_id)                                   CORE_MREAD_16((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 8, (r), core_id)
#define RDD_CSO_CONTEXT_ENTRY_CAM_RESULT_WRITE_CORE(v, g, idx, core_id)                                  CORE_MWRITE_16((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 8, (v), core_id)
#define RDD_CSO_CONTEXT_ENTRY_CAM_RESULT_READ(r, p)                                                      MREAD_16((uint8_t *)(p) + 8, (r))
#define RDD_CSO_CONTEXT_ENTRY_CAM_RESULT_WRITE(v, p)                                                     MWRITE_16((uint8_t *)(p) + 8, (v))
#define RDD_CSO_CONTEXT_ENTRY_CRC_RESULT_READ_G(r, g, idx)                                               GROUP_MREAD_32((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 12, (r))
#define RDD_CSO_CONTEXT_ENTRY_CRC_RESULT_WRITE_G(v, g, idx)                                              GROUP_MWRITE_32((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 12, (v))
#define RDD_CSO_CONTEXT_ENTRY_CRC_RESULT_READ_CORE(r, g, idx, core_id)                                   CORE_MREAD_32((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 12, (r), core_id)
#define RDD_CSO_CONTEXT_ENTRY_CRC_RESULT_WRITE_CORE(v, g, idx, core_id)                                  CORE_MWRITE_32((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 12, (v), core_id)
#define RDD_CSO_CONTEXT_ENTRY_CRC_RESULT_READ(r, p)                                                      MREAD_32((uint8_t *)(p) + 12, (r))
#define RDD_CSO_CONTEXT_ENTRY_CRC_RESULT_WRITE(v, p)                                                     MWRITE_32((uint8_t *)(p) + 12, (v))
#define RDD_CSO_CONTEXT_ENTRY_SAVED_PKT_DESC_0_READ_G(r, g, idx)                                         GROUP_MREAD_32((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 16, (r))
#define RDD_CSO_CONTEXT_ENTRY_SAVED_PKT_DESC_0_WRITE_G(v, g, idx)                                        GROUP_MWRITE_32((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 16, (v))
#define RDD_CSO_CONTEXT_ENTRY_SAVED_PKT_DESC_0_READ_CORE(r, g, idx, core_id)                             CORE_MREAD_32((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 16, (r), core_id)
#define RDD_CSO_CONTEXT_ENTRY_SAVED_PKT_DESC_0_WRITE_CORE(v, g, idx, core_id)                            CORE_MWRITE_32((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 16, (v), core_id)
#define RDD_CSO_CONTEXT_ENTRY_SAVED_PKT_DESC_0_READ(r, p)                                                MREAD_32((uint8_t *)(p) + 16, (r))
#define RDD_CSO_CONTEXT_ENTRY_SAVED_PKT_DESC_0_WRITE(v, p)                                               MWRITE_32((uint8_t *)(p) + 16, (v))
#define RDD_CSO_CONTEXT_ENTRY_SAVED_PKT_DESC_1_READ_G(r, g, idx)                                         GROUP_MREAD_32((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 20, (r))
#define RDD_CSO_CONTEXT_ENTRY_SAVED_PKT_DESC_1_WRITE_G(v, g, idx)                                        GROUP_MWRITE_32((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 20, (v))
#define RDD_CSO_CONTEXT_ENTRY_SAVED_PKT_DESC_1_READ_CORE(r, g, idx, core_id)                             CORE_MREAD_32((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 20, (r), core_id)
#define RDD_CSO_CONTEXT_ENTRY_SAVED_PKT_DESC_1_WRITE_CORE(v, g, idx, core_id)                            CORE_MWRITE_32((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 20, (v), core_id)
#define RDD_CSO_CONTEXT_ENTRY_SAVED_PKT_DESC_1_READ(r, p)                                                MREAD_32((uint8_t *)(p) + 20, (r))
#define RDD_CSO_CONTEXT_ENTRY_SAVED_PKT_DESC_1_WRITE(v, p)                                               MWRITE_32((uint8_t *)(p) + 20, (v))
#define RDD_CSO_CONTEXT_ENTRY_SAVED_PKT_DESC_2_READ_G(r, g, idx)                                         GROUP_MREAD_32((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 24, (r))
#define RDD_CSO_CONTEXT_ENTRY_SAVED_PKT_DESC_2_WRITE_G(v, g, idx)                                        GROUP_MWRITE_32((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 24, (v))
#define RDD_CSO_CONTEXT_ENTRY_SAVED_PKT_DESC_2_READ_CORE(r, g, idx, core_id)                             CORE_MREAD_32((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 24, (r), core_id)
#define RDD_CSO_CONTEXT_ENTRY_SAVED_PKT_DESC_2_WRITE_CORE(v, g, idx, core_id)                            CORE_MWRITE_32((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 24, (v), core_id)
#define RDD_CSO_CONTEXT_ENTRY_SAVED_PKT_DESC_2_READ(r, p)                                                MREAD_32((uint8_t *)(p) + 24, (r))
#define RDD_CSO_CONTEXT_ENTRY_SAVED_PKT_DESC_2_WRITE(v, p)                                               MWRITE_32((uint8_t *)(p) + 24, (v))
#define RDD_CSO_CONTEXT_ENTRY_SAVED_PKT_DESC_3_READ_G(r, g, idx)                                         GROUP_MREAD_32((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 28, (r))
#define RDD_CSO_CONTEXT_ENTRY_SAVED_PKT_DESC_3_WRITE_G(v, g, idx)                                        GROUP_MWRITE_32((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 28, (v))
#define RDD_CSO_CONTEXT_ENTRY_SAVED_PKT_DESC_3_READ_CORE(r, g, idx, core_id)                             CORE_MREAD_32((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 28, (r), core_id)
#define RDD_CSO_CONTEXT_ENTRY_SAVED_PKT_DESC_3_WRITE_CORE(v, g, idx, core_id)                            CORE_MWRITE_32((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 28, (v), core_id)
#define RDD_CSO_CONTEXT_ENTRY_SAVED_PKT_DESC_3_READ(r, p)                                                MREAD_32((uint8_t *)(p) + 28, (r))
#define RDD_CSO_CONTEXT_ENTRY_SAVED_PKT_DESC_3_WRITE(v, p)                                               MWRITE_32((uint8_t *)(p) + 28, (v))
#define RDD_CSO_CONTEXT_ENTRY_PARSER_RESULT_READ_G(r, g, idx, i)                                         GROUP_MREAD_I_32((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 32, i, (r))
#define RDD_CSO_CONTEXT_ENTRY_PARSER_RESULT_WRITE_G(v, g, idx, i)                                        GROUP_MWRITE_I_32((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 32, i, (v))
#define RDD_CSO_CONTEXT_ENTRY_PARSER_RESULT_READ_CORE(r, g, idx, i, core_id)                             CORE_MREAD_I_32((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 32, i, (r), core_id)
#define RDD_CSO_CONTEXT_ENTRY_PARSER_RESULT_WRITE_CORE(v, g, idx, i, core_id)                            CORE_MWRITE_I_32((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 32, i, (v), core_id)
#define RDD_CSO_CONTEXT_ENTRY_PARSER_RESULT_READ(r, p, i)                                                MREAD_I_32((uint8_t *)(p) + 32, i, (r))
#define RDD_CSO_CONTEXT_ENTRY_PARSER_RESULT_WRITE(v, p, i)                                               MWRITE_I_32((uint8_t *)(p) + 32, i, (v))
#define RDD_CSO_CONTEXT_ENTRY_SAVED_RET_ADDRESS_READ_G(r, g, idx)                                        GROUP_MREAD_32((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 128, (r))
#define RDD_CSO_CONTEXT_ENTRY_SAVED_RET_ADDRESS_WRITE_G(v, g, idx)                                       GROUP_MWRITE_32((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 128, (v))
#define RDD_CSO_CONTEXT_ENTRY_SAVED_RET_ADDRESS_READ_CORE(r, g, idx, core_id)                            CORE_MREAD_32((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 128, (r), core_id)
#define RDD_CSO_CONTEXT_ENTRY_SAVED_RET_ADDRESS_WRITE_CORE(v, g, idx, core_id)                           CORE_MWRITE_32((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 128, (v), core_id)
#define RDD_CSO_CONTEXT_ENTRY_SAVED_RET_ADDRESS_READ(r, p)                                               MREAD_32((uint8_t *)(p) + 128, (r))
#define RDD_CSO_CONTEXT_ENTRY_SAVED_RET_ADDRESS_WRITE(v, p)                                              MWRITE_32((uint8_t *)(p) + 128, (v))
#define RDD_CSO_CONTEXT_ENTRY_GOOD_CSUM_PACKETS_READ_G(r, g, idx)                                        GROUP_MREAD_32((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 132, (r))
#define RDD_CSO_CONTEXT_ENTRY_GOOD_CSUM_PACKETS_WRITE_G(v, g, idx)                                       GROUP_MWRITE_32((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 132, (v))
#define RDD_CSO_CONTEXT_ENTRY_GOOD_CSUM_PACKETS_READ_CORE(r, g, idx, core_id)                            CORE_MREAD_32((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 132, (r), core_id)
#define RDD_CSO_CONTEXT_ENTRY_GOOD_CSUM_PACKETS_WRITE_CORE(v, g, idx, core_id)                           CORE_MWRITE_32((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 132, (v), core_id)
#define RDD_CSO_CONTEXT_ENTRY_GOOD_CSUM_PACKETS_READ(r, p)                                               MREAD_32((uint8_t *)(p) + 132, (r))
#define RDD_CSO_CONTEXT_ENTRY_GOOD_CSUM_PACKETS_WRITE(v, p)                                              MWRITE_32((uint8_t *)(p) + 132, (v))
#define RDD_CSO_CONTEXT_ENTRY_NO_CSO_SUPPORT_PACKETS_READ_G(r, g, idx)                                   GROUP_MREAD_32((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 136, (r))
#define RDD_CSO_CONTEXT_ENTRY_NO_CSO_SUPPORT_PACKETS_WRITE_G(v, g, idx)                                  GROUP_MWRITE_32((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 136, (v))
#define RDD_CSO_CONTEXT_ENTRY_NO_CSO_SUPPORT_PACKETS_READ_CORE(r, g, idx, core_id)                       CORE_MREAD_32((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 136, (r), core_id)
#define RDD_CSO_CONTEXT_ENTRY_NO_CSO_SUPPORT_PACKETS_WRITE_CORE(v, g, idx, core_id)                      CORE_MWRITE_32((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 136, (v), core_id)
#define RDD_CSO_CONTEXT_ENTRY_NO_CSO_SUPPORT_PACKETS_READ(r, p)                                          MREAD_32((uint8_t *)(p) + 136, (r))
#define RDD_CSO_CONTEXT_ENTRY_NO_CSO_SUPPORT_PACKETS_WRITE(v, p)                                         MWRITE_32((uint8_t *)(p) + 136, (v))
#define RDD_CSO_CONTEXT_ENTRY_FORWARD_CSO_PACKETS_READ_G(r, g, idx)                                      GROUP_MREAD_32((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 140, (r))
#define RDD_CSO_CONTEXT_ENTRY_FORWARD_CSO_PACKETS_WRITE_G(v, g, idx)                                     GROUP_MWRITE_32((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 140, (v))
#define RDD_CSO_CONTEXT_ENTRY_FORWARD_CSO_PACKETS_READ_CORE(r, g, idx, core_id)                          CORE_MREAD_32((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 140, (r), core_id)
#define RDD_CSO_CONTEXT_ENTRY_FORWARD_CSO_PACKETS_WRITE_CORE(v, g, idx, core_id)                         CORE_MWRITE_32((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 140, (v), core_id)
#define RDD_CSO_CONTEXT_ENTRY_FORWARD_CSO_PACKETS_READ(r, p)                                             MREAD_32((uint8_t *)(p) + 140, (r))
#define RDD_CSO_CONTEXT_ENTRY_FORWARD_CSO_PACKETS_WRITE(v, p)                                            MWRITE_32((uint8_t *)(p) + 140, (v))
#define RDD_CSO_CONTEXT_ENTRY_FORWARD_CSO_VER_ERROR_READ_G(r, g, idx)                                    GROUP_MREAD_32((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 144, (r))
#define RDD_CSO_CONTEXT_ENTRY_FORWARD_CSO_VER_ERROR_WRITE_G(v, g, idx)                                   GROUP_MWRITE_32((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 144, (v))
#define RDD_CSO_CONTEXT_ENTRY_FORWARD_CSO_VER_ERROR_READ_CORE(r, g, idx, core_id)                        CORE_MREAD_32((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 144, (r), core_id)
#define RDD_CSO_CONTEXT_ENTRY_FORWARD_CSO_VER_ERROR_WRITE_CORE(v, g, idx, core_id)                       CORE_MWRITE_32((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 144, (v), core_id)
#define RDD_CSO_CONTEXT_ENTRY_FORWARD_CSO_VER_ERROR_READ(r, p)                                           MREAD_32((uint8_t *)(p) + 144, (r))
#define RDD_CSO_CONTEXT_ENTRY_FORWARD_CSO_VER_ERROR_WRITE(v, p)                                          MWRITE_32((uint8_t *)(p) + 144, (v))
#define RDD_CSO_CONTEXT_ENTRY_BAD_IPV4_HDR_CSUM_PACKETS_READ_G(r, g, idx)                                GROUP_MREAD_32((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 148, (r))
#define RDD_CSO_CONTEXT_ENTRY_BAD_IPV4_HDR_CSUM_PACKETS_WRITE_G(v, g, idx)                               GROUP_MWRITE_32((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 148, (v))
#define RDD_CSO_CONTEXT_ENTRY_BAD_IPV4_HDR_CSUM_PACKETS_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_32((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 148, (r), core_id)
#define RDD_CSO_CONTEXT_ENTRY_BAD_IPV4_HDR_CSUM_PACKETS_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_32((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 148, (v), core_id)
#define RDD_CSO_CONTEXT_ENTRY_BAD_IPV4_HDR_CSUM_PACKETS_READ(r, p)                                       MREAD_32((uint8_t *)(p) + 148, (r))
#define RDD_CSO_CONTEXT_ENTRY_BAD_IPV4_HDR_CSUM_PACKETS_WRITE(v, p)                                      MWRITE_32((uint8_t *)(p) + 148, (v))
#define RDD_CSO_CONTEXT_ENTRY_BAD_TCP_UDP_CSUM_PACKETS_READ_G(r, g, idx)                                 GROUP_MREAD_32((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 152, (r))
#define RDD_CSO_CONTEXT_ENTRY_BAD_TCP_UDP_CSUM_PACKETS_WRITE_G(v, g, idx)                                GROUP_MWRITE_32((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 152, (v))
#define RDD_CSO_CONTEXT_ENTRY_BAD_TCP_UDP_CSUM_PACKETS_READ_CORE(r, g, idx, core_id)                     CORE_MREAD_32((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 152, (r), core_id)
#define RDD_CSO_CONTEXT_ENTRY_BAD_TCP_UDP_CSUM_PACKETS_WRITE_CORE(v, g, idx, core_id)                    CORE_MWRITE_32((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 152, (v), core_id)
#define RDD_CSO_CONTEXT_ENTRY_BAD_TCP_UDP_CSUM_PACKETS_READ(r, p)                                        MREAD_32((uint8_t *)(p) + 152, (r))
#define RDD_CSO_CONTEXT_ENTRY_BAD_TCP_UDP_CSUM_PACKETS_WRITE(v, p)                                       MWRITE_32((uint8_t *)(p) + 152, (v))
#define RDD_CSO_CONTEXT_ENTRY_INVALID_OFFLOAD_RESULT_READ_G(r, g, idx)                                   GROUP_MREAD_32((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 156, (r))
#define RDD_CSO_CONTEXT_ENTRY_INVALID_OFFLOAD_RESULT_WRITE_G(v, g, idx)                                  GROUP_MWRITE_32((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 156, (v))
#define RDD_CSO_CONTEXT_ENTRY_INVALID_OFFLOAD_RESULT_READ_CORE(r, g, idx, core_id)                       CORE_MREAD_32((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 156, (r), core_id)
#define RDD_CSO_CONTEXT_ENTRY_INVALID_OFFLOAD_RESULT_WRITE_CORE(v, g, idx, core_id)                      CORE_MWRITE_32((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 156, (v), core_id)
#define RDD_CSO_CONTEXT_ENTRY_INVALID_OFFLOAD_RESULT_READ(r, p)                                          MREAD_32((uint8_t *)(p) + 156, (r))
#define RDD_CSO_CONTEXT_ENTRY_INVALID_OFFLOAD_RESULT_WRITE(v, p)                                         MWRITE_32((uint8_t *)(p) + 156, (v))
#define RDD_CSO_CONTEXT_ENTRY_OFFLOAD_REQ_ID_MISMATCH_READ_G(r, g, idx)                                  GROUP_MREAD_32((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 160, (r))
#define RDD_CSO_CONTEXT_ENTRY_OFFLOAD_REQ_ID_MISMATCH_WRITE_G(v, g, idx)                                 GROUP_MWRITE_32((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 160, (v))
#define RDD_CSO_CONTEXT_ENTRY_OFFLOAD_REQ_ID_MISMATCH_READ_CORE(r, g, idx, core_id)                      CORE_MREAD_32((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 160, (r), core_id)
#define RDD_CSO_CONTEXT_ENTRY_OFFLOAD_REQ_ID_MISMATCH_WRITE_CORE(v, g, idx, core_id)                     CORE_MWRITE_32((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 160, (v), core_id)
#define RDD_CSO_CONTEXT_ENTRY_OFFLOAD_REQ_ID_MISMATCH_READ(r, p)                                         MREAD_32((uint8_t *)(p) + 160, (r))
#define RDD_CSO_CONTEXT_ENTRY_OFFLOAD_REQ_ID_MISMATCH_WRITE(v, p)                                        MWRITE_32((uint8_t *)(p) + 160, (v))
#define RDD_CSO_CONTEXT_ENTRY_WAKEUP_REENABLE_READ_G(r, g, idx)                                          GROUP_MREAD_32((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 164, (r))
#define RDD_CSO_CONTEXT_ENTRY_WAKEUP_REENABLE_WRITE_G(v, g, idx)                                         GROUP_MWRITE_32((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 164, (v))
#define RDD_CSO_CONTEXT_ENTRY_WAKEUP_REENABLE_READ_CORE(r, g, idx, core_id)                              CORE_MREAD_32((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 164, (r), core_id)
#define RDD_CSO_CONTEXT_ENTRY_WAKEUP_REENABLE_WRITE_CORE(v, g, idx, core_id)                             CORE_MWRITE_32((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 164, (v), core_id)
#define RDD_CSO_CONTEXT_ENTRY_WAKEUP_REENABLE_READ(r, p)                                                 MREAD_32((uint8_t *)(p) + 164, (r))
#define RDD_CSO_CONTEXT_ENTRY_WAKEUP_REENABLE_WRITE(v, p)                                                MWRITE_32((uint8_t *)(p) + 164, (v))
#define RDD_CSO_CONTEXT_ENTRY_SAVED_BUFFER_NUMBER_READ_G(r, g, idx)                                      GROUP_MREAD_16((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 168, (r))
#define RDD_CSO_CONTEXT_ENTRY_SAVED_BUFFER_NUMBER_WRITE_G(v, g, idx)                                     GROUP_MWRITE_16((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 168, (v))
#define RDD_CSO_CONTEXT_ENTRY_SAVED_BUFFER_NUMBER_READ_CORE(r, g, idx, core_id)                          CORE_MREAD_16((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 168, (r), core_id)
#define RDD_CSO_CONTEXT_ENTRY_SAVED_BUFFER_NUMBER_WRITE_CORE(v, g, idx, core_id)                         CORE_MWRITE_16((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 168, (v), core_id)
#define RDD_CSO_CONTEXT_ENTRY_SAVED_BUFFER_NUMBER_READ(r, p)                                             MREAD_16((uint8_t *)(p) + 168, (r))
#define RDD_CSO_CONTEXT_ENTRY_SAVED_BUFFER_NUMBER_WRITE(v, p)                                            MWRITE_16((uint8_t *)(p) + 168, (v))
#define RDD_CSO_CONTEXT_ENTRY_SAVED_PACKET_LENGTH_READ_G(r, g, idx)                                      GROUP_MREAD_16((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 170, (r))
#define RDD_CSO_CONTEXT_ENTRY_SAVED_PACKET_LENGTH_WRITE_G(v, g, idx)                                     GROUP_MWRITE_16((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 170, (v))
#define RDD_CSO_CONTEXT_ENTRY_SAVED_PACKET_LENGTH_READ_CORE(r, g, idx, core_id)                          CORE_MREAD_16((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 170, (r), core_id)
#define RDD_CSO_CONTEXT_ENTRY_SAVED_PACKET_LENGTH_WRITE_CORE(v, g, idx, core_id)                         CORE_MWRITE_16((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 170, (v), core_id)
#define RDD_CSO_CONTEXT_ENTRY_SAVED_PACKET_LENGTH_READ(r, p)                                             MREAD_16((uint8_t *)(p) + 170, (r))
#define RDD_CSO_CONTEXT_ENTRY_SAVED_PACKET_LENGTH_WRITE(v, p)                                            MWRITE_16((uint8_t *)(p) + 170, (v))
#define RDD_CSO_CONTEXT_ENTRY_OFFLOAD_REQ_ID_READ_G(r, g, idx)                                           GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 172, 1, 7, (r))
#define RDD_CSO_CONTEXT_ENTRY_OFFLOAD_REQ_ID_WRITE_G(v, g, idx)                                          GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 172, 1, 7, (v))
#define RDD_CSO_CONTEXT_ENTRY_OFFLOAD_REQ_ID_READ_CORE(r, g, idx, core_id)                               CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 172, 1, 7, (r), core_id)
#define RDD_CSO_CONTEXT_ENTRY_OFFLOAD_REQ_ID_WRITE_CORE(v, g, idx, core_id)                              CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 172, 1, 7, (v), core_id)
#define RDD_CSO_CONTEXT_ENTRY_OFFLOAD_REQ_ID_READ(r, p)                                                  RDP_FIELD_MREAD_8((uint8_t *)(p) + 172, 1, 7, (r))
#define RDD_CSO_CONTEXT_ENTRY_OFFLOAD_REQ_ID_WRITE(v, p)                                                 RDP_FIELD_MWRITE_8((uint8_t *)(p) + 172, 1, 7, (v))
/* <<<CSO_CONTEXT_ENTRY_STRUCT */


/* >>>PREPEND_CSO_INFO_ENTRY_STRUCT */
typedef union
    {
    uint8_t word_8[4];
    uint16_t word_16[2];
    uint32_t word_32[1];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	dword_sz       	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved       	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	tx_l4_offset   	;
        uint16_t	pseudo_hdr_csum	;
#else
        uint16_t	pseudo_hdr_csum	;
        uint8_t	tx_l4_offset   	;
        uint32_t	reserved       	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	dword_sz       	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(4))) PREPEND_CSO_INFO_ENTRY_STRUCT;

#define RDD_PREPEND_CSO_INFO_ENTRY_DWORD_SZ_READ_G(r, g, idx)                                       GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PREPEND_CSO_INFO_ENTRY_STRUCT), 4, 4, (r))
#define RDD_PREPEND_CSO_INFO_ENTRY_DWORD_SZ_WRITE_G(v, g, idx)                                      GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PREPEND_CSO_INFO_ENTRY_STRUCT), 4, 4, (v))
#define RDD_PREPEND_CSO_INFO_ENTRY_DWORD_SZ_READ_CORE(r, g, idx, core_id)                           CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PREPEND_CSO_INFO_ENTRY_STRUCT), 4, 4, (r), core_id)
#define RDD_PREPEND_CSO_INFO_ENTRY_DWORD_SZ_WRITE_CORE(v, g, idx, core_id)                          CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PREPEND_CSO_INFO_ENTRY_STRUCT), 4, 4, (v), core_id)
#define RDD_PREPEND_CSO_INFO_ENTRY_DWORD_SZ_READ(r, p)                                              RDP_FIELD_MREAD_8((uint8_t *)(p), 4, 4, (r))
#define RDD_PREPEND_CSO_INFO_ENTRY_DWORD_SZ_WRITE(v, p)                                             RDP_FIELD_MWRITE_8((uint8_t *)(p), 4, 4, (v))
#define RDD_PREPEND_CSO_INFO_ENTRY_TX_L4_OFFSET_READ_G(r, g, idx)                                   GROUP_MREAD_8((g), (idx)*sizeof(PREPEND_CSO_INFO_ENTRY_STRUCT) + 1, (r))
#define RDD_PREPEND_CSO_INFO_ENTRY_TX_L4_OFFSET_WRITE_G(v, g, idx)                                  GROUP_MWRITE_8((g), (idx)*sizeof(PREPEND_CSO_INFO_ENTRY_STRUCT) + 1, (v))
#define RDD_PREPEND_CSO_INFO_ENTRY_TX_L4_OFFSET_READ_CORE(r, g, idx, core_id)                       CORE_MREAD_8((g), (idx)*sizeof(PREPEND_CSO_INFO_ENTRY_STRUCT) + 1, (r), core_id)
#define RDD_PREPEND_CSO_INFO_ENTRY_TX_L4_OFFSET_WRITE_CORE(v, g, idx, core_id)                      CORE_MWRITE_8((g), (idx)*sizeof(PREPEND_CSO_INFO_ENTRY_STRUCT) + 1, (v), core_id)
#define RDD_PREPEND_CSO_INFO_ENTRY_TX_L4_OFFSET_READ(r, p)                                          MREAD_8((uint8_t *)(p) + 1, (r))
#define RDD_PREPEND_CSO_INFO_ENTRY_TX_L4_OFFSET_WRITE(v, p)                                         MWRITE_8((uint8_t *)(p) + 1, (v))
#define RDD_PREPEND_CSO_INFO_ENTRY_PSEUDO_HDR_CSUM_READ_G(r, g, idx)                                GROUP_MREAD_16((g), (idx)*sizeof(PREPEND_CSO_INFO_ENTRY_STRUCT) + 2, (r))
#define RDD_PREPEND_CSO_INFO_ENTRY_PSEUDO_HDR_CSUM_WRITE_G(v, g, idx)                               GROUP_MWRITE_16((g), (idx)*sizeof(PREPEND_CSO_INFO_ENTRY_STRUCT) + 2, (v))
#define RDD_PREPEND_CSO_INFO_ENTRY_PSEUDO_HDR_CSUM_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_16((g), (idx)*sizeof(PREPEND_CSO_INFO_ENTRY_STRUCT) + 2, (r), core_id)
#define RDD_PREPEND_CSO_INFO_ENTRY_PSEUDO_HDR_CSUM_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_16((g), (idx)*sizeof(PREPEND_CSO_INFO_ENTRY_STRUCT) + 2, (v), core_id)
#define RDD_PREPEND_CSO_INFO_ENTRY_PSEUDO_HDR_CSUM_READ(r, p)                                       MREAD_16((uint8_t *)(p) + 2, (r))
#define RDD_PREPEND_CSO_INFO_ENTRY_PSEUDO_HDR_CSUM_WRITE(v, p)                                      MWRITE_16((uint8_t *)(p) + 2, (v))
/* <<<PREPEND_CSO_INFO_ENTRY_STRUCT */


/* >>>SPDSVC_RX_TS_STAT_STRUCT */
typedef union
    {
    uint8_t word_8[12];
    uint16_t word_16[6];
    uint32_t word_32[3];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	ts_first    	;
        uint32_t	ts_last     	;
        uint32_t	reserved    	:31	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ts_first_set	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#else
        uint32_t	ts_first    	;
        uint32_t	ts_last     	;
        uint32_t	ts_first_set	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved    	:31	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(4))) SPDSVC_RX_TS_STAT_STRUCT;

#define RDD_SPDSVC_RX_TS_STAT_TS_FIRST_READ_G(r, g, idx)                                    GROUP_MREAD_32((g), (idx)*sizeof(SPDSVC_RX_TS_STAT_STRUCT), (r))
#define RDD_SPDSVC_RX_TS_STAT_TS_FIRST_WRITE_G(v, g, idx)                                   GROUP_MWRITE_32((g), (idx)*sizeof(SPDSVC_RX_TS_STAT_STRUCT), (v))
#define RDD_SPDSVC_RX_TS_STAT_TS_FIRST_READ_CORE(r, g, idx, core_id)                        CORE_MREAD_32((g), (idx)*sizeof(SPDSVC_RX_TS_STAT_STRUCT), (r), core_id)
#define RDD_SPDSVC_RX_TS_STAT_TS_FIRST_WRITE_CORE(v, g, idx, core_id)                       CORE_MWRITE_32((g), (idx)*sizeof(SPDSVC_RX_TS_STAT_STRUCT), (v), core_id)
#define RDD_SPDSVC_RX_TS_STAT_TS_FIRST_READ(r, p)                                           MREAD_32((uint8_t *)(p), (r))
#define RDD_SPDSVC_RX_TS_STAT_TS_FIRST_WRITE(v, p)                                          MWRITE_32((uint8_t *)(p), (v))
#define RDD_SPDSVC_RX_TS_STAT_TS_LAST_READ_G(r, g, idx)                                     GROUP_MREAD_32((g), (idx)*sizeof(SPDSVC_RX_TS_STAT_STRUCT) + 4, (r))
#define RDD_SPDSVC_RX_TS_STAT_TS_LAST_WRITE_G(v, g, idx)                                    GROUP_MWRITE_32((g), (idx)*sizeof(SPDSVC_RX_TS_STAT_STRUCT) + 4, (v))
#define RDD_SPDSVC_RX_TS_STAT_TS_LAST_READ_CORE(r, g, idx, core_id)                         CORE_MREAD_32((g), (idx)*sizeof(SPDSVC_RX_TS_STAT_STRUCT) + 4, (r), core_id)
#define RDD_SPDSVC_RX_TS_STAT_TS_LAST_WRITE_CORE(v, g, idx, core_id)                        CORE_MWRITE_32((g), (idx)*sizeof(SPDSVC_RX_TS_STAT_STRUCT) + 4, (v), core_id)
#define RDD_SPDSVC_RX_TS_STAT_TS_LAST_READ(r, p)                                            MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_SPDSVC_RX_TS_STAT_TS_LAST_WRITE(v, p)                                           MWRITE_32((uint8_t *)(p) + 4, (v))
#define RDD_SPDSVC_RX_TS_STAT_TS_FIRST_SET_READ_G(r, g, idx)                                GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(SPDSVC_RX_TS_STAT_STRUCT) + 11, 0, 1, (r))
#define RDD_SPDSVC_RX_TS_STAT_TS_FIRST_SET_WRITE_G(v, g, idx)                               GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(SPDSVC_RX_TS_STAT_STRUCT) + 11, 0, 1, (v))
#define RDD_SPDSVC_RX_TS_STAT_TS_FIRST_SET_READ_CORE(r, g, idx, core_id)                    CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(SPDSVC_RX_TS_STAT_STRUCT) + 11, 0, 1, (r), core_id)
#define RDD_SPDSVC_RX_TS_STAT_TS_FIRST_SET_WRITE_CORE(v, g, idx, core_id)                   CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(SPDSVC_RX_TS_STAT_STRUCT) + 11, 0, 1, (v), core_id)
#define RDD_SPDSVC_RX_TS_STAT_TS_FIRST_SET_READ(r, p)                                       RDP_FIELD_MREAD_8((uint8_t *)(p) + 11, 0, 1, (r))
#define RDD_SPDSVC_RX_TS_STAT_TS_FIRST_SET_WRITE(v, p)                                      RDP_FIELD_MWRITE_8((uint8_t *)(p) + 11, 0, 1, (v))
/* <<<SPDSVC_RX_TS_STAT_STRUCT */


/* >>>RING_CPU_TX_DESCRIPTOR_STRUCT */
typedef union
    {
    uint8_t word_8[16];
    uint16_t word_16[8];
    uint32_t word_32[4];
    uint64_t dword_64[2];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
	/* Union WORD 0 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	is_egress           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	egress_or_ingress_1 	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	packet_length       	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	sk_buf_ptr_high     	;
		};
		/* Sub Union 1 */
		struct{
        uint32_t	reservedSU1_is_egress         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	first_level_q                 	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of egress_or_ingress_1 union */
        uint32_t	reservedSU1_packet_length     	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	reservedSU1_sk_buf_ptr_high   	;
		};
		/* Sub Union 2 */
		struct{
        uint32_t	reservedSU2_is_egress         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	gdx_pd_data_8_0               	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of egress_or_ingress_1 union */
        uint32_t	reservedSU2_packet_length     	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	reservedSU2_sk_buf_ptr_high   	;
		};
		/* Sub Union 3 */
		struct{
        uint32_t	reservedSU3_is_egress         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	wlan_tid                      	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of egress_or_ingress_1 union */
        uint32_t	reserved3                     	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of egress_or_ingress_1 union */
        uint32_t	reservedSU3_packet_length     	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	reservedSU3_sk_buf_ptr_high   	;
		};
		/* Sub Union 4 */
		struct{
        uint32_t	reservedSU4_is_egress         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	dhd_sq_flowring_8_0           	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of egress_or_ingress_1 union */
        uint32_t	reservedSU4_packet_length     	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	reservedSU4_sk_buf_ptr_high   	;
		};
	};
	/* Union WORD 1 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	sk_buf_ptr_low_or_data_1588	; /* This is a field union */
		};
		/* Sub Union 1 */
		struct{
        uint32_t	sk_buf_ptr_low                	; /* Member of sk_buf_ptr_low_or_data_1588 union */
		};
		/* Sub Union 2 */
		struct{
        uint32_t	data_1588                     	:18	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of sk_buf_ptr_low_or_data_1588 union */
        uint32_t	bufmng_cnt_id                 	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of sk_buf_ptr_low_or_data_1588 union */
        uint32_t	reserved1                     	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of sk_buf_ptr_low_or_data_1588 union */
		};
	};
	/* Union WORD 2 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	color               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	do_not_recycle      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	flag_1588           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_emac             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	wan_flow_source_port_union	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	fpm_fallback        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	sbpm_copy           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	tgtmem_or_l3pkt     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	abs                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	egress_or_ingress_2 	; /* This is a field union */
        uint8_t	pkt_buf_ptr_high    	;
		};
		/* Sub Union 1 */
		struct{
        uint32_t	reservedSU1_color             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_do_not_recycle    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_flag_1588         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_is_emac           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	wan_flow_source_port          	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of wan_flow_source_port_union union */
        uint32_t	reservedSU1_fpm_fallback      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_sbpm_copy         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	target_mem_0                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of tgtmem_or_l3pkt union */
        uint32_t	reservedSU1_abs               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	lag_index                     	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of egress_or_ingress_2 union */
        uint32_t	ssid                          	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of egress_or_ingress_2 union */
        uint32_t	egress_dont_drop              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of egress_or_ingress_2 union */
        uint32_t	reserved                      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of egress_or_ingress_2 union */
        uint8_t	reservedSU1_pkt_buf_ptr_high  	;
		};
		/* Sub Union 2 */
		struct{
        uint32_t	reservedSU2_color             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_do_not_recycle    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_flag_1588         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_is_emac           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_wan_flow_source_port_union	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_fpm_fallback      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_sbpm_copy         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	l3_packet                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of tgtmem_or_l3pkt union */
        uint32_t	reservedSU2_abs               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	crypto_session_id             	; /* Member of egress_or_ingress_2 union */
        uint8_t	reservedSU2_pkt_buf_ptr_high  	;
		};
		/* Sub Union 3 */
		struct{
        uint32_t	reservedSU3_color             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_do_not_recycle    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_flag_1588         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_is_emac           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_wan_flow_source_port_union	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_fpm_fallback      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_sbpm_copy         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_tgtmem_or_l3pkt   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_abs               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_gdx_rx                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of egress_or_ingress_2 union */
        uint32_t	gdx_pd_data_15_9              	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of egress_or_ingress_2 union */
        uint8_t	reservedSU3_pkt_buf_ptr_high  	;
		};
		/* Sub Union 4 */
		struct{
        uint32_t	reservedSU4_color             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_do_not_recycle    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_flag_1588         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_is_emac           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_vport                      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of wan_flow_source_port_union union */
        uint32_t	flow_or_port_id               	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of wan_flow_source_port_union union */
        uint32_t	reservedSU4_fpm_fallback      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_sbpm_copy         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_tgtmem_or_l3pkt   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_abs               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_dhd_sq                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of egress_or_ingress_2 union */
        uint32_t	service_queue_id              	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of egress_or_ingress_2 union */
        uint32_t	reserved6                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of egress_or_ingress_2 union */
        uint32_t	is_service_queue              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of egress_or_ingress_2 union */
        uint8_t	reservedSU4_pkt_buf_ptr_high  	;
		};
		/* Sub Union 5 */
		struct{
        uint32_t	reservedSU5_color             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU5_do_not_recycle    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU5_flag_1588         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU5_is_emac           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	dhd_sq_flowring_9             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of wan_flow_source_port_union union */
        uint32_t	dhd_sq_wifi_priority          	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of wan_flow_source_port_union union */
        uint32_t	dhd_sq_radio_idx              	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of wan_flow_source_port_union union */
        uint32_t	reserved5                     	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of wan_flow_source_port_union union */
        uint32_t	reservedSU5_fpm_fallback      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU5_sbpm_copy         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU5_tgtmem_or_l3pkt   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU5_abs               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	reservedSU5_egress_or_ingress_2	;
        uint8_t	reservedSU5_pkt_buf_ptr_high  	;
		};
	};
	/* Union WORD 3 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	pkt_buf_ptr_low_or_fpm_bn0	; /* This is a field union */
		};
		/* Sub Union 1 */
		struct{
        uint32_t	pkt_buf_ptr_low               	; /* Member of pkt_buf_ptr_low_or_fpm_bn0 union */
		};
		/* Sub Union 2 */
		struct{
        uint32_t	reserved0                     	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of pkt_buf_ptr_low_or_fpm_bn0 union */
        uint32_t	fpm_sop                       	:10	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of pkt_buf_ptr_low_or_fpm_bn0 union */
        uint32_t	fpm_bn0                       	:20	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of pkt_buf_ptr_low_or_fpm_bn0 union */
		};
		/* Sub Union 3 */
		struct{
        uint32_t	reserved2                     	:12	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of pkt_buf_ptr_low_or_fpm_bn0 union */
        uint32_t	bn_fpm_pool                   	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of pkt_buf_ptr_low_or_fpm_bn0 union */
        uint32_t	bn_fpm_num                    	:18	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of pkt_buf_ptr_low_or_fpm_bn0 union */
		};
	};
#else
	/* Union WORD 0 */
	union{
		/* Sub Union 0 */
		struct{
        uint8_t	sk_buf_ptr_high     	;
        uint32_t	packet_length       	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	egress_or_ingress_1 	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	is_egress           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 1 */
		struct{
        uint8_t	reservedSU1_sk_buf_ptr_high   	;
        uint32_t	reservedSU1_packet_length     	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	first_level_q                 	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of egress_or_ingress_1 union */
        uint32_t	reservedSU1_is_egress         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 2 */
		struct{
        uint8_t	reservedSU2_sk_buf_ptr_high   	;
        uint32_t	reservedSU2_packet_length     	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	gdx_pd_data_8_0               	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of egress_or_ingress_1 union */
        uint32_t	reservedSU2_is_egress         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 3 */
		struct{
        uint8_t	reservedSU3_sk_buf_ptr_high   	;
        uint32_t	reservedSU3_packet_length     	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved3                     	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of egress_or_ingress_1 union */
        uint32_t	wlan_tid                      	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of egress_or_ingress_1 union */
        uint32_t	reservedSU3_is_egress         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 4 */
		struct{
        uint8_t	reservedSU4_sk_buf_ptr_high   	;
        uint32_t	reservedSU4_packet_length     	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	dhd_sq_flowring_8_0           	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of egress_or_ingress_1 union */
        uint32_t	reservedSU4_is_egress         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
	/* Union WORD 1 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	sk_buf_ptr_low_or_data_1588	; /* This is a field union */
		};
		/* Sub Union 1 */
		struct{
        uint32_t	sk_buf_ptr_low                	; /* Member of sk_buf_ptr_low_or_data_1588 union */
		};
		/* Sub Union 2 */
		struct{
        uint32_t	reserved1                     	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of sk_buf_ptr_low_or_data_1588 union */
        uint32_t	bufmng_cnt_id                 	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of sk_buf_ptr_low_or_data_1588 union */
        uint32_t	data_1588                     	:18	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of sk_buf_ptr_low_or_data_1588 union */
		};
	};
	/* Union WORD 2 */
	union{
		/* Sub Union 0 */
		struct{
        uint8_t	pkt_buf_ptr_high    	;
        uint8_t	egress_or_ingress_2 	; /* This is a field union */
        uint32_t	abs                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	tgtmem_or_l3pkt     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	sbpm_copy           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	fpm_fallback        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	wan_flow_source_port_union	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	is_emac             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	flag_1588           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	do_not_recycle      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	color               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 1 */
		struct{
        uint8_t	reservedSU1_pkt_buf_ptr_high  	;
        uint32_t	reserved                      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of egress_or_ingress_2 union */
        uint32_t	egress_dont_drop              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of egress_or_ingress_2 union */
        uint32_t	ssid                          	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of egress_or_ingress_2 union */
        uint32_t	lag_index                     	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of egress_or_ingress_2 union */
        uint32_t	reservedSU1_abs               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	target_mem_0                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of tgtmem_or_l3pkt union */
        uint32_t	reservedSU1_sbpm_copy         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_fpm_fallback      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	wan_flow_source_port          	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of wan_flow_source_port_union union */
        uint32_t	reservedSU1_is_emac           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_flag_1588         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_do_not_recycle    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_color             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 2 */
		struct{
        uint8_t	reservedSU2_pkt_buf_ptr_high  	;
        uint8_t	crypto_session_id             	; /* Member of egress_or_ingress_2 union */
        uint32_t	reservedSU2_abs               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	l3_packet                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of tgtmem_or_l3pkt union */
        uint32_t	reservedSU2_sbpm_copy         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_fpm_fallback      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_wan_flow_source_port_union	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_is_emac           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_flag_1588         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_do_not_recycle    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_color             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 3 */
		struct{
        uint8_t	reservedSU3_pkt_buf_ptr_high  	;
        uint32_t	gdx_pd_data_15_9              	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of egress_or_ingress_2 union */
        uint32_t	is_gdx_rx                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of egress_or_ingress_2 union */
        uint32_t	reservedSU3_abs               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_tgtmem_or_l3pkt   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_sbpm_copy         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_fpm_fallback      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_wan_flow_source_port_union	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_is_emac           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_flag_1588         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_do_not_recycle    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_color             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 4 */
		struct{
        uint8_t	reservedSU4_pkt_buf_ptr_high  	;
        uint32_t	is_service_queue              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of egress_or_ingress_2 union */
        uint32_t	reserved6                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of egress_or_ingress_2 union */
        uint32_t	service_queue_id              	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of egress_or_ingress_2 union */
        uint32_t	is_dhd_sq                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of egress_or_ingress_2 union */
        uint32_t	reservedSU4_abs               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_tgtmem_or_l3pkt   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_sbpm_copy         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_fpm_fallback      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	flow_or_port_id               	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of wan_flow_source_port_union union */
        uint32_t	is_vport                      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of wan_flow_source_port_union union */
        uint32_t	reservedSU4_is_emac           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_flag_1588         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_do_not_recycle    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_color             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 5 */
		struct{
        uint8_t	reservedSU5_pkt_buf_ptr_high  	;
        uint8_t	reservedSU5_egress_or_ingress_2	;
        uint32_t	reservedSU5_abs               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU5_tgtmem_or_l3pkt   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU5_sbpm_copy         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU5_fpm_fallback      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved5                     	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of wan_flow_source_port_union union */
        uint32_t	dhd_sq_radio_idx              	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of wan_flow_source_port_union union */
        uint32_t	dhd_sq_wifi_priority          	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of wan_flow_source_port_union union */
        uint32_t	dhd_sq_flowring_9             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of wan_flow_source_port_union union */
        uint32_t	reservedSU5_is_emac           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU5_flag_1588         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU5_do_not_recycle    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU5_color             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
	/* Union WORD 3 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	pkt_buf_ptr_low_or_fpm_bn0	; /* This is a field union */
		};
		/* Sub Union 1 */
		struct{
        uint32_t	pkt_buf_ptr_low               	; /* Member of pkt_buf_ptr_low_or_fpm_bn0 union */
		};
		/* Sub Union 2 */
		struct{
        uint32_t	fpm_bn0                       	:20	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of pkt_buf_ptr_low_or_fpm_bn0 union */
        uint32_t	fpm_sop                       	:10	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of pkt_buf_ptr_low_or_fpm_bn0 union */
        uint32_t	reserved0                     	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of pkt_buf_ptr_low_or_fpm_bn0 union */
		};
		/* Sub Union 3 */
		struct{
        uint32_t	bn_fpm_num                    	:18	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of pkt_buf_ptr_low_or_fpm_bn0 union */
        uint32_t	bn_fpm_pool                   	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of pkt_buf_ptr_low_or_fpm_bn0 union */
        uint32_t	reserved2                     	:12	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of pkt_buf_ptr_low_or_fpm_bn0 union */
		};
	};
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) RING_CPU_TX_DESCRIPTOR_STRUCT;

#define RDD_RING_CPU_TX_DESCRIPTOR_IS_EGRESS_READ_G(r, g, idx)                                           GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT), 7, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_IS_EGRESS_WRITE_G(v, g, idx)                                          GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT), 7, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_IS_EGRESS_READ_CORE(r, g, idx, core_id)                               CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT), 7, 1, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_IS_EGRESS_WRITE_CORE(v, g, idx, core_id)                              CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT), 7, 1, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_IS_EGRESS_READ(r, p)                                                  RDP_FIELD_MREAD_8((uint8_t *)(p), 7, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_IS_EGRESS_WRITE(v, p)                                                 RDP_FIELD_MWRITE_8((uint8_t *)(p), 7, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_EGRESS_OR_INGRESS_1_READ_G(r, g, idx)                                 GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT), 6, 9, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_EGRESS_OR_INGRESS_1_WRITE_G(v, g, idx)                                GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT), 6, 9, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_EGRESS_OR_INGRESS_1_READ_CORE(r, g, idx, core_id)                     CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT), 6, 9, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_EGRESS_OR_INGRESS_1_WRITE_CORE(v, g, idx, core_id)                    CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT), 6, 9, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_EGRESS_OR_INGRESS_1_READ(r, p)                                        RDP_FIELD_MREAD_16((uint8_t *)(p), 6, 9, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_EGRESS_OR_INGRESS_1_WRITE(v, p)                                       RDP_FIELD_MWRITE_16((uint8_t *)(p), 6, 9, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_FIRST_LEVEL_Q_READ_G(r, g, idx)                                       GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT), 6, 9, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_FIRST_LEVEL_Q_WRITE_G(v, g, idx)                                      GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT), 6, 9, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_FIRST_LEVEL_Q_READ_CORE(r, g, idx, core_id)                           CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT), 6, 9, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_FIRST_LEVEL_Q_WRITE_CORE(v, g, idx, core_id)                          CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT), 6, 9, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_FIRST_LEVEL_Q_READ(r, p)                                              RDP_FIELD_MREAD_16((uint8_t *)(p), 6, 9, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_FIRST_LEVEL_Q_WRITE(v, p)                                             RDP_FIELD_MWRITE_16((uint8_t *)(p), 6, 9, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_GDX_PD_DATA_8_0_READ_G(r, g, idx)                                     GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT), 6, 9, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_GDX_PD_DATA_8_0_WRITE_G(v, g, idx)                                    GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT), 6, 9, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_GDX_PD_DATA_8_0_READ_CORE(r, g, idx, core_id)                         CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT), 6, 9, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_GDX_PD_DATA_8_0_WRITE_CORE(v, g, idx, core_id)                        CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT), 6, 9, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_GDX_PD_DATA_8_0_READ(r, p)                                            RDP_FIELD_MREAD_16((uint8_t *)(p), 6, 9, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_GDX_PD_DATA_8_0_WRITE(v, p)                                           RDP_FIELD_MWRITE_16((uint8_t *)(p), 6, 9, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_WLAN_TID_READ_G(r, g, idx)                                            GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT), 4, 3, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_WLAN_TID_WRITE_G(v, g, idx)                                           GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT), 4, 3, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_WLAN_TID_READ_CORE(r, g, idx, core_id)                                CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT), 4, 3, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_WLAN_TID_WRITE_CORE(v, g, idx, core_id)                               CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT), 4, 3, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_WLAN_TID_READ(r, p)                                                   RDP_FIELD_MREAD_8((uint8_t *)(p), 4, 3, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_WLAN_TID_WRITE(v, p)                                                  RDP_FIELD_MWRITE_8((uint8_t *)(p), 4, 3, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_DHD_SQ_FLOWRING_8_0_READ_G(r, g, idx)                                 GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT), 6, 9, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_DHD_SQ_FLOWRING_8_0_WRITE_G(v, g, idx)                                GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT), 6, 9, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_DHD_SQ_FLOWRING_8_0_READ_CORE(r, g, idx, core_id)                     CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT), 6, 9, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_DHD_SQ_FLOWRING_8_0_WRITE_CORE(v, g, idx, core_id)                    CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT), 6, 9, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_DHD_SQ_FLOWRING_8_0_READ(r, p)                                        RDP_FIELD_MREAD_16((uint8_t *)(p), 6, 9, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_DHD_SQ_FLOWRING_8_0_WRITE(v, p)                                       RDP_FIELD_MWRITE_16((uint8_t *)(p), 6, 9, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_PACKET_LENGTH_READ_G(r, g, idx)                                       GROUP_RDP_FIELD_MREAD_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 0, 8, 14, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_PACKET_LENGTH_WRITE_G(v, g, idx)                                      GROUP_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 0, 8, 14, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_PACKET_LENGTH_READ_CORE(r, g, idx, core_id)                           CORE_RDP_FIELD_MREAD_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 0, 8, 14, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_PACKET_LENGTH_WRITE_CORE(v, g, idx, core_id)                          CORE_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 0, 8, 14, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_PACKET_LENGTH_READ(r, p)                                              RDP_FIELD_MREAD_32((uint8_t *)(p) + 0, 8, 14, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_PACKET_LENGTH_WRITE(v, p)                                             RDP_FIELD_MWRITE_32((uint8_t *)(p) + 0, 8, 14, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_SK_BUF_PTR_HIGH_READ_G(r, g, idx)                                     GROUP_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 3, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_SK_BUF_PTR_HIGH_WRITE_G(v, g, idx)                                    GROUP_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 3, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_SK_BUF_PTR_HIGH_READ_CORE(r, g, idx, core_id)                         CORE_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 3, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_SK_BUF_PTR_HIGH_WRITE_CORE(v, g, idx, core_id)                        CORE_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 3, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_SK_BUF_PTR_HIGH_READ(r, p)                                            MREAD_8((uint8_t *)(p) + 3, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_SK_BUF_PTR_HIGH_WRITE(v, p)                                           MWRITE_8((uint8_t *)(p) + 3, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_SK_BUF_PTR_LOW_OR_DATA_1588_READ_G(r, g, idx)                         GROUP_MREAD_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 4, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_SK_BUF_PTR_LOW_OR_DATA_1588_WRITE_G(v, g, idx)                        GROUP_MWRITE_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 4, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_SK_BUF_PTR_LOW_OR_DATA_1588_READ_CORE(r, g, idx, core_id)             CORE_MREAD_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 4, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_SK_BUF_PTR_LOW_OR_DATA_1588_WRITE_CORE(v, g, idx, core_id)            CORE_MWRITE_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 4, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_SK_BUF_PTR_LOW_OR_DATA_1588_READ(r, p)                                MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_SK_BUF_PTR_LOW_OR_DATA_1588_WRITE(v, p)                               MWRITE_32((uint8_t *)(p) + 4, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_SK_BUF_PTR_LOW_READ_G(r, g, idx)                                      GROUP_MREAD_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 4, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_SK_BUF_PTR_LOW_WRITE_G(v, g, idx)                                     GROUP_MWRITE_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 4, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_SK_BUF_PTR_LOW_READ_CORE(r, g, idx, core_id)                          CORE_MREAD_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 4, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_SK_BUF_PTR_LOW_WRITE_CORE(v, g, idx, core_id)                         CORE_MWRITE_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 4, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_SK_BUF_PTR_LOW_READ(r, p)                                             MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_SK_BUF_PTR_LOW_WRITE(v, p)                                            MWRITE_32((uint8_t *)(p) + 4, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_DATA_1588_READ_G(r, g, idx)                                           GROUP_RDP_FIELD_MREAD_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 4, 14, 18, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_DATA_1588_WRITE_G(v, g, idx)                                          GROUP_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 4, 14, 18, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_DATA_1588_READ_CORE(r, g, idx, core_id)                               CORE_RDP_FIELD_MREAD_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 4, 14, 18, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_DATA_1588_WRITE_CORE(v, g, idx, core_id)                              CORE_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 4, 14, 18, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_DATA_1588_READ(r, p)                                                  RDP_FIELD_MREAD_32((uint8_t *)(p) + 4, 14, 18, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_DATA_1588_WRITE(v, p)                                                 RDP_FIELD_MWRITE_32((uint8_t *)(p) + 4, 14, 18, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_BUFMNG_CNT_ID_READ_G(r, g, idx)                                       GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 6, 1, 5, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_BUFMNG_CNT_ID_WRITE_G(v, g, idx)                                      GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 6, 1, 5, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_BUFMNG_CNT_ID_READ_CORE(r, g, idx, core_id)                           CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 6, 1, 5, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_BUFMNG_CNT_ID_WRITE_CORE(v, g, idx, core_id)                          CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 6, 1, 5, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_BUFMNG_CNT_ID_READ(r, p)                                              RDP_FIELD_MREAD_8((uint8_t *)(p) + 6, 1, 5, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_BUFMNG_CNT_ID_WRITE(v, p)                                             RDP_FIELD_MWRITE_8((uint8_t *)(p) + 6, 1, 5, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_COLOR_READ_G(r, g, idx)                                               GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 7, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_COLOR_WRITE_G(v, g, idx)                                              GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 7, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_COLOR_READ_CORE(r, g, idx, core_id)                                   CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 7, 1, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_COLOR_WRITE_CORE(v, g, idx, core_id)                                  CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 7, 1, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_COLOR_READ(r, p)                                                      RDP_FIELD_MREAD_8((uint8_t *)(p) + 8, 7, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_COLOR_WRITE(v, p)                                                     RDP_FIELD_MWRITE_8((uint8_t *)(p) + 8, 7, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_DO_NOT_RECYCLE_READ_G(r, g, idx)                                      GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 6, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_DO_NOT_RECYCLE_WRITE_G(v, g, idx)                                     GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 6, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_DO_NOT_RECYCLE_READ_CORE(r, g, idx, core_id)                          CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 6, 1, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_DO_NOT_RECYCLE_WRITE_CORE(v, g, idx, core_id)                         CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 6, 1, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_DO_NOT_RECYCLE_READ(r, p)                                             RDP_FIELD_MREAD_8((uint8_t *)(p) + 8, 6, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_DO_NOT_RECYCLE_WRITE(v, p)                                            RDP_FIELD_MWRITE_8((uint8_t *)(p) + 8, 6, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_FLAG_1588_READ_G(r, g, idx)                                           GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 5, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_FLAG_1588_WRITE_G(v, g, idx)                                          GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 5, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_FLAG_1588_READ_CORE(r, g, idx, core_id)                               CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 5, 1, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_FLAG_1588_WRITE_CORE(v, g, idx, core_id)                              CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 5, 1, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_FLAG_1588_READ(r, p)                                                  RDP_FIELD_MREAD_8((uint8_t *)(p) + 8, 5, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_FLAG_1588_WRITE(v, p)                                                 RDP_FIELD_MWRITE_8((uint8_t *)(p) + 8, 5, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_IS_EMAC_READ_G(r, g, idx)                                             GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 4, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_IS_EMAC_WRITE_G(v, g, idx)                                            GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 4, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_IS_EMAC_READ_CORE(r, g, idx, core_id)                                 CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 4, 1, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_IS_EMAC_WRITE_CORE(v, g, idx, core_id)                                CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 4, 1, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_IS_EMAC_READ(r, p)                                                    RDP_FIELD_MREAD_8((uint8_t *)(p) + 8, 4, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_IS_EMAC_WRITE(v, p)                                                   RDP_FIELD_MWRITE_8((uint8_t *)(p) + 8, 4, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_WAN_FLOW_SOURCE_PORT_UNION_READ_G(r, g, idx)                          GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 4, 8, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_WAN_FLOW_SOURCE_PORT_UNION_WRITE_G(v, g, idx)                         GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 4, 8, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_WAN_FLOW_SOURCE_PORT_UNION_READ_CORE(r, g, idx, core_id)              CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 4, 8, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_WAN_FLOW_SOURCE_PORT_UNION_WRITE_CORE(v, g, idx, core_id)             CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 4, 8, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_WAN_FLOW_SOURCE_PORT_UNION_READ(r, p)                                 RDP_FIELD_MREAD_16((uint8_t *)(p) + 8, 4, 8, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_WAN_FLOW_SOURCE_PORT_UNION_WRITE(v, p)                                RDP_FIELD_MWRITE_16((uint8_t *)(p) + 8, 4, 8, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_WAN_FLOW_SOURCE_PORT_READ_G(r, g, idx)                                GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 4, 8, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_WAN_FLOW_SOURCE_PORT_WRITE_G(v, g, idx)                               GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 4, 8, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_WAN_FLOW_SOURCE_PORT_READ_CORE(r, g, idx, core_id)                    CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 4, 8, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_WAN_FLOW_SOURCE_PORT_WRITE_CORE(v, g, idx, core_id)                   CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 4, 8, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_WAN_FLOW_SOURCE_PORT_READ(r, p)                                       RDP_FIELD_MREAD_16((uint8_t *)(p) + 8, 4, 8, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_WAN_FLOW_SOURCE_PORT_WRITE(v, p)                                      RDP_FIELD_MWRITE_16((uint8_t *)(p) + 8, 4, 8, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_IS_VPORT_READ_G(r, g, idx)                                            GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 3, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_IS_VPORT_WRITE_G(v, g, idx)                                           GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 3, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_IS_VPORT_READ_CORE(r, g, idx, core_id)                                CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 3, 1, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_IS_VPORT_WRITE_CORE(v, g, idx, core_id)                               CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 3, 1, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_IS_VPORT_READ(r, p)                                                   RDP_FIELD_MREAD_8((uint8_t *)(p) + 8, 3, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_IS_VPORT_WRITE(v, p)                                                  RDP_FIELD_MWRITE_8((uint8_t *)(p) + 8, 3, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_FLOW_OR_PORT_ID_READ_G(r, g, idx)                                     GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 4, 7, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_FLOW_OR_PORT_ID_WRITE_G(v, g, idx)                                    GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 4, 7, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_FLOW_OR_PORT_ID_READ_CORE(r, g, idx, core_id)                         CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 4, 7, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_FLOW_OR_PORT_ID_WRITE_CORE(v, g, idx, core_id)                        CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 4, 7, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_FLOW_OR_PORT_ID_READ(r, p)                                            RDP_FIELD_MREAD_16((uint8_t *)(p) + 8, 4, 7, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_FLOW_OR_PORT_ID_WRITE(v, p)                                           RDP_FIELD_MWRITE_16((uint8_t *)(p) + 8, 4, 7, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_DHD_SQ_FLOWRING_9_READ_G(r, g, idx)                                   GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 3, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_DHD_SQ_FLOWRING_9_WRITE_G(v, g, idx)                                  GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 3, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_DHD_SQ_FLOWRING_9_READ_CORE(r, g, idx, core_id)                       CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 3, 1, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_DHD_SQ_FLOWRING_9_WRITE_CORE(v, g, idx, core_id)                      CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 3, 1, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_DHD_SQ_FLOWRING_9_READ(r, p)                                          RDP_FIELD_MREAD_8((uint8_t *)(p) + 8, 3, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_DHD_SQ_FLOWRING_9_WRITE(v, p)                                         RDP_FIELD_MWRITE_8((uint8_t *)(p) + 8, 3, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_DHD_SQ_WIFI_PRIORITY_READ_G(r, g, idx)                                GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 0, 3, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_DHD_SQ_WIFI_PRIORITY_WRITE_G(v, g, idx)                               GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 0, 3, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_DHD_SQ_WIFI_PRIORITY_READ_CORE(r, g, idx, core_id)                    CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 0, 3, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_DHD_SQ_WIFI_PRIORITY_WRITE_CORE(v, g, idx, core_id)                   CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 0, 3, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_DHD_SQ_WIFI_PRIORITY_READ(r, p)                                       RDP_FIELD_MREAD_8((uint8_t *)(p) + 8, 0, 3, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_DHD_SQ_WIFI_PRIORITY_WRITE(v, p)                                      RDP_FIELD_MWRITE_8((uint8_t *)(p) + 8, 0, 3, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_DHD_SQ_RADIO_IDX_READ_G(r, g, idx)                                    GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 9, 6, 2, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_DHD_SQ_RADIO_IDX_WRITE_G(v, g, idx)                                   GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 9, 6, 2, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_DHD_SQ_RADIO_IDX_READ_CORE(r, g, idx, core_id)                        CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 9, 6, 2, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_DHD_SQ_RADIO_IDX_WRITE_CORE(v, g, idx, core_id)                       CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 9, 6, 2, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_DHD_SQ_RADIO_IDX_READ(r, p)                                           RDP_FIELD_MREAD_8((uint8_t *)(p) + 9, 6, 2, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_DHD_SQ_RADIO_IDX_WRITE(v, p)                                          RDP_FIELD_MWRITE_8((uint8_t *)(p) + 9, 6, 2, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_FPM_FALLBACK_READ_G(r, g, idx)                                        GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 9, 3, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_FPM_FALLBACK_WRITE_G(v, g, idx)                                       GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 9, 3, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_FPM_FALLBACK_READ_CORE(r, g, idx, core_id)                            CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 9, 3, 1, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_FPM_FALLBACK_WRITE_CORE(v, g, idx, core_id)                           CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 9, 3, 1, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_FPM_FALLBACK_READ(r, p)                                               RDP_FIELD_MREAD_8((uint8_t *)(p) + 9, 3, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_FPM_FALLBACK_WRITE(v, p)                                              RDP_FIELD_MWRITE_8((uint8_t *)(p) + 9, 3, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_SBPM_COPY_READ_G(r, g, idx)                                           GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 9, 2, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_SBPM_COPY_WRITE_G(v, g, idx)                                          GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 9, 2, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_SBPM_COPY_READ_CORE(r, g, idx, core_id)                               CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 9, 2, 1, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_SBPM_COPY_WRITE_CORE(v, g, idx, core_id)                              CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 9, 2, 1, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_SBPM_COPY_READ(r, p)                                                  RDP_FIELD_MREAD_8((uint8_t *)(p) + 9, 2, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_SBPM_COPY_WRITE(v, p)                                                 RDP_FIELD_MWRITE_8((uint8_t *)(p) + 9, 2, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_TGTMEM_OR_L3PKT_READ_G(r, g, idx)                                     GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 9, 1, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_TGTMEM_OR_L3PKT_WRITE_G(v, g, idx)                                    GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 9, 1, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_TGTMEM_OR_L3PKT_READ_CORE(r, g, idx, core_id)                         CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 9, 1, 1, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_TGTMEM_OR_L3PKT_WRITE_CORE(v, g, idx, core_id)                        CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 9, 1, 1, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_TGTMEM_OR_L3PKT_READ(r, p)                                            RDP_FIELD_MREAD_8((uint8_t *)(p) + 9, 1, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_TGTMEM_OR_L3PKT_WRITE(v, p)                                           RDP_FIELD_MWRITE_8((uint8_t *)(p) + 9, 1, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_TARGET_MEM_0_READ_G(r, g, idx)                                        GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 9, 1, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_TARGET_MEM_0_WRITE_G(v, g, idx)                                       GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 9, 1, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_TARGET_MEM_0_READ_CORE(r, g, idx, core_id)                            CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 9, 1, 1, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_TARGET_MEM_0_WRITE_CORE(v, g, idx, core_id)                           CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 9, 1, 1, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_TARGET_MEM_0_READ(r, p)                                               RDP_FIELD_MREAD_8((uint8_t *)(p) + 9, 1, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_TARGET_MEM_0_WRITE(v, p)                                              RDP_FIELD_MWRITE_8((uint8_t *)(p) + 9, 1, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_L3_PACKET_READ_G(r, g, idx)                                           GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 9, 1, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_L3_PACKET_WRITE_G(v, g, idx)                                          GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 9, 1, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_L3_PACKET_READ_CORE(r, g, idx, core_id)                               CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 9, 1, 1, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_L3_PACKET_WRITE_CORE(v, g, idx, core_id)                              CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 9, 1, 1, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_L3_PACKET_READ(r, p)                                                  RDP_FIELD_MREAD_8((uint8_t *)(p) + 9, 1, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_L3_PACKET_WRITE(v, p)                                                 RDP_FIELD_MWRITE_8((uint8_t *)(p) + 9, 1, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_ABS_READ_G(r, g, idx)                                                 GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 9, 0, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_ABS_WRITE_G(v, g, idx)                                                GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 9, 0, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_ABS_READ_CORE(r, g, idx, core_id)                                     CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 9, 0, 1, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_ABS_WRITE_CORE(v, g, idx, core_id)                                    CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 9, 0, 1, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_ABS_READ(r, p)                                                        RDP_FIELD_MREAD_8((uint8_t *)(p) + 9, 0, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_ABS_WRITE(v, p)                                                       RDP_FIELD_MWRITE_8((uint8_t *)(p) + 9, 0, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_EGRESS_OR_INGRESS_2_READ_G(r, g, idx)                                 GROUP_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_EGRESS_OR_INGRESS_2_WRITE_G(v, g, idx)                                GROUP_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_EGRESS_OR_INGRESS_2_READ_CORE(r, g, idx, core_id)                     CORE_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_EGRESS_OR_INGRESS_2_WRITE_CORE(v, g, idx, core_id)                    CORE_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_EGRESS_OR_INGRESS_2_READ(r, p)                                        MREAD_8((uint8_t *)(p) + 10, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_EGRESS_OR_INGRESS_2_WRITE(v, p)                                       MWRITE_8((uint8_t *)(p) + 10, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_LAG_INDEX_READ_G(r, g, idx)                                           GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, 6, 2, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_LAG_INDEX_WRITE_G(v, g, idx)                                          GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, 6, 2, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_LAG_INDEX_READ_CORE(r, g, idx, core_id)                               CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, 6, 2, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_LAG_INDEX_WRITE_CORE(v, g, idx, core_id)                              CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, 6, 2, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_LAG_INDEX_READ(r, p)                                                  RDP_FIELD_MREAD_8((uint8_t *)(p) + 10, 6, 2, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_LAG_INDEX_WRITE(v, p)                                                 RDP_FIELD_MWRITE_8((uint8_t *)(p) + 10, 6, 2, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_SSID_READ_G(r, g, idx)                                                GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, 2, 4, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_SSID_WRITE_G(v, g, idx)                                               GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, 2, 4, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_SSID_READ_CORE(r, g, idx, core_id)                                    CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, 2, 4, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_SSID_WRITE_CORE(v, g, idx, core_id)                                   CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, 2, 4, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_SSID_READ(r, p)                                                       RDP_FIELD_MREAD_8((uint8_t *)(p) + 10, 2, 4, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_SSID_WRITE(v, p)                                                      RDP_FIELD_MWRITE_8((uint8_t *)(p) + 10, 2, 4, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_EGRESS_DONT_DROP_READ_G(r, g, idx)                                    GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, 1, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_EGRESS_DONT_DROP_WRITE_G(v, g, idx)                                   GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, 1, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_EGRESS_DONT_DROP_READ_CORE(r, g, idx, core_id)                        CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, 1, 1, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_EGRESS_DONT_DROP_WRITE_CORE(v, g, idx, core_id)                       CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, 1, 1, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_EGRESS_DONT_DROP_READ(r, p)                                           RDP_FIELD_MREAD_8((uint8_t *)(p) + 10, 1, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_EGRESS_DONT_DROP_WRITE(v, p)                                          RDP_FIELD_MWRITE_8((uint8_t *)(p) + 10, 1, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_CRYPTO_SESSION_ID_READ_G(r, g, idx)                                   GROUP_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_CRYPTO_SESSION_ID_WRITE_G(v, g, idx)                                  GROUP_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_CRYPTO_SESSION_ID_READ_CORE(r, g, idx, core_id)                       CORE_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_CRYPTO_SESSION_ID_WRITE_CORE(v, g, idx, core_id)                      CORE_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_CRYPTO_SESSION_ID_READ(r, p)                                          MREAD_8((uint8_t *)(p) + 10, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_CRYPTO_SESSION_ID_WRITE(v, p)                                         MWRITE_8((uint8_t *)(p) + 10, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_IS_GDX_RX_READ_G(r, g, idx)                                           GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, 7, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_IS_GDX_RX_WRITE_G(v, g, idx)                                          GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, 7, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_IS_GDX_RX_READ_CORE(r, g, idx, core_id)                               CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, 7, 1, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_IS_GDX_RX_WRITE_CORE(v, g, idx, core_id)                              CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, 7, 1, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_IS_GDX_RX_READ(r, p)                                                  RDP_FIELD_MREAD_8((uint8_t *)(p) + 10, 7, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_IS_GDX_RX_WRITE(v, p)                                                 RDP_FIELD_MWRITE_8((uint8_t *)(p) + 10, 7, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_GDX_PD_DATA_15_9_READ_G(r, g, idx)                                    GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, 0, 7, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_GDX_PD_DATA_15_9_WRITE_G(v, g, idx)                                   GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, 0, 7, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_GDX_PD_DATA_15_9_READ_CORE(r, g, idx, core_id)                        CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, 0, 7, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_GDX_PD_DATA_15_9_WRITE_CORE(v, g, idx, core_id)                       CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, 0, 7, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_GDX_PD_DATA_15_9_READ(r, p)                                           RDP_FIELD_MREAD_8((uint8_t *)(p) + 10, 0, 7, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_GDX_PD_DATA_15_9_WRITE(v, p)                                          RDP_FIELD_MWRITE_8((uint8_t *)(p) + 10, 0, 7, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_IS_DHD_SQ_READ_G(r, g, idx)                                           GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, 7, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_IS_DHD_SQ_WRITE_G(v, g, idx)                                          GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, 7, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_IS_DHD_SQ_READ_CORE(r, g, idx, core_id)                               CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, 7, 1, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_IS_DHD_SQ_WRITE_CORE(v, g, idx, core_id)                              CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, 7, 1, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_IS_DHD_SQ_READ(r, p)                                                  RDP_FIELD_MREAD_8((uint8_t *)(p) + 10, 7, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_IS_DHD_SQ_WRITE(v, p)                                                 RDP_FIELD_MWRITE_8((uint8_t *)(p) + 10, 7, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_SERVICE_QUEUE_ID_READ_G(r, g, idx)                                    GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, 2, 5, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_SERVICE_QUEUE_ID_WRITE_G(v, g, idx)                                   GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, 2, 5, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_SERVICE_QUEUE_ID_READ_CORE(r, g, idx, core_id)                        CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, 2, 5, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_SERVICE_QUEUE_ID_WRITE_CORE(v, g, idx, core_id)                       CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, 2, 5, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_SERVICE_QUEUE_ID_READ(r, p)                                           RDP_FIELD_MREAD_8((uint8_t *)(p) + 10, 2, 5, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_SERVICE_QUEUE_ID_WRITE(v, p)                                          RDP_FIELD_MWRITE_8((uint8_t *)(p) + 10, 2, 5, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_IS_SERVICE_QUEUE_READ_G(r, g, idx)                                    GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, 0, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_IS_SERVICE_QUEUE_WRITE_G(v, g, idx)                                   GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, 0, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_IS_SERVICE_QUEUE_READ_CORE(r, g, idx, core_id)                        CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, 0, 1, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_IS_SERVICE_QUEUE_WRITE_CORE(v, g, idx, core_id)                       CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, 0, 1, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_IS_SERVICE_QUEUE_READ(r, p)                                           RDP_FIELD_MREAD_8((uint8_t *)(p) + 10, 0, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_IS_SERVICE_QUEUE_WRITE(v, p)                                          RDP_FIELD_MWRITE_8((uint8_t *)(p) + 10, 0, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_PKT_BUF_PTR_HIGH_READ_G(r, g, idx)                                    GROUP_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 11, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_PKT_BUF_PTR_HIGH_WRITE_G(v, g, idx)                                   GROUP_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 11, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_PKT_BUF_PTR_HIGH_READ_CORE(r, g, idx, core_id)                        CORE_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 11, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_PKT_BUF_PTR_HIGH_WRITE_CORE(v, g, idx, core_id)                       CORE_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 11, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_PKT_BUF_PTR_HIGH_READ(r, p)                                           MREAD_8((uint8_t *)(p) + 11, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_PKT_BUF_PTR_HIGH_WRITE(v, p)                                          MWRITE_8((uint8_t *)(p) + 11, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_PKT_BUF_PTR_LOW_OR_FPM_BN0_READ_G(r, g, idx)                          GROUP_MREAD_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 12, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_PKT_BUF_PTR_LOW_OR_FPM_BN0_WRITE_G(v, g, idx)                         GROUP_MWRITE_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 12, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_PKT_BUF_PTR_LOW_OR_FPM_BN0_READ_CORE(r, g, idx, core_id)              CORE_MREAD_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 12, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_PKT_BUF_PTR_LOW_OR_FPM_BN0_WRITE_CORE(v, g, idx, core_id)             CORE_MWRITE_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 12, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_PKT_BUF_PTR_LOW_OR_FPM_BN0_READ(r, p)                                 MREAD_32((uint8_t *)(p) + 12, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_PKT_BUF_PTR_LOW_OR_FPM_BN0_WRITE(v, p)                                MWRITE_32((uint8_t *)(p) + 12, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_PKT_BUF_PTR_LOW_READ_G(r, g, idx)                                     GROUP_MREAD_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 12, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_PKT_BUF_PTR_LOW_WRITE_G(v, g, idx)                                    GROUP_MWRITE_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 12, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_PKT_BUF_PTR_LOW_READ_CORE(r, g, idx, core_id)                         CORE_MREAD_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 12, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_PKT_BUF_PTR_LOW_WRITE_CORE(v, g, idx, core_id)                        CORE_MWRITE_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 12, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_PKT_BUF_PTR_LOW_READ(r, p)                                            MREAD_32((uint8_t *)(p) + 12, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_PKT_BUF_PTR_LOW_WRITE(v, p)                                           MWRITE_32((uint8_t *)(p) + 12, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_FPM_SOP_READ_G(r, g, idx)                                             GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 12, 4, 10, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_FPM_SOP_WRITE_G(v, g, idx)                                            GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 12, 4, 10, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_FPM_SOP_READ_CORE(r, g, idx, core_id)                                 CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 12, 4, 10, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_FPM_SOP_WRITE_CORE(v, g, idx, core_id)                                CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 12, 4, 10, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_FPM_SOP_READ(r, p)                                                    RDP_FIELD_MREAD_16((uint8_t *)(p) + 12, 4, 10, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_FPM_SOP_WRITE(v, p)                                                   RDP_FIELD_MWRITE_16((uint8_t *)(p) + 12, 4, 10, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_FPM_BN0_READ_G(r, g, idx)                                             GROUP_RDP_FIELD_MREAD_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 12, 0, 20, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_FPM_BN0_WRITE_G(v, g, idx)                                            GROUP_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 12, 0, 20, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_FPM_BN0_READ_CORE(r, g, idx, core_id)                                 CORE_RDP_FIELD_MREAD_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 12, 0, 20, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_FPM_BN0_WRITE_CORE(v, g, idx, core_id)                                CORE_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 12, 0, 20, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_FPM_BN0_READ(r, p)                                                    RDP_FIELD_MREAD_32((uint8_t *)(p) + 12, 0, 20, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_FPM_BN0_WRITE(v, p)                                                   RDP_FIELD_MWRITE_32((uint8_t *)(p) + 12, 0, 20, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_BN_FPM_POOL_READ_G(r, g, idx)                                         GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 13, 2, 2, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_BN_FPM_POOL_WRITE_G(v, g, idx)                                        GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 13, 2, 2, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_BN_FPM_POOL_READ_CORE(r, g, idx, core_id)                             CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 13, 2, 2, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_BN_FPM_POOL_WRITE_CORE(v, g, idx, core_id)                            CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 13, 2, 2, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_BN_FPM_POOL_READ(r, p)                                                RDP_FIELD_MREAD_8((uint8_t *)(p) + 13, 2, 2, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_BN_FPM_POOL_WRITE(v, p)                                               RDP_FIELD_MWRITE_8((uint8_t *)(p) + 13, 2, 2, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_BN_FPM_NUM_READ_G(r, g, idx)                                          GROUP_RDP_FIELD_MREAD_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 12, 0, 18, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_BN_FPM_NUM_WRITE_G(v, g, idx)                                         GROUP_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 12, 0, 18, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_BN_FPM_NUM_READ_CORE(r, g, idx, core_id)                              CORE_RDP_FIELD_MREAD_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 12, 0, 18, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_BN_FPM_NUM_WRITE_CORE(v, g, idx, core_id)                             CORE_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 12, 0, 18, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_BN_FPM_NUM_READ(r, p)                                                 RDP_FIELD_MREAD_32((uint8_t *)(p) + 12, 0, 18, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_BN_FPM_NUM_WRITE(v, p)                                                RDP_FIELD_MWRITE_32((uint8_t *)(p) + 12, 0, 18, (v))
/* <<<RING_CPU_TX_DESCRIPTOR_STRUCT */


/* >>>CPU_TX_RING_INDICES_STRUCT */
typedef union
    {
    uint8_t word_8[4];
    uint16_t word_16[2];
    uint32_t word_32[1];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint16_t	read_idx  	;
        uint16_t	write_idx 	;
#else
        uint16_t	write_idx 	;
        uint16_t	read_idx  	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(4))) CPU_TX_RING_INDICES_STRUCT;

#define RDD_CPU_TX_RING_INDICES_READ_IDX_READ_G(r, g, idx)                                 GROUP_MREAD_16((g), (idx)*sizeof(CPU_TX_RING_INDICES_STRUCT), (r))
#define RDD_CPU_TX_RING_INDICES_READ_IDX_WRITE_G(v, g, idx)                                GROUP_MWRITE_16((g), (idx)*sizeof(CPU_TX_RING_INDICES_STRUCT), (v))
#define RDD_CPU_TX_RING_INDICES_READ_IDX_READ_CORE(r, g, idx, core_id)                     CORE_MREAD_16((g), (idx)*sizeof(CPU_TX_RING_INDICES_STRUCT), (r), core_id)
#define RDD_CPU_TX_RING_INDICES_READ_IDX_WRITE_CORE(v, g, idx, core_id)                    CORE_MWRITE_16((g), (idx)*sizeof(CPU_TX_RING_INDICES_STRUCT), (v), core_id)
#define RDD_CPU_TX_RING_INDICES_READ_IDX_READ(r, p)                                        MREAD_16((uint8_t *)(p), (r))
#define RDD_CPU_TX_RING_INDICES_READ_IDX_WRITE(v, p)                                       MWRITE_16((uint8_t *)(p), (v))
#define RDD_CPU_TX_RING_INDICES_WRITE_IDX_READ_G(r, g, idx)                                GROUP_MREAD_16((g), (idx)*sizeof(CPU_TX_RING_INDICES_STRUCT) + 2, (r))
#define RDD_CPU_TX_RING_INDICES_WRITE_IDX_WRITE_G(v, g, idx)                               GROUP_MWRITE_16((g), (idx)*sizeof(CPU_TX_RING_INDICES_STRUCT) + 2, (v))
#define RDD_CPU_TX_RING_INDICES_WRITE_IDX_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_16((g), (idx)*sizeof(CPU_TX_RING_INDICES_STRUCT) + 2, (r), core_id)
#define RDD_CPU_TX_RING_INDICES_WRITE_IDX_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_16((g), (idx)*sizeof(CPU_TX_RING_INDICES_STRUCT) + 2, (v), core_id)
#define RDD_CPU_TX_RING_INDICES_WRITE_IDX_READ(r, p)                                       MREAD_16((uint8_t *)(p) + 2, (r))
#define RDD_CPU_TX_RING_INDICES_WRITE_IDX_WRITE(v, p)                                      MWRITE_16((uint8_t *)(p) + 2, (v))
/* <<<CPU_TX_RING_INDICES_STRUCT */


/* >>>CPU_TX_SYNC_FIFO_ENTRY_STRUCT */
typedef union
    {
    uint8_t word_8[8];
    uint16_t word_16[4];
    uint32_t word_32[2];
    uint64_t dword_64[1];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint16_t	write_ptr 	;
        uint16_t	read_ptr  	;
        uint16_t	fifo      	;
        uint16_t	reserved  	;
#else
        uint16_t	read_ptr  	;
        uint16_t	write_ptr 	;
        uint16_t	reserved  	;
        uint16_t	fifo      	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) CPU_TX_SYNC_FIFO_ENTRY_STRUCT;

#define RDD_CPU_TX_SYNC_FIFO_ENTRY_WRITE_PTR_READ_G(r, g, idx)                                GROUP_MREAD_16((g), (idx)*sizeof(CPU_TX_SYNC_FIFO_ENTRY_STRUCT), (r))
#define RDD_CPU_TX_SYNC_FIFO_ENTRY_WRITE_PTR_WRITE_G(v, g, idx)                               GROUP_MWRITE_16((g), (idx)*sizeof(CPU_TX_SYNC_FIFO_ENTRY_STRUCT), (v))
#define RDD_CPU_TX_SYNC_FIFO_ENTRY_WRITE_PTR_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_16((g), (idx)*sizeof(CPU_TX_SYNC_FIFO_ENTRY_STRUCT), (r), core_id)
#define RDD_CPU_TX_SYNC_FIFO_ENTRY_WRITE_PTR_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_16((g), (idx)*sizeof(CPU_TX_SYNC_FIFO_ENTRY_STRUCT), (v), core_id)
#define RDD_CPU_TX_SYNC_FIFO_ENTRY_WRITE_PTR_READ(r, p)                                       MREAD_16((uint8_t *)(p), (r))
#define RDD_CPU_TX_SYNC_FIFO_ENTRY_WRITE_PTR_WRITE(v, p)                                      MWRITE_16((uint8_t *)(p), (v))
#define RDD_CPU_TX_SYNC_FIFO_ENTRY_READ_PTR_READ_G(r, g, idx)                                 GROUP_MREAD_16((g), (idx)*sizeof(CPU_TX_SYNC_FIFO_ENTRY_STRUCT) + 2, (r))
#define RDD_CPU_TX_SYNC_FIFO_ENTRY_READ_PTR_WRITE_G(v, g, idx)                                GROUP_MWRITE_16((g), (idx)*sizeof(CPU_TX_SYNC_FIFO_ENTRY_STRUCT) + 2, (v))
#define RDD_CPU_TX_SYNC_FIFO_ENTRY_READ_PTR_READ_CORE(r, g, idx, core_id)                     CORE_MREAD_16((g), (idx)*sizeof(CPU_TX_SYNC_FIFO_ENTRY_STRUCT) + 2, (r), core_id)
#define RDD_CPU_TX_SYNC_FIFO_ENTRY_READ_PTR_WRITE_CORE(v, g, idx, core_id)                    CORE_MWRITE_16((g), (idx)*sizeof(CPU_TX_SYNC_FIFO_ENTRY_STRUCT) + 2, (v), core_id)
#define RDD_CPU_TX_SYNC_FIFO_ENTRY_READ_PTR_READ(r, p)                                        MREAD_16((uint8_t *)(p) + 2, (r))
#define RDD_CPU_TX_SYNC_FIFO_ENTRY_READ_PTR_WRITE(v, p)                                       MWRITE_16((uint8_t *)(p) + 2, (v))
#define RDD_CPU_TX_SYNC_FIFO_ENTRY_FIFO_READ_G(r, g, idx)                                     GROUP_MREAD_16((g), (idx)*sizeof(CPU_TX_SYNC_FIFO_ENTRY_STRUCT) + 4, (r))
#define RDD_CPU_TX_SYNC_FIFO_ENTRY_FIFO_WRITE_G(v, g, idx)                                    GROUP_MWRITE_16((g), (idx)*sizeof(CPU_TX_SYNC_FIFO_ENTRY_STRUCT) + 4, (v))
#define RDD_CPU_TX_SYNC_FIFO_ENTRY_FIFO_READ_CORE(r, g, idx, core_id)                         CORE_MREAD_16((g), (idx)*sizeof(CPU_TX_SYNC_FIFO_ENTRY_STRUCT) + 4, (r), core_id)
#define RDD_CPU_TX_SYNC_FIFO_ENTRY_FIFO_WRITE_CORE(v, g, idx, core_id)                        CORE_MWRITE_16((g), (idx)*sizeof(CPU_TX_SYNC_FIFO_ENTRY_STRUCT) + 4, (v), core_id)
#define RDD_CPU_TX_SYNC_FIFO_ENTRY_FIFO_READ(r, p)                                            MREAD_16((uint8_t *)(p) + 4, (r))
#define RDD_CPU_TX_SYNC_FIFO_ENTRY_FIFO_WRITE(v, p)                                           MWRITE_16((uint8_t *)(p) + 4, (v))
/* <<<CPU_TX_SYNC_FIFO_ENTRY_STRUCT */


/* >>>CPU_TX_DBG_CNTRS_STRUCT */
#define RDD_CPU_TX_DBG_CNTRS_RESERVED_NUMBER	5
typedef union
    {
    uint8_t word_8[64];
    uint16_t word_16[32];
    uint32_t word_32[16];
    uint64_t dword_64[8];
        struct {
        uint32_t	sbpm_no_next                                     	;
        uint32_t	sbpm_no_first                                    	;
        uint32_t	tx_flow_disable                                  	;
        uint32_t	no_fpm                                           	;
        uint32_t	task_exit                                        	;
        uint32_t	sync_wait                                        	;
        uint32_t	no_dispatcher_scheduler                          	;
        uint32_t	recycle_fifo_full                                	;
        uint32_t	drop_pkt                                         	;
        uint32_t	task_start                                       	;
        uint32_t	no_fwd                                           	;
        uint32_t	reserved[RDD_CPU_TX_DBG_CNTRS_RESERVED_NUMBER];
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) CPU_TX_DBG_CNTRS_STRUCT;

#define RDD_CPU_TX_DBG_CNTRS_SBPM_NO_NEXT_READ_G(r, g, idx)                                           GROUP_MREAD_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT), (r))
#define RDD_CPU_TX_DBG_CNTRS_SBPM_NO_NEXT_WRITE_G(v, g, idx)                                          GROUP_MWRITE_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT), (v))
#define RDD_CPU_TX_DBG_CNTRS_SBPM_NO_NEXT_READ_CORE(r, g, idx, core_id)                               CORE_MREAD_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT), (r), core_id)
#define RDD_CPU_TX_DBG_CNTRS_SBPM_NO_NEXT_WRITE_CORE(v, g, idx, core_id)                              CORE_MWRITE_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT), (v), core_id)
#define RDD_CPU_TX_DBG_CNTRS_SBPM_NO_NEXT_READ(r, p)                                                  MREAD_32((uint8_t *)(p), (r))
#define RDD_CPU_TX_DBG_CNTRS_SBPM_NO_NEXT_WRITE(v, p)                                                 MWRITE_32((uint8_t *)(p), (v))
#define RDD_CPU_TX_DBG_CNTRS_SBPM_NO_FIRST_READ_G(r, g, idx)                                          GROUP_MREAD_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 4, (r))
#define RDD_CPU_TX_DBG_CNTRS_SBPM_NO_FIRST_WRITE_G(v, g, idx)                                         GROUP_MWRITE_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 4, (v))
#define RDD_CPU_TX_DBG_CNTRS_SBPM_NO_FIRST_READ_CORE(r, g, idx, core_id)                              CORE_MREAD_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 4, (r), core_id)
#define RDD_CPU_TX_DBG_CNTRS_SBPM_NO_FIRST_WRITE_CORE(v, g, idx, core_id)                             CORE_MWRITE_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 4, (v), core_id)
#define RDD_CPU_TX_DBG_CNTRS_SBPM_NO_FIRST_READ(r, p)                                                 MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_CPU_TX_DBG_CNTRS_SBPM_NO_FIRST_WRITE(v, p)                                                MWRITE_32((uint8_t *)(p) + 4, (v))
#define RDD_CPU_TX_DBG_CNTRS_TX_FLOW_DISABLE_READ_G(r, g, idx)                                        GROUP_MREAD_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 8, (r))
#define RDD_CPU_TX_DBG_CNTRS_TX_FLOW_DISABLE_WRITE_G(v, g, idx)                                       GROUP_MWRITE_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 8, (v))
#define RDD_CPU_TX_DBG_CNTRS_TX_FLOW_DISABLE_READ_CORE(r, g, idx, core_id)                            CORE_MREAD_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 8, (r), core_id)
#define RDD_CPU_TX_DBG_CNTRS_TX_FLOW_DISABLE_WRITE_CORE(v, g, idx, core_id)                           CORE_MWRITE_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 8, (v), core_id)
#define RDD_CPU_TX_DBG_CNTRS_TX_FLOW_DISABLE_READ(r, p)                                               MREAD_32((uint8_t *)(p) + 8, (r))
#define RDD_CPU_TX_DBG_CNTRS_TX_FLOW_DISABLE_WRITE(v, p)                                              MWRITE_32((uint8_t *)(p) + 8, (v))
#define RDD_CPU_TX_DBG_CNTRS_NO_FPM_READ_G(r, g, idx)                                                 GROUP_MREAD_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 12, (r))
#define RDD_CPU_TX_DBG_CNTRS_NO_FPM_WRITE_G(v, g, idx)                                                GROUP_MWRITE_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 12, (v))
#define RDD_CPU_TX_DBG_CNTRS_NO_FPM_READ_CORE(r, g, idx, core_id)                                     CORE_MREAD_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 12, (r), core_id)
#define RDD_CPU_TX_DBG_CNTRS_NO_FPM_WRITE_CORE(v, g, idx, core_id)                                    CORE_MWRITE_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 12, (v), core_id)
#define RDD_CPU_TX_DBG_CNTRS_NO_FPM_READ(r, p)                                                        MREAD_32((uint8_t *)(p) + 12, (r))
#define RDD_CPU_TX_DBG_CNTRS_NO_FPM_WRITE(v, p)                                                       MWRITE_32((uint8_t *)(p) + 12, (v))
#define RDD_CPU_TX_DBG_CNTRS_TASK_EXIT_READ_G(r, g, idx)                                              GROUP_MREAD_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 16, (r))
#define RDD_CPU_TX_DBG_CNTRS_TASK_EXIT_WRITE_G(v, g, idx)                                             GROUP_MWRITE_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 16, (v))
#define RDD_CPU_TX_DBG_CNTRS_TASK_EXIT_READ_CORE(r, g, idx, core_id)                                  CORE_MREAD_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 16, (r), core_id)
#define RDD_CPU_TX_DBG_CNTRS_TASK_EXIT_WRITE_CORE(v, g, idx, core_id)                                 CORE_MWRITE_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 16, (v), core_id)
#define RDD_CPU_TX_DBG_CNTRS_TASK_EXIT_READ(r, p)                                                     MREAD_32((uint8_t *)(p) + 16, (r))
#define RDD_CPU_TX_DBG_CNTRS_TASK_EXIT_WRITE(v, p)                                                    MWRITE_32((uint8_t *)(p) + 16, (v))
#define RDD_CPU_TX_DBG_CNTRS_SYNC_WAIT_READ_G(r, g, idx)                                              GROUP_MREAD_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 20, (r))
#define RDD_CPU_TX_DBG_CNTRS_SYNC_WAIT_WRITE_G(v, g, idx)                                             GROUP_MWRITE_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 20, (v))
#define RDD_CPU_TX_DBG_CNTRS_SYNC_WAIT_READ_CORE(r, g, idx, core_id)                                  CORE_MREAD_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 20, (r), core_id)
#define RDD_CPU_TX_DBG_CNTRS_SYNC_WAIT_WRITE_CORE(v, g, idx, core_id)                                 CORE_MWRITE_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 20, (v), core_id)
#define RDD_CPU_TX_DBG_CNTRS_SYNC_WAIT_READ(r, p)                                                     MREAD_32((uint8_t *)(p) + 20, (r))
#define RDD_CPU_TX_DBG_CNTRS_SYNC_WAIT_WRITE(v, p)                                                    MWRITE_32((uint8_t *)(p) + 20, (v))
#define RDD_CPU_TX_DBG_CNTRS_NO_DISPATCHER_SCHEDULER_READ_G(r, g, idx)                                GROUP_MREAD_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 24, (r))
#define RDD_CPU_TX_DBG_CNTRS_NO_DISPATCHER_SCHEDULER_WRITE_G(v, g, idx)                               GROUP_MWRITE_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 24, (v))
#define RDD_CPU_TX_DBG_CNTRS_NO_DISPATCHER_SCHEDULER_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 24, (r), core_id)
#define RDD_CPU_TX_DBG_CNTRS_NO_DISPATCHER_SCHEDULER_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 24, (v), core_id)
#define RDD_CPU_TX_DBG_CNTRS_NO_DISPATCHER_SCHEDULER_READ(r, p)                                       MREAD_32((uint8_t *)(p) + 24, (r))
#define RDD_CPU_TX_DBG_CNTRS_NO_DISPATCHER_SCHEDULER_WRITE(v, p)                                      MWRITE_32((uint8_t *)(p) + 24, (v))
#define RDD_CPU_TX_DBG_CNTRS_RECYCLE_FIFO_FULL_READ_G(r, g, idx)                                      GROUP_MREAD_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 28, (r))
#define RDD_CPU_TX_DBG_CNTRS_RECYCLE_FIFO_FULL_WRITE_G(v, g, idx)                                     GROUP_MWRITE_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 28, (v))
#define RDD_CPU_TX_DBG_CNTRS_RECYCLE_FIFO_FULL_READ_CORE(r, g, idx, core_id)                          CORE_MREAD_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 28, (r), core_id)
#define RDD_CPU_TX_DBG_CNTRS_RECYCLE_FIFO_FULL_WRITE_CORE(v, g, idx, core_id)                         CORE_MWRITE_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 28, (v), core_id)
#define RDD_CPU_TX_DBG_CNTRS_RECYCLE_FIFO_FULL_READ(r, p)                                             MREAD_32((uint8_t *)(p) + 28, (r))
#define RDD_CPU_TX_DBG_CNTRS_RECYCLE_FIFO_FULL_WRITE(v, p)                                            MWRITE_32((uint8_t *)(p) + 28, (v))
#define RDD_CPU_TX_DBG_CNTRS_DROP_PKT_READ_G(r, g, idx)                                               GROUP_MREAD_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 32, (r))
#define RDD_CPU_TX_DBG_CNTRS_DROP_PKT_WRITE_G(v, g, idx)                                              GROUP_MWRITE_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 32, (v))
#define RDD_CPU_TX_DBG_CNTRS_DROP_PKT_READ_CORE(r, g, idx, core_id)                                   CORE_MREAD_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 32, (r), core_id)
#define RDD_CPU_TX_DBG_CNTRS_DROP_PKT_WRITE_CORE(v, g, idx, core_id)                                  CORE_MWRITE_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 32, (v), core_id)
#define RDD_CPU_TX_DBG_CNTRS_DROP_PKT_READ(r, p)                                                      MREAD_32((uint8_t *)(p) + 32, (r))
#define RDD_CPU_TX_DBG_CNTRS_DROP_PKT_WRITE(v, p)                                                     MWRITE_32((uint8_t *)(p) + 32, (v))
#define RDD_CPU_TX_DBG_CNTRS_TASK_START_READ_G(r, g, idx)                                             GROUP_MREAD_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 36, (r))
#define RDD_CPU_TX_DBG_CNTRS_TASK_START_WRITE_G(v, g, idx)                                            GROUP_MWRITE_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 36, (v))
#define RDD_CPU_TX_DBG_CNTRS_TASK_START_READ_CORE(r, g, idx, core_id)                                 CORE_MREAD_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 36, (r), core_id)
#define RDD_CPU_TX_DBG_CNTRS_TASK_START_WRITE_CORE(v, g, idx, core_id)                                CORE_MWRITE_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 36, (v), core_id)
#define RDD_CPU_TX_DBG_CNTRS_TASK_START_READ(r, p)                                                    MREAD_32((uint8_t *)(p) + 36, (r))
#define RDD_CPU_TX_DBG_CNTRS_TASK_START_WRITE(v, p)                                                   MWRITE_32((uint8_t *)(p) + 36, (v))
#define RDD_CPU_TX_DBG_CNTRS_NO_FWD_READ_G(r, g, idx)                                                 GROUP_MREAD_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 40, (r))
#define RDD_CPU_TX_DBG_CNTRS_NO_FWD_WRITE_G(v, g, idx)                                                GROUP_MWRITE_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 40, (v))
#define RDD_CPU_TX_DBG_CNTRS_NO_FWD_READ_CORE(r, g, idx, core_id)                                     CORE_MREAD_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 40, (r), core_id)
#define RDD_CPU_TX_DBG_CNTRS_NO_FWD_WRITE_CORE(v, g, idx, core_id)                                    CORE_MWRITE_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 40, (v), core_id)
#define RDD_CPU_TX_DBG_CNTRS_NO_FWD_READ(r, p)                                                        MREAD_32((uint8_t *)(p) + 40, (r))
#define RDD_CPU_TX_DBG_CNTRS_NO_FWD_WRITE(v, p)                                                       MWRITE_32((uint8_t *)(p) + 40, (v))
/* <<<CPU_TX_DBG_CNTRS_STRUCT */


/* >>>RNR_COUNTER_REPLY_ENTRY_STRUCT */
typedef union
    {
    uint8_t word_8[32];
    uint16_t word_16[16];
    uint32_t word_32[8];
    uint64_t dword_64[4];
        struct {
        uint32_t	counter_reply   	;
        uint32_t	reserved0       	;
        uint32_t	reserved1       	;
        uint32_t	reserved2       	;
        uint32_t	counter_rt_val  	;
        uint32_t	rnr_sync_cnt_val	;
        uint32_t	recv_total_pkt  	;
        uint32_t	sent_total_pkt  	;
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) RNR_COUNTER_REPLY_ENTRY_STRUCT;

#define RDD_RNR_COUNTER_REPLY_ENTRY_COUNTER_REPLY_READ_G(r, g, idx)                                   GROUP_MREAD_32((g), (idx)*sizeof(RNR_COUNTER_REPLY_ENTRY_STRUCT), (r))
#define RDD_RNR_COUNTER_REPLY_ENTRY_COUNTER_REPLY_WRITE_G(v, g, idx)                                  GROUP_MWRITE_32((g), (idx)*sizeof(RNR_COUNTER_REPLY_ENTRY_STRUCT), (v))
#define RDD_RNR_COUNTER_REPLY_ENTRY_COUNTER_REPLY_READ_CORE(r, g, idx, core_id)                       CORE_MREAD_32((g), (idx)*sizeof(RNR_COUNTER_REPLY_ENTRY_STRUCT), (r), core_id)
#define RDD_RNR_COUNTER_REPLY_ENTRY_COUNTER_REPLY_WRITE_CORE(v, g, idx, core_id)                      CORE_MWRITE_32((g), (idx)*sizeof(RNR_COUNTER_REPLY_ENTRY_STRUCT), (v), core_id)
#define RDD_RNR_COUNTER_REPLY_ENTRY_COUNTER_REPLY_READ(r, p)                                          MREAD_32((uint8_t *)(p), (r))
#define RDD_RNR_COUNTER_REPLY_ENTRY_COUNTER_REPLY_WRITE(v, p)                                         MWRITE_32((uint8_t *)(p), (v))
#define RDD_RNR_COUNTER_REPLY_ENTRY_COUNTER_RT_VAL_READ_G(r, g, idx)                                  GROUP_MREAD_32((g), (idx)*sizeof(RNR_COUNTER_REPLY_ENTRY_STRUCT) + 16, (r))
#define RDD_RNR_COUNTER_REPLY_ENTRY_COUNTER_RT_VAL_WRITE_G(v, g, idx)                                 GROUP_MWRITE_32((g), (idx)*sizeof(RNR_COUNTER_REPLY_ENTRY_STRUCT) + 16, (v))
#define RDD_RNR_COUNTER_REPLY_ENTRY_COUNTER_RT_VAL_READ_CORE(r, g, idx, core_id)                      CORE_MREAD_32((g), (idx)*sizeof(RNR_COUNTER_REPLY_ENTRY_STRUCT) + 16, (r), core_id)
#define RDD_RNR_COUNTER_REPLY_ENTRY_COUNTER_RT_VAL_WRITE_CORE(v, g, idx, core_id)                     CORE_MWRITE_32((g), (idx)*sizeof(RNR_COUNTER_REPLY_ENTRY_STRUCT) + 16, (v), core_id)
#define RDD_RNR_COUNTER_REPLY_ENTRY_COUNTER_RT_VAL_READ(r, p)                                         MREAD_32((uint8_t *)(p) + 16, (r))
#define RDD_RNR_COUNTER_REPLY_ENTRY_COUNTER_RT_VAL_WRITE(v, p)                                        MWRITE_32((uint8_t *)(p) + 16, (v))
#define RDD_RNR_COUNTER_REPLY_ENTRY_RNR_SYNC_CNT_VAL_READ_G(r, g, idx)                                GROUP_MREAD_32((g), (idx)*sizeof(RNR_COUNTER_REPLY_ENTRY_STRUCT) + 20, (r))
#define RDD_RNR_COUNTER_REPLY_ENTRY_RNR_SYNC_CNT_VAL_WRITE_G(v, g, idx)                               GROUP_MWRITE_32((g), (idx)*sizeof(RNR_COUNTER_REPLY_ENTRY_STRUCT) + 20, (v))
#define RDD_RNR_COUNTER_REPLY_ENTRY_RNR_SYNC_CNT_VAL_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_32((g), (idx)*sizeof(RNR_COUNTER_REPLY_ENTRY_STRUCT) + 20, (r), core_id)
#define RDD_RNR_COUNTER_REPLY_ENTRY_RNR_SYNC_CNT_VAL_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_32((g), (idx)*sizeof(RNR_COUNTER_REPLY_ENTRY_STRUCT) + 20, (v), core_id)
#define RDD_RNR_COUNTER_REPLY_ENTRY_RNR_SYNC_CNT_VAL_READ(r, p)                                       MREAD_32((uint8_t *)(p) + 20, (r))
#define RDD_RNR_COUNTER_REPLY_ENTRY_RNR_SYNC_CNT_VAL_WRITE(v, p)                                      MWRITE_32((uint8_t *)(p) + 20, (v))
#define RDD_RNR_COUNTER_REPLY_ENTRY_RECV_TOTAL_PKT_READ_G(r, g, idx)                                  GROUP_MREAD_32((g), (idx)*sizeof(RNR_COUNTER_REPLY_ENTRY_STRUCT) + 24, (r))
#define RDD_RNR_COUNTER_REPLY_ENTRY_RECV_TOTAL_PKT_WRITE_G(v, g, idx)                                 GROUP_MWRITE_32((g), (idx)*sizeof(RNR_COUNTER_REPLY_ENTRY_STRUCT) + 24, (v))
#define RDD_RNR_COUNTER_REPLY_ENTRY_RECV_TOTAL_PKT_READ_CORE(r, g, idx, core_id)                      CORE_MREAD_32((g), (idx)*sizeof(RNR_COUNTER_REPLY_ENTRY_STRUCT) + 24, (r), core_id)
#define RDD_RNR_COUNTER_REPLY_ENTRY_RECV_TOTAL_PKT_WRITE_CORE(v, g, idx, core_id)                     CORE_MWRITE_32((g), (idx)*sizeof(RNR_COUNTER_REPLY_ENTRY_STRUCT) + 24, (v), core_id)
#define RDD_RNR_COUNTER_REPLY_ENTRY_RECV_TOTAL_PKT_READ(r, p)                                         MREAD_32((uint8_t *)(p) + 24, (r))
#define RDD_RNR_COUNTER_REPLY_ENTRY_RECV_TOTAL_PKT_WRITE(v, p)                                        MWRITE_32((uint8_t *)(p) + 24, (v))
#define RDD_RNR_COUNTER_REPLY_ENTRY_SENT_TOTAL_PKT_READ_G(r, g, idx)                                  GROUP_MREAD_32((g), (idx)*sizeof(RNR_COUNTER_REPLY_ENTRY_STRUCT) + 28, (r))
#define RDD_RNR_COUNTER_REPLY_ENTRY_SENT_TOTAL_PKT_WRITE_G(v, g, idx)                                 GROUP_MWRITE_32((g), (idx)*sizeof(RNR_COUNTER_REPLY_ENTRY_STRUCT) + 28, (v))
#define RDD_RNR_COUNTER_REPLY_ENTRY_SENT_TOTAL_PKT_READ_CORE(r, g, idx, core_id)                      CORE_MREAD_32((g), (idx)*sizeof(RNR_COUNTER_REPLY_ENTRY_STRUCT) + 28, (r), core_id)
#define RDD_RNR_COUNTER_REPLY_ENTRY_SENT_TOTAL_PKT_WRITE_CORE(v, g, idx, core_id)                     CORE_MWRITE_32((g), (idx)*sizeof(RNR_COUNTER_REPLY_ENTRY_STRUCT) + 28, (v), core_id)
#define RDD_RNR_COUNTER_REPLY_ENTRY_SENT_TOTAL_PKT_READ(r, p)                                         MREAD_32((uint8_t *)(p) + 28, (r))
#define RDD_RNR_COUNTER_REPLY_ENTRY_SENT_TOTAL_PKT_WRITE(v, p)                                        MWRITE_32((uint8_t *)(p) + 28, (v))
/* <<<RNR_COUNTER_REPLY_ENTRY_STRUCT */


/* >>>SPDSVC_GEN_PARAMS_STRUCT */
typedef union
    {
    uint8_t word_8[60];
    uint16_t word_16[30];
    uint32_t word_32[15];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	processing_tx_pd_0	;
        uint32_t	processing_tx_pd_1	;
        uint32_t	reserved0         	;
        uint32_t	reserved1         	;
        uint32_t	reserved2         	;
        uint32_t	reserved3         	;
        uint32_t	processing_tx_pd_2	;
        uint32_t	processing_tx_pd_3	;
        uint32_t	total_copies      	;
        uint32_t	bucket            	;
        uint16_t	timer_period      	;
        uint16_t	total_length      	;
        uint32_t	tx_packets        	;
        uint32_t	tx_dropped        	;
        uint32_t	tokens            	;
        uint32_t	bucket_size       	;
#else
        uint32_t	processing_tx_pd_0	;
        uint32_t	processing_tx_pd_1	;
        uint32_t	reserved0         	;
        uint32_t	reserved1         	;
        uint32_t	reserved2         	;
        uint32_t	reserved3         	;
        uint32_t	processing_tx_pd_2	;
        uint32_t	processing_tx_pd_3	;
        uint32_t	total_copies      	;
        uint32_t	bucket            	;
        uint16_t	total_length      	;
        uint16_t	timer_period      	;
        uint32_t	tx_packets        	;
        uint32_t	tx_dropped        	;
        uint32_t	tokens            	;
        uint32_t	bucket_size       	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(4))) SPDSVC_GEN_PARAMS_STRUCT;

#define RDD_SPDSVC_GEN_PARAMS_PROCESSING_TX_PD_0_READ_G(r, g, idx)                                GROUP_MREAD_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT), (r))
#define RDD_SPDSVC_GEN_PARAMS_PROCESSING_TX_PD_0_WRITE_G(v, g, idx)                               GROUP_MWRITE_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT), (v))
#define RDD_SPDSVC_GEN_PARAMS_PROCESSING_TX_PD_0_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT), (r), core_id)
#define RDD_SPDSVC_GEN_PARAMS_PROCESSING_TX_PD_0_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT), (v), core_id)
#define RDD_SPDSVC_GEN_PARAMS_PROCESSING_TX_PD_0_READ(r, p)                                       MREAD_32((uint8_t *)(p), (r))
#define RDD_SPDSVC_GEN_PARAMS_PROCESSING_TX_PD_0_WRITE(v, p)                                      MWRITE_32((uint8_t *)(p), (v))
#define RDD_SPDSVC_GEN_PARAMS_PROCESSING_TX_PD_1_READ_G(r, g, idx)                                GROUP_MREAD_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 4, (r))
#define RDD_SPDSVC_GEN_PARAMS_PROCESSING_TX_PD_1_WRITE_G(v, g, idx)                               GROUP_MWRITE_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 4, (v))
#define RDD_SPDSVC_GEN_PARAMS_PROCESSING_TX_PD_1_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 4, (r), core_id)
#define RDD_SPDSVC_GEN_PARAMS_PROCESSING_TX_PD_1_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 4, (v), core_id)
#define RDD_SPDSVC_GEN_PARAMS_PROCESSING_TX_PD_1_READ(r, p)                                       MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_SPDSVC_GEN_PARAMS_PROCESSING_TX_PD_1_WRITE(v, p)                                      MWRITE_32((uint8_t *)(p) + 4, (v))
#define RDD_SPDSVC_GEN_PARAMS_PROCESSING_TX_PD_2_READ_G(r, g, idx)                                GROUP_MREAD_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 24, (r))
#define RDD_SPDSVC_GEN_PARAMS_PROCESSING_TX_PD_2_WRITE_G(v, g, idx)                               GROUP_MWRITE_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 24, (v))
#define RDD_SPDSVC_GEN_PARAMS_PROCESSING_TX_PD_2_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 24, (r), core_id)
#define RDD_SPDSVC_GEN_PARAMS_PROCESSING_TX_PD_2_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 24, (v), core_id)
#define RDD_SPDSVC_GEN_PARAMS_PROCESSING_TX_PD_2_READ(r, p)                                       MREAD_32((uint8_t *)(p) + 24, (r))
#define RDD_SPDSVC_GEN_PARAMS_PROCESSING_TX_PD_2_WRITE(v, p)                                      MWRITE_32((uint8_t *)(p) + 24, (v))
#define RDD_SPDSVC_GEN_PARAMS_PROCESSING_TX_PD_3_READ_G(r, g, idx)                                GROUP_MREAD_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 28, (r))
#define RDD_SPDSVC_GEN_PARAMS_PROCESSING_TX_PD_3_WRITE_G(v, g, idx)                               GROUP_MWRITE_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 28, (v))
#define RDD_SPDSVC_GEN_PARAMS_PROCESSING_TX_PD_3_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 28, (r), core_id)
#define RDD_SPDSVC_GEN_PARAMS_PROCESSING_TX_PD_3_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 28, (v), core_id)
#define RDD_SPDSVC_GEN_PARAMS_PROCESSING_TX_PD_3_READ(r, p)                                       MREAD_32((uint8_t *)(p) + 28, (r))
#define RDD_SPDSVC_GEN_PARAMS_PROCESSING_TX_PD_3_WRITE(v, p)                                      MWRITE_32((uint8_t *)(p) + 28, (v))
#define RDD_SPDSVC_GEN_PARAMS_TOTAL_COPIES_READ_G(r, g, idx)                                      GROUP_MREAD_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 32, (r))
#define RDD_SPDSVC_GEN_PARAMS_TOTAL_COPIES_WRITE_G(v, g, idx)                                     GROUP_MWRITE_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 32, (v))
#define RDD_SPDSVC_GEN_PARAMS_TOTAL_COPIES_READ_CORE(r, g, idx, core_id)                          CORE_MREAD_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 32, (r), core_id)
#define RDD_SPDSVC_GEN_PARAMS_TOTAL_COPIES_WRITE_CORE(v, g, idx, core_id)                         CORE_MWRITE_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 32, (v), core_id)
#define RDD_SPDSVC_GEN_PARAMS_TOTAL_COPIES_READ(r, p)                                             MREAD_32((uint8_t *)(p) + 32, (r))
#define RDD_SPDSVC_GEN_PARAMS_TOTAL_COPIES_WRITE(v, p)                                            MWRITE_32((uint8_t *)(p) + 32, (v))
#define RDD_SPDSVC_GEN_PARAMS_BUCKET_READ_G(r, g, idx)                                            GROUP_MREAD_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 36, (r))
#define RDD_SPDSVC_GEN_PARAMS_BUCKET_WRITE_G(v, g, idx)                                           GROUP_MWRITE_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 36, (v))
#define RDD_SPDSVC_GEN_PARAMS_BUCKET_READ_CORE(r, g, idx, core_id)                                CORE_MREAD_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 36, (r), core_id)
#define RDD_SPDSVC_GEN_PARAMS_BUCKET_WRITE_CORE(v, g, idx, core_id)                               CORE_MWRITE_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 36, (v), core_id)
#define RDD_SPDSVC_GEN_PARAMS_BUCKET_READ(r, p)                                                   MREAD_32((uint8_t *)(p) + 36, (r))
#define RDD_SPDSVC_GEN_PARAMS_BUCKET_WRITE(v, p)                                                  MWRITE_32((uint8_t *)(p) + 36, (v))
#define RDD_SPDSVC_GEN_PARAMS_TIMER_PERIOD_READ_G(r, g, idx)                                      GROUP_MREAD_16((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 40, (r))
#define RDD_SPDSVC_GEN_PARAMS_TIMER_PERIOD_WRITE_G(v, g, idx)                                     GROUP_MWRITE_16((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 40, (v))
#define RDD_SPDSVC_GEN_PARAMS_TIMER_PERIOD_READ_CORE(r, g, idx, core_id)                          CORE_MREAD_16((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 40, (r), core_id)
#define RDD_SPDSVC_GEN_PARAMS_TIMER_PERIOD_WRITE_CORE(v, g, idx, core_id)                         CORE_MWRITE_16((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 40, (v), core_id)
#define RDD_SPDSVC_GEN_PARAMS_TIMER_PERIOD_READ(r, p)                                             MREAD_16((uint8_t *)(p) + 40, (r))
#define RDD_SPDSVC_GEN_PARAMS_TIMER_PERIOD_WRITE(v, p)                                            MWRITE_16((uint8_t *)(p) + 40, (v))
#define RDD_SPDSVC_GEN_PARAMS_TOTAL_LENGTH_READ_G(r, g, idx)                                      GROUP_MREAD_16((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 42, (r))
#define RDD_SPDSVC_GEN_PARAMS_TOTAL_LENGTH_WRITE_G(v, g, idx)                                     GROUP_MWRITE_16((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 42, (v))
#define RDD_SPDSVC_GEN_PARAMS_TOTAL_LENGTH_READ_CORE(r, g, idx, core_id)                          CORE_MREAD_16((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 42, (r), core_id)
#define RDD_SPDSVC_GEN_PARAMS_TOTAL_LENGTH_WRITE_CORE(v, g, idx, core_id)                         CORE_MWRITE_16((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 42, (v), core_id)
#define RDD_SPDSVC_GEN_PARAMS_TOTAL_LENGTH_READ(r, p)                                             MREAD_16((uint8_t *)(p) + 42, (r))
#define RDD_SPDSVC_GEN_PARAMS_TOTAL_LENGTH_WRITE(v, p)                                            MWRITE_16((uint8_t *)(p) + 42, (v))
#define RDD_SPDSVC_GEN_PARAMS_TX_PACKETS_READ_G(r, g, idx)                                        GROUP_MREAD_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 44, (r))
#define RDD_SPDSVC_GEN_PARAMS_TX_PACKETS_WRITE_G(v, g, idx)                                       GROUP_MWRITE_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 44, (v))
#define RDD_SPDSVC_GEN_PARAMS_TX_PACKETS_READ_CORE(r, g, idx, core_id)                            CORE_MREAD_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 44, (r), core_id)
#define RDD_SPDSVC_GEN_PARAMS_TX_PACKETS_WRITE_CORE(v, g, idx, core_id)                           CORE_MWRITE_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 44, (v), core_id)
#define RDD_SPDSVC_GEN_PARAMS_TX_PACKETS_READ(r, p)                                               MREAD_32((uint8_t *)(p) + 44, (r))
#define RDD_SPDSVC_GEN_PARAMS_TX_PACKETS_WRITE(v, p)                                              MWRITE_32((uint8_t *)(p) + 44, (v))
#define RDD_SPDSVC_GEN_PARAMS_TX_DROPPED_READ_G(r, g, idx)                                        GROUP_MREAD_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 48, (r))
#define RDD_SPDSVC_GEN_PARAMS_TX_DROPPED_WRITE_G(v, g, idx)                                       GROUP_MWRITE_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 48, (v))
#define RDD_SPDSVC_GEN_PARAMS_TX_DROPPED_READ_CORE(r, g, idx, core_id)                            CORE_MREAD_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 48, (r), core_id)
#define RDD_SPDSVC_GEN_PARAMS_TX_DROPPED_WRITE_CORE(v, g, idx, core_id)                           CORE_MWRITE_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 48, (v), core_id)
#define RDD_SPDSVC_GEN_PARAMS_TX_DROPPED_READ(r, p)                                               MREAD_32((uint8_t *)(p) + 48, (r))
#define RDD_SPDSVC_GEN_PARAMS_TX_DROPPED_WRITE(v, p)                                              MWRITE_32((uint8_t *)(p) + 48, (v))
#define RDD_SPDSVC_GEN_PARAMS_TOKENS_READ_G(r, g, idx)                                            GROUP_MREAD_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 52, (r))
#define RDD_SPDSVC_GEN_PARAMS_TOKENS_WRITE_G(v, g, idx)                                           GROUP_MWRITE_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 52, (v))
#define RDD_SPDSVC_GEN_PARAMS_TOKENS_READ_CORE(r, g, idx, core_id)                                CORE_MREAD_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 52, (r), core_id)
#define RDD_SPDSVC_GEN_PARAMS_TOKENS_WRITE_CORE(v, g, idx, core_id)                               CORE_MWRITE_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 52, (v), core_id)
#define RDD_SPDSVC_GEN_PARAMS_TOKENS_READ(r, p)                                                   MREAD_32((uint8_t *)(p) + 52, (r))
#define RDD_SPDSVC_GEN_PARAMS_TOKENS_WRITE(v, p)                                                  MWRITE_32((uint8_t *)(p) + 52, (v))
#define RDD_SPDSVC_GEN_PARAMS_BUCKET_SIZE_READ_G(r, g, idx)                                       GROUP_MREAD_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 56, (r))
#define RDD_SPDSVC_GEN_PARAMS_BUCKET_SIZE_WRITE_G(v, g, idx)                                      GROUP_MWRITE_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 56, (v))
#define RDD_SPDSVC_GEN_PARAMS_BUCKET_SIZE_READ_CORE(r, g, idx, core_id)                           CORE_MREAD_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 56, (r), core_id)
#define RDD_SPDSVC_GEN_PARAMS_BUCKET_SIZE_WRITE_CORE(v, g, idx, core_id)                          CORE_MWRITE_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 56, (v), core_id)
#define RDD_SPDSVC_GEN_PARAMS_BUCKET_SIZE_READ(r, p)                                              MREAD_32((uint8_t *)(p) + 56, (r))
#define RDD_SPDSVC_GEN_PARAMS_BUCKET_SIZE_WRITE(v, p)                                             MWRITE_32((uint8_t *)(p) + 56, (v))
/* <<<SPDSVC_GEN_PARAMS_STRUCT */


/* >>>SPDTEST_GEN_CFG_STRUCT */
typedef union
    {
    uint8_t word_8[4];
    uint16_t word_16[2];
    uint32_t word_32[1];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	test_type         	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_on             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_endless_tx     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	not_valid_license 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	iperf3_64bit_pktid	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved0         	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	interrupt_id      	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	reserved1         	;
#else
        uint16_t	reserved1         	;
        uint32_t	interrupt_id      	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved0         	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	iperf3_64bit_pktid	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	not_valid_license 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_endless_tx     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_on             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	test_type         	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(4))) SPDTEST_GEN_CFG_STRUCT;

#define RDD_SPDTEST_GEN_CFG_TEST_TYPE_READ_G(r, g, idx)                                         GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(SPDTEST_GEN_CFG_STRUCT), 4, 4, (r))
#define RDD_SPDTEST_GEN_CFG_TEST_TYPE_WRITE_G(v, g, idx)                                        GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(SPDTEST_GEN_CFG_STRUCT), 4, 4, (v))
#define RDD_SPDTEST_GEN_CFG_TEST_TYPE_READ_CORE(r, g, idx, core_id)                             CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(SPDTEST_GEN_CFG_STRUCT), 4, 4, (r), core_id)
#define RDD_SPDTEST_GEN_CFG_TEST_TYPE_WRITE_CORE(v, g, idx, core_id)                            CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(SPDTEST_GEN_CFG_STRUCT), 4, 4, (v), core_id)
#define RDD_SPDTEST_GEN_CFG_TEST_TYPE_READ(r, p)                                                RDP_FIELD_MREAD_8((uint8_t *)(p), 4, 4, (r))
#define RDD_SPDTEST_GEN_CFG_TEST_TYPE_WRITE(v, p)                                               RDP_FIELD_MWRITE_8((uint8_t *)(p), 4, 4, (v))
#define RDD_SPDTEST_GEN_CFG_IS_ON_READ_G(r, g, idx)                                             GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(SPDTEST_GEN_CFG_STRUCT), 3, 1, (r))
#define RDD_SPDTEST_GEN_CFG_IS_ON_WRITE_G(v, g, idx)                                            GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(SPDTEST_GEN_CFG_STRUCT), 3, 1, (v))
#define RDD_SPDTEST_GEN_CFG_IS_ON_READ_CORE(r, g, idx, core_id)                                 CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(SPDTEST_GEN_CFG_STRUCT), 3, 1, (r), core_id)
#define RDD_SPDTEST_GEN_CFG_IS_ON_WRITE_CORE(v, g, idx, core_id)                                CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(SPDTEST_GEN_CFG_STRUCT), 3, 1, (v), core_id)
#define RDD_SPDTEST_GEN_CFG_IS_ON_READ(r, p)                                                    RDP_FIELD_MREAD_8((uint8_t *)(p), 3, 1, (r))
#define RDD_SPDTEST_GEN_CFG_IS_ON_WRITE(v, p)                                                   RDP_FIELD_MWRITE_8((uint8_t *)(p), 3, 1, (v))
#define RDD_SPDTEST_GEN_CFG_IS_ENDLESS_TX_READ_G(r, g, idx)                                     GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(SPDTEST_GEN_CFG_STRUCT), 2, 1, (r))
#define RDD_SPDTEST_GEN_CFG_IS_ENDLESS_TX_WRITE_G(v, g, idx)                                    GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(SPDTEST_GEN_CFG_STRUCT), 2, 1, (v))
#define RDD_SPDTEST_GEN_CFG_IS_ENDLESS_TX_READ_CORE(r, g, idx, core_id)                         CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(SPDTEST_GEN_CFG_STRUCT), 2, 1, (r), core_id)
#define RDD_SPDTEST_GEN_CFG_IS_ENDLESS_TX_WRITE_CORE(v, g, idx, core_id)                        CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(SPDTEST_GEN_CFG_STRUCT), 2, 1, (v), core_id)
#define RDD_SPDTEST_GEN_CFG_IS_ENDLESS_TX_READ(r, p)                                            RDP_FIELD_MREAD_8((uint8_t *)(p), 2, 1, (r))
#define RDD_SPDTEST_GEN_CFG_IS_ENDLESS_TX_WRITE(v, p)                                           RDP_FIELD_MWRITE_8((uint8_t *)(p), 2, 1, (v))
#define RDD_SPDTEST_GEN_CFG_NOT_VALID_LICENSE_READ_G(r, g, idx)                                 GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(SPDTEST_GEN_CFG_STRUCT), 1, 1, (r))
#define RDD_SPDTEST_GEN_CFG_NOT_VALID_LICENSE_WRITE_G(v, g, idx)                                GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(SPDTEST_GEN_CFG_STRUCT), 1, 1, (v))
#define RDD_SPDTEST_GEN_CFG_NOT_VALID_LICENSE_READ_CORE(r, g, idx, core_id)                     CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(SPDTEST_GEN_CFG_STRUCT), 1, 1, (r), core_id)
#define RDD_SPDTEST_GEN_CFG_NOT_VALID_LICENSE_WRITE_CORE(v, g, idx, core_id)                    CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(SPDTEST_GEN_CFG_STRUCT), 1, 1, (v), core_id)
#define RDD_SPDTEST_GEN_CFG_NOT_VALID_LICENSE_READ(r, p)                                        RDP_FIELD_MREAD_8((uint8_t *)(p), 1, 1, (r))
#define RDD_SPDTEST_GEN_CFG_NOT_VALID_LICENSE_WRITE(v, p)                                       RDP_FIELD_MWRITE_8((uint8_t *)(p), 1, 1, (v))
#define RDD_SPDTEST_GEN_CFG_IPERF3_64BIT_PKTID_READ_G(r, g, idx)                                GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(SPDTEST_GEN_CFG_STRUCT), 0, 1, (r))
#define RDD_SPDTEST_GEN_CFG_IPERF3_64BIT_PKTID_WRITE_G(v, g, idx)                               GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(SPDTEST_GEN_CFG_STRUCT), 0, 1, (v))
#define RDD_SPDTEST_GEN_CFG_IPERF3_64BIT_PKTID_READ_CORE(r, g, idx, core_id)                    CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(SPDTEST_GEN_CFG_STRUCT), 0, 1, (r), core_id)
#define RDD_SPDTEST_GEN_CFG_IPERF3_64BIT_PKTID_WRITE_CORE(v, g, idx, core_id)                   CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(SPDTEST_GEN_CFG_STRUCT), 0, 1, (v), core_id)
#define RDD_SPDTEST_GEN_CFG_IPERF3_64BIT_PKTID_READ(r, p)                                       RDP_FIELD_MREAD_8((uint8_t *)(p), 0, 1, (r))
#define RDD_SPDTEST_GEN_CFG_IPERF3_64BIT_PKTID_WRITE(v, p)                                      RDP_FIELD_MWRITE_8((uint8_t *)(p), 0, 1, (v))
#define RDD_SPDTEST_GEN_CFG_INTERRUPT_ID_READ_G(r, g, idx)                                      GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(SPDTEST_GEN_CFG_STRUCT) + 1, 0, 5, (r))
#define RDD_SPDTEST_GEN_CFG_INTERRUPT_ID_WRITE_G(v, g, idx)                                     GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(SPDTEST_GEN_CFG_STRUCT) + 1, 0, 5, (v))
#define RDD_SPDTEST_GEN_CFG_INTERRUPT_ID_READ_CORE(r, g, idx, core_id)                          CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(SPDTEST_GEN_CFG_STRUCT) + 1, 0, 5, (r), core_id)
#define RDD_SPDTEST_GEN_CFG_INTERRUPT_ID_WRITE_CORE(v, g, idx, core_id)                         CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(SPDTEST_GEN_CFG_STRUCT) + 1, 0, 5, (v), core_id)
#define RDD_SPDTEST_GEN_CFG_INTERRUPT_ID_READ(r, p)                                             RDP_FIELD_MREAD_8((uint8_t *)(p) + 1, 0, 5, (r))
#define RDD_SPDTEST_GEN_CFG_INTERRUPT_ID_WRITE(v, p)                                            RDP_FIELD_MWRITE_8((uint8_t *)(p) + 1, 0, 5, (v))
/* <<<SPDTEST_GEN_CFG_STRUCT */


/* >>>UDPSPDT_TX_PARAMS_STRUCT */
typedef union
    {
    uint8_t word_8[24];
    uint16_t word_16[12];
    uint32_t word_32[6];
    uint64_t dword_64[3];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	total_num_of_pkts    	;
        uint16_t	packet_size          	;
        uint16_t	last_packet_size     	;
        uint32_t	curr_bucket          	;
        uint32_t	bucket_budget        	;
        uint32_t	last_packet_start_idx	;
        uint32_t	max_bucket_size      	;
#else
        uint32_t	total_num_of_pkts    	;
        uint16_t	last_packet_size     	;
        uint16_t	packet_size          	;
        uint32_t	curr_bucket          	;
        uint32_t	bucket_budget        	;
        uint32_t	last_packet_start_idx	;
        uint32_t	max_bucket_size      	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) UDPSPDT_TX_PARAMS_STRUCT;

#define RDD_UDPSPDT_TX_PARAMS_TOTAL_NUM_OF_PKTS_READ_G(r, g, idx)                                    GROUP_MREAD_32((g), (idx)*sizeof(UDPSPDT_TX_PARAMS_STRUCT), (r))
#define RDD_UDPSPDT_TX_PARAMS_TOTAL_NUM_OF_PKTS_WRITE_G(v, g, idx)                                   GROUP_MWRITE_32((g), (idx)*sizeof(UDPSPDT_TX_PARAMS_STRUCT), (v))
#define RDD_UDPSPDT_TX_PARAMS_TOTAL_NUM_OF_PKTS_READ_CORE(r, g, idx, core_id)                        CORE_MREAD_32((g), (idx)*sizeof(UDPSPDT_TX_PARAMS_STRUCT), (r), core_id)
#define RDD_UDPSPDT_TX_PARAMS_TOTAL_NUM_OF_PKTS_WRITE_CORE(v, g, idx, core_id)                       CORE_MWRITE_32((g), (idx)*sizeof(UDPSPDT_TX_PARAMS_STRUCT), (v), core_id)
#define RDD_UDPSPDT_TX_PARAMS_TOTAL_NUM_OF_PKTS_READ(r, p)                                           MREAD_32((uint8_t *)(p), (r))
#define RDD_UDPSPDT_TX_PARAMS_TOTAL_NUM_OF_PKTS_WRITE(v, p)                                          MWRITE_32((uint8_t *)(p), (v))
#define RDD_UDPSPDT_TX_PARAMS_PACKET_SIZE_READ_G(r, g, idx)                                          GROUP_MREAD_16((g), (idx)*sizeof(UDPSPDT_TX_PARAMS_STRUCT) + 4, (r))
#define RDD_UDPSPDT_TX_PARAMS_PACKET_SIZE_WRITE_G(v, g, idx)                                         GROUP_MWRITE_16((g), (idx)*sizeof(UDPSPDT_TX_PARAMS_STRUCT) + 4, (v))
#define RDD_UDPSPDT_TX_PARAMS_PACKET_SIZE_READ_CORE(r, g, idx, core_id)                              CORE_MREAD_16((g), (idx)*sizeof(UDPSPDT_TX_PARAMS_STRUCT) + 4, (r), core_id)
#define RDD_UDPSPDT_TX_PARAMS_PACKET_SIZE_WRITE_CORE(v, g, idx, core_id)                             CORE_MWRITE_16((g), (idx)*sizeof(UDPSPDT_TX_PARAMS_STRUCT) + 4, (v), core_id)
#define RDD_UDPSPDT_TX_PARAMS_PACKET_SIZE_READ(r, p)                                                 MREAD_16((uint8_t *)(p) + 4, (r))
#define RDD_UDPSPDT_TX_PARAMS_PACKET_SIZE_WRITE(v, p)                                                MWRITE_16((uint8_t *)(p) + 4, (v))
#define RDD_UDPSPDT_TX_PARAMS_LAST_PACKET_SIZE_READ_G(r, g, idx)                                     GROUP_MREAD_16((g), (idx)*sizeof(UDPSPDT_TX_PARAMS_STRUCT) + 6, (r))
#define RDD_UDPSPDT_TX_PARAMS_LAST_PACKET_SIZE_WRITE_G(v, g, idx)                                    GROUP_MWRITE_16((g), (idx)*sizeof(UDPSPDT_TX_PARAMS_STRUCT) + 6, (v))
#define RDD_UDPSPDT_TX_PARAMS_LAST_PACKET_SIZE_READ_CORE(r, g, idx, core_id)                         CORE_MREAD_16((g), (idx)*sizeof(UDPSPDT_TX_PARAMS_STRUCT) + 6, (r), core_id)
#define RDD_UDPSPDT_TX_PARAMS_LAST_PACKET_SIZE_WRITE_CORE(v, g, idx, core_id)                        CORE_MWRITE_16((g), (idx)*sizeof(UDPSPDT_TX_PARAMS_STRUCT) + 6, (v), core_id)
#define RDD_UDPSPDT_TX_PARAMS_LAST_PACKET_SIZE_READ(r, p)                                            MREAD_16((uint8_t *)(p) + 6, (r))
#define RDD_UDPSPDT_TX_PARAMS_LAST_PACKET_SIZE_WRITE(v, p)                                           MWRITE_16((uint8_t *)(p) + 6, (v))
#define RDD_UDPSPDT_TX_PARAMS_CURR_BUCKET_READ_G(r, g, idx)                                          GROUP_MREAD_32((g), (idx)*sizeof(UDPSPDT_TX_PARAMS_STRUCT) + 8, (r))
#define RDD_UDPSPDT_TX_PARAMS_CURR_BUCKET_WRITE_G(v, g, idx)                                         GROUP_MWRITE_32((g), (idx)*sizeof(UDPSPDT_TX_PARAMS_STRUCT) + 8, (v))
#define RDD_UDPSPDT_TX_PARAMS_CURR_BUCKET_READ_CORE(r, g, idx, core_id)                              CORE_MREAD_32((g), (idx)*sizeof(UDPSPDT_TX_PARAMS_STRUCT) + 8, (r), core_id)
#define RDD_UDPSPDT_TX_PARAMS_CURR_BUCKET_WRITE_CORE(v, g, idx, core_id)                             CORE_MWRITE_32((g), (idx)*sizeof(UDPSPDT_TX_PARAMS_STRUCT) + 8, (v), core_id)
#define RDD_UDPSPDT_TX_PARAMS_CURR_BUCKET_READ(r, p)                                                 MREAD_32((uint8_t *)(p) + 8, (r))
#define RDD_UDPSPDT_TX_PARAMS_CURR_BUCKET_WRITE(v, p)                                                MWRITE_32((uint8_t *)(p) + 8, (v))
#define RDD_UDPSPDT_TX_PARAMS_BUCKET_BUDGET_READ_G(r, g, idx)                                        GROUP_MREAD_32((g), (idx)*sizeof(UDPSPDT_TX_PARAMS_STRUCT) + 12, (r))
#define RDD_UDPSPDT_TX_PARAMS_BUCKET_BUDGET_WRITE_G(v, g, idx)                                       GROUP_MWRITE_32((g), (idx)*sizeof(UDPSPDT_TX_PARAMS_STRUCT) + 12, (v))
#define RDD_UDPSPDT_TX_PARAMS_BUCKET_BUDGET_READ_CORE(r, g, idx, core_id)                            CORE_MREAD_32((g), (idx)*sizeof(UDPSPDT_TX_PARAMS_STRUCT) + 12, (r), core_id)
#define RDD_UDPSPDT_TX_PARAMS_BUCKET_BUDGET_WRITE_CORE(v, g, idx, core_id)                           CORE_MWRITE_32((g), (idx)*sizeof(UDPSPDT_TX_PARAMS_STRUCT) + 12, (v), core_id)
#define RDD_UDPSPDT_TX_PARAMS_BUCKET_BUDGET_READ(r, p)                                               MREAD_32((uint8_t *)(p) + 12, (r))
#define RDD_UDPSPDT_TX_PARAMS_BUCKET_BUDGET_WRITE(v, p)                                              MWRITE_32((uint8_t *)(p) + 12, (v))
#define RDD_UDPSPDT_TX_PARAMS_LAST_PACKET_START_IDX_READ_G(r, g, idx)                                GROUP_MREAD_32((g), (idx)*sizeof(UDPSPDT_TX_PARAMS_STRUCT) + 16, (r))
#define RDD_UDPSPDT_TX_PARAMS_LAST_PACKET_START_IDX_WRITE_G(v, g, idx)                               GROUP_MWRITE_32((g), (idx)*sizeof(UDPSPDT_TX_PARAMS_STRUCT) + 16, (v))
#define RDD_UDPSPDT_TX_PARAMS_LAST_PACKET_START_IDX_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_32((g), (idx)*sizeof(UDPSPDT_TX_PARAMS_STRUCT) + 16, (r), core_id)
#define RDD_UDPSPDT_TX_PARAMS_LAST_PACKET_START_IDX_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_32((g), (idx)*sizeof(UDPSPDT_TX_PARAMS_STRUCT) + 16, (v), core_id)
#define RDD_UDPSPDT_TX_PARAMS_LAST_PACKET_START_IDX_READ(r, p)                                       MREAD_32((uint8_t *)(p) + 16, (r))
#define RDD_UDPSPDT_TX_PARAMS_LAST_PACKET_START_IDX_WRITE(v, p)                                      MWRITE_32((uint8_t *)(p) + 16, (v))
#define RDD_UDPSPDT_TX_PARAMS_MAX_BUCKET_SIZE_READ_G(r, g, idx)                                      GROUP_MREAD_32((g), (idx)*sizeof(UDPSPDT_TX_PARAMS_STRUCT) + 20, (r))
#define RDD_UDPSPDT_TX_PARAMS_MAX_BUCKET_SIZE_WRITE_G(v, g, idx)                                     GROUP_MWRITE_32((g), (idx)*sizeof(UDPSPDT_TX_PARAMS_STRUCT) + 20, (v))
#define RDD_UDPSPDT_TX_PARAMS_MAX_BUCKET_SIZE_READ_CORE(r, g, idx, core_id)                          CORE_MREAD_32((g), (idx)*sizeof(UDPSPDT_TX_PARAMS_STRUCT) + 20, (r), core_id)
#define RDD_UDPSPDT_TX_PARAMS_MAX_BUCKET_SIZE_WRITE_CORE(v, g, idx, core_id)                         CORE_MWRITE_32((g), (idx)*sizeof(UDPSPDT_TX_PARAMS_STRUCT) + 20, (v), core_id)
#define RDD_UDPSPDT_TX_PARAMS_MAX_BUCKET_SIZE_READ(r, p)                                             MREAD_32((uint8_t *)(p) + 20, (r))
#define RDD_UDPSPDT_TX_PARAMS_MAX_BUCKET_SIZE_WRITE(v, p)                                            MWRITE_32((uint8_t *)(p) + 20, (v))
/* <<<UDPSPDT_TX_PARAMS_STRUCT */


/* >>>UDPSPDT_STREAM_TX_STAT_STRUCT */
typedef union
    {
    uint8_t word_8[40];
    uint16_t word_16[20];
    uint32_t word_32[10];
    uint64_t dword_64[5];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	tx_packets_1               	;
        uint32_t	tx_packets_0               	;
        uint32_t	tx_drops_no_spbm           	;
        uint32_t	first_ts                   	;
        uint32_t	last_ts_1                  	;
        uint32_t	last_ts_0                  	;
        uint32_t	iperf3_ts_sec              	;
        uint32_t	iperf3_ts_usec             	;
        uint16_t	bad_proto_cntr             	;
        uint16_t	time_slice_expire          	;
        uint16_t	tx_drops_no_sbpm_timer_stop	;
        uint32_t	reserved                   	:15	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	first_ts_set               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#else
        uint32_t	tx_packets_1               	;
        uint32_t	tx_packets_0               	;
        uint32_t	tx_drops_no_spbm           	;
        uint32_t	first_ts                   	;
        uint32_t	last_ts_1                  	;
        uint32_t	last_ts_0                  	;
        uint32_t	iperf3_ts_sec              	;
        uint32_t	iperf3_ts_usec             	;
        uint16_t	time_slice_expire          	;
        uint16_t	bad_proto_cntr             	;
        uint32_t	first_ts_set               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved                   	:15	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	tx_drops_no_sbpm_timer_stop	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) UDPSPDT_STREAM_TX_STAT_STRUCT;

#define RDD_UDPSPDT_STREAM_TX_STAT_TX_PACKETS_1_READ_G(r, g, idx)                                               GROUP_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT), (r))
#define RDD_UDPSPDT_STREAM_TX_STAT_TX_PACKETS_1_WRITE_G(v, g, idx)                                              GROUP_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT), (v))
#define RDD_UDPSPDT_STREAM_TX_STAT_TX_PACKETS_1_READ_CORE(r, g, idx, core_id)                                   CORE_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT), (r), core_id)
#define RDD_UDPSPDT_STREAM_TX_STAT_TX_PACKETS_1_WRITE_CORE(v, g, idx, core_id)                                  CORE_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT), (v), core_id)
#define RDD_UDPSPDT_STREAM_TX_STAT_TX_PACKETS_1_READ(r, p)                                                      MREAD_32((uint8_t *)(p), (r))
#define RDD_UDPSPDT_STREAM_TX_STAT_TX_PACKETS_1_WRITE(v, p)                                                     MWRITE_32((uint8_t *)(p), (v))
#define RDD_UDPSPDT_STREAM_TX_STAT_TX_PACKETS_0_READ_G(r, g, idx)                                               GROUP_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 4, (r))
#define RDD_UDPSPDT_STREAM_TX_STAT_TX_PACKETS_0_WRITE_G(v, g, idx)                                              GROUP_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 4, (v))
#define RDD_UDPSPDT_STREAM_TX_STAT_TX_PACKETS_0_READ_CORE(r, g, idx, core_id)                                   CORE_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 4, (r), core_id)
#define RDD_UDPSPDT_STREAM_TX_STAT_TX_PACKETS_0_WRITE_CORE(v, g, idx, core_id)                                  CORE_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 4, (v), core_id)
#define RDD_UDPSPDT_STREAM_TX_STAT_TX_PACKETS_0_READ(r, p)                                                      MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_UDPSPDT_STREAM_TX_STAT_TX_PACKETS_0_WRITE(v, p)                                                     MWRITE_32((uint8_t *)(p) + 4, (v))
#define RDD_UDPSPDT_STREAM_TX_STAT_TX_DROPS_NO_SPBM_READ_G(r, g, idx)                                           GROUP_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 8, (r))
#define RDD_UDPSPDT_STREAM_TX_STAT_TX_DROPS_NO_SPBM_WRITE_G(v, g, idx)                                          GROUP_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 8, (v))
#define RDD_UDPSPDT_STREAM_TX_STAT_TX_DROPS_NO_SPBM_READ_CORE(r, g, idx, core_id)                               CORE_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 8, (r), core_id)
#define RDD_UDPSPDT_STREAM_TX_STAT_TX_DROPS_NO_SPBM_WRITE_CORE(v, g, idx, core_id)                              CORE_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 8, (v), core_id)
#define RDD_UDPSPDT_STREAM_TX_STAT_TX_DROPS_NO_SPBM_READ(r, p)                                                  MREAD_32((uint8_t *)(p) + 8, (r))
#define RDD_UDPSPDT_STREAM_TX_STAT_TX_DROPS_NO_SPBM_WRITE(v, p)                                                 MWRITE_32((uint8_t *)(p) + 8, (v))
#define RDD_UDPSPDT_STREAM_TX_STAT_FIRST_TS_READ_G(r, g, idx)                                                   GROUP_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 12, (r))
#define RDD_UDPSPDT_STREAM_TX_STAT_FIRST_TS_WRITE_G(v, g, idx)                                                  GROUP_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 12, (v))
#define RDD_UDPSPDT_STREAM_TX_STAT_FIRST_TS_READ_CORE(r, g, idx, core_id)                                       CORE_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 12, (r), core_id)
#define RDD_UDPSPDT_STREAM_TX_STAT_FIRST_TS_WRITE_CORE(v, g, idx, core_id)                                      CORE_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 12, (v), core_id)
#define RDD_UDPSPDT_STREAM_TX_STAT_FIRST_TS_READ(r, p)                                                          MREAD_32((uint8_t *)(p) + 12, (r))
#define RDD_UDPSPDT_STREAM_TX_STAT_FIRST_TS_WRITE(v, p)                                                         MWRITE_32((uint8_t *)(p) + 12, (v))
#define RDD_UDPSPDT_STREAM_TX_STAT_LAST_TS_1_READ_G(r, g, idx)                                                  GROUP_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 16, (r))
#define RDD_UDPSPDT_STREAM_TX_STAT_LAST_TS_1_WRITE_G(v, g, idx)                                                 GROUP_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 16, (v))
#define RDD_UDPSPDT_STREAM_TX_STAT_LAST_TS_1_READ_CORE(r, g, idx, core_id)                                      CORE_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 16, (r), core_id)
#define RDD_UDPSPDT_STREAM_TX_STAT_LAST_TS_1_WRITE_CORE(v, g, idx, core_id)                                     CORE_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 16, (v), core_id)
#define RDD_UDPSPDT_STREAM_TX_STAT_LAST_TS_1_READ(r, p)                                                         MREAD_32((uint8_t *)(p) + 16, (r))
#define RDD_UDPSPDT_STREAM_TX_STAT_LAST_TS_1_WRITE(v, p)                                                        MWRITE_32((uint8_t *)(p) + 16, (v))
#define RDD_UDPSPDT_STREAM_TX_STAT_LAST_TS_0_READ_G(r, g, idx)                                                  GROUP_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 20, (r))
#define RDD_UDPSPDT_STREAM_TX_STAT_LAST_TS_0_WRITE_G(v, g, idx)                                                 GROUP_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 20, (v))
#define RDD_UDPSPDT_STREAM_TX_STAT_LAST_TS_0_READ_CORE(r, g, idx, core_id)                                      CORE_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 20, (r), core_id)
#define RDD_UDPSPDT_STREAM_TX_STAT_LAST_TS_0_WRITE_CORE(v, g, idx, core_id)                                     CORE_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 20, (v), core_id)
#define RDD_UDPSPDT_STREAM_TX_STAT_LAST_TS_0_READ(r, p)                                                         MREAD_32((uint8_t *)(p) + 20, (r))
#define RDD_UDPSPDT_STREAM_TX_STAT_LAST_TS_0_WRITE(v, p)                                                        MWRITE_32((uint8_t *)(p) + 20, (v))
#define RDD_UDPSPDT_STREAM_TX_STAT_IPERF3_TS_SEC_READ_G(r, g, idx)                                              GROUP_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 24, (r))
#define RDD_UDPSPDT_STREAM_TX_STAT_IPERF3_TS_SEC_WRITE_G(v, g, idx)                                             GROUP_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 24, (v))
#define RDD_UDPSPDT_STREAM_TX_STAT_IPERF3_TS_SEC_READ_CORE(r, g, idx, core_id)                                  CORE_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 24, (r), core_id)
#define RDD_UDPSPDT_STREAM_TX_STAT_IPERF3_TS_SEC_WRITE_CORE(v, g, idx, core_id)                                 CORE_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 24, (v), core_id)
#define RDD_UDPSPDT_STREAM_TX_STAT_IPERF3_TS_SEC_READ(r, p)                                                     MREAD_32((uint8_t *)(p) + 24, (r))
#define RDD_UDPSPDT_STREAM_TX_STAT_IPERF3_TS_SEC_WRITE(v, p)                                                    MWRITE_32((uint8_t *)(p) + 24, (v))
#define RDD_UDPSPDT_STREAM_TX_STAT_IPERF3_TS_USEC_READ_G(r, g, idx)                                             GROUP_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 28, (r))
#define RDD_UDPSPDT_STREAM_TX_STAT_IPERF3_TS_USEC_WRITE_G(v, g, idx)                                            GROUP_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 28, (v))
#define RDD_UDPSPDT_STREAM_TX_STAT_IPERF3_TS_USEC_READ_CORE(r, g, idx, core_id)                                 CORE_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 28, (r), core_id)
#define RDD_UDPSPDT_STREAM_TX_STAT_IPERF3_TS_USEC_WRITE_CORE(v, g, idx, core_id)                                CORE_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 28, (v), core_id)
#define RDD_UDPSPDT_STREAM_TX_STAT_IPERF3_TS_USEC_READ(r, p)                                                    MREAD_32((uint8_t *)(p) + 28, (r))
#define RDD_UDPSPDT_STREAM_TX_STAT_IPERF3_TS_USEC_WRITE(v, p)                                                   MWRITE_32((uint8_t *)(p) + 28, (v))
#define RDD_UDPSPDT_STREAM_TX_STAT_BAD_PROTO_CNTR_READ_G(r, g, idx)                                             GROUP_MREAD_16((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 32, (r))
#define RDD_UDPSPDT_STREAM_TX_STAT_BAD_PROTO_CNTR_WRITE_G(v, g, idx)                                            GROUP_MWRITE_16((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 32, (v))
#define RDD_UDPSPDT_STREAM_TX_STAT_BAD_PROTO_CNTR_READ_CORE(r, g, idx, core_id)                                 CORE_MREAD_16((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 32, (r), core_id)
#define RDD_UDPSPDT_STREAM_TX_STAT_BAD_PROTO_CNTR_WRITE_CORE(v, g, idx, core_id)                                CORE_MWRITE_16((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 32, (v), core_id)
#define RDD_UDPSPDT_STREAM_TX_STAT_BAD_PROTO_CNTR_READ(r, p)                                                    MREAD_16((uint8_t *)(p) + 32, (r))
#define RDD_UDPSPDT_STREAM_TX_STAT_BAD_PROTO_CNTR_WRITE(v, p)                                                   MWRITE_16((uint8_t *)(p) + 32, (v))
#define RDD_UDPSPDT_STREAM_TX_STAT_TIME_SLICE_EXPIRE_READ_G(r, g, idx)                                          GROUP_MREAD_16((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 34, (r))
#define RDD_UDPSPDT_STREAM_TX_STAT_TIME_SLICE_EXPIRE_WRITE_G(v, g, idx)                                         GROUP_MWRITE_16((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 34, (v))
#define RDD_UDPSPDT_STREAM_TX_STAT_TIME_SLICE_EXPIRE_READ_CORE(r, g, idx, core_id)                              CORE_MREAD_16((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 34, (r), core_id)
#define RDD_UDPSPDT_STREAM_TX_STAT_TIME_SLICE_EXPIRE_WRITE_CORE(v, g, idx, core_id)                             CORE_MWRITE_16((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 34, (v), core_id)
#define RDD_UDPSPDT_STREAM_TX_STAT_TIME_SLICE_EXPIRE_READ(r, p)                                                 MREAD_16((uint8_t *)(p) + 34, (r))
#define RDD_UDPSPDT_STREAM_TX_STAT_TIME_SLICE_EXPIRE_WRITE(v, p)                                                MWRITE_16((uint8_t *)(p) + 34, (v))
#define RDD_UDPSPDT_STREAM_TX_STAT_TX_DROPS_NO_SBPM_TIMER_STOP_READ_G(r, g, idx)                                GROUP_MREAD_16((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 36, (r))
#define RDD_UDPSPDT_STREAM_TX_STAT_TX_DROPS_NO_SBPM_TIMER_STOP_WRITE_G(v, g, idx)                               GROUP_MWRITE_16((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 36, (v))
#define RDD_UDPSPDT_STREAM_TX_STAT_TX_DROPS_NO_SBPM_TIMER_STOP_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_16((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 36, (r), core_id)
#define RDD_UDPSPDT_STREAM_TX_STAT_TX_DROPS_NO_SBPM_TIMER_STOP_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_16((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 36, (v), core_id)
#define RDD_UDPSPDT_STREAM_TX_STAT_TX_DROPS_NO_SBPM_TIMER_STOP_READ(r, p)                                       MREAD_16((uint8_t *)(p) + 36, (r))
#define RDD_UDPSPDT_STREAM_TX_STAT_TX_DROPS_NO_SBPM_TIMER_STOP_WRITE(v, p)                                      MWRITE_16((uint8_t *)(p) + 36, (v))
#define RDD_UDPSPDT_STREAM_TX_STAT_FIRST_TS_SET_READ_G(r, g, idx)                                               GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 39, 0, 1, (r))
#define RDD_UDPSPDT_STREAM_TX_STAT_FIRST_TS_SET_WRITE_G(v, g, idx)                                              GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 39, 0, 1, (v))
#define RDD_UDPSPDT_STREAM_TX_STAT_FIRST_TS_SET_READ_CORE(r, g, idx, core_id)                                   CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 39, 0, 1, (r), core_id)
#define RDD_UDPSPDT_STREAM_TX_STAT_FIRST_TS_SET_WRITE_CORE(v, g, idx, core_id)                                  CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 39, 0, 1, (v), core_id)
#define RDD_UDPSPDT_STREAM_TX_STAT_FIRST_TS_SET_READ(r, p)                                                      RDP_FIELD_MREAD_8((uint8_t *)(p) + 39, 0, 1, (r))
#define RDD_UDPSPDT_STREAM_TX_STAT_FIRST_TS_SET_WRITE(v, p)                                                     RDP_FIELD_MWRITE_8((uint8_t *)(p) + 39, 0, 1, (v))
/* <<<UDPSPDT_STREAM_TX_STAT_STRUCT */


/* >>>PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT */
typedef union
    {
    uint8_t word_8[16];
    uint16_t word_16[8];
    uint32_t word_32[4];
    uint64_t dword_64[2];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
	/* Union WORD 0 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	valid                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	headroom             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	dont_agg             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	mc_copy              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reprocess            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	color                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	force_copy           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	spdsvc_type          	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	l3_offset_or_buff_allocated	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	first_level_q        	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	flag_1588_or_dsl_rx  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	coherent             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	spdtest_stream_id    	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	tcpspdtest_is_upload 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved1            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 1 */
		struct{
        uint32_t	reservedSU1_valid              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_headroom           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_dont_agg           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_mc_copy            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_reprocess          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_color              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_force_copy         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_spdsvc_type        	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	l3_offset                      	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of l3_offset_or_buff_allocated union */
        uint32_t	reservedSU1_first_level_q      	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	flag_1588                      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of flag_1588_or_dsl_rx union */
        uint32_t	reservedSU1_coherent           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_spdtest_stream_id  	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_tcpspdtest_is_upload	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_reserved1          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 2 */
		struct{
        uint32_t	reservedSU2_valid              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_headroom           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_dont_agg           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_mc_copy            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_reprocess          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_color              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_force_copy         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_spdsvc_type        	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	pktgen_buff_allocated          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of l3_offset_or_buff_allocated union */
        uint32_t	reserved0                      	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of l3_offset_or_buff_allocated union */
        uint32_t	reservedSU2_first_level_q      	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	dsl_rx                         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of flag_1588_or_dsl_rx union */
        uint32_t	reservedSU2_coherent           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_spdtest_stream_id  	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_tcpspdtest_is_upload	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_reserved1          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
	/* Union WORD 1 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	reserved2            	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	spdtest_l3_l4_hdr_len	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	priority             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ingress_cong         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	abs                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved3            	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	packet_length        	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
	/* Union WORD 2 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	drop                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	target_mem_1         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved4            	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_emac              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	eh                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ingress_vport        	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved5            	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	bn1_or_abs1          	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
		};
		/* Sub Union 1 */
		struct{
        uint32_t	reservedSU1_drop               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_target_mem_1       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_reserved4          	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_is_emac            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_eh                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_ingress_vport      	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_reserved5          	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	bn1_first                      	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of bn1_or_abs1 union */
		};
		/* Sub Union 2 */
		struct{
        uint32_t	reservedSU2_drop               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_target_mem_1       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_reserved4          	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_is_emac            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_eh                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_ingress_vport      	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_reserved5          	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved6                      	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of bn1_or_abs1 union */
        uint32_t	abs1                           	:11	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of bn1_or_abs1 union */
		};
	};
	/* Union WORD 3 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	agg_pd               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	target_mem_0         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	payload_offset_sop   	:30	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
		};
		/* Sub Union 1 */
		struct{
        uint32_t	reservedSU1_agg_pd             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_target_mem_0       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	sop_fpm                        	:10	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of payload_offset_sop union */
        uint32_t	fpm_pool                       	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of payload_offset_sop union */
        uint32_t	fpm_num                        	:18	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of payload_offset_sop union */
		};
		/* Sub Union 2 */
		struct{
        uint32_t	reservedSU2_agg_pd             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_target_mem_0       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	bn_num                         	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of payload_offset_sop union */
        uint32_t	sop                            	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of payload_offset_sop union */
        uint16_t	bn0_first                      	; /* Member of payload_offset_sop union */
		};
		/* Sub Union 3 */
		struct{
        uint32_t	reservedSU3_agg_pd             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_target_mem_0       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved7                      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of payload_offset_sop union */
        uint32_t	abs0                           	:29	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of payload_offset_sop union */
		};
	};
#else
	/* Union WORD 0 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	reserved1            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	tcpspdtest_is_upload 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	spdtest_stream_id    	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	coherent             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	flag_1588_or_dsl_rx  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	first_level_q        	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	l3_offset_or_buff_allocated	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	spdsvc_type          	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	force_copy           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	color                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reprocess            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	mc_copy              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	dont_agg             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	headroom             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	valid                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 1 */
		struct{
        uint32_t	reservedSU1_reserved1          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_tcpspdtest_is_upload	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_spdtest_stream_id  	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_coherent           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	flag_1588                      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of flag_1588_or_dsl_rx union */
        uint32_t	reservedSU1_first_level_q      	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	l3_offset                      	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of l3_offset_or_buff_allocated union */
        uint32_t	reservedSU1_spdsvc_type        	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_force_copy         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_color              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_reprocess          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_mc_copy            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_dont_agg           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_headroom           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_valid              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 2 */
		struct{
        uint32_t	reservedSU2_reserved1          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_tcpspdtest_is_upload	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_spdtest_stream_id  	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_coherent           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	dsl_rx                         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of flag_1588_or_dsl_rx union */
        uint32_t	reservedSU2_first_level_q      	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved0                      	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of l3_offset_or_buff_allocated union */
        uint32_t	pktgen_buff_allocated          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of l3_offset_or_buff_allocated union */
        uint32_t	reservedSU2_spdsvc_type        	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_force_copy         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_color              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_reprocess          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_mc_copy            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_dont_agg           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_headroom           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_valid              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
	/* Union WORD 1 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	packet_length        	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved3            	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	abs                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ingress_cong         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	priority             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	spdtest_l3_l4_hdr_len	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved2            	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
	/* Union WORD 2 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	bn1_or_abs1          	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	reserved5            	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ingress_vport        	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	eh                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_emac              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved4            	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	target_mem_1         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	drop                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 1 */
		struct{
        uint32_t	bn1_first                      	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of bn1_or_abs1 union */
        uint32_t	reservedSU1_reserved5          	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_ingress_vport      	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_eh                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_is_emac            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_reserved4          	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_target_mem_1       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_drop               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 2 */
		struct{
        uint32_t	abs1                           	:11	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of bn1_or_abs1 union */
        uint32_t	reserved6                      	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of bn1_or_abs1 union */
        uint32_t	reservedSU2_reserved5          	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_ingress_vport      	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_eh                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_is_emac            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_reserved4          	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_target_mem_1       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_drop               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
	/* Union WORD 3 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	payload_offset_sop   	:30	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	target_mem_0         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	agg_pd               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 1 */
		struct{
        uint32_t	fpm_num                        	:18	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of payload_offset_sop union */
        uint32_t	fpm_pool                       	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of payload_offset_sop union */
        uint32_t	sop_fpm                        	:10	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of payload_offset_sop union */
        uint32_t	reservedSU1_target_mem_0       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_agg_pd             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 2 */
		struct{
        uint16_t	bn0_first                      	; /* Member of payload_offset_sop union */
        uint32_t	sop                            	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of payload_offset_sop union */
        uint32_t	bn_num                         	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of payload_offset_sop union */
        uint32_t	reservedSU2_target_mem_0       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_agg_pd             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 3 */
		struct{
        uint32_t	abs0                           	:29	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of payload_offset_sop union */
        uint32_t	reserved7                      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of payload_offset_sop union */
        uint32_t	reservedSU3_target_mem_0       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_agg_pd             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT;

#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_VALID_READ_G(r, g, idx)                                                GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT), 7, 1, (r))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_VALID_WRITE_G(v, g, idx)                                               GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT), 7, 1, (v))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_VALID_READ_CORE(r, g, idx, core_id)                                    CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT), 7, 1, (r), core_id)
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_VALID_WRITE_CORE(v, g, idx, core_id)                                   CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT), 7, 1, (v), core_id)
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_VALID_READ(r, p)                                                       RDP_FIELD_MREAD_8((uint8_t *)(p), 7, 1, (r))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_VALID_WRITE(v, p)                                                      RDP_FIELD_MWRITE_8((uint8_t *)(p), 7, 1, (v))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_HEADROOM_READ_G(r, g, idx)                                             GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT), 6, 1, (r))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_HEADROOM_WRITE_G(v, g, idx)                                            GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT), 6, 1, (v))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_HEADROOM_READ_CORE(r, g, idx, core_id)                                 CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT), 6, 1, (r), core_id)
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_HEADROOM_WRITE_CORE(v, g, idx, core_id)                                CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT), 6, 1, (v), core_id)
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_HEADROOM_READ(r, p)                                                    RDP_FIELD_MREAD_8((uint8_t *)(p), 6, 1, (r))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_HEADROOM_WRITE(v, p)                                                   RDP_FIELD_MWRITE_8((uint8_t *)(p), 6, 1, (v))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_DONT_AGG_READ_G(r, g, idx)                                             GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT), 5, 1, (r))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_DONT_AGG_WRITE_G(v, g, idx)                                            GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT), 5, 1, (v))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_DONT_AGG_READ_CORE(r, g, idx, core_id)                                 CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT), 5, 1, (r), core_id)
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_DONT_AGG_WRITE_CORE(v, g, idx, core_id)                                CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT), 5, 1, (v), core_id)
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_DONT_AGG_READ(r, p)                                                    RDP_FIELD_MREAD_8((uint8_t *)(p), 5, 1, (r))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_DONT_AGG_WRITE(v, p)                                                   RDP_FIELD_MWRITE_8((uint8_t *)(p), 5, 1, (v))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_MC_COPY_READ_G(r, g, idx)                                              GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT), 4, 1, (r))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_MC_COPY_WRITE_G(v, g, idx)                                             GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT), 4, 1, (v))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_MC_COPY_READ_CORE(r, g, idx, core_id)                                  CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT), 4, 1, (r), core_id)
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_MC_COPY_WRITE_CORE(v, g, idx, core_id)                                 CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT), 4, 1, (v), core_id)
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_MC_COPY_READ(r, p)                                                     RDP_FIELD_MREAD_8((uint8_t *)(p), 4, 1, (r))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_MC_COPY_WRITE(v, p)                                                    RDP_FIELD_MWRITE_8((uint8_t *)(p), 4, 1, (v))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_REPROCESS_READ_G(r, g, idx)                                            GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT), 3, 1, (r))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_REPROCESS_WRITE_G(v, g, idx)                                           GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT), 3, 1, (v))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_REPROCESS_READ_CORE(r, g, idx, core_id)                                CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT), 3, 1, (r), core_id)
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_REPROCESS_WRITE_CORE(v, g, idx, core_id)                               CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT), 3, 1, (v), core_id)
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_REPROCESS_READ(r, p)                                                   RDP_FIELD_MREAD_8((uint8_t *)(p), 3, 1, (r))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_REPROCESS_WRITE(v, p)                                                  RDP_FIELD_MWRITE_8((uint8_t *)(p), 3, 1, (v))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_COLOR_READ_G(r, g, idx)                                                GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT), 2, 1, (r))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_COLOR_WRITE_G(v, g, idx)                                               GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT), 2, 1, (v))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_COLOR_READ_CORE(r, g, idx, core_id)                                    CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT), 2, 1, (r), core_id)
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_COLOR_WRITE_CORE(v, g, idx, core_id)                                   CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT), 2, 1, (v), core_id)
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_COLOR_READ(r, p)                                                       RDP_FIELD_MREAD_8((uint8_t *)(p), 2, 1, (r))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_COLOR_WRITE(v, p)                                                      RDP_FIELD_MWRITE_8((uint8_t *)(p), 2, 1, (v))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_FORCE_COPY_READ_G(r, g, idx)                                           GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT), 1, 1, (r))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_FORCE_COPY_WRITE_G(v, g, idx)                                          GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT), 1, 1, (v))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_FORCE_COPY_READ_CORE(r, g, idx, core_id)                               CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT), 1, 1, (r), core_id)
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_FORCE_COPY_WRITE_CORE(v, g, idx, core_id)                              CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT), 1, 1, (v), core_id)
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_FORCE_COPY_READ(r, p)                                                  RDP_FIELD_MREAD_8((uint8_t *)(p), 1, 1, (r))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_FORCE_COPY_WRITE(v, p)                                                 RDP_FIELD_MWRITE_8((uint8_t *)(p), 1, 1, (v))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_SPDSVC_TYPE_READ_G(r, g, idx)                                          GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT), 6, 3, (r))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_SPDSVC_TYPE_WRITE_G(v, g, idx)                                         GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT), 6, 3, (v))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_SPDSVC_TYPE_READ_CORE(r, g, idx, core_id)                              CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT), 6, 3, (r), core_id)
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_SPDSVC_TYPE_WRITE_CORE(v, g, idx, core_id)                             CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT), 6, 3, (v), core_id)
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_SPDSVC_TYPE_READ(r, p)                                                 RDP_FIELD_MREAD_16((uint8_t *)(p), 6, 3, (r))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_SPDSVC_TYPE_WRITE(v, p)                                                RDP_FIELD_MWRITE_16((uint8_t *)(p), 6, 3, (v))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_L3_OFFSET_OR_BUFF_ALLOCATED_READ_G(r, g, idx)                          GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 1, 0, 6, (r))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_L3_OFFSET_OR_BUFF_ALLOCATED_WRITE_G(v, g, idx)                         GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 1, 0, 6, (v))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_L3_OFFSET_OR_BUFF_ALLOCATED_READ_CORE(r, g, idx, core_id)              CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 1, 0, 6, (r), core_id)
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_L3_OFFSET_OR_BUFF_ALLOCATED_WRITE_CORE(v, g, idx, core_id)             CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 1, 0, 6, (v), core_id)
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_L3_OFFSET_OR_BUFF_ALLOCATED_READ(r, p)                                 RDP_FIELD_MREAD_8((uint8_t *)(p) + 1, 0, 6, (r))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_L3_OFFSET_OR_BUFF_ALLOCATED_WRITE(v, p)                                RDP_FIELD_MWRITE_8((uint8_t *)(p) + 1, 0, 6, (v))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_L3_OFFSET_READ_G(r, g, idx)                                            GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 1, 0, 6, (r))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_L3_OFFSET_WRITE_G(v, g, idx)                                           GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 1, 0, 6, (v))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_L3_OFFSET_READ_CORE(r, g, idx, core_id)                                CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 1, 0, 6, (r), core_id)
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_L3_OFFSET_WRITE_CORE(v, g, idx, core_id)                               CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 1, 0, 6, (v), core_id)
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_L3_OFFSET_READ(r, p)                                                   RDP_FIELD_MREAD_8((uint8_t *)(p) + 1, 0, 6, (r))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_L3_OFFSET_WRITE(v, p)                                                  RDP_FIELD_MWRITE_8((uint8_t *)(p) + 1, 0, 6, (v))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_PKTGEN_BUFF_ALLOCATED_READ_G(r, g, idx)                                GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 1, 5, 1, (r))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_PKTGEN_BUFF_ALLOCATED_WRITE_G(v, g, idx)                               GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 1, 5, 1, (v))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_PKTGEN_BUFF_ALLOCATED_READ_CORE(r, g, idx, core_id)                    CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 1, 5, 1, (r), core_id)
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_PKTGEN_BUFF_ALLOCATED_WRITE_CORE(v, g, idx, core_id)                   CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 1, 5, 1, (v), core_id)
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_PKTGEN_BUFF_ALLOCATED_READ(r, p)                                       RDP_FIELD_MREAD_8((uint8_t *)(p) + 1, 5, 1, (r))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_PKTGEN_BUFF_ALLOCATED_WRITE(v, p)                                      RDP_FIELD_MWRITE_8((uint8_t *)(p) + 1, 5, 1, (v))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_FIRST_LEVEL_Q_READ_G(r, g, idx)                                        GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 2, 7, 9, (r))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_FIRST_LEVEL_Q_WRITE_G(v, g, idx)                                       GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 2, 7, 9, (v))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_FIRST_LEVEL_Q_READ_CORE(r, g, idx, core_id)                            CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 2, 7, 9, (r), core_id)
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_FIRST_LEVEL_Q_WRITE_CORE(v, g, idx, core_id)                           CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 2, 7, 9, (v), core_id)
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_FIRST_LEVEL_Q_READ(r, p)                                               RDP_FIELD_MREAD_16((uint8_t *)(p) + 2, 7, 9, (r))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_FIRST_LEVEL_Q_WRITE(v, p)                                              RDP_FIELD_MWRITE_16((uint8_t *)(p) + 2, 7, 9, (v))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_FLAG_1588_OR_DSL_RX_READ_G(r, g, idx)                                  GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 3, 6, 1, (r))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_FLAG_1588_OR_DSL_RX_WRITE_G(v, g, idx)                                 GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 3, 6, 1, (v))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_FLAG_1588_OR_DSL_RX_READ_CORE(r, g, idx, core_id)                      CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 3, 6, 1, (r), core_id)
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_FLAG_1588_OR_DSL_RX_WRITE_CORE(v, g, idx, core_id)                     CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 3, 6, 1, (v), core_id)
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_FLAG_1588_OR_DSL_RX_READ(r, p)                                         RDP_FIELD_MREAD_8((uint8_t *)(p) + 3, 6, 1, (r))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_FLAG_1588_OR_DSL_RX_WRITE(v, p)                                        RDP_FIELD_MWRITE_8((uint8_t *)(p) + 3, 6, 1, (v))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_FLAG_1588_READ_G(r, g, idx)                                            GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 3, 6, 1, (r))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_FLAG_1588_WRITE_G(v, g, idx)                                           GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 3, 6, 1, (v))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_FLAG_1588_READ_CORE(r, g, idx, core_id)                                CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 3, 6, 1, (r), core_id)
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_FLAG_1588_WRITE_CORE(v, g, idx, core_id)                               CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 3, 6, 1, (v), core_id)
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_FLAG_1588_READ(r, p)                                                   RDP_FIELD_MREAD_8((uint8_t *)(p) + 3, 6, 1, (r))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_FLAG_1588_WRITE(v, p)                                                  RDP_FIELD_MWRITE_8((uint8_t *)(p) + 3, 6, 1, (v))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_DSL_RX_READ_G(r, g, idx)                                               GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 3, 6, 1, (r))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_DSL_RX_WRITE_G(v, g, idx)                                              GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 3, 6, 1, (v))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_DSL_RX_READ_CORE(r, g, idx, core_id)                                   CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 3, 6, 1, (r), core_id)
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_DSL_RX_WRITE_CORE(v, g, idx, core_id)                                  CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 3, 6, 1, (v), core_id)
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_DSL_RX_READ(r, p)                                                      RDP_FIELD_MREAD_8((uint8_t *)(p) + 3, 6, 1, (r))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_DSL_RX_WRITE(v, p)                                                     RDP_FIELD_MWRITE_8((uint8_t *)(p) + 3, 6, 1, (v))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_COHERENT_READ_G(r, g, idx)                                             GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 3, 5, 1, (r))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_COHERENT_WRITE_G(v, g, idx)                                            GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 3, 5, 1, (v))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_COHERENT_READ_CORE(r, g, idx, core_id)                                 CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 3, 5, 1, (r), core_id)
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_COHERENT_WRITE_CORE(v, g, idx, core_id)                                CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 3, 5, 1, (v), core_id)
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_COHERENT_READ(r, p)                                                    RDP_FIELD_MREAD_8((uint8_t *)(p) + 3, 5, 1, (r))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_COHERENT_WRITE(v, p)                                                   RDP_FIELD_MWRITE_8((uint8_t *)(p) + 3, 5, 1, (v))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_SPDTEST_STREAM_ID_READ_G(r, g, idx)                                    GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 3, 2, 3, (r))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_SPDTEST_STREAM_ID_WRITE_G(v, g, idx)                                   GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 3, 2, 3, (v))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_SPDTEST_STREAM_ID_READ_CORE(r, g, idx, core_id)                        CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 3, 2, 3, (r), core_id)
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_SPDTEST_STREAM_ID_WRITE_CORE(v, g, idx, core_id)                       CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 3, 2, 3, (v), core_id)
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_SPDTEST_STREAM_ID_READ(r, p)                                           RDP_FIELD_MREAD_8((uint8_t *)(p) + 3, 2, 3, (r))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_SPDTEST_STREAM_ID_WRITE(v, p)                                          RDP_FIELD_MWRITE_8((uint8_t *)(p) + 3, 2, 3, (v))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_TCPSPDTEST_IS_UPLOAD_READ_G(r, g, idx)                                 GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 3, 1, 1, (r))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_TCPSPDTEST_IS_UPLOAD_WRITE_G(v, g, idx)                                GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 3, 1, 1, (v))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_TCPSPDTEST_IS_UPLOAD_READ_CORE(r, g, idx, core_id)                     CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 3, 1, 1, (r), core_id)
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_TCPSPDTEST_IS_UPLOAD_WRITE_CORE(v, g, idx, core_id)                    CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 3, 1, 1, (v), core_id)
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_TCPSPDTEST_IS_UPLOAD_READ(r, p)                                        RDP_FIELD_MREAD_8((uint8_t *)(p) + 3, 1, 1, (r))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_TCPSPDTEST_IS_UPLOAD_WRITE(v, p)                                       RDP_FIELD_MWRITE_8((uint8_t *)(p) + 3, 1, 1, (v))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_SPDTEST_L3_L4_HDR_LEN_READ_G(r, g, idx)                                GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 4, 6, 7, (r))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_SPDTEST_L3_L4_HDR_LEN_WRITE_G(v, g, idx)                               GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 4, 6, 7, (v))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_SPDTEST_L3_L4_HDR_LEN_READ_CORE(r, g, idx, core_id)                    CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 4, 6, 7, (r), core_id)
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_SPDTEST_L3_L4_HDR_LEN_WRITE_CORE(v, g, idx, core_id)                   CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 4, 6, 7, (v), core_id)
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_SPDTEST_L3_L4_HDR_LEN_READ(r, p)                                       RDP_FIELD_MREAD_16((uint8_t *)(p) + 4, 6, 7, (r))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_SPDTEST_L3_L4_HDR_LEN_WRITE(v, p)                                      RDP_FIELD_MWRITE_16((uint8_t *)(p) + 4, 6, 7, (v))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_PRIORITY_READ_G(r, g, idx)                                             GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 5, 5, 1, (r))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_PRIORITY_WRITE_G(v, g, idx)                                            GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 5, 5, 1, (v))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_PRIORITY_READ_CORE(r, g, idx, core_id)                                 CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 5, 5, 1, (r), core_id)
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_PRIORITY_WRITE_CORE(v, g, idx, core_id)                                CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 5, 5, 1, (v), core_id)
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_PRIORITY_READ(r, p)                                                    RDP_FIELD_MREAD_8((uint8_t *)(p) + 5, 5, 1, (r))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_PRIORITY_WRITE(v, p)                                                   RDP_FIELD_MWRITE_8((uint8_t *)(p) + 5, 5, 1, (v))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_INGRESS_CONG_READ_G(r, g, idx)                                         GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 5, 4, 1, (r))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_INGRESS_CONG_WRITE_G(v, g, idx)                                        GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 5, 4, 1, (v))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_INGRESS_CONG_READ_CORE(r, g, idx, core_id)                             CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 5, 4, 1, (r), core_id)
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_INGRESS_CONG_WRITE_CORE(v, g, idx, core_id)                            CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 5, 4, 1, (v), core_id)
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_INGRESS_CONG_READ(r, p)                                                RDP_FIELD_MREAD_8((uint8_t *)(p) + 5, 4, 1, (r))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_INGRESS_CONG_WRITE(v, p)                                               RDP_FIELD_MWRITE_8((uint8_t *)(p) + 5, 4, 1, (v))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_ABS_READ_G(r, g, idx)                                                  GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 5, 3, 1, (r))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_ABS_WRITE_G(v, g, idx)                                                 GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 5, 3, 1, (v))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_ABS_READ_CORE(r, g, idx, core_id)                                      CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 5, 3, 1, (r), core_id)
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_ABS_WRITE_CORE(v, g, idx, core_id)                                     CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 5, 3, 1, (v), core_id)
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_ABS_READ(r, p)                                                         RDP_FIELD_MREAD_8((uint8_t *)(p) + 5, 3, 1, (r))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_ABS_WRITE(v, p)                                                        RDP_FIELD_MWRITE_8((uint8_t *)(p) + 5, 3, 1, (v))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_PACKET_LENGTH_READ_G(r, g, idx)                                        GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 6, 0, 14, (r))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_PACKET_LENGTH_WRITE_G(v, g, idx)                                       GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 6, 0, 14, (v))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_PACKET_LENGTH_READ_CORE(r, g, idx, core_id)                            CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 6, 0, 14, (r), core_id)
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_PACKET_LENGTH_WRITE_CORE(v, g, idx, core_id)                           CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 6, 0, 14, (v), core_id)
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_PACKET_LENGTH_READ(r, p)                                               RDP_FIELD_MREAD_16((uint8_t *)(p) + 6, 0, 14, (r))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_PACKET_LENGTH_WRITE(v, p)                                              RDP_FIELD_MWRITE_16((uint8_t *)(p) + 6, 0, 14, (v))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_DROP_READ_G(r, g, idx)                                                 GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 8, 7, 1, (r))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_DROP_WRITE_G(v, g, idx)                                                GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 8, 7, 1, (v))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_DROP_READ_CORE(r, g, idx, core_id)                                     CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 8, 7, 1, (r), core_id)
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_DROP_WRITE_CORE(v, g, idx, core_id)                                    CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 8, 7, 1, (v), core_id)
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_DROP_READ(r, p)                                                        RDP_FIELD_MREAD_8((uint8_t *)(p) + 8, 7, 1, (r))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_DROP_WRITE(v, p)                                                       RDP_FIELD_MWRITE_8((uint8_t *)(p) + 8, 7, 1, (v))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_TARGET_MEM_1_READ_G(r, g, idx)                                         GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 8, 6, 1, (r))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_TARGET_MEM_1_WRITE_G(v, g, idx)                                        GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 8, 6, 1, (v))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_TARGET_MEM_1_READ_CORE(r, g, idx, core_id)                             CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 8, 6, 1, (r), core_id)
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_TARGET_MEM_1_WRITE_CORE(v, g, idx, core_id)                            CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 8, 6, 1, (v), core_id)
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_TARGET_MEM_1_READ(r, p)                                                RDP_FIELD_MREAD_8((uint8_t *)(p) + 8, 6, 1, (r))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_TARGET_MEM_1_WRITE(v, p)                                               RDP_FIELD_MWRITE_8((uint8_t *)(p) + 8, 6, 1, (v))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_IS_EMAC_READ_G(r, g, idx)                                              GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 8, 3, 1, (r))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_IS_EMAC_WRITE_G(v, g, idx)                                             GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 8, 3, 1, (v))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_IS_EMAC_READ_CORE(r, g, idx, core_id)                                  CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 8, 3, 1, (r), core_id)
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_IS_EMAC_WRITE_CORE(v, g, idx, core_id)                                 CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 8, 3, 1, (v), core_id)
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_IS_EMAC_READ(r, p)                                                     RDP_FIELD_MREAD_8((uint8_t *)(p) + 8, 3, 1, (r))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_IS_EMAC_WRITE(v, p)                                                    RDP_FIELD_MWRITE_8((uint8_t *)(p) + 8, 3, 1, (v))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_EH_READ_G(r, g, idx)                                                   GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 8, 2, 1, (r))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_EH_WRITE_G(v, g, idx)                                                  GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 8, 2, 1, (v))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_EH_READ_CORE(r, g, idx, core_id)                                       CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 8, 2, 1, (r), core_id)
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_EH_WRITE_CORE(v, g, idx, core_id)                                      CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 8, 2, 1, (v), core_id)
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_EH_READ(r, p)                                                          RDP_FIELD_MREAD_8((uint8_t *)(p) + 8, 2, 1, (r))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_EH_WRITE(v, p)                                                         RDP_FIELD_MWRITE_8((uint8_t *)(p) + 8, 2, 1, (v))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_INGRESS_VPORT_READ_G(r, g, idx)                                        GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 8, 2, 8, (r))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_INGRESS_VPORT_WRITE_G(v, g, idx)                                       GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 8, 2, 8, (v))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_INGRESS_VPORT_READ_CORE(r, g, idx, core_id)                            CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 8, 2, 8, (r), core_id)
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_INGRESS_VPORT_WRITE_CORE(v, g, idx, core_id)                           CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 8, 2, 8, (v), core_id)
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_INGRESS_VPORT_READ(r, p)                                               RDP_FIELD_MREAD_16((uint8_t *)(p) + 8, 2, 8, (r))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_INGRESS_VPORT_WRITE(v, p)                                              RDP_FIELD_MWRITE_16((uint8_t *)(p) + 8, 2, 8, (v))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_BN1_OR_ABS1_READ_G(r, g, idx)                                          GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 10, 0, 14, (r))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_BN1_OR_ABS1_WRITE_G(v, g, idx)                                         GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 10, 0, 14, (v))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_BN1_OR_ABS1_READ_CORE(r, g, idx, core_id)                              CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 10, 0, 14, (r), core_id)
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_BN1_OR_ABS1_WRITE_CORE(v, g, idx, core_id)                             CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 10, 0, 14, (v), core_id)
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_BN1_OR_ABS1_READ(r, p)                                                 RDP_FIELD_MREAD_16((uint8_t *)(p) + 10, 0, 14, (r))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_BN1_OR_ABS1_WRITE(v, p)                                                RDP_FIELD_MWRITE_16((uint8_t *)(p) + 10, 0, 14, (v))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_BN1_FIRST_READ_G(r, g, idx)                                            GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 10, 0, 14, (r))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_BN1_FIRST_WRITE_G(v, g, idx)                                           GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 10, 0, 14, (v))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_BN1_FIRST_READ_CORE(r, g, idx, core_id)                                CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 10, 0, 14, (r), core_id)
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_BN1_FIRST_WRITE_CORE(v, g, idx, core_id)                               CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 10, 0, 14, (v), core_id)
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_BN1_FIRST_READ(r, p)                                                   RDP_FIELD_MREAD_16((uint8_t *)(p) + 10, 0, 14, (r))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_BN1_FIRST_WRITE(v, p)                                                  RDP_FIELD_MWRITE_16((uint8_t *)(p) + 10, 0, 14, (v))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_ABS1_READ_G(r, g, idx)                                                 GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 10, 0, 11, (r))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_ABS1_WRITE_G(v, g, idx)                                                GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 10, 0, 11, (v))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_ABS1_READ_CORE(r, g, idx, core_id)                                     CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 10, 0, 11, (r), core_id)
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_ABS1_WRITE_CORE(v, g, idx, core_id)                                    CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 10, 0, 11, (v), core_id)
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_ABS1_READ(r, p)                                                        RDP_FIELD_MREAD_16((uint8_t *)(p) + 10, 0, 11, (r))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_ABS1_WRITE(v, p)                                                       RDP_FIELD_MWRITE_16((uint8_t *)(p) + 10, 0, 11, (v))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_AGG_PD_READ_G(r, g, idx)                                               GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 12, 7, 1, (r))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_AGG_PD_WRITE_G(v, g, idx)                                              GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 12, 7, 1, (v))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_AGG_PD_READ_CORE(r, g, idx, core_id)                                   CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 12, 7, 1, (r), core_id)
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_AGG_PD_WRITE_CORE(v, g, idx, core_id)                                  CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 12, 7, 1, (v), core_id)
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_AGG_PD_READ(r, p)                                                      RDP_FIELD_MREAD_8((uint8_t *)(p) + 12, 7, 1, (r))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_AGG_PD_WRITE(v, p)                                                     RDP_FIELD_MWRITE_8((uint8_t *)(p) + 12, 7, 1, (v))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_TARGET_MEM_0_READ_G(r, g, idx)                                         GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 12, 6, 1, (r))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_TARGET_MEM_0_WRITE_G(v, g, idx)                                        GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 12, 6, 1, (v))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_TARGET_MEM_0_READ_CORE(r, g, idx, core_id)                             CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 12, 6, 1, (r), core_id)
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_TARGET_MEM_0_WRITE_CORE(v, g, idx, core_id)                            CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 12, 6, 1, (v), core_id)
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_TARGET_MEM_0_READ(r, p)                                                RDP_FIELD_MREAD_8((uint8_t *)(p) + 12, 6, 1, (r))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_TARGET_MEM_0_WRITE(v, p)                                               RDP_FIELD_MWRITE_8((uint8_t *)(p) + 12, 6, 1, (v))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_PAYLOAD_OFFSET_SOP_READ_G(r, g, idx)                                   GROUP_RDP_FIELD_MREAD_32((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 12, 0, 30, (r))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_PAYLOAD_OFFSET_SOP_WRITE_G(v, g, idx)                                  GROUP_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 12, 0, 30, (v))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_PAYLOAD_OFFSET_SOP_READ_CORE(r, g, idx, core_id)                       CORE_RDP_FIELD_MREAD_32((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 12, 0, 30, (r), core_id)
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_PAYLOAD_OFFSET_SOP_WRITE_CORE(v, g, idx, core_id)                      CORE_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 12, 0, 30, (v), core_id)
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_PAYLOAD_OFFSET_SOP_READ(r, p)                                          RDP_FIELD_MREAD_32((uint8_t *)(p) + 12, 0, 30, (r))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_PAYLOAD_OFFSET_SOP_WRITE(v, p)                                         RDP_FIELD_MWRITE_32((uint8_t *)(p) + 12, 0, 30, (v))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_SOP_FPM_READ_G(r, g, idx)                                              GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 12, 4, 10, (r))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_SOP_FPM_WRITE_G(v, g, idx)                                             GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 12, 4, 10, (v))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_SOP_FPM_READ_CORE(r, g, idx, core_id)                                  CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 12, 4, 10, (r), core_id)
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_SOP_FPM_WRITE_CORE(v, g, idx, core_id)                                 CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 12, 4, 10, (v), core_id)
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_SOP_FPM_READ(r, p)                                                     RDP_FIELD_MREAD_16((uint8_t *)(p) + 12, 4, 10, (r))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_SOP_FPM_WRITE(v, p)                                                    RDP_FIELD_MWRITE_16((uint8_t *)(p) + 12, 4, 10, (v))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_FPM_POOL_READ_G(r, g, idx)                                             GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 13, 2, 2, (r))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_FPM_POOL_WRITE_G(v, g, idx)                                            GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 13, 2, 2, (v))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_FPM_POOL_READ_CORE(r, g, idx, core_id)                                 CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 13, 2, 2, (r), core_id)
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_FPM_POOL_WRITE_CORE(v, g, idx, core_id)                                CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 13, 2, 2, (v), core_id)
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_FPM_POOL_READ(r, p)                                                    RDP_FIELD_MREAD_8((uint8_t *)(p) + 13, 2, 2, (r))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_FPM_POOL_WRITE(v, p)                                                   RDP_FIELD_MWRITE_8((uint8_t *)(p) + 13, 2, 2, (v))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_FPM_NUM_READ_G(r, g, idx)                                              GROUP_RDP_FIELD_MREAD_32((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 12, 0, 18, (r))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_FPM_NUM_WRITE_G(v, g, idx)                                             GROUP_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 12, 0, 18, (v))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_FPM_NUM_READ_CORE(r, g, idx, core_id)                                  CORE_RDP_FIELD_MREAD_32((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 12, 0, 18, (r), core_id)
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_FPM_NUM_WRITE_CORE(v, g, idx, core_id)                                 CORE_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 12, 0, 18, (v), core_id)
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_FPM_NUM_READ(r, p)                                                     RDP_FIELD_MREAD_32((uint8_t *)(p) + 12, 0, 18, (r))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_FPM_NUM_WRITE(v, p)                                                    RDP_FIELD_MWRITE_32((uint8_t *)(p) + 12, 0, 18, (v))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_BN_NUM_READ_G(r, g, idx)                                               GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 12, 7, 7, (r))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_BN_NUM_WRITE_G(v, g, idx)                                              GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 12, 7, 7, (v))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_BN_NUM_READ_CORE(r, g, idx, core_id)                                   CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 12, 7, 7, (r), core_id)
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_BN_NUM_WRITE_CORE(v, g, idx, core_id)                                  CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 12, 7, 7, (v), core_id)
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_BN_NUM_READ(r, p)                                                      RDP_FIELD_MREAD_16((uint8_t *)(p) + 12, 7, 7, (r))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_BN_NUM_WRITE(v, p)                                                     RDP_FIELD_MWRITE_16((uint8_t *)(p) + 12, 7, 7, (v))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_SOP_READ_G(r, g, idx)                                                  GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 13, 0, 7, (r))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_SOP_WRITE_G(v, g, idx)                                                 GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 13, 0, 7, (v))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_SOP_READ_CORE(r, g, idx, core_id)                                      CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 13, 0, 7, (r), core_id)
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_SOP_WRITE_CORE(v, g, idx, core_id)                                     CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 13, 0, 7, (v), core_id)
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_SOP_READ(r, p)                                                         RDP_FIELD_MREAD_8((uint8_t *)(p) + 13, 0, 7, (r))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_SOP_WRITE(v, p)                                                        RDP_FIELD_MWRITE_8((uint8_t *)(p) + 13, 0, 7, (v))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_BN0_FIRST_READ_G(r, g, idx)                                            GROUP_MREAD_16((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 14, (r))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_BN0_FIRST_WRITE_G(v, g, idx)                                           GROUP_MWRITE_16((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 14, (v))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_BN0_FIRST_READ_CORE(r, g, idx, core_id)                                CORE_MREAD_16((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 14, (r), core_id)
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_BN0_FIRST_WRITE_CORE(v, g, idx, core_id)                               CORE_MWRITE_16((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 14, (v), core_id)
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_BN0_FIRST_READ(r, p)                                                   MREAD_16((uint8_t *)(p) + 14, (r))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_BN0_FIRST_WRITE(v, p)                                                  MWRITE_16((uint8_t *)(p) + 14, (v))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_ABS0_READ_G(r, g, idx)                                                 GROUP_RDP_FIELD_MREAD_32((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 12, 0, 29, (r))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_ABS0_WRITE_G(v, g, idx)                                                GROUP_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 12, 0, 29, (v))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_ABS0_READ_CORE(r, g, idx, core_id)                                     CORE_RDP_FIELD_MREAD_32((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 12, 0, 29, (r), core_id)
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_ABS0_WRITE_CORE(v, g, idx, core_id)                                    CORE_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT) + 12, 0, 29, (v), core_id)
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_ABS0_READ(r, p)                                                        RDP_FIELD_MREAD_32((uint8_t *)(p) + 12, 0, 29, (r))
#define RDD_PROCESSING_SPDSVC_RX_DESCRIPTOR_ABS0_WRITE(v, p)                                                       RDP_FIELD_MWRITE_32((uint8_t *)(p) + 12, 0, 29, (v))
/* <<<PROCESSING_SPDSVC_RX_DESCRIPTOR_STRUCT */


/* >>>UDPSPDT_STREAM_RX_STAT_STRUCT */
typedef union
    {
    uint8_t word_8[48];
    uint16_t word_16[24];
    uint32_t word_32[12];
    uint64_t dword_64[6];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	rx_bytes_1              	;
        uint32_t	rx_bytes_0              	;
        uint32_t	rx_packets_1            	;
        uint32_t	rx_packets_0            	;
        uint32_t	ts_first                	;
        uint32_t	ts_last_1               	;
        uint32_t	ts_last_0               	;
        uint32_t	ts_first_set            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved                	:15	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	bad_proto_cntr          	;
        uint32_t	iperf3_rx_packet_lost_1 	;
        uint32_t	iperf3_rx_packet_lost_0 	;
        uint32_t	iperf3_rx_out_of_order_1	;
        uint32_t	iperf3_rx_out_of_order_0	;
#else
        uint32_t	rx_bytes_1              	;
        uint32_t	rx_bytes_0              	;
        uint32_t	rx_packets_1            	;
        uint32_t	rx_packets_0            	;
        uint32_t	ts_first                	;
        uint32_t	ts_last_1               	;
        uint32_t	ts_last_0               	;
        uint16_t	bad_proto_cntr          	;
        uint32_t	reserved                	:15	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ts_first_set            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	iperf3_rx_packet_lost_1 	;
        uint32_t	iperf3_rx_packet_lost_0 	;
        uint32_t	iperf3_rx_out_of_order_1	;
        uint32_t	iperf3_rx_out_of_order_0	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) UDPSPDT_STREAM_RX_STAT_STRUCT;

#define RDD_UDPSPDT_STREAM_RX_STAT_RX_BYTES_1_READ_G(r, g, idx)                                              GROUP_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT), (r))
#define RDD_UDPSPDT_STREAM_RX_STAT_RX_BYTES_1_WRITE_G(v, g, idx)                                             GROUP_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT), (v))
#define RDD_UDPSPDT_STREAM_RX_STAT_RX_BYTES_1_READ_CORE(r, g, idx, core_id)                                  CORE_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT), (r), core_id)
#define RDD_UDPSPDT_STREAM_RX_STAT_RX_BYTES_1_WRITE_CORE(v, g, idx, core_id)                                 CORE_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT), (v), core_id)
#define RDD_UDPSPDT_STREAM_RX_STAT_RX_BYTES_1_READ(r, p)                                                     MREAD_32((uint8_t *)(p), (r))
#define RDD_UDPSPDT_STREAM_RX_STAT_RX_BYTES_1_WRITE(v, p)                                                    MWRITE_32((uint8_t *)(p), (v))
#define RDD_UDPSPDT_STREAM_RX_STAT_RX_BYTES_0_READ_G(r, g, idx)                                              GROUP_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 4, (r))
#define RDD_UDPSPDT_STREAM_RX_STAT_RX_BYTES_0_WRITE_G(v, g, idx)                                             GROUP_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 4, (v))
#define RDD_UDPSPDT_STREAM_RX_STAT_RX_BYTES_0_READ_CORE(r, g, idx, core_id)                                  CORE_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 4, (r), core_id)
#define RDD_UDPSPDT_STREAM_RX_STAT_RX_BYTES_0_WRITE_CORE(v, g, idx, core_id)                                 CORE_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 4, (v), core_id)
#define RDD_UDPSPDT_STREAM_RX_STAT_RX_BYTES_0_READ(r, p)                                                     MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_UDPSPDT_STREAM_RX_STAT_RX_BYTES_0_WRITE(v, p)                                                    MWRITE_32((uint8_t *)(p) + 4, (v))
#define RDD_UDPSPDT_STREAM_RX_STAT_RX_PACKETS_1_READ_G(r, g, idx)                                            GROUP_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 8, (r))
#define RDD_UDPSPDT_STREAM_RX_STAT_RX_PACKETS_1_WRITE_G(v, g, idx)                                           GROUP_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 8, (v))
#define RDD_UDPSPDT_STREAM_RX_STAT_RX_PACKETS_1_READ_CORE(r, g, idx, core_id)                                CORE_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 8, (r), core_id)
#define RDD_UDPSPDT_STREAM_RX_STAT_RX_PACKETS_1_WRITE_CORE(v, g, idx, core_id)                               CORE_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 8, (v), core_id)
#define RDD_UDPSPDT_STREAM_RX_STAT_RX_PACKETS_1_READ(r, p)                                                   MREAD_32((uint8_t *)(p) + 8, (r))
#define RDD_UDPSPDT_STREAM_RX_STAT_RX_PACKETS_1_WRITE(v, p)                                                  MWRITE_32((uint8_t *)(p) + 8, (v))
#define RDD_UDPSPDT_STREAM_RX_STAT_RX_PACKETS_0_READ_G(r, g, idx)                                            GROUP_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 12, (r))
#define RDD_UDPSPDT_STREAM_RX_STAT_RX_PACKETS_0_WRITE_G(v, g, idx)                                           GROUP_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 12, (v))
#define RDD_UDPSPDT_STREAM_RX_STAT_RX_PACKETS_0_READ_CORE(r, g, idx, core_id)                                CORE_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 12, (r), core_id)
#define RDD_UDPSPDT_STREAM_RX_STAT_RX_PACKETS_0_WRITE_CORE(v, g, idx, core_id)                               CORE_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 12, (v), core_id)
#define RDD_UDPSPDT_STREAM_RX_STAT_RX_PACKETS_0_READ(r, p)                                                   MREAD_32((uint8_t *)(p) + 12, (r))
#define RDD_UDPSPDT_STREAM_RX_STAT_RX_PACKETS_0_WRITE(v, p)                                                  MWRITE_32((uint8_t *)(p) + 12, (v))
#define RDD_UDPSPDT_STREAM_RX_STAT_TS_FIRST_READ_G(r, g, idx)                                                GROUP_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 16, (r))
#define RDD_UDPSPDT_STREAM_RX_STAT_TS_FIRST_WRITE_G(v, g, idx)                                               GROUP_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 16, (v))
#define RDD_UDPSPDT_STREAM_RX_STAT_TS_FIRST_READ_CORE(r, g, idx, core_id)                                    CORE_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 16, (r), core_id)
#define RDD_UDPSPDT_STREAM_RX_STAT_TS_FIRST_WRITE_CORE(v, g, idx, core_id)                                   CORE_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 16, (v), core_id)
#define RDD_UDPSPDT_STREAM_RX_STAT_TS_FIRST_READ(r, p)                                                       MREAD_32((uint8_t *)(p) + 16, (r))
#define RDD_UDPSPDT_STREAM_RX_STAT_TS_FIRST_WRITE(v, p)                                                      MWRITE_32((uint8_t *)(p) + 16, (v))
#define RDD_UDPSPDT_STREAM_RX_STAT_TS_LAST_1_READ_G(r, g, idx)                                               GROUP_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 20, (r))
#define RDD_UDPSPDT_STREAM_RX_STAT_TS_LAST_1_WRITE_G(v, g, idx)                                              GROUP_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 20, (v))
#define RDD_UDPSPDT_STREAM_RX_STAT_TS_LAST_1_READ_CORE(r, g, idx, core_id)                                   CORE_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 20, (r), core_id)
#define RDD_UDPSPDT_STREAM_RX_STAT_TS_LAST_1_WRITE_CORE(v, g, idx, core_id)                                  CORE_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 20, (v), core_id)
#define RDD_UDPSPDT_STREAM_RX_STAT_TS_LAST_1_READ(r, p)                                                      MREAD_32((uint8_t *)(p) + 20, (r))
#define RDD_UDPSPDT_STREAM_RX_STAT_TS_LAST_1_WRITE(v, p)                                                     MWRITE_32((uint8_t *)(p) + 20, (v))
#define RDD_UDPSPDT_STREAM_RX_STAT_TS_LAST_0_READ_G(r, g, idx)                                               GROUP_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 24, (r))
#define RDD_UDPSPDT_STREAM_RX_STAT_TS_LAST_0_WRITE_G(v, g, idx)                                              GROUP_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 24, (v))
#define RDD_UDPSPDT_STREAM_RX_STAT_TS_LAST_0_READ_CORE(r, g, idx, core_id)                                   CORE_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 24, (r), core_id)
#define RDD_UDPSPDT_STREAM_RX_STAT_TS_LAST_0_WRITE_CORE(v, g, idx, core_id)                                  CORE_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 24, (v), core_id)
#define RDD_UDPSPDT_STREAM_RX_STAT_TS_LAST_0_READ(r, p)                                                      MREAD_32((uint8_t *)(p) + 24, (r))
#define RDD_UDPSPDT_STREAM_RX_STAT_TS_LAST_0_WRITE(v, p)                                                     MWRITE_32((uint8_t *)(p) + 24, (v))
#define RDD_UDPSPDT_STREAM_RX_STAT_TS_FIRST_SET_READ_G(r, g, idx)                                            GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 28, 7, 1, (r))
#define RDD_UDPSPDT_STREAM_RX_STAT_TS_FIRST_SET_WRITE_G(v, g, idx)                                           GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 28, 7, 1, (v))
#define RDD_UDPSPDT_STREAM_RX_STAT_TS_FIRST_SET_READ_CORE(r, g, idx, core_id)                                CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 28, 7, 1, (r), core_id)
#define RDD_UDPSPDT_STREAM_RX_STAT_TS_FIRST_SET_WRITE_CORE(v, g, idx, core_id)                               CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 28, 7, 1, (v), core_id)
#define RDD_UDPSPDT_STREAM_RX_STAT_TS_FIRST_SET_READ(r, p)                                                   RDP_FIELD_MREAD_8((uint8_t *)(p) + 28, 7, 1, (r))
#define RDD_UDPSPDT_STREAM_RX_STAT_TS_FIRST_SET_WRITE(v, p)                                                  RDP_FIELD_MWRITE_8((uint8_t *)(p) + 28, 7, 1, (v))
#define RDD_UDPSPDT_STREAM_RX_STAT_BAD_PROTO_CNTR_READ_G(r, g, idx)                                          GROUP_MREAD_16((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 30, (r))
#define RDD_UDPSPDT_STREAM_RX_STAT_BAD_PROTO_CNTR_WRITE_G(v, g, idx)                                         GROUP_MWRITE_16((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 30, (v))
#define RDD_UDPSPDT_STREAM_RX_STAT_BAD_PROTO_CNTR_READ_CORE(r, g, idx, core_id)                              CORE_MREAD_16((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 30, (r), core_id)
#define RDD_UDPSPDT_STREAM_RX_STAT_BAD_PROTO_CNTR_WRITE_CORE(v, g, idx, core_id)                             CORE_MWRITE_16((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 30, (v), core_id)
#define RDD_UDPSPDT_STREAM_RX_STAT_BAD_PROTO_CNTR_READ(r, p)                                                 MREAD_16((uint8_t *)(p) + 30, (r))
#define RDD_UDPSPDT_STREAM_RX_STAT_BAD_PROTO_CNTR_WRITE(v, p)                                                MWRITE_16((uint8_t *)(p) + 30, (v))
#define RDD_UDPSPDT_STREAM_RX_STAT_IPERF3_RX_PACKET_LOST_1_READ_G(r, g, idx)                                 GROUP_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 32, (r))
#define RDD_UDPSPDT_STREAM_RX_STAT_IPERF3_RX_PACKET_LOST_1_WRITE_G(v, g, idx)                                GROUP_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 32, (v))
#define RDD_UDPSPDT_STREAM_RX_STAT_IPERF3_RX_PACKET_LOST_1_READ_CORE(r, g, idx, core_id)                     CORE_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 32, (r), core_id)
#define RDD_UDPSPDT_STREAM_RX_STAT_IPERF3_RX_PACKET_LOST_1_WRITE_CORE(v, g, idx, core_id)                    CORE_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 32, (v), core_id)
#define RDD_UDPSPDT_STREAM_RX_STAT_IPERF3_RX_PACKET_LOST_1_READ(r, p)                                        MREAD_32((uint8_t *)(p) + 32, (r))
#define RDD_UDPSPDT_STREAM_RX_STAT_IPERF3_RX_PACKET_LOST_1_WRITE(v, p)                                       MWRITE_32((uint8_t *)(p) + 32, (v))
#define RDD_UDPSPDT_STREAM_RX_STAT_IPERF3_RX_PACKET_LOST_0_READ_G(r, g, idx)                                 GROUP_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 36, (r))
#define RDD_UDPSPDT_STREAM_RX_STAT_IPERF3_RX_PACKET_LOST_0_WRITE_G(v, g, idx)                                GROUP_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 36, (v))
#define RDD_UDPSPDT_STREAM_RX_STAT_IPERF3_RX_PACKET_LOST_0_READ_CORE(r, g, idx, core_id)                     CORE_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 36, (r), core_id)
#define RDD_UDPSPDT_STREAM_RX_STAT_IPERF3_RX_PACKET_LOST_0_WRITE_CORE(v, g, idx, core_id)                    CORE_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 36, (v), core_id)
#define RDD_UDPSPDT_STREAM_RX_STAT_IPERF3_RX_PACKET_LOST_0_READ(r, p)                                        MREAD_32((uint8_t *)(p) + 36, (r))
#define RDD_UDPSPDT_STREAM_RX_STAT_IPERF3_RX_PACKET_LOST_0_WRITE(v, p)                                       MWRITE_32((uint8_t *)(p) + 36, (v))
#define RDD_UDPSPDT_STREAM_RX_STAT_IPERF3_RX_OUT_OF_ORDER_1_READ_G(r, g, idx)                                GROUP_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 40, (r))
#define RDD_UDPSPDT_STREAM_RX_STAT_IPERF3_RX_OUT_OF_ORDER_1_WRITE_G(v, g, idx)                               GROUP_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 40, (v))
#define RDD_UDPSPDT_STREAM_RX_STAT_IPERF3_RX_OUT_OF_ORDER_1_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 40, (r), core_id)
#define RDD_UDPSPDT_STREAM_RX_STAT_IPERF3_RX_OUT_OF_ORDER_1_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 40, (v), core_id)
#define RDD_UDPSPDT_STREAM_RX_STAT_IPERF3_RX_OUT_OF_ORDER_1_READ(r, p)                                       MREAD_32((uint8_t *)(p) + 40, (r))
#define RDD_UDPSPDT_STREAM_RX_STAT_IPERF3_RX_OUT_OF_ORDER_1_WRITE(v, p)                                      MWRITE_32((uint8_t *)(p) + 40, (v))
#define RDD_UDPSPDT_STREAM_RX_STAT_IPERF3_RX_OUT_OF_ORDER_0_READ_G(r, g, idx)                                GROUP_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 44, (r))
#define RDD_UDPSPDT_STREAM_RX_STAT_IPERF3_RX_OUT_OF_ORDER_0_WRITE_G(v, g, idx)                               GROUP_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 44, (v))
#define RDD_UDPSPDT_STREAM_RX_STAT_IPERF3_RX_OUT_OF_ORDER_0_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 44, (r), core_id)
#define RDD_UDPSPDT_STREAM_RX_STAT_IPERF3_RX_OUT_OF_ORDER_0_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 44, (v), core_id)
#define RDD_UDPSPDT_STREAM_RX_STAT_IPERF3_RX_OUT_OF_ORDER_0_READ(r, p)                                       MREAD_32((uint8_t *)(p) + 44, (r))
#define RDD_UDPSPDT_STREAM_RX_STAT_IPERF3_RX_OUT_OF_ORDER_0_WRITE(v, p)                                      MWRITE_32((uint8_t *)(p) + 44, (v))
/* <<<UDPSPDT_STREAM_RX_STAT_STRUCT */


/* >>>UDPSPDT_SCRATCH_IPERF3_RX_STRUCT */
typedef union
    {
    uint8_t word_8[8];
    uint16_t word_16[4];
    uint32_t word_32[2];
    uint64_t dword_64[1];
        struct {
        uint32_t	rx_packets_0	;
        uint32_t	rx_packets_1	;
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) UDPSPDT_SCRATCH_IPERF3_RX_STRUCT;

#define RDD_UDPSPDT_SCRATCH_IPERF3_RX_RX_PACKETS_0_READ_G(r, g, idx)                                GROUP_MREAD_32((g), (idx)*sizeof(UDPSPDT_SCRATCH_IPERF3_RX_STRUCT), (r))
#define RDD_UDPSPDT_SCRATCH_IPERF3_RX_RX_PACKETS_0_WRITE_G(v, g, idx)                               GROUP_MWRITE_32((g), (idx)*sizeof(UDPSPDT_SCRATCH_IPERF3_RX_STRUCT), (v))
#define RDD_UDPSPDT_SCRATCH_IPERF3_RX_RX_PACKETS_0_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_32((g), (idx)*sizeof(UDPSPDT_SCRATCH_IPERF3_RX_STRUCT), (r), core_id)
#define RDD_UDPSPDT_SCRATCH_IPERF3_RX_RX_PACKETS_0_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_32((g), (idx)*sizeof(UDPSPDT_SCRATCH_IPERF3_RX_STRUCT), (v), core_id)
#define RDD_UDPSPDT_SCRATCH_IPERF3_RX_RX_PACKETS_0_READ(r, p)                                       MREAD_32((uint8_t *)(p), (r))
#define RDD_UDPSPDT_SCRATCH_IPERF3_RX_RX_PACKETS_0_WRITE(v, p)                                      MWRITE_32((uint8_t *)(p), (v))
#define RDD_UDPSPDT_SCRATCH_IPERF3_RX_RX_PACKETS_1_READ_G(r, g, idx)                                GROUP_MREAD_32((g), (idx)*sizeof(UDPSPDT_SCRATCH_IPERF3_RX_STRUCT) + 4, (r))
#define RDD_UDPSPDT_SCRATCH_IPERF3_RX_RX_PACKETS_1_WRITE_G(v, g, idx)                               GROUP_MWRITE_32((g), (idx)*sizeof(UDPSPDT_SCRATCH_IPERF3_RX_STRUCT) + 4, (v))
#define RDD_UDPSPDT_SCRATCH_IPERF3_RX_RX_PACKETS_1_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_32((g), (idx)*sizeof(UDPSPDT_SCRATCH_IPERF3_RX_STRUCT) + 4, (r), core_id)
#define RDD_UDPSPDT_SCRATCH_IPERF3_RX_RX_PACKETS_1_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_32((g), (idx)*sizeof(UDPSPDT_SCRATCH_IPERF3_RX_STRUCT) + 4, (v), core_id)
#define RDD_UDPSPDT_SCRATCH_IPERF3_RX_RX_PACKETS_1_READ(r, p)                                       MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_UDPSPDT_SCRATCH_IPERF3_RX_RX_PACKETS_1_WRITE(v, p)                                      MWRITE_32((uint8_t *)(p) + 4, (v))
/* <<<UDPSPDT_SCRATCH_IPERF3_RX_STRUCT */


/* >>>SPDSVC_WLAN_GEN_PARAMS_STRUCT */
typedef union
    {
    uint8_t word_8[10];
    uint16_t word_16[5];
        struct {
        uint32_t	complete_tracked	;
        uint32_t	tx_copies       	;
        uint16_t	spdsvc_free_idx 	;
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(2))) SPDSVC_WLAN_GEN_PARAMS_STRUCT;

#define RDD_SPDSVC_WLAN_GEN_PARAMS_COMPLETE_TRACKED_READ_G(r, g, idx)                                GROUP_MREAD_32((g), (idx)*sizeof(SPDSVC_WLAN_GEN_PARAMS_STRUCT), (r))
#define RDD_SPDSVC_WLAN_GEN_PARAMS_COMPLETE_TRACKED_WRITE_G(v, g, idx)                               GROUP_MWRITE_32((g), (idx)*sizeof(SPDSVC_WLAN_GEN_PARAMS_STRUCT), (v))
#define RDD_SPDSVC_WLAN_GEN_PARAMS_COMPLETE_TRACKED_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_32((g), (idx)*sizeof(SPDSVC_WLAN_GEN_PARAMS_STRUCT), (r), core_id)
#define RDD_SPDSVC_WLAN_GEN_PARAMS_COMPLETE_TRACKED_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_32((g), (idx)*sizeof(SPDSVC_WLAN_GEN_PARAMS_STRUCT), (v), core_id)
#define RDD_SPDSVC_WLAN_GEN_PARAMS_COMPLETE_TRACKED_READ(r, p)                                       MREAD_32((uint8_t *)(p), (r))
#define RDD_SPDSVC_WLAN_GEN_PARAMS_COMPLETE_TRACKED_WRITE(v, p)                                      MWRITE_32((uint8_t *)(p), (v))
#define RDD_SPDSVC_WLAN_GEN_PARAMS_TX_COPIES_READ_G(r, g, idx)                                       GROUP_MREAD_32((g), (idx)*sizeof(SPDSVC_WLAN_GEN_PARAMS_STRUCT) + 4, (r))
#define RDD_SPDSVC_WLAN_GEN_PARAMS_TX_COPIES_WRITE_G(v, g, idx)                                      GROUP_MWRITE_32((g), (idx)*sizeof(SPDSVC_WLAN_GEN_PARAMS_STRUCT) + 4, (v))
#define RDD_SPDSVC_WLAN_GEN_PARAMS_TX_COPIES_READ_CORE(r, g, idx, core_id)                           CORE_MREAD_32((g), (idx)*sizeof(SPDSVC_WLAN_GEN_PARAMS_STRUCT) + 4, (r), core_id)
#define RDD_SPDSVC_WLAN_GEN_PARAMS_TX_COPIES_WRITE_CORE(v, g, idx, core_id)                          CORE_MWRITE_32((g), (idx)*sizeof(SPDSVC_WLAN_GEN_PARAMS_STRUCT) + 4, (v), core_id)
#define RDD_SPDSVC_WLAN_GEN_PARAMS_TX_COPIES_READ(r, p)                                              MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_SPDSVC_WLAN_GEN_PARAMS_TX_COPIES_WRITE(v, p)                                             MWRITE_32((uint8_t *)(p) + 4, (v))
#define RDD_SPDSVC_WLAN_GEN_PARAMS_SPDSVC_FREE_IDX_READ_G(r, g, idx)                                 GROUP_MREAD_16((g), (idx)*sizeof(SPDSVC_WLAN_GEN_PARAMS_STRUCT) + 8, (r))
#define RDD_SPDSVC_WLAN_GEN_PARAMS_SPDSVC_FREE_IDX_WRITE_G(v, g, idx)                                GROUP_MWRITE_16((g), (idx)*sizeof(SPDSVC_WLAN_GEN_PARAMS_STRUCT) + 8, (v))
#define RDD_SPDSVC_WLAN_GEN_PARAMS_SPDSVC_FREE_IDX_READ_CORE(r, g, idx, core_id)                     CORE_MREAD_16((g), (idx)*sizeof(SPDSVC_WLAN_GEN_PARAMS_STRUCT) + 8, (r), core_id)
#define RDD_SPDSVC_WLAN_GEN_PARAMS_SPDSVC_FREE_IDX_WRITE_CORE(v, g, idx, core_id)                    CORE_MWRITE_16((g), (idx)*sizeof(SPDSVC_WLAN_GEN_PARAMS_STRUCT) + 8, (v), core_id)
#define RDD_SPDSVC_WLAN_GEN_PARAMS_SPDSVC_FREE_IDX_READ(r, p)                                        MREAD_16((uint8_t *)(p) + 8, (r))
#define RDD_SPDSVC_WLAN_GEN_PARAMS_SPDSVC_FREE_IDX_WRITE(v, p)                                       MWRITE_16((uint8_t *)(p) + 8, (v))
/* <<<SPDSVC_WLAN_GEN_PARAMS_STRUCT */


/* >>>SPDSVC_WLAN_TXPOST_PARAMS_STRUCT */
typedef union
    {
    uint8_t word_8[2];
    uint16_t word_16[1];
        struct {
        uint16_t	spdsvc_free_idx	;
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(2))) SPDSVC_WLAN_TXPOST_PARAMS_STRUCT;

#define RDD_SPDSVC_WLAN_TXPOST_PARAMS_SPDSVC_FREE_IDX_READ_G(r, g, idx)                                GROUP_MREAD_16((g), (idx)*sizeof(SPDSVC_WLAN_TXPOST_PARAMS_STRUCT), (r))
#define RDD_SPDSVC_WLAN_TXPOST_PARAMS_SPDSVC_FREE_IDX_WRITE_G(v, g, idx)                               GROUP_MWRITE_16((g), (idx)*sizeof(SPDSVC_WLAN_TXPOST_PARAMS_STRUCT), (v))
#define RDD_SPDSVC_WLAN_TXPOST_PARAMS_SPDSVC_FREE_IDX_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_16((g), (idx)*sizeof(SPDSVC_WLAN_TXPOST_PARAMS_STRUCT), (r), core_id)
#define RDD_SPDSVC_WLAN_TXPOST_PARAMS_SPDSVC_FREE_IDX_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_16((g), (idx)*sizeof(SPDSVC_WLAN_TXPOST_PARAMS_STRUCT), (v), core_id)
#define RDD_SPDSVC_WLAN_TXPOST_PARAMS_SPDSVC_FREE_IDX_READ(r, p)                                       MREAD_16((uint8_t *)(p), (r))
#define RDD_SPDSVC_WLAN_TXPOST_PARAMS_SPDSVC_FREE_IDX_WRITE(v, p)                                      MWRITE_16((uint8_t *)(p), (v))
/* <<<SPDSVC_WLAN_TXPOST_PARAMS_STRUCT */


/* >>>PKTGEN_TX_PARAMS_STRUCT */
typedef union
    {
    uint8_t word_8[32];
    uint16_t word_16[16];
    uint32_t word_32[8];
    uint64_t dword_64[4];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	bbmsg_sbpm_mcast_inc_req_0	;
        uint32_t	bbmsg_sbpm_mcast_inc_req_1	;
        uint32_t	ref_pd_0                  	;
        uint32_t	ref_pd_1                  	;
        uint32_t	ref_pd_2                  	;
        uint32_t	ref_pd_3                  	;
        uint32_t	task_num                  	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved1                 	:28	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	reserved2                 	;
        uint16_t	bad_tx_num_of_bns         	;
#else
        uint32_t	bbmsg_sbpm_mcast_inc_req_0	;
        uint32_t	bbmsg_sbpm_mcast_inc_req_1	;
        uint32_t	ref_pd_0                  	;
        uint32_t	ref_pd_1                  	;
        uint32_t	ref_pd_2                  	;
        uint32_t	ref_pd_3                  	;
        uint32_t	reserved1                 	:28	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	task_num                  	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	bad_tx_num_of_bns         	;
        uint16_t	reserved2                 	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) PKTGEN_TX_PARAMS_STRUCT;

#define RDD_PKTGEN_TX_PARAMS_BBMSG_SBPM_MCAST_INC_REQ_0_READ_G(r, g, idx)                                GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_PARAMS_STRUCT), (r))
#define RDD_PKTGEN_TX_PARAMS_BBMSG_SBPM_MCAST_INC_REQ_0_WRITE_G(v, g, idx)                               GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_PARAMS_STRUCT), (v))
#define RDD_PKTGEN_TX_PARAMS_BBMSG_SBPM_MCAST_INC_REQ_0_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_PARAMS_STRUCT), (r), core_id)
#define RDD_PKTGEN_TX_PARAMS_BBMSG_SBPM_MCAST_INC_REQ_0_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_PARAMS_STRUCT), (v), core_id)
#define RDD_PKTGEN_TX_PARAMS_BBMSG_SBPM_MCAST_INC_REQ_0_READ(r, p)                                       MREAD_32((uint8_t *)(p), (r))
#define RDD_PKTGEN_TX_PARAMS_BBMSG_SBPM_MCAST_INC_REQ_0_WRITE(v, p)                                      MWRITE_32((uint8_t *)(p), (v))
#define RDD_PKTGEN_TX_PARAMS_BBMSG_SBPM_MCAST_INC_REQ_1_READ_G(r, g, idx)                                GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_PARAMS_STRUCT) + 4, (r))
#define RDD_PKTGEN_TX_PARAMS_BBMSG_SBPM_MCAST_INC_REQ_1_WRITE_G(v, g, idx)                               GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_PARAMS_STRUCT) + 4, (v))
#define RDD_PKTGEN_TX_PARAMS_BBMSG_SBPM_MCAST_INC_REQ_1_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_PARAMS_STRUCT) + 4, (r), core_id)
#define RDD_PKTGEN_TX_PARAMS_BBMSG_SBPM_MCAST_INC_REQ_1_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_PARAMS_STRUCT) + 4, (v), core_id)
#define RDD_PKTGEN_TX_PARAMS_BBMSG_SBPM_MCAST_INC_REQ_1_READ(r, p)                                       MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_PKTGEN_TX_PARAMS_BBMSG_SBPM_MCAST_INC_REQ_1_WRITE(v, p)                                      MWRITE_32((uint8_t *)(p) + 4, (v))
#define RDD_PKTGEN_TX_PARAMS_REF_PD_0_READ_G(r, g, idx)                                                  GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_PARAMS_STRUCT) + 8, (r))
#define RDD_PKTGEN_TX_PARAMS_REF_PD_0_WRITE_G(v, g, idx)                                                 GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_PARAMS_STRUCT) + 8, (v))
#define RDD_PKTGEN_TX_PARAMS_REF_PD_0_READ_CORE(r, g, idx, core_id)                                      CORE_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_PARAMS_STRUCT) + 8, (r), core_id)
#define RDD_PKTGEN_TX_PARAMS_REF_PD_0_WRITE_CORE(v, g, idx, core_id)                                     CORE_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_PARAMS_STRUCT) + 8, (v), core_id)
#define RDD_PKTGEN_TX_PARAMS_REF_PD_0_READ(r, p)                                                         MREAD_32((uint8_t *)(p) + 8, (r))
#define RDD_PKTGEN_TX_PARAMS_REF_PD_0_WRITE(v, p)                                                        MWRITE_32((uint8_t *)(p) + 8, (v))
#define RDD_PKTGEN_TX_PARAMS_REF_PD_1_READ_G(r, g, idx)                                                  GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_PARAMS_STRUCT) + 12, (r))
#define RDD_PKTGEN_TX_PARAMS_REF_PD_1_WRITE_G(v, g, idx)                                                 GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_PARAMS_STRUCT) + 12, (v))
#define RDD_PKTGEN_TX_PARAMS_REF_PD_1_READ_CORE(r, g, idx, core_id)                                      CORE_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_PARAMS_STRUCT) + 12, (r), core_id)
#define RDD_PKTGEN_TX_PARAMS_REF_PD_1_WRITE_CORE(v, g, idx, core_id)                                     CORE_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_PARAMS_STRUCT) + 12, (v), core_id)
#define RDD_PKTGEN_TX_PARAMS_REF_PD_1_READ(r, p)                                                         MREAD_32((uint8_t *)(p) + 12, (r))
#define RDD_PKTGEN_TX_PARAMS_REF_PD_1_WRITE(v, p)                                                        MWRITE_32((uint8_t *)(p) + 12, (v))
#define RDD_PKTGEN_TX_PARAMS_REF_PD_2_READ_G(r, g, idx)                                                  GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_PARAMS_STRUCT) + 16, (r))
#define RDD_PKTGEN_TX_PARAMS_REF_PD_2_WRITE_G(v, g, idx)                                                 GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_PARAMS_STRUCT) + 16, (v))
#define RDD_PKTGEN_TX_PARAMS_REF_PD_2_READ_CORE(r, g, idx, core_id)                                      CORE_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_PARAMS_STRUCT) + 16, (r), core_id)
#define RDD_PKTGEN_TX_PARAMS_REF_PD_2_WRITE_CORE(v, g, idx, core_id)                                     CORE_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_PARAMS_STRUCT) + 16, (v), core_id)
#define RDD_PKTGEN_TX_PARAMS_REF_PD_2_READ(r, p)                                                         MREAD_32((uint8_t *)(p) + 16, (r))
#define RDD_PKTGEN_TX_PARAMS_REF_PD_2_WRITE(v, p)                                                        MWRITE_32((uint8_t *)(p) + 16, (v))
#define RDD_PKTGEN_TX_PARAMS_REF_PD_3_READ_G(r, g, idx)                                                  GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_PARAMS_STRUCT) + 20, (r))
#define RDD_PKTGEN_TX_PARAMS_REF_PD_3_WRITE_G(v, g, idx)                                                 GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_PARAMS_STRUCT) + 20, (v))
#define RDD_PKTGEN_TX_PARAMS_REF_PD_3_READ_CORE(r, g, idx, core_id)                                      CORE_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_PARAMS_STRUCT) + 20, (r), core_id)
#define RDD_PKTGEN_TX_PARAMS_REF_PD_3_WRITE_CORE(v, g, idx, core_id)                                     CORE_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_PARAMS_STRUCT) + 20, (v), core_id)
#define RDD_PKTGEN_TX_PARAMS_REF_PD_3_READ(r, p)                                                         MREAD_32((uint8_t *)(p) + 20, (r))
#define RDD_PKTGEN_TX_PARAMS_REF_PD_3_WRITE(v, p)                                                        MWRITE_32((uint8_t *)(p) + 20, (v))
#define RDD_PKTGEN_TX_PARAMS_TASK_NUM_READ_G(r, g, idx)                                                  GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PKTGEN_TX_PARAMS_STRUCT) + 24, 4, 4, (r))
#define RDD_PKTGEN_TX_PARAMS_TASK_NUM_WRITE_G(v, g, idx)                                                 GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PKTGEN_TX_PARAMS_STRUCT) + 24, 4, 4, (v))
#define RDD_PKTGEN_TX_PARAMS_TASK_NUM_READ_CORE(r, g, idx, core_id)                                      CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PKTGEN_TX_PARAMS_STRUCT) + 24, 4, 4, (r), core_id)
#define RDD_PKTGEN_TX_PARAMS_TASK_NUM_WRITE_CORE(v, g, idx, core_id)                                     CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PKTGEN_TX_PARAMS_STRUCT) + 24, 4, 4, (v), core_id)
#define RDD_PKTGEN_TX_PARAMS_TASK_NUM_READ(r, p)                                                         RDP_FIELD_MREAD_8((uint8_t *)(p) + 24, 4, 4, (r))
#define RDD_PKTGEN_TX_PARAMS_TASK_NUM_WRITE(v, p)                                                        RDP_FIELD_MWRITE_8((uint8_t *)(p) + 24, 4, 4, (v))
#define RDD_PKTGEN_TX_PARAMS_BAD_TX_NUM_OF_BNS_READ_G(r, g, idx)                                         GROUP_MREAD_16((g), (idx)*sizeof(PKTGEN_TX_PARAMS_STRUCT) + 30, (r))
#define RDD_PKTGEN_TX_PARAMS_BAD_TX_NUM_OF_BNS_WRITE_G(v, g, idx)                                        GROUP_MWRITE_16((g), (idx)*sizeof(PKTGEN_TX_PARAMS_STRUCT) + 30, (v))
#define RDD_PKTGEN_TX_PARAMS_BAD_TX_NUM_OF_BNS_READ_CORE(r, g, idx, core_id)                             CORE_MREAD_16((g), (idx)*sizeof(PKTGEN_TX_PARAMS_STRUCT) + 30, (r), core_id)
#define RDD_PKTGEN_TX_PARAMS_BAD_TX_NUM_OF_BNS_WRITE_CORE(v, g, idx, core_id)                            CORE_MWRITE_16((g), (idx)*sizeof(PKTGEN_TX_PARAMS_STRUCT) + 30, (v), core_id)
#define RDD_PKTGEN_TX_PARAMS_BAD_TX_NUM_OF_BNS_READ(r, p)                                                MREAD_16((uint8_t *)(p) + 30, (r))
#define RDD_PKTGEN_TX_PARAMS_BAD_TX_NUM_OF_BNS_WRITE(v, p)                                               MWRITE_16((uint8_t *)(p) + 30, (v))
/* <<<PKTGEN_TX_PARAMS_STRUCT */


/* >>>PKTGEN_SBPM_HDR_BN_STRUCT */
typedef union
    {
    uint8_t word_8[2];
    uint16_t word_16[1];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint16_t	first_bn  	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	ext_idx   	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#else
        uint16_t	ext_idx   	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	first_bn  	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(2))) PKTGEN_SBPM_HDR_BN_STRUCT;

#define RDD_PKTGEN_SBPM_HDR_BN_FIRST_BN_READ_G(r, g, idx)                                GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PKTGEN_SBPM_HDR_BN_STRUCT), 2, 14, (r))
#define RDD_PKTGEN_SBPM_HDR_BN_FIRST_BN_WRITE_G(v, g, idx)                               GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PKTGEN_SBPM_HDR_BN_STRUCT), 2, 14, (v))
#define RDD_PKTGEN_SBPM_HDR_BN_FIRST_BN_READ_CORE(r, g, idx, core_id)                    CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PKTGEN_SBPM_HDR_BN_STRUCT), 2, 14, (r), core_id)
#define RDD_PKTGEN_SBPM_HDR_BN_FIRST_BN_WRITE_CORE(v, g, idx, core_id)                   CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PKTGEN_SBPM_HDR_BN_STRUCT), 2, 14, (v), core_id)
#define RDD_PKTGEN_SBPM_HDR_BN_FIRST_BN_READ(r, p)                                       RDP_FIELD_MREAD_16((uint8_t *)(p), 2, 14, (r))
#define RDD_PKTGEN_SBPM_HDR_BN_FIRST_BN_WRITE(v, p)                                      RDP_FIELD_MWRITE_16((uint8_t *)(p), 2, 14, (v))
#define RDD_PKTGEN_SBPM_HDR_BN_EXT_IDX_READ_G(r, g, idx)                                 GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PKTGEN_SBPM_HDR_BN_STRUCT) + 1, 0, 2, (r))
#define RDD_PKTGEN_SBPM_HDR_BN_EXT_IDX_WRITE_G(v, g, idx)                                GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PKTGEN_SBPM_HDR_BN_STRUCT) + 1, 0, 2, (v))
#define RDD_PKTGEN_SBPM_HDR_BN_EXT_IDX_READ_CORE(r, g, idx, core_id)                     CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PKTGEN_SBPM_HDR_BN_STRUCT) + 1, 0, 2, (r), core_id)
#define RDD_PKTGEN_SBPM_HDR_BN_EXT_IDX_WRITE_CORE(v, g, idx, core_id)                    CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PKTGEN_SBPM_HDR_BN_STRUCT) + 1, 0, 2, (v), core_id)
#define RDD_PKTGEN_SBPM_HDR_BN_EXT_IDX_READ(r, p)                                        RDP_FIELD_MREAD_8((uint8_t *)(p) + 1, 0, 2, (r))
#define RDD_PKTGEN_SBPM_HDR_BN_EXT_IDX_WRITE(v, p)                                       RDP_FIELD_MWRITE_8((uint8_t *)(p) + 1, 0, 2, (v))
/* <<<PKTGEN_SBPM_HDR_BN_STRUCT */


/* >>>PKTGEN_SBPM_EXT_STRUCT */
typedef union
    {
    uint8_t word_8[4];
    uint16_t word_16[2];
    uint32_t word_32[1];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	reserved0 	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	num_of_bns	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	bn1       	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#else
        uint32_t	bn1       	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	num_of_bns	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved0 	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(4))) PKTGEN_SBPM_EXT_STRUCT;

#define RDD_PKTGEN_SBPM_EXT_NUM_OF_BNS_READ_G(r, g, idx)                                GROUP_RDP_FIELD_MREAD_32((g), (idx)*sizeof(PKTGEN_SBPM_EXT_STRUCT) + 0, 14, 4, (r))
#define RDD_PKTGEN_SBPM_EXT_NUM_OF_BNS_WRITE_G(v, g, idx)                               GROUP_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(PKTGEN_SBPM_EXT_STRUCT) + 0, 14, 4, (v))
#define RDD_PKTGEN_SBPM_EXT_NUM_OF_BNS_READ_CORE(r, g, idx, core_id)                    CORE_RDP_FIELD_MREAD_32((g), (idx)*sizeof(PKTGEN_SBPM_EXT_STRUCT) + 0, 14, 4, (r), core_id)
#define RDD_PKTGEN_SBPM_EXT_NUM_OF_BNS_WRITE_CORE(v, g, idx, core_id)                   CORE_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(PKTGEN_SBPM_EXT_STRUCT) + 0, 14, 4, (v), core_id)
#define RDD_PKTGEN_SBPM_EXT_NUM_OF_BNS_READ(r, p)                                       RDP_FIELD_MREAD_32((uint8_t *)(p) + 0, 14, 4, (r))
#define RDD_PKTGEN_SBPM_EXT_NUM_OF_BNS_WRITE(v, p)                                      RDP_FIELD_MWRITE_32((uint8_t *)(p) + 0, 14, 4, (v))
#define RDD_PKTGEN_SBPM_EXT_BN1_READ_G(r, g, idx)                                       GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PKTGEN_SBPM_EXT_STRUCT) + 2, 0, 14, (r))
#define RDD_PKTGEN_SBPM_EXT_BN1_WRITE_G(v, g, idx)                                      GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PKTGEN_SBPM_EXT_STRUCT) + 2, 0, 14, (v))
#define RDD_PKTGEN_SBPM_EXT_BN1_READ_CORE(r, g, idx, core_id)                           CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PKTGEN_SBPM_EXT_STRUCT) + 2, 0, 14, (r), core_id)
#define RDD_PKTGEN_SBPM_EXT_BN1_WRITE_CORE(v, g, idx, core_id)                          CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PKTGEN_SBPM_EXT_STRUCT) + 2, 0, 14, (v), core_id)
#define RDD_PKTGEN_SBPM_EXT_BN1_READ(r, p)                                              RDP_FIELD_MREAD_16((uint8_t *)(p) + 2, 0, 14, (r))
#define RDD_PKTGEN_SBPM_EXT_BN1_WRITE(v, p)                                             RDP_FIELD_MWRITE_16((uint8_t *)(p) + 2, 0, 14, (v))
/* <<<PKTGEN_SBPM_EXT_STRUCT */


/* >>>PKTGEN_FPM_UG_MGMT_ENTRY_STRUCT */
typedef union
    {
    uint8_t word_8[20];
    uint16_t word_16[10];
    uint32_t word_32[5];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	fpm_ug_cnt_dummy   	;
        uint32_t	fpm_ug_cnt         	;
        uint32_t	fpm_ug_cnt_reg_addr	;
        uint32_t	fpm_ug_threshold   	:28	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	fpm_tokens_quantum 	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	budget             	;
#else
        uint32_t	fpm_ug_cnt_dummy   	;
        uint32_t	fpm_ug_cnt         	;
        uint32_t	fpm_ug_cnt_reg_addr	;
        uint32_t	fpm_tokens_quantum 	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	fpm_ug_threshold   	:28	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	budget             	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(4))) PKTGEN_FPM_UG_MGMT_ENTRY_STRUCT;

#define RDD_PKTGEN_FPM_UG_MGMT_ENTRY_FPM_UG_CNT_DUMMY_READ_G(r, g, idx)                                   GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_FPM_UG_MGMT_ENTRY_STRUCT), (r))
#define RDD_PKTGEN_FPM_UG_MGMT_ENTRY_FPM_UG_CNT_DUMMY_WRITE_G(v, g, idx)                                  GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_FPM_UG_MGMT_ENTRY_STRUCT), (v))
#define RDD_PKTGEN_FPM_UG_MGMT_ENTRY_FPM_UG_CNT_DUMMY_READ_CORE(r, g, idx, core_id)                       CORE_MREAD_32((g), (idx)*sizeof(PKTGEN_FPM_UG_MGMT_ENTRY_STRUCT), (r), core_id)
#define RDD_PKTGEN_FPM_UG_MGMT_ENTRY_FPM_UG_CNT_DUMMY_WRITE_CORE(v, g, idx, core_id)                      CORE_MWRITE_32((g), (idx)*sizeof(PKTGEN_FPM_UG_MGMT_ENTRY_STRUCT), (v), core_id)
#define RDD_PKTGEN_FPM_UG_MGMT_ENTRY_FPM_UG_CNT_DUMMY_READ(r, p)                                          MREAD_32((uint8_t *)(p), (r))
#define RDD_PKTGEN_FPM_UG_MGMT_ENTRY_FPM_UG_CNT_DUMMY_WRITE(v, p)                                         MWRITE_32((uint8_t *)(p), (v))
#define RDD_PKTGEN_FPM_UG_MGMT_ENTRY_FPM_UG_CNT_READ_G(r, g, idx)                                         GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_FPM_UG_MGMT_ENTRY_STRUCT) + 4, (r))
#define RDD_PKTGEN_FPM_UG_MGMT_ENTRY_FPM_UG_CNT_WRITE_G(v, g, idx)                                        GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_FPM_UG_MGMT_ENTRY_STRUCT) + 4, (v))
#define RDD_PKTGEN_FPM_UG_MGMT_ENTRY_FPM_UG_CNT_READ_CORE(r, g, idx, core_id)                             CORE_MREAD_32((g), (idx)*sizeof(PKTGEN_FPM_UG_MGMT_ENTRY_STRUCT) + 4, (r), core_id)
#define RDD_PKTGEN_FPM_UG_MGMT_ENTRY_FPM_UG_CNT_WRITE_CORE(v, g, idx, core_id)                            CORE_MWRITE_32((g), (idx)*sizeof(PKTGEN_FPM_UG_MGMT_ENTRY_STRUCT) + 4, (v), core_id)
#define RDD_PKTGEN_FPM_UG_MGMT_ENTRY_FPM_UG_CNT_READ(r, p)                                                MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_PKTGEN_FPM_UG_MGMT_ENTRY_FPM_UG_CNT_WRITE(v, p)                                               MWRITE_32((uint8_t *)(p) + 4, (v))
#define RDD_PKTGEN_FPM_UG_MGMT_ENTRY_FPM_UG_CNT_REG_ADDR_READ_G(r, g, idx)                                GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_FPM_UG_MGMT_ENTRY_STRUCT) + 8, (r))
#define RDD_PKTGEN_FPM_UG_MGMT_ENTRY_FPM_UG_CNT_REG_ADDR_WRITE_G(v, g, idx)                               GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_FPM_UG_MGMT_ENTRY_STRUCT) + 8, (v))
#define RDD_PKTGEN_FPM_UG_MGMT_ENTRY_FPM_UG_CNT_REG_ADDR_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_32((g), (idx)*sizeof(PKTGEN_FPM_UG_MGMT_ENTRY_STRUCT) + 8, (r), core_id)
#define RDD_PKTGEN_FPM_UG_MGMT_ENTRY_FPM_UG_CNT_REG_ADDR_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_32((g), (idx)*sizeof(PKTGEN_FPM_UG_MGMT_ENTRY_STRUCT) + 8, (v), core_id)
#define RDD_PKTGEN_FPM_UG_MGMT_ENTRY_FPM_UG_CNT_REG_ADDR_READ(r, p)                                       MREAD_32((uint8_t *)(p) + 8, (r))
#define RDD_PKTGEN_FPM_UG_MGMT_ENTRY_FPM_UG_CNT_REG_ADDR_WRITE(v, p)                                      MWRITE_32((uint8_t *)(p) + 8, (v))
#define RDD_PKTGEN_FPM_UG_MGMT_ENTRY_FPM_UG_THRESHOLD_READ_G(r, g, idx)                                   GROUP_RDP_FIELD_MREAD_32((g), (idx)*sizeof(PKTGEN_FPM_UG_MGMT_ENTRY_STRUCT) + 12, 4, 28, (r))
#define RDD_PKTGEN_FPM_UG_MGMT_ENTRY_FPM_UG_THRESHOLD_WRITE_G(v, g, idx)                                  GROUP_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(PKTGEN_FPM_UG_MGMT_ENTRY_STRUCT) + 12, 4, 28, (v))
#define RDD_PKTGEN_FPM_UG_MGMT_ENTRY_FPM_UG_THRESHOLD_READ_CORE(r, g, idx, core_id)                       CORE_RDP_FIELD_MREAD_32((g), (idx)*sizeof(PKTGEN_FPM_UG_MGMT_ENTRY_STRUCT) + 12, 4, 28, (r), core_id)
#define RDD_PKTGEN_FPM_UG_MGMT_ENTRY_FPM_UG_THRESHOLD_WRITE_CORE(v, g, idx, core_id)                      CORE_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(PKTGEN_FPM_UG_MGMT_ENTRY_STRUCT) + 12, 4, 28, (v), core_id)
#define RDD_PKTGEN_FPM_UG_MGMT_ENTRY_FPM_UG_THRESHOLD_READ(r, p)                                          RDP_FIELD_MREAD_32((uint8_t *)(p) + 12, 4, 28, (r))
#define RDD_PKTGEN_FPM_UG_MGMT_ENTRY_FPM_UG_THRESHOLD_WRITE(v, p)                                         RDP_FIELD_MWRITE_32((uint8_t *)(p) + 12, 4, 28, (v))
#define RDD_PKTGEN_FPM_UG_MGMT_ENTRY_FPM_TOKENS_QUANTUM_READ_G(r, g, idx)                                 GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PKTGEN_FPM_UG_MGMT_ENTRY_STRUCT) + 15, 0, 4, (r))
#define RDD_PKTGEN_FPM_UG_MGMT_ENTRY_FPM_TOKENS_QUANTUM_WRITE_G(v, g, idx)                                GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PKTGEN_FPM_UG_MGMT_ENTRY_STRUCT) + 15, 0, 4, (v))
#define RDD_PKTGEN_FPM_UG_MGMT_ENTRY_FPM_TOKENS_QUANTUM_READ_CORE(r, g, idx, core_id)                     CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PKTGEN_FPM_UG_MGMT_ENTRY_STRUCT) + 15, 0, 4, (r), core_id)
#define RDD_PKTGEN_FPM_UG_MGMT_ENTRY_FPM_TOKENS_QUANTUM_WRITE_CORE(v, g, idx, core_id)                    CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PKTGEN_FPM_UG_MGMT_ENTRY_STRUCT) + 15, 0, 4, (v), core_id)
#define RDD_PKTGEN_FPM_UG_MGMT_ENTRY_FPM_TOKENS_QUANTUM_READ(r, p)                                        RDP_FIELD_MREAD_8((uint8_t *)(p) + 15, 0, 4, (r))
#define RDD_PKTGEN_FPM_UG_MGMT_ENTRY_FPM_TOKENS_QUANTUM_WRITE(v, p)                                       RDP_FIELD_MWRITE_8((uint8_t *)(p) + 15, 0, 4, (v))
#define RDD_PKTGEN_FPM_UG_MGMT_ENTRY_BUDGET_READ_G(r, g, idx)                                             GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_FPM_UG_MGMT_ENTRY_STRUCT) + 16, (r))
#define RDD_PKTGEN_FPM_UG_MGMT_ENTRY_BUDGET_WRITE_G(v, g, idx)                                            GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_FPM_UG_MGMT_ENTRY_STRUCT) + 16, (v))
#define RDD_PKTGEN_FPM_UG_MGMT_ENTRY_BUDGET_READ_CORE(r, g, idx, core_id)                                 CORE_MREAD_32((g), (idx)*sizeof(PKTGEN_FPM_UG_MGMT_ENTRY_STRUCT) + 16, (r), core_id)
#define RDD_PKTGEN_FPM_UG_MGMT_ENTRY_BUDGET_WRITE_CORE(v, g, idx, core_id)                                CORE_MWRITE_32((g), (idx)*sizeof(PKTGEN_FPM_UG_MGMT_ENTRY_STRUCT) + 16, (v), core_id)
#define RDD_PKTGEN_FPM_UG_MGMT_ENTRY_BUDGET_READ(r, p)                                                    MREAD_32((uint8_t *)(p) + 16, (r))
#define RDD_PKTGEN_FPM_UG_MGMT_ENTRY_BUDGET_WRITE(v, p)                                                   MWRITE_32((uint8_t *)(p) + 16, (v))
/* <<<PKTGEN_FPM_UG_MGMT_ENTRY_STRUCT */


/* >>>ENTRY_PARMS_STRUCT */
typedef union
    {
    uint8_t word_8[8];
    uint16_t word_16[4];
    uint32_t word_32[2];
    uint64_t dword_64[1];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
	/* Union WORD 0 */
	union{
		/* Sub Union 0 */
		struct{
        uint16_t	wan_flow          	;
        uint16_t	reserved          	;
		};
	};
	/* Union WORD 1 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	tcp_udp_parms     	; /* This is a field union */
		};
		/* Sub Union 1 */
		struct{
        uint8_t	l2_hdr_len                  	; /* Member of tcp_udp_parms union */
        uint8_t	l3_hdr_len                  	; /* Member of tcp_udp_parms union */
        uint8_t	l3_protocol                 	; /* Member of tcp_udp_parms union */
        uint8_t	tx_hdr_len                  	; /* Member of tcp_udp_parms union */
		};
		/* Sub Union 2 */
		struct{
        uint16_t	udp_payload_offset          	; /* Member of tcp_udp_parms union */
        uint16_t	udp_csum                    	; /* Member of tcp_udp_parms union */
		};
	};
#else
	/* Union WORD 0 */
	union{
		/* Sub Union 0 */
		struct{
        uint16_t	reserved          	;
        uint16_t	wan_flow          	;
		};
	};
	/* Union WORD 1 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	tcp_udp_parms     	; /* This is a field union */
		};
		/* Sub Union 1 */
		struct{
        uint8_t	tx_hdr_len                  	; /* Member of tcp_udp_parms union */
        uint8_t	l3_protocol                 	; /* Member of tcp_udp_parms union */
        uint8_t	l3_hdr_len                  	; /* Member of tcp_udp_parms union */
        uint8_t	l2_hdr_len                  	; /* Member of tcp_udp_parms union */
		};
		/* Sub Union 2 */
		struct{
        uint16_t	udp_csum                    	; /* Member of tcp_udp_parms union */
        uint16_t	udp_payload_offset          	; /* Member of tcp_udp_parms union */
		};
	};
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) ENTRY_PARMS_STRUCT;

#define RDD_ENTRY_PARMS_WAN_FLOW_READ_G(r, g, idx)                                          GROUP_MREAD_16((g), (idx)*sizeof(ENTRY_PARMS_STRUCT), (r))
#define RDD_ENTRY_PARMS_WAN_FLOW_WRITE_G(v, g, idx)                                         GROUP_MWRITE_16((g), (idx)*sizeof(ENTRY_PARMS_STRUCT), (v))
#define RDD_ENTRY_PARMS_WAN_FLOW_READ_CORE(r, g, idx, core_id)                              CORE_MREAD_16((g), (idx)*sizeof(ENTRY_PARMS_STRUCT), (r), core_id)
#define RDD_ENTRY_PARMS_WAN_FLOW_WRITE_CORE(v, g, idx, core_id)                             CORE_MWRITE_16((g), (idx)*sizeof(ENTRY_PARMS_STRUCT), (v), core_id)
#define RDD_ENTRY_PARMS_WAN_FLOW_READ(r, p)                                                 MREAD_16((uint8_t *)(p), (r))
#define RDD_ENTRY_PARMS_WAN_FLOW_WRITE(v, p)                                                MWRITE_16((uint8_t *)(p), (v))
#define RDD_ENTRY_PARMS_TCP_UDP_PARMS_READ_G(r, g, idx)                                     GROUP_MREAD_32((g), (idx)*sizeof(ENTRY_PARMS_STRUCT) + 4, (r))
#define RDD_ENTRY_PARMS_TCP_UDP_PARMS_WRITE_G(v, g, idx)                                    GROUP_MWRITE_32((g), (idx)*sizeof(ENTRY_PARMS_STRUCT) + 4, (v))
#define RDD_ENTRY_PARMS_TCP_UDP_PARMS_READ_CORE(r, g, idx, core_id)                         CORE_MREAD_32((g), (idx)*sizeof(ENTRY_PARMS_STRUCT) + 4, (r), core_id)
#define RDD_ENTRY_PARMS_TCP_UDP_PARMS_WRITE_CORE(v, g, idx, core_id)                        CORE_MWRITE_32((g), (idx)*sizeof(ENTRY_PARMS_STRUCT) + 4, (v), core_id)
#define RDD_ENTRY_PARMS_TCP_UDP_PARMS_READ(r, p)                                            MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_ENTRY_PARMS_TCP_UDP_PARMS_WRITE(v, p)                                           MWRITE_32((uint8_t *)(p) + 4, (v))
#define RDD_ENTRY_PARMS_L2_HDR_LEN_READ_G(r, g, idx)                                        GROUP_MREAD_8((g), (idx)*sizeof(ENTRY_PARMS_STRUCT) + 4, (r))
#define RDD_ENTRY_PARMS_L2_HDR_LEN_WRITE_G(v, g, idx)                                       GROUP_MWRITE_8((g), (idx)*sizeof(ENTRY_PARMS_STRUCT) + 4, (v))
#define RDD_ENTRY_PARMS_L2_HDR_LEN_READ_CORE(r, g, idx, core_id)                            CORE_MREAD_8((g), (idx)*sizeof(ENTRY_PARMS_STRUCT) + 4, (r), core_id)
#define RDD_ENTRY_PARMS_L2_HDR_LEN_WRITE_CORE(v, g, idx, core_id)                           CORE_MWRITE_8((g), (idx)*sizeof(ENTRY_PARMS_STRUCT) + 4, (v), core_id)
#define RDD_ENTRY_PARMS_L2_HDR_LEN_READ(r, p)                                               MREAD_8((uint8_t *)(p) + 4, (r))
#define RDD_ENTRY_PARMS_L2_HDR_LEN_WRITE(v, p)                                              MWRITE_8((uint8_t *)(p) + 4, (v))
#define RDD_ENTRY_PARMS_L3_HDR_LEN_READ_G(r, g, idx)                                        GROUP_MREAD_8((g), (idx)*sizeof(ENTRY_PARMS_STRUCT) + 5, (r))
#define RDD_ENTRY_PARMS_L3_HDR_LEN_WRITE_G(v, g, idx)                                       GROUP_MWRITE_8((g), (idx)*sizeof(ENTRY_PARMS_STRUCT) + 5, (v))
#define RDD_ENTRY_PARMS_L3_HDR_LEN_READ_CORE(r, g, idx, core_id)                            CORE_MREAD_8((g), (idx)*sizeof(ENTRY_PARMS_STRUCT) + 5, (r), core_id)
#define RDD_ENTRY_PARMS_L3_HDR_LEN_WRITE_CORE(v, g, idx, core_id)                           CORE_MWRITE_8((g), (idx)*sizeof(ENTRY_PARMS_STRUCT) + 5, (v), core_id)
#define RDD_ENTRY_PARMS_L3_HDR_LEN_READ(r, p)                                               MREAD_8((uint8_t *)(p) + 5, (r))
#define RDD_ENTRY_PARMS_L3_HDR_LEN_WRITE(v, p)                                              MWRITE_8((uint8_t *)(p) + 5, (v))
#define RDD_ENTRY_PARMS_L3_PROTOCOL_READ_G(r, g, idx)                                       GROUP_MREAD_8((g), (idx)*sizeof(ENTRY_PARMS_STRUCT) + 6, (r))
#define RDD_ENTRY_PARMS_L3_PROTOCOL_WRITE_G(v, g, idx)                                      GROUP_MWRITE_8((g), (idx)*sizeof(ENTRY_PARMS_STRUCT) + 6, (v))
#define RDD_ENTRY_PARMS_L3_PROTOCOL_READ_CORE(r, g, idx, core_id)                           CORE_MREAD_8((g), (idx)*sizeof(ENTRY_PARMS_STRUCT) + 6, (r), core_id)
#define RDD_ENTRY_PARMS_L3_PROTOCOL_WRITE_CORE(v, g, idx, core_id)                          CORE_MWRITE_8((g), (idx)*sizeof(ENTRY_PARMS_STRUCT) + 6, (v), core_id)
#define RDD_ENTRY_PARMS_L3_PROTOCOL_READ(r, p)                                              MREAD_8((uint8_t *)(p) + 6, (r))
#define RDD_ENTRY_PARMS_L3_PROTOCOL_WRITE(v, p)                                             MWRITE_8((uint8_t *)(p) + 6, (v))
#define RDD_ENTRY_PARMS_TX_HDR_LEN_READ_G(r, g, idx)                                        GROUP_MREAD_8((g), (idx)*sizeof(ENTRY_PARMS_STRUCT) + 7, (r))
#define RDD_ENTRY_PARMS_TX_HDR_LEN_WRITE_G(v, g, idx)                                       GROUP_MWRITE_8((g), (idx)*sizeof(ENTRY_PARMS_STRUCT) + 7, (v))
#define RDD_ENTRY_PARMS_TX_HDR_LEN_READ_CORE(r, g, idx, core_id)                            CORE_MREAD_8((g), (idx)*sizeof(ENTRY_PARMS_STRUCT) + 7, (r), core_id)
#define RDD_ENTRY_PARMS_TX_HDR_LEN_WRITE_CORE(v, g, idx, core_id)                           CORE_MWRITE_8((g), (idx)*sizeof(ENTRY_PARMS_STRUCT) + 7, (v), core_id)
#define RDD_ENTRY_PARMS_TX_HDR_LEN_READ(r, p)                                               MREAD_8((uint8_t *)(p) + 7, (r))
#define RDD_ENTRY_PARMS_TX_HDR_LEN_WRITE(v, p)                                              MWRITE_8((uint8_t *)(p) + 7, (v))
#define RDD_ENTRY_PARMS_UDP_PAYLOAD_OFFSET_READ_G(r, g, idx)                                GROUP_MREAD_16((g), (idx)*sizeof(ENTRY_PARMS_STRUCT) + 4, (r))
#define RDD_ENTRY_PARMS_UDP_PAYLOAD_OFFSET_WRITE_G(v, g, idx)                               GROUP_MWRITE_16((g), (idx)*sizeof(ENTRY_PARMS_STRUCT) + 4, (v))
#define RDD_ENTRY_PARMS_UDP_PAYLOAD_OFFSET_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_16((g), (idx)*sizeof(ENTRY_PARMS_STRUCT) + 4, (r), core_id)
#define RDD_ENTRY_PARMS_UDP_PAYLOAD_OFFSET_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_16((g), (idx)*sizeof(ENTRY_PARMS_STRUCT) + 4, (v), core_id)
#define RDD_ENTRY_PARMS_UDP_PAYLOAD_OFFSET_READ(r, p)                                       MREAD_16((uint8_t *)(p) + 4, (r))
#define RDD_ENTRY_PARMS_UDP_PAYLOAD_OFFSET_WRITE(v, p)                                      MWRITE_16((uint8_t *)(p) + 4, (v))
#define RDD_ENTRY_PARMS_UDP_CSUM_READ_G(r, g, idx)                                          GROUP_MREAD_16((g), (idx)*sizeof(ENTRY_PARMS_STRUCT) + 6, (r))
#define RDD_ENTRY_PARMS_UDP_CSUM_WRITE_G(v, g, idx)                                         GROUP_MWRITE_16((g), (idx)*sizeof(ENTRY_PARMS_STRUCT) + 6, (v))
#define RDD_ENTRY_PARMS_UDP_CSUM_READ_CORE(r, g, idx, core_id)                              CORE_MREAD_16((g), (idx)*sizeof(ENTRY_PARMS_STRUCT) + 6, (r), core_id)
#define RDD_ENTRY_PARMS_UDP_CSUM_WRITE_CORE(v, g, idx, core_id)                             CORE_MWRITE_16((g), (idx)*sizeof(ENTRY_PARMS_STRUCT) + 6, (v), core_id)
#define RDD_ENTRY_PARMS_UDP_CSUM_READ(r, p)                                                 MREAD_16((uint8_t *)(p) + 6, (r))
#define RDD_ENTRY_PARMS_UDP_CSUM_WRITE(v, p)                                                MWRITE_16((uint8_t *)(p) + 6, (v))
/* <<<ENTRY_PARMS_STRUCT */


/* >>>REF_PKT_HDR_STRUCT */
typedef union
    {
    uint8_t word_8[128];
    uint16_t word_16[64];
    uint32_t word_32[32];
    uint64_t dword_64[16];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint16_t	size      	;
        uint16_t	offset    	;
        uint32_t	reserved  	;
        uint32_t	hdr       	;
        uint32_t	hdr_1     	;
        uint32_t	hdr_2     	;
        uint32_t	hdr_3     	;
        uint32_t	hdr_4     	;
        uint32_t	hdr_5     	;
        uint32_t	hdr_6     	;
        uint32_t	hdr_7     	;
        uint32_t	hdr_8     	;
        uint32_t	hdr_9     	;
        uint32_t	hdr_10    	;
        uint32_t	hdr_11    	;
        uint32_t	hdr_12    	;
        uint32_t	hdr_13    	;
        uint32_t	hdr_14    	;
        uint32_t	hdr_15    	;
        uint32_t	hdr_16    	;
        uint32_t	hdr_17    	;
        uint32_t	hdr_18    	;
        uint32_t	hdr_19    	;
        uint32_t	hdr_20    	;
        uint32_t	hdr_21    	;
        uint32_t	hdr_22    	;
        uint32_t	hdr_23    	;
        uint32_t	hdr_24    	;
        uint32_t	hdr_25    	;
        uint32_t	hdr_26    	;
        uint32_t	hdr_27    	;
        uint32_t	hdr_28    	;
        uint32_t	hdr_29    	;
#else
        uint16_t	offset    	;
        uint16_t	size      	;
        uint32_t	reserved  	;
        uint32_t	hdr       	;
        uint32_t	hdr_1     	;
        uint32_t	hdr_2     	;
        uint32_t	hdr_3     	;
        uint32_t	hdr_4     	;
        uint32_t	hdr_5     	;
        uint32_t	hdr_6     	;
        uint32_t	hdr_7     	;
        uint32_t	hdr_8     	;
        uint32_t	hdr_9     	;
        uint32_t	hdr_10    	;
        uint32_t	hdr_11    	;
        uint32_t	hdr_12    	;
        uint32_t	hdr_13    	;
        uint32_t	hdr_14    	;
        uint32_t	hdr_15    	;
        uint32_t	hdr_16    	;
        uint32_t	hdr_17    	;
        uint32_t	hdr_18    	;
        uint32_t	hdr_19    	;
        uint32_t	hdr_20    	;
        uint32_t	hdr_21    	;
        uint32_t	hdr_22    	;
        uint32_t	hdr_23    	;
        uint32_t	hdr_24    	;
        uint32_t	hdr_25    	;
        uint32_t	hdr_26    	;
        uint32_t	hdr_27    	;
        uint32_t	hdr_28    	;
        uint32_t	hdr_29    	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) REF_PKT_HDR_STRUCT;

#define RDD_REF_PKT_HDR_SIZE_READ_G(r, g, idx)                                    GROUP_MREAD_16((g), (idx)*sizeof(REF_PKT_HDR_STRUCT), (r))
#define RDD_REF_PKT_HDR_SIZE_WRITE_G(v, g, idx)                                   GROUP_MWRITE_16((g), (idx)*sizeof(REF_PKT_HDR_STRUCT), (v))
#define RDD_REF_PKT_HDR_SIZE_READ_CORE(r, g, idx, core_id)                        CORE_MREAD_16((g), (idx)*sizeof(REF_PKT_HDR_STRUCT), (r), core_id)
#define RDD_REF_PKT_HDR_SIZE_WRITE_CORE(v, g, idx, core_id)                       CORE_MWRITE_16((g), (idx)*sizeof(REF_PKT_HDR_STRUCT), (v), core_id)
#define RDD_REF_PKT_HDR_SIZE_READ(r, p)                                           MREAD_16((uint8_t *)(p), (r))
#define RDD_REF_PKT_HDR_SIZE_WRITE(v, p)                                          MWRITE_16((uint8_t *)(p), (v))
#define RDD_REF_PKT_HDR_OFFSET_READ_G(r, g, idx)                                  GROUP_MREAD_16((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 2, (r))
#define RDD_REF_PKT_HDR_OFFSET_WRITE_G(v, g, idx)                                 GROUP_MWRITE_16((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 2, (v))
#define RDD_REF_PKT_HDR_OFFSET_READ_CORE(r, g, idx, core_id)                      CORE_MREAD_16((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 2, (r), core_id)
#define RDD_REF_PKT_HDR_OFFSET_WRITE_CORE(v, g, idx, core_id)                     CORE_MWRITE_16((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 2, (v), core_id)
#define RDD_REF_PKT_HDR_OFFSET_READ(r, p)                                         MREAD_16((uint8_t *)(p) + 2, (r))
#define RDD_REF_PKT_HDR_OFFSET_WRITE(v, p)                                        MWRITE_16((uint8_t *)(p) + 2, (v))
#define RDD_REF_PKT_HDR_HDR_READ_G(r, g, idx)                                     GROUP_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 8, (r))
#define RDD_REF_PKT_HDR_HDR_WRITE_G(v, g, idx)                                    GROUP_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 8, (v))
#define RDD_REF_PKT_HDR_HDR_READ_CORE(r, g, idx, core_id)                         CORE_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 8, (r), core_id)
#define RDD_REF_PKT_HDR_HDR_WRITE_CORE(v, g, idx, core_id)                        CORE_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 8, (v), core_id)
#define RDD_REF_PKT_HDR_HDR_READ(r, p)                                            MREAD_32((uint8_t *)(p) + 8, (r))
#define RDD_REF_PKT_HDR_HDR_WRITE(v, p)                                           MWRITE_32((uint8_t *)(p) + 8, (v))
#define RDD_REF_PKT_HDR_HDR_1_READ_G(r, g, idx)                                   GROUP_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 12, (r))
#define RDD_REF_PKT_HDR_HDR_1_WRITE_G(v, g, idx)                                  GROUP_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 12, (v))
#define RDD_REF_PKT_HDR_HDR_1_READ_CORE(r, g, idx, core_id)                       CORE_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 12, (r), core_id)
#define RDD_REF_PKT_HDR_HDR_1_WRITE_CORE(v, g, idx, core_id)                      CORE_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 12, (v), core_id)
#define RDD_REF_PKT_HDR_HDR_1_READ(r, p)                                          MREAD_32((uint8_t *)(p) + 12, (r))
#define RDD_REF_PKT_HDR_HDR_1_WRITE(v, p)                                         MWRITE_32((uint8_t *)(p) + 12, (v))
#define RDD_REF_PKT_HDR_HDR_2_READ_G(r, g, idx)                                   GROUP_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 16, (r))
#define RDD_REF_PKT_HDR_HDR_2_WRITE_G(v, g, idx)                                  GROUP_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 16, (v))
#define RDD_REF_PKT_HDR_HDR_2_READ_CORE(r, g, idx, core_id)                       CORE_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 16, (r), core_id)
#define RDD_REF_PKT_HDR_HDR_2_WRITE_CORE(v, g, idx, core_id)                      CORE_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 16, (v), core_id)
#define RDD_REF_PKT_HDR_HDR_2_READ(r, p)                                          MREAD_32((uint8_t *)(p) + 16, (r))
#define RDD_REF_PKT_HDR_HDR_2_WRITE(v, p)                                         MWRITE_32((uint8_t *)(p) + 16, (v))
#define RDD_REF_PKT_HDR_HDR_3_READ_G(r, g, idx)                                   GROUP_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 20, (r))
#define RDD_REF_PKT_HDR_HDR_3_WRITE_G(v, g, idx)                                  GROUP_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 20, (v))
#define RDD_REF_PKT_HDR_HDR_3_READ_CORE(r, g, idx, core_id)                       CORE_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 20, (r), core_id)
#define RDD_REF_PKT_HDR_HDR_3_WRITE_CORE(v, g, idx, core_id)                      CORE_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 20, (v), core_id)
#define RDD_REF_PKT_HDR_HDR_3_READ(r, p)                                          MREAD_32((uint8_t *)(p) + 20, (r))
#define RDD_REF_PKT_HDR_HDR_3_WRITE(v, p)                                         MWRITE_32((uint8_t *)(p) + 20, (v))
#define RDD_REF_PKT_HDR_HDR_4_READ_G(r, g, idx)                                   GROUP_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 24, (r))
#define RDD_REF_PKT_HDR_HDR_4_WRITE_G(v, g, idx)                                  GROUP_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 24, (v))
#define RDD_REF_PKT_HDR_HDR_4_READ_CORE(r, g, idx, core_id)                       CORE_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 24, (r), core_id)
#define RDD_REF_PKT_HDR_HDR_4_WRITE_CORE(v, g, idx, core_id)                      CORE_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 24, (v), core_id)
#define RDD_REF_PKT_HDR_HDR_4_READ(r, p)                                          MREAD_32((uint8_t *)(p) + 24, (r))
#define RDD_REF_PKT_HDR_HDR_4_WRITE(v, p)                                         MWRITE_32((uint8_t *)(p) + 24, (v))
#define RDD_REF_PKT_HDR_HDR_5_READ_G(r, g, idx)                                   GROUP_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 28, (r))
#define RDD_REF_PKT_HDR_HDR_5_WRITE_G(v, g, idx)                                  GROUP_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 28, (v))
#define RDD_REF_PKT_HDR_HDR_5_READ_CORE(r, g, idx, core_id)                       CORE_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 28, (r), core_id)
#define RDD_REF_PKT_HDR_HDR_5_WRITE_CORE(v, g, idx, core_id)                      CORE_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 28, (v), core_id)
#define RDD_REF_PKT_HDR_HDR_5_READ(r, p)                                          MREAD_32((uint8_t *)(p) + 28, (r))
#define RDD_REF_PKT_HDR_HDR_5_WRITE(v, p)                                         MWRITE_32((uint8_t *)(p) + 28, (v))
#define RDD_REF_PKT_HDR_HDR_6_READ_G(r, g, idx)                                   GROUP_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 32, (r))
#define RDD_REF_PKT_HDR_HDR_6_WRITE_G(v, g, idx)                                  GROUP_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 32, (v))
#define RDD_REF_PKT_HDR_HDR_6_READ_CORE(r, g, idx, core_id)                       CORE_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 32, (r), core_id)
#define RDD_REF_PKT_HDR_HDR_6_WRITE_CORE(v, g, idx, core_id)                      CORE_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 32, (v), core_id)
#define RDD_REF_PKT_HDR_HDR_6_READ(r, p)                                          MREAD_32((uint8_t *)(p) + 32, (r))
#define RDD_REF_PKT_HDR_HDR_6_WRITE(v, p)                                         MWRITE_32((uint8_t *)(p) + 32, (v))
#define RDD_REF_PKT_HDR_HDR_7_READ_G(r, g, idx)                                   GROUP_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 36, (r))
#define RDD_REF_PKT_HDR_HDR_7_WRITE_G(v, g, idx)                                  GROUP_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 36, (v))
#define RDD_REF_PKT_HDR_HDR_7_READ_CORE(r, g, idx, core_id)                       CORE_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 36, (r), core_id)
#define RDD_REF_PKT_HDR_HDR_7_WRITE_CORE(v, g, idx, core_id)                      CORE_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 36, (v), core_id)
#define RDD_REF_PKT_HDR_HDR_7_READ(r, p)                                          MREAD_32((uint8_t *)(p) + 36, (r))
#define RDD_REF_PKT_HDR_HDR_7_WRITE(v, p)                                         MWRITE_32((uint8_t *)(p) + 36, (v))
#define RDD_REF_PKT_HDR_HDR_8_READ_G(r, g, idx)                                   GROUP_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 40, (r))
#define RDD_REF_PKT_HDR_HDR_8_WRITE_G(v, g, idx)                                  GROUP_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 40, (v))
#define RDD_REF_PKT_HDR_HDR_8_READ_CORE(r, g, idx, core_id)                       CORE_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 40, (r), core_id)
#define RDD_REF_PKT_HDR_HDR_8_WRITE_CORE(v, g, idx, core_id)                      CORE_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 40, (v), core_id)
#define RDD_REF_PKT_HDR_HDR_8_READ(r, p)                                          MREAD_32((uint8_t *)(p) + 40, (r))
#define RDD_REF_PKT_HDR_HDR_8_WRITE(v, p)                                         MWRITE_32((uint8_t *)(p) + 40, (v))
#define RDD_REF_PKT_HDR_HDR_9_READ_G(r, g, idx)                                   GROUP_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 44, (r))
#define RDD_REF_PKT_HDR_HDR_9_WRITE_G(v, g, idx)                                  GROUP_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 44, (v))
#define RDD_REF_PKT_HDR_HDR_9_READ_CORE(r, g, idx, core_id)                       CORE_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 44, (r), core_id)
#define RDD_REF_PKT_HDR_HDR_9_WRITE_CORE(v, g, idx, core_id)                      CORE_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 44, (v), core_id)
#define RDD_REF_PKT_HDR_HDR_9_READ(r, p)                                          MREAD_32((uint8_t *)(p) + 44, (r))
#define RDD_REF_PKT_HDR_HDR_9_WRITE(v, p)                                         MWRITE_32((uint8_t *)(p) + 44, (v))
#define RDD_REF_PKT_HDR_HDR_10_READ_G(r, g, idx)                                  GROUP_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 48, (r))
#define RDD_REF_PKT_HDR_HDR_10_WRITE_G(v, g, idx)                                 GROUP_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 48, (v))
#define RDD_REF_PKT_HDR_HDR_10_READ_CORE(r, g, idx, core_id)                      CORE_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 48, (r), core_id)
#define RDD_REF_PKT_HDR_HDR_10_WRITE_CORE(v, g, idx, core_id)                     CORE_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 48, (v), core_id)
#define RDD_REF_PKT_HDR_HDR_10_READ(r, p)                                         MREAD_32((uint8_t *)(p) + 48, (r))
#define RDD_REF_PKT_HDR_HDR_10_WRITE(v, p)                                        MWRITE_32((uint8_t *)(p) + 48, (v))
#define RDD_REF_PKT_HDR_HDR_11_READ_G(r, g, idx)                                  GROUP_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 52, (r))
#define RDD_REF_PKT_HDR_HDR_11_WRITE_G(v, g, idx)                                 GROUP_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 52, (v))
#define RDD_REF_PKT_HDR_HDR_11_READ_CORE(r, g, idx, core_id)                      CORE_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 52, (r), core_id)
#define RDD_REF_PKT_HDR_HDR_11_WRITE_CORE(v, g, idx, core_id)                     CORE_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 52, (v), core_id)
#define RDD_REF_PKT_HDR_HDR_11_READ(r, p)                                         MREAD_32((uint8_t *)(p) + 52, (r))
#define RDD_REF_PKT_HDR_HDR_11_WRITE(v, p)                                        MWRITE_32((uint8_t *)(p) + 52, (v))
#define RDD_REF_PKT_HDR_HDR_12_READ_G(r, g, idx)                                  GROUP_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 56, (r))
#define RDD_REF_PKT_HDR_HDR_12_WRITE_G(v, g, idx)                                 GROUP_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 56, (v))
#define RDD_REF_PKT_HDR_HDR_12_READ_CORE(r, g, idx, core_id)                      CORE_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 56, (r), core_id)
#define RDD_REF_PKT_HDR_HDR_12_WRITE_CORE(v, g, idx, core_id)                     CORE_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 56, (v), core_id)
#define RDD_REF_PKT_HDR_HDR_12_READ(r, p)                                         MREAD_32((uint8_t *)(p) + 56, (r))
#define RDD_REF_PKT_HDR_HDR_12_WRITE(v, p)                                        MWRITE_32((uint8_t *)(p) + 56, (v))
#define RDD_REF_PKT_HDR_HDR_13_READ_G(r, g, idx)                                  GROUP_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 60, (r))
#define RDD_REF_PKT_HDR_HDR_13_WRITE_G(v, g, idx)                                 GROUP_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 60, (v))
#define RDD_REF_PKT_HDR_HDR_13_READ_CORE(r, g, idx, core_id)                      CORE_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 60, (r), core_id)
#define RDD_REF_PKT_HDR_HDR_13_WRITE_CORE(v, g, idx, core_id)                     CORE_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 60, (v), core_id)
#define RDD_REF_PKT_HDR_HDR_13_READ(r, p)                                         MREAD_32((uint8_t *)(p) + 60, (r))
#define RDD_REF_PKT_HDR_HDR_13_WRITE(v, p)                                        MWRITE_32((uint8_t *)(p) + 60, (v))
#define RDD_REF_PKT_HDR_HDR_14_READ_G(r, g, idx)                                  GROUP_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 64, (r))
#define RDD_REF_PKT_HDR_HDR_14_WRITE_G(v, g, idx)                                 GROUP_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 64, (v))
#define RDD_REF_PKT_HDR_HDR_14_READ_CORE(r, g, idx, core_id)                      CORE_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 64, (r), core_id)
#define RDD_REF_PKT_HDR_HDR_14_WRITE_CORE(v, g, idx, core_id)                     CORE_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 64, (v), core_id)
#define RDD_REF_PKT_HDR_HDR_14_READ(r, p)                                         MREAD_32((uint8_t *)(p) + 64, (r))
#define RDD_REF_PKT_HDR_HDR_14_WRITE(v, p)                                        MWRITE_32((uint8_t *)(p) + 64, (v))
#define RDD_REF_PKT_HDR_HDR_15_READ_G(r, g, idx)                                  GROUP_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 68, (r))
#define RDD_REF_PKT_HDR_HDR_15_WRITE_G(v, g, idx)                                 GROUP_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 68, (v))
#define RDD_REF_PKT_HDR_HDR_15_READ_CORE(r, g, idx, core_id)                      CORE_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 68, (r), core_id)
#define RDD_REF_PKT_HDR_HDR_15_WRITE_CORE(v, g, idx, core_id)                     CORE_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 68, (v), core_id)
#define RDD_REF_PKT_HDR_HDR_15_READ(r, p)                                         MREAD_32((uint8_t *)(p) + 68, (r))
#define RDD_REF_PKT_HDR_HDR_15_WRITE(v, p)                                        MWRITE_32((uint8_t *)(p) + 68, (v))
#define RDD_REF_PKT_HDR_HDR_16_READ_G(r, g, idx)                                  GROUP_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 72, (r))
#define RDD_REF_PKT_HDR_HDR_16_WRITE_G(v, g, idx)                                 GROUP_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 72, (v))
#define RDD_REF_PKT_HDR_HDR_16_READ_CORE(r, g, idx, core_id)                      CORE_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 72, (r), core_id)
#define RDD_REF_PKT_HDR_HDR_16_WRITE_CORE(v, g, idx, core_id)                     CORE_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 72, (v), core_id)
#define RDD_REF_PKT_HDR_HDR_16_READ(r, p)                                         MREAD_32((uint8_t *)(p) + 72, (r))
#define RDD_REF_PKT_HDR_HDR_16_WRITE(v, p)                                        MWRITE_32((uint8_t *)(p) + 72, (v))
#define RDD_REF_PKT_HDR_HDR_17_READ_G(r, g, idx)                                  GROUP_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 76, (r))
#define RDD_REF_PKT_HDR_HDR_17_WRITE_G(v, g, idx)                                 GROUP_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 76, (v))
#define RDD_REF_PKT_HDR_HDR_17_READ_CORE(r, g, idx, core_id)                      CORE_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 76, (r), core_id)
#define RDD_REF_PKT_HDR_HDR_17_WRITE_CORE(v, g, idx, core_id)                     CORE_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 76, (v), core_id)
#define RDD_REF_PKT_HDR_HDR_17_READ(r, p)                                         MREAD_32((uint8_t *)(p) + 76, (r))
#define RDD_REF_PKT_HDR_HDR_17_WRITE(v, p)                                        MWRITE_32((uint8_t *)(p) + 76, (v))
#define RDD_REF_PKT_HDR_HDR_18_READ_G(r, g, idx)                                  GROUP_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 80, (r))
#define RDD_REF_PKT_HDR_HDR_18_WRITE_G(v, g, idx)                                 GROUP_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 80, (v))
#define RDD_REF_PKT_HDR_HDR_18_READ_CORE(r, g, idx, core_id)                      CORE_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 80, (r), core_id)
#define RDD_REF_PKT_HDR_HDR_18_WRITE_CORE(v, g, idx, core_id)                     CORE_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 80, (v), core_id)
#define RDD_REF_PKT_HDR_HDR_18_READ(r, p)                                         MREAD_32((uint8_t *)(p) + 80, (r))
#define RDD_REF_PKT_HDR_HDR_18_WRITE(v, p)                                        MWRITE_32((uint8_t *)(p) + 80, (v))
#define RDD_REF_PKT_HDR_HDR_19_READ_G(r, g, idx)                                  GROUP_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 84, (r))
#define RDD_REF_PKT_HDR_HDR_19_WRITE_G(v, g, idx)                                 GROUP_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 84, (v))
#define RDD_REF_PKT_HDR_HDR_19_READ_CORE(r, g, idx, core_id)                      CORE_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 84, (r), core_id)
#define RDD_REF_PKT_HDR_HDR_19_WRITE_CORE(v, g, idx, core_id)                     CORE_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 84, (v), core_id)
#define RDD_REF_PKT_HDR_HDR_19_READ(r, p)                                         MREAD_32((uint8_t *)(p) + 84, (r))
#define RDD_REF_PKT_HDR_HDR_19_WRITE(v, p)                                        MWRITE_32((uint8_t *)(p) + 84, (v))
#define RDD_REF_PKT_HDR_HDR_20_READ_G(r, g, idx)                                  GROUP_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 88, (r))
#define RDD_REF_PKT_HDR_HDR_20_WRITE_G(v, g, idx)                                 GROUP_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 88, (v))
#define RDD_REF_PKT_HDR_HDR_20_READ_CORE(r, g, idx, core_id)                      CORE_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 88, (r), core_id)
#define RDD_REF_PKT_HDR_HDR_20_WRITE_CORE(v, g, idx, core_id)                     CORE_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 88, (v), core_id)
#define RDD_REF_PKT_HDR_HDR_20_READ(r, p)                                         MREAD_32((uint8_t *)(p) + 88, (r))
#define RDD_REF_PKT_HDR_HDR_20_WRITE(v, p)                                        MWRITE_32((uint8_t *)(p) + 88, (v))
#define RDD_REF_PKT_HDR_HDR_21_READ_G(r, g, idx)                                  GROUP_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 92, (r))
#define RDD_REF_PKT_HDR_HDR_21_WRITE_G(v, g, idx)                                 GROUP_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 92, (v))
#define RDD_REF_PKT_HDR_HDR_21_READ_CORE(r, g, idx, core_id)                      CORE_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 92, (r), core_id)
#define RDD_REF_PKT_HDR_HDR_21_WRITE_CORE(v, g, idx, core_id)                     CORE_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 92, (v), core_id)
#define RDD_REF_PKT_HDR_HDR_21_READ(r, p)                                         MREAD_32((uint8_t *)(p) + 92, (r))
#define RDD_REF_PKT_HDR_HDR_21_WRITE(v, p)                                        MWRITE_32((uint8_t *)(p) + 92, (v))
#define RDD_REF_PKT_HDR_HDR_22_READ_G(r, g, idx)                                  GROUP_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 96, (r))
#define RDD_REF_PKT_HDR_HDR_22_WRITE_G(v, g, idx)                                 GROUP_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 96, (v))
#define RDD_REF_PKT_HDR_HDR_22_READ_CORE(r, g, idx, core_id)                      CORE_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 96, (r), core_id)
#define RDD_REF_PKT_HDR_HDR_22_WRITE_CORE(v, g, idx, core_id)                     CORE_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 96, (v), core_id)
#define RDD_REF_PKT_HDR_HDR_22_READ(r, p)                                         MREAD_32((uint8_t *)(p) + 96, (r))
#define RDD_REF_PKT_HDR_HDR_22_WRITE(v, p)                                        MWRITE_32((uint8_t *)(p) + 96, (v))
#define RDD_REF_PKT_HDR_HDR_23_READ_G(r, g, idx)                                  GROUP_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 100, (r))
#define RDD_REF_PKT_HDR_HDR_23_WRITE_G(v, g, idx)                                 GROUP_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 100, (v))
#define RDD_REF_PKT_HDR_HDR_23_READ_CORE(r, g, idx, core_id)                      CORE_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 100, (r), core_id)
#define RDD_REF_PKT_HDR_HDR_23_WRITE_CORE(v, g, idx, core_id)                     CORE_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 100, (v), core_id)
#define RDD_REF_PKT_HDR_HDR_23_READ(r, p)                                         MREAD_32((uint8_t *)(p) + 100, (r))
#define RDD_REF_PKT_HDR_HDR_23_WRITE(v, p)                                        MWRITE_32((uint8_t *)(p) + 100, (v))
#define RDD_REF_PKT_HDR_HDR_24_READ_G(r, g, idx)                                  GROUP_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 104, (r))
#define RDD_REF_PKT_HDR_HDR_24_WRITE_G(v, g, idx)                                 GROUP_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 104, (v))
#define RDD_REF_PKT_HDR_HDR_24_READ_CORE(r, g, idx, core_id)                      CORE_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 104, (r), core_id)
#define RDD_REF_PKT_HDR_HDR_24_WRITE_CORE(v, g, idx, core_id)                     CORE_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 104, (v), core_id)
#define RDD_REF_PKT_HDR_HDR_24_READ(r, p)                                         MREAD_32((uint8_t *)(p) + 104, (r))
#define RDD_REF_PKT_HDR_HDR_24_WRITE(v, p)                                        MWRITE_32((uint8_t *)(p) + 104, (v))
#define RDD_REF_PKT_HDR_HDR_25_READ_G(r, g, idx)                                  GROUP_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 108, (r))
#define RDD_REF_PKT_HDR_HDR_25_WRITE_G(v, g, idx)                                 GROUP_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 108, (v))
#define RDD_REF_PKT_HDR_HDR_25_READ_CORE(r, g, idx, core_id)                      CORE_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 108, (r), core_id)
#define RDD_REF_PKT_HDR_HDR_25_WRITE_CORE(v, g, idx, core_id)                     CORE_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 108, (v), core_id)
#define RDD_REF_PKT_HDR_HDR_25_READ(r, p)                                         MREAD_32((uint8_t *)(p) + 108, (r))
#define RDD_REF_PKT_HDR_HDR_25_WRITE(v, p)                                        MWRITE_32((uint8_t *)(p) + 108, (v))
#define RDD_REF_PKT_HDR_HDR_26_READ_G(r, g, idx)                                  GROUP_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 112, (r))
#define RDD_REF_PKT_HDR_HDR_26_WRITE_G(v, g, idx)                                 GROUP_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 112, (v))
#define RDD_REF_PKT_HDR_HDR_26_READ_CORE(r, g, idx, core_id)                      CORE_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 112, (r), core_id)
#define RDD_REF_PKT_HDR_HDR_26_WRITE_CORE(v, g, idx, core_id)                     CORE_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 112, (v), core_id)
#define RDD_REF_PKT_HDR_HDR_26_READ(r, p)                                         MREAD_32((uint8_t *)(p) + 112, (r))
#define RDD_REF_PKT_HDR_HDR_26_WRITE(v, p)                                        MWRITE_32((uint8_t *)(p) + 112, (v))
#define RDD_REF_PKT_HDR_HDR_27_READ_G(r, g, idx)                                  GROUP_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 116, (r))
#define RDD_REF_PKT_HDR_HDR_27_WRITE_G(v, g, idx)                                 GROUP_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 116, (v))
#define RDD_REF_PKT_HDR_HDR_27_READ_CORE(r, g, idx, core_id)                      CORE_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 116, (r), core_id)
#define RDD_REF_PKT_HDR_HDR_27_WRITE_CORE(v, g, idx, core_id)                     CORE_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 116, (v), core_id)
#define RDD_REF_PKT_HDR_HDR_27_READ(r, p)                                         MREAD_32((uint8_t *)(p) + 116, (r))
#define RDD_REF_PKT_HDR_HDR_27_WRITE(v, p)                                        MWRITE_32((uint8_t *)(p) + 116, (v))
#define RDD_REF_PKT_HDR_HDR_28_READ_G(r, g, idx)                                  GROUP_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 120, (r))
#define RDD_REF_PKT_HDR_HDR_28_WRITE_G(v, g, idx)                                 GROUP_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 120, (v))
#define RDD_REF_PKT_HDR_HDR_28_READ_CORE(r, g, idx, core_id)                      CORE_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 120, (r), core_id)
#define RDD_REF_PKT_HDR_HDR_28_WRITE_CORE(v, g, idx, core_id)                     CORE_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 120, (v), core_id)
#define RDD_REF_PKT_HDR_HDR_28_READ(r, p)                                         MREAD_32((uint8_t *)(p) + 120, (r))
#define RDD_REF_PKT_HDR_HDR_28_WRITE(v, p)                                        MWRITE_32((uint8_t *)(p) + 120, (v))
#define RDD_REF_PKT_HDR_HDR_29_READ_G(r, g, idx)                                  GROUP_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 124, (r))
#define RDD_REF_PKT_HDR_HDR_29_WRITE_G(v, g, idx)                                 GROUP_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 124, (v))
#define RDD_REF_PKT_HDR_HDR_29_READ_CORE(r, g, idx, core_id)                      CORE_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 124, (r), core_id)
#define RDD_REF_PKT_HDR_HDR_29_WRITE_CORE(v, g, idx, core_id)                     CORE_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 124, (v), core_id)
#define RDD_REF_PKT_HDR_HDR_29_READ(r, p)                                         MREAD_32((uint8_t *)(p) + 124, (r))
#define RDD_REF_PKT_HDR_HDR_29_WRITE(v, p)                                        MWRITE_32((uint8_t *)(p) + 124, (v))
/* <<<REF_PKT_HDR_STRUCT */


/* >>>PKTGEN_TX_STREAM_ENTRY_STRUCT */
typedef union
    {
    uint8_t word_8[136];
    uint16_t word_16[68];
    uint32_t word_32[34];
    uint64_t dword_64[17];
        struct {
        REF_PKT_HDR_STRUCT ref_pkt_hdr;
        ENTRY_PARMS_STRUCT entry_parms;
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) PKTGEN_TX_STREAM_ENTRY_STRUCT;

#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_SIZE_READ_G(r, g, idx)                                              GROUP_MREAD_16((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT), (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_SIZE_WRITE_G(v, g, idx)                                             GROUP_MWRITE_16((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT), (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_SIZE_READ_CORE(r, g, idx, core_id)                                  CORE_MREAD_16((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT), (r), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_SIZE_WRITE_CORE(v, g, idx, core_id)                                 CORE_MWRITE_16((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT), (v), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_SIZE_READ(r, p)                                                     MREAD_16((uint8_t *)(p), (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_SIZE_WRITE(v, p)                                                    MWRITE_16((uint8_t *)(p), (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_OFFSET_READ_G(r, g, idx)                                            GROUP_MREAD_16((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 2, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_OFFSET_WRITE_G(v, g, idx)                                           GROUP_MWRITE_16((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 2, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_OFFSET_READ_CORE(r, g, idx, core_id)                                CORE_MREAD_16((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 2, (r), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_OFFSET_WRITE_CORE(v, g, idx, core_id)                               CORE_MWRITE_16((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 2, (v), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_OFFSET_READ(r, p)                                                   MREAD_16((uint8_t *)(p) + 2, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_OFFSET_WRITE(v, p)                                                  MWRITE_16((uint8_t *)(p) + 2, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_RESERVED_READ_G(r, g, idx)                                          GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 4, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_RESERVED_WRITE_G(v, g, idx)                                         GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 4, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_RESERVED_READ_CORE(r, g, idx, core_id)                              CORE_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 4, (r), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_RESERVED_WRITE_CORE(v, g, idx, core_id)                             CORE_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 4, (v), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_RESERVED_READ(r, p)                                                 MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_RESERVED_WRITE(v, p)                                                MWRITE_32((uint8_t *)(p) + 4, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_READ_G(r, g, idx)                                               GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 8, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_WRITE_G(v, g, idx)                                              GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 8, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_READ_CORE(r, g, idx, core_id)                                   CORE_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 8, (r), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_WRITE_CORE(v, g, idx, core_id)                                  CORE_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 8, (v), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_READ(r, p)                                                      MREAD_32((uint8_t *)(p) + 8, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_WRITE(v, p)                                                     MWRITE_32((uint8_t *)(p) + 8, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_1_READ_G(r, g, idx)                                             GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 12, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_1_WRITE_G(v, g, idx)                                            GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 12, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_1_READ_CORE(r, g, idx, core_id)                                 CORE_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 12, (r), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_1_WRITE_CORE(v, g, idx, core_id)                                CORE_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 12, (v), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_1_READ(r, p)                                                    MREAD_32((uint8_t *)(p) + 12, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_1_WRITE(v, p)                                                   MWRITE_32((uint8_t *)(p) + 12, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_2_READ_G(r, g, idx)                                             GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 16, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_2_WRITE_G(v, g, idx)                                            GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 16, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_2_READ_CORE(r, g, idx, core_id)                                 CORE_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 16, (r), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_2_WRITE_CORE(v, g, idx, core_id)                                CORE_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 16, (v), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_2_READ(r, p)                                                    MREAD_32((uint8_t *)(p) + 16, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_2_WRITE(v, p)                                                   MWRITE_32((uint8_t *)(p) + 16, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_3_READ_G(r, g, idx)                                             GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 20, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_3_WRITE_G(v, g, idx)                                            GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 20, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_3_READ_CORE(r, g, idx, core_id)                                 CORE_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 20, (r), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_3_WRITE_CORE(v, g, idx, core_id)                                CORE_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 20, (v), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_3_READ(r, p)                                                    MREAD_32((uint8_t *)(p) + 20, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_3_WRITE(v, p)                                                   MWRITE_32((uint8_t *)(p) + 20, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_4_READ_G(r, g, idx)                                             GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 24, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_4_WRITE_G(v, g, idx)                                            GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 24, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_4_READ_CORE(r, g, idx, core_id)                                 CORE_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 24, (r), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_4_WRITE_CORE(v, g, idx, core_id)                                CORE_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 24, (v), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_4_READ(r, p)                                                    MREAD_32((uint8_t *)(p) + 24, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_4_WRITE(v, p)                                                   MWRITE_32((uint8_t *)(p) + 24, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_5_READ_G(r, g, idx)                                             GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 28, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_5_WRITE_G(v, g, idx)                                            GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 28, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_5_READ_CORE(r, g, idx, core_id)                                 CORE_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 28, (r), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_5_WRITE_CORE(v, g, idx, core_id)                                CORE_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 28, (v), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_5_READ(r, p)                                                    MREAD_32((uint8_t *)(p) + 28, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_5_WRITE(v, p)                                                   MWRITE_32((uint8_t *)(p) + 28, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_6_READ_G(r, g, idx)                                             GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 32, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_6_WRITE_G(v, g, idx)                                            GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 32, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_6_READ_CORE(r, g, idx, core_id)                                 CORE_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 32, (r), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_6_WRITE_CORE(v, g, idx, core_id)                                CORE_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 32, (v), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_6_READ(r, p)                                                    MREAD_32((uint8_t *)(p) + 32, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_6_WRITE(v, p)                                                   MWRITE_32((uint8_t *)(p) + 32, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_7_READ_G(r, g, idx)                                             GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 36, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_7_WRITE_G(v, g, idx)                                            GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 36, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_7_READ_CORE(r, g, idx, core_id)                                 CORE_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 36, (r), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_7_WRITE_CORE(v, g, idx, core_id)                                CORE_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 36, (v), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_7_READ(r, p)                                                    MREAD_32((uint8_t *)(p) + 36, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_7_WRITE(v, p)                                                   MWRITE_32((uint8_t *)(p) + 36, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_8_READ_G(r, g, idx)                                             GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 40, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_8_WRITE_G(v, g, idx)                                            GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 40, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_8_READ_CORE(r, g, idx, core_id)                                 CORE_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 40, (r), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_8_WRITE_CORE(v, g, idx, core_id)                                CORE_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 40, (v), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_8_READ(r, p)                                                    MREAD_32((uint8_t *)(p) + 40, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_8_WRITE(v, p)                                                   MWRITE_32((uint8_t *)(p) + 40, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_9_READ_G(r, g, idx)                                             GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 44, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_9_WRITE_G(v, g, idx)                                            GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 44, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_9_READ_CORE(r, g, idx, core_id)                                 CORE_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 44, (r), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_9_WRITE_CORE(v, g, idx, core_id)                                CORE_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 44, (v), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_9_READ(r, p)                                                    MREAD_32((uint8_t *)(p) + 44, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_9_WRITE(v, p)                                                   MWRITE_32((uint8_t *)(p) + 44, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_10_READ_G(r, g, idx)                                            GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 48, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_10_WRITE_G(v, g, idx)                                           GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 48, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_10_READ_CORE(r, g, idx, core_id)                                CORE_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 48, (r), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_10_WRITE_CORE(v, g, idx, core_id)                               CORE_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 48, (v), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_10_READ(r, p)                                                   MREAD_32((uint8_t *)(p) + 48, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_10_WRITE(v, p)                                                  MWRITE_32((uint8_t *)(p) + 48, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_11_READ_G(r, g, idx)                                            GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 52, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_11_WRITE_G(v, g, idx)                                           GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 52, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_11_READ_CORE(r, g, idx, core_id)                                CORE_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 52, (r), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_11_WRITE_CORE(v, g, idx, core_id)                               CORE_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 52, (v), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_11_READ(r, p)                                                   MREAD_32((uint8_t *)(p) + 52, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_11_WRITE(v, p)                                                  MWRITE_32((uint8_t *)(p) + 52, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_12_READ_G(r, g, idx)                                            GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 56, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_12_WRITE_G(v, g, idx)                                           GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 56, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_12_READ_CORE(r, g, idx, core_id)                                CORE_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 56, (r), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_12_WRITE_CORE(v, g, idx, core_id)                               CORE_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 56, (v), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_12_READ(r, p)                                                   MREAD_32((uint8_t *)(p) + 56, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_12_WRITE(v, p)                                                  MWRITE_32((uint8_t *)(p) + 56, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_13_READ_G(r, g, idx)                                            GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 60, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_13_WRITE_G(v, g, idx)                                           GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 60, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_13_READ_CORE(r, g, idx, core_id)                                CORE_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 60, (r), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_13_WRITE_CORE(v, g, idx, core_id)                               CORE_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 60, (v), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_13_READ(r, p)                                                   MREAD_32((uint8_t *)(p) + 60, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_13_WRITE(v, p)                                                  MWRITE_32((uint8_t *)(p) + 60, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_14_READ_G(r, g, idx)                                            GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 64, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_14_WRITE_G(v, g, idx)                                           GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 64, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_14_READ_CORE(r, g, idx, core_id)                                CORE_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 64, (r), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_14_WRITE_CORE(v, g, idx, core_id)                               CORE_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 64, (v), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_14_READ(r, p)                                                   MREAD_32((uint8_t *)(p) + 64, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_14_WRITE(v, p)                                                  MWRITE_32((uint8_t *)(p) + 64, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_15_READ_G(r, g, idx)                                            GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 68, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_15_WRITE_G(v, g, idx)                                           GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 68, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_15_READ_CORE(r, g, idx, core_id)                                CORE_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 68, (r), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_15_WRITE_CORE(v, g, idx, core_id)                               CORE_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 68, (v), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_15_READ(r, p)                                                   MREAD_32((uint8_t *)(p) + 68, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_15_WRITE(v, p)                                                  MWRITE_32((uint8_t *)(p) + 68, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_16_READ_G(r, g, idx)                                            GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 72, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_16_WRITE_G(v, g, idx)                                           GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 72, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_16_READ_CORE(r, g, idx, core_id)                                CORE_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 72, (r), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_16_WRITE_CORE(v, g, idx, core_id)                               CORE_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 72, (v), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_16_READ(r, p)                                                   MREAD_32((uint8_t *)(p) + 72, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_16_WRITE(v, p)                                                  MWRITE_32((uint8_t *)(p) + 72, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_17_READ_G(r, g, idx)                                            GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 76, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_17_WRITE_G(v, g, idx)                                           GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 76, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_17_READ_CORE(r, g, idx, core_id)                                CORE_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 76, (r), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_17_WRITE_CORE(v, g, idx, core_id)                               CORE_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 76, (v), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_17_READ(r, p)                                                   MREAD_32((uint8_t *)(p) + 76, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_17_WRITE(v, p)                                                  MWRITE_32((uint8_t *)(p) + 76, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_18_READ_G(r, g, idx)                                            GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 80, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_18_WRITE_G(v, g, idx)                                           GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 80, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_18_READ_CORE(r, g, idx, core_id)                                CORE_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 80, (r), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_18_WRITE_CORE(v, g, idx, core_id)                               CORE_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 80, (v), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_18_READ(r, p)                                                   MREAD_32((uint8_t *)(p) + 80, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_18_WRITE(v, p)                                                  MWRITE_32((uint8_t *)(p) + 80, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_19_READ_G(r, g, idx)                                            GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 84, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_19_WRITE_G(v, g, idx)                                           GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 84, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_19_READ_CORE(r, g, idx, core_id)                                CORE_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 84, (r), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_19_WRITE_CORE(v, g, idx, core_id)                               CORE_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 84, (v), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_19_READ(r, p)                                                   MREAD_32((uint8_t *)(p) + 84, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_19_WRITE(v, p)                                                  MWRITE_32((uint8_t *)(p) + 84, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_20_READ_G(r, g, idx)                                            GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 88, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_20_WRITE_G(v, g, idx)                                           GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 88, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_20_READ_CORE(r, g, idx, core_id)                                CORE_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 88, (r), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_20_WRITE_CORE(v, g, idx, core_id)                               CORE_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 88, (v), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_20_READ(r, p)                                                   MREAD_32((uint8_t *)(p) + 88, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_20_WRITE(v, p)                                                  MWRITE_32((uint8_t *)(p) + 88, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_21_READ_G(r, g, idx)                                            GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 92, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_21_WRITE_G(v, g, idx)                                           GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 92, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_21_READ_CORE(r, g, idx, core_id)                                CORE_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 92, (r), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_21_WRITE_CORE(v, g, idx, core_id)                               CORE_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 92, (v), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_21_READ(r, p)                                                   MREAD_32((uint8_t *)(p) + 92, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_21_WRITE(v, p)                                                  MWRITE_32((uint8_t *)(p) + 92, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_22_READ_G(r, g, idx)                                            GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 96, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_22_WRITE_G(v, g, idx)                                           GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 96, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_22_READ_CORE(r, g, idx, core_id)                                CORE_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 96, (r), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_22_WRITE_CORE(v, g, idx, core_id)                               CORE_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 96, (v), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_22_READ(r, p)                                                   MREAD_32((uint8_t *)(p) + 96, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_22_WRITE(v, p)                                                  MWRITE_32((uint8_t *)(p) + 96, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_23_READ_G(r, g, idx)                                            GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 100, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_23_WRITE_G(v, g, idx)                                           GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 100, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_23_READ_CORE(r, g, idx, core_id)                                CORE_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 100, (r), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_23_WRITE_CORE(v, g, idx, core_id)                               CORE_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 100, (v), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_23_READ(r, p)                                                   MREAD_32((uint8_t *)(p) + 100, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_23_WRITE(v, p)                                                  MWRITE_32((uint8_t *)(p) + 100, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_24_READ_G(r, g, idx)                                            GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 104, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_24_WRITE_G(v, g, idx)                                           GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 104, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_24_READ_CORE(r, g, idx, core_id)                                CORE_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 104, (r), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_24_WRITE_CORE(v, g, idx, core_id)                               CORE_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 104, (v), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_24_READ(r, p)                                                   MREAD_32((uint8_t *)(p) + 104, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_24_WRITE(v, p)                                                  MWRITE_32((uint8_t *)(p) + 104, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_25_READ_G(r, g, idx)                                            GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 108, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_25_WRITE_G(v, g, idx)                                           GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 108, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_25_READ_CORE(r, g, idx, core_id)                                CORE_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 108, (r), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_25_WRITE_CORE(v, g, idx, core_id)                               CORE_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 108, (v), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_25_READ(r, p)                                                   MREAD_32((uint8_t *)(p) + 108, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_25_WRITE(v, p)                                                  MWRITE_32((uint8_t *)(p) + 108, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_26_READ_G(r, g, idx)                                            GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 112, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_26_WRITE_G(v, g, idx)                                           GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 112, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_26_READ_CORE(r, g, idx, core_id)                                CORE_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 112, (r), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_26_WRITE_CORE(v, g, idx, core_id)                               CORE_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 112, (v), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_26_READ(r, p)                                                   MREAD_32((uint8_t *)(p) + 112, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_26_WRITE(v, p)                                                  MWRITE_32((uint8_t *)(p) + 112, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_27_READ_G(r, g, idx)                                            GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 116, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_27_WRITE_G(v, g, idx)                                           GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 116, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_27_READ_CORE(r, g, idx, core_id)                                CORE_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 116, (r), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_27_WRITE_CORE(v, g, idx, core_id)                               CORE_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 116, (v), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_27_READ(r, p)                                                   MREAD_32((uint8_t *)(p) + 116, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_27_WRITE(v, p)                                                  MWRITE_32((uint8_t *)(p) + 116, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_28_READ_G(r, g, idx)                                            GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 120, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_28_WRITE_G(v, g, idx)                                           GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 120, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_28_READ_CORE(r, g, idx, core_id)                                CORE_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 120, (r), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_28_WRITE_CORE(v, g, idx, core_id)                               CORE_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 120, (v), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_28_READ(r, p)                                                   MREAD_32((uint8_t *)(p) + 120, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_28_WRITE(v, p)                                                  MWRITE_32((uint8_t *)(p) + 120, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_29_READ_G(r, g, idx)                                            GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 124, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_29_WRITE_G(v, g, idx)                                           GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 124, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_29_READ_CORE(r, g, idx, core_id)                                CORE_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 124, (r), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_29_WRITE_CORE(v, g, idx, core_id)                               CORE_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 124, (v), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_29_READ(r, p)                                                   MREAD_32((uint8_t *)(p) + 124, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_29_WRITE(v, p)                                                  MWRITE_32((uint8_t *)(p) + 124, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_WAN_FLOW_READ_G(r, g, idx)                                          GROUP_MREAD_16((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 128, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_WAN_FLOW_WRITE_G(v, g, idx)                                         GROUP_MWRITE_16((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 128, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_WAN_FLOW_READ_CORE(r, g, idx, core_id)                              CORE_MREAD_16((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 128, (r), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_WAN_FLOW_WRITE_CORE(v, g, idx, core_id)                             CORE_MWRITE_16((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 128, (v), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_WAN_FLOW_READ(r, p)                                                 MREAD_16((uint8_t *)(p) + 128, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_WAN_FLOW_WRITE(v, p)                                                MWRITE_16((uint8_t *)(p) + 128, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_RESERVED_READ_G(r, g, idx)                                          GROUP_MREAD_16((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 130, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_RESERVED_WRITE_G(v, g, idx)                                         GROUP_MWRITE_16((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 130, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_RESERVED_READ_CORE(r, g, idx, core_id)                              CORE_MREAD_16((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 130, (r), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_RESERVED_WRITE_CORE(v, g, idx, core_id)                             CORE_MWRITE_16((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 130, (v), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_RESERVED_READ(r, p)                                                 MREAD_16((uint8_t *)(p) + 130, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_RESERVED_WRITE(v, p)                                                MWRITE_16((uint8_t *)(p) + 130, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_TCP_UDP_PARMS_READ_G(r, g, idx)                                     GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 132, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_TCP_UDP_PARMS_WRITE_G(v, g, idx)                                    GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 132, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_TCP_UDP_PARMS_READ_CORE(r, g, idx, core_id)                         CORE_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 132, (r), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_TCP_UDP_PARMS_WRITE_CORE(v, g, idx, core_id)                        CORE_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 132, (v), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_TCP_UDP_PARMS_READ(r, p)                                            MREAD_32((uint8_t *)(p) + 132, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_TCP_UDP_PARMS_WRITE(v, p)                                           MWRITE_32((uint8_t *)(p) + 132, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_L2_HDR_LEN_READ_G(r, g, idx)                                        GROUP_MREAD_8((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 132, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_L2_HDR_LEN_WRITE_G(v, g, idx)                                       GROUP_MWRITE_8((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 132, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_L2_HDR_LEN_READ_CORE(r, g, idx, core_id)                            CORE_MREAD_8((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 132, (r), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_L2_HDR_LEN_WRITE_CORE(v, g, idx, core_id)                           CORE_MWRITE_8((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 132, (v), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_L2_HDR_LEN_READ(r, p)                                               MREAD_8((uint8_t *)(p) + 132, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_L2_HDR_LEN_WRITE(v, p)                                              MWRITE_8((uint8_t *)(p) + 132, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_L3_HDR_LEN_READ_G(r, g, idx)                                        GROUP_MREAD_8((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 133, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_L3_HDR_LEN_WRITE_G(v, g, idx)                                       GROUP_MWRITE_8((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 133, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_L3_HDR_LEN_READ_CORE(r, g, idx, core_id)                            CORE_MREAD_8((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 133, (r), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_L3_HDR_LEN_WRITE_CORE(v, g, idx, core_id)                           CORE_MWRITE_8((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 133, (v), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_L3_HDR_LEN_READ(r, p)                                               MREAD_8((uint8_t *)(p) + 133, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_L3_HDR_LEN_WRITE(v, p)                                              MWRITE_8((uint8_t *)(p) + 133, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_L3_PROTOCOL_READ_G(r, g, idx)                                       GROUP_MREAD_8((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 134, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_L3_PROTOCOL_WRITE_G(v, g, idx)                                      GROUP_MWRITE_8((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 134, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_L3_PROTOCOL_READ_CORE(r, g, idx, core_id)                           CORE_MREAD_8((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 134, (r), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_L3_PROTOCOL_WRITE_CORE(v, g, idx, core_id)                          CORE_MWRITE_8((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 134, (v), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_L3_PROTOCOL_READ(r, p)                                              MREAD_8((uint8_t *)(p) + 134, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_L3_PROTOCOL_WRITE(v, p)                                             MWRITE_8((uint8_t *)(p) + 134, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_TX_HDR_LEN_READ_G(r, g, idx)                                        GROUP_MREAD_8((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 135, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_TX_HDR_LEN_WRITE_G(v, g, idx)                                       GROUP_MWRITE_8((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 135, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_TX_HDR_LEN_READ_CORE(r, g, idx, core_id)                            CORE_MREAD_8((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 135, (r), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_TX_HDR_LEN_WRITE_CORE(v, g, idx, core_id)                           CORE_MWRITE_8((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 135, (v), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_TX_HDR_LEN_READ(r, p)                                               MREAD_8((uint8_t *)(p) + 135, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_TX_HDR_LEN_WRITE(v, p)                                              MWRITE_8((uint8_t *)(p) + 135, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_UDP_PAYLOAD_OFFSET_READ_G(r, g, idx)                                GROUP_MREAD_16((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 132, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_UDP_PAYLOAD_OFFSET_WRITE_G(v, g, idx)                               GROUP_MWRITE_16((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 132, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_UDP_PAYLOAD_OFFSET_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_16((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 132, (r), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_UDP_PAYLOAD_OFFSET_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_16((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 132, (v), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_UDP_PAYLOAD_OFFSET_READ(r, p)                                       MREAD_16((uint8_t *)(p) + 132, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_UDP_PAYLOAD_OFFSET_WRITE(v, p)                                      MWRITE_16((uint8_t *)(p) + 132, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_UDP_CSUM_READ_G(r, g, idx)                                          GROUP_MREAD_16((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 134, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_UDP_CSUM_WRITE_G(v, g, idx)                                         GROUP_MWRITE_16((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 134, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_UDP_CSUM_READ_CORE(r, g, idx, core_id)                              CORE_MREAD_16((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 134, (r), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_UDP_CSUM_WRITE_CORE(v, g, idx, core_id)                             CORE_MWRITE_16((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 134, (v), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_UDP_CSUM_READ(r, p)                                                 MREAD_16((uint8_t *)(p) + 134, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_UDP_CSUM_WRITE(v, p)                                                MWRITE_16((uint8_t *)(p) + 134, (v))
/* <<<PKTGEN_TX_STREAM_ENTRY_STRUCT */


/* >>>PKTGEN_TX_STREAM_SCRATCH_ENTRY_STRUCT */
typedef union
    {
    uint8_t word_8[8];
    uint16_t word_16[4];
    uint32_t word_32[2];
    uint64_t dword_64[1];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	reserved0 	;
        uint16_t	csum_value	;
        uint16_t	reserved1 	;
#else
        uint32_t	reserved0 	;
        uint16_t	reserved1 	;
        uint16_t	csum_value	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) PKTGEN_TX_STREAM_SCRATCH_ENTRY_STRUCT;

#define RDD_PKTGEN_TX_STREAM_SCRATCH_ENTRY_CSUM_VALUE_READ_G(r, g, idx)                                GROUP_MREAD_16((g), (idx)*sizeof(PKTGEN_TX_STREAM_SCRATCH_ENTRY_STRUCT) + 4, (r))
#define RDD_PKTGEN_TX_STREAM_SCRATCH_ENTRY_CSUM_VALUE_WRITE_G(v, g, idx)                               GROUP_MWRITE_16((g), (idx)*sizeof(PKTGEN_TX_STREAM_SCRATCH_ENTRY_STRUCT) + 4, (v))
#define RDD_PKTGEN_TX_STREAM_SCRATCH_ENTRY_CSUM_VALUE_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_16((g), (idx)*sizeof(PKTGEN_TX_STREAM_SCRATCH_ENTRY_STRUCT) + 4, (r), core_id)
#define RDD_PKTGEN_TX_STREAM_SCRATCH_ENTRY_CSUM_VALUE_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_16((g), (idx)*sizeof(PKTGEN_TX_STREAM_SCRATCH_ENTRY_STRUCT) + 4, (v), core_id)
#define RDD_PKTGEN_TX_STREAM_SCRATCH_ENTRY_CSUM_VALUE_READ(r, p)                                       MREAD_16((uint8_t *)(p) + 4, (r))
#define RDD_PKTGEN_TX_STREAM_SCRATCH_ENTRY_CSUM_VALUE_WRITE(v, p)                                      MWRITE_16((uint8_t *)(p) + 4, (v))
/* <<<PKTGEN_TX_STREAM_SCRATCH_ENTRY_STRUCT */


/* >>>TCPSPDTEST_RING_MNG_STRUCT */
typedef union
    {
    uint8_t word_8[8];
    uint16_t word_16[4];
    uint32_t word_32[2];
    uint64_t dword_64[1];
        struct {
        uint32_t	write_offset	;
        uint32_t	read_offset 	;
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) TCPSPDTEST_RING_MNG_STRUCT;

#define RDD_TCPSPDTEST_RING_MNG_WRITE_OFFSET_READ_G(r, g, idx)                                GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_RING_MNG_STRUCT), (r))
#define RDD_TCPSPDTEST_RING_MNG_WRITE_OFFSET_WRITE_G(v, g, idx)                               GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_RING_MNG_STRUCT), (v))
#define RDD_TCPSPDTEST_RING_MNG_WRITE_OFFSET_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_RING_MNG_STRUCT), (r), core_id)
#define RDD_TCPSPDTEST_RING_MNG_WRITE_OFFSET_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_RING_MNG_STRUCT), (v), core_id)
#define RDD_TCPSPDTEST_RING_MNG_WRITE_OFFSET_READ(r, p)                                       MREAD_32((uint8_t *)(p), (r))
#define RDD_TCPSPDTEST_RING_MNG_WRITE_OFFSET_WRITE(v, p)                                      MWRITE_32((uint8_t *)(p), (v))
#define RDD_TCPSPDTEST_RING_MNG_READ_OFFSET_READ_G(r, g, idx)                                 GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_RING_MNG_STRUCT) + 4, (r))
#define RDD_TCPSPDTEST_RING_MNG_READ_OFFSET_WRITE_G(v, g, idx)                                GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_RING_MNG_STRUCT) + 4, (v))
#define RDD_TCPSPDTEST_RING_MNG_READ_OFFSET_READ_CORE(r, g, idx, core_id)                     CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_RING_MNG_STRUCT) + 4, (r), core_id)
#define RDD_TCPSPDTEST_RING_MNG_READ_OFFSET_WRITE_CORE(v, g, idx, core_id)                    CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_RING_MNG_STRUCT) + 4, (v), core_id)
#define RDD_TCPSPDTEST_RING_MNG_READ_OFFSET_READ(r, p)                                        MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_TCPSPDTEST_RING_MNG_READ_OFFSET_WRITE(v, p)                                       MWRITE_32((uint8_t *)(p) + 4, (v))
/* <<<TCPSPDTEST_RING_MNG_STRUCT */


/* >>>TCPSPDTEST_DOWNLOAD_RING_METADATA_STRUCT */
typedef union
    {
    uint8_t word_8[8];
    uint16_t word_16[4];
    uint32_t word_32[2];
    uint64_t dword_64[1];
        struct {
        uint32_t	rx_l3_payload_len	;
        uint32_t	rx_l4_seq        	;
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) TCPSPDTEST_DOWNLOAD_RING_METADATA_STRUCT;

#define RDD_TCPSPDTEST_DOWNLOAD_RING_METADATA_RX_L3_PAYLOAD_LEN_READ_G(r, g, idx)                                GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_DOWNLOAD_RING_METADATA_STRUCT), (r))
#define RDD_TCPSPDTEST_DOWNLOAD_RING_METADATA_RX_L3_PAYLOAD_LEN_WRITE_G(v, g, idx)                               GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_DOWNLOAD_RING_METADATA_STRUCT), (v))
#define RDD_TCPSPDTEST_DOWNLOAD_RING_METADATA_RX_L3_PAYLOAD_LEN_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_DOWNLOAD_RING_METADATA_STRUCT), (r), core_id)
#define RDD_TCPSPDTEST_DOWNLOAD_RING_METADATA_RX_L3_PAYLOAD_LEN_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_DOWNLOAD_RING_METADATA_STRUCT), (v), core_id)
#define RDD_TCPSPDTEST_DOWNLOAD_RING_METADATA_RX_L3_PAYLOAD_LEN_READ(r, p)                                       MREAD_32((uint8_t *)(p), (r))
#define RDD_TCPSPDTEST_DOWNLOAD_RING_METADATA_RX_L3_PAYLOAD_LEN_WRITE(v, p)                                      MWRITE_32((uint8_t *)(p), (v))
#define RDD_TCPSPDTEST_DOWNLOAD_RING_METADATA_RX_L4_SEQ_READ_G(r, g, idx)                                        GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_DOWNLOAD_RING_METADATA_STRUCT) + 4, (r))
#define RDD_TCPSPDTEST_DOWNLOAD_RING_METADATA_RX_L4_SEQ_WRITE_G(v, g, idx)                                       GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_DOWNLOAD_RING_METADATA_STRUCT) + 4, (v))
#define RDD_TCPSPDTEST_DOWNLOAD_RING_METADATA_RX_L4_SEQ_READ_CORE(r, g, idx, core_id)                            CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_DOWNLOAD_RING_METADATA_STRUCT) + 4, (r), core_id)
#define RDD_TCPSPDTEST_DOWNLOAD_RING_METADATA_RX_L4_SEQ_WRITE_CORE(v, g, idx, core_id)                           CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_DOWNLOAD_RING_METADATA_STRUCT) + 4, (v), core_id)
#define RDD_TCPSPDTEST_DOWNLOAD_RING_METADATA_RX_L4_SEQ_READ(r, p)                                               MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_TCPSPDTEST_DOWNLOAD_RING_METADATA_RX_L4_SEQ_WRITE(v, p)                                              MWRITE_32((uint8_t *)(p) + 4, (v))
/* <<<TCPSPDTEST_DOWNLOAD_RING_METADATA_STRUCT */


/* >>>TCPSPDTEST_RTO_RING_TX_SEQ_METADATA_STRUCT */
typedef union
    {
    uint8_t word_8[8];
    uint16_t word_16[4];
    uint32_t word_32[2];
    uint64_t dword_64[1];
        struct {
        uint32_t	time      	;
        uint32_t	tx_seq    	;
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) TCPSPDTEST_RTO_RING_TX_SEQ_METADATA_STRUCT;

#define RDD_TCPSPDTEST_RTO_RING_TX_SEQ_METADATA_TIME_READ_G(r, g, idx)                                  GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_RTO_RING_TX_SEQ_METADATA_STRUCT), (r))
#define RDD_TCPSPDTEST_RTO_RING_TX_SEQ_METADATA_TIME_WRITE_G(v, g, idx)                                 GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_RTO_RING_TX_SEQ_METADATA_STRUCT), (v))
#define RDD_TCPSPDTEST_RTO_RING_TX_SEQ_METADATA_TIME_READ_CORE(r, g, idx, core_id)                      CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_RTO_RING_TX_SEQ_METADATA_STRUCT), (r), core_id)
#define RDD_TCPSPDTEST_RTO_RING_TX_SEQ_METADATA_TIME_WRITE_CORE(v, g, idx, core_id)                     CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_RTO_RING_TX_SEQ_METADATA_STRUCT), (v), core_id)
#define RDD_TCPSPDTEST_RTO_RING_TX_SEQ_METADATA_TIME_READ(r, p)                                         MREAD_32((uint8_t *)(p), (r))
#define RDD_TCPSPDTEST_RTO_RING_TX_SEQ_METADATA_TIME_WRITE(v, p)                                        MWRITE_32((uint8_t *)(p), (v))
#define RDD_TCPSPDTEST_RTO_RING_TX_SEQ_METADATA_TX_SEQ_READ_G(r, g, idx)                                GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_RTO_RING_TX_SEQ_METADATA_STRUCT) + 4, (r))
#define RDD_TCPSPDTEST_RTO_RING_TX_SEQ_METADATA_TX_SEQ_WRITE_G(v, g, idx)                               GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_RTO_RING_TX_SEQ_METADATA_STRUCT) + 4, (v))
#define RDD_TCPSPDTEST_RTO_RING_TX_SEQ_METADATA_TX_SEQ_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_RTO_RING_TX_SEQ_METADATA_STRUCT) + 4, (r), core_id)
#define RDD_TCPSPDTEST_RTO_RING_TX_SEQ_METADATA_TX_SEQ_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_RTO_RING_TX_SEQ_METADATA_STRUCT) + 4, (v), core_id)
#define RDD_TCPSPDTEST_RTO_RING_TX_SEQ_METADATA_TX_SEQ_READ(r, p)                                       MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_TCPSPDTEST_RTO_RING_TX_SEQ_METADATA_TX_SEQ_WRITE(v, p)                                      MWRITE_32((uint8_t *)(p) + 4, (v))
/* <<<TCPSPDTEST_RTO_RING_TX_SEQ_METADATA_STRUCT */


/* >>>TCPSPDTEST_RING_SACK_OPT_METADATA_STRUCT */
typedef union
    {
    uint8_t word_8[8];
    uint16_t word_16[4];
    uint32_t word_32[2];
    uint64_t dword_64[1];
        struct {
        uint32_t	left_edge 	;
        uint32_t	right_edge	;
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) TCPSPDTEST_RING_SACK_OPT_METADATA_STRUCT;

#define RDD_TCPSPDTEST_RING_SACK_OPT_METADATA_LEFT_EDGE_READ_G(r, g, idx)                                 GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_RING_SACK_OPT_METADATA_STRUCT), (r))
#define RDD_TCPSPDTEST_RING_SACK_OPT_METADATA_LEFT_EDGE_WRITE_G(v, g, idx)                                GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_RING_SACK_OPT_METADATA_STRUCT), (v))
#define RDD_TCPSPDTEST_RING_SACK_OPT_METADATA_LEFT_EDGE_READ_CORE(r, g, idx, core_id)                     CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_RING_SACK_OPT_METADATA_STRUCT), (r), core_id)
#define RDD_TCPSPDTEST_RING_SACK_OPT_METADATA_LEFT_EDGE_WRITE_CORE(v, g, idx, core_id)                    CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_RING_SACK_OPT_METADATA_STRUCT), (v), core_id)
#define RDD_TCPSPDTEST_RING_SACK_OPT_METADATA_LEFT_EDGE_READ(r, p)                                        MREAD_32((uint8_t *)(p), (r))
#define RDD_TCPSPDTEST_RING_SACK_OPT_METADATA_LEFT_EDGE_WRITE(v, p)                                       MWRITE_32((uint8_t *)(p), (v))
#define RDD_TCPSPDTEST_RING_SACK_OPT_METADATA_RIGHT_EDGE_READ_G(r, g, idx)                                GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_RING_SACK_OPT_METADATA_STRUCT) + 4, (r))
#define RDD_TCPSPDTEST_RING_SACK_OPT_METADATA_RIGHT_EDGE_WRITE_G(v, g, idx)                               GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_RING_SACK_OPT_METADATA_STRUCT) + 4, (v))
#define RDD_TCPSPDTEST_RING_SACK_OPT_METADATA_RIGHT_EDGE_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_RING_SACK_OPT_METADATA_STRUCT) + 4, (r), core_id)
#define RDD_TCPSPDTEST_RING_SACK_OPT_METADATA_RIGHT_EDGE_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_RING_SACK_OPT_METADATA_STRUCT) + 4, (v), core_id)
#define RDD_TCPSPDTEST_RING_SACK_OPT_METADATA_RIGHT_EDGE_READ(r, p)                                       MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_TCPSPDTEST_RING_SACK_OPT_METADATA_RIGHT_EDGE_WRITE(v, p)                                      MWRITE_32((uint8_t *)(p) + 4, (v))
/* <<<TCPSPDTEST_RING_SACK_OPT_METADATA_STRUCT */


/* >>>TCPSPDTEST_ENGINE_GLOBAL_INFO_STRUCT */
typedef union
    {
    uint8_t word_8[20];
    uint16_t word_16[10];
    uint32_t word_32[5];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint8_t	num_streams                 	;
        uint8_t	wakeup_stream_id            	;
        uint8_t	dn_pkt_drop_fw_wakeup_vector	;
        uint8_t	num_bns                     	;
        uint32_t	stream_vector               	;
        uint32_t	up_bucket_tokens            	;
        uint32_t	up_bucket_full_tokens       	;
        uint16_t	up_bucket_tokens_fill_rate  	;
        uint8_t	up_next_stream_id           	;
        uint32_t	reserved1                   	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	up_is_timer_active          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#else
        uint8_t	num_bns                     	;
        uint8_t	dn_pkt_drop_fw_wakeup_vector	;
        uint8_t	wakeup_stream_id            	;
        uint8_t	num_streams                 	;
        uint32_t	stream_vector               	;
        uint32_t	up_bucket_tokens            	;
        uint32_t	up_bucket_full_tokens       	;
        uint32_t	up_is_timer_active          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved1                   	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	up_next_stream_id           	;
        uint16_t	up_bucket_tokens_fill_rate  	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(4))) TCPSPDTEST_ENGINE_GLOBAL_INFO_STRUCT;

#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_NUM_STREAMS_READ_G(r, g, idx)                                                 GROUP_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_GLOBAL_INFO_STRUCT), (r))
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_NUM_STREAMS_WRITE_G(v, g, idx)                                                GROUP_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_GLOBAL_INFO_STRUCT), (v))
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_NUM_STREAMS_READ_CORE(r, g, idx, core_id)                                     CORE_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_GLOBAL_INFO_STRUCT), (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_NUM_STREAMS_WRITE_CORE(v, g, idx, core_id)                                    CORE_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_GLOBAL_INFO_STRUCT), (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_NUM_STREAMS_READ(r, p)                                                        MREAD_8((uint8_t *)(p), (r))
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_NUM_STREAMS_WRITE(v, p)                                                       MWRITE_8((uint8_t *)(p), (v))
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_WAKEUP_STREAM_ID_READ_G(r, g, idx)                                            GROUP_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_GLOBAL_INFO_STRUCT) + 1, (r))
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_WAKEUP_STREAM_ID_WRITE_G(v, g, idx)                                           GROUP_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_GLOBAL_INFO_STRUCT) + 1, (v))
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_WAKEUP_STREAM_ID_READ_CORE(r, g, idx, core_id)                                CORE_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_GLOBAL_INFO_STRUCT) + 1, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_WAKEUP_STREAM_ID_WRITE_CORE(v, g, idx, core_id)                               CORE_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_GLOBAL_INFO_STRUCT) + 1, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_WAKEUP_STREAM_ID_READ(r, p)                                                   MREAD_8((uint8_t *)(p) + 1, (r))
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_WAKEUP_STREAM_ID_WRITE(v, p)                                                  MWRITE_8((uint8_t *)(p) + 1, (v))
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_DN_PKT_DROP_FW_WAKEUP_VECTOR_READ_G(r, g, idx)                                GROUP_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_GLOBAL_INFO_STRUCT) + 2, (r))
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_DN_PKT_DROP_FW_WAKEUP_VECTOR_WRITE_G(v, g, idx)                               GROUP_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_GLOBAL_INFO_STRUCT) + 2, (v))
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_DN_PKT_DROP_FW_WAKEUP_VECTOR_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_GLOBAL_INFO_STRUCT) + 2, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_DN_PKT_DROP_FW_WAKEUP_VECTOR_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_GLOBAL_INFO_STRUCT) + 2, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_DN_PKT_DROP_FW_WAKEUP_VECTOR_READ(r, p)                                       MREAD_8((uint8_t *)(p) + 2, (r))
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_DN_PKT_DROP_FW_WAKEUP_VECTOR_WRITE(v, p)                                      MWRITE_8((uint8_t *)(p) + 2, (v))
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_NUM_BNS_READ_G(r, g, idx)                                                     GROUP_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_GLOBAL_INFO_STRUCT) + 3, (r))
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_NUM_BNS_WRITE_G(v, g, idx)                                                    GROUP_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_GLOBAL_INFO_STRUCT) + 3, (v))
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_NUM_BNS_READ_CORE(r, g, idx, core_id)                                         CORE_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_GLOBAL_INFO_STRUCT) + 3, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_NUM_BNS_WRITE_CORE(v, g, idx, core_id)                                        CORE_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_GLOBAL_INFO_STRUCT) + 3, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_NUM_BNS_READ(r, p)                                                            MREAD_8((uint8_t *)(p) + 3, (r))
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_NUM_BNS_WRITE(v, p)                                                           MWRITE_8((uint8_t *)(p) + 3, (v))
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_STREAM_VECTOR_READ_G(r, g, idx)                                               GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_GLOBAL_INFO_STRUCT) + 4, (r))
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_STREAM_VECTOR_WRITE_G(v, g, idx)                                              GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_GLOBAL_INFO_STRUCT) + 4, (v))
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_STREAM_VECTOR_READ_CORE(r, g, idx, core_id)                                   CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_GLOBAL_INFO_STRUCT) + 4, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_STREAM_VECTOR_WRITE_CORE(v, g, idx, core_id)                                  CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_GLOBAL_INFO_STRUCT) + 4, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_STREAM_VECTOR_READ(r, p)                                                      MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_STREAM_VECTOR_WRITE(v, p)                                                     MWRITE_32((uint8_t *)(p) + 4, (v))
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_UP_BUCKET_TOKENS_READ_G(r, g, idx)                                            GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_GLOBAL_INFO_STRUCT) + 8, (r))
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_UP_BUCKET_TOKENS_WRITE_G(v, g, idx)                                           GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_GLOBAL_INFO_STRUCT) + 8, (v))
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_UP_BUCKET_TOKENS_READ_CORE(r, g, idx, core_id)                                CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_GLOBAL_INFO_STRUCT) + 8, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_UP_BUCKET_TOKENS_WRITE_CORE(v, g, idx, core_id)                               CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_GLOBAL_INFO_STRUCT) + 8, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_UP_BUCKET_TOKENS_READ(r, p)                                                   MREAD_32((uint8_t *)(p) + 8, (r))
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_UP_BUCKET_TOKENS_WRITE(v, p)                                                  MWRITE_32((uint8_t *)(p) + 8, (v))
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_UP_BUCKET_FULL_TOKENS_READ_G(r, g, idx)                                       GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_GLOBAL_INFO_STRUCT) + 12, (r))
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_UP_BUCKET_FULL_TOKENS_WRITE_G(v, g, idx)                                      GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_GLOBAL_INFO_STRUCT) + 12, (v))
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_UP_BUCKET_FULL_TOKENS_READ_CORE(r, g, idx, core_id)                           CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_GLOBAL_INFO_STRUCT) + 12, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_UP_BUCKET_FULL_TOKENS_WRITE_CORE(v, g, idx, core_id)                          CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_GLOBAL_INFO_STRUCT) + 12, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_UP_BUCKET_FULL_TOKENS_READ(r, p)                                              MREAD_32((uint8_t *)(p) + 12, (r))
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_UP_BUCKET_FULL_TOKENS_WRITE(v, p)                                             MWRITE_32((uint8_t *)(p) + 12, (v))
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_UP_BUCKET_TOKENS_FILL_RATE_READ_G(r, g, idx)                                  GROUP_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_GLOBAL_INFO_STRUCT) + 16, (r))
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_UP_BUCKET_TOKENS_FILL_RATE_WRITE_G(v, g, idx)                                 GROUP_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_GLOBAL_INFO_STRUCT) + 16, (v))
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_UP_BUCKET_TOKENS_FILL_RATE_READ_CORE(r, g, idx, core_id)                      CORE_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_GLOBAL_INFO_STRUCT) + 16, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_UP_BUCKET_TOKENS_FILL_RATE_WRITE_CORE(v, g, idx, core_id)                     CORE_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_GLOBAL_INFO_STRUCT) + 16, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_UP_BUCKET_TOKENS_FILL_RATE_READ(r, p)                                         MREAD_16((uint8_t *)(p) + 16, (r))
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_UP_BUCKET_TOKENS_FILL_RATE_WRITE(v, p)                                        MWRITE_16((uint8_t *)(p) + 16, (v))
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_UP_NEXT_STREAM_ID_READ_G(r, g, idx)                                           GROUP_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_GLOBAL_INFO_STRUCT) + 18, (r))
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_UP_NEXT_STREAM_ID_WRITE_G(v, g, idx)                                          GROUP_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_GLOBAL_INFO_STRUCT) + 18, (v))
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_UP_NEXT_STREAM_ID_READ_CORE(r, g, idx, core_id)                               CORE_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_GLOBAL_INFO_STRUCT) + 18, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_UP_NEXT_STREAM_ID_WRITE_CORE(v, g, idx, core_id)                              CORE_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_GLOBAL_INFO_STRUCT) + 18, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_UP_NEXT_STREAM_ID_READ(r, p)                                                  MREAD_8((uint8_t *)(p) + 18, (r))
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_UP_NEXT_STREAM_ID_WRITE(v, p)                                                 MWRITE_8((uint8_t *)(p) + 18, (v))
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_UP_IS_TIMER_ACTIVE_READ_G(r, g, idx)                                          GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_GLOBAL_INFO_STRUCT) + 19, 0, 1, (r))
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_UP_IS_TIMER_ACTIVE_WRITE_G(v, g, idx)                                         GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_GLOBAL_INFO_STRUCT) + 19, 0, 1, (v))
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_UP_IS_TIMER_ACTIVE_READ_CORE(r, g, idx, core_id)                              CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_GLOBAL_INFO_STRUCT) + 19, 0, 1, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_UP_IS_TIMER_ACTIVE_WRITE_CORE(v, g, idx, core_id)                             CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_GLOBAL_INFO_STRUCT) + 19, 0, 1, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_UP_IS_TIMER_ACTIVE_READ(r, p)                                                 RDP_FIELD_MREAD_8((uint8_t *)(p) + 19, 0, 1, (r))
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_UP_IS_TIMER_ACTIVE_WRITE(v, p)                                                RDP_FIELD_MWRITE_8((uint8_t *)(p) + 19, 0, 1, (v))
/* <<<TCPSPDTEST_ENGINE_GLOBAL_INFO_STRUCT */


/* >>>TCPSPDTEST_ENGINE_CONN_INFO_STRUCT */
typedef union
    {
    uint8_t word_8[8];
    uint16_t word_16[4];
    uint32_t word_32[2];
    uint64_t dword_64[1];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint8_t	cpu_rx_rdd_queue	;
        uint8_t	up_pppoe_hdr_ofs	;
        uint8_t	up_peer_rx_scale	;
        uint8_t	sack_permitted  	;
        uint16_t	up_tx_mss       	;
        uint16_t	up_tx_max_pd_len	;
#else
        uint8_t	sack_permitted  	;
        uint8_t	up_peer_rx_scale	;
        uint8_t	up_pppoe_hdr_ofs	;
        uint8_t	cpu_rx_rdd_queue	;
        uint16_t	up_tx_max_pd_len	;
        uint16_t	up_tx_mss       	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) TCPSPDTEST_ENGINE_CONN_INFO_STRUCT;

#define RDD_TCPSPDTEST_ENGINE_CONN_INFO_CPU_RX_RDD_QUEUE_READ_G(r, g, idx)                                GROUP_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_CONN_INFO_STRUCT), (r))
#define RDD_TCPSPDTEST_ENGINE_CONN_INFO_CPU_RX_RDD_QUEUE_WRITE_G(v, g, idx)                               GROUP_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_CONN_INFO_STRUCT), (v))
#define RDD_TCPSPDTEST_ENGINE_CONN_INFO_CPU_RX_RDD_QUEUE_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_CONN_INFO_STRUCT), (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_CONN_INFO_CPU_RX_RDD_QUEUE_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_CONN_INFO_STRUCT), (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_CONN_INFO_CPU_RX_RDD_QUEUE_READ(r, p)                                       MREAD_8((uint8_t *)(p), (r))
#define RDD_TCPSPDTEST_ENGINE_CONN_INFO_CPU_RX_RDD_QUEUE_WRITE(v, p)                                      MWRITE_8((uint8_t *)(p), (v))
#define RDD_TCPSPDTEST_ENGINE_CONN_INFO_UP_PPPOE_HDR_OFS_READ_G(r, g, idx)                                GROUP_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_CONN_INFO_STRUCT) + 1, (r))
#define RDD_TCPSPDTEST_ENGINE_CONN_INFO_UP_PPPOE_HDR_OFS_WRITE_G(v, g, idx)                               GROUP_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_CONN_INFO_STRUCT) + 1, (v))
#define RDD_TCPSPDTEST_ENGINE_CONN_INFO_UP_PPPOE_HDR_OFS_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_CONN_INFO_STRUCT) + 1, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_CONN_INFO_UP_PPPOE_HDR_OFS_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_CONN_INFO_STRUCT) + 1, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_CONN_INFO_UP_PPPOE_HDR_OFS_READ(r, p)                                       MREAD_8((uint8_t *)(p) + 1, (r))
#define RDD_TCPSPDTEST_ENGINE_CONN_INFO_UP_PPPOE_HDR_OFS_WRITE(v, p)                                      MWRITE_8((uint8_t *)(p) + 1, (v))
#define RDD_TCPSPDTEST_ENGINE_CONN_INFO_UP_PEER_RX_SCALE_READ_G(r, g, idx)                                GROUP_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_CONN_INFO_STRUCT) + 2, (r))
#define RDD_TCPSPDTEST_ENGINE_CONN_INFO_UP_PEER_RX_SCALE_WRITE_G(v, g, idx)                               GROUP_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_CONN_INFO_STRUCT) + 2, (v))
#define RDD_TCPSPDTEST_ENGINE_CONN_INFO_UP_PEER_RX_SCALE_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_CONN_INFO_STRUCT) + 2, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_CONN_INFO_UP_PEER_RX_SCALE_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_CONN_INFO_STRUCT) + 2, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_CONN_INFO_UP_PEER_RX_SCALE_READ(r, p)                                       MREAD_8((uint8_t *)(p) + 2, (r))
#define RDD_TCPSPDTEST_ENGINE_CONN_INFO_UP_PEER_RX_SCALE_WRITE(v, p)                                      MWRITE_8((uint8_t *)(p) + 2, (v))
#define RDD_TCPSPDTEST_ENGINE_CONN_INFO_SACK_PERMITTED_READ_G(r, g, idx)                                  GROUP_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_CONN_INFO_STRUCT) + 3, (r))
#define RDD_TCPSPDTEST_ENGINE_CONN_INFO_SACK_PERMITTED_WRITE_G(v, g, idx)                                 GROUP_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_CONN_INFO_STRUCT) + 3, (v))
#define RDD_TCPSPDTEST_ENGINE_CONN_INFO_SACK_PERMITTED_READ_CORE(r, g, idx, core_id)                      CORE_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_CONN_INFO_STRUCT) + 3, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_CONN_INFO_SACK_PERMITTED_WRITE_CORE(v, g, idx, core_id)                     CORE_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_CONN_INFO_STRUCT) + 3, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_CONN_INFO_SACK_PERMITTED_READ(r, p)                                         MREAD_8((uint8_t *)(p) + 3, (r))
#define RDD_TCPSPDTEST_ENGINE_CONN_INFO_SACK_PERMITTED_WRITE(v, p)                                        MWRITE_8((uint8_t *)(p) + 3, (v))
#define RDD_TCPSPDTEST_ENGINE_CONN_INFO_UP_TX_MSS_READ_G(r, g, idx)                                       GROUP_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_CONN_INFO_STRUCT) + 4, (r))
#define RDD_TCPSPDTEST_ENGINE_CONN_INFO_UP_TX_MSS_WRITE_G(v, g, idx)                                      GROUP_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_CONN_INFO_STRUCT) + 4, (v))
#define RDD_TCPSPDTEST_ENGINE_CONN_INFO_UP_TX_MSS_READ_CORE(r, g, idx, core_id)                           CORE_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_CONN_INFO_STRUCT) + 4, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_CONN_INFO_UP_TX_MSS_WRITE_CORE(v, g, idx, core_id)                          CORE_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_CONN_INFO_STRUCT) + 4, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_CONN_INFO_UP_TX_MSS_READ(r, p)                                              MREAD_16((uint8_t *)(p) + 4, (r))
#define RDD_TCPSPDTEST_ENGINE_CONN_INFO_UP_TX_MSS_WRITE(v, p)                                             MWRITE_16((uint8_t *)(p) + 4, (v))
#define RDD_TCPSPDTEST_ENGINE_CONN_INFO_UP_TX_MAX_PD_LEN_READ_G(r, g, idx)                                GROUP_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_CONN_INFO_STRUCT) + 6, (r))
#define RDD_TCPSPDTEST_ENGINE_CONN_INFO_UP_TX_MAX_PD_LEN_WRITE_G(v, g, idx)                               GROUP_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_CONN_INFO_STRUCT) + 6, (v))
#define RDD_TCPSPDTEST_ENGINE_CONN_INFO_UP_TX_MAX_PD_LEN_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_CONN_INFO_STRUCT) + 6, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_CONN_INFO_UP_TX_MAX_PD_LEN_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_CONN_INFO_STRUCT) + 6, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_CONN_INFO_UP_TX_MAX_PD_LEN_READ(r, p)                                       MREAD_16((uint8_t *)(p) + 6, (r))
#define RDD_TCPSPDTEST_ENGINE_CONN_INFO_UP_TX_MAX_PD_LEN_WRITE(v, p)                                      MWRITE_16((uint8_t *)(p) + 6, (v))
/* <<<TCPSPDTEST_ENGINE_CONN_INFO_STRUCT */


/* >>>TCPSPDTEST_ENGINE_TCB_STRUCT */
typedef union
    {
    uint8_t word_8[112];
    uint16_t word_16[56];
    uint32_t word_32[28];
    uint64_t dword_64[14];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	rx_pkts                     	;
        uint32_t	txed_pkts                   	;
        uint32_t	freed_pkts                  	;
        uint32_t	ack_seq                     	;
        uint32_t	tx_seq                      	;
        uint16_t	bad_pkts                    	;
        uint16_t	src_port                    	;
        uint32_t	rx_bytes                    	;
        uint32_t	rx_bytes_1                  	;
        uint32_t	expected_bytes              	;
        uint32_t	expected_bytes_1            	;
        uint32_t	up_to_send_bytes            	;
        uint32_t	up_to_send_bytes_1          	;
        uint16_t	no_dispatcher_credits       	;
        uint16_t	no_pktgen_tx_credits        	;
        uint32_t	up_cwnd                     	;
        uint32_t	up_cwnd_thr                 	;
        uint32_t	up_cwnd_initial             	;
        uint32_t	up_cwnd_max                 	;
        uint32_t	up_cwnd_budget              	;
        uint32_t	up_last_ack_seq             	;
        uint32_t	up_last_ack_time            	;
        uint32_t	up_sack_bytes               	;
        uint32_t	up_fast_retrans_trig_cnt    	;
        uint32_t	up_dup_ack_cnt              	;
        uint32_t	up_dup_ack_seq_done         	;
        uint16_t	up_dup_ack_total_pkts_cnt   	;
        uint16_t	up_fast_retrans_cnt         	;
        uint8_t	up_err_dn_pkt_cnt           	;
        uint8_t	dn_err_up_pkt_cnt           	;
        uint8_t	up_cwnd_rtt_factor          	;
        uint8_t	err_dst_port_cnt            	;
        uint16_t	dynack_bytes_thr            	;
        uint16_t	dynack_bytes_thr_cnt        	;
        uint8_t	dynack_thr_upd_rate         	;
        uint8_t	dynack_thr_upd_rate_cnt     	;
        uint8_t	up_dup_ack_state            	;
        uint32_t	reserved2                   	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	dn_is_pkt_drop_driver_wakeup	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	dn_is_pkt_drop_force_ack    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	up_is_rx_win_stop           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	up_is_timeout               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_stream_active            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_upload                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#else
        uint32_t	rx_pkts                     	;
        uint32_t	txed_pkts                   	;
        uint32_t	freed_pkts                  	;
        uint32_t	ack_seq                     	;
        uint32_t	tx_seq                      	;
        uint16_t	src_port                    	;
        uint16_t	bad_pkts                    	;
        uint32_t	rx_bytes                    	;
        uint32_t	rx_bytes_1                  	;
        uint32_t	expected_bytes              	;
        uint32_t	expected_bytes_1            	;
        uint32_t	up_to_send_bytes            	;
        uint32_t	up_to_send_bytes_1          	;
        uint16_t	no_pktgen_tx_credits        	;
        uint16_t	no_dispatcher_credits       	;
        uint32_t	up_cwnd                     	;
        uint32_t	up_cwnd_thr                 	;
        uint32_t	up_cwnd_initial             	;
        uint32_t	up_cwnd_max                 	;
        uint32_t	up_cwnd_budget              	;
        uint32_t	up_last_ack_seq             	;
        uint32_t	up_last_ack_time            	;
        uint32_t	up_sack_bytes               	;
        uint32_t	up_fast_retrans_trig_cnt    	;
        uint32_t	up_dup_ack_cnt              	;
        uint32_t	up_dup_ack_seq_done         	;
        uint16_t	up_fast_retrans_cnt         	;
        uint16_t	up_dup_ack_total_pkts_cnt   	;
        uint8_t	err_dst_port_cnt            	;
        uint8_t	up_cwnd_rtt_factor          	;
        uint8_t	dn_err_up_pkt_cnt           	;
        uint8_t	up_err_dn_pkt_cnt           	;
        uint16_t	dynack_bytes_thr_cnt        	;
        uint16_t	dynack_bytes_thr            	;
        uint32_t	is_upload                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_stream_active            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	up_is_timeout               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	up_is_rx_win_stop           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	dn_is_pkt_drop_force_ack    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	dn_is_pkt_drop_driver_wakeup	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved2                   	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	up_dup_ack_state            	;
        uint8_t	dynack_thr_upd_rate_cnt     	;
        uint8_t	dynack_thr_upd_rate         	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) TCPSPDTEST_ENGINE_TCB_STRUCT;

#define RDD_TCPSPDTEST_ENGINE_TCB_RX_PKTS_READ_G(r, g, idx)                                                     GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT), (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_RX_PKTS_WRITE_G(v, g, idx)                                                    GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT), (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_RX_PKTS_READ_CORE(r, g, idx, core_id)                                         CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT), (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_RX_PKTS_WRITE_CORE(v, g, idx, core_id)                                        CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT), (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_RX_PKTS_READ(r, p)                                                            MREAD_32((uint8_t *)(p), (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_RX_PKTS_WRITE(v, p)                                                           MWRITE_32((uint8_t *)(p), (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_TXED_PKTS_READ_G(r, g, idx)                                                   GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 4, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_TXED_PKTS_WRITE_G(v, g, idx)                                                  GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 4, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_TXED_PKTS_READ_CORE(r, g, idx, core_id)                                       CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 4, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_TXED_PKTS_WRITE_CORE(v, g, idx, core_id)                                      CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 4, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_TXED_PKTS_READ(r, p)                                                          MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_TXED_PKTS_WRITE(v, p)                                                         MWRITE_32((uint8_t *)(p) + 4, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_FREED_PKTS_READ_G(r, g, idx)                                                  GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 8, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_FREED_PKTS_WRITE_G(v, g, idx)                                                 GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 8, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_FREED_PKTS_READ_CORE(r, g, idx, core_id)                                      CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 8, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_FREED_PKTS_WRITE_CORE(v, g, idx, core_id)                                     CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 8, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_FREED_PKTS_READ(r, p)                                                         MREAD_32((uint8_t *)(p) + 8, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_FREED_PKTS_WRITE(v, p)                                                        MWRITE_32((uint8_t *)(p) + 8, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_ACK_SEQ_READ_G(r, g, idx)                                                     GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 12, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_ACK_SEQ_WRITE_G(v, g, idx)                                                    GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 12, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_ACK_SEQ_READ_CORE(r, g, idx, core_id)                                         CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 12, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_ACK_SEQ_WRITE_CORE(v, g, idx, core_id)                                        CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 12, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_ACK_SEQ_READ(r, p)                                                            MREAD_32((uint8_t *)(p) + 12, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_ACK_SEQ_WRITE(v, p)                                                           MWRITE_32((uint8_t *)(p) + 12, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_TX_SEQ_READ_G(r, g, idx)                                                      GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 16, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_TX_SEQ_WRITE_G(v, g, idx)                                                     GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 16, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_TX_SEQ_READ_CORE(r, g, idx, core_id)                                          CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 16, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_TX_SEQ_WRITE_CORE(v, g, idx, core_id)                                         CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 16, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_TX_SEQ_READ(r, p)                                                             MREAD_32((uint8_t *)(p) + 16, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_TX_SEQ_WRITE(v, p)                                                            MWRITE_32((uint8_t *)(p) + 16, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_BAD_PKTS_READ_G(r, g, idx)                                                    GROUP_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 20, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_BAD_PKTS_WRITE_G(v, g, idx)                                                   GROUP_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 20, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_BAD_PKTS_READ_CORE(r, g, idx, core_id)                                        CORE_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 20, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_BAD_PKTS_WRITE_CORE(v, g, idx, core_id)                                       CORE_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 20, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_BAD_PKTS_READ(r, p)                                                           MREAD_16((uint8_t *)(p) + 20, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_BAD_PKTS_WRITE(v, p)                                                          MWRITE_16((uint8_t *)(p) + 20, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_SRC_PORT_READ_G(r, g, idx)                                                    GROUP_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 22, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_SRC_PORT_WRITE_G(v, g, idx)                                                   GROUP_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 22, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_SRC_PORT_READ_CORE(r, g, idx, core_id)                                        CORE_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 22, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_SRC_PORT_WRITE_CORE(v, g, idx, core_id)                                       CORE_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 22, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_SRC_PORT_READ(r, p)                                                           MREAD_16((uint8_t *)(p) + 22, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_SRC_PORT_WRITE(v, p)                                                          MWRITE_16((uint8_t *)(p) + 22, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_RX_BYTES_READ_G(r, g, idx)                                                    GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 24, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_RX_BYTES_WRITE_G(v, g, idx)                                                   GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 24, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_RX_BYTES_READ_CORE(r, g, idx, core_id)                                        CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 24, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_RX_BYTES_WRITE_CORE(v, g, idx, core_id)                                       CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 24, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_RX_BYTES_READ(r, p)                                                           MREAD_32((uint8_t *)(p) + 24, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_RX_BYTES_WRITE(v, p)                                                          MWRITE_32((uint8_t *)(p) + 24, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_RX_BYTES_1_READ_G(r, g, idx)                                                  GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 28, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_RX_BYTES_1_WRITE_G(v, g, idx)                                                 GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 28, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_RX_BYTES_1_READ_CORE(r, g, idx, core_id)                                      CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 28, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_RX_BYTES_1_WRITE_CORE(v, g, idx, core_id)                                     CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 28, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_RX_BYTES_1_READ(r, p)                                                         MREAD_32((uint8_t *)(p) + 28, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_RX_BYTES_1_WRITE(v, p)                                                        MWRITE_32((uint8_t *)(p) + 28, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_EXPECTED_BYTES_READ_G(r, g, idx)                                              GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 32, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_EXPECTED_BYTES_WRITE_G(v, g, idx)                                             GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 32, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_EXPECTED_BYTES_READ_CORE(r, g, idx, core_id)                                  CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 32, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_EXPECTED_BYTES_WRITE_CORE(v, g, idx, core_id)                                 CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 32, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_EXPECTED_BYTES_READ(r, p)                                                     MREAD_32((uint8_t *)(p) + 32, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_EXPECTED_BYTES_WRITE(v, p)                                                    MWRITE_32((uint8_t *)(p) + 32, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_EXPECTED_BYTES_1_READ_G(r, g, idx)                                            GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 36, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_EXPECTED_BYTES_1_WRITE_G(v, g, idx)                                           GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 36, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_EXPECTED_BYTES_1_READ_CORE(r, g, idx, core_id)                                CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 36, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_EXPECTED_BYTES_1_WRITE_CORE(v, g, idx, core_id)                               CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 36, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_EXPECTED_BYTES_1_READ(r, p)                                                   MREAD_32((uint8_t *)(p) + 36, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_EXPECTED_BYTES_1_WRITE(v, p)                                                  MWRITE_32((uint8_t *)(p) + 36, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_TO_SEND_BYTES_READ_G(r, g, idx)                                            GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 40, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_TO_SEND_BYTES_WRITE_G(v, g, idx)                                           GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 40, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_TO_SEND_BYTES_READ_CORE(r, g, idx, core_id)                                CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 40, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_TO_SEND_BYTES_WRITE_CORE(v, g, idx, core_id)                               CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 40, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_TO_SEND_BYTES_READ(r, p)                                                   MREAD_32((uint8_t *)(p) + 40, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_TO_SEND_BYTES_WRITE(v, p)                                                  MWRITE_32((uint8_t *)(p) + 40, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_TO_SEND_BYTES_1_READ_G(r, g, idx)                                          GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 44, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_TO_SEND_BYTES_1_WRITE_G(v, g, idx)                                         GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 44, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_TO_SEND_BYTES_1_READ_CORE(r, g, idx, core_id)                              CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 44, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_TO_SEND_BYTES_1_WRITE_CORE(v, g, idx, core_id)                             CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 44, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_TO_SEND_BYTES_1_READ(r, p)                                                 MREAD_32((uint8_t *)(p) + 44, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_TO_SEND_BYTES_1_WRITE(v, p)                                                MWRITE_32((uint8_t *)(p) + 44, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_NO_DISPATCHER_CREDITS_READ_G(r, g, idx)                                       GROUP_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 48, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_NO_DISPATCHER_CREDITS_WRITE_G(v, g, idx)                                      GROUP_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 48, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_NO_DISPATCHER_CREDITS_READ_CORE(r, g, idx, core_id)                           CORE_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 48, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_NO_DISPATCHER_CREDITS_WRITE_CORE(v, g, idx, core_id)                          CORE_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 48, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_NO_DISPATCHER_CREDITS_READ(r, p)                                              MREAD_16((uint8_t *)(p) + 48, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_NO_DISPATCHER_CREDITS_WRITE(v, p)                                             MWRITE_16((uint8_t *)(p) + 48, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_NO_PKTGEN_TX_CREDITS_READ_G(r, g, idx)                                        GROUP_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 50, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_NO_PKTGEN_TX_CREDITS_WRITE_G(v, g, idx)                                       GROUP_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 50, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_NO_PKTGEN_TX_CREDITS_READ_CORE(r, g, idx, core_id)                            CORE_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 50, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_NO_PKTGEN_TX_CREDITS_WRITE_CORE(v, g, idx, core_id)                           CORE_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 50, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_NO_PKTGEN_TX_CREDITS_READ(r, p)                                               MREAD_16((uint8_t *)(p) + 50, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_NO_PKTGEN_TX_CREDITS_WRITE(v, p)                                              MWRITE_16((uint8_t *)(p) + 50, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_CWND_READ_G(r, g, idx)                                                     GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 52, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_CWND_WRITE_G(v, g, idx)                                                    GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 52, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_CWND_READ_CORE(r, g, idx, core_id)                                         CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 52, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_CWND_WRITE_CORE(v, g, idx, core_id)                                        CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 52, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_CWND_READ(r, p)                                                            MREAD_32((uint8_t *)(p) + 52, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_CWND_WRITE(v, p)                                                           MWRITE_32((uint8_t *)(p) + 52, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_CWND_THR_READ_G(r, g, idx)                                                 GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 56, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_CWND_THR_WRITE_G(v, g, idx)                                                GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 56, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_CWND_THR_READ_CORE(r, g, idx, core_id)                                     CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 56, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_CWND_THR_WRITE_CORE(v, g, idx, core_id)                                    CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 56, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_CWND_THR_READ(r, p)                                                        MREAD_32((uint8_t *)(p) + 56, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_CWND_THR_WRITE(v, p)                                                       MWRITE_32((uint8_t *)(p) + 56, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_CWND_INITIAL_READ_G(r, g, idx)                                             GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 60, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_CWND_INITIAL_WRITE_G(v, g, idx)                                            GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 60, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_CWND_INITIAL_READ_CORE(r, g, idx, core_id)                                 CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 60, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_CWND_INITIAL_WRITE_CORE(v, g, idx, core_id)                                CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 60, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_CWND_INITIAL_READ(r, p)                                                    MREAD_32((uint8_t *)(p) + 60, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_CWND_INITIAL_WRITE(v, p)                                                   MWRITE_32((uint8_t *)(p) + 60, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_CWND_MAX_READ_G(r, g, idx)                                                 GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 64, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_CWND_MAX_WRITE_G(v, g, idx)                                                GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 64, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_CWND_MAX_READ_CORE(r, g, idx, core_id)                                     CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 64, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_CWND_MAX_WRITE_CORE(v, g, idx, core_id)                                    CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 64, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_CWND_MAX_READ(r, p)                                                        MREAD_32((uint8_t *)(p) + 64, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_CWND_MAX_WRITE(v, p)                                                       MWRITE_32((uint8_t *)(p) + 64, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_CWND_BUDGET_READ_G(r, g, idx)                                              GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 68, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_CWND_BUDGET_WRITE_G(v, g, idx)                                             GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 68, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_CWND_BUDGET_READ_CORE(r, g, idx, core_id)                                  CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 68, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_CWND_BUDGET_WRITE_CORE(v, g, idx, core_id)                                 CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 68, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_CWND_BUDGET_READ(r, p)                                                     MREAD_32((uint8_t *)(p) + 68, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_CWND_BUDGET_WRITE(v, p)                                                    MWRITE_32((uint8_t *)(p) + 68, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_LAST_ACK_SEQ_READ_G(r, g, idx)                                             GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 72, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_LAST_ACK_SEQ_WRITE_G(v, g, idx)                                            GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 72, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_LAST_ACK_SEQ_READ_CORE(r, g, idx, core_id)                                 CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 72, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_LAST_ACK_SEQ_WRITE_CORE(v, g, idx, core_id)                                CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 72, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_LAST_ACK_SEQ_READ(r, p)                                                    MREAD_32((uint8_t *)(p) + 72, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_LAST_ACK_SEQ_WRITE(v, p)                                                   MWRITE_32((uint8_t *)(p) + 72, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_LAST_ACK_TIME_READ_G(r, g, idx)                                            GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 76, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_LAST_ACK_TIME_WRITE_G(v, g, idx)                                           GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 76, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_LAST_ACK_TIME_READ_CORE(r, g, idx, core_id)                                CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 76, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_LAST_ACK_TIME_WRITE_CORE(v, g, idx, core_id)                               CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 76, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_LAST_ACK_TIME_READ(r, p)                                                   MREAD_32((uint8_t *)(p) + 76, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_LAST_ACK_TIME_WRITE(v, p)                                                  MWRITE_32((uint8_t *)(p) + 76, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_SACK_BYTES_READ_G(r, g, idx)                                               GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 80, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_SACK_BYTES_WRITE_G(v, g, idx)                                              GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 80, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_SACK_BYTES_READ_CORE(r, g, idx, core_id)                                   CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 80, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_SACK_BYTES_WRITE_CORE(v, g, idx, core_id)                                  CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 80, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_SACK_BYTES_READ(r, p)                                                      MREAD_32((uint8_t *)(p) + 80, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_SACK_BYTES_WRITE(v, p)                                                     MWRITE_32((uint8_t *)(p) + 80, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_FAST_RETRANS_TRIG_CNT_READ_G(r, g, idx)                                    GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 84, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_FAST_RETRANS_TRIG_CNT_WRITE_G(v, g, idx)                                   GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 84, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_FAST_RETRANS_TRIG_CNT_READ_CORE(r, g, idx, core_id)                        CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 84, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_FAST_RETRANS_TRIG_CNT_WRITE_CORE(v, g, idx, core_id)                       CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 84, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_FAST_RETRANS_TRIG_CNT_READ(r, p)                                           MREAD_32((uint8_t *)(p) + 84, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_FAST_RETRANS_TRIG_CNT_WRITE(v, p)                                          MWRITE_32((uint8_t *)(p) + 84, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_DUP_ACK_CNT_READ_G(r, g, idx)                                              GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 88, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_DUP_ACK_CNT_WRITE_G(v, g, idx)                                             GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 88, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_DUP_ACK_CNT_READ_CORE(r, g, idx, core_id)                                  CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 88, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_DUP_ACK_CNT_WRITE_CORE(v, g, idx, core_id)                                 CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 88, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_DUP_ACK_CNT_READ(r, p)                                                     MREAD_32((uint8_t *)(p) + 88, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_DUP_ACK_CNT_WRITE(v, p)                                                    MWRITE_32((uint8_t *)(p) + 88, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_DUP_ACK_SEQ_DONE_READ_G(r, g, idx)                                         GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 92, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_DUP_ACK_SEQ_DONE_WRITE_G(v, g, idx)                                        GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 92, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_DUP_ACK_SEQ_DONE_READ_CORE(r, g, idx, core_id)                             CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 92, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_DUP_ACK_SEQ_DONE_WRITE_CORE(v, g, idx, core_id)                            CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 92, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_DUP_ACK_SEQ_DONE_READ(r, p)                                                MREAD_32((uint8_t *)(p) + 92, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_DUP_ACK_SEQ_DONE_WRITE(v, p)                                               MWRITE_32((uint8_t *)(p) + 92, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_DUP_ACK_TOTAL_PKTS_CNT_READ_G(r, g, idx)                                   GROUP_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 96, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_DUP_ACK_TOTAL_PKTS_CNT_WRITE_G(v, g, idx)                                  GROUP_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 96, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_DUP_ACK_TOTAL_PKTS_CNT_READ_CORE(r, g, idx, core_id)                       CORE_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 96, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_DUP_ACK_TOTAL_PKTS_CNT_WRITE_CORE(v, g, idx, core_id)                      CORE_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 96, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_DUP_ACK_TOTAL_PKTS_CNT_READ(r, p)                                          MREAD_16((uint8_t *)(p) + 96, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_DUP_ACK_TOTAL_PKTS_CNT_WRITE(v, p)                                         MWRITE_16((uint8_t *)(p) + 96, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_FAST_RETRANS_CNT_READ_G(r, g, idx)                                         GROUP_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 98, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_FAST_RETRANS_CNT_WRITE_G(v, g, idx)                                        GROUP_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 98, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_FAST_RETRANS_CNT_READ_CORE(r, g, idx, core_id)                             CORE_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 98, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_FAST_RETRANS_CNT_WRITE_CORE(v, g, idx, core_id)                            CORE_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 98, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_FAST_RETRANS_CNT_READ(r, p)                                                MREAD_16((uint8_t *)(p) + 98, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_FAST_RETRANS_CNT_WRITE(v, p)                                               MWRITE_16((uint8_t *)(p) + 98, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_ERR_DN_PKT_CNT_READ_G(r, g, idx)                                           GROUP_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 100, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_ERR_DN_PKT_CNT_WRITE_G(v, g, idx)                                          GROUP_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 100, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_ERR_DN_PKT_CNT_READ_CORE(r, g, idx, core_id)                               CORE_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 100, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_ERR_DN_PKT_CNT_WRITE_CORE(v, g, idx, core_id)                              CORE_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 100, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_ERR_DN_PKT_CNT_READ(r, p)                                                  MREAD_8((uint8_t *)(p) + 100, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_ERR_DN_PKT_CNT_WRITE(v, p)                                                 MWRITE_8((uint8_t *)(p) + 100, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_DN_ERR_UP_PKT_CNT_READ_G(r, g, idx)                                           GROUP_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 101, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_DN_ERR_UP_PKT_CNT_WRITE_G(v, g, idx)                                          GROUP_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 101, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_DN_ERR_UP_PKT_CNT_READ_CORE(r, g, idx, core_id)                               CORE_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 101, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_DN_ERR_UP_PKT_CNT_WRITE_CORE(v, g, idx, core_id)                              CORE_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 101, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_DN_ERR_UP_PKT_CNT_READ(r, p)                                                  MREAD_8((uint8_t *)(p) + 101, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_DN_ERR_UP_PKT_CNT_WRITE(v, p)                                                 MWRITE_8((uint8_t *)(p) + 101, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_CWND_RTT_FACTOR_READ_G(r, g, idx)                                          GROUP_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 102, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_CWND_RTT_FACTOR_WRITE_G(v, g, idx)                                         GROUP_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 102, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_CWND_RTT_FACTOR_READ_CORE(r, g, idx, core_id)                              CORE_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 102, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_CWND_RTT_FACTOR_WRITE_CORE(v, g, idx, core_id)                             CORE_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 102, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_CWND_RTT_FACTOR_READ(r, p)                                                 MREAD_8((uint8_t *)(p) + 102, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_CWND_RTT_FACTOR_WRITE(v, p)                                                MWRITE_8((uint8_t *)(p) + 102, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_ERR_DST_PORT_CNT_READ_G(r, g, idx)                                            GROUP_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 103, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_ERR_DST_PORT_CNT_WRITE_G(v, g, idx)                                           GROUP_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 103, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_ERR_DST_PORT_CNT_READ_CORE(r, g, idx, core_id)                                CORE_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 103, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_ERR_DST_PORT_CNT_WRITE_CORE(v, g, idx, core_id)                               CORE_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 103, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_ERR_DST_PORT_CNT_READ(r, p)                                                   MREAD_8((uint8_t *)(p) + 103, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_ERR_DST_PORT_CNT_WRITE(v, p)                                                  MWRITE_8((uint8_t *)(p) + 103, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_DYNACK_BYTES_THR_READ_G(r, g, idx)                                            GROUP_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 104, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_DYNACK_BYTES_THR_WRITE_G(v, g, idx)                                           GROUP_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 104, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_DYNACK_BYTES_THR_READ_CORE(r, g, idx, core_id)                                CORE_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 104, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_DYNACK_BYTES_THR_WRITE_CORE(v, g, idx, core_id)                               CORE_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 104, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_DYNACK_BYTES_THR_READ(r, p)                                                   MREAD_16((uint8_t *)(p) + 104, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_DYNACK_BYTES_THR_WRITE(v, p)                                                  MWRITE_16((uint8_t *)(p) + 104, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_DYNACK_BYTES_THR_CNT_READ_G(r, g, idx)                                        GROUP_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 106, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_DYNACK_BYTES_THR_CNT_WRITE_G(v, g, idx)                                       GROUP_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 106, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_DYNACK_BYTES_THR_CNT_READ_CORE(r, g, idx, core_id)                            CORE_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 106, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_DYNACK_BYTES_THR_CNT_WRITE_CORE(v, g, idx, core_id)                           CORE_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 106, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_DYNACK_BYTES_THR_CNT_READ(r, p)                                               MREAD_16((uint8_t *)(p) + 106, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_DYNACK_BYTES_THR_CNT_WRITE(v, p)                                              MWRITE_16((uint8_t *)(p) + 106, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_DYNACK_THR_UPD_RATE_READ_G(r, g, idx)                                         GROUP_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 108, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_DYNACK_THR_UPD_RATE_WRITE_G(v, g, idx)                                        GROUP_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 108, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_DYNACK_THR_UPD_RATE_READ_CORE(r, g, idx, core_id)                             CORE_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 108, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_DYNACK_THR_UPD_RATE_WRITE_CORE(v, g, idx, core_id)                            CORE_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 108, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_DYNACK_THR_UPD_RATE_READ(r, p)                                                MREAD_8((uint8_t *)(p) + 108, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_DYNACK_THR_UPD_RATE_WRITE(v, p)                                               MWRITE_8((uint8_t *)(p) + 108, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_DYNACK_THR_UPD_RATE_CNT_READ_G(r, g, idx)                                     GROUP_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 109, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_DYNACK_THR_UPD_RATE_CNT_WRITE_G(v, g, idx)                                    GROUP_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 109, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_DYNACK_THR_UPD_RATE_CNT_READ_CORE(r, g, idx, core_id)                         CORE_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 109, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_DYNACK_THR_UPD_RATE_CNT_WRITE_CORE(v, g, idx, core_id)                        CORE_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 109, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_DYNACK_THR_UPD_RATE_CNT_READ(r, p)                                            MREAD_8((uint8_t *)(p) + 109, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_DYNACK_THR_UPD_RATE_CNT_WRITE(v, p)                                           MWRITE_8((uint8_t *)(p) + 109, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_DUP_ACK_STATE_READ_G(r, g, idx)                                            GROUP_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 110, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_DUP_ACK_STATE_WRITE_G(v, g, idx)                                           GROUP_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 110, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_DUP_ACK_STATE_READ_CORE(r, g, idx, core_id)                                CORE_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 110, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_DUP_ACK_STATE_WRITE_CORE(v, g, idx, core_id)                               CORE_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 110, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_DUP_ACK_STATE_READ(r, p)                                                   MREAD_8((uint8_t *)(p) + 110, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_DUP_ACK_STATE_WRITE(v, p)                                                  MWRITE_8((uint8_t *)(p) + 110, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_DN_IS_PKT_DROP_DRIVER_WAKEUP_READ_G(r, g, idx)                                GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 111, 5, 1, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_DN_IS_PKT_DROP_DRIVER_WAKEUP_WRITE_G(v, g, idx)                               GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 111, 5, 1, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_DN_IS_PKT_DROP_DRIVER_WAKEUP_READ_CORE(r, g, idx, core_id)                    CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 111, 5, 1, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_DN_IS_PKT_DROP_DRIVER_WAKEUP_WRITE_CORE(v, g, idx, core_id)                   CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 111, 5, 1, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_DN_IS_PKT_DROP_DRIVER_WAKEUP_READ(r, p)                                       RDP_FIELD_MREAD_8((uint8_t *)(p) + 111, 5, 1, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_DN_IS_PKT_DROP_DRIVER_WAKEUP_WRITE(v, p)                                      RDP_FIELD_MWRITE_8((uint8_t *)(p) + 111, 5, 1, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_DN_IS_PKT_DROP_FORCE_ACK_READ_G(r, g, idx)                                    GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 111, 4, 1, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_DN_IS_PKT_DROP_FORCE_ACK_WRITE_G(v, g, idx)                                   GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 111, 4, 1, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_DN_IS_PKT_DROP_FORCE_ACK_READ_CORE(r, g, idx, core_id)                        CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 111, 4, 1, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_DN_IS_PKT_DROP_FORCE_ACK_WRITE_CORE(v, g, idx, core_id)                       CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 111, 4, 1, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_DN_IS_PKT_DROP_FORCE_ACK_READ(r, p)                                           RDP_FIELD_MREAD_8((uint8_t *)(p) + 111, 4, 1, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_DN_IS_PKT_DROP_FORCE_ACK_WRITE(v, p)                                          RDP_FIELD_MWRITE_8((uint8_t *)(p) + 111, 4, 1, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_IS_RX_WIN_STOP_READ_G(r, g, idx)                                           GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 111, 3, 1, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_IS_RX_WIN_STOP_WRITE_G(v, g, idx)                                          GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 111, 3, 1, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_IS_RX_WIN_STOP_READ_CORE(r, g, idx, core_id)                               CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 111, 3, 1, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_IS_RX_WIN_STOP_WRITE_CORE(v, g, idx, core_id)                              CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 111, 3, 1, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_IS_RX_WIN_STOP_READ(r, p)                                                  RDP_FIELD_MREAD_8((uint8_t *)(p) + 111, 3, 1, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_IS_RX_WIN_STOP_WRITE(v, p)                                                 RDP_FIELD_MWRITE_8((uint8_t *)(p) + 111, 3, 1, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_IS_TIMEOUT_READ_G(r, g, idx)                                               GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 111, 2, 1, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_IS_TIMEOUT_WRITE_G(v, g, idx)                                              GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 111, 2, 1, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_IS_TIMEOUT_READ_CORE(r, g, idx, core_id)                                   CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 111, 2, 1, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_IS_TIMEOUT_WRITE_CORE(v, g, idx, core_id)                                  CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 111, 2, 1, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_IS_TIMEOUT_READ(r, p)                                                      RDP_FIELD_MREAD_8((uint8_t *)(p) + 111, 2, 1, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_IS_TIMEOUT_WRITE(v, p)                                                     RDP_FIELD_MWRITE_8((uint8_t *)(p) + 111, 2, 1, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_IS_STREAM_ACTIVE_READ_G(r, g, idx)                                            GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 111, 1, 1, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_IS_STREAM_ACTIVE_WRITE_G(v, g, idx)                                           GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 111, 1, 1, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_IS_STREAM_ACTIVE_READ_CORE(r, g, idx, core_id)                                CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 111, 1, 1, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_IS_STREAM_ACTIVE_WRITE_CORE(v, g, idx, core_id)                               CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 111, 1, 1, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_IS_STREAM_ACTIVE_READ(r, p)                                                   RDP_FIELD_MREAD_8((uint8_t *)(p) + 111, 1, 1, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_IS_STREAM_ACTIVE_WRITE(v, p)                                                  RDP_FIELD_MWRITE_8((uint8_t *)(p) + 111, 1, 1, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_IS_UPLOAD_READ_G(r, g, idx)                                                   GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 111, 0, 1, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_IS_UPLOAD_WRITE_G(v, g, idx)                                                  GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 111, 0, 1, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_IS_UPLOAD_READ_CORE(r, g, idx, core_id)                                       CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 111, 0, 1, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_IS_UPLOAD_WRITE_CORE(v, g, idx, core_id)                                      CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 111, 0, 1, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_IS_UPLOAD_READ(r, p)                                                          RDP_FIELD_MREAD_8((uint8_t *)(p) + 111, 0, 1, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_IS_UPLOAD_WRITE(v, p)                                                         RDP_FIELD_MWRITE_8((uint8_t *)(p) + 111, 0, 1, (v))
/* <<<TCPSPDTEST_ENGINE_TCB_STRUCT */


/* >>>TCPSPDTEST_ENGINE_PKT_DROP_STRUCT */
typedef union
    {
    uint8_t word_8[48];
    uint16_t word_16[24];
    uint32_t word_32[12];
    uint64_t dword_64[6];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint8_t	drop_state                 	;
        uint8_t	is_win_full                	;
        uint16_t	num_errs                   	;
        uint16_t	wr_ofs                     	;
        uint16_t	rd_ofs                     	;
        uint32_t	ack_seq_err_start          	;
        uint32_t	saved_rx_l4_seq            	;
        uint32_t	saved_ring_rd_wr_ofs       	;
        uint32_t	saved_ring_rd_wr_ofs_1     	;
        uint32_t	saved_rx_l3_hdr_len        	;
        uint32_t	saved_rx_l3_payload_len    	;
        uint32_t	saved_packet_descriptor_0  	;
        uint32_t	saved_packet_descriptor_0_1	;
        uint32_t	saved_packet_descriptor_2  	;
        uint32_t	saved_packet_descriptor_2_1	;
#else
        uint16_t	num_errs                   	;
        uint8_t	is_win_full                	;
        uint8_t	drop_state                 	;
        uint16_t	rd_ofs                     	;
        uint16_t	wr_ofs                     	;
        uint32_t	ack_seq_err_start          	;
        uint32_t	saved_rx_l4_seq            	;
        uint32_t	saved_ring_rd_wr_ofs       	;
        uint32_t	saved_ring_rd_wr_ofs_1     	;
        uint32_t	saved_rx_l3_hdr_len        	;
        uint32_t	saved_rx_l3_payload_len    	;
        uint32_t	saved_packet_descriptor_0  	;
        uint32_t	saved_packet_descriptor_0_1	;
        uint32_t	saved_packet_descriptor_2  	;
        uint32_t	saved_packet_descriptor_2_1	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) TCPSPDTEST_ENGINE_PKT_DROP_STRUCT;

#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_DROP_STATE_READ_G(r, g, idx)                                                 GROUP_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT), (r))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_DROP_STATE_WRITE_G(v, g, idx)                                                GROUP_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT), (v))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_DROP_STATE_READ_CORE(r, g, idx, core_id)                                     CORE_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT), (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_DROP_STATE_WRITE_CORE(v, g, idx, core_id)                                    CORE_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT), (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_DROP_STATE_READ(r, p)                                                        MREAD_8((uint8_t *)(p), (r))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_DROP_STATE_WRITE(v, p)                                                       MWRITE_8((uint8_t *)(p), (v))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_IS_WIN_FULL_READ_G(r, g, idx)                                                GROUP_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT) + 1, (r))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_IS_WIN_FULL_WRITE_G(v, g, idx)                                               GROUP_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT) + 1, (v))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_IS_WIN_FULL_READ_CORE(r, g, idx, core_id)                                    CORE_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT) + 1, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_IS_WIN_FULL_WRITE_CORE(v, g, idx, core_id)                                   CORE_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT) + 1, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_IS_WIN_FULL_READ(r, p)                                                       MREAD_8((uint8_t *)(p) + 1, (r))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_IS_WIN_FULL_WRITE(v, p)                                                      MWRITE_8((uint8_t *)(p) + 1, (v))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_NUM_ERRS_READ_G(r, g, idx)                                                   GROUP_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT) + 2, (r))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_NUM_ERRS_WRITE_G(v, g, idx)                                                  GROUP_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT) + 2, (v))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_NUM_ERRS_READ_CORE(r, g, idx, core_id)                                       CORE_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT) + 2, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_NUM_ERRS_WRITE_CORE(v, g, idx, core_id)                                      CORE_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT) + 2, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_NUM_ERRS_READ(r, p)                                                          MREAD_16((uint8_t *)(p) + 2, (r))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_NUM_ERRS_WRITE(v, p)                                                         MWRITE_16((uint8_t *)(p) + 2, (v))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_WR_OFS_READ_G(r, g, idx)                                                     GROUP_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT) + 4, (r))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_WR_OFS_WRITE_G(v, g, idx)                                                    GROUP_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT) + 4, (v))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_WR_OFS_READ_CORE(r, g, idx, core_id)                                         CORE_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT) + 4, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_WR_OFS_WRITE_CORE(v, g, idx, core_id)                                        CORE_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT) + 4, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_WR_OFS_READ(r, p)                                                            MREAD_16((uint8_t *)(p) + 4, (r))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_WR_OFS_WRITE(v, p)                                                           MWRITE_16((uint8_t *)(p) + 4, (v))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_RD_OFS_READ_G(r, g, idx)                                                     GROUP_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT) + 6, (r))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_RD_OFS_WRITE_G(v, g, idx)                                                    GROUP_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT) + 6, (v))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_RD_OFS_READ_CORE(r, g, idx, core_id)                                         CORE_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT) + 6, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_RD_OFS_WRITE_CORE(v, g, idx, core_id)                                        CORE_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT) + 6, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_RD_OFS_READ(r, p)                                                            MREAD_16((uint8_t *)(p) + 6, (r))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_RD_OFS_WRITE(v, p)                                                           MWRITE_16((uint8_t *)(p) + 6, (v))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_ACK_SEQ_ERR_START_READ_G(r, g, idx)                                          GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT) + 8, (r))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_ACK_SEQ_ERR_START_WRITE_G(v, g, idx)                                         GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT) + 8, (v))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_ACK_SEQ_ERR_START_READ_CORE(r, g, idx, core_id)                              CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT) + 8, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_ACK_SEQ_ERR_START_WRITE_CORE(v, g, idx, core_id)                             CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT) + 8, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_ACK_SEQ_ERR_START_READ(r, p)                                                 MREAD_32((uint8_t *)(p) + 8, (r))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_ACK_SEQ_ERR_START_WRITE(v, p)                                                MWRITE_32((uint8_t *)(p) + 8, (v))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RX_L4_SEQ_READ_G(r, g, idx)                                            GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT) + 12, (r))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RX_L4_SEQ_WRITE_G(v, g, idx)                                           GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT) + 12, (v))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RX_L4_SEQ_READ_CORE(r, g, idx, core_id)                                CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT) + 12, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RX_L4_SEQ_WRITE_CORE(v, g, idx, core_id)                               CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT) + 12, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RX_L4_SEQ_READ(r, p)                                                   MREAD_32((uint8_t *)(p) + 12, (r))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RX_L4_SEQ_WRITE(v, p)                                                  MWRITE_32((uint8_t *)(p) + 12, (v))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RING_RD_WR_OFS_READ_G(r, g, idx)                                       GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT) + 16, (r))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RING_RD_WR_OFS_WRITE_G(v, g, idx)                                      GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT) + 16, (v))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RING_RD_WR_OFS_READ_CORE(r, g, idx, core_id)                           CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT) + 16, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RING_RD_WR_OFS_WRITE_CORE(v, g, idx, core_id)                          CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT) + 16, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RING_RD_WR_OFS_READ(r, p)                                              MREAD_32((uint8_t *)(p) + 16, (r))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RING_RD_WR_OFS_WRITE(v, p)                                             MWRITE_32((uint8_t *)(p) + 16, (v))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RING_RD_WR_OFS_1_READ_G(r, g, idx)                                     GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT) + 20, (r))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RING_RD_WR_OFS_1_WRITE_G(v, g, idx)                                    GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT) + 20, (v))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RING_RD_WR_OFS_1_READ_CORE(r, g, idx, core_id)                         CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT) + 20, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RING_RD_WR_OFS_1_WRITE_CORE(v, g, idx, core_id)                        CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT) + 20, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RING_RD_WR_OFS_1_READ(r, p)                                            MREAD_32((uint8_t *)(p) + 20, (r))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RING_RD_WR_OFS_1_WRITE(v, p)                                           MWRITE_32((uint8_t *)(p) + 20, (v))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RX_L3_HDR_LEN_READ_G(r, g, idx)                                        GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT) + 24, (r))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RX_L3_HDR_LEN_WRITE_G(v, g, idx)                                       GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT) + 24, (v))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RX_L3_HDR_LEN_READ_CORE(r, g, idx, core_id)                            CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT) + 24, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RX_L3_HDR_LEN_WRITE_CORE(v, g, idx, core_id)                           CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT) + 24, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RX_L3_HDR_LEN_READ(r, p)                                               MREAD_32((uint8_t *)(p) + 24, (r))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RX_L3_HDR_LEN_WRITE(v, p)                                              MWRITE_32((uint8_t *)(p) + 24, (v))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RX_L3_PAYLOAD_LEN_READ_G(r, g, idx)                                    GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT) + 28, (r))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RX_L3_PAYLOAD_LEN_WRITE_G(v, g, idx)                                   GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT) + 28, (v))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RX_L3_PAYLOAD_LEN_READ_CORE(r, g, idx, core_id)                        CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT) + 28, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RX_L3_PAYLOAD_LEN_WRITE_CORE(v, g, idx, core_id)                       CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT) + 28, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RX_L3_PAYLOAD_LEN_READ(r, p)                                           MREAD_32((uint8_t *)(p) + 28, (r))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RX_L3_PAYLOAD_LEN_WRITE(v, p)                                          MWRITE_32((uint8_t *)(p) + 28, (v))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_PACKET_DESCRIPTOR_0_READ_G(r, g, idx)                                  GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT) + 32, (r))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_PACKET_DESCRIPTOR_0_WRITE_G(v, g, idx)                                 GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT) + 32, (v))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_PACKET_DESCRIPTOR_0_READ_CORE(r, g, idx, core_id)                      CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT) + 32, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_PACKET_DESCRIPTOR_0_WRITE_CORE(v, g, idx, core_id)                     CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT) + 32, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_PACKET_DESCRIPTOR_0_READ(r, p)                                         MREAD_32((uint8_t *)(p) + 32, (r))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_PACKET_DESCRIPTOR_0_WRITE(v, p)                                        MWRITE_32((uint8_t *)(p) + 32, (v))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_PACKET_DESCRIPTOR_0_1_READ_G(r, g, idx)                                GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT) + 36, (r))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_PACKET_DESCRIPTOR_0_1_WRITE_G(v, g, idx)                               GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT) + 36, (v))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_PACKET_DESCRIPTOR_0_1_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT) + 36, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_PACKET_DESCRIPTOR_0_1_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT) + 36, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_PACKET_DESCRIPTOR_0_1_READ(r, p)                                       MREAD_32((uint8_t *)(p) + 36, (r))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_PACKET_DESCRIPTOR_0_1_WRITE(v, p)                                      MWRITE_32((uint8_t *)(p) + 36, (v))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_PACKET_DESCRIPTOR_2_READ_G(r, g, idx)                                  GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT) + 40, (r))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_PACKET_DESCRIPTOR_2_WRITE_G(v, g, idx)                                 GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT) + 40, (v))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_PACKET_DESCRIPTOR_2_READ_CORE(r, g, idx, core_id)                      CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT) + 40, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_PACKET_DESCRIPTOR_2_WRITE_CORE(v, g, idx, core_id)                     CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT) + 40, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_PACKET_DESCRIPTOR_2_READ(r, p)                                         MREAD_32((uint8_t *)(p) + 40, (r))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_PACKET_DESCRIPTOR_2_WRITE(v, p)                                        MWRITE_32((uint8_t *)(p) + 40, (v))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_PACKET_DESCRIPTOR_2_1_READ_G(r, g, idx)                                GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT) + 44, (r))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_PACKET_DESCRIPTOR_2_1_WRITE_G(v, g, idx)                               GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT) + 44, (v))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_PACKET_DESCRIPTOR_2_1_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT) + 44, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_PACKET_DESCRIPTOR_2_1_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT) + 44, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_PACKET_DESCRIPTOR_2_1_READ(r, p)                                       MREAD_32((uint8_t *)(p) + 44, (r))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_PACKET_DESCRIPTOR_2_1_WRITE(v, p)                                      MWRITE_32((uint8_t *)(p) + 44, (v))
/* <<<TCPSPDTEST_ENGINE_PKT_DROP_STRUCT */


/* >>>TCPSPDTEST_ENGINE_RING_STRUCT */
#define RDD_TCPSPDTEST_ENGINE_RING_SCRATCHPAD_NUMBER	8
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_SCRATCHPAD_METADATA_NUMBER	16
#define RDD_TCPSPDTEST_ENGINE_RING_SACK_OPT_SCRATCHPAD_METADATA_NUMBER	8
typedef union
    {
    uint8_t word_8[208];
    uint16_t word_16[104];
    uint32_t word_32[52];
    uint64_t dword_64[26];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	rto_tx_seq_addr_low                                                                                 	;
        uint32_t	rto_tx_seq_addr_high                                                                                	;
        uint32_t	rto_tx_seq_send_cnt                                                                                 	;
        uint32_t	rto_tx_seq_drop_cnt                                                                                 	;
        uint32_t	rto_retrans_addr_low                                                                                	;
        uint32_t	rto_retrans_addr_high                                                                               	;
        uint32_t	sack_opt_addr_low                                                                                   	;
        uint32_t	sack_opt_addr_high                                                                                  	;
        uint32_t	sack_opt_send_cnt                                                                                   	;
        uint32_t	sack_opt_drop_cnt                                                                                   	;
        uint32_t	pkt_drop_rx_seq_addr_low                                                                            	;
        uint32_t	pkt_drop_rx_seq_addr_high                                                                           	;
        uint32_t	pkt_drop_rx_seq_send_cnt                                                                            	;
        uint32_t	pkt_drop_rx_seq_drop_cnt                                                                            	;
        uint32_t	sack_opt_total_parsed_cnt                                                                           	;
        uint32_t	rto_retrans_receive_cnt                                                                             	;
        uint16_t	rto_tx_seq_scratchpad_metadata_wr_ofs                                                               	;
        uint16_t	reserved1                                                                                           	;
        uint32_t	rto_tx_seq_coalescing_timeout_cnt                                                                   	;
        uint32_t	rto_tx_seq_coalescing_fill_pkt_cnt                                                                  	;
        uint32_t	rto_tx_seq_coalescing_last_time                                                                     	;
        uint32_t	scratchpad[RDD_TCPSPDTEST_ENGINE_RING_SCRATCHPAD_NUMBER];
        uint32_t	rto_tx_seq_scratchpad_metadata[RDD_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_SCRATCHPAD_METADATA_NUMBER];
        uint32_t	sack_opt_scratchpad_metadata[RDD_TCPSPDTEST_ENGINE_RING_SACK_OPT_SCRATCHPAD_METADATA_NUMBER];
#else
        uint32_t	rto_tx_seq_addr_low                                                                                 	;
        uint32_t	rto_tx_seq_addr_high                                                                                	;
        uint32_t	rto_tx_seq_send_cnt                                                                                 	;
        uint32_t	rto_tx_seq_drop_cnt                                                                                 	;
        uint32_t	rto_retrans_addr_low                                                                                	;
        uint32_t	rto_retrans_addr_high                                                                               	;
        uint32_t	sack_opt_addr_low                                                                                   	;
        uint32_t	sack_opt_addr_high                                                                                  	;
        uint32_t	sack_opt_send_cnt                                                                                   	;
        uint32_t	sack_opt_drop_cnt                                                                                   	;
        uint32_t	pkt_drop_rx_seq_addr_low                                                                            	;
        uint32_t	pkt_drop_rx_seq_addr_high                                                                           	;
        uint32_t	pkt_drop_rx_seq_send_cnt                                                                            	;
        uint32_t	pkt_drop_rx_seq_drop_cnt                                                                            	;
        uint32_t	sack_opt_total_parsed_cnt                                                                           	;
        uint32_t	rto_retrans_receive_cnt                                                                             	;
        uint16_t	reserved1                                                                                           	;
        uint16_t	rto_tx_seq_scratchpad_metadata_wr_ofs                                                               	;
        uint32_t	rto_tx_seq_coalescing_timeout_cnt                                                                   	;
        uint32_t	rto_tx_seq_coalescing_fill_pkt_cnt                                                                  	;
        uint32_t	rto_tx_seq_coalescing_last_time                                                                     	;
        uint32_t	scratchpad[RDD_TCPSPDTEST_ENGINE_RING_SCRATCHPAD_NUMBER];
        uint32_t	rto_tx_seq_scratchpad_metadata[RDD_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_SCRATCHPAD_METADATA_NUMBER];
        uint32_t	sack_opt_scratchpad_metadata[RDD_TCPSPDTEST_ENGINE_RING_SACK_OPT_SCRATCHPAD_METADATA_NUMBER];
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) TCPSPDTEST_ENGINE_RING_STRUCT;

#define RDD_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_ADDR_LOW_READ_G(r, g, idx)                                                  GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT), (r))
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_ADDR_LOW_WRITE_G(v, g, idx)                                                 GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT), (v))
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_ADDR_LOW_READ_CORE(r, g, idx, core_id)                                      CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT), (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_ADDR_LOW_WRITE_CORE(v, g, idx, core_id)                                     CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT), (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_ADDR_LOW_READ(r, p)                                                         MREAD_32((uint8_t *)(p), (r))
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_ADDR_LOW_WRITE(v, p)                                                        MWRITE_32((uint8_t *)(p), (v))
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_ADDR_HIGH_READ_G(r, g, idx)                                                 GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 4, (r))
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_ADDR_HIGH_WRITE_G(v, g, idx)                                                GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 4, (v))
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_ADDR_HIGH_READ_CORE(r, g, idx, core_id)                                     CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 4, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_ADDR_HIGH_WRITE_CORE(v, g, idx, core_id)                                    CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 4, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_ADDR_HIGH_READ(r, p)                                                        MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_ADDR_HIGH_WRITE(v, p)                                                       MWRITE_32((uint8_t *)(p) + 4, (v))
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_SEND_CNT_READ_G(r, g, idx)                                                  GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 8, (r))
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_SEND_CNT_WRITE_G(v, g, idx)                                                 GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 8, (v))
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_SEND_CNT_READ_CORE(r, g, idx, core_id)                                      CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 8, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_SEND_CNT_WRITE_CORE(v, g, idx, core_id)                                     CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 8, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_SEND_CNT_READ(r, p)                                                         MREAD_32((uint8_t *)(p) + 8, (r))
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_SEND_CNT_WRITE(v, p)                                                        MWRITE_32((uint8_t *)(p) + 8, (v))
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_DROP_CNT_READ_G(r, g, idx)                                                  GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 12, (r))
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_DROP_CNT_WRITE_G(v, g, idx)                                                 GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 12, (v))
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_DROP_CNT_READ_CORE(r, g, idx, core_id)                                      CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 12, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_DROP_CNT_WRITE_CORE(v, g, idx, core_id)                                     CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 12, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_DROP_CNT_READ(r, p)                                                         MREAD_32((uint8_t *)(p) + 12, (r))
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_DROP_CNT_WRITE(v, p)                                                        MWRITE_32((uint8_t *)(p) + 12, (v))
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_RETRANS_ADDR_LOW_READ_G(r, g, idx)                                                 GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 16, (r))
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_RETRANS_ADDR_LOW_WRITE_G(v, g, idx)                                                GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 16, (v))
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_RETRANS_ADDR_LOW_READ_CORE(r, g, idx, core_id)                                     CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 16, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_RETRANS_ADDR_LOW_WRITE_CORE(v, g, idx, core_id)                                    CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 16, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_RETRANS_ADDR_LOW_READ(r, p)                                                        MREAD_32((uint8_t *)(p) + 16, (r))
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_RETRANS_ADDR_LOW_WRITE(v, p)                                                       MWRITE_32((uint8_t *)(p) + 16, (v))
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_RETRANS_ADDR_HIGH_READ_G(r, g, idx)                                                GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 20, (r))
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_RETRANS_ADDR_HIGH_WRITE_G(v, g, idx)                                               GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 20, (v))
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_RETRANS_ADDR_HIGH_READ_CORE(r, g, idx, core_id)                                    CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 20, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_RETRANS_ADDR_HIGH_WRITE_CORE(v, g, idx, core_id)                                   CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 20, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_RETRANS_ADDR_HIGH_READ(r, p)                                                       MREAD_32((uint8_t *)(p) + 20, (r))
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_RETRANS_ADDR_HIGH_WRITE(v, p)                                                      MWRITE_32((uint8_t *)(p) + 20, (v))
#define RDD_TCPSPDTEST_ENGINE_RING_SACK_OPT_ADDR_LOW_READ_G(r, g, idx)                                                    GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 24, (r))
#define RDD_TCPSPDTEST_ENGINE_RING_SACK_OPT_ADDR_LOW_WRITE_G(v, g, idx)                                                   GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 24, (v))
#define RDD_TCPSPDTEST_ENGINE_RING_SACK_OPT_ADDR_LOW_READ_CORE(r, g, idx, core_id)                                        CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 24, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_RING_SACK_OPT_ADDR_LOW_WRITE_CORE(v, g, idx, core_id)                                       CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 24, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_RING_SACK_OPT_ADDR_LOW_READ(r, p)                                                           MREAD_32((uint8_t *)(p) + 24, (r))
#define RDD_TCPSPDTEST_ENGINE_RING_SACK_OPT_ADDR_LOW_WRITE(v, p)                                                          MWRITE_32((uint8_t *)(p) + 24, (v))
#define RDD_TCPSPDTEST_ENGINE_RING_SACK_OPT_ADDR_HIGH_READ_G(r, g, idx)                                                   GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 28, (r))
#define RDD_TCPSPDTEST_ENGINE_RING_SACK_OPT_ADDR_HIGH_WRITE_G(v, g, idx)                                                  GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 28, (v))
#define RDD_TCPSPDTEST_ENGINE_RING_SACK_OPT_ADDR_HIGH_READ_CORE(r, g, idx, core_id)                                       CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 28, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_RING_SACK_OPT_ADDR_HIGH_WRITE_CORE(v, g, idx, core_id)                                      CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 28, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_RING_SACK_OPT_ADDR_HIGH_READ(r, p)                                                          MREAD_32((uint8_t *)(p) + 28, (r))
#define RDD_TCPSPDTEST_ENGINE_RING_SACK_OPT_ADDR_HIGH_WRITE(v, p)                                                         MWRITE_32((uint8_t *)(p) + 28, (v))
#define RDD_TCPSPDTEST_ENGINE_RING_SACK_OPT_SEND_CNT_READ_G(r, g, idx)                                                    GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 32, (r))
#define RDD_TCPSPDTEST_ENGINE_RING_SACK_OPT_SEND_CNT_WRITE_G(v, g, idx)                                                   GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 32, (v))
#define RDD_TCPSPDTEST_ENGINE_RING_SACK_OPT_SEND_CNT_READ_CORE(r, g, idx, core_id)                                        CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 32, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_RING_SACK_OPT_SEND_CNT_WRITE_CORE(v, g, idx, core_id)                                       CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 32, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_RING_SACK_OPT_SEND_CNT_READ(r, p)                                                           MREAD_32((uint8_t *)(p) + 32, (r))
#define RDD_TCPSPDTEST_ENGINE_RING_SACK_OPT_SEND_CNT_WRITE(v, p)                                                          MWRITE_32((uint8_t *)(p) + 32, (v))
#define RDD_TCPSPDTEST_ENGINE_RING_SACK_OPT_DROP_CNT_READ_G(r, g, idx)                                                    GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 36, (r))
#define RDD_TCPSPDTEST_ENGINE_RING_SACK_OPT_DROP_CNT_WRITE_G(v, g, idx)                                                   GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 36, (v))
#define RDD_TCPSPDTEST_ENGINE_RING_SACK_OPT_DROP_CNT_READ_CORE(r, g, idx, core_id)                                        CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 36, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_RING_SACK_OPT_DROP_CNT_WRITE_CORE(v, g, idx, core_id)                                       CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 36, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_RING_SACK_OPT_DROP_CNT_READ(r, p)                                                           MREAD_32((uint8_t *)(p) + 36, (r))
#define RDD_TCPSPDTEST_ENGINE_RING_SACK_OPT_DROP_CNT_WRITE(v, p)                                                          MWRITE_32((uint8_t *)(p) + 36, (v))
#define RDD_TCPSPDTEST_ENGINE_RING_PKT_DROP_RX_SEQ_ADDR_LOW_READ_G(r, g, idx)                                             GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 40, (r))
#define RDD_TCPSPDTEST_ENGINE_RING_PKT_DROP_RX_SEQ_ADDR_LOW_WRITE_G(v, g, idx)                                            GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 40, (v))
#define RDD_TCPSPDTEST_ENGINE_RING_PKT_DROP_RX_SEQ_ADDR_LOW_READ_CORE(r, g, idx, core_id)                                 CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 40, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_RING_PKT_DROP_RX_SEQ_ADDR_LOW_WRITE_CORE(v, g, idx, core_id)                                CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 40, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_RING_PKT_DROP_RX_SEQ_ADDR_LOW_READ(r, p)                                                    MREAD_32((uint8_t *)(p) + 40, (r))
#define RDD_TCPSPDTEST_ENGINE_RING_PKT_DROP_RX_SEQ_ADDR_LOW_WRITE(v, p)                                                   MWRITE_32((uint8_t *)(p) + 40, (v))
#define RDD_TCPSPDTEST_ENGINE_RING_PKT_DROP_RX_SEQ_ADDR_HIGH_READ_G(r, g, idx)                                            GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 44, (r))
#define RDD_TCPSPDTEST_ENGINE_RING_PKT_DROP_RX_SEQ_ADDR_HIGH_WRITE_G(v, g, idx)                                           GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 44, (v))
#define RDD_TCPSPDTEST_ENGINE_RING_PKT_DROP_RX_SEQ_ADDR_HIGH_READ_CORE(r, g, idx, core_id)                                CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 44, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_RING_PKT_DROP_RX_SEQ_ADDR_HIGH_WRITE_CORE(v, g, idx, core_id)                               CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 44, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_RING_PKT_DROP_RX_SEQ_ADDR_HIGH_READ(r, p)                                                   MREAD_32((uint8_t *)(p) + 44, (r))
#define RDD_TCPSPDTEST_ENGINE_RING_PKT_DROP_RX_SEQ_ADDR_HIGH_WRITE(v, p)                                                  MWRITE_32((uint8_t *)(p) + 44, (v))
#define RDD_TCPSPDTEST_ENGINE_RING_PKT_DROP_RX_SEQ_SEND_CNT_READ_G(r, g, idx)                                             GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 48, (r))
#define RDD_TCPSPDTEST_ENGINE_RING_PKT_DROP_RX_SEQ_SEND_CNT_WRITE_G(v, g, idx)                                            GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 48, (v))
#define RDD_TCPSPDTEST_ENGINE_RING_PKT_DROP_RX_SEQ_SEND_CNT_READ_CORE(r, g, idx, core_id)                                 CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 48, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_RING_PKT_DROP_RX_SEQ_SEND_CNT_WRITE_CORE(v, g, idx, core_id)                                CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 48, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_RING_PKT_DROP_RX_SEQ_SEND_CNT_READ(r, p)                                                    MREAD_32((uint8_t *)(p) + 48, (r))
#define RDD_TCPSPDTEST_ENGINE_RING_PKT_DROP_RX_SEQ_SEND_CNT_WRITE(v, p)                                                   MWRITE_32((uint8_t *)(p) + 48, (v))
#define RDD_TCPSPDTEST_ENGINE_RING_PKT_DROP_RX_SEQ_DROP_CNT_READ_G(r, g, idx)                                             GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 52, (r))
#define RDD_TCPSPDTEST_ENGINE_RING_PKT_DROP_RX_SEQ_DROP_CNT_WRITE_G(v, g, idx)                                            GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 52, (v))
#define RDD_TCPSPDTEST_ENGINE_RING_PKT_DROP_RX_SEQ_DROP_CNT_READ_CORE(r, g, idx, core_id)                                 CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 52, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_RING_PKT_DROP_RX_SEQ_DROP_CNT_WRITE_CORE(v, g, idx, core_id)                                CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 52, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_RING_PKT_DROP_RX_SEQ_DROP_CNT_READ(r, p)                                                    MREAD_32((uint8_t *)(p) + 52, (r))
#define RDD_TCPSPDTEST_ENGINE_RING_PKT_DROP_RX_SEQ_DROP_CNT_WRITE(v, p)                                                   MWRITE_32((uint8_t *)(p) + 52, (v))
#define RDD_TCPSPDTEST_ENGINE_RING_SACK_OPT_TOTAL_PARSED_CNT_READ_G(r, g, idx)                                            GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 56, (r))
#define RDD_TCPSPDTEST_ENGINE_RING_SACK_OPT_TOTAL_PARSED_CNT_WRITE_G(v, g, idx)                                           GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 56, (v))
#define RDD_TCPSPDTEST_ENGINE_RING_SACK_OPT_TOTAL_PARSED_CNT_READ_CORE(r, g, idx, core_id)                                CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 56, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_RING_SACK_OPT_TOTAL_PARSED_CNT_WRITE_CORE(v, g, idx, core_id)                               CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 56, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_RING_SACK_OPT_TOTAL_PARSED_CNT_READ(r, p)                                                   MREAD_32((uint8_t *)(p) + 56, (r))
#define RDD_TCPSPDTEST_ENGINE_RING_SACK_OPT_TOTAL_PARSED_CNT_WRITE(v, p)                                                  MWRITE_32((uint8_t *)(p) + 56, (v))
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_RETRANS_RECEIVE_CNT_READ_G(r, g, idx)                                              GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 60, (r))
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_RETRANS_RECEIVE_CNT_WRITE_G(v, g, idx)                                             GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 60, (v))
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_RETRANS_RECEIVE_CNT_READ_CORE(r, g, idx, core_id)                                  CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 60, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_RETRANS_RECEIVE_CNT_WRITE_CORE(v, g, idx, core_id)                                 CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 60, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_RETRANS_RECEIVE_CNT_READ(r, p)                                                     MREAD_32((uint8_t *)(p) + 60, (r))
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_RETRANS_RECEIVE_CNT_WRITE(v, p)                                                    MWRITE_32((uint8_t *)(p) + 60, (v))
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_SCRATCHPAD_METADATA_WR_OFS_READ_G(r, g, idx)                                GROUP_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 64, (r))
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_SCRATCHPAD_METADATA_WR_OFS_WRITE_G(v, g, idx)                               GROUP_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 64, (v))
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_SCRATCHPAD_METADATA_WR_OFS_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 64, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_SCRATCHPAD_METADATA_WR_OFS_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 64, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_SCRATCHPAD_METADATA_WR_OFS_READ(r, p)                                       MREAD_16((uint8_t *)(p) + 64, (r))
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_SCRATCHPAD_METADATA_WR_OFS_WRITE(v, p)                                      MWRITE_16((uint8_t *)(p) + 64, (v))
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_COALESCING_TIMEOUT_CNT_READ_G(r, g, idx)                                    GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 68, (r))
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_COALESCING_TIMEOUT_CNT_WRITE_G(v, g, idx)                                   GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 68, (v))
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_COALESCING_TIMEOUT_CNT_READ_CORE(r, g, idx, core_id)                        CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 68, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_COALESCING_TIMEOUT_CNT_WRITE_CORE(v, g, idx, core_id)                       CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 68, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_COALESCING_TIMEOUT_CNT_READ(r, p)                                           MREAD_32((uint8_t *)(p) + 68, (r))
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_COALESCING_TIMEOUT_CNT_WRITE(v, p)                                          MWRITE_32((uint8_t *)(p) + 68, (v))
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_COALESCING_FILL_PKT_CNT_READ_G(r, g, idx)                                   GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 72, (r))
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_COALESCING_FILL_PKT_CNT_WRITE_G(v, g, idx)                                  GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 72, (v))
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_COALESCING_FILL_PKT_CNT_READ_CORE(r, g, idx, core_id)                       CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 72, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_COALESCING_FILL_PKT_CNT_WRITE_CORE(v, g, idx, core_id)                      CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 72, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_COALESCING_FILL_PKT_CNT_READ(r, p)                                          MREAD_32((uint8_t *)(p) + 72, (r))
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_COALESCING_FILL_PKT_CNT_WRITE(v, p)                                         MWRITE_32((uint8_t *)(p) + 72, (v))
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_COALESCING_LAST_TIME_READ_G(r, g, idx)                                      GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 76, (r))
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_COALESCING_LAST_TIME_WRITE_G(v, g, idx)                                     GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 76, (v))
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_COALESCING_LAST_TIME_READ_CORE(r, g, idx, core_id)                          CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 76, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_COALESCING_LAST_TIME_WRITE_CORE(v, g, idx, core_id)                         CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 76, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_COALESCING_LAST_TIME_READ(r, p)                                             MREAD_32((uint8_t *)(p) + 76, (r))
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_COALESCING_LAST_TIME_WRITE(v, p)                                            MWRITE_32((uint8_t *)(p) + 76, (v))
#define RDD_TCPSPDTEST_ENGINE_RING_SCRATCHPAD_READ_G(r, g, idx, i)                                                        GROUP_MREAD_I_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 80, i, (r))
#define RDD_TCPSPDTEST_ENGINE_RING_SCRATCHPAD_WRITE_G(v, g, idx, i)                                                       GROUP_MWRITE_I_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 80, i, (v))
#define RDD_TCPSPDTEST_ENGINE_RING_SCRATCHPAD_READ_CORE(r, g, idx, i, core_id)                                            CORE_MREAD_I_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 80, i, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_RING_SCRATCHPAD_WRITE_CORE(v, g, idx, i, core_id)                                           CORE_MWRITE_I_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 80, i, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_RING_SCRATCHPAD_READ(r, p, i)                                                               MREAD_I_32((uint8_t *)(p) + 80, i, (r))
#define RDD_TCPSPDTEST_ENGINE_RING_SCRATCHPAD_WRITE(v, p, i)                                                              MWRITE_I_32((uint8_t *)(p) + 80, i, (v))
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_SCRATCHPAD_METADATA_READ_G(r, g, idx, i)                                    GROUP_MREAD_I_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 112, i, (r))
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_SCRATCHPAD_METADATA_WRITE_G(v, g, idx, i)                                   GROUP_MWRITE_I_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 112, i, (v))
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_SCRATCHPAD_METADATA_READ_CORE(r, g, idx, i, core_id)                        CORE_MREAD_I_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 112, i, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_SCRATCHPAD_METADATA_WRITE_CORE(v, g, idx, i, core_id)                       CORE_MWRITE_I_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 112, i, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_SCRATCHPAD_METADATA_READ(r, p, i)                                           MREAD_I_32((uint8_t *)(p) + 112, i, (r))
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_SCRATCHPAD_METADATA_WRITE(v, p, i)                                          MWRITE_I_32((uint8_t *)(p) + 112, i, (v))
#define RDD_TCPSPDTEST_ENGINE_RING_SACK_OPT_SCRATCHPAD_METADATA_READ_G(r, g, idx, i)                                      GROUP_MREAD_I_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 176, i, (r))
#define RDD_TCPSPDTEST_ENGINE_RING_SACK_OPT_SCRATCHPAD_METADATA_WRITE_G(v, g, idx, i)                                     GROUP_MWRITE_I_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 176, i, (v))
#define RDD_TCPSPDTEST_ENGINE_RING_SACK_OPT_SCRATCHPAD_METADATA_READ_CORE(r, g, idx, i, core_id)                          CORE_MREAD_I_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 176, i, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_RING_SACK_OPT_SCRATCHPAD_METADATA_WRITE_CORE(v, g, idx, i, core_id)                         CORE_MWRITE_I_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 176, i, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_RING_SACK_OPT_SCRATCHPAD_METADATA_READ(r, p, i)                                             MREAD_I_32((uint8_t *)(p) + 176, i, (r))
#define RDD_TCPSPDTEST_ENGINE_RING_SACK_OPT_SCRATCHPAD_METADATA_WRITE(v, p, i)                                            MWRITE_I_32((uint8_t *)(p) + 176, i, (v))
/* <<<TCPSPDTEST_ENGINE_RING_STRUCT */


/* >>>TCPSPDTEST_STREAM_STRUCT */
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_SCRATCHPAD_NUMBER	8
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_SCRATCHPAD_METADATA_NUMBER	16
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_SACK_OPT_SCRATCHPAD_METADATA_NUMBER	8
typedef union
    {
    uint8_t word_8[376];
    uint16_t word_16[188];
    uint32_t word_32[94];
    uint64_t dword_64[47];
        struct {
        TCPSPDTEST_ENGINE_CONN_INFO_STRUCT tcpspdtest_engine_conn_info;
        TCPSPDTEST_ENGINE_TCB_STRUCT tcpspdtest_engine_tcb;
        TCPSPDTEST_ENGINE_PKT_DROP_STRUCT tcpspdtest_engine_pkt_drop;
        TCPSPDTEST_ENGINE_RING_STRUCT tcpspdtest_engine_ring;
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) TCPSPDTEST_STREAM_STRUCT;

#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_CONN_INFO_CPU_RX_RDD_QUEUE_READ_G(r, g, idx)                                                GROUP_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT), (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_CONN_INFO_CPU_RX_RDD_QUEUE_WRITE_G(v, g, idx)                                               GROUP_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT), (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_CONN_INFO_CPU_RX_RDD_QUEUE_READ_CORE(r, g, idx, core_id)                                    CORE_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT), (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_CONN_INFO_CPU_RX_RDD_QUEUE_WRITE_CORE(v, g, idx, core_id)                                   CORE_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT), (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_CONN_INFO_CPU_RX_RDD_QUEUE_READ(r, p)                                                       MREAD_8((uint8_t *)(p), (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_CONN_INFO_CPU_RX_RDD_QUEUE_WRITE(v, p)                                                      MWRITE_8((uint8_t *)(p), (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_CONN_INFO_UP_PPPOE_HDR_OFS_READ_G(r, g, idx)                                                GROUP_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 1, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_CONN_INFO_UP_PPPOE_HDR_OFS_WRITE_G(v, g, idx)                                               GROUP_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 1, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_CONN_INFO_UP_PPPOE_HDR_OFS_READ_CORE(r, g, idx, core_id)                                    CORE_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 1, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_CONN_INFO_UP_PPPOE_HDR_OFS_WRITE_CORE(v, g, idx, core_id)                                   CORE_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 1, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_CONN_INFO_UP_PPPOE_HDR_OFS_READ(r, p)                                                       MREAD_8((uint8_t *)(p) + 1, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_CONN_INFO_UP_PPPOE_HDR_OFS_WRITE(v, p)                                                      MWRITE_8((uint8_t *)(p) + 1, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_CONN_INFO_UP_PEER_RX_SCALE_READ_G(r, g, idx)                                                GROUP_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 2, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_CONN_INFO_UP_PEER_RX_SCALE_WRITE_G(v, g, idx)                                               GROUP_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 2, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_CONN_INFO_UP_PEER_RX_SCALE_READ_CORE(r, g, idx, core_id)                                    CORE_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 2, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_CONN_INFO_UP_PEER_RX_SCALE_WRITE_CORE(v, g, idx, core_id)                                   CORE_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 2, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_CONN_INFO_UP_PEER_RX_SCALE_READ(r, p)                                                       MREAD_8((uint8_t *)(p) + 2, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_CONN_INFO_UP_PEER_RX_SCALE_WRITE(v, p)                                                      MWRITE_8((uint8_t *)(p) + 2, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_CONN_INFO_SACK_PERMITTED_READ_G(r, g, idx)                                                  GROUP_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 3, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_CONN_INFO_SACK_PERMITTED_WRITE_G(v, g, idx)                                                 GROUP_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 3, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_CONN_INFO_SACK_PERMITTED_READ_CORE(r, g, idx, core_id)                                      CORE_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 3, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_CONN_INFO_SACK_PERMITTED_WRITE_CORE(v, g, idx, core_id)                                     CORE_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 3, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_CONN_INFO_SACK_PERMITTED_READ(r, p)                                                         MREAD_8((uint8_t *)(p) + 3, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_CONN_INFO_SACK_PERMITTED_WRITE(v, p)                                                        MWRITE_8((uint8_t *)(p) + 3, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_CONN_INFO_UP_TX_MSS_READ_G(r, g, idx)                                                       GROUP_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 4, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_CONN_INFO_UP_TX_MSS_WRITE_G(v, g, idx)                                                      GROUP_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 4, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_CONN_INFO_UP_TX_MSS_READ_CORE(r, g, idx, core_id)                                           CORE_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 4, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_CONN_INFO_UP_TX_MSS_WRITE_CORE(v, g, idx, core_id)                                          CORE_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 4, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_CONN_INFO_UP_TX_MSS_READ(r, p)                                                              MREAD_16((uint8_t *)(p) + 4, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_CONN_INFO_UP_TX_MSS_WRITE(v, p)                                                             MWRITE_16((uint8_t *)(p) + 4, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_CONN_INFO_UP_TX_MAX_PD_LEN_READ_G(r, g, idx)                                                GROUP_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 6, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_CONN_INFO_UP_TX_MAX_PD_LEN_WRITE_G(v, g, idx)                                               GROUP_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 6, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_CONN_INFO_UP_TX_MAX_PD_LEN_READ_CORE(r, g, idx, core_id)                                    CORE_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 6, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_CONN_INFO_UP_TX_MAX_PD_LEN_WRITE_CORE(v, g, idx, core_id)                                   CORE_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 6, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_CONN_INFO_UP_TX_MAX_PD_LEN_READ(r, p)                                                       MREAD_16((uint8_t *)(p) + 6, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_CONN_INFO_UP_TX_MAX_PD_LEN_WRITE(v, p)                                                      MWRITE_16((uint8_t *)(p) + 6, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_RX_PKTS_READ_G(r, g, idx)                                                               GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 8, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_RX_PKTS_WRITE_G(v, g, idx)                                                              GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 8, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_RX_PKTS_READ_CORE(r, g, idx, core_id)                                                   CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 8, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_RX_PKTS_WRITE_CORE(v, g, idx, core_id)                                                  CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 8, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_RX_PKTS_READ(r, p)                                                                      MREAD_32((uint8_t *)(p) + 8, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_RX_PKTS_WRITE(v, p)                                                                     MWRITE_32((uint8_t *)(p) + 8, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_TXED_PKTS_READ_G(r, g, idx)                                                             GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 12, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_TXED_PKTS_WRITE_G(v, g, idx)                                                            GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 12, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_TXED_PKTS_READ_CORE(r, g, idx, core_id)                                                 CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 12, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_TXED_PKTS_WRITE_CORE(v, g, idx, core_id)                                                CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 12, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_TXED_PKTS_READ(r, p)                                                                    MREAD_32((uint8_t *)(p) + 12, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_TXED_PKTS_WRITE(v, p)                                                                   MWRITE_32((uint8_t *)(p) + 12, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_FREED_PKTS_READ_G(r, g, idx)                                                            GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 16, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_FREED_PKTS_WRITE_G(v, g, idx)                                                           GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 16, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_FREED_PKTS_READ_CORE(r, g, idx, core_id)                                                CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 16, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_FREED_PKTS_WRITE_CORE(v, g, idx, core_id)                                               CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 16, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_FREED_PKTS_READ(r, p)                                                                   MREAD_32((uint8_t *)(p) + 16, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_FREED_PKTS_WRITE(v, p)                                                                  MWRITE_32((uint8_t *)(p) + 16, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_ACK_SEQ_READ_G(r, g, idx)                                                               GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 20, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_ACK_SEQ_WRITE_G(v, g, idx)                                                              GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 20, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_ACK_SEQ_READ_CORE(r, g, idx, core_id)                                                   CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 20, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_ACK_SEQ_WRITE_CORE(v, g, idx, core_id)                                                  CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 20, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_ACK_SEQ_READ(r, p)                                                                      MREAD_32((uint8_t *)(p) + 20, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_ACK_SEQ_WRITE(v, p)                                                                     MWRITE_32((uint8_t *)(p) + 20, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_TX_SEQ_READ_G(r, g, idx)                                                                GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 24, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_TX_SEQ_WRITE_G(v, g, idx)                                                               GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 24, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_TX_SEQ_READ_CORE(r, g, idx, core_id)                                                    CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 24, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_TX_SEQ_WRITE_CORE(v, g, idx, core_id)                                                   CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 24, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_TX_SEQ_READ(r, p)                                                                       MREAD_32((uint8_t *)(p) + 24, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_TX_SEQ_WRITE(v, p)                                                                      MWRITE_32((uint8_t *)(p) + 24, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_BAD_PKTS_READ_G(r, g, idx)                                                              GROUP_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 28, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_BAD_PKTS_WRITE_G(v, g, idx)                                                             GROUP_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 28, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_BAD_PKTS_READ_CORE(r, g, idx, core_id)                                                  CORE_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 28, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_BAD_PKTS_WRITE_CORE(v, g, idx, core_id)                                                 CORE_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 28, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_BAD_PKTS_READ(r, p)                                                                     MREAD_16((uint8_t *)(p) + 28, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_BAD_PKTS_WRITE(v, p)                                                                    MWRITE_16((uint8_t *)(p) + 28, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_SRC_PORT_READ_G(r, g, idx)                                                              GROUP_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 30, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_SRC_PORT_WRITE_G(v, g, idx)                                                             GROUP_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 30, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_SRC_PORT_READ_CORE(r, g, idx, core_id)                                                  CORE_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 30, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_SRC_PORT_WRITE_CORE(v, g, idx, core_id)                                                 CORE_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 30, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_SRC_PORT_READ(r, p)                                                                     MREAD_16((uint8_t *)(p) + 30, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_SRC_PORT_WRITE(v, p)                                                                    MWRITE_16((uint8_t *)(p) + 30, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_RX_BYTES_READ_G(r, g, idx)                                                              GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 32, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_RX_BYTES_WRITE_G(v, g, idx)                                                             GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 32, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_RX_BYTES_READ_CORE(r, g, idx, core_id)                                                  CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 32, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_RX_BYTES_WRITE_CORE(v, g, idx, core_id)                                                 CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 32, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_RX_BYTES_READ(r, p)                                                                     MREAD_32((uint8_t *)(p) + 32, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_RX_BYTES_WRITE(v, p)                                                                    MWRITE_32((uint8_t *)(p) + 32, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_RX_BYTES_1_READ_G(r, g, idx)                                                            GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 36, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_RX_BYTES_1_WRITE_G(v, g, idx)                                                           GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 36, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_RX_BYTES_1_READ_CORE(r, g, idx, core_id)                                                CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 36, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_RX_BYTES_1_WRITE_CORE(v, g, idx, core_id)                                               CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 36, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_RX_BYTES_1_READ(r, p)                                                                   MREAD_32((uint8_t *)(p) + 36, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_RX_BYTES_1_WRITE(v, p)                                                                  MWRITE_32((uint8_t *)(p) + 36, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_EXPECTED_BYTES_READ_G(r, g, idx)                                                        GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 40, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_EXPECTED_BYTES_WRITE_G(v, g, idx)                                                       GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 40, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_EXPECTED_BYTES_READ_CORE(r, g, idx, core_id)                                            CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 40, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_EXPECTED_BYTES_WRITE_CORE(v, g, idx, core_id)                                           CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 40, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_EXPECTED_BYTES_READ(r, p)                                                               MREAD_32((uint8_t *)(p) + 40, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_EXPECTED_BYTES_WRITE(v, p)                                                              MWRITE_32((uint8_t *)(p) + 40, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_EXPECTED_BYTES_1_READ_G(r, g, idx)                                                      GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 44, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_EXPECTED_BYTES_1_WRITE_G(v, g, idx)                                                     GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 44, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_EXPECTED_BYTES_1_READ_CORE(r, g, idx, core_id)                                          CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 44, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_EXPECTED_BYTES_1_WRITE_CORE(v, g, idx, core_id)                                         CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 44, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_EXPECTED_BYTES_1_READ(r, p)                                                             MREAD_32((uint8_t *)(p) + 44, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_EXPECTED_BYTES_1_WRITE(v, p)                                                            MWRITE_32((uint8_t *)(p) + 44, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_TO_SEND_BYTES_READ_G(r, g, idx)                                                      GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 48, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_TO_SEND_BYTES_WRITE_G(v, g, idx)                                                     GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 48, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_TO_SEND_BYTES_READ_CORE(r, g, idx, core_id)                                          CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 48, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_TO_SEND_BYTES_WRITE_CORE(v, g, idx, core_id)                                         CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 48, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_TO_SEND_BYTES_READ(r, p)                                                             MREAD_32((uint8_t *)(p) + 48, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_TO_SEND_BYTES_WRITE(v, p)                                                            MWRITE_32((uint8_t *)(p) + 48, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_TO_SEND_BYTES_1_READ_G(r, g, idx)                                                    GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 52, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_TO_SEND_BYTES_1_WRITE_G(v, g, idx)                                                   GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 52, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_TO_SEND_BYTES_1_READ_CORE(r, g, idx, core_id)                                        CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 52, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_TO_SEND_BYTES_1_WRITE_CORE(v, g, idx, core_id)                                       CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 52, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_TO_SEND_BYTES_1_READ(r, p)                                                           MREAD_32((uint8_t *)(p) + 52, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_TO_SEND_BYTES_1_WRITE(v, p)                                                          MWRITE_32((uint8_t *)(p) + 52, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_NO_DISPATCHER_CREDITS_READ_G(r, g, idx)                                                 GROUP_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 56, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_NO_DISPATCHER_CREDITS_WRITE_G(v, g, idx)                                                GROUP_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 56, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_NO_DISPATCHER_CREDITS_READ_CORE(r, g, idx, core_id)                                     CORE_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 56, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_NO_DISPATCHER_CREDITS_WRITE_CORE(v, g, idx, core_id)                                    CORE_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 56, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_NO_DISPATCHER_CREDITS_READ(r, p)                                                        MREAD_16((uint8_t *)(p) + 56, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_NO_DISPATCHER_CREDITS_WRITE(v, p)                                                       MWRITE_16((uint8_t *)(p) + 56, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_NO_PKTGEN_TX_CREDITS_READ_G(r, g, idx)                                                  GROUP_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 58, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_NO_PKTGEN_TX_CREDITS_WRITE_G(v, g, idx)                                                 GROUP_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 58, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_NO_PKTGEN_TX_CREDITS_READ_CORE(r, g, idx, core_id)                                      CORE_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 58, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_NO_PKTGEN_TX_CREDITS_WRITE_CORE(v, g, idx, core_id)                                     CORE_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 58, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_NO_PKTGEN_TX_CREDITS_READ(r, p)                                                         MREAD_16((uint8_t *)(p) + 58, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_NO_PKTGEN_TX_CREDITS_WRITE(v, p)                                                        MWRITE_16((uint8_t *)(p) + 58, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_CWND_READ_G(r, g, idx)                                                               GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 60, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_CWND_WRITE_G(v, g, idx)                                                              GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 60, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_CWND_READ_CORE(r, g, idx, core_id)                                                   CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 60, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_CWND_WRITE_CORE(v, g, idx, core_id)                                                  CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 60, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_CWND_READ(r, p)                                                                      MREAD_32((uint8_t *)(p) + 60, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_CWND_WRITE(v, p)                                                                     MWRITE_32((uint8_t *)(p) + 60, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_CWND_THR_READ_G(r, g, idx)                                                           GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 64, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_CWND_THR_WRITE_G(v, g, idx)                                                          GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 64, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_CWND_THR_READ_CORE(r, g, idx, core_id)                                               CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 64, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_CWND_THR_WRITE_CORE(v, g, idx, core_id)                                              CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 64, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_CWND_THR_READ(r, p)                                                                  MREAD_32((uint8_t *)(p) + 64, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_CWND_THR_WRITE(v, p)                                                                 MWRITE_32((uint8_t *)(p) + 64, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_CWND_INITIAL_READ_G(r, g, idx)                                                       GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 68, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_CWND_INITIAL_WRITE_G(v, g, idx)                                                      GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 68, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_CWND_INITIAL_READ_CORE(r, g, idx, core_id)                                           CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 68, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_CWND_INITIAL_WRITE_CORE(v, g, idx, core_id)                                          CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 68, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_CWND_INITIAL_READ(r, p)                                                              MREAD_32((uint8_t *)(p) + 68, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_CWND_INITIAL_WRITE(v, p)                                                             MWRITE_32((uint8_t *)(p) + 68, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_CWND_MAX_READ_G(r, g, idx)                                                           GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 72, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_CWND_MAX_WRITE_G(v, g, idx)                                                          GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 72, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_CWND_MAX_READ_CORE(r, g, idx, core_id)                                               CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 72, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_CWND_MAX_WRITE_CORE(v, g, idx, core_id)                                              CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 72, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_CWND_MAX_READ(r, p)                                                                  MREAD_32((uint8_t *)(p) + 72, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_CWND_MAX_WRITE(v, p)                                                                 MWRITE_32((uint8_t *)(p) + 72, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_CWND_BUDGET_READ_G(r, g, idx)                                                        GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 76, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_CWND_BUDGET_WRITE_G(v, g, idx)                                                       GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 76, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_CWND_BUDGET_READ_CORE(r, g, idx, core_id)                                            CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 76, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_CWND_BUDGET_WRITE_CORE(v, g, idx, core_id)                                           CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 76, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_CWND_BUDGET_READ(r, p)                                                               MREAD_32((uint8_t *)(p) + 76, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_CWND_BUDGET_WRITE(v, p)                                                              MWRITE_32((uint8_t *)(p) + 76, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_LAST_ACK_SEQ_READ_G(r, g, idx)                                                       GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 80, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_LAST_ACK_SEQ_WRITE_G(v, g, idx)                                                      GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 80, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_LAST_ACK_SEQ_READ_CORE(r, g, idx, core_id)                                           CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 80, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_LAST_ACK_SEQ_WRITE_CORE(v, g, idx, core_id)                                          CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 80, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_LAST_ACK_SEQ_READ(r, p)                                                              MREAD_32((uint8_t *)(p) + 80, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_LAST_ACK_SEQ_WRITE(v, p)                                                             MWRITE_32((uint8_t *)(p) + 80, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_LAST_ACK_TIME_READ_G(r, g, idx)                                                      GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 84, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_LAST_ACK_TIME_WRITE_G(v, g, idx)                                                     GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 84, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_LAST_ACK_TIME_READ_CORE(r, g, idx, core_id)                                          CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 84, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_LAST_ACK_TIME_WRITE_CORE(v, g, idx, core_id)                                         CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 84, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_LAST_ACK_TIME_READ(r, p)                                                             MREAD_32((uint8_t *)(p) + 84, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_LAST_ACK_TIME_WRITE(v, p)                                                            MWRITE_32((uint8_t *)(p) + 84, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_SACK_BYTES_READ_G(r, g, idx)                                                         GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 88, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_SACK_BYTES_WRITE_G(v, g, idx)                                                        GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 88, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_SACK_BYTES_READ_CORE(r, g, idx, core_id)                                             CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 88, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_SACK_BYTES_WRITE_CORE(v, g, idx, core_id)                                            CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 88, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_SACK_BYTES_READ(r, p)                                                                MREAD_32((uint8_t *)(p) + 88, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_SACK_BYTES_WRITE(v, p)                                                               MWRITE_32((uint8_t *)(p) + 88, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_FAST_RETRANS_TRIG_CNT_READ_G(r, g, idx)                                              GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 92, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_FAST_RETRANS_TRIG_CNT_WRITE_G(v, g, idx)                                             GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 92, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_FAST_RETRANS_TRIG_CNT_READ_CORE(r, g, idx, core_id)                                  CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 92, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_FAST_RETRANS_TRIG_CNT_WRITE_CORE(v, g, idx, core_id)                                 CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 92, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_FAST_RETRANS_TRIG_CNT_READ(r, p)                                                     MREAD_32((uint8_t *)(p) + 92, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_FAST_RETRANS_TRIG_CNT_WRITE(v, p)                                                    MWRITE_32((uint8_t *)(p) + 92, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_DUP_ACK_CNT_READ_G(r, g, idx)                                                        GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 96, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_DUP_ACK_CNT_WRITE_G(v, g, idx)                                                       GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 96, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_DUP_ACK_CNT_READ_CORE(r, g, idx, core_id)                                            CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 96, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_DUP_ACK_CNT_WRITE_CORE(v, g, idx, core_id)                                           CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 96, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_DUP_ACK_CNT_READ(r, p)                                                               MREAD_32((uint8_t *)(p) + 96, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_DUP_ACK_CNT_WRITE(v, p)                                                              MWRITE_32((uint8_t *)(p) + 96, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_DUP_ACK_SEQ_DONE_READ_G(r, g, idx)                                                   GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 100, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_DUP_ACK_SEQ_DONE_WRITE_G(v, g, idx)                                                  GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 100, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_DUP_ACK_SEQ_DONE_READ_CORE(r, g, idx, core_id)                                       CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 100, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_DUP_ACK_SEQ_DONE_WRITE_CORE(v, g, idx, core_id)                                      CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 100, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_DUP_ACK_SEQ_DONE_READ(r, p)                                                          MREAD_32((uint8_t *)(p) + 100, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_DUP_ACK_SEQ_DONE_WRITE(v, p)                                                         MWRITE_32((uint8_t *)(p) + 100, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_DUP_ACK_TOTAL_PKTS_CNT_READ_G(r, g, idx)                                             GROUP_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 104, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_DUP_ACK_TOTAL_PKTS_CNT_WRITE_G(v, g, idx)                                            GROUP_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 104, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_DUP_ACK_TOTAL_PKTS_CNT_READ_CORE(r, g, idx, core_id)                                 CORE_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 104, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_DUP_ACK_TOTAL_PKTS_CNT_WRITE_CORE(v, g, idx, core_id)                                CORE_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 104, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_DUP_ACK_TOTAL_PKTS_CNT_READ(r, p)                                                    MREAD_16((uint8_t *)(p) + 104, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_DUP_ACK_TOTAL_PKTS_CNT_WRITE(v, p)                                                   MWRITE_16((uint8_t *)(p) + 104, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_FAST_RETRANS_CNT_READ_G(r, g, idx)                                                   GROUP_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 106, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_FAST_RETRANS_CNT_WRITE_G(v, g, idx)                                                  GROUP_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 106, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_FAST_RETRANS_CNT_READ_CORE(r, g, idx, core_id)                                       CORE_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 106, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_FAST_RETRANS_CNT_WRITE_CORE(v, g, idx, core_id)                                      CORE_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 106, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_FAST_RETRANS_CNT_READ(r, p)                                                          MREAD_16((uint8_t *)(p) + 106, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_FAST_RETRANS_CNT_WRITE(v, p)                                                         MWRITE_16((uint8_t *)(p) + 106, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_ERR_DN_PKT_CNT_READ_G(r, g, idx)                                                     GROUP_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 108, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_ERR_DN_PKT_CNT_WRITE_G(v, g, idx)                                                    GROUP_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 108, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_ERR_DN_PKT_CNT_READ_CORE(r, g, idx, core_id)                                         CORE_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 108, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_ERR_DN_PKT_CNT_WRITE_CORE(v, g, idx, core_id)                                        CORE_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 108, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_ERR_DN_PKT_CNT_READ(r, p)                                                            MREAD_8((uint8_t *)(p) + 108, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_ERR_DN_PKT_CNT_WRITE(v, p)                                                           MWRITE_8((uint8_t *)(p) + 108, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_DN_ERR_UP_PKT_CNT_READ_G(r, g, idx)                                                     GROUP_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 109, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_DN_ERR_UP_PKT_CNT_WRITE_G(v, g, idx)                                                    GROUP_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 109, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_DN_ERR_UP_PKT_CNT_READ_CORE(r, g, idx, core_id)                                         CORE_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 109, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_DN_ERR_UP_PKT_CNT_WRITE_CORE(v, g, idx, core_id)                                        CORE_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 109, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_DN_ERR_UP_PKT_CNT_READ(r, p)                                                            MREAD_8((uint8_t *)(p) + 109, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_DN_ERR_UP_PKT_CNT_WRITE(v, p)                                                           MWRITE_8((uint8_t *)(p) + 109, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_CWND_RTT_FACTOR_READ_G(r, g, idx)                                                    GROUP_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 110, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_CWND_RTT_FACTOR_WRITE_G(v, g, idx)                                                   GROUP_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 110, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_CWND_RTT_FACTOR_READ_CORE(r, g, idx, core_id)                                        CORE_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 110, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_CWND_RTT_FACTOR_WRITE_CORE(v, g, idx, core_id)                                       CORE_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 110, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_CWND_RTT_FACTOR_READ(r, p)                                                           MREAD_8((uint8_t *)(p) + 110, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_CWND_RTT_FACTOR_WRITE(v, p)                                                          MWRITE_8((uint8_t *)(p) + 110, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_ERR_DST_PORT_CNT_READ_G(r, g, idx)                                                      GROUP_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 111, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_ERR_DST_PORT_CNT_WRITE_G(v, g, idx)                                                     GROUP_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 111, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_ERR_DST_PORT_CNT_READ_CORE(r, g, idx, core_id)                                          CORE_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 111, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_ERR_DST_PORT_CNT_WRITE_CORE(v, g, idx, core_id)                                         CORE_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 111, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_ERR_DST_PORT_CNT_READ(r, p)                                                             MREAD_8((uint8_t *)(p) + 111, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_ERR_DST_PORT_CNT_WRITE(v, p)                                                            MWRITE_8((uint8_t *)(p) + 111, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_DYNACK_BYTES_THR_READ_G(r, g, idx)                                                      GROUP_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 112, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_DYNACK_BYTES_THR_WRITE_G(v, g, idx)                                                     GROUP_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 112, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_DYNACK_BYTES_THR_READ_CORE(r, g, idx, core_id)                                          CORE_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 112, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_DYNACK_BYTES_THR_WRITE_CORE(v, g, idx, core_id)                                         CORE_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 112, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_DYNACK_BYTES_THR_READ(r, p)                                                             MREAD_16((uint8_t *)(p) + 112, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_DYNACK_BYTES_THR_WRITE(v, p)                                                            MWRITE_16((uint8_t *)(p) + 112, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_DYNACK_BYTES_THR_CNT_READ_G(r, g, idx)                                                  GROUP_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 114, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_DYNACK_BYTES_THR_CNT_WRITE_G(v, g, idx)                                                 GROUP_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 114, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_DYNACK_BYTES_THR_CNT_READ_CORE(r, g, idx, core_id)                                      CORE_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 114, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_DYNACK_BYTES_THR_CNT_WRITE_CORE(v, g, idx, core_id)                                     CORE_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 114, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_DYNACK_BYTES_THR_CNT_READ(r, p)                                                         MREAD_16((uint8_t *)(p) + 114, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_DYNACK_BYTES_THR_CNT_WRITE(v, p)                                                        MWRITE_16((uint8_t *)(p) + 114, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_DYNACK_THR_UPD_RATE_READ_G(r, g, idx)                                                   GROUP_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 116, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_DYNACK_THR_UPD_RATE_WRITE_G(v, g, idx)                                                  GROUP_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 116, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_DYNACK_THR_UPD_RATE_READ_CORE(r, g, idx, core_id)                                       CORE_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 116, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_DYNACK_THR_UPD_RATE_WRITE_CORE(v, g, idx, core_id)                                      CORE_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 116, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_DYNACK_THR_UPD_RATE_READ(r, p)                                                          MREAD_8((uint8_t *)(p) + 116, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_DYNACK_THR_UPD_RATE_WRITE(v, p)                                                         MWRITE_8((uint8_t *)(p) + 116, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_DYNACK_THR_UPD_RATE_CNT_READ_G(r, g, idx)                                               GROUP_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 117, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_DYNACK_THR_UPD_RATE_CNT_WRITE_G(v, g, idx)                                              GROUP_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 117, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_DYNACK_THR_UPD_RATE_CNT_READ_CORE(r, g, idx, core_id)                                   CORE_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 117, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_DYNACK_THR_UPD_RATE_CNT_WRITE_CORE(v, g, idx, core_id)                                  CORE_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 117, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_DYNACK_THR_UPD_RATE_CNT_READ(r, p)                                                      MREAD_8((uint8_t *)(p) + 117, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_DYNACK_THR_UPD_RATE_CNT_WRITE(v, p)                                                     MWRITE_8((uint8_t *)(p) + 117, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_DUP_ACK_STATE_READ_G(r, g, idx)                                                      GROUP_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 118, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_DUP_ACK_STATE_WRITE_G(v, g, idx)                                                     GROUP_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 118, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_DUP_ACK_STATE_READ_CORE(r, g, idx, core_id)                                          CORE_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 118, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_DUP_ACK_STATE_WRITE_CORE(v, g, idx, core_id)                                         CORE_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 118, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_DUP_ACK_STATE_READ(r, p)                                                             MREAD_8((uint8_t *)(p) + 118, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_DUP_ACK_STATE_WRITE(v, p)                                                            MWRITE_8((uint8_t *)(p) + 118, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_RESERVED2_READ_G(r, g, idx)                                                             GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 119, 6, 2, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_RESERVED2_WRITE_G(v, g, idx)                                                            GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 119, 6, 2, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_RESERVED2_READ_CORE(r, g, idx, core_id)                                                 CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 119, 6, 2, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_RESERVED2_WRITE_CORE(v, g, idx, core_id)                                                CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 119, 6, 2, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_RESERVED2_READ(r, p)                                                                    RDP_FIELD_MREAD_8((uint8_t *)(p) + 119, 6, 2, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_RESERVED2_WRITE(v, p)                                                                   RDP_FIELD_MWRITE_8((uint8_t *)(p) + 119, 6, 2, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_DN_IS_PKT_DROP_DRIVER_WAKEUP_READ_G(r, g, idx)                                          GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 119, 5, 1, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_DN_IS_PKT_DROP_DRIVER_WAKEUP_WRITE_G(v, g, idx)                                         GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 119, 5, 1, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_DN_IS_PKT_DROP_DRIVER_WAKEUP_READ_CORE(r, g, idx, core_id)                              CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 119, 5, 1, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_DN_IS_PKT_DROP_DRIVER_WAKEUP_WRITE_CORE(v, g, idx, core_id)                             CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 119, 5, 1, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_DN_IS_PKT_DROP_DRIVER_WAKEUP_READ(r, p)                                                 RDP_FIELD_MREAD_8((uint8_t *)(p) + 119, 5, 1, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_DN_IS_PKT_DROP_DRIVER_WAKEUP_WRITE(v, p)                                                RDP_FIELD_MWRITE_8((uint8_t *)(p) + 119, 5, 1, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_DN_IS_PKT_DROP_FORCE_ACK_READ_G(r, g, idx)                                              GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 119, 4, 1, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_DN_IS_PKT_DROP_FORCE_ACK_WRITE_G(v, g, idx)                                             GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 119, 4, 1, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_DN_IS_PKT_DROP_FORCE_ACK_READ_CORE(r, g, idx, core_id)                                  CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 119, 4, 1, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_DN_IS_PKT_DROP_FORCE_ACK_WRITE_CORE(v, g, idx, core_id)                                 CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 119, 4, 1, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_DN_IS_PKT_DROP_FORCE_ACK_READ(r, p)                                                     RDP_FIELD_MREAD_8((uint8_t *)(p) + 119, 4, 1, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_DN_IS_PKT_DROP_FORCE_ACK_WRITE(v, p)                                                    RDP_FIELD_MWRITE_8((uint8_t *)(p) + 119, 4, 1, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_IS_RX_WIN_STOP_READ_G(r, g, idx)                                                     GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 119, 3, 1, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_IS_RX_WIN_STOP_WRITE_G(v, g, idx)                                                    GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 119, 3, 1, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_IS_RX_WIN_STOP_READ_CORE(r, g, idx, core_id)                                         CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 119, 3, 1, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_IS_RX_WIN_STOP_WRITE_CORE(v, g, idx, core_id)                                        CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 119, 3, 1, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_IS_RX_WIN_STOP_READ(r, p)                                                            RDP_FIELD_MREAD_8((uint8_t *)(p) + 119, 3, 1, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_IS_RX_WIN_STOP_WRITE(v, p)                                                           RDP_FIELD_MWRITE_8((uint8_t *)(p) + 119, 3, 1, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_IS_TIMEOUT_READ_G(r, g, idx)                                                         GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 119, 2, 1, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_IS_TIMEOUT_WRITE_G(v, g, idx)                                                        GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 119, 2, 1, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_IS_TIMEOUT_READ_CORE(r, g, idx, core_id)                                             CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 119, 2, 1, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_IS_TIMEOUT_WRITE_CORE(v, g, idx, core_id)                                            CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 119, 2, 1, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_IS_TIMEOUT_READ(r, p)                                                                RDP_FIELD_MREAD_8((uint8_t *)(p) + 119, 2, 1, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_IS_TIMEOUT_WRITE(v, p)                                                               RDP_FIELD_MWRITE_8((uint8_t *)(p) + 119, 2, 1, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_IS_STREAM_ACTIVE_READ_G(r, g, idx)                                                      GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 119, 1, 1, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_IS_STREAM_ACTIVE_WRITE_G(v, g, idx)                                                     GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 119, 1, 1, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_IS_STREAM_ACTIVE_READ_CORE(r, g, idx, core_id)                                          CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 119, 1, 1, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_IS_STREAM_ACTIVE_WRITE_CORE(v, g, idx, core_id)                                         CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 119, 1, 1, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_IS_STREAM_ACTIVE_READ(r, p)                                                             RDP_FIELD_MREAD_8((uint8_t *)(p) + 119, 1, 1, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_IS_STREAM_ACTIVE_WRITE(v, p)                                                            RDP_FIELD_MWRITE_8((uint8_t *)(p) + 119, 1, 1, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_IS_UPLOAD_READ_G(r, g, idx)                                                             GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 119, 0, 1, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_IS_UPLOAD_WRITE_G(v, g, idx)                                                            GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 119, 0, 1, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_IS_UPLOAD_READ_CORE(r, g, idx, core_id)                                                 CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 119, 0, 1, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_IS_UPLOAD_WRITE_CORE(v, g, idx, core_id)                                                CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 119, 0, 1, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_IS_UPLOAD_READ(r, p)                                                                    RDP_FIELD_MREAD_8((uint8_t *)(p) + 119, 0, 1, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_IS_UPLOAD_WRITE(v, p)                                                                   RDP_FIELD_MWRITE_8((uint8_t *)(p) + 119, 0, 1, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_DROP_STATE_READ_G(r, g, idx)                                                       GROUP_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 120, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_DROP_STATE_WRITE_G(v, g, idx)                                                      GROUP_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 120, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_DROP_STATE_READ_CORE(r, g, idx, core_id)                                           CORE_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 120, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_DROP_STATE_WRITE_CORE(v, g, idx, core_id)                                          CORE_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 120, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_DROP_STATE_READ(r, p)                                                              MREAD_8((uint8_t *)(p) + 120, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_DROP_STATE_WRITE(v, p)                                                             MWRITE_8((uint8_t *)(p) + 120, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_IS_WIN_FULL_READ_G(r, g, idx)                                                      GROUP_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 121, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_IS_WIN_FULL_WRITE_G(v, g, idx)                                                     GROUP_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 121, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_IS_WIN_FULL_READ_CORE(r, g, idx, core_id)                                          CORE_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 121, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_IS_WIN_FULL_WRITE_CORE(v, g, idx, core_id)                                         CORE_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 121, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_IS_WIN_FULL_READ(r, p)                                                             MREAD_8((uint8_t *)(p) + 121, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_IS_WIN_FULL_WRITE(v, p)                                                            MWRITE_8((uint8_t *)(p) + 121, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_NUM_ERRS_READ_G(r, g, idx)                                                         GROUP_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 122, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_NUM_ERRS_WRITE_G(v, g, idx)                                                        GROUP_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 122, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_NUM_ERRS_READ_CORE(r, g, idx, core_id)                                             CORE_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 122, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_NUM_ERRS_WRITE_CORE(v, g, idx, core_id)                                            CORE_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 122, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_NUM_ERRS_READ(r, p)                                                                MREAD_16((uint8_t *)(p) + 122, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_NUM_ERRS_WRITE(v, p)                                                               MWRITE_16((uint8_t *)(p) + 122, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_WR_OFS_READ_G(r, g, idx)                                                           GROUP_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 124, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_WR_OFS_WRITE_G(v, g, idx)                                                          GROUP_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 124, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_WR_OFS_READ_CORE(r, g, idx, core_id)                                               CORE_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 124, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_WR_OFS_WRITE_CORE(v, g, idx, core_id)                                              CORE_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 124, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_WR_OFS_READ(r, p)                                                                  MREAD_16((uint8_t *)(p) + 124, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_WR_OFS_WRITE(v, p)                                                                 MWRITE_16((uint8_t *)(p) + 124, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_RD_OFS_READ_G(r, g, idx)                                                           GROUP_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 126, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_RD_OFS_WRITE_G(v, g, idx)                                                          GROUP_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 126, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_RD_OFS_READ_CORE(r, g, idx, core_id)                                               CORE_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 126, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_RD_OFS_WRITE_CORE(v, g, idx, core_id)                                              CORE_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 126, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_RD_OFS_READ(r, p)                                                                  MREAD_16((uint8_t *)(p) + 126, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_RD_OFS_WRITE(v, p)                                                                 MWRITE_16((uint8_t *)(p) + 126, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_ACK_SEQ_ERR_START_READ_G(r, g, idx)                                                GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 128, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_ACK_SEQ_ERR_START_WRITE_G(v, g, idx)                                               GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 128, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_ACK_SEQ_ERR_START_READ_CORE(r, g, idx, core_id)                                    CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 128, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_ACK_SEQ_ERR_START_WRITE_CORE(v, g, idx, core_id)                                   CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 128, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_ACK_SEQ_ERR_START_READ(r, p)                                                       MREAD_32((uint8_t *)(p) + 128, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_ACK_SEQ_ERR_START_WRITE(v, p)                                                      MWRITE_32((uint8_t *)(p) + 128, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RX_L4_SEQ_READ_G(r, g, idx)                                                  GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 132, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RX_L4_SEQ_WRITE_G(v, g, idx)                                                 GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 132, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RX_L4_SEQ_READ_CORE(r, g, idx, core_id)                                      CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 132, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RX_L4_SEQ_WRITE_CORE(v, g, idx, core_id)                                     CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 132, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RX_L4_SEQ_READ(r, p)                                                         MREAD_32((uint8_t *)(p) + 132, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RX_L4_SEQ_WRITE(v, p)                                                        MWRITE_32((uint8_t *)(p) + 132, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RING_RD_WR_OFS_READ_G(r, g, idx)                                             GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 136, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RING_RD_WR_OFS_WRITE_G(v, g, idx)                                            GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 136, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RING_RD_WR_OFS_READ_CORE(r, g, idx, core_id)                                 CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 136, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RING_RD_WR_OFS_WRITE_CORE(v, g, idx, core_id)                                CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 136, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RING_RD_WR_OFS_READ(r, p)                                                    MREAD_32((uint8_t *)(p) + 136, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RING_RD_WR_OFS_WRITE(v, p)                                                   MWRITE_32((uint8_t *)(p) + 136, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RING_RD_WR_OFS_1_READ_G(r, g, idx)                                           GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 140, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RING_RD_WR_OFS_1_WRITE_G(v, g, idx)                                          GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 140, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RING_RD_WR_OFS_1_READ_CORE(r, g, idx, core_id)                               CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 140, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RING_RD_WR_OFS_1_WRITE_CORE(v, g, idx, core_id)                              CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 140, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RING_RD_WR_OFS_1_READ(r, p)                                                  MREAD_32((uint8_t *)(p) + 140, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RING_RD_WR_OFS_1_WRITE(v, p)                                                 MWRITE_32((uint8_t *)(p) + 140, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RX_L3_HDR_LEN_READ_G(r, g, idx)                                              GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 144, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RX_L3_HDR_LEN_WRITE_G(v, g, idx)                                             GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 144, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RX_L3_HDR_LEN_READ_CORE(r, g, idx, core_id)                                  CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 144, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RX_L3_HDR_LEN_WRITE_CORE(v, g, idx, core_id)                                 CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 144, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RX_L3_HDR_LEN_READ(r, p)                                                     MREAD_32((uint8_t *)(p) + 144, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RX_L3_HDR_LEN_WRITE(v, p)                                                    MWRITE_32((uint8_t *)(p) + 144, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RX_L3_PAYLOAD_LEN_READ_G(r, g, idx)                                          GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 148, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RX_L3_PAYLOAD_LEN_WRITE_G(v, g, idx)                                         GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 148, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RX_L3_PAYLOAD_LEN_READ_CORE(r, g, idx, core_id)                              CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 148, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RX_L3_PAYLOAD_LEN_WRITE_CORE(v, g, idx, core_id)                             CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 148, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RX_L3_PAYLOAD_LEN_READ(r, p)                                                 MREAD_32((uint8_t *)(p) + 148, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RX_L3_PAYLOAD_LEN_WRITE(v, p)                                                MWRITE_32((uint8_t *)(p) + 148, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_PACKET_DESCRIPTOR_0_READ_G(r, g, idx)                                        GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 152, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_PACKET_DESCRIPTOR_0_WRITE_G(v, g, idx)                                       GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 152, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_PACKET_DESCRIPTOR_0_READ_CORE(r, g, idx, core_id)                            CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 152, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_PACKET_DESCRIPTOR_0_WRITE_CORE(v, g, idx, core_id)                           CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 152, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_PACKET_DESCRIPTOR_0_READ(r, p)                                               MREAD_32((uint8_t *)(p) + 152, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_PACKET_DESCRIPTOR_0_WRITE(v, p)                                              MWRITE_32((uint8_t *)(p) + 152, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_PACKET_DESCRIPTOR_0_1_READ_G(r, g, idx)                                      GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 156, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_PACKET_DESCRIPTOR_0_1_WRITE_G(v, g, idx)                                     GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 156, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_PACKET_DESCRIPTOR_0_1_READ_CORE(r, g, idx, core_id)                          CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 156, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_PACKET_DESCRIPTOR_0_1_WRITE_CORE(v, g, idx, core_id)                         CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 156, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_PACKET_DESCRIPTOR_0_1_READ(r, p)                                             MREAD_32((uint8_t *)(p) + 156, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_PACKET_DESCRIPTOR_0_1_WRITE(v, p)                                            MWRITE_32((uint8_t *)(p) + 156, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_PACKET_DESCRIPTOR_2_READ_G(r, g, idx)                                        GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 160, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_PACKET_DESCRIPTOR_2_WRITE_G(v, g, idx)                                       GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 160, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_PACKET_DESCRIPTOR_2_READ_CORE(r, g, idx, core_id)                            CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 160, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_PACKET_DESCRIPTOR_2_WRITE_CORE(v, g, idx, core_id)                           CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 160, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_PACKET_DESCRIPTOR_2_READ(r, p)                                               MREAD_32((uint8_t *)(p) + 160, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_PACKET_DESCRIPTOR_2_WRITE(v, p)                                              MWRITE_32((uint8_t *)(p) + 160, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_PACKET_DESCRIPTOR_2_1_READ_G(r, g, idx)                                      GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 164, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_PACKET_DESCRIPTOR_2_1_WRITE_G(v, g, idx)                                     GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 164, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_PACKET_DESCRIPTOR_2_1_READ_CORE(r, g, idx, core_id)                          CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 164, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_PACKET_DESCRIPTOR_2_1_WRITE_CORE(v, g, idx, core_id)                         CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 164, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_PACKET_DESCRIPTOR_2_1_READ(r, p)                                             MREAD_32((uint8_t *)(p) + 164, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_PACKET_DESCRIPTOR_2_1_WRITE(v, p)                                            MWRITE_32((uint8_t *)(p) + 164, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_ADDR_LOW_READ_G(r, g, idx)                                                  GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 168, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_ADDR_LOW_WRITE_G(v, g, idx)                                                 GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 168, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_ADDR_LOW_READ_CORE(r, g, idx, core_id)                                      CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 168, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_ADDR_LOW_WRITE_CORE(v, g, idx, core_id)                                     CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 168, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_ADDR_LOW_READ(r, p)                                                         MREAD_32((uint8_t *)(p) + 168, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_ADDR_LOW_WRITE(v, p)                                                        MWRITE_32((uint8_t *)(p) + 168, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_ADDR_HIGH_READ_G(r, g, idx)                                                 GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 172, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_ADDR_HIGH_WRITE_G(v, g, idx)                                                GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 172, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_ADDR_HIGH_READ_CORE(r, g, idx, core_id)                                     CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 172, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_ADDR_HIGH_WRITE_CORE(v, g, idx, core_id)                                    CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 172, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_ADDR_HIGH_READ(r, p)                                                        MREAD_32((uint8_t *)(p) + 172, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_ADDR_HIGH_WRITE(v, p)                                                       MWRITE_32((uint8_t *)(p) + 172, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_SEND_CNT_READ_G(r, g, idx)                                                  GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 176, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_SEND_CNT_WRITE_G(v, g, idx)                                                 GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 176, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_SEND_CNT_READ_CORE(r, g, idx, core_id)                                      CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 176, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_SEND_CNT_WRITE_CORE(v, g, idx, core_id)                                     CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 176, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_SEND_CNT_READ(r, p)                                                         MREAD_32((uint8_t *)(p) + 176, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_SEND_CNT_WRITE(v, p)                                                        MWRITE_32((uint8_t *)(p) + 176, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_DROP_CNT_READ_G(r, g, idx)                                                  GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 180, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_DROP_CNT_WRITE_G(v, g, idx)                                                 GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 180, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_DROP_CNT_READ_CORE(r, g, idx, core_id)                                      CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 180, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_DROP_CNT_WRITE_CORE(v, g, idx, core_id)                                     CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 180, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_DROP_CNT_READ(r, p)                                                         MREAD_32((uint8_t *)(p) + 180, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_DROP_CNT_WRITE(v, p)                                                        MWRITE_32((uint8_t *)(p) + 180, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_RTO_RETRANS_ADDR_LOW_READ_G(r, g, idx)                                                 GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 184, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_RTO_RETRANS_ADDR_LOW_WRITE_G(v, g, idx)                                                GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 184, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_RTO_RETRANS_ADDR_LOW_READ_CORE(r, g, idx, core_id)                                     CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 184, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_RTO_RETRANS_ADDR_LOW_WRITE_CORE(v, g, idx, core_id)                                    CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 184, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_RTO_RETRANS_ADDR_LOW_READ(r, p)                                                        MREAD_32((uint8_t *)(p) + 184, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_RTO_RETRANS_ADDR_LOW_WRITE(v, p)                                                       MWRITE_32((uint8_t *)(p) + 184, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_RTO_RETRANS_ADDR_HIGH_READ_G(r, g, idx)                                                GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 188, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_RTO_RETRANS_ADDR_HIGH_WRITE_G(v, g, idx)                                               GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 188, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_RTO_RETRANS_ADDR_HIGH_READ_CORE(r, g, idx, core_id)                                    CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 188, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_RTO_RETRANS_ADDR_HIGH_WRITE_CORE(v, g, idx, core_id)                                   CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 188, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_RTO_RETRANS_ADDR_HIGH_READ(r, p)                                                       MREAD_32((uint8_t *)(p) + 188, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_RTO_RETRANS_ADDR_HIGH_WRITE(v, p)                                                      MWRITE_32((uint8_t *)(p) + 188, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_SACK_OPT_ADDR_LOW_READ_G(r, g, idx)                                                    GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 192, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_SACK_OPT_ADDR_LOW_WRITE_G(v, g, idx)                                                   GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 192, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_SACK_OPT_ADDR_LOW_READ_CORE(r, g, idx, core_id)                                        CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 192, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_SACK_OPT_ADDR_LOW_WRITE_CORE(v, g, idx, core_id)                                       CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 192, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_SACK_OPT_ADDR_LOW_READ(r, p)                                                           MREAD_32((uint8_t *)(p) + 192, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_SACK_OPT_ADDR_LOW_WRITE(v, p)                                                          MWRITE_32((uint8_t *)(p) + 192, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_SACK_OPT_ADDR_HIGH_READ_G(r, g, idx)                                                   GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 196, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_SACK_OPT_ADDR_HIGH_WRITE_G(v, g, idx)                                                  GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 196, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_SACK_OPT_ADDR_HIGH_READ_CORE(r, g, idx, core_id)                                       CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 196, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_SACK_OPT_ADDR_HIGH_WRITE_CORE(v, g, idx, core_id)                                      CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 196, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_SACK_OPT_ADDR_HIGH_READ(r, p)                                                          MREAD_32((uint8_t *)(p) + 196, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_SACK_OPT_ADDR_HIGH_WRITE(v, p)                                                         MWRITE_32((uint8_t *)(p) + 196, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_SACK_OPT_SEND_CNT_READ_G(r, g, idx)                                                    GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 200, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_SACK_OPT_SEND_CNT_WRITE_G(v, g, idx)                                                   GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 200, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_SACK_OPT_SEND_CNT_READ_CORE(r, g, idx, core_id)                                        CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 200, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_SACK_OPT_SEND_CNT_WRITE_CORE(v, g, idx, core_id)                                       CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 200, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_SACK_OPT_SEND_CNT_READ(r, p)                                                           MREAD_32((uint8_t *)(p) + 200, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_SACK_OPT_SEND_CNT_WRITE(v, p)                                                          MWRITE_32((uint8_t *)(p) + 200, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_SACK_OPT_DROP_CNT_READ_G(r, g, idx)                                                    GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 204, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_SACK_OPT_DROP_CNT_WRITE_G(v, g, idx)                                                   GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 204, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_SACK_OPT_DROP_CNT_READ_CORE(r, g, idx, core_id)                                        CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 204, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_SACK_OPT_DROP_CNT_WRITE_CORE(v, g, idx, core_id)                                       CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 204, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_SACK_OPT_DROP_CNT_READ(r, p)                                                           MREAD_32((uint8_t *)(p) + 204, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_SACK_OPT_DROP_CNT_WRITE(v, p)                                                          MWRITE_32((uint8_t *)(p) + 204, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_PKT_DROP_RX_SEQ_ADDR_LOW_READ_G(r, g, idx)                                             GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 208, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_PKT_DROP_RX_SEQ_ADDR_LOW_WRITE_G(v, g, idx)                                            GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 208, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_PKT_DROP_RX_SEQ_ADDR_LOW_READ_CORE(r, g, idx, core_id)                                 CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 208, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_PKT_DROP_RX_SEQ_ADDR_LOW_WRITE_CORE(v, g, idx, core_id)                                CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 208, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_PKT_DROP_RX_SEQ_ADDR_LOW_READ(r, p)                                                    MREAD_32((uint8_t *)(p) + 208, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_PKT_DROP_RX_SEQ_ADDR_LOW_WRITE(v, p)                                                   MWRITE_32((uint8_t *)(p) + 208, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_PKT_DROP_RX_SEQ_ADDR_HIGH_READ_G(r, g, idx)                                            GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 212, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_PKT_DROP_RX_SEQ_ADDR_HIGH_WRITE_G(v, g, idx)                                           GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 212, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_PKT_DROP_RX_SEQ_ADDR_HIGH_READ_CORE(r, g, idx, core_id)                                CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 212, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_PKT_DROP_RX_SEQ_ADDR_HIGH_WRITE_CORE(v, g, idx, core_id)                               CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 212, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_PKT_DROP_RX_SEQ_ADDR_HIGH_READ(r, p)                                                   MREAD_32((uint8_t *)(p) + 212, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_PKT_DROP_RX_SEQ_ADDR_HIGH_WRITE(v, p)                                                  MWRITE_32((uint8_t *)(p) + 212, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_PKT_DROP_RX_SEQ_SEND_CNT_READ_G(r, g, idx)                                             GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 216, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_PKT_DROP_RX_SEQ_SEND_CNT_WRITE_G(v, g, idx)                                            GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 216, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_PKT_DROP_RX_SEQ_SEND_CNT_READ_CORE(r, g, idx, core_id)                                 CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 216, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_PKT_DROP_RX_SEQ_SEND_CNT_WRITE_CORE(v, g, idx, core_id)                                CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 216, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_PKT_DROP_RX_SEQ_SEND_CNT_READ(r, p)                                                    MREAD_32((uint8_t *)(p) + 216, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_PKT_DROP_RX_SEQ_SEND_CNT_WRITE(v, p)                                                   MWRITE_32((uint8_t *)(p) + 216, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_PKT_DROP_RX_SEQ_DROP_CNT_READ_G(r, g, idx)                                             GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 220, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_PKT_DROP_RX_SEQ_DROP_CNT_WRITE_G(v, g, idx)                                            GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 220, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_PKT_DROP_RX_SEQ_DROP_CNT_READ_CORE(r, g, idx, core_id)                                 CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 220, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_PKT_DROP_RX_SEQ_DROP_CNT_WRITE_CORE(v, g, idx, core_id)                                CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 220, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_PKT_DROP_RX_SEQ_DROP_CNT_READ(r, p)                                                    MREAD_32((uint8_t *)(p) + 220, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_PKT_DROP_RX_SEQ_DROP_CNT_WRITE(v, p)                                                   MWRITE_32((uint8_t *)(p) + 220, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_SACK_OPT_TOTAL_PARSED_CNT_READ_G(r, g, idx)                                            GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 224, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_SACK_OPT_TOTAL_PARSED_CNT_WRITE_G(v, g, idx)                                           GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 224, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_SACK_OPT_TOTAL_PARSED_CNT_READ_CORE(r, g, idx, core_id)                                CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 224, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_SACK_OPT_TOTAL_PARSED_CNT_WRITE_CORE(v, g, idx, core_id)                               CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 224, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_SACK_OPT_TOTAL_PARSED_CNT_READ(r, p)                                                   MREAD_32((uint8_t *)(p) + 224, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_SACK_OPT_TOTAL_PARSED_CNT_WRITE(v, p)                                                  MWRITE_32((uint8_t *)(p) + 224, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_RTO_RETRANS_RECEIVE_CNT_READ_G(r, g, idx)                                              GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 228, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_RTO_RETRANS_RECEIVE_CNT_WRITE_G(v, g, idx)                                             GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 228, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_RTO_RETRANS_RECEIVE_CNT_READ_CORE(r, g, idx, core_id)                                  CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 228, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_RTO_RETRANS_RECEIVE_CNT_WRITE_CORE(v, g, idx, core_id)                                 CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 228, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_RTO_RETRANS_RECEIVE_CNT_READ(r, p)                                                     MREAD_32((uint8_t *)(p) + 228, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_RTO_RETRANS_RECEIVE_CNT_WRITE(v, p)                                                    MWRITE_32((uint8_t *)(p) + 228, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_SCRATCHPAD_METADATA_WR_OFS_READ_G(r, g, idx)                                GROUP_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 232, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_SCRATCHPAD_METADATA_WR_OFS_WRITE_G(v, g, idx)                               GROUP_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 232, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_SCRATCHPAD_METADATA_WR_OFS_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 232, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_SCRATCHPAD_METADATA_WR_OFS_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 232, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_SCRATCHPAD_METADATA_WR_OFS_READ(r, p)                                       MREAD_16((uint8_t *)(p) + 232, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_SCRATCHPAD_METADATA_WR_OFS_WRITE(v, p)                                      MWRITE_16((uint8_t *)(p) + 232, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_RESERVED1_READ_G(r, g, idx)                                                            GROUP_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 234, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_RESERVED1_WRITE_G(v, g, idx)                                                           GROUP_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 234, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_RESERVED1_READ_CORE(r, g, idx, core_id)                                                CORE_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 234, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_RESERVED1_WRITE_CORE(v, g, idx, core_id)                                               CORE_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 234, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_RESERVED1_READ(r, p)                                                                   MREAD_16((uint8_t *)(p) + 234, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_RESERVED1_WRITE(v, p)                                                                  MWRITE_16((uint8_t *)(p) + 234, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_COALESCING_TIMEOUT_CNT_READ_G(r, g, idx)                                    GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 236, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_COALESCING_TIMEOUT_CNT_WRITE_G(v, g, idx)                                   GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 236, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_COALESCING_TIMEOUT_CNT_READ_CORE(r, g, idx, core_id)                        CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 236, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_COALESCING_TIMEOUT_CNT_WRITE_CORE(v, g, idx, core_id)                       CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 236, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_COALESCING_TIMEOUT_CNT_READ(r, p)                                           MREAD_32((uint8_t *)(p) + 236, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_COALESCING_TIMEOUT_CNT_WRITE(v, p)                                          MWRITE_32((uint8_t *)(p) + 236, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_COALESCING_FILL_PKT_CNT_READ_G(r, g, idx)                                   GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 240, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_COALESCING_FILL_PKT_CNT_WRITE_G(v, g, idx)                                  GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 240, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_COALESCING_FILL_PKT_CNT_READ_CORE(r, g, idx, core_id)                       CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 240, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_COALESCING_FILL_PKT_CNT_WRITE_CORE(v, g, idx, core_id)                      CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 240, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_COALESCING_FILL_PKT_CNT_READ(r, p)                                          MREAD_32((uint8_t *)(p) + 240, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_COALESCING_FILL_PKT_CNT_WRITE(v, p)                                         MWRITE_32((uint8_t *)(p) + 240, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_COALESCING_LAST_TIME_READ_G(r, g, idx)                                      GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 244, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_COALESCING_LAST_TIME_WRITE_G(v, g, idx)                                     GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 244, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_COALESCING_LAST_TIME_READ_CORE(r, g, idx, core_id)                          CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 244, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_COALESCING_LAST_TIME_WRITE_CORE(v, g, idx, core_id)                         CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 244, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_COALESCING_LAST_TIME_READ(r, p)                                             MREAD_32((uint8_t *)(p) + 244, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_COALESCING_LAST_TIME_WRITE(v, p)                                            MWRITE_32((uint8_t *)(p) + 244, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_SCRATCHPAD_READ_G(r, g, idx, i)                                                        GROUP_MREAD_I_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 248, i, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_SCRATCHPAD_WRITE_G(v, g, idx, i)                                                       GROUP_MWRITE_I_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 248, i, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_SCRATCHPAD_READ_CORE(r, g, idx, i, core_id)                                            CORE_MREAD_I_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 248, i, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_SCRATCHPAD_WRITE_CORE(v, g, idx, i, core_id)                                           CORE_MWRITE_I_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 248, i, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_SCRATCHPAD_READ(r, p, i)                                                               MREAD_I_32((uint8_t *)(p) + 248, i, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_SCRATCHPAD_WRITE(v, p, i)                                                              MWRITE_I_32((uint8_t *)(p) + 248, i, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_SCRATCHPAD_METADATA_READ_G(r, g, idx, i)                                    GROUP_MREAD_I_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 280, i, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_SCRATCHPAD_METADATA_WRITE_G(v, g, idx, i)                                   GROUP_MWRITE_I_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 280, i, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_SCRATCHPAD_METADATA_READ_CORE(r, g, idx, i, core_id)                        CORE_MREAD_I_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 280, i, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_SCRATCHPAD_METADATA_WRITE_CORE(v, g, idx, i, core_id)                       CORE_MWRITE_I_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 280, i, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_SCRATCHPAD_METADATA_READ(r, p, i)                                           MREAD_I_32((uint8_t *)(p) + 280, i, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_SCRATCHPAD_METADATA_WRITE(v, p, i)                                          MWRITE_I_32((uint8_t *)(p) + 280, i, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_SACK_OPT_SCRATCHPAD_METADATA_READ_G(r, g, idx, i)                                      GROUP_MREAD_I_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 344, i, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_SACK_OPT_SCRATCHPAD_METADATA_WRITE_G(v, g, idx, i)                                     GROUP_MWRITE_I_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 344, i, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_SACK_OPT_SCRATCHPAD_METADATA_READ_CORE(r, g, idx, i, core_id)                          CORE_MREAD_I_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 344, i, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_SACK_OPT_SCRATCHPAD_METADATA_WRITE_CORE(v, g, idx, i, core_id)                         CORE_MWRITE_I_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 344, i, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_SACK_OPT_SCRATCHPAD_METADATA_READ(r, p, i)                                             MREAD_I_32((uint8_t *)(p) + 344, i, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_SACK_OPT_SCRATCHPAD_METADATA_WRITE(v, p, i)                                            MWRITE_I_32((uint8_t *)(p) + 344, i, (v))
/* <<<TCPSPDTEST_STREAM_STRUCT */


/* >>>DEBUG_PRINT_HEADER_STRUCT */
typedef union
    {
    uint8_t word_8[4];
    uint16_t word_16[2];
    uint32_t word_32[1];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint8_t	print_mark	;
        uint32_t	core_id   	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	task_id   	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	print_prio	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	msg_len   	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	string_id 	:11	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#else
        uint32_t	string_id 	:11	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	msg_len   	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	print_prio	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	task_id   	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	core_id   	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	print_mark	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(4))) DEBUG_PRINT_HEADER_STRUCT;

#define RDD_DEBUG_PRINT_HEADER_PRINT_MARK_READ_G(r, g, idx)                                GROUP_MREAD_8((g), (idx)*sizeof(DEBUG_PRINT_HEADER_STRUCT), (r))
#define RDD_DEBUG_PRINT_HEADER_PRINT_MARK_WRITE_G(v, g, idx)                               GROUP_MWRITE_8((g), (idx)*sizeof(DEBUG_PRINT_HEADER_STRUCT), (v))
#define RDD_DEBUG_PRINT_HEADER_PRINT_MARK_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_8((g), (idx)*sizeof(DEBUG_PRINT_HEADER_STRUCT), (r), core_id)
#define RDD_DEBUG_PRINT_HEADER_PRINT_MARK_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_8((g), (idx)*sizeof(DEBUG_PRINT_HEADER_STRUCT), (v), core_id)
#define RDD_DEBUG_PRINT_HEADER_PRINT_MARK_READ(r, p)                                       MREAD_8((uint8_t *)(p), (r))
#define RDD_DEBUG_PRINT_HEADER_PRINT_MARK_WRITE(v, p)                                      MWRITE_8((uint8_t *)(p), (v))
#define RDD_DEBUG_PRINT_HEADER_PRINT_MARK_L_READ( wv )                                     RDP_FIELD_GET( wv, 24, 8 )
#define RDD_DEBUG_PRINT_HEADER_PRINT_MARK_L_WRITE( v, wv )                                 RDP_FIELD_SET( v, 24, 8, wv )
#define RDD_DEBUG_PRINT_HEADER_CORE_ID_READ_G(r, g, idx)                                   GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(DEBUG_PRINT_HEADER_STRUCT) + 1, 4, 4, (r))
#define RDD_DEBUG_PRINT_HEADER_CORE_ID_WRITE_G(v, g, idx)                                  GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(DEBUG_PRINT_HEADER_STRUCT) + 1, 4, 4, (v))
#define RDD_DEBUG_PRINT_HEADER_CORE_ID_READ_CORE(r, g, idx, core_id)                       CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(DEBUG_PRINT_HEADER_STRUCT) + 1, 4, 4, (r), core_id)
#define RDD_DEBUG_PRINT_HEADER_CORE_ID_WRITE_CORE(v, g, idx, core_id)                      CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(DEBUG_PRINT_HEADER_STRUCT) + 1, 4, 4, (v), core_id)
#define RDD_DEBUG_PRINT_HEADER_CORE_ID_READ(r, p)                                          RDP_FIELD_MREAD_8((uint8_t *)(p) + 1, 4, 4, (r))
#define RDD_DEBUG_PRINT_HEADER_CORE_ID_WRITE(v, p)                                         RDP_FIELD_MWRITE_8((uint8_t *)(p) + 1, 4, 4, (v))
#define RDD_DEBUG_PRINT_HEADER_CORE_ID_L_READ( wv )                                        RDP_FIELD_GET( wv, 20, 4 )
#define RDD_DEBUG_PRINT_HEADER_CORE_ID_L_WRITE( v, wv )                                    RDP_FIELD_SET( v, 20, 4, wv )
#define RDD_DEBUG_PRINT_HEADER_TASK_ID_READ_G(r, g, idx)                                   GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(DEBUG_PRINT_HEADER_STRUCT) + 1, 0, 4, (r))
#define RDD_DEBUG_PRINT_HEADER_TASK_ID_WRITE_G(v, g, idx)                                  GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(DEBUG_PRINT_HEADER_STRUCT) + 1, 0, 4, (v))
#define RDD_DEBUG_PRINT_HEADER_TASK_ID_READ_CORE(r, g, idx, core_id)                       CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(DEBUG_PRINT_HEADER_STRUCT) + 1, 0, 4, (r), core_id)
#define RDD_DEBUG_PRINT_HEADER_TASK_ID_WRITE_CORE(v, g, idx, core_id)                      CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(DEBUG_PRINT_HEADER_STRUCT) + 1, 0, 4, (v), core_id)
#define RDD_DEBUG_PRINT_HEADER_TASK_ID_READ(r, p)                                          RDP_FIELD_MREAD_8((uint8_t *)(p) + 1, 0, 4, (r))
#define RDD_DEBUG_PRINT_HEADER_TASK_ID_WRITE(v, p)                                         RDP_FIELD_MWRITE_8((uint8_t *)(p) + 1, 0, 4, (v))
#define RDD_DEBUG_PRINT_HEADER_TASK_ID_L_READ( wv )                                        RDP_FIELD_GET( wv, 16, 4 )
#define RDD_DEBUG_PRINT_HEADER_TASK_ID_L_WRITE( v, wv )                                    RDP_FIELD_SET( v, 16, 4, wv )
#define RDD_DEBUG_PRINT_HEADER_PRINT_PRIO_READ_G(r, g, idx)                                GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(DEBUG_PRINT_HEADER_STRUCT) + 2, 6, 2, (r))
#define RDD_DEBUG_PRINT_HEADER_PRINT_PRIO_WRITE_G(v, g, idx)                               GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(DEBUG_PRINT_HEADER_STRUCT) + 2, 6, 2, (v))
#define RDD_DEBUG_PRINT_HEADER_PRINT_PRIO_READ_CORE(r, g, idx, core_id)                    CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(DEBUG_PRINT_HEADER_STRUCT) + 2, 6, 2, (r), core_id)
#define RDD_DEBUG_PRINT_HEADER_PRINT_PRIO_WRITE_CORE(v, g, idx, core_id)                   CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(DEBUG_PRINT_HEADER_STRUCT) + 2, 6, 2, (v), core_id)
#define RDD_DEBUG_PRINT_HEADER_PRINT_PRIO_READ(r, p)                                       RDP_FIELD_MREAD_8((uint8_t *)(p) + 2, 6, 2, (r))
#define RDD_DEBUG_PRINT_HEADER_PRINT_PRIO_WRITE(v, p)                                      RDP_FIELD_MWRITE_8((uint8_t *)(p) + 2, 6, 2, (v))
#define RDD_DEBUG_PRINT_HEADER_PRINT_PRIO_L_READ( wv )                                     RDP_FIELD_GET( wv, 14, 2 )
#define RDD_DEBUG_PRINT_HEADER_PRINT_PRIO_L_WRITE( v, wv )                                 RDP_FIELD_SET( v, 14, 2, wv )
#define RDD_DEBUG_PRINT_HEADER_MSG_LEN_READ_G(r, g, idx)                                   GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(DEBUG_PRINT_HEADER_STRUCT) + 2, 3, 3, (r))
#define RDD_DEBUG_PRINT_HEADER_MSG_LEN_WRITE_G(v, g, idx)                                  GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(DEBUG_PRINT_HEADER_STRUCT) + 2, 3, 3, (v))
#define RDD_DEBUG_PRINT_HEADER_MSG_LEN_READ_CORE(r, g, idx, core_id)                       CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(DEBUG_PRINT_HEADER_STRUCT) + 2, 3, 3, (r), core_id)
#define RDD_DEBUG_PRINT_HEADER_MSG_LEN_WRITE_CORE(v, g, idx, core_id)                      CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(DEBUG_PRINT_HEADER_STRUCT) + 2, 3, 3, (v), core_id)
#define RDD_DEBUG_PRINT_HEADER_MSG_LEN_READ(r, p)                                          RDP_FIELD_MREAD_8((uint8_t *)(p) + 2, 3, 3, (r))
#define RDD_DEBUG_PRINT_HEADER_MSG_LEN_WRITE(v, p)                                         RDP_FIELD_MWRITE_8((uint8_t *)(p) + 2, 3, 3, (v))
#define RDD_DEBUG_PRINT_HEADER_MSG_LEN_L_READ( wv )                                        RDP_FIELD_GET( wv, 11, 3 )
#define RDD_DEBUG_PRINT_HEADER_MSG_LEN_L_WRITE( v, wv )                                    RDP_FIELD_SET( v, 11, 3, wv )
#define RDD_DEBUG_PRINT_HEADER_STRING_ID_READ_G(r, g, idx)                                 GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(DEBUG_PRINT_HEADER_STRUCT) + 2, 0, 11, (r))
#define RDD_DEBUG_PRINT_HEADER_STRING_ID_WRITE_G(v, g, idx)                                GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(DEBUG_PRINT_HEADER_STRUCT) + 2, 0, 11, (v))
#define RDD_DEBUG_PRINT_HEADER_STRING_ID_READ_CORE(r, g, idx, core_id)                     CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(DEBUG_PRINT_HEADER_STRUCT) + 2, 0, 11, (r), core_id)
#define RDD_DEBUG_PRINT_HEADER_STRING_ID_WRITE_CORE(v, g, idx, core_id)                    CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(DEBUG_PRINT_HEADER_STRUCT) + 2, 0, 11, (v), core_id)
#define RDD_DEBUG_PRINT_HEADER_STRING_ID_READ(r, p)                                        RDP_FIELD_MREAD_16((uint8_t *)(p) + 2, 0, 11, (r))
#define RDD_DEBUG_PRINT_HEADER_STRING_ID_WRITE(v, p)                                       RDP_FIELD_MWRITE_16((uint8_t *)(p) + 2, 0, 11, (v))
#define RDD_DEBUG_PRINT_HEADER_STRING_ID_L_READ( wv )                                      RDP_FIELD_GET( wv, 0, 11 )
#define RDD_DEBUG_PRINT_HEADER_STRING_ID_L_WRITE( v, wv )                                  RDP_FIELD_SET( v, 0, 11, wv )
/* <<<DEBUG_PRINT_HEADER_STRUCT */


/* >>>DEBUG_PRINT_INFO_STRUCT */
typedef union
    {
    uint8_t word_8[16];
    uint16_t word_16[8];
    uint32_t word_32[4];
    uint64_t dword_64[2];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	addr_low  	;
        uint32_t	addr_high 	;
        uint32_t	size      	;
        uint8_t	table_id  	;
        uint32_t	reserved  	:24	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#else
        uint32_t	addr_low  	;
        uint32_t	addr_high 	;
        uint32_t	size      	;
        uint32_t	reserved  	:24	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	table_id  	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) DEBUG_PRINT_INFO_STRUCT;

#define RDD_DEBUG_PRINT_INFO_ADDR_LOW_READ_G(r, g, idx)                                 GROUP_MREAD_32((g), (idx)*sizeof(DEBUG_PRINT_INFO_STRUCT), (r))
#define RDD_DEBUG_PRINT_INFO_ADDR_LOW_WRITE_G(v, g, idx)                                GROUP_MWRITE_32((g), (idx)*sizeof(DEBUG_PRINT_INFO_STRUCT), (v))
#define RDD_DEBUG_PRINT_INFO_ADDR_LOW_READ_CORE(r, g, idx, core_id)                     CORE_MREAD_32((g), (idx)*sizeof(DEBUG_PRINT_INFO_STRUCT), (r), core_id)
#define RDD_DEBUG_PRINT_INFO_ADDR_LOW_WRITE_CORE(v, g, idx, core_id)                    CORE_MWRITE_32((g), (idx)*sizeof(DEBUG_PRINT_INFO_STRUCT), (v), core_id)
#define RDD_DEBUG_PRINT_INFO_ADDR_LOW_READ(r, p)                                        MREAD_32((uint8_t *)(p), (r))
#define RDD_DEBUG_PRINT_INFO_ADDR_LOW_WRITE(v, p)                                       MWRITE_32((uint8_t *)(p), (v))
#define RDD_DEBUG_PRINT_INFO_ADDR_LOW_L_READ( wv )                                      RDP_FIELD_GET( wv, 0, 32 )
#define RDD_DEBUG_PRINT_INFO_ADDR_LOW_L_WRITE( v, wv )                                  RDP_FIELD_SET( v, 0, 32, wv )
#define RDD_DEBUG_PRINT_INFO_ADDR_HIGH_READ_G(r, g, idx)                                GROUP_MREAD_32((g), (idx)*sizeof(DEBUG_PRINT_INFO_STRUCT) + 4, (r))
#define RDD_DEBUG_PRINT_INFO_ADDR_HIGH_WRITE_G(v, g, idx)                               GROUP_MWRITE_32((g), (idx)*sizeof(DEBUG_PRINT_INFO_STRUCT) + 4, (v))
#define RDD_DEBUG_PRINT_INFO_ADDR_HIGH_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_32((g), (idx)*sizeof(DEBUG_PRINT_INFO_STRUCT) + 4, (r), core_id)
#define RDD_DEBUG_PRINT_INFO_ADDR_HIGH_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_32((g), (idx)*sizeof(DEBUG_PRINT_INFO_STRUCT) + 4, (v), core_id)
#define RDD_DEBUG_PRINT_INFO_ADDR_HIGH_READ(r, p)                                       MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_DEBUG_PRINT_INFO_ADDR_HIGH_WRITE(v, p)                                      MWRITE_32((uint8_t *)(p) + 4, (v))
#define RDD_DEBUG_PRINT_INFO_ADDR_HIGH_L_READ( wv )                                     RDP_FIELD_GET( wv, 0, 32 )
#define RDD_DEBUG_PRINT_INFO_ADDR_HIGH_L_WRITE( v, wv )                                 RDP_FIELD_SET( v, 0, 32, wv )
#define RDD_DEBUG_PRINT_INFO_SIZE_READ_G(r, g, idx)                                     GROUP_MREAD_32((g), (idx)*sizeof(DEBUG_PRINT_INFO_STRUCT) + 8, (r))
#define RDD_DEBUG_PRINT_INFO_SIZE_WRITE_G(v, g, idx)                                    GROUP_MWRITE_32((g), (idx)*sizeof(DEBUG_PRINT_INFO_STRUCT) + 8, (v))
#define RDD_DEBUG_PRINT_INFO_SIZE_READ_CORE(r, g, idx, core_id)                         CORE_MREAD_32((g), (idx)*sizeof(DEBUG_PRINT_INFO_STRUCT) + 8, (r), core_id)
#define RDD_DEBUG_PRINT_INFO_SIZE_WRITE_CORE(v, g, idx, core_id)                        CORE_MWRITE_32((g), (idx)*sizeof(DEBUG_PRINT_INFO_STRUCT) + 8, (v), core_id)
#define RDD_DEBUG_PRINT_INFO_SIZE_READ(r, p)                                            MREAD_32((uint8_t *)(p) + 8, (r))
#define RDD_DEBUG_PRINT_INFO_SIZE_WRITE(v, p)                                           MWRITE_32((uint8_t *)(p) + 8, (v))
#define RDD_DEBUG_PRINT_INFO_SIZE_L_READ( wv )                                          RDP_FIELD_GET( wv, 0, 32 )
#define RDD_DEBUG_PRINT_INFO_SIZE_L_WRITE( v, wv )                                      RDP_FIELD_SET( v, 0, 32, wv )
#define RDD_DEBUG_PRINT_INFO_TABLE_ID_READ_G(r, g, idx)                                 GROUP_MREAD_8((g), (idx)*sizeof(DEBUG_PRINT_INFO_STRUCT) + 12, (r))
#define RDD_DEBUG_PRINT_INFO_TABLE_ID_WRITE_G(v, g, idx)                                GROUP_MWRITE_8((g), (idx)*sizeof(DEBUG_PRINT_INFO_STRUCT) + 12, (v))
#define RDD_DEBUG_PRINT_INFO_TABLE_ID_READ_CORE(r, g, idx, core_id)                     CORE_MREAD_8((g), (idx)*sizeof(DEBUG_PRINT_INFO_STRUCT) + 12, (r), core_id)
#define RDD_DEBUG_PRINT_INFO_TABLE_ID_WRITE_CORE(v, g, idx, core_id)                    CORE_MWRITE_8((g), (idx)*sizeof(DEBUG_PRINT_INFO_STRUCT) + 12, (v), core_id)
#define RDD_DEBUG_PRINT_INFO_TABLE_ID_READ(r, p)                                        MREAD_8((uint8_t *)(p) + 12, (r))
#define RDD_DEBUG_PRINT_INFO_TABLE_ID_WRITE(v, p)                                       MWRITE_8((uint8_t *)(p) + 12, (v))
#define RDD_DEBUG_PRINT_INFO_TABLE_ID_L_READ( wv )                                      RDP_FIELD_GET( wv, 24, 8 )
#define RDD_DEBUG_PRINT_INFO_TABLE_ID_L_WRITE( v, wv )                                  RDP_FIELD_SET( v, 24, 8, wv )
/* <<<DEBUG_PRINT_INFO_STRUCT */


/* >>>IPTV_CFG_STRUCT */
typedef union
    {
    uint8_t word_8[8];
    uint16_t word_16[4];
    uint32_t word_32[2];
    uint64_t dword_64[1];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint16_t	res_offset    	;
        uint16_t	context_offset	;
        uint16_t	key_offset    	;
        uint8_t	hash_tbl_idx  	;
        uint8_t	l2_mcast      	;
#else
        uint16_t	context_offset	;
        uint16_t	res_offset    	;
        uint8_t	l2_mcast      	;
        uint8_t	hash_tbl_idx  	;
        uint16_t	key_offset    	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) IPTV_CFG_STRUCT;

#define RDD_IPTV_CFG_RES_OFFSET_READ_G(r, g, idx)                                    GROUP_MREAD_16((g), (idx)*sizeof(IPTV_CFG_STRUCT), (r))
#define RDD_IPTV_CFG_RES_OFFSET_WRITE_G(v, g, idx)                                   GROUP_MWRITE_16((g), (idx)*sizeof(IPTV_CFG_STRUCT), (v))
#define RDD_IPTV_CFG_RES_OFFSET_READ_CORE(r, g, idx, core_id)                        CORE_MREAD_16((g), (idx)*sizeof(IPTV_CFG_STRUCT), (r), core_id)
#define RDD_IPTV_CFG_RES_OFFSET_WRITE_CORE(v, g, idx, core_id)                       CORE_MWRITE_16((g), (idx)*sizeof(IPTV_CFG_STRUCT), (v), core_id)
#define RDD_IPTV_CFG_RES_OFFSET_READ(r, p)                                           MREAD_16((uint8_t *)(p), (r))
#define RDD_IPTV_CFG_RES_OFFSET_WRITE(v, p)                                          MWRITE_16((uint8_t *)(p), (v))
#define RDD_IPTV_CFG_CONTEXT_OFFSET_READ_G(r, g, idx)                                GROUP_MREAD_16((g), (idx)*sizeof(IPTV_CFG_STRUCT) + 2, (r))
#define RDD_IPTV_CFG_CONTEXT_OFFSET_WRITE_G(v, g, idx)                               GROUP_MWRITE_16((g), (idx)*sizeof(IPTV_CFG_STRUCT) + 2, (v))
#define RDD_IPTV_CFG_CONTEXT_OFFSET_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_16((g), (idx)*sizeof(IPTV_CFG_STRUCT) + 2, (r), core_id)
#define RDD_IPTV_CFG_CONTEXT_OFFSET_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_16((g), (idx)*sizeof(IPTV_CFG_STRUCT) + 2, (v), core_id)
#define RDD_IPTV_CFG_CONTEXT_OFFSET_READ(r, p)                                       MREAD_16((uint8_t *)(p) + 2, (r))
#define RDD_IPTV_CFG_CONTEXT_OFFSET_WRITE(v, p)                                      MWRITE_16((uint8_t *)(p) + 2, (v))
#define RDD_IPTV_CFG_KEY_OFFSET_READ_G(r, g, idx)                                    GROUP_MREAD_16((g), (idx)*sizeof(IPTV_CFG_STRUCT) + 4, (r))
#define RDD_IPTV_CFG_KEY_OFFSET_WRITE_G(v, g, idx)                                   GROUP_MWRITE_16((g), (idx)*sizeof(IPTV_CFG_STRUCT) + 4, (v))
#define RDD_IPTV_CFG_KEY_OFFSET_READ_CORE(r, g, idx, core_id)                        CORE_MREAD_16((g), (idx)*sizeof(IPTV_CFG_STRUCT) + 4, (r), core_id)
#define RDD_IPTV_CFG_KEY_OFFSET_WRITE_CORE(v, g, idx, core_id)                       CORE_MWRITE_16((g), (idx)*sizeof(IPTV_CFG_STRUCT) + 4, (v), core_id)
#define RDD_IPTV_CFG_KEY_OFFSET_READ(r, p)                                           MREAD_16((uint8_t *)(p) + 4, (r))
#define RDD_IPTV_CFG_KEY_OFFSET_WRITE(v, p)                                          MWRITE_16((uint8_t *)(p) + 4, (v))
#define RDD_IPTV_CFG_HASH_TBL_IDX_READ_G(r, g, idx)                                  GROUP_MREAD_8((g), (idx)*sizeof(IPTV_CFG_STRUCT) + 6, (r))
#define RDD_IPTV_CFG_HASH_TBL_IDX_WRITE_G(v, g, idx)                                 GROUP_MWRITE_8((g), (idx)*sizeof(IPTV_CFG_STRUCT) + 6, (v))
#define RDD_IPTV_CFG_HASH_TBL_IDX_READ_CORE(r, g, idx, core_id)                      CORE_MREAD_8((g), (idx)*sizeof(IPTV_CFG_STRUCT) + 6, (r), core_id)
#define RDD_IPTV_CFG_HASH_TBL_IDX_WRITE_CORE(v, g, idx, core_id)                     CORE_MWRITE_8((g), (idx)*sizeof(IPTV_CFG_STRUCT) + 6, (v), core_id)
#define RDD_IPTV_CFG_HASH_TBL_IDX_READ(r, p)                                         MREAD_8((uint8_t *)(p) + 6, (r))
#define RDD_IPTV_CFG_HASH_TBL_IDX_WRITE(v, p)                                        MWRITE_8((uint8_t *)(p) + 6, (v))
#define RDD_IPTV_CFG_L2_MCAST_READ_G(r, g, idx)                                      GROUP_MREAD_8((g), (idx)*sizeof(IPTV_CFG_STRUCT) + 7, (r))
#define RDD_IPTV_CFG_L2_MCAST_WRITE_G(v, g, idx)                                     GROUP_MWRITE_8((g), (idx)*sizeof(IPTV_CFG_STRUCT) + 7, (v))
#define RDD_IPTV_CFG_L2_MCAST_READ_CORE(r, g, idx, core_id)                          CORE_MREAD_8((g), (idx)*sizeof(IPTV_CFG_STRUCT) + 7, (r), core_id)
#define RDD_IPTV_CFG_L2_MCAST_WRITE_CORE(v, g, idx, core_id)                         CORE_MWRITE_8((g), (idx)*sizeof(IPTV_CFG_STRUCT) + 7, (v), core_id)
#define RDD_IPTV_CFG_L2_MCAST_READ(r, p)                                             MREAD_8((uint8_t *)(p) + 7, (r))
#define RDD_IPTV_CFG_L2_MCAST_WRITE(v, p)                                            MWRITE_8((uint8_t *)(p) + 7, (v))
/* <<<IPTV_CFG_STRUCT */


/* >>>IPTV_HASH_LKP_ENTRY_STRUCT */
typedef union
    {
    uint8_t word_8[8];
    uint16_t word_16[4];
    uint32_t word_32[2];
    uint64_t dword_64[1];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
	/* Union WORD 0 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	addr_high        	; /* This is a field union */
		};
		/* Sub Union 1 */
		struct{
        uint32_t	reserved0                  	:31	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of addr_high union */
        uint32_t	ipv6                       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of addr_high union */
		};
		/* Sub Union 2 */
		struct{
        uint16_t	reserved1                  	; /* Member of addr_high union */
        uint16_t	mac_high                   	; /* Member of addr_high union */
		};
	};
	/* Union WORD 1 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	dst_ip_or_mac_low	;
		};
	};
#else
	/* Union WORD 0 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	addr_high        	; /* This is a field union */
		};
		/* Sub Union 1 */
		struct{
        uint32_t	ipv6                       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of addr_high union */
        uint32_t	reserved0                  	:31	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of addr_high union */
		};
		/* Sub Union 2 */
		struct{
        uint16_t	mac_high                   	; /* Member of addr_high union */
        uint16_t	reserved1                  	; /* Member of addr_high union */
		};
	};
	/* Union WORD 1 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	dst_ip_or_mac_low	;
		};
	};
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) IPTV_HASH_LKP_ENTRY_STRUCT;

#define RDD_IPTV_HASH_LKP_ENTRY_ADDR_HIGH_READ_G(r, g, idx)                                        GROUP_MREAD_32((g), (idx)*sizeof(IPTV_HASH_LKP_ENTRY_STRUCT), (r))
#define RDD_IPTV_HASH_LKP_ENTRY_ADDR_HIGH_WRITE_G(v, g, idx)                                       GROUP_MWRITE_32((g), (idx)*sizeof(IPTV_HASH_LKP_ENTRY_STRUCT), (v))
#define RDD_IPTV_HASH_LKP_ENTRY_ADDR_HIGH_READ_CORE(r, g, idx, core_id)                            CORE_MREAD_32((g), (idx)*sizeof(IPTV_HASH_LKP_ENTRY_STRUCT), (r), core_id)
#define RDD_IPTV_HASH_LKP_ENTRY_ADDR_HIGH_WRITE_CORE(v, g, idx, core_id)                           CORE_MWRITE_32((g), (idx)*sizeof(IPTV_HASH_LKP_ENTRY_STRUCT), (v), core_id)
#define RDD_IPTV_HASH_LKP_ENTRY_ADDR_HIGH_READ(r, p)                                               MREAD_32((uint8_t *)(p), (r))
#define RDD_IPTV_HASH_LKP_ENTRY_ADDR_HIGH_WRITE(v, p)                                              MWRITE_32((uint8_t *)(p), (v))
#define RDD_IPTV_HASH_LKP_ENTRY_IPV6_READ_G(r, g, idx)                                             GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(IPTV_HASH_LKP_ENTRY_STRUCT) + 3, 0, 1, (r))
#define RDD_IPTV_HASH_LKP_ENTRY_IPV6_WRITE_G(v, g, idx)                                            GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(IPTV_HASH_LKP_ENTRY_STRUCT) + 3, 0, 1, (v))
#define RDD_IPTV_HASH_LKP_ENTRY_IPV6_READ_CORE(r, g, idx, core_id)                                 CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(IPTV_HASH_LKP_ENTRY_STRUCT) + 3, 0, 1, (r), core_id)
#define RDD_IPTV_HASH_LKP_ENTRY_IPV6_WRITE_CORE(v, g, idx, core_id)                                CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(IPTV_HASH_LKP_ENTRY_STRUCT) + 3, 0, 1, (v), core_id)
#define RDD_IPTV_HASH_LKP_ENTRY_IPV6_READ(r, p)                                                    RDP_FIELD_MREAD_8((uint8_t *)(p) + 3, 0, 1, (r))
#define RDD_IPTV_HASH_LKP_ENTRY_IPV6_WRITE(v, p)                                                   RDP_FIELD_MWRITE_8((uint8_t *)(p) + 3, 0, 1, (v))
#define RDD_IPTV_HASH_LKP_ENTRY_MAC_HIGH_READ_G(r, g, idx)                                         GROUP_MREAD_16((g), (idx)*sizeof(IPTV_HASH_LKP_ENTRY_STRUCT) + 2, (r))
#define RDD_IPTV_HASH_LKP_ENTRY_MAC_HIGH_WRITE_G(v, g, idx)                                        GROUP_MWRITE_16((g), (idx)*sizeof(IPTV_HASH_LKP_ENTRY_STRUCT) + 2, (v))
#define RDD_IPTV_HASH_LKP_ENTRY_MAC_HIGH_READ_CORE(r, g, idx, core_id)                             CORE_MREAD_16((g), (idx)*sizeof(IPTV_HASH_LKP_ENTRY_STRUCT) + 2, (r), core_id)
#define RDD_IPTV_HASH_LKP_ENTRY_MAC_HIGH_WRITE_CORE(v, g, idx, core_id)                            CORE_MWRITE_16((g), (idx)*sizeof(IPTV_HASH_LKP_ENTRY_STRUCT) + 2, (v), core_id)
#define RDD_IPTV_HASH_LKP_ENTRY_MAC_HIGH_READ(r, p)                                                MREAD_16((uint8_t *)(p) + 2, (r))
#define RDD_IPTV_HASH_LKP_ENTRY_MAC_HIGH_WRITE(v, p)                                               MWRITE_16((uint8_t *)(p) + 2, (v))
#define RDD_IPTV_HASH_LKP_ENTRY_DST_IP_OR_MAC_LOW_READ_G(r, g, idx)                                GROUP_MREAD_32((g), (idx)*sizeof(IPTV_HASH_LKP_ENTRY_STRUCT) + 4, (r))
#define RDD_IPTV_HASH_LKP_ENTRY_DST_IP_OR_MAC_LOW_WRITE_G(v, g, idx)                               GROUP_MWRITE_32((g), (idx)*sizeof(IPTV_HASH_LKP_ENTRY_STRUCT) + 4, (v))
#define RDD_IPTV_HASH_LKP_ENTRY_DST_IP_OR_MAC_LOW_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_32((g), (idx)*sizeof(IPTV_HASH_LKP_ENTRY_STRUCT) + 4, (r), core_id)
#define RDD_IPTV_HASH_LKP_ENTRY_DST_IP_OR_MAC_LOW_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_32((g), (idx)*sizeof(IPTV_HASH_LKP_ENTRY_STRUCT) + 4, (v), core_id)
#define RDD_IPTV_HASH_LKP_ENTRY_DST_IP_OR_MAC_LOW_READ(r, p)                                       MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_IPTV_HASH_LKP_ENTRY_DST_IP_OR_MAC_LOW_WRITE(v, p)                                      MWRITE_32((uint8_t *)(p) + 4, (v))
/* <<<IPTV_HASH_LKP_ENTRY_STRUCT */


/* >>>IPTV_HASH_RESULT_ENTRY_STRUCT */
typedef union
    {
    uint8_t word_8[3];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	ctx_idx   	:10	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved0 	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#else
        uint32_t	reserved0 	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ctx_idx   	:10	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } IPTV_HASH_RESULT_ENTRY_STRUCT;

#define RDD_IPTV_HASH_RESULT_ENTRY_CTX_IDX_READ_G(r, g, idx)                                  GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(IPTV_HASH_RESULT_ENTRY_STRUCT), 6, 10, (r))
#define RDD_IPTV_HASH_RESULT_ENTRY_CTX_IDX_WRITE_G(v, g, idx)                                 GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(IPTV_HASH_RESULT_ENTRY_STRUCT), 6, 10, (v))
#define RDD_IPTV_HASH_RESULT_ENTRY_CTX_IDX_READ_CORE(r, g, idx, core_id)                      CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(IPTV_HASH_RESULT_ENTRY_STRUCT), 6, 10, (r), core_id)
#define RDD_IPTV_HASH_RESULT_ENTRY_CTX_IDX_WRITE_CORE(v, g, idx, core_id)                     CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(IPTV_HASH_RESULT_ENTRY_STRUCT), 6, 10, (v), core_id)
#define RDD_IPTV_HASH_RESULT_ENTRY_CTX_IDX_READ(r, p)                                         RDP_FIELD_MREAD_16((uint8_t *)(p), 6, 10, (r))
#define RDD_IPTV_HASH_RESULT_ENTRY_CTX_IDX_WRITE(v, p)                                        RDP_FIELD_MWRITE_16((uint8_t *)(p), 6, 10, (v))
/* <<<IPTV_HASH_RESULT_ENTRY_STRUCT */


/* >>>IPTV_DDR_CONTEXT_ENTRY_STRUCT */
#define RDD_IPTV_DDR_CONTEXT_ENTRY_SRC_IPV6_ADDR_NUMBER	16
#define RDD_IPTV_DDR_CONTEXT_ENTRY_DST_IPV6_ADDR_NUMBER	16
#define RDD_IPTV_DDR_CONTEXT_ENTRY_RESULT_NUMBER	32
typedef union
    {
    uint8_t word_8[88];
    uint16_t word_16[44];
    uint32_t word_32[22];
    uint64_t dword_64[11];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	valid                                                             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ip_ver                                                            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	any_vid                                                           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	any_src_ip                                                        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	vid                                                               	:12	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	next_entry_idx                                                    	;
        uint16_t	ssid_vector_0_or_flooding_vport                                   	;
        uint16_t	ssid_vector_1                                                     	;
        uint16_t	ssid_vector_2                                                     	;
        uint32_t	reserved4                                                         	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	rdd_vport                                                         	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	reserved3                                                         	;
        uint8_t	reserved2                                                         	;
        uint32_t	pool_num                                                          	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	replications                                                      	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved1                                                         	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	cntr_id                                                           	:10	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	egress_ports_vector                                               	;
        uint32_t	src_ip                                                            	;
        uint8_t	src_ipv6_addr[RDD_IPTV_DDR_CONTEXT_ENTRY_SRC_IPV6_ADDR_NUMBER];
        uint8_t	dst_ipv6_addr[RDD_IPTV_DDR_CONTEXT_ENTRY_DST_IPV6_ADDR_NUMBER];
        uint8_t	result[RDD_IPTV_DDR_CONTEXT_ENTRY_RESULT_NUMBER];
#else
        uint16_t	next_entry_idx                                                    	;
        uint32_t	vid                                                               	:12	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	any_src_ip                                                        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	any_vid                                                           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ip_ver                                                            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	valid                                                             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	ssid_vector_1                                                     	;
        uint16_t	ssid_vector_0_or_flooding_vport                                   	;
        uint8_t	reserved3                                                         	;
        uint32_t	rdd_vport                                                         	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved4                                                         	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	ssid_vector_2                                                     	;
        uint32_t	cntr_id                                                           	:10	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved1                                                         	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	replications                                                      	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	pool_num                                                          	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	reserved2                                                         	;
        uint32_t	egress_ports_vector                                               	;
        uint32_t	src_ip                                                            	;
        uint8_t	src_ipv6_addr[RDD_IPTV_DDR_CONTEXT_ENTRY_SRC_IPV6_ADDR_NUMBER];
        uint8_t	dst_ipv6_addr[RDD_IPTV_DDR_CONTEXT_ENTRY_DST_IPV6_ADDR_NUMBER];
        uint8_t	result[RDD_IPTV_DDR_CONTEXT_ENTRY_RESULT_NUMBER];
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) IPTV_DDR_CONTEXT_ENTRY_STRUCT;

#define RDD_IPTV_DDR_CONTEXT_ENTRY_VALID_READ_G(r, g, idx)                                                          GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT), 7, 1, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_VALID_WRITE_G(v, g, idx)                                                         GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT), 7, 1, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_VALID_READ_CORE(r, g, idx, core_id)                                              CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT), 7, 1, (r), core_id)
#define RDD_IPTV_DDR_CONTEXT_ENTRY_VALID_WRITE_CORE(v, g, idx, core_id)                                             CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT), 7, 1, (v), core_id)
#define RDD_IPTV_DDR_CONTEXT_ENTRY_VALID_READ(r, p)                                                                 RDP_FIELD_MREAD_8((uint8_t *)(p), 7, 1, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_VALID_WRITE(v, p)                                                                RDP_FIELD_MWRITE_8((uint8_t *)(p), 7, 1, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_IP_VER_READ_G(r, g, idx)                                                         GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT), 6, 1, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_IP_VER_WRITE_G(v, g, idx)                                                        GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT), 6, 1, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_IP_VER_READ_CORE(r, g, idx, core_id)                                             CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT), 6, 1, (r), core_id)
#define RDD_IPTV_DDR_CONTEXT_ENTRY_IP_VER_WRITE_CORE(v, g, idx, core_id)                                            CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT), 6, 1, (v), core_id)
#define RDD_IPTV_DDR_CONTEXT_ENTRY_IP_VER_READ(r, p)                                                                RDP_FIELD_MREAD_8((uint8_t *)(p), 6, 1, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_IP_VER_WRITE(v, p)                                                               RDP_FIELD_MWRITE_8((uint8_t *)(p), 6, 1, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_ANY_VID_READ_G(r, g, idx)                                                        GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT), 5, 1, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_ANY_VID_WRITE_G(v, g, idx)                                                       GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT), 5, 1, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_ANY_VID_READ_CORE(r, g, idx, core_id)                                            CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT), 5, 1, (r), core_id)
#define RDD_IPTV_DDR_CONTEXT_ENTRY_ANY_VID_WRITE_CORE(v, g, idx, core_id)                                           CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT), 5, 1, (v), core_id)
#define RDD_IPTV_DDR_CONTEXT_ENTRY_ANY_VID_READ(r, p)                                                               RDP_FIELD_MREAD_8((uint8_t *)(p), 5, 1, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_ANY_VID_WRITE(v, p)                                                              RDP_FIELD_MWRITE_8((uint8_t *)(p), 5, 1, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_ANY_SRC_IP_READ_G(r, g, idx)                                                     GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT), 4, 1, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_ANY_SRC_IP_WRITE_G(v, g, idx)                                                    GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT), 4, 1, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_ANY_SRC_IP_READ_CORE(r, g, idx, core_id)                                         CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT), 4, 1, (r), core_id)
#define RDD_IPTV_DDR_CONTEXT_ENTRY_ANY_SRC_IP_WRITE_CORE(v, g, idx, core_id)                                        CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT), 4, 1, (v), core_id)
#define RDD_IPTV_DDR_CONTEXT_ENTRY_ANY_SRC_IP_READ(r, p)                                                            RDP_FIELD_MREAD_8((uint8_t *)(p), 4, 1, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_ANY_SRC_IP_WRITE(v, p)                                                           RDP_FIELD_MWRITE_8((uint8_t *)(p), 4, 1, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_VID_READ_G(r, g, idx)                                                            GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT), 0, 12, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_VID_WRITE_G(v, g, idx)                                                           GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT), 0, 12, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_VID_READ_CORE(r, g, idx, core_id)                                                CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT), 0, 12, (r), core_id)
#define RDD_IPTV_DDR_CONTEXT_ENTRY_VID_WRITE_CORE(v, g, idx, core_id)                                               CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT), 0, 12, (v), core_id)
#define RDD_IPTV_DDR_CONTEXT_ENTRY_VID_READ(r, p)                                                                   RDP_FIELD_MREAD_16((uint8_t *)(p), 0, 12, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_VID_WRITE(v, p)                                                                  RDP_FIELD_MWRITE_16((uint8_t *)(p), 0, 12, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_NEXT_ENTRY_IDX_READ_G(r, g, idx)                                                 GROUP_MREAD_16((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 2, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_NEXT_ENTRY_IDX_WRITE_G(v, g, idx)                                                GROUP_MWRITE_16((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 2, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_NEXT_ENTRY_IDX_READ_CORE(r, g, idx, core_id)                                     CORE_MREAD_16((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 2, (r), core_id)
#define RDD_IPTV_DDR_CONTEXT_ENTRY_NEXT_ENTRY_IDX_WRITE_CORE(v, g, idx, core_id)                                    CORE_MWRITE_16((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 2, (v), core_id)
#define RDD_IPTV_DDR_CONTEXT_ENTRY_NEXT_ENTRY_IDX_READ(r, p)                                                        MREAD_16((uint8_t *)(p) + 2, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_NEXT_ENTRY_IDX_WRITE(v, p)                                                       MWRITE_16((uint8_t *)(p) + 2, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_SSID_VECTOR_0_OR_FLOODING_VPORT_READ_G(r, g, idx)                                GROUP_MREAD_16((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 4, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_SSID_VECTOR_0_OR_FLOODING_VPORT_WRITE_G(v, g, idx)                               GROUP_MWRITE_16((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 4, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_SSID_VECTOR_0_OR_FLOODING_VPORT_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_16((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 4, (r), core_id)
#define RDD_IPTV_DDR_CONTEXT_ENTRY_SSID_VECTOR_0_OR_FLOODING_VPORT_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_16((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 4, (v), core_id)
#define RDD_IPTV_DDR_CONTEXT_ENTRY_SSID_VECTOR_0_OR_FLOODING_VPORT_READ(r, p)                                       MREAD_16((uint8_t *)(p) + 4, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_SSID_VECTOR_0_OR_FLOODING_VPORT_WRITE(v, p)                                      MWRITE_16((uint8_t *)(p) + 4, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_SSID_VECTOR_1_READ_G(r, g, idx)                                                  GROUP_MREAD_16((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 6, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_SSID_VECTOR_1_WRITE_G(v, g, idx)                                                 GROUP_MWRITE_16((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 6, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_SSID_VECTOR_1_READ_CORE(r, g, idx, core_id)                                      CORE_MREAD_16((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 6, (r), core_id)
#define RDD_IPTV_DDR_CONTEXT_ENTRY_SSID_VECTOR_1_WRITE_CORE(v, g, idx, core_id)                                     CORE_MWRITE_16((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 6, (v), core_id)
#define RDD_IPTV_DDR_CONTEXT_ENTRY_SSID_VECTOR_1_READ(r, p)                                                         MREAD_16((uint8_t *)(p) + 6, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_SSID_VECTOR_1_WRITE(v, p)                                                        MWRITE_16((uint8_t *)(p) + 6, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_SSID_VECTOR_2_READ_G(r, g, idx)                                                  GROUP_MREAD_16((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 8, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_SSID_VECTOR_2_WRITE_G(v, g, idx)                                                 GROUP_MWRITE_16((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 8, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_SSID_VECTOR_2_READ_CORE(r, g, idx, core_id)                                      CORE_MREAD_16((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 8, (r), core_id)
#define RDD_IPTV_DDR_CONTEXT_ENTRY_SSID_VECTOR_2_WRITE_CORE(v, g, idx, core_id)                                     CORE_MWRITE_16((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 8, (v), core_id)
#define RDD_IPTV_DDR_CONTEXT_ENTRY_SSID_VECTOR_2_READ(r, p)                                                         MREAD_16((uint8_t *)(p) + 8, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_SSID_VECTOR_2_WRITE(v, p)                                                        MWRITE_16((uint8_t *)(p) + 8, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_RDD_VPORT_READ_G(r, g, idx)                                                      GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 10, 0, 5, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_RDD_VPORT_WRITE_G(v, g, idx)                                                     GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 10, 0, 5, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_RDD_VPORT_READ_CORE(r, g, idx, core_id)                                          CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 10, 0, 5, (r), core_id)
#define RDD_IPTV_DDR_CONTEXT_ENTRY_RDD_VPORT_WRITE_CORE(v, g, idx, core_id)                                         CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 10, 0, 5, (v), core_id)
#define RDD_IPTV_DDR_CONTEXT_ENTRY_RDD_VPORT_READ(r, p)                                                             RDP_FIELD_MREAD_8((uint8_t *)(p) + 10, 0, 5, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_RDD_VPORT_WRITE(v, p)                                                            RDP_FIELD_MWRITE_8((uint8_t *)(p) + 10, 0, 5, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_POOL_NUM_READ_G(r, g, idx)                                                       GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 13, 6, 2, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_POOL_NUM_WRITE_G(v, g, idx)                                                      GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 13, 6, 2, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_POOL_NUM_READ_CORE(r, g, idx, core_id)                                           CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 13, 6, 2, (r), core_id)
#define RDD_IPTV_DDR_CONTEXT_ENTRY_POOL_NUM_WRITE_CORE(v, g, idx, core_id)                                          CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 13, 6, 2, (v), core_id)
#define RDD_IPTV_DDR_CONTEXT_ENTRY_POOL_NUM_READ(r, p)                                                              RDP_FIELD_MREAD_8((uint8_t *)(p) + 13, 6, 2, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_POOL_NUM_WRITE(v, p)                                                             RDP_FIELD_MWRITE_8((uint8_t *)(p) + 13, 6, 2, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_REPLICATIONS_READ_G(r, g, idx)                                                   GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 13, 0, 6, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_REPLICATIONS_WRITE_G(v, g, idx)                                                  GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 13, 0, 6, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_REPLICATIONS_READ_CORE(r, g, idx, core_id)                                       CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 13, 0, 6, (r), core_id)
#define RDD_IPTV_DDR_CONTEXT_ENTRY_REPLICATIONS_WRITE_CORE(v, g, idx, core_id)                                      CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 13, 0, 6, (v), core_id)
#define RDD_IPTV_DDR_CONTEXT_ENTRY_REPLICATIONS_READ(r, p)                                                          RDP_FIELD_MREAD_8((uint8_t *)(p) + 13, 0, 6, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_REPLICATIONS_WRITE(v, p)                                                         RDP_FIELD_MWRITE_8((uint8_t *)(p) + 13, 0, 6, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_CNTR_ID_READ_G(r, g, idx)                                                        GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 14, 0, 10, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_CNTR_ID_WRITE_G(v, g, idx)                                                       GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 14, 0, 10, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_CNTR_ID_READ_CORE(r, g, idx, core_id)                                            CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 14, 0, 10, (r), core_id)
#define RDD_IPTV_DDR_CONTEXT_ENTRY_CNTR_ID_WRITE_CORE(v, g, idx, core_id)                                           CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 14, 0, 10, (v), core_id)
#define RDD_IPTV_DDR_CONTEXT_ENTRY_CNTR_ID_READ(r, p)                                                               RDP_FIELD_MREAD_16((uint8_t *)(p) + 14, 0, 10, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_CNTR_ID_WRITE(v, p)                                                              RDP_FIELD_MWRITE_16((uint8_t *)(p) + 14, 0, 10, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_EGRESS_PORTS_VECTOR_READ_G(r, g, idx)                                            GROUP_MREAD_32((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 16, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_EGRESS_PORTS_VECTOR_WRITE_G(v, g, idx)                                           GROUP_MWRITE_32((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 16, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_EGRESS_PORTS_VECTOR_READ_CORE(r, g, idx, core_id)                                CORE_MREAD_32((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 16, (r), core_id)
#define RDD_IPTV_DDR_CONTEXT_ENTRY_EGRESS_PORTS_VECTOR_WRITE_CORE(v, g, idx, core_id)                               CORE_MWRITE_32((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 16, (v), core_id)
#define RDD_IPTV_DDR_CONTEXT_ENTRY_EGRESS_PORTS_VECTOR_READ(r, p)                                                   MREAD_32((uint8_t *)(p) + 16, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_EGRESS_PORTS_VECTOR_WRITE(v, p)                                                  MWRITE_32((uint8_t *)(p) + 16, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_SRC_IP_READ_G(r, g, idx)                                                         GROUP_MREAD_32((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 20, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_SRC_IP_WRITE_G(v, g, idx)                                                        GROUP_MWRITE_32((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 20, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_SRC_IP_READ_CORE(r, g, idx, core_id)                                             CORE_MREAD_32((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 20, (r), core_id)
#define RDD_IPTV_DDR_CONTEXT_ENTRY_SRC_IP_WRITE_CORE(v, g, idx, core_id)                                            CORE_MWRITE_32((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 20, (v), core_id)
#define RDD_IPTV_DDR_CONTEXT_ENTRY_SRC_IP_READ(r, p)                                                                MREAD_32((uint8_t *)(p) + 20, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_SRC_IP_WRITE(v, p)                                                               MWRITE_32((uint8_t *)(p) + 20, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_SRC_IPV6_ADDR_READ_G(r, g, idx, i)                                               GROUP_MREAD_I_8((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 24, i, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_SRC_IPV6_ADDR_WRITE_G(v, g, idx, i)                                              GROUP_MWRITE_I_8((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 24, i, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_SRC_IPV6_ADDR_READ_CORE(r, g, idx, i, core_id)                                   CORE_MREAD_I_8((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 24, i, (r), core_id)
#define RDD_IPTV_DDR_CONTEXT_ENTRY_SRC_IPV6_ADDR_WRITE_CORE(v, g, idx, i, core_id)                                  CORE_MWRITE_I_8((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 24, i, (v), core_id)
#define RDD_IPTV_DDR_CONTEXT_ENTRY_SRC_IPV6_ADDR_READ(r, p, i)                                                      MREAD_I_8((uint8_t *)(p) + 24, i, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_SRC_IPV6_ADDR_WRITE(v, p, i)                                                     MWRITE_I_8((uint8_t *)(p) + 24, i, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_DST_IPV6_ADDR_READ_G(r, g, idx, i)                                               GROUP_MREAD_I_8((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 40, i, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_DST_IPV6_ADDR_WRITE_G(v, g, idx, i)                                              GROUP_MWRITE_I_8((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 40, i, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_DST_IPV6_ADDR_READ_CORE(r, g, idx, i, core_id)                                   CORE_MREAD_I_8((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 40, i, (r), core_id)
#define RDD_IPTV_DDR_CONTEXT_ENTRY_DST_IPV6_ADDR_WRITE_CORE(v, g, idx, i, core_id)                                  CORE_MWRITE_I_8((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 40, i, (v), core_id)
#define RDD_IPTV_DDR_CONTEXT_ENTRY_DST_IPV6_ADDR_READ(r, p, i)                                                      MREAD_I_8((uint8_t *)(p) + 40, i, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_DST_IPV6_ADDR_WRITE(v, p, i)                                                     MWRITE_I_8((uint8_t *)(p) + 40, i, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_RESULT_READ_G(r, g, idx, i)                                                      GROUP_MREAD_I_8((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 56, i, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_RESULT_WRITE_G(v, g, idx, i)                                                     GROUP_MWRITE_I_8((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 56, i, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_RESULT_READ_CORE(r, g, idx, i, core_id)                                          CORE_MREAD_I_8((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 56, i, (r), core_id)
#define RDD_IPTV_DDR_CONTEXT_ENTRY_RESULT_WRITE_CORE(v, g, idx, i, core_id)                                         CORE_MWRITE_I_8((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 56, i, (v), core_id)
#define RDD_IPTV_DDR_CONTEXT_ENTRY_RESULT_READ(r, p, i)                                                             MREAD_I_8((uint8_t *)(p) + 56, i, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_RESULT_WRITE(v, p, i)                                                            MWRITE_I_8((uint8_t *)(p) + 56, i, (v))
/* <<<IPTV_DDR_CONTEXT_ENTRY_STRUCT */


/* >>>IPTV_RULE_BASED_RESULT_STRUCT */
#define RDD_IPTV_RULE_BASED_RESULT_RULE_NUMBER	16
typedef union
    {
    uint8_t word_8[16];
    uint16_t word_16[8];
    uint32_t word_32[4];
    uint64_t dword_64[2];
        struct {
        uint8_t rule[16];
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) IPTV_RULE_BASED_RESULT_STRUCT;

#define RDD_IPTV_RULE_BASED_RESULT_RULE_READ_G(r, g, idx, i)                             GROUP_MREAD_I_8((g), (idx)*sizeof(IPTV_RULE_BASED_RESULT_STRUCT), i, (r))
#define RDD_IPTV_RULE_BASED_RESULT_RULE_WRITE_G(v, g, idx, i)                            GROUP_MWRITE_I_8((g), (idx)*sizeof(IPTV_RULE_BASED_RESULT_STRUCT), i, (v))
#define RDD_IPTV_RULE_BASED_RESULT_RULE_READ_CORE(r, g, idx, i, core_id)                 CORE_MREAD_I_8((g), (idx)*sizeof(IPTV_RULE_BASED_RESULT_STRUCT), i, (r), core_id)
#define RDD_IPTV_RULE_BASED_RESULT_RULE_WRITE_CORE(v, g, idx, i, core_id)                CORE_MWRITE_I_8((g), (idx)*sizeof(IPTV_RULE_BASED_RESULT_STRUCT), i, (v), core_id)
#define RDD_IPTV_RULE_BASED_RESULT_RULE_READ(r, p, i)                                    MREAD_I_8((uint8_t *)(p), i, (r))
#define RDD_IPTV_RULE_BASED_RESULT_RULE_WRITE(v, p, i)                                   MWRITE_I_8((uint8_t *)(p), i, (v))
/* <<<IPTV_RULE_BASED_RESULT_STRUCT */


/* >>>IPTV_GPE_BASED_RESULT_STRUCT */
#define RDD_IPTV_GPE_BASED_RESULT_L3_COMMAND_LIST_NUMBER	20
typedef union
    {
    uint8_t word_8[32];
    uint16_t word_16[16];
    uint32_t word_32[8];
    uint64_t dword_64[4];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	port_buffer_addr_low                                                 	;
        uint8_t	port_buffer_addr_high                                                	;
        uint32_t	reserved0                                                            	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved2                                                            	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_routed                                                            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	mtu                                                                  	:11	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	num_vlan_tags                                                        	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved1                                                            	:17	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	any_inner_vid                                                        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	inner_vid                                                            	:12	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	l3_command_list[RDD_IPTV_GPE_BASED_RESULT_L3_COMMAND_LIST_NUMBER];
#else
        uint32_t	port_buffer_addr_low                                                 	;
        uint32_t	mtu                                                                  	:11	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_routed                                                            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved2                                                            	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved0                                                            	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	port_buffer_addr_high                                                	;
        uint32_t	inner_vid                                                            	:12	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	any_inner_vid                                                        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved1                                                            	:17	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	num_vlan_tags                                                        	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	l3_command_list[RDD_IPTV_GPE_BASED_RESULT_L3_COMMAND_LIST_NUMBER];
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) IPTV_GPE_BASED_RESULT_STRUCT;

#define RDD_IPTV_GPE_BASED_RESULT_PORT_BUFFER_ADDR_LOW_READ_G(r, g, idx)                                 GROUP_MREAD_32((g), (idx)*sizeof(IPTV_GPE_BASED_RESULT_STRUCT), (r))
#define RDD_IPTV_GPE_BASED_RESULT_PORT_BUFFER_ADDR_LOW_WRITE_G(v, g, idx)                                GROUP_MWRITE_32((g), (idx)*sizeof(IPTV_GPE_BASED_RESULT_STRUCT), (v))
#define RDD_IPTV_GPE_BASED_RESULT_PORT_BUFFER_ADDR_LOW_READ_CORE(r, g, idx, core_id)                     CORE_MREAD_32((g), (idx)*sizeof(IPTV_GPE_BASED_RESULT_STRUCT), (r), core_id)
#define RDD_IPTV_GPE_BASED_RESULT_PORT_BUFFER_ADDR_LOW_WRITE_CORE(v, g, idx, core_id)                    CORE_MWRITE_32((g), (idx)*sizeof(IPTV_GPE_BASED_RESULT_STRUCT), (v), core_id)
#define RDD_IPTV_GPE_BASED_RESULT_PORT_BUFFER_ADDR_LOW_READ(r, p)                                        MREAD_32((uint8_t *)(p), (r))
#define RDD_IPTV_GPE_BASED_RESULT_PORT_BUFFER_ADDR_LOW_WRITE(v, p)                                       MWRITE_32((uint8_t *)(p), (v))
#define RDD_IPTV_GPE_BASED_RESULT_PORT_BUFFER_ADDR_HIGH_READ_G(r, g, idx)                                GROUP_MREAD_8((g), (idx)*sizeof(IPTV_GPE_BASED_RESULT_STRUCT) + 4, (r))
#define RDD_IPTV_GPE_BASED_RESULT_PORT_BUFFER_ADDR_HIGH_WRITE_G(v, g, idx)                               GROUP_MWRITE_8((g), (idx)*sizeof(IPTV_GPE_BASED_RESULT_STRUCT) + 4, (v))
#define RDD_IPTV_GPE_BASED_RESULT_PORT_BUFFER_ADDR_HIGH_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_8((g), (idx)*sizeof(IPTV_GPE_BASED_RESULT_STRUCT) + 4, (r), core_id)
#define RDD_IPTV_GPE_BASED_RESULT_PORT_BUFFER_ADDR_HIGH_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_8((g), (idx)*sizeof(IPTV_GPE_BASED_RESULT_STRUCT) + 4, (v), core_id)
#define RDD_IPTV_GPE_BASED_RESULT_PORT_BUFFER_ADDR_HIGH_READ(r, p)                                       MREAD_8((uint8_t *)(p) + 4, (r))
#define RDD_IPTV_GPE_BASED_RESULT_PORT_BUFFER_ADDR_HIGH_WRITE(v, p)                                      MWRITE_8((uint8_t *)(p) + 4, (v))
#define RDD_IPTV_GPE_BASED_RESULT_IS_ROUTED_READ_G(r, g, idx)                                            GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(IPTV_GPE_BASED_RESULT_STRUCT) + 6, 3, 1, (r))
#define RDD_IPTV_GPE_BASED_RESULT_IS_ROUTED_WRITE_G(v, g, idx)                                           GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(IPTV_GPE_BASED_RESULT_STRUCT) + 6, 3, 1, (v))
#define RDD_IPTV_GPE_BASED_RESULT_IS_ROUTED_READ_CORE(r, g, idx, core_id)                                CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(IPTV_GPE_BASED_RESULT_STRUCT) + 6, 3, 1, (r), core_id)
#define RDD_IPTV_GPE_BASED_RESULT_IS_ROUTED_WRITE_CORE(v, g, idx, core_id)                               CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(IPTV_GPE_BASED_RESULT_STRUCT) + 6, 3, 1, (v), core_id)
#define RDD_IPTV_GPE_BASED_RESULT_IS_ROUTED_READ(r, p)                                                   RDP_FIELD_MREAD_8((uint8_t *)(p) + 6, 3, 1, (r))
#define RDD_IPTV_GPE_BASED_RESULT_IS_ROUTED_WRITE(v, p)                                                  RDP_FIELD_MWRITE_8((uint8_t *)(p) + 6, 3, 1, (v))
#define RDD_IPTV_GPE_BASED_RESULT_MTU_READ_G(r, g, idx)                                                  GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(IPTV_GPE_BASED_RESULT_STRUCT) + 6, 0, 11, (r))
#define RDD_IPTV_GPE_BASED_RESULT_MTU_WRITE_G(v, g, idx)                                                 GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(IPTV_GPE_BASED_RESULT_STRUCT) + 6, 0, 11, (v))
#define RDD_IPTV_GPE_BASED_RESULT_MTU_READ_CORE(r, g, idx, core_id)                                      CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(IPTV_GPE_BASED_RESULT_STRUCT) + 6, 0, 11, (r), core_id)
#define RDD_IPTV_GPE_BASED_RESULT_MTU_WRITE_CORE(v, g, idx, core_id)                                     CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(IPTV_GPE_BASED_RESULT_STRUCT) + 6, 0, 11, (v), core_id)
#define RDD_IPTV_GPE_BASED_RESULT_MTU_READ(r, p)                                                         RDP_FIELD_MREAD_16((uint8_t *)(p) + 6, 0, 11, (r))
#define RDD_IPTV_GPE_BASED_RESULT_MTU_WRITE(v, p)                                                        RDP_FIELD_MWRITE_16((uint8_t *)(p) + 6, 0, 11, (v))
#define RDD_IPTV_GPE_BASED_RESULT_NUM_VLAN_TAGS_READ_G(r, g, idx)                                        GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(IPTV_GPE_BASED_RESULT_STRUCT) + 8, 6, 2, (r))
#define RDD_IPTV_GPE_BASED_RESULT_NUM_VLAN_TAGS_WRITE_G(v, g, idx)                                       GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(IPTV_GPE_BASED_RESULT_STRUCT) + 8, 6, 2, (v))
#define RDD_IPTV_GPE_BASED_RESULT_NUM_VLAN_TAGS_READ_CORE(r, g, idx, core_id)                            CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(IPTV_GPE_BASED_RESULT_STRUCT) + 8, 6, 2, (r), core_id)
#define RDD_IPTV_GPE_BASED_RESULT_NUM_VLAN_TAGS_WRITE_CORE(v, g, idx, core_id)                           CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(IPTV_GPE_BASED_RESULT_STRUCT) + 8, 6, 2, (v), core_id)
#define RDD_IPTV_GPE_BASED_RESULT_NUM_VLAN_TAGS_READ(r, p)                                               RDP_FIELD_MREAD_8((uint8_t *)(p) + 8, 6, 2, (r))
#define RDD_IPTV_GPE_BASED_RESULT_NUM_VLAN_TAGS_WRITE(v, p)                                              RDP_FIELD_MWRITE_8((uint8_t *)(p) + 8, 6, 2, (v))
#define RDD_IPTV_GPE_BASED_RESULT_ANY_INNER_VID_READ_G(r, g, idx)                                        GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(IPTV_GPE_BASED_RESULT_STRUCT) + 10, 4, 1, (r))
#define RDD_IPTV_GPE_BASED_RESULT_ANY_INNER_VID_WRITE_G(v, g, idx)                                       GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(IPTV_GPE_BASED_RESULT_STRUCT) + 10, 4, 1, (v))
#define RDD_IPTV_GPE_BASED_RESULT_ANY_INNER_VID_READ_CORE(r, g, idx, core_id)                            CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(IPTV_GPE_BASED_RESULT_STRUCT) + 10, 4, 1, (r), core_id)
#define RDD_IPTV_GPE_BASED_RESULT_ANY_INNER_VID_WRITE_CORE(v, g, idx, core_id)                           CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(IPTV_GPE_BASED_RESULT_STRUCT) + 10, 4, 1, (v), core_id)
#define RDD_IPTV_GPE_BASED_RESULT_ANY_INNER_VID_READ(r, p)                                               RDP_FIELD_MREAD_8((uint8_t *)(p) + 10, 4, 1, (r))
#define RDD_IPTV_GPE_BASED_RESULT_ANY_INNER_VID_WRITE(v, p)                                              RDP_FIELD_MWRITE_8((uint8_t *)(p) + 10, 4, 1, (v))
#define RDD_IPTV_GPE_BASED_RESULT_INNER_VID_READ_G(r, g, idx)                                            GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(IPTV_GPE_BASED_RESULT_STRUCT) + 10, 0, 12, (r))
#define RDD_IPTV_GPE_BASED_RESULT_INNER_VID_WRITE_G(v, g, idx)                                           GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(IPTV_GPE_BASED_RESULT_STRUCT) + 10, 0, 12, (v))
#define RDD_IPTV_GPE_BASED_RESULT_INNER_VID_READ_CORE(r, g, idx, core_id)                                CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(IPTV_GPE_BASED_RESULT_STRUCT) + 10, 0, 12, (r), core_id)
#define RDD_IPTV_GPE_BASED_RESULT_INNER_VID_WRITE_CORE(v, g, idx, core_id)                               CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(IPTV_GPE_BASED_RESULT_STRUCT) + 10, 0, 12, (v), core_id)
#define RDD_IPTV_GPE_BASED_RESULT_INNER_VID_READ(r, p)                                                   RDP_FIELD_MREAD_16((uint8_t *)(p) + 10, 0, 12, (r))
#define RDD_IPTV_GPE_BASED_RESULT_INNER_VID_WRITE(v, p)                                                  RDP_FIELD_MWRITE_16((uint8_t *)(p) + 10, 0, 12, (v))
#define RDD_IPTV_GPE_BASED_RESULT_L3_COMMAND_LIST_READ_G(r, g, idx, i)                                   GROUP_MREAD_I_8((g), (idx)*sizeof(IPTV_GPE_BASED_RESULT_STRUCT) + 12, i, (r))
#define RDD_IPTV_GPE_BASED_RESULT_L3_COMMAND_LIST_WRITE_G(v, g, idx, i)                                  GROUP_MWRITE_I_8((g), (idx)*sizeof(IPTV_GPE_BASED_RESULT_STRUCT) + 12, i, (v))
#define RDD_IPTV_GPE_BASED_RESULT_L3_COMMAND_LIST_READ_CORE(r, g, idx, i, core_id)                       CORE_MREAD_I_8((g), (idx)*sizeof(IPTV_GPE_BASED_RESULT_STRUCT) + 12, i, (r), core_id)
#define RDD_IPTV_GPE_BASED_RESULT_L3_COMMAND_LIST_WRITE_CORE(v, g, idx, i, core_id)                      CORE_MWRITE_I_8((g), (idx)*sizeof(IPTV_GPE_BASED_RESULT_STRUCT) + 12, i, (v), core_id)
#define RDD_IPTV_GPE_BASED_RESULT_L3_COMMAND_LIST_READ(r, p, i)                                          MREAD_I_8((uint8_t *)(p) + 12, i, (r))
#define RDD_IPTV_GPE_BASED_RESULT_L3_COMMAND_LIST_WRITE(v, p, i)                                         MWRITE_I_8((uint8_t *)(p) + 12, i, (v))
/* <<<IPTV_GPE_BASED_RESULT_STRUCT */


/* >>>IPTV_CLASSIFICATION_CFG_ENTRY_STRUCT */
typedef union
    {
    uint8_t word_8[1];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint8_t	da_prefix_mode_mac	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	da_prefix_mode_ip 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	iptv_en           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	reserved1         	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#else
        uint8_t	reserved1         	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	iptv_en           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	da_prefix_mode_ip 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	da_prefix_mode_mac	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } IPTV_CLASSIFICATION_CFG_ENTRY_STRUCT;

#define RDD_IPTV_CLASSIFICATION_CFG_ENTRY_DA_PREFIX_MODE_MAC_READ_G(r, g, idx)                                GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(IPTV_CLASSIFICATION_CFG_ENTRY_STRUCT), 7, 1, (r))
#define RDD_IPTV_CLASSIFICATION_CFG_ENTRY_DA_PREFIX_MODE_MAC_WRITE_G(v, g, idx)                               GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(IPTV_CLASSIFICATION_CFG_ENTRY_STRUCT), 7, 1, (v))
#define RDD_IPTV_CLASSIFICATION_CFG_ENTRY_DA_PREFIX_MODE_MAC_READ_CORE(r, g, idx, core_id)                    CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(IPTV_CLASSIFICATION_CFG_ENTRY_STRUCT), 7, 1, (r), core_id)
#define RDD_IPTV_CLASSIFICATION_CFG_ENTRY_DA_PREFIX_MODE_MAC_WRITE_CORE(v, g, idx, core_id)                   CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(IPTV_CLASSIFICATION_CFG_ENTRY_STRUCT), 7, 1, (v), core_id)
#define RDD_IPTV_CLASSIFICATION_CFG_ENTRY_DA_PREFIX_MODE_MAC_READ(r, p)                                       RDP_FIELD_MREAD_8((uint8_t *)(p), 7, 1, (r))
#define RDD_IPTV_CLASSIFICATION_CFG_ENTRY_DA_PREFIX_MODE_MAC_WRITE(v, p)                                      RDP_FIELD_MWRITE_8((uint8_t *)(p), 7, 1, (v))
#define RDD_IPTV_CLASSIFICATION_CFG_ENTRY_DA_PREFIX_MODE_IP_READ_G(r, g, idx)                                 GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(IPTV_CLASSIFICATION_CFG_ENTRY_STRUCT), 6, 1, (r))
#define RDD_IPTV_CLASSIFICATION_CFG_ENTRY_DA_PREFIX_MODE_IP_WRITE_G(v, g, idx)                                GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(IPTV_CLASSIFICATION_CFG_ENTRY_STRUCT), 6, 1, (v))
#define RDD_IPTV_CLASSIFICATION_CFG_ENTRY_DA_PREFIX_MODE_IP_READ_CORE(r, g, idx, core_id)                     CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(IPTV_CLASSIFICATION_CFG_ENTRY_STRUCT), 6, 1, (r), core_id)
#define RDD_IPTV_CLASSIFICATION_CFG_ENTRY_DA_PREFIX_MODE_IP_WRITE_CORE(v, g, idx, core_id)                    CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(IPTV_CLASSIFICATION_CFG_ENTRY_STRUCT), 6, 1, (v), core_id)
#define RDD_IPTV_CLASSIFICATION_CFG_ENTRY_DA_PREFIX_MODE_IP_READ(r, p)                                        RDP_FIELD_MREAD_8((uint8_t *)(p), 6, 1, (r))
#define RDD_IPTV_CLASSIFICATION_CFG_ENTRY_DA_PREFIX_MODE_IP_WRITE(v, p)                                       RDP_FIELD_MWRITE_8((uint8_t *)(p), 6, 1, (v))
#define RDD_IPTV_CLASSIFICATION_CFG_ENTRY_IPTV_EN_READ_G(r, g, idx)                                           GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(IPTV_CLASSIFICATION_CFG_ENTRY_STRUCT), 5, 1, (r))
#define RDD_IPTV_CLASSIFICATION_CFG_ENTRY_IPTV_EN_WRITE_G(v, g, idx)                                          GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(IPTV_CLASSIFICATION_CFG_ENTRY_STRUCT), 5, 1, (v))
#define RDD_IPTV_CLASSIFICATION_CFG_ENTRY_IPTV_EN_READ_CORE(r, g, idx, core_id)                               CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(IPTV_CLASSIFICATION_CFG_ENTRY_STRUCT), 5, 1, (r), core_id)
#define RDD_IPTV_CLASSIFICATION_CFG_ENTRY_IPTV_EN_WRITE_CORE(v, g, idx, core_id)                              CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(IPTV_CLASSIFICATION_CFG_ENTRY_STRUCT), 5, 1, (v), core_id)
#define RDD_IPTV_CLASSIFICATION_CFG_ENTRY_IPTV_EN_READ(r, p)                                                  RDP_FIELD_MREAD_8((uint8_t *)(p), 5, 1, (r))
#define RDD_IPTV_CLASSIFICATION_CFG_ENTRY_IPTV_EN_WRITE(v, p)                                                 RDP_FIELD_MWRITE_8((uint8_t *)(p), 5, 1, (v))
/* <<<IPTV_CLASSIFICATION_CFG_ENTRY_STRUCT */


/* >>>MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_STRUCT */
#define RDD_MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_CLIENT_IDX_VECTOR_NUMBER	8
typedef union
    {
    uint8_t word_8[60];
    uint16_t word_16[30];
    uint32_t word_32[15];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	natc_control                                                                         	;
        uint8_t	q_bytes_cnt                                                                          	;
        uint32_t	reserved0                                                                            	:24	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	pathstat_idx                                                                         	;
        uint32_t	is_service_queue                                                                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	service_queue                                                                        	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_routed                                                                            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved1                                                                            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	fwd_and_trap                                                                         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved2                                                                            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved3                                                                            	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_ctx_ext                                                                           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved4                                                                            	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	wifi_ssid_vector_0                                                                   	;
        uint16_t	wifi_ssid_vector_1                                                                   	;
        uint16_t	wifi_ssid_vector_2                                                                   	;
        uint16_t	max_pkt_len                                                                          	;
        uint8_t	reserved5                                                                            	;
        uint32_t	policer_enable                                                                       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	policer_id                                                                           	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved6                                                                            	:15	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved7                                                                            	;
        uint32_t	client_idx_vector[RDD_MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_CLIENT_IDX_VECTOR_NUMBER];
#else
        uint32_t	natc_control                                                                         	;
        uint32_t	reserved0                                                                            	:24	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	q_bytes_cnt                                                                          	;
        uint32_t	reserved4                                                                            	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_ctx_ext                                                                           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved3                                                                            	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved2                                                                            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	fwd_and_trap                                                                         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved1                                                                            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_routed                                                                            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	service_queue                                                                        	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_service_queue                                                                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	pathstat_idx                                                                         	;
        uint16_t	wifi_ssid_vector_1                                                                   	;
        uint16_t	wifi_ssid_vector_0                                                                   	;
        uint16_t	max_pkt_len                                                                          	;
        uint16_t	wifi_ssid_vector_2                                                                   	;
        uint32_t	reserved6                                                                            	:15	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	policer_id                                                                           	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	policer_enable                                                                       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	reserved5                                                                            	;
        uint32_t	reserved7                                                                            	;
        uint32_t	client_idx_vector[RDD_MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_CLIENT_IDX_VECTOR_NUMBER];
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(4))) MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_STRUCT;

#define RDD_MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_NATC_CONTROL_READ_G(r, g, idx)                                      GROUP_MREAD_32((g), (idx)*sizeof(MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_STRUCT), (r))
#define RDD_MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_NATC_CONTROL_WRITE_G(v, g, idx)                                     GROUP_MWRITE_32((g), (idx)*sizeof(MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_STRUCT), (v))
#define RDD_MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_NATC_CONTROL_READ_CORE(r, g, idx, core_id)                          CORE_MREAD_32((g), (idx)*sizeof(MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_STRUCT), (r), core_id)
#define RDD_MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_NATC_CONTROL_WRITE_CORE(v, g, idx, core_id)                         CORE_MWRITE_32((g), (idx)*sizeof(MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_STRUCT), (v), core_id)
#define RDD_MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_NATC_CONTROL_READ(r, p)                                             MREAD_32((uint8_t *)(p), (r))
#define RDD_MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_NATC_CONTROL_WRITE(v, p)                                            MWRITE_32((uint8_t *)(p), (v))
#define RDD_MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_Q_BYTES_CNT_READ_G(r, g, idx)                                       GROUP_MREAD_8((g), (idx)*sizeof(MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 4, (r))
#define RDD_MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_Q_BYTES_CNT_WRITE_G(v, g, idx)                                      GROUP_MWRITE_8((g), (idx)*sizeof(MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 4, (v))
#define RDD_MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_Q_BYTES_CNT_READ_CORE(r, g, idx, core_id)                           CORE_MREAD_8((g), (idx)*sizeof(MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 4, (r), core_id)
#define RDD_MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_Q_BYTES_CNT_WRITE_CORE(v, g, idx, core_id)                          CORE_MWRITE_8((g), (idx)*sizeof(MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 4, (v), core_id)
#define RDD_MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_Q_BYTES_CNT_READ(r, p)                                              MREAD_8((uint8_t *)(p) + 4, (r))
#define RDD_MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_Q_BYTES_CNT_WRITE(v, p)                                             MWRITE_8((uint8_t *)(p) + 4, (v))
#define RDD_MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_PATHSTAT_IDX_READ_G(r, g, idx)                                      GROUP_MREAD_8((g), (idx)*sizeof(MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 8, (r))
#define RDD_MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_PATHSTAT_IDX_WRITE_G(v, g, idx)                                     GROUP_MWRITE_8((g), (idx)*sizeof(MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 8, (v))
#define RDD_MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_PATHSTAT_IDX_READ_CORE(r, g, idx, core_id)                          CORE_MREAD_8((g), (idx)*sizeof(MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 8, (r), core_id)
#define RDD_MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_PATHSTAT_IDX_WRITE_CORE(v, g, idx, core_id)                         CORE_MWRITE_8((g), (idx)*sizeof(MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 8, (v), core_id)
#define RDD_MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_PATHSTAT_IDX_READ(r, p)                                             MREAD_8((uint8_t *)(p) + 8, (r))
#define RDD_MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_PATHSTAT_IDX_WRITE(v, p)                                            MWRITE_8((uint8_t *)(p) + 8, (v))
#define RDD_MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_IS_SERVICE_QUEUE_READ_G(r, g, idx)                                  GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 9, 7, 1, (r))
#define RDD_MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_IS_SERVICE_QUEUE_WRITE_G(v, g, idx)                                 GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 9, 7, 1, (v))
#define RDD_MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_IS_SERVICE_QUEUE_READ_CORE(r, g, idx, core_id)                      CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 9, 7, 1, (r), core_id)
#define RDD_MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_IS_SERVICE_QUEUE_WRITE_CORE(v, g, idx, core_id)                     CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 9, 7, 1, (v), core_id)
#define RDD_MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_IS_SERVICE_QUEUE_READ(r, p)                                         RDP_FIELD_MREAD_8((uint8_t *)(p) + 9, 7, 1, (r))
#define RDD_MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_IS_SERVICE_QUEUE_WRITE(v, p)                                        RDP_FIELD_MWRITE_8((uint8_t *)(p) + 9, 7, 1, (v))
#define RDD_MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_SERVICE_QUEUE_READ_G(r, g, idx)                                     GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 9, 2, 5, (r))
#define RDD_MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_SERVICE_QUEUE_WRITE_G(v, g, idx)                                    GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 9, 2, 5, (v))
#define RDD_MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_SERVICE_QUEUE_READ_CORE(r, g, idx, core_id)                         CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 9, 2, 5, (r), core_id)
#define RDD_MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_SERVICE_QUEUE_WRITE_CORE(v, g, idx, core_id)                        CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 9, 2, 5, (v), core_id)
#define RDD_MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_SERVICE_QUEUE_READ(r, p)                                            RDP_FIELD_MREAD_8((uint8_t *)(p) + 9, 2, 5, (r))
#define RDD_MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_SERVICE_QUEUE_WRITE(v, p)                                           RDP_FIELD_MWRITE_8((uint8_t *)(p) + 9, 2, 5, (v))
#define RDD_MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_IS_ROUTED_READ_G(r, g, idx)                                         GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 9, 1, 1, (r))
#define RDD_MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_IS_ROUTED_WRITE_G(v, g, idx)                                        GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 9, 1, 1, (v))
#define RDD_MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_IS_ROUTED_READ_CORE(r, g, idx, core_id)                             CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 9, 1, 1, (r), core_id)
#define RDD_MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_IS_ROUTED_WRITE_CORE(v, g, idx, core_id)                            CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 9, 1, 1, (v), core_id)
#define RDD_MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_IS_ROUTED_READ(r, p)                                                RDP_FIELD_MREAD_8((uint8_t *)(p) + 9, 1, 1, (r))
#define RDD_MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_IS_ROUTED_WRITE(v, p)                                               RDP_FIELD_MWRITE_8((uint8_t *)(p) + 9, 1, 1, (v))
#define RDD_MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_FWD_AND_TRAP_READ_G(r, g, idx)                                      GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 10, 7, 1, (r))
#define RDD_MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_FWD_AND_TRAP_WRITE_G(v, g, idx)                                     GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 10, 7, 1, (v))
#define RDD_MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_FWD_AND_TRAP_READ_CORE(r, g, idx, core_id)                          CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 10, 7, 1, (r), core_id)
#define RDD_MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_FWD_AND_TRAP_WRITE_CORE(v, g, idx, core_id)                         CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 10, 7, 1, (v), core_id)
#define RDD_MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_FWD_AND_TRAP_READ(r, p)                                             RDP_FIELD_MREAD_8((uint8_t *)(p) + 10, 7, 1, (r))
#define RDD_MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_FWD_AND_TRAP_WRITE(v, p)                                            RDP_FIELD_MWRITE_8((uint8_t *)(p) + 10, 7, 1, (v))
#define RDD_MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_IS_CTX_EXT_READ_G(r, g, idx)                                        GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 11, 7, 1, (r))
#define RDD_MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_IS_CTX_EXT_WRITE_G(v, g, idx)                                       GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 11, 7, 1, (v))
#define RDD_MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_IS_CTX_EXT_READ_CORE(r, g, idx, core_id)                            CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 11, 7, 1, (r), core_id)
#define RDD_MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_IS_CTX_EXT_WRITE_CORE(v, g, idx, core_id)                           CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 11, 7, 1, (v), core_id)
#define RDD_MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_IS_CTX_EXT_READ(r, p)                                               RDP_FIELD_MREAD_8((uint8_t *)(p) + 11, 7, 1, (r))
#define RDD_MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_IS_CTX_EXT_WRITE(v, p)                                              RDP_FIELD_MWRITE_8((uint8_t *)(p) + 11, 7, 1, (v))
#define RDD_MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_WIFI_SSID_VECTOR_0_READ_G(r, g, idx)                                GROUP_MREAD_16((g), (idx)*sizeof(MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 12, (r))
#define RDD_MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_WIFI_SSID_VECTOR_0_WRITE_G(v, g, idx)                               GROUP_MWRITE_16((g), (idx)*sizeof(MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 12, (v))
#define RDD_MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_WIFI_SSID_VECTOR_0_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_16((g), (idx)*sizeof(MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 12, (r), core_id)
#define RDD_MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_WIFI_SSID_VECTOR_0_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_16((g), (idx)*sizeof(MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 12, (v), core_id)
#define RDD_MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_WIFI_SSID_VECTOR_0_READ(r, p)                                       MREAD_16((uint8_t *)(p) + 12, (r))
#define RDD_MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_WIFI_SSID_VECTOR_0_WRITE(v, p)                                      MWRITE_16((uint8_t *)(p) + 12, (v))
#define RDD_MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_WIFI_SSID_VECTOR_1_READ_G(r, g, idx)                                GROUP_MREAD_16((g), (idx)*sizeof(MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 14, (r))
#define RDD_MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_WIFI_SSID_VECTOR_1_WRITE_G(v, g, idx)                               GROUP_MWRITE_16((g), (idx)*sizeof(MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 14, (v))
#define RDD_MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_WIFI_SSID_VECTOR_1_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_16((g), (idx)*sizeof(MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 14, (r), core_id)
#define RDD_MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_WIFI_SSID_VECTOR_1_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_16((g), (idx)*sizeof(MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 14, (v), core_id)
#define RDD_MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_WIFI_SSID_VECTOR_1_READ(r, p)                                       MREAD_16((uint8_t *)(p) + 14, (r))
#define RDD_MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_WIFI_SSID_VECTOR_1_WRITE(v, p)                                      MWRITE_16((uint8_t *)(p) + 14, (v))
#define RDD_MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_WIFI_SSID_VECTOR_2_READ_G(r, g, idx)                                GROUP_MREAD_16((g), (idx)*sizeof(MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 16, (r))
#define RDD_MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_WIFI_SSID_VECTOR_2_WRITE_G(v, g, idx)                               GROUP_MWRITE_16((g), (idx)*sizeof(MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 16, (v))
#define RDD_MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_WIFI_SSID_VECTOR_2_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_16((g), (idx)*sizeof(MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 16, (r), core_id)
#define RDD_MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_WIFI_SSID_VECTOR_2_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_16((g), (idx)*sizeof(MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 16, (v), core_id)
#define RDD_MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_WIFI_SSID_VECTOR_2_READ(r, p)                                       MREAD_16((uint8_t *)(p) + 16, (r))
#define RDD_MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_WIFI_SSID_VECTOR_2_WRITE(v, p)                                      MWRITE_16((uint8_t *)(p) + 16, (v))
#define RDD_MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_MAX_PKT_LEN_READ_G(r, g, idx)                                       GROUP_MREAD_16((g), (idx)*sizeof(MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 18, (r))
#define RDD_MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_MAX_PKT_LEN_WRITE_G(v, g, idx)                                      GROUP_MWRITE_16((g), (idx)*sizeof(MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 18, (v))
#define RDD_MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_MAX_PKT_LEN_READ_CORE(r, g, idx, core_id)                           CORE_MREAD_16((g), (idx)*sizeof(MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 18, (r), core_id)
#define RDD_MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_MAX_PKT_LEN_WRITE_CORE(v, g, idx, core_id)                          CORE_MWRITE_16((g), (idx)*sizeof(MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 18, (v), core_id)
#define RDD_MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_MAX_PKT_LEN_READ(r, p)                                              MREAD_16((uint8_t *)(p) + 18, (r))
#define RDD_MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_MAX_PKT_LEN_WRITE(v, p)                                             MWRITE_16((uint8_t *)(p) + 18, (v))
#define RDD_MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_POLICER_ENABLE_READ_G(r, g, idx)                                    GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 21, 7, 1, (r))
#define RDD_MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_POLICER_ENABLE_WRITE_G(v, g, idx)                                   GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 21, 7, 1, (v))
#define RDD_MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_POLICER_ENABLE_READ_CORE(r, g, idx, core_id)                        CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 21, 7, 1, (r), core_id)
#define RDD_MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_POLICER_ENABLE_WRITE_CORE(v, g, idx, core_id)                       CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 21, 7, 1, (v), core_id)
#define RDD_MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_POLICER_ENABLE_READ(r, p)                                           RDP_FIELD_MREAD_8((uint8_t *)(p) + 21, 7, 1, (r))
#define RDD_MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_POLICER_ENABLE_WRITE(v, p)                                          RDP_FIELD_MWRITE_8((uint8_t *)(p) + 21, 7, 1, (v))
#define RDD_MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_POLICER_ID_READ_G(r, g, idx)                                        GROUP_RDP_FIELD_MREAD_32((g), (idx)*sizeof(MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 20, 15, 8, (r))
#define RDD_MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_POLICER_ID_WRITE_G(v, g, idx)                                       GROUP_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 20, 15, 8, (v))
#define RDD_MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_POLICER_ID_READ_CORE(r, g, idx, core_id)                            CORE_RDP_FIELD_MREAD_32((g), (idx)*sizeof(MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 20, 15, 8, (r), core_id)
#define RDD_MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_POLICER_ID_WRITE_CORE(v, g, idx, core_id)                           CORE_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 20, 15, 8, (v), core_id)
#define RDD_MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_POLICER_ID_READ(r, p)                                               RDP_FIELD_MREAD_32((uint8_t *)(p) + 20, 15, 8, (r))
#define RDD_MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_POLICER_ID_WRITE(v, p)                                              RDP_FIELD_MWRITE_32((uint8_t *)(p) + 20, 15, 8, (v))
#define RDD_MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_CLIENT_IDX_VECTOR_READ_G(r, g, idx, i)                              GROUP_MREAD_I_32((g), (idx)*sizeof(MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 28, i, (r))
#define RDD_MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_CLIENT_IDX_VECTOR_WRITE_G(v, g, idx, i)                             GROUP_MWRITE_I_32((g), (idx)*sizeof(MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 28, i, (v))
#define RDD_MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_CLIENT_IDX_VECTOR_READ_CORE(r, g, idx, i, core_id)                  CORE_MREAD_I_32((g), (idx)*sizeof(MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 28, i, (r), core_id)
#define RDD_MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_CLIENT_IDX_VECTOR_WRITE_CORE(v, g, idx, i, core_id)                 CORE_MWRITE_I_32((g), (idx)*sizeof(MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 28, i, (v), core_id)
#define RDD_MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_CLIENT_IDX_VECTOR_READ(r, p, i)                                     MREAD_I_32((uint8_t *)(p) + 28, i, (r))
#define RDD_MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_CLIENT_IDX_VECTOR_WRITE(v, p, i)                                    MWRITE_I_32((uint8_t *)(p) + 28, i, (v))
/* <<<MASTER_MC_FLOW_CACHE_CONTEXT_ENTRY_STRUCT */


/* >>>MULTICAST_KEY_MASK_ENTRY_STRUCT */
typedef union
    {
    uint8_t word_8[4];
    uint16_t word_16[2];
    uint32_t word_32[1];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint16_t	vlan_mask 	;
        uint16_t	etype_mask	;
#else
        uint16_t	etype_mask	;
        uint16_t	vlan_mask 	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(4))) MULTICAST_KEY_MASK_ENTRY_STRUCT;

#define RDD_MULTICAST_KEY_MASK_ENTRY_VLAN_MASK_READ_G(r, g, idx)                                 GROUP_MREAD_16((g), (idx)*sizeof(MULTICAST_KEY_MASK_ENTRY_STRUCT), (r))
#define RDD_MULTICAST_KEY_MASK_ENTRY_VLAN_MASK_WRITE_G(v, g, idx)                                GROUP_MWRITE_16((g), (idx)*sizeof(MULTICAST_KEY_MASK_ENTRY_STRUCT), (v))
#define RDD_MULTICAST_KEY_MASK_ENTRY_VLAN_MASK_READ_CORE(r, g, idx, core_id)                     CORE_MREAD_16((g), (idx)*sizeof(MULTICAST_KEY_MASK_ENTRY_STRUCT), (r), core_id)
#define RDD_MULTICAST_KEY_MASK_ENTRY_VLAN_MASK_WRITE_CORE(v, g, idx, core_id)                    CORE_MWRITE_16((g), (idx)*sizeof(MULTICAST_KEY_MASK_ENTRY_STRUCT), (v), core_id)
#define RDD_MULTICAST_KEY_MASK_ENTRY_VLAN_MASK_READ(r, p)                                        MREAD_16((uint8_t *)(p), (r))
#define RDD_MULTICAST_KEY_MASK_ENTRY_VLAN_MASK_WRITE(v, p)                                       MWRITE_16((uint8_t *)(p), (v))
#define RDD_MULTICAST_KEY_MASK_ENTRY_ETYPE_MASK_READ_G(r, g, idx)                                GROUP_MREAD_16((g), (idx)*sizeof(MULTICAST_KEY_MASK_ENTRY_STRUCT) + 2, (r))
#define RDD_MULTICAST_KEY_MASK_ENTRY_ETYPE_MASK_WRITE_G(v, g, idx)                               GROUP_MWRITE_16((g), (idx)*sizeof(MULTICAST_KEY_MASK_ENTRY_STRUCT) + 2, (v))
#define RDD_MULTICAST_KEY_MASK_ENTRY_ETYPE_MASK_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_16((g), (idx)*sizeof(MULTICAST_KEY_MASK_ENTRY_STRUCT) + 2, (r), core_id)
#define RDD_MULTICAST_KEY_MASK_ENTRY_ETYPE_MASK_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_16((g), (idx)*sizeof(MULTICAST_KEY_MASK_ENTRY_STRUCT) + 2, (v), core_id)
#define RDD_MULTICAST_KEY_MASK_ENTRY_ETYPE_MASK_READ(r, p)                                       MREAD_16((uint8_t *)(p) + 2, (r))
#define RDD_MULTICAST_KEY_MASK_ENTRY_ETYPE_MASK_WRITE(v, p)                                      MWRITE_16((uint8_t *)(p) + 2, (v))
/* <<<MULTICAST_KEY_MASK_ENTRY_STRUCT */


/* >>>NAT_CACHE_VLAN_ACTION_KEY_ENTRY_STRUCT */
typedef union
    {
    uint8_t word_8[16];
    uint16_t word_16[8];
    uint32_t word_32[4];
    uint64_t dword_64[2];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	reserved0   	;
        uint32_t	reserved1   	;
        uint32_t	reserved2   	;
        uint16_t	rule        	;
        uint32_t	valid       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	sub_table_id	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	extension   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved3   	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	port        	;
#else
        uint32_t	reserved0   	;
        uint32_t	reserved1   	;
        uint32_t	reserved2   	;
        uint8_t	port        	;
        uint32_t	reserved3   	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	extension   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	sub_table_id	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	valid       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	rule        	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) NAT_CACHE_VLAN_ACTION_KEY_ENTRY_STRUCT;

#define RDD_NAT_CACHE_VLAN_ACTION_KEY_ENTRY_RULE_READ_G(r, g, idx)                                        GROUP_MREAD_16((g), (idx)*sizeof(NAT_CACHE_VLAN_ACTION_KEY_ENTRY_STRUCT) + 12, (r))
#define RDD_NAT_CACHE_VLAN_ACTION_KEY_ENTRY_RULE_WRITE_G(v, g, idx)                                       GROUP_MWRITE_16((g), (idx)*sizeof(NAT_CACHE_VLAN_ACTION_KEY_ENTRY_STRUCT) + 12, (v))
#define RDD_NAT_CACHE_VLAN_ACTION_KEY_ENTRY_RULE_READ_CORE(r, g, idx, core_id)                            CORE_MREAD_16((g), (idx)*sizeof(NAT_CACHE_VLAN_ACTION_KEY_ENTRY_STRUCT) + 12, (r), core_id)
#define RDD_NAT_CACHE_VLAN_ACTION_KEY_ENTRY_RULE_WRITE_CORE(v, g, idx, core_id)                           CORE_MWRITE_16((g), (idx)*sizeof(NAT_CACHE_VLAN_ACTION_KEY_ENTRY_STRUCT) + 12, (v), core_id)
#define RDD_NAT_CACHE_VLAN_ACTION_KEY_ENTRY_RULE_READ(r, p)                                               MREAD_16((uint8_t *)(p) + 12, (r))
#define RDD_NAT_CACHE_VLAN_ACTION_KEY_ENTRY_RULE_WRITE(v, p)                                              MWRITE_16((uint8_t *)(p) + 12, (v))
#define RDD_NAT_CACHE_VLAN_ACTION_KEY_ENTRY_VALID_READ_G(r, g, idx)                                       GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_VLAN_ACTION_KEY_ENTRY_STRUCT) + 14, 7, 1, (r))
#define RDD_NAT_CACHE_VLAN_ACTION_KEY_ENTRY_VALID_WRITE_G(v, g, idx)                                      GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_VLAN_ACTION_KEY_ENTRY_STRUCT) + 14, 7, 1, (v))
#define RDD_NAT_CACHE_VLAN_ACTION_KEY_ENTRY_VALID_READ_CORE(r, g, idx, core_id)                           CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_VLAN_ACTION_KEY_ENTRY_STRUCT) + 14, 7, 1, (r), core_id)
#define RDD_NAT_CACHE_VLAN_ACTION_KEY_ENTRY_VALID_WRITE_CORE(v, g, idx, core_id)                          CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_VLAN_ACTION_KEY_ENTRY_STRUCT) + 14, 7, 1, (v), core_id)
#define RDD_NAT_CACHE_VLAN_ACTION_KEY_ENTRY_VALID_READ(r, p)                                              RDP_FIELD_MREAD_8((uint8_t *)(p) + 14, 7, 1, (r))
#define RDD_NAT_CACHE_VLAN_ACTION_KEY_ENTRY_VALID_WRITE(v, p)                                             RDP_FIELD_MWRITE_8((uint8_t *)(p) + 14, 7, 1, (v))
#define RDD_NAT_CACHE_VLAN_ACTION_KEY_ENTRY_SUB_TABLE_ID_READ_G(r, g, idx)                                GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_VLAN_ACTION_KEY_ENTRY_STRUCT) + 14, 4, 3, (r))
#define RDD_NAT_CACHE_VLAN_ACTION_KEY_ENTRY_SUB_TABLE_ID_WRITE_G(v, g, idx)                               GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_VLAN_ACTION_KEY_ENTRY_STRUCT) + 14, 4, 3, (v))
#define RDD_NAT_CACHE_VLAN_ACTION_KEY_ENTRY_SUB_TABLE_ID_READ_CORE(r, g, idx, core_id)                    CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_VLAN_ACTION_KEY_ENTRY_STRUCT) + 14, 4, 3, (r), core_id)
#define RDD_NAT_CACHE_VLAN_ACTION_KEY_ENTRY_SUB_TABLE_ID_WRITE_CORE(v, g, idx, core_id)                   CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_VLAN_ACTION_KEY_ENTRY_STRUCT) + 14, 4, 3, (v), core_id)
#define RDD_NAT_CACHE_VLAN_ACTION_KEY_ENTRY_SUB_TABLE_ID_READ(r, p)                                       RDP_FIELD_MREAD_8((uint8_t *)(p) + 14, 4, 3, (r))
#define RDD_NAT_CACHE_VLAN_ACTION_KEY_ENTRY_SUB_TABLE_ID_WRITE(v, p)                                      RDP_FIELD_MWRITE_8((uint8_t *)(p) + 14, 4, 3, (v))
#define RDD_NAT_CACHE_VLAN_ACTION_KEY_ENTRY_EXTENSION_READ_G(r, g, idx)                                   GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_VLAN_ACTION_KEY_ENTRY_STRUCT) + 14, 3, 1, (r))
#define RDD_NAT_CACHE_VLAN_ACTION_KEY_ENTRY_EXTENSION_WRITE_G(v, g, idx)                                  GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_VLAN_ACTION_KEY_ENTRY_STRUCT) + 14, 3, 1, (v))
#define RDD_NAT_CACHE_VLAN_ACTION_KEY_ENTRY_EXTENSION_READ_CORE(r, g, idx, core_id)                       CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_VLAN_ACTION_KEY_ENTRY_STRUCT) + 14, 3, 1, (r), core_id)
#define RDD_NAT_CACHE_VLAN_ACTION_KEY_ENTRY_EXTENSION_WRITE_CORE(v, g, idx, core_id)                      CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_VLAN_ACTION_KEY_ENTRY_STRUCT) + 14, 3, 1, (v), core_id)
#define RDD_NAT_CACHE_VLAN_ACTION_KEY_ENTRY_EXTENSION_READ(r, p)                                          RDP_FIELD_MREAD_8((uint8_t *)(p) + 14, 3, 1, (r))
#define RDD_NAT_CACHE_VLAN_ACTION_KEY_ENTRY_EXTENSION_WRITE(v, p)                                         RDP_FIELD_MWRITE_8((uint8_t *)(p) + 14, 3, 1, (v))
#define RDD_NAT_CACHE_VLAN_ACTION_KEY_ENTRY_PORT_READ_G(r, g, idx)                                        GROUP_MREAD_8((g), (idx)*sizeof(NAT_CACHE_VLAN_ACTION_KEY_ENTRY_STRUCT) + 15, (r))
#define RDD_NAT_CACHE_VLAN_ACTION_KEY_ENTRY_PORT_WRITE_G(v, g, idx)                                       GROUP_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_VLAN_ACTION_KEY_ENTRY_STRUCT) + 15, (v))
#define RDD_NAT_CACHE_VLAN_ACTION_KEY_ENTRY_PORT_READ_CORE(r, g, idx, core_id)                            CORE_MREAD_8((g), (idx)*sizeof(NAT_CACHE_VLAN_ACTION_KEY_ENTRY_STRUCT) + 15, (r), core_id)
#define RDD_NAT_CACHE_VLAN_ACTION_KEY_ENTRY_PORT_WRITE_CORE(v, g, idx, core_id)                           CORE_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_VLAN_ACTION_KEY_ENTRY_STRUCT) + 15, (v), core_id)
#define RDD_NAT_CACHE_VLAN_ACTION_KEY_ENTRY_PORT_READ(r, p)                                               MREAD_8((uint8_t *)(p) + 15, (r))
#define RDD_NAT_CACHE_VLAN_ACTION_KEY_ENTRY_PORT_WRITE(v, p)                                              MWRITE_8((uint8_t *)(p) + 15, (v))
/* <<<NAT_CACHE_VLAN_ACTION_KEY_ENTRY_STRUCT */


/* >>>NAT_CACHE_COUNTER_LKP_ENTRY_STRUCT */
typedef union
    {
    uint8_t word_8[16];
    uint16_t word_16[8];
    uint32_t word_32[4];
    uint64_t dword_64[2];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	valid       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved0   	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	sub_table_id	;
        uint16_t	reserved1   	;
        uint32_t	reserved2   	;
        uint32_t	reserved3   	;
        uint32_t	reserved4   	:15	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	counter_key 	:13	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	not_used    	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#else
        uint16_t	reserved1   	;
        uint8_t	sub_table_id	;
        uint32_t	reserved0   	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	valid       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved2   	;
        uint32_t	reserved3   	;
        uint32_t	not_used    	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	counter_key 	:13	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved4   	:15	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) NAT_CACHE_COUNTER_LKP_ENTRY_STRUCT;

#define RDD_NAT_CACHE_COUNTER_LKP_ENTRY_VALID_READ_G(r, g, idx)                                       GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_COUNTER_LKP_ENTRY_STRUCT), 7, 1, (r))
#define RDD_NAT_CACHE_COUNTER_LKP_ENTRY_VALID_WRITE_G(v, g, idx)                                      GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_COUNTER_LKP_ENTRY_STRUCT), 7, 1, (v))
#define RDD_NAT_CACHE_COUNTER_LKP_ENTRY_VALID_READ_CORE(r, g, idx, core_id)                           CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_COUNTER_LKP_ENTRY_STRUCT), 7, 1, (r), core_id)
#define RDD_NAT_CACHE_COUNTER_LKP_ENTRY_VALID_WRITE_CORE(v, g, idx, core_id)                          CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_COUNTER_LKP_ENTRY_STRUCT), 7, 1, (v), core_id)
#define RDD_NAT_CACHE_COUNTER_LKP_ENTRY_VALID_READ(r, p)                                              RDP_FIELD_MREAD_8((uint8_t *)(p), 7, 1, (r))
#define RDD_NAT_CACHE_COUNTER_LKP_ENTRY_VALID_WRITE(v, p)                                             RDP_FIELD_MWRITE_8((uint8_t *)(p), 7, 1, (v))
#define RDD_NAT_CACHE_COUNTER_LKP_ENTRY_SUB_TABLE_ID_READ_G(r, g, idx)                                GROUP_MREAD_8((g), (idx)*sizeof(NAT_CACHE_COUNTER_LKP_ENTRY_STRUCT) + 1, (r))
#define RDD_NAT_CACHE_COUNTER_LKP_ENTRY_SUB_TABLE_ID_WRITE_G(v, g, idx)                               GROUP_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_COUNTER_LKP_ENTRY_STRUCT) + 1, (v))
#define RDD_NAT_CACHE_COUNTER_LKP_ENTRY_SUB_TABLE_ID_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_8((g), (idx)*sizeof(NAT_CACHE_COUNTER_LKP_ENTRY_STRUCT) + 1, (r), core_id)
#define RDD_NAT_CACHE_COUNTER_LKP_ENTRY_SUB_TABLE_ID_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_COUNTER_LKP_ENTRY_STRUCT) + 1, (v), core_id)
#define RDD_NAT_CACHE_COUNTER_LKP_ENTRY_SUB_TABLE_ID_READ(r, p)                                       MREAD_8((uint8_t *)(p) + 1, (r))
#define RDD_NAT_CACHE_COUNTER_LKP_ENTRY_SUB_TABLE_ID_WRITE(v, p)                                      MWRITE_8((uint8_t *)(p) + 1, (v))
#define RDD_NAT_CACHE_COUNTER_LKP_ENTRY_COUNTER_KEY_READ_G(r, g, idx)                                 GROUP_RDP_FIELD_MREAD_32((g), (idx)*sizeof(NAT_CACHE_COUNTER_LKP_ENTRY_STRUCT) + 12, 4, 13, (r))
#define RDD_NAT_CACHE_COUNTER_LKP_ENTRY_COUNTER_KEY_WRITE_G(v, g, idx)                                GROUP_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(NAT_CACHE_COUNTER_LKP_ENTRY_STRUCT) + 12, 4, 13, (v))
#define RDD_NAT_CACHE_COUNTER_LKP_ENTRY_COUNTER_KEY_READ_CORE(r, g, idx, core_id)                     CORE_RDP_FIELD_MREAD_32((g), (idx)*sizeof(NAT_CACHE_COUNTER_LKP_ENTRY_STRUCT) + 12, 4, 13, (r), core_id)
#define RDD_NAT_CACHE_COUNTER_LKP_ENTRY_COUNTER_KEY_WRITE_CORE(v, g, idx, core_id)                    CORE_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(NAT_CACHE_COUNTER_LKP_ENTRY_STRUCT) + 12, 4, 13, (v), core_id)
#define RDD_NAT_CACHE_COUNTER_LKP_ENTRY_COUNTER_KEY_READ(r, p)                                        RDP_FIELD_MREAD_32((uint8_t *)(p) + 12, 4, 13, (r))
#define RDD_NAT_CACHE_COUNTER_LKP_ENTRY_COUNTER_KEY_WRITE(v, p)                                       RDP_FIELD_MWRITE_32((uint8_t *)(p) + 12, 4, 13, (v))
#define RDD_NAT_CACHE_COUNTER_LKP_ENTRY_NOT_USED_READ_G(r, g, idx)                                    GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_COUNTER_LKP_ENTRY_STRUCT) + 15, 0, 4, (r))
#define RDD_NAT_CACHE_COUNTER_LKP_ENTRY_NOT_USED_WRITE_G(v, g, idx)                                   GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_COUNTER_LKP_ENTRY_STRUCT) + 15, 0, 4, (v))
#define RDD_NAT_CACHE_COUNTER_LKP_ENTRY_NOT_USED_READ_CORE(r, g, idx, core_id)                        CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_COUNTER_LKP_ENTRY_STRUCT) + 15, 0, 4, (r), core_id)
#define RDD_NAT_CACHE_COUNTER_LKP_ENTRY_NOT_USED_WRITE_CORE(v, g, idx, core_id)                       CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_COUNTER_LKP_ENTRY_STRUCT) + 15, 0, 4, (v), core_id)
#define RDD_NAT_CACHE_COUNTER_LKP_ENTRY_NOT_USED_READ(r, p)                                           RDP_FIELD_MREAD_8((uint8_t *)(p) + 15, 0, 4, (r))
#define RDD_NAT_CACHE_COUNTER_LKP_ENTRY_NOT_USED_WRITE(v, p)                                          RDP_FIELD_MWRITE_8((uint8_t *)(p) + 15, 0, 4, (v))
/* <<<NAT_CACHE_COUNTER_LKP_ENTRY_STRUCT */


/* >>>NATC_COMMAND_COUNTER_STRUCT */
typedef union
    {
    uint8_t word_8[24];
    uint16_t word_16[12];
    uint32_t word_32[6];
    uint64_t dword_64[3];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	command_overwritten                     	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	table_num                               	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	decr                                    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	cache_flush                             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved0                               	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	packet_len                              	;
        uint32_t	nat_cache_counter_lkp_entry_valid       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	nat_cache_counter_lkp_entry_reserved0   	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	nat_cache_counter_lkp_entry_sub_table_id	;
        uint16_t	nat_cache_counter_lkp_entry_reserved1   	;
        uint32_t	nat_cache_counter_lkp_entry_reserved2   	;
        uint32_t	nat_cache_counter_lkp_entry_reserved3   	;
        uint32_t	nat_cache_counter_lkp_entry_reserved4   	:15	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	nat_cache_counter_lkp_entry_counter_key 	:13	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	nat_cache_counter_lkp_entry_not_used    	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	not_written                             	;
#else
        uint16_t	packet_len                              	;
        uint32_t	reserved0                               	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	cache_flush                             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	decr                                    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	table_num                               	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	command_overwritten                     	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	nat_cache_counter_lkp_entry_reserved1   	;
        uint8_t	nat_cache_counter_lkp_entry_sub_table_id	;
        uint32_t	nat_cache_counter_lkp_entry_reserved0   	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	nat_cache_counter_lkp_entry_valid       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	nat_cache_counter_lkp_entry_reserved2   	;
        uint32_t	nat_cache_counter_lkp_entry_reserved3   	;
        uint32_t	nat_cache_counter_lkp_entry_not_used    	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	nat_cache_counter_lkp_entry_counter_key 	:13	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	nat_cache_counter_lkp_entry_reserved4   	:15	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	not_written                             	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) NATC_COMMAND_COUNTER_STRUCT;

#define RDD_NATC_COMMAND_COUNTER_COMMAND_OVERWRITTEN_READ_G(r, g, idx)                                                     GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT), 6, 2, (r))
#define RDD_NATC_COMMAND_COUNTER_COMMAND_OVERWRITTEN_WRITE_G(v, g, idx)                                                    GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT), 6, 2, (v))
#define RDD_NATC_COMMAND_COUNTER_COMMAND_OVERWRITTEN_READ_CORE(r, g, idx, core_id)                                         CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT), 6, 2, (r), core_id)
#define RDD_NATC_COMMAND_COUNTER_COMMAND_OVERWRITTEN_WRITE_CORE(v, g, idx, core_id)                                        CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT), 6, 2, (v), core_id)
#define RDD_NATC_COMMAND_COUNTER_COMMAND_OVERWRITTEN_READ(r, p)                                                            RDP_FIELD_MREAD_8((uint8_t *)(p), 6, 2, (r))
#define RDD_NATC_COMMAND_COUNTER_COMMAND_OVERWRITTEN_WRITE(v, p)                                                           RDP_FIELD_MWRITE_8((uint8_t *)(p), 6, 2, (v))
#define RDD_NATC_COMMAND_COUNTER_TABLE_NUM_READ_G(r, g, idx)                                                               GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT), 3, 3, (r))
#define RDD_NATC_COMMAND_COUNTER_TABLE_NUM_WRITE_G(v, g, idx)                                                              GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT), 3, 3, (v))
#define RDD_NATC_COMMAND_COUNTER_TABLE_NUM_READ_CORE(r, g, idx, core_id)                                                   CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT), 3, 3, (r), core_id)
#define RDD_NATC_COMMAND_COUNTER_TABLE_NUM_WRITE_CORE(v, g, idx, core_id)                                                  CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT), 3, 3, (v), core_id)
#define RDD_NATC_COMMAND_COUNTER_TABLE_NUM_READ(r, p)                                                                      RDP_FIELD_MREAD_8((uint8_t *)(p), 3, 3, (r))
#define RDD_NATC_COMMAND_COUNTER_TABLE_NUM_WRITE(v, p)                                                                     RDP_FIELD_MWRITE_8((uint8_t *)(p), 3, 3, (v))
#define RDD_NATC_COMMAND_COUNTER_DECR_READ_G(r, g, idx)                                                                    GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT), 2, 1, (r))
#define RDD_NATC_COMMAND_COUNTER_DECR_WRITE_G(v, g, idx)                                                                   GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT), 2, 1, (v))
#define RDD_NATC_COMMAND_COUNTER_DECR_READ_CORE(r, g, idx, core_id)                                                        CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT), 2, 1, (r), core_id)
#define RDD_NATC_COMMAND_COUNTER_DECR_WRITE_CORE(v, g, idx, core_id)                                                       CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT), 2, 1, (v), core_id)
#define RDD_NATC_COMMAND_COUNTER_DECR_READ(r, p)                                                                           RDP_FIELD_MREAD_8((uint8_t *)(p), 2, 1, (r))
#define RDD_NATC_COMMAND_COUNTER_DECR_WRITE(v, p)                                                                          RDP_FIELD_MWRITE_8((uint8_t *)(p), 2, 1, (v))
#define RDD_NATC_COMMAND_COUNTER_CACHE_FLUSH_READ_G(r, g, idx)                                                             GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT), 1, 1, (r))
#define RDD_NATC_COMMAND_COUNTER_CACHE_FLUSH_WRITE_G(v, g, idx)                                                            GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT), 1, 1, (v))
#define RDD_NATC_COMMAND_COUNTER_CACHE_FLUSH_READ_CORE(r, g, idx, core_id)                                                 CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT), 1, 1, (r), core_id)
#define RDD_NATC_COMMAND_COUNTER_CACHE_FLUSH_WRITE_CORE(v, g, idx, core_id)                                                CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT), 1, 1, (v), core_id)
#define RDD_NATC_COMMAND_COUNTER_CACHE_FLUSH_READ(r, p)                                                                    RDP_FIELD_MREAD_8((uint8_t *)(p), 1, 1, (r))
#define RDD_NATC_COMMAND_COUNTER_CACHE_FLUSH_WRITE(v, p)                                                                   RDP_FIELD_MWRITE_8((uint8_t *)(p), 1, 1, (v))
#define RDD_NATC_COMMAND_COUNTER_PACKET_LEN_READ_G(r, g, idx)                                                              GROUP_MREAD_16((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT) + 2, (r))
#define RDD_NATC_COMMAND_COUNTER_PACKET_LEN_WRITE_G(v, g, idx)                                                             GROUP_MWRITE_16((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT) + 2, (v))
#define RDD_NATC_COMMAND_COUNTER_PACKET_LEN_READ_CORE(r, g, idx, core_id)                                                  CORE_MREAD_16((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT) + 2, (r), core_id)
#define RDD_NATC_COMMAND_COUNTER_PACKET_LEN_WRITE_CORE(v, g, idx, core_id)                                                 CORE_MWRITE_16((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT) + 2, (v), core_id)
#define RDD_NATC_COMMAND_COUNTER_PACKET_LEN_READ(r, p)                                                                     MREAD_16((uint8_t *)(p) + 2, (r))
#define RDD_NATC_COMMAND_COUNTER_PACKET_LEN_WRITE(v, p)                                                                    MWRITE_16((uint8_t *)(p) + 2, (v))
#define RDD_NATC_COMMAND_COUNTER_NAT_CACHE_COUNTER_LKP_ENTRY_VALID_READ_G(r, g, idx)                                       GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT) + 4, 7, 1, (r))
#define RDD_NATC_COMMAND_COUNTER_NAT_CACHE_COUNTER_LKP_ENTRY_VALID_WRITE_G(v, g, idx)                                      GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT) + 4, 7, 1, (v))
#define RDD_NATC_COMMAND_COUNTER_NAT_CACHE_COUNTER_LKP_ENTRY_VALID_READ_CORE(r, g, idx, core_id)                           CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT) + 4, 7, 1, (r), core_id)
#define RDD_NATC_COMMAND_COUNTER_NAT_CACHE_COUNTER_LKP_ENTRY_VALID_WRITE_CORE(v, g, idx, core_id)                          CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT) + 4, 7, 1, (v), core_id)
#define RDD_NATC_COMMAND_COUNTER_NAT_CACHE_COUNTER_LKP_ENTRY_VALID_READ(r, p)                                              RDP_FIELD_MREAD_8((uint8_t *)(p) + 4, 7, 1, (r))
#define RDD_NATC_COMMAND_COUNTER_NAT_CACHE_COUNTER_LKP_ENTRY_VALID_WRITE(v, p)                                             RDP_FIELD_MWRITE_8((uint8_t *)(p) + 4, 7, 1, (v))
#define RDD_NATC_COMMAND_COUNTER_NAT_CACHE_COUNTER_LKP_ENTRY_RESERVED0_READ_G(r, g, idx)                                   GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT) + 4, 0, 7, (r))
#define RDD_NATC_COMMAND_COUNTER_NAT_CACHE_COUNTER_LKP_ENTRY_RESERVED0_WRITE_G(v, g, idx)                                  GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT) + 4, 0, 7, (v))
#define RDD_NATC_COMMAND_COUNTER_NAT_CACHE_COUNTER_LKP_ENTRY_RESERVED0_READ_CORE(r, g, idx, core_id)                       CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT) + 4, 0, 7, (r), core_id)
#define RDD_NATC_COMMAND_COUNTER_NAT_CACHE_COUNTER_LKP_ENTRY_RESERVED0_WRITE_CORE(v, g, idx, core_id)                      CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT) + 4, 0, 7, (v), core_id)
#define RDD_NATC_COMMAND_COUNTER_NAT_CACHE_COUNTER_LKP_ENTRY_RESERVED0_READ(r, p)                                          RDP_FIELD_MREAD_8((uint8_t *)(p) + 4, 0, 7, (r))
#define RDD_NATC_COMMAND_COUNTER_NAT_CACHE_COUNTER_LKP_ENTRY_RESERVED0_WRITE(v, p)                                         RDP_FIELD_MWRITE_8((uint8_t *)(p) + 4, 0, 7, (v))
#define RDD_NATC_COMMAND_COUNTER_NAT_CACHE_COUNTER_LKP_ENTRY_SUB_TABLE_ID_READ_G(r, g, idx)                                GROUP_MREAD_8((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT) + 5, (r))
#define RDD_NATC_COMMAND_COUNTER_NAT_CACHE_COUNTER_LKP_ENTRY_SUB_TABLE_ID_WRITE_G(v, g, idx)                               GROUP_MWRITE_8((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT) + 5, (v))
#define RDD_NATC_COMMAND_COUNTER_NAT_CACHE_COUNTER_LKP_ENTRY_SUB_TABLE_ID_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_8((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT) + 5, (r), core_id)
#define RDD_NATC_COMMAND_COUNTER_NAT_CACHE_COUNTER_LKP_ENTRY_SUB_TABLE_ID_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_8((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT) + 5, (v), core_id)
#define RDD_NATC_COMMAND_COUNTER_NAT_CACHE_COUNTER_LKP_ENTRY_SUB_TABLE_ID_READ(r, p)                                       MREAD_8((uint8_t *)(p) + 5, (r))
#define RDD_NATC_COMMAND_COUNTER_NAT_CACHE_COUNTER_LKP_ENTRY_SUB_TABLE_ID_WRITE(v, p)                                      MWRITE_8((uint8_t *)(p) + 5, (v))
#define RDD_NATC_COMMAND_COUNTER_NAT_CACHE_COUNTER_LKP_ENTRY_RESERVED1_READ_G(r, g, idx)                                   GROUP_MREAD_16((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT) + 6, (r))
#define RDD_NATC_COMMAND_COUNTER_NAT_CACHE_COUNTER_LKP_ENTRY_RESERVED1_WRITE_G(v, g, idx)                                  GROUP_MWRITE_16((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT) + 6, (v))
#define RDD_NATC_COMMAND_COUNTER_NAT_CACHE_COUNTER_LKP_ENTRY_RESERVED1_READ_CORE(r, g, idx, core_id)                       CORE_MREAD_16((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT) + 6, (r), core_id)
#define RDD_NATC_COMMAND_COUNTER_NAT_CACHE_COUNTER_LKP_ENTRY_RESERVED1_WRITE_CORE(v, g, idx, core_id)                      CORE_MWRITE_16((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT) + 6, (v), core_id)
#define RDD_NATC_COMMAND_COUNTER_NAT_CACHE_COUNTER_LKP_ENTRY_RESERVED1_READ(r, p)                                          MREAD_16((uint8_t *)(p) + 6, (r))
#define RDD_NATC_COMMAND_COUNTER_NAT_CACHE_COUNTER_LKP_ENTRY_RESERVED1_WRITE(v, p)                                         MWRITE_16((uint8_t *)(p) + 6, (v))
#define RDD_NATC_COMMAND_COUNTER_NAT_CACHE_COUNTER_LKP_ENTRY_RESERVED2_READ_G(r, g, idx)                                   GROUP_MREAD_32((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT) + 8, (r))
#define RDD_NATC_COMMAND_COUNTER_NAT_CACHE_COUNTER_LKP_ENTRY_RESERVED2_WRITE_G(v, g, idx)                                  GROUP_MWRITE_32((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT) + 8, (v))
#define RDD_NATC_COMMAND_COUNTER_NAT_CACHE_COUNTER_LKP_ENTRY_RESERVED2_READ_CORE(r, g, idx, core_id)                       CORE_MREAD_32((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT) + 8, (r), core_id)
#define RDD_NATC_COMMAND_COUNTER_NAT_CACHE_COUNTER_LKP_ENTRY_RESERVED2_WRITE_CORE(v, g, idx, core_id)                      CORE_MWRITE_32((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT) + 8, (v), core_id)
#define RDD_NATC_COMMAND_COUNTER_NAT_CACHE_COUNTER_LKP_ENTRY_RESERVED2_READ(r, p)                                          MREAD_32((uint8_t *)(p) + 8, (r))
#define RDD_NATC_COMMAND_COUNTER_NAT_CACHE_COUNTER_LKP_ENTRY_RESERVED2_WRITE(v, p)                                         MWRITE_32((uint8_t *)(p) + 8, (v))
#define RDD_NATC_COMMAND_COUNTER_NAT_CACHE_COUNTER_LKP_ENTRY_RESERVED3_READ_G(r, g, idx)                                   GROUP_MREAD_32((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT) + 12, (r))
#define RDD_NATC_COMMAND_COUNTER_NAT_CACHE_COUNTER_LKP_ENTRY_RESERVED3_WRITE_G(v, g, idx)                                  GROUP_MWRITE_32((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT) + 12, (v))
#define RDD_NATC_COMMAND_COUNTER_NAT_CACHE_COUNTER_LKP_ENTRY_RESERVED3_READ_CORE(r, g, idx, core_id)                       CORE_MREAD_32((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT) + 12, (r), core_id)
#define RDD_NATC_COMMAND_COUNTER_NAT_CACHE_COUNTER_LKP_ENTRY_RESERVED3_WRITE_CORE(v, g, idx, core_id)                      CORE_MWRITE_32((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT) + 12, (v), core_id)
#define RDD_NATC_COMMAND_COUNTER_NAT_CACHE_COUNTER_LKP_ENTRY_RESERVED3_READ(r, p)                                          MREAD_32((uint8_t *)(p) + 12, (r))
#define RDD_NATC_COMMAND_COUNTER_NAT_CACHE_COUNTER_LKP_ENTRY_RESERVED3_WRITE(v, p)                                         MWRITE_32((uint8_t *)(p) + 12, (v))
#define RDD_NATC_COMMAND_COUNTER_NAT_CACHE_COUNTER_LKP_ENTRY_RESERVED4_READ_G(r, g, idx)                                   GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT) + 16, 1, 15, (r))
#define RDD_NATC_COMMAND_COUNTER_NAT_CACHE_COUNTER_LKP_ENTRY_RESERVED4_WRITE_G(v, g, idx)                                  GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT) + 16, 1, 15, (v))
#define RDD_NATC_COMMAND_COUNTER_NAT_CACHE_COUNTER_LKP_ENTRY_RESERVED4_READ_CORE(r, g, idx, core_id)                       CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT) + 16, 1, 15, (r), core_id)
#define RDD_NATC_COMMAND_COUNTER_NAT_CACHE_COUNTER_LKP_ENTRY_RESERVED4_WRITE_CORE(v, g, idx, core_id)                      CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT) + 16, 1, 15, (v), core_id)
#define RDD_NATC_COMMAND_COUNTER_NAT_CACHE_COUNTER_LKP_ENTRY_RESERVED4_READ(r, p)                                          RDP_FIELD_MREAD_16((uint8_t *)(p) + 16, 1, 15, (r))
#define RDD_NATC_COMMAND_COUNTER_NAT_CACHE_COUNTER_LKP_ENTRY_RESERVED4_WRITE(v, p)                                         RDP_FIELD_MWRITE_16((uint8_t *)(p) + 16, 1, 15, (v))
#define RDD_NATC_COMMAND_COUNTER_NAT_CACHE_COUNTER_LKP_ENTRY_COUNTER_KEY_READ_G(r, g, idx)                                 GROUP_RDP_FIELD_MREAD_32((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT) + 16, 4, 13, (r))
#define RDD_NATC_COMMAND_COUNTER_NAT_CACHE_COUNTER_LKP_ENTRY_COUNTER_KEY_WRITE_G(v, g, idx)                                GROUP_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT) + 16, 4, 13, (v))
#define RDD_NATC_COMMAND_COUNTER_NAT_CACHE_COUNTER_LKP_ENTRY_COUNTER_KEY_READ_CORE(r, g, idx, core_id)                     CORE_RDP_FIELD_MREAD_32((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT) + 16, 4, 13, (r), core_id)
#define RDD_NATC_COMMAND_COUNTER_NAT_CACHE_COUNTER_LKP_ENTRY_COUNTER_KEY_WRITE_CORE(v, g, idx, core_id)                    CORE_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT) + 16, 4, 13, (v), core_id)
#define RDD_NATC_COMMAND_COUNTER_NAT_CACHE_COUNTER_LKP_ENTRY_COUNTER_KEY_READ(r, p)                                        RDP_FIELD_MREAD_32((uint8_t *)(p) + 16, 4, 13, (r))
#define RDD_NATC_COMMAND_COUNTER_NAT_CACHE_COUNTER_LKP_ENTRY_COUNTER_KEY_WRITE(v, p)                                       RDP_FIELD_MWRITE_32((uint8_t *)(p) + 16, 4, 13, (v))
#define RDD_NATC_COMMAND_COUNTER_NAT_CACHE_COUNTER_LKP_ENTRY_NOT_USED_READ_G(r, g, idx)                                    GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT) + 19, 0, 4, (r))
#define RDD_NATC_COMMAND_COUNTER_NAT_CACHE_COUNTER_LKP_ENTRY_NOT_USED_WRITE_G(v, g, idx)                                   GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT) + 19, 0, 4, (v))
#define RDD_NATC_COMMAND_COUNTER_NAT_CACHE_COUNTER_LKP_ENTRY_NOT_USED_READ_CORE(r, g, idx, core_id)                        CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT) + 19, 0, 4, (r), core_id)
#define RDD_NATC_COMMAND_COUNTER_NAT_CACHE_COUNTER_LKP_ENTRY_NOT_USED_WRITE_CORE(v, g, idx, core_id)                       CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT) + 19, 0, 4, (v), core_id)
#define RDD_NATC_COMMAND_COUNTER_NAT_CACHE_COUNTER_LKP_ENTRY_NOT_USED_READ(r, p)                                           RDP_FIELD_MREAD_8((uint8_t *)(p) + 19, 0, 4, (r))
#define RDD_NATC_COMMAND_COUNTER_NAT_CACHE_COUNTER_LKP_ENTRY_NOT_USED_WRITE(v, p)                                          RDP_FIELD_MWRITE_8((uint8_t *)(p) + 19, 0, 4, (v))
#define RDD_NATC_COMMAND_COUNTER_NOT_WRITTEN_READ_G(r, g, idx)                                                             GROUP_MREAD_32((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT) + 20, (r))
#define RDD_NATC_COMMAND_COUNTER_NOT_WRITTEN_WRITE_G(v, g, idx)                                                            GROUP_MWRITE_32((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT) + 20, (v))
#define RDD_NATC_COMMAND_COUNTER_NOT_WRITTEN_READ_CORE(r, g, idx, core_id)                                                 CORE_MREAD_32((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT) + 20, (r), core_id)
#define RDD_NATC_COMMAND_COUNTER_NOT_WRITTEN_WRITE_CORE(v, g, idx, core_id)                                                CORE_MWRITE_32((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT) + 20, (v), core_id)
#define RDD_NATC_COMMAND_COUNTER_NOT_WRITTEN_READ(r, p)                                                                    MREAD_32((uint8_t *)(p) + 20, (r))
#define RDD_NATC_COMMAND_COUNTER_NOT_WRITTEN_WRITE(v, p)                                                                   MWRITE_32((uint8_t *)(p) + 20, (v))
/* <<<NATC_COMMAND_COUNTER_STRUCT */


/* >>>NAT_CACHE_LKP_ENTRY_VAR_SIZE_CTX_STRUCT */
typedef union
    {
    uint8_t word_8[16];
    uint16_t word_16[8];
    uint32_t word_32[4];
    uint64_t dword_64[2];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	reserved1   	;
        uint32_t	reserved2   	;
        uint32_t	reserved3   	;
        uint32_t	reserved4   	:24	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	var_size_ctx	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#else
        uint32_t	reserved1   	;
        uint32_t	reserved2   	;
        uint32_t	reserved3   	;
        uint32_t	var_size_ctx	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved4   	:24	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) NAT_CACHE_LKP_ENTRY_VAR_SIZE_CTX_STRUCT;

#define RDD_NAT_CACHE_LKP_ENTRY_VAR_SIZE_CTX_VAR_SIZE_CTX_READ_G(r, g, idx)                                GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_LKP_ENTRY_VAR_SIZE_CTX_STRUCT) + 15, 4, 4, (r))
#define RDD_NAT_CACHE_LKP_ENTRY_VAR_SIZE_CTX_VAR_SIZE_CTX_WRITE_G(v, g, idx)                               GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_LKP_ENTRY_VAR_SIZE_CTX_STRUCT) + 15, 4, 4, (v))
#define RDD_NAT_CACHE_LKP_ENTRY_VAR_SIZE_CTX_VAR_SIZE_CTX_READ_CORE(r, g, idx, core_id)                    CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_LKP_ENTRY_VAR_SIZE_CTX_STRUCT) + 15, 4, 4, (r), core_id)
#define RDD_NAT_CACHE_LKP_ENTRY_VAR_SIZE_CTX_VAR_SIZE_CTX_WRITE_CORE(v, g, idx, core_id)                   CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_LKP_ENTRY_VAR_SIZE_CTX_STRUCT) + 15, 4, 4, (v), core_id)
#define RDD_NAT_CACHE_LKP_ENTRY_VAR_SIZE_CTX_VAR_SIZE_CTX_READ(r, p)                                       RDP_FIELD_MREAD_8((uint8_t *)(p) + 15, 4, 4, (r))
#define RDD_NAT_CACHE_LKP_ENTRY_VAR_SIZE_CTX_VAR_SIZE_CTX_WRITE(v, p)                                      RDP_FIELD_MWRITE_8((uint8_t *)(p) + 15, 4, 4, (v))
/* <<<NAT_CACHE_LKP_ENTRY_VAR_SIZE_CTX_STRUCT */


/* >>>NATC_COMMAND_DATA_EXT_STRUCT */
#define RDD_NATC_COMMAND_DATA_EXT_NATC_COMMAND_DATA_RESERVED_NUMBER	40
#define RDD_NATC_COMMAND_DATA_EXT_NATC_L2_CRC_BUF_NUMBER	16
typedef union
    {
    uint8_t word_8[56];
    uint16_t word_16[28];
    uint32_t word_32[14];
    uint64_t dword_64[7];
        struct {
        uint8_t natc_command_data_reserved[40];
        uint8_t natc_l2_crc_buf[16];
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) NATC_COMMAND_DATA_EXT_STRUCT;

#define RDD_NATC_COMMAND_DATA_EXT_NATC_COMMAND_DATA_RESERVED_READ_G(r, g, idx, i)                             GROUP_MREAD_I_8((g), (idx)*sizeof(NATC_COMMAND_DATA_EXT_STRUCT), i, (r))
#define RDD_NATC_COMMAND_DATA_EXT_NATC_COMMAND_DATA_RESERVED_WRITE_G(v, g, idx, i)                            GROUP_MWRITE_I_8((g), (idx)*sizeof(NATC_COMMAND_DATA_EXT_STRUCT), i, (v))
#define RDD_NATC_COMMAND_DATA_EXT_NATC_COMMAND_DATA_RESERVED_READ_CORE(r, g, idx, i, core_id)                 CORE_MREAD_I_8((g), (idx)*sizeof(NATC_COMMAND_DATA_EXT_STRUCT), i, (r), core_id)
#define RDD_NATC_COMMAND_DATA_EXT_NATC_COMMAND_DATA_RESERVED_WRITE_CORE(v, g, idx, i, core_id)                CORE_MWRITE_I_8((g), (idx)*sizeof(NATC_COMMAND_DATA_EXT_STRUCT), i, (v), core_id)
#define RDD_NATC_COMMAND_DATA_EXT_NATC_COMMAND_DATA_RESERVED_READ(r, p, i)                                    MREAD_I_8((uint8_t *)(p), i, (r))
#define RDD_NATC_COMMAND_DATA_EXT_NATC_COMMAND_DATA_RESERVED_WRITE(v, p, i)                                   MWRITE_I_8((uint8_t *)(p), i, (v))
#define RDD_NATC_COMMAND_DATA_EXT_NATC_L2_CRC_BUF_READ_G(r, g, idx, i)                                        GROUP_MREAD_I_8((g), (idx)*sizeof(NATC_COMMAND_DATA_EXT_STRUCT) + 40, i, (r))
#define RDD_NATC_COMMAND_DATA_EXT_NATC_L2_CRC_BUF_WRITE_G(v, g, idx, i)                                       GROUP_MWRITE_I_8((g), (idx)*sizeof(NATC_COMMAND_DATA_EXT_STRUCT) + 40, i, (v))
#define RDD_NATC_COMMAND_DATA_EXT_NATC_L2_CRC_BUF_READ_CORE(r, g, idx, i, core_id)                            CORE_MREAD_I_8((g), (idx)*sizeof(NATC_COMMAND_DATA_EXT_STRUCT) + 40, i, (r), core_id)
#define RDD_NATC_COMMAND_DATA_EXT_NATC_L2_CRC_BUF_WRITE_CORE(v, g, idx, i, core_id)                           CORE_MWRITE_I_8((g), (idx)*sizeof(NATC_COMMAND_DATA_EXT_STRUCT) + 40, i, (v), core_id)
#define RDD_NATC_COMMAND_DATA_EXT_NATC_L2_CRC_BUF_READ(r, p, i)                                               MREAD_I_8((uint8_t *)(p) + 40, i, (r))
#define RDD_NATC_COMMAND_DATA_EXT_NATC_L2_CRC_BUF_WRITE(v, p, i)                                              MWRITE_I_8((uint8_t *)(p) + 40, i, (v))
/* <<<NATC_COMMAND_DATA_EXT_STRUCT */


/* >>>NAT_CACHE_MC_LKP_ENTRY_STRUCT */
typedef union
    {
    uint8_t word_8[16];
    uint16_t word_16[8];
    uint32_t word_32[4];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
	/* Union WORD 0 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	src_ip         	;
		};
	};
	/* Union WORD 1 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	dst_ip         	;
		};
	};
	/* Union WORD 2 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	vlans_etype_crc	;
		};
	};
	/* Union WORD 3 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	tos_vport_client_union	; /* This is a field union */
		};
		/* Sub Union 1 */
		struct{
        uint8_t	tos                      	; /* Member of tos_vport_client_union union */
        uint8_t	client_idx               	; /* Member of tos_vport_client_union union */
        uint32_t	valid                    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of tos_vport_client_union union */
        uint32_t	is_ipv6                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of tos_vport_client_union union */
        uint32_t	rx_vport                 	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of tos_vport_client_union union */
        uint32_t	num_of_vlans             	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of tos_vport_client_union union */
        uint32_t	var_size_ctx             	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of tos_vport_client_union union */
		};
		/* Sub Union 2 */
		struct{
        uint32_t	dscp                     	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of tos_vport_client_union union */
        uint32_t	ecn                      	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of tos_vport_client_union union */
        uint32_t	reserved1                	:24	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of tos_vport_client_union union */
		};
	};
#else
	/* Union WORD 0 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	src_ip         	;
		};
	};
	/* Union WORD 1 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	dst_ip         	;
		};
	};
	/* Union WORD 2 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	vlans_etype_crc	;
		};
	};
	/* Union WORD 3 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	tos_vport_client_union	; /* This is a field union */
		};
		/* Sub Union 1 */
		struct{
        uint32_t	var_size_ctx             	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of tos_vport_client_union union */
        uint32_t	num_of_vlans             	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of tos_vport_client_union union */
        uint32_t	rx_vport                 	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of tos_vport_client_union union */
        uint32_t	is_ipv6                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of tos_vport_client_union union */
        uint32_t	valid                    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of tos_vport_client_union union */
        uint8_t	client_idx               	; /* Member of tos_vport_client_union union */
        uint8_t	tos                      	; /* Member of tos_vport_client_union union */
		};
		/* Sub Union 2 */
		struct{
        uint32_t	reserved1                	:24	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of tos_vport_client_union union */
        uint32_t	ecn                      	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of tos_vport_client_union union */
        uint32_t	dscp                     	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of tos_vport_client_union union */
		};
	};
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(4))) NAT_CACHE_MC_LKP_ENTRY_STRUCT;

#define RDD_NAT_CACHE_MC_LKP_ENTRY_SRC_IP_READ_G(r, g, idx)                                         GROUP_MREAD_32((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT), (r))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_SRC_IP_WRITE_G(v, g, idx)                                        GROUP_MWRITE_32((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT), (v))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_SRC_IP_READ_CORE(r, g, idx, core_id)                             CORE_MREAD_32((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT), (r), core_id)
#define RDD_NAT_CACHE_MC_LKP_ENTRY_SRC_IP_WRITE_CORE(v, g, idx, core_id)                            CORE_MWRITE_32((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT), (v), core_id)
#define RDD_NAT_CACHE_MC_LKP_ENTRY_SRC_IP_READ(r, p)                                                MREAD_32((uint8_t *)(p), (r))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_SRC_IP_WRITE(v, p)                                               MWRITE_32((uint8_t *)(p), (v))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_DST_IP_READ_G(r, g, idx)                                         GROUP_MREAD_32((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 4, (r))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_DST_IP_WRITE_G(v, g, idx)                                        GROUP_MWRITE_32((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 4, (v))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_DST_IP_READ_CORE(r, g, idx, core_id)                             CORE_MREAD_32((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 4, (r), core_id)
#define RDD_NAT_CACHE_MC_LKP_ENTRY_DST_IP_WRITE_CORE(v, g, idx, core_id)                            CORE_MWRITE_32((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 4, (v), core_id)
#define RDD_NAT_CACHE_MC_LKP_ENTRY_DST_IP_READ(r, p)                                                MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_DST_IP_WRITE(v, p)                                               MWRITE_32((uint8_t *)(p) + 4, (v))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_VLANS_ETYPE_CRC_READ_G(r, g, idx)                                GROUP_MREAD_32((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 8, (r))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_VLANS_ETYPE_CRC_WRITE_G(v, g, idx)                               GROUP_MWRITE_32((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 8, (v))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_VLANS_ETYPE_CRC_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_32((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 8, (r), core_id)
#define RDD_NAT_CACHE_MC_LKP_ENTRY_VLANS_ETYPE_CRC_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_32((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 8, (v), core_id)
#define RDD_NAT_CACHE_MC_LKP_ENTRY_VLANS_ETYPE_CRC_READ(r, p)                                       MREAD_32((uint8_t *)(p) + 8, (r))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_VLANS_ETYPE_CRC_WRITE(v, p)                                      MWRITE_32((uint8_t *)(p) + 8, (v))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_TOS_VPORT_CLIENT_UNION_READ_G(r, g, idx)                         GROUP_MREAD_32((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 12, (r))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_TOS_VPORT_CLIENT_UNION_WRITE_G(v, g, idx)                        GROUP_MWRITE_32((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 12, (v))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_TOS_VPORT_CLIENT_UNION_READ_CORE(r, g, idx, core_id)             CORE_MREAD_32((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 12, (r), core_id)
#define RDD_NAT_CACHE_MC_LKP_ENTRY_TOS_VPORT_CLIENT_UNION_WRITE_CORE(v, g, idx, core_id)            CORE_MWRITE_32((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 12, (v), core_id)
#define RDD_NAT_CACHE_MC_LKP_ENTRY_TOS_VPORT_CLIENT_UNION_READ(r, p)                                MREAD_32((uint8_t *)(p) + 12, (r))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_TOS_VPORT_CLIENT_UNION_WRITE(v, p)                               MWRITE_32((uint8_t *)(p) + 12, (v))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_TOS_READ_G(r, g, idx)                                            GROUP_MREAD_8((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 12, (r))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_TOS_WRITE_G(v, g, idx)                                           GROUP_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 12, (v))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_TOS_READ_CORE(r, g, idx, core_id)                                CORE_MREAD_8((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 12, (r), core_id)
#define RDD_NAT_CACHE_MC_LKP_ENTRY_TOS_WRITE_CORE(v, g, idx, core_id)                               CORE_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 12, (v), core_id)
#define RDD_NAT_CACHE_MC_LKP_ENTRY_TOS_READ(r, p)                                                   MREAD_8((uint8_t *)(p) + 12, (r))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_TOS_WRITE(v, p)                                                  MWRITE_8((uint8_t *)(p) + 12, (v))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_CLIENT_IDX_READ_G(r, g, idx)                                     GROUP_MREAD_8((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 13, (r))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_CLIENT_IDX_WRITE_G(v, g, idx)                                    GROUP_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 13, (v))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_CLIENT_IDX_READ_CORE(r, g, idx, core_id)                         CORE_MREAD_8((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 13, (r), core_id)
#define RDD_NAT_CACHE_MC_LKP_ENTRY_CLIENT_IDX_WRITE_CORE(v, g, idx, core_id)                        CORE_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 13, (v), core_id)
#define RDD_NAT_CACHE_MC_LKP_ENTRY_CLIENT_IDX_READ(r, p)                                            MREAD_8((uint8_t *)(p) + 13, (r))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_CLIENT_IDX_WRITE(v, p)                                           MWRITE_8((uint8_t *)(p) + 13, (v))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_VALID_READ_G(r, g, idx)                                          GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 14, 7, 1, (r))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_VALID_WRITE_G(v, g, idx)                                         GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 14, 7, 1, (v))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_VALID_READ_CORE(r, g, idx, core_id)                              CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 14, 7, 1, (r), core_id)
#define RDD_NAT_CACHE_MC_LKP_ENTRY_VALID_WRITE_CORE(v, g, idx, core_id)                             CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 14, 7, 1, (v), core_id)
#define RDD_NAT_CACHE_MC_LKP_ENTRY_VALID_READ(r, p)                                                 RDP_FIELD_MREAD_8((uint8_t *)(p) + 14, 7, 1, (r))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_VALID_WRITE(v, p)                                                RDP_FIELD_MWRITE_8((uint8_t *)(p) + 14, 7, 1, (v))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_IS_IPV6_READ_G(r, g, idx)                                        GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 14, 6, 1, (r))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_IS_IPV6_WRITE_G(v, g, idx)                                       GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 14, 6, 1, (v))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_IS_IPV6_READ_CORE(r, g, idx, core_id)                            CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 14, 6, 1, (r), core_id)
#define RDD_NAT_CACHE_MC_LKP_ENTRY_IS_IPV6_WRITE_CORE(v, g, idx, core_id)                           CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 14, 6, 1, (v), core_id)
#define RDD_NAT_CACHE_MC_LKP_ENTRY_IS_IPV6_READ(r, p)                                               RDP_FIELD_MREAD_8((uint8_t *)(p) + 14, 6, 1, (r))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_IS_IPV6_WRITE(v, p)                                              RDP_FIELD_MWRITE_8((uint8_t *)(p) + 14, 6, 1, (v))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_RX_VPORT_READ_G(r, g, idx)                                       GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 14, 7, 7, (r))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_RX_VPORT_WRITE_G(v, g, idx)                                      GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 14, 7, 7, (v))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_RX_VPORT_READ_CORE(r, g, idx, core_id)                           CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 14, 7, 7, (r), core_id)
#define RDD_NAT_CACHE_MC_LKP_ENTRY_RX_VPORT_WRITE_CORE(v, g, idx, core_id)                          CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 14, 7, 7, (v), core_id)
#define RDD_NAT_CACHE_MC_LKP_ENTRY_RX_VPORT_READ(r, p)                                              RDP_FIELD_MREAD_16((uint8_t *)(p) + 14, 7, 7, (r))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_RX_VPORT_WRITE(v, p)                                             RDP_FIELD_MWRITE_16((uint8_t *)(p) + 14, 7, 7, (v))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_NUM_OF_VLANS_READ_G(r, g, idx)                                   GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 15, 4, 3, (r))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_NUM_OF_VLANS_WRITE_G(v, g, idx)                                  GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 15, 4, 3, (v))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_NUM_OF_VLANS_READ_CORE(r, g, idx, core_id)                       CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 15, 4, 3, (r), core_id)
#define RDD_NAT_CACHE_MC_LKP_ENTRY_NUM_OF_VLANS_WRITE_CORE(v, g, idx, core_id)                      CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 15, 4, 3, (v), core_id)
#define RDD_NAT_CACHE_MC_LKP_ENTRY_NUM_OF_VLANS_READ(r, p)                                          RDP_FIELD_MREAD_8((uint8_t *)(p) + 15, 4, 3, (r))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_NUM_OF_VLANS_WRITE(v, p)                                         RDP_FIELD_MWRITE_8((uint8_t *)(p) + 15, 4, 3, (v))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_VAR_SIZE_CTX_READ_G(r, g, idx)                                   GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 15, 0, 4, (r))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_VAR_SIZE_CTX_WRITE_G(v, g, idx)                                  GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 15, 0, 4, (v))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_VAR_SIZE_CTX_READ_CORE(r, g, idx, core_id)                       CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 15, 0, 4, (r), core_id)
#define RDD_NAT_CACHE_MC_LKP_ENTRY_VAR_SIZE_CTX_WRITE_CORE(v, g, idx, core_id)                      CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 15, 0, 4, (v), core_id)
#define RDD_NAT_CACHE_MC_LKP_ENTRY_VAR_SIZE_CTX_READ(r, p)                                          RDP_FIELD_MREAD_8((uint8_t *)(p) + 15, 0, 4, (r))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_VAR_SIZE_CTX_WRITE(v, p)                                         RDP_FIELD_MWRITE_8((uint8_t *)(p) + 15, 0, 4, (v))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_DSCP_READ_G(r, g, idx)                                           GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 12, 2, 6, (r))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_DSCP_WRITE_G(v, g, idx)                                          GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 12, 2, 6, (v))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_DSCP_READ_CORE(r, g, idx, core_id)                               CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 12, 2, 6, (r), core_id)
#define RDD_NAT_CACHE_MC_LKP_ENTRY_DSCP_WRITE_CORE(v, g, idx, core_id)                              CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 12, 2, 6, (v), core_id)
#define RDD_NAT_CACHE_MC_LKP_ENTRY_DSCP_READ(r, p)                                                  RDP_FIELD_MREAD_8((uint8_t *)(p) + 12, 2, 6, (r))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_DSCP_WRITE(v, p)                                                 RDP_FIELD_MWRITE_8((uint8_t *)(p) + 12, 2, 6, (v))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_ECN_READ_G(r, g, idx)                                            GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 12, 0, 2, (r))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_ECN_WRITE_G(v, g, idx)                                           GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 12, 0, 2, (v))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_ECN_READ_CORE(r, g, idx, core_id)                                CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 12, 0, 2, (r), core_id)
#define RDD_NAT_CACHE_MC_LKP_ENTRY_ECN_WRITE_CORE(v, g, idx, core_id)                               CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 12, 0, 2, (v), core_id)
#define RDD_NAT_CACHE_MC_LKP_ENTRY_ECN_READ(r, p)                                                   RDP_FIELD_MREAD_8((uint8_t *)(p) + 12, 0, 2, (r))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_ECN_WRITE(v, p)                                                  RDP_FIELD_MWRITE_8((uint8_t *)(p) + 12, 0, 2, (v))
/* <<<NAT_CACHE_MC_LKP_ENTRY_STRUCT */


/* >>>TCAM_CONTEXT_STRUCT */
#define RDD_TCAM_CONTEXT_RESERVED2_NUMBER	12
typedef union
    {
    uint8_t word_8[16];
    uint16_t word_16[8];
    uint32_t word_32[4];
    uint64_t dword_64[2];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	action                                          	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	trap_reason                                     	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	cntr_id                                         	:11	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	cntr_disable                                    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	bytes_cntr_id                                   	:11	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	bytes_cntr_disable                              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	iq_priority                                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ct_override                                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved1                                       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	reserved2[RDD_TCAM_CONTEXT_RESERVED2_NUMBER];
#else
        uint32_t	reserved1                                       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ct_override                                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	iq_priority                                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	bytes_cntr_disable                              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	bytes_cntr_id                                   	:11	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	cntr_disable                                    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	cntr_id                                         	:11	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	trap_reason                                     	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	action                                          	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	reserved2[RDD_TCAM_CONTEXT_RESERVED2_NUMBER];
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) TCAM_CONTEXT_STRUCT;

#define RDD_TCAM_CONTEXT_ACTION_READ_G(r, g, idx)                                            GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(TCAM_CONTEXT_STRUCT), 6, 2, (r))
#define RDD_TCAM_CONTEXT_ACTION_WRITE_G(v, g, idx)                                           GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(TCAM_CONTEXT_STRUCT), 6, 2, (v))
#define RDD_TCAM_CONTEXT_ACTION_READ_CORE(r, g, idx, core_id)                                CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(TCAM_CONTEXT_STRUCT), 6, 2, (r), core_id)
#define RDD_TCAM_CONTEXT_ACTION_WRITE_CORE(v, g, idx, core_id)                               CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(TCAM_CONTEXT_STRUCT), 6, 2, (v), core_id)
#define RDD_TCAM_CONTEXT_ACTION_READ(r, p)                                                   RDP_FIELD_MREAD_8((uint8_t *)(p), 6, 2, (r))
#define RDD_TCAM_CONTEXT_ACTION_WRITE(v, p)                                                  RDP_FIELD_MWRITE_8((uint8_t *)(p), 6, 2, (v))
#define RDD_TCAM_CONTEXT_TRAP_REASON_READ_G(r, g, idx)                                       GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(TCAM_CONTEXT_STRUCT), 3, 3, (r))
#define RDD_TCAM_CONTEXT_TRAP_REASON_WRITE_G(v, g, idx)                                      GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(TCAM_CONTEXT_STRUCT), 3, 3, (v))
#define RDD_TCAM_CONTEXT_TRAP_REASON_READ_CORE(r, g, idx, core_id)                           CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(TCAM_CONTEXT_STRUCT), 3, 3, (r), core_id)
#define RDD_TCAM_CONTEXT_TRAP_REASON_WRITE_CORE(v, g, idx, core_id)                          CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(TCAM_CONTEXT_STRUCT), 3, 3, (v), core_id)
#define RDD_TCAM_CONTEXT_TRAP_REASON_READ(r, p)                                              RDP_FIELD_MREAD_8((uint8_t *)(p), 3, 3, (r))
#define RDD_TCAM_CONTEXT_TRAP_REASON_WRITE(v, p)                                             RDP_FIELD_MWRITE_8((uint8_t *)(p), 3, 3, (v))
#define RDD_TCAM_CONTEXT_CNTR_ID_READ_G(r, g, idx)                                           GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(TCAM_CONTEXT_STRUCT), 0, 11, (r))
#define RDD_TCAM_CONTEXT_CNTR_ID_WRITE_G(v, g, idx)                                          GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(TCAM_CONTEXT_STRUCT), 0, 11, (v))
#define RDD_TCAM_CONTEXT_CNTR_ID_READ_CORE(r, g, idx, core_id)                               CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(TCAM_CONTEXT_STRUCT), 0, 11, (r), core_id)
#define RDD_TCAM_CONTEXT_CNTR_ID_WRITE_CORE(v, g, idx, core_id)                              CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(TCAM_CONTEXT_STRUCT), 0, 11, (v), core_id)
#define RDD_TCAM_CONTEXT_CNTR_ID_READ(r, p)                                                  RDP_FIELD_MREAD_16((uint8_t *)(p), 0, 11, (r))
#define RDD_TCAM_CONTEXT_CNTR_ID_WRITE(v, p)                                                 RDP_FIELD_MWRITE_16((uint8_t *)(p), 0, 11, (v))
#define RDD_TCAM_CONTEXT_CNTR_DISABLE_READ_G(r, g, idx)                                      GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(TCAM_CONTEXT_STRUCT) + 2, 7, 1, (r))
#define RDD_TCAM_CONTEXT_CNTR_DISABLE_WRITE_G(v, g, idx)                                     GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(TCAM_CONTEXT_STRUCT) + 2, 7, 1, (v))
#define RDD_TCAM_CONTEXT_CNTR_DISABLE_READ_CORE(r, g, idx, core_id)                          CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(TCAM_CONTEXT_STRUCT) + 2, 7, 1, (r), core_id)
#define RDD_TCAM_CONTEXT_CNTR_DISABLE_WRITE_CORE(v, g, idx, core_id)                         CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(TCAM_CONTEXT_STRUCT) + 2, 7, 1, (v), core_id)
#define RDD_TCAM_CONTEXT_CNTR_DISABLE_READ(r, p)                                             RDP_FIELD_MREAD_8((uint8_t *)(p) + 2, 7, 1, (r))
#define RDD_TCAM_CONTEXT_CNTR_DISABLE_WRITE(v, p)                                            RDP_FIELD_MWRITE_8((uint8_t *)(p) + 2, 7, 1, (v))
#define RDD_TCAM_CONTEXT_BYTES_CNTR_ID_READ_G(r, g, idx)                                     GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(TCAM_CONTEXT_STRUCT) + 2, 4, 11, (r))
#define RDD_TCAM_CONTEXT_BYTES_CNTR_ID_WRITE_G(v, g, idx)                                    GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(TCAM_CONTEXT_STRUCT) + 2, 4, 11, (v))
#define RDD_TCAM_CONTEXT_BYTES_CNTR_ID_READ_CORE(r, g, idx, core_id)                         CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(TCAM_CONTEXT_STRUCT) + 2, 4, 11, (r), core_id)
#define RDD_TCAM_CONTEXT_BYTES_CNTR_ID_WRITE_CORE(v, g, idx, core_id)                        CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(TCAM_CONTEXT_STRUCT) + 2, 4, 11, (v), core_id)
#define RDD_TCAM_CONTEXT_BYTES_CNTR_ID_READ(r, p)                                            RDP_FIELD_MREAD_16((uint8_t *)(p) + 2, 4, 11, (r))
#define RDD_TCAM_CONTEXT_BYTES_CNTR_ID_WRITE(v, p)                                           RDP_FIELD_MWRITE_16((uint8_t *)(p) + 2, 4, 11, (v))
#define RDD_TCAM_CONTEXT_BYTES_CNTR_DISABLE_READ_G(r, g, idx)                                GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(TCAM_CONTEXT_STRUCT) + 3, 3, 1, (r))
#define RDD_TCAM_CONTEXT_BYTES_CNTR_DISABLE_WRITE_G(v, g, idx)                               GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(TCAM_CONTEXT_STRUCT) + 3, 3, 1, (v))
#define RDD_TCAM_CONTEXT_BYTES_CNTR_DISABLE_READ_CORE(r, g, idx, core_id)                    CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(TCAM_CONTEXT_STRUCT) + 3, 3, 1, (r), core_id)
#define RDD_TCAM_CONTEXT_BYTES_CNTR_DISABLE_WRITE_CORE(v, g, idx, core_id)                   CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(TCAM_CONTEXT_STRUCT) + 3, 3, 1, (v), core_id)
#define RDD_TCAM_CONTEXT_BYTES_CNTR_DISABLE_READ(r, p)                                       RDP_FIELD_MREAD_8((uint8_t *)(p) + 3, 3, 1, (r))
#define RDD_TCAM_CONTEXT_BYTES_CNTR_DISABLE_WRITE(v, p)                                      RDP_FIELD_MWRITE_8((uint8_t *)(p) + 3, 3, 1, (v))
#define RDD_TCAM_CONTEXT_IQ_PRIORITY_READ_G(r, g, idx)                                       GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(TCAM_CONTEXT_STRUCT) + 3, 2, 1, (r))
#define RDD_TCAM_CONTEXT_IQ_PRIORITY_WRITE_G(v, g, idx)                                      GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(TCAM_CONTEXT_STRUCT) + 3, 2, 1, (v))
#define RDD_TCAM_CONTEXT_IQ_PRIORITY_READ_CORE(r, g, idx, core_id)                           CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(TCAM_CONTEXT_STRUCT) + 3, 2, 1, (r), core_id)
#define RDD_TCAM_CONTEXT_IQ_PRIORITY_WRITE_CORE(v, g, idx, core_id)                          CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(TCAM_CONTEXT_STRUCT) + 3, 2, 1, (v), core_id)
#define RDD_TCAM_CONTEXT_IQ_PRIORITY_READ(r, p)                                              RDP_FIELD_MREAD_8((uint8_t *)(p) + 3, 2, 1, (r))
#define RDD_TCAM_CONTEXT_IQ_PRIORITY_WRITE(v, p)                                             RDP_FIELD_MWRITE_8((uint8_t *)(p) + 3, 2, 1, (v))
#define RDD_TCAM_CONTEXT_CT_OVERRIDE_READ_G(r, g, idx)                                       GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(TCAM_CONTEXT_STRUCT) + 3, 1, 1, (r))
#define RDD_TCAM_CONTEXT_CT_OVERRIDE_WRITE_G(v, g, idx)                                      GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(TCAM_CONTEXT_STRUCT) + 3, 1, 1, (v))
#define RDD_TCAM_CONTEXT_CT_OVERRIDE_READ_CORE(r, g, idx, core_id)                           CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(TCAM_CONTEXT_STRUCT) + 3, 1, 1, (r), core_id)
#define RDD_TCAM_CONTEXT_CT_OVERRIDE_WRITE_CORE(v, g, idx, core_id)                          CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(TCAM_CONTEXT_STRUCT) + 3, 1, 1, (v), core_id)
#define RDD_TCAM_CONTEXT_CT_OVERRIDE_READ(r, p)                                              RDP_FIELD_MREAD_8((uint8_t *)(p) + 3, 1, 1, (r))
#define RDD_TCAM_CONTEXT_CT_OVERRIDE_WRITE(v, p)                                             RDP_FIELD_MWRITE_8((uint8_t *)(p) + 3, 1, 1, (v))
/* <<<TCAM_CONTEXT_STRUCT */


/* >>>MIRRORING_DESCRIPTOR_STRUCT */
typedef union
    {
    uint8_t word_8[2];
    uint16_t word_16[1];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint16_t	mirror_en 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	dst_vport 	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	dst_queue 	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#else
        uint16_t	dst_queue 	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	dst_vport 	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	mirror_en 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(2))) MIRRORING_DESCRIPTOR_STRUCT;

#define RDD_MIRRORING_DESCRIPTOR_MIRROR_EN_READ_G(r, g, idx)                                GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(MIRRORING_DESCRIPTOR_STRUCT), 7, 1, (r))
#define RDD_MIRRORING_DESCRIPTOR_MIRROR_EN_WRITE_G(v, g, idx)                               GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(MIRRORING_DESCRIPTOR_STRUCT), 7, 1, (v))
#define RDD_MIRRORING_DESCRIPTOR_MIRROR_EN_READ_CORE(r, g, idx, core_id)                    CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(MIRRORING_DESCRIPTOR_STRUCT), 7, 1, (r), core_id)
#define RDD_MIRRORING_DESCRIPTOR_MIRROR_EN_WRITE_CORE(v, g, idx, core_id)                   CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(MIRRORING_DESCRIPTOR_STRUCT), 7, 1, (v), core_id)
#define RDD_MIRRORING_DESCRIPTOR_MIRROR_EN_READ(r, p)                                       RDP_FIELD_MREAD_8((uint8_t *)(p), 7, 1, (r))
#define RDD_MIRRORING_DESCRIPTOR_MIRROR_EN_WRITE(v, p)                                      RDP_FIELD_MWRITE_8((uint8_t *)(p), 7, 1, (v))
#define RDD_MIRRORING_DESCRIPTOR_DST_VPORT_READ_G(r, g, idx)                                GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(MIRRORING_DESCRIPTOR_STRUCT), 1, 6, (r))
#define RDD_MIRRORING_DESCRIPTOR_DST_VPORT_WRITE_G(v, g, idx)                               GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(MIRRORING_DESCRIPTOR_STRUCT), 1, 6, (v))
#define RDD_MIRRORING_DESCRIPTOR_DST_VPORT_READ_CORE(r, g, idx, core_id)                    CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(MIRRORING_DESCRIPTOR_STRUCT), 1, 6, (r), core_id)
#define RDD_MIRRORING_DESCRIPTOR_DST_VPORT_WRITE_CORE(v, g, idx, core_id)                   CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(MIRRORING_DESCRIPTOR_STRUCT), 1, 6, (v), core_id)
#define RDD_MIRRORING_DESCRIPTOR_DST_VPORT_READ(r, p)                                       RDP_FIELD_MREAD_8((uint8_t *)(p), 1, 6, (r))
#define RDD_MIRRORING_DESCRIPTOR_DST_VPORT_WRITE(v, p)                                      RDP_FIELD_MWRITE_8((uint8_t *)(p), 1, 6, (v))
#define RDD_MIRRORING_DESCRIPTOR_DST_QUEUE_READ_G(r, g, idx)                                GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(MIRRORING_DESCRIPTOR_STRUCT), 0, 9, (r))
#define RDD_MIRRORING_DESCRIPTOR_DST_QUEUE_WRITE_G(v, g, idx)                               GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(MIRRORING_DESCRIPTOR_STRUCT), 0, 9, (v))
#define RDD_MIRRORING_DESCRIPTOR_DST_QUEUE_READ_CORE(r, g, idx, core_id)                    CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(MIRRORING_DESCRIPTOR_STRUCT), 0, 9, (r), core_id)
#define RDD_MIRRORING_DESCRIPTOR_DST_QUEUE_WRITE_CORE(v, g, idx, core_id)                   CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(MIRRORING_DESCRIPTOR_STRUCT), 0, 9, (v), core_id)
#define RDD_MIRRORING_DESCRIPTOR_DST_QUEUE_READ(r, p)                                       RDP_FIELD_MREAD_16((uint8_t *)(p), 0, 9, (r))
#define RDD_MIRRORING_DESCRIPTOR_DST_QUEUE_WRITE(v, p)                                      RDP_FIELD_MWRITE_16((uint8_t *)(p), 0, 9, (v))
/* <<<MIRRORING_DESCRIPTOR_STRUCT */


/* >>>PI2_PROBABILITY_CALC_DESCRIPTOR_STRUCT */
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_PI2_QUEUE_MASK_NUMBER	16
typedef union
    {
    uint8_t word_8[52];
    uint16_t word_16[26];
    uint32_t word_32[13];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint16_t	pi2_queue_mask[RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_PI2_QUEUE_MASK_NUMBER];
        uint16_t	timer_value                                                                  	;
        uint8_t	calc_iter                                                                    	;
        uint8_t	target_delay                                                                 	;
        uint16_t	alpha_coeff                                                                  	;
        uint16_t	beta_coeff                                                                   	;
        uint8_t	ticks_per_run                                                                	;
        uint8_t	ticks_left                                                                   	;
        uint8_t	ds_start_iter                                                                	;
        uint8_t	sr_start_iter                                                                	;
        uint16_t	us_aqm_q_table                                                               	;
        uint16_t	ds_aqm_q_table                                                               	;
        uint16_t	sr_aqm_q_table                                                               	;
        uint16_t	reserved1                                                                    	;
#else
        uint16_t	pi2_queue_mask[RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_PI2_QUEUE_MASK_NUMBER];
        uint8_t	target_delay                                                                 	;
        uint8_t	calc_iter                                                                    	;
        uint16_t	timer_value                                                                  	;
        uint16_t	beta_coeff                                                                   	;
        uint16_t	alpha_coeff                                                                  	;
        uint8_t	sr_start_iter                                                                	;
        uint8_t	ds_start_iter                                                                	;
        uint8_t	ticks_left                                                                   	;
        uint8_t	ticks_per_run                                                                	;
        uint16_t	ds_aqm_q_table                                                               	;
        uint16_t	us_aqm_q_table                                                               	;
        uint16_t	reserved1                                                                    	;
        uint16_t	sr_aqm_q_table                                                               	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(4))) PI2_PROBABILITY_CALC_DESCRIPTOR_STRUCT;

#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_PI2_QUEUE_MASK_READ_G(r, g, idx, i)                             GROUP_MREAD_I_16((g), (idx)*sizeof(PI2_PROBABILITY_CALC_DESCRIPTOR_STRUCT), i, (r))
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_PI2_QUEUE_MASK_WRITE_G(v, g, idx, i)                            GROUP_MWRITE_I_16((g), (idx)*sizeof(PI2_PROBABILITY_CALC_DESCRIPTOR_STRUCT), i, (v))
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_PI2_QUEUE_MASK_READ_CORE(r, g, idx, i, core_id)                 CORE_MREAD_I_16((g), (idx)*sizeof(PI2_PROBABILITY_CALC_DESCRIPTOR_STRUCT), i, (r), core_id)
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_PI2_QUEUE_MASK_WRITE_CORE(v, g, idx, i, core_id)                CORE_MWRITE_I_16((g), (idx)*sizeof(PI2_PROBABILITY_CALC_DESCRIPTOR_STRUCT), i, (v), core_id)
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_PI2_QUEUE_MASK_READ(r, p, i)                                    MREAD_I_16((uint8_t *)(p), i, (r))
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_PI2_QUEUE_MASK_WRITE(v, p, i)                                   MWRITE_I_16((uint8_t *)(p), i, (v))
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_TIMER_VALUE_READ_G(r, g, idx)                                   GROUP_MREAD_16((g), (idx)*sizeof(PI2_PROBABILITY_CALC_DESCRIPTOR_STRUCT) + 32, (r))
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_TIMER_VALUE_WRITE_G(v, g, idx)                                  GROUP_MWRITE_16((g), (idx)*sizeof(PI2_PROBABILITY_CALC_DESCRIPTOR_STRUCT) + 32, (v))
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_TIMER_VALUE_READ_CORE(r, g, idx, core_id)                       CORE_MREAD_16((g), (idx)*sizeof(PI2_PROBABILITY_CALC_DESCRIPTOR_STRUCT) + 32, (r), core_id)
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_TIMER_VALUE_WRITE_CORE(v, g, idx, core_id)                      CORE_MWRITE_16((g), (idx)*sizeof(PI2_PROBABILITY_CALC_DESCRIPTOR_STRUCT) + 32, (v), core_id)
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_TIMER_VALUE_READ(r, p)                                          MREAD_16((uint8_t *)(p) + 32, (r))
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_TIMER_VALUE_WRITE(v, p)                                         MWRITE_16((uint8_t *)(p) + 32, (v))
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_CALC_ITER_READ_G(r, g, idx)                                     GROUP_MREAD_8((g), (idx)*sizeof(PI2_PROBABILITY_CALC_DESCRIPTOR_STRUCT) + 34, (r))
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_CALC_ITER_WRITE_G(v, g, idx)                                    GROUP_MWRITE_8((g), (idx)*sizeof(PI2_PROBABILITY_CALC_DESCRIPTOR_STRUCT) + 34, (v))
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_CALC_ITER_READ_CORE(r, g, idx, core_id)                         CORE_MREAD_8((g), (idx)*sizeof(PI2_PROBABILITY_CALC_DESCRIPTOR_STRUCT) + 34, (r), core_id)
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_CALC_ITER_WRITE_CORE(v, g, idx, core_id)                        CORE_MWRITE_8((g), (idx)*sizeof(PI2_PROBABILITY_CALC_DESCRIPTOR_STRUCT) + 34, (v), core_id)
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_CALC_ITER_READ(r, p)                                            MREAD_8((uint8_t *)(p) + 34, (r))
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_CALC_ITER_WRITE(v, p)                                           MWRITE_8((uint8_t *)(p) + 34, (v))
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_TARGET_DELAY_READ_G(r, g, idx)                                  GROUP_MREAD_8((g), (idx)*sizeof(PI2_PROBABILITY_CALC_DESCRIPTOR_STRUCT) + 35, (r))
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_TARGET_DELAY_WRITE_G(v, g, idx)                                 GROUP_MWRITE_8((g), (idx)*sizeof(PI2_PROBABILITY_CALC_DESCRIPTOR_STRUCT) + 35, (v))
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_TARGET_DELAY_READ_CORE(r, g, idx, core_id)                      CORE_MREAD_8((g), (idx)*sizeof(PI2_PROBABILITY_CALC_DESCRIPTOR_STRUCT) + 35, (r), core_id)
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_TARGET_DELAY_WRITE_CORE(v, g, idx, core_id)                     CORE_MWRITE_8((g), (idx)*sizeof(PI2_PROBABILITY_CALC_DESCRIPTOR_STRUCT) + 35, (v), core_id)
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_TARGET_DELAY_READ(r, p)                                         MREAD_8((uint8_t *)(p) + 35, (r))
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_TARGET_DELAY_WRITE(v, p)                                        MWRITE_8((uint8_t *)(p) + 35, (v))
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_ALPHA_COEFF_READ_G(r, g, idx)                                   GROUP_MREAD_16((g), (idx)*sizeof(PI2_PROBABILITY_CALC_DESCRIPTOR_STRUCT) + 36, (r))
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_ALPHA_COEFF_WRITE_G(v, g, idx)                                  GROUP_MWRITE_16((g), (idx)*sizeof(PI2_PROBABILITY_CALC_DESCRIPTOR_STRUCT) + 36, (v))
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_ALPHA_COEFF_READ_CORE(r, g, idx, core_id)                       CORE_MREAD_16((g), (idx)*sizeof(PI2_PROBABILITY_CALC_DESCRIPTOR_STRUCT) + 36, (r), core_id)
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_ALPHA_COEFF_WRITE_CORE(v, g, idx, core_id)                      CORE_MWRITE_16((g), (idx)*sizeof(PI2_PROBABILITY_CALC_DESCRIPTOR_STRUCT) + 36, (v), core_id)
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_ALPHA_COEFF_READ(r, p)                                          MREAD_16((uint8_t *)(p) + 36, (r))
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_ALPHA_COEFF_WRITE(v, p)                                         MWRITE_16((uint8_t *)(p) + 36, (v))
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_BETA_COEFF_READ_G(r, g, idx)                                    GROUP_MREAD_16((g), (idx)*sizeof(PI2_PROBABILITY_CALC_DESCRIPTOR_STRUCT) + 38, (r))
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_BETA_COEFF_WRITE_G(v, g, idx)                                   GROUP_MWRITE_16((g), (idx)*sizeof(PI2_PROBABILITY_CALC_DESCRIPTOR_STRUCT) + 38, (v))
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_BETA_COEFF_READ_CORE(r, g, idx, core_id)                        CORE_MREAD_16((g), (idx)*sizeof(PI2_PROBABILITY_CALC_DESCRIPTOR_STRUCT) + 38, (r), core_id)
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_BETA_COEFF_WRITE_CORE(v, g, idx, core_id)                       CORE_MWRITE_16((g), (idx)*sizeof(PI2_PROBABILITY_CALC_DESCRIPTOR_STRUCT) + 38, (v), core_id)
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_BETA_COEFF_READ(r, p)                                           MREAD_16((uint8_t *)(p) + 38, (r))
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_BETA_COEFF_WRITE(v, p)                                          MWRITE_16((uint8_t *)(p) + 38, (v))
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_TICKS_PER_RUN_READ_G(r, g, idx)                                 GROUP_MREAD_8((g), (idx)*sizeof(PI2_PROBABILITY_CALC_DESCRIPTOR_STRUCT) + 40, (r))
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_TICKS_PER_RUN_WRITE_G(v, g, idx)                                GROUP_MWRITE_8((g), (idx)*sizeof(PI2_PROBABILITY_CALC_DESCRIPTOR_STRUCT) + 40, (v))
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_TICKS_PER_RUN_READ_CORE(r, g, idx, core_id)                     CORE_MREAD_8((g), (idx)*sizeof(PI2_PROBABILITY_CALC_DESCRIPTOR_STRUCT) + 40, (r), core_id)
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_TICKS_PER_RUN_WRITE_CORE(v, g, idx, core_id)                    CORE_MWRITE_8((g), (idx)*sizeof(PI2_PROBABILITY_CALC_DESCRIPTOR_STRUCT) + 40, (v), core_id)
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_TICKS_PER_RUN_READ(r, p)                                        MREAD_8((uint8_t *)(p) + 40, (r))
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_TICKS_PER_RUN_WRITE(v, p)                                       MWRITE_8((uint8_t *)(p) + 40, (v))
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_TICKS_LEFT_READ_G(r, g, idx)                                    GROUP_MREAD_8((g), (idx)*sizeof(PI2_PROBABILITY_CALC_DESCRIPTOR_STRUCT) + 41, (r))
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_TICKS_LEFT_WRITE_G(v, g, idx)                                   GROUP_MWRITE_8((g), (idx)*sizeof(PI2_PROBABILITY_CALC_DESCRIPTOR_STRUCT) + 41, (v))
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_TICKS_LEFT_READ_CORE(r, g, idx, core_id)                        CORE_MREAD_8((g), (idx)*sizeof(PI2_PROBABILITY_CALC_DESCRIPTOR_STRUCT) + 41, (r), core_id)
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_TICKS_LEFT_WRITE_CORE(v, g, idx, core_id)                       CORE_MWRITE_8((g), (idx)*sizeof(PI2_PROBABILITY_CALC_DESCRIPTOR_STRUCT) + 41, (v), core_id)
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_TICKS_LEFT_READ(r, p)                                           MREAD_8((uint8_t *)(p) + 41, (r))
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_TICKS_LEFT_WRITE(v, p)                                          MWRITE_8((uint8_t *)(p) + 41, (v))
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_DS_START_ITER_READ_G(r, g, idx)                                 GROUP_MREAD_8((g), (idx)*sizeof(PI2_PROBABILITY_CALC_DESCRIPTOR_STRUCT) + 42, (r))
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_DS_START_ITER_WRITE_G(v, g, idx)                                GROUP_MWRITE_8((g), (idx)*sizeof(PI2_PROBABILITY_CALC_DESCRIPTOR_STRUCT) + 42, (v))
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_DS_START_ITER_READ_CORE(r, g, idx, core_id)                     CORE_MREAD_8((g), (idx)*sizeof(PI2_PROBABILITY_CALC_DESCRIPTOR_STRUCT) + 42, (r), core_id)
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_DS_START_ITER_WRITE_CORE(v, g, idx, core_id)                    CORE_MWRITE_8((g), (idx)*sizeof(PI2_PROBABILITY_CALC_DESCRIPTOR_STRUCT) + 42, (v), core_id)
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_DS_START_ITER_READ(r, p)                                        MREAD_8((uint8_t *)(p) + 42, (r))
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_DS_START_ITER_WRITE(v, p)                                       MWRITE_8((uint8_t *)(p) + 42, (v))
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_SR_START_ITER_READ_G(r, g, idx)                                 GROUP_MREAD_8((g), (idx)*sizeof(PI2_PROBABILITY_CALC_DESCRIPTOR_STRUCT) + 43, (r))
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_SR_START_ITER_WRITE_G(v, g, idx)                                GROUP_MWRITE_8((g), (idx)*sizeof(PI2_PROBABILITY_CALC_DESCRIPTOR_STRUCT) + 43, (v))
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_SR_START_ITER_READ_CORE(r, g, idx, core_id)                     CORE_MREAD_8((g), (idx)*sizeof(PI2_PROBABILITY_CALC_DESCRIPTOR_STRUCT) + 43, (r), core_id)
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_SR_START_ITER_WRITE_CORE(v, g, idx, core_id)                    CORE_MWRITE_8((g), (idx)*sizeof(PI2_PROBABILITY_CALC_DESCRIPTOR_STRUCT) + 43, (v), core_id)
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_SR_START_ITER_READ(r, p)                                        MREAD_8((uint8_t *)(p) + 43, (r))
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_SR_START_ITER_WRITE(v, p)                                       MWRITE_8((uint8_t *)(p) + 43, (v))
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_US_AQM_Q_TABLE_READ_G(r, g, idx)                                GROUP_MREAD_16((g), (idx)*sizeof(PI2_PROBABILITY_CALC_DESCRIPTOR_STRUCT) + 44, (r))
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_US_AQM_Q_TABLE_WRITE_G(v, g, idx)                               GROUP_MWRITE_16((g), (idx)*sizeof(PI2_PROBABILITY_CALC_DESCRIPTOR_STRUCT) + 44, (v))
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_US_AQM_Q_TABLE_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_16((g), (idx)*sizeof(PI2_PROBABILITY_CALC_DESCRIPTOR_STRUCT) + 44, (r), core_id)
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_US_AQM_Q_TABLE_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_16((g), (idx)*sizeof(PI2_PROBABILITY_CALC_DESCRIPTOR_STRUCT) + 44, (v), core_id)
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_US_AQM_Q_TABLE_READ(r, p)                                       MREAD_16((uint8_t *)(p) + 44, (r))
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_US_AQM_Q_TABLE_WRITE(v, p)                                      MWRITE_16((uint8_t *)(p) + 44, (v))
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_DS_AQM_Q_TABLE_READ_G(r, g, idx)                                GROUP_MREAD_16((g), (idx)*sizeof(PI2_PROBABILITY_CALC_DESCRIPTOR_STRUCT) + 46, (r))
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_DS_AQM_Q_TABLE_WRITE_G(v, g, idx)                               GROUP_MWRITE_16((g), (idx)*sizeof(PI2_PROBABILITY_CALC_DESCRIPTOR_STRUCT) + 46, (v))
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_DS_AQM_Q_TABLE_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_16((g), (idx)*sizeof(PI2_PROBABILITY_CALC_DESCRIPTOR_STRUCT) + 46, (r), core_id)
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_DS_AQM_Q_TABLE_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_16((g), (idx)*sizeof(PI2_PROBABILITY_CALC_DESCRIPTOR_STRUCT) + 46, (v), core_id)
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_DS_AQM_Q_TABLE_READ(r, p)                                       MREAD_16((uint8_t *)(p) + 46, (r))
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_DS_AQM_Q_TABLE_WRITE(v, p)                                      MWRITE_16((uint8_t *)(p) + 46, (v))
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_SR_AQM_Q_TABLE_READ_G(r, g, idx)                                GROUP_MREAD_16((g), (idx)*sizeof(PI2_PROBABILITY_CALC_DESCRIPTOR_STRUCT) + 48, (r))
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_SR_AQM_Q_TABLE_WRITE_G(v, g, idx)                               GROUP_MWRITE_16((g), (idx)*sizeof(PI2_PROBABILITY_CALC_DESCRIPTOR_STRUCT) + 48, (v))
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_SR_AQM_Q_TABLE_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_16((g), (idx)*sizeof(PI2_PROBABILITY_CALC_DESCRIPTOR_STRUCT) + 48, (r), core_id)
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_SR_AQM_Q_TABLE_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_16((g), (idx)*sizeof(PI2_PROBABILITY_CALC_DESCRIPTOR_STRUCT) + 48, (v), core_id)
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_SR_AQM_Q_TABLE_READ(r, p)                                       MREAD_16((uint8_t *)(p) + 48, (r))
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_SR_AQM_Q_TABLE_WRITE(v, p)                                      MWRITE_16((uint8_t *)(p) + 48, (v))
/* <<<PI2_PROBABILITY_CALC_DESCRIPTOR_STRUCT */


/* >>>HASH_COMMAND_STRUCT */
typedef union
    {
    uint8_t word_8[8];
    uint16_t word_16[4];
    uint32_t word_32[2];
    uint64_t dword_64[1];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	configuration	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	aging        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	key_1        	:28	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	key_0        	;
#else
        uint32_t	key_1        	:28	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	aging        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	configuration	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	key_0        	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) HASH_COMMAND_STRUCT;

#define RDD_HASH_COMMAND_CONFIGURATION_READ_G(r, g, idx)                                GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(HASH_COMMAND_STRUCT), 5, 3, (r))
#define RDD_HASH_COMMAND_CONFIGURATION_WRITE_G(v, g, idx)                               GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(HASH_COMMAND_STRUCT), 5, 3, (v))
#define RDD_HASH_COMMAND_CONFIGURATION_READ_CORE(r, g, idx, core_id)                    CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(HASH_COMMAND_STRUCT), 5, 3, (r), core_id)
#define RDD_HASH_COMMAND_CONFIGURATION_WRITE_CORE(v, g, idx, core_id)                   CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(HASH_COMMAND_STRUCT), 5, 3, (v), core_id)
#define RDD_HASH_COMMAND_CONFIGURATION_READ(r, p)                                       RDP_FIELD_MREAD_8((uint8_t *)(p), 5, 3, (r))
#define RDD_HASH_COMMAND_CONFIGURATION_WRITE(v, p)                                      RDP_FIELD_MWRITE_8((uint8_t *)(p), 5, 3, (v))
#define RDD_HASH_COMMAND_AGING_READ_G(r, g, idx)                                        GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(HASH_COMMAND_STRUCT), 4, 1, (r))
#define RDD_HASH_COMMAND_AGING_WRITE_G(v, g, idx)                                       GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(HASH_COMMAND_STRUCT), 4, 1, (v))
#define RDD_HASH_COMMAND_AGING_READ_CORE(r, g, idx, core_id)                            CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(HASH_COMMAND_STRUCT), 4, 1, (r), core_id)
#define RDD_HASH_COMMAND_AGING_WRITE_CORE(v, g, idx, core_id)                           CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(HASH_COMMAND_STRUCT), 4, 1, (v), core_id)
#define RDD_HASH_COMMAND_AGING_READ(r, p)                                               RDP_FIELD_MREAD_8((uint8_t *)(p), 4, 1, (r))
#define RDD_HASH_COMMAND_AGING_WRITE(v, p)                                              RDP_FIELD_MWRITE_8((uint8_t *)(p), 4, 1, (v))
#define RDD_HASH_COMMAND_KEY_1_READ_G(r, g, idx)                                        GROUP_RDP_FIELD_MREAD_32((g), (idx)*sizeof(HASH_COMMAND_STRUCT), 0, 28, (r))
#define RDD_HASH_COMMAND_KEY_1_WRITE_G(v, g, idx)                                       GROUP_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(HASH_COMMAND_STRUCT), 0, 28, (v))
#define RDD_HASH_COMMAND_KEY_1_READ_CORE(r, g, idx, core_id)                            CORE_RDP_FIELD_MREAD_32((g), (idx)*sizeof(HASH_COMMAND_STRUCT), 0, 28, (r), core_id)
#define RDD_HASH_COMMAND_KEY_1_WRITE_CORE(v, g, idx, core_id)                           CORE_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(HASH_COMMAND_STRUCT), 0, 28, (v), core_id)
#define RDD_HASH_COMMAND_KEY_1_READ(r, p)                                               RDP_FIELD_MREAD_32((uint8_t *)(p), 0, 28, (r))
#define RDD_HASH_COMMAND_KEY_1_WRITE(v, p)                                              RDP_FIELD_MWRITE_32((uint8_t *)(p), 0, 28, (v))
#define RDD_HASH_COMMAND_KEY_0_READ_G(r, g, idx)                                        GROUP_MREAD_32((g), (idx)*sizeof(HASH_COMMAND_STRUCT) + 4, (r))
#define RDD_HASH_COMMAND_KEY_0_WRITE_G(v, g, idx)                                       GROUP_MWRITE_32((g), (idx)*sizeof(HASH_COMMAND_STRUCT) + 4, (v))
#define RDD_HASH_COMMAND_KEY_0_READ_CORE(r, g, idx, core_id)                            CORE_MREAD_32((g), (idx)*sizeof(HASH_COMMAND_STRUCT) + 4, (r), core_id)
#define RDD_HASH_COMMAND_KEY_0_WRITE_CORE(v, g, idx, core_id)                           CORE_MWRITE_32((g), (idx)*sizeof(HASH_COMMAND_STRUCT) + 4, (v), core_id)
#define RDD_HASH_COMMAND_KEY_0_READ(r, p)                                               MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_HASH_COMMAND_KEY_0_WRITE(v, p)                                              MWRITE_32((uint8_t *)(p) + 4, (v))
/* <<<HASH_COMMAND_STRUCT */


/* >>>NATC_COMMAND_DATA_STRUCT */
#define RDD_NATC_COMMAND_DATA_KEY_NUMBER	32
typedef union
    {
    uint8_t word_8[36];
    uint16_t word_16[18];
    uint32_t word_32[9];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	command_overwritten                      	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	table_num                                	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	decr                                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	cache_flush                              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved0                                	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	packet_len                               	;
        uint8_t	key[RDD_NATC_COMMAND_DATA_KEY_NUMBER];
#else
        uint16_t	packet_len                               	;
        uint32_t	reserved0                                	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	cache_flush                              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	decr                                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	table_num                                	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	command_overwritten                      	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	key[RDD_NATC_COMMAND_DATA_KEY_NUMBER];
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(4))) NATC_COMMAND_DATA_STRUCT;

#define RDD_NATC_COMMAND_DATA_COMMAND_OVERWRITTEN_READ_G(r, g, idx)                                GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NATC_COMMAND_DATA_STRUCT), 6, 2, (r))
#define RDD_NATC_COMMAND_DATA_COMMAND_OVERWRITTEN_WRITE_G(v, g, idx)                               GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NATC_COMMAND_DATA_STRUCT), 6, 2, (v))
#define RDD_NATC_COMMAND_DATA_COMMAND_OVERWRITTEN_READ_CORE(r, g, idx, core_id)                    CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NATC_COMMAND_DATA_STRUCT), 6, 2, (r), core_id)
#define RDD_NATC_COMMAND_DATA_COMMAND_OVERWRITTEN_WRITE_CORE(v, g, idx, core_id)                   CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NATC_COMMAND_DATA_STRUCT), 6, 2, (v), core_id)
#define RDD_NATC_COMMAND_DATA_COMMAND_OVERWRITTEN_READ(r, p)                                       RDP_FIELD_MREAD_8((uint8_t *)(p), 6, 2, (r))
#define RDD_NATC_COMMAND_DATA_COMMAND_OVERWRITTEN_WRITE(v, p)                                      RDP_FIELD_MWRITE_8((uint8_t *)(p), 6, 2, (v))
#define RDD_NATC_COMMAND_DATA_TABLE_NUM_READ_G(r, g, idx)                                          GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NATC_COMMAND_DATA_STRUCT), 3, 3, (r))
#define RDD_NATC_COMMAND_DATA_TABLE_NUM_WRITE_G(v, g, idx)                                         GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NATC_COMMAND_DATA_STRUCT), 3, 3, (v))
#define RDD_NATC_COMMAND_DATA_TABLE_NUM_READ_CORE(r, g, idx, core_id)                              CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NATC_COMMAND_DATA_STRUCT), 3, 3, (r), core_id)
#define RDD_NATC_COMMAND_DATA_TABLE_NUM_WRITE_CORE(v, g, idx, core_id)                             CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NATC_COMMAND_DATA_STRUCT), 3, 3, (v), core_id)
#define RDD_NATC_COMMAND_DATA_TABLE_NUM_READ(r, p)                                                 RDP_FIELD_MREAD_8((uint8_t *)(p), 3, 3, (r))
#define RDD_NATC_COMMAND_DATA_TABLE_NUM_WRITE(v, p)                                                RDP_FIELD_MWRITE_8((uint8_t *)(p), 3, 3, (v))
#define RDD_NATC_COMMAND_DATA_DECR_READ_G(r, g, idx)                                               GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NATC_COMMAND_DATA_STRUCT), 2, 1, (r))
#define RDD_NATC_COMMAND_DATA_DECR_WRITE_G(v, g, idx)                                              GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NATC_COMMAND_DATA_STRUCT), 2, 1, (v))
#define RDD_NATC_COMMAND_DATA_DECR_READ_CORE(r, g, idx, core_id)                                   CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NATC_COMMAND_DATA_STRUCT), 2, 1, (r), core_id)
#define RDD_NATC_COMMAND_DATA_DECR_WRITE_CORE(v, g, idx, core_id)                                  CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NATC_COMMAND_DATA_STRUCT), 2, 1, (v), core_id)
#define RDD_NATC_COMMAND_DATA_DECR_READ(r, p)                                                      RDP_FIELD_MREAD_8((uint8_t *)(p), 2, 1, (r))
#define RDD_NATC_COMMAND_DATA_DECR_WRITE(v, p)                                                     RDP_FIELD_MWRITE_8((uint8_t *)(p), 2, 1, (v))
#define RDD_NATC_COMMAND_DATA_CACHE_FLUSH_READ_G(r, g, idx)                                        GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NATC_COMMAND_DATA_STRUCT), 1, 1, (r))
#define RDD_NATC_COMMAND_DATA_CACHE_FLUSH_WRITE_G(v, g, idx)                                       GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NATC_COMMAND_DATA_STRUCT), 1, 1, (v))
#define RDD_NATC_COMMAND_DATA_CACHE_FLUSH_READ_CORE(r, g, idx, core_id)                            CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NATC_COMMAND_DATA_STRUCT), 1, 1, (r), core_id)
#define RDD_NATC_COMMAND_DATA_CACHE_FLUSH_WRITE_CORE(v, g, idx, core_id)                           CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NATC_COMMAND_DATA_STRUCT), 1, 1, (v), core_id)
#define RDD_NATC_COMMAND_DATA_CACHE_FLUSH_READ(r, p)                                               RDP_FIELD_MREAD_8((uint8_t *)(p), 1, 1, (r))
#define RDD_NATC_COMMAND_DATA_CACHE_FLUSH_WRITE(v, p)                                              RDP_FIELD_MWRITE_8((uint8_t *)(p), 1, 1, (v))
#define RDD_NATC_COMMAND_DATA_PACKET_LEN_READ_G(r, g, idx)                                         GROUP_MREAD_16((g), (idx)*sizeof(NATC_COMMAND_DATA_STRUCT) + 2, (r))
#define RDD_NATC_COMMAND_DATA_PACKET_LEN_WRITE_G(v, g, idx)                                        GROUP_MWRITE_16((g), (idx)*sizeof(NATC_COMMAND_DATA_STRUCT) + 2, (v))
#define RDD_NATC_COMMAND_DATA_PACKET_LEN_READ_CORE(r, g, idx, core_id)                             CORE_MREAD_16((g), (idx)*sizeof(NATC_COMMAND_DATA_STRUCT) + 2, (r), core_id)
#define RDD_NATC_COMMAND_DATA_PACKET_LEN_WRITE_CORE(v, g, idx, core_id)                            CORE_MWRITE_16((g), (idx)*sizeof(NATC_COMMAND_DATA_STRUCT) + 2, (v), core_id)
#define RDD_NATC_COMMAND_DATA_PACKET_LEN_READ(r, p)                                                MREAD_16((uint8_t *)(p) + 2, (r))
#define RDD_NATC_COMMAND_DATA_PACKET_LEN_WRITE(v, p)                                               MWRITE_16((uint8_t *)(p) + 2, (v))
#define RDD_NATC_COMMAND_DATA_KEY_READ_G(r, g, idx, i)                                             GROUP_MREAD_I_8((g), (idx)*sizeof(NATC_COMMAND_DATA_STRUCT) + 4, i, (r))
#define RDD_NATC_COMMAND_DATA_KEY_WRITE_G(v, g, idx, i)                                            GROUP_MWRITE_I_8((g), (idx)*sizeof(NATC_COMMAND_DATA_STRUCT) + 4, i, (v))
#define RDD_NATC_COMMAND_DATA_KEY_READ_CORE(r, g, idx, i, core_id)                                 CORE_MREAD_I_8((g), (idx)*sizeof(NATC_COMMAND_DATA_STRUCT) + 4, i, (r), core_id)
#define RDD_NATC_COMMAND_DATA_KEY_WRITE_CORE(v, g, idx, i, core_id)                                CORE_MWRITE_I_8((g), (idx)*sizeof(NATC_COMMAND_DATA_STRUCT) + 4, i, (v), core_id)
#define RDD_NATC_COMMAND_DATA_KEY_READ(r, p, i)                                                    MREAD_I_8((uint8_t *)(p) + 4, i, (r))
#define RDD_NATC_COMMAND_DATA_KEY_WRITE(v, p, i)                                                   MWRITE_I_8((uint8_t *)(p) + 4, i, (v))
/* <<<NATC_COMMAND_DATA_STRUCT */


/* >>>AGGREGATED_PD_DESCRIPTOR_STRUCT */
typedef union
    {
    uint8_t word_8[16];
    uint16_t word_16[8];
    uint32_t word_32[4];
    uint64_t dword_64[2];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
	/* Union WORD 0 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	valid                       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	second_level_q_3_or_same_second_level_q	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	plen_2                      	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	plen_1                      	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	plen_0                      	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 1 */
		struct{
        uint32_t	reservedSU1_valid                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	second_level_queue_3_bits5_8          	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of second_level_q_3_or_same_second_level_q union */
        uint32_t	reservedSU1_plen_2                    	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_plen_1                    	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_plen_0                    	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 2 */
		struct{
        uint32_t	reservedSU2_valid                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	same_second_level_q                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of second_level_q_3_or_same_second_level_q union */
        uint32_t	second_level_queue_3_bits5_7          	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of second_level_q_3_or_same_second_level_q union */
        uint32_t	reservedSU2_plen_2                    	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_plen_1                    	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_plen_0                    	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
	/* Union WORD 1 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	second_level_queues         	; /* This is a field union */
		};
		/* Sub Union 1 */
		struct{
        uint32_t	last                                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of second_level_queues union */
        uint32_t	reserved0                             	:31	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of second_level_queues union */
		};
		/* Sub Union 2 */
		struct{
        uint32_t	second_level_queue_3_bits0_4          	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of second_level_queues union */
        uint32_t	second_level_queue_2                  	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of second_level_queues union */
        uint32_t	second_level_queue_1                  	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of second_level_queues union */
        uint32_t	second_level_queue_0                  	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of second_level_queues union */
		};
		/* Sub Union 3 */
		struct{
        uint32_t	reserved3                             	:23	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of second_level_queues union */
        uint32_t	codel_timestamp                       	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of second_level_queues union */
		};
	};
	/* Union WORD 2 */
	union{
		/* Sub Union 0 */
		struct{
        uint8_t	mac_flow_3                  	;
        uint8_t	mac_flow_2                  	;
        uint8_t	mac_flow_1                  	;
        uint8_t	aggregated_pd_mac_flow      	; /* This is a field union */
		};
		/* Sub Union 1 */
		struct{
        uint8_t	reservedSU1_mac_flow_3                	;
        uint8_t	reservedSU1_mac_flow_2                	;
        uint8_t	reservedSU1_mac_flow_1                	;
        uint8_t	mac_flow_0                            	; /* Member of aggregated_pd_mac_flow union */
		};
		/* Sub Union 2 */
		struct{
        uint8_t	reservedSU2_mac_flow_3                	;
        uint8_t	reservedSU2_mac_flow_2                	;
        uint8_t	reservedSU2_mac_flow_1                	;
        uint8_t	flow_id_0                             	; /* Member of aggregated_pd_mac_flow union */
		};
	};
	/* Union WORD 3 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	agg_pd                      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	target_mem_0                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	num_packets                 	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	total_plen                  	:10	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	buffer_number_0             	:18	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
		};
		/* Sub Union 1 */
		struct{
        uint32_t	reservedSU1_agg_pd                    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_target_mem_0              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_num_packets               	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_total_plen                	:10	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	fpm                                   	:18	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of buffer_number_0 union */
		};
		/* Sub Union 2 */
		struct{
        uint32_t	reservedSU2_agg_pd                    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_target_mem_0              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_num_packets               	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_total_plen                	:10	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	sbpm                                  	:18	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of buffer_number_0 union */
		};
	};
#else
	/* Union WORD 0 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	plen_0                      	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	plen_1                      	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	plen_2                      	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	second_level_q_3_or_same_second_level_q	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	valid                       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 1 */
		struct{
        uint32_t	reservedSU1_plen_0                    	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_plen_1                    	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_plen_2                    	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	second_level_queue_3_bits5_8          	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of second_level_q_3_or_same_second_level_q union */
        uint32_t	reservedSU1_valid                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 2 */
		struct{
        uint32_t	reservedSU2_plen_0                    	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_plen_1                    	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_plen_2                    	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	second_level_queue_3_bits5_7          	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of second_level_q_3_or_same_second_level_q union */
        uint32_t	same_second_level_q                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of second_level_q_3_or_same_second_level_q union */
        uint32_t	reservedSU2_valid                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
	/* Union WORD 1 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	second_level_queues         	; /* This is a field union */
		};
		/* Sub Union 1 */
		struct{
        uint32_t	reserved0                             	:31	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of second_level_queues union */
        uint32_t	last                                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of second_level_queues union */
		};
		/* Sub Union 2 */
		struct{
        uint32_t	second_level_queue_0                  	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of second_level_queues union */
        uint32_t	second_level_queue_1                  	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of second_level_queues union */
        uint32_t	second_level_queue_2                  	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of second_level_queues union */
        uint32_t	second_level_queue_3_bits0_4          	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of second_level_queues union */
		};
		/* Sub Union 3 */
		struct{
        uint32_t	codel_timestamp                       	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of second_level_queues union */
        uint32_t	reserved3                             	:23	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of second_level_queues union */
		};
	};
	/* Union WORD 2 */
	union{
		/* Sub Union 0 */
		struct{
        uint8_t	aggregated_pd_mac_flow      	; /* This is a field union */
        uint8_t	mac_flow_1                  	;
        uint8_t	mac_flow_2                  	;
        uint8_t	mac_flow_3                  	;
		};
		/* Sub Union 1 */
		struct{
        uint8_t	mac_flow_0                            	; /* Member of aggregated_pd_mac_flow union */
        uint8_t	reservedSU1_mac_flow_1                	;
        uint8_t	reservedSU1_mac_flow_2                	;
        uint8_t	reservedSU1_mac_flow_3                	;
		};
		/* Sub Union 2 */
		struct{
        uint8_t	flow_id_0                             	; /* Member of aggregated_pd_mac_flow union */
        uint8_t	reservedSU2_mac_flow_1                	;
        uint8_t	reservedSU2_mac_flow_2                	;
        uint8_t	reservedSU2_mac_flow_3                	;
		};
	};
	/* Union WORD 3 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	buffer_number_0             	:18	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	total_plen                  	:10	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	num_packets                 	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	target_mem_0                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	agg_pd                      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 1 */
		struct{
        uint32_t	fpm                                   	:18	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of buffer_number_0 union */
        uint32_t	reservedSU1_total_plen                	:10	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_num_packets               	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_target_mem_0              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_agg_pd                    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 2 */
		struct{
        uint32_t	sbpm                                  	:18	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of buffer_number_0 union */
        uint32_t	reservedSU2_total_plen                	:10	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_num_packets               	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_target_mem_0              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_agg_pd                    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) AGGREGATED_PD_DESCRIPTOR_STRUCT;

#define RDD_AGGREGATED_PD_DESCRIPTOR_VALID_READ_G(r, g, idx)                                                       GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(AGGREGATED_PD_DESCRIPTOR_STRUCT), 7, 1, (r))
#define RDD_AGGREGATED_PD_DESCRIPTOR_VALID_WRITE_G(v, g, idx)                                                      GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(AGGREGATED_PD_DESCRIPTOR_STRUCT), 7, 1, (v))
#define RDD_AGGREGATED_PD_DESCRIPTOR_VALID_READ_CORE(r, g, idx, core_id)                                           CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(AGGREGATED_PD_DESCRIPTOR_STRUCT), 7, 1, (r), core_id)
#define RDD_AGGREGATED_PD_DESCRIPTOR_VALID_WRITE_CORE(v, g, idx, core_id)                                          CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(AGGREGATED_PD_DESCRIPTOR_STRUCT), 7, 1, (v), core_id)
#define RDD_AGGREGATED_PD_DESCRIPTOR_VALID_READ(r, p)                                                              RDP_FIELD_MREAD_8((uint8_t *)(p), 7, 1, (r))
#define RDD_AGGREGATED_PD_DESCRIPTOR_VALID_WRITE(v, p)                                                             RDP_FIELD_MWRITE_8((uint8_t *)(p), 7, 1, (v))
#define RDD_AGGREGATED_PD_DESCRIPTOR_VALID_L_READ( wv )                                                            RDP_FIELD_GET( wv, 31, 1 )
#define RDD_AGGREGATED_PD_DESCRIPTOR_VALID_L_WRITE( v, wv )                                                        RDP_FIELD_SET( v, 31, 1, wv )
#define RDD_AGGREGATED_PD_DESCRIPTOR_SECOND_LEVEL_Q_3_OR_SAME_SECOND_LEVEL_Q_READ_G(r, g, idx)                     GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(AGGREGATED_PD_DESCRIPTOR_STRUCT), 3, 4, (r))
#define RDD_AGGREGATED_PD_DESCRIPTOR_SECOND_LEVEL_Q_3_OR_SAME_SECOND_LEVEL_Q_WRITE_G(v, g, idx)                    GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(AGGREGATED_PD_DESCRIPTOR_STRUCT), 3, 4, (v))
#define RDD_AGGREGATED_PD_DESCRIPTOR_SECOND_LEVEL_Q_3_OR_SAME_SECOND_LEVEL_Q_READ_CORE(r, g, idx, core_id)         CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(AGGREGATED_PD_DESCRIPTOR_STRUCT), 3, 4, (r), core_id)
#define RDD_AGGREGATED_PD_DESCRIPTOR_SECOND_LEVEL_Q_3_OR_SAME_SECOND_LEVEL_Q_WRITE_CORE(v, g, idx, core_id)        CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(AGGREGATED_PD_DESCRIPTOR_STRUCT), 3, 4, (v), core_id)
#define RDD_AGGREGATED_PD_DESCRIPTOR_SECOND_LEVEL_Q_3_OR_SAME_SECOND_LEVEL_Q_READ(r, p)                            RDP_FIELD_MREAD_8((uint8_t *)(p), 3, 4, (r))
#define RDD_AGGREGATED_PD_DESCRIPTOR_SECOND_LEVEL_Q_3_OR_SAME_SECOND_LEVEL_Q_WRITE(v, p)                           RDP_FIELD_MWRITE_8((uint8_t *)(p), 3, 4, (v))
#define RDD_AGGREGATED_PD_DESCRIPTOR_SECOND_LEVEL_Q_3_OR_SAME_SECOND_LEVEL_Q_L_READ( wv )                          RDP_FIELD_GET( wv, 27, 4 )
#define RDD_AGGREGATED_PD_DESCRIPTOR_SECOND_LEVEL_Q_3_OR_SAME_SECOND_LEVEL_Q_L_WRITE( v, wv )                      RDP_FIELD_SET( v, 27, 4, wv )
#define RDD_AGGREGATED_PD_DESCRIPTOR_SECOND_LEVEL_QUEUE_3_BITS5_8_READ_G(r, g, idx)                                GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(AGGREGATED_PD_DESCRIPTOR_STRUCT), 3, 4, (r))
#define RDD_AGGREGATED_PD_DESCRIPTOR_SECOND_LEVEL_QUEUE_3_BITS5_8_WRITE_G(v, g, idx)                               GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(AGGREGATED_PD_DESCRIPTOR_STRUCT), 3, 4, (v))
#define RDD_AGGREGATED_PD_DESCRIPTOR_SECOND_LEVEL_QUEUE_3_BITS5_8_READ_CORE(r, g, idx, core_id)                    CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(AGGREGATED_PD_DESCRIPTOR_STRUCT), 3, 4, (r), core_id)
#define RDD_AGGREGATED_PD_DESCRIPTOR_SECOND_LEVEL_QUEUE_3_BITS5_8_WRITE_CORE(v, g, idx, core_id)                   CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(AGGREGATED_PD_DESCRIPTOR_STRUCT), 3, 4, (v), core_id)
#define RDD_AGGREGATED_PD_DESCRIPTOR_SECOND_LEVEL_QUEUE_3_BITS5_8_READ(r, p)                                       RDP_FIELD_MREAD_8((uint8_t *)(p), 3, 4, (r))
#define RDD_AGGREGATED_PD_DESCRIPTOR_SECOND_LEVEL_QUEUE_3_BITS5_8_WRITE(v, p)                                      RDP_FIELD_MWRITE_8((uint8_t *)(p), 3, 4, (v))
#define RDD_AGGREGATED_PD_DESCRIPTOR_SECOND_LEVEL_QUEUE_3_BITS5_8_L_READ( wv )                                     RDP_FIELD_GET( wv, 27, 4 )
#define RDD_AGGREGATED_PD_DESCRIPTOR_SECOND_LEVEL_QUEUE_3_BITS5_8_L_WRITE( v, wv )                                 RDP_FIELD_SET( v, 27, 4, wv )
#define RDD_AGGREGATED_PD_DESCRIPTOR_SAME_SECOND_LEVEL_Q_READ_G(r, g, idx)                                         GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(AGGREGATED_PD_DESCRIPTOR_STRUCT), 6, 1, (r))
#define RDD_AGGREGATED_PD_DESCRIPTOR_SAME_SECOND_LEVEL_Q_WRITE_G(v, g, idx)                                        GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(AGGREGATED_PD_DESCRIPTOR_STRUCT), 6, 1, (v))
#define RDD_AGGREGATED_PD_DESCRIPTOR_SAME_SECOND_LEVEL_Q_READ_CORE(r, g, idx, core_id)                             CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(AGGREGATED_PD_DESCRIPTOR_STRUCT), 6, 1, (r), core_id)
#define RDD_AGGREGATED_PD_DESCRIPTOR_SAME_SECOND_LEVEL_Q_WRITE_CORE(v, g, idx, core_id)                            CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(AGGREGATED_PD_DESCRIPTOR_STRUCT), 6, 1, (v), core_id)
#define RDD_AGGREGATED_PD_DESCRIPTOR_SAME_SECOND_LEVEL_Q_READ(r, p)                                                RDP_FIELD_MREAD_8((uint8_t *)(p), 6, 1, (r))
#define RDD_AGGREGATED_PD_DESCRIPTOR_SAME_SECOND_LEVEL_Q_WRITE(v, p)                                               RDP_FIELD_MWRITE_8((uint8_t *)(p), 6, 1, (v))
#define RDD_AGGREGATED_PD_DESCRIPTOR_SAME_SECOND_LEVEL_Q_L_READ( wv )                                              RDP_FIELD_GET( wv, 30, 1 )
#define RDD_AGGREGATED_PD_DESCRIPTOR_SAME_SECOND_LEVEL_Q_L_WRITE( v, wv )                                          RDP_FIELD_SET( v, 30, 1, wv )
#define RDD_AGGREGATED_PD_DESCRIPTOR_SECOND_LEVEL_QUEUE_3_BITS5_7_READ_G(r, g, idx)                                GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(AGGREGATED_PD_DESCRIPTOR_STRUCT), 3, 3, (r))
#define RDD_AGGREGATED_PD_DESCRIPTOR_SECOND_LEVEL_QUEUE_3_BITS5_7_WRITE_G(v, g, idx)                               GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(AGGREGATED_PD_DESCRIPTOR_STRUCT), 3, 3, (v))
#define RDD_AGGREGATED_PD_DESCRIPTOR_SECOND_LEVEL_QUEUE_3_BITS5_7_READ_CORE(r, g, idx, core_id)                    CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(AGGREGATED_PD_DESCRIPTOR_STRUCT), 3, 3, (r), core_id)
#define RDD_AGGREGATED_PD_DESCRIPTOR_SECOND_LEVEL_QUEUE_3_BITS5_7_WRITE_CORE(v, g, idx, core_id)                   CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(AGGREGATED_PD_DESCRIPTOR_STRUCT), 3, 3, (v), core_id)
#define RDD_AGGREGATED_PD_DESCRIPTOR_SECOND_LEVEL_QUEUE_3_BITS5_7_READ(r, p)                                       RDP_FIELD_MREAD_8((uint8_t *)(p), 3, 3, (r))
#define RDD_AGGREGATED_PD_DESCRIPTOR_SECOND_LEVEL_QUEUE_3_BITS5_7_WRITE(v, p)                                      RDP_FIELD_MWRITE_8((uint8_t *)(p), 3, 3, (v))
#define RDD_AGGREGATED_PD_DESCRIPTOR_SECOND_LEVEL_QUEUE_3_BITS5_7_L_READ( wv )                                     RDP_FIELD_GET( wv, 27, 3 )
#define RDD_AGGREGATED_PD_DESCRIPTOR_SECOND_LEVEL_QUEUE_3_BITS5_7_L_WRITE( v, wv )                                 RDP_FIELD_SET( v, 27, 3, wv )
#define RDD_AGGREGATED_PD_DESCRIPTOR_PLEN_2_READ_G(r, g, idx)                                                      GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(AGGREGATED_PD_DESCRIPTOR_STRUCT), 2, 9, (r))
#define RDD_AGGREGATED_PD_DESCRIPTOR_PLEN_2_WRITE_G(v, g, idx)                                                     GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(AGGREGATED_PD_DESCRIPTOR_STRUCT), 2, 9, (v))
#define RDD_AGGREGATED_PD_DESCRIPTOR_PLEN_2_READ_CORE(r, g, idx, core_id)                                          CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(AGGREGATED_PD_DESCRIPTOR_STRUCT), 2, 9, (r), core_id)
#define RDD_AGGREGATED_PD_DESCRIPTOR_PLEN_2_WRITE_CORE(v, g, idx, core_id)                                         CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(AGGREGATED_PD_DESCRIPTOR_STRUCT), 2, 9, (v), core_id)
#define RDD_AGGREGATED_PD_DESCRIPTOR_PLEN_2_READ(r, p)                                                             RDP_FIELD_MREAD_16((uint8_t *)(p), 2, 9, (r))
#define RDD_AGGREGATED_PD_DESCRIPTOR_PLEN_2_WRITE(v, p)                                                            RDP_FIELD_MWRITE_16((uint8_t *)(p), 2, 9, (v))
#define RDD_AGGREGATED_PD_DESCRIPTOR_PLEN_2_L_READ( wv )                                                           RDP_FIELD_GET( wv, 18, 9 )
#define RDD_AGGREGATED_PD_DESCRIPTOR_PLEN_2_L_WRITE( v, wv )                                                       RDP_FIELD_SET( v, 18, 9, wv )
#define RDD_AGGREGATED_PD_DESCRIPTOR_PLEN_1_READ_G(r, g, idx)                                                      GROUP_RDP_FIELD_MREAD_32((g), (idx)*sizeof(AGGREGATED_PD_DESCRIPTOR_STRUCT) + 0, 9, 9, (r))
#define RDD_AGGREGATED_PD_DESCRIPTOR_PLEN_1_WRITE_G(v, g, idx)                                                     GROUP_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(AGGREGATED_PD_DESCRIPTOR_STRUCT) + 0, 9, 9, (v))
#define RDD_AGGREGATED_PD_DESCRIPTOR_PLEN_1_READ_CORE(r, g, idx, core_id)                                          CORE_RDP_FIELD_MREAD_32((g), (idx)*sizeof(AGGREGATED_PD_DESCRIPTOR_STRUCT) + 0, 9, 9, (r), core_id)
#define RDD_AGGREGATED_PD_DESCRIPTOR_PLEN_1_WRITE_CORE(v, g, idx, core_id)                                         CORE_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(AGGREGATED_PD_DESCRIPTOR_STRUCT) + 0, 9, 9, (v), core_id)
#define RDD_AGGREGATED_PD_DESCRIPTOR_PLEN_1_READ(r, p)                                                             RDP_FIELD_MREAD_32((uint8_t *)(p) + 0, 9, 9, (r))
#define RDD_AGGREGATED_PD_DESCRIPTOR_PLEN_1_WRITE(v, p)                                                            RDP_FIELD_MWRITE_32((uint8_t *)(p) + 0, 9, 9, (v))
#define RDD_AGGREGATED_PD_DESCRIPTOR_PLEN_1_L_READ( wv )                                                           RDP_FIELD_GET( wv, 9, 9 )
#define RDD_AGGREGATED_PD_DESCRIPTOR_PLEN_1_L_WRITE( v, wv )                                                       RDP_FIELD_SET( v, 9, 9, wv )
#define RDD_AGGREGATED_PD_DESCRIPTOR_PLEN_0_READ_G(r, g, idx)                                                      GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(AGGREGATED_PD_DESCRIPTOR_STRUCT) + 2, 0, 9, (r))
#define RDD_AGGREGATED_PD_DESCRIPTOR_PLEN_0_WRITE_G(v, g, idx)                                                     GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(AGGREGATED_PD_DESCRIPTOR_STRUCT) + 2, 0, 9, (v))
#define RDD_AGGREGATED_PD_DESCRIPTOR_PLEN_0_READ_CORE(r, g, idx, core_id)                                          CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(AGGREGATED_PD_DESCRIPTOR_STRUCT) + 2, 0, 9, (r), core_id)
#define RDD_AGGREGATED_PD_DESCRIPTOR_PLEN_0_WRITE_CORE(v, g, idx, core_id)                                         CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(AGGREGATED_PD_DESCRIPTOR_STRUCT) + 2, 0, 9, (v), core_id)
#define RDD_AGGREGATED_PD_DESCRIPTOR_PLEN_0_READ(r, p)                                                             RDP_FIELD_MREAD_16((uint8_t *)(p) + 2, 0, 9, (r))
#define RDD_AGGREGATED_PD_DESCRIPTOR_PLEN_0_WRITE(v, p)                                                            RDP_FIELD_MWRITE_16((uint8_t *)(p) + 2, 0, 9, (v))
#define RDD_AGGREGATED_PD_DESCRIPTOR_PLEN_0_L_READ( wv )                                                           RDP_FIELD_GET( wv, 0, 9 )
#define RDD_AGGREGATED_PD_DESCRIPTOR_PLEN_0_L_WRITE( v, wv )                                                       RDP_FIELD_SET( v, 0, 9, wv )
#define RDD_AGGREGATED_PD_DESCRIPTOR_SECOND_LEVEL_QUEUES_READ_G(r, g, idx)                                         GROUP_MREAD_32((g), (idx)*sizeof(AGGREGATED_PD_DESCRIPTOR_STRUCT) + 4, (r))
#define RDD_AGGREGATED_PD_DESCRIPTOR_SECOND_LEVEL_QUEUES_WRITE_G(v, g, idx)                                        GROUP_MWRITE_32((g), (idx)*sizeof(AGGREGATED_PD_DESCRIPTOR_STRUCT) + 4, (v))
#define RDD_AGGREGATED_PD_DESCRIPTOR_SECOND_LEVEL_QUEUES_READ_CORE(r, g, idx, core_id)                             CORE_MREAD_32((g), (idx)*sizeof(AGGREGATED_PD_DESCRIPTOR_STRUCT) + 4, (r), core_id)
#define RDD_AGGREGATED_PD_DESCRIPTOR_SECOND_LEVEL_QUEUES_WRITE_CORE(v, g, idx, core_id)                            CORE_MWRITE_32((g), (idx)*sizeof(AGGREGATED_PD_DESCRIPTOR_STRUCT) + 4, (v), core_id)
#define RDD_AGGREGATED_PD_DESCRIPTOR_SECOND_LEVEL_QUEUES_READ(r, p)                                                MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_AGGREGATED_PD_DESCRIPTOR_SECOND_LEVEL_QUEUES_WRITE(v, p)                                               MWRITE_32((uint8_t *)(p) + 4, (v))
#define RDD_AGGREGATED_PD_DESCRIPTOR_SECOND_LEVEL_QUEUES_L_READ( wv )                                              RDP_FIELD_GET( wv