#ifndef __MDM_OBJECT_H__
#define __MDM_OBJECT_H__


/*
 * This file is automatically generated from the data-model spreadsheet.
 * Do not modify this file directly - You will lose all your changes the
 * next time this file is generated!
 */


/*!\file mdm_object.h 
 * \brief Automatically generated header file mdm_object.h
 */


#include "cms.h"

/*! \brief Obj struct for InternetGatewayDevice.
 *
 * MDMOID_IGD 1
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    deviceSummary;	/**< ReadOnly */
    UINT32    LANDeviceNumberOfEntries;	/**< ReadOnly */
    UINT32    WANDeviceNumberOfEntries;	/**< ReadOnly */
#ifdef DMP_DOWNLOAD_1
    UBOOL8    IPv4DownloadDiagnosticsSupported;	/**< ReadOnly */
#endif
#ifdef DMP_DOWNLOAD_1
    UBOOL8    IPv6DownloadDiagnosticsSupported;	/**< ReadOnly */
#endif
#ifdef DMP_UPLOAD_1
    UBOOL8    IPv4UploadDiagnosticsSupported;	/**< ReadOnly */
#endif
#ifdef DMP_UPLOAD_1
    UBOOL8    IPv6UploadDiagnosticsSupported;	/**< ReadOnly */
#endif
#ifdef DMP_UDPECHO_1
    UBOOL8    IPv4UDPEchoDiagnosticsSupported;	/**< ReadOnly */
#endif
#ifdef DMP_UDPECHO_1
    UBOOL8    IPv6UDPEchoDiagnosticsSupported;	/**< ReadOnly */
#endif
} IGDObject;

/*! \brief _IGDObject is used internally to represent IGDObject */
typedef IGDObject _IGDObject;



/*! \brief Obj struct for InternetGatewayDevice.DeviceInfo.
 *
 * MDMOID_IGD_DEVICE_INFO 2
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    manufacturer;	/**< ReadOnly */
    char *    manufacturerOUI;	/**< ReadOnly */
    char *    modelName;	/**< ReadOnly */
    char *    description;	/**< ReadOnly */
    char *    productClass;	/**< ReadOnly */
    char *    serialNumber;	/**< ReadOnly */
    char *    hardwareVersion;	/**< ReadOnly */
    char *    softwareVersion;	/**< ReadOnly */
    char *    modemFirmwareVersion;	/**< ReadOnly */
    char *    enabledOptions;	/**< ReadOnly */
    char *    additionalHardwareVersion;	/**< ReadOnly */
    char *    additionalSoftwareVersion;	/**< ReadOnly */
    char *    specVersion;	/**< ReadOnly */
    char *    provisioningCode;	/**< ReadWrite */
    UINT32    upTime;	/**< ReadOnly */
    DATETIME  firstUseDate;	/**< ReadOnly */
#ifdef DMP_X_BROADCOM_COM_BASELINE_1
    UINT32    X_BROADCOM_COM_NumberOfCpuThreads;	/**< ReadOnly */
#endif
    char *    X_BROADCOM_COM_SwBuildTimestamp;	/**< ReadOnly */
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    char *    X_BROADCOM_COM_DslPhyDrvVersion;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_PSTNENDPOINT_1
    char *    X_BROADCOM_COM_VoiceServiceVersion;	/**< ReadOnly */
#endif
    char *    deviceLog;	/**< ReadOnly */
    UINT32    vendorConfigFileNumberOfEntries;	/**< ReadOnly */
} IGDDeviceInfoObject;

/*! \brief _IGDDeviceInfoObject is used internally to represent IGDDeviceInfoObject */
typedef IGDDeviceInfoObject _IGDDeviceInfoObject;



/*! \brief Obj struct for InternetGatewayDevice.DeviceInfo.VendorConfigFile.{i}.
 *
 * MDMOID_VENDOR_CONFIG_FILE 3
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    name;	/**< ReadOnly */
    char *    version;	/**< ReadOnly */
    DATETIME  date;	/**< ReadOnly */
    char *    description;	/**< ReadOnly */
} VendorConfigFileObject;

/*! \brief _VendorConfigFileObject is used internally to represent VendorConfigFileObject */
typedef VendorConfigFileObject _VendorConfigFileObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_SyslogCfg.
 *
 * MDMOID_SYSLOG_CFG 3110
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    status;	/**< ReadWrite */
    char *    option;	/**< ReadWrite */
    char *    localDisplayLevel;	/**< ReadWrite */
    char *    localLogLevel;	/**< ReadWrite */
    char *    remoteLogLevel;	/**< ReadWrite */
    char *    serverIPAddress;	/**< ReadWrite */
    UINT32    serverPortNumber;	/**< ReadWrite */
} SyslogCfgObject;

/*! \brief _SyslogCfgObject is used internally to represent SyslogCfgObject */
typedef SyslogCfgObject _SyslogCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_LoginCfg.
 *
 * MDMOID_LOGIN_CFG 3120
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    adminUserName;	/**< ReadOnly */
    char *    adminPassword;	/**< ReadWrite */
    char *    adminPasswordHash;	/**< ReadWrite */
    char *    supportUserName;	/**< ReadOnly */
    char *    supportPassword;	/**< ReadWrite */
    char *    supportPasswordHash;	/**< ReadWrite */
    char *    userUserName;	/**< ReadOnly */
    char *    userPassword;	/**< ReadWrite */
    char *    userPasswordHash;	/**< ReadWrite */
} LoginCfgObject;

/*! \brief _LoginCfgObject is used internally to represent LoginCfgObject */
typedef LoginCfgObject _LoginCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_SELT_TEST.
 *
 * MDMOID_SELT 3290
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
} SeltObject;

/*! \brief _SeltObject is used internally to represent SeltObject */
typedef SeltObject _SeltObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_SELT_TEST.Configuration.
 *
 * MDMOID_SELT_CFG 3291
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    seltTestState;	/**< ReadWrite */
    char *    maxSeltF;	/**< ReadWrite */
    char *    maxSeltT;	/**< ReadWrite */
    char *    maxSeltPSD;	/**< ReadWrite */
    char *    CID;	/**< ReadWrite */
    UINT32    lineNumber;	/**< ReadWrite */
} SeltCfgObject;

/*! \brief _SeltCfgObject is used internally to represent SeltCfgObject */
typedef SeltCfgObject _SeltCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_SELT_TEST.Result.{i}.
 *
 * MDMOID_SELT_RESULT 3292
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    CID;	/**< Read */
    UINT32    lineNumber;	/**< Read */
    DATETIME  testStartTime;	/**< Read */
    DATETIME  testEndTime;	/**< Read */
    char *    maxSeltPSD;	/**< Read */
    char *    maxSeltF;	/**< Read */
    char *    maxSeltT;	/**< Read */
    char *    UER;	/**< Read */
    char *    loopEchoResponse;	/**< Read */
    char *    loopLength;	/**< Read */
    char *    gauge;	/**< Read */
    UINT32    BTLen1;	/**< Read */
    UINT32    BTLocation1;	/**< Read */
    UINT32    BTLen2;	/**< Read */
    UINT32    BTLocation2;	/**< Read */
    char *    NETerminationType;	/**< Read */
    UINT32    missingMicrofilterLocation;	/**< Read */
    UINT32    shortLocation1;	/**< Read */
    UINT32    shortLocation2;	/**< Read */
    UINT32    openLocation1;	/**< Read */
    UINT32    openLocation2;	/**< Read */
} SeltResultObject;

/*! \brief _SeltResultObject is used internally to represent SeltResultObject */
typedef SeltResultObject _SeltResultObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_AppCfg.
 *
 * MDMOID_APP_CFG 3130
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
} AppCfgObject;

/*! \brief _AppCfgObject is used internally to represent AppCfgObject */
typedef AppCfgObject _AppCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_AppCfg.HttpdCfg.
 *
 * MDMOID_HTTPD_CFG 3150
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    networkAccess;	/**< ReadWrite */
    char *    loggingLevel;	/**< ReadWrite */
    char *    loggingDestination;	/**< ReadWrite */
    UBOOL8    quickSetupEnabled;	/**< ReadWrite */
} HttpdCfgObject;

/*! \brief _HttpdCfgObject is used internally to represent HttpdCfgObject */
typedef HttpdCfgObject _HttpdCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_AppCfg.Tr69cCfg.
 *
 * MDMOID_TR69C_CFG 3131
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    loggingLevel;	/**< ReadWrite */
    char *    loggingDestination;	/**< ReadWrite */
#ifdef DMP_X_BROADCOM_COM_DEBUG_1
    UBOOL8    loggingSOAP;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_SECURITY_1
    UBOOL8    connectionRequestAuthentication;	/**< ReadWrite */
#endif
} Tr69cCfgObject;

/*! \brief _Tr69cCfgObject is used internally to represent Tr69cCfgObject */
typedef Tr69cCfgObject _Tr69cCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_AppCfg.SshdCfg.
 *
 * MDMOID_SSHD_CFG 3132
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    networkAccess;	/**< ReadWrite */
    char *    loggingLevel;	/**< ReadWrite */
    char *    loggingDestination;	/**< ReadWrite */
} SshdCfgObject;

/*! \brief _SshdCfgObject is used internally to represent SshdCfgObject */
typedef SshdCfgObject _SshdCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_AppCfg.TelnetdCfg.
 *
 * MDMOID_TELNETD_CFG 3133
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    networkAccess;	/**< ReadWrite */
    char *    loggingLevel;	/**< ReadWrite */
    char *    loggingDestination;	/**< ReadWrite */
} TelnetdCfgObject;

/*! \brief _TelnetdCfgObject is used internally to represent TelnetdCfgObject */
typedef TelnetdCfgObject _TelnetdCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_AppCfg.ConsoledCfg.
 *
 * MDMOID_CONSOLED_CFG 3134
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    loggingLevel;	/**< ReadWrite */
    char *    loggingDestination;	/**< ReadWrite */
} ConsoledCfgObject;

/*! \brief _ConsoledCfgObject is used internally to represent ConsoledCfgObject */
typedef ConsoledCfgObject _ConsoledCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_AppCfg.SmdCfg.
 *
 * MDMOID_SMD_CFG 3135
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    loggingLevel;	/**< ReadWrite */
    char *    loggingDestination;	/**< ReadWrite */
} SmdCfgObject;

/*! \brief _SmdCfgObject is used internally to represent SmdCfgObject */
typedef SmdCfgObject _SmdCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_AppCfg.SskCfg.
 *
 * MDMOID_SSK_CFG 3136
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    loggingLevel;	/**< ReadWrite */
    char *    loggingDestination;	/**< ReadWrite */
} SskCfgObject;

/*! \brief _SskCfgObject is used internally to represent SskCfgObject */
typedef SskCfgObject _SskCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_AppCfg.FtpdCfg.
 *
 * MDMOID_FTPD_CFG 3137
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    networkAccess;	/**< ReadWrite */
    char *    loggingLevel;	/**< ReadWrite */
    char *    loggingDestination;	/**< ReadWrite */
} FtpdCfgObject;

/*! \brief _FtpdCfgObject is used internally to represent FtpdCfgObject */
typedef FtpdCfgObject _FtpdCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_AppCfg.TftpdCfg.
 *
 * MDMOID_TFTPD_CFG 3138
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    networkAccess;	/**< ReadWrite */
    char *    loggingLevel;	/**< ReadWrite */
    char *    loggingDestination;	/**< ReadWrite */
} TftpdCfgObject;

/*! \brief _TftpdCfgObject is used internally to represent TftpdCfgObject */
typedef TftpdCfgObject _TftpdCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_AppCfg.PppdCfg.
 *
 * MDMOID_PPPD_CFG 3139
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    loggingLevel;	/**< ReadWrite */
    char *    loggingDestination;	/**< ReadWrite */
} PppdCfgObject;

/*! \brief _PppdCfgObject is used internally to represent PppdCfgObject */
typedef PppdCfgObject _PppdCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_AppCfg.IcmpCfg.
 *
 * MDMOID_ICMP_CFG 3140
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    networkAccess;	/**< ReadWrite */
} IcmpCfgObject;

/*! \brief _IcmpCfgObject is used internally to represent IcmpCfgObject */
typedef IcmpCfgObject _IcmpCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_AppCfg.UpnpCfg.
 *
 * MDMOID_UPNP_CFG 3141
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    loggingLevel;	/**< ReadWrite */
    char *    loggingDestination;	/**< ReadWrite */
} UpnpCfgObject;

/*! \brief _UpnpCfgObject is used internally to represent UpnpCfgObject */
typedef UpnpCfgObject _UpnpCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_AppCfg.DnsProxyCfg.
 *
 * MDMOID_DNS_PROXY_CFG 3142
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    deviceDomainName;	/**< ReadWrite */
    char *    deviceHostName;	/**< ReadWrite */
    char *    loggingLevel;	/**< ReadWrite */
    char *    loggingDestination;	/**< ReadWrite */
} DnsProxyCfgObject;

/*! \brief _DnsProxyCfgObject is used internally to represent DnsProxyCfgObject */
typedef DnsProxyCfgObject _DnsProxyCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_AppCfg.L2tpAcClientCfg.
 *
 * MDMOID_L2TP_AC_CLIENT_CFG 3143
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    UINT32    numberOfClient;	/**< ReadOnly */
    char *    loggingLevel;	/**< ReadWrite */
    char *    loggingDestination;	/**< ReadWrite */
} L2tpAcClientCfgObject;

/*! \brief _L2tpAcClientCfgObject is used internally to represent L2tpAcClientCfgObject */
typedef L2tpAcClientCfgObject _L2tpAcClientCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_AppCfg.VectoringCfg.
 *
 * MDMOID_VECTORING_CFG 3144
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    loggingLevel;	/**< ReadWrite */
    char *    loggingDestination;	/**< ReadWrite */
} VectoringCfgObject;

/*! \brief _VectoringCfgObject is used internally to represent VectoringCfgObject */
typedef VectoringCfgObject _VectoringCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_AppCfg.OmcidCfg.
 *
 * MDMOID_OMCID_CFG 2000
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    loggingLevel;	/**< ReadWrite */
    char *    loggingDestination;	/**< ReadWrite */
} OmcidCfgObject;

/*! \brief _OmcidCfgObject is used internally to represent OmcidCfgObject */
typedef OmcidCfgObject _OmcidCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_AppCfg.OsgidCfg.
 *
 * MDMOID_OSGID_CFG 3880
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    loggingLevel;	/**< ReadWrite */
    char *    loggingDestination;	/**< ReadOnly */
} OsgidCfgObject;

/*! \brief _OsgidCfgObject is used internally to represent OsgidCfgObject */
typedef OsgidCfgObject _OsgidCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_AppCfg.BbcdCfg.
 *
 * MDMOID_BBCD_CFG 3881
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    loggingLevel;	/**< ReadWrite */
    char *    loggingDestination;	/**< ReadOnly */
} BbcdCfgObject;

/*! \brief _BbcdCfgObject is used internally to represent BbcdCfgObject */
typedef BbcdCfgObject _BbcdCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_AppCfg.OpenwrtdCfg.
 *
 * MDMOID_OPENWRTD_CFG 3882
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    loggingLevel;	/**< ReadWrite */
    char *    loggingDestination;	/**< ReadOnly */
} OpenwrtdCfgObject;

/*! \brief _OpenwrtdCfgObject is used internally to represent OpenwrtdCfgObject */
typedef OpenwrtdCfgObject _OpenwrtdCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_AppCfg.DockermdCfg.
 *
 * MDMOID_DOCKERMD_CFG 3883
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    loggingLevel;	/**< ReadWrite */
    char *    loggingDestination;	/**< ReadOnly */
} DockermdCfgObject;

/*! \brief _DockermdCfgObject is used internally to represent DockermdCfgObject */
typedef DockermdCfgObject _DockermdCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_AppCfg.FirewalldCfg.
 *
 * MDMOID_FIREWALLD_CFG 3884
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    loggingLevel;	/**< ReadWrite */
    char *    loggingDestination;	/**< ReadOnly */
} FirewalldCfgObject;

/*! \brief _FirewalldCfgObject is used internally to represent FirewalldCfgObject */
typedef FirewalldCfgObject _FirewalldCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_AppCfg.XmppcCfg.
 *
 * MDMOID_XMPPC_CFG 3300
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    loggingLevel;	/**< ReadWrite */
    char *    loggingDestination;	/**< ReadWrite */
} XmppcCfgObject;

/*! \brief _XmppcCfgObject is used internally to represent XmppcCfgObject */
typedef XmppcCfgObject _XmppcCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_AppCfg.SnmpdCfg.
 *
 * MDMOID_SNMPD_CFG 3180
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    networkAccess;	/**< ReadWrite */
    char *    loggingLevel;	/**< ReadWrite */
    char *    loggingDestination;	/**< ReadWrite */
} SnmpdCfgObject;

/*! \brief _SnmpdCfgObject is used internally to represent SnmpdCfgObject */
typedef SnmpdCfgObject _SnmpdCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_AppCfg.DectdCfg.
 *
 * MDMOID_DECTD_CFG 3340
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    loggingLevel;	/**< ReadWrite */
    char *    loggingDestination;	/**< ReadWrite */
} DectdCfgObject;

/*! \brief _DectdCfgObject is used internally to represent DectdCfgObject */
typedef DectdCfgObject _DectdCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_AppCfg.EponappCfg.
 *
 * MDMOID_EPONAPP_CFG 2500
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    loggingLevel;	/**< ReadWrite */
    char *    loggingDestination;	/**< ReadWrite */
} EponappCfgObject;

/*! \brief _EponappCfgObject is used internally to represent EponappCfgObject */
typedef EponappCfgObject _EponappCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_EthernetSwitch.
 *
 * MDMOID_ETHERNET_SWITCH 3220
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    numberOfVirtualPorts;	/**< ReadOnly */
    UBOOL8    enableVirtualPorts;	/**< ReadWrite */
    char *    ifName;	/**< ReadOnly */
} EthernetSwitchObject;

/*! \brief _EthernetSwitchObject is used internally to represent EthernetSwitchObject */
typedef EthernetSwitchObject _EthernetSwitchObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_PwrMngtCfg.
 *
 * MDMOID_PWR_MNGT 3230
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    CPUSpeed;	/**< ReadWrite */
    UBOOL8    CPUr4kWaitEn;	/**< ReadWrite */
    UBOOL8    DRAMSelfRefreshEn;	/**< ReadWrite */
    UBOOL8    DRAMAutoPDEn;	/**< ReadWrite */
    UBOOL8    ethAutoPwrDwnEn;	/**< ReadWrite */
    UBOOL8    ethEEE;	/**< ReadWrite */
    SINT32    ethRegisteredCount;	/**< ReadOnly */
    SINT32    ethIfConnectedCount;	/**< ReadOnly */
    SINT32    USBIfRegisteredCount;	/**< ReadOnly */
    SINT32    USBIfConnectedCount;	/**< ReadOnly */
    UBOOL8    avsEn;	/**< ReadWrite */
    UBOOL8    VCTEn;	/**< ReadWrite */
    UBOOL8    wifiEn;	/**< ReadWrite */
    UBOOL8    ledEn;	/**< ReadWrite */
    UBOOL8    USBHostEn;	/**< ReadWrite */
    UBOOL8    USBDevEn;	/**< ReadWrite */
    UBOOL8    DSLEn;	/**< ReadWrite */
    UBOOL8    moCAEn;	/**< ReadWrite */
    UBOOL8    GPONEn;	/**< ReadWrite */
    UBOOL8    bcm6358MAC0En;	/**< ReadWrite */
    UBOOL8    bcm6358MAC1En;	/**< ReadWrite */
    UBOOL8    bcm6358EPHYEn;	/**< ReadWrite */
    UBOOL8    bcm5325ePHY0En;	/**< ReadWrite */
    UBOOL8    bcm5325ePHY1En;	/**< ReadWrite */
    UBOOL8    bcm5325ePHY2En;	/**< ReadWrite */
    UBOOL8    bcm5325ePHY3En;	/**< ReadWrite */
    UBOOL8    bcm5325ePHY45En;	/**< ReadWrite */
    UBOOL8    bcm6368ePHY0En;	/**< ReadWrite */
    UBOOL8    bcm6368ePHY1En;	/**< ReadWrite */
    UBOOL8    bcm6368ePHY2En;	/**< ReadWrite */
    UBOOL8    bcm6368ePHY3En;	/**< ReadWrite */
    UBOOL8    bcm6816ePHY0En;	/**< ReadWrite */
    UBOOL8    bcm6816ePHY1En;	/**< ReadWrite */
    UBOOL8    bcm6816ePHY2En;	/**< ReadWrite */
    UBOOL8    bcm6816ePHY3En;	/**< ReadWrite */
} PwrMngtObject;

/*! \brief _PwrMngtObject is used internally to represent PwrMngtObject */
typedef PwrMngtObject _PwrMngtObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_BMU.
 *
 * MDMOID_BATTERY_MANAGEMENT 3232
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
} BatteryManagementObject;

/*! \brief _BatteryManagementObject is used internally to represent BatteryManagementObject */
typedef BatteryManagementObject _BatteryManagementObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_BMU.Config.
 *
 * MDMOID_BATTERY_MANAGEMENT_CONFIGURATION 3233
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    SINT32    pollIntervalSeconds;	/**< ReadWrite */
    SINT32    maxChargePercent;	/**< ReadWrite */
    SINT32    upsConfigLowBattTime;	/**< ReadWrite */
    SINT32    replacementThresholdPercent;	/**< ReadWrite */
    SINT32    lowChargePercent;	/**< ReadWrite */
    UBOOL8    lifeTestingEnabled;	/**< ReadWrite */
    UINT32    lifeTestPeriod;	/**< ReadWrite */
    char *    lifeTestTOD;	/**< ReadWrite */
    SINT32    packVoltageSmoothingSteps;	/**< ReadWrite */
    UINT32    boardVoltageSmoothingSteps;	/**< ReadWrite */
    UINT32    packTemperatureSmoothingSteps;	/**< ReadWrite */
    UINT32    boardTemperatureSmoothingSteps;	/**< ReadWrite */
    UINT32    allowedFaults;	/**< ReadWrite */
} BatteryManagementConfigurationObject;

/*! \brief _BatteryManagementConfigurationObject is used internally to represent BatteryManagementConfigurationObject */
typedef BatteryManagementConfigurationObject _BatteryManagementConfigurationObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_BMU.Status.
 *
 * MDMOID_BATTERY_MANAGEMENT_STATUS 3234
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    version;	/**< ReadOnly */
    DATETIME  buildDateTime;	/**< ReadOnly */
    UBOOL8    operatingOnBattery;	/**< ReadOnly */
    char *    state;	/**< ReadOnly */
    UINT32    numberOfPresentBatteries;	/**< ReadOnly */
    UINT32    inputVoltage;	/**< ReadOnly */
    SINT32    temperature;	/**< ReadOnly */
    UINT32    estimatedMinutesRemaining;	/**< ReadOnly */
    SINT32    batteryCurrent;	/**< ReadOnly */
    UINT32    upsSecondsOnBattery;	/**< ReadOnly */
} BatteryManagementStatusObject;

/*! \brief _BatteryManagementStatusObject is used internally to represent BatteryManagementStatusObject */
typedef BatteryManagementStatusObject _BatteryManagementStatusObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_BMU.BatteryStatus.{i}.
 *
 * MDMOID_BATTERY_MANAGEMENT_BATTERY_STATUS 3235
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    index;	/**< ReadOnly */
    UBOOL8    batteryPresent;	/**< ReadOnly */
    UBOOL8    batteryValid;	/**< ReadOnly */
    UBOOL8    batteryBad;	/**< ReadOnly */
    UBOOL8    batterySelected;	/**< ReadOnly */
    UBOOL8    batteryFullyCharged;	/**< ReadOnly */
    UBOOL8    batteryChargeLow;	/**< ReadOnly */
    UBOOL8    batteryChargeLowPercent;	/**< ReadOnly */
    UBOOL8    batteryChargeDepleted;	/**< ReadOnly */
    UBOOL8    batteryChargeStateUnknown;	/**< ReadOnly */
    UINT32    batteryChargeCapacity;	/**< ReadOnly */
    UINT32    batteryActualCapacity;	/**< ReadOnly */
    UINT32    batteryFullChargeVoltage;	/**< ReadOnly */
    UINT32    batteryDepletedVoltage;	/**< ReadOnly */
    UINT32    batteryMeasuredVoltage;	/**< ReadOnly */
    UINT32    batteryPercentCharge;	/**< ReadOnly */
    UINT32    batteryEstimatedMinutesRemaining;	/**< ReadOnly */
    SINT32    batteryTemperature;	/**< ReadOnly */
    UINT32    batteryLifeTestCount;	/**< ReadOnly */
    DATETIME  batteryLastLifeTest;	/**< ReadOnly */
    DATETIME  batteryNextLifeTest;	/**< ReadOnly */
    char *    batteryLifeTestState;	/**< ReadOnly */
    UINT32    batteryStateofHealth;	/**< ReadOnly */
} BatteryManagementBatteryStatusObject;

/*! \brief _BatteryManagementBatteryStatusObject is used internally to represent BatteryManagementBatteryStatusObject */
typedef BatteryManagementBatteryStatusObject _BatteryManagementBatteryStatusObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_BMU.BatteryNonVol.{i}.
 *
 * MDMOID_BATTERY_MANAGEMENT_BATTERY_NON_VOL 3236
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    index;	/**< ReadWrite */
    UINT32    flags;	/**< ReadWrite */
    UINT32    estLifeRemaining;	/**< ReadWrite */
    UINT32    designCapacity;	/**< ReadWrite */
    UINT32    maxMicroWh;	/**< ReadWrite */
    UINT64    guid;	/**< ReadWrite */
    UINT32    lifeTestCount;	/**< ReadWrite */
    UINT64    lastLifeTestStarted;	/**< ReadWrite */
    UINT64    nextLifeTestUpdate;	/**< ReadWrite */
    UINT32    totalSeconds;	/**< ReadWrite */
    UINT32    seriesResistance;	/**< ReadWrite */
    HEXBINARY  dchgVoltages;	/**< ReadWrite */
} BatteryManagementBatteryNonVolObject;

/*! \brief _BatteryManagementBatteryNonVolObject is used internally to represent BatteryManagementBatteryNonVolObject */
typedef BatteryManagementBatteryNonVolObject _BatteryManagementBatteryNonVolObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_TM.
 *
 * MDMOID_BCM_TRAFFIC_MANAGEMENT 3380
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    owner;	/**< ReadWrite */
    UINT32    qidPrioMap;	/**< ReadWrite */
} BCMTrafficManagementObject;

/*! \brief _BCMTrafficManagementObject is used internally to represent BCMTrafficManagementObject */
typedef BCMTrafficManagementObject _BCMTrafficManagementObject;



/*! \brief Obj struct for InternetGatewayDevice.DeviceConfig.
 *
 * MDMOID_DEVICE_CONFIG 4
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    persistentData;	/**< ReadWrite */
    char *    configFile;	/**< ReadWrite */
} DeviceConfigObject;

/*! \brief _DeviceConfigObject is used internally to represent DeviceConfigObject */
typedef DeviceConfigObject _DeviceConfigObject;



/*! \brief Obj struct for InternetGatewayDevice.ManagementServer.
 *
 * MDMOID_MANAGEMENT_SERVER 5
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    URL;	/**< ReadWrite */
    char *    lastConnectedURL;	/**< ReadWrite */
    char *    username;	/**< ReadWrite */
    char *    password;	/**< ReadWrite */
    UBOOL8    periodicInformEnable;	/**< ReadWrite */
    UINT32    periodicInformInterval;	/**< ReadWrite */
    DATETIME  periodicInformTime;	/**< ReadWrite */
    char *    parameterKey;	/**< ReadOnly */
    char *    X_BROADCOM_COM_BoundIfName;	/**< ReadWrite */
    char *    connectionRequestURL;	/**< ReadOnly */
    char *    connectionRequestUsername;	/**< ReadWrite */
    char *    connectionRequestPassword;	/**< ReadWrite */
    UBOOL8    upgradesManaged;	/**< ReadWrite */
    char *    kickURL;	/**< ReadOnly */
    UINT32    CWMPRetryMinimumWaitInterval;	/**< ReadWrite */
    UINT32    CWMPRetryIntervalMultiplier;	/**< ReadWrite */
#ifdef DMP_DEVICEASSOCIATION_1
    UINT32    manageableDeviceNumberOfEntries;	/**< ReadOnly */
#endif
    UINT32    manageableDeviceNotificationLimit;	/**< ReadWrite */
#ifdef DMP_UDPCONNREQ_1
    char *    UDPConnectionRequestAddress;	/**< ReadOnly */
#endif
#ifdef DMP_UDPCONNREQ_1
    UINT32    UDPConnectionRequestAddressNotificationLimit;	/**< ReadWrite */
#endif
#ifdef DMP_UDPCONNREQ_1
    UBOOL8    STUNEnable;	/**< ReadWrite */
#endif
#ifdef DMP_UDPCONNREQ_1
    char *    STUNServerAddress;	/**< ReadWrite */
#endif
#ifdef DMP_UDPCONNREQ_1
    UINT32    STUNServerPort;	/**< ReadWrite */
#endif
#ifdef DMP_UDPCONNREQ_1
    char *    STUNUsername;	/**< ReadWrite */
#endif
#ifdef DMP_UDPCONNREQ_1
    char *    STUNPassword;	/**< ReadWrite */
#endif
#ifdef DMP_UDPCONNREQ_1
    SINT32    STUNMaximumKeepAlivePeriod;	/**< ReadWrite */
#endif
#ifdef DMP_UDPCONNREQ_1
    UINT32    STUNMinimumKeepAlivePeriod;	/**< ReadWrite */
#endif
#ifdef DMP_UDPCONNREQ_1
    UBOOL8    NATDetected;	/**< ReadOnly */
#endif
#ifdef DMP_DEVICE2_XMPPCONNREQ_1
    char *    supportedConnReqMethods;	/**< ReadOnly */
#endif
#ifdef DMP_DEVICE2_XMPPCONNREQ_1
    char *    connReqXMPPConnection;	/**< ReadWrite */
#endif
#ifdef DMP_DEVICE2_XMPPCONNREQ_1
    char *    connReqAllowedJabberIDs;	/**< ReadWrite */
#endif
#ifdef DMP_DEVICE2_XMPPCONNREQ_1
    char *    connReqJabberID;	/**< ReadWrite */
#endif
} ManagementServerObject;

/*! \brief _ManagementServerObject is used internally to represent ManagementServerObject */
typedef ManagementServerObject _ManagementServerObject;



/*! \brief Obj struct for InternetGatewayDevice.ManagementServer.ManageableDevice.{i}.
 *
 * MDMOID_MANAGEABLE_DEVICE 6
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    manufacturerOUI;	/**< ReadOnly */
    char *    serialNumber;	/**< ReadOnly */
    char *    productClass;	/**< ReadOnly */
} ManageableDeviceObject;

/*! \brief _ManageableDeviceObject is used internally to represent ManageableDeviceObject */
typedef ManageableDeviceObject _ManageableDeviceObject;



/*! \brief Obj struct for InternetGatewayDevice.ManagementServer.AutonomousTransferCompletePolicy.
 *
 * MDMOID_AUTON_XFER_COMPLETE_POLICY 7
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    transferTypeFilter;	/**< ReadWrite */
    char *    resultTypeFilter;	/**< ReadWrite */
    char *    fileTypeFilter;	/**< ReadWrite */
} AutonXferCompletePolicyObject;

/*! \brief _AutonXferCompletePolicyObject is used internally to represent AutonXferCompletePolicyObject */
typedef AutonXferCompletePolicyObject _AutonXferCompletePolicyObject;



/*! \brief Obj struct for InternetGatewayDevice.ManagementServer.DUStateChangeComplPolicy.
 *
 * MDMOID_DU_STATE_CHANGE_COMPL_POLICY 8
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    operationTypeFilter;	/**< ReadWrite */
    char *    resultTypeFilter;	/**< ReadWrite */
    char *    faultCodeFilter;	/**< ReadWrite */
} DUStateChangeComplPolicyObject;

/*! \brief _DUStateChangeComplPolicyObject is used internally to represent DUStateChangeComplPolicyObject */
typedef DUStateChangeComplPolicyObject _DUStateChangeComplPolicyObject;



/*! \brief Obj struct for InternetGatewayDevice.Time.
 *
 * MDMOID_TIME_SERVER_CFG 9
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    status;	/**< ReadOnly */
    char *    NTPServer1;	/**< ReadWrite */
    char *    NTPServer2;	/**< ReadWrite */
    char *    NTPServer3;	/**< ReadWrite */
    char *    NTPServer4;	/**< ReadWrite */
    char *    NTPServer5;	/**< ReadWrite */
    DATETIME  currentLocalTime;	/**< ReadOnly */
    char *    localTimeZone;	/**< ReadWrite */
    char *    localTimeZoneName;	/**< ReadWrite */
    UBOOL8    daylightSavingsUsed;	/**< ReadWrite */
    DATETIME  daylightSavingsStart;	/**< ReadWrite */
    DATETIME  daylightSavingsEnd;	/**< ReadWrite */
} TimeServerCfgObject;

/*! \brief _TimeServerCfgObject is used internally to represent TimeServerCfgObject */
typedef TimeServerCfgObject _TimeServerCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.Layer2Bridging.
 *
 * MDMOID_L2_BRIDGING 11
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    maxBridgeEntries;	/**< ReadOnly */
    UINT32    maxFilterEntries;	/**< ReadOnly */
    UINT32    maxMarkingEntries;	/**< ReadOnly */
    UINT32    bridgeNumberOfEntries;	/**< ReadOnly */
    UINT32    filterNumberOfEntries;	/**< ReadOnly */
    UINT32    markingNumberOfEntries;	/**< ReadOnly */
    UINT32    availableInterfaceNumberOfEntries;	/**< ReadOnly */
} L2BridgingObject;

/*! \brief _L2BridgingObject is used internally to represent L2BridgingObject */
typedef L2BridgingObject _L2BridgingObject;



/*! \brief Obj struct for InternetGatewayDevice.Layer2Bridging.Bridge.{i}.
 *
 * MDMOID_L2_BRIDGING_ENTRY 12
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    bridgeKey;	/**< ReadOnly */
    UBOOL8    bridgeEnable;	/**< ReadWrite */
    char *    bridgeStatus;	/**< ReadOnly */
    char *    bridgeName;	/**< ReadWrite */
    UINT32    VLANID;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_Mode;	/**< ReadWrite */
} L2BridgingEntryObject;

/*! \brief _L2BridgingEntryObject is used internally to represent L2BridgingEntryObject */
typedef L2BridgingEntryObject _L2BridgingEntryObject;



/*! \brief Obj struct for InternetGatewayDevice.Layer2Bridging.Filter.{i}.
 *
 * MDMOID_L2_BRIDGING_FILTER 13
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    filterKey;	/**< ReadOnly */
    UBOOL8    filterEnable;	/**< ReadWrite */
    char *    filterStatus;	/**< ReadOnly */
    SINT32    filterBridgeReference;	/**< ReadWrite */
    char *    filterInterface;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_VLANIDFilter;	/**< ReadWrite */
    char *    sourceMACFromVendorClassIDFilter;	/**< ReadWrite */
    UBOOL8    sourceMACFromVendorClassIDFilterExclude;	/**< ReadWrite */
} L2BridgingFilterObject;

/*! \brief _L2BridgingFilterObject is used internally to represent L2BridgingFilterObject */
typedef L2BridgingFilterObject _L2BridgingFilterObject;



/*! \brief Obj struct for InternetGatewayDevice.Layer2Bridging.AvailableInterface.{i}.
 *
 * MDMOID_L2_BRIDGING_INTF 15
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    availableInterfaceKey;	/**< ReadOnly */
    char *    interfaceType;	/**< ReadOnly */
    char *    interfaceReference;	/**< ReadOnly */
} L2BridgingIntfObject;

/*! \brief _L2BridgingIntfObject is used internally to represent L2BridgingIntfObject */
typedef L2BridgingIntfObject _L2BridgingIntfObject;



/*! \brief Obj struct for InternetGatewayDevice.QueueManagement.
 *
 * MDMOID_Q_MGMT 16
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    UBOOL8    X_BROADCOM_COM_EnableStateChanged;	/**< ReadWrite */
    UINT32    maxQueues;	/**< ReadOnly */
    UINT32    maxClassificationEntries;	/**< ReadOnly */
    UINT32    classificationNumberOfEntries;	/**< ReadOnly */
    UINT32    maxAppEntries;	/**< ReadOnly */
    UINT32    appNumberOfEntries;	/**< ReadOnly */
    UINT32    maxFlowEntries;	/**< ReadOnly */
    UINT32    flowNumberOfEntries;	/**< ReadOnly */
    UINT32    maxPolicerEntries;	/**< ReadOnly */
    UINT32    policerNumberOfEntries;	/**< ReadOnly */
    UINT32    maxQueueEntries;	/**< ReadOnly */
    UINT32    queueNumberOfEntries;	/**< ReadOnly */
    UINT32    defaultForwardingPolicy;	/**< ReadWrite */
    SINT32    defaultPolicer;	/**< ReadWrite */
    UINT32    defaultQueue;	/**< ReadWrite */
    SINT32    defaultDSCPMark;	/**< ReadWrite */
    SINT32    defaultEthernetPriorityMark;	/**< ReadWrite */
    char *    availableAppList;	/**< ReadOnly */
} QMgmtObject;

/*! \brief _QMgmtObject is used internally to represent QMgmtObject */
typedef QMgmtObject _QMgmtObject;



/*! \brief Obj struct for InternetGatewayDevice.QueueManagement.Classification.{i}.
 *
 * MDMOID_Q_MGMT_CLASSIFICATION 17
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    classificationKey;	/**< ReadOnly */
    UBOOL8    classificationEnable;	/**< ReadWrite */
    char *    classificationStatus;	/**< ReadOnly */
    UINT32    classificationOrder;	/**< ReadWrite */
    char *    classInterface;	/**< ReadWrite */
    IPADDRESS  destIP;	/**< ReadWrite */
    IPADDRESS  destMask;	/**< ReadWrite */
    UBOOL8    destIPExclude;	/**< ReadWrite */
    IPADDRESS  sourceIP;	/**< ReadWrite */
    IPADDRESS  sourceMask;	/**< ReadWrite */
    UBOOL8    sourceIPExclude;	/**< ReadWrite */
    SINT32    protocol;	/**< ReadWrite */
    UBOOL8    protocolExclude;	/**< ReadWrite */
    SINT32    destPort;	/**< ReadWrite */
    SINT32    destPortRangeMax;	/**< ReadWrite */
    UBOOL8    destPortExclude;	/**< ReadWrite */
    SINT32    sourcePort;	/**< ReadWrite */
    SINT32    sourcePortRangeMax;	/**< ReadWrite */
    UBOOL8    sourcePortExclude;	/**< ReadWrite */
    MACADDRESS  sourceMACAddress;	/**< ReadWrite */
    MACADDRESS  sourceMACMask;	/**< ReadWrite */
    UBOOL8    sourceMACExclude;	/**< ReadWrite */
    MACADDRESS  destMACAddress;	/**< ReadWrite */
    MACADDRESS  destMACMask;	/**< ReadWrite */
    UBOOL8    destMACExclude;	/**< ReadWrite */
    SINT32    ethertype;	/**< ReadWrite */
    UBOOL8    ethertypeExclude;	/**< ReadWrite */
    char *    sourceVendorClassID;	/**< ReadWrite */
    UBOOL8    sourceVendorClassIDExclude;	/**< ReadWrite */
    char *    sourceUserClassID;	/**< ReadWrite */
    UBOOL8    sourceUserClassIDExclude;	/**< ReadWrite */
    SINT32    DSCPCheck;	/**< ReadWrite */
    UBOOL8    DSCPExclude;	/**< ReadWrite */
    SINT32    DSCPMark;	/**< ReadWrite */
    SINT32    ethernetPriorityCheck;	/**< ReadWrite */
    UBOOL8    ethernetPriorityExclude;	/**< ReadWrite */
    SINT32    ethernetPriorityMark;	/**< ReadWrite */
    SINT32    VLANIDCheck;	/**< ReadWrite */
    UBOOL8    VLANIDExclude;	/**< ReadWrite */
    UINT32    forwardingPolicy;	/**< ReadWrite */
    SINT32    classPolicer;	/**< ReadWrite */
    SINT32    classQueue;	/**< ReadWrite */
    SINT32    classApp;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_Icmpv6Type;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_Icmpv6Code;	/**< ReadWrite */
    UBOOL8    X_BROADCOM_COM_Icmpv6TypeCodeExclude;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_ClassRate;	/**< ReadWrite */
    char *    X_BROADCOM_COM_ClassName;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_VLANIDTag;	/**< ReadWrite */
    char *    X_BROADCOM_COM_egressInterface;	/**< ReadWrite */
    UINT32    X_BROADCOM_COM_ClassKey;	/**< ReadWrite */
} QMgmtClassificationObject;

/*! \brief _QMgmtClassificationObject is used internally to represent QMgmtClassificationObject */
typedef QMgmtClassificationObject _QMgmtClassificationObject;



/*! \brief Obj struct for InternetGatewayDevice.QueueManagement.Policer.{i}.
 *
 * MDMOID_Q_MGMT_POLICER 20
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    policerKey;	/**< ReadOnly */
    UBOOL8    policerEnable;	/**< ReadWrite */
    char *    policerStatus;	/**< ReadOnly */
    UINT32    committedRate;	/**< ReadWrite */
    UINT32    committedBurstSize;	/**< ReadWrite */
    UINT32    excessBurstSize;	/**< ReadWrite */
    UINT32    peakRate;	/**< ReadWrite */
    UINT32    peakBurstSize;	/**< ReadWrite */
    char *    meterType;	/**< ReadWrite */
    char *    possibleMeterTypes;	/**< ReadOnly */
    char *    conformingAction;	/**< ReadWrite */
    char *    partialConformingAction;	/**< ReadWrite */
    char *    nonConformingAction;	/**< ReadWrite */
    UINT32    countedPackets;	/**< ReadOnly */
    UINT32    countedBytes;	/**< ReadOnly */
    char *    X_BROADCOM_COM_PolicerName;	/**< ReadWrite */
    UINT32    X_BROADCOM_COM_PolicerInfo;	/**< ReadWrite */
} QMgmtPolicerObject;

/*! \brief _QMgmtPolicerObject is used internally to represent QMgmtPolicerObject */
typedef QMgmtPolicerObject _QMgmtPolicerObject;



/*! \brief Obj struct for InternetGatewayDevice.QueueManagement.Queue.{i}.
 *
 * MDMOID_Q_MGMT_QUEUE 21
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    queueKey;	/**< ReadOnly */
    UBOOL8    queueEnable;	/**< ReadWrite */
    char *    queueStatus;	/**< ReadOnly */
    char *    queueInterface;	/**< ReadWrite */
    UINT32    queueWeight;	/**< ReadWrite */
    UINT32    queuePrecedence;	/**< ReadWrite */
    UINT32    REDThreshold;	/**< ReadWrite */
    char *    dropAlgorithm;	/**< ReadWrite */
    char *    schedulerAlgorithm;	/**< ReadWrite */
    SINT32    shapingRate;	/**< ReadWrite */
    UINT32    shapingBurstSize;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_MinBitRate;	/**< ReadWrite */
    char *    X_BROADCOM_COM_QueueName;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_DslLatency;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_PtmPriority;	/**< ReadWrite */
    UINT32    X_BROADCOM_COM_QueueId;	/**< ReadWrite */
    UINT32    X_BROADCOM_COM_LowClassMaxThreshold;	/**< ReadWrite */
    UINT32    X_BROADCOM_COM_HighClassMinThreshold;	/**< ReadWrite */
    UINT32    X_BROADCOM_COM_HighClassMaxThreshold;	/**< ReadWrite */
    UBOOL8    X_BROADCOM_COM_TcpPureAckQueue;	/**< ReadWrite */
} QMgmtQueueObject;

/*! \brief _QMgmtQueueObject is used internally to represent QMgmtQueueObject */
typedef QMgmtQueueObject _QMgmtQueueObject;



/*! \brief Obj struct for InternetGatewayDevice.QueueManagement.QueueStats.{i}.
 *
 * MDMOID_Q_MGMT_QUEUE_STATS 22
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    queueInterface;	/**< ReadWrite */
    UINT32    X_BROADCOM_COM_QueueId;	/**< ReadWrite */
    UINT32    outputPackets;	/**< ReadOnly */
    UINT32    outputBytes;	/**< ReadOnly */
    UINT32    droppedPackets;	/**< ReadOnly */
    UINT32    droppedBytes;	/**< ReadOnly */
} QMgmtQueueStatsObject;

/*! \brief _QMgmtQueueStatsObject is used internally to represent QMgmtQueueStatsObject */
typedef QMgmtQueueStatsObject _QMgmtQueueStatsObject;



/*! \brief Obj struct for InternetGatewayDevice.IPPingDiagnostics.
 *
 * MDMOID_IP_PING_DIAG 24
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    diagnosticsState;	/**< ReadWrite */
    char *    interface;	/**< ReadWrite */
    char *    host;	/**< ReadWrite */
    UINT32    numberOfRepetitions;	/**< ReadWrite */
    UINT32    timeout;	/**< ReadWrite */
    UINT32    dataBlockSize;	/**< ReadWrite */
    UINT32    DSCP;	/**< ReadWrite */
    UINT32    successCount;	/**< ReadOnly */
    UINT32    failureCount;	/**< ReadOnly */
    UINT32    averageResponseTime;	/**< ReadOnly */
    UINT32    minimumResponseTime;	/**< ReadOnly */
    UINT32    maximumResponseTime;	/**< ReadOnly */
} IPPingDiagObject;

/*! \brief _IPPingDiagObject is used internally to represent IPPingDiagObject */
typedef IPPingDiagObject _IPPingDiagObject;



/*! \brief Obj struct for InternetGatewayDevice.EponSoftwareImage.{i}.
 *
 * MDMOID_EPON_SOFTWARE_IMAGE 25
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    managedEntityId;	/**< ReadWrite */
    HEXBINARY  version;	/**< ReadWrite */
    UBOOL8    isCommitted;	/**< ReadWrite */
    UBOOL8    isActive;	/**< ReadWrite */
    UBOOL8    isValid;	/**< ReadWrite */
} EponSoftwareImageObject;

/*! \brief _EponSoftwareImageObject is used internally to represent EponSoftwareImageObject */
typedef EponSoftwareImageObject _EponSoftwareImageObject;



/*! \brief Obj struct for InternetGatewayDevice.EponSwUpgradeStatus.
 *
 * MDMOID_EPON_SW_UPGRADE_STATUS 26
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    ctcDownloadState;	/**< ReadWrite */
    UINT32    recentlyDownloadedPartition;	/**< ReadWrite */
    UBOOL8    download3715Needed;	/**< ReadWrite */
} EponSwUpgradeStatusObject;

/*! \brief _EponSwUpgradeStatusObject is used internally to represent EponSwUpgradeStatusObject */
typedef EponSwUpgradeStatusObject _EponSwUpgradeStatusObject;



/*! \brief Obj struct for InternetGatewayDevice.LANDevice.{i}.
 *
 * MDMOID_LAN_DEV 27
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    LANEthernetInterfaceNumberOfEntries;	/**< ReadOnly */
    UINT32    LANUSBInterfaceNumberOfEntries;	/**< ReadOnly */
    UINT32    LANWLANConfigurationNumberOfEntries;	/**< ReadOnly */
#ifdef DMP_X_BROADCOM_COM_BASELINE_1
    UINT32    X_BROADCOM_COM_LANMocaInterfaceNumberOfEntries;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_EPON_1
    UINT32    X_BROADCOM_COM_LANEponInterfaceNumberOfEntries;	/**< ReadOnly */
#endif
} LanDevObject;

/*! \brief _LanDevObject is used internally to represent LanDevObject */
typedef LanDevObject _LanDevObject;



/*! \brief Obj struct for InternetGatewayDevice.LANDevice.{i}.X_BROADCOM_COM_MldSnoopingConfig.
 *
 * MDMOID_MLD_SNOOPING_CFG 3281
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    status;	/**< ReadOnly */
    char *    mode;	/**< ReadWrite */
    SINT32    lanToLanEnable;	/**< ReadWrite */
} MldSnoopingCfgObject;

/*! \brief _MldSnoopingCfgObject is used internally to represent MldSnoopingCfgObject */
typedef MldSnoopingCfgObject _MldSnoopingCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.LANDevice.{i}.X_BROADCOM_COM_IgmpSnoopingConfig.
 *
 * MDMOID_IGMP_SNOOPING_CFG 3280
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    status;	/**< ReadOnly */
    char *    mode;	/**< ReadWrite */
    SINT32    lanToLanEnable;	/**< ReadWrite */
} IgmpSnoopingCfgObject;

/*! \brief _IgmpSnoopingCfgObject is used internally to represent IgmpSnoopingCfgObject */
typedef IgmpSnoopingCfgObject _IgmpSnoopingCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.LANDevice.{i}.LANHostConfigManagement.
 *
 * MDMOID_LAN_HOST_CFG 28
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    DHCPServerConfigurable;	/**< ReadWrite */
    UBOOL8    DHCPServerEnable;	/**< ReadWrite */
    UBOOL8    DHCPRelay;	/**< ReadOnly */
    char *    X_BROADCOM_COM_DhcpRelayServer;	/**< ReadWrite */
    IPADDRESS  minAddress;	/**< ReadWrite */
    IPADDRESS  maxAddress;	/**< ReadWrite */
    IPADDRESS  reservedAddresses;	/**< ReadWrite */
    IPADDRESS  subnetMask;	/**< ReadWrite */
    char *    DNSServers;	/**< ReadWrite */
    char *    domainName;	/**< ReadWrite */
    char *    IPRouters;	/**< ReadWrite */
    SINT32    DHCPLeaseTime;	/**< ReadWrite */
    UINT32    IPInterfaceNumberOfEntries;	/**< ReadOnly */
} LanHostCfgObject;

/*! \brief _LanHostCfgObject is used internally to represent LanHostCfgObject */
typedef LanHostCfgObject _LanHostCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.LANDevice.{i}.LANHostConfigManagement.IPInterface.{i}.
 *
 * MDMOID_LAN_IP_INTF 29
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    IPADDRESS  IPInterfaceIPAddress;	/**< ReadWrite */
    IPADDRESS  IPInterfaceSubnetMask;	/**< ReadWrite */
    char *    IPInterfaceAddressingType;	/**< ReadWrite */
    char *    X_BROADCOM_COM_IfName;	/**< ReadOnly */
#ifdef DMP_X_BROADCOM_COM_SECURITY_1
    UBOOL8    X_BROADCOM_COM_FirewallEnabled;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_BASELINE_1
    char *    X_BROADCOM_COM_DhcpConnectionStatus;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_BASELINE_1
    char *    X_BROADCOM_COM_DhcpDefaultGateway;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_BASELINE_1
    char *    X_BROADCOM_COM_DNSServers;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_BASELINE_1
    UINT32    X_BROADCOM_COM_DhcpcPid;	/**< ReadOnly */
#endif
} LanIpIntfObject;

/*! \brief _LanIpIntfObject is used internally to represent LanIpIntfObject */
typedef LanIpIntfObject _LanIpIntfObject;



/*! \brief Obj struct for InternetGatewayDevice.LANDevice.{i}.LANHostConfigManagement.IPInterface.{i}.X_BROADCOM_COM_IPv6LanIntfAddress.
 *
 * MDMOID_I_PV6_LAN_INTF_ADDR 30
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    uniqueLocalAddress;	/**< ReadWrite */
} IPv6LanIntfAddrObject;

/*! \brief _IPv6LanIntfAddrObject is used internally to represent IPv6LanIntfAddrObject */
typedef IPv6LanIntfAddrObject _IPv6LanIntfAddrObject;



/*! \brief Obj struct for InternetGatewayDevice.LANDevice.{i}.LANHostConfigManagement.IPInterface.{i}.X_BROADCOM_COM_IPv6LanIntfAddress.DelegatedAddress.{i}.
 *
 * MDMOID_DELEGATED_ADDRESS 31
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    mode;	/**< ReadOnly */
    char *    delegatedConnection;	/**< ReadOnly */
    char *    IPv6InterfaceAddress;	/**< ReadOnly */
} DelegatedAddressObject;

/*! \brief _DelegatedAddressObject is used internally to represent DelegatedAddressObject */
typedef DelegatedAddressObject _DelegatedAddressObject;



/*! \brief Obj struct for InternetGatewayDevice.LANDevice.{i}.LANHostConfigManagement.IPInterface.{i}.X_BROADCOM_COM_FirewallException.{i}.
 *
 * MDMOID_LAN_IP_INTF_FIREWALL_EXCEPTION 32
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    filterName;	/**< ReadWrite */
    char *    IPVersion;	/**< ReadWrite */
    char *    protocol;	/**< ReadWrite */
    UINT32    sourcePortStart;	/**< ReadWrite */
    UINT32    sourcePortEnd;	/**< ReadWrite */
    UINT32    destinationPortStart;	/**< ReadWrite */
    UINT32    destinationPortEnd;	/**< ReadWrite */
    char *    sourceIPAddress;	/**< ReadWrite */
    char *    sourceNetMask;	/**< ReadWrite */
    char *    destinationIPAddress;	/**< ReadWrite */
    char *    destinationNetMask;	/**< ReadWrite */
} LanIpIntfFirewallExceptionObject;

/*! \brief _LanIpIntfFirewallExceptionObject is used internally to represent LanIpIntfFirewallExceptionObject */
typedef LanIpIntfFirewallExceptionObject _LanIpIntfFirewallExceptionObject;



/*! \brief Obj struct for InternetGatewayDevice.LANDevice.{i}.LANHostConfigManagement.IPInterface.{i}.X_BROADCOM_COM_IpFilterCfg.{i}.
 *
 * MDMOID_IP_FILTER_CFG 33
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    filterName;	/**< ReadWrite */
    char *    IPVersion;	/**< ReadWrite */
    char *    protocol;	/**< ReadWrite */
    UINT32    sourcePortStart;	/**< ReadWrite */
    UINT32    sourcePortEnd;	/**< ReadWrite */
    UINT32    destinationPortStart;	/**< ReadWrite */
    UINT32    destinationPortEnd;	/**< ReadWrite */
    char *    sourceIPAddress;	/**< ReadWrite */
    char *    sourceNetMask;	/**< ReadWrite */
    char *    destinationIPAddress;	/**< ReadWrite */
    char *    destinationNetMask;	/**< ReadWrite */
} IpFilterCfgObject;

/*! \brief _IpFilterCfgObject is used internally to represent IpFilterCfgObject */
typedef IpFilterCfgObject _IpFilterCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.LANDevice.{i}.LANHostConfigManagement.DHCPConditionalServingPool.{i}.
 *
 * MDMOID_DHCP_CONDITIONAL_SERVING 34
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    chaddr;	/**< ReadWrite */
    char *    chaddrMask;	/**< ReadWrite */
    IPADDRESS  minAddress;	/**< ReadWrite */
    IPADDRESS  maxAddress;	/**< ReadWrite */
    char *    reservedAddresses;	/**< ReadWrite */
    IPADDRESS  subnetMask;	/**< ReadWrite */
    char *    DNSServers;	/**< ReadWrite */
    char *    domainName;	/**< ReadWrite */
    char *    IPRouters;	/**< ReadWrite */
    SINT32    DHCPLeaseTime;	/**< ReadWrite */
} DHCPConditionalServingObject;

/*! \brief _DHCPConditionalServingObject is used internally to represent DHCPConditionalServingObject */
typedef DHCPConditionalServingObject _DHCPConditionalServingObject;



/*! \brief Obj struct for InternetGatewayDevice.LANDevice.{i}.X_BROADCOM_COM_IPv6LANHostConfigManagement.
 *
 * MDMOID_I_PV6_LAN_HOST_CFG 36
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    DHCPv6ServerEnable;	/**< ReadWrite */
    UINT32    X_BROADCOM_COM_Dhcp6sPid;	/**< ReadOnly */
    UBOOL8    statefulDHCPv6Server;	/**< ReadWrite */
    char *    minInterfaceID;	/**< ReadWrite */
    char *    maxInterfaceID;	/**< ReadWrite */
    SINT32    DHCPv6LeaseTime;	/**< ReadWrite */
    char *    IPv6DomainName;	/**< ReadWrite */
    char *    IPv6DNSConfigType;	/**< ReadWrite */
    char *    IPv6DNSServers;	/**< ReadWrite */
    char *    IPv6DNSWANConnection;	/**< ReadWrite */
    UINT32    IPv6InterfaceNumberOfEntries;	/**< ReadOnly */
} IPv6LanHostCfgObject;

/*! \brief _IPv6LanHostCfgObject is used internally to represent IPv6LanHostCfgObject */
typedef IPv6LanHostCfgObject _IPv6LanHostCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.LANDevice.{i}.X_BROADCOM_COM_IPv6LANHostConfigManagement.RadvdConfigManagement.
 *
 * MDMOID_RADVD_CONFIG_MGT 37
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
} RadvdConfigMgtObject;

/*! \brief _RadvdConfigMgtObject is used internally to represent RadvdConfigMgtObject */
typedef RadvdConfigMgtObject _RadvdConfigMgtObject;



/*! \brief Obj struct for InternetGatewayDevice.LANDevice.{i}.X_BROADCOM_COM_IPv6LANHostConfigManagement.RadvdConfigManagement.ULAPrefixInfo.
 *
 * MDMOID_ULA_PREFIX_INFO 38
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    UBOOL8    random;	/**< ReadWrite */
    char *    prefix;	/**< ReadWrite */
    SINT32    preferredLifeTime;	/**< ReadWrite */
    SINT32    validLifeTime;	/**< ReadWrite */
} ULAPrefixInfoObject;

/*! \brief _ULAPrefixInfoObject is used internally to represent ULAPrefixInfoObject */
typedef ULAPrefixInfoObject _ULAPrefixInfoObject;



/*! \brief Obj struct for InternetGatewayDevice.LANDevice.{i}.X_BROADCOM_COM_IPv6LANHostConfigManagement.RadvdConfigManagement.RadvdOtherInfo.
 *
 * MDMOID_RADVD_OTHER_INFO 39
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    recursiveDns;	/**< ReadWrite */
    char *    dnssSearchList;	/**< ReadWrite */
} RadvdOtherInfoObject;

/*! \brief _RadvdOtherInfoObject is used internally to represent RadvdOtherInfoObject */
typedef RadvdOtherInfoObject _RadvdOtherInfoObject;



/*! \brief Obj struct for InternetGatewayDevice.LANDevice.{i}.X_BROADCOM_COM_IPv6LANHostConfigManagement.RadvdConfigManagement.PrefixInformation.{i}.
 *
 * MDMOID_PREFIX_INFO 40
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    mode;	/**< ReadOnly */
    char *    delegatedConnection;	/**< ReadOnly */
    char *    prefix;	/**< ReadOnly */
    SINT32    preferredLifeTime;	/**< ReadOnly */
    SINT32    validLifeTime;	/**< ReadOnly */
    char *    prefixOld;	/**< ReadOnly */
    SINT32    validLifeTimeOld;	/**< ReadOnly */
} PrefixInfoObject;

/*! \brief _PrefixInfoObject is used internally to represent PrefixInfoObject */
typedef PrefixInfoObject _PrefixInfoObject;



/*! \brief Obj struct for InternetGatewayDevice.LANDevice.{i}.LANEthernetInterfaceConfig.{i}.
 *
 * MDMOID_LAN_ETH_INTF 41
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    status;	/**< ReadOnly */
    MACADDRESS  MACAddress;	/**< ReadOnly */
    char *    maxBitRate;	/**< ReadWrite */
    char *    duplexMode;	/**< ReadWrite */
    char *    X_BROADCOM_COM_IfName;	/**< ReadOnly */
    SINT32    X_BROADCOM_COM_EthernetPriorityMark;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_dot1qPvid;	/**< ReadWrite */
    UINT32    X_BROADCOM_COM_VLAN_Enable;	/**< ReadWrite */
    char *    X_BROADCOM_COM_VLAN_TagList;	/**< ReadWrite */
    UBOOL8    X_BROADCOM_COM_GMAC_Enabled;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_ShapingRate;	/**< ReadWrite */
    UINT32    X_BROADCOM_COM_ShapingBurstSize;	/**< ReadWrite */
    char *    X_BROADCOM_COM_WanLan_Attribute;	/**< ReadWrite */
} LanEthIntfObject;

/*! \brief _LanEthIntfObject is used internally to represent LanEthIntfObject */
typedef LanEthIntfObject _LanEthIntfObject;



/*! \brief Obj struct for InternetGatewayDevice.LANDevice.{i}.LANEthernetInterfaceConfig.{i}.Stats.
 *
 * MDMOID_LAN_ETH_INTF_STATS 42
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    bytesSent;	/**< ReadOnly */
    UINT32    bytesReceived;	/**< ReadOnly */
    UINT32    packetsSent;	/**< ReadOnly */
    UINT32    packetsReceived;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_PacketsSent;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_PacketsReceived;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_TxErrors;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_RxErrors;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_TxDrops;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_RxDrops;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_MulticastPacketsSent;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_MulticastPacketsReceived;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_MulticastBytesSent;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_MulticastBytesReceived;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_UnicastPacketsSent;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_UnicastPacketsReceived;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_BroadcastPacketsSent;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_BroadcastPacketsReceived;	/**< ReadOnly */
} LanEthIntfStatsObject;

/*! \brief _LanEthIntfStatsObject is used internally to represent LanEthIntfStatsObject */
typedef LanEthIntfStatsObject _LanEthIntfStatsObject;



/*! \brief Obj struct for InternetGatewayDevice.LANDevice.{i}.LANUSBInterfaceConfig.{i}.
 *
 * MDMOID_LAN_USB_INTF 43
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    status;	/**< ReadOnly */
    char *    MACAddress;	/**< ReadOnly */
    char *    power;	/**< ReadOnly */
    char *    X_BROADCOM_COM_IfName;	/**< ReadOnly */
} LanUsbIntfObject;

/*! \brief _LanUsbIntfObject is used internally to represent LanUsbIntfObject */
typedef LanUsbIntfObject _LanUsbIntfObject;



/*! \brief Obj struct for InternetGatewayDevice.LANDevice.{i}.LANUSBInterfaceConfig.{i}.Stats.
 *
 * MDMOID_LAN_USB_INTF_STATS 44
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    bytesSent;	/**< ReadOnly */
    UINT32    bytesReceived;	/**< ReadOnly */
    UINT32    cellsSent;	/**< ReadOnly */
    UINT32    cellsReceived;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_PacketsSent;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_PacketsReceived;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_TxErrors;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_RxErrors;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_TxDrops;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_RxDrops;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_MulticastPacketsSent;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_MulticastPacketsReceived;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_MulticastBytesSent;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_MulticastBytesReceived;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_UnicastPacketsSent;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_UnicastPacketsReceived;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_BroadcastPacketsSent;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_BroadcastPacketsReceived;	/**< ReadOnly */
} LanUsbIntfStatsObject;

/*! \brief _LanUsbIntfStatsObject is used internally to represent LanUsbIntfStatsObject */
typedef LanUsbIntfStatsObject _LanUsbIntfStatsObject;



/*! \brief Obj struct for InternetGatewayDevice.LANDevice.{i}.WLANConfiguration.{i}.
 *
 * MDMOID_LAN_WLAN 45
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    status;	/**< ReadOnly */
    char *    BSSID;	/**< ReadOnly */
    char *    maxBitRate;	/**< ReadWrite */
    UINT32    channel;	/**< ReadWrite */
    char *    SSID;	/**< ReadWrite */
    char *    beaconType;	/**< ReadWrite */
    UBOOL8    MACAddressControlEnabled;	/**< ReadWrite */
    char *    standard;	/**< ReadOnly */
    UINT32    WEPKeyIndex;	/**< ReadWrite */
    char *    keyPassphrase;	/**< ReadWrite */
    char *    WEPEncryptionLevel;	/**< ReadOnly */
    char *    basicEncryptionModes;	/**< ReadWrite */
    char *    basicAuthenticationMode;	/**< ReadWrite */
    char *    WPAEncryptionModes;	/**< ReadWrite */
    char *    WPAAuthenticationMode;	/**< ReadWrite */
    char *    IEEE11iEncryptionModes;	/**< ReadWrite */
    char *    IEEE11iAuthenticationMode;	/**< ReadWrite */
    char *    possibleChannels;	/**< ReadOnly */
    char *    basicDataTransmitRates;	/**< ReadWrite */
    char *    operationalDataTransmitRates;	/**< ReadWrite */
    char *    possibleDataTransmitRates;	/**< ReadOnly */
    UBOOL8    insecureOOBAccessEnabled;	/**< ReadWrite */
    UBOOL8    beaconAdvertisementEnabled;	/**< ReadWrite */
#ifdef DMP_WIFILAN_2
    UBOOL8    SSIDAdvertisementEnabled;	/**< ReadWrite */
#endif
    UBOOL8    radioEnabled;	/**< ReadWrite */
    UBOOL8    autoRateFallBackEnabled;	/**< ReadWrite */
    char *    locationDescription;	/**< ReadWrite */
    char *    regulatoryDomain;	/**< ReadWrite */
    UINT32    totalPSKFailures;	/**< ReadOnly */
    UINT32    totalIntegrityFailures;	/**< ReadOnly */
    char *    channelsInUse;	/**< ReadOnly */
    char *    deviceOperationMode;	/**< ReadOnly */
    UINT32    distanceFromRoot;	/**< ReadWrite */
    char *    peerBSSID;	/**< ReadWrite */
    char *    authenticationServiceMode;	/**< ReadWrite */
    UINT32    totalBytesSent;	/**< ReadOnly */
    UINT32    totalBytesReceived;	/**< ReadOnly */
    UINT32    totalPacketsSent;	/**< ReadOnly */
    UINT32    totalPacketsReceived;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_RxErrors;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_RxDrops;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_TxErrors;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_TxDrops;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_MulticastPacketsSent;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_MulticastPacketsReceived;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_MulticastBytesSent;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_MulticastBytesReceived;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_UnicastPacketsSent;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_UnicastPacketsReceived;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_BroadcastPacketsSent;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_BroadcastPacketsReceived;	/**< ReadOnly */
    UINT32    totalAssociations;	/**< ReadOnly */
    char *    X_BROADCOM_COM_IfName;	/**< ReadOnly */
    UBOOL8    X_BROADCOM_COM_HideSSID;	/**< ReadWrite */
    UINT32    X_BROADCOM_COM_TxPowerPercent;	/**< ReadWrite */
    char *    X_BROADCOM_COM_GuestSSID;	/**< ReadWrite */
    char *    X_BROADCOM_COM_GuestBSSID;	/**< ReadOnly */
    UBOOL8    X_BROADCOM_COM_GuestEnable;	/**< ReadWrite */
    UBOOL8    X_BROADCOM_COM_GuestHiden;	/**< ReadWrite */
    UBOOL8    X_BROADCOM_COM_GuestIsolateClients;	/**< ReadWrite */
    UBOOL8    X_BROADCOM_COM_GuestDisableWMMAdvertise;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_GuestMaxClients;	/**< ReadWrite */
    char *    X_BROADCOM_COM_Guest1SSID;	/**< ReadWrite */
    char *    X_BROADCOM_COM_Guest1BSSID;	/**< ReadOnly */
    UBOOL8    X_BROADCOM_COM_Guest1Enable;	/**< ReadWrite */
    UBOOL8    X_BROADCOM_COM_Guest1Hiden;	/**< ReadWrite */
    UBOOL8    X_BROADCOM_COM_Guest1IsolateClients;	/**< ReadWrite */
    UBOOL8    X_BROADCOM_COM_Guest1DisableWMMAdvertise;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_Guest1MaxClients;	/**< ReadWrite */
    char *    X_BROADCOM_COM_Guest2SSID;	/**< ReadWrite */
    char *    X_BROADCOM_COM_Guest2BSSID;	/**< ReadOnly */
    UBOOL8    X_BROADCOM_COM_Guest2Enable;	/**< ReadWrite */
    UBOOL8    X_BROADCOM_COM_Guest2Hiden;	/**< ReadWrite */
    UBOOL8    X_BROADCOM_COM_Guest2IsolateClients;	/**< ReadWrite */
    UBOOL8    X_BROADCOM_COM_Guest2DisableWMMAdvertise;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_Guest2MaxClients;	/**< ReadWrite */
} LanWlanObject;

/*! \brief _LanWlanObject is used internally to represent LanWlanObject */
typedef LanWlanObject _LanWlanObject;



/*! \brief Obj struct for InternetGatewayDevice.LANDevice.{i}.WLANConfiguration.{i}.AssociatedDevice.{i}.
 *
 * MDMOID_LAN_WLAN_ASSOCIATED_DEVICE_ENTRY 46
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    MACADDRESS  associatedDeviceMACAddress;	/**< ReadOnly */
    char *    associatedDeviceIPAddress;	/**< ReadOnly */
    UBOOL8    associatedDeviceAuthenticationState;	/**< ReadOnly */
    char *    lastRequestedUnicastCipher;	/**< ReadOnly */
    char *    lastRequestedMulticastCipher;	/**< ReadOnly */
    char *    lastPMKId;	/**< ReadOnly */
    char *    lastDataTransmitRate;	/**< ReadOnly */
    SINT32    X_BROADCOM_COM_Associated;	/**< ReadOnly */
    SINT32    X_BROADCOM_COM_Authorized;	/**< ReadWrite */
    char *    X_BROADCOM_COM_Ssid;	/**< ReadWrite */
    char *    X_BROADCOM_COM_Ifcname;	/**< ReadWrite */
} LanWlanAssociatedDeviceEntryObject;

/*! \brief _LanWlanAssociatedDeviceEntryObject is used internally to represent LanWlanAssociatedDeviceEntryObject */
typedef LanWlanAssociatedDeviceEntryObject _LanWlanAssociatedDeviceEntryObject;



/*! \brief Obj struct for InternetGatewayDevice.LANDevice.{i}.WLANConfiguration.{i}.WEPKey.{i}.
 *
 * MDMOID_LAN_WLAN_WEP_KEY 47
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    WEPKey;	/**< ReadWrite */
} LanWlanWepKeyObject;

/*! \brief _LanWlanWepKeyObject is used internally to represent LanWlanWepKeyObject */
typedef LanWlanWepKeyObject _LanWlanWepKeyObject;



/*! \brief Obj struct for InternetGatewayDevice.LANDevice.{i}.WLANConfiguration.{i}.PreSharedKey.{i}.
 *
 * MDMOID_LAN_WLAN_PRE_SHARED_KEY 48
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    preSharedKey;	/**< ReadWrite */
    char *    keyPassphrase;	/**< ReadWrite */
    MACADDRESS  associatedDeviceMACAddress;	/**< ReadWrite */
} LanWlanPreSharedKeyObject;

/*! \brief _LanWlanPreSharedKeyObject is used internally to represent LanWlanPreSharedKeyObject */
typedef LanWlanPreSharedKeyObject _LanWlanPreSharedKeyObject;



/*! \brief Obj struct for InternetGatewayDevice.LANDevice.{i}.WLANConfiguration.{i}.X_BROADCOM_COM_WlanAdapter.
 *
 * MDMOID_WLAN_ADAPTER 50
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
} WlanAdapterObject;

/*! \brief _WlanAdapterObject is used internally to represent WlanAdapterObject */
typedef WlanAdapterObject _WlanAdapterObject;



/*! \brief Obj struct for InternetGatewayDevice.LANDevice.{i}.WLANConfiguration.{i}.X_BROADCOM_COM_WlanAdapter.WlBaseCfg.
 *
 * MDMOID_WL_BASE_CFG 51
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    SINT32    wlEnbl;	/**< ReadWrite */
    SINT32    wlSsidIdx;	/**< ReadWrite */
    char *    wlMode;	/**< ReadWrite */
    char *    wlCountry;	/**< ReadWrite */
    char *    wlPhyType;	/**< ReadWrite */
    SINT32    wlCoreRev;	/**< ReadWrite */
    char *    wlBasicRate;	/**< ReadWrite */
    char *    wlProtection;	/**< ReadWrite */
    char *    wlPreambleType;	/**< ReadWrite */
    char *    wlAfterBurnerEn;	/**< ReadWrite */
    char *    wlFrameBurst;	/**< ReadWrite */
    SINT32    wlChannel;	/**< ReadWrite */
    SINT32    wlCurrentChannel;	/**< ReadWrite */
    SINT32    wlFrgThrshld;	/**< ReadWrite */
    SINT32    wlRtsThrshld;	/**< ReadWrite */
    SINT32    wlDtmIntvl;	/**< ReadWrite */
    SINT32    wlBcnIntvl;	/**< ReadWrite */
    SINT32    wlRate;	/**< ReadWrite */
    SINT32    wlgMode;	/**< ReadWrite */
    SINT32    wlBand;	/**< ReadWrite */
    SINT32    wlMCastRate;	/**< ReadWrite */
    SINT32    wlInfra;	/**< ReadWrite */
    SINT32    wlAntDiv;	/**< ReadWrite */
    SINT32    wlWme;	/**< ReadWrite */
    SINT32    wlWmeNoAck;	/**< ReadWrite */
    SINT32    wlWmeApsd;	/**< ReadWrite */
    SINT32    wlTxPwrPcnt;	/**< ReadWrite */
    SINT32    wlRegMode;	/**< ReadWrite */
    SINT32    wlDfsPreIsm;	/**< ReadWrite */
    SINT32    wlDfsPostIsm;	/**< ReadWrite */
    SINT32    wlTpcDb;	/**< ReadWrite */
    SINT32    wlCsScanTimer;	/**< ReadWrite */
    SINT32    wlGlobalMaxAssoc;	/**< ReadWrite */
    SINT32    wlMBands;	/**< ReadWrite */
    char *    wlVer;	/**< ReadWrite */
    SINT32    wlNumBss;	/**< ReadWrite */
    SINT32    wlMaxMbss;	/**< ReadWrite */
    UBOOL8    wlMbssSupported;	/**< ReadWrite */
    SINT32    wlLazyWds;	/**< ReadWrite */
    SINT32    wlAburnSupported;	/**< ReadWrite */
    SINT32    wlAmpduSupported;	/**< ReadWrite */
    SINT32    wlAmsduSupported;	/**< ReadWrite */
    SINT32    wlWmeSupported;	/**< ReadWrite */
    SINT32    wlWmfSupported;	/**< ReadWrite */
    SINT32    wlVecSupported;	/**< ReadWrite */
    SINT32    wlVec;	/**< ReadWrite */
    SINT32    wlIperf;	/**< ReadWrite */
    SINT32    wlRifsAdvert;	/**< ReadWrite */
    SINT32    wlChanImEnab;	/**< ReadWrite */
    SINT32    wlObssCoex;	/**< ReadWrite */
    SINT32    wlRxChainPwrSaveEnable;	/**< ReadWrite */
    SINT32    wlRxChainPwrSaveQuietTime;	/**< ReadWrite */
    SINT32    wlRxChainPwrSavePps;	/**< ReadWrite */
    SINT32    wlRadioPwrSaveEnable;	/**< ReadWrite */
    SINT32    wlRadioPwrSaveQuietTime;	/**< ReadWrite */
    SINT32    wlRadioPwrSavePps;	/**< ReadWrite */
    SINT32    wlRadioPwrSaveLevel;	/**< ReadWrite */
    SINT32    wlTXBFCapable;	/**< ReadWrite */
    SINT32    wlEnableBFR;	/**< ReadWrite */
    SINT32    wlEnableBFE;	/**< ReadWrite */
    SINT32    bsdRole;	/**< ReadWrite */
    SINT32    bsdHport;	/**< ReadWrite */
    SINT32    bsdPport;	/**< ReadWrite */
    char *    bsdHelper;	/**< ReadWrite */
    char *    bsdPrimary;	/**< ReadWrite */
    SINT32    ssdEnable;	/**< ReadWrite */
    SINT32    wlTafEnable;	/**< ReadWrite */
    SINT32    wlAtf;	/**< ReadWrite */
    SINT32    wlPspretendThreshold;	/**< ReadWrite */
    SINT32    wlPspretendRetryLimit;	/**< ReadWrite */
    SINT32    wlAcsFcsMode;	/**< ReadWrite */
    SINT32    wlAcsDfs;	/**< ReadWrite */
    SINT32    wlAcsCsScanTimer;	/**< ReadWrite */
    SINT32    wlAcsCiScanTimer;	/**< ReadWrite */
    SINT32    wlAcsCiScanTimeout;	/**< ReadWrite */
    SINT32    wlAcsScanEntryExpire;	/**< ReadWrite */
    SINT32    wlAcsTxIdleCnt;	/**< ReadWrite */
    SINT32    wlAcsChanDwellTime;	/**< ReadWrite */
    SINT32    wlAcsChanFlopPeriod;	/**< ReadWrite */
    SINT32    wlIntferPeriod;	/**< ReadWrite */
    SINT32    wlIntferCnt;	/**< ReadWrite */
    SINT32    wlIntferTxfail;	/**< ReadWrite */
    SINT32    wlIntferTcptxfail;	/**< ReadWrite */
    char *    wlAcsDfsrImmediate;	/**< ReadWrite */
    char *    wlAcsDfsrDeferred;	/**< ReadWrite */
    char *    wlAcsDfsrActivity;	/**< ReadWrite */
    UBOOL8    wlTxPriority;	/**< ReadWrite */
    UBOOL8    wlRxPriority;	/**< ReadWrite */
    UBOOL8    wlCalPriority;	/**< ReadWrite */
    SINT32    wlWdsSec;	/**< ReadWrite */
    char *    wlWdsKey;	/**< ReadWrite */
    SINT32    wlWdsSecEnable;	/**< ReadWrite */
    SINT32    wlEnableUre;	/**< ReadWrite */
    SINT32    wlStaRetryTime;	/**< ReadWrite */
} WlBaseCfgObject;

/*! \brief _WlBaseCfgObject is used internally to represent WlBaseCfgObject */
typedef WlBaseCfgObject _WlBaseCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.LANDevice.{i}.WLANConfiguration.{i}.X_BROADCOM_COM_WlanAdapter.WlStaticWdsCfg.{i}.
 *
 * MDMOID_WL_STATIC_WDS_CFG 52
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    wlMacAddr;	/**< ReadWrite */
} WlStaticWdsCfgObject;

/*! \brief _WlStaticWdsCfgObject is used internally to represent WlStaticWdsCfgObject */
typedef WlStaticWdsCfgObject _WlStaticWdsCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.LANDevice.{i}.WLANConfiguration.{i}.X_BROADCOM_COM_WlanAdapter.WlWdsCfg.{i}.
 *
 * MDMOID_WL_WDS_CFG 53
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    wlMacAddr;	/**< ReadWrite */
    char *    wlSsid;	/**< ReadWrite */
    char *    wlIfcname;	/**< ReadWrite */
} WlWdsCfgObject;

/*! \brief _WlWdsCfgObject is used internally to represent WlWdsCfgObject */
typedef WlWdsCfgObject _WlWdsCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.LANDevice.{i}.WLANConfiguration.{i}.X_BROADCOM_COM_WlanAdapter.WlScanWdsCfg.{i}.
 *
 * MDMOID_WL_SCAN_WDS_CFG 54
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    wlMacAddr;	/**< ReadWrite */
    char *    wlSsid;	/**< ReadWrite */
    char *    wlIfcname;	/**< ReadWrite */
} WlScanWdsCfgObject;

/*! \brief _WlScanWdsCfgObject is used internally to represent WlScanWdsCfgObject */
typedef WlScanWdsCfgObject _WlScanWdsCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.LANDevice.{i}.WLANConfiguration.{i}.X_BROADCOM_COM_WlanAdapter.WlMimoCfg.
 *
 * MDMOID_WL_MIMO_CFG 55
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    SINT32    wlNBwCap;	/**< ReadWrite */
    SINT32    wlNCtrlsb;	/**< ReadWrite */
    SINT32    wlNBand;	/**< ReadWrite */
    SINT32    wlNMcsidx;	/**< ReadWrite */
    char *    wlNProtection;	/**< ReadWrite */
    char *    wlRifs;	/**< ReadWrite */
    char *    wlAmpdu;	/**< ReadWrite */
    char *    wlAmsdu;	/**< ReadWrite */
    char *    wlNmode;	/**< ReadWrite */
    SINT32    wlNReqd;	/**< ReadWrite */
    SINT32    wlStbcTx;	/**< ReadWrite */
    SINT32    wlStbcRx;	/**< ReadWrite */
} WlMimoCfgObject;

/*! \brief _WlMimoCfgObject is used internally to represent WlMimoCfgObject */
typedef WlMimoCfgObject _WlMimoCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.LANDevice.{i}.WLANConfiguration.{i}.X_BROADCOM_COM_WlanAdapter.WlSesCfg.
 *
 * MDMOID_WL_SES_CFG 56
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    SINT32    wlSesEnable;	/**< ReadWrite */
    SINT32    wlSesEvent;	/**< ReadWrite */
    char *    wlSesStates;	/**< ReadWrite */
    char *    wlSesSsid;	/**< ReadWrite */
    char *    wlSesWpaPsk;	/**< ReadWrite */
    SINT32    wlSesHide;	/**< ReadWrite */
    SINT32    wlSesAuth;	/**< ReadWrite */
    char *    wlSesAuthMode;	/**< ReadWrite */
    char *    wlSesWep;	/**< ReadWrite */
    char *    wlSesWpa;	/**< ReadWrite */
    SINT32    wlSesWdsMode;	/**< ReadWrite */
    SINT32    wlSesClEnable;	/**< ReadWrite */
    SINT32    wlSesClEvent;	/**< ReadWrite */
    char *    wlSesWdsWsec;	/**< ReadWrite */
} WlSesCfgObject;

/*! \brief _WlSesCfgObject is used internally to represent WlSesCfgObject */
typedef WlSesCfgObject _WlSesCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.LANDevice.{i}.WLANConfiguration.{i}.X_BROADCOM_COM_WlanAdapter.WlVirtIntfCfg.{i}.
 *
 * MDMOID_WL_VIRT_INTF_CFG 57
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    SINT32    wlIdx;	/**< ReadWrite */
    char *    wlSsid;	/**< ReadWrite */
    char *    wlIfcname;	/**< ReadWrite */
    char *    wlBrName;	/**< ReadWrite */
    char *    wlBssMacAddr;	/**< ReadWrite */
    char *    wlWpaPsk;	/**< ReadWrite */
    char *    wlWep;	/**< ReadWrite */
    char *    wlWpa;	/**< ReadWrite */
    char *    wlAuthMode;	/**< ReadWrite */
    SINT32    wlWpaGTKRekey;	/**< ReadWrite */
    char *    wlRadiusKey;	/**< ReadWrite */
    char *    wlRadiusServerIP;	/**< ReadWrite */
    SINT32    wlRadiusPort;	/**< ReadWrite */
    char *    wlWapiCertificate;	/**< ReadWrite */
    SINT32    wlAuth;	/**< ReadWrite */
    SINT32    wlEnblSsid;	/**< ReadWrite */
    char *    status;	/**< ReadOnly */
    SINT32    wlKeyIndex128;	/**< ReadWrite */
    SINT32    wlKeyIndex64;	/**< ReadWrite */
    SINT32    wlKeyBit;	/**< ReadWrite */
    SINT32    wlPreauth;	/**< ReadWrite */
    SINT32    wlNetReauth;	/**< ReadWrite */
    SINT32    wlMFP;	/**< ReadWrite */
    SINT32    wlSsdType;	/**< ReadWrite */
    SINT32    wlHide;	/**< ReadWrite */
    SINT32    wlAPIsolation;	/**< ReadWrite */
    SINT32    wlMaxAssoc;	/**< ReadWrite */
    SINT32    wlDisableWme;	/**< ReadWrite */
    char *    wlFltMacMode;	/**< ReadWrite */
    SINT32    wlEnableWmf;	/**< ReadWrite */
    SINT32    wlEnableHspot;	/**< ReadWrite */
    char *    wlOperMode;	/**< ReadWrite */
} WlVirtIntfCfgObject;

/*! \brief _WlVirtIntfCfgObject is used internally to represent WlVirtIntfCfgObject */
typedef WlVirtIntfCfgObject _WlVirtIntfCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.LANDevice.{i}.WLANConfiguration.{i}.X_BROADCOM_COM_WlanAdapter.WlVirtIntfCfg.{i}.WlMacFltCfg.{i}.
 *
 * MDMOID_WL_MAC_FLT 58
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    wlMacAddr;	/**< ReadWrite */
    char *    wlSsid;	/**< ReadWrite */
    char *    wlIfcname;	/**< ReadWrite */
} WlMacFltObject;

/*! \brief _WlMacFltObject is used internally to represent WlMacFltObject */
typedef WlMacFltObject _WlMacFltObject;



/*! \brief Obj struct for InternetGatewayDevice.LANDevice.{i}.WLANConfiguration.{i}.X_BROADCOM_COM_WlanAdapter.WlVirtIntfCfg.{i}.WlKey64Cfg.{i}.
 *
 * MDMOID_WL_KEY64_CFG 59
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    wlKey64;	/**< ReadWrite */
} WlKey64CfgObject;

/*! \brief _WlKey64CfgObject is used internally to represent WlKey64CfgObject */
typedef WlKey64CfgObject _WlKey64CfgObject;



/*! \brief Obj struct for InternetGatewayDevice.LANDevice.{i}.WLANConfiguration.{i}.X_BROADCOM_COM_WlanAdapter.WlVirtIntfCfg.{i}.WlKey128Cfg.{i}.
 *
 * MDMOID_WL_KEY128_CFG 60
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    wlKey128;	/**< ReadWrite */
} WlKey128CfgObject;

/*! \brief _WlKey128CfgObject is used internally to represent WlKey128CfgObject */
typedef WlKey128CfgObject _WlKey128CfgObject;



/*! \brief Obj struct for InternetGatewayDevice.LANDevice.{i}.WLANConfiguration.{i}.X_BROADCOM_COM_WlanAdapter.WlVirtIntfCfg.{i}.WlWpsCfg.
 *
 * MDMOID_WL_WPS_CFG 61
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    wsc_config_state;	/**< ReadWrite */
    char *    wsc_mode;	/**< ReadWrite */
} WlWpsCfgObject;

/*! \brief _WlWpsCfgObject is used internally to represent WlWpsCfgObject */
typedef WlWpsCfgObject _WlWpsCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.LANDevice.{i}.WLANConfiguration.{i}.X_BROADCOM_COM_WLANVirtMbssConfiguration.{i}.
 *
 * MDMOID_LAN_WLAN_VIRT_MBSS 62
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    mbssGuestSSID;	/**< ReadWrite */
    char *    mbssGuestBSSID;	/**< ReadOnly */
    UBOOL8    mbssGuestEnable;	/**< ReadWrite */
    UBOOL8    mbssGuestHiden;	/**< ReadWrite */
    UBOOL8    mbssGuestIsolateClients;	/**< ReadWrite */
    UBOOL8    mbssGuestDisableWMMAdvertise;	/**< ReadWrite */
    SINT32    mbssGuestMaxClients;	/**< ReadWrite */
} LanWlanVirtMbssObject;

/*! \brief _LanWlanVirtMbssObject is used internally to represent LanWlanVirtMbssObject */
typedef LanWlanVirtMbssObject _LanWlanVirtMbssObject;



/*! \brief Obj struct for InternetGatewayDevice.LANDevice.{i}.X_BROADCOM_COM_LANMocaInterfaceConfig.{i}.
 *
 * MDMOID_LAN_MOCA_INTF 63
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    status;	/**< ReadOnly */
    char *    ifName;	/**< ReadOnly */
    char *    connectionMode;	/**< ReadWrite */
    UINT32    loopbackConfiguration;	/**< ReadWrite */
    UINT32    administrativeState;	/**< ReadWrite */
    UINT32    operationalState;	/**< ReadOnly */
    char *    mocaControl;	/**< ReadWrite */
    UINT32    maxFrameSize;	/**< ReadWrite */
    UBOOL8    alarmReportingControl;	/**< ReadWrite */
    UINT32    alarmReportingControlInterval;	/**< ReadWrite */
    UBOOL8    pppoeFilter;	/**< ReadWrite */
    UINT32    networkStatus;	/**< ReadOnly */
    char *    password;	/**< ReadWrite */
    UBOOL8    privacy;	/**< ReadWrite */
    UINT32    minBandwidthAlarmThreshold;	/**< ReadWrite */
    UINT32    frequencyMask;	/**< ReadWrite */
    UINT32    rfChannel;	/**< ReadOnly */
    UINT32    lastOperationalFrequency;	/**< ReadWrite */
    UINT32    ncMode;	/**< ReadWrite */
    UBOOL8    autoNwSearch;	/**< ReadWrite */
    UBOOL8    txPwrControl;	/**< ReadWrite */
    UINT32    continuousPowerMode;	/**< ReadWrite */
    UINT32    mcastMode;	/**< ReadWrite */
    UBOOL8    labMode;	/**< ReadWrite */
    UBOOL8    eclQTagMode;	/**< ReadWrite */
    UINT32    maxTransmitTime;	/**< ReadWrite */
    SINT32    maxTransmitPower;	/**< ReadWrite */
    SINT32    snrMargin;	/**< ReadWrite */
    UINT32    outOfOrderLmo;	/**< ReadWrite */
    UBOOL8    lmoReportEnable;	/**< ReadWrite */
    UINT32    tabooMaskStart;	/**< ReadWrite */
    UINT32    tabooChannelMask;	/**< ReadWrite */
    UBOOL8    continuousIerrInsert;	/**< ReadWrite */
    UBOOL8    continuousIeMapInsert;	/**< ReadWrite */
    UINT32    maxPktAggr;	/**< ReadWrite */
    UINT32    maxConstellationNode;	/**< ReadWrite */
    UINT32    maxConstellation;	/**< ReadWrite */
    UBOOL8    preferedNetworkController;	/**< ReadWrite */
    UINT32    pmkExchangeInterval;	/**< ReadWrite */
    UINT32    tekExchangeInterval;	/**< ReadWrite */
    UINT32    traceLevel;	/**< ReadWrite */
    UBOOL8    traceLevelRestoreDefault;	/**< ReadWrite */
    UINT32    mrNonDefSeqNumber;	/**< ReadWrite */
    char *    initParmsString;	/**< ReadWrite */
    char *    configParmsString;	/**< ReadWrite */
    char *    traceParmsString;	/**< ReadWrite */
    UBOOL8    limitedConnections;	/**< ReadWrite */
#ifdef DMP_X_BROADCOM_COM_AUTODETECTION_1
    UINT32    maxConnections;	/**< ReadWrite */
#endif
} LanMocaIntfObject;

/*! \brief _LanMocaIntfObject is used internally to represent LanMocaIntfObject */
typedef LanMocaIntfObject _LanMocaIntfObject;



/*! \brief Obj struct for InternetGatewayDevice.LANDevice.{i}.X_BROADCOM_COM_LANMocaInterfaceConfig.{i}.Status.
 *
 * MDMOID_LAN_MOCA_INTF_STATUS 64
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    vendorId;	/**< ReadOnly */
    UINT32    hwVersion;	/**< ReadOnly */
    UINT32    softwareVersion;	/**< ReadOnly */
    UINT32    driverMajorVersion;	/**< ReadOnly */
    UINT32    driverMinorVersion;	/**< ReadOnly */
    UINT32    driverBuildVersion;	/**< ReadOnly */
    UINT32    selfMoCAVersion;	/**< ReadOnly */
    UINT32    networkVersionNumber;	/**< ReadOnly */
    UINT32    qam256Support;	/**< ReadOnly */
    UINT32    operationalStatus;	/**< ReadOnly */
    UINT32    linkStatus;	/**< ReadOnly */
    UINT32    connectedNodes;	/**< ReadOnly */
    UINT32    nodeId;	/**< ReadOnly */
    UINT32    networkControllerNodeId;	/**< ReadOnly */
    UINT32    upTime;	/**< ReadOnly */
    UINT32    linkUpTime;	/**< ReadOnly */
    UINT32    backupNetworkControllerNodeId;	/**< ReadOnly */
    UINT32    rfChannel;	/**< ReadOnly */
    UINT32    bwStatus;	/**< ReadOnly */
} LanMocaIntfStatusObject;

/*! \brief _LanMocaIntfStatusObject is used internally to represent LanMocaIntfStatusObject */
typedef LanMocaIntfStatusObject _LanMocaIntfStatusObject;



/*! \brief Obj struct for InternetGatewayDevice.LANDevice.{i}.X_BROADCOM_COM_LANMocaInterfaceConfig.{i}.Stats.
 *
 * MDMOID_LAN_MOCA_INTF_STATS 65
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    inUcPkts;	/**< ReadOnly */
    UINT32    inDiscardPktsEcl;	/**< ReadOnly */
    UINT32    inDiscardPktsMac;	/**< ReadOnly */
    UINT32    inUnKnownPkts;	/**< ReadOnly */
    UINT32    inMcPkts;	/**< ReadOnly */
    UINT32    inBcPkts;	/**< ReadOnly */
    UINT32    inOctetsLow;	/**< ReadOnly */
    UINT32    outUcPkts;	/**< ReadOnly */
    UINT32    outDiscardPkts;	/**< ReadOnly */
    UINT32    outBcPkts;	/**< ReadOnly */
    UINT32    outOctetsLow;	/**< ReadOnly */
    UINT32    networkControllerHandOffs;	/**< ReadOnly */
    UINT32    networkControllerBackups;	/**< ReadOnly */
} LanMocaIntfStatsObject;

/*! \brief _LanMocaIntfStatsObject is used internally to represent LanMocaIntfStatsObject */
typedef LanMocaIntfStatsObject _LanMocaIntfStatsObject;



/*! \brief Obj struct for InternetGatewayDevice.LANDevice.{i}.X_BROADCOM_COM_LANEponInterfaceConfig.{i}.
 *
 * MDMOID_LAN_EPON_INTF 66
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    status;	/**< ReadOnly */
    char *    ifName;	/**< ReadOnly */
    char *    MACAddress;	/**< ReadOnly */
    UBOOL8    MACAddressControlEnabled;	/**< ReadWrite */
} LanEponIntfObject;

/*! \brief _LanEponIntfObject is used internally to represent LanEponIntfObject */
typedef LanEponIntfObject _LanEponIntfObject;



/*! \brief Obj struct for InternetGatewayDevice.LANDevice.{i}.X_BROADCOM_COM_LANEponInterfaceConfig.{i}.Stats.
 *
 * MDMOID_LAN_EPON_INTF_STATS 67
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    bytesSent;	/**< ReadOnly */
    UINT32    bytesReceived;	/**< ReadOnly */
    UINT32    packetsSent;	/**< ReadOnly */
    UINT32    packetsReceived;	/**< ReadOnly */
    UINT32    txErrors;	/**< ReadOnly */
    UINT32    rxErrors;	/**< ReadOnly */
    UINT32    txDrops;	/**< ReadOnly */
    UINT32    rxDrops;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_MulticastPacketsSent;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_MulticastPacketsReceived;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_MulticastBytesSent;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_MulticastBytesReceived;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_UnicastPacketsSent;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_UnicastPacketsReceived;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_BroadcastPacketsSent;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_BroadcastPacketsReceived;	/**< ReadOnly */
} LanEponIntfStatsObject;

/*! \brief _LanEponIntfStatsObject is used internally to represent LanEponIntfStatsObject */
typedef LanEponIntfStatsObject _LanEponIntfStatsObject;



/*! \brief Obj struct for InternetGatewayDevice.LANDevice.{i}.Hosts.
 *
 * MDMOID_LAN_HOSTS 68
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    hostNumberOfEntries;	/**< ReadOnly */
} LanHostsObject;

/*! \brief _LanHostsObject is used internally to represent LanHostsObject */
typedef LanHostsObject _LanHostsObject;



/*! \brief Obj struct for InternetGatewayDevice.LANDevice.{i}.Hosts.Host.{i}.
 *
 * MDMOID_LAN_HOST_ENTRY 69
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    IPAddress;	/**< ReadOnly */
    char *    addressSource;	/**< ReadOnly */
    SINT32    leaseTimeRemaining;	/**< ReadOnly */
    MACADDRESS  MACAddress;	/**< ReadOnly */
    char *    hostName;	/**< ReadOnly */
    char *    interfaceType;	/**< ReadOnly */
    UBOOL8    active;	/**< ReadOnly */
    char *    X_BROADCOM_COM_IfName;	/**< ReadOnly */
} LanHostEntryObject;

/*! \brief _LanHostEntryObject is used internally to represent LanHostEntryObject */
typedef LanHostEntryObject _LanHostEntryObject;



/*! \brief Obj struct for InternetGatewayDevice.WANDevice.{i}.
 *
 * MDMOID_WAN_DEV 70
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    WANConnectionNumberOfEntries;	/**< ReadOnly */
} WanDevObject;

/*! \brief _WanDevObject is used internally to represent WanDevObject */
typedef WanDevObject _WanDevObject;



/*! \brief Obj struct for InternetGatewayDevice.WANDevice.{i}.WANCommonInterfaceConfig.
 *
 * MDMOID_WAN_COMMON_INTF_CFG 71
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    WANAccessType;	/**< ReadOnly */
    UINT32    layer1UpstreamMaxBitRate;	/**< ReadOnly */
    UINT32    layer1DownstreamMaxBitRate;	/**< ReadOnly */
    char *    physicalLinkStatus;	/**< ReadOnly */
    UINT32    totalBytesSent;	/**< ReadOnly */
    UINT32    totalBytesReceived;	/**< ReadOnly */
    UINT32    totalPacketsSent;	/**< ReadOnly */
    UINT32    totalPacketsReceived;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_TxErrors;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_RxErrors;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_TxDrops;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_RxDrops;	/**< ReadOnly */
    UINT32    maximumActiveConnections;	/**< ReadOnly */
    UINT32    numberOfActiveConnections;	/**< ReadOnly */
} WanCommonIntfCfgObject;

/*! \brief _WanCommonIntfCfgObject is used internally to represent WanCommonIntfCfgObject */
typedef WanCommonIntfCfgObject _WanCommonIntfCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.WANDevice.{i}.X_BROADCOM_COM_XTM_Interface_Stats.{i}.
 *
 * MDMOID_XTM_INTERFACE_STATS 73
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    port;	/**< ReadOnly */
    char *    status;	/**< ReadOnly */
    UINT32    inOctets;	/**< ReadOnly */
    UINT32    outOctets;	/**< ReadOnly */
    UINT32    inPackets;	/**< ReadOnly */
    UINT32    outPackets;	/**< ReadOnly */
    UINT32    inOAMCells;	/**< ReadOnly */
    UINT32    outOAMCells;	/**< ReadOnly */
    UINT32    inASMCells;	/**< ReadOnly */
    UINT32    outASMCells;	/**< ReadOnly */
    UINT32    inPacketErrors;	/**< ReadOnly */
    UINT32    inCellErrors;	/**< ReadOnly */
} XtmInterfaceStatsObject;

/*! \brief _XtmInterfaceStatsObject is used internally to represent XtmInterfaceStatsObject */
typedef XtmInterfaceStatsObject _XtmInterfaceStatsObject;



/*! \brief Obj struct for InternetGatewayDevice.WANDevice.{i}.WANDSLInterfaceConfig.
 *
 * MDMOID_WAN_DSL_INTF_CFG 78
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    status;	/**< ReadOnly */
    UBOOL8    errorSamplesAvailable;	/**< ReadOnly */
    char *    linkEncapsulationUsed;	/**< ReadWrite */
    char *    linkEncapsulationSupported;	/**< ReadWrite */
    char *    linkEncapsulationRequested;	/**< ReadWrite */
    char *    modulationType;	/**< ReadOnly */
    char *    lineEncoding;	/**< ReadOnly */
    char *    dataPath;	/**< ReadOnly */
    UINT32    interleaveDepth;	/**< ReadOnly */
    SINT32    lineNumber;	/**< ReadOnly */
    UINT32    upstreamCurrRate;	/**< ReadOnly */
    UINT32    downstreamCurrRate;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_UpstreamCurrRate_2;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_DownstreamCurrRate_2;	/**< ReadOnly */
    UINT32    upstreamMaxRate;	/**< ReadOnly */
    UINT32    downstreamMaxRate;	/**< ReadOnly */
    SINT32    upstreamNoiseMargin;	/**< ReadOnly */
    SINT32    downstreamNoiseMargin;	/**< ReadOnly */
    SINT32    upstreamAttenuation;	/**< ReadOnly */
    SINT32    downstreamAttenuation;	/**< ReadOnly */
    SINT32    upstreamPower;	/**< ReadOnly */
    SINT32    downstreamPower;	/**< ReadOnly */
    char *    ATURVendor;	/**< ReadOnly */
    UINT32    ATURCountry;	/**< ReadOnly */
    UINT32    ATURANSIStd;	/**< ReadOnly */
    UINT32    ATURANSIRev;	/**< ReadOnly */
    char *    ATUCVendor;	/**< ReadOnly */
    UINT32    ATUCCountry;	/**< ReadOnly */
    UINT32    ATUCANSIStd;	/**< ReadOnly */
    UINT32    ATUCANSIRev;	/**< ReadOnly */
    UINT32    totalStart;	/**< ReadOnly */
    UINT32    showtimeStart;	/**< ReadOnly */
    UINT32    lastShowtimeStart;	/**< ReadOnly */
    UINT32    currentDayStart;	/**< ReadOnly */
    UINT32    quarterHourStart;	/**< ReadOnly */
    char *    standardsSupported;	/**< ReadOnly */
    char *    standardUsed;	/**< ReadOnly */
#ifdef DMP_VDSL2WAN_1
    char *    allowedProfiles;	/**< ReadOnly */
#endif
#ifdef DMP_VDSL2WAN_1
    char *    currentProfile;	/**< ReadOnly */
#endif
#ifdef DMP_VDSL2WAN_1
    UINT32    UPBOKLE;	/**< ReadOnly */
#endif
    SINT32    TRELLISds;	/**< ReadOnly */
    SINT32    TRELLISus;	/**< ReadOnly */
    UINT32    ACTSNRMODEds;	/**< ReadOnly */
    SINT32    ACTSNRMODEus;	/**< ReadOnly */
    UINT32    ACTUALCE;	/**< ReadOnly */
    char *    SNRMpbds;	/**< ReadOnly */
    char *    SNRMpbus;	/**< ReadOnly */
    char *    X_BROADCOM_COM_AdslVersion;	/**< ReadOnly */
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    char *    X_BROADCOM_COM_AdslModulationCfg;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UBOOL8    X_BROADCOM_COM_ADSL2_AnnexM;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    char *    X_BROADCOM_COM_PhoneLinePair;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    char *    X_BROADCOM_COM_Bitswap;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    char *    X_BROADCOM_COM_SRA;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    char *    X_BROADCOM_COM_TrellisD;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    char *    X_BROADCOM_COM_TrellisU;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    char *    X_BROADCOM_COM_SNR;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    char *    X_BROADCOM_COM_Bitmap;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_QueueSize;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_NumTxQueues;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    char *    X_BROADCOM_COM_UpstreamS;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    char *    X_BROADCOM_COM_DownstreamS;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_UpstreamR;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_DownstreamR;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_UpstreamK;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_DownstreamK;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    char *    X_BROADCOM_COM_UpstreamDelay;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    char *    X_BROADCOM_COM_UpstreamDelay_2;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    char *    X_BROADCOM_COM_DownstreamDelay;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    char *    X_BROADCOM_COM_DownstreamDelay_2;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    char *    X_BROADCOM_COM_DownstreamINP;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    char *    X_BROADCOM_COM_DownstreamINP_2;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    char *    X_BROADCOM_COM_UpstreamINP;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    char *    X_BROADCOM_COM_UpstreamINP_2;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_UpstreamD;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_UpstreamD_2;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_DownstreamD;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_DownstreamD_2;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_ADSL2_UpstreamMSGc;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_ADSL2_UpstreamMSGc_2;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_ADSL2_DownstreamMSGc;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_ADSL2_DownstreamMSGc_2;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_ADSL2_UpstreamB;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_ADSL2_UpstreamB_2;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_ADSL2_DownstreamB;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_ADSL2_DownstreamB_2;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_ADSL2_UpstreamM;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_ADSL2_UpstreamM_2;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_ADSL2_DownstreamM;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_ADSL2_DownstreamM_2;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_ADSL2_UpstreamT;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_ADSL2_UpstreamT_2;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_ADSL2_DownstreamT;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_ADSL2_DownstreamT_2;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_ADSL2_UpstreamR;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_ADSL2_UpstreamR_2;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_ADSL2_DownstreamR;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_ADSL2_DownstreamR_2;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    char *    X_BROADCOM_COM_ADSL2_UpstreamS;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    char *    X_BROADCOM_COM_ADSL2_UpstreamS_2;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    char *    X_BROADCOM_COM_ADSL2_DownstreamS;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    char *    X_BROADCOM_COM_ADSL2_DownstreamS_2;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_ADSL2_UpstreamL;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_ADSL2_UpstreamL_2;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_ADSL2_DownstreamL;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_ADSL2_DownstreamL_2;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_VDSL2WAN_1
    UBOOL8    X_BROADCOM_COM_VDSL_8a;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_VDSL2WAN_1
    UBOOL8    X_BROADCOM_COM_VDSL_8b;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_VDSL2WAN_1
    UBOOL8    X_BROADCOM_COM_VDSL_8c;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_VDSL2WAN_1
    UBOOL8    X_BROADCOM_COM_VDSL_8d;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_VDSL2WAN_1
    UBOOL8    X_BROADCOM_COM_VDSL_12a;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_VDSL2WAN_1
    UBOOL8    X_BROADCOM_COM_VDSL_12b;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_VDSL2WAN_1
    UBOOL8    X_BROADCOM_COM_VDSL_17a;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_VDSL2WAN_1
    UBOOL8    X_BROADCOM_COM_VDSL_30a;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_VDSL2WAN_1
    UBOOL8    X_BROADCOM_COM_VDSL_BrcmPriv1;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_VDSL2WAN_1
    UBOOL8    X_BROADCOM_COM_VDSL_35b;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_VDSL2WAN_1
    UBOOL8    X_BROADCOM_COM_VDSL_BrcmPriv2;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_VDSL2WAN_1
    UBOOL8    X_BROADCOM_COM_FAST_106a;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_VDSL2WAN_1
    UBOOL8    X_BROADCOM_COM_FAST_212a;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_VDSL2WAN_1
    UBOOL8    X_BROADCOM_COM_FAST_106b;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_VDSL2WAN_1
    UBOOL8    X_BROADCOM_COM_FAST_106c;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_VDSL2WAN_1
    UBOOL8    X_BROADCOM_COM_FAST_212c;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_VDSL2WAN_1
    UBOOL8    X_BROADCOM_COM_VDSL_US0_8a;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_VDSL2WAN_1
    UINT32    X_BROADCOM_COM_VDSL_UpstreamI;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_VDSL2WAN_1
    UINT32    X_BROADCOM_COM_VDSL_UpstreamI_2;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_VDSL2WAN_1
    UINT32    X_BROADCOM_COM_VDSL_DownstreamI;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_VDSL2WAN_1
    UINT32    X_BROADCOM_COM_VDSL_DownstreamI_2;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_VDSL2WAN_1
    UINT32    X_BROADCOM_COM_VDSL_UpstreamN;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_VDSL2WAN_1
    UINT32    X_BROADCOM_COM_VDSL_UpstreamN_2;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_VDSL2WAN_1
    UINT32    X_BROADCOM_COM_VDSL_DownstreamN;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_VDSL2WAN_1
    UINT32    X_BROADCOM_COM_VDSL_DownstreamN_2;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    char *    X_BROADCOM_COM_LinkPowerState;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_DSLBONDING_1
    UBOOL8    X_BROADCOM_COM_EnableBonding;	/**< ReadWrite */
#endif
    UINT32    X_BROADCOM_COM_BondingLineNumber;	/**< ReadWrite */
#ifdef DMP_X_BROADCOM_COM_DSLBONDING_1
    char *    X_BROADCOM_COM_BondingPeerName;	/**< ReadWrite */
#endif
    UINT32    X_BROADCOM_COM_DslCfgParam;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_DslTrainingMarginQ4;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_DslShowtimeMarginQ4;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_DslLOMTimeThldSec;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_DslPwmSyncClockFreq;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_DslHsModeSwitchTime;	/**< ReadWrite */
    UINT32    X_BROADCOM_COM_DslParam;	/**< ReadWrite */
    UINT32    X_BROADCOM_COM_DslPhyCfg1Mask;	/**< ReadWrite */
    UINT32    X_BROADCOM_COM_DslPhyCfg1Value;	/**< ReadWrite */
    UINT32    X_BROADCOM_COM_DslPhyCfg2Mask;	/**< ReadWrite */
    UINT32    X_BROADCOM_COM_DslPhyCfg2Value;	/**< ReadWrite */
    UINT32    X_BROADCOM_COM_DslPhyCfg3Mask;	/**< ReadWrite */
    UINT32    X_BROADCOM_COM_DslPhyCfg3Value;	/**< ReadWrite */
    UINT32    X_BROADCOM_COM_DslPhyCfg4Mask;	/**< ReadWrite */
    UINT32    X_BROADCOM_COM_DslPhyCfg4Value;	/**< ReadWrite */
    UINT32    X_BROADCOM_COM_DslPhyCfg5Mask;	/**< ReadWrite */
    UINT32    X_BROADCOM_COM_DslPhyCfg5Value;	/**< ReadWrite */
    UINT32    X_BROADCOM_COM_DslPhyCfg6Mask;	/**< ReadWrite */
    UINT32    X_BROADCOM_COM_DslPhyCfg6Value;	/**< ReadWrite */
    UINT32    X_BROADCOM_COM_DslPhyCfg7Mask;	/**< ReadWrite */
    UINT32    X_BROADCOM_COM_DslPhyCfg7Value;	/**< ReadWrite */
    UINT32    X_BROADCOM_COM_DslPhyCfg8Mask;	/**< ReadWrite */
    UINT32    X_BROADCOM_COM_DslPhyCfg8Value;	/**< ReadWrite */
    UINT32    X_BROADCOM_COM_DslPhyUsDataRateKbps;	/**< ReadWrite */
    UINT32    X_BROADCOM_COM_DslPhyDsDataRateKbps;	/**< ReadWrite */
    UINT32    X_BROADCOM_COM_DslPhyAggrDataRateKbps;	/**< ReadWrite */
    UINT32    X_BROADCOM_COM_DslPhyMiscCfgParam;	/**< ReadWrite */
} WanDslIntfCfgObject;

/*! \brief _WanDslIntfCfgObject is used internally to represent WanDslIntfCfgObject */
typedef WanDslIntfCfgObject _WanDslIntfCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.WANDevice.{i}.WANDSLInterfaceConfig.X_BROADCOM_COM_BertTest.
 *
 * MDMOID_WAN_BERT_TEST 79
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    bertTestMode;	/**< ReadWrite */
    UINT32    bertTestDuration;	/**< ReadWrite */
    char *    bertTestStatus;	/**< ReadOnly */
    UINT32    totalTime;	/**< ReadOnly */
    UINT32    elapsedTime;	/**< ReadOnly */
    UINT32    bitsTestedCntHigh;	/**< ReadOnly */
    UINT32    bitsTestedCntLow;	/**< ReadOnly */
    UINT32    errBitsCntHigh;	/**< ReadOnly */
    UINT32    errBitsCntLow;	/**< ReadOnly */
} WanBertTestObject;

/*! \brief _WanBertTestObject is used internally to represent WanBertTestObject */
typedef WanBertTestObject _WanBertTestObject;



/*! \brief Obj struct for InternetGatewayDevice.WANDevice.{i}.WANDSLInterfaceConfig.Stats.
 *
 * MDMOID_WAN_DSL_INTF_STATS 80
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
} WanDslIntfStatsObject;

/*! \brief _WanDslIntfStatsObject is used internally to represent WanDslIntfStatsObject */
typedef WanDslIntfStatsObject _WanDslIntfStatsObject;



/*! \brief Obj struct for InternetGatewayDevice.WANDevice.{i}.WANDSLInterfaceConfig.Stats.Total.
 *
 * MDMOID_WAN_DSL_INTF_STATS_TOTAL 81
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_RxRsCorrectable;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_RxRsCorrectable_2;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_TxRsCorrectable;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_TxRsCorrectable_2;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_TxRsUncorrectable;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_TxRsUncorrectable_2;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_RxRsUncorrectable;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_RxRsUncorrectable_2;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_TxRsWords;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_TxRsWords_2;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_RxRsWords;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_RxRsWords_2;	/**< ReadOnly */
#endif
    UINT32    receiveBlocks;	/**< ReadOnly */
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_ReceiveBlocks_2;	/**< ReadOnly */
#endif
    UINT32    transmitBlocks;	/**< ReadOnly */
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_TransmitBlocks_2;	/**< ReadOnly */
#endif
    UINT32    cellDelin;	/**< ReadOnly */
    UINT32    linkRetrain;	/**< ReadOnly */
    UINT32    initErrors;	/**< ReadOnly */
    UINT32    initTimeouts;	/**< ReadOnly */
    UINT32    lossOfFraming;	/**< ReadOnly */
    UINT32    erroredSecs;	/**< ReadOnly */
    UINT32    severelyErroredSecs;	/**< ReadOnly */
    UINT32    FECErrors;	/**< ReadOnly */
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_FECErrors_2;	/**< ReadOnly */
#endif
    UINT32    ATUCFECErrors;	/**< ReadOnly */
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_ATUCFECErrors_2;	/**< ReadOnly */
#endif
    UINT32    HECErrors;	/**< ReadOnly */
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_HECErrors_2;	/**< ReadOnly */
#endif
    UINT32    ATUCHECErrors;	/**< ReadOnly */
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_ATUCHECErrors_2;	/**< ReadOnly */
#endif
    UINT32    CRCErrors;	/**< ReadOnly */
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_CRCErrors_2;	/**< ReadOnly */
#endif
    UINT32    ATUCCRCErrors;	/**< ReadOnly */
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_ATUCCRCErrors_2;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_UpstreamUas;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_DownstreamUas;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_UpstreamEs;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_UpstreamSes;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_UpstreamBitErrors;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_UpstreamBitErrors_2;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_DownstreamBitErrors;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_DownstreamBitErrors_2;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_UpstreamDataCells;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_UpstreamDataCells_2;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_DownstreamDataCells;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_DownstreamDataCells_2;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_UpstreamTotalCells;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_UpstreamTotalCells_2;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_DownstreamTotalCells;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_DownstreamTotalCells_2;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_UpstreamLCD;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_UpstreamLCD_2;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_DownstreamLCD;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_DownstreamLCD_2;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_UpstreamOCD;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_UpstreamOCD_2;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_DownstreamOCD;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_DownstreamOCD_2;	/**< ReadOnly */
#endif
} WanDslIntfStatsTotalObject;

/*! \brief _WanDslIntfStatsTotalObject is used internally to represent WanDslIntfStatsTotalObject */
typedef WanDslIntfStatsTotalObject _WanDslIntfStatsTotalObject;



/*! \brief Obj struct for InternetGatewayDevice.WANDevice.{i}.WANDSLInterfaceConfig.Stats.Showtime.
 *
 * MDMOID_WAN_DSL_INTF_STATS_SHOWTIME 82
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_RxRsUncorrectable;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_TxRsUncorrectable;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_RxRsCorrectable;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_TxRsCorrectable;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_RxRsWords;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_TxRsWords;	/**< ReadOnly */
#endif
    UINT32    receiveBlocks;	/**< ReadOnly */
    UINT32    transmitBlocks;	/**< ReadOnly */
    UINT32    cellDelin;	/**< ReadOnly */
    UINT32    linkRetrain;	/**< ReadOnly */
    UINT32    initErrors;	/**< ReadOnly */
    UINT32    initTimeouts;	/**< ReadOnly */
    UINT32    lossOfFraming;	/**< ReadOnly */
    UINT32    erroredSecs;	/**< ReadOnly */
    UINT32    severelyErroredSecs;	/**< ReadOnly */
    UINT32    FECErrors;	/**< ReadOnly */
    UINT32    ATUCFECErrors;	/**< ReadOnly */
    UINT32    HECErrors;	/**< ReadOnly */
    UINT32    ATUCHECErrors;	/**< ReadOnly */
    UINT32    CRCErrors;	/**< ReadOnly */
    UINT32    ATUCCRCErrors;	/**< ReadOnly */
} WanDslIntfStatsShowtimeObject;

/*! \brief _WanDslIntfStatsShowtimeObject is used internally to represent WanDslIntfStatsShowtimeObject */
typedef WanDslIntfStatsShowtimeObject _WanDslIntfStatsShowtimeObject;



/*! \brief Obj struct for InternetGatewayDevice.WANDevice.{i}.WANDSLInterfaceConfig.Stats.CurrentDay.
 *
 * MDMOID_WAN_DSL_INTF_STATS_CURRENT_DAY 84
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    receiveBlocks;	/**< ReadOnly */
    UINT32    transmitBlocks;	/**< ReadOnly */
    UINT32    cellDelin;	/**< ReadOnly */
    UINT32    linkRetrain;	/**< ReadOnly */
    UINT32    initErrors;	/**< ReadOnly */
    UINT32    initTimeouts;	/**< ReadOnly */
    UINT32    lossOfFraming;	/**< ReadOnly */
    UINT32    erroredSecs;	/**< ReadOnly */
    UINT32    severelyErroredSecs;	/**< ReadOnly */
    UINT32    FECErrors;	/**< ReadOnly */
    UINT32    ATUCFECErrors;	/**< ReadOnly */
    UINT32    HECErrors;	/**< ReadOnly */
    UINT32    ATUCHECErrors;	/**< ReadOnly */
    UINT32    CRCErrors;	/**< ReadOnly */
    UINT32    ATUCCRCErrors;	/**< ReadOnly */
} WanDslIntfStatsCurrentDayObject;

/*! \brief _WanDslIntfStatsCurrentDayObject is used internally to represent WanDslIntfStatsCurrentDayObject */
typedef WanDslIntfStatsCurrentDayObject _WanDslIntfStatsCurrentDayObject;



/*! \brief Obj struct for InternetGatewayDevice.WANDevice.{i}.WANDSLInterfaceConfig.Stats.QuarterHour.
 *
 * MDMOID_WAN_DSL_INTF_STATS_QUARTER_HOUR 85
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    receiveBlocks;	/**< ReadOnly */
    UINT32    transmitBlocks;	/**< ReadOnly */
    UINT32    cellDelin;	/**< ReadOnly */
    UINT32    linkRetrain;	/**< ReadOnly */
    UINT32    initErrors;	/**< ReadOnly */
    UINT32    initTimeouts;	/**< ReadOnly */
    UINT32    lossOfFraming;	/**< ReadOnly */
    UINT32    erroredSecs;	/**< ReadOnly */
    UINT32    severelyErroredSecs;	/**< ReadOnly */
    UINT32    FECErrors;	/**< ReadOnly */
    UINT32    ATUCFECErrors;	/**< ReadOnly */
    UINT32    HECErrors;	/**< ReadOnly */
    UINT32    ATUCHECErrors;	/**< ReadOnly */
    UINT32    CRCErrors;	/**< ReadOnly */
    UINT32    ATUCCRCErrors;	/**< ReadOnly */
} WanDslIntfStatsQuarterHourObject;

/*! \brief _WanDslIntfStatsQuarterHourObject is used internally to represent WanDslIntfStatsQuarterHourObject */
typedef WanDslIntfStatsQuarterHourObject _WanDslIntfStatsQuarterHourObject;



/*! \brief Obj struct for InternetGatewayDevice.WANDevice.{i}.WANDSLInterfaceConfig.TestParams.
 *
 * MDMOID_WAN_DSL_TEST_PARAMS 86
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    HLOGGds;	/**< ReadOnly */
    UINT32    HLOGGus;	/**< ReadOnly */
    char *    HLOGpsds;	/**< ReadOnly */
    char *    HLOGpsus;	/**< ReadOnly */
    UINT32    HLOGMTds;	/**< ReadOnly */
    UINT32    HLOGMTus;	/**< ReadOnly */
    UINT32    QLNGds;	/**< ReadOnly */
    UINT32    QLNGus;	/**< ReadOnly */
    char *    QLNpsds;	/**< ReadOnly */
    char *    QLNpsus;	/**< ReadOnly */
    UINT32    QLNMTds;	/**< ReadOnly */
    UINT32    QLNMTus;	/**< ReadOnly */
    UINT32    SNRGds;	/**< ReadOnly */
    UINT32    SNRGus;	/**< ReadOnly */
    char *    SNRpsds;	/**< ReadOnly */
    char *    SNRpsus;	/**< ReadOnly */
    UINT32    SNRMTds;	/**< ReadOnly */
    UINT32    SNRMTus;	/**< ReadOnly */
    char *    LATNds;	/**< ReadOnly */
    char *    LATNus;	/**< ReadOnly */
    char *    SATNds;	/**< ReadOnly */
    char *    SATNus;	/**< ReadOnly */
} WanDslTestParamsObject;

/*! \brief _WanDslTestParamsObject is used internally to represent WanDslTestParamsObject */
typedef WanDslTestParamsObject _WanDslTestParamsObject;



/*! \brief Obj struct for InternetGatewayDevice.WANDevice.{i}.WANEthernetInterfaceConfig.
 *
 * MDMOID_WAN_ETH_INTF 87
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    status;	/**< ReadOnly */
    MACADDRESS  MACAddress;	/**< ReadOnly */
    char *    maxBitRate;	/**< ReadWrite */
    char *    duplexMode;	/**< ReadWrite */
#ifdef DMP_QOS_1
    SINT32    shapingRate;	/**< ReadWrite */
#endif
#ifdef DMP_QOS_1
    UINT32    shapingBurstSize;	/**< ReadWrite */
#endif
    char *    X_BROADCOM_COM_IfName;	/**< ReadWrite */
    char *    X_BROADCOM_COM_ConnectionMode;	/**< ReadWrite */
    UBOOL8    X_BROADCOM_COM_PersistentDevice;	/**< ReadWrite */
    UBOOL8    X_BROADCOM_COM_LimitedConnections;	/**< ReadWrite */
#ifdef DMP_X_BROADCOM_COM_AUTODETECTION_1
    UINT32    X_BROADCOM_COM_MaxConnections;	/**< ReadWrite */
#endif
    UBOOL8    X_BROADCOM_COM_GMAC_Enabled;	/**< ReadWrite */
    char *    X_BROADCOM_COM_WanLan_Attribute;	/**< ReadWrite */
} WanEthIntfObject;

/*! \brief _WanEthIntfObject is used internally to represent WanEthIntfObject */
typedef WanEthIntfObject _WanEthIntfObject;



/*! \brief Obj struct for InternetGatewayDevice.WANDevice.{i}.WANEthernetInterfaceConfig.X_BROADCOM_COM_IPv6Address.{i}.
 *
 * MDMOID_I_PV6_ADDR 88
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    scope;	/**< ReadOnly */
    char *    IPv6Address;	/**< ReadOnly */
} IPv6AddrObject;

/*! \brief _IPv6AddrObject is used internally to represent IPv6AddrObject */
typedef IPv6AddrObject _IPv6AddrObject;



/*! \brief Obj struct for InternetGatewayDevice.WANDevice.{i}.WANEthernetInterfaceConfig.Stats.
 *
 * MDMOID_WAN_ETH_INTF_STATS 89
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    bytesSent;	/**< ReadOnly */
    UINT32    bytesReceived;	/**< ReadOnly */
    UINT32    packetsSent;	/**< ReadOnly */
    UINT32    packetsReceived;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_RxDrops;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_TxDrops;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_RxErrors;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_TxErrors;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_MulticastPacketsSent;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_MulticastPacketsReceived;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_MulticastBytesSent;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_MulticastBytesReceived;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_UnicastPacketsSent;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_UnicastPacketsReceived;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_BroadcastPacketsSent;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_BroadcastPacketsReceived;	/**< ReadOnly */
} WanEthIntfStatsObject;

/*! \brief _WanEthIntfStatsObject is used internally to represent WanEthIntfStatsObject */
typedef WanEthIntfStatsObject _WanEthIntfStatsObject;



/*! \brief Obj struct for InternetGatewayDevice.WANDevice.{i}.X_BROADCOM_COM_WANWifiInterfaceConfig.
 *
 * MDMOID_WAN_WIFI_INTF 90
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    status;	/**< ReadOnly */
    char *    MACAddress;	/**< ReadOnly */
    char *    ifName;	/**< ReadWrite */
    char *    connectionMode;	/**< ReadWrite */
    UBOOL8    persistentDevice;	/**< ReadWrite */
    UBOOL8    limitedConnections;	/**< ReadWrite */
#ifdef DMP_X_BROADCOM_COM_AUTODETECTION_1
    UINT32    maxConnections;	/**< ReadWrite */
#endif
} WanWifiIntfObject;

/*! \brief _WanWifiIntfObject is used internally to represent WanWifiIntfObject */
typedef WanWifiIntfObject _WanWifiIntfObject;



/*! \brief Obj struct for InternetGatewayDevice.WANDevice.{i}.X_BROADCOM_COM_WANWifiInterfaceConfig.IPv6Address.{i}.
 *
 * MDMOID_WIFI_I_PV6_ADDR 91
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    scope;	/**< ReadOnly */
    char *    IPv6Address;	/**< ReadOnly */
} WifiIPv6AddrObject;

/*! \brief _WifiIPv6AddrObject is used internally to represent WifiIPv6AddrObject */
typedef WifiIPv6AddrObject _WifiIPv6AddrObject;



/*! \brief Obj struct for InternetGatewayDevice.WANDevice.{i}.X_BROADCOM_COM_WANWifiInterfaceConfig.Stats.
 *
 * MDMOID_WAN_WIFI_INTF_STATS 92
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    bytesSent;	/**< ReadOnly */
    UINT32    bytesReceived;	/**< ReadOnly */
    UINT32    packetsSent;	/**< ReadOnly */
    UINT32    packetsReceived;	/**< ReadOnly */
} WanWifiIntfStatsObject;

/*! \brief _WanWifiIntfStatsObject is used internally to represent WanWifiIntfStatsObject */
typedef WanWifiIntfStatsObject _WanWifiIntfStatsObject;



/*! \brief Obj struct for InternetGatewayDevice.WANDevice.{i}.X_BROADCOM_COM_WANMocaInterfaceConfig.
 *
 * MDMOID_WAN_MOCA_INTF 93
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    status;	/**< ReadOnly */
    char *    ifName;	/**< ReadWrite */
    char *    connectionMode;	/**< ReadWrite */
    UINT32    loopbackConfiguration;	/**< ReadWrite */
    UINT32    administrativeState;	/**< ReadWrite */
    UINT32    operationalState;	/**< ReadOnly */
    char *    mocaControl;	/**< ReadWrite */
    UINT32    maxFrameSize;	/**< ReadWrite */
    UBOOL8    alarmReportingControl;	/**< ReadWrite */
    UINT32    alarmReportingControlInterval;	/**< ReadWrite */
    UBOOL8    pppoeFilter;	/**< ReadWrite */
    UINT32    networkStatus;	/**< ReadOnly */
    char *    password;	/**< ReadWrite */
    UBOOL8    privacy;	/**< ReadWrite */
    UINT32    minBandwidthAlarmThreshold;	/**< ReadWrite */
    UINT32    frequencyMask;	/**< ReadWrite */
    UINT32    rfChannel;	/**< ReadOnly */
    UINT32    lastOperationalFrequency;	/**< ReadWrite */
    UINT32    ncMode;	/**< ReadWrite */
    UBOOL8    autoNwSearch;	/**< ReadWrite */
    UBOOL8    txPwrControl;	/**< ReadWrite */
    UINT32    continuousPowerMode;	/**< ReadWrite */
    UINT32    mcastMode;	/**< ReadWrite */
    UBOOL8    labMode;	/**< ReadWrite */
    UBOOL8    eclQTagMode;	/**< ReadWrite */
    UINT32    maxTransmitTime;	/**< ReadWrite */
    SINT32    maxTransmitPower;	/**< ReadWrite */
    SINT32    snrMargin;	/**< ReadWrite */
    UINT32    outOfOrderLmo;	/**< ReadWrite */
    UBOOL8    lmoReportEnable;	/**< ReadWrite */
    UINT32    tabooMaskStart;	/**< ReadWrite */
    UINT32    tabooChannelMask;	/**< ReadWrite */
    UBOOL8    continuousIerrInsert;	/**< ReadWrite */
    UBOOL8    continuousIeMapInsert;	/**< ReadWrite */
    UINT32    maxPktAggr;	/**< ReadWrite */
    UINT32    maxConstellationNode;	/**< ReadWrite */
    UINT32    maxConstellation;	/**< ReadWrite */
    UBOOL8    preferedNetworkController;	/**< ReadWrite */
    UINT32    pmkExchangeInterval;	/**< ReadWrite */
    UINT32    tekExchangeInterval;	/**< ReadWrite */
    UINT32    traceLevel;	/**< ReadWrite */
    UBOOL8    traceLevelRestoreDefault;	/**< ReadWrite */
    UINT32    mrNonDefSeqNumber;	/**< ReadWrite */
    char *    initParmsString;	/**< ReadWrite */
    char *    configParmsString;	/**< ReadWrite */
    char *    traceParmsString;	/**< ReadWrite */
    UBOOL8    persistentDevice;	/**< ReadWrite */
    UBOOL8    limitedConnections;	/**< ReadWrite */
#ifdef DMP_X_BROADCOM_COM_AUTODETECTION_1
    UINT32    maxConnections;	/**< ReadWrite */
#endif
} WanMocaIntfObject;

/*! \brief _WanMocaIntfObject is used internally to represent WanMocaIntfObject */
typedef WanMocaIntfObject _WanMocaIntfObject;



/*! \brief Obj struct for InternetGatewayDevice.WANDevice.{i}.X_BROADCOM_COM_WANMocaInterfaceConfig.Status.
 *
 * MDMOID_WAN_MOCA_INTF_STATUS 94
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    vendorId;	/**< ReadOnly */
    UINT32    hwVersion;	/**< ReadOnly */
    UINT32    softwareVersion;	/**< ReadOnly */
    UINT32    driverMajorVersion;	/**< ReadOnly */
    UINT32    driverMinorVersion;	/**< ReadOnly */
    UINT32    driverBuildVersion;	/**< ReadOnly */
    UINT32    selfMoCAVersion;	/**< ReadOnly */
    UINT32    networkVersionNumber;	/**< ReadOnly */
    UINT32    qam256Support;	/**< ReadOnly */
    UINT32    operationalStatus;	/**< ReadOnly */
    UINT32    linkStatus;	/**< ReadOnly */
    UINT32    connectedNodes;	/**< ReadOnly */
    UINT32    nodeId;	/**< ReadOnly */
    UINT32    networkControllerNodeId;	/**< ReadOnly */
    UINT32    upTime;	/**< ReadOnly */
    UINT32    linkUpTime;	/**< ReadOnly */
    UINT32    backupNetworkControllerNodeId;	/**< ReadOnly */
    UINT32    rfChannel;	/**< ReadOnly */
    UINT32    bwStatus;	/**< ReadOnly */
} WanMocaIntfStatusObject;

/*! \brief _WanMocaIntfStatusObject is used internally to represent WanMocaIntfStatusObject */
typedef WanMocaIntfStatusObject _WanMocaIntfStatusObject;



/*! \brief Obj struct for InternetGatewayDevice.WANDevice.{i}.X_BROADCOM_COM_WANMocaInterfaceConfig.Stats.
 *
 * MDMOID_WAN_MOCA_INTF_STATS 95
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    inUcPkts;	/**< ReadOnly */
    UINT32    inDiscardPktsEcl;	/**< ReadOnly */
    UINT32    inDiscardPktsMac;	/**< ReadOnly */
    UINT32    inUnKnownPkts;	/**< ReadOnly */
    UINT32    inMcPkts;	/**< ReadOnly */
    UINT32    inBcPkts;	/**< ReadOnly */
    UINT32    inOctetsLow;	/**< ReadOnly */
    UINT32    outUcPkts;	/**< ReadOnly */
    UINT32    outDiscardPkts;	/**< ReadOnly */
    UINT32    outBcPkts;	/**< ReadOnly */
    UINT32    outOctetsLow;	/**< ReadOnly */
    UINT32    networkControllerHandOffs;	/**< ReadOnly */
    UINT32    networkControllerBackups;	/**< ReadOnly */
} WanMocaIntfStatsObject;

/*! \brief _WanMocaIntfStatsObject is used internally to represent WanMocaIntfStatsObject */
typedef WanMocaIntfStatsObject _WanMocaIntfStatsObject;



/*! \brief Obj struct for InternetGatewayDevice.WANDevice.{i}.X_BROADCOM_COM_L2tpAcIntfConfig.{i}.
 *
 * MDMOID_L2TP_AC_INTF_CONFIG 96
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    tunnelName;	/**< ReadWrite */
    char *    lnsIpAddress;	/**< ReadWrite */
    char *    intfStatus;	/**< ReadOnly */
    UINT32    tunnelId;	/**< ReadOnly */
    UINT32    sourcePort;	/**< ReadWrite */
} L2tpAcIntfConfigObject;

/*! \brief _L2tpAcIntfConfigObject is used internally to represent L2tpAcIntfConfigObject */
typedef L2tpAcIntfConfigObject _L2tpAcIntfConfigObject;



/*! \brief Obj struct for InternetGatewayDevice.WANDevice.{i}.X_BROADCOM_COM_WANPonInterfaceConfig.
 *
 * MDMOID_WAN_PON_INTF 97
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    status;	/**< ReadOnly */
    char *    ponType;	/**< ReadWrite */
} WanPonIntfObject;

/*! \brief _WanPonIntfObject is used internally to represent WanPonIntfObject */
typedef WanPonIntfObject _WanPonIntfObject;



/*! \brief Obj struct for InternetGatewayDevice.WANDevice.{i}.X_BROADCOM_COM_WANPonInterfaceConfig.Stats.
 *
 * MDMOID_WAN_PON_INTF_STATUS 98
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    bytesSent;	/**< ReadWrite */
    UINT32    byteReceived;	/**< ReadOnly */
    UINT32    packetsSent;	/**< ReadOnly */
    UINT32    packetsReceived;	/**< ReadOnly */
} WanPonIntfStatusObject;

/*! \brief _WanPonIntfStatusObject is used internally to represent WanPonIntfStatusObject */
typedef WanPonIntfStatusObject _WanPonIntfStatusObject;



/*! \brief Obj struct for InternetGatewayDevice.WANDevice.{i}.WANDSLDiagnostics.
 *
 * MDMOID_WAN_DSL_DIAG 101
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    loopDiagnosticsState;	/**< ReadWrite */
    SINT32    ACTPSDds;	/**< ReadOnly */
    SINT32    ACTPSDus;	/**< ReadOnly */
    SINT32    ACTATPds;	/**< ReadOnly */
    SINT32    ACTATPus;	/**< ReadOnly */
    SINT32    HLINSCds;	/**< ReadOnly */
    char *    HLINpsds;	/**< ReadOnly */
    char *    QLNpsds;	/**< ReadOnly */
    char *    SNRpsds;	/**< ReadOnly */
    char *    BITSpsds;	/**< ReadOnly */
    char *    GAINSpsds;	/**< ReadOnly */
    SINT32    HLINSCus;	/**< ReadOnly */
    SINT32    HLINGds;	/**< ReadOnly */
    UINT32    HLINGus;	/**< ReadOnly */
    char *    HLINpsus;	/**< ReadOnly */
    UINT32    HLOGGds;	/**< ReadOnly */
    UINT32    HLOGGus;	/**< ReadOnly */
    char *    HLOGpsds;	/**< ReadOnly */
    char *    HLOGpsus;	/**< ReadOnly */
    UINT32    HLOGMTds;	/**< ReadOnly */
    UINT32    HLOGMTus;	/**< ReadOnly */
    UINT32    QLNGds;	/**< ReadOnly */
    UINT32    QLNGus;	/**< ReadOnly */
    char *    QLNpsus;	/**< ReadOnly */
    UINT32    QLNMTds;	/**< ReadOnly */
    UINT32    QLNMTus;	/**< ReadOnly */
    UINT32    SNRGds;	/**< ReadOnly */
    UINT32    SNRGus;	/**< ReadOnly */
    char *    SNRpsus;	/**< ReadOnly */
    UINT32    SNRMTds;	/**< ReadOnly */
    UINT32    SNRMTus;	/**< ReadOnly */
    char *    LATNpbds;	/**< ReadOnly */
    char *    LATNpbus;	/**< ReadOnly */
    char *    SATNds;	/**< ReadOnly */
    char *    SATNus;	/**< ReadOnly */
} WanDslDiagObject;

/*! \brief _WanDslDiagObject is used internally to represent WanDslDiagObject */
typedef WanDslDiagObject _WanDslDiagObject;



/*! \brief Obj struct for InternetGatewayDevice.WANDevice.{i}.X_BROADCOM_COM_WANDSLDiagnostics.
 *
 * MDMOID_WAN_DSL_PROPRIETARY_DIAG 102
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
} WanDslProprietaryDiagObject;

/*! \brief _WanDslProprietaryDiagObject is used internally to represent WanDslProprietaryDiagObject */
typedef WanDslProprietaryDiagObject _WanDslProprietaryDiagObject;



/*! \brief Obj struct for InternetGatewayDevice.WANDevice.{i}.X_BROADCOM_COM_WANDSLDiagnostics.PeakLineNoise.
 *
 * MDMOID_WAN_DSL_DIAG_PLN 103
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    diagnosticState;	/**< ReadWrite */
    char *    PLNThldBB;	/**< ReadWrite */
    char *    PLNThldPerTone;	/**< ReadWrite */
    UINT32    PLNDurationNbBins;	/**< ReadWrite */
    char *    PLNDurationBins;	/**< ReadWrite */
    UINT32    PLNIntrArvNbBins;	/**< ReadWrite */
    char *    PLNIntrArvlBins;	/**< ReadWrite */
    char *    PLNValueps;	/**< ReadOnly */
    char *    PLNThldCntps;	/**< ReadOnly */
    char *    PLNDurationHist;	/**< ReadOnly */
    char *    PLNIntrArvlHist;	/**< ReadOnly */
    UINT32    PLNPerToneCounter;	/**< ReadOnly */
    UINT32    PLNBBCounter;	/**< ReadOnly */
} WanDslDiagPlnObject;

/*! \brief _WanDslDiagPlnObject is used internally to represent WanDslDiagPlnObject */
typedef WanDslDiagPlnObject _WanDslDiagPlnObject;



/*! \brief Obj struct for InternetGatewayDevice.WANDevice.{i}.X_BROADCOM_COM_WANDSLDiagnostics.NonLinearity.
 *
 * MDMOID_WAN_DSL_DIAG_NON_LINEARITY 104
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    maxCriticalDistNoise;	/**< ReadOnly */
    UINT32    distAffectedBits;	/**< ReadOnly */
    char *    distNoisedB;	/**< ReadOnly */
} WanDslDiagNonLinearityObject;

/*! \brief _WanDslDiagNonLinearityObject is used internally to represent WanDslDiagNonLinearityObject */
typedef WanDslDiagNonLinearityObject _WanDslDiagNonLinearityObject;



/*! \brief Obj struct for InternetGatewayDevice.WANDevice.{i}.X_BROADCOM_COM_WANCellularInterfaceConfig.
 *
 * MDMOID_WAN_CELLULAR_INTERFACE_CFG 105
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    cellularInterface;	/**< ReadWrite */
} WanCellularInterfaceCfgObject;

/*! \brief _WanCellularInterfaceCfgObject is used internally to represent WanCellularInterfaceCfgObject */
typedef WanCellularInterfaceCfgObject _WanCellularInterfaceCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.WANDevice.{i}.WANConnectionDevice.{i}.
 *
 * MDMOID_WAN_CONN_DEVICE 106
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    WANIPConnectionNumberOfEntries;	/**< ReadOnly */
    UINT32    WANPPPConnectionNumberOfEntries;	/**< ReadOnly */
} WanConnDeviceObject;

/*! \brief _WanConnDeviceObject is used internally to represent WanConnDeviceObject */
typedef WanConnDeviceObject _WanConnDeviceObject;



/*! \brief Obj struct for InternetGatewayDevice.WANDevice.{i}.WANConnectionDevice.{i}.X_BROADCOM_COM_WANATMF4EndToEndLoopbackDiagnostics.
 *
 * MDMOID_WAN_ATM_F4_END_TO_END_LOOPBACK_DIAG 107
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    diagnosticsState;	/**< ReadWrite */
    UINT32    numberOfRepetitions;	/**< ReadWrite */
    UINT32    timeout;	/**< ReadWrite */
    UINT32    successCount;	/**< ReadOnly */
    UINT32    failureCount;	/**< ReadOnly */
    UINT32    averageResponseTime;	/**< ReadOnly */
    UINT32    minimumResponseTime;	/**< ReadOnly */
    UINT32    maximumResponseTime;	/**< ReadOnly */
} WanAtmF4EndToEndLoopbackDiagObject;

/*! \brief _WanAtmF4EndToEndLoopbackDiagObject is used internally to represent WanAtmF4EndToEndLoopbackDiagObject */
typedef WanAtmF4EndToEndLoopbackDiagObject _WanAtmF4EndToEndLoopbackDiagObject;



/*! \brief Obj struct for InternetGatewayDevice.WANDevice.{i}.WANConnectionDevice.{i}.X_BROADCOM_COM_WANATMF4LoopbackDiagnostics.
 *
 * MDMOID_WAN_ATM_F4_LOOPBACK_DIAG 108
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    diagnosticsState;	/**< ReadWrite */
    UINT32    numberOfRepetitions;	/**< ReadWrite */
    UINT32    timeout;	/**< ReadWrite */
    UINT32    successCount;	/**< ReadOnly */
    UINT32    failureCount;	/**< ReadOnly */
    UINT32    averageResponseTime;	/**< ReadOnly */
    UINT32    minimumResponseTime;	/**< ReadOnly */
    UINT32    maximumResponseTime;	/**< ReadOnly */
} WanAtmF4LoopbackDiagObject;

/*! \brief _WanAtmF4LoopbackDiagObject is used internally to represent WanAtmF4LoopbackDiagObject */
typedef WanAtmF4LoopbackDiagObject _WanAtmF4LoopbackDiagObject;



/*! \brief Obj struct for InternetGatewayDevice.WANDevice.{i}.WANConnectionDevice.{i}.X_BROADCOM_COM_WANATMF5EndToEndLoopbackDiagnostics.
 *
 * MDMOID_WAN_ATM_F5_END_TO_END_LOOPBACK_DIAG 109
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    diagnosticsState;	/**< ReadWrite */
    UINT32    numberOfRepetitions;	/**< ReadWrite */
    UINT32    timeout;	/**< ReadWrite */
    UINT32    successCount;	/**< ReadOnly */
    UINT32    failureCount;	/**< ReadOnly */
    UINT32    averageResponseTime;	/**< ReadOnly */
    UINT32    minimumResponseTime;	/**< ReadOnly */
    UINT32    maximumResponseTime;	/**< ReadOnly */
} WanAtmF5EndToEndLoopbackDiagObject;

/*! \brief _WanAtmF5EndToEndLoopbackDiagObject is used internally to represent WanAtmF5EndToEndLoopbackDiagObject */
typedef WanAtmF5EndToEndLoopbackDiagObject _WanAtmF5EndToEndLoopbackDiagObject;



/*! \brief Obj struct for InternetGatewayDevice.WANDevice.{i}.WANConnectionDevice.{i}.X_BROADCOM_COM_WANGPONLinkConfig.
 *
 * MDMOID_WAN_GPON_LINK_CFG 110
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    linkStatus;	/**< ReadOnly */
    UINT32    portID;	/**< ReadOnly */
    SINT32    direction;	/**< ReadOnly */
    char *    connectionMode;	/**< ReadWrite */
    char *    ifName;	/**< ReadWrite */
    UBOOL8    phyDetected;	/**< ReadOnly */
} WanGponLinkCfgObject;

/*! \brief _WanGponLinkCfgObject is used internally to represent WanGponLinkCfgObject */
typedef WanGponLinkCfgObject _WanGponLinkCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.WANDevice.{i}.WANConnectionDevice.{i}.X_BROADCOM_COM_WANEPONLinkConfig.
 *
 * MDMOID_WAN_EPON_LINK_CFG 111
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    linkStatus;	/**< ReadOnly */
    char *    connectionMode;	/**< ReadWrite */
    char *    ifName;	/**< ReadWrite */
    UBOOL8    phyDetected;	/**< ReadOnly */
} WanEponLinkCfgObject;

/*! \brief _WanEponLinkCfgObject is used internally to represent WanEponLinkCfgObject */
typedef WanEponLinkCfgObject _WanEponLinkCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.WANDevice.{i}.WANConnectionDevice.{i}.WANDSLLinkConfig.
 *
 * MDMOID_WAN_DSL_LINK_CFG 112
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    linkStatus;	/**< ReadOnly */
    char *    linkType;	/**< ReadWrite */
    UBOOL8    autoConfig;	/**< ReadOnly */
    char *    modulationType;	/**< ReadOnly */
    char *    destinationAddress;	/**< ReadWrite */
    char *    ATMEncapsulation;	/**< ReadWrite */
    char *    ATMAAL;	/**< ReadOnly */
    UINT32    ATMTransmittedBlocks;	/**< ReadOnly */
    UINT32    ATMReceivedBlocks;	/**< ReadOnly */
    char *    ATMQoS;	/**< ReadWrite */
    UINT32    ATMPeakCellRate;	/**< ReadWrite */
    UINT32    ATMMaximumBurstSize;	/**< ReadWrite */
    UINT32    ATMSustainableCellRate;	/**< ReadWrite */
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    SINT32    X_BROADCOM_COM_ATMMinimumCellRate;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UBOOL8    X_BROADCOM_COM_ATMEnbQos;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    char *    X_BROADCOM_COM_GrpScheduler;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_GrpWeight;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_GrpPrecedence;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    char *    X_BROADCOM_COM_SchedulerAlgorithm;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_QueueWeight;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_QueuePrecedence;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    char *    X_BROADCOM_COM_ATMStatus;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_ATMInterfaceId;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    char *    X_BROADCOM_COM_MacAddress;	/**< ReadOnly */
#endif
    UINT32    AAL5CRCErrors;	/**< ReadOnly */
    UINT32    ATMCRCErrors;	/**< ReadOnly */
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    char *    X_BROADCOM_COM_ConnectionMode;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    char *    X_BROADCOM_COM_IfName;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    char *    X_BROADCOM_COM_DropAlgorithm;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_LowClassMinThreshold;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_LowClassMaxThreshold;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_HighClassMinThreshold;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_ADSLWAN_1
    UINT32    X_BROADCOM_COM_HighClassMaxThreshold;	/**< ReadWrite */
#endif
} WanDslLinkCfgObject;

/*! \brief _WanDslLinkCfgObject is used internally to represent WanDslLinkCfgObject */
typedef WanDslLinkCfgObject _WanDslLinkCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.WANDevice.{i}.WANConnectionDevice.{i}.WANDSLLinkConfig.X_BROADCOM_COM_ATM_PARMS.
 *
 * MDMOID_WAN_DSL_ATM_PARAMS 113
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    ATMFreeCellQSize;	/**< ReadOnly */
    UINT32    ATMFreePacketQSize;	/**< ReadOnly */
    UINT32    ATMFreePacketQBufferSize;	/**< ReadOnly */
    UINT32    ATMFreePacketQBufferOffset;	/**< ReadOnly */
    UINT32    ATMReceiveCellQSize;	/**< ReadOnly */
    UINT32    ATMReceivePacketQSize;	/**< ReadOnly */
    UINT32    ATMTransmitFifoPriority;	/**< ReadOnly */
    UINT32    ATMAal5CpcsMaxSduLength;	/**< ReadOnly */
    UINT32    ATMAal2SscsMaxSsarSduLength;	/**< ReadOnly */
} WanDslAtmParamsObject;

/*! \brief _WanDslAtmParamsObject is used internally to represent WanDslAtmParamsObject */
typedef WanDslAtmParamsObject _WanDslAtmParamsObject;



/*! \brief Obj struct for InternetGatewayDevice.WANDevice.{i}.WANConnectionDevice.{i}.WANATMF5LoopbackDiagnostics.
 *
 * MDMOID_WAN_ATM5_LOOPBACK_DIAG 114
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    diagnosticsState;	/**< ReadWrite */
    UINT32    numberOfRepetitions;	/**< ReadWrite */
    UINT32    timeout;	/**< ReadWrite */
    UINT32    successCount;	/**< ReadOnly */
    UINT32    failureCount;	/**< ReadOnly */
    UINT32    averageResponseTime;	/**< ReadOnly */
    UINT32    minimumResponseTime;	/**< ReadOnly */
    UINT32    maximumResponseTime;	/**< ReadOnly */
} WanAtm5LoopbackDiagObject;

/*! \brief _WanAtm5LoopbackDiagObject is used internally to represent WanAtm5LoopbackDiagObject */
typedef WanAtm5LoopbackDiagObject _WanAtm5LoopbackDiagObject;



/*! \brief Obj struct for InternetGatewayDevice.WANDevice.{i}.WANConnectionDevice.{i}.WANPTMLinkConfig.
 *
 * MDMOID_WAN_PTM_LINK_CFG 115
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    linkStatus;	/**< ReadOnly */
#ifdef DMP_X_BROADCOM_COM_PTMWAN_1
    UINT32    X_BROADCOM_COM_PTMPortId;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_PTMWAN_1
    UBOOL8    X_BROADCOM_COM_PTMPriorityLow;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_PTMWAN_1
    UBOOL8    X_BROADCOM_COM_PTMPriorityHigh;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_PTMWAN_1
    UBOOL8    X_BROADCOM_COM_PTMEnbQos;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_PTMWAN_1
    char *    X_BROADCOM_COM_GrpScheduler;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_PTMWAN_1
    UINT32    X_BROADCOM_COM_GrpWeight;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_PTMWAN_1
    UINT32    X_BROADCOM_COM_GrpPrecedence;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_PTMWAN_1
    char *    X_BROADCOM_COM_SchedulerAlgorithm;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_PTMWAN_1
    UINT32    X_BROADCOM_COM_QueueWeight;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_PTMWAN_1
    UINT32    X_BROADCOM_COM_QueuePrecedence;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_PTMWAN_1
    char *    X_BROADCOM_COM_ConnectionMode;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_PTMWAN_1
    char *    X_BROADCOM_COM_IfName;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_PTMWAN_1
    char *    X_BROADCOM_COM_DropAlgorithm;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_PTMWAN_1
    UINT32    X_BROADCOM_COM_LowClassMinThreshold;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_PTMWAN_1
    UINT32    X_BROADCOM_COM_LowClassMaxThreshold;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_PTMWAN_1
    UINT32    X_BROADCOM_COM_HighClassMinThreshold;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_PTMWAN_1
    UINT32    X_BROADCOM_COM_HighClassMaxThreshold;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_PTMWAN_1
    SINT32    X_BROADCOM_COM_QueueMinimumRate;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_PTMWAN_1
    SINT32    X_BROADCOM_COM_QueueShapingRate;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_PTMWAN_1
    UINT32    X_BROADCOM_COM_QueueShapingBurstSize;	/**< ReadWrite */
#endif
} WanPtmLinkCfgObject;

/*! \brief _WanPtmLinkCfgObject is used internally to represent WanPtmLinkCfgObject */
typedef WanPtmLinkCfgObject _WanPtmLinkCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.WANDevice.{i}.WANConnectionDevice.{i}.WANEthernetLinkConfig.
 *
 * MDMOID_WAN_ETH_LINK_CFG 116
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    ethernetLinkStatus;	/**< ReadOnly */
} WanEthLinkCfgObject;

/*! \brief _WanEthLinkCfgObject is used internally to represent WanEthLinkCfgObject */
typedef WanEthLinkCfgObject _WanEthLinkCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.WANDevice.{i}.WANConnectionDevice.{i}.X_BROADCOM_COM_WANWifiLinkConfig.
 *
 * MDMOID_WAN_WIFI_LINK_CFG 117
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    wlanLinkStatus;	/**< ReadOnly */
} WanWifiLinkCfgObject;

/*! \brief _WanWifiLinkCfgObject is used internally to represent WanWifiLinkCfgObject */
typedef WanWifiLinkCfgObject _WanWifiLinkCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.WANDevice.{i}.WANConnectionDevice.{i}.X_BROADCOM_COM_WANCellularLinkConfig.
 *
 * MDMOID_WAN_CELLULAR_LINK_CFG 118
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    cellularAPN;	/**< ReadWrite */
} WanCellularLinkCfgObject;

/*! \brief _WanCellularLinkCfgObject is used internally to represent WanCellularLinkCfgObject */
typedef WanCellularLinkCfgObject _WanCellularLinkCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.WANDevice.{i}.WANConnectionDevice.{i}.X_BROADCOM_COM_L2tpAcLinkConfig.
 *
 * MDMOID_L2TP_AC_LINK_CONFIG 119
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    sessionName;	/**< ReadWrite */
    char *    connectionMode;	/**< ReadWrite */
    char *    linkStatus;	/**< ReadOnly */
    UINT32    sessionId;	/**< ReadOnly */
    char *    ifName;	/**< ReadWrite */
    char *    tunnelName;	/**< ReadWrite */
} L2tpAcLinkConfigObject;

/*! \brief _L2tpAcLinkConfigObject is used internally to represent L2tpAcLinkConfigObject */
typedef L2tpAcLinkConfigObject _L2tpAcLinkConfigObject;



/*! \brief Obj struct for InternetGatewayDevice.WANDevice.{i}.WANConnectionDevice.{i}.WANIPConnection.{i}.
 *
 * MDMOID_WAN_IP_CONN 121
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    connectionStatus;	/**< ReadOnly */
    char *    possibleConnectionTypes;	/**< ReadOnly */
    char *    connectionType;	/**< ReadWrite */
    char *    name;	/**< ReadWrite */
    UINT32    uptime;	/**< ReadOnly */
    char *    lastConnectionError;	/**< ReadOnly */
    UBOOL8    NATEnabled;	/**< ReadWrite */
    UBOOL8    X_BROADCOM_COM_FullconeNATEnabled;	/**< ReadWrite */
    char *    addressingType;	/**< ReadWrite */
    char *    externalIPAddress;	/**< ReadWrite */
    char *    subnetMask;	/**< ReadWrite */
    char *    defaultGateway;	/**< ReadWrite */
    UBOOL8    X_BROADCOM_COM_FirewallEnabled;	/**< ReadWrite */
#ifdef DMP_X_BROADCOM_COM_IGMP_1
    UBOOL8    X_BROADCOM_COM_IGMPEnabled;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_IGMP_1
    UBOOL8    X_BROADCOM_COM_IGMP_SOURCEEnabled;	/**< ReadWrite */
#endif
    UBOOL8    DNSEnabled;	/**< ReadWrite */
    char *    DNSServers;	/**< ReadWrite */
    UINT32    maxMTUSize;	/**< ReadWrite */
    MACADDRESS  MACAddress;	/**< ReadWrite */
    UBOOL8    MACAddressOverride;	/**< ReadWrite */
    char *    routeProtocolRx;	/**< ReadWrite */
    char *    X_BROADCOM_COM_RipOperationMode;	/**< ReadWrite */
    char *    X_BROADCOM_COM_RipDebugMode;	/**< ReadWrite */
    char *    X_BROADCOM_COM_IfName;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_ConnectionId;	/**< ReadWrite */
    UINT32    X_BROADCOM_COM_DhcpcPid;	/**< ReadOnly */
    SINT32    X_BROADCOM_COM_VlanMux8021p;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_VlanMuxID;	/**< ReadWrite */
    UINT32    X_BROADCOM_COM_VlanTpid;	/**< ReadWrite */
    UINT32    portMappingNumberOfEntries;	/**< ReadOnly */
    char *    X_BROADCOM_COM_Op60VenderID;	/**< ReadWrite */
    char *    X_BROADCOM_COM_Op61DUID;	/**< ReadWrite */
    char *    X_BROADCOM_COM_Op61IAID;	/**< ReadWrite */
    char *    X_BROADCOM_COM_Op77UserID;	/**< ReadWrite */
    UBOOL8    X_BROADCOM_COM_Op125Enabled;	/**< ReadWrite */
    char *    X_BROADCOM_COM_Op50IpAddress;	/**< ReadWrite */
    UINT32    X_BROADCOM_COM_Op51LeasedTime;	/**< ReadWrite */
    char *    X_BROADCOM_COM_Op54ServerIpAddress;	/**< ReadWrite */
    UBOOL8    X_BROADCOM_COM_IPv6Enabled;	/**< ReadWrite */
    UBOOL8    X_BROADCOM_COM_IPv4Enabled;	/**< ReadWrite */
    UINT32    X_BROADCOM_COM_PCPMode;	/**< ReadWrite */
    char *    X_BROADCOM_COM_PCPServer;	/**< ReadWrite */
#ifdef DMP_X_BROADCOM_COM_IPV6_1
    UBOOL8    X_BROADCOM_COM_UnnumberedModel;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_IPV6_1
    char *    X_BROADCOM_COM_IPv6ConnStatus;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_IPV6_1
    char *    X_BROADCOM_COM_IPv6AddressingType;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_IPV6_1
    UBOOL8    X_BROADCOM_COM_Dhcp6cForAddress;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_IPV6_1
    UBOOL8    X_BROADCOM_COM_Dhcp6cForPrefixDelegation;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_IPV6_1
    UBOOL8    X_BROADCOM_COM_Dhcp6cForNPTv6Prefix;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_IPV6_1
    char *    X_BROADCOM_COM_ExternalIPv6Address;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_IPV6_1
    char *    X_BROADCOM_COM_DefaultIPv6Gateway;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_IPV6_1
    UBOOL8    X_BROADCOM_COM_MFlag;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_IPV6_1
    UBOOL8    X_BROADCOM_COM_OFlag;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_IPV6_1
    char *    X_BROADCOM_COM_IPv6DNSServers;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_IPV6_1
    char *    X_BROADCOM_COM_IPv6DomainName;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_IPV6_1
    UBOOL8    X_BROADCOM_COM_IPv6PrefixDelegationEnabled;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_IPV6_1
    char *    X_BROADCOM_COM_IPv6SitePrefix;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_IPV6_1
    SINT32    X_BROADCOM_COM_IPv6SitePrefixPltime;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_IPV6_1
    SINT32    X_BROADCOM_COM_IPv6SitePrefixVltime;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_IPV6_1
    char *    X_BROADCOM_COM_IPv6SitePrefixOld;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_IPV6_1
    SINT32    X_BROADCOM_COM_IPv6SitePrefixVltimeOld;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_IPV6_1
    UBOOL8    X_BROADCOM_COM_AFlag;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_IPV6_1
    UBOOL8    X_BROADCOM_COM_LFlag;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_IPV6_1
    char *    X_BROADCOM_COM_IPv6RaPrefix;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_IPV6_1
    UINT32    X_BROADCOM_COM_Dhcp6cPid;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_MLD_1
    UBOOL8    X_BROADCOM_COM_MLDEnabled;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_MLD_1
    UBOOL8    X_BROADCOM_COM_MLD_SOURCEEnabled;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_AUTODETECTION_1
    UBOOL8    X_BROADCOM_COM_LastConnected;	/**< ReadWrite */
#endif
    char *    X_BROADCOM_COM_TransientLayer2LinkStatus;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_ConnectionEstablishedTime;	/**< ReadOnly */
} WanIpConnObject;

/*! \brief _WanIpConnObject is used internally to represent WanIpConnObject */
typedef WanIpConnObject _WanIpConnObject;



/*! \brief Obj struct for InternetGatewayDevice.WANDevice.{i}.WANConnectionDevice.{i}.WANIPConnection.{i}.PortMapping.{i}.
 *
 * MDMOID_WAN_IP_CONN_PORTMAPPING 122
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    portMappingEnabled;	/**< ReadWrite */
    UINT32    portMappingLeaseDuration;	/**< ReadWrite */
    UINT32    X_BROADCOM_COM_ExpiryTime;	/**< ReadWrite */
    char *    remoteHost;	/**< ReadWrite */
    UINT32    externalPort;	/**< ReadWrite */
    UINT32    X_BROADCOM_COM_ExternalPortEnd;	/**< ReadWrite */
    UINT32    internalPort;	/**< ReadWrite */
    UINT32    X_BROADCOM_COM_InternalPortEnd;	/**< ReadWrite */
    char *    portMappingProtocol;	/**< ReadWrite */
    char *    internalClient;	/**< ReadWrite */
    char *    portMappingDescription;	/**< ReadWrite */
    char *    X_BROADCOM_COM_AppName;	/**< ReadWrite */
} WanIpConnPortmappingObject;

/*! \brief _WanIpConnPortmappingObject is used internally to represent WanIpConnPortmappingObject */
typedef WanIpConnPortmappingObject _WanIpConnPortmappingObject;



/*! \brief Obj struct for InternetGatewayDevice.WANDevice.{i}.WANConnectionDevice.{i}.WANIPConnection.{i}.X_BROADCOM_COM_PortTriggering.{i}.
 *
 * MDMOID_WAN_IP_CONN_PORT_TRIGGERING 123
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    name;	/**< ReadWrite */
    char *    triggerProtocol;	/**< ReadWrite */
    char *    openProtocol;	/**< ReadWrite */
    UINT32    triggerPortStart;	/**< ReadWrite */
    UINT32    triggerPortEnd;	/**< ReadWrite */
    UINT32    openPortStart;	/**< ReadWrite */
    UINT32    openPortEnd;	/**< ReadWrite */
} WanIpConnPortTriggeringObject;

/*! \brief _WanIpConnPortTriggeringObject is used internally to represent WanIpConnPortTriggeringObject */
typedef WanIpConnPortTriggeringObject _WanIpConnPortTriggeringObject;



/*! \brief Obj struct for InternetGatewayDevice.WANDevice.{i}.WANConnectionDevice.{i}.WANIPConnection.{i}.X_BROADCOM_COM_FirewallException.{i}.
 *
 * MDMOID_WAN_IP_CONN_FIREWALL_EXCEPTION 124
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    filterName;	/**< ReadWrite */
    char *    IPVersion;	/**< ReadWrite */
    char *    protocol;	/**< ReadWrite */
    UINT32    sourcePortStart;	/**< ReadWrite */
    UINT32    sourcePortEnd;	/**< ReadWrite */
    UINT32    destinationPortStart;	/**< ReadWrite */
    UINT32    destinationPortEnd;	/**< ReadWrite */
    char *    sourceIPAddress;	/**< ReadWrite */
    char *    sourceNetMask;	/**< ReadWrite */
    char *    destinationIPAddress;	/**< ReadWrite */
    char *    destinationNetMask;	/**< ReadWrite */
} WanIpConnFirewallExceptionObject;

/*! \brief _WanIpConnFirewallExceptionObject is used internally to represent WanIpConnFirewallExceptionObject */
typedef WanIpConnFirewallExceptionObject _WanIpConnFirewallExceptionObject;



/*! \brief Obj struct for InternetGatewayDevice.WANDevice.{i}.WANConnectionDevice.{i}.WANIPConnection.{i}.X_BROADCOM_COM_MacFilterObj.
 *
 * MDMOID_MAC_FILTER 125
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    policy;	/**< ReadWrite */
} MacFilterObject;

/*! \brief _MacFilterObject is used internally to represent MacFilterObject */
typedef MacFilterObject _MacFilterObject;



/*! \brief Obj struct for InternetGatewayDevice.WANDevice.{i}.WANConnectionDevice.{i}.WANIPConnection.{i}.X_BROADCOM_COM_MacFilterObj.X_BROADCOM_COM_MacFilterCfg.{i}.
 *
 * MDMOID_MAC_FILTER_CFG 126
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    protocol;	/**< ReadWrite */
    char *    direction;	/**< ReadWrite */
    char *    sourceMAC;	/**< ReadWrite */
    char *    destinationMAC;	/**< ReadWrite */
} MacFilterCfgObject;

/*! \brief _MacFilterCfgObject is used internally to represent MacFilterCfgObject */
typedef MacFilterCfgObject _MacFilterCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.WANDevice.{i}.WANConnectionDevice.{i}.WANIPConnection.{i}.Stats.
 *
 * MDMOID_WAN_IP_CONN_STATS 127
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    X_BROADCOM_COM_RxDrops;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_TxDrops;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_RxErrors;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_TxErrors;	/**< ReadOnly */
    UINT32    ethernetBytesSent;	/**< ReadOnly */
    UINT32    ethernetBytesReceived;	/**< ReadOnly */
    UINT32    ethernetPacketsSent;	/**< ReadOnly */
    UINT32    ethernetPacketsReceived;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_MulticastPacketsSent;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_MulticastPacketsReceived;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_MulticastBytesSent;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_MulticastBytesReceived;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_UnicastPacketsSent;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_UnicastPacketsReceived;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_BroadcastPacketsSent;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_BroadcastPacketsReceived;	/**< ReadOnly */
} WanIpConnStatsObject;

/*! \brief _WanIpConnStatsObject is used internally to represent WanIpConnStatsObject */
typedef WanIpConnStatsObject _WanIpConnStatsObject;



/*! \brief Obj struct for InternetGatewayDevice.WANDevice.{i}.WANConnectionDevice.{i}.WANPPPConnection.{i}.
 *
 * MDMOID_WAN_PPP_CONN 128
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    connectionStatus;	/**< ReadOnly */
    char *    possibleConnectionTypes;	/**< ReadOnly */
    char *    connectionType;	/**< ReadWrite */
    char *    name;	/**< ReadWrite */
    UINT32    uptime;	/**< ReadOnly */
    char *    lastConnectionError;	/**< ReadOnly */
    UINT32    idleDisconnectTime;	/**< ReadWrite */
    UBOOL8    RSIPAvailable;	/**< ReadOnly */
    UBOOL8    NATEnabled;	/**< ReadWrite */
    UBOOL8    X_BROADCOM_COM_FullconeNATEnabled;	/**< ReadWrite */
    UBOOL8    X_BROADCOM_COM_FirewallEnabled;	/**< ReadWrite */
#ifdef DMP_X_BROADCOM_COM_IGMP_1
    UBOOL8    X_BROADCOM_COM_IGMPEnabled;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_IGMP_1
    UBOOL8    X_BROADCOM_COM_IGMP_SOURCEEnabled;	/**< ReadWrite */
#endif
    char *    username;	/**< ReadWrite */
    char *    password;	/**< ReadWrite */
    char *    PPPEncryptionProtocol;	/**< ReadOnly */
    char *    PPPCompressionProtocol;	/**< ReadOnly */
    char *    PPPAuthenticationProtocol;	/**< ReadWrite */
    UINT32    X_BROADCOM_COM_ConnectionEstablishedTime;	/**< ReadOnly */
    UBOOL8    X_BROADCOM_COM_IPExtension;	/**< ReadWrite */
    UBOOL8    X_BROADCOM_COM_UseStaticIPAddress;	/**< ReadWrite */
    char *    X_BROADCOM_COM_LocalIPAddress;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_ConnectionId;	/**< ReadWrite */
    UINT32    X_BROADCOM_COM_PppdPid;	/**< ReadOnly */
    char *    X_BROADCOM_COM_IfName;	/**< ReadWrite */
    char *    X_BROADCOM_COM_DefaultGateway;	/**< ReadOnly */
    UBOOL8    X_BROADCOM_COM_Enable_Debug;	/**< ReadWrite */
    UBOOL8    X_BROADCOM_COM_AddPppToBridge;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_VlanMux8021p;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_VlanMuxID;	/**< ReadWrite */
    UINT32    X_BROADCOM_COM_VlanTpid;	/**< ReadWrite */
    char *    X_BROADCOM_COM_UserRequest;	/**< ReadOnly */
    IPADDRESS  externalIPAddress;	/**< ReadOnly */
    IPADDRESS  remoteIPAddress;	/**< ReadOnly */
    UINT32    currentMRUSize;	/**< ReadOnly */
    UBOOL8    DNSEnabled;	/**< ReadWrite */
    UBOOL8    DNSOverrideAllowed;	/**< ReadWrite */
    char *    DNSServers;	/**< ReadWrite */
    MACADDRESS  MACAddress;	/**< ReadWrite */
    UBOOL8    MACAddressOverride;	/**< ReadWrite */
    char *    transportType;	/**< ReadOnly */
    char *    PPPoEServiceName;	/**< ReadWrite */
    char *    connectionTrigger;	/**< ReadWrite */
    char *    routeProtocolRx;	/**< ReadWrite */
    UINT32    PPPLCPEcho;	/**< ReadOnly */
    UINT32    PPPLCPEchoRetry;	/**< ReadOnly */
    UINT32    portMappingNumberOfEntries;	/**< ReadOnly */
    UBOOL8    X_BROADCOM_COM_IPv6Enabled;	/**< ReadWrite */
    UBOOL8    X_BROADCOM_COM_IPv4Enabled;	/**< ReadWrite */
    UINT32    X_BROADCOM_COM_PCPMode;	/**< ReadWrite */
    char *    X_BROADCOM_COM_PCPServer;	/**< ReadWrite */
#ifdef DMP_X_BROADCOM_COM_IPV6_1
    UBOOL8    X_BROADCOM_COM_UnnumberedModel;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_IPV6_1
    char *    X_BROADCOM_COM_IPv6ConnStatus;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_IPV6_1
    UBOOL8    X_BROADCOM_COM_IPv6PppUp;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_IPV6_1
    char *    X_BROADCOM_COM_IPv6AddressingType;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_IPV6_1
    UBOOL8    X_BROADCOM_COM_Dhcp6cForAddress;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_IPV6_1
    UBOOL8    X_BROADCOM_COM_Dhcp6cForPrefixDelegation;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_IPV6_1
    UBOOL8    X_BROADCOM_COM_Dhcp6cForNPTv6Prefix;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_IPV6_1
    char *    X_BROADCOM_COM_ExternalIPv6Address;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_IPV6_1
    char *    X_BROADCOM_COM_DefaultIPv6Gateway;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_IPV6_1
    UBOOL8    X_BROADCOM_COM_MFlag;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_IPV6_1
    UBOOL8    X_BROADCOM_COM_OFlag;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_IPV6_1
    char *    X_BROADCOM_COM_IPv6DNSServers;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_IPV6_1
    char *    X_BROADCOM_COM_IPv6DomainName;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_IPV6_1
    UBOOL8    X_BROADCOM_COM_IPv6PrefixDelegationEnabled;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_IPV6_1
    char *    X_BROADCOM_COM_IPv6SitePrefix;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_IPV6_1
    SINT32    X_BROADCOM_COM_IPv6SitePrefixPltime;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_IPV6_1
    SINT32    X_BROADCOM_COM_IPv6SitePrefixVltime;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_IPV6_1
    char *    X_BROADCOM_COM_IPv6SitePrefixOld;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_IPV6_1
    SINT32    X_BROADCOM_COM_IPv6SitePrefixVltimeOld;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_IPV6_1
    UBOOL8    X_BROADCOM_COM_AFlag;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_IPV6_1
    UBOOL8    X_BROADCOM_COM_LFlag;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_IPV6_1
    char *    X_BROADCOM_COM_IPv6RaPrefix;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_IPV6_1
    UINT32    X_BROADCOM_COM_Dhcp6cPid;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_MLD_1
    UBOOL8    X_BROADCOM_COM_MLDEnabled;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_MLD_1
    UBOOL8    X_BROADCOM_COM_MLD_SOURCEEnabled;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_AUTODETECTION_1
    UBOOL8    X_BROADCOM_COM_LastConnected;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_AUTODETECTION_1
    UBOOL8    X_BROADCOM_COM_StopPppD;	/**< ReadOnly */
#endif
    char *    X_BROADCOM_COM_TransientLayer2LinkStatus;	/**< ReadOnly */
} WanPppConnObject;

/*! \brief _WanPppConnObject is used internally to represent WanPppConnObject */
typedef WanPppConnObject _WanPppConnObject;



/*! \brief Obj struct for InternetGatewayDevice.WANDevice.{i}.WANConnectionDevice.{i}.WANPPPConnection.{i}.PortMapping.{i}.
 *
 * MDMOID_WAN_PPP_CONN_PORTMAPPING 129
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    portMappingEnabled;	/**< ReadWrite */
    UINT32    portMappingLeaseDuration;	/**< ReadWrite */
    UINT32    X_BROADCOM_COM_ExpiryTime;	/**< ReadWrite */
    char *    remoteHost;	/**< ReadWrite */
    UINT32    externalPort;	/**< ReadWrite */
    UINT32    X_BROADCOM_COM_ExternalPortEnd;	/**< ReadWrite */
    UINT32    internalPort;	/**< ReadWrite */
    UINT32    X_BROADCOM_COM_InternalPortEnd;	/**< ReadWrite */
    char *    portMappingProtocol;	/**< ReadWrite */
    char *    internalClient;	/**< ReadWrite */
    char *    portMappingDescription;	/**< ReadWrite */
    char *    X_BROADCOM_COM_AppName;	/**< ReadWrite */
} WanPppConnPortmappingObject;

/*! \brief _WanPppConnPortmappingObject is used internally to represent WanPppConnPortmappingObject */
typedef WanPppConnPortmappingObject _WanPppConnPortmappingObject;



/*! \brief Obj struct for InternetGatewayDevice.WANDevice.{i}.WANConnectionDevice.{i}.WANPPPConnection.{i}.X_BROADCOM_COM_PortTriggering.{i}.
 *
 * MDMOID_WAN_PPP_CONN_PORT_TRIGGERING 130
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    name;	/**< ReadWrite */
    char *    triggerProtocol;	/**< ReadWrite */
    char *    openProtocol;	/**< ReadWrite */
    UINT32    triggerPortStart;	/**< ReadWrite */
    UINT32    triggerPortEnd;	/**< ReadWrite */
    UINT32    openPortStart;	/**< ReadWrite */
    UINT32    openPortEnd;	/**< ReadWrite */
} WanPppConnPortTriggeringObject;

/*! \brief _WanPppConnPortTriggeringObject is used internally to represent WanPppConnPortTriggeringObject */
typedef WanPppConnPortTriggeringObject _WanPppConnPortTriggeringObject;



/*! \brief Obj struct for InternetGatewayDevice.WANDevice.{i}.WANConnectionDevice.{i}.WANPPPConnection.{i}.X_BROADCOM_COM_FirewallException.{i}.
 *
 * MDMOID_WAN_PPP_CONN_FIREWALL_EXCEPTION 131
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    filterName;	/**< ReadWrite */
    char *    IPVersion;	/**< ReadWrite */
    char *    protocol;	/**< ReadWrite */
    UINT32    sourcePortStart;	/**< ReadWrite */
    UINT32    sourcePortEnd;	/**< ReadWrite */
    UINT32    destinationPortStart;	/**< ReadWrite */
    UINT32    destinationPortEnd;	/**< ReadWrite */
    char *    sourceIPAddress;	/**< ReadWrite */
    char *    sourceNetMask;	/**< ReadWrite */
    char *    destinationIPAddress;	/**< ReadWrite */
    char *    destinationNetMask;	/**< ReadWrite */
} WanPppConnFirewallExceptionObject;

/*! \brief _WanPppConnFirewallExceptionObject is used internally to represent WanPppConnFirewallExceptionObject */
typedef WanPppConnFirewallExceptionObject _WanPppConnFirewallExceptionObject;



/*! \brief Obj struct for InternetGatewayDevice.WANDevice.{i}.WANConnectionDevice.{i}.WANPPPConnection.{i}.Stats.
 *
 * MDMOID_WAN_PPP_CONN_STATS 132
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    X_BROADCOM_COM_RxDrops;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_TxDrops;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_RxErrors;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_TxErrors;	/**< ReadOnly */
    UINT32    ethernetBytesSent;	/**< ReadOnly */
    UINT32    ethernetBytesReceived;	/**< ReadOnly */
    UINT32    ethernetPacketsSent;	/**< ReadOnly */
    UINT32    ethernetPacketsReceived;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_MulticastPacketsSent;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_MulticastPacketsReceived;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_MulticastBytesSent;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_MulticastBytesReceived;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_UnicastPacketsSent;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_UnicastPacketsReceived;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_BroadcastPacketsSent;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_BroadcastPacketsReceived;	/**< ReadOnly */
} WanPppConnStatsObject;

/*! \brief _WanPppConnStatsObject is used internally to represent WanPppConnStatsObject */
typedef WanPppConnStatsObject _WanPppConnStatsObject;



/*! \brief Obj struct for InternetGatewayDevice.Layer3Forwarding.
 *
 * MDMOID_L3_FORWARDING 133
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    defaultConnectionService;	/**< ReadWrite */
    UINT32    forwardNumberOfEntries;	/**< ReadOnly */
    char *    X_BROADCOM_COM_DefaultConnectionServices;	/**< ReadWrite */
    char *    X_BROADCOM_COM_ActiveDefaultGateway;	/**< ReadOnly */
} L3ForwardingObject;

/*! \brief _L3ForwardingObject is used internally to represent L3ForwardingObject */
typedef L3ForwardingObject _L3ForwardingObject;



/*! \brief Obj struct for InternetGatewayDevice.Layer3Forwarding.Forwarding.{i}.
 *
 * MDMOID_L3_FORWARDING_ENTRY 134
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    status;	/**< ReadOnly */
    char *    type;	/**< ReadWrite */
    char *    X_BROADCOM_COM_PolicyRoutingName;	/**< ReadWrite */
    IPADDRESS  destIPAddress;	/**< ReadWrite */
    IPADDRESS  destSubnetMask;	/**< ReadWrite */
    IPADDRESS  sourceIPAddress;	/**< ReadWrite */
    IPADDRESS  sourceSubnetMask;	/**< ReadWrite */
    char *    X_BROADCOM_COM_SourceIfName;	/**< ReadWrite */
#ifdef DMP_QOS_1
    SINT32    forwardingPolicy;	/**< ReadWrite */
#endif
    IPADDRESS  gatewayIPAddress;	/**< ReadWrite */
    char *    interface;	/**< ReadWrite */
    SINT32    forwardingMetric;	/**< ReadWrite */
    UINT32    MTU;	/**< ReadWrite */
} L3ForwardingEntryObject;

/*! \brief _L3ForwardingEntryObject is used internally to represent L3ForwardingEntryObject */
typedef L3ForwardingEntryObject _L3ForwardingEntryObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_IPv6Layer3Forwarding.
 *
 * MDMOID_I_PV6_L3_FORWARDING 135
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    defaultConnectionService;	/**< ReadWrite */
    UINT32    forwardNumberOfEntries;	/**< ReadOnly */
} IPv6L3ForwardingObject;

/*! \brief _IPv6L3ForwardingObject is used internally to represent IPv6L3ForwardingObject */
typedef IPv6L3ForwardingObject _IPv6L3ForwardingObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_IPv6Layer3Forwarding.IPv6Forwarding.{i}.
 *
 * MDMOID_I_PV6_L3_FORWARDING_ENTRY 136
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    status;	/**< ReadOnly */
    char *    type;	/**< ReadWrite */
    char *    policyRoutingName;	/**< ReadWrite */
    char *    destIPv6Address;	/**< ReadWrite */
    char *    sourceIPv6Address;	/**< ReadWrite */
    char *    sourceIfName;	/**< ReadWrite */
    SINT32    forwardingPolicy;	/**< ReadWrite */
    char *    gatewayIPv6Address;	/**< ReadWrite */
    char *    interface;	/**< ReadWrite */
    SINT32    forwardingMetric;	/**< ReadWrite */
    UINT32    MTU;	/**< ReadWrite */
} IPv6L3ForwardingEntryObject;

/*! \brief _IPv6L3ForwardingEntryObject is used internally to represent IPv6L3ForwardingEntryObject */
typedef IPv6L3ForwardingEntryObject _IPv6L3ForwardingEntryObject;



/*! \brief Obj struct for InternetGatewayDevice.Services.
 *
 * MDMOID_SERVICES 137
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
} ServicesObject;

/*! \brief _ServicesObject is used internally to represent ServicesObject */
typedef ServicesObject _ServicesObject;



/*! \brief Obj struct for InternetGatewayDevice.Services.StorageService.{i}.
 *
 * MDMOID_STORAGE_SERVICE 800
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    UINT32    physicalMediumNumberOfEntries;	/**< ReadOnly */
    UINT32    logicalVolumeNumberOfEntries;	/**< ReadOnly */
    UINT32    userAccountNumberOfEntries;	/**< ReadWrite */
} StorageServiceObject;

/*! \brief _StorageServiceObject is used internally to represent StorageServiceObject */
typedef StorageServiceObject _StorageServiceObject;



/*! \brief Obj struct for InternetGatewayDevice.Services.StorageService.{i}.UserAccount.{i}.
 *
 * MDMOID_USER_ACCOUNT 801
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    username;	/**< ReadWrite */
    char *    password;	/**< ReadWrite */
    char *    X_BROADCOM_volumeName;	/**< ReadWrite */
} UserAccountObject;

/*! \brief _UserAccountObject is used internally to represent UserAccountObject */
typedef UserAccountObject _UserAccountObject;



/*! \brief Obj struct for InternetGatewayDevice.Services.StorageService.{i}.Capabilites.
 *
 * MDMOID_CAPABILITES 802
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    FTPCapable;	/**< ReadOnly */
    UBOOL8    SFTPCapable;	/**< ReadOnly */
    UBOOL8    HTTPCapable;	/**< ReadOnly */
    UBOOL8    HTTPSCapable;	/**< ReadOnly */
    UBOOL8    HTTPWritable;	/**< ReadOnly */
    char *    supportedNetworkProtocols;	/**< ReadOnly */
    char *    supportedFileSystemTypes;	/**< ReadOnly */
    UBOOL8    volumeEncryptionCapable;	/**< ReadOnly */
} CapabilitesObject;

/*! \brief _CapabilitesObject is used internally to represent CapabilitesObject */
typedef CapabilitesObject _CapabilitesObject;



/*! \brief Obj struct for InternetGatewayDevice.Services.StorageService.{i}.NetInfo.
 *
 * MDMOID_NETWORK_INFO 803
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    hostName;	/**< ReadWrite */
    char *    domainName;	/**< ReadWrite */
} NetworkInfoObject;

/*! \brief _NetworkInfoObject is used internally to represent NetworkInfoObject */
typedef NetworkInfoObject _NetworkInfoObject;



/*! \brief Obj struct for InternetGatewayDevice.Services.StorageService.{i}.NetworkServer.
 *
 * MDMOID_NETWORK_SERVER 804
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    AFPEnable;	/**< ReadOnly */
    UBOOL8    NFSEnable;	/**< ReadOnly */
    UBOOL8    SMBEnable;	/**< ReadOnly */
    UBOOL8    networkProtocolAuthReq;	/**< ReadOnly */
} NetworkServerObject;

/*! \brief _NetworkServerObject is used internally to represent NetworkServerObject */
typedef NetworkServerObject _NetworkServerObject;



/*! \brief Obj struct for InternetGatewayDevice.Services.StorageService.{i}.PhysicalMedium.{i}.
 *
 * MDMOID_PHYSICAL_MEDIUM 805
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    name;	/**< ReadOnly */
    char *    connectionType;	/**< ReadOnly */
    UBOOL8    removable;	/**< ReadOnly */
    UINT32    capacity;	/**< ReadOnly */
    char *    status;	/**< ReadOnly */
} PhysicalMediumObject;

/*! \brief _PhysicalMediumObject is used internally to represent PhysicalMediumObject */
typedef PhysicalMediumObject _PhysicalMediumObject;



/*! \brief Obj struct for InternetGatewayDevice.Services.StorageService.{i}.LogicalVolume.{i}.
 *
 * MDMOID_LOGICAL_VOLUME 806
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    name;	/**< ReadOnly */
    char *    status;	/**< ReadOnly */
    UBOOL8    enable;	/**< ReadOnly */
    char *    physicalReference;	/**< ReadOnly */
    char *    fileSystem;	/**< ReadOnly */
    UINT32    capacity;	/**< ReadOnly */
    UINT32    usedSpace;	/**< ReadOnly */
    UBOOL8    encrypted;	/**< ReadOnly */
    UINT32    folderNumberOfEntries;	/**< ReadOnly */
} LogicalVolumeObject;

/*! \brief _LogicalVolumeObject is used internally to represent LogicalVolumeObject */
typedef LogicalVolumeObject _LogicalVolumeObject;



/*! \brief Obj struct for InternetGatewayDevice.Services.StorageService.{i}.LogicalVolume.{i}.Folder.{i}.
 *
 * MDMOID_FOLDER 807
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    name;	/**< ReadOnly */
    UBOOL8    enable;	/**< ReadOnly */
    UINT32    userAccountAccess;	/**< ReadOnly */
} FolderObject;

/*! \brief _FolderObject is used internally to represent FolderObject */
typedef FolderObject _FolderObject;



/*! \brief Obj struct for InternetGatewayDevice.Services.VoiceService.{i}.
 *
 * MDMOID_VOICE 500
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    voiceProfileNumberOfEntries;	/**< ReadOnly */
    char *    X_BROADCOM_COM_BoundIfName;	/**< ReadWrite */
    char *    X_BROADCOM_COM_BoundIpAddr;	/**< ReadOnly */
    char *    X_BROADCOM_COM_IpAddressFamily;	/**< ReadWrite */
    UBOOL8    X_BROADCOM_COM_VoiceDnsEnable;	/**< ReadWrite */
    char *    X_BROADCOM_COM_VoiceDnsServerPri;	/**< ReadWrite */
    char *    X_BROADCOM_COM_VoiceDnsServerSec;	/**< ReadWrite */
    UBOOL8    X_BROADCOM_COM_UseSipStackDnsResolver;	/**< ReadWrite */
    char *    X_BROADCOM_COM_LoggingLevel;	/**< ReadWrite */
    char *    X_BROADCOM_COM_LoggingDestination;	/**< ReadWrite */
    char *    X_BROADCOM_COM_ModuleLogLevels;	/**< ReadWrite */
    char *    X_BROADCOM_COM_CCTKTraceLevel;	/**< ReadWrite */
    char *    X_BROADCOM_COM_CCTKTraceGroup;	/**< ReadWrite */
#ifdef DMP_X_BROADCOM_COM_DECTENDPOINT_1
    char *    X_BROADCOM_COM_DectEepromData;	/**< ReadWrite */
#endif
    char *    X_BROADCOM_COM_ManagementProtocol;	/**< ReadWrite */
    char *    X_BROADCOM_COM_VoiceAppState;	/**< ReadWrite */
} VoiceObject;

/*! \brief _VoiceObject is used internally to represent VoiceObject */
typedef VoiceObject _VoiceObject;



/*! \brief Obj struct for InternetGatewayDevice.Services.VoiceService.{i}.X_BROADCOM_COM_VoiceMsgReq.
 *
 * MDMOID_VOICE_MSG_REQ 501
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    X_BROADCOM_COM_MsgType;	/**< ReadWrite */
    UBOOL8    X_BROADCOM_COM_OmciMibReset;	/**< ReadWrite */
    UBOOL8    X_BROADCOM_COM_OmciCfgUpldComplete;	/**< ReadWrite */
    UINT32    X_BROADCOM_COM_DectMsgType;	/**< ReadWrite */
    char *    X_BROADCOM_COM_MsgData;	/**< ReadWrite */
} VoiceMsgReqObject;

/*! \brief _VoiceMsgReqObject is used internally to represent VoiceMsgReqObject */
typedef VoiceMsgReqObject _VoiceMsgReqObject;



/*! \brief Obj struct for InternetGatewayDevice.Services.VoiceService.{i}.X_BROADCOM_COM_SysAccess.
 *
 * MDMOID_VOICE_SYS_ACCESS 502
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    X_BROADCOM_COM_IfName;	/**< ReadWrite */
    UBOOL8    X_BROADCOM_COM_IsPhyUp;	/**< ReadWrite */
    UBOOL8    X_BROADCOM_COM_IsIpv4Up;	/**< ReadWrite */
    char *    X_BROADCOM_COM_Ipv4Addr;	/**< ReadWrite */
    char *    X_BROADCOM_COM_Ipv4DnsServers;	/**< ReadWrite */
    UBOOL8    X_BROADCOM_COM_IsIpv6Up;	/**< ReadWrite */
    char *    X_BROADCOM_COM_Ipv6Addr;	/**< ReadWrite */
    char *    X_BROADCOM_COM_Ipv6DnsServers;	/**< ReadWrite */
    char *    X_BROADCOM_COM_LocalSipCertPrivKey;	/**< ReadWrite */
    char *    X_BROADCOM_COM_LocalSipCertContents;	/**< ReadWrite */
    char *    X_BROADCOM_COM_TrustedCaSipCertContents;	/**< ReadWrite */
} VoiceSysAccessObject;

/*! \brief _VoiceSysAccessObject is used internally to represent VoiceSysAccessObject */
typedef VoiceSysAccessObject _VoiceSysAccessObject;



/*! \brief Obj struct for InternetGatewayDevice.Services.VoiceService.{i}.X_BROADCOM_COM_Call.{i}.
 *
 * MDMOID_VOICE_CALL_LIST 503
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
} VoiceCallListObject;

/*! \brief _VoiceCallListObject is used internally to represent VoiceCallListObject */
typedef VoiceCallListObject _VoiceCallListObject;



/*! \brief Obj struct for InternetGatewayDevice.Services.VoiceService.{i}.X_BROADCOM_COM_Call.{i}.NewFlag.
 *
 * MDMOID_VOICE_CALL_NEW_FLAG 504
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    element;	/**< ReadWrite */
} VoiceCallNewFlagObject;

/*! \brief _VoiceCallNewFlagObject is used internally to represent VoiceCallNewFlagObject */
typedef VoiceCallNewFlagObject _VoiceCallNewFlagObject;



/*! \brief Obj struct for InternetGatewayDevice.Services.VoiceService.{i}.X_BROADCOM_COM_Call.{i}.NumberOfMissedCalls.
 *
 * MDMOID_VOICE_CALL_NUMBER_OF_MISSED_CALLS 505
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    element;	/**< ReadWrite */
} VoiceCallNumberOfMissedCallsObject;

/*! \brief _VoiceCallNumberOfMissedCallsObject is used internally to represent VoiceCallNumberOfMissedCallsObject */
typedef VoiceCallNumberOfMissedCallsObject _VoiceCallNumberOfMissedCallsObject;



/*! \brief Obj struct for InternetGatewayDevice.Services.VoiceService.{i}.X_BROADCOM_COM_Call.{i}.Number.
 *
 * MDMOID_VOICE_CALL_NUMBER 506
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    element;	/**< ReadWrite */
    UBOOL8    internal;	/**< ReadWrite */
    UBOOL8    own;	/**< ReadWrite */
} VoiceCallNumberObject;

/*! \brief _VoiceCallNumberObject is used internally to represent VoiceCallNumberObject */
typedef VoiceCallNumberObject _VoiceCallNumberObject;



/*! \brief Obj struct for InternetGatewayDevice.Services.VoiceService.{i}.X_BROADCOM_COM_Call.{i}.Name.
 *
 * MDMOID_VOICE_CALL_NAME 507
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    element;	/**< ReadWrite */
} VoiceCallNameObject;

/*! \brief _VoiceCallNameObject is used internally to represent VoiceCallNameObject */
typedef VoiceCallNameObject _VoiceCallNameObject;



/*! \brief Obj struct for InternetGatewayDevice.Services.VoiceService.{i}.X_BROADCOM_COM_Call.{i}.DateTime.
 *
 * MDMOID_VOICE_CALL_DATE_TIME 508
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    DATETIME  element;	/**< ReadWrite */
} VoiceCallDateTimeObject;

/*! \brief _VoiceCallDateTimeObject is used internally to represent VoiceCallDateTimeObject */
typedef VoiceCallDateTimeObject _VoiceCallDateTimeObject;



/*! \brief Obj struct for InternetGatewayDevice.Services.VoiceService.{i}.X_BROADCOM_COM_Call.{i}.LineName.
 *
 * MDMOID_VOICE_CALL_LINE_NAME 509
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    element;	/**< ReadWrite */
} VoiceCallLineNameObject;

/*! \brief _VoiceCallLineNameObject is used internally to represent VoiceCallLineNameObject */
typedef VoiceCallLineNameObject _VoiceCallLineNameObject;



/*! \brief Obj struct for InternetGatewayDevice.Services.VoiceService.{i}.X_BROADCOM_COM_Call.{i}.LineId.
 *
 * MDMOID_VOICE_CALL_LINE_ID 510
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    element;	/**< ReadWrite */
    UINT32    subType;	/**< ReadWrite */
} VoiceCallLineIdObject;

/*! \brief _VoiceCallLineIdObject is used internally to represent VoiceCallLineIdObject */
typedef VoiceCallLineIdObject _VoiceCallLineIdObject;



/*! \brief Obj struct for InternetGatewayDevice.Services.VoiceService.{i}.X_BROADCOM_COM_Call.{i}.CallType.
 *
 * MDMOID_VOICE_CALL_TYPE 511
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    element;	/**< ReadWrite */
} VoiceCallTypeObject;

/*! \brief _VoiceCallTypeObject is used internally to represent VoiceCallTypeObject */
typedef VoiceCallTypeObject _VoiceCallTypeObject;



/*! \brief Obj struct for InternetGatewayDevice.Services.VoiceService.{i}.X_BROADCOM_COM_Contact.{i}.
 *
 * MDMOID_VOICE_CONTACT_LIST 512
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
} VoiceContactListObject;

/*! \brief _VoiceContactListObject is used internally to represent VoiceContactListObject */
typedef VoiceContactListObject _VoiceContactListObject;



/*! \brief Obj struct for InternetGatewayDevice.Services.VoiceService.{i}.X_BROADCOM_COM_Contact.{i}.Name.
 *
 * MDMOID_VOICE_CONTACT_NAME 513
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    element;	/**< ReadWrite */
} VoiceContactNameObject;

/*! \brief _VoiceContactNameObject is used internally to represent VoiceContactNameObject */
typedef VoiceContactNameObject _VoiceContactNameObject;



/*! \brief Obj struct for InternetGatewayDevice.Services.VoiceService.{i}.X_BROADCOM_COM_Contact.{i}.FirstName.
 *
 * MDMOID_VOICE_CONTACT_FIRST_NAME 514
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    element;	/**< ReadWrite */
} VoiceContactFirstNameObject;

/*! \brief _VoiceContactFirstNameObject is used internally to represent VoiceContactFirstNameObject */
typedef VoiceContactFirstNameObject _VoiceContactFirstNameObject;



/*! \brief Obj struct for InternetGatewayDevice.Services.VoiceService.{i}.X_BROADCOM_COM_Contact.{i}.ContactNumber.{i}.
 *
 * MDMOID_VOICE_CONTACT_NUMBER 515
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    editable;	/**< ReadWrite */
    char *    number;	/**< ReadWrite */
    UBOOL8    own;	/**< ReadWrite */
    UINT32    numberType;	/**< ReadWrite */
} VoiceContactNumberObject;

/*! \brief _VoiceContactNumberObject is used internally to represent VoiceContactNumberObject */
typedef VoiceContactNumberObject _VoiceContactNumberObject;



/*! \brief Obj struct for InternetGatewayDevice.Services.VoiceService.{i}.X_BROADCOM_COM_Contact.{i}.Melody.
 *
 * MDMOID_VOICE_CONTACT_MELODY 516
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    element;	/**< ReadWrite */
} VoiceContactMelodyObject;

/*! \brief _VoiceContactMelodyObject is used internally to represent VoiceContactMelodyObject */
typedef VoiceContactMelodyObject _VoiceContactMelodyObject;



/*! \brief Obj struct for InternetGatewayDevice.Services.VoiceService.{i}.X_BROADCOM_COM_Contact.{i}.LineId.
 *
 * MDMOID_VOICE_CONTACT_LINE_ID 517
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    element;	/**< ReadWrite */
    UINT32    lineIdSubType;	/**< ReadWrite */
} VoiceContactLineIdObject;

/*! \brief _VoiceContactLineIdObject is used internally to represent VoiceContactLineIdObject */
typedef VoiceContactLineIdObject _VoiceContactLineIdObject;



/*! \brief Obj struct for InternetGatewayDevice.Services.VoiceService.{i}.X_BROADCOM_COM_SupportList.{i}.
 *
 * MDMOID_VOICE_DECT_SUPPORT_LIST 518
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    element;	/**< ReadOnly */
    UBOOL8    supported;	/**< ReadOnly */
} VoiceDectSupportListObject;

/*! \brief _VoiceDectSupportListObject is used internally to represent VoiceDectSupportListObject */
typedef VoiceDectSupportListObject _VoiceDectSupportListObject;



/*! \brief Obj struct for InternetGatewayDevice.Services.VoiceService.{i}.Capabilities.
 *
 * MDMOID_VOICE_CAP 519
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    maxProfileCount;	/**< ReadOnly */
    UINT32    maxLineCount;	/**< ReadOnly */
    UINT32    maxSessionsPerLine;	/**< ReadOnly */
    UINT32    maxSessionCount;	/**< ReadOnly */
    char *    signalingProtocols;	/**< ReadOnly */
    char *    regions;	/**< ReadOnly */
    UBOOL8    RTCP;	/**< ReadOnly */
    UBOOL8    SRTP;	/**< ReadOnly */
    UBOOL8    RTPRedundancy;	/**< ReadOnly */
    UBOOL8    DSCPCoupled;	/**< ReadOnly */
    UBOOL8    ethernetTaggingCoupled;	/**< ReadOnly */
    UBOOL8    PSTNSoftSwitchOver;	/**< ReadOnly */
    UBOOL8    faxT38;	/**< ReadOnly */
    UBOOL8    faxPassThrough;	/**< ReadOnly */
    UBOOL8    modemPassThrough;	/**< ReadOnly */
    UBOOL8    toneGeneration;	/**< ReadOnly */
    UBOOL8    ringGeneration;	/**< ReadOnly */
    UBOOL8    digitMap;	/**< ReadOnly */
    UBOOL8    numberingPlan;	/**< ReadOnly */
    UBOOL8    buttonMap;	/**< ReadOnly */
    UBOOL8    voicePortTests;	/**< ReadOnly */
} VoiceCapObject;

/*! \brief _VoiceCapObject is used internally to represent VoiceCapObject */
typedef VoiceCapObject _VoiceCapObject;



/*! \brief Obj struct for InternetGatewayDevice.Services.VoiceService.{i}.Capabilities.SIP.
 *
 * MDMOID_VOICE_CAP_SIP 520
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    role;	/**< ReadOnly */
    char *    extensions;	/**< ReadOnly */
    char *    transports;	/**< ReadOnly */
    char *    URISchemes;	/**< ReadOnly */
    UBOOL8    eventSubscription;	/**< ReadOnly */
    UBOOL8    responseMap;	/**< ReadOnly */
    char *    TLSKeyExchangeProtocols;	/**< ReadOnly */
} VoiceCapSipObject;

/*! \brief _VoiceCapSipObject is used internally to represent VoiceCapSipObject */
typedef VoiceCapSipObject _VoiceCapSipObject;



/*! \brief Obj struct for InternetGatewayDevice.Services.VoiceService.{i}.Capabilities.MGCP.
 *
 * MDMOID_VOICE_CAP_MGCP 521
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    extensions;	/**< ReadOnly */
} VoiceCapMgcpObject;

/*! \brief _VoiceCapMgcpObject is used internally to represent VoiceCapMgcpObject */
typedef VoiceCapMgcpObject _VoiceCapMgcpObject;



/*! \brief Obj struct for InternetGatewayDevice.Services.VoiceService.{i}.Capabilities.Codecs.{i}.
 *
 * MDMOID_VOICE_CAP_CODECS 523
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    entryID;	/**< ReadOnly */
    char *    codec;	/**< ReadOnly */
    UINT32    bitRate;	/**< ReadOnly */
    char *    packetizationPeriod;	/**< ReadOnly */
    UBOOL8    silenceSuppression;	/**< ReadOnly */
} VoiceCapCodecsObject;

/*! \brief _VoiceCapCodecsObject is used internally to represent VoiceCapCodecsObject */
typedef VoiceCapCodecsObject _VoiceCapCodecsObject;



/*! \brief Obj struct for InternetGatewayDevice.Services.VoiceService.{i}.VoiceProfile.{i}.
 *
 * MDMOID_VOICE_PROF 524
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    enable;	/**< ReadWrite */
    UBOOL8    reset;	/**< ReadWrite */
    UINT32    numberOfLines;	/**< ReadOnly */
    char *    name;	/**< ReadWrite */
    char *    signalingProtocol;	/**< ReadWrite */
    UINT32    maxSessions;	/**< ReadWrite */
    char *    DTMFMethod;	/**< ReadWrite */
    char *    DTMFMethodG711;	/**< ReadWrite */
    char *    X_BROADCOM_COM_HookFlashMethod;	/**< ReadWrite */
    char *    region;	/**< ReadWrite */
    char *    digitMap;	/**< ReadWrite */
    UBOOL8    digitMapEnable;	/**< ReadWrite */
    UBOOL8    STUNEnable;	/**< ReadWrite */
    char *    STUNServer;	/**< ReadWrite */
    UINT32    X_BROADCOM_COM_STUNServerPort;	/**< ReadWrite */
    char *    X_BROADCOM_COM_LogServer;	/**< ReadWrite */
    UINT32    X_BROADCOM_COM_LogServerPort;	/**< ReadWrite */
    UINT32    X_BROADCOM_COM_SPNum;	/**< ReadWrite */
    UBOOL8    X_BROADCOM_COM_V18_Support;	/**< ReadWrite */
    UINT32    X_BROADCOM_COM_CriticalDigitTimer;	/**< ReadWrite */
    UINT32    X_BROADCOM_COM_PartialDigitTimer;	/**< ReadWrite */
#ifdef DMP_SIPENDPOINT_1
    char *    X_BROADCOM_COM_CCTK_DigitMap;	/**< ReadWrite */
#endif
} VoiceProfObject;

/*! \brief _VoiceProfObject is used internally to represent VoiceProfObject */
typedef VoiceProfObject _VoiceProfObject;



/*! \brief Obj struct for InternetGatewayDevice.Services.VoiceService.{i}.VoiceProfile.{i}.ServiceProviderInfo.
 *
 * MDMOID_VOICE_PROF_PROVIDER 525
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    name;	/**< ReadWrite */
} VoiceProfProviderObject;

/*! \brief _VoiceProfProviderObject is used internally to represent VoiceProfProviderObject */
typedef VoiceProfProviderObject _VoiceProfProviderObject;



/*! \brief Obj struct for InternetGatewayDevice.Services.VoiceService.{i}.VoiceProfile.{i}.SIP.
 *
 * MDMOID_VOICE_PROF_SIP 526
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    proxyServer;	/**< ReadWrite */
    UINT32    proxyServerPort;	/**< ReadWrite */
    char *    proxyServerTransport;	/**< ReadWrite */
    char *    registrarServer;	/**< ReadWrite */
    UINT32    registrarServerPort;	/**< ReadWrite */
    char *    registrarServerTransport;	/**< ReadWrite */
    UBOOL8    X_BROADCOM_COM_UseSipUriForTls;	/**< ReadWrite */
    UBOOL8    X_BROADCOM_COM_ToTagMatching;	/**< ReadWrite */
    char *    X_BROADCOM_COM_MusicServer;	/**< ReadWrite */
    UINT32    X_BROADCOM_COM_MusicServerPort;	/**< ReadWrite */
    char *    X_BROADCOM_COM_ConferencingURI;	/**< ReadWrite */
    char *    X_BROADCOM_COM_ConferencingOption;	/**< ReadWrite */
    UBOOL8    X_BROADCOM_COM_SipFailoverEnable;	/**< ReadWrite */
    UBOOL8    X_BROADCOM_COM_SipOptionsEnable;	/**< ReadWrite */
    char *    X_BROADCOM_COM_SecondaryDomainName;	/**< ReadWrite */
    char *    X_BROADCOM_COM_SecondaryProxyAddress;	/**< ReadWrite */
    UINT32    X_BROADCOM_COM_SecondaryProxyPort;	/**< ReadWrite */
    char *    X_BROADCOM_COM_SecondaryOutboundProxyAddress;	/**< ReadWrite */
    UINT32    X_BROADCOM_COM_SecondaryOutboundProxyPort;	/**< ReadWrite */
    char *    X_BROADCOM_COM_SecondaryRegistrarAddress;	/**< ReadWrite */
    UINT32    X_BROADCOM_COM_SecondaryRegistrarPort;	/**< ReadWrite */
    char *    X_BROADCOM_COM_BackToPrimMode;	/**< ReadWrite */
    UBOOL8    X_BROADCOM_COM_EuroFlashEnable;	/**< ReadWrite */
    char *    X_BROADCOM_COM_SipMode;	/**< ReadWrite */
    char *    userAgentDomain;	/**< ReadWrite */
    UINT32    userAgentPort;	/**< ReadWrite */
    char *    userAgentTransport;	/**< ReadWrite */
    char *    outboundProxy;	/**< ReadWrite */
    UINT32    outboundProxyPort;	/**< ReadWrite */
    char *    organization;	/**< ReadWrite */
    UINT32    registrationPeriod;	/**< ReadWrite */
    UINT32    timerB;	/**< ReadWrite */
    UINT32    timerF;	/**< ReadWrite */
    UINT32    registerExpires;	/**< ReadWrite */
    UINT32    registerRetryInterval;	/**< ReadWrite */
    UINT32    DSCPMark;	/**< ReadWrite */
    SINT32    VLANIDMark;	/**< ReadWrite */
    SINT32    ethernetPriorityMark;	/**< ReadWrite */
} VoiceProfSipObject;

/*! \brief _VoiceProfSipObject is used internally to represent VoiceProfSipObject */
typedef VoiceProfSipObject _VoiceProfSipObject;



/*! \brief Obj struct for InternetGatewayDevice.Services.VoiceService.{i}.VoiceProfile.{i}.SIP.EventSubscribe.{i}.
 *
 * MDMOID_VOICE_PROF_SIP_SUBSCRIBE 527
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    event;	/**< ReadWrite */
    char *    notifier;	/**< ReadWrite */
    UINT32    notifierPort;	/**< ReadWrite */
    char *    notifierTransport;	/**< ReadWrite */
} VoiceProfSipSubscribeObject;

/*! \brief _VoiceProfSipSubscribeObject is used internally to represent VoiceProfSipSubscribeObject */
typedef VoiceProfSipSubscribeObject _VoiceProfSipSubscribeObject;



/*! \brief Obj struct for InternetGatewayDevice.Services.VoiceService.{i}.VoiceProfile.{i}.MGCP.
 *
 * MDMOID_VOICE_PROF_MGCP 529
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    callAgent1;	/**< ReadWrite */
    char *    user;	/**< ReadWrite */
} VoiceProfMgcpObject;

/*! \brief _VoiceProfMgcpObject is used internally to represent VoiceProfMgcpObject */
typedef VoiceProfMgcpObject _VoiceProfMgcpObject;



/*! \brief Obj struct for InternetGatewayDevice.Services.VoiceService.{i}.VoiceProfile.{i}.RTP.
 *
 * MDMOID_VOICE_PROF_RTP 531
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    localPortMin;	/**< ReadWrite */
    UINT32    localPortMax;	/**< ReadWrite */
    UINT32    DSCPMark;	/**< ReadWrite */
    UINT32    telephoneEventPayloadType;	/**< ReadWrite */
} VoiceProfRtpObject;

/*! \brief _VoiceProfRtpObject is used internally to represent VoiceProfRtpObject */
typedef VoiceProfRtpObject _VoiceProfRtpObject;



/*! \brief Obj struct for InternetGatewayDevice.Services.VoiceService.{i}.VoiceProfile.{i}.RTP.RTCP.
 *
 * MDMOID_VOICE_PROF_RTP_RTCP 532
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< Present */
    UINT32    txRepeatInterval;	/**< Present */
    char *    localCName;	/**< Present */
    char *    X_BROADCOM_COM_RTCPXR_Config;	/**< ReadWrite */
    char *    X_BROADCOM_COM_RTCPXP_PubRepAddr;	/**< ReadWrite */
    UBOOL8    X_BROADCOM_COM_RTCPRandomInt;	/**< ReadWrite */
} VoiceProfRtpRtcpObject;

/*! \brief _VoiceProfRtpRtcpObject is used internally to represent VoiceProfRtpRtcpObject */
typedef VoiceProfRtpRtcpObject _VoiceProfRtpRtcpObject;



/*! \brief Obj struct for InternetGatewayDevice.Services.VoiceService.{i}.VoiceProfile.{i}.RTP.SRTP.
 *
 * MDMOID_VOICE_PROF_RTP_SRTP 533
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadOnly */
    char *    X_BROADCOM_COM_SrtpUsageOption;	/**< ReadWrite */
} VoiceProfRtpSrtpObject;

/*! \brief _VoiceProfRtpSrtpObject is used internally to represent VoiceProfRtpSrtpObject */
typedef VoiceProfRtpSrtpObject _VoiceProfRtpSrtpObject;



/*! \brief Obj struct for InternetGatewayDevice.Services.VoiceService.{i}.VoiceProfile.{i}.RTP.Redundancy.
 *
 * MDMOID_VOICE_PROF_RTP_REDUNDANCY 534
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    UINT32    payloadType;	/**< ReadWrite */
    UINT32    blockPayloadType;	/**< ReadOnly */
    SINT32    voiceRedundancy;	/**< ReadWrite */
} VoiceProfRtpRedundancyObject;

/*! \brief _VoiceProfRtpRedundancyObject is used internally to represent VoiceProfRtpRedundancyObject */
typedef VoiceProfRtpRedundancyObject _VoiceProfRtpRedundancyObject;



/*! \brief Obj struct for InternetGatewayDevice.Services.VoiceService.{i}.VoiceProfile.{i}.FaxT38.
 *
 * MDMOID_VOICE_PROF_FAX_T38 543
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    UINT32    bitRate;	/**< ReadWrite */
    UINT32    highSpeedPacketRate;	/**< ReadWrite */
} VoiceProfFaxT38Object;

/*! \brief _VoiceProfFaxT38Object is used internally to represent VoiceProfFaxT38Object */
typedef VoiceProfFaxT38Object _VoiceProfFaxT38Object;



/*! \brief Obj struct for InternetGatewayDevice.Services.VoiceService.{i}.VoiceProfile.{i}.Line.{i}.
 *
 * MDMOID_VOICE_LINE 544
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    enable;	/**< ReadWrite */
    char *    directoryNumber;	/**< ReadWrite */
    char *    status;	/**< ReadOnly */
    char *    callState;	/**< ReadOnly */
#ifdef DMP_TAENDPOINT_1
    char *    phyReferenceList;	/**< ReadWrite */
#endif
    char *    X_BROADCOM_COM_NonFxsPhyReferenceList;	/**< ReadWrite */
    UINT32    X_BROADCOM_COM_CMAcntNum;	/**< ReadWrite */
    char *    X_BROADCOM_COM_AssociatedNonFxsPhyIntfType;	/**< ReadWrite */
} VoiceLineObject;

/*! \brief _VoiceLineObject is used internally to represent VoiceLineObject */
typedef VoiceLineObject _VoiceLineObject;



/*! \brief Obj struct for InternetGatewayDevice.Services.VoiceService.{i}.VoiceProfile.{i}.Line.{i}.SIP.
 *
 * MDMOID_VOICE_LINE_SIP 545
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    authUserName;	/**< ReadWrite */
    char *    authPassword;	/**< ReadWrite */
    char *    URI;	/**< ReadWrite */
} VoiceLineSipObject;

/*! \brief _VoiceLineSipObject is used internally to represent VoiceLineSipObject */
typedef VoiceLineSipObject _VoiceLineSipObject;



/*! \brief Obj struct for InternetGatewayDevice.Services.VoiceService.{i}.VoiceProfile.{i}.Line.{i}.CallingFeatures.
 *
 * MDMOID_VOICE_LINE_CALLING_FEATURES 553
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    callerIDEnable;	/**< ReadWrite */
    UBOOL8    callerIDNameEnable;	/**< ReadWrite */
    char *    callerIDName;	/**< ReadWrite */
    UBOOL8    callWaitingEnable;	/**< ReadWrite */
    char *    callWaitingStatus;	/**< ReadOnly */
    UINT32    maxSessions;	/**< ReadWrite */
    UBOOL8    callForwardUnconditionalEnable;	/**< ReadWrite */
    UBOOL8    X_BROADCOM_COM_CallForwardUnconditionalStart;	/**< ReadWrite */
    char *    callForwardUnconditionalNumber;	/**< ReadWrite */
    UBOOL8    callForwardOnBusyEnable;	/**< ReadWrite */
    UBOOL8    X_BROADCOM_COM_CallForwardOnBusyStart;	/**< ReadWrite */
    char *    callForwardOnBusyNumber;	/**< ReadWrite */
    UBOOL8    callForwardOnNoAnswerEnable;	/**< ReadWrite */
    UBOOL8    X_BROADCOM_COM_CallForwardOnNoAnswerStart;	/**< ReadWrite */
    char *    callForwardOnNoAnswerNumber;	/**< ReadWrite */
    UBOOL8    callTransferEnable;	/**< ReadWrite */
    UBOOL8    MWIEnable;	/**< ReadWrite */
    UBOOL8    anonymousCallBlockEnable;	/**< ReadWrite */
    UBOOL8    X_BROADCOM_COM_AnonymousCallBlockStart;	/**< ReadWrite */
    UBOOL8    anonymousCallEnable;	/**< ReadWrite */
    UBOOL8    doNotDisturbEnable;	/**< ReadWrite */
    UBOOL8    X_BROADCOM_COM_DoNotDisturbStart;	/**< ReadWrite */
    UBOOL8    callReturnEnable;	/**< ReadWrite */
    UBOOL8    repeatDialEnable;	/**< ReadWrite */
    UBOOL8    X_BROADCOM_COM_CAllCompletionOnBusyEnable;	/**< ReadWrite */
    UBOOL8    X_BROADCOM_COM_SpeedDialEnable;	/**< ReadWrite */
    UBOOL8    X_BROADCOM_COM_WarmLineEnable;	/**< ReadWrite */
    UBOOL8    X_BROADCOM_COM_WarmLineStart;	/**< ReadWrite */
    char *    X_BROADCOM_COM_WarmLineNumber;	/**< ReadWrite */
    UBOOL8    X_BROADCOM_COM_CallBarringEnable;	/**< ReadWrite */
    char *    X_BROADCOM_COM_CallBarringMode;	/**< ReadWrite */
    char *    X_BROADCOM_COM_CallBarringUserPin;	/**< ReadWrite */
    char *    X_BROADCOM_COM_CallBarringDigitMap;	/**< ReadWrite */
    UBOOL8    X_BROADCOM_COM_NetworkPrivacyEnable;	/**< ReadWrite */
    UBOOL8    X_BROADCOM_COM_NetworkPrivacyStart;	/**< ReadWrite */
    UBOOL8    X_BROADCOM_COM_VMWIEnable;	/**< ReadWrite */
    UBOOL8    X_BROADCOM_COM_EnumEnable;	/**< ReadWrite */
    UBOOL8    X_BROADCOM_COM_EnumStart;	/**< ReadWrite */
    UINT32    X_BROADCOM_COM_EmergNetworkHoldTime;	/**< ReadWrite */
    UINT32    X_BROADCOM_COM_EmergencyDSCPMark;	/**< ReadWrite */
    UBOOL8    X_BROADCOM_COM_EmergNoLocationInfo;	/**< ReadWrite */
    UBOOL8    X_BROADCOM_COM_EmergAllow3WayCall;	/**< ReadWrite */
    UBOOL8    X_BROADCOM_COM_EmergNetworkHoldDisable;	/**< ReadWrite */
    UBOOL8    X_BROADCOM_COM_EmergNetworkHoldBypassChk;	/**< ReadWrite */
    UBOOL8    X_BROADCOM_COM_EndCallAcptIncEmerg;	/**< ReadWrite */
    UINT32    X_BROADCOM_COM_EmergHowlerDuration;	/**< ReadWrite */
} VoiceLineCallingFeaturesObject;

/*! \brief _VoiceLineCallingFeaturesObject is used internally to represent VoiceLineCallingFeaturesObject */
typedef VoiceLineCallingFeaturesObject _VoiceLineCallingFeaturesObject;



/*! \brief Obj struct for InternetGatewayDevice.Services.VoiceService.{i}.VoiceProfile.{i}.Line.{i}.VoiceProcessing.
 *
 * MDMOID_VOICE_LINE_PROCESSING 554
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    SINT32    transmitGain;	/**< ReadWrite */
    SINT32    receiveGain;	/**< ReadWrite */
    UBOOL8    echoCancellationEnable;	/**< ReadWrite */
} VoiceLineProcessingObject;

/*! \brief _VoiceLineProcessingObject is used internally to represent VoiceLineProcessingObject */
typedef VoiceLineProcessingObject _VoiceLineProcessingObject;



/*! \brief Obj struct for InternetGatewayDevice.Services.VoiceService.{i}.VoiceProfile.{i}.Line.{i}.Codec.
 *
 * MDMOID_VOICE_LINE_CODEC 555
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
} VoiceLineCodecObject;

/*! \brief _VoiceLineCodecObject is used internally to represent VoiceLineCodecObject */
typedef VoiceLineCodecObject _VoiceLineCodecObject;



/*! \brief Obj struct for InternetGatewayDevice.Services.VoiceService.{i}.VoiceProfile.{i}.Line.{i}.Codec.List.{i}.
 *
 * MDMOID_VOICE_LINE_CODEC_LIST 556
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    entryID;	/**< ReadOnly */
    char *    codec;	/**< ReadOnly */
    UINT32    bitRate;	/**< ReadOnly */
    char *    packetizationPeriod;	/**< ReadWrite */
    UBOOL8    silenceSuppression;	/**< ReadWrite */
    UBOOL8    enable;	/**< ReadWrite */
    UINT32    priority;	/**< ReadWrite */
} VoiceLineCodecListObject;

/*! \brief _VoiceLineCodecListObject is used internally to represent VoiceLineCodecListObject */
typedef VoiceLineCodecListObject _VoiceLineCodecListObject;



/*! \brief Obj struct for InternetGatewayDevice.Services.VoiceService.{i}.VoiceProfile.{i}.Line.{i}.Stats.
 *
 * MDMOID_VOICE_LINE_STATS 558
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    resetStatistics;	/**< ReadWrite */
    UINT32    packetsSent;	/**< ReadOnly */
    UINT32    packetsReceived;	/**< ReadOnly */
    UINT32    bytesSent;	/**< ReadOnly */
    UINT32    bytesReceived;	/**< ReadOnly */
    UINT32    packetsLost;	/**< ReadOnly */
    UINT32    incomingCallsReceived;	/**< ReadOnly */
    UINT32    incomingCallsAnswered;	/**< ReadOnly */
    UINT32    incomingCallsConnected;	/**< ReadOnly */
    UINT32    incomingCallsFailed;	/**< ReadOnly */
    UINT32    outgoingCallsAttempted;	/**< ReadOnly */
    UINT32    outgoingCallsAnswered;	/**< ReadOnly */
    UINT32    outgoingCallsConnected;	/**< ReadOnly */
    UINT32    outgoingCallsFailed;	/**< ReadOnly */
    UINT32    callsDropped;	/**< ReadOnly */
    UINT32    receivePacketLossRate;	/**< ReadOnly */
    UINT32    farEndPacketLossRate;	/**< ReadOnly */
    UINT32    receiveInterarrivalJitter;	/**< ReadOnly */
    UINT32    farEndInterarrivalJitter;	/**< ReadOnly */
    UINT32    roundTripDelay;	/**< ReadOnly */
    UINT32    averageReceiveInterarrivalJitter;	/**< ReadOnly */
    UINT32    averageFarEndInterarrivalJitter;	/**< ReadOnly */
    UINT32    averageRoundTripDelay;	/**< ReadOnly */
} VoiceLineStatsObject;

/*! \brief _VoiceLineStatsObject is used internally to represent VoiceLineStatsObject */
typedef VoiceLineStatsObject _VoiceLineStatsObject;



/*! \brief Obj struct for InternetGatewayDevice.Services.VoiceService.{i}.VoiceProfile.{i}.Line.{i}.X_BROADCOM_COM_DectLineSetting.
 *
 * MDMOID_VOICE_LINE_SETTING 559
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
} VoiceLineSettingObject;

/*! \brief _VoiceLineSettingObject is used internally to represent VoiceLineSettingObject */
typedef VoiceLineSettingObject _VoiceLineSettingObject;



/*! \brief Obj struct for InternetGatewayDevice.Services.VoiceService.{i}.VoiceProfile.{i}.Line.{i}.X_BROADCOM_COM_DectLineSetting.LineName.
 *
 * MDMOID_VOICE_LINE_NAME 560
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    element;	/**< ReadWrite */
} VoiceLineNameObject;

/*! \brief _VoiceLineNameObject is used internally to represent VoiceLineNameObject */
typedef VoiceLineNameObject _VoiceLineNameObject;



/*! \brief Obj struct for InternetGatewayDevice.Services.VoiceService.{i}.VoiceProfile.{i}.Line.{i}.X_BROADCOM_COM_DectLineSetting.LineId.
 *
 * MDMOID_VOICE_LINE_DECT_LINE_ID 561
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    element;	/**< ReadWrite */
} VoiceLineDectLineIdObject;

/*! \brief _VoiceLineDectLineIdObject is used internally to represent VoiceLineDectLineIdObject */
typedef VoiceLineDectLineIdObject _VoiceLineDectLineIdObject;



/*! \brief Obj struct for InternetGatewayDevice.Services.VoiceService.{i}.VoiceProfile.{i}.Line.{i}.X_BROADCOM_COM_DectLineSetting.AttachedHandset.
 *
 * MDMOID_VOICE_LINE_ATTACHED_HANDSET 562
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    element;	/**< ReadWrite */
    UINT32    totalNumber;	/**< ReadWrite */
} VoiceLineAttachedHandsetObject;

/*! \brief _VoiceLineAttachedHandsetObject is used internally to represent VoiceLineAttachedHandsetObject */
typedef VoiceLineAttachedHandsetObject _VoiceLineAttachedHandsetObject;



/*! \brief Obj struct for InternetGatewayDevice.Services.VoiceService.{i}.VoiceProfile.{i}.Line.{i}.X_BROADCOM_COM_DectLineSetting.Melody.
 *
 * MDMOID_VOICE_LINE_MELODY 563
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    element;	/**< ReadWrite */
} VoiceLineMelodyObject;

/*! \brief _VoiceLineMelodyObject is used internally to represent VoiceLineMelodyObject */
typedef VoiceLineMelodyObject _VoiceLineMelodyObject;



/*! \brief Obj struct for InternetGatewayDevice.Services.VoiceService.{i}.VoiceProfile.{i}.Line.{i}.X_BROADCOM_COM_DectLineSetting.DialingPrefix.
 *
 * MDMOID_VOICE_LINE_DIALING_PREFIX 564
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    element;	/**< ReadWrite */
    UBOOL8    internal;	/**< ReadWrite */
    UBOOL8    own;	/**< ReadWrite */
} VoiceLineDialingPrefixObject;

/*! \brief _VoiceLineDialingPrefixObject is used internally to represent VoiceLineDialingPrefixObject */
typedef VoiceLineDialingPrefixObject _VoiceLineDialingPrefixObject;



/*! \brief Obj struct for InternetGatewayDevice.Services.VoiceService.{i}.VoiceProfile.{i}.Line.{i}.X_BROADCOM_COM_DectLineSetting.Volumn.
 *
 * MDMOID_VOICE_LINE_VOLUMN 565
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    element;	/**< ReadWrite */
} VoiceLineVolumnObject;

/*! \brief _VoiceLineVolumnObject is used internally to represent VoiceLineVolumnObject */
typedef VoiceLineVolumnObject _VoiceLineVolumnObject;



/*! \brief Obj struct for InternetGatewayDevice.Services.VoiceService.{i}.VoiceProfile.{i}.Line.{i}.X_BROADCOM_COM_DectLineSetting.BlockedNumber.
 *
 * MDMOID_VOICE_LINE_BLOCKED_NUMBER 566
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    element;	/**< ReadWrite */
    UBOOL8    internal;	/**< ReadWrite */
    UBOOL8    own;	/**< ReadWrite */
} VoiceLineBlockedNumberObject;

/*! \brief _VoiceLineBlockedNumberObject is used internally to represent VoiceLineBlockedNumberObject */
typedef VoiceLineBlockedNumberObject _VoiceLineBlockedNumberObject;



/*! \brief Obj struct for InternetGatewayDevice.Services.VoiceService.{i}.VoiceProfile.{i}.Line.{i}.X_BROADCOM_COM_DectLineSetting.MultiCallMode.
 *
 * MDMOID_VOICE_LINE_MULTI_CALL_MODE 567
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    element;	/**< ReadWrite */
} VoiceLineMultiCallModeObject;

/*! \brief _VoiceLineMultiCallModeObject is used internally to represent VoiceLineMultiCallModeObject */
typedef VoiceLineMultiCallModeObject _VoiceLineMultiCallModeObject;



/*! \brief Obj struct for InternetGatewayDevice.Services.VoiceService.{i}.VoiceProfile.{i}.Line.{i}.X_BROADCOM_COM_DectLineSetting.IntrusionCall.
 *
 * MDMOID_VOICE_LINE_INTRUSION_CALL 568
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    element;	/**< ReadWrite */
} VoiceLineIntrusionCallObject;

/*! \brief _VoiceLineIntrusionCallObject is used internally to represent VoiceLineIntrusionCallObject */
typedef VoiceLineIntrusionCallObject _VoiceLineIntrusionCallObject;



/*! \brief Obj struct for InternetGatewayDevice.Services.VoiceService.{i}.VoiceProfile.{i}.Line.{i}.X_BROADCOM_COM_DectLineSetting.CLIR.
 *
 * MDMOID_CLI_R 569
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    element;	/**< ReadWrite */
} VoiceLineCLIRObject;

/*! \brief _VoiceLineCLIRObject is used internally to represent VoiceLineCLIRObject */
typedef VoiceLineCLIRObject _VoiceLineCLIRObject;



/*! \brief Obj struct for InternetGatewayDevice.Services.VoiceService.{i}.PhyInterface.{i}.
 *
 * MDMOID_VOICE_PHY_INTF 570
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    phyPort;	/**< ReadOnly */
    UINT32    interfaceID;	/**< ReadOnly */
    char *    description;	/**< ReadOnly */
} VoicePhyIntfObject;

/*! \brief _VoicePhyIntfObject is used internally to represent VoicePhyIntfObject */
typedef VoicePhyIntfObject _VoicePhyIntfObject;



/*! \brief Obj struct for InternetGatewayDevice.Services.VoiceService.{i}.PhyInterface.{i}.Tests.
 *
 * MDMOID_VOICE_PHY_INTF_TESTS 571
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    testState;	/**< ReadWrite */
    char *    testSelector;	/**< ReadWrite */
    UBOOL8    phoneConnectivity;	/**< ReadOnly */
} VoicePhyIntfTestsObject;

/*! \brief _VoicePhyIntfTestsObject is used internally to represent VoicePhyIntfTestsObject */
typedef VoicePhyIntfTestsObject _VoicePhyIntfTestsObject;



/*! \brief Obj struct for InternetGatewayDevice.Services.VoiceService.{i}.X_BROADCOM_COM_PSTN.{i}.
 *
 * MDMOID_VOICE_PSTN 572
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    pstnPhyPort;	/**< ReadOnly */
    UINT32    pstnInterfaceID;	/**< ReadOnly */
    char *    outgoingCallDialPlan;	/**< ReadWrite */
    char *    incomingCallRoutingMode;	/**< ReadWrite */
    char *    incomingCallRoutingDest;	/**< ReadWrite */
} VoicePstnObject;

/*! \brief _VoicePstnObject is used internally to represent VoicePstnObject */
typedef VoicePstnObject _VoicePstnObject;



/*! \brief Obj struct for InternetGatewayDevice.Services.VoiceService.{i}.X_BROADCOM_COM_Ntr.
 *
 * MDMOID_VOICE_NTR 573
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    UBOOL8    autoModeEnable;	/**< ReadWrite */
    char *    manualOffset;	/**< ReadWrite */
    char *    manualPpm;	/**< ReadWrite */
    SINT32    manualSteps;	/**< ReadWrite */
    UBOOL8    debugEnable;	/**< ReadWrite */
    char *    pcmMipsTallyCurrent;	/**< ReadWrite */
    char *    pcmMipsTallyPrevious;	/**< ReadWrite */
    char *    pcmNtrTallyCurrent;	/**< ReadWrite */
    char *    pcmNtrTallyPrevious;	/**< ReadWrite */
    char *    dslMipsTallyCurrent;	/**< ReadWrite */
    char *    dslMipsTallyPrevious;	/**< ReadWrite */
    char *    dslNtrTallyCurrent;	/**< ReadWrite */
    char *    dslNtrTallyPrevious;	/**< ReadWrite */
    char *    sampleRate;	/**< ReadWrite */
    char *    pllBandwidth;	/**< ReadWrite */
    char *    dampingFactor;	/**< ReadWrite */
} VoiceNtrObject;

/*! \brief _VoiceNtrObject is used internally to represent VoiceNtrObject */
typedef VoiceNtrObject _VoiceNtrObject;



/*! \brief Obj struct for InternetGatewayDevice.Services.VoiceService.{i}.X_BROADCOM_COM_Ntr.History.{i}.
 *
 * MDMOID_VOICE_NTR_HISTORY 574
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    SINT32    autoSteps;	/**< ReadWrite */
    char *    autoOffset;	/**< ReadWrite */
    char *    autoPpm;	/**< ReadWrite */
    SINT32    autoPhaseError;	/**< ReadWrite */
} VoiceNtrHistoryObject;

/*! \brief _VoiceNtrHistoryObject is used internally to represent VoiceNtrHistoryObject */
typedef VoiceNtrHistoryObject _VoiceNtrHistoryObject;



/*! \brief Obj struct for InternetGatewayDevice.Services.VoiceService.{i}.DECTInterface.
 *
 * MDMOID_VOICE_DECT_SYSTEM_SETTING 575
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    X_BROADCOM_COM_LinkDate;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_Type;	/**< ReadOnly */
    char *    X_BROADCOM_COM_DectId;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_MANIC;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_MODIC;	/**< ReadOnly */
    UINT32    numberOfHandsets;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_MaxNumberOfHandsets;	/**< ReadOnly */
    UBOOL8    waitingSubscription;	/**< ReadOnly */
    UBOOL8    X_BROADCOM_COM_ServiceEnabled;	/**< ReadOnly */
    char *    X_BROADCOM_COM_AccessCode;	/**< ReadWrite */
} VoiceDectSystemSettingObject;

/*! \brief _VoiceDectSystemSettingObject is used internally to represent VoiceDectSystemSettingObject */
typedef VoiceDectSystemSettingObject _VoiceDectSystemSettingObject;



/*! \brief Obj struct for InternetGatewayDevice.Services.VoiceService.{i}.DECTInterface.Handset.{i}.
 *
 * MDMOID_DECT_HANDSET 576
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    status;	/**< ReadOnly */
    char *    IPEI;	/**< ReadOnly */
    DATETIME  subscriptionTime;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_MANIC;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_MODIC;	/**< ReadOnly */
    char *    X_BROADCOM_COM_IPUI;	/**< ReadWrite */
    UINT32    X_BROADCOM_COM_ID;	/**< ReadWrite */
    char *    X_BROADCOM_COM_Name;	/**< ReadWrite */
    char *    X_BROADCOM_COM_Call_Interception;	/**< ReadWrite */
    UBOOL8    X_BROADCOM_COM_Delete;	/**< ReadWrite */
} VoiceDECTHandsetObject;

/*! \brief _VoiceDECTHandsetObject is used internally to represent VoiceDECTHandsetObject */
typedef VoiceDECTHandsetObject _VoiceDECTHandsetObject;



/*! \brief Obj struct for InternetGatewayDevice.Services.VoiceService.{i}.DECTInterface.PINCode.
 *
 * MDMOID_VOICE_DECT_PIN_CODE 577
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    element;	/**< ReadWrite */
} VoiceDectPinCodeObject;

/*! \brief _VoiceDectPinCodeObject is used internally to represent VoiceDectPinCodeObject */
typedef VoiceDectPinCodeObject _VoiceDectPinCodeObject;



/*! \brief Obj struct for InternetGatewayDevice.Services.VoiceService.{i}.DECTInterface.ClockMaster.
 *
 * MDMOID_VOICE_DECT_CLOCK_MASTER 578
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    element;	/**< ReadWrite */
} VoiceDectClockMasterObject;

/*! \brief _VoiceDectClockMasterObject is used internally to represent VoiceDectClockMasterObject */
typedef VoiceDectClockMasterObject _VoiceDectClockMasterObject;



/*! \brief Obj struct for InternetGatewayDevice.Services.VoiceService.{i}.DECTInterface.ResetBase.
 *
 * MDMOID_VOICE_DECT_RESET_BASE 579
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    element;	/**< ReadWrite */
} VoiceDectResetBaseObject;

/*! \brief _VoiceDectResetBaseObject is used internally to represent VoiceDectResetBaseObject */
typedef VoiceDectResetBaseObject _VoiceDectResetBaseObject;



/*! \brief Obj struct for InternetGatewayDevice.Services.VoiceService.{i}.DECTInterface.FirmwareVersion.
 *
 * MDMOID_VOICE_DECT_FIRMWARE_VERSION 580
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    element;	/**< ReadOnly */
} VoiceDectFirmwareVersionObject;

/*! \brief _VoiceDectFirmwareVersionObject is used internally to represent VoiceDectFirmwareVersionObject */
typedef VoiceDectFirmwareVersionObject _VoiceDectFirmwareVersionObject;



/*! \brief Obj struct for InternetGatewayDevice.Services.VoiceService.{i}.DECTInterface.HardwareVersion.
 *
 * MDMOID_VOICE_DECT_HARDWARE_VERSION 581
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    element;	/**< ReadOnly */
} VoiceDectHardwareVersionObject;

/*! \brief _VoiceDectHardwareVersionObject is used internally to represent VoiceDectHardwareVersionObject */
typedef VoiceDectHardwareVersionObject _VoiceDectHardwareVersionObject;



/*! \brief Obj struct for InternetGatewayDevice.Services.VoiceService.{i}.DECTInterface.EEPROMVersion.
 *
 * MDMOID_EEPROM_VERSION 582
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    element;	/**< ReadOnly */
} VoiceDectEEPROMVersionObject;

/*! \brief _VoiceDectEEPROMVersionObject is used internally to represent VoiceDectEEPROMVersionObject */
typedef VoiceDectEEPROMVersionObject _VoiceDectEEPROMVersionObject;



/*! \brief Obj struct for InternetGatewayDevice.XMPP.
 *
 * MDMOID_DEV2_XMPP 1900
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    connectionNumberOfEntries;	/**< ReadOnly */
} Dev2XmppObject;

/*! \brief _Dev2XmppObject is used internally to represent Dev2XmppObject */
typedef Dev2XmppObject _Dev2XmppObject;



/*! \brief Obj struct for InternetGatewayDevice.XMPP.Connection.{i}.
 *
 * MDMOID_DEV2_XMPP_CONN 1901
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    username;	/**< ReadWrite */
    char *    password;	/**< ReadWrite */
    char *    domain;	/**< ReadWrite */
    char *    resource;	/**< ReadWrite */
    char *    jabberID;	/**< ReadOnly */
    char *    status;	/**< ReadOnly */
    DATETIME  lastChangeDate;	/**< ReadOnly */
#ifdef DMP_DEVICE2_XMPPADVANCED_1
    char *    serverConnectAlgorithm;	/**< ReadWrite */
#endif
#ifdef DMP_DEVICE2_XMPPADVANCED_1
    SINT64    keepAliveInterval;	/**< ReadWrite */
#endif
    UINT32    serverRetryMaxInterval;	/**< ReadWrite */
    SINT32    serverRetryAttempts;	/**< ReadWrite */
#ifdef DMP_DEVICE2_XMPPADVANCED_1
    UBOOL8    useTLS;	/**< ReadWrite */
#endif
#ifdef DMP_DEVICE2_XMPPADVANCED_1
    UBOOL8    TLSEstablished;	/**< ReadOnly */
#endif
#ifdef DMP_DEVICE2_XMPPADVANCED_1
    UINT32    serverNumberOfEntries;	/**< ReadOnly */
#endif
} Dev2XmppConnObject;

/*! \brief _Dev2XmppConnObject is used internally to represent Dev2XmppConnObject */
typedef Dev2XmppConnObject _Dev2XmppConnObject;



/*! \brief Obj struct for InternetGatewayDevice.XMPP.Connection.{i}.Server.{i}.
 *
 * MDMOID_DEV2_XMPP_CONN_SERVER 1902
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    alias;	/**< ReadWrite */
    UINT32    priority;	/**< ReadWrite */
    SINT32    weight;	/**< ReadWrite */
    char *    serverAddress;	/**< ReadWrite */
    UINT32    port;	/**< ReadWrite */
} Dev2XmppConnServerObject;

/*! \brief _Dev2XmppConnServerObject is used internally to represent Dev2XmppConnServerObject */
typedef Dev2XmppConnServerObject _Dev2XmppConnServerObject;



/*! \brief Obj struct for InternetGatewayDevice.SoftwareModules.
 *
 * MDMOID_SW_MODULES 1820
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    execEnvNumberOfEntries;	/**< ReadOnly */
    UINT32    deploymentUnitNumberOfEntries;	/**< ReadOnly */
    UINT32    executionUnitNumberOfEntries;	/**< ReadOnly */
    UBOOL8    X_BROADCOM_COM_PreinstallNeeded;	/**< ReadWrite */
    UBOOL8    X_BROADCOM_COM_PreinstallAtRuntime;	/**< ReadWrite */
    UBOOL8    X_BROADCOM_COM_PreinstallOverwrite;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_MaxDUEntries;	/**< ReadWrite */
} SwModulesObject;

/*! \brief _SwModulesObject is used internally to represent SwModulesObject */
typedef SwModulesObject _SwModulesObject;



/*! \brief Obj struct for InternetGatewayDevice.SoftwareModules.ExecEnv.{i}.
 *
 * MDMOID_EXEC_ENV 1821
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    status;	/**< ReadOnly */
    UBOOL8    reset;	/**< ReadWrite */
    char *    alias;	/**< ReadWrite */
    char *    name;	/**< ReadOnly */
    char *    type;	/**< ReadOnly */
    UINT32    initialRunLevel;	/**< ReadWrite */
    SINT32    requestedRunLevel;	/**< ReadWrite */
    SINT32    currentRunLevel;	/**< ReadOnly */
    SINT32    initialExecutionUnitRunLevel;	/**< ReadWrite */
    char *    vendor;	/**< ReadOnly */
    char *    version;	/**< ReadOnly */
    char *    parentExecEnv;	/**< ReadOnly */
    SINT32    allocatedDiskSpace;	/**< ReadOnly */
    SINT32    availableDiskSpace;	/**< ReadOnly */
    SINT32    allocatedMemory;	/**< ReadOnly */
    SINT32    availableMemory;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_MngrEid;	/**< ReadOnly */
    char *    X_BROADCOM_COM_ContainerName;	/**< ReadOnly */
    char *    X_BROADCOM_COM_MngrAppName;	/**< ReadOnly */
    UBOOL8    X_BROADCOM_COM_IsPreinstall;	/**< ReadWrite */
    char *    X_BROADCOM_COM_Username;	/**< ReadOnly */
    SINT32    X_BROADCOM_COM_UidBase;	/**< ReadOnly */
    char *    X_BROADCOM_COM_IPv4Addresses;	/**< ReadOnly */
    char *    X_BROADCOM_COM_IPv6Addresses;	/**< ReadOnly */
    SINT32    X_BROADCOM_COM_MaxActiveContainers;	/**< ReadWrite */
    UINT32    X_BROADCOM_COM_NumberOfActiveContainers;	/**< ReadOnly */
} ExecEnvObject;

/*! \brief _ExecEnvObject is used internally to represent ExecEnvObject */
typedef ExecEnvObject _ExecEnvObject;



/*! \brief Obj struct for InternetGatewayDevice.SoftwareModules.ExecEnv.{i}.X_BROADCOM_COM_Manifest.
 *
 * MDMOID_EE_MANIFEST 1822
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    isPrivileged;	/**< ReadOnly */
    UBOOL8    enableAfterInstall;	/**< ReadOnly */
    UBOOL8    accessHostFiles;	/**< ReadOnly */
    char *    exposedPorts;	/**< ReadOnly */
} EeManifestObject;

/*! \brief _EeManifestObject is used internally to represent EeManifestObject */
typedef EeManifestObject _EeManifestObject;



/*! \brief Obj struct for InternetGatewayDevice.SoftwareModules.ExecEnv.{i}.X_BROADCOM_COM_Manifest.Bus.
 *
 * MDMOID_EE_BUS 1823
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    busInfo;	/**< ReadOnly */
} EeBusObject;

/*! \brief _EeBusObject is used internally to represent EeBusObject */
typedef EeBusObject _EeBusObject;



/*! \brief Obj struct for InternetGatewayDevice.SoftwareModules.ExecEnv.{i}.X_BROADCOM_COM_Manifest.Process.
 *
 * MDMOID_EE_PROCESS 1824
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    apparmorProfile;	/**< ReadOnly */
} EeProcessObject;

/*! \brief _EeProcessObject is used internally to represent EeProcessObject */
typedef EeProcessObject _EeProcessObject;



/*! \brief Obj struct for InternetGatewayDevice.SoftwareModules.ExecEnv.{i}.X_BROADCOM_COM_Manifest.Process.Args.{i}.
 *
 * MDMOID_EE_PROCESS_ARGS 1825
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    arg;	/**< ReadOnly */
} EeProcessArgsObject;

/*! \brief _EeProcessArgsObject is used internally to represent EeProcessArgsObject */
typedef EeProcessArgsObject _EeProcessArgsObject;



/*! \brief Obj struct for InternetGatewayDevice.SoftwareModules.ExecEnv.{i}.X_BROADCOM_COM_Manifest.Process.Env.{i}.
 *
 * MDMOID_EE_PROCESS_ENV 1826
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    envVar;	/**< ReadOnly */
} EeProcessEnvObject;

/*! \brief _EeProcessEnvObject is used internally to represent EeProcessEnvObject */
typedef EeProcessEnvObject _EeProcessEnvObject;



/*! \brief Obj struct for InternetGatewayDevice.SoftwareModules.ExecEnv.{i}.X_BROADCOM_COM_Manifest.Mounts.{i}.
 *
 * MDMOID_EE_MOUNTS 1827
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    destination;	/**< ReadOnly */
    char *    source;	/**< ReadOnly */
    char *    type;	/**< ReadOnly */
} EeMountsObject;

/*! \brief _EeMountsObject is used internally to represent EeMountsObject */
typedef EeMountsObject _EeMountsObject;



/*! \brief Obj struct for InternetGatewayDevice.SoftwareModules.ExecEnv.{i}.X_BROADCOM_COM_Manifest.Mounts.{i}.Options.{i}.
 *
 * MDMOID_EE_MOUNTS_OPTION 1828
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    option;	/**< ReadOnly */
} EeMountsOptionObject;

/*! \brief _EeMountsOptionObject is used internally to represent EeMountsOptionObject */
typedef EeMountsOptionObject _EeMountsOptionObject;



/*! \brief Obj struct for InternetGatewayDevice.SoftwareModules.ExecEnv.{i}.X_BROADCOM_COM_Manifest.Linux.
 *
 * MDMOID_EE_LINUX 1829
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
} EeLinuxObject;

/*! \brief _EeLinuxObject is used internally to represent EeLinuxObject */
typedef EeLinuxObject _EeLinuxObject;



/*! \brief Obj struct for InternetGatewayDevice.SoftwareModules.ExecEnv.{i}.X_BROADCOM_COM_Manifest.Linux.Resources.
 *
 * MDMOID_EE_RESOURCE 1830
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
} EeResourceObject;

/*! \brief _EeResourceObject is used internally to represent EeResourceObject */
typedef EeResourceObject _EeResourceObject;



/*! \brief Obj struct for InternetGatewayDevice.SoftwareModules.ExecEnv.{i}.X_BROADCOM_COM_Manifest.Linux.Resources.BlockIO.{i}.
 *
 * MDMOID_EE_BLKIO 1831
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    type;	/**< ReadOnly */
    SINT64    major;	/**< ReadOnly */
    SINT64    minor;	/**< ReadOnly */
    UINT64    rate;	/**< ReadOnly */
} EeBlkioObject;

/*! \brief _EeBlkioObject is used internally to represent EeBlkioObject */
typedef EeBlkioObject _EeBlkioObject;



/*! \brief Obj struct for InternetGatewayDevice.SoftwareModules.ExecEnv.{i}.X_BROADCOM_COM_Manifest.Linux.Resources.CPU.
 *
 * MDMOID_EE_CPU 1832
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    SINT64    quota;	/**< ReadOnly */
    UINT32    realtimeRuntime;	/**< ReadOnly */
    char *    cpus;	/**< ReadOnly */
} EeCpuObject;

/*! \brief _EeCpuObject is used internally to represent EeCpuObject */
typedef EeCpuObject _EeCpuObject;



/*! \brief Obj struct for InternetGatewayDevice.SoftwareModules.ExecEnv.{i}.X_BROADCOM_COM_Manifest.Linux.Resources.Devices.{i}.
 *
 * MDMOID_EE_RES_DEVICES 1833
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    allow;	/**< ReadOnly */
    char *    type;	/**< ReadOnly */
    SINT64    major;	/**< ReadOnly */
    SINT64    minor;	/**< ReadOnly */
    char *    access;	/**< ReadOnly */
} EeResDevicesObject;

/*! \brief _EeResDevicesObject is used internally to represent EeResDevicesObject */
typedef EeResDevicesObject _EeResDevicesObject;



/*! \brief Obj struct for InternetGatewayDevice.SoftwareModules.ExecEnv.{i}.X_BROADCOM_COM_Manifest.Linux.Resources.NetworkSetup.
 *
 * MDMOID_EE_NETWORK_SETUP 1834
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    networkMode;	/**< ReadOnly */
} EeNetworkSetupObject;

/*! \brief _EeNetworkSetupObject is used internally to represent EeNetworkSetupObject */
typedef EeNetworkSetupObject _EeNetworkSetupObject;



/*! \brief Obj struct for InternetGatewayDevice.SoftwareModules.ExecEnv.{i}.X_BROADCOM_COM_Manifest.Linux.Devices.{i}.
 *
 * MDMOID_EE_DEVICES 1835
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    path;	/**< ReadOnly */
    char *    type;	/**< ReadOnly */
    SINT64    major;	/**< ReadOnly */
    SINT64    minor;	/**< ReadOnly */
} EeDevicesObject;

/*! \brief _EeDevicesObject is used internally to represent EeDevicesObject */
typedef EeDevicesObject _EeDevicesObject;



/*! \brief Obj struct for InternetGatewayDevice.SoftwareModules.ExecEnv.{i}.X_BROADCOM_COM_Manifest.Linux.Hooks.
 *
 * MDMOID_EE_HOOKS 1836
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
} EeHooksObject;

/*! \brief _EeHooksObject is used internally to represent EeHooksObject */
typedef EeHooksObject _EeHooksObject;



/*! \brief Obj struct for InternetGatewayDevice.SoftwareModules.ExecEnv.{i}.X_BROADCOM_COM_Manifest.Linux.Hooks.Presetup.{i}.
 *
 * MDMOID_EE_PRESETUP 1837
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    path;	/**< ReadOnly */
    UINT64    timeout;	/**< ReadOnly */
} EePresetupObject;

/*! \brief _EePresetupObject is used internally to represent EePresetupObject */
typedef EePresetupObject _EePresetupObject;



/*! \brief Obj struct for InternetGatewayDevice.SoftwareModules.ExecEnv.{i}.X_BROADCOM_COM_Manifest.Linux.Hooks.Presetup.{i}.Args.{i}.
 *
 * MDMOID_EE_PRESETUP_ARGS 1838
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    arg;	/**< ReadOnly */
} EePresetupArgsObject;

/*! \brief _EePresetupArgsObject is used internally to represent EePresetupArgsObject */
typedef EePresetupArgsObject _EePresetupArgsObject;



/*! \brief Obj struct for InternetGatewayDevice.SoftwareModules.ExecEnv.{i}.X_BROADCOM_COM_Manifest.Linux.Hooks.Prestart.{i}.
 *
 * MDMOID_EE_PRESTART 1839
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    path;	/**< ReadOnly */
    UINT64    timeout;	/**< ReadOnly */
} EePrestartObject;

/*! \brief _EePrestartObject is used internally to represent EePrestartObject */
typedef EePrestartObject _EePrestartObject;



/*! \brief Obj struct for InternetGatewayDevice.SoftwareModules.ExecEnv.{i}.X_BROADCOM_COM_Manifest.Linux.Hooks.Prestart.{i}.Args.{i}.
 *
 * MDMOID_EE_PRESTART_ARGS 1840
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    arg;	/**< ReadOnly */
} EePrestartArgsObject;

/*! \brief _EePrestartArgsObject is used internally to represent EePrestartArgsObject */
typedef EePrestartArgsObject _EePrestartArgsObject;



/*! \brief Obj struct for InternetGatewayDevice.SoftwareModules.ExecEnv.{i}.X_BROADCOM_COM_Manifest.Linux.Hooks.Poststart.{i}.
 *
 * MDMOID_EE_POSTSTART 1841
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    path;	/**< ReadOnly */
    UINT64    timeout;	/**< ReadOnly */
} EePoststartObject;

/*! \brief _EePoststartObject is used internally to represent EePoststartObject */
typedef EePoststartObject _EePoststartObject;



/*! \brief Obj struct for InternetGatewayDevice.SoftwareModules.ExecEnv.{i}.X_BROADCOM_COM_Manifest.Linux.Hooks.Poststart.{i}.Args.{i}.
 *
 * MDMOID_EE_POSTSTART_ARGS 1842
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    arg;	/**< ReadOnly */
} EePoststartArgsObject;

/*! \brief _EePoststartArgsObject is used internally to represent EePoststartArgsObject */
typedef EePoststartArgsObject _EePoststartArgsObject;



/*! \brief Obj struct for InternetGatewayDevice.SoftwareModules.ExecEnv.{i}.X_BROADCOM_COM_Manifest.Linux.Hooks.Poststop.{i}.
 *
 * MDMOID_EE_POSTSTOP 1843
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    path;	/**< ReadOnly */
    UINT64    timeout;	/**< ReadOnly */
} EePoststopObject;

/*! \brief _EePoststopObject is used internally to represent EePoststopObject */
typedef EePoststopObject _EePoststopObject;



/*! \brief Obj struct for InternetGatewayDevice.SoftwareModules.ExecEnv.{i}.X_BROADCOM_COM_Manifest.Linux.Hooks.Poststop.{i}.Args.{i}.
 *
 * MDMOID_EE_POSTSTOP_ARGS 1844
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    arg;	/**< ReadOnly */
} EePoststopArgsObject;

/*! \brief _EePoststopArgsObject is used internally to represent EePoststopArgsObject */
typedef EePoststopArgsObject _EePoststopArgsObject;



/*! \brief Obj struct for InternetGatewayDevice.SoftwareModules.ExecEnv.{i}.X_BROADCOM_COM_NetworkInfo.
 *
 * MDMOID_EE_NETWORK 1845
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    primaryIfName;	/**< ReadOnly */
    char *    primaryIfAddr;	/**< ReadOnly */
    char *    secondaryIfName;	/**< ReadOnly */
    char *    secondaryIfAddr;	/**< ReadOnly */
    char *    wanOnlyIfName;	/**< ReadOnly */
    char *    wanOnlyIfAddr;	/**< ReadOnly */
} EeNetworkObject;

/*! \brief _EeNetworkObject is used internally to represent EeNetworkObject */
typedef EeNetworkObject _EeNetworkObject;



/*! \brief Obj struct for InternetGatewayDevice.SoftwareModules.DeploymentUnit.{i}.
 *
 * MDMOID_DU 1846
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    UUID;	/**< ReadOnly */
    char *    DUID;	/**< ReadOnly */
    char *    alias;	/**< ReadWrite */
    char *    name;	/**< ReadOnly */
    char *    status;	/**< ReadOnly */
    UBOOL8    resolved;	/**< ReadOnly */
    char *    URL;	/**< ReadOnly */
    char *    X_BROADCOM_COM_Username;	/**< ReadOnly */
    char *    X_BROADCOM_COM_Password;	/**< ReadOnly */
    char *    description;	/**< ReadOnly */
    char *    vendor;	/**< ReadOnly */
    char *    version;	/**< ReadOnly */
    char *    executionUnitList;	/**< ReadOnly */
    char *    executionEnvRef;	/**< ReadOnly */
    char *    X_BROADCOM_COM_ExecutionEnvList;	/**< ReadOnly */
    DATETIME  X_BROADCOM_COM_startTime;	/**< ReadOnly */
    DATETIME  X_BROADCOM_COM_completeTime;	/**< ReadOnly */
    SINT32    X_BROADCOM_COM_bundleId;	/**< ReadOnly */
    UBOOL8    X_BROADCOM_COM_IsPreinstall;	/**< ReadWrite */
} DUObject;

/*! \brief _DUObject is used internally to represent DUObject */
typedef DUObject _DUObject;



/*! \brief Obj struct for InternetGatewayDevice.SoftwareModules.ExecutionUnit.{i}.
 *
 * MDMOID_EU 1847
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    EUID;	/**< ReadOnly */
    char *    alias;	/**< ReadWrite */
    char *    name;	/**< ReadOnly */
    char *    execEnvLabel;	/**< ReadOnly */
    char *    status;	/**< ReadOnly */
    char *    requestedState;	/**< ReadWrite */
    char *    executionFaultCode;	/**< ReadOnly */
    char *    executionFaultMessage;	/**< ReadOnly */
    char *    X_BROADCOM_COM_StateChangeReason;	/**< ReadOnly */
    DATETIME  X_BROADCOM_COM_State_LastChange;	/**< ReadOnly */
    UBOOL8    autoStart;	/**< ReadWrite */
    UINT32    runLevel;	/**< ReadWrite */
    char *    vendor;	/**< ReadOnly */
    char *    version;	/**< ReadOnly */
    char *    description;	/**< ReadOnly */
    SINT32    diskSpaceInUse;	/**< ReadOnly */
    SINT32    memoryInUse;	/**< ReadOnly */
    char *    associatedProcessList;	/**< ReadOnly */
    char *    executionEnvRef;	/**< ReadOnly */
    SINT32    X_BROADCOM_COM_bundleId;	/**< ReadOnly */
    char *    X_BROADCOM_COM_appDigest;	/**< ReadOnly */
    char *    X_BROADCOM_COM_ManifestDigest;	/**< ReadOnly */
    char *    X_BROADCOM_COM_MediaType;	/**< ReadOnly */
    char *    X_BROADCOM_COM_Username;	/**< ReadOnly */
    char *    X_BROADCOM_COM_MngrAppName;	/**< ReadOnly */
    char *    X_BROADCOM_COM_IPv4Addresses;	/**< ReadOnly */
    char *    X_BROADCOM_COM_IPv6Addresses;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_autoStartOrder;	/**< ReadWrite */
    UBOOL8    X_BROADCOM_COM_autoRelaunch;	/**< ReadWrite */
    UINT32    X_BROADCOM_COM_maxRestarts;	/**< ReadWrite */
    UINT32    X_BROADCOM_COM_restartInterval;	/**< ReadWrite */
    UINT32    X_BROADCOM_COM_successfulStartPeriod;	/**< ReadWrite */
    UINT32    X_BROADCOM_COM_restartCount;	/**< ReadOnly */
    char *    X_BROADCOM_COM_ContainerName;	/**< ReadOnly */
} EUObject;

/*! \brief _EUObject is used internally to represent EUObject */
typedef EUObject _EUObject;



/*! \brief Obj struct for InternetGatewayDevice.SoftwareModules.ExecutionUnit.{i}.Extensions.
 *
 * MDMOID_EXTENSIONS 1848
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
} ExtensionsObject;

/*! \brief _ExtensionsObject is used internally to represent ExtensionsObject */
typedef ExtensionsObject _ExtensionsObject;



/*! \brief Obj struct for InternetGatewayDevice.SoftwareModules.ExecutionUnit.{i}.Extensions.X_BROADCOM_COM_Bus.
 *
 * MDMOID_BUS 1849
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    name;	/**< ReadOnly */
    UINT32    objectPathNumberOfEntries;	/**< ReadOnly */
    char *    serviceStatus;	/**< ReadOnly */
} BusObject;

/*! \brief _BusObject is used internally to represent BusObject */
typedef BusObject _BusObject;



/*! \brief Obj struct for InternetGatewayDevice.SoftwareModules.ExecutionUnit.{i}.Extensions.X_BROADCOM_COM_Bus.ObjectPath.{i}.
 *
 * MDMOID_BUS_OBJECT_PATH 1850
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    path;	/**< ReadOnly */
    UINT32    interfaceNumberOfEntries;	/**< ReadOnly */
} BusObjectPathObject;

/*! \brief _BusObjectPathObject is used internally to represent BusObjectPathObject */
typedef BusObjectPathObject _BusObjectPathObject;



/*! \brief Obj struct for InternetGatewayDevice.SoftwareModules.ExecutionUnit.{i}.Extensions.X_BROADCOM_COM_Bus.ObjectPath.{i}.Interface.{i}.
 *
 * MDMOID_BUS_INTERFACE 1851
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    name;	/**< ReadOnly */
    UINT32    methodNumberOfEntries;	/**< ReadOnly */
    UINT32    signalNumberOfEntries;	/**< ReadOnly */
    UINT32    propertyNumberOfEntries;	/**< ReadOnly */
} BusInterfaceObject;

/*! \brief _BusInterfaceObject is used internally to represent BusInterfaceObject */
typedef BusInterfaceObject _BusInterfaceObject;



/*! \brief Obj struct for InternetGatewayDevice.SoftwareModules.ExecutionUnit.{i}.Extensions.X_BROADCOM_COM_Bus.ObjectPath.{i}.Interface.{i}.Method.{i}.
 *
 * MDMOID_BUS_METHOD 1852
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    name;	/**< ReadOnly */
} BusMethodObject;

/*! \brief _BusMethodObject is used internally to represent BusMethodObject */
typedef BusMethodObject _BusMethodObject;



/*! \brief Obj struct for InternetGatewayDevice.SoftwareModules.ExecutionUnit.{i}.Extensions.X_BROADCOM_COM_Bus.ObjectPath.{i}.Interface.{i}.Signal.{i}.
 *
 * MDMOID_BUS_SIGNAL 1853
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    name;	/**< ReadOnly */
} BusSignalObject;

/*! \brief _BusSignalObject is used internally to represent BusSignalObject */
typedef BusSignalObject _BusSignalObject;



/*! \brief Obj struct for InternetGatewayDevice.SoftwareModules.ExecutionUnit.{i}.Extensions.X_BROADCOM_COM_Bus.ObjectPath.{i}.Interface.{i}.Property.{i}.
 *
 * MDMOID_BUS_PROPERTY 1854
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    name;	/**< ReadOnly */
} BusPropertyObject;

/*! \brief _BusPropertyObject is used internally to represent BusPropertyObject */
typedef BusPropertyObject _BusPropertyObject;



/*! \brief Obj struct for InternetGatewayDevice.SoftwareModules.ExecutionUnit.{i}.Extensions.X_BROADCOM_COM_BusClient.
 *
 * MDMOID_BUS_CLIENT 1855
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    name;	/**< ReadOnly */
    UINT32    privilegeNumberOfEntries;	/**< ReadOnly */
} BusClientObject;

/*! \brief _BusClientObject is used internally to represent BusClientObject */
typedef BusClientObject _BusClientObject;



/*! \brief Obj struct for InternetGatewayDevice.SoftwareModules.ExecutionUnit.{i}.Extensions.X_BROADCOM_COM_BusClient.Privilege.{i}.
 *
 * MDMOID_BUS_CLIENT_PRIVILEGE 1856
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    wellknownName;	/**< ReadWrite */
    char *    objectPath;	/**< ReadWrite */
    char *    interface;	/**< ReadWrite */
    char *    member;	/**< ReadWrite */
    char *    memberType;	/**< ReadWrite */
} BusClientPrivilegeObject;

/*! \brief _BusClientPrivilegeObject is used internally to represent BusClientPrivilegeObject */
typedef BusClientPrivilegeObject _BusClientPrivilegeObject;



/*! \brief Obj struct for InternetGatewayDevice.SoftwareModules.ExecutionUnit.{i}.Extensions.X_BROADCOM_COM_Manifest.
 *
 * MDMOID_MANIFEST 1857
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    user;	/**< ReadOnly */
    SINT64    maxMemory;	/**< ReadOnly */
    SINT32    maxFlashSize;	/**< ReadOnly */
    char *    networkMode;	/**< ReadOnly */
    UINT32    interfaceIdentifier;	/**< ReadOnly */
    char *    exposedPorts;	/**< ReadOnly */
    UINT32    realtimeRuntime;	/**< ReadOnly */
    char *    cpus;	/**< ReadOnly */
} ManifestObject;

/*! \brief _ManifestObject is used internally to represent ManifestObject */
typedef ManifestObject _ManifestObject;



/*! \brief Obj struct for InternetGatewayDevice.SoftwareModules.ExecutionUnit.{i}.Extensions.X_BROADCOM_COM_Manifest.Bus.
 *
 * MDMOID_EU_BUS 1858
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    busInfo;	/**< ReadOnly */
} EuBusObject;

/*! \brief _EuBusObject is used internally to represent EuBusObject */
typedef EuBusObject _EuBusObject;



/*! \brief Obj struct for InternetGatewayDevice.SoftwareModules.ExecutionUnit.{i}.Extensions.X_BROADCOM_COM_Manifest.Process.
 *
 * MDMOID_EU_PROCESS 1859
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    apparmorProfile;	/**< ReadOnly */
} EuProcessObject;

/*! \brief _EuProcessObject is used internally to represent EuProcessObject */
typedef EuProcessObject _EuProcessObject;



/*! \brief Obj struct for InternetGatewayDevice.SoftwareModules.ExecutionUnit.{i}.Extensions.X_BROADCOM_COM_Manifest.Process.Args.{i}.
 *
 * MDMOID_EU_PROCESS_ARGS 1860
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    arg;	/**< ReadOnly */
} EuProcessArgsObject;

/*! \brief _EuProcessArgsObject is used internally to represent EuProcessArgsObject */
typedef EuProcessArgsObject _EuProcessArgsObject;



/*! \brief Obj struct for InternetGatewayDevice.SoftwareModules.ExecutionUnit.{i}.Extensions.X_BROADCOM_COM_Manifest.Process.Env.{i}.
 *
 * MDMOID_EU_PROCESS_ENV 1861
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    envVar;	/**< ReadOnly */
} EuProcessEnvObject;

/*! \brief _EuProcessEnvObject is used internally to represent EuProcessEnvObject */
typedef EuProcessEnvObject _EuProcessEnvObject;



/*! \brief Obj struct for InternetGatewayDevice.SoftwareModules.ExecutionUnit.{i}.Extensions.X_BROADCOM_COM_Manifest.Mounts.{i}.
 *
 * MDMOID_EU_MOUNTS 1862
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    destination;	/**< ReadOnly */
    char *    source;	/**< ReadOnly */
    char *    type;	/**< ReadOnly */
} EuMountsObject;

/*! \brief _EuMountsObject is used internally to represent EuMountsObject */
typedef EuMountsObject _EuMountsObject;



/*! \brief Obj struct for InternetGatewayDevice.SoftwareModules.ExecutionUnit.{i}.Extensions.X_BROADCOM_COM_Manifest.Mounts.{i}.Options.{i}.
 *
 * MDMOID_EU_MOUNTS_OPTION 1863
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    option;	/**< ReadOnly */
} EuMountsOptionObject;

/*! \brief _EuMountsOptionObject is used internally to represent EuMountsOptionObject */
typedef EuMountsOptionObject _EuMountsOptionObject;



/*! \brief Obj struct for InternetGatewayDevice.SoftwareModules.ExecutionUnit.{i}.Extensions.X_BROADCOM_COM_Manifest.Linux.
 *
 * MDMOID_EU_LINUX 1864
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
} EuLinuxObject;

/*! \brief _EuLinuxObject is used internally to represent EuLinuxObject */
typedef EuLinuxObject _EuLinuxObject;



/*! \brief Obj struct for InternetGatewayDevice.SoftwareModules.ExecutionUnit.{i}.Extensions.X_BROADCOM_COM_Manifest.Linux.Resources.
 *
 * MDMOID_EU_RESOURCE 1865
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
} EuResourceObject;

/*! \brief _EuResourceObject is used internally to represent EuResourceObject */
typedef EuResourceObject _EuResourceObject;



/*! \brief Obj struct for InternetGatewayDevice.SoftwareModules.ExecutionUnit.{i}.Extensions.X_BROADCOM_COM_Manifest.Linux.Resources.BlockIO.{i}.
 *
 * MDMOID_EU_BLKIO 1866
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    type;	/**< ReadOnly */
    SINT64    major;	/**< ReadOnly */
    SINT64    minor;	/**< ReadOnly */
    UINT64    rate;	/**< ReadOnly */
} EuBlkioObject;

/*! \brief _EuBlkioObject is used internally to represent EuBlkioObject */
typedef EuBlkioObject _EuBlkioObject;



/*! \brief Obj struct for InternetGatewayDevice.SoftwareModules.ExecutionUnit.{i}.Extensions.X_BROADCOM_COM_Manifest.Linux.Resources.CPU.
 *
 * MDMOID_EU_CPU 1867
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    SINT64    quota;	/**< ReadOnly */
} EuCpuObject;

/*! \brief _EuCpuObject is used internally to represent EuCpuObject */
typedef EuCpuObject _EuCpuObject;



/*! \brief Obj struct for InternetGatewayDevice.SoftwareModules.ExecutionUnit.{i}.Extensions.X_BROADCOM_COM_Manifest.Linux.Resources.Devices.{i}.
 *
 * MDMOID_EU_RES_DEVICES 1868
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    allow;	/**< ReadOnly */
    char *    type;	/**< ReadOnly */
    SINT64    major;	/**< ReadOnly */
    SINT64    minor;	/**< ReadOnly */
    char *    access;	/**< ReadOnly */
} EuResDevicesObject;

/*! \brief _EuResDevicesObject is used internally to represent EuResDevicesObject */
typedef EuResDevicesObject _EuResDevicesObject;



/*! \brief Obj struct for InternetGatewayDevice.SoftwareModules.ExecutionUnit.{i}.Extensions.X_BROADCOM_COM_Manifest.Linux.Devices.{i}.
 *
 * MDMOID_EU_DEVICES 1869
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    path;	/**< ReadOnly */
    char *    type;	/**< ReadOnly */
    SINT64    major;	/**< ReadOnly */
    SINT64    minor;	/**< ReadOnly */
} EuDevicesObject;

/*! \brief _EuDevicesObject is used internally to represent EuDevicesObject */
typedef EuDevicesObject _EuDevicesObject;



/*! \brief Obj struct for InternetGatewayDevice.SoftwareModules.ExecutionUnit.{i}.Extensions.X_BROADCOM_COM_Manifest.Linux.Hooks.
 *
 * MDMOID_EU_HOOKS 1870
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
} EuHooksObject;

/*! \brief _EuHooksObject is used internally to represent EuHooksObject */
typedef EuHooksObject _EuHooksObject;



/*! \brief Obj struct for InternetGatewayDevice.SoftwareModules.ExecutionUnit.{i}.Extensions.X_BROADCOM_COM_Manifest.Linux.Hooks.Presetup.{i}.
 *
 * MDMOID_EU_PRESETUP 1871
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    path;	/**< ReadOnly */
    UINT64    timeout;	/**< ReadOnly */
} EuPresetupObject;

/*! \brief _EuPresetupObject is used internally to represent EuPresetupObject */
typedef EuPresetupObject _EuPresetupObject;



/*! \brief Obj struct for InternetGatewayDevice.SoftwareModules.ExecutionUnit.{i}.Extensions.X_BROADCOM_COM_Manifest.Linux.Hooks.Presetup.{i}.Args.{i}.
 *
 * MDMOID_EU_PRESETUP_ARGS 1872
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    arg;	/**< ReadOnly */
} EuPresetupArgsObject;

/*! \brief _EuPresetupArgsObject is used internally to represent EuPresetupArgsObject */
typedef EuPresetupArgsObject _EuPresetupArgsObject;



/*! \brief Obj struct for InternetGatewayDevice.SoftwareModules.ExecutionUnit.{i}.Extensions.X_BROADCOM_COM_Manifest.Linux.Hooks.Prestart.{i}.
 *
 * MDMOID_EU_PRESTART 1873
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    path;	/**< ReadOnly */
    UINT64    timeout;	/**< ReadOnly */
} EuPrestartObject;

/*! \brief _EuPrestartObject is used internally to represent EuPrestartObject */
typedef EuPrestartObject _EuPrestartObject;



/*! \brief Obj struct for InternetGatewayDevice.SoftwareModules.ExecutionUnit.{i}.Extensions.X_BROADCOM_COM_Manifest.Linux.Hooks.Prestart.{i}.Args.{i}.
 *
 * MDMOID_EU_PRESTART_ARGS 1874
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    arg;	/**< ReadOnly */
} EuPrestartArgsObject;

/*! \brief _EuPrestartArgsObject is used internally to represent EuPrestartArgsObject */
typedef EuPrestartArgsObject _EuPrestartArgsObject;



/*! \brief Obj struct for InternetGatewayDevice.SoftwareModules.ExecutionUnit.{i}.Extensions.X_BROADCOM_COM_Manifest.Linux.Hooks.Poststart.{i}.
 *
 * MDMOID_EU_POSTSTART 1875
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    path;	/**< ReadOnly */
    UINT64    timeout;	/**< ReadOnly */
} EuPoststartObject;

/*! \brief _EuPoststartObject is used internally to represent EuPoststartObject */
typedef EuPoststartObject _EuPoststartObject;



/*! \brief Obj struct for InternetGatewayDevice.SoftwareModules.ExecutionUnit.{i}.Extensions.X_BROADCOM_COM_Manifest.Linux.Hooks.Poststart.{i}.Args.{i}.
 *
 * MDMOID_EU_POSTSTART_ARGS 1876
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    arg;	/**< ReadOnly */
} EuPoststartArgsObject;

/*! \brief _EuPoststartArgsObject is used internally to represent EuPoststartArgsObject */
typedef EuPoststartArgsObject _EuPoststartArgsObject;



/*! \brief Obj struct for InternetGatewayDevice.SoftwareModules.ExecutionUnit.{i}.Extensions.X_BROADCOM_COM_Manifest.Linux.Hooks.Poststop.{i}.
 *
 * MDMOID_EU_POSTSTOP 1877
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    path;	/**< ReadOnly */
    UINT64    timeout;	/**< ReadOnly */
} EuPoststopObject;

/*! \brief _EuPoststopObject is used internally to represent EuPoststopObject */
typedef EuPoststopObject _EuPoststopObject;



/*! \brief Obj struct for InternetGatewayDevice.SoftwareModules.ExecutionUnit.{i}.Extensions.X_BROADCOM_COM_Manifest.Linux.Hooks.Poststop.{i}.Args.{i}.
 *
 * MDMOID_EU_POSTSTOP_ARGS 1878
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    arg;	/**< ReadOnly */
} EuPoststopArgsObject;

/*! \brief _EuPoststopArgsObject is used internally to represent EuPoststopArgsObject */
typedef EuPoststopArgsObject _EuPoststopArgsObject;



/*! \brief Obj struct for InternetGatewayDevice.SoftwareModules.ExecutionUnit.{i}.Extensions.X_BROADCOM_COM_Manifest.Dependency.
 *
 * MDMOID_EU_DEPENDENCY 1879
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    libraries;	/**< ReadOnly */
} EuDependencyObject;

/*! \brief _EuDependencyObject is used internally to represent EuDependencyObject */
typedef EuDependencyObject _EuDependencyObject;



/*! \brief Obj struct for InternetGatewayDevice.SoftwareModules.ExecutionUnit.{i}.Extensions.X_BROADCOM_COM_Manifest.Seccomp.
 *
 * MDMOID_EU_SECCOMP 1880
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    defaultAction;	/**< ReadOnly */
} EuSeccompObject;

/*! \brief _EuSeccompObject is used internally to represent EuSeccompObject */
typedef EuSeccompObject _EuSeccompObject;



/*! \brief Obj struct for InternetGatewayDevice.SoftwareModules.ExecutionUnit.{i}.Extensions.X_BROADCOM_COM_Manifest.Seccomp.Syscalls.{i}.
 *
 * MDMOID_EU_SYSCALLS 1881
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    names;	/**< ReadOnly */
    char *    action;	/**< ReadOnly */
} EuSyscallsObject;

/*! \brief _EuSyscallsObject is used internally to represent EuSyscallsObject */
typedef EuSyscallsObject _EuSyscallsObject;



/*! \brief Obj struct for InternetGatewayDevice.SoftwareModules.ExecutionUnit.{i}.Extensions.X_BROADCOM_COM_Manifest.Seccomp.Syscalls.{i}.Args.{i}.
 *
 * MDMOID_EU_SYSCALL_ARGS 1882
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    index;	/**< ReadOnly */
    UINT64    value;	/**< ReadOnly */
    UINT64    valueTwo;	/**< ReadOnly */
    char *    op;	/**< ReadOnly */
} EuSyscallArgsObject;

/*! \brief _EuSyscallArgsObject is used internally to represent EuSyscallArgsObject */
typedef EuSyscallArgsObject _EuSyscallArgsObject;



/*! \brief Obj struct for InternetGatewayDevice.SoftwareModules.X_BROADCOM_COM_DmAccess.{i}.
 *
 * MDMOID_DM_ACCESS 1883
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    EUID;	/**< ReadWrite */
    char *    accessID;	/**< ReadWrite */
    char *    profileList;	/**< ReadWrite */
} DmAccessObject;

/*! \brief _DmAccessObject is used internally to represent DmAccessObject */
typedef DmAccessObject _DmAccessObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_SnmpCfg.
 *
 * MDMOID_SNMP_CFG 3181
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    status;	/**< ReadWrite */
    char *    ROCommunity;	/**< ReadWrite */
    char *    RWCommunity;	/**< ReadWrite */
    char *    sysName;	/**< ReadWrite */
    char *    sysLocation;	/**< ReadWrite */
    char *    sysContact;	/**< ReadWrite */
    char *    trapIPAddress;	/**< ReadWrite */
    char *    IPVersion;	/**< ReadWrite */
} SnmpCfgObject;

/*! \brief _SnmpCfgObject is used internally to represent SnmpCfgObject */
typedef SnmpCfgObject _SnmpCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_DbusRemoteCfg.
 *
 * MDMOID_DBUS_REMOTE_CFG 3288
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    UINT32    port;	/**< ReadWrite */
} DbusRemoteCfgObject;

/*! \brief _DbusRemoteCfgObject is used internally to represent DbusRemoteCfgObject */
typedef DbusRemoteCfgObject _DbusRemoteCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_SecDmzHostCfg.
 *
 * MDMOID_SEC_DMZ_HOST_CFG 3000
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    IPAddress;	/**< ReadWrite */
} SecDmzHostCfgObject;

/*! \brief _SecDmzHostCfgObject is used internally to represent SecDmzHostCfgObject */
typedef SecDmzHostCfgObject _SecDmzHostCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_AccessTimeRestriction.{i}.
 *
 * MDMOID_ACCESS_TIME_RESTRICTION 3001
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    username;	/**< ReadWrite */
    char *    startTime;	/**< ReadWrite */
    char *    endTime;	/**< ReadWrite */
    char *    days;	/**< ReadWrite */
    char *    MACAddress;	/**< ReadWrite */
} AccessTimeRestrictionObject;

/*! \brief _AccessTimeRestrictionObject is used internally to represent AccessTimeRestrictionObject */
typedef AccessTimeRestrictionObject _AccessTimeRestrictionObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_UrlFilterCfg.
 *
 * MDMOID_URL_FILTER_CFG 3002
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    excludeMode;	/**< ReadWrite */
} UrlFilterCfgObject;

/*! \brief _UrlFilterCfgObject is used internally to represent UrlFilterCfgObject */
typedef UrlFilterCfgObject _UrlFilterCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_UrlFilterCfg.X_BROADCOM_COM_UrlFilterListCfgObj.{i}.
 *
 * MDMOID_URL_FILTER_LIST 3003
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    urlAddress;	/**< ReadWrite */
    UINT32    portNumber;	/**< ReadWrite */
} UrlFilterListObject;

/*! \brief _UrlFilterListObject is used internally to represent UrlFilterListObject */
typedef UrlFilterListObject _UrlFilterListObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_DDnsCfg.{i}.
 *
 * MDMOID_D_DNS_CFG 3004
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    fullyQualifiedDomainName;	/**< ReadWrite */
    char *    userName;	/**< ReadWrite */
    char *    password;	/**< ReadWrite */
    char *    ifName;	/**< ReadWrite */
    char *    providerName;	/**< ReadWrite */
} DDnsCfgObject;

/*! \brief _DDnsCfgObject is used internally to represent DDnsCfgObject */
typedef DDnsCfgObject _DDnsCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_IPPCfg.
 *
 * MDMOID_IPP_CFG 3005
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    make;	/**< ReadWrite */
    char *    device;	/**< ReadWrite */
    char *    name;	/**< ReadWrite */
} IppCfgObject;

/*! \brief _IppCfgObject is used internally to represent IppCfgObject */
typedef IppCfgObject _IppCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_DLNA.
 *
 * MDMOID_DLNA 3190
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
} DlnaObject;

/*! \brief _DlnaObject is used internally to represent DlnaObject */
typedef DlnaObject _DlnaObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_DLNA.DmsCfg.
 *
 * MDMOID_DMS_CFG 3191
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    mediaPath;	/**< ReadWrite */
    UINT32    servicePort;	/**< ReadWrite */
    UINT32    brKey;	/**< ReadWrite */
} DmsCfgObject;

/*! \brief _DmsCfgObject is used internally to represent DmsCfgObject */
typedef DmsCfgObject _DmsCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_DebugPortMirroringCfg.{i}.
 *
 * MDMOID_WAN_DEBUG_PORT_MIRRORING_CFG 3006
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    monitorInterface;	/**< ReadWrite */
    char *    mirrorInterface;	/**< ReadWrite */
    UBOOL8    direction;	/**< ReadWrite */
    UBOOL8    status;	/**< ReadWrite */
} WanDebugPortMirroringCfgObject;

/*! \brief _WanDebugPortMirroringCfgObject is used internally to represent WanDebugPortMirroringCfgObject */
typedef WanDebugPortMirroringCfgObject _WanDebugPortMirroringCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_IPSecCfg.{i}.
 *
 * MDMOID_IP_SEC_CFG 3210
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    entryID;	/**< ReadWrite */
    UBOOL8    enable;	/**< ReadWrite */
    char *    connName;	/**< ReadWrite */
    char *    tunMode;	/**< ReadWrite */
    char *    ipVer;	/**< ReadWrite */
    char *    localGwIf;	/**< ReadWrite */
    char *    remoteGWAddress;	/**< ReadWrite */
    char *    localRangeLo;	/**< ReadWrite */
    char *    localRangeHi;	/**< ReadWrite */
    char *    localIPMode;	/**< ReadWrite */
    char *    localIPAddress;	/**< ReadWrite */
    char *    localMask;	/**< ReadWrite */
    char *    remoteRangeLo;	/**< ReadWrite */
    char *    remoteRangeHi;	/**< ReadWrite */
    char *    remoteIPMode;	/**< ReadWrite */
    char *    remoteIPAddress;	/**< ReadWrite */
    char *    remoteMask;	/**< ReadWrite */
    char *    keyExM;	/**< ReadWrite */
    char *    authM;	/**< ReadWrite */
    char *    PSK;	/**< ReadWrite */
    char *    certificateName;	/**< ReadWrite */
    char *    perfectFSEn;	/**< ReadWrite */
    char *    manualEncryptionAlgo;	/**< ReadWrite */
    char *    manualEncryptionKey;	/**< ReadWrite */
    char *    manualAuthAlgo;	/**< ReadWrite */
    char *    manualAthKey;	/**< ReadWrite */
    char *    SPI;	/**< ReadWrite */
    char *    ph1Mode;	/**< ReadWrite */
    char *    ph1EncryptionAlo;	/**< ReadWrite */
    char *    ph1IntegrityAlgo;	/**< ReadWrite */
    char *    ph1DHGroup;	/**< ReadWrite */
    UINT32    ph1KeyTime;	/**< ReadWrite */
    char *    ph2Mode;	/**< ReadWrite */
    char *    ph2EncryptionAlo;	/**< ReadWrite */
    char *    ph2IntegrityAlgo;	/**< ReadWrite */
    char *    ph2DHGroup;	/**< ReadWrite */
    UINT32    ph2KeyTime;	/**< ReadWrite */
} IPSecCfgObject;

/*! \brief _IPSecCfgObject is used internally to represent IPSecCfgObject */
typedef IPSecCfgObject _IPSecCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_CertificateCfg.{i}.
 *
 * MDMOID_CERTIFICATE_CFG 3200
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    name;	/**< ReadWrite */
    char *    subject;	/**< ReadWrite */
    char *    type;	/**< ReadWrite */
    char *    password;	/**< ReadWrite */
    char *    content;	/**< ReadWrite */
    char *    privKey;	/**< ReadWrite */
    char *    reqPub;	/**< ReadWrite */
    UINT32    refCount;	/**< ReadWrite */
} CertificateCfgObject;

/*! \brief _CertificateCfgObject is used internally to represent CertificateCfgObject */
typedef CertificateCfgObject _CertificateCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_WapiCertificate.
 *
 * MDMOID_WAPI_CERTIFICATE 3201
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
} WapiCertificateObject;

/*! \brief _WapiCertificateObject is used internally to represent WapiCertificateObject */
typedef WapiCertificateObject _WapiCertificateObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_WapiCertificate.WapiAsCertificate.
 *
 * MDMOID_WAPI_AS_CERTIFICATE 3202
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    certificateFlag;	/**< ReadWrite */
    SINT32    certificateLength;	/**< ReadWrite */
    char *    certificateContent;	/**< ReadWrite */
    UINT32    privateKeyFlag;	/**< ReadWrite */
    SINT32    privateKeyLength;	/**< ReadWrite */
    char *    privateKeyContent;	/**< ReadWrite */
} WapiAsCertificateObject;

/*! \brief _WapiAsCertificateObject is used internally to represent WapiAsCertificateObject */
typedef WapiAsCertificateObject _WapiAsCertificateObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_WapiCertificate.WapiIssuedCertificate.
 *
 * MDMOID_WAPI_ISSUED_CERTIFICATE 3203
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    asEnabled;	/**< ReadWrite */
    UINT32    lastUpdated;	/**< ReadWrite */
    char *    issuedList;	/**< ReadWrite */
    char *    revokedList;	/**< ReadWrite */
} WapiIssuedCertificateObject;

/*! \brief _WapiIssuedCertificateObject is used internally to represent WapiIssuedCertificateObject */
typedef WapiIssuedCertificateObject _WapiIssuedCertificateObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_NetworkConfig.
 *
 * MDMOID_NETWORK_CONFIG 3007
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    DNSIfName;	/**< ReadWrite */
    char *    DNSServers;	/**< ReadWrite */
    char *    activeDNSServers;	/**< ReadOnly */
    UBOOL8    enableAdvancedDMZ;	/**< ReadWrite */
} NetworkConfigObject;

/*! \brief _NetworkConfigObject is used internally to represent NetworkConfigObject */
typedef NetworkConfigObject _NetworkConfigObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_InterfaceControl.
 *
 * MDMOID_INTERFACE_CONTROL 3008
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    ifName;	/**< ReadWrite */
    UBOOL8    moveToWANSide;	/**< ReadWrite */
    UBOOL8    moveToLANSide;	/**< ReadWrite */
} InterfaceControlObject;

/*! \brief _InterfaceControlObject is used internally to represent InterfaceControlObject */
typedef InterfaceControlObject _InterfaceControlObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_EthernetOam.
 *
 * MDMOID_ETHERNET_OAM 3009
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
} EthernetOamObject;

/*! \brief _EthernetOamObject is used internally to represent EthernetOamObject */
typedef EthernetOamObject _EthernetOamObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_EthernetOam.Ieee8023ahCfg.
 *
 * MDMOID_IEEE8023AH_CFG 3010
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enabled;	/**< ReadWrite */
    char *    ifName;	/**< ReadWrite */
    UINT32    oamId;	/**< ReadWrite */
    UBOOL8    autoEventEnabled;	/**< ReadWrite */
    UBOOL8    variableRetrievalEnabled;	/**< ReadWrite */
    UBOOL8    linkEventsEnabled;	/**< ReadWrite */
    UBOOL8    remoteLoopbackEnabled;	/**< ReadWrite */
    UBOOL8    activeModeEnabled;	/**< ReadWrite */
    UINT32    tmsctl3ahPid;	/**< ReadOnly */
} Ieee8023ahCfgObject;

/*! \brief _Ieee8023ahCfgObject is used internally to represent Ieee8023ahCfgObject */
typedef Ieee8023ahCfgObject _Ieee8023ahCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_EthernetOam.Ieee8021agCfg.
 *
 * MDMOID_IEEE8021AG_CFG 3011
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enabled;	/**< ReadWrite */
    UBOOL8    Y1731Enabled;	/**< ReadWrite */
    char *    mdId;	/**< ReadWrite */
    UINT32    mdLevel;	/**< ReadWrite */
    char *    maId;	/**< ReadWrite */
    UINT32    ccmInterval;	/**< ReadWrite */
    UINT32    tmsctl1agPid;	/**< ReadOnly */
} Ieee8021agCfgObject;

/*! \brief _Ieee8021agCfgObject is used internally to represent Ieee8021agCfgObject */
typedef Ieee8021agCfgObject _Ieee8021agCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_EthernetOam.Ieee8021agCfg.LocalMep.{i}.
 *
 * MDMOID_LOCAL_MEP 3012
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    ifName;	/**< ReadWrite */
    SINT32    mepId;	/**< ReadWrite */
    SINT32    vlanId;	/**< ReadWrite */
    UBOOL8    ccmEnabled;	/**< ReadWrite */
} LocalMepObject;

/*! \brief _LocalMepObject is used internally to represent LocalMepObject */
typedef LocalMepObject _LocalMepObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_EthernetOam.Ieee8021agCfg.RemoteMep.{i}.
 *
 * MDMOID_REMOTE_MEP 3013
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    SINT32    mepId;	/**< ReadWrite */
} RemoteMepObject;

/*! \brief _RemoteMepObject is used internally to represent RemoteMepObject */
typedef RemoteMepObject _RemoteMepObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_EthernetOam.Ieee8021agCfg.LoopbackDiagnostics.
 *
 * MDMOID_EOAM1AG_LOOPBACK_DIAG 3014
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    diagnosticsState;	/**< ReadWrite */
    SINT32    localMepId;	/**< ReadWrite */
    char *    targetMacAddress;	/**< ReadWrite */
    UINT32    numberOfRepetitions;	/**< ReadWrite */
    UINT32    successCount;	/**< ReadOnly */
    UINT32    failureCount;	/**< ReadOnly */
} Eoam1agLoopbackDiagObject;

/*! \brief _Eoam1agLoopbackDiagObject is used internally to represent Eoam1agLoopbackDiagObject */
typedef Eoam1agLoopbackDiagObject _Eoam1agLoopbackDiagObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_EthernetOam.Ieee8021agCfg.LinktraceDiagnostics.
 *
 * MDMOID_EOAM1AG_LINKTRACE_DIAG 3015
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    diagnosticsState;	/**< ReadWrite */
    SINT32    localMepId;	/**< ReadWrite */
    char *    targetMacAddress;	/**< ReadWrite */
    SINT32    maxHopCount;	/**< ReadWrite */
    char *    mepList;	/**< ReadOnly */
} Eoam1agLinktraceDiagObject;

/*! \brief _Eoam1agLinktraceDiagObject is used internally to represent Eoam1agLinktraceDiagObject */
typedef Eoam1agLinktraceDiagObject _Eoam1agLinktraceDiagObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_McastCfg.
 *
 * MDMOID_MCAST_CFG 3282
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    SINT32    mcastPrecedence;	/**< ReadWrite */
    char *    mcastMaxGroupsPortList;	/**< ReadWrite */
    SINT32    mcastStrictWan;	/**< ReadWrite */
#ifdef DMP_X_BROADCOM_COM_DCSP_MCAST_REMARK_1
    UBOOL8    mcastDscpRemarkEnable;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_DCSP_MCAST_REMARK_1
    SINT32    mcastDscpRemarkVal;	/**< ReadWrite */
#endif
    UBOOL8    deprecated;	/**< ReadWrite */
    char *    mcastIgmpSnoopExceptions;	/**< ReadWrite */
    char *    mcastMldSnoopExceptions;	/**< ReadWrite */
} McastCfgObject;

/*! \brief _McastCfgObject is used internally to represent McastCfgObject */
typedef McastCfgObject _McastCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_IGMPCfg.
 *
 * MDMOID_IGMP_CFG 3283
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    igmpVer;	/**< ReadWrite */
    UINT32    igmpQI;	/**< ReadWrite */
    UINT32    igmpQRI;	/**< ReadWrite */
    UINT32    igmpLMQI;	/**< ReadWrite */
    UINT32    igmpRV;	/**< ReadWrite */
    UINT32    igmpMaxGroups;	/**< ReadWrite */
    UINT32    igmpMaxSources;	/**< ReadWrite */
    UINT32    igmpMaxMembers;	/**< ReadWrite */
    UBOOL8    igmpFastLeaveEnable;	/**< ReadWrite */
    UBOOL8    igmpFloodEnable;	/**< ReadWrite */
    UBOOL8    igmpLan2LanMulticastEnable;	/**< ReadWrite */
    UBOOL8    igmpJoinImmediate;	/**< ReadWrite */
    char *    igmpBridgeIfNames;	/**< ReadWrite */
    char *    igmpMcastIfNames;	/**< ReadWrite */
    char *    igmpProxyIfNames;	/**< ReadWrite */
} IgmpCfgObject;

/*! \brief _IgmpCfgObject is used internally to represent IgmpCfgObject */
typedef IgmpCfgObject _IgmpCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_MLDCfg.
 *
 * MDMOID_MLD_CFG 3284
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    mldVer;	/**< ReadWrite */
    UINT32    mldQI;	/**< ReadWrite */
    UINT32    mldQRI;	/**< ReadWrite */
    UINT32    mldLMQI;	/**< ReadWrite */
    UINT32    mldRV;	/**< ReadWrite */
    UINT32    mldMaxGroups;	/**< ReadWrite */
    UINT32    mldMaxSources;	/**< ReadWrite */
    UINT32    mldMaxMembers;	/**< ReadWrite */
    UBOOL8    mldFastLeaveEnable;	/**< ReadWrite */
    UBOOL8    mldFloodEnable;	/**< ReadWrite */
    UBOOL8    mldLan2LanMulticastEnable;	/**< ReadWrite */
    char *    mldBridgeIfNames;	/**< ReadWrite */
    char *    mldProxyIfNames;	/**< ReadWrite */
    char *    mldMcastIfNames;	/**< ReadWrite */
} MldCfgObject;

/*! \brief _MldCfgObject is used internally to represent MldCfgObject */
typedef MldCfgObject _MldCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_IPTunnel.{i}.
 *
 * MDMOID_IP_TUNNEL 3016
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    activated;	/**< ReadWrite */
    char *    tunnelName;	/**< ReadWrite */
    SINT32    tunnelCounter;	/**< ReadOnly */
    char *    mode;	/**< ReadWrite */
    char *    associatedWanIfName;	/**< ReadWrite */
    char *    associatedLanIfName;	/**< ReadWrite */
} IPTunnelObject;

/*! \brief _IPTunnelObject is used internally to represent IPTunnelObject */
typedef IPTunnelObject _IPTunnelObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_IPTunnel.{i}.V4inV6Tunnel.{i}.
 *
 * MDMOID_IPV4IN_IPV6_TUNNEL 3017
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    connStatus;	/**< ReadOnly */
    char *    mechanism;	/**< ReadWrite */
    UBOOL8    dynamic;	/**< ReadWrite */
    char *    remoteIpv6Address;	/**< ReadWrite */
    char *    currentAftrName;	/**< ReadOnly */
} Ipv4inIpv6TunnelObject;

/*! \brief _Ipv4inIpv6TunnelObject is used internally to represent Ipv4inIpv6TunnelObject */
typedef Ipv4inIpv6TunnelObject _Ipv4inIpv6TunnelObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_IPTunnel.{i}.V6inV4Tunnel.{i}.
 *
 * MDMOID_IPV6IN_IPV4_TUNNEL 3018
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    connStatus;	/**< ReadOnly */
    char *    mechanism;	/**< ReadWrite */
    UBOOL8    dynamic;	/**< ReadWrite */
    SINT32    ipv4MaskLen;	/**< ReadWrite */
    char *    prefix;	/**< ReadWrite */
    char *    borderRelayAddress;	/**< ReadWrite */
} Ipv6inIpv4TunnelObject;

/*! \brief _Ipv6inIpv4TunnelObject is used internally to represent Ipv6inIpv4TunnelObject */
typedef Ipv6inIpv4TunnelObject _Ipv6inIpv4TunnelObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_WlanNvram.
 *
 * MDMOID_WLAN_NVRAM 3019
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    wlanNvram;	/**< ReadWrite */
    char *    wlanUnsetNvram;	/**< ReadWrite */
} WlanNvramObject;

/*! \brief _WlanNvramObject is used internally to represent WlanNvramObject */
typedef WlanNvramObject _WlanNvramObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_OpenVSwitchCfg.
 *
 * MDMOID_OPENVSWITCH_CFG 3810
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    status;	/**< ReadOnly */
    char *    OFControllerIPAddress;	/**< ReadWrite */
    UINT32    OFControllerPortNumber;	/**< ReadWrite */
    char *    ifNameList;	/**< ReadWrite */
} OpenvswitchCfgObject;

/*! \brief _OpenvswitchCfgObject is used internally to represent OpenvswitchCfgObject */
typedef OpenvswitchCfgObject _OpenvswitchCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.Capabilities.
 *
 * MDMOID_CAPABILITIES 900
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
} CapabilitiesObject;

/*! \brief _CapabilitiesObject is used internally to represent CapabilitiesObject */
typedef CapabilitiesObject _CapabilitiesObject;



/*! \brief Obj struct for InternetGatewayDevice.Capabilities.PerformanceDiagnostic.
 *
 * MDMOID_PERFORMANCE_DIAG 901
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
#ifdef DMP_DOWNLOAD_1
    char *    downloadTransports;	/**< ReadOnly */
#endif
#ifdef DMP_UPLOAD_1
    char *    uploadTransports;	/**< ReadOnly */
#endif
} PerformanceDiagObject;

/*! \brief _PerformanceDiagObject is used internally to represent PerformanceDiagObject */
typedef PerformanceDiagObject _PerformanceDiagObject;



/*! \brief Obj struct for InternetGatewayDevice.DownloadDiagnostics.
 *
 * MDMOID_DL_DIAG 902
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    diagnosticsState;	/**< ReadWrite */
    char *    interface;	/**< ReadWrite */
    char *    downloadURL;	/**< ReadWrite */
    UINT32    DSCP;	/**< ReadWrite */
    UINT32    ethernetPriority;	/**< ReadWrite */
    DATETIME  ROMTime;	/**< ReadOnly */
    DATETIME  BOMTime;	/**< ReadOnly */
    DATETIME  EOMTime;	/**< ReadOnly */
    UINT32    testBytesReceived;	/**< ReadOnly */
    UINT32    totalBytesReceived;	/**< ReadOnly */
#ifdef DMP_DOWNLOADTCP_1
    DATETIME  TCPOpenRequestTime;	/**< ReadOnly */
#endif
#ifdef DMP_DOWNLOADTCP_1
    DATETIME  TCPOpenResponseTime;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_BASELINE_1
    UINT32    X_BROADCOM_COM_LogLevel;	/**< ReadWrite */
#endif
} DlDiagObject;

/*! \brief _DlDiagObject is used internally to represent DlDiagObject */
typedef DlDiagObject _DlDiagObject;



/*! \brief Obj struct for InternetGatewayDevice.UploadDiagnostics.
 *
 * MDMOID_UL_DIAG 903
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    diagnosticsState;	/**< ReadWrite */
    char *    interface;	/**< ReadWrite */
    char *    uploadURL;	/**< ReadWrite */
    UINT32    DSCP;	/**< ReadWrite */
    UINT32    testFileLength;	/**< ReadWrite */
    UINT32    ethernetPriority;	/**< ReadWrite */
    DATETIME  ROMTime;	/**< ReadOnly */
    DATETIME  BOMTime;	/**< ReadOnly */
    DATETIME  EOMTime;	/**< ReadOnly */
    UINT32    totalBytesSent;	/**< ReadOnly */
#ifdef DMP_UPLOADTCP_1
    DATETIME  TCPOpenRequestTime;	/**< ReadOnly */
#endif
#ifdef DMP_UPLOADTCP_1
    DATETIME  TCPOpenResponseTime;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_BASELINE_1
    UINT32    X_BROADCOM_COM_LogLevel;	/**< ReadWrite */
#endif
} UlDiagObject;

/*! \brief _UlDiagObject is used internally to represent UlDiagObject */
typedef UlDiagObject _UlDiagObject;



/*! \brief Obj struct for InternetGatewayDevice.UDPEchoConfig.
 *
 * MDMOID_UDP_ECHO_CFG 904
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    interface;	/**< ReadWrite */
    IPADDRESS  sourceIPAddress;	/**< ReadWrite */
    UINT32    UDPPort;	/**< ReadWrite */
#ifdef DMP_UDPECHOPLUS_1
    UBOOL8    echoPlusEnabled;	/**< ReadWrite */
#endif
    UBOOL8    echoPlusSupported;	/**< ReadOnly */
    UINT32    packetsReceived;	/**< ReadOnly */
    UINT32    packetsResponded;	/**< ReadOnly */
#ifdef DMP_X_BROADCOM_COM_BASELINE_1
    UINT32    X_BROADCOM_COM_PacketsRespondedFail;	/**< ReadOnly */
#endif
    UINT32    bytesReceived;	/**< ReadOnly */
    UINT32    bytesResponded;	/**< ReadOnly */
    DATETIME  timeFirstPacketReceived;	/**< ReadOnly */
    DATETIME  timeLastPacketReceived;	/**< ReadOnly */
#ifdef DMP_X_BROADCOM_COM_BASELINE_1
    UINT32    X_BROADCOM_COM_LogLevel;	/**< ReadWrite */
#endif
} UDPEchoCfgObject;

/*! \brief _UDPEchoCfgObject is used internally to represent UDPEchoCfgObject */
typedef UDPEchoCfgObject _UDPEchoCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.PeriodicStatistics.
 *
 * MDMOID_PERIODIC_STAT 920
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    minSampleInterval;	/**< ReadOnly */
    UINT32    maxReportSamples;	/**< ReadOnly */
    UINT32    sampleSetNumberOfEntries;	/**< ReadOnly */
} PeriodicStatObject;

/*! \brief _PeriodicStatObject is used internally to represent PeriodicStatObject */
typedef PeriodicStatObject _PeriodicStatObject;



/*! \brief Obj struct for InternetGatewayDevice.PeriodicStatistics.SampleSet.{i}.
 *
 * MDMOID_SAMPLE_SET 921
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
#ifdef DMP_PERIODICSTATSADV_1
    UBOOL8    enable;	/**< ReadWrite */
#endif
#ifdef DMP_PERIODICSTATSADV_1
    char *    status;	/**< ReadOnly */
#endif
    char *    name;	/**< ReadWrite */
    UINT32    sampleInterval;	/**< ReadWrite */
    UINT32    reportSamples;	/**< ReadWrite */
#ifdef DMP_PERIODICSTATSADV_1
    UINT32    fetchSamples;	/**< ReadWrite */
#endif
#ifdef DMP_PERIODICSTATSADV_1
    UBOOL8    forceSample;	/**< ReadWrite */
#endif
    DATETIME  reportStartTime;	/**< ReadOnly */
    DATETIME  reportEndTime;	/**< ReadOnly */
    char *    sampleSeconds;	/**< ReadOnly */
    UINT32    parameterNumberOfEntries;	/**< ReadOnly */
} SampleSetObject;

/*! \brief _SampleSetObject is used internally to represent SampleSetObject */
typedef SampleSetObject _SampleSetObject;



/*! \brief Obj struct for InternetGatewayDevice.PeriodicStatistics.SampleSet.{i}.Parameter.{i}.
 *
 * MDMOID_SAMPLE_PARAMETER 922
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    alias;	/**< ReadWrite */
#ifdef DMP_PERIODICSTATSADV_1
    UBOOL8    enable;	/**< ReadWrite */
#endif
    char *    reference;	/**< ReadWrite */
#ifdef DMP_PERIODICSTATSADV_1
    char *    sampleMode;	/**< ReadWrite */
#endif
#ifdef DMP_PERIODICSTATSADV_1
    SINT32    lowThreshold;	/**< ReadWrite */
#endif
#ifdef DMP_PERIODICSTATSADV_1
    SINT32    highThreshold;	/**< ReadWrite */
#endif
    char *    sampleSeconds;	/**< ReadOnly */
    char *    suspectData;	/**< ReadOnly */
    char *    values;	/**< ReadOnly */
#ifdef DMP_PERIODICSTATSADV_1
    UINT32    failures;	/**< ReadOnly */
#endif
} SampleParameterObject;

/*! \brief _SampleParameterObject is used internally to represent SampleParameterObject */
typedef SampleParameterObject _SampleParameterObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_EPON.
 *
 * MDMOID_EPON 2010
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    authenticationId;	/**< ReadWrite */
    char *    authenticationPassword;	/**< ReadWrite */
    UINT32    oamSelection;	/**< ReadWrite */
    UINT32    imageCrc;	/**< ReadWrite */
    UINT32    imageCrcBeforeCommit;	/**< ReadWrite */
    HEXBINARY  date;	/**< ReadWrite */
    UINT32    maxLinkNum;	/**< ReadWrite */
    char *    dpoeFileName;	/**< ReadWrite */
    HEXBINARY  dpoeMfgTime;	/**< ReadWrite */
    UINT32    eponSchMode;	/**< ReadWrite */
    UINT32    eponIdleTimeOffset;	/**< ReadWrite */
    char *    extendedId;	/**< ReadWrite */
    UBOOL8    eponTxLaserPowerOff;	/**< ReadWrite */
    UBOOL8    failSafe;	/**< ReadWrite */
    UINT32    cucCfgCnt;	/**< ReadWrite */
    char *    dpoeCosignerName;	/**< ReadWrite */
    HEXBINARY  dpoeCosignerTime;	/**< ReadWrite */
} EponObject;

/*! \brief _EponObject is used internally to represent EponObject */
typedef EponObject _EponObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_DPoE.
 *
 * MDMOID_D_PO_E 2020
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
} DPoEObject;

/*! \brief _DPoEObject is used internally to represent DPoEObject */
typedef DPoEObject _DPoEObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_DPoE.DPoE_OnuRebootReady.
 *
 * MDMOID_D_PO_E_ONU_REBOOT_READY 2021
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT64    status;	/**< ReadOnly */
} DPoEOnuRebootReadyObject;

/*! \brief _DPoEOnuRebootReadyObject is used internally to represent DPoEOnuRebootReadyObject */
typedef DPoEOnuRebootReadyObject _DPoEOnuRebootReadyObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_DPoE.DPoE_EponMode.
 *
 * MDMOID_D_PO_E_EPON_MODE 2022
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    eponMode;	/**< ReadOnly */
} DPoEEponModeObject;

/*! \brief _DPoEEponModeObject is used internally to represent DPoEEponModeObject */
typedef DPoEEponModeObject _DPoEEponModeObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_DPoE.DPoE_DynamicMacTableSetting.
 *
 * MDMOID_D_PO_E_DYNAMIC_MAC_SETTING 2023
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    dynamicMacAddressAgeLimit;	/**< ReadOnly */
    UINT32    dynamicMacLearningTableMaxSize;	/**< ReadOnly */
    UINT32    dynamicMacLearningAggregateLimit;	/**< ReadOnly */
} DPoEDynamicMacSettingObject;

/*! \brief _DPoEDynamicMacSettingObject is used internally to represent DPoEDynamicMacSettingObject */
typedef DPoEDynamicMacSettingObject _DPoEDynamicMacSettingObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_DPoE.DPoE_DynamicMacTable.{i}.
 *
 * MDMOID_D_PO_E_DYNAMIC_MAC_TABLE 2024
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    port;	/**< ReadOnly */
    UINT32    numEntries;	/**< ReadOnly */
    char *    macAddress;	/**< ReadOnly */
} DPoEDynamicMacTableObject;

/*! \brief _DPoEDynamicMacTableObject is used internally to represent DPoEDynamicMacTableObject */
typedef DPoEDynamicMacTableObject _DPoEDynamicMacTableObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_DPoE.DPoE_StaticMacTable.{i}.
 *
 * MDMOID_D_PO_E_STATIC_MAC_TABLE 2025
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    port;	/**< ReadOnly */
    UINT32    numEntries;	/**< ReadOnly */
    char *    macAddress;	/**< ReadOnly */
} DPoEStaticMacTableObject;

/*! \brief _DPoEStaticMacTableObject is used internally to represent DPoEStaticMacTableObject */
typedef DPoEStaticMacTableObject _DPoEStaticMacTableObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_DPoE.DPoE_FirmwareInfo.
 *
 * MDMOID_D_PO_E_FIRMWARE_INFO 2026
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    bootVersion;	/**< ReadOnly */
    char *    bootCrc32;	/**< ReadOnly */
    char *    appVersion;	/**< ReadOnly */
    char *    appCrc32;	/**< ReadOnly */
} DPoEFirmwareInfoObject;

/*! \brief _DPoEFirmwareInfoObject is used internally to represent DPoEFirmwareInfoObject */
typedef DPoEFirmwareInfoObject _DPoEFirmwareInfoObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_DPoE.DPoE_ChipInfo.
 *
 * MDMOID_D_PO_E_CHIP_INFO 2027
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    jedecId;	/**< ReadOnly */
    UINT32    chipModel;	/**< ReadOnly */
    UINT32    chipVersion;	/**< ReadOnly */
} DPoEChipInfoObject;

/*! \brief _DPoEChipInfoObject is used internally to represent DPoEChipInfoObject */
typedef DPoEChipInfoObject _DPoEChipInfoObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_DPoE.DPoE_OnuId.
 *
 * MDMOID_D_PO_E_ONU_ID 2028
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    macAddress;	/**< ReadOnly */
} DPoEOnuIdObject;

/*! \brief _DPoEOnuIdObject is used internally to represent DPoEOnuIdObject */
typedef DPoEOnuIdObject _DPoEOnuIdObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_DPoE.DPoE_ManufacturerInfo.
 *
 * MDMOID_D_PO_E_MANUFACTURER_INFO 2029
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    info;	/**< ReadOnly */
    char *    organizationName;	/**< ReadOnly */
    UINT32    year;	/**< ReadOnly */
    UINT32    month;	/**< ReadOnly */
    UINT32    day;	/**< ReadOnly */
} DPoEManufacturerInfoObject;

/*! \brief _DPoEManufacturerInfoObject is used internally to represent DPoEManufacturerInfoObject */
typedef DPoEManufacturerInfoObject _DPoEManufacturerInfoObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_DPoE.DPoE_MaxLogicalLinks.
 *
 * MDMOID_D_PO_E_MAX_LOGICAL_LINKS 2030
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    bidirectional;	/**< ReadOnly */
    UINT32    downstreamonly;	/**< ReadOnly */
} DPoEMaxLogicalLinksObject;

/*! \brief _DPoEMaxLogicalLinksObject is used internally to represent DPoEMaxLogicalLinksObject */
typedef DPoEMaxLogicalLinksObject _DPoEMaxLogicalLinksObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_DPoE.DPoE_NetworkPorts.
 *
 * MDMOID_D_PO_E_NETWORK_PORTS 2031
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    total;	/**< ReadOnly */
} DPoENetworkPortsObject;

/*! \brief _DPoENetworkPortsObject is used internally to represent DPoENetworkPortsObject */
typedef DPoENetworkPortsObject _DPoENetworkPortsObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_DPoE.DPoE_S1Interfaces.
 *
 * MDMOID_D_PO_E_S1_INTERFACES 2032
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    total;	/**< ReadWrite */
    char *    nameList;	/**< ReadWrite */
} DPoES1InterfacesObject;

/*! \brief _DPoES1InterfacesObject is used internally to represent DPoES1InterfacesObject */
typedef DPoES1InterfacesObject _DPoES1InterfacesObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_DPoE.DPoE_OnuPacketBufferCapabilities.
 *
 * MDMOID_D_PO_E_ONU_PACKET_BUFFER_CAPS 2033
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    upstreamQueues;	/**< ReadOnly */
    UINT32    upQueuesMaxPerLink;	/**< ReadOnly */
    UINT32    upQueueIncrement;	/**< ReadOnly */
    UINT32    downstreamQueues;	/**< ReadOnly */
    UINT32    dnQueuesMaxPerPort;	/**< ReadOnly */
    UINT32    dnQueueIncrement;	/**< ReadOnly */
    UINT32    totalPacketBuffer;	/**< ReadOnly */
    UINT32    upPacketBuffer;	/**< ReadOnly */
    UINT32    dnPacketBuffer;	/**< ReadOnly */
} DPoEOnuPacketBufferCapsObject;

/*! \brief _DPoEOnuPacketBufferCapsObject is used internally to represent DPoEOnuPacketBufferCapsObject */
typedef DPoEOnuPacketBufferCapsObject _DPoEOnuPacketBufferCapsObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_DPoE.DPoE_LlidForwardingState.{i}.
 *
 * MDMOID_D_PO_E_LLID_FORWARDING_STATE 2034
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    linkId;	/**< ReadOnly */
    UINT32    forwardingState;	/**< ReadOnly */
} DPoELlidForwardingStateObject;

/*! \brief _DPoELlidForwardingStateObject is used internally to represent DPoELlidForwardingStateObject */
typedef DPoELlidForwardingStateObject _DPoELlidForwardingStateObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_DPoE.DPoE_OamFrameRate.{i}.
 *
 * MDMOID_D_PO_E_OAM_FRAME_RATE 2035
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    linkId;	/**< ReadOnly */
    UINT32    maxRate;	/**< ReadOnly */
    UINT32    minRate;	/**< ReadOnly */
} DPoEOamFrameRateObject;

/*! \brief _DPoEOamFrameRateObject is used internally to represent DPoEOamFrameRateObject */
typedef DPoEOamFrameRateObject _DPoEOamFrameRateObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_DPoE.DPoE_DeviceSysDescrInfo.
 *
 * MDMOID_D_PO_E_DEVICE_SYS_DESCR_INFO 2036
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    vendorName;	/**< ReadOnly */
    char *    modelNumber;	/**< ReadOnly */
    char *    hardwareVersion;	/**< ReadOnly */
} DPoEDeviceSysDescrInfoObject;

/*! \brief _DPoEDeviceSysDescrInfoObject is used internally to represent DPoEDeviceSysDescrInfoObject */
typedef DPoEDeviceSysDescrInfoObject _DPoEDeviceSysDescrInfoObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_DPoE.DPoE_OnuLinkStatistics.{i}.
 *
 * MDMOID_D_PO_E_ONU_LINK_STATISTICS 2037
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    link;	/**< ReadOnly */
    UINT64    rxUnicastFrames;	/**< ReadOnly */
    UINT64    txUnicastFrames;	/**< ReadOnly */
    UINT64    rxFrameTooShort;	/**< ReadOnly */
    UINT64    rxFrame64;	/**< ReadOnly */
    UINT64    rxFrame65_127;	/**< ReadOnly */
    UINT64    rxFrame128_255;	/**< ReadOnly */
    UINT64    rxFrame256_511;	/**< ReadOnly */
    UINT64    rxFrame512_1023;	/**< ReadOnly */
    UINT64    rxFrame1024_1518;	/**< ReadOnly */
    UINT64    rxFrame1519_Plus;	/**< ReadOnly */
    UINT64    txFrame64;	/**< ReadOnly */
    UINT64    txFrame65_127;	/**< ReadOnly */
    UINT64    txFrame128_255;	/**< ReadOnly */
    UINT64    txFrame256_511;	/**< ReadOnly */
    UINT64    txFrame512_1023;	/**< ReadOnly */
    UINT64    txFrame_1024_1518;	/**< ReadOnly */
    UINT64    txFrame_1519_Plus;	/**< ReadOnly */
    UINT64    framesDropped;	/**< ReadOnly */
    UINT64    bytesDropped;	/**< ReadOnly */
    UINT32    opticalMonVcc;	/**< ReadOnly */
    UINT32    opticalMonTxBiasCurrent;	/**< ReadOnly */
    UINT32    opticalMonTxPower;	/**< ReadOnly */
    UINT32    opticalMonRxPower;	/**< ReadOnly */
} DPoEOnuLinkStatisticsObject;

/*! \brief _DPoEOnuLinkStatisticsObject is used internally to represent DPoEOnuLinkStatisticsObject */
typedef DPoEOnuLinkStatisticsObject _DPoEOnuLinkStatisticsObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_DPoE.DPoE_ClearOnuLinkStatistics.
 *
 * MDMOID_D_PO_E_CLEAR_ONU_LINK_STATISTICS 2038
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    setClearOnuLinkStats;	/**< ReadOnly */
} DPoEClearOnuLinkStatisticsObject;

/*! \brief _DPoEClearOnuLinkStatisticsObject is used internally to represent DPoEClearOnuLinkStatisticsObject */
typedef DPoEClearOnuLinkStatisticsObject _DPoEClearOnuLinkStatisticsObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_DPoE.DPoE_ReinitMac.
 *
 * MDMOID_D_PO_E_REINIT_MAC 2039
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    reinitDPoE;	/**< ReadOnly */
} DPoEReinitMacObject;

/*! \brief _DPoEReinitMacObject is used internally to represent DPoEReinitMacObject */
typedef DPoEReinitMacObject _DPoEReinitMacObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_DPoE.DPoE_LogicLinkNum.
 *
 * MDMOID_D_PO_E_LOGIC_LINK 2040
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    cfgLinkNum;	/**< ReadOnly */
} DPoELogicLinkObject;

/*! \brief _DPoELogicLinkObject is used internally to represent DPoELogicLinkObject */
typedef DPoELogicLinkObject _DPoELogicLinkObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_DPoE.DPoE_ResetCount.
 *
 * MDMOID_D_PO_E_RESET_COUNT 2041
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT64    localResetCount;	/**< ReadWrite */
    UINT64    oamResetCount;	/**< ReadWrite */
} DPoEResetCountObject;

/*! \brief _DPoEResetCountObject is used internally to represent DPoEResetCountObject */
typedef DPoEResetCountObject _DPoEResetCountObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_OMCI.
 *
 * MDMOID_BCM_OMCI 2100
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
} BcmOmciObject;

/*! \brief _BcmOmciObject is used internally to represent BcmOmciObject */
typedef BcmOmciObject _BcmOmciObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_OMCI.RunTimeData.
 *
 * MDMOID_BCM_OMCI_RTD 2101
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
} BcmOmciRtdObject;

/*! \brief _BcmOmciRtdObject is used internally to represent BcmOmciRtdObject */
typedef BcmOmciRtdObject _BcmOmciRtdObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_OMCI.RunTimeData.Multicast.
 *
 * MDMOID_BCM_OMCI_RTD_MCAST 2102
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    igmpAdmission;	/**< ReadWrite */
    UBOOL8    joinForceForward;	/**< ReadWrite */
    UINT32    upstreamIgmpRate;	/**< ReadWrite */
    char *    igmpMcastIfNames;	/**< ReadWrite */
    char *    mcastBridgeIfNames;	/**< ReadWrite */
} BcmOmciRtdMcastObject;

/*! \brief _BcmOmciRtdMcastObject is used internally to represent BcmOmciRtdMcastObject */
typedef BcmOmciRtdMcastObject _BcmOmciRtdMcastObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_OMCI.RunTimeData.Layer3.
 *
 * MDMOID_BCM_OMCI_RTD_LAYER3 2103
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
} BcmOmciRtdLayer3Object;

/*! \brief _BcmOmciRtdLayer3Object is used internally to represent BcmOmciRtdLayer3Object */
typedef BcmOmciRtdLayer3Object _BcmOmciRtdLayer3Object;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_OMCI.RunTimeData.Layer3.IpHostConfigData.{i}.
 *
 * MDMOID_BCM_OMCI_RTD_IP_HOST_CONFIG_DATA 2104
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    managedEntityId;	/**< ReadWrite */
    UINT32    ipOptions;	/**< ReadWrite */
    HEXBINARY  macAddress;	/**< ReadOnly */
    HEXBINARY  ontId;	/**< ReadWrite */
    UINT32    ipAddress;	/**< ReadWrite */
    UINT32    mask;	/**< ReadWrite */
    UINT32    gateway;	/**< ReadWrite */
    UINT32    primaryDns;	/**< ReadWrite */
    UINT32    secondaryDns;	/**< ReadWrite */
    UINT32    currentAddress;	/**< ReadWrite */
    UINT32    currentMask;	/**< ReadWrite */
    UINT32    currentGateway;	/**< ReadWrite */
    UINT32    currentPrimaryDns;	/**< ReadWrite */
    UINT32    currentSecondaryDns;	/**< ReadWrite */
    HEXBINARY  domainName;	/**< ReadOnly */
    HEXBINARY  hostName;	/**< ReadOnly */
} BcmOmciRtdIpHostConfigDataObject;

/*! \brief _BcmOmciRtdIpHostConfigDataObject is used internally to represent BcmOmciRtdIpHostConfigDataObject */
typedef BcmOmciRtdIpHostConfigDataObject _BcmOmciRtdIpHostConfigDataObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_OMCI.RunTimeData.Layer3.IpHostConfigDataExt.{i}.
 *
 * MDMOID_BCM_OMCI_RTD_IP_HOST_CONFIG_DATA_EXT 2105
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    managedEntityId;	/**< ReadWrite */
    UINT32    connectionStatus;	/**< ReadWrite */
    UINT32    dhcpcPid;	/**< ReadWrite */
    char *    interfaceName;	/**< ReadWrite */
} BcmOmciRtdIpHostConfigDataExtObject;

/*! \brief _BcmOmciRtdIpHostConfigDataExtObject is used internally to represent BcmOmciRtdIpHostConfigDataExtObject */
typedef BcmOmciRtdIpHostConfigDataExtObject _BcmOmciRtdIpHostConfigDataExtObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_OMCI.RunTimeData.Layer3.Ipv6HostConfigData.{i}.
 *
 * MDMOID_BCM_OMCI_RTD_IPV6_HOST_CONFIG_DATA 2106
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    managedEntityId;	/**< ReadWrite */
    UINT32    ipOptions;	/**< ReadWrite */
    HEXBINARY  macAddress;	/**< ReadOnly */
    HEXBINARY  onuId;	/**< ReadWrite */
    HEXBINARY  ipv6LinkLocalAddress;	/**< ReadWrite */
    HEXBINARY  ipv6Address;	/**< ReadWrite */
    HEXBINARY  defaultRouter;	/**< ReadWrite */
    HEXBINARY  primaryDns;	/**< ReadWrite */
    HEXBINARY  secondaryDns;	/**< ReadWrite */
    HEXBINARY  currentAddressTable;	/**< ReadOnly */
    HEXBINARY  currentDefaultRouterTable;	/**< ReadOnly */
    HEXBINARY  currentDnsTable;	/**< ReadOnly */
    HEXBINARY  duid;	/**< ReadOnly */
    HEXBINARY  onlinkPrefix;	/**< ReadWrite */
    HEXBINARY  currentOnlinkPrefixTable;	/**< ReadWrite */
} BcmOmciRtdIpv6HostConfigDataObject;

/*! \brief _BcmOmciRtdIpv6HostConfigDataObject is used internally to represent BcmOmciRtdIpv6HostConfigDataObject */
typedef BcmOmciRtdIpv6HostConfigDataObject _BcmOmciRtdIpv6HostConfigDataObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_OMCI.RunTimeData.Layer3.Ipv6HostConfigData.{i}.CurrentAddressTableObj.{i}.
 *
 * MDMOID_BCM_OMCI_RTD_IPV6_CURRENT_ADDRESS_TABLE 2107
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    HEXBINARY  currentAddressEntry;	/**< ReadOnly */
} BcmOmciRtdIpv6CurrentAddressTableObject;

/*! \brief _BcmOmciRtdIpv6CurrentAddressTableObject is used internally to represent BcmOmciRtdIpv6CurrentAddressTableObject */
typedef BcmOmciRtdIpv6CurrentAddressTableObject _BcmOmciRtdIpv6CurrentAddressTableObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_OMCI.RunTimeData.Layer3.Ipv6HostConfigData.{i}.CurrentDefaultRouterTableObj.{i}.
 *
 * MDMOID_BCM_OMCI_RTD_IPV6_CURRENT_DEFAULT_ROUTER_TABLE 2108
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    HEXBINARY  currentDefaultRouterEntry;	/**< ReadOnly */
} BcmOmciRtdIpv6CurrentDefaultRouterTableObject;

/*! \brief _BcmOmciRtdIpv6CurrentDefaultRouterTableObject is used internally to represent BcmOmciRtdIpv6CurrentDefaultRouterTableObject */
typedef BcmOmciRtdIpv6CurrentDefaultRouterTableObject _BcmOmciRtdIpv6CurrentDefaultRouterTableObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_OMCI.RunTimeData.Layer3.Ipv6HostConfigData.{i}.CurrentDnsTableObj.{i}.
 *
 * MDMOID_BCM_OMCI_RTD_IPV6_CURRENT_DNS_TABLE 2109
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    HEXBINARY  currentDnsEntry;	/**< ReadOnly */
} BcmOmciRtdIpv6CurrentDnsTableObject;

/*! \brief _BcmOmciRtdIpv6CurrentDnsTableObject is used internally to represent BcmOmciRtdIpv6CurrentDnsTableObject */
typedef BcmOmciRtdIpv6CurrentDnsTableObject _BcmOmciRtdIpv6CurrentDnsTableObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_OMCI.RunTimeData.Layer3.Ipv6HostConfigData.{i}.CurrentOnlinkPrefixTableObj.{i}.
 *
 * MDMOID_BCM_OMCI_RTD_IPV6_CURRENT_ONLINK_PREFIX_TABLE 2110
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    HEXBINARY  currentOnlinkPrefixTableEntry;	/**< ReadWrite */
} BcmOmciRtdIpv6CurrentOnlinkPrefixTableObject;

/*! \brief _BcmOmciRtdIpv6CurrentOnlinkPrefixTableObject is used internally to represent BcmOmciRtdIpv6CurrentOnlinkPrefixTableObject */
typedef BcmOmciRtdIpv6CurrentOnlinkPrefixTableObject _BcmOmciRtdIpv6CurrentOnlinkPrefixTableObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_OMCI.RunTimeData.Layer3.Ipv6HostConfigDataExt.{i}.
 *
 * MDMOID_BCM_OMCI_RTD_IPV6_HOST_CONFIG_DATA_EXT 2111
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    managedEntityId;	/**< ReadWrite */
    UINT32    connectionStatus;	/**< ReadWrite */
    UINT32    dhcpcPid;	/**< ReadWrite */
    char *    interfaceName;	/**< ReadWrite */
    UBOOL8    MFlag;	/**< ReadWrite */
    UBOOL8    OFlag;	/**< ReadWrite */
} BcmOmciRtdIpv6HostConfigDataExtObject;

/*! \brief _BcmOmciRtdIpv6HostConfigDataExtObject is used internally to represent BcmOmciRtdIpv6HostConfigDataExtObject */
typedef BcmOmciRtdIpv6HostConfigDataExtObject _BcmOmciRtdIpv6HostConfigDataExtObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_OMCI.RunTimeData.Layer3.TcpUdpConfigData.{i}.
 *
 * MDMOID_BCM_OMCI_RTD_TCP_UDP_CONFIG_DATA 2112
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    managedEntityId;	/**< ReadWrite */
    UINT32    portId;	/**< ReadWrite */
    UINT32    protocol;	/**< ReadWrite */
    UINT32    tos;	/**< ReadWrite */
    UINT32    ipHostPointer;	/**< ReadWrite */
} BcmOmciRtdTcpUdpConfigDataObject;

/*! \brief _BcmOmciRtdTcpUdpConfigDataObject is used internally to represent BcmOmciRtdTcpUdpConfigDataObject */
typedef BcmOmciRtdTcpUdpConfigDataObject _BcmOmciRtdTcpUdpConfigDataObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_OMCI.Debug.
 *
 * MDMOID_BCM_OMCI_DEBUG 2113
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
} BcmOmciDebugObject;

/*! \brief _BcmOmciDebugObject is used internally to represent BcmOmciDebugObject */
typedef BcmOmciDebugObject _BcmOmciDebugObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_OMCI.Config.
 *
 * MDMOID_BCM_OMCI_CONFIG 2114
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
} BcmOmciConfigObject;

/*! \brief _BcmOmciConfigObject is used internally to represent BcmOmciConfigObject */
typedef BcmOmciConfigObject _BcmOmciConfigObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_OMCI.Config.OmciSystemCfg.
 *
 * MDMOID_BCM_OMCI_CONFIG_SYSTEM 2115
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    numberOfDSQueuesPerUni;	/**< ReadWrite */
    UINT32    tcontManagedEntityId;	/**< ReadWrite */
    UINT32    numberOfTConts;	/**< ReadWrite */
    UINT32    queueInit;	/**< ReadWrite */
    UINT32    trafficSchedulers;	/**< ReadWrite */
    HEXBINARY  tcontPolicies;	/**< ReadWrite */
    UINT32    ethernetManagedEntityId1;	/**< ReadWrite */
    UINT32    ethernetManagedEntityId2;	/**< ReadWrite */
    UINT32    ethernetManagedEntityId3;	/**< ReadWrite */
    UINT32    ethernetManagedEntityId4;	/**< ReadWrite */
    UINT32    ethernetManagedEntityId5;	/**< ReadWrite */
    UINT32    ethernetManagedEntityId6;	/**< ReadWrite */
    UINT32    ethernetManagedEntityId7;	/**< ReadWrite */
    UINT32    ethernetManagedEntityId8;	/**< ReadWrite */
    UBOOL8    ethUniFlexIdMode;	/**< ReadWrite */
    UINT32    ethUniFeSlotId;	/**< ReadWrite */
    UINT32    ethUniGbeSlotId;	/**< ReadWrite */
    UINT32    ethUni10GSlotId;	/**< ReadWrite */
    UINT32    numberOfEthernetPorts;	/**< ReadWrite */
    UINT32    ethernetTypes;	/**< ReadWrite */
    UINT32    veipPptpUni0;	/**< ReadWrite */
    UINT32    mocaManagedEntityId1;	/**< ReadWrite */
    UINT32    mocaManagedEntityId2;	/**< ReadWrite */
    UINT32    numberOfMocaPorts;	/**< ReadWrite */
    UINT32    potsManagedEntityId1;	/**< ReadWrite */
    UINT32    potsManagedEntityId2;	/**< ReadWrite */
    UINT32    numberOfPotsPorts;	/**< ReadWrite */
    UINT32    veipManagedEntityId1;	/**< ReadWrite */
    UINT32    numberOfVeipPorts;	/**< ReadWrite */
    UINT32    numberOfDownstreamPriorityQueues;	/**< ReadWrite */
    UINT32    debugFlags;	/**< ReadWrite */
    UINT32    promiscMode;	/**< ReadWrite */
    UINT32    getPmMode;	/**< ReadWrite */
    UBOOL8    omciRawEnable;	/**< ReadWrite */
#ifdef DMP_X_BROADCOM_COM_GPONRG_OMCI_FULL_1
    UBOOL8    compatibleRGOmciFull;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_GPONONT_1
    UBOOL8    compatibleOnt;	/**< ReadWrite */
#endif
    UINT32    trafficManagementOption;	/**< ReadWrite */
    UINT32    voiceModelOption;	/**< ReadWrite */
    UINT32    ponAppType;	/**< ReadWrite */
    UINT32    ponIfType;	/**< ReadWrite */
    UINT32    dsInvalidQueueAction;	/**< ReadWrite */
    UBOOL8    joinForceForward;	/**< ReadWrite */
    UINT32    bridgeGroupFwdMask;	/**< ReadWrite */
    UBOOL8    uniDataPathMode;	/**< ReadWrite */
    UINT32    extVlanDefaultRuleEnable;	/**< ReadWrite */
    HEXBINARY  psk;	/**< ReadWrite */
    UBOOL8    extMsgSetEnable;	/**< ReadWrite */
    UINT32    omccVersion;	/**< ReadWrite */
    UINT32    allocIdInitValue;	/**< ReadWrite */
    HEXBINARY  logicalOnuId;	/**< ReadWrite */
    HEXBINARY  logicalPassword;	/**< ReadWrite */
    UINT32    numberOfXtmUniPorts;	/**< ReadWrite */
    UBOOL8    mapperDsMode;	/**< ReadWrite */
    UBOOL8    mcastHostCtrlMode;	/**< ReadWrite */
    UINT32    localExtVlanDsMode;	/**< ReadWrite */
    char *    defaultLanBrgName;	/**< ReadWrite */
    UINT32    ethOmciManaged;	/**< ReadOnly */
    UINT32    extVlanSortMode;	/**< ReadWrite */
} BcmOmciConfigSystemObject;

/*! \brief _BcmOmciConfigSystemObject is used internally to represent BcmOmciConfigSystemObject */
typedef BcmOmciConfigSystemObject _BcmOmciConfigSystemObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_OMCI.Stats.
 *
 * MDMOID_BCM_OMCI_STATS 2116
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
} BcmOmciStatsObject;

/*! \brief _BcmOmciStatsObject is used internally to represent BcmOmciStatsObject */
typedef BcmOmciStatsObject _BcmOmciStatsObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_OMCI.Stats.GponOmciStats.
 *
 * MDMOID_BCM_OMCI_STATS_GPON_OMCI_STATS 2117
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    rxGoodPackets;	/**< ReadOnly */
    UINT32    rxBaseLinePackets;	/**< ReadOnly */
    UINT32    rxExtendedPackets;	/**< ReadOnly */
    UINT32    rxLengthErrors;	/**< ReadOnly */
    UINT32    rxCrcErrors;	/**< ReadOnly */
    UINT32    rxOtherErrors;	/**< ReadOnly */
    UINT32    txAvcPackets;	/**< ReadOnly */
    UINT32    txAlarmPackets;	/**< ReadOnly */
    UINT32    txResponsePackets;	/**< ReadOnly */
    UINT32    txRetransmissions;	/**< ReadOnly */
    UINT32    txErrors;	/**< ReadOnly */
} BcmOmciStatsGponOmciStatsObject;

/*! \brief _BcmOmciStatsGponOmciStatsObject is used internally to represent BcmOmciStatsGponOmciStatsObject */
typedef BcmOmciStatsGponOmciStatsObject _BcmOmciStatsGponOmciStatsObject;



/*! \brief Obj struct for InternetGatewayDevice.X_RDK_ONT.
 *
 * MDMOID_BCM_GPON 2200
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
} BcmGponObject;

/*! \brief _BcmGponObject is used internally to represent BcmGponObject */
typedef BcmGponObject _BcmGponObject;



/*! \brief Obj struct for InternetGatewayDevice.X_RDK_ONT.PhysicalMedia.{i}.
 *
 * MDMOID_GPON_PHYSICAL_MEDIA 2201
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    administrativeState;	/**< ReadWrite */
    char *    status;	/**< ReadOnly */
    char *    cage;	/**< ReadOnly */
    char *    moduleVendor;	/**< ReadOnly */
    char *    moduleName;	/**< ReadOnly */
    char *    moduleVersion;	/**< ReadOnly */
    char *    moduleFirmwareVersion;	/**< ReadOnly */
    char *    ponMode;	/**< ReadOnly */
    char *    connector;	/**< ReadOnly */
    char *    redundancyState;	/**< ReadOnly */
    UINT32    nominalBitRateDownstream;	/**< ReadOnly */
    UINT32    nominalBitRateUpstream;	/**< ReadOnly */
} GponPhysicalMediaObject;

/*! \brief _GponPhysicalMediaObject is used internally to represent GponPhysicalMediaObject */
typedef GponPhysicalMediaObject _GponPhysicalMediaObject;



/*! \brief Obj struct for InternetGatewayDevice.X_RDK_ONT.PhysicalMedia.{i}.PerformanceThreshold.
 *
 * MDMOID_GPON_PHYSICAL_MEDIA_PM_THR 2202
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    signalFail;	/**< ReadOnly */
    UINT32    signalDegrade;	/**< ReadOnly */
} GponPhysicalMediaPmThrObject;

/*! \brief _GponPhysicalMediaPmThrObject is used internally to represent GponPhysicalMediaPmThrObject */
typedef GponPhysicalMediaPmThrObject _GponPhysicalMediaPmThrObject;



/*! \brief Obj struct for InternetGatewayDevice.X_RDK_ONT.PhysicalMedia.{i}.RxPower.
 *
 * MDMOID_GPON_PHYSICAL_MEDIA_RX_POWER 2203
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    SINT32    signalLevel;	/**< ReadOnly */
    SINT32    signalLevelLowerThreshold;	/**< ReadWrite */
    SINT32    signalLevelUpperThreshold;	/**< ReadWrite */
} GponPhysicalMediaRxPowerObject;

/*! \brief _GponPhysicalMediaRxPowerObject is used internally to represent GponPhysicalMediaRxPowerObject */
typedef GponPhysicalMediaRxPowerObject _GponPhysicalMediaRxPowerObject;



/*! \brief Obj struct for InternetGatewayDevice.X_RDK_ONT.PhysicalMedia.{i}.TxPower.
 *
 * MDMOID_GPON_PHYSICAL_MEDIA_TX_POWER 2204
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    SINT32    signalLevel;	/**< ReadOnly */
    SINT32    signalLevelLowerThreshold;	/**< ReadWrite */
    SINT32    signalLevelUpperThreshold;	/**< ReadWrite */
} GponPhysicalMediaTxPowerObject;

/*! \brief _GponPhysicalMediaTxPowerObject is used internally to represent GponPhysicalMediaTxPowerObject */
typedef GponPhysicalMediaTxPowerObject _GponPhysicalMediaTxPowerObject;



/*! \brief Obj struct for InternetGatewayDevice.X_RDK_ONT.PhysicalMedia.{i}.Voltage.
 *
 * MDMOID_GPON_PHYSICAL_MEDIA_VOLTAGE 2205
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    SINT32    voltageLevel;	/**< ReadOnly */
} GponPhysicalMediaVoltageObject;

/*! \brief _GponPhysicalMediaVoltageObject is used internally to represent GponPhysicalMediaVoltageObject */
typedef GponPhysicalMediaVoltageObject _GponPhysicalMediaVoltageObject;



/*! \brief Obj struct for InternetGatewayDevice.X_RDK_ONT.PhysicalMedia.{i}.Bias.
 *
 * MDMOID_GPON_PHYSICAL_MEDIA_BIAS 2206
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    currentBias;	/**< ReadOnly */
} GponPhysicalMediaBiasObject;

/*! \brief _GponPhysicalMediaBiasObject is used internally to represent GponPhysicalMediaBiasObject */
typedef GponPhysicalMediaBiasObject _GponPhysicalMediaBiasObject;



/*! \brief Obj struct for InternetGatewayDevice.X_RDK_ONT.PhysicalMedia.{i}.Temperature.
 *
 * MDMOID_GPON_PHYSICAL_MEDIA_TEMP 2207
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    SINT32    currentTemp;	/**< ReadOnly */
} GponPhysicalMediaTempObject;

/*! \brief _GponPhysicalMediaTempObject is used internally to represent GponPhysicalMediaTempObject */
typedef GponPhysicalMediaTempObject _GponPhysicalMediaTempObject;



/*! \brief Obj struct for InternetGatewayDevice.X_RDK_ONT.PhysicalMedia.{i}.Alarm.
 *
 * MDMOID_GPON_PHYSICAL_MEDIA_ALARMS 2208
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    LOS;	/**< ReadOnly */
    char *    LOF;	/**< ReadOnly */
    char *    SF;	/**< ReadOnly */
    char *    SD;	/**< ReadOnly */
    char *    LCDG;	/**< ReadOnly */
    char *    TF;	/**< ReadOnly */
    char *    SUF;	/**< ReadOnly */
    char *    MEM;	/**< ReadOnly */
    char *    DACT;	/**< ReadOnly */
    char *    DIS;	/**< ReadOnly */
    char *    MIS;	/**< ReadOnly */
    char *    PEE;	/**< ReadOnly */
    char *    RDI;	/**< ReadOnly */
    char *    LODS;	/**< ReadOnly */
    char *    ROGUE;	/**< ReadOnly */
} GponPhysicalMediaAlarmsObject;

/*! \brief _GponPhysicalMediaAlarmsObject is used internally to represent GponPhysicalMediaAlarmsObject */
typedef GponPhysicalMediaAlarmsObject _GponPhysicalMediaAlarmsObject;



/*! \brief Obj struct for InternetGatewayDevice.X_RDK_ONT.Gtc.
 *
 * MDMOID_GPON_GTC 2209
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT64    correctedFecBytes;	/**< ReadOnly */
    UINT64    correctedFecCodeWords;	/**< ReadOnly */
    UINT64    uncorrectedFecCodeWords;	/**< ReadOnly */
    UINT64    totalFecCodeWords;	/**< ReadOnly */
    UINT64    hecErrorCount;	/**< ReadOnly */
    UINT64    PSBdHecErrors;	/**< ReadOnly */
    UINT64    frameHecErrors;	/**< ReadOnly */
    UINT64    framesLost;	/**< ReadOnly */
} GponGtcObject;

/*! \brief _GponGtcObject is used internally to represent GponGtcObject */
typedef GponGtcObject _GponGtcObject;



/*! \brief Obj struct for InternetGatewayDevice.X_RDK_ONT.Ploam.
 *
 * MDMOID_GPON_PLOAM 2210
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    onuId;	/**< ReadOnly */
    char *    vendorId;	/**< ReadOnly */
    char *    serialNumber;	/**< ReadOnly */
    char *    registrationState;	/**< ReadOnly */
    UINT32    activationCounter;	/**< ReadOnly */
    UINT32    txMessageCount;	/**< ReadOnly */
    UINT32    rxMessageCount;	/**< ReadOnly */
    UINT32    micErrors;	/**< ReadOnly */
} GponPloamObject;

/*! \brief _GponPloamObject is used internally to represent GponPloamObject */
typedef GponPloamObject _GponPloamObject;



/*! \brief Obj struct for InternetGatewayDevice.X_RDK_ONT.Ploam.RegistrationTimers.
 *
 * MDMOID_GPON_PLOAM_REG_TIMERS 2211
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    TO1;	/**< ReadOnly */
    UINT32    TO2;	/**< ReadOnly */
} GponPloamRegTimersObject;

/*! \brief _GponPloamRegTimersObject is used internally to represent GponPloamRegTimersObject */
typedef GponPloamRegTimersObject _GponPloamRegTimersObject;



/*! \brief Obj struct for InternetGatewayDevice.X_RDK_ONT.Omci.
 *
 * MDMOID_GPON_OMCI 2212
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    rxBaseLineMessageCountValid;	/**< ReadOnly */
    UINT32    rxExtendedMessageCountValid;	/**< ReadOnly */
    UINT32    micErrors;	/**< ReadOnly */
} GponOmciObject;

/*! \brief _GponOmciObject is used internally to represent GponOmciObject */
typedef GponOmciObject _GponOmciObject;



/*! \brief Obj struct for InternetGatewayDevice.X_RDK_ONT.TcLayerStatus.{i}.
 *
 * MDMOID_GPON_TC_LAYER_STATUS 2213
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    ifType;	/**< ReadOnly */
    UINT32    onuState;	/**< ReadOnly */
    UINT32    onuId;	/**< ReadOnly */
    HEXBINARY  serialNumber;	/**< ReadOnly */
} GponTcLayerStatusObject;

/*! \brief _GponTcLayerStatusObject is used internally to represent GponTcLayerStatusObject */
typedef GponTcLayerStatusObject _GponTcLayerStatusObject;



/*! \brief Obj struct for InternetGatewayDevice.X_RDK_ONT.WanLinkStatus.{i}.
 *
 * MDMOID_GPON_WAN_LINK_STATUS 2214
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    ifName;	/**< ReadOnly */
    char *    tcStatus;	/**< ReadOnly */
    char *    omciStatus;	/**< ReadOnly */
} GponWanLinkStatusObject;

/*! \brief _GponWanLinkStatusObject is used internally to represent GponWanLinkStatusObject */
typedef GponWanLinkStatusObject _GponWanLinkStatusObject;



/*! \brief Obj struct for InternetGatewayDevice.X_RDK_ONT.Veip.{i}.
 *
 * MDMOID_GPON_VEIP 2215
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    meId;	/**< ReadOnly */
    char *    interfaceName;	/**< ReadOnly */
    char *    administrativeState;	/**< ReadOnly */
    char *    operationalState;	/**< ReadOnly */
    char *    interDomainName;	/**< ReadOnly */
} GponVeipObject;

/*! \brief _GponVeipObject is used internally to represent GponVeipObject */
typedef GponVeipObject _GponVeipObject;



/*! \brief Obj struct for InternetGatewayDevice.X_RDK_ONT.Veip.{i}.EthernetFlow.
 *
 * MDMOID_GPON_VEIP_ETH_FLOW 2216
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
} GponVeipEthFlowObject;

/*! \brief _GponVeipEthFlowObject is used internally to represent GponVeipEthFlowObject */
typedef GponVeipEthFlowObject _GponVeipEthFlowObject;



/*! \brief Obj struct for InternetGatewayDevice.X_RDK_ONT.Veip.{i}.EthernetFlow.Ingress.
 *
 * MDMOID_GPON_VEIP_ETH_FLOW_INGRESS 2217
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    tagged;	/**< ReadWrite */
} GponVeipEthFlowIngressObject;

/*! \brief _GponVeipEthFlowIngressObject is used internally to represent GponVeipEthFlowIngressObject */
typedef GponVeipEthFlowIngressObject _GponVeipEthFlowIngressObject;



/*! \brief Obj struct for InternetGatewayDevice.X_RDK_ONT.Veip.{i}.EthernetFlow.Ingress.Q-VLAN.
 *
 * MDMOID_GPON_VEIP_ETH_FLOW_INGRESS_QVLAN 2218
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    vid;	/**< ReadWrite */
    UINT32    pcp;	/**< ReadWrite */
    UINT32    dei;	/**< ReadWrite */
} GponVeipEthFlowIngressQvlanObject;

/*! \brief _GponVeipEthFlowIngressQvlanObject is used internally to represent GponVeipEthFlowIngressQvlanObject */
typedef GponVeipEthFlowIngressQvlanObject _GponVeipEthFlowIngressQvlanObject;



/*! \brief Obj struct for InternetGatewayDevice.X_RDK_ONT.Veip.{i}.EthernetFlow.Egress.
 *
 * MDMOID_GPON_VEIP_ETH_FLOW_EGRESS 2219
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    tagged;	/**< ReadWrite */
} GponVeipEthFlowEgressObject;

/*! \brief _GponVeipEthFlowEgressObject is used internally to represent GponVeipEthFlowEgressObject */
typedef GponVeipEthFlowEgressObject _GponVeipEthFlowEgressObject;



/*! \brief Obj struct for InternetGatewayDevice.X_RDK_ONT.Veip.{i}.EthernetFlow.Egress.Q-VLAN.
 *
 * MDMOID_GPON_VEIP_ETH_FLOW_EGRESS_QVLAN 2220
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    vid;	/**< ReadWrite */
    UINT32    pcp;	/**< ReadWrite */
    UINT32    dei;	/**< ReadWrite */
} GponVeipEthFlowEgressQvlanObject;

/*! \brief _GponVeipEthFlowEgressQvlanObject is used internally to represent GponVeipEthFlowEgressQvlanObject */
typedef GponVeipEthFlowEgressQvlanObject _GponVeipEthFlowEgressQvlanObject;



/*! \brief Obj struct for InternetGatewayDevice.X_RDK_ONT.TR69.{i}.
 *
 * MDMOID_GPON_TR069_MGMT_SERVER 2221
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    managedEntityId;	/**< ReadOnly */
    UINT32    administrativeState;	/**< ReadOnly */
    char *    url;	/**< ReadOnly */
    char *    acsNetworkAddress;	/**< ReadOnly */
    UINT32    associatedTag;	/**< ReadOnly */
} GponTr069MgmtServerObject;

/*! \brief _GponTr069MgmtServerObject is used internally to represent GponTr069MgmtServerObject */
typedef GponTr069MgmtServerObject _GponTr069MgmtServerObject;



/*! \brief Obj struct for InternetGatewayDevice.X_RDK_ONT.Stats.
 *
 * MDMOID_GPON_STATS 2222
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
} GponStatsObject;

/*! \brief _GponStatsObject is used internally to represent GponStatsObject */
typedef GponStatsObject _GponStatsObject;



/*! \brief Obj struct for InternetGatewayDevice.X_RDK_ONT.GponVeipStats.{i}.
 *
 * MDMOID_GPON_VEIP_STAT 2223
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    ifName;	/**< ReadOnly */
    char *    direction;	/**< ReadOnly */
    UINT64    dropEvents;	/**< ReadOnly */
    UINT64    octets;	/**< ReadOnly */
    UINT64    frames;	/**< ReadOnly */
    UINT64    broadcastFrames;	/**< ReadOnly */
    UINT64    multicastFrames;	/**< ReadOnly */
    UINT64    crcErroredFrames;	/**< ReadOnly */
    UINT64    undersizeFrames;	/**< ReadOnly */
    UINT64    oversizeFrames;	/**< ReadOnly */
    UINT64    frames64Octets;	/**< ReadOnly */
    UINT64    frames65to127Octets;	/**< ReadOnly */
    UINT64    frames128to255Octets;	/**< ReadOnly */
    UINT64    frames256to511Octets;	/**< ReadOnly */
    UINT64    frames512to1023Octets;	/**< ReadOnly */
    UINT64    frames1024to1518Octets;	/**< ReadOnly */
} GponVeipStatObject;

/*! \brief _GponVeipStatObject is used internally to represent GponVeipStatObject */
typedef GponVeipStatObject _GponVeipStatObject;



/*! \brief Obj struct for InternetGatewayDevice.X_RDK_ONT.Gem.{i}.
 *
 * MDMOID_GPON_GEM_STAT 2224
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    portId;	/**< ReadOnly */
    char *    trafficType;	/**< ReadOnly */
    UINT32    allocId;	/**< ReadOnly */
    char *    type;	/**< ReadOnly */
    UINT32    transmittedFrames;	/**< ReadOnly */
    UINT64    receivedFrames;	/**< ReadOnly */
    UINT64    transmittedPayloadBytes;	/**< ReadOnly */
    UINT64    receivedPayloadBytes;	/**< ReadOnly */
    UINT32    encryptionKeyErrors;	/**< ReadOnly */
} GponGemStatObject;

/*! \brief _GponGemStatObject is used internally to represent GponGemStatObject */
typedef GponGemStatObject _GponGemStatObject;



/*! \brief Obj struct for InternetGatewayDevice.X_RDK_ONT.Gem.{i}.EthernetFlow.
 *
 * MDMOID_GPON_GEM_ETH_FLOW 2225
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
} GponGemEthFlowObject;

/*! \brief _GponGemEthFlowObject is used internally to represent GponGemEthFlowObject */
typedef GponGemEthFlowObject _GponGemEthFlowObject;



/*! \brief Obj struct for InternetGatewayDevice.X_RDK_ONT.Gem.{i}.EthernetFlow.Ingress.
 *
 * MDMOID_GPON_GEM_ETH_FLOW_INGRESS 2226
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    tagged;	/**< ReadWrite */
} GponGemEthFlowIngressObject;

/*! \brief _GponGemEthFlowIngressObject is used internally to represent GponGemEthFlowIngressObject */
typedef GponGemEthFlowIngressObject _GponGemEthFlowIngressObject;



/*! \brief Obj struct for InternetGatewayDevice.X_RDK_ONT.Gem.{i}.EthernetFlow.Ingress.C-VLAN.
 *
 * MDMOID_GPON_GEM_ETH_FLOW_INGRESS_C_VLAN 2227
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    vid;	/**< ReadWrite */
    UINT32    pcp;	/**< ReadWrite */
    UINT32    dei;	/**< ReadWrite */
} GponGemEthFlowIngressCVlanObject;

/*! \brief _GponGemEthFlowIngressCVlanObject is used internally to represent GponGemEthFlowIngressCVlanObject */
typedef GponGemEthFlowIngressCVlanObject _GponGemEthFlowIngressCVlanObject;



/*! \brief Obj struct for InternetGatewayDevice.X_RDK_ONT.Gem.{i}.EthernetFlow.Ingress.S-VLAN.
 *
 * MDMOID_GPON_GEM_ETH_FLOW_INGRESS_S_VLAN 2228
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    vid;	/**< ReadWrite */
    UINT32    pcp;	/**< ReadWrite */
    UINT32    dei;	/**< ReadWrite */
} GponGemEthFlowIngressSVlanObject;

/*! \brief _GponGemEthFlowIngressSVlanObject is used internally to represent GponGemEthFlowIngressSVlanObject */
typedef GponGemEthFlowIngressSVlanObject _GponGemEthFlowIngressSVlanObject;



/*! \brief Obj struct for InternetGatewayDevice.X_RDK_ONT.Gem.{i}.EthernetFlow.Egress.
 *
 * MDMOID_GPON_GEM_ETH_FLOW_EGRESS 2229
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    tagged;	/**< ReadWrite */
} GponGemEthFlowEgressObject;

/*! \brief _GponGemEthFlowEgressObject is used internally to represent GponGemEthFlowEgressObject */
typedef GponGemEthFlowEgressObject _GponGemEthFlowEgressObject;



/*! \brief Obj struct for InternetGatewayDevice.X_RDK_ONT.Gem.{i}.EthernetFlow.Egress.C-VLAN.
 *
 * MDMOID_GPON_GEM_ETH_FLOW_EGRESS_C_VLAN 2230
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    vid;	/**< ReadWrite */
    UINT32    pcp;	/**< ReadWrite */
    UINT32    dei;	/**< ReadWrite */
} GponGemEthFlowEgressCVlanObject;

/*! \brief _GponGemEthFlowEgressCVlanObject is used internally to represent GponGemEthFlowEgressCVlanObject */
typedef GponGemEthFlowEgressCVlanObject _GponGemEthFlowEgressCVlanObject;



/*! \brief Obj struct for InternetGatewayDevice.X_RDK_ONT.Gem.{i}.EthernetFlow.Egress.S-VLAN.
 *
 * MDMOID_GPON_GEM_ETH_FLOW_EGRESS_S_VLAN 2231
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    vid;	/**< ReadWrite */
    UINT32    pcp;	/**< ReadWrite */
    UINT32    dei;	/**< ReadWrite */
} GponGemEthFlowEgressSVlanObject;

/*! \brief _GponGemEthFlowEgressSVlanObject is used internally to represent GponGemEthFlowEgressSVlanObject */
typedef GponGemEthFlowEgressSVlanObject _GponGemEthFlowEgressSVlanObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_Container.
 *
 * MDMOID_CONTAINER 3500
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    containerNumberOfEntries;	/**< ReadOnly */
} ContainerObject;

/*! \brief _ContainerObject is used internally to represent ContainerObject */
typedef ContainerObject _ContainerObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_Container.ContainerInfo.{i}.
 *
 * MDMOID_CONTAINER_INFO 3501
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    standard;	/**< ReadOnly */
    char *    execEnvRef;	/**< ReadOnly */
    char *    referencePath;	/**< ReadOnly */
} ContainerInfoObject;

/*! \brief _ContainerInfoObject is used internally to represent ContainerInfoObject */
typedef ContainerInfoObject _ContainerInfoObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_Container.ContainerInfo.{i}.State.
 *
 * MDMOID_CONTAINER_STATE 3502
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    ID;	/**< ReadOnly */
    char *    name;	/**< ReadOnly */
    char *    status;	/**< ReadOnly */
    char *    PID;	/**< ReadOnly */
    char *    cpuUse;	/**< ReadOnly */
    char *    memoryUse;	/**< ReadOnly */
} ContainerStateObject;

/*! \brief _ContainerStateObject is used internally to represent ContainerStateObject */
typedef ContainerStateObject _ContainerStateObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_Container.ContainerInfo.{i}.Network.
 *
 * MDMOID_CONTAINER_NETWORK 3503
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    interface;	/**< ReadOnly */
    char *    IPv4Addresses;	/**< ReadOnly */
    char *    IPv6Addresses;	/**< ReadOnly */
    char *    ports;	/**< ReadOnly */
} ContainerNetworkObject;

/*! \brief _ContainerNetworkObject is used internally to represent ContainerNetworkObject */
typedef ContainerNetworkObject _ContainerNetworkObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_Container.ContainerInfo.{i}.Stats.
 *
 * MDMOID_CONTAINER_STATS 3504
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    bytesSent;	/**< ReadOnly */
    char *    bytesReceived;	/**< ReadOnly */
} ContainerStatsObject;

/*! \brief _ContainerStatsObject is used internally to represent ContainerStatsObject */
typedef ContainerStatsObject _ContainerStatsObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_SpeedService.
 *
 * MDMOID_SPEED_SERVICE 3580
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    diagnosticsState;	/**< ReadWrite */
    char *    mode;	/**< ReadWrite */
    char *    direction;	/**< ReadWrite */
    char *    dataPath;	/**< ReadWrite */
    char *    serverIpAddr;	/**< ReadWrite */
    UINT32    tcpPort;	/**< ReadWrite */
    UINT32    udpPort;	/**< ReadWrite */
    UINT32    stepDuration;	/**< ReadWrite */
    UINT32    packetLength;	/**< ReadWrite */
    UINT32    startingBwKbps;	/**< ReadWrite */
    char *    algorithm;	/**< ReadWrite */
    UINT32    maxSteps;	/**< ReadWrite */
    UINT32    acceptablePercentageLoss;	/**< ReadWrite */
    SINT32    latencyTolerancePercentage;	/**< ReadWrite */
    UINT32    maxLossPercentage;	/**< ReadWrite */
    char *    logBuffer;	/**< ReadOnly */
    UINT32    goodPut;	/**< ReadOnly */
    UINT32    payloadRate;	/**< ReadOnly */
    UINT32    packetLoss;	/**< ReadOnly */
    UINT32    avgLatency;	/**< ReadOnly */
    UINT32    adjustReceivedRate;	/**< ReadOnly */
    UINT32    receivedTime;	/**< ReadOnly */
    UINT32    overhead;	/**< ReadOnly */
    DATETIME  lastRunTime;	/**< ReadOnly */
    UINT32    resultHistoryNumberOfEntries;	/**< ReadOnly */
} SpeedServiceObject;

/*! \brief _SpeedServiceObject is used internally to represent SpeedServiceObject */
typedef SpeedServiceObject _SpeedServiceObject;



/*! \brief Obj struct for InternetGatewayDevice.X_BROADCOM_COM_SpeedService.ResultHistory.{i}.
 *
 * MDMOID_RESULT_HISTORY 3581
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    goodPut;	/**< ReadOnly */
    UINT32    payloadRate;	/**< ReadOnly */
    UINT32    packetLoss;	/**< ReadOnly */
    UINT32    avgLatency;	/**< ReadOnly */
    UINT32    adjustReceivedRate;	/**< ReadOnly */
    UINT32    receivedTime;	/**< ReadOnly */
    UINT32    overhead;	/**< ReadOnly */
    DATETIME  runTime;	/**< ReadOnly */
    char *    direction;	/**< ReadOnly */
} ResultHistoryObject;

/*! \brief _ResultHistoryObject is used internally to represent ResultHistoryObject */
typedef ResultHistoryObject _ResultHistoryObject;



/*! \brief Obj struct for InternetGatewayDevice.X_CT_OAM.
 *
 * MDMOID_CTOAM 2510
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
#ifdef DMP_ENDPOINT_1
    UINT32    portID;	/**< ReadWrite */
#endif
} CTOAMObject;

/*! \brief _CTOAMObject is used internally to represent CTOAMObject */
typedef CTOAMObject _CTOAMObject;



/*! \brief Obj struct for InternetGatewayDevice.X_CT_OAM.IADInfo.
 *
 * MDMOID_OAMIAD_INFO 2511
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
#ifdef DMP_ENDPOINT_1
    SINT32    branch;	/**< ReadWrite */
#endif
#ifdef DMP_ENDPOINT_1
    UINT32    leaf;	/**< ReadWrite */
#endif
#ifdef DMP_ENDPOINT_1
    UINT32    variableWidth;	/**< ReadWrite */
#endif
#ifdef DMP_ENDPOINT_1
    HEXBINARY  MACAddress;	/**< ReadWrite */
#endif
#ifdef DMP_ENDPOINT_1
    UINT32    protocolSupported;	/**< ReadWrite */
#endif
#ifdef DMP_ENDPOINT_1
    HEXBINARY  iadSoftwareVersion;	/**< ReadWrite */
#endif
#ifdef DMP_ENDPOINT_1
    HEXBINARY  iadSoftwaretime;	/**< ReadWrite */
#endif
#ifdef DMP_ENDPOINT_1
    UINT32    voipUserCount;	/**< ReadWrite */
#endif
} OAMIADInfoObject;

/*! \brief _OAMIADInfoObject is used internally to represent OAMIADInfoObject */
typedef OAMIADInfoObject _OAMIADInfoObject;



/*! \brief Obj struct for InternetGatewayDevice.X_CT_OAM.GlobalParameterConfig.
 *
 * MDMOID_OAM_GLB_PARAM_CFG 2512
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
#ifdef DMP_ENDPOINT_1
    SINT32    branch;	/**< ReadWrite */
#endif
#ifdef DMP_ENDPOINT_1
    UINT32    leaf;	/**< ReadWrite */
#endif
#ifdef DMP_ENDPOINT_1
    UINT32    variableWidth;	/**< ReadWrite */
#endif
#ifdef DMP_ENDPOINT_1
    UINT32    voiceIpMode;	/**< ReadWrite */
#endif
#ifdef DMP_ENDPOINT_1
    UINT32    ipAddr;	/**< ReadWrite */
#endif
#ifdef DMP_ENDPOINT_1
    UINT32    netMask;	/**< ReadWrite */
#endif
#ifdef DMP_ENDPOINT_1
    UINT32    defaultGW;	/**< ReadWrite */
#endif
#ifdef DMP_ENDPOINT_1
    UINT32    PPPoEMode;	/**< ReadWrite */
#endif
#ifdef DMP_ENDPOINT_1
    char *    PPPOEusername;	/**< ReadWrite */
#endif
#ifdef DMP_ENDPOINT_1
    BASE64    PPPOEpassword;	/**< ReadWrite */
#endif
#ifdef DMP_ENDPOINT_1
    UINT32    taggedflag;	/**< ReadWrite */
#endif
#ifdef DMP_ENDPOINT_1
    UINT32    voiceCVlan;	/**< ReadWrite */
#endif
#ifdef DMP_ENDPOINT_1
    UINT32    voiceSVlan;	/**< ReadWrite */
#endif
#ifdef DMP_ENDPOINT_1
    UINT32    voicePriority;	/**< ReadWrite */
#endif
#ifdef DMP_ENDPOINT_1
    UINT32    status;	/**< ReadWrite */
#endif
} OAMGlbParamCfgObject;

/*! \brief _OAMGlbParamCfgObject is used internally to represent OAMGlbParamCfgObject */
typedef OAMGlbParamCfgObject _OAMGlbParamCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.X_CT_OAM.SIPParameterConfig.
 *
 * MDMOID_OAMSIP_PARAM_CFG 2513
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
#ifdef DMP_ENDPOINT_1
    SINT32    branch;	/**< ReadWrite */
#endif
#ifdef DMP_ENDPOINT_1
    UINT32    leaf;	/**< ReadWrite */
#endif
#ifdef DMP_ENDPOINT_1
    UINT32    variableWidth;	/**< ReadWrite */
#endif
#ifdef DMP_ENDPOINT_1
    UINT32    MGPortNo;	/**< ReadWrite */
#endif
#ifdef DMP_ENDPOINT_1
    UINT32    sipProxyServIp;	/**< ReadWrite */
#endif
#ifdef DMP_ENDPOINT_1
    UINT32    sipProxyServComPortNo;	/**< ReadWrite */
#endif
#ifdef DMP_ENDPOINT_1
    UINT32    backupSipProxyServIp;	/**< ReadWrite */
#endif
#ifdef DMP_ENDPOINT_1
    UINT32    backUpSipProxyServComPortNo;	/**< ReadWrite */
#endif
#ifdef DMP_ENDPOINT_1
    UINT32    activeSipProxyServer;	/**< ReadWrite */
#endif
#ifdef DMP_ENDPOINT_1
    UINT32    sipRegServIP;	/**< ReadWrite */
#endif
#ifdef DMP_ENDPOINT_1
    UINT32    sipRegServComPortNo;	/**< ReadWrite */
#endif
#ifdef DMP_ENDPOINT_1
    UINT32    backupSipRegServIp;	/**< ReadWrite */
#endif
#ifdef DMP_ENDPOINT_1
    UINT32    backupSipRegServComPortNo;	/**< ReadWrite */
#endif
#ifdef DMP_ENDPOINT_1
    UINT32    outBoundServPortIP;	/**< ReadWrite */
#endif
#ifdef DMP_ENDPOINT_1
    UINT32    outBoundServPortNo;	/**< ReadWrite */
#endif
#ifdef DMP_ENDPOINT_1
    UINT32    sipRegIntervalSIP;	/**< ReadWrite */
#endif
#ifdef DMP_ENDPOINT_1
    UINT32    heartbeatSwitch;	/**< ReadWrite */
#endif
#ifdef DMP_ENDPOINT_1
    UINT32    heartbeatCycle;	/**< ReadWrite */
#endif
#ifdef DMP_ENDPOINT_1
    UINT32    heartbeatCount;	/**< ReadWrite */
#endif
} OAMSIPParamCfgObject;

/*! \brief _OAMSIPParamCfgObject is used internally to represent OAMSIPParamCfgObject */
typedef OAMSIPParamCfgObject _OAMSIPParamCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.X_CT_OAM.SIPUserParameterConfig.
 *
 * MDMOID_OAMSIP_USR_PARAM_CFG 2514
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
#ifdef DMP_ENDPOINT_1
    SINT32    branch;	/**< ReadWrite */
#endif
#ifdef DMP_ENDPOINT_1
    UINT32    leaf;	/**< ReadWrite */
#endif
#ifdef DMP_ENDPOINT_1
    UINT32    variableWidth;	/**< ReadWrite */
#endif
#ifdef DMP_ENDPOINT_1
    HEXBINARY  userAccount;	/**< ReadWrite */
#endif
#ifdef DMP_ENDPOINT_1
    HEXBINARY  username;	/**< ReadWrite */
#endif
#ifdef DMP_ENDPOINT_1
    HEXBINARY  userPassword;	/**< ReadWrite */
#endif
} OAMSIPUsrParamCfgObject;

/*! \brief _OAMSIPUsrParamCfgObject is used internally to represent OAMSIPUsrParamCfgObject */
typedef OAMSIPUsrParamCfgObject _OAMSIPUsrParamCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.X_CT_OAM.FAXModemConfig.
 *
 * MDMOID_OAMFAXMD_CFG 2515
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
#ifdef DMP_ENDPOINT_1
    SINT32    branch;	/**< ReadWrite */
#endif
#ifdef DMP_ENDPOINT_1
    UINT32    leaf;	/**< ReadWrite */
#endif
#ifdef DMP_ENDPOINT_1
    UINT32    variableWidth;	/**< ReadWrite */
#endif
#ifdef DMP_ENDPOINT_1
    UINT32    voiceT38Enable;	/**< ReadWrite */
#endif
#ifdef DMP_ENDPOINT_1
    UINT32    voiceFaxModemControl;	/**< ReadWrite */
#endif
} OAMFAXMDCfgObject;

/*! \brief _OAMFAXMDCfgObject is used internally to represent OAMFAXMDCfgObject */
typedef OAMFAXMDCfgObject _OAMFAXMDCfgObject;



/*! \brief Obj struct for InternetGatewayDevice.X_CT_OAM.POTSStatus.
 *
 * MDMOID_OAMPOTS_STS 2516
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
#ifdef DMP_ENDPOINT_1
    SINT32    branch;	/**< ReadWrite */
#endif
#ifdef DMP_ENDPOINT_1
    UINT32    leaf;	/**< ReadWrite */
#endif
#ifdef DMP_ENDPOINT_1
    UINT32    variableWidth;	/**< ReadWrite */
#endif
#ifdef DMP_ENDPOINT_1
    UINT32    IADPortStatus;	/**< ReadWrite */
#endif
#ifdef DMP_ENDPOINT_1
    UINT32    portServiceState;	/**< ReadWrite */
#endif
#ifdef DMP_ENDPOINT_1
    UINT32    portCodecMode;	/**< ReadWrite */
#endif
} OAMPOTSStsObject;

/*! \brief _OAMPOTSStsObject is used internally to represent OAMPOTSStsObject */
typedef OAMPOTSStsObject _OAMPOTSStsObject;



/*! \brief Obj struct for InternetGatewayDevice.X_CT_OAM.IADOperation.
 *
 * MDMOID_OAMIAD_OP 2517
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
#ifdef DMP_ENDPOINT_1
    UINT32    operation;	/**< ReadWrite */
#endif
} OAMIADOpObject;

/*! \brief _OAMIADOpObject is used internally to represent OAMIADOpObject */
typedef OAMIADOpObject _OAMIADOpObject;



/*! \brief Obj struct for InternetGatewayDevice.X_CT_OAM.SIPDigitMap.
 *
 * MDMOID_OAMSIP_DGT_MP 2518
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
#ifdef DMP_ENDPOINT_1
    char *    SIPDigitalMap;	/**< ReadWrite */
#endif
} OAMSIPDgtMpObject;

/*! \brief _OAMSIPDgtMpObject is used internally to represent OAMSIPDgtMpObject */
typedef OAMSIPDgtMpObject _OAMSIPDgtMpObject;



/*! \brief Obj struct for InternetGatewayDevice.Device.
 *
 * MDMOID_DEV2_DEVICE 1000
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
#ifdef DMP_DEVICE2_BASELINE_3
    char *    rootDataModelVersion;	/**< ReadOnly */
#endif
    UINT32    interfaceStackNumberOfEntries;	/**< ReadOnly */
} Dev2DeviceObject;

/*! \brief _Dev2DeviceObject is used internally to represent Dev2DeviceObject */
typedef Dev2DeviceObject _Dev2DeviceObject;



/*! \brief Obj struct for InternetGatewayDevice.Device.Services.
 *
 * MDMOID_DEV2_SERVICES 1003
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    storageServiceNumberOfEntries;	/**< ReadOnly */
    UINT32    voiceServiceNumberOfEntries;	/**< ReadOnly */
} Dev2ServicesObject;

/*! \brief _Dev2ServicesObject is used internally to represent Dev2ServicesObject */
typedef Dev2ServicesObject _Dev2ServicesObject;



/*! \brief Obj struct for InternetGatewayDevice.Device.GatewayInfo.
 *
 * MDMOID_DEV2_GATEWAY_INFO 1040
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    manufacturerOUI;	/**< ReadOnly */
    char *    productClass;	/**< ReadOnly */
    char *    serialNumber;	/**< ReadOnly */
} Dev2GatewayInfoObject;

/*! \brief _Dev2GatewayInfoObject is used internally to represent Dev2GatewayInfoObject */
typedef Dev2GatewayInfoObject _Dev2GatewayInfoObject;



/*! \brief Obj struct for InternetGatewayDevice.Device.InterfaceStack.{i}.
 *
 * MDMOID_DEV2_INTERFACE_STACK 1060
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    alias;	/**< ReadWrite */
#ifdef DMP_DEVICE2_BASELINE_2
    char *    higherLayer;	/**< ReadOnly */
#endif
#ifdef DMP_DEVICE2_BASELINE_2
    char *    lowerLayer;	/**< ReadOnly */
#endif
    char *    higherAlias;	/**< ReadOnly */
    char *    lowerAlias;	/**< ReadOnly */
} Dev2InterfaceStackObject;

/*! \brief _Dev2InterfaceStackObject is used internally to represent Dev2InterfaceStackObject */
typedef Dev2InterfaceStackObject _Dev2InterfaceStackObject;



/*! \brief Obj struct for InternetGatewayDevice.Device.Optical.
 *
 * MDMOID_DEVICE_OPTICAL 1110
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    interfaceNumberOfEntries;	/**< ReadOnly */
} DeviceOpticalObject;

/*! \brief _DeviceOpticalObject is used internally to represent DeviceOpticalObject */
typedef DeviceOpticalObject _DeviceOpticalObject;



/*! \brief Obj struct for InternetGatewayDevice.Device.Optical.Interface.{i}.
 *
 * MDMOID_OPTICAL_INTERFACE 1111
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    status;	/**< ReadOnly */
    char *    alias;	/**< ReadWrite */
    char *    name;	/**< ReadWrite */
    UINT32    lastChange;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_LastChange;	/**< ReadWrite */
    char *    lowerLayers;	/**< ReadWrite */
    UBOOL8    upstream;	/**< ReadOnly */
    SINT32    opticalSignalLevel;	/**< ReadOnly */
    SINT32    transmitOpticalLevel;	/**< ReadOnly */
    char *    X_BROADCOM_COM_PonType;	/**< ReadWrite */
    char *    X_BROADCOM_COM_PonRate;	/**< ReadWrite */
} OpticalInterfaceObject;

/*! \brief _OpticalInterfaceObject is used internally to represent OpticalInterfaceObject */
typedef OpticalInterfaceObject _OpticalInterfaceObject;



/*! \brief Obj struct for InternetGatewayDevice.Device.Optical.Interface.{i}.Stats.
 *
 * MDMOID_OPTICAL_INTERFACE_STATS 1112
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT64    bytesSent;	/**< ReadOnly */
    UINT64    bytesReceived;	/**< ReadOnly */
    UINT64    packetsSent;	/**< ReadOnly */
    UINT64    packetsReceived;	/**< ReadOnly */
    UINT32    errorsSent;	/**< ReadOnly */
    UINT32    errorsReceived;	/**< ReadOnly */
    UINT32    discardPacketsSent;	/**< ReadOnly */
    UINT32    discardPacketsReceived;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_MulticastPacketsSent;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_MulticastPacketsReceived;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_MulticastBytesSent;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_MulticastBytesReceived;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_UnicastPacketsSent;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_UnicastPacketsReceived;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_BroadcastPacketsSent;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_BroadcastPacketsReceived;	/**< ReadOnly */
} OpticalInterfaceStatsObject;

/*! \brief _OpticalInterfaceStatsObject is used internally to represent OpticalInterfaceStatsObject */
typedef OpticalInterfaceStatsObject _OpticalInterfaceStatsObject;



/*! \brief Obj struct for InternetGatewayDevice.Device.Ethernet.
 *
 * MDMOID_DEV2_ETHERNET 1150
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    interfaceNumberOfEntries;	/**< ReadOnly */
#ifdef DMP_DEVICE2_ETHERNETLINK_1
    UINT32    linkNumberOfEntries;	/**< ReadOnly */
#endif
#ifdef DMP_DEVICE2_VLANTERMINATION_1
    UINT32    VLANTerminationNumberOfEntries;	/**< ReadOnly */
#endif
#ifdef DMP_DEVICE2_ETHLAG_1
    UINT32    LAGNumberOfEntries;	/**< ReadOnly */
#endif
} Dev2EthernetObject;

/*! \brief _Dev2EthernetObject is used internally to represent Dev2EthernetObject */
typedef Dev2EthernetObject _Dev2EthernetObject;



/*! \brief Obj struct for InternetGatewayDevice.Device.Ethernet.Interface.{i}.
 *
 * MDMOID_DEV2_ETHERNET_INTERFACE 1152
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    status;	/**< ReadOnly */
    char *    alias;	/**< ReadWrite */
    char *    name;	/**< ReadOnly */
    UINT32    lastChange;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_LastChange;	/**< ReadWrite */
    char *    lowerLayers;	/**< ReadWrite */
    UBOOL8    upstream;	/**< ReadOnly */
    char *    MACAddress;	/**< ReadOnly */
    SINT32    maxBitRate;	/**< ReadWrite */
    char *    duplexMode;	/**< ReadWrite */
    UBOOL8    X_BROADCOM_COM_GMAC_Enabled;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_ShapingRate;	/**< ReadWrite */
    UINT32    X_BROADCOM_COM_ShapingBurstSize;	/**< ReadWrite */
    char *    X_BROADCOM_COM_WanLan_Attribute;	/**< ReadWrite */
#ifdef DMP_X_BROADCOM_COM_CABLEDIAGNOSTICS_1
    UBOOL8    X_BROADCOM_COM_CableDiagnostics_AutoEnabled;	/**< ReadWrite */
#endif
} Dev2EthernetInterfaceObject;

/*! \brief _Dev2EthernetInterfaceObject is used internally to represent Dev2EthernetInterfaceObject */
typedef Dev2EthernetInterfaceObject _Dev2EthernetInterfaceObject;



/*! \brief Obj struct for InternetGatewayDevice.Device.Ethernet.Interface.{i}.Stats.
 *
 * MDMOID_DEV2_ETHERNET_INTERFACE_STATS 1153
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT64    bytesSent;	/**< ReadOnly */
    UINT64    bytesReceived;	/**< ReadOnly */
    UINT64    packetsSent;	/**< ReadOnly */
    UINT64    packetsReceived;	/**< ReadOnly */
    UINT32    errorsSent;	/**< ReadOnly */
    UINT32    errorsReceived;	/**< ReadOnly */
    UINT64    unicastPacketsSent;	/**< ReadOnly */
    UINT64    unicastPacketsReceived;	/**< ReadOnly */
    UINT32    discardPacketsSent;	/**< ReadOnly */
    UINT32    discardPacketsReceived;	/**< ReadOnly */
    UINT64    X_BROADCOM_COM_MulticastBytesSent;	/**< ReadOnly */
    UINT64    X_BROADCOM_COM_MulticastBytesReceived;	/**< ReadOnly */
    UINT64    multicastPacketsSent;	/**< ReadOnly */
    UINT64    multicastPacketsReceived;	/**< ReadOnly */
    UINT64    broadcastPacketsSent;	/**< ReadOnly */
    UINT64    broadcastPacketsReceived;	/**< ReadOnly */
    UINT32    unknownProtoPacketsReceived;	/**< ReadOnly */
} Dev2EthernetInterfaceStatsObject;

/*! \brief _Dev2EthernetInterfaceStatsObject is used internally to represent Dev2EthernetInterfaceStatsObject */
typedef Dev2EthernetInterfaceStatsObject _Dev2EthernetInterfaceStatsObject;



/*! \brief Obj struct for InternetGatewayDevice.Device.Ethernet.Link.{i}.
 *
 * MDMOID_DEV2_ETHERNET_LINK 1154
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    status;	/**< ReadOnly */
    char *    alias;	/**< ReadWrite */
    char *    name;	/**< ReadOnly */
    UINT32    lastChange;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_LastChange;	/**< ReadWrite */
    char *    lowerLayers;	/**< ReadWrite */
    char *    MACAddress;	/**< ReadOnly */
} Dev2EthernetLinkObject;

/*! \brief _Dev2EthernetLinkObject is used internally to represent Dev2EthernetLinkObject */
typedef Dev2EthernetLinkObject _Dev2EthernetLinkObject;



/*! \brief Obj struct for InternetGatewayDevice.Device.Ethernet.VLANTermination.{i}.
 *
 * MDMOID_DEV2_VLAN_TERMINATION 1156
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    status;	/**< ReadOnly */
    char *    alias;	/**< ReadWrite */
    char *    name;	/**< ReadOnly */
    UINT32    lastChange;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_LastChange;	/**< ReadWrite */
    char *    lowerLayers;	/**< ReadWrite */
    SINT32    VLANID;	/**< ReadWrite */
    UINT32    TPID;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_Vlan8021p;	/**< ReadWrite */
} Dev2VlanTerminationObject;

/*! \brief _Dev2VlanTerminationObject is used internally to represent Dev2VlanTerminationObject */
typedef Dev2VlanTerminationObject _Dev2VlanTerminationObject;



/*! \brief Obj struct for InternetGatewayDevice.Device.Ethernet.LAG.{i}.
 *
 * MDMOID_LA_G 1170
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    status;	/**< ReadOnly */
    char *    alias;	/**< ReadWrite */
    char *    name;	/**< ReadOnly */
    UINT32    lastChange;	/**< ReadOnly */
    char *    lowerLayers;	/**< ReadOnly */
    char *    MACAddress;	/**< ReadWrite */
    UINT32    X_BROADCOM_COM_LastChange;	/**< ReadWrite */
    UBOOL8    X_BROADCOM_COM_Upstream;	/**< ReadWrite */
    char *    X_BROADCOM_COM_EthIfName1;	/**< ReadWrite */
    char *    X_BROADCOM_COM_EthIfName2;	/**< ReadWrite */
    char *    X_BROADCOM_COM_Mode;	/**< ReadWrite */
    char *    X_BROADCOM_COM_XmitHashPolicy;	/**< ReadWrite */
    char *    X_BROADCOM_COM_LacpRate;	/**< ReadWrite */
    char *    X_BROADCOM_COM_SelectionLogic;	/**< ReadWrite */
    UINT32    X_BROADCOM_COM_Miimon;	/**< ReadWrite */
} Dev2EthLAGObject;

/*! \brief _Dev2EthLAGObject is used internally to represent Dev2EthLAGObject */
typedef Dev2EthLAGObject _Dev2EthLAGObject;



/*! \brief Obj struct for InternetGatewayDevice.Device.Ethernet.LAG.{i}.Stats.
 *
 * MDMOID_LAG_STATS 1171
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT64    bytesSent;	/**< ReadOnly */
    UINT64    bytesReceived;	/**< ReadOnly */
    UINT64    packetsSent;	/**< ReadOnly */
    UINT64    packetsReceived;	/**< ReadOnly */
    UINT32    errorsSent;	/**< ReadOnly */
    UINT32    errorsReceived;	/**< ReadOnly */
    UINT64    unicastPacketsSent;	/**< ReadOnly */
    UINT64    unicastPacketsReceived;	/**< ReadOnly */
    UINT64    discardPacketsSent;	/**< ReadOnly */
    UINT64    discardPacketsReceived;	/**< ReadOnly */
    UINT64    multicastPacketsSent;	/**< ReadOnly */
    UINT64    multicastPacketsReceived;	/**< ReadOnly */
    UINT64    broadcastPacketsSent;	/**< ReadOnly */
    UINT64    broadcastPacketsReceived;	/**< ReadOnly */
    UINT64    unknownProtoPacketsReceived;	/**< ReadOnly */
} Dev2EthLAGStatsObject;

/*! \brief _Dev2EthLAGStatsObject is used internally to represent Dev2EthLAGStatsObject */
typedef Dev2EthLAGStatsObject _Dev2EthLAGStatsObject;



/*! \brief Obj struct for InternetGatewayDevice.Device.Ethernet.X_BROADCOM_COM_CableDiagnostics.
 *
 * MDMOID_DEV2_CABLE_DIAG 1158
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    diagnosticsState;	/**< ReadWrite */
    char *    interface;	/**< ReadWrite */
    UINT32    perInterfaceResultNumberOfEntries;	/**< ReadOnly */
} Dev2CableDiagObject;

/*! \brief _Dev2CableDiagObject is used internally to represent Dev2CableDiagObject */
typedef Dev2CableDiagObject _Dev2CableDiagObject;



/*! \brief Obj struct for InternetGatewayDevice.Device.Ethernet.X_BROADCOM_COM_CableDiagnostics.PerInterfaceResult.{i}.
 *
 * MDMOID_DEV2_CABLE_DIAG_PER_INTERFACE_RESULT 1159
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    interface;	/**< ReadOnly */
    DECIMAL    lengthMeter;	/**< ReadOnly */
    DATETIME  timestamp;	/**< ReadOnly */
    char *    type;	/**< ReadOnly */
    char *    linkStatus;	/**< ReadOnly */
    char *    status;	/**< ReadOnly */
} Dev2CableDiagPerInterfaceResultObject;

/*! \brief _Dev2CableDiagPerInterfaceResultObject is used internally to represent Dev2CableDiagPerInterfaceResultObject */
typedef Dev2CableDiagPerInterfaceResultObject _Dev2CableDiagPerInterfaceResultObject;



/*! \brief Obj struct for InternetGatewayDevice.Device.Ethernet.X_BROADCOM_COM_CableDiagnostics.PerInterfaceResult.{i}.BrownPair.
 *
 * MDMOID_DEV2_CABLE_DIAG_BROWN_PAIR 1160
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    status;	/**< ReadOnly */
    DECIMAL    lengthMeter;	/**< ReadOnly */
} Dev2CableDiagBrownPairObject;

/*! \brief _Dev2CableDiagBrownPairObject is used internally to represent Dev2CableDiagBrownPairObject */
typedef Dev2CableDiagBrownPairObject _Dev2CableDiagBrownPairObject;



/*! \brief Obj struct for InternetGatewayDevice.Device.Ethernet.X_BROADCOM_COM_CableDiagnostics.PerInterfaceResult.{i}.BluePair.
 *
 * MDMOID_DEV2_CABLE_DIAG_BLUE_PAIR 1161
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    status;	/**< ReadOnly */
    DECIMAL    lengthMeter;	/**< ReadOnly */
} Dev2CableDiagBluePairObject;

/*! \brief _Dev2CableDiagBluePairObject is used internally to represent Dev2CableDiagBluePairObject */
typedef Dev2CableDiagBluePairObject _Dev2CableDiagBluePairObject;



/*! \brief Obj struct for InternetGatewayDevice.Device.Ethernet.X_BROADCOM_COM_CableDiagnostics.PerInterfaceResult.{i}.GreenPair.
 *
 * MDMOID_DEV2_CABLE_DIAG_GREEN_PAIR 1162
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    status;	/**< ReadOnly */
    DECIMAL    lengthMeter;	/**< ReadOnly */
} Dev2CableDiagGreenPairObject;

/*! \brief _Dev2CableDiagGreenPairObject is used internally to represent Dev2CableDiagGreenPairObject */
typedef Dev2CableDiagGreenPairObject _Dev2CableDiagGreenPairObject;



/*! \brief Obj struct for InternetGatewayDevice.Device.Ethernet.X_BROADCOM_COM_CableDiagnostics.PerInterfaceResult.{i}.OrangePair.
 *
 * MDMOID_DEV2_CABLE_DIAG_ORANGE_PAIR 1163
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    status;	/**< ReadOnly */
    DECIMAL    lengthMeter;	/**< ReadOnly */
} Dev2CableDiagOrangePairObject;

/*! \brief _Dev2CableDiagOrangePairObject is used internally to represent Dev2CableDiagOrangePairObject */
typedef Dev2CableDiagOrangePairObject _Dev2CableDiagOrangePairObject;



/*! \brief Obj struct for InternetGatewayDevice.Device.PPP.
 *
 * MDMOID_DEV2_PPP 1290
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    interfaceNumberOfEntries;	/**< ReadOnly */
#ifdef DMP_DEVICE2_PPPINTERFACE_2
    char *    supportedNCPs;	/**< ReadOnly */
#endif
} Dev2PppObject;

/*! \brief _Dev2PppObject is used internally to represent Dev2PppObject */
typedef Dev2PppObject _Dev2PppObject;



/*! \brief Obj struct for InternetGatewayDevice.Device.PPP.Interface.{i}.
 *
 * MDMOID_DEV2_PPP_INTERFACE 1291
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    status;	/**< ReadOnly */
    char *    alias;	/**< ReadWrite */
    char *    name;	/**< ReadWrite */
    UINT32    lastChange;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_LastChange;	/**< ReadWrite */
    char *    lowerLayers;	/**< ReadWrite */
    UBOOL8    reset;	/**< ReadWrite */
    char *    connectionStatus;	/**< ReadOnly */
    char *    lastConnectionError;	/**< ReadOnly */
    UINT32    autoDisconnectTime;	/**< ReadWrite */
    UINT32    idleDisconnectTime;	/**< ReadWrite */
    UINT32    warnDisconnectDelay;	/**< ReadWrite */
    char *    username;	/**< ReadWrite */
    char *    password;	/**< ReadWrite */
    char *    encryptionProtocol;	/**< ReadOnly */
    char *    compressionProtocol;	/**< ReadOnly */
    char *    authenticationProtocol;	/**< ReadWrite */
    UINT32    maxMRUSize;	/**< ReadWrite */
    UINT32    currentMRUSize;	/**< ReadOnly */
    char *    connectionTrigger;	/**< ReadWrite */
    UINT32    LCPEcho;	/**< ReadOnly */
    UINT32    LCPEchoRetry;	/**< ReadOnly */
    UBOOL8    IPCPEnable;	/**< ReadWrite */
#ifdef DMP_DEVICE2_PPPINTERFACE_2
    UBOOL8    IPv6CPEnable;	/**< ReadWrite */
#endif
    UINT32    X_BROADCOM_COM_Pid;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_ConnectionEstablishedTime;	/**< ReadOnly */
    UBOOL8    X_BROADCOM_COM_UseStaticIPAddress;	/**< ReadWrite */
    char *    X_BROADCOM_COM_LocalIPAddress;	/**< ReadWrite */
    UBOOL8    X_BROADCOM_COM_Enable_Debug;	/**< ReadWrite */
    char *    X_BROADCOM_COM_UserRequest;	/**< ReadOnly */
} Dev2PppInterfaceObject;

/*! \brief _Dev2PppInterfaceObject is used internally to represent Dev2PppInterfaceObject */
typedef Dev2PppInterfaceObject _Dev2PppInterfaceObject;



/*! \brief Obj struct for InternetGatewayDevice.Device.PPP.Interface.{i}.PPPoA.
 *
 * MDMOID_DEV2_PPP_INTERFACE_PPOA 1292
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
} Dev2PppInterfacePpoaObject;

/*! \brief _Dev2PppInterfacePpoaObject is used internally to represent Dev2PppInterfacePpoaObject */
typedef Dev2PppInterfacePpoaObject _Dev2PppInterfacePpoaObject;



/*! \brief Obj struct for InternetGatewayDevice.Device.PPP.Interface.{i}.PPPoE.
 *
 * MDMOID_DEV2_PPP_INTERFACE_PPOE 1293
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    sessionID;	/**< ReadOnly */
    char *    ACName;	/**< ReadWrite */
    char *    serviceName;	/**< ReadWrite */
    UBOOL8    X_BROADCOM_COM_AddPppToBridge;	/**< ReadWrite */
    UBOOL8    X_BROADCOM_COM_IPExtension;	/**< ReadWrite */
} Dev2PppInterfacePpoeObject;

/*! \brief _Dev2PppInterfacePpoeObject is used internally to represent Dev2PppInterfacePpoeObject */
typedef Dev2PppInterfacePpoeObject _Dev2PppInterfacePpoeObject;



/*! \brief Obj struct for InternetGatewayDevice.Device.PPP.Interface.{i}.IPCP.
 *
 * MDMOID_DEV2_PPP_INTERFACE_IPCP 1294
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    localIPAddress;	/**< ReadOnly */
    char *    remoteIPAddress;	/**< ReadOnly */
    char *    DNSServers;	/**< ReadOnly */
} Dev2PppInterfaceIpcpObject;

/*! \brief _Dev2PppInterfaceIpcpObject is used internally to represent Dev2PppInterfaceIpcpObject */
typedef Dev2PppInterfaceIpcpObject _Dev2PppInterfaceIpcpObject;



/*! \brief Obj struct for InternetGatewayDevice.Device.PPP.Interface.{i}.IPv6CP.
 *
 * MDMOID_DEV2_PPP_INTERFACE_IPV6CP 1295
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    localInterfaceIdentifier;	/**< ReadOnly */
    char *    remoteInterfaceIdentifier;	/**< ReadOnly */
} Dev2PppInterfaceIpv6cpObject;

/*! \brief _Dev2PppInterfaceIpv6cpObject is used internally to represent Dev2PppInterfaceIpv6cpObject */
typedef Dev2PppInterfaceIpv6cpObject _Dev2PppInterfaceIpv6cpObject;



/*! \brief Obj struct for InternetGatewayDevice.Device.PPP.Interface.{i}.Stats.
 *
 * MDMOID_DEV2_PPP_INTERFACE_STATS 1296
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT64    bytesSent;	/**< ReadOnly */
    UINT64    bytesReceived;	/**< ReadOnly */
    UINT64    packetsSent;	/**< ReadOnly */
    UINT64    packetsReceived;	/**< ReadOnly */
    UINT32    errorsSent;	/**< ReadOnly */
    UINT32    errorsReceived;	/**< ReadOnly */
    UINT64    unicastPacketsSent;	/**< ReadOnly */
    UINT64    unicastPacketsReceived;	/**< ReadOnly */
    UINT32    discardPacketsSent;	/**< ReadOnly */
    UINT32    discardPacketsReceived;	/**< ReadOnly */
    UINT64    X_BROADCOM_COM_MulticastBytesSent;	/**< ReadOnly */
    UINT64    X_BROADCOM_COM_MulticastBytesReceived;	/**< ReadOnly */
    UINT64    multicastPacketsSent;	/**< ReadOnly */
    UINT64    multicastPacketsReceived;	/**< ReadOnly */
    UINT64    broadcastPacketsSent;	/**< ReadOnly */
    UINT64    broadcastPacketsReceived;	/**< ReadOnly */
    UINT32    unknownProtoPacketsReceived;	/**< ReadOnly */
} Dev2PppInterfaceStatsObject;

/*! \brief _Dev2PppInterfaceStatsObject is used internally to represent Dev2PppInterfaceStatsObject */
typedef Dev2PppInterfaceStatsObject _Dev2PppInterfaceStatsObject;



/*! \brief Obj struct for InternetGatewayDevice.Device.PPP.Interface.{i}.L2TP.
 *
 * MDMOID_DEV2_PPP_INTERFACE_L2TP 1297
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    tunnelName;	/**< ReadWrite */
    char *    lnsIpAddress;	/**< ReadWrite */
    char *    intfStatus;	/**< ReadOnly */
    UINT32    tunnelId;	/**< ReadOnly */
} Dev2PppInterfaceL2tpObject;

/*! \brief _Dev2PppInterfaceL2tpObject is used internally to represent Dev2PppInterfaceL2tpObject */
typedef Dev2PppInterfaceL2tpObject _Dev2PppInterfaceL2tpObject;



/*! \brief Obj struct for InternetGatewayDevice.Device.PPP.Interface.{i}.PPTP.
 *
 * MDMOID_DEV2_PPP_INTERFACE_PPTP 1298
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    pptpIpAddress;	/**< ReadWrite */
    char *    pptpusertname;	/**< ReadWrite */
    char *    pptppassword;	/**< ReadWrite */
} Dev2PppInterfacePptpObject;

/*! \brief _Dev2PppInterfacePptpObject is used internally to represent Dev2PppInterfacePptpObject */
typedef Dev2PppInterfacePptpObject _Dev2PppInterfacePptpObject;



/*! \brief Obj struct for InternetGatewayDevice.Device.PPP.Interface.{i}.L2TPNS.
 *
 * MDMOID_DEV2_PPP_INTERFACE_L2TP_NS 1299
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    lnsName;	/**< ReadWrite */
    char *    username;	/**< ReadWrite */
    char *    password;	/**< ReadWrite */
    char *    lnsLocalIp;	/**< ReadWrite */
    char *    peerSatrtIp;	/**< ReadWrite */
    char *    peerEndIp;	/**< ReadWrite */
    char *    lnsStatus;	/**< ReadOnly */
    UBOOL8    enableCHAP;	/**< ReadWrite */
    UBOOL8    enablePAP;	/**< ReadWrite */
    UBOOL8    enableMSCHAP;	/**< ReadWrite */
    UBOOL8    enableMSCHAPv2;	/**< ReadWrite */
    UBOOL8    enableLengthBit;	/**< ReadWrite */
} Dev2PppInterfaceL2tpNsObject;

/*! \brief _Dev2PppInterfaceL2tpNsObject is used internally to represent Dev2PppInterfaceL2tpNsObject */
typedef Dev2PppInterfaceL2tpNsObject _Dev2PppInterfaceL2tpNsObject;



/*! \brief Obj struct for InternetGatewayDevice.Device.PPP.Interface.{i}.PPTPNS.
 *
 * MDMOID_DEV2_PPP_INTERFACE_PPTP_NS 1300
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    pptpnsName;	/**< ReadWrite */
    char *    username;	/**< ReadWrite */
    char *    password;	/**< ReadWrite */
    char *    pptpnsLocalIp;	/**< ReadWrite */
    char *    peerSatrtIp;	/**< ReadWrite */
    char *    peerEndIp;	/**< ReadWrite */
    char *    pptpnsStatus;	/**< ReadOnly */
    UBOOL8    enableCHAP;	/**< ReadWrite */
    UBOOL8    enablePAP;	/**< ReadWrite */
    UBOOL8    enableMSCHAP;	/**< ReadWrite */
    UBOOL8    enableMSCHAPv2;	/**< ReadWrite */
    UBOOL8    enableDebugPptpns;	/**< ReadWrite */
} Dev2PppInterfacePptpNsObject;

/*! \brief _Dev2PppInterfacePptpNsObject is used internally to represent Dev2PppInterfacePptpNsObject */
typedef Dev2PppInterfacePptpNsObject _Dev2PppInterfacePptpNsObject;



/*! \brief Obj struct for InternetGatewayDevice.Device.IP.
 *
 * MDMOID_DEV2_IP 1400
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    IPv4Capable;	/**< ReadOnly */
#ifdef DMP_DEVICE2_IPINTERFACE_2
    UBOOL8    IPv4Enable;	/**< ReadWrite */
#endif
#ifdef DMP_DEVICE2_IPINTERFACE_2
    char *    IPv4Status;	/**< ReadOnly */
#endif
#ifdef DMP_DEVICE2_IPV6INTERFACE_1
    UBOOL8    IPv6Capable;	/**< ReadOnly */
#endif
#ifdef DMP_DEVICE2_IPV6INTERFACE_1
    UBOOL8    IPv6Enable;	/**< ReadWrite */
#endif
#ifdef DMP_DEVICE2_IPV6INTERFACE_1
    char *    IPv6Status;	/**< ReadOnly */
#endif
#ifdef DMP_DEVICE2_IPV6INTERFACE_1
    char *    ULAPrefix;	/**< ReadWrite */
#endif
    UINT32    interfaceNumberOfEntries;	/**< ReadOnly */
} Dev2IpObject;

/*! \brief _Dev2IpObject is used internally to represent Dev2IpObject */
typedef Dev2IpObject _Dev2IpObject;



/*! \brief Obj struct for InternetGatewayDevice.Device.IP.Interface.{i}.
 *
 * MDMOID_DEV2_IP_INTERFACE 1401
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
#ifdef DMP_DEVICE2_IPINTERFACE_2
    UBOOL8    IPv4Enable;	/**< ReadWrite */
#endif
#ifdef DMP_DEVICE2_IPV6INTERFACE_1
    UBOOL8    IPv6Enable;	/**< ReadWrite */
#endif
#ifdef DMP_DEVICE2_IPV6INTERFACE_1
    UBOOL8    ULAEnable;	/**< ReadWrite */
#endif
    UBOOL8    X_BROADCOM_COM_ULARandom;	/**< ReadWrite */
    char *    status;	/**< ReadOnly */
    char *    alias;	/**< ReadWrite */
    char *    name;	/**< ReadOnly */
    UINT32    lastChange;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_LastChange;	/**< ReadWrite */
    char *    lowerLayers;	/**< ReadWrite */
    char *    router;	/**< ReadWrite */
    UBOOL8    reset;	/**< ReadWrite */
    UINT32    maxMTUSize;	/**< ReadWrite */
    char *    type;	/**< ReadOnly */
    UBOOL8    loopback;	/**< ReadWrite */
    UINT32    IPv4AddressNumberOfEntries;	/**< ReadOnly */
#ifdef DMP_DEVICE2_IPV6INTERFACE_1
    UINT32    IPv6AddressNumberOfEntries;	/**< ReadOnly */
#endif
#ifdef DMP_DEVICE2_IPV6INTERFACE_1
    UINT32    IPv6PrefixNumberOfEntries;	/**< ReadOnly */
#endif
    UBOOL8    autoIPEnable;	/**< ReadWrite */
    char *    X_BROADCOM_COM_IPv4ServiceStatus;	/**< ReadOnly */
    char *    X_BROADCOM_COM_IPv6ServiceStatus;	/**< ReadOnly */
    UBOOL8    X_BROADCOM_COM_Upstream;	/**< ReadOnly */
    char *    X_BROADCOM_COM_GroupName;	/**< ReadWrite */
    UBOOL8    X_BROADCOM_COM_BridgeService;	/**< ReadWrite */
    char *    X_BROADCOM_COM_BridgeName;	/**< ReadWrite */
    UBOOL8    X_BROADCOM_COM_BridgeNeedsIpAddr;	/**< ReadWrite */
    UBOOL8    X_BROADCOM_COM_FirewallEnabled;	/**< ReadWrite */
#ifdef DMP_X_BROADCOM_COM_IGMP_1
    UBOOL8    X_BROADCOM_COM_IGMPEnabled;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_IGMP_1
    UBOOL8    X_BROADCOM_COM_IGMP_SOURCEEnabled;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_MLD_1
    UBOOL8    X_BROADCOM_COM_MLDEnabled;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_MLD_1
    UBOOL8    X_BROADCOM_COM_MLD_SOURCEEnabled;	/**< ReadWrite */
#endif
    UBOOL8    X_BROADCOM_COM_Mflag_Upstream;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_PCPMode;	/**< ReadWrite */
    char *    X_BROADCOM_COM_PCPServer;	/**< ReadWrite */
} Dev2IpInterfaceObject;

/*! \brief _Dev2IpInterfaceObject is used internally to represent Dev2IpInterfaceObject */
typedef Dev2IpInterfaceObject _Dev2IpInterfaceObject;



/*! \brief Obj struct for InternetGatewayDevice.Device.IP.Interface.{i}.IPv4Address.{i}.
 *
 * MDMOID_DEV2_IPV4_ADDRESS 1402
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
#ifdef DMP_DEVICE2_IPINTERFACE_2
    char *    status;	/**< ReadOnly */
#endif
    char *    alias;	/**< ReadWrite */
    char *    IPAddress;	/**< ReadWrite */
    char *    subnetMask;	/**< ReadWrite */
    char *    addressingType;	/**< ReadOnly */
} Dev2Ipv4AddressObject;

/*! \brief _Dev2Ipv4AddressObject is used internally to represent Dev2Ipv4AddressObject */
typedef Dev2Ipv4AddressObject _Dev2Ipv4AddressObject;



/*! \brief Obj struct for InternetGatewayDevice.Device.IP.Interface.{i}.IPv6Address.{i}.
 *
 * MDMOID_DEV2_IPV6_ADDRESS 1403
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    status;	/**< ReadOnly */
    char *    IPAddressStatus;	/**< ReadOnly */
    char *    alias;	/**< ReadWrite */
    char *    IPAddress;	/**< ReadWrite */
    char *    origin;	/**< ReadOnly */
    char *    prefix;	/**< ReadWrite */
    DATETIME  preferredLifetime;	/**< ReadWrite */
    DATETIME  validLifetime;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_Plt;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_Vlt;	/**< ReadWrite */
    UBOOL8    anycast;	/**< ReadWrite */
} Dev2Ipv6AddressObject;

/*! \brief _Dev2Ipv6AddressObject is used internally to represent Dev2Ipv6AddressObject */
typedef Dev2Ipv6AddressObject _Dev2Ipv6AddressObject;



/*! \brief Obj struct for InternetGatewayDevice.Device.IP.Interface.{i}.IPv6Prefix.{i}.
 *
 * MDMOID_DEV2_IPV6_PREFIX 1404
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    status;	/**< ReadOnly */
    char *    prefixStatus;	/**< ReadOnly */
    char *    alias;	/**< ReadWrite */
    char *    prefix;	/**< ReadWrite */
    char *    origin;	/**< ReadOnly */
    char *    staticType;	/**< ReadWrite */
    char *    parentPrefix;	/**< ReadWrite */
    char *    childPrefixBits;	/**< ReadWrite */
    UBOOL8    onLink;	/**< ReadWrite */
    UBOOL8    autonomous;	/**< ReadWrite */
    DATETIME  preferredLifetime;	/**< ReadWrite */
    DATETIME  validLifetime;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_Plt;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_Vlt;	/**< ReadWrite */
    UBOOL8    X_BROADCOM_COM_UniqueLocalFlag;	/**< ReadWrite */
    char *    X_BROADCOM_COM_Prefix_Old;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_Vlt_Old;	/**< ReadWrite */
} Dev2Ipv6PrefixObject;

/*! \brief _Dev2Ipv6PrefixObject is used internally to represent Dev2Ipv6PrefixObject */
typedef Dev2Ipv6PrefixObject _Dev2Ipv6PrefixObject;



/*! \brief Obj struct for InternetGatewayDevice.Device.IP.Interface.{i}.Stats.
 *
 * MDMOID_DEV2_IP_STATS 1405
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT64    bytesSent;	/**< ReadOnly */
    UINT64    bytesReceived;	/**< ReadOnly */
    UINT64    packetsSent;	/**< ReadOnly */
    UINT64    packetsReceived;	/**< ReadOnly */
    UINT32    errorsSent;	/**< ReadOnly */
    UINT32    errorsReceived;	/**< ReadOnly */
    UINT64    unicastPacketsSent;	/**< ReadOnly */
    UINT64    unicastPacketsReceived;	/**< ReadOnly */
    UINT32    discardPacketsSent;	/**< ReadOnly */
    UINT32    discardPacketsReceived;	/**< ReadOnly */
    UINT64    X_BROADCOM_COM_MulticastBytesSent;	/**< ReadOnly */
    UINT64    X_BROADCOM_COM_MulticastBytesReceived;	/**< ReadOnly */
    UINT64    multicastPacketsSent;	/**< ReadOnly */
    UINT64    multicastPacketsReceived;	/**< ReadOnly */
    UINT64    broadcastPacketsSent;	/**< ReadOnly */
    UINT64    broadcastPacketsReceived;	/**< ReadOnly */
    UINT32    unknownProtoPacketsReceived;	/**< ReadOnly */
} Dev2IpStatsObject;

/*! \brief _Dev2IpStatsObject is used internally to represent Dev2IpStatsObject */
typedef Dev2IpStatsObject _Dev2IpStatsObject;



/*! \brief Obj struct for InternetGatewayDevice.Device.Routing.
 *
 * MDMOID_DEV2_ROUTING 1460
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    routerNumberOfEntries;	/**< ReadOnly */
} Dev2RoutingObject;

/*! \brief _Dev2RoutingObject is used internally to represent Dev2RoutingObject */
typedef Dev2RoutingObject _Dev2RoutingObject;



/*! \brief Obj struct for InternetGatewayDevice.Device.Routing.Router.{i}.
 *
 * MDMOID_DEV2_ROUTER 1461
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    status;	/**< ReadOnly */
    char *    alias;	/**< ReadWrite */
    UINT32    IPv4ForwardingNumberOfEntries;	/**< ReadOnly */
#ifdef DMP_DEVICE2_IPV6ROUTING_1
    UINT32    IPv6ForwardingNumberOfEntries;	/**< ReadOnly */
#endif
    char *    X_BROADCOM_COM_DefaultConnectionServices;	/**< ReadWrite */
    char *    X_BROADCOM_COM_ActiveDefaultGateway;	/**< ReadOnly */
#ifdef DMP_X_BROADCOM_COM_DEV2_IPV6_1
    char *    X_BROADCOM_COM_DefaultIpv6ConnectionServices;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_DEV2_IPV6_1
    char *    X_BROADCOM_COM_ActiveIpv6DefaultGateway;	/**< ReadOnly */
#endif
} Dev2RouterObject;

/*! \brief _Dev2RouterObject is used internally to represent Dev2RouterObject */
typedef Dev2RouterObject _Dev2RouterObject;



/*! \brief Obj struct for InternetGatewayDevice.Device.Routing.Router.{i}.IPv4Forwarding.{i}.
 *
 * MDMOID_DEV2_IPV4_FORWARDING 1462
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    status;	/**< ReadOnly */
    char *    alias;	/**< ReadWrite */
    UBOOL8    staticRoute;	/**< ReadOnly */
    char *    destIPAddress;	/**< ReadWrite */
    char *    destSubnetMask;	/**< ReadWrite */
    char *    gatewayIPAddress;	/**< ReadWrite */
    char *    interface;	/**< ReadWrite */
#ifdef DMP_DEVICE2_ROUTING_2
    char *    origin;	/**< ReadOnly */
#endif
    SINT32    forwardingMetric;	/**< ReadWrite */
    char *    X_BROADCOM_COM_PolicyRoutingName;	/**< ReadWrite */
    char *    X_BROADCOM_COM_SourceIfName;	/**< ReadWrite */
    char *    X_BROADCOM_COM_SourceIPAddress;	/**< ReadWrite */
} Dev2Ipv4ForwardingObject;

/*! \brief _Dev2Ipv4ForwardingObject is used internally to represent Dev2Ipv4ForwardingObject */
typedef Dev2Ipv4ForwardingObject _Dev2Ipv4ForwardingObject;



/*! \brief Obj struct for InternetGatewayDevice.Device.Routing.Router.{i}.IPv6Forwarding.{i}.
 *
 * MDMOID_DEV2_IPV6_FORWARDING 1463
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    status;	/**< ReadOnly */
    char *    alias;	/**< ReadWrite */
    char *    destIPPrefix;	/**< ReadWrite */
    char *    nextHop;	/**< ReadWrite */
    char *    interface;	/**< ReadWrite */
    char *    origin;	/**< ReadOnly */
    SINT32    forwardingMetric;	/**< ReadWrite */
} Dev2Ipv6ForwardingObject;

/*! \brief _Dev2Ipv6ForwardingObject is used internally to represent Dev2Ipv6ForwardingObject */
typedef Dev2Ipv6ForwardingObject _Dev2Ipv6ForwardingObject;



/*! \brief Obj struct for InternetGatewayDevice.Device.Routing.RouteInformation.
 *
 * MDMOID_DEV2_ROUTE_INFO 1466
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    UINT32    interfaceSettingNumberOfEntries;	/**< ReadOnly */
} Dev2RouteInfoObject;

/*! \brief _Dev2RouteInfoObject is used internally to represent Dev2RouteInfoObject */
typedef Dev2RouteInfoObject _Dev2RouteInfoObject;



/*! \brief Obj struct for InternetGatewayDevice.Device.Routing.RouteInformation.InterfaceSetting.{i}.
 *
 * MDMOID_DEV2_ROUTE_INFO_INTF_SETTING 1467
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    status;	/**< ReadOnly */
    char *    interface;	/**< ReadOnly */
    char *    sourceRouter;	/**< ReadOnly */
    char *    preferredRouteFlag;	/**< ReadOnly */
    char *    prefix;	/**< ReadOnly */
    DATETIME  routeLifetime;	/**< ReadOnly */
} Dev2RouteInfoIntfSettingObject;

/*! \brief _Dev2RouteInfoIntfSettingObject is used internally to represent Dev2RouteInfoIntfSettingObject */
typedef Dev2RouteInfoIntfSettingObject _Dev2RouteInfoIntfSettingObject;



/*! \brief Obj struct for InternetGatewayDevice.Device.NeighborDiscovery.
 *
 * MDMOID_DEV2_NEIGHBOR_DISCOVERY 1470
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    UINT32    interfaceSettingNumberOfEntries;	/**< ReadOnly */
} Dev2NeighborDiscoveryObject;

/*! \brief _Dev2NeighborDiscoveryObject is used internally to represent Dev2NeighborDiscoveryObject */
typedef Dev2NeighborDiscoveryObject _Dev2NeighborDiscoveryObject;



/*! \brief Obj struct for InternetGatewayDevice.Device.NeighborDiscovery.InterfaceSetting.{i}.
 *
 * MDMOID_DEV2_NEIGHBOR_DISCOVERY_INTERFACE_SETTING 1471
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    status;	/**< ReadOnly */
    char *    alias;	/**< ReadWrite */
    char *    interface;	/**< ReadWrite */
    UINT32    retransTimer;	/**< ReadWrite */
    UINT32    rtrSolicitationInterval;	/**< ReadWrite */
    UINT32    maxRtrSolicitations;	/**< ReadWrite */
} Dev2NeighborDiscoveryInterfaceSettingObject;

/*! \brief _Dev2NeighborDiscoveryInterfaceSettingObject is used internally to represent Dev2NeighborDiscoveryInterfaceSettingObject */
typedef Dev2NeighborDiscoveryInterfaceSettingObject _Dev2NeighborDiscoveryInterfaceSettingObject;



/*! \brief Obj struct for InternetGatewayDevice.Device.RouterAdvertisement.
 *
 * MDMOID_DEV2_ROUTER_ADVERTISEMENT 1472
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    UINT32    interfaceSettingNumberOfEntries;	/**< ReadOnly */
} Dev2RouterAdvertisementObject;

/*! \brief _Dev2RouterAdvertisementObject is used internally to represent Dev2RouterAdvertisementObject */
typedef Dev2RouterAdvertisementObject _Dev2RouterAdvertisementObject;



/*! \brief Obj struct for InternetGatewayDevice.Device.RouterAdvertisement.InterfaceSetting.{i}.
 *
 * MDMOID_DEV2_ROUTER_ADVERTISEMENT_INTERFACE_SETTING 1473
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    status;	/**< ReadOnly */
    char *    alias;	/**< ReadWrite */
    char *    interface;	/**< ReadWrite */
    char *    manualPrefixes;	/**< ReadWrite */
    char *    prefixes;	/**< ReadOnly */
    UINT32    maxRtrAdvInterval;	/**< ReadWrite */
    UINT32    minRtrAdvInterval;	/**< ReadWrite */
    UINT32    advDefaultLifetime;	/**< ReadWrite */
    UBOOL8    advManagedFlag;	/**< ReadWrite */
    UBOOL8    advOtherConfigFlag;	/**< ReadWrite */
    char *    advPreferredRouterFlag;	/**< ReadWrite */
    UBOOL8    advNDProxyFlag;	/**< ReadWrite */
    UINT32    advLinkMTU;	/**< ReadWrite */
    UINT32    advReachableTime;	/**< ReadWrite */
    UINT32    advRetransTimer;	/**< ReadWrite */
    UINT32    advCurHopLimit;	/**< ReadWrite */
    UINT32    optionNumberOfEntries;	/**< ReadOnly */
} Dev2RouterAdvertisementInterfaceSettingObject;

/*! \brief _Dev2RouterAdvertisementInterfaceSettingObject is used internally to represent Dev2RouterAdvertisementInterfaceSettingObject */
typedef Dev2RouterAdvertisementInterfaceSettingObject _Dev2RouterAdvertisementInterfaceSettingObject;



/*! \brief Obj struct for InternetGatewayDevice.Device.IPv6rd.
 *
 * MDMOID_DEV2_IPV6RD 1480
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    UINT32    interfaceSettingNumberOfEntries;	/**< ReadOnly */
} Dev2Ipv6rdObject;

/*! \brief _Dev2Ipv6rdObject is used internally to represent Dev2Ipv6rdObject */
typedef Dev2Ipv6rdObject _Dev2Ipv6rdObject;



/*! \brief Obj struct for InternetGatewayDevice.Device.IPv6rd.InterfaceSetting.{i}.
 *
 * MDMOID_DEV2_IPV6RD_INTERFACE_SETTING 1481
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    status;	/**< ReadOnly */
    char *    alias;	/**< ReadWrite */
    char *    borderRelayIPv4Addresses;	/**< ReadWrite */
    UBOOL8    allTrafficToBorderRelay;	/**< ReadWrite */
    char *    SPIPv6Prefix;	/**< ReadWrite */
    UINT32    IPv4MaskLength;	/**< ReadWrite */
    char *    addressSource;	/**< ReadWrite */
    char *    tunnelInterface;	/**< ReadOnly */
    char *    tunneledInterface;	/**< ReadOnly */
    char *    X_BROADCOM_COM_TunnelName;	/**< ReadWrite */
    char *    X_BROADCOM_COM_TunnelInterface;	/**< ReadWrite */
    char *    X_BROADCOM_COM_TunneledInterface;	/**< ReadWrite */
    UBOOL8    X_BROADCOM_COM_Dynamic;	/**< ReadWrite */
} Dev2Ipv6rdInterfaceSettingObject;

/*! \brief _Dev2Ipv6rdInterfaceSettingObject is used internally to represent Dev2Ipv6rdInterfaceSettingObject */
typedef Dev2Ipv6rdInterfaceSettingObject _Dev2Ipv6rdInterfaceSettingObject;



/*! \brief Obj struct for InternetGatewayDevice.Device.DSLite.
 *
 * MDMOID_DEV2_DSLITE 1490
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    UINT32    interfaceSettingNumberOfEntries;	/**< ReadOnly */
} Dev2DsliteObject;

/*! \brief _Dev2DsliteObject is used internally to represent Dev2DsliteObject */
typedef Dev2DsliteObject _Dev2DsliteObject;



/*! \brief Obj struct for InternetGatewayDevice.Device.DSLite.InterfaceSetting.{i}.
 *
 * MDMOID_DEV2_DSLITE_INTERFACE_SETTING 1491
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    status;	/**< ReadOnly */
    char *    alias;	/**< ReadWrite */
    char *    endpointAssignmentPrecedence;	/**< ReadWrite */
#ifdef DMP_DEVICE2_DSLITE_2
    char *    endpointAddressTypePrecedence;	/**< ReadWrite */
#endif
#ifdef DMP_DEVICE2_DSLITE_2
    char *    endpointAddressInUse;	/**< ReadOnly */
#endif
    char *    endpointName;	/**< ReadWrite */
    char *    endpointAddress;	/**< ReadWrite */
    char *    origin;	/**< ReadOnly */
    char *    tunnelInterface;	/**< ReadOnly */
    char *    tunneledInterface;	/**< ReadOnly */
    char *    X_BROADCOM_COM_TunnelName;	/**< ReadWrite */
    char *    X_BROADCOM_COM_TunnelInterface;	/**< ReadWrite */
    char *    X_BROADCOM_COM_TunneledInterface;	/**< ReadWrite */
} Dev2DsliteInterfaceSettingObject;

/*! \brief _Dev2DsliteInterfaceSettingObject is used internally to represent Dev2DsliteInterfaceSettingObject */
typedef Dev2DsliteInterfaceSettingObject _Dev2DsliteInterfaceSettingObject;



/*! \brief Obj struct for InternetGatewayDevice.Device.MAP.
 *
 * MDMOID_DEV2_MAP 1910
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    UINT32    domainNumberOfEntries;	/**< ReadOnly */
} Dev2MapObject;

/*! \brief _Dev2MapObject is used internally to represent Dev2MapObject */
typedef Dev2MapObject _Dev2MapObject;



/*! \brief Obj struct for InternetGatewayDevice.Device.MAP.Domain.{i}.
 *
 * MDMOID_DEV2_MAP_DOMAIN 1911
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    status;	/**< ReadOnly */
    char *    alias;	/**< ReadWrite */
    char *    transportMode;	/**< ReadWrite */
    char *    WANInterface;	/**< ReadWrite */
    char *    IPv6Prefix;	/**< ReadWrite */
    char *    BRIPv6Prefix;	/**< ReadWrite */
#ifdef DMP_DEVICE2_MAPADV_1
    UINT32    PSIDOffset;	/**< ReadWrite */
#endif
#ifdef DMP_DEVICE2_MAPADV_1
    UINT32    PSIDLength;	/**< ReadWrite */
#endif
#ifdef DMP_DEVICE2_MAPADV_1
    UINT32    PSID;	/**< ReadWrite */
#endif
#ifdef DMP_DEVICE2_MAPADV_1
    UBOOL8    includeSystemPorts;	/**< ReadWrite */
#endif
    UINT32    ruleNumberOfEntries;	/**< ReadOnly */
} Dev2MapDomainObject;

/*! \brief _Dev2MapDomainObject is used internally to represent Dev2MapDomainObject */
typedef Dev2MapDomainObject _Dev2MapDomainObject;



/*! \brief Obj struct for InternetGatewayDevice.Device.MAP.Domain.{i}.Rule.{i}.
 *
 * MDMOID_DEV2_MAP_DOMAIN_RULE 1912
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    status;	/**< ReadOnly */
    char *    alias;	/**< ReadWrite */
    char *    origin;	/**< ReadOnly */
    char *    IPv6Prefix;	/**< ReadWrite */
    char *    IPv4Prefix;	/**< ReadWrite */
#ifdef DMP_DEVICE2_MAPADV_1
    UINT32    EABitsLength;	/**< ReadWrite */
#endif
    UBOOL8    isFMR;	/**< ReadWrite */
} Dev2MapDomainRuleObject;

/*! \brief _Dev2MapDomainRuleObject is used internally to represent Dev2MapDomainRuleObject */
typedef Dev2MapDomainRuleObject _Dev2MapDomainRuleObject;



/*! \brief Obj struct for InternetGatewayDevice.Device.LANConfigSecurity.
 *
 * MDMOID_DEV2_LAN_CONFIG_SECURITY 1510
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    configPassword;	/**< ReadWrite */
} Dev2LanConfigSecurityObject;

/*! \brief _Dev2LanConfigSecurityObject is used internally to represent Dev2LanConfigSecurityObject */
typedef Dev2LanConfigSecurityObject _Dev2LanConfigSecurityObject;



/*! \brief Obj struct for InternetGatewayDevice.Device.DNS.
 *
 * MDMOID_DEV2_DNS 1530
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
#ifdef DMP_DEVICE2_BASELINE_2
    char *    supportedRecordTypes;	/**< ReadOnly */
#endif
} Dev2DnsObject;

/*! \brief _Dev2DnsObject is used internally to represent Dev2DnsObject */
typedef Dev2DnsObject _Dev2DnsObject;



/*! \brief Obj struct for InternetGatewayDevice.Device.DNS.Client.
 *
 * MDMOID_DEV2_DNS_CLIENT 1531
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    status;	/**< ReadOnly */
    UINT32    serverNumberOfEntries;	/**< ReadOnly */
    char *    X_BROADCOM_COM_DnsIfNames;	/**< ReadWrite */
    char *    X_BROADCOM_COM_ActiveDnsIfName;	/**< ReadWrite */
    char *    X_BROADCOM_COM_ActiveDnsServers;	/**< ReadWrite */
    char *    X_BROADCOM_COM_Ipv6_DnsIfNames;	/**< ReadWrite */
    char *    X_BROADCOM_COM_Ipv6_ActiveDnsIfName;	/**< ReadWrite */
    char *    X_BROADCOM_COM_Ipv6_ActiveDnsServers;	/**< ReadWrite */
} Dev2DnsClientObject;

/*! \brief _Dev2DnsClientObject is used internally to represent Dev2DnsClientObject */
typedef Dev2DnsClientObject _Dev2DnsClientObject;



/*! \brief Obj struct for InternetGatewayDevice.Device.DNS.Client.Server.{i}.
 *
 * MDMOID_DEV2_DNS_SERVER 1532
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    status;	/**< ReadOnly */
    char *    alias;	/**< ReadWrite */
    char *    DNSServer;	/**< ReadWrite */
    char *    interface;	/**< ReadWrite */
    char *    type;	/**< ReadOnly */
} Dev2DnsServerObject;

/*! \brief _Dev2DnsServerObject is used internally to represent Dev2DnsServerObject */
typedef Dev2DnsServerObject _Dev2DnsServerObject;



/*! \brief Obj struct for InternetGatewayDevice.Device.DHCPv6.
 *
 * MDMOID_DEV2_DHCPV6 1580
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    clientNumberOfEntries;	/**< ReadOnly */
} Dev2Dhcpv6Object;

/*! \brief _Dev2Dhcpv6Object is used internally to represent Dev2Dhcpv6Object */
typedef Dev2Dhcpv6Object _Dev2Dhcpv6Object;



/*! \brief Obj struct for InternetGatewayDevice.Device.DHCPv6.Client.{i}.
 *
 * MDMOID_DEV2_DHCPV6_CLIENT 1581
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    alias;	/**< ReadWrite */
    char *    interface;	/**< ReadWrite */
    char *    status;	/**< ReadOnly */
    HEXBINARY  DUID;	/**< ReadOnly */
    UBOOL8    requestAddresses;	/**< ReadWrite */
    UBOOL8    requestPrefixes;	/**< ReadWrite */
    UBOOL8    rapidCommit;	/**< ReadWrite */
    UBOOL8    renew;	/**< ReadWrite */
    UINT32    X_BROADCOM_COM_Pid;	/**< ReadOnly */
    UBOOL8    X_BROADCOM_COM_UnnumberedModel;	/**< ReadWrite */
#ifdef DMP_DEVICE2_DHCPV6CLIENTSERVERIDENTITY_1
    UINT32    serverNumberOfEntries;	/**< ReadOnly */
#endif
    UINT32    sentOptionNumberOfEntries;	/**< ReadOnly */
    UINT32    receivedOptionNumberOfEntries;	/**< ReadOnly */
} Dev2Dhcpv6ClientObject;

/*! \brief _Dev2Dhcpv6ClientObject is used internally to represent Dev2Dhcpv6ClientObject */
typedef Dev2Dhcpv6ClientObject _Dev2Dhcpv6ClientObject;



/*! \brief Obj struct for InternetGatewayDevice.Device.DHCPv6.Client.{i}.X_BROADCOM_COM_RcvOption.
 *
 * MDMOID_DEV2_DHCP6C_RCV_OPTION 1585
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    address;	/**< ReadOnly */
    SINT32    addressPlt;	/**< ReadOnly */
    SINT32    addressVlt;	/**< ReadOnly */
    char *    prefix;	/**< ReadOnly */
    SINT32    prefixPlt;	/**< ReadOnly */
    SINT32    prefixVlt;	/**< ReadOnly */
    char *    prefixOld;	/**< ReadOnly */
    SINT32    prefixVltOld;	/**< ReadOnly */
    char *    DNSServers;	/**< ReadOnly */
    char *    domainName;	/**< ReadOnly */
    char *    aftr;	/**< ReadOnly */
    char *    mapTransportMode;	/**< ReadOnly */
    char *    mapBRPrefix;	/**< ReadOnly */
    char *    mapRuleIPv4Prefix;	/**< ReadOnly */
    char *    mapRuleIPv6Prefix;	/**< ReadOnly */
    UINT32    mapEALen;	/**< ReadOnly */
    UINT32    mapPSIDOffset;	/**< ReadOnly */
    UINT32    mapPSIDLen;	/**< ReadOnly */
    UINT32    mapPSID;	/**< ReadOnly */
    UBOOL8    mapIsFMR;	/**< ReadOnly */
} Dev2Dhcp6cRcvOptionObject;

/*! \brief _Dev2Dhcp6cRcvOptionObject is used internally to represent Dev2Dhcp6cRcvOptionObject */
typedef Dev2Dhcp6cRcvOptionObject _Dev2Dhcp6cRcvOptionObject;



/*! \brief Obj struct for InternetGatewayDevice.Device.DHCPv6.Server.
 *
 * MDMOID_DEV2_DHCPV6_SERVER 1586
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    UINT32    poolNumberOfEntries;	/**< ReadOnly */
} Dev2Dhcpv6ServerObject;

/*! \brief _Dev2Dhcpv6ServerObject is used internally to represent Dev2Dhcpv6ServerObject */
typedef Dev2Dhcpv6ServerObject _Dev2Dhcpv6ServerObject;



/*! \brief Obj struct for InternetGatewayDevice.Device.DHCPv6.Server.Pool.{i}.
 *
 * MDMOID_DEV2_DHCPV6_SERVER_POOL 1587
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    status;	/**< ReadOnly */
    char *    alias;	/**< ReadWrite */
    UINT32    order;	/**< ReadWrite */
    char *    interface;	/**< ReadWrite */
#ifdef DMP_DEVICE2_DHCPV6SERVERADV_1
    HEXBINARY  DUID;	/**< ReadWrite */
#endif
    UBOOL8    DUIDExclude;	/**< ReadWrite */
#ifdef DMP_DEVICE2_DHCPV6SERVERADV_1
    HEXBINARY  vendorClassID;	/**< ReadWrite */
#endif
    UBOOL8    vendorClassIDExclude;	/**< ReadWrite */
#ifdef DMP_DEVICE2_DHCPV6SERVERADV_1
    HEXBINARY  userClassID;	/**< ReadWrite */
#endif
    UBOOL8    userClassIDExclude;	/**< ReadWrite */
#ifdef DMP_DEVICE2_DHCPV6SERVERADV_1
    char *    sourceAddress;	/**< ReadWrite */
#endif
#ifdef DMP_DEVICE2_DHCPV6SERVERADV_1
    char *    sourceAddressMask;	/**< ReadWrite */
#endif
    UBOOL8    sourceAddressExclude;	/**< ReadWrite */
    UBOOL8    IANAEnable;	/**< ReadWrite */
    char *    IANAManualPrefixes;	/**< ReadWrite */
    char *    IANAPrefixes;	/**< ReadOnly */
    char *    X_BROADCOM_COM_MinInterfaceID;	/**< ReadWrite */
    char *    X_BROADCOM_COM_MaxInterfaceID;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_IANALeaseTime;	/**< ReadWrite */
    UINT32    X_BROADCOM_COM_Pid;	/**< ReadOnly */
    UBOOL8    IAPDEnable;	/**< ReadWrite */
    char *    IAPDManualPrefixes;	/**< ReadWrite */
    char *    IAPDPrefixes;	/**< ReadOnly */
    UINT32    IAPDAddLength;	/**< ReadWrite */
#ifdef DMP_DEVICE2_DHCPV6SERVERCLIENTINFO_1
    UINT32    clientNumberOfEntries;	/**< ReadOnly */
#endif
    UINT32    optionNumberOfEntries;	/**< ReadOnly */
} Dev2Dhcpv6ServerPoolObject;

/*! \brief _Dev2Dhcpv6ServerPoolObject is used internally to represent Dev2Dhcpv6ServerPoolObject */
typedef Dev2Dhcpv6ServerPoolObject _Dev2Dhcpv6ServerPoolObject;



/*! \brief Obj struct for InternetGatewayDevice.Device.DHCPv6.Server.Pool.{i}.Client.{i}.
 *
 * MDMOID_DEV2_DHCPV6_SERVER_POOL_CLIENT 1588
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    alias;	/**< ReadWrite */
    char *    sourceAddress;	/**< ReadOnly */
    UBOOL8    active;	/**< ReadOnly */
    UINT32    IPv6AddressNumberOfEntries;	/**< ReadOnly */
    UINT32    IPv6PrefixNumberOfEntries;	/**< ReadOnly */
    UINT32    optionNumberOfEntries;	/**< ReadOnly */
} Dev2Dhcpv6ServerPoolClientObject;

/*! \brief _Dev2Dhcpv6ServerPoolClientObject is used internally to represent Dev2Dhcpv6ServerPoolClientObject */
typedef Dev2Dhcpv6ServerPoolClientObject _Dev2Dhcpv6ServerPoolClientObject;



/*! \brief Obj struct for InternetGatewayDevice.Device.DHCPv6.Server.Pool.{i}.Client.{i}.IPv6Address.{i}.
 *
 * MDMOID_DEV2_DHCPV6_SERVER_POOL_CLIENT_IPV6_ADDRESS 1589
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    IPAddress;	/**< ReadOnly */
    DATETIME  preferredLifetime;	/**< ReadOnly */
    DATETIME  validLifetime;	/**< ReadOnly */
} Dev2Dhcpv6ServerPoolClientIpv6AddressObject;

/*! \brief _Dev2Dhcpv6ServerPoolClientIpv6AddressObject is used internally to represent Dev2Dhcpv6ServerPoolClientIpv6AddressObject */
typedef Dev2Dhcpv6ServerPoolClientIpv6AddressObject _Dev2Dhcpv6ServerPoolClientIpv6AddressObject;



/*! \brief Obj struct for InternetGatewayDevice.Device.DHCPv6.Server.Pool.{i}.Client.{i}.IPv6Prefix.{i}.
 *
 * MDMOID_DEV2_DHCPV6_SERVER_POOL_CLIENT_IPV6_PREFIX 1590
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    prefix;	/**< ReadOnly */
    DATETIME  preferredLifetime;	/**< ReadOnly */
    DATETIME  validLifetime;	/**< ReadOnly */
} Dev2Dhcpv6ServerPoolClientIpv6PrefixObject;

/*! \brief _Dev2Dhcpv6ServerPoolClientIpv6PrefixObject is used internally to represent Dev2Dhcpv6ServerPoolClientIpv6PrefixObject */
typedef Dev2Dhcpv6ServerPoolClientIpv6PrefixObject _Dev2Dhcpv6ServerPoolClientIpv6PrefixObject;



/*! \brief Obj struct for InternetGatewayDevice.Device.DHCPv6.Server.Pool.{i}.Client.{i}.Option.{i}.
 *
 * MDMOID_DEV2_DHCPV6_SERVER_POOL_CLIENT_OPTION 1591
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    tag;	/**< ReadOnly */
    HEXBINARY  value;	/**< ReadOnly */
} Dev2Dhcpv6ServerPoolClientOptionObject;

/*! \brief _Dev2Dhcpv6ServerPoolClientOptionObject is used internally to represent Dev2Dhcpv6ServerPoolClientOptionObject */
typedef Dev2Dhcpv6ServerPoolClientOptionObject _Dev2Dhcpv6ServerPoolClientOptionObject;



/*! \brief Obj struct for InternetGatewayDevice.Device.DHCPv6.Server.Pool.{i}.Option.{i}.
 *
 * MDMOID_DEV2_DHCPV6_SERVER_POOL_OPTION 1592
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    alias;	/**< ReadWrite */
    UINT32    tag;	/**< ReadWrite */
    HEXBINARY  value;	/**< ReadWrite */
    char *    passthroughClient;	/**< ReadWrite */
} Dev2Dhcpv6ServerPoolOptionObject;

/*! \brief _Dev2Dhcpv6ServerPoolOptionObject is used internally to represent Dev2Dhcpv6ServerPoolOptionObject */
typedef Dev2Dhcpv6ServerPoolOptionObject _Dev2Dhcpv6ServerPoolOptionObject;



/*! \brief Obj struct for InternetGatewayDevice.Device.IEEE1905.
 *
 * MDMOID_DEV2_IEEE1905 1780
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    version;	/**< ReadOnly */
} Dev2Ieee1905Object;

/*! \brief _Dev2Ieee1905Object is used internally to represent Dev2Ieee1905Object */
typedef Dev2Ieee1905Object _Dev2Ieee1905Object;



/*! \brief Obj struct for InternetGatewayDevice.Device.IEEE1905.AL.
 *
 * MDMOID_DEV2_IEEE1905_AL 1781
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    IEEE1905Id;	/**< ReadOnly */
    char *    status;	/**< ReadOnly */
    UINT32    lastChange;	/**< ReadOnly */
    char *    lowerLayers;	/**< ReadOnly */
    char *    registrarFreqBand;	/**< ReadWrite */
    UINT32    interfaceNumberOfEntries;	/**< ReadOnly */
    UBOOL8    enable;	/**< ReadWrite */
    char *    deviceFriendlyName;	/**< ReadWrite */
    UBOOL8    isRegistrar;	/**< ReadWrite */
    UBOOL8    APFreqBand24Enable;	/**< ReadWrite */
    UBOOL8    APFreqBand5Enable;	/**< ReadWrite */
} Dev2Ieee1905AlObject;

/*! \brief _Dev2Ieee1905AlObject is used internally to represent Dev2Ieee1905AlObject */
typedef Dev2Ieee1905AlObject _Dev2Ieee1905AlObject;



/*! \brief Obj struct for InternetGatewayDevice.Device.IEEE1905.AL.Interface.{i}.
 *
 * MDMOID_DEV2_IEEE1905_AL_IFC 1782
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    interfaceId;	/**< ReadOnly */
    char *    status;	/**< ReadOnly */
    UINT32    lastChange;	/**< ReadOnly */
    char *    lowerLayers;	/**< ReadOnly */
    char *    mediaType;	/**< ReadOnly */
#ifdef DMP_DEVICE2_IEEE1905POWER_1
    char *    powerState;	/**< ReadWrite */
#endif
#ifdef DMP_DEVICE2_IEEE1905LINKMETRIC_1
    UINT32    linkNumberOfEntries;	/**< ReadOnly */
#endif
    char *    genericPhyOUI;	/**< ReadOnly */
    UINT32    genericVariant;	/**< ReadOnly */
    char *    genericPhyURL;	/**< ReadOnly */
} Dev2Ieee1905AlIfcObject;

/*! \brief _Dev2Ieee1905AlIfcObject is used internally to represent Dev2Ieee1905AlIfcObject */
typedef Dev2Ieee1905AlIfcObject _Dev2Ieee1905AlIfcObject;



/*! \brief Obj struct for InternetGatewayDevice.Device.IEEE1905.AL.Interface.{i}.Link.{i}.
 *
 * MDMOID_DEV2_IEEE1905_AL_IFC_LINK 1783
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    interfaceId;	/**< ReadOnly */
    char *    IEEE1905Id;	/**< ReadOnly */
    char *    mediaType;	/**< ReadOnly */
#ifdef DMP_DEVICE2_IEEE1905BASELINE_1
    char *    genericPhyOUI;	/**< ReadOnly */
#endif
#ifdef DMP_DEVICE2_IEEE1905BASELINE_1
    UINT32    genericVariant;	/**< ReadOnly */
#endif
#ifdef DMP_DEVICE2_IEEE1905BASELINE_1
    char *    genericPhyURL;	/**< ReadOnly */
#endif
} Dev2Ieee1905AlIfcLinkObject;

/*! \brief _Dev2Ieee1905AlIfcLinkObject is used internally to represent Dev2Ieee1905AlIfcLinkObject */
typedef Dev2Ieee1905AlIfcLinkObject _Dev2Ieee1905AlIfcLinkObject;



/*! \brief Obj struct for InternetGatewayDevice.Device.IEEE1905.AL.Interface.{i}.Link.{i}.Metric.
 *
 * MDMOID_DEV2_IEEE1905_AL_IFC_LINK_METRIC 1784
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    IEEE802dot1Bridge;	/**< ReadOnly */
    UINT32    packetErrors;	/**< ReadOnly */
    UINT32    packetErrorsReceived;	/**< ReadOnly */
    UINT32    transmittedPackets;	/**< ReadOnly */
    UINT32    packetsReceived;	/**< ReadOnly */
    UINT32    MACThroughputCapacity;	/**< ReadOnly */
    UINT32    linkAvailability;	/**< ReadOnly */
    UINT32    PHYRate;	/**< ReadOnly */
    UINT32    RSSI;	/**< ReadOnly */
} Dev2Ieee1905AlIfcLinkMetricObject;

/*! \brief _Dev2Ieee1905AlIfcLinkMetricObject is used internally to represent Dev2Ieee1905AlIfcLinkMetricObject */
typedef Dev2Ieee1905AlIfcLinkMetricObject _Dev2Ieee1905AlIfcLinkMetricObject;



/*! \brief Obj struct for InternetGatewayDevice.Device.IEEE1905.AL.ForwardingTable.
 *
 * MDMOID_DEV2_IEEE1905_AL_FORWARDING_TABLE 1785
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    forwardingRuleNumberOfEntries;	/**< ReadOnly */
} Dev2Ieee1905AlForwardingTableObject;

/*! \brief _Dev2Ieee1905AlForwardingTableObject is used internally to represent Dev2Ieee1905AlForwardingTableObject */
typedef Dev2Ieee1905AlForwardingTableObject _Dev2Ieee1905AlForwardingTableObject;



/*! \brief Obj struct for InternetGatewayDevice.Device.IEEE1905.AL.ForwardingTable.ForwardingRule.{i}.
 *
 * MDMOID_DEV2_IEEE1905_AL_FORWARDING_TABLE_FORWARDING_RULE 1786
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    interfaceList;	/**< ReadWrite */
    char *    MACDestinationAddress;	/**< ReadWrite */
    UBOOL8    MACDestinationAddressExclude;	/**< ReadWrite */
    char *    MACSourceAddress;	/**< ReadWrite */
    UBOOL8    MACSourceAddressExclude;	/**< ReadWrite */
    SINT32    etherType;	/**< ReadWrite */
    UBOOL8    etherTypeExclude;	/**< ReadWrite */
    SINT32    vid;	/**< ReadWrite */
    UBOOL8    vidExclude;	/**< ReadWrite */
    SINT32    PCP;	/**< ReadWrite */
    UBOOL8    PCPExclude;	/**< ReadWrite */
} Dev2Ieee1905AlForwardingTableForwardingRuleObject;

/*! \brief _Dev2Ieee1905AlForwardingTableForwardingRuleObject is used internally to represent Dev2Ieee1905AlForwardingTableForwardingRuleObject */
typedef Dev2Ieee1905AlForwardingTableForwardingRuleObject _Dev2Ieee1905AlForwardingTableForwardingRuleObject;



/*! \brief Obj struct for InternetGatewayDevice.Device.IEEE1905.AL.NetworkTopology.
 *
 * MDMOID_DEV2_IEEE1905_AL_NETWORK_TOPOLOGY 1787
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    status;	/**< ReadOnly */
    UINT32    maxChangeLogEntries;	/**< ReadWrite */
    char *    lastChange;	/**< ReadOnly */
    UINT32    IEEE1905DeviceNumberOfEntries;	/**< ReadOnly */
    UINT32    changeLogNumberOfEntries;	/**< ReadOnly */
} Dev2Ieee1905AlNetworkTopologyObject;

/*! \brief _Dev2Ieee1905AlNetworkTopologyObject is used internally to represent Dev2Ieee1905AlNetworkTopologyObject */
typedef Dev2Ieee1905AlNetworkTopologyObject _Dev2Ieee1905AlNetworkTopologyObject;



/*! \brief Obj struct for InternetGatewayDevice.Device.IEEE1905.AL.NetworkTopology.ChangeLog.{i}.
 *
 * MDMOID_DEV2_IEEE1905_AL_NETWORK_TOPOLOGY_CHANGE_LOG 1788
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    DATETIME  timeStamp;	/**< ReadOnly */
    char *    eventType;	/**< ReadOnly */
    char *    reporterDeviceId;	/**< ReadOnly */
    char *    reporterInterfaceId;	/**< ReadOnly */
    char *    neighborType;	/**< ReadOnly */
    char *    neighborId;	/**< ReadOnly */
} Dev2Ieee1905AlNetworkTopologyChangeLogObject;

/*! \brief _Dev2Ieee1905AlNetworkTopologyChangeLogObject is used internally to represent Dev2Ieee1905AlNetworkTopologyChangeLogObject */
typedef Dev2Ieee1905AlNetworkTopologyChangeLogObject _Dev2Ieee1905AlNetworkTopologyChangeLogObject;



/*! \brief Obj struct for InternetGatewayDevice.Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.{i}.
 *
 * MDMOID_DEV2_IEEE1905_AL_NETWORK_TOPOLOGY_IEEE1905_DEVICE 1789
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    IEEE1905Id;	/**< ReadOnly */
    UINT32    version;	/**< ReadOnly */
    char *    friendlyName;	/**< ReadOnly */
    UINT32    vendorPropertiesNumberOfEntries;	/**< ReadOnly */
    UINT32    IPv4AddressesNumberOfEntries;	/**< ReadOnly */
    UINT32    IPv6AddressesNumberOfEntries;	/**< ReadOnly */
    UINT32    interfaceNumberOfEntries;	/**< ReadOnly */
    UINT32    nonIEEE1905NeighborNumberOfEntries;	/**< ReadOnly */
    UINT32    IEEE1905NeighborNumberOfEntries;	/**< ReadOnly */
    UINT32    L2NeighborNumberOfEntries;	/**< ReadOnly */
    UINT32    bridgingTupleNumberOfEntries;	/**< ReadOnly */
} Dev2Ieee1905AlNetworkTopologyIeee1905DeviceObject;

/*! \brief _Dev2Ieee1905AlNetworkTopologyIeee1905DeviceObject is used internally to represent Dev2Ieee1905AlNetworkTopologyIeee1905DeviceObject */
typedef Dev2Ieee1905AlNetworkTopologyIeee1905DeviceObject _Dev2Ieee1905AlNetworkTopologyIeee1905DeviceObject;



/*! \brief Obj struct for InternetGatewayDevice.Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.{i}.Interface.{i}.
 *
 * MDMOID_DEV2_IEEE1905_AL_NETWORK_TOPOLOGY_IEEE1905_DEVICE_IFC 1790
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    interfaceId;	/**< ReadOnly */
    char *    mediaType;	/**< ReadOnly */
    char *    powerState;	/**< ReadWrite */
#ifdef DMP_DEVICE2_IEEE1905BASELINE_1
    char *    genericPhyOUI;	/**< ReadOnly */
#endif
#ifdef DMP_DEVICE2_IEEE1905BASELINE_1
    UINT32    genericVariant;	/**< ReadOnly */
#endif
#ifdef DMP_DEVICE2_IEEE1905BASELINE_1
    char *    genericPhyURL;	/**< ReadOnly */
#endif
} Dev2Ieee1905AlNetworkTopologyIeee1905DeviceIfcObject;

/*! \brief _Dev2Ieee1905AlNetworkTopologyIeee1905DeviceIfcObject is used internally to represent Dev2Ieee1905AlNetworkTopologyIeee1905DeviceIfcObject */
typedef Dev2Ieee1905AlNetworkTopologyIeee1905DeviceIfcObject _Dev2Ieee1905AlNetworkTopologyIeee1905DeviceIfcObject;



/*! \brief Obj struct for InternetGatewayDevice.Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.{i}.NonIEEE1905Neighbor.{i}.
 *
 * MDMOID_DEV2_IEEE1905_AL_NETWORK_TOPOLOGY_IEEE1905_DEVICE_NON_IEEE1905_NEIGHBOR 1791
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    localInterface;	/**< ReadOnly */
    char *    neighborInterfaceId;	/**< ReadOnly */
} Dev2Ieee1905AlNetworkTopologyIeee1905DeviceNonIeee1905NeighborObject;

/*! \brief _Dev2Ieee1905AlNetworkTopologyIeee1905DeviceNonIeee1905NeighborObject is used internally to represent Dev2Ieee1905AlNetworkTopologyIeee1905DeviceNonIeee1905NeighborObject */
typedef Dev2Ieee1905AlNetworkTopologyIeee1905DeviceNonIeee1905NeighborObject _Dev2Ieee1905AlNetworkTopologyIeee1905DeviceNonIeee1905NeighborObject;



/*! \brief Obj struct for InternetGatewayDevice.Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.{i}.L2Neighbor.{i}.
 *
 * MDMOID_DEV2_IEEE1905_AL_NETWORK_TOPOLOGY_IEEE1905_DEVICE_NON_L2_NEIGHBOR 1792
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    localInterface;	/**< ReadOnly */
    char *    neighborInterfaceId;	/**< ReadOnly */
} Dev2Ieee1905AlNetworkTopologyIeee1905DeviceNonL2NeighborObject;

/*! \brief _Dev2Ieee1905AlNetworkTopologyIeee1905DeviceNonL2NeighborObject is used internally to represent Dev2Ieee1905AlNetworkTopologyIeee1905DeviceNonL2NeighborObject */
typedef Dev2Ieee1905AlNetworkTopologyIeee1905DeviceNonL2NeighborObject _Dev2Ieee1905AlNetworkTopologyIeee1905DeviceNonL2NeighborObject;



/*! \brief Obj struct for InternetGatewayDevice.Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.{i}.IEEE1905Neighbor.{i}.
 *
 * MDMOID_DEV2_IEEE1905_AL_NETWORK_TOPOLOGY_IEEE1905_DEVICE_IEEE1905_NEIGHBOR 1793
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    localInterface;	/**< ReadOnly */
    char *    neighborDeviceId;	/**< ReadOnly */
    UINT32    metricNumberOfEntries;	/**< ReadOnly */
} Dev2Ieee1905AlNetworkTopologyIeee1905DeviceIeee1905NeighborObject;

/*! \brief _Dev2Ieee1905AlNetworkTopologyIeee1905DeviceIeee1905NeighborObject is used internally to represent Dev2Ieee1905AlNetworkTopologyIeee1905DeviceIeee1905NeighborObject */
typedef Dev2Ieee1905AlNetworkTopologyIeee1905DeviceIeee1905NeighborObject _Dev2Ieee1905AlNetworkTopologyIeee1905DeviceIeee1905NeighborObject;



/*! \brief Obj struct for InternetGatewayDevice.Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.{i}.IEEE1905Neighbor.{i}.Metric.{i}.
 *
 * MDMOID_DEV2_IEEE1905_AL_NETWORK_TOPOLOGY_IEEE1905_DEVICE_IEEE1905_NEIGHBOR_METRIC 1794
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    neighborMACAddress;	/**< ReadOnly */
    UBOOL8    IEEE802dot1Bridge;	/**< ReadOnly */
    UINT32    packetErrors;	/**< ReadOnly */
    UINT32    packetErrorsReceived;	/**< ReadOnly */
    UINT32    transmittedPackets;	/**< ReadOnly */
    UINT32    packetsReceived;	/**< ReadOnly */
    UINT32    MACThroughputCapacity;	/**< ReadOnly */
    UINT32    linkAvailability;	/**< ReadOnly */
    UINT32    PHYRate;	/**< ReadOnly */
    UINT32    RSSI;	/**< ReadOnly */
} Dev2Ieee1905AlNetworkTopologyIeee1905DeviceIeee1905NeighborMetricObject;

/*! \brief _Dev2Ieee1905AlNetworkTopologyIeee1905DeviceIeee1905NeighborMetricObject is used internally to represent Dev2Ieee1905AlNetworkTopologyIeee1905DeviceIeee1905NeighborMetricObject */
typedef Dev2Ieee1905AlNetworkTopologyIeee1905DeviceIeee1905NeighborMetricObject _Dev2Ieee1905AlNetworkTopologyIeee1905DeviceIeee1905NeighborMetricObject;



/*! \brief Obj struct for InternetGatewayDevice.Device.IEEE1905.AL.NetworkTopology.IEEE1905Device.{i}.BridgingTuple.{i}.
 *
 * MDMOID_DEV2_IEEE1905_AL_NETWORK_TOPOLOGY_IEEE1905_DEVICE_BRIDGING_TUPLE 1795
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    interfaceList;	/**< ReadOnly */
} Dev2Ieee1905AlNetworkTopologyIeee1905DeviceBridgingTupleObject;

/*! \brief _Dev2Ieee1905AlNetworkTopologyIeee1905DeviceBridgingTupleObject is used internally to represent Dev2Ieee1905AlNetworkTopologyIeee1905DeviceBridgingTupleObject */
typedef Dev2Ieee1905AlNetworkTopologyIeee1905DeviceBridgingTupleObject _Dev2Ieee1905AlNetworkTopologyIeee1905DeviceBridgingTupleObject;



/*! \brief Obj struct for InternetGatewayDevice.Device.IEEE1905.AL.Security.
 *
 * MDMOID_DEV2_IEEE1905_AL_SECURITY 1796
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    setupMethod;	/**< ReadWrite */
    char *    password;	/**< ReadWrite */
} Dev2Ieee1905AlSecurityObject;

/*! \brief _Dev2Ieee1905AlSecurityObject is used internally to represent Dev2Ieee1905AlSecurityObject */
typedef Dev2Ieee1905AlSecurityObject _Dev2Ieee1905AlSecurityObject;



/*! \brief Obj struct for Device.DeviceInfo.
 *
 * MDMOID_DEV2_DEVICE_INFO 1004
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    manufacturer;	/**< ReadOnly */
    char *    manufacturerOUI;	/**< ReadOnly */
#ifdef DMP_DEVICE2_DEVICEINFO_1
    char *    friendlyName;	/**< ReadWrite */
#endif
    char *    modelName;	/**< ReadOnly */
    char *    description;	/**< ReadOnly */
#ifdef DMP_DEVICE2_DEVICEINFO_1
    char *    productClass;	/**< ReadOnly */
#endif
    char *    serialNumber;	/**< ReadOnly */
    char *    hardwareVersion;	/**< ReadOnly */
    char *    softwareVersion;	/**< ReadOnly */
#ifdef DMP_DEVICE2_FIRMWARE_1
    char *    activeFirmwareImage;	/**< ReadOnly */
#endif
#ifdef DMP_DEVICE2_FIRMWARE_1
    char *    bootFirmwareImage;	/**< ReadWrite */
#endif
    char *    additionalHardwareVersion;	/**< ReadOnly */
    char *    additionalSoftwareVersion;	/**< ReadOnly */
    char *    provisioningCode;	/**< ReadWrite */
    UINT32    upTime;	/**< ReadOnly */
    DATETIME  firstUseDate;	/**< ReadOnly */
#ifdef DMP_DEVICE2_FIRMWARE_1
    UINT32    firmwareImageNumberOfEntries;	/**< ReadOnly */
#endif
    UINT32    vendorConfigFileNumberOfEntries;	/**< ReadOnly */
#ifdef DMP_DEVICE2_SUPPORTEDDATAMODEL_1
    UINT32    supportedDataModelNumberOfEntries;	/**< ReadOnly */
#endif
    UINT32    processorNumberOfEntries;	/**< ReadOnly */
    UINT32    vendorLogFileNumberOfEntries;	/**< ReadOnly */
#ifdef DMP_DEVICE2_LOCATION_1
    UINT32    locationNumberOfEntries;	/**< ReadOnly */
#endif
    char *    X_BROADCOM_COM_SwBuildTimestamp;	/**< ReadOnly */
#ifdef DMP_X_BROADCOM_COM_DSL_1
    char *    X_BROADCOM_COM_DslPhyDrvVersion;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_PSTNENDPOINT_1
    char *    X_BROADCOM_COM_VoiceServiceVersion;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_MULTIPLE_TR69C_SUPPORT_1
    char *    X_BROADCOM_COM_E2E_SerialNumber;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_MULTIPLE_TR69C_SUPPORT_1
    char *    X_BROADCOM_COM_E2E_ProvisioningCode;	/**< ReadWrite */
#endif
    char *    X_BROADCOM_COM_FirmwareMgmtOwner;	/**< ReadWrite */
    char *    X_BROADCOM_COM_PrevBootName;	/**< ReadWrite */
} Dev2DeviceInfoObject;

/*! \brief _Dev2DeviceInfoObject is used internally to represent Dev2DeviceInfoObject */
typedef Dev2DeviceInfoObject _Dev2DeviceInfoObject;



/*! \brief Obj struct for Device.DeviceInfo.VendorConfigFile.{i}.
 *
 * MDMOID_DEV2_DEVICE_VENDOR_CONFIG_FILE 1005
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    alias;	/**< ReadWrite */
    char *    name;	/**< ReadOnly */
    char *    version;	/**< ReadOnly */
    DATETIME  date;	/**< ReadOnly */
    char *    description;	/**< ReadOnly */
    UBOOL8    useForBackupRestore;	/**< ReadOnly */
} Dev2DeviceVendorConfigFileObject;

/*! \brief _Dev2DeviceVendorConfigFileObject is used internally to represent Dev2DeviceVendorConfigFileObject */
typedef Dev2DeviceVendorConfigFileObject _Dev2DeviceVendorConfigFileObject;



/*! \brief Obj struct for Device.DeviceInfo.FirmwareImage.{i}.
 *
 * MDMOID_DEV2_FIRMWARE_IMAGE 1006
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    alias;	/**< ReadWrite */
    char *    name;	/**< ReadOnly */
    char *    version;	/**< ReadOnly */
    UBOOL8    available;	/**< ReadWrite */
    char *    status;	/**< ReadOnly */
    char *    bootFailureLog;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_FLASH_PARTITION;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_SEQ_NUM;	/**< ReadOnly */
    UBOOL8    X_BROADCOM_COM_isUpdated;	/**< ReadWrite */
    char *    X_BROADCOM_COM_checkSumAlgorithm;	/**< ReadWrite */
    char *    X_BROADCOM_COM_expectedCheckSum;	/**< ReadWrite */
    char *    X_BROADCOM_COM_actualCheckSum;	/**< ReadWrite */
} Dev2FirmwareImageObject;

/*! \brief _Dev2FirmwareImageObject is used internally to represent Dev2FirmwareImageObject */
typedef Dev2FirmwareImageObject _Dev2FirmwareImageObject;



/*! \brief Obj struct for Device.DeviceInfo.SupportedDataModel.{i}.
 *
 * MDMOID_DEV2_SUPPORTED_DATA_MODEL 1007
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    alias;	/**< ReadWrite */
    char *    URL;	/**< ReadOnly */
#ifdef DMP_DEVICE2_SUPPORTEDDATAMODEL_2
    char *    UUID;	/**< ReadOnly */
#endif
    char *    URN;	/**< ReadOnly */
    char *    features;	/**< ReadOnly */
} Dev2SupportedDataModelObject;

/*! \brief _Dev2SupportedDataModelObject is used internally to represent Dev2SupportedDataModelObject */
typedef Dev2SupportedDataModelObject _Dev2SupportedDataModelObject;



/*! \brief Obj struct for Device.DeviceInfo.MemoryStatus.
 *
 * MDMOID_DEV2_MEMORY_STATUS 1008
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    total;	/**< ReadOnly */
    UINT32    free;	/**< ReadOnly */
} Dev2MemoryStatusObject;

/*! \brief _Dev2MemoryStatusObject is used internally to represent Dev2MemoryStatusObject */
typedef Dev2MemoryStatusObject _Dev2MemoryStatusObject;



/*! \brief Obj struct for Device.DeviceInfo.ProcessStatus.
 *
 * MDMOID_DEV2_PROCESS_STATUS 1009
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    CPUUsage;	/**< ReadOnly */
    UINT32    processNumberOfEntries;	/**< ReadOnly */
} Dev2ProcessStatusObject;

/*! \brief _Dev2ProcessStatusObject is used internally to represent Dev2ProcessStatusObject */
typedef Dev2ProcessStatusObject _Dev2ProcessStatusObject;



/*! \brief Obj struct for Device.DeviceInfo.ProcessStatus.Process.{i}.
 *
 * MDMOID_DEV2_PROCESS_STATUS_ENTRY 1010
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    PID;	/**< ReadOnly */
    char *    command;	/**< ReadOnly */
    UINT32    size;	/**< ReadOnly */
    UINT32    priority;	/**< ReadOnly */
    UINT32    CPUTime;	/**< ReadOnly */
    char *    state;	/**< ReadOnly */
} Dev2ProcessStatusEntryObject;

/*! \brief _Dev2ProcessStatusEntryObject is used internally to represent Dev2ProcessStatusEntryObject */
typedef Dev2ProcessStatusEntryObject _Dev2ProcessStatusEntryObject;



/*! \brief Obj struct for Device.DeviceInfo.Processor.{i}.
 *
 * MDMOID_DEV2_PROCESSOR 1014
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    alias;	/**< ReadWrite */
    char *    architecture;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_Frequency;	/**< ReadOnly */
} Dev2ProcessorObject;

/*! \brief _Dev2ProcessorObject is used internally to represent Dev2ProcessorObject */
typedef Dev2ProcessorObject _Dev2ProcessorObject;



/*! \brief Obj struct for Device.DeviceInfo.X_BROADCOM_COM_RebootInfo.
 *
 * MDMOID_DEV2_REBOOT_INFO 1018
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    cause;	/**< ReadWrite */
    char *    commandKey;	/**< ReadWrite */
    char *    lastFirmwareVersion;	/**< ReadWrite */
} Dev2RebootInfoObject;

/*! \brief _Dev2RebootInfoObject is used internally to represent Dev2RebootInfoObject */
typedef Dev2RebootInfoObject _Dev2RebootInfoObject;



/*! \brief Obj struct for Device.CWMPManagementServer.
 *
 * MDMOID_CWMP_MANAGEMENT_SERVER 1029
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enableCWMP;	/**< ReadWrite */
} Dev2CWMPManagementServerObject;

/*! \brief _Dev2CWMPManagementServerObject is used internally to represent Dev2CWMPManagementServerObject */
typedef Dev2CWMPManagementServerObject _Dev2CWMPManagementServerObject;



/*! \brief Obj struct for Device.X_BROADCOM_COM_AppCfg.SysmgmtMdCfg.
 *
 * MDMOID_SYSMGMT_MD_CFG 3330
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    loggingLevel;	/**< ReadWrite */
    UINT32    loggingDestinationMask;	/**< ReadWrite */
} SysmgmtMdCfgObject;

/*! \brief _SysmgmtMdCfgObject is used internally to represent SysmgmtMdCfgObject */
typedef SysmgmtMdCfgObject _SysmgmtMdCfgObject;



/*! \brief Obj struct for Device.X_BROADCOM_COM_AppCfg.BcmMsgdCfg.
 *
 * MDMOID_BCM_MSGD_CFG 3339
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    loggingLevel;	/**< ReadWrite */
    UINT32    loggingDestinationMask;	/**< ReadWrite */
} BcmMsgdCfgObject;

/*! \brief _BcmMsgdCfgObject is used internally to represent BcmMsgdCfgObject */
typedef BcmMsgdCfgObject _BcmMsgdCfgObject;



/*! \brief Obj struct for Device.X_BROADCOM_COM_AppCfg.WiFiMdCfg.
 *
 * MDMOID_WI_FI_MD_CFG 3331
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    loggingLevel;	/**< ReadWrite */
    UINT32    loggingDestinationMask;	/**< ReadWrite */
} WiFiMdCfgObject;

/*! \brief _WiFiMdCfgObject is used internally to represent WiFiMdCfgObject */
typedef WiFiMdCfgObject _WiFiMdCfgObject;



/*! \brief Obj struct for Device.X_BROADCOM_COM_AppCfg.WlsskCfg.
 *
 * MDMOID_WLSSK_CFG 3332
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    loggingLevel;	/**< ReadWrite */
    UINT32    loggingDestinationMask;	/**< ReadWrite */
} WlsskCfgObject;

/*! \brief _WlsskCfgObject is used internally to represent WlsskCfgObject */
typedef WlsskCfgObject _WlsskCfgObject;



/*! \brief Obj struct for Device.X_BROADCOM_COM_AppCfg.VoiceMdCfg.
 *
 * MDMOID_VOICE_MD_CFG 3322
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    loggingLevel;	/**< ReadWrite */
    UINT32    loggingDestinationMask;	/**< ReadWrite */
} VoiceMdCfgObject;

/*! \brief _VoiceMdCfgObject is used internally to represent VoiceMdCfgObject */
typedef VoiceMdCfgObject _VoiceMdCfgObject;



/*! \brief Obj struct for Device.X_BROADCOM_COM_AppCfg.VoiceHalThreadCfg.
 *
 * MDMOID_VOICE_HAL_THREAD_CFG 3323
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    loggingLevel;	/**< ReadWrite */
    UINT32    loggingDestinationMask;	/**< ReadWrite */
} VoiceHalThreadCfgObject;

/*! \brief _VoiceHalThreadCfgObject is used internally to represent VoiceHalThreadCfgObject */
typedef VoiceHalThreadCfgObject _VoiceHalThreadCfgObject;



/*! \brief Obj struct for Device.X_BROADCOM_COM_AppCfg.UspMdCfg.
 *
 * MDMOID_USP_MD_CFG 3333
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    loggingLevel;	/**< ReadWrite */
    UINT32    loggingDestinationMask;	/**< ReadWrite */
} UspMdCfgObject;

/*! \brief _UspMdCfgObject is used internally to represent UspMdCfgObject */
typedef UspMdCfgObject _UspMdCfgObject;



/*! \brief Obj struct for Device.X_BROADCOM_COM_AppCfg.ObuspaCfg.
 *
 * MDMOID_OBUSPA_CFG 3334
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    loggingLevel;	/**< ReadWrite */
    UINT32    loggingDestinationMask;	/**< ReadWrite */
    UBOOL8    protocolTrace;	/**< ReadWrite */
} ObuspaCfgObject;

/*! \brief _ObuspaCfgObject is used internally to represent ObuspaCfgObject */
typedef ObuspaCfgObject _ObuspaCfgObject;



/*! \brief Obj struct for Device.X_BROADCOM_COM_AppCfg.Tr69MdCfg.
 *
 * MDMOID_TR69_MD_CFG 3357
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    loggingLevel;	/**< ReadWrite */
    UINT32    loggingDestinationMask;	/**< ReadWrite */
} Tr69MdCfgObject;

/*! \brief _Tr69MdCfgObject is used internally to represent Tr69MdCfgObject */
typedef Tr69MdCfgObject _Tr69MdCfgObject;



/*! \brief Obj struct for Device.X_BROADCOM_COM_AppCfg.GponMdCfg.
 *
 * MDMOID_GPON_MD_CFG 3325
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    loggingLevel;	/**< ReadWrite */
    UINT32    loggingDestinationMask;	/**< ReadWrite */
} GponMdCfgObject;

/*! \brief _GponMdCfgObject is used internally to represent GponMdCfgObject */
typedef GponMdCfgObject _GponMdCfgObject;



/*! \brief Obj struct for Device.X_BROADCOM_COM_AppCfg.GponHalThreadCfg.
 *
 * MDMOID_GPON_HAL_THREAD_CFG 3326
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    loggingLevel;	/**< ReadWrite */
    UINT32    loggingDestinationMask;	/**< ReadWrite */
} GponHalThreadCfgObject;

/*! \brief _GponHalThreadCfgObject is used internally to represent GponHalThreadCfgObject */
typedef GponHalThreadCfgObject _GponHalThreadCfgObject;



/*! \brief Obj struct for Device.X_BROADCOM_COM_AppCfg.EponMdCfg.
 *
 * MDMOID_EPON_MD_CFG 3327
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    loggingLevel;	/**< ReadWrite */
    UINT32    loggingDestinationMask;	/**< ReadWrite */
} EponMdCfgObject;

/*! \brief _EponMdCfgObject is used internally to represent EponMdCfgObject */
typedef EponMdCfgObject _EponMdCfgObject;



/*! \brief Obj struct for Device.X_BROADCOM_COM_AppCfg.EponHalThreadCfg.
 *
 * MDMOID_EPON_HAL_THREAD_CFG 3328
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    loggingLevel;	/**< ReadWrite */
    UINT32    loggingDestinationMask;	/**< ReadWrite */
} EponHalThreadCfgObject;

/*! \brief _EponHalThreadCfgObject is used internally to represent EponHalThreadCfgObject */
typedef EponHalThreadCfgObject _EponHalThreadCfgObject;



/*! \brief Obj struct for Device.X_BROADCOM_COM_AppCfg.DslMdCfg.
 *
 * MDMOID_DSL_MD_CFG 3350
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    loggingLevel;	/**< ReadWrite */
    UINT32    loggingDestinationMask;	/**< ReadWrite */
} DslMdCfgObject;

/*! \brief _DslMdCfgObject is used internally to represent DslMdCfgObject */
typedef DslMdCfgObject _DslMdCfgObject;



/*! \brief Obj struct for Device.X_BROADCOM_COM_AppCfg.DslHalThreadCfg.
 *
 * MDMOID_DSL_HAL_THREAD_CFG 3351
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    loggingLevel;	/**< ReadWrite */
    UINT32    loggingDestinationMask;	/**< ReadWrite */
} DslHalThreadCfgObject;

/*! \brief _DslHalThreadCfgObject is used internally to represent DslHalThreadCfgObject */
typedef DslHalThreadCfgObject _DslHalThreadCfgObject;



/*! \brief Obj struct for Device.X_BROADCOM_COM_AppCfg.DslSskCfg.
 *
 * MDMOID_DSL_SSK_CFG 3352
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    loggingLevel;	/**< ReadWrite */
    UINT32    loggingDestinationMask;	/**< ReadWrite */
} DslSskCfgObject;

/*! \brief _DslSskCfgObject is used internally to represent DslSskCfgObject */
typedef DslSskCfgObject _DslSskCfgObject;



/*! \brief Obj struct for Device.X_BROADCOM_COM_AppCfg.DiagMdCfg.
 *
 * MDMOID_DIAG_MD_CFG 3360
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    loggingLevel;	/**< ReadWrite */
    UINT32    loggingDestinationMask;	/**< ReadWrite */
} DiagMdCfgObject;

/*! \brief _DiagMdCfgObject is used internally to represent DiagMdCfgObject */
typedef DiagMdCfgObject _DiagMdCfgObject;



/*! \brief Obj struct for Device.X_BROADCOM_COM_AppCfg.DiagSskCfg.
 *
 * MDMOID_DIAG_SSK_CFG 3361
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    loggingLevel;	/**< ReadWrite */
    UINT32    loggingDestinationMask;	/**< ReadWrite */
} DiagSskCfgObject;

/*! \brief _DiagSskCfgObject is used internally to represent DiagSskCfgObject */
typedef DiagSskCfgObject _DiagSskCfgObject;



/*! \brief Obj struct for Device.X_BROADCOM_COM_AppCfg.DevinfoMdCfg.
 *
 * MDMOID_DEVINFO_MD_CFG 3320
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    loggingLevel;	/**< ReadWrite */
    UINT32    loggingDestinationMask;	/**< ReadWrite */
} DevinfoMdCfgObject;

/*! \brief _DevinfoMdCfgObject is used internally to represent DevinfoMdCfgObject */
typedef DevinfoMdCfgObject _DevinfoMdCfgObject;



/*! \brief Obj struct for Device.ManagementServer.
 *
 * MDMOID_DEV2_MANAGEMENT_SERVER 1030
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enableCWMP;	/**< ReadWrite */
    char *    URL;	/**< ReadWrite */
    char *    lastConnectedURL;	/**< ReadWrite */
    char *    username;	/**< ReadWrite */
    char *    password;	/**< ReadWrite */
    UBOOL8    periodicInformEnable;	/**< ReadWrite */
    UINT32    periodicInformInterval;	/**< ReadWrite */
    DATETIME  periodicInformTime;	/**< ReadWrite */
    char *    parameterKey;	/**< ReadOnly */
    char *    X_BROADCOM_COM_BoundIfName;	/**< ReadWrite */
    char *    connectionRequestURL;	/**< ReadOnly */
    char *    connectionRequestUsername;	/**< ReadWrite */
    char *    connectionRequestPassword;	/**< ReadWrite */
    UBOOL8    upgradesManaged;	/**< ReadWrite */
    UINT32    CWMPRetryMinimumWaitInterval;	/**< ReadWrite */
    UINT32    CWMPRetryIntervalMultiplier;	/**< ReadWrite */
#ifdef DMP_DEVICE2_UDPCONNREQ_1
    char *    UDPConnectionRequestAddress;	/**< ReadOnly */
#endif
#ifdef DMP_DEVICE2_UDPCONNREQ_1
    UBOOL8    STUNEnable;	/**< ReadWrite */
#endif
#ifdef DMP_DEVICE2_UDPCONNREQ_1
    char *    STUNServerAddress;	/**< ReadWrite */
#endif
#ifdef DMP_DEVICE2_UDPCONNREQ_1
    UINT32    STUNServerPort;	/**< ReadWrite */
#endif
#ifdef DMP_DEVICE2_UDPCONNREQ_1
    char *    STUNUsername;	/**< ReadWrite */
#endif
#ifdef DMP_DEVICE2_UDPCONNREQ_1
    char *    STUNPassword;	/**< ReadWrite */
#endif
#ifdef DMP_DEVICE2_UDPCONNREQ_1
    SINT32    STUNMaximumKeepAlivePeriod;	/**< ReadWrite */
#endif
#ifdef DMP_DEVICE2_UDPCONNREQ_1
    UINT32    STUNMinimumKeepAlivePeriod;	/**< ReadWrite */
#endif
#ifdef DMP_DEVICE2_UDPCONNREQ_1
    UBOOL8    NATDetected;	/**< ReadOnly */
#endif
#ifdef DMP_DEVICE2_DEVICEASSOCIATION_1
    UINT32    manageableDeviceNumberOfEntries;	/**< ReadOnly */
#endif
    UINT32    manageableDeviceNotificationLimit;	/**< ReadWrite */
#ifdef DMP_DEVICE2_XMPPCONNREQ_1
    char *    supportedConnReqMethods;	/**< ReadOnly */
#endif
#ifdef DMP_DEVICE2_XMPPCONNREQ_1
    char *    connReqXMPPConnection;	/**< ReadWrite */
#endif
#ifdef DMP_DEVICE2_XMPPCONNREQ_1
    char *    connReqAllowedJabberIDs;	/**< ReadWrite */
#endif
#ifdef DMP_DEVICE2_XMPPCONNREQ_1
    char *    connReqJabberID;	/**< ReadWrite */
#endif
} Dev2ManagementServerObject;

/*! \brief _Dev2ManagementServerObject is used internally to represent Dev2ManagementServerObject */
typedef Dev2ManagementServerObject _Dev2ManagementServerObject;



/*! \brief Obj struct for Device.ManagementServer.ManageableDevice.{i}.
 *
 * MDMOID_DEV2_MANAGEMENT_SERVER_MANAGEABLE_DEVICE 1031
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    manufacturerOUI;	/**< ReadOnly */
    char *    serialNumber;	/**< ReadOnly */
    char *    productClass;	/**< ReadOnly */
    char *    host;	/**< ReadOnly */
} Dev2ManagementServerManageableDeviceObject;

/*! \brief _Dev2ManagementServerManageableDeviceObject is used internally to represent Dev2ManagementServerManageableDeviceObject */
typedef Dev2ManagementServerManageableDeviceObject _Dev2ManagementServerManageableDeviceObject;



/*! \brief Obj struct for Device.ManagementServer.AutonomousTransferCompletePolicy.
 *
 * MDMOID_DEV2_AUTON_XFER_COMPLETE_POLICY 1032
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    transferTypeFilter;	/**< ReadWrite */
    char *    resultTypeFilter;	/**< ReadWrite */
    char *    fileTypeFilter;	/**< ReadWrite */
} Dev2AutonXferCompletePolicyObject;

/*! \brief _Dev2AutonXferCompletePolicyObject is used internally to represent Dev2AutonXferCompletePolicyObject */
typedef Dev2AutonXferCompletePolicyObject _Dev2AutonXferCompletePolicyObject;



/*! \brief Obj struct for Device.ManagementServer.DUStateChangeComplPolicy.
 *
 * MDMOID_DEV2_DU_STATE_CHANGE_COMPL_POLICY 1037
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    operationTypeFilter;	/**< ReadWrite */
    char *    resultTypeFilter;	/**< ReadWrite */
    char *    faultCodeFilter;	/**< ReadWrite */
} Dev2DuStateChangeComplPolicyObject;

/*! \brief _Dev2DuStateChangeComplPolicyObject is used internally to represent Dev2DuStateChangeComplPolicyObject */
typedef Dev2DuStateChangeComplPolicyObject _Dev2DuStateChangeComplPolicyObject;



/*! \brief Obj struct for Device.Time.
 *
 * MDMOID_DEV2_TIME 1045
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    status;	/**< ReadOnly */
    char *    NTPServer1;	/**< ReadWrite */
    char *    NTPServer2;	/**< ReadWrite */
    char *    NTPServer3;	/**< ReadWrite */
    char *    NTPServer4;	/**< ReadWrite */
    char *    NTPServer5;	/**< ReadWrite */
    DATETIME  currentLocalTime;	/**< ReadOnly */
    char *    localTimeZone;	/**< ReadWrite */
    char *    X_BROADCOM_COM_LocalTimeZoneName;	/**< ReadWrite */
    UBOOL8    X_BROADCOM_COM_DaylightSavingsUsed;	/**< ReadWrite */
    DATETIME  X_BROADCOM_COM_DaylightSavingsStart;	/**< ReadWrite */
    DATETIME  X_BROADCOM_COM_DaylightSavingsEnd;	/**< ReadWrite */
} Dev2TimeObject;

/*! \brief _Dev2TimeObject is used internally to represent Dev2TimeObject */
typedef Dev2TimeObject _Dev2TimeObject;



/*! \brief Obj struct for Device.DSL.
 *
 * MDMOID_DEV2_DSL 1061
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    lineNumberOfEntries;	/**< ReadOnly */
    UINT32    channelNumberOfEntries;	/**< ReadOnly */
#ifdef DMP_DEVICE2_BONDEDDSL_1
    UINT32    bondingGroupNumberOfEntries;	/**< ReadOnly */
#endif
} Dev2DslObject;

/*! \brief _Dev2DslObject is used internally to represent Dev2DslObject */
typedef Dev2DslObject _Dev2DslObject;



/*! \brief Obj struct for Device.DSL.Line.{i}.
 *
 * MDMOID_DEV2_DSL_LINE 1062
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    status;	/**< ReadOnly */
    char *    alias;	/**< ReadWrite */
    char *    name;	/**< ReadOnly */
    UINT32    lastChange;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_LastChange;	/**< ReadWrite */
    char *    lowerLayers;	/**< ReadWrite */
    UBOOL8    upstream;	/**< ReadOnly */
    char *    firmwareVersion;	/**< ReadOnly */
    char *    linkStatus;	/**< ReadOnly */
#ifdef DMP_DEVICE2_ADSL2_1
    char *    standardsSupported;	/**< ReadOnly */
#endif
#ifdef DMP_DEVICE2_ADSL2_1
    HEXBINARY  XTSE;	/**< ReadOnly */
#endif
#ifdef DMP_DEVICE2_ADSL2_1
    char *    standardUsed;	/**< ReadOnly */
#endif
#ifdef DMP_DEVICE2_ADSL2_1
    HEXBINARY  XTSUsed;	/**< ReadOnly */
#endif
    char *    lineEncoding;	/**< ReadOnly */
#ifdef DMP_DEVICE2_VDSL2_1
    char *    allowedProfiles;	/**< ReadOnly */
#endif
#ifdef DMP_DEVICE2_VDSL2_1
    char *    currentProfile;	/**< ReadOnly */
#endif
    char *    powerManagementState;	/**< ReadOnly */
#ifdef DMP_DEVICE2_VDSL2_1
    UINT32    UPBOKLE;	/**< ReadOnly */
#endif
#ifdef DMP_DEVICE2_VDSL2_1
    SINT32    TRELLISds;	/**< ReadOnly */
#endif
#ifdef DMP_DEVICE2_VDSL2_1
    SINT32    TRELLISus;	/**< ReadOnly */
#endif
#ifdef DMP_DEVICE2_VDSL2_1
    UINT32    ACTSNRMODEds;	/**< ReadOnly */
#endif
#ifdef DMP_DEVICE2_VDSL2_1
    UINT32    ACTSNRMODEus;	/**< ReadOnly */
#endif
#ifdef DMP_DEVICE2_VDSL2_1
    UINT32    ACTUALCE;	/**< ReadOnly */
#endif
    SINT32    lineNumber;	/**< ReadOnly */
    UINT32    upstreamMaxBitRate;	/**< ReadOnly */
    UINT32    downstreamMaxBitRate;	/**< ReadOnly */
    SINT32    upstreamNoiseMargin;	/**< ReadOnly */
    SINT32    downstreamNoiseMargin;	/**< ReadOnly */
#ifdef DMP_DEVICE2_VDSL2_1
    char *    SNRMpbus;	/**< ReadOnly */
#endif
#ifdef DMP_DEVICE2_VDSL2_1
    char *    SNRMpbds;	/**< ReadOnly */
#endif
#ifdef DMP_DEVICE2_VDSL2_1
    SINT32    upstreamAttenuation;	/**< ReadOnly */
#endif
#ifdef DMP_DEVICE2_VDSL2_1
    SINT32    downstreamAttenuation;	/**< ReadOnly */
#endif
    SINT32    upstreamPower;	/**< ReadOnly */
    SINT32    downstreamPower;	/**< ReadOnly */
#ifdef DMP_X_RDK_DSL_1
    HEXBINARY  XTUCSystemVendorId;	/**< ReadOnly */
#endif
#ifdef DMP_X_RDK_DSL_1
    HEXBINARY  XTURSystemVendorId;	/**< ReadWrite */
#endif
#ifdef DMP_X_RDK_DSL_1
    char *    XTUCVersionNumber;	/**< ReadOnly */
#endif
#ifdef DMP_X_RDK_DSL_1
    char *    XTURVersionNumber;	/**< ReadWrite */
#endif
#ifdef DMP_X_RDK_DSL_1
    char *    XTUCSerialNumber;	/**< ReadOnly */
#endif
#ifdef DMP_X_RDK_DSL_1
    char *    XTURSerialNumber;	/**< ReadWrite */
#endif
    HEXBINARY  XTURVendor;	/**< ReadOnly */
    HEXBINARY  XTURCountry;	/**< ReadOnly */
#ifdef DMP_X_RDK_DSL_1
    HEXBINARY  XTURVendorSpecific;	/**< ReadWrite */
#endif
    UINT32    XTURANSIStd;	/**< ReadOnly */
    UINT32    XTURANSIRev;	/**< ReadOnly */
    HEXBINARY  XTUCVendor;	/**< ReadOnly */
    HEXBINARY  XTUCCountry;	/**< ReadOnly */
#ifdef DMP_X_RDK_DSL_1
    HEXBINARY  XTUCVendorSpecific;	/**< ReadOnly */
#endif
    UINT32    XTUCANSIStd;	/**< ReadOnly */
    UINT32    XTUCANSIRev;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_BondingLineNumber;	/**< ReadWrite */
    char *    X_BROADCOM_COM_AdslVersion;	/**< ReadOnly */
#ifdef DMP_X_BROADCOM_COM_DSL_1
    char *    X_BROADCOM_COM_AdslModulationCfg;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_DSL_1
    UBOOL8    X_BROADCOM_COM_ADSL2_AnnexM;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_DSL_1
    char *    X_BROADCOM_COM_PhoneLinePair;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_DSL_1
    char *    X_BROADCOM_COM_Bitswap;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_DSL_1
    char *    X_BROADCOM_COM_SRA;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_DSL_1
    char *    X_BROADCOM_COM_TrellisD;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_DSL_1
    char *    X_BROADCOM_COM_TrellisU;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_DSL_1
    char *    X_BROADCOM_COM_SNR;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_DSL_1
    char *    X_BROADCOM_COM_Bitmap;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_DSL_1
    UINT32    X_BROADCOM_COM_QueueSize;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_DSL_1
    UINT32    X_BROADCOM_COM_NumTxQueues;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_DSL_1
    char *    X_BROADCOM_COM_UpstreamS;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_DSL_1
    char *    X_BROADCOM_COM_DownstreamS;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_DSL_1
    UINT32    X_BROADCOM_COM_UpstreamR;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_DSL_1
    UINT32    X_BROADCOM_COM_DownstreamR;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_DSL_1
    UINT32    X_BROADCOM_COM_UpstreamK;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_DSL_1
    UINT32    X_BROADCOM_COM_DownstreamK;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_DSL_1
    char *    X_BROADCOM_COM_UpstreamDelay;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_DSL_1
    char *    X_BROADCOM_COM_UpstreamDelay_2;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_DSL_1
    char *    X_BROADCOM_COM_DownstreamDelay;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_DSL_1
    char *    X_BROADCOM_COM_DownstreamDelay_2;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_DSL_1
    char *    X_BROADCOM_COM_DownstreamINP;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_DSL_1
    char *    X_BROADCOM_COM_DownstreamINP_2;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_DSL_1
    char *    X_BROADCOM_COM_UpstreamINP;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_DSL_1
    char *    X_BROADCOM_COM_UpstreamINP_2;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_DSL_1
    UINT32    X_BROADCOM_COM_UpstreamD;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_DSL_1
    UINT32    X_BROADCOM_COM_UpstreamD_2;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_DSL_1
    UINT32    X_BROADCOM_COM_DownstreamD;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_DSL_1
    UINT32    X_BROADCOM_COM_DownstreamD_2;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_DSL_1
    UINT32    X_BROADCOM_COM_ADSL2_UpstreamMSGc;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_DSL_1
    UINT32    X_BROADCOM_COM_ADSL2_UpstreamMSGc_2;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_DSL_1
    UINT32    X_BROADCOM_COM_ADSL2_DownstreamMSGc;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_DSL_1
    UINT32    X_BROADCOM_COM_ADSL2_DownstreamMSGc_2;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_DSL_1
    UINT32    X_BROADCOM_COM_ADSL2_UpstreamB;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_DSL_1
    UINT32    X_BROADCOM_COM_ADSL2_UpstreamB_2;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_DSL_1
    UINT32    X_BROADCOM_COM_ADSL2_DownstreamB;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_DSL_1
    UINT32    X_BROADCOM_COM_ADSL2_DownstreamB_2;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_DSL_1
    UINT32    X_BROADCOM_COM_ADSL2_UpstreamM;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_DSL_1
    UINT32    X_BROADCOM_COM_ADSL2_UpstreamM_2;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_DSL_1
    UINT32    X_BROADCOM_COM_ADSL2_DownstreamM;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_DSL_1
    UINT32    X_BROADCOM_COM_ADSL2_DownstreamM_2;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_DSL_1
    UINT32    X_BROADCOM_COM_ADSL2_UpstreamT;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_DSL_1
    UINT32    X_BROADCOM_COM_ADSL2_UpstreamT_2;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_DSL_1
    UINT32    X_BROADCOM_COM_ADSL2_DownstreamT;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_DSL_1
    UINT32    X_BROADCOM_COM_ADSL2_DownstreamT_2;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_DSL_1
    UINT32    X_BROADCOM_COM_ADSL2_UpstreamR;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_DSL_1
    UINT32    X_BROADCOM_COM_ADSL2_UpstreamR_2;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_DSL_1
    UINT32    X_BROADCOM_COM_ADSL2_DownstreamR;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_DSL_1
    UINT32    X_BROADCOM_COM_ADSL2_DownstreamR_2;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_DSL_1
    char *    X_BROADCOM_COM_ADSL2_UpstreamS;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_DSL_1
    char *    X_BROADCOM_COM_ADSL2_UpstreamS_2;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_DSL_1
    char *    X_BROADCOM_COM_ADSL2_DownstreamS;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_DSL_1
    char *    X_BROADCOM_COM_ADSL2_DownstreamS_2;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_DSL_1
    UINT32    X_BROADCOM_COM_ADSL2_UpstreamL;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_DSL_1
    UINT32    X_BROADCOM_COM_ADSL2_UpstreamL_2;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_DSL_1
    UINT32    X_BROADCOM_COM_ADSL2_DownstreamL;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_DSL_1
    UINT32    X_BROADCOM_COM_ADSL2_DownstreamL_2;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_VDSL2WAN_1
    UBOOL8    X_BROADCOM_COM_VDSL_8a;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_VDSL2WAN_1
    UBOOL8    X_BROADCOM_COM_VDSL_8b;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_VDSL2WAN_1
    UBOOL8    X_BROADCOM_COM_VDSL_8c;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_VDSL2WAN_1
    UBOOL8    X_BROADCOM_COM_VDSL_8d;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_VDSL2WAN_1
    UBOOL8    X_BROADCOM_COM_VDSL_12a;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_VDSL2WAN_1
    UBOOL8    X_BROADCOM_COM_VDSL_12b;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_VDSL2WAN_1
    UBOOL8    X_BROADCOM_COM_VDSL_17a;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_VDSL2WAN_1
    UBOOL8    X_BROADCOM_COM_VDSL_30a;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_VDSL2WAN_1
    UBOOL8    X_BROADCOM_COM_VDSL_BrcmPriv1;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_VDSL2WAN_1
    UBOOL8    X_BROADCOM_COM_VDSL_35b;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_VDSL2WAN_1
    UBOOL8    X_BROADCOM_COM_VDSL_BrcmPriv2;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_VDSL2WAN_1
    UBOOL8    X_BROADCOM_COM_VDSL_US0_8a;	/**< ReadWrite */
#endif
#ifdef DMP_X_BROADCOM_COM_VDSL2WAN_1
    UINT32    X_BROADCOM_COM_VDSL_UpstreamI;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_VDSL2WAN_1
    UINT32    X_BROADCOM_COM_VDSL_UpstreamI_2;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_VDSL2WAN_1
    UINT32    X_BROADCOM_COM_VDSL_DownstreamI;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_VDSL2WAN_1
    UINT32    X_BROADCOM_COM_VDSL_DownstreamI_2;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_VDSL2WAN_1
    UINT32    X_BROADCOM_COM_VDSL_UpstreamN;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_VDSL2WAN_1
    UINT32    X_BROADCOM_COM_VDSL_UpstreamN_2;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_VDSL2WAN_1
    UINT32    X_BROADCOM_COM_VDSL_DownstreamN;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_VDSL2WAN_1
    UINT32    X_BROADCOM_COM_VDSL_DownstreamN_2;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_DSL_1
    char *    X_BROADCOM_COM_LinkPowerState;	/**< ReadOnly */
#endif
    UINT32    X_BROADCOM_COM_DslCfgParam;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_DslTrainingMarginQ4;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_DslShowtimeMarginQ4;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_DslLOMTimeThldSec;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_DslPwmSyncClockFreq;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_DslHsModeSwitchTime;	/**< ReadWrite */
    UINT32    X_BROADCOM_COM_DslParam;	/**< ReadWrite */
    UINT32    X_BROADCOM_COM_DslPhyCfg1Mask;	/**< ReadWrite */
    UINT32    X_BROADCOM_COM_DslPhyCfg1Value;	/**< ReadWrite */
    UINT32    X_BROADCOM_COM_DslPhyCfg2Mask;	/**< ReadWrite */
    UINT32    X_BROADCOM_COM_DslPhyCfg2Value;	/**< ReadWrite */
    UINT32    X_BROADCOM_COM_DslPhyCfg3Mask;	/**< ReadWrite */
    UINT32    X_BROADCOM_COM_DslPhyCfg3Value;	/**< ReadWrite */
    UINT32    X_BROADCOM_COM_DslPhyCfg4Mask;	/**< ReadWrite */
    UINT32    X_BROADCOM_COM_DslPhyCfg4Value;	/**< ReadWrite */
    UINT32    X_BROADCOM_COM_DslPhyCfg5Mask;	/**< ReadWrite */
    UINT32    X_BROADCOM_COM_DslPhyCfg5Value;	/**< ReadWrite */
    UINT32    X_BROADCOM_COM_DslPhyCfg6Mask;	/**< ReadWrite */
    UINT32    X_BROADCOM_COM_DslPhyCfg6Value;	/**< ReadWrite */
    UINT32    X_BROADCOM_COM_DslPhyCfg7Mask;	/**< ReadWrite */
    UINT32    X_BROADCOM_COM_DslPhyCfg7Value;	/**< ReadWrite */
    UINT32    X_BROADCOM_COM_DslPhyCfg8Mask;	/**< ReadWrite */
    UINT32    X_BROADCOM_COM_DslPhyCfg8Value;	/**< ReadWrite */
    UINT32    X_BROADCOM_COM_DslPhyUsDataRateKbps;	/**< ReadWrite */
    UINT32    X_BROADCOM_COM_DslPhyDsDataRateKbps;	/**< ReadWrite */
    UINT32    X_BROADCOM_COM_DslPhyAggrDataRateKbps;	/**< ReadWrite */
    UINT32    X_BROADCOM_COM_DslPhyMiscCfgParam;	/**< ReadWrite */
} Dev2DslLineObject;

/*! \brief _Dev2DslLineObject is used internally to represent Dev2DslLineObject */
typedef Dev2DslLineObject _Dev2DslLineObject;



/*! \brief Obj struct for Device.DSL.Line.{i}.X_BROADCOM_COM_BertTest.
 *
 * MDMOID_DEV2_DSL_LINE_BERT_TEST 1063
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    bertTestMode;	/**< ReadWrite */
    UINT32    bertTestDuration;	/**< ReadWrite */
    char *    bertTestStatus;	/**< ReadOnly */
    UINT32    totalTime;	/**< ReadOnly */
    UINT32    elapsedTime;	/**< ReadOnly */
    UINT32    bitsTestedCntHigh;	/**< ReadOnly */
    UINT32    bitsTestedCntLow;	/**< ReadOnly */
    UINT32    errBitsCntHigh;	/**< ReadOnly */
    UINT32    errBitsCntLow;	/**< ReadOnly */
} Dev2DslLineBertTestObject;

/*! \brief _Dev2DslLineBertTestObject is used internally to represent Dev2DslLineBertTestObject */
typedef Dev2DslLineBertTestObject _Dev2DslLineBertTestObject;



/*! \brief Obj struct for Device.DSL.Line.{i}.Stats.
 *
 * MDMOID_DEV2_DSL_LINE_STATS 1064
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT64    bytesSent;	/**< ReadOnly */
    UINT64    bytesReceived;	/**< ReadOnly */
    UINT64    packetsSent;	/**< ReadOnly */
    UINT64    packetsReceived;	/**< ReadOnly */
    UINT32    errorsSent;	/**< ReadOnly */
    UINT32    errorsReceived;	/**< ReadOnly */
    UINT32    discardPacketsSent;	/**< ReadOnly */
    UINT32    discardPacketsReceived;	/**< ReadOnly */
    UINT32    totalStart;	/**< ReadOnly */
    UINT32    showtimeStart;	/**< ReadOnly */
    UINT32    lastShowtimeStart;	/**< ReadOnly */
    UINT32    currentDayStart;	/**< ReadOnly */
    UINT32    quarterHourStart;	/**< ReadOnly */
} Dev2DslLineStatsObject;

/*! \brief _Dev2DslLineStatsObject is used internally to represent Dev2DslLineStatsObject */
typedef Dev2DslLineStatsObject _Dev2DslLineStatsObject;



/*! \brief Obj struct for Device.DSL.Line.{i}.Stats.Total.
 *
 * MDMOID_DEV2_DSL_LINE_STATS_TOTAL 1065
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    erroredSecs;	/**< ReadOnly */
    UINT32    severelyErroredSecs;	/**< ReadOnly */
#ifdef DMP_X_BROADCOM_COM_DSL_1
    UINT32    X_BROADCOM_COM_UpstreamUas;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_DSL_1
    UINT32    X_BROADCOM_COM_DownstreamUas;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_DSL_1
    UINT32    X_BROADCOM_COM_UpstreamEs;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_DSL_1
    UINT32    X_BROADCOM_COM_UpstreamSes;	/**< ReadOnly */
#endif
} Dev2DslLineStatsTotalObject;

/*! \brief _Dev2DslLineStatsTotalObject is used internally to represent Dev2DslLineStatsTotalObject */
typedef Dev2DslLineStatsTotalObject _Dev2DslLineStatsTotalObject;



/*! \brief Obj struct for Device.DSL.Line.{i}.Stats.Showtime.
 *
 * MDMOID_DEV2_DSL_LINE_STATS_SHOWTIME 1066
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    erroredSecs;	/**< ReadOnly */
    UINT32    severelyErroredSecs;	/**< ReadOnly */
} Dev2DslLineStatsShowtimeObject;

/*! \brief _Dev2DslLineStatsShowtimeObject is used internally to represent Dev2DslLineStatsShowtimeObject */
typedef Dev2DslLineStatsShowtimeObject _Dev2DslLineStatsShowtimeObject;



/*! \brief Obj struct for Device.DSL.Line.{i}.Stats.CurrentDay.
 *
 * MDMOID_DEV2_DSL_LINE_STATS_CURRENT_DAY 1068
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    erroredSecs;	/**< ReadOnly */
    UINT32    severelyErroredSecs;	/**< ReadOnly */
#ifdef DMP_X_RDK_DSL_1
    UINT32    X_RDK_LinkRetrain;	/**< ReadOnly */
#endif
} Dev2DslLineStatsCurrentDayObject;

/*! \brief _Dev2DslLineStatsCurrentDayObject is used internally to represent Dev2DslLineStatsCurrentDayObject */
typedef Dev2DslLineStatsCurrentDayObject _Dev2DslLineStatsCurrentDayObject;



/*! \brief Obj struct for Device.DSL.Line.{i}.Stats.QuarterHour.
 *
 * MDMOID_DEV2_DSL_LINE_STATS_QUARTER_HOUR 1069
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    erroredSecs;	/**< ReadOnly */
    UINT32    severelyErroredSecs;	/**< ReadOnly */
#ifdef DMP_X_RDK_DSL_1
    UINT32    X_RDK_LinkRetrain;	/**< ReadOnly */
#endif
} Dev2DslLineStatsQuarterHourObject;

/*! \brief _Dev2DslLineStatsQuarterHourObject is used internally to represent Dev2DslLineStatsQuarterHourObject */
typedef Dev2DslLineStatsQuarterHourObject _Dev2DslLineStatsQuarterHourObject;



/*! \brief Obj struct for Device.DSL.Line.{i}.TestParams.
 *
 * MDMOID_DEV2_DSL_LINE_TEST_PARAMS 1070
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
#ifdef DMP_DEVICE2_VDSL2_1
    UINT32    HLOGGds;	/**< ReadOnly */
#endif
#ifdef DMP_DEVICE2_VDSL2_1
    UINT32    HLOGGus;	/**< ReadOnly */
#endif
    char *    HLOGpsds;	/**< ReadOnly */
    char *    HLOGpsus;	/**< ReadOnly */
    UINT32    HLOGMTds;	/**< ReadOnly */
    UINT32    HLOGMTus;	/**< ReadOnly */
#ifdef DMP_DEVICE2_VDSL2_1
    UINT32    QLNGds;	/**< ReadOnly */
#endif
#ifdef DMP_DEVICE2_VDSL2_1
    UINT32    QLNGus;	/**< ReadOnly */
#endif
    char *    QLNpsds;	/**< ReadOnly */
    char *    QLNpsus;	/**< ReadOnly */
    UINT32    QLNMTds;	/**< ReadOnly */
    UINT32    QLNMTus;	/**< ReadOnly */
#ifdef DMP_DEVICE2_VDSL2_1
    UINT32    SNRGds;	/**< ReadOnly */
#endif
#ifdef DMP_DEVICE2_VDSL2_1
    UINT32    SNRGus;	/**< ReadOnly */
#endif
    char *    SNRpsds;	/**< ReadOnly */
    char *    SNRpsus;	/**< ReadOnly */
    UINT32    SNRMTds;	/**< ReadOnly */
    UINT32    SNRMTus;	/**< ReadOnly */
    char *    LATNds;	/**< ReadOnly */
    char *    LATNus;	/**< ReadOnly */
    char *    SATNds;	/**< ReadOnly */
    char *    SATNus;	/**< ReadOnly */
} Dev2DslLineTestParamsObject;

/*! \brief _Dev2DslLineTestParamsObject is used internally to represent Dev2DslLineTestParamsObject */
typedef Dev2DslLineTestParamsObject _Dev2DslLineTestParamsObject;



/*! \brief Obj struct for Device.DSL.Channel.{i}.
 *
 * MDMOID_DEV2_DSL_CHANNEL 1071
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    status;	/**< ReadOnly */
    char *    alias;	/**< ReadWrite */
    char *    name;	/**< ReadOnly */
    UINT32    lastChange;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_LastChange;	/**< ReadWrite */
    char *    lowerLayers;	/**< ReadOnly */
#ifdef DMP_DEVICE2_ADSL2_1
    char *    linkEncapsulationSupported;	/**< ReadOnly */
#endif
    char *    linkEncapsulationUsed;	/**< ReadOnly */
    UINT32    LPATH;	/**< ReadOnly */
    UINT32    INTLVDEPTH;	/**< ReadOnly */
    SINT32    INTLVBLOCK;	/**< ReadOnly */
    UINT32    actualInterleavingDelay;	/**< ReadOnly */
    SINT32    ACTINP;	/**< ReadOnly */
    UBOOL8    INPREPORT;	/**< ReadOnly */
    SINT32    NFEC;	/**< ReadOnly */
    SINT32    RFEC;	/**< ReadOnly */
    SINT32    LSYMB;	/**< ReadOnly */
    UINT32    upstreamCurrRate;	/**< ReadOnly */
    UINT32    downstreamCurrRate;	/**< ReadOnly */
#ifdef DMP_X_BROADCOM_COM_DSL_1
    UINT32    X_BROADCOM_COM_UpstreamCurrRate_2;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_DSL_1
    UINT32    X_BROADCOM_COM_DownstreamCurrRate_2;	/**< ReadOnly */
#endif
    UINT32    ACTNDR;	/**< ReadOnly */
    UINT32    ACTINPREIN;	/**< ReadOnly */
} Dev2DslChannelObject;

/*! \brief _Dev2DslChannelObject is used internally to represent Dev2DslChannelObject */
typedef Dev2DslChannelObject _Dev2DslChannelObject;



/*! \brief Obj struct for Device.DSL.Channel.{i}.Stats.
 *
 * MDMOID_DEV2_DSL_CHANNEL_STATS 1072
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT64    bytesSent;	/**< ReadOnly */
    UINT64    bytesReceived;	/**< ReadOnly */
    UINT64    packetsSent;	/**< ReadOnly */
    UINT64    packetsReceived;	/**< ReadOnly */
    UINT32    errorsSent;	/**< ReadOnly */
    UINT32    errorsReceived;	/**< ReadOnly */
    UINT32    discardPacketsSent;	/**< ReadOnly */
    UINT32    discardPacketsReceived;	/**< ReadOnly */
    UINT32    totalStart;	/**< ReadOnly */
    UINT32    showtimeStart;	/**< ReadOnly */
    UINT32    lastShowtimeStart;	/**< ReadOnly */
    UINT32    currentDayStart;	/**< ReadOnly */
    UINT32    quarterHourStart;	/**< ReadOnly */
} Dev2DslChannelStatsObject;

/*! \brief _Dev2DslChannelStatsObject is used internally to represent Dev2DslChannelStatsObject */
typedef Dev2DslChannelStatsObject _Dev2DslChannelStatsObject;



/*! \brief Obj struct for Device.DSL.Channel.{i}.Stats.Total.
 *
 * MDMOID_DEV2_DSL_CHANNEL_STATS_TOTAL 1073
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    XTURFECErrors;	/**< ReadOnly */
    UINT32    XTUCFECErrors;	/**< ReadOnly */
    UINT32    XTURHECErrors;	/**< ReadOnly */
    UINT32    XTUCHECErrors;	/**< ReadOnly */
    UINT32    XTURCRCErrors;	/**< ReadOnly */
    UINT32    XTUCCRCErrors;	/**< ReadOnly */
#ifdef DMP_X_BROADCOM_COM_DSL_1
    UINT32    X_BROADCOM_COM_RxRsCorrectable;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_DSL_1
    UINT32    X_BROADCOM_COM_RxRsCorrectable_2;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_DSL_1
    UINT32    X_BROADCOM_COM_TxRsCorrectable;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_DSL_1
    UINT32    X_BROADCOM_COM_TxRsCorrectable_2;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_DSL_1
    UINT32    X_BROADCOM_COM_TxRsUncorrectable;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_DSL_1
    UINT32    X_BROADCOM_COM_TxRsUncorrectable_2;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_DSL_1
    UINT32    X_BROADCOM_COM_RxRsUncorrectable;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_DSL_1
    UINT32    X_BROADCOM_COM_RxRsUncorrectable_2;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_DSL_1
    UINT32    X_BROADCOM_COM_TxRsWords;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_DSL_1
    UINT32    X_BROADCOM_COM_TxRsWords_2;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_DSL_1
    UINT32    X_BROADCOM_COM_RxRsWords;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_DSL_1
    UINT32    X_BROADCOM_COM_RxRsWords_2;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_DSL_1
    UINT32    X_BROADCOM_COM_ReceiveBlocks;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_DSL_1
    UINT32    X_BROADCOM_COM_ReceiveBlocks_2;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_DSL_1
    UINT32    X_BROADCOM_COM_TransmitBlocks;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_DSL_1
    UINT32    X_BROADCOM_COM_TransmitBlocks_2;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_DSL_1
    UINT32    X_BROADCOM_COM_XTURFECErrors_2;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_DSL_1
    UINT32    X_BROADCOM_COM_XTUCFECErrors_2;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_DSL_1
    UINT32    X_BROADCOM_COM_XTURHECErrors_2;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_DSL_1
    UINT32    X_BROADCOM_COM_XTUCHECErrors_2;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_DSL_1
    UINT32    X_BROADCOM_COM_XTURCRCErrors_2;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_DSL_1
    UINT32    X_BROADCOM_COM_XTUCCRCErrors_2;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_DSL_1
    UINT32    X_BROADCOM_COM_UpstreamBitErrors;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_DSL_1
    UINT32    X_BROADCOM_COM_UpstreamBitErrors_2;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_DSL_1
    UINT32    X_BROADCOM_COM_DownstreamBitErrors;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_DSL_1
    UINT32    X_BROADCOM_COM_DownstreamBitErrors_2;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_DSL_1
    UINT32    X_BROADCOM_COM_UpstreamDataCells;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_DSL_1
    UINT32    X_BROADCOM_COM_UpstreamDataCells_2;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_DSL_1
    UINT32    X_BROADCOM_COM_DownstreamDataCells;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_DSL_1
    UINT32    X_BROADCOM_COM_DownstreamDataCells_2;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_DSL_1
    UINT32    X_BROADCOM_COM_UpstreamTotalCells;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_DSL_1
    UINT32    X_BROADCOM_COM_UpstreamTotalCells_2;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_DSL_1
    UINT32    X_BROADCOM_COM_DownstreamTotalCells;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_DSL_1
    UINT32    X_BROADCOM_COM_DownstreamTotalCells_2;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_DSL_1
    UINT32    X_BROADCOM_COM_UpstreamLCD;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_DSL_1
    UINT32    X_BROADCOM_COM_UpstreamLCD_2;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_DSL_1
    UINT32    X_BROADCOM_COM_DownstreamLCD;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_DSL_1
    UINT32    X_BROADCOM_COM_DownstreamLCD_2;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_DSL_1
    UINT32    X_BROADCOM_COM_UpstreamOCD;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_DSL_1
    UINT32    X_BROADCOM_COM_UpstreamOCD_2;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_DSL_1
    UINT32    X_BROADCOM_COM_DownstreamOCD;	/**< ReadOnly */
#endif
#ifdef DMP_X_BROADCOM_COM_DSL_1
    UINT32    X_BROADCOM_COM_DownstreamOCD_2;	/**< ReadOnly */
#endif
} Dev2DslChannelStatsTotalObject;

/*! \brief _Dev2DslChannelStatsTotalObject is used internally to represent Dev2DslChannelStatsTotalObject */
typedef Dev2DslChannelStatsTotalObject _Dev2DslChannelStatsTotalObject;



/*! \brief Obj struct for Device.DSL.Channel.{i}.Stats.Showtime.
 *
 * MDMOID_DEV2_DSL_CHANNEL_STATS_SHOWTIME 1074
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    XTURFECErrors;	/**< ReadOnly */
    UINT32    XTUCFECErrors;	/**< ReadOnly */
    UINT32    XTURHECErrors;	/**< ReadOnly */
    UINT32    XTUCHECErrors;	/**< ReadOnly */
    UINT32    XTURCRCErrors;	/**< ReadOnly */
    UINT32    XTUCCRCErrors;	/**< ReadOnly */
} Dev2DslChannelStatsShowtimeObject;

/*! \brief _Dev2DslChannelStatsShowtimeObject is used internally to represent Dev2DslChannelStatsShowtimeObject */
typedef Dev2DslChannelStatsShowtimeObject _Dev2DslChannelStatsShowtimeObject;



/*! \brief Obj struct for Device.DSL.Channel.{i}.Stats.LastShowtime.
 *
 * MDMOID_DEV2_DSL_CHANNEL_STATS_LAST_SHOWTIME 1075
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    XTURFECErrors;	/**< ReadOnly */
    UINT32    XTUCFECErrors;	/**< ReadOnly */
    UINT32    XTURHECErrors;	/**< ReadOnly */
    UINT32    XTUCHECErrors;	/**< ReadOnly */
    UINT32    XTURCRCErrors;	/**< ReadOnly */
    UINT32    XTUCCRCErrors;	/**< ReadOnly */
} Dev2DslChannelStatsLastShowtimeObject;

/*! \brief _Dev2DslChannelStatsLastShowtimeObject is used internally to represent Dev2DslChannelStatsLastShowtimeObject */
typedef Dev2DslChannelStatsLastShowtimeObject _Dev2DslChannelStatsLastShowtimeObject;



/*! \brief Obj struct for Device.DSL.Channel.{i}.Stats.CurrentDay.
 *
 * MDMOID_DEV2_DSL_CHANNEL_STATS_CURRENT_DAY 1076
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    XTURFECErrors;	/**< ReadOnly */
    UINT32    XTUCFECErrors;	/**< ReadOnly */
    UINT32    XTURHECErrors;	/**< ReadOnly */
    UINT32    XTUCHECErrors;	/**< ReadOnly */
    UINT32    XTURCRCErrors;	/**< ReadOnly */
    UINT32    XTUCCRCErrors;	/**< ReadOnly */
#ifdef DMP_X_RDK_DSL_1
    UINT32    X_RDK_LinkRetrain;	/**< ReadOnly */
#endif
} Dev2DslChannelStatsCurrentDayObject;

/*! \brief _Dev2DslChannelStatsCurrentDayObject is used internally to represent Dev2DslChannelStatsCurrentDayObject */
typedef Dev2DslChannelStatsCurrentDayObject _Dev2DslChannelStatsCurrentDayObject;



/*! \brief Obj struct for Device.DSL.Channel.{i}.Stats.QuarterHour.
 *
 * MDMOID_DEV2_DSL_CHANNEL_STATS_QUARTER_HOUR 1077
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    XTURFECErrors;	/**< ReadOnly */
    UINT32    XTUCFECErrors;	/**< ReadOnly */
    UINT32    XTURHECErrors;	/**< ReadOnly */
    UINT32    XTUCHECErrors;	/**< ReadOnly */
    UINT32    XTURCRCErrors;	/**< ReadOnly */
    UINT32    XTUCCRCErrors;	/**< ReadOnly */
#ifdef DMP_X_RDK_DSL_1
    UINT32    X_RDK_LinkRetrain;	/**< ReadOnly */
#endif
} Dev2DslChannelStatsQuarterHourObject;

/*! \brief _Dev2DslChannelStatsQuarterHourObject is used internally to represent Dev2DslChannelStatsQuarterHourObject */
typedef Dev2DslChannelStatsQuarterHourObject _Dev2DslChannelStatsQuarterHourObject;



/*! \brief Obj struct for Device.DSL.BondingGroup.{i}.
 *
 * MDMOID_DEV2_DSL_BONDING_GROUP 1090
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    status;	/**< ReadOnly */
    char *    alias;	/**< ReadWrite */
    char *    name;	/**< ReadOnly */
    UINT32    lastChange;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_LastChange;	/**< ReadWrite */
    char *    lowerLayers;	/**< ReadOnly */
    char *    groupStatus;	/**< ReadOnly */
    UINT32    groupID;	/**< ReadOnly */
    char *    bondSchemesSupported;	/**< ReadOnly */
    char *    bondScheme;	/**< ReadOnly */
    UINT32    groupCapacity;	/**< ReadOnly */
    UINT32    runningTime;	/**< ReadOnly */
    UINT32    targetUpRate;	/**< ReadOnly */
    UINT32    targetDownRate;	/**< ReadOnly */
    UINT32    upstreamDifferentialDelayTolerance;	/**< ReadOnly */
    UINT32    bondedChannelNumberOfEntries;	/**< ReadOnly */
} Dev2DslBondingGroupObject;

/*! \brief _Dev2DslBondingGroupObject is used internally to represent Dev2DslBondingGroupObject */
typedef Dev2DslBondingGroupObject _Dev2DslBondingGroupObject;



/*! \brief Obj struct for Device.DSL.BondingGroup.{i}.BondedChannel.{i}.
 *
 * MDMOID_DEV2_DSL_BONDING_GROUP_BONDED_CHANNEL 1091
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    alias;	/**< ReadWrite */
    char *    channel;	/**< ReadOnly */
} Dev2DslBondingGroupBondedChannelObject;

/*! \brief _Dev2DslBondingGroupBondedChannelObject is used internally to represent Dev2DslBondingGroupBondedChannelObject */
typedef Dev2DslBondingGroupBondedChannelObject _Dev2DslBondingGroupBondedChannelObject;



/*! \brief Obj struct for Device.DSL.BondingGroup.{i}.BondedChannel.{i}.Ethernet.
 *
 * MDMOID_DEV2_DSL_BONDING_GROUP_BONDED_CHANNEL_ETHERNET 1092
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
} Dev2DslBondingGroupBondedChannelEthernetObject;

/*! \brief _Dev2DslBondingGroupBondedChannelEthernetObject is used internally to represent Dev2DslBondingGroupBondedChannelEthernetObject */
typedef Dev2DslBondingGroupBondedChannelEthernetObject _Dev2DslBondingGroupBondedChannelEthernetObject;



/*! \brief Obj struct for Device.DSL.BondingGroup.{i}.BondedChannel.{i}.Ethernet.Stats.
 *
 * MDMOID_DEV2_DSL_BONDING_GROUP_BONDED_CHANNEL_ETHERNET_STATS 1093
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
} Dev2DslBondingGroupBondedChannelEthernetStatsObject;

/*! \brief _Dev2DslBondingGroupBondedChannelEthernetStatsObject is used internally to represent Dev2DslBondingGroupBondedChannelEthernetStatsObject */
typedef Dev2DslBondingGroupBondedChannelEthernetStatsObject _Dev2DslBondingGroupBondedChannelEthernetStatsObject;



/*! \brief Obj struct for Device.DSL.BondingGroup.{i}.Stats.
 *
 * MDMOID_DEV2_DSL_BONDING_GROUP_STATS 1094
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT64    bytesSent;	/**< ReadOnly */
    UINT64    bytesReceived;	/**< ReadOnly */
    UINT64    packetsSent;	/**< ReadOnly */
    UINT64    packetsReceived;	/**< ReadOnly */
    UINT32    errorsSent;	/**< ReadOnly */
    UINT32    errorsReceived;	/**< ReadOnly */
    UINT64    unicastPacketsSent;	/**< ReadOnly */
    UINT64    unicastPacketsReceived;	/**< ReadOnly */
    UINT32    discardPacketsSent;	/**< ReadOnly */
    UINT32    discardPacketsReceived;	/**< ReadOnly */
    UINT64    multicastPacketsSent;	/**< ReadOnly */
    UINT64    multicastPacketsReceived;	/**< ReadOnly */
    UINT64    broadcastPacketsSent;	/**< ReadOnly */
    UINT64    broadcastPacketsReceived;	/**< ReadOnly */
    UINT32    unknownProtoPacketsReceived;	/**< ReadOnly */
    UINT32    totalStart;	/**< ReadOnly */
    UINT32    currentDayStart;	/**< ReadOnly */
    UINT32    quarterHourStart;	/**< ReadOnly */
} Dev2DslBondingGroupStatsObject;

/*! \brief _Dev2DslBondingGroupStatsObject is used internally to represent Dev2DslBondingGroupStatsObject */
typedef Dev2DslBondingGroupStatsObject _Dev2DslBondingGroupStatsObject;



/*! \brief Obj struct for Device.DSL.BondingGroup.{i}.Stats.Total.
 *
 * MDMOID_DEV2_DSL_BONDING_GROUP_STATS_TOTAL 1095
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    upstreamRate;	/**< ReadOnly */
    UINT32    downstreamRate;	/**< ReadOnly */
    UINT32    upstreamDifferentialDelay;	/**< ReadOnly */
    UINT32    erroredSeconds;	/**< ReadOnly */
    UINT32    severelyErroredSeconds;	/**< ReadOnly */
    UINT32    unavailableSeconds;	/**< ReadOnly */
} Dev2DslBondingGroupStatsTotalObject;

/*! \brief _Dev2DslBondingGroupStatsTotalObject is used internally to represent Dev2DslBondingGroupStatsTotalObject */
typedef Dev2DslBondingGroupStatsTotalObject _Dev2DslBondingGroupStatsTotalObject;



/*! \brief Obj struct for Device.DSL.BondingGroup.{i}.Stats.CurrentDay.
 *
 * MDMOID_DEV2_DSL_BONDING_GROUP_STATS_CURRENT_DAY 1096
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    upstreamRate;	/**< ReadOnly */
    UINT32    downstreamRate;	/**< ReadOnly */
    UINT32    upstreamDifferentialDelay;	/**< ReadOnly */
    UINT32    erroredSeconds;	/**< ReadOnly */
    UINT32    severelyErroredSeconds;	/**< ReadOnly */
    UINT32    unavailableSeconds;	/**< ReadOnly */
} Dev2DslBondingGroupStatsCurrentDayObject;

/*! \brief _Dev2DslBondingGroupStatsCurrentDayObject is used internally to represent Dev2DslBondingGroupStatsCurrentDayObject */
typedef Dev2DslBondingGroupStatsCurrentDayObject _Dev2DslBondingGroupStatsCurrentDayObject;



/*! \brief Obj struct for Device.DSL.BondingGroup.{i}.Stats.QuarterHour.
 *
 * MDMOID_DEV2_DSL_BONDING_GROUP_STATS_QUARTER_HOUR 1097
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    upstreamRate;	/**< ReadOnly */
    UINT32    downstreamRate;	/**< ReadOnly */
    UINT32    upstreamDifferentialDelay;	/**< ReadOnly */
    UINT32    erroredSeconds;	/**< ReadOnly */
    UINT32    severelyErroredSeconds;	/**< ReadOnly */
    UINT32    unavailableSeconds;	/**< ReadOnly */
} Dev2DslBondingGroupStatsQuarterHourObject;

/*! \brief _Dev2DslBondingGroupStatsQuarterHourObject is used internally to represent Dev2DslBondingGroupStatsQuarterHourObject */
typedef Dev2DslBondingGroupStatsQuarterHourObject _Dev2DslBondingGroupStatsQuarterHourObject;



/*! \brief Obj struct for Device.DSL.BondingGroup.{i}.Ethernet.
 *
 * MDMOID_DEV2_DSL_BONDING_GROUP_ETHERNET 1098
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
} Dev2DslBondingGroupEthernetObject;

/*! \brief _Dev2DslBondingGroupEthernetObject is used internally to represent Dev2DslBondingGroupEthernetObject */
typedef Dev2DslBondingGroupEthernetObject _Dev2DslBondingGroupEthernetObject;



/*! \brief Obj struct for Device.DSL.BondingGroup.{i}.Ethernet.Stats.
 *
 * MDMOID_DEV2_DSL_BONDING_GROUP_ETHERNET_STATS 1099
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    PAFErrors;	/**< ReadOnly */
    UINT32    PAFLostFragments;	/**< ReadOnly */
    UINT32    overflowErrorsReceived;	/**< ReadOnly */
    UINT32    framesDropped;	/**< ReadOnly */
} Dev2DslBondingGroupEthernetStatsObject;

/*! \brief _Dev2DslBondingGroupEthernetStatsObject is used internally to represent Dev2DslBondingGroupEthernetStatsObject */
typedef Dev2DslBondingGroupEthernetStatsObject _Dev2DslBondingGroupEthernetStatsObject;



/*! \brief Obj struct for Device.DSL.Diagnostics.
 *
 * MDMOID_DEV2_DSL_DIAGNOSTICS 1078
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
} Dev2DslDiagnosticsObject;

/*! \brief _Dev2DslDiagnosticsObject is used internally to represent Dev2DslDiagnosticsObject */
typedef Dev2DslDiagnosticsObject _Dev2DslDiagnosticsObject;



/*! \brief Obj struct for Device.DSL.Diagnostics.ADSLLineTest.
 *
 * MDMOID_ADSL_LINE_TEST 1079
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    diagnosticsState;	/**< ReadWrite */
    char *    interface;	/**< ReadWrite */
    UINT32    X_BROADCOM_COM_LineId;	/**< ReadOnly */
    SINT32    ACTPSDds;	/**< ReadOnly */
    SINT32    ACTPSDus;	/**< ReadOnly */
    SINT32    ACTATPds;	/**< ReadOnly */
    SINT32    ACTATPus;	/**< ReadOnly */
    SINT32    HLINSCds;	/**< ReadOnly */
    SINT32    HLINSCus;	/**< ReadOnly */
    UINT32    HLINGds;	/**< ReadOnly */
    UINT32    HLINGus;	/**< ReadOnly */
    UINT32    HLOGGds;	/**< ReadOnly */
    UINT32    HLOGGus;	/**< ReadOnly */
    char *    HLOGpsds;	/**< ReadOnly */
    char *    HLOGpsus;	/**< ReadOnly */
    UINT32    HLOGMTds;	/**< ReadOnly */
    UINT32    HLOGMTus;	/**< ReadOnly */
    char *    LATNpbds;	/**< ReadOnly */
    char *    LATNpbus;	/**< ReadOnly */
    char *    SATNds;	/**< ReadOnly */
    char *    SATNus;	/**< ReadOnly */
    char *    HLINpsds;	/**< ReadOnly */
    char *    HLINpsus;	/**< ReadOnly */
    UINT32    QLNGds;	/**< ReadOnly */
    UINT32    QLNGus;	/**< ReadOnly */
    char *    QLNpsds;	/**< ReadOnly */
    char *    QLNpsus;	/**< ReadOnly */
    UINT32    QLNMTds;	/**< ReadOnly */
    UINT32    QLNMTus;	/**< ReadOnly */
    UINT32    SNRGds;	/**< ReadOnly */
    UINT32    SNRGus;	/**< ReadOnly */
    char *    SNRpsds;	/**< ReadOnly */
    char *    SNRpsus;	/**< ReadOnly */
    UINT32    SNRMTds;	/**< ReadOnly */
    UINT32    SNRMTus;	/**< ReadOnly */
    char *    BITSpsds;	/**< ReadOnly */
    char *    BITSpsus;	/**< ReadOnly */
} Dev2DslDiagnosticsADSLLineTestObject;

/*! \brief _Dev2DslDiagnosticsADSLLineTestObject is used internally to represent Dev2DslDiagnosticsADSLLineTestObject */
typedef Dev2DslDiagnosticsADSLLineTestObject _Dev2DslDiagnosticsADSLLineTestObject;



/*! \brief Obj struct for Device.ATM.
 *
 * MDMOID_DEV2_ATM 1130
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    linkNumberOfEntries;	/**< ReadOnly */
} Dev2AtmObject;

/*! \brief _Dev2AtmObject is used internally to represent Dev2AtmObject */
typedef Dev2AtmObject _Dev2AtmObject;



/*! \brief Obj struct for Device.ATM.Link.{i}.
 *
 * MDMOID_DEV2_ATM_LINK 1131
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    status;	/**< ReadOnly */
    char *    alias;	/**< ReadWrite */
    char *    name;	/**< ReadOnly */
    UINT32    lastChange;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_LastChange;	/**< ReadWrite */
    char *    lowerLayers;	/**< ReadWrite */
    char *    linkType;	/**< ReadWrite */
    UBOOL8    autoConfig;	/**< ReadOnly */
    char *    destinationAddress;	/**< ReadWrite */
    char *    encapsulation;	/**< ReadWrite */
    UBOOL8    FCSPreserved;	/**< ReadWrite */
    char *    VCSearchList;	/**< ReadWrite */
    char *    AAL;	/**< ReadOnly */
#ifdef DMP_DEVICE2_X_BROADCOM_COM_ATMLINK_1
    UINT32    X_BROADCOM_COM_ATMInterfaceId;	/**< ReadWrite */
#endif
#ifdef DMP_DEVICE2_X_BROADCOM_COM_ATMLINK_1
    char *    X_BROADCOM_COM_ConnectionMode;	/**< ReadWrite */
#endif
#ifdef DMP_DEVICE2_X_BROADCOM_COM_ATMLINK_1
    char *    X_BROADCOM_COM_MacAddress;	/**< ReadOnly */
#endif
#ifdef DMP_DEVICE2_X_BROADCOM_COM_ATMLINK_1
    UBOOL8    X_BROADCOM_COM_ATMEnbQos;	/**< ReadWrite */
#endif
#ifdef DMP_DEVICE2_X_BROADCOM_COM_ATMLINK_1
    char *    X_BROADCOM_COM_GrpScheduler;	/**< ReadWrite */
#endif
#ifdef DMP_DEVICE2_X_BROADCOM_COM_ATMLINK_1
    UINT32    X_BROADCOM_COM_GrpWeight;	/**< ReadWrite */
#endif
#ifdef DMP_DEVICE2_X_BROADCOM_COM_ATMLINK_1
    UINT32    X_BROADCOM_COM_GrpPrecedence;	/**< ReadWrite */
#endif
#ifdef DMP_DEVICE2_X_BROADCOM_COM_ATMLINK_1
    char *    X_BROADCOM_COM_SchedulerAlgorithm;	/**< ReadWrite */
#endif
#ifdef DMP_DEVICE2_X_BROADCOM_COM_ATMLINK_1
    UINT32    X_BROADCOM_COM_QueueWeight;	/**< ReadWrite */
#endif
#ifdef DMP_DEVICE2_X_BROADCOM_COM_ATMLINK_1
    UINT32    X_BROADCOM_COM_QueuePrecedence;	/**< ReadWrite */
#endif
#ifdef DMP_DEVICE2_X_BROADCOM_COM_ATMLINK_1
    char *    X_BROADCOM_COM_DropAlgorithm;	/**< ReadWrite */
#endif
#ifdef DMP_DEVICE2_X_BROADCOM_COM_ATMLINK_1
    UINT32    X_BROADCOM_COM_LowClassMinThreshold;	/**< ReadWrite */
#endif
#ifdef DMP_DEVICE2_X_BROADCOM_COM_ATMLINK_1
    UINT32    X_BROADCOM_COM_LowClassMaxThreshold;	/**< ReadWrite */
#endif
#ifdef DMP_DEVICE2_X_BROADCOM_COM_ATMLINK_1
    UINT32    X_BROADCOM_COM_HighClassMinThreshold;	/**< ReadWrite */
#endif
#ifdef DMP_DEVICE2_X_BROADCOM_COM_ATMLINK_1
    UINT32    X_BROADCOM_COM_HighClassMaxThreshold;	/**< ReadWrite */
#endif
} Dev2AtmLinkObject;

/*! \brief _Dev2AtmLinkObject is used internally to represent Dev2AtmLinkObject */
typedef Dev2AtmLinkObject _Dev2AtmLinkObject;



/*! \brief Obj struct for Device.ATM.Link.{i}.Stats.
 *
 * MDMOID_DEV2_ATM_LINK_STATS 1132
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT64    bytesSent;	/**< ReadOnly */
    UINT64    bytesReceived;	/**< ReadOnly */
    UINT64    packetsSent;	/**< ReadOnly */
    UINT64    packetsReceived;	/**< ReadOnly */
    UINT32    errorsSent;	/**< ReadOnly */
    UINT32    errorsReceived;	/**< ReadOnly */
    UINT64    unicastPacketsSent;	/**< ReadOnly */
    UINT64    unicastPacketsReceived;	/**< ReadOnly */
    UINT32    discardPacketsSent;	/**< ReadOnly */
    UINT32    discardPacketsReceived;	/**< ReadOnly */
    UINT64    multicastPacketsSent;	/**< ReadOnly */
    UINT64    multicastPacketsReceived;	/**< ReadOnly */
    UINT64    broadcastPacketsSent;	/**< ReadOnly */
    UINT64    broadcastPacketsReceived;	/**< ReadOnly */
    UINT32    unknownProtoPacketsReceived;	/**< ReadOnly */
    UINT32    transmittedBlocks;	/**< ReadOnly */
    UINT32    receivedBlocks;	/**< ReadOnly */
    UINT32    CRCErrors;	/**< ReadOnly */
    UINT32    HECErrors;	/**< ReadOnly */
#ifdef DMP_DEVICE2_X_BROADCOM_COM_ATMLINK_1
    UINT32    X_BROADCOM_COM_InOAMCells;	/**< ReadOnly */
#endif
#ifdef DMP_DEVICE2_X_BROADCOM_COM_ATMLINK_1
    UINT32    X_BROADCOM_COM_OutOAMCells;	/**< ReadOnly */
#endif
#ifdef DMP_DEVICE2_X_BROADCOM_COM_ATMLINK_1
    UINT32    X_BROADCOM_COM_InASMCells;	/**< ReadOnly */
#endif
#ifdef DMP_DEVICE2_X_BROADCOM_COM_ATMLINK_1
    UINT32    X_BROADCOM_COM_OutASMCells;	/**< ReadOnly */
#endif
#ifdef DMP_DEVICE2_X_BROADCOM_COM_ATMLINK_1
    UINT32    X_BROADCOM_COM_InCellErrors;	/**< ReadOnly */
#endif
} Dev2AtmLinkStatsObject;

/*! \brief _Dev2AtmLinkStatsObject is used internally to represent Dev2AtmLinkStatsObject */
typedef Dev2AtmLinkStatsObject _Dev2AtmLinkStatsObject;



/*! \brief Obj struct for Device.ATM.Link.{i}.QoS.
 *
 * MDMOID_DEV2_ATM_LINK_QOS 1133
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    qoSClass;	/**< ReadWrite */
    UINT32    peakCellRate;	/**< ReadWrite */
    UINT32    maximumBurstSize;	/**< ReadWrite */
    UINT32    sustainableCellRate;	/**< ReadWrite */
#ifdef DMP_DEVICE2_X_BROADCOM_COM_ATMLINK_1
    SINT32    X_BROADCOM_COM_MinimumCellRate;	/**< ReadWrite */
#endif
} Dev2AtmLinkQosObject;

/*! \brief _Dev2AtmLinkQosObject is used internally to represent Dev2AtmLinkQosObject */
typedef Dev2AtmLinkQosObject _Dev2AtmLinkQosObject;



/*! \brief Obj struct for Device.ATM.Diagnostics.
 *
 * MDMOID_DEV2_ATM_DIAGNOSTICS 1134
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
} Dev2AtmDiagnosticsObject;

/*! \brief _Dev2AtmDiagnosticsObject is used internally to represent Dev2AtmDiagnosticsObject */
typedef Dev2AtmDiagnosticsObject _Dev2AtmDiagnosticsObject;



/*! \brief Obj struct for Device.ATM.Diagnostics.F5Loopback.
 *
 * MDMOID_DEV2_ATM_DIAGNOSTICS_F5_LOOPBACK 1135
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    diagnosticsState;	/**< ReadWrite */
    char *    interface;	/**< ReadWrite */
    UINT32    numberOfRepetitions;	/**< ReadWrite */
    UINT32    timeout;	/**< ReadWrite */
    UINT32    successCount;	/**< ReadOnly */
    UINT32    failureCount;	/**< ReadOnly */
    UINT32    averageResponseTime;	/**< ReadOnly */
    UINT32    minimumResponseTime;	/**< ReadOnly */
    UINT32    maximumResponseTime;	/**< ReadOnly */
} Dev2AtmDiagnosticsF5LoopbackObject;

/*! \brief _Dev2AtmDiagnosticsF5LoopbackObject is used internally to represent Dev2AtmDiagnosticsF5LoopbackObject */
typedef Dev2AtmDiagnosticsF5LoopbackObject _Dev2AtmDiagnosticsF5LoopbackObject;



/*! \brief Obj struct for Device.ATM.Diagnostics.X_BROADCOM_COM_F4EndToEndLoopback.
 *
 * MDMOID_DEV2_ATM_DIAGNOSTICS_F4_END_TO_END_LOOPBACK 1136
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    diagnosticsState;	/**< ReadWrite */
    char *    interface;	/**< ReadWrite */
    UINT32    numberOfRepetitions;	/**< ReadWrite */
    UINT32    timeout;	/**< ReadWrite */
    UINT32    successCount;	/**< ReadOnly */
    UINT32    failureCount;	/**< ReadOnly */
    UINT32    averageResponseTime;	/**< ReadOnly */
    UINT32    minimumResponseTime;	/**< ReadOnly */
    UINT32    maximumResponseTime;	/**< ReadOnly */
} Dev2AtmDiagnosticsF4EndToEndLoopbackObject;

/*! \brief _Dev2AtmDiagnosticsF4EndToEndLoopbackObject is used internally to represent Dev2AtmDiagnosticsF4EndToEndLoopbackObject */
typedef Dev2AtmDiagnosticsF4EndToEndLoopbackObject _Dev2AtmDiagnosticsF4EndToEndLoopbackObject;



/*! \brief Obj struct for Device.ATM.Diagnostics.X_BROADCOM_COM_F4Loopback.
 *
 * MDMOID_DEV2_ATM_DIAGNOSTICS_F4_LOOPBACK 1137
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    diagnosticsState;	/**< ReadWrite */
    char *    interface;	/**< ReadWrite */
    UINT32    numberOfRepetitions;	/**< ReadWrite */
    UINT32    timeout;	/**< ReadWrite */
    UINT32    successCount;	/**< ReadOnly */
    UINT32    failureCount;	/**< ReadOnly */
    UINT32    averageResponseTime;	/**< ReadOnly */
    UINT32    minimumResponseTime;	/**< ReadOnly */
    UINT32    maximumResponseTime;	/**< ReadOnly */
} Dev2AtmDiagnosticsF4LoopbackObject;

/*! \brief _Dev2AtmDiagnosticsF4LoopbackObject is used internally to represent Dev2AtmDiagnosticsF4LoopbackObject */
typedef Dev2AtmDiagnosticsF4LoopbackObject _Dev2AtmDiagnosticsF4LoopbackObject;



/*! \brief Obj struct for Device.ATM.Diagnostics.X_BROADCOM_COM_F5EndToEndLoopback.
 *
 * MDMOID_DEV2_ATM_DIAGNOSTICS_F5_END_TO_END_LOOPBACK 1138
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    diagnosticsState;	/**< ReadWrite */
    char *    interface;	/**< ReadWrite */
    UINT32    numberOfRepetitions;	/**< ReadWrite */
    UINT32    timeout;	/**< ReadWrite */
    UINT32    successCount;	/**< ReadOnly */
    UINT32    failureCount;	/**< ReadOnly */
    UINT32    averageResponseTime;	/**< ReadOnly */
    UINT32    minimumResponseTime;	/**< ReadOnly */
    UINT32    maximumResponseTime;	/**< ReadOnly */
} Dev2AtmDiagnosticsF5EndToEndLoopbackObject;

/*! \brief _Dev2AtmDiagnosticsF5EndToEndLoopbackObject is used internally to represent Dev2AtmDiagnosticsF5EndToEndLoopbackObject */
typedef Dev2AtmDiagnosticsF5EndToEndLoopbackObject _Dev2AtmDiagnosticsF5EndToEndLoopbackObject;



/*! \brief Obj struct for Device.PTM.
 *
 * MDMOID_DEV2_PTM 1140
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    linkNumberOfEntries;	/**< ReadOnly */
} Dev2PtmObject;

/*! \brief _Dev2PtmObject is used internally to represent Dev2PtmObject */
typedef Dev2PtmObject _Dev2PtmObject;



/*! \brief Obj struct for Device.PTM.Link.{i}.
 *
 * MDMOID_DEV2_PTM_LINK 1141
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    status;	/**< ReadOnly */
    char *    alias;	/**< ReadWrite */
    char *    name;	/**< ReadOnly */
    UINT32    lastChange;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_LastChange;	/**< ReadWrite */
    char *    lowerLayers;	/**< ReadWrite */
    char *    MACAddress;	/**< ReadOnly */
#ifdef DMP_DEVICE2_X_BROADCOM_COM_PTMLINK_1
    UBOOL8    X_BROADCOM_COM_PTMEnbQos;	/**< ReadWrite */
#endif
#ifdef DMP_DEVICE2_X_BROADCOM_COM_PTMLINK_1
    UINT32    X_BROADCOM_COM_PTMPortId;	/**< ReadWrite */
#endif
#ifdef DMP_DEVICE2_X_BROADCOM_COM_PTMLINK_1
    char *    X_BROADCOM_COM_ConnectionMode;	/**< ReadWrite */
#endif
#ifdef DMP_DEVICE2_X_BROADCOM_COM_PTMLINK_1
    UBOOL8    X_BROADCOM_COM_PTMPriorityLow;	/**< ReadWrite */
#endif
#ifdef DMP_DEVICE2_X_BROADCOM_COM_PTMLINK_1
    UBOOL8    X_BROADCOM_COM_PTMPriorityHigh;	/**< ReadWrite */
#endif
#ifdef DMP_DEVICE2_X_BROADCOM_COM_PTMLINK_1
    char *    X_BROADCOM_COM_GrpScheduler;	/**< ReadWrite */
#endif
#ifdef DMP_DEVICE2_X_BROADCOM_COM_PTMLINK_1
    UINT32    X_BROADCOM_COM_GrpWeight;	/**< ReadWrite */
#endif
#ifdef DMP_DEVICE2_X_BROADCOM_COM_PTMLINK_1
    UINT32    X_BROADCOM_COM_GrpPrecedence;	/**< ReadWrite */
#endif
#ifdef DMP_DEVICE2_X_BROADCOM_COM_PTMLINK_1
    char *    X_BROADCOM_COM_SchedulerAlgorithm;	/**< ReadWrite */
#endif
#ifdef DMP_DEVICE2_X_BROADCOM_COM_PTMLINK_1
    UINT32    X_BROADCOM_COM_QueueWeight;	/**< ReadWrite */
#endif
#ifdef DMP_DEVICE2_X_BROADCOM_COM_PTMLINK_1
    UINT32    X_BROADCOM_COM_QueuePrecedence;	/**< ReadWrite */
#endif
#ifdef DMP_DEVICE2_X_BROADCOM_COM_PTMLINK_1
    char *    X_BROADCOM_COM_DropAlgorithm;	/**< ReadWrite */
#endif
#ifdef DMP_DEVICE2_X_BROADCOM_COM_PTMLINK_1
    UINT32    X_BROADCOM_COM_LowClassMinThreshold;	/**< ReadWrite */
#endif
#ifdef DMP_DEVICE2_X_BROADCOM_COM_PTMLINK_1
    UINT32    X_BROADCOM_COM_LowClassMaxThreshold;	/**< ReadWrite */
#endif
#ifdef DMP_DEVICE2_X_BROADCOM_COM_PTMLINK_1
    UINT32    X_BROADCOM_COM_HighClassMinThreshold;	/**< ReadWrite */
#endif
#ifdef DMP_DEVICE2_X_BROADCOM_COM_PTMLINK_1
    UINT32    X_BROADCOM_COM_HighClassMaxThreshold;	/**< ReadWrite */
#endif
#ifdef DMP_DEVICE2_X_BROADCOM_COM_PTMLINK_1
    SINT32    X_BROADCOM_COM_QueueMinimumRate;	/**< ReadWrite */
#endif
#ifdef DMP_DEVICE2_X_BROADCOM_COM_PTMLINK_1
    SINT32    X_BROADCOM_COM_QueueShapingRate;	/**< ReadWrite */
#endif
#ifdef DMP_DEVICE2_X_BROADCOM_COM_PTMLINK_1
    UINT32    X_BROADCOM_COM_QueueShapingBurstSize;	/**< ReadWrite */
#endif
} Dev2PtmLinkObject;

/*! \brief _Dev2PtmLinkObject is used internally to represent Dev2PtmLinkObject */
typedef Dev2PtmLinkObject _Dev2PtmLinkObject;



/*! \brief Obj struct for Device.PTM.Link.{i}.Stats.
 *
 * MDMOID_DEV2_PTM_LINK_STATS 1142
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT64    bytesSent;	/**< ReadOnly */
    UINT64    bytesReceived;	/**< ReadOnly */
    UINT64    packetsSent;	/**< ReadOnly */
    UINT64    packetsReceived;	/**< ReadOnly */
    UINT32    errorsSent;	/**< ReadOnly */
    UINT32    errorsReceived;	/**< ReadOnly */
    UINT64    unicastPacketsSent;	/**< ReadOnly */
    UINT64    unicastPacketsReceived;	/**< ReadOnly */
    UINT32    discardPacketsSent;	/**< ReadOnly */
    UINT32    discardPacketsReceived;	/**< ReadOnly */
    UINT64    multicastPacketsSent;	/**< ReadOnly */
    UINT64    multicastPacketsReceived;	/**< ReadOnly */
    UINT64    broadcastPacketsSent;	/**< ReadOnly */
    UINT64    broadcastPacketsReceived;	/**< ReadOnly */
    UINT32    unknownProtoPacketsReceived;	/**< ReadOnly */
#ifdef DMP_DEVICE2_X_BROADCOM_COM_PTMLINK_1
    UINT32    X_BROADCOM_COM_InOAMCells;	/**< ReadOnly */
#endif
#ifdef DMP_DEVICE2_X_BROADCOM_COM_PTMLINK_1
    UINT32    X_BROADCOM_COM_OutOAMCells;	/**< ReadOnly */
#endif
#ifdef DMP_DEVICE2_X_BROADCOM_COM_PTMLINK_1
    UINT32    X_BROADCOM_COM_InASMCells;	/**< ReadOnly */
#endif
#ifdef DMP_DEVICE2_X_BROADCOM_COM_PTMLINK_1
    UINT32    X_BROADCOM_COM_OutASMCells;	/**< ReadOnly */
#endif
#ifdef DMP_DEVICE2_X_BROADCOM_COM_PTMLINK_1
    UINT32    X_BROADCOM_COM_InCellErrors;	/**< ReadOnly */
#endif
} Dev2PtmLinkStatsObject;

/*! \brief _Dev2PtmLinkStatsObject is used internally to represent Dev2PtmLinkStatsObject */
typedef Dev2PtmLinkStatsObject _Dev2PtmLinkStatsObject;



/*! \brief Obj struct for Device.USB.
 *
 * MDMOID_DEV2_USB 1180
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    interfaceNumberOfEntries;	/**< ReadOnly */
} Dev2UsbObject;

/*! \brief _Dev2UsbObject is used internally to represent Dev2UsbObject */
typedef Dev2UsbObject _Dev2UsbObject;



/*! \brief Obj struct for Device.USB.Interface.{i}.
 *
 * MDMOID_DEV2_USB_INTERFACE 1181
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    status;	/**< ReadOnly */
    char *    alias;	/**< ReadWrite */
    char *    name;	/**< ReadOnly */
    UINT32    lastChange;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_LastChange;	/**< ReadWrite */
    char *    lowerLayers;	/**< ReadWrite */
    UBOOL8    upstream;	/**< ReadOnly */
    char *    MACAddress;	/**< ReadOnly */
} Dev2UsbInterfaceObject;

/*! \brief _Dev2UsbInterfaceObject is used internally to represent Dev2UsbInterfaceObject */
typedef Dev2UsbInterfaceObject _Dev2UsbInterfaceObject;



/*! \brief Obj struct for Device.USB.Interface.{i}.Stats.
 *
 * MDMOID_DEV2_USB_INTERFACE_STATS 1182
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT64    bytesSent;	/**< ReadOnly */
    UINT64    bytesReceived;	/**< ReadOnly */
    UINT64    packetsSent;	/**< ReadOnly */
    UINT64    packetsReceived;	/**< ReadOnly */
    UINT32    errorsSent;	/**< ReadOnly */
    UINT32    errorsReceived;	/**< ReadOnly */
    UINT64    unicastPacketsSent;	/**< ReadOnly */
    UINT64    unicastPacketsReceived;	/**< ReadOnly */
    UINT32    discardPacketsSent;	/**< ReadOnly */
    UINT32    discardPacketsReceived;	/**< ReadOnly */
    UINT64    X_BROADCOM_COM_MulticastBytesSent;	/**< ReadOnly */
    UINT64    X_BROADCOM_COM_MulticastBytesReceived;	/**< ReadOnly */
    UINT64    multicastPacketsSent;	/**< ReadOnly */
    UINT64    multicastPacketsReceived;	/**< ReadOnly */
    UINT64    broadcastPacketsSent;	/**< ReadOnly */
    UINT64    broadcastPacketsReceived;	/**< ReadOnly */
    UINT32    unknownProtoPacketsReceived;	/**< ReadOnly */
} Dev2UsbInterfaceStatsObject;

/*! \brief _Dev2UsbInterfaceStatsObject is used internally to represent Dev2UsbInterfaceStatsObject */
typedef Dev2UsbInterfaceStatsObject _Dev2UsbInterfaceStatsObject;



/*! \brief Obj struct for Device.USB.Port.{i}.
 *
 * MDMOID_DEV2_USB_PORT 1183
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
} Dev2UsbPortObject;

/*! \brief _Dev2UsbPortObject is used internally to represent Dev2UsbPortObject */
typedef Dev2UsbPortObject _Dev2UsbPortObject;



/*! \brief Obj struct for Device.USB.USBHosts.
 *
 * MDMOID_DEV2_USB_HOSTS 1184
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    hostNumberOfEntries;	/**< ReadOnly */
} Dev2UsbHostsObject;

/*! \brief _Dev2UsbHostsObject is used internally to represent Dev2UsbHostsObject */
typedef Dev2UsbHostsObject _Dev2UsbHostsObject;



/*! \brief Obj struct for Device.USB.USBHosts.Host.{i}.
 *
 * MDMOID_DEV2_USB_HOST 1185
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    alias;	/**< ReadWrite */
    UBOOL8    enable;	/**< ReadWrite */
    char *    name;	/**< ReadOnly */
    char *    type;	/**< ReadOnly */
    char *    USBVersion;	/**< ReadOnly */
    UINT32    deviceNumberOfEntries;	/**< ReadOnly */
} Dev2UsbHostObject;

/*! \brief _Dev2UsbHostObject is used internally to represent Dev2UsbHostObject */
typedef Dev2UsbHostObject _Dev2UsbHostObject;



/*! \brief Obj struct for Device.USB.USBHosts.Host.{i}.Device.{i}.
 *
 * MDMOID_DEV2_USB_HOST_DEVICE 1186
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    X_BROADCOM_COM_DeviceKey;	/**< ReadOnly */
    UINT32    deviceNumber;	/**< ReadOnly */
    char *    USBVersion;	/**< ReadOnly */
    HEXBINARY  deviceClass;	/**< ReadOnly */
    HEXBINARY  deviceSubClass;	/**< ReadOnly */
    UINT32    deviceVersion;	/**< ReadOnly */
    HEXBINARY  deviceProtocol;	/**< ReadOnly */
    UINT32    productID;	/**< ReadOnly */
    UINT32    vendorID;	/**< ReadOnly */
    char *    manufacturer;	/**< ReadOnly */
    char *    productClass;	/**< ReadOnly */
    char *    serialNumber;	/**< ReadOnly */
    UINT32    port;	/**< ReadOnly */
    char *    USBPort;	/**< ReadOnly */
    char *    rate;	/**< ReadOnly */
    char *    parent;	/**< ReadOnly */
    UINT32    maxChildren;	/**< ReadOnly */
#ifdef DMP_DEVICE2_USBHOSTSADV_1
    UBOOL8    isSelfPowered;	/**< ReadOnly */
#endif
#ifdef DMP_DEVICE2_USBHOSTSADV_1
    UINT32    configurationNumberOfEntries;	/**< ReadOnly */
#endif
} Dev2UsbHostDeviceObject;

/*! \brief _Dev2UsbHostDeviceObject is used internally to represent Dev2UsbHostDeviceObject */
typedef Dev2UsbHostDeviceObject _Dev2UsbHostDeviceObject;



/*! \brief Obj struct for Device.USB.USBHosts.Host.{i}.Device.{i}.Configuration.{i}.
 *
 * MDMOID_DEV2_USB_HOST_DEVICE_CONFIG 1187
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    configurationNumber;	/**< ReadOnly */
    UINT32    interfaceNumberOfEntries;	/**< ReadOnly */
} Dev2UsbHostDeviceConfigObject;

/*! \brief _Dev2UsbHostDeviceConfigObject is used internally to represent Dev2UsbHostDeviceConfigObject */
typedef Dev2UsbHostDeviceConfigObject _Dev2UsbHostDeviceConfigObject;



/*! \brief Obj struct for Device.USB.USBHosts.Host.{i}.Device.{i}.Configuration.{i}.Interface.{i}.
 *
 * MDMOID_DEV2_USB_HOST_DEVICE_CONFIG_IFC 1188
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    interfaceNumber;	/**< ReadOnly */
    HEXBINARY  interfaceClass;	/**< ReadOnly */
    HEXBINARY  interfaceSubClass;	/**< ReadOnly */
    HEXBINARY  interfaceProtocol;	/**< ReadOnly */
} Dev2UsbHostDeviceConfigIfcObject;

/*! \brief _Dev2UsbHostDeviceConfigIfcObject is used internally to represent Dev2UsbHostDeviceConfigIfcObject */
typedef Dev2UsbHostDeviceConfigIfcObject _Dev2UsbHostDeviceConfigIfcObject;



/*! \brief Obj struct for Device.WiFi.
 *
 * MDMOID_DEV2_WIFI 2600
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    radioNumberOfEntries;	/**< ReadOnly */
#ifdef DMP_DEVICE2_WIFISSID_1
    UINT32    SSIDNumberOfEntries;	/**< ReadOnly */
#endif
#ifdef DMP_DEVICE2_WIFIACCESSPOINT_1
    UINT32    accessPointNumberOfEntries;	/**< ReadOnly */
#endif
#ifdef DMP_DEVICE2_WIFIENDPOINT_1
    UINT32    endPointNumberOfEntries;	/**< ReadOnly */
#endif
    char *    X_BROADCOM_COM_WlNvram;	/**< ReadWrite */
    char *    X_BROADCOM_COM_WlUnsetNvram;	/**< ReadWrite */
} Dev2WifiObject;

/*! \brief _Dev2WifiObject is used internally to represent Dev2WifiObject */
typedef Dev2WifiObject _Dev2WifiObject;



/*! \brief Obj struct for Device.WiFi.X_BROADCOM_COM_AFC.
 *
 * MDMOID_DEV2_WIFI_AFC_CFG 3400
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
} Dev2WifiAfcCfgObject;

/*! \brief _Dev2WifiAfcCfgObject is used internally to represent Dev2WifiAfcCfgObject */
typedef Dev2WifiAfcCfgObject _Dev2WifiAfcCfgObject;



/*! \brief Obj struct for Device.WiFi.X_BROADCOM_COM_AFC.LocPolDaemon.
 *
 * MDMOID_DEV2_WIFI_LOC_POL_DAEMON 3401
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    operatingMode;	/**< ReadWrite */
    char *    ipcType;	/**< ReadWrite */
    char *    cmdPath;	/**< ReadWrite */
    UINT32    timeout;	/**< ReadWrite */
    char *    debugLevel;	/**< ReadWrite */
} Dev2WifiLocPolDaemonObject;

/*! \brief _Dev2WifiLocPolDaemonObject is used internally to represent Dev2WifiLocPolDaemonObject */
typedef Dev2WifiLocPolDaemonObject _Dev2WifiLocPolDaemonObject;



/*! \brief Obj struct for Device.WiFi.X_BROADCOM_COM_AFC.AfcClientDaemon.
 *
 * MDMOID_DEV2_WIFI_AFC_CLIENT_DAEMON 3402
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    debugLevel;	/**< ReadWrite */
} Dev2WifiAfcClientDaemonObject;

/*! \brief _Dev2WifiAfcClientDaemonObject is used internally to represent Dev2WifiAfcClientDaemonObject */
typedef Dev2WifiAfcClientDaemonObject _Dev2WifiAfcClientDaemonObject;



/*! \brief Obj struct for Device.WiFi.X_BROADCOM_COM_AFC.MobAppDaemon.
 *
 * MDMOID_DEV2_WIFI_MOB_DAEMON 3403
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    ipcType;	/**< ReadWrite */
    char *    cmdPath;	/**< ReadWrite */
    UINT32    timeout;	/**< ReadWrite */
    char *    debugLevel;	/**< ReadWrite */
} Dev2WifiMobDaemonObject;

/*! \brief _Dev2WifiMobDaemonObject is used internally to represent Dev2WifiMobDaemonObject */
typedef Dev2WifiMobDaemonObject _Dev2WifiMobDaemonObject;



/*! \brief Obj struct for Device.WiFi.X_BROADCOM_COM_AFC.MobAppDaemon.Pairings.
 *
 * MDMOID_DEV2_WIFI_MOB_PAIRING 3404
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    maxNumPairedApp;	/**< ReadWrite */
    char *    DB;	/**< ReadWrite */
} Dev2WifiMobPairingObject;

/*! \brief _Dev2WifiMobPairingObject is used internally to represent Dev2WifiMobPairingObject */
typedef Dev2WifiMobPairingObject _Dev2WifiMobPairingObject;



/*! \brief Obj struct for Device.WiFi.X_BROADCOM_COM_AFC.MobAppDaemon.Discovery.
 *
 * MDMOID_DEV2_WIFI_MOB_DISCOVERY 3405
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    SSDPPort;	/**< ReadWrite */
} Dev2WifiMobDiscoveryObject;

/*! \brief _Dev2WifiMobDiscoveryObject is used internally to represent Dev2WifiMobDiscoveryObject */
typedef Dev2WifiMobDiscoveryObject _Dev2WifiMobDiscoveryObject;



/*! \brief Obj struct for Device.WiFi.X_BROADCOM_COM_AFC.MobAppDaemon.HttpServer.
 *
 * MDMOID_DEV2_WIFI_MOB_HTTP_SERVER 3406
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    port;	/**< ReadWrite */
    char *    cert;	/**< ReadWrite */
    char *    privateKey;	/**< ReadWrite */
} Dev2WifiMobHttpServerObject;

/*! \brief _Dev2WifiMobHttpServerObject is used internally to represent Dev2WifiMobHttpServerObject */
typedef Dev2WifiMobHttpServerObject _Dev2WifiMobHttpServerObject;



/*! \brief Obj struct for Device.WiFi.X_BROADCOM_COM_AFC.MobAppDaemon.HttpClient.
 *
 * MDMOID_DEV2_WIFI_MOB_HTTP_CLIENT 3407
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    trustedCA;	/**< ReadWrite */
} Dev2WifiMobHttpClientObject;

/*! \brief _Dev2WifiMobHttpClientObject is used internally to represent Dev2WifiMobHttpClientObject */
typedef Dev2WifiMobHttpClientObject _Dev2WifiMobHttpClientObject;



/*! \brief Obj struct for Device.WiFi.X_BROADCOM_COM_AFC.MobAppDaemon.CloudMessaging.
 *
 * MDMOID_DEV2_WIFI_MOB_CLOUD_MESSAGING 3408
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    firebaseId;	/**< ReadWrite */
    char *    firebasePrivateKey;	/**< ReadWrite */
    char *    FCMServiceAddress;	/**< ReadWrite */
} Dev2WifiMobCloudMessagingObject;

/*! \brief _Dev2WifiMobCloudMessagingObject is used internally to represent Dev2WifiMobCloudMessagingObject */
typedef Dev2WifiMobCloudMessagingObject _Dev2WifiMobCloudMessagingObject;



/*! \brief Obj struct for Device.WiFi.X_BROADCOM_COM_AFC.MobAppDaemon.App.
 *
 * MDMOID_DEV2_WIFI_MOB_APP 3409
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
} Dev2WifiMobAppObject;

/*! \brief _Dev2WifiMobAppObject is used internally to represent Dev2WifiMobAppObject */
typedef Dev2WifiMobAppObject _Dev2WifiMobAppObject;



/*! \brief Obj struct for Device.WiFi.X_BROADCOM_COM_AFC.MobAppDaemon.App.Ios.
 *
 * MDMOID_DEV2_WIFI_MOB_APP_IOS 3410
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    iosAppID;	/**< ReadWrite */
} Dev2WifiMobAppIosObject;

/*! \brief _Dev2WifiMobAppIosObject is used internally to represent Dev2WifiMobAppIosObject */
typedef Dev2WifiMobAppIosObject _Dev2WifiMobAppIosObject;



/*! \brief Obj struct for Device.WiFi.X_BROADCOM_COM_AFC.MobAppDaemon.App.Android.
 *
 * MDMOID_DEV2_WIFI_MOB_APP_ANDROID 3411
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    androidAppPackageName;	/**< ReadWrite */
    char *    playServerAddress;	/**< ReadWrite */
    char *    playAttestationSecret;	/**< ReadWrite */
    char *    integrityDecryptionKey;	/**< ReadWrite */
    char *    integrityVerificationKey;	/**< ReadWrite */
} Dev2WifiMobAppAndroidObject;

/*! \brief _Dev2WifiMobAppAndroidObject is used internally to represent Dev2WifiMobAppAndroidObject */
typedef Dev2WifiMobAppAndroidObject _Dev2WifiMobAppAndroidObject;



/*! \brief Obj struct for Device.WiFi.DataElements.
 *
 * MDMOID_DEV2_DATA_ELEMENTS 2601
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
} Dev2DataElementsObject;

/*! \brief _Dev2DataElementsObject is used internally to represent Dev2DataElementsObject */
typedef Dev2DataElementsObject _Dev2DataElementsObject;



/*! \brief Obj struct for Device.WiFi.DataElements.Network.
 *
 * MDMOID_DEV2_DATA_ELM_NETWORK 2602
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    ID;	/**< ReadWrite */
    char *    timeStamp;	/**< ReadOnly */
    char *    controllerID;	/**< ReadWrite */
    UINT32    deviceNumberOfEntries;	/**< ReadOnly */
    UINT32    SCSDisallowedStaList;	/**< ReadOnly */
    UINT32    SSIDNumberOfEntries;	/**< ReadOnly */
} Dev2DataElmNetworkObject;

/*! \brief _Dev2DataElmNetworkObject is used internally to represent Dev2DataElmNetworkObject */
typedef Dev2DataElmNetworkObject _Dev2DataElmNetworkObject;



/*! \brief Obj struct for Device.WiFi.DataElements.Network.SSID.{i}.
 *
 * MDMOID_DEV2_DATA_ELM_NETWORK_SSID 2603
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    SSID;	/**< ReadOnly */
    char *    band;	/**< ReadOnly */
} Dev2DataElmNetworkSsidObject;

/*! \brief _Dev2DataElmNetworkSsidObject is used internally to represent Dev2DataElmNetworkSsidObject */
typedef Dev2DataElmNetworkSsidObject _Dev2DataElmNetworkSsidObject;



/*! \brief Obj struct for Device.WiFi.DataElements.Network.MultiAPSteeringSummaryStats.
 *
 * MDMOID_DEV2_DATA_ELM_MULTIAPSTEERINGSUMMARY 2604
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT64    noCandidateAPFailures;	/**< ReadOnly */
    UINT64    blacklistAttempts;	/**< ReadOnly */
    UINT64    blacklistSuccesses;	/**< ReadOnly */
    UINT64    blacklistFailures;	/**< ReadOnly */
    UINT64    BTMAttempts;	/**< ReadOnly */
    UINT64    BTMSuccesses;	/**< ReadOnly */
    UINT64    BTMFailures;	/**< ReadOnly */
    UINT64    BTMQueryResponses;	/**< ReadOnly */
} Dev2DataElmMultiapsteeringsummaryObject;

/*! \brief _Dev2DataElmMultiapsteeringsummaryObject is used internally to represent Dev2DataElmMultiapsteeringsummaryObject */
typedef Dev2DataElmMultiapsteeringsummaryObject _Dev2DataElmMultiapsteeringsummaryObject;



/*! \brief Obj struct for Device.WiFi.DataElements.Network.Device.{i}.
 *
 * MDMOID_DEV2_DATA_ELM_DEVICE 2605
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    ID;	/**< ReadWrite */
    BASE64    multiAPCapabilities;	/**< ReadOnly */
    UINT32    collectionInterval;	/**< ReadOnly */
    UBOOL8    reportUnsuccessfulAssociations;	/**< ReadWrite */
    UINT32    maxReportingRate;	/**< ReadOnly */
    UINT32    APMetricsReportingInterval;	/**< ReadOnly */
    char *    manufacturer;	/**< ReadOnly */
    char *    serialNumber;	/**< ReadOnly */
    char *    manufacturerModel;	/**< ReadOnly */
    char *    softwareVersion;	/**< ReadOnly */
    char *    executionEnv;	/**< ReadOnly */
    HEXBINARY  DSCPMap;	/**< ReadOnly */
    UINT32    maxPrioritizationRules;	/**< ReadOnly */
    UBOOL8    prioritizationSupport;	/**< ReadOnly */
    UINT32    maxVIDs;	/**< ReadOnly */
    UBOOL8    APMetricsWiFi6;	/**< ReadOnly */
    char *    countryCode;	/**< ReadOnly */
    char *    localSteeringDisallowedSTAList;	/**< ReadOnly */
    char *    BTMSteeringDisallowedSTAList;	/**< ReadOnly */
    UBOOL8    DFSEnable;	/**< ReadOnly */
    UBOOL8    reportIndependentScans;	/**< ReadOnly */
    UBOOL8    associatedSTAinAPMetricsWiFi6;	/**< ReadOnly */
    UINT32    maxUnsuccessfulAssociationReportingRate;	/**< ReadOnly */
    UBOOL8    STASteeringState;	/**< ReadOnly */
    UBOOL8    coordinatedCACAllowed;	/**< ReadOnly */
    UBOOL8    trafficSeparationAllowed;	/**< ReadOnly */
    UBOOL8    servicePrioritizationAllowed;	/**< ReadOnly */
    UINT32    radioNumberOfEntries;	/**< ReadOnly */
    UINT32    default8021QNumberOfEntries;	/**< ReadOnly */
    UINT32    SSIDtoVIDMappingNumberOfEntries;	/**< ReadOnly */
    UINT32    CACStatusNumberOfEntries;	/**< ReadOnly */
    UINT32    IEEE1905SecurityNumberOfEntries;	/**< ReadOnly */
    UINT32    SPRuleNumberOfEntries;	/**< ReadOnly */
    UINT32    anticipatedChannelsNumberOfEntries;	/**< ReadOnly */
    UINT32    anticipatedChannelUsageNumberOfEntries;	/**< ReadOnly */
} Dev2DataElmDeviceObject;

/*! \brief _Dev2DataElmDeviceObject is used internally to represent Dev2DataElmDeviceObject */
typedef Dev2DataElmDeviceObject _Dev2DataElmDeviceObject;



/*! \brief Obj struct for Device.WiFi.DataElements.Network.Device.{i}.Default8021Q.{i}.
 *
 * MDMOID_DEV2_DATA_ELM_DEVICE_DEFAULT8021Q 2606
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    UINT32    primaryVID;	/**< ReadWrite */
    UINT32    defaultPCP;	/**< ReadWrite */
} Dev2DataElmDeviceDefault8021qObject;

/*! \brief _Dev2DataElmDeviceDefault8021qObject is used internally to represent Dev2DataElmDeviceDefault8021qObject */
typedef Dev2DataElmDeviceDefault8021qObject _Dev2DataElmDeviceDefault8021qObject;



/*! \brief Obj struct for Device.WiFi.DataElements.Network.Device.{i}.SSIDtoVIDMapping.{i}.
 *
 * MDMOID_DEV2_DATA_ELM_DEVICE_SSIDTOVIDMAPPING 2607
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    SSID;	/**< ReadOnly */
    UINT32    VID;	/**< ReadOnly */
} Dev2DataElmDeviceSsidtovidmappingObject;

/*! \brief _Dev2DataElmDeviceSsidtovidmappingObject is used internally to represent Dev2DataElmDeviceSsidtovidmappingObject */
typedef Dev2DataElmDeviceSsidtovidmappingObject _Dev2DataElmDeviceSsidtovidmappingObject;



/*! \brief Obj struct for Device.WiFi.DataElements.Network.Device.{i}.CACStatus.{i}.
 *
 * MDMOID_DEV2_DATA_ELM_CACSTATUS 2608
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    DATETIME  timeStamp;	/**< ReadOnly */
    UINT32    CACAvailableChannelNumberOfEntries;	/**< ReadOnly */
    UINT32    CACNonOccupancyChannelNumberOfEntries;	/**< ReadOnly */
    UINT32    CACActiveChannelNumberOfEntries;	/**< ReadOnly */
} Dev2DataElmCacstatusObject;

/*! \brief _Dev2DataElmCacstatusObject is used internally to represent Dev2DataElmCacstatusObject */
typedef Dev2DataElmCacstatusObject _Dev2DataElmCacstatusObject;



/*! \brief Obj struct for Device.WiFi.DataElements.Network.Device.{i}.CACStatus.{i}.CACAvailableChannel.{i}.
 *
 * MDMOID_DEV2_DATA_ELM_CACSTATUS_AVAILABLECHANNEL 2609
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    opClass;	/**< ReadOnly */
    UINT32    channel;	/**< ReadOnly */
    UINT32    minutes;	/**< ReadOnly */
} Dev2DataElmCacstatusAvailablechannelObject;

/*! \brief _Dev2DataElmCacstatusAvailablechannelObject is used internally to represent Dev2DataElmCacstatusAvailablechannelObject */
typedef Dev2DataElmCacstatusAvailablechannelObject _Dev2DataElmCacstatusAvailablechannelObject;



/*! \brief Obj struct for Device.WiFi.DataElements.Network.Device.{i}.CACStatus.{i}.CACNonOccupancyChannel.{i}.
 *
 * MDMOID_DEV2_DATA_ELM_CACSTATUS_NONOCCUPANCYCHANNEL 2610
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    opClass;	/**< ReadOnly */
    UINT32    channel;	/**< ReadOnly */
    UINT32    seconds;	/**< ReadOnly */
} Dev2DataElmCacstatusNonoccupancychannelObject;

/*! \brief _Dev2DataElmCacstatusNonoccupancychannelObject is used internally to represent Dev2DataElmCacstatusNonoccupancychannelObject */
typedef Dev2DataElmCacstatusNonoccupancychannelObject _Dev2DataElmCacstatusNonoccupancychannelObject;



/*! \brief Obj struct for Device.WiFi.DataElements.Network.Device.{i}.CACStatus.{i}.CACActiveChannel.{i}.
 *
 * MDMOID_DEV2_DATA_ELM_CACSTATUS_ACTIVECHANNEL 2611
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    opClass;	/**< ReadOnly */
    UINT32    channel;	/**< ReadOnly */
    UINT32    countdown;	/**< ReadOnly */
} Dev2DataElmCacstatusActivechannelObject;

/*! \brief _Dev2DataElmCacstatusActivechannelObject is used internally to represent Dev2DataElmCacstatusActivechannelObject */
typedef Dev2DataElmCacstatusActivechannelObject _Dev2DataElmCacstatusActivechannelObject;



/*! \brief Obj struct for Device.WiFi.DataElements.Network.Device.{i}.SPRule.{i}.
 *
 * MDMOID_DEV2_DATA_ELM_DEVICE_SPRULE 2612
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    ID;	/**< ReadOnly */
    UINT32    precedence;	/**< ReadOnly */
    UINT32    output;	/**< ReadOnly */
    UBOOL8    alwaysMatch;	/**< ReadOnly */
} Dev2DataElmDeviceSpruleObject;

/*! \brief _Dev2DataElmDeviceSpruleObject is used internally to represent Dev2DataElmDeviceSpruleObject */
typedef Dev2DataElmDeviceSpruleObject _Dev2DataElmDeviceSpruleObject;



/*! \brief Obj struct for Device.WiFi.DataElements.Network.Device.{i}.IEEE1905Security.{i}.
 *
 * MDMOID_DEV2_DATA_ELM_DEVICE_IEEE1905SECURITY 2613
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    onboardingProtocol;	/**< ReadOnly */
    UINT32    integrityAlgorithm;	/**< ReadOnly */
    UINT32    encryptionAlgorithm;	/**< ReadOnly */
} Dev2DataElmDeviceIeee1905securityObject;

/*! \brief _Dev2DataElmDeviceIeee1905securityObject is used internally to represent Dev2DataElmDeviceIeee1905securityObject */
typedef Dev2DataElmDeviceIeee1905securityObject _Dev2DataElmDeviceIeee1905securityObject;



/*! \brief Obj struct for Device.WiFi.DataElements.Network.Device.{i}.AnticipatedChannels.{i}.
 *
 * MDMOID_DEV2_DATA_ELM_ANTICIPATEDCHANNELS 2614
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    opClass;	/**< ReadOnly */
    char *    channelList;	/**< ReadOnly */
} Dev2DataElmAnticipatedchannelsObject;

/*! \brief _Dev2DataElmAnticipatedchannelsObject is used internally to represent Dev2DataElmAnticipatedchannelsObject */
typedef Dev2DataElmAnticipatedchannelsObject _Dev2DataElmAnticipatedchannelsObject;



/*! \brief Obj struct for Device.WiFi.DataElements.Network.Device.{i}.AnticipatedChannelUsage.{i}.
 *
 * MDMOID_DEV2_DATA_ELM_ANTICIPATEDCHANNELUSAGE 2615
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    opClass;	/**< ReadOnly */
    UINT32    channel;	/**< ReadOnly */
    char *    referenceBSSID;	/**< ReadOnly */
    UINT32    entryNumberOfEntries;	/**< ReadOnly */
} Dev2DataElmAnticipatedchannelusageObject;

/*! \brief _Dev2DataElmAnticipatedchannelusageObject is used internally to represent Dev2DataElmAnticipatedchannelusageObject */
typedef Dev2DataElmAnticipatedchannelusageObject _Dev2DataElmAnticipatedchannelusageObject;



/*! \brief Obj struct for Device.WiFi.DataElements.Network.Device.{i}.AnticipatedChannelUsage.{i}.Entry.{i}.
 *
 * MDMOID_DEV2_DATA_ELM_ANTICIPATEDCHANNELUSAGE_ENTRY 2616
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    HEXBINARY  burstStartTime;	/**< ReadOnly */
    UINT32    burstLength;	/**< ReadOnly */
    UINT32    repetitions;	/**< ReadOnly */
    UINT32    burstInterval;	/**< ReadOnly */
    HEXBINARY  RUBitmask;	/**< ReadOnly */
    char *    transmitterIdentifier;	/**< ReadOnly */
    SINT32    powerLevel;	/**< ReadOnly */
    char *    channelUsageReason;	/**< ReadOnly */
} Dev2DataElmAnticipatedchannelusageEntryObject;

/*! \brief _Dev2DataElmAnticipatedchannelusageEntryObject is used internally to represent Dev2DataElmAnticipatedchannelusageEntryObject */
typedef Dev2DataElmAnticipatedchannelusageEntryObject _Dev2DataElmAnticipatedchannelusageEntryObject;



/*! \brief Obj struct for Device.WiFi.DataElements.Network.Device.{i}.MultiAPDevice.
 *
 * MDMOID_DEV2_DATA_ELM_MULTIAPDEVICE 2617
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    manufacturerOUI;	/**< ReadOnly */
    DATETIME  lastContactTime;	/**< ReadOnly */
    char *    assocIEEE1905DeviceRef;	/**< ReadOnly */
    char *    easyMeshControllerOperationMode;	/**< ReadOnly */
    char *    easyMeshAgentOperationMode;	/**< ReadOnly */
} Dev2DataElmMultiapdeviceObject;

/*! \brief _Dev2DataElmMultiapdeviceObject is used internally to represent Dev2DataElmMultiapdeviceObject */
typedef Dev2DataElmMultiapdeviceObject _Dev2DataElmMultiapdeviceObject;



/*! \brief Obj struct for Device.WiFi.DataElements.Network.Device.{i}.MultiAPDevice.Backhaul.
 *
 * MDMOID_DEV2_DATA_ELM_MULTIAPDEVICE_BACKHAUL 2618
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    linkType;	/**< ReadOnly */
    char *    backhaulMACAddress;	/**< ReadOnly */
    char *    backhaulDeviceID;	/**< ReadOnly */
    char *    MACAddress;	/**< ReadOnly */
    UINT32    currentOperatingClassProfileNumberOfEntries;	/**< ReadOnly */
} Dev2DataElmMultiapdeviceBackhaulObject;

/*! \brief _Dev2DataElmMultiapdeviceBackhaulObject is used internally to represent Dev2DataElmMultiapdeviceBackhaulObject */
typedef Dev2DataElmMultiapdeviceBackhaulObject _Dev2DataElmMultiapdeviceBackhaulObject;



/*! \brief Obj struct for Device.WiFi.DataElements.Network.Device.{i}.MultiAPDevice.Backhaul.CurrentOperatingClassProfile.{i}.
 *
 * MDMOID_DEV2_DATA_ELM_MULTIAPDEVICE_BACKHAUL_CURR_OPERTCLASSPROFILE 2619
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    CLASS;	/**< ReadOnly */
    UINT32    channel;	/**< ReadOnly */
    SINT32    txPower;	/**< ReadOnly */
    DATETIME  timeStamp;	/**< ReadOnly */
} Dev2DataElmMultiapdeviceBackhaulCurrOpertclassprofileObject;

/*! \brief _Dev2DataElmMultiapdeviceBackhaulCurrOpertclassprofileObject is used internally to represent Dev2DataElmMultiapdeviceBackhaulCurrOpertclassprofileObject */
typedef Dev2DataElmMultiapdeviceBackhaulCurrOpertclassprofileObject _Dev2DataElmMultiapdeviceBackhaulCurrOpertclassprofileObject;



/*! \brief Obj struct for Device.WiFi.DataElements.Network.Device.{i}.MultiAPDevice.Backhaul.Stats.
 *
 * MDMOID_DEV2_DATA_ELM_MULTIAPDEVICE_BACKHAUL_STATS 2620
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT64    bytesSent;	/**< ReadOnly */
    UINT64    bytesReceived;	/**< ReadOnly */
    UINT64    packetsSent;	/**< ReadOnly */
    UINT64    packetsReceived;	/**< ReadOnly */
    UINT64    errorsSent;	/**< ReadOnly */
    UINT64    errorsReceived;	/**< ReadOnly */
    UINT32    linkUtilization;	/**< ReadOnly */
    UINT32    signalStrength;	/**< ReadOnly */
    UINT32    lastDataDownlinkRate;	/**< ReadOnly */
    UINT32    lastDataUplinkRate;	/**< ReadOnly */
    DATETIME  timeStamp;	/**< ReadOnly */
} Dev2DataElmMultiapdeviceBackhaulStatsObject;

/*! \brief _Dev2DataElmMultiapdeviceBackhaulStatsObject is used internally to represent Dev2DataElmMultiapdeviceBackhaulStatsObject */
typedef Dev2DataElmMultiapdeviceBackhaulStatsObject _Dev2DataElmMultiapdeviceBackhaulStatsObject;



/*! \brief Obj struct for Device.WiFi.DataElements.Network.Device.{i}.Radio.{i}.
 *
 * MDMOID_DEV2_DATA_ELM_RADIO 2621
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    BASE64    ID;	/**< ReadOnly */
    UBOOL8    enabled;	/**< ReadOnly */
    UINT32    noise;	/**< ReadOnly */
    UINT32    utilization;	/**< ReadOnly */
    UINT32    transmit;	/**< ReadOnly */
    UINT32    receiveSelf;	/**< ReadOnly */
    UINT32    receiveOther;	/**< ReadOnly */
    UBOOL8    trafficSeparationCombinedFronthaul;	/**< ReadOnly */
    UBOOL8    trafficSeparationCombinedBackhaul;	/**< ReadOnly */
    UINT32    steeringPolicy;	/**< ReadWrite */
    UINT32    channelUtilizationThreshold;	/**< ReadWrite */
    UINT32    RCPISteeringThreshold;	/**< ReadWrite */
    UINT32    STAReportingRCPIThreshold;	/**< ReadWrite */
    UINT32    STAReportingRCPIHysteresisMarginOverride;	/**< ReadWrite */
    UINT32    channelUtilizationReportingThreshold;	/**< ReadWrite */
    UBOOL8    associatedSTATrafficStatsInclusionPolicy;	/**< ReadWrite */
    UBOOL8    associatedSTALinkMetricsInclusionPolicy;	/**< ReadWrite */
    char *    chipsetVendor;	/**< ReadOnly */
    UBOOL8    APMetricsWiFi6;	/**< ReadOnly */
    UINT32    currentOperatingClassProfileNumberOfEntries;	/**< ReadOnly */
    UINT32    unassociatedSTANumberOfEntries;	/**< ReadOnly */
    UINT32    BSSNumberOfEntries;	/**< ReadOnly */
    UINT32    scanResultNumberOfEntries;	/**< ReadOnly */
    UINT32    disAllowedOpClassChannelsNumberOfEntries;	/**< ReadOnly */
} Dev2DataElmRadioObject;

/*! \brief _Dev2DataElmRadioObject is used internally to represent Dev2DataElmRadioObject */
typedef Dev2DataElmRadioObject _Dev2DataElmRadioObject;



/*! \brief Obj struct for Device.WiFi.DataElements.Network.Device.{i}.Radio.{i}.ScanResult.{i}.
 *
 * MDMOID_DEV2_DATA_ELM_SCAN_RESULT 2622
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    timeStamp;	/**< ReadOnly */
    UINT32    opClassScanNumberOfEntries;	/**< ReadOnly */
} Dev2DataElmScanResultObject;

/*! \brief _Dev2DataElmScanResultObject is used internally to represent Dev2DataElmScanResultObject */
typedef Dev2DataElmScanResultObject _Dev2DataElmScanResultObject;



/*! \brief Obj struct for Device.WiFi.DataElements.Network.Device.{i}.Radio.{i}.ScanResult.{i}.OpClassScan.{i}.
 *
 * MDMOID_DEV2_DATA_ELM_OP_CLASS_SCAN 2623
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    operatingClass;	/**< ReadOnly */
    UINT32    channelScanNumberOfEntries;	/**< ReadOnly */
} Dev2DataElmOpClassScanObject;

/*! \brief _Dev2DataElmOpClassScanObject is used internally to represent Dev2DataElmOpClassScanObject */
typedef Dev2DataElmOpClassScanObject _Dev2DataElmOpClassScanObject;



/*! \brief Obj struct for Device.WiFi.DataElements.Network.Device.{i}.Radio.{i}.ScanResult.{i}.OpClassScan.{i}.ChannelScan.{i}.
 *
 * MDMOID_DEV2_DATA_ELM_CHANNEL_SCAN 2624
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    channel;	/**< ReadOnly */
    char *    timeStamp;	/**< ReadOnly */
    UINT32    utilization;	/**< ReadOnly */
    UINT32    noise;	/**< ReadOnly */
    UINT32    neighborBSSNumberOfEntries;	/**< ReadOnly */
} Dev2DataElmChannelScanObject;

/*! \brief _Dev2DataElmChannelScanObject is used internally to represent Dev2DataElmChannelScanObject */
typedef Dev2DataElmChannelScanObject _Dev2DataElmChannelScanObject;



/*! \brief Obj struct for Device.WiFi.DataElements.Network.Device.{i}.Radio.{i}.ScanResult.{i}.OpClassScan.{i}.ChannelScan.{i}.NeighborBSS.{i}.
 *
 * MDMOID_BS_S 2625
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    BSSID;	/**< ReadOnly */
    char *    SSID;	/**< ReadOnly */
    UINT32    signalStrength;	/**< ReadOnly */
    char *    channelBandwidth;	/**< ReadOnly */
    UINT32    channelUtilization;	/**< ReadOnly */
    UINT32    stationCount;	/**< ReadOnly */
} Dev2DataElmNeighborBSSObject;

/*! \brief _Dev2DataElmNeighborBSSObject is used internally to represent Dev2DataElmNeighborBSSObject */
typedef Dev2DataElmNeighborBSSObject _Dev2DataElmNeighborBSSObject;



/*! \brief Obj struct for Device.WiFi.DataElements.Network.Device.{i}.Radio.{i}.BackhaulSta.
 *
 * MDMOID_DEV2_DATA_ELM_BACKHAUL_STA 2626
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    MACAddress;	/**< ReadOnly */
} Dev2DataElmBackhaulStaObject;

/*! \brief _Dev2DataElmBackhaulStaObject is used internally to represent Dev2DataElmBackhaulStaObject */
typedef Dev2DataElmBackhaulStaObject _Dev2DataElmBackhaulStaObject;



/*! \brief Obj struct for Device.WiFi.DataElements.Network.Device.{i}.Radio.{i}.ScanCapability.
 *
 * MDMOID_DEV2_DATA_ELM_RADIO_SCAN_CAPABLE 2627
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    onBootOnly;	/**< ReadOnly */
    UINT32    impact;	/**< ReadOnly */
    UINT32    minimumInterval;	/**< ReadOnly */
    UINT32    opClassChannelsNumberOfEntries;	/**< ReadOnly */
} Dev2DataElmRadioScanCapableObject;

/*! \brief _Dev2DataElmRadioScanCapableObject is used internally to represent Dev2DataElmRadioScanCapableObject */
typedef Dev2DataElmRadioScanCapableObject _Dev2DataElmRadioScanCapableObject;



/*! \brief Obj struct for Device.WiFi.DataElements.Network.Device.{i}.Radio.{i}.ScanCapability.OpClassChannels.{i}.
 *
 * MDMOID_DEV2_DATA_ELM_RADIO_SCAN_CAPABLE_OPCLASSCHANNELS 2628
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    opClass;	/**< ReadOnly */
    char *    channelList;	/**< ReadOnly */
} Dev2DataElmRadioScanCapableOpclasschannelsObject;

/*! \brief _Dev2DataElmRadioScanCapableOpclasschannelsObject is used internally to represent Dev2DataElmRadioScanCapableOpclasschannelsObject */
typedef Dev2DataElmRadioScanCapableOpclasschannelsObject _Dev2DataElmRadioScanCapableOpclasschannelsObject;



/*! \brief Obj struct for Device.WiFi.DataElements.Network.Device.{i}.Radio.{i}.CACCapability.
 *
 * MDMOID_DEV2_DATA_ELM_RADIO_CAC_CAPABLE 2629
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    CACMethodNumberOfEntries;	/**< ReadOnly */
} Dev2DataElmRadioCacCapableObject;

/*! \brief _Dev2DataElmRadioCacCapableObject is used internally to represent Dev2DataElmRadioCacCapableObject */
typedef Dev2DataElmRadioCacCapableObject _Dev2DataElmRadioCacCapableObject;



/*! \brief Obj struct for Device.WiFi.DataElements.Network.Device.{i}.Radio.{i}.CACCapability.CACMethod.{i}.
 *
 * MDMOID_DEV2_DATA_ELM_RADIO_CAC_CAPABLE_CACMETHOD 2630
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    method;	/**< ReadOnly */
    UINT32    numberOfSeconds;	/**< ReadOnly */
    UINT32    opClassChannelsNumberOfEntries;	/**< ReadOnly */
} Dev2DataElmRadioCacCapableCacmethodObject;

/*! \brief _Dev2DataElmRadioCacCapableCacmethodObject is used internally to represent Dev2DataElmRadioCacCapableCacmethodObject */
typedef Dev2DataElmRadioCacCapableCacmethodObject _Dev2DataElmRadioCacCapableCacmethodObject;



/*! \brief Obj struct for Device.WiFi.DataElements.Network.Device.{i}.Radio.{i}.CACCapability.CACMethod.{i}.OpClassChannels.{i}.
 *
 * MDMOID_DEV2_DATA_ELM_RADIO_CAC_CAPABLE_CACMETHOD_OPCLASSCHANNELS 2631
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    opClass;	/**< ReadOnly */
    char *    channelList;	/**< ReadOnly */
} Dev2DataElmRadioCacCapableCacmethodOpclasschannelsObject;

/*! \brief _Dev2DataElmRadioCacCapableCacmethodOpclasschannelsObject is used internally to represent Dev2DataElmRadioCacCapableCacmethodOpclasschannelsObject */
typedef Dev2DataElmRadioCacCapableCacmethodOpclasschannelsObject _Dev2DataElmRadioCacCapableCacmethodOpclasschannelsObject;



/*! \brief Obj struct for Device.WiFi.DataElements.Network.Device.{i}.Radio.{i}.Capabilities.
 *
 * MDMOID_DEV2_DATA_ELM_CAPABILITIES 2632
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    BASE64    HTCapabilities;	/**< ReadOnly */
    BASE64    VHTCapabilities;	/**< ReadOnly */
    BASE64    HECapabilities;	/**< ReadOnly */
    UINT32    capableOperatingClassProfileNumberOfEntries;	/**< ReadOnly */
    UINT32    AKMFrontHaulNumberOfEntries;	/**< ReadOnly */
    UINT32    AKMBackhaulNumberOfEntries;	/**< ReadOnly */
} Dev2DataElmCapabilitiesObject;

/*! \brief _Dev2DataElmCapabilitiesObject is used internally to represent Dev2DataElmCapabilitiesObject */
typedef Dev2DataElmCapabilitiesObject _Dev2DataElmCapabilitiesObject;



/*! \brief Obj struct for Device.WiFi.DataElements.Network.Device.{i}.Radio.{i}.Capabilities.WiFi6APRole.
 *
 * MDMOID_DEV2_DATA_ELM_CAPABLE_WIFI6APROLE 2633
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    HE160;	/**< ReadOnly */
    UBOOL8    HE8080;	/**< ReadOnly */
    BASE64    MCSNSS;	/**< ReadOnly */
    UBOOL8    SUBeamformer;	/**< ReadOnly */
    UBOOL8    SUBeamformee;	/**< ReadOnly */
    UBOOL8    MUBeamformer;	/**< ReadOnly */
    UBOOL8    beamformee80orLess;	/**< ReadOnly */
    UBOOL8    beamformeeAbove80;	/**< ReadOnly */
    UBOOL8    ULMUMIMO;	/**< ReadOnly */
    UBOOL8    ULOFDMA;	/**< ReadOnly */
    UINT32    maxDLMUMIMO;	/**< ReadOnly */
    UINT32    maxULMUMIMO;	/**< ReadOnly */
    UINT32    maxDLOFDMA;	/**< ReadOnly */
    UINT32    maxULOFDMA;	/**< ReadOnly */
    UBOOL8    RTS;	/**< ReadOnly */
    UBOOL8    MURTS;	/**< ReadOnly */
    UBOOL8    multiBSSID;	/**< ReadOnly */
    UBOOL8    MUEDCA;	/**< ReadOnly */
    UBOOL8    TWTRequestor;	/**< ReadOnly */
    UBOOL8    TWTResponder;	/**< ReadOnly */
    UBOOL8    spatialReuse;	/**< ReadOnly */
    UBOOL8    anticipatedChannelUsage;	/**< ReadOnly */
} Dev2DataElmCapableWifi6aproleObject;

/*! \brief _Dev2DataElmCapableWifi6aproleObject is used internally to represent Dev2DataElmCapableWifi6aproleObject */
typedef Dev2DataElmCapableWifi6aproleObject _Dev2DataElmCapableWifi6aproleObject;



/*! \brief Obj struct for Device.WiFi.DataElements.Network.Device.{i}.Radio.{i}.Capabilities.WiFi6bSTARole.
 *
 * MDMOID_DEV2_DATA_ELM_CAPABLE_WIFI6BSTAROLE 2634
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    HE160;	/**< ReadOnly */
    UBOOL8    HE8080;	/**< ReadOnly */
    BASE64    MCSNSS;	/**< ReadOnly */
    UBOOL8    SUBeamformer;	/**< ReadOnly */
    UBOOL8    SUBeamformee;	/**< ReadOnly */
    UBOOL8    MUBeamformer;	/**< ReadOnly */
    UBOOL8    beamformee80orLess;	/**< ReadOnly */
    UBOOL8    beamformeeAbove80;	/**< ReadOnly */
    UBOOL8    ULMUMIMO;	/**< ReadOnly */
    UBOOL8    ULOFDMA;	/**< ReadOnly */
    UINT32    maxDLMUMIMO;	/**< ReadOnly */
    UINT32    maxULMUMIMO;	/**< ReadOnly */
    UINT32    maxDLOFDMA;	/**< ReadOnly */
    UINT32    maxULOFDMA;	/**< ReadOnly */
    UBOOL8    RTS;	/**< ReadOnly */
    UBOOL8    MURTS;	/**< ReadOnly */
    UBOOL8    multiBSSID;	/**< ReadOnly */
    UBOOL8    MUEDCA;	/**< ReadOnly */
    UBOOL8    TWTRequestor;	/**< ReadOnly */
    UBOOL8    TWTResponder;	/**< ReadOnly */
    UBOOL8    spatialReuse;	/**< ReadOnly */
    UBOOL8    anticipatedChannelUsage;	/**< ReadOnly */
} Dev2DataElmCapableWifi6bstaroleObject;

/*! \brief _Dev2DataElmCapableWifi6bstaroleObject is used internally to represent Dev2DataElmCapableWifi6bstaroleObject */
typedef Dev2DataElmCapableWifi6bstaroleObject _Dev2DataElmCapableWifi6bstaroleObject;



/*! \brief Obj struct for Device.WiFi.DataElements.Network.Device.{i}.Radio.{i}.Capabilities.AKMFrontHaul.{i}.
 *
 * MDMOID_DEV2_DATA_ELM_CAPABLE_AKMFRONTHAUL 2635
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    BASE64    OUI;	/**< ReadOnly */
    UINT32    type;	/**< ReadOnly */
} Dev2DataElmCapableAkmfronthaulObject;

/*! \brief _Dev2DataElmCapableAkmfronthaulObject is used internally to represent Dev2DataElmCapableAkmfronthaulObject */
typedef Dev2DataElmCapableAkmfronthaulObject _Dev2DataElmCapableAkmfronthaulObject;



/*! \brief Obj struct for Device.WiFi.DataElements.Network.Device.{i}.Radio.{i}.Capabilities.AKMBackhaul.{i}.
 *
 * MDMOID_DEV2_DATA_ELM_CAPABLE_AKMBACKHAUL 2636
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    BASE64    OUI;	/**< ReadOnly */
    UINT32    type;	/**< ReadOnly */
} Dev2DataElmCapableAkmbackhaulObject;

/*! \brief _Dev2DataElmCapableAkmbackhaulObject is used internally to represent Dev2DataElmCapableAkmbackhaulObject */
typedef Dev2DataElmCapableAkmbackhaulObject _Dev2DataElmCapableAkmbackhaulObject;



/*! \brief Obj struct for Device.WiFi.DataElements.Network.Device.{i}.Radio.{i}.Capabilities.CapableOperatingClassProfile.{i}.
 *
 * MDMOID_DEV2_DATA_ELM_CAPABLE_OP_CLASS_PROFILE 2637
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    CLASS;	/**< ReadOnly */
    SINT32    maxTxPower;	/**< ReadOnly */
    char *    nonOperable;	/**< ReadOnly */
    UINT32    numberOfNonOperChan;	/**< ReadOnly */
} Dev2DataElmCapableOpClassProfileObject;

/*! \brief _Dev2DataElmCapableOpClassProfileObject is used internally to represent Dev2DataElmCapableOpClassProfileObject */
typedef Dev2DataElmCapableOpClassProfileObject _Dev2DataElmCapableOpClassProfileObject;



/*! \brief Obj struct for Device.WiFi.DataElements.Network.Device.{i}.Radio.{i}.CurrentOperatingClassProfile.{i}.
 *
 * MDMOID_DEV2_DATA_ELM_CUR_OP_CLASS_PROFILE 2638
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    CLASS;	/**< ReadOnly */
    UINT32    channel;	/**< ReadOnly */
    SINT32    txPower;	/**< ReadOnly */
    SINT32    transmitPowerLimit;	/**< ReadOnly */
    char *    timeStamp;	/**< ReadOnly */
} Dev2DataElmCurOpClassProfileObject;

/*! \brief _Dev2DataElmCurOpClassProfileObject is used internally to represent Dev2DataElmCurOpClassProfileObject */
typedef Dev2DataElmCurOpClassProfileObject _Dev2DataElmCurOpClassProfileObject;



/*! \brief Obj struct for Device.WiFi.DataElements.Network.Device.{i}.Radio.{i}.DisAllowedOpClassChannels.{i}.
 *
 * MDMOID_DEV2_DATA_ELM_RADIO_DISALLOWEDOPCLASSCHANNELS 2639
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    UINT32    opClass;	/**< ReadWrite */
    char *    channelList;	/**< ReadWrite */
} Dev2DataElmRadioDisallowedopclasschannelsObject;

/*! \brief _Dev2DataElmRadioDisallowedopclasschannelsObject is used internally to represent Dev2DataElmRadioDisallowedopclasschannelsObject */
typedef Dev2DataElmRadioDisallowedopclasschannelsObject _Dev2DataElmRadioDisallowedopclasschannelsObject;



/*! \brief Obj struct for Device.WiFi.DataElements.Network.Device.{i}.Radio.{i}.SpatialReuse.
 *
 * MDMOID_DEV2_DATA_ELM_RADIO_SPATIALREUSE 2640
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    partialBSSColor;	/**< ReadOnly */
    UINT32    BSSColor;	/**< ReadOnly */
    UBOOL8    HESIGASpatialReuseValue15Allowed;	/**< ReadOnly */
    UBOOL8    SRGInformationValid;	/**< ReadOnly */
    UBOOL8    nonSRGOffsetValid;	/**< ReadOnly */
    UBOOL8    PSRDisallowed;	/**< ReadOnly */
    UINT32    nonSRGOBSSPDMaxOffset;	/**< ReadOnly */
    UINT32    SRGOBSSPDMinOffset;	/**< ReadOnly */
    UINT32    SRGOBSSPDMaxOffset;	/**< ReadOnly */
    HEXBINARY  SRGBSSColorBitmap;	/**< ReadOnly */
    HEXBINARY  SRGPartialBSSIDBitmap;	/**< ReadOnly */
    HEXBINARY  neighborBSSColorInUseBitmap;	/**< ReadOnly */
} Dev2DataElmRadioSpatialreuseObject;

/*! \brief _Dev2DataElmRadioSpatialreuseObject is used internally to represent Dev2DataElmRadioSpatialreuseObject */
typedef Dev2DataElmRadioSpatialreuseObject _Dev2DataElmRadioSpatialreuseObject;



/*! \brief Obj struct for Device.WiFi.DataElements.Network.Device.{i}.Radio.{i}.BSS.{i}.
 *
 * MDMOID_DEV2_DATA_ELM_BSS 2641
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    BSSID;	/**< ReadOnly */
    char *    SSID;	/**< ReadOnly */
    UBOOL8    enabled;	/**< ReadOnly */
    UINT32    lastChange;	/**< ReadOnly */
    char *    timeStamp;	/**< ReadOnly */
    UINT64    unicastBytesSent;	/**< ReadOnly */
    UINT64    unicastBytesReceived;	/**< ReadOnly */
    UINT64    multicastBytesSent;	/**< ReadOnly */
    UINT64    multicastBytesReceived;	/**< ReadOnly */
    UINT64    broadcastBytesSent;	/**< ReadOnly */
    UINT64    broadcastBytesReceived;	/**< ReadOnly */
    UINT32    byteCounterUnits;	/**< ReadOnly */
    UBOOL8    profile1bSTAsDisallowed;	/**< ReadOnly */
    UBOOL8    profile2bSTAsDisallowed;	/**< ReadOnly */
    UINT32    associationAllowanceStatus;	/**< ReadOnly */
    BASE64    estServiceParametersBE;	/**< ReadOnly */
    BASE64    estServiceParametersBK;	/**< ReadOnly */
    BASE64    estServiceParametersVI;	/**< ReadOnly */
    BASE64    estServiceParametersVO;	/**< ReadOnly */
    UBOOL8    backhaulUse;	/**< ReadOnly */
    UBOOL8    fronthaulUse;	/**< ReadOnly */
    UBOOL8    R1disallowed;	/**< ReadOnly */
    UBOOL8    R2disallowed;	/**< ReadOnly */
    UBOOL8    multiBSSID;	/**< ReadOnly */
    UBOOL8    transmittedBSSID;	/**< ReadOnly */
    char *    fronthaulAKMsAllowed;	/**< ReadWrite */
    char *    backhaulAKMsAllowed;	/**< ReadWrite */
    UINT32    STANumberOfEntries;	/**< ReadOnly */
    UINT32    QMDescriptorNumberOfEntries;	/**< ReadOnly */
} Dev2DataElmBssObject;

/*! \brief _Dev2DataElmBssObject is used internally to represent Dev2DataElmBssObject */
typedef Dev2DataElmBssObject _Dev2DataElmBssObject;



/*! \brief Obj struct for Device.WiFi.DataElements.Network.Device.{i}.Radio.{i}.BSS.{i}.QMDescriptor.{i}.
 *
 * MDMOID_DEV2_DATA_ELM_BSS_QMDESCRIPTOR 2642
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    clientMAC;	/**< ReadOnly */
    HEXBINARY  descriptorElement;	/**< ReadOnly */
} Dev2DataElmBssQmdescriptorObject;

/*! \brief _Dev2DataElmBssQmdescriptorObject is used internally to represent Dev2DataElmBssQmdescriptorObject */
typedef Dev2DataElmBssQmdescriptorObject _Dev2DataElmBssQmdescriptorObject;



/*! \brief Obj struct for Device.WiFi.DataElements.Network.Device.{i}.Radio.{i}.BSS.{i}.MultiAPSteering.
 *
 * MDMOID_DEV2_DATA_ELM_BSS_MULTIAPSTEERING 2643
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT64    blacklistAttempts;	/**< ReadOnly */
    UINT64    BTMAttempts;	/**< ReadOnly */
    UINT64    BTMQueryResponses;	/**< ReadOnly */
} Dev2DataElmBssMultiapsteeringObject;

/*! \brief _Dev2DataElmBssMultiapsteeringObject is used internally to represent Dev2DataElmBssMultiapsteeringObject */
typedef Dev2DataElmBssMultiapsteeringObject _Dev2DataElmBssMultiapsteeringObject;



/*! \brief Obj struct for Device.WiFi.DataElements.Network.Device.{i}.Radio.{i}.BSS.{i}.STA.{i}.
 *
 * MDMOID_DEV2_DATA_ELM_STA 2644
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    MACAddress;	/**< ReadOnly */
    char *    timeStamp;	/**< ReadOnly */
    BASE64    HTCapabilities;	/**< ReadOnly */
    BASE64    VHTCapabilities;	/**< ReadOnly */
    BASE64    HECapabilities;	/**< ReadOnly */
    BASE64    clientCapabilities;	/**< ReadOnly */
    UINT32    lastDataDownlinkRate;	/**< ReadOnly */
    UINT32    lastDataUplinkRate;	/**< ReadOnly */
    UINT64    utilizationReceive;	/**< ReadOnly */
    UINT64    utilizationTransmit;	/**< ReadOnly */
    UINT64    bytesSent;	/**< ReadOnly */
    UINT64    bytesReceived;	/**< ReadOnly */
    UINT64    packetsSent;	/**< ReadOnly */
    UINT64    packetsReceived;	/**< ReadOnly */
    UINT64    errorsSent;	/**< ReadOnly */
    UINT64    errorsReceived;	/**< ReadOnly */
    UINT64    retransCount;	/**< ReadOnly */
    char *    IPV4Address;	/**< ReadOnly */
    char *    IPV6Address;	/**< ReadOnly */
    char *    hostName;	/**< ReadOnly */
    char *    cellularDataPreference;	/**< ReadWrite */
    UINT32    reAssociationDelay;	/**< ReadWrite */
    UINT32    TIDQueueSizesNumberOfEntries;	/**< ReadOnly */
} Dev2DataElmStaObject;

/*! \brief _Dev2DataElmStaObject is used internally to represent Dev2DataElmStaObject */
typedef Dev2DataElmStaObject _Dev2DataElmStaObject;



/*! \brief Obj struct for Device.WiFi.DataElements.Network.Device.{i}.Radio.{i}.BSS.{i}.STA.{i}.MultiAPSTA.
 *
 * MDMOID_APST_A 2645
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    DATETIME  associationTime;	/**< ReadOnly */
    UINT64    noise;	/**< ReadOnly */
    UINT32    steeringHistoryNumberOfEntries;	/**< ReadOnly */
} Dev2DataElmMultiAPSTAObject;

/*! \brief _Dev2DataElmMultiAPSTAObject is used internally to represent Dev2DataElmMultiAPSTAObject */
typedef Dev2DataElmMultiAPSTAObject _Dev2DataElmMultiAPSTAObject;



/*! \brief Obj struct for Device.WiFi.DataElements.Network.Device.{i}.Radio.{i}.BSS.{i}.STA.{i}.MultiAPSTA.SteeringSummaryStats.
 *
 * MDMOID_APSTA_STEERING_SUM_STATS 2646
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT64    noCandidateAPFailures;	/**< ReadOnly */
    UINT64    blacklistAttempts;	/**< ReadOnly */
    UINT64    blacklistSuccesses;	/**< ReadOnly */
    UINT64    blacklistFailures;	/**< ReadOnly */
    UINT64    BTMAttempts;	/**< ReadOnly */
    UINT64    BTMSuccesses;	/**< ReadOnly */
    UINT64    BTMFailures;	/**< ReadOnly */
    UINT64    BTMQueryResponses;	/**< ReadOnly */
    UINT32    lastSteerTime;	/**< ReadOnly */
} Dev2DataElmMultiAPSTASteeringSumStatsObject;

/*! \brief _Dev2DataElmMultiAPSTASteeringSumStatsObject is used internally to represent Dev2DataElmMultiAPSTASteeringSumStatsObject */
typedef Dev2DataElmMultiAPSTASteeringSumStatsObject _Dev2DataElmMultiAPSTASteeringSumStatsObject;



/*! \brief Obj struct for Device.WiFi.DataElements.Network.Device.{i}.Radio.{i}.BSS.{i}.STA.{i}.MultiAPSTA.SteeringHistory.{i}.
 *
 * MDMOID_APSTA_STEER_HISTORY 2647
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    DATETIME  time;	/**< ReadOnly */
    char *    APOrigin;	/**< ReadOnly */
    char *    triggerEvent;	/**< ReadOnly */
    char *    steeringApproach;	/**< ReadOnly */
    char *    APDestination;	/**< ReadOnly */
    UINT32    steeringDuration;	/**< ReadOnly */
} Dev2DataElmMultiAPSTASteerHistoryObject;

/*! \brief _Dev2DataElmMultiAPSTASteerHistoryObject is used internally to represent Dev2DataElmMultiAPSTASteerHistoryObject */
typedef Dev2DataElmMultiAPSTASteerHistoryObject _Dev2DataElmMultiAPSTASteerHistoryObject;



/*! \brief Obj struct for Device.WiFi.DataElements.Network.Device.{i}.Radio.{i}.BSS.{i}.STA.{i}.WiFi6Capabilities.
 *
 * MDMOID_DEV2_DATA_ELM_STA_WIFI6CAPABILITIES 2648
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    HE160;	/**< ReadOnly */
    UBOOL8    HE8080;	/**< ReadOnly */
    BASE64    MCSNSS;	/**< ReadOnly */
    UBOOL8    SUBeamformer;	/**< ReadOnly */
    UBOOL8    SUBeamformee;	/**< ReadOnly */
    UBOOL8    MUBeamformer;	/**< ReadOnly */
    UBOOL8    beamformee80orLess;	/**< ReadOnly */
    UBOOL8    beamformeeAbove80;	/**< ReadOnly */
    UBOOL8    ULMUMIMO;	/**< ReadOnly */
    UBOOL8    ULOFDMA;	/**< ReadOnly */
    UINT32    maxDLMUMIMO;	/**< ReadOnly */
    UINT32    maxULMUMIMO;	/**< ReadOnly */
    UINT32    maxDLOFDMA;	/**< ReadOnly */
    UINT32    maxULOFDMA;	/**< ReadOnly */
    UBOOL8    RTS;	/**< ReadOnly */
    UBOOL8    MURTS;	/**< ReadOnly */
    UBOOL8    multiBSSID;	/**< ReadOnly */
    UBOOL8    MUEDCA;	/**< ReadOnly */
    UBOOL8    TWTRequestor;	/**< ReadOnly */
    UBOOL8    TWTResponder;	/**< ReadOnly */
    UBOOL8    spatialReuse;	/**< ReadOnly */
    UBOOL8    anticipatedChannelUsage;	/**< ReadOnly */
} Dev2DataElmStaWifi6capabilitiesObject;

/*! \brief _Dev2DataElmStaWifi6capabilitiesObject is used internally to represent Dev2DataElmStaWifi6capabilitiesObject */
typedef Dev2DataElmStaWifi6capabilitiesObject _Dev2DataElmStaWifi6capabilitiesObject;



/*! \brief Obj struct for Device.WiFi.DataElements.Network.Device.{i}.Radio.{i}.BSS.{i}.STA.{i}.TIDQueueSizes.{i}.
 *
 * MDMOID_DEV2_DATA_ELM_STA_TIDQUEUESIZES 2649
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    TID;	/**< ReadOnly */
    UINT32    size;	/**< ReadOnly */
} Dev2DataElmStaTidqueuesizesObject;

/*! \brief _Dev2DataElmStaTidqueuesizesObject is used internally to represent Dev2DataElmStaTidqueuesizesObject */
typedef Dev2DataElmStaTidqueuesizesObject _Dev2DataElmStaTidqueuesizesObject;



/*! \brief Obj struct for Device.WiFi.DataElements.Network.Device.{i}.Radio.{i}.UnassociatedSTA.{i}.
 *
 * MDMOID_DEV2_DATA_ELM_UNASSOCIATED_STA 2650
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    MACAddress;	/**< ReadOnly */
    UINT32    signalStrength;	/**< ReadOnly */
} Dev2DataElmUnassociatedStaObject;

/*! \brief _Dev2DataElmUnassociatedStaObject is used internally to represent Dev2DataElmUnassociatedStaObject */
typedef Dev2DataElmUnassociatedStaObject _Dev2DataElmUnassociatedStaObject;



/*! \brief Obj struct for Device.WiFi.DataElements.Network.Device.{i}.Radio.{i}.MultiAPRadio.
 *
 * MDMOID_DEV2_DATA_ELM_MULTIAPRADIO 2651
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    radarDetections;	/**< ReadOnly */
} Dev2DataElmMultiapradioObject;

/*! \brief _Dev2DataElmMultiapradioObject is used internally to represent Dev2DataElmMultiapradioObject */
typedef Dev2DataElmMultiapradioObject _Dev2DataElmMultiapradioObject;



/*! \brief Obj struct for Device.WiFi.DataElements.AssociationEvent.
 *
 * MDMOID_DEV2_DATA_ELM_ASSOC_EVENT 2652
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    associationEventDataNumberOfEntries;	/**< ReadOnly */
} Dev2DataElmAssocEventObject;

/*! \brief _Dev2DataElmAssocEventObject is used internally to represent Dev2DataElmAssocEventObject */
typedef Dev2DataElmAssocEventObject _Dev2DataElmAssocEventObject;



/*! \brief Obj struct for Device.WiFi.DataElements.AssociationEvent.AssociationEventData.{i}.
 *
 * MDMOID_DEV2_DATA_ELM_ASSOC_EVENT_DATA 2653
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    BSSID;	/**< ReadOnly */
    char *    MACAddress;	/**< ReadOnly */
    UINT32    statusCode;	/**< ReadOnly */
    BASE64    HTCapabilities;	/**< ReadOnly */
    BASE64    VHTCapabilities;	/**< ReadOnly */
    BASE64    HECapabilities;	/**< ReadOnly */
    char *    timeStamp;	/**< ReadOnly */
} Dev2DataElmAssocEventDataObject;

/*! \brief _Dev2DataElmAssocEventDataObject is used internally to represent Dev2DataElmAssocEventDataObject */
typedef Dev2DataElmAssocEventDataObject _Dev2DataElmAssocEventDataObject;



/*! \brief Obj struct for Device.WiFi.DataElements.AssociationEvent.AssociationEventData.{i}.WiFi6Capabilities.
 *
 * MDMOID_DEV2_DATA_ELM_ASSOC_EVTDATA_WIFI6CAPABILITIES 2654
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    HE160;	/**< ReadOnly */
    UBOOL8    HE8080;	/**< ReadOnly */
    BASE64    MCSNSS;	/**< ReadOnly */
    UBOOL8    SUBeamformer;	/**< ReadOnly */
    UBOOL8    SUBeamformee;	/**< ReadOnly */
    UBOOL8    MUBeamformer;	/**< ReadOnly */
    UBOOL8    beamformee80orLess;	/**< ReadOnly */
    UBOOL8    beamformeeAbove80;	/**< ReadOnly */
    UBOOL8    ULMUMIMO;	/**< ReadOnly */
    UBOOL8    ULOFDMA;	/**< ReadOnly */
    UINT32    maxDLMUMIMO;	/**< ReadOnly */
    UINT32    maxULMUMIMO;	/**< ReadOnly */
    UINT32    maxDLOFDMA;	/**< ReadOnly */
    UINT32    maxULOFDMA;	/**< ReadOnly */
    UBOOL8    RTS;	/**< ReadOnly */
    UBOOL8    MURTS;	/**< ReadOnly */
    UBOOL8    multiBSSID;	/**< ReadOnly */
    UBOOL8    MUEDCA;	/**< ReadOnly */
    UBOOL8    TWTRequestor;	/**< ReadOnly */
    UBOOL8    TWTResponder;	/**< ReadOnly */
    UBOOL8    spatialReuse;	/**< ReadOnly */
    UBOOL8    anticipatedChannelUsage;	/**< ReadOnly */
} Dev2DataElmAssocEvtdataWifi6capabilitiesObject;

/*! \brief _Dev2DataElmAssocEvtdataWifi6capabilitiesObject is used internally to represent Dev2DataElmAssocEvtdataWifi6capabilitiesObject */
typedef Dev2DataElmAssocEvtdataWifi6capabilitiesObject _Dev2DataElmAssocEvtdataWifi6capabilitiesObject;



/*! \brief Obj struct for Device.WiFi.DataElements.DisassociationEvent.
 *
 * MDMOID_DEV2_DATA_ELM_DISASSOC_EVENT 2655
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    disassociationEventDataNumberOfEntries;	/**< ReadOnly */
} Dev2DataElmDisassocEventObject;

/*! \brief _Dev2DataElmDisassocEventObject is used internally to represent Dev2DataElmDisassocEventObject */
typedef Dev2DataElmDisassocEventObject _Dev2DataElmDisassocEventObject;



/*! \brief Obj struct for Device.WiFi.DataElements.DisassociationEvent.DisassociationEventData.{i}.
 *
 * MDMOID_DEV2_DATA_ELM_DISASSOC_EVENT_DATA 2656
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    BSSID;	/**< ReadOnly */
    char *    MACAddress;	/**< ReadOnly */
    UINT32    reasonCode;	/**< ReadOnly */
    UINT64    bytesSent;	/**< ReadOnly */
    UINT64    bytesReceived;	/**< ReadOnly */
    UINT64    packetsSent;	/**< ReadOnly */
    UINT64    packetsReceived;	/**< ReadOnly */
    UINT32    errorsSent;	/**< ReadOnly */
    UINT32    errorsReceived;	/**< ReadOnly */
    UINT32    retransCount;	/**< ReadOnly */
    char *    timeStamp;	/**< ReadOnly */
} Dev2DataElmDisassocEventDataObject;

/*! \brief _Dev2DataElmDisassocEventDataObject is used internally to represent Dev2DataElmDisassocEventDataObject */
typedef Dev2DataElmDisassocEventDataObject _Dev2DataElmDisassocEventDataObject;



/*! \brief Obj struct for Device.WiFi.DataElements.FailedConnectionEvent.
 *
 * MDMOID_DEV2_DATA_ELM_FAILEDCONN_EVT 2657
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    failedConnectionEventDataNumberOfEntries;	/**< ReadOnly */
} Dev2DataElmFailedconnEvtObject;

/*! \brief _Dev2DataElmFailedconnEvtObject is used internally to represent Dev2DataElmFailedconnEvtObject */
typedef Dev2DataElmFailedconnEvtObject _Dev2DataElmFailedconnEvtObject;



/*! \brief Obj struct for Device.WiFi.DataElements.FailedConnectionEvent.FailedConnectionEventData.{i}.
 *
 * MDMOID_DEV2_DATA_ELM_FAILEDCONN_EVTDATA 2658
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    MACAddress;	/**< ReadOnly */
    UINT32    statusCode;	/**< ReadOnly */
    UINT32    reasonCode;	/**< ReadOnly */
    char *    timeStamp;	/**< ReadOnly */
} Dev2DataElmFailedconnEvtdataObject;

/*! \brief _Dev2DataElmFailedconnEvtdataObject is used internally to represent Dev2DataElmFailedconnEvtdataObject */
typedef Dev2DataElmFailedconnEvtdataObject _Dev2DataElmFailedconnEvtdataObject;



/*! \brief Obj struct for Device.WiFi.X_BROADCOM_COM_BsdCfg.
 *
 * MDMOID_DEV2_WIFI_BSD_CFG 2659
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    SINT32    bsdRole;	/**< ReadWrite */
    char *    bsdPrimary;	/**< ReadWrite */
    char *    bsdHelper;	/**< ReadWrite */
    SINT32    bsdHport;	/**< ReadWrite */
    SINT32    bsdPport;	/**< ReadWrite */
    char *    bsdIfnames;	/**< ReadWrite */
    char *    bsdBounceDetect;	/**< ReadWrite */
} Dev2WifiBsdCfgObject;

/*! \brief _Dev2WifiBsdCfgObject is used internally to represent Dev2WifiBsdCfgObject */
typedef Dev2WifiBsdCfgObject _Dev2WifiBsdCfgObject;



/*! \brief Obj struct for Device.WiFi.X_BROADCOM_COM_WpsCfg.
 *
 * MDMOID_DEV2_WIFI_WPS_CFG 2660
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    wpsVersion2;	/**< ReadWrite */
    char *    wpsDeviceName;	/**< ReadWrite */
    char *    wpsMfstring;	/**< ReadWrite */
    char *    wpsModelname;	/**< ReadWrite */
    char *    wpsModelnum;	/**< ReadWrite */
    char *    wpsBoardnum;	/**< ReadWrite */
    char *    wpsDevicePin;	/**< ReadWrite */
    char *    wpsStaPin;	/**< ReadWrite */
    char *    wpsWerMode;	/**< ReadWrite */
    char *    wpsConfigMethod;	/**< ReadWrite */
    char *    wpsMsglevel;	/**< ReadWrite */
    char *    wpsCustomIfNames;	/**< ReadWrite */
} Dev2WifiWpsCfgObject;

/*! \brief _Dev2WifiWpsCfgObject is used internally to represent Dev2WifiWpsCfgObject */
typedef Dev2WifiWpsCfgObject _Dev2WifiWpsCfgObject;



/*! \brief Obj struct for Device.WiFi.X_BROADCOM_COM_NasCfg.
 *
 * MDMOID_DEV2_WIFI_NAS_CFG 2661
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    debug;	/**< ReadWrite */
} Dev2WifiNasCfgObject;

/*! \brief _Dev2WifiNasCfgObject is used internally to represent Dev2WifiNasCfgObject */
typedef Dev2WifiNasCfgObject _Dev2WifiNasCfgObject;



/*! \brief Obj struct for Device.WiFi.X_BROADCOM_COM_DebugMonitorCfg.
 *
 * MDMOID_DEV2_WIFI_DEBUG_MONITOR_CFG 2662
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    SINT32    enable;	/**< ReadWrite */
    char *    crahsLogDir;	/**< ReadWrite */
    SINT32    disableAppRestart;	/**< ReadWrite */
} Dev2WifiDebugMonitorCfgObject;

/*! \brief _Dev2WifiDebugMonitorCfgObject is used internally to represent Dev2WifiDebugMonitorCfgObject */
typedef Dev2WifiDebugMonitorCfgObject _Dev2WifiDebugMonitorCfgObject;



/*! \brief Obj struct for Device.WiFi.X_BROADCOM_COM_CeventdCfg.
 *
 * MDMOID_DEV2_WIFI_CEVENTD_CFG 2663
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    SINT32    enable;	/**< ReadWrite */
    char *    ceventdOut;	/**< ReadWrite */
    char *    eventmask;	/**< ReadWrite */
} Dev2WifiCeventdCfgObject;

/*! \brief _Dev2WifiCeventdCfgObject is used internally to represent Dev2WifiCeventdCfgObject */
typedef Dev2WifiCeventdCfgObject _Dev2WifiCeventdCfgObject;



/*! \brief Obj struct for Device.WiFi.X_BROADCOM_COM_HapdCfg.
 *
 * MDMOID_DEV2_WIFI_HAPD_CFG 2664
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    SINT32    enable;	/**< ReadWrite */
    UINT32    debug;	/**< ReadWrite */
} Dev2WifiHapdCfgObject;

/*! \brief _Dev2WifiHapdCfgObject is used internally to represent Dev2WifiHapdCfgObject */
typedef Dev2WifiHapdCfgObject _Dev2WifiHapdCfgObject;



/*! \brief Obj struct for Device.WiFi.X_BROADCOM_COM_SsdCfg.
 *
 * MDMOID_DEV2_WIFI_SSD_CFG 2665
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    SINT32    enable;	/**< ReadWrite */
} Dev2WifiSsdCfgObject;

/*! \brief _Dev2WifiSsdCfgObject is used internally to represent Dev2WifiSsdCfgObject */
typedef Dev2WifiSsdCfgObject _Dev2WifiSsdCfgObject;



/*! \brief Obj struct for Device.WiFi.X_BROADCOM_COM_WbdCfg.
 *
 * MDMOID_DEV2_WIFI_WBD_CFG 2666
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    multiapMode;	/**< ReadWrite */
    char *    wbdIfNames;	/**< ReadWrite */
    SINT32    mapBHOpen;	/**< ReadWrite */
    char *    wpsBhIfNames;	/**< ReadWrite */
    UINT32    wbdMsgLevel;	/**< ReadWrite */
    UINT32    mapMsgLevel;	/**< ReadWrite */
    char *    mapMsgLevelModule;	/**< ReadWrite */
} Dev2WifiWbdCfgObject;

/*! \brief _Dev2WifiWbdCfgObject is used internally to represent Dev2WifiWbdCfgObject */
typedef Dev2WifiWbdCfgObject _Dev2WifiWbdCfgObject;



/*! \brief Obj struct for Device.WiFi.X_BROADCOM_COM_WbdCfg.MapBss.{i}.
 *
 * MDMOID_DEV2_WIFI_WBD_CFG_MBSS 2667
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    prefix;	/**< ReadWrite */
    UINT32    map;	/**< ReadWrite */
    UINT32    bandFlag;	/**< ReadWrite */
    char *    ssid;	/**< ReadWrite */
    char *    akm;	/**< ReadWrite */
    char *    crypto;	/**< ReadWrite */
    char *    wpsPsk;	/**< ReadWrite */
} Dev2WifiWbdCfgMbssObject;

/*! \brief _Dev2WifiWbdCfgMbssObject is used internally to represent Dev2WifiWbdCfgMbssObject */
typedef Dev2WifiWbdCfgMbssObject _Dev2WifiWbdCfgMbssObject;



/*! \brief Obj struct for Device.WiFi.Radio.{i}.
 *
 * MDMOID_DEV2_WIFI_RADIO 2668
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    status;	/**< ReadOnly */
    char *    alias;	/**< ReadWrite */
    char *    name;	/**< ReadOnly */
    UINT32    lastChange;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_LastChange;	/**< ReadWrite */
    char *    lowerLayers;	/**< ReadWrite */
    UBOOL8    upstream;	/**< ReadOnly */
    UINT32    maxBitRate;	/**< ReadOnly */
    char *    supportedFrequencyBands;	/**< ReadOnly */
    UBOOL8    X_BROADCOM_COM_WlApstaSupported;	/**< ReadWrite */
    char *    X_BROADCOM_COM_WlCountry;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_WlSsidIdx;	/**< Read */
    SINT32    X_BROADCOM_COM_WlRegRev;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_WlAtf;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_WlTaf;	/**< ReadWrite */
    char *    operatingFrequencyBand;	/**< ReadWrite */
    char *    supportedStandards;	/**< ReadOnly */
    char *    operatingStandards;	/**< ReadWrite */
    char *    possibleChannels;	/**< ReadOnly */
    char *    channelsInUse;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_WlChannel;	/**< ReadWrite */
    UINT32    channel;	/**< ReadWrite */
    UBOOL8    autoChannelSupported;	/**< ReadOnly */
    UBOOL8    autoChannelEnable;	/**< ReadWrite */
    UINT32    autoChannelRefreshPeriod;	/**< ReadWrite */
    UINT32    maxSupportedSSIDs;	/**< ReadOnly */
    UINT32    maxSupportedAssociations;	/**< ReadOnly */
    char *    firmwareVersion;	/**< ReadOnly */
    char *    supportedOperatingChannelBandwidths;	/**< ReadOnly */
    char *    supportedChannelBandwidth;	/**< ReadWrite */
    char *    operatingChannelBandwidth;	/**< ReadWrite */
    char *    currentOperatingChannelBandwidth;	/**< ReadOnly */
    char *    extensionChannel;	/**< ReadWrite */
    char *    guardInterval;	/**< ReadWrite */
    UINT32    centerFrequencySegement0;	/**< ReadWrite */
    UINT32    centerFrequencySegement1;	/**< ReadWrite */
    SINT32    MCS;	/**< ReadWrite */
    char *    transmitPowerSupported;	/**< ReadOnly */
    SINT32    transmitPower;	/**< ReadWrite */
    UBOOL8    IEEE80211hSupported;	/**< ReadOnly */
    UBOOL8    IEEE80211hEnabled;	/**< ReadWrite */
    char *    regulatoryDomain;	/**< ReadWrite */
    UINT32    retryLimit;	/**< ReadWrite */
    HEXBINARY  CCARequest;	/**< ReadWrite */
    HEXBINARY  CCAReport;	/**< ReadOnly */
    HEXBINARY  RPIHistogramRequest;	/**< ReadWrite */
    HEXBINARY  RPIHistogramReport;	/**< ReadOnly */
    UINT32    fragmentationThreshold;	/**< ReadWrite */
    UINT32    RTSThreshold;	/**< ReadWrite */
    UINT32    longRetryLimit;	/**< ReadWrite */
    UINT32    beaconPeriod;	/**< ReadWrite */
    UINT32    DTIMPeriod;	/**< ReadWrite */
    UBOOL8    packetAggregationEnable;	/**< ReadWrite */
    char *    preambleType;	/**< ReadWrite */
    char *    basicDataTransmitRates;	/**< ReadWrite */
    char *    operationalDataTransmitRates;	/**< ReadWrite */
    char *    supportedDataTransmitRates;	/**< ReadOnly */
    SINT32    X_BROADCOM_COM_WlRegMode;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_WlIntferTcptxfail;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_WlIntferPeriod;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_WlIntferCnt;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_WlIntferTxfail;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_WlCoreRev;	/**< ReadWrite */
    char *    X_BROADCOM_COM_WlBasicRate;	/**< ReadWrite */
    char *    X_BROADCOM_COM_WlProtection;	/**< ReadWrite */
    char *    X_BROADCOM_COM_WlPreambleType;	/**< ReadWrite */
    char *    X_BROADCOM_COM_WlFrameBurst;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_WlFrgThrshld;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_WlRtsThrshld;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_WlBcnRotate;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_WlRate;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_WlgMode;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_WlMCastRate;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_WlInfra;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_WlAntDiv;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_WlDfsPreIsm;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_WlDfsPostIsm;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_WlTpcDb;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_WlMBands;	/**< ReadWrite */
    char *    X_BROADCOM_COM_WlNProtection;	/**< ReadWrite */
    char *    X_BROADCOM_COM_WlAmpdu;	/**< ReadWrite */
    char *    X_BROADCOM_COM_WlAmsdu;	/**< ReadWrite */
    char *    X_BROADCOM_COM_WlNmode;	/**< ReadWrite */
    char *    X_BROADCOM_COM_WlStbcTx;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_WlStbcRx;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_WlLazyWds;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_WlObssCoex;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_WlRxChainPwrSaveEnable;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_WlRxChainPwrSaveQuietTime;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_WlRxChainPwrSavePps;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_WlRxChainPwrSaveStasAssocCheck;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_WlRadioPwrSaveEnable;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_WlRadioPwrSaveQuietTime;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_WlRadioPwrSavePps;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_WlRadioPwrSaveStasAssocCheck;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_WlRadioPwrSaveLevel;	/**< ReadWrite */
    char *    X_BROADCOM_COM_WlWds;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_WlWdsSec;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_WlWdsTimeout;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_WlWdsSecEnable;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_WlEnableUre;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_WlStaRetryTime;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_WlTxbfBfeCap;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_WlTxbfBfrCap;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_WlTxbfImp;	/**< ReadWrite */
    char *    X_BROADCOM_COM_WlWmeApBe;	/**< ReadWrite */
    char *    X_BROADCOM_COM_WlWmeApBk;	/**< ReadWrite */
    char *    X_BROADCOM_COM_WlWmeApVi;	/**< ReadWrite */
    char *    X_BROADCOM_COM_WlWmeApVo;	/**< ReadWrite */
    char *    X_BROADCOM_COM_WlWmeStaBe;	/**< ReadWrite */
    char *    X_BROADCOM_COM_WlWmeStaBk;	/**< ReadWrite */
    char *    X_BROADCOM_COM_WlWmeStaVi;	/**< ReadWrite */
    char *    X_BROADCOM_COM_WlWmeStaVo;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_WlWmfUcigmpQuery;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_WlWmfMdataSendup;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_WlWmfUcastUpnp;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_WlWmfIgmpqFilter;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_WlWmfPstaDisable;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_WlPspretendRetryLimit;	/**< ReadWrite */
    char *    X_BROADCOM_COM_WlAmpduRtylimitTid;	/**< ReadWrite */
    char *    X_BROADCOM_COM_WlAmpduRrRtylimitTid;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_WlPsrMrpt;	/**< ReadWrite */
    char *    X_BROADCOM_COM_WlMuFeatures;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_WlVhtMode;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_WlVhtFeatures;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_WlHeFeatures;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_WlRxAmsduInAmpduOvr;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_WlObssDynBw;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_WlCalPeriod;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_WlPstaInact;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_WlProbRespSw;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_WlTxChain;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_WlRxChain;	/**< ReadWrite */
    char *    X_BROADCOM_COM_WlRifsAdvert;	/**< ReadWrite */
    char *    X_BROADCOM_COM_WlVlanPrioMode;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_WlMgmtRssiPolicy;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_WlWetTunnel;	/**< ReadWrite */
} Dev2WifiRadioObject;

/*! \brief _Dev2WifiRadioObject is used internally to represent Dev2WifiRadioObject */
typedef Dev2WifiRadioObject _Dev2WifiRadioObject;



/*! \brief Obj struct for Device.WiFi.Radio.{i}.Stats.
 *
 * MDMOID_DEV2_WIFI_RADIO_STATS 2669
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT64    bytesSent;	/**< ReadOnly */
    UINT64    bytesReceived;	/**< ReadOnly */
    UINT64    packetsSent;	/**< ReadOnly */
    UINT64    packetsReceived;	/**< ReadOnly */
    UINT32    errorsSent;	/**< ReadOnly */
    UINT32    errorsReceived;	/**< ReadOnly */
    UINT32    discardPacketsSent;	/**< ReadOnly */
    UINT32    discardPacketsReceived;	/**< ReadOnly */
    UINT32    PLCPErrorCount;	/**< ReadOnly */
    UINT32    FCSErrorCount;	/**< ReadOnly */
    UINT32    invalidMACCount;	/**< ReadOnly */
    UINT32    packetsOtherReceived;	/**< ReadOnly */
    SINT32    noise;	/**< ReadOnly */
    UINT32    manualChannelChangeCount;	/**< ReadOnly */
} Dev2WifiRadioStatsObject;

/*! \brief _Dev2WifiRadioStatsObject is used internally to represent Dev2WifiRadioStatsObject */
typedef Dev2WifiRadioStatsObject _Dev2WifiRadioStatsObject;



/*! \brief Obj struct for Device.WiFi.Radio.{i}.X_BROADCOM_COM_AcsdCfg.
 *
 * MDMOID_DEV2_WIFI_RADIO_ACSD_CFG 2670
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    acsDfsrImmediate;	/**< ReadWrite */
    char *    acsExclChannels;	/**< ReadWrite */
    char *    acsDfsrDeferred;	/**< ReadWrite */
    char *    acsDfsrActivity;	/**< ReadWrite */
    SINT32    acsFcsMode;	/**< ReadWrite */
    SINT32    acsDfs;	/**< ReadWrite */
    SINT32    acsCiScanTimer;	/**< ReadWrite */
    SINT32    acsCiScanTimeout;	/**< ReadWrite */
    SINT32    acsScanEntryExpire;	/**< ReadWrite */
    SINT32    acsTxIdleCnt;	/**< ReadWrite */
    SINT32    acsChanDwellTime;	/**< ReadWrite */
    SINT32    acsChanFlopPeriod;	/**< ReadWrite */
    SINT32    acsDcsCsaUnicast;	/**< ReadWrite */
    SINT32    acsBgdfsAhead;	/**< ReadWrite */
    SINT32    acsBgdfsAvoidOnFarSta;	/**< ReadWrite */
    SINT32    acsBgdfsEnab;	/**< ReadWrite */
    SINT32    acsBgdfsFallbackBlockingCac;	/**< ReadWrite */
    SINT32    acsBgdfsIdleFramesThld;	/**< ReadWrite */
    SINT32    acsBgdfsIdleInterval;	/**< ReadWrite */
    SINT32    acsBgdfsTxblankThreshold;	/**< ReadWrite */
    SINT32    acsBootOnly;	/**< ReadWrite */
    SINT32    acsChanimNum_segments;	/**< ReadWrite */
    SINT32    acsFarStaRssi;	/**< ReadWrite */
    SINT32    acsSegmentChanim;	/**< ReadWrite */
    SINT32    acsUseEscan;	/**< ReadWrite */
    SINT32    acsScsDfsScan;	/**< ReadWrite */
    SINT32    acsStartOnNondfs;	/**< ReadWrite */
    SINT32    acsIgnoreTxfail;	/**< ReadWrite */
    SINT32    acsInttrfNumsecs;	/**< ReadWrite */
    SINT32    acsDyn160;	/**< ReadWrite */
    SINT32    acsDfsReentry;	/**< ReadWrite */
    SINT32    acsInttrfThresh;	/**< ReadWrite */
} Dev2WifiRadioAcsdCfgObject;

/*! \brief _Dev2WifiRadioAcsdCfgObject is used internally to represent Dev2WifiRadioAcsdCfgObject */
typedef Dev2WifiRadioAcsdCfgObject _Dev2WifiRadioAcsdCfgObject;



/*! \brief Obj struct for Device.WiFi.NeighboringWiFiDiagnostic.
 *
 * MDMOID_DEV2_WIFI_NEIGHBORINGWIFIDIAGNOSTIC 2671
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    diagnosticsState;	/**< ReadWrite */
    UINT32    resultNumberOfEntries;	/**< ReadOnly */
} Dev2WifiNeighboringwifidiagnosticObject;

/*! \brief _Dev2WifiNeighboringwifidiagnosticObject is used internally to represent Dev2WifiNeighboringwifidiagnosticObject */
typedef Dev2WifiNeighboringwifidiagnosticObject _Dev2WifiNeighboringwifidiagnosticObject;



/*! \brief Obj struct for Device.WiFi.NeighboringWiFiDiagnostic.Result.{i}.
 *
 * MDMOID_DEV2_WIFI_NEIGHBORINGWIFIDIAGNOSTIC_RESULT 2672
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    radio;	/**< ReadOnly */
    char *    SSID;	/**< ReadOnly */
    char *    BSSID;	/**< ReadOnly */
    char *    mode;	/**< ReadOnly */
    UINT32    channel;	/**< ReadOnly */
    SINT32    signalStrength;	/**< ReadOnly */
    char *    securityModeEnabled;	/**< ReadOnly */
    char *    encryptionMode;	/**< ReadOnly */
    char *    operatingFrequencyBand;	/**< ReadOnly */
    char *    supportedStandards;	/**< ReadOnly */
    char *    operatingStandards;	/**< ReadOnly */
    char *    operatingChannelBandwidth;	/**< ReadOnly */
    UINT32    beaconPeriod;	/**< ReadOnly */
    SINT32    noise;	/**< ReadOnly */
    char *    basicDataTransferRates;	/**< ReadOnly */
    char *    supportedDataTransferRates;	/**< ReadOnly */
    UINT32    DTIMPeriod;	/**< ReadOnly */
} Dev2WifiNeighboringwifidiagnosticResultObject;

/*! \brief _Dev2WifiNeighboringwifidiagnosticResultObject is used internally to represent Dev2WifiNeighboringwifidiagnosticResultObject */
typedef Dev2WifiNeighboringwifidiagnosticResultObject _Dev2WifiNeighboringwifidiagnosticResultObject;



/*! \brief Obj struct for Device.WiFi.SSID.{i}.
 *
 * MDMOID_DEV2_WIFI_SSID 2673
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    status;	/**< ReadOnly */
    char *    alias;	/**< ReadWrite */
    char *    name;	/**< ReadOnly */
    UINT32    lastChange;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_LastChange;	/**< ReadWrite */
    UBOOL8    X_BROADCOM_COM_Upstream;	/**< ReadOnly */
    char *    lowerLayers;	/**< ReadWrite */
    char *    BSSID;	/**< ReadOnly */
    char *    MACAddress;	/**< ReadOnly */
    char *    SSID;	/**< ReadWrite */
    UINT32    X_BROADCOM_COM_Adapter;	/**< ReadOnly */
    SINT32    X_BROADCOM_COM_WlEnableWmf;	/**< ReadWrite */
    UINT32    X_BROADCOM_COM_Index;	/**< ReadOnly */
    SINT32    X_BROADCOM_COM_WlIdx;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_WlBrIndex;	/**< ReadWrite */
    char *    X_BROADCOM_COM_WlMode;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_WlAssocRetry;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_WlMcastRegenBssEnable;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_WlBssOpmodeCapReqd;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_WlDwds;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_WlProbRespMf;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_WlMap;	/**< ReadWrite */
} Dev2WifiSsidObject;

/*! \brief _Dev2WifiSsidObject is used internally to represent Dev2WifiSsidObject */
typedef Dev2WifiSsidObject _Dev2WifiSsidObject;



/*! \brief Obj struct for Device.WiFi.SSID.{i}.Stats.
 *
 * MDMOID_DEV2_WIFI_SSID_STATS 2674
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT64    bytesSent;	/**< ReadOnly */
    UINT64    bytesReceived;	/**< ReadOnly */
    UINT64    packetsSent;	/**< ReadOnly */
    UINT64    packetsReceived;	/**< ReadOnly */
    UINT32    errorsSent;	/**< ReadOnly */
    UINT32    retransCount;	/**< ReadOnly */
    UINT32    failedRetransCount;	/**< ReadOnly */
    UINT32    retryCount;	/**< ReadOnly */
    UINT32    multipleRetryCount;	/**< ReadOnly */
    UINT32    ACKFailureCount;	/**< ReadOnly */
    UINT32    aggregatedPacketCount;	/**< ReadOnly */
    UINT32    errorsReceived;	/**< ReadOnly */
    UINT64    unicastPacketsSent;	/**< ReadOnly */
    UINT64    unicastPacketsReceived;	/**< ReadOnly */
    UINT32    discardPacketsSent;	/**< ReadOnly */
    UINT32    discardPacketsReceived;	/**< ReadOnly */
    UINT64    multicastPacketsSent;	/**< ReadOnly */
    UINT64    multicastPacketsReceived;	/**< ReadOnly */
    UINT64    broadcastPacketsSent;	/**< ReadOnly */
    UINT64    broadcastPacketsReceived;	/**< ReadOnly */
    UINT32    unknownProtoPacketsReceived;	/**< ReadOnly */
} Dev2WifiSsidStatsObject;

/*! \brief _Dev2WifiSsidStatsObject is used internally to represent Dev2WifiSsidStatsObject */
typedef Dev2WifiSsidStatsObject _Dev2WifiSsidStatsObject;



/*! \brief Obj struct for Device.WiFi.SSID.{i}.X_BROADCOM_COM_BsdCfg.
 *
 * MDMOID_DEV2_WIFI_SSID_BSD_CFG 2675
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    bsdSteeringPolicy;	/**< ReadWrite */
    char *    bsdStaSelectionPolicy;	/**< ReadWrite */
    char *    bsdIfSelectPolicy;	/**< ReadWrite */
    char *    bsdIfQualifyPolicy;	/**< ReadWrite */
} Dev2WifiSsidBsdCfgObject;

/*! \brief _Dev2WifiSsidBsdCfgObject is used internally to represent Dev2WifiSsidBsdCfgObject */
typedef Dev2WifiSsidBsdCfgObject _Dev2WifiSsidBsdCfgObject;



/*! \brief Obj struct for Device.WiFi.SSID.{i}.X_BROADCOM_COM_HspotCfg.
 *
 * MDMOID_DEV2_WIFI_SSID_HSPOT_CFG 2676
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    hspotHsflag;	/**< ReadWrite */
    SINT32    hspotHs2cap;	/**< ReadWrite */
    SINT32    hspotOpercls;	/**< ReadWrite */
    char *    hspotAnonai;	/**< ReadWrite */
    char *    hspotWanmetrics;	/**< ReadWrite */
    char *    hspotOplist;	/**< ReadWrite */
    char *    hspotHomeqlist;	/**< ReadWrite */
    char *    hspotOsuSsid;	/**< ReadWrite */
    char *    hspotOsuFrndname;	/**< ReadWrite */
    char *    hspotOsuUri;	/**< ReadWrite */
    char *    hspotOsuNai;	/**< ReadWrite */
    SINT32    hspotOsuMethod;	/**< ReadWrite */
    char *    hspotOsuIcons;	/**< ReadWrite */
    char *    hspotOsuServdesc;	/**< ReadWrite */
    char *    hspotConcaplist;	/**< ReadWrite */
    char *    hspotQosmapie;	/**< ReadWrite */
    SINT32    hspotGascbdel;	/**< ReadWrite */
    SINT32    hspotHs2DebugLevel;	/**< ReadWrite */
    SINT32    hspotIwnettype;	/**< ReadWrite */
    char *    hspotHessid;	/**< ReadWrite */
    SINT32    hspotIpv4addr;	/**< ReadWrite */
    SINT32    hspotIpv6addr;	/**< ReadWrite */
    char *    hspotNetauthlist;	/**< ReadWrite */
    SINT32    hspotVenuegrp;	/**< ReadWrite */
    SINT32    hspotVenuetype;	/**< ReadWrite */
    char *    hspotVenuelist;	/**< ReadWrite */
    char *    hspotOuilist;	/**< ReadWrite */
    char *    hspot3gpplist;	/**< ReadWrite */
    char *    hspotDomainlist;	/**< ReadWrite */
    char *    hspotiRealmlist;	/**< ReadWrite */
} Dev2WifiSsidHspotCfgObject;

/*! \brief _Dev2WifiSsidHspotCfgObject is used internally to represent Dev2WifiSsidHspotCfgObject */
typedef Dev2WifiSsidHspotCfgObject _Dev2WifiSsidHspotCfgObject;



/*! \brief Obj struct for Device.WiFi.SSID.{i}.X_BROADCOM_COM_SsdCfg.
 *
 * MDMOID_DEV2_WIFI_SSID_SSD_CFG 2677
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    SINT32    ssdType;	/**< ReadWrite */
} Dev2WifiSsidSsdCfgObject;

/*! \brief _Dev2WifiSsidSsdCfgObject is used internally to represent Dev2WifiSsidSsdCfgObject */
typedef Dev2WifiSsidSsdCfgObject _Dev2WifiSsidSsdCfgObject;



/*! \brief Obj struct for Device.WiFi.AccessPoint.{i}.
 *
 * MDMOID_DEV2_WIFI_ACCESS_POINT 2678
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    status;	/**< ReadOnly */
    char *    alias;	/**< ReadWrite */
    char *    SSIDReference;	/**< ReadWrite */
    UBOOL8    SSIDAdvertisementEnabled;	/**< ReadWrite */
    UINT32    retryLimit;	/**< ReadWrite */
    UBOOL8    WMMCapability;	/**< ReadWrite */
    UBOOL8    UAPSDCapability;	/**< ReadWrite */
    UBOOL8    WMMEnable;	/**< ReadWrite */
    UBOOL8    X_BROADCOM_COM_WlSesAvail;	/**< ReadWrite */
    UBOOL8    X_BROADCOM_COM_WlWapiAvail;	/**< ReadWrite */
    UBOOL8    UAPSDEnable;	/**< ReadWrite */
    UINT32    associatedDeviceNumberOfEntries;	/**< ReadOnly */
    UINT32    maxAssociatedDevices;	/**< ReadWrite */
    UBOOL8    isolationEnable;	/**< ReadWrite */
#ifdef DMP_DEVICE2_WIFIACCESSPOINT_2
    UBOOL8    MACAddressControlEnabled;	/**< ReadWrite */
#endif
#ifdef DMP_DEVICE2_WIFIACCESSPOINT_2
    char *    allowedMACAddress;	/**< ReadWrite */
#endif
    UINT32    X_BROADCOM_COM_Adapter;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_Index;	/**< ReadOnly */
    SINT32    X_BROADCOM_COM_WlWmeNoAck;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_WlEnableHspot;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_WlNReqd;	/**< ReadWrite */
    char *    X_BROADCOM_COM_WlFltMacMode;	/**< ReadWrite */
    char *    X_BROADCOM_COM_WlFltMacList;	/**< ReadWrite */
} Dev2WifiAccessPointObject;

/*! \brief _Dev2WifiAccessPointObject is used internally to represent Dev2WifiAccessPointObject */
typedef Dev2WifiAccessPointObject _Dev2WifiAccessPointObject;



/*! \brief Obj struct for Device.WiFi.AccessPoint.{i}.Security.
 *
 * MDMOID_DEV2_WIFI_ACCESS_POINT_SECURITY 2679
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    reset;	/**< ReadWrite */
    char *    modesSupported;	/**< ReadOnly */
    char *    modeEnabled;	/**< ReadWrite */
    char *    wlWep;	/**< ReadWrite */
    HEXBINARY  WEPKey;	/**< ReadWrite */
    HEXBINARY  preSharedKey;	/**< ReadWrite */
    char *    keyPassphrase;	/**< ReadWrite */
    UINT32    rekeyingInterval;	/**< ReadWrite */
    char *    SAEPassphrase;	/**< ReadWrite */
    char *    radiusServerIPAddr;	/**< ReadWrite */
    char *    secondaryRadiusServerIPAddr;	/**< ReadWrite */
    UINT32    radiusServerPort;	/**< ReadWrite */
    UINT32    secondaryRadiusServerPort;	/**< ReadWrite */
    char *    radiusSecret;	/**< ReadWrite */
    char *    secondaryRadiusSecret;	/**< ReadWrite */
    char *    X_BROADCOM_COM_WlKey1;	/**< ReadWrite */
    char *    X_BROADCOM_COM_WlKey2;	/**< ReadWrite */
    char *    X_BROADCOM_COM_WlKey3;	/**< ReadWrite */
    char *    X_BROADCOM_COM_WlKey4;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_WlKeyIndex;	/**< ReadWrite */
    char *    X_BROADCOM_COM_WlWpaEncryption;	/**< ReadWrite */
    char *    wlAuthMode;	/**< ReadWrite */
    char *    wlAuthAkm;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_WlAuth;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_WlPreauth;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_WlNetReauth;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_WlMFP;	/**< ReadWrite */
} Dev2WifiAccessPointSecurityObject;

/*! \brief _Dev2WifiAccessPointSecurityObject is used internally to represent Dev2WifiAccessPointSecurityObject */
typedef Dev2WifiAccessPointSecurityObject _Dev2WifiAccessPointSecurityObject;



/*! \brief Obj struct for Device.WiFi.AccessPoint.{i}.WPS.
 *
 * MDMOID_DEV2_WIFI_ACCESS_POINT_WPS 2680
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    configMethodsSupported;	/**< ReadOnly */
    char *    configMethodsEnabled;	/**< ReadWrite */
    char *    status;	/**< ReadOnly */
    char *    version;	/**< ReadOnly */
    char *    PIN;	/**< ReadWrite */
    char *    X_BROADCOM_COM_Wsc_config_state;	/**< ReadWrite */
    char *    X_BROADCOM_COM_Wsc_reg;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_Wfi_enable;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_Wfi_pinmode;	/**< ReadWrite */
} Dev2WifiAccessPointWpsObject;

/*! \brief _Dev2WifiAccessPointWpsObject is used internally to represent Dev2WifiAccessPointWpsObject */
typedef Dev2WifiAccessPointWpsObject _Dev2WifiAccessPointWpsObject;



/*! \brief Obj struct for Device.WiFi.AccessPoint.{i}.AssociatedDevice.{i}.
 *
 * MDMOID_DEV2_WIFI_ASSOCIATED_DEVICE 2681
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    MACAddress;	/**< ReadOnly */
    char *    operatingStandard;	/**< ReadOnly */
    UBOOL8    authenticationState;	/**< ReadOnly */
    UINT32    lastDataDownlinkRate;	/**< ReadOnly */
    UINT32    lastDataUplinkRate;	/**< ReadOnly */
    DATETIME  associationTime;	/**< ReadOnly */
    SINT32    signalStrength;	/**< ReadOnly */
    SINT32    noise;	/**< ReadOnly */
    UINT32    retransmissions;	/**< ReadOnly */
    UBOOL8    active;	/**< ReadOnly */
    char *    X_BROADCOM_COM_BssIfname;	/**< Read */
} Dev2WifiAssociatedDeviceObject;

/*! \brief _Dev2WifiAssociatedDeviceObject is used internally to represent Dev2WifiAssociatedDeviceObject */
typedef Dev2WifiAssociatedDeviceObject _Dev2WifiAssociatedDeviceObject;



/*! \brief Obj struct for Device.WiFi.AccessPoint.{i}.AssociatedDevice.{i}.Stats.
 *
 * MDMOID_DEV2_WIFI_ASSOCIATEDDEVICE_STATS 2682
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT64    bytesSent;	/**< ReadOnly */
    UINT64    bytesReceived;	/**< ReadOnly */
    UINT64    packetsSent;	/**< ReadOnly */
    UINT64    packetsReceived;	/**< ReadOnly */
    UINT32    errorsSent;	/**< ReadOnly */
    UINT32    retransCount;	/**< ReadOnly */
    UINT32    failedRetransCount;	/**< ReadOnly */
    UINT32    retryCount;	/**< ReadOnly */
} Dev2WifiAssociateddeviceStatsObject;

/*! \brief _Dev2WifiAssociateddeviceStatsObject is used internally to represent Dev2WifiAssociateddeviceStatsObject */
typedef Dev2WifiAssociateddeviceStatsObject _Dev2WifiAssociateddeviceStatsObject;



/*! \brief Obj struct for Device.WiFi.AccessPoint.{i}.AC.{i}.
 *
 * MDMOID_DEV2_WIFI_ACCESS_POINT_AC 2683
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    accessCategory;	/**< ReadOnly */
    char *    alias;	/**< ReadWrite */
    UINT32    AIFSN;	/**< ReadWrite */
    UINT32    ECWMin;	/**< ReadWrite */
    UINT32    ECWMax;	/**< ReadWrite */
    UINT32    txOpMax;	/**< ReadWrite */
    UBOOL8    ackPolicy;	/**< ReadWrite */
    char *    outQLenHistogramIntervals;	/**< ReadWrite */
    UINT32    outQLenHistogramSampleInterval;	/**< ReadWrite */
} Dev2WifiAccessPointAcObject;

/*! \brief _Dev2WifiAccessPointAcObject is used internally to represent Dev2WifiAccessPointAcObject */
typedef Dev2WifiAccessPointAcObject _Dev2WifiAccessPointAcObject;



/*! \brief Obj struct for Device.WiFi.AccessPoint.{i}.AC.{i}.Stats.
 *
 * MDMOID_DEV2_WIFI_ACCESS_POINT_AC_STATS 2684
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT64    bytesSent;	/**< ReadOnly */
    UINT64    bytesReceived;	/**< ReadOnly */
    UINT64    packetsSent;	/**< ReadOnly */
    UINT64    packetsReceived;	/**< ReadOnly */
    UINT32    errorsSent;	/**< ReadOnly */
    UINT32    errorsReceived;	/**< ReadOnly */
    UINT32    discardPacketsSent;	/**< ReadOnly */
    UINT32    discardPacketsReceived;	/**< ReadOnly */
    UINT32    retransCount;	/**< ReadOnly */
    char *    outQLenHistogram;	/**< ReadOnly */
} Dev2WifiAccessPointAcStatsObject;

/*! \brief _Dev2WifiAccessPointAcStatsObject is used internally to represent Dev2WifiAccessPointAcStatsObject */
typedef Dev2WifiAccessPointAcStatsObject _Dev2WifiAccessPointAcStatsObject;



/*! \brief Obj struct for Device.WiFi.AccessPoint.{i}.Accounting.
 *
 * MDMOID_DEV2_WIFI_ACCESS_POINT_ACCOUNTING 2685
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    serverIPAddr;	/**< ReadWrite */
    char *    secondaryServerIPAddr;	/**< ReadWrite */
    UINT32    serverPort;	/**< ReadWrite */
    UINT32    secondaryServerPort;	/**< ReadWrite */
    char *    secret;	/**< ReadWrite */
    char *    secondarySecret;	/**< ReadWrite */
    UINT32    interimInterval;	/**< ReadWrite */
} Dev2WifiAccessPointAccountingObject;

/*! \brief _Dev2WifiAccessPointAccountingObject is used internally to represent Dev2WifiAccessPointAccountingObject */
typedef Dev2WifiAccessPointAccountingObject _Dev2WifiAccessPointAccountingObject;



/*! \brief Obj struct for Device.WiFi.EndPoint.{i}.
 *
 * MDMOID_DEV2_WIFI_END_POINT 2686
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    status;	/**< ReadOnly */
    char *    alias;	/**< ReadWrite */
    char *    profileReference;	/**< ReadWrite */
    char *    SSIDReference;	/**< ReadOnly */
    UINT32    profileNumberOfEntries;	/**< ReadOnly */
} Dev2WifiEndPointObject;

/*! \brief _Dev2WifiEndPointObject is used internally to represent Dev2WifiEndPointObject */
typedef Dev2WifiEndPointObject _Dev2WifiEndPointObject;



/*! \brief Obj struct for Device.WiFi.EndPoint.{i}.Stats.
 *
 * MDMOID_DEV2_WIFI_END_POINT_STATS 2687
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    lastDataDownlinkRate;	/**< ReadOnly */
    UINT32    lastDataUplinkRate;	/**< ReadOnly */
    SINT32    signalStrength;	/**< ReadOnly */
    UINT32    retransmissions;	/**< ReadOnly */
} Dev2WifiEndPointStatsObject;

/*! \brief _Dev2WifiEndPointStatsObject is used internally to represent Dev2WifiEndPointStatsObject */
typedef Dev2WifiEndPointStatsObject _Dev2WifiEndPointStatsObject;



/*! \brief Obj struct for Device.WiFi.EndPoint.{i}.Security.
 *
 * MDMOID_DEV2_WIFI_END_POINT_SECURITY 2688
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    modesSupported;	/**< ReadOnly */
} Dev2WifiEndPointSecurityObject;

/*! \brief _Dev2WifiEndPointSecurityObject is used internally to represent Dev2WifiEndPointSecurityObject */
typedef Dev2WifiEndPointSecurityObject _Dev2WifiEndPointSecurityObject;



/*! \brief Obj struct for Device.WiFi.EndPoint.{i}.Profile.{i}.
 *
 * MDMOID_DEV2_WIFI_END_POINT_PROFILE 2689
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    status;	/**< ReadOnly */
    char *    alias;	/**< ReadWrite */
    char *    SSID;	/**< ReadWrite */
    char *    location;	/**< ReadWrite */
    UINT32    priority;	/**< ReadWrite */
} Dev2WifiEndPointProfileObject;

/*! \brief _Dev2WifiEndPointProfileObject is used internally to represent Dev2WifiEndPointProfileObject */
typedef Dev2WifiEndPointProfileObject _Dev2WifiEndPointProfileObject;



/*! \brief Obj struct for Device.WiFi.EndPoint.{i}.Profile.{i}.Security.
 *
 * MDMOID_DEV2_WIFI_END_POINT_PROFILE_SECURITY 2690
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    modeEnabled;	/**< ReadWrite */
    HEXBINARY  WEPKey;	/**< ReadWrite */
    HEXBINARY  preSharedKey;	/**< ReadWrite */
    char *    keyPassphrase;	/**< ReadWrite */
    char *    MFPConfig;	/**< ReadWrite */
} Dev2WifiEndPointProfileSecurityObject;

/*! \brief _Dev2WifiEndPointProfileSecurityObject is used internally to represent Dev2WifiEndPointProfileSecurityObject */
typedef Dev2WifiEndPointProfileSecurityObject _Dev2WifiEndPointProfileSecurityObject;



/*! \brief Obj struct for Device.WiFi.EndPoint.{i}.WPS.
 *
 * MDMOID_DEV2_WIFI_END_POINT_WPS 2691
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    configMethodsSupported;	/**< ReadOnly */
    char *    configMethodsEnabled;	/**< ReadWrite */
    char *    status;	/**< ReadOnly */
    char *    version;	/**< ReadOnly */
    UINT32    PIN;	/**< ReadWrite */
} Dev2WifiEndPointWpsObject;

/*! \brief _Dev2WifiEndPointWpsObject is used internally to represent Dev2WifiEndPointWpsObject */
typedef Dev2WifiEndPointWpsObject _Dev2WifiEndPointWpsObject;



/*! \brief Obj struct for Device.WiFi.EndPoint.{i}.AC.{i}.
 *
 * MDMOID_DEV2_WIFI_END_POINT_AC 2692
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    accessCategory;	/**< ReadOnly */
    char *    alias;	/**< ReadWrite */
    UINT32    AIFSN;	/**< ReadWrite */
    UINT32    ECWMin;	/**< ReadWrite */
    UINT32    ECWMax;	/**< ReadWrite */
    UINT32    txOpMax;	/**< ReadWrite */
    UBOOL8    ackPolicy;	/**< ReadWrite */
    char *    outQLenHistogramIntervals;	/**< ReadWrite */
    UINT32    outQLenHistogramSampleInterval;	/**< ReadWrite */
} Dev2WifiEndPointAcObject;

/*! \brief _Dev2WifiEndPointAcObject is used internally to represent Dev2WifiEndPointAcObject */
typedef Dev2WifiEndPointAcObject _Dev2WifiEndPointAcObject;



/*! \brief Obj struct for Device.WiFi.EndPoint.{i}.AC.{i}.Stats.
 *
 * MDMOID_DEV2_WIFI_END_POINT_AC_STATS 2693
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT64    bytesSent;	/**< ReadOnly */
    UINT64    bytesReceived;	/**< ReadOnly */
    UINT64    packetsSent;	/**< ReadOnly */
    UINT64    packetsReceived;	/**< ReadOnly */
    UINT32    errorsSent;	/**< ReadOnly */
    UINT32    errorsReceived;	/**< ReadOnly */
    UINT32    discardPacketsSent;	/**< ReadOnly */
    UINT32    discardPacketsReceived;	/**< ReadOnly */
    UINT32    retransCount;	/**< ReadOnly */
    char *    outQLenHistogram;	/**< ReadOnly */
} Dev2WifiEndPointAcStatsObject;

/*! \brief _Dev2WifiEndPointAcStatsObject is used internally to represent Dev2WifiEndPointAcStatsObject */
typedef Dev2WifiEndPointAcStatsObject _Dev2WifiEndPointAcStatsObject;



/*! \brief Obj struct for Device.Bridging.
 *
 * MDMOID_DEV2_BRIDGING 1280
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    maxBridgeEntries;	/**< ReadOnly */
    UINT32    maxDBridgeEntries;	/**< ReadOnly */
#ifdef DMP_DEVICE2_VLANBRIDGE_1
    UINT32    maxQBridgeEntries;	/**< ReadOnly */
#endif
#ifdef DMP_DEVICE2_VLANBRIDGE_1
    UINT32    maxVLANEntries;	/**< ReadOnly */
#endif
#ifdef DMP_DEVICE2_BRIDGEFILTER_1
    UINT32    maxFilterEntries;	/**< ReadOnly */
#endif
    UINT32    bridgeNumberOfEntries;	/**< ReadOnly */
#ifdef DMP_DEVICE2_BRIDGEFILTER_1
    UINT32    filterNumberOfEntries;	/**< ReadOnly */
#endif
} Dev2BridgingObject;

/*! \brief _Dev2BridgingObject is used internally to represent Dev2BridgingObject */
typedef Dev2BridgingObject _Dev2BridgingObject;



/*! \brief Obj struct for Device.Bridging.Bridge.{i}.
 *
 * MDMOID_DEV2_BRIDGE 1281
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    status;	/**< ReadOnly */
    char *    alias;	/**< ReadWrite */
    char *    X_BROADCOM_COM_IfName;	/**< ReadWrite */
    char *    X_BROADCOM_COM_Type;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_Index;	/**< ReadOnly */
    SINT32    X_BROADCOM_COM_Mode;	/**< ReadWrite */
    UINT32    portNumberOfEntries;	/**< ReadOnly */
#ifdef DMP_DEVICE2_VLANBRIDGE_1
    UINT32    VLANNumberOfEntries;	/**< ReadOnly */
#endif
#ifdef DMP_DEVICE2_VLANBRIDGE_1
    UINT32    VLANPortNumberOfEntries;	/**< ReadOnly */
#endif
} Dev2BridgeObject;

/*! \brief _Dev2BridgeObject is used internally to represent Dev2BridgeObject */
typedef Dev2BridgeObject _Dev2BridgeObject;



/*! \brief Obj struct for Device.Bridging.Bridge.{i}.Port.{i}.
 *
 * MDMOID_DEV2_BRIDGE_PORT 1282
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    status;	/**< ReadOnly */
    char *    alias;	/**< ReadWrite */
    char *    name;	/**< ReadOnly */
    char *    X_BROADCOM_COM_Name;	/**< ReadWrite */
    UINT32    lastChange;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_LastChange;	/**< ReadWrite */
    char *    lowerLayers;	/**< ReadWrite */
    UBOOL8    managementPort;	/**< ReadWrite */
#ifdef DMP_DEVICE2_VLANBRIDGE_1
    UINT32    defaultUserPriority;	/**< ReadWrite */
#endif
    char *    portState;	/**< ReadOnly */
    UINT32    TPID;	/**< ReadWrite */
#ifdef DMP_DEVICE2_VLANBRIDGE_1
    UBOOL8    priorityTagging;	/**< ReadWrite */
#endif
} Dev2BridgePortObject;

/*! \brief _Dev2BridgePortObject is used internally to represent Dev2BridgePortObject */
typedef Dev2BridgePortObject _Dev2BridgePortObject;



/*! \brief Obj struct for Device.Bridging.Bridge.{i}.Port.{i}.Stats.
 *
 * MDMOID_DEV2_BRIDGE_PORT_STATS 1283
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT64    bytesSent;	/**< ReadOnly */
    UINT64    bytesReceived;	/**< ReadOnly */
    UINT64    packetsSent;	/**< ReadOnly */
    UINT64    packetsReceived;	/**< ReadOnly */
    UINT32    errorsSent;	/**< ReadOnly */
    UINT32    errorsReceived;	/**< ReadOnly */
    UINT64    unicastPacketsSent;	/**< ReadOnly */
    UINT64    unicastPacketsReceived;	/**< ReadOnly */
    UINT32    discardPacketsSent;	/**< ReadOnly */
    UINT32    discardPacketsReceived;	/**< ReadOnly */
    UINT64    multicastPacketsSent;	/**< ReadOnly */
    UINT64    multicastPacketsReceived;	/**< ReadOnly */
    UINT64    broadcastPacketsSent;	/**< ReadOnly */
    UINT64    broadcastPacketsReceived;	/**< ReadOnly */
    UINT32    unknownProtoPacketsReceived;	/**< ReadOnly */
} Dev2BridgePortStatsObject;

/*! \brief _Dev2BridgePortStatsObject is used internally to represent Dev2BridgePortStatsObject */
typedef Dev2BridgePortStatsObject _Dev2BridgePortStatsObject;



/*! \brief Obj struct for Device.Bridging.Bridge.{i}.VLAN.{i}.
 *
 * MDMOID_DEV2_BRIDGE_VLAN 1284
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    alias;	/**< ReadWrite */
    char *    name;	/**< ReadWrite */
    SINT32    VLANID;	/**< ReadWrite */
} Dev2BridgeVlanObject;

/*! \brief _Dev2BridgeVlanObject is used internally to represent Dev2BridgeVlanObject */
typedef Dev2BridgeVlanObject _Dev2BridgeVlanObject;



/*! \brief Obj struct for Device.Bridging.Bridge.{i}.VLANPort.{i}.
 *
 * MDMOID_DEV2_BRIDGE_VLAN_PORT 1285
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    alias;	/**< ReadWrite */
    char *    VLAN;	/**< ReadWrite */
    char *    port;	/**< ReadWrite */
    UBOOL8    untagged;	/**< ReadWrite */
} Dev2BridgeVlanPortObject;

/*! \brief _Dev2BridgeVlanPortObject is used internally to represent Dev2BridgeVlanPortObject */
typedef Dev2BridgeVlanPortObject _Dev2BridgeVlanPortObject;



/*! \brief Obj struct for Device.Bridging.Filter.{i}.
 *
 * MDMOID_DEV2_BRIDGE_FILTER 1286
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    alias;	/**< ReadWrite */
    char *    status;	/**< ReadOnly */
    char *    bridge;	/**< ReadWrite */
    UINT32    order;	/**< ReadWrite */
    char *    interface;	/**< ReadWrite */
#ifdef DMP_DEVICE2_BRIDGEFILTER_2
    char *    DHCPType;	/**< ReadWrite */
#endif
    UINT32    VLANIDFilter;	/**< ReadWrite */
    char *    ethertypeFilterList;	/**< ReadWrite */
    UBOOL8    ethertypeFilterExclude;	/**< ReadWrite */
    char *    sourceMACAddressFilterList;	/**< ReadWrite */
    UBOOL8    sourceMACAddressFilterExclude;	/**< ReadWrite */
    char *    destMACAddressFilterList;	/**< ReadWrite */
    UBOOL8    destMACAddressFilterExclude;	/**< ReadWrite */
    char *    sourceMACFromVendorClassIDFilter;	/**< ReadWrite */
#ifdef DMP_DEVICE2_BRIDGEFILTER_2
    HEXBINARY  sourceMACFromVendorClassIDFilterv6;	/**< ReadWrite */
#endif
    UBOOL8    sourceMACFromVendorClassIDFilterExclude;	/**< ReadWrite */
    char *    sourceMACFromVendorClassIDMode;	/**< ReadWrite */
    char *    destMACFromVendorClassIDFilter;	/**< ReadWrite */
#ifdef DMP_DEVICE2_BRIDGEFILTER_2
    HEXBINARY  destMACFromVendorClassIDFilterv6;	/**< ReadWrite */
#endif
    UBOOL8    destMACFromVendorClassIDFilterExclude;	/**< ReadWrite */
    char *    destMACFromVendorClassIDMode;	/**< ReadWrite */
    HEXBINARY  sourceMACFromClientIDFilter;	/**< ReadWrite */
    UBOOL8    sourceMACFromClientIDFilterExclude;	/**< ReadWrite */
    HEXBINARY  destMACFromClientIDFilter;	/**< ReadWrite */
    UBOOL8    destMACFromClientIDFilterExclude;	/**< ReadWrite */
    HEXBINARY  sourceMACFromUserClassIDFilter;	/**< ReadWrite */
    UBOOL8    sourceMACFromUserClassIDFilterExclude;	/**< ReadWrite */
    HEXBINARY  destMACFromUserClassIDFilter;	/**< ReadWrite */
    UBOOL8    destMACFromUserClassIDFilterExclude;	/**< ReadWrite */
#ifdef DMP_DEVICE2_BRIDGEL3L4FILTER_1
    char *    destIP;	/**< ReadWrite */
#endif
#ifdef DMP_DEVICE2_BRIDGEL3L4FILTER_1
    char *    destMask;	/**< ReadWrite */
#endif
#ifdef DMP_DEVICE2_BRIDGEL3L4FILTER_1
    UBOOL8    destIPExclude;	/**< ReadWrite */
#endif
#ifdef DMP_DEVICE2_BRIDGEL3L4FILTER_1
    char *    sourceIP;	/**< ReadWrite */
#endif
#ifdef DMP_DEVICE2_BRIDGEL3L4FILTER_1
    char *    sourceMask;	/**< ReadWrite */
#endif
#ifdef DMP_DEVICE2_BRIDGEL3L4FILTER_1
    UBOOL8    sourceIPExclude;	/**< ReadWrite */
#endif
#ifdef DMP_DEVICE2_BRIDGEL3L4FILTER_1
    SINT32    protocol;	/**< ReadWrite */
#endif
#ifdef DMP_DEVICE2_BRIDGEL3L4FILTER_1
    UBOOL8    protocolExclude;	/**< ReadWrite */
#endif
#ifdef DMP_DEVICE2_BRIDGEL3L4FILTER_1
    SINT32    destPort;	/**< ReadWrite */
#endif
    SINT32    destPortRangeMax;	/**< ReadWrite */
#ifdef DMP_DEVICE2_BRIDGEL3L4FILTER_1
    UBOOL8    destPortExclude;	/**< ReadWrite */
#endif
#ifdef DMP_DEVICE2_BRIDGEL3L4FILTER_1
    SINT32    sourcePort;	/**< ReadWrite */
#endif
#ifdef DMP_DEVICE2_BRIDGEL3L4FILTER_1
    SINT32    sourcePortRangeMax;	/**< ReadWrite */
#endif
#ifdef DMP_DEVICE2_BRIDGEL3L4FILTER_1
    UBOOL8    sourcePortExclude;	/**< ReadWrite */
#endif
} Dev2BridgeFilterObject;

/*! \brief _Dev2BridgeFilterObject is used internally to represent Dev2BridgeFilterObject */
typedef Dev2BridgeFilterObject _Dev2BridgeFilterObject;



/*! \brief Obj struct for Device.LocalAgent.
 *
 * MDMOID_DEV2_LOCALAGENT 1350
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    endpointID;	/**< ReadOnly */
    char *    softwareVersion;	/**< ReadOnly */
    UINT32    upTime;	/**< ReadOnly */
    char *    supportedProtocols;	/**< ReadOnly */
    char *    supportedFingerprintAlgorithms;	/**< ReadOnly */
    char *    advertisedDeviceSubtypes;	/**< ReadWrite */
    UINT32    maxSubscriptionChangeAdoptionTime;	/**< ReadWrite */
    char *    X_BROADCOM_COM_DualStackPreference;	/**< ReadWrite */
    UINT32    MTPNumberOfEntries;	/**< ReadOnly */
#ifdef DMP_DEVICE2_CONTROLLERS_1
    UINT32    controllerNumberOfEntries;	/**< ReadOnly */
#endif
#ifdef DMP_DEVICE2_SUBSCRIPTIONS_1
    UINT32    subscriptionNumberOfEntries;	/**< ReadOnly */
#endif
    UINT32    requestNumberOfEntries;	/**< ReadOnly */
    UINT32    certificateNumberOfEntries;	/**< ReadOnly */
} Dev2LocalagentObject;

/*! \brief _Dev2LocalagentObject is used internally to represent Dev2LocalagentObject */
typedef Dev2LocalagentObject _Dev2LocalagentObject;



/*! \brief Obj struct for Device.LocalAgent.MTP.{i}.
 *
 * MDMOID_DEV2_LOCALAGENT_MTP 1351
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    alias;	/**< ReadWrite */
    UBOOL8    enable;	/**< ReadWrite */
    char *    status;	/**< ReadOnly */
    char *    protocol;	/**< ReadWrite */
    UBOOL8    enableMDNS;	/**< ReadWrite */
} Dev2LocalagentMtpObject;

/*! \brief _Dev2LocalagentMtpObject is used internally to represent Dev2LocalagentMtpObject */
typedef Dev2LocalagentMtpObject _Dev2LocalagentMtpObject;



/*! \brief Obj struct for Device.LocalAgent.MTP.{i}.STOMP.
 *
 * MDMOID_DEV2_LOCALAGENT_MTP_STOMP 1353
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    reference;	/**< ReadWrite */
    char *    destination;	/**< ReadWrite */
    char *    destinationFromServer;	/**< ReadOnly */
} Dev2LocalagentMtpStompObject;

/*! \brief _Dev2LocalagentMtpStompObject is used internally to represent Dev2LocalagentMtpStompObject */
typedef Dev2LocalagentMtpStompObject _Dev2LocalagentMtpStompObject;



/*! \brief Obj struct for Device.LocalAgent.MTP.{i}.WebSocket.
 *
 * MDMOID_DEV2_LOCALAGENT_MTP_WEBSOCKET 1354
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    interfaces;	/**< ReadWrite */
    UINT32    port;	/**< ReadWrite */
    char *    path;	/**< ReadWrite */
    UBOOL8    enableEncryption;	/**< ReadWrite */
} Dev2LocalagentMtpWebsocketObject;

/*! \brief _Dev2LocalagentMtpWebsocketObject is used internally to represent Dev2LocalagentMtpWebsocketObject */
typedef Dev2LocalagentMtpWebsocketObject _Dev2LocalagentMtpWebsocketObject;



/*! \brief Obj struct for Device.LocalAgent.MTP.{i}.MQTT.
 *
 * MDMOID_DEV2_LOCALAGENT_MTP_MQTT 1355
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    reference;	/**< ReadWrite */
    char *    responseTopicConfigured;	/**< ReadWrite */
    char *    responseTopicDiscovered;	/**< ReadOnly */
    UINT32    publishQoS;	/**< ReadWrite */
} Dev2LocalagentMtpMqttObject;

/*! \brief _Dev2LocalagentMtpMqttObject is used internally to represent Dev2LocalagentMtpMqttObject */
typedef Dev2LocalagentMtpMqttObject _Dev2LocalagentMtpMqttObject;



/*! \brief Obj struct for Device.LocalAgent.Controller.{i}.
 *
 * MDMOID_DEV2_LOCALAGENT_CONTROLLER 1356
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    alias;	/**< ReadWrite */
    char *    endpointID;	/**< ReadWrite */
    char *    controllerCode;	/**< ReadWrite */
    char *    provisioningCode;	/**< ReadWrite */
    UBOOL8    enable;	/**< ReadWrite */
    char *    assignedRole;	/**< ReadWrite */
    char *    inheritedRole;	/**< ReadOnly */
    char *    credential;	/**< ReadWrite */
    UINT32    periodicNotifInterval;	/**< ReadWrite */
    DATETIME  periodicNotifTime;	/**< ReadWrite */
    UINT32    USPNotifRetryMinimumWaitInterval;	/**< ReadWrite */
    UINT32    USPNotifRetryIntervalMultiplier;	/**< ReadWrite */
    UINT32    bootParameterNumberOfEntries;	/**< ReadOnly */
    UINT32    MTPNumberOfEntries;	/**< ReadOnly */
} Dev2LocalagentControllerObject;

/*! \brief _Dev2LocalagentControllerObject is used internally to represent Dev2LocalagentControllerObject */
typedef Dev2LocalagentControllerObject _Dev2LocalagentControllerObject;



/*! \brief Obj struct for Device.LocalAgent.Controller.{i}.MTP.{i}.
 *
 * MDMOID_DEV2_LOCALAGENT_CONTROLLER_MTP 1357
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    alias;	/**< ReadWrite */
    UBOOL8    enable;	/**< ReadWrite */
    char *    protocol;	/**< ReadWrite */
} Dev2LocalagentControllerMtpObject;

/*! \brief _Dev2LocalagentControllerMtpObject is used internally to represent Dev2LocalagentControllerMtpObject */
typedef Dev2LocalagentControllerMtpObject _Dev2LocalagentControllerMtpObject;



/*! \brief Obj struct for Device.LocalAgent.Controller.{i}.MTP.{i}.STOMP.
 *
 * MDMOID_DEV2_LOCALAGENT_CONTROLLER_MTP_STOMP 1359
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    reference;	/**< ReadWrite */
    char *    destination;	/**< ReadWrite */
} Dev2LocalagentControllerMtpStompObject;

/*! \brief _Dev2LocalagentControllerMtpStompObject is used internally to represent Dev2LocalagentControllerMtpStompObject */
typedef Dev2LocalagentControllerMtpStompObject _Dev2LocalagentControllerMtpStompObject;



/*! \brief Obj struct for Device.LocalAgent.Controller.{i}.MTP.{i}.WebSocket.
 *
 * MDMOID_DEV2_LOCALAGENT_CONTROLLER_MTP_WEBSOCKET 1360
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    host;	/**< ReadWrite */
    UINT32    port;	/**< ReadWrite */
    char *    path;	/**< ReadWrite */
    UBOOL8    enableEncryption;	/**< ReadWrite */
    UINT32    keepAliveInterval;	/**< ReadWrite */
    UINT32    currentRetryCount;	/**< ReadOnly */
    UINT32    sessionRetryMinimumWaitInterval;	/**< ReadWrite */
    UINT32    sessionRetryIntervalMultiplier;	/**< ReadWrite */
} Dev2LocalagentControllerMtpWebsocketObject;

/*! \brief _Dev2LocalagentControllerMtpWebsocketObject is used internally to represent Dev2LocalagentControllerMtpWebsocketObject */
typedef Dev2LocalagentControllerMtpWebsocketObject _Dev2LocalagentControllerMtpWebsocketObject;



/*! \brief Obj struct for Device.LocalAgent.Controller.{i}.MTP.{i}.MQTT.
 *
 * MDMOID_DEV2_LOCALAGENT_CONTROLLER_MTP_MQTT 1361
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    reference;	/**< ReadWrite */
    char *    topic;	/**< ReadWrite */
    UBOOL8    publishRetainResponse;	/**< ReadWrite */
    UBOOL8    publishRetainNotify;	/**< ReadWrite */
} Dev2LocalagentControllerMtpMqttObject;

/*! \brief _Dev2LocalagentControllerMtpMqttObject is used internally to represent Dev2LocalagentControllerMtpMqttObject */
typedef Dev2LocalagentControllerMtpMqttObject _Dev2LocalagentControllerMtpMqttObject;



/*! \brief Obj struct for Device.LocalAgent.Controller.{i}.TransferCompletePolicy.
 *
 * MDMOID_DEV2_LOCALAGENT_CONTROLLER_TRANSFERCOMPLETEPOLICY 1362
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    resultTypeFilter;	/**< ReadWrite */
} Dev2LocalagentControllerTransfercompletepolicyObject;

/*! \brief _Dev2LocalagentControllerTransfercompletepolicyObject is used internally to represent Dev2LocalagentControllerTransfercompletepolicyObject */
typedef Dev2LocalagentControllerTransfercompletepolicyObject _Dev2LocalagentControllerTransfercompletepolicyObject;



/*! \brief Obj struct for Device.LocalAgent.Controller.{i}.BootParameter.{i}.
 *
 * MDMOID_DEV2_LOCALAGENT_CONTROLLER_BOOTPARAMETER 1363
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    alias;	/**< ReadWrite */
#ifdef DMP_DEVICE2_REBOOT_1
    UBOOL8    enable;	/**< ReadWrite */
#endif
#ifdef DMP_DEVICE2_REBOOT_1
    char *    parameterName;	/**< ReadWrite */
#endif
} Dev2LocalagentControllerBootparameterObject;

/*! \brief _Dev2LocalagentControllerBootparameterObject is used internally to represent Dev2LocalagentControllerBootparameterObject */
typedef Dev2LocalagentControllerBootparameterObject _Dev2LocalagentControllerBootparameterObject;



/*! \brief Obj struct for Device.LocalAgent.Controller.{i}.E2ESession.
 *
 * MDMOID_DEV2_LOCALAGENT_CONTROLLER_E2ESESSION 1364
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    sessionMode;	/**< ReadWrite */
    char *    status;	/**< ReadOnly */
    UINT32    sessionExpiration;	/**< ReadWrite */
    UINT32    sessionRetryMinimumWaitInterval;	/**< ReadWrite */
    UINT32    sessionRetryIntervalMultiplier;	/**< ReadWrite */
    UINT32    currentRetryCount;	/**< ReadOnly */
    UINT32    segmentedPayloadChunkSize;	/**< ReadWrite */
    SINT32    maxRetransmitTries;	/**< ReadWrite */
    char *    payloadSecurity;	/**< ReadWrite */
} Dev2LocalagentControllerE2esessionObject;

/*! \brief _Dev2LocalagentControllerE2esessionObject is used internally to represent Dev2LocalagentControllerE2esessionObject */
typedef Dev2LocalagentControllerE2esessionObject _Dev2LocalagentControllerE2esessionObject;



/*! \brief Obj struct for Device.LocalAgent.Subscription.{i}.
 *
 * MDMOID_DEV2_LOCALAGENT_SUBSCRIPTION 1365
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    alias;	/**< ReadWrite */
    UBOOL8    enable;	/**< ReadWrite */
    char *    recipient;	/**< ReadOnly */
    char *    ID;	/**< ReadWrite */
    DATETIME  creationDate;	/**< ReadOnly */
    char *    notifType;	/**< ReadWrite */
    char *    referenceList;	/**< ReadWrite */
    UBOOL8    persistent;	/**< ReadWrite */
    UINT32    timeToLive;	/**< ReadWrite */
    UBOOL8    notifRetry;	/**< ReadWrite */
    UINT32    notifExpiration;	/**< ReadWrite */
} Dev2LocalagentSubscriptionObject;

/*! \brief _Dev2LocalagentSubscriptionObject is used internally to represent Dev2LocalagentSubscriptionObject */
typedef Dev2LocalagentSubscriptionObject _Dev2LocalagentSubscriptionObject;



/*! \brief Obj struct for Device.LocalAgent.Request.{i}.
 *
 * MDMOID_DEV2_LOCALAGENT_REQUEST 1366
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    alias;	/**< ReadWrite */
    char *    originator;	/**< ReadOnly */
    char *    command;	/**< ReadOnly */
    char *    commandKey;	/**< ReadOnly */
    char *    status;	/**< ReadOnly */
} Dev2LocalagentRequestObject;

/*! \brief _Dev2LocalagentRequestObject is used internally to represent Dev2LocalagentRequestObject */
typedef Dev2LocalagentRequestObject _Dev2LocalagentRequestObject;



/*! \brief Obj struct for Device.LocalAgent.Request.{i}.X_BROADCOM_COM_InputArgs.{i}.
 *
 * MDMOID_DEV2_LOCALAGENT_REQUEST_ARGS 1367
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    name;	/**< ReadOnly */
    char *    value;	/**< ReadOnly */
} Dev2LocalagentRequestArgsObject;

/*! \brief _Dev2LocalagentRequestArgsObject is used internally to represent Dev2LocalagentRequestArgsObject */
typedef Dev2LocalagentRequestArgsObject _Dev2LocalagentRequestArgsObject;



/*! \brief Obj struct for Device.LocalAgent.Certificate.{i}.
 *
 * MDMOID_DEV2_LOCALAGENT_CERTIFICATE 1368
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    alias;	/**< ReadWrite */
    UBOOL8    enable;	/**< ReadWrite */
    char *    serialNumber;	/**< ReadOnly */
    char *    issuer;	/**< ReadOnly */
    char *    X_BROADCOM_COM_AltName;	/**< ReadOnly */
} Dev2LocalagentCertificateObject;

/*! \brief _Dev2LocalagentCertificateObject is used internally to represent Dev2LocalagentCertificateObject */
typedef Dev2LocalagentCertificateObject _Dev2LocalagentCertificateObject;



/*! \brief Obj struct for Device.LocalAgent.ControllerTrust.
 *
 * MDMOID_DEV2_LOCALAGENT_CONTROLLERTRUST 1369
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    untrustedRole;	/**< ReadWrite */
    char *    bannedRole;	/**< ReadWrite */
    UBOOL8    TOFUAllowed;	/**< ReadWrite */
    UINT32    TOFUInactivityTimer;	/**< ReadWrite */
    UINT32    roleNumberOfEntries;	/**< ReadOnly */
    UINT32    credentialNumberOfEntries;	/**< ReadOnly */
#ifdef DMP_DEVICE2_CHALLENGE_1
    UINT32    challengeNumberOfEntries;	/**< ReadOnly */
#endif
} Dev2LocalagentControllertrustObject;

/*! \brief _Dev2LocalagentControllertrustObject is used internally to represent Dev2LocalagentControllertrustObject */
typedef Dev2LocalagentControllertrustObject _Dev2LocalagentControllertrustObject;



/*! \brief Obj struct for Device.LocalAgent.ControllerTrust.Role.{i}.
 *
 * MDMOID_DEV2_LOCALAGENT_CONTROLLERTRUST_ROLE 1370
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    alias;	/**< ReadWrite */
    UBOOL8    enable;	/**< ReadWrite */
    char *    name;	/**< ReadWrite */
    UINT32    permissionNumberOfEntries;	/**< ReadOnly */
} Dev2LocalagentControllertrustRoleObject;

/*! \brief _Dev2LocalagentControllertrustRoleObject is used internally to represent Dev2LocalagentControllertrustRoleObject */
typedef Dev2LocalagentControllertrustRoleObject _Dev2LocalagentControllertrustRoleObject;



/*! \brief Obj struct for Device.LocalAgent.ControllerTrust.Role.{i}.Permission.{i}.
 *
 * MDMOID_DEV2_LOCALAGENT_CONTROLLERTRUST_ROLE_PERMISSION 1371
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    alias;	/**< ReadWrite */
    UBOOL8    enable;	/**< ReadWrite */
    UINT32    order;	/**< ReadWrite */
    char *    targets;	/**< ReadWrite */
    char *    param;	/**< ReadWrite */
    char *    obj;	/**< ReadWrite */
    char *    instantiatedObj;	/**< ReadWrite */
    char *    commandEvent;	/**< ReadWrite */
} Dev2LocalagentControllertrustRolePermissionObject;

/*! \brief _Dev2LocalagentControllertrustRolePermissionObject is used internally to represent Dev2LocalagentControllertrustRolePermissionObject */
typedef Dev2LocalagentControllertrustRolePermissionObject _Dev2LocalagentControllertrustRolePermissionObject;



/*! \brief Obj struct for Device.LocalAgent.ControllerTrust.Credential.{i}.
 *
 * MDMOID_DEV2_LOCALAGENT_CONTROLLERTRUST_CREDENTIAL 1372
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    alias;	/**< ReadWrite */
    UBOOL8    enable;	/**< ReadWrite */
    char *    role;	/**< ReadWrite */
    char *    credential;	/**< ReadWrite */
    char *    allowedUses;	/**< ReadWrite */
} Dev2LocalagentControllertrustCredentialObject;

/*! \brief _Dev2LocalagentControllertrustCredentialObject is used internally to represent Dev2LocalagentControllertrustCredentialObject */
typedef Dev2LocalagentControllertrustCredentialObject _Dev2LocalagentControllertrustCredentialObject;



/*! \brief Obj struct for Device.LocalAgent.ControllerTrust.Challenge.{i}.
 *
 * MDMOID_DEV2_LOCALAGENT_CONTROLLERTRUST_CHALLENGE 1373
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    alias;	/**< ReadWrite */
    char *    description;	/**< ReadWrite */
    char *    role;	/**< ReadWrite */
    UBOOL8    enable;	/**< ReadWrite */
    char *    type;	/**< ReadWrite */
    BASE64    value;	/**< ReadWrite */
    char *    valueType;	/**< ReadWrite */
    BASE64    instruction;	/**< ReadWrite */
    char *    instructionType;	/**< ReadWrite */
    UINT32    retries;	/**< ReadWrite */
    SINT32    lockoutPeriod;	/**< ReadWrite */
} Dev2LocalagentControllertrustChallengeObject;

/*! \brief _Dev2LocalagentControllertrustChallengeObject is used internally to represent Dev2LocalagentControllertrustChallengeObject */
typedef Dev2LocalagentControllertrustChallengeObject _Dev2LocalagentControllertrustChallengeObject;



/*! \brief Obj struct for Device.IP.Diagnostics.
 *
 * MDMOID_DEV2_IP_DIAGNOSTICS 1410
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    IPv4PingSupported;	/**< ReadOnly */
    UBOOL8    IPv6PingSupported;	/**< ReadWrite */
    UBOOL8    IPv4TraceRouteSupported;	/**< ReadOnly */
    UBOOL8    IPv6TraceRouteSupported;	/**< ReadOnly */
#ifdef DMP_DEVICE2_DOWNLOAD_1
    char *    downloadTransports;	/**< ReadOnly */
#endif
#ifdef DMP_DEVICE2_DOWNLOAD_1
    UBOOL8    IPv4DownloadDiagnosticsSupported;	/**< ReadOnly */
#endif
#ifdef DMP_DEVICE2_DOWNLOAD_1
    UBOOL8    IPv6DownloadDiagnosticsSupported;	/**< ReadOnly */
#endif
#ifdef DMP_DEVICE2_UPLOAD_1
    UBOOL8    IPv4UploadDiagnosticsSupported;	/**< ReadOnly */
#endif
#ifdef DMP_DEVICE2_UPLOAD_1
    UBOOL8    IPv6UploadDiagnosticsSupported;	/**< ReadOnly */
#endif
#ifdef DMP_DEVICE2_UPLOAD_1
    char *    uploadTransports;	/**< ReadOnly */
#endif
    UBOOL8    IPv4UDPEchoDiagnosticsSupported;	/**< ReadOnly */
    UBOOL8    IPv6UDPEchoDiagnosticsSupported;	/**< ReadOnly */
#ifdef DMP_DEVICE2_IPLAYERCAPACITYTEST_1
    UBOOL8    IPLayerCapacitySupported;	/**< ReadOnly */
#endif
    UBOOL8    IPv4ServerSelectionDiagnosticsSupported;	/**< ReadOnly */
    UBOOL8    IPv6ServerSelectionDiagnosticsSupported;	/**< ReadOnly */
} Dev2IpDiagnosticsObject;

/*! \brief _Dev2IpDiagnosticsObject is used internally to represent Dev2IpDiagnosticsObject */
typedef Dev2IpDiagnosticsObject _Dev2IpDiagnosticsObject;



/*! \brief Obj struct for Device.IP.Diagnostics.IPPing.
 *
 * MDMOID_DEV2_IP_PING_DIAG 1411
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    diagnosticsState;	/**< ReadWrite */
    char *    interface;	/**< ReadWrite */
    char *    protocolVersion;	/**< ReadWrite */
    char *    host;	/**< ReadWrite */
    UINT32    numberOfRepetitions;	/**< ReadWrite */
    UINT32    timeout;	/**< ReadWrite */
    UINT32    dataBlockSize;	/**< ReadWrite */
    UINT32    DSCP;	/**< ReadWrite */
    UINT32    successCount;	/**< ReadOnly */
    UINT32    failureCount;	/**< ReadOnly */
    UINT32    averageResponseTime;	/**< ReadOnly */
    UINT32    minimumResponseTime;	/**< ReadOnly */
    UINT32    maximumResponseTime;	/**< ReadOnly */
    SINT32    X_BROADCOM_COM_Pid;	/**< ReadOnly */
} Dev2IpPingDiagObject;

/*! \brief _Dev2IpPingDiagObject is used internally to represent Dev2IpPingDiagObject */
typedef Dev2IpPingDiagObject _Dev2IpPingDiagObject;



/*! \brief Obj struct for Device.IP.Diagnostics.TraceRoute.
 *
 * MDMOID_DEV2_IP_DIAG_TRACE_ROUTE 1412
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    diagnosticsState;	/**< ReadWrite */
    char *    interface;	/**< ReadWrite */
    char *    host;	/**< ReadWrite */
    UINT32    numberOfTries;	/**< ReadWrite */
    UINT32    timeout;	/**< ReadWrite */
    UINT32    dataBlockSize;	/**< ReadWrite */
    UINT32    DSCP;	/**< ReadWrite */
    UINT32    maxHopCount;	/**< ReadWrite */
    UINT32    responseTime;	/**< ReadOnly */
    UINT32    routeHopsNumberOfEntries;	/**< ReadOnly */
    SINT32    X_BROADCOM_COM_Pid;	/**< ReadOnly */
} Dev2IpDiagTraceRouteObject;

/*! \brief _Dev2IpDiagTraceRouteObject is used internally to represent Dev2IpDiagTraceRouteObject */
typedef Dev2IpDiagTraceRouteObject _Dev2IpDiagTraceRouteObject;



/*! \brief Obj struct for Device.IP.Diagnostics.TraceRoute.RouteHops.{i}.
 *
 * MDMOID_DEV2_IP_DIAG_TRACE_ROUTE_ROUTE_HOPS 1413
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    host;	/**< ReadOnly */
    char *    hostAddress;	/**< ReadOnly */
    UINT32    errorCode;	/**< ReadOnly */
    char *    RTTimes;	/**< ReadOnly */
} Dev2IpDiagTraceRouteRouteHopsObject;

/*! \brief _Dev2IpDiagTraceRouteRouteHopsObject is used internally to represent Dev2IpDiagTraceRouteRouteHopsObject */
typedef Dev2IpDiagTraceRouteRouteHopsObject _Dev2IpDiagTraceRouteRouteHopsObject;



/*! \brief Obj struct for Device.IP.Diagnostics.DownloadDiagnostics.
 *
 * MDMOID_DEV2_IP_DIAG_DOWNLOAD 1414
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    diagnosticsState;	/**< ReadWrite */
    char *    interface;	/**< ReadWrite */
    char *    downloadURL;	/**< ReadWrite */
    char *    downloadTransports;	/**< ReadOnly */
    UINT32    downloadDiagnosticsMaxConnections;	/**< ReadOnly */
    UINT32    DSCP;	/**< ReadWrite */
    UINT32    ethernetPriority;	/**< ReadWrite */
    UINT32    numberOfConnections;	/**< ReadWrite */
    char *    IPAddressUsed;	/**< ReadOnly */
    DATETIME  ROMTime;	/**< ReadOnly */
    DATETIME  BOMTime;	/**< ReadOnly */
    DATETIME  EOMTime;	/**< ReadOnly */
    UINT32    testBytesReceived;	/**< ReadOnly */
    UINT32    totalBytesReceived;	/**< ReadOnly */
    UINT32    totalBytesSent;	/**< ReadOnly */
    UINT32    periodOfFullLoading;	/**< ReadOnly */
#ifdef DMP_DEVICE2_DOWNLOADTCP_1
    DATETIME  TCPOpenRequestTime;	/**< ReadOnly */
#endif
#ifdef DMP_DEVICE2_DOWNLOADTCP_1
    DATETIME  TCPOpenResponseTime;	/**< ReadOnly */
#endif
    UINT32    perConnectionResultNumberOfEntries;	/**< ReadOnly */
    UBOOL8    enablePerConnectionResults;	/**< ReadWrite */
#ifdef DMP_X_BROADCOM_COM_BASELINE_1
    UINT32    X_BROADCOM_COM_LogLevel;	/**< ReadWrite */
#endif
    SINT32    X_BROADCOM_COM_Pid;	/**< ReadOnly */
    UBOOL8    X_BROADCOM_COM_UserStop;	/**< ReadOnly */
} Dev2IpDiagDownloadObject;

/*! \brief _Dev2IpDiagDownloadObject is used internally to represent Dev2IpDiagDownloadObject */
typedef Dev2IpDiagDownloadObject _Dev2IpDiagDownloadObject;



/*! \brief Obj struct for Device.IP.Diagnostics.DownloadDiagnostics.PerConnectionResult.{i}.
 *
 * MDMOID_DEV2_DOWNLOAD_PER_CONN_RESULT 1415
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    DATETIME  ROMTime;	/**< ReadOnly */
    DATETIME  BOMTime;	/**< ReadOnly */
    DATETIME  EOMTime;	/**< ReadOnly */
    UINT32    testBytesReceived;	/**< ReadOnly */
    UINT32    totalBytesReceived;	/**< ReadOnly */
    UINT32    totalBytesSent;	/**< ReadOnly */
    DATETIME  TCPOpenRequestTime;	/**< ReadOnly */
    DATETIME  TCPOpenResponseTime;	/**< ReadOnly */
} Dev2DownloadPerConnResultObject;

/*! \brief _Dev2DownloadPerConnResultObject is used internally to represent Dev2DownloadPerConnResultObject */
typedef Dev2DownloadPerConnResultObject _Dev2DownloadPerConnResultObject;



/*! \brief Obj struct for Device.IP.Diagnostics.UploadDiagnostics.
 *
 * MDMOID_DEV2_IP_DIAG_UPLOAD 1417
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    diagnosticsState;	/**< ReadWrite */
    char *    interface;	/**< ReadWrite */
    char *    uploadURL;	/**< ReadWrite */
    char *    uploadTransports;	/**< ReadOnly */
    UINT32    uploadDiagnosticsMaxConnections;	/**< ReadOnly */
    UINT32    DSCP;	/**< ReadWrite */
    UINT32    ethernetPriority;	/**< ReadWrite */
    UINT32    testFileLength;	/**< ReadWrite */
    UINT32    numberOfConnections;	/**< ReadWrite */
    char *    IPAddressUsed;	/**< ReadOnly */
    DATETIME  ROMTime;	/**< ReadOnly */
    DATETIME  BOMTime;	/**< ReadOnly */
    DATETIME  EOMTime;	/**< ReadOnly */
    UINT32    testBytesSent;	/**< ReadOnly */
    UINT32    totalBytesReceived;	/**< ReadOnly */
    UINT32    totalBytesSent;	/**< ReadOnly */
#ifdef DMP_DEVICE2_UPLOADTCP_1
    DATETIME  TCPOpenRequestTime;	/**< ReadOnly */
#endif
#ifdef DMP_DEVICE2_UPLOADTCP_1
    DATETIME  TCPOpenResponseTime;	/**< ReadOnly */
#endif
    UINT32    perConnectionResultNumberOfEntries;	/**< ReadOnly */
    UBOOL8    enablePerConnectionResults;	/**< ReadWrite */
#ifdef DMP_X_BROADCOM_COM_BASELINE_1
    UINT32    X_BROADCOM_COM_LogLevel;	/**< ReadWrite */
#endif
    SINT32    X_BROADCOM_COM_Pid;	/**< ReadOnly */
    UBOOL8    X_BROADCOM_COM_UserStop;	/**< ReadOnly */
} Dev2IpDiagUploadObject;

/*! \brief _Dev2IpDiagUploadObject is used internally to represent Dev2IpDiagUploadObject */
typedef Dev2IpDiagUploadObject _Dev2IpDiagUploadObject;



/*! \brief Obj struct for Device.IP.Diagnostics.UploadDiagnostics.PerConnectionResult.{i}.
 *
 * MDMOID_DEV2_UPLOAD_PER_CONN_RESULT 1418
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    DATETIME  ROMTime;	/**< ReadOnly */
    DATETIME  BOMTime;	/**< ReadOnly */
    DATETIME  EOMTime;	/**< ReadOnly */
    UINT32    testBytesSent;	/**< ReadOnly */
    UINT32    totalBytesReceived;	/**< ReadOnly */
    UINT32    totalBytesSent;	/**< ReadOnly */
    DATETIME  TCPOpenRequestTime;	/**< ReadOnly */
    DATETIME  TCPOpenResponseTime;	/**< ReadOnly */
} Dev2UploadPerConnResultObject;

/*! \brief _Dev2UploadPerConnResultObject is used internally to represent Dev2UploadPerConnResultObject */
typedef Dev2UploadPerConnResultObject _Dev2UploadPerConnResultObject;



/*! \brief Obj struct for Device.IP.Diagnostics.UDPEchoConfig.
 *
 * MDMOID_UDP_ECHO_CONFIG 1420
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    interface;	/**< ReadWrite */
    IPADDRESS  sourceIPAddress;	/**< ReadWrite */
    UINT32    UDPPort;	/**< ReadWrite */
#ifdef DMP_DEVICE2_UDPECHOPLUS_1
    UBOOL8    echoPlusEnabled;	/**< ReadWrite */
#endif
    UBOOL8    echoPlusSupported;	/**< ReadOnly */
    UINT32    packetsReceived;	/**< ReadOnly */
    UINT32    packetsResponded;	/**< ReadOnly */
#ifdef DMP_X_BROADCOM_COM_BASELINE_1
    UINT32    X_BROADCOM_COM_PacketsRespondedFail;	/**< ReadOnly */
#endif
    UINT32    bytesReceived;	/**< ReadOnly */
    UINT32    bytesResponded;	/**< ReadOnly */
    DATETIME  timeFirstPacketReceived;	/**< ReadOnly */
    DATETIME  timeLastPacketReceived;	/**< ReadOnly */
#ifdef DMP_X_BROADCOM_COM_BASELINE_1
    UINT32    X_BROADCOM_COM_LogLevel;	/**< ReadWrite */
#endif
    SINT32    X_BROADCOM_COM_Pid;	/**< ReadOnly */
} Dev2IpDiagUDPEchoConfigObject;

/*! \brief _Dev2IpDiagUDPEchoConfigObject is used internally to represent Dev2IpDiagUDPEchoConfigObject */
typedef Dev2IpDiagUDPEchoConfigObject _Dev2IpDiagUDPEchoConfigObject;



/*! \brief Obj struct for Device.IP.Diagnostics.UDPEchoDiagnostics.
 *
 * MDMOID_UDP_ECHO_DIAG 1421
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    diagnosticsState;	/**< ReadWrite */
    char *    interface;	/**< ReadWrite */
    char *    host;	/**< ReadWrite */
    UINT32    port;	/**< ReadWrite */
    UINT32    numberOfRepetitions;	/**< ReadWrite */
    UINT32    timeout;	/**< ReadWrite */
    UINT32    dataBlockSize;	/**< ReadWrite */
    UINT32    DSCP;	/**< ReadWrite */
    UINT32    interTransmissionTime;	/**< ReadWrite */
    char *    protocolVersion;	/**< ReadWrite */
    char *    IPAddressUsed;	/**< ReadOnly */
    UINT32    successCount;	/**< ReadOnly */
    UINT32    failureCount;	/**< ReadOnly */
    UINT32    averageResponseTime;	/**< ReadOnly */
    UINT32    minimumResponseTime;	/**< ReadOnly */
    UINT32    maximumResponseTime;	/**< ReadOnly */
    UBOOL8    enableIndividualPacketResults;	/**< ReadWrite */
    UINT32    individualPacketResultNumberOfEntries;	/**< ReadOnly */
#ifdef DMP_X_BROADCOM_COM_BASELINE_1
    UINT32    X_BROADCOM_COM_LogLevel;	/**< ReadWrite */
#endif
    SINT32    X_BROADCOM_COM_Pid;	/**< ReadOnly */
    UBOOL8    X_BROADCOM_COM_UserStop;	/**< ReadOnly */
} Dev2UDPEchoDiagObject;

/*! \brief _Dev2UDPEchoDiagObject is used internally to represent Dev2UDPEchoDiagObject */
typedef Dev2UDPEchoDiagObject _Dev2UDPEchoDiagObject;



/*! \brief Obj struct for Device.IP.Diagnostics.IPLayerCapacityMetrics.
 *
 * MDMOID_IP_CAP 1422
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    diagnosticsState;	/**< ReadWrite */
    UINT32    IPLayerMaxConnections;	/**< ReadOnly */
    UINT32    IPLayerMaxIncrementalResult;	/**< ReadOnly */
    char *    IPLayerCapSupportedSoftwareVersion;	/**< ReadOnly */
    char *    IPLayerCapSupportedControlProtocolVersion;	/**< ReadOnly */
    char *    IPLayerCapSupportedMetrics;	/**< ReadOnly */
    char *    interface;	/**< ReadWrite */
    char *    role;	/**< ReadWrite */
    char *    host;	/**< ReadWrite */
    UINT32    port;	/**< ReadWrite */
    UBOOL8    jumboFramesPermitted;	/**< ReadWrite */
    UINT32    numberOfConnections;	/**< ReadWrite */
    UINT32    ethernetPriority;	/**< ReadWrite */
    UINT32    DSCP;	/**< ReadWrite */
    char *    protocolVersion;	/**< ReadWrite */
    UINT32    UDPPayloadMin;	/**< ReadWrite */
    UINT32    UDPPayloadMax;	/**< ReadWrite */
    char *    UDPPayloadContent;	/**< ReadWrite */
    UINT32    portMin;	/**< ReadWrite */
    UINT32    portMax;	/**< ReadWrite */
    UINT32    portOptionalMin;	/**< ReadWrite */
    UINT32    portOptionalMax;	/**< ReadWrite */
    char *    testType;	/**< ReadWrite */
    UBOOL8    IPDVEnable;	/**< ReadWrite */
    UBOOL8    IPRREnable;	/**< ReadWrite */
    UBOOL8    RIPREnable;	/**< ReadWrite */
    UINT32    preambleDuration;	/**< ReadWrite */
    UINT32    startSendingRate;	/**< ReadWrite */
    UINT32    numberTestSubIntervals;	/**< ReadWrite */
    UINT32    numberFirstModeTestSubIntervals;	/**< ReadWrite */
    UINT32    testSubInterval;	/**< ReadWrite */
    UINT32    statusFeedbackInterval;	/**< ReadWrite */
    UINT32    timeoutNoTraffic;	/**< ReadWrite */
    UINT32    timeoutNoTestTraffic;	/**< ReadWrite */
    UINT32    timeoutNoStatusMessage;	/**< ReadWrite */
    UINT32    tmax;	/**< ReadWrite */
    UINT32    tmaxRTT;	/**< ReadWrite */
    UINT32    timestampResolution;	/**< ReadWrite */
    UINT32    seqErrThresh;	/**< ReadWrite */
    UBOOL8    reordDupIgnoreEnable;	/**< ReadWrite */
    UINT32    lowerThresh;	/**< ReadWrite */
    UINT32    upperThresh;	/**< ReadWrite */
    UINT32    highSpeedDelta;	/**< ReadWrite */
    UINT32    slowAdjThresh;	/**< ReadWrite */
    UINT32    HSpeedThresh;	/**< ReadWrite */
    DATETIME  BOMTime;	/**< ReadOnly */
    DATETIME  EOMTime;	/**< ReadOnly */
    UINT32    tmaxUsed;	/**< ReadOnly */
    UINT32    testInterval;	/**< ReadOnly */
    DECIMAL    maxIPLayerCapacity;	/**< ReadOnly */
    DATETIME  timeOfMax;	/**< ReadOnly */
    DECIMAL    maxETHCapacityNoFCS;	/**< ReadOnly */
    DECIMAL    maxETHCapacityWithFCS;	/**< ReadOnly */
    DECIMAL    maxETHCapacityWithFCSVLAN;	/**< ReadOnly */
    DECIMAL    lossRatioAtMax;	/**< ReadOnly */
    DECIMAL    RTTRangeAtMax;	/**< ReadOnly */
    DECIMAL    PDVRangeAtMax;	/**< ReadOnly */
    DECIMAL    minOnewayDelayAtMax;	/**< ReadOnly */
    DECIMAL    reorderedRatioAtMax;	/**< ReadOnly */
    DECIMAL    replicatedRatioAtMax;	/**< ReadOnly */
    DECIMAL    interfaceEthMbpsAtMax;	/**< ReadOnly */
    DECIMAL    IPLayerCapacitySummary;	/**< ReadOnly */
    DECIMAL    lossRatioSummary;	/**< ReadOnly */
    DECIMAL    RTTRangeSummary;	/**< ReadOnly */
    DECIMAL    PDVRangeSummary;	/**< ReadOnly */
    DECIMAL    minOnewayDelaySummary;	/**< ReadOnly */
    DECIMAL    minRTTSummary;	/**< ReadOnly */
    DECIMAL    reorderedRatioSummary;	/**< ReadOnly */
    DECIMAL    replicatedRatioSummary;	/**< ReadOnly */
    DECIMAL    interfaceEthMbpsSummary;	/**< ReadOnly */
    UINT32    incrementalResultNumberOfEntries;	/**< ReadOnly */
    UINT32    modalResultNumberOfEntries;	/**< ReadOnly */
    UINT32    tmaxRTTUsed;	/**< ReadOnly */
    UINT32    timestampResolutionUsed;	/**< ReadOnly */
    SINT32    X_BROADCOM_COM_Pid;	/**< ReadOnly */
} Dev2IpDiagIPCapObject;

/*! \brief _Dev2IpDiagIPCapObject is used internally to represent Dev2IpDiagIPCapObject */
typedef Dev2IpDiagIPCapObject _Dev2IpDiagIPCapObject;



/*! \brief Obj struct for Device.IP.Diagnostics.IPLayerCapacityMetrics.ModalResult.{i}.
 *
 * MDMOID_IP_CAP_MOD_RES 1423
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    DECIMAL    maxIPLayerCapacity;	/**< ReadOnly */
    DATETIME  timeOfMax;	/**< ReadOnly */
    DECIMAL    maxETHCapacityNoFCS;	/**< ReadOnly */
    DECIMAL    maxETHCapacityWithFCS;	/**< ReadOnly */
    DECIMAL    maxETHCapacityWithFCSVLAN;	/**< ReadOnly */
    DECIMAL    lossRatioAtMax;	/**< ReadOnly */
    DECIMAL    RTTRangeAtMax;	/**< ReadOnly */
    DECIMAL    PDVRangeAtMax;	/**< ReadOnly */
    DECIMAL    minOnewayDelayAtMax;	/**< ReadOnly */
    DECIMAL    reorderedRatioAtMax;	/**< ReadOnly */
    DECIMAL    replicatedRatioAtMax;	/**< ReadOnly */
    DECIMAL    interfaceEthMbpsAtMax;	/**< ReadOnly */
} Dev2IpDiagIPCapModResObject;

/*! \brief _Dev2IpDiagIPCapModResObject is used internally to represent Dev2IpDiagIPCapModResObject */
typedef Dev2IpDiagIPCapModResObject _Dev2IpDiagIPCapModResObject;



/*! \brief Obj struct for Device.IP.Diagnostics.IPLayerCapacityMetrics.IncrementalResult.{i}.
 *
 * MDMOID_IP_CAP_INC_RES 1424
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    DECIMAL    IPLayerCapacity;	/**< ReadOnly */
    DATETIME  timeOfSubInterval;	/**< ReadOnly */
    DECIMAL    lossRatio;	/**< ReadOnly */
    DECIMAL    RTTRange;	/**< ReadOnly */
    DECIMAL    PDVRange;	/**< ReadOnly */
    DECIMAL    minOnewayDelay;	/**< ReadOnly */
    DECIMAL    reorderedRatio;	/**< ReadOnly */
    DECIMAL    replicatedRatio;	/**< ReadOnly */
    DECIMAL    interfaceEthMbps;	/**< ReadOnly */
} Dev2IpDiagIPCapIncResObject;

/*! \brief _Dev2IpDiagIPCapIncResObject is used internally to represent Dev2IpDiagIPCapIncResObject */
typedef Dev2IpDiagIPCapIncResObject _Dev2IpDiagIPCapIncResObject;



/*! \brief Obj struct for Device.IP.Diagnostics.ServerSelectionDiagnostics.
 *
 * MDMOID_DEV2_IP_DIAG_SERVER_SELECTION 1425
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    diagnosticsState;	/**< ReadWrite */
    char *    interface;	/**< ReadWrite */
    char *    protocolVersion;	/**< ReadWrite */
    char *    protocol;	/**< ReadWrite */
    char *    hostList;	/**< ReadWrite */
    UINT32    numberOfRepetitions;	/**< ReadWrite */
    UINT32    timeout;	/**< ReadWrite */
    char *    fastestHost;	/**< ReadOnly */
    UINT32    minimumResponseTime;	/**< ReadOnly */
    UINT32    averageResponseTime;	/**< ReadOnly */
    UINT32    maximumResponseTime;	/**< ReadOnly */
    IPADDRESS  IPAddressUsed;	/**< ReadOnly */
    SINT32    X_BROADCOM_COM_Pid;	/**< ReadOnly */
} Dev2IpDiagServerSelectionObject;

/*! \brief _Dev2IpDiagServerSelectionObject is used internally to represent Dev2IpDiagServerSelectionObject */
typedef Dev2IpDiagServerSelectionObject _Dev2IpDiagServerSelectionObject;



/*! \brief Obj struct for Device.IPsec.
 *
 * MDMOID_DEV2_IPSEC 1430
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    status;	/**< ReadOnly */
    UINT32    filterNumberOfEntries;	/**< ReadOnly */
    UINT32    profileNumberOfEntries;	/**< ReadOnly */
} Dev2IpsecObject;

/*! \brief _Dev2IpsecObject is used internally to represent Dev2IpsecObject */
typedef Dev2IpsecObject _Dev2IpsecObject;



/*! \brief Obj struct for Device.IPsec.Filter.{i}.
 *
 * MDMOID_DEV2_IPSEC_FILTER 1432
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    status;	/**< ReadOnly */
    UINT32    order;	/**< ReadWrite */
    char *    alias;	/**< ReadWrite */
    char *    interface;	/**< ReadWrite */
    UBOOL8    allInterfaces;	/**< ReadWrite */
    char *    destIP;	/**< ReadWrite */
    char *    destMask;	/**< ReadWrite */
    char *    sourceIP;	/**< ReadWrite */
    char *    sourceMask;	/**< ReadWrite */
    SINT32    protocol;	/**< ReadWrite */
    char *    processingChoice;	/**< ReadWrite */
    char *    profile;	/**< ReadWrite */
    char *    X_BROADCOM_COM_TunnelName;	/**< ReadWrite */
    char *    X_BROADCOM_COM_SPI;	/**< ReadWrite */
    UBOOL8    X_BROADCOM_COM_L2TP_over_IPSec;	/**< ReadWrite */
    UBOOL8    X_BROADCOM_COM_LNS_L2TP_PORT;	/**< ReadWrite */
} Dev2IpsecFilterObject;

/*! \brief _Dev2IpsecFilterObject is used internally to represent Dev2IpsecFilterObject */
typedef Dev2IpsecFilterObject _Dev2IpsecFilterObject;



/*! \brief Obj struct for Device.IPsec.Profile.{i}.
 *
 * MDMOID_DEV2_IPSEC_PROFILE 1433
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    alias;	/**< ReadWrite */
    char *    remoteEndpoints;	/**< ReadWrite */
    char *    protocol;	/**< ReadWrite */
    char *    X_BROADCOM_COM_KeyExchangeMode;	/**< ReadWrite */
    char *    X_BROADCOM_COM_LocalIfName;	/**< ReadWrite */
} Dev2IpsecProfileObject;

/*! \brief _Dev2IpsecProfileObject is used internally to represent Dev2IpsecProfileObject */
typedef Dev2IpsecProfileObject _Dev2IpsecProfileObject;



/*! \brief Obj struct for Device.IPsec.Profile.{i}.X_BROADCOM_COM_ManualModeCfg.
 *
 * MDMOID_MANUAL_MODE_CFG 1435
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    allowedEncryptionAlgorithms;	/**< ReadWrite */
    char *    encryptionKey;	/**< ReadWrite */
    char *    allowedIntegrityAlgorithms;	/**< ReadWrite */
    char *    authenticationKey;	/**< ReadWrite */
    UINT32    SPI;	/**< ReadWrite */
} ManualModeCfgObject;

/*! \brief _ManualModeCfgObject is used internally to represent ManualModeCfgObject */
typedef ManualModeCfgObject _ManualModeCfgObject;



/*! \brief Obj struct for Device.IPsec.Profile.{i}.X_BROADCOM_COM_IKEv1Cfg.
 *
 * MDMOID_IKEV1_CFG 1436
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    authenticationMethod;	/**< ReadWrite */
    char *    preSharedKey;	/**< ReadWrite */
    char *    certificateName;	/**< ReadWrite */
    UBOOL8    perfectFSEn;	/**< ReadWrite */
    char *    phase1Mode;	/**< ReadWrite */
    char *    phase1AllowedEncryptionAlgorithms;	/**< ReadWrite */
    char *    phase1AllowedIntegrityAlgorithms;	/**< ReadWrite */
    char *    phase1AllowedDiffieHellmanGroupTransforms;	/**< ReadWrite */
    UINT32    phase1KeyTime;	/**< ReadWrite */
    char *    phase2AllowedEncryptionAlgorithms;	/**< ReadWrite */
    char *    phase2AllowedIntegrityAlgorithms;	/**< ReadWrite */
    char *    phase2AllowedDiffieHellmanGroupTransforms;	/**< ReadWrite */
    UINT32    phase2KeyTime;	/**< ReadWrite */
    UBOOL8    phase2ESN;	/**< ReadWrite */
    UINT32    phase2AntiReplayWindow;	/**< ReadWrite */
} Ikev1CfgObject;

/*! \brief _Ikev1CfgObject is used internally to represent Ikev1CfgObject */
typedef Ikev1CfgObject _Ikev1CfgObject;



/*! \brief Obj struct for Device.IPsec.Profile.{i}.X_BROADCOM_COM_IKEv2Cfg.
 *
 * MDMOID_IKEV2_CFG 1437
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    authenticationMethod;	/**< ReadWrite */
    char *    preSharedKey;	/**< ReadWrite */
    char *    certificateName;	/**< ReadWrite */
    UBOOL8    perfectFSEn;	/**< ReadWrite */
    char *    phase1AllowedEncryptionAlgorithms;	/**< ReadWrite */
    char *    phase1AllowedIntegrityAlgorithms;	/**< ReadWrite */
    char *    phase1AllowedDiffieHellmanGroupTransforms;	/**< ReadWrite */
    UINT32    phase1KeyTime;	/**< ReadWrite */
    char *    phase2AllowedEncryptionAlgorithms;	/**< ReadWrite */
    char *    phase2AllowedIntegrityAlgorithms;	/**< ReadWrite */
    char *    phase2AllowedDiffieHellmanGroupTransforms;	/**< ReadWrite */
    UINT32    phase2KeyTime;	/**< ReadWrite */
    UBOOL8    phase2ESN;	/**< ReadWrite */
    UINT32    phase2AntiReplayWindow;	/**< ReadWrite */
} Ikev2CfgObject;

/*! \brief _Ikev2CfgObject is used internally to represent Ikev2CfgObject */
typedef Ikev2CfgObject _Ikev2CfgObject;



/*! \brief Obj struct for Device.Routing.RIP.
 *
 * MDMOID_DEV2_RIP 1464
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    supportedModes;	/**< ReadOnly */
    UINT32    interfaceSettingNumberOfEntries;	/**< ReadOnly */
} Dev2RipObject;

/*! \brief _Dev2RipObject is used internally to represent Dev2RipObject */
typedef Dev2RipObject _Dev2RipObject;



/*! \brief Obj struct for Device.Routing.RIP.InterfaceSetting.{i}.
 *
 * MDMOID_DEV2_RIP_INTF_SETTING 1465
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    status;	/**< ReadOnly */
    char *    alias;	/**< ReadWrite */
    char *    interface;	/**< ReadWrite */
    UINT32    X_BROADCOM_COM_Version;	/**< ReadWrite */
    UBOOL8    acceptRA;	/**< ReadWrite */
    UBOOL8    sendRA;	/**< ReadWrite */
} Dev2RipIntfSettingObject;

/*! \brief _Dev2RipIntfSettingObject is used internally to represent Dev2RipIntfSettingObject */
typedef Dev2RipIntfSettingObject _Dev2RipIntfSettingObject;



/*! \brief Obj struct for Device.Hosts.
 *
 * MDMOID_DEV2_HOSTS 1520
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    hostNumberOfEntries;	/**< ReadOnly */
} Dev2HostsObject;

/*! \brief _Dev2HostsObject is used internally to represent Dev2HostsObject */
typedef Dev2HostsObject _Dev2HostsObject;



/*! \brief Obj struct for Device.Hosts.Host.{i}.
 *
 * MDMOID_DEV2_HOST 1521
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    physAddress;	/**< ReadOnly */
    char *    IPAddress;	/**< ReadOnly */
#ifdef DMP_DEVICE2_HOSTS_2
    char *    DHCPClient;	/**< ReadOnly */
#endif
    SINT32    leaseTimeRemaining;	/**< ReadOnly */
#ifdef DMP_DEVICE2_HOSTS_2
    char *    associatedDevice;	/**< ReadOnly */
#endif
    char *    layer1Interface;	/**< ReadOnly */
    char *    layer3Interface;	/**< ReadOnly */
    char *    hostName;	/**< ReadOnly */
    UBOOL8    active;	/**< ReadOnly */
#ifdef DMP_DEVICE2_HOSTS_2
    UINT32    IPv4AddressNumberOfEntries;	/**< ReadOnly */
#endif
#ifdef DMP_DEVICE2_HOSTS_2
    UINT32    IPv6AddressNumberOfEntries;	/**< ReadOnly */
#endif
} Dev2HostObject;

/*! \brief _Dev2HostObject is used internally to represent Dev2HostObject */
typedef Dev2HostObject _Dev2HostObject;



/*! \brief Obj struct for Device.Hosts.Host.{i}.IPv4Address.{i}.
 *
 * MDMOID_DEV2_HOST_IPV4_ADDRESS 1522
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    IPAddress;	/**< ReadOnly */
} Dev2HostIpv4AddressObject;

/*! \brief _Dev2HostIpv4AddressObject is used internally to represent Dev2HostIpv4AddressObject */
typedef Dev2HostIpv4AddressObject _Dev2HostIpv4AddressObject;



/*! \brief Obj struct for Device.Hosts.Host.{i}.IPv6Address.{i}.
 *
 * MDMOID_DEV2_HOST_IPV6_ADDRESS 1523
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    IPAddress;	/**< ReadOnly */
} Dev2HostIpv6AddressObject;

/*! \brief _Dev2HostIpv6AddressObject is used internally to represent Dev2HostIpv6AddressObject */
typedef Dev2HostIpv6AddressObject _Dev2HostIpv6AddressObject;



/*! \brief Obj struct for Device.NAT.
 *
 * MDMOID_DEV2_NAT 1550
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    interfaceSettingNumberOfEntries;	/**< ReadOnly */
    UINT32    portMappingNumberOfEntries;	/**< ReadOnly */
} Dev2NatObject;

/*! \brief _Dev2NatObject is used internally to represent Dev2NatObject */
typedef Dev2NatObject _Dev2NatObject;



/*! \brief Obj struct for Device.NAT.InterfaceSetting.{i}.
 *
 * MDMOID_DEV2_NAT_INTF_SETTING 1551
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    status;	/**< ReadOnly */
    char *    alias;	/**< ReadWrite */
    char *    interface;	/**< ReadWrite */
    UBOOL8    X_BROADCOM_COM_FullconeNATEnabled;	/**< ReadWrite */
} Dev2NatIntfSettingObject;

/*! \brief _Dev2NatIntfSettingObject is used internally to represent Dev2NatIntfSettingObject */
typedef Dev2NatIntfSettingObject _Dev2NatIntfSettingObject;



/*! \brief Obj struct for Device.NAT.InterfaceSetting.{i}.X_BROADCOM_COM_PortTriggering.{i}.
 *
 * MDMOID_DEV2_NAT_PORT_TRIGGERING 3592
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    name;	/**< ReadWrite */
    char *    triggerProtocol;	/**< ReadWrite */
    char *    openProtocol;	/**< ReadWrite */
    UINT32    triggerPortStart;	/**< ReadWrite */
    UINT32    triggerPortEnd;	/**< ReadWrite */
    UINT32    openPortStart;	/**< ReadWrite */
    UINT32    openPortEnd;	/**< ReadWrite */
} Dev2NatPortTriggeringObject;

/*! \brief _Dev2NatPortTriggeringObject is used internally to represent Dev2NatPortTriggeringObject */
typedef Dev2NatPortTriggeringObject _Dev2NatPortTriggeringObject;



/*! \brief Obj struct for Device.NAT.PortMapping.{i}.
 *
 * MDMOID_DEV2_NAT_PORT_MAPPING 3593
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    status;	/**< ReadOnly */
    char *    alias;	/**< ReadWrite */
    char *    interface;	/**< ReadWrite */
    UBOOL8    allInterfaces;	/**< ReadWrite */
    UINT32    leaseDuration;	/**< ReadWrite */
    char *    remoteHost;	/**< ReadWrite */
    UINT32    externalPort;	/**< ReadWrite */
    UINT32    externalPortEndRange;	/**< ReadWrite */
    UINT32    internalPort;	/**< ReadWrite */
    UINT32    X_BROADCOM_COM_InternalPortEndRange;	/**< ReadWrite */
    char *    protocol;	/**< ReadWrite */
    char *    internalClient;	/**< ReadWrite */
    char *    description;	/**< ReadWrite */
    char *    X_BROADCOM_COM_AppName;	/**< ReadWrite */
} Dev2NatPortMappingObject;

/*! \brief _Dev2NatPortMappingObject is used internally to represent Dev2NatPortMappingObject */
typedef Dev2NatPortMappingObject _Dev2NatPortMappingObject;



/*! \brief Obj struct for Device.DHCPv4.
 *
 * MDMOID_DEV2_DHCPV4 1560
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
#ifdef DMP_DEVICE2_DHCPV4CLIENT_1
    UINT32    clientNumberOfEntries;	/**< ReadOnly */
#endif
} Dev2Dhcpv4Object;

/*! \brief _Dev2Dhcpv4Object is used internally to represent Dev2Dhcpv4Object */
typedef Dev2Dhcpv4Object _Dev2Dhcpv4Object;



/*! \brief Obj struct for Device.DHCPv4.Client.{i}.
 *
 * MDMOID_DEV2_DHCPV4_CLIENT 1561
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    alias;	/**< ReadWrite */
    char *    interface;	/**< ReadWrite */
    char *    status;	/**< ReadOnly */
    char *    DHCPStatus;	/**< ReadOnly */
    char *    IPAddress;	/**< ReadOnly */
    char *    subnetMask;	/**< ReadOnly */
    char *    IPRouters;	/**< ReadOnly */
    char *    DNSServers;	/**< ReadOnly */
    UINT32    sentOptionNumberOfEntries;	/**< ReadOnly */
    UINT32    reqOptionNumberOfEntries;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_Pid;	/**< ReadOnly */
} Dev2Dhcpv4ClientObject;

/*! \brief _Dev2Dhcpv4ClientObject is used internally to represent Dev2Dhcpv4ClientObject */
typedef Dev2Dhcpv4ClientObject _Dev2Dhcpv4ClientObject;



/*! \brief Obj struct for Device.DHCPv4.Client.{i}.SentOption.{i}.
 *
 * MDMOID_DEV2_DHCPV4_CLIENT_SENT_OPTION 1562
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    alias;	/**< ReadWrite */
    UINT32    tag;	/**< ReadWrite */
    HEXBINARY  value;	/**< ReadWrite */
} Dev2Dhcpv4ClientSentOptionObject;

/*! \brief _Dev2Dhcpv4ClientSentOptionObject is used internally to represent Dev2Dhcpv4ClientSentOptionObject */
typedef Dev2Dhcpv4ClientSentOptionObject _Dev2Dhcpv4ClientSentOptionObject;



/*! \brief Obj struct for Device.DHCPv4.Client.{i}.ReqOption.{i}.
 *
 * MDMOID_DEV2_DHCPV4_CLIENT_REQ_OPTION 1563
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    UINT32    order;	/**< ReadWrite */
    char *    alias;	/**< ReadWrite */
    UINT32    tag;	/**< ReadWrite */
    HEXBINARY  value;	/**< ReadOnly */
    char *    X_BROADCOM_COM_Value;	/**< ReadWrite */
} Dev2Dhcpv4ClientReqOptionObject;

/*! \brief _Dev2Dhcpv4ClientReqOptionObject is used internally to represent Dev2Dhcpv4ClientReqOptionObject */
typedef Dev2Dhcpv4ClientReqOptionObject _Dev2Dhcpv4ClientReqOptionObject;



/*! \brief Obj struct for Device.DHCPv4.Server.
 *
 * MDMOID_DEV2_DHCPV4_SERVER 1564
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    UINT32    poolNumberOfEntries;	/**< ReadOnly */
} Dev2Dhcpv4ServerObject;

/*! \brief _Dev2Dhcpv4ServerObject is used internally to represent Dev2Dhcpv4ServerObject */
typedef Dev2Dhcpv4ServerObject _Dev2Dhcpv4ServerObject;



/*! \brief Obj struct for Device.DHCPv4.Server.Pool.{i}.
 *
 * MDMOID_DEV2_DHCPV4_SERVER_POOL 1565
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    status;	/**< ReadOnly */
    char *    alias;	/**< ReadWrite */
    char *    interface;	/**< ReadWrite */
    IPADDRESS  minAddress;	/**< ReadWrite */
    IPADDRESS  maxAddress;	/**< ReadWrite */
    char *    subnetMask;	/**< ReadWrite */
    char *    DNSServers;	/**< ReadWrite */
    char *    domainName;	/**< ReadWrite */
    char *    IPRouters;	/**< ReadWrite */
    SINT32    leaseTime;	/**< ReadWrite */
    UINT32    staticAddressNumberOfEntries;	/**< ReadOnly */
    UINT32    optionNumberOfEntries;	/**< ReadOnly */
#ifdef DMP_DEVICE2_DHCPV4SERVERCLIENTINFO_1
    UINT32    clientNumberOfEntries;	/**< ReadOnly */
#endif
} Dev2Dhcpv4ServerPoolObject;

/*! \brief _Dev2Dhcpv4ServerPoolObject is used internally to represent Dev2Dhcpv4ServerPoolObject */
typedef Dev2Dhcpv4ServerPoolObject _Dev2Dhcpv4ServerPoolObject;



/*! \brief Obj struct for Device.DHCPv4.Server.Pool.{i}.StaticAddress.{i}.
 *
 * MDMOID_DEV2_DHCPV4_SERVER_POOL_STATIC_ADDRESS 1566
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    alias;	/**< ReadWrite */
    MACADDRESS  chaddr;	/**< ReadWrite */
    IPADDRESS  yiaddr;	/**< ReadWrite */
} Dev2Dhcpv4ServerPoolStaticAddressObject;

/*! \brief _Dev2Dhcpv4ServerPoolStaticAddressObject is used internally to represent Dev2Dhcpv4ServerPoolStaticAddressObject */
typedef Dev2Dhcpv4ServerPoolStaticAddressObject _Dev2Dhcpv4ServerPoolStaticAddressObject;



/*! \brief Obj struct for Device.DHCPv4.Server.Pool.{i}.Client.{i}.
 *
 * MDMOID_DEV2_DHCPV4_SERVER_POOL_CLIENT 1568
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    alias;	/**< ReadWrite */
    char *    chaddr;	/**< ReadOnly */
    UBOOL8    active;	/**< ReadOnly */
    UINT32    IPv4AddressNumberOfEntries;	/**< ReadOnly */
    UINT32    optionNumberOfEntries;	/**< ReadOnly */
} Dev2Dhcpv4ServerPoolClientObject;

/*! \brief _Dev2Dhcpv4ServerPoolClientObject is used internally to represent Dev2Dhcpv4ServerPoolClientObject */
typedef Dev2Dhcpv4ServerPoolClientObject _Dev2Dhcpv4ServerPoolClientObject;



/*! \brief Obj struct for Device.DHCPv4.Server.Pool.{i}.Client.{i}.IPv4Address.{i}.
 *
 * MDMOID_DEV2_DHCPV4_SERVER_POOL_CLIENT_I_PV4_ADDRESS 1569
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    IPAddress;	/**< ReadOnly */
    DATETIME  leaseTimeRemaining;	/**< ReadOnly */
} Dev2Dhcpv4ServerPoolClientIPv4AddressObject;

/*! \brief _Dev2Dhcpv4ServerPoolClientIPv4AddressObject is used internally to represent Dev2Dhcpv4ServerPoolClientIPv4AddressObject */
typedef Dev2Dhcpv4ServerPoolClientIPv4AddressObject _Dev2Dhcpv4ServerPoolClientIPv4AddressObject;



/*! \brief Obj struct for Device.DHCPv4.Server.Pool.{i}.Client.{i}.Option.{i}.
 *
 * MDMOID_DEV2_DHCPV4_SERVER_POOL_CLIENT_OPTION 1570
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    tag;	/**< ReadOnly */
    HEXBINARY  value;	/**< ReadOnly */
} Dev2Dhcpv4ServerPoolClientOptionObject;

/*! \brief _Dev2Dhcpv4ServerPoolClientOptionObject is used internally to represent Dev2Dhcpv4ServerPoolClientOptionObject */
typedef Dev2Dhcpv4ServerPoolClientOptionObject _Dev2Dhcpv4ServerPoolClientOptionObject;



/*! \brief Obj struct for Device.DHCPv4.Relay.
 *
 * MDMOID_DEV2_DHCPV4_RELAY 1571
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    status;	/**< ReadOnly */
    UINT32    forwardingNumberOfEntries;	/**< ReadOnly */
} Dev2Dhcpv4RelayObject;

/*! \brief _Dev2Dhcpv4RelayObject is used internally to represent Dev2Dhcpv4RelayObject */
typedef Dev2Dhcpv4RelayObject _Dev2Dhcpv4RelayObject;



/*! \brief Obj struct for Device.DHCPv4.Relay.Forwarding.{i}.
 *
 * MDMOID_DEV2_DHCPV4_RELAY_FORWARDING 1572
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    status;	/**< ReadOnly */
    char *    alias;	/**< ReadWrite */
    char *    interface;	/**< ReadWrite */
    char *    DHCPServerIPAddress;	/**< ReadWrite */
} Dev2Dhcpv4RelayForwardingObject;

/*! \brief _Dev2Dhcpv4RelayForwardingObject is used internally to represent Dev2Dhcpv4RelayForwardingObject */
typedef Dev2Dhcpv4RelayForwardingObject _Dev2Dhcpv4RelayForwardingObject;



/*! \brief Obj struct for Device.Firewall.
 *
 * MDMOID_DEV2_FIREWALL 1680
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
#ifdef DMP_DEVICE2_SIMPLEFIREWALL_1
    char *    config;	/**< ReadWrite */
#endif
    char *    advancedLevel;	/**< ReadWrite */
    char *    type;	/**< ReadOnly */
#ifdef DMP_DEVICE2_SIMPLEFIREWALL_1
    char *    version;	/**< ReadOnly */
#endif
#ifdef DMP_DEVICE2_SIMPLEFIREWALL_1
    DATETIME  lastChange;	/**< ReadOnly */
#endif
    UINT32    levelNumberOfEntries;	/**< ReadOnly */
    UINT32    chainNumberOfEntries;	/**< ReadOnly */
} Dev2FirewallObject;

/*! \brief _Dev2FirewallObject is used internally to represent Dev2FirewallObject */
typedef Dev2FirewallObject _Dev2FirewallObject;



/*! \brief Obj struct for Device.Firewall.Level.{i}.
 *
 * MDMOID_DEV2_FIREWALL_LEVEL 1681
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    name;	/**< ReadWrite */
    char *    chain;	/**< ReadOnly */
    char *    defaultPolicy;	/**< ReadWrite */
} Dev2FirewallLevelObject;

/*! \brief _Dev2FirewallLevelObject is used internally to represent Dev2FirewallLevelObject */
typedef Dev2FirewallLevelObject _Dev2FirewallLevelObject;



/*! \brief Obj struct for Device.Firewall.Chain.{i}.
 *
 * MDMOID_DEV2_FIREWALL_CHAIN 1682
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    name;	/**< ReadWrite */
    char *    creator;	/**< ReadWrite */
    UINT32    ruleNumberOfEntries;	/**< ReadOnly */
} Dev2FirewallChainObject;

/*! \brief _Dev2FirewallChainObject is used internally to represent Dev2FirewallChainObject */
typedef Dev2FirewallChainObject _Dev2FirewallChainObject;



/*! \brief Obj struct for Device.Firewall.Chain.{i}.Rule.{i}.
 *
 * MDMOID_DEV2_FIREWALL_CHAIN_RULE 1683
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    status;	/**< ReadOnly */
    char *    target;	/**< ReadWrite */
    char *    sourceInterface;	/**< ReadWrite */
    char *    destInterface;	/**< ReadWrite */
    SINT32    IPVersion;	/**< ReadWrite */
    char *    destIP;	/**< ReadWrite */
    char *    sourceIP;	/**< ReadWrite */
    SINT32    protocol;	/**< ReadWrite */
    SINT32    destPort;	/**< ReadWrite */
    SINT32    sourcePort;	/**< ReadWrite */
} Dev2FirewallChainRuleObject;

/*! \brief _Dev2FirewallChainRuleObject is used internally to represent Dev2FirewallChainRuleObject */
typedef Dev2FirewallChainRuleObject _Dev2FirewallChainRuleObject;



/*! \brief Obj struct for Device.Firewall.X_BROADCOM_COM_FirewallException.{i}.
 *
 * MDMOID_DEV2_FIREWALL_EXCEPTION 3250
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    IPInterface;	/**< ReadWrite */
} Dev2FirewallExceptionObject;

/*! \brief _Dev2FirewallExceptionObject is used internally to represent Dev2FirewallExceptionObject */
typedef Dev2FirewallExceptionObject _Dev2FirewallExceptionObject;



/*! \brief Obj struct for Device.Firewall.X_BROADCOM_COM_FirewallException.{i}.Rule.{i}.
 *
 * MDMOID_DEV2_FIREWALL_EXCEPTION_RULE 3251
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    filterName;	/**< ReadWrite */
    char *    IPVersion;	/**< ReadWrite */
    char *    protocol;	/**< ReadWrite */
    UINT32    sourcePortStart;	/**< ReadWrite */
    UINT32    sourcePortEnd;	/**< ReadWrite */
    UINT32    destinationPortStart;	/**< ReadWrite */
    UINT32    destinationPortEnd;	/**< ReadWrite */
    char *    sourceIPAddress;	/**< ReadWrite */
    char *    sourceNetMask;	/**< ReadWrite */
    char *    destinationIPAddress;	/**< ReadWrite */
    char *    destinationNetMask;	/**< ReadWrite */
    char *    target;	/**< ReadWrite */
} Dev2FirewallExceptionRuleObject;

/*! \brief _Dev2FirewallExceptionRuleObject is used internally to represent Dev2FirewallExceptionRuleObject */
typedef Dev2FirewallExceptionRuleObject _Dev2FirewallExceptionRuleObject;



/*! \brief Obj struct for Device.Firewall.X_BROADCOM_COM_MacFilterObj.{i}.
 *
 * MDMOID_DEV2_MAC_FILTER 3590
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    IPInterface;	/**< ReadWrite */
    char *    policy;	/**< ReadWrite */
} Dev2MacFilterObject;

/*! \brief _Dev2MacFilterObject is used internally to represent Dev2MacFilterObject */
typedef Dev2MacFilterObject _Dev2MacFilterObject;



/*! \brief Obj struct for Device.Firewall.X_BROADCOM_COM_MacFilterObj.{i}.X_BROADCOM_COM_MacFilterCfg.{i}.
 *
 * MDMOID_DEV2_MAC_FILTER_CFG 3591
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    protocol;	/**< ReadWrite */
    char *    direction;	/**< ReadWrite */
    char *    sourceMAC;	/**< ReadWrite */
    char *    destinationMAC;	/**< ReadWrite */
} Dev2MacFilterCfgObject;

/*! \brief _Dev2MacFilterCfgObject is used internally to represent Dev2MacFilterCfgObject */
typedef Dev2MacFilterCfgObject _Dev2MacFilterCfgObject;



/*! \brief Obj struct for Device.QoS.
 *
 * MDMOID_DEV2_QOS 1500
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    X_BROADCOM_COM_Enable;	/**< ReadWrite */
    UBOOL8    X_BROADCOM_COM_EnableStateChanged;	/**< ReadWrite */
    UINT32    maxClassificationEntries;	/**< ReadOnly */
    UINT32    classificationNumberOfEntries;	/**< ReadOnly */
    UINT32    maxAppEntries;	/**< ReadOnly */
    UINT32    appNumberOfEntries;	/**< ReadOnly */
    UINT32    maxFlowEntries;	/**< ReadOnly */
    UINT32    flowNumberOfEntries;	/**< ReadOnly */
    UINT32    maxPolicerEntries;	/**< ReadOnly */
    UINT32    policerNumberOfEntries;	/**< ReadOnly */
    UINT32    maxQueueEntries;	/**< ReadOnly */
    UINT32    queueNumberOfEntries;	/**< ReadOnly */
#ifdef DMP_DEVICE2_QOSSTATS_1
    UINT32    queueStatsNumberOfEntries;	/**< ReadOnly */
#endif
    UINT32    maxShaperEntries;	/**< ReadOnly */
    UINT32    shaperNumberOfEntries;	/**< ReadOnly */
    UINT32    defaultForwardingPolicy;	/**< ReadWrite */
    char *    defaultPolicer;	/**< ReadWrite */
    char *    defaultQueue;	/**< ReadWrite */
    SINT32    defaultDSCPMark;	/**< ReadWrite */
    SINT32    defaultEthernetPriorityMark;	/**< ReadWrite */
    char *    availableAppList;	/**< ReadOnly */
} Dev2QosObject;

/*! \brief _Dev2QosObject is used internally to represent Dev2QosObject */
typedef Dev2QosObject _Dev2QosObject;



/*! \brief Obj struct for Device.QoS.Classification.{i}.
 *
 * MDMOID_DEV2_QOS_CLASSIFICATION 1501
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    status;	/**< ReadOnly */
    UINT32    order;	/**< ReadWrite */
    char *    alias;	/**< ReadWrite */
    char *    DHCPType;	/**< ReadWrite */
    char *    interface;	/**< ReadWrite */
    UBOOL8    allInterfaces;	/**< ReadWrite */
    char *    destIP;	/**< ReadWrite */
    char *    destMask;	/**< ReadWrite */
    UBOOL8    destIPExclude;	/**< ReadWrite */
    char *    sourceIP;	/**< ReadWrite */
    char *    sourceMask;	/**< ReadWrite */
    UBOOL8    sourceIPExclude;	/**< ReadWrite */
    SINT32    protocol;	/**< ReadWrite */
    UBOOL8    protocolExclude;	/**< ReadWrite */
    SINT32    destPort;	/**< ReadWrite */
    SINT32    destPortRangeMax;	/**< ReadWrite */
    UBOOL8    destPortExclude;	/**< ReadWrite */
    SINT32    sourcePort;	/**< ReadWrite */
    SINT32    sourcePortRangeMax;	/**< ReadWrite */
    UBOOL8    sourcePortExclude;	/**< ReadWrite */
    char *    sourceMACAddress;	/**< ReadWrite */
    char *    sourceMACMask;	/**< ReadWrite */
    UBOOL8    sourceMACExclude;	/**< ReadWrite */
    char *    destMACAddress;	/**< ReadWrite */
    char *    destMACMask;	/**< ReadWrite */
    UBOOL8    destMACExclude;	/**< ReadWrite */
    SINT32    ethertype;	/**< ReadWrite */
    UBOOL8    ethertypeExclude;	/**< ReadWrite */
    SINT32    SSAP;	/**< ReadWrite */
    UBOOL8    SSAPExclude;	/**< ReadWrite */
    SINT32    DSAP;	/**< ReadWrite */
    UBOOL8    DSAPExclude;	/**< ReadWrite */
    SINT32    LLCControl;	/**< ReadWrite */
    UBOOL8    LLCControlExclude;	/**< ReadWrite */
    SINT32    SNAPOUI;	/**< ReadWrite */
    UBOOL8    SNAPOUIExclude;	/**< ReadWrite */
    char *    sourceVendorClassID;	/**< ReadWrite */
    HEXBINARY  sourceVendorClassIDv6;	/**< ReadWrite */
    UBOOL8    sourceVendorClassIDExclude;	/**< ReadWrite */
    char *    sourceVendorClassIDMode;	/**< ReadWrite */
    char *    destVendorClassID;	/**< ReadWrite */
    HEXBINARY  destVendorClassIDv6;	/**< ReadWrite */
    UBOOL8    destVendorClassIDExclude;	/**< ReadWrite */
    char *    destVendorClassIDMode;	/**< ReadWrite */
    HEXBINARY  sourceClientID;	/**< ReadWrite */
    UBOOL8    sourceClientIDExclude;	/**< ReadWrite */
    HEXBINARY  destClientID;	/**< ReadWrite */
    UBOOL8    destClientIDExclude;	/**< ReadWrite */
    HEXBINARY  sourceUserClassID;	/**< ReadWrite */
    UBOOL8    sourceUserClassIDExclude;	/**< ReadWrite */
    HEXBINARY  destUserClassID;	/**< ReadWrite */
    UBOOL8    destUserClassIDExclude;	/**< ReadWrite */
    HEXBINARY  sourceVendorSpecificInfo;	/**< ReadWrite */
    UBOOL8    sourceVendorSpecificInfoExclude;	/**< ReadWrite */
    UINT32    sourceVendorSpecificInfoEnterprise;	/**< ReadWrite */
    SINT32    sourceVendorSpecificInfoSubOption;	/**< ReadWrite */
    HEXBINARY  destVendorSpecificInfo;	/**< ReadWrite */
    UBOOL8    destVendorSpecificInfoExclude;	/**< ReadWrite */
    UINT32    destVendorSpecificInfoEnterprise;	/**< ReadWrite */
    SINT32    destVendorSpecificInfoSubOption;	/**< ReadWrite */
    UBOOL8    TCPACK;	/**< ReadWrite */
    UBOOL8    TCPACKExclude;	/**< ReadWrite */
    UINT32    IPLengthMin;	/**< ReadWrite */
    UINT32    IPLengthMax;	/**< ReadWrite */
    UBOOL8    IPLengthExclude;	/**< ReadWrite */
    SINT32    DSCPCheck;	/**< ReadWrite */
    UBOOL8    DSCPExclude;	/**< ReadWrite */
    SINT32    DSCPMark;	/**< ReadWrite */
    SINT32    ethernetPriorityCheck;	/**< ReadWrite */
    UBOOL8    ethernetPriorityExclude;	/**< ReadWrite */
    SINT32    ethernetPriorityMark;	/**< ReadWrite */
    SINT32    VLANIDCheck;	/**< ReadWrite */
    UBOOL8    VLANIDExclude;	/**< ReadWrite */
    SINT32    outOfBandInfo;	/**< ReadWrite */
    UINT32    forwardingPolicy;	/**< ReadWrite */
    SINT32    trafficClass;	/**< ReadWrite */
    char *    policer;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_Icmpv6Type;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_Icmpv6Code;	/**< ReadWrite */
    UBOOL8    X_BROADCOM_COM_Icmpv6TypeCodeExclude;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_ClassRate;	/**< ReadWrite */
    char *    X_BROADCOM_COM_ClassName;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_VLANIDTag;	/**< ReadWrite */
    char *    X_BROADCOM_COM_egressInterface;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_ClassQueue;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_ClassPolicer;	/**< ReadWrite */
    UINT32    X_BROADCOM_COM_ClassKey;	/**< ReadWrite */
} Dev2QosClassificationObject;

/*! \brief _Dev2QosClassificationObject is used internally to represent Dev2QosClassificationObject */
typedef Dev2QosClassificationObject _Dev2QosClassificationObject;



/*! \brief Obj struct for Device.QoS.Policer.{i}.
 *
 * MDMOID_DEV2_QOS_POLICER 1504
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    status;	/**< ReadOnly */
    char *    alias;	/**< ReadWrite */
    UINT32    committedRate;	/**< ReadWrite */
    UINT32    committedBurstSize;	/**< ReadWrite */
    UINT32    excessBurstSize;	/**< ReadWrite */
    UINT32    peakRate;	/**< ReadWrite */
    UINT32    peakBurstSize;	/**< ReadWrite */
    char *    meterType;	/**< ReadWrite */
    char *    possibleMeterTypes;	/**< ReadOnly */
    char *    conformingAction;	/**< ReadWrite */
    char *    partialConformingAction;	/**< ReadWrite */
    char *    nonConformingAction;	/**< ReadWrite */
    UINT32    totalCountedPackets;	/**< ReadOnly */
    UINT32    totalCountedBytes;	/**< ReadOnly */
#ifdef DMP_DEVICE2_QOSSTATS_1
    UINT32    conformingCountedPackets;	/**< ReadOnly */
#endif
#ifdef DMP_DEVICE2_QOSSTATS_1
    UINT32    conformingCountedBytes;	/**< ReadOnly */
#endif
    UINT32    partiallyConformingCountedPackets;	/**< ReadOnly */
    UINT32    partiallyConformingCountedBytes;	/**< ReadOnly */
#ifdef DMP_DEVICE2_QOSSTATS_1
    UINT32    nonConformingCountedPackets;	/**< ReadOnly */
#endif
#ifdef DMP_DEVICE2_QOSSTATS_1
    UINT32    nonConformingCountedBytes;	/**< ReadOnly */
#endif
    char *    X_BROADCOM_COM_PolicerName;	/**< ReadWrite */
    UINT32    X_BROADCOM_COM_PolicerInfo;	/**< ReadWrite */
} Dev2QosPolicerObject;

/*! \brief _Dev2QosPolicerObject is used internally to represent Dev2QosPolicerObject */
typedef Dev2QosPolicerObject _Dev2QosPolicerObject;



/*! \brief Obj struct for Device.QoS.Queue.{i}.
 *
 * MDMOID_DEV2_QOS_QUEUE 1505
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    status;	/**< ReadOnly */
    char *    alias;	/**< ReadWrite */
    char *    trafficClasses;	/**< ReadWrite */
    char *    interface;	/**< ReadWrite */
    UBOOL8    allInterfaces;	/**< ReadWrite */
    UBOOL8    hardwareAssisted;	/**< ReadOnly */
    UINT32    bufferLength;	/**< ReadOnly */
    UINT32    weight;	/**< ReadWrite */
    UINT32    precedence;	/**< ReadWrite */
    UINT32    REDThreshold;	/**< ReadWrite */
    UINT32    REDPercentage;	/**< ReadWrite */
    char *    dropAlgorithm;	/**< ReadWrite */
    char *    schedulerAlgorithm;	/**< ReadWrite */
    SINT32    shapingRate;	/**< ReadWrite */
    UINT32    shapingBurstSize;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_MinBitRate;	/**< ReadWrite */
    char *    X_BROADCOM_COM_QueueName;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_DslLatency;	/**< ReadWrite */
    SINT32    X_BROADCOM_COM_PtmPriority;	/**< ReadWrite */
    UINT32    X_BROADCOM_COM_QueueId;	/**< ReadWrite */
    UINT32    X_BROADCOM_COM_LowClassMaxThreshold;	/**< ReadWrite */
    UINT32    X_BROADCOM_COM_HighClassMinThreshold;	/**< ReadWrite */
    UINT32    X_BROADCOM_COM_HighClassMaxThreshold;	/**< ReadWrite */
    UBOOL8    X_BROADCOM_COM_TcpPureAckQueue;	/**< ReadWrite */
} Dev2QosQueueObject;

/*! \brief _Dev2QosQueueObject is used internally to represent Dev2QosQueueObject */
typedef Dev2QosQueueObject _Dev2QosQueueObject;



/*! \brief Obj struct for Device.QoS.QueueStats.{i}.
 *
 * MDMOID_DEV2_QOS_QUEUE_STATS 1506
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    status;	/**< ReadOnly */
    char *    alias;	/**< ReadWrite */
    char *    queue;	/**< ReadWrite */
    char *    interface;	/**< ReadWrite */
    UINT32    outputPackets;	/**< ReadOnly */
    UINT32    outputBytes;	/**< ReadOnly */
    UINT32    droppedPackets;	/**< ReadOnly */
    UINT32    droppedBytes;	/**< ReadOnly */
    UINT32    queueOccupancyPackets;	/**< ReadOnly */
    UINT32    queueOccupancyPercentage;	/**< ReadOnly */
} Dev2QosQueueStatsObject;

/*! \brief _Dev2QosQueueStatsObject is used internally to represent Dev2QosQueueStatsObject */
typedef Dev2QosQueueStatsObject _Dev2QosQueueStatsObject;



/*! \brief Obj struct for Device.QoS.Shaper.{i}.
 *
 * MDMOID_DEV2_QOS_SHAPER 1507
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    status;	/**< ReadOnly */
    char *    alias;	/**< ReadWrite */
    char *    interface;	/**< ReadWrite */
    SINT32    shapingRate;	/**< ReadWrite */
    UINT32    shapingBurstSize;	/**< ReadWrite */
} Dev2QosShaperObject;

/*! \brief _Dev2QosShaperObject is used internally to represent Dev2QosShaperObject */
typedef Dev2QosShaperObject _Dev2QosShaperObject;



/*! \brief Obj struct for Device.PeriodicStatistics.
 *
 * MDMOID_DEV2_PERIODIC_STAT 1690
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    minSampleInterval;	/**< ReadOnly */
    UINT32    maxReportSamples;	/**< ReadOnly */
    UINT32    sampleSetNumberOfEntries;	/**< ReadOnly */
} Dev2PeriodicStatObject;

/*! \brief _Dev2PeriodicStatObject is used internally to represent Dev2PeriodicStatObject */
typedef Dev2PeriodicStatObject _Dev2PeriodicStatObject;



/*! \brief Obj struct for Device.PeriodicStatistics.SampleSet.{i}.
 *
 * MDMOID_DEV2_SAMPLE_SET 1691
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
#ifdef DMP_DEVICE2_PERIODICSTATSADV_1
    UBOOL8    enable;	/**< ReadWrite */
#endif
#ifdef DMP_DEVICE2_PERIODICSTATSADV_1
    char *    status;	/**< ReadOnly */
#endif
    char *    name;	/**< ReadWrite */
    UINT32    sampleInterval;	/**< ReadWrite */
    UINT32    reportSamples;	/**< ReadWrite */
#ifdef DMP_DEVICE2_PERIODICSTATSADV_1
    UINT32    fetchSamples;	/**< ReadWrite */
#endif
#ifdef DMP_DEVICE2_PERIODICSTATSADV_1
    UBOOL8    forceSample;	/**< ReadWrite */
#endif
    DATETIME  reportStartTime;	/**< ReadOnly */
    DATETIME  reportEndTime;	/**< ReadOnly */
    char *    sampleSeconds;	/**< ReadOnly */
    UINT32    parameterNumberOfEntries;	/**< ReadOnly */
} Dev2SampleSetObject;

/*! \brief _Dev2SampleSetObject is used internally to represent Dev2SampleSetObject */
typedef Dev2SampleSetObject _Dev2SampleSetObject;



/*! \brief Obj struct for Device.PeriodicStatistics.SampleSet.{i}.Parameter.{i}.
 *
 * MDMOID_DEV2_SAMPLE_PARAMETER 1692
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    alias;	/**< ReadWrite */
#ifdef DMP_DEVICE2_PERIODICSTATSADV_1
    UBOOL8    enable;	/**< ReadWrite */
#endif
    char *    reference;	/**< ReadWrite */
#ifdef DMP_DEVICE2_PERIODICSTATSADV_1
    char *    sampleMode;	/**< ReadWrite */
#endif
#ifdef DMP_DEVICE2_PERIODICSTATSADV_1
    SINT32    lowThreshold;	/**< ReadWrite */
#endif
#ifdef DMP_DEVICE2_PERIODICSTATSADV_1
    SINT32    highThreshold;	/**< ReadWrite */
#endif
    char *    sampleSeconds;	/**< ReadOnly */
    char *    suspectData;	/**< ReadOnly */
    char *    values;	/**< ReadOnly */
#ifdef DMP_DEVICE2_PERIODICSTATSADV_1
    UINT32    failures;	/**< ReadOnly */
#endif
} Dev2SampleParameterObject;

/*! \brief _Dev2SampleParameterObject is used internally to represent Dev2SampleParameterObject */
typedef Dev2SampleParameterObject _Dev2SampleParameterObject;



/*! \brief Obj struct for Device.Security.
 *
 * MDMOID_DEV2_SECURITY 1720
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    certificateNumberOfEntries;	/**< ReadOnly */
} Dev2SecurityObject;

/*! \brief _Dev2SecurityObject is used internally to represent Dev2SecurityObject */
typedef Dev2SecurityObject _Dev2SecurityObject;



/*! \brief Obj struct for Device.Security.Certificate.{i}.
 *
 * MDMOID_DEV2_SECURITY_CERTIFICATE 1721
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    DATETIME  lastModif;	/**< ReadOnly */
    char *    serialNumber;	/**< ReadOnly */
    char *    issuer;	/**< ReadOnly */
    DATETIME  notBefore;	/**< ReadOnly */
    DATETIME  notAfter;	/**< ReadOnly */
    char *    subject;	/**< ReadOnly */
    char *    signatureAlgorithm;	/**< ReadOnly */
    char *    X_BROADCOM_COM_Name;	/**< ReadWrite */
} Dev2SecurityCertificateObject;

/*! \brief _Dev2SecurityCertificateObject is used internally to represent Dev2SecurityCertificateObject */
typedef Dev2SecurityCertificateObject _Dev2SecurityCertificateObject;



/*! \brief Obj struct for Device.BulkData.
 *
 * MDMOID_DEV2_BULK_DATA 1760
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    status;	/**< ReadOnly */
    UINT32    minReportingInterval;	/**< ReadOnly */
    char *    protocols;	/**< ReadOnly */
    char *    encodingTypes;	/**< ReadOnly */
#ifdef DMP_DEVICE2_BULKDATAREPORTS_1
    UBOOL8    parameterWildCardSupported;	/**< ReadOnly */
#endif
    SINT32    maxNumberOfProfiles;	/**< ReadOnly */
    SINT32    maxNumberOfParameterReferences;	/**< ReadOnly */
    UINT32    profileNumberOfEntries;	/**< ReadOnly */
} Dev2BulkDataObject;

/*! \brief _Dev2BulkDataObject is used internally to represent Dev2BulkDataObject */
typedef Dev2BulkDataObject _Dev2BulkDataObject;



/*! \brief Obj struct for Device.BulkData.Profile.{i}.
 *
 * MDMOID_DEV2_BULK_DATA_PROFILE 1761
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    alias;	/**< ReadWrite */
#ifdef DMP_DEVICE2_BULKDATAREPORTS_1
    char *    name;	/**< ReadWrite */
#endif
    char *    controller;	/**< ReadOnly */
#ifdef DMP_DEVICE2_BULKDATAREPORTS_1
    SINT32    numberOfRetainedFailedReports;	/**< ReadWrite */
#endif
    char *    protocol;	/**< ReadWrite */
    char *    encodingType;	/**< ReadWrite */
    UINT32    reportingInterval;	/**< ReadWrite */
    DATETIME  timeReference;	/**< ReadWrite */
    UINT32    parameterNumberOfEntries;	/**< ReadOnly */
} Dev2BulkDataProfileObject;

/*! \brief _Dev2BulkDataProfileObject is used internally to represent Dev2BulkDataProfileObject */
typedef Dev2BulkDataProfileObject _Dev2BulkDataProfileObject;



/*! \brief Obj struct for Device.BulkData.Profile.{i}.Parameter.{i}.
 *
 * MDMOID_DEV2_BULK_DATA_PROFILE_PARAM 1762
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
#ifdef DMP_DEVICE2_BULKDATAREPORTS_1
    char *    name;	/**< ReadWrite */
#endif
    char *    reference;	/**< ReadWrite */
} Dev2BulkDataProfileParamObject;

/*! \brief _Dev2BulkDataProfileParamObject is used internally to represent Dev2BulkDataProfileParamObject */
typedef Dev2BulkDataProfileParamObject _Dev2BulkDataProfileParamObject;



/*! \brief Obj struct for Device.BulkData.Profile.{i}.JSONEncoding.
 *
 * MDMOID_DEV2_BULK_DATA_PROFILE_JSON_ENCODING 1764
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    reportFormat;	/**< ReadWrite */
    char *    reportTimestamp;	/**< ReadWrite */
} Dev2BulkDataProfileJsonEncodingObject;

/*! \brief _Dev2BulkDataProfileJsonEncodingObject is used internally to represent Dev2BulkDataProfileJsonEncodingObject */
typedef Dev2BulkDataProfileJsonEncodingObject _Dev2BulkDataProfileJsonEncodingObject;



/*! \brief Obj struct for Device.BulkData.Profile.{i}.HTTP.
 *
 * MDMOID_DEV2_BULK_DATA_PROFILE_HTTP 1765
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    URL;	/**< ReadWrite */
    char *    username;	/**< ReadWrite */
    char *    password;	/**< ReadWrite */
    char *    compressionsSupported;	/**< ReadOnly */
    char *    compression;	/**< ReadWrite */
    char *    methodsSupported;	/**< ReadOnly */
    char *    method;	/**< ReadWrite */
    UBOOL8    useDateHeader;	/**< ReadWrite */
    UBOOL8    retryEnable;	/**< ReadWrite */
    UINT32    retryMinimumWaitInterval;	/**< ReadWrite */
    UINT32    retryIntervalMultiplier;	/**< ReadWrite */
    UINT32    requestURIParameterNumberOfEntries;	/**< ReadOnly */
} Dev2BulkDataProfileHttpObject;

/*! \brief _Dev2BulkDataProfileHttpObject is used internally to represent Dev2BulkDataProfileHttpObject */
typedef Dev2BulkDataProfileHttpObject _Dev2BulkDataProfileHttpObject;



/*! \brief Obj struct for Device.BulkData.Profile.{i}.HTTP.RequestURIParameter.{i}.
 *
 * MDMOID_URI_PARAM 1766
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    name;	/**< ReadWrite */
    char *    reference;	/**< ReadWrite */
} Dev2BulkDataHttpReqURIParamObject;

/*! \brief _Dev2BulkDataHttpReqURIParamObject is used internally to represent Dev2BulkDataHttpReqURIParamObject */
typedef Dev2BulkDataHttpReqURIParamObject _Dev2BulkDataHttpReqURIParamObject;



/*! \brief Obj struct for Device.FAST.
 *
 * MDMOID_DEV2_FAST 3595
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    lineNumberOfEntries;	/**< ReadOnly */
} Dev2FastObject;

/*! \brief _Dev2FastObject is used internally to represent Dev2FastObject */
typedef Dev2FastObject _Dev2FastObject;



/*! \brief Obj struct for Device.FAST.Line.{i}.
 *
 * MDMOID_DEV2_FAST_LINE 3596
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    status;	/**< ReadOnly */
    char *    alias;	/**< ReadWrite */
    char *    name;	/**< ReadOnly */
    UINT32    lastChange;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_LastChange;	/**< ReadWrite */
    UINT32    X_BROADCOM_COM_BondingLineNumber;	/**< Read */
    char *    lowerLayers;	/**< ReadWrite */
    UBOOL8    upstream;	/**< ReadOnly */
    char *    firmwareVersion;	/**< ReadOnly */
    char *    linkStatus;	/**< ReadOnly */
    char *    allowedProfiles;	/**< ReadOnly */
    char *    currentProfile;	/**< ReadOnly */
    UBOOL8    X_BROADCOM_COM_FAST_106a;	/**< ReadWrite */
    UBOOL8    X_BROADCOM_COM_FAST_212a;	/**< ReadWrite */
    UBOOL8    X_BROADCOM_COM_FAST_106b;	/**< ReadWrite */
    UBOOL8    X_BROADCOM_COM_FAST_106c;	/**< ReadWrite */
    UBOOL8    X_BROADCOM_COM_FAST_212c;	/**< ReadWrite */
    UBOOL8    X_BROADCOM_COM_FAST_P424a;	/**< ReadWrite */
    UBOOL8    X_BROADCOM_COM_FAST_P424d;	/**< ReadWrite */
    UBOOL8    X_BROADCOM_COM_FAST_Q424c;	/**< ReadWrite */
    UBOOL8    X_BROADCOM_COM_FAST_Q424d;	/**< ReadWrite */
    UBOOL8    X_BROADCOM_COM_FAST_P424amp;	/**< ReadWrite */
    UBOOL8    X_BROADCOM_COM_FAST_P424dmp;	/**< ReadWrite */
    UBOOL8    X_BROADCOM_COM_FAST_Q424cmp;	/**< ReadWrite */
    UBOOL8    X_BROADCOM_COM_FAST_Q424dmp;	/**< ReadWrite */
    char *    powerManagementState;	/**< ReadOnly */
    UINT32    UPBOKLER;	/**< ReadOnly */
    UINT32    lastTransmittedDownstreamSignal;	/**< ReadOnly */
    UINT32    lastTransmittedUpstreamSignal;	/**< ReadOnly */
    UINT32    UPBOKLE;	/**< ReadOnly */
    SINT32    lineNumber;	/**< ReadOnly */
    UINT32    upstreamMaxBitRate;	/**< ReadOnly */
    UINT32    downstreamMaxBitRate;	/**< ReadOnly */
    SINT32    upstreamNoiseMargin;	/**< ReadOnly */
    SINT32    downstreamNoiseMargin;	/**< ReadOnly */
    SINT32    upstreamAttenuation;	/**< ReadOnly */
    SINT32    downstreamAttenuation;	/**< ReadOnly */
    SINT32    upstreamPower;	/**< ReadOnly */
    SINT32    downstreamPower;	/**< ReadOnly */
    SINT32    SNRRMCds;	/**< ReadOnly */
    SINT32    SNRRMCus;	/**< ReadOnly */
    char *    BITSRMCpsds;	/**< ReadOnly */
    char *    BITSRMCpsus;	/**< ReadOnly */
    UBOOL8    FEXTCANCELds;	/**< R */
    UBOOL8    FEXTCANCELus;	/**< R */
    UINT32    ETRds;	/**< ReadOnly */
    UINT32    ETRus;	/**< ReadOnly */
    UINT32    ATTETRds;	/**< ReadOnly */
    UINT32    ATTETRus;	/**< ReadOnly */
    UINT32    MINEFTR;	/**< ReadOnly */
} Dev2FastLineObject;

/*! \brief _Dev2FastLineObject is used internally to represent Dev2FastLineObject */
typedef Dev2FastLineObject _Dev2FastLineObject;



/*! \brief Obj struct for Device.FAST.Line.{i}.Stats.
 *
 * MDMOID_DEV2_FAST_LINE_STATS 3597
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT64    bytesSent;	/**< ReadOnly */
    UINT64    bytesReceived;	/**< ReadOnly */
    UINT64    packetsSent;	/**< ReadOnly */
    UINT64    packetsReceived;	/**< ReadOnly */
    UINT32    errorsSent;	/**< ReadOnly */
    UINT32    errorsReceived;	/**< ReadOnly */
    UINT32    discardPacketsSent;	/**< ReadOnly */
    UINT32    discardPacketsReceived;	/**< ReadOnly */
    UINT64    eocBytesSent;	/**< ReadOnly */
    UINT64    eocBytesReceived;	/**< ReadOnly */
    UINT64    eocPacketsSent;	/**< ReadOnly */
    UINT64    eocPacketsReceived;	/**< ReadOnly */
    UINT64    eocMessagesSent;	/**< ReadOnly */
    UINT64    eocMessagesReceived;	/**< ReadOnly */
    UINT32    totalStart;	/**< ReadOnly */
    UINT32    showtimeStart;	/**< ReadOnly */
    UINT32    lastShowtimeStart;	/**< ReadOnly */
    UINT32    currentDayStart;	/**< ReadOnly */
    UINT32    quarterHourStart;	/**< ReadOnly */
} Dev2FastLineStatsObject;

/*! \brief _Dev2FastLineStatsObject is used internally to represent Dev2FastLineStatsObject */
typedef Dev2FastLineStatsObject _Dev2FastLineStatsObject;



/*! \brief Obj struct for Device.FAST.Line.{i}.Stats.Total.
 *
 * MDMOID_DEV2_FAST_LINE_STATS_TOTAL 3598
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    erroredSecs;	/**< ReadOnly */
    UINT32    severelyErroredSecs;	/**< ReadOnly */
    UINT32    LOSS;	/**< ReadOnly */
    UINT32    LORS;	/**< ReadOnly */
    UINT32    UAS;	/**< ReadOnly */
    UINT32    RTXUC;	/**< ReadOnly */
    UINT32    RTXTX;	/**< ReadOnly */
    UINT32    successBSW;	/**< ReadOnly */
    UINT32    successSRA;	/**< ReadOnly */
    UINT32    successFRA;	/**< ReadOnly */
    UINT32    successRPA;	/**< ReadOnly */
    UINT32    successTIGA;	/**< ReadOnly */
} Dev2FastLineStatsTotalObject;

/*! \brief _Dev2FastLineStatsTotalObject is used internally to represent Dev2FastLineStatsTotalObject */
typedef Dev2FastLineStatsTotalObject _Dev2FastLineStatsTotalObject;



/*! \brief Obj struct for Device.FAST.Line.{i}.Stats.Showtime.
 *
 * MDMOID_DEV2_FAST_LINE_STATS_SHOWTIME 3599
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    erroredSecs;	/**< ReadOnly */
    UINT32    severelyErroredSecs;	/**< ReadOnly */
    UINT32    LOSS;	/**< ReadOnly */
    UINT32    LORS;	/**< ReadOnly */
    UINT32    UAS;	/**< ReadOnly */
    UINT32    RTXUC;	/**< ReadOnly */
    UINT32    RTXTX;	/**< ReadOnly */
    UINT32    successBSW;	/**< ReadOnly */
    UINT32    successSRA;	/**< ReadOnly */
    UINT32    successFRA;	/**< ReadOnly */
    UINT32    successRPA;	/**< ReadOnly */
    UINT32    successTIGA;	/**< ReadOnly */
} Dev2FastLineStatsShowtimeObject;

/*! \brief _Dev2FastLineStatsShowtimeObject is used internally to represent Dev2FastLineStatsShowtimeObject */
typedef Dev2FastLineStatsShowtimeObject _Dev2FastLineStatsShowtimeObject;



/*! \brief Obj struct for Device.FAST.Line.{i}.Stats.CurrentDay.
 *
 * MDMOID_DEV2_FAST_LINE_STATS_CURRENT_DAY 3601
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    erroredSecs;	/**< ReadOnly */
    UINT32    severelyErroredSecs;	/**< ReadOnly */
    UINT32    LOSS;	/**< ReadOnly */
    UINT32    LORS;	/**< ReadOnly */
    UINT32    UAS;	/**< ReadOnly */
    UINT32    RTXUC;	/**< ReadOnly */
    UINT32    RTXTX;	/**< ReadOnly */
    UINT32    successBSW;	/**< ReadOnly */
    UINT32    successSRA;	/**< ReadOnly */
    UINT32    successFRA;	/**< ReadOnly */
    UINT32    successRPA;	/**< ReadOnly */
    UINT32    successTIGA;	/**< ReadOnly */
} Dev2FastLineStatsCurrentDayObject;

/*! \brief _Dev2FastLineStatsCurrentDayObject is used internally to represent Dev2FastLineStatsCurrentDayObject */
typedef Dev2FastLineStatsCurrentDayObject _Dev2FastLineStatsCurrentDayObject;



/*! \brief Obj struct for Device.FAST.Line.{i}.Stats.QuarterHour.
 *
 * MDMOID_DEV2_FAST_LINE_STATS_QUARTER_HOUR 3602
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    erroredSecs;	/**< ReadOnly */
    UINT32    severelyErroredSecs;	/**< ReadOnly */
    UINT32    LOSS;	/**< ReadOnly */
    UINT32    LORS;	/**< ReadOnly */
    UINT32    UAS;	/**< ReadOnly */
    UINT32    RTXUC;	/**< ReadOnly */
    UINT32    RTXTX;	/**< ReadOnly */
    UINT32    successBSW;	/**< ReadOnly */
    UINT32    successSRA;	/**< ReadOnly */
    UINT32    successFRA;	/**< ReadOnly */
    UINT32    successRPA;	/**< ReadOnly */
    UINT32    successTIGA;	/**< ReadOnly */
} Dev2FastLineStatsQuarterHourObject;

/*! \brief _Dev2FastLineStatsQuarterHourObject is used internally to represent Dev2FastLineStatsQuarterHourObject */
typedef Dev2FastLineStatsQuarterHourObject _Dev2FastLineStatsQuarterHourObject;



/*! \brief Obj struct for Device.FAST.Line.{i}.TestParams.
 *
 * MDMOID_DEV2_FAST_LINE_TEST_PARAMS 3603
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    SNRGds;	/**< ReadOnly */
    UINT32    SNRGus;	/**< ReadOnly */
    char *    SNRpsds;	/**< ReadOnly */
    char *    SNRpsus;	/**< ReadOnly */
    UINT32    SNRMTds;	/**< ReadOnly */
    UINT32    SNRMTus;	/**< ReadOnly */
    UINT32    ACTINP;	/**< ReadOnly */
    UINT32    NFEC;	/**< ReadOnly */
    SINT32    RFEC;	/**< ReadOnly */
    UINT32    upstreamCurrRate;	/**< ReadOnly */
    UINT32    downstreamCurrRate;	/**< ReadOnly */
    UINT32    ACTINPREIN;	/**< ReadOnly */
} Dev2FastLineTestParamsObject;

/*! \brief _Dev2FastLineTestParamsObject is used internally to represent Dev2FastLineTestParamsObject */
typedef Dev2FastLineTestParamsObject _Dev2FastLineTestParamsObject;



/*! \brief Obj struct for Device.STOMP.
 *
 * MDMOID_DEV2_STOMP 1930
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    connectionNumberOfEntries;	/**< ReadOnly */
} Dev2StompObject;

/*! \brief _Dev2StompObject is used internally to represent Dev2StompObject */
typedef Dev2StompObject _Dev2StompObject;



/*! \brief Obj struct for Device.STOMP.Connection.{i}.
 *
 * MDMOID_DEV2_STOMP_CONNECTION 1931
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    alias;	/**< ReadWrite */
    UBOOL8    enable;	/**< ReadWrite */
    char *    status;	/**< ReadOnly */
    DATETIME  lastChangeDate;	/**< ReadOnly */
    char *    host;	/**< ReadWrite */
    UINT32    port;	/**< ReadWrite */
    char *    username;	/**< ReadWrite */
    char *    password;	/**< ReadWrite */
    char *    virtualHost;	/**< ReadWrite */
#ifdef DMP_DEVICE2_STOMPHEARTBEAT_1
    UBOOL8    enableHeartbeats;	/**< ReadWrite */
#endif
#ifdef DMP_DEVICE2_STOMPHEARTBEAT_1
    UINT32    outgoingHeartbeat;	/**< ReadWrite */
#endif
#ifdef DMP_DEVICE2_STOMPHEARTBEAT_1
    UINT32    incomingHeartbeat;	/**< ReadWrite */
#endif
    UINT32    serverRetryInitialInterval;	/**< ReadWrite */
    UINT32    serverRetryIntervalMultiplier;	/**< ReadWrite */
    UINT32    serverRetryMaxInterval;	/**< ReadWrite */
    UBOOL8    enableEncryption;	/**< ReadWrite */
} Dev2StompConnectionObject;

/*! \brief _Dev2StompConnectionObject is used internally to represent Dev2StompConnectionObject */
typedef Dev2StompConnectionObject _Dev2StompConnectionObject;



/*! \brief Obj struct for Device.MQTT.
 *
 * MDMOID_DEV2_MQTT 1935
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    clientNumberOfEntries;	/**< ReadOnly */
} Dev2MqttObject;

/*! \brief _Dev2MqttObject is used internally to represent Dev2MqttObject */
typedef Dev2MqttObject _Dev2MqttObject;



/*! \brief Obj struct for Device.MQTT.Capabilities.
 *
 * MDMOID_DEV2_MQTT_CAPABILITIES 1936
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    protocolVersionsSupported;	/**< ReadOnly */
#ifdef DMP_DEVICE2_MQTTCLIENTCON_1
    char *    transportProtocolSupported;	/**< ReadOnly */
#endif
    UINT32    maxNumberOfClientSubscriptions;	/**< ReadOnly */
} Dev2MqttCapabilitiesObject;

/*! \brief _Dev2MqttCapabilitiesObject is used internally to represent Dev2MqttCapabilitiesObject */
typedef Dev2MqttCapabilitiesObject _Dev2MqttCapabilitiesObject;



/*! \brief Obj struct for Device.MQTT.Client.{i}.
 *
 * MDMOID_DEV2_MQTT_CLIENT 1937
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    alias;	/**< ReadWrite */
#ifdef DMP_DEVICE2_MQTTCLIENTEXTENDED_1
    char *    name;	/**< ReadWrite */
#endif
    UBOOL8    enable;	/**< ReadWrite */
    char *    status;	/**< ReadOnly */
    char *    protocolVersion;	/**< ReadWrite */
    UBOOL8    enableEncryption;	/**< ReadWrite */
    char *    brokerAddress;	/**< ReadWrite */
    UINT32    brokerPort;	/**< ReadWrite */
#ifdef DMP_DEVICE2_MQTTCLIENTEXTENDED_1
    char *    transportProtocol;	/**< ReadWrite */
#endif
    UBOOL8    cleanSession;	/**< ReadWrite */
    UBOOL8    cleanStart;	/**< ReadWrite */
    UINT32    keepAliveTime;	/**< ReadWrite */
    UBOOL8    requestResponseInfo;	/**< ReadWrite */
    UBOOL8    requestProblemInfo;	/**< ReadWrite */
#ifdef DMP_DEVICE2_MQTTCLIENTEXTENDED_1
    char *    clientID;	/**< ReadWrite */
#endif
#ifdef DMP_DEVICE2_MQTTCLIENTEXTENDED_1
    char *    username;	/**< ReadWrite */
#endif
#ifdef DMP_DEVICE2_MQTTCLIENTEXTENDED_1
    char *    password;	/**< ReadWrite */
#endif
#ifdef DMP_DEVICE2_MQTTCLIENTEXTENDED_1
    UINT32    messageRetryTime;	/**< ReadWrite */
#endif
#ifdef DMP_DEVICE2_MQTTCLIENTEXTENDED_1
    UINT32    connectRetryTime;	/**< ReadWrite */
#endif
#ifdef DMP_DEVICE2_MQTTCLIENTCON_1
    UINT32    connectRetryIntervalMultiplier;	/**< ReadWrite */
#endif
#ifdef DMP_DEVICE2_MQTTCLIENTCON_1
    UINT32    connectRetryMaxInterval;	/**< ReadWrite */
#endif
#ifdef DMP_DEVICE2_MQTTCLIENTCON_1
    char *    responseInformation;	/**< ReadOnly */
#endif
#ifdef DMP_DEVICE2_MQTTCLIENTSUBSCRIBE_1
    UINT32    subscriptionNumberOfEntries;	/**< ReadOnly */
#endif
} Dev2MqttClientObject;

/*! \brief _Dev2MqttClientObject is used internally to represent Dev2MqttClientObject */
typedef Dev2MqttClientObject _Dev2MqttClientObject;



/*! \brief Obj struct for Device.MQTT.Client.{i}.Subscription.{i}.
 *
 * MDMOID_DEV2_MQTT_CLIENT_SUBSCRIPTION 1938
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    alias;	/**< ReadWrite */
    UBOOL8    enable;	/**< ReadWrite */
    char *    status;	/**< ReadOnly */
    char *    topic;	/**< ReadWrite */
    UINT32    qoS;	/**< ReadWrite */
} Dev2MqttClientSubscriptionObject;

/*! \brief _Dev2MqttClientSubscriptionObject is used internally to represent Dev2MqttClientSubscriptionObject */
typedef Dev2MqttClientSubscriptionObject _Dev2MqttClientSubscriptionObject;



/*! \brief Obj struct for Device.VXLAN.
 *
 * MDMOID_DEV2_VXLAN 1950
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    tunnelNumberOfEntries;	/**< ReadOnly */
#ifdef DMP_DEVICE2_VXLANADV_1
    UINT32    filterNumberOfEntries;	/**< ReadOnly */
#endif
    UINT32    X_BROADCOM_COM_TunnelIfNumOfEntries;	/**< ReadOnly */
} Dev2VxlanObject;

/*! \brief _Dev2VxlanObject is used internally to represent Dev2VxlanObject */
typedef Dev2VxlanObject _Dev2VxlanObject;



/*! \brief Obj struct for Device.VXLAN.Tunnel.{i}.
 *
 * MDMOID_DEV2_VXLAN_TUNNEL 1951
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    status;	/**< ReadOnly */
    char *    alias;	/**< ReadWrite */
    char *    remoteEndpoints;	/**< ReadWrite */
    char *    keepAlivePolicy;	/**< ReadWrite */
    UINT32    keepAliveTimeout;	/**< ReadWrite */
    UINT32    keepAliveThreshold;	/**< ReadWrite */
    char *    deliveryHeaderProtocol;	/**< ReadWrite */
#ifdef DMP_DEVICE2_VXLANADV_1
    UINT32    defaultDSCPMark;	/**< ReadWrite */
#endif
    char *    connectedRemoteEndpoint;	/**< ReadOnly */
    UINT32    interfaceNumberOfEntries;	/**< ReadOnly */
    UINT32    sourcePort;	/**< ReadWrite */
    UINT32    remotePort;	/**< ReadWrite */
} Dev2VxlanTunnelObject;

/*! \brief _Dev2VxlanTunnelObject is used internally to represent Dev2VxlanTunnelObject */
typedef Dev2VxlanTunnelObject _Dev2VxlanTunnelObject;



/*! \brief Obj struct for Device.VXLAN.Tunnel.{i}.Stats.
 *
 * MDMOID_DEV2_VXLAN_TUNNEL_STATS 1952
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
#ifdef DMP_DEVICE2_VXLANADV_1
    UINT32    keepAliveSent;	/**< ReadOnly */
#endif
#ifdef DMP_DEVICE2_VXLANADV_1
    UINT32    keepAliveReceived;	/**< ReadOnly */
#endif
    UINT64    bytesSent;	/**< ReadOnly */
    UINT64    bytesReceived;	/**< ReadOnly */
    UINT64    packetsSent;	/**< ReadOnly */
    UINT64    packetsReceived;	/**< ReadOnly */
    UINT32    errorsSent;	/**< ReadOnly */
    UINT32    errorsReceived;	/**< ReadOnly */
} Dev2VxlanTunnelStatsObject;

/*! \brief _Dev2VxlanTunnelStatsObject is used internally to represent Dev2VxlanTunnelStatsObject */
typedef Dev2VxlanTunnelStatsObject _Dev2VxlanTunnelStatsObject;



/*! \brief Obj struct for Device.VXLAN.Tunnel.{i}.Interface.{i}.
 *
 * MDMOID_DEV2_VXLAN_TUNNEL_INTERFACE 1953
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    status;	/**< ReadOnly */
    char *    alias;	/**< ReadWrite */
    char *    name;	/**< ReadWrite */
    UINT32    lastChange;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_LastChange;	/**< ReadWrite */
    char *    lowerLayers;	/**< ReadWrite */
    SINT32    VNI;	/**< ReadWrite */
    UBOOL8    X_BROADCOM_COM_L2_Mode;	/**< ReadWrite */
} Dev2VxlanTunnelInterfaceObject;

/*! \brief _Dev2VxlanTunnelInterfaceObject is used internally to represent Dev2VxlanTunnelInterfaceObject */
typedef Dev2VxlanTunnelInterfaceObject _Dev2VxlanTunnelInterfaceObject;



/*! \brief Obj struct for Device.VXLAN.Tunnel.{i}.Interface.{i}.Stats.
 *
 * MDMOID_DEV2_VXLAN_TUNNEL_INTERFACE_STATS 1954
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT64    bytesSent;	/**< ReadOnly */
    UINT64    bytesReceived;	/**< ReadOnly */
    UINT64    packetsSent;	/**< ReadOnly */
    UINT64    packetsReceived;	/**< ReadOnly */
    UINT32    errorsSent;	/**< ReadOnly */
    UINT32    errorsReceived;	/**< ReadOnly */
#ifdef DMP_DEVICE2_VXLANADV_1
    UINT32    discardChecksumReceived;	/**< ReadOnly */
#endif
#ifdef DMP_DEVICE2_VXLANADV_1
    UINT32    discardSequenceNumberReceived;	/**< ReadOnly */
#endif
} Dev2VxlanTunnelInterfaceStatsObject;

/*! \brief _Dev2VxlanTunnelInterfaceStatsObject is used internally to represent Dev2VxlanTunnelInterfaceStatsObject */
typedef Dev2VxlanTunnelInterfaceStatsObject _Dev2VxlanTunnelInterfaceStatsObject;



/*! \brief Obj struct for Device.GRE.
 *
 * MDMOID_DEV2_GRE 1980
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT32    tunnelNumberOfEntries;	/**< ReadOnly */
#ifdef DMP_DEVICE2_GREADV_1
    UINT32    filterNumberOfEntries;	/**< ReadOnly */
#endif
} Dev2GreObject;

/*! \brief _Dev2GreObject is used internally to represent Dev2GreObject */
typedef Dev2GreObject _Dev2GreObject;



/*! \brief Obj struct for Device.GRE.Tunnel.{i}.
 *
 * MDMOID_DEV2_GRE_TUNNEL 1981
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    status;	/**< ReadOnly */
    char *    alias;	/**< ReadWrite */
    char *    remoteEndpoints;	/**< ReadWrite */
    char *    keepAlivePolicy;	/**< ReadWrite */
    UINT32    keepAliveTimeout;	/**< ReadWrite */
    UINT32    keepAliveThreshold;	/**< ReadWrite */
    char *    deliveryHeaderProtocol;	/**< ReadWrite */
    UINT32    defaultDSCPMark;	/**< ReadWrite */
    char *    connectedRemoteEndpoint;	/**< ReadOnly */
    UINT32    interfaceNumberOfEntries;	/**< ReadOnly */
} Dev2GreTunnelObject;

/*! \brief _Dev2GreTunnelObject is used internally to represent Dev2GreTunnelObject */
typedef Dev2GreTunnelObject _Dev2GreTunnelObject;



/*! \brief Obj struct for Device.GRE.Tunnel.{i}.Stats.
 *
 * MDMOID_DEV2_GRE_TUNNEL_STATS 1982
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
#ifdef DMP_DEVICE2_GREADV_1
    UINT32    keepAliveSent;	/**< ReadOnly */
#endif
#ifdef DMP_DEVICE2_GREADV_1
    UINT32    keepAliveReceived;	/**< ReadOnly */
#endif
    UINT64    bytesSent;	/**< ReadOnly */
    UINT64    bytesReceived;	/**< ReadOnly */
    UINT64    packetsSent;	/**< ReadOnly */
    UINT64    packetsReceived;	/**< ReadOnly */
    UINT32    errorsSent;	/**< ReadOnly */
    UINT32    errorsReceived;	/**< ReadOnly */
} Dev2GreTunnelStatsObject;

/*! \brief _Dev2GreTunnelStatsObject is used internally to represent Dev2GreTunnelStatsObject */
typedef Dev2GreTunnelStatsObject _Dev2GreTunnelStatsObject;



/*! \brief Obj struct for Device.GRE.Tunnel.{i}.Interface.{i}.
 *
 * MDMOID_DEV2_GRE_TUNNEL_INTERFACE 1983
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    status;	/**< ReadOnly */
    char *    alias;	/**< ReadWrite */
    char *    name;	/**< ReadWrite */
    UINT32    lastChange;	/**< ReadOnly */
    UINT32    X_BROADCOM_COM_LastChange;	/**< ReadWrite */
    char *    lowerLayers;	/**< ReadWrite */
    UINT32    protocolIdOverride;	/**< ReadWrite */
    UBOOL8    useChecksum;	/**< ReadWrite */
#ifdef DMP_DEVICE2_GREADV_1
    char *    keyIdentifierGenerationPolicy;	/**< ReadWrite */
#endif
#ifdef DMP_DEVICE2_GREADV_1
    UINT32    keyIdentifier;	/**< ReadWrite */
#endif
#ifdef DMP_DEVICE2_GREADV_1
    UBOOL8    useSequenceNumber;	/**< ReadWrite */
#endif
    UBOOL8    X_BROADCOM_COM_L2_Mode;	/**< ReadWrite */
} Dev2GreTunnelInterfaceObject;

/*! \brief _Dev2GreTunnelInterfaceObject is used internally to represent Dev2GreTunnelInterfaceObject */
typedef Dev2GreTunnelInterfaceObject _Dev2GreTunnelInterfaceObject;



/*! \brief Obj struct for Device.GRE.Tunnel.{i}.Interface.{i}.Stats.
 *
 * MDMOID_DEV2_GRE_TUNNEL_INTERFACE_STATS 1984
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UINT64    bytesSent;	/**< ReadOnly */
    UINT64    bytesReceived;	/**< ReadOnly */
    UINT64    packetsSent;	/**< ReadOnly */
    UINT64    packetsReceived;	/**< ReadOnly */
    UINT32    errorsSent;	/**< ReadOnly */
    UINT32    errorsReceived;	/**< ReadOnly */
#ifdef DMP_DEVICE2_GREADV_1
    UINT32    discardChecksumReceived;	/**< ReadOnly */
#endif
#ifdef DMP_DEVICE2_GREADV_1
    UINT32    discardSequenceNumberReceived;	/**< ReadOnly */
#endif
} Dev2GreTunnelInterfaceStatsObject;

/*! \brief _Dev2GreTunnelInterfaceStatsObject is used internally to represent Dev2GreTunnelInterfaceStatsObject */
typedef Dev2GreTunnelInterfaceStatsObject _Dev2GreTunnelInterfaceStatsObject;



/*! \brief Obj struct for Device.USPAgent.
 *
 * MDMOID_USP_AGENT 2700
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    endpointID;	/**< ReadOnly */
    char *    softwareVersion;	/**< ReadOnly */
    UINT32    upTime;	/**< ReadOnly */
    char *    supportedProtocols;	/**< ReadOnly */
    char *    supportedFingerprintAlgorithms;	/**< ReadOnly */
    char *    advertisedDeviceSubtypes;	/**< ReadWrite */
    UINT32    maxSubscriptionChangeAdoptionTime;	/**< ReadWrite */
    char *    X_BROADCOM_COM_DualStackPreference;	/**< ReadWrite */
    UINT32    MTPNumberOfEntries;	/**< ReadOnly */
    UINT32    controllerNumberOfEntries;	/**< ReadOnly */
    UINT32    certificateNumberOfEntries;	/**< ReadOnly */
    char *    addCertificate;	/**< ReadWrite */
} Dev2USPAgentObject;

/*! \brief _Dev2USPAgentObject is used internally to represent Dev2USPAgentObject */
typedef Dev2USPAgentObject _Dev2USPAgentObject;



/*! \brief Obj struct for Device.USPAgent.MTP.{i}.
 *
 * MDMOID_USP_AGENT_MTP 2701
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    alias;	/**< ReadWrite */
    UBOOL8    enable;	/**< ReadWrite */
    char *    status;	/**< ReadOnly */
    char *    protocol;	/**< ReadWrite */
    UBOOL8    enableMDNS;	/**< ReadWrite */
} Dev2USPAgentMtpObject;

/*! \brief _Dev2USPAgentMtpObject is used internally to represent Dev2USPAgentMtpObject */
typedef Dev2USPAgentMtpObject _Dev2USPAgentMtpObject;



/*! \brief Obj struct for Device.USPAgent.MTP.{i}.STOMP.
 *
 * MDMOID_USP_AGENT_MTP_STOMP 2703
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    reference;	/**< ReadWrite */
    char *    destination;	/**< ReadWrite */
    char *    destinationFromServer;	/**< ReadOnly */
} Dev2USPAgentMtpStompObject;

/*! \brief _Dev2USPAgentMtpStompObject is used internally to represent Dev2USPAgentMtpStompObject */
typedef Dev2USPAgentMtpStompObject _Dev2USPAgentMtpStompObject;



/*! \brief Obj struct for Device.USPAgent.MTP.{i}.WebSocket.
 *
 * MDMOID_USP_AGENT_MTP_WEBSOCKET 2704
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    interfaces;	/**< ReadWrite */
    UINT32    port;	/**< ReadWrite */
    char *    path;	/**< ReadWrite */
    UBOOL8    enableEncryption;	/**< ReadWrite */
    UINT32    keepAliveInterval;	/**< ReadWrite */
} Dev2USPAgentMtpWebsocketObject;

/*! \brief _Dev2USPAgentMtpWebsocketObject is used internally to represent Dev2USPAgentMtpWebsocketObject */
typedef Dev2USPAgentMtpWebsocketObject _Dev2USPAgentMtpWebsocketObject;



/*! \brief Obj struct for Device.USPAgent.MTP.{i}.MQTT.
 *
 * MDMOID_USP_AGENT_MTP_MQTT 2705
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    reference;	/**< ReadWrite */
    char *    responseTopicConfigured;	/**< ReadWrite */
    char *    responseTopicDiscovered;	/**< ReadOnly */
    UINT32    publishQoS;	/**< ReadWrite */
} Dev2USPAgentMtpMqttObject;

/*! \brief _Dev2USPAgentMtpMqttObject is used internally to represent Dev2USPAgentMtpMqttObject */
typedef Dev2USPAgentMtpMqttObject _Dev2USPAgentMtpMqttObject;



/*! \brief Obj struct for Device.USPAgent.Controller.{i}.
 *
 * MDMOID_USP_AGENT_CONTROLLER 2706
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    alias;	/**< ReadWrite */
    char *    endpointID;	/**< ReadWrite */
    char *    controllerCode;	/**< ReadWrite */
    char *    provisioningCode;	/**< ReadWrite */
    UBOOL8    enable;	/**< ReadWrite */
    char *    assignedRole;	/**< ReadWrite */
    char *    inheritedRole;	/**< ReadOnly */
    char *    credential;	/**< ReadWrite */
    UINT32    periodicNotifInterval;	/**< ReadWrite */
    DATETIME  periodicNotifTime;	/**< ReadWrite */
    UINT32    USPNotifRetryMinimumWaitInterval;	/**< ReadWrite */
    UINT32    USPNotifRetryIntervalMultiplier;	/**< ReadWrite */
    UINT32    MTPNumberOfEntries;	/**< ReadOnly */
    UBOOL8    sendOnBoardRequest;	/**< ReadWrite */
} Dev2USPAgentControllerObject;

/*! \brief _Dev2USPAgentControllerObject is used internally to represent Dev2USPAgentControllerObject */
typedef Dev2USPAgentControllerObject _Dev2USPAgentControllerObject;



/*! \brief Obj struct for Device.USPAgent.Controller.{i}.MTP.{i}.
 *
 * MDMOID_USP_AGENT_CONTROLLER_MTP 2707
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    alias;	/**< ReadWrite */
    UBOOL8    enable;	/**< ReadWrite */
    char *    protocol;	/**< ReadWrite */
    UINT32    order;	/**< ReadWrite */
} Dev2USPAgentControllerMtpObject;

/*! \brief _Dev2USPAgentControllerMtpObject is used internally to represent Dev2USPAgentControllerMtpObject */
typedef Dev2USPAgentControllerMtpObject _Dev2USPAgentControllerMtpObject;



/*! \brief Obj struct for Device.USPAgent.Controller.{i}.MTP.{i}.STOMP.
 *
 * MDMOID_USP_AGENT_CONTROLLER_MTP_STOMP 2709
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    reference;	/**< ReadWrite */
    char *    destination;	/**< ReadWrite */
} Dev2USPAgentControllerMtpStompObject;

/*! \brief _Dev2USPAgentControllerMtpStompObject is used internally to represent Dev2USPAgentControllerMtpStompObject */
typedef Dev2USPAgentControllerMtpStompObject _Dev2USPAgentControllerMtpStompObject;



/*! \brief Obj struct for Device.USPAgent.Controller.{i}.MTP.{i}.WebSocket.
 *
 * MDMOID_USP_AGENT_CONTROLLER_MTP_WEBSOCKET 2710
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    host;	/**< ReadWrite */
    UINT32    port;	/**< ReadWrite */
    char *    path;	/**< ReadWrite */
    UBOOL8    enableEncryption;	/**< ReadWrite */
    UINT32    keepAliveInterval;	/**< ReadWrite */
    UINT32    currentRetryCount;	/**< ReadOnly */
    UINT32    sessionRetryMinimumWaitInterval;	/**< ReadWrite */
    UINT32    sessionRetryIntervalMultiplier;	/**< ReadWrite */
} Dev2USPAgentControllerMtpWebsocketObject;

/*! \brief _Dev2USPAgentControllerMtpWebsocketObject is used internally to represent Dev2USPAgentControllerMtpWebsocketObject */
typedef Dev2USPAgentControllerMtpWebsocketObject _Dev2USPAgentControllerMtpWebsocketObject;



/*! \brief Obj struct for Device.USPAgent.Controller.{i}.MTP.{i}.MQTT.
 *
 * MDMOID_USP_AGENT_CONTROLLER_MTP_MQTT 2711
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    reference;	/**< ReadWrite */
    char *    topic;	/**< ReadWrite */
    UBOOL8    publishRetainResponse;	/**< ReadWrite */
    UBOOL8    publishRetainNotify;	/**< ReadWrite */
} Dev2USPAgentControllerMtpMqttObject;

/*! \brief _Dev2USPAgentControllerMtpMqttObject is used internally to represent Dev2USPAgentControllerMtpMqttObject */
typedef Dev2USPAgentControllerMtpMqttObject _Dev2USPAgentControllerMtpMqttObject;



/*! \brief Obj struct for Device.USPAgent.Certificate.{i}.
 *
 * MDMOID_USP_AGENT_CERTIFICATE 2712
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    alias;	/**< ReadWrite */
    UBOOL8    enable;	/**< ReadWrite */
    char *    serialNumber;	/**< ReadOnly */
    char *    issuer;	/**< ReadOnly */
    char *    X_BROADCOM_COM_AltName;	/**< ReadOnly */
} Dev2USPAgentCertificateObject;

/*! \brief _Dev2USPAgentCertificateObject is used internally to represent Dev2USPAgentCertificateObject */
typedef Dev2USPAgentCertificateObject _Dev2USPAgentCertificateObject;



/*! \brief Obj struct for Device.USPAgent.ControllerTrust.
 *
 * MDMOID_USP_AGENT_CONTROLLERTRUST 2713
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    untrustedRole;	/**< ReadWrite */
    char *    bannedRole;	/**< ReadWrite */
    UBOOL8    TOFUAllowed;	/**< ReadWrite */
    UINT32    TOFUInactivityTimer;	/**< ReadWrite */
    UINT32    roleNumberOfEntries;	/**< ReadOnly */
    UINT32    credentialNumberOfEntries;	/**< ReadOnly */
    UINT32    challengeNumberOfEntries;	/**< ReadOnly */
} Dev2USPAgentControllertrustObject;

/*! \brief _Dev2USPAgentControllertrustObject is used internally to represent Dev2USPAgentControllertrustObject */
typedef Dev2USPAgentControllertrustObject _Dev2USPAgentControllertrustObject;



/*! \brief Obj struct for Device.USPAgent.ControllerTrust.Role.{i}.
 *
 * MDMOID_USP_AGENT_CONTROLLERTRUST_ROLE 2714
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    alias;	/**< ReadWrite */
    UBOOL8    enable;	/**< ReadWrite */
    char *    name;	/**< ReadWrite */
    UINT32    permissionNumberOfEntries;	/**< ReadOnly */
} Dev2USPAgentControllertrustRoleObject;

/*! \brief _Dev2USPAgentControllertrustRoleObject is used internally to represent Dev2USPAgentControllertrustRoleObject */
typedef Dev2USPAgentControllertrustRoleObject _Dev2USPAgentControllertrustRoleObject;



/*! \brief Obj struct for Device.USPAgent.ControllerTrust.Role.{i}.Permission.{i}.
 *
 * MDMOID_USP_AGENT_CONTROLLERTRUST_ROLE_PERMISSION 2715
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    alias;	/**< ReadWrite */
    UBOOL8    enable;	/**< ReadWrite */
    UINT32    order;	/**< ReadWrite */
    char *    targets;	/**< ReadWrite */
    char *    param;	/**< ReadWrite */
    char *    obj;	/**< ReadWrite */
    char *    instantiatedObj;	/**< ReadWrite */
    char *    commandEvent;	/**< ReadWrite */
} Dev2USPAgentControllertrustRolePermissionObject;

/*! \brief _Dev2USPAgentControllertrustRolePermissionObject is used internally to represent Dev2USPAgentControllertrustRolePermissionObject */
typedef Dev2USPAgentControllertrustRolePermissionObject _Dev2USPAgentControllertrustRolePermissionObject;



/*! \brief Obj struct for Device.USPAgent.ControllerTrust.Credential.{i}.
 *
 * MDMOID_USP_AGENT_CONTROLLERTRUST_CREDENTIAL 2716
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    alias;	/**< ReadWrite */
    UBOOL8    enable;	/**< ReadWrite */
    char *    role;	/**< ReadWrite */
    char *    credential;	/**< ReadWrite */
    char *    allowedUses;	/**< ReadWrite */
} Dev2USPAgentControllertrustCredentialObject;

/*! \brief _Dev2USPAgentControllertrustCredentialObject is used internally to represent Dev2USPAgentControllertrustCredentialObject */
typedef Dev2USPAgentControllertrustCredentialObject _Dev2USPAgentControllertrustCredentialObject;



/*! \brief Obj struct for Device.USPAgent.ControllerTrust.Challenge.{i}.
 *
 * MDMOID_USP_AGENT_CONTROLLERTRUST_CHALLENGE 2717
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    alias;	/**< ReadWrite */
    char *    description;	/**< ReadWrite */
    char *    role;	/**< ReadWrite */
    UBOOL8    enable;	/**< ReadWrite */
    char *    type;	/**< ReadWrite */
    BASE64    value;	/**< ReadWrite */
    char *    valueType;	/**< ReadWrite */
    BASE64    instruction;	/**< ReadWrite */
    char *    instructionType;	/**< ReadWrite */
    UINT32    retries;	/**< ReadWrite */
    SINT32    lockoutPeriod;	/**< ReadWrite */
} Dev2USPAgentControllertrustChallengeObject;

/*! \brief _Dev2USPAgentControllertrustChallengeObject is used internally to represent Dev2USPAgentControllertrustChallengeObject */
typedef Dev2USPAgentControllertrustChallengeObject _Dev2USPAgentControllertrustChallengeObject;



/*! \brief Obj struct for Device.X_BROADCOM_COM_BasdCfg.
 *
 * MDMOID_BASD_CFG 3390
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    status;	/**< ReadOnly */
    DATETIME  lastChange;	/**< ReadOnly */
    char *    statusChangeReason;	/**< ReadOnly */
    UBOOL8    restarting;	/**< ReadOnly */
    char *    URL;	/**< ReadWrite */
    char *    deviceId;	/**< ReadWrite */
    UINT32    retryMinimumWaitInterval;	/**< ReadWrite */
    UINT32    retryIntervalMultiplier;	/**< ReadWrite */
    UINT32    debugLevel;	/**< ReadWrite */
    char *    username;	/**< ReadWrite */
    char *    password;	/**< ReadWrite */
    UINT32    anomalyHistoryNumberOfEntries;	/**< ReadOnly */
    UINT32    maxAnomalyHistoryNumberOfEntries;	/**< ReadWrite */
} BasdCfgObject;

/*! \brief _BasdCfgObject is used internally to represent BasdCfgObject */
typedef BasdCfgObject _BasdCfgObject;



/*! \brief Obj struct for Device.X_BROADCOM_COM_BasdCfg.AnomalyHistory.{i}.
 *
 * MDMOID_BAS_HISTORY 3391
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    status;	/**< ReadOnly */
    DATETIME  lastChange;	/**< ReadOnly */
    char *    statusChangeReason;	/**< ReadOnly */
} BasHistoryObject;

/*! \brief _BasHistoryObject is used internally to represent BasHistoryObject */
typedef BasHistoryObject _BasHistoryObject;



/*! \brief Obj struct for Device.X_BROADCOM_COM_BasClients.{i}.
 *
 * MDMOID_BAS_CLIENT 3392
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    name;	/**< ReadOnly */
    UBOOL8    enable;	/**< ReadWrite */
    char *    status;	/**< ReadOnly */
    DATETIME  lastChange;	/**< ReadOnly */
    char *    statusChangeReason;	/**< ReadOnly */
    UBOOL8    restarting;	/**< ReadOnly */
    UBOOL8    isStatic;	/**< ReadOnly */
    char *    exeName;	/**< ReadOnly */
    char *    exeArgs;	/**< ReadWrite */
    UINT32    anomalyHistoryNumberOfEntries;	/**< ReadOnly */
    UINT32    maxAnomalyHistoryNumberOfEntries;	/**< ReadWrite */
} BasClientObject;

/*! \brief _BasClientObject is used internally to represent BasClientObject */
typedef BasClientObject _BasClientObject;



/*! \brief Obj struct for Device.X_BROADCOM_COM_BasClients.{i}.AnomalyHistory.{i}.
 *
 * MDMOID_BAS_CLIENT_HISTORY 3393
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    char *    status;	/**< ReadOnly */
    DATETIME  lastChange;	/**< ReadOnly */
    char *    statusChangeReason;	/**< ReadOnly */
} BasClientHistoryObject;

/*! \brief _BasClientHistoryObject is used internally to represent BasClientHistoryObject */
typedef BasClientHistoryObject _BasClientHistoryObject;



/*! \brief Obj struct for Device.X_BROADCOM_COM_OpenVSwitchCfg.
 *
 * MDMOID_DEV2_OPENVSWITCH_CFG 3820
 */
typedef struct
{
    MdmObjectId _oid;	/**< for internal use only */
    UINT16 _sequenceNum;	/**< for internal use only */
    UBOOL8    enable;	/**< ReadWrite */
    char *    status;	/**< ReadOnly */
    char *    OFControllerIPAddress;	/**< ReadWrite */
    UINT32    OFControllerPortNumber;	/**< ReadWrite */
} Dev2OpenvswitchCfgObject;

/*! \brief _Dev2OpenvswitchCfgObject is used internally to represent Dev2OpenvswitchCfgObject */
typedef Dev2OpenvswitchCfgObject _Dev2OpenvswitchCfgObject;





#endif /* __MDM_OBJECT_H__ */
