JAVA := java
ifeq ($(shell hash md5sum && echo y),y)
MD5 := md5sum
else
MD5 := perl $(HOSTTOOLS_DIR)/perlmd5/perlmd5.pl
endif
YUICOMPRESSOR_SCRIPT := $(HOSTTOOLS_DIR)/yuicompressor/yuicompressor-2.4.8.jar
# V-----------------------------------V
define CREATE_WEB_TRG

# 1: target name
# 2: source directory (relative to current dir)
# 3: target directory (relative to $(INSTALL_DIR)/webs)
# 4: staging directory (relative to current dir)
# 5: tar file
# 6: local file list (optional) - only copy over


# The CREATE_WEB_TRG creates several makefile targets within the calling makefile.   The
# main target is named after param1.  Invoking this target will cause all web files
# directory to be minimized and copyied to the target directory.    The web file list
# defaults to being all files under the source directroy (param2), unless a file list
# is specified (param6).  If a filelist is specified, then only files matching that
# list are copied.  Notice that wildcards are allowed in the filelist, but full
# pathnames are not (all files must be relative to the source directory (param2)).

# param4 - the staging directory, specifies a directory which is used to temporarily
# house the minimized files, and md5 sums before copying.

# once the files have been minimized, each minimized file, and the md5 sum of its source
# is added to the minimized file tarball (param5).  This prevents the minimizer from
# having to run on each make clean (minimization may take a significant amount of time).

# Files are only re-minimized if a) java is installed on the build system, and b) the
# source md5 does not match the md5 stored against the file within the tar file/ staging
# directory

# This also automatically creates a WEB_CLEAN target, and makes clean depend on this.
# This means if someone does a clean, the staging directory is wiped out, along with
# any files produced.

_SRC_DIR_$(strip $(1)) := $(abspath $(strip $(2)))
_TRG_DIR_$(strip $(1)) := $(shell [[ _$(strip $(3)) == _/* ]] && echo "$(strip $(3))" || echo "$$(INSTALL_DIR)/webs/$(strip $(3))")
_STG_DIR_$(strip $(1)) := $(abspath $(strip $(4)))
_TAR_FILE_$(strip $(1)) := $(abspath $(strip $(5)))

_SRCS_$(strip $(1)) := $$(shell cd $$(_SRC_DIR_$(strip $(1))); [ -z "$(6)" ] && find $(abspath $(strip $(2))) -type f || find $(6:%=$(abspath $(strip $(2)))/%) -type f  )
_STGS_$(strip $(1)) := $$(patsubst $$(_SRC_DIR_$(strip $(1)))/%,$$(_STG_DIR_$(strip $(1)))/%,$$(_SRCS_$(strip $(1))))
_TRGS_$(strip $(1)) := $$(patsubst $$(_SRC_DIR_$(strip $(1)))/%,$$(_TRG_DIR_$(strip $(1)))/%,$$(_SRCS_$(strip $(1))))

_UNTAR_MARK_$(strip $(1)) := $$(_STG_DIR_$(strip $(1)))/.untarred_$(strip $(1))   #file which signifies that untar is done

.SECONDARY: $$(_STGS_$(strip $(1)))

#$$(info "V---------------------------------V")
#$$(info "_SRC_DIR_$(strip $(1))   = $$(_SRC_DIR_$(strip $(1)))")
#$$(info "_TRG_DIR_$(strip $(1))   = $$(_TRG_DIR_$(strip $(1)))  ($(strip $(3)))")
#$$(info "_TAR_FILE_$(strip $(1))  = $$(_TAR_FILE_$(strip $(1)))")
#$$(info "_SRCS_$(strip $(1))      = $$(_SRCS_$(strip $(1)))")
#$$(info "_TRGS_$(strip $(1))      = $$(_TRGS_$(strip $(1)))")
#$$(info "^---------------------------------^")

$(strip $(1)): $$(_TRGS_$(strip $(1)))
	@echo "DONE $$@"

$$(_TRG_DIR_$(strip $(1)))/%: $$(_STG_DIR_$(strip $(1)))/%
	@echo "Installing $$(@F) ..."
	@mkdir -p $$(@D);
	@install -D -m 444 $$< $$(@D)

# do not minify js files that are already minified.
$$(_STG_DIR_$(strip $(1)))/%.min.js: $$(_SRC_DIR_$(strip $(1)))/%.min.js
	@echo "Staging $$(@F)";
	@mkdir -p $$(@D);
	@install -D -m 664 $$< $$(@D)

#Note: the following is run regardless of date stamps.
$$(_STG_DIR_$(strip $(1)))/%.js: $$(_SRC_DIR_$(strip $(1)))/%.js ALWAYS_RUN_$(strip $(1))
	@echo "Building $$@";
	@if [ -e $$(@) ] && [ -e $$(@).md5 ] && [ $$$$($(MD5) $$(<) | cut -c -32) == $$$$(cat $$(@).md5) ]; then \
		echo "Nothing to be done for $$(@F)"; \
	else \
		echo "Minify $$(@F)..."; \
		mkdir -p $$(@D); \
		if [ $(NO_MINIFY) ]; then \
			hash $(JAVA) 2>&- && $(JAVA) -jar $(YUICOMPRESSOR_SCRIPT) $$(<) > $$(@); \
			[ $$$$? != 0 ] && (echo "MINIFICATION FAILURE DETECTED: $$(@F)" >&2) && exit 1; \
			echo "Not minifying $$(@F)"; \
			mkdir -p $$(@D); \
			install -D -m 664 $$< $$(@D); \
		else \
			hash $(JAVA) 2>&- && $(JAVA) -jar $(YUICOMPRESSOR_SCRIPT) $$(<) > $$(@); \
			if [ $$$$? == 0 ]; then \
				$(MD5) $$(<) | cut -c -32 > $$(@).md5; \
				if [ -n $$(_TAR_FILE_$(strip $(1))) ]; then \
					if [ ! -e $$(_TAR_FILE_$(strip $(1))) ] || [ -w $$(_TAR_FILE_$(strip $(1))) ]; then \
						cd $$(_STG_DIR_$(strip $(1))); \
						while true; do mkdir $$(_STG_DIR_$(strip $(1)))/_mutex_dir 2> /dev/null && break; echo "WAITING FOR LOCK: $$@"; sleep 0.1;  done; \
						tar --delete -f $$(_TAR_FILE_$(strip $(1))) $$(@:$$(_STG_DIR_$(strip $(1)))/%=%) $$(@:$$(_STG_DIR_$(strip $(1)))/%=%).md5; \
						tar -upvf $$(_TAR_FILE_$(strip $(1))) $$(@:$$(_STG_DIR_$(strip $(1)))/%=%) $$(@:$$(_STG_DIR_$(strip $(1)))/%=%).md5; \
						rmdir $$(_STG_DIR_$(strip $(1)))/_mutex_dir 2> /dev/null; \
					else \
						echo "WARNING: COULD NOT UPDATE TAR FILE WITH MINIMIZED FILE - $$(_TAR_FILE_$(strip $(1)))" >&2; \
						echo "  Please ensure this file is checked out for edit" >&2; \
					fi; \
				fi; \
			else \
				echo "MINIFY FAILED $$(@F)..." >&2; \
				cp -f $$< $$@; \
				chmod +w $$@; \
			fi; \
		fi; \
	fi

# do not minify css files that are already minified.
$$(_STG_DIR_$(strip $(1)))/%.min.css: $$(_SRC_DIR_$(strip $(1)))/%.min.css
	@echo "Staging $$(@F)";
	@mkdir -p $$(@D);
	@install -m 664 $$< $$(@D);

#Note: the following is run regardless of date stamps.
$$(_STG_DIR_$(strip $(1)))/%.css: $$(_SRC_DIR_$(strip $(1)))/%.css ALWAYS_RUN_$(strip $(1))
	@echo "Building $$@";
	@if [ -e $$(@) ] && [ -e $$(@).md5 ] && [ $$$$(md5sum $$(<) | cut -c -32) == $$$$(cat $$(@).md5) ]; then \
		echo "Nothing to be done for $$(@F)"; \
	else \
		echo "Minify $$(@F)..."; \
		mkdir -p $$(@D); \
		if [ $(NO_MINIFY) ]; then \
			hash $(JAVA) 2>&- && $(JAVA) -jar $(YUICOMPRESSOR_SCRIPT) $$(<) > $$(@); \
			[ $$$$? != 0 ] && (echo "MINIFICATION FAILURE DETECTED: $$(@F)" >&2) && exit 1; \
			echo "Not minifying $$(@F)"; \
			mkdir -p $$(@D); \
			install -D -m 664 $$< $$(@D); \
		else \
			hash $(JAVA) 2>&- && $(JAVA) -jar $(YUICOMPRESSOR_SCRIPT) $$(<) > $$(@); \
			if [ $$$$? == 0 ]; then \
				$(MD5) $$(<) | cut -c -32 > $$(@).md5; \
				if [ -n $$(_TAR_FILE_$(strip $(1))) ]; then \
					if [ ! -e $$(_TAR_FILE_$(strip $(1))) ] || [ -w $$(_TAR_FILE_$(strip $(1))) ]; then \
						cd $$(_STG_DIR_$(strip $(1))); \
						while true; do mkdir $$(_STG_DIR_$(strip $(1)))/_mutex_dir 2> /dev/null && break; echo "WAITING FOR LOCK: $$@"; sleep 0.1; done; \
						tar --delete -f $$(_TAR_FILE_$(strip $(1))) $$(@:$$(_STG_DIR_$(strip $(1)))/%=%) $$(@:$$(_STG_DIR_$(strip $(1)))/%=%).md5; \
						tar -upvf $$(_TAR_FILE_$(strip $(1))) $$(@:$$(_STG_DIR_$(strip $(1)))/%=%) $$(@:$$(_STG_DIR_$(strip $(1)))/%=%).md5; \
						rmdir $$(_STG_DIR_$(strip $(1)))/_mutex_dir 2> /dev/null; \
					else \
						echo "WARNING: COULD NOT UPDATE TAR FILE WITH MINIMIZED FILE - $$(_TAR_FILE_$(strip $(1)))" >&2; \
						echo "  Please ensure this file is checked out for edit" >&2; \
					fi; \
				fi; \
			else \
				echo "MINIFY FAILED $$(@F)..."; >&2 \
				mkdir -p $$(@D); \
				install -D -m 664 $$< $$(@D); \
			fi; \
		fi; \
	fi

ALWAYS_RUN_$(strip $(1)):
	@echo "Building $(strip $(1))"
	@rmdir $$(_STG_DIR_$(strip $(1)))/_mutex_dir 2> /dev/null || true

.PHONY: ALWAYS_RUN_$(strip $(1)) WEB_CLEAN_$(strip $(1)) $(strip $(1))

$$(_STG_DIR_$(strip $(1)))/%: $$(_SRC_DIR_$(strip $(1)))/%
	@echo "Staging $$(@F) ..."
	@mkdir -p $$(@D);
	@install -D -m 664 $$< $$(@D)

# for performance, we only want to do a single untar.
$$(_UNTAR_MARK_$(strip $(1))):
	@echo "running $$@"
	@mkdir -p $$(_STG_DIR_$(strip $(1)))
	@[ -f $$(_TAR_FILE_$(strip $(1))) ] && tar -xf $$(_TAR_FILE_$(strip $(1))) -C $$(_STG_DIR_$(strip $(1))) || true
	touch $$@

$$(_STGS_$(strip $(1))): | $$(_UNTAR_MARK_$(strip $(1)))

clean: WEB_CLEAN_$(strip $(1))

WEB_CLEAN_$(strip $(1)):
	@echo "running $$@"
	-rm -f $$(_TRGS_$(strip $(1)))
	-rm -rf $$(_STG_DIR_$(strip $(1)))
	-rm -f $$(_UNTAR_MARK_$(strip $(1)))

endef
# ^-----------------------------------^

