/*
 * Copyright (c) 2008-2018, Qualcomm Technologies, Inc.
 * All Rights Reserved.
 * Confidential and Proprietary - Qualcomm Technologies, Inc.
 * 2008 - 2016 Qualcomm Atheros, Inc.
 */
/*                                                                           */
/* File:       /trees/yli/yli-dev/chips/osprey/2.0/blueprint/top/osprey_reg_map_macro.h*/
/* Creator:    yli                                                           */
/* Time:       Wednesday Jan 6, 2010 [2:09:02 pm]                            */
/*                                                                           */
/* Path:       /trees/yli/yli-dev/chips/osprey/2.0/blueprint/top             */
/* Arguments:  /cad/denali/blueprint/3.7//Linux/blueprint -codegen           */
/*             /trees/yli/yli-dev/chips/osprey/2.0/env/blueprint/ath_ansic.codegen*/
/*             -ath_ansic -Wdesc -I                                          */
/*             /trees/yli/yli-dev/chips/osprey/2.0/blueprint/top -I          */
/*             /trees/yli/yli-dev/chips/osprey/2.0/blueprint -I              */
/*             /trees/yli/yli-dev/chips/osprey/2.0/env/blueprint -I          */
/*             /trees/yli/yli-dev/chips/osprey/2.0/blueprint/sysconfig -odir */
/*             /trees/yli/yli-dev/chips/osprey/2.0/blueprint/top -eval       */
/*             {$INCLUDE_SYSCONFIG_FILES=1} -eval                            */
/*             $WAR_EV58615_for_ansic_codegen=1 osprey_reg.rdl               */
/*                                                                           */
/* Sources:    /trees/yli/yli-dev/chips/osprey/2.0/blueprint/top/emulation_misc.rdl*/
/*             /trees/yli/yli-dev/chips/osprey/2.0/blueprint/sysconfig/mac_dma_reg_sysconfig.rdl*/
/*             /trees/yli/yli-dev/chips/osprey/2.0/rtl/amba_mac/svd/blueprint/svd_reg.rdl*/
/*             /trees/yli/yli-dev/chips/osprey/2.0/blueprint/sysconfig/mac_pcu_reg_sysconfig.rdl*/
/*             /trees/yli/yli-dev/chips/osprey/2.0/blueprint/top/merlin2_0_radio_reg_map.rdl*/
/*             /trees/yli/yli-dev/chips/osprey/2.0/rtl/mac/rtl/mac_dma/blueprint/mac_dma_reg.rdl*/
/*             /trees/yli/yli-dev/chips/osprey/2.0/rtl/host_intf/rtl/blueprint/efuse_reg.rdl*/
/*             /trees/yli/yli-dev/chips/osprey/2.0/rtl/mac/rtl/mac_dma/blueprint/mac_dcu_reg.rdl*/
/*             /trees/yli/yli-dev/chips/osprey/2.0/ip/pcie_axi/blueprint/DWC_pcie_ep.rdl*/
/*             /trees/yli/yli-dev/chips/osprey/2.0/rtl/apb_analog/analog_intf_reg.rdl*/
/*             /trees/yli/yli-dev/chips/osprey/2.0/rtl/mac/rtl/mac_pcu/blueprint/mac_pcu_reg.rdl*/
/*             /trees/yli/yli-dev/chips/osprey/2.0/rtl/rtc/blueprint/rtc_reg.rdl*/
/*             /trees/yli/yli-dev/chips/osprey/2.0/blueprint/sysconfig/DWC_pcie_dbi_axi_sysconfig.rdl*/
/*             /trees/yli/yli-dev/chips/osprey/2.0/rtl/host_intf/rtl/blueprint/host_intf_reg.rdl*/
/*             /trees/yli/yli-dev/chips/osprey/2.0/rtl/mac/rtl/mac_dma/blueprint/mac_qcu_reg.rdl*/
/*             /trees/yli/yli-dev/chips/osprey/2.0/rtl/bb/blueprint/bb_reg_map.rdl*/
/*             /trees/yli/yli-dev/chips/osprey/2.0/blueprint/sysconfig/rtc_reg_sysconfig.rdl*/
/*             /trees/yli/yli-dev/chips/osprey/2.0/blueprint/sysconfig/efuse_reg_sysconfig.rdl*/
/*             /trees/yli/yli-dev/chips/osprey/2.0/blueprint/sysconfig/bb_reg_map_sysconfig.rdl*/
/*             /trees/yli/yli-dev/chips/osprey/2.0/blueprint/sysconfig/osprey_pcieconfig.rdl*/
/*             /trees/yli/yli-dev/chips/osprey/2.0/blueprint/top/osprey_reg.rdl*/
/*             /trees/yli/yli-dev/chips/osprey/2.0/blueprint/sysconfig/radio_65_reg_sysconfig.rdl*/
/*             /trees/yli/yli-dev/chips/osprey/2.0/blueprint/sysconfig/merlin2_0_radio_reg_sysconfig.rdl*/
/*             /trees/yli/yli-dev/chips/osprey/2.0/blueprint/sysconfig/mac_qcu_reg_sysconfig.rdl*/
/*             /trees/yli/yli-dev/chips/osprey/2.0/blueprint/sysconfig/mac_dcu_reg_sysconfig.rdl*/
/*             /trees/yli/yli-dev/chips/osprey/2.0/rtl/amba_mac/blueprint/rtc_sync_reg.rdl*/
/*             /trees/yli/yli-dev/chips/osprey/2.0/blueprint/sysconfig/analog_intf_reg_sysconfig.rdl*/
/*             /trees/yli/yli-dev/chips/osprey/2.0/blueprint/sysconfig/svd_reg_sysconfig.rdl*/
/*             /trees/yli/yli-dev/chips/osprey/2.0/blueprint/top/osprey_radio_reg.rdl*/
/*             /trees/yli/yli-dev/chips/osprey/2.0/blueprint/sysconfig/host_intf_reg_sysconfig.rdl*/
/*             /trees/yli/yli-dev/chips/osprey/2.0/env/blueprint/ath_ansic.pm*/
/*             /cad/local/lib/perl/Pinfo.pm                                  */
/*                                                                           */
/* Blueprint:   3.7 (Fri Oct 5 10:32:33 PDT 2007)                            */
/* Machine:    artemis                                                       */
/* OS:         Linux 2.6.9-78.0.5.ELlargesmp                                 */
/* Description:                                                              */
/*                                                                           */
/*This Register Map contains the complete register set for OSPREY.           */
/*                                                                           */
/*                                                                           */


#ifndef __REG_OSPREY_REG_MAP_MACRO_H__
#define __REG_OSPREY_REG_MAP_MACRO_H__


/* macros for BlueprintGlobalNameSpace::MAC_DMA_CR */
#ifndef __MAC_DMA_CR_MACRO__
#define __MAC_DMA_CR_MACRO__

/* macros for field RXE_LP */
#define MAC_DMA_CR__RXE_LP__SHIFT                                             2
#define MAC_DMA_CR__RXE_LP__WIDTH                                             1
#define MAC_DMA_CR__RXE_LP__MASK                                    0x00000004U
#define MAC_DMA_CR__RXE_LP__READ(src)   (((u_int32_t)(src) & 0x00000004U) >> 2)
#define MAC_DMA_CR__RXE_LP__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000004U) | ((u_int32_t)(1) << 2)
#define MAC_DMA_CR__RXE_LP__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000004U) | ((u_int32_t)(0) << 2)

/* macros for field RXE_HP */
#define MAC_DMA_CR__RXE_HP__SHIFT                                             3
#define MAC_DMA_CR__RXE_HP__WIDTH                                             1
#define MAC_DMA_CR__RXE_HP__MASK                                    0x00000008U
#define MAC_DMA_CR__RXE_HP__READ(src)   (((u_int32_t)(src) & 0x00000008U) >> 3)
#define MAC_DMA_CR__RXE_HP__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000008U) | ((u_int32_t)(1) << 3)
#define MAC_DMA_CR__RXE_HP__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000008U) | ((u_int32_t)(0) << 3)

/* macros for field RXD */
#define MAC_DMA_CR__RXD__SHIFT                                                5
#define MAC_DMA_CR__RXD__WIDTH                                                1
#define MAC_DMA_CR__RXD__MASK                                       0x00000020U
#define MAC_DMA_CR__RXD__READ(src)      (((u_int32_t)(src) & 0x00000020U) >> 5)
#define MAC_DMA_CR__RXD__WRITE(src)     (((u_int32_t)(src) << 5) & 0x00000020U)
#define MAC_DMA_CR__RXD__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000020U) | (((u_int32_t)(src) <<\
                    5) & 0x00000020U)
#define MAC_DMA_CR__RXD__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 5) & ~0x00000020U)))
#define MAC_DMA_CR__RXD__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000020U) | ((u_int32_t)(1) << 5)
#define MAC_DMA_CR__RXD__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000020U) | ((u_int32_t)(0) << 5)

/* macros for field SWI */
#define MAC_DMA_CR__SWI__SHIFT                                                6
#define MAC_DMA_CR__SWI__WIDTH                                                1
#define MAC_DMA_CR__SWI__MASK                                       0x00000040U
#define MAC_DMA_CR__SWI__READ(src)      (((u_int32_t)(src) & 0x00000040U) >> 6)
#define MAC_DMA_CR__SWI__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000040U) | ((u_int32_t)(1) << 6)
#define MAC_DMA_CR__SWI__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000040U) | ((u_int32_t)(0) << 6)
#define MAC_DMA_CR__TYPE                                              u_int32_t
#define MAC_DMA_CR__READ                                            0x0000006cU
#define MAC_DMA_CR__WRITE                                           0x0000006cU

#endif /* __MAC_DMA_CR_MACRO__ */


/* macros for mac_dma_reg_block.MAC_DMA_CR */
#define INST_MAC_DMA_REG_BLOCK__MAC_DMA_CR__NUM                               1

/* macros for BlueprintGlobalNameSpace::MAC_DMA_CFG */
#ifndef __MAC_DMA_CFG_MACRO__
#define __MAC_DMA_CFG_MACRO__

/* macros for field BE_MODE_XMIT_DESC */
#define MAC_DMA_CFG__BE_MODE_XMIT_DESC__SHIFT                                 0
#define MAC_DMA_CFG__BE_MODE_XMIT_DESC__WIDTH                                 1
#define MAC_DMA_CFG__BE_MODE_XMIT_DESC__MASK                        0x00000001U
#define MAC_DMA_CFG__BE_MODE_XMIT_DESC__READ(src) \
                    (u_int32_t)(src)\
                    & 0x00000001U
#define MAC_DMA_CFG__BE_MODE_XMIT_DESC__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x00000001U)
#define MAC_DMA_CFG__BE_MODE_XMIT_DESC__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | ((u_int32_t)(src) &\
                    0x00000001U)
#define MAC_DMA_CFG__BE_MODE_XMIT_DESC__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00000001U)))
#define MAC_DMA_CFG__BE_MODE_XMIT_DESC__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(1)
#define MAC_DMA_CFG__BE_MODE_XMIT_DESC__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(0)

/* macros for field BE_MODE_XMIT_DATA */
#define MAC_DMA_CFG__BE_MODE_XMIT_DATA__SHIFT                                 1
#define MAC_DMA_CFG__BE_MODE_XMIT_DATA__WIDTH                                 1
#define MAC_DMA_CFG__BE_MODE_XMIT_DATA__MASK                        0x00000002U
#define MAC_DMA_CFG__BE_MODE_XMIT_DATA__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000002U) >> 1)
#define MAC_DMA_CFG__BE_MODE_XMIT_DATA__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 1) & 0x00000002U)
#define MAC_DMA_CFG__BE_MODE_XMIT_DATA__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | (((u_int32_t)(src) <<\
                    1) & 0x00000002U)
#define MAC_DMA_CFG__BE_MODE_XMIT_DATA__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 1) & ~0x00000002U)))
#define MAC_DMA_CFG__BE_MODE_XMIT_DATA__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | ((u_int32_t)(1) << 1)
#define MAC_DMA_CFG__BE_MODE_XMIT_DATA__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | ((u_int32_t)(0) << 1)

/* macros for field BE_MODE_RCV_DESC */
#define MAC_DMA_CFG__BE_MODE_RCV_DESC__SHIFT                                  2
#define MAC_DMA_CFG__BE_MODE_RCV_DESC__WIDTH                                  1
#define MAC_DMA_CFG__BE_MODE_RCV_DESC__MASK                         0x00000004U
#define MAC_DMA_CFG__BE_MODE_RCV_DESC__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000004U) >> 2)
#define MAC_DMA_CFG__BE_MODE_RCV_DESC__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 2) & 0x00000004U)
#define MAC_DMA_CFG__BE_MODE_RCV_DESC__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000004U) | (((u_int32_t)(src) <<\
                    2) & 0x00000004U)
#define MAC_DMA_CFG__BE_MODE_RCV_DESC__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 2) & ~0x00000004U)))
#define MAC_DMA_CFG__BE_MODE_RCV_DESC__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000004U) | ((u_int32_t)(1) << 2)
#define MAC_DMA_CFG__BE_MODE_RCV_DESC__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000004U) | ((u_int32_t)(0) << 2)

/* macros for field BE_MODE_RCV_DATA */
#define MAC_DMA_CFG__BE_MODE_RCV_DATA__SHIFT                                  3
#define MAC_DMA_CFG__BE_MODE_RCV_DATA__WIDTH                                  1
#define MAC_DMA_CFG__BE_MODE_RCV_DATA__MASK                         0x00000008U
#define MAC_DMA_CFG__BE_MODE_RCV_DATA__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000008U) >> 3)
#define MAC_DMA_CFG__BE_MODE_RCV_DATA__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 3) & 0x00000008U)
#define MAC_DMA_CFG__BE_MODE_RCV_DATA__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000008U) | (((u_int32_t)(src) <<\
                    3) & 0x00000008U)
#define MAC_DMA_CFG__BE_MODE_RCV_DATA__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 3) & ~0x00000008U)))
#define MAC_DMA_CFG__BE_MODE_RCV_DATA__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000008U) | ((u_int32_t)(1) << 3)
#define MAC_DMA_CFG__BE_MODE_RCV_DATA__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000008U) | ((u_int32_t)(0) << 3)

/* macros for field BE_MODE_MMR */
#define MAC_DMA_CFG__BE_MODE_MMR__SHIFT                                       4
#define MAC_DMA_CFG__BE_MODE_MMR__WIDTH                                       1
#define MAC_DMA_CFG__BE_MODE_MMR__MASK                              0x00000010U
#define MAC_DMA_CFG__BE_MODE_MMR__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000010U) >> 4)
#define MAC_DMA_CFG__BE_MODE_MMR__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 4) & 0x00000010U)
#define MAC_DMA_CFG__BE_MODE_MMR__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000010U) | (((u_int32_t)(src) <<\
                    4) & 0x00000010U)
#define MAC_DMA_CFG__BE_MODE_MMR__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 4) & ~0x00000010U)))
#define MAC_DMA_CFG__BE_MODE_MMR__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000010U) | ((u_int32_t)(1) << 4)
#define MAC_DMA_CFG__BE_MODE_MMR__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000010U) | ((u_int32_t)(0) << 4)

/* macros for field ADHOC */
#define MAC_DMA_CFG__ADHOC__SHIFT                                             5
#define MAC_DMA_CFG__ADHOC__WIDTH                                             1
#define MAC_DMA_CFG__ADHOC__MASK                                    0x00000020U
#define MAC_DMA_CFG__ADHOC__READ(src)   (((u_int32_t)(src) & 0x00000020U) >> 5)
#define MAC_DMA_CFG__ADHOC__WRITE(src)  (((u_int32_t)(src) << 5) & 0x00000020U)
#define MAC_DMA_CFG__ADHOC__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000020U) | (((u_int32_t)(src) <<\
                    5) & 0x00000020U)
#define MAC_DMA_CFG__ADHOC__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 5) & ~0x00000020U)))
#define MAC_DMA_CFG__ADHOC__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000020U) | ((u_int32_t)(1) << 5)
#define MAC_DMA_CFG__ADHOC__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000020U) | ((u_int32_t)(0) << 5)

/* macros for field PHY_OK */
#define MAC_DMA_CFG__PHY_OK__SHIFT                                            8
#define MAC_DMA_CFG__PHY_OK__WIDTH                                            1
#define MAC_DMA_CFG__PHY_OK__MASK                                   0x00000100U
#define MAC_DMA_CFG__PHY_OK__READ(src)  (((u_int32_t)(src) & 0x00000100U) >> 8)
#define MAC_DMA_CFG__PHY_OK__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000100U) | ((u_int32_t)(1) << 8)
#define MAC_DMA_CFG__PHY_OK__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000100U) | ((u_int32_t)(0) << 8)

/* macros for field EEPROM_BUSY */
#define MAC_DMA_CFG__EEPROM_BUSY__SHIFT                                       9
#define MAC_DMA_CFG__EEPROM_BUSY__WIDTH                                       1
#define MAC_DMA_CFG__EEPROM_BUSY__MASK                              0x00000200U
#define MAC_DMA_CFG__EEPROM_BUSY__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000200U) >> 9)
#define MAC_DMA_CFG__EEPROM_BUSY__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000200U) | ((u_int32_t)(1) << 9)
#define MAC_DMA_CFG__EEPROM_BUSY__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000200U) | ((u_int32_t)(0) << 9)

/* macros for field CLKGATE_DIS */
#define MAC_DMA_CFG__CLKGATE_DIS__SHIFT                                      10
#define MAC_DMA_CFG__CLKGATE_DIS__WIDTH                                       1
#define MAC_DMA_CFG__CLKGATE_DIS__MASK                              0x00000400U
#define MAC_DMA_CFG__CLKGATE_DIS__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000400U) >> 10)
#define MAC_DMA_CFG__CLKGATE_DIS__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 10) & 0x00000400U)
#define MAC_DMA_CFG__CLKGATE_DIS__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000400U) | (((u_int32_t)(src) <<\
                    10) & 0x00000400U)
#define MAC_DMA_CFG__CLKGATE_DIS__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 10) & ~0x00000400U)))
#define MAC_DMA_CFG__CLKGATE_DIS__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000400U) | ((u_int32_t)(1) << 10)
#define MAC_DMA_CFG__CLKGATE_DIS__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000400U) | ((u_int32_t)(0) << 10)

/* macros for field HALT_REQ */
#define MAC_DMA_CFG__HALT_REQ__SHIFT                                         11
#define MAC_DMA_CFG__HALT_REQ__WIDTH                                          1
#define MAC_DMA_CFG__HALT_REQ__MASK                                 0x00000800U
#define MAC_DMA_CFG__HALT_REQ__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000800U) >> 11)
#define MAC_DMA_CFG__HALT_REQ__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 11) & 0x00000800U)
#define MAC_DMA_CFG__HALT_REQ__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000800U) | (((u_int32_t)(src) <<\
                    11) & 0x00000800U)
#define MAC_DMA_CFG__HALT_REQ__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 11) & ~0x00000800U)))
#define MAC_DMA_CFG__HALT_REQ__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000800U) | ((u_int32_t)(1) << 11)
#define MAC_DMA_CFG__HALT_REQ__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000800U) | ((u_int32_t)(0) << 11)

/* macros for field HALT_ACK */
#define MAC_DMA_CFG__HALT_ACK__SHIFT                                         12
#define MAC_DMA_CFG__HALT_ACK__WIDTH                                          1
#define MAC_DMA_CFG__HALT_ACK__MASK                                 0x00001000U
#define MAC_DMA_CFG__HALT_ACK__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00001000U) >> 12)
#define MAC_DMA_CFG__HALT_ACK__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00001000U) | ((u_int32_t)(1) << 12)
#define MAC_DMA_CFG__HALT_ACK__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00001000U) | ((u_int32_t)(0) << 12)

/* macros for field REQ_Q_FULL_THRESHOLD */
#define MAC_DMA_CFG__REQ_Q_FULL_THRESHOLD__SHIFT                             17
#define MAC_DMA_CFG__REQ_Q_FULL_THRESHOLD__WIDTH                              2
#define MAC_DMA_CFG__REQ_Q_FULL_THRESHOLD__MASK                     0x00060000U
#define MAC_DMA_CFG__REQ_Q_FULL_THRESHOLD__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00060000U) >> 17)
#define MAC_DMA_CFG__REQ_Q_FULL_THRESHOLD__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 17) & 0x00060000U)
#define MAC_DMA_CFG__REQ_Q_FULL_THRESHOLD__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00060000U) | (((u_int32_t)(src) <<\
                    17) & 0x00060000U)
#define MAC_DMA_CFG__REQ_Q_FULL_THRESHOLD__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 17) & ~0x00060000U)))

/* macros for field MISSING_TX_INTR_FIX_ENABLE */
#define MAC_DMA_CFG__MISSING_TX_INTR_FIX_ENABLE__SHIFT                       19
#define MAC_DMA_CFG__MISSING_TX_INTR_FIX_ENABLE__WIDTH                        1
#define MAC_DMA_CFG__MISSING_TX_INTR_FIX_ENABLE__MASK               0x00080000U
#define MAC_DMA_CFG__MISSING_TX_INTR_FIX_ENABLE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00080000U) >> 19)
#define MAC_DMA_CFG__MISSING_TX_INTR_FIX_ENABLE__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 19) & 0x00080000U)
#define MAC_DMA_CFG__MISSING_TX_INTR_FIX_ENABLE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00080000U) | (((u_int32_t)(src) <<\
                    19) & 0x00080000U)
#define MAC_DMA_CFG__MISSING_TX_INTR_FIX_ENABLE__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 19) & ~0x00080000U)))
#define MAC_DMA_CFG__MISSING_TX_INTR_FIX_ENABLE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00080000U) | ((u_int32_t)(1) << 19)
#define MAC_DMA_CFG__MISSING_TX_INTR_FIX_ENABLE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00080000U) | ((u_int32_t)(0) << 19)
#define MAC_DMA_CFG__TYPE                                             u_int32_t
#define MAC_DMA_CFG__READ                                           0x000e1f3fU
#define MAC_DMA_CFG__WRITE                                          0x000e1f3fU

#endif /* __MAC_DMA_CFG_MACRO__ */


/* macros for mac_dma_reg_block.MAC_DMA_CFG */
#define INST_MAC_DMA_REG_BLOCK__MAC_DMA_CFG__NUM                              1

/* macros for BlueprintGlobalNameSpace::MAC_DMA_RXBUFPTR_THRESH */
#ifndef __MAC_DMA_RXBUFPTR_THRESH_MACRO__
#define __MAC_DMA_RXBUFPTR_THRESH_MACRO__

/* macros for field HP_DATA */
#define MAC_DMA_RXBUFPTR_THRESH__HP_DATA__SHIFT                               0
#define MAC_DMA_RXBUFPTR_THRESH__HP_DATA__WIDTH                               4
#define MAC_DMA_RXBUFPTR_THRESH__HP_DATA__MASK                      0x0000000fU
#define MAC_DMA_RXBUFPTR_THRESH__HP_DATA__READ(src) \
                    (u_int32_t)(src)\
                    & 0x0000000fU
#define MAC_DMA_RXBUFPTR_THRESH__HP_DATA__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x0000000fU)
#define MAC_DMA_RXBUFPTR_THRESH__HP_DATA__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000000fU) | ((u_int32_t)(src) &\
                    0x0000000fU)
#define MAC_DMA_RXBUFPTR_THRESH__HP_DATA__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x0000000fU)))

/* macros for field LP_DATA */
#define MAC_DMA_RXBUFPTR_THRESH__LP_DATA__SHIFT                               8
#define MAC_DMA_RXBUFPTR_THRESH__LP_DATA__WIDTH                               7
#define MAC_DMA_RXBUFPTR_THRESH__LP_DATA__MASK                      0x00007f00U
#define MAC_DMA_RXBUFPTR_THRESH__LP_DATA__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00007f00U) >> 8)
#define MAC_DMA_RXBUFPTR_THRESH__LP_DATA__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 8) & 0x00007f00U)
#define MAC_DMA_RXBUFPTR_THRESH__LP_DATA__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00007f00U) | (((u_int32_t)(src) <<\
                    8) & 0x00007f00U)
#define MAC_DMA_RXBUFPTR_THRESH__LP_DATA__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 8) & ~0x00007f00U)))
#define MAC_DMA_RXBUFPTR_THRESH__TYPE                                 u_int32_t
#define MAC_DMA_RXBUFPTR_THRESH__READ                               0x00007f0fU
#define MAC_DMA_RXBUFPTR_THRESH__WRITE                              0x00007f0fU

#endif /* __MAC_DMA_RXBUFPTR_THRESH_MACRO__ */


/* macros for mac_dma_reg_block.MAC_DMA_RXBUFPTR_THRESH */
#define INST_MAC_DMA_REG_BLOCK__MAC_DMA_RXBUFPTR_THRESH__NUM                  1

/* macros for BlueprintGlobalNameSpace::MAC_DMA_TXDPPTR_THRESH */
#ifndef __MAC_DMA_TXDPPTR_THRESH_MACRO__
#define __MAC_DMA_TXDPPTR_THRESH_MACRO__

/* macros for field DATA */
#define MAC_DMA_TXDPPTR_THRESH__DATA__SHIFT                                   0
#define MAC_DMA_TXDPPTR_THRESH__DATA__WIDTH                                   4
#define MAC_DMA_TXDPPTR_THRESH__DATA__MASK                          0x0000000fU
#define MAC_DMA_TXDPPTR_THRESH__DATA__READ(src)  (u_int32_t)(src) & 0x0000000fU
#define MAC_DMA_TXDPPTR_THRESH__DATA__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x0000000fU)
#define MAC_DMA_TXDPPTR_THRESH__DATA__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000000fU) | ((u_int32_t)(src) &\
                    0x0000000fU)
#define MAC_DMA_TXDPPTR_THRESH__DATA__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x0000000fU)))
#define MAC_DMA_TXDPPTR_THRESH__TYPE                                  u_int32_t
#define MAC_DMA_TXDPPTR_THRESH__READ                                0x0000000fU
#define MAC_DMA_TXDPPTR_THRESH__WRITE                               0x0000000fU

#endif /* __MAC_DMA_TXDPPTR_THRESH_MACRO__ */


/* macros for mac_dma_reg_block.MAC_DMA_TXDPPTR_THRESH */
#define INST_MAC_DMA_REG_BLOCK__MAC_DMA_TXDPPTR_THRESH__NUM                   1

/* macros for BlueprintGlobalNameSpace::MAC_DMA_MIRT */
#ifndef __MAC_DMA_MIRT_MACRO__
#define __MAC_DMA_MIRT_MACRO__

/* macros for field RATE_THRESH */
#define MAC_DMA_MIRT__RATE_THRESH__SHIFT                                      0
#define MAC_DMA_MIRT__RATE_THRESH__WIDTH                                     16
#define MAC_DMA_MIRT__RATE_THRESH__MASK                             0x0000ffffU
#define MAC_DMA_MIRT__RATE_THRESH__READ(src)     (u_int32_t)(src) & 0x0000ffffU
#define MAC_DMA_MIRT__RATE_THRESH__WRITE(src)  ((u_int32_t)(src) & 0x0000ffffU)
#define MAC_DMA_MIRT__RATE_THRESH__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000ffffU) | ((u_int32_t)(src) &\
                    0x0000ffffU)
#define MAC_DMA_MIRT__RATE_THRESH__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x0000ffffU)))
#define MAC_DMA_MIRT__TYPE                                            u_int32_t
#define MAC_DMA_MIRT__READ                                          0x0000ffffU
#define MAC_DMA_MIRT__WRITE                                         0x0000ffffU

#endif /* __MAC_DMA_MIRT_MACRO__ */


/* macros for mac_dma_reg_block.MAC_DMA_MIRT */
#define INST_MAC_DMA_REG_BLOCK__MAC_DMA_MIRT__NUM                             1

/* macros for BlueprintGlobalNameSpace::MAC_DMA_GLOBAL_IER */
#ifndef __MAC_DMA_GLOBAL_IER_MACRO__
#define __MAC_DMA_GLOBAL_IER_MACRO__

/* macros for field ENABLE */
#define MAC_DMA_GLOBAL_IER__ENABLE__SHIFT                                     0
#define MAC_DMA_GLOBAL_IER__ENABLE__WIDTH                                     1
#define MAC_DMA_GLOBAL_IER__ENABLE__MASK                            0x00000001U
#define MAC_DMA_GLOBAL_IER__ENABLE__READ(src)    (u_int32_t)(src) & 0x00000001U
#define MAC_DMA_GLOBAL_IER__ENABLE__WRITE(src) ((u_int32_t)(src) & 0x00000001U)
#define MAC_DMA_GLOBAL_IER__ENABLE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | ((u_int32_t)(src) &\
                    0x00000001U)
#define MAC_DMA_GLOBAL_IER__ENABLE__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00000001U)))
#define MAC_DMA_GLOBAL_IER__ENABLE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(1)
#define MAC_DMA_GLOBAL_IER__ENABLE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(0)
#define MAC_DMA_GLOBAL_IER__TYPE                                      u_int32_t
#define MAC_DMA_GLOBAL_IER__READ                                    0x00000001U
#define MAC_DMA_GLOBAL_IER__WRITE                                   0x00000001U

#endif /* __MAC_DMA_GLOBAL_IER_MACRO__ */


/* macros for mac_dma_reg_block.MAC_DMA_GLOBAL_IER */
#define INST_MAC_DMA_REG_BLOCK__MAC_DMA_GLOBAL_IER__NUM                       1

/* macros for BlueprintGlobalNameSpace::MAC_DMA_TIMT */
#ifndef __MAC_DMA_TIMT_MACRO__
#define __MAC_DMA_TIMT_MACRO__

/* macros for field TX_LAST_PKT_THRESH */
#define MAC_DMA_TIMT__TX_LAST_PKT_THRESH__SHIFT                               0
#define MAC_DMA_TIMT__TX_LAST_PKT_THRESH__WIDTH                              16
#define MAC_DMA_TIMT__TX_LAST_PKT_THRESH__MASK                      0x0000ffffU
#define MAC_DMA_TIMT__TX_LAST_PKT_THRESH__READ(src) \
                    (u_int32_t)(src)\
                    & 0x0000ffffU
#define MAC_DMA_TIMT__TX_LAST_PKT_THRESH__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x0000ffffU)
#define MAC_DMA_TIMT__TX_LAST_PKT_THRESH__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000ffffU) | ((u_int32_t)(src) &\
                    0x0000ffffU)
#define MAC_DMA_TIMT__TX_LAST_PKT_THRESH__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x0000ffffU)))

/* macros for field TX_FIRST_PKT_THRESH */
#define MAC_DMA_TIMT__TX_FIRST_PKT_THRESH__SHIFT                             16
#define MAC_DMA_TIMT__TX_FIRST_PKT_THRESH__WIDTH                             16
#define MAC_DMA_TIMT__TX_FIRST_PKT_THRESH__MASK                     0xffff0000U
#define MAC_DMA_TIMT__TX_FIRST_PKT_THRESH__READ(src) \
                    (((u_int32_t)(src)\
                    & 0xffff0000U) >> 16)
#define MAC_DMA_TIMT__TX_FIRST_PKT_THRESH__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 16) & 0xffff0000U)
#define MAC_DMA_TIMT__TX_FIRST_PKT_THRESH__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xffff0000U) | (((u_int32_t)(src) <<\
                    16) & 0xffff0000U)
#define MAC_DMA_TIMT__TX_FIRST_PKT_THRESH__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 16) & ~0xffff0000U)))
#define MAC_DMA_TIMT__TYPE                                            u_int32_t
#define MAC_DMA_TIMT__READ                                          0xffffffffU
#define MAC_DMA_TIMT__WRITE                                         0xffffffffU

#endif /* __MAC_DMA_TIMT_MACRO__ */


/* macros for mac_dma_reg_block.MAC_DMA_TIMT */
#define INST_MAC_DMA_REG_BLOCK__MAC_DMA_TIMT__NUM                             1

/* macros for BlueprintGlobalNameSpace::MAC_DMA_RIMT */
#ifndef __MAC_DMA_RIMT_MACRO__
#define __MAC_DMA_RIMT_MACRO__

/* macros for field RX_LAST_PKT_THRESH */
#define MAC_DMA_RIMT__RX_LAST_PKT_THRESH__SHIFT                               0
#define MAC_DMA_RIMT__RX_LAST_PKT_THRESH__WIDTH                              16
#define MAC_DMA_RIMT__RX_LAST_PKT_THRESH__MASK                      0x0000ffffU
#define MAC_DMA_RIMT__RX_LAST_PKT_THRESH__READ(src) \
                    (u_int32_t)(src)\
                    & 0x0000ffffU
#define MAC_DMA_RIMT__RX_LAST_PKT_THRESH__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x0000ffffU)
#define MAC_DMA_RIMT__RX_LAST_PKT_THRESH__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000ffffU) | ((u_int32_t)(src) &\
                    0x0000ffffU)
#define MAC_DMA_RIMT__RX_LAST_PKT_THRESH__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x0000ffffU)))

/* macros for field RX_FIRST_PKT_THRESH */
#define MAC_DMA_RIMT__RX_FIRST_PKT_THRESH__SHIFT                             16
#define MAC_DMA_RIMT__RX_FIRST_PKT_THRESH__WIDTH                             16
#define MAC_DMA_RIMT__RX_FIRST_PKT_THRESH__MASK                     0xffff0000U
#define MAC_DMA_RIMT__RX_FIRST_PKT_THRESH__READ(src) \
                    (((u_int32_t)(src)\
                    & 0xffff0000U) >> 16)
#define MAC_DMA_RIMT__RX_FIRST_PKT_THRESH__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 16) & 0xffff0000U)
#define MAC_DMA_RIMT__RX_FIRST_PKT_THRESH__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xffff0000U) | (((u_int32_t)(src) <<\
                    16) & 0xffff0000U)
#define MAC_DMA_RIMT__RX_FIRST_PKT_THRESH__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 16) & ~0xffff0000U)))
#define MAC_DMA_RIMT__TYPE                                            u_int32_t
#define MAC_DMA_RIMT__READ                                          0xffffffffU
#define MAC_DMA_RIMT__WRITE                                         0xffffffffU

#endif /* __MAC_DMA_RIMT_MACRO__ */


/* macros for mac_dma_reg_block.MAC_DMA_RIMT */
#define INST_MAC_DMA_REG_BLOCK__MAC_DMA_RIMT__NUM                             1

/* macros for BlueprintGlobalNameSpace::MAC_DMA_TXCFG */
#ifndef __MAC_DMA_TXCFG_MACRO__
#define __MAC_DMA_TXCFG_MACRO__

/* macros for field DMA_SIZE */
#define MAC_DMA_TXCFG__DMA_SIZE__SHIFT                                        0
#define MAC_DMA_TXCFG__DMA_SIZE__WIDTH                                        3
#define MAC_DMA_TXCFG__DMA_SIZE__MASK                               0x00000007U
#define MAC_DMA_TXCFG__DMA_SIZE__READ(src)       (u_int32_t)(src) & 0x00000007U
#define MAC_DMA_TXCFG__DMA_SIZE__WRITE(src)    ((u_int32_t)(src) & 0x00000007U)
#define MAC_DMA_TXCFG__DMA_SIZE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000007U) | ((u_int32_t)(src) &\
                    0x00000007U)
#define MAC_DMA_TXCFG__DMA_SIZE__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00000007U)))

/* macros for field TRIGLVL */
#define MAC_DMA_TXCFG__TRIGLVL__SHIFT                                         4
#define MAC_DMA_TXCFG__TRIGLVL__WIDTH                                         6
#define MAC_DMA_TXCFG__TRIGLVL__MASK                                0x000003f0U
#define MAC_DMA_TXCFG__TRIGLVL__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x000003f0U) >> 4)
#define MAC_DMA_TXCFG__TRIGLVL__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 4) & 0x000003f0U)
#define MAC_DMA_TXCFG__TRIGLVL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000003f0U) | (((u_int32_t)(src) <<\
                    4) & 0x000003f0U)
#define MAC_DMA_TXCFG__TRIGLVL__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 4) & ~0x000003f0U)))

/* macros for field JUMBO_EN */
#define MAC_DMA_TXCFG__JUMBO_EN__SHIFT                                       10
#define MAC_DMA_TXCFG__JUMBO_EN__WIDTH                                        1
#define MAC_DMA_TXCFG__JUMBO_EN__MASK                               0x00000400U
#define MAC_DMA_TXCFG__JUMBO_EN__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000400U) >> 10)
#define MAC_DMA_TXCFG__JUMBO_EN__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 10) & 0x00000400U)
#define MAC_DMA_TXCFG__JUMBO_EN__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000400U) | (((u_int32_t)(src) <<\
                    10) & 0x00000400U)
#define MAC_DMA_TXCFG__JUMBO_EN__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 10) & ~0x00000400U)))
#define MAC_DMA_TXCFG__JUMBO_EN__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000400U) | ((u_int32_t)(1) << 10)
#define MAC_DMA_TXCFG__JUMBO_EN__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000400U) | ((u_int32_t)(0) << 10)

/* macros for field BCN_PAST_ATIM_DIS */
#define MAC_DMA_TXCFG__BCN_PAST_ATIM_DIS__SHIFT                              11
#define MAC_DMA_TXCFG__BCN_PAST_ATIM_DIS__WIDTH                               1
#define MAC_DMA_TXCFG__BCN_PAST_ATIM_DIS__MASK                      0x00000800U
#define MAC_DMA_TXCFG__BCN_PAST_ATIM_DIS__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000800U) >> 11)
#define MAC_DMA_TXCFG__BCN_PAST_ATIM_DIS__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 11) & 0x00000800U)
#define MAC_DMA_TXCFG__BCN_PAST_ATIM_DIS__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000800U) | (((u_int32_t)(src) <<\
                    11) & 0x00000800U)
#define MAC_DMA_TXCFG__BCN_PAST_ATIM_DIS__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 11) & ~0x00000800U)))
#define MAC_DMA_TXCFG__BCN_PAST_ATIM_DIS__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000800U) | ((u_int32_t)(1) << 11)
#define MAC_DMA_TXCFG__BCN_PAST_ATIM_DIS__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000800U) | ((u_int32_t)(0) << 11)

/* macros for field ATIM_DEFER_DIS */
#define MAC_DMA_TXCFG__ATIM_DEFER_DIS__SHIFT                                 12
#define MAC_DMA_TXCFG__ATIM_DEFER_DIS__WIDTH                                  1
#define MAC_DMA_TXCFG__ATIM_DEFER_DIS__MASK                         0x00001000U
#define MAC_DMA_TXCFG__ATIM_DEFER_DIS__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00001000U) >> 12)
#define MAC_DMA_TXCFG__ATIM_DEFER_DIS__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 12) & 0x00001000U)
#define MAC_DMA_TXCFG__ATIM_DEFER_DIS__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00001000U) | (((u_int32_t)(src) <<\
                    12) & 0x00001000U)
#define MAC_DMA_TXCFG__ATIM_DEFER_DIS__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 12) & ~0x00001000U)))
#define MAC_DMA_TXCFG__ATIM_DEFER_DIS__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00001000U) | ((u_int32_t)(1) << 12)
#define MAC_DMA_TXCFG__ATIM_DEFER_DIS__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00001000U) | ((u_int32_t)(0) << 12)

/* macros for field RTCI_DIS */
#define MAC_DMA_TXCFG__RTCI_DIS__SHIFT                                       14
#define MAC_DMA_TXCFG__RTCI_DIS__WIDTH                                        1
#define MAC_DMA_TXCFG__RTCI_DIS__MASK                               0x00004000U
#define MAC_DMA_TXCFG__RTCI_DIS__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00004000U) >> 14)
#define MAC_DMA_TXCFG__RTCI_DIS__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 14) & 0x00004000U)
#define MAC_DMA_TXCFG__RTCI_DIS__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00004000U) | (((u_int32_t)(src) <<\
                    14) & 0x00004000U)
#define MAC_DMA_TXCFG__RTCI_DIS__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 14) & ~0x00004000U)))
#define MAC_DMA_TXCFG__RTCI_DIS__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00004000U) | ((u_int32_t)(1) << 14)
#define MAC_DMA_TXCFG__RTCI_DIS__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00004000U) | ((u_int32_t)(0) << 14)

/* macros for field DIS_RETRY_UNDERRUN */
#define MAC_DMA_TXCFG__DIS_RETRY_UNDERRUN__SHIFT                             17
#define MAC_DMA_TXCFG__DIS_RETRY_UNDERRUN__WIDTH                              1
#define MAC_DMA_TXCFG__DIS_RETRY_UNDERRUN__MASK                     0x00020000U
#define MAC_DMA_TXCFG__DIS_RETRY_UNDERRUN__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00020000U) >> 17)
#define MAC_DMA_TXCFG__DIS_RETRY_UNDERRUN__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 17) & 0x00020000U)
#define MAC_DMA_TXCFG__DIS_RETRY_UNDERRUN__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00020000U) | (((u_int32_t)(src) <<\
                    17) & 0x00020000U)
#define MAC_DMA_TXCFG__DIS_RETRY_UNDERRUN__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 17) & ~0x00020000U)))
#define MAC_DMA_TXCFG__DIS_RETRY_UNDERRUN__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00020000U) | ((u_int32_t)(1) << 17)
#define MAC_DMA_TXCFG__DIS_RETRY_UNDERRUN__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00020000U) | ((u_int32_t)(0) << 17)

/* macros for field DIS_CW_INC_QUIET_COLL */
#define MAC_DMA_TXCFG__DIS_CW_INC_QUIET_COLL__SHIFT                          18
#define MAC_DMA_TXCFG__DIS_CW_INC_QUIET_COLL__WIDTH                           1
#define MAC_DMA_TXCFG__DIS_CW_INC_QUIET_COLL__MASK                  0x00040000U
#define MAC_DMA_TXCFG__DIS_CW_INC_QUIET_COLL__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00040000U) >> 18)
#define MAC_DMA_TXCFG__DIS_CW_INC_QUIET_COLL__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 18) & 0x00040000U)
#define MAC_DMA_TXCFG__DIS_CW_INC_QUIET_COLL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00040000U) | (((u_int32_t)(src) <<\
                    18) & 0x00040000U)
#define MAC_DMA_TXCFG__DIS_CW_INC_QUIET_COLL__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 18) & ~0x00040000U)))
#define MAC_DMA_TXCFG__DIS_CW_INC_QUIET_COLL__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00040000U) | ((u_int32_t)(1) << 18)
#define MAC_DMA_TXCFG__DIS_CW_INC_QUIET_COLL__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00040000U) | ((u_int32_t)(0) << 18)
#define MAC_DMA_TXCFG__TYPE                                           u_int32_t
#define MAC_DMA_TXCFG__READ                                         0x00065ff7U
#define MAC_DMA_TXCFG__WRITE                                        0x00065ff7U

#endif /* __MAC_DMA_TXCFG_MACRO__ */


/* macros for mac_dma_reg_block.MAC_DMA_TXCFG */
#define INST_MAC_DMA_REG_BLOCK__MAC_DMA_TXCFG__NUM                            1

/* macros for BlueprintGlobalNameSpace::MAC_DMA_RXCFG */
#ifndef __MAC_DMA_RXCFG_MACRO__
#define __MAC_DMA_RXCFG_MACRO__

/* macros for field DMA_SIZE */
#define MAC_DMA_RXCFG__DMA_SIZE__SHIFT                                        0
#define MAC_DMA_RXCFG__DMA_SIZE__WIDTH                                        3
#define MAC_DMA_RXCFG__DMA_SIZE__MASK                               0x00000007U
#define MAC_DMA_RXCFG__DMA_SIZE__READ(src)       (u_int32_t)(src) & 0x00000007U
#define MAC_DMA_RXCFG__DMA_SIZE__WRITE(src)    ((u_int32_t)(src) & 0x00000007U)
#define MAC_DMA_RXCFG__DMA_SIZE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000007U) | ((u_int32_t)(src) &\
                    0x00000007U)
#define MAC_DMA_RXCFG__DMA_SIZE__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00000007U)))

/* macros for field ZERO_LEN_DMA_EN */
#define MAC_DMA_RXCFG__ZERO_LEN_DMA_EN__SHIFT                                 3
#define MAC_DMA_RXCFG__ZERO_LEN_DMA_EN__WIDTH                                 2
#define MAC_DMA_RXCFG__ZERO_LEN_DMA_EN__MASK                        0x00000018U
#define MAC_DMA_RXCFG__ZERO_LEN_DMA_EN__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000018U) >> 3)
#define MAC_DMA_RXCFG__ZERO_LEN_DMA_EN__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 3) & 0x00000018U)
#define MAC_DMA_RXCFG__ZERO_LEN_DMA_EN__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000018U) | (((u_int32_t)(src) <<\
                    3) & 0x00000018U)
#define MAC_DMA_RXCFG__ZERO_LEN_DMA_EN__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 3) & ~0x00000018U)))

/* macros for field JUMBO_EN */
#define MAC_DMA_RXCFG__JUMBO_EN__SHIFT                                        5
#define MAC_DMA_RXCFG__JUMBO_EN__WIDTH                                        1
#define MAC_DMA_RXCFG__JUMBO_EN__MASK                               0x00000020U
#define MAC_DMA_RXCFG__JUMBO_EN__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000020U) >> 5)
#define MAC_DMA_RXCFG__JUMBO_EN__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 5) & 0x00000020U)
#define MAC_DMA_RXCFG__JUMBO_EN__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000020U) | (((u_int32_t)(src) <<\
                    5) & 0x00000020U)
#define MAC_DMA_RXCFG__JUMBO_EN__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 5) & ~0x00000020U)))
#define MAC_DMA_RXCFG__JUMBO_EN__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000020U) | ((u_int32_t)(1) << 5)
#define MAC_DMA_RXCFG__JUMBO_EN__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000020U) | ((u_int32_t)(0) << 5)

/* macros for field JUMBO_WRAP_EN */
#define MAC_DMA_RXCFG__JUMBO_WRAP_EN__SHIFT                                   6
#define MAC_DMA_RXCFG__JUMBO_WRAP_EN__WIDTH                                   1
#define MAC_DMA_RXCFG__JUMBO_WRAP_EN__MASK                          0x00000040U
#define MAC_DMA_RXCFG__JUMBO_WRAP_EN__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000040U) >> 6)
#define MAC_DMA_RXCFG__JUMBO_WRAP_EN__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 6) & 0x00000040U)
#define MAC_DMA_RXCFG__JUMBO_WRAP_EN__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000040U) | (((u_int32_t)(src) <<\
                    6) & 0x00000040U)
#define MAC_DMA_RXCFG__JUMBO_WRAP_EN__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 6) & ~0x00000040U)))
#define MAC_DMA_RXCFG__JUMBO_WRAP_EN__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000040U) | ((u_int32_t)(1) << 6)
#define MAC_DMA_RXCFG__JUMBO_WRAP_EN__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000040U) | ((u_int32_t)(0) << 6)

/* macros for field SLEEP_RX_PEND_EN */
#define MAC_DMA_RXCFG__SLEEP_RX_PEND_EN__SHIFT                                7
#define MAC_DMA_RXCFG__SLEEP_RX_PEND_EN__WIDTH                                1
#define MAC_DMA_RXCFG__SLEEP_RX_PEND_EN__MASK                       0x00000080U
#define MAC_DMA_RXCFG__SLEEP_RX_PEND_EN__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000080U) >> 7)
#define MAC_DMA_RXCFG__SLEEP_RX_PEND_EN__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 7) & 0x00000080U)
#define MAC_DMA_RXCFG__SLEEP_RX_PEND_EN__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000080U) | (((u_int32_t)(src) <<\
                    7) & 0x00000080U)
#define MAC_DMA_RXCFG__SLEEP_RX_PEND_EN__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 7) & ~0x00000080U)))
#define MAC_DMA_RXCFG__SLEEP_RX_PEND_EN__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000080U) | ((u_int32_t)(1) << 7)
#define MAC_DMA_RXCFG__SLEEP_RX_PEND_EN__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000080U) | ((u_int32_t)(0) << 7)
#define MAC_DMA_RXCFG__TYPE                                           u_int32_t
#define MAC_DMA_RXCFG__READ                                         0x000000ffU
#define MAC_DMA_RXCFG__WRITE                                        0x000000ffU

#endif /* __MAC_DMA_RXCFG_MACRO__ */


/* macros for mac_dma_reg_block.MAC_DMA_RXCFG */
#define INST_MAC_DMA_REG_BLOCK__MAC_DMA_RXCFG__NUM                            1

/* macros for BlueprintGlobalNameSpace::MAC_DMA_RXJLA */
#ifndef __MAC_DMA_RXJLA_MACRO__
#define __MAC_DMA_RXJLA_MACRO__

/* macros for field DATA */
#define MAC_DMA_RXJLA__DATA__SHIFT                                            2
#define MAC_DMA_RXJLA__DATA__WIDTH                                           30
#define MAC_DMA_RXJLA__DATA__MASK                                   0xfffffffcU
#define MAC_DMA_RXJLA__DATA__READ(src)  (((u_int32_t)(src) & 0xfffffffcU) >> 2)
#define MAC_DMA_RXJLA__TYPE                                           u_int32_t
#define MAC_DMA_RXJLA__READ                                         0xfffffffcU

#endif /* __MAC_DMA_RXJLA_MACRO__ */


/* macros for mac_dma_reg_block.MAC_DMA_RXJLA */
#define INST_MAC_DMA_REG_BLOCK__MAC_DMA_RXJLA__NUM                            1

/* macros for BlueprintGlobalNameSpace::MAC_DMA_MIBC */
#ifndef __MAC_DMA_MIBC_MACRO__
#define __MAC_DMA_MIBC_MACRO__

/* macros for field WARNING */
#define MAC_DMA_MIBC__WARNING__SHIFT                                          0
#define MAC_DMA_MIBC__WARNING__WIDTH                                          1
#define MAC_DMA_MIBC__WARNING__MASK                                 0x00000001U
#define MAC_DMA_MIBC__WARNING__READ(src)         (u_int32_t)(src) & 0x00000001U
#define MAC_DMA_MIBC__WARNING__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(1)
#define MAC_DMA_MIBC__WARNING__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(0)

/* macros for field FREEZE */
#define MAC_DMA_MIBC__FREEZE__SHIFT                                           1
#define MAC_DMA_MIBC__FREEZE__WIDTH                                           1
#define MAC_DMA_MIBC__FREEZE__MASK                                  0x00000002U
#define MAC_DMA_MIBC__FREEZE__READ(src) (((u_int32_t)(src) & 0x00000002U) >> 1)
#define MAC_DMA_MIBC__FREEZE__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 1) & 0x00000002U)
#define MAC_DMA_MIBC__FREEZE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | (((u_int32_t)(src) <<\
                    1) & 0x00000002U)
#define MAC_DMA_MIBC__FREEZE__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 1) & ~0x00000002U)))
#define MAC_DMA_MIBC__FREEZE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | ((u_int32_t)(1) << 1)
#define MAC_DMA_MIBC__FREEZE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | ((u_int32_t)(0) << 1)

/* macros for field CLEAR */
#define MAC_DMA_MIBC__CLEAR__SHIFT                                            2
#define MAC_DMA_MIBC__CLEAR__WIDTH                                            1
#define MAC_DMA_MIBC__CLEAR__MASK                                   0x00000004U
#define MAC_DMA_MIBC__CLEAR__READ(src)  (((u_int32_t)(src) & 0x00000004U) >> 2)
#define MAC_DMA_MIBC__CLEAR__WRITE(src) (((u_int32_t)(src) << 2) & 0x00000004U)
#define MAC_DMA_MIBC__CLEAR__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000004U) | (((u_int32_t)(src) <<\
                    2) & 0x00000004U)
#define MAC_DMA_MIBC__CLEAR__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 2) & ~0x00000004U)))
#define MAC_DMA_MIBC__CLEAR__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000004U) | ((u_int32_t)(1) << 2)
#define MAC_DMA_MIBC__CLEAR__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000004U) | ((u_int32_t)(0) << 2)

/* macros for field STROBE */
#define MAC_DMA_MIBC__STROBE__SHIFT                                           3
#define MAC_DMA_MIBC__STROBE__WIDTH                                           1
#define MAC_DMA_MIBC__STROBE__MASK                                  0x00000008U
#define MAC_DMA_MIBC__STROBE__READ(src) (((u_int32_t)(src) & 0x00000008U) >> 3)
#define MAC_DMA_MIBC__STROBE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000008U) | ((u_int32_t)(1) << 3)
#define MAC_DMA_MIBC__STROBE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000008U) | ((u_int32_t)(0) << 3)
#define MAC_DMA_MIBC__TYPE                                            u_int32_t
#define MAC_DMA_MIBC__READ                                          0x0000000fU
#define MAC_DMA_MIBC__WRITE                                         0x0000000fU

#endif /* __MAC_DMA_MIBC_MACRO__ */


/* macros for mac_dma_reg_block.MAC_DMA_MIBC */
#define INST_MAC_DMA_REG_BLOCK__MAC_DMA_MIBC__NUM                             1

/* macros for BlueprintGlobalNameSpace::MAC_DMA_TOPS */
#ifndef __MAC_DMA_TOPS_MACRO__
#define __MAC_DMA_TOPS_MACRO__

/* macros for field TIMEOUT */
#define MAC_DMA_TOPS__TIMEOUT__SHIFT                                          0
#define MAC_DMA_TOPS__TIMEOUT__WIDTH                                         16
#define MAC_DMA_TOPS__TIMEOUT__MASK                                 0x0000ffffU
#define MAC_DMA_TOPS__TIMEOUT__READ(src)         (u_int32_t)(src) & 0x0000ffffU
#define MAC_DMA_TOPS__TIMEOUT__WRITE(src)      ((u_int32_t)(src) & 0x0000ffffU)
#define MAC_DMA_TOPS__TIMEOUT__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000ffffU) | ((u_int32_t)(src) &\
                    0x0000ffffU)
#define MAC_DMA_TOPS__TIMEOUT__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x0000ffffU)))
#define MAC_DMA_TOPS__TYPE                                            u_int32_t
#define MAC_DMA_TOPS__READ                                          0x0000ffffU
#define MAC_DMA_TOPS__WRITE                                         0x0000ffffU

#endif /* __MAC_DMA_TOPS_MACRO__ */


/* macros for mac_dma_reg_block.MAC_DMA_TOPS */
#define INST_MAC_DMA_REG_BLOCK__MAC_DMA_TOPS__NUM                             1

/* macros for BlueprintGlobalNameSpace::MAC_DMA_RXNPTO */
#ifndef __MAC_DMA_RXNPTO_MACRO__
#define __MAC_DMA_RXNPTO_MACRO__

/* macros for field TIMEOUT */
#define MAC_DMA_RXNPTO__TIMEOUT__SHIFT                                        0
#define MAC_DMA_RXNPTO__TIMEOUT__WIDTH                                       10
#define MAC_DMA_RXNPTO__TIMEOUT__MASK                               0x000003ffU
#define MAC_DMA_RXNPTO__TIMEOUT__READ(src)       (u_int32_t)(src) & 0x000003ffU
#define MAC_DMA_RXNPTO__TIMEOUT__WRITE(src)    ((u_int32_t)(src) & 0x000003ffU)
#define MAC_DMA_RXNPTO__TIMEOUT__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000003ffU) | ((u_int32_t)(src) &\
                    0x000003ffU)
#define MAC_DMA_RXNPTO__TIMEOUT__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x000003ffU)))
#define MAC_DMA_RXNPTO__TYPE                                          u_int32_t
#define MAC_DMA_RXNPTO__READ                                        0x000003ffU
#define MAC_DMA_RXNPTO__WRITE                                       0x000003ffU

#endif /* __MAC_DMA_RXNPTO_MACRO__ */


/* macros for mac_dma_reg_block.MAC_DMA_RXNPTO */
#define INST_MAC_DMA_REG_BLOCK__MAC_DMA_RXNPTO__NUM                           1

/* macros for BlueprintGlobalNameSpace::MAC_DMA_TXNPTO */
#ifndef __MAC_DMA_TXNPTO_MACRO__
#define __MAC_DMA_TXNPTO_MACRO__

/* macros for field TIMEOUT */
#define MAC_DMA_TXNPTO__TIMEOUT__SHIFT                                        0
#define MAC_DMA_TXNPTO__TIMEOUT__WIDTH                                       10
#define MAC_DMA_TXNPTO__TIMEOUT__MASK                               0x000003ffU
#define MAC_DMA_TXNPTO__TIMEOUT__READ(src)       (u_int32_t)(src) & 0x000003ffU
#define MAC_DMA_TXNPTO__TIMEOUT__WRITE(src)    ((u_int32_t)(src) & 0x000003ffU)
#define MAC_DMA_TXNPTO__TIMEOUT__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000003ffU) | ((u_int32_t)(src) &\
                    0x000003ffU)
#define MAC_DMA_TXNPTO__TIMEOUT__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x000003ffU)))

/* macros for field MASK */
#define MAC_DMA_TXNPTO__MASK__SHIFT                                          10
#define MAC_DMA_TXNPTO__MASK__WIDTH                                          10
#define MAC_DMA_TXNPTO__MASK__MASK                                  0x000ffc00U
#define MAC_DMA_TXNPTO__MASK__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x000ffc00U) >> 10)
#define MAC_DMA_TXNPTO__MASK__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 10) & 0x000ffc00U)
#define MAC_DMA_TXNPTO__MASK__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000ffc00U) | (((u_int32_t)(src) <<\
                    10) & 0x000ffc00U)
#define MAC_DMA_TXNPTO__MASK__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 10) & ~0x000ffc00U)))
#define MAC_DMA_TXNPTO__TYPE                                          u_int32_t
#define MAC_DMA_TXNPTO__READ                                        0x000fffffU
#define MAC_DMA_TXNPTO__WRITE                                       0x000fffffU

#endif /* __MAC_DMA_TXNPTO_MACRO__ */


/* macros for mac_dma_reg_block.MAC_DMA_TXNPTO */
#define INST_MAC_DMA_REG_BLOCK__MAC_DMA_TXNPTO__NUM                           1

/* macros for BlueprintGlobalNameSpace::MAC_DMA_RPGTO */
#ifndef __MAC_DMA_RPGTO_MACRO__
#define __MAC_DMA_RPGTO_MACRO__

/* macros for field TIMEOUT */
#define MAC_DMA_RPGTO__TIMEOUT__SHIFT                                         0
#define MAC_DMA_RPGTO__TIMEOUT__WIDTH                                        10
#define MAC_DMA_RPGTO__TIMEOUT__MASK                                0x000003ffU
#define MAC_DMA_RPGTO__TIMEOUT__READ(src)        (u_int32_t)(src) & 0x000003ffU
#define MAC_DMA_RPGTO__TIMEOUT__WRITE(src)     ((u_int32_t)(src) & 0x000003ffU)
#define MAC_DMA_RPGTO__TIMEOUT__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000003ffU) | ((u_int32_t)(src) &\
                    0x000003ffU)
#define MAC_DMA_RPGTO__TIMEOUT__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x000003ffU)))
#define MAC_DMA_RPGTO__TYPE                                           u_int32_t
#define MAC_DMA_RPGTO__READ                                         0x000003ffU
#define MAC_DMA_RPGTO__WRITE                                        0x000003ffU

#endif /* __MAC_DMA_RPGTO_MACRO__ */


/* macros for mac_dma_reg_block.MAC_DMA_RPGTO */
#define INST_MAC_DMA_REG_BLOCK__MAC_DMA_RPGTO__NUM                            1

/* macros for BlueprintGlobalNameSpace::MAC_DMA_MACMISC */
#ifndef __MAC_DMA_MACMISC_MACRO__
#define __MAC_DMA_MACMISC_MACRO__

/* macros for field FORCE_PCI_EXT */
#define MAC_DMA_MACMISC__FORCE_PCI_EXT__SHIFT                                 4
#define MAC_DMA_MACMISC__FORCE_PCI_EXT__WIDTH                                 1
#define MAC_DMA_MACMISC__FORCE_PCI_EXT__MASK                        0x00000010U
#define MAC_DMA_MACMISC__FORCE_PCI_EXT__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000010U) >> 4)
#define MAC_DMA_MACMISC__FORCE_PCI_EXT__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 4) & 0x00000010U)
#define MAC_DMA_MACMISC__FORCE_PCI_EXT__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000010U) | (((u_int32_t)(src) <<\
                    4) & 0x00000010U)
#define MAC_DMA_MACMISC__FORCE_PCI_EXT__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 4) & ~0x00000010U)))
#define MAC_DMA_MACMISC__FORCE_PCI_EXT__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000010U) | ((u_int32_t)(1) << 4)
#define MAC_DMA_MACMISC__FORCE_PCI_EXT__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000010U) | ((u_int32_t)(0) << 4)

/* macros for field DMA_OBS_MUXSEL */
#define MAC_DMA_MACMISC__DMA_OBS_MUXSEL__SHIFT                                5
#define MAC_DMA_MACMISC__DMA_OBS_MUXSEL__WIDTH                                4
#define MAC_DMA_MACMISC__DMA_OBS_MUXSEL__MASK                       0x000001e0U
#define MAC_DMA_MACMISC__DMA_OBS_MUXSEL__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x000001e0U) >> 5)
#define MAC_DMA_MACMISC__DMA_OBS_MUXSEL__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 5) & 0x000001e0U)
#define MAC_DMA_MACMISC__DMA_OBS_MUXSEL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000001e0U) | (((u_int32_t)(src) <<\
                    5) & 0x000001e0U)
#define MAC_DMA_MACMISC__DMA_OBS_MUXSEL__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 5) & ~0x000001e0U)))

/* macros for field MISC_OBS_MUXSEL */
#define MAC_DMA_MACMISC__MISC_OBS_MUXSEL__SHIFT                               9
#define MAC_DMA_MACMISC__MISC_OBS_MUXSEL__WIDTH                               3
#define MAC_DMA_MACMISC__MISC_OBS_MUXSEL__MASK                      0x00000e00U
#define MAC_DMA_MACMISC__MISC_OBS_MUXSEL__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000e00U) >> 9)
#define MAC_DMA_MACMISC__MISC_OBS_MUXSEL__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 9) & 0x00000e00U)
#define MAC_DMA_MACMISC__MISC_OBS_MUXSEL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000e00U) | (((u_int32_t)(src) <<\
                    9) & 0x00000e00U)
#define MAC_DMA_MACMISC__MISC_OBS_MUXSEL__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 9) & ~0x00000e00U)))

/* macros for field MISC_F2_OBS_LOW_MUXSEL */
#define MAC_DMA_MACMISC__MISC_F2_OBS_LOW_MUXSEL__SHIFT                       12
#define MAC_DMA_MACMISC__MISC_F2_OBS_LOW_MUXSEL__WIDTH                        3
#define MAC_DMA_MACMISC__MISC_F2_OBS_LOW_MUXSEL__MASK               0x00007000U
#define MAC_DMA_MACMISC__MISC_F2_OBS_LOW_MUXSEL__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00007000U) >> 12)
#define MAC_DMA_MACMISC__MISC_F2_OBS_LOW_MUXSEL__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 12) & 0x00007000U)
#define MAC_DMA_MACMISC__MISC_F2_OBS_LOW_MUXSEL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00007000U) | (((u_int32_t)(src) <<\
                    12) & 0x00007000U)
#define MAC_DMA_MACMISC__MISC_F2_OBS_LOW_MUXSEL__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 12) & ~0x00007000U)))

/* macros for field MISC_F2_OBS_HIGH_MUXSEL */
#define MAC_DMA_MACMISC__MISC_F2_OBS_HIGH_MUXSEL__SHIFT                      15
#define MAC_DMA_MACMISC__MISC_F2_OBS_HIGH_MUXSEL__WIDTH                       3
#define MAC_DMA_MACMISC__MISC_F2_OBS_HIGH_MUXSEL__MASK              0x00038000U
#define MAC_DMA_MACMISC__MISC_F2_OBS_HIGH_MUXSEL__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00038000U) >> 15)
#define MAC_DMA_MACMISC__MISC_F2_OBS_HIGH_MUXSEL__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 15) & 0x00038000U)
#define MAC_DMA_MACMISC__MISC_F2_OBS_HIGH_MUXSEL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00038000U) | (((u_int32_t)(src) <<\
                    15) & 0x00038000U)
#define MAC_DMA_MACMISC__MISC_F2_OBS_HIGH_MUXSEL__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 15) & ~0x00038000U)))
#define MAC_DMA_MACMISC__TYPE                                         u_int32_t
#define MAC_DMA_MACMISC__READ                                       0x0003fff0U
#define MAC_DMA_MACMISC__WRITE                                      0x0003fff0U

#endif /* __MAC_DMA_MACMISC_MACRO__ */


/* macros for mac_dma_reg_block.MAC_DMA_MACMISC */
#define INST_MAC_DMA_REG_BLOCK__MAC_DMA_MACMISC__NUM                          1

/* macros for BlueprintGlobalNameSpace::MAC_DMA_INTER */
#ifndef __MAC_DMA_INTER_MACRO__
#define __MAC_DMA_INTER_MACRO__

/* macros for field REQ */
#define MAC_DMA_INTER__REQ__SHIFT                                             0
#define MAC_DMA_INTER__REQ__WIDTH                                             1
#define MAC_DMA_INTER__REQ__MASK                                    0x00000001U
#define MAC_DMA_INTER__REQ__READ(src)            (u_int32_t)(src) & 0x00000001U
#define MAC_DMA_INTER__REQ__WRITE(src)         ((u_int32_t)(src) & 0x00000001U)
#define MAC_DMA_INTER__REQ__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | ((u_int32_t)(src) &\
                    0x00000001U)
#define MAC_DMA_INTER__REQ__VERIFY(src)  (!(((u_int32_t)(src) & ~0x00000001U)))
#define MAC_DMA_INTER__REQ__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(1)
#define MAC_DMA_INTER__REQ__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(0)

/* macros for field MSI_RX_SRC */
#define MAC_DMA_INTER__MSI_RX_SRC__SHIFT                                      1
#define MAC_DMA_INTER__MSI_RX_SRC__WIDTH                                      2
#define MAC_DMA_INTER__MSI_RX_SRC__MASK                             0x00000006U
#define MAC_DMA_INTER__MSI_RX_SRC__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000006U) >> 1)
#define MAC_DMA_INTER__MSI_RX_SRC__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 1) & 0x00000006U)
#define MAC_DMA_INTER__MSI_RX_SRC__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000006U) | (((u_int32_t)(src) <<\
                    1) & 0x00000006U)
#define MAC_DMA_INTER__MSI_RX_SRC__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 1) & ~0x00000006U)))

/* macros for field MSI_TX_SRC */
#define MAC_DMA_INTER__MSI_TX_SRC__SHIFT                                      3
#define MAC_DMA_INTER__MSI_TX_SRC__WIDTH                                      2
#define MAC_DMA_INTER__MSI_TX_SRC__MASK                             0x00000018U
#define MAC_DMA_INTER__MSI_TX_SRC__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000018U) >> 3)
#define MAC_DMA_INTER__MSI_TX_SRC__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 3) & 0x00000018U)
#define MAC_DMA_INTER__MSI_TX_SRC__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000018U) | (((u_int32_t)(src) <<\
                    3) & 0x00000018U)
#define MAC_DMA_INTER__MSI_TX_SRC__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 3) & ~0x00000018U)))
#define MAC_DMA_INTER__TYPE                                           u_int32_t
#define MAC_DMA_INTER__READ                                         0x0000001fU
#define MAC_DMA_INTER__WRITE                                        0x0000001fU

#endif /* __MAC_DMA_INTER_MACRO__ */


/* macros for mac_dma_reg_block.MAC_DMA_INTER */
#define INST_MAC_DMA_REG_BLOCK__MAC_DMA_INTER__NUM                            1

/* macros for BlueprintGlobalNameSpace::MAC_DMA_DATABUF */
#ifndef __MAC_DMA_DATABUF_MACRO__
#define __MAC_DMA_DATABUF_MACRO__

/* macros for field LEN */
#define MAC_DMA_DATABUF__LEN__SHIFT                                           0
#define MAC_DMA_DATABUF__LEN__WIDTH                                          12
#define MAC_DMA_DATABUF__LEN__MASK                                  0x00000fffU
#define MAC_DMA_DATABUF__LEN__READ(src)          (u_int32_t)(src) & 0x00000fffU
#define MAC_DMA_DATABUF__LEN__WRITE(src)       ((u_int32_t)(src) & 0x00000fffU)
#define MAC_DMA_DATABUF__LEN__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000fffU) | ((u_int32_t)(src) &\
                    0x00000fffU)
#define MAC_DMA_DATABUF__LEN__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00000fffU)))
#define MAC_DMA_DATABUF__TYPE                                         u_int32_t
#define MAC_DMA_DATABUF__READ                                       0x00000fffU
#define MAC_DMA_DATABUF__WRITE                                      0x00000fffU

#endif /* __MAC_DMA_DATABUF_MACRO__ */


/* macros for mac_dma_reg_block.MAC_DMA_DATABUF */
#define INST_MAC_DMA_REG_BLOCK__MAC_DMA_DATABUF__NUM                          1

/* macros for BlueprintGlobalNameSpace::MAC_DMA_GTT */
#ifndef __MAC_DMA_GTT_MACRO__
#define __MAC_DMA_GTT_MACRO__

/* macros for field COUNT */
#define MAC_DMA_GTT__COUNT__SHIFT                                             0
#define MAC_DMA_GTT__COUNT__WIDTH                                            16
#define MAC_DMA_GTT__COUNT__MASK                                    0x0000ffffU
#define MAC_DMA_GTT__COUNT__READ(src)            (u_int32_t)(src) & 0x0000ffffU
#define MAC_DMA_GTT__COUNT__WRITE(src)         ((u_int32_t)(src) & 0x0000ffffU)
#define MAC_DMA_GTT__COUNT__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000ffffU) | ((u_int32_t)(src) &\
                    0x0000ffffU)
#define MAC_DMA_GTT__COUNT__VERIFY(src)  (!(((u_int32_t)(src) & ~0x0000ffffU)))

/* macros for field LIMIT */
#define MAC_DMA_GTT__LIMIT__SHIFT                                            16
#define MAC_DMA_GTT__LIMIT__WIDTH                                            16
#define MAC_DMA_GTT__LIMIT__MASK                                    0xffff0000U
#define MAC_DMA_GTT__LIMIT__READ(src)  (((u_int32_t)(src) & 0xffff0000U) >> 16)
#define MAC_DMA_GTT__LIMIT__WRITE(src) (((u_int32_t)(src) << 16) & 0xffff0000U)
#define MAC_DMA_GTT__LIMIT__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xffff0000U) | (((u_int32_t)(src) <<\
                    16) & 0xffff0000U)
#define MAC_DMA_GTT__LIMIT__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 16) & ~0xffff0000U)))
#define MAC_DMA_GTT__TYPE                                             u_int32_t
#define MAC_DMA_GTT__READ                                           0xffffffffU
#define MAC_DMA_GTT__WRITE                                          0xffffffffU

#endif /* __MAC_DMA_GTT_MACRO__ */


/* macros for mac_dma_reg_block.MAC_DMA_GTT */
#define INST_MAC_DMA_REG_BLOCK__MAC_DMA_GTT__NUM                              1

/* macros for BlueprintGlobalNameSpace::MAC_DMA_GTTM */
#ifndef __MAC_DMA_GTTM_MACRO__
#define __MAC_DMA_GTTM_MACRO__

/* macros for field USEC_STROBE */
#define MAC_DMA_GTTM__USEC_STROBE__SHIFT                                      0
#define MAC_DMA_GTTM__USEC_STROBE__WIDTH                                      1
#define MAC_DMA_GTTM__USEC_STROBE__MASK                             0x00000001U
#define MAC_DMA_GTTM__USEC_STROBE__READ(src)     (u_int32_t)(src) & 0x00000001U
#define MAC_DMA_GTTM__USEC_STROBE__WRITE(src)  ((u_int32_t)(src) & 0x00000001U)
#define MAC_DMA_GTTM__USEC_STROBE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | ((u_int32_t)(src) &\
                    0x00000001U)
#define MAC_DMA_GTTM__USEC_STROBE__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00000001U)))
#define MAC_DMA_GTTM__USEC_STROBE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(1)
#define MAC_DMA_GTTM__USEC_STROBE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(0)

/* macros for field IGNORE_CHAN_IDLE */
#define MAC_DMA_GTTM__IGNORE_CHAN_IDLE__SHIFT                                 1
#define MAC_DMA_GTTM__IGNORE_CHAN_IDLE__WIDTH                                 1
#define MAC_DMA_GTTM__IGNORE_CHAN_IDLE__MASK                        0x00000002U
#define MAC_DMA_GTTM__IGNORE_CHAN_IDLE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000002U) >> 1)
#define MAC_DMA_GTTM__IGNORE_CHAN_IDLE__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 1) & 0x00000002U)
#define MAC_DMA_GTTM__IGNORE_CHAN_IDLE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | (((u_int32_t)(src) <<\
                    1) & 0x00000002U)
#define MAC_DMA_GTTM__IGNORE_CHAN_IDLE__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 1) & ~0x00000002U)))
#define MAC_DMA_GTTM__IGNORE_CHAN_IDLE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | ((u_int32_t)(1) << 1)
#define MAC_DMA_GTTM__IGNORE_CHAN_IDLE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | ((u_int32_t)(0) << 1)

/* macros for field RESET_ON_CHAN_IDLE */
#define MAC_DMA_GTTM__RESET_ON_CHAN_IDLE__SHIFT                               2
#define MAC_DMA_GTTM__RESET_ON_CHAN_IDLE__WIDTH                               1
#define MAC_DMA_GTTM__RESET_ON_CHAN_IDLE__MASK                      0x00000004U
#define MAC_DMA_GTTM__RESET_ON_CHAN_IDLE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000004U) >> 2)
#define MAC_DMA_GTTM__RESET_ON_CHAN_IDLE__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 2) & 0x00000004U)
#define MAC_DMA_GTTM__RESET_ON_CHAN_IDLE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000004U) | (((u_int32_t)(src) <<\
                    2) & 0x00000004U)
#define MAC_DMA_GTTM__RESET_ON_CHAN_IDLE__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 2) & ~0x00000004U)))
#define MAC_DMA_GTTM__RESET_ON_CHAN_IDLE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000004U) | ((u_int32_t)(1) << 2)
#define MAC_DMA_GTTM__RESET_ON_CHAN_IDLE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000004U) | ((u_int32_t)(0) << 2)

/* macros for field CST_USEC_STROBE */
#define MAC_DMA_GTTM__CST_USEC_STROBE__SHIFT                                  3
#define MAC_DMA_GTTM__CST_USEC_STROBE__WIDTH                                  1
#define MAC_DMA_GTTM__CST_USEC_STROBE__MASK                         0x00000008U
#define MAC_DMA_GTTM__CST_USEC_STROBE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000008U) >> 3)
#define MAC_DMA_GTTM__CST_USEC_STROBE__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 3) & 0x00000008U)
#define MAC_DMA_GTTM__CST_USEC_STROBE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000008U) | (((u_int32_t)(src) <<\
                    3) & 0x00000008U)
#define MAC_DMA_GTTM__CST_USEC_STROBE__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 3) & ~0x00000008U)))
#define MAC_DMA_GTTM__CST_USEC_STROBE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000008U) | ((u_int32_t)(1) << 3)
#define MAC_DMA_GTTM__CST_USEC_STROBE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000008U) | ((u_int32_t)(0) << 3)

/* macros for field DISABLE_QCU_FR_ACTIVE_GTT */
#define MAC_DMA_GTTM__DISABLE_QCU_FR_ACTIVE_GTT__SHIFT                        4
#define MAC_DMA_GTTM__DISABLE_QCU_FR_ACTIVE_GTT__WIDTH                        1
#define MAC_DMA_GTTM__DISABLE_QCU_FR_ACTIVE_GTT__MASK               0x00000010U
#define MAC_DMA_GTTM__DISABLE_QCU_FR_ACTIVE_GTT__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000010U) >> 4)
#define MAC_DMA_GTTM__DISABLE_QCU_FR_ACTIVE_GTT__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 4) & 0x00000010U)
#define MAC_DMA_GTTM__DISABLE_QCU_FR_ACTIVE_GTT__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000010U) | (((u_int32_t)(src) <<\
                    4) & 0x00000010U)
#define MAC_DMA_GTTM__DISABLE_QCU_FR_ACTIVE_GTT__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 4) & ~0x00000010U)))
#define MAC_DMA_GTTM__DISABLE_QCU_FR_ACTIVE_GTT__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000010U) | ((u_int32_t)(1) << 4)
#define MAC_DMA_GTTM__DISABLE_QCU_FR_ACTIVE_GTT__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000010U) | ((u_int32_t)(0) << 4)

/* macros for field DISABLE_QCU_FR_ACTIVE_BT */
#define MAC_DMA_GTTM__DISABLE_QCU_FR_ACTIVE_BT__SHIFT                         5
#define MAC_DMA_GTTM__DISABLE_QCU_FR_ACTIVE_BT__WIDTH                         1
#define MAC_DMA_GTTM__DISABLE_QCU_FR_ACTIVE_BT__MASK                0x00000020U
#define MAC_DMA_GTTM__DISABLE_QCU_FR_ACTIVE_BT__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000020U) >> 5)
#define MAC_DMA_GTTM__DISABLE_QCU_FR_ACTIVE_BT__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 5) & 0x00000020U)
#define MAC_DMA_GTTM__DISABLE_QCU_FR_ACTIVE_BT__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000020U) | (((u_int32_t)(src) <<\
                    5) & 0x00000020U)
#define MAC_DMA_GTTM__DISABLE_QCU_FR_ACTIVE_BT__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 5) & ~0x00000020U)))
#define MAC_DMA_GTTM__DISABLE_QCU_FR_ACTIVE_BT__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000020U) | ((u_int32_t)(1) << 5)
#define MAC_DMA_GTTM__DISABLE_QCU_FR_ACTIVE_BT__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000020U) | ((u_int32_t)(0) << 5)
#define MAC_DMA_GTTM__TYPE                                            u_int32_t
#define MAC_DMA_GTTM__READ                                          0x0000003fU
#define MAC_DMA_GTTM__WRITE                                         0x0000003fU

#endif /* __MAC_DMA_GTTM_MACRO__ */


/* macros for mac_dma_reg_block.MAC_DMA_GTTM */
#define INST_MAC_DMA_REG_BLOCK__MAC_DMA_GTTM__NUM                             1

/* macros for BlueprintGlobalNameSpace::MAC_DMA_CST */
#ifndef __MAC_DMA_CST_MACRO__
#define __MAC_DMA_CST_MACRO__

/* macros for field COUNT */
#define MAC_DMA_CST__COUNT__SHIFT                                             0
#define MAC_DMA_CST__COUNT__WIDTH                                            16
#define MAC_DMA_CST__COUNT__MASK                                    0x0000ffffU
#define MAC_DMA_CST__COUNT__READ(src)            (u_int32_t)(src) & 0x0000ffffU
#define MAC_DMA_CST__COUNT__WRITE(src)         ((u_int32_t)(src) & 0x0000ffffU)
#define MAC_DMA_CST__COUNT__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000ffffU) | ((u_int32_t)(src) &\
                    0x0000ffffU)
#define MAC_DMA_CST__COUNT__VERIFY(src)  (!(((u_int32_t)(src) & ~0x0000ffffU)))

/* macros for field LIMIT */
#define MAC_DMA_CST__LIMIT__SHIFT                                            16
#define MAC_DMA_CST__LIMIT__WIDTH                                            16
#define MAC_DMA_CST__LIMIT__MASK                                    0xffff0000U
#define MAC_DMA_CST__LIMIT__READ(src)  (((u_int32_t)(src) & 0xffff0000U) >> 16)
#define MAC_DMA_CST__LIMIT__WRITE(src) (((u_int32_t)(src) << 16) & 0xffff0000U)
#define MAC_DMA_CST__LIMIT__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xffff0000U) | (((u_int32_t)(src) <<\
                    16) & 0xffff0000U)
#define MAC_DMA_CST__LIMIT__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 16) & ~0xffff0000U)))
#define MAC_DMA_CST__TYPE                                             u_int32_t
#define MAC_DMA_CST__READ                                           0xffffffffU
#define MAC_DMA_CST__WRITE                                          0xffffffffU

#endif /* __MAC_DMA_CST_MACRO__ */


/* macros for mac_dma_reg_block.MAC_DMA_CST */
#define INST_MAC_DMA_REG_BLOCK__MAC_DMA_CST__NUM                              1

/* macros for BlueprintGlobalNameSpace::MAC_DMA_RXDP_SIZE */
#ifndef __MAC_DMA_RXDP_SIZE_MACRO__
#define __MAC_DMA_RXDP_SIZE_MACRO__

/* macros for field LP */
#define MAC_DMA_RXDP_SIZE__LP__SHIFT                                          0
#define MAC_DMA_RXDP_SIZE__LP__WIDTH                                          8
#define MAC_DMA_RXDP_SIZE__LP__MASK                                 0x000000ffU
#define MAC_DMA_RXDP_SIZE__LP__READ(src)         (u_int32_t)(src) & 0x000000ffU

/* macros for field HP */
#define MAC_DMA_RXDP_SIZE__HP__SHIFT                                          8
#define MAC_DMA_RXDP_SIZE__HP__WIDTH                                          5
#define MAC_DMA_RXDP_SIZE__HP__MASK                                 0x00001f00U
#define MAC_DMA_RXDP_SIZE__HP__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00001f00U) >> 8)
#define MAC_DMA_RXDP_SIZE__TYPE                                       u_int32_t
#define MAC_DMA_RXDP_SIZE__READ                                     0x00001fffU

#endif /* __MAC_DMA_RXDP_SIZE_MACRO__ */


/* macros for mac_dma_reg_block.MAC_DMA_RXDP_SIZE */
#define INST_MAC_DMA_REG_BLOCK__MAC_DMA_RXDP_SIZE__NUM                        1

/* macros for BlueprintGlobalNameSpace::MAC_DMA_RX_QUEUE_HP_RXDP */
#ifndef __MAC_DMA_RX_QUEUE_HP_RXDP_MACRO__
#define __MAC_DMA_RX_QUEUE_HP_RXDP_MACRO__

/* macros for field ADDR */
#define MAC_DMA_RX_QUEUE_HP_RXDP__ADDR__SHIFT                                 0
#define MAC_DMA_RX_QUEUE_HP_RXDP__ADDR__WIDTH                                32
#define MAC_DMA_RX_QUEUE_HP_RXDP__ADDR__MASK                        0xffffffffU
#define MAC_DMA_RX_QUEUE_HP_RXDP__ADDR__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define MAC_DMA_RX_QUEUE_HP_RXDP__ADDR__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0xffffffffU)
#define MAC_DMA_RX_QUEUE_HP_RXDP__ADDR__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xffffffffU) | ((u_int32_t)(src) &\
                    0xffffffffU)
#define MAC_DMA_RX_QUEUE_HP_RXDP__ADDR__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0xffffffffU)))
#define MAC_DMA_RX_QUEUE_HP_RXDP__TYPE                                u_int32_t
#define MAC_DMA_RX_QUEUE_HP_RXDP__READ                              0xffffffffU
#define MAC_DMA_RX_QUEUE_HP_RXDP__WRITE                             0xffffffffU

#endif /* __MAC_DMA_RX_QUEUE_HP_RXDP_MACRO__ */


/* macros for mac_dma_reg_block.MAC_DMA_RX_QUEUE_HP_RXDP */
#define INST_MAC_DMA_REG_BLOCK__MAC_DMA_RX_QUEUE_HP_RXDP__NUM                 1

/* macros for BlueprintGlobalNameSpace::MAC_DMA_RX_QUEUE_LP_RXDP */
#ifndef __MAC_DMA_RX_QUEUE_LP_RXDP_MACRO__
#define __MAC_DMA_RX_QUEUE_LP_RXDP_MACRO__

/* macros for field ADDR */
#define MAC_DMA_RX_QUEUE_LP_RXDP__ADDR__SHIFT                                 0
#define MAC_DMA_RX_QUEUE_LP_RXDP__ADDR__WIDTH                                32
#define MAC_DMA_RX_QUEUE_LP_RXDP__ADDR__MASK                        0xffffffffU
#define MAC_DMA_RX_QUEUE_LP_RXDP__ADDR__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define MAC_DMA_RX_QUEUE_LP_RXDP__ADDR__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0xffffffffU)
#define MAC_DMA_RX_QUEUE_LP_RXDP__ADDR__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xffffffffU) | ((u_int32_t)(src) &\
                    0xffffffffU)
#define MAC_DMA_RX_QUEUE_LP_RXDP__ADDR__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0xffffffffU)))
#define MAC_DMA_RX_QUEUE_LP_RXDP__TYPE                                u_int32_t
#define MAC_DMA_RX_QUEUE_LP_RXDP__READ                              0xffffffffU
#define MAC_DMA_RX_QUEUE_LP_RXDP__WRITE                             0xffffffffU

#endif /* __MAC_DMA_RX_QUEUE_LP_RXDP_MACRO__ */


/* macros for mac_dma_reg_block.MAC_DMA_RX_QUEUE_LP_RXDP */
#define INST_MAC_DMA_REG_BLOCK__MAC_DMA_RX_QUEUE_LP_RXDP__NUM                 1

/* macros for BlueprintGlobalNameSpace::MAC_DMA_ISR_P */
#ifndef __MAC_DMA_ISR_P_MACRO__
#define __MAC_DMA_ISR_P_MACRO__

/* macros for field DATA */
#define MAC_DMA_ISR_P__DATA__SHIFT                                            0
#define MAC_DMA_ISR_P__DATA__WIDTH                                           32
#define MAC_DMA_ISR_P__DATA__MASK                                   0xffffffffU
#define MAC_DMA_ISR_P__DATA__READ(src)           (u_int32_t)(src) & 0xffffffffU
#define MAC_DMA_ISR_P__DATA__WRITE(src)        ((u_int32_t)(src) & 0xffffffffU)
#define MAC_DMA_ISR_P__DATA__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xffffffffU) | ((u_int32_t)(src) &\
                    0xffffffffU)
#define MAC_DMA_ISR_P__DATA__VERIFY(src) (!(((u_int32_t)(src) & ~0xffffffffU)))
#define MAC_DMA_ISR_P__TYPE                                           u_int32_t
#define MAC_DMA_ISR_P__READ                                         0xffffffffU
#define MAC_DMA_ISR_P__WRITE                                        0xffffffffU

#endif /* __MAC_DMA_ISR_P_MACRO__ */


/* macros for mac_dma_reg_block.MAC_DMA_ISR_P */
#define INST_MAC_DMA_REG_BLOCK__MAC_DMA_ISR_P__NUM                            1

/* macros for BlueprintGlobalNameSpace::MAC_DMA_ISR_S0 */
#ifndef __MAC_DMA_ISR_S0_MACRO__
#define __MAC_DMA_ISR_S0_MACRO__

/* macros for field DATA */
#define MAC_DMA_ISR_S0__DATA__SHIFT                                           0
#define MAC_DMA_ISR_S0__DATA__WIDTH                                          32
#define MAC_DMA_ISR_S0__DATA__MASK                                  0xffffffffU
#define MAC_DMA_ISR_S0__DATA__READ(src)          (u_int32_t)(src) & 0xffffffffU
#define MAC_DMA_ISR_S0__DATA__WRITE(src)       ((u_int32_t)(src) & 0xffffffffU)
#define MAC_DMA_ISR_S0__DATA__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xffffffffU) | ((u_int32_t)(src) &\
                    0xffffffffU)
#define MAC_DMA_ISR_S0__DATA__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0xffffffffU)))
#define MAC_DMA_ISR_S0__TYPE                                          u_int32_t
#define MAC_DMA_ISR_S0__READ                                        0xffffffffU
#define MAC_DMA_ISR_S0__WRITE                                       0xffffffffU

#endif /* __MAC_DMA_ISR_S0_MACRO__ */


/* macros for mac_dma_reg_block.MAC_DMA_ISR_S0 */
#define INST_MAC_DMA_REG_BLOCK__MAC_DMA_ISR_S0__NUM                           1

/* macros for BlueprintGlobalNameSpace::MAC_DMA_ISR_S1 */
#ifndef __MAC_DMA_ISR_S1_MACRO__
#define __MAC_DMA_ISR_S1_MACRO__

/* macros for field DATA */
#define MAC_DMA_ISR_S1__DATA__SHIFT                                           0
#define MAC_DMA_ISR_S1__DATA__WIDTH                                          32
#define MAC_DMA_ISR_S1__DATA__MASK                                  0xffffffffU
#define MAC_DMA_ISR_S1__DATA__READ(src)          (u_int32_t)(src) & 0xffffffffU
#define MAC_DMA_ISR_S1__DATA__WRITE(src)       ((u_int32_t)(src) & 0xffffffffU)
#define MAC_DMA_ISR_S1__DATA__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xffffffffU) | ((u_int32_t)(src) &\
                    0xffffffffU)
#define MAC_DMA_ISR_S1__DATA__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0xffffffffU)))
#define MAC_DMA_ISR_S1__TYPE                                          u_int32_t
#define MAC_DMA_ISR_S1__READ                                        0xffffffffU
#define MAC_DMA_ISR_S1__WRITE                                       0xffffffffU

#endif /* __MAC_DMA_ISR_S1_MACRO__ */


/* macros for mac_dma_reg_block.MAC_DMA_ISR_S1 */
#define INST_MAC_DMA_REG_BLOCK__MAC_DMA_ISR_S1__NUM                           1

/* macros for BlueprintGlobalNameSpace::MAC_DMA_ISR_S2 */
#ifndef __MAC_DMA_ISR_S2_MACRO__
#define __MAC_DMA_ISR_S2_MACRO__

/* macros for field DATA */
#define MAC_DMA_ISR_S2__DATA__SHIFT                                           0
#define MAC_DMA_ISR_S2__DATA__WIDTH                                          32
#define MAC_DMA_ISR_S2__DATA__MASK                                  0xffffffffU
#define MAC_DMA_ISR_S2__DATA__READ(src)          (u_int32_t)(src) & 0xffffffffU
#define MAC_DMA_ISR_S2__DATA__WRITE(src)       ((u_int32_t)(src) & 0xffffffffU)
#define MAC_DMA_ISR_S2__DATA__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xffffffffU) | ((u_int32_t)(src) &\
                    0xffffffffU)
#define MAC_DMA_ISR_S2__DATA__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0xffffffffU)))
#define MAC_DMA_ISR_S2__TYPE                                          u_int32_t
#define MAC_DMA_ISR_S2__READ                                        0xffffffffU
#define MAC_DMA_ISR_S2__WRITE                                       0xffffffffU

#endif /* __MAC_DMA_ISR_S2_MACRO__ */


/* macros for mac_dma_reg_block.MAC_DMA_ISR_S2 */
#define INST_MAC_DMA_REG_BLOCK__MAC_DMA_ISR_S2__NUM                           1

/* macros for BlueprintGlobalNameSpace::MAC_DMA_ISR_S3 */
#ifndef __MAC_DMA_ISR_S3_MACRO__
#define __MAC_DMA_ISR_S3_MACRO__

/* macros for field DATA */
#define MAC_DMA_ISR_S3__DATA__SHIFT                                           0
#define MAC_DMA_ISR_S3__DATA__WIDTH                                          32
#define MAC_DMA_ISR_S3__DATA__MASK                                  0xffffffffU
#define MAC_DMA_ISR_S3__DATA__READ(src)          (u_int32_t)(src) & 0xffffffffU
#define MAC_DMA_ISR_S3__DATA__WRITE(src)       ((u_int32_t)(src) & 0xffffffffU)
#define MAC_DMA_ISR_S3__DATA__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xffffffffU) | ((u_int32_t)(src) &\
                    0xffffffffU)
#define MAC_DMA_ISR_S3__DATA__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0xffffffffU)))
#define MAC_DMA_ISR_S3__TYPE                                          u_int32_t
#define MAC_DMA_ISR_S3__READ                                        0xffffffffU
#define MAC_DMA_ISR_S3__WRITE                                       0xffffffffU

#endif /* __MAC_DMA_ISR_S3_MACRO__ */


/* macros for mac_dma_reg_block.MAC_DMA_ISR_S3 */
#define INST_MAC_DMA_REG_BLOCK__MAC_DMA_ISR_S3__NUM                           1

/* macros for BlueprintGlobalNameSpace::MAC_DMA_ISR_S4 */
#ifndef __MAC_DMA_ISR_S4_MACRO__
#define __MAC_DMA_ISR_S4_MACRO__

/* macros for field DATA */
#define MAC_DMA_ISR_S4__DATA__SHIFT                                           0
#define MAC_DMA_ISR_S4__DATA__WIDTH                                          32
#define MAC_DMA_ISR_S4__DATA__MASK                                  0xffffffffU
#define MAC_DMA_ISR_S4__DATA__READ(src)          (u_int32_t)(src) & 0xffffffffU
#define MAC_DMA_ISR_S4__DATA__WRITE(src)       ((u_int32_t)(src) & 0xffffffffU)
#define MAC_DMA_ISR_S4__DATA__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xffffffffU) | ((u_int32_t)(src) &\
                    0xffffffffU)
#define MAC_DMA_ISR_S4__DATA__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0xffffffffU)))
#define MAC_DMA_ISR_S4__TYPE                                          u_int32_t
#define MAC_DMA_ISR_S4__READ                                        0xffffffffU
#define MAC_DMA_ISR_S4__WRITE                                       0xffffffffU

#endif /* __MAC_DMA_ISR_S4_MACRO__ */


/* macros for mac_dma_reg_block.MAC_DMA_ISR_S4 */
#define INST_MAC_DMA_REG_BLOCK__MAC_DMA_ISR_S4__NUM                           1

/* macros for BlueprintGlobalNameSpace::MAC_DMA_ISR_S5 */
#ifndef __MAC_DMA_ISR_S5_MACRO__
#define __MAC_DMA_ISR_S5_MACRO__

/* macros for field DATA */
#define MAC_DMA_ISR_S5__DATA__SHIFT                                           0
#define MAC_DMA_ISR_S5__DATA__WIDTH                                          32
#define MAC_DMA_ISR_S5__DATA__MASK                                  0xffffffffU
#define MAC_DMA_ISR_S5__DATA__READ(src)          (u_int32_t)(src) & 0xffffffffU
#define MAC_DMA_ISR_S5__DATA__WRITE(src)       ((u_int32_t)(src) & 0xffffffffU)
#define MAC_DMA_ISR_S5__DATA__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xffffffffU) | ((u_int32_t)(src) &\
                    0xffffffffU)
#define MAC_DMA_ISR_S5__DATA__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0xffffffffU)))
#define MAC_DMA_ISR_S5__TYPE                                          u_int32_t
#define MAC_DMA_ISR_S5__READ                                        0xffffffffU
#define MAC_DMA_ISR_S5__WRITE                                       0xffffffffU

#endif /* __MAC_DMA_ISR_S5_MACRO__ */


/* macros for mac_dma_reg_block.MAC_DMA_ISR_S5 */
#define INST_MAC_DMA_REG_BLOCK__MAC_DMA_ISR_S5__NUM                           1

/* macros for BlueprintGlobalNameSpace::MAC_DMA_IMR_P */
#ifndef __MAC_DMA_IMR_P_MACRO__
#define __MAC_DMA_IMR_P_MACRO__

/* macros for field MASK */
#define MAC_DMA_IMR_P__MASK__SHIFT                                            0
#define MAC_DMA_IMR_P__MASK__WIDTH                                           32
#define MAC_DMA_IMR_P__MASK__MASK                                   0xffffffffU
#define MAC_DMA_IMR_P__MASK__READ(src)           (u_int32_t)(src) & 0xffffffffU
#define MAC_DMA_IMR_P__MASK__WRITE(src)        ((u_int32_t)(src) & 0xffffffffU)
#define MAC_DMA_IMR_P__MASK__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xffffffffU) | ((u_int32_t)(src) &\
                    0xffffffffU)
#define MAC_DMA_IMR_P__MASK__VERIFY(src) (!(((u_int32_t)(src) & ~0xffffffffU)))
#define MAC_DMA_IMR_P__TYPE                                           u_int32_t
#define MAC_DMA_IMR_P__READ                                         0xffffffffU
#define MAC_DMA_IMR_P__WRITE                                        0xffffffffU

#endif /* __MAC_DMA_IMR_P_MACRO__ */


/* macros for mac_dma_reg_block.MAC_DMA_IMR_P */
#define INST_MAC_DMA_REG_BLOCK__MAC_DMA_IMR_P__NUM                            1

/* macros for BlueprintGlobalNameSpace::MAC_DMA_IMR_S0 */
#ifndef __MAC_DMA_IMR_S0_MACRO__
#define __MAC_DMA_IMR_S0_MACRO__

/* macros for field MASK */
#define MAC_DMA_IMR_S0__MASK__SHIFT                                           0
#define MAC_DMA_IMR_S0__MASK__WIDTH                                          32
#define MAC_DMA_IMR_S0__MASK__MASK                                  0xffffffffU
#define MAC_DMA_IMR_S0__MASK__READ(src)          (u_int32_t)(src) & 0xffffffffU
#define MAC_DMA_IMR_S0__MASK__WRITE(src)       ((u_int32_t)(src) & 0xffffffffU)
#define MAC_DMA_IMR_S0__MASK__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xffffffffU) | ((u_int32_t)(src) &\
                    0xffffffffU)
#define MAC_DMA_IMR_S0__MASK__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0xffffffffU)))
#define MAC_DMA_IMR_S0__TYPE                                          u_int32_t
#define MAC_DMA_IMR_S0__READ                                        0xffffffffU
#define MAC_DMA_IMR_S0__WRITE                                       0xffffffffU

#endif /* __MAC_DMA_IMR_S0_MACRO__ */


/* macros for mac_dma_reg_block.MAC_DMA_IMR_S0 */
#define INST_MAC_DMA_REG_BLOCK__MAC_DMA_IMR_S0__NUM                           1

/* macros for BlueprintGlobalNameSpace::MAC_DMA_IMR_S1 */
#ifndef __MAC_DMA_IMR_S1_MACRO__
#define __MAC_DMA_IMR_S1_MACRO__

/* macros for field DATA */
#define MAC_DMA_IMR_S1__DATA__SHIFT                                           0
#define MAC_DMA_IMR_S1__DATA__WIDTH                                          32
#define MAC_DMA_IMR_S1__DATA__MASK                                  0xffffffffU
#define MAC_DMA_IMR_S1__DATA__READ(src)          (u_int32_t)(src) & 0xffffffffU
#define MAC_DMA_IMR_S1__DATA__WRITE(src)       ((u_int32_t)(src) & 0xffffffffU)
#define MAC_DMA_IMR_S1__DATA__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xffffffffU) | ((u_int32_t)(src) &\
                    0xffffffffU)
#define MAC_DMA_IMR_S1__DATA__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0xffffffffU)))
#define MAC_DMA_IMR_S1__TYPE                                          u_int32_t
#define MAC_DMA_IMR_S1__READ                                        0xffffffffU
#define MAC_DMA_IMR_S1__WRITE                                       0xffffffffU

#endif /* __MAC_DMA_IMR_S1_MACRO__ */


/* macros for mac_dma_reg_block.MAC_DMA_IMR_S1 */
#define INST_MAC_DMA_REG_BLOCK__MAC_DMA_IMR_S1__NUM                           1

/* macros for BlueprintGlobalNameSpace::MAC_DMA_IMR_S2 */
#ifndef __MAC_DMA_IMR_S2_MACRO__
#define __MAC_DMA_IMR_S2_MACRO__

/* macros for field MASK */
#define MAC_DMA_IMR_S2__MASK__SHIFT                                           0
#define MAC_DMA_IMR_S2__MASK__WIDTH                                          32
#define MAC_DMA_IMR_S2__MASK__MASK                                  0xffffffffU
#define MAC_DMA_IMR_S2__MASK__READ(src)          (u_int32_t)(src) & 0xffffffffU
#define MAC_DMA_IMR_S2__MASK__WRITE(src)       ((u_int32_t)(src) & 0xffffffffU)
#define MAC_DMA_IMR_S2__MASK__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xffffffffU) | ((u_int32_t)(src) &\
                    0xffffffffU)
#define MAC_DMA_IMR_S2__MASK__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0xffffffffU)))
#define MAC_DMA_IMR_S2__TYPE                                          u_int32_t
#define MAC_DMA_IMR_S2__READ                                        0xffffffffU
#define MAC_DMA_IMR_S2__WRITE                                       0xffffffffU

#endif /* __MAC_DMA_IMR_S2_MACRO__ */


/* macros for mac_dma_reg_block.MAC_DMA_IMR_S2 */
#define INST_MAC_DMA_REG_BLOCK__MAC_DMA_IMR_S2__NUM                           1

/* macros for BlueprintGlobalNameSpace::MAC_DMA_IMR_S3 */
#ifndef __MAC_DMA_IMR_S3_MACRO__
#define __MAC_DMA_IMR_S3_MACRO__

/* macros for field MASK */
#define MAC_DMA_IMR_S3__MASK__SHIFT                                           0
#define MAC_DMA_IMR_S3__MASK__WIDTH                                          32
#define MAC_DMA_IMR_S3__MASK__MASK                                  0xffffffffU
#define MAC_DMA_IMR_S3__MASK__READ(src)          (u_int32_t)(src) & 0xffffffffU
#define MAC_DMA_IMR_S3__MASK__WRITE(src)       ((u_int32_t)(src) & 0xffffffffU)
#define MAC_DMA_IMR_S3__MASK__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xffffffffU) | ((u_int32_t)(src) &\
                    0xffffffffU)
#define MAC_DMA_IMR_S3__MASK__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0xffffffffU)))
#define MAC_DMA_IMR_S3__TYPE                                          u_int32_t
#define MAC_DMA_IMR_S3__READ                                        0xffffffffU
#define MAC_DMA_IMR_S3__WRITE                                       0xffffffffU

#endif /* __MAC_DMA_IMR_S3_MACRO__ */


/* macros for mac_dma_reg_block.MAC_DMA_IMR_S3 */
#define INST_MAC_DMA_REG_BLOCK__MAC_DMA_IMR_S3__NUM                           1

/* macros for BlueprintGlobalNameSpace::MAC_DMA_IMR_S4 */
#ifndef __MAC_DMA_IMR_S4_MACRO__
#define __MAC_DMA_IMR_S4_MACRO__

/* macros for field MASK */
#define MAC_DMA_IMR_S4__MASK__SHIFT                                           0
#define MAC_DMA_IMR_S4__MASK__WIDTH                                          32
#define MAC_DMA_IMR_S4__MASK__MASK                                  0xffffffffU
#define MAC_DMA_IMR_S4__MASK__READ(src)          (u_int32_t)(src) & 0xffffffffU
#define MAC_DMA_IMR_S4__MASK__WRITE(src)       ((u_int32_t)(src) & 0xffffffffU)
#define MAC_DMA_IMR_S4__MASK__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xffffffffU) | ((u_int32_t)(src) &\
                    0xffffffffU)
#define MAC_DMA_IMR_S4__MASK__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0xffffffffU)))
#define MAC_DMA_IMR_S4__TYPE                                          u_int32_t
#define MAC_DMA_IMR_S4__READ                                        0xffffffffU
#define MAC_DMA_IMR_S4__WRITE                                       0xffffffffU

#endif /* __MAC_DMA_IMR_S4_MACRO__ */


/* macros for mac_dma_reg_block.MAC_DMA_IMR_S4 */
#define INST_MAC_DMA_REG_BLOCK__MAC_DMA_IMR_S4__NUM                           1

/* macros for BlueprintGlobalNameSpace::MAC_DMA_IMR_S5 */
#ifndef __MAC_DMA_IMR_S5_MACRO__
#define __MAC_DMA_IMR_S5_MACRO__

/* macros for field MASK */
#define MAC_DMA_IMR_S5__MASK__SHIFT                                           0
#define MAC_DMA_IMR_S5__MASK__WIDTH                                          32
#define MAC_DMA_IMR_S5__MASK__MASK                                  0xffffffffU
#define MAC_DMA_IMR_S5__MASK__READ(src)          (u_int32_t)(src) & 0xffffffffU
#define MAC_DMA_IMR_S5__MASK__WRITE(src)       ((u_int32_t)(src) & 0xffffffffU)
#define MAC_DMA_IMR_S5__MASK__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xffffffffU) | ((u_int32_t)(src) &\
                    0xffffffffU)
#define MAC_DMA_IMR_S5__MASK__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0xffffffffU)))
#define MAC_DMA_IMR_S5__TYPE                                          u_int32_t
#define MAC_DMA_IMR_S5__READ                                        0xffffffffU
#define MAC_DMA_IMR_S5__WRITE                                       0xffffffffU

#endif /* __MAC_DMA_IMR_S5_MACRO__ */


/* macros for mac_dma_reg_block.MAC_DMA_IMR_S5 */
#define INST_MAC_DMA_REG_BLOCK__MAC_DMA_IMR_S5__NUM                           1

/* macros for BlueprintGlobalNameSpace::MAC_DMA_ISR_P_RAC */
#ifndef __MAC_DMA_ISR_P_RAC_MACRO__
#define __MAC_DMA_ISR_P_RAC_MACRO__

/* macros for field DATA */
#define MAC_DMA_ISR_P_RAC__DATA__SHIFT                                        0
#define MAC_DMA_ISR_P_RAC__DATA__WIDTH                                       32
#define MAC_DMA_ISR_P_RAC__DATA__MASK                               0xffffffffU
#define MAC_DMA_ISR_P_RAC__DATA__READ(src)       (u_int32_t)(src) & 0xffffffffU
#define MAC_DMA_ISR_P_RAC__TYPE                                       u_int32_t
#define MAC_DMA_ISR_P_RAC__READ                                     0xffffffffU

#endif /* __MAC_DMA_ISR_P_RAC_MACRO__ */


/* macros for mac_dma_reg_block.MAC_DMA_ISR_P_RAC */
#define INST_MAC_DMA_REG_BLOCK__MAC_DMA_ISR_P_RAC__NUM                        1

/* macros for BlueprintGlobalNameSpace::MAC_DMA_ISR_S0_S */
#ifndef __MAC_DMA_ISR_S0_S_MACRO__
#define __MAC_DMA_ISR_S0_S_MACRO__

/* macros for field SHADOW */
#define MAC_DMA_ISR_S0_S__SHADOW__SHIFT                                       0
#define MAC_DMA_ISR_S0_S__SHADOW__WIDTH                                      32
#define MAC_DMA_ISR_S0_S__SHADOW__MASK                              0xffffffffU
#define MAC_DMA_ISR_S0_S__SHADOW__READ(src)      (u_int32_t)(src) & 0xffffffffU
#define MAC_DMA_ISR_S0_S__TYPE                                        u_int32_t
#define MAC_DMA_ISR_S0_S__READ                                      0xffffffffU

#endif /* __MAC_DMA_ISR_S0_S_MACRO__ */


/* macros for mac_dma_reg_block.MAC_DMA_ISR_S0_S */
#define INST_MAC_DMA_REG_BLOCK__MAC_DMA_ISR_S0_S__NUM                         1

/* macros for BlueprintGlobalNameSpace::MAC_DMA_ISR_S1_S */
#ifndef __MAC_DMA_ISR_S1_S_MACRO__
#define __MAC_DMA_ISR_S1_S_MACRO__

/* macros for field SHADOW */
#define MAC_DMA_ISR_S1_S__SHADOW__SHIFT                                       0
#define MAC_DMA_ISR_S1_S__SHADOW__WIDTH                                      32
#define MAC_DMA_ISR_S1_S__SHADOW__MASK                              0xffffffffU
#define MAC_DMA_ISR_S1_S__SHADOW__READ(src)      (u_int32_t)(src) & 0xffffffffU
#define MAC_DMA_ISR_S1_S__TYPE                                        u_int32_t
#define MAC_DMA_ISR_S1_S__READ                                      0xffffffffU

#endif /* __MAC_DMA_ISR_S1_S_MACRO__ */


/* macros for mac_dma_reg_block.MAC_DMA_ISR_S1_S */
#define INST_MAC_DMA_REG_BLOCK__MAC_DMA_ISR_S1_S__NUM                         1

/* macros for BlueprintGlobalNameSpace::MAC_DMA_ISR_S2_S */
#ifndef __MAC_DMA_ISR_S2_S_MACRO__
#define __MAC_DMA_ISR_S2_S_MACRO__

/* macros for field SHADOW */
#define MAC_DMA_ISR_S2_S__SHADOW__SHIFT                                       0
#define MAC_DMA_ISR_S2_S__SHADOW__WIDTH                                      32
#define MAC_DMA_ISR_S2_S__SHADOW__MASK                              0xffffffffU
#define MAC_DMA_ISR_S2_S__SHADOW__READ(src)      (u_int32_t)(src) & 0xffffffffU
#define MAC_DMA_ISR_S2_S__TYPE                                        u_int32_t
#define MAC_DMA_ISR_S2_S__READ                                      0xffffffffU

#endif /* __MAC_DMA_ISR_S2_S_MACRO__ */


/* macros for mac_dma_reg_block.MAC_DMA_ISR_S2_S */
#define INST_MAC_DMA_REG_BLOCK__MAC_DMA_ISR_S2_S__NUM                         1

/* macros for BlueprintGlobalNameSpace::MAC_DMA_ISR_S3_S */
#ifndef __MAC_DMA_ISR_S3_S_MACRO__
#define __MAC_DMA_ISR_S3_S_MACRO__

/* macros for field SHADOW */
#define MAC_DMA_ISR_S3_S__SHADOW__SHIFT                                       0
#define MAC_DMA_ISR_S3_S__SHADOW__WIDTH                                      32
#define MAC_DMA_ISR_S3_S__SHADOW__MASK                              0xffffffffU
#define MAC_DMA_ISR_S3_S__SHADOW__READ(src)      (u_int32_t)(src) & 0xffffffffU
#define MAC_DMA_ISR_S3_S__TYPE                                        u_int32_t
#define MAC_DMA_ISR_S3_S__READ                                      0xffffffffU

#endif /* __MAC_DMA_ISR_S3_S_MACRO__ */


/* macros for mac_dma_reg_block.MAC_DMA_ISR_S3_S */
#define INST_MAC_DMA_REG_BLOCK__MAC_DMA_ISR_S3_S__NUM                         1

/* macros for BlueprintGlobalNameSpace::MAC_DMA_ISR_S4_S */
#ifndef __MAC_DMA_ISR_S4_S_MACRO__
#define __MAC_DMA_ISR_S4_S_MACRO__

/* macros for field SHADOW */
#define MAC_DMA_ISR_S4_S__SHADOW__SHIFT                                       0
#define MAC_DMA_ISR_S4_S__SHADOW__WIDTH                                      32
#define MAC_DMA_ISR_S4_S__SHADOW__MASK                              0xffffffffU
#define MAC_DMA_ISR_S4_S__SHADOW__READ(src)      (u_int32_t)(src) & 0xffffffffU
#define MAC_DMA_ISR_S4_S__TYPE                                        u_int32_t
#define MAC_DMA_ISR_S4_S__READ                                      0xffffffffU

#endif /* __MAC_DMA_ISR_S4_S_MACRO__ */


/* macros for mac_dma_reg_block.MAC_DMA_ISR_S4_S */
#define INST_MAC_DMA_REG_BLOCK__MAC_DMA_ISR_S4_S__NUM                         1

/* macros for BlueprintGlobalNameSpace::MAC_DMA_ISR_S5_S */
#ifndef __MAC_DMA_ISR_S5_S_MACRO__
#define __MAC_DMA_ISR_S5_S_MACRO__

/* macros for field SHADOW */
#define MAC_DMA_ISR_S5_S__SHADOW__SHIFT                                       0
#define MAC_DMA_ISR_S5_S__SHADOW__WIDTH                                      32
#define MAC_DMA_ISR_S5_S__SHADOW__MASK                              0xffffffffU
#define MAC_DMA_ISR_S5_S__SHADOW__READ(src)      (u_int32_t)(src) & 0xffffffffU
#define MAC_DMA_ISR_S5_S__TYPE                                        u_int32_t
#define MAC_DMA_ISR_S5_S__READ                                      0xffffffffU

#endif /* __MAC_DMA_ISR_S5_S_MACRO__ */


/* macros for mac_dma_reg_block.MAC_DMA_ISR_S5_S */
#define INST_MAC_DMA_REG_BLOCK__MAC_DMA_ISR_S5_S__NUM                         1

/* macros for BlueprintGlobalNameSpace::MAC_DMA_DMADBG_0 */
#ifndef __MAC_DMA_DMADBG_0_MACRO__
#define __MAC_DMA_DMADBG_0_MACRO__

/* macros for field DATA */
#define MAC_DMA_DMADBG_0__DATA__SHIFT                                         0
#define MAC_DMA_DMADBG_0__DATA__WIDTH                                        32
#define MAC_DMA_DMADBG_0__DATA__MASK                                0xffffffffU
#define MAC_DMA_DMADBG_0__DATA__READ(src)        (u_int32_t)(src) & 0xffffffffU
#define MAC_DMA_DMADBG_0__TYPE                                        u_int32_t
#define MAC_DMA_DMADBG_0__READ                                      0xffffffffU

#endif /* __MAC_DMA_DMADBG_0_MACRO__ */


/* macros for mac_dma_reg_block.MAC_DMA_DMADBG_0 */
#define INST_MAC_DMA_REG_BLOCK__MAC_DMA_DMADBG_0__NUM                         1

/* macros for BlueprintGlobalNameSpace::MAC_DMA_DMADBG_1 */
#ifndef __MAC_DMA_DMADBG_1_MACRO__
#define __MAC_DMA_DMADBG_1_MACRO__

/* macros for field DATA */
#define MAC_DMA_DMADBG_1__DATA__SHIFT                                         0
#define MAC_DMA_DMADBG_1__DATA__WIDTH                                        32
#define MAC_DMA_DMADBG_1__DATA__MASK                                0xffffffffU
#define MAC_DMA_DMADBG_1__DATA__READ(src)        (u_int32_t)(src) & 0xffffffffU
#define MAC_DMA_DMADBG_1__TYPE                                        u_int32_t
#define MAC_DMA_DMADBG_1__READ                                      0xffffffffU

#endif /* __MAC_DMA_DMADBG_1_MACRO__ */


/* macros for mac_dma_reg_block.MAC_DMA_DMADBG_1 */
#define INST_MAC_DMA_REG_BLOCK__MAC_DMA_DMADBG_1__NUM                         1

/* macros for BlueprintGlobalNameSpace::MAC_DMA_DMADBG_2 */
#ifndef __MAC_DMA_DMADBG_2_MACRO__
#define __MAC_DMA_DMADBG_2_MACRO__

/* macros for field DATA */
#define MAC_DMA_DMADBG_2__DATA__SHIFT                                         0
#define MAC_DMA_DMADBG_2__DATA__WIDTH                                        32
#define MAC_DMA_DMADBG_2__DATA__MASK                                0xffffffffU
#define MAC_DMA_DMADBG_2__DATA__READ(src)        (u_int32_t)(src) & 0xffffffffU
#define MAC_DMA_DMADBG_2__TYPE                                        u_int32_t
#define MAC_DMA_DMADBG_2__READ                                      0xffffffffU

#endif /* __MAC_DMA_DMADBG_2_MACRO__ */


/* macros for mac_dma_reg_block.MAC_DMA_DMADBG_2 */
#define INST_MAC_DMA_REG_BLOCK__MAC_DMA_DMADBG_2__NUM                         1

/* macros for BlueprintGlobalNameSpace::MAC_DMA_DMADBG_3 */
#ifndef __MAC_DMA_DMADBG_3_MACRO__
#define __MAC_DMA_DMADBG_3_MACRO__

/* macros for field DATA */
#define MAC_DMA_DMADBG_3__DATA__SHIFT                                         0
#define MAC_DMA_DMADBG_3__DATA__WIDTH                                        32
#define MAC_DMA_DMADBG_3__DATA__MASK                                0xffffffffU
#define MAC_DMA_DMADBG_3__DATA__READ(src)        (u_int32_t)(src) & 0xffffffffU
#define MAC_DMA_DMADBG_3__TYPE                                        u_int32_t
#define MAC_DMA_DMADBG_3__READ                                      0xffffffffU

#endif /* __MAC_DMA_DMADBG_3_MACRO__ */


/* macros for mac_dma_reg_block.MAC_DMA_DMADBG_3 */
#define INST_MAC_DMA_REG_BLOCK__MAC_DMA_DMADBG_3__NUM                         1

/* macros for BlueprintGlobalNameSpace::MAC_DMA_DMADBG_4 */
#ifndef __MAC_DMA_DMADBG_4_MACRO__
#define __MAC_DMA_DMADBG_4_MACRO__

/* macros for field DATA */
#define MAC_DMA_DMADBG_4__DATA__SHIFT                                         0
#define MAC_DMA_DMADBG_4__DATA__WIDTH                                        32
#define MAC_DMA_DMADBG_4__DATA__MASK                                0xffffffffU
#define MAC_DMA_DMADBG_4__DATA__READ(src)        (u_int32_t)(src) & 0xffffffffU
#define MAC_DMA_DMADBG_4__TYPE                                        u_int32_t
#define MAC_DMA_DMADBG_4__READ                                      0xffffffffU

#endif /* __MAC_DMA_DMADBG_4_MACRO__ */


/* macros for mac_dma_reg_block.MAC_DMA_DMADBG_4 */
#define INST_MAC_DMA_REG_BLOCK__MAC_DMA_DMADBG_4__NUM                         1

/* macros for BlueprintGlobalNameSpace::MAC_DMA_DMADBG_5 */
#ifndef __MAC_DMA_DMADBG_5_MACRO__
#define __MAC_DMA_DMADBG_5_MACRO__

/* macros for field DATA */
#define MAC_DMA_DMADBG_5__DATA__SHIFT                                         0
#define MAC_DMA_DMADBG_5__DATA__WIDTH                                        32
#define MAC_DMA_DMADBG_5__DATA__MASK                                0xffffffffU
#define MAC_DMA_DMADBG_5__DATA__READ(src)        (u_int32_t)(src) & 0xffffffffU
#define MAC_DMA_DMADBG_5__TYPE                                        u_int32_t
#define MAC_DMA_DMADBG_5__READ                                      0xffffffffU

#endif /* __MAC_DMA_DMADBG_5_MACRO__ */


/* macros for mac_dma_reg_block.MAC_DMA_DMADBG_5 */
#define INST_MAC_DMA_REG_BLOCK__MAC_DMA_DMADBG_5__NUM                         1

/* macros for BlueprintGlobalNameSpace::MAC_DMA_DMADBG_6 */
#ifndef __MAC_DMA_DMADBG_6_MACRO__
#define __MAC_DMA_DMADBG_6_MACRO__

/* macros for field DATA */
#define MAC_DMA_DMADBG_6__DATA__SHIFT                                         0
#define MAC_DMA_DMADBG_6__DATA__WIDTH                                        32
#define MAC_DMA_DMADBG_6__DATA__MASK                                0xffffffffU
#define MAC_DMA_DMADBG_6__DATA__READ(src)        (u_int32_t)(src) & 0xffffffffU
#define MAC_DMA_DMADBG_6__TYPE                                        u_int32_t
#define MAC_DMA_DMADBG_6__READ                                      0xffffffffU

#endif /* __MAC_DMA_DMADBG_6_MACRO__ */


/* macros for mac_dma_reg_block.MAC_DMA_DMADBG_6 */
#define INST_MAC_DMA_REG_BLOCK__MAC_DMA_DMADBG_6__NUM                         1

/* macros for BlueprintGlobalNameSpace::MAC_DMA_DMADBG_7 */
#ifndef __MAC_DMA_DMADBG_7_MACRO__
#define __MAC_DMA_DMADBG_7_MACRO__

/* macros for field DATA */
#define MAC_DMA_DMADBG_7__DATA__SHIFT                                         0
#define MAC_DMA_DMADBG_7__DATA__WIDTH                                        32
#define MAC_DMA_DMADBG_7__DATA__MASK                                0xffffffffU
#define MAC_DMA_DMADBG_7__DATA__READ(src)        (u_int32_t)(src) & 0xffffffffU
#define MAC_DMA_DMADBG_7__TYPE                                        u_int32_t
#define MAC_DMA_DMADBG_7__READ                                      0xffffffffU

#endif /* __MAC_DMA_DMADBG_7_MACRO__ */


/* macros for mac_dma_reg_block.MAC_DMA_DMADBG_7 */
#define INST_MAC_DMA_REG_BLOCK__MAC_DMA_DMADBG_7__NUM                         1

/* macros for BlueprintGlobalNameSpace::MAC_DMA_QCU_TXDP_REMAINING_QCU_7_0 */
#ifndef __MAC_DMA_QCU_TXDP_REMAINING_QCU_7_0_MACRO__
#define __MAC_DMA_QCU_TXDP_REMAINING_QCU_7_0_MACRO__

/* macros for field DATA */
#define MAC_DMA_QCU_TXDP_REMAINING_QCU_7_0__DATA__SHIFT                       0
#define MAC_DMA_QCU_TXDP_REMAINING_QCU_7_0__DATA__WIDTH                      32
#define MAC_DMA_QCU_TXDP_REMAINING_QCU_7_0__DATA__MASK              0xffffffffU
#define MAC_DMA_QCU_TXDP_REMAINING_QCU_7_0__DATA__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define MAC_DMA_QCU_TXDP_REMAINING_QCU_7_0__TYPE                      u_int32_t
#define MAC_DMA_QCU_TXDP_REMAINING_QCU_7_0__READ                    0xffffffffU

#endif /* __MAC_DMA_QCU_TXDP_REMAINING_QCU_7_0_MACRO__ */


/* macros for mac_dma_reg_block.MAC_DMA_QCU_TXDP_REMAINING_QCU_7_0 */
#define INST_MAC_DMA_REG_BLOCK__MAC_DMA_QCU_TXDP_REMAINING_QCU_7_0__NUM       1

/* macros for BlueprintGlobalNameSpace::MAC_DMA_QCU_TXDP_REMAINING_QCU_9_8 */
#ifndef __MAC_DMA_QCU_TXDP_REMAINING_QCU_9_8_MACRO__
#define __MAC_DMA_QCU_TXDP_REMAINING_QCU_9_8_MACRO__

/* macros for field DATA */
#define MAC_DMA_QCU_TXDP_REMAINING_QCU_9_8__DATA__SHIFT                       0
#define MAC_DMA_QCU_TXDP_REMAINING_QCU_9_8__DATA__WIDTH                       8
#define MAC_DMA_QCU_TXDP_REMAINING_QCU_9_8__DATA__MASK              0x000000ffU
#define MAC_DMA_QCU_TXDP_REMAINING_QCU_9_8__DATA__READ(src) \
                    (u_int32_t)(src)\
                    & 0x000000ffU
#define MAC_DMA_QCU_TXDP_REMAINING_QCU_9_8__TYPE                      u_int32_t
#define MAC_DMA_QCU_TXDP_REMAINING_QCU_9_8__READ                    0x000000ffU

#endif /* __MAC_DMA_QCU_TXDP_REMAINING_QCU_9_8_MACRO__ */


/* macros for mac_dma_reg_block.MAC_DMA_QCU_TXDP_REMAINING_QCU_9_8 */
#define INST_MAC_DMA_REG_BLOCK__MAC_DMA_QCU_TXDP_REMAINING_QCU_9_8__NUM       1

/* macros for BlueprintGlobalNameSpace::MAC_QCU_TXDP */
#ifndef __MAC_QCU_TXDP_MACRO__
#define __MAC_QCU_TXDP_MACRO__

/* macros for field DATA */
#define MAC_QCU_TXDP__DATA__SHIFT                                             0
#define MAC_QCU_TXDP__DATA__WIDTH                                            32
#define MAC_QCU_TXDP__DATA__MASK                                    0xffffffffU
#define MAC_QCU_TXDP__DATA__READ(src)            (u_int32_t)(src) & 0xffffffffU
#define MAC_QCU_TXDP__DATA__WRITE(src)         ((u_int32_t)(src) & 0xffffffffU)
#define MAC_QCU_TXDP__DATA__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xffffffffU) | ((u_int32_t)(src) &\
                    0xffffffffU)
#define MAC_QCU_TXDP__DATA__VERIFY(src)  (!(((u_int32_t)(src) & ~0xffffffffU)))
#define MAC_QCU_TXDP__TYPE                                            u_int32_t
#define MAC_QCU_TXDP__READ                                          0xffffffffU
#define MAC_QCU_TXDP__WRITE                                         0xffffffffU

#endif /* __MAC_QCU_TXDP_MACRO__ */


/* macros for mac_qcu_reg_block.MAC_QCU_TXDP */
#define INST_MAC_QCU_REG_BLOCK__MAC_QCU_TXDP__NUM                            10

/* macros for BlueprintGlobalNameSpace::MAC_QCU_STATUS_RING_START */
#ifndef __MAC_QCU_STATUS_RING_START_MACRO__
#define __MAC_QCU_STATUS_RING_START_MACRO__

/* macros for field ADDR */
#define MAC_QCU_STATUS_RING_START__ADDR__SHIFT                                0
#define MAC_QCU_STATUS_RING_START__ADDR__WIDTH                               32
#define MAC_QCU_STATUS_RING_START__ADDR__MASK                       0xffffffffU
#define MAC_QCU_STATUS_RING_START__ADDR__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define MAC_QCU_STATUS_RING_START__ADDR__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0xffffffffU)
#define MAC_QCU_STATUS_RING_START__ADDR__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xffffffffU) | ((u_int32_t)(src) &\
                    0xffffffffU)
#define MAC_QCU_STATUS_RING_START__ADDR__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0xffffffffU)))
#define MAC_QCU_STATUS_RING_START__TYPE                               u_int32_t
#define MAC_QCU_STATUS_RING_START__READ                             0xffffffffU
#define MAC_QCU_STATUS_RING_START__WRITE                            0xffffffffU

#endif /* __MAC_QCU_STATUS_RING_START_MACRO__ */


/* macros for mac_qcu_reg_block.MAC_QCU_STATUS_RING_START */
#define INST_MAC_QCU_REG_BLOCK__MAC_QCU_STATUS_RING_START__NUM                1

/* macros for BlueprintGlobalNameSpace::MAC_QCU_STATUS_RING_END */
#ifndef __MAC_QCU_STATUS_RING_END_MACRO__
#define __MAC_QCU_STATUS_RING_END_MACRO__

/* macros for field ADDR */
#define MAC_QCU_STATUS_RING_END__ADDR__SHIFT                                  0
#define MAC_QCU_STATUS_RING_END__ADDR__WIDTH                                 32
#define MAC_QCU_STATUS_RING_END__ADDR__MASK                         0xffffffffU
#define MAC_QCU_STATUS_RING_END__ADDR__READ(src) (u_int32_t)(src) & 0xffffffffU
#define MAC_QCU_STATUS_RING_END__ADDR__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0xffffffffU)
#define MAC_QCU_STATUS_RING_END__ADDR__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xffffffffU) | ((u_int32_t)(src) &\
                    0xffffffffU)
#define MAC_QCU_STATUS_RING_END__ADDR__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0xffffffffU)))
#define MAC_QCU_STATUS_RING_END__TYPE                                 u_int32_t
#define MAC_QCU_STATUS_RING_END__READ                               0xffffffffU
#define MAC_QCU_STATUS_RING_END__WRITE                              0xffffffffU

#endif /* __MAC_QCU_STATUS_RING_END_MACRO__ */


/* macros for mac_qcu_reg_block.MAC_QCU_STATUS_RING_END */
#define INST_MAC_QCU_REG_BLOCK__MAC_QCU_STATUS_RING_END__NUM                  1

/* macros for BlueprintGlobalNameSpace::MAC_QCU_STATUS_RING_CURRENT */
#ifndef __MAC_QCU_STATUS_RING_CURRENT_MACRO__
#define __MAC_QCU_STATUS_RING_CURRENT_MACRO__

/* macros for field ADDRESS */
#define MAC_QCU_STATUS_RING_CURRENT__ADDRESS__SHIFT                           0
#define MAC_QCU_STATUS_RING_CURRENT__ADDRESS__WIDTH                          32
#define MAC_QCU_STATUS_RING_CURRENT__ADDRESS__MASK                  0xffffffffU
#define MAC_QCU_STATUS_RING_CURRENT__ADDRESS__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define MAC_QCU_STATUS_RING_CURRENT__TYPE                             u_int32_t
#define MAC_QCU_STATUS_RING_CURRENT__READ                           0xffffffffU

#endif /* __MAC_QCU_STATUS_RING_CURRENT_MACRO__ */


/* macros for mac_qcu_reg_block.MAC_QCU_STATUS_RING_CURRENT */
#define INST_MAC_QCU_REG_BLOCK__MAC_QCU_STATUS_RING_CURRENT__NUM              1

/* macros for BlueprintGlobalNameSpace::MAC_QCU_TXE */
#ifndef __MAC_QCU_TXE_MACRO__
#define __MAC_QCU_TXE_MACRO__

/* macros for field DATA */
#define MAC_QCU_TXE__DATA__SHIFT                                              0
#define MAC_QCU_TXE__DATA__WIDTH                                             10
#define MAC_QCU_TXE__DATA__MASK                                     0x000003ffU
#define MAC_QCU_TXE__DATA__READ(src)             (u_int32_t)(src) & 0x000003ffU
#define MAC_QCU_TXE__TYPE                                             u_int32_t
#define MAC_QCU_TXE__READ                                           0x000003ffU

#endif /* __MAC_QCU_TXE_MACRO__ */


/* macros for mac_qcu_reg_block.MAC_QCU_TXE */
#define INST_MAC_QCU_REG_BLOCK__MAC_QCU_TXE__NUM                              1

/* macros for BlueprintGlobalNameSpace::MAC_QCU_TXD */
#ifndef __MAC_QCU_TXD_MACRO__
#define __MAC_QCU_TXD_MACRO__

/* macros for field DATA */
#define MAC_QCU_TXD__DATA__SHIFT                                              0
#define MAC_QCU_TXD__DATA__WIDTH                                             10
#define MAC_QCU_TXD__DATA__MASK                                     0x000003ffU
#define MAC_QCU_TXD__DATA__READ(src)             (u_int32_t)(src) & 0x000003ffU
#define MAC_QCU_TXD__DATA__WRITE(src)          ((u_int32_t)(src) & 0x000003ffU)
#define MAC_QCU_TXD__DATA__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000003ffU) | ((u_int32_t)(src) &\
                    0x000003ffU)
#define MAC_QCU_TXD__DATA__VERIFY(src)   (!(((u_int32_t)(src) & ~0x000003ffU)))

/* macros for field SPARE */
#define MAC_QCU_TXD__SPARE__SHIFT                                            10
#define MAC_QCU_TXD__SPARE__WIDTH                                             4
#define MAC_QCU_TXD__SPARE__MASK                                    0x00003c00U
#define MAC_QCU_TXD__SPARE__READ(src)  (((u_int32_t)(src) & 0x00003c00U) >> 10)
#define MAC_QCU_TXD__SPARE__WRITE(src) (((u_int32_t)(src) << 10) & 0x00003c00U)
#define MAC_QCU_TXD__SPARE__MODIFY(dst, src) \
    (dst) = ((dst) &\
            ~0x00003c00U) | (((u_int32_t)(src) <<\
                    10) & 0x00003c00U)
#define MAC_QCU_TXD__SPARE__VERIFY(src) \
    (!((((u_int32_t)(src)\
         << 10) & ~0x00003c00U)))

#define MAC_QCU_TXD__TYPE                                             u_int32_t
#define MAC_QCU_TXD__READ                                           0x000003ffU
#define MAC_QCU_TXD__WRITE                                          0x000003ffU

#endif /* __MAC_QCU_TXD_MACRO__ */


/* macros for mac_qcu_reg_block.MAC_QCU_TXD */
#define INST_MAC_QCU_REG_BLOCK__MAC_QCU_TXD__NUM                              1

/* macros for BlueprintGlobalNameSpace::MAC_QCU_CBR */
#ifndef __MAC_QCU_CBR_MACRO__
#define __MAC_QCU_CBR_MACRO__

/* macros for field INTERVAL */
#define MAC_QCU_CBR__INTERVAL__SHIFT                                          0
#define MAC_QCU_CBR__INTERVAL__WIDTH                                         24
#define MAC_QCU_CBR__INTERVAL__MASK                                 0x00ffffffU
#define MAC_QCU_CBR__INTERVAL__READ(src)         (u_int32_t)(src) & 0x00ffffffU
#define MAC_QCU_CBR__INTERVAL__WRITE(src)      ((u_int32_t)(src) & 0x00ffffffU)
#define MAC_QCU_CBR__INTERVAL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00ffffffU) | ((u_int32_t)(src) &\
                    0x00ffffffU)
#define MAC_QCU_CBR__INTERVAL__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00ffffffU)))

/* macros for field OVF_THRESH */
#define MAC_QCU_CBR__OVF_THRESH__SHIFT                                       24
#define MAC_QCU_CBR__OVF_THRESH__WIDTH                                        8
#define MAC_QCU_CBR__OVF_THRESH__MASK                               0xff000000U
#define MAC_QCU_CBR__OVF_THRESH__READ(src) \
                    (((u_int32_t)(src)\
                    & 0xff000000U) >> 24)
#define MAC_QCU_CBR__OVF_THRESH__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 24) & 0xff000000U)
#define MAC_QCU_CBR__OVF_THRESH__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xff000000U) | (((u_int32_t)(src) <<\
                    24) & 0xff000000U)
#define MAC_QCU_CBR__OVF_THRESH__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 24) & ~0xff000000U)))
#define MAC_QCU_CBR__TYPE                                             u_int32_t
#define MAC_QCU_CBR__READ                                           0xffffffffU
#define MAC_QCU_CBR__WRITE                                          0xffffffffU

#endif /* __MAC_QCU_CBR_MACRO__ */


/* macros for mac_qcu_reg_block.MAC_QCU_CBR */
#define INST_MAC_QCU_REG_BLOCK__MAC_QCU_CBR__NUM                             10

/* macros for BlueprintGlobalNameSpace::MAC_QCU_RDYTIME */
#ifndef __MAC_QCU_RDYTIME_MACRO__
#define __MAC_QCU_RDYTIME_MACRO__

/* macros for field DURATION */
#define MAC_QCU_RDYTIME__DURATION__SHIFT                                      0
#define MAC_QCU_RDYTIME__DURATION__WIDTH                                     24
#define MAC_QCU_RDYTIME__DURATION__MASK                             0x00ffffffU
#define MAC_QCU_RDYTIME__DURATION__READ(src)     (u_int32_t)(src) & 0x00ffffffU
#define MAC_QCU_RDYTIME__DURATION__WRITE(src)  ((u_int32_t)(src) & 0x00ffffffU)
#define MAC_QCU_RDYTIME__DURATION__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00ffffffU) | ((u_int32_t)(src) &\
                    0x00ffffffU)
#define MAC_QCU_RDYTIME__DURATION__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00ffffffU)))

/* macros for field EN */
#define MAC_QCU_RDYTIME__EN__SHIFT                                           24
#define MAC_QCU_RDYTIME__EN__WIDTH                                            1
#define MAC_QCU_RDYTIME__EN__MASK                                   0x01000000U
#define MAC_QCU_RDYTIME__EN__READ(src) (((u_int32_t)(src) & 0x01000000U) >> 24)
#define MAC_QCU_RDYTIME__EN__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 24) & 0x01000000U)
#define MAC_QCU_RDYTIME__EN__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x01000000U) | (((u_int32_t)(src) <<\
                    24) & 0x01000000U)
#define MAC_QCU_RDYTIME__EN__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 24) & ~0x01000000U)))
#define MAC_QCU_RDYTIME__EN__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x01000000U) | ((u_int32_t)(1) << 24)
#define MAC_QCU_RDYTIME__EN__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x01000000U) | ((u_int32_t)(0) << 24)
#define MAC_QCU_RDYTIME__TYPE                                         u_int32_t
#define MAC_QCU_RDYTIME__READ                                       0x01ffffffU
#define MAC_QCU_RDYTIME__WRITE                                      0x01ffffffU

#endif /* __MAC_QCU_RDYTIME_MACRO__ */


/* macros for mac_qcu_reg_block.MAC_QCU_RDYTIME */
#define INST_MAC_QCU_REG_BLOCK__MAC_QCU_RDYTIME__NUM                         10

/* macros for BlueprintGlobalNameSpace::MAC_QCU_ONESHOT_ARM_SC */
#ifndef __MAC_QCU_ONESHOT_ARM_SC_MACRO__
#define __MAC_QCU_ONESHOT_ARM_SC_MACRO__

/* macros for field SET */
#define MAC_QCU_ONESHOT_ARM_SC__SET__SHIFT                                    0
#define MAC_QCU_ONESHOT_ARM_SC__SET__WIDTH                                   10
#define MAC_QCU_ONESHOT_ARM_SC__SET__MASK                           0x000003ffU
#define MAC_QCU_ONESHOT_ARM_SC__SET__READ(src)   (u_int32_t)(src) & 0x000003ffU
#define MAC_QCU_ONESHOT_ARM_SC__SET__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x000003ffU)
#define MAC_QCU_ONESHOT_ARM_SC__SET__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000003ffU) | ((u_int32_t)(src) &\
                    0x000003ffU)
#define MAC_QCU_ONESHOT_ARM_SC__SET__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x000003ffU)))
#define MAC_QCU_ONESHOT_ARM_SC__TYPE                                  u_int32_t
#define MAC_QCU_ONESHOT_ARM_SC__READ                                0x000003ffU
#define MAC_QCU_ONESHOT_ARM_SC__WRITE                               0x000003ffU

#endif /* __MAC_QCU_ONESHOT_ARM_SC_MACRO__ */


/* macros for mac_qcu_reg_block.MAC_QCU_ONESHOT_ARM_SC */
#define INST_MAC_QCU_REG_BLOCK__MAC_QCU_ONESHOT_ARM_SC__NUM                   1

/* macros for BlueprintGlobalNameSpace::MAC_QCU_ONESHOT_ARM_CC */
#ifndef __MAC_QCU_ONESHOT_ARM_CC_MACRO__
#define __MAC_QCU_ONESHOT_ARM_CC_MACRO__

/* macros for field CLEAR */
#define MAC_QCU_ONESHOT_ARM_CC__CLEAR__SHIFT                                  0
#define MAC_QCU_ONESHOT_ARM_CC__CLEAR__WIDTH                                 10
#define MAC_QCU_ONESHOT_ARM_CC__CLEAR__MASK                         0x000003ffU
#define MAC_QCU_ONESHOT_ARM_CC__CLEAR__READ(src) (u_int32_t)(src) & 0x000003ffU
#define MAC_QCU_ONESHOT_ARM_CC__CLEAR__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x000003ffU)
#define MAC_QCU_ONESHOT_ARM_CC__CLEAR__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000003ffU) | ((u_int32_t)(src) &\
                    0x000003ffU)
#define MAC_QCU_ONESHOT_ARM_CC__CLEAR__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x000003ffU)))
#define MAC_QCU_ONESHOT_ARM_CC__TYPE                                  u_int32_t
#define MAC_QCU_ONESHOT_ARM_CC__READ                                0x000003ffU
#define MAC_QCU_ONESHOT_ARM_CC__WRITE                               0x000003ffU

#endif /* __MAC_QCU_ONESHOT_ARM_CC_MACRO__ */


/* macros for mac_qcu_reg_block.MAC_QCU_ONESHOT_ARM_CC */
#define INST_MAC_QCU_REG_BLOCK__MAC_QCU_ONESHOT_ARM_CC__NUM                   1

/* macros for BlueprintGlobalNameSpace::MAC_QCU_MISC */
#ifndef __MAC_QCU_MISC_MACRO__
#define __MAC_QCU_MISC_MACRO__

/* macros for field FSP */
#define MAC_QCU_MISC__FSP__SHIFT                                              0
#define MAC_QCU_MISC__FSP__WIDTH                                              4
#define MAC_QCU_MISC__FSP__MASK                                     0x0000000fU
#define MAC_QCU_MISC__FSP__READ(src)             (u_int32_t)(src) & 0x0000000fU
#define MAC_QCU_MISC__FSP__WRITE(src)          ((u_int32_t)(src) & 0x0000000fU)
#define MAC_QCU_MISC__FSP__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000000fU) | ((u_int32_t)(src) &\
                    0x0000000fU)
#define MAC_QCU_MISC__FSP__VERIFY(src)   (!(((u_int32_t)(src) & ~0x0000000fU)))

/* macros for field ONESHOT_EN */
#define MAC_QCU_MISC__ONESHOT_EN__SHIFT                                       4
#define MAC_QCU_MISC__ONESHOT_EN__WIDTH                                       1
#define MAC_QCU_MISC__ONESHOT_EN__MASK                              0x00000010U
#define MAC_QCU_MISC__ONESHOT_EN__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000010U) >> 4)
#define MAC_QCU_MISC__ONESHOT_EN__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 4) & 0x00000010U)
#define MAC_QCU_MISC__ONESHOT_EN__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000010U) | (((u_int32_t)(src) <<\
                    4) & 0x00000010U)
#define MAC_QCU_MISC__ONESHOT_EN__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 4) & ~0x00000010U)))
#define MAC_QCU_MISC__ONESHOT_EN__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000010U) | ((u_int32_t)(1) << 4)
#define MAC_QCU_MISC__ONESHOT_EN__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000010U) | ((u_int32_t)(0) << 4)

/* macros for field CBR_EXP_INC_DIS_NOFR */
#define MAC_QCU_MISC__CBR_EXP_INC_DIS_NOFR__SHIFT                             5
#define MAC_QCU_MISC__CBR_EXP_INC_DIS_NOFR__WIDTH                             1
#define MAC_QCU_MISC__CBR_EXP_INC_DIS_NOFR__MASK                    0x00000020U
#define MAC_QCU_MISC__CBR_EXP_INC_DIS_NOFR__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000020U) >> 5)
#define MAC_QCU_MISC__CBR_EXP_INC_DIS_NOFR__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 5) & 0x00000020U)
#define MAC_QCU_MISC__CBR_EXP_INC_DIS_NOFR__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000020U) | (((u_int32_t)(src) <<\
                    5) & 0x00000020U)
#define MAC_QCU_MISC__CBR_EXP_INC_DIS_NOFR__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 5) & ~0x00000020U)))
#define MAC_QCU_MISC__CBR_EXP_INC_DIS_NOFR__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000020U) | ((u_int32_t)(1) << 5)
#define MAC_QCU_MISC__CBR_EXP_INC_DIS_NOFR__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000020U) | ((u_int32_t)(0) << 5)

/* macros for field CBR_EXP_INC_DIS_NOBCNFR */
#define MAC_QCU_MISC__CBR_EXP_INC_DIS_NOBCNFR__SHIFT                          6
#define MAC_QCU_MISC__CBR_EXP_INC_DIS_NOBCNFR__WIDTH                          1
#define MAC_QCU_MISC__CBR_EXP_INC_DIS_NOBCNFR__MASK                 0x00000040U
#define MAC_QCU_MISC__CBR_EXP_INC_DIS_NOBCNFR__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000040U) >> 6)
#define MAC_QCU_MISC__CBR_EXP_INC_DIS_NOBCNFR__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 6) & 0x00000040U)
#define MAC_QCU_MISC__CBR_EXP_INC_DIS_NOBCNFR__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000040U) | (((u_int32_t)(src) <<\
                    6) & 0x00000040U)
#define MAC_QCU_MISC__CBR_EXP_INC_DIS_NOBCNFR__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 6) & ~0x00000040U)))
#define MAC_QCU_MISC__CBR_EXP_INC_DIS_NOBCNFR__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000040U) | ((u_int32_t)(1) << 6)
#define MAC_QCU_MISC__CBR_EXP_INC_DIS_NOBCNFR__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000040U) | ((u_int32_t)(0) << 6)

/* macros for field IS_BCN */
#define MAC_QCU_MISC__IS_BCN__SHIFT                                           7
#define MAC_QCU_MISC__IS_BCN__WIDTH                                           1
#define MAC_QCU_MISC__IS_BCN__MASK                                  0x00000080U
#define MAC_QCU_MISC__IS_BCN__READ(src) (((u_int32_t)(src) & 0x00000080U) >> 7)
#define MAC_QCU_MISC__IS_BCN__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 7) & 0x00000080U)
#define MAC_QCU_MISC__IS_BCN__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000080U) | (((u_int32_t)(src) <<\
                    7) & 0x00000080U)
#define MAC_QCU_MISC__IS_BCN__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 7) & ~0x00000080U)))
#define MAC_QCU_MISC__IS_BCN__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000080U) | ((u_int32_t)(1) << 7)
#define MAC_QCU_MISC__IS_BCN__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000080U) | ((u_int32_t)(0) << 7)

/* macros for field CBR_EXP_INC_LIMIT */
#define MAC_QCU_MISC__CBR_EXP_INC_LIMIT__SHIFT                                8
#define MAC_QCU_MISC__CBR_EXP_INC_LIMIT__WIDTH                                1
#define MAC_QCU_MISC__CBR_EXP_INC_LIMIT__MASK                       0x00000100U
#define MAC_QCU_MISC__CBR_EXP_INC_LIMIT__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000100U) >> 8)
#define MAC_QCU_MISC__CBR_EXP_INC_LIMIT__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 8) & 0x00000100U)
#define MAC_QCU_MISC__CBR_EXP_INC_LIMIT__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000100U) | (((u_int32_t)(src) <<\
                    8) & 0x00000100U)
#define MAC_QCU_MISC__CBR_EXP_INC_LIMIT__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 8) & ~0x00000100U)))
#define MAC_QCU_MISC__CBR_EXP_INC_LIMIT__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000100U) | ((u_int32_t)(1) << 8)
#define MAC_QCU_MISC__CBR_EXP_INC_LIMIT__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000100U) | ((u_int32_t)(0) << 8)

/* macros for field TXE_CLR_ON_CBR_END */
#define MAC_QCU_MISC__TXE_CLR_ON_CBR_END__SHIFT                               9
#define MAC_QCU_MISC__TXE_CLR_ON_CBR_END__WIDTH                               1
#define MAC_QCU_MISC__TXE_CLR_ON_CBR_END__MASK                      0x00000200U
#define MAC_QCU_MISC__TXE_CLR_ON_CBR_END__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000200U) >> 9)
#define MAC_QCU_MISC__TXE_CLR_ON_CBR_END__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 9) & 0x00000200U)
#define MAC_QCU_MISC__TXE_CLR_ON_CBR_END__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000200U) | (((u_int32_t)(src) <<\
                    9) & 0x00000200U)
#define MAC_QCU_MISC__TXE_CLR_ON_CBR_END__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 9) & ~0x00000200U)))
#define MAC_QCU_MISC__TXE_CLR_ON_CBR_END__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000200U) | ((u_int32_t)(1) << 9)
#define MAC_QCU_MISC__TXE_CLR_ON_CBR_END__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000200U) | ((u_int32_t)(0) << 9)

/* macros for field MMR_CBR_EXP_CNT_CLR_EN */
#define MAC_QCU_MISC__MMR_CBR_EXP_CNT_CLR_EN__SHIFT                          10
#define MAC_QCU_MISC__MMR_CBR_EXP_CNT_CLR_EN__WIDTH                           1
#define MAC_QCU_MISC__MMR_CBR_EXP_CNT_CLR_EN__MASK                  0x00000400U
#define MAC_QCU_MISC__MMR_CBR_EXP_CNT_CLR_EN__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000400U) >> 10)
#define MAC_QCU_MISC__MMR_CBR_EXP_CNT_CLR_EN__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 10) & 0x00000400U)
#define MAC_QCU_MISC__MMR_CBR_EXP_CNT_CLR_EN__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000400U) | (((u_int32_t)(src) <<\
                    10) & 0x00000400U)
#define MAC_QCU_MISC__MMR_CBR_EXP_CNT_CLR_EN__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 10) & ~0x00000400U)))
#define MAC_QCU_MISC__MMR_CBR_EXP_CNT_CLR_EN__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000400U) | ((u_int32_t)(1) << 10)
#define MAC_QCU_MISC__MMR_CBR_EXP_CNT_CLR_EN__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000400U) | ((u_int32_t)(0) << 10)

/* macros for field FR_ABORT_REQ_EN */
#define MAC_QCU_MISC__FR_ABORT_REQ_EN__SHIFT                                 11
#define MAC_QCU_MISC__FR_ABORT_REQ_EN__WIDTH                                  1
#define MAC_QCU_MISC__FR_ABORT_REQ_EN__MASK                         0x00000800U
#define MAC_QCU_MISC__FR_ABORT_REQ_EN__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000800U) >> 11)
#define MAC_QCU_MISC__FR_ABORT_REQ_EN__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 11) & 0x00000800U)
#define MAC_QCU_MISC__FR_ABORT_REQ_EN__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000800U) | (((u_int32_t)(src) <<\
                    11) & 0x00000800U)
#define MAC_QCU_MISC__FR_ABORT_REQ_EN__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 11) & ~0x00000800U)))
#define MAC_QCU_MISC__FR_ABORT_REQ_EN__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000800U) | ((u_int32_t)(1) << 11)
#define MAC_QCU_MISC__FR_ABORT_REQ_EN__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000800U) | ((u_int32_t)(0) << 11)
#define MAC_QCU_MISC__TYPE                                            u_int32_t
#define MAC_QCU_MISC__READ                                          0x00000fffU
#define MAC_QCU_MISC__WRITE                                         0x00000fffU

#endif /* __MAC_QCU_MISC_MACRO__ */


/* macros for mac_qcu_reg_block.MAC_QCU_MISC */
#define INST_MAC_QCU_REG_BLOCK__MAC_QCU_MISC__NUM                            10

/* macros for BlueprintGlobalNameSpace::MAC_QCU_CNT */
#ifndef __MAC_QCU_CNT_MACRO__
#define __MAC_QCU_CNT_MACRO__

/* macros for field FR_PEND */
#define MAC_QCU_CNT__FR_PEND__SHIFT                                           0
#define MAC_QCU_CNT__FR_PEND__WIDTH                                           2
#define MAC_QCU_CNT__FR_PEND__MASK                                  0x00000003U
#define MAC_QCU_CNT__FR_PEND__READ(src)          (u_int32_t)(src) & 0x00000003U

/* macros for field CBR_EXP */
#define MAC_QCU_CNT__CBR_EXP__SHIFT                                           8
#define MAC_QCU_CNT__CBR_EXP__WIDTH                                           8
#define MAC_QCU_CNT__CBR_EXP__MASK                                  0x0000ff00U
#define MAC_QCU_CNT__CBR_EXP__READ(src) (((u_int32_t)(src) & 0x0000ff00U) >> 8)
#define MAC_QCU_CNT__TYPE                                             u_int32_t
#define MAC_QCU_CNT__READ                                           0x0000ff03U

#endif /* __MAC_QCU_CNT_MACRO__ */


/* macros for mac_qcu_reg_block.MAC_QCU_CNT */
#define INST_MAC_QCU_REG_BLOCK__MAC_QCU_CNT__NUM                             10

/* macros for BlueprintGlobalNameSpace::MAC_QCU_RDYTIME_SHDN */
#ifndef __MAC_QCU_RDYTIME_SHDN_MACRO__
#define __MAC_QCU_RDYTIME_SHDN_MACRO__

/* macros for field SHUTDOWN */
#define MAC_QCU_RDYTIME_SHDN__SHUTDOWN__SHIFT                                 0
#define MAC_QCU_RDYTIME_SHDN__SHUTDOWN__WIDTH                                10
#define MAC_QCU_RDYTIME_SHDN__SHUTDOWN__MASK                        0x000003ffU
#define MAC_QCU_RDYTIME_SHDN__SHUTDOWN__READ(src) \
                    (u_int32_t)(src)\
                    & 0x000003ffU
#define MAC_QCU_RDYTIME_SHDN__SHUTDOWN__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x000003ffU)
#define MAC_QCU_RDYTIME_SHDN__SHUTDOWN__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000003ffU) | ((u_int32_t)(src) &\
                    0x000003ffU)
#define MAC_QCU_RDYTIME_SHDN__SHUTDOWN__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x000003ffU)))
#define MAC_QCU_RDYTIME_SHDN__TYPE                                    u_int32_t
#define MAC_QCU_RDYTIME_SHDN__READ                                  0x000003ffU
#define MAC_QCU_RDYTIME_SHDN__WRITE                                 0x000003ffU
#define MAC_QCU_RDYTIME_SHDN__WOCLR                                 0x000003ffU

#endif /* __MAC_QCU_RDYTIME_SHDN_MACRO__ */


/* macros for mac_qcu_reg_block.MAC_QCU_RDYTIME_SHDN */
#define INST_MAC_QCU_REG_BLOCK__MAC_QCU_RDYTIME_SHDN__NUM                     1

/* macros for BlueprintGlobalNameSpace::MAC_QCU_DESC_CRC_CHK */
#ifndef __MAC_QCU_DESC_CRC_CHK_MACRO__
#define __MAC_QCU_DESC_CRC_CHK_MACRO__

/* macros for field EN */
#define MAC_QCU_DESC_CRC_CHK__EN__SHIFT                                       0
#define MAC_QCU_DESC_CRC_CHK__EN__WIDTH                                       1
#define MAC_QCU_DESC_CRC_CHK__EN__MASK                              0x00000001U
#define MAC_QCU_DESC_CRC_CHK__EN__READ(src)      (u_int32_t)(src) & 0x00000001U
#define MAC_QCU_DESC_CRC_CHK__EN__WRITE(src)   ((u_int32_t)(src) & 0x00000001U)
#define MAC_QCU_DESC_CRC_CHK__EN__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | ((u_int32_t)(src) &\
                    0x00000001U)
#define MAC_QCU_DESC_CRC_CHK__EN__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00000001U)))
#define MAC_QCU_DESC_CRC_CHK__EN__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(1)
#define MAC_QCU_DESC_CRC_CHK__EN__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(0)
#define MAC_QCU_DESC_CRC_CHK__TYPE                                    u_int32_t
#define MAC_QCU_DESC_CRC_CHK__READ                                  0x00000001U
#define MAC_QCU_DESC_CRC_CHK__WRITE                                 0x00000001U

#endif /* __MAC_QCU_DESC_CRC_CHK_MACRO__ */


/* macros for mac_qcu_reg_block.MAC_QCU_DESC_CRC_CHK */
#define INST_MAC_QCU_REG_BLOCK__MAC_QCU_DESC_CRC_CHK__NUM                     1

/* macros for BlueprintGlobalNameSpace::MAC_DCU_QCUMASK */
#ifndef __MAC_DCU_QCUMASK_MACRO__
#define __MAC_DCU_QCUMASK_MACRO__

/* macros for field DATA */
#define MAC_DCU_QCUMASK__DATA__SHIFT                                          0
#define MAC_DCU_QCUMASK__DATA__WIDTH                                         10
#define MAC_DCU_QCUMASK__DATA__MASK                                 0x000003ffU
#define MAC_DCU_QCUMASK__DATA__READ(src)         (u_int32_t)(src) & 0x000003ffU
#define MAC_DCU_QCUMASK__DATA__WRITE(src)      ((u_int32_t)(src) & 0x000003ffU)
#define MAC_DCU_QCUMASK__DATA__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000003ffU) | ((u_int32_t)(src) &\
                    0x000003ffU)
#define MAC_DCU_QCUMASK__DATA__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x000003ffU)))
#define MAC_DCU_QCUMASK__TYPE                                         u_int32_t
#define MAC_DCU_QCUMASK__READ                                       0x000003ffU
#define MAC_DCU_QCUMASK__WRITE                                      0x000003ffU

#endif /* __MAC_DCU_QCUMASK_MACRO__ */


/* macros for mac_dcu_reg_block.MAC_DCU_QCUMASK */
#define INST_MAC_DCU_REG_BLOCK__MAC_DCU_QCUMASK__NUM                         10

/* macros for BlueprintGlobalNameSpace::MAC_DCU_GBL_IFS_SIFS */
#ifndef __MAC_DCU_GBL_IFS_SIFS_MACRO__
#define __MAC_DCU_GBL_IFS_SIFS_MACRO__

/* macros for field DURATION */
#define MAC_DCU_GBL_IFS_SIFS__DURATION__SHIFT                                 0
#define MAC_DCU_GBL_IFS_SIFS__DURATION__WIDTH                                16
#define MAC_DCU_GBL_IFS_SIFS__DURATION__MASK                        0x0000ffffU
#define MAC_DCU_GBL_IFS_SIFS__DURATION__READ(src) \
                    (u_int32_t)(src)\
                    & 0x0000ffffU
#define MAC_DCU_GBL_IFS_SIFS__DURATION__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x0000ffffU)
#define MAC_DCU_GBL_IFS_SIFS__DURATION__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000ffffU) | ((u_int32_t)(src) &\
                    0x0000ffffU)
#define MAC_DCU_GBL_IFS_SIFS__DURATION__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x0000ffffU)))
#define MAC_DCU_GBL_IFS_SIFS__TYPE                                    u_int32_t
#define MAC_DCU_GBL_IFS_SIFS__READ                                  0x0000ffffU
#define MAC_DCU_GBL_IFS_SIFS__WRITE                                 0x0000ffffU

#endif /* __MAC_DCU_GBL_IFS_SIFS_MACRO__ */


/* macros for mac_dcu_reg_block.MAC_DCU_GBL_IFS_SIFS */
#define INST_MAC_DCU_REG_BLOCK__MAC_DCU_GBL_IFS_SIFS__NUM                     1

/* macros for BlueprintGlobalNameSpace::MAC_DCU_TXFILTER_DCU0_31_0 */
#ifndef __MAC_DCU_TXFILTER_DCU0_31_0_MACRO__
#define __MAC_DCU_TXFILTER_DCU0_31_0_MACRO__

/* macros for field DATA */
#define MAC_DCU_TXFILTER_DCU0_31_0__DATA__SHIFT                               0
#define MAC_DCU_TXFILTER_DCU0_31_0__DATA__WIDTH                              32
#define MAC_DCU_TXFILTER_DCU0_31_0__DATA__MASK                      0xffffffffU
#define MAC_DCU_TXFILTER_DCU0_31_0__DATA__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define MAC_DCU_TXFILTER_DCU0_31_0__DATA__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0xffffffffU)
#define MAC_DCU_TXFILTER_DCU0_31_0__DATA__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xffffffffU) | ((u_int32_t)(src) &\
                    0xffffffffU)
#define MAC_DCU_TXFILTER_DCU0_31_0__DATA__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0xffffffffU)))
#define MAC_DCU_TXFILTER_DCU0_31_0__TYPE                              u_int32_t
#define MAC_DCU_TXFILTER_DCU0_31_0__READ                            0xffffffffU
#define MAC_DCU_TXFILTER_DCU0_31_0__WRITE                           0xffffffffU

#endif /* __MAC_DCU_TXFILTER_DCU0_31_0_MACRO__ */


/* macros for mac_dcu_reg_block.MAC_DCU_TXFILTER_DCU0_31_0 */
#define INST_MAC_DCU_REG_BLOCK__MAC_DCU_TXFILTER_DCU0_31_0__NUM               1

/* macros for BlueprintGlobalNameSpace::MAC_DCU_TXFILTER_DCU8_31_0 */
#ifndef __MAC_DCU_TXFILTER_DCU8_31_0_MACRO__
#define __MAC_DCU_TXFILTER_DCU8_31_0_MACRO__

/* macros for field DATA */
#define MAC_DCU_TXFILTER_DCU8_31_0__DATA__SHIFT                               0
#define MAC_DCU_TXFILTER_DCU8_31_0__DATA__WIDTH                              32
#define MAC_DCU_TXFILTER_DCU8_31_0__DATA__MASK                      0xffffffffU
#define MAC_DCU_TXFILTER_DCU8_31_0__DATA__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define MAC_DCU_TXFILTER_DCU8_31_0__TYPE                              u_int32_t
#define MAC_DCU_TXFILTER_DCU8_31_0__READ                            0xffffffffU

#endif /* __MAC_DCU_TXFILTER_DCU8_31_0_MACRO__ */


/* macros for mac_dcu_reg_block.MAC_DCU_TXFILTER_DCU8_31_0 */
#define INST_MAC_DCU_REG_BLOCK__MAC_DCU_TXFILTER_DCU8_31_0__NUM               1

/* macros for BlueprintGlobalNameSpace::MAC_DCU_LCL_IFS */
#ifndef __MAC_DCU_LCL_IFS_MACRO__
#define __MAC_DCU_LCL_IFS_MACRO__

/* macros for field CW_MIN */
#define MAC_DCU_LCL_IFS__CW_MIN__SHIFT                                        0
#define MAC_DCU_LCL_IFS__CW_MIN__WIDTH                                       10
#define MAC_DCU_LCL_IFS__CW_MIN__MASK                               0x000003ffU
#define MAC_DCU_LCL_IFS__CW_MIN__READ(src)       (u_int32_t)(src) & 0x000003ffU
#define MAC_DCU_LCL_IFS__CW_MIN__WRITE(src)    ((u_int32_t)(src) & 0x000003ffU)
#define MAC_DCU_LCL_IFS__CW_MIN__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000003ffU) | ((u_int32_t)(src) &\
                    0x000003ffU)
#define MAC_DCU_LCL_IFS__CW_MIN__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x000003ffU)))

/* macros for field CW_MAX */
#define MAC_DCU_LCL_IFS__CW_MAX__SHIFT                                       10
#define MAC_DCU_LCL_IFS__CW_MAX__WIDTH                                       10
#define MAC_DCU_LCL_IFS__CW_MAX__MASK                               0x000ffc00U
#define MAC_DCU_LCL_IFS__CW_MAX__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x000ffc00U) >> 10)
#define MAC_DCU_LCL_IFS__CW_MAX__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 10) & 0x000ffc00U)
#define MAC_DCU_LCL_IFS__CW_MAX__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000ffc00U) | (((u_int32_t)(src) <<\
                    10) & 0x000ffc00U)
#define MAC_DCU_LCL_IFS__CW_MAX__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 10) & ~0x000ffc00U)))

/* macros for field AIFS */
#define MAC_DCU_LCL_IFS__AIFS__SHIFT                                         20
#define MAC_DCU_LCL_IFS__AIFS__WIDTH                                          8
#define MAC_DCU_LCL_IFS__AIFS__MASK                                 0x0ff00000U
#define MAC_DCU_LCL_IFS__AIFS__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0ff00000U) >> 20)
#define MAC_DCU_LCL_IFS__AIFS__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 20) & 0x0ff00000U)
#define MAC_DCU_LCL_IFS__AIFS__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0ff00000U) | (((u_int32_t)(src) <<\
                    20) & 0x0ff00000U)
#define MAC_DCU_LCL_IFS__AIFS__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 20) & ~0x0ff00000U)))

/* macros for field LONG_AIFS */
#define MAC_DCU_LCL_IFS__LONG_AIFS__SHIFT                                    28
#define MAC_DCU_LCL_IFS__LONG_AIFS__WIDTH                                     1
#define MAC_DCU_LCL_IFS__LONG_AIFS__MASK                            0x10000000U
#define MAC_DCU_LCL_IFS__LONG_AIFS__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x10000000U) >> 28)
#define MAC_DCU_LCL_IFS__LONG_AIFS__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 28) & 0x10000000U)
#define MAC_DCU_LCL_IFS__LONG_AIFS__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x10000000U) | (((u_int32_t)(src) <<\
                    28) & 0x10000000U)
#define MAC_DCU_LCL_IFS__LONG_AIFS__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 28) & ~0x10000000U)))
#define MAC_DCU_LCL_IFS__LONG_AIFS__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x10000000U) | ((u_int32_t)(1) << 28)
#define MAC_DCU_LCL_IFS__LONG_AIFS__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x10000000U) | ((u_int32_t)(0) << 28)
#define MAC_DCU_LCL_IFS__TYPE                                         u_int32_t
#define MAC_DCU_LCL_IFS__READ                                       0x1fffffffU
#define MAC_DCU_LCL_IFS__WRITE                                      0x1fffffffU

#endif /* __MAC_DCU_LCL_IFS_MACRO__ */


/* macros for mac_dcu_reg_block.MAC_DCU_LCL_IFS */
#define INST_MAC_DCU_REG_BLOCK__MAC_DCU_LCL_IFS__NUM                         10

/* macros for BlueprintGlobalNameSpace::MAC_DCU_GBL_IFS_SLOT */
#ifndef __MAC_DCU_GBL_IFS_SLOT_MACRO__
#define __MAC_DCU_GBL_IFS_SLOT_MACRO__

/* macros for field DURATION */
#define MAC_DCU_GBL_IFS_SLOT__DURATION__SHIFT                                 0
#define MAC_DCU_GBL_IFS_SLOT__DURATION__WIDTH                                16
#define MAC_DCU_GBL_IFS_SLOT__DURATION__MASK                        0x0000ffffU
#define MAC_DCU_GBL_IFS_SLOT__DURATION__READ(src) \
                    (u_int32_t)(src)\
                    & 0x0000ffffU
#define MAC_DCU_GBL_IFS_SLOT__DURATION__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x0000ffffU)
#define MAC_DCU_GBL_IFS_SLOT__DURATION__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000ffffU) | ((u_int32_t)(src) &\
                    0x0000ffffU)
#define MAC_DCU_GBL_IFS_SLOT__DURATION__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x0000ffffU)))
#define MAC_DCU_GBL_IFS_SLOT__TYPE                                    u_int32_t
#define MAC_DCU_GBL_IFS_SLOT__READ                                  0x0000ffffU
#define MAC_DCU_GBL_IFS_SLOT__WRITE                                 0x0000ffffU

#endif /* __MAC_DCU_GBL_IFS_SLOT_MACRO__ */


/* macros for mac_dcu_reg_block.MAC_DCU_GBL_IFS_SLOT */
#define INST_MAC_DCU_REG_BLOCK__MAC_DCU_GBL_IFS_SLOT__NUM                     1

/* macros for BlueprintGlobalNameSpace::MAC_DCU_TXFILTER_DCU0_63_32 */
#ifndef __MAC_DCU_TXFILTER_DCU0_63_32_MACRO__
#define __MAC_DCU_TXFILTER_DCU0_63_32_MACRO__

/* macros for field DATA */
#define MAC_DCU_TXFILTER_DCU0_63_32__DATA__SHIFT                              0
#define MAC_DCU_TXFILTER_DCU0_63_32__DATA__WIDTH                             32
#define MAC_DCU_TXFILTER_DCU0_63_32__DATA__MASK                     0xffffffffU
#define MAC_DCU_TXFILTER_DCU0_63_32__DATA__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define MAC_DCU_TXFILTER_DCU0_63_32__DATA__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0xffffffffU)
#define MAC_DCU_TXFILTER_DCU0_63_32__DATA__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xffffffffU) | ((u_int32_t)(src) &\
                    0xffffffffU)
#define MAC_DCU_TXFILTER_DCU0_63_32__DATA__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0xffffffffU)))
#define MAC_DCU_TXFILTER_DCU0_63_32__TYPE                             u_int32_t
#define MAC_DCU_TXFILTER_DCU0_63_32__READ                           0xffffffffU
#define MAC_DCU_TXFILTER_DCU0_63_32__WRITE                          0xffffffffU

#endif /* __MAC_DCU_TXFILTER_DCU0_63_32_MACRO__ */


/* macros for mac_dcu_reg_block.MAC_DCU_TXFILTER_DCU0_63_32 */
#define INST_MAC_DCU_REG_BLOCK__MAC_DCU_TXFILTER_DCU0_63_32__NUM              1

/* macros for BlueprintGlobalNameSpace::MAC_DCU_TXFILTER_DCU8_63_32 */
#ifndef __MAC_DCU_TXFILTER_DCU8_63_32_MACRO__
#define __MAC_DCU_TXFILTER_DCU8_63_32_MACRO__

/* macros for field DATA */
#define MAC_DCU_TXFILTER_DCU8_63_32__DATA__SHIFT                              0
#define MAC_DCU_TXFILTER_DCU8_63_32__DATA__WIDTH                             32
#define MAC_DCU_TXFILTER_DCU8_63_32__DATA__MASK                     0xffffffffU
#define MAC_DCU_TXFILTER_DCU8_63_32__DATA__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define MAC_DCU_TXFILTER_DCU8_63_32__TYPE                             u_int32_t
#define MAC_DCU_TXFILTER_DCU8_63_32__READ                           0xffffffffU

#endif /* __MAC_DCU_TXFILTER_DCU8_63_32_MACRO__ */


/* macros for mac_dcu_reg_block.MAC_DCU_TXFILTER_DCU8_63_32 */
#define INST_MAC_DCU_REG_BLOCK__MAC_DCU_TXFILTER_DCU8_63_32__NUM              1

/* macros for BlueprintGlobalNameSpace::MAC_DCU_RETRY_LIMIT */
#ifndef __MAC_DCU_RETRY_LIMIT_MACRO__
#define __MAC_DCU_RETRY_LIMIT_MACRO__

/* macros for field FRFL */
#define MAC_DCU_RETRY_LIMIT__FRFL__SHIFT                                      0
#define MAC_DCU_RETRY_LIMIT__FRFL__WIDTH                                      4
#define MAC_DCU_RETRY_LIMIT__FRFL__MASK                             0x0000000fU
#define MAC_DCU_RETRY_LIMIT__FRFL__READ(src)     (u_int32_t)(src) & 0x0000000fU
#define MAC_DCU_RETRY_LIMIT__FRFL__WRITE(src)  ((u_int32_t)(src) & 0x0000000fU)
#define MAC_DCU_RETRY_LIMIT__FRFL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000000fU) | ((u_int32_t)(src) &\
                    0x0000000fU)
#define MAC_DCU_RETRY_LIMIT__FRFL__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x0000000fU)))

/* macros for field SRFL */
#define MAC_DCU_RETRY_LIMIT__SRFL__SHIFT                                      8
#define MAC_DCU_RETRY_LIMIT__SRFL__WIDTH                                      6
#define MAC_DCU_RETRY_LIMIT__SRFL__MASK                             0x00003f00U
#define MAC_DCU_RETRY_LIMIT__SRFL__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00003f00U) >> 8)
#define MAC_DCU_RETRY_LIMIT__SRFL__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 8) & 0x00003f00U)
#define MAC_DCU_RETRY_LIMIT__SRFL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00003f00U) | (((u_int32_t)(src) <<\
                    8) & 0x00003f00U)
#define MAC_DCU_RETRY_LIMIT__SRFL__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 8) & ~0x00003f00U)))

/* macros for field SDFL */
#define MAC_DCU_RETRY_LIMIT__SDFL__SHIFT                                     14
#define MAC_DCU_RETRY_LIMIT__SDFL__WIDTH                                      6
#define MAC_DCU_RETRY_LIMIT__SDFL__MASK                             0x000fc000U
#define MAC_DCU_RETRY_LIMIT__SDFL__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x000fc000U) >> 14)
#define MAC_DCU_RETRY_LIMIT__SDFL__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 14) & 0x000fc000U)
#define MAC_DCU_RETRY_LIMIT__SDFL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000fc000U) | (((u_int32_t)(src) <<\
                    14) & 0x000fc000U)
#define MAC_DCU_RETRY_LIMIT__SDFL__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 14) & ~0x000fc000U)))
#define MAC_DCU_RETRY_LIMIT__TYPE                                     u_int32_t
#define MAC_DCU_RETRY_LIMIT__READ                                   0x000fff0fU
#define MAC_DCU_RETRY_LIMIT__WRITE                                  0x000fff0fU

#endif /* __MAC_DCU_RETRY_LIMIT_MACRO__ */


/* macros for mac_dcu_reg_block.MAC_DCU_RETRY_LIMIT */
#define INST_MAC_DCU_REG_BLOCK__MAC_DCU_RETRY_LIMIT__NUM                     10

/* macros for BlueprintGlobalNameSpace::MAC_DCU_GBL_IFS_EIFS */
#ifndef __MAC_DCU_GBL_IFS_EIFS_MACRO__
#define __MAC_DCU_GBL_IFS_EIFS_MACRO__

/* macros for field DURATION */
#define MAC_DCU_GBL_IFS_EIFS__DURATION__SHIFT                                 0
#define MAC_DCU_GBL_IFS_EIFS__DURATION__WIDTH                                16
#define MAC_DCU_GBL_IFS_EIFS__DURATION__MASK                        0x0000ffffU
#define MAC_DCU_GBL_IFS_EIFS__DURATION__READ(src) \
                    (u_int32_t)(src)\
                    & 0x0000ffffU
#define MAC_DCU_GBL_IFS_EIFS__DURATION__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x0000ffffU)
#define MAC_DCU_GBL_IFS_EIFS__DURATION__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000ffffU) | ((u_int32_t)(src) &\
                    0x0000ffffU)
#define MAC_DCU_GBL_IFS_EIFS__DURATION__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x0000ffffU)))
#define MAC_DCU_GBL_IFS_EIFS__TYPE                                    u_int32_t
#define MAC_DCU_GBL_IFS_EIFS__READ                                  0x0000ffffU
#define MAC_DCU_GBL_IFS_EIFS__WRITE                                 0x0000ffffU

#endif /* __MAC_DCU_GBL_IFS_EIFS_MACRO__ */


/* macros for mac_dcu_reg_block.MAC_DCU_GBL_IFS_EIFS */
#define INST_MAC_DCU_REG_BLOCK__MAC_DCU_GBL_IFS_EIFS__NUM                     1

/* macros for BlueprintGlobalNameSpace::MAC_DCU_TXFILTER_DCU0_95_64 */
#ifndef __MAC_DCU_TXFILTER_DCU0_95_64_MACRO__
#define __MAC_DCU_TXFILTER_DCU0_95_64_MACRO__

/* macros for field DATA */
#define MAC_DCU_TXFILTER_DCU0_95_64__DATA__SHIFT                              0
#define MAC_DCU_TXFILTER_DCU0_95_64__DATA__WIDTH                             32
#define MAC_DCU_TXFILTER_DCU0_95_64__DATA__MASK                     0xffffffffU
#define MAC_DCU_TXFILTER_DCU0_95_64__DATA__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define MAC_DCU_TXFILTER_DCU0_95_64__DATA__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0xffffffffU)
#define MAC_DCU_TXFILTER_DCU0_95_64__DATA__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xffffffffU) | ((u_int32_t)(src) &\
                    0xffffffffU)
#define MAC_DCU_TXFILTER_DCU0_95_64__DATA__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0xffffffffU)))
#define MAC_DCU_TXFILTER_DCU0_95_64__TYPE                             u_int32_t
#define MAC_DCU_TXFILTER_DCU0_95_64__READ                           0xffffffffU
#define MAC_DCU_TXFILTER_DCU0_95_64__WRITE                          0xffffffffU

#endif /* __MAC_DCU_TXFILTER_DCU0_95_64_MACRO__ */


/* macros for mac_dcu_reg_block.MAC_DCU_TXFILTER_DCU0_95_64 */
#define INST_MAC_DCU_REG_BLOCK__MAC_DCU_TXFILTER_DCU0_95_64__NUM              1

/* macros for BlueprintGlobalNameSpace::MAC_DCU_TXFILTER_DCU8_95_64 */
#ifndef __MAC_DCU_TXFILTER_DCU8_95_64_MACRO__
#define __MAC_DCU_TXFILTER_DCU8_95_64_MACRO__

/* macros for field DATA */
#define MAC_DCU_TXFILTER_DCU8_95_64__DATA__SHIFT                              0
#define MAC_DCU_TXFILTER_DCU8_95_64__DATA__WIDTH                             32
#define MAC_DCU_TXFILTER_DCU8_95_64__DATA__MASK                     0xffffffffU
#define MAC_DCU_TXFILTER_DCU8_95_64__DATA__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define MAC_DCU_TXFILTER_DCU8_95_64__TYPE                             u_int32_t
#define MAC_DCU_TXFILTER_DCU8_95_64__READ                           0xffffffffU

#endif /* __MAC_DCU_TXFILTER_DCU8_95_64_MACRO__ */


/* macros for mac_dcu_reg_block.MAC_DCU_TXFILTER_DCU8_95_64 */
#define INST_MAC_DCU_REG_BLOCK__MAC_DCU_TXFILTER_DCU8_95_64__NUM              1

/* macros for BlueprintGlobalNameSpace::MAC_DCU_CHANNEL_TIME */
#ifndef __MAC_DCU_CHANNEL_TIME_MACRO__
#define __MAC_DCU_CHANNEL_TIME_MACRO__

/* macros for field DURATION */
#define MAC_DCU_CHANNEL_TIME__DURATION__SHIFT                                 0
#define MAC_DCU_CHANNEL_TIME__DURATION__WIDTH                                20
#define MAC_DCU_CHANNEL_TIME__DURATION__MASK                        0x000fffffU
#define MAC_DCU_CHANNEL_TIME__DURATION__READ(src) \
                    (u_int32_t)(src)\
                    & 0x000fffffU
#define MAC_DCU_CHANNEL_TIME__DURATION__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x000fffffU)
#define MAC_DCU_CHANNEL_TIME__DURATION__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000fffffU) | ((u_int32_t)(src) &\
                    0x000fffffU)
#define MAC_DCU_CHANNEL_TIME__DURATION__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x000fffffU)))

/* macros for field ENABLE */
#define MAC_DCU_CHANNEL_TIME__ENABLE__SHIFT                                  20
#define MAC_DCU_CHANNEL_TIME__ENABLE__WIDTH                                   1
#define MAC_DCU_CHANNEL_TIME__ENABLE__MASK                          0x00100000U
#define MAC_DCU_CHANNEL_TIME__ENABLE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00100000U) >> 20)
#define MAC_DCU_CHANNEL_TIME__ENABLE__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 20) & 0x00100000U)
#define MAC_DCU_CHANNEL_TIME__ENABLE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00100000U) | (((u_int32_t)(src) <<\
                    20) & 0x00100000U)
#define MAC_DCU_CHANNEL_TIME__ENABLE__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 20) & ~0x00100000U)))
#define MAC_DCU_CHANNEL_TIME__ENABLE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00100000U) | ((u_int32_t)(1) << 20)
#define MAC_DCU_CHANNEL_TIME__ENABLE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00100000U) | ((u_int32_t)(0) << 20)
#define MAC_DCU_CHANNEL_TIME__TYPE                                    u_int32_t
#define MAC_DCU_CHANNEL_TIME__READ                                  0x001fffffU
#define MAC_DCU_CHANNEL_TIME__WRITE                                 0x001fffffU

#endif /* __MAC_DCU_CHANNEL_TIME_MACRO__ */


/* macros for mac_dcu_reg_block.MAC_DCU_CHANNEL_TIME */
#define INST_MAC_DCU_REG_BLOCK__MAC_DCU_CHANNEL_TIME__NUM                    10

/* macros for BlueprintGlobalNameSpace::MAC_DCU_GBL_IFS_MISC */
#ifndef __MAC_DCU_GBL_IFS_MISC_MACRO__
#define __MAC_DCU_GBL_IFS_MISC_MACRO__

/* macros for field LFSR_SLICE_SEL */
#define MAC_DCU_GBL_IFS_MISC__LFSR_SLICE_SEL__SHIFT                           0
#define MAC_DCU_GBL_IFS_MISC__LFSR_SLICE_SEL__WIDTH                           3
#define MAC_DCU_GBL_IFS_MISC__LFSR_SLICE_SEL__MASK                  0x00000007U
#define MAC_DCU_GBL_IFS_MISC__LFSR_SLICE_SEL__READ(src) \
                    (u_int32_t)(src)\
                    & 0x00000007U
#define MAC_DCU_GBL_IFS_MISC__LFSR_SLICE_SEL__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x00000007U)
#define MAC_DCU_GBL_IFS_MISC__LFSR_SLICE_SEL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000007U) | ((u_int32_t)(src) &\
                    0x00000007U)
#define MAC_DCU_GBL_IFS_MISC__LFSR_SLICE_SEL__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00000007U)))

/* macros for field TURBO_MODE */
#define MAC_DCU_GBL_IFS_MISC__TURBO_MODE__SHIFT                               3
#define MAC_DCU_GBL_IFS_MISC__TURBO_MODE__WIDTH                               1
#define MAC_DCU_GBL_IFS_MISC__TURBO_MODE__MASK                      0x00000008U
#define MAC_DCU_GBL_IFS_MISC__TURBO_MODE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000008U) >> 3)
#define MAC_DCU_GBL_IFS_MISC__TURBO_MODE__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 3) & 0x00000008U)
#define MAC_DCU_GBL_IFS_MISC__TURBO_MODE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000008U) | (((u_int32_t)(src) <<\
                    3) & 0x00000008U)
#define MAC_DCU_GBL_IFS_MISC__TURBO_MODE__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 3) & ~0x00000008U)))
#define MAC_DCU_GBL_IFS_MISC__TURBO_MODE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000008U) | ((u_int32_t)(1) << 3)
#define MAC_DCU_GBL_IFS_MISC__TURBO_MODE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000008U) | ((u_int32_t)(0) << 3)

/* macros for field SIFS_DUR_USEC */
#define MAC_DCU_GBL_IFS_MISC__SIFS_DUR_USEC__SHIFT                            4
#define MAC_DCU_GBL_IFS_MISC__SIFS_DUR_USEC__WIDTH                            6
#define MAC_DCU_GBL_IFS_MISC__SIFS_DUR_USEC__MASK                   0x000003f0U
#define MAC_DCU_GBL_IFS_MISC__SIFS_DUR_USEC__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x000003f0U) >> 4)
#define MAC_DCU_GBL_IFS_MISC__SIFS_DUR_USEC__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 4) & 0x000003f0U)
#define MAC_DCU_GBL_IFS_MISC__SIFS_DUR_USEC__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000003f0U) | (((u_int32_t)(src) <<\
                    4) & 0x000003f0U)
#define MAC_DCU_GBL_IFS_MISC__SIFS_DUR_USEC__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 4) & ~0x000003f0U)))

/* macros for field ARB_DLY */
#define MAC_DCU_GBL_IFS_MISC__ARB_DLY__SHIFT                                 20
#define MAC_DCU_GBL_IFS_MISC__ARB_DLY__WIDTH                                  2
#define MAC_DCU_GBL_IFS_MISC__ARB_DLY__MASK                         0x00300000U
#define MAC_DCU_GBL_IFS_MISC__ARB_DLY__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00300000U) >> 20)
#define MAC_DCU_GBL_IFS_MISC__ARB_DLY__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 20) & 0x00300000U)
#define MAC_DCU_GBL_IFS_MISC__ARB_DLY__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00300000U) | (((u_int32_t)(src) <<\
                    20) & 0x00300000U)
#define MAC_DCU_GBL_IFS_MISC__ARB_DLY__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 20) & ~0x00300000U)))

/* macros for field SIFS_RST_UNCOND */
#define MAC_DCU_GBL_IFS_MISC__SIFS_RST_UNCOND__SHIFT                         22
#define MAC_DCU_GBL_IFS_MISC__SIFS_RST_UNCOND__WIDTH                          1
#define MAC_DCU_GBL_IFS_MISC__SIFS_RST_UNCOND__MASK                 0x00400000U
#define MAC_DCU_GBL_IFS_MISC__SIFS_RST_UNCOND__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00400000U) >> 22)
#define MAC_DCU_GBL_IFS_MISC__SIFS_RST_UNCOND__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 22) & 0x00400000U)
#define MAC_DCU_GBL_IFS_MISC__SIFS_RST_UNCOND__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00400000U) | (((u_int32_t)(src) <<\
                    22) & 0x00400000U)
#define MAC_DCU_GBL_IFS_MISC__SIFS_RST_UNCOND__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 22) & ~0x00400000U)))
#define MAC_DCU_GBL_IFS_MISC__SIFS_RST_UNCOND__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00400000U) | ((u_int32_t)(1) << 22)
#define MAC_DCU_GBL_IFS_MISC__SIFS_RST_UNCOND__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00400000U) | ((u_int32_t)(0) << 22)

/* macros for field AIFS_RST_UNCOND */
#define MAC_DCU_GBL_IFS_MISC__AIFS_RST_UNCOND__SHIFT                         23
#define MAC_DCU_GBL_IFS_MISC__AIFS_RST_UNCOND__WIDTH                          1
#define MAC_DCU_GBL_IFS_MISC__AIFS_RST_UNCOND__MASK                 0x00800000U
#define MAC_DCU_GBL_IFS_MISC__AIFS_RST_UNCOND__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00800000U) >> 23)
#define MAC_DCU_GBL_IFS_MISC__AIFS_RST_UNCOND__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 23) & 0x00800000U)
#define MAC_DCU_GBL_IFS_MISC__AIFS_RST_UNCOND__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00800000U) | (((u_int32_t)(src) <<\
                    23) & 0x00800000U)
#define MAC_DCU_GBL_IFS_MISC__AIFS_RST_UNCOND__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 23) & ~0x00800000U)))
#define MAC_DCU_GBL_IFS_MISC__AIFS_RST_UNCOND__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00800000U) | ((u_int32_t)(1) << 23)
#define MAC_DCU_GBL_IFS_MISC__AIFS_RST_UNCOND__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00800000U) | ((u_int32_t)(0) << 23)

/* macros for field LFSR_SLICE_RANDOM_DIS */
#define MAC_DCU_GBL_IFS_MISC__LFSR_SLICE_RANDOM_DIS__SHIFT                   24
#define MAC_DCU_GBL_IFS_MISC__LFSR_SLICE_RANDOM_DIS__WIDTH                    1
#define MAC_DCU_GBL_IFS_MISC__LFSR_SLICE_RANDOM_DIS__MASK           0x01000000U
#define MAC_DCU_GBL_IFS_MISC__LFSR_SLICE_RANDOM_DIS__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x01000000U) >> 24)
#define MAC_DCU_GBL_IFS_MISC__LFSR_SLICE_RANDOM_DIS__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 24) & 0x01000000U)
#define MAC_DCU_GBL_IFS_MISC__LFSR_SLICE_RANDOM_DIS__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x01000000U) | (((u_int32_t)(src) <<\
                    24) & 0x01000000U)
#define MAC_DCU_GBL_IFS_MISC__LFSR_SLICE_RANDOM_DIS__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 24) & ~0x01000000U)))
#define MAC_DCU_GBL_IFS_MISC__LFSR_SLICE_RANDOM_DIS__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x01000000U) | ((u_int32_t)(1) << 24)
#define MAC_DCU_GBL_IFS_MISC__LFSR_SLICE_RANDOM_DIS__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x01000000U) | ((u_int32_t)(0) << 24)

/* macros for field CHAN_SLOT_WIN_DUR */
#define MAC_DCU_GBL_IFS_MISC__CHAN_SLOT_WIN_DUR__SHIFT                       25
#define MAC_DCU_GBL_IFS_MISC__CHAN_SLOT_WIN_DUR__WIDTH                        2
#define MAC_DCU_GBL_IFS_MISC__CHAN_SLOT_WIN_DUR__MASK               0x06000000U
#define MAC_DCU_GBL_IFS_MISC__CHAN_SLOT_WIN_DUR__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x06000000U) >> 25)
#define MAC_DCU_GBL_IFS_MISC__CHAN_SLOT_WIN_DUR__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 25) & 0x06000000U)
#define MAC_DCU_GBL_IFS_MISC__CHAN_SLOT_WIN_DUR__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x06000000U) | (((u_int32_t)(src) <<\
                    25) & 0x06000000U)
#define MAC_DCU_GBL_IFS_MISC__CHAN_SLOT_WIN_DUR__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 25) & ~0x06000000U)))

/* macros for field CHAN_SLOT_ALWAYS */
#define MAC_DCU_GBL_IFS_MISC__CHAN_SLOT_ALWAYS__SHIFT                        27
#define MAC_DCU_GBL_IFS_MISC__CHAN_SLOT_ALWAYS__WIDTH                         1
#define MAC_DCU_GBL_IFS_MISC__CHAN_SLOT_ALWAYS__MASK                0x08000000U
#define MAC_DCU_GBL_IFS_MISC__CHAN_SLOT_ALWAYS__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x08000000U) >> 27)
#define MAC_DCU_GBL_IFS_MISC__CHAN_SLOT_ALWAYS__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 27) & 0x08000000U)
#define MAC_DCU_GBL_IFS_MISC__CHAN_SLOT_ALWAYS__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x08000000U) | (((u_int32_t)(src) <<\
                    27) & 0x08000000U)
#define MAC_DCU_GBL_IFS_MISC__CHAN_SLOT_ALWAYS__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 27) & ~0x08000000U)))
#define MAC_DCU_GBL_IFS_MISC__CHAN_SLOT_ALWAYS__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x08000000U) | ((u_int32_t)(1) << 27)
#define MAC_DCU_GBL_IFS_MISC__CHAN_SLOT_ALWAYS__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x08000000U) | ((u_int32_t)(0) << 27)

/* macros for field IGNORE_BACKOFF */
#define MAC_DCU_GBL_IFS_MISC__IGNORE_BACKOFF__SHIFT                          28
#define MAC_DCU_GBL_IFS_MISC__IGNORE_BACKOFF__WIDTH                           1
#define MAC_DCU_GBL_IFS_MISC__IGNORE_BACKOFF__MASK                  0x10000000U
#define MAC_DCU_GBL_IFS_MISC__IGNORE_BACKOFF__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x10000000U) >> 28)
#define MAC_DCU_GBL_IFS_MISC__IGNORE_BACKOFF__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 28) & 0x10000000U)
#define MAC_DCU_GBL_IFS_MISC__IGNORE_BACKOFF__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x10000000U) | (((u_int32_t)(src) <<\
                    28) & 0x10000000U)
#define MAC_DCU_GBL_IFS_MISC__IGNORE_BACKOFF__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 28) & ~0x10000000U)))
#define MAC_DCU_GBL_IFS_MISC__IGNORE_BACKOFF__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x10000000U) | ((u_int32_t)(1) << 28)
#define MAC_DCU_GBL_IFS_MISC__IGNORE_BACKOFF__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x10000000U) | ((u_int32_t)(0) << 28)
#define MAC_DCU_GBL_IFS_MISC__TYPE                                    u_int32_t
#define MAC_DCU_GBL_IFS_MISC__READ                                  0x1ff003ffU
#define MAC_DCU_GBL_IFS_MISC__WRITE                                 0x1ff003ffU
/* macros for field SLOT_COUNT_RST_UNCOND */
#define MAC_DCU_GBL_IFS_MISC__SLOT_COUNT_RST_UNCOND__SHIFT                   29
#define MAC_DCU_GBL_IFS_MISC__SLOT_COUNT_RST_UNCOND__WIDTH                    1
#define MAC_DCU_GBL_IFS_MISC__SLOT_COUNT_RST_UNCOND__MASK           0x20000000U
#define MAC_DCU_GBL_IFS_MISC__SLOT_COUNT_RST_UNCOND__READ(src) \
                        (((u_int32_t)(src)\
                                              & 0x20000000U) >> 29)
#define MAC_DCU_GBL_IFS_MISC__SLOT_COUNT_RST_UNCOND__WRITE(src) \
                        (((u_int32_t)(src)\
                                              << 29) & 0x20000000U)
#define MAC_DCU_GBL_IFS_MISC__SLOT_COUNT_RST_UNCOND__MODIFY(dst, src) \
                        (dst) = ((dst) &\
                                                    ~0x20000000U) | (((u_int32_t)(src) <<\
                                                                                29) & 0x20000000U)
#define MAC_DCU_GBL_IFS_MISC__SLOT_COUNT_RST_UNCOND__VERIFY(src) \
                        (!((((u_int32_t)(src)\
                                                 << 29) & ~0x20000000U)))
#define MAC_DCU_GBL_IFS_MISC__SLOT_COUNT_RST_UNCOND__SET(dst) \
                        (dst) = ((dst) &\
                                                    ~0x20000000U) | ((u_int32_t)(1) << 29)
#define MAC_DCU_GBL_IFS_MISC__SLOT_COUNT_RST_UNCOND__CLR(dst) \
                        (dst) = ((dst) &\
                                                    ~0x20000000U) | ((u_int32_t)(0) << 29)

#endif /* __MAC_DCU_GBL_IFS_MISC_MACRO__ */


/* macros for mac_dcu_reg_block.MAC_DCU_GBL_IFS_MISC */
#define INST_MAC_DCU_REG_BLOCK__MAC_DCU_GBL_IFS_MISC__NUM                     1

/* macros for BlueprintGlobalNameSpace::MAC_DCU_TXFILTER_DCU0_127_96 */
#ifndef __MAC_DCU_TXFILTER_DCU0_127_96_MACRO__
#define __MAC_DCU_TXFILTER_DCU0_127_96_MACRO__

/* macros for field DATA */
#define MAC_DCU_TXFILTER_DCU0_127_96__DATA__SHIFT                             0
#define MAC_DCU_TXFILTER_DCU0_127_96__DATA__WIDTH                            32
#define MAC_DCU_TXFILTER_DCU0_127_96__DATA__MASK                    0xffffffffU
#define MAC_DCU_TXFILTER_DCU0_127_96__DATA__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define MAC_DCU_TXFILTER_DCU0_127_96__DATA__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0xffffffffU)
#define MAC_DCU_TXFILTER_DCU0_127_96__DATA__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xffffffffU) | ((u_int32_t)(src) &\
                    0xffffffffU)
#define MAC_DCU_TXFILTER_DCU0_127_96__DATA__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0xffffffffU)))
#define MAC_DCU_TXFILTER_DCU0_127_96__TYPE                            u_int32_t
#define MAC_DCU_TXFILTER_DCU0_127_96__READ                          0xffffffffU
#define MAC_DCU_TXFILTER_DCU0_127_96__WRITE                         0xffffffffU

#endif /* __MAC_DCU_TXFILTER_DCU0_127_96_MACRO__ */


/* macros for mac_dcu_reg_block.MAC_DCU_TXFILTER_DCU0_127_96 */
#define INST_MAC_DCU_REG_BLOCK__MAC_DCU_TXFILTER_DCU0_127_96__NUM             1

/* macros for BlueprintGlobalNameSpace::MAC_DCU_TXFILTER_DCU8_127_96 */
#ifndef __MAC_DCU_TXFILTER_DCU8_127_96_MACRO__
#define __MAC_DCU_TXFILTER_DCU8_127_96_MACRO__

/* macros for field DATA */
#define MAC_DCU_TXFILTER_DCU8_127_96__DATA__SHIFT                             0
#define MAC_DCU_TXFILTER_DCU8_127_96__DATA__WIDTH                            32
#define MAC_DCU_TXFILTER_DCU8_127_96__DATA__MASK                    0xffffffffU
#define MAC_DCU_TXFILTER_DCU8_127_96__DATA__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define MAC_DCU_TXFILTER_DCU8_127_96__TYPE                            u_int32_t
#define MAC_DCU_TXFILTER_DCU8_127_96__READ                          0xffffffffU

#endif /* __MAC_DCU_TXFILTER_DCU8_127_96_MACRO__ */


/* macros for mac_dcu_reg_block.MAC_DCU_TXFILTER_DCU8_127_96 */
#define INST_MAC_DCU_REG_BLOCK__MAC_DCU_TXFILTER_DCU8_127_96__NUM             1

/* macros for BlueprintGlobalNameSpace::MAC_DCU_MISC */
#ifndef __MAC_DCU_MISC_MACRO__
#define __MAC_DCU_MISC_MACRO__

/* macros for field BKOFF_THRESH */
#define MAC_DCU_MISC__BKOFF_THRESH__SHIFT                                     0
#define MAC_DCU_MISC__BKOFF_THRESH__WIDTH                                     6
#define MAC_DCU_MISC__BKOFF_THRESH__MASK                            0x0000003fU
#define MAC_DCU_MISC__BKOFF_THRESH__READ(src)    (u_int32_t)(src) & 0x0000003fU
#define MAC_DCU_MISC__BKOFF_THRESH__WRITE(src) ((u_int32_t)(src) & 0x0000003fU)
#define MAC_DCU_MISC__BKOFF_THRESH__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000003fU) | ((u_int32_t)(src) &\
                    0x0000003fU)
#define MAC_DCU_MISC__BKOFF_THRESH__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x0000003fU)))

/* macros for field SFC_RST_AT_TS_END_EN */
#define MAC_DCU_MISC__SFC_RST_AT_TS_END_EN__SHIFT                             6
#define MAC_DCU_MISC__SFC_RST_AT_TS_END_EN__WIDTH                             1
#define MAC_DCU_MISC__SFC_RST_AT_TS_END_EN__MASK                    0x00000040U
#define MAC_DCU_MISC__SFC_RST_AT_TS_END_EN__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000040U) >> 6)
#define MAC_DCU_MISC__SFC_RST_AT_TS_END_EN__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 6) & 0x00000040U)
#define MAC_DCU_MISC__SFC_RST_AT_TS_END_EN__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000040U) | (((u_int32_t)(src) <<\
                    6) & 0x00000040U)
#define MAC_DCU_MISC__SFC_RST_AT_TS_END_EN__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 6) & ~0x00000040U)))
#define MAC_DCU_MISC__SFC_RST_AT_TS_END_EN__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000040U) | ((u_int32_t)(1) << 6)
#define MAC_DCU_MISC__SFC_RST_AT_TS_END_EN__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000040U) | ((u_int32_t)(0) << 6)

/* macros for field CW_RST_AT_TS_END_DIS */
#define MAC_DCU_MISC__CW_RST_AT_TS_END_DIS__SHIFT                             7
#define MAC_DCU_MISC__CW_RST_AT_TS_END_DIS__WIDTH                             1
#define MAC_DCU_MISC__CW_RST_AT_TS_END_DIS__MASK                    0x00000080U
#define MAC_DCU_MISC__CW_RST_AT_TS_END_DIS__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000080U) >> 7)
#define MAC_DCU_MISC__CW_RST_AT_TS_END_DIS__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 7) & 0x00000080U)
#define MAC_DCU_MISC__CW_RST_AT_TS_END_DIS__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000080U) | (((u_int32_t)(src) <<\
                    7) & 0x00000080U)
#define MAC_DCU_MISC__CW_RST_AT_TS_END_DIS__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 7) & ~0x00000080U)))
#define MAC_DCU_MISC__CW_RST_AT_TS_END_DIS__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000080U) | ((u_int32_t)(1) << 7)
#define MAC_DCU_MISC__CW_RST_AT_TS_END_DIS__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000080U) | ((u_int32_t)(0) << 7)

/* macros for field FRAG_BURST_WAIT_QCU_EN */
#define MAC_DCU_MISC__FRAG_BURST_WAIT_QCU_EN__SHIFT                           8
#define MAC_DCU_MISC__FRAG_BURST_WAIT_QCU_EN__WIDTH                           1
#define MAC_DCU_MISC__FRAG_BURST_WAIT_QCU_EN__MASK                  0x00000100U
#define MAC_DCU_MISC__FRAG_BURST_WAIT_QCU_EN__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000100U) >> 8)
#define MAC_DCU_MISC__FRAG_BURST_WAIT_QCU_EN__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 8) & 0x00000100U)
#define MAC_DCU_MISC__FRAG_BURST_WAIT_QCU_EN__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000100U) | (((u_int32_t)(src) <<\
                    8) & 0x00000100U)
#define MAC_DCU_MISC__FRAG_BURST_WAIT_QCU_EN__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 8) & ~0x00000100U)))
#define MAC_DCU_MISC__FRAG_BURST_WAIT_QCU_EN__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000100U) | ((u_int32_t)(1) << 8)
#define MAC_DCU_MISC__FRAG_BURST_WAIT_QCU_EN__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000100U) | ((u_int32_t)(0) << 8)

/* macros for field FRAG_BURST_BKOFF_EN */
#define MAC_DCU_MISC__FRAG_BURST_BKOFF_EN__SHIFT                              9
#define MAC_DCU_MISC__FRAG_BURST_BKOFF_EN__WIDTH                              1
#define MAC_DCU_MISC__FRAG_BURST_BKOFF_EN__MASK                     0x00000200U
#define MAC_DCU_MISC__FRAG_BURST_BKOFF_EN__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000200U) >> 9)
#define MAC_DCU_MISC__FRAG_BURST_BKOFF_EN__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 9) & 0x00000200U)
#define MAC_DCU_MISC__FRAG_BURST_BKOFF_EN__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000200U) | (((u_int32_t)(src) <<\
                    9) & 0x00000200U)
#define MAC_DCU_MISC__FRAG_BURST_BKOFF_EN__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 9) & ~0x00000200U)))
#define MAC_DCU_MISC__FRAG_BURST_BKOFF_EN__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000200U) | ((u_int32_t)(1) << 9)
#define MAC_DCU_MISC__FRAG_BURST_BKOFF_EN__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000200U) | ((u_int32_t)(0) << 9)

/* macros for field HCF_POLL_EN */
#define MAC_DCU_MISC__HCF_POLL_EN__SHIFT                                     11
#define MAC_DCU_MISC__HCF_POLL_EN__WIDTH                                      1
#define MAC_DCU_MISC__HCF_POLL_EN__MASK                             0x00000800U
#define MAC_DCU_MISC__HCF_POLL_EN__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000800U) >> 11)
#define MAC_DCU_MISC__HCF_POLL_EN__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 11) & 0x00000800U)
#define MAC_DCU_MISC__HCF_POLL_EN__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000800U) | (((u_int32_t)(src) <<\
                    11) & 0x00000800U)
#define MAC_DCU_MISC__HCF_POLL_EN__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 11) & ~0x00000800U)))
#define MAC_DCU_MISC__HCF_POLL_EN__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000800U) | ((u_int32_t)(1) << 11)
#define MAC_DCU_MISC__HCF_POLL_EN__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000800U) | ((u_int32_t)(0) << 11)

/* macros for field BKOFF_PF */
#define MAC_DCU_MISC__BKOFF_PF__SHIFT                                        12
#define MAC_DCU_MISC__BKOFF_PF__WIDTH                                         1
#define MAC_DCU_MISC__BKOFF_PF__MASK                                0x00001000U
#define MAC_DCU_MISC__BKOFF_PF__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00001000U) >> 12)
#define MAC_DCU_MISC__BKOFF_PF__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 12) & 0x00001000U)
#define MAC_DCU_MISC__BKOFF_PF__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00001000U) | (((u_int32_t)(src) <<\
                    12) & 0x00001000U)
#define MAC_DCU_MISC__BKOFF_PF__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 12) & ~0x00001000U)))
#define MAC_DCU_MISC__BKOFF_PF__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00001000U) | ((u_int32_t)(1) << 12)
#define MAC_DCU_MISC__BKOFF_PF__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00001000U) | ((u_int32_t)(0) << 12)

/* macros for field VIRT_COLL_POLICY */
#define MAC_DCU_MISC__VIRT_COLL_POLICY__SHIFT                                14
#define MAC_DCU_MISC__VIRT_COLL_POLICY__WIDTH                                 2
#define MAC_DCU_MISC__VIRT_COLL_POLICY__MASK                        0x0000c000U
#define MAC_DCU_MISC__VIRT_COLL_POLICY__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0000c000U) >> 14)
#define MAC_DCU_MISC__VIRT_COLL_POLICY__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 14) & 0x0000c000U)
#define MAC_DCU_MISC__VIRT_COLL_POLICY__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000c000U) | (((u_int32_t)(src) <<\
                    14) & 0x0000c000U)
#define MAC_DCU_MISC__VIRT_COLL_POLICY__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 14) & ~0x0000c000U)))

/* macros for field IS_BCN */
#define MAC_DCU_MISC__IS_BCN__SHIFT                                          16
#define MAC_DCU_MISC__IS_BCN__WIDTH                                           1
#define MAC_DCU_MISC__IS_BCN__MASK                                  0x00010000U
#define MAC_DCU_MISC__IS_BCN__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00010000U) >> 16)
#define MAC_DCU_MISC__IS_BCN__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 16) & 0x00010000U)
#define MAC_DCU_MISC__IS_BCN__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00010000U) | (((u_int32_t)(src) <<\
                    16) & 0x00010000U)
#define MAC_DCU_MISC__IS_BCN__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 16) & ~0x00010000U)))
#define MAC_DCU_MISC__IS_BCN__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00010000U) | ((u_int32_t)(1) << 16)
#define MAC_DCU_MISC__IS_BCN__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00010000U) | ((u_int32_t)(0) << 16)

/* macros for field ARB_LOCKOUT_IF_EN */
#define MAC_DCU_MISC__ARB_LOCKOUT_IF_EN__SHIFT                               17
#define MAC_DCU_MISC__ARB_LOCKOUT_IF_EN__WIDTH                                1
#define MAC_DCU_MISC__ARB_LOCKOUT_IF_EN__MASK                       0x00020000U
#define MAC_DCU_MISC__ARB_LOCKOUT_IF_EN__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00020000U) >> 17)
#define MAC_DCU_MISC__ARB_LOCKOUT_IF_EN__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 17) & 0x00020000U)
#define MAC_DCU_MISC__ARB_LOCKOUT_IF_EN__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00020000U) | (((u_int32_t)(src) <<\
                    17) & 0x00020000U)
#define MAC_DCU_MISC__ARB_LOCKOUT_IF_EN__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 17) & ~0x00020000U)))
#define MAC_DCU_MISC__ARB_LOCKOUT_IF_EN__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00020000U) | ((u_int32_t)(1) << 17)
#define MAC_DCU_MISC__ARB_LOCKOUT_IF_EN__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00020000U) | ((u_int32_t)(0) << 17)

/* macros for field LOCKOUT_GBL_EN */
#define MAC_DCU_MISC__LOCKOUT_GBL_EN__SHIFT                                  18
#define MAC_DCU_MISC__LOCKOUT_GBL_EN__WIDTH                                   1
#define MAC_DCU_MISC__LOCKOUT_GBL_EN__MASK                          0x00040000U
#define MAC_DCU_MISC__LOCKOUT_GBL_EN__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00040000U) >> 18)
#define MAC_DCU_MISC__LOCKOUT_GBL_EN__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 18) & 0x00040000U)
#define MAC_DCU_MISC__LOCKOUT_GBL_EN__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00040000U) | (((u_int32_t)(src) <<\
                    18) & 0x00040000U)
#define MAC_DCU_MISC__LOCKOUT_GBL_EN__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 18) & ~0x00040000U)))
#define MAC_DCU_MISC__LOCKOUT_GBL_EN__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00040000U) | ((u_int32_t)(1) << 18)
#define MAC_DCU_MISC__LOCKOUT_GBL_EN__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00040000U) | ((u_int32_t)(0) << 18)

/* macros for field LOCKOUT_IGNORE */
#define MAC_DCU_MISC__LOCKOUT_IGNORE__SHIFT                                  19
#define MAC_DCU_MISC__LOCKOUT_IGNORE__WIDTH                                   1
#define MAC_DCU_MISC__LOCKOUT_IGNORE__MASK                          0x00080000U
#define MAC_DCU_MISC__LOCKOUT_IGNORE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00080000U) >> 19)
#define MAC_DCU_MISC__LOCKOUT_IGNORE__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 19) & 0x00080000U)
#define MAC_DCU_MISC__LOCKOUT_IGNORE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00080000U) | (((u_int32_t)(src) <<\
                    19) & 0x00080000U)
#define MAC_DCU_MISC__LOCKOUT_IGNORE__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 19) & ~0x00080000U)))
#define MAC_DCU_MISC__LOCKOUT_IGNORE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00080000U) | ((u_int32_t)(1) << 19)
#define MAC_DCU_MISC__LOCKOUT_IGNORE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00080000U) | ((u_int32_t)(0) << 19)

/* macros for field SEQNUM_FREEZE */
#define MAC_DCU_MISC__SEQNUM_FREEZE__SHIFT                                   20
#define MAC_DCU_MISC__SEQNUM_FREEZE__WIDTH                                    1
#define MAC_DCU_MISC__SEQNUM_FREEZE__MASK                           0x00100000U
#define MAC_DCU_MISC__SEQNUM_FREEZE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00100000U) >> 20)
#define MAC_DCU_MISC__SEQNUM_FREEZE__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 20) & 0x00100000U)
#define MAC_DCU_MISC__SEQNUM_FREEZE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00100000U) | (((u_int32_t)(src) <<\
                    20) & 0x00100000U)
#define MAC_DCU_MISC__SEQNUM_FREEZE__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 20) & ~0x00100000U)))
#define MAC_DCU_MISC__SEQNUM_FREEZE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00100000U) | ((u_int32_t)(1) << 20)
#define MAC_DCU_MISC__SEQNUM_FREEZE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00100000U) | ((u_int32_t)(0) << 20)

/* macros for field POST_BKOFF_SKIP */
#define MAC_DCU_MISC__POST_BKOFF_SKIP__SHIFT                                 21
#define MAC_DCU_MISC__POST_BKOFF_SKIP__WIDTH                                  1
#define MAC_DCU_MISC__POST_BKOFF_SKIP__MASK                         0x00200000U
#define MAC_DCU_MISC__POST_BKOFF_SKIP__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00200000U) >> 21)
#define MAC_DCU_MISC__POST_BKOFF_SKIP__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 21) & 0x00200000U)
#define MAC_DCU_MISC__POST_BKOFF_SKIP__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00200000U) | (((u_int32_t)(src) <<\
                    21) & 0x00200000U)
#define MAC_DCU_MISC__POST_BKOFF_SKIP__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 21) & ~0x00200000U)))
#define MAC_DCU_MISC__POST_BKOFF_SKIP__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00200000U) | ((u_int32_t)(1) << 21)
#define MAC_DCU_MISC__POST_BKOFF_SKIP__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00200000U) | ((u_int32_t)(0) << 21)

/* macros for field VIRT_COLL_CW_INC_EN */
#define MAC_DCU_MISC__VIRT_COLL_CW_INC_EN__SHIFT                             22
#define MAC_DCU_MISC__VIRT_COLL_CW_INC_EN__WIDTH                              1
#define MAC_DCU_MISC__VIRT_COLL_CW_INC_EN__MASK                     0x00400000U
#define MAC_DCU_MISC__VIRT_COLL_CW_INC_EN__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00400000U) >> 22)
#define MAC_DCU_MISC__VIRT_COLL_CW_INC_EN__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 22) & 0x00400000U)
#define MAC_DCU_MISC__VIRT_COLL_CW_INC_EN__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00400000U) | (((u_int32_t)(src) <<\
                    22) & 0x00400000U)
#define MAC_DCU_MISC__VIRT_COLL_CW_INC_EN__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 22) & ~0x00400000U)))
#define MAC_DCU_MISC__VIRT_COLL_CW_INC_EN__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00400000U) | ((u_int32_t)(1) << 22)
#define MAC_DCU_MISC__VIRT_COLL_CW_INC_EN__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00400000U) | ((u_int32_t)(0) << 22)

/* macros for field RETRY_ON_BLOWN_IFS_EN */
#define MAC_DCU_MISC__RETRY_ON_BLOWN_IFS_EN__SHIFT                           23
#define MAC_DCU_MISC__RETRY_ON_BLOWN_IFS_EN__WIDTH                            1
#define MAC_DCU_MISC__RETRY_ON_BLOWN_IFS_EN__MASK                   0x00800000U
#define MAC_DCU_MISC__RETRY_ON_BLOWN_IFS_EN__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00800000U) >> 23)
#define MAC_DCU_MISC__RETRY_ON_BLOWN_IFS_EN__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 23) & 0x00800000U)
#define MAC_DCU_MISC__RETRY_ON_BLOWN_IFS_EN__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00800000U) | (((u_int32_t)(src) <<\
                    23) & 0x00800000U)
#define MAC_DCU_MISC__RETRY_ON_BLOWN_IFS_EN__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 23) & ~0x00800000U)))
#define MAC_DCU_MISC__RETRY_ON_BLOWN_IFS_EN__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00800000U) | ((u_int32_t)(1) << 23)
#define MAC_DCU_MISC__RETRY_ON_BLOWN_IFS_EN__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00800000U) | ((u_int32_t)(0) << 23)

/* macros for field SIFS_BURST_CHAN_BUSY_IGNORE */
#define MAC_DCU_MISC__SIFS_BURST_CHAN_BUSY_IGNORE__SHIFT                     24
#define MAC_DCU_MISC__SIFS_BURST_CHAN_BUSY_IGNORE__WIDTH                      1
#define MAC_DCU_MISC__SIFS_BURST_CHAN_BUSY_IGNORE__MASK             0x01000000U
#define MAC_DCU_MISC__SIFS_BURST_CHAN_BUSY_IGNORE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x01000000U) >> 24)
#define MAC_DCU_MISC__SIFS_BURST_CHAN_BUSY_IGNORE__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 24) & 0x01000000U)
#define MAC_DCU_MISC__SIFS_BURST_CHAN_BUSY_IGNORE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x01000000U) | (((u_int32_t)(src) <<\
                    24) & 0x01000000U)
#define MAC_DCU_MISC__SIFS_BURST_CHAN_BUSY_IGNORE__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 24) & ~0x01000000U)))
#define MAC_DCU_MISC__SIFS_BURST_CHAN_BUSY_IGNORE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x01000000U) | ((u_int32_t)(1) << 24)
#define MAC_DCU_MISC__SIFS_BURST_CHAN_BUSY_IGNORE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x01000000U) | ((u_int32_t)(0) << 24)
#define MAC_DCU_MISC__TYPE                                            u_int32_t
#define MAC_DCU_MISC__READ                                          0x01ffdbffU
#define MAC_DCU_MISC__WRITE                                         0x01ffdbffU

#endif /* __MAC_DCU_MISC_MACRO__ */


/* macros for mac_dcu_reg_block.MAC_DCU_MISC */
#define INST_MAC_DCU_REG_BLOCK__MAC_DCU_MISC__NUM                            10

/* macros for BlueprintGlobalNameSpace::MAC_DCU_TXFILTER_DCU1_31_0 */
#ifndef __MAC_DCU_TXFILTER_DCU1_31_0_MACRO__
#define __MAC_DCU_TXFILTER_DCU1_31_0_MACRO__

/* macros for field DATA */
#define MAC_DCU_TXFILTER_DCU1_31_0__DATA__SHIFT                               0
#define MAC_DCU_TXFILTER_DCU1_31_0__DATA__WIDTH                              32
#define MAC_DCU_TXFILTER_DCU1_31_0__DATA__MASK                      0xffffffffU
#define MAC_DCU_TXFILTER_DCU1_31_0__DATA__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define MAC_DCU_TXFILTER_DCU1_31_0__TYPE                              u_int32_t
#define MAC_DCU_TXFILTER_DCU1_31_0__READ                            0xffffffffU

#endif /* __MAC_DCU_TXFILTER_DCU1_31_0_MACRO__ */


/* macros for mac_dcu_reg_block.MAC_DCU_TXFILTER_DCU1_31_0 */
#define INST_MAC_DCU_REG_BLOCK__MAC_DCU_TXFILTER_DCU1_31_0__NUM               1

/* macros for BlueprintGlobalNameSpace::MAC_DCU_TXFILTER_DCU9_31_0 */
#ifndef __MAC_DCU_TXFILTER_DCU9_31_0_MACRO__
#define __MAC_DCU_TXFILTER_DCU9_31_0_MACRO__

/* macros for field DATA */
#define MAC_DCU_TXFILTER_DCU9_31_0__DATA__SHIFT                               0
#define MAC_DCU_TXFILTER_DCU9_31_0__DATA__WIDTH                              32
#define MAC_DCU_TXFILTER_DCU9_31_0__DATA__MASK                      0xffffffffU
#define MAC_DCU_TXFILTER_DCU9_31_0__DATA__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define MAC_DCU_TXFILTER_DCU9_31_0__TYPE                              u_int32_t
#define MAC_DCU_TXFILTER_DCU9_31_0__READ                            0xffffffffU

#endif /* __MAC_DCU_TXFILTER_DCU9_31_0_MACRO__ */


/* macros for mac_dcu_reg_block.MAC_DCU_TXFILTER_DCU9_31_0 */
#define INST_MAC_DCU_REG_BLOCK__MAC_DCU_TXFILTER_DCU9_31_0__NUM               1

/* macros for BlueprintGlobalNameSpace::MAC_DCU_SEQ */
#ifndef __MAC_DCU_SEQ_MACRO__
#define __MAC_DCU_SEQ_MACRO__

/* macros for field NUM */
#define MAC_DCU_SEQ__NUM__SHIFT                                               0
#define MAC_DCU_SEQ__NUM__WIDTH                                              32
#define MAC_DCU_SEQ__NUM__MASK                                      0xffffffffU
#define MAC_DCU_SEQ__NUM__READ(src)              (u_int32_t)(src) & 0xffffffffU
#define MAC_DCU_SEQ__NUM__WRITE(src)           ((u_int32_t)(src) & 0xffffffffU)
#define MAC_DCU_SEQ__NUM__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xffffffffU) | ((u_int32_t)(src) &\
                    0xffffffffU)
#define MAC_DCU_SEQ__NUM__VERIFY(src)    (!(((u_int32_t)(src) & ~0xffffffffU)))
#define MAC_DCU_SEQ__TYPE                                             u_int32_t
#define MAC_DCU_SEQ__READ                                           0xffffffffU
#define MAC_DCU_SEQ__WRITE                                          0xffffffffU

#endif /* __MAC_DCU_SEQ_MACRO__ */


/* macros for mac_dcu_reg_block.MAC_DCU_SEQ */
#define INST_MAC_DCU_REG_BLOCK__MAC_DCU_SEQ__NUM                              1

/* macros for BlueprintGlobalNameSpace::MAC_DCU_TXFILTER_DCU1_63_32 */
#ifndef __MAC_DCU_TXFILTER_DCU1_63_32_MACRO__
#define __MAC_DCU_TXFILTER_DCU1_63_32_MACRO__

/* macros for field DATA */
#define MAC_DCU_TXFILTER_DCU1_63_32__DATA__SHIFT                              0
#define MAC_DCU_TXFILTER_DCU1_63_32__DATA__WIDTH                             32
#define MAC_DCU_TXFILTER_DCU1_63_32__DATA__MASK                     0xffffffffU
#define MAC_DCU_TXFILTER_DCU1_63_32__DATA__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define MAC_DCU_TXFILTER_DCU1_63_32__TYPE                             u_int32_t
#define MAC_DCU_TXFILTER_DCU1_63_32__READ                           0xffffffffU

#endif /* __MAC_DCU_TXFILTER_DCU1_63_32_MACRO__ */


/* macros for mac_dcu_reg_block.MAC_DCU_TXFILTER_DCU1_63_32 */
#define INST_MAC_DCU_REG_BLOCK__MAC_DCU_TXFILTER_DCU1_63_32__NUM              1

/* macros for BlueprintGlobalNameSpace::MAC_DCU_TXFILTER_DCU9_63_32 */
#ifndef __MAC_DCU_TXFILTER_DCU9_63_32_MACRO__
#define __MAC_DCU_TXFILTER_DCU9_63_32_MACRO__

/* macros for field DATA */
#define MAC_DCU_TXFILTER_DCU9_63_32__DATA__SHIFT                              0
#define MAC_DCU_TXFILTER_DCU9_63_32__DATA__WIDTH                             32
#define MAC_DCU_TXFILTER_DCU9_63_32__DATA__MASK                     0xffffffffU
#define MAC_DCU_TXFILTER_DCU9_63_32__DATA__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define MAC_DCU_TXFILTER_DCU9_63_32__TYPE                             u_int32_t
#define MAC_DCU_TXFILTER_DCU9_63_32__READ                           0xffffffffU

#endif /* __MAC_DCU_TXFILTER_DCU9_63_32_MACRO__ */


/* macros for mac_dcu_reg_block.MAC_DCU_TXFILTER_DCU9_63_32 */
#define INST_MAC_DCU_REG_BLOCK__MAC_DCU_TXFILTER_DCU9_63_32__NUM              1

/* macros for BlueprintGlobalNameSpace::MAC_DCU_TXFILTER_DCU1_95_64 */
#ifndef __MAC_DCU_TXFILTER_DCU1_95_64_MACRO__
#define __MAC_DCU_TXFILTER_DCU1_95_64_MACRO__

/* macros for field DATA */
#define MAC_DCU_TXFILTER_DCU1_95_64__DATA__SHIFT                              0
#define MAC_DCU_TXFILTER_DCU1_95_64__DATA__WIDTH                             32
#define MAC_DCU_TXFILTER_DCU1_95_64__DATA__MASK                     0xffffffffU
#define MAC_DCU_TXFILTER_DCU1_95_64__DATA__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define MAC_DCU_TXFILTER_DCU1_95_64__TYPE                             u_int32_t
#define MAC_DCU_TXFILTER_DCU1_95_64__READ                           0xffffffffU

#endif /* __MAC_DCU_TXFILTER_DCU1_95_64_MACRO__ */


/* macros for mac_dcu_reg_block.MAC_DCU_TXFILTER_DCU1_95_64 */
#define INST_MAC_DCU_REG_BLOCK__MAC_DCU_TXFILTER_DCU1_95_64__NUM              1

/* macros for BlueprintGlobalNameSpace::MAC_DCU_TXFILTER_DCU9_95_64 */
#ifndef __MAC_DCU_TXFILTER_DCU9_95_64_MACRO__
#define __MAC_DCU_TXFILTER_DCU9_95_64_MACRO__

/* macros for field DATA */
#define MAC_DCU_TXFILTER_DCU9_95_64__DATA__SHIFT                              0
#define MAC_DCU_TXFILTER_DCU9_95_64__DATA__WIDTH                             32
#define MAC_DCU_TXFILTER_DCU9_95_64__DATA__MASK                     0xffffffffU
#define MAC_DCU_TXFILTER_DCU9_95_64__DATA__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define MAC_DCU_TXFILTER_DCU9_95_64__TYPE                             u_int32_t
#define MAC_DCU_TXFILTER_DCU9_95_64__READ                           0xffffffffU

#endif /* __MAC_DCU_TXFILTER_DCU9_95_64_MACRO__ */


/* macros for mac_dcu_reg_block.MAC_DCU_TXFILTER_DCU9_95_64 */
#define INST_MAC_DCU_REG_BLOCK__MAC_DCU_TXFILTER_DCU9_95_64__NUM              1

/* macros for BlueprintGlobalNameSpace::MAC_DCU_TXFILTER_DCU1_127_96 */
#ifndef __MAC_DCU_TXFILTER_DCU1_127_96_MACRO__
#define __MAC_DCU_TXFILTER_DCU1_127_96_MACRO__

/* macros for field DATA */
#define MAC_DCU_TXFILTER_DCU1_127_96__DATA__SHIFT                             0
#define MAC_DCU_TXFILTER_DCU1_127_96__DATA__WIDTH                            32
#define MAC_DCU_TXFILTER_DCU1_127_96__DATA__MASK                    0xffffffffU
#define MAC_DCU_TXFILTER_DCU1_127_96__DATA__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define MAC_DCU_TXFILTER_DCU1_127_96__TYPE                            u_int32_t
#define MAC_DCU_TXFILTER_DCU1_127_96__READ                          0xffffffffU

#endif /* __MAC_DCU_TXFILTER_DCU1_127_96_MACRO__ */


/* macros for mac_dcu_reg_block.MAC_DCU_TXFILTER_DCU1_127_96 */
#define INST_MAC_DCU_REG_BLOCK__MAC_DCU_TXFILTER_DCU1_127_96__NUM             1

/* macros for BlueprintGlobalNameSpace::MAC_DCU_TXFILTER_DCU9_127_96 */
#ifndef __MAC_DCU_TXFILTER_DCU9_127_96_MACRO__
#define __MAC_DCU_TXFILTER_DCU9_127_96_MACRO__

/* macros for field DATA */
#define MAC_DCU_TXFILTER_DCU9_127_96__DATA__SHIFT                             0
#define MAC_DCU_TXFILTER_DCU9_127_96__DATA__WIDTH                            32
#define MAC_DCU_TXFILTER_DCU9_127_96__DATA__MASK                    0xffffffffU
#define MAC_DCU_TXFILTER_DCU9_127_96__DATA__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define MAC_DCU_TXFILTER_DCU9_127_96__TYPE                            u_int32_t
#define MAC_DCU_TXFILTER_DCU9_127_96__READ                          0xffffffffU

#endif /* __MAC_DCU_TXFILTER_DCU9_127_96_MACRO__ */


/* macros for mac_dcu_reg_block.MAC_DCU_TXFILTER_DCU9_127_96 */
#define INST_MAC_DCU_REG_BLOCK__MAC_DCU_TXFILTER_DCU9_127_96__NUM             1

/* macros for BlueprintGlobalNameSpace::MAC_DCU_TXFILTER_DCU2_31_0 */
#ifndef __MAC_DCU_TXFILTER_DCU2_31_0_MACRO__
#define __MAC_DCU_TXFILTER_DCU2_31_0_MACRO__

/* macros for field DATA */
#define MAC_DCU_TXFILTER_DCU2_31_0__DATA__SHIFT                               0
#define MAC_DCU_TXFILTER_DCU2_31_0__DATA__WIDTH                              32
#define MAC_DCU_TXFILTER_DCU2_31_0__DATA__MASK                      0xffffffffU
#define MAC_DCU_TXFILTER_DCU2_31_0__DATA__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define MAC_DCU_TXFILTER_DCU2_31_0__TYPE                              u_int32_t
#define MAC_DCU_TXFILTER_DCU2_31_0__READ                            0xffffffffU

#endif /* __MAC_DCU_TXFILTER_DCU2_31_0_MACRO__ */


/* macros for mac_dcu_reg_block.MAC_DCU_TXFILTER_DCU2_31_0 */
#define INST_MAC_DCU_REG_BLOCK__MAC_DCU_TXFILTER_DCU2_31_0__NUM               1

/* macros for BlueprintGlobalNameSpace::MAC_DCU_PAUSE */
#ifndef __MAC_DCU_PAUSE_MACRO__
#define __MAC_DCU_PAUSE_MACRO__

/* macros for field REQUEST */
#define MAC_DCU_PAUSE__REQUEST__SHIFT                                         0
#define MAC_DCU_PAUSE__REQUEST__WIDTH                                        10
#define MAC_DCU_PAUSE__REQUEST__MASK                                0x000003ffU
#define MAC_DCU_PAUSE__REQUEST__READ(src)        (u_int32_t)(src) & 0x000003ffU
#define MAC_DCU_PAUSE__REQUEST__WRITE(src)     ((u_int32_t)(src) & 0x000003ffU)
#define MAC_DCU_PAUSE__REQUEST__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000003ffU) | ((u_int32_t)(src) &\
                    0x000003ffU)
#define MAC_DCU_PAUSE__REQUEST__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x000003ffU)))

/* macros for field STATUS */
#define MAC_DCU_PAUSE__STATUS__SHIFT                                         16
#define MAC_DCU_PAUSE__STATUS__WIDTH                                          1
#define MAC_DCU_PAUSE__STATUS__MASK                                 0x00010000U
#define MAC_DCU_PAUSE__STATUS__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00010000U) >> 16)
#define MAC_DCU_PAUSE__STATUS__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00010000U) | ((u_int32_t)(1) << 16)
#define MAC_DCU_PAUSE__STATUS__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00010000U) | ((u_int32_t)(0) << 16)
#define MAC_DCU_PAUSE__TYPE                                           u_int32_t
#define MAC_DCU_PAUSE__READ                                         0x000103ffU
#define MAC_DCU_PAUSE__WRITE                                        0x000103ffU

#endif /* __MAC_DCU_PAUSE_MACRO__ */


/* macros for mac_dcu_reg_block.MAC_DCU_PAUSE */
#define INST_MAC_DCU_REG_BLOCK__MAC_DCU_PAUSE__NUM                            1

/* macros for BlueprintGlobalNameSpace::MAC_DCU_TXFILTER_DCU2_63_32 */
#ifndef __MAC_DCU_TXFILTER_DCU2_63_32_MACRO__
#define __MAC_DCU_TXFILTER_DCU2_63_32_MACRO__

/* macros for field DATA */
#define MAC_DCU_TXFILTER_DCU2_63_32__DATA__SHIFT                              0
#define MAC_DCU_TXFILTER_DCU2_63_32__DATA__WIDTH                             32
#define MAC_DCU_TXFILTER_DCU2_63_32__DATA__MASK                     0xffffffffU
#define MAC_DCU_TXFILTER_DCU2_63_32__DATA__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define MAC_DCU_TXFILTER_DCU2_63_32__TYPE                             u_int32_t
#define MAC_DCU_TXFILTER_DCU2_63_32__READ                           0xffffffffU

#endif /* __MAC_DCU_TXFILTER_DCU2_63_32_MACRO__ */


/* macros for mac_dcu_reg_block.MAC_DCU_TXFILTER_DCU2_63_32 */
#define INST_MAC_DCU_REG_BLOCK__MAC_DCU_TXFILTER_DCU2_63_32__NUM              1

/* macros for BlueprintGlobalNameSpace::MAC_DCU_WOW_KACFG */
#ifndef __MAC_DCU_WOW_KACFG_MACRO__
#define __MAC_DCU_WOW_KACFG_MACRO__

/* macros for field TX_EN */
#define MAC_DCU_WOW_KACFG__TX_EN__SHIFT                                       0
#define MAC_DCU_WOW_KACFG__TX_EN__WIDTH                                       1
#define MAC_DCU_WOW_KACFG__TX_EN__MASK                              0x00000001U
#define MAC_DCU_WOW_KACFG__TX_EN__READ(src)      (u_int32_t)(src) & 0x00000001U
#define MAC_DCU_WOW_KACFG__TX_EN__WRITE(src)   ((u_int32_t)(src) & 0x00000001U)
#define MAC_DCU_WOW_KACFG__TX_EN__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | ((u_int32_t)(src) &\
                    0x00000001U)
#define MAC_DCU_WOW_KACFG__TX_EN__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00000001U)))
#define MAC_DCU_WOW_KACFG__TX_EN__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(1)
#define MAC_DCU_WOW_KACFG__TX_EN__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(0)

/* macros for field TIM_EN */
#define MAC_DCU_WOW_KACFG__TIM_EN__SHIFT                                      1
#define MAC_DCU_WOW_KACFG__TIM_EN__WIDTH                                      1
#define MAC_DCU_WOW_KACFG__TIM_EN__MASK                             0x00000002U
#define MAC_DCU_WOW_KACFG__TIM_EN__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000002U) >> 1)
#define MAC_DCU_WOW_KACFG__TIM_EN__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 1) & 0x00000002U)
#define MAC_DCU_WOW_KACFG__TIM_EN__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | (((u_int32_t)(src) <<\
                    1) & 0x00000002U)
#define MAC_DCU_WOW_KACFG__TIM_EN__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 1) & ~0x00000002U)))
#define MAC_DCU_WOW_KACFG__TIM_EN__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | ((u_int32_t)(1) << 1)
#define MAC_DCU_WOW_KACFG__TIM_EN__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | ((u_int32_t)(0) << 1)

/* macros for field BCN_CNT */
#define MAC_DCU_WOW_KACFG__BCN_CNT__SHIFT                                     4
#define MAC_DCU_WOW_KACFG__BCN_CNT__WIDTH                                     8
#define MAC_DCU_WOW_KACFG__BCN_CNT__MASK                            0x00000ff0U
#define MAC_DCU_WOW_KACFG__BCN_CNT__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000ff0U) >> 4)
#define MAC_DCU_WOW_KACFG__BCN_CNT__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 4) & 0x00000ff0U)
#define MAC_DCU_WOW_KACFG__BCN_CNT__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000ff0U) | (((u_int32_t)(src) <<\
                    4) & 0x00000ff0U)
#define MAC_DCU_WOW_KACFG__BCN_CNT__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 4) & ~0x00000ff0U)))

/* macros for field RX_TIMEOUT_CNT */
#define MAC_DCU_WOW_KACFG__RX_TIMEOUT_CNT__SHIFT                             12
#define MAC_DCU_WOW_KACFG__RX_TIMEOUT_CNT__WIDTH                             12
#define MAC_DCU_WOW_KACFG__RX_TIMEOUT_CNT__MASK                     0x00fff000U
#define MAC_DCU_WOW_KACFG__RX_TIMEOUT_CNT__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00fff000U) >> 12)
#define MAC_DCU_WOW_KACFG__RX_TIMEOUT_CNT__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 12) & 0x00fff000U)
#define MAC_DCU_WOW_KACFG__RX_TIMEOUT_CNT__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00fff000U) | (((u_int32_t)(src) <<\
                    12) & 0x00fff000U)
#define MAC_DCU_WOW_KACFG__RX_TIMEOUT_CNT__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 12) & ~0x00fff000U)))
#define MAC_DCU_WOW_KACFG__TYPE                                       u_int32_t
#define MAC_DCU_WOW_KACFG__READ                                     0x00fffff3U
#define MAC_DCU_WOW_KACFG__WRITE                                    0x00fffff3U

#endif /* __MAC_DCU_WOW_KACFG_MACRO__ */


/* macros for mac_dcu_reg_block.MAC_DCU_WOW_KACFG */
#define INST_MAC_DCU_REG_BLOCK__MAC_DCU_WOW_KACFG__NUM                        1

/* macros for BlueprintGlobalNameSpace::MAC_DCU_TXFILTER_DCU2_95_64 */
#ifndef __MAC_DCU_TXFILTER_DCU2_95_64_MACRO__
#define __MAC_DCU_TXFILTER_DCU2_95_64_MACRO__

/* macros for field DATA */
#define MAC_DCU_TXFILTER_DCU2_95_64__DATA__SHIFT                              0
#define MAC_DCU_TXFILTER_DCU2_95_64__DATA__WIDTH                             32
#define MAC_DCU_TXFILTER_DCU2_95_64__DATA__MASK                     0xffffffffU
#define MAC_DCU_TXFILTER_DCU2_95_64__DATA__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define MAC_DCU_TXFILTER_DCU2_95_64__TYPE                             u_int32_t
#define MAC_DCU_TXFILTER_DCU2_95_64__READ                           0xffffffffU

#endif /* __MAC_DCU_TXFILTER_DCU2_95_64_MACRO__ */


/* macros for mac_dcu_reg_block.MAC_DCU_TXFILTER_DCU2_95_64 */
#define INST_MAC_DCU_REG_BLOCK__MAC_DCU_TXFILTER_DCU2_95_64__NUM              1

/* macros for BlueprintGlobalNameSpace::MAC_DCU_TXSLOT */
#ifndef __MAC_DCU_TXSLOT_MACRO__
#define __MAC_DCU_TXSLOT_MACRO__

/* macros for field MASK */
#define MAC_DCU_TXSLOT__MASK__SHIFT                                           0
#define MAC_DCU_TXSLOT__MASK__WIDTH                                          16
#define MAC_DCU_TXSLOT__MASK__MASK                                  0x0000ffffU
#define MAC_DCU_TXSLOT__MASK__READ(src)          (u_int32_t)(src) & 0x0000ffffU
#define MAC_DCU_TXSLOT__MASK__WRITE(src)       ((u_int32_t)(src) & 0x0000ffffU)
#define MAC_DCU_TXSLOT__MASK__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000ffffU) | ((u_int32_t)(src) &\
                    0x0000ffffU)
#define MAC_DCU_TXSLOT__MASK__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x0000ffffU)))
#define MAC_DCU_TXSLOT__TYPE                                          u_int32_t
#define MAC_DCU_TXSLOT__READ                                        0x0000ffffU
#define MAC_DCU_TXSLOT__WRITE                                       0x0000ffffU

#endif /* __MAC_DCU_TXSLOT_MACRO__ */


/* macros for mac_dcu_reg_block.MAC_DCU_TXSLOT */
#define INST_MAC_DCU_REG_BLOCK__MAC_DCU_TXSLOT__NUM                           1

/* macros for BlueprintGlobalNameSpace::MAC_DCU_TXFILTER_DCU2_127_96 */
#ifndef __MAC_DCU_TXFILTER_DCU2_127_96_MACRO__
#define __MAC_DCU_TXFILTER_DCU2_127_96_MACRO__

/* macros for field DATA */
#define MAC_DCU_TXFILTER_DCU2_127_96__DATA__SHIFT                             0
#define MAC_DCU_TXFILTER_DCU2_127_96__DATA__WIDTH                            32
#define MAC_DCU_TXFILTER_DCU2_127_96__DATA__MASK                    0xffffffffU
#define MAC_DCU_TXFILTER_DCU2_127_96__DATA__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define MAC_DCU_TXFILTER_DCU2_127_96__TYPE                            u_int32_t
#define MAC_DCU_TXFILTER_DCU2_127_96__READ                          0xffffffffU

#endif /* __MAC_DCU_TXFILTER_DCU2_127_96_MACRO__ */


/* macros for mac_dcu_reg_block.MAC_DCU_TXFILTER_DCU2_127_96 */
#define INST_MAC_DCU_REG_BLOCK__MAC_DCU_TXFILTER_DCU2_127_96__NUM             1

/* macros for BlueprintGlobalNameSpace::MAC_DCU_TXFILTER_DCU3_31_0 */
#ifndef __MAC_DCU_TXFILTER_DCU3_31_0_MACRO__
#define __MAC_DCU_TXFILTER_DCU3_31_0_MACRO__

/* macros for field DATA */
#define MAC_DCU_TXFILTER_DCU3_31_0__DATA__SHIFT                               0
#define MAC_DCU_TXFILTER_DCU3_31_0__DATA__WIDTH                              32
#define MAC_DCU_TXFILTER_DCU3_31_0__DATA__MASK                      0xffffffffU
#define MAC_DCU_TXFILTER_DCU3_31_0__DATA__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define MAC_DCU_TXFILTER_DCU3_31_0__TYPE                              u_int32_t
#define MAC_DCU_TXFILTER_DCU3_31_0__READ                            0xffffffffU

#endif /* __MAC_DCU_TXFILTER_DCU3_31_0_MACRO__ */


/* macros for mac_dcu_reg_block.MAC_DCU_TXFILTER_DCU3_31_0 */
#define INST_MAC_DCU_REG_BLOCK__MAC_DCU_TXFILTER_DCU3_31_0__NUM               1

/* macros for BlueprintGlobalNameSpace::MAC_DCU_TXFILTER_DCU3_63_32 */
#ifndef __MAC_DCU_TXFILTER_DCU3_63_32_MACRO__
#define __MAC_DCU_TXFILTER_DCU3_63_32_MACRO__

/* macros for field DATA */
#define MAC_DCU_TXFILTER_DCU3_63_32__DATA__SHIFT                              0
#define MAC_DCU_TXFILTER_DCU3_63_32__DATA__WIDTH                             32
#define MAC_DCU_TXFILTER_DCU3_63_32__DATA__MASK                     0xffffffffU
#define MAC_DCU_TXFILTER_DCU3_63_32__DATA__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define MAC_DCU_TXFILTER_DCU3_63_32__TYPE                             u_int32_t
#define MAC_DCU_TXFILTER_DCU3_63_32__READ                           0xffffffffU

#endif /* __MAC_DCU_TXFILTER_DCU3_63_32_MACRO__ */


/* macros for mac_dcu_reg_block.MAC_DCU_TXFILTER_DCU3_63_32 */
#define INST_MAC_DCU_REG_BLOCK__MAC_DCU_TXFILTER_DCU3_63_32__NUM              1

/* macros for BlueprintGlobalNameSpace::MAC_DCU_TXFILTER_DCU3_95_64 */
#ifndef __MAC_DCU_TXFILTER_DCU3_95_64_MACRO__
#define __MAC_DCU_TXFILTER_DCU3_95_64_MACRO__

/* macros for field DATA */
#define MAC_DCU_TXFILTER_DCU3_95_64__DATA__SHIFT                              0
#define MAC_DCU_TXFILTER_DCU3_95_64__DATA__WIDTH                             32
#define MAC_DCU_TXFILTER_DCU3_95_64__DATA__MASK                     0xffffffffU
#define MAC_DCU_TXFILTER_DCU3_95_64__DATA__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define MAC_DCU_TXFILTER_DCU3_95_64__TYPE                             u_int32_t
#define MAC_DCU_TXFILTER_DCU3_95_64__READ                           0xffffffffU

#endif /* __MAC_DCU_TXFILTER_DCU3_95_64_MACRO__ */


/* macros for mac_dcu_reg_block.MAC_DCU_TXFILTER_DCU3_95_64 */
#define INST_MAC_DCU_REG_BLOCK__MAC_DCU_TXFILTER_DCU3_95_64__NUM              1

/* macros for BlueprintGlobalNameSpace::MAC_DCU_TXFILTER_DCU3_127_96 */
#ifndef __MAC_DCU_TXFILTER_DCU3_127_96_MACRO__
#define __MAC_DCU_TXFILTER_DCU3_127_96_MACRO__

/* macros for field DATA */
#define MAC_DCU_TXFILTER_DCU3_127_96__DATA__SHIFT                             0
#define MAC_DCU_TXFILTER_DCU3_127_96__DATA__WIDTH                            32
#define MAC_DCU_TXFILTER_DCU3_127_96__DATA__MASK                    0xffffffffU
#define MAC_DCU_TXFILTER_DCU3_127_96__DATA__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define MAC_DCU_TXFILTER_DCU3_127_96__TYPE                            u_int32_t
#define MAC_DCU_TXFILTER_DCU3_127_96__READ                          0xffffffffU

#endif /* __MAC_DCU_TXFILTER_DCU3_127_96_MACRO__ */


/* macros for mac_dcu_reg_block.MAC_DCU_TXFILTER_DCU3_127_96 */
#define INST_MAC_DCU_REG_BLOCK__MAC_DCU_TXFILTER_DCU3_127_96__NUM             1

/* macros for BlueprintGlobalNameSpace::MAC_DCU_TXFILTER_DCU4_31_0 */
#ifndef __MAC_DCU_TXFILTER_DCU4_31_0_MACRO__
#define __MAC_DCU_TXFILTER_DCU4_31_0_MACRO__

/* macros for field DATA */
#define MAC_DCU_TXFILTER_DCU4_31_0__DATA__SHIFT                               0
#define MAC_DCU_TXFILTER_DCU4_31_0__DATA__WIDTH                              32
#define MAC_DCU_TXFILTER_DCU4_31_0__DATA__MASK                      0xffffffffU
#define MAC_DCU_TXFILTER_DCU4_31_0__DATA__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define MAC_DCU_TXFILTER_DCU4_31_0__TYPE                              u_int32_t
#define MAC_DCU_TXFILTER_DCU4_31_0__READ                            0xffffffffU

#endif /* __MAC_DCU_TXFILTER_DCU4_31_0_MACRO__ */


/* macros for mac_dcu_reg_block.MAC_DCU_TXFILTER_DCU4_31_0 */
#define INST_MAC_DCU_REG_BLOCK__MAC_DCU_TXFILTER_DCU4_31_0__NUM               1

/* macros for BlueprintGlobalNameSpace::MAC_DCU_TXFILTER_CLEAR */
#ifndef __MAC_DCU_TXFILTER_CLEAR_MACRO__
#define __MAC_DCU_TXFILTER_CLEAR_MACRO__

/* macros for field DATA */
#define MAC_DCU_TXFILTER_CLEAR__DATA__SHIFT                                   0
#define MAC_DCU_TXFILTER_CLEAR__DATA__WIDTH                                  32
#define MAC_DCU_TXFILTER_CLEAR__DATA__MASK                          0xffffffffU
#define MAC_DCU_TXFILTER_CLEAR__DATA__READ(src)  (u_int32_t)(src) & 0xffffffffU
#define MAC_DCU_TXFILTER_CLEAR__DATA__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0xffffffffU)
#define MAC_DCU_TXFILTER_CLEAR__DATA__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xffffffffU) | ((u_int32_t)(src) &\
                    0xffffffffU)
#define MAC_DCU_TXFILTER_CLEAR__DATA__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0xffffffffU)))
#define MAC_DCU_TXFILTER_CLEAR__TYPE                                  u_int32_t
#define MAC_DCU_TXFILTER_CLEAR__READ                                0xffffffffU
#define MAC_DCU_TXFILTER_CLEAR__WRITE                               0xffffffffU

#endif /* __MAC_DCU_TXFILTER_CLEAR_MACRO__ */


/* macros for mac_dcu_reg_block.MAC_DCU_TXFILTER_CLEAR */
#define INST_MAC_DCU_REG_BLOCK__MAC_DCU_TXFILTER_CLEAR__NUM                   1

/* macros for BlueprintGlobalNameSpace::MAC_DCU_TXFILTER_DCU4_63_32 */
#ifndef __MAC_DCU_TXFILTER_DCU4_63_32_MACRO__
#define __MAC_DCU_TXFILTER_DCU4_63_32_MACRO__

/* macros for field DATA */
#define MAC_DCU_TXFILTER_DCU4_63_32__DATA__SHIFT                              0
#define MAC_DCU_TXFILTER_DCU4_63_32__DATA__WIDTH                             32
#define MAC_DCU_TXFILTER_DCU4_63_32__DATA__MASK                     0xffffffffU
#define MAC_DCU_TXFILTER_DCU4_63_32__DATA__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define MAC_DCU_TXFILTER_DCU4_63_32__TYPE                             u_int32_t
#define MAC_DCU_TXFILTER_DCU4_63_32__READ                           0xffffffffU

#endif /* __MAC_DCU_TXFILTER_DCU4_63_32_MACRO__ */


/* macros for mac_dcu_reg_block.MAC_DCU_TXFILTER_DCU4_63_32 */
#define INST_MAC_DCU_REG_BLOCK__MAC_DCU_TXFILTER_DCU4_63_32__NUM              1

/* macros for BlueprintGlobalNameSpace::MAC_DCU_TXFILTER_SET */
#ifndef __MAC_DCU_TXFILTER_SET_MACRO__
#define __MAC_DCU_TXFILTER_SET_MACRO__

/* macros for field DATA */
#define MAC_DCU_TXFILTER_SET__DATA__SHIFT                                     0
#define MAC_DCU_TXFILTER_SET__DATA__WIDTH                                    32
#define MAC_DCU_TXFILTER_SET__DATA__MASK                            0xffffffffU
#define MAC_DCU_TXFILTER_SET__DATA__READ(src)    (u_int32_t)(src) & 0xffffffffU
#define MAC_DCU_TXFILTER_SET__DATA__WRITE(src) ((u_int32_t)(src) & 0xffffffffU)
#define MAC_DCU_TXFILTER_SET__DATA__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xffffffffU) | ((u_int32_t)(src) &\
                    0xffffffffU)
#define MAC_DCU_TXFILTER_SET__DATA__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0xffffffffU)))
#define MAC_DCU_TXFILTER_SET__TYPE                                    u_int32_t
#define MAC_DCU_TXFILTER_SET__READ                                  0xffffffffU
#define MAC_DCU_TXFILTER_SET__WRITE                                 0xffffffffU

#endif /* __MAC_DCU_TXFILTER_SET_MACRO__ */


/* macros for mac_dcu_reg_block.MAC_DCU_TXFILTER_SET */
#define INST_MAC_DCU_REG_BLOCK__MAC_DCU_TXFILTER_SET__NUM                     1

/* macros for BlueprintGlobalNameSpace::MAC_DCU_TXFILTER_DCU4_95_64 */
#ifndef __MAC_DCU_TXFILTER_DCU4_95_64_MACRO__
#define __MAC_DCU_TXFILTER_DCU4_95_64_MACRO__

/* macros for field DATA */
#define MAC_DCU_TXFILTER_DCU4_95_64__DATA__SHIFT                              0
#define MAC_DCU_TXFILTER_DCU4_95_64__DATA__WIDTH                             32
#define MAC_DCU_TXFILTER_DCU4_95_64__DATA__MASK                     0xffffffffU
#define MAC_DCU_TXFILTER_DCU4_95_64__DATA__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define MAC_DCU_TXFILTER_DCU4_95_64__TYPE                             u_int32_t
#define MAC_DCU_TXFILTER_DCU4_95_64__READ                           0xffffffffU

#endif /* __MAC_DCU_TXFILTER_DCU4_95_64_MACRO__ */


/* macros for mac_dcu_reg_block.MAC_DCU_TXFILTER_DCU4_95_64 */
#define INST_MAC_DCU_REG_BLOCK__MAC_DCU_TXFILTER_DCU4_95_64__NUM              1

/* macros for BlueprintGlobalNameSpace::MAC_DCU_TXFILTER_DCU4_127_96 */
#ifndef __MAC_DCU_TXFILTER_DCU4_127_96_MACRO__
#define __MAC_DCU_TXFILTER_DCU4_127_96_MACRO__

/* macros for field DATA */
#define MAC_DCU_TXFILTER_DCU4_127_96__DATA__SHIFT                             0
#define MAC_DCU_TXFILTER_DCU4_127_96__DATA__WIDTH                            32
#define MAC_DCU_TXFILTER_DCU4_127_96__DATA__MASK                    0xffffffffU
#define MAC_DCU_TXFILTER_DCU4_127_96__DATA__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define MAC_DCU_TXFILTER_DCU4_127_96__TYPE                            u_int32_t
#define MAC_DCU_TXFILTER_DCU4_127_96__READ                          0xffffffffU

#endif /* __MAC_DCU_TXFILTER_DCU4_127_96_MACRO__ */


/* macros for mac_dcu_reg_block.MAC_DCU_TXFILTER_DCU4_127_96 */
#define INST_MAC_DCU_REG_BLOCK__MAC_DCU_TXFILTER_DCU4_127_96__NUM             1

/* macros for BlueprintGlobalNameSpace::MAC_DCU_TXFILTER_DCU5_31_0 */
#ifndef __MAC_DCU_TXFILTER_DCU5_31_0_MACRO__
#define __MAC_DCU_TXFILTER_DCU5_31_0_MACRO__

/* macros for field DATA */
#define MAC_DCU_TXFILTER_DCU5_31_0__DATA__SHIFT                               0
#define MAC_DCU_TXFILTER_DCU5_31_0__DATA__WIDTH                              32
#define MAC_DCU_TXFILTER_DCU5_31_0__DATA__MASK                      0xffffffffU
#define MAC_DCU_TXFILTER_DCU5_31_0__DATA__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define MAC_DCU_TXFILTER_DCU5_31_0__TYPE                              u_int32_t
#define MAC_DCU_TXFILTER_DCU5_31_0__READ                            0xffffffffU

#endif /* __MAC_DCU_TXFILTER_DCU5_31_0_MACRO__ */


/* macros for mac_dcu_reg_block.MAC_DCU_TXFILTER_DCU5_31_0 */
#define INST_MAC_DCU_REG_BLOCK__MAC_DCU_TXFILTER_DCU5_31_0__NUM               1

/* macros for BlueprintGlobalNameSpace::MAC_DCU_TXFILTER_DCU5_63_32 */
#ifndef __MAC_DCU_TXFILTER_DCU5_63_32_MACRO__
#define __MAC_DCU_TXFILTER_DCU5_63_32_MACRO__

/* macros for field DATA */
#define MAC_DCU_TXFILTER_DCU5_63_32__DATA__SHIFT                              0
#define MAC_DCU_TXFILTER_DCU5_63_32__DATA__WIDTH                             32
#define MAC_DCU_TXFILTER_DCU5_63_32__DATA__MASK                     0xffffffffU
#define MAC_DCU_TXFILTER_DCU5_63_32__DATA__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define MAC_DCU_TXFILTER_DCU5_63_32__TYPE                             u_int32_t
#define MAC_DCU_TXFILTER_DCU5_63_32__READ                           0xffffffffU

#endif /* __MAC_DCU_TXFILTER_DCU5_63_32_MACRO__ */


/* macros for mac_dcu_reg_block.MAC_DCU_TXFILTER_DCU5_63_32 */
#define INST_MAC_DCU_REG_BLOCK__MAC_DCU_TXFILTER_DCU5_63_32__NUM              1

/* macros for BlueprintGlobalNameSpace::MAC_DCU_TXFILTER_DCU5_95_64 */
#ifndef __MAC_DCU_TXFILTER_DCU5_95_64_MACRO__
#define __MAC_DCU_TXFILTER_DCU5_95_64_MACRO__

/* macros for field DATA */
#define MAC_DCU_TXFILTER_DCU5_95_64__DATA__SHIFT                              0
#define MAC_DCU_TXFILTER_DCU5_95_64__DATA__WIDTH                             32
#define MAC_DCU_TXFILTER_DCU5_95_64__DATA__MASK                     0xffffffffU
#define MAC_DCU_TXFILTER_DCU5_95_64__DATA__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define MAC_DCU_TXFILTER_DCU5_95_64__TYPE                             u_int32_t
#define MAC_DCU_TXFILTER_DCU5_95_64__READ                           0xffffffffU

#endif /* __MAC_DCU_TXFILTER_DCU5_95_64_MACRO__ */


/* macros for mac_dcu_reg_block.MAC_DCU_TXFILTER_DCU5_95_64 */
#define INST_MAC_DCU_REG_BLOCK__MAC_DCU_TXFILTER_DCU5_95_64__NUM              1

/* macros for BlueprintGlobalNameSpace::MAC_DCU_TXFILTER_DCU5_127_96 */
#ifndef __MAC_DCU_TXFILTER_DCU5_127_96_MACRO__
#define __MAC_DCU_TXFILTER_DCU5_127_96_MACRO__

/* macros for field DATA */
#define MAC_DCU_TXFILTER_DCU5_127_96__DATA__SHIFT                             0
#define MAC_DCU_TXFILTER_DCU5_127_96__DATA__WIDTH                            32
#define MAC_DCU_TXFILTER_DCU5_127_96__DATA__MASK                    0xffffffffU
#define MAC_DCU_TXFILTER_DCU5_127_96__DATA__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define MAC_DCU_TXFILTER_DCU5_127_96__TYPE                            u_int32_t
#define MAC_DCU_TXFILTER_DCU5_127_96__READ                          0xffffffffU

#endif /* __MAC_DCU_TXFILTER_DCU5_127_96_MACRO__ */


/* macros for mac_dcu_reg_block.MAC_DCU_TXFILTER_DCU5_127_96 */
#define INST_MAC_DCU_REG_BLOCK__MAC_DCU_TXFILTER_DCU5_127_96__NUM             1

/* macros for BlueprintGlobalNameSpace::MAC_DCU_TXFILTER_DCU6_31_0 */
#ifndef __MAC_DCU_TXFILTER_DCU6_31_0_MACRO__
#define __MAC_DCU_TXFILTER_DCU6_31_0_MACRO__

/* macros for field DATA */
#define MAC_DCU_TXFILTER_DCU6_31_0__DATA__SHIFT                               0
#define MAC_DCU_TXFILTER_DCU6_31_0__DATA__WIDTH                              32
#define MAC_DCU_TXFILTER_DCU6_31_0__DATA__MASK                      0xffffffffU
#define MAC_DCU_TXFILTER_DCU6_31_0__DATA__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define MAC_DCU_TXFILTER_DCU6_31_0__TYPE                              u_int32_t
#define MAC_DCU_TXFILTER_DCU6_31_0__READ                            0xffffffffU

#endif /* __MAC_DCU_TXFILTER_DCU6_31_0_MACRO__ */


/* macros for mac_dcu_reg_block.MAC_DCU_TXFILTER_DCU6_31_0 */
#define INST_MAC_DCU_REG_BLOCK__MAC_DCU_TXFILTER_DCU6_31_0__NUM               1

/* macros for BlueprintGlobalNameSpace::MAC_DCU_TXFILTER_DCU6_63_32 */
#ifndef __MAC_DCU_TXFILTER_DCU6_63_32_MACRO__
#define __MAC_DCU_TXFILTER_DCU6_63_32_MACRO__

/* macros for field DATA */
#define MAC_DCU_TXFILTER_DCU6_63_32__DATA__SHIFT                              0
#define MAC_DCU_TXFILTER_DCU6_63_32__DATA__WIDTH                             32
#define MAC_DCU_TXFILTER_DCU6_63_32__DATA__MASK                     0xffffffffU
#define MAC_DCU_TXFILTER_DCU6_63_32__DATA__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define MAC_DCU_TXFILTER_DCU6_63_32__TYPE                             u_int32_t
#define MAC_DCU_TXFILTER_DCU6_63_32__READ                           0xffffffffU

#endif /* __MAC_DCU_TXFILTER_DCU6_63_32_MACRO__ */


/* macros for mac_dcu_reg_block.MAC_DCU_TXFILTER_DCU6_63_32 */
#define INST_MAC_DCU_REG_BLOCK__MAC_DCU_TXFILTER_DCU6_63_32__NUM              1

/* macros for BlueprintGlobalNameSpace::MAC_DCU_TXFILTER_DCU6_95_64 */
#ifndef __MAC_DCU_TXFILTER_DCU6_95_64_MACRO__
#define __MAC_DCU_TXFILTER_DCU6_95_64_MACRO__

/* macros for field DATA */
#define MAC_DCU_TXFILTER_DCU6_95_64__DATA__SHIFT                              0
#define MAC_DCU_TXFILTER_DCU6_95_64__DATA__WIDTH                             32
#define MAC_DCU_TXFILTER_DCU6_95_64__DATA__MASK                     0xffffffffU
#define MAC_DCU_TXFILTER_DCU6_95_64__DATA__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define MAC_DCU_TXFILTER_DCU6_95_64__TYPE                             u_int32_t
#define MAC_DCU_TXFILTER_DCU6_95_64__READ                           0xffffffffU

#endif /* __MAC_DCU_TXFILTER_DCU6_95_64_MACRO__ */


/* macros for mac_dcu_reg_block.MAC_DCU_TXFILTER_DCU6_95_64 */
#define INST_MAC_DCU_REG_BLOCK__MAC_DCU_TXFILTER_DCU6_95_64__NUM              1

/* macros for BlueprintGlobalNameSpace::MAC_DCU_TXFILTER_DCU6_127_96 */
#ifndef __MAC_DCU_TXFILTER_DCU6_127_96_MACRO__
#define __MAC_DCU_TXFILTER_DCU6_127_96_MACRO__

/* macros for field DATA */
#define MAC_DCU_TXFILTER_DCU6_127_96__DATA__SHIFT                             0
#define MAC_DCU_TXFILTER_DCU6_127_96__DATA__WIDTH                            32
#define MAC_DCU_TXFILTER_DCU6_127_96__DATA__MASK                    0xffffffffU
#define MAC_DCU_TXFILTER_DCU6_127_96__DATA__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define MAC_DCU_TXFILTER_DCU6_127_96__TYPE                            u_int32_t
#define MAC_DCU_TXFILTER_DCU6_127_96__READ                          0xffffffffU

#endif /* __MAC_DCU_TXFILTER_DCU6_127_96_MACRO__ */


/* macros for mac_dcu_reg_block.MAC_DCU_TXFILTER_DCU6_127_96 */
#define INST_MAC_DCU_REG_BLOCK__MAC_DCU_TXFILTER_DCU6_127_96__NUM             1

/* macros for BlueprintGlobalNameSpace::MAC_DCU_TXFILTER_DCU7_31_0 */
#ifndef __MAC_DCU_TXFILTER_DCU7_31_0_MACRO__
#define __MAC_DCU_TXFILTER_DCU7_31_0_MACRO__

/* macros for field DATA */
#define MAC_DCU_TXFILTER_DCU7_31_0__DATA__SHIFT                               0
#define MAC_DCU_TXFILTER_DCU7_31_0__DATA__WIDTH                              32
#define MAC_DCU_TXFILTER_DCU7_31_0__DATA__MASK                      0xffffffffU
#define MAC_DCU_TXFILTER_DCU7_31_0__DATA__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define MAC_DCU_TXFILTER_DCU7_31_0__TYPE                              u_int32_t
#define MAC_DCU_TXFILTER_DCU7_31_0__READ                            0xffffffffU

#endif /* __MAC_DCU_TXFILTER_DCU7_31_0_MACRO__ */


/* macros for mac_dcu_reg_block.MAC_DCU_TXFILTER_DCU7_31_0 */
#define INST_MAC_DCU_REG_BLOCK__MAC_DCU_TXFILTER_DCU7_31_0__NUM               1

/* macros for BlueprintGlobalNameSpace::MAC_DCU_TXFILTER_DCU7_63_32 */
#ifndef __MAC_DCU_TXFILTER_DCU7_63_32_MACRO__
#define __MAC_DCU_TXFILTER_DCU7_63_32_MACRO__

/* macros for field DATA */
#define MAC_DCU_TXFILTER_DCU7_63_32__DATA__SHIFT                              0
#define MAC_DCU_TXFILTER_DCU7_63_32__DATA__WIDTH                             32
#define MAC_DCU_TXFILTER_DCU7_63_32__DATA__MASK                     0xffffffffU
#define MAC_DCU_TXFILTER_DCU7_63_32__DATA__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define MAC_DCU_TXFILTER_DCU7_63_32__TYPE                             u_int32_t
#define MAC_DCU_TXFILTER_DCU7_63_32__READ                           0xffffffffU

#endif /* __MAC_DCU_TXFILTER_DCU7_63_32_MACRO__ */


/* macros for mac_dcu_reg_block.MAC_DCU_TXFILTER_DCU7_63_32 */
#define INST_MAC_DCU_REG_BLOCK__MAC_DCU_TXFILTER_DCU7_63_32__NUM              1

/* macros for BlueprintGlobalNameSpace::MAC_DCU_TXFILTER_DCU7_95_64 */
#ifndef __MAC_DCU_TXFILTER_DCU7_95_64_MACRO__
#define __MAC_DCU_TXFILTER_DCU7_95_64_MACRO__

/* macros for field DATA */
#define MAC_DCU_TXFILTER_DCU7_95_64__DATA__SHIFT                              0
#define MAC_DCU_TXFILTER_DCU7_95_64__DATA__WIDTH                             32
#define MAC_DCU_TXFILTER_DCU7_95_64__DATA__MASK                     0xffffffffU
#define MAC_DCU_TXFILTER_DCU7_95_64__DATA__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define MAC_DCU_TXFILTER_DCU7_95_64__TYPE                             u_int32_t
#define MAC_DCU_TXFILTER_DCU7_95_64__READ                           0xffffffffU

#endif /* __MAC_DCU_TXFILTER_DCU7_95_64_MACRO__ */


/* macros for mac_dcu_reg_block.MAC_DCU_TXFILTER_DCU7_95_64 */
#define INST_MAC_DCU_REG_BLOCK__MAC_DCU_TXFILTER_DCU7_95_64__NUM              1

/* macros for BlueprintGlobalNameSpace::MAC_DCU_TXFILTER_DCU7_127_96 */
#ifndef __MAC_DCU_TXFILTER_DCU7_127_96_MACRO__
#define __MAC_DCU_TXFILTER_DCU7_127_96_MACRO__

/* macros for field DATA */
#define MAC_DCU_TXFILTER_DCU7_127_96__DATA__SHIFT                             0
#define MAC_DCU_TXFILTER_DCU7_127_96__DATA__WIDTH                            32
#define MAC_DCU_TXFILTER_DCU7_127_96__DATA__MASK                    0xffffffffU
#define MAC_DCU_TXFILTER_DCU7_127_96__DATA__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define MAC_DCU_TXFILTER_DCU7_127_96__TYPE                            u_int32_t
#define MAC_DCU_TXFILTER_DCU7_127_96__READ                          0xffffffffU

#endif /* __MAC_DCU_TXFILTER_DCU7_127_96_MACRO__ */


/* macros for mac_dcu_reg_block.MAC_DCU_TXFILTER_DCU7_127_96 */
#define INST_MAC_DCU_REG_BLOCK__MAC_DCU_TXFILTER_DCU7_127_96__NUM             1

/* macros for BlueprintGlobalNameSpace::MAC_SLEEP_STATUS */
#ifndef __MAC_SLEEP_STATUS_MACRO__
#define __MAC_SLEEP_STATUS_MACRO__

/* macros for field DATA */
#define MAC_SLEEP_STATUS__DATA__SHIFT                                         0
#define MAC_SLEEP_STATUS__DATA__WIDTH                                        32
#define MAC_SLEEP_STATUS__DATA__MASK                                0xffffffffU
#define MAC_SLEEP_STATUS__DATA__READ(src)        (u_int32_t)(src) & 0xffffffffU
#define MAC_SLEEP_STATUS__DATA__WRITE(src)     ((u_int32_t)(src) & 0xffffffffU)
#define MAC_SLEEP_STATUS__DATA__MODIFY(dst, src) \
    (dst) = ((dst) &\
            ~0xffffffffU) | ((u_int32_t)(src) &\
                0xffffffffU)
#define MAC_SLEEP_STATUS__DATA__VERIFY(src) \
    (!(((u_int32_t)(src)\
        & ~0xffffffffU)))
#define MAC_SLEEP_STATUS__TYPE                                        u_int32_t
#define MAC_SLEEP_STATUS__READ                                      0xffffffffU
#define MAC_SLEEP_STATUS__WRITE                                     0xffffffffU

#endif /* __MAC_SLEEP_STATUS_MACRO__ */


/* macros for mac_dcu_reg_block.MAC_SLEEP_STATUS */
#define INST_MAC_DCU_REG_BLOCK__MAC_SLEEP_STATUS__NUM                         1

/* macros for BlueprintGlobalNameSpace::MAC_LED_CONFIG */
#ifndef __MAC_LED_CONFIG_MACRO__
#define __MAC_LED_CONFIG_MACRO__

/* macros for field DATA */
#define MAC_LED_CONFIG__DATA__SHIFT                                           0
#define MAC_LED_CONFIG__DATA__WIDTH                                          32
#define MAC_LED_CONFIG__DATA__MASK                                  0xffffffffU
#define MAC_LED_CONFIG__DATA__READ(src)          (u_int32_t)(src) & 0xffffffffU
#define MAC_LED_CONFIG__DATA__WRITE(src)       ((u_int32_t)(src) & 0xffffffffU)
#define MAC_LED_CONFIG__DATA__MODIFY(dst, src) \
    (dst) = ((dst) &\
            ~0xffffffffU) | ((u_int32_t)(src) &\
                0xffffffffU)
#define MAC_LED_CONFIG__DATA__VERIFY(src) \
    (!(((u_int32_t)(src)\
        & ~0xffffffffU)))
#define MAC_LED_CONFIG__TYPE                                          u_int32_t
#define MAC_LED_CONFIG__READ                                        0xffffffffU
#define MAC_LED_CONFIG__WRITE                                       0xffffffffU

#endif /* __MAC_LED_CONFIG_MACRO__ */


/* macros for mac_dcu_reg_block.MAC_LED_CONFIG */
#define INST_MAC_DCU_REG_BLOCK__MAC_LED_CONFIG__NUM                           1

/* macros for BlueprintGlobalNameSpace::HOST_INTF_RESET_CONTROL */
#ifndef __HOST_INTF_RESET_CONTROL_MACRO__
#define __HOST_INTF_RESET_CONTROL_MACRO__

/* macros for field AHB_RESET */
#define HOST_INTF_RESET_CONTROL__AHB_RESET__SHIFT                             0
#define HOST_INTF_RESET_CONTROL__AHB_RESET__WIDTH                             1
#define HOST_INTF_RESET_CONTROL__AHB_RESET__MASK                    0x00000001U
#define HOST_INTF_RESET_CONTROL__AHB_RESET__READ(src) \
                    (u_int32_t)(src)\
                    & 0x00000001U
#define HOST_INTF_RESET_CONTROL__AHB_RESET__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x00000001U)
#define HOST_INTF_RESET_CONTROL__AHB_RESET__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | ((u_int32_t)(src) &\
                    0x00000001U)
#define HOST_INTF_RESET_CONTROL__AHB_RESET__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00000001U)))
#define HOST_INTF_RESET_CONTROL__AHB_RESET__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(1)
#define HOST_INTF_RESET_CONTROL__AHB_RESET__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(0)

/* macros for field APB_RESET */
#define HOST_INTF_RESET_CONTROL__APB_RESET__SHIFT                             1
#define HOST_INTF_RESET_CONTROL__APB_RESET__WIDTH                             1
#define HOST_INTF_RESET_CONTROL__APB_RESET__MASK                    0x00000002U
#define HOST_INTF_RESET_CONTROL__APB_RESET__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000002U) >> 1)
#define HOST_INTF_RESET_CONTROL__APB_RESET__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 1) & 0x00000002U)
#define HOST_INTF_RESET_CONTROL__APB_RESET__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | (((u_int32_t)(src) <<\
                    1) & 0x00000002U)
#define HOST_INTF_RESET_CONTROL__APB_RESET__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 1) & ~0x00000002U)))
#define HOST_INTF_RESET_CONTROL__APB_RESET__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | ((u_int32_t)(1) << 1)
#define HOST_INTF_RESET_CONTROL__APB_RESET__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | ((u_int32_t)(0) << 1)

/* macros for field LOCAL_RESET */
#define HOST_INTF_RESET_CONTROL__LOCAL_RESET__SHIFT                           8
#define HOST_INTF_RESET_CONTROL__LOCAL_RESET__WIDTH                           1
#define HOST_INTF_RESET_CONTROL__LOCAL_RESET__MASK                  0x00000100U
#define HOST_INTF_RESET_CONTROL__LOCAL_RESET__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000100U) >> 8)
#define HOST_INTF_RESET_CONTROL__LOCAL_RESET__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 8) & 0x00000100U)
#define HOST_INTF_RESET_CONTROL__LOCAL_RESET__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000100U) | (((u_int32_t)(src) <<\
                    8) & 0x00000100U)
#define HOST_INTF_RESET_CONTROL__LOCAL_RESET__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 8) & ~0x00000100U)))
#define HOST_INTF_RESET_CONTROL__LOCAL_RESET__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000100U) | ((u_int32_t)(1) << 8)
#define HOST_INTF_RESET_CONTROL__LOCAL_RESET__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000100U) | ((u_int32_t)(0) << 8)
#define HOST_INTF_RESET_CONTROL__TYPE                                 u_int32_t
#define HOST_INTF_RESET_CONTROL__READ                               0x00000103U
#define HOST_INTF_RESET_CONTROL__WRITE                              0x00000103U

#endif /* __HOST_INTF_RESET_CONTROL_MACRO__ */


/* macros for host_intf_reg_block.HOST_INTF_RESET_CONTROL */
#define INST_HOST_INTF_REG_BLOCK__HOST_INTF_RESET_CONTROL__NUM                1

/* macros for BlueprintGlobalNameSpace::HOST_INTF_WORK_AROUND */
#ifndef __HOST_INTF_WORK_AROUND_MACRO__
#define __HOST_INTF_WORK_AROUND_MACRO__

/* macros for field TS1_WA_EN */
#define HOST_INTF_WORK_AROUND__TS1_WA_EN__SHIFT                               0
#define HOST_INTF_WORK_AROUND__TS1_WA_EN__WIDTH                               1
#define HOST_INTF_WORK_AROUND__TS1_WA_EN__MASK                      0x00000001U
#define HOST_INTF_WORK_AROUND__TS1_WA_EN__READ(src) \
                    (u_int32_t)(src)\
                    & 0x00000001U
#define HOST_INTF_WORK_AROUND__TS1_WA_EN__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x00000001U)
#define HOST_INTF_WORK_AROUND__TS1_WA_EN__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | ((u_int32_t)(src) &\
                    0x00000001U)
#define HOST_INTF_WORK_AROUND__TS1_WA_EN__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00000001U)))
#define HOST_INTF_WORK_AROUND__TS1_WA_EN__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(1)
#define HOST_INTF_WORK_AROUND__TS1_WA_EN__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(0)

/* macros for field TS2_WA_EN */
#define HOST_INTF_WORK_AROUND__TS2_WA_EN__SHIFT                               1
#define HOST_INTF_WORK_AROUND__TS2_WA_EN__WIDTH                               1
#define HOST_INTF_WORK_AROUND__TS2_WA_EN__MASK                      0x00000002U
#define HOST_INTF_WORK_AROUND__TS2_WA_EN__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000002U) >> 1)
#define HOST_INTF_WORK_AROUND__TS2_WA_EN__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 1) & 0x00000002U)
#define HOST_INTF_WORK_AROUND__TS2_WA_EN__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | (((u_int32_t)(src) <<\
                    1) & 0x00000002U)
#define HOST_INTF_WORK_AROUND__TS2_WA_EN__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 1) & ~0x00000002U)))
#define HOST_INTF_WORK_AROUND__TS2_WA_EN__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | ((u_int32_t)(1) << 1)
#define HOST_INTF_WORK_AROUND__TS2_WA_EN__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | ((u_int32_t)(0) << 1)

/* macros for field RESET_SERDES_WA_EN */
#define HOST_INTF_WORK_AROUND__RESET_SERDES_WA_EN__SHIFT                      2
#define HOST_INTF_WORK_AROUND__RESET_SERDES_WA_EN__WIDTH                      1
#define HOST_INTF_WORK_AROUND__RESET_SERDES_WA_EN__MASK             0x00000004U
#define HOST_INTF_WORK_AROUND__RESET_SERDES_WA_EN__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000004U) >> 2)
#define HOST_INTF_WORK_AROUND__RESET_SERDES_WA_EN__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 2) & 0x00000004U)
#define HOST_INTF_WORK_AROUND__RESET_SERDES_WA_EN__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000004U) | (((u_int32_t)(src) <<\
                    2) & 0x00000004U)
#define HOST_INTF_WORK_AROUND__RESET_SERDES_WA_EN__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 2) & ~0x00000004U)))
#define HOST_INTF_WORK_AROUND__RESET_SERDES_WA_EN__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000004U) | ((u_int32_t)(1) << 2)
#define HOST_INTF_WORK_AROUND__RESET_SERDES_WA_EN__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000004U) | ((u_int32_t)(0) << 2)

/* macros for field GDATA_WA_EN */
#define HOST_INTF_WORK_AROUND__GDATA_WA_EN__SHIFT                             3
#define HOST_INTF_WORK_AROUND__GDATA_WA_EN__WIDTH                             1
#define HOST_INTF_WORK_AROUND__GDATA_WA_EN__MASK                    0x00000008U
#define HOST_INTF_WORK_AROUND__GDATA_WA_EN__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000008U) >> 3)
#define HOST_INTF_WORK_AROUND__GDATA_WA_EN__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 3) & 0x00000008U)
#define HOST_INTF_WORK_AROUND__GDATA_WA_EN__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000008U) | (((u_int32_t)(src) <<\
                    3) & 0x00000008U)
#define HOST_INTF_WORK_AROUND__GDATA_WA_EN__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 3) & ~0x00000008U)))
#define HOST_INTF_WORK_AROUND__GDATA_WA_EN__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000008U) | ((u_int32_t)(1) << 3)
#define HOST_INTF_WORK_AROUND__GDATA_WA_EN__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000008U) | ((u_int32_t)(0) << 3)

/* macros for field NO_NAK_WA_EN */
#define HOST_INTF_WORK_AROUND__NO_NAK_WA_EN__SHIFT                            4
#define HOST_INTF_WORK_AROUND__NO_NAK_WA_EN__WIDTH                            1
#define HOST_INTF_WORK_AROUND__NO_NAK_WA_EN__MASK                   0x00000010U
#define HOST_INTF_WORK_AROUND__NO_NAK_WA_EN__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000010U) >> 4)
#define HOST_INTF_WORK_AROUND__NO_NAK_WA_EN__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 4) & 0x00000010U)
#define HOST_INTF_WORK_AROUND__NO_NAK_WA_EN__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000010U) | (((u_int32_t)(src) <<\
                    4) & 0x00000010U)
#define HOST_INTF_WORK_AROUND__NO_NAK_WA_EN__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 4) & ~0x00000010U)))
#define HOST_INTF_WORK_AROUND__NO_NAK_WA_EN__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000010U) | ((u_int32_t)(1) << 4)
#define HOST_INTF_WORK_AROUND__NO_NAK_WA_EN__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000010U) | ((u_int32_t)(0) << 4)

/* macros for field FORCE_L1L0_DMA */
#define HOST_INTF_WORK_AROUND__FORCE_L1L0_DMA__SHIFT                          9
#define HOST_INTF_WORK_AROUND__FORCE_L1L0_DMA__WIDTH                          1
#define HOST_INTF_WORK_AROUND__FORCE_L1L0_DMA__MASK                 0x00000200U
#define HOST_INTF_WORK_AROUND__FORCE_L1L0_DMA__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000200U) >> 9)
#define HOST_INTF_WORK_AROUND__FORCE_L1L0_DMA__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 9) & 0x00000200U)
#define HOST_INTF_WORK_AROUND__FORCE_L1L0_DMA__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000200U) | (((u_int32_t)(src) <<\
                    9) & 0x00000200U)
#define HOST_INTF_WORK_AROUND__FORCE_L1L0_DMA__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 9) & ~0x00000200U)))
#define HOST_INTF_WORK_AROUND__FORCE_L1L0_DMA__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000200U) | ((u_int32_t)(1) << 9)
#define HOST_INTF_WORK_AROUND__FORCE_L1L0_DMA__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000200U) | ((u_int32_t)(0) << 9)

/* macros for field PCIE_COLD_RESET_OVRRD */
#define HOST_INTF_WORK_AROUND__PCIE_COLD_RESET_OVRRD__SHIFT                  13
#define HOST_INTF_WORK_AROUND__PCIE_COLD_RESET_OVRRD__WIDTH                   1
#define HOST_INTF_WORK_AROUND__PCIE_COLD_RESET_OVRRD__MASK          0x00002000U
#define HOST_INTF_WORK_AROUND__PCIE_COLD_RESET_OVRRD__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00002000U) >> 13)
#define HOST_INTF_WORK_AROUND__PCIE_COLD_RESET_OVRRD__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 13) & 0x00002000U)
#define HOST_INTF_WORK_AROUND__PCIE_COLD_RESET_OVRRD__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00002000U) | (((u_int32_t)(src) <<\
                    13) & 0x00002000U)
#define HOST_INTF_WORK_AROUND__PCIE_COLD_RESET_OVRRD__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 13) & ~0x00002000U)))
#define HOST_INTF_WORK_AROUND__PCIE_COLD_RESET_OVRRD__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00002000U) | ((u_int32_t)(1) << 13)
#define HOST_INTF_WORK_AROUND__PCIE_COLD_RESET_OVRRD__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00002000U) | ((u_int32_t)(0) << 13)

/* macros for field D3_TO_L1_DISABLE */
#define HOST_INTF_WORK_AROUND__D3_TO_L1_DISABLE__SHIFT                       14
#define HOST_INTF_WORK_AROUND__D3_TO_L1_DISABLE__WIDTH                        1
#define HOST_INTF_WORK_AROUND__D3_TO_L1_DISABLE__MASK               0x00004000U
#define HOST_INTF_WORK_AROUND__D3_TO_L1_DISABLE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00004000U) >> 14)
#define HOST_INTF_WORK_AROUND__D3_TO_L1_DISABLE__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 14) & 0x00004000U)
#define HOST_INTF_WORK_AROUND__D3_TO_L1_DISABLE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00004000U) | (((u_int32_t)(src) <<\
                    14) & 0x00004000U)
#define HOST_INTF_WORK_AROUND__D3_TO_L1_DISABLE__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 14) & ~0x00004000U)))
#define HOST_INTF_WORK_AROUND__D3_TO_L1_DISABLE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00004000U) | ((u_int32_t)(1) << 14)
#define HOST_INTF_WORK_AROUND__D3_TO_L1_DISABLE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00004000U) | ((u_int32_t)(0) << 14)

/* macros for field PCIERST_PORRST_SHORT */
#define HOST_INTF_WORK_AROUND__PCIERST_PORRST_SHORT__SHIFT                   15
#define HOST_INTF_WORK_AROUND__PCIERST_PORRST_SHORT__WIDTH                    1
#define HOST_INTF_WORK_AROUND__PCIERST_PORRST_SHORT__MASK           0x00008000U
#define HOST_INTF_WORK_AROUND__PCIERST_PORRST_SHORT__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00008000U) >> 15)
#define HOST_INTF_WORK_AROUND__PCIERST_PORRST_SHORT__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 15) & 0x00008000U)
#define HOST_INTF_WORK_AROUND__PCIERST_PORRST_SHORT__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00008000U) | (((u_int32_t)(src) <<\
                    15) & 0x00008000U)
#define HOST_INTF_WORK_AROUND__PCIERST_PORRST_SHORT__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 15) & ~0x00008000U)))
#define HOST_INTF_WORK_AROUND__PCIERST_PORRST_SHORT__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00008000U) | ((u_int32_t)(1) << 15)
#define HOST_INTF_WORK_AROUND__PCIERST_PORRST_SHORT__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00008000U) | ((u_int32_t)(0) << 15)

/* macros for field D3_TO_L1_DISABLE_REAL */
#define HOST_INTF_WORK_AROUND__D3_TO_L1_DISABLE_REAL__SHIFT                  16
#define HOST_INTF_WORK_AROUND__D3_TO_L1_DISABLE_REAL__WIDTH                   1
#define HOST_INTF_WORK_AROUND__D3_TO_L1_DISABLE_REAL__MASK          0x00010000U
#define HOST_INTF_WORK_AROUND__D3_TO_L1_DISABLE_REAL__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00010000U) >> 16)
#define HOST_INTF_WORK_AROUND__D3_TO_L1_DISABLE_REAL__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 16) & 0x00010000U)
#define HOST_INTF_WORK_AROUND__D3_TO_L1_DISABLE_REAL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00010000U) | (((u_int32_t)(src) <<\
                    16) & 0x00010000U)
#define HOST_INTF_WORK_AROUND__D3_TO_L1_DISABLE_REAL__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 16) & ~0x00010000U)))
#define HOST_INTF_WORK_AROUND__D3_TO_L1_DISABLE_REAL__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00010000U) | ((u_int32_t)(1) << 16)
#define HOST_INTF_WORK_AROUND__D3_TO_L1_DISABLE_REAL__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00010000U) | ((u_int32_t)(0) << 16)

/* macros for field ASPM_TIMER_BASED_L1_DISABLE */
#define HOST_INTF_WORK_AROUND__ASPM_TIMER_BASED_L1_DISABLE__SHIFT            17
#define HOST_INTF_WORK_AROUND__ASPM_TIMER_BASED_L1_DISABLE__WIDTH             1
#define HOST_INTF_WORK_AROUND__ASPM_TIMER_BASED_L1_DISABLE__MASK    0x00020000U
#define HOST_INTF_WORK_AROUND__ASPM_TIMER_BASED_L1_DISABLE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00020000U) >> 17)
#define HOST_INTF_WORK_AROUND__ASPM_TIMER_BASED_L1_DISABLE__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 17) & 0x00020000U)
#define HOST_INTF_WORK_AROUND__ASPM_TIMER_BASED_L1_DISABLE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00020000U) | (((u_int32_t)(src) <<\
                    17) & 0x00020000U)
#define HOST_INTF_WORK_AROUND__ASPM_TIMER_BASED_L1_DISABLE__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 17) & ~0x00020000U)))
#define HOST_INTF_WORK_AROUND__ASPM_TIMER_BASED_L1_DISABLE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00020000U) | ((u_int32_t)(1) << 17)
#define HOST_INTF_WORK_AROUND__ASPM_TIMER_BASED_L1_DISABLE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00020000U) | ((u_int32_t)(0) << 17)

/* macros for field PCIERST_PORRST_SW_CNTL */
#define HOST_INTF_WORK_AROUND__PCIERST_PORRST_SW_CNTL__SHIFT                 18
#define HOST_INTF_WORK_AROUND__PCIERST_PORRST_SW_CNTL__WIDTH                  1
#define HOST_INTF_WORK_AROUND__PCIERST_PORRST_SW_CNTL__MASK         0x00040000U
#define HOST_INTF_WORK_AROUND__PCIERST_PORRST_SW_CNTL__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00040000U) >> 18)
#define HOST_INTF_WORK_AROUND__PCIERST_PORRST_SW_CNTL__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 18) & 0x00040000U)
#define HOST_INTF_WORK_AROUND__PCIERST_PORRST_SW_CNTL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00040000U) | (((u_int32_t)(src) <<\
                    18) & 0x00040000U)
#define HOST_INTF_WORK_AROUND__PCIERST_PORRST_SW_CNTL__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 18) & ~0x00040000U)))
#define HOST_INTF_WORK_AROUND__PCIERST_PORRST_SW_CNTL__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00040000U) | ((u_int32_t)(1) << 18)
#define HOST_INTF_WORK_AROUND__PCIERST_PORRST_SW_CNTL__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00040000U) | ((u_int32_t)(0) << 18)

/* macros for field PCIERST_PORRST_SHIFT */
#define HOST_INTF_WORK_AROUND__PCIERST_PORRST_SHIFT__SHIFT                   20
#define HOST_INTF_WORK_AROUND__PCIERST_PORRST_SHIFT__WIDTH                    1
#define HOST_INTF_WORK_AROUND__PCIERST_PORRST_SHIFT__MASK           0x00100000U
#define HOST_INTF_WORK_AROUND__PCIERST_PORRST_SHIFT__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00100000U) >> 20)
#define HOST_INTF_WORK_AROUND__PCIERST_PORRST_SHIFT__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 20) & 0x00100000U)
#define HOST_INTF_WORK_AROUND__PCIERST_PORRST_SHIFT__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00100000U) | (((u_int32_t)(src) <<\
                    20) & 0x00100000U)
#define HOST_INTF_WORK_AROUND__PCIERST_PORRST_SHIFT__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 20) & ~0x00100000U)))
#define HOST_INTF_WORK_AROUND__PCIERST_PORRST_SHIFT__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00100000U) | ((u_int32_t)(1) << 20)
#define HOST_INTF_WORK_AROUND__PCIERST_PORRST_SHIFT__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00100000U) | ((u_int32_t)(0) << 20)

/* macros for field PCIERST_PORRST_PHY */
#define HOST_INTF_WORK_AROUND__PCIERST_PORRST_PHY__SHIFT                     21
#define HOST_INTF_WORK_AROUND__PCIERST_PORRST_PHY__WIDTH                      1
#define HOST_INTF_WORK_AROUND__PCIERST_PORRST_PHY__MASK             0x00200000U
#define HOST_INTF_WORK_AROUND__PCIERST_PORRST_PHY__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00200000U) >> 21)
#define HOST_INTF_WORK_AROUND__PCIERST_PORRST_PHY__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 21) & 0x00200000U)
#define HOST_INTF_WORK_AROUND__PCIERST_PORRST_PHY__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00200000U) | (((u_int32_t)(src) <<\
                    21) & 0x00200000U)
#define HOST_INTF_WORK_AROUND__PCIERST_PORRST_PHY__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 21) & ~0x00200000U)))
#define HOST_INTF_WORK_AROUND__PCIERST_PORRST_PHY__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00200000U) | ((u_int32_t)(1) << 21)
#define HOST_INTF_WORK_AROUND__PCIERST_PORRST_PHY__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00200000U) | ((u_int32_t)(0) << 21)

/* macros for field PCIE_NFTS_CNTL_EN */
#define HOST_INTF_WORK_AROUND__PCIE_NFTS_CNTL_EN__SHIFT                      23
#define HOST_INTF_WORK_AROUND__PCIE_NFTS_CNTL_EN__WIDTH                       1
#define HOST_INTF_WORK_AROUND__PCIE_NFTS_CNTL_EN__MASK              0x00800000U
#define HOST_INTF_WORK_AROUND__PCIE_NFTS_CNTL_EN__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00800000U) >> 23)
#define HOST_INTF_WORK_AROUND__PCIE_NFTS_CNTL_EN__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 23) & 0x00800000U)
#define HOST_INTF_WORK_AROUND__PCIE_NFTS_CNTL_EN__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00800000U) | (((u_int32_t)(src) <<\
                    23) & 0x00800000U)
#define HOST_INTF_WORK_AROUND__PCIE_NFTS_CNTL_EN__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 23) & ~0x00800000U)))
#define HOST_INTF_WORK_AROUND__PCIE_NFTS_CNTL_EN__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00800000U) | ((u_int32_t)(1) << 23)
#define HOST_INTF_WORK_AROUND__PCIE_NFTS_CNTL_EN__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00800000U) | ((u_int32_t)(0) << 23)

/* macros for field RESET_SERDES_WA_TIMEOUT */
#define HOST_INTF_WORK_AROUND__RESET_SERDES_WA_TIMEOUT__SHIFT                24
#define HOST_INTF_WORK_AROUND__RESET_SERDES_WA_TIMEOUT__WIDTH                 8
#define HOST_INTF_WORK_AROUND__RESET_SERDES_WA_TIMEOUT__MASK        0xff000000U
#define HOST_INTF_WORK_AROUND__RESET_SERDES_WA_TIMEOUT__READ(src) \
                    (((u_int32_t)(src)\
                    & 0xff000000U) >> 24)
#define HOST_INTF_WORK_AROUND__RESET_SERDES_WA_TIMEOUT__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 24) & 0xff000000U)
#define HOST_INTF_WORK_AROUND__RESET_SERDES_WA_TIMEOUT__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xff000000U) | (((u_int32_t)(src) <<\
                    24) & 0xff000000U)
#define HOST_INTF_WORK_AROUND__RESET_SERDES_WA_TIMEOUT__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 24) & ~0xff000000U)))
#define HOST_INTF_WORK_AROUND__TYPE                                   u_int32_t
#define HOST_INTF_WORK_AROUND__READ                                 0xffb7e21fU
#define HOST_INTF_WORK_AROUND__WRITE                                0xffb7e21fU

#endif /* __HOST_INTF_WORK_AROUND_MACRO__ */


/* macros for host_intf_reg_block.HOST_INTF_WORK_AROUND */
#define INST_HOST_INTF_REG_BLOCK__HOST_INTF_WORK_AROUND__NUM                  1

/* macros for BlueprintGlobalNameSpace::HOST_INTF_PM_STATE */
#ifndef __HOST_INTF_PM_STATE_MACRO__
#define __HOST_INTF_PM_STATE_MACRO__

/* macros for field PCIE_PM_XTLH_BLOCK_TLP */
#define HOST_INTF_PM_STATE__PCIE_PM_XTLH_BLOCK_TLP__SHIFT                     0
#define HOST_INTF_PM_STATE__PCIE_PM_XTLH_BLOCK_TLP__WIDTH                     1
#define HOST_INTF_PM_STATE__PCIE_PM_XTLH_BLOCK_TLP__MASK            0x00000001U
#define HOST_INTF_PM_STATE__PCIE_PM_XTLH_BLOCK_TLP__READ(src) \
                    (u_int32_t)(src)\
                    & 0x00000001U
#define HOST_INTF_PM_STATE__PCIE_PM_XTLH_BLOCK_TLP__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(1)
#define HOST_INTF_PM_STATE__PCIE_PM_XTLH_BLOCK_TLP__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(0)

/* macros for field PCIE_PM_CURNT_STATE */
#define HOST_INTF_PM_STATE__PCIE_PM_CURNT_STATE__SHIFT                        1
#define HOST_INTF_PM_STATE__PCIE_PM_CURNT_STATE__WIDTH                        3
#define HOST_INTF_PM_STATE__PCIE_PM_CURNT_STATE__MASK               0x0000000eU
#define HOST_INTF_PM_STATE__PCIE_PM_CURNT_STATE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0000000eU) >> 1)

/* macros for field PCIE_PM_DSTATE */
#define HOST_INTF_PM_STATE__PCIE_PM_DSTATE__SHIFT                             4
#define HOST_INTF_PM_STATE__PCIE_PM_DSTATE__WIDTH                             3
#define HOST_INTF_PM_STATE__PCIE_PM_DSTATE__MASK                    0x00000070U
#define HOST_INTF_PM_STATE__PCIE_PM_DSTATE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000070U) >> 4)

/* macros for field PCIE_PM_PME_EN */
#define HOST_INTF_PM_STATE__PCIE_PM_PME_EN__SHIFT                             7
#define HOST_INTF_PM_STATE__PCIE_PM_PME_EN__WIDTH                             1
#define HOST_INTF_PM_STATE__PCIE_PM_PME_EN__MASK                    0x00000080U
#define HOST_INTF_PM_STATE__PCIE_PM_PME_EN__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000080U) >> 7)
#define HOST_INTF_PM_STATE__PCIE_PM_PME_EN__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000080U) | ((u_int32_t)(1) << 7)
#define HOST_INTF_PM_STATE__PCIE_PM_PME_EN__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000080U) | ((u_int32_t)(0) << 7)

/* macros for field PCIE_PM_STATUS */
#define HOST_INTF_PM_STATE__PCIE_PM_STATUS__SHIFT                             8
#define HOST_INTF_PM_STATE__PCIE_PM_STATUS__WIDTH                             1
#define HOST_INTF_PM_STATE__PCIE_PM_STATUS__MASK                    0x00000100U
#define HOST_INTF_PM_STATE__PCIE_PM_STATUS__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000100U) >> 8)
#define HOST_INTF_PM_STATE__PCIE_PM_STATUS__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000100U) | ((u_int32_t)(1) << 8)
#define HOST_INTF_PM_STATE__PCIE_PM_STATUS__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000100U) | ((u_int32_t)(0) << 8)

/* macros for field PCIE_AUX_PM_EN */
#define HOST_INTF_PM_STATE__PCIE_AUX_PM_EN__SHIFT                             9
#define HOST_INTF_PM_STATE__PCIE_AUX_PM_EN__WIDTH                             1
#define HOST_INTF_PM_STATE__PCIE_AUX_PM_EN__MASK                    0x00000200U
#define HOST_INTF_PM_STATE__PCIE_AUX_PM_EN__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000200U) >> 9)
#define HOST_INTF_PM_STATE__PCIE_AUX_PM_EN__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000200U) | ((u_int32_t)(1) << 9)
#define HOST_INTF_PM_STATE__PCIE_AUX_PM_EN__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000200U) | ((u_int32_t)(0) << 9)

/* macros for field PCIE_XMLH_LTSSM_STATE */
#define HOST_INTF_PM_STATE__PCIE_XMLH_LTSSM_STATE__SHIFT                     10
#define HOST_INTF_PM_STATE__PCIE_XMLH_LTSSM_STATE__WIDTH                      5
#define HOST_INTF_PM_STATE__PCIE_XMLH_LTSSM_STATE__MASK             0x00007c00U
#define HOST_INTF_PM_STATE__PCIE_XMLH_LTSSM_STATE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00007c00U) >> 10)

/* macros for field CLKMISC_MULTI_PIPE_MODE_MAC */
#define HOST_INTF_PM_STATE__CLKMISC_MULTI_PIPE_MODE_MAC__SHIFT               19
#define HOST_INTF_PM_STATE__CLKMISC_MULTI_PIPE_MODE_MAC__WIDTH                1
#define HOST_INTF_PM_STATE__CLKMISC_MULTI_PIPE_MODE_MAC__MASK       0x00080000U
#define HOST_INTF_PM_STATE__CLKMISC_MULTI_PIPE_MODE_MAC__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00080000U) >> 19)
#define HOST_INTF_PM_STATE__CLKMISC_MULTI_PIPE_MODE_MAC__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00080000U) | ((u_int32_t)(1) << 19)
#define HOST_INTF_PM_STATE__CLKMISC_MULTI_PIPE_MODE_MAC__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00080000U) | ((u_int32_t)(0) << 19)

/* macros for field CLKMISC_MULTI_PIPE_MODE_PHY */
#define HOST_INTF_PM_STATE__CLKMISC_MULTI_PIPE_MODE_PHY__SHIFT               20
#define HOST_INTF_PM_STATE__CLKMISC_MULTI_PIPE_MODE_PHY__WIDTH                1
#define HOST_INTF_PM_STATE__CLKMISC_MULTI_PIPE_MODE_PHY__MASK       0x00100000U
#define HOST_INTF_PM_STATE__CLKMISC_MULTI_PIPE_MODE_PHY__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00100000U) >> 20)
#define HOST_INTF_PM_STATE__CLKMISC_MULTI_PIPE_MODE_PHY__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00100000U) | ((u_int32_t)(1) << 20)
#define HOST_INTF_PM_STATE__CLKMISC_MULTI_PIPE_MODE_PHY__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00100000U) | ((u_int32_t)(0) << 20)

/* macros for field CLKMISC_MULTI_PCIE_PHY_TEST */
#define HOST_INTF_PM_STATE__CLKMISC_MULTI_PCIE_PHY_TEST__SHIFT               21
#define HOST_INTF_PM_STATE__CLKMISC_MULTI_PCIE_PHY_TEST__WIDTH                1
#define HOST_INTF_PM_STATE__CLKMISC_MULTI_PCIE_PHY_TEST__MASK       0x00200000U
#define HOST_INTF_PM_STATE__CLKMISC_MULTI_PCIE_PHY_TEST__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00200000U) >> 21)
#define HOST_INTF_PM_STATE__CLKMISC_MULTI_PCIE_PHY_TEST__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00200000U) | ((u_int32_t)(1) << 21)
#define HOST_INTF_PM_STATE__CLKMISC_MULTI_PCIE_PHY_TEST__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00200000U) | ((u_int32_t)(0) << 21)
#define HOST_INTF_PM_STATE__TYPE                                      u_int32_t
#define HOST_INTF_PM_STATE__READ                                    0x00387fffU

#endif /* __HOST_INTF_PM_STATE_MACRO__ */


/* macros for host_intf_reg_block.HOST_INTF_PM_STATE */
#define INST_HOST_INTF_REG_BLOCK__HOST_INTF_PM_STATE__NUM                     1

/* macros for BlueprintGlobalNameSpace::HOST_INTF_CXPL_DEBUG_INFOL */
#ifndef __HOST_INTF_CXPL_DEBUG_INFOL_MACRO__
#define __HOST_INTF_CXPL_DEBUG_INFOL_MACRO__

/* macros for field DATA */
#define HOST_INTF_CXPL_DEBUG_INFOL__DATA__SHIFT                               0
#define HOST_INTF_CXPL_DEBUG_INFOL__DATA__WIDTH                              32
#define HOST_INTF_CXPL_DEBUG_INFOL__DATA__MASK                      0xffffffffU
#define HOST_INTF_CXPL_DEBUG_INFOL__DATA__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define HOST_INTF_CXPL_DEBUG_INFOL__TYPE                              u_int32_t
#define HOST_INTF_CXPL_DEBUG_INFOL__READ                            0xffffffffU

#endif /* __HOST_INTF_CXPL_DEBUG_INFOL_MACRO__ */


/* macros for host_intf_reg_block.HOST_INTF_CXPL_DEBUG_INFOL */
#define INST_HOST_INTF_REG_BLOCK__HOST_INTF_CXPL_DEBUG_INFOL__NUM             1

/* macros for BlueprintGlobalNameSpace::HOST_INTF_CXPL_DEBUG_INFOH */
#ifndef __HOST_INTF_CXPL_DEBUG_INFOH_MACRO__
#define __HOST_INTF_CXPL_DEBUG_INFOH_MACRO__

/* macros for field DATA */
#define HOST_INTF_CXPL_DEBUG_INFOH__DATA__SHIFT                               0
#define HOST_INTF_CXPL_DEBUG_INFOH__DATA__WIDTH                              32
#define HOST_INTF_CXPL_DEBUG_INFOH__DATA__MASK                      0xffffffffU
#define HOST_INTF_CXPL_DEBUG_INFOH__DATA__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define HOST_INTF_CXPL_DEBUG_INFOH__TYPE                              u_int32_t
#define HOST_INTF_CXPL_DEBUG_INFOH__READ                            0xffffffffU

#endif /* __HOST_INTF_CXPL_DEBUG_INFOH_MACRO__ */


/* macros for host_intf_reg_block.HOST_INTF_CXPL_DEBUG_INFOH */
#define INST_HOST_INTF_REG_BLOCK__HOST_INTF_CXPL_DEBUG_INFOH__NUM             1

/* macros for BlueprintGlobalNameSpace::HOST_INTF_PM_CTRL */
#ifndef __HOST_INTF_PM_CTRL_MACRO__
#define __HOST_INTF_PM_CTRL_MACRO__

/* macros for field PCIE_PM_OVERRIDE */
#define HOST_INTF_PM_CTRL__PCIE_PM_OVERRIDE__SHIFT                            0
#define HOST_INTF_PM_CTRL__PCIE_PM_OVERRIDE__WIDTH                            1
#define HOST_INTF_PM_CTRL__PCIE_PM_OVERRIDE__MASK                   0x00000001U
#define HOST_INTF_PM_CTRL__PCIE_PM_OVERRIDE__READ(src) \
                    (u_int32_t)(src)\
                    & 0x00000001U
#define HOST_INTF_PM_CTRL__PCIE_PM_OVERRIDE__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x00000001U)
#define HOST_INTF_PM_CTRL__PCIE_PM_OVERRIDE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | ((u_int32_t)(src) &\
                    0x00000001U)
#define HOST_INTF_PM_CTRL__PCIE_PM_OVERRIDE__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00000001U)))
#define HOST_INTF_PM_CTRL__PCIE_PM_OVERRIDE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(1)
#define HOST_INTF_PM_CTRL__PCIE_PM_OVERRIDE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(0)

/* macros for field PCIE_PM_DELAY */
#define HOST_INTF_PM_CTRL__PCIE_PM_DELAY__SHIFT                               2
#define HOST_INTF_PM_CTRL__PCIE_PM_DELAY__WIDTH                              16
#define HOST_INTF_PM_CTRL__PCIE_PM_DELAY__MASK                      0x0003fffcU
#define HOST_INTF_PM_CTRL__PCIE_PM_DELAY__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0003fffcU) >> 2)
#define HOST_INTF_PM_CTRL__PCIE_PM_DELAY__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 2) & 0x0003fffcU)
#define HOST_INTF_PM_CTRL__PCIE_PM_DELAY__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0003fffcU) | (((u_int32_t)(src) <<\
                    2) & 0x0003fffcU)
#define HOST_INTF_PM_CTRL__PCIE_PM_DELAY__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 2) & ~0x0003fffcU)))

/* macros for field PCIE_PM_DISABLE */
#define HOST_INTF_PM_CTRL__PCIE_PM_DISABLE__SHIFT                            18
#define HOST_INTF_PM_CTRL__PCIE_PM_DISABLE__WIDTH                             1
#define HOST_INTF_PM_CTRL__PCIE_PM_DISABLE__MASK                    0x00040000U
#define HOST_INTF_PM_CTRL__PCIE_PM_DISABLE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00040000U) >> 18)
#define HOST_INTF_PM_CTRL__PCIE_PM_DISABLE__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 18) & 0x00040000U)
#define HOST_INTF_PM_CTRL__PCIE_PM_DISABLE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00040000U) | (((u_int32_t)(src) <<\
                    18) & 0x00040000U)
#define HOST_INTF_PM_CTRL__PCIE_PM_DISABLE__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 18) & ~0x00040000U)))
#define HOST_INTF_PM_CTRL__PCIE_PM_DISABLE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00040000U) | ((u_int32_t)(1) << 18)
#define HOST_INTF_PM_CTRL__PCIE_PM_DISABLE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00040000U) | ((u_int32_t)(0) << 18)

/* macros for field PCIE_ENTER_L1_EN */
#define HOST_INTF_PM_CTRL__PCIE_ENTER_L1_EN__SHIFT                           19
#define HOST_INTF_PM_CTRL__PCIE_ENTER_L1_EN__WIDTH                            1
#define HOST_INTF_PM_CTRL__PCIE_ENTER_L1_EN__MASK                   0x00080000U
#define HOST_INTF_PM_CTRL__PCIE_ENTER_L1_EN__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00080000U) >> 19)
#define HOST_INTF_PM_CTRL__PCIE_ENTER_L1_EN__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 19) & 0x00080000U)
#define HOST_INTF_PM_CTRL__PCIE_ENTER_L1_EN__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00080000U) | (((u_int32_t)(src) <<\
                    19) & 0x00080000U)
#define HOST_INTF_PM_CTRL__PCIE_ENTER_L1_EN__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 19) & ~0x00080000U)))
#define HOST_INTF_PM_CTRL__PCIE_ENTER_L1_EN__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00080000U) | ((u_int32_t)(1) << 19)
#define HOST_INTF_PM_CTRL__PCIE_ENTER_L1_EN__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00080000U) | ((u_int32_t)(0) << 19)

/* macros for field PCIE_PME_DISABLE_CLK */
#define HOST_INTF_PM_CTRL__PCIE_PME_DISABLE_CLK__SHIFT                       20
#define HOST_INTF_PM_CTRL__PCIE_PME_DISABLE_CLK__WIDTH                        1
#define HOST_INTF_PM_CTRL__PCIE_PME_DISABLE_CLK__MASK               0x00100000U
#define HOST_INTF_PM_CTRL__PCIE_PME_DISABLE_CLK__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00100000U) >> 20)
#define HOST_INTF_PM_CTRL__PCIE_PME_DISABLE_CLK__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 20) & 0x00100000U)
#define HOST_INTF_PM_CTRL__PCIE_PME_DISABLE_CLK__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00100000U) | (((u_int32_t)(src) <<\
                    20) & 0x00100000U)
#define HOST_INTF_PM_CTRL__PCIE_PME_DISABLE_CLK__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 20) & ~0x00100000U)))
#define HOST_INTF_PM_CTRL__PCIE_PME_DISABLE_CLK__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00100000U) | ((u_int32_t)(1) << 20)
#define HOST_INTF_PM_CTRL__PCIE_PME_DISABLE_CLK__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00100000U) | ((u_int32_t)(0) << 20)

/* macros for field HOST_MAC_WOW_CLEAR */
#define HOST_INTF_PM_CTRL__HOST_MAC_WOW_CLEAR__SHIFT                         21
#define HOST_INTF_PM_CTRL__HOST_MAC_WOW_CLEAR__WIDTH                          1
#define HOST_INTF_PM_CTRL__HOST_MAC_WOW_CLEAR__MASK                 0x00200000U
#define HOST_INTF_PM_CTRL__HOST_MAC_WOW_CLEAR__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00200000U) >> 21)
#define HOST_INTF_PM_CTRL__HOST_MAC_WOW_CLEAR__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 21) & 0x00200000U)
#define HOST_INTF_PM_CTRL__HOST_MAC_WOW_CLEAR__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00200000U) | (((u_int32_t)(src) <<\
                    21) & 0x00200000U)
#define HOST_INTF_PM_CTRL__HOST_MAC_WOW_CLEAR__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 21) & ~0x00200000U)))
#define HOST_INTF_PM_CTRL__HOST_MAC_WOW_CLEAR__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00200000U) | ((u_int32_t)(1) << 21)
#define HOST_INTF_PM_CTRL__HOST_MAC_WOW_CLEAR__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00200000U) | ((u_int32_t)(0) << 21)

/* macros for field HOST_PME_ENABLE */
#define HOST_INTF_PM_CTRL__HOST_PME_ENABLE__SHIFT                            22
#define HOST_INTF_PM_CTRL__HOST_PME_ENABLE__WIDTH                             1
#define HOST_INTF_PM_CTRL__HOST_PME_ENABLE__MASK                    0x00400000U
#define HOST_INTF_PM_CTRL__HOST_PME_ENABLE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00400000U) >> 22)
#define HOST_INTF_PM_CTRL__HOST_PME_ENABLE__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 22) & 0x00400000U)
#define HOST_INTF_PM_CTRL__HOST_PME_ENABLE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00400000U) | (((u_int32_t)(src) <<\
                    22) & 0x00400000U)
#define HOST_INTF_PM_CTRL__HOST_PME_ENABLE__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 22) & ~0x00400000U)))
#define HOST_INTF_PM_CTRL__HOST_PME_ENABLE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00400000U) | ((u_int32_t)(1) << 22)
#define HOST_INTF_PM_CTRL__HOST_PME_ENABLE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00400000U) | ((u_int32_t)(0) << 22)

/* macros for field PME_POWER_STATE_MASK */
#define HOST_INTF_PM_CTRL__PME_POWER_STATE_MASK__SHIFT                       24
#define HOST_INTF_PM_CTRL__PME_POWER_STATE_MASK__WIDTH                        4
#define HOST_INTF_PM_CTRL__PME_POWER_STATE_MASK__MASK               0x0f000000U
#define HOST_INTF_PM_CTRL__PME_POWER_STATE_MASK__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0f000000U) >> 24)
#define HOST_INTF_PM_CTRL__PME_POWER_STATE_MASK__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 24) & 0x0f000000U)
#define HOST_INTF_PM_CTRL__PME_POWER_STATE_MASK__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0f000000U) | (((u_int32_t)(src) <<\
                    24) & 0x0f000000U)
#define HOST_INTF_PM_CTRL__PME_POWER_STATE_MASK__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 24) & ~0x0f000000U)))

/* macros for field SYS_AUX_PWR_DET */
#define HOST_INTF_PM_CTRL__SYS_AUX_PWR_DET__SHIFT                            28
#define HOST_INTF_PM_CTRL__SYS_AUX_PWR_DET__WIDTH                             1
#define HOST_INTF_PM_CTRL__SYS_AUX_PWR_DET__MASK                    0x10000000U
#define HOST_INTF_PM_CTRL__SYS_AUX_PWR_DET__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x10000000U) >> 28)
#define HOST_INTF_PM_CTRL__SYS_AUX_PWR_DET__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 28) & 0x10000000U)
#define HOST_INTF_PM_CTRL__SYS_AUX_PWR_DET__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x10000000U) | (((u_int32_t)(src) <<\
                    28) & 0x10000000U)
#define HOST_INTF_PM_CTRL__SYS_AUX_PWR_DET__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 28) & ~0x10000000U)))
#define HOST_INTF_PM_CTRL__SYS_AUX_PWR_DET__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x10000000U) | ((u_int32_t)(1) << 28)
#define HOST_INTF_PM_CTRL__SYS_AUX_PWR_DET__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x10000000U) | ((u_int32_t)(0) << 28)

/* macros for field PCIE_PWDBIAS_OVRD */
#define HOST_INTF_PM_CTRL__PCIE_PWDBIAS_OVRD__SHIFT                          29
#define HOST_INTF_PM_CTRL__PCIE_PWDBIAS_OVRD__WIDTH                           1
#define HOST_INTF_PM_CTRL__PCIE_PWDBIAS_OVRD__MASK                  0x20000000U
#define HOST_INTF_PM_CTRL__PCIE_PWDBIAS_OVRD__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x20000000U) >> 29)
#define HOST_INTF_PM_CTRL__PCIE_PWDBIAS_OVRD__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 29) & 0x20000000U)
#define HOST_INTF_PM_CTRL__PCIE_PWDBIAS_OVRD__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x20000000U) | (((u_int32_t)(src) <<\
                    29) & 0x20000000U)
#define HOST_INTF_PM_CTRL__PCIE_PWDBIAS_OVRD__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 29) & ~0x20000000U)))
#define HOST_INTF_PM_CTRL__PCIE_PWDBIAS_OVRD__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x20000000U) | ((u_int32_t)(1) << 29)
#define HOST_INTF_PM_CTRL__PCIE_PWDBIAS_OVRD__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x20000000U) | ((u_int32_t)(0) << 29)

/* macros for field PCIE_CLKREQ_OVRD */
#define HOST_INTF_PM_CTRL__PCIE_CLKREQ_OVRD__SHIFT                           30
#define HOST_INTF_PM_CTRL__PCIE_CLKREQ_OVRD__WIDTH                            1
#define HOST_INTF_PM_CTRL__PCIE_CLKREQ_OVRD__MASK                   0x40000000U
#define HOST_INTF_PM_CTRL__PCIE_CLKREQ_OVRD__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x40000000U) >> 30)
#define HOST_INTF_PM_CTRL__PCIE_CLKREQ_OVRD__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 30) & 0x40000000U)
#define HOST_INTF_PM_CTRL__PCIE_CLKREQ_OVRD__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x40000000U) | (((u_int32_t)(src) <<\
                    30) & 0x40000000U)
#define HOST_INTF_PM_CTRL__PCIE_CLKREQ_OVRD__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 30) & ~0x40000000U)))
#define HOST_INTF_PM_CTRL__PCIE_CLKREQ_OVRD__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x40000000U) | ((u_int32_t)(1) << 30)
#define HOST_INTF_PM_CTRL__PCIE_CLKREQ_OVRD__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x40000000U) | ((u_int32_t)(0) << 30)
#define HOST_INTF_PM_CTRL__TYPE                                       u_int32_t
#define HOST_INTF_PM_CTRL__READ                                     0x7f7ffffdU
#define HOST_INTF_PM_CTRL__WRITE                                    0x7f7ffffdU

#endif /* __HOST_INTF_PM_CTRL_MACRO__ */


/* macros for host_intf_reg_block.HOST_INTF_PM_CTRL */
#define INST_HOST_INTF_REG_BLOCK__HOST_INTF_PM_CTRL__NUM                      1

/* macros for BlueprintGlobalNameSpace::HOST_INTF_TIMEOUT */
#ifndef __HOST_INTF_TIMEOUT_MACRO__
#define __HOST_INTF_TIMEOUT_MACRO__

/* macros for field APB_TIMEOUT_VAL */
#define HOST_INTF_TIMEOUT__APB_TIMEOUT_VAL__SHIFT                             0
#define HOST_INTF_TIMEOUT__APB_TIMEOUT_VAL__WIDTH                            16
#define HOST_INTF_TIMEOUT__APB_TIMEOUT_VAL__MASK                    0x0000ffffU
#define HOST_INTF_TIMEOUT__APB_TIMEOUT_VAL__READ(src) \
                    (u_int32_t)(src)\
                    & 0x0000ffffU
#define HOST_INTF_TIMEOUT__APB_TIMEOUT_VAL__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x0000ffffU)
#define HOST_INTF_TIMEOUT__APB_TIMEOUT_VAL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000ffffU) | ((u_int32_t)(src) &\
                    0x0000ffffU)
#define HOST_INTF_TIMEOUT__APB_TIMEOUT_VAL__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x0000ffffU)))

/* macros for field AXI_TIMEOUT_VAL */
#define HOST_INTF_TIMEOUT__AXI_TIMEOUT_VAL__SHIFT                            16
#define HOST_INTF_TIMEOUT__AXI_TIMEOUT_VAL__WIDTH                            16
#define HOST_INTF_TIMEOUT__AXI_TIMEOUT_VAL__MASK                    0xffff0000U
#define HOST_INTF_TIMEOUT__AXI_TIMEOUT_VAL__READ(src) \
                    (((u_int32_t)(src)\
                    & 0xffff0000U) >> 16)
#define HOST_INTF_TIMEOUT__AXI_TIMEOUT_VAL__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 16) & 0xffff0000U)
#define HOST_INTF_TIMEOUT__AXI_TIMEOUT_VAL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xffff0000U) | (((u_int32_t)(src) <<\
                    16) & 0xffff0000U)
#define HOST_INTF_TIMEOUT__AXI_TIMEOUT_VAL__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 16) & ~0xffff0000U)))
#define HOST_INTF_TIMEOUT__TYPE                                       u_int32_t
#define HOST_INTF_TIMEOUT__READ                                     0xffffffffU
#define HOST_INTF_TIMEOUT__WRITE                                    0xffffffffU

#endif /* __HOST_INTF_TIMEOUT_MACRO__ */


/* macros for host_intf_reg_block.HOST_INTF_TIMEOUT */
#define INST_HOST_INTF_REG_BLOCK__HOST_INTF_TIMEOUT__NUM                      1

/* macros for BlueprintGlobalNameSpace::HOST_INTF_EEPROM_CTRL */
#ifndef __HOST_INTF_EEPROM_CTRL_MACRO__
#define __HOST_INTF_EEPROM_CTRL_MACRO__

/* macros for field FAST_FLASH_MODE */
#define HOST_INTF_EEPROM_CTRL__FAST_FLASH_MODE__SHIFT                         0
#define HOST_INTF_EEPROM_CTRL__FAST_FLASH_MODE__WIDTH                         1
#define HOST_INTF_EEPROM_CTRL__FAST_FLASH_MODE__MASK                0x00000001U
#define HOST_INTF_EEPROM_CTRL__FAST_FLASH_MODE__READ(src) \
                    (u_int32_t)(src)\
                    & 0x00000001U
#define HOST_INTF_EEPROM_CTRL__FAST_FLASH_MODE__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x00000001U)
#define HOST_INTF_EEPROM_CTRL__FAST_FLASH_MODE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | ((u_int32_t)(src) &\
                    0x00000001U)
#define HOST_INTF_EEPROM_CTRL__FAST_FLASH_MODE__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00000001U)))
#define HOST_INTF_EEPROM_CTRL__FAST_FLASH_MODE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(1)
#define HOST_INTF_EEPROM_CTRL__FAST_FLASH_MODE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(0)

/* macros for field FORCE_RESET */
#define HOST_INTF_EEPROM_CTRL__FORCE_RESET__SHIFT                             1
#define HOST_INTF_EEPROM_CTRL__FORCE_RESET__WIDTH                             1
#define HOST_INTF_EEPROM_CTRL__FORCE_RESET__MASK                    0x00000002U
#define HOST_INTF_EEPROM_CTRL__FORCE_RESET__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000002U) >> 1)
#define HOST_INTF_EEPROM_CTRL__FORCE_RESET__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 1) & 0x00000002U)
#define HOST_INTF_EEPROM_CTRL__FORCE_RESET__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | (((u_int32_t)(src) <<\
                    1) & 0x00000002U)
#define HOST_INTF_EEPROM_CTRL__FORCE_RESET__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 1) & ~0x00000002U)))
#define HOST_INTF_EEPROM_CTRL__FORCE_RESET__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | ((u_int32_t)(1) << 1)
#define HOST_INTF_EEPROM_CTRL__FORCE_RESET__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | ((u_int32_t)(0) << 1)

/* macros for field CLKDIV_RST_VAL */
#define HOST_INTF_EEPROM_CTRL__CLKDIV_RST_VAL__SHIFT                          2
#define HOST_INTF_EEPROM_CTRL__CLKDIV_RST_VAL__WIDTH                          6
#define HOST_INTF_EEPROM_CTRL__CLKDIV_RST_VAL__MASK                 0x000000fcU
#define HOST_INTF_EEPROM_CTRL__CLKDIV_RST_VAL__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x000000fcU) >> 2)
#define HOST_INTF_EEPROM_CTRL__CLKDIV_RST_VAL__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 2) & 0x000000fcU)
#define HOST_INTF_EEPROM_CTRL__CLKDIV_RST_VAL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000000fcU) | (((u_int32_t)(src) <<\
                    2) & 0x000000fcU)
#define HOST_INTF_EEPROM_CTRL__CLKDIV_RST_VAL__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 2) & ~0x000000fcU)))

/* macros for field NOT_PRESENT */
#define HOST_INTF_EEPROM_CTRL__NOT_PRESENT__SHIFT                             8
#define HOST_INTF_EEPROM_CTRL__NOT_PRESENT__WIDTH                             1
#define HOST_INTF_EEPROM_CTRL__NOT_PRESENT__MASK                    0x00000100U
#define HOST_INTF_EEPROM_CTRL__NOT_PRESENT__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000100U) >> 8)
#define HOST_INTF_EEPROM_CTRL__NOT_PRESENT__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000100U) | ((u_int32_t)(1) << 8)
#define HOST_INTF_EEPROM_CTRL__NOT_PRESENT__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000100U) | ((u_int32_t)(0) << 8)

/* macros for field IS_CORRUPT */
#define HOST_INTF_EEPROM_CTRL__IS_CORRUPT__SHIFT                              9
#define HOST_INTF_EEPROM_CTRL__IS_CORRUPT__WIDTH                              1
#define HOST_INTF_EEPROM_CTRL__IS_CORRUPT__MASK                     0x00000200U
#define HOST_INTF_EEPROM_CTRL__IS_CORRUPT__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000200U) >> 9)
#define HOST_INTF_EEPROM_CTRL__IS_CORRUPT__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000200U) | ((u_int32_t)(1) << 9)
#define HOST_INTF_EEPROM_CTRL__IS_CORRUPT__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000200U) | ((u_int32_t)(0) << 9)

/* macros for field PROTECT */
#define HOST_INTF_EEPROM_CTRL__PROTECT__SHIFT                                10
#define HOST_INTF_EEPROM_CTRL__PROTECT__WIDTH                                16
#define HOST_INTF_EEPROM_CTRL__PROTECT__MASK                        0x03fffc00U
#define HOST_INTF_EEPROM_CTRL__PROTECT__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x03fffc00U) >> 10)
#define HOST_INTF_EEPROM_CTRL__TYPE                                   u_int32_t
#define HOST_INTF_EEPROM_CTRL__READ                                 0x03ffffffU
#define HOST_INTF_EEPROM_CTRL__WRITE                                0x03ffffffU

#endif /* __HOST_INTF_EEPROM_CTRL_MACRO__ */


/* macros for host_intf_reg_block.HOST_INTF_EEPROM_CTRL */
#define INST_HOST_INTF_REG_BLOCK__HOST_INTF_EEPROM_CTRL__NUM                  1

/* macros for BlueprintGlobalNameSpace::HOST_INTF_SREV */
#ifndef __HOST_INTF_SREV_MACRO__
#define __HOST_INTF_SREV_MACRO__

/* macros for field MAC_ID */
#define HOST_INTF_SREV__MAC_ID__SHIFT                                         0
#define HOST_INTF_SREV__MAC_ID__WIDTH                                        32
#define HOST_INTF_SREV__MAC_ID__MASK                                0xffffffffU
#define HOST_INTF_SREV__MAC_ID__READ(src)        (u_int32_t)(src) & 0xffffffffU
#define HOST_INTF_SREV__TYPE                                          u_int32_t
#define HOST_INTF_SREV__READ                                        0xffffffffU

#endif /* __HOST_INTF_SREV_MACRO__ */


/* macros for host_intf_reg_block.HOST_INTF_SREV */
#define INST_HOST_INTF_REG_BLOCK__HOST_INTF_SREV__NUM                         1

/* macros for BlueprintGlobalNameSpace::HOST_INTF_INTR_SYNC_CAUSE */
#ifndef __HOST_INTF_INTR_SYNC_CAUSE_MACRO__
#define __HOST_INTF_INTR_SYNC_CAUSE_MACRO__

/* macros for field DATA */
#define HOST_INTF_INTR_SYNC_CAUSE__DATA__SHIFT                                0
#define HOST_INTF_INTR_SYNC_CAUSE__DATA__WIDTH                               32
#define HOST_INTF_INTR_SYNC_CAUSE__DATA__MASK                       0xffffffffU
#define HOST_INTF_INTR_SYNC_CAUSE__DATA__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define HOST_INTF_INTR_SYNC_CAUSE__DATA__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0xffffffffU)
#define HOST_INTF_INTR_SYNC_CAUSE__DATA__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xffffffffU) | ((u_int32_t)(src) &\
                    0xffffffffU)
#define HOST_INTF_INTR_SYNC_CAUSE__DATA__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0xffffffffU)))
#define HOST_INTF_INTR_SYNC_CAUSE__TYPE                               u_int32_t
#define HOST_INTF_INTR_SYNC_CAUSE__READ                             0xffffffffU
#define HOST_INTF_INTR_SYNC_CAUSE__WRITE                            0xffffffffU

#endif /* __HOST_INTF_INTR_SYNC_CAUSE_MACRO__ */


/* macros for host_intf_reg_block.HOST_INTF_INTR_SYNC_CAUSE */
#define INST_HOST_INTF_REG_BLOCK__HOST_INTF_INTR_SYNC_CAUSE__NUM              1

/* macros for BlueprintGlobalNameSpace::HOST_INTF_INTR_SYNC_ENABLE */
#ifndef __HOST_INTF_INTR_SYNC_ENABLE_MACRO__
#define __HOST_INTF_INTR_SYNC_ENABLE_MACRO__

/* macros for field DATA */
#define HOST_INTF_INTR_SYNC_ENABLE__DATA__SHIFT                               0
#define HOST_INTF_INTR_SYNC_ENABLE__DATA__WIDTH                              32
#define HOST_INTF_INTR_SYNC_ENABLE__DATA__MASK                      0xffffffffU
#define HOST_INTF_INTR_SYNC_ENABLE__DATA__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define HOST_INTF_INTR_SYNC_ENABLE__DATA__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0xffffffffU)
#define HOST_INTF_INTR_SYNC_ENABLE__DATA__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xffffffffU) | ((u_int32_t)(src) &\
                    0xffffffffU)
#define HOST_INTF_INTR_SYNC_ENABLE__DATA__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0xffffffffU)))
#define HOST_INTF_INTR_SYNC_ENABLE__TYPE                              u_int32_t
#define HOST_INTF_INTR_SYNC_ENABLE__READ                            0xffffffffU
#define HOST_INTF_INTR_SYNC_ENABLE__WRITE                           0xffffffffU

#endif /* __HOST_INTF_INTR_SYNC_ENABLE_MACRO__ */


/* macros for host_intf_reg_block.HOST_INTF_INTR_SYNC_ENABLE */
#define INST_HOST_INTF_REG_BLOCK__HOST_INTF_INTR_SYNC_ENABLE__NUM             1

/* macros for BlueprintGlobalNameSpace::HOST_INTF_INTR_ASYNC_MASK */
#ifndef __HOST_INTF_INTR_ASYNC_MASK_MACRO__
#define __HOST_INTF_INTR_ASYNC_MASK_MACRO__

/* macros for field DATA */
#define HOST_INTF_INTR_ASYNC_MASK__DATA__SHIFT                                0
#define HOST_INTF_INTR_ASYNC_MASK__DATA__WIDTH                               32
#define HOST_INTF_INTR_ASYNC_MASK__DATA__MASK                       0xffffffffU
#define HOST_INTF_INTR_ASYNC_MASK__DATA__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define HOST_INTF_INTR_ASYNC_MASK__DATA__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0xffffffffU)
#define HOST_INTF_INTR_ASYNC_MASK__DATA__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xffffffffU) | ((u_int32_t)(src) &\
                    0xffffffffU)
#define HOST_INTF_INTR_ASYNC_MASK__DATA__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0xffffffffU)))
#define HOST_INTF_INTR_ASYNC_MASK__TYPE                               u_int32_t
#define HOST_INTF_INTR_ASYNC_MASK__READ                             0xffffffffU
#define HOST_INTF_INTR_ASYNC_MASK__WRITE                            0xffffffffU

#endif /* __HOST_INTF_INTR_ASYNC_MASK_MACRO__ */


/* macros for host_intf_reg_block.HOST_INTF_INTR_ASYNC_MASK */
#define INST_HOST_INTF_REG_BLOCK__HOST_INTF_INTR_ASYNC_MASK__NUM              1

/* macros for BlueprintGlobalNameSpace::HOST_INTF_INTR_SYNC_MASK */
#ifndef __HOST_INTF_INTR_SYNC_MASK_MACRO__
#define __HOST_INTF_INTR_SYNC_MASK_MACRO__

/* macros for field DATA */
#define HOST_INTF_INTR_SYNC_MASK__DATA__SHIFT                                 0
#define HOST_INTF_INTR_SYNC_MASK__DATA__WIDTH                                32
#define HOST_INTF_INTR_SYNC_MASK__DATA__MASK                        0xffffffffU
#define HOST_INTF_INTR_SYNC_MASK__DATA__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define HOST_INTF_INTR_SYNC_MASK__DATA__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0xffffffffU)
#define HOST_INTF_INTR_SYNC_MASK__DATA__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xffffffffU) | ((u_int32_t)(src) &\
                    0xffffffffU)
#define HOST_INTF_INTR_SYNC_MASK__DATA__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0xffffffffU)))
#define HOST_INTF_INTR_SYNC_MASK__TYPE                                u_int32_t
#define HOST_INTF_INTR_SYNC_MASK__READ                              0xffffffffU
#define HOST_INTF_INTR_SYNC_MASK__WRITE                             0xffffffffU

#endif /* __HOST_INTF_INTR_SYNC_MASK_MACRO__ */


/* macros for host_intf_reg_block.HOST_INTF_INTR_SYNC_MASK */
#define INST_HOST_INTF_REG_BLOCK__HOST_INTF_INTR_SYNC_MASK__NUM               1

/* macros for BlueprintGlobalNameSpace::HOST_INTF_INTR_ASYNC_CAUSE */
#ifndef __HOST_INTF_INTR_ASYNC_CAUSE_MACRO__
#define __HOST_INTF_INTR_ASYNC_CAUSE_MACRO__

/* macros for field DATA */
#define HOST_INTF_INTR_ASYNC_CAUSE__DATA__SHIFT                               0
#define HOST_INTF_INTR_ASYNC_CAUSE__DATA__WIDTH                              32
#define HOST_INTF_INTR_ASYNC_CAUSE__DATA__MASK                      0xffffffffU
#define HOST_INTF_INTR_ASYNC_CAUSE__DATA__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define HOST_INTF_INTR_ASYNC_CAUSE__TYPE                              u_int32_t
#define HOST_INTF_INTR_ASYNC_CAUSE__READ                            0xffffffffU

#endif /* __HOST_INTF_INTR_ASYNC_CAUSE_MACRO__ */


/* macros for host_intf_reg_block.HOST_INTF_INTR_ASYNC_CAUSE */
#define INST_HOST_INTF_REG_BLOCK__HOST_INTF_INTR_ASYNC_CAUSE__NUM             1

/* macros for BlueprintGlobalNameSpace::HOST_INTF_INTR_ASYNC_ENABLE */
#ifndef __HOST_INTF_INTR_ASYNC_ENABLE_MACRO__
#define __HOST_INTF_INTR_ASYNC_ENABLE_MACRO__

/* macros for field DATA */
#define HOST_INTF_INTR_ASYNC_ENABLE__DATA__SHIFT                              0
#define HOST_INTF_INTR_ASYNC_ENABLE__DATA__WIDTH                             32
#define HOST_INTF_INTR_ASYNC_ENABLE__DATA__MASK                     0xffffffffU
#define HOST_INTF_INTR_ASYNC_ENABLE__DATA__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define HOST_INTF_INTR_ASYNC_ENABLE__DATA__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0xffffffffU)
#define HOST_INTF_INTR_ASYNC_ENABLE__DATA__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xffffffffU) | ((u_int32_t)(src) &\
                    0xffffffffU)
#define HOST_INTF_INTR_ASYNC_ENABLE__DATA__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0xffffffffU)))
#define HOST_INTF_INTR_ASYNC_ENABLE__TYPE                             u_int32_t
#define HOST_INTF_INTR_ASYNC_ENABLE__READ                           0xffffffffU
#define HOST_INTF_INTR_ASYNC_ENABLE__WRITE                          0xffffffffU

#endif /* __HOST_INTF_INTR_ASYNC_ENABLE_MACRO__ */


/* macros for host_intf_reg_block.HOST_INTF_INTR_ASYNC_ENABLE */
#define INST_HOST_INTF_REG_BLOCK__HOST_INTF_INTR_ASYNC_ENABLE__NUM            1

/* macros for BlueprintGlobalNameSpace::HOST_INTF_PCIE_PHY_RW */
#ifndef __HOST_INTF_PCIE_PHY_RW_MACRO__
#define __HOST_INTF_PCIE_PHY_RW_MACRO__

/* macros for field DATA */
#define HOST_INTF_PCIE_PHY_RW__DATA__SHIFT                                    0
#define HOST_INTF_PCIE_PHY_RW__DATA__WIDTH                                   32
#define HOST_INTF_PCIE_PHY_RW__DATA__MASK                           0xffffffffU
#define HOST_INTF_PCIE_PHY_RW__DATA__READ(src)   (u_int32_t)(src) & 0xffffffffU
#define HOST_INTF_PCIE_PHY_RW__DATA__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0xffffffffU)
#define HOST_INTF_PCIE_PHY_RW__DATA__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xffffffffU) | ((u_int32_t)(src) &\
                    0xffffffffU)
#define HOST_INTF_PCIE_PHY_RW__DATA__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0xffffffffU)))
#define HOST_INTF_PCIE_PHY_RW__TYPE                                   u_int32_t
#define HOST_INTF_PCIE_PHY_RW__READ                                 0xffffffffU
#define HOST_INTF_PCIE_PHY_RW__WRITE                                0xffffffffU

#endif /* __HOST_INTF_PCIE_PHY_RW_MACRO__ */


/* macros for host_intf_reg_block.HOST_INTF_PCIE_PHY_RW */
#define INST_HOST_INTF_REG_BLOCK__HOST_INTF_PCIE_PHY_RW__NUM                  1

/* macros for BlueprintGlobalNameSpace::HOST_INTF_PCIE_PHY_LOAD */
#ifndef __HOST_INTF_PCIE_PHY_LOAD_MACRO__
#define __HOST_INTF_PCIE_PHY_LOAD_MACRO__

/* macros for field DATA */
#define HOST_INTF_PCIE_PHY_LOAD__DATA__SHIFT                                  0
#define HOST_INTF_PCIE_PHY_LOAD__DATA__WIDTH                                 32
#define HOST_INTF_PCIE_PHY_LOAD__DATA__MASK                         0xffffffffU
#define HOST_INTF_PCIE_PHY_LOAD__DATA__READ(src) (u_int32_t)(src) & 0xffffffffU
#define HOST_INTF_PCIE_PHY_LOAD__DATA__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0xffffffffU)
#define HOST_INTF_PCIE_PHY_LOAD__DATA__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xffffffffU) | ((u_int32_t)(src) &\
                    0xffffffffU)
#define HOST_INTF_PCIE_PHY_LOAD__DATA__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0xffffffffU)))
#define HOST_INTF_PCIE_PHY_LOAD__TYPE                                 u_int32_t
#define HOST_INTF_PCIE_PHY_LOAD__READ                               0xffffffffU
#define HOST_INTF_PCIE_PHY_LOAD__WRITE                              0xffffffffU

#endif /* __HOST_INTF_PCIE_PHY_LOAD_MACRO__ */


/* macros for host_intf_reg_block.HOST_INTF_PCIE_PHY_LOAD */
#define INST_HOST_INTF_REG_BLOCK__HOST_INTF_PCIE_PHY_LOAD__NUM                1

/* macros for BlueprintGlobalNameSpace::HOST_INTF_GPIO_OUT */
#ifndef __HOST_INTF_GPIO_OUT_MACRO__
#define __HOST_INTF_GPIO_OUT_MACRO__

/* macros for field OUT */
#define HOST_INTF_GPIO_OUT__OUT__SHIFT                                        0
#define HOST_INTF_GPIO_OUT__OUT__WIDTH                                       17
#define HOST_INTF_GPIO_OUT__OUT__MASK                               0x0001ffffU
#define HOST_INTF_GPIO_OUT__OUT__READ(src)       (u_int32_t)(src) & 0x0001ffffU
#define HOST_INTF_GPIO_OUT__OUT__WRITE(src)    ((u_int32_t)(src) & 0x0001ffffU)
#define HOST_INTF_GPIO_OUT__OUT__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0001ffffU) | ((u_int32_t)(src) &\
                    0x0001ffffU)
#define HOST_INTF_GPIO_OUT__OUT__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x0001ffffU)))
#define HOST_INTF_GPIO_OUT__TYPE                                      u_int32_t
#define HOST_INTF_GPIO_OUT__READ                                    0x0001ffffU
#define HOST_INTF_GPIO_OUT__WRITE                                   0x0001ffffU

#endif /* __HOST_INTF_GPIO_OUT_MACRO__ */


/* macros for host_intf_reg_block.HOST_INTF_GPIO_OUT */
#define INST_HOST_INTF_REG_BLOCK__HOST_INTF_GPIO_OUT__NUM                     1

/* macros for BlueprintGlobalNameSpace::HOST_INTF_GPIO_IN */
#ifndef __HOST_INTF_GPIO_IN_MACRO__
#define __HOST_INTF_GPIO_IN_MACRO__

/* macros for field IN */
#define HOST_INTF_GPIO_IN__IN__SHIFT                                          0
#define HOST_INTF_GPIO_IN__IN__WIDTH                                         17
#define HOST_INTF_GPIO_IN__IN__MASK                                 0x0001ffffU
#define HOST_INTF_GPIO_IN__IN__READ(src)         (u_int32_t)(src) & 0x0001ffffU
#define HOST_INTF_GPIO_IN__TYPE                                       u_int32_t
#define HOST_INTF_GPIO_IN__READ                                     0x0001ffffU

#endif /* __HOST_INTF_GPIO_IN_MACRO__ */


/* macros for host_intf_reg_block.HOST_INTF_GPIO_IN */
#define INST_HOST_INTF_REG_BLOCK__HOST_INTF_GPIO_IN__NUM                      1

/* macros for BlueprintGlobalNameSpace::HOST_INTF_GPIO_OE */
#ifndef __HOST_INTF_GPIO_OE_MACRO__
#define __HOST_INTF_GPIO_OE_MACRO__

/* macros for field DATA */
#define HOST_INTF_GPIO_OE__DATA__SHIFT                                        0
#define HOST_INTF_GPIO_OE__DATA__WIDTH                                       32
#define HOST_INTF_GPIO_OE__DATA__MASK                               0xffffffffU
#define HOST_INTF_GPIO_OE__DATA__READ(src)       (u_int32_t)(src) & 0xffffffffU
#define HOST_INTF_GPIO_OE__DATA__WRITE(src)    ((u_int32_t)(src) & 0xffffffffU)
#define HOST_INTF_GPIO_OE__DATA__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xffffffffU) | ((u_int32_t)(src) &\
                    0xffffffffU)
#define HOST_INTF_GPIO_OE__DATA__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0xffffffffU)))
#define HOST_INTF_GPIO_OE__TYPE                                       u_int32_t
#define HOST_INTF_GPIO_OE__READ                                     0xffffffffU
#define HOST_INTF_GPIO_OE__WRITE                                    0xffffffffU

#endif /* __HOST_INTF_GPIO_OE_MACRO__ */


/* macros for host_intf_reg_block.HOST_INTF_GPIO_OE */
#define INST_HOST_INTF_REG_BLOCK__HOST_INTF_GPIO_OE__NUM                      1

/* macros for BlueprintGlobalNameSpace::HOST_INTF_GPIO_OE1 */
#ifndef __HOST_INTF_GPIO_OE1_MACRO__
#define __HOST_INTF_GPIO_OE1_MACRO__

/* macros for field DATA */
#define HOST_INTF_GPIO_OE1__DATA__SHIFT                                       0
#define HOST_INTF_GPIO_OE1__DATA__WIDTH                                       2
#define HOST_INTF_GPIO_OE1__DATA__MASK                              0x00000003U
#define HOST_INTF_GPIO_OE1__DATA__READ(src)      (u_int32_t)(src) & 0x00000003U
#define HOST_INTF_GPIO_OE1__DATA__WRITE(src)   ((u_int32_t)(src) & 0x00000003U)
#define HOST_INTF_GPIO_OE1__DATA__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000003U) | ((u_int32_t)(src) &\
                    0x00000003U)
#define HOST_INTF_GPIO_OE1__DATA__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00000003U)))
#define HOST_INTF_GPIO_OE1__TYPE                                      u_int32_t
#define HOST_INTF_GPIO_OE1__READ                                    0x00000003U
#define HOST_INTF_GPIO_OE1__WRITE                                   0x00000003U

#endif /* __HOST_INTF_GPIO_OE1_MACRO__ */


/* macros for host_intf_reg_block.HOST_INTF_GPIO_OE1 */
#define INST_HOST_INTF_REG_BLOCK__HOST_INTF_GPIO_OE1__NUM                     1

/* macros for BlueprintGlobalNameSpace::HOST_INTF_GPIO_INTR_POLAR */
#ifndef __HOST_INTF_GPIO_INTR_POLAR_MACRO__
#define __HOST_INTF_GPIO_INTR_POLAR_MACRO__

/* macros for field DATA */
#define HOST_INTF_GPIO_INTR_POLAR__DATA__SHIFT                                0
#define HOST_INTF_GPIO_INTR_POLAR__DATA__WIDTH                               17
#define HOST_INTF_GPIO_INTR_POLAR__DATA__MASK                       0x0001ffffU
#define HOST_INTF_GPIO_INTR_POLAR__DATA__READ(src) \
                    (u_int32_t)(src)\
                    & 0x0001ffffU
#define HOST_INTF_GPIO_INTR_POLAR__DATA__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x0001ffffU)
#define HOST_INTF_GPIO_INTR_POLAR__DATA__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0001ffffU) | ((u_int32_t)(src) &\
                    0x0001ffffU)
#define HOST_INTF_GPIO_INTR_POLAR__DATA__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x0001ffffU)))
#define HOST_INTF_GPIO_INTR_POLAR__TYPE                               u_int32_t
#define HOST_INTF_GPIO_INTR_POLAR__READ                             0x0001ffffU
#define HOST_INTF_GPIO_INTR_POLAR__WRITE                            0x0001ffffU

#endif /* __HOST_INTF_GPIO_INTR_POLAR_MACRO__ */


/* macros for host_intf_reg_block.HOST_INTF_GPIO_INTR_POLAR */
#define INST_HOST_INTF_REG_BLOCK__HOST_INTF_GPIO_INTR_POLAR__NUM              1

/* macros for BlueprintGlobalNameSpace::HOST_INTF_GPIO_INPUT_VALUE */
#ifndef __HOST_INTF_GPIO_INPUT_VALUE_MACRO__
#define __HOST_INTF_GPIO_INPUT_VALUE_MACRO__

/* macros for field RST_TSF_VAL */
#define HOST_INTF_GPIO_INPUT_VALUE__RST_TSF_VAL__SHIFT                        0
#define HOST_INTF_GPIO_INPUT_VALUE__RST_TSF_VAL__WIDTH                        1
#define HOST_INTF_GPIO_INPUT_VALUE__RST_TSF_VAL__MASK               0x00000001U
#define HOST_INTF_GPIO_INPUT_VALUE__RST_TSF_VAL__READ(src) \
                    (u_int32_t)(src)\
                    & 0x00000001U
#define HOST_INTF_GPIO_INPUT_VALUE__RST_TSF_VAL__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x00000001U)
#define HOST_INTF_GPIO_INPUT_VALUE__RST_TSF_VAL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | ((u_int32_t)(src) &\
                    0x00000001U)
#define HOST_INTF_GPIO_INPUT_VALUE__RST_TSF_VAL__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00000001U)))
#define HOST_INTF_GPIO_INPUT_VALUE__RST_TSF_VAL__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(1)
#define HOST_INTF_GPIO_INPUT_VALUE__RST_TSF_VAL__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(0)

/* macros for field RST_AZM_TS_VAL */
#define HOST_INTF_GPIO_INPUT_VALUE__RST_AZM_TS_VAL__SHIFT                     1
#define HOST_INTF_GPIO_INPUT_VALUE__RST_AZM_TS_VAL__WIDTH                     1
#define HOST_INTF_GPIO_INPUT_VALUE__RST_AZM_TS_VAL__MASK            0x00000002U
#define HOST_INTF_GPIO_INPUT_VALUE__RST_AZM_TS_VAL__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000002U) >> 1)
#define HOST_INTF_GPIO_INPUT_VALUE__RST_AZM_TS_VAL__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 1) & 0x00000002U)
#define HOST_INTF_GPIO_INPUT_VALUE__RST_AZM_TS_VAL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | (((u_int32_t)(src) <<\
                    1) & 0x00000002U)
#define HOST_INTF_GPIO_INPUT_VALUE__RST_AZM_TS_VAL__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 1) & ~0x00000002U)))
#define HOST_INTF_GPIO_INPUT_VALUE__RST_AZM_TS_VAL__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | ((u_int32_t)(1) << 1)
#define HOST_INTF_GPIO_INPUT_VALUE__RST_AZM_TS_VAL__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | ((u_int32_t)(0) << 1)

/* macros for field BT_PRIORITY_VAL */
#define HOST_INTF_GPIO_INPUT_VALUE__BT_PRIORITY_VAL__SHIFT                    2
#define HOST_INTF_GPIO_INPUT_VALUE__BT_PRIORITY_VAL__WIDTH                    1
#define HOST_INTF_GPIO_INPUT_VALUE__BT_PRIORITY_VAL__MASK           0x00000004U
#define HOST_INTF_GPIO_INPUT_VALUE__BT_PRIORITY_VAL__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000004U) >> 2)
#define HOST_INTF_GPIO_INPUT_VALUE__BT_PRIORITY_VAL__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 2) & 0x00000004U)
#define HOST_INTF_GPIO_INPUT_VALUE__BT_PRIORITY_VAL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000004U) | (((u_int32_t)(src) <<\
                    2) & 0x00000004U)
#define HOST_INTF_GPIO_INPUT_VALUE__BT_PRIORITY_VAL__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 2) & ~0x00000004U)))
#define HOST_INTF_GPIO_INPUT_VALUE__BT_PRIORITY_VAL__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000004U) | ((u_int32_t)(1) << 2)
#define HOST_INTF_GPIO_INPUT_VALUE__BT_PRIORITY_VAL__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000004U) | ((u_int32_t)(0) << 2)

/* macros for field BT_FREQUENCY_VAL */
#define HOST_INTF_GPIO_INPUT_VALUE__BT_FREQUENCY_VAL__SHIFT                   3
#define HOST_INTF_GPIO_INPUT_VALUE__BT_FREQUENCY_VAL__WIDTH                   1
#define HOST_INTF_GPIO_INPUT_VALUE__BT_FREQUENCY_VAL__MASK          0x00000008U
#define HOST_INTF_GPIO_INPUT_VALUE__BT_FREQUENCY_VAL__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000008U) >> 3)
#define HOST_INTF_GPIO_INPUT_VALUE__BT_FREQUENCY_VAL__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 3) & 0x00000008U)
#define HOST_INTF_GPIO_INPUT_VALUE__BT_FREQUENCY_VAL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000008U) | (((u_int32_t)(src) <<\
                    3) & 0x00000008U)
#define HOST_INTF_GPIO_INPUT_VALUE__BT_FREQUENCY_VAL__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 3) & ~0x00000008U)))
#define HOST_INTF_GPIO_INPUT_VALUE__BT_FREQUENCY_VAL__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000008U) | ((u_int32_t)(1) << 3)
#define HOST_INTF_GPIO_INPUT_VALUE__BT_FREQUENCY_VAL__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000008U) | ((u_int32_t)(0) << 3)

/* macros for field BT_ACTIVE_VAL */
#define HOST_INTF_GPIO_INPUT_VALUE__BT_ACTIVE_VAL__SHIFT                      4
#define HOST_INTF_GPIO_INPUT_VALUE__BT_ACTIVE_VAL__WIDTH                      1
#define HOST_INTF_GPIO_INPUT_VALUE__BT_ACTIVE_VAL__MASK             0x00000010U
#define HOST_INTF_GPIO_INPUT_VALUE__BT_ACTIVE_VAL__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000010U) >> 4)
#define HOST_INTF_GPIO_INPUT_VALUE__BT_ACTIVE_VAL__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 4) & 0x00000010U)
#define HOST_INTF_GPIO_INPUT_VALUE__BT_ACTIVE_VAL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000010U) | (((u_int32_t)(src) <<\
                    4) & 0x00000010U)
#define HOST_INTF_GPIO_INPUT_VALUE__BT_ACTIVE_VAL__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 4) & ~0x00000010U)))
#define HOST_INTF_GPIO_INPUT_VALUE__BT_ACTIVE_VAL__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000010U) | ((u_int32_t)(1) << 4)
#define HOST_INTF_GPIO_INPUT_VALUE__BT_ACTIVE_VAL__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000010U) | ((u_int32_t)(0) << 4)

/* macros for field ATT_BUT_VAL */
#define HOST_INTF_GPIO_INPUT_VALUE__ATT_BUT_VAL__SHIFT                        5
#define HOST_INTF_GPIO_INPUT_VALUE__ATT_BUT_VAL__WIDTH                        1
#define HOST_INTF_GPIO_INPUT_VALUE__ATT_BUT_VAL__MASK               0x00000020U
#define HOST_INTF_GPIO_INPUT_VALUE__ATT_BUT_VAL__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000020U) >> 5)
#define HOST_INTF_GPIO_INPUT_VALUE__ATT_BUT_VAL__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 5) & 0x00000020U)
#define HOST_INTF_GPIO_INPUT_VALUE__ATT_BUT_VAL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000020U) | (((u_int32_t)(src) <<\
                    5) & 0x00000020U)
#define HOST_INTF_GPIO_INPUT_VALUE__ATT_BUT_VAL__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 5) & ~0x00000020U)))
#define HOST_INTF_GPIO_INPUT_VALUE__ATT_BUT_VAL__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000020U) | ((u_int32_t)(1) << 5)
#define HOST_INTF_GPIO_INPUT_VALUE__ATT_BUT_VAL__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000020U) | ((u_int32_t)(0) << 5)

/* macros for field CLK25_VAL */
#define HOST_INTF_GPIO_INPUT_VALUE__CLK25_VAL__SHIFT                          6
#define HOST_INTF_GPIO_INPUT_VALUE__CLK25_VAL__WIDTH                          1
#define HOST_INTF_GPIO_INPUT_VALUE__CLK25_VAL__MASK                 0x00000040U
#define HOST_INTF_GPIO_INPUT_VALUE__CLK25_VAL__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000040U) >> 6)
#define HOST_INTF_GPIO_INPUT_VALUE__CLK25_VAL__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 6) & 0x00000040U)
#define HOST_INTF_GPIO_INPUT_VALUE__CLK25_VAL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000040U) | (((u_int32_t)(src) <<\
                    6) & 0x00000040U)
#define HOST_INTF_GPIO_INPUT_VALUE__CLK25_VAL__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 6) & ~0x00000040U)))
#define HOST_INTF_GPIO_INPUT_VALUE__CLK25_VAL__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000040U) | ((u_int32_t)(1) << 6)
#define HOST_INTF_GPIO_INPUT_VALUE__CLK25_VAL__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000040U) | ((u_int32_t)(0) << 6)

/* macros for field RFSILENT_BB_L_VAL */
#define HOST_INTF_GPIO_INPUT_VALUE__RFSILENT_BB_L_VAL__SHIFT                  7
#define HOST_INTF_GPIO_INPUT_VALUE__RFSILENT_BB_L_VAL__WIDTH                  1
#define HOST_INTF_GPIO_INPUT_VALUE__RFSILENT_BB_L_VAL__MASK         0x00000080U
#define HOST_INTF_GPIO_INPUT_VALUE__RFSILENT_BB_L_VAL__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000080U) >> 7)
#define HOST_INTF_GPIO_INPUT_VALUE__RFSILENT_BB_L_VAL__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 7) & 0x00000080U)
#define HOST_INTF_GPIO_INPUT_VALUE__RFSILENT_BB_L_VAL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000080U) | (((u_int32_t)(src) <<\
                    7) & 0x00000080U)
#define HOST_INTF_GPIO_INPUT_VALUE__RFSILENT_BB_L_VAL__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 7) & ~0x00000080U)))
#define HOST_INTF_GPIO_INPUT_VALUE__RFSILENT_BB_L_VAL__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000080U) | ((u_int32_t)(1) << 7)
#define HOST_INTF_GPIO_INPUT_VALUE__RFSILENT_BB_L_VAL__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000080U) | ((u_int32_t)(0) << 7)

/* macros for field GPIO_RST_TSF_ENABLE */
#define HOST_INTF_GPIO_INPUT_VALUE__GPIO_RST_TSF_ENABLE__SHIFT                8
#define HOST_INTF_GPIO_INPUT_VALUE__GPIO_RST_TSF_ENABLE__WIDTH                1
#define HOST_INTF_GPIO_INPUT_VALUE__GPIO_RST_TSF_ENABLE__MASK       0x00000100U
#define HOST_INTF_GPIO_INPUT_VALUE__GPIO_RST_TSF_ENABLE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000100U) >> 8)
#define HOST_INTF_GPIO_INPUT_VALUE__GPIO_RST_TSF_ENABLE__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 8) & 0x00000100U)
#define HOST_INTF_GPIO_INPUT_VALUE__GPIO_RST_TSF_ENABLE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000100U) | (((u_int32_t)(src) <<\
                    8) & 0x00000100U)
#define HOST_INTF_GPIO_INPUT_VALUE__GPIO_RST_TSF_ENABLE__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 8) & ~0x00000100U)))
#define HOST_INTF_GPIO_INPUT_VALUE__GPIO_RST_TSF_ENABLE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000100U) | ((u_int32_t)(1) << 8)
#define HOST_INTF_GPIO_INPUT_VALUE__GPIO_RST_TSF_ENABLE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000100U) | ((u_int32_t)(0) << 8)

/* macros for field GPIO_RST_AZM_TS_ENABLE */
#define HOST_INTF_GPIO_INPUT_VALUE__GPIO_RST_AZM_TS_ENABLE__SHIFT             9
#define HOST_INTF_GPIO_INPUT_VALUE__GPIO_RST_AZM_TS_ENABLE__WIDTH             1
#define HOST_INTF_GPIO_INPUT_VALUE__GPIO_RST_AZM_TS_ENABLE__MASK    0x00000200U
#define HOST_INTF_GPIO_INPUT_VALUE__GPIO_RST_AZM_TS_ENABLE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000200U) >> 9)
#define HOST_INTF_GPIO_INPUT_VALUE__GPIO_RST_AZM_TS_ENABLE__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 9) & 0x00000200U)
#define HOST_INTF_GPIO_INPUT_VALUE__GPIO_RST_AZM_TS_ENABLE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000200U) | (((u_int32_t)(src) <<\
                    9) & 0x00000200U)
#define HOST_INTF_GPIO_INPUT_VALUE__GPIO_RST_AZM_TS_ENABLE__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 9) & ~0x00000200U)))
#define HOST_INTF_GPIO_INPUT_VALUE__GPIO_RST_AZM_TS_ENABLE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000200U) | ((u_int32_t)(1) << 9)
#define HOST_INTF_GPIO_INPUT_VALUE__GPIO_RST_AZM_TS_ENABLE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000200U) | ((u_int32_t)(0) << 9)

/* macros for field BT_PRIORITY_ENABLE */
#define HOST_INTF_GPIO_INPUT_VALUE__BT_PRIORITY_ENABLE__SHIFT                10
#define HOST_INTF_GPIO_INPUT_VALUE__BT_PRIORITY_ENABLE__WIDTH                 1
#define HOST_INTF_GPIO_INPUT_VALUE__BT_PRIORITY_ENABLE__MASK        0x00000400U
#define HOST_INTF_GPIO_INPUT_VALUE__BT_PRIORITY_ENABLE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000400U) >> 10)
#define HOST_INTF_GPIO_INPUT_VALUE__BT_PRIORITY_ENABLE__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 10) & 0x00000400U)
#define HOST_INTF_GPIO_INPUT_VALUE__BT_PRIORITY_ENABLE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000400U) | (((u_int32_t)(src) <<\
                    10) & 0x00000400U)
#define HOST_INTF_GPIO_INPUT_VALUE__BT_PRIORITY_ENABLE__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 10) & ~0x00000400U)))
#define HOST_INTF_GPIO_INPUT_VALUE__BT_PRIORITY_ENABLE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000400U) | ((u_int32_t)(1) << 10)
#define HOST_INTF_GPIO_INPUT_VALUE__BT_PRIORITY_ENABLE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000400U) | ((u_int32_t)(0) << 10)

/* macros for field BT_FREQUENCY_ENABLE */
#define HOST_INTF_GPIO_INPUT_VALUE__BT_FREQUENCY_ENABLE__SHIFT               11
#define HOST_INTF_GPIO_INPUT_VALUE__BT_FREQUENCY_ENABLE__WIDTH                1
#define HOST_INTF_GPIO_INPUT_VALUE__BT_FREQUENCY_ENABLE__MASK       0x00000800U
#define HOST_INTF_GPIO_INPUT_VALUE__BT_FREQUENCY_ENABLE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000800U) >> 11)
#define HOST_INTF_GPIO_INPUT_VALUE__BT_FREQUENCY_ENABLE__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 11) & 0x00000800U)
#define HOST_INTF_GPIO_INPUT_VALUE__BT_FREQUENCY_ENABLE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000800U) | (((u_int32_t)(src) <<\
                    11) & 0x00000800U)
#define HOST_INTF_GPIO_INPUT_VALUE__BT_FREQUENCY_ENABLE__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 11) & ~0x00000800U)))
#define HOST_INTF_GPIO_INPUT_VALUE__BT_FREQUENCY_ENABLE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000800U) | ((u_int32_t)(1) << 11)
#define HOST_INTF_GPIO_INPUT_VALUE__BT_FREQUENCY_ENABLE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000800U) | ((u_int32_t)(0) << 11)

/* macros for field BT_ACTIVE_ENABLE */
#define HOST_INTF_GPIO_INPUT_VALUE__BT_ACTIVE_ENABLE__SHIFT                  12
#define HOST_INTF_GPIO_INPUT_VALUE__BT_ACTIVE_ENABLE__WIDTH                   1
#define HOST_INTF_GPIO_INPUT_VALUE__BT_ACTIVE_ENABLE__MASK          0x00001000U
#define HOST_INTF_GPIO_INPUT_VALUE__BT_ACTIVE_ENABLE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00001000U) >> 12)
#define HOST_INTF_GPIO_INPUT_VALUE__BT_ACTIVE_ENABLE__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 12) & 0x00001000U)
#define HOST_INTF_GPIO_INPUT_VALUE__BT_ACTIVE_ENABLE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00001000U) | (((u_int32_t)(src) <<\
                    12) & 0x00001000U)
#define HOST_INTF_GPIO_INPUT_VALUE__BT_ACTIVE_ENABLE__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 12) & ~0x00001000U)))
#define HOST_INTF_GPIO_INPUT_VALUE__BT_ACTIVE_ENABLE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00001000U) | ((u_int32_t)(1) << 12)
#define HOST_INTF_GPIO_INPUT_VALUE__BT_ACTIVE_ENABLE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00001000U) | ((u_int32_t)(0) << 12)

/* macros for field ATT_BUT_ENABLE */
#define HOST_INTF_GPIO_INPUT_VALUE__ATT_BUT_ENABLE__SHIFT                    13
#define HOST_INTF_GPIO_INPUT_VALUE__ATT_BUT_ENABLE__WIDTH                     1
#define HOST_INTF_GPIO_INPUT_VALUE__ATT_BUT_ENABLE__MASK            0x00002000U
#define HOST_INTF_GPIO_INPUT_VALUE__ATT_BUT_ENABLE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00002000U) >> 13)
#define HOST_INTF_GPIO_INPUT_VALUE__ATT_BUT_ENABLE__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 13) & 0x00002000U)
#define HOST_INTF_GPIO_INPUT_VALUE__ATT_BUT_ENABLE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00002000U) | (((u_int32_t)(src) <<\
                    13) & 0x00002000U)
#define HOST_INTF_GPIO_INPUT_VALUE__ATT_BUT_ENABLE__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 13) & ~0x00002000U)))
#define HOST_INTF_GPIO_INPUT_VALUE__ATT_BUT_ENABLE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00002000U) | ((u_int32_t)(1) << 13)
#define HOST_INTF_GPIO_INPUT_VALUE__ATT_BUT_ENABLE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00002000U) | ((u_int32_t)(0) << 13)

/* macros for field CLK25_ENABLE */
#define HOST_INTF_GPIO_INPUT_VALUE__CLK25_ENABLE__SHIFT                      14
#define HOST_INTF_GPIO_INPUT_VALUE__CLK25_ENABLE__WIDTH                       1
#define HOST_INTF_GPIO_INPUT_VALUE__CLK25_ENABLE__MASK              0x00004000U
#define HOST_INTF_GPIO_INPUT_VALUE__CLK25_ENABLE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00004000U) >> 14)
#define HOST_INTF_GPIO_INPUT_VALUE__CLK25_ENABLE__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 14) & 0x00004000U)
#define HOST_INTF_GPIO_INPUT_VALUE__CLK25_ENABLE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00004000U) | (((u_int32_t)(src) <<\
                    14) & 0x00004000U)
#define HOST_INTF_GPIO_INPUT_VALUE__CLK25_ENABLE__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 14) & ~0x00004000U)))
#define HOST_INTF_GPIO_INPUT_VALUE__CLK25_ENABLE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00004000U) | ((u_int32_t)(1) << 14)
#define HOST_INTF_GPIO_INPUT_VALUE__CLK25_ENABLE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00004000U) | ((u_int32_t)(0) << 14)

/* macros for field RFSILENT_BB_L_ENABLE */
#define HOST_INTF_GPIO_INPUT_VALUE__RFSILENT_BB_L_ENABLE__SHIFT              15
#define HOST_INTF_GPIO_INPUT_VALUE__RFSILENT_BB_L_ENABLE__WIDTH               1
#define HOST_INTF_GPIO_INPUT_VALUE__RFSILENT_BB_L_ENABLE__MASK      0x00008000U
#define HOST_INTF_GPIO_INPUT_VALUE__RFSILENT_BB_L_ENABLE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00008000U) >> 15)
#define HOST_INTF_GPIO_INPUT_VALUE__RFSILENT_BB_L_ENABLE__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 15) & 0x00008000U)
#define HOST_INTF_GPIO_INPUT_VALUE__RFSILENT_BB_L_ENABLE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00008000U) | (((u_int32_t)(src) <<\
                    15) & 0x00008000U)
#define HOST_INTF_GPIO_INPUT_VALUE__RFSILENT_BB_L_ENABLE__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 15) & ~0x00008000U)))
#define HOST_INTF_GPIO_INPUT_VALUE__RFSILENT_BB_L_ENABLE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00008000U) | ((u_int32_t)(1) << 15)
#define HOST_INTF_GPIO_INPUT_VALUE__RFSILENT_BB_L_ENABLE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00008000U) | ((u_int32_t)(0) << 15)

/* macros for field RTC_RESET_OVRD_ENABLE */
#define HOST_INTF_GPIO_INPUT_VALUE__RTC_RESET_OVRD_ENABLE__SHIFT             16
#define HOST_INTF_GPIO_INPUT_VALUE__RTC_RESET_OVRD_ENABLE__WIDTH              1
#define HOST_INTF_GPIO_INPUT_VALUE__RTC_RESET_OVRD_ENABLE__MASK     0x00010000U
#define HOST_INTF_GPIO_INPUT_VALUE__RTC_RESET_OVRD_ENABLE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00010000U) >> 16)
#define HOST_INTF_GPIO_INPUT_VALUE__RTC_RESET_OVRD_ENABLE__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 16) & 0x00010000U)
#define HOST_INTF_GPIO_INPUT_VALUE__RTC_RESET_OVRD_ENABLE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00010000U) | (((u_int32_t)(src) <<\
                    16) & 0x00010000U)
#define HOST_INTF_GPIO_INPUT_VALUE__RTC_RESET_OVRD_ENABLE__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 16) & ~0x00010000U)))
#define HOST_INTF_GPIO_INPUT_VALUE__RTC_RESET_OVRD_ENABLE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00010000U) | ((u_int32_t)(1) << 16)
#define HOST_INTF_GPIO_INPUT_VALUE__RTC_RESET_OVRD_ENABLE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00010000U) | ((u_int32_t)(0) << 16)

/* macros for field DS_JTAG_DISABLE */
#define HOST_INTF_GPIO_INPUT_VALUE__DS_JTAG_DISABLE__SHIFT                   17
#define HOST_INTF_GPIO_INPUT_VALUE__DS_JTAG_DISABLE__WIDTH                    1
#define HOST_INTF_GPIO_INPUT_VALUE__DS_JTAG_DISABLE__MASK           0x00020000U
#define HOST_INTF_GPIO_INPUT_VALUE__DS_JTAG_DISABLE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00020000U) >> 17)
#define HOST_INTF_GPIO_INPUT_VALUE__DS_JTAG_DISABLE__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 17) & 0x00020000U)
#define HOST_INTF_GPIO_INPUT_VALUE__DS_JTAG_DISABLE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00020000U) | (((u_int32_t)(src) <<\
                    17) & 0x00020000U)
#define HOST_INTF_GPIO_INPUT_VALUE__DS_JTAG_DISABLE__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 17) & ~0x00020000U)))
#define HOST_INTF_GPIO_INPUT_VALUE__DS_JTAG_DISABLE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00020000U) | ((u_int32_t)(1) << 17)
#define HOST_INTF_GPIO_INPUT_VALUE__DS_JTAG_DISABLE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00020000U) | ((u_int32_t)(0) << 17)

/* macros for field BT_PRIORITY_2_VAL */
#define HOST_INTF_GPIO_INPUT_VALUE__BT_PRIORITY_2_VAL__SHIFT                 18
#define HOST_INTF_GPIO_INPUT_VALUE__BT_PRIORITY_2_VAL__WIDTH                  1
#define HOST_INTF_GPIO_INPUT_VALUE__BT_PRIORITY_2_VAL__MASK         0x00040000U
#define HOST_INTF_GPIO_INPUT_VALUE__BT_PRIORITY_2_VAL__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00040000U) >> 18)
#define HOST_INTF_GPIO_INPUT_VALUE__BT_PRIORITY_2_VAL__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 18) & 0x00040000U)
#define HOST_INTF_GPIO_INPUT_VALUE__BT_PRIORITY_2_VAL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00040000U) | (((u_int32_t)(src) <<\
                    18) & 0x00040000U)
#define HOST_INTF_GPIO_INPUT_VALUE__BT_PRIORITY_2_VAL__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 18) & ~0x00040000U)))
#define HOST_INTF_GPIO_INPUT_VALUE__BT_PRIORITY_2_VAL__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00040000U) | ((u_int32_t)(1) << 18)
#define HOST_INTF_GPIO_INPUT_VALUE__BT_PRIORITY_2_VAL__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00040000U) | ((u_int32_t)(0) << 18)

/* macros for field BT_PRIORITY_2_ENABLE */
#define HOST_INTF_GPIO_INPUT_VALUE__BT_PRIORITY_2_ENABLE__SHIFT              19
#define HOST_INTF_GPIO_INPUT_VALUE__BT_PRIORITY_2_ENABLE__WIDTH               1
#define HOST_INTF_GPIO_INPUT_VALUE__BT_PRIORITY_2_ENABLE__MASK      0x00080000U
#define HOST_INTF_GPIO_INPUT_VALUE__BT_PRIORITY_2_ENABLE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00080000U) >> 19)
#define HOST_INTF_GPIO_INPUT_VALUE__BT_PRIORITY_2_ENABLE__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 19) & 0x00080000U)
#define HOST_INTF_GPIO_INPUT_VALUE__BT_PRIORITY_2_ENABLE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00080000U) | (((u_int32_t)(src) <<\
                    19) & 0x00080000U)
#define HOST_INTF_GPIO_INPUT_VALUE__BT_PRIORITY_2_ENABLE__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 19) & ~0x00080000U)))
#define HOST_INTF_GPIO_INPUT_VALUE__BT_PRIORITY_2_ENABLE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00080000U) | ((u_int32_t)(1) << 19)
#define HOST_INTF_GPIO_INPUT_VALUE__BT_PRIORITY_2_ENABLE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00080000U) | ((u_int32_t)(0) << 19)

/* macros for field BT_PRIORITY_3_VAL */
#define HOST_INTF_GPIO_INPUT_VALUE__BT_PRIORITY_3_VAL__SHIFT                 20
#define HOST_INTF_GPIO_INPUT_VALUE__BT_PRIORITY_3_VAL__WIDTH                  1
#define HOST_INTF_GPIO_INPUT_VALUE__BT_PRIORITY_3_VAL__MASK         0x00100000U
#define HOST_INTF_GPIO_INPUT_VALUE__BT_PRIORITY_3_VAL__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00100000U) >> 20)
#define HOST_INTF_GPIO_INPUT_VALUE__BT_PRIORITY_3_VAL__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 20) & 0x00100000U)
#define HOST_INTF_GPIO_INPUT_VALUE__BT_PRIORITY_3_VAL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00100000U) | (((u_int32_t)(src) <<\
                    20) & 0x00100000U)
#define HOST_INTF_GPIO_INPUT_VALUE__BT_PRIORITY_3_VAL__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 20) & ~0x00100000U)))
#define HOST_INTF_GPIO_INPUT_VALUE__BT_PRIORITY_3_VAL__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00100000U) | ((u_int32_t)(1) << 20)
#define HOST_INTF_GPIO_INPUT_VALUE__BT_PRIORITY_3_VAL__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00100000U) | ((u_int32_t)(0) << 20)

/* macros for field BT_PRIORITY_3_ENABLE */
#define HOST_INTF_GPIO_INPUT_VALUE__BT_PRIORITY_3_ENABLE__SHIFT              21
#define HOST_INTF_GPIO_INPUT_VALUE__BT_PRIORITY_3_ENABLE__WIDTH               1
#define HOST_INTF_GPIO_INPUT_VALUE__BT_PRIORITY_3_ENABLE__MASK      0x00200000U
#define HOST_INTF_GPIO_INPUT_VALUE__BT_PRIORITY_3_ENABLE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00200000U) >> 21)
#define HOST_INTF_GPIO_INPUT_VALUE__BT_PRIORITY_3_ENABLE__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 21) & 0x00200000U)
#define HOST_INTF_GPIO_INPUT_VALUE__BT_PRIORITY_3_ENABLE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00200000U) | (((u_int32_t)(src) <<\
                    21) & 0x00200000U)
#define HOST_INTF_GPIO_INPUT_VALUE__BT_PRIORITY_3_ENABLE__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 21) & ~0x00200000U)))
#define HOST_INTF_GPIO_INPUT_VALUE__BT_PRIORITY_3_ENABLE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00200000U) | ((u_int32_t)(1) << 21)
#define HOST_INTF_GPIO_INPUT_VALUE__BT_PRIORITY_3_ENABLE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00200000U) | ((u_int32_t)(0) << 21)
#define HOST_INTF_GPIO_INPUT_VALUE__TYPE                              u_int32_t
#define HOST_INTF_GPIO_INPUT_VALUE__READ                            0x003fffffU
#define HOST_INTF_GPIO_INPUT_VALUE__WRITE                           0x003fffffU

#endif /* __HOST_INTF_GPIO_INPUT_VALUE_MACRO__ */


/* macros for host_intf_reg_block.HOST_INTF_GPIO_INPUT_VALUE */
#define INST_HOST_INTF_REG_BLOCK__HOST_INTF_GPIO_INPUT_VALUE__NUM             1

/* macros for BlueprintGlobalNameSpace::HOST_INTF_GPIO_INPUT_MUX1 */
#ifndef __HOST_INTF_GPIO_INPUT_MUX1_MACRO__
#define __HOST_INTF_GPIO_INPUT_MUX1_MACRO__

/* macros for field SEL_0 */
#define HOST_INTF_GPIO_INPUT_MUX1__SEL_0__SHIFT                               0
#define HOST_INTF_GPIO_INPUT_MUX1__SEL_0__WIDTH                               4
#define HOST_INTF_GPIO_INPUT_MUX1__SEL_0__MASK                      0x0000000fU
#define HOST_INTF_GPIO_INPUT_MUX1__SEL_0__READ(src) \
                    (u_int32_t)(src)\
                    & 0x0000000fU
#define HOST_INTF_GPIO_INPUT_MUX1__SEL_0__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x0000000fU)
#define HOST_INTF_GPIO_INPUT_MUX1__SEL_0__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000000fU) | ((u_int32_t)(src) &\
                    0x0000000fU)
#define HOST_INTF_GPIO_INPUT_MUX1__SEL_0__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x0000000fU)))

/* macros for field SEL_1 */
#define HOST_INTF_GPIO_INPUT_MUX1__SEL_1__SHIFT                               4
#define HOST_INTF_GPIO_INPUT_MUX1__SEL_1__WIDTH                               4
#define HOST_INTF_GPIO_INPUT_MUX1__SEL_1__MASK                      0x000000f0U
#define HOST_INTF_GPIO_INPUT_MUX1__SEL_1__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x000000f0U) >> 4)
#define HOST_INTF_GPIO_INPUT_MUX1__SEL_1__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 4) & 0x000000f0U)
#define HOST_INTF_GPIO_INPUT_MUX1__SEL_1__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000000f0U) | (((u_int32_t)(src) <<\
                    4) & 0x000000f0U)
#define HOST_INTF_GPIO_INPUT_MUX1__SEL_1__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 4) & ~0x000000f0U)))

/* macros for field SEL_2 */
#define HOST_INTF_GPIO_INPUT_MUX1__SEL_2__SHIFT                               8
#define HOST_INTF_GPIO_INPUT_MUX1__SEL_2__WIDTH                               4
#define HOST_INTF_GPIO_INPUT_MUX1__SEL_2__MASK                      0x00000f00U
#define HOST_INTF_GPIO_INPUT_MUX1__SEL_2__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000f00U) >> 8)
#define HOST_INTF_GPIO_INPUT_MUX1__SEL_2__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 8) & 0x00000f00U)
#define HOST_INTF_GPIO_INPUT_MUX1__SEL_2__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000f00U) | (((u_int32_t)(src) <<\
                    8) & 0x00000f00U)
#define HOST_INTF_GPIO_INPUT_MUX1__SEL_2__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 8) & ~0x00000f00U)))

/* macros for field SEL_3 */
#define HOST_INTF_GPIO_INPUT_MUX1__SEL_3__SHIFT                              12
#define HOST_INTF_GPIO_INPUT_MUX1__SEL_3__WIDTH                               4
#define HOST_INTF_GPIO_INPUT_MUX1__SEL_3__MASK                      0x0000f000U
#define HOST_INTF_GPIO_INPUT_MUX1__SEL_3__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0000f000U) >> 12)
#define HOST_INTF_GPIO_INPUT_MUX1__SEL_3__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 12) & 0x0000f000U)
#define HOST_INTF_GPIO_INPUT_MUX1__SEL_3__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000f000U) | (((u_int32_t)(src) <<\
                    12) & 0x0000f000U)
#define HOST_INTF_GPIO_INPUT_MUX1__SEL_3__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 12) & ~0x0000f000U)))

/* macros for field SEL_4 */
#define HOST_INTF_GPIO_INPUT_MUX1__SEL_4__SHIFT                              16
#define HOST_INTF_GPIO_INPUT_MUX1__SEL_4__WIDTH                               4
#define HOST_INTF_GPIO_INPUT_MUX1__SEL_4__MASK                      0x000f0000U
#define HOST_INTF_GPIO_INPUT_MUX1__SEL_4__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x000f0000U) >> 16)
#define HOST_INTF_GPIO_INPUT_MUX1__SEL_4__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 16) & 0x000f0000U)
#define HOST_INTF_GPIO_INPUT_MUX1__SEL_4__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000f0000U) | (((u_int32_t)(src) <<\
                    16) & 0x000f0000U)
#define HOST_INTF_GPIO_INPUT_MUX1__SEL_4__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 16) & ~0x000f0000U)))

/* macros for field SEL_5 */
#define HOST_INTF_GPIO_INPUT_MUX1__SEL_5__SHIFT                              20
#define HOST_INTF_GPIO_INPUT_MUX1__SEL_5__WIDTH                               4
#define HOST_INTF_GPIO_INPUT_MUX1__SEL_5__MASK                      0x00f00000U
#define HOST_INTF_GPIO_INPUT_MUX1__SEL_5__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00f00000U) >> 20)
#define HOST_INTF_GPIO_INPUT_MUX1__SEL_5__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 20) & 0x00f00000U)
#define HOST_INTF_GPIO_INPUT_MUX1__SEL_5__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00f00000U) | (((u_int32_t)(src) <<\
                    20) & 0x00f00000U)
#define HOST_INTF_GPIO_INPUT_MUX1__SEL_5__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 20) & ~0x00f00000U)))
#define HOST_INTF_GPIO_INPUT_MUX1__TYPE                               u_int32_t
#define HOST_INTF_GPIO_INPUT_MUX1__READ                             0x00ffffffU
#define HOST_INTF_GPIO_INPUT_MUX1__WRITE                            0x00ffffffU

#endif /* __HOST_INTF_GPIO_INPUT_MUX1_MACRO__ */


/* macros for host_intf_reg_block.HOST_INTF_GPIO_INPUT_MUX1 */
#define INST_HOST_INTF_REG_BLOCK__HOST_INTF_GPIO_INPUT_MUX1__NUM              1

/* macros for BlueprintGlobalNameSpace::HOST_INTF_GPIO_INPUT_MUX2 */
#ifndef __HOST_INTF_GPIO_INPUT_MUX2_MACRO__
#define __HOST_INTF_GPIO_INPUT_MUX2_MACRO__

/* macros for field SEL_6 */
#define HOST_INTF_GPIO_INPUT_MUX2__SEL_6__SHIFT                               0
#define HOST_INTF_GPIO_INPUT_MUX2__SEL_6__WIDTH                               4
#define HOST_INTF_GPIO_INPUT_MUX2__SEL_6__MASK                      0x0000000fU
#define HOST_INTF_GPIO_INPUT_MUX2__SEL_6__READ(src) \
                    (u_int32_t)(src)\
                    & 0x0000000fU
#define HOST_INTF_GPIO_INPUT_MUX2__SEL_6__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x0000000fU)
#define HOST_INTF_GPIO_INPUT_MUX2__SEL_6__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000000fU) | ((u_int32_t)(src) &\
                    0x0000000fU)
#define HOST_INTF_GPIO_INPUT_MUX2__SEL_6__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x0000000fU)))

/* macros for field SEL_7 */
#define HOST_INTF_GPIO_INPUT_MUX2__SEL_7__SHIFT                               4
#define HOST_INTF_GPIO_INPUT_MUX2__SEL_7__WIDTH                               4
#define HOST_INTF_GPIO_INPUT_MUX2__SEL_7__MASK                      0x000000f0U
#define HOST_INTF_GPIO_INPUT_MUX2__SEL_7__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x000000f0U) >> 4)
#define HOST_INTF_GPIO_INPUT_MUX2__SEL_7__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 4) & 0x000000f0U)
#define HOST_INTF_GPIO_INPUT_MUX2__SEL_7__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000000f0U) | (((u_int32_t)(src) <<\
                    4) & 0x000000f0U)
#define HOST_INTF_GPIO_INPUT_MUX2__SEL_7__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 4) & ~0x000000f0U)))

/* macros for field SEL_8 */
#define HOST_INTF_GPIO_INPUT_MUX2__SEL_8__SHIFT                               8
#define HOST_INTF_GPIO_INPUT_MUX2__SEL_8__WIDTH                               4
#define HOST_INTF_GPIO_INPUT_MUX2__SEL_8__MASK                      0x00000f00U
#define HOST_INTF_GPIO_INPUT_MUX2__SEL_8__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000f00U) >> 8)
#define HOST_INTF_GPIO_INPUT_MUX2__SEL_8__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 8) & 0x00000f00U)
#define HOST_INTF_GPIO_INPUT_MUX2__SEL_8__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000f00U) | (((u_int32_t)(src) <<\
                    8) & 0x00000f00U)
#define HOST_INTF_GPIO_INPUT_MUX2__SEL_8__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 8) & ~0x00000f00U)))

/* macros for field SEL_9 */
#define HOST_INTF_GPIO_INPUT_MUX2__SEL_9__SHIFT                              12
#define HOST_INTF_GPIO_INPUT_MUX2__SEL_9__WIDTH                               4
#define HOST_INTF_GPIO_INPUT_MUX2__SEL_9__MASK                      0x0000f000U
#define HOST_INTF_GPIO_INPUT_MUX2__SEL_9__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0000f000U) >> 12)
#define HOST_INTF_GPIO_INPUT_MUX2__SEL_9__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 12) & 0x0000f000U)
#define HOST_INTF_GPIO_INPUT_MUX2__SEL_9__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000f000U) | (((u_int32_t)(src) <<\
                    12) & 0x0000f000U)
#define HOST_INTF_GPIO_INPUT_MUX2__SEL_9__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 12) & ~0x0000f000U)))

/* macros for field SEL_10 */
#define HOST_INTF_GPIO_INPUT_MUX2__SEL_10__SHIFT                             16
#define HOST_INTF_GPIO_INPUT_MUX2__SEL_10__WIDTH                              4
#define HOST_INTF_GPIO_INPUT_MUX2__SEL_10__MASK                     0x000f0000U
#define HOST_INTF_GPIO_INPUT_MUX2__SEL_10__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x000f0000U) >> 16)
#define HOST_INTF_GPIO_INPUT_MUX2__SEL_10__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 16) & 0x000f0000U)
#define HOST_INTF_GPIO_INPUT_MUX2__SEL_10__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000f0000U) | (((u_int32_t)(src) <<\
                    16) & 0x000f0000U)
#define HOST_INTF_GPIO_INPUT_MUX2__SEL_10__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 16) & ~0x000f0000U)))
#define HOST_INTF_GPIO_INPUT_MUX2__TYPE                               u_int32_t
#define HOST_INTF_GPIO_INPUT_MUX2__READ                             0x000fffffU
#define HOST_INTF_GPIO_INPUT_MUX2__WRITE                            0x000fffffU

#endif /* __HOST_INTF_GPIO_INPUT_MUX2_MACRO__ */


/* macros for host_intf_reg_block.HOST_INTF_GPIO_INPUT_MUX2 */
#define INST_HOST_INTF_REG_BLOCK__HOST_INTF_GPIO_INPUT_MUX2__NUM              1

/* macros for BlueprintGlobalNameSpace::HOST_INTF_GPIO_OUTPUT_MUX1 */
#ifndef __HOST_INTF_GPIO_OUTPUT_MUX1_MACRO__
#define __HOST_INTF_GPIO_OUTPUT_MUX1_MACRO__

/* macros for field SEL_0 */
#define HOST_INTF_GPIO_OUTPUT_MUX1__SEL_0__SHIFT                              0
#define HOST_INTF_GPIO_OUTPUT_MUX1__SEL_0__WIDTH                              5
#define HOST_INTF_GPIO_OUTPUT_MUX1__SEL_0__MASK                     0x0000001fU
#define HOST_INTF_GPIO_OUTPUT_MUX1__SEL_0__READ(src) \
                    (u_int32_t)(src)\
                    & 0x0000001fU
#define HOST_INTF_GPIO_OUTPUT_MUX1__SEL_0__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x0000001fU)
#define HOST_INTF_GPIO_OUTPUT_MUX1__SEL_0__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000001fU) | ((u_int32_t)(src) &\
                    0x0000001fU)
#define HOST_INTF_GPIO_OUTPUT_MUX1__SEL_0__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x0000001fU)))

/* macros for field SEL_1 */
#define HOST_INTF_GPIO_OUTPUT_MUX1__SEL_1__SHIFT                              5
#define HOST_INTF_GPIO_OUTPUT_MUX1__SEL_1__WIDTH                              5
#define HOST_INTF_GPIO_OUTPUT_MUX1__SEL_1__MASK                     0x000003e0U
#define HOST_INTF_GPIO_OUTPUT_MUX1__SEL_1__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x000003e0U) >> 5)
#define HOST_INTF_GPIO_OUTPUT_MUX1__SEL_1__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 5) & 0x000003e0U)
#define HOST_INTF_GPIO_OUTPUT_MUX1__SEL_1__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000003e0U) | (((u_int32_t)(src) <<\
                    5) & 0x000003e0U)
#define HOST_INTF_GPIO_OUTPUT_MUX1__SEL_1__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 5) & ~0x000003e0U)))

/* macros for field SEL_2 */
#define HOST_INTF_GPIO_OUTPUT_MUX1__SEL_2__SHIFT                             10
#define HOST_INTF_GPIO_OUTPUT_MUX1__SEL_2__WIDTH                              5
#define HOST_INTF_GPIO_OUTPUT_MUX1__SEL_2__MASK                     0x00007c00U
#define HOST_INTF_GPIO_OUTPUT_MUX1__SEL_2__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00007c00U) >> 10)
#define HOST_INTF_GPIO_OUTPUT_MUX1__SEL_2__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 10) & 0x00007c00U)
#define HOST_INTF_GPIO_OUTPUT_MUX1__SEL_2__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00007c00U) | (((u_int32_t)(src) <<\
                    10) & 0x00007c00U)
#define HOST_INTF_GPIO_OUTPUT_MUX1__SEL_2__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 10) & ~0x00007c00U)))

/* macros for field SEL_3 */
#define HOST_INTF_GPIO_OUTPUT_MUX1__SEL_3__SHIFT                             15
#define HOST_INTF_GPIO_OUTPUT_MUX1__SEL_3__WIDTH                              5
#define HOST_INTF_GPIO_OUTPUT_MUX1__SEL_3__MASK                     0x000f8000U
#define HOST_INTF_GPIO_OUTPUT_MUX1__SEL_3__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x000f8000U) >> 15)
#define HOST_INTF_GPIO_OUTPUT_MUX1__SEL_3__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 15) & 0x000f8000U)
#define HOST_INTF_GPIO_OUTPUT_MUX1__SEL_3__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000f8000U) | (((u_int32_t)(src) <<\
                    15) & 0x000f8000U)
#define HOST_INTF_GPIO_OUTPUT_MUX1__SEL_3__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 15) & ~0x000f8000U)))

/* macros for field SEL_4 */
#define HOST_INTF_GPIO_OUTPUT_MUX1__SEL_4__SHIFT                             20
#define HOST_INTF_GPIO_OUTPUT_MUX1__SEL_4__WIDTH                              5
#define HOST_INTF_GPIO_OUTPUT_MUX1__SEL_4__MASK                     0x01f00000U
#define HOST_INTF_GPIO_OUTPUT_MUX1__SEL_4__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x01f00000U) >> 20)
#define HOST_INTF_GPIO_OUTPUT_MUX1__SEL_4__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 20) & 0x01f00000U)
#define HOST_INTF_GPIO_OUTPUT_MUX1__SEL_4__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x01f00000U) | (((u_int32_t)(src) <<\
                    20) & 0x01f00000U)
#define HOST_INTF_GPIO_OUTPUT_MUX1__SEL_4__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 20) & ~0x01f00000U)))

/* macros for field SEL_5 */
#define HOST_INTF_GPIO_OUTPUT_MUX1__SEL_5__SHIFT                             25
#define HOST_INTF_GPIO_OUTPUT_MUX1__SEL_5__WIDTH                              5
#define HOST_INTF_GPIO_OUTPUT_MUX1__SEL_5__MASK                     0x3e000000U
#define HOST_INTF_GPIO_OUTPUT_MUX1__SEL_5__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x3e000000U) >> 25)
#define HOST_INTF_GPIO_OUTPUT_MUX1__SEL_5__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 25) & 0x3e000000U)
#define HOST_INTF_GPIO_OUTPUT_MUX1__SEL_5__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x3e000000U) | (((u_int32_t)(src) <<\
                    25) & 0x3e000000U)
#define HOST_INTF_GPIO_OUTPUT_MUX1__SEL_5__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 25) & ~0x3e000000U)))
#define HOST_INTF_GPIO_OUTPUT_MUX1__TYPE                              u_int32_t
#define HOST_INTF_GPIO_OUTPUT_MUX1__READ                            0x3fffffffU
#define HOST_INTF_GPIO_OUTPUT_MUX1__WRITE                           0x3fffffffU

#endif /* __HOST_INTF_GPIO_OUTPUT_MUX1_MACRO__ */


/* macros for host_intf_reg_block.HOST_INTF_GPIO_OUTPUT_MUX1 */
#define INST_HOST_INTF_REG_BLOCK__HOST_INTF_GPIO_OUTPUT_MUX1__NUM             1

/* macros for BlueprintGlobalNameSpace::HOST_INTF_GPIO_OUTPUT_MUX2 */
#ifndef __HOST_INTF_GPIO_OUTPUT_MUX2_MACRO__
#define __HOST_INTF_GPIO_OUTPUT_MUX2_MACRO__

/* macros for field SEL_6 */
#define HOST_INTF_GPIO_OUTPUT_MUX2__SEL_6__SHIFT                              0
#define HOST_INTF_GPIO_OUTPUT_MUX2__SEL_6__WIDTH                              5
#define HOST_INTF_GPIO_OUTPUT_MUX2__SEL_6__MASK                     0x0000001fU
#define HOST_INTF_GPIO_OUTPUT_MUX2__SEL_6__READ(src) \
                    (u_int32_t)(src)\
                    & 0x0000001fU
#define HOST_INTF_GPIO_OUTPUT_MUX2__SEL_6__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x0000001fU)
#define HOST_INTF_GPIO_OUTPUT_MUX2__SEL_6__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000001fU) | ((u_int32_t)(src) &\
                    0x0000001fU)
#define HOST_INTF_GPIO_OUTPUT_MUX2__SEL_6__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x0000001fU)))

/* macros for field SEL_7 */
#define HOST_INTF_GPIO_OUTPUT_MUX2__SEL_7__SHIFT                              5
#define HOST_INTF_GPIO_OUTPUT_MUX2__SEL_7__WIDTH                              5
#define HOST_INTF_GPIO_OUTPUT_MUX2__SEL_7__MASK                     0x000003e0U
#define HOST_INTF_GPIO_OUTPUT_MUX2__SEL_7__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x000003e0U) >> 5)
#define HOST_INTF_GPIO_OUTPUT_MUX2__SEL_7__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 5) & 0x000003e0U)
#define HOST_INTF_GPIO_OUTPUT_MUX2__SEL_7__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000003e0U) | (((u_int32_t)(src) <<\
                    5) & 0x000003e0U)
#define HOST_INTF_GPIO_OUTPUT_MUX2__SEL_7__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 5) & ~0x000003e0U)))

/* macros for field SEL_8 */
#define HOST_INTF_GPIO_OUTPUT_MUX2__SEL_8__SHIFT                             10
#define HOST_INTF_GPIO_OUTPUT_MUX2__SEL_8__WIDTH                              5
#define HOST_INTF_GPIO_OUTPUT_MUX2__SEL_8__MASK                     0x00007c00U
#define HOST_INTF_GPIO_OUTPUT_MUX2__SEL_8__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00007c00U) >> 10)
#define HOST_INTF_GPIO_OUTPUT_MUX2__SEL_8__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 10) & 0x00007c00U)
#define HOST_INTF_GPIO_OUTPUT_MUX2__SEL_8__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00007c00U) | (((u_int32_t)(src) <<\
                    10) & 0x00007c00U)
#define HOST_INTF_GPIO_OUTPUT_MUX2__SEL_8__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 10) & ~0x00007c00U)))

/* macros for field SEL_9 */
#define HOST_INTF_GPIO_OUTPUT_MUX2__SEL_9__SHIFT                             15
#define HOST_INTF_GPIO_OUTPUT_MUX2__SEL_9__WIDTH                              5
#define HOST_INTF_GPIO_OUTPUT_MUX2__SEL_9__MASK                     0x000f8000U
#define HOST_INTF_GPIO_OUTPUT_MUX2__SEL_9__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x000f8000U) >> 15)
#define HOST_INTF_GPIO_OUTPUT_MUX2__SEL_9__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 15) & 0x000f8000U)
#define HOST_INTF_GPIO_OUTPUT_MUX2__SEL_9__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000f8000U) | (((u_int32_t)(src) <<\
                    15) & 0x000f8000U)
#define HOST_INTF_GPIO_OUTPUT_MUX2__SEL_9__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 15) & ~0x000f8000U)))

/* macros for field SEL_10 */
#define HOST_INTF_GPIO_OUTPUT_MUX2__SEL_10__SHIFT                            20
#define HOST_INTF_GPIO_OUTPUT_MUX2__SEL_10__WIDTH                             5
#define HOST_INTF_GPIO_OUTPUT_MUX2__SEL_10__MASK                    0x01f00000U
#define HOST_INTF_GPIO_OUTPUT_MUX2__SEL_10__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x01f00000U) >> 20)
#define HOST_INTF_GPIO_OUTPUT_MUX2__SEL_10__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 20) & 0x01f00000U)
#define HOST_INTF_GPIO_OUTPUT_MUX2__SEL_10__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x01f00000U) | (((u_int32_t)(src) <<\
                    20) & 0x01f00000U)
#define HOST_INTF_GPIO_OUTPUT_MUX2__SEL_10__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 20) & ~0x01f00000U)))

/* macros for field SEL_11 */
#define HOST_INTF_GPIO_OUTPUT_MUX2__SEL_11__SHIFT                            25
#define HOST_INTF_GPIO_OUTPUT_MUX2__SEL_11__WIDTH                             5
#define HOST_INTF_GPIO_OUTPUT_MUX2__SEL_11__MASK                    0x3e000000U
#define HOST_INTF_GPIO_OUTPUT_MUX2__SEL_11__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x3e000000U) >> 25)
#define HOST_INTF_GPIO_OUTPUT_MUX2__SEL_11__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 25) & 0x3e000000U)
#define HOST_INTF_GPIO_OUTPUT_MUX2__SEL_11__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x3e000000U) | (((u_int32_t)(src) <<\
                    25) & 0x3e000000U)
#define HOST_INTF_GPIO_OUTPUT_MUX2__SEL_11__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 25) & ~0x3e000000U)))
#define HOST_INTF_GPIO_OUTPUT_MUX2__TYPE                              u_int32_t
#define HOST_INTF_GPIO_OUTPUT_MUX2__READ                            0x3fffffffU
#define HOST_INTF_GPIO_OUTPUT_MUX2__WRITE                           0x3fffffffU

#endif /* __HOST_INTF_GPIO_OUTPUT_MUX2_MACRO__ */


/* macros for host_intf_reg_block.HOST_INTF_GPIO_OUTPUT_MUX2 */
#define INST_HOST_INTF_REG_BLOCK__HOST_INTF_GPIO_OUTPUT_MUX2__NUM             1

/* macros for BlueprintGlobalNameSpace::HOST_INTF_GPIO_OUTPUT_MUX3 */
#ifndef __HOST_INTF_GPIO_OUTPUT_MUX3_MACRO__
#define __HOST_INTF_GPIO_OUTPUT_MUX3_MACRO__

/* macros for field SEL_12 */
#define HOST_INTF_GPIO_OUTPUT_MUX3__SEL_12__SHIFT                             0
#define HOST_INTF_GPIO_OUTPUT_MUX3__SEL_12__WIDTH                             5
#define HOST_INTF_GPIO_OUTPUT_MUX3__SEL_12__MASK                    0x0000001fU
#define HOST_INTF_GPIO_OUTPUT_MUX3__SEL_12__READ(src) \
                    (u_int32_t)(src)\
                    & 0x0000001fU
#define HOST_INTF_GPIO_OUTPUT_MUX3__SEL_12__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x0000001fU)
#define HOST_INTF_GPIO_OUTPUT_MUX3__SEL_12__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000001fU) | ((u_int32_t)(src) &\
                    0x0000001fU)
#define HOST_INTF_GPIO_OUTPUT_MUX3__SEL_12__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x0000001fU)))

/* macros for field SEL_13 */
#define HOST_INTF_GPIO_OUTPUT_MUX3__SEL_13__SHIFT                             5
#define HOST_INTF_GPIO_OUTPUT_MUX3__SEL_13__WIDTH                             5
#define HOST_INTF_GPIO_OUTPUT_MUX3__SEL_13__MASK                    0x000003e0U
#define HOST_INTF_GPIO_OUTPUT_MUX3__SEL_13__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x000003e0U) >> 5)
#define HOST_INTF_GPIO_OUTPUT_MUX3__SEL_13__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 5) & 0x000003e0U)
#define HOST_INTF_GPIO_OUTPUT_MUX3__SEL_13__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000003e0U) | (((u_int32_t)(src) <<\
                    5) & 0x000003e0U)
#define HOST_INTF_GPIO_OUTPUT_MUX3__SEL_13__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 5) & ~0x000003e0U)))

/* macros for field SEL_14 */
#define HOST_INTF_GPIO_OUTPUT_MUX3__SEL_14__SHIFT                            10
#define HOST_INTF_GPIO_OUTPUT_MUX3__SEL_14__WIDTH                             5
#define HOST_INTF_GPIO_OUTPUT_MUX3__SEL_14__MASK                    0x00007c00U
#define HOST_INTF_GPIO_OUTPUT_MUX3__SEL_14__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00007c00U) >> 10)
#define HOST_INTF_GPIO_OUTPUT_MUX3__SEL_14__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 10) & 0x00007c00U)
#define HOST_INTF_GPIO_OUTPUT_MUX3__SEL_14__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00007c00U) | (((u_int32_t)(src) <<\
                    10) & 0x00007c00U)
#define HOST_INTF_GPIO_OUTPUT_MUX3__SEL_14__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 10) & ~0x00007c00U)))

/* macros for field SEL_15 */
#define HOST_INTF_GPIO_OUTPUT_MUX3__SEL_15__SHIFT                            15
#define HOST_INTF_GPIO_OUTPUT_MUX3__SEL_15__WIDTH                             5
#define HOST_INTF_GPIO_OUTPUT_MUX3__SEL_15__MASK                    0x000f8000U
#define HOST_INTF_GPIO_OUTPUT_MUX3__SEL_15__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x000f8000U) >> 15)
#define HOST_INTF_GPIO_OUTPUT_MUX3__SEL_15__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 15) & 0x000f8000U)
#define HOST_INTF_GPIO_OUTPUT_MUX3__SEL_15__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000f8000U) | (((u_int32_t)(src) <<\
                    15) & 0x000f8000U)
#define HOST_INTF_GPIO_OUTPUT_MUX3__SEL_15__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 15) & ~0x000f8000U)))

/* macros for field SEL_16 */
#define HOST_INTF_GPIO_OUTPUT_MUX3__SEL_16__SHIFT                            20
#define HOST_INTF_GPIO_OUTPUT_MUX3__SEL_16__WIDTH                             5
#define HOST_INTF_GPIO_OUTPUT_MUX3__SEL_16__MASK                    0x01f00000U
#define HOST_INTF_GPIO_OUTPUT_MUX3__SEL_16__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x01f00000U) >> 20)
#define HOST_INTF_GPIO_OUTPUT_MUX3__SEL_16__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 20) & 0x01f00000U)
#define HOST_INTF_GPIO_OUTPUT_MUX3__SEL_16__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x01f00000U) | (((u_int32_t)(src) <<\
                    20) & 0x01f00000U)
#define HOST_INTF_GPIO_OUTPUT_MUX3__SEL_16__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 20) & ~0x01f00000U)))
#define HOST_INTF_GPIO_OUTPUT_MUX3__TYPE                              u_int32_t
#define HOST_INTF_GPIO_OUTPUT_MUX3__READ                            0x01ffffffU
#define HOST_INTF_GPIO_OUTPUT_MUX3__WRITE                           0x01ffffffU

#endif /* __HOST_INTF_GPIO_OUTPUT_MUX3_MACRO__ */


/* macros for host_intf_reg_block.HOST_INTF_GPIO_OUTPUT_MUX3 */
#define INST_HOST_INTF_REG_BLOCK__HOST_INTF_GPIO_OUTPUT_MUX3__NUM             1

/* macros for BlueprintGlobalNameSpace::HOST_INTF_GPIO_INPUT_STATE */
#ifndef __HOST_INTF_GPIO_INPUT_STATE_MACRO__
#define __HOST_INTF_GPIO_INPUT_STATE_MACRO__

/* macros for field ATT_LED */
#define HOST_INTF_GPIO_INPUT_STATE__ATT_LED__SHIFT                            0
#define HOST_INTF_GPIO_INPUT_STATE__ATT_LED__WIDTH                            1
#define HOST_INTF_GPIO_INPUT_STATE__ATT_LED__MASK                   0x00000001U
#define HOST_INTF_GPIO_INPUT_STATE__ATT_LED__READ(src) \
                    (u_int32_t)(src)\
                    & 0x00000001U
#define HOST_INTF_GPIO_INPUT_STATE__ATT_LED__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(1)
#define HOST_INTF_GPIO_INPUT_STATE__ATT_LED__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(0)

/* macros for field PWR_LED */
#define HOST_INTF_GPIO_INPUT_STATE__PWR_LED__SHIFT                            1
#define HOST_INTF_GPIO_INPUT_STATE__PWR_LED__WIDTH                            1
#define HOST_INTF_GPIO_INPUT_STATE__PWR_LED__MASK                   0x00000002U
#define HOST_INTF_GPIO_INPUT_STATE__PWR_LED__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000002U) >> 1)
#define HOST_INTF_GPIO_INPUT_STATE__PWR_LED__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | ((u_int32_t)(1) << 1)
#define HOST_INTF_GPIO_INPUT_STATE__PWR_LED__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | ((u_int32_t)(0) << 1)

/* macros for field WAKE_N */
#define HOST_INTF_GPIO_INPUT_STATE__WAKE_N__SHIFT                             2
#define HOST_INTF_GPIO_INPUT_STATE__WAKE_N__WIDTH                             1
#define HOST_INTF_GPIO_INPUT_STATE__WAKE_N__MASK                    0x00000004U
#define HOST_INTF_GPIO_INPUT_STATE__WAKE_N__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000004U) >> 2)
#define HOST_INTF_GPIO_INPUT_STATE__WAKE_N__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000004U) | ((u_int32_t)(1) << 2)
#define HOST_INTF_GPIO_INPUT_STATE__WAKE_N__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000004U) | ((u_int32_t)(0) << 2)

/* macros for field LED_NETWORK_EN */
#define HOST_INTF_GPIO_INPUT_STATE__LED_NETWORK_EN__SHIFT                     3
#define HOST_INTF_GPIO_INPUT_STATE__LED_NETWORK_EN__WIDTH                     1
#define HOST_INTF_GPIO_INPUT_STATE__LED_NETWORK_EN__MASK            0x00000008U
#define HOST_INTF_GPIO_INPUT_STATE__LED_NETWORK_EN__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000008U) >> 3)
#define HOST_INTF_GPIO_INPUT_STATE__LED_NETWORK_EN__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000008U) | ((u_int32_t)(1) << 3)
#define HOST_INTF_GPIO_INPUT_STATE__LED_NETWORK_EN__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000008U) | ((u_int32_t)(0) << 3)

/* macros for field LED_POWER_EN */
#define HOST_INTF_GPIO_INPUT_STATE__LED_POWER_EN__SHIFT                       4
#define HOST_INTF_GPIO_INPUT_STATE__LED_POWER_EN__WIDTH                       1
#define HOST_INTF_GPIO_INPUT_STATE__LED_POWER_EN__MASK              0x00000010U
#define HOST_INTF_GPIO_INPUT_STATE__LED_POWER_EN__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000010U) >> 4)
#define HOST_INTF_GPIO_INPUT_STATE__LED_POWER_EN__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000010U) | ((u_int32_t)(1) << 4)
#define HOST_INTF_GPIO_INPUT_STATE__LED_POWER_EN__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000010U) | ((u_int32_t)(0) << 4)

/* macros for field RX_CLEAR_EXTERNAL */
#define HOST_INTF_GPIO_INPUT_STATE__RX_CLEAR_EXTERNAL__SHIFT                  5
#define HOST_INTF_GPIO_INPUT_STATE__RX_CLEAR_EXTERNAL__WIDTH                  1
#define HOST_INTF_GPIO_INPUT_STATE__RX_CLEAR_EXTERNAL__MASK         0x00000020U
#define HOST_INTF_GPIO_INPUT_STATE__RX_CLEAR_EXTERNAL__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000020U) >> 5)
#define HOST_INTF_GPIO_INPUT_STATE__RX_CLEAR_EXTERNAL__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000020U) | ((u_int32_t)(1) << 5)
#define HOST_INTF_GPIO_INPUT_STATE__RX_CLEAR_EXTERNAL__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000020U) | ((u_int32_t)(0) << 5)

/* macros for field TX_FRAME */
#define HOST_INTF_GPIO_INPUT_STATE__TX_FRAME__SHIFT                           6
#define HOST_INTF_GPIO_INPUT_STATE__TX_FRAME__WIDTH                           1
#define HOST_INTF_GPIO_INPUT_STATE__TX_FRAME__MASK                  0x00000040U
#define HOST_INTF_GPIO_INPUT_STATE__TX_FRAME__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000040U) >> 6)
#define HOST_INTF_GPIO_INPUT_STATE__TX_FRAME__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000040U) | ((u_int32_t)(1) << 6)
#define HOST_INTF_GPIO_INPUT_STATE__TX_FRAME__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000040U) | ((u_int32_t)(0) << 6)

/* macros for field BB_RADIO_XLNAON */
#define HOST_INTF_GPIO_INPUT_STATE__BB_RADIO_XLNAON__SHIFT                    7
#define HOST_INTF_GPIO_INPUT_STATE__BB_RADIO_XLNAON__WIDTH                    1
#define HOST_INTF_GPIO_INPUT_STATE__BB_RADIO_XLNAON__MASK           0x00000080U
#define HOST_INTF_GPIO_INPUT_STATE__BB_RADIO_XLNAON__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000080U) >> 7)
#define HOST_INTF_GPIO_INPUT_STATE__BB_RADIO_XLNAON__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000080U) | ((u_int32_t)(1) << 7)
#define HOST_INTF_GPIO_INPUT_STATE__BB_RADIO_XLNAON__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000080U) | ((u_int32_t)(0) << 7)
#define HOST_INTF_GPIO_INPUT_STATE__TYPE                              u_int32_t
#define HOST_INTF_GPIO_INPUT_STATE__READ                            0x000000ffU

#endif /* __HOST_INTF_GPIO_INPUT_STATE_MACRO__ */


/* macros for host_intf_reg_block.HOST_INTF_GPIO_INPUT_STATE */
#define INST_HOST_INTF_REG_BLOCK__HOST_INTF_GPIO_INPUT_STATE__NUM             1

/* macros for BlueprintGlobalNameSpace::HOST_INTF_SPARE */
#ifndef __HOST_INTF_SPARE_MACRO__
#define __HOST_INTF_SPARE_MACRO__

/* macros for field SUPER_CONDOR_L1 */
#define HOST_INTF_SPARE__SUPER_CONDOR_L1__SHIFT                               0
#define HOST_INTF_SPARE__SUPER_CONDOR_L1__WIDTH                              32
#define HOST_INTF_SPARE__SUPER_CONDOR_L1__MASK                      0xffffffffU
#define HOST_INTF_SPARE__SUPER_CONDOR_L1__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define HOST_INTF_SPARE__SUPER_CONDOR_L1__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0xffffffffU)
#define HOST_INTF_SPARE__SUPER_CONDOR_L1__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xffffffffU) | ((u_int32_t)(src) &\
                    0xffffffffU)
#define HOST_INTF_SPARE__SUPER_CONDOR_L1__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0xffffffffU)))
#define HOST_INTF_SPARE__TYPE                                         u_int32_t
#define HOST_INTF_SPARE__READ                                       0xffffffffU
#define HOST_INTF_SPARE__WRITE                                      0xffffffffU

#endif /* __HOST_INTF_SPARE_MACRO__ */


/* macros for host_intf_reg_block.HOST_INTF_SPARE */
#define INST_HOST_INTF_REG_BLOCK__HOST_INTF_SPARE__NUM                        1

/* macros for BlueprintGlobalNameSpace::HOST_INTF_PCIE_CORE_RST_EN */
#ifndef __HOST_INTF_PCIE_CORE_RST_EN_MACRO__
#define __HOST_INTF_PCIE_CORE_RST_EN_MACRO__

/* macros for field TRAINING_RST_EN */
#define HOST_INTF_PCIE_CORE_RST_EN__TRAINING_RST_EN__SHIFT                    0
#define HOST_INTF_PCIE_CORE_RST_EN__TRAINING_RST_EN__WIDTH                    1
#define HOST_INTF_PCIE_CORE_RST_EN__TRAINING_RST_EN__MASK           0x00000001U
#define HOST_INTF_PCIE_CORE_RST_EN__TRAINING_RST_EN__READ(src) \
                    (u_int32_t)(src)\
                    & 0x00000001U
#define HOST_INTF_PCIE_CORE_RST_EN__TRAINING_RST_EN__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x00000001U)
#define HOST_INTF_PCIE_CORE_RST_EN__TRAINING_RST_EN__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | ((u_int32_t)(src) &\
                    0x00000001U)
#define HOST_INTF_PCIE_CORE_RST_EN__TRAINING_RST_EN__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00000001U)))
#define HOST_INTF_PCIE_CORE_RST_EN__TRAINING_RST_EN__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(1)
#define HOST_INTF_PCIE_CORE_RST_EN__TRAINING_RST_EN__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(0)

/* macros for field XMLH_LINK_RST_EN */
#define HOST_INTF_PCIE_CORE_RST_EN__XMLH_LINK_RST_EN__SHIFT                   1
#define HOST_INTF_PCIE_CORE_RST_EN__XMLH_LINK_RST_EN__WIDTH                   1
#define HOST_INTF_PCIE_CORE_RST_EN__XMLH_LINK_RST_EN__MASK          0x00000002U
#define HOST_INTF_PCIE_CORE_RST_EN__XMLH_LINK_RST_EN__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000002U) >> 1)
#define HOST_INTF_PCIE_CORE_RST_EN__XMLH_LINK_RST_EN__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 1) & 0x00000002U)
#define HOST_INTF_PCIE_CORE_RST_EN__XMLH_LINK_RST_EN__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | (((u_int32_t)(src) <<\
                    1) & 0x00000002U)
#define HOST_INTF_PCIE_CORE_RST_EN__XMLH_LINK_RST_EN__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 1) & ~0x00000002U)))
#define HOST_INTF_PCIE_CORE_RST_EN__XMLH_LINK_RST_EN__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | ((u_int32_t)(1) << 1)
#define HOST_INTF_PCIE_CORE_RST_EN__XMLH_LINK_RST_EN__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | ((u_int32_t)(0) << 1)

/* macros for field RDLH_LINK_RST_EN */
#define HOST_INTF_PCIE_CORE_RST_EN__RDLH_LINK_RST_EN__SHIFT                   2
#define HOST_INTF_PCIE_CORE_RST_EN__RDLH_LINK_RST_EN__WIDTH                   1
#define HOST_INTF_PCIE_CORE_RST_EN__RDLH_LINK_RST_EN__MASK          0x00000004U
#define HOST_INTF_PCIE_CORE_RST_EN__RDLH_LINK_RST_EN__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000004U) >> 2)
#define HOST_INTF_PCIE_CORE_RST_EN__RDLH_LINK_RST_EN__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 2) & 0x00000004U)
#define HOST_INTF_PCIE_CORE_RST_EN__RDLH_LINK_RST_EN__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000004U) | (((u_int32_t)(src) <<\
                    2) & 0x00000004U)
#define HOST_INTF_PCIE_CORE_RST_EN__RDLH_LINK_RST_EN__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 2) & ~0x00000004U)))
#define HOST_INTF_PCIE_CORE_RST_EN__RDLH_LINK_RST_EN__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000004U) | ((u_int32_t)(1) << 2)
#define HOST_INTF_PCIE_CORE_RST_EN__RDLH_LINK_RST_EN__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000004U) | ((u_int32_t)(0) << 2)

/* macros for field LINK_REQ_RST_EN */
#define HOST_INTF_PCIE_CORE_RST_EN__LINK_REQ_RST_EN__SHIFT                    3
#define HOST_INTF_PCIE_CORE_RST_EN__LINK_REQ_RST_EN__WIDTH                    1
#define HOST_INTF_PCIE_CORE_RST_EN__LINK_REQ_RST_EN__MASK           0x00000008U
#define HOST_INTF_PCIE_CORE_RST_EN__LINK_REQ_RST_EN__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000008U) >> 3)
#define HOST_INTF_PCIE_CORE_RST_EN__LINK_REQ_RST_EN__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 3) & 0x00000008U)
#define HOST_INTF_PCIE_CORE_RST_EN__LINK_REQ_RST_EN__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000008U) | (((u_int32_t)(src) <<\
                    3) & 0x00000008U)
#define HOST_INTF_PCIE_CORE_RST_EN__LINK_REQ_RST_EN__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 3) & ~0x00000008U)))
#define HOST_INTF_PCIE_CORE_RST_EN__LINK_REQ_RST_EN__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000008U) | ((u_int32_t)(1) << 3)
#define HOST_INTF_PCIE_CORE_RST_EN__LINK_REQ_RST_EN__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000008U) | ((u_int32_t)(0) << 3)
#define HOST_INTF_PCIE_CORE_RST_EN__TYPE                              u_int32_t
#define HOST_INTF_PCIE_CORE_RST_EN__READ                            0x0000000fU
#define HOST_INTF_PCIE_CORE_RST_EN__WRITE                           0x0000000fU

#endif /* __HOST_INTF_PCIE_CORE_RST_EN_MACRO__ */


/* macros for host_intf_reg_block.HOST_INTF_PCIE_CORE_RST_EN */
#define INST_HOST_INTF_REG_BLOCK__HOST_INTF_PCIE_CORE_RST_EN__NUM             1

/* macros for BlueprintGlobalNameSpace::HOST_INTF_CLKRUN */
#ifndef __HOST_INTF_CLKRUN_MACRO__
#define __HOST_INTF_CLKRUN_MACRO__

/* macros for field FORCE */
#define HOST_INTF_CLKRUN__FORCE__SHIFT                                        0
#define HOST_INTF_CLKRUN__FORCE__WIDTH                                        1
#define HOST_INTF_CLKRUN__FORCE__MASK                               0x00000001U
#define HOST_INTF_CLKRUN__FORCE__READ(src)       (u_int32_t)(src) & 0x00000001U
#define HOST_INTF_CLKRUN__FORCE__WRITE(src)    ((u_int32_t)(src) & 0x00000001U)
#define HOST_INTF_CLKRUN__FORCE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | ((u_int32_t)(src) &\
                    0x00000001U)
#define HOST_INTF_CLKRUN__FORCE__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00000001U)))
#define HOST_INTF_CLKRUN__FORCE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(1)
#define HOST_INTF_CLKRUN__FORCE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(0)

/* macros for field CNT */
#define HOST_INTF_CLKRUN__CNT__SHIFT                                          1
#define HOST_INTF_CLKRUN__CNT__WIDTH                                         31
#define HOST_INTF_CLKRUN__CNT__MASK                                 0xfffffffeU
#define HOST_INTF_CLKRUN__CNT__READ(src) \
                    (((u_int32_t)(src)\
                    & 0xfffffffeU) >> 1)
#define HOST_INTF_CLKRUN__CNT__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 1) & 0xfffffffeU)
#define HOST_INTF_CLKRUN__CNT__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xfffffffeU) | (((u_int32_t)(src) <<\
                    1) & 0xfffffffeU)
#define HOST_INTF_CLKRUN__CNT__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 1) & ~0xfffffffeU)))
#define HOST_INTF_CLKRUN__TYPE                                        u_int32_t
#define HOST_INTF_CLKRUN__READ                                      0xffffffffU
#define HOST_INTF_CLKRUN__WRITE                                     0xffffffffU

#endif /* __HOST_INTF_CLKRUN_MACRO__ */


/* macros for host_intf_reg_block.HOST_INTF_CLKRUN */
#define INST_HOST_INTF_REG_BLOCK__HOST_INTF_CLKRUN__NUM                       1

/* macros for BlueprintGlobalNameSpace::HOST_INTF_EEPROM_STS */
#ifndef __HOST_INTF_EEPROM_STS_MACRO__
#define __HOST_INTF_EEPROM_STS_MACRO__

/* macros for field RD_DATA */
#define HOST_INTF_EEPROM_STS__RD_DATA__SHIFT                                  0
#define HOST_INTF_EEPROM_STS__RD_DATA__WIDTH                                 16
#define HOST_INTF_EEPROM_STS__RD_DATA__MASK                         0x0000ffffU
#define HOST_INTF_EEPROM_STS__RD_DATA__READ(src) (u_int32_t)(src) & 0x0000ffffU

/* macros for field BUSY */
#define HOST_INTF_EEPROM_STS__BUSY__SHIFT                                    16
#define HOST_INTF_EEPROM_STS__BUSY__WIDTH                                     1
#define HOST_INTF_EEPROM_STS__BUSY__MASK                            0x00010000U
#define HOST_INTF_EEPROM_STS__BUSY__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00010000U) >> 16)
#define HOST_INTF_EEPROM_STS__BUSY__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00010000U) | ((u_int32_t)(1) << 16)
#define HOST_INTF_EEPROM_STS__BUSY__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00010000U) | ((u_int32_t)(0) << 16)

/* macros for field BUSY_ACCESS */
#define HOST_INTF_EEPROM_STS__BUSY_ACCESS__SHIFT                             17
#define HOST_INTF_EEPROM_STS__BUSY_ACCESS__WIDTH                              1
#define HOST_INTF_EEPROM_STS__BUSY_ACCESS__MASK                     0x00020000U
#define HOST_INTF_EEPROM_STS__BUSY_ACCESS__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00020000U) >> 17)
#define HOST_INTF_EEPROM_STS__BUSY_ACCESS__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00020000U) | ((u_int32_t)(1) << 17)
#define HOST_INTF_EEPROM_STS__BUSY_ACCESS__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00020000U) | ((u_int32_t)(0) << 17)

/* macros for field MASK_ACCESS */
#define HOST_INTF_EEPROM_STS__MASK_ACCESS__SHIFT                             18
#define HOST_INTF_EEPROM_STS__MASK_ACCESS__WIDTH                              1
#define HOST_INTF_EEPROM_STS__MASK_ACCESS__MASK                     0x00040000U
#define HOST_INTF_EEPROM_STS__MASK_ACCESS__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00040000U) >> 18)
#define HOST_INTF_EEPROM_STS__MASK_ACCESS__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00040000U) | ((u_int32_t)(1) << 18)
#define HOST_INTF_EEPROM_STS__MASK_ACCESS__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00040000U) | ((u_int32_t)(0) << 18)
#define HOST_INTF_EEPROM_STS__TYPE                                    u_int32_t
#define HOST_INTF_EEPROM_STS__READ                                  0x0007ffffU

#endif /* __HOST_INTF_EEPROM_STS_MACRO__ */


/* macros for host_intf_reg_block.HOST_INTF_EEPROM_STS */
#define INST_HOST_INTF_REG_BLOCK__HOST_INTF_EEPROM_STS__NUM                   1

/* macros for BlueprintGlobalNameSpace::HOST_INTF_OBS_CTRL */
#ifndef __HOST_INTF_OBS_CTRL_MACRO__
#define __HOST_INTF_OBS_CTRL_MACRO__

/* macros for field OBS_SEL */
#define HOST_INTF_OBS_CTRL__OBS_SEL__SHIFT                                    0
#define HOST_INTF_OBS_CTRL__OBS_SEL__WIDTH                                    4
#define HOST_INTF_OBS_CTRL__OBS_SEL__MASK                           0x0000000fU
#define HOST_INTF_OBS_CTRL__OBS_SEL__READ(src)   (u_int32_t)(src) & 0x0000000fU
#define HOST_INTF_OBS_CTRL__OBS_SEL__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x0000000fU)
#define HOST_INTF_OBS_CTRL__OBS_SEL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000000fU) | ((u_int32_t)(src) &\
                    0x0000000fU)
#define HOST_INTF_OBS_CTRL__OBS_SEL__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x0000000fU)))

/* macros for field ANT_SEL */
#define HOST_INTF_OBS_CTRL__ANT_SEL__SHIFT                                    4
#define HOST_INTF_OBS_CTRL__ANT_SEL__WIDTH                                    2
#define HOST_INTF_OBS_CTRL__ANT_SEL__MASK                           0x00000030U
#define HOST_INTF_OBS_CTRL__ANT_SEL__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000030U) >> 4)
#define HOST_INTF_OBS_CTRL__ANT_SEL__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 4) & 0x00000030U)
#define HOST_INTF_OBS_CTRL__ANT_SEL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000030U) | (((u_int32_t)(src) <<\
                    4) & 0x00000030U)
#define HOST_INTF_OBS_CTRL__ANT_SEL__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 4) & ~0x00000030U)))

/* macros for field OBS_MODE */
#define HOST_INTF_OBS_CTRL__OBS_MODE__SHIFT                                   6
#define HOST_INTF_OBS_CTRL__OBS_MODE__WIDTH                                   2
#define HOST_INTF_OBS_CTRL__OBS_MODE__MASK                          0x000000c0U
#define HOST_INTF_OBS_CTRL__OBS_MODE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x000000c0U) >> 6)
#define HOST_INTF_OBS_CTRL__OBS_MODE__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 6) & 0x000000c0U)
#define HOST_INTF_OBS_CTRL__OBS_MODE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000000c0U) | (((u_int32_t)(src) <<\
                    6) & 0x000000c0U)
#define HOST_INTF_OBS_CTRL__OBS_MODE__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 6) & ~0x000000c0U)))
#define HOST_INTF_OBS_CTRL__TYPE                                      u_int32_t
#define HOST_INTF_OBS_CTRL__READ                                    0x000000ffU
#define HOST_INTF_OBS_CTRL__WRITE                                   0x000000ffU

#endif /* __HOST_INTF_OBS_CTRL_MACRO__ */


/* macros for host_intf_reg_block.HOST_INTF_OBS_CTRL */
#define INST_HOST_INTF_REG_BLOCK__HOST_INTF_OBS_CTRL__NUM                     1

/* macros for BlueprintGlobalNameSpace::HOST_INTF_RFSILENT */
#ifndef __HOST_INTF_RFSILENT_MACRO__
#define __HOST_INTF_RFSILENT_MACRO__

/* macros for field FORCE */
#define HOST_INTF_RFSILENT__FORCE__SHIFT                                      0
#define HOST_INTF_RFSILENT__FORCE__WIDTH                                      1
#define HOST_INTF_RFSILENT__FORCE__MASK                             0x00000001U
#define HOST_INTF_RFSILENT__FORCE__READ(src)     (u_int32_t)(src) & 0x00000001U
#define HOST_INTF_RFSILENT__FORCE__WRITE(src)  ((u_int32_t)(src) & 0x00000001U)
#define HOST_INTF_RFSILENT__FORCE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | ((u_int32_t)(src) &\
                    0x00000001U)
#define HOST_INTF_RFSILENT__FORCE__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00000001U)))
#define HOST_INTF_RFSILENT__FORCE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(1)
#define HOST_INTF_RFSILENT__FORCE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(0)

/* macros for field INVERT */
#define HOST_INTF_RFSILENT__INVERT__SHIFT                                     1
#define HOST_INTF_RFSILENT__INVERT__WIDTH                                     1
#define HOST_INTF_RFSILENT__INVERT__MASK                            0x00000002U
#define HOST_INTF_RFSILENT__INVERT__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000002U) >> 1)
#define HOST_INTF_RFSILENT__INVERT__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 1) & 0x00000002U)
#define HOST_INTF_RFSILENT__INVERT__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | (((u_int32_t)(src) <<\
                    1) & 0x00000002U)
#define HOST_INTF_RFSILENT__INVERT__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 1) & ~0x00000002U)))
#define HOST_INTF_RFSILENT__INVERT__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | ((u_int32_t)(1) << 1)
#define HOST_INTF_RFSILENT__INVERT__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | ((u_int32_t)(0) << 1)

/* macros for field RTC_RESET_INVERT */
#define HOST_INTF_RFSILENT__RTC_RESET_INVERT__SHIFT                           2
#define HOST_INTF_RFSILENT__RTC_RESET_INVERT__WIDTH                           1
#define HOST_INTF_RFSILENT__RTC_RESET_INVERT__MASK                  0x00000004U
#define HOST_INTF_RFSILENT__RTC_RESET_INVERT__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000004U) >> 2)
#define HOST_INTF_RFSILENT__RTC_RESET_INVERT__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 2) & 0x00000004U)
#define HOST_INTF_RFSILENT__RTC_RESET_INVERT__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000004U) | (((u_int32_t)(src) <<\
                    2) & 0x00000004U)
#define HOST_INTF_RFSILENT__RTC_RESET_INVERT__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 2) & ~0x00000004U)))
#define HOST_INTF_RFSILENT__RTC_RESET_INVERT__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000004U) | ((u_int32_t)(1) << 2)
#define HOST_INTF_RFSILENT__RTC_RESET_INVERT__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000004U) | ((u_int32_t)(0) << 2)
#define HOST_INTF_RFSILENT__TYPE                                      u_int32_t
#define HOST_INTF_RFSILENT__READ                                    0x00000007U
#define HOST_INTF_RFSILENT__WRITE                                   0x00000007U

#endif /* __HOST_INTF_RFSILENT_MACRO__ */


/* macros for host_intf_reg_block.HOST_INTF_RFSILENT */
#define INST_HOST_INTF_REG_BLOCK__HOST_INTF_RFSILENT__NUM                     1

/* macros for BlueprintGlobalNameSpace::HOST_INTF_GPIO_PDPU */
#ifndef __HOST_INTF_GPIO_PDPU_MACRO__
#define __HOST_INTF_GPIO_PDPU_MACRO__

/* macros for field INT */
#define HOST_INTF_GPIO_PDPU__INT__SHIFT                                       0
#define HOST_INTF_GPIO_PDPU__INT__WIDTH                                      32
#define HOST_INTF_GPIO_PDPU__INT__MASK                              0xffffffffU
#define HOST_INTF_GPIO_PDPU__INT__READ(src)      (u_int32_t)(src) & 0xffffffffU
#define HOST_INTF_GPIO_PDPU__INT__WRITE(src)   ((u_int32_t)(src) & 0xffffffffU)
#define HOST_INTF_GPIO_PDPU__INT__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xffffffffU) | ((u_int32_t)(src) &\
                    0xffffffffU)
#define HOST_INTF_GPIO_PDPU__INT__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0xffffffffU)))
#define HOST_INTF_GPIO_PDPU__TYPE                                     u_int32_t
#define HOST_INTF_GPIO_PDPU__READ                                   0xffffffffU
#define HOST_INTF_GPIO_PDPU__WRITE                                  0xffffffffU

#endif /* __HOST_INTF_GPIO_PDPU_MACRO__ */


/* macros for host_intf_reg_block.HOST_INTF_GPIO_PDPU */
#define INST_HOST_INTF_REG_BLOCK__HOST_INTF_GPIO_PDPU__NUM                    1

/* macros for BlueprintGlobalNameSpace::HOST_INTF_GPIO_PDPU1 */
#ifndef __HOST_INTF_GPIO_PDPU1_MACRO__
#define __HOST_INTF_GPIO_PDPU1_MACRO__

/* macros for field INT */
#define HOST_INTF_GPIO_PDPU1__INT__SHIFT                                      0
#define HOST_INTF_GPIO_PDPU1__INT__WIDTH                                      2
#define HOST_INTF_GPIO_PDPU1__INT__MASK                             0x00000003U
#define HOST_INTF_GPIO_PDPU1__INT__READ(src)     (u_int32_t)(src) & 0x00000003U
#define HOST_INTF_GPIO_PDPU1__INT__WRITE(src)  ((u_int32_t)(src) & 0x00000003U)
#define HOST_INTF_GPIO_PDPU1__INT__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000003U) | ((u_int32_t)(src) &\
                    0x00000003U)
#define HOST_INTF_GPIO_PDPU1__INT__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00000003U)))
#define HOST_INTF_GPIO_PDPU1__TYPE                                    u_int32_t
#define HOST_INTF_GPIO_PDPU1__READ                                  0x00000003U
#define HOST_INTF_GPIO_PDPU1__WRITE                                 0x00000003U

#endif /* __HOST_INTF_GPIO_PDPU1_MACRO__ */


/* macros for host_intf_reg_block.HOST_INTF_GPIO_PDPU1 */
#define INST_HOST_INTF_REG_BLOCK__HOST_INTF_GPIO_PDPU1__NUM                   1

/* macros for BlueprintGlobalNameSpace::HOST_INTF_GPIO_DS */
#ifndef __HOST_INTF_GPIO_DS_MACRO__
#define __HOST_INTF_GPIO_DS_MACRO__

/* macros for field INT */
#define HOST_INTF_GPIO_DS__INT__SHIFT                                         0
#define HOST_INTF_GPIO_DS__INT__WIDTH                                        32
#define HOST_INTF_GPIO_DS__INT__MASK                                0xffffffffU
#define HOST_INTF_GPIO_DS__INT__READ(src)        (u_int32_t)(src) & 0xffffffffU
#define HOST_INTF_GPIO_DS__INT__WRITE(src)     ((u_int32_t)(src) & 0xffffffffU)
#define HOST_INTF_GPIO_DS__INT__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xffffffffU) | ((u_int32_t)(src) &\
                    0xffffffffU)
#define HOST_INTF_GPIO_DS__INT__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0xffffffffU)))
#define HOST_INTF_GPIO_DS__TYPE                                       u_int32_t
#define HOST_INTF_GPIO_DS__READ                                     0xffffffffU
#define HOST_INTF_GPIO_DS__WRITE                                    0xffffffffU

#endif /* __HOST_INTF_GPIO_DS_MACRO__ */


/* macros for host_intf_reg_block.HOST_INTF_GPIO_DS */
#define INST_HOST_INTF_REG_BLOCK__HOST_INTF_GPIO_DS__NUM                      1

/* macros for BlueprintGlobalNameSpace::HOST_INTF_GPIO_DS1 */
#ifndef __HOST_INTF_GPIO_DS1_MACRO__
#define __HOST_INTF_GPIO_DS1_MACRO__

/* macros for field INT */
#define HOST_INTF_GPIO_DS1__INT__SHIFT                                        0
#define HOST_INTF_GPIO_DS1__INT__WIDTH                                        2
#define HOST_INTF_GPIO_DS1__INT__MASK                               0x00000003U
#define HOST_INTF_GPIO_DS1__INT__READ(src)       (u_int32_t)(src) & 0x00000003U
#define HOST_INTF_GPIO_DS1__INT__WRITE(src)    ((u_int32_t)(src) & 0x00000003U)
#define HOST_INTF_GPIO_DS1__INT__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000003U) | ((u_int32_t)(src) &\
                    0x00000003U)
#define HOST_INTF_GPIO_DS1__INT__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00000003U)))
#define HOST_INTF_GPIO_DS1__TYPE                                      u_int32_t
#define HOST_INTF_GPIO_DS1__READ                                    0x00000003U
#define HOST_INTF_GPIO_DS1__WRITE                                   0x00000003U

#endif /* __HOST_INTF_GPIO_DS1_MACRO__ */


/* macros for host_intf_reg_block.HOST_INTF_GPIO_DS1 */
#define INST_HOST_INTF_REG_BLOCK__HOST_INTF_GPIO_DS1__NUM                     1

/* macros for BlueprintGlobalNameSpace::HOST_INTF_MISC */
#ifndef __HOST_INTF_MISC_MACRO__
#define __HOST_INTF_MISC_MACRO__

/* macros for field AT_SPEED_EN */
#define HOST_INTF_MISC__AT_SPEED_EN__SHIFT                                    0
#define HOST_INTF_MISC__AT_SPEED_EN__WIDTH                                    1
#define HOST_INTF_MISC__AT_SPEED_EN__MASK                           0x00000001U
#define HOST_INTF_MISC__AT_SPEED_EN__READ(src)   (u_int32_t)(src) & 0x00000001U
#define HOST_INTF_MISC__AT_SPEED_EN__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x00000001U)
#define HOST_INTF_MISC__AT_SPEED_EN__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | ((u_int32_t)(src) &\
                    0x00000001U)
#define HOST_INTF_MISC__AT_SPEED_EN__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00000001U)))
#define HOST_INTF_MISC__AT_SPEED_EN__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(1)
#define HOST_INTF_MISC__AT_SPEED_EN__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(0)

/* macros for field OTP_DEBUG_MODE_SEL */
#define HOST_INTF_MISC__OTP_DEBUG_MODE_SEL__SHIFT                             1
#define HOST_INTF_MISC__OTP_DEBUG_MODE_SEL__WIDTH                             1
#define HOST_INTF_MISC__OTP_DEBUG_MODE_SEL__MASK                    0x00000002U
#define HOST_INTF_MISC__OTP_DEBUG_MODE_SEL__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000002U) >> 1)
#define HOST_INTF_MISC__OTP_DEBUG_MODE_SEL__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 1) & 0x00000002U)
#define HOST_INTF_MISC__OTP_DEBUG_MODE_SEL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | (((u_int32_t)(src) <<\
                    1) & 0x00000002U)
#define HOST_INTF_MISC__OTP_DEBUG_MODE_SEL__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 1) & ~0x00000002U)))
#define HOST_INTF_MISC__OTP_DEBUG_MODE_SEL__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | ((u_int32_t)(1) << 1)
#define HOST_INTF_MISC__OTP_DEBUG_MODE_SEL__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | ((u_int32_t)(0) << 1)

/* macros for field OTP_DEBUG_EFUSE_MEM_SEL */
#define HOST_INTF_MISC__OTP_DEBUG_EFUSE_MEM_SEL__SHIFT                        2
#define HOST_INTF_MISC__OTP_DEBUG_EFUSE_MEM_SEL__WIDTH                        1
#define HOST_INTF_MISC__OTP_DEBUG_EFUSE_MEM_SEL__MASK               0x00000004U
#define HOST_INTF_MISC__OTP_DEBUG_EFUSE_MEM_SEL__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000004U) >> 2)
#define HOST_INTF_MISC__OTP_DEBUG_EFUSE_MEM_SEL__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 2) & 0x00000004U)
#define HOST_INTF_MISC__OTP_DEBUG_EFUSE_MEM_SEL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000004U) | (((u_int32_t)(src) <<\
                    2) & 0x00000004U)
#define HOST_INTF_MISC__OTP_DEBUG_EFUSE_MEM_SEL__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 2) & ~0x00000004U)))
#define HOST_INTF_MISC__OTP_DEBUG_EFUSE_MEM_SEL__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000004U) | ((u_int32_t)(1) << 2)
#define HOST_INTF_MISC__OTP_DEBUG_EFUSE_MEM_SEL__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000004U) | ((u_int32_t)(0) << 2)
#define HOST_INTF_MISC__TYPE                                          u_int32_t
#define HOST_INTF_MISC__READ                                        0x00000007U
#define HOST_INTF_MISC__WRITE                                       0x00000007U

#endif /* __HOST_INTF_MISC_MACRO__ */


/* macros for host_intf_reg_block.HOST_INTF_MISC */
#define INST_HOST_INTF_REG_BLOCK__HOST_INTF_MISC__NUM                         1

/* macros for BlueprintGlobalNameSpace::HOST_INTF_PCIE_MSI */
#ifndef __HOST_INTF_PCIE_MSI_MACRO__
#define __HOST_INTF_PCIE_MSI_MACRO__

/* macros for field INT_EN */
#define HOST_INTF_PCIE_MSI__INT_EN__SHIFT                                     0
#define HOST_INTF_PCIE_MSI__INT_EN__WIDTH                                     1
#define HOST_INTF_PCIE_MSI__INT_EN__MASK                            0x00000001U
#define HOST_INTF_PCIE_MSI__INT_EN__READ(src)    (u_int32_t)(src) & 0x00000001U
#define HOST_INTF_PCIE_MSI__INT_EN__WRITE(src) ((u_int32_t)(src) & 0x00000001U)
#define HOST_INTF_PCIE_MSI__INT_EN__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | ((u_int32_t)(src) &\
                    0x00000001U)
#define HOST_INTF_PCIE_MSI__INT_EN__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00000001U)))
#define HOST_INTF_PCIE_MSI__INT_EN__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(1)
#define HOST_INTF_PCIE_MSI__INT_EN__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(0)

/* macros for field MULTI_MSI */
#define HOST_INTF_PCIE_MSI__MULTI_MSI__SHIFT                                  1
#define HOST_INTF_PCIE_MSI__MULTI_MSI__WIDTH                                  8
#define HOST_INTF_PCIE_MSI__MULTI_MSI__MASK                         0x000001feU
#define HOST_INTF_PCIE_MSI__MULTI_MSI__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x000001feU) >> 1)
#define HOST_INTF_PCIE_MSI__MULTI_MSI__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 1) & 0x000001feU)
#define HOST_INTF_PCIE_MSI__MULTI_MSI__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000001feU) | (((u_int32_t)(src) <<\
                    1) & 0x000001feU)
#define HOST_INTF_PCIE_MSI__MULTI_MSI__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 1) & ~0x000001feU)))

/* macros for field INT_PENDING_ADDR */
#define HOST_INTF_PCIE_MSI__INT_PENDING_ADDR__SHIFT                           9
#define HOST_INTF_PCIE_MSI__INT_PENDING_ADDR__WIDTH                          16
#define HOST_INTF_PCIE_MSI__INT_PENDING_ADDR__MASK                  0x01fffe00U
#define HOST_INTF_PCIE_MSI__INT_PENDING_ADDR__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x01fffe00U) >> 9)
#define HOST_INTF_PCIE_MSI__INT_PENDING_ADDR__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 9) & 0x01fffe00U)
#define HOST_INTF_PCIE_MSI__INT_PENDING_ADDR__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x01fffe00U) | (((u_int32_t)(src) <<\
                    9) & 0x01fffe00U)
#define HOST_INTF_PCIE_MSI__INT_PENDING_ADDR__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 9) & ~0x01fffe00U)))

/* macros for field HW_DBI_WR_EN */
#define HOST_INTF_PCIE_MSI__HW_DBI_WR_EN__SHIFT                              25
#define HOST_INTF_PCIE_MSI__HW_DBI_WR_EN__WIDTH                               1
#define HOST_INTF_PCIE_MSI__HW_DBI_WR_EN__MASK                      0x02000000U
#define HOST_INTF_PCIE_MSI__HW_DBI_WR_EN__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x02000000U) >> 25)
#define HOST_INTF_PCIE_MSI__HW_DBI_WR_EN__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 25) & 0x02000000U)
#define HOST_INTF_PCIE_MSI__HW_DBI_WR_EN__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x02000000U) | (((u_int32_t)(src) <<\
                    25) & 0x02000000U)
#define HOST_INTF_PCIE_MSI__HW_DBI_WR_EN__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 25) & ~0x02000000U)))
#define HOST_INTF_PCIE_MSI__HW_DBI_WR_EN__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x02000000U) | ((u_int32_t)(1) << 25)
#define HOST_INTF_PCIE_MSI__HW_DBI_WR_EN__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x02000000U) | ((u_int32_t)(0) << 25)

/* macros for field IRQ_PENDING */
#define HOST_INTF_PCIE_MSI__IRQ_PENDING__SHIFT                               26
#define HOST_INTF_PCIE_MSI__IRQ_PENDING__WIDTH                                4
#define HOST_INTF_PCIE_MSI__IRQ_PENDING__MASK                       0x3c000000U
#define HOST_INTF_PCIE_MSI__IRQ_PENDING__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x3c000000U) >> 26)
#define HOST_INTF_PCIE_MSI__TYPE                                      u_int32_t
#define HOST_INTF_PCIE_MSI__READ                                    0x3fffffffU
#define HOST_INTF_PCIE_MSI__WRITE                                   0x3fffffffU

#endif /* __HOST_INTF_PCIE_MSI_MACRO__ */


/* macros for host_intf_reg_block.HOST_INTF_PCIE_MSI */
#define INST_HOST_INTF_REG_BLOCK__HOST_INTF_PCIE_MSI__NUM                     1

/* macros for BlueprintGlobalNameSpace::HOST_INTF_PCIE_PHY_LATENCY_NFTS_ADJ */
#ifndef __HOST_INTF_PCIE_PHY_LATENCY_NFTS_ADJ_MACRO__
#define __HOST_INTF_PCIE_PHY_LATENCY_NFTS_ADJ_MACRO__

/* macros for field DATA */
#define HOST_INTF_PCIE_PHY_LATENCY_NFTS_ADJ__DATA__SHIFT                      0
#define HOST_INTF_PCIE_PHY_LATENCY_NFTS_ADJ__DATA__WIDTH                     24
#define HOST_INTF_PCIE_PHY_LATENCY_NFTS_ADJ__DATA__MASK             0x00ffffffU
#define HOST_INTF_PCIE_PHY_LATENCY_NFTS_ADJ__DATA__READ(src) \
                    (u_int32_t)(src)\
                    & 0x00ffffffU
#define HOST_INTF_PCIE_PHY_LATENCY_NFTS_ADJ__DATA__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x00ffffffU)
#define HOST_INTF_PCIE_PHY_LATENCY_NFTS_ADJ__DATA__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00ffffffU) | ((u_int32_t)(src) &\
                    0x00ffffffU)
#define HOST_INTF_PCIE_PHY_LATENCY_NFTS_ADJ__DATA__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00ffffffU)))
#define HOST_INTF_PCIE_PHY_LATENCY_NFTS_ADJ__TYPE                     u_int32_t
#define HOST_INTF_PCIE_PHY_LATENCY_NFTS_ADJ__READ                   0x00ffffffU
#define HOST_INTF_PCIE_PHY_LATENCY_NFTS_ADJ__WRITE                  0x00ffffffU

#endif /* __HOST_INTF_PCIE_PHY_LATENCY_NFTS_ADJ_MACRO__ */


/* macros for host_intf_reg_block.HOST_INTF_PCIE_PHY_LATENCY_NFTS_ADJ */
#define INST_HOST_INTF_REG_BLOCK__HOST_INTF_PCIE_PHY_LATENCY_NFTS_ADJ__NUM    1

/* macros for BlueprintGlobalNameSpace::HOST_INTF_MAC_TDMA_CCA_CNTL */
#ifndef __HOST_INTF_MAC_TDMA_CCA_CNTL_MACRO__
#define __HOST_INTF_MAC_TDMA_CCA_CNTL_MACRO__

/* macros for field DATA */
#define HOST_INTF_MAC_TDMA_CCA_CNTL__DATA__SHIFT                              0
#define HOST_INTF_MAC_TDMA_CCA_CNTL__DATA__WIDTH                              2
#define HOST_INTF_MAC_TDMA_CCA_CNTL__DATA__MASK                     0x00000003U
#define HOST_INTF_MAC_TDMA_CCA_CNTL__DATA__READ(src) \
                    (u_int32_t)(src)\
                    & 0x00000003U
#define HOST_INTF_MAC_TDMA_CCA_CNTL__DATA__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x00000003U)
#define HOST_INTF_MAC_TDMA_CCA_CNTL__DATA__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000003U) | ((u_int32_t)(src) &\
                    0x00000003U)
#define HOST_INTF_MAC_TDMA_CCA_CNTL__DATA__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00000003U)))
#define HOST_INTF_MAC_TDMA_CCA_CNTL__TYPE                             u_int32_t
#define HOST_INTF_MAC_TDMA_CCA_CNTL__READ                           0x00000003U
#define HOST_INTF_MAC_TDMA_CCA_CNTL__WRITE                          0x00000003U

#endif /* __HOST_INTF_MAC_TDMA_CCA_CNTL_MACRO__ */


/* macros for host_intf_reg_block.HOST_INTF_MAC_TDMA_CCA_CNTL */
#define INST_HOST_INTF_REG_BLOCK__HOST_INTF_MAC_TDMA_CCA_CNTL__NUM            1

/* macros for BlueprintGlobalNameSpace::HOST_INTF_MAC_TXAPSYNC */
#ifndef __HOST_INTF_MAC_TXAPSYNC_MACRO__
#define __HOST_INTF_MAC_TXAPSYNC_MACRO__

/* macros for field ENABLE */
#define HOST_INTF_MAC_TXAPSYNC__ENABLE__SHIFT                                 0
#define HOST_INTF_MAC_TXAPSYNC__ENABLE__WIDTH                                 1
#define HOST_INTF_MAC_TXAPSYNC__ENABLE__MASK                        0x00000001U
#define HOST_INTF_MAC_TXAPSYNC__ENABLE__READ(src) \
                    (u_int32_t)(src)\
                    & 0x00000001U
#define HOST_INTF_MAC_TXAPSYNC__ENABLE__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x00000001U)
#define HOST_INTF_MAC_TXAPSYNC__ENABLE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | ((u_int32_t)(src) &\
                    0x00000001U)
#define HOST_INTF_MAC_TXAPSYNC__ENABLE__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00000001U)))
#define HOST_INTF_MAC_TXAPSYNC__ENABLE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(1)
#define HOST_INTF_MAC_TXAPSYNC__ENABLE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(0)
#define HOST_INTF_MAC_TXAPSYNC__TYPE                                  u_int32_t
#define HOST_INTF_MAC_TXAPSYNC__READ                                0x00000001U
#define HOST_INTF_MAC_TXAPSYNC__WRITE                               0x00000001U

#endif /* __HOST_INTF_MAC_TXAPSYNC_MACRO__ */


/* macros for host_intf_reg_block.HOST_INTF_MAC_TXAPSYNC */
#define INST_HOST_INTF_REG_BLOCK__HOST_INTF_MAC_TXAPSYNC__NUM                 1

/* macros for BlueprintGlobalNameSpace::HOST_INTF_MAC_TXSYNC_INITIAL_SYNC_TMR */
#ifndef __HOST_INTF_MAC_TXSYNC_INITIAL_SYNC_TMR_MACRO__
#define __HOST_INTF_MAC_TXSYNC_INITIAL_SYNC_TMR_MACRO__

/* macros for field DATA */
#define HOST_INTF_MAC_TXSYNC_INITIAL_SYNC_TMR__DATA__SHIFT                    0
#define HOST_INTF_MAC_TXSYNC_INITIAL_SYNC_TMR__DATA__WIDTH                   16
#define HOST_INTF_MAC_TXSYNC_INITIAL_SYNC_TMR__DATA__MASK           0x0000ffffU
#define HOST_INTF_MAC_TXSYNC_INITIAL_SYNC_TMR__DATA__READ(src) \
                    (u_int32_t)(src)\
                    & 0x0000ffffU
#define HOST_INTF_MAC_TXSYNC_INITIAL_SYNC_TMR__DATA__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x0000ffffU)
#define HOST_INTF_MAC_TXSYNC_INITIAL_SYNC_TMR__DATA__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000ffffU) | ((u_int32_t)(src) &\
                    0x0000ffffU)
#define HOST_INTF_MAC_TXSYNC_INITIAL_SYNC_TMR__DATA__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x0000ffffU)))
#define HOST_INTF_MAC_TXSYNC_INITIAL_SYNC_TMR__TYPE                   u_int32_t
#define HOST_INTF_MAC_TXSYNC_INITIAL_SYNC_TMR__READ                 0x0000ffffU
#define HOST_INTF_MAC_TXSYNC_INITIAL_SYNC_TMR__WRITE                0x0000ffffU

#endif /* __HOST_INTF_MAC_TXSYNC_INITIAL_SYNC_TMR_MACRO__ */


/* macros for host_intf_reg_block.HOST_INTF_MAC_TXSYNC_INITIAL_SYNC_TMR */
#define INST_HOST_INTF_REG_BLOCK__HOST_INTF_MAC_TXSYNC_INITIAL_SYNC_TMR__NUM  1

/* macros for BlueprintGlobalNameSpace::HOST_INTF_INTR_PRIORITY_SYNC_CAUSE */
#ifndef __HOST_INTF_INTR_PRIORITY_SYNC_CAUSE_MACRO__
#define __HOST_INTF_INTR_PRIORITY_SYNC_CAUSE_MACRO__

/* macros for field DATA */
#define HOST_INTF_INTR_PRIORITY_SYNC_CAUSE__DATA__SHIFT                       0
#define HOST_INTF_INTR_PRIORITY_SYNC_CAUSE__DATA__WIDTH                       3
#define HOST_INTF_INTR_PRIORITY_SYNC_CAUSE__DATA__MASK              0x00000007U
#define HOST_INTF_INTR_PRIORITY_SYNC_CAUSE__DATA__READ(src) \
                    (u_int32_t)(src)\
                    & 0x00000007U
#define HOST_INTF_INTR_PRIORITY_SYNC_CAUSE__DATA__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x00000007U)
#define HOST_INTF_INTR_PRIORITY_SYNC_CAUSE__DATA__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000007U) | ((u_int32_t)(src) &\
                    0x00000007U)
#define HOST_INTF_INTR_PRIORITY_SYNC_CAUSE__DATA__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00000007U)))
#define HOST_INTF_INTR_PRIORITY_SYNC_CAUSE__TYPE                      u_int32_t
#define HOST_INTF_INTR_PRIORITY_SYNC_CAUSE__READ                    0x00000007U
#define HOST_INTF_INTR_PRIORITY_SYNC_CAUSE__WRITE                   0x00000007U

#endif /* __HOST_INTF_INTR_PRIORITY_SYNC_CAUSE_MACRO__ */


/* macros for host_intf_reg_block.HOST_INTF_INTR_PRIORITY_SYNC_CAUSE */
#define INST_HOST_INTF_REG_BLOCK__HOST_INTF_INTR_PRIORITY_SYNC_CAUSE__NUM     1

/* macros for BlueprintGlobalNameSpace::HOST_INTF_INTR_PRIORITY_SYNC_ENABLE */
#ifndef __HOST_INTF_INTR_PRIORITY_SYNC_ENABLE_MACRO__
#define __HOST_INTF_INTR_PRIORITY_SYNC_ENABLE_MACRO__

/* macros for field DATA */
#define HOST_INTF_INTR_PRIORITY_SYNC_ENABLE__DATA__SHIFT                      0
#define HOST_INTF_INTR_PRIORITY_SYNC_ENABLE__DATA__WIDTH                      3
#define HOST_INTF_INTR_PRIORITY_SYNC_ENABLE__DATA__MASK             0x00000007U
#define HOST_INTF_INTR_PRIORITY_SYNC_ENABLE__DATA__READ(src) \
                    (u_int32_t)(src)\
                    & 0x00000007U
#define HOST_INTF_INTR_PRIORITY_SYNC_ENABLE__DATA__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x00000007U)
#define HOST_INTF_INTR_PRIORITY_SYNC_ENABLE__DATA__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000007U) | ((u_int32_t)(src) &\
                    0x00000007U)
#define HOST_INTF_INTR_PRIORITY_SYNC_ENABLE__DATA__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00000007U)))
#define HOST_INTF_INTR_PRIORITY_SYNC_ENABLE__TYPE                     u_int32_t
#define HOST_INTF_INTR_PRIORITY_SYNC_ENABLE__READ                   0x00000007U
#define HOST_INTF_INTR_PRIORITY_SYNC_ENABLE__WRITE                  0x00000007U

#endif /* __HOST_INTF_INTR_PRIORITY_SYNC_ENABLE_MACRO__ */


/* macros for host_intf_reg_block.HOST_INTF_INTR_PRIORITY_SYNC_ENABLE */
#define INST_HOST_INTF_REG_BLOCK__HOST_INTF_INTR_PRIORITY_SYNC_ENABLE__NUM    1

/* macros for BlueprintGlobalNameSpace::HOST_INTF_INTR_PRIORITY_ASYNC_MASK */
#ifndef __HOST_INTF_INTR_PRIORITY_ASYNC_MASK_MACRO__
#define __HOST_INTF_INTR_PRIORITY_ASYNC_MASK_MACRO__

/* macros for field DATA */
#define HOST_INTF_INTR_PRIORITY_ASYNC_MASK__DATA__SHIFT                       0
#define HOST_INTF_INTR_PRIORITY_ASYNC_MASK__DATA__WIDTH                       3
#define HOST_INTF_INTR_PRIORITY_ASYNC_MASK__DATA__MASK              0x00000007U
#define HOST_INTF_INTR_PRIORITY_ASYNC_MASK__DATA__READ(src) \
                    (u_int32_t)(src)\
                    & 0x00000007U
#define HOST_INTF_INTR_PRIORITY_ASYNC_MASK__DATA__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x00000007U)
#define HOST_INTF_INTR_PRIORITY_ASYNC_MASK__DATA__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000007U) | ((u_int32_t)(src) &\
                    0x00000007U)
#define HOST_INTF_INTR_PRIORITY_ASYNC_MASK__DATA__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00000007U)))
#define HOST_INTF_INTR_PRIORITY_ASYNC_MASK__TYPE                      u_int32_t
#define HOST_INTF_INTR_PRIORITY_ASYNC_MASK__READ                    0x00000007U
#define HOST_INTF_INTR_PRIORITY_ASYNC_MASK__WRITE                   0x00000007U

#endif /* __HOST_INTF_INTR_PRIORITY_ASYNC_MASK_MACRO__ */


/* macros for host_intf_reg_block.HOST_INTF_INTR_PRIORITY_ASYNC_MASK */
#define INST_HOST_INTF_REG_BLOCK__HOST_INTF_INTR_PRIORITY_ASYNC_MASK__NUM     1

/* macros for BlueprintGlobalNameSpace::HOST_INTF_INTR_PRIORITY_SYNC_MASK */
#ifndef __HOST_INTF_INTR_PRIORITY_SYNC_MASK_MACRO__
#define __HOST_INTF_INTR_PRIORITY_SYNC_MASK_MACRO__

/* macros for field DATA */
#define HOST_INTF_INTR_PRIORITY_SYNC_MASK__DATA__SHIFT                        0
#define HOST_INTF_INTR_PRIORITY_SYNC_MASK__DATA__WIDTH                        3
#define HOST_INTF_INTR_PRIORITY_SYNC_MASK__DATA__MASK               0x00000007U
#define HOST_INTF_INTR_PRIORITY_SYNC_MASK__DATA__READ(src) \
                    (u_int32_t)(src)\
                    & 0x00000007U
#define HOST_INTF_INTR_PRIORITY_SYNC_MASK__DATA__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x00000007U)
#define HOST_INTF_INTR_PRIORITY_SYNC_MASK__DATA__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000007U) | ((u_int32_t)(src) &\
                    0x00000007U)
#define HOST_INTF_INTR_PRIORITY_SYNC_MASK__DATA__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00000007U)))
#define HOST_INTF_INTR_PRIORITY_SYNC_MASK__TYPE                       u_int32_t
#define HOST_INTF_INTR_PRIORITY_SYNC_MASK__READ                     0x00000007U
#define HOST_INTF_INTR_PRIORITY_SYNC_MASK__WRITE                    0x00000007U

#endif /* __HOST_INTF_INTR_PRIORITY_SYNC_MASK_MACRO__ */


/* macros for host_intf_reg_block.HOST_INTF_INTR_PRIORITY_SYNC_MASK */
#define INST_HOST_INTF_REG_BLOCK__HOST_INTF_INTR_PRIORITY_SYNC_MASK__NUM      1

/* macros for BlueprintGlobalNameSpace::HOST_INTF_INTR_PRIORITY_ASYNC_CAUSE */
#ifndef __HOST_INTF_INTR_PRIORITY_ASYNC_CAUSE_MACRO__
#define __HOST_INTF_INTR_PRIORITY_ASYNC_CAUSE_MACRO__

/* macros for field DATA */
#define HOST_INTF_INTR_PRIORITY_ASYNC_CAUSE__DATA__SHIFT                      0
#define HOST_INTF_INTR_PRIORITY_ASYNC_CAUSE__DATA__WIDTH                      3
#define HOST_INTF_INTR_PRIORITY_ASYNC_CAUSE__DATA__MASK             0x00000007U
#define HOST_INTF_INTR_PRIORITY_ASYNC_CAUSE__DATA__READ(src) \
                    (u_int32_t)(src)\
                    & 0x00000007U
#define HOST_INTF_INTR_PRIORITY_ASYNC_CAUSE__TYPE                     u_int32_t
#define HOST_INTF_INTR_PRIORITY_ASYNC_CAUSE__READ                   0x00000007U

#endif /* __HOST_INTF_INTR_PRIORITY_ASYNC_CAUSE_MACRO__ */


/* macros for host_intf_reg_block.HOST_INTF_INTR_PRIORITY_ASYNC_CAUSE */
#define INST_HOST_INTF_REG_BLOCK__HOST_INTF_INTR_PRIORITY_ASYNC_CAUSE__NUM    1

/* macros for BlueprintGlobalNameSpace::HOST_INTF_INTR_PRIORITY_ASYNC_ENABLE */
#ifndef __HOST_INTF_INTR_PRIORITY_ASYNC_ENABLE_MACRO__
#define __HOST_INTF_INTR_PRIORITY_ASYNC_ENABLE_MACRO__

/* macros for field DATA */
#define HOST_INTF_INTR_PRIORITY_ASYNC_ENABLE__DATA__SHIFT                     0
#define HOST_INTF_INTR_PRIORITY_ASYNC_ENABLE__DATA__WIDTH                     3
#define HOST_INTF_INTR_PRIORITY_ASYNC_ENABLE__DATA__MASK            0x00000007U
#define HOST_INTF_INTR_PRIORITY_ASYNC_ENABLE__DATA__READ(src) \
                    (u_int32_t)(src)\
                    & 0x00000007U
#define HOST_INTF_INTR_PRIORITY_ASYNC_ENABLE__DATA__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x00000007U)
#define HOST_INTF_INTR_PRIORITY_ASYNC_ENABLE__DATA__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000007U) | ((u_int32_t)(src) &\
                    0x00000007U)
#define HOST_INTF_INTR_PRIORITY_ASYNC_ENABLE__DATA__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00000007U)))
#define HOST_INTF_INTR_PRIORITY_ASYNC_ENABLE__TYPE                    u_int32_t
#define HOST_INTF_INTR_PRIORITY_ASYNC_ENABLE__READ                  0x00000007U
#define HOST_INTF_INTR_PRIORITY_ASYNC_ENABLE__WRITE                 0x00000007U

#endif /* __HOST_INTF_INTR_PRIORITY_ASYNC_ENABLE_MACRO__ */


/* macros for host_intf_reg_block.HOST_INTF_INTR_PRIORITY_ASYNC_ENABLE */
#define INST_HOST_INTF_REG_BLOCK__HOST_INTF_INTR_PRIORITY_ASYNC_ENABLE__NUM   1

/* macros for BlueprintGlobalNameSpace::HOST_INTF_OTP */
#ifndef __HOST_INTF_OTP_MACRO__
#define __HOST_INTF_OTP_MACRO__

/* macros for field BOND_OPTION */
#define HOST_INTF_OTP__BOND_OPTION__SHIFT                                     0
#define HOST_INTF_OTP__BOND_OPTION__WIDTH                                    32
#define HOST_INTF_OTP__BOND_OPTION__MASK                            0xffffffffU
#define HOST_INTF_OTP__BOND_OPTION__READ(src)    (u_int32_t)(src) & 0xffffffffU
#define HOST_INTF_OTP__TYPE                                           u_int32_t
#define HOST_INTF_OTP__READ                                         0xffffffffU

#endif /* __HOST_INTF_OTP_MACRO__ */


/* macros for host_intf_reg_block.HOST_INTF_OTP */
#define INST_HOST_INTF_REG_BLOCK__HOST_INTF_OTP__NUM                          1

/* macros for BlueprintGlobalNameSpace::PCIE_CO_ERR_CTR0 */
#ifndef __PCIE_CO_ERR_CTR0_MACRO__
#define __PCIE_CO_ERR_CTR0_MACRO__

/* macros for field RCVD_ERR */
#define PCIE_CO_ERR_CTR0__RCVD_ERR__SHIFT                                     0
#define PCIE_CO_ERR_CTR0__RCVD_ERR__WIDTH                                     8
#define PCIE_CO_ERR_CTR0__RCVD_ERR__MASK                            0x000000ffU
#define PCIE_CO_ERR_CTR0__RCVD_ERR__READ(src)    (u_int32_t)(src) & 0x000000ffU
#define PCIE_CO_ERR_CTR0__RCVD_ERR__WRITE(src) ((u_int32_t)(src) & 0x000000ffU)
#define PCIE_CO_ERR_CTR0__RCVD_ERR__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000000ffU) | ((u_int32_t)(src) &\
                    0x000000ffU)
#define PCIE_CO_ERR_CTR0__RCVD_ERR__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x000000ffU)))

/* macros for field BAD_TLP_ERR */
#define PCIE_CO_ERR_CTR0__BAD_TLP_ERR__SHIFT                                  8
#define PCIE_CO_ERR_CTR0__BAD_TLP_ERR__WIDTH                                  8
#define PCIE_CO_ERR_CTR0__BAD_TLP_ERR__MASK                         0x0000ff00U
#define PCIE_CO_ERR_CTR0__BAD_TLP_ERR__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0000ff00U) >> 8)
#define PCIE_CO_ERR_CTR0__BAD_TLP_ERR__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 8) & 0x0000ff00U)
#define PCIE_CO_ERR_CTR0__BAD_TLP_ERR__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000ff00U) | (((u_int32_t)(src) <<\
                    8) & 0x0000ff00U)
#define PCIE_CO_ERR_CTR0__BAD_TLP_ERR__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 8) & ~0x0000ff00U)))

/* macros for field BAD_DLLP_ERR */
#define PCIE_CO_ERR_CTR0__BAD_DLLP_ERR__SHIFT                                16
#define PCIE_CO_ERR_CTR0__BAD_DLLP_ERR__WIDTH                                 8
#define PCIE_CO_ERR_CTR0__BAD_DLLP_ERR__MASK                        0x00ff0000U
#define PCIE_CO_ERR_CTR0__BAD_DLLP_ERR__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00ff0000U) >> 16)
#define PCIE_CO_ERR_CTR0__BAD_DLLP_ERR__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 16) & 0x00ff0000U)
#define PCIE_CO_ERR_CTR0__BAD_DLLP_ERR__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00ff0000U) | (((u_int32_t)(src) <<\
                    16) & 0x00ff0000U)
#define PCIE_CO_ERR_CTR0__BAD_DLLP_ERR__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 16) & ~0x00ff0000U)))
#define PCIE_CO_ERR_CTR0__TYPE                                        u_int32_t
#define PCIE_CO_ERR_CTR0__READ                                      0x00ffffffU
#define PCIE_CO_ERR_CTR0__WRITE                                     0x00ffffffU

#endif /* __PCIE_CO_ERR_CTR0_MACRO__ */


/* macros for host_intf_reg_block.PCIE_CO_ERR_CTR0 */
#define INST_HOST_INTF_REG_BLOCK__PCIE_CO_ERR_CTR0__NUM                       1

/* macros for BlueprintGlobalNameSpace::PCIE_CO_ERR_CTR1 */
#ifndef __PCIE_CO_ERR_CTR1_MACRO__
#define __PCIE_CO_ERR_CTR1_MACRO__

/* macros for field RPLY_TO_ERR */
#define PCIE_CO_ERR_CTR1__RPLY_TO_ERR__SHIFT                                  0
#define PCIE_CO_ERR_CTR1__RPLY_TO_ERR__WIDTH                                  8
#define PCIE_CO_ERR_CTR1__RPLY_TO_ERR__MASK                         0x000000ffU
#define PCIE_CO_ERR_CTR1__RPLY_TO_ERR__READ(src) (u_int32_t)(src) & 0x000000ffU
#define PCIE_CO_ERR_CTR1__RPLY_TO_ERR__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x000000ffU)
#define PCIE_CO_ERR_CTR1__RPLY_TO_ERR__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000000ffU) | ((u_int32_t)(src) &\
                    0x000000ffU)
#define PCIE_CO_ERR_CTR1__RPLY_TO_ERR__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x000000ffU)))

/* macros for field RPLY_NUM_RO_ERR */
#define PCIE_CO_ERR_CTR1__RPLY_NUM_RO_ERR__SHIFT                              8
#define PCIE_CO_ERR_CTR1__RPLY_NUM_RO_ERR__WIDTH                              8
#define PCIE_CO_ERR_CTR1__RPLY_NUM_RO_ERR__MASK                     0x0000ff00U
#define PCIE_CO_ERR_CTR1__RPLY_NUM_RO_ERR__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0000ff00U) >> 8)
#define PCIE_CO_ERR_CTR1__RPLY_NUM_RO_ERR__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 8) & 0x0000ff00U)
#define PCIE_CO_ERR_CTR1__RPLY_NUM_RO_ERR__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000ff00U) | (((u_int32_t)(src) <<\
                    8) & 0x0000ff00U)
#define PCIE_CO_ERR_CTR1__RPLY_NUM_RO_ERR__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 8) & ~0x0000ff00U)))
#define PCIE_CO_ERR_CTR1__TYPE                                        u_int32_t
#define PCIE_CO_ERR_CTR1__READ                                      0x0000ffffU
#define PCIE_CO_ERR_CTR1__WRITE                                     0x0000ffffU

#endif /* __PCIE_CO_ERR_CTR1_MACRO__ */


/* macros for host_intf_reg_block.PCIE_CO_ERR_CTR1 */
#define INST_HOST_INTF_REG_BLOCK__PCIE_CO_ERR_CTR1__NUM                       1

/* macros for BlueprintGlobalNameSpace::PCIE_CO_ERR_CTR_CTRL */
#ifndef __PCIE_CO_ERR_CTR_CTRL_MACRO__
#define __PCIE_CO_ERR_CTR_CTRL_MACRO__

/* macros for field RCVD_ERR_CTR_RUN */
#define PCIE_CO_ERR_CTR_CTRL__RCVD_ERR_CTR_RUN__SHIFT                         0
#define PCIE_CO_ERR_CTR_CTRL__RCVD_ERR_CTR_RUN__WIDTH                         1
#define PCIE_CO_ERR_CTR_CTRL__RCVD_ERR_CTR_RUN__MASK                0x00000001U
#define PCIE_CO_ERR_CTR_CTRL__RCVD_ERR_CTR_RUN__READ(src) \
                    (u_int32_t)(src)\
                    & 0x00000001U
#define PCIE_CO_ERR_CTR_CTRL__RCVD_ERR_CTR_RUN__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x00000001U)
#define PCIE_CO_ERR_CTR_CTRL__RCVD_ERR_CTR_RUN__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | ((u_int32_t)(src) &\
                    0x00000001U)
#define PCIE_CO_ERR_CTR_CTRL__RCVD_ERR_CTR_RUN__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00000001U)))
#define PCIE_CO_ERR_CTR_CTRL__RCVD_ERR_CTR_RUN__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(1)
#define PCIE_CO_ERR_CTR_CTRL__RCVD_ERR_CTR_RUN__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(0)

/* macros for field RCVD_ERR_CTR_AUTO_STOP */
#define PCIE_CO_ERR_CTR_CTRL__RCVD_ERR_CTR_AUTO_STOP__SHIFT                   1
#define PCIE_CO_ERR_CTR_CTRL__RCVD_ERR_CTR_AUTO_STOP__WIDTH                   1
#define PCIE_CO_ERR_CTR_CTRL__RCVD_ERR_CTR_AUTO_STOP__MASK          0x00000002U
#define PCIE_CO_ERR_CTR_CTRL__RCVD_ERR_CTR_AUTO_STOP__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000002U) >> 1)
#define PCIE_CO_ERR_CTR_CTRL__RCVD_ERR_CTR_AUTO_STOP__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 1) & 0x00000002U)
#define PCIE_CO_ERR_CTR_CTRL__RCVD_ERR_CTR_AUTO_STOP__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | (((u_int32_t)(src) <<\
                    1) & 0x00000002U)
#define PCIE_CO_ERR_CTR_CTRL__RCVD_ERR_CTR_AUTO_STOP__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 1) & ~0x00000002U)))
#define PCIE_CO_ERR_CTR_CTRL__RCVD_ERR_CTR_AUTO_STOP__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | ((u_int32_t)(1) << 1)
#define PCIE_CO_ERR_CTR_CTRL__RCVD_ERR_CTR_AUTO_STOP__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | ((u_int32_t)(0) << 1)

/* macros for field BAD_TLP_ERR_CTR_RUN */
#define PCIE_CO_ERR_CTR_CTRL__BAD_TLP_ERR_CTR_RUN__SHIFT                      2
#define PCIE_CO_ERR_CTR_CTRL__BAD_TLP_ERR_CTR_RUN__WIDTH                      1
#define PCIE_CO_ERR_CTR_CTRL__BAD_TLP_ERR_CTR_RUN__MASK             0x00000004U
#define PCIE_CO_ERR_CTR_CTRL__BAD_TLP_ERR_CTR_RUN__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000004U) >> 2)
#define PCIE_CO_ERR_CTR_CTRL__BAD_TLP_ERR_CTR_RUN__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 2) & 0x00000004U)
#define PCIE_CO_ERR_CTR_CTRL__BAD_TLP_ERR_CTR_RUN__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000004U) | (((u_int32_t)(src) <<\
                    2) & 0x00000004U)
#define PCIE_CO_ERR_CTR_CTRL__BAD_TLP_ERR_CTR_RUN__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 2) & ~0x00000004U)))
#define PCIE_CO_ERR_CTR_CTRL__BAD_TLP_ERR_CTR_RUN__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000004U) | ((u_int32_t)(1) << 2)
#define PCIE_CO_ERR_CTR_CTRL__BAD_TLP_ERR_CTR_RUN__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000004U) | ((u_int32_t)(0) << 2)

/* macros for field BAD_TLP_ERR_CTR_AUTO_STOP */
#define PCIE_CO_ERR_CTR_CTRL__BAD_TLP_ERR_CTR_AUTO_STOP__SHIFT                3
#define PCIE_CO_ERR_CTR_CTRL__BAD_TLP_ERR_CTR_AUTO_STOP__WIDTH                1
#define PCIE_CO_ERR_CTR_CTRL__BAD_TLP_ERR_CTR_AUTO_STOP__MASK       0x00000008U
#define PCIE_CO_ERR_CTR_CTRL__BAD_TLP_ERR_CTR_AUTO_STOP__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000008U) >> 3)
#define PCIE_CO_ERR_CTR_CTRL__BAD_TLP_ERR_CTR_AUTO_STOP__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 3) & 0x00000008U)
#define PCIE_CO_ERR_CTR_CTRL__BAD_TLP_ERR_CTR_AUTO_STOP__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000008U) | (((u_int32_t)(src) <<\
                    3) & 0x00000008U)
#define PCIE_CO_ERR_CTR_CTRL__BAD_TLP_ERR_CTR_AUTO_STOP__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 3) & ~0x00000008U)))
#define PCIE_CO_ERR_CTR_CTRL__BAD_TLP_ERR_CTR_AUTO_STOP__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000008U) | ((u_int32_t)(1) << 3)
#define PCIE_CO_ERR_CTR_CTRL__BAD_TLP_ERR_CTR_AUTO_STOP__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000008U) | ((u_int32_t)(0) << 3)

/* macros for field BAD_DLLP_ERR_CTR_RUN */
#define PCIE_CO_ERR_CTR_CTRL__BAD_DLLP_ERR_CTR_RUN__SHIFT                     4
#define PCIE_CO_ERR_CTR_CTRL__BAD_DLLP_ERR_CTR_RUN__WIDTH                     1
#define PCIE_CO_ERR_CTR_CTRL__BAD_DLLP_ERR_CTR_RUN__MASK            0x00000010U
#define PCIE_CO_ERR_CTR_CTRL__BAD_DLLP_ERR_CTR_RUN__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000010U) >> 4)
#define PCIE_CO_ERR_CTR_CTRL__BAD_DLLP_ERR_CTR_RUN__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 4) & 0x00000010U)
#define PCIE_CO_ERR_CTR_CTRL__BAD_DLLP_ERR_CTR_RUN__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000010U) | (((u_int32_t)(src) <<\
                    4) & 0x00000010U)
#define PCIE_CO_ERR_CTR_CTRL__BAD_DLLP_ERR_CTR_RUN__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 4) & ~0x00000010U)))
#define PCIE_CO_ERR_CTR_CTRL__BAD_DLLP_ERR_CTR_RUN__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000010U) | ((u_int32_t)(1) << 4)
#define PCIE_CO_ERR_CTR_CTRL__BAD_DLLP_ERR_CTR_RUN__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000010U) | ((u_int32_t)(0) << 4)

/* macros for field BAD_DLLP_ERR_CTR_AUTO_STOP */
#define PCIE_CO_ERR_CTR_CTRL__BAD_DLLP_ERR_CTR_AUTO_STOP__SHIFT               5
#define PCIE_CO_ERR_CTR_CTRL__BAD_DLLP_ERR_CTR_AUTO_STOP__WIDTH               1
#define PCIE_CO_ERR_CTR_CTRL__BAD_DLLP_ERR_CTR_AUTO_STOP__MASK      0x00000020U
#define PCIE_CO_ERR_CTR_CTRL__BAD_DLLP_ERR_CTR_AUTO_STOP__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000020U) >> 5)
#define PCIE_CO_ERR_CTR_CTRL__BAD_DLLP_ERR_CTR_AUTO_STOP__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 5) & 0x00000020U)
#define PCIE_CO_ERR_CTR_CTRL__BAD_DLLP_ERR_CTR_AUTO_STOP__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000020U) | (((u_int32_t)(src) <<\
                    5) & 0x00000020U)
#define PCIE_CO_ERR_CTR_CTRL__BAD_DLLP_ERR_CTR_AUTO_STOP__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 5) & ~0x00000020U)))
#define PCIE_CO_ERR_CTR_CTRL__BAD_DLLP_ERR_CTR_AUTO_STOP__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000020U) | ((u_int32_t)(1) << 5)
#define PCIE_CO_ERR_CTR_CTRL__BAD_DLLP_ERR_CTR_AUTO_STOP__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000020U) | ((u_int32_t)(0) << 5)

/* macros for field RPLY_TO_ERR_CTR_RUN */
#define PCIE_CO_ERR_CTR_CTRL__RPLY_TO_ERR_CTR_RUN__SHIFT                      6
#define PCIE_CO_ERR_CTR_CTRL__RPLY_TO_ERR_CTR_RUN__WIDTH                      1
#define PCIE_CO_ERR_CTR_CTRL__RPLY_TO_ERR_CTR_RUN__MASK             0x00000040U
#define PCIE_CO_ERR_CTR_CTRL__RPLY_TO_ERR_CTR_RUN__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000040U) >> 6)
#define PCIE_CO_ERR_CTR_CTRL__RPLY_TO_ERR_CTR_RUN__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 6) & 0x00000040U)
#define PCIE_CO_ERR_CTR_CTRL__RPLY_TO_ERR_CTR_RUN__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000040U) | (((u_int32_t)(src) <<\
                    6) & 0x00000040U)
#define PCIE_CO_ERR_CTR_CTRL__RPLY_TO_ERR_CTR_RUN__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 6) & ~0x00000040U)))
#define PCIE_CO_ERR_CTR_CTRL__RPLY_TO_ERR_CTR_RUN__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000040U) | ((u_int32_t)(1) << 6)
#define PCIE_CO_ERR_CTR_CTRL__RPLY_TO_ERR_CTR_RUN__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000040U) | ((u_int32_t)(0) << 6)

/* macros for field RPLY_TO_ERR_CTR_AUTO_STOP */
#define PCIE_CO_ERR_CTR_CTRL__RPLY_TO_ERR_CTR_AUTO_STOP__SHIFT                7
#define PCIE_CO_ERR_CTR_CTRL__RPLY_TO_ERR_CTR_AUTO_STOP__WIDTH                1
#define PCIE_CO_ERR_CTR_CTRL__RPLY_TO_ERR_CTR_AUTO_STOP__MASK       0x00000080U
#define PCIE_CO_ERR_CTR_CTRL__RPLY_TO_ERR_CTR_AUTO_STOP__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000080U) >> 7)
#define PCIE_CO_ERR_CTR_CTRL__RPLY_TO_ERR_CTR_AUTO_STOP__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 7) & 0x00000080U)
#define PCIE_CO_ERR_CTR_CTRL__RPLY_TO_ERR_CTR_AUTO_STOP__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000080U) | (((u_int32_t)(src) <<\
                    7) & 0x00000080U)
#define PCIE_CO_ERR_CTR_CTRL__RPLY_TO_ERR_CTR_AUTO_STOP__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 7) & ~0x00000080U)))
#define PCIE_CO_ERR_CTR_CTRL__RPLY_TO_ERR_CTR_AUTO_STOP__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000080U) | ((u_int32_t)(1) << 7)
#define PCIE_CO_ERR_CTR_CTRL__RPLY_TO_ERR_CTR_AUTO_STOP__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000080U) | ((u_int32_t)(0) << 7)

/* macros for field RPLY_NUM_RO_ERR_CTR_RUN */
#define PCIE_CO_ERR_CTR_CTRL__RPLY_NUM_RO_ERR_CTR_RUN__SHIFT                  8
#define PCIE_CO_ERR_CTR_CTRL__RPLY_NUM_RO_ERR_CTR_RUN__WIDTH                  1
#define PCIE_CO_ERR_CTR_CTRL__RPLY_NUM_RO_ERR_CTR_RUN__MASK         0x00000100U
#define PCIE_CO_ERR_CTR_CTRL__RPLY_NUM_RO_ERR_CTR_RUN__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000100U) >> 8)
#define PCIE_CO_ERR_CTR_CTRL__RPLY_NUM_RO_ERR_CTR_RUN__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 8) & 0x00000100U)
#define PCIE_CO_ERR_CTR_CTRL__RPLY_NUM_RO_ERR_CTR_RUN__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000100U) | (((u_int32_t)(src) <<\
                    8) & 0x00000100U)
#define PCIE_CO_ERR_CTR_CTRL__RPLY_NUM_RO_ERR_CTR_RUN__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 8) & ~0x00000100U)))
#define PCIE_CO_ERR_CTR_CTRL__RPLY_NUM_RO_ERR_CTR_RUN__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000100U) | ((u_int32_t)(1) << 8)
#define PCIE_CO_ERR_CTR_CTRL__RPLY_NUM_RO_ERR_CTR_RUN__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000100U) | ((u_int32_t)(0) << 8)

/* macros for field RPLY_NUM_RO_ERR_CTR_AUTO_STOP */
#define PCIE_CO_ERR_CTR_CTRL__RPLY_NUM_RO_ERR_CTR_AUTO_STOP__SHIFT            9
#define PCIE_CO_ERR_CTR_CTRL__RPLY_NUM_RO_ERR_CTR_AUTO_STOP__WIDTH            1
#define PCIE_CO_ERR_CTR_CTRL__RPLY_NUM_RO_ERR_CTR_AUTO_STOP__MASK   0x00000200U
#define PCIE_CO_ERR_CTR_CTRL__RPLY_NUM_RO_ERR_CTR_AUTO_STOP__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000200U) >> 9)
#define PCIE_CO_ERR_CTR_CTRL__RPLY_NUM_RO_ERR_CTR_AUTO_STOP__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 9) & 0x00000200U)
#define PCIE_CO_ERR_CTR_CTRL__RPLY_NUM_RO_ERR_CTR_AUTO_STOP__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000200U) | (((u_int32_t)(src) <<\
                    9) & 0x00000200U)
#define PCIE_CO_ERR_CTR_CTRL__RPLY_NUM_RO_ERR_CTR_AUTO_STOP__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 9) & ~0x00000200U)))
#define PCIE_CO_ERR_CTR_CTRL__RPLY_NUM_RO_ERR_CTR_AUTO_STOP__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000200U) | ((u_int32_t)(1) << 9)
#define PCIE_CO_ERR_CTR_CTRL__RPLY_NUM_RO_ERR_CTR_AUTO_STOP__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000200U) | ((u_int32_t)(0) << 9)
#define PCIE_CO_ERR_CTR_CTRL__TYPE                                    u_int32_t
#define PCIE_CO_ERR_CTR_CTRL__READ                                  0x000003ffU
#define PCIE_CO_ERR_CTR_CTRL__WRITE                                 0x000003ffU

#endif /* __PCIE_CO_ERR_CTR_CTRL_MACRO__ */


/* macros for host_intf_reg_block.PCIE_CO_ERR_CTR_CTRL */
#define INST_HOST_INTF_REG_BLOCK__PCIE_CO_ERR_CTR_CTRL__NUM                   1

/* macros for BlueprintGlobalNameSpace::FPGA_PHY_LAYER_REVID */
#ifndef __FPGA_PHY_LAYER_REVID_MACRO__
#define __FPGA_PHY_LAYER_REVID_MACRO__

/* macros for field FPGA_RADIO_FEATURE_INDEX */
#define FPGA_PHY_LAYER_REVID__FPGA_RADIO_FEATURE_INDEX__SHIFT                 0
#define FPGA_PHY_LAYER_REVID__FPGA_RADIO_FEATURE_INDEX__WIDTH                16
#define FPGA_PHY_LAYER_REVID__FPGA_RADIO_FEATURE_INDEX__MASK        0x0000ffffU
#define FPGA_PHY_LAYER_REVID__FPGA_RADIO_FEATURE_INDEX__READ(src) \
                    (u_int32_t)(src)\
                    & 0x0000ffffU

/* macros for field FPGA_BASEBAND_FEATURE_INDEX */
#define FPGA_PHY_LAYER_REVID__FPGA_BASEBAND_FEATURE_INDEX__SHIFT             16
#define FPGA_PHY_LAYER_REVID__FPGA_BASEBAND_FEATURE_INDEX__WIDTH             16
#define FPGA_PHY_LAYER_REVID__FPGA_BASEBAND_FEATURE_INDEX__MASK     0xffff0000U
#define FPGA_PHY_LAYER_REVID__FPGA_BASEBAND_FEATURE_INDEX__READ(src) \
                    (((u_int32_t)(src)\
                    & 0xffff0000U) >> 16)
#define FPGA_PHY_LAYER_REVID__TYPE                                    u_int32_t
#define FPGA_PHY_LAYER_REVID__READ                                  0xffffffffU

#endif /* __FPGA_PHY_LAYER_REVID_MACRO__ */


/* macros for emulation_misc_reg_block.FPGA_PHY_LAYER_REVID */
#define INST_EMULATION_MISC_REG_BLOCK__FPGA_PHY_LAYER_REVID__NUM              1

/* macros for BlueprintGlobalNameSpace::FPGA_LINK_LAYER_REVID */
#ifndef __FPGA_LINK_LAYER_REVID_MACRO__
#define __FPGA_LINK_LAYER_REVID_MACRO__

/* macros for field FPGA_MAC_FEATURE_INDEX */
#define FPGA_LINK_LAYER_REVID__FPGA_MAC_FEATURE_INDEX__SHIFT                  0
#define FPGA_LINK_LAYER_REVID__FPGA_MAC_FEATURE_INDEX__WIDTH                 16
#define FPGA_LINK_LAYER_REVID__FPGA_MAC_FEATURE_INDEX__MASK         0x0000ffffU
#define FPGA_LINK_LAYER_REVID__FPGA_MAC_FEATURE_INDEX__READ(src) \
                    (u_int32_t)(src)\
                    & 0x0000ffffU

/* macros for field FPGA_SOC_FEATURE_INDEX */
#define FPGA_LINK_LAYER_REVID__FPGA_SOC_FEATURE_INDEX__SHIFT                 16
#define FPGA_LINK_LAYER_REVID__FPGA_SOC_FEATURE_INDEX__WIDTH                 16
#define FPGA_LINK_LAYER_REVID__FPGA_SOC_FEATURE_INDEX__MASK         0xffff0000U
#define FPGA_LINK_LAYER_REVID__FPGA_SOC_FEATURE_INDEX__READ(src) \
                    (((u_int32_t)(src)\
                    & 0xffff0000U) >> 16)
#define FPGA_LINK_LAYER_REVID__TYPE                                   u_int32_t
#define FPGA_LINK_LAYER_REVID__READ                                 0xffffffffU

#endif /* __FPGA_LINK_LAYER_REVID_MACRO__ */


/* macros for emulation_misc_reg_block.FPGA_LINK_LAYER_REVID */
#define INST_EMULATION_MISC_REG_BLOCK__FPGA_LINK_LAYER_REVID__NUM             1

/* macros for BlueprintGlobalNameSpace::FPGA_REG1 */
#ifndef __FPGA_REG1_MACRO__
#define __FPGA_REG1_MACRO__

/* macros for field spare_reg1_bit0 */
#define FPGA_REG1__SPARE_REG1_BIT0__SHIFT                                     0
#define FPGA_REG1__SPARE_REG1_BIT0__WIDTH                                     1
#define FPGA_REG1__SPARE_REG1_BIT0__MASK                            0x00000001U
#define FPGA_REG1__SPARE_REG1_BIT0__READ(src)    (u_int32_t)(src) & 0x00000001U
#define FPGA_REG1__SPARE_REG1_BIT0__WRITE(src) ((u_int32_t)(src) & 0x00000001U)
#define FPGA_REG1__SPARE_REG1_BIT0__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | ((u_int32_t)(src) &\
                    0x00000001U)
#define FPGA_REG1__SPARE_REG1_BIT0__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00000001U)))
#define FPGA_REG1__SPARE_REG1_BIT0__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(1)
#define FPGA_REG1__SPARE_REG1_BIT0__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(0)

/* macros for field mask_rx_rf */
#define FPGA_REG1__MASK_RX_RF__SHIFT                                          1
#define FPGA_REG1__MASK_RX_RF__WIDTH                                          1
#define FPGA_REG1__MASK_RX_RF__MASK                                 0x00000002U
#define FPGA_REG1__MASK_RX_RF__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000002U) >> 1)
#define FPGA_REG1__MASK_RX_RF__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 1) & 0x00000002U)
#define FPGA_REG1__MASK_RX_RF__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | (((u_int32_t)(src) <<\
                    1) & 0x00000002U)
#define FPGA_REG1__MASK_RX_RF__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 1) & ~0x00000002U)))
#define FPGA_REG1__MASK_RX_RF__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | ((u_int32_t)(1) << 1)
#define FPGA_REG1__MASK_RX_RF__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | ((u_int32_t)(0) << 1)

/* macros for field dcm_release */
#define FPGA_REG1__DCM_RELEASE__SHIFT                                         2
#define FPGA_REG1__DCM_RELEASE__WIDTH                                         1
#define FPGA_REG1__DCM_RELEASE__MASK                                0x00000004U
#define FPGA_REG1__DCM_RELEASE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000004U) >> 2)
#define FPGA_REG1__DCM_RELEASE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000004U) | ((u_int32_t)(1) << 2)
#define FPGA_REG1__DCM_RELEASE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000004U) | ((u_int32_t)(0) << 2)

/* macros for field SPARE0 */
#define FPGA_REG1__SPARE0__SHIFT                                              3
#define FPGA_REG1__SPARE0__WIDTH                                              1
#define FPGA_REG1__SPARE0__MASK                                     0x00000008U
#define FPGA_REG1__SPARE0__READ(src)    (((u_int32_t)(src) & 0x00000008U) >> 3)
#define FPGA_REG1__SPARE0__WRITE(src)   (((u_int32_t)(src) << 3) & 0x00000008U)
#define FPGA_REG1__SPARE0__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000008U) | (((u_int32_t)(src) <<\
                    3) & 0x00000008U)
#define FPGA_REG1__SPARE0__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 3) & ~0x00000008U)))
#define FPGA_REG1__SPARE0__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000008U) | ((u_int32_t)(1) << 3)
#define FPGA_REG1__SPARE0__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000008U) | ((u_int32_t)(0) << 3)

/* macros for field emulation_clock_ratio */
#define FPGA_REG1__EMULATION_CLOCK_RATIO__SHIFT                               4
#define FPGA_REG1__EMULATION_CLOCK_RATIO__WIDTH                               4
#define FPGA_REG1__EMULATION_CLOCK_RATIO__MASK                      0x000000f0U
#define FPGA_REG1__EMULATION_CLOCK_RATIO__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x000000f0U) >> 4)
#define FPGA_REG1__EMULATION_CLOCK_RATIO__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 4) & 0x000000f0U)
#define FPGA_REG1__EMULATION_CLOCK_RATIO__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000000f0U) | (((u_int32_t)(src) <<\
                    4) & 0x000000f0U)
#define FPGA_REG1__EMULATION_CLOCK_RATIO__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 4) & ~0x000000f0U)))

/* macros for field long_shift_chain_override_index */
#define FPGA_REG1__LONG_SHIFT_CHAIN_OVERRIDE_INDEX__SHIFT                     8
#define FPGA_REG1__LONG_SHIFT_CHAIN_OVERRIDE_INDEX__WIDTH                     2
#define FPGA_REG1__LONG_SHIFT_CHAIN_OVERRIDE_INDEX__MASK            0x00000300U
#define FPGA_REG1__LONG_SHIFT_CHAIN_OVERRIDE_INDEX__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000300U) >> 8)
#define FPGA_REG1__LONG_SHIFT_CHAIN_OVERRIDE_INDEX__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 8) & 0x00000300U)
#define FPGA_REG1__LONG_SHIFT_CHAIN_OVERRIDE_INDEX__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000300U) | (((u_int32_t)(src) <<\
                    8) & 0x00000300U)
#define FPGA_REG1__LONG_SHIFT_CHAIN_OVERRIDE_INDEX__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 8) & ~0x00000300U)))

/* macros for field enable_long_shift_chain_override_index */
#define FPGA_REG1__ENABLE_LONG_SHIFT_CHAIN_OVERRIDE_INDEX__SHIFT             10
#define FPGA_REG1__ENABLE_LONG_SHIFT_CHAIN_OVERRIDE_INDEX__WIDTH              1
#define FPGA_REG1__ENABLE_LONG_SHIFT_CHAIN_OVERRIDE_INDEX__MASK     0x00000400U
#define FPGA_REG1__ENABLE_LONG_SHIFT_CHAIN_OVERRIDE_INDEX__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000400U) >> 10)
#define FPGA_REG1__ENABLE_LONG_SHIFT_CHAIN_OVERRIDE_INDEX__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 10) & 0x00000400U)
#define FPGA_REG1__ENABLE_LONG_SHIFT_CHAIN_OVERRIDE_INDEX__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000400U) | (((u_int32_t)(src) <<\
                    10) & 0x00000400U)
#define FPGA_REG1__ENABLE_LONG_SHIFT_CHAIN_OVERRIDE_INDEX__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 10) & ~0x00000400U)))
#define FPGA_REG1__ENABLE_LONG_SHIFT_CHAIN_OVERRIDE_INDEX__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000400U) | ((u_int32_t)(1) << 10)
#define FPGA_REG1__ENABLE_LONG_SHIFT_CHAIN_OVERRIDE_INDEX__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000400U) | ((u_int32_t)(0) << 10)

/* macros for field SPARE1 */
#define FPGA_REG1__SPARE1__SHIFT                                             11
#define FPGA_REG1__SPARE1__WIDTH                                             21
#define FPGA_REG1__SPARE1__MASK                                     0xfffff800U
#define FPGA_REG1__SPARE1__READ(src)   (((u_int32_t)(src) & 0xfffff800U) >> 11)
#define FPGA_REG1__SPARE1__WRITE(src)  (((u_int32_t)(src) << 11) & 0xfffff800U)
#define FPGA_REG1__SPARE1__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xfffff800U) | (((u_int32_t)(src) <<\
                    11) & 0xfffff800U)
#define FPGA_REG1__SPARE1__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 11) & ~0xfffff800U)))
#define FPGA_REG1__TYPE                                               u_int32_t
#define FPGA_REG1__READ                                             0xffffffffU
#define FPGA_REG1__WRITE                                            0xffffffffU

#endif /* __FPGA_REG1_MACRO__ */


/* macros for emulation_misc_reg_block.FPGA_REG1 */
#define INST_EMULATION_MISC_REG_BLOCK__FPGA_REG1__NUM                         1

/* macros for BlueprintGlobalNameSpace::FPGA_REG2 */
#ifndef __FPGA_REG2_MACRO__
#define __FPGA_REG2_MACRO__

/* macros for field RxPipeIFerrInjEn */
#define FPGA_REG2__RXPIPEIFERRINJEN__SHIFT                                    0
#define FPGA_REG2__RXPIPEIFERRINJEN__WIDTH                                    1
#define FPGA_REG2__RXPIPEIFERRINJEN__MASK                           0x00000001U
#define FPGA_REG2__RXPIPEIFERRINJEN__READ(src)   (u_int32_t)(src) & 0x00000001U
#define FPGA_REG2__RXPIPEIFERRINJEN__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x00000001U)
#define FPGA_REG2__RXPIPEIFERRINJEN__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | ((u_int32_t)(src) &\
                    0x00000001U)
#define FPGA_REG2__RXPIPEIFERRINJEN__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00000001U)))
#define FPGA_REG2__RXPIPEIFERRINJEN__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(1)
#define FPGA_REG2__RXPIPEIFERRINJEN__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(0)

/* macros for field TxPipeIFerrInjEn */
#define FPGA_REG2__TXPIPEIFERRINJEN__SHIFT                                    1
#define FPGA_REG2__TXPIPEIFERRINJEN__WIDTH                                    1
#define FPGA_REG2__TXPIPEIFERRINJEN__MASK                           0x00000002U
#define FPGA_REG2__TXPIPEIFERRINJEN__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000002U) >> 1)
#define FPGA_REG2__TXPIPEIFERRINJEN__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 1) & 0x00000002U)
#define FPGA_REG2__TXPIPEIFERRINJEN__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | (((u_int32_t)(src) <<\
                    1) & 0x00000002U)
#define FPGA_REG2__TXPIPEIFERRINJEN__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 1) & ~0x00000002U)))
#define FPGA_REG2__TXPIPEIFERRINJEN__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | ((u_int32_t)(1) << 1)
#define FPGA_REG2__TXPIPEIFERRINJEN__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | ((u_int32_t)(0) << 1)

/* macros for field RxPipeIFInjErrInDataK */
#define FPGA_REG2__RXPIPEIFINJERRINDATAK__SHIFT                               2
#define FPGA_REG2__RXPIPEIFINJERRINDATAK__WIDTH                               1
#define FPGA_REG2__RXPIPEIFINJERRINDATAK__MASK                      0x00000004U
#define FPGA_REG2__RXPIPEIFINJERRINDATAK__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000004U) >> 2)
#define FPGA_REG2__RXPIPEIFINJERRINDATAK__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 2) & 0x00000004U)
#define FPGA_REG2__RXPIPEIFINJERRINDATAK__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000004U) | (((u_int32_t)(src) <<\
                    2) & 0x00000004U)
#define FPGA_REG2__RXPIPEIFINJERRINDATAK__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 2) & ~0x00000004U)))
#define FPGA_REG2__RXPIPEIFINJERRINDATAK__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000004U) | ((u_int32_t)(1) << 2)
#define FPGA_REG2__RXPIPEIFINJERRINDATAK__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000004U) | ((u_int32_t)(0) << 2)

/* macros for field TxPipeIFInjErrInDataK */
#define FPGA_REG2__TXPIPEIFINJERRINDATAK__SHIFT                               3
#define FPGA_REG2__TXPIPEIFINJERRINDATAK__WIDTH                               1
#define FPGA_REG2__TXPIPEIFINJERRINDATAK__MASK                      0x00000008U
#define FPGA_REG2__TXPIPEIFINJERRINDATAK__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000008U) >> 3)
#define FPGA_REG2__TXPIPEIFINJERRINDATAK__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 3) & 0x00000008U)
#define FPGA_REG2__TXPIPEIFINJERRINDATAK__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000008U) | (((u_int32_t)(src) <<\
                    3) & 0x00000008U)
#define FPGA_REG2__TXPIPEIFINJERRINDATAK__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 3) & ~0x00000008U)))
#define FPGA_REG2__TXPIPEIFINJERRINDATAK__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000008U) | ((u_int32_t)(1) << 3)
#define FPGA_REG2__TXPIPEIFINJERRINDATAK__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000008U) | ((u_int32_t)(0) << 3)

/* macros for field dummy_error_injection */
#define FPGA_REG2__DUMMY_ERROR_INJECTION__SHIFT                               4
#define FPGA_REG2__DUMMY_ERROR_INJECTION__WIDTH                              28
#define FPGA_REG2__DUMMY_ERROR_INJECTION__MASK                      0xfffffff0U
#define FPGA_REG2__DUMMY_ERROR_INJECTION__READ(src) \
                    (((u_int32_t)(src)\
                    & 0xfffffff0U) >> 4)
#define FPGA_REG2__DUMMY_ERROR_INJECTION__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 4) & 0xfffffff0U)
#define FPGA_REG2__DUMMY_ERROR_INJECTION__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xfffffff0U) | (((u_int32_t)(src) <<\
                    4) & 0xfffffff0U)
#define FPGA_REG2__DUMMY_ERROR_INJECTION__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 4) & ~0xfffffff0U)))
#define FPGA_REG2__TYPE                                               u_int32_t
#define FPGA_REG2__READ                                             0xffffffffU
#define FPGA_REG2__WRITE                                            0xffffffffU

#endif /* __FPGA_REG2_MACRO__ */


/* macros for emulation_misc_reg_block.FPGA_REG2 */
#define INST_EMULATION_MISC_REG_BLOCK__FPGA_REG2__NUM                         1

/* macros for BlueprintGlobalNameSpace::FPGA_REG3 */
#ifndef __FPGA_REG3_MACRO__
#define __FPGA_REG3_MACRO__

/* macros for field fpga_changelist */
#define FPGA_REG3__FPGA_CHANGELIST__SHIFT                                     0
#define FPGA_REG3__FPGA_CHANGELIST__WIDTH                                    32
#define FPGA_REG3__FPGA_CHANGELIST__MASK                            0xffffffffU
#define FPGA_REG3__FPGA_CHANGELIST__READ(src)    (u_int32_t)(src) & 0xffffffffU
#define FPGA_REG3__TYPE                                               u_int32_t
#define FPGA_REG3__READ                                             0xffffffffU

#endif /* __FPGA_REG3_MACRO__ */


/* macros for emulation_misc_reg_block.FPGA_REG3 */
#define INST_EMULATION_MISC_REG_BLOCK__FPGA_REG3__NUM                         1

/* macros for BlueprintGlobalNameSpace::FPGA_REG4 */
#ifndef __FPGA_REG4_MACRO__
#define __FPGA_REG4_MACRO__

/* macros for field radio_0_tck */
#define FPGA_REG4__RADIO_0_TCK__SHIFT                                         0
#define FPGA_REG4__RADIO_0_TCK__WIDTH                                         1
#define FPGA_REG4__RADIO_0_TCK__MASK                                0x00000001U
#define FPGA_REG4__RADIO_0_TCK__READ(src)        (u_int32_t)(src) & 0x00000001U
#define FPGA_REG4__RADIO_0_TCK__WRITE(src)     ((u_int32_t)(src) & 0x00000001U)
#define FPGA_REG4__RADIO_0_TCK__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | ((u_int32_t)(src) &\
                    0x00000001U)
#define FPGA_REG4__RADIO_0_TCK__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00000001U)))
#define FPGA_REG4__RADIO_0_TCK__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(1)
#define FPGA_REG4__RADIO_0_TCK__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(0)

/* macros for field radio_0_tdi */
#define FPGA_REG4__RADIO_0_TDI__SHIFT                                         1
#define FPGA_REG4__RADIO_0_TDI__WIDTH                                         1
#define FPGA_REG4__RADIO_0_TDI__MASK                                0x00000002U
#define FPGA_REG4__RADIO_0_TDI__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000002U) >> 1)
#define FPGA_REG4__RADIO_0_TDI__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 1) & 0x00000002U)
#define FPGA_REG4__RADIO_0_TDI__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | (((u_int32_t)(src) <<\
                    1) & 0x00000002U)
#define FPGA_REG4__RADIO_0_TDI__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 1) & ~0x00000002U)))
#define FPGA_REG4__RADIO_0_TDI__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | ((u_int32_t)(1) << 1)
#define FPGA_REG4__RADIO_0_TDI__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | ((u_int32_t)(0) << 1)

/* macros for field radio_0_tms */
#define FPGA_REG4__RADIO_0_TMS__SHIFT                                         2
#define FPGA_REG4__RADIO_0_TMS__WIDTH                                         1
#define FPGA_REG4__RADIO_0_TMS__MASK                                0x00000004U
#define FPGA_REG4__RADIO_0_TMS__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000004U) >> 2)
#define FPGA_REG4__RADIO_0_TMS__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 2) & 0x00000004U)
#define FPGA_REG4__RADIO_0_TMS__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000004U) | (((u_int32_t)(src) <<\
                    2) & 0x00000004U)
#define FPGA_REG4__RADIO_0_TMS__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 2) & ~0x00000004U)))
#define FPGA_REG4__RADIO_0_TMS__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000004U) | ((u_int32_t)(1) << 2)
#define FPGA_REG4__RADIO_0_TMS__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000004U) | ((u_int32_t)(0) << 2)

/* macros for field radio_0_tdo */
#define FPGA_REG4__RADIO_0_TDO__SHIFT                                         3
#define FPGA_REG4__RADIO_0_TDO__WIDTH                                         1
#define FPGA_REG4__RADIO_0_TDO__MASK                                0x00000008U
#define FPGA_REG4__RADIO_0_TDO__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000008U) >> 3)
#define FPGA_REG4__RADIO_0_TDO__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000008U) | ((u_int32_t)(1) << 3)
#define FPGA_REG4__RADIO_0_TDO__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000008U) | ((u_int32_t)(0) << 3)

/* macros for field radio_1_tck */
#define FPGA_REG4__RADIO_1_TCK__SHIFT                                         4
#define FPGA_REG4__RADIO_1_TCK__WIDTH                                         1
#define FPGA_REG4__RADIO_1_TCK__MASK                                0x00000010U
#define FPGA_REG4__RADIO_1_TCK__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000010U) >> 4)
#define FPGA_REG4__RADIO_1_TCK__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 4) & 0x00000010U)
#define FPGA_REG4__RADIO_1_TCK__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000010U) | (((u_int32_t)(src) <<\
                    4) & 0x00000010U)
#define FPGA_REG4__RADIO_1_TCK__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 4) & ~0x00000010U)))
#define FPGA_REG4__RADIO_1_TCK__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000010U) | ((u_int32_t)(1) << 4)
#define FPGA_REG4__RADIO_1_TCK__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000010U) | ((u_int32_t)(0) << 4)

/* macros for field radio_1_tdi */
#define FPGA_REG4__RADIO_1_TDI__SHIFT                                         5
#define FPGA_REG4__RADIO_1_TDI__WIDTH                                         1
#define FPGA_REG4__RADIO_1_TDI__MASK                                0x00000020U
#define FPGA_REG4__RADIO_1_TDI__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000020U) >> 5)
#define FPGA_REG4__RADIO_1_TDI__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 5) & 0x00000020U)
#define FPGA_REG4__RADIO_1_TDI__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000020U) | (((u_int32_t)(src) <<\
                    5) & 0x00000020U)
#define FPGA_REG4__RADIO_1_TDI__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 5) & ~0x00000020U)))
#define FPGA_REG4__RADIO_1_TDI__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000020U) | ((u_int32_t)(1) << 5)
#define FPGA_REG4__RADIO_1_TDI__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000020U) | ((u_int32_t)(0) << 5)

/* macros for field radio_1_tms */
#define FPGA_REG4__RADIO_1_TMS__SHIFT                                         6
#define FPGA_REG4__RADIO_1_TMS__WIDTH                                         1
#define FPGA_REG4__RADIO_1_TMS__MASK                                0x00000040U
#define FPGA_REG4__RADIO_1_TMS__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000040U) >> 6)
#define FPGA_REG4__RADIO_1_TMS__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 6) & 0x00000040U)
#define FPGA_REG4__RADIO_1_TMS__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000040U) | (((u_int32_t)(src) <<\
                    6) & 0x00000040U)
#define FPGA_REG4__RADIO_1_TMS__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 6) & ~0x00000040U)))
#define FPGA_REG4__RADIO_1_TMS__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000040U) | ((u_int32_t)(1) << 6)
#define FPGA_REG4__RADIO_1_TMS__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000040U) | ((u_int32_t)(0) << 6)

/* macros for field radio_1_tdo */
#define FPGA_REG4__RADIO_1_TDO__SHIFT                                         7
#define FPGA_REG4__RADIO_1_TDO__WIDTH                                         1
#define FPGA_REG4__RADIO_1_TDO__MASK                                0x00000080U
#define FPGA_REG4__RADIO_1_TDO__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000080U) >> 7)
#define FPGA_REG4__RADIO_1_TDO__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000080U) | ((u_int32_t)(1) << 7)
#define FPGA_REG4__RADIO_1_TDO__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000080U) | ((u_int32_t)(0) << 7)

/* macros for field radio_2_tck */
#define FPGA_REG4__RADIO_2_TCK__SHIFT                                         8
#define FPGA_REG4__RADIO_2_TCK__WIDTH                                         1
#define FPGA_REG4__RADIO_2_TCK__MASK                                0x00000100U
#define FPGA_REG4__RADIO_2_TCK__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000100U) >> 8)
#define FPGA_REG4__RADIO_2_TCK__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 8) & 0x00000100U)
#define FPGA_REG4__RADIO_2_TCK__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000100U) | (((u_int32_t)(src) <<\
                    8) & 0x00000100U)
#define FPGA_REG4__RADIO_2_TCK__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 8) & ~0x00000100U)))
#define FPGA_REG4__RADIO_2_TCK__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000100U) | ((u_int32_t)(1) << 8)
#define FPGA_REG4__RADIO_2_TCK__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000100U) | ((u_int32_t)(0) << 8)

/* macros for field radio_2_tdi */
#define FPGA_REG4__RADIO_2_TDI__SHIFT                                         9
#define FPGA_REG4__RADIO_2_TDI__WIDTH                                         1
#define FPGA_REG4__RADIO_2_TDI__MASK                                0x00000200U
#define FPGA_REG4__RADIO_2_TDI__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000200U) >> 9)
#define FPGA_REG4__RADIO_2_TDI__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 9) & 0x00000200U)
#define FPGA_REG4__RADIO_2_TDI__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000200U) | (((u_int32_t)(src) <<\
                    9) & 0x00000200U)
#define FPGA_REG4__RADIO_2_TDI__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 9) & ~0x00000200U)))
#define FPGA_REG4__RADIO_2_TDI__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000200U) | ((u_int32_t)(1) << 9)
#define FPGA_REG4__RADIO_2_TDI__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000200U) | ((u_int32_t)(0) << 9)

/* macros for field radio_2_tms */
#define FPGA_REG4__RADIO_2_TMS__SHIFT                                        10
#define FPGA_REG4__RADIO_2_TMS__WIDTH                                         1
#define FPGA_REG4__RADIO_2_TMS__MASK                                0x00000400U
#define FPGA_REG4__RADIO_2_TMS__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000400U) >> 10)
#define FPGA_REG4__RADIO_2_TMS__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 10) & 0x00000400U)
#define FPGA_REG4__RADIO_2_TMS__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000400U) | (((u_int32_t)(src) <<\
                    10) & 0x00000400U)
#define FPGA_REG4__RADIO_2_TMS__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 10) & ~0x00000400U)))
#define FPGA_REG4__RADIO_2_TMS__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000400U) | ((u_int32_t)(1) << 10)
#define FPGA_REG4__RADIO_2_TMS__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000400U) | ((u_int32_t)(0) << 10)

/* macros for field radio_2_tdo */
#define FPGA_REG4__RADIO_2_TDO__SHIFT                                        11
#define FPGA_REG4__RADIO_2_TDO__WIDTH                                         1
#define FPGA_REG4__RADIO_2_TDO__MASK                                0x00000800U
#define FPGA_REG4__RADIO_2_TDO__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000800U) >> 11)
#define FPGA_REG4__RADIO_2_TDO__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000800U) | ((u_int32_t)(1) << 11)
#define FPGA_REG4__RADIO_2_TDO__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000800U) | ((u_int32_t)(0) << 11)

/* macros for field radio_3_tck */
#define FPGA_REG4__RADIO_3_TCK__SHIFT                                        12
#define FPGA_REG4__RADIO_3_TCK__WIDTH                                         1
#define FPGA_REG4__RADIO_3_TCK__MASK                                0x00001000U
#define FPGA_REG4__RADIO_3_TCK__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00001000U) >> 12)
#define FPGA_REG4__RADIO_3_TCK__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 12) & 0x00001000U)
#define FPGA_REG4__RADIO_3_TCK__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00001000U) | (((u_int32_t)(src) <<\
                    12) & 0x00001000U)
#define FPGA_REG4__RADIO_3_TCK__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 12) & ~0x00001000U)))
#define FPGA_REG4__RADIO_3_TCK__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00001000U) | ((u_int32_t)(1) << 12)
#define FPGA_REG4__RADIO_3_TCK__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00001000U) | ((u_int32_t)(0) << 12)

/* macros for field radio_3_tdi */
#define FPGA_REG4__RADIO_3_TDI__SHIFT                                        13
#define FPGA_REG4__RADIO_3_TDI__WIDTH                                         1
#define FPGA_REG4__RADIO_3_TDI__MASK                                0x00002000U
#define FPGA_REG4__RADIO_3_TDI__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00002000U) >> 13)
#define FPGA_REG4__RADIO_3_TDI__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 13) & 0x00002000U)
#define FPGA_REG4__RADIO_3_TDI__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00002000U) | (((u_int32_t)(src) <<\
                    13) & 0x00002000U)
#define FPGA_REG4__RADIO_3_TDI__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 13) & ~0x00002000U)))
#define FPGA_REG4__RADIO_3_TDI__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00002000U) | ((u_int32_t)(1) << 13)
#define FPGA_REG4__RADIO_3_TDI__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00002000U) | ((u_int32_t)(0) << 13)

/* macros for field radio_3_tms */
#define FPGA_REG4__RADIO_3_TMS__SHIFT                                        14
#define FPGA_REG4__RADIO_3_TMS__WIDTH                                         1
#define FPGA_REG4__RADIO_3_TMS__MASK                                0x00004000U
#define FPGA_REG4__RADIO_3_TMS__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00004000U) >> 14)
#define FPGA_REG4__RADIO_3_TMS__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 14) & 0x00004000U)
#define FPGA_REG4__RADIO_3_TMS__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00004000U) | (((u_int32_t)(src) <<\
                    14) & 0x00004000U)
#define FPGA_REG4__RADIO_3_TMS__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 14) & ~0x00004000U)))
#define FPGA_REG4__RADIO_3_TMS__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00004000U) | ((u_int32_t)(1) << 14)
#define FPGA_REG4__RADIO_3_TMS__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00004000U) | ((u_int32_t)(0) << 14)

/* macros for field radio_3_tdo */
#define FPGA_REG4__RADIO_3_TDO__SHIFT                                        15
#define FPGA_REG4__RADIO_3_TDO__WIDTH                                         1
#define FPGA_REG4__RADIO_3_TDO__MASK                                0x00008000U
#define FPGA_REG4__RADIO_3_TDO__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00008000U) >> 15)
#define FPGA_REG4__RADIO_3_TDO__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00008000U) | ((u_int32_t)(1) << 15)
#define FPGA_REG4__RADIO_3_TDO__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00008000U) | ((u_int32_t)(0) << 15)
#define FPGA_REG4__TYPE                                               u_int32_t
#define FPGA_REG4__READ                                             0x0000ffffU
#define FPGA_REG4__WRITE                                            0x0000ffffU

#endif /* __FPGA_REG4_MACRO__ */


/* macros for emulation_misc_reg_block.FPGA_REG4 */
#define INST_EMULATION_MISC_REG_BLOCK__FPGA_REG4__NUM                         1

/* macros for BlueprintGlobalNameSpace::FPGA_REG5 */
#ifndef __FPGA_REG5_MACRO__
#define __FPGA_REG5_MACRO__

/* macros for field drp_den */
#define FPGA_REG5__DRP_DEN__SHIFT                                             0
#define FPGA_REG5__DRP_DEN__WIDTH                                             1
#define FPGA_REG5__DRP_DEN__MASK                                    0x00000001U
#define FPGA_REG5__DRP_DEN__READ(src)            (u_int32_t)(src) & 0x00000001U
#define FPGA_REG5__DRP_DEN__WRITE(src)         ((u_int32_t)(src) & 0x00000001U)
#define FPGA_REG5__DRP_DEN__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | ((u_int32_t)(src) &\
                    0x00000001U)
#define FPGA_REG5__DRP_DEN__VERIFY(src)  (!(((u_int32_t)(src) & ~0x00000001U)))
#define FPGA_REG5__DRP_DEN__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(1)
#define FPGA_REG5__DRP_DEN__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(0)

/* macros for field drp_dwe */
#define FPGA_REG5__DRP_DWE__SHIFT                                             1
#define FPGA_REG5__DRP_DWE__WIDTH                                             1
#define FPGA_REG5__DRP_DWE__MASK                                    0x00000002U
#define FPGA_REG5__DRP_DWE__READ(src)   (((u_int32_t)(src) & 0x00000002U) >> 1)
#define FPGA_REG5__DRP_DWE__WRITE(src)  (((u_int32_t)(src) << 1) & 0x00000002U)
#define FPGA_REG5__DRP_DWE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | (((u_int32_t)(src) <<\
                    1) & 0x00000002U)
#define FPGA_REG5__DRP_DWE__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 1) & ~0x00000002U)))
#define FPGA_REG5__DRP_DWE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | ((u_int32_t)(1) << 1)
#define FPGA_REG5__DRP_DWE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | ((u_int32_t)(0) << 1)

/* macros for field drp_reset */
#define FPGA_REG5__DRP_RESET__SHIFT                                           2
#define FPGA_REG5__DRP_RESET__WIDTH                                           1
#define FPGA_REG5__DRP_RESET__MASK                                  0x00000004U
#define FPGA_REG5__DRP_RESET__READ(src) (((u_int32_t)(src) & 0x00000004U) >> 2)
#define FPGA_REG5__DRP_RESET__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 2) & 0x00000004U)
#define FPGA_REG5__DRP_RESET__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000004U) | (((u_int32_t)(src) <<\
                    2) & 0x00000004U)
#define FPGA_REG5__DRP_RESET__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 2) & ~0x00000004U)))
#define FPGA_REG5__DRP_RESET__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000004U) | ((u_int32_t)(1) << 2)
#define FPGA_REG5__DRP_RESET__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000004U) | ((u_int32_t)(0) << 2)

/* macros for field drp_address */
#define FPGA_REG5__DRP_ADDRESS__SHIFT                                         3
#define FPGA_REG5__DRP_ADDRESS__WIDTH                                         5
#define FPGA_REG5__DRP_ADDRESS__MASK                                0x000000f8U
#define FPGA_REG5__DRP_ADDRESS__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x000000f8U) >> 3)
#define FPGA_REG5__DRP_ADDRESS__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 3) & 0x000000f8U)
#define FPGA_REG5__DRP_ADDRESS__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000000f8U) | (((u_int32_t)(src) <<\
                    3) & 0x000000f8U)
#define FPGA_REG5__DRP_ADDRESS__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 3) & ~0x000000f8U)))

/* macros for field drp_reserved */
#define FPGA_REG5__DRP_RESERVED__SHIFT                                        8
#define FPGA_REG5__DRP_RESERVED__WIDTH                                        8
#define FPGA_REG5__DRP_RESERVED__MASK                               0x0000ff00U
#define FPGA_REG5__DRP_RESERVED__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0000ff00U) >> 8)
#define FPGA_REG5__DRP_RESERVED__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 8) & 0x0000ff00U)
#define FPGA_REG5__DRP_RESERVED__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000ff00U) | (((u_int32_t)(src) <<\
                    8) & 0x0000ff00U)
#define FPGA_REG5__DRP_RESERVED__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 8) & ~0x0000ff00U)))

/* macros for field drp_din */
#define FPGA_REG5__DRP_DIN__SHIFT                                            16
#define FPGA_REG5__DRP_DIN__WIDTH                                            16
#define FPGA_REG5__DRP_DIN__MASK                                    0xffff0000U
#define FPGA_REG5__DRP_DIN__READ(src)  (((u_int32_t)(src) & 0xffff0000U) >> 16)
#define FPGA_REG5__DRP_DIN__WRITE(src) (((u_int32_t)(src) << 16) & 0xffff0000U)
#define FPGA_REG5__DRP_DIN__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xffff0000U) | (((u_int32_t)(src) <<\
                    16) & 0xffff0000U)
#define FPGA_REG5__DRP_DIN__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 16) & ~0xffff0000U)))
#define FPGA_REG5__TYPE                                               u_int32_t
#define FPGA_REG5__READ                                             0xffffffffU
#define FPGA_REG5__WRITE                                            0xffffffffU

#endif /* __FPGA_REG5_MACRO__ */


/* macros for emulation_misc_reg_block.FPGA_REG5 */
#define INST_EMULATION_MISC_REG_BLOCK__FPGA_REG5__NUM                         1

/* macros for BlueprintGlobalNameSpace::FPGA_REG6 */
#ifndef __FPGA_REG6_MACRO__
#define __FPGA_REG6_MACRO__

/* macros for field drp_drdy */
#define FPGA_REG6__DRP_DRDY__SHIFT                                            0
#define FPGA_REG6__DRP_DRDY__WIDTH                                            1
#define FPGA_REG6__DRP_DRDY__MASK                                   0x00000001U
#define FPGA_REG6__DRP_DRDY__READ(src)           (u_int32_t)(src) & 0x00000001U
#define FPGA_REG6__DRP_DRDY__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(1)
#define FPGA_REG6__DRP_DRDY__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(0)

/* macros for field drp_dout */
#define FPGA_REG6__DRP_DOUT__SHIFT                                           16
#define FPGA_REG6__DRP_DOUT__WIDTH                                           16
#define FPGA_REG6__DRP_DOUT__MASK                                   0xffff0000U
#define FPGA_REG6__DRP_DOUT__READ(src) (((u_int32_t)(src) & 0xffff0000U) >> 16)
#define FPGA_REG6__TYPE                                               u_int32_t
#define FPGA_REG6__READ                                             0xffff0001U

#endif /* __FPGA_REG6_MACRO__ */


/* macros for emulation_misc_reg_block.FPGA_REG6 */
#define INST_EMULATION_MISC_REG_BLOCK__FPGA_REG6__NUM                         1

/* macros for BlueprintGlobalNameSpace::FPGA_REG7 */
#ifndef __FPGA_REG7_MACRO__
#define __FPGA_REG7_MACRO__

/* macros for field RxPipeIFerrInjMsk */
#define FPGA_REG7__RXPIPEIFERRINJMSK__SHIFT                                   0
#define FPGA_REG7__RXPIPEIFERRINJMSK__WIDTH                                  32
#define FPGA_REG7__RXPIPEIFERRINJMSK__MASK                          0xffffffffU
#define FPGA_REG7__RXPIPEIFERRINJMSK__READ(src)  (u_int32_t)(src) & 0xffffffffU
#define FPGA_REG7__RXPIPEIFERRINJMSK__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0xffffffffU)
#define FPGA_REG7__RXPIPEIFERRINJMSK__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xffffffffU) | ((u_int32_t)(src) &\
                    0xffffffffU)
#define FPGA_REG7__RXPIPEIFERRINJMSK__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0xffffffffU)))
#define FPGA_REG7__TYPE                                               u_int32_t
#define FPGA_REG7__READ                                             0xffffffffU
#define FPGA_REG7__WRITE                                            0xffffffffU

#endif /* __FPGA_REG7_MACRO__ */


/* macros for emulation_misc_reg_block.FPGA_REG7 */
#define INST_EMULATION_MISC_REG_BLOCK__FPGA_REG7__NUM                         1

/* macros for BlueprintGlobalNameSpace::FPGA_REG8 */
#ifndef __FPGA_REG8_MACRO__
#define __FPGA_REG8_MACRO__

/* macros for field TxPipeIFerrInjMsk */
#define FPGA_REG8__TXPIPEIFERRINJMSK__SHIFT                                   0
#define FPGA_REG8__TXPIPEIFERRINJMSK__WIDTH                                  32
#define FPGA_REG8__TXPIPEIFERRINJMSK__MASK                          0xffffffffU
#define FPGA_REG8__TXPIPEIFERRINJMSK__READ(src)  (u_int32_t)(src) & 0xffffffffU
#define FPGA_REG8__TXPIPEIFERRINJMSK__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0xffffffffU)
#define FPGA_REG8__TXPIPEIFERRINJMSK__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xffffffffU) | ((u_int32_t)(src) &\
                    0xffffffffU)
#define FPGA_REG8__TXPIPEIFERRINJMSK__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0xffffffffU)))
#define FPGA_REG8__TYPE                                               u_int32_t
#define FPGA_REG8__READ                                             0xffffffffU
#define FPGA_REG8__WRITE                                            0xffffffffU

#endif /* __FPGA_REG8_MACRO__ */


/* macros for emulation_misc_reg_block.FPGA_REG8 */
#define INST_EMULATION_MISC_REG_BLOCK__FPGA_REG8__NUM                         1

/* macros for BlueprintGlobalNameSpace::FPGA_REG9 */
#ifndef __FPGA_REG9_MACRO__
#define __FPGA_REG9_MACRO__

/* macros for field RxPipeIFDataErrMsk */
#define FPGA_REG9__RXPIPEIFDATAERRMSK__SHIFT                                  0
#define FPGA_REG9__RXPIPEIFDATAERRMSK__WIDTH                                 16
#define FPGA_REG9__RXPIPEIFDATAERRMSK__MASK                         0x0000ffffU
#define FPGA_REG9__RXPIPEIFDATAERRMSK__READ(src) (u_int32_t)(src) & 0x0000ffffU
#define FPGA_REG9__RXPIPEIFDATAERRMSK__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x0000ffffU)
#define FPGA_REG9__RXPIPEIFDATAERRMSK__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000ffffU) | ((u_int32_t)(src) &\
                    0x0000ffffU)
#define FPGA_REG9__RXPIPEIFDATAERRMSK__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x0000ffffU)))

/* macros for field TxPipeIFDataErrMsk */
#define FPGA_REG9__TXPIPEIFDATAERRMSK__SHIFT                                 16
#define FPGA_REG9__TXPIPEIFDATAERRMSK__WIDTH                                 16
#define FPGA_REG9__TXPIPEIFDATAERRMSK__MASK                         0xffff0000U
#define FPGA_REG9__TXPIPEIFDATAERRMSK__READ(src) \
                    (((u_int32_t)(src)\
                    & 0xffff0000U) >> 16)
#define FPGA_REG9__TXPIPEIFDATAERRMSK__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 16) & 0xffff0000U)
#define FPGA_REG9__TXPIPEIFDATAERRMSK__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xffff0000U) | (((u_int32_t)(src) <<\
                    16) & 0xffff0000U)
#define FPGA_REG9__TXPIPEIFDATAERRMSK__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 16) & ~0xffff0000U)))
#define FPGA_REG9__TYPE                                               u_int32_t
#define FPGA_REG9__READ                                             0xffffffffU
#define FPGA_REG9__WRITE                                            0xffffffffU

#endif /* __FPGA_REG9_MACRO__ */


/* macros for emulation_misc_reg_block.FPGA_REG9 */
#define INST_EMULATION_MISC_REG_BLOCK__FPGA_REG9__NUM                         1

/* macros for BlueprintGlobalNameSpace::FPGA_REG10 */
#ifndef __FPGA_REG10_MACRO__
#define __FPGA_REG10_MACRO__

/* macros for field RxPipeIFSpdMsk */
#define FPGA_REG10__RXPIPEIFSPDMSK__SHIFT                                     0
#define FPGA_REG10__RXPIPEIFSPDMSK__WIDTH                                    16
#define FPGA_REG10__RXPIPEIFSPDMSK__MASK                            0x0000ffffU
#define FPGA_REG10__RXPIPEIFSPDMSK__READ(src)    (u_int32_t)(src) & 0x0000ffffU
#define FPGA_REG10__RXPIPEIFSPDMSK__WRITE(src) ((u_int32_t)(src) & 0x0000ffffU)
#define FPGA_REG10__RXPIPEIFSPDMSK__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000ffffU) | ((u_int32_t)(src) &\
                    0x0000ffffU)
#define FPGA_REG10__RXPIPEIFSPDMSK__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x0000ffffU)))

/* macros for field TxPipeIFSpdMsk */
#define FPGA_REG10__TXPIPEIFSPDMSK__SHIFT                                    16
#define FPGA_REG10__TXPIPEIFSPDMSK__WIDTH                                    16
#define FPGA_REG10__TXPIPEIFSPDMSK__MASK                            0xffff0000U
#define FPGA_REG10__TXPIPEIFSPDMSK__READ(src) \
                    (((u_int32_t)(src)\
                    & 0xffff0000U) >> 16)
#define FPGA_REG10__TXPIPEIFSPDMSK__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 16) & 0xffff0000U)
#define FPGA_REG10__TXPIPEIFSPDMSK__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xffff0000U) | (((u_int32_t)(src) <<\
                    16) & 0xffff0000U)
#define FPGA_REG10__TXPIPEIFSPDMSK__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 16) & ~0xffff0000U)))
#define FPGA_REG10__TYPE                                              u_int32_t
#define FPGA_REG10__READ                                            0xffffffffU
#define FPGA_REG10__WRITE                                           0xffffffffU

#endif /* __FPGA_REG10_MACRO__ */


/* macros for emulation_misc_reg_block.FPGA_REG10 */
#define INST_EMULATION_MISC_REG_BLOCK__FPGA_REG10__NUM                        1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_0::ID */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__ID_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__ID_MACRO__

/* macros for field VendorID */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__ID__VENDORID__SHIFT             0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__ID__VENDORID__WIDTH            16
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__ID__VENDORID__MASK    0x0000ffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__ID__VENDORID__READ(src) \
                    (u_int32_t)(src)\
                    & 0x0000ffffU

/* macros for field DeviceID */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__ID__DEVICEID__SHIFT            16
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__ID__DEVICEID__WIDTH            16
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__ID__DEVICEID__MASK    0xffff0000U
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__ID__DEVICEID__READ(src) \
                    (((u_int32_t)(src)\
                    & 0xffff0000U) >> 16)
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__ID__TYPE                u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__ID__READ              0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__ID_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.ID */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__ID__NUM                                  1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_0::STS_CMD_RGSTR */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__STS_CMD_RGSTR_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__STS_CMD_RGSTR_MACRO__

/* macros for field CMD_RGSTR */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__STS_CMD_RGSTR__CMD_RGSTR__SHIFT 0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__STS_CMD_RGSTR__CMD_RGSTR__WIDTH \
                    16
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__STS_CMD_RGSTR__CMD_RGSTR__MASK \
                    0x0000ffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__STS_CMD_RGSTR__CMD_RGSTR__READ(src) \
                    (u_int32_t)(src)\
                    & 0x0000ffffU

/* macros for field STS_RGSTR */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__STS_CMD_RGSTR__STS_RGSTR__SHIFT \
                    16
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__STS_CMD_RGSTR__STS_RGSTR__WIDTH \
                    16
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__STS_CMD_RGSTR__STS_RGSTR__MASK \
                    0xffff0000U
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__STS_CMD_RGSTR__STS_RGSTR__READ(src) \
                    (((u_int32_t)(src)\
                    & 0xffff0000U) >> 16)
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__STS_CMD_RGSTR__TYPE     u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__STS_CMD_RGSTR__READ   0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__STS_CMD_RGSTR_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.STS_CMD_RGSTR */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__STS_CMD_RGSTR__NUM                       1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_0::CLS_REV_ID */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__CLS_REV_ID_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__CLS_REV_ID_MACRO__

/* macros for field RevID */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__CLS_REV_ID__REVID__SHIFT        0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__CLS_REV_ID__REVID__WIDTH        8
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__CLS_REV_ID__REVID__MASK \
                    0x000000ffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__CLS_REV_ID__REVID__READ(src) \
                    (u_int32_t)(src)\
                    & 0x000000ffU

/* macros for field CLS_CD */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__CLS_REV_ID__CLS_CD__SHIFT       8
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__CLS_REV_ID__CLS_CD__WIDTH      24
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__CLS_REV_ID__CLS_CD__MASK \
                    0xffffff00U
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__CLS_REV_ID__CLS_CD__READ(src) \
                    (((u_int32_t)(src)\
                    & 0xffffff00U) >> 8)
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__CLS_REV_ID__TYPE        u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__CLS_REV_ID__READ      0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__CLS_REV_ID_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.CLS_REV_ID */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__CLS_REV_ID__NUM                          1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_0::BIST_HEAD_LAT_CACH */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__BIST_HEAD_LAT_CACH_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__BIST_HEAD_LAT_CACH_MACRO__

/* macros for field CACH_LN_SZE */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__BIST_HEAD_LAT_CACH__CACH_LN_SZE__SHIFT \
                    0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__BIST_HEAD_LAT_CACH__CACH_LN_SZE__WIDTH \
                    8
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__BIST_HEAD_LAT_CACH__CACH_LN_SZE__MASK \
                    0x000000ffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__BIST_HEAD_LAT_CACH__CACH_LN_SZE__READ(src) \
                    (u_int32_t)(src)\
                    & 0x000000ffU

/* macros for field LAT_TIM */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__BIST_HEAD_LAT_CACH__LAT_TIM__SHIFT \
                    8
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__BIST_HEAD_LAT_CACH__LAT_TIM__WIDTH \
                    8
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__BIST_HEAD_LAT_CACH__LAT_TIM__MASK \
                    0x0000ff00U
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__BIST_HEAD_LAT_CACH__LAT_TIM__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0000ff00U) >> 8)

/* macros for field HEAD_TYP */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__BIST_HEAD_LAT_CACH__HEAD_TYP__SHIFT \
                    16
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__BIST_HEAD_LAT_CACH__HEAD_TYP__WIDTH \
                    8
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__BIST_HEAD_LAT_CACH__HEAD_TYP__MASK \
                    0x00ff0000U
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__BIST_HEAD_LAT_CACH__HEAD_TYP__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00ff0000U) >> 16)

/* macros for field BIST */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__BIST_HEAD_LAT_CACH__BIST__SHIFT \
                    24
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__BIST_HEAD_LAT_CACH__BIST__WIDTH 8
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__BIST_HEAD_LAT_CACH__BIST__MASK \
                    0xff000000U
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__BIST_HEAD_LAT_CACH__BIST__READ(src) \
                    (((u_int32_t)(src)\
                    & 0xff000000U) >> 24)
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__BIST_HEAD_LAT_CACH__TYPE \
                    u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__BIST_HEAD_LAT_CACH__READ \
                    0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__BIST_HEAD_LAT_CACH_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.BIST_HEAD_LAT_CACH */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__BIST_HEAD_LAT_CACH__NUM                  1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_0::BAS_ADR_0 */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__BAS_ADR_0_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__BAS_ADR_0_MACRO__

/* macros for field rdl */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__BAS_ADR_0__RDL__SHIFT           0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__BAS_ADR_0__RDL__WIDTH          32
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__BAS_ADR_0__RDL__MASK  0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__BAS_ADR_0__RDL__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__BAS_ADR_0__TYPE         u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__BAS_ADR_0__READ       0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__BAS_ADR_0_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.BAS_ADR_0 */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__BAS_ADR_0__NUM                           1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_0::BAS_ADR_1 */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__BAS_ADR_1_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__BAS_ADR_1_MACRO__

/* macros for field rdl */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__BAS_ADR_1__RDL__SHIFT           0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__BAS_ADR_1__RDL__WIDTH          32
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__BAS_ADR_1__RDL__MASK  0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__BAS_ADR_1__RDL__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__BAS_ADR_1__TYPE         u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__BAS_ADR_1__READ       0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__BAS_ADR_1_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.BAS_ADR_1 */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__BAS_ADR_1__NUM                           1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_0::BAS_ADR_2 */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__BAS_ADR_2_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__BAS_ADR_2_MACRO__

/* macros for field rdl */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__BAS_ADR_2__RDL__SHIFT           0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__BAS_ADR_2__RDL__WIDTH          32
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__BAS_ADR_2__RDL__MASK  0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__BAS_ADR_2__RDL__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__BAS_ADR_2__TYPE         u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__BAS_ADR_2__READ       0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__BAS_ADR_2_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.BAS_ADR_2 */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__BAS_ADR_2__NUM                           1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_0::BAS_ADR_3 */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__BAS_ADR_3_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__BAS_ADR_3_MACRO__

/* macros for field rdl */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__BAS_ADR_3__RDL__SHIFT           0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__BAS_ADR_3__RDL__WIDTH          32
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__BAS_ADR_3__RDL__MASK  0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__BAS_ADR_3__RDL__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__BAS_ADR_3__TYPE         u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__BAS_ADR_3__READ       0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__BAS_ADR_3_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.BAS_ADR_3 */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__BAS_ADR_3__NUM                           1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_0::BAS_ADR_4 */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__BAS_ADR_4_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__BAS_ADR_4_MACRO__

/* macros for field rdl */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__BAS_ADR_4__RDL__SHIFT           0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__BAS_ADR_4__RDL__WIDTH          32
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__BAS_ADR_4__RDL__MASK  0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__BAS_ADR_4__RDL__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__BAS_ADR_4__TYPE         u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__BAS_ADR_4__READ       0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__BAS_ADR_4_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.BAS_ADR_4 */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__BAS_ADR_4__NUM                           1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_0::BAS_ADR_5 */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__BAS_ADR_5_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__BAS_ADR_5_MACRO__

/* macros for field rdl */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__BAS_ADR_5__RDL__SHIFT           0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__BAS_ADR_5__RDL__WIDTH          32
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__BAS_ADR_5__RDL__MASK  0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__BAS_ADR_5__RDL__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__BAS_ADR_5__TYPE         u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__BAS_ADR_5__READ       0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__BAS_ADR_5_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.BAS_ADR_5 */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__BAS_ADR_5__NUM                           1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_0::CRD_CIS_PTR */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__CRD_CIS_PTR_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__CRD_CIS_PTR_MACRO__

/* macros for field rdl */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__CRD_CIS_PTR__RDL__SHIFT         0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__CRD_CIS_PTR__RDL__WIDTH        32
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__CRD_CIS_PTR__RDL__MASK \
                    0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__CRD_CIS_PTR__RDL__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__CRD_CIS_PTR__TYPE       u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__CRD_CIS_PTR__READ     0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__CRD_CIS_PTR_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.CRD_CIS_PTR */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__CRD_CIS_PTR__NUM                         1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_0::Sub_VenID */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__SUB_VENID_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__SUB_VENID_MACRO__

/* macros for field Subsys_VenID */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__SUB_VENID__SUBSYS_VENID__SHIFT  0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__SUB_VENID__SUBSYS_VENID__WIDTH 16
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__SUB_VENID__SUBSYS_VENID__MASK \
                    0x0000ffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__SUB_VENID__SUBSYS_VENID__READ(src) \
                    (u_int32_t)(src)\
                    & 0x0000ffffU

/* macros for field SubsysID */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__SUB_VENID__SUBSYSID__SHIFT     16
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__SUB_VENID__SUBSYSID__WIDTH     16
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__SUB_VENID__SUBSYSID__MASK \
                    0xffff0000U
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__SUB_VENID__SUBSYSID__READ(src) \
                    (((u_int32_t)(src)\
                    & 0xffff0000U) >> 16)
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__SUB_VENID__TYPE         u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__SUB_VENID__READ       0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__SUB_VENID_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.Sub_VenID */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__SUB_VENID__NUM                           1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_0::EXP_ROM_ADDR */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__EXP_ROM_ADDR_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__EXP_ROM_ADDR_MACRO__

/* macros for field rdl */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__EXP_ROM_ADDR__RDL__SHIFT        0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__EXP_ROM_ADDR__RDL__WIDTH       32
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__EXP_ROM_ADDR__RDL__MASK \
                    0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__EXP_ROM_ADDR__RDL__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__EXP_ROM_ADDR__TYPE      u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__EXP_ROM_ADDR__READ    0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__EXP_ROM_ADDR_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.EXP_ROM_ADDR */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__EXP_ROM_ADDR__NUM                        1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_0::CAPPTR */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__CAPPTR_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__CAPPTR_MACRO__

/* macros for field Captr */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__CAPPTR__CAPTR__SHIFT            0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__CAPPTR__CAPTR__WIDTH            8
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__CAPPTR__CAPTR__MASK   0x000000ffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__CAPPTR__CAPTR__READ(src) \
                    (u_int32_t)(src)\
                    & 0x000000ffU

/* macros for field RESERVE1 */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__CAPPTR__RESERVE1__SHIFT         8
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__CAPPTR__RESERVE1__WIDTH        24
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__CAPPTR__RESERVE1__MASK \
                    0xffffff00U
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__CAPPTR__RESERVE1__READ(src) \
                    (((u_int32_t)(src)\
                    & 0xffffff00U) >> 8)
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__CAPPTR__TYPE            u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__CAPPTR__READ          0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__CAPPTR_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.CAPPTR */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__CAPPTR__NUM                              1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_0::RESERVE2 */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__RESERVE2_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__RESERVE2_MACRO__

/* macros for field rdl */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__RESERVE2__RDL__SHIFT            0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__RESERVE2__RDL__WIDTH           32
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__RESERVE2__RDL__MASK   0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__RESERVE2__RDL__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__RESERVE2__TYPE          u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__RESERVE2__READ        0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__RESERVE2_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.RESERVE2 */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__RESERVE2__NUM                            1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_0::LAT_INT */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__LAT_INT_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__LAT_INT_MACRO__

/* macros for field INT_LIN */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__LAT_INT__INT_LIN__SHIFT         0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__LAT_INT__INT_LIN__WIDTH         8
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__LAT_INT__INT_LIN__MASK \
                    0x000000ffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__LAT_INT__INT_LIN__READ(src) \
                    (u_int32_t)(src)\
                    & 0x000000ffU

/* macros for field INT_PIN */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__LAT_INT__INT_PIN__SHIFT         8
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__LAT_INT__INT_PIN__WIDTH         8
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__LAT_INT__INT_PIN__MASK \
                    0x0000ff00U
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__LAT_INT__INT_PIN__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0000ff00U) >> 8)

/* macros for field MIN_GRNT */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__LAT_INT__MIN_GRNT__SHIFT       16
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__LAT_INT__MIN_GRNT__WIDTH        8
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__LAT_INT__MIN_GRNT__MASK \
                    0x00ff0000U
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__LAT_INT__MIN_GRNT__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00ff0000U) >> 16)

/* macros for field MX_LAT */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__LAT_INT__MX_LAT__SHIFT         24
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__LAT_INT__MX_LAT__WIDTH          8
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__LAT_INT__MX_LAT__MASK 0xff000000U
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__LAT_INT__MX_LAT__READ(src) \
                    (((u_int32_t)(src)\
                    & 0xff000000U) >> 24)
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__LAT_INT__TYPE           u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__LAT_INT__READ         0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_0__LAT_INT_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.LAT_INT */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__LAT_INT__NUM                             1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_1::CFG_PWR_CAP */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_1__CFG_PWR_CAP_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_1__CFG_PWR_CAP_MACRO__

/* macros for field CAP_ID */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_1__CFG_PWR_CAP__CAP_ID__SHIFT      0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_1__CFG_PWR_CAP__CAP_ID__WIDTH      8
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_1__CFG_PWR_CAP__CAP_ID__MASK \
                    0x000000ffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_1__CFG_PWR_CAP__CAP_ID__READ(src) \
                    (u_int32_t)(src)\
                    & 0x000000ffU

/* macros for field PM_NX_PTR */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_1__CFG_PWR_CAP__PM_NX_PTR__SHIFT   8
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_1__CFG_PWR_CAP__PM_NX_PTR__WIDTH   8
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_1__CFG_PWR_CAP__PM_NX_PTR__MASK \
                    0x0000ff00U
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_1__CFG_PWR_CAP__PM_NX_PTR__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0000ff00U) >> 8)

/* macros for field PMC */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_1__CFG_PWR_CAP__PMC__SHIFT        16
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_1__CFG_PWR_CAP__PMC__WIDTH        16
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_1__CFG_PWR_CAP__PMC__MASK \
                    0xffff0000U
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_1__CFG_PWR_CAP__PMC__READ(src) \
                    (((u_int32_t)(src)\
                    & 0xffff0000U) >> 16)
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_1__CFG_PWR_CAP__TYPE       u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_1__CFG_PWR_CAP__READ     0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_1__CFG_PWR_CAP_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.CFG_PWR_CAP */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__CFG_PWR_CAP__NUM                         1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_1::PWR_CSR */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_1__PWR_CSR_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_1__PWR_CSR_MACRO__

/* macros for field PMCSR */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_1__PWR_CSR__PMCSR__SHIFT           0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_1__PWR_CSR__PMCSR__WIDTH          16
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_1__PWR_CSR__PMCSR__MASK  0x0000ffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_1__PWR_CSR__PMCSR__READ(src) \
                    (u_int32_t)(src)\
                    & 0x0000ffffU

/* macros for field PM_BSE */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_1__PWR_CSR__PM_BSE__SHIFT         16
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_1__PWR_CSR__PM_BSE__WIDTH          8
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_1__PWR_CSR__PM_BSE__MASK 0x00ff0000U
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_1__PWR_CSR__PM_BSE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00ff0000U) >> 16)

/* macros for field Data1 */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_1__PWR_CSR__DATA1__SHIFT          24
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_1__PWR_CSR__DATA1__WIDTH           8
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_1__PWR_CSR__DATA1__MASK  0xff000000U
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_1__PWR_CSR__DATA1__READ(src) \
                    (((u_int32_t)(src)\
                    & 0xff000000U) >> 24)
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_1__PWR_CSR__TYPE           u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_1__PWR_CSR__READ         0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_1__PWR_CSR_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.PWR_CSR */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__PWR_CSR__NUM                             1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_2::MSG_CTR */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_2__MSG_CTR_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_2__MSG_CTR_MACRO__

/* macros for field CAP_ID */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_2__MSG_CTR__CAP_ID__SHIFT          0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_2__MSG_CTR__CAP_ID__WIDTH          8
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_2__MSG_CTR__CAP_ID__MASK 0x000000ffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_2__MSG_CTR__CAP_ID__READ(src) \
                    (u_int32_t)(src)\
                    & 0x000000ffU

/* macros for field MSI_NX_PTR */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_2__MSG_CTR__MSI_NX_PTR__SHIFT      8
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_2__MSG_CTR__MSI_NX_PTR__WIDTH      8
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_2__MSG_CTR__MSI_NX_PTR__MASK \
                    0x0000ff00U
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_2__MSG_CTR__MSI_NX_PTR__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0000ff00U) >> 8)

/* macros for field MSG_CTR_RGS */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_2__MSG_CTR__MSG_CTR_RGS__SHIFT    16
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_2__MSG_CTR__MSG_CTR_RGS__WIDTH    16
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_2__MSG_CTR__MSG_CTR_RGS__MASK \
                    0xffff0000U
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_2__MSG_CTR__MSG_CTR_RGS__READ(src) \
                    (((u_int32_t)(src)\
                    & 0xffff0000U) >> 16)
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_2__MSG_CTR__TYPE           u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_2__MSG_CTR__READ         0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_2__MSG_CTR_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.MSG_CTR */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__MSG_CTR__NUM                             1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_2::MSI_L32 */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_2__MSI_L32_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_2__MSI_L32_MACRO__

/* macros for field rdl */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_2__MSI_L32__RDL__SHIFT             0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_2__MSI_L32__RDL__WIDTH            32
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_2__MSI_L32__RDL__MASK    0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_2__MSI_L32__RDL__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_2__MSI_L32__TYPE           u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_2__MSI_L32__READ         0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_2__MSI_L32_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.MSI_L32 */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__MSI_L32__NUM                             1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_2::MSI_U32 */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_2__MSI_U32_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_2__MSI_U32_MACRO__

/* macros for field rdl */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_2__MSI_U32__RDL__SHIFT             0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_2__MSI_U32__RDL__WIDTH            32
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_2__MSI_U32__RDL__MASK    0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_2__MSI_U32__RDL__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_2__MSI_U32__TYPE           u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_2__MSI_U32__READ         0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_2__MSI_U32_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.MSI_U32 */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__MSI_U32__NUM                             1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_2::MSI_DATA */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_2__MSI_DATA_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_2__MSI_DATA_MACRO__

/* macros for field MSI_DATA_F */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_2__MSI_DATA__MSI_DATA_F__SHIFT     0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_2__MSI_DATA__MSI_DATA_F__WIDTH    16
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_2__MSI_DATA__MSI_DATA_F__MASK \
                    0x0000ffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_2__MSI_DATA__MSI_DATA_F__READ(src) \
                    (u_int32_t)(src)\
                    & 0x0000ffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_2__MSI_DATA__TYPE          u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_2__MSI_DATA__READ        0x0000ffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_2__MSI_DATA_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.MSI_DATA */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__MSI_DATA__NUM                            1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_3::PCIE_CAP */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_3__PCIE_CAP_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_3__PCIE_CAP_MACRO__

/* macros for field CAP_ID */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_3__PCIE_CAP__CAP_ID__SHIFT         0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_3__PCIE_CAP__CAP_ID__WIDTH         8
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_3__PCIE_CAP__CAP_ID__MASK \
                    0x000000ffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_3__PCIE_CAP__CAP_ID__READ(src) \
                    (u_int32_t)(src)\
                    & 0x000000ffU

/* macros for field PCIE_NX_PTR */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_3__PCIE_CAP__PCIE_NX_PTR__SHIFT    8
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_3__PCIE_CAP__PCIE_NX_PTR__WIDTH    8
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_3__PCIE_CAP__PCIE_NX_PTR__MASK \
                    0x0000ff00U
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_3__PCIE_CAP__PCIE_NX_PTR__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0000ff00U) >> 8)

/* macros for field PCIE_CAP_R */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_3__PCIE_CAP__PCIE_CAP_R__SHIFT    16
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_3__PCIE_CAP__PCIE_CAP_R__WIDTH    16
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_3__PCIE_CAP__PCIE_CAP_R__MASK \
                    0xffff0000U
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_3__PCIE_CAP__PCIE_CAP_R__READ(src) \
                    (((u_int32_t)(src)\
                    & 0xffff0000U) >> 16)
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_3__PCIE_CAP__TYPE          u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_3__PCIE_CAP__READ        0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_3__PCIE_CAP_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.PCIE_CAP */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__PCIE_CAP__NUM                            1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_3::DEV_CAP */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_3__DEV_CAP_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_3__DEV_CAP_MACRO__

/* macros for field rdl */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_3__DEV_CAP__RDL__SHIFT             0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_3__DEV_CAP__RDL__WIDTH            32
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_3__DEV_CAP__RDL__MASK    0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_3__DEV_CAP__RDL__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_3__DEV_CAP__TYPE           u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_3__DEV_CAP__READ         0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_3__DEV_CAP_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.DEV_CAP */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__DEV_CAP__NUM                             1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_3::DEV_STS_CTRL */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_3__DEV_STS_CTRL_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_3__DEV_STS_CTRL_MACRO__

/* macros for field DEV_CTRL */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_3__DEV_STS_CTRL__DEV_CTRL__SHIFT   0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_3__DEV_STS_CTRL__DEV_CTRL__WIDTH  16
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_3__DEV_STS_CTRL__DEV_CTRL__MASK \
                    0x0000ffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_3__DEV_STS_CTRL__DEV_CTRL__READ(src) \
                    (u_int32_t)(src)\
                    & 0x0000ffffU

/* macros for field DEV_STS */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_3__DEV_STS_CTRL__DEV_STS__SHIFT   16
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_3__DEV_STS_CTRL__DEV_STS__WIDTH   16
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_3__DEV_STS_CTRL__DEV_STS__MASK \
                    0xffff0000U
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_3__DEV_STS_CTRL__DEV_STS__READ(src) \
                    (((u_int32_t)(src)\
                    & 0xffff0000U) >> 16)
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_3__DEV_STS_CTRL__TYPE      u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_3__DEV_STS_CTRL__READ    0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_3__DEV_STS_CTRL_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.DEV_STS_CTRL */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__DEV_STS_CTRL__NUM                        1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_3::LNK_CAP */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_3__LNK_CAP_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_3__LNK_CAP_MACRO__

/* macros for field rdl */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_3__LNK_CAP__RDL__SHIFT             0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_3__LNK_CAP__RDL__WIDTH            32
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_3__LNK_CAP__RDL__MASK    0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_3__LNK_CAP__RDL__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_3__LNK_CAP__TYPE           u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_3__LNK_CAP__READ         0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_3__LNK_CAP_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.LNK_CAP */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__LNK_CAP__NUM                             1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_3::LNK_STS_CTRL */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_3__LNK_STS_CTRL_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_3__LNK_STS_CTRL_MACRO__

/* macros for field LNK_CTRL */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_3__LNK_STS_CTRL__LNK_CTRL__SHIFT   0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_3__LNK_STS_CTRL__LNK_CTRL__WIDTH  16
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_3__LNK_STS_CTRL__LNK_CTRL__MASK \
                    0x0000ffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_3__LNK_STS_CTRL__LNK_CTRL__READ(src) \
                    (u_int32_t)(src)\
                    & 0x0000ffffU

/* macros for field LNK_STS */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_3__LNK_STS_CTRL__LNK_STS__SHIFT   16
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_3__LNK_STS_CTRL__LNK_STS__WIDTH   16
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_3__LNK_STS_CTRL__LNK_STS__MASK \
                    0xffff0000U
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_3__LNK_STS_CTRL__LNK_STS__READ(src) \
                    (((u_int32_t)(src)\
                    & 0xffff0000U) >> 16)
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_3__LNK_STS_CTRL__TYPE      u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_3__LNK_STS_CTRL__READ    0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_3__LNK_STS_CTRL_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.LNK_STS_CTRL */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__LNK_STS_CTRL__NUM                        1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_3::SLT_CAP */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_3__SLT_CAP_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_3__SLT_CAP_MACRO__

/* macros for field rdl */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_3__SLT_CAP__RDL__SHIFT             0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_3__SLT_CAP__RDL__WIDTH            32
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_3__SLT_CAP__RDL__MASK    0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_3__SLT_CAP__RDL__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_3__SLT_CAP__TYPE           u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_3__SLT_CAP__READ         0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_3__SLT_CAP_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.SLT_CAP */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__SLT_CAP__NUM                             1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_3::SLT_STS_CTRL */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_3__SLT_STS_CTRL_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_3__SLT_STS_CTRL_MACRO__

/* macros for field SLT_CTRL */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_3__SLT_STS_CTRL__SLT_CTRL__SHIFT   0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_3__SLT_STS_CTRL__SLT_CTRL__WIDTH  16
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_3__SLT_STS_CTRL__SLT_CTRL__MASK \
                    0x0000ffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_3__SLT_STS_CTRL__SLT_CTRL__READ(src) \
                    (u_int32_t)(src)\
                    & 0x0000ffffU

/* macros for field SLT_STS */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_3__SLT_STS_CTRL__SLT_STS__SHIFT   16
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_3__SLT_STS_CTRL__SLT_STS__WIDTH   16
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_3__SLT_STS_CTRL__SLT_STS__MASK \
                    0xffff0000U
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_3__SLT_STS_CTRL__SLT_STS__READ(src) \
                    (((u_int32_t)(src)\
                    & 0xffff0000U) >> 16)
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_3__SLT_STS_CTRL__TYPE      u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_3__SLT_STS_CTRL__READ    0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_3__SLT_STS_CTRL_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.SLT_STS_CTRL */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__SLT_STS_CTRL__NUM                        1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_5::VPD_CAP */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_5__VPD_CAP_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_5__VPD_CAP_MACRO__

/* macros for field rdl */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_5__VPD_CAP__RDL__SHIFT             0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_5__VPD_CAP__RDL__WIDTH            32
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_5__VPD_CAP__RDL__MASK    0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_5__VPD_CAP__RDL__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_5__VPD_CAP__TYPE           u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_5__VPD_CAP__READ         0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_5__VPD_CAP_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.VPD_CAP */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__VPD_CAP__NUM                             1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_5::VPD_DATA */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_5__VPD_DATA_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_5__VPD_DATA_MACRO__

/* macros for field rdl */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_5__VPD_DATA__RDL__SHIFT            0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_5__VPD_DATA__RDL__WIDTH           32
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_5__VPD_DATA__RDL__MASK   0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_5__VPD_DATA__RDL__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_5__VPD_DATA__TYPE          u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_5__VPD_DATA__READ        0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_5__VPD_DATA_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.VPD_DATA */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__VPD_DATA__NUM                            1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_6::PCIE_EN_CAP_AER */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_6__PCIE_EN_CAP_AER_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_6__PCIE_EN_CAP_AER_MACRO__

/* macros for field rdl */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_6__PCIE_EN_CAP_AER__RDL__SHIFT     0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_6__PCIE_EN_CAP_AER__RDL__WIDTH    32
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_6__PCIE_EN_CAP_AER__RDL__MASK \
                    0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_6__PCIE_EN_CAP_AER__RDL__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_6__PCIE_EN_CAP_AER__TYPE   u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_6__PCIE_EN_CAP_AER__READ 0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_6__PCIE_EN_CAP_AER_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.PCIE_EN_CAP_AER */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__PCIE_EN_CAP_AER__NUM                     1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_6::UN_ERR_ST_R */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_6__UN_ERR_ST_R_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_6__UN_ERR_ST_R_MACRO__

/* macros for field rdl */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_6__UN_ERR_ST_R__RDL__SHIFT         0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_6__UN_ERR_ST_R__RDL__WIDTH        32
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_6__UN_ERR_ST_R__RDL__MASK \
                    0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_6__UN_ERR_ST_R__RDL__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_6__UN_ERR_ST_R__TYPE       u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_6__UN_ERR_ST_R__READ     0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_6__UN_ERR_ST_R_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.UN_ERR_ST_R */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__UN_ERR_ST_R__NUM                         1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_6::UN_ERR_MS_R */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_6__UN_ERR_MS_R_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_6__UN_ERR_MS_R_MACRO__

/* macros for field rdl */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_6__UN_ERR_MS_R__RDL__SHIFT         0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_6__UN_ERR_MS_R__RDL__WIDTH        32
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_6__UN_ERR_MS_R__RDL__MASK \
                    0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_6__UN_ERR_MS_R__RDL__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_6__UN_ERR_MS_R__TYPE       u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_6__UN_ERR_MS_R__READ     0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_6__UN_ERR_MS_R_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.UN_ERR_MS_R */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__UN_ERR_MS_R__NUM                         1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_6::UN_ERR_SV_R */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_6__UN_ERR_SV_R_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_6__UN_ERR_SV_R_MACRO__

/* macros for field rdl */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_6__UN_ERR_SV_R__RDL__SHIFT         0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_6__UN_ERR_SV_R__RDL__WIDTH        32
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_6__UN_ERR_SV_R__RDL__MASK \
                    0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_6__UN_ERR_SV_R__RDL__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_6__UN_ERR_SV_R__TYPE       u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_6__UN_ERR_SV_R__READ     0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_6__UN_ERR_SV_R_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.UN_ERR_SV_R */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__UN_ERR_SV_R__NUM                         1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_6::CO_ERR_ST_R */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_6__CO_ERR_ST_R_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_6__CO_ERR_ST_R_MACRO__

/* macros for field rdl */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_6__CO_ERR_ST_R__RDL__SHIFT         0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_6__CO_ERR_ST_R__RDL__WIDTH        32
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_6__CO_ERR_ST_R__RDL__MASK \
                    0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_6__CO_ERR_ST_R__RDL__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_6__CO_ERR_ST_R__TYPE       u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_6__CO_ERR_ST_R__READ     0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_6__CO_ERR_ST_R_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.CO_ERR_ST_R */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__CO_ERR_ST_R__NUM                         1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_6::CO_ERR_MS_R */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_6__CO_ERR_MS_R_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_6__CO_ERR_MS_R_MACRO__

/* macros for field rdl */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_6__CO_ERR_MS_R__RDL__SHIFT         0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_6__CO_ERR_MS_R__RDL__WIDTH        32
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_6__CO_ERR_MS_R__RDL__MASK \
                    0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_6__CO_ERR_MS_R__RDL__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_6__CO_ERR_MS_R__TYPE       u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_6__CO_ERR_MS_R__READ     0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_6__CO_ERR_MS_R_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.CO_ERR_MS_R */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__CO_ERR_MS_R__NUM                         1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_6::ADERR_CAP_CR */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_6__ADERR_CAP_CR_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_6__ADERR_CAP_CR_MACRO__

/* macros for field rdl */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_6__ADERR_CAP_CR__RDL__SHIFT        0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_6__ADERR_CAP_CR__RDL__WIDTH       32
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_6__ADERR_CAP_CR__RDL__MASK \
                    0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_6__ADERR_CAP_CR__RDL__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_6__ADERR_CAP_CR__TYPE      u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_6__ADERR_CAP_CR__READ    0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_6__ADERR_CAP_CR_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.ADERR_CAP_CR */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__ADERR_CAP_CR__NUM                        1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_6::HD_L_R0 */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_6__HD_L_R0_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_6__HD_L_R0_MACRO__

/* macros for field rdl */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_6__HD_L_R0__RDL__SHIFT             0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_6__HD_L_R0__RDL__WIDTH            32
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_6__HD_L_R0__RDL__MASK    0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_6__HD_L_R0__RDL__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_6__HD_L_R0__TYPE           u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_6__HD_L_R0__READ         0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_6__HD_L_R0_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.HD_L_R0 */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__HD_L_R0__NUM                             1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_6::HD_L_R4 */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_6__HD_L_R4_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_6__HD_L_R4_MACRO__

/* macros for field rdl */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_6__HD_L_R4__RDL__SHIFT             0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_6__HD_L_R4__RDL__WIDTH            32
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_6__HD_L_R4__RDL__MASK    0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_6__HD_L_R4__RDL__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_6__HD_L_R4__TYPE           u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_6__HD_L_R4__READ         0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_6__HD_L_R4_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.HD_L_R4 */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__HD_L_R4__NUM                             1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_6::HD_L_R8 */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_6__HD_L_R8_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_6__HD_L_R8_MACRO__

/* macros for field rdl */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_6__HD_L_R8__RDL__SHIFT             0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_6__HD_L_R8__RDL__WIDTH            32
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_6__HD_L_R8__RDL__MASK    0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_6__HD_L_R8__RDL__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_6__HD_L_R8__TYPE           u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_6__HD_L_R8__READ         0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_6__HD_L_R8_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.HD_L_R8 */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__HD_L_R8__NUM                             1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_6::HD_L_R12 */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_6__HD_L_R12_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_6__HD_L_R12_MACRO__

/* macros for field rdl */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_6__HD_L_R12__RDL__SHIFT            0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_6__HD_L_R12__RDL__WIDTH           32
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_6__HD_L_R12__RDL__MASK   0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_6__HD_L_R12__RDL__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_6__HD_L_R12__TYPE          u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_6__HD_L_R12__READ        0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_6__HD_L_R12_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.HD_L_R12 */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__HD_L_R12__NUM                            1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_7::PCIE_EN_CAP_VC */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_7__PCIE_EN_CAP_VC_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_7__PCIE_EN_CAP_VC_MACRO__

/* macros for field rdl */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_7__PCIE_EN_CAP_VC__RDL__SHIFT      0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_7__PCIE_EN_CAP_VC__RDL__WIDTH     32
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_7__PCIE_EN_CAP_VC__RDL__MASK \
                    0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_7__PCIE_EN_CAP_VC__RDL__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_7__PCIE_EN_CAP_VC__TYPE    u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_7__PCIE_EN_CAP_VC__READ  0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_7__PCIE_EN_CAP_VC_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.PCIE_EN_CAP_VC */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__PCIE_EN_CAP_VC__NUM                      1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_7::PVC_CAP_R1 */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_7__PVC_CAP_R1_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_7__PVC_CAP_R1_MACRO__

/* macros for field rdl */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_7__PVC_CAP_R1__RDL__SHIFT          0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_7__PVC_CAP_R1__RDL__WIDTH         32
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_7__PVC_CAP_R1__RDL__MASK 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_7__PVC_CAP_R1__RDL__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_7__PVC_CAP_R1__TYPE        u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_7__PVC_CAP_R1__READ      0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_7__PVC_CAP_R1_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.PVC_CAP_R1 */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__PVC_CAP_R1__NUM                          1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_7::P_CAP_R2 */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_7__P_CAP_R2_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_7__P_CAP_R2_MACRO__

/* macros for field rdl */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_7__P_CAP_R2__RDL__SHIFT            0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_7__P_CAP_R2__RDL__WIDTH           32
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_7__P_CAP_R2__RDL__MASK   0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_7__P_CAP_R2__RDL__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_7__P_CAP_R2__TYPE          u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_7__P_CAP_R2__READ        0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_7__P_CAP_R2_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.P_CAP_R2 */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__P_CAP_R2__NUM                            1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_7::PVC_STS_CTRL */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_7__PVC_STS_CTRL_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_7__PVC_STS_CTRL_MACRO__

/* macros for field PVC_CTRL */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_7__PVC_STS_CTRL__PVC_CTRL__SHIFT   0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_7__PVC_STS_CTRL__PVC_CTRL__WIDTH  16
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_7__PVC_STS_CTRL__PVC_CTRL__MASK \
                    0x0000ffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_7__PVC_STS_CTRL__PVC_CTRL__READ(src) \
                    (u_int32_t)(src)\
                    & 0x0000ffffU

/* macros for field PVC_STS */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_7__PVC_STS_CTRL__PVC_STS__SHIFT   16
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_7__PVC_STS_CTRL__PVC_STS__WIDTH   16
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_7__PVC_STS_CTRL__PVC_STS__MASK \
                    0xffff0000U
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_7__PVC_STS_CTRL__PVC_STS__READ(src) \
                    (((u_int32_t)(src)\
                    & 0xffff0000U) >> 16)
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_7__PVC_STS_CTRL__TYPE      u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_7__PVC_STS_CTRL__READ    0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_7__PVC_STS_CTRL_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.PVC_STS_CTRL */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__PVC_STS_CTRL__NUM                        1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_7::VC_CAP_R */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_7__VC_CAP_R_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_7__VC_CAP_R_MACRO__

/* macros for field rdl */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_7__VC_CAP_R__RDL__SHIFT            0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_7__VC_CAP_R__RDL__WIDTH           32
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_7__VC_CAP_R__RDL__MASK   0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_7__VC_CAP_R__RDL__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_7__VC_CAP_R__TYPE          u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_7__VC_CAP_R__READ        0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_7__VC_CAP_R_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.VC_CAP_R */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__VC_CAP_R__NUM                            1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_7::VC_CTL_R */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_7__VC_CTL_R_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_7__VC_CTL_R_MACRO__

/* macros for field rdl */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_7__VC_CTL_R__RDL__SHIFT            0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_7__VC_CTL_R__RDL__WIDTH           32
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_7__VC_CTL_R__RDL__MASK   0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_7__VC_CTL_R__RDL__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_7__VC_CTL_R__TYPE          u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_7__VC_CTL_R__READ        0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_7__VC_CTL_R_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.VC_CTL_R */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__VC_CTL_R__NUM                            1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_7::VC_STS_RSV */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_7__VC_STS_RSV_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_7__VC_STS_RSV_MACRO__

/* macros for field RSVDP */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_7__VC_STS_RSV__RSVDP__SHIFT        0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_7__VC_STS_RSV__RSVDP__WIDTH       16
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_7__VC_STS_RSV__RSVDP__MASK \
                    0x0000ffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_7__VC_STS_RSV__RSVDP__READ(src) \
                    (u_int32_t)(src)\
                    & 0x0000ffffU

/* macros for field VC_STS */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_7__VC_STS_RSV__VC_STS__SHIFT      16
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_7__VC_STS_RSV__VC_STS__WIDTH      16
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_7__VC_STS_RSV__VC_STS__MASK \
                    0xffff0000U
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_7__VC_STS_RSV__VC_STS__READ(src) \
                    (((u_int32_t)(src)\
                    & 0xffff0000U) >> 16)
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_7__VC_STS_RSV__TYPE        u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_7__VC_STS_RSV__READ      0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_7__VC_STS_RSV_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.VC_STS_RSV */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__VC_STS_RSV__NUM                          1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_7::VCR_CAP_R1 */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_7__VCR_CAP_R1_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_7__VCR_CAP_R1_MACRO__

/* macros for field rdl */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_7__VCR_CAP_R1__RDL__SHIFT          0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_7__VCR_CAP_R1__RDL__WIDTH         32
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_7__VCR_CAP_R1__RDL__MASK 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_7__VCR_CAP_R1__RDL__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_7__VCR_CAP_R1__TYPE        u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_7__VCR_CAP_R1__READ      0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_7__VCR_CAP_R1_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.VCR_CAP_R1 */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__VCR_CAP_R1__NUM                          1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_7::VCR_CTRL_R1 */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_7__VCR_CTRL_R1_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_7__VCR_CTRL_R1_MACRO__

/* macros for field rdl */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_7__VCR_CTRL_R1__RDL__SHIFT         0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_7__VCR_CTRL_R1__RDL__WIDTH        32
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_7__VCR_CTRL_R1__RDL__MASK \
                    0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_7__VCR_CTRL_R1__RDL__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_7__VCR_CTRL_R1__TYPE       u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_7__VCR_CTRL_R1__READ     0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_7__VCR_CTRL_R1_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.VCR_CTRL_R1 */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__VCR_CTRL_R1__NUM                         1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_7::VCR_STS_R1 */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_7__VCR_STS_R1_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_7__VCR_STS_R1_MACRO__

/* macros for field RSVDP1 */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_7__VCR_STS_R1__RSVDP1__SHIFT       0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_7__VCR_STS_R1__RSVDP1__WIDTH      16
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_7__VCR_STS_R1__RSVDP1__MASK \
                    0x0000ffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_7__VCR_STS_R1__RSVDP1__READ(src) \
                    (u_int32_t)(src)\
                    & 0x0000ffffU

/* macros for field VC_STS1 */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_7__VCR_STS_R1__VC_STS1__SHIFT     16
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_7__VCR_STS_R1__VC_STS1__WIDTH     16
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_7__VCR_STS_R1__VC_STS1__MASK \
                    0xffff0000U
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_7__VCR_STS_R1__VC_STS1__READ(src) \
                    (((u_int32_t)(src)\
                    & 0xffff0000U) >> 16)
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_7__VCR_STS_R1__TYPE        u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_7__VCR_STS_R1__READ      0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_7__VCR_STS_R1_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.VCR_STS_R1 */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__VCR_STS_R1__NUM                          1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_8::DEV_EN_CAP */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_8__DEV_EN_CAP_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_8__DEV_EN_CAP_MACRO__

/* macros for field rdl */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_8__DEV_EN_CAP__RDL__SHIFT          0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_8__DEV_EN_CAP__RDL__WIDTH         32
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_8__DEV_EN_CAP__RDL__MASK 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_8__DEV_EN_CAP__RDL__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_8__DEV_EN_CAP__TYPE        u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_8__DEV_EN_CAP__READ      0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_8__DEV_EN_CAP_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.DEV_EN_CAP */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__DEV_EN_CAP__NUM                          1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_8::SN_R1 */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_8__SN_R1_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_8__SN_R1_MACRO__

/* macros for field rdl */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_8__SN_R1__RDL__SHIFT               0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_8__SN_R1__RDL__WIDTH              32
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_8__SN_R1__RDL__MASK      0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_8__SN_R1__RDL__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_8__SN_R1__TYPE             u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_8__SN_R1__READ           0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_8__SN_R1_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.SN_R1 */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__SN_R1__NUM                               1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_8::SN_R2 */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_8__SN_R2_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_8__SN_R2_MACRO__

/* macros for field rdl */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_8__SN_R2__RDL__SHIFT               0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_8__SN_R2__RDL__WIDTH              32
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_8__SN_R2__RDL__MASK      0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_8__SN_R2__RDL__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_8__SN_R2__TYPE             u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_8__SN_R2__READ           0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_8__SN_R2_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.SN_R2 */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__SN_R2__NUM                               1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_9::LAT_REL_TIM */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__LAT_REL_TIM_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__LAT_REL_TIM_MACRO__

/* macros for field rdl */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__LAT_REL_TIM__RDL__SHIFT         0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__LAT_REL_TIM__RDL__WIDTH        32
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__LAT_REL_TIM__RDL__MASK \
                    0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__LAT_REL_TIM__RDL__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__LAT_REL_TIM__RDL__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0xffffffffU)
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__LAT_REL_TIM__RDL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xffffffffU) | ((u_int32_t)(src) &\
                    0xffffffffU)
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__LAT_REL_TIM__RDL__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0xffffffffU)))
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__LAT_REL_TIM__TYPE       u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__LAT_REL_TIM__READ     0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__LAT_REL_TIM__WRITE    0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__LAT_REL_TIM_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.LAT_REL_TIM */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__LAT_REL_TIM__NUM                         1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_9::OT_MSG_R */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__OT_MSG_R_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__OT_MSG_R_MACRO__

/* macros for field rdl */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__OT_MSG_R__RDL__SHIFT            0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__OT_MSG_R__RDL__WIDTH           32
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__OT_MSG_R__RDL__MASK   0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__OT_MSG_R__RDL__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__OT_MSG_R__RDL__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0xffffffffU)
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__OT_MSG_R__RDL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xffffffffU) | ((u_int32_t)(src) &\
                    0xffffffffU)
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__OT_MSG_R__RDL__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0xffffffffU)))
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__OT_MSG_R__TYPE          u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__OT_MSG_R__READ        0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__OT_MSG_R__WRITE       0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__OT_MSG_R_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.OT_MSG_R */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__OT_MSG_R__NUM                            1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_9::PT_LNK_R */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__PT_LNK_R_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__PT_LNK_R_MACRO__

/* macros for field rdl */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__PT_LNK_R__RDL__SHIFT            0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__PT_LNK_R__RDL__WIDTH           32
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__PT_LNK_R__RDL__MASK   0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__PT_LNK_R__RDL__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__PT_LNK_R__RDL__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0xffffffffU)
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__PT_LNK_R__RDL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xffffffffU) | ((u_int32_t)(src) &\
                    0xffffffffU)
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__PT_LNK_R__RDL__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0xffffffffU)))
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__PT_LNK_R__TYPE          u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__PT_LNK_R__READ        0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__PT_LNK_R__WRITE       0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__PT_LNK_R_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.PT_LNK_R */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__PT_LNK_R__NUM                            1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_9::ACk_FREQ_R */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__ACK_FREQ_R_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__ACK_FREQ_R_MACRO__

/* macros for field rdl */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__ACK_FREQ_R__RDL__SHIFT          0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__ACK_FREQ_R__RDL__WIDTH         32
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__ACK_FREQ_R__RDL__MASK 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__ACK_FREQ_R__RDL__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__ACK_FREQ_R__RDL__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0xffffffffU)
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__ACK_FREQ_R__RDL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xffffffffU) | ((u_int32_t)(src) &\
                    0xffffffffU)
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__ACK_FREQ_R__RDL__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0xffffffffU)))
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__ACK_FREQ_R__TYPE        u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__ACK_FREQ_R__READ      0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__ACK_FREQ_R__WRITE     0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__ACK_FREQ_R_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.ACk_FREQ_R */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__ACK_FREQ_R__NUM                          1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_9::PT_LNK_CTRL_R */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__PT_LNK_CTRL_R_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__PT_LNK_CTRL_R_MACRO__

/* macros for field rdl */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__PT_LNK_CTRL_R__RDL__SHIFT       0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__PT_LNK_CTRL_R__RDL__WIDTH      32
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__PT_LNK_CTRL_R__RDL__MASK \
                    0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__PT_LNK_CTRL_R__RDL__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__PT_LNK_CTRL_R__RDL__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0xffffffffU)
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__PT_LNK_CTRL_R__RDL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xffffffffU) | ((u_int32_t)(src) &\
                    0xffffffffU)
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__PT_LNK_CTRL_R__RDL__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0xffffffffU)))
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__PT_LNK_CTRL_R__TYPE     u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__PT_LNK_CTRL_R__READ   0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__PT_LNK_CTRL_R__WRITE  0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__PT_LNK_CTRL_R_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.PT_LNK_CTRL_R */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__PT_LNK_CTRL_R__NUM                       1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_9::LN_SKW_R */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__LN_SKW_R_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__LN_SKW_R_MACRO__

/* macros for field rdl */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__LN_SKW_R__RDL__SHIFT            0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__LN_SKW_R__RDL__WIDTH           32
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__LN_SKW_R__RDL__MASK   0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__LN_SKW_R__RDL__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__LN_SKW_R__RDL__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0xffffffffU)
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__LN_SKW_R__RDL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xffffffffU) | ((u_int32_t)(src) &\
                    0xffffffffU)
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__LN_SKW_R__RDL__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0xffffffffU)))
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__LN_SKW_R__TYPE          u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__LN_SKW_R__READ        0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__LN_SKW_R__WRITE       0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__LN_SKW_R_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.LN_SKW_R */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__LN_SKW_R__NUM                            1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_9::SYMB_N_R */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__SYMB_N_R_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__SYMB_N_R_MACRO__

/* macros for field rdl */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__SYMB_N_R__RDL__SHIFT            0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__SYMB_N_R__RDL__WIDTH           32
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__SYMB_N_R__RDL__MASK   0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__SYMB_N_R__RDL__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__SYMB_N_R__RDL__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0xffffffffU)
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__SYMB_N_R__RDL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xffffffffU) | ((u_int32_t)(src) &\
                    0xffffffffU)
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__SYMB_N_R__RDL__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0xffffffffU)))
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__SYMB_N_R__TYPE          u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__SYMB_N_R__READ        0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__SYMB_N_R__WRITE       0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__SYMB_N_R_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.SYMB_N_R */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__SYMB_N_R__NUM                            1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_9::SYMB_T_R */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__SYMB_T_R_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__SYMB_T_R_MACRO__

/* macros for field rdl */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__SYMB_T_R__RDL__SHIFT            0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__SYMB_T_R__RDL__WIDTH           32
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__SYMB_T_R__RDL__MASK   0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__SYMB_T_R__RDL__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__SYMB_T_R__RDL__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0xffffffffU)
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__SYMB_T_R__RDL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xffffffffU) | ((u_int32_t)(src) &\
                    0xffffffffU)
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__SYMB_T_R__RDL__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0xffffffffU)))
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__SYMB_T_R__TYPE          u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__SYMB_T_R__READ        0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__SYMB_T_R__WRITE       0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__SYMB_T_R_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.SYMB_T_R */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__SYMB_T_R__NUM                            1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_9::FL_MSK_R2 */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__FL_MSK_R2_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__FL_MSK_R2_MACRO__

/* macros for field rdl */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__FL_MSK_R2__RDL__SHIFT           0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__FL_MSK_R2__RDL__WIDTH          32
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__FL_MSK_R2__RDL__MASK  0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__FL_MSK_R2__RDL__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__FL_MSK_R2__RDL__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0xffffffffU)
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__FL_MSK_R2__RDL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xffffffffU) | ((u_int32_t)(src) &\
                    0xffffffffU)
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__FL_MSK_R2__RDL__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0xffffffffU)))
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__FL_MSK_R2__TYPE         u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__FL_MSK_R2__READ       0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__FL_MSK_R2__WRITE      0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__FL_MSK_R2_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.FL_MSK_R2 */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__FL_MSK_R2__NUM                           1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_9::DB_R0 */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__DB_R0_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__DB_R0_MACRO__

/* macros for field rdl */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__DB_R0__RDL__SHIFT               0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__DB_R0__RDL__WIDTH              32
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__DB_R0__RDL__MASK      0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__DB_R0__RDL__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__DB_R0__TYPE             u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__DB_R0__READ           0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__DB_R0_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.DB_R0 */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__DB_R0__NUM                               1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_9::DB_R1 */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__DB_R1_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__DB_R1_MACRO__

/* macros for field rdl */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__DB_R1__RDL__SHIFT               0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__DB_R1__RDL__WIDTH              32
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__DB_R1__RDL__MASK      0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__DB_R1__RDL__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__DB_R1__TYPE             u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__DB_R1__READ           0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__DB_R1_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.DB_R1 */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__DB_R1__NUM                               1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_9::TR_P_STS_R */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__TR_P_STS_R_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__TR_P_STS_R_MACRO__

/* macros for field rdl */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__TR_P_STS_R__RDL__SHIFT          0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__TR_P_STS_R__RDL__WIDTH         32
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__TR_P_STS_R__RDL__MASK 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__TR_P_STS_R__RDL__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__TR_P_STS_R__TYPE        u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__TR_P_STS_R__READ      0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__TR_P_STS_R_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.TR_P_STS_R */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__TR_P_STS_R__NUM                          1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_9::TR_NP_STS_R */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__TR_NP_STS_R_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__TR_NP_STS_R_MACRO__

/* macros for field rdl */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__TR_NP_STS_R__RDL__SHIFT         0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__TR_NP_STS_R__RDL__WIDTH        32
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__TR_NP_STS_R__RDL__MASK \
                    0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__TR_NP_STS_R__RDL__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__TR_NP_STS_R__TYPE       u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__TR_NP_STS_R__READ     0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__TR_NP_STS_R_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.TR_NP_STS_R */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__TR_NP_STS_R__NUM                         1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_9::TR_C_STS_R */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__TR_C_STS_R_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__TR_C_STS_R_MACRO__

/* macros for field rdl */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__TR_C_STS_R__RDL__SHIFT          0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__TR_C_STS_R__RDL__WIDTH         32
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__TR_C_STS_R__RDL__MASK 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__TR_C_STS_R__RDL__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__TR_C_STS_R__TYPE        u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__TR_C_STS_R__READ      0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__TR_C_STS_R_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.TR_C_STS_R */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__TR_C_STS_R__NUM                          1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_9::Q_STS_R */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__Q_STS_R_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__Q_STS_R_MACRO__

/* macros for field rdl */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__Q_STS_R__RDL__SHIFT             0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__Q_STS_R__RDL__WIDTH            32
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__Q_STS_R__RDL__MASK    0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__Q_STS_R__RDL__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__Q_STS_R__TYPE           u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__Q_STS_R__READ         0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__Q_STS_R_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.Q_STS_R */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__Q_STS_R__NUM                             1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_9::VC_TR_A_R1 */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC_TR_A_R1_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC_TR_A_R1_MACRO__

/* macros for field rdl */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC_TR_A_R1__RDL__SHIFT          0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC_TR_A_R1__RDL__WIDTH         32
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC_TR_A_R1__RDL__MASK 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC_TR_A_R1__RDL__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC_TR_A_R1__RDL__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0xffffffffU)
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC_TR_A_R1__RDL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xffffffffU) | ((u_int32_t)(src) &\
                    0xffffffffU)
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC_TR_A_R1__RDL__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0xffffffffU)))
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC_TR_A_R1__TYPE        u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC_TR_A_R1__READ      0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC_TR_A_R1__WRITE     0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC_TR_A_R1_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.VC_TR_A_R1 */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__VC_TR_A_R1__NUM                          1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_9::VC_TR_A_R2 */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC_TR_A_R2_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC_TR_A_R2_MACRO__

/* macros for field rdl */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC_TR_A_R2__RDL__SHIFT          0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC_TR_A_R2__RDL__WIDTH         32
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC_TR_A_R2__RDL__MASK 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC_TR_A_R2__RDL__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC_TR_A_R2__RDL__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0xffffffffU)
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC_TR_A_R2__RDL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xffffffffU) | ((u_int32_t)(src) &\
                    0xffffffffU)
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC_TR_A_R2__RDL__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0xffffffffU)))
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC_TR_A_R2__TYPE        u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC_TR_A_R2__READ      0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC_TR_A_R2__WRITE     0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC_TR_A_R2_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.VC_TR_A_R2 */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__VC_TR_A_R2__NUM                          1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_9::VC0_PR_Q_C */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC0_PR_Q_C_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC0_PR_Q_C_MACRO__

/* macros for field rdl */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC0_PR_Q_C__RDL__SHIFT          0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC0_PR_Q_C__RDL__WIDTH         32
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC0_PR_Q_C__RDL__MASK 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC0_PR_Q_C__RDL__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC0_PR_Q_C__TYPE        u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC0_PR_Q_C__READ      0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC0_PR_Q_C_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.VC0_PR_Q_C */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__VC0_PR_Q_C__NUM                          1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_9::VC0_NPR_Q_C */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC0_NPR_Q_C_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC0_NPR_Q_C_MACRO__

/* macros for field rdl */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC0_NPR_Q_C__RDL__SHIFT         0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC0_NPR_Q_C__RDL__WIDTH        32
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC0_NPR_Q_C__RDL__MASK \
                    0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC0_NPR_Q_C__RDL__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC0_NPR_Q_C__TYPE       u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC0_NPR_Q_C__READ     0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC0_NPR_Q_C_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.VC0_NPR_Q_C */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__VC0_NPR_Q_C__NUM                         1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_9::VC0_CR_Q_C */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC0_CR_Q_C_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC0_CR_Q_C_MACRO__

/* macros for field rdl */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC0_CR_Q_C__RDL__SHIFT          0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC0_CR_Q_C__RDL__WIDTH         32
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC0_CR_Q_C__RDL__MASK 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC0_CR_Q_C__RDL__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC0_CR_Q_C__TYPE        u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC0_CR_Q_C__READ      0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC0_CR_Q_C_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.VC0_CR_Q_C */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__VC0_CR_Q_C__NUM                          1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_9::VC1_PR_Q_C */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC1_PR_Q_C_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC1_PR_Q_C_MACRO__

/* macros for field rdl */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC1_PR_Q_C__RDL__SHIFT          0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC1_PR_Q_C__RDL__WIDTH         32
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC1_PR_Q_C__RDL__MASK 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC1_PR_Q_C__RDL__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC1_PR_Q_C__TYPE        u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC1_PR_Q_C__READ      0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC1_PR_Q_C_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.VC1_PR_Q_C */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__VC1_PR_Q_C__NUM                          1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_9::VC1_NPR_Q_C */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC1_NPR_Q_C_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC1_NPR_Q_C_MACRO__

/* macros for field rdl */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC1_NPR_Q_C__RDL__SHIFT         0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC1_NPR_Q_C__RDL__WIDTH        32
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC1_NPR_Q_C__RDL__MASK \
                    0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC1_NPR_Q_C__RDL__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC1_NPR_Q_C__TYPE       u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC1_NPR_Q_C__READ     0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC1_NPR_Q_C_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.VC1_NPR_Q_C */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__VC1_NPR_Q_C__NUM                         1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_9::VC1_CR_Q_C */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC1_CR_Q_C_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC1_CR_Q_C_MACRO__

/* macros for field rdl */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC1_CR_Q_C__RDL__SHIFT          0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC1_CR_Q_C__RDL__WIDTH         32
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC1_CR_Q_C__RDL__MASK 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC1_CR_Q_C__RDL__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC1_CR_Q_C__TYPE        u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC1_CR_Q_C__READ      0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC1_CR_Q_C_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.VC1_CR_Q_C */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__VC1_CR_Q_C__NUM                          1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_9::VC2_PR_Q_C */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC2_PR_Q_C_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC2_PR_Q_C_MACRO__

/* macros for field rdl */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC2_PR_Q_C__RDL__SHIFT          0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC2_PR_Q_C__RDL__WIDTH         32
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC2_PR_Q_C__RDL__MASK 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC2_PR_Q_C__RDL__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC2_PR_Q_C__TYPE        u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC2_PR_Q_C__READ      0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC2_PR_Q_C_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.VC2_PR_Q_C */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__VC2_PR_Q_C__NUM                          1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_9::VC2_NPR_Q_C */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC2_NPR_Q_C_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC2_NPR_Q_C_MACRO__

/* macros for field rdl */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC2_NPR_Q_C__RDL__SHIFT         0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC2_NPR_Q_C__RDL__WIDTH        32
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC2_NPR_Q_C__RDL__MASK \
                    0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC2_NPR_Q_C__RDL__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC2_NPR_Q_C__TYPE       u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC2_NPR_Q_C__READ     0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC2_NPR_Q_C_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.VC2_NPR_Q_C */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__VC2_NPR_Q_C__NUM                         1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_9::VC2_CR_Q_C */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC2_CR_Q_C_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC2_CR_Q_C_MACRO__

/* macros for field rdl */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC2_CR_Q_C__RDL__SHIFT          0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC2_CR_Q_C__RDL__WIDTH         32
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC2_CR_Q_C__RDL__MASK 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC2_CR_Q_C__RDL__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC2_CR_Q_C__TYPE        u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC2_CR_Q_C__READ      0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC2_CR_Q_C_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.VC2_CR_Q_C */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__VC2_CR_Q_C__NUM                          1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_9::VC3_PR_Q_C */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC3_PR_Q_C_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC3_PR_Q_C_MACRO__

/* macros for field rdl */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC3_PR_Q_C__RDL__SHIFT          0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC3_PR_Q_C__RDL__WIDTH         32
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC3_PR_Q_C__RDL__MASK 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC3_PR_Q_C__RDL__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC3_PR_Q_C__TYPE        u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC3_PR_Q_C__READ      0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC3_PR_Q_C_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.VC3_PR_Q_C */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__VC3_PR_Q_C__NUM                          1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_9::VC3_NPR_Q_C */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC3_NPR_Q_C_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC3_NPR_Q_C_MACRO__

/* macros for field rdl */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC3_NPR_Q_C__RDL__SHIFT         0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC3_NPR_Q_C__RDL__WIDTH        32
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC3_NPR_Q_C__RDL__MASK \
                    0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC3_NPR_Q_C__RDL__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC3_NPR_Q_C__TYPE       u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC3_NPR_Q_C__READ     0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC3_NPR_Q_C_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.VC3_NPR_Q_C */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__VC3_NPR_Q_C__NUM                         1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_9::VC3_CR_Q_C */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC3_CR_Q_C_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC3_CR_Q_C_MACRO__

/* macros for field rdl */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC3_CR_Q_C__RDL__SHIFT          0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC3_CR_Q_C__RDL__WIDTH         32
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC3_CR_Q_C__RDL__MASK 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC3_CR_Q_C__RDL__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC3_CR_Q_C__TYPE        u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC3_CR_Q_C__READ      0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC3_CR_Q_C_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.VC3_CR_Q_C */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__VC3_CR_Q_C__NUM                          1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_9::VC4_PR_Q_C */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC4_PR_Q_C_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC4_PR_Q_C_MACRO__

/* macros for field rdl */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC4_PR_Q_C__RDL__SHIFT          0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC4_PR_Q_C__RDL__WIDTH         32
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC4_PR_Q_C__RDL__MASK 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC4_PR_Q_C__RDL__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC4_PR_Q_C__TYPE        u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC4_PR_Q_C__READ      0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC4_PR_Q_C_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.VC4_PR_Q_C */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__VC4_PR_Q_C__NUM                          1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_9::VC4_NPR_Q_C */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC4_NPR_Q_C_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC4_NPR_Q_C_MACRO__

/* macros for field rdl */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC4_NPR_Q_C__RDL__SHIFT         0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC4_NPR_Q_C__RDL__WIDTH        32
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC4_NPR_Q_C__RDL__MASK \
                    0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC4_NPR_Q_C__RDL__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC4_NPR_Q_C__TYPE       u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC4_NPR_Q_C__READ     0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC4_NPR_Q_C_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.VC4_NPR_Q_C */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__VC4_NPR_Q_C__NUM                         1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_9::VC4_CR_Q_C */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC4_CR_Q_C_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC4_CR_Q_C_MACRO__

/* macros for field rdl */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC4_CR_Q_C__RDL__SHIFT          0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC4_CR_Q_C__RDL__WIDTH         32
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC4_CR_Q_C__RDL__MASK 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC4_CR_Q_C__RDL__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC4_CR_Q_C__TYPE        u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC4_CR_Q_C__READ      0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC4_CR_Q_C_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.VC4_CR_Q_C */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__VC4_CR_Q_C__NUM                          1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_9::VC5_PR_Q_C */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC5_PR_Q_C_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC5_PR_Q_C_MACRO__

/* macros for field rdl */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC5_PR_Q_C__RDL__SHIFT          0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC5_PR_Q_C__RDL__WIDTH         32
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC5_PR_Q_C__RDL__MASK 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC5_PR_Q_C__RDL__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC5_PR_Q_C__TYPE        u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC5_PR_Q_C__READ      0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC5_PR_Q_C_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.VC5_PR_Q_C */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__VC5_PR_Q_C__NUM                          1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_9::VC5_NPR_Q_C */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC5_NPR_Q_C_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC5_NPR_Q_C_MACRO__

/* macros for field rdl */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC5_NPR_Q_C__RDL__SHIFT         0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC5_NPR_Q_C__RDL__WIDTH        32
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC5_NPR_Q_C__RDL__MASK \
                    0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC5_NPR_Q_C__RDL__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC5_NPR_Q_C__TYPE       u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC5_NPR_Q_C__READ     0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC5_NPR_Q_C_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.VC5_NPR_Q_C */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__VC5_NPR_Q_C__NUM                         1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_9::VC5_CR_Q_C */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC5_CR_Q_C_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC5_CR_Q_C_MACRO__

/* macros for field rdl */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC5_CR_Q_C__RDL__SHIFT          0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC5_CR_Q_C__RDL__WIDTH         32
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC5_CR_Q_C__RDL__MASK 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC5_CR_Q_C__RDL__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC5_CR_Q_C__TYPE        u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC5_CR_Q_C__READ      0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC5_CR_Q_C_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.VC5_CR_Q_C */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__VC5_CR_Q_C__NUM                          1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_9::VC6_PR_Q_C */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC6_PR_Q_C_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC6_PR_Q_C_MACRO__

/* macros for field rdl */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC6_PR_Q_C__RDL__SHIFT          0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC6_PR_Q_C__RDL__WIDTH         32
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC6_PR_Q_C__RDL__MASK 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC6_PR_Q_C__RDL__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC6_PR_Q_C__TYPE        u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC6_PR_Q_C__READ      0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC6_PR_Q_C_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.VC6_PR_Q_C */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__VC6_PR_Q_C__NUM                          1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_9::VC6_NPR_Q_C */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC6_NPR_Q_C_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC6_NPR_Q_C_MACRO__

/* macros for field rdl */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC6_NPR_Q_C__RDL__SHIFT         0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC6_NPR_Q_C__RDL__WIDTH        32
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC6_NPR_Q_C__RDL__MASK \
                    0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC6_NPR_Q_C__RDL__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC6_NPR_Q_C__TYPE       u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC6_NPR_Q_C__READ     0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC6_NPR_Q_C_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.VC6_NPR_Q_C */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__VC6_NPR_Q_C__NUM                         1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_9::VC6_CR_Q_C */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC6_CR_Q_C_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC6_CR_Q_C_MACRO__

/* macros for field rdl */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC6_CR_Q_C__RDL__SHIFT          0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC6_CR_Q_C__RDL__WIDTH         32
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC6_CR_Q_C__RDL__MASK 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC6_CR_Q_C__RDL__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC6_CR_Q_C__TYPE        u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC6_CR_Q_C__READ      0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC6_CR_Q_C_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.VC6_CR_Q_C */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__VC6_CR_Q_C__NUM                          1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_9::VC7_PR_Q_C */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC7_PR_Q_C_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC7_PR_Q_C_MACRO__

/* macros for field rdl */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC7_PR_Q_C__RDL__SHIFT          0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC7_PR_Q_C__RDL__WIDTH         32
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC7_PR_Q_C__RDL__MASK 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC7_PR_Q_C__RDL__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC7_PR_Q_C__TYPE        u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC7_PR_Q_C__READ      0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC7_PR_Q_C_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.VC7_PR_Q_C */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__VC7_PR_Q_C__NUM                          1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_9::VC7_NPR_Q_C */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC7_NPR_Q_C_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC7_NPR_Q_C_MACRO__

/* macros for field rdl */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC7_NPR_Q_C__RDL__SHIFT         0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC7_NPR_Q_C__RDL__WIDTH        32
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC7_NPR_Q_C__RDL__MASK \
                    0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC7_NPR_Q_C__RDL__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC7_NPR_Q_C__TYPE       u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC7_NPR_Q_C__READ     0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC7_NPR_Q_C_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.VC7_NPR_Q_C */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__VC7_NPR_Q_C__NUM                         1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_9::VC7_CR_Q_C */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC7_CR_Q_C_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC7_CR_Q_C_MACRO__

/* macros for field rdl */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC7_CR_Q_C__RDL__SHIFT          0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC7_CR_Q_C__RDL__WIDTH         32
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC7_CR_Q_C__RDL__MASK 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC7_CR_Q_C__RDL__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC7_CR_Q_C__TYPE        u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC7_CR_Q_C__READ      0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC7_CR_Q_C_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.VC7_CR_Q_C */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__VC7_CR_Q_C__NUM                          1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_9::VC0_PB_D */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC0_PB_D_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC0_PB_D_MACRO__

/* macros for field rdl */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC0_PB_D__RDL__SHIFT            0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC0_PB_D__RDL__WIDTH           32
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC0_PB_D__RDL__MASK   0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC0_PB_D__RDL__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC0_PB_D__RDL__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0xffffffffU)
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC0_PB_D__RDL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xffffffffU) | ((u_int32_t)(src) &\
                    0xffffffffU)
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC0_PB_D__RDL__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0xffffffffU)))
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC0_PB_D__TYPE          u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC0_PB_D__READ        0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC0_PB_D__WRITE       0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC0_PB_D_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.VC0_PB_D */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__VC0_PB_D__NUM                            1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_9::VC0_NPB_D */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC0_NPB_D_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC0_NPB_D_MACRO__

/* macros for field rdl */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC0_NPB_D__RDL__SHIFT           0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC0_NPB_D__RDL__WIDTH          32
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC0_NPB_D__RDL__MASK  0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC0_NPB_D__RDL__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC0_NPB_D__RDL__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0xffffffffU)
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC0_NPB_D__RDL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xffffffffU) | ((u_int32_t)(src) &\
                    0xffffffffU)
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC0_NPB_D__RDL__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0xffffffffU)))
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC0_NPB_D__TYPE         u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC0_NPB_D__READ       0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC0_NPB_D__WRITE      0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC0_NPB_D_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.VC0_NPB_D */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__VC0_NPB_D__NUM                           1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_9::VC0_CB_D */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC0_CB_D_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC0_CB_D_MACRO__

/* macros for field rdl */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC0_CB_D__RDL__SHIFT            0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC0_CB_D__RDL__WIDTH           32
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC0_CB_D__RDL__MASK   0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC0_CB_D__RDL__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC0_CB_D__RDL__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0xffffffffU)
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC0_CB_D__RDL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xffffffffU) | ((u_int32_t)(src) &\
                    0xffffffffU)
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC0_CB_D__RDL__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0xffffffffU)))
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC0_CB_D__TYPE          u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC0_CB_D__READ        0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC0_CB_D__WRITE       0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC0_CB_D_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.VC0_CB_D */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__VC0_CB_D__NUM                            1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_9::VC1_PB_D */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC1_PB_D_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC1_PB_D_MACRO__

/* macros for field rdl */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC1_PB_D__RDL__SHIFT            0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC1_PB_D__RDL__WIDTH           32
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC1_PB_D__RDL__MASK   0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC1_PB_D__RDL__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC1_PB_D__RDL__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0xffffffffU)
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC1_PB_D__RDL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xffffffffU) | ((u_int32_t)(src) &\
                    0xffffffffU)
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC1_PB_D__RDL__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0xffffffffU)))
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC1_PB_D__TYPE          u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC1_PB_D__READ        0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC1_PB_D__WRITE       0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC1_PB_D_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.VC1_PB_D */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__VC1_PB_D__NUM                            1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_9::VC1_NPB_D */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC1_NPB_D_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC1_NPB_D_MACRO__

/* macros for field rdl */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC1_NPB_D__RDL__SHIFT           0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC1_NPB_D__RDL__WIDTH          32
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC1_NPB_D__RDL__MASK  0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC1_NPB_D__RDL__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC1_NPB_D__RDL__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0xffffffffU)
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC1_NPB_D__RDL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xffffffffU) | ((u_int32_t)(src) &\
                    0xffffffffU)
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC1_NPB_D__RDL__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0xffffffffU)))
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC1_NPB_D__TYPE         u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC1_NPB_D__READ       0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC1_NPB_D__WRITE      0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC1_NPB_D_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.VC1_NPB_D */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__VC1_NPB_D__NUM                           1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_9::VC1_CB_D */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC1_CB_D_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC1_CB_D_MACRO__

/* macros for field rdl */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC1_CB_D__RDL__SHIFT            0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC1_CB_D__RDL__WIDTH           32
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC1_CB_D__RDL__MASK   0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC1_CB_D__RDL__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC1_CB_D__RDL__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0xffffffffU)
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC1_CB_D__RDL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xffffffffU) | ((u_int32_t)(src) &\
                    0xffffffffU)
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC1_CB_D__RDL__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0xffffffffU)))
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC1_CB_D__TYPE          u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC1_CB_D__READ        0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC1_CB_D__WRITE       0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC1_CB_D_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.VC1_CB_D */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__VC1_CB_D__NUM                            1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_9::VC2_PB_D */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC2_PB_D_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC2_PB_D_MACRO__

/* macros for field rdl */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC2_PB_D__RDL__SHIFT            0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC2_PB_D__RDL__WIDTH           32
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC2_PB_D__RDL__MASK   0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC2_PB_D__RDL__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC2_PB_D__RDL__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0xffffffffU)
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC2_PB_D__RDL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xffffffffU) | ((u_int32_t)(src) &\
                    0xffffffffU)
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC2_PB_D__RDL__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0xffffffffU)))
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC2_PB_D__TYPE          u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC2_PB_D__READ        0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC2_PB_D__WRITE       0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC2_PB_D_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.VC2_PB_D */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__VC2_PB_D__NUM                            1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_9::VC2_NPB_D */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC2_NPB_D_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC2_NPB_D_MACRO__

/* macros for field rdl */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC2_NPB_D__RDL__SHIFT           0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC2_NPB_D__RDL__WIDTH          32
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC2_NPB_D__RDL__MASK  0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC2_NPB_D__RDL__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC2_NPB_D__RDL__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0xffffffffU)
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC2_NPB_D__RDL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xffffffffU) | ((u_int32_t)(src) &\
                    0xffffffffU)
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC2_NPB_D__RDL__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0xffffffffU)))
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC2_NPB_D__TYPE         u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC2_NPB_D__READ       0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC2_NPB_D__WRITE      0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC2_NPB_D_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.VC2_NPB_D */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__VC2_NPB_D__NUM                           1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_9::VC2_CB_D */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC2_CB_D_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC2_CB_D_MACRO__

/* macros for field rdl */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC2_CB_D__RDL__SHIFT            0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC2_CB_D__RDL__WIDTH           32
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC2_CB_D__RDL__MASK   0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC2_CB_D__RDL__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC2_CB_D__RDL__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0xffffffffU)
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC2_CB_D__RDL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xffffffffU) | ((u_int32_t)(src) &\
                    0xffffffffU)
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC2_CB_D__RDL__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0xffffffffU)))
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC2_CB_D__TYPE          u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC2_CB_D__READ        0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC2_CB_D__WRITE       0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC2_CB_D_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.VC2_CB_D */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__VC2_CB_D__NUM                            1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_9::VC3_PB_D */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC3_PB_D_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC3_PB_D_MACRO__

/* macros for field rdl */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC3_PB_D__RDL__SHIFT            0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC3_PB_D__RDL__WIDTH           32
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC3_PB_D__RDL__MASK   0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC3_PB_D__RDL__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC3_PB_D__RDL__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0xffffffffU)
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC3_PB_D__RDL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xffffffffU) | ((u_int32_t)(src) &\
                    0xffffffffU)
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC3_PB_D__RDL__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0xffffffffU)))
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC3_PB_D__TYPE          u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC3_PB_D__READ        0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC3_PB_D__WRITE       0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC3_PB_D_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.VC3_PB_D */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__VC3_PB_D__NUM                            1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_9::VC3_NPB_D */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC3_NPB_D_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC3_NPB_D_MACRO__

/* macros for field rdl */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC3_NPB_D__RDL__SHIFT           0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC3_NPB_D__RDL__WIDTH          32
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC3_NPB_D__RDL__MASK  0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC3_NPB_D__RDL__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC3_NPB_D__RDL__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0xffffffffU)
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC3_NPB_D__RDL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xffffffffU) | ((u_int32_t)(src) &\
                    0xffffffffU)
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC3_NPB_D__RDL__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0xffffffffU)))
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC3_NPB_D__TYPE         u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC3_NPB_D__READ       0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC3_NPB_D__WRITE      0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC3_NPB_D_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.VC3_NPB_D */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__VC3_NPB_D__NUM                           1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_9::VC3_CB_D */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC3_CB_D_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC3_CB_D_MACRO__

/* macros for field rdl */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC3_CB_D__RDL__SHIFT            0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC3_CB_D__RDL__WIDTH           32
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC3_CB_D__RDL__MASK   0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC3_CB_D__RDL__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC3_CB_D__RDL__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0xffffffffU)
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC3_CB_D__RDL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xffffffffU) | ((u_int32_t)(src) &\
                    0xffffffffU)
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC3_CB_D__RDL__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0xffffffffU)))
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC3_CB_D__TYPE          u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC3_CB_D__READ        0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC3_CB_D__WRITE       0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC3_CB_D_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.VC3_CB_D */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__VC3_CB_D__NUM                            1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_9::VC4_PB_D */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC4_PB_D_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC4_PB_D_MACRO__

/* macros for field rdl */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC4_PB_D__RDL__SHIFT            0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC4_PB_D__RDL__WIDTH           32
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC4_PB_D__RDL__MASK   0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC4_PB_D__RDL__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC4_PB_D__RDL__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0xffffffffU)
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC4_PB_D__RDL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xffffffffU) | ((u_int32_t)(src) &\
                    0xffffffffU)
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC4_PB_D__RDL__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0xffffffffU)))
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC4_PB_D__TYPE          u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC4_PB_D__READ        0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC4_PB_D__WRITE       0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC4_PB_D_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.VC4_PB_D */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__VC4_PB_D__NUM                            1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_9::VC4_NPB_D */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC4_NPB_D_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC4_NPB_D_MACRO__

/* macros for field rdl */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC4_NPB_D__RDL__SHIFT           0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC4_NPB_D__RDL__WIDTH          32
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC4_NPB_D__RDL__MASK  0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC4_NPB_D__RDL__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC4_NPB_D__RDL__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0xffffffffU)
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC4_NPB_D__RDL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xffffffffU) | ((u_int32_t)(src) &\
                    0xffffffffU)
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC4_NPB_D__RDL__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0xffffffffU)))
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC4_NPB_D__TYPE         u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC4_NPB_D__READ       0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC4_NPB_D__WRITE      0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC4_NPB_D_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.VC4_NPB_D */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__VC4_NPB_D__NUM                           1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_9::VC4_CB_D */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC4_CB_D_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC4_CB_D_MACRO__

/* macros for field rdl */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC4_CB_D__RDL__SHIFT            0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC4_CB_D__RDL__WIDTH           32
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC4_CB_D__RDL__MASK   0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC4_CB_D__RDL__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC4_CB_D__RDL__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0xffffffffU)
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC4_CB_D__RDL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xffffffffU) | ((u_int32_t)(src) &\
                    0xffffffffU)
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC4_CB_D__RDL__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0xffffffffU)))
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC4_CB_D__TYPE          u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC4_CB_D__READ        0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC4_CB_D__WRITE       0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC4_CB_D_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.VC4_CB_D */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__VC4_CB_D__NUM                            1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_9::VC5_PB_D */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC5_PB_D_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC5_PB_D_MACRO__

/* macros for field rdl */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC5_PB_D__RDL__SHIFT            0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC5_PB_D__RDL__WIDTH           32
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC5_PB_D__RDL__MASK   0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC5_PB_D__RDL__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC5_PB_D__RDL__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0xffffffffU)
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC5_PB_D__RDL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xffffffffU) | ((u_int32_t)(src) &\
                    0xffffffffU)
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC5_PB_D__RDL__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0xffffffffU)))
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC5_PB_D__TYPE          u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC5_PB_D__READ        0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC5_PB_D__WRITE       0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC5_PB_D_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.VC5_PB_D */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__VC5_PB_D__NUM                            1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_9::VC5_NPB_D */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC5_NPB_D_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC5_NPB_D_MACRO__

/* macros for field rdl */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC5_NPB_D__RDL__SHIFT           0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC5_NPB_D__RDL__WIDTH          32
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC5_NPB_D__RDL__MASK  0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC5_NPB_D__RDL__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC5_NPB_D__RDL__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0xffffffffU)
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC5_NPB_D__RDL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xffffffffU) | ((u_int32_t)(src) &\
                    0xffffffffU)
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC5_NPB_D__RDL__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0xffffffffU)))
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC5_NPB_D__TYPE         u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC5_NPB_D__READ       0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC5_NPB_D__WRITE      0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC5_NPB_D_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.VC5_NPB_D */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__VC5_NPB_D__NUM                           1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_9::VC5_CB_D */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC5_CB_D_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC5_CB_D_MACRO__

/* macros for field rdl */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC5_CB_D__RDL__SHIFT            0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC5_CB_D__RDL__WIDTH           32
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC5_CB_D__RDL__MASK   0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC5_CB_D__RDL__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC5_CB_D__RDL__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0xffffffffU)
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC5_CB_D__RDL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xffffffffU) | ((u_int32_t)(src) &\
                    0xffffffffU)
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC5_CB_D__RDL__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0xffffffffU)))
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC5_CB_D__TYPE          u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC5_CB_D__READ        0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC5_CB_D__WRITE       0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC5_CB_D_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.VC5_CB_D */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__VC5_CB_D__NUM                            1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_9::VC6_PB_D */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC6_PB_D_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC6_PB_D_MACRO__

/* macros for field rdl */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC6_PB_D__RDL__SHIFT            0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC6_PB_D__RDL__WIDTH           32
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC6_PB_D__RDL__MASK   0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC6_PB_D__RDL__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC6_PB_D__RDL__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0xffffffffU)
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC6_PB_D__RDL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xffffffffU) | ((u_int32_t)(src) &\
                    0xffffffffU)
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC6_PB_D__RDL__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0xffffffffU)))
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC6_PB_D__TYPE          u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC6_PB_D__READ        0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC6_PB_D__WRITE       0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC6_PB_D_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.VC6_PB_D */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__VC6_PB_D__NUM                            1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_9::VC6_NPB_D */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC6_NPB_D_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC6_NPB_D_MACRO__

/* macros for field rdl */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC6_NPB_D__RDL__SHIFT           0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC6_NPB_D__RDL__WIDTH          32
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC6_NPB_D__RDL__MASK  0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC6_NPB_D__RDL__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC6_NPB_D__RDL__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0xffffffffU)
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC6_NPB_D__RDL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xffffffffU) | ((u_int32_t)(src) &\
                    0xffffffffU)
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC6_NPB_D__RDL__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0xffffffffU)))
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC6_NPB_D__TYPE         u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC6_NPB_D__READ       0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC6_NPB_D__WRITE      0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC6_NPB_D_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.VC6_NPB_D */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__VC6_NPB_D__NUM                           1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_9::VC6_CB_D */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC6_CB_D_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC6_CB_D_MACRO__

/* macros for field rdl */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC6_CB_D__RDL__SHIFT            0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC6_CB_D__RDL__WIDTH           32
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC6_CB_D__RDL__MASK   0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC6_CB_D__RDL__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC6_CB_D__RDL__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0xffffffffU)
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC6_CB_D__RDL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xffffffffU) | ((u_int32_t)(src) &\
                    0xffffffffU)
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC6_CB_D__RDL__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0xffffffffU)))
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC6_CB_D__TYPE          u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC6_CB_D__READ        0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC6_CB_D__WRITE       0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC6_CB_D_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.VC6_CB_D */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__VC6_CB_D__NUM                            1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_9::VC7_PB_D */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC7_PB_D_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC7_PB_D_MACRO__

/* macros for field rdl */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC7_PB_D__RDL__SHIFT            0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC7_PB_D__RDL__WIDTH           32
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC7_PB_D__RDL__MASK   0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC7_PB_D__RDL__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC7_PB_D__RDL__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0xffffffffU)
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC7_PB_D__RDL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xffffffffU) | ((u_int32_t)(src) &\
                    0xffffffffU)
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC7_PB_D__RDL__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0xffffffffU)))
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC7_PB_D__TYPE          u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC7_PB_D__READ        0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC7_PB_D__WRITE       0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC7_PB_D_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.VC7_PB_D */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__VC7_PB_D__NUM                            1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_9::VC7_NPB_D */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC7_NPB_D_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC7_NPB_D_MACRO__

/* macros for field rdl */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC7_NPB_D__RDL__SHIFT           0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC7_NPB_D__RDL__WIDTH          32
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC7_NPB_D__RDL__MASK  0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC7_NPB_D__RDL__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC7_NPB_D__RDL__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0xffffffffU)
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC7_NPB_D__RDL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xffffffffU) | ((u_int32_t)(src) &\
                    0xffffffffU)
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC7_NPB_D__RDL__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0xffffffffU)))
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC7_NPB_D__TYPE         u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC7_NPB_D__READ       0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC7_NPB_D__WRITE      0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC7_NPB_D_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.VC7_NPB_D */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__VC7_NPB_D__NUM                           1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_9::VC7_CB_D */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC7_CB_D_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC7_CB_D_MACRO__

/* macros for field rdl */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC7_CB_D__RDL__SHIFT            0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC7_CB_D__RDL__WIDTH           32
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC7_CB_D__RDL__MASK   0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC7_CB_D__RDL__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC7_CB_D__RDL__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0xffffffffU)
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC7_CB_D__RDL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xffffffffU) | ((u_int32_t)(src) &\
                    0xffffffffU)
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC7_CB_D__RDL__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0xffffffffU)))
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC7_CB_D__TYPE          u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC7_CB_D__READ        0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC7_CB_D__WRITE       0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__VC7_CB_D_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.VC7_CB_D */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__VC7_CB_D__NUM                            1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_9::GEN2 */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__GEN2_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__GEN2_MACRO__

/* macros for field rdl */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__GEN2__RDL__SHIFT                0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__GEN2__RDL__WIDTH               32
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__GEN2__RDL__MASK       0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__GEN2__RDL__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__GEN2__RDL__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0xffffffffU)
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__GEN2__RDL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xffffffffU) | ((u_int32_t)(src) &\
                    0xffffffffU)
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__GEN2__RDL__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0xffffffffU)))
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__GEN2__TYPE              u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__GEN2__READ            0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__GEN2__WRITE           0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__GEN2_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.GEN2 */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__GEN2__NUM                                1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_9::PHY_STS_R */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__PHY_STS_R_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__PHY_STS_R_MACRO__

/* macros for field rdl */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__PHY_STS_R__RDL__SHIFT           0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__PHY_STS_R__RDL__WIDTH          32
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__PHY_STS_R__RDL__MASK  0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__PHY_STS_R__RDL__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__PHY_STS_R__RDL__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0xffffffffU)
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__PHY_STS_R__RDL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xffffffffU) | ((u_int32_t)(src) &\
                    0xffffffffU)
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__PHY_STS_R__RDL__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0xffffffffU)))
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__PHY_STS_R__TYPE         u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__PHY_STS_R__READ       0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__PHY_STS_R__WRITE      0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__PHY_STS_R_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.PHY_STS_R */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__PHY_STS_R__NUM                           1

/* macros for BlueprintGlobalNameSpace::DWC_pcie_dbi_axi::DWC_pcie_dbi_axi_9::PHY_CTRL_R */
#ifndef __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__PHY_CTRL_R_MACRO__
#define __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__PHY_CTRL_R_MACRO__

/* macros for field rdl */
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__PHY_CTRL_R__RDL__SHIFT          0
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__PHY_CTRL_R__RDL__WIDTH         32
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__PHY_CTRL_R__RDL__MASK 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__PHY_CTRL_R__RDL__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__PHY_CTRL_R__RDL__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0xffffffffU)
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__PHY_CTRL_R__RDL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xffffffffU) | ((u_int32_t)(src) &\
                    0xffffffffU)
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__PHY_CTRL_R__RDL__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0xffffffffU)))
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__PHY_CTRL_R__TYPE        u_int32_t
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__PHY_CTRL_R__READ      0xffffffffU
#define DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__PHY_CTRL_R__WRITE     0xffffffffU

#endif /* __DWC_PCIE_DBI_AXI__DWC_PCIE_DBI_AXI_9__PHY_CTRL_R_MACRO__ */


/* macros for DWC_pcie_dbi_axi_block.PHY_CTRL_R */
#define INST_DWC_PCIE_DBI_AXI_BLOCK__PHY_CTRL_R__NUM                          1
#define RFILE_INST_DWC_PCIE_DBI_AXI_BLOCK__DWC_PCIE_DBI_AXI_0__NUM            1
#define RFILE_INST_DWC_PCIE_DBI_AXI_BLOCK__DWC_PCIE_DBI_AXI_1__NUM            1
#define RFILE_INST_DWC_PCIE_DBI_AXI_BLOCK__DWC_PCIE_DBI_AXI_2__NUM            1
#define RFILE_INST_DWC_PCIE_DBI_AXI_BLOCK__DWC_PCIE_DBI_AXI_3__NUM            1
#define RFILE_INST_DWC_PCIE_DBI_AXI_BLOCK__DWC_PCIE_DBI_AXI_5__NUM            1
#define RFILE_INST_DWC_PCIE_DBI_AXI_BLOCK__DWC_PCIE_DBI_AXI_6__NUM            1
#define RFILE_INST_DWC_PCIE_DBI_AXI_BLOCK__DWC_PCIE_DBI_AXI_7__NUM            1
#define RFILE_INST_DWC_PCIE_DBI_AXI_BLOCK__DWC_PCIE_DBI_AXI_8__NUM            1
#define RFILE_INST_DWC_PCIE_DBI_AXI_BLOCK__DWC_PCIE_DBI_AXI_9__NUM            1

/* macros for BlueprintGlobalNameSpace::RESET_CONTROL */
#ifndef __RESET_CONTROL_MACRO__
#define __RESET_CONTROL_MACRO__

/* macros for field MAC_WARM_RST */
#define RESET_CONTROL__MAC_WARM_RST__SHIFT                                    0
#define RESET_CONTROL__MAC_WARM_RST__WIDTH                                    1
#define RESET_CONTROL__MAC_WARM_RST__MASK                           0x00000001U
#define RESET_CONTROL__MAC_WARM_RST__READ(src)   (u_int32_t)(src) & 0x00000001U
#define RESET_CONTROL__MAC_WARM_RST__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x00000001U)
#define RESET_CONTROL__MAC_WARM_RST__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | ((u_int32_t)(src) &\
                    0x00000001U)
#define RESET_CONTROL__MAC_WARM_RST__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00000001U)))
#define RESET_CONTROL__MAC_WARM_RST__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(1)
#define RESET_CONTROL__MAC_WARM_RST__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(0)

/* macros for field MAC_COLD_RST */
#define RESET_CONTROL__MAC_COLD_RST__SHIFT                                    1
#define RESET_CONTROL__MAC_COLD_RST__WIDTH                                    1
#define RESET_CONTROL__MAC_COLD_RST__MASK                           0x00000002U
#define RESET_CONTROL__MAC_COLD_RST__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000002U) >> 1)
#define RESET_CONTROL__MAC_COLD_RST__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 1) & 0x00000002U)
#define RESET_CONTROL__MAC_COLD_RST__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | (((u_int32_t)(src) <<\
                    1) & 0x00000002U)
#define RESET_CONTROL__MAC_COLD_RST__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 1) & ~0x00000002U)))
#define RESET_CONTROL__MAC_COLD_RST__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | ((u_int32_t)(1) << 1)
#define RESET_CONTROL__MAC_COLD_RST__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | ((u_int32_t)(0) << 1)

/* macros for field WARM_RST */
#define RESET_CONTROL__WARM_RST__SHIFT                                        2
#define RESET_CONTROL__WARM_RST__WIDTH                                        1
#define RESET_CONTROL__WARM_RST__MASK                               0x00000004U
#define RESET_CONTROL__WARM_RST__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000004U) >> 2)
#define RESET_CONTROL__WARM_RST__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 2) & 0x00000004U)
#define RESET_CONTROL__WARM_RST__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000004U) | (((u_int32_t)(src) <<\
                    2) & 0x00000004U)
#define RESET_CONTROL__WARM_RST__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 2) & ~0x00000004U)))
#define RESET_CONTROL__WARM_RST__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000004U) | ((u_int32_t)(1) << 2)
#define RESET_CONTROL__WARM_RST__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000004U) | ((u_int32_t)(0) << 2)

/* macros for field COLD_RST */
#define RESET_CONTROL__COLD_RST__SHIFT                                        3
#define RESET_CONTROL__COLD_RST__WIDTH                                        1
#define RESET_CONTROL__COLD_RST__MASK                               0x00000008U
#define RESET_CONTROL__COLD_RST__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000008U) >> 3)
#define RESET_CONTROL__COLD_RST__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 3) & 0x00000008U)
#define RESET_CONTROL__COLD_RST__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000008U) | (((u_int32_t)(src) <<\
                    3) & 0x00000008U)
#define RESET_CONTROL__COLD_RST__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 3) & ~0x00000008U)))
#define RESET_CONTROL__COLD_RST__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000008U) | ((u_int32_t)(1) << 3)
#define RESET_CONTROL__COLD_RST__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000008U) | ((u_int32_t)(0) << 3)
#define RESET_CONTROL__TYPE                                           u_int32_t
#define RESET_CONTROL__READ                                         0x0000000fU
#define RESET_CONTROL__WRITE                                        0x0000000fU

#endif /* __RESET_CONTROL_MACRO__ */


/* macros for rtc_reg_block.RESET_CONTROL */
#define INST_RTC_REG_BLOCK__RESET_CONTROL__NUM                                1

/* macros for BlueprintGlobalNameSpace::XTAL_CONTROL */
#ifndef __XTAL_CONTROL_MACRO__
#define __XTAL_CONTROL_MACRO__

/* macros for field TCXO */
#define XTAL_CONTROL__TCXO__SHIFT                                             0
#define XTAL_CONTROL__TCXO__WIDTH                                             1
#define XTAL_CONTROL__TCXO__MASK                                    0x00000001U
#define XTAL_CONTROL__TCXO__READ(src)            (u_int32_t)(src) & 0x00000001U
#define XTAL_CONTROL__TCXO__WRITE(src)         ((u_int32_t)(src) & 0x00000001U)
#define XTAL_CONTROL__TCXO__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | ((u_int32_t)(src) &\
                    0x00000001U)
#define XTAL_CONTROL__TCXO__VERIFY(src)  (!(((u_int32_t)(src) & ~0x00000001U)))
#define XTAL_CONTROL__TCXO__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(1)
#define XTAL_CONTROL__TCXO__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(0)
#define XTAL_CONTROL__TYPE                                            u_int32_t
#define XTAL_CONTROL__READ                                          0x00000001U
#define XTAL_CONTROL__WRITE                                         0x00000001U

#endif /* __XTAL_CONTROL_MACRO__ */


/* macros for rtc_reg_block.XTAL_CONTROL */
#define INST_RTC_REG_BLOCK__XTAL_CONTROL__NUM                                 1

/* macros for BlueprintGlobalNameSpace::REG_CONTROL0 */
#ifndef __REG_CONTROL0_MACRO__
#define __REG_CONTROL0_MACRO__

/* macros for field SWREG_BITS */
#define REG_CONTROL0__SWREG_BITS__SHIFT                                       0
#define REG_CONTROL0__SWREG_BITS__WIDTH                                      32
#define REG_CONTROL0__SWREG_BITS__MASK                              0xffffffffU
#define REG_CONTROL0__SWREG_BITS__READ(src)      (u_int32_t)(src) & 0xffffffffU
#define REG_CONTROL0__SWREG_BITS__WRITE(src)   ((u_int32_t)(src) & 0xffffffffU)
#define REG_CONTROL0__SWREG_BITS__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xffffffffU) | ((u_int32_t)(src) &\
                    0xffffffffU)
#define REG_CONTROL0__SWREG_BITS__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0xffffffffU)))
#define REG_CONTROL0__TYPE                                            u_int32_t
#define REG_CONTROL0__READ                                          0xffffffffU
#define REG_CONTROL0__WRITE                                         0xffffffffU

#endif /* __REG_CONTROL0_MACRO__ */


/* macros for rtc_reg_block.REG_CONTROL0 */
#define INST_RTC_REG_BLOCK__REG_CONTROL0__NUM                                 1

/* macros for BlueprintGlobalNameSpace::REG_CONTROL1 */
#ifndef __REG_CONTROL1_MACRO__
#define __REG_CONTROL1_MACRO__

/* macros for field SWREG_PROGRAM */
#define REG_CONTROL1__SWREG_PROGRAM__SHIFT                                    0
#define REG_CONTROL1__SWREG_PROGRAM__WIDTH                                    1
#define REG_CONTROL1__SWREG_PROGRAM__MASK                           0x00000001U
#define REG_CONTROL1__SWREG_PROGRAM__READ(src)   (u_int32_t)(src) & 0x00000001U
#define REG_CONTROL1__SWREG_PROGRAM__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x00000001U)
#define REG_CONTROL1__SWREG_PROGRAM__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | ((u_int32_t)(src) &\
                    0x00000001U)
#define REG_CONTROL1__SWREG_PROGRAM__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00000001U)))
#define REG_CONTROL1__SWREG_PROGRAM__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(1)
#define REG_CONTROL1__SWREG_PROGRAM__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(0)

/* macros for field OTPREG_LVL */
#define REG_CONTROL1__OTPREG_LVL__SHIFT                                       1
#define REG_CONTROL1__OTPREG_LVL__WIDTH                                       2
#define REG_CONTROL1__OTPREG_LVL__MASK                              0x00000006U
#define REG_CONTROL1__OTPREG_LVL__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000006U) >> 1)
#define REG_CONTROL1__OTPREG_LVL__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 1) & 0x00000006U)
#define REG_CONTROL1__OTPREG_LVL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000006U) | (((u_int32_t)(src) <<\
                    1) & 0x00000006U)
#define REG_CONTROL1__OTPREG_LVL__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 1) & ~0x00000006U)))
#define REG_CONTROL1__TYPE                                            u_int32_t
#define REG_CONTROL1__READ                                          0x00000007U
#define REG_CONTROL1__WRITE                                         0x00000007U

#endif /* __REG_CONTROL1_MACRO__ */


/* macros for rtc_reg_block.REG_CONTROL1 */
#define INST_RTC_REG_BLOCK__REG_CONTROL1__NUM                                 1

/* macros for BlueprintGlobalNameSpace::QUADRATURE */
#ifndef __QUADRATURE_MACRO__
#define __QUADRATURE_MACRO__

/* macros for field DAC */
#define QUADRATURE__DAC__SHIFT                                                0
#define QUADRATURE__DAC__WIDTH                                                3
#define QUADRATURE__DAC__MASK                                       0x00000007U
#define QUADRATURE__DAC__READ(src)               (u_int32_t)(src) & 0x00000007U
#define QUADRATURE__DAC__WRITE(src)            ((u_int32_t)(src) & 0x00000007U)
#define QUADRATURE__DAC__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000007U) | ((u_int32_t)(src) &\
                    0x00000007U)
#define QUADRATURE__DAC__VERIFY(src)     (!(((u_int32_t)(src) & ~0x00000007U)))

/* macros for field ADC */
#define QUADRATURE__ADC__SHIFT                                                4
#define QUADRATURE__ADC__WIDTH                                                4
#define QUADRATURE__ADC__MASK                                       0x000000f0U
#define QUADRATURE__ADC__READ(src)      (((u_int32_t)(src) & 0x000000f0U) >> 4)
#define QUADRATURE__ADC__WRITE(src)     (((u_int32_t)(src) << 4) & 0x000000f0U)
#define QUADRATURE__ADC__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000000f0U) | (((u_int32_t)(src) <<\
                    4) & 0x000000f0U)
#define QUADRATURE__ADC__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 4) & ~0x000000f0U)))
#define QUADRATURE__TYPE                                              u_int32_t
#define QUADRATURE__READ                                            0x000000f7U
#define QUADRATURE__WRITE                                           0x000000f7U

#endif /* __QUADRATURE_MACRO__ */


/* macros for rtc_reg_block.QUADRATURE */
#define INST_RTC_REG_BLOCK__QUADRATURE__NUM                                   1

/* macros for BlueprintGlobalNameSpace::PLL_CONTROL */
#ifndef __PLL_CONTROL_MACRO__
#define __PLL_CONTROL_MACRO__

/* macros for field DIV */
#define PLL_CONTROL__DIV__SHIFT                                               0
#define PLL_CONTROL__DIV__WIDTH                                              10
#define PLL_CONTROL__DIV__MASK                                      0x000003ffU
#define PLL_CONTROL__DIV__READ(src)              (u_int32_t)(src) & 0x000003ffU
#define PLL_CONTROL__DIV__WRITE(src)           ((u_int32_t)(src) & 0x000003ffU)
#define PLL_CONTROL__DIV__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000003ffU) | ((u_int32_t)(src) &\
                    0x000003ffU)
#define PLL_CONTROL__DIV__VERIFY(src)    (!(((u_int32_t)(src) & ~0x000003ffU)))

/* macros for field REFDIV */
#define PLL_CONTROL__REFDIV__SHIFT                                           10
#define PLL_CONTROL__REFDIV__WIDTH                                            4
#define PLL_CONTROL__REFDIV__MASK                                   0x00003c00U
#define PLL_CONTROL__REFDIV__READ(src) (((u_int32_t)(src) & 0x00003c00U) >> 10)
#define PLL_CONTROL__REFDIV__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 10) & 0x00003c00U)
#define PLL_CONTROL__REFDIV__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00003c00U) | (((u_int32_t)(src) <<\
                    10) & 0x00003c00U)
#define PLL_CONTROL__REFDIV__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 10) & ~0x00003c00U)))

/* macros for field CLK_SEL */
#define PLL_CONTROL__CLK_SEL__SHIFT                                          14
#define PLL_CONTROL__CLK_SEL__WIDTH                                           2
#define PLL_CONTROL__CLK_SEL__MASK                                  0x0000c000U
#define PLL_CONTROL__CLK_SEL__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0000c000U) >> 14)
#define PLL_CONTROL__CLK_SEL__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 14) & 0x0000c000U)
#define PLL_CONTROL__CLK_SEL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000c000U) | (((u_int32_t)(src) <<\
                    14) & 0x0000c000U)
#define PLL_CONTROL__CLK_SEL__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 14) & ~0x0000c000U)))

/* macros for field BYPASS */
#define PLL_CONTROL__BYPASS__SHIFT                                           16
#define PLL_CONTROL__BYPASS__WIDTH                                            1
#define PLL_CONTROL__BYPASS__MASK                                   0x00010000U
#define PLL_CONTROL__BYPASS__READ(src) (((u_int32_t)(src) & 0x00010000U) >> 16)
#define PLL_CONTROL__BYPASS__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 16) & 0x00010000U)
#define PLL_CONTROL__BYPASS__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00010000U) | (((u_int32_t)(src) <<\
                    16) & 0x00010000U)
#define PLL_CONTROL__BYPASS__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 16) & ~0x00010000U)))
#define PLL_CONTROL__BYPASS__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00010000U) | ((u_int32_t)(1) << 16)
#define PLL_CONTROL__BYPASS__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00010000U) | ((u_int32_t)(0) << 16)

/* macros for field UPDATING */
#define PLL_CONTROL__UPDATING__SHIFT                                         17
#define PLL_CONTROL__UPDATING__WIDTH                                          1
#define PLL_CONTROL__UPDATING__MASK                                 0x00020000U
#define PLL_CONTROL__UPDATING__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00020000U) >> 17)
#define PLL_CONTROL__UPDATING__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00020000U) | ((u_int32_t)(1) << 17)
#define PLL_CONTROL__UPDATING__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00020000U) | ((u_int32_t)(0) << 17)

/* macros for field NOPWD */
#define PLL_CONTROL__NOPWD__SHIFT                                            18
#define PLL_CONTROL__NOPWD__WIDTH                                             1
#define PLL_CONTROL__NOPWD__MASK                                    0x00040000U
#define PLL_CONTROL__NOPWD__READ(src)  (((u_int32_t)(src) & 0x00040000U) >> 18)
#define PLL_CONTROL__NOPWD__WRITE(src) (((u_int32_t)(src) << 18) & 0x00040000U)
#define PLL_CONTROL__NOPWD__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00040000U) | (((u_int32_t)(src) <<\
                    18) & 0x00040000U)
#define PLL_CONTROL__NOPWD__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 18) & ~0x00040000U)))
#define PLL_CONTROL__NOPWD__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00040000U) | ((u_int32_t)(1) << 18)
#define PLL_CONTROL__NOPWD__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00040000U) | ((u_int32_t)(0) << 18)

/* macros for field MAC_OVERRIDE */
#define PLL_CONTROL__MAC_OVERRIDE__SHIFT                                     19
#define PLL_CONTROL__MAC_OVERRIDE__WIDTH                                      1
#define PLL_CONTROL__MAC_OVERRIDE__MASK                             0x00080000U
#define PLL_CONTROL__MAC_OVERRIDE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00080000U) >> 19)
#define PLL_CONTROL__MAC_OVERRIDE__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 19) & 0x00080000U)
#define PLL_CONTROL__MAC_OVERRIDE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00080000U) | (((u_int32_t)(src) <<\
                    19) & 0x00080000U)
#define PLL_CONTROL__MAC_OVERRIDE__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 19) & ~0x00080000U)))
#define PLL_CONTROL__MAC_OVERRIDE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00080000U) | ((u_int32_t)(1) << 19)
#define PLL_CONTROL__MAC_OVERRIDE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00080000U) | ((u_int32_t)(0) << 19)
#define PLL_CONTROL__TYPE                                             u_int32_t
#define PLL_CONTROL__READ                                           0x000fffffU
#define PLL_CONTROL__WRITE                                          0x000fffffU

#endif /* __PLL_CONTROL_MACRO__ */


/* macros for rtc_reg_block.PLL_CONTROL */
#define INST_RTC_REG_BLOCK__PLL_CONTROL__NUM                                  1

/* macros for BlueprintGlobalNameSpace::PLL_CONTROL */
#ifndef __JET_PLL_CONTROL_MACRO__
#define __JET_PLL_CONTROL_MACRO__

/* macros for field DIV_INT */
#define JET_PLL_CONTROL__DIV_INT__SHIFT                                           0
#define JET_PLL_CONTROL__DIV_INT__WIDTH                                           6
#define JET_PLL_CONTROL__DIV_INT__MASK                                  0x0000003fU
#define JET_PLL_CONTROL__DIV_INT__READ(src)          (u_int32_t)(src) & 0x0000003fU
#define JET_PLL_CONTROL__DIV_INT__WRITE(src)       ((u_int32_t)(src) & 0x0000003fU)
#define JET_PLL_CONTROL__DIV_INT__MODIFY(dst, src) \
    (dst) = ((dst) &\
            ~0x0000003fU) | ((u_int32_t)(src) &\
                0x0000003fU)
#define JET_PLL_CONTROL__DIV_INT__VERIFY(src) \
    (!(((u_int32_t)(src)\
        & ~0x0000003fU)))

/* macros for field DIV_FRAC */
#define JET_PLL_CONTROL__DIV_FRAC__SHIFT                                          6
#define JET_PLL_CONTROL__DIV_FRAC__WIDTH                                         14
#define JET_PLL_CONTROL__DIV_FRAC__MASK                                 0x000fffc0U
#define JET_PLL_CONTROL__DIV_FRAC__READ(src) \
    (((u_int32_t)(src)\
      & 0x000fffc0U) >> 6)
#define JET_PLL_CONTROL__DIV_FRAC__WRITE(src) \
    (((u_int32_t)(src)\
      << 6) & 0x000fffc0U)
#define JET_PLL_CONTROL__DIV_FRAC__MODIFY(dst, src) \
    (dst) = ((dst) &\
            ~0x000fffc0U) | (((u_int32_t)(src) <<\
                    6) & 0x000fffc0U)
#define JET_PLL_CONTROL__DIV_FRAC__VERIFY(src) \
    (!((((u_int32_t)(src)\
         << 6) & ~0x000fffc0U)))

/* macros for field REFDIV */
#define JET_PLL_CONTROL__REFDIV__SHIFT                                           20
#define JET_PLL_CONTROL__REFDIV__WIDTH                                            5
#define JET_PLL_CONTROL__REFDIV__MASK                                   0x01f00000U
#define JET_PLL_CONTROL__REFDIV__READ(src) (((u_int32_t)(src) & 0x01f00000U) >> 20)
#define JET_PLL_CONTROL__REFDIV__WRITE(src) \
    (((u_int32_t)(src)\
      << 20) & 0x01f00000U)
#define JET_PLL_CONTROL__REFDIV__MODIFY(dst, src) \
    (dst) = ((dst) &\
            ~0x01f00000U) | (((u_int32_t)(src) <<\
                    20) & 0x01f00000U)
#define JET_PLL_CONTROL__REFDIV__VERIFY(src) \
    (!((((u_int32_t)(src)\
         << 20) & ~0x01f00000U)))

/* macros for field CLK_SEL */
#define JET_PLL_CONTROL__CLK_SEL__SHIFT                                          25
#define JET_PLL_CONTROL__CLK_SEL__WIDTH                                           2
#define JET_PLL_CONTROL__CLK_SEL__MASK                                  0x06000000U
#define JET_PLL_CONTROL__CLK_SEL__READ(src) \
    (((u_int32_t)(src)\
      & 0x06000000U) >> 25)
#define JET_PLL_CONTROL__CLK_SEL__WRITE(src) \
    (((u_int32_t)(src)\
      << 25) & 0x06000000U)
#define JET_PLL_CONTROL__CLK_SEL__MODIFY(dst, src) \
    (dst) = ((dst) &\
            ~0x06000000U) | (((u_int32_t)(src) <<\
                    25) & 0x06000000U)
#define JET_PLL_CONTROL__CLK_SEL__VERIFY(src) \
    (!((((u_int32_t)(src)\
         << 25) & ~0x06000000U)))

/* macros for field BYPASS */
#define JET_PLL_CONTROL__BYPASS__SHIFT                                           27
#define JET_PLL_CONTROL__BYPASS__WIDTH                                            1
#define JET_PLL_CONTROL__BYPASS__MASK                                   0x08000000U
#define JET_PLL_CONTROL__BYPASS__READ(src) (((u_int32_t)(src) & 0x08000000U) >> 27)
#define JET_PLL_CONTROL__BYPASS__WRITE(src) \
    (((u_int32_t)(src)\
      << 27) & 0x08000000U)
#define JET_PLL_CONTROL__BYPASS__MODIFY(dst, src) \
    (dst) = ((dst) &\
            ~0x08000000U) | (((u_int32_t)(src) <<\
                    27) & 0x08000000U)
#define JET_PLL_CONTROL__BYPASS__VERIFY(src) \
    (!((((u_int32_t)(src)\
         << 27) & ~0x08000000U)))
#define JET_PLL_CONTROL__BYPASS__SET(dst) \
    (dst) = ((dst) &\
            ~0x08000000U) | ((u_int32_t)(1) << 27)
#define JET_PLL_CONTROL__BYPASS__CLR(dst) \
    (dst) = ((dst) &\
            ~0x08000000U) | ((u_int32_t)(0) << 27)

/* macros for field UPDATING */
#define JET_PLL_CONTROL__UPDATING__SHIFT                                         28
#define JET_PLL_CONTROL__UPDATING__WIDTH                                          1
#define JET_PLL_CONTROL__UPDATING__MASK                                 0x10000000U
#define JET_PLL_CONTROL__UPDATING__READ(src) \
    (((u_int32_t)(src)\
      & 0x10000000U) >> 28)
#define JET_PLL_CONTROL__UPDATING__SET(dst) \
    (dst) = ((dst) &\
            ~0x10000000U) | ((u_int32_t)(1) << 28)
#define JET_PLL_CONTROL__UPDATING__CLR(dst) \
    (dst) = ((dst) &\
            ~0x10000000U) | ((u_int32_t)(0) << 28)

/* macros for field NOPWD */
#define JET_PLL_CONTROL__NOPWD__SHIFT                                            29
#define JET_PLL_CONTROL__NOPWD__WIDTH                                             1
#define JET_PLL_CONTROL__NOPWD__MASK                                    0x20000000U
#define JET_PLL_CONTROL__NOPWD__READ(src)  (((u_int32_t)(src) & 0x20000000U) >> 29)
#define JET_PLL_CONTROL__NOPWD__WRITE(src) (((u_int32_t)(src) << 29) & 0x20000000U)
#define JET_PLL_CONTROL__NOPWD__MODIFY(dst, src) \
    (dst) = ((dst) &\
            ~0x20000000U) | (((u_int32_t)(src) <<\
                    29) & 0x20000000U)
#define JET_PLL_CONTROL__NOPWD__VERIFY(src) \
    (!((((u_int32_t)(src)\
         << 29) & ~0x20000000U)))
#define JET_PLL_CONTROL__NOPWD__SET(dst) \
    (dst) = ((dst) &\
            ~0x20000000U) | ((u_int32_t)(1) << 29)
#define JET_PLL_CONTROL__NOPWD__CLR(dst) \
    (dst) = ((dst) &\
            ~0x20000000U) | ((u_int32_t)(0) << 29)

/* macros for field MAC_OVERRIDE */
#define JET_PLL_CONTROL__MAC_OVERRIDE__SHIFT                                     30
#define JET_PLL_CONTROL__MAC_OVERRIDE__WIDTH                                      1
#define JET_PLL_CONTROL__MAC_OVERRIDE__MASK                             0x40000000U
#define JET_PLL_CONTROL__MAC_OVERRIDE__READ(src) \
    (((u_int32_t)(src)\
      & 0x40000000U) >> 30)
#define JET_PLL_CONTROL__MAC_OVERRIDE__WRITE(src) \
    (((u_int32_t)(src)\
      << 30) & 0x40000000U)
#define JET_PLL_CONTROL__MAC_OVERRIDE__MODIFY(dst, src) \
    (dst) = ((dst) &\
            ~0x40000000U) | (((u_int32_t)(src) <<\
                    30) & 0x40000000U)
#define JET_PLL_CONTROL__MAC_OVERRIDE__VERIFY(src) \
    (!((((u_int32_t)(src)\
         << 30) & ~0x40000000U)))
#define JET_PLL_CONTROL__MAC_OVERRIDE__SET(dst) \
    (dst) = ((dst) &\
            ~0x40000000U) | ((u_int32_t)(1) << 30)
#define JET_PLL_CONTROL__MAC_OVERRIDE__CLR(dst) \
    (dst) = ((dst) &\
            ~0x40000000U) | ((u_int32_t)(0) << 30)
#define JET_PLL_CONTROL__TYPE                                             u_int32_t
#define JET_PLL_CONTROL__READ                                           0x7fffffffU
#define JET_PLL_CONTROL__WRITE                                          0x7fffffffU

#endif /* __JET_PLL_CONTROL_MACRO__ */

#define INST_RTC_REG_BLOCK__JET_PLL_CONTROL__NUM                                  1

/* macros for BlueprintGlobalNameSpace::PLL_SETTLE */
#ifndef __PLL_SETTLE_MACRO__
#define __PLL_SETTLE_MACRO__

/* macros for field TIME */
#define PLL_SETTLE__TIME__SHIFT                                               0
#define PLL_SETTLE__TIME__WIDTH                                              11
#define PLL_SETTLE__TIME__MASK                                      0x000007ffU
#define PLL_SETTLE__TIME__READ(src)              (u_int32_t)(src) & 0x000007ffU
#define PLL_SETTLE__TIME__WRITE(src)           ((u_int32_t)(src) & 0x000007ffU)
#define PLL_SETTLE__TIME__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000007ffU) | ((u_int32_t)(src) &\
                    0x000007ffU)
#define PLL_SETTLE__TIME__VERIFY(src)    (!(((u_int32_t)(src) & ~0x000007ffU)))
#define PLL_SETTLE__TYPE                                              u_int32_t
#define PLL_SETTLE__READ                                            0x000007ffU
#define PLL_SETTLE__WRITE                                           0x000007ffU

#endif /* __PLL_SETTLE_MACRO__ */


/* macros for rtc_reg_block.PLL_SETTLE */
#define INST_RTC_REG_BLOCK__PLL_SETTLE__NUM                                   1

/* macros for BlueprintGlobalNameSpace::XTAL_SETTLE */
#ifndef __XTAL_SETTLE_MACRO__
#define __XTAL_SETTLE_MACRO__

/* macros for field TIME */
#define XTAL_SETTLE__TIME__SHIFT                                              0
#define XTAL_SETTLE__TIME__WIDTH                                              7
#define XTAL_SETTLE__TIME__MASK                                     0x0000007fU
#define XTAL_SETTLE__TIME__READ(src)             (u_int32_t)(src) & 0x0000007fU
#define XTAL_SETTLE__TIME__WRITE(src)          ((u_int32_t)(src) & 0x0000007fU)
#define XTAL_SETTLE__TIME__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000007fU) | ((u_int32_t)(src) &\
                    0x0000007fU)
#define XTAL_SETTLE__TIME__VERIFY(src)   (!(((u_int32_t)(src) & ~0x0000007fU)))
#define XTAL_SETTLE__TYPE                                             u_int32_t
#define XTAL_SETTLE__READ                                           0x0000007fU
#define XTAL_SETTLE__WRITE                                          0x0000007fU

#endif /* __XTAL_SETTLE_MACRO__ */


/* macros for rtc_reg_block.XTAL_SETTLE */
#define INST_RTC_REG_BLOCK__XTAL_SETTLE__NUM                                  1

/* macros for BlueprintGlobalNameSpace::CLOCK_OUT */
#ifndef __CLOCK_OUT_MACRO__
#define __CLOCK_OUT_MACRO__

/* macros for field SELECT */
#define CLOCK_OUT__SELECT__SHIFT                                              0
#define CLOCK_OUT__SELECT__WIDTH                                              4
#define CLOCK_OUT__SELECT__MASK                                     0x0000000fU
#define CLOCK_OUT__SELECT__READ(src)             (u_int32_t)(src) & 0x0000000fU
#define CLOCK_OUT__SELECT__WRITE(src)          ((u_int32_t)(src) & 0x0000000fU)
#define CLOCK_OUT__SELECT__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000000fU) | ((u_int32_t)(src) &\
                    0x0000000fU)
#define CLOCK_OUT__SELECT__VERIFY(src)   (!(((u_int32_t)(src) & ~0x0000000fU)))

/* macros for field DELAY */
#define CLOCK_OUT__DELAY__SHIFT                                               4
#define CLOCK_OUT__DELAY__WIDTH                                               3
#define CLOCK_OUT__DELAY__MASK                                      0x00000070U
#define CLOCK_OUT__DELAY__READ(src)     (((u_int32_t)(src) & 0x00000070U) >> 4)
#define CLOCK_OUT__DELAY__WRITE(src)    (((u_int32_t)(src) << 4) & 0x00000070U)
#define CLOCK_OUT__DELAY__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000070U) | (((u_int32_t)(src) <<\
                    4) & 0x00000070U)
#define CLOCK_OUT__DELAY__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 4) & ~0x00000070U)))
#define CLOCK_OUT__TYPE                                               u_int32_t
#define CLOCK_OUT__READ                                             0x0000007fU
#define CLOCK_OUT__WRITE                                            0x0000007fU

#endif /* __CLOCK_OUT_MACRO__ */


/* macros for rtc_reg_block.CLOCK_OUT */
#define INST_RTC_REG_BLOCK__CLOCK_OUT__NUM                                    1

/* macros for BlueprintGlobalNameSpace::BIAS_OVERRIDE */
#ifndef __BIAS_OVERRIDE_MACRO__
#define __BIAS_OVERRIDE_MACRO__

/* macros for field ON */
#define BIAS_OVERRIDE__ON__SHIFT                                              0
#define BIAS_OVERRIDE__ON__WIDTH                                              1
#define BIAS_OVERRIDE__ON__MASK                                     0x00000001U
#define BIAS_OVERRIDE__ON__READ(src)             (u_int32_t)(src) & 0x00000001U
#define BIAS_OVERRIDE__ON__WRITE(src)          ((u_int32_t)(src) & 0x00000001U)
#define BIAS_OVERRIDE__ON__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | ((u_int32_t)(src) &\
                    0x00000001U)
#define BIAS_OVERRIDE__ON__VERIFY(src)   (!(((u_int32_t)(src) & ~0x00000001U)))
#define BIAS_OVERRIDE__ON__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(1)
#define BIAS_OVERRIDE__ON__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(0)
#define BIAS_OVERRIDE__TYPE                                           u_int32_t
#define BIAS_OVERRIDE__READ                                         0x00000001U
#define BIAS_OVERRIDE__WRITE                                        0x00000001U

#endif /* __BIAS_OVERRIDE_MACRO__ */


/* macros for rtc_reg_block.BIAS_OVERRIDE */
#define INST_RTC_REG_BLOCK__BIAS_OVERRIDE__NUM                                1

/* macros for BlueprintGlobalNameSpace::RESET_CAUSE */
#ifndef __RESET_CAUSE_MACRO__
#define __RESET_CAUSE_MACRO__

/* macros for field LAST */
#define RESET_CAUSE__LAST__SHIFT                                              0
#define RESET_CAUSE__LAST__WIDTH                                              2
#define RESET_CAUSE__LAST__MASK                                     0x00000003U
#define RESET_CAUSE__LAST__READ(src)             (u_int32_t)(src) & 0x00000003U
#define RESET_CAUSE__TYPE                                             u_int32_t
#define RESET_CAUSE__READ                                           0x00000003U

#endif /* __RESET_CAUSE_MACRO__ */


/* macros for rtc_reg_block.RESET_CAUSE */
#define INST_RTC_REG_BLOCK__RESET_CAUSE__NUM                                  1

/* macros for BlueprintGlobalNameSpace::SYSTEM_SLEEP */
#ifndef __SYSTEM_SLEEP_MACRO__
#define __SYSTEM_SLEEP_MACRO__

/* macros for field DISABLE */
#define SYSTEM_SLEEP__DISABLE__SHIFT                                          0
#define SYSTEM_SLEEP__DISABLE__WIDTH                                          1
#define SYSTEM_SLEEP__DISABLE__MASK                                 0x00000001U
#define SYSTEM_SLEEP__DISABLE__READ(src)         (u_int32_t)(src) & 0x00000001U
#define SYSTEM_SLEEP__DISABLE__WRITE(src)      ((u_int32_t)(src) & 0x00000001U)
#define SYSTEM_SLEEP__DISABLE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | ((u_int32_t)(src) &\
                    0x00000001U)
#define SYSTEM_SLEEP__DISABLE__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00000001U)))
#define SYSTEM_SLEEP__DISABLE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(1)
#define SYSTEM_SLEEP__DISABLE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(0)

/* macros for field LIGHT */
#define SYSTEM_SLEEP__LIGHT__SHIFT                                            1
#define SYSTEM_SLEEP__LIGHT__WIDTH                                            1
#define SYSTEM_SLEEP__LIGHT__MASK                                   0x00000002U
#define SYSTEM_SLEEP__LIGHT__READ(src)  (((u_int32_t)(src) & 0x00000002U) >> 1)
#define SYSTEM_SLEEP__LIGHT__WRITE(src) (((u_int32_t)(src) << 1) & 0x00000002U)
#define SYSTEM_SLEEP__LIGHT__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | (((u_int32_t)(src) <<\
                    1) & 0x00000002U)
#define SYSTEM_SLEEP__LIGHT__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 1) & ~0x00000002U)))
#define SYSTEM_SLEEP__LIGHT__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | ((u_int32_t)(1) << 1)
#define SYSTEM_SLEEP__LIGHT__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | ((u_int32_t)(0) << 1)

/* macros for field MAC_IF */
#define SYSTEM_SLEEP__MAC_IF__SHIFT                                           2
#define SYSTEM_SLEEP__MAC_IF__WIDTH                                           1
#define SYSTEM_SLEEP__MAC_IF__MASK                                  0x00000004U
#define SYSTEM_SLEEP__MAC_IF__READ(src) (((u_int32_t)(src) & 0x00000004U) >> 2)
#define SYSTEM_SLEEP__MAC_IF__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000004U) | ((u_int32_t)(1) << 2)
#define SYSTEM_SLEEP__MAC_IF__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000004U) | ((u_int32_t)(0) << 2)
#define SYSTEM_SLEEP__TYPE                                            u_int32_t
#define SYSTEM_SLEEP__READ                                          0x00000007U
#define SYSTEM_SLEEP__WRITE                                         0x00000007U

#endif /* __SYSTEM_SLEEP_MACRO__ */


/* macros for rtc_reg_block.SYSTEM_SLEEP */
#define INST_RTC_REG_BLOCK__SYSTEM_SLEEP__NUM                                 1

/* macros for BlueprintGlobalNameSpace::MAC_SLEEP_CONTROL */
#ifndef __MAC_SLEEP_CONTROL_MACRO__
#define __MAC_SLEEP_CONTROL_MACRO__

/* macros for field ENABLE */
#define MAC_SLEEP_CONTROL__ENABLE__SHIFT                                      0
#define MAC_SLEEP_CONTROL__ENABLE__WIDTH                                      2
#define MAC_SLEEP_CONTROL__ENABLE__MASK                             0x00000003U
#define MAC_SLEEP_CONTROL__ENABLE__READ(src)     (u_int32_t)(src) & 0x00000003U
#define MAC_SLEEP_CONTROL__ENABLE__WRITE(src)  ((u_int32_t)(src) & 0x00000003U)
#define MAC_SLEEP_CONTROL__ENABLE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000003U) | ((u_int32_t)(src) &\
                    0x00000003U)
#define MAC_SLEEP_CONTROL__ENABLE__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00000003U)))
#define MAC_SLEEP_CONTROL__TYPE                                       u_int32_t
#define MAC_SLEEP_CONTROL__READ                                     0x00000003U
#define MAC_SLEEP_CONTROL__WRITE                                    0x00000003U

#endif /* __MAC_SLEEP_CONTROL_MACRO__ */


/* macros for rtc_reg_block.MAC_SLEEP_CONTROL */
#define INST_RTC_REG_BLOCK__MAC_SLEEP_CONTROL__NUM                            1

/* macros for BlueprintGlobalNameSpace::KEEP_AWAKE */
#ifndef __KEEP_AWAKE_MACRO__
#define __KEEP_AWAKE_MACRO__

/* macros for field COUNT */
#define KEEP_AWAKE__COUNT__SHIFT                                              0
#define KEEP_AWAKE__COUNT__WIDTH                                              8
#define KEEP_AWAKE__COUNT__MASK                                     0x000000ffU
#define KEEP_AWAKE__COUNT__READ(src)             (u_int32_t)(src) & 0x000000ffU
#define KEEP_AWAKE__COUNT__WRITE(src)          ((u_int32_t)(src) & 0x000000ffU)
#define KEEP_AWAKE__COUNT__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000000ffU) | ((u_int32_t)(src) &\
                    0x000000ffU)
#define KEEP_AWAKE__COUNT__VERIFY(src)   (!(((u_int32_t)(src) & ~0x000000ffU)))
#define KEEP_AWAKE__TYPE                                              u_int32_t
#define KEEP_AWAKE__READ                                            0x000000ffU
#define KEEP_AWAKE__WRITE                                           0x000000ffU

#endif /* __KEEP_AWAKE_MACRO__ */


/* macros for rtc_reg_block.KEEP_AWAKE */
#define INST_RTC_REG_BLOCK__KEEP_AWAKE__NUM                                   1

/* macros for BlueprintGlobalNameSpace::DERIVED_RTC_CLK */
#ifndef __DERIVED_RTC_CLK_MACRO__
#define __DERIVED_RTC_CLK_MACRO__

/* macros for field PERIOD */
#define DERIVED_RTC_CLK__PERIOD__SHIFT                                        1
#define DERIVED_RTC_CLK__PERIOD__WIDTH                                       15
#define DERIVED_RTC_CLK__PERIOD__MASK                               0x0000fffeU
#define DERIVED_RTC_CLK__PERIOD__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0000fffeU) >> 1)
#define DERIVED_RTC_CLK__PERIOD__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 1) & 0x0000fffeU)
#define DERIVED_RTC_CLK__PERIOD__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000fffeU) | (((u_int32_t)(src) <<\
                    1) & 0x0000fffeU)
#define DERIVED_RTC_CLK__PERIOD__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 1) & ~0x0000fffeU)))

/* macros for field EXTERNAL_DETECT */
#define DERIVED_RTC_CLK__EXTERNAL_DETECT__SHIFT                              18
#define DERIVED_RTC_CLK__EXTERNAL_DETECT__WIDTH                               1
#define DERIVED_RTC_CLK__EXTERNAL_DETECT__MASK                      0x00040000U
#define DERIVED_RTC_CLK__EXTERNAL_DETECT__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00040000U) >> 18)
#define DERIVED_RTC_CLK__EXTERNAL_DETECT__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00040000U) | ((u_int32_t)(1) << 18)
#define DERIVED_RTC_CLK__EXTERNAL_DETECT__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00040000U) | ((u_int32_t)(0) << 18)
#define DERIVED_RTC_CLK__TYPE                                         u_int32_t
#define DERIVED_RTC_CLK__READ                                       0x0004fffeU
#define DERIVED_RTC_CLK__WRITE                                      0x0004fffeU

#endif /* __DERIVED_RTC_CLK_MACRO__ */


/* macros for rtc_reg_block.DERIVED_RTC_CLK */
#define INST_RTC_REG_BLOCK__DERIVED_RTC_CLK__NUM                              1

/* macros for BlueprintGlobalNameSpace::PLL_CONTROL2 */
#ifndef __PLL_CONTROL2_MACRO__
#define __PLL_CONTROL2_MACRO__

/* macros for field DIV_INT */
#define PLL_CONTROL2__DIV_INT__SHIFT                                          0
#define PLL_CONTROL2__DIV_INT__WIDTH                                          3
#define PLL_CONTROL2__DIV_INT__MASK                                 0x00000007U
#define PLL_CONTROL2__DIV_INT__READ(src)         (u_int32_t)(src) & 0x00000007U
#define PLL_CONTROL2__DIV_INT__WRITE(src)      ((u_int32_t)(src) & 0x00000007U)
#define PLL_CONTROL2__DIV_INT__MODIFY(dst, src) \
    (dst) = ((dst) &\
            ~0x00000007U) | ((u_int32_t)(src) &\
                0x00000007U)
#define PLL_CONTROL2__DIV_INT__VERIFY(src) \
    (!(((u_int32_t)(src)\
        & ~0x00000007U)))

/* macros for field DIV_FRAC */
#define PLL_CONTROL2__DIV_FRAC__SHIFT                                         3
#define PLL_CONTROL2__DIV_FRAC__WIDTH                                         4
#define PLL_CONTROL2__DIV_FRAC__MASK                                0x00000078U
#define PLL_CONTROL2__DIV_FRAC__READ(src) \
    (((u_int32_t)(src)\
      & 0x00000078U) >> 3)
#define PLL_CONTROL2__DIV_FRAC__WRITE(src) \
    (((u_int32_t)(src)\
      << 3) & 0x00000078U)
#define PLL_CONTROL2__DIV_FRAC__MODIFY(dst, src) \
    (dst) = ((dst) &\
            ~0x00000078U) | (((u_int32_t)(src) <<\
                    3) & 0x00000078U)
#define PLL_CONTROL2__DIV_FRAC__VERIFY(src) \
    (!((((u_int32_t)(src)\
         << 3) & ~0x00000078U)))
#define PLL_CONTROL2__TYPE                                            u_int32_t
#define PLL_CONTROL2__READ                                          0x0000007fU
#define PLL_CONTROL2__WRITE                                         0x0000007fU

#endif /* __PLL_CONTROL2_MACRO__ */


/* macros for rtc_reg_block.PLL_CONTROL2 */
#define INST_RTC_REG_BLOCK__PLL_CONTROL2__NUM                                 1

/* macros for BlueprintGlobalNameSpace::RTC_SYNC_RESET */
#ifndef __RTC_SYNC_RESET_MACRO__
#define __RTC_SYNC_RESET_MACRO__

/* macros for field RESET_L */
#define RTC_SYNC_RESET__RESET_L__SHIFT                                        0
#define RTC_SYNC_RESET__RESET_L__WIDTH                                        1
#define RTC_SYNC_RESET__RESET_L__MASK                               0x00000001U
#define RTC_SYNC_RESET__RESET_L__READ(src)       (u_int32_t)(src) & 0x00000001U
#define RTC_SYNC_RESET__RESET_L__WRITE(src)    ((u_int32_t)(src) & 0x00000001U)
#define RTC_SYNC_RESET__RESET_L__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | ((u_int32_t)(src) &\
                    0x00000001U)
#define RTC_SYNC_RESET__RESET_L__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00000001U)))
#define RTC_SYNC_RESET__RESET_L__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(1)
#define RTC_SYNC_RESET__RESET_L__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(0)
#define RTC_SYNC_RESET__TYPE                                          u_int32_t
#define RTC_SYNC_RESET__READ                                        0x00000001U
#define RTC_SYNC_RESET__WRITE                                       0x00000001U

#endif /* __RTC_SYNC_RESET_MACRO__ */


/* macros for rtc_sync_reg_block.RTC_SYNC_RESET */
#define INST_RTC_SYNC_REG_BLOCK__RTC_SYNC_RESET__NUM                          1

/* macros for BlueprintGlobalNameSpace::RTC_SYNC_STATUS */
#ifndef __RTC_SYNC_STATUS_MACRO__
#define __RTC_SYNC_STATUS_MACRO__

/* macros for field SHUTDOWN_STATE */
#define RTC_SYNC_STATUS__SHUTDOWN_STATE__SHIFT                                0
#define RTC_SYNC_STATUS__SHUTDOWN_STATE__WIDTH                                1
#define RTC_SYNC_STATUS__SHUTDOWN_STATE__MASK                       0x00000001U
#define RTC_SYNC_STATUS__SHUTDOWN_STATE__READ(src) \
                    (u_int32_t)(src)\
                    & 0x00000001U
#define RTC_SYNC_STATUS__SHUTDOWN_STATE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(1)
#define RTC_SYNC_STATUS__SHUTDOWN_STATE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(0)

/* macros for field ON_STATE */
#define RTC_SYNC_STATUS__ON_STATE__SHIFT                                      1
#define RTC_SYNC_STATUS__ON_STATE__WIDTH                                      1
#define RTC_SYNC_STATUS__ON_STATE__MASK                             0x00000002U
#define RTC_SYNC_STATUS__ON_STATE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000002U) >> 1)
#define RTC_SYNC_STATUS__ON_STATE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | ((u_int32_t)(1) << 1)
#define RTC_SYNC_STATUS__ON_STATE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | ((u_int32_t)(0) << 1)

/* macros for field SLEEP_STATE */
#define RTC_SYNC_STATUS__SLEEP_STATE__SHIFT                                   2
#define RTC_SYNC_STATUS__SLEEP_STATE__WIDTH                                   1
#define RTC_SYNC_STATUS__SLEEP_STATE__MASK                          0x00000004U
#define RTC_SYNC_STATUS__SLEEP_STATE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000004U) >> 2)
#define RTC_SYNC_STATUS__SLEEP_STATE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000004U) | ((u_int32_t)(1) << 2)
#define RTC_SYNC_STATUS__SLEEP_STATE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000004U) | ((u_int32_t)(0) << 2)

/* macros for field WAKEUP_STATE */
#define RTC_SYNC_STATUS__WAKEUP_STATE__SHIFT                                  3
#define RTC_SYNC_STATUS__WAKEUP_STATE__WIDTH                                  1
#define RTC_SYNC_STATUS__WAKEUP_STATE__MASK                         0x00000008U
#define RTC_SYNC_STATUS__WAKEUP_STATE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000008U) >> 3)
#define RTC_SYNC_STATUS__WAKEUP_STATE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000008U) | ((u_int32_t)(1) << 3)
#define RTC_SYNC_STATUS__WAKEUP_STATE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000008U) | ((u_int32_t)(0) << 3)

/* macros for field WRESET */
#define RTC_SYNC_STATUS__WRESET__SHIFT                                        4
#define RTC_SYNC_STATUS__WRESET__WIDTH                                        1
#define RTC_SYNC_STATUS__WRESET__MASK                               0x00000010U
#define RTC_SYNC_STATUS__WRESET__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000010U) >> 4)
#define RTC_SYNC_STATUS__WRESET__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000010U) | ((u_int32_t)(1) << 4)
#define RTC_SYNC_STATUS__WRESET__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000010U) | ((u_int32_t)(0) << 4)

/* macros for field PLL_CHANGING */
#define RTC_SYNC_STATUS__PLL_CHANGING__SHIFT                                  5
#define RTC_SYNC_STATUS__PLL_CHANGING__WIDTH                                  1
#define RTC_SYNC_STATUS__PLL_CHANGING__MASK                         0x00000020U
#define RTC_SYNC_STATUS__PLL_CHANGING__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000020U) >> 5)
#define RTC_SYNC_STATUS__PLL_CHANGING__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000020U) | ((u_int32_t)(1) << 5)
#define RTC_SYNC_STATUS__PLL_CHANGING__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000020U) | ((u_int32_t)(0) << 5)
#define RTC_SYNC_STATUS__TYPE                                         u_int32_t
#define RTC_SYNC_STATUS__READ                                       0x0000003fU

#endif /* __RTC_SYNC_STATUS_MACRO__ */


/* macros for rtc_sync_reg_block.RTC_SYNC_STATUS */
#define INST_RTC_SYNC_REG_BLOCK__RTC_SYNC_STATUS__NUM                         1

/* macros for BlueprintGlobalNameSpace::RTC_SYNC_DERIVED */
#ifndef __RTC_SYNC_DERIVED_MACRO__
#define __RTC_SYNC_DERIVED_MACRO__

/* macros for field BYPASS */
#define RTC_SYNC_DERIVED__BYPASS__SHIFT                                       0
#define RTC_SYNC_DERIVED__BYPASS__WIDTH                                       1
#define RTC_SYNC_DERIVED__BYPASS__MASK                              0x00000001U
#define RTC_SYNC_DERIVED__BYPASS__READ(src)      (u_int32_t)(src) & 0x00000001U
#define RTC_SYNC_DERIVED__BYPASS__WRITE(src)   ((u_int32_t)(src) & 0x00000001U)
#define RTC_SYNC_DERIVED__BYPASS__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | ((u_int32_t)(src) &\
                    0x00000001U)
#define RTC_SYNC_DERIVED__BYPASS__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00000001U)))
#define RTC_SYNC_DERIVED__BYPASS__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(1)
#define RTC_SYNC_DERIVED__BYPASS__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(0)

/* macros for field FORCE */
#define RTC_SYNC_DERIVED__FORCE__SHIFT                                        1
#define RTC_SYNC_DERIVED__FORCE__WIDTH                                        1
#define RTC_SYNC_DERIVED__FORCE__MASK                               0x00000002U
#define RTC_SYNC_DERIVED__FORCE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000002U) >> 1)
#define RTC_SYNC_DERIVED__FORCE__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 1) & 0x00000002U)
#define RTC_SYNC_DERIVED__FORCE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | (((u_int32_t)(src) <<\
                    1) & 0x00000002U)
#define RTC_SYNC_DERIVED__FORCE__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 1) & ~0x00000002U)))
#define RTC_SYNC_DERIVED__FORCE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | ((u_int32_t)(1) << 1)
#define RTC_SYNC_DERIVED__FORCE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | ((u_int32_t)(0) << 1)

/* macros for field FORCE_SWREG_PWD */
#define RTC_SYNC_DERIVED__FORCE_SWREG_PWD__SHIFT                              2
#define RTC_SYNC_DERIVED__FORCE_SWREG_PWD__WIDTH                              1
#define RTC_SYNC_DERIVED__FORCE_SWREG_PWD__MASK                     0x00000004U
#define RTC_SYNC_DERIVED__FORCE_SWREG_PWD__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 2) & 0x00000004U)
#define RTC_SYNC_DERIVED__FORCE_SWREG_PWD__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000004U) | (((u_int32_t)(src) <<\
                    2) & 0x00000004U)
#define RTC_SYNC_DERIVED__FORCE_SWREG_PWD__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 2) & ~0x00000004U)))
#define RTC_SYNC_DERIVED__FORCE_SWREG_PWD__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000004U) | ((u_int32_t)(1) << 2)
#define RTC_SYNC_DERIVED__FORCE_SWREG_PWD__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000004U) | ((u_int32_t)(0) << 2)

/* macros for field FORCE_LPO_PWD */
#define RTC_SYNC_DERIVED__FORCE_LPO_PWD__SHIFT                                3
#define RTC_SYNC_DERIVED__FORCE_LPO_PWD__WIDTH                                1
#define RTC_SYNC_DERIVED__FORCE_LPO_PWD__MASK                       0x00000008U
#define RTC_SYNC_DERIVED__FORCE_LPO_PWD__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 3) & 0x00000008U)
#define RTC_SYNC_DERIVED__FORCE_LPO_PWD__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000008U) | (((u_int32_t)(src) <<\
                    3) & 0x00000008U)
#define RTC_SYNC_DERIVED__FORCE_LPO_PWD__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 3) & ~0x00000008U)))
#define RTC_SYNC_DERIVED__FORCE_LPO_PWD__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000008U) | ((u_int32_t)(1) << 3)
#define RTC_SYNC_DERIVED__FORCE_LPO_PWD__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000008U) | ((u_int32_t)(0) << 3)
#define RTC_SYNC_DERIVED__TYPE                                        u_int32_t
#define RTC_SYNC_DERIVED__READ                                      0x00000003U
#define RTC_SYNC_DERIVED__WRITE                                     0x00000003U

#endif /* __RTC_SYNC_DERIVED_MACRO__ */


/* macros for rtc_sync_reg_block.RTC_SYNC_DERIVED */
#define INST_RTC_SYNC_REG_BLOCK__RTC_SYNC_DERIVED__NUM                        1

/* macros for BlueprintGlobalNameSpace::RTC_SYNC_FORCE_WAKE */
#ifndef __RTC_SYNC_FORCE_WAKE_MACRO__
#define __RTC_SYNC_FORCE_WAKE_MACRO__

/* macros for field ENABLE */
#define RTC_SYNC_FORCE_WAKE__ENABLE__SHIFT                                    0
#define RTC_SYNC_FORCE_WAKE__ENABLE__WIDTH                                    1
#define RTC_SYNC_FORCE_WAKE__ENABLE__MASK                           0x00000001U
#define RTC_SYNC_FORCE_WAKE__ENABLE__READ(src)   (u_int32_t)(src) & 0x00000001U
#define RTC_SYNC_FORCE_WAKE__ENABLE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(1)
#define RTC_SYNC_FORCE_WAKE__ENABLE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(0)

/* macros for field INTR */
#define RTC_SYNC_FORCE_WAKE__INTR__SHIFT                                      1
#define RTC_SYNC_FORCE_WAKE__INTR__WIDTH                                      1
#define RTC_SYNC_FORCE_WAKE__INTR__MASK                             0x00000002U
#define RTC_SYNC_FORCE_WAKE__INTR__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000002U) >> 1)
#define RTC_SYNC_FORCE_WAKE__INTR__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 1) & 0x00000002U)
#define RTC_SYNC_FORCE_WAKE__INTR__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | (((u_int32_t)(src) <<\
                    1) & 0x00000002U)
#define RTC_SYNC_FORCE_WAKE__INTR__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 1) & ~0x00000002U)))
#define RTC_SYNC_FORCE_WAKE__INTR__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | ((u_int32_t)(1) << 1)
#define RTC_SYNC_FORCE_WAKE__INTR__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | ((u_int32_t)(0) << 1)
#define RTC_SYNC_FORCE_WAKE__TYPE                                     u_int32_t
#define RTC_SYNC_FORCE_WAKE__READ                                   0x00000003U
#define RTC_SYNC_FORCE_WAKE__WRITE                                  0x00000003U

#endif /* __RTC_SYNC_FORCE_WAKE_MACRO__ */


/* macros for rtc_sync_reg_block.RTC_SYNC_FORCE_WAKE */
#define INST_RTC_SYNC_REG_BLOCK__RTC_SYNC_FORCE_WAKE__NUM                     1

/* macros for BlueprintGlobalNameSpace::RTC_SYNC_INTR_CAUSE */
#ifndef __RTC_SYNC_INTR_CAUSE_MACRO__
#define __RTC_SYNC_INTR_CAUSE_MACRO__

/* macros for field SHUTDOWN_STATE */
#define RTC_SYNC_INTR_CAUSE__SHUTDOWN_STATE__SHIFT                            0
#define RTC_SYNC_INTR_CAUSE__SHUTDOWN_STATE__WIDTH                            1
#define RTC_SYNC_INTR_CAUSE__SHUTDOWN_STATE__MASK                   0x00000001U
#define RTC_SYNC_INTR_CAUSE__SHUTDOWN_STATE__READ(src) \
                    (u_int32_t)(src)\
                    & 0x00000001U
#define RTC_SYNC_INTR_CAUSE__SHUTDOWN_STATE__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x00000001U)
#define RTC_SYNC_INTR_CAUSE__SHUTDOWN_STATE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | ((u_int32_t)(src) &\
                    0x00000001U)
#define RTC_SYNC_INTR_CAUSE__SHUTDOWN_STATE__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00000001U)))
#define RTC_SYNC_INTR_CAUSE__SHUTDOWN_STATE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(1)
#define RTC_SYNC_INTR_CAUSE__SHUTDOWN_STATE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(0)

/* macros for field ON_STATE */
#define RTC_SYNC_INTR_CAUSE__ON_STATE__SHIFT                                  1
#define RTC_SYNC_INTR_CAUSE__ON_STATE__WIDTH                                  1
#define RTC_SYNC_INTR_CAUSE__ON_STATE__MASK                         0x00000002U
#define RTC_SYNC_INTR_CAUSE__ON_STATE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000002U) >> 1)
#define RTC_SYNC_INTR_CAUSE__ON_STATE__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 1) & 0x00000002U)
#define RTC_SYNC_INTR_CAUSE__ON_STATE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | (((u_int32_t)(src) <<\
                    1) & 0x00000002U)
#define RTC_SYNC_INTR_CAUSE__ON_STATE__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 1) & ~0x00000002U)))
#define RTC_SYNC_INTR_CAUSE__ON_STATE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | ((u_int32_t)(1) << 1)
#define RTC_SYNC_INTR_CAUSE__ON_STATE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | ((u_int32_t)(0) << 1)

/* macros for field SLEEP_STATE */
#define RTC_SYNC_INTR_CAUSE__SLEEP_STATE__SHIFT                               2
#define RTC_SYNC_INTR_CAUSE__SLEEP_STATE__WIDTH                               1
#define RTC_SYNC_INTR_CAUSE__SLEEP_STATE__MASK                      0x00000004U
#define RTC_SYNC_INTR_CAUSE__SLEEP_STATE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000004U) >> 2)
#define RTC_SYNC_INTR_CAUSE__SLEEP_STATE__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 2) & 0x00000004U)
#define RTC_SYNC_INTR_CAUSE__SLEEP_STATE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000004U) | (((u_int32_t)(src) <<\
                    2) & 0x00000004U)
#define RTC_SYNC_INTR_CAUSE__SLEEP_STATE__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 2) & ~0x00000004U)))
#define RTC_SYNC_INTR_CAUSE__SLEEP_STATE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000004U) | ((u_int32_t)(1) << 2)
#define RTC_SYNC_INTR_CAUSE__SLEEP_STATE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000004U) | ((u_int32_t)(0) << 2)

/* macros for field WAKEUP_STATE */
#define RTC_SYNC_INTR_CAUSE__WAKEUP_STATE__SHIFT                              3
#define RTC_SYNC_INTR_CAUSE__WAKEUP_STATE__WIDTH                              1
#define RTC_SYNC_INTR_CAUSE__WAKEUP_STATE__MASK                     0x00000008U
#define RTC_SYNC_INTR_CAUSE__WAKEUP_STATE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000008U) >> 3)
#define RTC_SYNC_INTR_CAUSE__WAKEUP_STATE__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 3) & 0x00000008U)
#define RTC_SYNC_INTR_CAUSE__WAKEUP_STATE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000008U) | (((u_int32_t)(src) <<\
                    3) & 0x00000008U)
#define RTC_SYNC_INTR_CAUSE__WAKEUP_STATE__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 3) & ~0x00000008U)))
#define RTC_SYNC_INTR_CAUSE__WAKEUP_STATE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000008U) | ((u_int32_t)(1) << 3)
#define RTC_SYNC_INTR_CAUSE__WAKEUP_STATE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000008U) | ((u_int32_t)(0) << 3)

/* macros for field SLEEP_ACCESS */
#define RTC_SYNC_INTR_CAUSE__SLEEP_ACCESS__SHIFT                              4
#define RTC_SYNC_INTR_CAUSE__SLEEP_ACCESS__WIDTH                              1
#define RTC_SYNC_INTR_CAUSE__SLEEP_ACCESS__MASK                     0x00000010U
#define RTC_SYNC_INTR_CAUSE__SLEEP_ACCESS__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000010U) >> 4)
#define RTC_SYNC_INTR_CAUSE__SLEEP_ACCESS__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 4) & 0x00000010U)
#define RTC_SYNC_INTR_CAUSE__SLEEP_ACCESS__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000010U) | (((u_int32_t)(src) <<\
                    4) & 0x00000010U)
#define RTC_SYNC_INTR_CAUSE__SLEEP_ACCESS__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 4) & ~0x00000010U)))
#define RTC_SYNC_INTR_CAUSE__SLEEP_ACCESS__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000010U) | ((u_int32_t)(1) << 4)
#define RTC_SYNC_INTR_CAUSE__SLEEP_ACCESS__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000010U) | ((u_int32_t)(0) << 4)

/* macros for field PLL_CHANGING */
#define RTC_SYNC_INTR_CAUSE__PLL_CHANGING__SHIFT                              5
#define RTC_SYNC_INTR_CAUSE__PLL_CHANGING__WIDTH                              1
#define RTC_SYNC_INTR_CAUSE__PLL_CHANGING__MASK                     0x00000020U
#define RTC_SYNC_INTR_CAUSE__PLL_CHANGING__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000020U) >> 5)
#define RTC_SYNC_INTR_CAUSE__PLL_CHANGING__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 5) & 0x00000020U)
#define RTC_SYNC_INTR_CAUSE__PLL_CHANGING__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000020U) | (((u_int32_t)(src) <<\
                    5) & 0x00000020U)
#define RTC_SYNC_INTR_CAUSE__PLL_CHANGING__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 5) & ~0x00000020U)))
#define RTC_SYNC_INTR_CAUSE__PLL_CHANGING__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000020U) | ((u_int32_t)(1) << 5)
#define RTC_SYNC_INTR_CAUSE__PLL_CHANGING__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000020U) | ((u_int32_t)(0) << 5)
#define RTC_SYNC_INTR_CAUSE__TYPE                                     u_int32_t
#define RTC_SYNC_INTR_CAUSE__READ                                   0x0000003fU
#define RTC_SYNC_INTR_CAUSE__WRITE                                  0x0000003fU

#endif /* __RTC_SYNC_INTR_CAUSE_MACRO__ */


/* macros for rtc_sync_reg_block.RTC_SYNC_INTR_CAUSE */
#define INST_RTC_SYNC_REG_BLOCK__RTC_SYNC_INTR_CAUSE__NUM                     1

/* macros for BlueprintGlobalNameSpace::RTC_SYNC_INTR_ENABLE */
#ifndef __RTC_SYNC_INTR_ENABLE_MACRO__
#define __RTC_SYNC_INTR_ENABLE_MACRO__

/* macros for field SHUTDOWN_STATE */
#define RTC_SYNC_INTR_ENABLE__SHUTDOWN_STATE__SHIFT                           0
#define RTC_SYNC_INTR_ENABLE__SHUTDOWN_STATE__WIDTH                           1
#define RTC_SYNC_INTR_ENABLE__SHUTDOWN_STATE__MASK                  0x00000001U
#define RTC_SYNC_INTR_ENABLE__SHUTDOWN_STATE__READ(src) \
                    (u_int32_t)(src)\
                    & 0x00000001U
#define RTC_SYNC_INTR_ENABLE__SHUTDOWN_STATE__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x00000001U)
#define RTC_SYNC_INTR_ENABLE__SHUTDOWN_STATE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | ((u_int32_t)(src) &\
                    0x00000001U)
#define RTC_SYNC_INTR_ENABLE__SHUTDOWN_STATE__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00000001U)))
#define RTC_SYNC_INTR_ENABLE__SHUTDOWN_STATE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(1)
#define RTC_SYNC_INTR_ENABLE__SHUTDOWN_STATE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(0)

/* macros for field ON_STATE */
#define RTC_SYNC_INTR_ENABLE__ON_STATE__SHIFT                                 1
#define RTC_SYNC_INTR_ENABLE__ON_STATE__WIDTH                                 1
#define RTC_SYNC_INTR_ENABLE__ON_STATE__MASK                        0x00000002U
#define RTC_SYNC_INTR_ENABLE__ON_STATE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000002U) >> 1)
#define RTC_SYNC_INTR_ENABLE__ON_STATE__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 1) & 0x00000002U)
#define RTC_SYNC_INTR_ENABLE__ON_STATE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | (((u_int32_t)(src) <<\
                    1) & 0x00000002U)
#define RTC_SYNC_INTR_ENABLE__ON_STATE__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 1) & ~0x00000002U)))
#define RTC_SYNC_INTR_ENABLE__ON_STATE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | ((u_int32_t)(1) << 1)
#define RTC_SYNC_INTR_ENABLE__ON_STATE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | ((u_int32_t)(0) << 1)

/* macros for field SLEEP_STATE */
#define RTC_SYNC_INTR_ENABLE__SLEEP_STATE__SHIFT                              2
#define RTC_SYNC_INTR_ENABLE__SLEEP_STATE__WIDTH                              1
#define RTC_SYNC_INTR_ENABLE__SLEEP_STATE__MASK                     0x00000004U
#define RTC_SYNC_INTR_ENABLE__SLEEP_STATE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000004U) >> 2)
#define RTC_SYNC_INTR_ENABLE__SLEEP_STATE__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 2) & 0x00000004U)
#define RTC_SYNC_INTR_ENABLE__SLEEP_STATE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000004U) | (((u_int32_t)(src) <<\
                    2) & 0x00000004U)
#define RTC_SYNC_INTR_ENABLE__SLEEP_STATE__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 2) & ~0x00000004U)))
#define RTC_SYNC_INTR_ENABLE__SLEEP_STATE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000004U) | ((u_int32_t)(1) << 2)
#define RTC_SYNC_INTR_ENABLE__SLEEP_STATE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000004U) | ((u_int32_t)(0) << 2)

/* macros for field WAKEUP_STATE */
#define RTC_SYNC_INTR_ENABLE__WAKEUP_STATE__SHIFT                             3
#define RTC_SYNC_INTR_ENABLE__WAKEUP_STATE__WIDTH                             1
#define RTC_SYNC_INTR_ENABLE__WAKEUP_STATE__MASK                    0x00000008U
#define RTC_SYNC_INTR_ENABLE__WAKEUP_STATE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000008U) >> 3)
#define RTC_SYNC_INTR_ENABLE__WAKEUP_STATE__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 3) & 0x00000008U)
#define RTC_SYNC_INTR_ENABLE__WAKEUP_STATE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000008U) | (((u_int32_t)(src) <<\
                    3) & 0x00000008U)
#define RTC_SYNC_INTR_ENABLE__WAKEUP_STATE__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 3) & ~0x00000008U)))
#define RTC_SYNC_INTR_ENABLE__WAKEUP_STATE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000008U) | ((u_int32_t)(1) << 3)
#define RTC_SYNC_INTR_ENABLE__WAKEUP_STATE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000008U) | ((u_int32_t)(0) << 3)

/* macros for field SLEEP_ACCESS */
#define RTC_SYNC_INTR_ENABLE__SLEEP_ACCESS__SHIFT                             4
#define RTC_SYNC_INTR_ENABLE__SLEEP_ACCESS__WIDTH                             1
#define RTC_SYNC_INTR_ENABLE__SLEEP_ACCESS__MASK                    0x00000010U
#define RTC_SYNC_INTR_ENABLE__SLEEP_ACCESS__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000010U) >> 4)
#define RTC_SYNC_INTR_ENABLE__SLEEP_ACCESS__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 4) & 0x00000010U)
#define RTC_SYNC_INTR_ENABLE__SLEEP_ACCESS__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000010U) | (((u_int32_t)(src) <<\
                    4) & 0x00000010U)
#define RTC_SYNC_INTR_ENABLE__SLEEP_ACCESS__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 4) & ~0x00000010U)))
#define RTC_SYNC_INTR_ENABLE__SLEEP_ACCESS__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000010U) | ((u_int32_t)(1) << 4)
#define RTC_SYNC_INTR_ENABLE__SLEEP_ACCESS__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000010U) | ((u_int32_t)(0) << 4)

/* macros for field PLL_CHANGING */
#define RTC_SYNC_INTR_ENABLE__PLL_CHANGING__SHIFT                             5
#define RTC_SYNC_INTR_ENABLE__PLL_CHANGING__WIDTH                             1
#define RTC_SYNC_INTR_ENABLE__PLL_CHANGING__MASK                    0x00000020U
#define RTC_SYNC_INTR_ENABLE__PLL_CHANGING__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000020U) >> 5)
#define RTC_SYNC_INTR_ENABLE__PLL_CHANGING__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 5) & 0x00000020U)
#define RTC_SYNC_INTR_ENABLE__PLL_CHANGING__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000020U) | (((u_int32_t)(src) <<\
                    5) & 0x00000020U)
#define RTC_SYNC_INTR_ENABLE__PLL_CHANGING__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 5) & ~0x00000020U)))
#define RTC_SYNC_INTR_ENABLE__PLL_CHANGING__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000020U) | ((u_int32_t)(1) << 5)
#define RTC_SYNC_INTR_ENABLE__PLL_CHANGING__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000020U) | ((u_int32_t)(0) << 5)
#define RTC_SYNC_INTR_ENABLE__TYPE                                    u_int32_t
#define RTC_SYNC_INTR_ENABLE__READ                                  0x0000003fU
#define RTC_SYNC_INTR_ENABLE__WRITE                                 0x0000003fU

#endif /* __RTC_SYNC_INTR_ENABLE_MACRO__ */


/* macros for rtc_sync_reg_block.RTC_SYNC_INTR_ENABLE */
#define INST_RTC_SYNC_REG_BLOCK__RTC_SYNC_INTR_ENABLE__NUM                    1

/* macros for BlueprintGlobalNameSpace::RTC_SYNC_INTR_MASK */
#ifndef __RTC_SYNC_INTR_MASK_MACRO__
#define __RTC_SYNC_INTR_MASK_MACRO__

/* macros for field SHUTDOWN_STATE */
#define RTC_SYNC_INTR_MASK__SHUTDOWN_STATE__SHIFT                             0
#define RTC_SYNC_INTR_MASK__SHUTDOWN_STATE__WIDTH                             1
#define RTC_SYNC_INTR_MASK__SHUTDOWN_STATE__MASK                    0x00000001U
#define RTC_SYNC_INTR_MASK__SHUTDOWN_STATE__READ(src) \
                    (u_int32_t)(src)\
                    & 0x00000001U
#define RTC_SYNC_INTR_MASK__SHUTDOWN_STATE__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x00000001U)
#define RTC_SYNC_INTR_MASK__SHUTDOWN_STATE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | ((u_int32_t)(src) &\
                    0x00000001U)
#define RTC_SYNC_INTR_MASK__SHUTDOWN_STATE__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00000001U)))
#define RTC_SYNC_INTR_MASK__SHUTDOWN_STATE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(1)
#define RTC_SYNC_INTR_MASK__SHUTDOWN_STATE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(0)

/* macros for field ON_STATE */
#define RTC_SYNC_INTR_MASK__ON_STATE__SHIFT                                   1
#define RTC_SYNC_INTR_MASK__ON_STATE__WIDTH                                   1
#define RTC_SYNC_INTR_MASK__ON_STATE__MASK                          0x00000002U
#define RTC_SYNC_INTR_MASK__ON_STATE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000002U) >> 1)
#define RTC_SYNC_INTR_MASK__ON_STATE__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 1) & 0x00000002U)
#define RTC_SYNC_INTR_MASK__ON_STATE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | (((u_int32_t)(src) <<\
                    1) & 0x00000002U)
#define RTC_SYNC_INTR_MASK__ON_STATE__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 1) & ~0x00000002U)))
#define RTC_SYNC_INTR_MASK__ON_STATE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | ((u_int32_t)(1) << 1)
#define RTC_SYNC_INTR_MASK__ON_STATE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | ((u_int32_t)(0) << 1)

/* macros for field SLEEP_STATE */
#define RTC_SYNC_INTR_MASK__SLEEP_STATE__SHIFT                                2
#define RTC_SYNC_INTR_MASK__SLEEP_STATE__WIDTH                                1
#define RTC_SYNC_INTR_MASK__SLEEP_STATE__MASK                       0x00000004U
#define RTC_SYNC_INTR_MASK__SLEEP_STATE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000004U) >> 2)
#define RTC_SYNC_INTR_MASK__SLEEP_STATE__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 2) & 0x00000004U)
#define RTC_SYNC_INTR_MASK__SLEEP_STATE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000004U) | (((u_int32_t)(src) <<\
                    2) & 0x00000004U)
#define RTC_SYNC_INTR_MASK__SLEEP_STATE__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 2) & ~0x00000004U)))
#define RTC_SYNC_INTR_MASK__SLEEP_STATE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000004U) | ((u_int32_t)(1) << 2)
#define RTC_SYNC_INTR_MASK__SLEEP_STATE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000004U) | ((u_int32_t)(0) << 2)

/* macros for field WAKEUP_STATE */
#define RTC_SYNC_INTR_MASK__WAKEUP_STATE__SHIFT                               3
#define RTC_SYNC_INTR_MASK__WAKEUP_STATE__WIDTH                               1
#define RTC_SYNC_INTR_MASK__WAKEUP_STATE__MASK                      0x00000008U
#define RTC_SYNC_INTR_MASK__WAKEUP_STATE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000008U) >> 3)
#define RTC_SYNC_INTR_MASK__WAKEUP_STATE__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 3) & 0x00000008U)
#define RTC_SYNC_INTR_MASK__WAKEUP_STATE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000008U) | (((u_int32_t)(src) <<\
                    3) & 0x00000008U)
#define RTC_SYNC_INTR_MASK__WAKEUP_STATE__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 3) & ~0x00000008U)))
#define RTC_SYNC_INTR_MASK__WAKEUP_STATE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000008U) | ((u_int32_t)(1) << 3)
#define RTC_SYNC_INTR_MASK__WAKEUP_STATE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000008U) | ((u_int32_t)(0) << 3)

/* macros for field SLEEP_ACCESS */
#define RTC_SYNC_INTR_MASK__SLEEP_ACCESS__SHIFT                               4
#define RTC_SYNC_INTR_MASK__SLEEP_ACCESS__WIDTH                               1
#define RTC_SYNC_INTR_MASK__SLEEP_ACCESS__MASK                      0x00000010U
#define RTC_SYNC_INTR_MASK__SLEEP_ACCESS__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000010U) >> 4)
#define RTC_SYNC_INTR_MASK__SLEEP_ACCESS__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 4) & 0x00000010U)
#define RTC_SYNC_INTR_MASK__SLEEP_ACCESS__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000010U) | (((u_int32_t)(src) <<\
                    4) & 0x00000010U)
#define RTC_SYNC_INTR_MASK__SLEEP_ACCESS__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 4) & ~0x00000010U)))
#define RTC_SYNC_INTR_MASK__SLEEP_ACCESS__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000010U) | ((u_int32_t)(1) << 4)
#define RTC_SYNC_INTR_MASK__SLEEP_ACCESS__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000010U) | ((u_int32_t)(0) << 4)

/* macros for field PLL_CHANGING */
#define RTC_SYNC_INTR_MASK__PLL_CHANGING__SHIFT                               5
#define RTC_SYNC_INTR_MASK__PLL_CHANGING__WIDTH                               1
#define RTC_SYNC_INTR_MASK__PLL_CHANGING__MASK                      0x00000020U
#define RTC_SYNC_INTR_MASK__PLL_CHANGING__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000020U) >> 5)
#define RTC_SYNC_INTR_MASK__PLL_CHANGING__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 5) & 0x00000020U)
#define RTC_SYNC_INTR_MASK__PLL_CHANGING__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000020U) | (((u_int32_t)(src) <<\
                    5) & 0x00000020U)
#define RTC_SYNC_INTR_MASK__PLL_CHANGING__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 5) & ~0x00000020U)))
#define RTC_SYNC_INTR_MASK__PLL_CHANGING__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000020U) | ((u_int32_t)(1) << 5)
#define RTC_SYNC_INTR_MASK__PLL_CHANGING__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000020U) | ((u_int32_t)(0) << 5)
#define RTC_SYNC_INTR_MASK__TYPE                                      u_int32_t
#define RTC_SYNC_INTR_MASK__READ                                    0x0000003fU
#define RTC_SYNC_INTR_MASK__WRITE                                   0x0000003fU

#endif /* __RTC_SYNC_INTR_MASK_MACRO__ */


/* macros for rtc_sync_reg_block.RTC_SYNC_INTR_MASK */
#define INST_RTC_SYNC_REG_BLOCK__RTC_SYNC_INTR_MASK__NUM                      1

/* macros for BlueprintGlobalNameSpace::RADIO130NM_RXTXBB1_CH1 */
#ifndef __RADIO130NM_RXTXBB1_CH1_MACRO__
#define __RADIO130NM_RXTXBB1_CH1_MACRO__

/* macros for field PDHIQ */
#define RADIO130NM_RXTXBB1_CH1__PDHIQ__SHIFT                                  0
#define RADIO130NM_RXTXBB1_CH1__PDHIQ__WIDTH                                  1
#define RADIO130NM_RXTXBB1_CH1__PDHIQ__MASK                         0x00000001U
#define RADIO130NM_RXTXBB1_CH1__PDHIQ__READ(src) (u_int32_t)(src) & 0x00000001U
#define RADIO130NM_RXTXBB1_CH1__PDHIQ__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x00000001U)
#define RADIO130NM_RXTXBB1_CH1__PDHIQ__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | ((u_int32_t)(src) &\
                    0x00000001U)
#define RADIO130NM_RXTXBB1_CH1__PDHIQ__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00000001U)))
#define RADIO130NM_RXTXBB1_CH1__PDHIQ__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(1)
#define RADIO130NM_RXTXBB1_CH1__PDHIQ__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(0)

/* macros for field PDLOQ */
#define RADIO130NM_RXTXBB1_CH1__PDLOQ__SHIFT                                  1
#define RADIO130NM_RXTXBB1_CH1__PDLOQ__WIDTH                                  1
#define RADIO130NM_RXTXBB1_CH1__PDLOQ__MASK                         0x00000002U
#define RADIO130NM_RXTXBB1_CH1__PDLOQ__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000002U) >> 1)
#define RADIO130NM_RXTXBB1_CH1__PDLOQ__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 1) & 0x00000002U)
#define RADIO130NM_RXTXBB1_CH1__PDLOQ__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | (((u_int32_t)(src) <<\
                    1) & 0x00000002U)
#define RADIO130NM_RXTXBB1_CH1__PDLOQ__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 1) & ~0x00000002U)))
#define RADIO130NM_RXTXBB1_CH1__PDLOQ__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | ((u_int32_t)(1) << 1)
#define RADIO130NM_RXTXBB1_CH1__PDLOQ__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | ((u_int32_t)(0) << 1)

/* macros for field PDOFFSETI2V */
#define RADIO130NM_RXTXBB1_CH1__PDOFFSETI2V__SHIFT                            2
#define RADIO130NM_RXTXBB1_CH1__PDOFFSETI2V__WIDTH                            1
#define RADIO130NM_RXTXBB1_CH1__PDOFFSETI2V__MASK                   0x00000004U
#define RADIO130NM_RXTXBB1_CH1__PDOFFSETI2V__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000004U) >> 2)
#define RADIO130NM_RXTXBB1_CH1__PDOFFSETI2V__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 2) & 0x00000004U)
#define RADIO130NM_RXTXBB1_CH1__PDOFFSETI2V__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000004U) | (((u_int32_t)(src) <<\
                    2) & 0x00000004U)
#define RADIO130NM_RXTXBB1_CH1__PDOFFSETI2V__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 2) & ~0x00000004U)))
#define RADIO130NM_RXTXBB1_CH1__PDOFFSETI2V__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000004U) | ((u_int32_t)(1) << 2)
#define RADIO130NM_RXTXBB1_CH1__PDOFFSETI2V__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000004U) | ((u_int32_t)(0) << 2)

/* macros for field PDOFFSETHIQ */
#define RADIO130NM_RXTXBB1_CH1__PDOFFSETHIQ__SHIFT                            3
#define RADIO130NM_RXTXBB1_CH1__PDOFFSETHIQ__WIDTH                            1
#define RADIO130NM_RXTXBB1_CH1__PDOFFSETHIQ__MASK                   0x00000008U
#define RADIO130NM_RXTXBB1_CH1__PDOFFSETHIQ__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000008U) >> 3)
#define RADIO130NM_RXTXBB1_CH1__PDOFFSETHIQ__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 3) & 0x00000008U)
#define RADIO130NM_RXTXBB1_CH1__PDOFFSETHIQ__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000008U) | (((u_int32_t)(src) <<\
                    3) & 0x00000008U)
#define RADIO130NM_RXTXBB1_CH1__PDOFFSETHIQ__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 3) & ~0x00000008U)))
#define RADIO130NM_RXTXBB1_CH1__PDOFFSETHIQ__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000008U) | ((u_int32_t)(1) << 3)
#define RADIO130NM_RXTXBB1_CH1__PDOFFSETHIQ__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000008U) | ((u_int32_t)(0) << 3)

/* macros for field PDOFFSETLOQ */
#define RADIO130NM_RXTXBB1_CH1__PDOFFSETLOQ__SHIFT                            4
#define RADIO130NM_RXTXBB1_CH1__PDOFFSETLOQ__WIDTH                            1
#define RADIO130NM_RXTXBB1_CH1__PDOFFSETLOQ__MASK                   0x00000010U
#define RADIO130NM_RXTXBB1_CH1__PDOFFSETLOQ__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000010U) >> 4)
#define RADIO130NM_RXTXBB1_CH1__PDOFFSETLOQ__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 4) & 0x00000010U)
#define RADIO130NM_RXTXBB1_CH1__PDOFFSETLOQ__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000010U) | (((u_int32_t)(src) <<\
                    4) & 0x00000010U)
#define RADIO130NM_RXTXBB1_CH1__PDOFFSETLOQ__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 4) & ~0x00000010U)))
#define RADIO130NM_RXTXBB1_CH1__PDOFFSETLOQ__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000010U) | ((u_int32_t)(1) << 4)
#define RADIO130NM_RXTXBB1_CH1__PDOFFSETLOQ__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000010U) | ((u_int32_t)(0) << 4)

/* macros for field PDRXTXBB */
#define RADIO130NM_RXTXBB1_CH1__PDRXTXBB__SHIFT                               5
#define RADIO130NM_RXTXBB1_CH1__PDRXTXBB__WIDTH                               1
#define RADIO130NM_RXTXBB1_CH1__PDRXTXBB__MASK                      0x00000020U
#define RADIO130NM_RXTXBB1_CH1__PDRXTXBB__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000020U) >> 5)
#define RADIO130NM_RXTXBB1_CH1__PDRXTXBB__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 5) & 0x00000020U)
#define RADIO130NM_RXTXBB1_CH1__PDRXTXBB__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000020U) | (((u_int32_t)(src) <<\
                    5) & 0x00000020U)
#define RADIO130NM_RXTXBB1_CH1__PDRXTXBB__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 5) & ~0x00000020U)))
#define RADIO130NM_RXTXBB1_CH1__PDRXTXBB__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000020U) | ((u_int32_t)(1) << 5)
#define RADIO130NM_RXTXBB1_CH1__PDRXTXBB__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000020U) | ((u_int32_t)(0) << 5)

/* macros for field PDI2V */
#define RADIO130NM_RXTXBB1_CH1__PDI2V__SHIFT                                  6
#define RADIO130NM_RXTXBB1_CH1__PDI2V__WIDTH                                  1
#define RADIO130NM_RXTXBB1_CH1__PDI2V__MASK                         0x00000040U
#define RADIO130NM_RXTXBB1_CH1__PDI2V__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000040U) >> 6)
#define RADIO130NM_RXTXBB1_CH1__PDI2V__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 6) & 0x00000040U)
#define RADIO130NM_RXTXBB1_CH1__PDI2V__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000040U) | (((u_int32_t)(src) <<\
                    6) & 0x00000040U)
#define RADIO130NM_RXTXBB1_CH1__PDI2V__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 6) & ~0x00000040U)))
#define RADIO130NM_RXTXBB1_CH1__PDI2V__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000040U) | ((u_int32_t)(1) << 6)
#define RADIO130NM_RXTXBB1_CH1__PDI2V__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000040U) | ((u_int32_t)(0) << 6)

/* macros for field PDV2I */
#define RADIO130NM_RXTXBB1_CH1__PDV2I__SHIFT                                  7
#define RADIO130NM_RXTXBB1_CH1__PDV2I__WIDTH                                  1
#define RADIO130NM_RXTXBB1_CH1__PDV2I__MASK                         0x00000080U
#define RADIO130NM_RXTXBB1_CH1__PDV2I__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000080U) >> 7)
#define RADIO130NM_RXTXBB1_CH1__PDV2I__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 7) & 0x00000080U)
#define RADIO130NM_RXTXBB1_CH1__PDV2I__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000080U) | (((u_int32_t)(src) <<\
                    7) & 0x00000080U)
#define RADIO130NM_RXTXBB1_CH1__PDV2I__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 7) & ~0x00000080U)))
#define RADIO130NM_RXTXBB1_CH1__PDV2I__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000080U) | ((u_int32_t)(1) << 7)
#define RADIO130NM_RXTXBB1_CH1__PDV2I__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000080U) | ((u_int32_t)(0) << 7)

/* macros for field PDDACINTERFACE */
#define RADIO130NM_RXTXBB1_CH1__PDDACINTERFACE__SHIFT                         8
#define RADIO130NM_RXTXBB1_CH1__PDDACINTERFACE__WIDTH                         1
#define RADIO130NM_RXTXBB1_CH1__PDDACINTERFACE__MASK                0x00000100U
#define RADIO130NM_RXTXBB1_CH1__PDDACINTERFACE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000100U) >> 8)
#define RADIO130NM_RXTXBB1_CH1__PDDACINTERFACE__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 8) & 0x00000100U)
#define RADIO130NM_RXTXBB1_CH1__PDDACINTERFACE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000100U) | (((u_int32_t)(src) <<\
                    8) & 0x00000100U)
#define RADIO130NM_RXTXBB1_CH1__PDDACINTERFACE__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 8) & ~0x00000100U)))
#define RADIO130NM_RXTXBB1_CH1__PDDACINTERFACE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000100U) | ((u_int32_t)(1) << 8)
#define RADIO130NM_RXTXBB1_CH1__PDDACINTERFACE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000100U) | ((u_int32_t)(0) << 8)

/* macros for field SEL_ATB */
#define RADIO130NM_RXTXBB1_CH1__SEL_ATB__SHIFT                                9
#define RADIO130NM_RXTXBB1_CH1__SEL_ATB__WIDTH                                8
#define RADIO130NM_RXTXBB1_CH1__SEL_ATB__MASK                       0x0001fe00U
#define RADIO130NM_RXTXBB1_CH1__SEL_ATB__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0001fe00U) >> 9)
#define RADIO130NM_RXTXBB1_CH1__SEL_ATB__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 9) & 0x0001fe00U)
#define RADIO130NM_RXTXBB1_CH1__SEL_ATB__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0001fe00U) | (((u_int32_t)(src) <<\
                    9) & 0x0001fe00U)
#define RADIO130NM_RXTXBB1_CH1__SEL_ATB__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 9) & ~0x0001fe00U)))

/* macros for field FNOTCH */
#define RADIO130NM_RXTXBB1_CH1__FNOTCH__SHIFT                                17
#define RADIO130NM_RXTXBB1_CH1__FNOTCH__WIDTH                                 2
#define RADIO130NM_RXTXBB1_CH1__FNOTCH__MASK                        0x00060000U
#define RADIO130NM_RXTXBB1_CH1__FNOTCH__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00060000U) >> 17)
#define RADIO130NM_RXTXBB1_CH1__FNOTCH__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 17) & 0x00060000U)
#define RADIO130NM_RXTXBB1_CH1__FNOTCH__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00060000U) | (((u_int32_t)(src) <<\
                    17) & 0x00060000U)
#define RADIO130NM_RXTXBB1_CH1__FNOTCH__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 17) & ~0x00060000U)))

/* macros for field SPARE */
#define RADIO130NM_RXTXBB1_CH1__SPARE__SHIFT                                 19
#define RADIO130NM_RXTXBB1_CH1__SPARE__WIDTH                                 13
#define RADIO130NM_RXTXBB1_CH1__SPARE__MASK                         0xfff80000U
#define RADIO130NM_RXTXBB1_CH1__SPARE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0xfff80000U) >> 19)
#define RADIO130NM_RXTXBB1_CH1__SPARE__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 19) & 0xfff80000U)
#define RADIO130NM_RXTXBB1_CH1__SPARE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xfff80000U) | (((u_int32_t)(src) <<\
                    19) & 0xfff80000U)
#define RADIO130NM_RXTXBB1_CH1__SPARE__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 19) & ~0xfff80000U)))
#define RADIO130NM_RXTXBB1_CH1__TYPE                                  u_int32_t
#define RADIO130NM_RXTXBB1_CH1__READ                                0xffffffffU
#define RADIO130NM_RXTXBB1_CH1__WRITE                               0xffffffffU

#endif /* __RADIO130NM_RXTXBB1_CH1_MACRO__ */


/* macros for merlin2_0_radio_reg_map.RXTXBB1_CH1 */
#define INST_MERLIN2_0_RADIO_REG_MAP__RXTXBB1_CH1__NUM                        1

/* macros for BlueprintGlobalNameSpace::RADIO130NM_RXTXBB2_CH1 */
#ifndef __RADIO130NM_RXTXBB2_CH1_MACRO__
#define __RADIO130NM_RXTXBB2_CH1_MACRO__

/* macros for field PATH_OVERRIDE */
#define RADIO130NM_RXTXBB2_CH1__PATH_OVERRIDE__SHIFT                          0
#define RADIO130NM_RXTXBB2_CH1__PATH_OVERRIDE__WIDTH                          1
#define RADIO130NM_RXTXBB2_CH1__PATH_OVERRIDE__MASK                 0x00000001U
#define RADIO130NM_RXTXBB2_CH1__PATH_OVERRIDE__READ(src) \
                    (u_int32_t)(src)\
                    & 0x00000001U
#define RADIO130NM_RXTXBB2_CH1__PATH_OVERRIDE__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x00000001U)
#define RADIO130NM_RXTXBB2_CH1__PATH_OVERRIDE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | ((u_int32_t)(src) &\
                    0x00000001U)
#define RADIO130NM_RXTXBB2_CH1__PATH_OVERRIDE__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00000001U)))
#define RADIO130NM_RXTXBB2_CH1__PATH_OVERRIDE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(1)
#define RADIO130NM_RXTXBB2_CH1__PATH_OVERRIDE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(0)

/* macros for field PATH1LOQ_EN */
#define RADIO130NM_RXTXBB2_CH1__PATH1LOQ_EN__SHIFT                            1
#define RADIO130NM_RXTXBB2_CH1__PATH1LOQ_EN__WIDTH                            1
#define RADIO130NM_RXTXBB2_CH1__PATH1LOQ_EN__MASK                   0x00000002U
#define RADIO130NM_RXTXBB2_CH1__PATH1LOQ_EN__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000002U) >> 1)
#define RADIO130NM_RXTXBB2_CH1__PATH1LOQ_EN__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 1) & 0x00000002U)
#define RADIO130NM_RXTXBB2_CH1__PATH1LOQ_EN__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | (((u_int32_t)(src) <<\
                    1) & 0x00000002U)
#define RADIO130NM_RXTXBB2_CH1__PATH1LOQ_EN__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 1) & ~0x00000002U)))
#define RADIO130NM_RXTXBB2_CH1__PATH1LOQ_EN__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | ((u_int32_t)(1) << 1)
#define RADIO130NM_RXTXBB2_CH1__PATH1LOQ_EN__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | ((u_int32_t)(0) << 1)

/* macros for field PATH2LOQ_EN */
#define RADIO130NM_RXTXBB2_CH1__PATH2LOQ_EN__SHIFT                            2
#define RADIO130NM_RXTXBB2_CH1__PATH2LOQ_EN__WIDTH                            1
#define RADIO130NM_RXTXBB2_CH1__PATH2LOQ_EN__MASK                   0x00000004U
#define RADIO130NM_RXTXBB2_CH1__PATH2LOQ_EN__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000004U) >> 2)
#define RADIO130NM_RXTXBB2_CH1__PATH2LOQ_EN__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 2) & 0x00000004U)
#define RADIO130NM_RXTXBB2_CH1__PATH2LOQ_EN__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000004U) | (((u_int32_t)(src) <<\
                    2) & 0x00000004U)
#define RADIO130NM_RXTXBB2_CH1__PATH2LOQ_EN__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 2) & ~0x00000004U)))
#define RADIO130NM_RXTXBB2_CH1__PATH2LOQ_EN__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000004U) | ((u_int32_t)(1) << 2)
#define RADIO130NM_RXTXBB2_CH1__PATH2LOQ_EN__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000004U) | ((u_int32_t)(0) << 2)

/* macros for field PATH3LOQ_EN */
#define RADIO130NM_RXTXBB2_CH1__PATH3LOQ_EN__SHIFT                            3
#define RADIO130NM_RXTXBB2_CH1__PATH3LOQ_EN__WIDTH                            1
#define RADIO130NM_RXTXBB2_CH1__PATH3LOQ_EN__MASK                   0x00000008U
#define RADIO130NM_RXTXBB2_CH1__PATH3LOQ_EN__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000008U) >> 3)
#define RADIO130NM_RXTXBB2_CH1__PATH3LOQ_EN__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 3) & 0x00000008U)
#define RADIO130NM_RXTXBB2_CH1__PATH3LOQ_EN__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000008U) | (((u_int32_t)(src) <<\
                    3) & 0x00000008U)
#define RADIO130NM_RXTXBB2_CH1__PATH3LOQ_EN__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 3) & ~0x00000008U)))
#define RADIO130NM_RXTXBB2_CH1__PATH3LOQ_EN__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000008U) | ((u_int32_t)(1) << 3)
#define RADIO130NM_RXTXBB2_CH1__PATH3LOQ_EN__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000008U) | ((u_int32_t)(0) << 3)

/* macros for field PATH1HIQ_EN */
#define RADIO130NM_RXTXBB2_CH1__PATH1HIQ_EN__SHIFT                            4
#define RADIO130NM_RXTXBB2_CH1__PATH1HIQ_EN__WIDTH                            1
#define RADIO130NM_RXTXBB2_CH1__PATH1HIQ_EN__MASK                   0x00000010U
#define RADIO130NM_RXTXBB2_CH1__PATH1HIQ_EN__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000010U) >> 4)
#define RADIO130NM_RXTXBB2_CH1__PATH1HIQ_EN__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 4) & 0x00000010U)
#define RADIO130NM_RXTXBB2_CH1__PATH1HIQ_EN__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000010U) | (((u_int32_t)(src) <<\
                    4) & 0x00000010U)
#define RADIO130NM_RXTXBB2_CH1__PATH1HIQ_EN__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 4) & ~0x00000010U)))
#define RADIO130NM_RXTXBB2_CH1__PATH1HIQ_EN__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000010U) | ((u_int32_t)(1) << 4)
#define RADIO130NM_RXTXBB2_CH1__PATH1HIQ_EN__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000010U) | ((u_int32_t)(0) << 4)

/* macros for field PATH2HIQ_EN */
#define RADIO130NM_RXTXBB2_CH1__PATH2HIQ_EN__SHIFT                            5
#define RADIO130NM_RXTXBB2_CH1__PATH2HIQ_EN__WIDTH                            1
#define RADIO130NM_RXTXBB2_CH1__PATH2HIQ_EN__MASK                   0x00000020U
#define RADIO130NM_RXTXBB2_CH1__PATH2HIQ_EN__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000020U) >> 5)
#define RADIO130NM_RXTXBB2_CH1__PATH2HIQ_EN__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 5) & 0x00000020U)
#define RADIO130NM_RXTXBB2_CH1__PATH2HIQ_EN__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000020U) | (((u_int32_t)(src) <<\
                    5) & 0x00000020U)
#define RADIO130NM_RXTXBB2_CH1__PATH2HIQ_EN__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 5) & ~0x00000020U)))
#define RADIO130NM_RXTXBB2_CH1__PATH2HIQ_EN__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000020U) | ((u_int32_t)(1) << 5)
#define RADIO130NM_RXTXBB2_CH1__PATH2HIQ_EN__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000020U) | ((u_int32_t)(0) << 5)

/* macros for field FILTERDOUBLEBW */
#define RADIO130NM_RXTXBB2_CH1__FILTERDOUBLEBW__SHIFT                         6
#define RADIO130NM_RXTXBB2_CH1__FILTERDOUBLEBW__WIDTH                         1
#define RADIO130NM_RXTXBB2_CH1__FILTERDOUBLEBW__MASK                0x00000040U
#define RADIO130NM_RXTXBB2_CH1__FILTERDOUBLEBW__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000040U) >> 6)
#define RADIO130NM_RXTXBB2_CH1__FILTERDOUBLEBW__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 6) & 0x00000040U)
#define RADIO130NM_RXTXBB2_CH1__FILTERDOUBLEBW__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000040U) | (((u_int32_t)(src) <<\
                    6) & 0x00000040U)
#define RADIO130NM_RXTXBB2_CH1__FILTERDOUBLEBW__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 6) & ~0x00000040U)))
#define RADIO130NM_RXTXBB2_CH1__FILTERDOUBLEBW__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000040U) | ((u_int32_t)(1) << 6)
#define RADIO130NM_RXTXBB2_CH1__FILTERDOUBLEBW__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000040U) | ((u_int32_t)(0) << 6)

/* macros for field LOCALFILTERTUNING */
#define RADIO130NM_RXTXBB2_CH1__LOCALFILTERTUNING__SHIFT                      7
#define RADIO130NM_RXTXBB2_CH1__LOCALFILTERTUNING__WIDTH                      1
#define RADIO130NM_RXTXBB2_CH1__LOCALFILTERTUNING__MASK             0x00000080U
#define RADIO130NM_RXTXBB2_CH1__LOCALFILTERTUNING__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000080U) >> 7)
#define RADIO130NM_RXTXBB2_CH1__LOCALFILTERTUNING__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 7) & 0x00000080U)
#define RADIO130NM_RXTXBB2_CH1__LOCALFILTERTUNING__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000080U) | (((u_int32_t)(src) <<\
                    7) & 0x00000080U)
#define RADIO130NM_RXTXBB2_CH1__LOCALFILTERTUNING__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 7) & ~0x00000080U)))
#define RADIO130NM_RXTXBB2_CH1__LOCALFILTERTUNING__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000080U) | ((u_int32_t)(1) << 7)
#define RADIO130NM_RXTXBB2_CH1__LOCALFILTERTUNING__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000080U) | ((u_int32_t)(0) << 7)

/* macros for field FILTERFC */
#define RADIO130NM_RXTXBB2_CH1__FILTERFC__SHIFT                               8
#define RADIO130NM_RXTXBB2_CH1__FILTERFC__WIDTH                               5
#define RADIO130NM_RXTXBB2_CH1__FILTERFC__MASK                      0x00001f00U
#define RADIO130NM_RXTXBB2_CH1__FILTERFC__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00001f00U) >> 8)
#define RADIO130NM_RXTXBB2_CH1__FILTERFC__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 8) & 0x00001f00U)
#define RADIO130NM_RXTXBB2_CH1__FILTERFC__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00001f00U) | (((u_int32_t)(src) <<\
                    8) & 0x00001f00U)
#define RADIO130NM_RXTXBB2_CH1__FILTERFC__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 8) & ~0x00001f00U)))

/* macros for field CMSEL */
#define RADIO130NM_RXTXBB2_CH1__CMSEL__SHIFT                                 13
#define RADIO130NM_RXTXBB2_CH1__CMSEL__WIDTH                                  2
#define RADIO130NM_RXTXBB2_CH1__CMSEL__MASK                         0x00006000U
#define RADIO130NM_RXTXBB2_CH1__CMSEL__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00006000U) >> 13)
#define RADIO130NM_RXTXBB2_CH1__CMSEL__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 13) & 0x00006000U)
#define RADIO130NM_RXTXBB2_CH1__CMSEL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00006000U) | (((u_int32_t)(src) <<\
                    13) & 0x00006000U)
#define RADIO130NM_RXTXBB2_CH1__CMSEL__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 13) & ~0x00006000U)))

/* macros for field SEL_I2V_TEST */
#define RADIO130NM_RXTXBB2_CH1__SEL_I2V_TEST__SHIFT                          15
#define RADIO130NM_RXTXBB2_CH1__SEL_I2V_TEST__WIDTH                           1
#define RADIO130NM_RXTXBB2_CH1__SEL_I2V_TEST__MASK                  0x00008000U
#define RADIO130NM_RXTXBB2_CH1__SEL_I2V_TEST__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00008000U) >> 15)
#define RADIO130NM_RXTXBB2_CH1__SEL_I2V_TEST__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 15) & 0x00008000U)
#define RADIO130NM_RXTXBB2_CH1__SEL_I2V_TEST__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00008000U) | (((u_int32_t)(src) <<\
                    15) & 0x00008000U)
#define RADIO130NM_RXTXBB2_CH1__SEL_I2V_TEST__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 15) & ~0x00008000U)))
#define RADIO130NM_RXTXBB2_CH1__SEL_I2V_TEST__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00008000U) | ((u_int32_t)(1) << 15)
#define RADIO130NM_RXTXBB2_CH1__SEL_I2V_TEST__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00008000U) | ((u_int32_t)(0) << 15)

/* macros for field SEL_HIQ_TEST */
#define RADIO130NM_RXTXBB2_CH1__SEL_HIQ_TEST__SHIFT                          16
#define RADIO130NM_RXTXBB2_CH1__SEL_HIQ_TEST__WIDTH                           1
#define RADIO130NM_RXTXBB2_CH1__SEL_HIQ_TEST__MASK                  0x00010000U
#define RADIO130NM_RXTXBB2_CH1__SEL_HIQ_TEST__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00010000U) >> 16)
#define RADIO130NM_RXTXBB2_CH1__SEL_HIQ_TEST__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 16) & 0x00010000U)
#define RADIO130NM_RXTXBB2_CH1__SEL_HIQ_TEST__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00010000U) | (((u_int32_t)(src) <<\
                    16) & 0x00010000U)
#define RADIO130NM_RXTXBB2_CH1__SEL_HIQ_TEST__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 16) & ~0x00010000U)))
#define RADIO130NM_RXTXBB2_CH1__SEL_HIQ_TEST__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00010000U) | ((u_int32_t)(1) << 16)
#define RADIO130NM_RXTXBB2_CH1__SEL_HIQ_TEST__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00010000U) | ((u_int32_t)(0) << 16)

/* macros for field SEL_LOQ_TEST */
#define RADIO130NM_RXTXBB2_CH1__SEL_LOQ_TEST__SHIFT                          17
#define RADIO130NM_RXTXBB2_CH1__SEL_LOQ_TEST__WIDTH                           1
#define RADIO130NM_RXTXBB2_CH1__SEL_LOQ_TEST__MASK                  0x00020000U
#define RADIO130NM_RXTXBB2_CH1__SEL_LOQ_TEST__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00020000U) >> 17)
#define RADIO130NM_RXTXBB2_CH1__SEL_LOQ_TEST__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 17) & 0x00020000U)
#define RADIO130NM_RXTXBB2_CH1__SEL_LOQ_TEST__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00020000U) | (((u_int32_t)(src) <<\
                    17) & 0x00020000U)
#define RADIO130NM_RXTXBB2_CH1__SEL_LOQ_TEST__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 17) & ~0x00020000U)))
#define RADIO130NM_RXTXBB2_CH1__SEL_LOQ_TEST__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00020000U) | ((u_int32_t)(1) << 17)
#define RADIO130NM_RXTXBB2_CH1__SEL_LOQ_TEST__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00020000U) | ((u_int32_t)(0) << 17)

/* macros for field SEL_DAC_TEST */
#define RADIO130NM_RXTXBB2_CH1__SEL_DAC_TEST__SHIFT                          18
#define RADIO130NM_RXTXBB2_CH1__SEL_DAC_TEST__WIDTH                           1
#define RADIO130NM_RXTXBB2_CH1__SEL_DAC_TEST__MASK                  0x00040000U
#define RADIO130NM_RXTXBB2_CH1__SEL_DAC_TEST__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00040000U) >> 18)
#define RADIO130NM_RXTXBB2_CH1__SEL_DAC_TEST__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 18) & 0x00040000U)
#define RADIO130NM_RXTXBB2_CH1__SEL_DAC_TEST__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00040000U) | (((u_int32_t)(src) <<\
                    18) & 0x00040000U)
#define RADIO130NM_RXTXBB2_CH1__SEL_DAC_TEST__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 18) & ~0x00040000U)))
#define RADIO130NM_RXTXBB2_CH1__SEL_DAC_TEST__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00040000U) | ((u_int32_t)(1) << 18)
#define RADIO130NM_RXTXBB2_CH1__SEL_DAC_TEST__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00040000U) | ((u_int32_t)(0) << 18)

/* macros for field SELBUFFER */
#define RADIO130NM_RXTXBB2_CH1__SELBUFFER__SHIFT                             19
#define RADIO130NM_RXTXBB2_CH1__SELBUFFER__WIDTH                              1
#define RADIO130NM_RXTXBB2_CH1__SELBUFFER__MASK                     0x00080000U
#define RADIO130NM_RXTXBB2_CH1__SELBUFFER__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00080000U) >> 19)
#define RADIO130NM_RXTXBB2_CH1__SELBUFFER__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 19) & 0x00080000U)
#define RADIO130NM_RXTXBB2_CH1__SELBUFFER__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00080000U) | (((u_int32_t)(src) <<\
                    19) & 0x00080000U)
#define RADIO130NM_RXTXBB2_CH1__SELBUFFER__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 19) & ~0x00080000U)))
#define RADIO130NM_RXTXBB2_CH1__SELBUFFER__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00080000U) | ((u_int32_t)(1) << 19)
#define RADIO130NM_RXTXBB2_CH1__SELBUFFER__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00080000U) | ((u_int32_t)(0) << 19)

/* macros for field SHORTBUFFER */
#define RADIO130NM_RXTXBB2_CH1__SHORTBUFFER__SHIFT                           20
#define RADIO130NM_RXTXBB2_CH1__SHORTBUFFER__WIDTH                            1
#define RADIO130NM_RXTXBB2_CH1__SHORTBUFFER__MASK                   0x00100000U
#define RADIO130NM_RXTXBB2_CH1__SHORTBUFFER__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00100000U) >> 20)
#define RADIO130NM_RXTXBB2_CH1__SHORTBUFFER__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 20) & 0x00100000U)
#define RADIO130NM_RXTXBB2_CH1__SHORTBUFFER__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00100000U) | (((u_int32_t)(src) <<\
                    20) & 0x00100000U)
#define RADIO130NM_RXTXBB2_CH1__SHORTBUFFER__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 20) & ~0x00100000U)))
#define RADIO130NM_RXTXBB2_CH1__SHORTBUFFER__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00100000U) | ((u_int32_t)(1) << 20)
#define RADIO130NM_RXTXBB2_CH1__SHORTBUFFER__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00100000U) | ((u_int32_t)(0) << 20)

/* macros for field SPARE */
#define RADIO130NM_RXTXBB2_CH1__SPARE__SHIFT                                 21
#define RADIO130NM_RXTXBB2_CH1__SPARE__WIDTH                                  2
#define RADIO130NM_RXTXBB2_CH1__SPARE__MASK                         0x00600000U
#define RADIO130NM_RXTXBB2_CH1__SPARE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00600000U) >> 21)
#define RADIO130NM_RXTXBB2_CH1__SPARE__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 21) & 0x00600000U)
#define RADIO130NM_RXTXBB2_CH1__SPARE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00600000U) | (((u_int32_t)(src) <<\
                    21) & 0x00600000U)
#define RADIO130NM_RXTXBB2_CH1__SPARE__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 21) & ~0x00600000U)))

/* macros for field IBN_37P5_OSI2V_CTRL */
#define RADIO130NM_RXTXBB2_CH1__IBN_37P5_OSI2V_CTRL__SHIFT                   23
#define RADIO130NM_RXTXBB2_CH1__IBN_37P5_OSI2V_CTRL__WIDTH                    3
#define RADIO130NM_RXTXBB2_CH1__IBN_37P5_OSI2V_CTRL__MASK           0x03800000U
#define RADIO130NM_RXTXBB2_CH1__IBN_37P5_OSI2V_CTRL__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x03800000U) >> 23)
#define RADIO130NM_RXTXBB2_CH1__IBN_37P5_OSI2V_CTRL__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 23) & 0x03800000U)
#define RADIO130NM_RXTXBB2_CH1__IBN_37P5_OSI2V_CTRL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x03800000U) | (((u_int32_t)(src) <<\
                    23) & 0x03800000U)
#define RADIO130NM_RXTXBB2_CH1__IBN_37P5_OSI2V_CTRL__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 23) & ~0x03800000U)))

/* macros for field IBN_37P5_OSLO_CTRL */
#define RADIO130NM_RXTXBB2_CH1__IBN_37P5_OSLO_CTRL__SHIFT                    26
#define RADIO130NM_RXTXBB2_CH1__IBN_37P5_OSLO_CTRL__WIDTH                     3
#define RADIO130NM_RXTXBB2_CH1__IBN_37P5_OSLO_CTRL__MASK            0x1c000000U
#define RADIO130NM_RXTXBB2_CH1__IBN_37P5_OSLO_CTRL__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x1c000000U) >> 26)
#define RADIO130NM_RXTXBB2_CH1__IBN_37P5_OSLO_CTRL__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 26) & 0x1c000000U)
#define RADIO130NM_RXTXBB2_CH1__IBN_37P5_OSLO_CTRL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x1c000000U) | (((u_int32_t)(src) <<\
                    26) & 0x1c000000U)
#define RADIO130NM_RXTXBB2_CH1__IBN_37P5_OSLO_CTRL__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 26) & ~0x1c000000U)))

/* macros for field IBN_37P5_OSHI_CTRL */
#define RADIO130NM_RXTXBB2_CH1__IBN_37P5_OSHI_CTRL__SHIFT                    29
#define RADIO130NM_RXTXBB2_CH1__IBN_37P5_OSHI_CTRL__WIDTH                     3
#define RADIO130NM_RXTXBB2_CH1__IBN_37P5_OSHI_CTRL__MASK            0xe0000000U
#define RADIO130NM_RXTXBB2_CH1__IBN_37P5_OSHI_CTRL__READ(src) \
                    (((u_int32_t)(src)\
                    & 0xe0000000U) >> 29)
#define RADIO130NM_RXTXBB2_CH1__IBN_37P5_OSHI_CTRL__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 29) & 0xe0000000U)
#define RADIO130NM_RXTXBB2_CH1__IBN_37P5_OSHI_CTRL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xe0000000U) | (((u_int32_t)(src) <<\
                    29) & 0xe0000000U)
#define RADIO130NM_RXTXBB2_CH1__IBN_37P5_OSHI_CTRL__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 29) & ~0xe0000000U)))
#define RADIO130NM_RXTXBB2_CH1__TYPE                                  u_int32_t
#define RADIO130NM_RXTXBB2_CH1__READ                                0xffffffffU
#define RADIO130NM_RXTXBB2_CH1__WRITE                               0xffffffffU

#endif /* __RADIO130NM_RXTXBB2_CH1_MACRO__ */


/* macros for merlin2_0_radio_reg_map.RXTXBB2_CH1 */
#define INST_MERLIN2_0_RADIO_REG_MAP__RXTXBB2_CH1__NUM                        1

/* macros for BlueprintGlobalNameSpace::RADIO130NM_RXTXBB3_CH1 */
#ifndef __RADIO130NM_RXTXBB3_CH1_MACRO__
#define __RADIO130NM_RXTXBB3_CH1_MACRO__

/* macros for field IBN_100U_TEST_CTRL */
#define RADIO130NM_RXTXBB3_CH1__IBN_100U_TEST_CTRL__SHIFT                     0
#define RADIO130NM_RXTXBB3_CH1__IBN_100U_TEST_CTRL__WIDTH                     3
#define RADIO130NM_RXTXBB3_CH1__IBN_100U_TEST_CTRL__MASK            0x00000007U
#define RADIO130NM_RXTXBB3_CH1__IBN_100U_TEST_CTRL__READ(src) \
                    (u_int32_t)(src)\
                    & 0x00000007U
#define RADIO130NM_RXTXBB3_CH1__IBN_100U_TEST_CTRL__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x00000007U)
#define RADIO130NM_RXTXBB3_CH1__IBN_100U_TEST_CTRL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000007U) | ((u_int32_t)(src) &\
                    0x00000007U)
#define RADIO130NM_RXTXBB3_CH1__IBN_100U_TEST_CTRL__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00000007U)))

/* macros for field IBRN_12P5_CM_CTRL */
#define RADIO130NM_RXTXBB3_CH1__IBRN_12P5_CM_CTRL__SHIFT                      3
#define RADIO130NM_RXTXBB3_CH1__IBRN_12P5_CM_CTRL__WIDTH                      3
#define RADIO130NM_RXTXBB3_CH1__IBRN_12P5_CM_CTRL__MASK             0x00000038U
#define RADIO130NM_RXTXBB3_CH1__IBRN_12P5_CM_CTRL__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000038U) >> 3)
#define RADIO130NM_RXTXBB3_CH1__IBRN_12P5_CM_CTRL__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 3) & 0x00000038U)
#define RADIO130NM_RXTXBB3_CH1__IBRN_12P5_CM_CTRL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000038U) | (((u_int32_t)(src) <<\
                    3) & 0x00000038U)
#define RADIO130NM_RXTXBB3_CH1__IBRN_12P5_CM_CTRL__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 3) & ~0x00000038U)))

/* macros for field IBN_25U_LO2_CTRL */
#define RADIO130NM_RXTXBB3_CH1__IBN_25U_LO2_CTRL__SHIFT                       6
#define RADIO130NM_RXTXBB3_CH1__IBN_25U_LO2_CTRL__WIDTH                       3
#define RADIO130NM_RXTXBB3_CH1__IBN_25U_LO2_CTRL__MASK              0x000001c0U
#define RADIO130NM_RXTXBB3_CH1__IBN_25U_LO2_CTRL__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x000001c0U) >> 6)
#define RADIO130NM_RXTXBB3_CH1__IBN_25U_LO2_CTRL__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 6) & 0x000001c0U)
#define RADIO130NM_RXTXBB3_CH1__IBN_25U_LO2_CTRL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000001c0U) | (((u_int32_t)(src) <<\
                    6) & 0x000001c0U)
#define RADIO130NM_RXTXBB3_CH1__IBN_25U_LO2_CTRL__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 6) & ~0x000001c0U)))

/* macros for field IBN_25U_LO1_CTRL */
#define RADIO130NM_RXTXBB3_CH1__IBN_25U_LO1_CTRL__SHIFT                       9
#define RADIO130NM_RXTXBB3_CH1__IBN_25U_LO1_CTRL__WIDTH                       3
#define RADIO130NM_RXTXBB3_CH1__IBN_25U_LO1_CTRL__MASK              0x00000e00U
#define RADIO130NM_RXTXBB3_CH1__IBN_25U_LO1_CTRL__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000e00U) >> 9)
#define RADIO130NM_RXTXBB3_CH1__IBN_25U_LO1_CTRL__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 9) & 0x00000e00U)
#define RADIO130NM_RXTXBB3_CH1__IBN_25U_LO1_CTRL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000e00U) | (((u_int32_t)(src) <<\
                    9) & 0x00000e00U)
#define RADIO130NM_RXTXBB3_CH1__IBN_25U_LO1_CTRL__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 9) & ~0x00000e00U)))

/* macros for field IBN_25U_HI2_CTRL */
#define RADIO130NM_RXTXBB3_CH1__IBN_25U_HI2_CTRL__SHIFT                      12
#define RADIO130NM_RXTXBB3_CH1__IBN_25U_HI2_CTRL__WIDTH                       3
#define RADIO130NM_RXTXBB3_CH1__IBN_25U_HI2_CTRL__MASK              0x00007000U
#define RADIO130NM_RXTXBB3_CH1__IBN_25U_HI2_CTRL__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00007000U) >> 12)
#define RADIO130NM_RXTXBB3_CH1__IBN_25U_HI2_CTRL__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 12) & 0x00007000U)
#define RADIO130NM_RXTXBB3_CH1__IBN_25U_HI2_CTRL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00007000U) | (((u_int32_t)(src) <<\
                    12) & 0x00007000U)
#define RADIO130NM_RXTXBB3_CH1__IBN_25U_HI2_CTRL__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 12) & ~0x00007000U)))

/* macros for field IBN_25U_HI1_CTRL */
#define RADIO130NM_RXTXBB3_CH1__IBN_25U_HI1_CTRL__SHIFT                      15
#define RADIO130NM_RXTXBB3_CH1__IBN_25U_HI1_CTRL__WIDTH                       3
#define RADIO130NM_RXTXBB3_CH1__IBN_25U_HI1_CTRL__MASK              0x00038000U
#define RADIO130NM_RXTXBB3_CH1__IBN_25U_HI1_CTRL__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00038000U) >> 15)
#define RADIO130NM_RXTXBB3_CH1__IBN_25U_HI1_CTRL__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 15) & 0x00038000U)
#define RADIO130NM_RXTXBB3_CH1__IBN_25U_HI1_CTRL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00038000U) | (((u_int32_t)(src) <<\
                    15) & 0x00038000U)
#define RADIO130NM_RXTXBB3_CH1__IBN_25U_HI1_CTRL__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 15) & ~0x00038000U)))

/* macros for field IBN_25U_I2V_CTRL */
#define RADIO130NM_RXTXBB3_CH1__IBN_25U_I2V_CTRL__SHIFT                      18
#define RADIO130NM_RXTXBB3_CH1__IBN_25U_I2V_CTRL__WIDTH                       3
#define RADIO130NM_RXTXBB3_CH1__IBN_25U_I2V_CTRL__MASK              0x001c0000U
#define RADIO130NM_RXTXBB3_CH1__IBN_25U_I2V_CTRL__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x001c0000U) >> 18)
#define RADIO130NM_RXTXBB3_CH1__IBN_25U_I2V_CTRL__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 18) & 0x001c0000U)
#define RADIO130NM_RXTXBB3_CH1__IBN_25U_I2V_CTRL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x001c0000U) | (((u_int32_t)(src) <<\
                    18) & 0x001c0000U)
#define RADIO130NM_RXTXBB3_CH1__IBN_25U_I2V_CTRL__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 18) & ~0x001c0000U)))

/* macros for field IBN_25U_BKV2I_CTRL */
#define RADIO130NM_RXTXBB3_CH1__IBN_25U_BKV2I_CTRL__SHIFT                    21
#define RADIO130NM_RXTXBB3_CH1__IBN_25U_BKV2I_CTRL__WIDTH                     3
#define RADIO130NM_RXTXBB3_CH1__IBN_25U_BKV2I_CTRL__MASK            0x00e00000U
#define RADIO130NM_RXTXBB3_CH1__IBN_25U_BKV2I_CTRL__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00e00000U) >> 21)
#define RADIO130NM_RXTXBB3_CH1__IBN_25U_BKV2I_CTRL__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 21) & 0x00e00000U)
#define RADIO130NM_RXTXBB3_CH1__IBN_25U_BKV2I_CTRL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00e00000U) | (((u_int32_t)(src) <<\
                    21) & 0x00e00000U)
#define RADIO130NM_RXTXBB3_CH1__IBN_25U_BKV2I_CTRL__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 21) & ~0x00e00000U)))

/* macros for field IBN_25U_CM_BUFAMP_CTRL */
#define RADIO130NM_RXTXBB3_CH1__IBN_25U_CM_BUFAMP_CTRL__SHIFT                24
#define RADIO130NM_RXTXBB3_CH1__IBN_25U_CM_BUFAMP_CTRL__WIDTH                 3
#define RADIO130NM_RXTXBB3_CH1__IBN_25U_CM_BUFAMP_CTRL__MASK        0x07000000U
#define RADIO130NM_RXTXBB3_CH1__IBN_25U_CM_BUFAMP_CTRL__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x07000000U) >> 24)
#define RADIO130NM_RXTXBB3_CH1__IBN_25U_CM_BUFAMP_CTRL__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 24) & 0x07000000U)
#define RADIO130NM_RXTXBB3_CH1__IBN_25U_CM_BUFAMP_CTRL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x07000000U) | (((u_int32_t)(src) <<\
                    24) & 0x07000000U)
#define RADIO130NM_RXTXBB3_CH1__IBN_25U_CM_BUFAMP_CTRL__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 24) & ~0x07000000U)))

/* macros for field SPARE */
#define RADIO130NM_RXTXBB3_CH1__SPARE__SHIFT                                 27
#define RADIO130NM_RXTXBB3_CH1__SPARE__WIDTH                                  5
#define RADIO130NM_RXTXBB3_CH1__SPARE__MASK                         0xf8000000U
#define RADIO130NM_RXTXBB3_CH1__SPARE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0xf8000000U) >> 27)
#define RADIO130NM_RXTXBB3_CH1__SPARE__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 27) & 0xf8000000U)
#define RADIO130NM_RXTXBB3_CH1__SPARE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xf8000000U) | (((u_int32_t)(src) <<\
                    27) & 0xf8000000U)
#define RADIO130NM_RXTXBB3_CH1__SPARE__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 27) & ~0xf8000000U)))
#define RADIO130NM_RXTXBB3_CH1__TYPE                                  u_int32_t
#define RADIO130NM_RXTXBB3_CH1__READ                                0xffffffffU
#define RADIO130NM_RXTXBB3_CH1__WRITE                               0xffffffffU

#endif /* __RADIO130NM_RXTXBB3_CH1_MACRO__ */


/* macros for merlin2_0_radio_reg_map.RXTXBB3_CH1 */
#define INST_MERLIN2_0_RADIO_REG_MAP__RXTXBB3_CH1__NUM                        1

/* macros for BlueprintGlobalNameSpace::RADIO130NM_RXTXBB4_CH1 */
#ifndef __RADIO130NM_RXTXBB4_CH1_MACRO__
#define __RADIO130NM_RXTXBB4_CH1_MACRO__

/* macros for field OFSTCORRI2VQ */
#define RADIO130NM_RXTXBB4_CH1__OFSTCORRI2VQ__SHIFT                           0
#define RADIO130NM_RXTXBB4_CH1__OFSTCORRI2VQ__WIDTH                           5
#define RADIO130NM_RXTXBB4_CH1__OFSTCORRI2VQ__MASK                  0x0000001fU
#define RADIO130NM_RXTXBB4_CH1__OFSTCORRI2VQ__READ(src) \
                    (u_int32_t)(src)\
                    & 0x0000001fU
#define RADIO130NM_RXTXBB4_CH1__OFSTCORRI2VQ__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x0000001fU)
#define RADIO130NM_RXTXBB4_CH1__OFSTCORRI2VQ__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000001fU) | ((u_int32_t)(src) &\
                    0x0000001fU)
#define RADIO130NM_RXTXBB4_CH1__OFSTCORRI2VQ__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x0000001fU)))

/* macros for field OFSTCORRI2VI */
#define RADIO130NM_RXTXBB4_CH1__OFSTCORRI2VI__SHIFT                           5
#define RADIO130NM_RXTXBB4_CH1__OFSTCORRI2VI__WIDTH                           5
#define RADIO130NM_RXTXBB4_CH1__OFSTCORRI2VI__MASK                  0x000003e0U
#define RADIO130NM_RXTXBB4_CH1__OFSTCORRI2VI__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x000003e0U) >> 5)
#define RADIO130NM_RXTXBB4_CH1__OFSTCORRI2VI__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 5) & 0x000003e0U)
#define RADIO130NM_RXTXBB4_CH1__OFSTCORRI2VI__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000003e0U) | (((u_int32_t)(src) <<\
                    5) & 0x000003e0U)
#define RADIO130NM_RXTXBB4_CH1__OFSTCORRI2VI__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 5) & ~0x000003e0U)))

/* macros for field OFSTCORRLOQ */
#define RADIO130NM_RXTXBB4_CH1__OFSTCORRLOQ__SHIFT                           10
#define RADIO130NM_RXTXBB4_CH1__OFSTCORRLOQ__WIDTH                            5
#define RADIO130NM_RXTXBB4_CH1__OFSTCORRLOQ__MASK                   0x00007c00U
#define RADIO130NM_RXTXBB4_CH1__OFSTCORRLOQ__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00007c00U) >> 10)
#define RADIO130NM_RXTXBB4_CH1__OFSTCORRLOQ__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 10) & 0x00007c00U)
#define RADIO130NM_RXTXBB4_CH1__OFSTCORRLOQ__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00007c00U) | (((u_int32_t)(src) <<\
                    10) & 0x00007c00U)
#define RADIO130NM_RXTXBB4_CH1__OFSTCORRLOQ__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 10) & ~0x00007c00U)))

/* macros for field OFSTCORRLOI */
#define RADIO130NM_RXTXBB4_CH1__OFSTCORRLOI__SHIFT                           15
#define RADIO130NM_RXTXBB4_CH1__OFSTCORRLOI__WIDTH                            5
#define RADIO130NM_RXTXBB4_CH1__OFSTCORRLOI__MASK                   0x000f8000U
#define RADIO130NM_RXTXBB4_CH1__OFSTCORRLOI__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x000f8000U) >> 15)
#define RADIO130NM_RXTXBB4_CH1__OFSTCORRLOI__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 15) & 0x000f8000U)
#define RADIO130NM_RXTXBB4_CH1__OFSTCORRLOI__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000f8000U) | (((u_int32_t)(src) <<\
                    15) & 0x000f8000U)
#define RADIO130NM_RXTXBB4_CH1__OFSTCORRLOI__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 15) & ~0x000f8000U)))

/* macros for field OFSTCORRHIQ */
#define RADIO130NM_RXTXBB4_CH1__OFSTCORRHIQ__SHIFT                           20
#define RADIO130NM_RXTXBB4_CH1__OFSTCORRHIQ__WIDTH                            5
#define RADIO130NM_RXTXBB4_CH1__OFSTCORRHIQ__MASK                   0x01f00000U
#define RADIO130NM_RXTXBB4_CH1__OFSTCORRHIQ__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x01f00000U) >> 20)
#define RADIO130NM_RXTXBB4_CH1__OFSTCORRHIQ__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 20) & 0x01f00000U)
#define RADIO130NM_RXTXBB4_CH1__OFSTCORRHIQ__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x01f00000U) | (((u_int32_t)(src) <<\
                    20) & 0x01f00000U)
#define RADIO130NM_RXTXBB4_CH1__OFSTCORRHIQ__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 20) & ~0x01f00000U)))

/* macros for field OFSTCORRHII */
#define RADIO130NM_RXTXBB4_CH1__OFSTCORRHII__SHIFT                           25
#define RADIO130NM_RXTXBB4_CH1__OFSTCORRHII__WIDTH                            5
#define RADIO130NM_RXTXBB4_CH1__OFSTCORRHII__MASK                   0x3e000000U
#define RADIO130NM_RXTXBB4_CH1__OFSTCORRHII__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x3e000000U) >> 25)
#define RADIO130NM_RXTXBB4_CH1__OFSTCORRHII__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 25) & 0x3e000000U)
#define RADIO130NM_RXTXBB4_CH1__OFSTCORRHII__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x3e000000U) | (((u_int32_t)(src) <<\
                    25) & 0x3e000000U)
#define RADIO130NM_RXTXBB4_CH1__OFSTCORRHII__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 25) & ~0x3e000000U)))

/* macros for field LOCALOFFSET */
#define RADIO130NM_RXTXBB4_CH1__LOCALOFFSET__SHIFT                           30
#define RADIO130NM_RXTXBB4_CH1__LOCALOFFSET__WIDTH                            1
#define RADIO130NM_RXTXBB4_CH1__LOCALOFFSET__MASK                   0x40000000U
#define RADIO130NM_RXTXBB4_CH1__LOCALOFFSET__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x40000000U) >> 30)
#define RADIO130NM_RXTXBB4_CH1__LOCALOFFSET__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 30) & 0x40000000U)
#define RADIO130NM_RXTXBB4_CH1__LOCALOFFSET__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x40000000U) | (((u_int32_t)(src) <<\
                    30) & 0x40000000U)
#define RADIO130NM_RXTXBB4_CH1__LOCALOFFSET__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 30) & ~0x40000000U)))
#define RADIO130NM_RXTXBB4_CH1__LOCALOFFSET__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x40000000U) | ((u_int32_t)(1) << 30)
#define RADIO130NM_RXTXBB4_CH1__LOCALOFFSET__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x40000000U) | ((u_int32_t)(0) << 30)

/* macros for field SPARE */
#define RADIO130NM_RXTXBB4_CH1__SPARE__SHIFT                                 31
#define RADIO130NM_RXTXBB4_CH1__SPARE__WIDTH                                  1
#define RADIO130NM_RXTXBB4_CH1__SPARE__MASK                         0x80000000U
#define RADIO130NM_RXTXBB4_CH1__SPARE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x80000000U) >> 31)
#define RADIO130NM_RXTXBB4_CH1__SPARE__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 31) & 0x80000000U)
#define RADIO130NM_RXTXBB4_CH1__SPARE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x80000000U) | (((u_int32_t)(src) <<\
                    31) & 0x80000000U)
#define RADIO130NM_RXTXBB4_CH1__SPARE__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 31) & ~0x80000000U)))
#define RADIO130NM_RXTXBB4_CH1__SPARE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x80000000U) | ((u_int32_t)(1) << 31)
#define RADIO130NM_RXTXBB4_CH1__SPARE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x80000000U) | ((u_int32_t)(0) << 31)
#define RADIO130NM_RXTXBB4_CH1__TYPE                                  u_int32_t
#define RADIO130NM_RXTXBB4_CH1__READ                                0xffffffffU
#define RADIO130NM_RXTXBB4_CH1__WRITE                               0xffffffffU

#endif /* __RADIO130NM_RXTXBB4_CH1_MACRO__ */


/* macros for merlin2_0_radio_reg_map.RXTXBB4_CH1 */
#define INST_MERLIN2_0_RADIO_REG_MAP__RXTXBB4_CH1__NUM                        1

/* macros for BlueprintGlobalNameSpace::RADIO130NM_RF2G1_CH1 */
#ifndef __RADIO130NM_RF2G1_CH1_MACRO__
#define __RADIO130NM_RF2G1_CH1_MACRO__

/* macros for field SPARES */
#define RADIO130NM_RF2G1_CH1__SPARES__SHIFT                                   0
#define RADIO130NM_RF2G1_CH1__SPARES__WIDTH                                   6
#define RADIO130NM_RF2G1_CH1__SPARES__MASK                          0x0000003fU
#define RADIO130NM_RF2G1_CH1__SPARES__READ(src)  (u_int32_t)(src) & 0x0000003fU
#define RADIO130NM_RF2G1_CH1__SPARES__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x0000003fU)
#define RADIO130NM_RF2G1_CH1__SPARES__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000003fU) | ((u_int32_t)(src) &\
                    0x0000003fU)
#define RADIO130NM_RF2G1_CH1__SPARES__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x0000003fU)))

/* macros for field REGLO_BYPASS */
#define RADIO130NM_RF2G1_CH1__REGLO_BYPASS__SHIFT                             6
#define RADIO130NM_RF2G1_CH1__REGLO_BYPASS__WIDTH                             1
#define RADIO130NM_RF2G1_CH1__REGLO_BYPASS__MASK                    0x00000040U
#define RADIO130NM_RF2G1_CH1__REGLO_BYPASS__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000040U) >> 6)
#define RADIO130NM_RF2G1_CH1__REGLO_BYPASS__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 6) & 0x00000040U)
#define RADIO130NM_RF2G1_CH1__REGLO_BYPASS__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000040U) | (((u_int32_t)(src) <<\
                    6) & 0x00000040U)
#define RADIO130NM_RF2G1_CH1__REGLO_BYPASS__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 6) & ~0x00000040U)))
#define RADIO130NM_RF2G1_CH1__REGLO_BYPASS__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000040U) | ((u_int32_t)(1) << 6)
#define RADIO130NM_RF2G1_CH1__REGLO_BYPASS__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000040U) | ((u_int32_t)(0) << 6)

/* macros for field REGLNA_BYPASS */
#define RADIO130NM_RF2G1_CH1__REGLNA_BYPASS__SHIFT                            7
#define RADIO130NM_RF2G1_CH1__REGLNA_BYPASS__WIDTH                            1
#define RADIO130NM_RF2G1_CH1__REGLNA_BYPASS__MASK                   0x00000080U
#define RADIO130NM_RF2G1_CH1__REGLNA_BYPASS__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000080U) >> 7)
#define RADIO130NM_RF2G1_CH1__REGLNA_BYPASS__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 7) & 0x00000080U)
#define RADIO130NM_RF2G1_CH1__REGLNA_BYPASS__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000080U) | (((u_int32_t)(src) <<\
                    7) & 0x00000080U)
#define RADIO130NM_RF2G1_CH1__REGLNA_BYPASS__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 7) & ~0x00000080U)))
#define RADIO130NM_RF2G1_CH1__REGLNA_BYPASS__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000080U) | ((u_int32_t)(1) << 7)
#define RADIO130NM_RF2G1_CH1__REGLNA_BYPASS__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000080U) | ((u_int32_t)(0) << 7)

/* macros for field PDIC25U_VGM */
#define RADIO130NM_RF2G1_CH1__PDIC25U_VGM__SHIFT                              8
#define RADIO130NM_RF2G1_CH1__PDIC25U_VGM__WIDTH                              3
#define RADIO130NM_RF2G1_CH1__PDIC25U_VGM__MASK                     0x00000700U
#define RADIO130NM_RF2G1_CH1__PDIC25U_VGM__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000700U) >> 8)
#define RADIO130NM_RF2G1_CH1__PDIC25U_VGM__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 8) & 0x00000700U)
#define RADIO130NM_RF2G1_CH1__PDIC25U_VGM__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000700U) | (((u_int32_t)(src) <<\
                    8) & 0x00000700U)
#define RADIO130NM_RF2G1_CH1__PDIC25U_VGM__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 8) & ~0x00000700U)))

/* macros for field PACA_SEL */
#define RADIO130NM_RF2G1_CH1__PACA_SEL__SHIFT                                11
#define RADIO130NM_RF2G1_CH1__PACA_SEL__WIDTH                                 2
#define RADIO130NM_RF2G1_CH1__PACA_SEL__MASK                        0x00001800U
#define RADIO130NM_RF2G1_CH1__PACA_SEL__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00001800U) >> 11)
#define RADIO130NM_RF2G1_CH1__PACA_SEL__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 11) & 0x00001800U)
#define RADIO130NM_RF2G1_CH1__PACA_SEL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00001800U) | (((u_int32_t)(src) <<\
                    11) & 0x00001800U)
#define RADIO130NM_RF2G1_CH1__PACA_SEL__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 11) & ~0x00001800U)))

/* macros for field LOCONTROL */
#define RADIO130NM_RF2G1_CH1__LOCONTROL__SHIFT                               13
#define RADIO130NM_RF2G1_CH1__LOCONTROL__WIDTH                                1
#define RADIO130NM_RF2G1_CH1__LOCONTROL__MASK                       0x00002000U
#define RADIO130NM_RF2G1_CH1__LOCONTROL__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00002000U) >> 13)
#define RADIO130NM_RF2G1_CH1__LOCONTROL__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 13) & 0x00002000U)
#define RADIO130NM_RF2G1_CH1__LOCONTROL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00002000U) | (((u_int32_t)(src) <<\
                    13) & 0x00002000U)
#define RADIO130NM_RF2G1_CH1__LOCONTROL__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 13) & ~0x00002000U)))
#define RADIO130NM_RF2G1_CH1__LOCONTROL__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00002000U) | ((u_int32_t)(1) << 13)
#define RADIO130NM_RF2G1_CH1__LOCONTROL__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00002000U) | ((u_int32_t)(0) << 13)

/* macros for field TXATB_SEL */
#define RADIO130NM_RF2G1_CH1__TXATB_SEL__SHIFT                               14
#define RADIO130NM_RF2G1_CH1__TXATB_SEL__WIDTH                                3
#define RADIO130NM_RF2G1_CH1__TXATB_SEL__MASK                       0x0001c000U
#define RADIO130NM_RF2G1_CH1__TXATB_SEL__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0001c000U) >> 14)
#define RADIO130NM_RF2G1_CH1__TXATB_SEL__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 14) & 0x0001c000U)
#define RADIO130NM_RF2G1_CH1__TXATB_SEL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0001c000U) | (((u_int32_t)(src) <<\
                    14) & 0x0001c000U)
#define RADIO130NM_RF2G1_CH1__TXATB_SEL__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 14) & ~0x0001c000U)))

/* macros for field RXATB_SEL */
#define RADIO130NM_RF2G1_CH1__RXATB_SEL__SHIFT                               17
#define RADIO130NM_RF2G1_CH1__RXATB_SEL__WIDTH                                3
#define RADIO130NM_RF2G1_CH1__RXATB_SEL__MASK                       0x000e0000U
#define RADIO130NM_RF2G1_CH1__RXATB_SEL__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x000e0000U) >> 17)
#define RADIO130NM_RF2G1_CH1__RXATB_SEL__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 17) & 0x000e0000U)
#define RADIO130NM_RF2G1_CH1__RXATB_SEL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000e0000U) | (((u_int32_t)(src) <<\
                    17) & 0x000e0000U)
#define RADIO130NM_RF2G1_CH1__RXATB_SEL__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 17) & ~0x000e0000U)))

/* macros for field LOATB_SEL */
#define RADIO130NM_RF2G1_CH1__LOATB_SEL__SHIFT                               20
#define RADIO130NM_RF2G1_CH1__LOATB_SEL__WIDTH                                3
#define RADIO130NM_RF2G1_CH1__LOATB_SEL__MASK                       0x00700000U
#define RADIO130NM_RF2G1_CH1__LOATB_SEL__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00700000U) >> 20)
#define RADIO130NM_RF2G1_CH1__LOATB_SEL__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 20) & 0x00700000U)
#define RADIO130NM_RF2G1_CH1__LOATB_SEL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00700000U) | (((u_int32_t)(src) <<\
                    20) & 0x00700000U)
#define RADIO130NM_RF2G1_CH1__LOATB_SEL__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 20) & ~0x00700000U)))

/* macros for field OB */
#define RADIO130NM_RF2G1_CH1__OB__SHIFT                                      23
#define RADIO130NM_RF2G1_CH1__OB__WIDTH                                       3
#define RADIO130NM_RF2G1_CH1__OB__MASK                              0x03800000U
#define RADIO130NM_RF2G1_CH1__OB__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x03800000U) >> 23)
#define RADIO130NM_RF2G1_CH1__OB__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 23) & 0x03800000U)
#define RADIO130NM_RF2G1_CH1__OB__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x03800000U) | (((u_int32_t)(src) <<\
                    23) & 0x03800000U)
#define RADIO130NM_RF2G1_CH1__OB__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 23) & ~0x03800000U)))

/* macros for field DB */
#define RADIO130NM_RF2G1_CH1__DB__SHIFT                                      26
#define RADIO130NM_RF2G1_CH1__DB__WIDTH                                       3
#define RADIO130NM_RF2G1_CH1__DB__MASK                              0x1c000000U
#define RADIO130NM_RF2G1_CH1__DB__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x1c000000U) >> 26)
#define RADIO130NM_RF2G1_CH1__DB__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 26) & 0x1c000000U)
#define RADIO130NM_RF2G1_CH1__DB__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x1c000000U) | (((u_int32_t)(src) <<\
                    26) & 0x1c000000U)
#define RADIO130NM_RF2G1_CH1__DB__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 26) & ~0x1c000000U)))

/* macros for field PDIC25U_LNA */
#define RADIO130NM_RF2G1_CH1__PDIC25U_LNA__SHIFT                             29
#define RADIO130NM_RF2G1_CH1__PDIC25U_LNA__WIDTH                              3
#define RADIO130NM_RF2G1_CH1__PDIC25U_LNA__MASK                     0xe0000000U
#define RADIO130NM_RF2G1_CH1__PDIC25U_LNA__READ(src) \
                    (((u_int32_t)(src)\
                    & 0xe0000000U) >> 29)
#define RADIO130NM_RF2G1_CH1__PDIC25U_LNA__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 29) & 0xe0000000U)
#define RADIO130NM_RF2G1_CH1__PDIC25U_LNA__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xe0000000U) | (((u_int32_t)(src) <<\
                    29) & 0xe0000000U)
#define RADIO130NM_RF2G1_CH1__PDIC25U_LNA__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 29) & ~0xe0000000U)))
#define RADIO130NM_RF2G1_CH1__TYPE                                    u_int32_t
#define RADIO130NM_RF2G1_CH1__READ                                  0xffffffffU
#define RADIO130NM_RF2G1_CH1__WRITE                                 0xffffffffU

#endif /* __RADIO130NM_RF2G1_CH1_MACRO__ */


/* macros for merlin2_0_radio_reg_map.RF2G1_CH1 */
#define INST_MERLIN2_0_RADIO_REG_MAP__RF2G1_CH1__NUM                          1

/* macros for BlueprintGlobalNameSpace::RADIO130NM_RF2G2_CH1 */
#ifndef __RADIO130NM_RF2G2_CH1_MACRO__
#define __RADIO130NM_RF2G2_CH1_MACRO__

/* macros for field PDIR25U_VREGLO */
#define RADIO130NM_RF2G2_CH1__PDIR25U_VREGLO__SHIFT                           0
#define RADIO130NM_RF2G2_CH1__PDIR25U_VREGLO__WIDTH                           3
#define RADIO130NM_RF2G2_CH1__PDIR25U_VREGLO__MASK                  0x00000007U
#define RADIO130NM_RF2G2_CH1__PDIR25U_VREGLO__READ(src) \
                    (u_int32_t)(src)\
                    & 0x00000007U
#define RADIO130NM_RF2G2_CH1__PDIR25U_VREGLO__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x00000007U)
#define RADIO130NM_RF2G2_CH1__PDIR25U_VREGLO__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000007U) | ((u_int32_t)(src) &\
                    0x00000007U)
#define RADIO130NM_RF2G2_CH1__PDIR25U_VREGLO__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00000007U)))

/* macros for field PDIC25U_VREGLO */
#define RADIO130NM_RF2G2_CH1__PDIC25U_VREGLO__SHIFT                           3
#define RADIO130NM_RF2G2_CH1__PDIC25U_VREGLO__WIDTH                           3
#define RADIO130NM_RF2G2_CH1__PDIC25U_VREGLO__MASK                  0x00000038U
#define RADIO130NM_RF2G2_CH1__PDIC25U_VREGLO__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000038U) >> 3)
#define RADIO130NM_RF2G2_CH1__PDIC25U_VREGLO__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 3) & 0x00000038U)
#define RADIO130NM_RF2G2_CH1__PDIC25U_VREGLO__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000038U) | (((u_int32_t)(src) <<\
                    3) & 0x00000038U)
#define RADIO130NM_RF2G2_CH1__PDIC25U_VREGLO__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 3) & ~0x00000038U)))

/* macros for field PDIC50U_DIV */
#define RADIO130NM_RF2G2_CH1__PDIC50U_DIV__SHIFT                              6
#define RADIO130NM_RF2G2_CH1__PDIC50U_DIV__WIDTH                              3
#define RADIO130NM_RF2G2_CH1__PDIC50U_DIV__MASK                     0x000001c0U
#define RADIO130NM_RF2G2_CH1__PDIC50U_DIV__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x000001c0U) >> 6)
#define RADIO130NM_RF2G2_CH1__PDIC50U_DIV__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 6) & 0x000001c0U)
#define RADIO130NM_RF2G2_CH1__PDIC50U_DIV__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000001c0U) | (((u_int32_t)(src) <<\
                    6) & 0x000001c0U)
#define RADIO130NM_RF2G2_CH1__PDIC50U_DIV__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 6) & ~0x000001c0U)))

/* macros for field PDIC25U_RXRF */
#define RADIO130NM_RF2G2_CH1__PDIC25U_RXRF__SHIFT                             9
#define RADIO130NM_RF2G2_CH1__PDIC25U_RXRF__WIDTH                             3
#define RADIO130NM_RF2G2_CH1__PDIC25U_RXRF__MASK                    0x00000e00U
#define RADIO130NM_RF2G2_CH1__PDIC25U_RXRF__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000e00U) >> 9)
#define RADIO130NM_RF2G2_CH1__PDIC25U_RXRF__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 9) & 0x00000e00U)
#define RADIO130NM_RF2G2_CH1__PDIC25U_RXRF__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000e00U) | (((u_int32_t)(src) <<\
                    9) & 0x00000e00U)
#define RADIO130NM_RF2G2_CH1__PDIC25U_RXRF__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 9) & ~0x00000e00U)))

/* macros for field PDIC25U_TXRF */
#define RADIO130NM_RF2G2_CH1__PDIC25U_TXRF__SHIFT                            12
#define RADIO130NM_RF2G2_CH1__PDIC25U_TXRF__WIDTH                             3
#define RADIO130NM_RF2G2_CH1__PDIC25U_TXRF__MASK                    0x00007000U
#define RADIO130NM_RF2G2_CH1__PDIC25U_TXRF__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00007000U) >> 12)
#define RADIO130NM_RF2G2_CH1__PDIC25U_TXRF__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 12) & 0x00007000U)
#define RADIO130NM_RF2G2_CH1__PDIC25U_TXRF__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00007000U) | (((u_int32_t)(src) <<\
                    12) & 0x00007000U)
#define RADIO130NM_RF2G2_CH1__PDIC25U_TXRF__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 12) & ~0x00007000U)))

/* macros for field PDIC25U_TXPA */
#define RADIO130NM_RF2G2_CH1__PDIC25U_TXPA__SHIFT                            15
#define RADIO130NM_RF2G2_CH1__PDIC25U_TXPA__WIDTH                             3
#define RADIO130NM_RF2G2_CH1__PDIC25U_TXPA__MASK                    0x00038000U
#define RADIO130NM_RF2G2_CH1__PDIC25U_TXPA__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00038000U) >> 15)
#define RADIO130NM_RF2G2_CH1__PDIC25U_TXPA__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 15) & 0x00038000U)
#define RADIO130NM_RF2G2_CH1__PDIC25U_TXPA__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00038000U) | (((u_int32_t)(src) <<\
                    15) & 0x00038000U)
#define RADIO130NM_RF2G2_CH1__PDIC25U_TXPA__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 15) & ~0x00038000U)))

/* macros for field PDIR25U_TXPA */
#define RADIO130NM_RF2G2_CH1__PDIR25U_TXPA__SHIFT                            18
#define RADIO130NM_RF2G2_CH1__PDIR25U_TXPA__WIDTH                             1
#define RADIO130NM_RF2G2_CH1__PDIR25U_TXPA__MASK                    0x00040000U
#define RADIO130NM_RF2G2_CH1__PDIR25U_TXPA__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00040000U) >> 18)
#define RADIO130NM_RF2G2_CH1__PDIR25U_TXPA__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 18) & 0x00040000U)
#define RADIO130NM_RF2G2_CH1__PDIR25U_TXPA__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00040000U) | (((u_int32_t)(src) <<\
                    18) & 0x00040000U)
#define RADIO130NM_RF2G2_CH1__PDIR25U_TXPA__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 18) & ~0x00040000U)))
#define RADIO130NM_RF2G2_CH1__PDIR25U_TXPA__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00040000U) | ((u_int32_t)(1) << 18)
#define RADIO130NM_RF2G2_CH1__PDIR25U_TXPA__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00040000U) | ((u_int32_t)(0) << 18)

/* macros for field PDIR25U_TXMIX */
#define RADIO130NM_RF2G2_CH1__PDIR25U_TXMIX__SHIFT                           19
#define RADIO130NM_RF2G2_CH1__PDIR25U_TXMIX__WIDTH                            3
#define RADIO130NM_RF2G2_CH1__PDIR25U_TXMIX__MASK                   0x00380000U
#define RADIO130NM_RF2G2_CH1__PDIR25U_TXMIX__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00380000U) >> 19)
#define RADIO130NM_RF2G2_CH1__PDIR25U_TXMIX__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 19) & 0x00380000U)
#define RADIO130NM_RF2G2_CH1__PDIR25U_TXMIX__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00380000U) | (((u_int32_t)(src) <<\
                    19) & 0x00380000U)
#define RADIO130NM_RF2G2_CH1__PDIR25U_TXMIX__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 19) & ~0x00380000U)))

/* macros for field PDTXMIX */
#define RADIO130NM_RF2G2_CH1__PDTXMIX__SHIFT                                 22
#define RADIO130NM_RF2G2_CH1__PDTXMIX__WIDTH                                  1
#define RADIO130NM_RF2G2_CH1__PDTXMIX__MASK                         0x00400000U
#define RADIO130NM_RF2G2_CH1__PDTXMIX__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00400000U) >> 22)
#define RADIO130NM_RF2G2_CH1__PDTXMIX__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 22) & 0x00400000U)
#define RADIO130NM_RF2G2_CH1__PDTXMIX__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00400000U) | (((u_int32_t)(src) <<\
                    22) & 0x00400000U)
#define RADIO130NM_RF2G2_CH1__PDTXMIX__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 22) & ~0x00400000U)))
#define RADIO130NM_RF2G2_CH1__PDTXMIX__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00400000U) | ((u_int32_t)(1) << 22)
#define RADIO130NM_RF2G2_CH1__PDTXMIX__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00400000U) | ((u_int32_t)(0) << 22)

/* macros for field PDTXLO */
#define RADIO130NM_RF2G2_CH1__PDTXLO__SHIFT                                  23
#define RADIO130NM_RF2G2_CH1__PDTXLO__WIDTH                                   1
#define RADIO130NM_RF2G2_CH1__PDTXLO__MASK                          0x00800000U
#define RADIO130NM_RF2G2_CH1__PDTXLO__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00800000U) >> 23)
#define RADIO130NM_RF2G2_CH1__PDTXLO__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 23) & 0x00800000U)
#define RADIO130NM_RF2G2_CH1__PDTXLO__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00800000U) | (((u_int32_t)(src) <<\
                    23) & 0x00800000U)
#define RADIO130NM_RF2G2_CH1__PDTXLO__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 23) & ~0x00800000U)))
#define RADIO130NM_RF2G2_CH1__PDTXLO__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00800000U) | ((u_int32_t)(1) << 23)
#define RADIO130NM_RF2G2_CH1__PDTXLO__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00800000U) | ((u_int32_t)(0) << 23)

/* macros for field PDRXLO */
#define RADIO130NM_RF2G2_CH1__PDRXLO__SHIFT                                  24
#define RADIO130NM_RF2G2_CH1__PDRXLO__WIDTH                                   1
#define RADIO130NM_RF2G2_CH1__PDRXLO__MASK                          0x01000000U
#define RADIO130NM_RF2G2_CH1__PDRXLO__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x01000000U) >> 24)
#define RADIO130NM_RF2G2_CH1__PDRXLO__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 24) & 0x01000000U)
#define RADIO130NM_RF2G2_CH1__PDRXLO__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x01000000U) | (((u_int32_t)(src) <<\
                    24) & 0x01000000U)
#define RADIO130NM_RF2G2_CH1__PDRXLO__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 24) & ~0x01000000U)))
#define RADIO130NM_RF2G2_CH1__PDRXLO__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x01000000U) | ((u_int32_t)(1) << 24)
#define RADIO130NM_RF2G2_CH1__PDRXLO__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x01000000U) | ((u_int32_t)(0) << 24)

/* macros for field PDVGM */
#define RADIO130NM_RF2G2_CH1__PDVGM__SHIFT                                   25
#define RADIO130NM_RF2G2_CH1__PDVGM__WIDTH                                    1
#define RADIO130NM_RF2G2_CH1__PDVGM__MASK                           0x02000000U
#define RADIO130NM_RF2G2_CH1__PDVGM__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x02000000U) >> 25)
#define RADIO130NM_RF2G2_CH1__PDVGM__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 25) & 0x02000000U)
#define RADIO130NM_RF2G2_CH1__PDVGM__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x02000000U) | (((u_int32_t)(src) <<\
                    25) & 0x02000000U)
#define RADIO130NM_RF2G2_CH1__PDVGM__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 25) & ~0x02000000U)))
#define RADIO130NM_RF2G2_CH1__PDVGM__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x02000000U) | ((u_int32_t)(1) << 25)
#define RADIO130NM_RF2G2_CH1__PDVGM__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x02000000U) | ((u_int32_t)(0) << 25)

/* macros for field PDREGLO */
#define RADIO130NM_RF2G2_CH1__PDREGLO__SHIFT                                 26
#define RADIO130NM_RF2G2_CH1__PDREGLO__WIDTH                                  1
#define RADIO130NM_RF2G2_CH1__PDREGLO__MASK                         0x04000000U
#define RADIO130NM_RF2G2_CH1__PDREGLO__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x04000000U) >> 26)
#define RADIO130NM_RF2G2_CH1__PDREGLO__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 26) & 0x04000000U)
#define RADIO130NM_RF2G2_CH1__PDREGLO__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x04000000U) | (((u_int32_t)(src) <<\
                    26) & 0x04000000U)
#define RADIO130NM_RF2G2_CH1__PDREGLO__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 26) & ~0x04000000U)))
#define RADIO130NM_RF2G2_CH1__PDREGLO__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x04000000U) | ((u_int32_t)(1) << 26)
#define RADIO130NM_RF2G2_CH1__PDREGLO__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x04000000U) | ((u_int32_t)(0) << 26)

/* macros for field PDREGLNA */
#define RADIO130NM_RF2G2_CH1__PDREGLNA__SHIFT                                27
#define RADIO130NM_RF2G2_CH1__PDREGLNA__WIDTH                                 1
#define RADIO130NM_RF2G2_CH1__PDREGLNA__MASK                        0x08000000U
#define RADIO130NM_RF2G2_CH1__PDREGLNA__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x08000000U) >> 27)
#define RADIO130NM_RF2G2_CH1__PDREGLNA__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 27) & 0x08000000U)
#define RADIO130NM_RF2G2_CH1__PDREGLNA__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x08000000U) | (((u_int32_t)(src) <<\
                    27) & 0x08000000U)
#define RADIO130NM_RF2G2_CH1__PDREGLNA__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 27) & ~0x08000000U)))
#define RADIO130NM_RF2G2_CH1__PDREGLNA__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x08000000U) | ((u_int32_t)(1) << 27)
#define RADIO130NM_RF2G2_CH1__PDREGLNA__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x08000000U) | ((u_int32_t)(0) << 27)

/* macros for field PDPAOUT */
#define RADIO130NM_RF2G2_CH1__PDPAOUT__SHIFT                                 28
#define RADIO130NM_RF2G2_CH1__PDPAOUT__WIDTH                                  1
#define RADIO130NM_RF2G2_CH1__PDPAOUT__MASK                         0x10000000U
#define RADIO130NM_RF2G2_CH1__PDPAOUT__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x10000000U) >> 28)
#define RADIO130NM_RF2G2_CH1__PDPAOUT__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 28) & 0x10000000U)
#define RADIO130NM_RF2G2_CH1__PDPAOUT__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x10000000U) | (((u_int32_t)(src) <<\
                    28) & 0x10000000U)
#define RADIO130NM_RF2G2_CH1__PDPAOUT__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 28) & ~0x10000000U)))
#define RADIO130NM_RF2G2_CH1__PDPAOUT__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x10000000U) | ((u_int32_t)(1) << 28)
#define RADIO130NM_RF2G2_CH1__PDPAOUT__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x10000000U) | ((u_int32_t)(0) << 28)

/* macros for field PDPADRV */
#define RADIO130NM_RF2G2_CH1__PDPADRV__SHIFT                                 29
#define RADIO130NM_RF2G2_CH1__PDPADRV__WIDTH                                  1
#define RADIO130NM_RF2G2_CH1__PDPADRV__MASK                         0x20000000U
#define RADIO130NM_RF2G2_CH1__PDPADRV__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x20000000U) >> 29)
#define RADIO130NM_RF2G2_CH1__PDPADRV__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 29) & 0x20000000U)
#define RADIO130NM_RF2G2_CH1__PDPADRV__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x20000000U) | (((u_int32_t)(src) <<\
                    29) & 0x20000000U)
#define RADIO130NM_RF2G2_CH1__PDPADRV__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 29) & ~0x20000000U)))
#define RADIO130NM_RF2G2_CH1__PDPADRV__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x20000000U) | ((u_int32_t)(1) << 29)
#define RADIO130NM_RF2G2_CH1__PDPADRV__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x20000000U) | ((u_int32_t)(0) << 29)

/* macros for field PDDIV */
#define RADIO130NM_RF2G2_CH1__PDDIV__SHIFT                                   30
#define RADIO130NM_RF2G2_CH1__PDDIV__WIDTH                                    1
#define RADIO130NM_RF2G2_CH1__PDDIV__MASK                           0x40000000U
#define RADIO130NM_RF2G2_CH1__PDDIV__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x40000000U) >> 30)
#define RADIO130NM_RF2G2_CH1__PDDIV__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 30) & 0x40000000U)
#define RADIO130NM_RF2G2_CH1__PDDIV__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x40000000U) | (((u_int32_t)(src) <<\
                    30) & 0x40000000U)
#define RADIO130NM_RF2G2_CH1__PDDIV__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 30) & ~0x40000000U)))
#define RADIO130NM_RF2G2_CH1__PDDIV__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x40000000U) | ((u_int32_t)(1) << 30)
#define RADIO130NM_RF2G2_CH1__PDDIV__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x40000000U) | ((u_int32_t)(0) << 30)

/* macros for field PDLNA */
#define RADIO130NM_RF2G2_CH1__PDLNA__SHIFT                                   31
#define RADIO130NM_RF2G2_CH1__PDLNA__WIDTH                                    1
#define RADIO130NM_RF2G2_CH1__PDLNA__MASK                           0x80000000U
#define RADIO130NM_RF2G2_CH1__PDLNA__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x80000000U) >> 31)
#define RADIO130NM_RF2G2_CH1__PDLNA__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 31) & 0x80000000U)
#define RADIO130NM_RF2G2_CH1__PDLNA__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x80000000U) | (((u_int32_t)(src) <<\
                    31) & 0x80000000U)
#define RADIO130NM_RF2G2_CH1__PDLNA__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 31) & ~0x80000000U)))
#define RADIO130NM_RF2G2_CH1__PDLNA__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x80000000U) | ((u_int32_t)(1) << 31)
#define RADIO130NM_RF2G2_CH1__PDLNA__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x80000000U) | ((u_int32_t)(0) << 31)
#define RADIO130NM_RF2G2_CH1__TYPE                                    u_int32_t
#define RADIO130NM_RF2G2_CH1__READ                                  0xffffffffU
#define RADIO130NM_RF2G2_CH1__WRITE                                 0xffffffffU

#endif /* __RADIO130NM_RF2G2_CH1_MACRO__ */


/* macros for merlin2_0_radio_reg_map.RF2G2_CH1 */
#define INST_MERLIN2_0_RADIO_REG_MAP__RF2G2_CH1__NUM                          1

/* macros for BlueprintGlobalNameSpace::RADIO130NM_RF5G1_CH1 */
#ifndef __RADIO130NM_RF5G1_CH1_MACRO__
#define __RADIO130NM_RF5G1_CH1_MACRO__

/* macros for field SPARE */
#define RADIO130NM_RF5G1_CH1__SPARE__SHIFT                                    0
#define RADIO130NM_RF5G1_CH1__SPARE__WIDTH                                   10
#define RADIO130NM_RF5G1_CH1__SPARE__MASK                           0x000003ffU
#define RADIO130NM_RF5G1_CH1__SPARE__READ(src)   (u_int32_t)(src) & 0x000003ffU
#define RADIO130NM_RF5G1_CH1__SPARE__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x000003ffU)
#define RADIO130NM_RF5G1_CH1__SPARE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000003ffU) | ((u_int32_t)(src) &\
                    0x000003ffU)
#define RADIO130NM_RF5G1_CH1__SPARE__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x000003ffU)))

/* macros for field PDREGLO5 */
#define RADIO130NM_RF5G1_CH1__PDREGLO5__SHIFT                                10
#define RADIO130NM_RF5G1_CH1__PDREGLO5__WIDTH                                 1
#define RADIO130NM_RF5G1_CH1__PDREGLO5__MASK                        0x00000400U
#define RADIO130NM_RF5G1_CH1__PDREGLO5__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000400U) >> 10)
#define RADIO130NM_RF5G1_CH1__PDREGLO5__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 10) & 0x00000400U)
#define RADIO130NM_RF5G1_CH1__PDREGLO5__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000400U) | (((u_int32_t)(src) <<\
                    10) & 0x00000400U)
#define RADIO130NM_RF5G1_CH1__PDREGLO5__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 10) & ~0x00000400U)))
#define RADIO130NM_RF5G1_CH1__PDREGLO5__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000400U) | ((u_int32_t)(1) << 10)
#define RADIO130NM_RF5G1_CH1__PDREGLO5__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000400U) | ((u_int32_t)(0) << 10)

/* macros for field REGLO_BYPASS5 */
#define RADIO130NM_RF5G1_CH1__REGLO_BYPASS5__SHIFT                           11
#define RADIO130NM_RF5G1_CH1__REGLO_BYPASS5__WIDTH                            1
#define RADIO130NM_RF5G1_CH1__REGLO_BYPASS5__MASK                   0x00000800U
#define RADIO130NM_RF5G1_CH1__REGLO_BYPASS5__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000800U) >> 11)
#define RADIO130NM_RF5G1_CH1__REGLO_BYPASS5__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 11) & 0x00000800U)
#define RADIO130NM_RF5G1_CH1__REGLO_BYPASS5__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000800U) | (((u_int32_t)(src) <<\
                    11) & 0x00000800U)
#define RADIO130NM_RF5G1_CH1__REGLO_BYPASS5__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 11) & ~0x00000800U)))
#define RADIO130NM_RF5G1_CH1__REGLO_BYPASS5__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000800U) | ((u_int32_t)(1) << 11)
#define RADIO130NM_RF5G1_CH1__REGLO_BYPASS5__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000800U) | ((u_int32_t)(0) << 11)

/* macros for field LO5CONTROL */
#define RADIO130NM_RF5G1_CH1__LO5CONTROL__SHIFT                              12
#define RADIO130NM_RF5G1_CH1__LO5CONTROL__WIDTH                               1
#define RADIO130NM_RF5G1_CH1__LO5CONTROL__MASK                      0x00001000U
#define RADIO130NM_RF5G1_CH1__LO5CONTROL__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00001000U) >> 12)
#define RADIO130NM_RF5G1_CH1__LO5CONTROL__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 12) & 0x00001000U)
#define RADIO130NM_RF5G1_CH1__LO5CONTROL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00001000U) | (((u_int32_t)(src) <<\
                    12) & 0x00001000U)
#define RADIO130NM_RF5G1_CH1__LO5CONTROL__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 12) & ~0x00001000U)))
#define RADIO130NM_RF5G1_CH1__LO5CONTROL__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00001000U) | ((u_int32_t)(1) << 12)
#define RADIO130NM_RF5G1_CH1__LO5CONTROL__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00001000U) | ((u_int32_t)(0) << 12)

/* macros for field TX5_ATB_SEL */
#define RADIO130NM_RF5G1_CH1__TX5_ATB_SEL__SHIFT                             13
#define RADIO130NM_RF5G1_CH1__TX5_ATB_SEL__WIDTH                              3
#define RADIO130NM_RF5G1_CH1__TX5_ATB_SEL__MASK                     0x0000e000U
#define RADIO130NM_RF5G1_CH1__TX5_ATB_SEL__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0000e000U) >> 13)
#define RADIO130NM_RF5G1_CH1__TX5_ATB_SEL__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 13) & 0x0000e000U)
#define RADIO130NM_RF5G1_CH1__TX5_ATB_SEL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000e000U) | (((u_int32_t)(src) <<\
                    13) & 0x0000e000U)
#define RADIO130NM_RF5G1_CH1__TX5_ATB_SEL__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 13) & ~0x0000e000U)))

/* macros for field OB5 */
#define RADIO130NM_RF5G1_CH1__OB5__SHIFT                                     16
#define RADIO130NM_RF5G1_CH1__OB5__WIDTH                                      3
#define RADIO130NM_RF5G1_CH1__OB5__MASK                             0x00070000U
#define RADIO130NM_RF5G1_CH1__OB5__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00070000U) >> 16)
#define RADIO130NM_RF5G1_CH1__OB5__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 16) & 0x00070000U)
#define RADIO130NM_RF5G1_CH1__OB5__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00070000U) | (((u_int32_t)(src) <<\
                    16) & 0x00070000U)
#define RADIO130NM_RF5G1_CH1__OB5__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 16) & ~0x00070000U)))

/* macros for field DB5 */
#define RADIO130NM_RF5G1_CH1__DB5__SHIFT                                     19
#define RADIO130NM_RF5G1_CH1__DB5__WIDTH                                      3
#define RADIO130NM_RF5G1_CH1__DB5__MASK                             0x00380000U
#define RADIO130NM_RF5G1_CH1__DB5__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00380000U) >> 19)
#define RADIO130NM_RF5G1_CH1__DB5__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 19) & 0x00380000U)
#define RADIO130NM_RF5G1_CH1__DB5__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00380000U) | (((u_int32_t)(src) <<\
                    19) & 0x00380000U)
#define RADIO130NM_RF5G1_CH1__DB5__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 19) & ~0x00380000U)))

/* macros for field PWDTXPKD */
#define RADIO130NM_RF5G1_CH1__PWDTXPKD__SHIFT                                22
#define RADIO130NM_RF5G1_CH1__PWDTXPKD__WIDTH                                 3
#define RADIO130NM_RF5G1_CH1__PWDTXPKD__MASK                        0x01c00000U
#define RADIO130NM_RF5G1_CH1__PWDTXPKD__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x01c00000U) >> 22)
#define RADIO130NM_RF5G1_CH1__PWDTXPKD__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 22) & 0x01c00000U)
#define RADIO130NM_RF5G1_CH1__PWDTXPKD__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x01c00000U) | (((u_int32_t)(src) <<\
                    22) & 0x01c00000U)
#define RADIO130NM_RF5G1_CH1__PWDTXPKD__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 22) & ~0x01c00000U)))

/* macros for field PACASCBIAS */
#define RADIO130NM_RF5G1_CH1__PACASCBIAS__SHIFT                              25
#define RADIO130NM_RF5G1_CH1__PACASCBIAS__WIDTH                               2
#define RADIO130NM_RF5G1_CH1__PACASCBIAS__MASK                      0x06000000U
#define RADIO130NM_RF5G1_CH1__PACASCBIAS__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x06000000U) >> 25)
#define RADIO130NM_RF5G1_CH1__PACASCBIAS__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 25) & 0x06000000U)
#define RADIO130NM_RF5G1_CH1__PACASCBIAS__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x06000000U) | (((u_int32_t)(src) <<\
                    25) & 0x06000000U)
#define RADIO130NM_RF5G1_CH1__PACASCBIAS__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 25) & ~0x06000000U)))

/* macros for field PDPAOUT5 */
#define RADIO130NM_RF5G1_CH1__PDPAOUT5__SHIFT                                27
#define RADIO130NM_RF5G1_CH1__PDPAOUT5__WIDTH                                 1
#define RADIO130NM_RF5G1_CH1__PDPAOUT5__MASK                        0x08000000U
#define RADIO130NM_RF5G1_CH1__PDPAOUT5__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x08000000U) >> 27)
#define RADIO130NM_RF5G1_CH1__PDPAOUT5__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 27) & 0x08000000U)
#define RADIO130NM_RF5G1_CH1__PDPAOUT5__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x08000000U) | (((u_int32_t)(src) <<\
                    27) & 0x08000000U)
#define RADIO130NM_RF5G1_CH1__PDPAOUT5__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 27) & ~0x08000000U)))
#define RADIO130NM_RF5G1_CH1__PDPAOUT5__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x08000000U) | ((u_int32_t)(1) << 27)
#define RADIO130NM_RF5G1_CH1__PDPAOUT5__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x08000000U) | ((u_int32_t)(0) << 27)

/* macros for field PDPADRV5 */
#define RADIO130NM_RF5G1_CH1__PDPADRV5__SHIFT                                28
#define RADIO130NM_RF5G1_CH1__PDPADRV5__WIDTH                                 1
#define RADIO130NM_RF5G1_CH1__PDPADRV5__MASK                        0x10000000U
#define RADIO130NM_RF5G1_CH1__PDPADRV5__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x10000000U) >> 28)
#define RADIO130NM_RF5G1_CH1__PDPADRV5__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 28) & 0x10000000U)
#define RADIO130NM_RF5G1_CH1__PDPADRV5__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x10000000U) | (((u_int32_t)(src) <<\
                    28) & 0x10000000U)
#define RADIO130NM_RF5G1_CH1__PDPADRV5__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 28) & ~0x10000000U)))
#define RADIO130NM_RF5G1_CH1__PDPADRV5__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x10000000U) | ((u_int32_t)(1) << 28)
#define RADIO130NM_RF5G1_CH1__PDPADRV5__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x10000000U) | ((u_int32_t)(0) << 28)

/* macros for field PDTXBUF5 */
#define RADIO130NM_RF5G1_CH1__PDTXBUF5__SHIFT                                29
#define RADIO130NM_RF5G1_CH1__PDTXBUF5__WIDTH                                 1
#define RADIO130NM_RF5G1_CH1__PDTXBUF5__MASK                        0x20000000U
#define RADIO130NM_RF5G1_CH1__PDTXBUF5__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x20000000U) >> 29)
#define RADIO130NM_RF5G1_CH1__PDTXBUF5__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 29) & 0x20000000U)
#define RADIO130NM_RF5G1_CH1__PDTXBUF5__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x20000000U) | (((u_int32_t)(src) <<\
                    29) & 0x20000000U)
#define RADIO130NM_RF5G1_CH1__PDTXBUF5__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 29) & ~0x20000000U)))
#define RADIO130NM_RF5G1_CH1__PDTXBUF5__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x20000000U) | ((u_int32_t)(1) << 29)
#define RADIO130NM_RF5G1_CH1__PDTXBUF5__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x20000000U) | ((u_int32_t)(0) << 29)

/* macros for field PDTXMIX5 */
#define RADIO130NM_RF5G1_CH1__PDTXMIX5__SHIFT                                30
#define RADIO130NM_RF5G1_CH1__PDTXMIX5__WIDTH                                 1
#define RADIO130NM_RF5G1_CH1__PDTXMIX5__MASK                        0x40000000U
#define RADIO130NM_RF5G1_CH1__PDTXMIX5__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x40000000U) >> 30)
#define RADIO130NM_RF5G1_CH1__PDTXMIX5__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 30) & 0x40000000U)
#define RADIO130NM_RF5G1_CH1__PDTXMIX5__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x40000000U) | (((u_int32_t)(src) <<\
                    30) & 0x40000000U)
#define RADIO130NM_RF5G1_CH1__PDTXMIX5__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 30) & ~0x40000000U)))
#define RADIO130NM_RF5G1_CH1__PDTXMIX5__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x40000000U) | ((u_int32_t)(1) << 30)
#define RADIO130NM_RF5G1_CH1__PDTXMIX5__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x40000000U) | ((u_int32_t)(0) << 30)

/* macros for field PDTXLO5 */
#define RADIO130NM_RF5G1_CH1__PDTXLO5__SHIFT                                 31
#define RADIO130NM_RF5G1_CH1__PDTXLO5__WIDTH                                  1
#define RADIO130NM_RF5G1_CH1__PDTXLO5__MASK                         0x80000000U
#define RADIO130NM_RF5G1_CH1__PDTXLO5__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x80000000U) >> 31)
#define RADIO130NM_RF5G1_CH1__PDTXLO5__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 31) & 0x80000000U)
#define RADIO130NM_RF5G1_CH1__PDTXLO5__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x80000000U) | (((u_int32_t)(src) <<\
                    31) & 0x80000000U)
#define RADIO130NM_RF5G1_CH1__PDTXLO5__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 31) & ~0x80000000U)))
#define RADIO130NM_RF5G1_CH1__PDTXLO5__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x80000000U) | ((u_int32_t)(1) << 31)
#define RADIO130NM_RF5G1_CH1__PDTXLO5__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x80000000U) | ((u_int32_t)(0) << 31)
#define RADIO130NM_RF5G1_CH1__TYPE                                    u_int32_t
#define RADIO130NM_RF5G1_CH1__READ                                  0xffffffffU
#define RADIO130NM_RF5G1_CH1__WRITE                                 0xffffffffU

#endif /* __RADIO130NM_RF5G1_CH1_MACRO__ */


/* macros for merlin2_0_radio_reg_map.RF5G1_CH1 */
#define INST_MERLIN2_0_RADIO_REG_MAP__RF5G1_CH1__NUM                          1

/* macros for BlueprintGlobalNameSpace::RADIO130NM_RF5G2_CH1 */
#ifndef __RADIO130NM_RF5G2_CH1_MACRO__
#define __RADIO130NM_RF5G2_CH1_MACRO__

/* macros for field SPARE */
#define RADIO130NM_RF5G2_CH1__SPARE__SHIFT                                    0
#define RADIO130NM_RF5G2_CH1__SPARE__WIDTH                                   11
#define RADIO130NM_RF5G2_CH1__SPARE__MASK                           0x000007ffU
#define RADIO130NM_RF5G2_CH1__SPARE__READ(src)   (u_int32_t)(src) & 0x000007ffU
#define RADIO130NM_RF5G2_CH1__SPARE__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x000007ffU)
#define RADIO130NM_RF5G2_CH1__SPARE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000007ffU) | ((u_int32_t)(src) &\
                    0x000007ffU)
#define RADIO130NM_RF5G2_CH1__SPARE__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x000007ffU)))

/* macros for field PDBIR2 */
#define RADIO130NM_RF5G2_CH1__PDBIR2__SHIFT                                  11
#define RADIO130NM_RF5G2_CH1__PDBIR2__WIDTH                                   3
#define RADIO130NM_RF5G2_CH1__PDBIR2__MASK                          0x00003800U
#define RADIO130NM_RF5G2_CH1__PDBIR2__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00003800U) >> 11)
#define RADIO130NM_RF5G2_CH1__PDBIR2__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 11) & 0x00003800U)
#define RADIO130NM_RF5G2_CH1__PDBIR2__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00003800U) | (((u_int32_t)(src) <<\
                    11) & 0x00003800U)
#define RADIO130NM_RF5G2_CH1__PDBIR2__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 11) & ~0x00003800U)))

/* macros for field PDBIR1 */
#define RADIO130NM_RF5G2_CH1__PDBIR1__SHIFT                                  14
#define RADIO130NM_RF5G2_CH1__PDBIR1__WIDTH                                   3
#define RADIO130NM_RF5G2_CH1__PDBIR1__MASK                          0x0001c000U
#define RADIO130NM_RF5G2_CH1__PDBIR1__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0001c000U) >> 14)
#define RADIO130NM_RF5G2_CH1__PDBIR1__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 14) & 0x0001c000U)
#define RADIO130NM_RF5G2_CH1__PDBIR1__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0001c000U) | (((u_int32_t)(src) <<\
                    14) & 0x0001c000U)
#define RADIO130NM_RF5G2_CH1__PDBIR1__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 14) & ~0x0001c000U)))

/* macros for field PDBIRTXPA */
#define RADIO130NM_RF5G2_CH1__PDBIRTXPA__SHIFT                               17
#define RADIO130NM_RF5G2_CH1__PDBIRTXPA__WIDTH                                3
#define RADIO130NM_RF5G2_CH1__PDBIRTXPA__MASK                       0x000e0000U
#define RADIO130NM_RF5G2_CH1__PDBIRTXPA__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x000e0000U) >> 17)
#define RADIO130NM_RF5G2_CH1__PDBIRTXPA__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 17) & 0x000e0000U)
#define RADIO130NM_RF5G2_CH1__PDBIRTXPA__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000e0000U) | (((u_int32_t)(src) <<\
                    17) & 0x000e0000U)
#define RADIO130NM_RF5G2_CH1__PDBIRTXPA__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 17) & ~0x000e0000U)))

/* macros for field PDBIRTXMIX */
#define RADIO130NM_RF5G2_CH1__PDBIRTXMIX__SHIFT                              20
#define RADIO130NM_RF5G2_CH1__PDBIRTXMIX__WIDTH                               3
#define RADIO130NM_RF5G2_CH1__PDBIRTXMIX__MASK                      0x00700000U
#define RADIO130NM_RF5G2_CH1__PDBIRTXMIX__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00700000U) >> 20)
#define RADIO130NM_RF5G2_CH1__PDBIRTXMIX__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 20) & 0x00700000U)
#define RADIO130NM_RF5G2_CH1__PDBIRTXMIX__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00700000U) | (((u_int32_t)(src) <<\
                    20) & 0x00700000U)
#define RADIO130NM_RF5G2_CH1__PDBIRTXMIX__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 20) & ~0x00700000U)))

/* macros for field RX5_ATB_SEL */
#define RADIO130NM_RF5G2_CH1__RX5_ATB_SEL__SHIFT                             23
#define RADIO130NM_RF5G2_CH1__RX5_ATB_SEL__WIDTH                              3
#define RADIO130NM_RF5G2_CH1__RX5_ATB_SEL__MASK                     0x03800000U
#define RADIO130NM_RF5G2_CH1__RX5_ATB_SEL__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x03800000U) >> 23)
#define RADIO130NM_RF5G2_CH1__RX5_ATB_SEL__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 23) & 0x03800000U)
#define RADIO130NM_RF5G2_CH1__RX5_ATB_SEL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x03800000U) | (((u_int32_t)(src) <<\
                    23) & 0x03800000U)
#define RADIO130NM_RF5G2_CH1__RX5_ATB_SEL__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 23) & ~0x03800000U)))

/* macros for field PDRFVGA5 */
#define RADIO130NM_RF5G2_CH1__PDRFVGA5__SHIFT                                26
#define RADIO130NM_RF5G2_CH1__PDRFVGA5__WIDTH                                 1
#define RADIO130NM_RF5G2_CH1__PDRFVGA5__MASK                        0x04000000U
#define RADIO130NM_RF5G2_CH1__PDRFVGA5__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x04000000U) >> 26)
#define RADIO130NM_RF5G2_CH1__PDRFVGA5__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 26) & 0x04000000U)
#define RADIO130NM_RF5G2_CH1__PDRFVGA5__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x04000000U) | (((u_int32_t)(src) <<\
                    26) & 0x04000000U)
#define RADIO130NM_RF5G2_CH1__PDRFVGA5__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 26) & ~0x04000000U)))
#define RADIO130NM_RF5G2_CH1__PDRFVGA5__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x04000000U) | ((u_int32_t)(1) << 26)
#define RADIO130NM_RF5G2_CH1__PDRFVGA5__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x04000000U) | ((u_int32_t)(0) << 26)

/* macros for field PDCSLNA5 */
#define RADIO130NM_RF5G2_CH1__PDCSLNA5__SHIFT                                27
#define RADIO130NM_RF5G2_CH1__PDCSLNA5__WIDTH                                 1
#define RADIO130NM_RF5G2_CH1__PDCSLNA5__MASK                        0x08000000U
#define RADIO130NM_RF5G2_CH1__PDCSLNA5__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x08000000U) >> 27)
#define RADIO130NM_RF5G2_CH1__PDCSLNA5__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 27) & 0x08000000U)
#define RADIO130NM_RF5G2_CH1__PDCSLNA5__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x08000000U) | (((u_int32_t)(src) <<\
                    27) & 0x08000000U)
#define RADIO130NM_RF5G2_CH1__PDCSLNA5__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 27) & ~0x08000000U)))
#define RADIO130NM_RF5G2_CH1__PDCSLNA5__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x08000000U) | ((u_int32_t)(1) << 27)
#define RADIO130NM_RF5G2_CH1__PDCSLNA5__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x08000000U) | ((u_int32_t)(0) << 27)

/* macros for field PDVGM5 */
#define RADIO130NM_RF5G2_CH1__PDVGM5__SHIFT                                  28
#define RADIO130NM_RF5G2_CH1__PDVGM5__WIDTH                                   1
#define RADIO130NM_RF5G2_CH1__PDVGM5__MASK                          0x10000000U
#define RADIO130NM_RF5G2_CH1__PDVGM5__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x10000000U) >> 28)
#define RADIO130NM_RF5G2_CH1__PDVGM5__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 28) & 0x10000000U)
#define RADIO130NM_RF5G2_CH1__PDVGM5__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x10000000U) | (((u_int32_t)(src) <<\
                    28) & 0x10000000U)
#define RADIO130NM_RF5G2_CH1__PDVGM5__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 28) & ~0x10000000U)))
#define RADIO130NM_RF5G2_CH1__PDVGM5__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x10000000U) | ((u_int32_t)(1) << 28)
#define RADIO130NM_RF5G2_CH1__PDVGM5__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x10000000U) | ((u_int32_t)(0) << 28)

/* macros for field PDRXLO5 */
#define RADIO130NM_RF5G2_CH1__PDRXLO5__SHIFT                                 29
#define RADIO130NM_RF5G2_CH1__PDRXLO5__WIDTH                                  1
#define RADIO130NM_RF5G2_CH1__PDRXLO5__MASK                         0x20000000U
#define RADIO130NM_RF5G2_CH1__PDRXLO5__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x20000000U) >> 29)
#define RADIO130NM_RF5G2_CH1__PDRXLO5__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 29) & 0x20000000U)
#define RADIO130NM_RF5G2_CH1__PDRXLO5__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x20000000U) | (((u_int32_t)(src) <<\
                    29) & 0x20000000U)
#define RADIO130NM_RF5G2_CH1__PDRXLO5__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 29) & ~0x20000000U)))
#define RADIO130NM_RF5G2_CH1__PDRXLO5__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x20000000U) | ((u_int32_t)(1) << 29)
#define RADIO130NM_RF5G2_CH1__PDRXLO5__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x20000000U) | ((u_int32_t)(0) << 29)

/* macros for field PDREGFE5 */
#define RADIO130NM_RF5G2_CH1__PDREGFE5__SHIFT                                30
#define RADIO130NM_RF5G2_CH1__PDREGFE5__WIDTH                                 1
#define RADIO130NM_RF5G2_CH1__PDREGFE5__MASK                        0x40000000U
#define RADIO130NM_RF5G2_CH1__PDREGFE5__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x40000000U) >> 30)
#define RADIO130NM_RF5G2_CH1__PDREGFE5__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 30) & 0x40000000U)
#define RADIO130NM_RF5G2_CH1__PDREGFE5__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x40000000U) | (((u_int32_t)(src) <<\
                    30) & 0x40000000U)
#define RADIO130NM_RF5G2_CH1__PDREGFE5__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 30) & ~0x40000000U)))
#define RADIO130NM_RF5G2_CH1__PDREGFE5__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x40000000U) | ((u_int32_t)(1) << 30)
#define RADIO130NM_RF5G2_CH1__PDREGFE5__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x40000000U) | ((u_int32_t)(0) << 30)

/* macros for field REGFE_BYPASS5 */
#define RADIO130NM_RF5G2_CH1__REGFE_BYPASS5__SHIFT                           31
#define RADIO130NM_RF5G2_CH1__REGFE_BYPASS5__WIDTH                            1
#define RADIO130NM_RF5G2_CH1__REGFE_BYPASS5__MASK                   0x80000000U
#define RADIO130NM_RF5G2_CH1__REGFE_BYPASS5__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x80000000U) >> 31)
#define RADIO130NM_RF5G2_CH1__REGFE_BYPASS5__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 31) & 0x80000000U)
#define RADIO130NM_RF5G2_CH1__REGFE_BYPASS5__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x80000000U) | (((u_int32_t)(src) <<\
                    31) & 0x80000000U)
#define RADIO130NM_RF5G2_CH1__REGFE_BYPASS5__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 31) & ~0x80000000U)))
#define RADIO130NM_RF5G2_CH1__REGFE_BYPASS5__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x80000000U) | ((u_int32_t)(1) << 31)
#define RADIO130NM_RF5G2_CH1__REGFE_BYPASS5__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x80000000U) | ((u_int32_t)(0) << 31)
#define RADIO130NM_RF5G2_CH1__TYPE                                    u_int32_t
#define RADIO130NM_RF5G2_CH1__READ                                  0xffffffffU
#define RADIO130NM_RF5G2_CH1__WRITE                                 0xffffffffU

#endif /* __RADIO130NM_RF5G2_CH1_MACRO__ */


/* macros for merlin2_0_radio_reg_map.RF5G2_CH1 */
#define INST_MERLIN2_0_RADIO_REG_MAP__RF5G2_CH1__NUM                          1

/* macros for BlueprintGlobalNameSpace::RADIO130NM_RF5G3_CH1 */
#ifndef __RADIO130NM_RF5G3_CH1_MACRO__
#define __RADIO130NM_RF5G3_CH1_MACRO__

/* macros for field SPARE */
#define RADIO130NM_RF5G3_CH1__SPARE__SHIFT                                    0
#define RADIO130NM_RF5G3_CH1__SPARE__WIDTH                                    5
#define RADIO130NM_RF5G3_CH1__SPARE__MASK                           0x0000001fU
#define RADIO130NM_RF5G3_CH1__SPARE__READ(src)   (u_int32_t)(src) & 0x0000001fU
#define RADIO130NM_RF5G3_CH1__SPARE__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x0000001fU)
#define RADIO130NM_RF5G3_CH1__SPARE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000001fU) | ((u_int32_t)(src) &\
                    0x0000001fU)
#define RADIO130NM_RF5G3_CH1__SPARE__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x0000001fU)))

/* macros for field PDBIBCVGM */
#define RADIO130NM_RF5G3_CH1__PDBIBCVGM__SHIFT                                5
#define RADIO130NM_RF5G3_CH1__PDBIBCVGM__WIDTH                                3
#define RADIO130NM_RF5G3_CH1__PDBIBCVGM__MASK                       0x000000e0U
#define RADIO130NM_RF5G3_CH1__PDBIBCVGM__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x000000e0U) >> 5)
#define RADIO130NM_RF5G3_CH1__PDBIBCVGM__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 5) & 0x000000e0U)
#define RADIO130NM_RF5G3_CH1__PDBIBCVGM__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000000e0U) | (((u_int32_t)(src) <<\
                    5) & 0x000000e0U)
#define RADIO130NM_RF5G3_CH1__PDBIBCVGM__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 5) & ~0x000000e0U)))

/* macros for field PDBIBCRFVGA */
#define RADIO130NM_RF5G3_CH1__PDBIBCRFVGA__SHIFT                              8
#define RADIO130NM_RF5G3_CH1__PDBIBCRFVGA__WIDTH                              3
#define RADIO130NM_RF5G3_CH1__PDBIBCRFVGA__MASK                     0x00000700U
#define RADIO130NM_RF5G3_CH1__PDBIBCRFVGA__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000700U) >> 8)
#define RADIO130NM_RF5G3_CH1__PDBIBCRFVGA__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 8) & 0x00000700U)
#define RADIO130NM_RF5G3_CH1__PDBIBCRFVGA__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000700U) | (((u_int32_t)(src) <<\
                    8) & 0x00000700U)
#define RADIO130NM_RF5G3_CH1__PDBIBCRFVGA__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 8) & ~0x00000700U)))

/* macros for field PDBIBCLNA */
#define RADIO130NM_RF5G3_CH1__PDBIBCLNA__SHIFT                               11
#define RADIO130NM_RF5G3_CH1__PDBIBCLNA__WIDTH                                3
#define RADIO130NM_RF5G3_CH1__PDBIBCLNA__MASK                       0x00003800U
#define RADIO130NM_RF5G3_CH1__PDBIBCLNA__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00003800U) >> 11)
#define RADIO130NM_RF5G3_CH1__PDBIBCLNA__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 11) & 0x00003800U)
#define RADIO130NM_RF5G3_CH1__PDBIBCLNA__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00003800U) | (((u_int32_t)(src) <<\
                    11) & 0x00003800U)
#define RADIO130NM_RF5G3_CH1__PDBIBCLNA__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 11) & ~0x00003800U)))

/* macros for field PDBIC3 */
#define RADIO130NM_RF5G3_CH1__PDBIC3__SHIFT                                  14
#define RADIO130NM_RF5G3_CH1__PDBIC3__WIDTH                                   3
#define RADIO130NM_RF5G3_CH1__PDBIC3__MASK                          0x0001c000U
#define RADIO130NM_RF5G3_CH1__PDBIC3__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0001c000U) >> 14)
#define RADIO130NM_RF5G3_CH1__PDBIC3__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 14) & 0x0001c000U)
#define RADIO130NM_RF5G3_CH1__PDBIC3__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0001c000U) | (((u_int32_t)(src) <<\
                    14) & 0x0001c000U)
#define RADIO130NM_RF5G3_CH1__PDBIC3__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 14) & ~0x0001c000U)))

/* macros for field PDBIC2 */
#define RADIO130NM_RF5G3_CH1__PDBIC2__SHIFT                                  17
#define RADIO130NM_RF5G3_CH1__PDBIC2__WIDTH                                   3
#define RADIO130NM_RF5G3_CH1__PDBIC2__MASK                          0x000e0000U
#define RADIO130NM_RF5G3_CH1__PDBIC2__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x000e0000U) >> 17)
#define RADIO130NM_RF5G3_CH1__PDBIC2__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 17) & 0x000e0000U)
#define RADIO130NM_RF5G3_CH1__PDBIC2__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000e0000U) | (((u_int32_t)(src) <<\
                    17) & 0x000e0000U)
#define RADIO130NM_RF5G3_CH1__PDBIC2__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 17) & ~0x000e0000U)))

/* macros for field PDBIC1 */
#define RADIO130NM_RF5G3_CH1__PDBIC1__SHIFT                                  20
#define RADIO130NM_RF5G3_CH1__PDBIC1__WIDTH                                   3
#define RADIO130NM_RF5G3_CH1__PDBIC1__MASK                          0x00700000U
#define RADIO130NM_RF5G3_CH1__PDBIC1__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00700000U) >> 20)
#define RADIO130NM_RF5G3_CH1__PDBIC1__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 20) & 0x00700000U)
#define RADIO130NM_RF5G3_CH1__PDBIC1__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00700000U) | (((u_int32_t)(src) <<\
                    20) & 0x00700000U)
#define RADIO130NM_RF5G3_CH1__PDBIC1__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 20) & ~0x00700000U)))

/* macros for field PDBICTXMIX */
#define RADIO130NM_RF5G3_CH1__PDBICTXMIX__SHIFT                              23
#define RADIO130NM_RF5G3_CH1__PDBICTXMIX__WIDTH                               3
#define RADIO130NM_RF5G3_CH1__PDBICTXMIX__MASK                      0x03800000U
#define RADIO130NM_RF5G3_CH1__PDBICTXMIX__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x03800000U) >> 23)
#define RADIO130NM_RF5G3_CH1__PDBICTXMIX__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 23) & 0x03800000U)
#define RADIO130NM_RF5G3_CH1__PDBICTXMIX__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x03800000U) | (((u_int32_t)(src) <<\
                    23) & 0x03800000U)
#define RADIO130NM_RF5G3_CH1__PDBICTXMIX__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 23) & ~0x03800000U)))

/* macros for field PDBICTXPA */
#define RADIO130NM_RF5G3_CH1__PDBICTXPA__SHIFT                               26
#define RADIO130NM_RF5G3_CH1__PDBICTXPA__WIDTH                                3
#define RADIO130NM_RF5G3_CH1__PDBICTXPA__MASK                       0x1c000000U
#define RADIO130NM_RF5G3_CH1__PDBICTXPA__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x1c000000U) >> 26)
#define RADIO130NM_RF5G3_CH1__PDBICTXPA__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 26) & 0x1c000000U)
#define RADIO130NM_RF5G3_CH1__PDBICTXPA__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x1c000000U) | (((u_int32_t)(src) <<\
                    26) & 0x1c000000U)
#define RADIO130NM_RF5G3_CH1__PDBICTXPA__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 26) & ~0x1c000000U)))

/* macros for field PDBICTXBUF */
#define RADIO130NM_RF5G3_CH1__PDBICTXBUF__SHIFT                              29
#define RADIO130NM_RF5G3_CH1__PDBICTXBUF__WIDTH                               3
#define RADIO130NM_RF5G3_CH1__PDBICTXBUF__MASK                      0xe0000000U
#define RADIO130NM_RF5G3_CH1__PDBICTXBUF__READ(src) \
                    (((u_int32_t)(src)\
                    & 0xe0000000U) >> 29)
#define RADIO130NM_RF5G3_CH1__PDBICTXBUF__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 29) & 0xe0000000U)
#define RADIO130NM_RF5G3_CH1__PDBICTXBUF__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xe0000000U) | (((u_int32_t)(src) <<\
                    29) & 0xe0000000U)
#define RADIO130NM_RF5G3_CH1__PDBICTXBUF__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 29) & ~0xe0000000U)))
#define RADIO130NM_RF5G3_CH1__TYPE                                    u_int32_t
#define RADIO130NM_RF5G3_CH1__READ                                  0xffffffffU
#define RADIO130NM_RF5G3_CH1__WRITE                                 0xffffffffU

#endif /* __RADIO130NM_RF5G3_CH1_MACRO__ */


/* macros for merlin2_0_radio_reg_map.RF5G3_CH1 */
#define INST_MERLIN2_0_RADIO_REG_MAP__RF5G3_CH1__NUM                          1

/* macros for BlueprintGlobalNameSpace::RADIO130NM_RXTXBB1_CH0 */
#ifndef __RADIO130NM_RXTXBB1_CH0_MACRO__
#define __RADIO130NM_RXTXBB1_CH0_MACRO__

/* macros for field PDHIQ */
#define RADIO130NM_RXTXBB1_CH0__PDHIQ__SHIFT                                  0
#define RADIO130NM_RXTXBB1_CH0__PDHIQ__WIDTH                                  1
#define RADIO130NM_RXTXBB1_CH0__PDHIQ__MASK                         0x00000001U
#define RADIO130NM_RXTXBB1_CH0__PDHIQ__READ(src) (u_int32_t)(src) & 0x00000001U
#define RADIO130NM_RXTXBB1_CH0__PDHIQ__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x00000001U)
#define RADIO130NM_RXTXBB1_CH0__PDHIQ__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | ((u_int32_t)(src) &\
                    0x00000001U)
#define RADIO130NM_RXTXBB1_CH0__PDHIQ__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00000001U)))
#define RADIO130NM_RXTXBB1_CH0__PDHIQ__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(1)
#define RADIO130NM_RXTXBB1_CH0__PDHIQ__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(0)

/* macros for field PDLOQ */
#define RADIO130NM_RXTXBB1_CH0__PDLOQ__SHIFT                                  1
#define RADIO130NM_RXTXBB1_CH0__PDLOQ__WIDTH                                  1
#define RADIO130NM_RXTXBB1_CH0__PDLOQ__MASK                         0x00000002U
#define RADIO130NM_RXTXBB1_CH0__PDLOQ__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000002U) >> 1)
#define RADIO130NM_RXTXBB1_CH0__PDLOQ__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 1) & 0x00000002U)
#define RADIO130NM_RXTXBB1_CH0__PDLOQ__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | (((u_int32_t)(src) <<\
                    1) & 0x00000002U)
#define RADIO130NM_RXTXBB1_CH0__PDLOQ__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 1) & ~0x00000002U)))
#define RADIO130NM_RXTXBB1_CH0__PDLOQ__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | ((u_int32_t)(1) << 1)
#define RADIO130NM_RXTXBB1_CH0__PDLOQ__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | ((u_int32_t)(0) << 1)

/* macros for field PDOFFSETI2V */
#define RADIO130NM_RXTXBB1_CH0__PDOFFSETI2V__SHIFT                            2
#define RADIO130NM_RXTXBB1_CH0__PDOFFSETI2V__WIDTH                            1
#define RADIO130NM_RXTXBB1_CH0__PDOFFSETI2V__MASK                   0x00000004U
#define RADIO130NM_RXTXBB1_CH0__PDOFFSETI2V__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000004U) >> 2)
#define RADIO130NM_RXTXBB1_CH0__PDOFFSETI2V__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 2) & 0x00000004U)
#define RADIO130NM_RXTXBB1_CH0__PDOFFSETI2V__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000004U) | (((u_int32_t)(src) <<\
                    2) & 0x00000004U)
#define RADIO130NM_RXTXBB1_CH0__PDOFFSETI2V__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 2) & ~0x00000004U)))
#define RADIO130NM_RXTXBB1_CH0__PDOFFSETI2V__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000004U) | ((u_int32_t)(1) << 2)
#define RADIO130NM_RXTXBB1_CH0__PDOFFSETI2V__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000004U) | ((u_int32_t)(0) << 2)

/* macros for field PDOFFSETHIQ */
#define RADIO130NM_RXTXBB1_CH0__PDOFFSETHIQ__SHIFT                            3
#define RADIO130NM_RXTXBB1_CH0__PDOFFSETHIQ__WIDTH                            1
#define RADIO130NM_RXTXBB1_CH0__PDOFFSETHIQ__MASK                   0x00000008U
#define RADIO130NM_RXTXBB1_CH0__PDOFFSETHIQ__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000008U) >> 3)
#define RADIO130NM_RXTXBB1_CH0__PDOFFSETHIQ__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 3) & 0x00000008U)
#define RADIO130NM_RXTXBB1_CH0__PDOFFSETHIQ__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000008U) | (((u_int32_t)(src) <<\
                    3) & 0x00000008U)
#define RADIO130NM_RXTXBB1_CH0__PDOFFSETHIQ__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 3) & ~0x00000008U)))
#define RADIO130NM_RXTXBB1_CH0__PDOFFSETHIQ__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000008U) | ((u_int32_t)(1) << 3)
#define RADIO130NM_RXTXBB1_CH0__PDOFFSETHIQ__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000008U) | ((u_int32_t)(0) << 3)

/* macros for field PDOFFSETLOQ */
#define RADIO130NM_RXTXBB1_CH0__PDOFFSETLOQ__SHIFT                            4
#define RADIO130NM_RXTXBB1_CH0__PDOFFSETLOQ__WIDTH                            1
#define RADIO130NM_RXTXBB1_CH0__PDOFFSETLOQ__MASK                   0x00000010U
#define RADIO130NM_RXTXBB1_CH0__PDOFFSETLOQ__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000010U) >> 4)
#define RADIO130NM_RXTXBB1_CH0__PDOFFSETLOQ__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 4) & 0x00000010U)
#define RADIO130NM_RXTXBB1_CH0__PDOFFSETLOQ__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000010U) | (((u_int32_t)(src) <<\
                    4) & 0x00000010U)
#define RADIO130NM_RXTXBB1_CH0__PDOFFSETLOQ__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 4) & ~0x00000010U)))
#define RADIO130NM_RXTXBB1_CH0__PDOFFSETLOQ__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000010U) | ((u_int32_t)(1) << 4)
#define RADIO130NM_RXTXBB1_CH0__PDOFFSETLOQ__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000010U) | ((u_int32_t)(0) << 4)

/* macros for field PDRXTXBB */
#define RADIO130NM_RXTXBB1_CH0__PDRXTXBB__SHIFT                               5
#define RADIO130NM_RXTXBB1_CH0__PDRXTXBB__WIDTH                               1
#define RADIO130NM_RXTXBB1_CH0__PDRXTXBB__MASK                      0x00000020U
#define RADIO130NM_RXTXBB1_CH0__PDRXTXBB__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000020U) >> 5)
#define RADIO130NM_RXTXBB1_CH0__PDRXTXBB__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 5) & 0x00000020U)
#define RADIO130NM_RXTXBB1_CH0__PDRXTXBB__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000020U) | (((u_int32_t)(src) <<\
                    5) & 0x00000020U)
#define RADIO130NM_RXTXBB1_CH0__PDRXTXBB__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 5) & ~0x00000020U)))
#define RADIO130NM_RXTXBB1_CH0__PDRXTXBB__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000020U) | ((u_int32_t)(1) << 5)
#define RADIO130NM_RXTXBB1_CH0__PDRXTXBB__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000020U) | ((u_int32_t)(0) << 5)

/* macros for field PDI2V */
#define RADIO130NM_RXTXBB1_CH0__PDI2V__SHIFT                                  6
#define RADIO130NM_RXTXBB1_CH0__PDI2V__WIDTH                                  1
#define RADIO130NM_RXTXBB1_CH0__PDI2V__MASK                         0x00000040U
#define RADIO130NM_RXTXBB1_CH0__PDI2V__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000040U) >> 6)
#define RADIO130NM_RXTXBB1_CH0__PDI2V__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 6) & 0x00000040U)
#define RADIO130NM_RXTXBB1_CH0__PDI2V__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000040U) | (((u_int32_t)(src) <<\
                    6) & 0x00000040U)
#define RADIO130NM_RXTXBB1_CH0__PDI2V__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 6) & ~0x00000040U)))
#define RADIO130NM_RXTXBB1_CH0__PDI2V__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000040U) | ((u_int32_t)(1) << 6)
#define RADIO130NM_RXTXBB1_CH0__PDI2V__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000040U) | ((u_int32_t)(0) << 6)

/* macros for field PDV2I */
#define RADIO130NM_RXTXBB1_CH0__PDV2I__SHIFT                                  7
#define RADIO130NM_RXTXBB1_CH0__PDV2I__WIDTH                                  1
#define RADIO130NM_RXTXBB1_CH0__PDV2I__MASK                         0x00000080U
#define RADIO130NM_RXTXBB1_CH0__PDV2I__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000080U) >> 7)
#define RADIO130NM_RXTXBB1_CH0__PDV2I__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 7) & 0x00000080U)
#define RADIO130NM_RXTXBB1_CH0__PDV2I__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000080U) | (((u_int32_t)(src) <<\
                    7) & 0x00000080U)
#define RADIO130NM_RXTXBB1_CH0__PDV2I__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 7) & ~0x00000080U)))
#define RADIO130NM_RXTXBB1_CH0__PDV2I__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000080U) | ((u_int32_t)(1) << 7)
#define RADIO130NM_RXTXBB1_CH0__PDV2I__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000080U) | ((u_int32_t)(0) << 7)

/* macros for field PDDACINTERFACE */
#define RADIO130NM_RXTXBB1_CH0__PDDACINTERFACE__SHIFT                         8
#define RADIO130NM_RXTXBB1_CH0__PDDACINTERFACE__WIDTH                         1
#define RADIO130NM_RXTXBB1_CH0__PDDACINTERFACE__MASK                0x00000100U
#define RADIO130NM_RXTXBB1_CH0__PDDACINTERFACE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000100U) >> 8)
#define RADIO130NM_RXTXBB1_CH0__PDDACINTERFACE__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 8) & 0x00000100U)
#define RADIO130NM_RXTXBB1_CH0__PDDACINTERFACE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000100U) | (((u_int32_t)(src) <<\
                    8) & 0x00000100U)
#define RADIO130NM_RXTXBB1_CH0__PDDACINTERFACE__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 8) & ~0x00000100U)))
#define RADIO130NM_RXTXBB1_CH0__PDDACINTERFACE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000100U) | ((u_int32_t)(1) << 8)
#define RADIO130NM_RXTXBB1_CH0__PDDACINTERFACE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000100U) | ((u_int32_t)(0) << 8)

/* macros for field SEL_ATB */
#define RADIO130NM_RXTXBB1_CH0__SEL_ATB__SHIFT                                9
#define RADIO130NM_RXTXBB1_CH0__SEL_ATB__WIDTH                                8
#define RADIO130NM_RXTXBB1_CH0__SEL_ATB__MASK                       0x0001fe00U
#define RADIO130NM_RXTXBB1_CH0__SEL_ATB__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0001fe00U) >> 9)
#define RADIO130NM_RXTXBB1_CH0__SEL_ATB__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 9) & 0x0001fe00U)
#define RADIO130NM_RXTXBB1_CH0__SEL_ATB__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0001fe00U) | (((u_int32_t)(src) <<\
                    9) & 0x0001fe00U)
#define RADIO130NM_RXTXBB1_CH0__SEL_ATB__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 9) & ~0x0001fe00U)))

/* macros for field FNOTCH */
#define RADIO130NM_RXTXBB1_CH0__FNOTCH__SHIFT                                17
#define RADIO130NM_RXTXBB1_CH0__FNOTCH__WIDTH                                 2
#define RADIO130NM_RXTXBB1_CH0__FNOTCH__MASK                        0x00060000U
#define RADIO130NM_RXTXBB1_CH0__FNOTCH__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00060000U) >> 17)
#define RADIO130NM_RXTXBB1_CH0__FNOTCH__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 17) & 0x00060000U)
#define RADIO130NM_RXTXBB1_CH0__FNOTCH__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00060000U) | (((u_int32_t)(src) <<\
                    17) & 0x00060000U)
#define RADIO130NM_RXTXBB1_CH0__FNOTCH__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 17) & ~0x00060000U)))

/* macros for field SPARE */
#define RADIO130NM_RXTXBB1_CH0__SPARE__SHIFT                                 19
#define RADIO130NM_RXTXBB1_CH0__SPARE__WIDTH                                 13
#define RADIO130NM_RXTXBB1_CH0__SPARE__MASK                         0xfff80000U
#define RADIO130NM_RXTXBB1_CH0__SPARE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0xfff80000U) >> 19)
#define RADIO130NM_RXTXBB1_CH0__SPARE__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 19) & 0xfff80000U)
#define RADIO130NM_RXTXBB1_CH0__SPARE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xfff80000U) | (((u_int32_t)(src) <<\
                    19) & 0xfff80000U)
#define RADIO130NM_RXTXBB1_CH0__SPARE__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 19) & ~0xfff80000U)))
#define RADIO130NM_RXTXBB1_CH0__TYPE                                  u_int32_t
#define RADIO130NM_RXTXBB1_CH0__READ                                0xffffffffU
#define RADIO130NM_RXTXBB1_CH0__WRITE                               0xffffffffU

#endif /* __RADIO130NM_RXTXBB1_CH0_MACRO__ */


/* macros for merlin2_0_radio_reg_map.RXTXBB1_CH0 */
#define INST_MERLIN2_0_RADIO_REG_MAP__RXTXBB1_CH0__NUM                        1

/* macros for BlueprintGlobalNameSpace::RADIO130NM_RXTXBB2_CH0 */
#ifndef __RADIO130NM_RXTXBB2_CH0_MACRO__
#define __RADIO130NM_RXTXBB2_CH0_MACRO__

/* macros for field PATH_OVERRIDE */
#define RADIO130NM_RXTXBB2_CH0__PATH_OVERRIDE__SHIFT                          0
#define RADIO130NM_RXTXBB2_CH0__PATH_OVERRIDE__WIDTH                          1
#define RADIO130NM_RXTXBB2_CH0__PATH_OVERRIDE__MASK                 0x00000001U
#define RADIO130NM_RXTXBB2_CH0__PATH_OVERRIDE__READ(src) \
                    (u_int32_t)(src)\
                    & 0x00000001U
#define RADIO130NM_RXTXBB2_CH0__PATH_OVERRIDE__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x00000001U)
#define RADIO130NM_RXTXBB2_CH0__PATH_OVERRIDE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | ((u_int32_t)(src) &\
                    0x00000001U)
#define RADIO130NM_RXTXBB2_CH0__PATH_OVERRIDE__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00000001U)))
#define RADIO130NM_RXTXBB2_CH0__PATH_OVERRIDE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(1)
#define RADIO130NM_RXTXBB2_CH0__PATH_OVERRIDE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(0)

/* macros for field PATH1LOQ_EN */
#define RADIO130NM_RXTXBB2_CH0__PATH1LOQ_EN__SHIFT                            1
#define RADIO130NM_RXTXBB2_CH0__PATH1LOQ_EN__WIDTH                            1
#define RADIO130NM_RXTXBB2_CH0__PATH1LOQ_EN__MASK                   0x00000002U
#define RADIO130NM_RXTXBB2_CH0__PATH1LOQ_EN__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000002U) >> 1)
#define RADIO130NM_RXTXBB2_CH0__PATH1LOQ_EN__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 1) & 0x00000002U)
#define RADIO130NM_RXTXBB2_CH0__PATH1LOQ_EN__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | (((u_int32_t)(src) <<\
                    1) & 0x00000002U)
#define RADIO130NM_RXTXBB2_CH0__PATH1LOQ_EN__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 1) & ~0x00000002U)))
#define RADIO130NM_RXTXBB2_CH0__PATH1LOQ_EN__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | ((u_int32_t)(1) << 1)
#define RADIO130NM_RXTXBB2_CH0__PATH1LOQ_EN__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | ((u_int32_t)(0) << 1)

/* macros for field PATH2LOQ_EN */
#define RADIO130NM_RXTXBB2_CH0__PATH2LOQ_EN__SHIFT                            2
#define RADIO130NM_RXTXBB2_CH0__PATH2LOQ_EN__WIDTH                            1
#define RADIO130NM_RXTXBB2_CH0__PATH2LOQ_EN__MASK                   0x00000004U
#define RADIO130NM_RXTXBB2_CH0__PATH2LOQ_EN__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000004U) >> 2)
#define RADIO130NM_RXTXBB2_CH0__PATH2LOQ_EN__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 2) & 0x00000004U)
#define RADIO130NM_RXTXBB2_CH0__PATH2LOQ_EN__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000004U) | (((u_int32_t)(src) <<\
                    2) & 0x00000004U)
#define RADIO130NM_RXTXBB2_CH0__PATH2LOQ_EN__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 2) & ~0x00000004U)))
#define RADIO130NM_RXTXBB2_CH0__PATH2LOQ_EN__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000004U) | ((u_int32_t)(1) << 2)
#define RADIO130NM_RXTXBB2_CH0__PATH2LOQ_EN__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000004U) | ((u_int32_t)(0) << 2)

/* macros for field PATH3LOQ_EN */
#define RADIO130NM_RXTXBB2_CH0__PATH3LOQ_EN__SHIFT                            3
#define RADIO130NM_RXTXBB2_CH0__PATH3LOQ_EN__WIDTH                            1
#define RADIO130NM_RXTXBB2_CH0__PATH3LOQ_EN__MASK                   0x00000008U
#define RADIO130NM_RXTXBB2_CH0__PATH3LOQ_EN__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000008U) >> 3)
#define RADIO130NM_RXTXBB2_CH0__PATH3LOQ_EN__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 3) & 0x00000008U)
#define RADIO130NM_RXTXBB2_CH0__PATH3LOQ_EN__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000008U) | (((u_int32_t)(src) <<\
                    3) & 0x00000008U)
#define RADIO130NM_RXTXBB2_CH0__PATH3LOQ_EN__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 3) & ~0x00000008U)))
#define RADIO130NM_RXTXBB2_CH0__PATH3LOQ_EN__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000008U) | ((u_int32_t)(1) << 3)
#define RADIO130NM_RXTXBB2_CH0__PATH3LOQ_EN__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000008U) | ((u_int32_t)(0) << 3)

/* macros for field PATH1HIQ_EN */
#define RADIO130NM_RXTXBB2_CH0__PATH1HIQ_EN__SHIFT                            4
#define RADIO130NM_RXTXBB2_CH0__PATH1HIQ_EN__WIDTH                            1
#define RADIO130NM_RXTXBB2_CH0__PATH1HIQ_EN__MASK                   0x00000010U
#define RADIO130NM_RXTXBB2_CH0__PATH1HIQ_EN__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000010U) >> 4)
#define RADIO130NM_RXTXBB2_CH0__PATH1HIQ_EN__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 4) & 0x00000010U)
#define RADIO130NM_RXTXBB2_CH0__PATH1HIQ_EN__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000010U) | (((u_int32_t)(src) <<\
                    4) & 0x00000010U)
#define RADIO130NM_RXTXBB2_CH0__PATH1HIQ_EN__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 4) & ~0x00000010U)))
#define RADIO130NM_RXTXBB2_CH0__PATH1HIQ_EN__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000010U) | ((u_int32_t)(1) << 4)
#define RADIO130NM_RXTXBB2_CH0__PATH1HIQ_EN__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000010U) | ((u_int32_t)(0) << 4)

/* macros for field PATH2HIQ_EN */
#define RADIO130NM_RXTXBB2_CH0__PATH2HIQ_EN__SHIFT                            5
#define RADIO130NM_RXTXBB2_CH0__PATH2HIQ_EN__WIDTH                            1
#define RADIO130NM_RXTXBB2_CH0__PATH2HIQ_EN__MASK                   0x00000020U
#define RADIO130NM_RXTXBB2_CH0__PATH2HIQ_EN__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000020U) >> 5)
#define RADIO130NM_RXTXBB2_CH0__PATH2HIQ_EN__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 5) & 0x00000020U)
#define RADIO130NM_RXTXBB2_CH0__PATH2HIQ_EN__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000020U) | (((u_int32_t)(src) <<\
                    5) & 0x00000020U)
#define RADIO130NM_RXTXBB2_CH0__PATH2HIQ_EN__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 5) & ~0x00000020U)))
#define RADIO130NM_RXTXBB2_CH0__PATH2HIQ_EN__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000020U) | ((u_int32_t)(1) << 5)
#define RADIO130NM_RXTXBB2_CH0__PATH2HIQ_EN__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000020U) | ((u_int32_t)(0) << 5)

/* macros for field FILTERDOUBLEBW */
#define RADIO130NM_RXTXBB2_CH0__FILTERDOUBLEBW__SHIFT                         6
#define RADIO130NM_RXTXBB2_CH0__FILTERDOUBLEBW__WIDTH                         1
#define RADIO130NM_RXTXBB2_CH0__FILTERDOUBLEBW__MASK                0x00000040U
#define RADIO130NM_RXTXBB2_CH0__FILTERDOUBLEBW__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000040U) >> 6)
#define RADIO130NM_RXTXBB2_CH0__FILTERDOUBLEBW__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 6) & 0x00000040U)
#define RADIO130NM_RXTXBB2_CH0__FILTERDOUBLEBW__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000040U) | (((u_int32_t)(src) <<\
                    6) & 0x00000040U)
#define RADIO130NM_RXTXBB2_CH0__FILTERDOUBLEBW__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 6) & ~0x00000040U)))
#define RADIO130NM_RXTXBB2_CH0__FILTERDOUBLEBW__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000040U) | ((u_int32_t)(1) << 6)
#define RADIO130NM_RXTXBB2_CH0__FILTERDOUBLEBW__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000040U) | ((u_int32_t)(0) << 6)

/* macros for field LOCALFILTERTUNING */
#define RADIO130NM_RXTXBB2_CH0__LOCALFILTERTUNING__SHIFT                      7
#define RADIO130NM_RXTXBB2_CH0__LOCALFILTERTUNING__WIDTH                      1
#define RADIO130NM_RXTXBB2_CH0__LOCALFILTERTUNING__MASK             0x00000080U
#define RADIO130NM_RXTXBB2_CH0__LOCALFILTERTUNING__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000080U) >> 7)
#define RADIO130NM_RXTXBB2_CH0__LOCALFILTERTUNING__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 7) & 0x00000080U)
#define RADIO130NM_RXTXBB2_CH0__LOCALFILTERTUNING__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000080U) | (((u_int32_t)(src) <<\
                    7) & 0x00000080U)
#define RADIO130NM_RXTXBB2_CH0__LOCALFILTERTUNING__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 7) & ~0x00000080U)))
#define RADIO130NM_RXTXBB2_CH0__LOCALFILTERTUNING__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000080U) | ((u_int32_t)(1) << 7)
#define RADIO130NM_RXTXBB2_CH0__LOCALFILTERTUNING__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000080U) | ((u_int32_t)(0) << 7)

/* macros for field FILTERFC */
#define RADIO130NM_RXTXBB2_CH0__FILTERFC__SHIFT                               8
#define RADIO130NM_RXTXBB2_CH0__FILTERFC__WIDTH                               5
#define RADIO130NM_RXTXBB2_CH0__FILTERFC__MASK                      0x00001f00U
#define RADIO130NM_RXTXBB2_CH0__FILTERFC__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00001f00U) >> 8)
#define RADIO130NM_RXTXBB2_CH0__FILTERFC__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 8) & 0x00001f00U)
#define RADIO130NM_RXTXBB2_CH0__FILTERFC__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00001f00U) | (((u_int32_t)(src) <<\
                    8) & 0x00001f00U)
#define RADIO130NM_RXTXBB2_CH0__FILTERFC__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 8) & ~0x00001f00U)))

/* macros for field CMSEL */
#define RADIO130NM_RXTXBB2_CH0__CMSEL__SHIFT                                 13
#define RADIO130NM_RXTXBB2_CH0__CMSEL__WIDTH                                  2
#define RADIO130NM_RXTXBB2_CH0__CMSEL__MASK                         0x00006000U
#define RADIO130NM_RXTXBB2_CH0__CMSEL__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00006000U) >> 13)
#define RADIO130NM_RXTXBB2_CH0__CMSEL__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 13) & 0x00006000U)
#define RADIO130NM_RXTXBB2_CH0__CMSEL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00006000U) | (((u_int32_t)(src) <<\
                    13) & 0x00006000U)
#define RADIO130NM_RXTXBB2_CH0__CMSEL__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 13) & ~0x00006000U)))

/* macros for field SEL_I2V_TEST */
#define RADIO130NM_RXTXBB2_CH0__SEL_I2V_TEST__SHIFT                          15
#define RADIO130NM_RXTXBB2_CH0__SEL_I2V_TEST__WIDTH                           1
#define RADIO130NM_RXTXBB2_CH0__SEL_I2V_TEST__MASK                  0x00008000U
#define RADIO130NM_RXTXBB2_CH0__SEL_I2V_TEST__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00008000U) >> 15)
#define RADIO130NM_RXTXBB2_CH0__SEL_I2V_TEST__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 15) & 0x00008000U)
#define RADIO130NM_RXTXBB2_CH0__SEL_I2V_TEST__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00008000U) | (((u_int32_t)(src) <<\
                    15) & 0x00008000U)
#define RADIO130NM_RXTXBB2_CH0__SEL_I2V_TEST__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 15) & ~0x00008000U)))
#define RADIO130NM_RXTXBB2_CH0__SEL_I2V_TEST__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00008000U) | ((u_int32_t)(1) << 15)
#define RADIO130NM_RXTXBB2_CH0__SEL_I2V_TEST__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00008000U) | ((u_int32_t)(0) << 15)

/* macros for field SEL_HIQ_TEST */
#define RADIO130NM_RXTXBB2_CH0__SEL_HIQ_TEST__SHIFT                          16
#define RADIO130NM_RXTXBB2_CH0__SEL_HIQ_TEST__WIDTH                           1
#define RADIO130NM_RXTXBB2_CH0__SEL_HIQ_TEST__MASK                  0x00010000U
#define RADIO130NM_RXTXBB2_CH0__SEL_HIQ_TEST__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00010000U) >> 16)
#define RADIO130NM_RXTXBB2_CH0__SEL_HIQ_TEST__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 16) & 0x00010000U)
#define RADIO130NM_RXTXBB2_CH0__SEL_HIQ_TEST__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00010000U) | (((u_int32_t)(src) <<\
                    16) & 0x00010000U)
#define RADIO130NM_RXTXBB2_CH0__SEL_HIQ_TEST__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 16) & ~0x00010000U)))
#define RADIO130NM_RXTXBB2_CH0__SEL_HIQ_TEST__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00010000U) | ((u_int32_t)(1) << 16)
#define RADIO130NM_RXTXBB2_CH0__SEL_HIQ_TEST__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00010000U) | ((u_int32_t)(0) << 16)

/* macros for field SEL_LOQ_TEST */
#define RADIO130NM_RXTXBB2_CH0__SEL_LOQ_TEST__SHIFT                          17
#define RADIO130NM_RXTXBB2_CH0__SEL_LOQ_TEST__WIDTH                           1
#define RADIO130NM_RXTXBB2_CH0__SEL_LOQ_TEST__MASK                  0x00020000U
#define RADIO130NM_RXTXBB2_CH0__SEL_LOQ_TEST__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00020000U) >> 17)
#define RADIO130NM_RXTXBB2_CH0__SEL_LOQ_TEST__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 17) & 0x00020000U)
#define RADIO130NM_RXTXBB2_CH0__SEL_LOQ_TEST__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00020000U) | (((u_int32_t)(src) <<\
                    17) & 0x00020000U)
#define RADIO130NM_RXTXBB2_CH0__SEL_LOQ_TEST__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 17) & ~0x00020000U)))
#define RADIO130NM_RXTXBB2_CH0__SEL_LOQ_TEST__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00020000U) | ((u_int32_t)(1) << 17)
#define RADIO130NM_RXTXBB2_CH0__SEL_LOQ_TEST__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00020000U) | ((u_int32_t)(0) << 17)

/* macros for field SEL_DAC_TEST */
#define RADIO130NM_RXTXBB2_CH0__SEL_DAC_TEST__SHIFT                          18
#define RADIO130NM_RXTXBB2_CH0__SEL_DAC_TEST__WIDTH                           1
#define RADIO130NM_RXTXBB2_CH0__SEL_DAC_TEST__MASK                  0x00040000U
#define RADIO130NM_RXTXBB2_CH0__SEL_DAC_TEST__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00040000U) >> 18)
#define RADIO130NM_RXTXBB2_CH0__SEL_DAC_TEST__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 18) & 0x00040000U)
#define RADIO130NM_RXTXBB2_CH0__SEL_DAC_TEST__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00040000U) | (((u_int32_t)(src) <<\
                    18) & 0x00040000U)
#define RADIO130NM_RXTXBB2_CH0__SEL_DAC_TEST__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 18) & ~0x00040000U)))
#define RADIO130NM_RXTXBB2_CH0__SEL_DAC_TEST__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00040000U) | ((u_int32_t)(1) << 18)
#define RADIO130NM_RXTXBB2_CH0__SEL_DAC_TEST__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00040000U) | ((u_int32_t)(0) << 18)

/* macros for field SELBUFFER */
#define RADIO130NM_RXTXBB2_CH0__SELBUFFER__SHIFT                             19
#define RADIO130NM_RXTXBB2_CH0__SELBUFFER__WIDTH                              1
#define RADIO130NM_RXTXBB2_CH0__SELBUFFER__MASK                     0x00080000U
#define RADIO130NM_RXTXBB2_CH0__SELBUFFER__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00080000U) >> 19)
#define RADIO130NM_RXTXBB2_CH0__SELBUFFER__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 19) & 0x00080000U)
#define RADIO130NM_RXTXBB2_CH0__SELBUFFER__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00080000U) | (((u_int32_t)(src) <<\
                    19) & 0x00080000U)
#define RADIO130NM_RXTXBB2_CH0__SELBUFFER__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 19) & ~0x00080000U)))
#define RADIO130NM_RXTXBB2_CH0__SELBUFFER__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00080000U) | ((u_int32_t)(1) << 19)
#define RADIO130NM_RXTXBB2_CH0__SELBUFFER__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00080000U) | ((u_int32_t)(0) << 19)

/* macros for field SHORTBUFFER */
#define RADIO130NM_RXTXBB2_CH0__SHORTBUFFER__SHIFT                           20
#define RADIO130NM_RXTXBB2_CH0__SHORTBUFFER__WIDTH                            1
#define RADIO130NM_RXTXBB2_CH0__SHORTBUFFER__MASK                   0x00100000U
#define RADIO130NM_RXTXBB2_CH0__SHORTBUFFER__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00100000U) >> 20)
#define RADIO130NM_RXTXBB2_CH0__SHORTBUFFER__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 20) & 0x00100000U)
#define RADIO130NM_RXTXBB2_CH0__SHORTBUFFER__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00100000U) | (((u_int32_t)(src) <<\
                    20) & 0x00100000U)
#define RADIO130NM_RXTXBB2_CH0__SHORTBUFFER__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 20) & ~0x00100000U)))
#define RADIO130NM_RXTXBB2_CH0__SHORTBUFFER__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00100000U) | ((u_int32_t)(1) << 20)
#define RADIO130NM_RXTXBB2_CH0__SHORTBUFFER__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00100000U) | ((u_int32_t)(0) << 20)

/* macros for field SPARE */
#define RADIO130NM_RXTXBB2_CH0__SPARE__SHIFT                                 21
#define RADIO130NM_RXTXBB2_CH0__SPARE__WIDTH                                  2
#define RADIO130NM_RXTXBB2_CH0__SPARE__MASK                         0x00600000U
#define RADIO130NM_RXTXBB2_CH0__SPARE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00600000U) >> 21)
#define RADIO130NM_RXTXBB2_CH0__SPARE__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 21) & 0x00600000U)
#define RADIO130NM_RXTXBB2_CH0__SPARE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00600000U) | (((u_int32_t)(src) <<\
                    21) & 0x00600000U)
#define RADIO130NM_RXTXBB2_CH0__SPARE__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 21) & ~0x00600000U)))

/* macros for field IBN_37P5_OSI2V_CTRL */
#define RADIO130NM_RXTXBB2_CH0__IBN_37P5_OSI2V_CTRL__SHIFT                   23
#define RADIO130NM_RXTXBB2_CH0__IBN_37P5_OSI2V_CTRL__WIDTH                    3
#define RADIO130NM_RXTXBB2_CH0__IBN_37P5_OSI2V_CTRL__MASK           0x03800000U
#define RADIO130NM_RXTXBB2_CH0__IBN_37P5_OSI2V_CTRL__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x03800000U) >> 23)
#define RADIO130NM_RXTXBB2_CH0__IBN_37P5_OSI2V_CTRL__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 23) & 0x03800000U)
#define RADIO130NM_RXTXBB2_CH0__IBN_37P5_OSI2V_CTRL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x03800000U) | (((u_int32_t)(src) <<\
                    23) & 0x03800000U)
#define RADIO130NM_RXTXBB2_CH0__IBN_37P5_OSI2V_CTRL__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 23) & ~0x03800000U)))

/* macros for field IBN_37P5_OSLO_CTRL */
#define RADIO130NM_RXTXBB2_CH0__IBN_37P5_OSLO_CTRL__SHIFT                    26
#define RADIO130NM_RXTXBB2_CH0__IBN_37P5_OSLO_CTRL__WIDTH                     3
#define RADIO130NM_RXTXBB2_CH0__IBN_37P5_OSLO_CTRL__MASK            0x1c000000U
#define RADIO130NM_RXTXBB2_CH0__IBN_37P5_OSLO_CTRL__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x1c000000U) >> 26)
#define RADIO130NM_RXTXBB2_CH0__IBN_37P5_OSLO_CTRL__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 26) & 0x1c000000U)
#define RADIO130NM_RXTXBB2_CH0__IBN_37P5_OSLO_CTRL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x1c000000U) | (((u_int32_t)(src) <<\
                    26) & 0x1c000000U)
#define RADIO130NM_RXTXBB2_CH0__IBN_37P5_OSLO_CTRL__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 26) & ~0x1c000000U)))

/* macros for field IBN_37P5_OSHI_CTRL */
#define RADIO130NM_RXTXBB2_CH0__IBN_37P5_OSHI_CTRL__SHIFT                    29
#define RADIO130NM_RXTXBB2_CH0__IBN_37P5_OSHI_CTRL__WIDTH                     3
#define RADIO130NM_RXTXBB2_CH0__IBN_37P5_OSHI_CTRL__MASK            0xe0000000U
#define RADIO130NM_RXTXBB2_CH0__IBN_37P5_OSHI_CTRL__READ(src) \
                    (((u_int32_t)(src)\
                    & 0xe0000000U) >> 29)
#define RADIO130NM_RXTXBB2_CH0__IBN_37P5_OSHI_CTRL__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 29) & 0xe0000000U)
#define RADIO130NM_RXTXBB2_CH0__IBN_37P5_OSHI_CTRL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xe0000000U) | (((u_int32_t)(src) <<\
                    29) & 0xe0000000U)
#define RADIO130NM_RXTXBB2_CH0__IBN_37P5_OSHI_CTRL__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 29) & ~0xe0000000U)))
#define RADIO130NM_RXTXBB2_CH0__TYPE                                  u_int32_t
#define RADIO130NM_RXTXBB2_CH0__READ                                0xffffffffU
#define RADIO130NM_RXTXBB2_CH0__WRITE                               0xffffffffU

#endif /* __RADIO130NM_RXTXBB2_CH0_MACRO__ */


/* macros for merlin2_0_radio_reg_map.RXTXBB2_CH0 */
#define INST_MERLIN2_0_RADIO_REG_MAP__RXTXBB2_CH0__NUM                        1

/* macros for BlueprintGlobalNameSpace::RADIO130NM_RXTXBB3_CH0 */
#ifndef __RADIO130NM_RXTXBB3_CH0_MACRO__
#define __RADIO130NM_RXTXBB3_CH0_MACRO__

/* macros for field IBN_100U_TEST_CTRL */
#define RADIO130NM_RXTXBB3_CH0__IBN_100U_TEST_CTRL__SHIFT                     0
#define RADIO130NM_RXTXBB3_CH0__IBN_100U_TEST_CTRL__WIDTH                     3
#define RADIO130NM_RXTXBB3_CH0__IBN_100U_TEST_CTRL__MASK            0x00000007U
#define RADIO130NM_RXTXBB3_CH0__IBN_100U_TEST_CTRL__READ(src) \
                    (u_int32_t)(src)\
                    & 0x00000007U
#define RADIO130NM_RXTXBB3_CH0__IBN_100U_TEST_CTRL__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x00000007U)
#define RADIO130NM_RXTXBB3_CH0__IBN_100U_TEST_CTRL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000007U) | ((u_int32_t)(src) &\
                    0x00000007U)
#define RADIO130NM_RXTXBB3_CH0__IBN_100U_TEST_CTRL__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00000007U)))

/* macros for field IBRN_12P5_CM_CTRL */
#define RADIO130NM_RXTXBB3_CH0__IBRN_12P5_CM_CTRL__SHIFT                      3
#define RADIO130NM_RXTXBB3_CH0__IBRN_12P5_CM_CTRL__WIDTH                      3
#define RADIO130NM_RXTXBB3_CH0__IBRN_12P5_CM_CTRL__MASK             0x00000038U
#define RADIO130NM_RXTXBB3_CH0__IBRN_12P5_CM_CTRL__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000038U) >> 3)
#define RADIO130NM_RXTXBB3_CH0__IBRN_12P5_CM_CTRL__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 3) & 0x00000038U)
#define RADIO130NM_RXTXBB3_CH0__IBRN_12P5_CM_CTRL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000038U) | (((u_int32_t)(src) <<\
                    3) & 0x00000038U)
#define RADIO130NM_RXTXBB3_CH0__IBRN_12P5_CM_CTRL__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 3) & ~0x00000038U)))

/* macros for field IBN_25U_LO2_CTRL */
#define RADIO130NM_RXTXBB3_CH0__IBN_25U_LO2_CTRL__SHIFT                       6
#define RADIO130NM_RXTXBB3_CH0__IBN_25U_LO2_CTRL__WIDTH                       3
#define RADIO130NM_RXTXBB3_CH0__IBN_25U_LO2_CTRL__MASK              0x000001c0U
#define RADIO130NM_RXTXBB3_CH0__IBN_25U_LO2_CTRL__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x000001c0U) >> 6)
#define RADIO130NM_RXTXBB3_CH0__IBN_25U_LO2_CTRL__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 6) & 0x000001c0U)
#define RADIO130NM_RXTXBB3_CH0__IBN_25U_LO2_CTRL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000001c0U) | (((u_int32_t)(src) <<\
                    6) & 0x000001c0U)
#define RADIO130NM_RXTXBB3_CH0__IBN_25U_LO2_CTRL__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 6) & ~0x000001c0U)))

/* macros for field IBN_25U_LO1_CTRL */
#define RADIO130NM_RXTXBB3_CH0__IBN_25U_LO1_CTRL__SHIFT                       9
#define RADIO130NM_RXTXBB3_CH0__IBN_25U_LO1_CTRL__WIDTH                       3
#define RADIO130NM_RXTXBB3_CH0__IBN_25U_LO1_CTRL__MASK              0x00000e00U
#define RADIO130NM_RXTXBB3_CH0__IBN_25U_LO1_CTRL__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000e00U) >> 9)
#define RADIO130NM_RXTXBB3_CH0__IBN_25U_LO1_CTRL__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 9) & 0x00000e00U)
#define RADIO130NM_RXTXBB3_CH0__IBN_25U_LO1_CTRL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000e00U) | (((u_int32_t)(src) <<\
                    9) & 0x00000e00U)
#define RADIO130NM_RXTXBB3_CH0__IBN_25U_LO1_CTRL__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 9) & ~0x00000e00U)))

/* macros for field IBN_25U_HI2_CTRL */
#define RADIO130NM_RXTXBB3_CH0__IBN_25U_HI2_CTRL__SHIFT                      12
#define RADIO130NM_RXTXBB3_CH0__IBN_25U_HI2_CTRL__WIDTH                       3
#define RADIO130NM_RXTXBB3_CH0__IBN_25U_HI2_CTRL__MASK              0x00007000U
#define RADIO130NM_RXTXBB3_CH0__IBN_25U_HI2_CTRL__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00007000U) >> 12)
#define RADIO130NM_RXTXBB3_CH0__IBN_25U_HI2_CTRL__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 12) & 0x00007000U)
#define RADIO130NM_RXTXBB3_CH0__IBN_25U_HI2_CTRL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00007000U) | (((u_int32_t)(src) <<\
                    12) & 0x00007000U)
#define RADIO130NM_RXTXBB3_CH0__IBN_25U_HI2_CTRL__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 12) & ~0x00007000U)))

/* macros for field IBN_25U_HI1_CTRL */
#define RADIO130NM_RXTXBB3_CH0__IBN_25U_HI1_CTRL__SHIFT                      15
#define RADIO130NM_RXTXBB3_CH0__IBN_25U_HI1_CTRL__WIDTH                       3
#define RADIO130NM_RXTXBB3_CH0__IBN_25U_HI1_CTRL__MASK              0x00038000U
#define RADIO130NM_RXTXBB3_CH0__IBN_25U_HI1_CTRL__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00038000U) >> 15)
#define RADIO130NM_RXTXBB3_CH0__IBN_25U_HI1_CTRL__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 15) & 0x00038000U)
#define RADIO130NM_RXTXBB3_CH0__IBN_25U_HI1_CTRL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00038000U) | (((u_int32_t)(src) <<\
                    15) & 0x00038000U)
#define RADIO130NM_RXTXBB3_CH0__IBN_25U_HI1_CTRL__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 15) & ~0x00038000U)))

/* macros for field IBN_25U_I2V_CTRL */
#define RADIO130NM_RXTXBB3_CH0__IBN_25U_I2V_CTRL__SHIFT                      18
#define RADIO130NM_RXTXBB3_CH0__IBN_25U_I2V_CTRL__WIDTH                       3
#define RADIO130NM_RXTXBB3_CH0__IBN_25U_I2V_CTRL__MASK              0x001c0000U
#define RADIO130NM_RXTXBB3_CH0__IBN_25U_I2V_CTRL__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x001c0000U) >> 18)
#define RADIO130NM_RXTXBB3_CH0__IBN_25U_I2V_CTRL__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 18) & 0x001c0000U)
#define RADIO130NM_RXTXBB3_CH0__IBN_25U_I2V_CTRL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x001c0000U) | (((u_int32_t)(src) <<\
                    18) & 0x001c0000U)
#define RADIO130NM_RXTXBB3_CH0__IBN_25U_I2V_CTRL__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 18) & ~0x001c0000U)))

/* macros for field IBN_25U_BKV2I_CTRL */
#define RADIO130NM_RXTXBB3_CH0__IBN_25U_BKV2I_CTRL__SHIFT                    21
#define RADIO130NM_RXTXBB3_CH0__IBN_25U_BKV2I_CTRL__WIDTH                     3
#define RADIO130NM_RXTXBB3_CH0__IBN_25U_BKV2I_CTRL__MASK            0x00e00000U
#define RADIO130NM_RXTXBB3_CH0__IBN_25U_BKV2I_CTRL__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00e00000U) >> 21)
#define RADIO130NM_RXTXBB3_CH0__IBN_25U_BKV2I_CTRL__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 21) & 0x00e00000U)
#define RADIO130NM_RXTXBB3_CH0__IBN_25U_BKV2I_CTRL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00e00000U) | (((u_int32_t)(src) <<\
                    21) & 0x00e00000U)
#define RADIO130NM_RXTXBB3_CH0__IBN_25U_BKV2I_CTRL__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 21) & ~0x00e00000U)))

/* macros for field IBN_25U_CM_BUFAMP_CTRL */
#define RADIO130NM_RXTXBB3_CH0__IBN_25U_CM_BUFAMP_CTRL__SHIFT                24
#define RADIO130NM_RXTXBB3_CH0__IBN_25U_CM_BUFAMP_CTRL__WIDTH                 3
#define RADIO130NM_RXTXBB3_CH0__IBN_25U_CM_BUFAMP_CTRL__MASK        0x07000000U
#define RADIO130NM_RXTXBB3_CH0__IBN_25U_CM_BUFAMP_CTRL__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x07000000U) >> 24)
#define RADIO130NM_RXTXBB3_CH0__IBN_25U_CM_BUFAMP_CTRL__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 24) & 0x07000000U)
#define RADIO130NM_RXTXBB3_CH0__IBN_25U_CM_BUFAMP_CTRL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x07000000U) | (((u_int32_t)(src) <<\
                    24) & 0x07000000U)
#define RADIO130NM_RXTXBB3_CH0__IBN_25U_CM_BUFAMP_CTRL__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 24) & ~0x07000000U)))

/* macros for field SPARE */
#define RADIO130NM_RXTXBB3_CH0__SPARE__SHIFT                                 27
#define RADIO130NM_RXTXBB3_CH0__SPARE__WIDTH                                  5
#define RADIO130NM_RXTXBB3_CH0__SPARE__MASK                         0xf8000000U
#define RADIO130NM_RXTXBB3_CH0__SPARE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0xf8000000U) >> 27)
#define RADIO130NM_RXTXBB3_CH0__SPARE__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 27) & 0xf8000000U)
#define RADIO130NM_RXTXBB3_CH0__SPARE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xf8000000U) | (((u_int32_t)(src) <<\
                    27) & 0xf8000000U)
#define RADIO130NM_RXTXBB3_CH0__SPARE__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 27) & ~0xf8000000U)))
#define RADIO130NM_RXTXBB3_CH0__TYPE                                  u_int32_t
#define RADIO130NM_RXTXBB3_CH0__READ                                0xffffffffU
#define RADIO130NM_RXTXBB3_CH0__WRITE                               0xffffffffU

#endif /* __RADIO130NM_RXTXBB3_CH0_MACRO__ */


/* macros for merlin2_0_radio_reg_map.RXTXBB3_CH0 */
#define INST_MERLIN2_0_RADIO_REG_MAP__RXTXBB3_CH0__NUM                        1

/* macros for BlueprintGlobalNameSpace::RADIO130NM_RXTXBB4_CH0 */
#ifndef __RADIO130NM_RXTXBB4_CH0_MACRO__
#define __RADIO130NM_RXTXBB4_CH0_MACRO__

/* macros for field OFSTCORRI2VQ */
#define RADIO130NM_RXTXBB4_CH0__OFSTCORRI2VQ__SHIFT                           0
#define RADIO130NM_RXTXBB4_CH0__OFSTCORRI2VQ__WIDTH                           5
#define RADIO130NM_RXTXBB4_CH0__OFSTCORRI2VQ__MASK                  0x0000001fU
#define RADIO130NM_RXTXBB4_CH0__OFSTCORRI2VQ__READ(src) \
                    (u_int32_t)(src)\
                    & 0x0000001fU
#define RADIO130NM_RXTXBB4_CH0__OFSTCORRI2VQ__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x0000001fU)
#define RADIO130NM_RXTXBB4_CH0__OFSTCORRI2VQ__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000001fU) | ((u_int32_t)(src) &\
                    0x0000001fU)
#define RADIO130NM_RXTXBB4_CH0__OFSTCORRI2VQ__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x0000001fU)))

/* macros for field OFSTCORRI2VI */
#define RADIO130NM_RXTXBB4_CH0__OFSTCORRI2VI__SHIFT                           5
#define RADIO130NM_RXTXBB4_CH0__OFSTCORRI2VI__WIDTH                           5
#define RADIO130NM_RXTXBB4_CH0__OFSTCORRI2VI__MASK                  0x000003e0U
#define RADIO130NM_RXTXBB4_CH0__OFSTCORRI2VI__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x000003e0U) >> 5)
#define RADIO130NM_RXTXBB4_CH0__OFSTCORRI2VI__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 5) & 0x000003e0U)
#define RADIO130NM_RXTXBB4_CH0__OFSTCORRI2VI__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000003e0U) | (((u_int32_t)(src) <<\
                    5) & 0x000003e0U)
#define RADIO130NM_RXTXBB4_CH0__OFSTCORRI2VI__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 5) & ~0x000003e0U)))

/* macros for field OFSTCORRLOQ */
#define RADIO130NM_RXTXBB4_CH0__OFSTCORRLOQ__SHIFT                           10
#define RADIO130NM_RXTXBB4_CH0__OFSTCORRLOQ__WIDTH                            5
#define RADIO130NM_RXTXBB4_CH0__OFSTCORRLOQ__MASK                   0x00007c00U
#define RADIO130NM_RXTXBB4_CH0__OFSTCORRLOQ__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00007c00U) >> 10)
#define RADIO130NM_RXTXBB4_CH0__OFSTCORRLOQ__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 10) & 0x00007c00U)
#define RADIO130NM_RXTXBB4_CH0__OFSTCORRLOQ__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00007c00U) | (((u_int32_t)(src) <<\
                    10) & 0x00007c00U)
#define RADIO130NM_RXTXBB4_CH0__OFSTCORRLOQ__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 10) & ~0x00007c00U)))

/* macros for field OFSTCORRLOI */
#define RADIO130NM_RXTXBB4_CH0__OFSTCORRLOI__SHIFT                           15
#define RADIO130NM_RXTXBB4_CH0__OFSTCORRLOI__WIDTH                            5
#define RADIO130NM_RXTXBB4_CH0__OFSTCORRLOI__MASK                   0x000f8000U
#define RADIO130NM_RXTXBB4_CH0__OFSTCORRLOI__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x000f8000U) >> 15)
#define RADIO130NM_RXTXBB4_CH0__OFSTCORRLOI__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 15) & 0x000f8000U)
#define RADIO130NM_RXTXBB4_CH0__OFSTCORRLOI__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000f8000U) | (((u_int32_t)(src) <<\
                    15) & 0x000f8000U)
#define RADIO130NM_RXTXBB4_CH0__OFSTCORRLOI__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 15) & ~0x000f8000U)))

/* macros for field OFSTCORRHIQ */
#define RADIO130NM_RXTXBB4_CH0__OFSTCORRHIQ__SHIFT                           20
#define RADIO130NM_RXTXBB4_CH0__OFSTCORRHIQ__WIDTH                            5
#define RADIO130NM_RXTXBB4_CH0__OFSTCORRHIQ__MASK                   0x01f00000U
#define RADIO130NM_RXTXBB4_CH0__OFSTCORRHIQ__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x01f00000U) >> 20)
#define RADIO130NM_RXTXBB4_CH0__OFSTCORRHIQ__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 20) & 0x01f00000U)
#define RADIO130NM_RXTXBB4_CH0__OFSTCORRHIQ__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x01f00000U) | (((u_int32_t)(src) <<\
                    20) & 0x01f00000U)
#define RADIO130NM_RXTXBB4_CH0__OFSTCORRHIQ__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 20) & ~0x01f00000U)))

/* macros for field OFSTCORRHII */
#define RADIO130NM_RXTXBB4_CH0__OFSTCORRHII__SHIFT                           25
#define RADIO130NM_RXTXBB4_CH0__OFSTCORRHII__WIDTH                            5
#define RADIO130NM_RXTXBB4_CH0__OFSTCORRHII__MASK                   0x3e000000U
#define RADIO130NM_RXTXBB4_CH0__OFSTCORRHII__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x3e000000U) >> 25)
#define RADIO130NM_RXTXBB4_CH0__OFSTCORRHII__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 25) & 0x3e000000U)
#define RADIO130NM_RXTXBB4_CH0__OFSTCORRHII__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x3e000000U) | (((u_int32_t)(src) <<\
                    25) & 0x3e000000U)
#define RADIO130NM_RXTXBB4_CH0__OFSTCORRHII__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 25) & ~0x3e000000U)))

/* macros for field LOCALOFFSET */
#define RADIO130NM_RXTXBB4_CH0__LOCALOFFSET__SHIFT                           30
#define RADIO130NM_RXTXBB4_CH0__LOCALOFFSET__WIDTH                            1
#define RADIO130NM_RXTXBB4_CH0__LOCALOFFSET__MASK                   0x40000000U
#define RADIO130NM_RXTXBB4_CH0__LOCALOFFSET__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x40000000U) >> 30)
#define RADIO130NM_RXTXBB4_CH0__LOCALOFFSET__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 30) & 0x40000000U)
#define RADIO130NM_RXTXBB4_CH0__LOCALOFFSET__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x40000000U) | (((u_int32_t)(src) <<\
                    30) & 0x40000000U)
#define RADIO130NM_RXTXBB4_CH0__LOCALOFFSET__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 30) & ~0x40000000U)))
#define RADIO130NM_RXTXBB4_CH0__LOCALOFFSET__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x40000000U) | ((u_int32_t)(1) << 30)
#define RADIO130NM_RXTXBB4_CH0__LOCALOFFSET__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x40000000U) | ((u_int32_t)(0) << 30)

/* macros for field SPARE */
#define RADIO130NM_RXTXBB4_CH0__SPARE__SHIFT                                 31
#define RADIO130NM_RXTXBB4_CH0__SPARE__WIDTH                                  1
#define RADIO130NM_RXTXBB4_CH0__SPARE__MASK                         0x80000000U
#define RADIO130NM_RXTXBB4_CH0__SPARE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x80000000U) >> 31)
#define RADIO130NM_RXTXBB4_CH0__SPARE__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 31) & 0x80000000U)
#define RADIO130NM_RXTXBB4_CH0__SPARE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x80000000U) | (((u_int32_t)(src) <<\
                    31) & 0x80000000U)
#define RADIO130NM_RXTXBB4_CH0__SPARE__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 31) & ~0x80000000U)))
#define RADIO130NM_RXTXBB4_CH0__SPARE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x80000000U) | ((u_int32_t)(1) << 31)
#define RADIO130NM_RXTXBB4_CH0__SPARE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x80000000U) | ((u_int32_t)(0) << 31)
#define RADIO130NM_RXTXBB4_CH0__TYPE                                  u_int32_t
#define RADIO130NM_RXTXBB4_CH0__READ                                0xffffffffU
#define RADIO130NM_RXTXBB4_CH0__WRITE                               0xffffffffU

#endif /* __RADIO130NM_RXTXBB4_CH0_MACRO__ */


/* macros for merlin2_0_radio_reg_map.RXTXBB4_CH0 */
#define INST_MERLIN2_0_RADIO_REG_MAP__RXTXBB4_CH0__NUM                        1

/* macros for BlueprintGlobalNameSpace::RADIO130NM_RF5G1_CH0 */
#ifndef __RADIO130NM_RF5G1_CH0_MACRO__
#define __RADIO130NM_RF5G1_CH0_MACRO__

/* macros for field SPARE */
#define RADIO130NM_RF5G1_CH0__SPARE__SHIFT                                    0
#define RADIO130NM_RF5G1_CH0__SPARE__WIDTH                                   10
#define RADIO130NM_RF5G1_CH0__SPARE__MASK                           0x000003ffU
#define RADIO130NM_RF5G1_CH0__SPARE__READ(src)   (u_int32_t)(src) & 0x000003ffU
#define RADIO130NM_RF5G1_CH0__SPARE__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x000003ffU)
#define RADIO130NM_RF5G1_CH0__SPARE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000003ffU) | ((u_int32_t)(src) &\
                    0x000003ffU)
#define RADIO130NM_RF5G1_CH0__SPARE__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x000003ffU)))

/* macros for field PDREGLO5 */
#define RADIO130NM_RF5G1_CH0__PDREGLO5__SHIFT                                10
#define RADIO130NM_RF5G1_CH0__PDREGLO5__WIDTH                                 1
#define RADIO130NM_RF5G1_CH0__PDREGLO5__MASK                        0x00000400U
#define RADIO130NM_RF5G1_CH0__PDREGLO5__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000400U) >> 10)
#define RADIO130NM_RF5G1_CH0__PDREGLO5__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 10) & 0x00000400U)
#define RADIO130NM_RF5G1_CH0__PDREGLO5__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000400U) | (((u_int32_t)(src) <<\
                    10) & 0x00000400U)
#define RADIO130NM_RF5G1_CH0__PDREGLO5__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 10) & ~0x00000400U)))
#define RADIO130NM_RF5G1_CH0__PDREGLO5__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000400U) | ((u_int32_t)(1) << 10)
#define RADIO130NM_RF5G1_CH0__PDREGLO5__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000400U) | ((u_int32_t)(0) << 10)

/* macros for field REGLO_BYPASS5 */
#define RADIO130NM_RF5G1_CH0__REGLO_BYPASS5__SHIFT                           11
#define RADIO130NM_RF5G1_CH0__REGLO_BYPASS5__WIDTH                            1
#define RADIO130NM_RF5G1_CH0__REGLO_BYPASS5__MASK                   0x00000800U
#define RADIO130NM_RF5G1_CH0__REGLO_BYPASS5__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000800U) >> 11)
#define RADIO130NM_RF5G1_CH0__REGLO_BYPASS5__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 11) & 0x00000800U)
#define RADIO130NM_RF5G1_CH0__REGLO_BYPASS5__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000800U) | (((u_int32_t)(src) <<\
                    11) & 0x00000800U)
#define RADIO130NM_RF5G1_CH0__REGLO_BYPASS5__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 11) & ~0x00000800U)))
#define RADIO130NM_RF5G1_CH0__REGLO_BYPASS5__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000800U) | ((u_int32_t)(1) << 11)
#define RADIO130NM_RF5G1_CH0__REGLO_BYPASS5__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000800U) | ((u_int32_t)(0) << 11)

/* macros for field LO5CONTROL */
#define RADIO130NM_RF5G1_CH0__LO5CONTROL__SHIFT                              12
#define RADIO130NM_RF5G1_CH0__LO5CONTROL__WIDTH                               1
#define RADIO130NM_RF5G1_CH0__LO5CONTROL__MASK                      0x00001000U
#define RADIO130NM_RF5G1_CH0__LO5CONTROL__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00001000U) >> 12)
#define RADIO130NM_RF5G1_CH0__LO5CONTROL__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 12) & 0x00001000U)
#define RADIO130NM_RF5G1_CH0__LO5CONTROL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00001000U) | (((u_int32_t)(src) <<\
                    12) & 0x00001000U)
#define RADIO130NM_RF5G1_CH0__LO5CONTROL__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 12) & ~0x00001000U)))
#define RADIO130NM_RF5G1_CH0__LO5CONTROL__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00001000U) | ((u_int32_t)(1) << 12)
#define RADIO130NM_RF5G1_CH0__LO5CONTROL__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00001000U) | ((u_int32_t)(0) << 12)

/* macros for field TX5_ATB_SEL */
#define RADIO130NM_RF5G1_CH0__TX5_ATB_SEL__SHIFT                             13
#define RADIO130NM_RF5G1_CH0__TX5_ATB_SEL__WIDTH                              3
#define RADIO130NM_RF5G1_CH0__TX5_ATB_SEL__MASK                     0x0000e000U
#define RADIO130NM_RF5G1_CH0__TX5_ATB_SEL__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0000e000U) >> 13)
#define RADIO130NM_RF5G1_CH0__TX5_ATB_SEL__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 13) & 0x0000e000U)
#define RADIO130NM_RF5G1_CH0__TX5_ATB_SEL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000e000U) | (((u_int32_t)(src) <<\
                    13) & 0x0000e000U)
#define RADIO130NM_RF5G1_CH0__TX5_ATB_SEL__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 13) & ~0x0000e000U)))

/* macros for field OB5 */
#define RADIO130NM_RF5G1_CH0__OB5__SHIFT                                     16
#define RADIO130NM_RF5G1_CH0__OB5__WIDTH                                      3
#define RADIO130NM_RF5G1_CH0__OB5__MASK                             0x00070000U
#define RADIO130NM_RF5G1_CH0__OB5__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00070000U) >> 16)
#define RADIO130NM_RF5G1_CH0__OB5__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 16) & 0x00070000U)
#define RADIO130NM_RF5G1_CH0__OB5__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00070000U) | (((u_int32_t)(src) <<\
                    16) & 0x00070000U)
#define RADIO130NM_RF5G1_CH0__OB5__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 16) & ~0x00070000U)))

/* macros for field DB5 */
#define RADIO130NM_RF5G1_CH0__DB5__SHIFT                                     19
#define RADIO130NM_RF5G1_CH0__DB5__WIDTH                                      3
#define RADIO130NM_RF5G1_CH0__DB5__MASK                             0x00380000U
#define RADIO130NM_RF5G1_CH0__DB5__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00380000U) >> 19)
#define RADIO130NM_RF5G1_CH0__DB5__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 19) & 0x00380000U)
#define RADIO130NM_RF5G1_CH0__DB5__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00380000U) | (((u_int32_t)(src) <<\
                    19) & 0x00380000U)
#define RADIO130NM_RF5G1_CH0__DB5__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 19) & ~0x00380000U)))

/* macros for field PWDTXPKD */
#define RADIO130NM_RF5G1_CH0__PWDTXPKD__SHIFT                                22
#define RADIO130NM_RF5G1_CH0__PWDTXPKD__WIDTH                                 3
#define RADIO130NM_RF5G1_CH0__PWDTXPKD__MASK                        0x01c00000U
#define RADIO130NM_RF5G1_CH0__PWDTXPKD__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x01c00000U) >> 22)
#define RADIO130NM_RF5G1_CH0__PWDTXPKD__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 22) & 0x01c00000U)
#define RADIO130NM_RF5G1_CH0__PWDTXPKD__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x01c00000U) | (((u_int32_t)(src) <<\
                    22) & 0x01c00000U)
#define RADIO130NM_RF5G1_CH0__PWDTXPKD__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 22) & ~0x01c00000U)))

/* macros for field PACASCBIAS */
#define RADIO130NM_RF5G1_CH0__PACASCBIAS__SHIFT                              25
#define RADIO130NM_RF5G1_CH0__PACASCBIAS__WIDTH                               2
#define RADIO130NM_RF5G1_CH0__PACASCBIAS__MASK                      0x06000000U
#define RADIO130NM_RF5G1_CH0__PACASCBIAS__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x06000000U) >> 25)
#define RADIO130NM_RF5G1_CH0__PACASCBIAS__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 25) & 0x06000000U)
#define RADIO130NM_RF5G1_CH0__PACASCBIAS__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x06000000U) | (((u_int32_t)(src) <<\
                    25) & 0x06000000U)
#define RADIO130NM_RF5G1_CH0__PACASCBIAS__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 25) & ~0x06000000U)))

/* macros for field PDPAOUT5 */
#define RADIO130NM_RF5G1_CH0__PDPAOUT5__SHIFT                                27
#define RADIO130NM_RF5G1_CH0__PDPAOUT5__WIDTH                                 1
#define RADIO130NM_RF5G1_CH0__PDPAOUT5__MASK                        0x08000000U
#define RADIO130NM_RF5G1_CH0__PDPAOUT5__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x08000000U) >> 27)
#define RADIO130NM_RF5G1_CH0__PDPAOUT5__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 27) & 0x08000000U)
#define RADIO130NM_RF5G1_CH0__PDPAOUT5__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x08000000U) | (((u_int32_t)(src) <<\
                    27) & 0x08000000U)
#define RADIO130NM_RF5G1_CH0__PDPAOUT5__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 27) & ~0x08000000U)))
#define RADIO130NM_RF5G1_CH0__PDPAOUT5__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x08000000U) | ((u_int32_t)(1) << 27)
#define RADIO130NM_RF5G1_CH0__PDPAOUT5__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x08000000U) | ((u_int32_t)(0) << 27)

/* macros for field PDPADRV5 */
#define RADIO130NM_RF5G1_CH0__PDPADRV5__SHIFT                                28
#define RADIO130NM_RF5G1_CH0__PDPADRV5__WIDTH                                 1
#define RADIO130NM_RF5G1_CH0__PDPADRV5__MASK                        0x10000000U
#define RADIO130NM_RF5G1_CH0__PDPADRV5__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x10000000U) >> 28)
#define RADIO130NM_RF5G1_CH0__PDPADRV5__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 28) & 0x10000000U)
#define RADIO130NM_RF5G1_CH0__PDPADRV5__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x10000000U) | (((u_int32_t)(src) <<\
                    28) & 0x10000000U)
#define RADIO130NM_RF5G1_CH0__PDPADRV5__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 28) & ~0x10000000U)))
#define RADIO130NM_RF5G1_CH0__PDPADRV5__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x10000000U) | ((u_int32_t)(1) << 28)
#define RADIO130NM_RF5G1_CH0__PDPADRV5__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x10000000U) | ((u_int32_t)(0) << 28)

/* macros for field PDTXBUF5 */
#define RADIO130NM_RF5G1_CH0__PDTXBUF5__SHIFT                                29
#define RADIO130NM_RF5G1_CH0__PDTXBUF5__WIDTH                                 1
#define RADIO130NM_RF5G1_CH0__PDTXBUF5__MASK                        0x20000000U
#define RADIO130NM_RF5G1_CH0__PDTXBUF5__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x20000000U) >> 29)
#define RADIO130NM_RF5G1_CH0__PDTXBUF5__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 29) & 0x20000000U)
#define RADIO130NM_RF5G1_CH0__PDTXBUF5__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x20000000U) | (((u_int32_t)(src) <<\
                    29) & 0x20000000U)
#define RADIO130NM_RF5G1_CH0__PDTXBUF5__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 29) & ~0x20000000U)))
#define RADIO130NM_RF5G1_CH0__PDTXBUF5__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x20000000U) | ((u_int32_t)(1) << 29)
#define RADIO130NM_RF5G1_CH0__PDTXBUF5__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x20000000U) | ((u_int32_t)(0) << 29)

/* macros for field PDTXMIX5 */
#define RADIO130NM_RF5G1_CH0__PDTXMIX5__SHIFT                                30
#define RADIO130NM_RF5G1_CH0__PDTXMIX5__WIDTH                                 1
#define RADIO130NM_RF5G1_CH0__PDTXMIX5__MASK                        0x40000000U
#define RADIO130NM_RF5G1_CH0__PDTXMIX5__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x40000000U) >> 30)
#define RADIO130NM_RF5G1_CH0__PDTXMIX5__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 30) & 0x40000000U)
#define RADIO130NM_RF5G1_CH0__PDTXMIX5__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x40000000U) | (((u_int32_t)(src) <<\
                    30) & 0x40000000U)
#define RADIO130NM_RF5G1_CH0__PDTXMIX5__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 30) & ~0x40000000U)))
#define RADIO130NM_RF5G1_CH0__PDTXMIX5__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x40000000U) | ((u_int32_t)(1) << 30)
#define RADIO130NM_RF5G1_CH0__PDTXMIX5__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x40000000U) | ((u_int32_t)(0) << 30)

/* macros for field PDTXLO5 */
#define RADIO130NM_RF5G1_CH0__PDTXLO5__SHIFT                                 31
#define RADIO130NM_RF5G1_CH0__PDTXLO5__WIDTH                                  1
#define RADIO130NM_RF5G1_CH0__PDTXLO5__MASK                         0x80000000U
#define RADIO130NM_RF5G1_CH0__PDTXLO5__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x80000000U) >> 31)
#define RADIO130NM_RF5G1_CH0__PDTXLO5__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 31) & 0x80000000U)
#define RADIO130NM_RF5G1_CH0__PDTXLO5__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x80000000U) | (((u_int32_t)(src) <<\
                    31) & 0x80000000U)
#define RADIO130NM_RF5G1_CH0__PDTXLO5__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 31) & ~0x80000000U)))
#define RADIO130NM_RF5G1_CH0__PDTXLO5__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x80000000U) | ((u_int32_t)(1) << 31)
#define RADIO130NM_RF5G1_CH0__PDTXLO5__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x80000000U) | ((u_int32_t)(0) << 31)
#define RADIO130NM_RF5G1_CH0__TYPE                                    u_int32_t
#define RADIO130NM_RF5G1_CH0__READ                                  0xffffffffU
#define RADIO130NM_RF5G1_CH0__WRITE                                 0xffffffffU

#endif /* __RADIO130NM_RF5G1_CH0_MACRO__ */


/* macros for merlin2_0_radio_reg_map.RF5G1_CH0 */
#define INST_MERLIN2_0_RADIO_REG_MAP__RF5G1_CH0__NUM                          1

/* macros for BlueprintGlobalNameSpace::RADIO130NM_RF5G2_CH0 */
#ifndef __RADIO130NM_RF5G2_CH0_MACRO__
#define __RADIO130NM_RF5G2_CH0_MACRO__

/* macros for field SPARE */
#define RADIO130NM_RF5G2_CH0__SPARE__SHIFT                                    0
#define RADIO130NM_RF5G2_CH0__SPARE__WIDTH                                   11
#define RADIO130NM_RF5G2_CH0__SPARE__MASK                           0x000007ffU
#define RADIO130NM_RF5G2_CH0__SPARE__READ(src)   (u_int32_t)(src) & 0x000007ffU
#define RADIO130NM_RF5G2_CH0__SPARE__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x000007ffU)
#define RADIO130NM_RF5G2_CH0__SPARE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000007ffU) | ((u_int32_t)(src) &\
                    0x000007ffU)
#define RADIO130NM_RF5G2_CH0__SPARE__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x000007ffU)))

/* macros for field PDBIR2 */
#define RADIO130NM_RF5G2_CH0__PDBIR2__SHIFT                                  11
#define RADIO130NM_RF5G2_CH0__PDBIR2__WIDTH                                   3
#define RADIO130NM_RF5G2_CH0__PDBIR2__MASK                          0x00003800U
#define RADIO130NM_RF5G2_CH0__PDBIR2__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00003800U) >> 11)
#define RADIO130NM_RF5G2_CH0__PDBIR2__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 11) & 0x00003800U)
#define RADIO130NM_RF5G2_CH0__PDBIR2__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00003800U) | (((u_int32_t)(src) <<\
                    11) & 0x00003800U)
#define RADIO130NM_RF5G2_CH0__PDBIR2__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 11) & ~0x00003800U)))

/* macros for field PDBIR1 */
#define RADIO130NM_RF5G2_CH0__PDBIR1__SHIFT                                  14
#define RADIO130NM_RF5G2_CH0__PDBIR1__WIDTH                                   3
#define RADIO130NM_RF5G2_CH0__PDBIR1__MASK                          0x0001c000U
#define RADIO130NM_RF5G2_CH0__PDBIR1__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0001c000U) >> 14)
#define RADIO130NM_RF5G2_CH0__PDBIR1__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 14) & 0x0001c000U)
#define RADIO130NM_RF5G2_CH0__PDBIR1__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0001c000U) | (((u_int32_t)(src) <<\
                    14) & 0x0001c000U)
#define RADIO130NM_RF5G2_CH0__PDBIR1__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 14) & ~0x0001c000U)))

/* macros for field PDBIRTXPA */
#define RADIO130NM_RF5G2_CH0__PDBIRTXPA__SHIFT                               17
#define RADIO130NM_RF5G2_CH0__PDBIRTXPA__WIDTH                                3
#define RADIO130NM_RF5G2_CH0__PDBIRTXPA__MASK                       0x000e0000U
#define RADIO130NM_RF5G2_CH0__PDBIRTXPA__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x000e0000U) >> 17)
#define RADIO130NM_RF5G2_CH0__PDBIRTXPA__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 17) & 0x000e0000U)
#define RADIO130NM_RF5G2_CH0__PDBIRTXPA__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000e0000U) | (((u_int32_t)(src) <<\
                    17) & 0x000e0000U)
#define RADIO130NM_RF5G2_CH0__PDBIRTXPA__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 17) & ~0x000e0000U)))

/* macros for field PDBIRTXMIX */
#define RADIO130NM_RF5G2_CH0__PDBIRTXMIX__SHIFT                              20
#define RADIO130NM_RF5G2_CH0__PDBIRTXMIX__WIDTH                               3
#define RADIO130NM_RF5G2_CH0__PDBIRTXMIX__MASK                      0x00700000U
#define RADIO130NM_RF5G2_CH0__PDBIRTXMIX__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00700000U) >> 20)
#define RADIO130NM_RF5G2_CH0__PDBIRTXMIX__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 20) & 0x00700000U)
#define RADIO130NM_RF5G2_CH0__PDBIRTXMIX__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00700000U) | (((u_int32_t)(src) <<\
                    20) & 0x00700000U)
#define RADIO130NM_RF5G2_CH0__PDBIRTXMIX__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 20) & ~0x00700000U)))

/* macros for field RX5_ATB_SEL */
#define RADIO130NM_RF5G2_CH0__RX5_ATB_SEL__SHIFT                             23
#define RADIO130NM_RF5G2_CH0__RX5_ATB_SEL__WIDTH                              3
#define RADIO130NM_RF5G2_CH0__RX5_ATB_SEL__MASK                     0x03800000U
#define RADIO130NM_RF5G2_CH0__RX5_ATB_SEL__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x03800000U) >> 23)
#define RADIO130NM_RF5G2_CH0__RX5_ATB_SEL__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 23) & 0x03800000U)
#define RADIO130NM_RF5G2_CH0__RX5_ATB_SEL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x03800000U) | (((u_int32_t)(src) <<\
                    23) & 0x03800000U)
#define RADIO130NM_RF5G2_CH0__RX5_ATB_SEL__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 23) & ~0x03800000U)))

/* macros for field PDRFVGA5 */
#define RADIO130NM_RF5G2_CH0__PDRFVGA5__SHIFT                                26
#define RADIO130NM_RF5G2_CH0__PDRFVGA5__WIDTH                                 1
#define RADIO130NM_RF5G2_CH0__PDRFVGA5__MASK                        0x04000000U
#define RADIO130NM_RF5G2_CH0__PDRFVGA5__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x04000000U) >> 26)
#define RADIO130NM_RF5G2_CH0__PDRFVGA5__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 26) & 0x04000000U)
#define RADIO130NM_RF5G2_CH0__PDRFVGA5__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x04000000U) | (((u_int32_t)(src) <<\
                    26) & 0x04000000U)
#define RADIO130NM_RF5G2_CH0__PDRFVGA5__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 26) & ~0x04000000U)))
#define RADIO130NM_RF5G2_CH0__PDRFVGA5__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x04000000U) | ((u_int32_t)(1) << 26)
#define RADIO130NM_RF5G2_CH0__PDRFVGA5__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x04000000U) | ((u_int32_t)(0) << 26)

/* macros for field PDCSLNA5 */
#define RADIO130NM_RF5G2_CH0__PDCSLNA5__SHIFT                                27
#define RADIO130NM_RF5G2_CH0__PDCSLNA5__WIDTH                                 1
#define RADIO130NM_RF5G2_CH0__PDCSLNA5__MASK                        0x08000000U
#define RADIO130NM_RF5G2_CH0__PDCSLNA5__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x08000000U) >> 27)
#define RADIO130NM_RF5G2_CH0__PDCSLNA5__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 27) & 0x08000000U)
#define RADIO130NM_RF5G2_CH0__PDCSLNA5__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x08000000U) | (((u_int32_t)(src) <<\
                    27) & 0x08000000U)
#define RADIO130NM_RF5G2_CH0__PDCSLNA5__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 27) & ~0x08000000U)))
#define RADIO130NM_RF5G2_CH0__PDCSLNA5__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x08000000U) | ((u_int32_t)(1) << 27)
#define RADIO130NM_RF5G2_CH0__PDCSLNA5__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x08000000U) | ((u_int32_t)(0) << 27)

/* macros for field PDVGM5 */
#define RADIO130NM_RF5G2_CH0__PDVGM5__SHIFT                                  28
#define RADIO130NM_RF5G2_CH0__PDVGM5__WIDTH                                   1
#define RADIO130NM_RF5G2_CH0__PDVGM5__MASK                          0x10000000U
#define RADIO130NM_RF5G2_CH0__PDVGM5__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x10000000U) >> 28)
#define RADIO130NM_RF5G2_CH0__PDVGM5__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 28) & 0x10000000U)
#define RADIO130NM_RF5G2_CH0__PDVGM5__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x10000000U) | (((u_int32_t)(src) <<\
                    28) & 0x10000000U)
#define RADIO130NM_RF5G2_CH0__PDVGM5__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 28) & ~0x10000000U)))
#define RADIO130NM_RF5G2_CH0__PDVGM5__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x10000000U) | ((u_int32_t)(1) << 28)
#define RADIO130NM_RF5G2_CH0__PDVGM5__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x10000000U) | ((u_int32_t)(0) << 28)

/* macros for field PDRXLO5 */
#define RADIO130NM_RF5G2_CH0__PDRXLO5__SHIFT                                 29
#define RADIO130NM_RF5G2_CH0__PDRXLO5__WIDTH                                  1
#define RADIO130NM_RF5G2_CH0__PDRXLO5__MASK                         0x20000000U
#define RADIO130NM_RF5G2_CH0__PDRXLO5__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x20000000U) >> 29)
#define RADIO130NM_RF5G2_CH0__PDRXLO5__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 29) & 0x20000000U)
#define RADIO130NM_RF5G2_CH0__PDRXLO5__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x20000000U) | (((u_int32_t)(src) <<\
                    29) & 0x20000000U)
#define RADIO130NM_RF5G2_CH0__PDRXLO5__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 29) & ~0x20000000U)))
#define RADIO130NM_RF5G2_CH0__PDRXLO5__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x20000000U) | ((u_int32_t)(1) << 29)
#define RADIO130NM_RF5G2_CH0__PDRXLO5__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x20000000U) | ((u_int32_t)(0) << 29)

/* macros for field PDREGFE5 */
#define RADIO130NM_RF5G2_CH0__PDREGFE5__SHIFT                                30
#define RADIO130NM_RF5G2_CH0__PDREGFE5__WIDTH                                 1
#define RADIO130NM_RF5G2_CH0__PDREGFE5__MASK                        0x40000000U
#define RADIO130NM_RF5G2_CH0__PDREGFE5__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x40000000U) >> 30)
#define RADIO130NM_RF5G2_CH0__PDREGFE5__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 30) & 0x40000000U)
#define RADIO130NM_RF5G2_CH0__PDREGFE5__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x40000000U) | (((u_int32_t)(src) <<\
                    30) & 0x40000000U)
#define RADIO130NM_RF5G2_CH0__PDREGFE5__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 30) & ~0x40000000U)))
#define RADIO130NM_RF5G2_CH0__PDREGFE5__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x40000000U) | ((u_int32_t)(1) << 30)
#define RADIO130NM_RF5G2_CH0__PDREGFE5__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x40000000U) | ((u_int32_t)(0) << 30)

/* macros for field REGFE_BYPASS5 */
#define RADIO130NM_RF5G2_CH0__REGFE_BYPASS5__SHIFT                           31
#define RADIO130NM_RF5G2_CH0__REGFE_BYPASS5__WIDTH                            1
#define RADIO130NM_RF5G2_CH0__REGFE_BYPASS5__MASK                   0x80000000U
#define RADIO130NM_RF5G2_CH0__REGFE_BYPASS5__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x80000000U) >> 31)
#define RADIO130NM_RF5G2_CH0__REGFE_BYPASS5__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 31) & 0x80000000U)
#define RADIO130NM_RF5G2_CH0__REGFE_BYPASS5__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x80000000U) | (((u_int32_t)(src) <<\
                    31) & 0x80000000U)
#define RADIO130NM_RF5G2_CH0__REGFE_BYPASS5__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 31) & ~0x80000000U)))
#define RADIO130NM_RF5G2_CH0__REGFE_BYPASS5__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x80000000U) | ((u_int32_t)(1) << 31)
#define RADIO130NM_RF5G2_CH0__REGFE_BYPASS5__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x80000000U) | ((u_int32_t)(0) << 31)
#define RADIO130NM_RF5G2_CH0__TYPE                                    u_int32_t
#define RADIO130NM_RF5G2_CH0__READ                                  0xffffffffU
#define RADIO130NM_RF5G2_CH0__WRITE                                 0xffffffffU

#endif /* __RADIO130NM_RF5G2_CH0_MACRO__ */


/* macros for merlin2_0_radio_reg_map.RF5G2_CH0 */
#define INST_MERLIN2_0_RADIO_REG_MAP__RF5G2_CH0__NUM                          1

/* macros for BlueprintGlobalNameSpace::RADIO130NM_RF5G3_CH0 */
#ifndef __RADIO130NM_RF5G3_CH0_MACRO__
#define __RADIO130NM_RF5G3_CH0_MACRO__

/* macros for field SPARE */
#define RADIO130NM_RF5G3_CH0__SPARE__SHIFT                                    0
#define RADIO130NM_RF5G3_CH0__SPARE__WIDTH                                    5
#define RADIO130NM_RF5G3_CH0__SPARE__MASK                           0x0000001fU
#define RADIO130NM_RF5G3_CH0__SPARE__READ(src)   (u_int32_t)(src) & 0x0000001fU
#define RADIO130NM_RF5G3_CH0__SPARE__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x0000001fU)
#define RADIO130NM_RF5G3_CH0__SPARE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000001fU) | ((u_int32_t)(src) &\
                    0x0000001fU)
#define RADIO130NM_RF5G3_CH0__SPARE__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x0000001fU)))

/* macros for field PDBIBCVGM */
#define RADIO130NM_RF5G3_CH0__PDBIBCVGM__SHIFT                                5
#define RADIO130NM_RF5G3_CH0__PDBIBCVGM__WIDTH                                3
#define RADIO130NM_RF5G3_CH0__PDBIBCVGM__MASK                       0x000000e0U
#define RADIO130NM_RF5G3_CH0__PDBIBCVGM__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x000000e0U) >> 5)
#define RADIO130NM_RF5G3_CH0__PDBIBCVGM__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 5) & 0x000000e0U)
#define RADIO130NM_RF5G3_CH0__PDBIBCVGM__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000000e0U) | (((u_int32_t)(src) <<\
                    5) & 0x000000e0U)
#define RADIO130NM_RF5G3_CH0__PDBIBCVGM__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 5) & ~0x000000e0U)))

/* macros for field PDBIBCRFVGA */
#define RADIO130NM_RF5G3_CH0__PDBIBCRFVGA__SHIFT                              8
#define RADIO130NM_RF5G3_CH0__PDBIBCRFVGA__WIDTH                              3
#define RADIO130NM_RF5G3_CH0__PDBIBCRFVGA__MASK                     0x00000700U
#define RADIO130NM_RF5G3_CH0__PDBIBCRFVGA__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000700U) >> 8)
#define RADIO130NM_RF5G3_CH0__PDBIBCRFVGA__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 8) & 0x00000700U)
#define RADIO130NM_RF5G3_CH0__PDBIBCRFVGA__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000700U) | (((u_int32_t)(src) <<\
                    8) & 0x00000700U)
#define RADIO130NM_RF5G3_CH0__PDBIBCRFVGA__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 8) & ~0x00000700U)))

/* macros for field PDBIBCLNA */
#define RADIO130NM_RF5G3_CH0__PDBIBCLNA__SHIFT                               11
#define RADIO130NM_RF5G3_CH0__PDBIBCLNA__WIDTH                                3
#define RADIO130NM_RF5G3_CH0__PDBIBCLNA__MASK                       0x00003800U
#define RADIO130NM_RF5G3_CH0__PDBIBCLNA__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00003800U) >> 11)
#define RADIO130NM_RF5G3_CH0__PDBIBCLNA__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 11) & 0x00003800U)
#define RADIO130NM_RF5G3_CH0__PDBIBCLNA__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00003800U) | (((u_int32_t)(src) <<\
                    11) & 0x00003800U)
#define RADIO130NM_RF5G3_CH0__PDBIBCLNA__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 11) & ~0x00003800U)))

/* macros for field PDBIC3 */
#define RADIO130NM_RF5G3_CH0__PDBIC3__SHIFT                                  14
#define RADIO130NM_RF5G3_CH0__PDBIC3__WIDTH                                   3
#define RADIO130NM_RF5G3_CH0__PDBIC3__MASK                          0x0001c000U
#define RADIO130NM_RF5G3_CH0__PDBIC3__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0001c000U) >> 14)
#define RADIO130NM_RF5G3_CH0__PDBIC3__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 14) & 0x0001c000U)
#define RADIO130NM_RF5G3_CH0__PDBIC3__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0001c000U) | (((u_int32_t)(src) <<\
                    14) & 0x0001c000U)
#define RADIO130NM_RF5G3_CH0__PDBIC3__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 14) & ~0x0001c000U)))

/* macros for field PDBIC2 */
#define RADIO130NM_RF5G3_CH0__PDBIC2__SHIFT                                  17
#define RADIO130NM_RF5G3_CH0__PDBIC2__WIDTH                                   3
#define RADIO130NM_RF5G3_CH0__PDBIC2__MASK                          0x000e0000U
#define RADIO130NM_RF5G3_CH0__PDBIC2__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x000e0000U) >> 17)
#define RADIO130NM_RF5G3_CH0__PDBIC2__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 17) & 0x000e0000U)
#define RADIO130NM_RF5G3_CH0__PDBIC2__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000e0000U) | (((u_int32_t)(src) <<\
                    17) & 0x000e0000U)
#define RADIO130NM_RF5G3_CH0__PDBIC2__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 17) & ~0x000e0000U)))

/* macros for field PDBIC1 */
#define RADIO130NM_RF5G3_CH0__PDBIC1__SHIFT                                  20
#define RADIO130NM_RF5G3_CH0__PDBIC1__WIDTH                                   3
#define RADIO130NM_RF5G3_CH0__PDBIC1__MASK                          0x00700000U
#define RADIO130NM_RF5G3_CH0__PDBIC1__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00700000U) >> 20)
#define RADIO130NM_RF5G3_CH0__PDBIC1__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 20) & 0x00700000U)
#define RADIO130NM_RF5G3_CH0__PDBIC1__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00700000U) | (((u_int32_t)(src) <<\
                    20) & 0x00700000U)
#define RADIO130NM_RF5G3_CH0__PDBIC1__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 20) & ~0x00700000U)))

/* macros for field PDBICTXMIX */
#define RADIO130NM_RF5G3_CH0__PDBICTXMIX__SHIFT                              23
#define RADIO130NM_RF5G3_CH0__PDBICTXMIX__WIDTH                               3
#define RADIO130NM_RF5G3_CH0__PDBICTXMIX__MASK                      0x03800000U
#define RADIO130NM_RF5G3_CH0__PDBICTXMIX__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x03800000U) >> 23)
#define RADIO130NM_RF5G3_CH0__PDBICTXMIX__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 23) & 0x03800000U)
#define RADIO130NM_RF5G3_CH0__PDBICTXMIX__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x03800000U) | (((u_int32_t)(src) <<\
                    23) & 0x03800000U)
#define RADIO130NM_RF5G3_CH0__PDBICTXMIX__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 23) & ~0x03800000U)))

/* macros for field PDBICTXPA */
#define RADIO130NM_RF5G3_CH0__PDBICTXPA__SHIFT                               26
#define RADIO130NM_RF5G3_CH0__PDBICTXPA__WIDTH                                3
#define RADIO130NM_RF5G3_CH0__PDBICTXPA__MASK                       0x1c000000U
#define RADIO130NM_RF5G3_CH0__PDBICTXPA__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x1c000000U) >> 26)
#define RADIO130NM_RF5G3_CH0__PDBICTXPA__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 26) & 0x1c000000U)
#define RADIO130NM_RF5G3_CH0__PDBICTXPA__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x1c000000U) | (((u_int32_t)(src) <<\
                    26) & 0x1c000000U)
#define RADIO130NM_RF5G3_CH0__PDBICTXPA__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 26) & ~0x1c000000U)))

/* macros for field PDBICTXBUF */
#define RADIO130NM_RF5G3_CH0__PDBICTXBUF__SHIFT                              29
#define RADIO130NM_RF5G3_CH0__PDBICTXBUF__WIDTH                               3
#define RADIO130NM_RF5G3_CH0__PDBICTXBUF__MASK                      0xe0000000U
#define RADIO130NM_RF5G3_CH0__PDBICTXBUF__READ(src) \
                    (((u_int32_t)(src)\
                    & 0xe0000000U) >> 29)
#define RADIO130NM_RF5G3_CH0__PDBICTXBUF__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 29) & 0xe0000000U)
#define RADIO130NM_RF5G3_CH0__PDBICTXBUF__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xe0000000U) | (((u_int32_t)(src) <<\
                    29) & 0xe0000000U)
#define RADIO130NM_RF5G3_CH0__PDBICTXBUF__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 29) & ~0xe0000000U)))
#define RADIO130NM_RF5G3_CH0__TYPE                                    u_int32_t
#define RADIO130NM_RF5G3_CH0__READ                                  0xffffffffU
#define RADIO130NM_RF5G3_CH0__WRITE                                 0xffffffffU

#endif /* __RADIO130NM_RF5G3_CH0_MACRO__ */


/* macros for merlin2_0_radio_reg_map.RF5G3_CH0 */
#define INST_MERLIN2_0_RADIO_REG_MAP__RF5G3_CH0__NUM                          1

/* macros for BlueprintGlobalNameSpace::RADIO130NM_RF2G1_CH0 */
#ifndef __RADIO130NM_RF2G1_CH0_MACRO__
#define __RADIO130NM_RF2G1_CH0_MACRO__

/* macros for field SPARES */
#define RADIO130NM_RF2G1_CH0__SPARES__SHIFT                                   0
#define RADIO130NM_RF2G1_CH0__SPARES__WIDTH                                   6
#define RADIO130NM_RF2G1_CH0__SPARES__MASK                          0x0000003fU
#define RADIO130NM_RF2G1_CH0__SPARES__READ(src)  (u_int32_t)(src) & 0x0000003fU
#define RADIO130NM_RF2G1_CH0__SPARES__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x0000003fU)
#define RADIO130NM_RF2G1_CH0__SPARES__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000003fU) | ((u_int32_t)(src) &\
                    0x0000003fU)
#define RADIO130NM_RF2G1_CH0__SPARES__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x0000003fU)))

/* macros for field REGLO_BYPASS */
#define RADIO130NM_RF2G1_CH0__REGLO_BYPASS__SHIFT                             6
#define RADIO130NM_RF2G1_CH0__REGLO_BYPASS__WIDTH                             1
#define RADIO130NM_RF2G1_CH0__REGLO_BYPASS__MASK                    0x00000040U
#define RADIO130NM_RF2G1_CH0__REGLO_BYPASS__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000040U) >> 6)
#define RADIO130NM_RF2G1_CH0__REGLO_BYPASS__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 6) & 0x00000040U)
#define RADIO130NM_RF2G1_CH0__REGLO_BYPASS__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000040U) | (((u_int32_t)(src) <<\
                    6) & 0x00000040U)
#define RADIO130NM_RF2G1_CH0__REGLO_BYPASS__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 6) & ~0x00000040U)))
#define RADIO130NM_RF2G1_CH0__REGLO_BYPASS__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000040U) | ((u_int32_t)(1) << 6)
#define RADIO130NM_RF2G1_CH0__REGLO_BYPASS__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000040U) | ((u_int32_t)(0) << 6)

/* macros for field REGLNA_BYPASS */
#define RADIO130NM_RF2G1_CH0__REGLNA_BYPASS__SHIFT                            7
#define RADIO130NM_RF2G1_CH0__REGLNA_BYPASS__WIDTH                            1
#define RADIO130NM_RF2G1_CH0__REGLNA_BYPASS__MASK                   0x00000080U
#define RADIO130NM_RF2G1_CH0__REGLNA_BYPASS__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000080U) >> 7)
#define RADIO130NM_RF2G1_CH0__REGLNA_BYPASS__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 7) & 0x00000080U)
#define RADIO130NM_RF2G1_CH0__REGLNA_BYPASS__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000080U) | (((u_int32_t)(src) <<\
                    7) & 0x00000080U)
#define RADIO130NM_RF2G1_CH0__REGLNA_BYPASS__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 7) & ~0x00000080U)))
#define RADIO130NM_RF2G1_CH0__REGLNA_BYPASS__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000080U) | ((u_int32_t)(1) << 7)
#define RADIO130NM_RF2G1_CH0__REGLNA_BYPASS__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000080U) | ((u_int32_t)(0) << 7)

/* macros for field PDIC25U_VGM */
#define RADIO130NM_RF2G1_CH0__PDIC25U_VGM__SHIFT                              8
#define RADIO130NM_RF2G1_CH0__PDIC25U_VGM__WIDTH                              3
#define RADIO130NM_RF2G1_CH0__PDIC25U_VGM__MASK                     0x00000700U
#define RADIO130NM_RF2G1_CH0__PDIC25U_VGM__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000700U) >> 8)
#define RADIO130NM_RF2G1_CH0__PDIC25U_VGM__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 8) & 0x00000700U)
#define RADIO130NM_RF2G1_CH0__PDIC25U_VGM__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000700U) | (((u_int32_t)(src) <<\
                    8) & 0x00000700U)
#define RADIO130NM_RF2G1_CH0__PDIC25U_VGM__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 8) & ~0x00000700U)))

/* macros for field PACA_SEL */
#define RADIO130NM_RF2G1_CH0__PACA_SEL__SHIFT                                11
#define RADIO130NM_RF2G1_CH0__PACA_SEL__WIDTH                                 2
#define RADIO130NM_RF2G1_CH0__PACA_SEL__MASK                        0x00001800U
#define RADIO130NM_RF2G1_CH0__PACA_SEL__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00001800U) >> 11)
#define RADIO130NM_RF2G1_CH0__PACA_SEL__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 11) & 0x00001800U)
#define RADIO130NM_RF2G1_CH0__PACA_SEL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00001800U) | (((u_int32_t)(src) <<\
                    11) & 0x00001800U)
#define RADIO130NM_RF2G1_CH0__PACA_SEL__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 11) & ~0x00001800U)))

/* macros for field LOCONTROL */
#define RADIO130NM_RF2G1_CH0__LOCONTROL__SHIFT                               13
#define RADIO130NM_RF2G1_CH0__LOCONTROL__WIDTH                                1
#define RADIO130NM_RF2G1_CH0__LOCONTROL__MASK                       0x00002000U
#define RADIO130NM_RF2G1_CH0__LOCONTROL__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00002000U) >> 13)
#define RADIO130NM_RF2G1_CH0__LOCONTROL__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 13) & 0x00002000U)
#define RADIO130NM_RF2G1_CH0__LOCONTROL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00002000U) | (((u_int32_t)(src) <<\
                    13) & 0x00002000U)
#define RADIO130NM_RF2G1_CH0__LOCONTROL__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 13) & ~0x00002000U)))
#define RADIO130NM_RF2G1_CH0__LOCONTROL__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00002000U) | ((u_int32_t)(1) << 13)
#define RADIO130NM_RF2G1_CH0__LOCONTROL__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00002000U) | ((u_int32_t)(0) << 13)

/* macros for field TXATB_SEL */
#define RADIO130NM_RF2G1_CH0__TXATB_SEL__SHIFT                               14
#define RADIO130NM_RF2G1_CH0__TXATB_SEL__WIDTH                                3
#define RADIO130NM_RF2G1_CH0__TXATB_SEL__MASK                       0x0001c000U
#define RADIO130NM_RF2G1_CH0__TXATB_SEL__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0001c000U) >> 14)
#define RADIO130NM_RF2G1_CH0__TXATB_SEL__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 14) & 0x0001c000U)
#define RADIO130NM_RF2G1_CH0__TXATB_SEL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0001c000U) | (((u_int32_t)(src) <<\
                    14) & 0x0001c000U)
#define RADIO130NM_RF2G1_CH0__TXATB_SEL__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 14) & ~0x0001c000U)))

/* macros for field RXATB_SEL */
#define RADIO130NM_RF2G1_CH0__RXATB_SEL__SHIFT                               17
#define RADIO130NM_RF2G1_CH0__RXATB_SEL__WIDTH                                3
#define RADIO130NM_RF2G1_CH0__RXATB_SEL__MASK                       0x000e0000U
#define RADIO130NM_RF2G1_CH0__RXATB_SEL__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x000e0000U) >> 17)
#define RADIO130NM_RF2G1_CH0__RXATB_SEL__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 17) & 0x000e0000U)
#define RADIO130NM_RF2G1_CH0__RXATB_SEL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000e0000U) | (((u_int32_t)(src) <<\
                    17) & 0x000e0000U)
#define RADIO130NM_RF2G1_CH0__RXATB_SEL__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 17) & ~0x000e0000U)))

/* macros for field LOATB_SEL */
#define RADIO130NM_RF2G1_CH0__LOATB_SEL__SHIFT                               20
#define RADIO130NM_RF2G1_CH0__LOATB_SEL__WIDTH                                3
#define RADIO130NM_RF2G1_CH0__LOATB_SEL__MASK                       0x00700000U
#define RADIO130NM_RF2G1_CH0__LOATB_SEL__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00700000U) >> 20)
#define RADIO130NM_RF2G1_CH0__LOATB_SEL__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 20) & 0x00700000U)
#define RADIO130NM_RF2G1_CH0__LOATB_SEL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00700000U) | (((u_int32_t)(src) <<\
                    20) & 0x00700000U)
#define RADIO130NM_RF2G1_CH0__LOATB_SEL__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 20) & ~0x00700000U)))

/* macros for field OB */
#define RADIO130NM_RF2G1_CH0__OB__SHIFT                                      23
#define RADIO130NM_RF2G1_CH0__OB__WIDTH                                       3
#define RADIO130NM_RF2G1_CH0__OB__MASK                              0x03800000U
#define RADIO130NM_RF2G1_CH0__OB__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x03800000U) >> 23)
#define RADIO130NM_RF2G1_CH0__OB__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 23) & 0x03800000U)
#define RADIO130NM_RF2G1_CH0__OB__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x03800000U) | (((u_int32_t)(src) <<\
                    23) & 0x03800000U)
#define RADIO130NM_RF2G1_CH0__OB__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 23) & ~0x03800000U)))

/* macros for field DB */
#define RADIO130NM_RF2G1_CH0__DB__SHIFT                                      26
#define RADIO130NM_RF2G1_CH0__DB__WIDTH                                       3
#define RADIO130NM_RF2G1_CH0__DB__MASK                              0x1c000000U
#define RADIO130NM_RF2G1_CH0__DB__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x1c000000U) >> 26)
#define RADIO130NM_RF2G1_CH0__DB__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 26) & 0x1c000000U)
#define RADIO130NM_RF2G1_CH0__DB__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x1c000000U) | (((u_int32_t)(src) <<\
                    26) & 0x1c000000U)
#define RADIO130NM_RF2G1_CH0__DB__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 26) & ~0x1c000000U)))

/* macros for field PDIC25U_LNA */
#define RADIO130NM_RF2G1_CH0__PDIC25U_LNA__SHIFT                             29
#define RADIO130NM_RF2G1_CH0__PDIC25U_LNA__WIDTH                              3
#define RADIO130NM_RF2G1_CH0__PDIC25U_LNA__MASK                     0xe0000000U
#define RADIO130NM_RF2G1_CH0__PDIC25U_LNA__READ(src) \
                    (((u_int32_t)(src)\
                    & 0xe0000000U) >> 29)
#define RADIO130NM_RF2G1_CH0__PDIC25U_LNA__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 29) & 0xe0000000U)
#define RADIO130NM_RF2G1_CH0__PDIC25U_LNA__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xe0000000U) | (((u_int32_t)(src) <<\
                    29) & 0xe0000000U)
#define RADIO130NM_RF2G1_CH0__PDIC25U_LNA__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 29) & ~0xe0000000U)))
#define RADIO130NM_RF2G1_CH0__TYPE                                    u_int32_t
#define RADIO130NM_RF2G1_CH0__READ                                  0xffffffffU
#define RADIO130NM_RF2G1_CH0__WRITE                                 0xffffffffU

#endif /* __RADIO130NM_RF2G1_CH0_MACRO__ */


/* macros for merlin2_0_radio_reg_map.RF2G1_CH0 */
#define INST_MERLIN2_0_RADIO_REG_MAP__RF2G1_CH0__NUM                          1

/* macros for BlueprintGlobalNameSpace::RADIO130NM_RF2G2_CH0 */
#ifndef __RADIO130NM_RF2G2_CH0_MACRO__
#define __RADIO130NM_RF2G2_CH0_MACRO__

/* macros for field PDIR25U_VREGLO */
#define RADIO130NM_RF2G2_CH0__PDIR25U_VREGLO__SHIFT                           0
#define RADIO130NM_RF2G2_CH0__PDIR25U_VREGLO__WIDTH                           3
#define RADIO130NM_RF2G2_CH0__PDIR25U_VREGLO__MASK                  0x00000007U
#define RADIO130NM_RF2G2_CH0__PDIR25U_VREGLO__READ(src) \
                    (u_int32_t)(src)\
                    & 0x00000007U
#define RADIO130NM_RF2G2_CH0__PDIR25U_VREGLO__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x00000007U)
#define RADIO130NM_RF2G2_CH0__PDIR25U_VREGLO__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000007U) | ((u_int32_t)(src) &\
                    0x00000007U)
#define RADIO130NM_RF2G2_CH0__PDIR25U_VREGLO__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00000007U)))

/* macros for field PDIC25U_VREGLO */
#define RADIO130NM_RF2G2_CH0__PDIC25U_VREGLO__SHIFT                           3
#define RADIO130NM_RF2G2_CH0__PDIC25U_VREGLO__WIDTH                           3
#define RADIO130NM_RF2G2_CH0__PDIC25U_VREGLO__MASK                  0x00000038U
#define RADIO130NM_RF2G2_CH0__PDIC25U_VREGLO__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000038U) >> 3)
#define RADIO130NM_RF2G2_CH0__PDIC25U_VREGLO__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 3) & 0x00000038U)
#define RADIO130NM_RF2G2_CH0__PDIC25U_VREGLO__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000038U) | (((u_int32_t)(src) <<\
                    3) & 0x00000038U)
#define RADIO130NM_RF2G2_CH0__PDIC25U_VREGLO__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 3) & ~0x00000038U)))

/* macros for field PDIC50U_DIV */
#define RADIO130NM_RF2G2_CH0__PDIC50U_DIV__SHIFT                              6
#define RADIO130NM_RF2G2_CH0__PDIC50U_DIV__WIDTH                              3
#define RADIO130NM_RF2G2_CH0__PDIC50U_DIV__MASK                     0x000001c0U
#define RADIO130NM_RF2G2_CH0__PDIC50U_DIV__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x000001c0U) >> 6)
#define RADIO130NM_RF2G2_CH0__PDIC50U_DIV__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 6) & 0x000001c0U)
#define RADIO130NM_RF2G2_CH0__PDIC50U_DIV__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000001c0U) | (((u_int32_t)(src) <<\
                    6) & 0x000001c0U)
#define RADIO130NM_RF2G2_CH0__PDIC50U_DIV__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 6) & ~0x000001c0U)))

/* macros for field PDIC25U_RXRF */
#define RADIO130NM_RF2G2_CH0__PDIC25U_RXRF__SHIFT                             9
#define RADIO130NM_RF2G2_CH0__PDIC25U_RXRF__WIDTH                             3
#define RADIO130NM_RF2G2_CH0__PDIC25U_RXRF__MASK                    0x00000e00U
#define RADIO130NM_RF2G2_CH0__PDIC25U_RXRF__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000e00U) >> 9)
#define RADIO130NM_RF2G2_CH0__PDIC25U_RXRF__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 9) & 0x00000e00U)
#define RADIO130NM_RF2G2_CH0__PDIC25U_RXRF__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000e00U) | (((u_int32_t)(src) <<\
                    9) & 0x00000e00U)
#define RADIO130NM_RF2G2_CH0__PDIC25U_RXRF__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 9) & ~0x00000e00U)))

/* macros for field PDIC25U_TXRF */
#define RADIO130NM_RF2G2_CH0__PDIC25U_TXRF__SHIFT                            12
#define RADIO130NM_RF2G2_CH0__PDIC25U_TXRF__WIDTH                             3
#define RADIO130NM_RF2G2_CH0__PDIC25U_TXRF__MASK                    0x00007000U
#define RADIO130NM_RF2G2_CH0__PDIC25U_TXRF__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00007000U) >> 12)
#define RADIO130NM_RF2G2_CH0__PDIC25U_TXRF__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 12) & 0x00007000U)
#define RADIO130NM_RF2G2_CH0__PDIC25U_TXRF__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00007000U) | (((u_int32_t)(src) <<\
                    12) & 0x00007000U)
#define RADIO130NM_RF2G2_CH0__PDIC25U_TXRF__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 12) & ~0x00007000U)))

/* macros for field PDIC25U_TXPA */
#define RADIO130NM_RF2G2_CH0__PDIC25U_TXPA__SHIFT                            15
#define RADIO130NM_RF2G2_CH0__PDIC25U_TXPA__WIDTH                             3
#define RADIO130NM_RF2G2_CH0__PDIC25U_TXPA__MASK                    0x00038000U
#define RADIO130NM_RF2G2_CH0__PDIC25U_TXPA__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00038000U) >> 15)
#define RADIO130NM_RF2G2_CH0__PDIC25U_TXPA__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 15) & 0x00038000U)
#define RADIO130NM_RF2G2_CH0__PDIC25U_TXPA__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00038000U) | (((u_int32_t)(src) <<\
                    15) & 0x00038000U)
#define RADIO130NM_RF2G2_CH0__PDIC25U_TXPA__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 15) & ~0x00038000U)))

/* macros for field PDIR25U_TXPA */
#define RADIO130NM_RF2G2_CH0__PDIR25U_TXPA__SHIFT                            18
#define RADIO130NM_RF2G2_CH0__PDIR25U_TXPA__WIDTH                             1
#define RADIO130NM_RF2G2_CH0__PDIR25U_TXPA__MASK                    0x00040000U
#define RADIO130NM_RF2G2_CH0__PDIR25U_TXPA__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00040000U) >> 18)
#define RADIO130NM_RF2G2_CH0__PDIR25U_TXPA__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 18) & 0x00040000U)
#define RADIO130NM_RF2G2_CH0__PDIR25U_TXPA__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00040000U) | (((u_int32_t)(src) <<\
                    18) & 0x00040000U)
#define RADIO130NM_RF2G2_CH0__PDIR25U_TXPA__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 18) & ~0x00040000U)))
#define RADIO130NM_RF2G2_CH0__PDIR25U_TXPA__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00040000U) | ((u_int32_t)(1) << 18)
#define RADIO130NM_RF2G2_CH0__PDIR25U_TXPA__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00040000U) | ((u_int32_t)(0) << 18)

/* macros for field PDIR25U_TXMIX */
#define RADIO130NM_RF2G2_CH0__PDIR25U_TXMIX__SHIFT                           19
#define RADIO130NM_RF2G2_CH0__PDIR25U_TXMIX__WIDTH                            3
#define RADIO130NM_RF2G2_CH0__PDIR25U_TXMIX__MASK                   0x00380000U
#define RADIO130NM_RF2G2_CH0__PDIR25U_TXMIX__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00380000U) >> 19)
#define RADIO130NM_RF2G2_CH0__PDIR25U_TXMIX__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 19) & 0x00380000U)
#define RADIO130NM_RF2G2_CH0__PDIR25U_TXMIX__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00380000U) | (((u_int32_t)(src) <<\
                    19) & 0x00380000U)
#define RADIO130NM_RF2G2_CH0__PDIR25U_TXMIX__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 19) & ~0x00380000U)))

/* macros for field PDTXMIX */
#define RADIO130NM_RF2G2_CH0__PDTXMIX__SHIFT                                 22
#define RADIO130NM_RF2G2_CH0__PDTXMIX__WIDTH                                  1
#define RADIO130NM_RF2G2_CH0__PDTXMIX__MASK                         0x00400000U
#define RADIO130NM_RF2G2_CH0__PDTXMIX__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00400000U) >> 22)
#define RADIO130NM_RF2G2_CH0__PDTXMIX__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 22) & 0x00400000U)
#define RADIO130NM_RF2G2_CH0__PDTXMIX__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00400000U) | (((u_int32_t)(src) <<\
                    22) & 0x00400000U)
#define RADIO130NM_RF2G2_CH0__PDTXMIX__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 22) & ~0x00400000U)))
#define RADIO130NM_RF2G2_CH0__PDTXMIX__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00400000U) | ((u_int32_t)(1) << 22)
#define RADIO130NM_RF2G2_CH0__PDTXMIX__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00400000U) | ((u_int32_t)(0) << 22)

/* macros for field PDTXLO */
#define RADIO130NM_RF2G2_CH0__PDTXLO__SHIFT                                  23
#define RADIO130NM_RF2G2_CH0__PDTXLO__WIDTH                                   1
#define RADIO130NM_RF2G2_CH0__PDTXLO__MASK                          0x00800000U
#define RADIO130NM_RF2G2_CH0__PDTXLO__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00800000U) >> 23)
#define RADIO130NM_RF2G2_CH0__PDTXLO__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 23) & 0x00800000U)
#define RADIO130NM_RF2G2_CH0__PDTXLO__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00800000U) | (((u_int32_t)(src) <<\
                    23) & 0x00800000U)
#define RADIO130NM_RF2G2_CH0__PDTXLO__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 23) & ~0x00800000U)))
#define RADIO130NM_RF2G2_CH0__PDTXLO__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00800000U) | ((u_int32_t)(1) << 23)
#define RADIO130NM_RF2G2_CH0__PDTXLO__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00800000U) | ((u_int32_t)(0) << 23)

/* macros for field PDRXLO */
#define RADIO130NM_RF2G2_CH0__PDRXLO__SHIFT                                  24
#define RADIO130NM_RF2G2_CH0__PDRXLO__WIDTH                                   1
#define RADIO130NM_RF2G2_CH0__PDRXLO__MASK                          0x01000000U
#define RADIO130NM_RF2G2_CH0__PDRXLO__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x01000000U) >> 24)
#define RADIO130NM_RF2G2_CH0__PDRXLO__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 24) & 0x01000000U)
#define RADIO130NM_RF2G2_CH0__PDRXLO__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x01000000U) | (((u_int32_t)(src) <<\
                    24) & 0x01000000U)
#define RADIO130NM_RF2G2_CH0__PDRXLO__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 24) & ~0x01000000U)))
#define RADIO130NM_RF2G2_CH0__PDRXLO__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x01000000U) | ((u_int32_t)(1) << 24)
#define RADIO130NM_RF2G2_CH0__PDRXLO__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x01000000U) | ((u_int32_t)(0) << 24)

/* macros for field PDVGM */
#define RADIO130NM_RF2G2_CH0__PDVGM__SHIFT                                   25
#define RADIO130NM_RF2G2_CH0__PDVGM__WIDTH                                    1
#define RADIO130NM_RF2G2_CH0__PDVGM__MASK                           0x02000000U
#define RADIO130NM_RF2G2_CH0__PDVGM__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x02000000U) >> 25)
#define RADIO130NM_RF2G2_CH0__PDVGM__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 25) & 0x02000000U)
#define RADIO130NM_RF2G2_CH0__PDVGM__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x02000000U) | (((u_int32_t)(src) <<\
                    25) & 0x02000000U)
#define RADIO130NM_RF2G2_CH0__PDVGM__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 25) & ~0x02000000U)))
#define RADIO130NM_RF2G2_CH0__PDVGM__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x02000000U) | ((u_int32_t)(1) << 25)
#define RADIO130NM_RF2G2_CH0__PDVGM__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x02000000U) | ((u_int32_t)(0) << 25)

/* macros for field PDREGLO */
#define RADIO130NM_RF2G2_CH0__PDREGLO__SHIFT                                 26
#define RADIO130NM_RF2G2_CH0__PDREGLO__WIDTH                                  1
#define RADIO130NM_RF2G2_CH0__PDREGLO__MASK                         0x04000000U
#define RADIO130NM_RF2G2_CH0__PDREGLO__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x04000000U) >> 26)
#define RADIO130NM_RF2G2_CH0__PDREGLO__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 26) & 0x04000000U)
#define RADIO130NM_RF2G2_CH0__PDREGLO__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x04000000U) | (((u_int32_t)(src) <<\
                    26) & 0x04000000U)
#define RADIO130NM_RF2G2_CH0__PDREGLO__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 26) & ~0x04000000U)))
#define RADIO130NM_RF2G2_CH0__PDREGLO__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x04000000U) | ((u_int32_t)(1) << 26)
#define RADIO130NM_RF2G2_CH0__PDREGLO__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x04000000U) | ((u_int32_t)(0) << 26)

/* macros for field PDREGLNA */
#define RADIO130NM_RF2G2_CH0__PDREGLNA__SHIFT                                27
#define RADIO130NM_RF2G2_CH0__PDREGLNA__WIDTH                                 1
#define RADIO130NM_RF2G2_CH0__PDREGLNA__MASK                        0x08000000U
#define RADIO130NM_RF2G2_CH0__PDREGLNA__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x08000000U) >> 27)
#define RADIO130NM_RF2G2_CH0__PDREGLNA__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 27) & 0x08000000U)
#define RADIO130NM_RF2G2_CH0__PDREGLNA__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x08000000U) | (((u_int32_t)(src) <<\
                    27) & 0x08000000U)
#define RADIO130NM_RF2G2_CH0__PDREGLNA__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 27) & ~0x08000000U)))
#define RADIO130NM_RF2G2_CH0__PDREGLNA__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x08000000U) | ((u_int32_t)(1) << 27)
#define RADIO130NM_RF2G2_CH0__PDREGLNA__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x08000000U) | ((u_int32_t)(0) << 27)

/* macros for field PDPAOUT */
#define RADIO130NM_RF2G2_CH0__PDPAOUT__SHIFT                                 28
#define RADIO130NM_RF2G2_CH0__PDPAOUT__WIDTH                                  1
#define RADIO130NM_RF2G2_CH0__PDPAOUT__MASK                         0x10000000U
#define RADIO130NM_RF2G2_CH0__PDPAOUT__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x10000000U) >> 28)
#define RADIO130NM_RF2G2_CH0__PDPAOUT__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 28) & 0x10000000U)
#define RADIO130NM_RF2G2_CH0__PDPAOUT__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x10000000U) | (((u_int32_t)(src) <<\
                    28) & 0x10000000U)
#define RADIO130NM_RF2G2_CH0__PDPAOUT__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 28) & ~0x10000000U)))
#define RADIO130NM_RF2G2_CH0__PDPAOUT__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x10000000U) | ((u_int32_t)(1) << 28)
#define RADIO130NM_RF2G2_CH0__PDPAOUT__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x10000000U) | ((u_int32_t)(0) << 28)

/* macros for field PDPADRV */
#define RADIO130NM_RF2G2_CH0__PDPADRV__SHIFT                                 29
#define RADIO130NM_RF2G2_CH0__PDPADRV__WIDTH                                  1
#define RADIO130NM_RF2G2_CH0__PDPADRV__MASK                         0x20000000U
#define RADIO130NM_RF2G2_CH0__PDPADRV__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x20000000U) >> 29)
#define RADIO130NM_RF2G2_CH0__PDPADRV__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 29) & 0x20000000U)
#define RADIO130NM_RF2G2_CH0__PDPADRV__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x20000000U) | (((u_int32_t)(src) <<\
                    29) & 0x20000000U)
#define RADIO130NM_RF2G2_CH0__PDPADRV__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 29) & ~0x20000000U)))
#define RADIO130NM_RF2G2_CH0__PDPADRV__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x20000000U) | ((u_int32_t)(1) << 29)
#define RADIO130NM_RF2G2_CH0__PDPADRV__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x20000000U) | ((u_int32_t)(0) << 29)

/* macros for field PDDIV */
#define RADIO130NM_RF2G2_CH0__PDDIV__SHIFT                                   30
#define RADIO130NM_RF2G2_CH0__PDDIV__WIDTH                                    1
#define RADIO130NM_RF2G2_CH0__PDDIV__MASK                           0x40000000U
#define RADIO130NM_RF2G2_CH0__PDDIV__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x40000000U) >> 30)
#define RADIO130NM_RF2G2_CH0__PDDIV__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 30) & 0x40000000U)
#define RADIO130NM_RF2G2_CH0__PDDIV__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x40000000U) | (((u_int32_t)(src) <<\
                    30) & 0x40000000U)
#define RADIO130NM_RF2G2_CH0__PDDIV__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 30) & ~0x40000000U)))
#define RADIO130NM_RF2G2_CH0__PDDIV__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x40000000U) | ((u_int32_t)(1) << 30)
#define RADIO130NM_RF2G2_CH0__PDDIV__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x40000000U) | ((u_int32_t)(0) << 30)

/* macros for field PDLNA */
#define RADIO130NM_RF2G2_CH0__PDLNA__SHIFT                                   31
#define RADIO130NM_RF2G2_CH0__PDLNA__WIDTH                                    1
#define RADIO130NM_RF2G2_CH0__PDLNA__MASK                           0x80000000U
#define RADIO130NM_RF2G2_CH0__PDLNA__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x80000000U) >> 31)
#define RADIO130NM_RF2G2_CH0__PDLNA__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 31) & 0x80000000U)
#define RADIO130NM_RF2G2_CH0__PDLNA__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x80000000U) | (((u_int32_t)(src) <<\
                    31) & 0x80000000U)
#define RADIO130NM_RF2G2_CH0__PDLNA__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 31) & ~0x80000000U)))
#define RADIO130NM_RF2G2_CH0__PDLNA__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x80000000U) | ((u_int32_t)(1) << 31)
#define RADIO130NM_RF2G2_CH0__PDLNA__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x80000000U) | ((u_int32_t)(0) << 31)
#define RADIO130NM_RF2G2_CH0__TYPE                                    u_int32_t
#define RADIO130NM_RF2G2_CH0__READ                                  0xffffffffU
#define RADIO130NM_RF2G2_CH0__WRITE                                 0xffffffffU

#endif /* __RADIO130NM_RF2G2_CH0_MACRO__ */


/* macros for merlin2_0_radio_reg_map.RF2G2_CH0 */
#define INST_MERLIN2_0_RADIO_REG_MAP__RF2G2_CH0__NUM                          1

/* macros for BlueprintGlobalNameSpace::RADIO130NM_SYNTH1 */
#ifndef __RADIO130NM_SYNTH1_MACRO__
#define __RADIO130NM_SYNTH1_MACRO__

/* macros for field SEL_VCMONABUS */
#define RADIO130NM_SYNTH1__SEL_VCMONABUS__SHIFT                               0
#define RADIO130NM_SYNTH1__SEL_VCMONABUS__WIDTH                               3
#define RADIO130NM_SYNTH1__SEL_VCMONABUS__MASK                      0x00000007U
#define RADIO130NM_SYNTH1__SEL_VCMONABUS__READ(src) \
                    (u_int32_t)(src)\
                    & 0x00000007U
#define RADIO130NM_SYNTH1__SEL_VCMONABUS__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x00000007U)
#define RADIO130NM_SYNTH1__SEL_VCMONABUS__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000007U) | ((u_int32_t)(src) &\
                    0x00000007U)
#define RADIO130NM_SYNTH1__SEL_VCMONABUS__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00000007U)))

/* macros for field CON_IVCOBUF */
#define RADIO130NM_SYNTH1__CON_IVCOBUF__SHIFT                                 3
#define RADIO130NM_SYNTH1__CON_IVCOBUF__WIDTH                                 1
#define RADIO130NM_SYNTH1__CON_IVCOBUF__MASK                        0x00000008U
#define RADIO130NM_SYNTH1__CON_IVCOBUF__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000008U) >> 3)
#define RADIO130NM_SYNTH1__CON_IVCOBUF__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 3) & 0x00000008U)
#define RADIO130NM_SYNTH1__CON_IVCOBUF__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000008U) | (((u_int32_t)(src) <<\
                    3) & 0x00000008U)
#define RADIO130NM_SYNTH1__CON_IVCOBUF__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 3) & ~0x00000008U)))
#define RADIO130NM_SYNTH1__CON_IVCOBUF__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000008U) | ((u_int32_t)(1) << 3)
#define RADIO130NM_SYNTH1__CON_IVCOBUF__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000008U) | ((u_int32_t)(0) << 3)

/* macros for field CON_IVCOREG */
#define RADIO130NM_SYNTH1__CON_IVCOREG__SHIFT                                 4
#define RADIO130NM_SYNTH1__CON_IVCOREG__WIDTH                                 1
#define RADIO130NM_SYNTH1__CON_IVCOREG__MASK                        0x00000010U
#define RADIO130NM_SYNTH1__CON_IVCOREG__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000010U) >> 4)
#define RADIO130NM_SYNTH1__CON_IVCOREG__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 4) & 0x00000010U)
#define RADIO130NM_SYNTH1__CON_IVCOREG__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000010U) | (((u_int32_t)(src) <<\
                    4) & 0x00000010U)
#define RADIO130NM_SYNTH1__CON_IVCOREG__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 4) & ~0x00000010U)))
#define RADIO130NM_SYNTH1__CON_IVCOREG__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000010U) | ((u_int32_t)(1) << 4)
#define RADIO130NM_SYNTH1__CON_IVCOREG__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000010U) | ((u_int32_t)(0) << 4)

/* macros for field CON_VDDVCOREG */
#define RADIO130NM_SYNTH1__CON_VDDVCOREG__SHIFT                               5
#define RADIO130NM_SYNTH1__CON_VDDVCOREG__WIDTH                               1
#define RADIO130NM_SYNTH1__CON_VDDVCOREG__MASK                      0x00000020U
#define RADIO130NM_SYNTH1__CON_VDDVCOREG__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000020U) >> 5)
#define RADIO130NM_SYNTH1__CON_VDDVCOREG__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 5) & 0x00000020U)
#define RADIO130NM_SYNTH1__CON_VDDVCOREG__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000020U) | (((u_int32_t)(src) <<\
                    5) & 0x00000020U)
#define RADIO130NM_SYNTH1__CON_VDDVCOREG__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 5) & ~0x00000020U)))
#define RADIO130NM_SYNTH1__CON_VDDVCOREG__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000020U) | ((u_int32_t)(1) << 5)
#define RADIO130NM_SYNTH1__CON_VDDVCOREG__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000020U) | ((u_int32_t)(0) << 5)

/* macros for field MONITOR_SYNTHLOCKVCOK */
#define RADIO130NM_SYNTH1__MONITOR_SYNTHLOCKVCOK__SHIFT                       6
#define RADIO130NM_SYNTH1__MONITOR_SYNTHLOCKVCOK__WIDTH                       1
#define RADIO130NM_SYNTH1__MONITOR_SYNTHLOCKVCOK__MASK              0x00000040U
#define RADIO130NM_SYNTH1__MONITOR_SYNTHLOCKVCOK__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000040U) >> 6)
#define RADIO130NM_SYNTH1__MONITOR_SYNTHLOCKVCOK__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 6) & 0x00000040U)
#define RADIO130NM_SYNTH1__MONITOR_SYNTHLOCKVCOK__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000040U) | (((u_int32_t)(src) <<\
                    6) & 0x00000040U)
#define RADIO130NM_SYNTH1__MONITOR_SYNTHLOCKVCOK__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 6) & ~0x00000040U)))
#define RADIO130NM_SYNTH1__MONITOR_SYNTHLOCKVCOK__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000040U) | ((u_int32_t)(1) << 6)
#define RADIO130NM_SYNTH1__MONITOR_SYNTHLOCKVCOK__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000040U) | ((u_int32_t)(0) << 6)

/* macros for field MONITOR_VC2LOW */
#define RADIO130NM_SYNTH1__MONITOR_VC2LOW__SHIFT                              7
#define RADIO130NM_SYNTH1__MONITOR_VC2LOW__WIDTH                              1
#define RADIO130NM_SYNTH1__MONITOR_VC2LOW__MASK                     0x00000080U
#define RADIO130NM_SYNTH1__MONITOR_VC2LOW__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000080U) >> 7)
#define RADIO130NM_SYNTH1__MONITOR_VC2LOW__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 7) & 0x00000080U)
#define RADIO130NM_SYNTH1__MONITOR_VC2LOW__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000080U) | (((u_int32_t)(src) <<\
                    7) & 0x00000080U)
#define RADIO130NM_SYNTH1__MONITOR_VC2LOW__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 7) & ~0x00000080U)))
#define RADIO130NM_SYNTH1__MONITOR_VC2LOW__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000080U) | ((u_int32_t)(1) << 7)
#define RADIO130NM_SYNTH1__MONITOR_VC2LOW__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000080U) | ((u_int32_t)(0) << 7)

/* macros for field MONITOR_VC2HIGH */
#define RADIO130NM_SYNTH1__MONITOR_VC2HIGH__SHIFT                             8
#define RADIO130NM_SYNTH1__MONITOR_VC2HIGH__WIDTH                             1
#define RADIO130NM_SYNTH1__MONITOR_VC2HIGH__MASK                    0x00000100U
#define RADIO130NM_SYNTH1__MONITOR_VC2HIGH__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000100U) >> 8)
#define RADIO130NM_SYNTH1__MONITOR_VC2HIGH__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 8) & 0x00000100U)
#define RADIO130NM_SYNTH1__MONITOR_VC2HIGH__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000100U) | (((u_int32_t)(src) <<\
                    8) & 0x00000100U)
#define RADIO130NM_SYNTH1__MONITOR_VC2HIGH__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 8) & ~0x00000100U)))
#define RADIO130NM_SYNTH1__MONITOR_VC2HIGH__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000100U) | ((u_int32_t)(1) << 8)
#define RADIO130NM_SYNTH1__MONITOR_VC2HIGH__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000100U) | ((u_int32_t)(0) << 8)

/* macros for field MONITOR_FB_DIV2 */
#define RADIO130NM_SYNTH1__MONITOR_FB_DIV2__SHIFT                             9
#define RADIO130NM_SYNTH1__MONITOR_FB_DIV2__WIDTH                             1
#define RADIO130NM_SYNTH1__MONITOR_FB_DIV2__MASK                    0x00000200U
#define RADIO130NM_SYNTH1__MONITOR_FB_DIV2__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000200U) >> 9)
#define RADIO130NM_SYNTH1__MONITOR_FB_DIV2__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 9) & 0x00000200U)
#define RADIO130NM_SYNTH1__MONITOR_FB_DIV2__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000200U) | (((u_int32_t)(src) <<\
                    9) & 0x00000200U)
#define RADIO130NM_SYNTH1__MONITOR_FB_DIV2__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 9) & ~0x00000200U)))
#define RADIO130NM_SYNTH1__MONITOR_FB_DIV2__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000200U) | ((u_int32_t)(1) << 9)
#define RADIO130NM_SYNTH1__MONITOR_FB_DIV2__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000200U) | ((u_int32_t)(0) << 9)

/* macros for field MONITOR_REF */
#define RADIO130NM_SYNTH1__MONITOR_REF__SHIFT                                10
#define RADIO130NM_SYNTH1__MONITOR_REF__WIDTH                                 1
#define RADIO130NM_SYNTH1__MONITOR_REF__MASK                        0x00000400U
#define RADIO130NM_SYNTH1__MONITOR_REF__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000400U) >> 10)
#define RADIO130NM_SYNTH1__MONITOR_REF__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 10) & 0x00000400U)
#define RADIO130NM_SYNTH1__MONITOR_REF__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000400U) | (((u_int32_t)(src) <<\
                    10) & 0x00000400U)
#define RADIO130NM_SYNTH1__MONITOR_REF__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 10) & ~0x00000400U)))
#define RADIO130NM_SYNTH1__MONITOR_REF__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000400U) | ((u_int32_t)(1) << 10)
#define RADIO130NM_SYNTH1__MONITOR_REF__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000400U) | ((u_int32_t)(0) << 10)

/* macros for field MONITOR_FB */
#define RADIO130NM_SYNTH1__MONITOR_FB__SHIFT                                 11
#define RADIO130NM_SYNTH1__MONITOR_FB__WIDTH                                  1
#define RADIO130NM_SYNTH1__MONITOR_FB__MASK                         0x00000800U
#define RADIO130NM_SYNTH1__MONITOR_FB__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000800U) >> 11)
#define RADIO130NM_SYNTH1__MONITOR_FB__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 11) & 0x00000800U)
#define RADIO130NM_SYNTH1__MONITOR_FB__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000800U) | (((u_int32_t)(src) <<\
                    11) & 0x00000800U)
#define RADIO130NM_SYNTH1__MONITOR_FB__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 11) & ~0x00000800U)))
#define RADIO130NM_SYNTH1__MONITOR_FB__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000800U) | ((u_int32_t)(1) << 11)
#define RADIO130NM_SYNTH1__MONITOR_FB__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000800U) | ((u_int32_t)(0) << 11)

/* macros for field PWUP_LOMIX_PD */
#define RADIO130NM_SYNTH1__PWUP_LOMIX_PD__SHIFT                              12
#define RADIO130NM_SYNTH1__PWUP_LOMIX_PD__WIDTH                               1
#define RADIO130NM_SYNTH1__PWUP_LOMIX_PD__MASK                      0x00001000U
#define RADIO130NM_SYNTH1__PWUP_LOMIX_PD__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00001000U) >> 12)
#define RADIO130NM_SYNTH1__PWUP_LOMIX_PD__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 12) & 0x00001000U)
#define RADIO130NM_SYNTH1__PWUP_LOMIX_PD__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00001000U) | (((u_int32_t)(src) <<\
                    12) & 0x00001000U)
#define RADIO130NM_SYNTH1__PWUP_LOMIX_PD__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 12) & ~0x00001000U)))
#define RADIO130NM_SYNTH1__PWUP_LOMIX_PD__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00001000U) | ((u_int32_t)(1) << 12)
#define RADIO130NM_SYNTH1__PWUP_LOMIX_PD__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00001000U) | ((u_int32_t)(0) << 12)

/* macros for field PWUP_LODIV_PD */
#define RADIO130NM_SYNTH1__PWUP_LODIV_PD__SHIFT                              13
#define RADIO130NM_SYNTH1__PWUP_LODIV_PD__WIDTH                               1
#define RADIO130NM_SYNTH1__PWUP_LODIV_PD__MASK                      0x00002000U
#define RADIO130NM_SYNTH1__PWUP_LODIV_PD__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00002000U) >> 13)
#define RADIO130NM_SYNTH1__PWUP_LODIV_PD__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 13) & 0x00002000U)
#define RADIO130NM_SYNTH1__PWUP_LODIV_PD__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00002000U) | (((u_int32_t)(src) <<\
                    13) & 0x00002000U)
#define RADIO130NM_SYNTH1__PWUP_LODIV_PD__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 13) & ~0x00002000U)))
#define RADIO130NM_SYNTH1__PWUP_LODIV_PD__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00002000U) | ((u_int32_t)(1) << 13)
#define RADIO130NM_SYNTH1__PWUP_LODIV_PD__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00002000U) | ((u_int32_t)(0) << 13)

/* macros for field PWUP_LOBUF5G_PD */
#define RADIO130NM_SYNTH1__PWUP_LOBUF5G_PD__SHIFT                            14
#define RADIO130NM_SYNTH1__PWUP_LOBUF5G_PD__WIDTH                             1
#define RADIO130NM_SYNTH1__PWUP_LOBUF5G_PD__MASK                    0x00004000U
#define RADIO130NM_SYNTH1__PWUP_LOBUF5G_PD__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00004000U) >> 14)
#define RADIO130NM_SYNTH1__PWUP_LOBUF5G_PD__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 14) & 0x00004000U)
#define RADIO130NM_SYNTH1__PWUP_LOBUF5G_PD__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00004000U) | (((u_int32_t)(src) <<\
                    14) & 0x00004000U)
#define RADIO130NM_SYNTH1__PWUP_LOBUF5G_PD__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 14) & ~0x00004000U)))
#define RADIO130NM_SYNTH1__PWUP_LOBUF5G_PD__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00004000U) | ((u_int32_t)(1) << 14)
#define RADIO130NM_SYNTH1__PWUP_LOBUF5G_PD__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00004000U) | ((u_int32_t)(0) << 14)

/* macros for field PWUP_LOBUF2G_PD */
#define RADIO130NM_SYNTH1__PWUP_LOBUF2G_PD__SHIFT                            15
#define RADIO130NM_SYNTH1__PWUP_LOBUF2G_PD__WIDTH                             1
#define RADIO130NM_SYNTH1__PWUP_LOBUF2G_PD__MASK                    0x00008000U
#define RADIO130NM_SYNTH1__PWUP_LOBUF2G_PD__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00008000U) >> 15)
#define RADIO130NM_SYNTH1__PWUP_LOBUF2G_PD__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 15) & 0x00008000U)
#define RADIO130NM_SYNTH1__PWUP_LOBUF2G_PD__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00008000U) | (((u_int32_t)(src) <<\
                    15) & 0x00008000U)
#define RADIO130NM_SYNTH1__PWUP_LOBUF2G_PD__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 15) & ~0x00008000U)))
#define RADIO130NM_SYNTH1__PWUP_LOBUF2G_PD__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00008000U) | ((u_int32_t)(1) << 15)
#define RADIO130NM_SYNTH1__PWUP_LOBUF2G_PD__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00008000U) | ((u_int32_t)(0) << 15)

/* macros for field PWUP_VCOBUF_PD */
#define RADIO130NM_SYNTH1__PWUP_VCOBUF_PD__SHIFT                             16
#define RADIO130NM_SYNTH1__PWUP_VCOBUF_PD__WIDTH                              1
#define RADIO130NM_SYNTH1__PWUP_VCOBUF_PD__MASK                     0x00010000U
#define RADIO130NM_SYNTH1__PWUP_VCOBUF_PD__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00010000U) >> 16)
#define RADIO130NM_SYNTH1__PWUP_VCOBUF_PD__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 16) & 0x00010000U)
#define RADIO130NM_SYNTH1__PWUP_VCOBUF_PD__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00010000U) | (((u_int32_t)(src) <<\
                    16) & 0x00010000U)
#define RADIO130NM_SYNTH1__PWUP_VCOBUF_PD__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                 