// ------------------------------------------------------------------
// Copyright (c) 2004-2012 Qualcomm Atheros.  All rights reserved.
// $ATH_LICENSE_TARGET_C$
// ------------------------------------------------------------------
//===================================================================
// Author(s): ="Qualcomm Atheros"
//===================================================================



#ifndef _PEREGRINE_REG_MAP_ART_TEMPLATE_H_
#define _PEREGRINE_REG_MAP_ART_TEMPLATE_H_

static struct _Field _F[] =
{
/* Register name, field name                                   Address     MSB LSB */
{"SOC_RESET_CONTROL", "CE_RST"                               , 0x00004000, 18, 18},
{"SOC_RESET_CONTROL", "UART2_RST"                            , 0x00004000, 17, 17},
{"SOC_RESET_CONTROL", "CPU_INIT_RESET"                       , 0x00004000, 11, 11},
{"SOC_RESET_CONTROL", "RST_OUT"                              , 0x00004000, 9 , 9 },
{"SOC_RESET_CONTROL", "COLD_RST"                             , 0x00004000, 8 , 8 },
{"SOC_RESET_CONTROL", "CPU_WARM_RST"                         , 0x00004000, 6 , 6 },
{"SOC_RESET_CONTROL", "PCIE_RST_SHORT_OVRD"                  , 0x00004000, 2 , 2 },
{"SOC_RESET_CONTROL", "UART_RST"                             , 0x00004000, 1 , 1 },
{"SOC_RESET_CONTROL", "SI0_RST"                              , 0x00004000, 0 , 0 },
{"SOC_TCXO_DETECT", "PRESENT"                                , 0x00004004, 0 , 0 },
{"SOC_XTAL_TEST", "NOTCXODET"                                , 0x00004008, 0 , 0 },
{"SOC_CPU_CLOCK", "STANDARD"                                 , 0x00004020, 1 , 0 },
{"SOC_CLOCK_CONTROL", "RTC_CLK_AMBA"                         , 0x00004028, 6 , 6 },
{"SOC_CLOCK_CONTROL", "LF_CLK32"                             , 0x00004028, 2 , 2 },
{"SOC_CLOCK_CONTROL", "SI0_CLK"                              , 0x00004028, 0 , 0 },
{"SOC_WDT_CONTROL", "ACTION"                                 , 0x00004030, 2 , 0 },
{"SOC_WDT_STATUS", "INTERRUPT"                               , 0x00004034, 0 , 0 },
{"SOC_WDT", "TARGET"                                         , 0x00004038, 21, 0 },
{"SOC_WDT_COUNT", "VALUE"                                    , 0x0000403c, 21, 0 },
{"SOC_WDT_RESET", "VALUE"                                    , 0x00004040, 0 , 0 },
{"SOC_INT_STATUS", "THERM"                                   , 0x00004044, 15, 15},
{"SOC_INT_STATUS", "EFUSE_OVERWRITE"                         , 0x00004044, 14, 14},
{"SOC_INT_STATUS", "BTCOEX"                                  , 0x00004044, 13, 13},
{"SOC_INT_STATUS", "RTC_POWER"                               , 0x00004044, 12, 12},
{"SOC_INT_STATUS", "MAC"                                     , 0x00004044, 11, 11},
{"SOC_INT_STATUS", "RTC_ALARM"                               , 0x00004044, 10, 10},
{"SOC_INT_STATUS", "HF_TIMER"                                , 0x00004044, 9 , 9 },
{"SOC_INT_STATUS", "LF_TIMER3"                               , 0x00004044, 8 , 8 },
{"SOC_INT_STATUS", "LF_TIMER2"                               , 0x00004044, 7 , 7 },
{"SOC_INT_STATUS", "LF_TIMER1"                               , 0x00004044, 6 , 6 },
{"SOC_INT_STATUS", "LF_TIMER0"                               , 0x00004044, 5 , 5 },
{"SOC_INT_STATUS", "KEYPAD"                                  , 0x00004044, 4 , 4 },
{"SOC_INT_STATUS", "SI"                                      , 0x00004044, 3 , 3 },
{"SOC_INT_STATUS", "GPIO"                                    , 0x00004044, 2 , 2 },
{"SOC_INT_STATUS", "ERROR"                                   , 0x00004044, 1 , 1 },
{"SOC_INT_STATUS", "WDT_INT"                                 , 0x00004044, 0 , 0 },
{"SOC_LF_TIMER0", "TARGET"                                   , 0x00004048, 31, 0 },
{"SOC_LF_TIMER_COUNT0", "VALUE"                              , 0x0000404c, 31, 0 },
{"SOC_LF_TIMER_CONTROL0", "ENABLE"                           , 0x00004050, 2 , 2 },
{"SOC_LF_TIMER_CONTROL0", "AUTO_RESTART"                     , 0x00004050, 1 , 1 },
{"SOC_LF_TIMER_CONTROL0", "RESET"                            , 0x00004050, 0 , 0 },
{"SOC_LF_TIMER_STATUS0", "INTERRUPT"                         , 0x00004054, 0 , 0 },
{"SOC_LF_TIMER1", "TARGET"                                   , 0x00004058, 31, 0 },
{"SOC_LF_TIMER_COUNT1", "VALUE"                              , 0x0000405c, 31, 0 },
{"SOC_LF_TIMER_CONTROL1", "ENABLE"                           , 0x00004060, 2 , 2 },
{"SOC_LF_TIMER_CONTROL1", "AUTO_RESTART"                     , 0x00004060, 1 , 1 },
{"SOC_LF_TIMER_CONTROL1", "RESET"                            , 0x00004060, 0 , 0 },
{"SOC_LF_TIMER_STATUS1", "INTERRUPT"                         , 0x00004064, 0 , 0 },
{"SOC_LF_TIMER2", "TARGET"                                   , 0x00004068, 31, 0 },
{"SOC_LF_TIMER_COUNT2", "VALUE"                              , 0x0000406c, 31, 0 },
{"SOC_LF_TIMER_CONTROL2", "ENABLE"                           , 0x00004070, 2 , 2 },
{"SOC_LF_TIMER_CONTROL2", "AUTO_RESTART"                     , 0x00004070, 1 , 1 },
{"SOC_LF_TIMER_CONTROL2", "RESET"                            , 0x00004070, 0 , 0 },
{"SOC_LF_TIMER_STATUS2", "INTERRUPT"                         , 0x00004074, 0 , 0 },
{"SOC_LF_TIMER3", "TARGET"                                   , 0x00004078, 31, 0 },
{"SOC_LF_TIMER_COUNT3", "VALUE"                              , 0x0000407c, 31, 0 },
{"SOC_LF_TIMER_CONTROL3", "ENABLE"                           , 0x00004080, 2 , 2 },
{"SOC_LF_TIMER_CONTROL3", "AUTO_RESTART"                     , 0x00004080, 1 , 1 },
{"SOC_LF_TIMER_CONTROL3", "RESET"                            , 0x00004080, 0 , 0 },
{"SOC_LF_TIMER_STATUS3", "INTERRUPT"                         , 0x00004084, 0 , 0 },
{"SOC_HF_TIMER", "TARGET"                                    , 0x00004088, 31, 12},
{"SOC_HF_TIMER_COUNT", "VALUE"                               , 0x0000408c, 31, 12},
{"SOC_HF_LF_COUNT", "VALUE"                                  , 0x00004090, 31, 0 },
{"SOC_HF_TIMER_CONTROL", "ENABLE"                            , 0x00004094, 3 , 3 },
{"SOC_HF_TIMER_CONTROL", "ON"                                , 0x00004094, 2 , 2 },
{"SOC_HF_TIMER_CONTROL", "AUTO_RESTART"                      , 0x00004094, 1 , 1 },
{"SOC_HF_TIMER_CONTROL", "RESET"                             , 0x00004094, 0 , 0 },
{"SOC_HF_TIMER_STATUS", "INTERRUPT"                          , 0x00004098, 0 , 0 },
{"SOC_RTC_CONTROL", "ENABLE"                                 , 0x0000409c, 2 , 2 },
{"SOC_RTC_CONTROL", "LOAD_RTC"                               , 0x0000409c, 1 , 1 },
{"SOC_RTC_CONTROL", "LOAD_ALARM"                             , 0x0000409c, 0 , 0 },
{"SOC_RTC_TIME", "WEEK_DAY"                                  , 0x000040a0, 26, 24},
{"SOC_RTC_TIME", "HOUR"                                      , 0x000040a0, 21, 16},
{"SOC_RTC_TIME", "MINUTE"                                    , 0x000040a0, 14, 8 },
{"SOC_RTC_TIME", "SECOND"                                    , 0x000040a0, 6 , 0 },
{"SOC_RTC_DATE", "YEAR"                                      , 0x000040a4, 23, 16},
{"SOC_RTC_DATE", "MONTH"                                     , 0x000040a4, 12, 8 },
{"SOC_RTC_DATE", "MONTH_DAY"                                 , 0x000040a4, 5 , 0 },
{"SOC_RTC_SET_TIME", "WEEK_DAY"                              , 0x000040a8, 26, 24},
{"SOC_RTC_SET_TIME", "HOUR"                                  , 0x000040a8, 21, 16},
{"SOC_RTC_SET_TIME", "MINUTE"                                , 0x000040a8, 14, 8 },
{"SOC_RTC_SET_TIME", "SECOND"                                , 0x000040a8, 6 , 0 },
{"SOC_RTC_SET_DATE", "YEAR"                                  , 0x000040ac, 23, 16},
{"SOC_RTC_SET_DATE", "MONTH"                                 , 0x000040ac, 12, 8 },
{"SOC_RTC_SET_DATE", "MONTH_DAY"                             , 0x000040ac, 5 , 0 },
{"SOC_RTC_SET_ALARM", "HOUR"                                 , 0x000040b0, 21, 16},
{"SOC_RTC_SET_ALARM", "MINUTE"                               , 0x000040b0, 14, 8 },
{"SOC_RTC_SET_ALARM", "SECOND"                               , 0x000040b0, 6 , 0 },
{"SOC_RTC_CONFIG", "BCD"                                     , 0x000040b4, 2 , 2 },
{"SOC_RTC_CONFIG", "TWELVE_HOUR"                             , 0x000040b4, 1 , 1 },
{"SOC_RTC_CONFIG", "DSE"                                     , 0x000040b4, 0 , 0 },
{"SOC_RTC_ALARM_STATUS", "ENABLE"                            , 0x000040b8, 1 , 1 },
{"SOC_RTC_ALARM_STATUS", "INTERRUPT"                         , 0x000040b8, 0 , 0 },
{"SOC_UART_WAKEUP", "ENABLE"                                 , 0x000040bc, 0 , 0 },
{"SOC_RESET_CAUSE", "LAST"                                   , 0x000040c0, 2 , 0 },
{"SOC_SYSTEM_SLEEP", "MAC_IF"                                , 0x000040c4, 2 , 2 },
{"SOC_SYSTEM_SLEEP", "LIGHT"                                 , 0x000040c4, 1 , 1 },
{"SOC_SYSTEM_SLEEP", "DISABLE"                               , 0x000040c4, 0 , 0 },
{"SOC_INT_STATUS1", "MAC_4"                                  , 0x000040c8, 3 , 3 },
{"SOC_INT_STATUS1", "MAC_3"                                  , 0x000040c8, 2 , 2 },
{"SOC_INT_STATUS1", "MAC_2"                                  , 0x000040c8, 1 , 1 },
{"SOC_INT_STATUS1", "MAC_1"                                  , 0x000040c8, 0 , 0 },
{"SOC_INT_SLEEP_MASK", "BITMAP"                              , 0x000040cc, 31, 0 },
{"SOC_LPO_CAL_TIME", "LENGTH"                                , 0x000040d4, 13, 0 },
{"SOC_LPO_INIT_DIVIDEND_INT", "VALUE"                        , 0x000040d8, 23, 0 },
{"SOC_LPO_INIT_DIVIDEND_FRACTION", "VALUE"                   , 0x000040dc, 10, 0 },
{"SOC_LPO_CAL", "ENABLE"                                     , 0x000040e0, 20, 20},
{"SOC_LPO_CAL", "COUNT"                                      , 0x000040e0, 19, 0 },
{"SOC_LPO_CAL_TEST_CONTROL", "ENABLE"                        , 0x000040e4, 16, 16},
{"SOC_LPO_CAL_TEST_CONTROL", "RTC_CYCLES"                    , 0x000040e4, 15, 0 },
{"SOC_LPO_CAL_TEST_STATUS", "READY"                          , 0x000040e8, 16, 16},
{"SOC_LPO_CAL_TEST_STATUS", "COUNT"                          , 0x000040e8, 15, 0 },
{"SOC_CHIP_ID", "VERSION"                                    , 0x000040ec, 31, 18},
{"SOC_CHIP_ID", "TYPE"                                       , 0x000040ec, 17, 12},
{"SOC_CHIP_ID", "REVISION"                                   , 0x000040ec, 11, 8 },
{"SOC_CHIP_ID", "OLD_VERSION"                                , 0x000040ec, 7 , 0 },
{"SOC_POWER_REG", "SWREG_VS_EN"                              , 0x0000410c, 17, 17},
{"SOC_POWER_REG", "DISCON_MODE_EN"                           , 0x0000410c, 16, 16},
{"SOC_POWER_REG", "DEEP_SLEEP_EN"                            , 0x0000410c, 15, 15},
{"SOC_POWER_REG", "DEBUG_EN"                                 , 0x0000410c, 14, 14},
{"SOC_POWER_REG", "WLAN_BB_PWD_EN"                           , 0x0000410c, 13, 13},
{"SOC_POWER_REG", "WLAN_MAC_PWD_EN"                          , 0x0000410c, 12, 12},
{"SOC_POWER_REG", "CPU_INT_ENABLE"                           , 0x0000410c, 7 , 7 },
{"SOC_POWER_REG", "RADIO_PWD_EN"                             , 0x0000410c, 4 , 4 },
{"SOC_POWER_REG", "WLAN_PWD_EN"                              , 0x0000410c, 1 , 1 },
{"SOC_POWER_REG", "POWER_EN"                                 , 0x0000410c, 0 , 0 },
{"SOC_CORE_CLK_CTRL", "DIV"                                  , 0x00004110, 2 , 0 },
{"SOC_GPIO_WAKEUP_CONTROL", "ENABLE"                         , 0x00004114, 0 , 0 },
{"SLEEP_RETENTION", "GREEN_SAVE"                             , 0x00004214, 10, 10},
{"SLEEP_RETENTION", "TIME"                                   , 0x00004214, 9 , 2 },
{"SLEEP_RETENTION", "MODE"                                   , 0x00004214, 1 , 1 },
{"SLEEP_RETENTION", "ENABLE"                                 , 0x00004214, 0 , 0 },
{"LP_PERF_COUNTER", "EN"                                     , 0x00004284, 0 , 0 },
{"LP_PERF_LIGHT_SLEEP", "CNT"                                , 0x00004288, 31, 0 },
{"LP_PERF_DEEP_SLEEP", "CNT"                                 , 0x0000428c, 31, 0 },
{"LP_PERF_ON", "CNT"                                         , 0x00004290, 31, 0 },
{"CHIP_MODE", "BIT"                                          , 0x000042a8, 1 , 0 },
{"CLK_REQ_FALL_EDGE", "EN"                                   , 0x000042ac, 31, 31},
{"CLK_REQ_FALL_EDGE", "DELAY"                                , 0x000042ac, 7 , 0 },
{"OTP", "LDO25_EN"                                           , 0x000042b0, 1 , 1 },
{"OTP", "VDD12_EN"                                           , 0x000042b0, 0 , 0 },
{"OTP_STATUS", "LDO25_EN_READY"                              , 0x000042b4, 1 , 1 },
{"OTP_STATUS", "VDD12_EN_READY"                              , 0x000042b4, 0 , 0 },
{"PMU", "REG_WAKEUP_TIME_SEL"                                , 0x000042b8, 1 , 0 },
{"PMU_CONFIG", "VALUE"                                       , 0x000042bc, 4 , 0 },
{"PMU_PAREG", "LVL_CTR"                                      , 0x000042c0, 2 , 0 },
{"PMU_BYPASS", "SWREG"                                       , 0x000042c4, 1 , 1 },
{"PMU_BYPASS", "PAREG"                                       , 0x000042c4, 0 , 0 },
{"THERM_CTRL1", "CHAIN"                                      , 0x000042dc, 18, 17},
{"THERM_CTRL1", "BYPASS"                                     , 0x000042dc, 16, 16},
{"THERM_CTRL1", "WIDTH_ARBITOR"                              , 0x000042dc, 15, 12},
{"THERM_CTRL1", "WIDTH"                                      , 0x000042dc, 11, 5 },
{"THERM_CTRL1", "TYPE"                                       , 0x000042dc, 4 , 3 },
{"THERM_CTRL1", "MEASURE"                                    , 0x000042dc, 2 , 2 },
{"THERM_CTRL1", "INT_EN"                                     , 0x000042dc, 1 , 1 },
{"THERM_CTRL1", "INT_STATUS"                                 , 0x000042dc, 0 , 0 },
{"THERM_CTRL2", "ADC_OFF"                                    , 0x000042e0, 25, 25},
{"THERM_CTRL2", "ADC_ON"                                     , 0x000042e0, 24, 24},
{"THERM_CTRL2", "SAMPLE"                                     , 0x000042e0, 23, 16},
{"THERM_CTRL2", "HIGH"                                       , 0x000042e0, 15, 8 },
{"THERM_CTRL2", "LOW"                                        , 0x000042e0, 7 , 0 },
{"THERM_CTRL3", "ADC_GAIN"                                   , 0x000042e4, 16, 8 },
{"THERM_CTRL3", "ADC_OFFSET"                                 , 0x000042e4, 7 , 0 },
{"LISTEN_MODE1", "TIMER_CLEAR"                               , 0x000042e8, 19, 19},
{"LISTEN_MODE1", "TIMER_THRESH_WAKE"                         , 0x000042e8, 18, 3 },
{"LISTEN_MODE1", "TIMER_OVERFLOW_WAKE"                       , 0x000042e8, 2 , 2 },
{"LISTEN_MODE1", "CLOCK_GATE"                                , 0x000042e8, 1 , 1 },
{"LISTEN_MODE1", "ENABLE"                                    , 0x000042e8, 0 , 0 },
{"LISTEN_MODE2", "TIMER_TRIGGER_WAKE"                        , 0x000042ec, 15, 0 },
{"CPU_PLL_CONFIG", "RANGE"                                   , 0x000042f0, 28, 28},
{"CPU_PLL_CONFIG", "FRAC"                                    , 0x000042f0, 25, 20},
{"CPU_PLL_CONFIG", "INT"                                     , 0x000042f0, 17, 12},
{"CPU_PLL_CONFIG", "OUTDIV"                                  , 0x000042f0, 9 , 7 },
{"CPU_PLL_CONFIG", "PLLPWD"                                  , 0x000042f0, 6 , 6 },
{"CPU_PLL_CONFIG", "REFDIV"                                  , 0x000042f0, 4 , 0 },
{"BB_PLL_CONFIG", "FRAC"                                     , 0x000042f4, 17, 0 },
{"RTC_SLEEP_COUNT", "THRESHOLD"                              , 0x000042f8, 5 , 0 },
{"ENTERPRISE_CONFIG_OVRD", "TPC_LOWER_PERFORMANCE"           , 0x000042fc, 12, 12},
{"ENTERPRISE_CONFIG_OVRD", "SWCOM_IDLE_MODE"                 , 0x000042fc, 11, 11},
{"ENTERPRISE_CONFIG_OVRD", "STBC_DISABLE"                    , 0x000042fc, 10, 10},
{"ENTERPRISE_CONFIG_OVRD", "LDPC_DISABLE"                    , 0x000042fc, 9 , 9 },
{"ENTERPRISE_CONFIG_OVRD", "GREEN_TX_DISABLE"                , 0x000042fc, 8 , 8 },
{"ENTERPRISE_CONFIG_OVRD", "DUAL_BAND_DISABLE"               , 0x000042fc, 7 , 7 },
{"ENTERPRISE_CONFIG_OVRD", "CHAIN1_DISABLE"                  , 0x000042fc, 6 , 6 },
{"ENTERPRISE_CONFIG_OVRD", "CH_5MHZ_DISABLE"                 , 0x000042fc, 5 , 5 },
{"ENTERPRISE_CONFIG_OVRD", "CH_10MHZ_DISABLE"                , 0x000042fc, 4 , 4 },
{"ENTERPRISE_CONFIG_OVRD", "TXBF_DISABLE"                    , 0x000042fc, 3 , 3 },
{"ENTERPRISE_CONFIG_OVRD", "MIN_PKT_SIZE_DISABLE"            , 0x000042fc, 2 , 2 },
{"ENTERPRISE_CONFIG_OVRD", "LOOPBACK_DISABLE"                , 0x000042fc, 1 , 1 },
{"ENTERPRISE_CONFIG_OVRD", "LOCATION_DISABLE"                , 0x000042fc, 0 , 0 },
{"RTC_DEBUG_BUS", "SEL"                                      , 0x00004300, 0 , 0 },
{"RTC_EXT_CLK_BUF", "EN"                                     , 0x00004304, 0 , 0 },
{"RTC_CAL_DIV_DEFAULT", "V"                                  , 0x00004308, 17, 0 },
{"OTP_LDO", "LVL"                                            , 0x0000430c, 1 , 0 },
{"SRIF_CLOCK", "CORE_DIV"                                    , 0x00004310, 1 , 1 },
{"SRIF_CLOCK", "SEL"                                         , 0x00004310, 0 , 0 },
{"SRIF_CLOCK_GATING", "PCIE_CLK_EN"                          , 0x00004314, 1 , 1 },
{"SRIF_CLOCK_GATING", "CORE_CLK_EN"                          , 0x00004314, 0 , 0 },
{"RTC_SPARE0", "BITS"                                        , 0x00004318, 31, 0 },
{"RTC_SPARE1", "BITS"                                        , 0x0000431c, 31, 0 },
{"WLAN_RESET_CONTROL", "MCI_RESET"                           , 0x00005000, 7 , 7 },
{"WLAN_RESET_CONTROL", "RADIO_SRESET"                        , 0x00005000, 6 , 6 },
{"WLAN_RESET_CONTROL", "BB_COLD_RST"                         , 0x00005000, 5 , 5 },
{"WLAN_RESET_CONTROL", "BB_WARM_RST"                         , 0x00005000, 4 , 4 },
{"WLAN_RESET_CONTROL", "COLD_RST"                            , 0x00005000, 3 , 3 },
{"WLAN_RESET_CONTROL", "WARM_RST"                            , 0x00005000, 2 , 2 },
{"WLAN_RESET_CONTROL", "MAC_COLD_RST"                        , 0x00005000, 1 , 1 },
{"WLAN_RESET_CONTROL", "MAC_WARM_RST"                        , 0x00005000, 0 , 0 },
{"WLAN_XTAL_CONTROL", "TCXO"                                 , 0x00005004, 0 , 0 },
{"WLAN_REG_CONTROL0", "SWREG_BITS"                           , 0x00005008, 31, 0 },
{"WLAN_REG_CONTROL1", "OTPREG_LVL"                           , 0x0000500c, 2 , 1 },
{"WLAN_REG_CONTROL1", "SWREG_PROGRAM"                        , 0x0000500c, 0 , 0 },
{"WLAN_QUADRATURE", "ADC"                                    , 0x00005010, 7 , 4 },
{"WLAN_QUADRATURE", "DAC"                                    , 0x00005010, 2 , 0 },
{"WLAN_PLL_CONTROL", "DIG_TEST_CLK"                          , 0x00005014, 20, 20},
{"WLAN_PLL_CONTROL", "MAC_OVERRIDE"                          , 0x00005014, 19, 19},
{"WLAN_PLL_CONTROL", "NOPWD"                                 , 0x00005014, 18, 18},
{"WLAN_PLL_CONTROL", "UPDATING"                              , 0x00005014, 17, 17},
{"WLAN_PLL_CONTROL", "BYPASS"                                , 0x00005014, 16, 16},
{"WLAN_PLL_CONTROL", "CLK_SEL"                               , 0x00005014, 15, 14},
{"WLAN_PLL_CONTROL", "REFDIV"                                , 0x00005014, 13, 10},
{"WLAN_PLL_CONTROL", "DIV"                                   , 0x00005014, 9 , 0 },
{"WLAN_PLL_SETTLE", "TIME"                                   , 0x00005018, 10, 0 },
{"WLAN_XTAL_SETTLE", "TIME"                                  , 0x0000501c, 6 , 0 },
{"WLAN_CLOCK_OUT", "DELAY"                                   , 0x00005020, 6 , 4 },
{"WLAN_CLOCK_OUT", "SELECT"                                  , 0x00005020, 3 , 0 },
{"WLAN_BIAS_OVERRIDE", "ON"                                  , 0x00005024, 0 , 0 },
{"WLAN_RESET_CAUSE", "LAST"                                  , 0x00005028, 2 , 0 },
{"WLAN_SYSTEM_SLEEP", "MAC_IF"                               , 0x0000502c, 2 , 2 },
{"WLAN_SYSTEM_SLEEP", "LIGHT"                                , 0x0000502c, 1 , 1 },
{"WLAN_SYSTEM_SLEEP", "DISABLE"                              , 0x0000502c, 0 , 0 },
{"WLAN_MAC_SLEEP_CONTROL", "HSEL_WMAC_ENABLE"                , 0x00005030, 2 , 2 },
{"WLAN_MAC_SLEEP_CONTROL", "RESERVED"                        , 0x00005030, 1 , 1 },
{"WLAN_MAC_SLEEP_CONTROL", "ENABLE"                          , 0x00005030, 0 , 0 },
{"WLAN_KEEP_AWAKE", "MAC_CLK_REQ_COUNT"                      , 0x00005034, 15, 8 },
{"WLAN_KEEP_AWAKE", "COUNT"                                  , 0x00005034, 7 , 0 },
{"WLAN_DERIVED_RTC_CLK", "EXTERNAL_DETECT_EN"                , 0x00005038, 20, 20},
{"WLAN_DERIVED_RTC_CLK", "EXTERNAL_DETECT"                   , 0x00005038, 18, 18},
{"WLAN_DERIVED_RTC_CLK", "PERIOD"                            , 0x00005038, 15, 1 },
{"MAC_PCU_SLP32_MODE", "TSF2_WRITE_STATUS"                   , 0x0000503c, 24, 24},
{"MAC_PCU_SLP32_MODE", "FORCE_BIAS_BLOCK_ON"                 , 0x0000503c, 23, 23},
{"MAC_PCU_SLP32_MODE", "DISABLE_32KHZ"                       , 0x0000503c, 22, 22},
{"MAC_PCU_SLP32_MODE", "TSF_WRITE_STATUS"                    , 0x0000503c, 21, 21},
{"MAC_PCU_SLP32_MODE", "ENABLE"                              , 0x0000503c, 20, 20},
{"MAC_PCU_SLP32_MODE", "HALF_CLK_LATENCY"                    , 0x0000503c, 19, 0 },
{"MAC_PCU_SLP32_WAKE", "XTL_TIME"                            , 0x00005040, 15, 0 },
{"MAC_PCU_SLP32_INC", "TSF_INC"                              , 0x00005044, 19, 0 },
{"MAC_PCU_SLP_MIB1", "SLEEP_CNT"                             , 0x00005048, 31, 0 },
{"MAC_PCU_SLP_MIB2", "CYCLE_CNT"                             , 0x0000504c, 31, 0 },
{"MAC_PCU_SLP_MIB3", "PENDING"                               , 0x00005050, 1 , 1 },
{"MAC_PCU_SLP_MIB3", "CLR_CNT"                               , 0x00005050, 0 , 0 },
{"MAC_PCU_TSF_L32", "VALUE"                                  , 0x00005054, 31, 0 },
{"MAC_PCU_TSF_U32", "VALUE"                                  , 0x00005058, 31, 0 },
{"MAC_PCU_WBTIMER_0", "ENABLE"                               , 0x0000505c, 0 , 0 },
{"MAC_PCU_WBTIMER_1", "VALUE"                                , 0x00005060, 31, 0 },
{"MAC_PCU_GENERIC_TIMERS[0]", "DATA"                         , 0x00005064, 31, 0 },
{"MAC_PCU_GENERIC_TIMERS[1]", "DATA"                         , 0x00005068, 31, 0 },
{"MAC_PCU_GENERIC_TIMERS[2]", "DATA"                         , 0x0000506c, 31, 0 },
{"MAC_PCU_GENERIC_TIMERS[3]", "DATA"                         , 0x00005070, 31, 0 },
{"MAC_PCU_GENERIC_TIMERS[4]", "DATA"                         , 0x00005074, 31, 0 },
{"MAC_PCU_GENERIC_TIMERS[5]", "DATA"                         , 0x00005078, 31, 0 },
{"MAC_PCU_GENERIC_TIMERS[6]", "DATA"                         , 0x0000507c, 31, 0 },
{"MAC_PCU_GENERIC_TIMERS[7]", "DATA"                         , 0x00005080, 31, 0 },
{"MAC_PCU_GENERIC_TIMERS[8]", "DATA"                         , 0x00005084, 31, 0 },
{"MAC_PCU_GENERIC_TIMERS[9]", "DATA"                         , 0x00005088, 31, 0 },
{"MAC_PCU_GENERIC_TIMERS[10]", "DATA"                        , 0x0000508c, 31, 0 },
{"MAC_PCU_GENERIC_TIMERS[11]", "DATA"                        , 0x00005090, 31, 0 },
{"MAC_PCU_GENERIC_TIMERS[12]", "DATA"                        , 0x00005094, 31, 0 },
{"MAC_PCU_GENERIC_TIMERS[13]", "DATA"                        , 0x00005098, 31, 0 },
{"MAC_PCU_GENERIC_TIMERS[14]", "DATA"                        , 0x0000509c, 31, 0 },
{"MAC_PCU_GENERIC_TIMERS[15]", "DATA"                        , 0x000050a0, 31, 0 },
{"MAC_PCU_GENERIC_TIMERS_MODE", "THRESH"                     , 0x000050bc, 31, 12},
{"MAC_PCU_GENERIC_TIMERS_MODE", "OVERFLOW_INDEX"             , 0x000050bc, 10, 8 },
{"MAC_PCU_GENERIC_TIMERS_MODE", "ENABLE"                     , 0x000050bc, 7 , 0 },
{"MAC_PCU_SLP1", "CAB_TIMEOUT"                               , 0x000050c0, 31, 21},
{"MAC_PCU_SLP1", "BUG_59985_FIX_ENABLE"                      , 0x000050c0, 20, 20},
{"MAC_PCU_SLP1", "ASSUME_DTIM"                               , 0x000050c0, 19, 19},
{"MAC_PCU_SLP1", "CAB_TIMEOUT_EXT"                           , 0x000050c0, 4 , 0 },
{"MAC_PCU_SLP2", "BEACON_TIMEOUT"                            , 0x000050c4, 31, 21},
{"MAC_PCU_SLP2", "BEACON_TIMEOUT_EXT"                        , 0x000050c4, 4 , 0 },
{"MAC_PCU_SLP3", "CAB_AWAKE_ENABLE"                          , 0x000050c8, 16, 16},
{"MAC_PCU_SLP3", "CAB_AWAKE_DUR"                             , 0x000050c8, 15, 0 },
{"MAC_PCU_SLP4", "ASSUME_DTIM2"                              , 0x000050cc, 31, 31},
{"MAC_PCU_SLP4", "CAB2_TIMEOUT"                              , 0x000050cc, 30, 16},
{"MAC_PCU_SLP4", "BEACON2_TIMEOUT"                           , 0x000050cc, 15, 0 },
{"MAC_PCU_RESET_TSF", "ONE_SHOT2"                            , 0x000050d0, 25, 25},
{"MAC_PCU_RESET_TSF", "ONE_SHOT"                             , 0x000050d0, 24, 24},
{"MAC_PCU_TSF2_L32", "VALUE"                                 , 0x000050d4, 31, 0 },
{"MAC_PCU_TSF2_U32", "VALUE"                                 , 0x000050d8, 31, 0 },
{"MAC_PCU_GENERIC_TIMERS2[0]", "DATA"                        , 0x000050dc, 31, 0 },
{"MAC_PCU_GENERIC_TIMERS2[1]", "DATA"                        , 0x000050e0, 31, 0 },
{"MAC_PCU_GENERIC_TIMERS2[2]", "DATA"                        , 0x000050e4, 31, 0 },
{"MAC_PCU_GENERIC_TIMERS2[3]", "DATA"                        , 0x000050e8, 31, 0 },
{"MAC_PCU_GENERIC_TIMERS2[4]", "DATA"                        , 0x000050ec, 31, 0 },
{"MAC_PCU_GENERIC_TIMERS2[5]", "DATA"                        , 0x000050f0, 31, 0 },
{"MAC_PCU_GENERIC_TIMERS2[6]", "DATA"                        , 0x000050f4, 31, 0 },
{"MAC_PCU_GENERIC_TIMERS2[7]", "DATA"                        , 0x000050f8, 31, 0 },
{"MAC_PCU_GENERIC_TIMERS2[8]", "DATA"                        , 0x000050fc, 31, 0 },
{"MAC_PCU_GENERIC_TIMERS2[9]", "DATA"                        , 0x00005100, 31, 0 },
{"MAC_PCU_GENERIC_TIMERS2[10]", "DATA"                       , 0x00005104, 31, 0 },
{"MAC_PCU_GENERIC_TIMERS2[11]", "DATA"                       , 0x00005108, 31, 0 },
{"MAC_PCU_GENERIC_TIMERS2[12]", "DATA"                       , 0x0000510c, 31, 0 },
{"MAC_PCU_GENERIC_TIMERS2[13]", "DATA"                       , 0x00005110, 31, 0 },
{"MAC_PCU_GENERIC_TIMERS2[14]", "DATA"                       , 0x00005114, 31, 0 },
{"MAC_PCU_GENERIC_TIMERS2[15]", "DATA"                       , 0x00005118, 31, 0 },
{"MAC_PCU_GENERIC_TIMERS_MODE2", "OVERFLOW_INDEX2"           , 0x00005134, 15, 12},
{"MAC_PCU_GENERIC_TIMERS_MODE2", "OVERFLOW_INDEX"            , 0x00005134, 11, 8 },
{"MAC_PCU_GENERIC_TIMERS_MODE2", "ENABLE"                    , 0x00005134, 7 , 0 },
{"MAC_PCU_TSF_THRESHOLD", "VALUE"                            , 0x00005144, 15, 0 },
{"WLAN_HT", "MODE"                                           , 0x00005148, 0 , 0 },
{"MAC_PCU_GENERIC_TIMERS_TSF_SEL", "VALUE"                   , 0x00005150, 15, 0 },
{"MAC_PCU_BMISS_TIMEOUT", "ENABLE"                           , 0x00005154, 24, 24},
{"MAC_PCU_BMISS_TIMEOUT", "VALUE"                            , 0x00005154, 23, 0 },
{"MAC_PCU_BMISS2_TIMEOUT", "ENABLE"                          , 0x00005158, 24, 24},
{"MAC_PCU_BMISS2_TIMEOUT", "VALUE"                           , 0x00005158, 23, 0 },
{"UNIFIED_MAC_REVID", "VALUE"                                , 0x00005160, 31, 0 },
{"RTC_SYNC_RESET", "RESET_L"                                 , 0x00005240, 0 , 0 },
{"RTC_SYNC_STATUS", "PLL_CHANGING"                           , 0x00005244, 5 , 5 },
{"RTC_SYNC_STATUS", "WRESET"                                 , 0x00005244, 4 , 4 },
{"RTC_SYNC_STATUS", "WAKEUP_STATE"                           , 0x00005244, 3 , 3 },
{"RTC_SYNC_STATUS", "SLEEP_STATE"                            , 0x00005244, 2 , 2 },
{"RTC_SYNC_STATUS", "ON_STATE"                               , 0x00005244, 1 , 1 },
{"RTC_SYNC_STATUS", "SHUTDOWN_STATE"                         , 0x00005244, 0 , 0 },
{"RTC_SYNC_DERIVED", "FORCE_LPO_PWD"                         , 0x00005248, 3 , 3 },
{"RTC_SYNC_DERIVED", "FORCE_SWREG_PWD"                       , 0x00005248, 2 , 2 },
{"RTC_SYNC_DERIVED", "FORCE"                                 , 0x00005248, 1 , 1 },
{"RTC_SYNC_DERIVED", "BYPASS"                                , 0x00005248, 0 , 0 },
{"RTC_SYNC_FORCE_WAKE", "LEGACY_MODE"                        , 0x0000524c, 3 , 3 },
{"RTC_SYNC_FORCE_WAKE", "STATE"                              , 0x0000524c, 2 , 2 },
{"RTC_SYNC_FORCE_WAKE", "INTR"                               , 0x0000524c, 1 , 1 },
{"RTC_SYNC_FORCE_WAKE", "ENABLE"                             , 0x0000524c, 0 , 0 },
{"RTC_SYNC_INTR_CAUSE", "PLL_CHANGING"                       , 0x00005250, 5 , 5 },
{"RTC_SYNC_INTR_CAUSE", "SLEEP_ACCESS"                       , 0x00005250, 4 , 4 },
{"RTC_SYNC_INTR_CAUSE", "WAKEUP_STATE"                       , 0x00005250, 3 , 3 },
{"RTC_SYNC_INTR_CAUSE", "SLEEP_STATE"                        , 0x00005250, 2 , 2 },
{"RTC_SYNC_INTR_CAUSE", "ON_STATE"                           , 0x00005250, 1 , 1 },
{"RTC_SYNC_INTR_CAUSE", "SHUTDOWN_STATE"                     , 0x00005250, 0 , 0 },
{"RTC_SYNC_INTR_ENABLE", "PLL_CHANGING"                      , 0x00005254, 5 , 5 },
{"RTC_SYNC_INTR_ENABLE", "SLEEP_ACCESS"                      , 0x00005254, 4 , 4 },
{"RTC_SYNC_INTR_ENABLE", "WAKEUP_STATE"                      , 0x00005254, 3 , 3 },
{"RTC_SYNC_INTR_ENABLE", "SLEEP_STATE"                       , 0x00005254, 2 , 2 },
{"RTC_SYNC_INTR_ENABLE", "ON_STATE"                          , 0x00005254, 1 , 1 },
{"RTC_SYNC_INTR_ENABLE", "SHUTDOWN_STATE"                    , 0x00005254, 0 , 0 },
{"RTC_SYNC_INTR_MASK", "PLL_CHANGING"                        , 0x00005258, 5 , 5 },
{"RTC_SYNC_INTR_MASK", "SLEEP_ACCESS"                        , 0x00005258, 4 , 4 },
{"RTC_SYNC_INTR_MASK", "WAKEUP_STATE"                        , 0x00005258, 3 , 3 },
{"RTC_SYNC_INTR_MASK", "SLEEP_STATE"                         , 0x00005258, 2 , 2 },
{"RTC_SYNC_INTR_MASK", "ON_STATE"                            , 0x00005258, 1 , 1 },
{"RTC_SYNC_INTR_MASK", "SHUTDOWN_STATE"                      , 0x00005258, 0 , 0 },
{"MCI_COMMAND0", "DISABLE_TIMESTAMP"                         , 0x00006000, 13, 13},
{"MCI_COMMAND0", "LEN"                                       , 0x00006000, 12, 8 },
{"MCI_COMMAND0", "HEADER"                                    , 0x00006000, 7 , 0 },
{"MCI_COMMAND1", "ADDR"                                      , 0x00006004, 31, 0 },
{"MCI_COMMAND2", "RESET_REQ_WAKEUP"                          , 0x00006008, 10, 10},
{"MCI_COMMAND2", "RESET_RX_NUM_CYCLES"                       , 0x00006008, 9 , 2 },
{"MCI_COMMAND2", "RESET_RX"                                  , 0x00006008, 1 , 1 },
{"MCI_COMMAND2", "RESET_TX"                                  , 0x00006008, 0 , 0 },
{"MCI_RX_CTRL", "HDR_RX_TIMEOUT_EN"                          , 0x0000600c, 2 , 2 },
{"MCI_RX_CTRL", "DISABLE_MAXGAIN_RESET"                      , 0x0000600c, 1 , 1 },
{"MCI_RX_CTRL", "DISABLE_TIMESTAMP"                          , 0x0000600c, 0 , 0 },
{"MCI_TX_CTRL", "GAIN_UPDATE_NUM"                            , 0x00006010, 27, 24},
{"MCI_TX_CTRL", "GAIN_UPDATE_FREQ"                           , 0x00006010, 23, 3 },
{"MCI_TX_CTRL", "DISABLE_LNA_UPDATES"                        , 0x00006010, 2 , 2 },
{"MCI_TX_CTRL", "CLK_DIV"                                    , 0x00006010, 1 , 0 },
{"MCI_MSG_ATTRIBUTES_TABLE", "INVALID_HDR"                   , 0x00006014, 31, 16},
{"MCI_MSG_ATTRIBUTES_TABLE", "CHECKSUM_EN"                   , 0x00006014, 15, 0 },
{"MCI_SCHD_TABLE_0", "BASE_ADDR"                             , 0x00006018, 31, 0 },
{"MCI_SCHD_TABLE_1", "SW_REQ_OWN"                            , 0x0000601c, 31, 16},
{"MCI_SCHD_TABLE_1", "OWN"                                   , 0x0000601c, 15, 0 },
{"MCI_GPM_0", "START_ADDR"                                   , 0x00006020, 31, 0 },
{"MCI_GPM_1", "WRITE_PTR"                                    , 0x00006024, 31, 16},
{"MCI_GPM_1", "LEN"                                          , 0x00006024, 15, 0 },
{"MCI_INTERRUPT_RAW", "CONT_INFO_TIMEOUT"                    , 0x00006028, 31, 31},
{"MCI_INTERRUPT_RAW", "BB_AIC_IRQ"                           , 0x00006028, 30, 30},
{"MCI_INTERRUPT_RAW", "BT_STOMP"                             , 0x00006028, 29, 29},
{"MCI_INTERRUPT_RAW", "BT_FREQ"                              , 0x00006028, 28, 28},
{"MCI_INTERRUPT_RAW", "BT_PRI_THRESH"                        , 0x00006028, 27, 27},
{"MCI_INTERRUPT_RAW", "BT_PRI"                               , 0x00006028, 26, 11},
{"MCI_INTERRUPT_RAW", "REMOTE_SLEEP_UPDATE"                  , 0x00006028, 10, 10},
{"MCI_INTERRUPT_RAW", "RX_MSG"                               , 0x00006028, 9 , 9 },
{"MCI_INTERRUPT_RAW", "TX_SW_MSG_FAIL"                       , 0x00006028, 8 , 8 },
{"MCI_INTERRUPT_RAW", "TX_HW_MSG_FAIL"                       , 0x00006028, 7 , 7 },
{"MCI_INTERRUPT_RAW", "RX_ILLEGAL_HDR"                       , 0x00006028, 6 , 6 },
{"MCI_INTERRUPT_RAW", "RX_SW_MSG_FAIL"                       , 0x00006028, 5 , 5 },
{"MCI_INTERRUPT_RAW", "RX_HW_MSG_FAIL"                       , 0x00006028, 4 , 4 },
{"MCI_INTERRUPT_RAW", "RX_INVALID_HDR"                       , 0x00006028, 3 , 3 },
{"MCI_INTERRUPT_RAW", "RX_CKSUM_FAIL"                        , 0x00006028, 2 , 2 },
{"MCI_INTERRUPT_RAW", "CPU_INT_MSG"                          , 0x00006028, 1 , 1 },
{"MCI_INTERRUPT_RAW", "SW_MSG_DONE"                          , 0x00006028, 0 , 0 },
{"MCI_INTERRUPT_EN", "CONT_INFO_TIMEOUT"                     , 0x0000602c, 31, 31},
{"MCI_INTERRUPT_EN", "BB_AIC_IRQ"                            , 0x0000602c, 30, 30},
{"MCI_INTERRUPT_EN", "BT_STOMP"                              , 0x0000602c, 29, 29},
{"MCI_INTERRUPT_EN", "BT_FREQ"                               , 0x0000602c, 28, 28},
{"MCI_INTERRUPT_EN", "BT_PRI_THRESH"                         , 0x0000602c, 27, 27},
{"MCI_INTERRUPT_EN", "BT_PRI"                                , 0x0000602c, 26, 11},
{"MCI_INTERRUPT_EN", "REMOTE_SLEEP_UPDATE"                   , 0x0000602c, 10, 10},
{"MCI_INTERRUPT_EN", "RX_MSG"                                , 0x0000602c, 9 , 9 },
{"MCI_INTERRUPT_EN", "TX_SW_MSG_FAIL"                        , 0x0000602c, 8 , 8 },
{"MCI_INTERRUPT_EN", "TX_HW_MSG_FAIL"                        , 0x0000602c, 7 , 7 },
{"MCI_INTERRUPT_EN", "RX_ILLEGAL_HDR"                        , 0x0000602c, 6 , 6 },
{"MCI_INTERRUPT_EN", "RX_SW_MSG_FAIL"                        , 0x0000602c, 5 , 5 },
{"MCI_INTERRUPT_EN", "RX_HW_MSG_FAIL"                        , 0x0000602c, 4 , 4 },
{"MCI_INTERRUPT_EN", "RX_INVALID_HDR"                        , 0x0000602c, 3 , 3 },
{"MCI_INTERRUPT_EN", "RX_CKSUM_FAIL"                         , 0x0000602c, 2 , 2 },
{"MCI_INTERRUPT_EN", "CPU_INT_MSG"                           , 0x0000602c, 1 , 1 },
{"MCI_INTERRUPT_EN", "SW_MSG_DONE"                           , 0x0000602c, 0 , 0 },
{"MCI_REMOTE_CPU_INT", "BODY"                                , 0x00006030, 31, 0 },
{"MCI_REMOTE_CPU_INT_EN", "BODY"                             , 0x00006034, 31, 0 },
{"MCI_INTERRUPT_RX_MSG_RAW", "REQ_WAKE"                      , 0x00006038, 12, 12},
{"MCI_INTERRUPT_RX_MSG_RAW", "SYS_WAKING"                    , 0x00006038, 11, 11},
{"MCI_INTERRUPT_RX_MSG_RAW", "SYS_SLEEPING"                  , 0x00006038, 10, 10},
{"MCI_INTERRUPT_RX_MSG_RAW", "LNA_INFO"                      , 0x00006038, 9 , 9 },
{"MCI_INTERRUPT_RX_MSG_RAW", "GPM"                           , 0x00006038, 8 , 8 },
{"MCI_INTERRUPT_RX_MSG_RAW", "CPU_INT"                       , 0x00006038, 6 , 6 },
{"MCI_INTERRUPT_RX_MSG_RAW", "SCHD_INFO"                     , 0x00006038, 5 , 5 },
{"MCI_INTERRUPT_RX_MSG_RAW", "CONT_RST"                      , 0x00006038, 4 , 4 },
{"MCI_INTERRUPT_RX_MSG_RAW", "CONT_INFO"                     , 0x00006038, 3 , 3 },
{"MCI_INTERRUPT_RX_MSG_RAW", "CONT_NACK"                     , 0x00006038, 2 , 2 },
{"MCI_INTERRUPT_RX_MSG_RAW", "LNA_CTRL"                      , 0x00006038, 1 , 1 },
{"MCI_INTERRUPT_RX_MSG_RAW", "REMOTE_RESET"                  , 0x00006038, 0 , 0 },
{"MCI_INTERRUPT_RX_MSG_EN", "REQ_WAKE"                       , 0x0000603c, 12, 12},
{"MCI_INTERRUPT_RX_MSG_EN", "SYS_WAKING"                     , 0x0000603c, 11, 11},
{"MCI_INTERRUPT_RX_MSG_EN", "SYS_SLEEPING"                   , 0x0000603c, 10, 10},
{"MCI_INTERRUPT_RX_MSG_EN", "LNA_INFO"                       , 0x0000603c, 9 , 9 },
{"MCI_INTERRUPT_RX_MSG_EN", "GPM"                            , 0x0000603c, 8 , 8 },
{"MCI_INTERRUPT_RX_MSG_EN", "CPU_INT"                        , 0x0000603c, 6 , 6 },
{"MCI_INTERRUPT_RX_MSG_EN", "SCHD_INFO"                      , 0x0000603c, 5 , 5 },
{"MCI_INTERRUPT_RX_MSG_EN", "CONT_RST"                       , 0x0000603c, 4 , 4 },
{"MCI_INTERRUPT_RX_MSG_EN", "CONT_INFO"                      , 0x0000603c, 3 , 3 },
{"MCI_INTERRUPT_RX_MSG_EN", "CONT_NACK"                      , 0x0000603c, 2 , 2 },
{"MCI_INTERRUPT_RX_MSG_EN", "LNA_CTRL"                       , 0x0000603c, 1 , 1 },
{"MCI_INTERRUPT_RX_MSG_EN", "REMOTE_RESET"                   , 0x0000603c, 0 , 0 },
{"MCI_CPU_INT", "MSG"                                        , 0x00006040, 31, 0 },
{"MCI_RX_STATUS", "S2P_COUNT"                                , 0x00006044, 17, 14},
{"MCI_RX_STATUS", "MCI_CLK_REQ"                              , 0x00006044, 13, 13},
{"MCI_RX_STATUS", "REMOTE_SLEEP"                             , 0x00006044, 12, 12},
{"MCI_RX_STATUS", "SCHD_MSG_INDEX"                           , 0x00006044, 11, 8 },
{"MCI_CONT_STATUS", "OWNER"                                  , 0x00006048, 31, 28},
{"MCI_CONT_STATUS", "CHANNEL"                                , 0x00006048, 27, 21},
{"MCI_CONT_STATUS", "LINKID"                                 , 0x00006048, 20, 17},
{"MCI_CONT_STATUS", "TX"                                     , 0x00006048, 16, 16},
{"MCI_CONT_STATUS", "PRIORITY"                               , 0x00006048, 15, 8 },
{"MCI_CONT_STATUS", "RSSI_POWER"                             , 0x00006048, 7 , 0 },
{"MCI_BT_PRI0", "VAL3"                                       , 0x0000604c, 31, 24},
{"MCI_BT_PRI0", "VAL2"                                       , 0x0000604c, 23, 16},
{"MCI_BT_PRI0", "VAL1"                                       , 0x0000604c, 15, 8 },
{"MCI_BT_PRI0", "VAL0"                                       , 0x0000604c, 7 , 0 },
{"MCI_BT_PRI1", "VAL3"                                       , 0x00006050, 31, 24},
{"MCI_BT_PRI1", "VAL2"                                       , 0x00006050, 23, 16},
{"MCI_BT_PRI1", "VAL1"                                       , 0x00006050, 15, 8 },
{"MCI_BT_PRI1", "VAL0"                                       , 0x00006050, 7 , 0 },
{"MCI_BT_PRI2", "VAL3"                                       , 0x00006054, 31, 24},
{"MCI_BT_PRI2", "VAL2"                                       , 0x00006054, 23, 16},
{"MCI_BT_PRI2", "VAL1"                                       , 0x00006054, 15, 8 },
{"MCI_BT_PRI2", "VAL0"                                       , 0x00006054, 7 , 0 },
{"MCI_BT_PRI3", "VAL3"                                       , 0x00006058, 31, 24},
{"MCI_BT_PRI3", "VAL2"                                       , 0x00006058, 23, 16},
{"MCI_BT_PRI3", "VAL1"                                       , 0x00006058, 15, 8 },
{"MCI_BT_PRI3", "VAL0"                                       , 0x00006058, 7 , 0 },
{"MCI_BT_PRI", "THRESH"                                      , 0x0000605c, 7 , 0 },
{"MCI_WL_FREQ0", "MASK"                                      , 0x00006060, 31, 0 },
{"MCI_WL_FREQ1", "MASK"                                      , 0x00006064, 31, 0 },
{"MCI_WL_FREQ2", "MASK"                                      , 0x00006068, 15, 0 },
{"MCI_GAIN", "OFFSET2"                                       , 0x0000606c, 15, 8 },
{"MCI_GAIN", "OFFSET1"                                       , 0x0000606c, 7 , 0 },
{"MCI_WBTIMER1", "TARGET"                                    , 0x00006070, 31, 0 },
{"MCI_WBTIMER2", "TARGET"                                    , 0x00006074, 31, 0 },
{"MCI_WBTIMER3", "TARGET"                                    , 0x00006078, 31, 0 },
{"MCI_WBTIMER4", "TARGET"                                    , 0x0000607c, 31, 0 },
{"MCI_MAXGAIN", "GAIN4"                                      , 0x00006080, 31, 24},
{"MCI_MAXGAIN", "GAIN3"                                      , 0x00006080, 23, 16},
{"MCI_MAXGAIN", "GAIN2"                                      , 0x00006080, 15, 8 },
{"MCI_MAXGAIN", "GAIN1"                                      , 0x00006080, 7 , 0 },
{"MCI_HW_SCHD_TBL_CTL", "PREV_PTR"                           , 0x00006084, 31, 28},
{"MCI_HW_SCHD_TBL_CTL", "NEXT_PTR"                           , 0x00006084, 27, 24},
{"MCI_HW_SCHD_TBL_CTL", "CUR_PTR"                            , 0x00006084, 23, 20},
{"MCI_HW_SCHD_TBL_CTL", "TAIL_PTR"                           , 0x00006084, 19, 16},
{"MCI_HW_SCHD_TBL_CTL", "HEAD_PTR"                           , 0x00006084, 15, 12},
{"MCI_HW_SCHD_TBL_CTL", "TBL_EMPTY"                          , 0x00006084, 11, 11},
{"MCI_HW_SCHD_TBL_CTL", "RW_ADDR"                            , 0x00006084, 4 , 1 },
{"MCI_HW_SCHD_TBL_CTL", "CLEAR"                              , 0x00006084, 0 , 0 },
{"MCI_HW_SCHD_TBL_D0", "Data0"                               , 0x00006088, 31, 0 },
{"MCI_HW_SCHD_TBL_D1", "Data1"                               , 0x0000608c, 31, 0 },
{"MCI_HW_SCHD_TBL_D2", "Data2"                               , 0x00006090, 31, 0 },
{"MCI_HW_SCHD_TBL_D3", "Data3"                               , 0x00006094, 31, 0 },
{"MCI_TX_PAYLOAD0", "D0"                                     , 0x00006098, 31, 0 },
{"MCI_TX_PAYLOAD1", "D1"                                     , 0x0000609c, 31, 0 },
{"MCI_TX_PAYLOAD2", "D2"                                     , 0x000060a0, 31, 0 },
{"MCI_TX_PAYLOAD3", "D3"                                     , 0x000060a4, 31, 0 },
{"BTCOEX_WBTIMER", "VALUE"                                   , 0x000060a8, 31, 0 },
{"BTCOEX_CTRL", "REDUCE_TXPWR_ENABLE"                        , 0x000060ac, 29, 29},
{"BTCOEX_CTRL", "WAIT_BA_MARGIN"                             , 0x000060ac, 28, 21},
{"BTCOEX_CTRL", "USE_1_CHAIN_FOR_ACK"                        , 0x000060ac, 20, 20},
{"BTCOEX_CTRL", "USE_1_CHAIN_FOR_BCN"                        , 0x000060ac, 19, 19},
{"BTCOEX_CTRL", "WL_PRIORITY_SW_CTRL"                        , 0x000060ac, 18, 15},
{"BTCOEX_CTRL", "AGGR_THRESH"                                , 0x000060ac, 14, 12},
{"BTCOEX_CTRL", "RX_CHAIN_MASK"                              , 0x000060ac, 11, 9 },
{"BTCOEX_CTRL", "DEDICATED_ANT_MODE"                         , 0x000060ac, 7 , 7 },
{"BTCOEX_CTRL", "TIME_TO_NEXT_BT_THRESH_ENABLE"              , 0x000060ac, 6 , 6 },
{"BTCOEX_CTRL", "ONE_STEP_LOOK_AHEAD_ENABLE"                 , 0x000060ac, 5 , 5 },
{"BTCOEX_CTRL", "PA_SHARED"                                  , 0x000060ac, 4 , 4 },
{"BTCOEX_CTRL", "LNA_SHARED"                                 , 0x000060ac, 3 , 3 },
{"BTCOEX_CTRL", "MCI_MODE_ENABLE"                            , 0x000060ac, 2 , 2 },
{"BTCOEX_CTRL", "WBTIMER_ENABLE"                             , 0x000060ac, 1 , 1 },
{"BTCOEX_CTRL", "JUPITER_MODE"                               , 0x000060ac, 0 , 0 },
{"BTCOEX_WL_WEIGHTS0", "VALUE3"                              , 0x000060b0, 31, 24},
{"BTCOEX_WL_WEIGHTS0", "VALUE2"                              , 0x000060b0, 23, 16},
{"BTCOEX_WL_WEIGHTS0", "VALUE1"                              , 0x000060b0, 15, 8 },
{"BTCOEX_WL_WEIGHTS0", "VALUE0"                              , 0x000060b0, 7 , 0 },
{"BTCOEX_WL_WEIGHTS1", "VALUE3"                              , 0x000060b4, 31, 24},
{"BTCOEX_WL_WEIGHTS1", "VALUE2"                              , 0x000060b4, 23, 16},
{"BTCOEX_WL_WEIGHTS1", "VALUE1"                              , 0x000060b4, 15, 8 },
{"BTCOEX_WL_WEIGHTS1", "VALUE0"                              , 0x000060b4, 7 , 0 },
{"BTCOEX_WL_WEIGHTS2", "VALUE3"                              , 0x000060b8, 31, 24},
{"BTCOEX_WL_WEIGHTS2", "VALUE2"                              , 0x000060b8, 23, 16},
{"BTCOEX_WL_WEIGHTS2", "VALUE1"                              , 0x000060b8, 15, 8 },
{"BTCOEX_WL_WEIGHTS2", "VALUE0"                              , 0x000060b8, 7 , 0 },
{"BTCOEX_WL_WEIGHTS3", "VALUE3"                              , 0x000060bc, 31, 24},
{"BTCOEX_WL_WEIGHTS3", "VALUE2"                              , 0x000060bc, 23, 16},
{"BTCOEX_WL_WEIGHTS3", "VALUE1"                              , 0x000060bc, 15, 8 },
{"BTCOEX_WL_WEIGHTS3", "VALUE0"                              , 0x000060bc, 7 , 0 },
{"BTCOEX_MAX_TXPWR[0]", "DATA"                               , 0x000060c0, 31, 0 },
{"BTCOEX_MAX_TXPWR[1]", "DATA"                               , 0x000060c4, 31, 0 },
{"BTCOEX_MAX_TXPWR[2]", "DATA"                               , 0x000060c8, 31, 0 },
{"BTCOEX_MAX_TXPWR[3]", "DATA"                               , 0x000060cc, 31, 0 },
{"BTCOEX_MAX_TXPWR[4]", "DATA"                               , 0x000060d0, 31, 0 },
{"BTCOEX_MAX_TXPWR[5]", "DATA"                               , 0x000060d4, 31, 0 },
{"BTCOEX_MAX_TXPWR[6]", "DATA"                               , 0x000060d8, 31, 0 },
{"BTCOEX_MAX_TXPWR[7]", "DATA"                               , 0x000060dc, 31, 0 },
{"BTCOEX_WL_LNA", "INFO_MSG_LEGACY"                          , 0x00006140, 22, 22},
{"BTCOEX_WL_LNA", "STATE_TIMEOUT"                            , 0x00006140, 21, 0 },
{"BTCOEX_RFGAIN_CTRL", "ANT_ISOLATION"                       , 0x00006144, 18, 13},
{"BTCOEX_RFGAIN_CTRL", "GAIN_CAP_TIME_THRESHOLD"             , 0x00006144, 12, 8 },
{"BTCOEX_RFGAIN_CTRL", "SW_GAIN_CAP"                         , 0x00006144, 7 , 1 },
{"BTCOEX_RFGAIN_CTRL", "GAIN_CAP_ENABLE"                     , 0x00006144, 0 , 0 },
{"BTCOEX_CTRL2", "RESERVED"                                  , 0x00006148, 31, 28},
{"BTCOEX_CTRL2", "BT_RX_ALLOW_WL_UNSHARED_CHAIN_TX"          , 0x00006148, 27, 27},
{"BTCOEX_CTRL2", "WL_2S_RX_ALLOW_BT_TX"                      , 0x00006148, 26, 26},
{"BTCOEX_CTRL2", "WL_1S_RX_ALLOW_BT_TX"                      , 0x00006148, 25, 25},
{"BTCOEX_CTRL2", "MAC_BB_OBS_SEL"                            , 0x00006148, 24, 24},
{"BTCOEX_CTRL2", "GPIO_OBS_SEL"                              , 0x00006148, 23, 23},
{"BTCOEX_CTRL2", "DEWEIGHT_RX_ENABLE"                        , 0x00006148, 22, 22},
{"BTCOEX_CTRL2", "TX_SHARED_CHAIN_MASK"                      , 0x00006148, 21, 19},
{"BTCOEX_CTRL2", "TXPWR_THRESH"                              , 0x00006148, 18, 11},
{"BTCOEX_CTRL2", "OBS_SEL"                                   , 0x00006148, 10, 8 },
{"BTCOEX_CTRL2", "TXTX_RANGE_ENABLE"                         , 0x00006148, 7 , 7 },
{"BTCOEX_CTRL2", "TXRX_RANGE_ENABLE"                         , 0x00006148, 6 , 6 },
{"BTCOEX_CTRL2", "RXTX_RANGE_ENABLE"                         , 0x00006148, 5 , 5 },
{"BTCOEX_CTRL2", "RXRX_RANGE_ENABLE"                         , 0x00006148, 4 , 4 },
{"BTCOEX_CTRL2", "RESERVED2"                                 , 0x00006148, 3 , 2 },
{"BTCOEX_CTRL2", "IGNORE_RX_FOR_BA"                          , 0x00006148, 1 , 1 },
{"BTCOEX_CTRL2", "FORCE_WAIT_BA_ENABLE"                      , 0x00006148, 0 , 0 },
{"BTCOEX_RC", "WARM_RST"                                     , 0x0000614c, 0 , 0 },
{"BTCOEX_MAX_RFGAIN[0]", "DATA"                              , 0x00006150, 31, 0 },
{"BTCOEX_MAX_RFGAIN[1]", "DATA"                              , 0x00006154, 31, 0 },
{"BTCOEX_MAX_RFGAIN[2]", "DATA"                              , 0x00006158, 31, 0 },
{"BTCOEX_MAX_RFGAIN[3]", "DATA"                              , 0x0000615c, 31, 0 },
{"BTCOEX_MAX_RFGAIN[4]", "DATA"                              , 0x00006160, 31, 0 },
{"BTCOEX_MAX_RFGAIN[5]", "DATA"                              , 0x00006164, 31, 0 },
{"BTCOEX_MAX_RFGAIN[6]", "DATA"                              , 0x00006168, 31, 0 },
{"BTCOEX_MAX_RFGAIN[7]", "DATA"                              , 0x0000616c, 31, 0 },
{"BTCOEX_MAX_RFGAIN[8]", "DATA"                              , 0x00006170, 31, 0 },
{"BTCOEX_MAX_RFGAIN[9]", "DATA"                              , 0x00006174, 31, 0 },
{"BTCOEX_MAX_RFGAIN[10]", "DATA"                             , 0x00006178, 31, 0 },
{"BTCOEX_MAX_RFGAIN[11]", "DATA"                             , 0x0000617c, 31, 0 },
{"BTCOEX_MAX_RFGAIN[12]", "DATA"                             , 0x00006180, 31, 0 },
{"BTCOEX_MAX_RFGAIN[13]", "DATA"                             , 0x00006184, 31, 0 },
{"BTCOEX_MAX_RFGAIN[14]", "DATA"                             , 0x00006188, 31, 0 },
{"BTCOEX_MAX_RFGAIN[15]", "DATA"                             , 0x0000618c, 31, 0 },
{"BTCOEX_DBG", "OBS"                                         , 0x00006250, 31, 0 },
{"MCI_LAST_HW_MSG_HDR", "LEN"                                , 0x00006254, 10, 8 },
{"MCI_LAST_HW_MSG_HDR", "HDR"                                , 0x00006254, 7 , 0 },
{"MCI_LAST_HW_MSG_BDY", "BDY"                                , 0x00006258, 31, 0 },
{"MCI_SCHD_TABLE_2", "HW_BASED"                              , 0x00006260, 1 , 1 },
{"MCI_SCHD_TABLE_2", "MEM_BASED"                             , 0x00006260, 0 , 0 },
{"BTCOEX_CTRL3", "CONT_INFO_TIMEOUT"                         , 0x00006264, 11, 0 },
{"MCI_INTERRUPT_1_RAW", "BT_TXRX_CNT_LIMIT"                  , 0x0000626c, 1 , 1 },
{"MCI_INTERRUPT_1_RAW", "RX_TIMEOUT_RST"                     , 0x0000626c, 0 , 0 },
{"MCI_INTERRUPT_1_EN", "BT_TXRX_CNT_LIMIT"                   , 0x00006270, 1 , 1 },
{"MCI_INTERRUPT_1_EN", "RX_TIMEOUT_RST"                      , 0x00006270, 0 , 0 },
{"MCI_EV_MISC", "RESERVED"                                   , 0x00006274, 15, 1 },
{"MCI_EV_MISC", "EV88239_FIX_EN"                             , 0x00006274, 0 , 0 },
{"BTCOEX_RX_RANGE", "BT_MAX"                                 , 0x00006278, 31, 24},
{"BTCOEX_RX_RANGE", "BT_MIN"                                 , 0x00006278, 23, 16},
{"BTCOEX_RX_RANGE", "WL_MAX"                                 , 0x00006278, 15, 8 },
{"BTCOEX_RX_RANGE", "WL_MIN"                                 , 0x00006278, 7 , 0 },
{"BTCOEX_TX_RANGE", "BT_MAX"                                 , 0x0000627c, 31, 24},
{"BTCOEX_TX_RANGE", "BT_MIN"                                 , 0x0000627c, 23, 16},
{"BTCOEX_TX_RANGE", "WL_MAX"                                 , 0x0000627c, 15, 8 },
{"BTCOEX_TX_RANGE", "WL_MIN"                                 , 0x0000627c, 7 , 0 },
{"BTCOEX_CHANNEL_BUSY_CNT", "VALUE"                          , 0x00006280, 31, 0 },
{"BTCOEX_CHANNEL_BUSY_CNT_CTRL", "CLEAR"                     , 0x00006284, 1 , 1 },
{"BTCOEX_CHANNEL_BUSY_CNT_CTRL", "ENABLE"                    , 0x00006284, 0 , 0 },
{"BTCOEX_BT_TX_CNT", "VALUE"                                 , 0x00006288, 31, 0 },
{"BTCOEX_BT_RX_CNT", "VALUE"                                 , 0x0000628c, 31, 0 },
{"BTCOEX_BT_TXRX_CNT_LIMIT", "VALUE"                         , 0x00006290, 31, 0 },
{"BTCOEX_BT_TXRX_CNT_CTRL", "LOW_PRI_LIMIT"                  , 0x00006294, 23, 16},
{"BTCOEX_BT_TXRX_CNT_CTRL", "HIGH_PRI_LIMIT"                 , 0x00006294, 15, 8 },
{"BTCOEX_BT_TXRX_CNT_CTRL", "RESERVED"                       , 0x00006294, 7 , 2 },
{"BTCOEX_BT_TXRX_CNT_CTRL", "CLEAR"                          , 0x00006294, 1 , 1 },
{"BTCOEX_BT_TXRX_CNT_CTRL", "ENABLE"                         , 0x00006294, 0 , 0 },
{"WLAN_INT_STATUS", "BTCOEX"                                 , 0x00007000, 0 , 0 },
{"BTCOEXCTRL", "WBSYNC_ON_BEACON"                            , 0x00007004, 25, 25},
{"BTCOEXCTRL", "PTA_MODE"                                    , 0x00007004, 24, 23},
{"BTCOEXCTRL", "FREQ_TIME"                                   , 0x00007004, 22, 18},
{"BTCOEXCTRL", "PRIORITY_TIME"                               , 0x00007004, 17, 12},
{"BTCOEXCTRL", "SYNC_DET_EN"                                 , 0x00007004, 11, 11},
{"BTCOEXCTRL", "IDLE_CNT_EN"                                 , 0x00007004, 10, 10},
{"BTCOEXCTRL", "FRAME_CNT_EN"                                , 0x00007004, 9 , 9 },
{"BTCOEXCTRL", "CLK_CNT_EN"                                  , 0x00007004, 8 , 8 },
{"BTCOEXCTRL", "GAP"                                         , 0x00007004, 7 , 0 },
{"WBSYNC_PRIORITY1", "BITMAP"                                , 0x00007008, 31, 0 },
{"WBSYNC_PRIORITY2", "BITMAP"                                , 0x0000700c, 31, 0 },
{"WBSYNC_PRIORITY3", "BITMAP"                                , 0x00007010, 31, 0 },
{"BTCOEX0", "SYNC_DUR"                                       , 0x00007014, 7 , 0 },
{"BTCOEX1", "CLK_THRES"                                      , 0x00007018, 20, 0 },
{"BTCOEX2", "FRAME_THRES"                                    , 0x0000701c, 7 , 0 },
{"BTCOEX3", "CLK_CNT"                                        , 0x00007020, 20, 0 },
{"BTCOEX4", "FRAME_CNT"                                      , 0x00007024, 7 , 0 },
{"BTCOEX5", "IDLE_CNT"                                       , 0x00007028, 15, 0 },
{"BTCOEX6", "IDLE_RESET_LVL_BITMAP"                          , 0x0000702c, 31, 0 },
{"WBSYNC", "BTCLOCK"                                         , 0x00007030, 31, 0 },
{"WBSYNC1", "BTCLOCK"                                        , 0x00007034, 31, 0 },
{"WBSYNC2", "BTCLOCK"                                        , 0x00007038, 31, 0 },
{"WBSYNC3", "BTCLOCK"                                        , 0x0000703c, 31, 0 },
{"WB_TIMER_TARGET", "VALUE"                                  , 0x00007040, 31, 0 },
{"WB_TIMER_SLOP", "VALUE"                                    , 0x00007044, 9 , 0 },
{"BTCOEX_INT_EN", "WB_TIMER"                                 , 0x00007048, 7 , 7 },
{"BTCOEX_INT_EN", "NOSYNC"                                   , 0x00007048, 4 , 4 },
{"BTCOEX_INT_EN", "SYNC"                                     , 0x00007048, 3 , 3 },
{"BTCOEX_INT_EN", "END"                                      , 0x00007048, 2 , 2 },
{"BTCOEX_INT_EN", "FRAME_CNT"                                , 0x00007048, 1 , 1 },
{"BTCOEX_INT_EN", "CLK_CNT"                                  , 0x00007048, 0 , 0 },
{"BTCOEX_INT_STAT", "MCI"                                    , 0x0000704c, 12, 12},
{"BTCOEX_INT_STAT", "WB_TIMER"                               , 0x0000704c, 7 , 7 },
{"BTCOEX_INT_STAT", "BTPRIORITY_STOMP"                       , 0x0000704c, 6 , 6 },
{"BTCOEX_INT_STAT", "BTPRIORITY"                             , 0x0000704c, 5 , 5 },
{"BTCOEX_INT_STAT", "NOSYNC"                                 , 0x0000704c, 4 , 4 },
{"BTCOEX_INT_STAT", "SYNC"                                   , 0x0000704c, 3 , 3 },
{"BTCOEX_INT_STAT", "END"                                    , 0x0000704c, 2 , 2 },
{"BTCOEX_INT_STAT", "FRAME_CNT"                              , 0x0000704c, 1 , 1 },
{"BTCOEX_INT_STAT", "CLK_CNT"                                , 0x0000704c, 0 , 0 },
{"BTPRIORITY_INT_EN", "BITMAP"                               , 0x00007050, 31, 0 },
{"BTPRIORITY_INT_STAT", "BITMAP"                             , 0x00007054, 31, 0 },
{"BTPRIORITY_STOMP_INT_EN", "BITMAP"                         , 0x00007058, 31, 0 },
{"BTPRIORITY_STOMP_INT_STAT", "BITMAP"                       , 0x0000705c, 31, 0 },
{"BTPRIORITY_INT", "DELAY"                                   , 0x00007060, 7 , 0 },
{"SCO_PARAMS", "SLOP"                                        , 0x00007064, 23, 14},
{"SCO_PARAMS", "PERIOD"                                      , 0x00007064, 13, 0 },
{"SCO_PRIORITY", "BITMAP"                                    , 0x00007068, 31, 0 },
{"SCO_SYNC", "BTCLOCK"                                       , 0x0000706c, 31, 0 },
{"BTCOEX_RAW_STAT", "WB_TIMER"                               , 0x00007070, 7 , 7 },
{"BTCOEX_RAW_STAT", "NOSYNC"                                 , 0x00007070, 4 , 4 },
{"BTCOEX_RAW_STAT", "SYNC"                                   , 0x00007070, 3 , 3 },
{"BTCOEX_RAW_STAT", "END"                                    , 0x00007070, 2 , 2 },
{"BTCOEX_RAW_STAT", "FRAME_CNT"                              , 0x00007070, 1 , 1 },
{"BTCOEX_RAW_STAT", "CLK_CNT"                                , 0x00007070, 0 , 0 },
{"BTPRIORITY_RAW_STAT", "BITMAP"                             , 0x00007074, 31, 0 },
{"BTPRIORITY_STOMP_RAW_STAT", "BITMAP"                       , 0x00007078, 31, 0 },
{"PCIE_DEBUG_LOW", "CXPL_DEBUG_INFO_LOW"                     , 0x00008000, 31, 0 },
{"PCIE_DEBUG_HIGH", "CXPL_DEBUG_INFO_HIGH"                   , 0x00008004, 31, 0 },
{"PCIE_PM", "WAKE"                                           , 0x00008008, 25, 25},
{"PCIE_PM", "XMLH_L1_EXIT"                                   , 0x00008008, 24, 24},
{"PCIE_PM", "LINK_REQ_RST_N"                                 , 0x00008008, 23, 23},
{"PCIE_PM", "RDLH_LINK_UP"                                   , 0x00008008, 22, 22},
{"PCIE_PM", "MASTER_STATE"                                   , 0x00008008, 21, 17},
{"PCIE_PM", "PME_EN"                                         , 0x00008008, 16, 16},
{"PCIE_PM", "AUX_PM_EN"                                      , 0x00008008, 15, 15},
{"PCIE_PM", "XTLH_BLOCK_TLP"                                 , 0x00008008, 14, 14},
{"PCIE_PM", "DSTATE"                                         , 0x00008008, 13, 11},
{"PCIE_PM", "LTSSM_STATE"                                    , 0x00008008, 10, 5 },
{"PCIE_PM", "STATUS"                                         , 0x00008008, 4 , 4 },
{"PCIE_PM", "XMLH_LINK_UP"                                   , 0x00008008, 3 , 3 },
{"PCIE_PM", "CURNT_STATE"                                    , 0x00008008, 2 , 0 },
{"PCIE_CTRL", "RST_MASK"                                     , 0x0000800c, 20, 20},
{"PCIE_CTRL", "OBS_MUX"                                      , 0x0000800c, 19, 17},
{"PCIE_CTRL", "IGNORE_AXI_PCIE_L1"                           , 0x0000800c, 16, 16},
{"PCIE_CTRL", "IGNORE_MAC_FOR_L1"                            , 0x0000800c, 15, 15},
{"PCIE_CTRL", "TARGET_L1_EN"                                 , 0x0000800c, 14, 14},
{"PCIE_CTRL", "HOST_L1_EN"                                   , 0x0000800c, 13, 13},
{"PCIE_CTRL", "TRAINING_RST_EN"                              , 0x0000800c, 12, 12},
{"PCIE_CTRL", "RDLH_LINK_RST_EN"                             , 0x0000800c, 11, 11},
{"PCIE_CTRL", "LINK_REQ_RST_EN"                              , 0x0000800c, 10, 10},
{"PCIE_CTRL", "XMLH_LINK_RST_EN"                             , 0x0000800c, 9 , 9 },
{"PCIE_CTRL", "APP_LTSSM_ENABLE"                             , 0x0000800c, 8 , 8 },
{"PCIE_CTRL", "ASPM_TIMER_BASED_L1_DISABLE"                  , 0x0000800c, 7 , 7 },
{"PCIE_CTRL", "SYS_AUX_PWR_DET"                              , 0x0000800c, 6 , 6 },
{"PCIE_CTRL", "D3_TO_L1_DISABLE_EN"                          , 0x0000800c, 5 , 5 },
{"PCIE_CTRL", "D3_TO_L1_DISABLE_REAL_EN"                     , 0x0000800c, 4 , 4 },
{"PCIE_CTRL", "NO_NAK_WA_EN"                                 , 0x0000800c, 3 , 3 },
{"PCIE_CTRL", "GDATA_WA_EN"                                  , 0x0000800c, 2 , 2 },
{"PCIE_CTRL", "TS2_WA_EN"                                    , 0x0000800c, 1 , 1 },
{"PCIE_CTRL", "TS1_WA_EN"                                    , 0x0000800c, 0 , 0 },
{"PCIE_NFTS", "CNTL_EN"                                      , 0x00008010, 8 , 8 },
{"PCIE_NFTS", "ADJ"                                          , 0x00008010, 7 , 0 },
{"PCIE_MSI_STATUS", "MSI_INT_PENDING"                        , 0x00008014, 24, 21},
{"PCIE_MSI_STATUS", "MULTI"                                  , 0x00008014, 20, 18},
{"PCIE_MSI_STATUS", "_64_BIT"                                , 0x00008014, 17, 17},
{"PCIE_MSI_STATUS", "DATA"                                   , 0x00008014, 16, 1 },
{"PCIE_MSI_STATUS", "EN"                                     , 0x00008014, 0 , 0 },
{"PCIE_MSI_MASK", "VALUE"                                    , 0x00008018, 31, 0 },
{"PCIE_MSI_ADDR", "LOW"                                      , 0x0000801c, 31, 0 },
{"PCIE_CO_ERR_CTR0", "BAD_DLLP_ERR"                          , 0x00008020, 23, 16},
{"PCIE_CO_ERR_CTR0", "BAD_TLP_ERR"                           , 0x00008020, 15, 8 },
{"PCIE_CO_ERR_CTR0", "RCVD_ERR"                              , 0x00008020, 7 , 0 },
{"PCIE_CO_ERR_CTR1", "RPLY_NUM_RO_ERR"                       , 0x00008024, 15, 8 },
{"PCIE_CO_ERR_CTR1", "RPLY_TO_ERR"                           , 0x00008024, 7 , 0 },
{"PCIE_CO_ERR_CTR_CTRL", "RPLY_NUM_RO_ERR_CTR_AUTO_STOP"     , 0x00008028, 9 , 9 },
{"PCIE_CO_ERR_CTR_CTRL", "RPLY_NUM_RO_ERR_CTR_RUN"           , 0x00008028, 8 , 8 },
{"PCIE_CO_ERR_CTR_CTRL", "RPLY_TO_ERR_CTR_AUTO_STOP"         , 0x00008028, 7 , 7 },
{"PCIE_CO_ERR_CTR_CTRL", "RPLY_TO_ERR_CTR_RUN"               , 0x00008028, 6 , 6 },
{"PCIE_CO_ERR_CTR_CTRL", "BAD_DLLP_ERR_CTR_AUTO_STOP"        , 0x00008028, 5 , 5 },
{"PCIE_CO_ERR_CTR_CTRL", "BAD_DLLP_ERR_CTR_RUN"              , 0x00008028, 4 , 4 },
{"PCIE_CO_ERR_CTR_CTRL", "BAD_TLP_ERR_CTR_AUTO_STOP"         , 0x00008028, 3 , 3 },
{"PCIE_CO_ERR_CTR_CTRL", "BAD_TLP_ERR_CTR_RUN"               , 0x00008028, 2 , 2 },
{"PCIE_CO_ERR_CTR_CTRL", "RCVD_ERR_CTR_AUTO_STOP"            , 0x00008028, 1 , 1 },
{"PCIE_CO_ERR_CTR_CTRL", "RCVD_ERR_CTR_RUN"                  , 0x00008028, 0 , 0 },
{"PCIE_MISC_STATUS", "CFG_PM_NO_SOFT_RST"                    , 0x0000802c, 9 , 9 },
{"PCIE_MISC_STATUS", "CFG_RCB"                               , 0x0000802c, 8 , 8 },
{"PCIE_MISC_STATUS", "CFG_MAX_PAYLOAD_SIZE"                  , 0x0000802c, 7 , 5 },
{"PCIE_MISC_STATUS", "CFG_MAX_RD_REQ_SIZE"                   , 0x0000802c, 4 , 2 },
{"PCIE_MISC_STATUS", "CFG_MEM_SPACE_EN"                      , 0x0000802c, 1 , 1 },
{"PCIE_MISC_STATUS", "CFG_BUS_MASTER_EN"                     , 0x0000802c, 0 , 0 },
{"PCIE_BAR0_START", "VAL"                                    , 0x00008030, 31, 0 },
{"PCIE_BAR0_LIMIT", "VAL"                                    , 0x00008034, 31, 0 },
{"AUTOCOMPL", "ENABLE"                                       , 0x00008038, 0 , 0 },
{"NUM_READS_WR_PENDING", "V"                                 , 0x0000803c, 4 , 0 },
{"PCIE_SCRATCH_0", "VAL"                                     , 0x00008040, 31, 0 },
{"PCIE_SCRATCH_1", "VAL"                                     , 0x00008044, 31, 0 },
{"CORE_CTRL", "MASK_PCIE_RST"                                , 0x00009000, 19, 19},
{"CORE_CTRL", "PCIE_LTSSM_EN"                                , 0x00009000, 18, 18},
{"CORE_CTRL", "AUTOCMPLT_CPU_TO_HOST_RD"                     , 0x00009000, 17, 17},
{"CORE_CTRL", "OUTBAND_PWRUP"                                , 0x00009000, 16, 16},
{"CORE_CTRL", "WAKE_L"                                       , 0x00009000, 15, 15},
{"CORE_CTRL", "HOST_WAKE_INTR_CLR"                           , 0x00009000, 14, 14},
{"CORE_CTRL", "CPU_INTR"                                     , 0x00009000, 13, 13},
{"CORE_CTRL", "PCIE_INTR"                                    , 0x00009000, 12, 12},
{"CORE_CTRL", "PCIE_REG_31"                                  , 0x00009000, 11, 11},
{"CORE_CTRL", "PCIE_BAR"                                     , 0x00009000, 10, 0 },
{"CORE_PM", "DSTATE"                                         , 0x00009004, 5 , 3 },
{"CORE_PM", "STATUS"                                         , 0x00009004, 2 , 2 },
{"CORE_PM", "AUX_PM_EN"                                      , 0x00009004, 1 , 1 },
{"CORE_PM", "PME_EN"                                         , 0x00009004, 0 , 0 },
{"PCIE_INTR_ENABLE", "VAL"                                   , 0x00009008, 29, 0 },
{"PCIE_INTR_CAUSE", "VAL"                                    , 0x0000900c, 29, 0 },
{"CPU_INTR", "STATUS"                                        , 0x00009010, 29, 0 },
{"PCIE_INTR_CLR", "VAL"                                      , 0x00009014, 29, 0 },
{"BT_INTR", "V"                                              , 0x00009018, 0 , 0 },
{"CPU_ADDR_MSB", "V"                                         , 0x0000901c, 3 , 0 },
{"AXI_SPOOFER", "PCIE_EN"                                    , 0x00009020, 5 , 5 },
{"AXI_SPOOFER", "BRIDGE_EN"                                  , 0x00009020, 4 , 4 },
{"AXI_SPOOFER", "CPU_S_EN"                                   , 0x00009020, 3 , 3 },
{"AXI_SPOOFER", "CE_EN"                                      , 0x00009020, 2 , 2 },
{"AXI_SPOOFER", "WMAC_EN"                                    , 0x00009020, 1 , 1 },
{"AXI_SPOOFER", "CPU_M_EN"                                   , 0x00009020, 0 , 0 },
{"SCRATCH_0", "VAL"                                          , 0x00009024, 31, 0 },
{"SCRATCH_1", "VAL"                                          , 0x00009028, 31, 0 },
{"SCRATCH_2", "VAL"                                          , 0x0000902c, 31, 0 },
{"SCRATCH_3", "VAL"                                          , 0x00009030, 31, 0 },
{"UartData", "UartTxCsr"                                     , 0x0000c000, 9 , 9 },
{"UartData", "UartRxCsr"                                     , 0x0000c000, 8 , 8 },
{"UartData", "UartTxRxData"                                  , 0x0000c000, 7 , 0 },
{"UartCs", "UartRxBusy"                                      , 0x0000c004, 15, 15},
{"UartCs", "UartTxBusy"                                      , 0x0000c004, 14, 14},
{"UartCs", "UartHostIntEn"                                   , 0x0000c004, 13, 13},
{"UartCs", "UartHostInt"                                     , 0x0000c004, 12, 12},
{"UartCs", "UartTxBreak"                                     , 0x0000c004, 11, 11},
{"UartCs", "UartRxBreak"                                     , 0x0000c004, 10, 10},
{"UartCs", "UartSeriaTxReady"                                , 0x0000c004, 9 , 9 },
{"UartCs", "UartTxReadyOride"                                , 0x0000c004, 8 , 8 },
{"UartCs", "UartRxReadyOride"                                , 0x0000c004, 7 , 7 },
{"UartCs", "UartDmaEn"                                       , 0x0000c004, 6 , 6 },
{"UartCs", "UartFlowControlMode"                             , 0x0000c004, 5 , 4 },
{"UartCs", "UartInterfaceMode"                               , 0x0000c004, 3 , 2 },
{"UartCs", "UartParityMode"                                  , 0x0000c004, 1 , 0 },
{"UartClock", "UartClockScale"                               , 0x0000c008, 23, 16},
{"UartClock", "UartClockStep"                                , 0x0000c008, 15, 0 },
{"UartInt", "UartTxEmptyInt"                                 , 0x0000c00c, 9 , 9 },
{"UartInt", "UartRxFullInt"                                  , 0x0000c00c, 8 , 8 },
{"UartInt", "UartRxBreakOffInt"                              , 0x0000c00c, 7 , 7 },
{"UartInt", "UartRxBreakOnInt"                               , 0x0000c00c, 6 , 6 },
{"UartInt", "UartRxParityErrInt"                             , 0x0000c00c, 5 , 5 },
{"UartInt", "UartTxOflowErrInt"                              , 0x0000c00c, 4 , 4 },
{"UartInt", "UartRxOflowErrInt"                              , 0x0000c00c, 3 , 3 },
{"UartInt", "UartRxFramingErrInt"                            , 0x0000c00c, 2 , 2 },
{"UartInt", "UartTxReadyInt"                                 , 0x0000c00c, 1 , 1 },
{"UartInt", "UartRxValidInt"                                 , 0x0000c00c, 0 , 0 },
{"UartIntEn", "UartTxEmptyIntEn"                             , 0x0000c010, 9 , 9 },
{"UartIntEn", "UartRxFullIntEn"                              , 0x0000c010, 8 , 8 },
{"UartIntEn", "UartRxBreakOffIntEn"                          , 0x0000c010, 7 , 7 },
{"UartIntEn", "UartRxBreakOnIntEn"                           , 0x0000c010, 6 , 6 },
{"UartIntEn", "UartRxParityErrIntEn"                         , 0x0000c010, 5 , 5 },
{"UartIntEn", "UartTxOflowErrIntEn"                          , 0x0000c010, 4 , 4 },
{"UartIntEn", "UartRxOflowErrIntEn"                          , 0x0000c010, 3 , 3 },
{"UartIntEn", "UartRxFramingErrIntEn"                        , 0x0000c010, 2 , 2 },
{"UartIntEn", "UartTxReadyIntEn"                             , 0x0000c010, 1 , 1 },
{"UartIntEn", "UartRxValidIntEn"                             , 0x0000c010, 0 , 0 },
{"SI_CONFIG", "ERR_INT"                                      , 0x00010000, 19, 19},
{"SI_CONFIG", "BIDIR_OD_DATA"                                , 0x00010000, 18, 18},
{"SI_CONFIG", "I2C"                                          , 0x00010000, 16, 16},
{"SI_CONFIG", "POS_SAMPLE"                                   , 0x00010000, 7 , 7 },
{"SI_CONFIG", "POS_DRIVE"                                    , 0x00010000, 6 , 6 },
{"SI_CONFIG", "INACTIVE_DATA"                                , 0x00010000, 5 , 5 },
{"SI_CONFIG", "INACTIVE_CLK"                                 , 0x00010000, 4 , 4 },
{"SI_CONFIG", "DIVIDER"                                      , 0x00010000, 3 , 0 },
{"SI_CS", "BIT_CNT_IN_LAST_BYTE"                             , 0x00010004, 13, 11},
{"SI_CS", "DONE_ERR"                                         , 0x00010004, 10, 10},
{"SI_CS", "DONE_INT"                                         , 0x00010004, 9 , 9 },
{"SI_CS", "START"                                            , 0x00010004, 8 , 8 },
{"SI_CS", "RX_CNT"                                           , 0x00010004, 7 , 4 },
{"SI_CS", "TX_CNT"                                           , 0x00010004, 3 , 0 },
{"SI_TX_DATA0", "DATA3"                                      , 0x00010008, 31, 24},
{"SI_TX_DATA0", "DATA2"                                      , 0x00010008, 23, 16},
{"SI_TX_DATA0", "DATA1"                                      , 0x00010008, 15, 8 },
{"SI_TX_DATA0", "DATA0"                                      , 0x00010008, 7 , 0 },
{"SI_TX_DATA1", "DATA7"                                      , 0x0001000c, 31, 24},
{"SI_TX_DATA1", "DATA6"                                      , 0x0001000c, 23, 16},
{"SI_TX_DATA1", "DATA5"                                      , 0x0001000c, 15, 8 },
{"SI_TX_DATA1", "DATA4"                                      , 0x0001000c, 7 , 0 },
{"SI_RX_DATA0", "DATA3"                                      , 0x00010010, 31, 24},
{"SI_RX_DATA0", "DATA2"                                      , 0x00010010, 23, 16},
{"SI_RX_DATA0", "DATA1"                                      , 0x00010010, 15, 8 },
{"SI_RX_DATA0", "DATA0"                                      , 0x00010010, 7 , 0 },
{"SI_RX_DATA1", "DATA7"                                      , 0x00010014, 31, 24},
{"SI_RX_DATA1", "DATA6"                                      , 0x00010014, 23, 16},
{"SI_RX_DATA1", "DATA5"                                      , 0x00010014, 15, 8 },
{"SI_RX_DATA1", "DATA4"                                      , 0x00010014, 7 , 0 },
{"WLAN_APB_ADDR_ERROR_CONTROL", "QUAL_ENABLE"                , 0x00010018, 1 , 1 },
{"WLAN_APB_ADDR_ERROR_CONTROL", "ENABLE"                     , 0x00010018, 0 , 0 },
{"WLAN_APB_ADDR_ERROR_STATUS", "WRITE"                       , 0x0001001c, 25, 25},
{"WLAN_APB_ADDR_ERROR_STATUS", "ADDRESS"                     , 0x0001001c, 24, 0 },
{"WLAN_AHB_ADDR_ERROR_CONTROL", "ENABLE"                     , 0x00010020, 0 , 0 },
{"WLAN_AHB_ADDR_ERROR_STATUS", "MAC"                         , 0x00010024, 31, 31},
{"WLAN_AHB_ADDR_ERROR_STATUS", "ADDRESS"                     , 0x00010024, 23, 0 },
{"WLAN_AHB_CONFIG", "MAX_BURST_16"                           , 0x00010028, 2 , 2 },
{"WLAN_AHB_CONFIG", "MAX_BURST_8"                            , 0x00010028, 1 , 1 },
{"WLAN_AHB_CONFIG", "MAX_BURST_4"                            , 0x00010028, 0 , 0 },
{"WLAN_HMASTER", "IDLE_LIMIT"                                , 0x0001002c, 31, 28},
{"WLAN_HMASTER", "LOCK_DET"                                  , 0x0001002c, 3 , 0 },
{"WLAN_HMASTER_STATUS", "LOCK"                               , 0x00010030, 3 , 0 },
{"WLAN_GPIO_OUT_LOW", "DATA"                                 , 0x00014000, 31, 0 },
{"WLAN_GPIO_OUT_W1TS_LOW", "DATA"                            , 0x00014004, 31, 0 },
{"WLAN_GPIO_OUT_W1TC_LOW", "DATA"                            , 0x00014008, 31, 0 },
{"WLAN_GPIO_ENABLE_LOW", "DATA"                              , 0x0001400c, 31, 0 },
{"WLAN_GPIO_ENABLE_W1TS_LOW", "DATA"                         , 0x00014010, 31, 0 },
{"WLAN_GPIO_ENABLE_W1TC_LOW", "DATA"                         , 0x00014014, 31, 0 },
{"WLAN_GPIO_IN_LOW", "DATA"                                  , 0x00014018, 31, 0 },
{"WLAN_GPIO_STATUS_LOW", "INTERRUPT"                         , 0x0001401c, 31, 0 },
{"WLAN_GPIO_STATUS_W1TS_LOW", "INTERRUPT"                    , 0x00014020, 31, 0 },
{"WLAN_GPIO_STATUS_W1TC_LOW", "INTERRUPT"                    , 0x00014024, 31, 0 },
{"WLAN_GPIO_PIN0", "CONFIG"                                  , 0x00014028, 14, 11},
{"WLAN_GPIO_PIN0", "WAKEUP_ENABLE"                           , 0x00014028, 10, 10},
{"WLAN_GPIO_PIN0", "INT_TYPE"                                , 0x00014028, 9 , 7 },
{"WLAN_GPIO_PIN0", "PAD_PULL"                                , 0x00014028, 6 , 5 },
{"WLAN_GPIO_PIN0", "PAD_STRENGTH"                            , 0x00014028, 4 , 3 },
{"WLAN_GPIO_PIN0", "PAD_DRIVER"                              , 0x00014028, 2 , 2 },
{"WLAN_GPIO_PIN0", "SOURCE"                                  , 0x00014028, 0 , 0 },
{"WLAN_GPIO_PIN1", "CONFIG"                                  , 0x0001402c, 14, 11},
{"WLAN_GPIO_PIN1", "WAKEUP_ENABLE"                           , 0x0001402c, 10, 10},
{"WLAN_GPIO_PIN1", "INT_TYPE"                                , 0x0001402c, 9 , 7 },
{"WLAN_GPIO_PIN1", "PAD_PULL"                                , 0x0001402c, 6 , 5 },
{"WLAN_GPIO_PIN1", "PAD_STRENGTH"                            , 0x0001402c, 4 , 3 },
{"WLAN_GPIO_PIN1", "PAD_DRIVER"                              , 0x0001402c, 2 , 2 },
{"WLAN_GPIO_PIN1", "SOURCE"                                  , 0x0001402c, 0 , 0 },
{"WLAN_GPIO_PIN2", "CONFIG"                                  , 0x00014030, 14, 11},
{"WLAN_GPIO_PIN2", "WAKEUP_ENABLE"                           , 0x00014030, 10, 10},
{"WLAN_GPIO_PIN2", "INT_TYPE"                                , 0x00014030, 9 , 7 },
{"WLAN_GPIO_PIN2", "PAD_PULL"                                , 0x00014030, 6 , 5 },
{"WLAN_GPIO_PIN2", "PAD_STRENGTH"                            , 0x00014030, 4 , 3 },
{"WLAN_GPIO_PIN2", "PAD_DRIVER"                              , 0x00014030, 2 , 2 },
{"WLAN_GPIO_PIN2", "SOURCE"                                  , 0x00014030, 0 , 0 },
{"WLAN_GPIO_PIN3", "CONFIG"                                  , 0x00014034, 14, 11},
{"WLAN_GPIO_PIN3", "WAKEUP_ENABLE"                           , 0x00014034, 10, 10},
{"WLAN_GPIO_PIN3", "INT_TYPE"                                , 0x00014034, 9 , 7 },
{"WLAN_GPIO_PIN3", "PAD_PULL"                                , 0x00014034, 6 , 5 },
{"WLAN_GPIO_PIN3", "PAD_STRENGTH"                            , 0x00014034, 4 , 3 },
{"WLAN_GPIO_PIN3", "PAD_DRIVER"                              , 0x00014034, 2 , 2 },
{"WLAN_GPIO_PIN3", "SOURCE"                                  , 0x00014034, 0 , 0 },
{"WLAN_GPIO_PIN4", "CONFIG"                                  , 0x00014038, 14, 11},
{"WLAN_GPIO_PIN4", "WAKEUP_ENABLE"                           , 0x00014038, 10, 10},
{"WLAN_GPIO_PIN4", "INT_TYPE"                                , 0x00014038, 9 , 7 },
{"WLAN_GPIO_PIN4", "PAD_PULL"                                , 0x00014038, 6 , 5 },
{"WLAN_GPIO_PIN4", "PAD_STRENGTH"                            , 0x00014038, 4 , 3 },
{"WLAN_GPIO_PIN4", "PAD_DRIVER"                              , 0x00014038, 2 , 2 },
{"WLAN_GPIO_PIN4", "SOURCE"                                  , 0x00014038, 0 , 0 },
{"WLAN_GPIO_PIN5", "CONFIG"                                  , 0x0001403c, 14, 11},
{"WLAN_GPIO_PIN5", "WAKEUP_ENABLE"                           , 0x0001403c, 10, 10},
{"WLAN_GPIO_PIN5", "INT_TYPE"                                , 0x0001403c, 9 , 7 },
{"WLAN_GPIO_PIN5", "PAD_PULL"                                , 0x0001403c, 6 , 5 },
{"WLAN_GPIO_PIN5", "PAD_STRENGTH"                            , 0x0001403c, 4 , 3 },
{"WLAN_GPIO_PIN5", "PAD_DRIVER"                              , 0x0001403c, 2 , 2 },
{"WLAN_GPIO_PIN5", "SOURCE"                                  , 0x0001403c, 0 , 0 },
{"WLAN_GPIO_PIN6", "CONFIG"                                  , 0x00014040, 14, 11},
{"WLAN_GPIO_PIN6", "WAKEUP_ENABLE"                           , 0x00014040, 10, 10},
{"WLAN_GPIO_PIN6", "INT_TYPE"                                , 0x00014040, 9 , 7 },
{"WLAN_GPIO_PIN6", "PAD_PULL"                                , 0x00014040, 6 , 5 },
{"WLAN_GPIO_PIN6", "PAD_STRENGTH"                            , 0x00014040, 4 , 3 },
{"WLAN_GPIO_PIN6", "PAD_DRIVER"                              , 0x00014040, 2 , 2 },
{"WLAN_GPIO_PIN6", "SOURCE"                                  , 0x00014040, 0 , 0 },
{"WLAN_GPIO_PIN7", "CONFIG"                                  , 0x00014044, 14, 11},
{"WLAN_GPIO_PIN7", "WAKEUP_ENABLE"                           , 0x00014044, 10, 10},
{"WLAN_GPIO_PIN7", "INT_TYPE"                                , 0x00014044, 9 , 7 },
{"WLAN_GPIO_PIN7", "PAD_PULL"                                , 0x00014044, 6 , 5 },
{"WLAN_GPIO_PIN7", "PAD_STRENGTH"                            , 0x00014044, 4 , 3 },
{"WLAN_GPIO_PIN7", "PAD_DRIVER"                              , 0x00014044, 2 , 2 },
{"WLAN_GPIO_PIN7", "PUD_OVERRIDE"                            , 0x00014044, 1 , 1 },
{"WLAN_GPIO_PIN7", "SOURCE"                                  , 0x00014044, 0 , 0 },
{"WLAN_GPIO_PIN8", "CONFIG"                                  , 0x00014048, 14, 11},
{"WLAN_GPIO_PIN8", "WAKEUP_ENABLE"                           , 0x00014048, 10, 10},
{"WLAN_GPIO_PIN8", "INT_TYPE"                                , 0x00014048, 9 , 7 },
{"WLAN_GPIO_PIN8", "PAD_PULL"                                , 0x00014048, 6 , 5 },
{"WLAN_GPIO_PIN8", "PAD_STRENGTH"                            , 0x00014048, 4 , 3 },
{"WLAN_GPIO_PIN8", "PAD_DRIVER"                              , 0x00014048, 2 , 2 },
{"WLAN_GPIO_PIN8", "SOURCE"                                  , 0x00014048, 0 , 0 },
{"WLAN_GPIO_PIN9", "CONFIG"                                  , 0x0001404c, 14, 11},
{"WLAN_GPIO_PIN9", "WAKEUP_ENABLE"                           , 0x0001404c, 10, 10},
{"WLAN_GPIO_PIN9", "INT_TYPE"                                , 0x0001404c, 9 , 7 },
{"WLAN_GPIO_PIN9", "PAD_PULL"                                , 0x0001404c, 6 , 5 },
{"WLAN_GPIO_PIN9", "PAD_STRENGTH"                            , 0x0001404c, 4 , 3 },
{"WLAN_GPIO_PIN9", "PAD_DRIVER"                              , 0x0001404c, 2 , 2 },
{"WLAN_GPIO_PIN9", "SOURCE"                                  , 0x0001404c, 0 , 0 },
{"WLAN_GPIO_PIN10", "CONFIG"                                 , 0x00014050, 14, 11},
{"WLAN_GPIO_PIN10", "WAKEUP_ENABLE"                          , 0x00014050, 10, 10},
{"WLAN_GPIO_PIN10", "INT_TYPE"                               , 0x00014050, 9 , 7 },
{"WLAN_GPIO_PIN10", "PAD_PULL"                               , 0x00014050, 6 , 5 },
{"WLAN_GPIO_PIN10", "PAD_STRENGTH"                           , 0x00014050, 4 , 3 },
{"WLAN_GPIO_PIN10", "PAD_DRIVER"                             , 0x00014050, 2 , 2 },
{"WLAN_GPIO_PIN10", "SOURCE"                                 , 0x00014050, 0 , 0 },
{"WLAN_GPIO_PIN11", "CONFIG"                                 , 0x00014054, 14, 11},
{"WLAN_GPIO_PIN11", "WAKEUP_ENABLE"                          , 0x00014054, 10, 10},
{"WLAN_GPIO_PIN11", "INT_TYPE"                               , 0x00014054, 9 , 7 },
{"WLAN_GPIO_PIN11", "PAD_PULL"                               , 0x00014054, 6 , 5 },
{"WLAN_GPIO_PIN11", "PAD_STRENGTH"                           , 0x00014054, 4 , 3 },
{"WLAN_GPIO_PIN11", "PAD_DRIVER"                             , 0x00014054, 2 , 2 },
{"WLAN_GPIO_PIN11", "SOURCE"                                 , 0x00014054, 0 , 0 },
{"WLAN_GPIO_PIN12", "CONFIG"                                 , 0x00014058, 14, 11},
{"WLAN_GPIO_PIN12", "WAKEUP_ENABLE"                          , 0x00014058, 10, 10},
{"WLAN_GPIO_PIN12", "INT_TYPE"                               , 0x00014058, 9 , 7 },
{"WLAN_GPIO_PIN12", "PAD_PULL"                               , 0x00014058, 6 , 5 },
{"WLAN_GPIO_PIN12", "PAD_STRENGTH"                           , 0x00014058, 4 , 3 },
{"WLAN_GPIO_PIN12", "PAD_DRIVER"                             , 0x00014058, 2 , 2 },
{"WLAN_GPIO_PIN12", "SOURCE"                                 , 0x00014058, 0 , 0 },
{"WLAN_GPIO_PIN13", "CONFIG"                                 , 0x0001405c, 14, 11},
{"WLAN_GPIO_PIN13", "WAKEUP_ENABLE"                          , 0x0001405c, 10, 10},
{"WLAN_GPIO_PIN13", "INT_TYPE"                               , 0x0001405c, 9 , 7 },
{"WLAN_GPIO_PIN13", "PAD_PULL"                               , 0x0001405c, 6 , 5 },
{"WLAN_GPIO_PIN13", "PAD_STRENGTH"                           , 0x0001405c, 4 , 3 },
{"WLAN_GPIO_PIN13", "PAD_DRIVER"                             , 0x0001405c, 2 , 2 },
{"WLAN_GPIO_PIN13", "SOURCE"                                 , 0x0001405c, 0 , 0 },
{"WLAN_GPIO_PIN14", "CONFIG"                                 , 0x00014060, 14, 11},
{"WLAN_GPIO_PIN14", "WAKEUP_ENABLE"                          , 0x00014060, 10, 10},
{"WLAN_GPIO_PIN14", "INT_TYPE"                               , 0x00014060, 9 , 7 },
{"WLAN_GPIO_PIN14", "PAD_PULL"                               , 0x00014060, 6 , 5 },
{"WLAN_GPIO_PIN14", "PAD_STRENGTH"                           , 0x00014060, 4 , 3 },
{"WLAN_GPIO_PIN14", "PAD_DRIVER"                             , 0x00014060, 2 , 2 },
{"WLAN_GPIO_PIN14", "SOURCE"                                 , 0x00014060, 0 , 0 },
{"WLAN_GPIO_PIN15", "CONFIG"                                 , 0x00014064, 14, 11},
{"WLAN_GPIO_PIN15", "WAKEUP_ENABLE"                          , 0x00014064, 10, 10},
{"WLAN_GPIO_PIN15", "INT_TYPE"                               , 0x00014064, 9 , 7 },
{"WLAN_GPIO_PIN15", "PAD_PULL"                               , 0x00014064, 6 , 5 },
{"WLAN_GPIO_PIN15", "PAD_STRENGTH"                           , 0x00014064, 4 , 3 },
{"WLAN_GPIO_PIN15", "PAD_DRIVER"                             , 0x00014064, 2 , 2 },
{"WLAN_GPIO_PIN15", "SOURCE"                                 , 0x00014064, 0 , 0 },
{"WLAN_GPIO_PIN16", "CONFIG"                                 , 0x00014068, 14, 11},
{"WLAN_GPIO_PIN16", "WAKEUP_ENABLE"                          , 0x00014068, 10, 10},
{"WLAN_GPIO_PIN16", "INT_TYPE"                               , 0x00014068, 9 , 7 },
{"WLAN_GPIO_PIN16", "PAD_PULL"                               , 0x00014068, 6 , 5 },
{"WLAN_GPIO_PIN16", "PAD_STRENGTH"                           , 0x00014068, 4 , 3 },
{"WLAN_GPIO_PIN16", "PAD_DRIVER"                             , 0x00014068, 2 , 2 },
{"WLAN_GPIO_PIN16", "PUD_OVERRIDE"                           , 0x00014068, 1 , 1 },
{"WLAN_GPIO_PIN16", "SOURCE"                                 , 0x00014068, 0 , 0 },
{"WLAN_GPIO_PIN17", "CONFIG"                                 , 0x0001406c, 14, 11},
{"WLAN_GPIO_PIN17", "WAKEUP_ENABLE"                          , 0x0001406c, 10, 10},
{"WLAN_GPIO_PIN17", "INT_TYPE"                               , 0x0001406c, 9 , 7 },
{"WLAN_GPIO_PIN17", "PAD_PULL"                               , 0x0001406c, 6 , 5 },
{"WLAN_GPIO_PIN17", "PAD_STRENGTH"                           , 0x0001406c, 4 , 3 },
{"WLAN_GPIO_PIN17", "PAD_DRIVER"                             , 0x0001406c, 2 , 2 },
{"WLAN_GPIO_PIN17", "PUD_OVERRIDE"                           , 0x0001406c, 1 , 1 },
{"WLAN_GPIO_PIN17", "SOURCE"                                 , 0x0001406c, 0 , 0 },
{"WLAN_GPIO_PIN18", "WAKEUP_ENABLE"                          , 0x00014070, 10, 10},
{"WLAN_GPIO_PIN18", "INT_TYPE"                               , 0x00014070, 9 , 7 },
{"WLAN_GPIO_PIN18", "PAD_STRENGTH"                           , 0x00014070, 4 , 3 },
{"WLAN_GPIO_PIN18", "PAD_DRIVER"                             , 0x00014070, 2 , 2 },
{"WLAN_GPIO_PIN18", "SOURCE"                                 , 0x00014070, 0 , 0 },
{"WLAN_GPIO_PIN19", "CONFIG"                                 , 0x00014074, 14, 11},
{"WLAN_GPIO_PIN19", "WAKEUP_ENABLE"                          , 0x00014074, 10, 10},
{"WLAN_GPIO_PIN19", "INT_TYPE"                               , 0x00014074, 9 , 7 },
{"WLAN_GPIO_PIN19", "PAD_PULL"                               , 0x00014074, 6 , 5 },
{"WLAN_GPIO_PIN19", "PAD_STRENGTH"                           , 0x00014074, 4 , 3 },
{"WLAN_GPIO_PIN19", "PAD_DRIVER"                             , 0x00014074, 2 , 2 },
{"WLAN_GPIO_PIN19", "SOURCE"                                 , 0x00014074, 0 , 0 },
{"WLAN_GPIO_PIN20", "CONFIG"                                 , 0x00014078, 14, 11},
{"WLAN_GPIO_PIN20", "WAKEUP_ENABLE"                          , 0x00014078, 10, 10},
{"WLAN_GPIO_PIN20", "INT_TYPE"                               , 0x00014078, 9 , 7 },
{"WLAN_GPIO_PIN20", "PAD_PULL"                               , 0x00014078, 6 , 5 },
{"WLAN_GPIO_PIN20", "PAD_STRENGTH"                           , 0x00014078, 4 , 3 },
{"WLAN_GPIO_PIN20", "PAD_DRIVER"                             , 0x00014078, 2 , 2 },
{"WLAN_GPIO_PIN20", "SOURCE"                                 , 0x00014078, 0 , 0 },
{"WLAN_GPIO_PIN21", "CONFIG"                                 , 0x0001407c, 14, 11},
{"WLAN_GPIO_PIN21", "WAKEUP_ENABLE"                          , 0x0001407c, 10, 10},
{"WLAN_GPIO_PIN21", "INT_TYPE"                               , 0x0001407c, 9 , 7 },
{"WLAN_GPIO_PIN21", "PAD_PULL"                               , 0x0001407c, 6 , 5 },
{"WLAN_GPIO_PIN21", "PAD_STRENGTH"                           , 0x0001407c, 4 , 3 },
{"WLAN_GPIO_PIN21", "PAD_DRIVER"                             , 0x0001407c, 2 , 2 },
{"WLAN_GPIO_PIN21", "SOURCE"                                 , 0x0001407c, 0 , 0 },
{"WLAN_GPIO_PIN22", "CONFIG"                                 , 0x00014080, 14, 11},
{"WLAN_GPIO_PIN22", "WAKEUP_ENABLE"                          , 0x00014080, 10, 10},
{"WLAN_GPIO_PIN22", "INT_TYPE"                               , 0x00014080, 9 , 7 },
{"WLAN_GPIO_PIN22", "PAD_PULL"                               , 0x00014080, 6 , 5 },
{"WLAN_GPIO_PIN22", "PAD_STRENGTH"                           , 0x00014080, 4 , 3 },
{"WLAN_GPIO_PIN22", "PAD_DRIVER"                             , 0x00014080, 2 , 2 },
{"WLAN_GPIO_PIN22", "SOURCE"                                 , 0x00014080, 0 , 0 },
{"WLAN_GPIO_PIN23", "CONFIG"                                 , 0x00014084, 14, 11},
{"WLAN_GPIO_PIN23", "WAKEUP_ENABLE"                          , 0x00014084, 10, 10},
{"WLAN_GPIO_PIN23", "INT_TYPE"                               , 0x00014084, 9 , 7 },
{"WLAN_GPIO_PIN23", "PAD_PULL"                               , 0x00014084, 6 , 5 },
{"WLAN_GPIO_PIN23", "PAD_STRENGTH"                           , 0x00014084, 4 , 3 },
{"WLAN_GPIO_PIN23", "PAD_DRIVER"                             , 0x00014084, 2 , 2 },
{"WLAN_GPIO_PIN23", "SOURCE"                                 , 0x00014084, 0 , 0 },
{"WL_SOC_APB", "TOGGLE"                                      , 0x00014088, 0 , 0 },
{"WLAN_SIGMA_DELTA", "ENABLE"                                , 0x0001408c, 16, 16},
{"WLAN_SIGMA_DELTA", "PRESCALAR"                             , 0x0001408c, 15, 8 },
{"WLAN_SIGMA_DELTA", "TARGET"                                , 0x0001408c, 7 , 0 },
{"WL_BOOTSTRAP", "LOAD_FIRMWARE_FROM_ATE"                    , 0x00014090, 25, 25},
{"WL_BOOTSTRAP", "CPU_MBIST_EN"                              , 0x00014090, 24, 24},
{"WL_BOOTSTRAP", "STATUS"                                    , 0x00014090, 23, 0 },
{"WLAN_DEBUG_CONTROL", "COEX"                                , 0x00014094, 3 , 1 },
{"WLAN_DEBUG_CONTROL", "ENABLE"                              , 0x00014094, 0 , 0 },
{"WLAN_DEBUG_INPUT_SEL", "SHIFT"                             , 0x00014098, 5 , 4 },
{"WLAN_DEBUG_INPUT_SEL", "SRC"                               , 0x00014098, 3 , 0 },
{"WLAN_DEBUG_OUT", "DATA"                                    , 0x0001409c, 17, 0 },
{"ANTENNA_CONTROL", "RX_CLEAR"                               , 0x000140a0, 20, 20},
{"ANTENNA_CONTROL", "SPI_CS"                                 , 0x000140a0, 19, 19},
{"ANTENNA_CONTROL", "SPI_MODE"                               , 0x000140a0, 18, 18},
{"ANTENNA_CONTROL", "LED_SEL"                                , 0x000140a0, 17, 15},
{"ANTENNA_CONTROL", "OVERRIDE"                               , 0x000140a0, 14, 10},
{"ANTENNA_CONTROL", "VALUE"                                  , 0x000140a0, 9 , 5 },
{"ANTENNA_CONTROL", "ENABLE"                                 , 0x000140a0, 4 , 0 },
{"AMBA_DEBUG_BUS", "SEL"                                     , 0x000140a4, 4 , 0 },
{"CPU_MBIST", "BLOCK_FAIL"                                   , 0x000140a8, 10, 2 },
{"CPU_MBIST", "GLOBAL_FAIL"                                  , 0x000140a8, 1 , 1 },
{"CPU_MBIST", "DONE"                                         , 0x000140a8, 0 , 0 },
{"SPDT_CONTROL", "RFSILENT_FORCE"                            , 0x000140ac, 13, 13},
{"SPDT_CONTROL", "BT_OWN"                                    , 0x000140ac, 12, 12},
{"SPDT_CONTROL", "WLAN_IDLE"                                 , 0x000140ac, 11, 8 },
{"SPDT_CONTROL", "WLAN_RX"                                   , 0x000140ac, 7 , 4 },
{"SPDT_CONTROL", "WLAN_TX"                                   , 0x000140ac, 3 , 0 },
{"BT_PINS_OVERRIDE", "UART"                                  , 0x000140b0, 2 , 2 },
{"BT_PINS_OVERRIDE", "HIGH"                                  , 0x000140b0, 1 , 1 },
{"BT_PINS_OVERRIDE", "LOW"                                   , 0x000140b0, 0 , 0 },
{"CLOCK_OBS_MUX", "SEL"                                      , 0x000140b4, 1 , 0 },
{"GPIO_SPARE0", "BITS"                                       , 0x000140b8, 31, 0 },
{"GPIO_SPARE1", "BITS"                                       , 0x000140bc, 31, 0 },
{"RXTXBB1_CH1", "SPARE"                                      , 0x0001c000, 31, 19},
{"RXTXBB1_CH1", "FNOTCH"                                     , 0x0001c000, 18, 17},
{"RXTXBB1_CH1", "SEL_ATB"                                    , 0x0001c000, 16, 9 },
{"RXTXBB1_CH1", "PDDACINTERFACE"                             , 0x0001c000, 8 , 8 },
{"RXTXBB1_CH1", "PDV2I"                                      , 0x0001c000, 7 , 7 },
{"RXTXBB1_CH1", "PDI2V"                                      , 0x0001c000, 6 , 6 },
{"RXTXBB1_CH1", "PDRXTXBB"                                   , 0x0001c000, 5 , 5 },
{"RXTXBB1_CH1", "PDOFFSETLOQ"                                , 0x0001c000, 4 , 4 },
{"RXTXBB1_CH1", "PDOFFSETHIQ"                                , 0x0001c000, 3 , 3 },
{"RXTXBB1_CH1", "PDOFFSETI2V"                                , 0x0001c000, 2 , 2 },
{"RXTXBB1_CH1", "PDLOQ"                                      , 0x0001c000, 1 , 1 },
{"RXTXBB1_CH1", "PDHIQ"                                      , 0x0001c000, 0 , 0 },
{"rxrf_b0_RXRFSA_BIAS1", "PWD_BIAS"                          , 0x0001c000, 31, 31},
{"rxrf_b0_RXRFSA_BIAS1", "PWD_IC75LNA2G"                     , 0x0001c000, 30, 28},
{"rxrf_b0_RXRFSA_BIAS1", "PWD_IC25MXR2GH"                    , 0x0001c000, 27, 25},
{"rxrf_b0_RXRFSA_BIAS1", "PWD_IR25LO24"                      , 0x0001c000, 24, 22},
{"rxrf_b0_RXRFSA_BIAS1", "PWD_IC75LNA5G"                     , 0x0001c000, 21, 19},
{"rxrf_b0_RXRFSA_BIAS1", "PWD_IC25VGA5G"                     , 0x0001c000, 18, 16},
{"rxrf_b0_RXRFSA_BIAS1", "PWD_IC25MXR5GH"                    , 0x0001c000, 15, 13},
{"rxrf_b0_RXRFSA_BIAS1", "PWD_IC25MXR2_5GH"                  , 0x0001c000, 12, 10},
{"rxrf_b0_RXRFSA_BIAS1", "PWD_IC25LO36"                      , 0x0001c000, 9 , 7 },
{"rxrf_b0_RXRFSA_BIAS1", "PWD_IR25LO18"                      , 0x0001c000, 6 , 4 },
{"rxrf_b0_RXRFSA_BIAS1", "PWD_IR25SPARE"                     , 0x0001c000, 3 , 1 },
{"rxrf_b0_RXRFSA_BIAS1", "SPARE"                             , 0x0001c000, 0 , 0 },
{"RXTXBB2_CH1", "IBN_37P5_OSHI_CTRL"                         , 0x0001c004, 31, 29},
{"RXTXBB2_CH1", "IBN_37P5_OSLO_CTRL"                         , 0x0001c004, 28, 26},
{"RXTXBB2_CH1", "IBN_37P5_OSI2V_CTRL"                        , 0x0001c004, 25, 23},
{"RXTXBB2_CH1", "SPARE"                                      , 0x0001c004, 22, 21},
{"RXTXBB2_CH1", "SHORTBUFFER"                                , 0x0001c004, 20, 20},
{"RXTXBB2_CH1", "SELBUFFER"                                  , 0x0001c004, 19, 19},
{"RXTXBB2_CH1", "SEL_DAC_TEST"                               , 0x0001c004, 18, 18},
{"RXTXBB2_CH1", "SEL_LOQ_TEST"                               , 0x0001c004, 17, 17},
{"RXTXBB2_CH1", "SEL_HIQ_TEST"                               , 0x0001c004, 16, 16},
{"RXTXBB2_CH1", "SEL_I2V_TEST"                               , 0x0001c004, 15, 15},
{"RXTXBB2_CH1", "CMSEL"                                      , 0x0001c004, 14, 13},
{"RXTXBB2_CH1", "FILTERFC"                                   , 0x0001c004, 12, 8 },
{"RXTXBB2_CH1", "LOCALFILTERTUNING"                          , 0x0001c004, 7 , 7 },
{"RXTXBB2_CH1", "FILTERDOUBLEBW"                             , 0x0001c004, 6 , 6 },
{"RXTXBB2_CH1", "PATH2HIQ_EN"                                , 0x0001c004, 5 , 5 },
{"RXTXBB2_CH1", "PATH1HIQ_EN"                                , 0x0001c004, 4 , 4 },
{"RXTXBB2_CH1", "PATH3LOQ_EN"                                , 0x0001c004, 3 , 3 },
{"RXTXBB2_CH1", "PATH2LOQ_EN"                                , 0x0001c004, 2 , 2 },
{"RXTXBB2_CH1", "PATH1LOQ_EN"                                , 0x0001c004, 1 , 1 },
{"RXTXBB2_CH1", "PATH_OVERRIDE"                              , 0x0001c004, 0 , 0 },
{"rxrf_b0_RXRFSA_BIAS2", "PWD_IR25VCM"                       , 0x0001c004, 31, 29},
{"rxrf_b0_RXRFSA_BIAS2", "PWD_IC25VCMBUF"                    , 0x0001c004, 28, 26},
{"rxrf_b0_RXRFSA_BIAS2", "PWD_IC25AGC"                       , 0x0001c004, 25, 23},
{"rxrf_b0_RXRFSA_BIAS2", "PWD_IR25AGC"                       , 0x0001c004, 22, 20},
{"rxrf_b0_RXRFSA_BIAS2", "PWD_IR25AGCH"                      , 0x0001c004, 19, 17},
{"rxrf_b0_RXRFSA_BIAS2", "PWD_IC25LNABUF"                    , 0x0001c004, 16, 14},
{"rxrf_b0_RXRFSA_BIAS2", "PWD_IR25SPARE"                     , 0x0001c004, 13, 11},
{"rxrf_b0_RXRFSA_BIAS2", "PWD_IR25SPAREH"                    , 0x0001c004, 10, 8 },
{"rxrf_b0_RXRFSA_BIAS2", "PWD_VCMBUF"                        , 0x0001c004, 7 , 7 },
{"rxrf_b0_RXRFSA_BIAS2", "VCMVALUE"                          , 0x0001c004, 6 , 4 },
{"rxrf_b0_RXRFSA_BIAS2", "PKEN"                              , 0x0001c004, 3 , 0 },
{"RXTXBB3_CH1", "SPARE"                                      , 0x0001c008, 31, 27},
{"RXTXBB3_CH1", "IBN_25U_CM_BUFAMP_CTRL"                     , 0x0001c008, 26, 24},
{"RXTXBB3_CH1", "IBN_25U_BKV2I_CTRL"                         , 0x0001c008, 23, 21},
{"RXTXBB3_CH1", "IBN_25U_I2V_CTRL"                           , 0x0001c008, 20, 18},
{"RXTXBB3_CH1", "IBN_25U_HI1_CTRL"                           , 0x0001c008, 17, 15},
{"RXTXBB3_CH1", "IBN_25U_HI2_CTRL"                           , 0x0001c008, 14, 12},
{"RXTXBB3_CH1", "IBN_25U_LO1_CTRL"                           , 0x0001c008, 11, 9 },
{"RXTXBB3_CH1", "IBN_25U_LO2_CTRL"                           , 0x0001c008, 8 , 6 },
{"RXTXBB3_CH1", "IBRN_12P5_CM_CTRL"                          , 0x0001c008, 5 , 3 },
{"RXTXBB3_CH1", "IBN_100U_TEST_CTRL"                         , 0x0001c008, 2 , 0 },
{"rxrf_b0_RXRFSA_GAINSTAGES", "RX_OVERRIDE"                  , 0x0001c008, 31, 31},
{"rxrf_b0_RXRFSA_GAINSTAGES", "LNA2G_GAIN_OVR"               , 0x0001c008, 30, 28},
{"rxrf_b0_RXRFSA_GAINSTAGES", "MXR2G_GAIN_OVR"               , 0x0001c008, 27, 26},
{"rxrf_b0_RXRFSA_GAINSTAGES", "LNA5G_GAIN_OVR"               , 0x0001c008, 25, 23},
{"rxrf_b0_RXRFSA_GAINSTAGES", "VGA5G_GAIN_OVR"               , 0x0001c008, 22, 20},
{"rxrf_b0_RXRFSA_GAINSTAGES", "MXR5G_GAIN_OVR"               , 0x0001c008, 19, 18},
{"rxrf_b0_RXRFSA_GAINSTAGES", "PWD_LNA2G"                    , 0x0001c008, 17, 17},
{"rxrf_b0_RXRFSA_GAINSTAGES", "PWD_MXR2G"                    , 0x0001c008, 16, 16},
{"rxrf_b0_RXRFSA_GAINSTAGES", "PWD_LO2G"                     , 0x0001c008, 15, 15},
{"rxrf_b0_RXRFSA_GAINSTAGES", "LNA2G_LP"                     , 0x0001c008, 14, 14},
{"rxrf_b0_RXRFSA_GAINSTAGES", "LNA2G_SHORTINP"               , 0x0001c008, 13, 13},
{"rxrf_b0_RXRFSA_GAINSTAGES", "LNA2G_CAP"                    , 0x0001c008, 12, 11},
{"rxrf_b0_RXRFSA_GAINSTAGES", "PWD_LNA5G"                    , 0x0001c008, 10, 10},
{"rxrf_b0_RXRFSA_GAINSTAGES", "PWD_MXR5G"                    , 0x0001c008, 9 , 9 },
{"rxrf_b0_RXRFSA_GAINSTAGES", "PWD_VGA5G"                    , 0x0001c008, 8 , 8 },
{"rxrf_b0_RXRFSA_GAINSTAGES", "PWD_LO5G"                     , 0x0001c008, 7 , 7 },
{"rxrf_b0_RXRFSA_GAINSTAGES", "LNA5G_SHORTINP"               , 0x0001c008, 6 , 6 },
{"rxrf_b0_RXRFSA_GAINSTAGES", "LNA5G_CAP"                    , 0x0001c008, 5 , 4 },
{"rxrf_b0_RXRFSA_GAINSTAGES", "VGA5G_CAP"                    , 0x0001c008, 3 , 2 },
{"rxrf_b0_RXRFSA_GAINSTAGES", "LNAON_CALDC"                  , 0x0001c008, 1 , 1 },
{"rxrf_b0_RXRFSA_GAINSTAGES", "SPARE"                        , 0x0001c008, 0 , 0 },
{"RXTXBB4_CH1", "SPARE"                                      , 0x0001c00c, 31, 31},
{"RXTXBB4_CH1", "LOCALOFFSET"                                , 0x0001c00c, 30, 30},
{"RXTXBB4_CH1", "OFSTCORRHII"                                , 0x0001c00c, 29, 25},
{"RXTXBB4_CH1", "OFSTCORRHIQ"                                , 0x0001c00c, 24, 20},
{"RXTXBB4_CH1", "OFSTCORRLOI"                                , 0x0001c00c, 19, 15},
{"RXTXBB4_CH1", "OFSTCORRLOQ"                                , 0x0001c00c, 14, 10},
{"RXTXBB4_CH1", "OFSTCORRI2VI"                               , 0x0001c00c, 9 , 5 },
{"RXTXBB4_CH1", "OFSTCORRI2VQ"                               , 0x0001c00c, 4 , 0 },
{"rxrf_b0_RXRFSA_AGC", "AGC_OVERRIDE"                        , 0x0001c00c, 31, 31},
{"rxrf_b0_RXRFSA_AGC", "AGC_ON_OVR"                          , 0x0001c00c, 30, 30},
{"rxrf_b0_RXRFSA_AGC", "AGC_CAL_OVR"                         , 0x0001c00c, 29, 29},
{"rxrf_b0_RXRFSA_AGC", "AGC2G_DBDAC_OVR"                     , 0x0001c00c, 28, 25},
{"rxrf_b0_RXRFSA_AGC", "AGC2G_CALDAC_OVR"                    , 0x0001c00c, 24, 19},
{"rxrf_b0_RXRFSA_AGC", "AGC5G_DBDAC_OVR"                     , 0x0001c00c, 18, 15},
{"rxrf_b0_RXRFSA_AGC", "AGC5G_CALDAC_OVR"                    , 0x0001c00c, 14, 9 },
{"rxrf_b0_RXRFSA_AGC", "AGC_FALL_CTRL"                       , 0x0001c00c, 8 , 6 },
{"rxrf_b0_RXRFSA_AGC", "PWD_LNABUF"                          , 0x0001c00c, 5 , 5 },
{"rxrf_b0_RXRFSA_AGC", "LNABUF_PWD_OVR"                      , 0x0001c00c, 4 , 4 },
{"rxrf_b0_RXRFSA_AGC", "LNABUFGAIN2X"                        , 0x0001c00c, 3 , 3 },
{"rxrf_b0_RXRFSA_AGC", "AGC_OUT"                             , 0x0001c00c, 2 , 2 },
{"rxrf_b0_RXRFSA_AGC", "RF2G_ON_DURING_CALPA"                , 0x0001c00c, 1 , 1 },
{"rxrf_b0_RXRFSA_AGC", "RF5G_ON_DURING_CALPA"                , 0x0001c00c, 0 , 0 },
{"RF2G1_CH1", "PDIC25U_LNA"                                  , 0x0001c010, 31, 29},
{"RF2G1_CH1", "DB"                                           , 0x0001c010, 28, 26},
{"RF2G1_CH1", "OB"                                           , 0x0001c010, 25, 23},
{"RF2G1_CH1", "LOATB_SEL"                                    , 0x0001c010, 22, 20},
{"RF2G1_CH1", "RXATB_SEL"                                    , 0x0001c010, 19, 17},
{"RF2G1_CH1", "TXATB_SEL"                                    , 0x0001c010, 16, 14},
{"RF2G1_CH1", "LOCONTROL"                                    , 0x0001c010, 13, 13},
{"RF2G1_CH1", "PACA_SEL"                                     , 0x0001c010, 12, 11},
{"RF2G1_CH1", "PDIC25U_VGM"                                  , 0x0001c010, 10, 8 },
{"RF2G1_CH1", "REGLNA_BYPASS"                                , 0x0001c010, 7 , 7 },
{"RF2G1_CH1", "REGLO_BYPASS"                                 , 0x0001c010, 6 , 6 },
{"RF2G1_CH1", "SPARES"                                       , 0x0001c010, 5 , 0 },
{"rxrf_b0_RXRFSA_BIAS3", "PWD_IC50AIC"                       , 0x0001c010, 31, 29},
{"rxrf_b0_RXRFSA_BIAS3", "PWD_IC50LNABUF2G"                  , 0x0001c010, 28, 26},
{"rxrf_b0_RXRFSA_BIAS3", "PWD_IC25SPARE"                     , 0x0001c010, 25, 23},
{"rxrf_b0_RXRFSA_BIAS3", "MXRFORCEDON"                       , 0x0001c010, 22, 22},
{"rxrf_b0_RXRFSA_BIAS3", "BT_LNA_CNT_OVR"                    , 0x0001c010, 21, 21},
{"rxrf_b0_RXRFSA_BIAS3", "USE_BT_LNA"                        , 0x0001c010, 20, 20},
{"rxrf_b0_RXRFSA_BIAS3", "PWD_AICGM"                         , 0x0001c010, 19, 19},
{"rxrf_b0_RXRFSA_BIAS3", "PWD_AICGM_OVR"                     , 0x0001c010, 18, 18},
{"rxrf_b0_RXRFSA_BIAS3", "AICSTBY_ENABLE"                    , 0x0001c010, 17, 17},
{"rxrf_b0_RXRFSA_BIAS3", "AICSTBY_VGAON_ENABLE"              , 0x0001c010, 16, 16},
{"rxrf_b0_RXRFSA_BIAS3", "KEEPLNABUF2GCASCON"                , 0x0001c010, 15, 15},
{"rxrf_b0_RXRFSA_BIAS3", "shortbiasres_div2grx"              , 0x0001c010, 14, 14},
{"rxrf_b0_RXRFSA_BIAS3", "shortbiasres_div5grx"              , 0x0001c010, 13, 13},
{"rxrf_b0_RXRFSA_BIAS3", "CONTROLSPARE"                      , 0x0001c010, 12, 0 },
{"RF2G2_CH1", "PDLNA"                                        , 0x0001c014, 31, 31},
{"RF2G2_CH1", "PDDIV"                                        , 0x0001c014, 30, 30},
{"RF2G2_CH1", "PDPADRV"                                      , 0x0001c014, 29, 29},
{"RF2G2_CH1", "PDPAOUT"                                      , 0x0001c014, 28, 28},
{"RF2G2_CH1", "PDREGLNA"                                     , 0x0001c014, 27, 27},
{"RF2G2_CH1", "PDREGLO"                                      , 0x0001c014, 26, 26},
{"RF2G2_CH1", "PDVGM"                                        , 0x0001c014, 25, 25},
{"RF2G2_CH1", "PDRXLO"                                       , 0x0001c014, 24, 24},
{"RF2G2_CH1", "PDTXLO"                                       , 0x0001c014, 23, 23},
{"RF2G2_CH1", "PDTXMIX"                                      , 0x0001c014, 22, 22},
{"RF2G2_CH1", "PDIR25U_TXMIX"                                , 0x0001c014, 21, 19},
{"RF2G2_CH1", "PDIR25U_TXPA"                                 , 0x0001c014, 18, 18},
{"RF2G2_CH1", "PDIC25U_TXPA"                                 , 0x0001c014, 17, 15},
{"RF2G2_CH1", "PDIC25U_TXRF"                                 , 0x0001c014, 14, 12},
{"RF2G2_CH1", "PDIC25U_RXRF"                                 , 0x0001c014, 11, 9 },
{"RF2G2_CH1", "PDIC50U_DIV"                                  , 0x0001c014, 8 , 6 },
{"RF2G2_CH1", "PDIC25U_VREGLO"                               , 0x0001c014, 5 , 3 },
{"RF2G2_CH1", "PDIR25U_VREGLO"                               , 0x0001c014, 2 , 0 },
{"RF5G1_CH1", "PDTXLO5"                                      , 0x0001c018, 31, 31},
{"RF5G1_CH1", "PDTXMIX5"                                     , 0x0001c018, 30, 30},
{"RF5G1_CH1", "PDTXBUF5"                                     , 0x0001c018, 29, 29},
{"RF5G1_CH1", "PDPADRV5"                                     , 0x0001c018, 28, 28},
{"RF5G1_CH1", "PDPAOUT5"                                     , 0x0001c018, 27, 27},
{"RF5G1_CH1", "PACASCBIAS"                                   , 0x0001c018, 26, 25},
{"RF5G1_CH1", "PWDTXPKD"                                     , 0x0001c018, 24, 22},
{"RF5G1_CH1", "DB5"                                          , 0x0001c018, 21, 19},
{"RF5G1_CH1", "OB5"                                          , 0x0001c018, 18, 16},
{"RF5G1_CH1", "TX5_ATB_SEL"                                  , 0x0001c018, 15, 13},
{"RF5G1_CH1", "LO5CONTROL"                                   , 0x0001c018, 12, 12},
{"RF5G1_CH1", "REGLO_BYPASS5"                                , 0x0001c018, 11, 11},
{"RF5G1_CH1", "PDREGLO5"                                     , 0x0001c018, 10, 10},
{"RF5G1_CH1", "SPARE"                                        , 0x0001c018, 9 , 0 },
{"RF5G2_CH1", "REGFE_BYPASS5"                                , 0x0001c01c, 31, 31},
{"RF5G2_CH1", "PDREGFE5"                                     , 0x0001c01c, 30, 30},
{"RF5G2_CH1", "PDRXLO5"                                      , 0x0001c01c, 29, 29},
{"RF5G2_CH1", "PDVGM5"                                       , 0x0001c01c, 28, 28},
{"RF5G2_CH1", "PDCSLNA5"                                     , 0x0001c01c, 27, 27},
{"RF5G2_CH1", "PDRFVGA5"                                     , 0x0001c01c, 26, 26},
{"RF5G2_CH1", "RX5_ATB_SEL"                                  , 0x0001c01c, 25, 23},
{"RF5G2_CH1", "PDBIRTXMIX"                                   , 0x0001c01c, 22, 20},
{"RF5G2_CH1", "PDBIRTXPA"                                    , 0x0001c01c, 19, 17},
{"RF5G2_CH1", "PDBIR1"                                       , 0x0001c01c, 16, 14},
{"RF5G2_CH1", "PDBIR2"                                       , 0x0001c01c, 13, 11},
{"RF5G2_CH1", "SPARE"                                        , 0x0001c01c, 10, 0 },
{"RF5G3_CH1", "PDBICTXBUF"                                   , 0x0001c020, 31, 29},
{"RF5G3_CH1", "PDBICTXPA"                                    , 0x0001c020, 28, 26},
{"RF5G3_CH1", "PDBICTXMIX"                                   , 0x0001c020, 25, 23},
{"RF5G3_CH1", "PDBIC1"                                       , 0x0001c020, 22, 20},
{"RF5G3_CH1", "PDBIC2"                                       , 0x0001c020, 19, 17},
{"RF5G3_CH1", "PDBIC3"                                       , 0x0001c020, 16, 14},
{"RF5G3_CH1", "PDBIBCLNA"                                    , 0x0001c020, 13, 11},
{"RF5G3_CH1", "PDBIBCRFVGA"                                  , 0x0001c020, 10, 8 },
{"RF5G3_CH1", "PDBIBCVGM"                                    , 0x0001c020, 7 , 5 },
{"RF5G3_CH1", "SPARE"                                        , 0x0001c020, 4 , 0 },
{"RXTXBB1_CH0", "SPARE"                                      , 0x0001c024, 31, 19},
{"RXTXBB1_CH0", "FNOTCH"                                     , 0x0001c024, 18, 17},
{"RXTXBB1_CH0", "SEL_ATB"                                    , 0x0001c024, 16, 9 },
{"RXTXBB1_CH0", "PDDACINTERFACE"                             , 0x0001c024, 8 , 8 },
{"RXTXBB1_CH0", "PDV2I"                                      , 0x0001c024, 7 , 7 },
{"RXTXBB1_CH0", "PDI2V"                                      , 0x0001c024, 6 , 6 },
{"RXTXBB1_CH0", "PDRXTXBB"                                   , 0x0001c024, 5 , 5 },
{"RXTXBB1_CH0", "PDOFFSETLOQ"                                , 0x0001c024, 4 , 4 },
{"RXTXBB1_CH0", "PDOFFSETHIQ"                                , 0x0001c024, 3 , 3 },
{"RXTXBB1_CH0", "PDOFFSETI2V"                                , 0x0001c024, 2 , 2 },
{"RXTXBB1_CH0", "PDLOQ"                                      , 0x0001c024, 1 , 1 },
{"RXTXBB1_CH0", "PDHIQ"                                      , 0x0001c024, 0 , 0 },
{"RXTXBB2_CH0", "IBN_37P5_OSHI_CTRL"                         , 0x0001c028, 31, 29},
{"RXTXBB2_CH0", "IBN_37P5_OSLO_CTRL"                         , 0x0001c028, 28, 26},
{"RXTXBB2_CH0", "IBN_37P5_OSI2V_CTRL"                        , 0x0001c028, 25, 23},
{"RXTXBB2_CH0", "SPARE"                                      , 0x0001c028, 22, 21},
{"RXTXBB2_CH0", "SHORTBUFFER"                                , 0x0001c028, 20, 20},
{"RXTXBB2_CH0", "SELBUFFER"                                  , 0x0001c028, 19, 19},
{"RXTXBB2_CH0", "SEL_DAC_TEST"                               , 0x0001c028, 18, 18},
{"RXTXBB2_CH0", "SEL_LOQ_TEST"                               , 0x0001c028, 17, 17},
{"RXTXBB2_CH0", "SEL_HIQ_TEST"                               , 0x0001c028, 16, 16},
{"RXTXBB2_CH0", "SEL_I2V_TEST"                               , 0x0001c028, 15, 15},
{"RXTXBB2_CH0", "CMSEL"                                      , 0x0001c028, 14, 13},
{"RXTXBB2_CH0", "FILTERFC"                                   , 0x0001c028, 12, 8 },
{"RXTXBB2_CH0", "LOCALFILTERTUNING"                          , 0x0001c028, 7 , 7 },
{"RXTXBB2_CH0", "FILTERDOUBLEBW"                             , 0x0001c028, 6 , 6 },
{"RXTXBB2_CH0", "PATH2HIQ_EN"                                , 0x0001c028, 5 , 5 },
{"RXTXBB2_CH0", "PATH1HIQ_EN"                                , 0x0001c028, 4 , 4 },
{"RXTXBB2_CH0", "PATH3LOQ_EN"                                , 0x0001c028, 3 , 3 },
{"RXTXBB2_CH0", "PATH2LOQ_EN"                                , 0x0001c028, 2 , 2 },
{"RXTXBB2_CH0", "PATH1LOQ_EN"                                , 0x0001c028, 1 , 1 },
{"RXTXBB2_CH0", "PATH_OVERRIDE"                              , 0x0001c028, 0 , 0 },
{"RXTXBB3_CH0", "SPARE"                                      , 0x0001c02c, 31, 27},
{"RXTXBB3_CH0", "IBN_25U_CM_BUFAMP_CTRL"                     , 0x0001c02c, 26, 24},
{"RXTXBB3_CH0", "IBN_25U_BKV2I_CTRL"                         , 0x0001c02c, 23, 21},
{"RXTXBB3_CH0", "IBN_25U_I2V_CTRL"                           , 0x0001c02c, 20, 18},
{"RXTXBB3_CH0", "IBN_25U_HI1_CTRL"                           , 0x0001c02c, 17, 15},
{"RXTXBB3_CH0", "IBN_25U_HI2_CTRL"                           , 0x0001c02c, 14, 12},
{"RXTXBB3_CH0", "IBN_25U_LO1_CTRL"                           , 0x0001c02c, 11, 9 },
{"RXTXBB3_CH0", "IBN_25U_LO2_CTRL"                           , 0x0001c02c, 8 , 6 },
{"RXTXBB3_CH0", "IBRN_12P5_CM_CTRL"                          , 0x0001c02c, 5 , 3 },
{"RXTXBB3_CH0", "IBN_100U_TEST_CTRL"                         , 0x0001c02c, 2 , 0 },
{"RXTXBB4_CH0", "SPARE"                                      , 0x0001c030, 31, 31},
{"RXTXBB4_CH0", "LOCALOFFSET"                                , 0x0001c030, 30, 30},
{"RXTXBB4_CH0", "OFSTCORRHII"                                , 0x0001c030, 29, 25},
{"RXTXBB4_CH0", "OFSTCORRHIQ"                                , 0x0001c030, 24, 20},
{"RXTXBB4_CH0", "OFSTCORRLOI"                                , 0x0001c030, 19, 15},
{"RXTXBB4_CH0", "OFSTCORRLOQ"                                , 0x0001c030, 14, 10},
{"RXTXBB4_CH0", "OFSTCORRI2VI"                               , 0x0001c030, 9 , 5 },
{"RXTXBB4_CH0", "OFSTCORRI2VQ"                               , 0x0001c030, 4 , 0 },
{"RF5G1_CH0", "PDTXLO5"                                      , 0x0001c034, 31, 31},
{"RF5G1_CH0", "PDTXMIX5"                                     , 0x0001c034, 30, 30},
{"RF5G1_CH0", "PDTXBUF5"                                     , 0x0001c034, 29, 29},
{"RF5G1_CH0", "PDPADRV5"                                     , 0x0001c034, 28, 28},
{"RF5G1_CH0", "PDPAOUT5"                                     , 0x0001c034, 27, 27},
{"RF5G1_CH0", "PACASCBIAS"                                   , 0x0001c034, 26, 25},
{"RF5G1_CH0", "PWDTXPKD"                                     , 0x0001c034, 24, 22},
{"RF5G1_CH0", "DB5"                                          , 0x0001c034, 21, 19},
{"RF5G1_CH0", "OB5"                                          , 0x0001c034, 18, 16},
{"RF5G1_CH0", "TX5_ATB_SEL"                                  , 0x0001c034, 15, 13},
{"RF5G1_CH0", "LO5CONTROL"                                   , 0x0001c034, 12, 12},
{"RF5G1_CH0", "REGLO_BYPASS5"                                , 0x0001c034, 11, 11},
{"RF5G1_CH0", "PDREGLO5"                                     , 0x0001c034, 10, 10},
{"RF5G1_CH0", "SPARE"                                        , 0x0001c034, 9 , 0 },
{"RF5G2_CH0", "REGFE_BYPASS5"                                , 0x0001c038, 31, 31},
{"RF5G2_CH0", "PDREGFE5"                                     , 0x0001c038, 30, 30},
{"RF5G2_CH0", "PDRXLO5"                                      , 0x0001c038, 29, 29},
{"RF5G2_CH0", "PDVGM5"                                       , 0x0001c038, 28, 28},
{"RF5G2_CH0", "PDCSLNA5"                                     , 0x0001c038, 27, 27},
{"RF5G2_CH0", "PDRFVGA5"                                     , 0x0001c038, 26, 26},
{"RF5G2_CH0", "RX5_ATB_SEL"                                  , 0x0001c038, 25, 23},
{"RF5G2_CH0", "PDBIRTXMIX"                                   , 0x0001c038, 22, 20},
{"RF5G2_CH0", "PDBIRTXPA"                                    , 0x0001c038, 19, 17},
{"RF5G2_CH0", "PDBIR1"                                       , 0x0001c038, 16, 14},
{"RF5G2_CH0", "PDBIR2"                                       , 0x0001c038, 13, 11},
{"RF5G2_CH0", "SPARE"                                        , 0x0001c038, 10, 0 },
{"RF5G3_CH0", "PDBICTXBUF"                                   , 0x0001c03c, 31, 29},
{"RF5G3_CH0", "PDBICTXPA"                                    , 0x0001c03c, 28, 26},
{"RF5G3_CH0", "PDBICTXMIX"                                   , 0x0001c03c, 25, 23},
{"RF5G3_CH0", "PDBIC1"                                       , 0x0001c03c, 22, 20},
{"RF5G3_CH0", "PDBIC2"                                       , 0x0001c03c, 19, 17},
{"RF5G3_CH0", "PDBIC3"                                       , 0x0001c03c, 16, 14},
{"RF5G3_CH0", "PDBIBCLNA"                                    , 0x0001c03c, 13, 11},
{"RF5G3_CH0", "PDBIBCRFVGA"                                  , 0x0001c03c, 10, 8 },
{"RF5G3_CH0", "PDBIBCVGM"                                    , 0x0001c03c, 7 , 5 },
{"RF5G3_CH0", "SPARE"                                        , 0x0001c03c, 4 , 0 },
{"RF2G1_CH0", "PDIC25U_LNA"                                  , 0x0001c040, 31, 29},
{"RF2G1_CH0", "DB"                                           , 0x0001c040, 28, 26},
{"RF2G1_CH0", "OB"                                           , 0x0001c040, 25, 23},
{"RF2G1_CH0", "LOATB_SEL"                                    , 0x0001c040, 22, 20},
{"RF2G1_CH0", "RXATB_SEL"                                    , 0x0001c040, 19, 17},
{"RF2G1_CH0", "TXATB_SEL"                                    , 0x0001c040, 16, 14},
{"RF2G1_CH0", "LOCONTROL"                                    , 0x0001c040, 13, 13},
{"RF2G1_CH0", "PACA_SEL"                                     , 0x0001c040, 12, 11},
{"RF2G1_CH0", "PDIC25U_VGM"                                  , 0x0001c040, 10, 8 },
{"RF2G1_CH0", "REGLNA_BYPASS"                                , 0x0001c040, 7 , 7 },
{"RF2G1_CH0", "REGLO_BYPASS"                                 , 0x0001c040, 6 , 6 },
{"RF2G1_CH0", "SPARES"                                       , 0x0001c040, 5 , 0 },
{"txrf_b0_TXRFSA1", "localtxgain2G"                          , 0x0001c040, 31, 31},
{"txrf_b0_TXRFSA1", "padrvgn2G"                              , 0x0001c040, 30, 24},
{"txrf_b0_TXRFSA1", "LOdiv2Gforced"                          , 0x0001c040, 23, 23},
{"txrf_b0_TXRFSA1", "LObuf2Gforced"                          , 0x0001c040, 22, 22},
{"txrf_b0_TXRFSA1", "pdlodiv2G"                              , 0x0001c040, 21, 21},
{"txrf_b0_TXRFSA1", "pdlobuf2G"                              , 0x0001c040, 20, 20},
{"txrf_b0_TXRFSA1", "pdmxr2G"                                , 0x0001c040, 19, 19},
{"txrf_b0_TXRFSA1", "pdDR2G"                                 , 0x0001c040, 18, 18},
{"txrf_b0_TXRFSA1", "pdout2G"                                , 0x0001c040, 17, 17},
{"txrf_b0_TXRFSA1", "localtxgain5G"                          , 0x0001c040, 16, 16},
{"txrf_b0_TXRFSA1", "padrv3gn5G"                             , 0x0001c040, 15, 12},
{"txrf_b0_TXRFSA1", "padrv2gn5G_main"                        , 0x0001c040, 11, 9 },
{"txrf_b0_TXRFSA1", "padrv2gn5G_aux1"                        , 0x0001c040, 8 , 6 },
{"txrf_b0_TXRFSA1", "padrv2gn5G_aux2"                        , 0x0001c040, 5 , 3 },
{"txrf_b0_TXRFSA1", "reserved_PA2G"                          , 0x0001c040, 2 , 0 },
{"RF2G2_CH0", "PDLNA"                                        , 0x0001c044, 31, 31},
{"RF2G2_CH0", "PDDIV"                                        , 0x0001c044, 30, 30},
{"RF2G2_CH0", "PDPADRV"                                      , 0x0001c044, 29, 29},
{"RF2G2_CH0", "PDPAOUT"                                      , 0x0001c044, 28, 28},
{"RF2G2_CH0", "PDREGLNA"                                     , 0x0001c044, 27, 27},
{"RF2G2_CH0", "PDREGLO"                                      , 0x0001c044, 26, 26},
{"RF2G2_CH0", "PDVGM"                                        , 0x0001c044, 25, 25},
{"RF2G2_CH0", "PDRXLO"                                       , 0x0001c044, 24, 24},
{"RF2G2_CH0", "PDTXLO"                                       , 0x0001c044, 23, 23},
{"RF2G2_CH0", "PDTXMIX"                                      , 0x0001c044, 22, 22},
{"RF2G2_CH0", "PDIR25U_TXMIX"                                , 0x0001c044, 21, 19},
{"RF2G2_CH0", "PDIR25U_TXPA"                                 , 0x0001c044, 18, 18},
{"RF2G2_CH0", "PDIC25U_TXPA"                                 , 0x0001c044, 17, 15},
{"RF2G2_CH0", "PDIC25U_TXRF"                                 , 0x0001c044, 14, 12},
{"RF2G2_CH0", "PDIC25U_RXRF"                                 , 0x0001c044, 11, 9 },
{"RF2G2_CH0", "PDIC50U_DIV"                                  , 0x0001c044, 8 , 6 },
{"RF2G2_CH0", "PDIC25U_VREGLO"                               , 0x0001c044, 5 , 3 },
{"RF2G2_CH0", "PDIR25U_VREGLO"                               , 0x0001c044, 2 , 0 },
{"txrf_b0_TXRFSA2", "pdmxr5G"                                , 0x0001c044, 31, 31},
{"txrf_b0_TXRFSA2", "LOdiv5Gforced"                          , 0x0001c044, 30, 30},
{"txrf_b0_TXRFSA2", "LObuf5Gforced"                          , 0x0001c044, 29, 29},
{"txrf_b0_TXRFSA2", "pdlodiv5G"                              , 0x0001c044, 28, 28},
{"txrf_b0_TXRFSA2", "pdlobuf5G"                              , 0x0001c044, 27, 27},
{"txrf_b0_TXRFSA2", "pdout5G"                                , 0x0001c044, 26, 24},
{"txrf_b0_TXRFSA2", "db2G"                                   , 0x0001c044, 23, 21},
{"txrf_b0_TXRFSA2", "ob2G_cck"                               , 0x0001c044, 20, 18},
{"txrf_b0_TXRFSA2", "ob2G_psk"                               , 0x0001c044, 17, 15},
{"txrf_b0_TXRFSA2", "ob2G_qam"                               , 0x0001c044, 14, 12},
{"txrf_b0_TXRFSA2", "ob2G_softpd"                            , 0x0001c044, 11, 9 },
{"txrf_b0_TXRFSA2", "dcas2G"                                 , 0x0001c044, 8 , 6 },
{"txrf_b0_TXRFSA2", "ocas2G_wlan"                            , 0x0001c044, 5 , 3 },
{"txrf_b0_TXRFSA2", "reserved_PA2G"                          , 0x0001c044, 2 , 0 },
{"SYNTH1", "PWD_BIAS"                                        , 0x0001c048, 31, 31},
{"SYNTH1", "PWD_CP"                                          , 0x0001c048, 30, 30},
{"SYNTH1", "PWD_VCMON"                                       , 0x0001c048, 29, 29},
{"SYNTH1", "PWD_VCO"                                         , 0x0001c048, 28, 28},
{"SYNTH1", "PWD_PRESC"                                       , 0x0001c048, 27, 27},
{"SYNTH1", "PWD_LOBUF2G"                                     , 0x0001c048, 26, 26},
{"SYNTH1", "PWD_LOBUF5G"                                     , 0x0001c048, 25, 25},
{"SYNTH1", "PWD_LODIV"                                       , 0x0001c048, 24, 24},
{"SYNTH1", "PWD_LOMIX"                                       , 0x0001c048, 23, 23},
{"SYNTH1", "PWUP_LOREF"                                      , 0x0001c048, 22, 22},
{"SYNTH1", "VCOREGBYPASS"                                    , 0x0001c048, 21, 21},
{"SYNTH1", "VCOREGLEVEL"                                     , 0x0001c048, 20, 19},
{"SYNTH1", "VCOBUFBIAS"                                      , 0x0001c048, 18, 17},
{"SYNTH1", "PWUP_VCOBUF_PD"                                  , 0x0001c048, 16, 16},
{"SYNTH1", "PWUP_LOBUF2G_PD"                                 , 0x0001c048, 15, 15},
{"SYNTH1", "PWUP_LOBUF5G_PD"                                 , 0x0001c048, 14, 14},
{"SYNTH1", "PWUP_LODIV_PD"                                   , 0x0001c048, 13, 13},
{"SYNTH1", "PWUP_LOMIX_PD"                                   , 0x0001c048, 12, 12},
{"SYNTH1", "MONITOR_FB"                                      , 0x0001c048, 11, 11},
{"SYNTH1", "MONITOR_REF"                                     , 0x0001c048, 10, 10},
{"SYNTH1", "MONITOR_FB_DIV2"                                 , 0x0001c048, 9 , 9 },
{"SYNTH1", "MONITOR_VC2HIGH"                                 , 0x0001c048, 8 , 8 },
{"SYNTH1", "MONITOR_VC2LOW"                                  , 0x0001c048, 7 , 7 },
{"SYNTH1", "MONITOR_SYNTHLOCKVCOK"                           , 0x0001c048, 6 , 6 },
{"SYNTH1", "CON_VDDVCOREG"                                   , 0x0001c048, 5 , 5 },
{"SYNTH1", "CON_IVCOREG"                                     , 0x0001c048, 4 , 4 },
{"SYNTH1", "CON_IVCOBUF"                                     , 0x0001c048, 3 , 3 },
{"SYNTH1", "SEL_VCMONABUS"                                   , 0x0001c048, 2 , 0 },
{"txrf_b0_TXRFSA3", "obdboffst2G_aux1"                       , 0x0001c048, 31, 29},
{"txrf_b0_TXRFSA3", "obdboffst2G_aux2"                       , 0x0001c048, 28, 26},
{"txrf_b0_TXRFSA3", "d3b5G"                                  , 0x0001c048, 25, 23},
{"txrf_b0_TXRFSA3", "d2b5G"                                  , 0x0001c048, 22, 20},
{"txrf_b0_TXRFSA3", "ob5G_cck"                               , 0x0001c048, 19, 17},
{"txrf_b0_TXRFSA3", "ob5G_psk"                               , 0x0001c048, 16, 14},
{"txrf_b0_TXRFSA3", "ob5G_qam"                               , 0x0001c048, 13, 11},
{"txrf_b0_TXRFSA3", "obdboffst5G_aux1"                       , 0x0001c048, 10, 8 },
{"txrf_b0_TXRFSA3", "obdboffst5G_aux2"                       , 0x0001c048, 7 , 5 },
{"txrf_b0_TXRFSA3", "d3cas5G"                                , 0x0001c048, 4 , 2 },
{"txrf_b0_TXRFSA3", "reserved_3"                             , 0x0001c048, 1 , 0 },
{"SYNTH2", "VC_CAL_REF"                                      , 0x0001c04c, 31, 29},
{"SYNTH2", "VC_HI_REF"                                       , 0x0001c04c, 28, 26},
{"SYNTH2", "VC_MID_REF"                                      , 0x0001c04c, 25, 23},
{"SYNTH2", "VC_LOW_REF"                                      , 0x0001c04c, 22, 20},
{"SYNTH2", "CPBIAS"                                          , 0x0001c04c, 19, 18},
{"SYNTH2", "CPSTEERING_EN_INTN"                              , 0x0001c04c, 17, 17},
{"SYNTH2", "CPLOWLK"                                         , 0x0001c04c, 16, 16},
{"SYNTH2", "LOOPLEAKCUR"                                     , 0x0001c04c, 15, 12},
{"SYNTH2", "CAPRANGE1"                                       , 0x0001c04c, 11, 8 },
{"SYNTH2", "CAPRANGE2"                                       , 0x0001c04c, 7 , 4 },
{"SYNTH2", "CAPRANGE3"                                       , 0x0001c04c, 3 , 0 },
{"txrf_b0_TXRFSA4", "d1cas5G_main"                           , 0x0001c04c, 31, 29},
{"txrf_b0_TXRFSA4", "d1cas5G_aux1"                           , 0x0001c04c, 28, 26},
{"txrf_b0_TXRFSA4", "d1cas5G_aux2"                           , 0x0001c04c, 25, 23},
{"txrf_b0_TXRFSA4", "d2cas5G_main"                           , 0x0001c04c, 22, 20},
{"txrf_b0_TXRFSA4", "d2cas5G_aux1"                           , 0x0001c04c, 19, 17},
{"txrf_b0_TXRFSA4", "d2cas5G_aux2"                           , 0x0001c04c, 16, 14},
{"txrf_b0_TXRFSA4", "btob_wlan"                              , 0x0001c04c, 13, 11},
{"txrf_b0_TXRFSA4", "btob_softpd_wlan"                       , 0x0001c04c, 10, 8 },
{"txrf_b0_TXRFSA4", "PAforcedon_WLAN"                        , 0x0001c04c, 7 , 7 },
{"txrf_b0_TXRFSA4", "usebtob_wlansr"                         , 0x0001c04c, 6 , 6 },
{"txrf_b0_TXRFSA4", "pwd_ic25aic"                            , 0x0001c04c, 5 , 3 },
{"txrf_b0_TXRFSA4", "pwd_ic25spare"                          , 0x0001c04c, 2 , 0 },
{"SYNTH3", "DIS_CLK_XTAL"                                    , 0x0001c050, 31, 31},
{"SYNTH3", "SEL_CLK_DIV2"                                    , 0x0001c050, 30, 30},
{"SYNTH3", "WAIT_SHORTR_PWRUP"                               , 0x0001c050, 29, 24},
{"SYNTH3", "WAIT_PWRUP"                                      , 0x0001c050, 23, 18},
{"SYNTH3", "WAIT_CAL_BIN"                                    , 0x0001c050, 17, 12},
{"SYNTH3", "WAIT_CAL_LIN"                                    , 0x0001c050, 11, 6 },
{"SYNTH3", "WAIT_VC_CHECK"                                   , 0x0001c050, 5 , 0 },
{"txrf_b0_TXRFSA5", "AICstby_enable"                         , 0x0001c050, 31, 31},
{"txrf_b0_TXRFSA5", "local_AICpwd"                           , 0x0001c050, 30, 30},
{"txrf_b0_TXRFSA5", "pwdAICvgaI_ls"                          , 0x0001c050, 29, 29},
{"txrf_b0_TXRFSA5", "pwdAICvgaQ_ls"                          , 0x0001c050, 28, 28},
{"txrf_b0_TXRFSA5", "csteer_en"                              , 0x0001c050, 27, 27},
{"txrf_b0_TXRFSA5", "reserved7_1"                            , 0x0001c050, 26, 0 },
{"SYNTH4", "DIS_LIN_CAPSEARCH"                               , 0x0001c054, 31, 31},
{"SYNTH4", "DIS_LOSTVC"                                      , 0x0001c054, 30, 30},
{"SYNTH4", "ALWAYS_SHORTR"                                   , 0x0001c054, 29, 29},
{"SYNTH4", "SHORTR_UNTIL_LOCKED"                             , 0x0001c054, 28, 28},
{"SYNTH4", "FORCE_PINVC"                                     , 0x0001c054, 27, 27},
{"SYNTH4", "FORCE_VCOCAP"                                    , 0x0001c054, 26, 26},
{"SYNTH4", "VCOCAP_OVR"                                      , 0x0001c054, 25, 18},
{"SYNTH4", "VCOCAPPULLUP"                                    , 0x0001c054, 17, 17},
{"SYNTH4", "CLKXTAL_EDGE_SEL"                                , 0x0001c054, 16, 16},
{"SYNTH4", "FORCE_LO_ON"                                     , 0x0001c054, 15, 15},
{"SYNTH4", "PFDDELAY_FRACN"                                  , 0x0001c054, 14, 14},
{"SYNTH4", "PFD_DISABLE"                                     , 0x0001c054, 13, 13},
{"SYNTH4", "PRESCSEL"                                        , 0x0001c054, 12, 11},
{"SYNTH4", "RESET_PRESC"                                     , 0x0001c054, 10, 10},
{"SYNTH4", "SDM_DISABLE"                                     , 0x0001c054, 9 , 9 },
{"SYNTH4", "SDM_MODE"                                        , 0x0001c054, 8 , 8 },
{"SYNTH4", "SDM_DITHER"                                      , 0x0001c054, 7 , 6 },
{"SYNTH4", "PSCOUNT_FBSEL"                                   , 0x0001c054, 5 , 5 },
{"SYNTH4", "FORCE_LOBUF5GTUNE"                               , 0x0001c054, 4 , 4 },
{"SYNTH4", "LOBUF5GTUNE_OVR"                                 , 0x0001c054, 3 , 2 },
{"SYNTH4", "LONGSHIFTSEL"                                    , 0x0001c054, 1 , 1 },
{"SYNTH4", "FORCE_SHIFTREG"                                  , 0x0001c054, 0 , 0 },
{"txrf_b0_TXRFSA6", "pdpredist2G"                            , 0x0001c054, 31, 31},
{"txrf_b0_TXRFSA6", "capdiv2G_predist"                       , 0x0001c054, 30, 27},
{"txrf_b0_TXRFSA6", "rdiv2G"                                 , 0x0001c054, 26, 25},
{"txrf_b0_TXRFSA6", "pdpredist5G"                            , 0x0001c054, 24, 24},
{"txrf_b0_TXRFSA6", "capdiv5G"                               , 0x0001c054, 23, 21},
{"txrf_b0_TXRFSA6", "rdiv5G"                                 , 0x0001c054, 20, 19},
{"txrf_b0_TXRFSA6", "caltxshiftovr"                          , 0x0001c054, 18, 18},
{"txrf_b0_TXRFSA6", "caltxshift"                             , 0x0001c054, 17, 17},
{"txrf_b0_TXRFSA6", "db2Gcaltx"                              , 0x0001c054, 16, 14},
{"txrf_b0_TXRFSA6", "padrvgn2Gcaltx"                         , 0x0001c054, 13, 7 },
{"txrf_b0_TXRFSA6", "d3b5Gcaltx"                             , 0x0001c054, 6 , 4 },
{"txrf_b0_TXRFSA6", "pdout5G_3caltx"                         , 0x0001c054, 3 , 3 },
{"txrf_b0_TXRFSA6", "reserved_5"                             , 0x0001c054, 2 , 0 },
{"SYNTH5", "IRCP"                                            , 0x0001c058, 31, 29},
{"SYNTH5", "IRVCMON"                                         , 0x0001c058, 28, 26},
{"SYNTH5", "IRLOPKDET"                                       , 0x0001c058, 25, 23},
{"SYNTH5", "ICPRESC"                                         , 0x0001c058, 22, 20},
{"SYNTH5", "ICLODIV"                                         , 0x0001c058, 19, 17},
{"SYNTH5", "ICLOMIX"                                         , 0x0001c058, 16, 14},
{"SYNTH5", "ICVCOREG"                                        , 0x0001c058, 13, 11},
{"SYNTH5", "ICVCO"                                           , 0x0001c058, 10, 8 },
{"SYNTH5", "ICLOBUF2G"                                       , 0x0001c058, 7 , 5 },
{"SYNTH5", "ICLOBUF5G"                                       , 0x0001c058, 4 , 2 },
{"SYNTH5", "ICPKCOMP"                                        , 0x0001c058, 1 , 0 },
{"txrf_b0_TXRFSA7", "pwd_ic25mixbuf5G"                       , 0x0001c058, 31, 29},
{"txrf_b0_TXRFSA7", "pwd_ir25pa5G1"                          , 0x0001c058, 28, 26},
{"txrf_b0_TXRFSA7", "pwd_ir25pa5G2"                          , 0x0001c058, 25, 23},
{"txrf_b0_TXRFSA7", "pwd_ic25tempsen"                        , 0x0001c058, 22, 20},
{"txrf_b0_TXRFSA7", "pwdWLAN_ic25paBT"                       , 0x0001c058, 19, 17},
{"txrf_b0_TXRFSA7", "pwd_ir25mixdiv2G"                       , 0x0001c058, 16, 14},
{"txrf_b0_TXRFSA7", "pwd_ir25mixbias2G"                      , 0x0001c058, 13, 11},
{"txrf_b0_TXRFSA7", "pwdWLAN_ir25pa2G"                       , 0x0001c058, 10, 8 },
{"txrf_b0_TXRFSA7", "pwd_ir25mixdiv5G"                       , 0x0001c058, 7 , 5 },
{"txrf_b0_TXRFSA7", "AICcapdivmasking_b"                     , 0x0001c058, 4 , 4 },
{"txrf_b0_TXRFSA7", "shortbiasres_div5gtx"                   , 0x0001c058, 3 , 3 },
{"txrf_b0_TXRFSA7", "offst_aux2_m2_21"                       , 0x0001c058, 2 , 1 },
{"txrf_b0_TXRFSA7", "shortbiasres_div2gtx"                   , 0x0001c058, 0 , 0 },
{"SYNTH6", "SYNTH_ON"                                        , 0x0001c05c, 31, 31},
{"SYNTH6", "SYNTH_SM_STATE"                                  , 0x0001c05c, 30, 27},
{"SYNTH6", "CAP_SEARCH"                                      , 0x0001c05c, 26, 26},
{"SYNTH6", "SYNTH_LOCK_VC_OK"                                , 0x0001c05c, 25, 25},
{"SYNTH6", "PIN_VC"                                          , 0x0001c05c, 24, 24},
{"SYNTH6", "VCO_CAP_ST"                                      , 0x0001c05c, 23, 16},
{"SYNTH6", "SHORT_R"                                         , 0x0001c05c, 15, 15},
{"SYNTH6", "RESET_RFD"                                       , 0x0001c05c, 14, 14},
{"SYNTH6", "RESET_PFD"                                       , 0x0001c05c, 13, 13},
{"SYNTH6", "RESET_PSCOUNTERS"                                , 0x0001c05c, 12, 12},
{"SYNTH6", "RESET_SDM_B"                                     , 0x0001c05c, 11, 11},
{"SYNTH6", "VC2HIGH"                                         , 0x0001c05c, 10, 10},
{"SYNTH6", "VC2LOW"                                          , 0x0001c05c, 9 , 9 },
{"SYNTH6", "LOOP_IP"                                         , 0x0001c05c, 8 , 2 },
{"SYNTH6", "LOBUF5GTUNE"                                     , 0x0001c05c, 1 , 0 },
{"txrf_b0_TXRFSA8", "pwd_ir25mixbias5G"                      , 0x0001c05c, 31, 29},
{"txrf_b0_TXRFSA8", "bias_cgm_igsel_pa2G"                    , 0x0001c05c, 28, 25},
{"txrf_b0_TXRFSA8", "bias_cgm_icsel_pa2G"                    , 0x0001c05c, 24, 21},
{"txrf_b0_TXRFSA8", "bias_cgm_igsel_pa5G"                    , 0x0001c05c, 20, 17},
{"txrf_b0_TXRFSA8", "bias_cgm_icsel_pa5G"                    , 0x0001c05c, 16, 13},
{"txrf_b0_TXRFSA8", "pwd_ir25tempsen"                        , 0x0001c05c, 12, 10},
{"txrf_b0_TXRFSA8", "pwd_irspare"                            , 0x0001c05c, 9 , 7 },
{"txrf_b0_TXRFSA8", "shshobdb2G"                             , 0x0001c05c, 6 , 6 },
{"txrf_b0_TXRFSA8", "shshobdb5G"                             , 0x0001c05c, 5 , 5 },
{"txrf_b0_TXRFSA8", "reserved6_2"                            , 0x0001c05c, 4 , 0 },
{"SYNTH7", "LOADSYNTHCHANNEL"                                , 0x0001c060, 31, 31},
{"SYNTH7", "FRACMODE"                                        , 0x0001c060, 30, 30},
{"SYNTH7", "AMODEREFSEL"                                     , 0x0001c060, 29, 28},
{"SYNTH7", "CHANSEL"                                         , 0x0001c060, 27, 19},
{"SYNTH7", "CHANFRAC"                                        , 0x0001c060, 18, 2 },
{"SYNTH7", "FORCE_FRACLSB"                                   , 0x0001c060, 1 , 1 },
{"SYNTH7", "OVRCHANDECODER"                                  , 0x0001c060, 0 , 0 },
{"txrf_b0_TXRFSA9", "pa5g_ind_swTbl"                         , 0x0001c060, 31, 29},
{"txrf_b0_TXRFSA9", "offst_aux2_m2_0"                        , 0x0001c060, 28, 28},
{"txrf_b0_TXRFSA9", "offst_aux2_m1"                          , 0x0001c060, 27, 25},
{"txrf_b0_TXRFSA9", "pa5g_cap_swTbl_01"                      , 0x0001c060, 24, 22},
{"txrf_b0_TXRFSA9", "pa5g_cap_swTbl_10"                      , 0x0001c060, 21, 19},
{"txrf_b0_TXRFSA9", "pa5g_cap_swTbl_11"                      , 0x0001c060, 18, 16},
{"txrf_b0_TXRFSA9", "ATBsel2G"                               , 0x0001c060, 15, 12},
{"txrf_b0_TXRFSA9", "ATBsel5G"                               , 0x0001c060, 11, 8 },
{"txrf_b0_TXRFSA9", "reserved7"                              , 0x0001c060, 7 , 0 },
{"SYNTH8", "REFDIVB"                                         , 0x0001c064, 31, 27},
{"SYNTH8", "LOOP_3RD_ORDER_RB"                               , 0x0001c064, 26, 22},
{"SYNTH8", "LOOP_CPB"                                        , 0x0001c064, 21, 17},
{"SYNTH8", "LOOP_RSB"                                        , 0x0001c064, 16, 12},
{"SYNTH8", "LOOP_CSB"                                        , 0x0001c064, 11, 8 },
{"SYNTH8", "LOOP_ICPB"                                       , 0x0001c064, 7 , 1 },
{"SYNTH8", "CPSTEERING_EN_FRACN"                             , 0x0001c064, 0 , 0 },
{"SYNTH9", "REFDIVA"                                         , 0x0001c068, 31, 27},
{"SYNTH9", "LOOP_3RD_ORDER_RA"                               , 0x0001c068, 26, 22},
{"SYNTH9", "LOOP_CPA0"                                       , 0x0001c068, 21, 17},
{"SYNTH9", "LOOP_RSA0"                                       , 0x0001c068, 16, 12},
{"SYNTH9", "LOOP_CSA0"                                       , 0x0001c068, 11, 8 },
{"SYNTH9", "LOOP_ICPA0"                                      , 0x0001c068, 7 , 4 },
{"SYNTH9", "SLOPE_ICPA0"                                     , 0x0001c068, 3 , 1 },
{"SYNTH9", "PFDDELAY_INTN"                                   , 0x0001c068, 0 , 0 },
{"SYNTH10", "LOOP_CPA1"                                      , 0x0001c06c, 31, 27},
{"SYNTH10", "LOOP_RSA1"                                      , 0x0001c06c, 26, 22},
{"SYNTH10", "LOOP_CSA1"                                      , 0x0001c06c, 21, 18},
{"SYNTH10", "LOOP_ICPA1"                                     , 0x0001c06c, 17, 14},
{"SYNTH10", "SLOPE_ICPA1"                                    , 0x0001c06c, 13, 11},
{"SYNTH10", "SPARE"                                          , 0x0001c06c, 10, 0 },
{"SYNTH11", "LOOP_CPA2"                                      , 0x0001c070, 31, 27},
{"SYNTH11", "LOOP_RSA2"                                      , 0x0001c070, 26, 22},
{"SYNTH11", "LOOP_CSA2"                                      , 0x0001c070, 21, 18},
{"SYNTH11", "LOOP_ICPA2"                                     , 0x0001c070, 17, 14},
{"SYNTH11", "SLOPE_ICPA2"                                    , 0x0001c070, 13, 11},
{"SYNTH11", "CPSTEERING_MODE"                                , 0x0001c070, 10, 10},
{"SYNTH11", "LO2GSEL"                                        , 0x0001c070, 9 , 8 },
{"SYNTH11", "LOREFSEL"                                       , 0x0001c070, 7 , 6 },
{"SYNTH11", "FORCE_LOBUF5G_ON"                               , 0x0001c070, 5 , 5 },
{"SYNTH11", "SPARE"                                          , 0x0001c070, 4 , 0 },
{"BIAS1", "PADON"                                            , 0x0001c074, 31, 31},
{"BIAS1", "SEL_BIAS"                                         , 0x0001c074, 30, 25},
{"BIAS1", "BIAS1_SPARE"                                      , 0x0001c074, 24, 22},
{"BIAS1", "PWD_ICXTAL25"                                     , 0x0001c074, 21, 19},
{"BIAS1", "PWD_IRXTAL25"                                     , 0x0001c074, 18, 16},
{"BIAS1", "PWD_ICXPALDO25"                                   , 0x0001c074, 15, 13},
{"BIAS1", "PWD_IRXPALDO25"                                   , 0x0001c074, 12, 10},
{"BIAS1", "PWD_ICRXLDO25"                                    , 0x0001c074, 9 , 7 },
{"BIAS1", "PWD_IRRXLDO25"                                    , 0x0001c074, 6 , 4 },
{"BIAS1", "PWD_ICPLL25"                                      , 0x0001c074, 3 , 3 },
{"BIAS1", "PWD_IRPLL25"                                      , 0x0001c074, 2 , 2 },
{"BIAS1", "PWD_ICPCIE50"                                     , 0x0001c074, 1 , 1 },
{"BIAS1", "PWD_IRPCIE50"                                     , 0x0001c074, 0 , 0 },
{"BIAS2", "PWD_ICSYNTH50"                                    , 0x0001c078, 31, 31},
{"BIAS2", "PWD_IRSYNTH50"                                    , 0x0001c078, 30, 30},
{"BIAS2", "PWD_ICRF5G50"                                     , 0x0001c078, 29, 29},
{"BIAS2", "PWD_ICRF2G50"                                     , 0x0001c078, 28, 28},
{"BIAS2", "PWD_IRRF5G50"                                     , 0x0001c078, 27, 27},
{"BIAS2", "PWD_IRRF2G50"                                     , 0x0001c078, 26, 26},
{"BIAS2", "PWD_ICBB50"                                       , 0x0001c078, 25, 25},
{"BIAS2", "PWD_IRBB50"                                       , 0x0001c078, 24, 24},
{"BIAS2", "PWD_ICDACINTFACE25"                               , 0x0001c078, 23, 23},
{"BIAS2", "PWD_ICADCCOMPI25"                                 , 0x0001c078, 22, 20},
{"BIAS2", "PWD_ICADCCOMPQ25"                                 , 0x0001c078, 19, 17},
{"BIAS2", "PWD_ICADCREFBUFI12P5"                             , 0x0001c078, 16, 14},
{"BIAS2", "PWD_ICADCREFBUFQ12P5"                             , 0x0001c078, 13, 11},
{"BIAS2", "PWD_ICADCREFOPAMPI25"                             , 0x0001c078, 10, 8 },
{"BIAS2", "PWD_ICADCREFOPAMPQ25"                             , 0x0001c078, 7 , 5 },
{"BIAS2", "PWD_IRADCREFMSTRI12P5"                            , 0x0001c078, 4 , 4 },
{"BIAS2", "PWD_IRADCREFMSTRQ12P5"                            , 0x0001c078, 3 , 3 },
{"BIAS2", "PWD_ICDAC50"                                      , 0x0001c078, 2 , 0 },
{"BIAS3", "PWD_ICTXPC25"                                     , 0x0001c07c, 31, 31},
{"BIAS3", "PWD_IRTXPC25"                                     , 0x0001c07c, 30, 30},
{"BIAS3", "PWD_ICTSENS25"                                    , 0x0001c07c, 29, 29},
{"BIAS3", "PWD_IRTSENS25"                                    , 0x0001c07c, 28, 28},
{"BIAS3", "PWD_IC25SPARE1"                                   , 0x0001c07c, 27, 25},
{"BIAS3", "PWD_IC25SPARE2"                                   , 0x0001c07c, 24, 22},
{"BIAS3", "PWD_IC25SPARE3"                                   , 0x0001c07c, 21, 19},
{"BIAS3", "PWD_IC25SPARE4"                                   , 0x0001c07c, 18, 16},
{"BIAS3", "PWD_IR25SPARE1"                                   , 0x0001c07c, 15, 13},
{"BIAS3", "PWD_IR25SPARE2"                                   , 0x0001c07c, 12, 10},
{"BIAS3", "PWD_IR25SPARE3"                                   , 0x0001c07c, 9 , 7 },
{"BIAS3", "PWD_IR25SPARE4"                                   , 0x0001c07c, 6 , 4 },
{"BIAS3", "PWD_ICLOLDO25"                                    , 0x0001c07c, 3 , 1 },
{"BIAS3", "BIAS3_SPARE"                                      , 0x0001c07c, 0 , 0 },
{"BIAS4", "BIAS4_SEL_SPARE"                                  , 0x0001c080, 31, 24},
{"BIAS4", "PWD_ICXLNA2G50"                                   , 0x0001c080, 23, 21},
{"BIAS4", "PWD_ICXLNA5G50"                                   , 0x0001c080, 20, 18},
{"BIAS4", "PWD_IRLOLDO25"                                    , 0x0001c080, 17, 15},
{"BIAS4", "BIAS4_SPARE"                                      , 0x0001c080, 14, 0 },
{"synth_SYNTH1", "PWD_BIAS"                                  , 0x0001c080, 31, 31},
{"synth_SYNTH1", "PWD_CP"                                    , 0x0001c080, 30, 30},
{"synth_SYNTH1", "PWD_VCMON"                                 , 0x0001c080, 29, 29},
{"synth_SYNTH1", "PWD_VCO"                                   , 0x0001c080, 28, 28},
{"synth_SYNTH1", "PWD_PRESC"                                 , 0x0001c080, 27, 27},
{"synth_SYNTH1", "PWD_LOBUFA2G"                              , 0x0001c080, 26, 26},
{"synth_SYNTH1", "PWD_LOBUFB2G"                              , 0x0001c080, 25, 25},
{"synth_SYNTH1", "SPARE1A"                                   , 0x0001c080, 24, 20},
{"synth_SYNTH1", "PWD_LODIV"                                 , 0x0001c080, 19, 19},
{"synth_SYNTH1", "PWD_LOMIX"                                 , 0x0001c080, 18, 18},
{"synth_SYNTH1", "SEL_VCMON_LOGEN_ABUS"                      , 0x0001c080, 17, 17},
{"synth_SYNTH1", "PWUP_LOGEN_PD"                             , 0x0001c080, 16, 14},
{"synth_SYNTH1", "MONITOR_DLL"                               , 0x0001c080, 13, 12},
{"synth_SYNTH1", "MONITOR_FB"                                , 0x0001c080, 11, 11},
{"synth_SYNTH1", "MONITOR_REF"                               , 0x0001c080, 10, 10},
{"synth_SYNTH1", "MONITOR_FB_DIV2"                           , 0x0001c080, 9 , 9 },
{"synth_SYNTH1", "MONITOR_VC2HIGH"                           , 0x0001c080, 8 , 8 },
{"synth_SYNTH1", "MONITOR_VC2LOW"                            , 0x0001c080, 7 , 7 },
{"synth_SYNTH1", "MONITOR_SYNTHLOCKVCOK"                     , 0x0001c080, 6 , 6 },
{"synth_SYNTH1", "SEL_VCOABUS"                               , 0x0001c080, 5 , 3 },
{"synth_SYNTH1", "SEL_VCMONABUS"                             , 0x0001c080, 2 , 0 },
{"GAIN0", "TX6DBLOQGAIN"                                     , 0x0001c084, 31, 30},
{"GAIN0", "TX1DBLOQGAIN"                                     , 0x0001c084, 29, 27},
{"GAIN0", "TXV2IGAIN"                                        , 0x0001c084, 26, 25},
{"GAIN0", "PABUF5GN"                                         , 0x0001c084, 24, 24},
{"GAIN0", "PADRVGN"                                          , 0x0001c084, 23, 21},
{"GAIN0", "PAOUT2GN"                                         , 0x0001c084, 20, 18},
{"GAIN0", "LNAON"                                            , 0x0001c084, 17, 17},
{"GAIN0", "LNAGAIN"                                          , 0x0001c084, 16, 13},
{"GAIN0", "RFVGA5GAIN"                                       , 0x0001c084, 12, 11},
{"GAIN0", "RFGMGN"                                           , 0x0001c084, 10, 8 },
{"GAIN0", "RX6DBLOQGAIN"                                     , 0x0001c084, 7 , 6 },
{"GAIN0", "RX1DBLOQGAIN"                                     , 0x0001c084, 5 , 3 },
{"GAIN0", "RX6DBHIQGAIN"                                     , 0x0001c084, 2 , 1 },
{"GAIN0", "SPARE"                                            , 0x0001c084, 0 , 0 },
{"synth_SYNTH2", "VC_CAL_REF"                                , 0x0001c084, 31, 29},
{"synth_SYNTH2", "VC_HI_REF"                                 , 0x0001c084, 28, 26},
{"synth_SYNTH2", "VC_MID_REF"                                , 0x0001c084, 25, 23},
{"synth_SYNTH2", "VC_LOW_REF"                                , 0x0001c084, 22, 20},
{"synth_SYNTH2", "BIT_INDEX_SAVE_VCO_CAP"                    , 0x0001c084, 19, 16},
{"synth_SYNTH2", "MODULATELSB"                               , 0x0001c084, 15, 15},
{"synth_SYNTH2", "ENINTERPOLATION"                           , 0x0001c084, 14, 14},
{"synth_SYNTH2", "INTERP_ENABLE_VCO_CAP_CHECK"               , 0x0001c084, 13, 13},
{"synth_SYNTH2", "RESERVED2A"                                , 0x0001c084, 12, 12},
{"synth_SYNTH2", "CENTER_VC_BIN"                             , 0x0001c084, 11, 11},
{"synth_SYNTH2", "CENTER_VC_MON"                             , 0x0001c084, 10, 10},
{"synth_SYNTH2", "SKIP_MON_ALIGN"                            , 0x0001c084, 9 , 9 },
{"synth_SYNTH2", "LIN_SEARCH_STEP_SIZE"                      , 0x0001c084, 8 , 6 },
{"synth_SYNTH2", "SKIPLINCAPSEARCH"                          , 0x0001c084, 5 , 5 },
{"synth_SYNTH2", "DIS_LIN_CAPSEARCH"                         , 0x0001c084, 4 , 4 },
{"synth_SYNTH2", "MAXLINSTEPS"                               , 0x0001c084, 3 , 0 },
{"GAIN1", "TX6DBLOQGAIN"                                     , 0x0001c088, 31, 30},
{"GAIN1", "TX1DBLOQGAIN"                                     , 0x0001c088, 29, 27},
{"GAIN1", "TXV2IGAIN"                                        , 0x0001c088, 26, 25},
{"GAIN1", "PABUF5GN"                                         , 0x0001c088, 24, 24},
{"GAIN1", "PADRVGN"                                          , 0x0001c088, 23, 21},
{"GAIN1", "PAOUT2GN"                                         , 0x0001c088, 20, 18},
{"GAIN1", "LNAON"                                            , 0x0001c088, 17, 17},
{"GAIN1", "LNAGAIN"                                          , 0x0001c088, 16, 13},
{"GAIN1", "RFVGA5GAIN"                                       , 0x0001c088, 12, 11},
{"GAIN1", "RFGMGN"                                           , 0x0001c088, 10, 8 },
{"GAIN1", "RX6DBLOQGAIN"                                     , 0x0001c088, 7 , 6 },
{"GAIN1", "RX1DBLOQGAIN"                                     , 0x0001c088, 5 , 3 },
{"GAIN1", "RX6DBHIQGAIN"                                     , 0x0001c088, 2 , 1 },
{"GAIN1", "SPARE"                                            , 0x0001c088, 0 , 0 },
{"synth_SYNTH3", "DIS_CLK_XTAL"                              , 0x0001c088, 31, 31},
{"synth_SYNTH3", "SEL_CLK_DIV2"                              , 0x0001c088, 30, 30},
{"synth_SYNTH3", "WAIT_SHORTR_PWRUP"                         , 0x0001c088, 29, 24},
{"synth_SYNTH3", "WAIT_PWRUP"                                , 0x0001c088, 23, 18},
{"synth_SYNTH3", "WAIT_VCO_SETTLE_EXTRA"                     , 0x0001c088, 17, 12},
{"synth_SYNTH3", "WAIT_CAL_LIN"                              , 0x0001c088, 11, 6 },
{"synth_SYNTH3", "WAIT_VC_CHECK"                             , 0x0001c088, 5 , 0 },
{"TOP0", "LOCALTXGAIN"                                       , 0x0001c08c, 31, 31},
{"TOP0", "LOCALRXGAIN"                                       , 0x0001c08c, 30, 30},
{"TOP0", "LOCALMODE"                                         , 0x0001c08c, 29, 29},
{"TOP0", "CALFC"                                             , 0x0001c08c, 28, 27},
{"TOP0", "CALDC"                                             , 0x0001c08c, 26, 25},
{"TOP0", "CAL_RESIDUE"                                       , 0x0001c08c, 24, 23},
{"TOP0", "CALTX"                                             , 0x0001c08c, 22, 21},
{"TOP0", "BMODE"                                             , 0x0001c08c, 20, 20},
{"TOP0", "BMODERXTX"                                         , 0x0001c08c, 19, 18},
{"TOP0", "TURBOMODE"                                         , 0x0001c08c, 17, 17},
{"TOP0", "SYNTHON"                                           , 0x0001c08c, 16, 16},
{"TOP0", "RXON"                                              , 0x0001c08c, 15, 14},
{"TOP0", "TXON"                                              , 0x0001c08c, 13, 12},
{"TOP0", "PAON"                                              , 0x0001c08c, 11, 10},
{"TOP0", "XLNAON"                                            , 0x0001c08c, 9 , 8 },
{"TOP0", "XPAON"                                             , 0x0001c08c, 7 , 7 },
{"TOP0", "LOCALXTAL"                                         , 0x0001c08c, 6 , 6 },
{"TOP0", "PWDCLKIN"                                          , 0x0001c08c, 5 , 5 },
{"TOP0", "OSCON"                                             , 0x0001c08c, 4 , 4 },
{"TOP0", "SCLKEN_FORCE"                                      , 0x0001c08c, 3 , 3 },
{"TOP0", "SYNTHON_FORCE"                                     , 0x0001c08c, 2 , 2 },
{"TOP0", "PWDBIAS"                                           , 0x0001c08c, 1 , 1 },
{"TOP0", "FORCEMSBLOW"                                       , 0x0001c08c, 0 , 0 },
{"synth_SYNTH4", "WAIT_PIN_VC_EXTRA"                         , 0x0001c08c, 31, 28},
{"synth_SYNTH4", "RESERVED4A"                                , 0x0001c08c, 27, 27},
{"synth_SYNTH4", "DIS_LOSTVC"                                , 0x0001c08c, 26, 26},
{"synth_SYNTH4", "ALWAYS_SHORTR"                             , 0x0001c08c, 25, 25},
{"synth_SYNTH4", "SHORTR_UNTIL_LOCKED"                       , 0x0001c08c, 24, 24},
{"synth_SYNTH4", "FORCE_PINVC"                               , 0x0001c08c, 23, 23},
{"synth_SYNTH4", "FORCE_VCOCAP"                              , 0x0001c08c, 22, 22},
{"synth_SYNTH4", "VCOCAP_OVR"                                , 0x0001c08c, 21, 12},
{"synth_SYNTH4", "CNT_WITH_FORCE_CAP"                        , 0x0001c08c, 11, 11},
{"synth_SYNTH4", "CLKXTAL_EDGE_SEL_D"                        , 0x0001c08c, 10, 10},
{"synth_SYNTH4", "FORCE_LO_ON"                               , 0x0001c08c, 9 , 9 },
{"synth_SYNTH4", "FBWIDTH"                                   , 0x0001c08c, 8 , 7 },
{"synth_SYNTH4", "DELCLKSD"                                  , 0x0001c08c, 6 , 6 },
{"synth_SYNTH4", "PFD_DISABLE"                               , 0x0001c08c, 5 , 5 },
{"synth_SYNTH4", "SDM_DISABLE"                               , 0x0001c08c, 4 , 4 },
{"synth_SYNTH4", "SDM_MODE"                                  , 0x0001c08c, 3 , 3 },
{"synth_SYNTH4", "SDM_SPARE1"                                , 0x0001c08c, 2 , 2 },
{"synth_SYNTH4", "LO5GIBIAS"                                 , 0x0001c08c, 1 , 0 },
{"TOP1", "REVID"                                             , 0x0001c090, 31, 29},
{"TOP1", "INT2PAD"                                           , 0x0001c090, 28, 28},
{"TOP1", "INTH2PAD"                                          , 0x0001c090, 27, 27},
{"TOP1", "PAD2GND"                                           , 0x0001c090, 26, 26},
{"TOP1", "INT2GND"                                           , 0x0001c090, 25, 25},
{"TOP1", "LOCALADDAC"                                        , 0x0001c090, 24, 24},
{"TOP1", "PWDPLL"                                            , 0x0001c090, 23, 23},
{"TOP1", "PWDADC"                                            , 0x0001c090, 22, 21},
{"TOP1", "PWDDAC"                                            , 0x0001c090, 20, 19},
{"TOP1", "DACLPMODE"                                         , 0x0001c090, 18, 18},
{"TOP1", "INV_CLK160_ADC"                                    , 0x0001c090, 17, 17},
{"TOP1", "PLL_ATB"                                           , 0x0001c090, 16, 15},
{"TOP1", "PLL_FILTER"                                        , 0x0001c090, 14, 7 },
{"TOP1", "PLL_ICP"                                           , 0x0001c090, 6 , 4 },
{"TOP1", "PLL_SCLAMP"                                        , 0x0001c090, 3 , 1 },
{"TOP1", "PLL_SVREG"                                         , 0x0001c090, 0 , 0 },
{"synth_SYNTH5", "SDM_SPARE2"                                , 0x0001c090, 31, 30},
{"synth_SYNTH5", "LO48BUF_ATB"                               , 0x0001c090, 29, 29},
{"synth_SYNTH5", "BIASVCO"                                   , 0x0001c090, 28, 25},
{"synth_SYNTH5", "SPARE5B"                                   , 0x0001c090, 24, 22},
{"synth_SYNTH5", "PRECH_VCO_REF"                             , 0x0001c090, 21, 19},
{"synth_SYNTH5", "EN_PRECH_VCO"                              , 0x0001c090, 18, 18},
{"synth_SYNTH5", "LO5GIBIAS_CH0"                             , 0x0001c090, 17, 16},
{"synth_SYNTH5", "USEVCOCAPIN"                               , 0x0001c090, 15, 15},
{"synth_SYNTH5", "VCOCAPIN"                                  , 0x0001c090, 14, 5 },
{"synth_SYNTH5", "LSBOVERLAPVALUE"                           , 0x0001c090, 4 , 0 },
{"TOP2", "XPABIAS_LVL"                                       , 0x0001c094, 31, 30},
{"TOP2", "FORCE_XLDO_ON"                                     , 0x0001c094, 29, 29},
{"TOP2", "XLNABUFMODE"                                       , 0x0001c094, 28, 28},
{"TOP2", "XLNAISEL"                                          , 0x0001c094, 27, 26},
{"TOP2", "XLNABUFIN"                                         , 0x0001c094, 25, 25},
{"TOP2", "NOTCXODET"                                         , 0x0001c094, 24, 24},
{"TOP2", "PWDXINPAD"                                         , 0x0001c094, 23, 23},
{"TOP2", "PWDCLKIND"                                         , 0x0001c094, 22, 22},
{"TOP2", "LOCALBIAS"                                         , 0x0001c094, 21, 21},
{"TOP2", "LOCALBIAS2X"                                       , 0x0001c094, 20, 20},
{"TOP2", "XTALDIV"                                           , 0x0001c094, 19, 18},
{"TOP2", "TXPC_NEGOUT"                                       , 0x0001c094, 17, 17},
{"TOP2", "TXPC_TEST"                                         , 0x0001c094, 16, 16},
{"TOP2", "TXPC_TESTDAC"                                      , 0x0001c094, 15, 10},
{"TOP2", "TXPC_TESTGAIN"                                     , 0x0001c094, 9 , 8 },
{"TOP2", "TXPC_TESTPWD"                                      , 0x0001c094, 7 , 7 },
{"TOP2", "TXPC_XPDBS"                                        , 0x0001c094, 6 , 4 },
{"TOP2", "TXPC_CLKDELAY"                                     , 0x0001c094, 3 , 3 },
{"TOP2", "DATAOUTSEL"                                        , 0x0001c094, 2 , 1 },
{"TOP2", "BYPASSVREGLO"                                      , 0x0001c094, 0 , 0 },
{"synth_SYNTH6", "SYNTH_ON"                                  , 0x0001c094, 31, 31},
{"synth_SYNTH6", "SYNTH_SM_STATE"                            , 0x0001c094, 30, 27},
{"synth_SYNTH6", "CAP_SEARCH"                                , 0x0001c094, 26, 26},
{"synth_SYNTH6", "SYNTH_LOCK_VC_OK"                          , 0x0001c094, 25, 25},
{"synth_SYNTH6", "SYNTH_IS_LOCKED"                           , 0x0001c094, 24, 24},
{"synth_SYNTH6", "PIN_VC"                                    , 0x0001c094, 23, 23},
{"synth_SYNTH6", "VCO_CAP_ST"                                , 0x0001c094, 22, 13},
{"synth_SYNTH6", "SHORT_R"                                   , 0x0001c094, 12, 12},
{"synth_SYNTH6", "RESET_PFD"                                 , 0x0001c094, 11, 11},
{"synth_SYNTH6", "RESET_PSCOUNTERS"                          , 0x0001c094, 10, 10},
{"synth_SYNTH6", "RESET_SDM_B"                               , 0x0001c094, 9 , 9 },
{"synth_SYNTH6", "VC2HIGH"                                   , 0x0001c094, 8 , 8 },
{"synth_SYNTH6", "VC2LOW"                                    , 0x0001c094, 7 , 7 },
{"synth_SYNTH6", "DLLVC2HI"                                  , 0x0001c094, 6 , 6 },
{"synth_SYNTH6", "DLLVC2LO"                                  , 0x0001c094, 5 , 5 },
{"synth_SYNTH6", "RESERVED6A"                                , 0x0001c094, 4 , 0 },
{"TOP3", "LOCALPLLDIV"                                       , 0x0001c098, 31, 31},
{"TOP3", "PLLREFDIVA"                                        , 0x0001c098, 30, 27},
{"TOP3", "PLLREFDIVB"                                        , 0x0001c098, 26, 23},
{"TOP3", "PLLFBDIVA"                                         , 0x0001c098, 22, 13},
{"TOP3", "PLLFBDIVB"                                         , 0x0001c098, 12, 3 },
{"TOP3", "VREGLO_ATBSEL"                                     , 0x0001c098, 2 , 0 },
{"synth_SYNTH7", "LOADSYNTHCHANNEL"                          , 0x0001c098, 31, 31},
{"synth_SYNTH7", "FRACMODE"                                  , 0x0001c098, 30, 30},
{"synth_SYNTH7", "BANDSEL5G"                                 , 0x0001c098, 29, 28},
{"synth_SYNTH7", "SPARE7A"                                   , 0x0001c098, 27, 27},
{"synth_SYNTH7", "CHANSEL"                                   , 0x0001c098, 26, 19},
{"synth_SYNTH7", "CHANFRAC"                                  , 0x0001c098, 18, 2 },
{"synth_SYNTH7", "FORCE_FRACLSB"                             , 0x0001c098, 1 , 1 },
{"synth_SYNTH7", "OVRCHANDECODER"                            , 0x0001c098, 0 , 0 },
{"synth_SYNTH8", "REFMULTB"                                  , 0x0001c09c, 31, 29},
{"synth_SYNTH8", "DLLVCOCAPB"                                , 0x0001c09c, 28, 26},
{"synth_SYNTH8", "DLLVCOCURB"                                , 0x0001c09c, 25, 23},
{"synth_SYNTH8", "LOOP_3RD_ORDER_RB"                         , 0x0001c09c, 22, 20},
{"synth_SYNTH8", "KVCOB"                                     , 0x0001c09c, 19, 17},
{"synth_SYNTH8", "DLLCPCAL_B"                                , 0x0001c09c, 16, 15},
{"synth_SYNTH8", "LOOP_RSB"                                  , 0x0001c09c, 14, 11},
{"synth_SYNTH8", "ICPB"                                      , 0x0001c09c, 10, 4 },
{"synth_SYNTH8", "ICPLKB"                                    , 0x0001c09c, 3 , 0 },
{"synth_SYNTH9", "REFMULTA01"                                , 0x0001c0a0, 31, 29},
{"synth_SYNTH9", "KVCOA0"                                    , 0x0001c0a0, 28, 26},
{"synth_SYNTH9", "DLLVCOCAPA01"                              , 0x0001c0a0, 25, 23},
{"synth_SYNTH9", "DLLVCOCURA01"                              , 0x0001c0a0, 22, 20},
{"synth_SYNTH9", "DLLCPCAL_A01"                              , 0x0001c0a0, 19, 18},
{"synth_SYNTH9", "LOOP_3RD_ORDER_RA0"                        , 0x0001c0a0, 17, 15},
{"synth_SYNTH9", "LOOP_RSA0"                                 , 0x0001c0a0, 14, 11},
{"synth_SYNTH9", "ICPA0"                                     , 0x0001c0a0, 10, 4 },
{"synth_SYNTH9", "ICPLKA0"                                   , 0x0001c0a0, 3 , 0 },
{"synth_SYNTH10", "SPARE10B"                                 , 0x0001c0a4, 31, 29},
{"synth_SYNTH10", "KVCOA1"                                   , 0x0001c0a4, 28, 26},
{"synth_SYNTH10", "LOOP_RSA1"                                , 0x0001c0a4, 25, 22},
{"synth_SYNTH10", "ICPA1"                                    , 0x0001c0a4, 21, 15},
{"synth_SYNTH10", "ICPLKA1"                                  , 0x0001c0a4, 14, 11},
{"synth_SYNTH10", "LO5GIBIAS_CH1"                            , 0x0001c0a4, 10, 9 },
{"synth_SYNTH10", "LOOP_3RD_ORDER_RA1"                       , 0x0001c0a4, 8 , 6 },
{"synth_SYNTH10", "SPARE10A"                                 , 0x0001c0a4, 5 , 5 },
{"synth_SYNTH10", "LO36BUF_ATB"                              , 0x0001c0a4, 4 , 2 },
{"synth_SYNTH10", "LOBUFB2GTUNE"                             , 0x0001c0a4, 1 , 0 },
{"synth_SYNTH11", "SPARE11C"                                 , 0x0001c0a8, 31, 29},
{"synth_SYNTH11", "KVCOA2"                                   , 0x0001c0a8, 28, 26},
{"synth_SYNTH11", "LOOP_RSA2"                                , 0x0001c0a8, 25, 22},
{"synth_SYNTH11", "ICPA2"                                    , 0x0001c0a8, 21, 15},
{"synth_SYNTH11", "ICPLKA2"                                  , 0x0001c0a8, 14, 11},
{"synth_SYNTH11", "LOOP_3RD_ORDER_RA2"                       , 0x0001c0a8, 10, 8 },
{"synth_SYNTH11", "SPARE11A"                                 , 0x0001c0a8, 7 , 7 },
{"synth_SYNTH11", "LOBUFA2GTUNE"                             , 0x0001c0a8, 6 , 5 },
{"synth_SYNTH11", "SPARE11B"                                 , 0x0001c0a8, 4 , 1 },
{"synth_SYNTH11", "INVERT_SDM_CLK"                           , 0x0001c0a8, 0 , 0 },
{"synth_SYNTH12", "SYNTHDIGOUTEN"                            , 0x0001c0ac, 31, 31},
{"synth_SYNTH12", "ISELQEN_LOBUFA2G"                         , 0x0001c0ac, 30, 28},
{"synth_SYNTH12", "DLLCP_B"                                  , 0x0001c0ac, 27, 24},
{"synth_SYNTH12", "DLLCP_A01"                                , 0x0001c0ac, 23, 20},
{"synth_SYNTH12", "DLLCP_A23"                                , 0x0001c0ac, 19, 16},
{"synth_SYNTH12", "LOOP_CPB"                                 , 0x0001c0ac, 15, 14},
{"synth_SYNTH12", "LOOP_CPA0"                                , 0x0001c0ac, 13, 12},
{"synth_SYNTH12", "LOOP_CPA1"                                , 0x0001c0ac, 11, 10},
{"synth_SYNTH12", "LOOP_CPA2"                                , 0x0001c0ac, 9 , 8 },
{"synth_SYNTH12", "LOOP_CPA3"                                , 0x0001c0ac, 7 , 6 },
{"synth_SYNTH12", "SPARE12A"                                 , 0x0001c0ac, 5 , 0 },
{"synth_SYNTH13", "REFMULTA23"                               , 0x0001c0b0, 31, 29},
{"synth_SYNTH13", "KVCOA3"                                   , 0x0001c0b0, 28, 26},
{"synth_SYNTH13", "LOOP_3RD_ORDER_RA3"                       , 0x0001c0b0, 25, 23},
{"synth_SYNTH13", "DLLVCOCAPA23"                             , 0x0001c0b0, 22, 20},
{"synth_SYNTH13", "DLLVCOCURA23"                             , 0x0001c0b0, 19, 17},
{"synth_SYNTH13", "DLLCPCAL_A23"                             , 0x0001c0b0, 16, 15},
{"synth_SYNTH13", "LOOP_RSA3"                                , 0x0001c0b0, 14, 11},
{"synth_SYNTH13", "ICPA3"                                    , 0x0001c0b0, 10, 4 },
{"synth_SYNTH13", "ICPLKA3"                                  , 0x0001c0b0, 3 , 0 },
{"synth_SYNTH14", "FORCE_SHORTR_BIASNREF"                    , 0x0001c0b4, 31, 31},
{"synth_SYNTH14", "FORCE_SHORTR_VCO"                         , 0x0001c0b4, 30, 30},
{"synth_SYNTH14", "FORCE_SHORTR_CP"                          , 0x0001c0b4, 29, 29},
{"synth_SYNTH14", "SHORTR_BIASNREF_OVR"                      , 0x0001c0b4, 28, 28},
{"synth_SYNTH14", "SHORTR_VCO_OVR"                           , 0x0001c0b4, 27, 27},
{"synth_SYNTH14", "SHORTR_CP_OVR"                            , 0x0001c0b4, 26, 26},
{"synth_SYNTH14", "AICOVR1_CHANSEL"                          , 0x0001c0b4, 25, 18},
{"synth_SYNTH14", "AICOVR1_CHANFRAC"                         , 0x0001c0b4, 17, 1 },
{"synth_SYNTH14", "SPARE15A"                                 , 0x0001c0b4, 0 , 0 },
{"synth_SYNTH15", "SPARE16A"                                 , 0x0001c0b8, 31, 31},
{"synth_SYNTH15", "FORCELOBUF5GON"                           , 0x0001c0b8, 30, 28},
{"synth_SYNTH15", "FORCEPWDLOBUF5G"                          , 0x0001c0b8, 27, 25},
{"synth_SYNTH15", "AICOVR2_CHANSEL"                          , 0x0001c0b8, 24, 17},
{"synth_SYNTH15", "AICOVR2_CHANFRAC"                         , 0x0001c0b8, 16, 0 },
{"synth_SYNTH16", "DLLABSEL"                                 , 0x0001c0bc, 31, 30},
{"synth_SYNTH16", "RESERVED16A"                              , 0x0001c0bc, 29, 24},
{"synth_SYNTH16", "DLLPD"                                    , 0x0001c0bc, 23, 23},
{"synth_SYNTH16", "DLLPDCAL"                                 , 0x0001c0bc, 22, 22},
{"synth_SYNTH16", "DLLVCH"                                   , 0x0001c0bc, 21, 20},
{"synth_SYNTH16", "DLLVCL"                                   , 0x0001c0bc, 19, 18},
{"synth_SYNTH16", "FORCE_DLL_CAPCUR"                         , 0x0001c0bc, 17, 17},
{"synth_SYNTH16", "DLL_CHANGE_CAP_FIRST"                     , 0x0001c0bc, 16, 16},
{"synth_SYNTH16", "WAIT_DLLSM"                               , 0x0001c0bc, 15, 12},
{"synth_SYNTH16", "DLL_VC_CHK_CNT"                           , 0x0001c0bc, 11, 8 },
{"synth_SYNTH16", "FORCE_DLL_IS_LOCKED"                      , 0x0001c0bc, 7 , 7 },
{"synth_SYNTH16", "DLL_IS_LOCKED_OVR"                        , 0x0001c0bc, 6 , 6 },
{"synth_SYNTH16", "RESERVED17B"                              , 0x0001c0bc, 5 , 4 },
{"synth_SYNTH16", "RESERVED17A"                              , 0x0001c0bc, 3 , 0 },
{"bias_wlan_BIASWLAN1", "bias_sel"                           , 0x0001c0c0, 31, 24},
{"bias_wlan_BIASWLAN1", "pwd_ic25adc"                        , 0x0001c0c0, 23, 21},
{"bias_wlan_BIASWLAN1", "pwd_ic25biquad1"                    , 0x0001c0c0, 20, 18},
{"bias_wlan_BIASWLAN1", "pwd_ic25dac"                        , 0x0001c0c0, 17, 15},
{"bias_wlan_BIASWLAN1", "pwd_ic25biquad2"                    , 0x0001c0c0, 14, 12},
{"bias_wlan_BIASWLAN1", "pwd_ic25v2iI"                       , 0x0001c0c0, 11, 9 },
{"bias_wlan_BIASWLAN1", "pwd_ic25v2iQ"                       , 0x0001c0c0, 8 , 6 },
{"bias_wlan_BIASWLAN1", "pwd_ic100pcie"                      , 0x0001c0c0, 5 , 3 },
{"bias_wlan_BIASWLAN1", "SPARE1"                             , 0x0001c0c0, 2 , 0 },
{"bias_wlan_BIASWLAN2", "pwd_ic25pllgm"                      , 0x0001c0c4, 31, 29},
{"bias_wlan_BIASWLAN2", "pwd_ic25pllcp"                      , 0x0001c0c4, 28, 26},
{"bias_wlan_BIASWLAN2", "pwd_ic25pllcp2"                     , 0x0001c0c4, 25, 23},
{"bias_wlan_BIASWLAN2", "pwd_ic25pllreg"                     , 0x0001c0c4, 22, 20},
{"bias_wlan_BIASWLAN2", "pwd_ic25synth"                      , 0x0001c0c4, 19, 17},
{"bias_wlan_BIASWLAN2", "pwd_ic25rxrf"                       , 0x0001c0c4, 16, 14},
{"bias_wlan_BIASWLAN2", "pwd_ic25txrf"                       , 0x0001c0c4, 13, 11},
{"bias_wlan_BIASWLAN2", "pwd_ic25xtal"                       , 0x0001c0c4, 10, 8 },
{"bias_wlan_BIASWLAN2", "pwd_ir25cpupll"                     , 0x0001c0c4, 7 , 5 },
{"bias_wlan_BIASWLAN2", "SPARE2"                             , 0x0001c0c4, 4 , 0 },
{"bias_wlan_BIASWLAN3", "pwd_ir50adc"                        , 0x0001c0c8, 31, 29},
{"bias_wlan_BIASWLAN3", "pwd_ir25biquad1"                    , 0x0001c0c8, 28, 26},
{"bias_wlan_BIASWLAN3", "pwd_ir25dac"                        , 0x0001c0c8, 25, 23},
{"bias_wlan_BIASWLAN3", "pwd_ir50dac"                        , 0x0001c0c8, 22, 20},
{"bias_wlan_BIASWLAN3", "pwd_ir25biquad2"                    , 0x0001c0c8, 19, 17},
{"bias_wlan_BIASWLAN3", "pwd_ir25pllreg"                     , 0x0001c0c8, 16, 14},
{"bias_wlan_BIASWLAN3", "pwd_ir25synth"                      , 0x0001c0c8, 13, 11},
{"bias_wlan_BIASWLAN3", "pwd_ir25rxrf"                       , 0x0001c0c8, 10, 8 },
{"bias_wlan_BIASWLAN3", "pwd_ir25txrf"                       , 0x0001c0c8, 7 , 5 },
{"bias_wlan_BIASWLAN3", "pwd_ir25xtalreg"                    , 0x0001c0c8, 4 , 2 },
{"bias_wlan_BIASWLAN3", "SPARE3"                             , 0x0001c0c8, 1 , 0 },
{"bias_wlan_BIASWLAN4", "pwd_ic25cpupll"                     , 0x0001c0cc, 31, 29},
{"bias_wlan_BIASWLAN4", "pwd_ic25testtxiq"                   , 0x0001c0cc, 28, 26},
{"bias_wlan_BIASWLAN4", "pwd_ic25xpabias"                    , 0x0001c0cc, 25, 23},
{"bias_wlan_BIASWLAN4", "pwd_ir25otpreg"                     , 0x0001c0cc, 22, 20},
{"bias_wlan_BIASWLAN4", "pwd_ir25thermadc"                   , 0x0001c0cc, 19, 17},
{"bias_wlan_BIASWLAN4", "pwd_ir25xpabias"                    , 0x0001c0cc, 16, 14},
{"bias_wlan_BIASWLAN4", "pwd_icbiascal"                      , 0x0001c0cc, 13, 13},
{"bias_wlan_BIASWLAN4", "icbiascaltoATB"                     , 0x0001c0cc, 12, 12},
{"bias_wlan_BIASWLAN4", "kickbackfilter_Rsel"                , 0x0001c0cc, 11, 10},
{"bias_wlan_BIASWLAN4", "pwd_ic25spareB"                     , 0x0001c0cc, 9 , 7 },
{"bias_wlan_BIASWLAN4", "pwd_ir25adc"                        , 0x0001c0cc, 6 , 4 },
{"bias_wlan_BIASWLAN4", "SPARE4"                             , 0x0001c0cc, 3 , 0 },
{"rxtx_b0_RXTX1", "mantxgain"                                , 0x0001c100, 31, 31},
{"rxtx_b0_RXTX1", "padrv3gn5g"                               , 0x0001c100, 30, 27},
{"rxtx_b0_RXTX1", "padrv2gn5g"                               , 0x0001c100, 26, 24},
{"rxtx_b0_RXTX1", "padrv2gn2g"                               , 0x0001c100, 23, 20},
{"rxtx_b0_RXTX1", "padrvhalfgn2g"                            , 0x0001c100, 19, 19},
{"rxtx_b0_RXTX1", "ovr_agc_dbdac"                            , 0x0001c100, 18, 18},
{"rxtx_b0_RXTX1", "agc_dbdac"                                , 0x0001c100, 17, 14},
{"rxtx_b0_RXTX1", "manrxgain"                                , 0x0001c100, 13, 13},
{"rxtx_b0_RXTX1", "lnagain"                                  , 0x0001c100, 12, 10},
{"rxtx_b0_RXTX1", "vgagain"                                  , 0x0001c100, 9 , 7 },
{"rxtx_b0_RXTX1", "mxrgain"                                  , 0x0001c100, 6 , 5 },
{"rxtx_b0_RXTX1", "reserved"                                 , 0x0001c100, 4 , 0 },
{"rxtx_b0_RXTX2", "agcon_ovr"                                , 0x0001c104, 31, 31},
{"rxtx_b0_RXTX2", "agcon"                                    , 0x0001c104, 30, 30},
{"rxtx_b0_RXTX2", "txmod_ovr"                                , 0x0001c104, 29, 29},
{"rxtx_b0_RXTX2", "txmod"                                    , 0x0001c104, 28, 26},
{"rxtx_b0_RXTX2", "rxon_ovr"                                 , 0x0001c104, 25, 25},
{"rxtx_b0_RXTX2", "rxon"                                     , 0x0001c104, 24, 24},
{"rxtx_b0_RXTX2", "paon_ovr"                                 , 0x0001c104, 23, 23},
{"rxtx_b0_RXTX2", "paon"                                     , 0x0001c104, 22, 22},
{"rxtx_b0_RXTX2", "txon_ovr"                                 , 0x0001c104, 21, 21},
{"rxtx_b0_RXTX2", "txon"                                     , 0x0001c104, 20, 20},
{"rxtx_b0_RXTX2", "BW_ST_ovr"                                , 0x0001c104, 19, 19},
{"rxtx_b0_RXTX2", "BW_ST"                                    , 0x0001c104, 18, 16},
{"rxtx_b0_RXTX2", "synthon_ovr"                              , 0x0001c104, 15, 15},
{"rxtx_b0_RXTX2", "synthon"                                  , 0x0001c104, 14, 14},
{"rxtx_b0_RXTX2", "bmode_ovr"                                , 0x0001c104, 13, 13},
{"rxtx_b0_RXTX2", "bmode"                                    , 0x0001c104, 12, 12},
{"rxtx_b0_RXTX2", "calpa_ovr"                                , 0x0001c104, 11, 11},
{"rxtx_b0_RXTX2", "calpa"                                    , 0x0001c104, 10, 10},
{"rxtx_b0_RXTX2", "caltxshift_ovr"                           , 0x0001c104, 9 , 9 },
{"rxtx_b0_RXTX2", "caltxshift"                               , 0x0001c104, 8 , 8 },
{"rxtx_b0_RXTX2", "caltx_ovr"                                , 0x0001c104, 7 , 7 },
{"rxtx_b0_RXTX2", "caltx"                                    , 0x0001c104, 6 , 6 },
{"rxtx_b0_RXTX2", "calfc_ovr"                                , 0x0001c104, 5 , 5 },
{"rxtx_b0_RXTX2", "calfc"                                    , 0x0001c104, 4 , 4 },
{"rxtx_b0_RXTX2", "calresidue_ovr"                           , 0x0001c104, 3 , 3 },
{"rxtx_b0_RXTX2", "calresidue"                               , 0x0001c104, 2 , 2 },
{"rxtx_b0_RXTX2", "LOforcedon"                               , 0x0001c104, 1 , 1 },
{"rxtx_b0_RXTX2", "reserved"                                 , 0x0001c104, 0 , 0 },
{"rxtx_b0_RXTX3", "agc_cal_ovr"                              , 0x0001c108, 31, 31},
{"rxtx_b0_RXTX3", "agc_cal"                                  , 0x0001c108, 30, 30},
{"rxtx_b0_RXTX3", "agc_caldac"                               , 0x0001c108, 29, 24},
{"rxtx_b0_RXTX3", "adc_samp_rate_ovr"                        , 0x0001c108, 23, 23},
{"rxtx_b0_RXTX3", "adc_samp_rate"                            , 0x0001c108, 22, 21},
{"rxtx_b0_RXTX3", "calrx_ovr"                                , 0x0001c108, 20, 20},
{"rxtx_b0_RXTX3", "calrx"                                    , 0x0001c108, 19, 19},
{"rxtx_b0_RXTX3", "caladcoffset_ovr"                         , 0x0001c108, 18, 18},
{"rxtx_b0_RXTX3", "caladcoffset"                             , 0x0001c108, 17, 17},
{"rxtx_b0_RXTX3", "calxpa_ovr"                               , 0x0001c108, 16, 16},
{"rxtx_b0_RXTX3", "calxpa"                                   , 0x0001c108, 15, 15},
{"rxtx_b0_RXTX3", "xlnaon_ovr"                               , 0x0001c108, 14, 14},
{"rxtx_b0_RXTX3", "xlnaon"                                   , 0x0001c108, 13, 13},
{"rxtx_b0_RXTX3", "xlnabias_pwd"                             , 0x0001c108, 12, 12},
{"rxtx_b0_RXTX3", "reserved"                                 , 0x0001c108, 11, 0 },
{"rxtx_b0_RXTX4", "xlna_strength"                            , 0x0001c10c, 31, 30},
{"rxtx_b0_RXTX4", "thermOn_ovr"                              , 0x0001c10c, 29, 29},
{"rxtx_b0_RXTX4", "thermOn"                                  , 0x0001c10c, 28, 28},
{"rxtx_b0_RXTX4", "txswen"                                   , 0x0001c10c, 25, 25},
{"rxtx_b0_RXTX4", "txswen_ovr"                               , 0x0001c10c, 24, 24},
{"rxtx_b0_RXTX4", "AICcapdiv2GI"                             , 0x0001c10c, 23, 20},
{"rxtx_b0_RXTX4", "AICcapdiv2GQ"                             , 0x0001c10c, 19, 16},
{"rxtx_b0_RXTX4", "AICvga_gnI"                               , 0x0001c10c, 15, 11},
{"rxtx_b0_RXTX4", "AICvga_gnQ"                               , 0x0001c10c, 10, 6 },
{"rxtx_b0_RXTX4", "AICinvI"                                  , 0x0001c10c, 5 , 5 },
{"rxtx_b0_RXTX4", "AICinvQ"                                  , 0x0001c10c, 4 , 4 },
{"rxtx_b0_RXTX4", "AICgmgn6dB"                               , 0x0001c10c, 3 , 0 },
{"rxtx_b0_RXTX5", "AICgmHP"                                  , 0x0001c110, 31, 31},
{"rxtx_b0_RXTX5", "AIClocal_mode"                            , 0x0001c110, 30, 30},
{"rxtx_b0_RXTX5", "AICon"                                    , 0x0001c110, 29, 29},
{"rxtx_b0_RXTX5", "AICstby"                                  , 0x0001c110, 28, 28},
{"rxtx_b0_RXTX5", "AIC_chanOvr"                              , 0x0001c110, 27, 26},
{"rxtx_b0_RXTX5", "AIC_loadChannel"                          , 0x0001c110, 25, 25},
{"rxtx_b0_RXTX5", "testIQ_rsel"                              , 0x0001c110, 24, 24},
{"rxtx_b0_RXTX5", "testIQ_bufen"                             , 0x0001c110, 23, 23},
{"rxtx_b0_RXTX5", "testI_on"                                 , 0x0001c110, 22, 22},
{"rxtx_b0_RXTX5", "testQ_on"                                 , 0x0001c110, 21, 21},
{"rxtx_b0_RXTX5", "bbreplace_en"                             , 0x0001c110, 20, 20},
{"rxtx_b0_RXTX5", "RESERVED5"                                , 0x0001c110, 19, 0 },
{"bb_b0_BB1", "RANGE_OSDAC"                                  , 0x0001c140, 31, 30},
{"bb_b0_BB1", "LOCALOFFSET"                                  , 0x0001c140, 29, 29},
{"bb_b0_BB1", "OFSTCORRI2VI"                                 , 0x0001c140, 28, 24},
{"bb_b0_BB1", "OFSTCORRI2VQ"                                 , 0x0001c140, 23, 19},
{"bb_b0_BB1", "ATBSEL"                                       , 0x0001c140, 18, 16},
{"bb_b0_BB1", "CMSEL1"                                       , 0x0001c140, 15, 13},
{"bb_b0_BB1", "CMSEL2"                                       , 0x0001c140, 12, 10},
{"bb_b0_BB1", "PWD_RCFILT_OVR"                               , 0x0001c140, 9 , 9 },
{"bb_b0_BB1", "PWD_RCFILT"                                   , 0x0001c140, 8 , 8 },
{"bb_b0_BB1", "PWD_V2I_OVR"                                  , 0x0001c140, 7 , 7 },
{"bb_b0_BB1", "PWD_V2I"                                      , 0x0001c140, 6 , 6 },
{"bb_b0_BB1", "PWD_OSDAC_OVR"                                , 0x0001c140, 5 , 5 },
{"bb_b0_BB1", "PWD_OSDAC"                                    , 0x0001c140, 4 , 4 },
{"bb_b0_BB1", "PWD_BIQUAD1_OVR"                              , 0x0001c140, 3 , 3 },
{"bb_b0_BB1", "PWD_BIQUAD1"                                  , 0x0001c140, 2 , 2 },
{"bb_b0_BB1", "PWD_BIQUAD2_OVR"                              , 0x0001c140, 1 , 1 },
{"bb_b0_BB1", "PWD_BIQUAD2"                                  , 0x0001c140, 0 , 0 },
{"bb_b0_BB2", "SWITCH_OVERRIDE"                              , 0x0001c144, 31, 31},
{"bb_b0_BB2", "RXIN2RC_EN"                                   , 0x0001c144, 30, 30},
{"bb_b0_BB2", "RC2BQ1_EN"                                    , 0x0001c144, 29, 29},
{"bb_b0_BB2", "RC2RXOUT_EN"                                  , 0x0001c144, 28, 28},
{"bb_b0_BB2", "BQ2RXOUT_EN"                                  , 0x0001c144, 27, 27},
{"bb_b0_BB2", "NOTCHON"                                      , 0x0001c144, 26, 26},
{"bb_b0_BB2", "BYPASSBQ1_EN"                                 , 0x0001c144, 25, 25},
{"bb_b0_BB2", "BQ2V2I_EN"                                    , 0x0001c144, 24, 24},
{"bb_b0_BB2", "DAC2V2I_EN"                                   , 0x0001c144, 23, 23},
{"bb_b0_BB2", "FILTERFC_OVR"                                 , 0x0001c144, 22, 22},
{"bb_b0_BB2", "FILTERFC"                                     , 0x0001c144, 21, 17},
{"bb_b0_BB2", "FNOTCH_OVR"                                   , 0x0001c144, 16, 16},
{"bb_b0_BB2", "FNOTCH"                                       , 0x0001c144, 15, 12},
{"bb_b0_BB2", "REMOVECAP_RCFILT_OVR"                         , 0x0001c144, 11, 11},
{"bb_b0_BB2", "REMOVECAP_RCFILT"                             , 0x0001c144, 10, 10},
{"bb_b0_BB2", "dac_clk_inv"                                  , 0x0001c144, 9 , 9 },
{"bb_b0_BB2", "btcpupll_clkbufdrvstr"                        , 0x0001c144, 8 , 7 },
{"bb_b0_BB2", "flip_adc_str_clk"                             , 0x0001c144, 6 , 6 },
{"bb_b0_BB2", "SEL_TEST"                                     , 0x0001c144, 5 , 0 },
{"bb_b0_BB3", "pll704en"                                     , 0x0001c148, 31, 31},
{"bb_b0_BB3", "OFSTCORRI2VI"                                 , 0x0001c148, 30, 26},
{"bb_b0_BB3", "OFSTCORRI2VQ"                                 , 0x0001c148, 25, 21},
{"bb_b0_BB3", "FILTERFC"                                     , 0x0001c148, 20, 16},
{"bb_b0_BB3", "RX_FILTERFC"                                  , 0x0001c148, 15, 11},
{"bb_b0_BB3", "TX_FILTERFC"                                  , 0x0001c148, 10, 6 },
{"bb_b0_BB3", "SEL_OFST_READBK"                              , 0x0001c148, 5 , 4 },
{"bb_b0_BB3", "ADC_COMPBIAS"                                 , 0x0001c148, 3 , 2 },
{"bb_b0_BB3", "DOUBLE_RCFILT_CURR"                           , 0x0001c148, 1 , 1 },
{"bb_b0_BB3", "PWD_BB_BIAS_OVR"                              , 0x0001c148, 0 , 0 },
{"bb_b0_BB4", "RX_RXIN2RC_EN"                                , 0x0001c14c, 31, 31},
{"bb_b0_BB4", "RX_RC2BQ1_EN"                                 , 0x0001c14c, 30, 30},
{"bb_b0_BB4", "RX_RC2RXOUT_EN"                               , 0x0001c14c, 29, 29},
{"bb_b0_BB4", "RX_BQ2RXOUT_EN"                               , 0x0001c14c, 28, 28},
{"bb_b0_BB4", "RX_NOTCHON"                                   , 0x0001c14c, 27, 27},
{"bb_b0_BB4", "RX_BYPASSBQ1_EN"                              , 0x0001c14c, 26, 26},
{"bb_b0_BB4", "RX_BQ2V2I_EN"                                 , 0x0001c14c, 25, 25},
{"bb_b0_BB4", "RX_DAC2V2I_EN"                                , 0x0001c14c, 24, 24},
{"bb_b0_BB4", "RX_PWD_RCFILT"                                , 0x0001c14c, 23, 23},
{"bb_b0_BB4", "RX_PWD_V2I"                                   , 0x0001c14c, 22, 22},
{"bb_b0_BB4", "RX_PWD_BIQUAD1"                               , 0x0001c14c, 21, 21},
{"bb_b0_BB4", "RX_PWD_BIQUAD2"                               , 0x0001c14c, 20, 20},
{"bb_b0_BB4", "RX_REMOVECAP_RCFILT"                          , 0x0001c14c, 19, 19},
{"bb_b0_BB4", "RX_NOTCH_HALFBW"                              , 0x0001c14c, 18, 18},
{"bb_b0_BB4", "TX_RXIN2RC_EN"                                , 0x0001c14c, 17, 17},
{"bb_b0_BB4", "TX_RC2BQ1_EN"                                 , 0x0001c14c, 16, 16},
{"bb_b0_BB4", "TX_RC2RXOUT_EN"                               , 0x0001c14c, 15, 15},
{"bb_b0_BB4", "TX_BQ2RXOUT_EN"                               , 0x0001c14c, 14, 14},
{"bb_b0_BB4", "TX_NOTCHON"                                   , 0x0001c14c, 13, 13},
{"bb_b0_BB4", "TX_BYPASSBQ1_EN"                              , 0x0001c14c, 12, 12},
{"bb_b0_BB4", "TX_BQ2V2I_EN"                                 , 0x0001c14c, 11, 11},
{"bb_b0_BB4", "TX_DAC2V2I_EN"                                , 0x0001c14c, 10, 10},
{"bb_b0_BB4", "TX_PWD_RCFILT"                                , 0x0001c14c, 9 , 9 },
{"bb_b0_BB4", "TX_PWD_V2I"                                   , 0x0001c14c, 8 , 8 },
{"bb_b0_BB4", "TX_PWD_BIQUAD1"                               , 0x0001c14c, 7 , 7 },
{"bb_b0_BB4", "TX_PWD_BIQUAD2"                               , 0x0001c14c, 6 , 6 },
{"bb_b0_BB4", "TX_REMOVECAP_RCFILT"                          , 0x0001c14c, 5 , 5 },
{"bb_b0_BB4", "TX_NOTCH_HALFBW"                              , 0x0001c14c, 4 , 4 },
{"bb_b0_BB4", "ADC_DEC_DELAYBIAS"                            , 0x0001c14c, 3 , 2 },
{"bb_b0_BB4", "ADC_INC_DELAYBIAS"                            , 0x0001c14c, 1 , 1 },
{"bb_b0_BB4", "ADC_COMP_RESET"                               , 0x0001c14c, 0 , 0 },
{"bb_b0_BB5", "CALRX_RXIN2RC_EN"                             , 0x0001c150, 31, 31},
{"bb_b0_BB5", "CALRX_RC2BQ1_EN"                              , 0x0001c150, 30, 30},
{"bb_b0_BB5", "CALRX_RC2RXOUT_EN"                            , 0x0001c150, 29, 29},
{"bb_b0_BB5", "CALRX_BQ2RXOUT_EN"                            , 0x0001c150, 28, 28},
{"bb_b0_BB5", "CALRX_NOTCHON"                                , 0x0001c150, 27, 27},
{"bb_b0_BB5", "CALRX_BYPASSBQ1_EN"                           , 0x0001c150, 26, 26},
{"bb_b0_BB5", "CALRX_BQ2V2I_EN"                              , 0x0001c150, 25, 25},
{"bb_b0_BB5", "CALRX_DAC2V2I_EN"                             , 0x0001c150, 24, 24},
{"bb_b0_BB5", "CALRX_PWD_RCFILT"                             , 0x0001c150, 23, 23},
{"bb_b0_BB5", "CALRX_PWD_V2I"                                , 0x0001c150, 22, 22},
{"bb_b0_BB5", "CALRX_PWD_BIQUAD1"                            , 0x0001c150, 21, 21},
{"bb_b0_BB5", "CALRX_PWD_BIQUAD2"                            , 0x0001c150, 20, 20},
{"bb_b0_BB5", "CALRX_REMOVECAP_RCFILT"                       , 0x0001c150, 19, 19},
{"bb_b0_BB5", "CALRX_NOTCH_HALFBW"                           , 0x0001c150, 18, 18},
{"bb_b0_BB5", "CALTX_RXIN2RC_EN"                             , 0x0001c150, 17, 17},
{"bb_b0_BB5", "CALTX_RC2BQ1_EN"                              , 0x0001c150, 16, 16},
{"bb_b0_BB5", "CALTX_RC2RXOUT_EN"                            , 0x0001c150, 15, 15},
{"bb_b0_BB5", "CALTX_BQ2RXOUT_EN"                            , 0x0001c150, 14, 14},
{"bb_b0_BB5", "CALTX_NOTCHON"                                , 0x0001c150, 13, 13},
{"bb_b0_BB5", "CALTX_BYPASSBQ1_EN"                           , 0x0001c150, 12, 12},
{"bb_b0_BB5", "CALTX_BQ2V2I_EN"                              , 0x0001c150, 11, 11},
{"bb_b0_BB5", "CALTX_DAC2V2I_EN"                             , 0x0001c150, 10, 10},
{"bb_b0_BB5", "CALTX_PWD_RCFILT"                             , 0x0001c150, 9 , 9 },
{"bb_b0_BB5", "CALTX_PWD_V2I"                                , 0x0001c150, 8 , 8 },
{"bb_b0_BB5", "CALTX_PWD_BIQUAD1"                            , 0x0001c150, 7 , 7 },
{"bb_b0_BB5", "CALTX_PWD_BIQUAD2"                            , 0x0001c150, 6 , 6 },
{"bb_b0_BB5", "CALTX_REMOVECAP_RCFILT"                       , 0x0001c150, 5 , 5 },
{"bb_b0_BB5", "CALTX_NOTCH_HALFBW"                           , 0x0001c150, 4 , 4 },
{"bb_b0_BB5", "ADC_REFBIAS"                                  , 0x0001c150, 3 , 2 },
{"bb_b0_BB5", "ADC_REFINC"                                   , 0x0001c150, 1 , 1 },
{"bb_b0_BB5", "ADC_SWAP"                                     , 0x0001c150, 0 , 0 },
{"bb_b0_BB6", "CALPA_RXIN2RC_EN"                             , 0x0001c154, 31, 31},
{"bb_b0_BB6", "CALPA_RC2BQ1_EN"                              , 0x0001c154, 30, 30},
{"bb_b0_BB6", "CALPA_RC2RXOUT_EN"                            , 0x0001c154, 29, 29},
{"bb_b0_BB6", "CALPA_BQ2RXOUT_EN"                            , 0x0001c154, 28, 28},
{"bb_b0_BB6", "CALPA_NOTCHON"                                , 0x0001c154, 27, 27},
{"bb_b0_BB6", "CALPA_BYPASSBQ1_EN"                           , 0x0001c154, 26, 26},
{"bb_b0_BB6", "CALPA_BQ2V2I_EN"                              , 0x0001c154, 25, 25},
{"bb_b0_BB6", "CALPA_DAC2V2I_EN"                             , 0x0001c154, 24, 24},
{"bb_b0_BB6", "CALPA_PWD_RCFILT"                             , 0x0001c154, 23, 23},
{"bb_b0_BB6", "CALPA_PWD_V2I"                                , 0x0001c154, 22, 22},
{"bb_b0_BB6", "CALPA_PWD_BIQUAD1"                            , 0x0001c154, 21, 21},
{"bb_b0_BB6", "CALPA_PWD_BIQUAD2"                            , 0x0001c154, 20, 20},
{"bb_b0_BB6", "CALPA_REMOVECAP_RCFILT"                       , 0x0001c154, 19, 19},
{"bb_b0_BB6", "CALPA_NOTCH_HALFBW"                           , 0x0001c154, 18, 18},
{"bb_b0_BB6", "CALFC_RXIN2RC_EN"                             , 0x0001c154, 17, 17},
{"bb_b0_BB6", "CALFC_RC2BQ1_EN"                              , 0x0001c154, 16, 16},
{"bb_b0_BB6", "CALFC_RC2RXOUT_EN"                            , 0x0001c154, 15, 15},
{"bb_b0_BB6", "CALFC_BQ2RXOUT_EN"                            , 0x0001c154, 14, 14},
{"bb_b0_BB6", "CALFC_NOTCHON"                                , 0x0001c154, 13, 13},
{"bb_b0_BB6", "CALFC_BYPASSBQ1_EN"                           , 0x0001c154, 12, 12},
{"bb_b0_BB6", "CALFC_BQ2V2I_EN"                              , 0x0001c154, 11, 11},
{"bb_b0_BB6", "CALFC_DAC2V2I_EN"                             , 0x0001c154, 10, 10},
{"bb_b0_BB6", "CALFC_PWD_RCFILT"                             , 0x0001c154, 9 , 9 },
{"bb_b0_BB6", "CALFC_PWD_V2I"                                , 0x0001c154, 8 , 8 },
{"bb_b0_BB6", "CALFC_PWD_BIQUAD1"                            , 0x0001c154, 7 , 7 },
{"bb_b0_BB6", "CALFC_PWD_BIQUAD2"                            , 0x0001c154, 6 , 6 },
{"bb_b0_BB6", "CALFC_REMOVECAP_RCFILT"                       , 0x0001c154, 5 , 5 },
{"bb_b0_BB6", "CALFC_NOTCH_HALFBW"                           , 0x0001c154, 4 , 4 },
{"bb_b0_BB6", "PWD_BB_BIAS"                                  , 0x0001c154, 3 , 3 },
{"bb_b0_BB6", "DRV_STR"                                      , 0x0001c154, 2 , 0 },
{"bb_b0_BB7", "LPRX_RXIN2RC_EN"                              , 0x0001c158, 31, 31},
{"bb_b0_BB7", "LPRX_RC2BQ1_EN"                               , 0x0001c158, 30, 30},
{"bb_b0_BB7", "LPRX_RC2RXOUT_EN"                             , 0x0001c158, 29, 29},
{"bb_b0_BB7", "LPRX_BQ2RXOUT_EN"                             , 0x0001c158, 28, 28},
{"bb_b0_BB7", "LPRX_NOTCHON"                                 , 0x0001c158, 27, 27},
{"bb_b0_BB7", "LPRX_BYPASSBQ1_EN"                            , 0x0001c158, 26, 26},
{"bb_b0_BB7", "LPRX_BQ2V2I_EN"                               , 0x0001c158, 25, 25},
{"bb_b0_BB7", "LPRX_DAC2V2I_EN"                              , 0x0001c158, 24, 24},
{"bb_b0_BB7", "LPRX_PWD_RCFILT"                              , 0x0001c158, 23, 23},
{"bb_b0_BB7", "LPRX_PWD_V2I"                                 , 0x0001c158, 22, 22},
{"bb_b0_BB7", "LPRX_PWD_BIQUAD1"                             , 0x0001c158, 21, 21},
{"bb_b0_BB7", "LPRX_PWD_BIQUAD2"                             , 0x0001c158, 20, 20},
{"bb_b0_BB7", "LPRX_REMOVECAP_RCFILT"                        , 0x0001c158, 19, 19},
{"bb_b0_BB7", "LPRX_NOTCH_HALFBW"                            , 0x0001c158, 18, 18},
{"bb_b0_BB7", "LPRX_FILTERFC"                                , 0x0001c158, 17, 13},
{"bb_b0_BB7", "PWD_OSDAC_CAL"                                , 0x0001c158, 12, 10},
{"bb_b0_BB7", "NOTCH_HALFBW"                                 , 0x0001c158, 9 , 9 },
{"bb_b0_BB7", "RX_FILTERFC_OVR"                              , 0x0001c158, 8 , 8 },
{"bb_b0_BB7", "TX_FILTERFC_OVR"                              , 0x0001c158, 7 , 7 },
{"bb_b0_BB7", "LPRX_FILTERFC_OVR"                            , 0x0001c158, 6 , 6 },
{"bb_b0_BB7", "ADCSHORT"                                     , 0x0001c158, 5 , 5 },
{"bb_b0_BB7", "ADCSHORT_OVR"                                 , 0x0001c158, 4 , 4 },
{"bb_b0_BB7", "ADDACLOOPBACK"                                , 0x0001c158, 3 , 3 },
{"bb_b0_BB7", "DACFULLSCALE"                                 , 0x0001c158, 2 , 2 },
{"bb_b0_BB7", "LOWPWRLISTEN_OVR"                             , 0x0001c158, 1 , 1 },
{"bb_b0_BB7", "LOWPWRLISTEN"                                 , 0x0001c158, 0 , 0 },
{"bb_b0_BB8", "RX1DB_BIQUAD"                                 , 0x0001c15c, 31, 29},
{"bb_b0_BB8", "RX6DB_BIQUAD1"                                , 0x0001c15c, 28, 27},
{"bb_b0_BB8", "RX6DB_BIQUAD2"                                , 0x0001c15c, 26, 25},
{"bb_b0_BB8", "TX1DB_BIQUAD"                                 , 0x0001c15c, 24, 22},
{"bb_b0_BB8", "TX6DB_BIQUAD1"                                , 0x0001c15c, 21, 20},
{"bb_b0_BB8", "TX6DB_BIQUAD2"                                , 0x0001c15c, 19, 18},
{"bb_b0_BB8", "TXBB_GC"                                      , 0x0001c15c, 17, 14},
{"bb_b0_BB8", "DACRSTB"                                      , 0x0001c15c, 13, 13},
{"bb_b0_BB8", "INV_CLK320_ADDAC"                             , 0x0001c15c, 12, 12},
{"bb_b0_BB8", "local_dacpwd"                                 , 0x0001c15c, 11, 11},
{"bb_b0_BB8", "dacpwd"                                       , 0x0001c15c, 10, 10},
{"bb_b0_BB8", "dacclkpwd"                                    , 0x0001c15c, 9 , 9 },
{"bb_b0_BB8", "local_adcpwd"                                 , 0x0001c15c, 8 , 8 },
{"bb_b0_BB8", "adcpwd"                                       , 0x0001c15c, 7 , 7 },
{"bb_b0_BB8", "adcclkpwd"                                    , 0x0001c15c, 6 , 6 },
{"bb_b0_BB8", "local_clkmodaaddac"                           , 0x0001c15c, 5 , 5 },
{"bb_b0_BB8", "dac_clk_sel"                                  , 0x0001c15c, 4 , 4 },
{"bb_b0_BB8", "adc_clk_sel"                                  , 0x0001c15c, 3 , 2 },
{"bb_b0_BB8", "dactermResSw"                                 , 0x0001c15c, 1 , 0 },
{"bb_dpll_DPLL1", "refdiv"                                   , 0x0001c180, 31, 27},
{"bb_dpll_DPLL1", "nint"                                     , 0x0001c180, 26, 18},
{"bb_dpll_DPLL1", "nfrac"                                    , 0x0001c180, 17, 0 },
{"bb_dpll_DPLL2", "local_pll"                                , 0x0001c184, 31, 31},
{"bb_dpll_DPLL2", "ki"                                       , 0x0001c184, 30, 29},
{"bb_dpll_DPLL2", "kd"                                       , 0x0001c184, 28, 25},
{"bb_dpll_DPLL2", "en_negtrig"                               , 0x0001c184, 24, 24},
{"bb_dpll_DPLL2", "sel_1sdm"                                 , 0x0001c184, 23, 23},
{"bb_dpll_DPLL2", "pll_pwd"                                  , 0x0001c184, 22, 22},
{"bb_dpll_DPLL2", "outdiv"                                   , 0x0001c184, 21, 19},
{"bb_dpll_DPLL2", "phase_shift"                              , 0x0001c184, 18, 12},
{"bb_dpll_DPLL2", "testin"                                   , 0x0001c184, 11, 2 },
{"bb_dpll_DPLL2", "sel_count"                                , 0x0001c184, 1 , 1 },
{"bb_dpll_DPLL2", "reset_test"                               , 0x0001c184, 0 , 0 },
{"bb_dpll_DPLL3", "do_meas"                                  , 0x0001c188, 31, 31},
{"bb_dpll_DPLL3", "vc_meas0"                                 , 0x0001c188, 30, 13},
{"bb_dpll_DPLL3", "vc_diff0"                                 , 0x0001c188, 12, 3 },
{"bb_dpll_DPLL3", "local_pll_pwd"                            , 0x0001c188, 2 , 2 },
{"bb_dpll_DPLL3", "SPARE"                                    , 0x0001c188, 1 , 0 },
{"synthb_SYNTHB1", "WAIT_CAL_BIN_FINE"                       , 0x0001c1c0, 31, 26},
{"synthb_SYNTHB1", "WAIT_CAL_BIN_COARSE"                     , 0x0001c1c0, 25, 20},
{"synthb_SYNTHB1", "VCOCAPCNT_COARSE_OFFSET"                 , 0x0001c1c0, 19, 14},
{"synthb_SYNTHB1", "VCOCAPCNT_FINE_OFFSET"                   , 0x0001c1c0, 13, 8 },
{"synthb_SYNTHB1", "MAX_LOST_VC_CNT"                         , 0x0001c1c0, 7 , 2 },
{"synthb_SYNTHB1", "RESERVED18A"                             , 0x0001c1c0, 1 , 0 },
{"synthb_SYNTHB2", "VCOCAPCNTSAVED"                          , 0x0001c1c4, 31, 14},
{"synthb_SYNTHB2", "ICP"                                     , 0x0001c1c4, 13, 7 },
{"synthb_SYNTHB2", "VC_MON_ERROR_COUNT"                      , 0x0001c1c4, 6 , 0 },
{"synthb_SYNTHB3", "DLL_SM_STATE"                            , 0x0001c1c8, 31, 30},
{"synthb_SYNTHB3", "DLL_IS_LOCKED"                           , 0x0001c1c8, 29, 29},
{"synthb_SYNTHB3", "DLL_CAPCUR_EXHAUSTED"                    , 0x0001c1c8, 28, 28},
{"synthb_SYNTHB3", "DLL_VCO_CUR_ST"                          , 0x0001c1c8, 27, 25},
{"synthb_SYNTHB3", "DLL_VCO_CAP_ST"                          , 0x0001c1c8, 24, 22},
{"synthb_SYNTHB3", "VCO_CAP_ST_BIN_SEARCH"                   , 0x0001c1c8, 21, 12},
{"synthb_SYNTHB3", "RESERVED_B3A"                            , 0x0001c1c8, 11, 0 },
{"synthb_SYNTHB4", "BANDSEL5G_FREQ_BOUNDARY1"                , 0x0001c1cc, 31, 22},
{"synthb_SYNTHB4", "BANDSEL5G_FREQ_BOUNDARY2"                , 0x0001c1cc, 21, 12},
{"synthb_SYNTHB4", "BANDSEL5G_FREQ_BOUNDARY3"                , 0x0001c1cc, 11, 2 },
{"synthb_SYNTHB4", "RESERVEDB4"                              , 0x0001c1cc, 1 , 0 },
{"top_wlan_PLLCLKMODAWLAN", "rst_warm_int_l"                 , 0x0001c280, 31, 31},
{"top_wlan_PLLCLKMODAWLAN", "local_pllbypass"                , 0x0001c280, 30, 30},
{"top_wlan_PLLCLKMODAWLAN", "pllbypass"                      , 0x0001c280, 29, 29},
{"top_wlan_PLLCLKMODAWLAN", "pwdpllreg"                      , 0x0001c280, 28, 28},
{"top_wlan_PLLCLKMODAWLAN", "global_clk_en"                  , 0x0001c280, 27, 27},
{"top_wlan_PLLCLKMODAWLAN", "local_clkmoda"                  , 0x0001c280, 26, 26},
{"top_wlan_PLLCLKMODAWLAN", "refclk_sel"                     , 0x0001c280, 25, 24},
{"top_wlan_PLLCLKMODAWLAN", "flip_pllclk160"                 , 0x0001c280, 23, 23},
{"top_wlan_PLLCLKMODAWLAN", "flip_pllclk320"                 , 0x0001c280, 22, 22},
{"top_wlan_PLLCLKMODAWLAN", "flip_refclk40"                  , 0x0001c280, 21, 21},
{"top_wlan_PLLCLKMODAWLAN", "clk107_en"                      , 0x0001c280, 20, 20},
{"top_wlan_PLLCLKMODAWLAN", "extclk_en"                      , 0x0001c280, 19, 19},
{"top_wlan_PLLCLKMODAWLAN", "pwdLPO_WLAN"                    , 0x0001c280, 18, 18},
{"top_wlan_PLLCLKMODAWLAN", "rbias_out"                      , 0x0001c280, 17, 12},
{"top_wlan_PLLCLKMODAWLAN", "xlnaon"                         , 0x0001c280, 11, 10},
{"top_wlan_PLLCLKMODAWLAN", "xlna2on_0"                      , 0x0001c280, 9 , 9 },
{"top_wlan_PLLCLKMODAWLAN", "xlna5on_0"                      , 0x0001c280, 8 , 8 },
{"top_wlan_PLLCLKMODAWLAN", "xlnaon_ovr"                     , 0x0001c280, 7 , 7 },
{"top_wlan_PLLCLKMODAWLAN", "pwd_xlnabias"                   , 0x0001c280, 6 , 6 },
{"top_wlan_PLLCLKMODAWLAN", "xlna_drv_strength"              , 0x0001c280, 5 , 4 },
{"top_wlan_PLLCLKMODAWLAN", "clkbufdrvstr2"                  , 0x0001c280, 3 , 2 },
{"top_wlan_PLLCLKMODAWLAN", "clkbufdrvstr1"                  , 0x0001c280, 1 , 0 },
{"top_wlan_TOPWLAN1", "int2gnd"                              , 0x0001c284, 31, 31},
{"top_wlan_TOPWLAN1", "int2pad"                              , 0x0001c284, 30, 30},
{"top_wlan_TOPWLAN1", "intH2gnd"                             , 0x0001c284, 29, 29},
{"top_wlan_TOPWLAN1", "intH2pad"                             , 0x0001c284, 28, 28},
{"top_wlan_TOPWLAN1", "pad2gnd"                              , 0x0001c284, 27, 27},
{"top_wlan_TOPWLAN1", "aioPadMuxEn"                          , 0x0001c284, 26, 26},
{"top_wlan_TOPWLAN1", "pwdbias"                              , 0x0001c284, 25, 25},
{"top_wlan_TOPWLAN1", "pwdv2i"                               , 0x0001c284, 24, 24},
{"top_wlan_TOPWLAN1", "local_xpaon"                          , 0x0001c284, 23, 23},
{"top_wlan_TOPWLAN1", "xpa2on"                               , 0x0001c284, 22, 20},
{"top_wlan_TOPWLAN1", "xpa5on"                               , 0x0001c284, 19, 17},
{"top_wlan_TOPWLAN1", "xpashort2gnd"                         , 0x0001c284, 16, 16},
{"top_wlan_TOPWLAN1", "xpabias_bypass"                       , 0x0001c284, 15, 15},
{"top_wlan_TOPWLAN1", "xparegulator_en"                      , 0x0001c284, 14, 14},
{"top_wlan_TOPWLAN1", "xpabiaslvl"                           , 0x0001c284, 13, 10},
{"top_wlan_TOPWLAN1", "xpabias_atbselect"                    , 0x0001c284, 9 , 9 },
{"top_wlan_TOPWLAN1", "use_WLAN_setting"                     , 0x0001c284, 8 , 8 },
{"top_wlan_TOPWLAN1", "localrbias"                           , 0x0001c284, 7 , 7 },
{"top_wlan_TOPWLAN1", "rbias"                                , 0x0001c284, 6 , 1 },
{"top_wlan_TOPWLAN1", "pll704en"                             , 0x0001c284, 0 , 0 },
{"top_wlan_THERMWLAN", "local_therm"                         , 0x0001c288, 31, 31},
{"top_wlan_THERMWLAN", "sar_autopwd_en"                      , 0x0001c288, 30, 30},
{"top_wlan_THERMWLAN", "thermstart"                          , 0x0001c288, 29, 29},
{"top_wlan_THERMWLAN", "sar_slow_en"                         , 0x0001c288, 28, 28},
{"top_wlan_THERMWLAN", "thermsel"                            , 0x0001c288, 27, 26},
{"top_wlan_THERMWLAN", "sar_adccal_en"                       , 0x0001c288, 25, 25},
{"top_wlan_THERMWLAN", "sar_dactest_en"                      , 0x0001c288, 24, 24},
{"top_wlan_THERMWLAN", "sar_dactest_code"                    , 0x0001c288, 23, 16},
{"top_wlan_THERMWLAN", "sar_adc_out"                         , 0x0001c288, 15, 8 },
{"top_wlan_THERMWLAN", "sar_adc_done"                        , 0x0001c288, 7 , 7 },
{"top_wlan_THERMWLAN", "sel_tempsensor"                      , 0x0001c288, 6 , 6 },
{"top_wlan_THERMWLAN", "therm_forcerst_b"                    , 0x0001c288, 5 , 5 },
{"top_wlan_THERMWLAN", "pwd_swregclk"                        , 0x0001c288, 4 , 4 },
{"top_wlan_THERMWLAN", "flip_swregclk"                       , 0x0001c288, 3 , 3 },
{"top_wlan_THERMWLAN", "reserved"                            , 0x0001c288, 2 , 1 },
{"top_wlan_THERMWLAN", "forcepwdbtclk"                       , 0x0001c288, 0 , 0 },
{"top_wlan_XTALWLAN", "tcxodet"                              , 0x0001c28c, 31, 31},
{"top_wlan_XTALWLAN", "xtal_capindac"                        , 0x0001c28c, 30, 24},
{"top_wlan_XTALWLAN", "xtal_capoutdac"                       , 0x0001c28c, 23, 17},
{"top_wlan_XTALWLAN", "xtal_drvstr"                          , 0x0001c28c, 16, 15},
{"top_wlan_XTALWLAN", "xtal_shortXin"                        , 0x0001c28c, 14, 14},
{"top_wlan_XTALWLAN", "xtal_localbias"                       , 0x0001c28c, 13, 13},
{"top_wlan_XTALWLAN", "xtal_pwdclkD"                         , 0x0001c28c, 12, 12},
{"top_wlan_XTALWLAN", "xtal_bias2x"                          , 0x0001c28c, 11, 11},
{"top_wlan_XTALWLAN", "xtal_Lbias2x"                         , 0x0001c28c, 10, 10},
{"top_wlan_XTALWLAN", "xtal_selvreg"                         , 0x0001c28c, 9 , 9 },
{"top_wlan_XTALWLAN", "xtal_oscon"                           , 0x0001c28c, 8 , 8 },
{"top_wlan_XTALWLAN", "xtal_pwdclkin"                        , 0x0001c28c, 7 , 7 },
{"top_wlan_XTALWLAN", "local_xtal"                           , 0x0001c28c, 6 , 6 },
{"top_wlan_XTALWLAN", "smallRregref"                         , 0x0001c28c, 5 , 5 },
{"top_wlan_XTALWLAN", "smallRbias"                           , 0x0001c28c, 4 , 4 },
{"top_wlan_XTALWLAN", "bibxosc0"                             , 0x0001c28c, 3 , 3 },
{"top_wlan_XTALWLAN", "bibxosc1"                             , 0x0001c28c, 2 , 2 },
{"top_wlan_XTALWLAN", "xoscrefv"                             , 0x0001c28c, 1 , 0 },
{"cpu_dpll_DPLL1", "refdiv"                                  , 0x0001c300, 31, 27},
{"cpu_dpll_DPLL1", "nint"                                    , 0x0001c300, 26, 18},
{"cpu_dpll_DPLL1", "nfrac"                                   , 0x0001c300, 17, 0 },
{"cpu_dpll_DPLL2", "local_pll"                               , 0x0001c304, 31, 31},
{"cpu_dpll_DPLL2", "ki"                                      , 0x0001c304, 30, 29},
{"cpu_dpll_DPLL2", "kd"                                      , 0x0001c304, 28, 25},
{"cpu_dpll_DPLL2", "en_negtrig"                              , 0x0001c304, 24, 24},
{"cpu_dpll_DPLL2", "sel_1sdm"                                , 0x0001c304, 23, 23},
{"cpu_dpll_DPLL2", "pll_pwd"                                 , 0x0001c304, 22, 22},
{"cpu_dpll_DPLL2", "outdiv"                                  , 0x0001c304, 21, 19},
{"cpu_dpll_DPLL2", "phase_shift"                             , 0x0001c304, 18, 12},
{"cpu_dpll_DPLL2", "testin"                                  , 0x0001c304, 11, 2 },
{"cpu_dpll_DPLL2", "sel_count"                               , 0x0001c304, 1 , 1 },
{"cpu_dpll_DPLL2", "reset_test"                              , 0x0001c304, 0 , 0 },
{"cpu_dpll_DPLL3", "do_meas"                                 , 0x0001c308, 31, 31},
{"cpu_dpll_DPLL3", "vc_meas0"                                , 0x0001c308, 30, 13},
{"cpu_dpll_DPLL3", "vc_diff0"                                , 0x0001c308, 12, 3 },
{"cpu_dpll_DPLL3", "local_pll_pwd"                           , 0x0001c308, 2 , 2 },
{"cpu_dpll_DPLL3", "SPARE"                                   , 0x0001c308, 1 , 0 },
{"pmu_wlan_WLAN_PMU1", "swreg"                               , 0x0001c340, 31, 0 },
{"pmu_wlan_WLAN_PMU2", "swregmsb"                            , 0x0001c344, 31, 22},
{"pmu_wlan_WLAN_PMU2", "pgm"                                 , 0x0001c344, 21, 21},
{"pmu_wlan_WLAN_PMU2", "use_WLAN_setting"                    , 0x0001c344, 20, 20},
{"pmu_wlan_WLAN_PMU2", "disc_bit_local"                      , 0x0001c344, 19, 19},
{"pmu_wlan_WLAN_PMU2", "SPARE"                               , 0x0001c344, 18, 0 },
{"rbist_b0_rbist_cntrl", "ate_rx_dc_interleave_power_measurement", 0x0001c380, 21, 21},
{"rbist_b0_rbist_cntrl", "ate_rx_dc_interleave"              , 0x0001c380, 20, 17},
{"rbist_b0_rbist_cntrl", "ate_rbist_enable"                  , 0x0001c380, 16, 16},
{"rbist_b0_rbist_cntrl", "ate_rxdac_calibrate"               , 0x0001c380, 15, 15},
{"rbist_b0_rbist_cntrl", "ate_cmac_power_hpf_enable"         , 0x0001c380, 14, 14},
{"rbist_b0_rbist_cntrl", "ate_cmac_i2q2_enable"              , 0x0001c380, 13, 13},
{"rbist_b0_rbist_cntrl", "ate_cmac_iq_enable"                , 0x0001c380, 12, 12},
{"rbist_b0_rbist_cntrl", "ate_cmac_power_enable"             , 0x0001c380, 11, 11},
{"rbist_b0_rbist_cntrl", "ate_cmac_corr_enable"              , 0x0001c380, 10, 10},
{"rbist_b0_rbist_cntrl", "ate_cmac_dc_enable"                , 0x0001c380, 9 , 9 },
{"rbist_b0_rbist_cntrl", "ate_cmac_dc_write_to_cancel"       , 0x0001c380, 8 , 8 },
{"rbist_b0_rbist_cntrl", "ate_tonegen_prbs_enable_q"         , 0x0001c380, 7 , 7 },
{"rbist_b0_rbist_cntrl", "ate_tonegen_prbs_enable_i"         , 0x0001c380, 6 , 6 },
{"rbist_b0_rbist_cntrl", "ate_tonegen_linramp_enable_q"      , 0x0001c380, 5 , 5 },
{"rbist_b0_rbist_cntrl", "ate_tonegen_linramp_enable_i"      , 0x0001c380, 4 , 4 },
{"rbist_b0_rbist_cntrl", "ate_tonegen_lftone0_enable"        , 0x0001c380, 3 , 3 },
{"rbist_b0_rbist_cntrl", "ate_tonegen_tone1_enable"          , 0x0001c380, 2 , 2 },
{"rbist_b0_rbist_cntrl", "ate_tonegen_tone0_enable"          , 0x0001c380, 1 , 1 },
{"rbist_b0_rbist_cntrl", "ate_tonegen_dc_enable"             , 0x0001c380, 0 , 0 },
{"rbist_b0_tx_dc_offset", "ate_tonegen_dc_q"                 , 0x0001c384, 26, 16},
{"rbist_b0_tx_dc_offset", "ate_tonegen_dc_i"                 , 0x0001c384, 10, 0 },
{"rbist_b0_tx_tonegen0", "ate_tonegen_tone_tau_k"            , 0x0001c388, 31, 24},
{"rbist_b0_tx_tonegen0", "ate_tonegen_tone_backoff_1db"      , 0x0001c388, 18, 16},
{"rbist_b0_tx_tonegen0", "ate_tonegen_tone_backoff_6db"      , 0x0001c388, 11, 8 },
{"rbist_b0_tx_tonegen0", "ate_tonegen_tone_freq"             , 0x0001c388, 7 , 0 },
{"rbist_b0_tx_tonegen1", "ate_tonegen_tone_tau_k"            , 0x0001c38c, 31, 24},
{"rbist_b0_tx_tonegen1", "ate_tonegen_tone_backoff_1db"      , 0x0001c38c, 18, 16},
{"rbist_b0_tx_tonegen1", "ate_tonegen_tone_backoff_6db"      , 0x0001c38c, 11, 8 },
{"rbist_b0_tx_tonegen1", "ate_tonegen_tone_freq"             , 0x0001c38c, 7 , 0 },
{"rbist_b0_tx_lftonegen0", "ate_tonegen_tone_tau_k"          , 0x0001c390, 31, 24},
{"rbist_b0_tx_lftonegen0", "ate_tonegen_tone_backoff_1db"    , 0x0001c390, 18, 16},
{"rbist_b0_tx_lftonegen0", "ate_tonegen_tone_backoff_6db"    , 0x0001c390, 11, 8 },
{"rbist_b0_tx_lftonegen0", "ate_tonegen_tone_freq"           , 0x0001c390, 7 , 0 },
{"rbist_b0_tx_linear_ramp_i", "ate_tonegen_linramp_step"     , 0x0001c394, 29, 24},
{"rbist_b0_tx_linear_ramp_i", "ate_tonegen_linramp_dwell"    , 0x0001c394, 21, 12},
{"rbist_b0_tx_linear_ramp_i", "ate_tonegen_linramp_init"     , 0x0001c394, 10, 0 },
{"rbist_b0_tx_linear_ramp_q", "ate_tonegen_linramp_step"     , 0x0001c398, 29, 24},
{"rbist_b0_tx_linear_ramp_q", "ate_tonegen_linramp_dwell"    , 0x0001c398, 21, 12},
{"rbist_b0_tx_linear_ramp_q", "ate_tonegen_linramp_init"     , 0x0001c398, 10, 0 },
{"rbist_b0_tx_prbs_mag", "ate_tonegen_prbs_magnitude_q"      , 0x0001c39c, 25, 16},
{"rbist_b0_tx_prbs_mag", "ate_tonegen_prbs_magnitude_i"      , 0x0001c39c, 9 , 0 },
{"rbist_b0_tx_prbs_seed_i", "ate_tonegen_prbs_seed"          , 0x0001c3a0, 30, 0 },
{"rbist_b0_tx_prbs_seed_q", "ate_tonegen_prbs_seed"          , 0x0001c3a4, 30, 0 },
{"rbist_b0_cmac_dc_cancel", "ate_cmac_dc_cancel_q"           , 0x0001c3a8, 25, 16},
{"rbist_b0_cmac_dc_cancel", "ate_cmac_dc_cancel_i"           , 0x0001c3a8, 9 , 0 },
{"rbist_b0_cmac_dc_offset", "ate_cmac_dc_cycles"             , 0x0001c3ac, 3 , 0 },
{"rbist_b0_cmac_corr", "ate_cmac_corr_freq"                  , 0x0001c3b0, 14, 8 },
{"rbist_b0_cmac_corr", "ate_cmac_corr_cycles"                , 0x0001c3b0, 4 , 0 },
{"rbist_b0_cmac_power", "ate_cmac_power_cycles"              , 0x0001c3b4, 3 , 0 },
{"rbist_b0_cmac_cross_corr", "ate_cmac_iq_cycles"            , 0x0001c3b8, 3 , 0 },
{"rbist_b0_cmac_i2q2", "ate_cmac_i2q2_cycles"                , 0x0001c3bc, 3 , 0 },
{"rbist_b0_cmac_power_hpf", "ate_cmac_power_hpf_wait"        , 0x0001c3c0, 7 , 4 },
{"rbist_b0_cmac_power_hpf", "ate_cmac_power_hpf_cycles"      , 0x0001c3c0, 3 , 0 },
{"rbist_b0_rxdac_set1", "ate_rxdac_cal_measure_time"         , 0x0001c3c4, 19, 16},
{"rbist_b0_rxdac_set1", "ate_rxdac_cal_wait"                 , 0x0001c3c4, 13, 8 },
{"rbist_b0_rxdac_set1", "ate_rxdac_hi_gain"                  , 0x0001c3c4, 4 , 4 },
{"rbist_b0_rxdac_set1", "ate_rxdac_mux"                      , 0x0001c3c4, 1 , 0 },
{"rbist_b0_rxdac_set2", "ate_rxdac_q_low"                    , 0x0001c3c8, 28, 24},
{"rbist_b0_rxdac_set2", "ate_rxdac_i_low"                    , 0x0001c3c8, 20, 16},
{"rbist_b0_rxdac_set2", "ate_rxdac_q_hi"                     , 0x0001c3c8, 12, 8 },
{"rbist_b0_rxdac_set2", "ate_rxdac_i_hi"                     , 0x0001c3c8, 4 , 0 },
{"rbist_b0_rxdac_long_shift", "ate_rxdac_q_static"           , 0x0001c3cc, 12, 8 },
{"rbist_b0_rxdac_long_shift", "ate_rxdac_i_static"           , 0x0001c3cc, 4 , 0 },
{"rbist_b0_cmac_results_i", "ate_cmac_results"               , 0x0001c3d0, 31, 0 },
{"rbist_b0_cmac_results_q", "ate_cmac_results"               , 0x0001c3d4, 31, 0 },
{"rbist_b0_cmac_results_1_i", "ate_cmac_results"             , 0x0001c3d8, 31, 0 },
{"rbist_b0_cmac_results_1_q", "ate_cmac_results"             , 0x0001c3dc, 31, 0 },
{"rbist_b0_cmac_results_2_i", "ate_cmac_results"             , 0x0001c3e0, 31, 0 },
{"rbist_b0_cmac_results_2_q", "ate_cmac_results"             , 0x0001c3e4, 31, 0 },
{"rbist_b0_cmac_results_3_i", "ate_cmac_results"             , 0x0001c3e8, 31, 0 },
{"rbist_b0_cmac_results_3_q", "ate_cmac_results"             , 0x0001c3ec, 31, 0 },
{"rbist_b0_cmac_dc_cancel_1", "ate_cmac_dc_cancel_q"         , 0x0001c3f0, 25, 16},
{"rbist_b0_cmac_dc_cancel_1", "ate_cmac_dc_cancel_i"         , 0x0001c3f0, 9 , 0 },
{"rbist_b0_cmac_dc_cancel_2", "ate_cmac_dc_cancel_q"         , 0x0001c3f4, 25, 16},
{"rbist_b0_cmac_dc_cancel_2", "ate_cmac_dc_cancel_i"         , 0x0001c3f4, 9 , 0 },
{"rbist_b0_cmac_dc_cancel_3", "ate_cmac_dc_cancel_q"         , 0x0001c3f8, 25, 16},
{"rbist_b0_cmac_dc_cancel_3", "ate_cmac_dc_cancel_i"         , 0x0001c3f8, 9 , 0 },
{"rbist_b0_cmac_gain_comp", "ate_cmac_gain_comp_enable"      , 0x0001c3fc, 31, 31},
{"rbist_b0_cmac_gain_comp", "ate_cmac_gain_comp_q"           , 0x0001c3fc, 13, 8 },
{"rbist_b0_cmac_gain_comp", "ate_cmac_gain_comp_i"           , 0x0001c3fc, 5 , 0 },
{"rxrf_b1_RXRFSA_BIAS1", "PWD_BIAS"                          , 0x0001c400, 31, 31},
{"rxrf_b1_RXRFSA_BIAS1", "PWD_IC75LNA2G"                     , 0x0001c400, 30, 28},
{"rxrf_b1_RXRFSA_BIAS1", "PWD_IC25MXR2GH"                    , 0x0001c400, 27, 25},
{"rxrf_b1_RXRFSA_BIAS1", "PWD_IR25LO24"                      , 0x0001c400, 24, 22},
{"rxrf_b1_RXRFSA_BIAS1", "PWD_IC75LNA5G"                     , 0x0001c400, 21, 19},
{"rxrf_b1_RXRFSA_BIAS1", "PWD_IC25VGA5G"                     , 0x0001c400, 18, 16},
{"rxrf_b1_RXRFSA_BIAS1", "PWD_IC25MXR5GH"                    , 0x0001c400, 15, 13},
{"rxrf_b1_RXRFSA_BIAS1", "PWD_IC25MXR2_5GH"                  , 0x0001c400, 12, 10},
{"rxrf_b1_RXRFSA_BIAS1", "PWD_IC25LO36"                      , 0x0001c400, 9 , 7 },
{"rxrf_b1_RXRFSA_BIAS1", "PWD_IR25LO18"                      , 0x0001c400, 6 , 4 },
{"rxrf_b1_RXRFSA_BIAS1", "PWD_IR25SPARE"                     , 0x0001c400, 3 , 1 },
{"rxrf_b1_RXRFSA_BIAS1", "SPARE"                             , 0x0001c400, 0 , 0 },
{"rxrf_b1_RXRFSA_BIAS2", "PWD_IR25VCM"                       , 0x0001c404, 31, 29},
{"rxrf_b1_RXRFSA_BIAS2", "PWD_IC25VCMBUF"                    , 0x0001c404, 28, 26},
{"rxrf_b1_RXRFSA_BIAS2", "PWD_IC25AGC"                       , 0x0001c404, 25, 23},
{"rxrf_b1_RXRFSA_BIAS2", "PWD_IR25AGC"                       , 0x0001c404, 22, 20},
{"rxrf_b1_RXRFSA_BIAS2", "PWD_IR25AGCH"                      , 0x0001c404, 19, 17},
{"rxrf_b1_RXRFSA_BIAS2", "PWD_IC25LNABUF"                    , 0x0001c404, 16, 14},
{"rxrf_b1_RXRFSA_BIAS2", "PWD_IR25SPARE"                     , 0x0001c404, 13, 11},
{"rxrf_b1_RXRFSA_BIAS2", "PWD_IR25SPAREH"                    , 0x0001c404, 10, 8 },
{"rxrf_b1_RXRFSA_BIAS2", "PWD_VCMBUF"                        , 0x0001c404, 7 , 7 },
{"rxrf_b1_RXRFSA_BIAS2", "VCMVALUE"                          , 0x0001c404, 6 , 4 },
{"rxrf_b1_RXRFSA_BIAS2", "PKEN"                              , 0x0001c404, 3 , 0 },
{"rxrf_b1_RXRFSA_GAINSTAGES", "RX_OVERRIDE"                  , 0x0001c408, 31, 31},
{"rxrf_b1_RXRFSA_GAINSTAGES", "LNA2G_GAIN_OVR"               , 0x0001c408, 30, 28},
{"rxrf_b1_RXRFSA_GAINSTAGES", "MXR2G_GAIN_OVR"               , 0x0001c408, 27, 26},
{"rxrf_b1_RXRFSA_GAINSTAGES", "LNA5G_GAIN_OVR"               , 0x0001c408, 25, 23},
{"rxrf_b1_RXRFSA_GAINSTAGES", "VGA5G_GAIN_OVR"               , 0x0001c408, 22, 20},
{"rxrf_b1_RXRFSA_GAINSTAGES", "MXR5G_GAIN_OVR"               , 0x0001c408, 19, 18},
{"rxrf_b1_RXRFSA_GAINSTAGES", "PWD_LNA2G"                    , 0x0001c408, 17, 17},
{"rxrf_b1_RXRFSA_GAINSTAGES", "PWD_MXR2G"                    , 0x0001c408, 16, 16},
{"rxrf_b1_RXRFSA_GAINSTAGES", "PWD_LO2G"                     , 0x0001c408, 15, 15},
{"rxrf_b1_RXRFSA_GAINSTAGES", "LNA2G_LP"                     , 0x0001c408, 14, 14},
{"rxrf_b1_RXRFSA_GAINSTAGES", "LNA2G_SHORTINP"               , 0x0001c408, 13, 13},
{"rxrf_b1_RXRFSA_GAINSTAGES", "LNA2G_CAP"                    , 0x0001c408, 12, 11},
{"rxrf_b1_RXRFSA_GAINSTAGES", "PWD_LNA5G"                    , 0x0001c408, 10, 10},
{"rxrf_b1_RXRFSA_GAINSTAGES", "PWD_MXR5G"                    , 0x0001c408, 9 , 9 },
{"rxrf_b1_RXRFSA_GAINSTAGES", "PWD_VGA5G"                    , 0x0001c408, 8 , 8 },
{"rxrf_b1_RXRFSA_GAINSTAGES", "PWD_LO5G"                     , 0x0001c408, 7 , 7 },
{"rxrf_b1_RXRFSA_GAINSTAGES", "LNA5G_SHORTINP"               , 0x0001c408, 6 , 6 },
{"rxrf_b1_RXRFSA_GAINSTAGES", "LNA5G_CAP"                    , 0x0001c408, 5 , 4 },
{"rxrf_b1_RXRFSA_GAINSTAGES", "VGA5G_CAP"                    , 0x0001c408, 3 , 2 },
{"rxrf_b1_RXRFSA_GAINSTAGES", "LNAON_CALDC"                  , 0x0001c408, 1 , 1 },
{"rxrf_b1_RXRFSA_GAINSTAGES", "SPARE"                        , 0x0001c408, 0 , 0 },
{"rxrf_b1_RXRFSA_AGC", "AGC_OVERRIDE"                        , 0x0001c40c, 31, 31},
{"rxrf_b1_RXRFSA_AGC", "AGC_ON_OVR"                          , 0x0001c40c, 30, 30},
{"rxrf_b1_RXRFSA_AGC", "AGC_CAL_OVR"                         , 0x0001c40c, 29, 29},
{"rxrf_b1_RXRFSA_AGC", "AGC2G_DBDAC_OVR"                     , 0x0001c40c, 28, 25},
{"rxrf_b1_RXRFSA_AGC", "AGC2G_CALDAC_OVR"                    , 0x0001c40c, 24, 19},
{"rxrf_b1_RXRFSA_AGC", "AGC5G_DBDAC_OVR"                     , 0x0001c40c, 18, 15},
{"rxrf_b1_RXRFSA_AGC", "AGC5G_CALDAC_OVR"                    , 0x0001c40c, 14, 9 },
{"rxrf_b1_RXRFSA_AGC", "AGC_FALL_CTRL"                       , 0x0001c40c, 8 , 6 },
{"rxrf_b1_RXRFSA_AGC", "PWD_LNABUF"                          , 0x0001c40c, 5 , 5 },
{"rxrf_b1_RXRFSA_AGC", "LNABUF_PWD_OVR"                      , 0x0001c40c, 4 , 4 },
{"rxrf_b1_RXRFSA_AGC", "LNABUFGAIN2X"                        , 0x0001c40c, 3 , 3 },
{"rxrf_b1_RXRFSA_AGC", "AGC_OUT"                             , 0x0001c40c, 2 , 2 },
{"rxrf_b1_RXRFSA_AGC", "RF2G_ON_DURING_CALPA"                , 0x0001c40c, 1 , 1 },
{"rxrf_b1_RXRFSA_AGC", "RF5G_ON_DURING_CALPA"                , 0x0001c40c, 0 , 0 },
{"rxrf_b1_RXRFSA_BIAS3", "PWD_IC50AIC"                       , 0x0001c410, 31, 29},
{"rxrf_b1_RXRFSA_BIAS3", "PWD_IC50LNABUF2G"                  , 0x0001c410, 28, 26},
{"rxrf_b1_RXRFSA_BIAS3", "PWD_IC25SPARE"                     , 0x0001c410, 25, 23},
{"rxrf_b1_RXRFSA_BIAS3", "MXRFORCEDON"                       , 0x0001c410, 22, 22},
{"rxrf_b1_RXRFSA_BIAS3", "BT_LNA_CNT_OVR"                    , 0x0001c410, 21, 21},
{"rxrf_b1_RXRFSA_BIAS3", "USE_BT_LNA"                        , 0x0001c410, 20, 20},
{"rxrf_b1_RXRFSA_BIAS3", "PWD_AICGM"                         , 0x0001c410, 19, 19},
{"rxrf_b1_RXRFSA_BIAS3", "PWD_AICGM_OVR"                     , 0x0001c410, 18, 18},
{"rxrf_b1_RXRFSA_BIAS3", "AICSTBY_ENABLE"                    , 0x0001c410, 17, 17},
{"rxrf_b1_RXRFSA_BIAS3", "AICSTBY_VGAON_ENABLE"              , 0x0001c410, 16, 16},
{"rxrf_b1_RXRFSA_BIAS3", "KEEPLNABUF2GCASCON"                , 0x0001c410, 15, 15},
{"rxrf_b1_RXRFSA_BIAS3", "shortbiasres_div2grx"              , 0x0001c410, 14, 14},
{"rxrf_b1_RXRFSA_BIAS3", "shortbiasres_div5grx"              , 0x0001c410, 13, 13},
{"rxrf_b1_RXRFSA_BIAS3", "CONTROLSPARE"                      , 0x0001c410, 12, 0 },
{"txrf_b1_TXRFSA1", "localtxgain2G"                          , 0x0001c440, 31, 31},
{"txrf_b1_TXRFSA1", "padrvgn2G"                              , 0x0001c440, 30, 24},
{"txrf_b1_TXRFSA1", "LOdiv2Gforced"                          , 0x0001c440, 23, 23},
{"txrf_b1_TXRFSA1", "LObuf2Gforced"                          , 0x0001c440, 22, 22},
{"txrf_b1_TXRFSA1", "pdlodiv2G"                              , 0x0001c440, 21, 21},
{"txrf_b1_TXRFSA1", "pdlobuf2G"                              , 0x0001c440, 20, 20},
{"txrf_b1_TXRFSA1", "pdmxr2G"                                , 0x0001c440, 19, 19},
{"txrf_b1_TXRFSA1", "pdDR2G"                                 , 0x0001c440, 18, 18},
{"txrf_b1_TXRFSA1", "pdout2G"                                , 0x0001c440, 17, 17},
{"txrf_b1_TXRFSA1", "localtxgain5G"                          , 0x0001c440, 16, 16},
{"txrf_b1_TXRFSA1", "padrv3gn5G"                             , 0x0001c440, 15, 12},
{"txrf_b1_TXRFSA1", "padrv2gn5G_main"                        , 0x0001c440, 11, 9 },
{"txrf_b1_TXRFSA1", "padrv2gn5G_aux1"                        , 0x0001c440, 8 , 6 },
{"txrf_b1_TXRFSA1", "padrv2gn5G_aux2"                        , 0x0001c440, 5 , 3 },
{"txrf_b1_TXRFSA1", "reserved_PA2G"                          , 0x0001c440, 2 , 0 },
{"txrf_b1_TXRFSA2", "pdmxr5G"                                , 0x0001c444, 31, 31},
{"txrf_b1_TXRFSA2", "LOdiv5Gforced"                          , 0x0001c444, 30, 30},
{"txrf_b1_TXRFSA2", "LObuf5Gforced"                          , 0x0001c444, 29, 29},
{"txrf_b1_TXRFSA2", "pdlodiv5G"                              , 0x0001c444, 28, 28},
{"txrf_b1_TXRFSA2", "pdlobuf5G"                              , 0x0001c444, 27, 27},
{"txrf_b1_TXRFSA2", "pdout5G"                                , 0x0001c444, 26, 24},
{"txrf_b1_TXRFSA2", "db2G"                                   , 0x0001c444, 23, 21},
{"txrf_b1_TXRFSA2", "ob2G_cck"                               , 0x0001c444, 20, 18},
{"txrf_b1_TXRFSA2", "ob2G_psk"                               , 0x0001c444, 17, 15},
{"txrf_b1_TXRFSA2", "ob2G_qam"                               , 0x0001c444, 14, 12},
{"txrf_b1_TXRFSA2", "ob2G_softpd"                            , 0x0001c444, 11, 9 },
{"txrf_b1_TXRFSA2", "dcas2G"                                 , 0x0001c444, 8 , 6 },
{"txrf_b1_TXRFSA2", "ocas2G_wlan"                            , 0x0001c444, 5 , 3 },
{"txrf_b1_TXRFSA2", "reserved_PA2G"                          , 0x0001c444, 2 , 0 },
{"txrf_b1_TXRFSA3", "obdboffst2G_aux1"                       , 0x0001c448, 31, 29},
{"txrf_b1_TXRFSA3", "obdboffst2G_aux2"                       , 0x0001c448, 28, 26},
{"txrf_b1_TXRFSA3", "d3b5G"                                  , 0x0001c448, 25, 23},
{"txrf_b1_TXRFSA3", "d2b5G"                                  , 0x0001c448, 22, 20},
{"txrf_b1_TXRFSA3", "ob5G_cck"                               , 0x0001c448, 19, 17},
{"txrf_b1_TXRFSA3", "ob5G_psk"                               , 0x0001c448, 16, 14},
{"txrf_b1_TXRFSA3", "ob5G_qam"                               , 0x0001c448, 13, 11},
{"txrf_b1_TXRFSA3", "obdboffst5G_aux1"                       , 0x0001c448, 10, 8 },
{"txrf_b1_TXRFSA3", "obdboffst5G_aux2"                       , 0x0001c448, 7 , 5 },
{"txrf_b1_TXRFSA3", "d3cas5G"                                , 0x0001c448, 4 , 2 },
{"txrf_b1_TXRFSA3", "reserved_3"                             , 0x0001c448, 1 , 0 },
{"txrf_b1_TXRFSA4", "d1cas5G_main"                           , 0x0001c44c, 31, 29},
{"txrf_b1_TXRFSA4", "d1cas5G_aux1"                           , 0x0001c44c, 28, 26},
{"txrf_b1_TXRFSA4", "d1cas5G_aux2"                           , 0x0001c44c, 25, 23},
{"txrf_b1_TXRFSA4", "d2cas5G_main"                           , 0x0001c44c, 22, 20},
{"txrf_b1_TXRFSA4", "d2cas5G_aux1"                           , 0x0001c44c, 19, 17},
{"txrf_b1_TXRFSA4", "d2cas5G_aux2"                           , 0x0001c44c, 16, 14},
{"txrf_b1_TXRFSA4", "btob_wlan"                              , 0x0001c44c, 13, 11},
{"txrf_b1_TXRFSA4", "btob_softpd_wlan"                       , 0x0001c44c, 10, 8 },
{"txrf_b1_TXRFSA4", "PAforcedon_WLAN"                        , 0x0001c44c, 7 , 7 },
{"txrf_b1_TXRFSA4", "usebtob_wlansr"                         , 0x0001c44c, 6 , 6 },
{"txrf_b1_TXRFSA4", "pwd_ic25aic"                            , 0x0001c44c, 5 , 3 },
{"txrf_b1_TXRFSA4", "pwd_ic25spare"                          , 0x0001c44c, 2 , 0 },
{"txrf_b1_TXRFSA5", "AICstby_enable"                         , 0x0001c450, 31, 31},
{"txrf_b1_TXRFSA5", "local_AICpwd"                           , 0x0001c450, 30, 30},
{"txrf_b1_TXRFSA5", "pwdAICvgaI_ls"                          , 0x0001c450, 29, 29},
{"txrf_b1_TXRFSA5", "pwdAICvgaQ_ls"                          , 0x0001c450, 28, 28},
{"txrf_b1_TXRFSA5", "csteer_en"                              , 0x0001c450, 27, 27},
{"txrf_b1_TXRFSA5", "reserved7_1"                            , 0x0001c450, 26, 0 },
{"txrf_b1_TXRFSA6", "pdpredist2G"                            , 0x0001c454, 31, 31},
{"txrf_b1_TXRFSA6", "capdiv2G_predist"                       , 0x0001c454, 30, 27},
{"txrf_b1_TXRFSA6", "rdiv2G"                                 , 0x0001c454, 26, 25},
{"txrf_b1_TXRFSA6", "pdpredist5G"                            , 0x0001c454, 24, 24},
{"txrf_b1_TXRFSA6", "capdiv5G"                               , 0x0001c454, 23, 21},
{"txrf_b1_TXRFSA6", "rdiv5G"                                 , 0x0001c454, 20, 19},
{"txrf_b1_TXRFSA6", "caltxshiftovr"                          , 0x0001c454, 18, 18},
{"txrf_b1_TXRFSA6", "caltxshift"                             , 0x0001c454, 17, 17},
{"txrf_b1_TXRFSA6", "db2Gcaltx"                              , 0x0001c454, 16, 14},
{"txrf_b1_TXRFSA6", "padrvgn2Gcaltx"                         , 0x0001c454, 13, 7 },
{"txrf_b1_TXRFSA6", "d3b5Gcaltx"                             , 0x0001c454, 6 , 4 },
{"txrf_b1_TXRFSA6", "pdout5G_3caltx"                         , 0x0001c454, 3 , 3 },
{"txrf_b1_TXRFSA6", "reserved_5"                             , 0x0001c454, 2 , 0 },
{"txrf_b1_TXRFSA7", "pwd_ic25mixbuf5G"                       , 0x0001c458, 31, 29},
{"txrf_b1_TXRFSA7", "pwd_ir25pa5G1"                          , 0x0001c458, 28, 26},
{"txrf_b1_TXRFSA7", "pwd_ir25pa5G2"                          , 0x0001c458, 25, 23},
{"txrf_b1_TXRFSA7", "pwd_ic25tempsen"                        , 0x0001c458, 22, 20},
{"txrf_b1_TXRFSA7", "pwdWLAN_ic25paBT"                       , 0x0001c458, 19, 17},
{"txrf_b1_TXRFSA7", "pwd_ir25mixdiv2G"                       , 0x0001c458, 16, 14},
{"txrf_b1_TXRFSA7", "pwd_ir25mixbias2G"                      , 0x0001c458, 13, 11},
{"txrf_b1_TXRFSA7", "pwdWLAN_ir25pa2G"                       , 0x0001c458, 10, 8 },
{"txrf_b1_TXRFSA7", "pwd_ir25mixdiv5G"                       , 0x0001c458, 7 , 5 },
{"txrf_b1_TXRFSA7", "AICcapdivmasking_b"                     , 0x0001c458, 4 , 4 },
{"txrf_b1_TXRFSA7", "shortbiasres_div5gtx"                   , 0x0001c458, 3 , 3 },
{"txrf_b1_TXRFSA7", "offst_aux2_m2_21"                       , 0x0001c458, 2 , 1 },
{"txrf_b1_TXRFSA7", "shortbiasres_div2gtx"                   , 0x0001c458, 0 , 0 },
{"txrf_b1_TXRFSA8", "pwd_ir25mixbias5G"                      , 0x0001c45c, 31, 29},
{"txrf_b1_TXRFSA8", "bias_cgm_igsel_pa2G"                    , 0x0001c45c, 28, 25},
{"txrf_b1_TXRFSA8", "bias_cgm_icsel_pa2G"                    , 0x0001c45c, 24, 21},
{"txrf_b1_TXRFSA8", "bias_cgm_igsel_pa5G"                    , 0x0001c45c, 20, 17},
{"txrf_b1_TXRFSA8", "bias_cgm_icsel_pa5G"                    , 0x0001c45c, 16, 13},
{"txrf_b1_TXRFSA8", "pwd_ir25tempsen"                        , 0x0001c45c, 12, 10},
{"txrf_b1_TXRFSA8", "pwd_irspare"                            , 0x0001c45c, 9 , 7 },
{"txrf_b1_TXRFSA8", "shshobdb2G"                             , 0x0001c45c, 6 , 6 },
{"txrf_b1_TXRFSA8", "shshobdb5G"                             , 0x0001c45c, 5 , 5 },
{"txrf_b1_TXRFSA8", "reserved6_2"                            , 0x0001c45c, 4 , 0 },
{"txrf_b1_TXRFSA9", "pa5g_ind_swTbl"                         , 0x0001c460, 31, 29},
{"txrf_b1_TXRFSA9", "offst_aux2_m2_0"                        , 0x0001c460, 28, 28},
{"txrf_b1_TXRFSA9", "offst_aux2_m1"                          , 0x0001c460, 27, 25},
{"txrf_b1_TXRFSA9", "pa5g_cap_swTbl_01"                      , 0x0001c460, 24, 22},
{"txrf_b1_TXRFSA9", "pa5g_cap_swTbl_10"                      , 0x0001c460, 21, 19},
{"txrf_b1_TXRFSA9", "pa5g_cap_swTbl_11"                      , 0x0001c460, 18, 16},
{"txrf_b1_TXRFSA9", "ATBsel2G"                               , 0x0001c460, 15, 12},
{"txrf_b1_TXRFSA9", "ATBsel5G"                               , 0x0001c460, 11, 8 },
{"txrf_b1_TXRFSA9", "reserved7"                              , 0x0001c460, 7 , 0 },
{"rxtx_b1_RXTX1", "mantxgain"                                , 0x0001c500, 31, 31},
{"rxtx_b1_RXTX1", "padrv3gn5g"                               , 0x0001c500, 30, 27},
{"rxtx_b1_RXTX1", "padrv2gn5g"                               , 0x0001c500, 26, 24},
{"rxtx_b1_RXTX1", "padrv2gn2g"                               , 0x0001c500, 23, 20},
{"rxtx_b1_RXTX1", "padrvhalfgn2g"                            , 0x0001c500, 19, 19},
{"rxtx_b1_RXTX1", "ovr_agc_dbdac"                            , 0x0001c500, 18, 18},
{"rxtx_b1_RXTX1", "agc_dbdac"                                , 0x0001c500, 17, 14},
{"rxtx_b1_RXTX1", "manrxgain"                                , 0x0001c500, 13, 13},
{"rxtx_b1_RXTX1", "lnagain"                                  , 0x0001c500, 12, 10},
{"rxtx_b1_RXTX1", "vgagain"                                  , 0x0001c500, 9 , 7 },
{"rxtx_b1_RXTX1", "mxrgain"                                  , 0x0001c500, 6 , 5 },
{"rxtx_b1_RXTX1", "reserved"                                 , 0x0001c500, 4 , 0 },
{"rxtx_b1_RXTX2", "agcon_ovr"                                , 0x0001c504, 31, 31},
{"rxtx_b1_RXTX2", "agcon"                                    , 0x0001c504, 30, 30},
{"rxtx_b1_RXTX2", "txmod_ovr"                                , 0x0001c504, 29, 29},
{"rxtx_b1_RXTX2", "txmod"                                    , 0x0001c504, 28, 26},
{"rxtx_b1_RXTX2", "rxon_ovr"                                 , 0x0001c504, 25, 25},
{"rxtx_b1_RXTX2", "rxon"                                     , 0x0001c504, 24, 24},
{"rxtx_b1_RXTX2", "paon_ovr"                                 , 0x0001c504, 23, 23},
{"rxtx_b1_RXTX2", "paon"                                     , 0x0001c504, 22, 22},
{"rxtx_b1_RXTX2", "txon_ovr"                                 , 0x0001c504, 21, 21},
{"rxtx_b1_RXTX2", "txon"                                     , 0x0001c504, 20, 20},
{"rxtx_b1_RXTX2", "BW_ST_ovr"                                , 0x0001c504, 19, 19},
{"rxtx_b1_RXTX2", "BW_ST"                                    , 0x0001c504, 18, 16},
{"rxtx_b1_RXTX2", "synthon_ovr"                              , 0x0001c504, 15, 15},
{"rxtx_b1_RXTX2", "synthon"                                  , 0x0001c504, 14, 14},
{"rxtx_b1_RXTX2", "bmode_ovr"                                , 0x0001c504, 13, 13},
{"rxtx_b1_RXTX2", "bmode"                                    , 0x0001c504, 12, 12},
{"rxtx_b1_RXTX2", "calpa_ovr"                                , 0x0001c504, 11, 11},
{"rxtx_b1_RXTX2", "calpa"                                    , 0x0001c504, 10, 10},
{"rxtx_b1_RXTX2", "caltxshift_ovr"                           , 0x0001c504, 9 , 9 },
{"rxtx_b1_RXTX2", "caltxshift"                               , 0x0001c504, 8 , 8 },
{"rxtx_b1_RXTX2", "caltx_ovr"                                , 0x0001c504, 7 , 7 },
{"rxtx_b1_RXTX2", "caltx"                                    , 0x0001c504, 6 , 6 },
{"rxtx_b1_RXTX2", "calfc_ovr"                                , 0x0001c504, 5 , 5 },
{"rxtx_b1_RXTX2", "calfc"                                    , 0x0001c504, 4 , 4 },
{"rxtx_b1_RXTX2", "calresidue_ovr"                           , 0x0001c504, 3 , 3 },
{"rxtx_b1_RXTX2", "calresidue"                               , 0x0001c504, 2 , 2 },
{"rxtx_b1_RXTX2", "LOforcedon"                               , 0x0001c504, 1 , 1 },
{"rxtx_b1_RXTX2", "reserved"                                 , 0x0001c504, 0 , 0 },
{"rxtx_b1_RXTX3", "agc_cal_ovr"                              , 0x0001c508, 31, 31},
{"rxtx_b1_RXTX3", "agc_cal"                                  , 0x0001c508, 30, 30},
{"rxtx_b1_RXTX3", "agc_caldac"                               , 0x0001c508, 29, 24},
{"rxtx_b1_RXTX3", "adc_samp_rate_ovr"                        , 0x0001c508, 23, 23},
{"rxtx_b1_RXTX3", "adc_samp_rate"                            , 0x0001c508, 22, 21},
{"rxtx_b1_RXTX3", "calrx_ovr"                                , 0x0001c508, 20, 20},
{"rxtx_b1_RXTX3", "calrx"                                    , 0x0001c508, 19, 19},
{"rxtx_b1_RXTX3", "caladcoffset_ovr"                         , 0x0001c508, 18, 18},
{"rxtx_b1_RXTX3", "caladcoffset"                             , 0x0001c508, 17, 17},
{"rxtx_b1_RXTX3", "calxpa_ovr"                               , 0x0001c508, 16, 16},
{"rxtx_b1_RXTX3", "calxpa"                                   , 0x0001c508, 15, 15},
{"rxtx_b1_RXTX3", "xlnaon_ovr"                               , 0x0001c508, 14, 14},
{"rxtx_b1_RXTX3", "xlnaon"                                   , 0x0001c508, 13, 13},
{"rxtx_b1_RXTX3", "xlnabias_pwd"                             , 0x0001c508, 12, 12},
{"rxtx_b1_RXTX3", "reserved"                                 , 0x0001c508, 11, 0 },
{"rxtx_b1_RXTX4", "xlna_strength"                            , 0x0001c50c, 31, 30},
{"rxtx_b1_RXTX4", "thermOn_ovr"                              , 0x0001c50c, 29, 29},
{"rxtx_b1_RXTX4", "thermOn"                                  , 0x0001c50c, 28, 28},
{"rxtx_b1_RXTX4", "txswen"                                   , 0x0001c50c, 25, 25},
{"rxtx_b1_RXTX4", "txswen_ovr"                               , 0x0001c50c, 24, 24},
{"rxtx_b1_RXTX4", "AICcapdiv2GI"                             , 0x0001c50c, 23, 20},
{"rxtx_b1_RXTX4", "AICcapdiv2GQ"                             , 0x0001c50c, 19, 16},
{"rxtx_b1_RXTX4", "AICvga_gnI"                               , 0x0001c50c, 15, 11},
{"rxtx_b1_RXTX4", "AICvga_gnQ"                               , 0x0001c50c, 10, 6 },
{"rxtx_b1_RXTX4", "AICinvI"                                  , 0x0001c50c, 5 , 5 },
{"rxtx_b1_RXTX4", "AICinvQ"                                  , 0x0001c50c, 4 , 4 },
{"rxtx_b1_RXTX4", "AICgmgn6dB"                               , 0x0001c50c, 3 , 0 },
{"rxtx_b1_RXTX5", "AICgmHP"                                  , 0x0001c510, 31, 31},
{"rxtx_b1_RXTX5", "AIClocal_mode"                            , 0x0001c510, 30, 30},
{"rxtx_b1_RXTX5", "AICon"                                    , 0x0001c510, 29, 29},
{"rxtx_b1_RXTX5", "AICstby"                                  , 0x0001c510, 28, 28},
{"rxtx_b1_RXTX5", "AIC_chanOvr"                              , 0x0001c510, 27, 26},
{"rxtx_b1_RXTX5", "AIC_loadChannel"                          , 0x0001c510, 25, 25},
{"rxtx_b1_RXTX5", "testIQ_rsel"                              , 0x0001c510, 24, 24},
{"rxtx_b1_RXTX5", "testIQ_bufen"                             , 0x0001c510, 23, 23},
{"rxtx_b1_RXTX5", "testI_on"                                 , 0x0001c510, 22, 22},
{"rxtx_b1_RXTX5", "testQ_on"                                 , 0x0001c510, 21, 21},
{"rxtx_b1_RXTX5", "bbreplace_en"                             , 0x0001c510, 20, 20},
{"rxtx_b1_RXTX5", "RESERVED5"                                , 0x0001c510, 19, 0 },
{"bb_b1_BB1", "RANGE_OSDAC"                                  , 0x0001c540, 31, 30},
{"bb_b1_BB1", "LOCALOFFSET"                                  , 0x0001c540, 29, 29},
{"bb_b1_BB1", "OFSTCORRI2VI"                                 , 0x0001c540, 28, 24},
{"bb_b1_BB1", "OFSTCORRI2VQ"                                 , 0x0001c540, 23, 19},
{"bb_b1_BB1", "ATBSEL"                                       , 0x0001c540, 18, 16},
{"bb_b1_BB1", "CMSEL1"                                       , 0x0001c540, 15, 13},
{"bb_b1_BB1", "CMSEL2"                                       , 0x0001c540, 12, 10},
{"bb_b1_BB1", "PWD_RCFILT_OVR"                               , 0x0001c540, 9 , 9 },
{"bb_b1_BB1", "PWD_RCFILT"                                   , 0x0001c540, 8 , 8 },
{"bb_b1_BB1", "PWD_V2I_OVR"                                  , 0x0001c540, 7 , 7 },
{"bb_b1_BB1", "PWD_V2I"                                      , 0x0001c540, 6 , 6 },
{"bb_b1_BB1", "PWD_OSDAC_OVR"                                , 0x0001c540, 5 , 5 },
{"bb_b1_BB1", "PWD_OSDAC"                                    , 0x0001c540, 4 , 4 },
{"bb_b1_BB1", "PWD_BIQUAD1_OVR"                              , 0x0001c540, 3 , 3 },
{"bb_b1_BB1", "PWD_BIQUAD1"                                  , 0x0001c540, 2 , 2 },
{"bb_b1_BB1", "PWD_BIQUAD2_OVR"                              , 0x0001c540, 1 , 1 },
{"bb_b1_BB1", "PWD_BIQUAD2"                                  , 0x0001c540, 0 , 0 },
{"bb_b1_BB2", "SWITCH_OVERRIDE"                              , 0x0001c544, 31, 31},
{"bb_b1_BB2", "RXIN2RC_EN"                                   , 0x0001c544, 30, 30},
{"bb_b1_BB2", "RC2BQ1_EN"                                    , 0x0001c544, 29, 29},
{"bb_b1_BB2", "RC2RXOUT_EN"                                  , 0x0001c544, 28, 28},
{"bb_b1_BB2", "BQ2RXOUT_EN"                                  , 0x0001c544, 27, 27},
{"bb_b1_BB2", "NOTCHON"                                      , 0x0001c544, 26, 26},
{"bb_b1_BB2", "BYPASSBQ1_EN"                                 , 0x0001c544, 25, 25},
{"bb_b1_BB2", "BQ2V2I_EN"                                    , 0x0001c544, 24, 24},
{"bb_b1_BB2", "DAC2V2I_EN"                                   , 0x0001c544, 23, 23},
{"bb_b1_BB2", "FILTERFC_OVR"                                 , 0x0001c544, 22, 22},
{"bb_b1_BB2", "FILTERFC"                                     , 0x0001c544, 21, 17},
{"bb_b1_BB2", "FNOTCH_OVR"                                   , 0x0001c544, 16, 16},
{"bb_b1_BB2", "FNOTCH"                                       , 0x0001c544, 15, 12},
{"bb_b1_BB2", "REMOVECAP_RCFILT_OVR"                         , 0x0001c544, 11, 11},
{"bb_b1_BB2", "REMOVECAP_RCFILT"                             , 0x0001c544, 10, 10},
{"bb_b1_BB2", "dac_clk_inv"                                  , 0x0001c544, 9 , 9 },
{"bb_b1_BB2", "btcpupll_clkbufdrvstr"                        , 0x0001c544, 8 , 7 },
{"bb_b1_BB2", "flip_adc_str_clk"                             , 0x0001c544, 6 , 6 },
{"bb_b1_BB2", "SEL_TEST"                                     , 0x0001c544, 5 , 0 },
{"bb_b1_BB3", "pll704en"                                     , 0x0001c548, 31, 31},
{"bb_b1_BB3", "OFSTCORRI2VI"                                 , 0x0001c548, 30, 26},
{"bb_b1_BB3", "OFSTCORRI2VQ"                                 , 0x0001c548, 25, 21},
{"bb_b1_BB3", "FILTERFC"                                     , 0x0001c548, 20, 16},
{"bb_b1_BB3", "RX_FILTERFC"                                  , 0x0001c548, 15, 11},
{"bb_b1_BB3", "TX_FILTERFC"                                  , 0x0001c548, 10, 6 },
{"bb_b1_BB3", "SEL_OFST_READBK"                              , 0x0001c548, 5 , 4 },
{"bb_b1_BB3", "ADC_COMPBIAS"                                 , 0x0001c548, 3 , 2 },
{"bb_b1_BB3", "DOUBLE_RCFILT_CURR"                           , 0x0001c548, 1 , 1 },
{"bb_b1_BB3", "PWD_BB_BIAS_OVR"                              , 0x0001c548, 0 , 0 },
{"bb_b1_BB4", "RX_RXIN2RC_EN"                                , 0x0001c54c, 31, 31},
{"bb_b1_BB4", "RX_RC2BQ1_EN"                                 , 0x0001c54c, 30, 30},
{"bb_b1_BB4", "RX_RC2RXOUT_EN"                               , 0x0001c54c, 29, 29},
{"bb_b1_BB4", "RX_BQ2RXOUT_EN"                               , 0x0001c54c, 28, 28},
{"bb_b1_BB4", "RX_NOTCHON"                                   , 0x0001c54c, 27, 27},
{"bb_b1_BB4", "RX_BYPASSBQ1_EN"                              , 0x0001c54c, 26, 26},
{"bb_b1_BB4", "RX_BQ2V2I_EN"                                 , 0x0001c54c, 25, 25},
{"bb_b1_BB4", "RX_DAC2V2I_EN"                                , 0x0001c54c, 24, 24},
{"bb_b1_BB4", "RX_PWD_RCFILT"                                , 0x0001c54c, 23, 23},
{"bb_b1_BB4", "RX_PWD_V2I"                                   , 0x0001c54c, 22, 22},
{"bb_b1_BB4", "RX_PWD_BIQUAD1"                               , 0x0001c54c, 21, 21},
{"bb_b1_BB4", "RX_PWD_BIQUAD2"                               , 0x0001c54c, 20, 20},
{"bb_b1_BB4", "RX_REMOVECAP_RCFILT"                          , 0x0001c54c, 19, 19},
{"bb_b1_BB4", "RX_NOTCH_HALFBW"                              , 0x0001c54c, 18, 18},
{"bb_b1_BB4", "TX_RXIN2RC_EN"                                , 0x0001c54c, 17, 17},
{"bb_b1_BB4", "TX_RC2BQ1_EN"                                 , 0x0001c54c, 16, 16},
{"bb_b1_BB4", "TX_RC2RXOUT_EN"                               , 0x0001c54c, 15, 15},
{"bb_b1_BB4", "TX_BQ2RXOUT_EN"                               , 0x0001c54c, 14, 14},
{"bb_b1_BB4", "TX_NOTCHON"                                   , 0x0001c54c, 13, 13},
{"bb_b1_BB4", "TX_BYPASSBQ1_EN"                              , 0x0001c54c, 12, 12},
{"bb_b1_BB4", "TX_BQ2V2I_EN"                                 , 0x0001c54c, 11, 11},
{"bb_b1_BB4", "TX_DAC2V2I_EN"                                , 0x0001c54c, 10, 10},
{"bb_b1_BB4", "TX_PWD_RCFILT"                                , 0x0001c54c, 9 , 9 },
{"bb_b1_BB4", "TX_PWD_V2I"                                   , 0x0001c54c, 8 , 8 },
{"bb_b1_BB4", "TX_PWD_BIQUAD1"                               , 0x0001c54c, 7 , 7 },
{"bb_b1_BB4", "TX_PWD_BIQUAD2"                               , 0x0001c54c, 6 , 6 },
{"bb_b1_BB4", "TX_REMOVECAP_RCFILT"                          , 0x0001c54c, 5 , 5 },
{"bb_b1_BB4", "TX_NOTCH_HALFBW"                              , 0x0001c54c, 4 , 4 },
{"bb_b1_BB4", "ADC_DEC_DELAYBIAS"                            , 0x0001c54c, 3 , 2 },
{"bb_b1_BB4", "ADC_INC_DELAYBIAS"                            , 0x0001c54c, 1 , 1 },
{"bb_b1_BB4", "ADC_COMP_RESET"                               , 0x0001c54c, 0 , 0 },
{"bb_b1_BB5", "CALRX_RXIN2RC_EN"                             , 0x0001c550, 31, 31},
{"bb_b1_BB5", "CALRX_RC2BQ1_EN"                              , 0x0001c550, 30, 30},
{"bb_b1_BB5", "CALRX_RC2RXOUT_EN"                            , 0x0001c550, 29, 29},
{"bb_b1_BB5", "CALRX_BQ2RXOUT_EN"                            , 0x0001c550, 28, 28},
{"bb_b1_BB5", "CALRX_NOTCHON"                                , 0x0001c550, 27, 27},
{"bb_b1_BB5", "CALRX_BYPASSBQ1_EN"                           , 0x0001c550, 26, 26},
{"bb_b1_BB5", "CALRX_BQ2V2I_EN"                              , 0x0001c550, 25, 25},
{"bb_b1_BB5", "CALRX_DAC2V2I_EN"                             , 0x0001c550, 24, 24},
{"bb_b1_BB5", "CALRX_PWD_RCFILT"                             , 0x0001c550, 23, 23},
{"bb_b1_BB5", "CALRX_PWD_V2I"                                , 0x0001c550, 22, 22},
{"bb_b1_BB5", "CALRX_PWD_BIQUAD1"                            , 0x0001c550, 21, 21},
{"bb_b1_BB5", "CALRX_PWD_BIQUAD2"                            , 0x0001c550, 20, 20},
{"bb_b1_BB5", "CALRX_REMOVECAP_RCFILT"                       , 0x0001c550, 19, 19},
{"bb_b1_BB5", "CALRX_NOTCH_HALFBW"                           , 0x0001c550, 18, 18},
{"bb_b1_BB5", "CALTX_RXIN2RC_EN"                             , 0x0001c550, 17, 17},
{"bb_b1_BB5", "CALTX_RC2BQ1_EN"                              , 0x0001c550, 16, 16},
{"bb_b1_BB5", "CALTX_RC2RXOUT_EN"                            , 0x0001c550, 15, 15},
{"bb_b1_BB5", "CALTX_BQ2RXOUT_EN"                            , 0x0001c550, 14, 14},
{"bb_b1_BB5", "CALTX_NOTCHON"                                , 0x0001c550, 13, 13},
{"bb_b1_BB5", "CALTX_BYPASSBQ1_EN"                           , 0x0001c550, 12, 12},
{"bb_b1_BB5", "CALTX_BQ2V2I_EN"                              , 0x0001c550, 11, 11},
{"bb_b1_BB5", "CALTX_DAC2V2I_EN"                             , 0x0001c550, 10, 10},
{"bb_b1_BB5", "CALTX_PWD_RCFILT"                             , 0x0001c550, 9 , 9 },
{"bb_b1_BB5", "CALTX_PWD_V2I"                                , 0x0001c550, 8 , 8 },
{"bb_b1_BB5", "CALTX_PWD_BIQUAD1"                            , 0x0001c550, 7 , 7 },
{"bb_b1_BB5", "CALTX_PWD_BIQUAD2"                            , 0x0001c550, 6 , 6 },
{"bb_b1_BB5", "CALTX_REMOVECAP_RCFILT"                       , 0x0001c550, 5 , 5 },
{"bb_b1_BB5", "CALTX_NOTCH_HALFBW"                           , 0x0001c550, 4 , 4 },
{"bb_b1_BB5", "ADC_REFBIAS"                                  , 0x0001c550, 3 , 2 },
{"bb_b1_BB5", "ADC_REFINC"                                   , 0x0001c550, 1 , 1 },
{"bb_b1_BB5", "ADC_SWAP"                                     , 0x0001c550, 0 , 0 },
{"bb_b1_BB6", "CALPA_RXIN2RC_EN"                             , 0x0001c554, 31, 31},
{"bb_b1_BB6", "CALPA_RC2BQ1_EN"                              , 0x0001c554, 30, 30},
{"bb_b1_BB6", "CALPA_RC2RXOUT_EN"                            , 0x0001c554, 29, 29},
{"bb_b1_BB6", "CALPA_BQ2RXOUT_EN"                            , 0x0001c554, 28, 28},
{"bb_b1_BB6", "CALPA_NOTCHON"                                , 0x0001c554, 27, 27},
{"bb_b1_BB6", "CALPA_BYPASSBQ1_EN"                           , 0x0001c554, 26, 26},
{"bb_b1_BB6", "CALPA_BQ2V2I_EN"                              , 0x0001c554, 25, 25},
{"bb_b1_BB6", "CALPA_DAC2V2I_EN"                             , 0x0001c554, 24, 24},
{"bb_b1_BB6", "CALPA_PWD_RCFILT"                             , 0x0001c554, 23, 23},
{"bb_b1_BB6", "CALPA_PWD_V2I"                                , 0x0001c554, 22, 22},
{"bb_b1_BB6", "CALPA_PWD_BIQUAD1"                            , 0x0001c554, 21, 21},
{"bb_b1_BB6", "CALPA_PWD_BIQUAD2"                            , 0x0001c554, 20, 20},
{"bb_b1_BB6", "CALPA_REMOVECAP_RCFILT"                       , 0x0001c554, 19, 19},
{"bb_b1_BB6", "CALPA_NOTCH_HALFBW"                           , 0x0001c554, 18, 18},
{"bb_b1_BB6", "CALFC_RXIN2RC_EN"                             , 0x0001c554, 17, 17},
{"bb_b1_BB6", "CALFC_RC2BQ1_EN"                              , 0x0001c554, 16, 16},
{"bb_b1_BB6", "CALFC_RC2RXOUT_EN"                            , 0x0001c554, 15, 15},
{"bb_b1_BB6", "CALFC_BQ2RXOUT_EN"                            , 0x0001c554, 14, 14},
{"bb_b1_BB6", "CALFC_NOTCHON"                                , 0x0001c554, 13, 13},
{"bb_b1_BB6", "CALFC_BYPASSBQ1_EN"                           , 0x0001c554, 12, 12},
{"bb_b1_BB6", "CALFC_BQ2V2I_EN"                              , 0x0001c554, 11, 11},
{"bb_b1_BB6", "CALFC_DAC2V2I_EN"                             , 0x0001c554, 10, 10},
{"bb_b1_BB6", "CALFC_PWD_RCFILT"                             , 0x0001c554, 9 , 9 },
{"bb_b1_BB6", "CALFC_PWD_V2I"                                , 0x0001c554, 8 , 8 },
{"bb_b1_BB6", "CALFC_PWD_BIQUAD1"                            , 0x0001c554, 7 , 7 },
{"bb_b1_BB6", "CALFC_PWD_BIQUAD2"                            , 0x0001c554, 6 , 6 },
{"bb_b1_BB6", "CALFC_REMOVECAP_RCFILT"                       , 0x0001c554, 5 , 5 },
{"bb_b1_BB6", "CALFC_NOTCH_HALFBW"                           , 0x0001c554, 4 , 4 },
{"bb_b1_BB6", "PWD_BB_BIAS"                                  , 0x0001c554, 3 , 3 },
{"bb_b1_BB6", "DRV_STR"                                      , 0x0001c554, 2 , 0 },
{"bb_b1_BB7", "LPRX_RXIN2RC_EN"                              , 0x0001c558, 31, 31},
{"bb_b1_BB7", "LPRX_RC2BQ1_EN"                               , 0x0001c558, 30, 30},
{"bb_b1_BB7", "LPRX_RC2RXOUT_EN"                             , 0x0001c558, 29, 29},
{"bb_b1_BB7", "LPRX_BQ2RXOUT_EN"                             , 0x0001c558, 28, 28},
{"bb_b1_BB7", "LPRX_NOTCHON"                                 , 0x0001c558, 27, 27},
{"bb_b1_BB7", "LPRX_BYPASSBQ1_EN"                            , 0x0001c558, 26, 26},
{"bb_b1_BB7", "LPRX_BQ2V2I_EN"                               , 0x0001c558, 25, 25},
{"bb_b1_BB7", "LPRX_DAC2V2I_EN"                              , 0x0001c558, 24, 24},
{"bb_b1_BB7", "LPRX_PWD_RCFILT"                              , 0x0001c558, 23, 23},
{"bb_b1_BB7", "LPRX_PWD_V2I"                                 , 0x0001c558, 22, 22},
{"bb_b1_BB7", "LPRX_PWD_BIQUAD1"                             , 0x0001c558, 21, 21},
{"bb_b1_BB7", "LPRX_PWD_BIQUAD2"                             , 0x0001c558, 20, 20},
{"bb_b1_BB7", "LPRX_REMOVECAP_RCFILT"                        , 0x0001c558, 19, 19},
{"bb_b1_BB7", "LPRX_NOTCH_HALFBW"                            , 0x0001c558, 18, 18},
{"bb_b1_BB7", "LPRX_FILTERFC"                                , 0x0001c558, 17, 13},
{"bb_b1_BB7", "PWD_OSDAC_CAL"                                , 0x0001c558, 12, 10},
{"bb_b1_BB7", "NOTCH_HALFBW"                                 , 0x0001c558, 9 , 9 },
{"bb_b1_BB7", "RX_FILTERFC_OVR"                              , 0x0001c558, 8 , 8 },
{"bb_b1_BB7", "TX_FILTERFC_OVR"                              , 0x0001c558, 7 , 7 },
{"bb_b1_BB7", "LPRX_FILTERFC_OVR"                            , 0x0001c558, 6 , 6 },
{"bb_b1_BB7", "ADCSHORT"                                     , 0x0001c558, 5 , 5 },
{"bb_b1_BB7", "ADCSHORT_OVR"                                 , 0x0001c558, 4 , 4 },
{"bb_b1_BB7", "ADDACLOOPBACK"                                , 0x0001c558, 3 , 3 },
{"bb_b1_BB7", "DACFULLSCALE"                                 , 0x0001c558, 2 , 2 },
{"bb_b1_BB7", "LOWPWRLISTEN_OVR"                             , 0x0001c558, 1 , 1 },
{"bb_b1_BB7", "LOWPWRLISTEN"                                 , 0x0001c558, 0 , 0 },
{"bb_b1_BB8", "RX1DB_BIQUAD"                                 , 0x0001c55c, 31, 29},
{"bb_b1_BB8", "RX6DB_BIQUAD1"                                , 0x0001c55c, 28, 27},
{"bb_b1_BB8", "RX6DB_BIQUAD2"                                , 0x0001c55c, 26, 25},
{"bb_b1_BB8", "TX1DB_BIQUAD"                                 , 0x0001c55c, 24, 22},
{"bb_b1_BB8", "TX6DB_BIQUAD1"                                , 0x0001c55c, 21, 20},
{"bb_b1_BB8", "TX6DB_BIQUAD2"                                , 0x0001c55c, 19, 18},
{"bb_b1_BB8", "TXBB_GC"                                      , 0x0001c55c, 17, 14},
{"bb_b1_BB8", "DACRSTB"                                      , 0x0001c55c, 13, 13},
{"bb_b1_BB8", "INV_CLK320_ADDAC"                             , 0x0001c55c, 12, 12},
{"bb_b1_BB8", "local_dacpwd"                                 , 0x0001c55c, 11, 11},
{"bb_b1_BB8", "dacpwd"                                       , 0x0001c55c, 10, 10},
{"bb_b1_BB8", "dacclkpwd"                                    , 0x0001c55c, 9 , 9 },
{"bb_b1_BB8", "local_adcpwd"                                 , 0x0001c55c, 8 , 8 },
{"bb_b1_BB8", "adcpwd"                                       , 0x0001c55c, 7 , 7 },
{"bb_b1_BB8", "adcclkpwd"                                    , 0x0001c55c, 6 , 6 },
{"bb_b1_BB8", "local_clkmodaaddac"                           , 0x0001c55c, 5 , 5 },
{"bb_b1_BB8", "dac_clk_sel"                                  , 0x0001c55c, 4 , 4 },
{"bb_b1_BB8", "adc_clk_sel"                                  , 0x0001c55c, 3 , 2 },
{"bb_b1_BB8", "dactermResSw"                                 , 0x0001c55c, 1 , 0 },
{"rbist_b1_rbist_cntrl", "ate_rx_dc_interleave_power_measurement", 0x0001c780, 21, 21},
{"rbist_b1_rbist_cntrl", "ate_rx_dc_interleave"              , 0x0001c780, 20, 17},
{"rbist_b1_rbist_cntrl", "ate_rbist_enable"                  , 0x0001c780, 16, 16},
{"rbist_b1_rbist_cntrl", "ate_rxdac_calibrate"               , 0x0001c780, 15, 15},
{"rbist_b1_rbist_cntrl", "ate_cmac_power_hpf_enable"         , 0x0001c780, 14, 14},
{"rbist_b1_rbist_cntrl", "ate_cmac_i2q2_enable"              , 0x0001c780, 13, 13},
{"rbist_b1_rbist_cntrl", "ate_cmac_iq_enable"                , 0x0001c780, 12, 12},
{"rbist_b1_rbist_cntrl", "ate_cmac_power_enable"             , 0x0001c780, 11, 11},
{"rbist_b1_rbist_cntrl", "ate_cmac_corr_enable"              , 0x0001c780, 10, 10},
{"rbist_b1_rbist_cntrl", "ate_cmac_dc_enable"                , 0x0001c780, 9 , 9 },
{"rbist_b1_rbist_cntrl", "ate_cmac_dc_write_to_cancel"       , 0x0001c780, 8 , 8 },
{"rbist_b1_rbist_cntrl", "ate_tonegen_prbs_enable_q"         , 0x0001c780, 7 , 7 },
{"rbist_b1_rbist_cntrl", "ate_tonegen_prbs_enable_i"         , 0x0001c780, 6 , 6 },
{"rbist_b1_rbist_cntrl", "ate_tonegen_linramp_enable_q"      , 0x0001c780, 5 , 5 },
{"rbist_b1_rbist_cntrl", "ate_tonegen_linramp_enable_i"      , 0x0001c780, 4 , 4 },
{"rbist_b1_rbist_cntrl", "ate_tonegen_lftone0_enable"        , 0x0001c780, 3 , 3 },
{"rbist_b1_rbist_cntrl", "ate_tonegen_tone1_enable"          , 0x0001c780, 2 , 2 },
{"rbist_b1_rbist_cntrl", "ate_tonegen_tone0_enable"          , 0x0001c780, 1 , 1 },
{"rbist_b1_rbist_cntrl", "ate_tonegen_dc_enable"             , 0x0001c780, 0 , 0 },
{"rbist_b1_tx_dc_offset", "ate_tonegen_dc_q"                 , 0x0001c784, 26, 16},
{"rbist_b1_tx_dc_offset", "ate_tonegen_dc_i"                 , 0x0001c784, 10, 0 },
{"rbist_b1_tx_tonegen0", "ate_tonegen_tone_tau_k"            , 0x0001c788, 31, 24},
{"rbist_b1_tx_tonegen0", "ate_tonegen_tone_backoff_1db"      , 0x0001c788, 18, 16},
{"rbist_b1_tx_tonegen0", "ate_tonegen_tone_backoff_6db"      , 0x0001c788, 11, 8 },
{"rbist_b1_tx_tonegen0", "ate_tonegen_tone_freq"             , 0x0001c788, 7 , 0 },
{"rbist_b1_tx_tonegen1", "ate_tonegen_tone_tau_k"            , 0x0001c78c, 31, 24},
{"rbist_b1_tx_tonegen1", "ate_tonegen_tone_backoff_1db"      , 0x0001c78c, 18, 16},
{"rbist_b1_tx_tonegen1", "ate_tonegen_tone_backoff_6db"      , 0x0001c78c, 11, 8 },
{"rbist_b1_tx_tonegen1", "ate_tonegen_tone_freq"             , 0x0001c78c, 7 , 0 },
{"rbist_b1_tx_lftonegen0", "ate_tonegen_tone_tau_k"          , 0x0001c790, 31, 24},
{"rbist_b1_tx_lftonegen0", "ate_tonegen_tone_backoff_1db"    , 0x0001c790, 18, 16},
{"rbist_b1_tx_lftonegen0", "ate_tonegen_tone_backoff_6db"    , 0x0001c790, 11, 8 },
{"rbist_b1_tx_lftonegen0", "ate_tonegen_tone_freq"           , 0x0001c790, 7 , 0 },
{"rbist_b1_tx_linear_ramp_i", "ate_tonegen_linramp_step"     , 0x0001c794, 29, 24},
{"rbist_b1_tx_linear_ramp_i", "ate_tonegen_linramp_dwell"    , 0x0001c794, 21, 12},
{"rbist_b1_tx_linear_ramp_i", "ate_tonegen_linramp_init"     , 0x0001c794, 10, 0 },
{"rbist_b1_tx_linear_ramp_q", "ate_tonegen_linramp_step"     , 0x0001c798, 29, 24},
{"rbist_b1_tx_linear_ramp_q", "ate_tonegen_linramp_dwell"    , 0x0001c798, 21, 12},
{"rbist_b1_tx_linear_ramp_q", "ate_tonegen_linramp_init"     , 0x0001c798, 10, 0 },
{"rbist_b1_tx_prbs_mag", "ate_tonegen_prbs_magnitude_q"      , 0x0001c79c, 25, 16},
{"rbist_b1_tx_prbs_mag", "ate_tonegen_prbs_magnitude_i"      , 0x0001c79c, 9 , 0 },
{"rbist_b1_tx_prbs_seed_i", "ate_tonegen_prbs_seed"          , 0x0001c7a0, 30, 0 },
{"rbist_b1_tx_prbs_seed_q", "ate_tonegen_prbs_seed"          , 0x0001c7a4, 30, 0 },
{"rbist_b1_cmac_dc_cancel", "ate_cmac_dc_cancel_q"           , 0x0001c7a8, 25, 16},
{"rbist_b1_cmac_dc_cancel", "ate_cmac_dc_cancel_i"           , 0x0001c7a8, 9 , 0 },
{"rbist_b1_cmac_dc_offset", "ate_cmac_dc_cycles"             , 0x0001c7ac, 3 , 0 },
{"rbist_b1_cmac_corr", "ate_cmac_corr_freq"                  , 0x0001c7b0, 14, 8 },
{"rbist_b1_cmac_corr", "ate_cmac_corr_cycles"                , 0x0001c7b0, 4 , 0 },
{"rbist_b1_cmac_power", "ate_cmac_power_cycles"              , 0x0001c7b4, 3 , 0 },
{"rbist_b1_cmac_cross_corr", "ate_cmac_iq_cycles"            , 0x0001c7b8, 3 , 0 },
{"rbist_b1_cmac_i2q2", "ate_cmac_i2q2_cycles"                , 0x0001c7bc, 3 , 0 },
{"rbist_b1_cmac_power_hpf", "ate_cmac_power_hpf_wait"        , 0x0001c7c0, 7 , 4 },
{"rbist_b1_cmac_power_hpf", "ate_cmac_power_hpf_cycles"      , 0x0001c7c0, 3 , 0 },
{"rbist_b1_rxdac_set1", "ate_rxdac_cal_measure_time"         , 0x0001c7c4, 19, 16},
{"rbist_b1_rxdac_set1", "ate_rxdac_cal_wait"                 , 0x0001c7c4, 13, 8 },
{"rbist_b1_rxdac_set1", "ate_rxdac_hi_gain"                  , 0x0001c7c4, 4 , 4 },
{"rbist_b1_rxdac_set1", "ate_rxdac_mux"                      , 0x0001c7c4, 1 , 0 },
{"rbist_b1_rxdac_set2", "ate_rxdac_q_low"                    , 0x0001c7c8, 28, 24},
{"rbist_b1_rxdac_set2", "ate_rxdac_i_low"                    , 0x0001c7c8, 20, 16},
{"rbist_b1_rxdac_set2", "ate_rxdac_q_hi"                     , 0x0001c7c8, 12, 8 },
{"rbist_b1_rxdac_set2", "ate_rxdac_i_hi"                     , 0x0001c7c8, 4 , 0 },
{"rbist_b1_rxdac_long_shift", "ate_rxdac_q_static"           , 0x0001c7cc, 12, 8 },
{"rbist_b1_rxdac_long_shift", "ate_rxdac_i_static"           , 0x0001c7cc, 4 , 0 },
{"rbist_b1_cmac_results_i", "ate_cmac_results"               , 0x0001c7d0, 31, 0 },
{"rbist_b1_cmac_results_q", "ate_cmac_results"               , 0x0001c7d4, 31, 0 },
{"rbist_b1_cmac_results_1_i", "ate_cmac_results"             , 0x0001c7d8, 31, 0 },
{"rbist_b1_cmac_results_1_q", "ate_cmac_results"             , 0x0001c7dc, 31, 0 },
{"rbist_b1_cmac_results_2_i", "ate_cmac_results"             , 0x0001c7e0, 31, 0 },
{"rbist_b1_cmac_results_2_q", "ate_cmac_results"             , 0x0001c7e4, 31, 0 },
{"rbist_b1_cmac_results_3_i", "ate_cmac_results"             , 0x0001c7e8, 31, 0 },
{"rbist_b1_cmac_results_3_q", "ate_cmac_results"             , 0x0001c7ec, 31, 0 },
{"rbist_b1_cmac_dc_cancel_1", "ate_cmac_dc_cancel_q"         , 0x0001c7f0, 25, 16},
{"rbist_b1_cmac_dc_cancel_1", "ate_cmac_dc_cancel_i"         , 0x0001c7f0, 9 , 0 },
{"rbist_b1_cmac_dc_cancel_2", "ate_cmac_dc_cancel_q"         , 0x0001c7f4, 25, 16},
{"rbist_b1_cmac_dc_cancel_2", "ate_cmac_dc_cancel_i"         , 0x0001c7f4, 9 , 0 },
{"rbist_b1_cmac_dc_cancel_3", "ate_cmac_dc_cancel_q"         , 0x0001c7f8, 25, 16},
{"rbist_b1_cmac_dc_cancel_3", "ate_cmac_dc_cancel_i"         , 0x0001c7f8, 9 , 0 },
{"rbist_b1_cmac_gain_comp", "ate_cmac_gain_comp_enable"      , 0x0001c7fc, 31, 31},
{"rbist_b1_cmac_gain_comp", "ate_cmac_gain_comp_q"           , 0x0001c7fc, 13, 8 },
{"rbist_b1_cmac_gain_comp", "ate_cmac_gain_comp_i"           , 0x0001c7fc, 5 , 0 },
{"rxrf_b2_RXRFSA_BIAS1", "PWD_BIAS"                          , 0x0001c800, 31, 31},
{"rxrf_b2_RXRFSA_BIAS1", "PWD_IC75LNA2G"                     , 0x0001c800, 30, 28},
{"rxrf_b2_RXRFSA_BIAS1", "PWD_IC25MXR2GH"                    , 0x0001c800, 27, 25},
{"rxrf_b2_RXRFSA_BIAS1", "PWD_IR25LO24"                      , 0x0001c800, 24, 22},
{"rxrf_b2_RXRFSA_BIAS1", "PWD_IC75LNA5G"                     , 0x0001c800, 21, 19},
{"rxrf_b2_RXRFSA_BIAS1", "PWD_IC25VGA5G"                     , 0x0001c800, 18, 16},
{"rxrf_b2_RXRFSA_BIAS1", "PWD_IC25MXR5GH"                    , 0x0001c800, 15, 13},
{"rxrf_b2_RXRFSA_BIAS1", "PWD_IC25MXR2_5GH"                  , 0x0001c800, 12, 10},
{"rxrf_b2_RXRFSA_BIAS1", "PWD_IC25LO36"                      , 0x0001c800, 9 , 7 },
{"rxrf_b2_RXRFSA_BIAS1", "PWD_IR25LO18"                      , 0x0001c800, 6 , 4 },
{"rxrf_b2_RXRFSA_BIAS1", "PWD_IR25SPARE"                     , 0x0001c800, 3 , 1 },
{"rxrf_b2_RXRFSA_BIAS1", "SPARE"                             , 0x0001c800, 0 , 0 },
{"rxrf_b2_RXRFSA_BIAS2", "PWD_IR25VCM"                       , 0x0001c804, 31, 29},
{"rxrf_b2_RXRFSA_BIAS2", "PWD_IC25VCMBUF"                    , 0x0001c804, 28, 26},
{"rxrf_b2_RXRFSA_BIAS2", "PWD_IC25AGC"                       , 0x0001c804, 25, 23},
{"rxrf_b2_RXRFSA_BIAS2", "PWD_IR25AGC"                       , 0x0001c804, 22, 20},
{"rxrf_b2_RXRFSA_BIAS2", "PWD_IR25AGCH"                      , 0x0001c804, 19, 17},
{"rxrf_b2_RXRFSA_BIAS2", "PWD_IC25LNABUF"                    , 0x0001c804, 16, 14},
{"rxrf_b2_RXRFSA_BIAS2", "PWD_IR25SPARE"                     , 0x0001c804, 13, 11},
{"rxrf_b2_RXRFSA_BIAS2", "PWD_IR25SPAREH"                    , 0x0001c804, 10, 8 },
{"rxrf_b2_RXRFSA_BIAS2", "PWD_VCMBUF"                        , 0x0001c804, 7 , 7 },
{"rxrf_b2_RXRFSA_BIAS2", "VCMVALUE"                          , 0x0001c804, 6 , 4 },
{"rxrf_b2_RXRFSA_BIAS2", "PKEN"                              , 0x0001c804, 3 , 0 },
{"rxrf_b2_RXRFSA_GAINSTAGES", "RX_OVERRIDE"                  , 0x0001c808, 31, 31},
{"rxrf_b2_RXRFSA_GAINSTAGES", "LNA2G_GAIN_OVR"               , 0x0001c808, 30, 28},
{"rxrf_b2_RXRFSA_GAINSTAGES", "MXR2G_GAIN_OVR"               , 0x0001c808, 27, 26},
{"rxrf_b2_RXRFSA_GAINSTAGES", "LNA5G_GAIN_OVR"               , 0x0001c808, 25, 23},
{"rxrf_b2_RXRFSA_GAINSTAGES", "VGA5G_GAIN_OVR"               , 0x0001c808, 22, 20},
{"rxrf_b2_RXRFSA_GAINSTAGES", "MXR5G_GAIN_OVR"               , 0x0001c808, 19, 18},
{"rxrf_b2_RXRFSA_GAINSTAGES", "PWD_LNA2G"                    , 0x0001c808, 17, 17},
{"rxrf_b2_RXRFSA_GAINSTAGES", "PWD_MXR2G"                    , 0x0001c808, 16, 16},
{"rxrf_b2_RXRFSA_GAINSTAGES", "PWD_LO2G"                     , 0x0001c808, 15, 15},
{"rxrf_b2_RXRFSA_GAINSTAGES", "LNA2G_LP"                     , 0x0001c808, 14, 14},
{"rxrf_b2_RXRFSA_GAINSTAGES", "LNA2G_SHORTINP"               , 0x0001c808, 13, 13},
{"rxrf_b2_RXRFSA_GAINSTAGES", "LNA2G_CAP"                    , 0x0001c808, 12, 11},
{"rxrf_b2_RXRFSA_GAINSTAGES", "PWD_LNA5G"                    , 0x0001c808, 10, 10},
{"rxrf_b2_RXRFSA_GAINSTAGES", "PWD_MXR5G"                    , 0x0001c808, 9 , 9 },
{"rxrf_b2_RXRFSA_GAINSTAGES", "PWD_VGA5G"                    , 0x0001c808, 8 , 8 },
{"rxrf_b2_RXRFSA_GAINSTAGES", "PWD_LO5G"                     , 0x0001c808, 7 , 7 },
{"rxrf_b2_RXRFSA_GAINSTAGES", "LNA5G_SHORTINP"               , 0x0001c808, 6 , 6 },
{"rxrf_b2_RXRFSA_GAINSTAGES", "LNA5G_CAP"                    , 0x0001c808, 5 , 4 },
{"rxrf_b2_RXRFSA_GAINSTAGES", "VGA5G_CAP"                    , 0x0001c808, 3 , 2 },
{"rxrf_b2_RXRFSA_GAINSTAGES", "LNAON_CALDC"                  , 0x0001c808, 1 , 1 },
{"rxrf_b2_RXRFSA_GAINSTAGES", "SPARE"                        , 0x0001c808, 0 , 0 },
{"rxrf_b2_RXRFSA_AGC", "AGC_OVERRIDE"                        , 0x0001c80c, 31, 31},
{"rxrf_b2_RXRFSA_AGC", "AGC_ON_OVR"                          , 0x0001c80c, 30, 30},
{"rxrf_b2_RXRFSA_AGC", "AGC_CAL_OVR"                         , 0x0001c80c, 29, 29},
{"rxrf_b2_RXRFSA_AGC", "AGC2G_DBDAC_OVR"                     , 0x0001c80c, 28, 25},
{"rxrf_b2_RXRFSA_AGC", "AGC2G_CALDAC_OVR"                    , 0x0001c80c, 24, 19},
{"rxrf_b2_RXRFSA_AGC", "AGC5G_DBDAC_OVR"                     , 0x0001c80c, 18, 15},
{"rxrf_b2_RXRFSA_AGC", "AGC5G_CALDAC_OVR"                    , 0x0001c80c, 14, 9 },
{"rxrf_b2_RXRFSA_AGC", "AGC_FALL_CTRL"                       , 0x0001c80c, 8 , 6 },
{"rxrf_b2_RXRFSA_AGC", "PWD_LNABUF"                          , 0x0001c80c, 5 , 5 },
{"rxrf_b2_RXRFSA_AGC", "LNABUF_PWD_OVR"                      , 0x0001c80c, 4 , 4 },
{"rxrf_b2_RXRFSA_AGC", "LNABUFGAIN2X"                        , 0x0001c80c, 3 , 3 },
{"rxrf_b2_RXRFSA_AGC", "AGC_OUT"                             , 0x0001c80c, 2 , 2 },
{"rxrf_b2_RXRFSA_AGC", "RF2G_ON_DURING_CALPA"                , 0x0001c80c, 1 , 1 },
{"rxrf_b2_RXRFSA_AGC", "RF5G_ON_DURING_CALPA"                , 0x0001c80c, 0 , 0 },
{"rxrf_b2_RXRFSA_BIAS3", "PWD_IC50AIC"                       , 0x0001c810, 31, 29},
{"rxrf_b2_RXRFSA_BIAS3", "PWD_IC50LNABUF2G"                  , 0x0001c810, 28, 26},
{"rxrf_b2_RXRFSA_BIAS3", "PWD_IC25SPARE"                     , 0x0001c810, 25, 23},
{"rxrf_b2_RXRFSA_BIAS3", "MXRFORCEDON"                       , 0x0001c810, 22, 22},
{"rxrf_b2_RXRFSA_BIAS3", "BT_LNA_CNT_OVR"                    , 0x0001c810, 21, 21},
{"rxrf_b2_RXRFSA_BIAS3", "USE_BT_LNA"                        , 0x0001c810, 20, 20},
{"rxrf_b2_RXRFSA_BIAS3", "PWD_AICGM"                         , 0x0001c810, 19, 19},
{"rxrf_b2_RXRFSA_BIAS3", "PWD_AICGM_OVR"                     , 0x0001c810, 18, 18},
{"rxrf_b2_RXRFSA_BIAS3", "AICSTBY_ENABLE"                    , 0x0001c810, 17, 17},
{"rxrf_b2_RXRFSA_BIAS3", "AICSTBY_VGAON_ENABLE"              , 0x0001c810, 16, 16},
{"rxrf_b2_RXRFSA_BIAS3", "KEEPLNABUF2GCASCON"                , 0x0001c810, 15, 15},
{"rxrf_b2_RXRFSA_BIAS3", "shortbiasres_div2grx"              , 0x0001c810, 14, 14},
{"rxrf_b2_RXRFSA_BIAS3", "shortbiasres_div5grx"              , 0x0001c810, 13, 13},
{"rxrf_b2_RXRFSA_BIAS3", "CONTROLSPARE"                      , 0x0001c810, 12, 0 },
{"txrf_b2_TXRFSA1", "localtxgain2G"                          , 0x0001c840, 31, 31},
{"txrf_b2_TXRFSA1", "padrvgn2G"                              , 0x0001c840, 30, 24},
{"txrf_b2_TXRFSA1", "LOdiv2Gforced"                          , 0x0001c840, 23, 23},
{"txrf_b2_TXRFSA1", "LObuf2Gforced"                          , 0x0001c840, 22, 22},
{"txrf_b2_TXRFSA1", "pdlodiv2G"                              , 0x0001c840, 21, 21},
{"txrf_b2_TXRFSA1", "pdlobuf2G"                              , 0x0001c840, 20, 20},
{"txrf_b2_TXRFSA1", "pdmxr2G"                                , 0x0001c840, 19, 19},
{"txrf_b2_TXRFSA1", "pdDR2G"                                 , 0x0001c840, 18, 18},
{"txrf_b2_TXRFSA1", "pdout2G"                                , 0x0001c840, 17, 17},
{"txrf_b2_TXRFSA1", "localtxgain5G"                          , 0x0001c840, 16, 16},
{"txrf_b2_TXRFSA1", "padrv3gn5G"                             , 0x0001c840, 15, 12},
{"txrf_b2_TXRFSA1", "padrv2gn5G_main"                        , 0x0001c840, 11, 9 },
{"txrf_b2_TXRFSA1", "padrv2gn5G_aux1"                        , 0x0001c840, 8 , 6 },
{"txrf_b2_TXRFSA1", "padrv2gn5G_aux2"                        , 0x0001c840, 5 , 3 },
{"txrf_b2_TXRFSA1", "reserved_PA2G"                          , 0x0001c840, 2 , 0 },
{"txrf_b2_TXRFSA2", "pdmxr5G"                                , 0x0001c844, 31, 31},
{"txrf_b2_TXRFSA2", "LOdiv5Gforced"                          , 0x0001c844, 30, 30},
{"txrf_b2_TXRFSA2", "LObuf5Gforced"                          , 0x0001c844, 29, 29},
{"txrf_b2_TXRFSA2", "pdlodiv5G"                              , 0x0001c844, 28, 28},
{"txrf_b2_TXRFSA2", "pdlobuf5G"                              , 0x0001c844, 27, 27},
{"txrf_b2_TXRFSA2", "pdout5G"                                , 0x0001c844, 26, 24},
{"txrf_b2_TXRFSA2", "db2G"                                   , 0x0001c844, 23, 21},
{"txrf_b2_TXRFSA2", "ob2G_cck"                               , 0x0001c844, 20, 18},
{"txrf_b2_TXRFSA2", "ob2G_psk"                               , 0x0001c844, 17, 15},
{"txrf_b2_TXRFSA2", "ob2G_qam"                               , 0x0001c844, 14, 12},
{"txrf_b2_TXRFSA2", "ob2G_softpd"                            , 0x0001c844, 11, 9 },
{"txrf_b2_TXRFSA2", "dcas2G"                                 , 0x0001c844, 8 , 6 },
{"txrf_b2_TXRFSA2", "ocas2G_wlan"                            , 0x0001c844, 5 , 3 },
{"txrf_b2_TXRFSA2", "reserved_PA2G"                          , 0x0001c844, 2 , 0 },
{"txrf_b2_TXRFSA3", "obdboffst2G_aux1"                       , 0x0001c848, 31, 29},
{"txrf_b2_TXRFSA3", "obdboffst2G_aux2"                       , 0x0001c848, 28, 26},
{"txrf_b2_TXRFSA3", "d3b5G"                                  , 0x0001c848, 25, 23},
{"txrf_b2_TXRFSA3", "d2b5G"                                  , 0x0001c848, 22, 20},
{"txrf_b2_TXRFSA3", "ob5G_cck"                               , 0x0001c848, 19, 17},
{"txrf_b2_TXRFSA3", "ob5G_psk"                               , 0x0001c848, 16, 14},
{"txrf_b2_TXRFSA3", "ob5G_qam"                               , 0x0001c848, 13, 11},
{"txrf_b2_TXRFSA3", "obdboffst5G_aux1"                       , 0x0001c848, 10, 8 },
{"txrf_b2_TXRFSA3", "obdboffst5G_aux2"                       , 0x0001c848, 7 , 5 },
{"txrf_b2_TXRFSA3", "d3cas5G"                                , 0x0001c848, 4 , 2 },
{"txrf_b2_TXRFSA3", "reserved_3"                             , 0x0001c848, 1 , 0 },
{"txrf_b2_TXRFSA4", "d1cas5G_main"                           , 0x0001c84c, 31, 29},
{"txrf_b2_TXRFSA4", "d1cas5G_aux1"                           , 0x0001c84c, 28, 26},
{"txrf_b2_TXRFSA4", "d1cas5G_aux2"                           , 0x0001c84c, 25, 23},
{"txrf_b2_TXRFSA4", "d2cas5G_main"                           , 0x0001c84c, 22, 20},
{"txrf_b2_TXRFSA4", "d2cas5G_aux1"                           , 0x0001c84c, 19, 17},
{"txrf_b2_TXRFSA4", "d2cas5G_aux2"                           , 0x0001c84c, 16, 14},
{"txrf_b2_TXRFSA4", "btob_wlan"                              , 0x0001c84c, 13, 11},
{"txrf_b2_TXRFSA4", "btob_softpd_wlan"                       , 0x0001c84c, 10, 8 },
{"txrf_b2_TXRFSA4", "PAforcedon_WLAN"                        , 0x0001c84c, 7 , 7 },
{"txrf_b2_TXRFSA4", "usebtob_wlansr"                         , 0x0001c84c, 6 , 6 },
{"txrf_b2_TXRFSA4", "pwd_ic25aic"                            , 0x0001c84c, 5 , 3 },
{"txrf_b2_TXRFSA4", "pwd_ic25spare"                          , 0x0001c84c, 2 , 0 },
{"txrf_b2_TXRFSA5", "AICstby_enable"                         , 0x0001c850, 31, 31},
{"txrf_b2_TXRFSA5", "local_AICpwd"                           , 0x0001c850, 30, 30},
{"txrf_b2_TXRFSA5", "pwdAICvgaI_ls"                          , 0x0001c850, 29, 29},
{"txrf_b2_TXRFSA5", "pwdAICvgaQ_ls"                          , 0x0001c850, 28, 28},
{"txrf_b2_TXRFSA5", "csteer_en"                              , 0x0001c850, 27, 27},
{"txrf_b2_TXRFSA5", "reserved7_1"                            , 0x0001c850, 26, 0 },
{"txrf_b2_TXRFSA6", "pdpredist2G"                            , 0x0001c854, 31, 31},
{"txrf_b2_TXRFSA6", "capdiv2G_predist"                       , 0x0001c854, 30, 27},
{"txrf_b2_TXRFSA6", "rdiv2G"                                 , 0x0001c854, 26, 25},
{"txrf_b2_TXRFSA6", "pdpredist5G"                            , 0x0001c854, 24, 24},
{"txrf_b2_TXRFSA6", "capdiv5G"                               , 0x0001c854, 23, 21},
{"txrf_b2_TXRFSA6", "rdiv5G"                                 , 0x0001c854, 20, 19},
{"txrf_b2_TXRFSA6", "caltxshiftovr"                          , 0x0001c854, 18, 18},
{"txrf_b2_TXRFSA6", "caltxshift"                             , 0x0001c854, 17, 17},
{"txrf_b2_TXRFSA6", "db2Gcaltx"                              , 0x0001c854, 16, 14},
{"txrf_b2_TXRFSA6", "padrvgn2Gcaltx"                         , 0x0001c854, 13, 7 },
{"txrf_b2_TXRFSA6", "d3b5Gcaltx"                             , 0x0001c854, 6 , 4 },
{"txrf_b2_TXRFSA6", "pdout5G_3caltx"                         , 0x0001c854, 3 , 3 },
{"txrf_b2_TXRFSA6", "reserved_5"                             , 0x0001c854, 2 , 0 },
{"txrf_b2_TXRFSA7", "pwd_ic25mixbuf5G"                       , 0x0001c858, 31, 29},
{"txrf_b2_TXRFSA7", "pwd_ir25pa5G1"                          , 0x0001c858, 28, 26},
{"txrf_b2_TXRFSA7", "pwd_ir25pa5G2"                          , 0x0001c858, 25, 23},
{"txrf_b2_TXRFSA7", "pwd_ic25tempsen"                        , 0x0001c858, 22, 20},
{"txrf_b2_TXRFSA7", "pwdWLAN_ic25paBT"                       , 0x0001c858, 19, 17},
{"txrf_b2_TXRFSA7", "pwd_ir25mixdiv2G"                       , 0x0001c858, 16, 14},
{"txrf_b2_TXRFSA7", "pwd_ir25mixbias2G"                      , 0x0001c858, 13, 11},
{"txrf_b2_TXRFSA7", "pwdWLAN_ir25pa2G"                       , 0x0001c858, 10, 8 },
{"txrf_b2_TXRFSA7", "pwd_ir25mixdiv5G"                       , 0x0001c858, 7 , 5 },
{"txrf_b2_TXRFSA7", "AICcapdivmasking_b"                     , 0x0001c858, 4 , 4 },
{"txrf_b2_TXRFSA7", "shortbiasres_div5gtx"                   , 0x0001c858, 3 , 3 },
{"txrf_b2_TXRFSA7", "offst_aux2_m2_21"                       , 0x0001c858, 2 , 1 },
{"txrf_b2_TXRFSA7", "shortbiasres_div2gtx"                   , 0x0001c858, 0 , 0 },
{"txrf_b2_TXRFSA8", "pwd_ir25mixbias5G"                      , 0x0001c85c, 31, 29},
{"txrf_b2_TXRFSA8", "bias_cgm_igsel_pa2G"                    , 0x0001c85c, 28, 25},
{"txrf_b2_TXRFSA8", "bias_cgm_icsel_pa2G"                    , 0x0001c85c, 24, 21},
{"txrf_b2_TXRFSA8", "bias_cgm_igsel_pa5G"                    , 0x0001c85c, 20, 17},
{"txrf_b2_TXRFSA8", "bias_cgm_icsel_pa5G"                    , 0x0001c85c, 16, 13},
{"txrf_b2_TXRFSA8", "pwd_ir25tempsen"                        , 0x0001c85c, 12, 10},
{"txrf_b2_TXRFSA8", "pwd_irspare"                            , 0x0001c85c, 9 , 7 },
{"txrf_b2_TXRFSA8", "shshobdb2G"                             , 0x0001c85c, 6 , 6 },
{"txrf_b2_TXRFSA8", "shshobdb5G"                             , 0x0001c85c, 5 , 5 },
{"txrf_b2_TXRFSA8", "reserved6_2"                            , 0x0001c85c, 4 , 0 },
{"txrf_b2_TXRFSA9", "pa5g_ind_swTbl"                         , 0x0001c860, 31, 29},
{"txrf_b2_TXRFSA9", "offst_aux2_m2_0"                        , 0x0001c860, 28, 28},
{"txrf_b2_TXRFSA9", "offst_aux2_m1"                          , 0x0001c860, 27, 25},
{"txrf_b2_TXRFSA9", "pa5g_cap_swTbl_01"                      , 0x0001c860, 24, 22},
{"txrf_b2_TXRFSA9", "pa5g_cap_swTbl_10"                      , 0x0001c860, 21, 19},
{"txrf_b2_TXRFSA9", "pa5g_cap_swTbl_11"                      , 0x0001c860, 18, 16},
{"txrf_b2_TXRFSA9", "ATBsel2G"                               , 0x0001c860, 15, 12},
{"txrf_b2_TXRFSA9", "ATBsel5G"                               , 0x0001c860, 11, 8 },
{"txrf_b2_TXRFSA9", "reserved7"                              , 0x0001c860, 7 , 0 },
{"rxtx_b2_RXTX1", "mantxgain"                                , 0x0001c900, 31, 31},
{"rxtx_b2_RXTX1", "padrv3gn5g"                               , 0x0001c900, 30, 27},
{"rxtx_b2_RXTX1", "padrv2gn5g"                               , 0x0001c900, 26, 24},
{"rxtx_b2_RXTX1", "padrv2gn2g"                               , 0x0001c900, 23, 20},
{"rxtx_b2_RXTX1", "padrvhalfgn2g"                            , 0x0001c900, 19, 19},
{"rxtx_b2_RXTX1", "ovr_agc_dbdac"                            , 0x0001c900, 18, 18},
{"rxtx_b2_RXTX1", "agc_dbdac"                                , 0x0001c900, 17, 14},
{"rxtx_b2_RXTX1", "manrxgain"                                , 0x0001c900, 13, 13},
{"rxtx_b2_RXTX1", "lnagain"                                  , 0x0001c900, 12, 10},
{"rxtx_b2_RXTX1", "vgagain"                                  , 0x0001c900, 9 , 7 },
{"rxtx_b2_RXTX1", "mxrgain"                                  , 0x0001c900, 6 , 5 },
{"rxtx_b2_RXTX1", "reserved"                                 , 0x0001c900, 4 , 0 },
{"rxtx_b2_RXTX2", "agcon_ovr"                                , 0x0001c904, 31, 31},
{"rxtx_b2_RXTX2", "agcon"                                    , 0x0001c904, 30, 30},
{"rxtx_b2_RXTX2", "txmod_ovr"                                , 0x0001c904, 29, 29},
{"rxtx_b2_RXTX2", "txmod"                                    , 0x0001c904, 28, 26},
{"rxtx_b2_RXTX2", "rxon_ovr"                                 , 0x0001c904, 25, 25},
{"rxtx_b2_RXTX2", "rxon"                                     , 0x0001c904, 24, 24},
{"rxtx_b2_RXTX2", "paon_ovr"                                 , 0x0001c904, 23, 23},
{"rxtx_b2_RXTX2", "paon"                                     , 0x0001c904, 22, 22},
{"rxtx_b2_RXTX2", "txon_ovr"                                 , 0x0001c904, 21, 21},
{"rxtx_b2_RXTX2", "txon"                                     , 0x0001c904, 20, 20},
{"rxtx_b2_RXTX2", "BW_ST_ovr"                                , 0x0001c904, 19, 19},
{"rxtx_b2_RXTX2", "BW_ST"                                    , 0x0001c904, 18, 16},
{"rxtx_b2_RXTX2", "synthon_ovr"                              , 0x0001c904, 15, 15},
{"rxtx_b2_RXTX2", "synthon"                                  , 0x0001c904, 14, 14},
{"rxtx_b2_RXTX2", "bmode_ovr"                                , 0x0001c904, 13, 13},
{"rxtx_b2_RXTX2", "bmode"                                    , 0x0001c904, 12, 12},
{"rxtx_b2_RXTX2", "calpa_ovr"                                , 0x0001c904, 11, 11},
{"rxtx_b2_RXTX2", "calpa"                                    , 0x0001c904, 10, 10},
{"rxtx_b2_RXTX2", "caltxshift_ovr"                           , 0x0001c904, 9 , 9 },
{"rxtx_b2_RXTX2", "caltxshift"                               , 0x0001c904, 8 , 8 },
{"rxtx_b2_RXTX2", "caltx_ovr"                                , 0x0001c904, 7 , 7 },
{"rxtx_b2_RXTX2", "caltx"                                    , 0x0001c904, 6 , 6 },
{"rxtx_b2_RXTX2", "calfc_ovr"                                , 0x0001c904, 5 , 5 },
{"rxtx_b2_RXTX2", "calfc"                                    , 0x0001c904, 4 , 4 },
{"rxtx_b2_RXTX2", "calresidue_ovr"                           , 0x0001c904, 3 , 3 },
{"rxtx_b2_RXTX2", "calresidue"                               , 0x0001c904, 2 , 2 },
{"rxtx_b2_RXTX2", "LOforcedon"                               , 0x0001c904, 1 , 1 },
{"rxtx_b2_RXTX2", "reserved"                                 , 0x0001c904, 0 , 0 },
{"rxtx_b2_RXTX3", "agc_cal_ovr"                              , 0x0001c908, 31, 31},
{"rxtx_b2_RXTX3", "agc_cal"                                  , 0x0001c908, 30, 30},
{"rxtx_b2_RXTX3", "agc_caldac"                               , 0x0001c908, 29, 24},
{"rxtx_b2_RXTX3", "adc_samp_rate_ovr"                        , 0x0001c908, 23, 23},
{"rxtx_b2_RXTX3", "adc_samp_rate"                            , 0x0001c908, 22, 21},
{"rxtx_b2_RXTX3", "calrx_ovr"                                , 0x0001c908, 20, 20},
{"rxtx_b2_RXTX3", "calrx"                                    , 0x0001c908, 19, 19},
{"rxtx_b2_RXTX3", "caladcoffset_ovr"                         , 0x0001c908, 18, 18},
{"rxtx_b2_RXTX3", "caladcoffset"                             , 0x0001c908, 17, 17},
{"rxtx_b2_RXTX3", "calxpa_ovr"                               , 0x0001c908, 16, 16},
{"rxtx_b2_RXTX3", "calxpa"                                   , 0x0001c908, 15, 15},
{"rxtx_b2_RXTX3", "xlnaon_ovr"                               , 0x0001c908, 14, 14},
{"rxtx_b2_RXTX3", "xlnaon"                                   , 0x0001c908, 13, 13},
{"rxtx_b2_RXTX3", "xlnabias_pwd"                             , 0x0001c908, 12, 12},
{"rxtx_b2_RXTX3", "reserved"                                 , 0x0001c908, 11, 0 },
{"rxtx_b2_RXTX4", "xlna_strength"                            , 0x0001c90c, 31, 30},
{"rxtx_b2_RXTX4", "thermOn_ovr"                              , 0x0001c90c, 29, 29},
{"rxtx_b2_RXTX4", "thermOn"                                  , 0x0001c90c, 28, 28},
{"rxtx_b2_RXTX4", "txswen"                                   , 0x0001c90c, 25, 25},
{"rxtx_b2_RXTX4", "txswen_ovr"                               , 0x0001c90c, 24, 24},
{"rxtx_b2_RXTX4", "AICcapdiv2GI"                             , 0x0001c90c, 23, 20},
{"rxtx_b2_RXTX4", "AICcapdiv2GQ"                             , 0x0001c90c, 19, 16},
{"rxtx_b2_RXTX4", "AICvga_gnI"                               , 0x0001c90c, 15, 11},
{"rxtx_b2_RXTX4", "AICvga_gnQ"                               , 0x0001c90c, 10, 6 },
{"rxtx_b2_RXTX4", "AICinvI"                                  , 0x0001c90c, 5 , 5 },
{"rxtx_b2_RXTX4", "AICinvQ"                                  , 0x0001c90c, 4 , 4 },
{"rxtx_b2_RXTX4", "AICgmgn6dB"                               , 0x0001c90c, 3 , 0 },
{"rxtx_b2_RXTX5", "AICgmHP"                                  , 0x0001c910, 31, 31},
{"rxtx_b2_RXTX5", "AIClocal_mode"                            , 0x0001c910, 30, 30},
{"rxtx_b2_RXTX5", "AICon"                                    , 0x0001c910, 29, 29},
{"rxtx_b2_RXTX5", "AICstby"                                  , 0x0001c910, 28, 28},
{"rxtx_b2_RXTX5", "AIC_chanOvr"                              , 0x0001c910, 27, 26},
{"rxtx_b2_RXTX5", "AIC_loadChannel"                          , 0x0001c910, 25, 25},
{"rxtx_b2_RXTX5", "testIQ_rsel"                              , 0x0001c910, 24, 24},
{"rxtx_b2_RXTX5", "testIQ_bufen"                             , 0x0001c910, 23, 23},
{"rxtx_b2_RXTX5", "testI_on"                                 , 0x0001c910, 22, 22},
{"rxtx_b2_RXTX5", "testQ_on"                                 , 0x0001c910, 21, 21},
{"rxtx_b2_RXTX5", "bbreplace_en"                             , 0x0001c910, 20, 20},
{"rxtx_b2_RXTX5", "RESERVED5"                                , 0x0001c910, 19, 0 },
{"bb_b2_BB1", "RANGE_OSDAC"                                  , 0x0001c940, 31, 30},
{"bb_b2_BB1", "LOCALOFFSET"                                  , 0x0001c940, 29, 29},
{"bb_b2_BB1", "OFSTCORRI2VI"                                 , 0x0001c940, 28, 24},
{"bb_b2_BB1", "OFSTCORRI2VQ"                                 , 0x0001c940, 23, 19},
{"bb_b2_BB1", "ATBSEL"                                       , 0x0001c940, 18, 16},
{"bb_b2_BB1", "CMSEL1"                                       , 0x0001c940, 15, 13},
{"bb_b2_BB1", "CMSEL2"                                       , 0x0001c940, 12, 10},
{"bb_b2_BB1", "PWD_RCFILT_OVR"                               , 0x0001c940, 9 , 9 },
{"bb_b2_BB1", "PWD_RCFILT"                                   , 0x0001c940, 8 , 8 },
{"bb_b2_BB1", "PWD_V2I_OVR"                                  , 0x0001c940, 7 , 7 },
{"bb_b2_BB1", "PWD_V2I"                                      , 0x0001c940, 6 , 6 },
{"bb_b2_BB1", "PWD_OSDAC_OVR"                                , 0x0001c940, 5 , 5 },
{"bb_b2_BB1", "PWD_OSDAC"                                    , 0x0001c940, 4 , 4 },
{"bb_b2_BB1", "PWD_BIQUAD1_OVR"                              , 0x0001c940, 3 , 3 },
{"bb_b2_BB1", "PWD_BIQUAD1"                                  , 0x0001c940, 2 , 2 },
{"bb_b2_BB1", "PWD_BIQUAD2_OVR"                              , 0x0001c940, 1 , 1 },
{"bb_b2_BB1", "PWD_BIQUAD2"                                  , 0x0001c940, 0 , 0 },
{"bb_b2_BB2", "SWITCH_OVERRIDE"                              , 0x0001c944, 31, 31},
{"bb_b2_BB2", "RXIN2RC_EN"                                   , 0x0001c944, 30, 30},
{"bb_b2_BB2", "RC2BQ1_EN"                                    , 0x0001c944, 29, 29},
{"bb_b2_BB2", "RC2RXOUT_EN"                                  , 0x0001c944, 28, 28},
{"bb_b2_BB2", "BQ2RXOUT_EN"                                  , 0x0001c944, 27, 27},
{"bb_b2_BB2", "NOTCHON"                                      , 0x0001c944, 26, 26},
{"bb_b2_BB2", "BYPASSBQ1_EN"                                 , 0x0001c944, 25, 25},
{"bb_b2_BB2", "BQ2V2I_EN"                                    , 0x0001c944, 24, 24},
{"bb_b2_BB2", "DAC2V2I_EN"                                   , 0x0001c944, 23, 23},
{"bb_b2_BB2", "FILTERFC_OVR"                                 , 0x0001c944, 22, 22},
{"bb_b2_BB2", "FILTERFC"                                     , 0x0001c944, 21, 17},
{"bb_b2_BB2", "FNOTCH_OVR"                                   , 0x0001c944, 16, 16},
{"bb_b2_BB2", "FNOTCH"                                       , 0x0001c944, 15, 12},
{"bb_b2_BB2", "REMOVECAP_RCFILT_OVR"                         , 0x0001c944, 11, 11},
{"bb_b2_BB2", "REMOVECAP_RCFILT"                             , 0x0001c944, 10, 10},
{"bb_b2_BB2", "dac_clk_inv"                                  , 0x0001c944, 9 , 9 },
{"bb_b2_BB2", "btcpupll_clkbufdrvstr"                        , 0x0001c944, 8 , 7 },
{"bb_b2_BB2", "flip_adc_str_clk"                             , 0x0001c944, 6 , 6 },
{"bb_b2_BB2", "SEL_TEST"                                     , 0x0001c944, 5 , 0 },
{"bb_b2_BB3", "pll704en"                                     , 0x0001c948, 31, 31},
{"bb_b2_BB3", "OFSTCORRI2VI"                                 , 0x0001c948, 30, 26},
{"bb_b2_BB3", "OFSTCORRI2VQ"                                 , 0x0001c948, 25, 21},
{"bb_b2_BB3", "FILTERFC"                                     , 0x0001c948, 20, 16},
{"bb_b2_BB3", "RX_FILTERFC"                                  , 0x0001c948, 15, 11},
{"bb_b2_BB3", "TX_FILTERFC"                                  , 0x0001c948, 10, 6 },
{"bb_b2_BB3", "SEL_OFST_READBK"                              , 0x0001c948, 5 , 4 },
{"bb_b2_BB3", "ADC_COMPBIAS"                                 , 0x0001c948, 3 , 2 },
{"bb_b2_BB3", "DOUBLE_RCFILT_CURR"                           , 0x0001c948, 1 , 1 },
{"bb_b2_BB3", "PWD_BB_BIAS_OVR"                              , 0x0001c948, 0 , 0 },
{"bb_b2_BB4", "RX_RXIN2RC_EN"                                , 0x0001c94c, 31, 31},
{"bb_b2_BB4", "RX_RC2BQ1_EN"                                 , 0x0001c94c, 30, 30},
{"bb_b2_BB4", "RX_RC2RXOUT_EN"                               , 0x0001c94c, 29, 29},
{"bb_b2_BB4", "RX_BQ2RXOUT_EN"                               , 0x0001c94c, 28, 28},
{"bb_b2_BB4", "RX_NOTCHON"                                   , 0x0001c94c, 27, 27},
{"bb_b2_BB4", "RX_BYPASSBQ1_EN"                              , 0x0001c94c, 26, 26},
{"bb_b2_BB4", "RX_BQ2V2I_EN"                                 , 0x0001c94c, 25, 25},
{"bb_b2_BB4", "RX_DAC2V2I_EN"                                , 0x0001c94c, 24, 24},
{"bb_b2_BB4", "RX_PWD_RCFILT"                                , 0x0001c94c, 23, 23},
{"bb_b2_BB4", "RX_PWD_V2I"                                   , 0x0001c94c, 22, 22},
{"bb_b2_BB4", "RX_PWD_BIQUAD1"                               , 0x0001c94c, 21, 21},
{"bb_b2_BB4", "RX_PWD_BIQUAD2"                               , 0x0001c94c, 20, 20},
{"bb_b2_BB4", "RX_REMOVECAP_RCFILT"                          , 0x0001c94c, 19, 19},
{"bb_b2_BB4", "RX_NOTCH_HALFBW"                              , 0x0001c94c, 18, 18},
{"bb_b2_BB4", "TX_RXIN2RC_EN"                                , 0x0001c94c, 17, 17},
{"bb_b2_BB4", "TX_RC2BQ1_EN"                                 , 0x0001c94c, 16, 16},
{"bb_b2_BB4", "TX_RC2RXOUT_EN"                               , 0x0001c94c, 15, 15},
{"bb_b2_BB4", "TX_BQ2RXOUT_EN"                               , 0x0001c94c, 14, 14},
{"bb_b2_BB4", "TX_NOTCHON"                                   , 0x0001c94c, 13, 13},
{"bb_b2_BB4", "TX_BYPASSBQ1_EN"                              , 0x0001c94c, 12, 12},
{"bb_b2_BB4", "TX_BQ2V2I_EN"                                 , 0x0001c94c, 11, 11},
{"bb_b2_BB4", "TX_DAC2V2I_EN"                                , 0x0001c94c, 10, 10},
{"bb_b2_BB4", "TX_PWD_RCFILT"                                , 0x0001c94c, 9 , 9 },
{"bb_b2_BB4", "TX_PWD_V2I"                                   , 0x0001c94c, 8 , 8 },
{"bb_b2_BB4", "TX_PWD_BIQUAD1"                               , 0x0001c94c, 7 , 7 },
{"bb_b2_BB4", "TX_PWD_BIQUAD2"                               , 0x0001c94c, 6 , 6 },
{"bb_b2_BB4", "TX_REMOVECAP_RCFILT"                          , 0x0001c94c, 5 , 5 },
{"bb_b2_BB4", "TX_NOTCH_HALFBW"                              , 0x0001c94c, 4 , 4 },
{"bb_b2_BB4", "ADC_DEC_DELAYBIAS"                            , 0x0001c94c, 3 , 2 },
{"bb_b2_BB4", "ADC_INC_DELAYBIAS"                            , 0x0001c94c, 1 , 1 },
{"bb_b2_BB4", "ADC_COMP_RESET"                               , 0x0001c94c, 0 , 0 },
{"bb_b2_BB5", "CALRX_RXIN2RC_EN"                             , 0x0001c950, 31, 31},
{"bb_b2_BB5", "CALRX_RC2BQ1_EN"                              , 0x0001c950, 30, 30},
{"bb_b2_BB5", "CALRX_RC2RXOUT_EN"                            , 0x0001c950, 29, 29},
{"bb_b2_BB5", "CALRX_BQ2RXOUT_EN"                            , 0x0001c950, 28, 28},
{"bb_b2_BB5", "CALRX_NOTCHON"                                , 0x0001c950, 27, 27},
{"bb_b2_BB5", "CALRX_BYPASSBQ1_EN"                           , 0x0001c950, 26, 26},
{"bb_b2_BB5", "CALRX_BQ2V2I_EN"                              , 0x0001c950, 25, 25},
{"bb_b2_BB5", "CALRX_DAC2V2I_EN"                             , 0x0001c950, 24, 24},
{"bb_b2_BB5", "CALRX_PWD_RCFILT"                             , 0x0001c950, 23, 23},
{"bb_b2_BB5", "CALRX_PWD_V2I"                                , 0x0001c950, 22, 22},
{"bb_b2_BB5", "CALRX_PWD_BIQUAD1"                            , 0x0001c950, 21, 21},
{"bb_b2_BB5", "CALRX_PWD_BIQUAD2"                            , 0x0001c950, 20, 20},
{"bb_b2_BB5", "CALRX_REMOVECAP_RCFILT"                       , 0x0001c950, 19, 19},
{"bb_b2_BB5", "CALRX_NOTCH_HALFBW"                           , 0x0001c950, 18, 18},
{"bb_b2_BB5", "CALTX_RXIN2RC_EN"                             , 0x0001c950, 17, 17},
{"bb_b2_BB5", "CALTX_RC2BQ1_EN"                              , 0x0001c950, 16, 16},
{"bb_b2_BB5", "CALTX_RC2RXOUT_EN"                            , 0x0001c950, 15, 15},
{"bb_b2_BB5", "CALTX_BQ2RXOUT_EN"                            , 0x0001c950, 14, 14},
{"bb_b2_BB5", "CALTX_NOTCHON"                                , 0x0001c950, 13, 13},
{"bb_b2_BB5", "CALTX_BYPASSBQ1_EN"                           , 0x0001c950, 12, 12},
{"bb_b2_BB5", "CALTX_BQ2V2I_EN"                              , 0x0001c950, 11, 11},
{"bb_b2_BB5", "CALTX_DAC2V2I_EN"                             , 0x0001c950, 10, 10},
{"bb_b2_BB5", "CALTX_PWD_RCFILT"                             , 0x0001c950, 9 , 9 },
{"bb_b2_BB5", "CALTX_PWD_V2I"                                , 0x0001c950, 8 , 8 },
{"bb_b2_BB5", "CALTX_PWD_BIQUAD1"                            , 0x0001c950, 7 , 7 },
{"bb_b2_BB5", "CALTX_PWD_BIQUAD2"                            , 0x0001c950, 6 , 6 },
{"bb_b2_BB5", "CALTX_REMOVECAP_RCFILT"                       , 0x0001c950, 5 , 5 },
{"bb_b2_BB5", "CALTX_NOTCH_HALFBW"                           , 0x0001c950, 4 , 4 },
{"bb_b2_BB5", "ADC_REFBIAS"                                  , 0x0001c950, 3 , 2 },
{"bb_b2_BB5", "ADC_REFINC"                                   , 0x0001c950, 1 , 1 },
{"bb_b2_BB5", "ADC_SWAP"                                     , 0x0001c950, 0 , 0 },
{"bb_b2_BB6", "CALPA_RXIN2RC_EN"                             , 0x0001c954, 31, 31},
{"bb_b2_BB6", "CALPA_RC2BQ1_EN"                              , 0x0001c954, 30, 30},
{"bb_b2_BB6", "CALPA_RC2RXOUT_EN"                            , 0x0001c954, 29, 29},
{"bb_b2_BB6", "CALPA_BQ2RXOUT_EN"                            , 0x0001c954, 28, 28},
{"bb_b2_BB6", "CALPA_NOTCHON"                                , 0x0001c954, 27, 27},
{"bb_b2_BB6", "CALPA_BYPASSBQ1_EN"                           , 0x0001c954, 26, 26},
{"bb_b2_BB6", "CALPA_BQ2V2I_EN"                              , 0x0001c954, 25, 25},
{"bb_b2_BB6", "CALPA_DAC2V2I_EN"                             , 0x0001c954, 24, 24},
{"bb_b2_BB6", "CALPA_PWD_RCFILT"                             , 0x0001c954, 23, 23},
{"bb_b2_BB6", "CALPA_PWD_V2I"                                , 0x0001c954, 22, 22},
{"bb_b2_BB6", "CALPA_PWD_BIQUAD1"                            , 0x0001c954, 21, 21},
{"bb_b2_BB6", "CALPA_PWD_BIQUAD2"                            , 0x0001c954, 20, 20},
{"bb_b2_BB6", "CALPA_REMOVECAP_RCFILT"                       , 0x0001c954, 19, 19},
{"bb_b2_BB6", "CALPA_NOTCH_HALFBW"                           , 0x0001c954, 18, 18},
{"bb_b2_BB6", "CALFC_RXIN2RC_EN"                             , 0x0001c954, 17, 17},
{"bb_b2_BB6", "CALFC_RC2BQ1_EN"                              , 0x0001c954, 16, 16},
{"bb_b2_BB6", "CALFC_RC2RXOUT_EN"                            , 0x0001c954, 15, 15},
{"bb_b2_BB6", "CALFC_BQ2RXOUT_EN"                            , 0x0001c954, 14, 14},
{"bb_b2_BB6", "CALFC_NOTCHON"                                , 0x0001c954, 13, 13},
{"bb_b2_BB6", "CALFC_BYPASSBQ1_EN"                           , 0x0001c954, 12, 12},
{"bb_b2_BB6", "CALFC_BQ2V2I_EN"                              , 0x0001c954, 11, 11},
{"bb_b2_BB6", "CALFC_DAC2V2I_EN"                             , 0x0001c954, 10, 10},
{"bb_b2_BB6", "CALFC_PWD_RCFILT"                             , 0x0001c954, 9 , 9 },
{"bb_b2_BB6", "CALFC_PWD_V2I"                                , 0x0001c954, 8 , 8 },
{"bb_b2_BB6", "CALFC_PWD_BIQUAD1"                            , 0x0001c954, 7 , 7 },
{"bb_b2_BB6", "CALFC_PWD_BIQUAD2"                            , 0x0001c954, 6 , 6 },
{"bb_b2_BB6", "CALFC_REMOVECAP_RCFILT"                       , 0x0001c954, 5 , 5 },
{"bb_b2_BB6", "CALFC_NOTCH_HALFBW"                           , 0x0001c954, 4 , 4 },
{"bb_b2_BB6", "PWD_BB_BIAS"                                  , 0x0001c954, 3 , 3 },
{"bb_b2_BB6", "DRV_STR"                                      , 0x0001c954, 2 , 0 },
{"bb_b2_BB7", "LPRX_RXIN2RC_EN"                              , 0x0001c958, 31, 31},
{"bb_b2_BB7", "LPRX_RC2BQ1_EN"                               , 0x0001c958, 30, 30},
{"bb_b2_BB7", "LPRX_RC2RXOUT_EN"                             , 0x0001c958, 29, 29},
{"bb_b2_BB7", "LPRX_BQ2RXOUT_EN"                             , 0x0001c958, 28, 28},
{"bb_b2_BB7", "LPRX_NOTCHON"                                 , 0x0001c958, 27, 27},
{"bb_b2_BB7", "LPRX_BYPASSBQ1_EN"                            , 0x0001c958, 26, 26},
{"bb_b2_BB7", "LPRX_BQ2V2I_EN"                               , 0x0001c958, 25, 25},
{"bb_b2_BB7", "LPRX_DAC2V2I_EN"                              , 0x0001c958, 24, 24},
{"bb_b2_BB7", "LPRX_PWD_RCFILT"                              , 0x0001c958, 23, 23},
{"bb_b2_BB7", "LPRX_PWD_V2I"                                 , 0x0001c958, 22, 22},
{"bb_b2_BB7", "LPRX_PWD_BIQUAD1"                             , 0x0001c958, 21, 21},
{"bb_b2_BB7", "LPRX_PWD_BIQUAD2"                             , 0x0001c958, 20, 20},
{"bb_b2_BB7", "LPRX_REMOVECAP_RCFILT"                        , 0x0001c958, 19, 19},
{"bb_b2_BB7", "LPRX_NOTCH_HALFBW"                            , 0x0001c958, 18, 18},
{"bb_b2_BB7", "LPRX_FILTERFC"                                , 0x0001c958, 17, 13},
{"bb_b2_BB7", "PWD_OSDAC_CAL"                                , 0x0001c958, 12, 10},
{"bb_b2_BB7", "NOTCH_HALFBW"                                 , 0x0001c958, 9 , 9 },
{"bb_b2_BB7", "RX_FILTERFC_OVR"                              , 0x0001c958, 8 , 8 },
{"bb_b2_BB7", "TX_FILTERFC_OVR"                              , 0x0001c958, 7 , 7 },
{"bb_b2_BB7", "LPRX_FILTERFC_OVR"                            , 0x0001c958, 6 , 6 },
{"bb_b2_BB7", "ADCSHORT"                                     , 0x0001c958, 5 , 5 },
{"bb_b2_BB7", "ADCSHORT_OVR"                                 , 0x0001c958, 4 , 4 },
{"bb_b2_BB7", "ADDACLOOPBACK"                                , 0x0001c958, 3 , 3 },
{"bb_b2_BB7", "DACFULLSCALE"                                 , 0x0001c958, 2 , 2 },
{"bb_b2_BB7", "LOWPWRLISTEN_OVR"                             , 0x0001c958, 1 , 1 },
{"bb_b2_BB7", "LOWPWRLISTEN"                                 , 0x0001c958, 0 , 0 },
{"bb_b2_BB8", "RX1DB_BIQUAD"                                 , 0x0001c95c, 31, 29},
{"bb_b2_BB8", "RX6DB_BIQUAD1"                                , 0x0001c95c, 28, 27},
{"bb_b2_BB8", "RX6DB_BIQUAD2"                                , 0x0001c95c, 26, 25},
{"bb_b2_BB8", "TX1DB_BIQUAD"                                 , 0x0001c95c, 24, 22},
{"bb_b2_BB8", "TX6DB_BIQUAD1"                                , 0x0001c95c, 21, 20},
{"bb_b2_BB8", "TX6DB_BIQUAD2"                                , 0x0001c95c, 19, 18},
{"bb_b2_BB8", "TXBB_GC"                                      , 0x0001c95c, 17, 14},
{"bb_b2_BB8", "DACRSTB"                                      , 0x0001c95c, 13, 13},
{"bb_b2_BB8", "INV_CLK320_ADDAC"                             , 0x0001c95c, 12, 12},
{"bb_b2_BB8", "local_dacpwd"                                 , 0x0001c95c, 11, 11},
{"bb_b2_BB8", "dacpwd"                                       , 0x0001c95c, 10, 10},
{"bb_b2_BB8", "dacclkpwd"                                    , 0x0001c95c, 9 , 9 },
{"bb_b2_BB8", "local_adcpwd"                                 , 0x0001c95c, 8 , 8 },
{"bb_b2_BB8", "adcpwd"                                       , 0x0001c95c, 7 , 7 },
{"bb_b2_BB8", "adcclkpwd"                                    , 0x0001c95c, 6 , 6 },
{"bb_b2_BB8", "local_clkmodaaddac"                           , 0x0001c95c, 5 , 5 },
{"bb_b2_BB8", "dac_clk_sel"                                  , 0x0001c95c, 4 , 4 },
{"bb_b2_BB8", "adc_clk_sel"                                  , 0x0001c95c, 3 , 2 },
{"bb_b2_BB8", "dactermResSw"                                 , 0x0001c95c, 1 , 0 },
{"rbist_b2_rbist_cntrl", "ate_rx_dc_interleave_power_measurement", 0x0001cb80, 21, 21},
{"rbist_b2_rbist_cntrl", "ate_rx_dc_interleave"              , 0x0001cb80, 20, 17},
{"rbist_b2_rbist_cntrl", "ate_rbist_enable"                  , 0x0001cb80, 16, 16},
{"rbist_b2_rbist_cntrl", "ate_rxdac_calibrate"               , 0x0001cb80, 15, 15},
{"rbist_b2_rbist_cntrl", "ate_cmac_power_hpf_enable"         , 0x0001cb80, 14, 14},
{"rbist_b2_rbist_cntrl", "ate_cmac_i2q2_enable"              , 0x0001cb80, 13, 13},
{"rbist_b2_rbist_cntrl", "ate_cmac_iq_enable"                , 0x0001cb80, 12, 12},
{"rbist_b2_rbist_cntrl", "ate_cmac_power_enable"             , 0x0001cb80, 11, 11},
{"rbist_b2_rbist_cntrl", "ate_cmac_corr_enable"              , 0x0001cb80, 10, 10},
{"rbist_b2_rbist_cntrl", "ate_cmac_dc_enable"                , 0x0001cb80, 9 , 9 },
{"rbist_b2_rbist_cntrl", "ate_cmac_dc_write_to_cancel"       , 0x0001cb80, 8 , 8 },
{"rbist_b2_rbist_cntrl", "ate_tonegen_prbs_enable_q"         , 0x0001cb80, 7 , 7 },
{"rbist_b2_rbist_cntrl", "ate_tonegen_prbs_enable_i"         , 0x0001cb80, 6 , 6 },
{"rbist_b2_rbist_cntrl", "ate_tonegen_linramp_enable_q"      , 0x0001cb80, 5 , 5 },
{"rbist_b2_rbist_cntrl", "ate_tonegen_linramp_enable_i"      , 0x0001cb80, 4 , 4 },
{"rbist_b2_rbist_cntrl", "ate_tonegen_lftone0_enable"        , 0x0001cb80, 3 , 3 },
{"rbist_b2_rbist_cntrl", "ate_tonegen_tone1_enable"          , 0x0001cb80, 2 , 2 },
{"rbist_b2_rbist_cntrl", "ate_tonegen_tone0_enable"          , 0x0001cb80, 1 , 1 },
{"rbist_b2_rbist_cntrl", "ate_tonegen_dc_enable"             , 0x0001cb80, 0 , 0 },
{"rbist_b2_tx_dc_offset", "ate_tonegen_dc_q"                 , 0x0001cb84, 26, 16},
{"rbist_b2_tx_dc_offset", "ate_tonegen_dc_i"                 , 0x0001cb84, 10, 0 },
{"rbist_b2_tx_tonegen0", "ate_tonegen_tone_tau_k"            , 0x0001cb88, 31, 24},
{"rbist_b2_tx_tonegen0", "ate_tonegen_tone_backoff_1db"      , 0x0001cb88, 18, 16},
{"rbist_b2_tx_tonegen0", "ate_tonegen_tone_backoff_6db"      , 0x0001cb88, 11, 8 },
{"rbist_b2_tx_tonegen0", "ate_tonegen_tone_freq"             , 0x0001cb88, 7 , 0 },
{"rbist_b2_tx_tonegen1", "ate_tonegen_tone_tau_k"            , 0x0001cb8c, 31, 24},
{"rbist_b2_tx_tonegen1", "ate_tonegen_tone_backoff_1db"      , 0x0001cb8c, 18, 16},
{"rbist_b2_tx_tonegen1", "ate_tonegen_tone_backoff_6db"      , 0x0001cb8c, 11, 8 },
{"rbist_b2_tx_tonegen1", "ate_tonegen_tone_freq"             , 0x0001cb8c, 7 , 0 },
{"rbist_b2_tx_lftonegen0", "ate_tonegen_tone_tau_k"          , 0x0001cb90, 31, 24},
{"rbist_b2_tx_lftonegen0", "ate_tonegen_tone_backoff_1db"    , 0x0001cb90, 18, 16},
{"rbist_b2_tx_lftonegen0", "ate_tonegen_tone_backoff_6db"    , 0x0001cb90, 11, 8 },
{"rbist_b2_tx_lftonegen0", "ate_tonegen_tone_freq"           , 0x0001cb90, 7 , 0 },
{"rbist_b2_tx_linear_ramp_i", "ate_tonegen_linramp_step"     , 0x0001cb94, 29, 24},
{"rbist_b2_tx_linear_ramp_i", "ate_tonegen_linramp_dwell"    , 0x0001cb94, 21, 12},
{"rbist_b2_tx_linear_ramp_i", "ate_tonegen_linramp_init"     , 0x0001cb94, 10, 0 },
{"rbist_b2_tx_linear_ramp_q", "ate_tonegen_linramp_step"     , 0x0001cb98, 29, 24},
{"rbist_b2_tx_linear_ramp_q", "ate_tonegen_linramp_dwell"    , 0x0001cb98, 21, 12},
{"rbist_b2_tx_linear_ramp_q", "ate_tonegen_linramp_init"     , 0x0001cb98, 10, 0 },
{"rbist_b2_tx_prbs_mag", "ate_tonegen_prbs_magnitude_q"      , 0x0001cb9c, 25, 16},
{"rbist_b2_tx_prbs_mag", "ate_tonegen_prbs_magnitude_i"      , 0x0001cb9c, 9 , 0 },
{"rbist_b2_tx_prbs_seed_i", "ate_tonegen_prbs_seed"          , 0x0001cba0, 30, 0 },
{"rbist_b2_tx_prbs_seed_q", "ate_tonegen_prbs_seed"          , 0x0001cba4, 30, 0 },
{"rbist_b2_cmac_dc_cancel", "ate_cmac_dc_cancel_q"           , 0x0001cba8, 25, 16},
{"rbist_b2_cmac_dc_cancel", "ate_cmac_dc_cancel_i"           , 0x0001cba8, 9 , 0 },
{"rbist_b2_cmac_dc_offset", "ate_cmac_dc_cycles"             , 0x0001cbac, 3 , 0 },
{"rbist_b2_cmac_corr", "ate_cmac_corr_freq"                  , 0x0001cbb0, 14, 8 },
{"rbist_b2_cmac_corr", "ate_cmac_corr_cycles"                , 0x0001cbb0, 4 , 0 },
{"rbist_b2_cmac_power", "ate_cmac_power_cycles"              , 0x0001cbb4, 3 , 0 },
{"rbist_b2_cmac_cross_corr", "ate_cmac_iq_cycles"            , 0x0001cbb8, 3 , 0 },
{"rbist_b2_cmac_i2q2", "ate_cmac_i2q2_cycles"                , 0x0001cbbc, 3 , 0 },
{"rbist_b2_cmac_power_hpf", "ate_cmac_power_hpf_wait"        , 0x0001cbc0, 7 , 4 },
{"rbist_b2_cmac_power_hpf", "ate_cmac_power_hpf_cycles"      , 0x0001cbc0, 3 , 0 },
{"rbist_b2_rxdac_set1", "ate_rxdac_cal_measure_time"         , 0x0001cbc4, 19, 16},
{"rbist_b2_rxdac_set1", "ate_rxdac_cal_wait"                 , 0x0001cbc4, 13, 8 },
{"rbist_b2_rxdac_set1", "ate_rxdac_hi_gain"                  , 0x0001cbc4, 4 , 4 },
{"rbist_b2_rxdac_set1", "ate_rxdac_mux"                      , 0x0001cbc4, 1 , 0 },
{"rbist_b2_rxdac_set2", "ate_rxdac_q_low"                    , 0x0001cbc8, 28, 24},
{"rbist_b2_rxdac_set2", "ate_rxdac_i_low"                    , 0x0001cbc8, 20, 16},
{"rbist_b2_rxdac_set2", "ate_rxdac_q_hi"                     , 0x0001cbc8, 12, 8 },
{"rbist_b2_rxdac_set2", "ate_rxdac_i_hi"                     , 0x0001cbc8, 4 , 0 },
{"rbist_b2_rxdac_long_shift", "ate_rxdac_q_static"           , 0x0001cbcc, 12, 8 },
{"rbist_b2_rxdac_long_shift", "ate_rxdac_i_static"           , 0x0001cbcc, 4 , 0 },
{"rbist_b2_cmac_results_i", "ate_cmac_results"               , 0x0001cbd0, 31, 0 },
{"rbist_b2_cmac_results_q", "ate_cmac_results"               , 0x0001cbd4, 31, 0 },
{"rbist_b2_cmac_results_1_i", "ate_cmac_results"             , 0x0001cbd8, 31, 0 },
{"rbist_b2_cmac_results_1_q", "ate_cmac_results"             , 0x0001cbdc, 31, 0 },
{"rbist_b2_cmac_results_2_i", "ate_cmac_results"             , 0x0001cbe0, 31, 0 },
{"rbist_b2_cmac_results_2_q", "ate_cmac_results"             , 0x0001cbe4, 31, 0 },
{"rbist_b2_cmac_results_3_i", "ate_cmac_results"             , 0x0001cbe8, 31, 0 },
{"rbist_b2_cmac_results_3_q", "ate_cmac_results"             , 0x0001cbec, 31, 0 },
{"rbist_b2_cmac_dc_cancel_1", "ate_cmac_dc_cancel_q"         , 0x0001cbf0, 25, 16},
{"rbist_b2_cmac_dc_cancel_1", "ate_cmac_dc_cancel_i"         , 0x0001cbf0, 9 , 0 },
{"rbist_b2_cmac_dc_cancel_2", "ate_cmac_dc_cancel_q"         , 0x0001cbf4, 25, 16},
{"rbist_b2_cmac_dc_cancel_2", "ate_cmac_dc_cancel_i"         , 0x0001cbf4, 9 , 0 },
{"rbist_b2_cmac_dc_cancel_3", "ate_cmac_dc_cancel_q"         , 0x0001cbf8, 25, 16},
{"rbist_b2_cmac_dc_cancel_3", "ate_cmac_dc_cancel_i"         , 0x0001cbf8, 9 , 0 },
{"rbist_b2_cmac_gain_comp", "ate_cmac_gain_comp_enable"      , 0x0001cbfc, 31, 31},
{"rbist_b2_cmac_gain_comp", "ate_cmac_gain_comp_q"           , 0x0001cbfc, 13, 8 },
{"rbist_b2_cmac_gain_comp", "ate_cmac_gain_comp_i"           , 0x0001cbfc, 5 , 0 },
{"synth_bt_SYNTHBT1", "PWD_BIAS"                             , 0x0001d080, 31, 31},
{"synth_bt_SYNTHBT1", "PWD_CP"                               , 0x0001d080, 30, 30},
{"synth_bt_SYNTHBT1", "PWD_VCMON"                            , 0x0001d080, 29, 29},
{"synth_bt_SYNTHBT1", "PWD_VCO"                              , 0x0001d080, 28, 28},
{"synth_bt_SYNTHBT1", "PWD_PRESC"                            , 0x0001d080, 27, 27},
{"synth_bt_SYNTHBT1", "VCOREGBYPASS"                         , 0x0001d080, 26, 26},
{"synth_bt_SYNTHBT1", "VCOREGLEVEL"                          , 0x0001d080, 25, 24},
{"synth_bt_SYNTHBT1", "MONITOR_FB"                           , 0x0001d080, 23, 23},
{"synth_bt_SYNTHBT1", "MONITOR_REF"                          , 0x0001d080, 22, 22},
{"synth_bt_SYNTHBT1", "MONITOR_VC2HIGH"                      , 0x0001d080, 21, 21},
{"synth_bt_SYNTHBT1", "MONITOR_VC2LOW"                       , 0x0001d080, 20, 20},
{"synth_bt_SYNTHBT1", "MONITOR_SYNTHLOCKVCOK"                , 0x0001d080, 19, 19},
{"synth_bt_SYNTHBT1", "SEL_VCOABUS"                          , 0x0001d080, 18, 16},
{"synth_bt_SYNTHBT1", "SEL_VCMONABUS"                        , 0x0001d080, 15, 13},
{"synth_bt_SYNTHBT1", "DIGTESTOUTEN"                         , 0x0001d080, 12, 12},
{"synth_bt_SYNTHBT1", "CLKXTAL_EDGE_SEL"                     , 0x0001d080, 11, 11},
{"synth_bt_SYNTHBT1", "PFD_DISABLE"                          , 0x0001d080, 10, 10},
{"synth_bt_SYNTHBT1", "RESET_PSCOUNTERS"                     , 0x0001d080, 9 , 9 },
{"synth_bt_SYNTHBT1", "PSCOUNT_FBSEL"                        , 0x0001d080, 8 , 8 },
{"synth_bt_SYNTHBT1", "PRESC_SEL"                            , 0x0001d080, 7 , 6 },
{"synth_bt_SYNTHBT1", "PFDDELAY"                             , 0x0001d080, 5 , 5 },
{"synth_bt_SYNTHBT1", "LONGSHIFTSEL"                         , 0x0001d080, 4 , 4 },
{"synth_bt_SYNTHBT1", "LOCALSYNTHCAL"                        , 0x0001d080, 3 , 3 },
{"synth_bt_SYNTHBT1", "SYNTHCAL"                             , 0x0001d080, 2 , 2 },
{"synth_bt_SYNTHBT1", "SPARE1"                               , 0x0001d080, 1 , 1 },
{"synth_bt_SYNTHBT1", "BT_clk_doubler_en"                    , 0x0001d080, 0 , 0 },
{"synth_bt_SYNTHBT2", "FREQ0"                                , 0x0001d084, 31, 17},
{"synth_bt_SYNTHBT2", "FDIFF16"                              , 0x0001d084, 16, 7 },
{"synth_bt_SYNTHBT2", "VCOCAP0"                              , 0x0001d084, 6 , 0 },
{"synth_bt_SYNTHBT3", "OVR_CAL"                              , 0x0001d088, 31, 31},
{"synth_bt_SYNTHBT3", "WAIT_CAL_SETTLE"                      , 0x0001d088, 30, 25},
{"synth_bt_SYNTHBT3", "WAIT_SHORTR_PWRUP"                    , 0x0001d088, 24, 19},
{"synth_bt_SYNTHBT3", "VC_CAL_REF"                           , 0x0001d088, 18, 16},
{"synth_bt_SYNTHBT3", "VC_HI_REF"                            , 0x0001d088, 15, 13},
{"synth_bt_SYNTHBT3", "VC_MID_REF"                           , 0x0001d088, 12, 10},
{"synth_bt_SYNTHBT3", "VC_LOW_REF"                           , 0x0001d088, 9 , 7 },
{"synth_bt_SYNTHBT3", "ALWAYS_SHORTR"                        , 0x0001d088, 6 , 6 },
{"synth_bt_SYNTHBT3", "SHORTR_DURING_CAL"                    , 0x0001d088, 5 , 5 },
{"synth_bt_SYNTHBT3", "DIS_CLK_XTAL"                         , 0x0001d088, 4 , 4 },
{"synth_bt_SYNTHBT3", "FORCE_PINVC"                          , 0x0001d088, 3 , 3 },
{"synth_bt_SYNTHBT3", "SDM_DISABLE"                          , 0x0001d088, 2 , 2 },
{"synth_bt_SYNTHBT3", "SDM_DITHER"                           , 0x0001d088, 1 , 0 },
{"synth_bt_SYNTHBT4", "FORCE_VCOCAP"                         , 0x0001d08c, 31, 31},
{"synth_bt_SYNTHBT4", "VCOCAP_OVR"                           , 0x0001d08c, 30, 24},
{"synth_bt_SYNTHBT4", "SYNTHON_ST"                           , 0x0001d08c, 23, 23},
{"synth_bt_SYNTHBT4", "SYNTHCAL_ST"                          , 0x0001d08c, 22, 22},
{"synth_bt_SYNTHBT4", "SYNTH_SM_STATE"                       , 0x0001d08c, 21, 19},
{"synth_bt_SYNTHBT4", "PIN_VC"                               , 0x0001d08c, 18, 18},
{"synth_bt_SYNTHBT4", "SHORT_R"                              , 0x0001d08c, 17, 17},
{"synth_bt_SYNTHBT4", "RESET_RFD"                            , 0x0001d08c, 16, 16},
{"synth_bt_SYNTHBT4", "RESET_PFD"                            , 0x0001d08c, 15, 15},
{"synth_bt_SYNTHBT4", "RESET_PSCOUNTERS"                     , 0x0001d08c, 14, 14},
{"synth_bt_SYNTHBT4", "RESET_SDM_B"                          , 0x0001d08c, 13, 13},
{"synth_bt_SYNTHBT4", "VCO_CAP_ST"                           , 0x0001d08c, 12, 6 },
{"synth_bt_SYNTHBT4", "SPARE4"                               , 0x0001d08c, 5 , 0 },
{"synth_bt_SYNTHBT5", "FREQ0_ST"                             , 0x0001d090, 31, 17},
{"synth_bt_SYNTHBT5", "FDIFF16_ST"                           , 0x0001d090, 16, 7 },
{"synth_bt_SYNTHBT5", "VCOCAP0_ST"                           , 0x0001d090, 6 , 0 },
{"synth_bt_SYNTHBT6", "PWDB_IRPFDCP"                         , 0x0001d094, 31, 29},
{"synth_bt_SYNTHBT6", "PWDB_IRVCMON25"                       , 0x0001d094, 28, 26},
{"synth_bt_SYNTHBT6", "PWDB_ICPRESC50"                       , 0x0001d094, 25, 23},
{"synth_bt_SYNTHBT6", "PWDB_IRVCOREG50"                      , 0x0001d094, 22, 22},
{"synth_bt_SYNTHBT6", "PWDB_ICVCOREG25"                      , 0x0001d094, 21, 19},
{"synth_bt_SYNTHBT6", "PWDB_ICVCO25"                         , 0x0001d094, 18, 16},
{"synth_bt_SYNTHBT6", "VCOBIAS"                              , 0x0001d094, 15, 14},
{"synth_bt_SYNTHBT6", "PWDB_ICSPARE"                         , 0x0001d094, 13, 3 },
{"synth_bt_SYNTHBT6", "PWDB_IRSPARE"                         , 0x0001d094, 2 , 0 },
{"synth_bt_SYNTHBT7", "LOADSYNTHCHANNEL"                     , 0x0001d098, 31, 31},
{"synth_bt_SYNTHBT7", "CHANSEL"                              , 0x0001d098, 30, 22},
{"synth_bt_SYNTHBT7", "CHANFRAC"                             , 0x0001d098, 21, 5 },
{"synth_bt_SYNTHBT7", "REFDIV"                               , 0x0001d098, 4 , 3 },
{"synth_bt_SYNTHBT7", "SPARE7"                               , 0x0001d098, 2 , 0 },
{"synth_bt_SYNTHBT8", "LOOP_3RD_ORDER_R"                     , 0x0001d09c, 31, 27},
{"synth_bt_SYNTHBT8", "LOOP_CP"                              , 0x0001d09c, 26, 22},
{"synth_bt_SYNTHBT8", "LOOP_RS"                              , 0x0001d09c, 21, 17},
{"synth_bt_SYNTHBT8", "LOOP_ICP"                             , 0x0001d09c, 16, 12},
{"synth_bt_SYNTHBT8", "LOOPLEAKCUR"                          , 0x0001d09c, 11, 8 },
{"synth_bt_SYNTHBT8", "CPBIAS"                               , 0x0001d09c, 7 , 6 },
{"synth_bt_SYNTHBT8", "CPLOWLK"                              , 0x0001d09c, 5 , 5 },
{"synth_bt_SYNTHBT8", "CPSTEERING_EN"                        , 0x0001d09c, 4 , 4 },
{"synth_bt_SYNTHBT8", "SPARE8"                               , 0x0001d09c, 3 , 0 },
{"bias_bt_BIASBT1", "bias_sel"                               , 0x0001d0c0, 31, 25},
{"bias_bt_BIASBT1", "sel_ir25syn"                            , 0x0001d0c0, 24, 24},
{"bias_bt_BIASBT1", "sel_ir25sar"                            , 0x0001d0c0, 23, 23},
{"bias_bt_BIASBT1", "sel_ic25testiq"                         , 0x0001d0c0, 22, 22},
{"bias_bt_BIASBT1", "icbiascaltoATB"                         , 0x0001d0c0, 21, 21},
{"bias_bt_BIASBT1", "cgm_icsel"                              , 0x0001d0c0, 20, 17},
{"bias_bt_BIASBT1", "cgm_igsel"                              , 0x0001d0c0, 16, 13},
{"bias_bt_BIASBT1", "pwd_ic25adc"                            , 0x0001d0c0, 12, 10},
{"bias_bt_BIASBT1", "pwd_ic25cgm"                            , 0x0001d0c0, 9 , 7 },
{"bias_bt_BIASBT1", "pwd_ic25pllcp2"                         , 0x0001d0c0, 6 , 4 },
{"bias_bt_BIASBT1", "pwd_ic25pllcp"                          , 0x0001d0c0, 3 , 1 },
{"bias_bt_BIASBT1", "SPARE1"                                 , 0x0001d0c0, 0 , 0 },
{"bias_bt_BIASBT2", "pwd_ic25pllgm"                          , 0x0001d0c4, 31, 29},
{"bias_bt_BIASBT2", "pwd_ic25pllreg"                         , 0x0001d0c4, 28, 26},
{"bias_bt_BIASBT2", "pwd_ic25rxfiltI"                        , 0x0001d0c4, 25, 23},
{"bias_bt_BIASBT2", "pwd_ic25rxfiltQ"                        , 0x0001d0c4, 22, 20},
{"bias_bt_BIASBT2", "pwd_ic25rxmix"                          , 0x0001d0c4, 19, 17},
{"bias_bt_BIASBT2", "pwd_ic25paBT"                           , 0x0001d0c4, 16, 14},
{"bias_bt_BIASBT2", "pwd_ic25uAIC"                           , 0x0001d0c4, 13, 11},
{"bias_bt_BIASBT2", "pwd_ic25xtal"                           , 0x0001d0c4, 10, 8 },
{"bias_bt_BIASBT2", "pwd_ic25xtalreg"                        , 0x0001d0c4, 7 , 5 },
{"bias_bt_BIASBT2", "pwd_icg50lna"                           , 0x0001d0c4, 4 , 2 },
{"bias_bt_BIASBT2", "SPARE2"                                 , 0x0001d0c4, 1 , 0 },
{"bias_bt_BIASBT3", "pwd_ic50dac"                            , 0x0001d0c8, 31, 29},
{"bias_bt_BIASBT3", "pwd_ic50v2i"                            , 0x0001d0c8, 28, 26},
{"bias_bt_BIASBT3", "pwd_ic25tempsen"                        , 0x0001d0c8, 25, 23},
{"bias_bt_BIASBT3", "pwd_ic25synth"                          , 0x0001d0c8, 22, 20},
{"bias_bt_BIASBT3", "pwd_ir12p5spare"                        , 0x0001d0c8, 19, 19},
{"bias_bt_BIASBT3", "pwd_ic25rxagc"                          , 0x0001d0c8, 18, 16},
{"bias_bt_BIASBT3", "pwd_icbiascal"                          , 0x0001d0c8, 15, 15},
{"bias_bt_BIASBT3", "pwd_ic25testiq"                         , 0x0001d0c8, 14, 12},
{"bias_bt_BIASBT3", "pwd_ir25adc"                            , 0x0001d0c8, 11, 9 },
{"bias_bt_BIASBT3", "pwd_ir25cgm"                            , 0x0001d0c8, 8 , 6 },
{"bias_bt_BIASBT3", "pwd_ir25lo"                             , 0x0001d0c8, 5 , 3 },
{"bias_bt_BIASBT3", "pwd_ir25pa"                             , 0x0001d0c8, 2 , 0 },
{"bias_bt_BIASBT4", "pwd_ir25pllreg"                         , 0x0001d0cc, 31, 29},
{"bias_bt_BIASBT4", "pwd_ir25rxagc2"                         , 0x0001d0cc, 28, 26},
{"bias_bt_BIASBT4", "pwd_ir25otpreg"                         , 0x0001d0cc, 25, 23},
{"bias_bt_BIASBT4", "pwd_ir25txmix"                          , 0x0001d0cc, 22, 20},
{"bias_bt_BIASBT4", "pwd_ir25xtalreg"                        , 0x0001d0cc, 19, 17},
{"bias_bt_BIASBT4", "pwd_ir25tempsen"                        , 0x0001d0cc, 16, 14},
{"bias_bt_BIASBT4", "pwd_ir25synth"                          , 0x0001d0cc, 13, 11},
{"bias_bt_BIASBT4", "pwd_ir25sar"                            , 0x0001d0cc, 10, 8 },
{"bias_bt_BIASBT4", "pwd_ir25rxagc"                          , 0x0001d0cc, 7 , 5 },
{"bias_bt_BIASBT4", "pwd_ic75lna2GBT"                        , 0x0001d0cc, 4 , 2 },
{"bias_bt_BIASBT4", "SPARE4"                                 , 0x0001d0cc, 1 , 0 },
{"bias_bt_BIASBT5", "pwd_ic25spare1"                         , 0x0001d0d0, 31, 29},
{"bias_bt_BIASBT5", "pwd_ic25spare2"                         , 0x0001d0d0, 28, 26},
{"bias_bt_BIASBT5", "pwd_ic25spare3"                         , 0x0001d0d0, 25, 23},
{"bias_bt_BIASBT5", "pwd_ir25spare1"                         , 0x0001d0d0, 22, 20},
{"bias_bt_BIASBT5", "pwd_ir25spare2"                         , 0x0001d0d0, 19, 17},
{"bias_bt_BIASBT5", "SPARE5"                                 , 0x0001d0d0, 16, 0 },
{"top_bt_TOPBT1", "adc_atb"                                  , 0x0001d100, 31, 28},
{"top_bt_TOPBT1", "adc_clkdly"                               , 0x0001d100, 27, 27},
{"top_bt_TOPBT1", "adc_iamp1c"                               , 0x0001d100, 26, 24},
{"top_bt_TOPBT1", "adc_iamp2c"                               , 0x0001d100, 23, 21},
{"top_bt_TOPBT1", "adc_iamp3c"                               , 0x0001d100, 20, 18},
{"top_bt_TOPBT1", "adc_irefc"                                , 0x0001d100, 17, 15},
{"top_bt_TOPBT1", "adc_neg2out"                              , 0x0001d100, 14, 14},
{"top_bt_TOPBT1", "adc_negout"                               , 0x0001d100, 13, 13},
{"top_bt_TOPBT1", "adc_pwd"                                  , 0x0001d100, 12, 12},
{"top_bt_TOPBT1", "adc_pwdQ"                                 , 0x0001d100, 11, 11},
{"top_bt_TOPBT1", "adc_pwdsd21"                              , 0x0001d100, 10, 10},
{"top_bt_TOPBT1", "adc_rst"                                  , 0x0001d100, 9 , 9 },
{"top_bt_TOPBT1", "adc_shortreffilt"                         , 0x0001d100, 8 , 8 },
{"top_bt_TOPBT1", "pwdpll"                                   , 0x0001d100, 7 , 7 },
{"top_bt_TOPBT1", "atb_int2gnd"                              , 0x0001d100, 6 , 6 },
{"top_bt_TOPBT1", "atb_int2pad"                              , 0x0001d100, 5 , 5 },
{"top_bt_TOPBT1", "atb_intH2gnd"                             , 0x0001d100, 4 , 4 },
{"top_bt_TOPBT1", "atb_intH2pad"                             , 0x0001d100, 3 , 3 },
{"top_bt_TOPBT1", "atb_pad2gnd"                              , 0x0001d100, 2 , 2 },
{"top_bt_TOPBT1", "pwdLPO"                                   , 0x0001d100, 1 , 1 },
{"top_bt_TOPBT1", "pwdshpa"                                  , 0x0001d100, 0 , 0 },
{"top_bt_TOPBT2", "bias_rbias"                               , 0x0001d104, 31, 26},
{"top_bt_TOPBT2", "bias_pwdbg"                               , 0x0001d104, 25, 25},
{"top_bt_TOPBT2", "bias_pwdcgm"                              , 0x0001d104, 24, 24},
{"top_bt_TOPBT2", "bias_pwdmirrors"                          , 0x0001d104, 23, 23},
{"top_bt_TOPBT2", "bias_pwdv2i"                              , 0x0001d104, 22, 22},
{"top_bt_TOPBT2", "caltx"                                    , 0x0001d104, 21, 21},
{"top_bt_TOPBT2", "calPA"                                    , 0x0001d104, 20, 20},
{"top_bt_TOPBT2", "fe_atb"                                   , 0x0001d104, 19, 17},
{"top_bt_TOPBT2", "fe_txmod"                                 , 0x0001d104, 16, 15},
{"top_bt_TOPBT2", "fe_db0"                                   , 0x0001d104, 14, 12},
{"top_bt_TOPBT2", "fe_db1"                                   , 0x0001d104, 11, 9 },
{"top_bt_TOPBT2", "fe_db2"                                   , 0x0001d104, 8 , 6 },
{"top_bt_TOPBT2", "fe_db3"                                   , 0x0001d104, 5 , 3 },
{"top_bt_TOPBT2", "shlnagn"                                  , 0x0001d104, 2 , 0 },
{"top_bt_TOPBT3", "fe_lnagn"                                 , 0x0001d108, 31, 29},
{"top_bt_TOPBT3", "fe_lnaon"                                 , 0x0001d108, 28, 28},
{"top_bt_TOPBT3", "fe_sellna"                                , 0x0001d108, 27, 27},
{"top_bt_TOPBT3", "fe_trsw_txen"                             , 0x0001d108, 26, 26},
{"top_bt_TOPBT3", "fe_cref"                                  , 0x0001d108, 25, 24},
{"top_bt_TOPBT3", "fe_ob0"                                   , 0x0001d108, 23, 21},
{"top_bt_TOPBT3", "fe_ob1"                                   , 0x0001d108, 20, 18},
{"top_bt_TOPBT3", "fe_ob2"                                   , 0x0001d108, 17, 15},
{"top_bt_TOPBT3", "fe_ob3"                                   , 0x0001d108, 14, 12},
{"top_bt_TOPBT3", "fe_padrvgn"                               , 0x0001d108, 11, 9 },
{"top_bt_TOPBT3", "fe_paoutgn"                               , 0x0001d108, 8 , 6 },
{"top_bt_TOPBT3", "fe_pasupplyswitch"                        , 0x0001d108, 5 , 5 },
{"top_bt_TOPBT3", "fe_phase"                                 , 0x0001d108, 4 , 4 },
{"top_bt_TOPBT3", "fe_pwddbias"                              , 0x0001d108, 3 , 3 },
{"top_bt_TOPBT3", "fe_pwddgain"                              , 0x0001d108, 2 , 2 },
{"top_bt_TOPBT3", "fe_pwdpaout"                              , 0x0001d108, 1 , 1 },
{"top_bt_TOPBT3", "force_oscon"                              , 0x0001d108, 0 , 0 },
{"top_bt_TOPBT4", "force_rxtxlo"                             , 0x0001d10c, 31, 31},
{"top_bt_TOPBT4", "force_sclken"                             , 0x0001d10c, 30, 30},
{"top_bt_TOPBT4", "force_synthon"                            , 0x0001d10c, 29, 29},
{"top_bt_TOPBT4", "lo_atb"                                   , 0x0001d10c, 28, 26},
{"top_bt_TOPBT4", "lo_pwdlorx"                               , 0x0001d10c, 25, 25},
{"top_bt_TOPBT4", "lo_pwdlotx"                               , 0x0001d10c, 24, 24},
{"top_bt_TOPBT4", "lo_divon_if_synthon"                      , 0x0001d10c, 23, 23},
{"top_bt_TOPBT4", "localaddac"                               , 0x0001d10c, 22, 22},
{"top_bt_TOPBT4", "localmode"                                , 0x0001d10c, 21, 21},
{"top_bt_TOPBT4", "localrxagc"                               , 0x0001d10c, 20, 20},
{"top_bt_TOPBT4", "localrxgain"                              , 0x0001d10c, 19, 19},
{"top_bt_TOPBT4", "localsynth"                               , 0x0001d10c, 18, 18},
{"top_bt_TOPBT4", "localtxgain"                              , 0x0001d10c, 17, 17},
{"top_bt_TOPBT4", "localpwd"                                 , 0x0001d10c, 16, 16},
{"top_bt_TOPBT4", "localtrsw"                                , 0x0001d10c, 15, 15},
{"top_bt_TOPBT4", "localrbias"                               , 0x0001d10c, 14, 14},
{"top_bt_TOPBT4", "rxAGCpwd"                                 , 0x0001d10c, 13, 13},
{"top_bt_TOPBT4", "rxAGCcal"                                 , 0x0001d10c, 12, 12},
{"top_bt_TOPBT4", "rxAGCcalth"                               , 0x0001d10c, 11, 6 },
{"top_bt_TOPBT4", "rxAGCfall"                                , 0x0001d10c, 5 , 4 },
{"top_bt_TOPBT4", "rxAGCtarg"                                , 0x0001d10c, 3 , 0 },
{"top_bt_TOPBT5", "rxfilt_gn"                                , 0x0001d110, 31, 28},
{"top_bt_TOPBT5", "rxfilt_pwdI"                              , 0x0001d110, 27, 27},
{"top_bt_TOPBT5", "rxfilt_pwdQ"                              , 0x0001d110, 26, 26},
{"top_bt_TOPBT5", "rxfilt_boostOPout"                        , 0x0001d110, 25, 25},
{"top_bt_TOPBT5", "rxon"                                     , 0x0001d110, 24, 24},
{"top_bt_TOPBT5", "rxmix_atb"                                , 0x0001d110, 23, 22},
{"top_bt_TOPBT5", "rxmix_gn"                                 , 0x0001d110, 21, 20},
{"top_bt_TOPBT5", "rxmix_pwdI"                               , 0x0001d110, 19, 19},
{"top_bt_TOPBT5", "rxmix_pwdQ"                               , 0x0001d110, 18, 18},
{"top_bt_TOPBT5", "synthon"                                  , 0x0001d110, 17, 17},
{"top_bt_TOPBT5", "synthonTxMode"                            , 0x0001d110, 16, 16},
{"top_bt_TOPBT5", "testiq_bufen"                             , 0x0001d110, 15, 15},
{"top_bt_TOPBT5", "testiq_s"                                 , 0x0001d110, 14, 12},
{"top_bt_TOPBT5", "sel_digtestdata"                          , 0x0001d110, 11, 10},
{"top_bt_TOPBT5", "force_testiq_dig_oel"                     , 0x0001d110, 9 , 9 },
{"top_bt_TOPBT5", "force_atb_dig_oel"                        , 0x0001d110, 8 , 8 },
{"top_bt_TOPBT5", "ldo_lvl"                                  , 0x0001d110, 7 , 5 },
{"top_bt_TOPBT5", "otpreg_on"                                , 0x0001d110, 4 , 4 },
{"top_bt_TOPBT5", "otp_ps_en"                                , 0x0001d110, 3 , 3 },
{"top_bt_TOPBT5", "otpreg_lvlctr"                            , 0x0001d110, 2 , 1 },
{"top_bt_TOPBT5", "lfosc_test_disable"                       , 0x0001d110, 0 , 0 },
{"top_bt_TOPBT6", "tx_atb"                                   , 0x0001d114, 31, 28},
{"top_bt_TOPBT6", "tx_dacpwd"                                , 0x0001d114, 27, 27},
{"top_bt_TOPBT6", "tx_dacresolution"                         , 0x0001d114, 26, 25},
{"top_bt_TOPBT6", "tx_dacrstb"                               , 0x0001d114, 24, 24},
{"top_bt_TOPBT6", "tx_forcedacfullscale"                     , 0x0001d114, 23, 23},
{"top_bt_TOPBT6", "paon"                                     , 0x0001d114, 22, 22},
{"top_bt_TOPBT6", "txon"                                     , 0x0001d114, 21, 21},
{"top_bt_TOPBT6", "tx_pwdmix"                                , 0x0001d114, 20, 20},
{"top_bt_TOPBT6", "tx_v2ign"                                 , 0x0001d114, 19, 18},
{"top_bt_TOPBT6", "xtal_oscon"                               , 0x0001d114, 17, 17},
{"top_bt_TOPBT6", "vddhsense_on"                             , 0x0001d114, 16, 16},
{"top_bt_TOPBT6", "localtherm"                               , 0x0001d114, 15, 15},
{"top_bt_TOPBT6", "therm_on"                                 , 0x0001d114, 14, 14},
{"top_bt_TOPBT6", "therm_start"                              , 0x0001d114, 13, 13},
{"top_bt_TOPBT6", "therm_sel"                                , 0x0001d114, 12, 11},
{"top_bt_TOPBT6", "therm_slow"                               , 0x0001d114, 10, 10},
{"top_bt_TOPBT6", "therm_autopwd_en"                         , 0x0001d114, 9 , 9 },
{"top_bt_TOPBT6", "therm_adccal_en"                          , 0x0001d114, 8 , 8 },
{"top_bt_TOPBT6", "therm_dactest_en"                         , 0x0001d114, 7 , 7 },
{"top_bt_TOPBT6", "SEL_MULABUS"                              , 0x0001d114, 6 , 4 },
{"top_bt_TOPBT6", "RESERVED"                                 , 0x0001d114, 3 , 0 },
{"top_bt_TOPBT7", "therm_dactest_code"                       , 0x0001d118, 31, 24},
{"top_bt_TOPBT7", "xtal_oscon"                               , 0x0001d118, 23, 23},
{"top_bt_TOPBT7", "synthon"                                  , 0x0001d118, 22, 22},
{"top_bt_TOPBT7", "synthonTxMode"                            , 0x0001d118, 21, 21},
{"top_bt_TOPBT7", "rxon"                                     , 0x0001d118, 20, 20},
{"top_bt_TOPBT7", "txon"                                     , 0x0001d118, 19, 19},
{"top_bt_TOPBT7", "paon"                                     , 0x0001d118, 18, 18},
{"top_bt_TOPBT7", "caltx"                                    , 0x0001d118, 17, 17},
{"top_bt_TOPBT7", "calPA"                                    , 0x0001d118, 16, 16},
{"top_bt_TOPBT7", "fe_phase"                                 , 0x0001d118, 15, 15},
{"top_bt_TOPBT7", "fe_lnagn"                                 , 0x0001d118, 14, 12},
{"top_bt_TOPBT7", "fe_lnaon"                                 , 0x0001d118, 11, 11},
{"top_bt_TOPBT7", "fe_sellna"                                , 0x0001d118, 10, 10},
{"top_bt_TOPBT7", "fe_txmod"                                 , 0x0001d118, 9 , 8 },
{"top_bt_TOPBT7", "fe_padrvgn"                               , 0x0001d118, 7 , 5 },
{"top_bt_TOPBT7", "fe_paoutgn"                               , 0x0001d118, 4 , 2 },
{"top_bt_TOPBT7", "pwdpll"                                   , 0x0001d118, 1 , 1 },
{"top_bt_TOPBT7", "rxAGCpwd"                                 , 0x0001d118, 0 , 0 },
{"top_bt_TOPBT8", "rxAGCcal"                                 , 0x0001d11c, 31, 31},
{"top_bt_TOPBT8", "rxAGCcalth"                               , 0x0001d11c, 30, 25},
{"top_bt_TOPBT8", "rxAGCfall"                                , 0x0001d11c, 24, 23},
{"top_bt_TOPBT8", "rxAGCtarg"                                , 0x0001d11c, 22, 19},
{"top_bt_TOPBT8", "rxfilt_gn"                                , 0x0001d11c, 18, 15},
{"top_bt_TOPBT8", "rxmix_gn"                                 , 0x0001d11c, 14, 13},
{"top_bt_TOPBT8", "tx_dacresolution"                         , 0x0001d11c, 12, 11},
{"top_bt_TOPBT8", "tx_v2ign"                                 , 0x0001d11c, 10, 9 },
{"top_bt_TOPBT8", "vddhsense_on"                             , 0x0001d11c, 8 , 8 },
{"top_bt_TOPBT8", "therm_on"                                 , 0x0001d11c, 7 , 7 },
{"top_bt_TOPBT8", "therm_start"                              , 0x0001d11c, 6 , 6 },
{"top_bt_TOPBT8", "therm_sel"                                , 0x0001d11c, 5 , 4 },
{"top_bt_TOPBT8", "therm_done"                               , 0x0001d11c, 3 , 3 },
{"top_bt_TOPBT8", "lnaAGCout"                                , 0x0001d11c, 2 , 2 },
{"top_bt_TOPBT8", "RESERVED"                                 , 0x0001d11c, 1 , 0 },
{"top_bt_TOPBT9", "therm_val"                                , 0x0001d120, 31, 24},
{"top_bt_TOPBT9", "bias_rbias"                               , 0x0001d120, 23, 18},
{"top_bt_TOPBT9", "revid"                                    , 0x0001d120, 17, 15},
{"top_bt_TOPBT9", "PAforcedonBT"                             , 0x0001d120, 14, 14},
{"top_bt_TOPBT9", "ocasBT"                                   , 0x0001d120, 13, 11},
{"top_bt_TOPBT9", "lna_LP_BT"                                , 0x0001d120, 10, 10},
{"top_bt_TOPBT9", "mxrforcedonBT"                            , 0x0001d120, 9 , 9 },
{"top_bt_TOPBT9", "use_shared_pa"                            , 0x0001d120, 8 , 8 },
{"top_bt_TOPBT9", "use_shared_lna"                           , 0x0001d120, 7 , 7 },
{"top_bt_TOPBT9", "obpwdBT"                                  , 0x0001d120, 6 , 4 },
{"top_bt_TOPBT9", "testiq_rsel"                              , 0x0001d120, 3 , 3 },
{"top_bt_TOPBT9", "RESERVED"                                 , 0x0001d120, 2 , 1 },
{"top_bt_TOPBT9", "enable_lpo2"                              , 0x0001d120, 0 , 0 },
{"top_bt_TOPBT10", "AICstandby_enable"                       , 0x0001d124, 31, 29},
{"top_bt_TOPBT10", "AIC_fix_capdiv"                          , 0x0001d124, 28, 26},
{"top_bt_TOPBT10", "AIC_csteer_en"                           , 0x0001d124, 25, 25},
{"top_bt_TOPBT10", "pwdAICvgaI"                              , 0x0001d124, 24, 22},
{"top_bt_TOPBT10", "pwdAICvgaQ"                              , 0x0001d124, 21, 19},
{"top_bt_TOPBT10", "local_AICpwd"                            , 0x0001d124, 18, 18},
{"top_bt_TOPBT10", "AIC_atb"                                 , 0x0001d124, 17, 15},
{"top_bt_TOPBT10", "VREFMUL1"                                , 0x0001d124, 14, 11},
{"top_bt_TOPBT10", "VREFMUL2"                                , 0x0001d124, 10, 7 },
{"top_bt_TOPBT10", "VREFMUL3"                                , 0x0001d124, 6 , 3 },
{"top_bt_TOPBT10", "STRCONT"                                 , 0x0001d124, 2 , 2 },
{"top_bt_TOPBT10", "therm_rst_ls"                            , 0x0001d124, 1 , 1 },
{"top_bt_TOPBT10", "proc_mon_en"                             , 0x0001d124, 0 , 0 },
{"clk_bt_CLK1", "clkmod_adc_clk_div2"                        , 0x0001d280, 31, 31},
{"clk_bt_CLK1", "clkmod_adc_clk_phase"                       , 0x0001d280, 30, 29},
{"clk_bt_CLK1", "clkmod_adc_clk_sel"                         , 0x0001d280, 28, 28},
{"clk_bt_CLK1", "clkmod_adcclkduty"                          , 0x0001d280, 27, 27},
{"clk_bt_CLK1", "clkmod_dac_clk_div2"                        , 0x0001d280, 26, 26},
{"clk_bt_CLK1", "clkmod_dac_clk_phase"                       , 0x0001d280, 25, 24},
{"clk_bt_CLK1", "clkmod_spurfreq"                            , 0x0001d280, 23, 22},
{"clk_bt_CLK1", "clkmod_spuron"                              , 0x0001d280, 21, 21},
{"clk_bt_CLK1", "clkmod_pllbypass"                           , 0x0001d280, 20, 20},
{"clk_bt_CLK1", "clkmod_localmode"                           , 0x0001d280, 19, 19},
{"clk_bt_CLK1", "clkmod_codec_pwd"                           , 0x0001d280, 18, 18},
{"clk_bt_CLK1", "clkmod_codec_src"                           , 0x0001d280, 17, 17},
{"clk_bt_CLK1", "clkmod_codec_mode"                          , 0x0001d280, 16, 16},
{"clk_bt_CLK1", "clkmod_testclk_en"                          , 0x0001d280, 15, 15},
{"clk_bt_CLK1", "clkmod_testclk_sel"                         , 0x0001d280, 14, 12},
{"clk_bt_CLK1", "clkmod_usepllout"                           , 0x0001d280, 11, 11},
{"clk_bt_CLK1", "clkmod_force_en"                            , 0x0001d280, 10, 10},
{"clk_bt_CLK1", "pll_atb"                                    , 0x0001d280, 9 , 8 },
{"clk_bt_CLK1", "pll_icp"                                    , 0x0001d280, 7 , 5 },
{"clk_bt_CLK1", "pll_filter"                                 , 0x0001d280, 4 , 0 },
{"clk_bt_CLK2", "pll_refdiv"                                 , 0x0001d284, 31, 28},
{"clk_bt_CLK2", "pll_div"                                    , 0x0001d284, 27, 18},
{"clk_bt_CLK2", "pll_frac"                                   , 0x0001d284, 17, 3 },
{"clk_bt_CLK2", "pll_hifreq_en"                              , 0x0001d284, 2 , 2 },
{"clk_bt_CLK2", "pll_kvco"                                   , 0x0001d284, 1 , 0 },
{"clk_bt_CLK3", "pll_svreg"                                  , 0x0001d288, 31, 31},
{"clk_bt_CLK3", "xtal_bias2x"                                , 0x0001d288, 30, 30},
{"clk_bt_CLK3", "xtal_capindac"                              , 0x0001d288, 29, 23},
{"clk_bt_CLK3", "xtal_capoutdac"                             , 0x0001d288, 22, 16},
{"clk_bt_CLK3", "xtal_drvpnr"                                , 0x0001d288, 15, 14},
{"clk_bt_CLK3", "xtal_localbias"                             , 0x0001d288, 13, 13},
{"clk_bt_CLK3", "xtal_notcxodet"                             , 0x0001d288, 12, 12},
{"clk_bt_CLK3", "xtal_pwdclkD"                               , 0x0001d288, 11, 11},
{"clk_bt_CLK3", "xtal_svreg"                                 , 0x0001d288, 10, 10},
{"clk_bt_CLK3", "xtal_highZ"                                 , 0x0001d288, 9 , 9 },
{"clk_bt_CLK3", "xtal_Lbias2x"                               , 0x0001d288, 8 , 8 },
{"clk_bt_CLK3", "refclk_to_adc"                              , 0x0001d288, 7 , 7 },
{"clk_bt_CLK3", "SPARE3"                                     , 0x0001d288, 6 , 0 },
{"pmu_bt_BT_PMU1", "swreg"                                   , 0x0001d340, 31, 0 },
{"pmu_bt_BT_PMU2", "swregmsb"                                , 0x0001d344, 31, 22},
{"pmu_bt_BT_PMU2", "pgm"                                     , 0x0001d344, 21, 21},
{"pmu_bt_BT_PMU2", "disc_bit_local"                          , 0x0001d344, 20, 20},
{"pmu_bt_BT_PMU2", "SPARE"                                   , 0x0001d344, 19, 0 },
{"MAC_DMA_CR", "SWI"                                         , 0x00020008, 6 , 6 },
{"MAC_DMA_CR", "RXD"                                         , 0x00020008, 5 , 5 },
{"MAC_DMA_CFG", "TX_PPDU_END_SWAP"                           , 0x00020014, 31, 31},
{"MAC_DMA_CFG", "MAX_FRAG_TABLE_ENTRIES"                     , 0x00020014, 30, 27},
{"MAC_DMA_CFG", "TX_PACKET_SWAP"                             , 0x00020014, 26, 26},
{"MAC_DMA_CFG", "CV_ENTRY_SWAP"                              , 0x00020014, 25, 25},
{"MAC_DMA_CFG", "PEER_ENTRY_SWAP"                            , 0x00020014, 24, 24},
{"MAC_DMA_CFG", "TX_MSDU_START_SWAP"                         , 0x00020014, 23, 23},
{"MAC_DMA_CFG", "TX_PPDU_START_SWAP"                         , 0x00020014, 22, 22},
{"MAC_DMA_CFG", "MARGIN_NUM_FRAME_DWORDS_IN_FLIGHT"          , 0x00020014, 21, 14},
{"MAC_DMA_CFG", "DISABLE_TXBUF_SPACE_AWARE_TXDMA"            , 0x00020014, 13, 13},
{"MAC_DMA_CFG", "HALT_ACK"                                   , 0x00020014, 12, 12},
{"MAC_DMA_CFG", "HALT_REQ"                                   , 0x00020014, 11, 11},
{"MAC_DMA_CFG", "CLKGATE_DIS"                                , 0x00020014, 10, 10},
{"MAC_DMA_CFG", "EEPROM_BUSY"                                , 0x00020014, 9 , 9 },
{"MAC_DMA_CFG", "PHY_OK"                                     , 0x00020014, 8 , 8 },
{"MAC_DMA_CFG", "ADHOC"                                      , 0x00020014, 5 , 5 },
{"MAC_DMA_CFG", "BE_MODE_MMR"                                , 0x00020014, 4 , 4 },
{"MAC_DMA_CFG", "RESET_INT_MIT_CNTRS"                        , 0x00020014, 3 , 3 },
{"MAC_DMA_CFG", "LEGACY_INT_MIT_MODE_ENABLE"                 , 0x00020014, 2 , 2 },
{"MAC_DMA_CFG", "REQ_Q_FULL_THRESHOLD"                       , 0x00020014, 1 , 0 },
{"MAC_DMA_TXDPPTR_THRESH", "DATA"                            , 0x0002001c, 3 , 0 },
{"MAC_DMA_GLOBAL_IER", "ENABLE"                              , 0x00020024, 0 , 0 },
{"MAC_DMA_TXCFG", "DISABLE_TXDMA_AXI_RESP_CH_TIMEOUT"        , 0x00020030, 31, 31},
{"MAC_DMA_TXCFG", "DISABLE_TXDMA_AXI_REQ_CH_TIMEOUT"         , 0x00020030, 30, 30},
{"MAC_DMA_TXCFG", "TXDMA_OLE_TIMEOUT_LIMIT"                  , 0x00020030, 29, 24},
{"MAC_DMA_TXCFG", "TXDMA_AXI_TIMEOUT_LIMIT"                  , 0x00020030, 23, 16},
{"MAC_DMA_TXCFG", "RTCI_DIS"                                 , 0x00020030, 14, 14},
{"MAC_DMA_TXCFG", "ATIM_DEFER_DIS"                           , 0x00020030, 12, 12},
{"MAC_DMA_TXCFG", "BCN_PAST_ATIM_DIS"                        , 0x00020030, 11, 11},
{"MAC_DMA_TXCFG", "JUMBO_EN"                                 , 0x00020030, 10, 10},
{"MAC_DMA_TXCFG", "TRIGLVL"                                  , 0x00020030, 9 , 4 },
{"MAC_DMA_TXCFG", "RTS_FAIL_EXCESSIVE_RETRIES"               , 0x00020030, 3 , 3 },
{"MAC_DMA_TXCFG", "DIS_CW_INC_QUIET_COLL"                    , 0x00020030, 2 , 2 },
{"MAC_DMA_TXCFG", "DIS_RETRY_UNDERRUN"                       , 0x00020030, 1 , 1 },
{"MAC_DMA_TXCFG", "MAX_BUF_DMA_BLOCKSIZE"                    , 0x00020030, 0 , 0 },
{"MAC_DMA_MIBC", "STROBE"                                    , 0x00020040, 3 , 3 },
{"MAC_DMA_MIBC", "CLEAR"                                     , 0x00020040, 2 , 2 },
{"MAC_DMA_MIBC", "FREEZE"                                    , 0x00020040, 1 , 1 },
{"MAC_DMA_MIBC", "WARNING"                                   , 0x00020040, 0 , 0 },
{"MAC_DMA_TOPS", "TIMEOUT"                                   , 0x00020044, 15, 0 },
{"MAC_DMA_RXNPTO", "TIMEOUT"                                 , 0x00020048, 9 , 0 },
{"MAC_DMA_TXNPTO", "MASK"                                    , 0x0002004c, 19, 10},
{"MAC_DMA_TXNPTO", "TIMEOUT"                                 , 0x0002004c, 9 , 0 },
{"MAC_DMA_RPGTO", "TIMEOUT"                                  , 0x00020050, 9 , 0 },
{"MAC_DMA_MACMISC", "TXERR_INT_FIX_DISABLE"                  , 0x00020058, 18, 18},
{"MAC_DMA_MACMISC", "MISC_F2_OBS_HIGH_MUXSEL"                , 0x00020058, 17, 15},
{"MAC_DMA_MACMISC", "MISC_F2_OBS_LOW_MUXSEL"                 , 0x00020058, 14, 12},
{"MAC_DMA_MACMISC", "MISC_OBS_MUXSEL"                        , 0x00020058, 11, 9 },
{"MAC_DMA_MACMISC", "DMA_OBS_MUXSEL"                         , 0x00020058, 8 , 5 },
{"MAC_DMA_MACMISC", "FORCE_PCI_EXT"                          , 0x00020058, 4 , 4 },
{"MAC_DMA_INTER", "MSI_TX_SRC"                               , 0x0002005c, 4 , 3 },
{"MAC_DMA_INTER", "MSI_RX_SRC"                               , 0x0002005c, 2 , 1 },
{"MAC_DMA_INTER", "REQ"                                      , 0x0002005c, 0 , 0 },
{"MAC_DMA_DATABUF", "LEN"                                    , 0x00020060, 11, 0 },
{"MAC_DMA_GTT", "LIMIT"                                      , 0x00020064, 31, 16},
{"MAC_DMA_GTT", "COUNT"                                      , 0x00020064, 15, 0 },
{"MAC_DMA_GTTM", "DISABLE_QCU_FR_ACTIVE_BT"                  , 0x00020068, 5 , 5 },
{"MAC_DMA_GTTM", "DISABLE_QCU_FR_ACTIVE_GTT"                 , 0x00020068, 4 , 4 },
{"MAC_DMA_GTTM", "CST_USEC_STROBE"                           , 0x00020068, 3 , 3 },
{"MAC_DMA_GTTM", "RESET_ON_CHAN_IDLE"                        , 0x00020068, 2 , 2 },
{"MAC_DMA_GTTM", "IGNORE_CHAN_IDLE"                          , 0x00020068, 1 , 1 },
{"MAC_DMA_GTTM", "USEC_STROBE"                               , 0x00020068, 0 , 0 },
{"MAC_DMA_CST", "LIMIT"                                      , 0x0002006c, 31, 16},
{"MAC_DMA_CST", "COUNT"                                      , 0x0002006c, 15, 0 },
{"MAC_DMA_RXDP_SIZE", "HP"                                   , 0x00020070, 12, 8 },
{"MAC_DMA_RXDP_SIZE", "LP"                                   , 0x00020070, 7 , 0 },
{"MAC_DMA_RX_QUEUE_HP_RXDP", "ADDR"                          , 0x00020074, 31, 0 },
{"MAC_DMA_RX_QUEUE_LP_RXDP", "ADDR"                          , 0x00020078, 31, 0 },
{"MAC_DMA_ISR_P", "BIT_31"                                   , 0x00020080, 31, 31},
{"MAC_DMA_ISR_P", "BIT_30"                                   , 0x00020080, 30, 30},
{"MAC_DMA_ISR_P", "BIT_29"                                   , 0x00020080, 29, 29},
{"MAC_DMA_ISR_P", "GENTMR"                                   , 0x00020080, 28, 28},
{"MAC_DMA_ISR_P", "QTRIG"                                    , 0x00020080, 27, 27},
{"MAC_DMA_ISR_P", "QCBRURN"                                  , 0x00020080, 26, 26},
{"MAC_DMA_ISR_P", "QCBROVF"                                  , 0x00020080, 25, 25},
{"MAC_DMA_ISR_P", "BB_INT"                                   , 0x00020080, 24, 24},
{"MAC_DMA_ISR_P", "BCNMISC"                                  , 0x00020080, 23, 23},
{"MAC_DMA_ISR_P", "OLE_INT"                                  , 0x00020080, 22, 22},
{"MAC_DMA_ISR_P", "RXINT"                                    , 0x00020080, 21, 21},
{"MAC_DMA_ISR_P", "BNR"                                      , 0x00020080, 20, 20},
{"MAC_DMA_ISR_P", "BIT_19"                                   , 0x00020080, 19, 19},
{"MAC_DMA_ISR_P", "BMISS"                                    , 0x00020080, 18, 18},
{"MAC_DMA_ISR_P", "BRSSI"                                    , 0x00020080, 17, 17},
{"MAC_DMA_ISR_P", "SWBA"                                     , 0x00020080, 16, 16},
{"MAC_DMA_ISR_P", "BIT_15"                                   , 0x00020080, 15, 15},
{"MAC_DMA_ISR_P", "BIT_14"                                   , 0x00020080, 14, 14},
{"MAC_DMA_ISR_P", "SWI"                                      , 0x00020080, 13, 13},
{"MAC_DMA_ISR_P", "MIB"                                      , 0x00020080, 12, 12},
{"MAC_DMA_ISR_P", "TXURN"                                    , 0x00020080, 11, 11},
{"MAC_DMA_ISR_P", "TXEOL"                                    , 0x00020080, 10, 10},
{"MAC_DMA_ISR_P", "TXNOFR"                                   , 0x00020080, 9 , 9 },
{"MAC_DMA_ISR_P", "TXERR"                                    , 0x00020080, 8 , 8 },
{"MAC_DMA_ISR_P", "BTINT"                                    , 0x00020080, 7 , 7 },
{"MAC_DMA_ISR_P", "TX_DMA_ERR"                               , 0x00020080, 6 , 6 },
{"MAC_DMA_ISR_P", "RXORN"                                    , 0x00020080, 5 , 5 },
{"MAC_DMA_ISR_P", "BIT_4"                                    , 0x00020080, 4 , 4 },
{"MAC_DMA_ISR_P", "BIT_3"                                    , 0x00020080, 3 , 3 },
{"MAC_DMA_ISR_P", "BIT_2"                                    , 0x00020080, 2 , 2 },
{"MAC_DMA_ISR_P", "RX_DMA_ERR"                               , 0x00020080, 1 , 1 },
{"MAC_DMA_ISR_P", "RX_DMA_RING_LWM"                          , 0x00020080, 0 , 0 },
{"MAC_DMA_TXRX_ISR", "RXOK_HP"                               , 0x00020084, 13, 13},
{"MAC_DMA_TXRX_ISR", "RXOK_PPDU"                             , 0x00020084, 12, 12},
{"MAC_DMA_TXRX_ISR", "RXOK_MPDU"                             , 0x00020084, 11, 11},
{"MAC_DMA_TXRX_ISR", "RXOK_MSDU"                             , 0x00020084, 10, 10},
{"MAC_DMA_TXRX_ISR", "TXOK_QCU9"                             , 0x00020084, 9 , 9 },
{"MAC_DMA_TXRX_ISR", "TXOK_QCU8"                             , 0x00020084, 8 , 8 },
{"MAC_DMA_TXRX_ISR", "TXOK_QCU7"                             , 0x00020084, 7 , 7 },
{"MAC_DMA_TXRX_ISR", "TXOK_QCU6"                             , 0x00020084, 6 , 6 },
{"MAC_DMA_TXRX_ISR", "TXOK_QCU5"                             , 0x00020084, 5 , 5 },
{"MAC_DMA_TXRX_ISR", "TXOK_QCU4"                             , 0x00020084, 4 , 4 },
{"MAC_DMA_TXRX_ISR", "TXOK_QCU3"                             , 0x00020084, 3 , 3 },
{"MAC_DMA_TXRX_ISR", "TXOK_QCU2"                             , 0x00020084, 2 , 2 },
{"MAC_DMA_TXRX_ISR", "TXOK_QCU1"                             , 0x00020084, 1 , 1 },
{"MAC_DMA_TXRX_ISR", "TXOK_QCU0"                             , 0x00020084, 0 , 0 },
{"MAC_DMA_ISR_S1", "RSVD_2"                                  , 0x00020088, 31, 26},
{"MAC_DMA_ISR_S1", "TXEOL"                                   , 0x00020088, 25, 16},
{"MAC_DMA_ISR_S1", "RSVD_1"                                  , 0x00020088, 15, 10},
{"MAC_DMA_ISR_S1", "TXERR"                                   , 0x00020088, 9 , 0 },
{"MAC_DMA_ISR_S2", "RSVD"                                    , 0x0002008c, 31, 31},
{"MAC_DMA_ISR_S2", "TBTT_TIME_STA_0"                         , 0x0002008c, 30, 30},
{"MAC_DMA_ISR_S2", "TSFOOR_STA_0"                            , 0x0002008c, 29, 29},
{"MAC_DMA_ISR_S2", "DTIM_STA_0"                              , 0x0002008c, 28, 28},
{"MAC_DMA_ISR_S2", "CABTO_STA_0"                             , 0x0002008c, 27, 27},
{"MAC_DMA_ISR_S2", "BCNTO_STA_0"                             , 0x0002008c, 26, 26},
{"MAC_DMA_ISR_S2", "DTIMSYNC_STA_0"                          , 0x0002008c, 25, 25},
{"MAC_DMA_ISR_S2", "CABEND_STA_0"                            , 0x0002008c, 24, 24},
{"MAC_DMA_ISR_S2", "TIM_STA_0"                               , 0x0002008c, 23, 23},
{"MAC_DMA_ISR_S2", "GTT"                                     , 0x0002008c, 22, 22},
{"MAC_DMA_ISR_S2", "CST"                                     , 0x0002008c, 21, 21},
{"MAC_DMA_ISR_S2", "TBTT_TIME_STA_1"                         , 0x0002008c, 20, 20},
{"MAC_DMA_ISR_S2", "TSFOOR_STA_1"                            , 0x0002008c, 19, 19},
{"MAC_DMA_ISR_S2", "DTIM_STA_1"                              , 0x0002008c, 18, 18},
{"MAC_DMA_ISR_S2", "CABTO_STA_1"                             , 0x0002008c, 17, 17},
{"MAC_DMA_ISR_S2", "BCNTO_STA_1"                             , 0x0002008c, 16, 16},
{"MAC_DMA_ISR_S2", "DTIMSYNC_STA_1"                          , 0x0002008c, 15, 15},
{"MAC_DMA_ISR_S2", "CABEND_STA_1"                            , 0x0002008c, 14, 14},
{"MAC_DMA_ISR_S2", "TIM_STA_1"                               , 0x0002008c, 13, 13},
{"MAC_DMA_ISR_S2", "PCU_RX_PTR_BAD"                          , 0x0002008c, 12, 12},
{"MAC_DMA_ISR_S2", "TDMA_APSYNC"                             , 0x0002008c, 11, 11},
{"MAC_DMA_ISR_S2", "TDMA_START_TIME_ERROR"                   , 0x0002008c, 10, 10},
{"MAC_DMA_ISR_S2", "TXURN"                                   , 0x0002008c, 9 , 0 },
{"MAC_DMA_ISR_S3", "BMISS_STA_1"                             , 0x00020090, 31, 31},
{"MAC_DMA_ISR_S3", "BMISS_STA_0"                             , 0x00020090, 30, 30},
{"MAC_DMA_ISR_S3", "PCU_RSSI_LOW_STA_1"                      , 0x00020090, 29, 29},
{"MAC_DMA_ISR_S3", "PCU_RSSI_HIGH_STA_1"                     , 0x00020090, 28, 28},
{"MAC_DMA_ISR_S3", "PCU_RSSI_LOW_STA_0"                      , 0x00020090, 27, 27},
{"MAC_DMA_ISR_S3", "PCU_RSSI_HIGH_STA_0"                     , 0x00020090, 26, 26},
{"MAC_DMA_ISR_S3", "QCBRURN"                                 , 0x00020090, 25, 16},
{"MAC_DMA_ISR_S3", "RXDMA_HP_DP_OVF"                         , 0x00020090, 15, 15},
{"MAC_DMA_ISR_S3", "RXDMA_LP_DP_OVF"                         , 0x00020090, 14, 14},
{"MAC_DMA_ISR_S3", "RSVD"                                    , 0x00020090, 13, 10},
{"MAC_DMA_ISR_S3", "QCBROVF"                                 , 0x00020090, 9 , 0 },
{"MAC_DMA_ISR_S4", "RSVD_2"                                  , 0x00020094, 31, 26},
{"MAC_DMA_ISR_S4", "TXDP_FIFO_OVF"                           , 0x00020094, 25, 16},
{"MAC_DMA_ISR_S4", "RSVD_1"                                  , 0x00020094, 15, 10},
{"MAC_DMA_ISR_S4", "QTRIG"                                   , 0x00020094, 9 , 0 },
{"MAC_DMA_ISR_S5", "GENERIC_TIMER_THRESH"                    , 0x00020098, 31, 17},
{"MAC_DMA_ISR_S5", "GENERIC_TIMER_OVF"                       , 0x00020098, 16, 16},
{"MAC_DMA_ISR_S5", "GENERIC_TIMER_TRIGGER"                   , 0x00020098, 15, 0 },
{"MAC_DMA_ISR_S6", "RSVD"                                    , 0x0002009c, 31, 25},
{"MAC_DMA_ISR_S6", "TX_DMA_ERR_OLE_RDY_TIMEOUT"              , 0x0002009c, 24, 24},
{"MAC_DMA_ISR_S6", "TX_DMA_ERR_AXI_TIMEOUT"                  , 0x0002009c, 23, 23},
{"MAC_DMA_ISR_S6", "TX_CONFIG_PHY_ERR"                       , 0x0002009c, 22, 22},
{"MAC_DMA_ISR_S6", "TX_DMA_ERR_UNEXPECTED_NULL"              , 0x0002009c, 21, 21},
{"MAC_DMA_ISR_S6", "RX_DMA_ERR_NONPKT_TLV_PAST_BUF_END"      , 0x0002009c, 20, 20},
{"MAC_DMA_ISR_S6", "RX_DMA_RING_LWM"                         , 0x0002009c, 19, 16},
{"MAC_DMA_ISR_S6", "RX_DMA_ERR_MULTI_DATA_TLVS"              , 0x0002009c, 15, 15},
{"MAC_DMA_ISR_S6", "RX_DMA_ERR_NULL_RING_MASK"               , 0x0002009c, 14, 14},
{"MAC_DMA_ISR_S6", "RX_DMA_ERR_INVALID_TAG_ID"               , 0x0002009c, 13, 13},
{"MAC_DMA_ISR_S6", "RX_DMA_ERR_INVALID_TAG_SIG"              , 0x0002009c, 12, 12},
{"MAC_DMA_ISR_S6", "RX_DMA_ERR_TLV_TOO_SHORT"                , 0x0002009c, 11, 11},
{"MAC_DMA_ISR_S6", "RX_DMA_ERR_TLV_FRAMING"                  , 0x0002009c, 10, 10},
{"MAC_DMA_ISR_S6", "BT_PRIORITY_FALLING"                     , 0x0002009c, 9 , 9 },
{"MAC_DMA_ISR_S6", "BT_PRIORITY_RISING"                      , 0x0002009c, 8 , 8 },
{"MAC_DMA_ISR_S6", "BT_ACTIVE_FALLING"                       , 0x0002009c, 7 , 7 },
{"MAC_DMA_ISR_S6", "BT_ACTIVE_RISING"                        , 0x0002009c, 6 , 6 },
{"MAC_DMA_ISR_S6", "WL_STOMPED"                              , 0x0002009c, 5 , 5 },
{"MAC_DMA_ISR_S6", "BT_STOMPED"                              , 0x0002009c, 4 , 4 },
{"MAC_DMA_ISR_S6", "BT_LOW_PRIORITY_FALLING"                 , 0x0002009c, 3 , 3 },
{"MAC_DMA_ISR_S6", "BT_LOW_PRIORITY_RISING"                  , 0x0002009c, 2 , 2 },
{"MAC_DMA_ISR_S6", "BB_PANIC_IRQ"                            , 0x0002009c, 1 , 1 },
{"MAC_DMA_ISR_S6", "BB_MAC_TEMP_SENSOR"                      , 0x0002009c, 0 , 0 },
{"MAC_DMA_IMR_P", "BIT_31"                                   , 0x000200a0, 31, 31},
{"MAC_DMA_IMR_P", "BIT_30"                                   , 0x000200a0, 30, 30},
{"MAC_DMA_IMR_P", "BIT_29"                                   , 0x000200a0, 29, 29},
{"MAC_DMA_IMR_P", "GENTMR"                                   , 0x000200a0, 28, 28},
{"MAC_DMA_IMR_P", "QTRIG"                                    , 0x000200a0, 27, 27},
{"MAC_DMA_IMR_P", "QCBRURN"                                  , 0x000200a0, 26, 26},
{"MAC_DMA_IMR_P", "QCBROVF"                                  , 0x000200a0, 25, 25},
{"MAC_DMA_IMR_P", "BB_INT"                                   , 0x000200a0, 24, 24},
{"MAC_DMA_IMR_P", "BCNMISC"                                  , 0x000200a0, 23, 23},
{"MAC_DMA_IMR_P", "OLE_INT"                                  , 0x000200a0, 22, 22},
{"MAC_DMA_IMR_P", "RXINT"                                    , 0x000200a0, 21, 21},
{"MAC_DMA_IMR_P", "BNR"                                      , 0x000200a0, 20, 20},
{"MAC_DMA_IMR_P", "BIT_19"                                   , 0x000200a0, 19, 19},
{"MAC_DMA_IMR_P", "BMISS"                                    , 0x000200a0, 18, 18},
{"MAC_DMA_IMR_P", "BRSSI"                                    , 0x000200a0, 17, 17},
{"MAC_DMA_IMR_P", "SWBA"                                     , 0x000200a0, 16, 16},
{"MAC_DMA_IMR_P", "BIT_15"                                   , 0x000200a0, 15, 15},
{"MAC_DMA_IMR_P", "BIT_14"                                   , 0x000200a0, 14, 14},
{"MAC_DMA_IMR_P", "SWI"                                      , 0x000200a0, 13, 13},
{"MAC_DMA_IMR_P", "MIB"                                      , 0x000200a0, 12, 12},
{"MAC_DMA_IMR_P", "TXURN"                                    , 0x000200a0, 11, 11},
{"MAC_DMA_IMR_P", "TXEOL"                                    , 0x000200a0, 10, 10},
{"MAC_DMA_IMR_P", "TXNOFR"                                   , 0x000200a0, 9 , 9 },
{"MAC_DMA_IMR_P", "TXERR"                                    , 0x000200a0, 8 , 8 },
{"MAC_DMA_IMR_P", "BTINT"                                    , 0x000200a0, 7 , 7 },
{"MAC_DMA_IMR_P", "TX_DMA_ERR"                               , 0x000200a0, 6 , 6 },
{"MAC_DMA_IMR_P", "RXORN"                                    , 0x000200a0, 5 , 5 },
{"MAC_DMA_IMR_P", "BIT_4"                                    , 0x000200a0, 4 , 4 },
{"MAC_DMA_IMR_P", "BIT_3"                                    , 0x000200a0, 3 , 3 },
{"MAC_DMA_IMR_P", "BIT_2"                                    , 0x000200a0, 2 , 2 },
{"MAC_DMA_IMR_P", "RX_DMA_ERR"                               , 0x000200a0, 1 , 1 },
{"MAC_DMA_IMR_P", "RX_DMA_RING_LWM"                          , 0x000200a0, 0 , 0 },
{"MAC_DMA_TXRX_IMR", "RXOK_HP"                               , 0x000200a4, 13, 13},
{"MAC_DMA_TXRX_IMR", "RXOK_PPDU"                             , 0x000200a4, 12, 12},
{"MAC_DMA_TXRX_IMR", "RXOK_MPDU"                             , 0x000200a4, 11, 11},
{"MAC_DMA_TXRX_IMR", "RXOK_MSDU"                             , 0x000200a4, 10, 10},
{"MAC_DMA_TXRX_IMR", "TXOK"                                  , 0x000200a4, 9 , 0 },
{"MAC_DMA_IMR_S1", "RSVD_2"                                  , 0x000200a8, 31, 26},
{"MAC_DMA_IMR_S1", "TXEOL"                                   , 0x000200a8, 25, 16},
{"MAC_DMA_IMR_S1", "RSVD_1"                                  , 0x000200a8, 15, 10},
{"MAC_DMA_IMR_S1", "TXERR"                                   , 0x000200a8, 9 , 0 },
{"MAC_DMA_IMR_S2", "RSVD"                                    , 0x000200ac, 31, 31},
{"MAC_DMA_IMR_S2", "TBTT_TIME_STA_0"                         , 0x000200ac, 30, 30},
{"MAC_DMA_IMR_S2", "TSFOOR_STA_0"                            , 0x000200ac, 29, 29},
{"MAC_DMA_IMR_S2", "DTIM_STA_0"                              , 0x000200ac, 28, 28},
{"MAC_DMA_IMR_S2", "CABTO_STA_0"                             , 0x000200ac, 27, 27},
{"MAC_DMA_IMR_S2", "BCNTO_STA_0"                             , 0x000200ac, 26, 26},
{"MAC_DMA_IMR_S2", "DTIMSYNC_STA_0"                          , 0x000200ac, 25, 25},
{"MAC_DMA_IMR_S2", "CABEND_STA_0"                            , 0x000200ac, 24, 24},
{"MAC_DMA_IMR_S2", "TIM_STA_0"                               , 0x000200ac, 23, 23},
{"MAC_DMA_IMR_S2", "GTT"                                     , 0x000200ac, 22, 22},
{"MAC_DMA_IMR_S2", "CST"                                     , 0x000200ac, 21, 21},
{"MAC_DMA_IMR_S2", "TBTT_TIME_STA_1"                         , 0x000200ac, 20, 20},
{"MAC_DMA_IMR_S2", "TSFOOR_STA_1"                            , 0x000200ac, 19, 19},
{"MAC_DMA_IMR_S2", "DTIM_STA_1"                              , 0x000200ac, 18, 18},
{"MAC_DMA_IMR_S2", "CABTO_STA_1"                             , 0x000200ac, 17, 17},
{"MAC_DMA_IMR_S2", "BCNTO_STA_1"                             , 0x000200ac, 16, 16},
{"MAC_DMA_IMR_S2", "DTIMSYNC_STA_1"                          , 0x000200ac, 15, 15},
{"MAC_DMA_IMR_S2", "CABEND_STA_1"                            , 0x000200ac, 14, 14},
{"MAC_DMA_IMR_S2", "TIM_STA_1"                               , 0x000200ac, 13, 13},
{"MAC_DMA_IMR_S2", "PCU_RX_PTR_BAD"                          , 0x000200ac, 12, 12},
{"MAC_DMA_IMR_S2", "TDMA_APSYNC"                             , 0x000200ac, 11, 11},
{"MAC_DMA_IMR_S2", "TDMA_START_TIME_ERROR"                   , 0x000200ac, 10, 10},
{"MAC_DMA_IMR_S2", "TXURN"                                   , 0x000200ac, 9 , 0 },
{"MAC_DMA_IMR_S3", "BMISS_STA_1"                             , 0x000200b0, 31, 31},
{"MAC_DMA_IMR_S3", "BMISS_STA_0"                             , 0x000200b0, 30, 30},
{"MAC_DMA_IMR_S3", "PCU_RSSI_LOW_STA_1"                      , 0x000200b0, 29, 29},
{"MAC_DMA_IMR_S3", "PCU_RSSI_HIGH_STA_1"                     , 0x000200b0, 28, 28},
{"MAC_DMA_IMR_S3", "PCU_RSSI_LOW_STA_0"                      , 0x000200b0, 27, 27},
{"MAC_DMA_IMR_S3", "PCU_RSSI_HIGH_STA_0"                     , 0x000200b0, 26, 26},
{"MAC_DMA_IMR_S3", "QCBRURN"                                 , 0x000200b0, 25, 16},
{"MAC_DMA_IMR_S3", "RXDMA_HP_DP_OVF"                         , 0x000200b0, 15, 15},
{"MAC_DMA_IMR_S3", "RXDMA_LP_DP_OVF"                         , 0x000200b0, 14, 14},
{"MAC_DMA_IMR_S3", "RSVD"                                    , 0x000200b0, 13, 10},
{"MAC_DMA_IMR_S3", "QCBROVF"                                 , 0x000200b0, 9 , 0 },
{"MAC_DMA_IMR_S4", "RSVD_2"                                  , 0x000200b4, 31, 26},
{"MAC_DMA_IMR_S4", "TXDP_FIFO_OVF"                           , 0x000200b4, 25, 16},
{"MAC_DMA_IMR_S4", "RSVD_1"                                  , 0x000200b4, 15, 10},
{"MAC_DMA_IMR_S4", "QTRIG"                                   , 0x000200b4, 9 , 0 },
{"MAC_DMA_IMR_S5", "GENERIC_TIMER_THRESH"                    , 0x000200b8, 31, 17},
{"MAC_DMA_IMR_S5", "GENERIC_TIMER_OVF"                       , 0x000200b8, 16, 16},
{"MAC_DMA_IMR_S5", "GENERIC_TIMER_TRIGGER"                   , 0x000200b8, 15, 0 },
{"MAC_DMA_IMR_S6", "RSVD"                                    , 0x000200bc, 31, 23},
{"MAC_DMA_IMR_S6", "TX_CONFIG_PHY_ERR"                       , 0x000200bc, 22, 22},
{"MAC_DMA_IMR_S6", "TX_DMA_ERR_UNEXPECTED_NULL"              , 0x000200bc, 21, 21},
{"MAC_DMA_IMR_S6", "RX_DMA_ERR_NONPKT_TLV_PAST_BUF_END"      , 0x000200bc, 20, 20},
{"MAC_DMA_IMR_S6", "RX_DMA_RING_LWM"                         , 0x000200bc, 19, 16},
{"MAC_DMA_IMR_S6", "RX_DMA_ERR_MULTI_DATA_TLVS"              , 0x000200bc, 15, 15},
{"MAC_DMA_IMR_S6", "RX_DMA_ERR_NULL_RING_MASK"               , 0x000200bc, 14, 14},
{"MAC_DMA_IMR_S6", "RX_DMA_ERR_INVALID_TAG_ID"               , 0x000200bc, 13, 13},
{"MAC_DMA_IMR_S6", "RX_DMA_ERR_INVALID_TAG_SIG"              , 0x000200bc, 12, 12},
{"MAC_DMA_IMR_S6", "RX_DMA_ERR_TLV_TOO_SHORT"                , 0x000200bc, 11, 11},
{"MAC_DMA_IMR_S6", "RX_DMA_ERR_TLV_FRAMING"                  , 0x000200bc, 10, 10},
{"MAC_DMA_IMR_S6", "BT_PRIORITY_FALLING"                     , 0x000200bc, 9 , 9 },
{"MAC_DMA_IMR_S6", "BT_PRIORITY_RISING"                      , 0x000200bc, 8 , 8 },
{"MAC_DMA_IMR_S6", "BT_ACTIVE_FALLING"                       , 0x000200bc, 7 , 7 },
{"MAC_DMA_IMR_S6", "BT_ACTIVE_RISING"                        , 0x000200bc, 6 , 6 },
{"MAC_DMA_IMR_S6", "WL_STOMPED"                              , 0x000200bc, 5 , 5 },
{"MAC_DMA_IMR_S6", "BT_STOMPED"                              , 0x000200bc, 4 , 4 },
{"MAC_DMA_IMR_S6", "BT_LOW_PRIORITY_FALLING"                 , 0x000200bc, 3 , 3 },
{"MAC_DMA_IMR_S6", "BT_LOW_PRIORITY_RISING"                  , 0x000200bc, 2 , 2 },
{"MAC_DMA_IMR_S6", "BB_PANIC_IRQ"                            , 0x000200bc, 1 , 1 },
{"MAC_DMA_IMR_S6", "BB_MAC_TEMP_SENSOR"                      , 0x000200bc, 0 , 0 },
{"MAC_DMA_ISR_P_RAC", "DATA"                                 , 0x000200c0, 31, 0 },
{"MAC_DMA_ISR_S1_S", "RSVD_2"                                , 0x000200c8, 31, 26},
{"MAC_DMA_ISR_S1_S", "TXEOL"                                 , 0x000200c8, 25, 16},
{"MAC_DMA_ISR_S1_S", "RSVD_1"                                , 0x000200c8, 15, 10},
{"MAC_DMA_ISR_S1_S", "TXERR"                                 , 0x000200c8, 9 , 0 },
{"MAC_DMA_ISR_S6_S", "RSVD"                                  , 0x000200cc, 31, 25},
{"MAC_DMA_ISR_S6_S", "TX_DMA_ERR_OLE_RDY_TIMEOUT"            , 0x000200cc, 24, 24},
{"MAC_DMA_ISR_S6_S", "TX_DMA_ERR_AXI_TIMEOUT"                , 0x000200cc, 23, 23},
{"MAC_DMA_ISR_S6_S", "TX_CONFIG_PHY_ERR"                     , 0x000200cc, 22, 22},
{"MAC_DMA_ISR_S6_S", "TX_DMA_ERR_UNEXPECTED_NULL"            , 0x000200cc, 21, 21},
{"MAC_DMA_ISR_S6_S", "RX_DMA_ERR_NONPKT_TLV_PAST_BUF_END"    , 0x000200cc, 20, 20},
{"MAC_DMA_ISR_S6_S", "RX_DMA_RING_LWM"                       , 0x000200cc, 19, 16},
{"MAC_DMA_ISR_S6_S", "RX_DMA_ERR_MULTI_DATA_TLVS"            , 0x000200cc, 15, 15},
{"MAC_DMA_ISR_S6_S", "RX_DMA_ERR_NULL_RING_MASK"             , 0x000200cc, 14, 14},
{"MAC_DMA_ISR_S6_S", "RX_DMA_ERR_INVALID_TAG_ID"             , 0x000200cc, 13, 13},
{"MAC_DMA_ISR_S6_S", "RX_DMA_ERR_INVALID_TAG_SIG"            , 0x000200cc, 12, 12},
{"MAC_DMA_ISR_S6_S", "RX_DMA_ERR_TLV_TOO_SHORT"              , 0x000200cc, 11, 11},
{"MAC_DMA_ISR_S6_S", "RX_DMA_ERR_TLV_FRAMING"                , 0x000200cc, 10, 10},
{"MAC_DMA_ISR_S6_S", "BT_PRIORITY_FALLING"                   , 0x000200cc, 9 , 9 },
{"MAC_DMA_ISR_S6_S", "BT_PRIORITY_RISING"                    , 0x000200cc, 8 , 8 },
{"MAC_DMA_ISR_S6_S", "BT_ACTIVE_FALLING"                     , 0x000200cc, 7 , 7 },
{"MAC_DMA_ISR_S6_S", "BT_ACTIVE_RISING"                      , 0x000200cc, 6 , 6 },
{"MAC_DMA_ISR_S6_S", "WL_STOMPED"                            , 0x000200cc, 5 , 5 },
{"MAC_DMA_ISR_S6_S", "BT_STOMPED"                            , 0x000200cc, 4 , 4 },
{"MAC_DMA_ISR_S6_S", "BT_LOW_PRIORITY_FALLING"               , 0x000200cc, 3 , 3 },
{"MAC_DMA_ISR_S6_S", "BT_LOW_PRIORITY_RISING"                , 0x000200cc, 2 , 2 },
{"MAC_DMA_ISR_S6_S", "BB_PANIC_IRQ"                          , 0x000200cc, 1 , 1 },
{"MAC_DMA_ISR_S6_S", "BB_MAC_TEMP_SENSOR"                    , 0x000200cc, 0 , 0 },
{"MAC_DMA_ISR_S2_S", "RSVD"                                  , 0x000200d0, 31, 31},
{"MAC_DMA_ISR_S2_S", "TBTT_TIME_STA_0"                       , 0x000200d0, 30, 30},
{"MAC_DMA_ISR_S2_S", "TSFOOR_STA_0"                          , 0x000200d0, 29, 29},
{"MAC_DMA_ISR_S2_S", "DTIM_STA_0"                            , 0x000200d0, 28, 28},
{"MAC_DMA_ISR_S2_S", "CABTO_STA_0"                           , 0x000200d0, 27, 27},
{"MAC_DMA_ISR_S2_S", "BCNTO_STA_0"                           , 0x000200d0, 26, 26},
{"MAC_DMA_ISR_S2_S", "DTIMSYNC_STA_0"                        , 0x000200d0, 25, 25},
{"MAC_DMA_ISR_S2_S", "CABEND_STA_0"                          , 0x000200d0, 24, 24},
{"MAC_DMA_ISR_S2_S", "TIM_STA_0"                             , 0x000200d0, 23, 23},
{"MAC_DMA_ISR_S2_S", "GTT"                                   , 0x000200d0, 22, 22},
{"MAC_DMA_ISR_S2_S", "CST"                                   , 0x000200d0, 21, 21},
{"MAC_DMA_ISR_S2_S", "TBTT_TIME_STA_1"                       , 0x000200d0, 20, 20},
{"MAC_DMA_ISR_S2_S", "TSFOOR_STA_1"                          , 0x000200d0, 19, 19},
{"MAC_DMA_ISR_S2_S", "DTIM_STA_1"                            , 0x000200d0, 18, 18},
{"MAC_DMA_ISR_S2_S", "CABTO_STA_1"                           , 0x000200d0, 17, 17},
{"MAC_DMA_ISR_S2_S", "BCNTO_STA_1"                           , 0x000200d0, 16, 16},
{"MAC_DMA_ISR_S2_S", "DTIMSYNC_STA_1"                        , 0x000200d0, 15, 15},
{"MAC_DMA_ISR_S2_S", "CABEND_STA_1"                          , 0x000200d0, 14, 14},
{"MAC_DMA_ISR_S2_S", "TIM_STA_1"                             , 0x000200d0, 13, 13},
{"MAC_DMA_ISR_S2_S", "PCU_RX_PTR_BAD"                        , 0x000200d0, 12, 12},
{"MAC_DMA_ISR_S2_S", "TDMA_APSYNC"                           , 0x000200d0, 11, 11},
{"MAC_DMA_ISR_S2_S", "TDMA_START_TIME_ERROR"                 , 0x000200d0, 10, 10},
{"MAC_DMA_ISR_S2_S", "TXURN"                                 , 0x000200d0, 9 , 0 },
{"MAC_DMA_ISR_S3_S", "BMISS_STA_1"                           , 0x000200d4, 31, 31},
{"MAC_DMA_ISR_S3_S", "BMISS_STA_0"                           , 0x000200d4, 30, 30},
{"MAC_DMA_ISR_S3_S", "PCU_RSSI_LOW_STA_1"                    , 0x000200d4, 29, 29},
{"MAC_DMA_ISR_S3_S", "PCU_RSSI_HIGH_STA_1"                   , 0x000200d4, 28, 28},
{"MAC_DMA_ISR_S3_S", "PCU_RSSI_LOW_STA_0"                    , 0x000200d4, 27, 27},
{"MAC_DMA_ISR_S3_S", "PCU_RSSI_HIGH_STA_0"                   , 0x000200d4, 26, 26},
{"MAC_DMA_ISR_S3_S", "QCBRURN"                               , 0x000200d4, 25, 16},
{"MAC_DMA_ISR_S3_S", "RXDMA_HP_DP_OVF"                       , 0x000200d4, 15, 15},
{"MAC_DMA_ISR_S3_S", "RXDMA_LP_DP_OVF"                       , 0x000200d4, 14, 14},
{"MAC_DMA_ISR_S3_S", "RSVD"                                  , 0x000200d4, 13, 10},
{"MAC_DMA_ISR_S3_S", "QCBROVF"                               , 0x000200d4, 9 , 0 },
{"MAC_DMA_ISR_S4_S", "RSVD_2"                                , 0x000200d8, 31, 26},
{"MAC_DMA_ISR_S4_S", "TXDP_FIFO_OVF"                         , 0x000200d8, 25, 16},
{"MAC_DMA_ISR_S4_S", "RSVD_1"                                , 0x000200d8, 15, 10},
{"MAC_DMA_ISR_S4_S", "QTRIG"                                 , 0x000200d8, 9 , 0 },
{"MAC_DMA_ISR_S5_S", "GENERIC_TIMER_THRESH"                  , 0x000200dc, 31, 17},
{"MAC_DMA_ISR_S5_S", "GENERIC_TIMER_OVF"                     , 0x000200dc, 16, 16},
{"MAC_DMA_ISR_S5_S", "GENERIC_TIMER_TRIGGER"                 , 0x000200dc, 15, 0 },
{"MAC_DMA_DMADBG_0", "DATA"                                  , 0x000200e0, 31, 0 },
{"MAC_DMA_DMADBG_1", "DATA"                                  , 0x000200e4, 31, 0 },
{"MAC_DMA_DMADBG_2", "DATA"                                  , 0x000200e8, 31, 0 },
{"MAC_DMA_DMADBG_3", "DATA"                                  , 0x000200ec, 31, 0 },
{"MAC_DMA_DMADBG_4", "DATA"                                  , 0x000200f0, 31, 0 },
{"MAC_DMA_DMADBG_5", "DATA"                                  , 0x000200f4, 31, 0 },
{"MAC_DMA_DMADBG_6", "DATA"                                  , 0x000200f8, 31, 0 },
{"MAC_DMA_DMADBG_7", "DATA"                                  , 0x000200fc, 31, 0 },
{"MAC_DMA_QCU_TXDP_REMAINING_QCU_7_0", "DATA"                , 0x00020100, 31, 0 },
{"MAC_DMA_QCU_TXDP_REMAINING_QCU_9_8", "DATA"                , 0x00020104, 7 , 0 },
{"MAC_DMA_ISR_S7", "RESERVED_1"                              , 0x00020108, 31, 20},
{"MAC_DMA_ISR_S7", "OLE_RX_WMAC_PARSER_ERR"                  , 0x00020108, 19, 19},
{"MAC_DMA_ISR_S7", "OLE_RX_ETH_PARSER_ERR"                   , 0x00020108, 18, 18},
{"MAC_DMA_ISR_S7", "OLE_RX_MPDU_PKT_ABORT"                   , 0x00020108, 17, 17},
{"MAC_DMA_ISR_S7", "OLE_RX_MSDU_LEN_ERR"                     , 0x00020108, 16, 16},
{"MAC_DMA_ISR_S7", "RESERVED_0"                              , 0x00020108, 15, 9 },
{"MAC_DMA_ISR_S7", "OLE_TX_ILLEGAL_FRAME"                    , 0x00020108, 8 , 8 },
{"MAC_DMA_ISR_S7", "OLE_TX_UNKNOWN_LLC"                      , 0x00020108, 7 , 7 },
{"MAC_DMA_ISR_S7", "OLE_TX_INCOMPLETE_VLAN_LLC"              , 0x00020108, 6 , 6 },
{"MAC_DMA_ISR_S7", "OLE_TX_UNKNOWN_TYPE_ERR"                 , 0x00020108, 5 , 5 },
{"MAC_DMA_ISR_S7", "OLE_TX_SEQ_NUM_BITMAP_ERR"               , 0x00020108, 4 , 4 },
{"MAC_DMA_ISR_S7", "OLE_TX_PN_BITMAP_ERR"                    , 0x00020108, 3 , 3 },
{"MAC_DMA_ISR_S7", "OLE_TX_AMSDU_FRAME_ERR"                  , 0x00020108, 2 , 2 },
{"MAC_DMA_ISR_S7", "OLE_TX_WEP_KTYPE_ERR"                    , 0x00020108, 1 , 1 },
{"MAC_DMA_ISR_S7", "DMA_OLE_TX_ABORT"                        , 0x00020108, 0 , 0 },
{"MAC_DMA_IMR_S7", "RESERVED_1"                              , 0x0002010c, 31, 20},
{"MAC_DMA_IMR_S7", "OLE_RX_WMAC_PARSER_ERR"                  , 0x0002010c, 19, 19},
{"MAC_DMA_IMR_S7", "OLE_RX_ETH_PARSER_ERR"                   , 0x0002010c, 18, 18},
{"MAC_DMA_IMR_S7", "OLE_RX_MPDU_PKT_ABORT"                   , 0x0002010c, 17, 17},
{"MAC_DMA_IMR_S7", "OLE_RX_MSDU_LEN_ERR"                     , 0x0002010c, 16, 16},
{"MAC_DMA_IMR_S7", "RESERVED_0"                              , 0x0002010c, 15, 9 },
{"MAC_DMA_IMR_S7", "OLE_TX_ILLEGAL_FRAME"                    , 0x0002010c, 8 , 8 },
{"MAC_DMA_IMR_S7", "OLE_TX_UNKNOWN_LLC"                      , 0x0002010c, 7 , 7 },
{"MAC_DMA_IMR_S7", "OLE_TX_INCOMPLETE_VLAN_LLC"              , 0x0002010c, 6 , 6 },
{"MAC_DMA_IMR_S7", "OLE_TX_UNKNOWN_TYPE_ERR"                 , 0x0002010c, 5 , 5 },
{"MAC_DMA_IMR_S7", "OLE_TX_SEQ_NUM_BITMAP_ERR"               , 0x0002010c, 4 , 4 },
{"MAC_DMA_IMR_S7", "OLE_TX_PN_BITMAP_ERR"                    , 0x0002010c, 3 , 3 },
{"MAC_DMA_IMR_S7", "OLE_TX_AMSDU_FRAME_ERR"                  , 0x0002010c, 2 , 2 },
{"MAC_DMA_IMR_S7", "OLE_TX_WEP_KTYPE_ERR"                    , 0x0002010c, 1 , 1 },
{"MAC_DMA_IMR_S7", "DMA_OLE_TX_ABORT"                        , 0x0002010c, 0 , 0 },
{"MAC_DMA_ISR_S7_S", "RESERVED_1"                            , 0x00020110, 31, 20},
{"MAC_DMA_ISR_S7_S", "OLE_RX_WMAC_PARSER_ERR"                , 0x00020110, 19, 19},
{"MAC_DMA_ISR_S7_S", "OLE_RX_ETH_PARSER_ERR"                 , 0x00020110, 18, 18},
{"MAC_DMA_ISR_S7_S", "OLE_RX_MPDU_PKT_ABORT"                 , 0x00020110, 17, 17},
{"MAC_DMA_ISR_S7_S", "OLE_RX_MSDU_LEN_ERR"                   , 0x00020110, 16, 16},
{"MAC_DMA_ISR_S7_S", "RESERVED_0"                            , 0x00020110, 15, 9 },
{"MAC_DMA_ISR_S7_S", "OLE_TX_ILLEGAL_FRAME"                  , 0x00020110, 8 , 8 },
{"MAC_DMA_ISR_S7_S", "OLE_TX_UNKNOWN_LLC"                    , 0x00020110, 7 , 7 },
{"MAC_DMA_ISR_S7_S", "OLE_TX_INCOMPLETE_VLAN_LLC"            , 0x00020110, 6 , 6 },
{"MAC_DMA_ISR_S7_S", "OLE_TX_UNKNOWN_TYPE_ERR"               , 0x00020110, 5 , 5 },
{"MAC_DMA_ISR_S7_S", "OLE_TX_SEQ_NUM_BITMAP_ERR"             , 0x00020110, 4 , 4 },
{"MAC_DMA_ISR_S7_S", "OLE_TX_PN_BITMAP_ERR"                  , 0x00020110, 3 , 3 },
{"MAC_DMA_ISR_S7_S", "OLE_TX_AMSDU_FRAME_ERR"                , 0x00020110, 2 , 2 },
{"MAC_DMA_ISR_S7_S", "OLE_TX_WEP_KTYPE_ERR"                  , 0x00020110, 1 , 1 },
{"MAC_DMA_ISR_S7_S", "DMA_OLE_TX_ABORT"                      , 0x00020110, 0 , 0 },
{"MAC_DMA_CHKACC", "CHKSUM_SEL"                              , 0x0002012c, 0 , 0 },
{"MAC_DMA_AXI_CFG_0", "WIFI_MEM_BASE_ADDR"                   , 0x00020138, 31, 0 },
{"MAC_DMA_AXI_CFG_1", "WIFI_MEM_MASK"                        , 0x0002013c, 31, 0 },
{"MAC_DMA_AXI_CFG_2", "WIFI_MEM_WRITE_SIZE"                  , 0x00020140, 3 , 2 },
{"MAC_DMA_AXI_CFG_2", "WIFI_MEM_READ_SIZE"                   , 0x00020140, 1 , 0 },
{"MAC_DMA_RCV_CFG_RING0_0", "BASE_ADDR"                      , 0x00020200, 31, 0 },
{"MAC_DMA_RCV_CFG_RING0_1", "BUF_SIZE"                       , 0x00020204, 31, 16},
{"MAC_DMA_RCV_CFG_RING0_1", "NUM_DESCS"                      , 0x00020204, 14, 0 },
{"MAC_DMA_RCV_CFG_RING0_2", "RX_FRAGINFO_SWAP"               , 0x00020208, 25, 25},
{"MAC_DMA_RCV_CFG_RING0_2", "RX_ATTENTION_SWAP"              , 0x00020208, 24, 24},
{"MAC_DMA_RCV_CFG_RING0_2", "RX_MSDU_END_SWAP"               , 0x00020208, 23, 23},
{"MAC_DMA_RCV_CFG_RING0_2", "RX_MSDU_START_SWAP"             , 0x00020208, 22, 22},
{"MAC_DMA_RCV_CFG_RING0_2", "RX_MPDU_END_SWAP"               , 0x00020208, 21, 21},
{"MAC_DMA_RCV_CFG_RING0_2", "RX_MPDU_START_SWAP"             , 0x00020208, 20, 20},
{"MAC_DMA_RCV_CFG_RING0_2", "RX_PPDU_END_SWAP"               , 0x00020208, 19, 19},
{"MAC_DMA_RCV_CFG_RING0_2", "RX_PPDU_START_SWAP"             , 0x00020208, 18, 18},
{"MAC_DMA_RCV_CFG_RING0_2", "RX_PACKET_SWAP"                 , 0x00020208, 17, 17},
{"MAC_DMA_RCV_CFG_RING0_2", "RX_HEADER_SWAP"                 , 0x00020208, 16, 16},
{"MAC_DMA_RCV_CFG_RING0_2", "INTR_LWM_THRESH"                , 0x00020208, 7 , 0 },
{"MAC_DMA_RCV_CFG_RING0_3", "RX_PACKET_OFFSET"               , 0x0002020c, 25, 18},
{"MAC_DMA_RCV_CFG_RING0_3", "RX_HEADER_OFFSET"               , 0x0002020c, 9 , 2 },
{"MAC_DMA_RCV_CFG_RING0_4", "RX_PPDU_END_OFFSET"             , 0x00020210, 25, 18},
{"MAC_DMA_RCV_CFG_RING0_4", "RX_PPDU_START_OFFSET"           , 0x00020210, 9 , 2 },
{"MAC_DMA_RCV_CFG_RING0_5", "RX_MPDU_END_OFFSET"             , 0x00020214, 25, 18},
{"MAC_DMA_RCV_CFG_RING0_5", "RX_MPDU_START_OFFSET"           , 0x00020214, 9 , 2 },
{"MAC_DMA_RCV_CFG_RING0_6", "RX_MSDU_END_OFFSET"             , 0x00020218, 25, 18},
{"MAC_DMA_RCV_CFG_RING0_6", "RX_MSDU_START_OFFSET"           , 0x00020218, 9 , 2 },
{"MAC_DMA_RCV_CFG_RING0_7", "RX_FRAGINFO_OFFSET"             , 0x0002021c, 25, 18},
{"MAC_DMA_RCV_CFG_RING0_7", "RX_ATTENTION_OFFSET"            , 0x0002021c, 9 , 2 },
{"MAC_DMA_RCV_CFG_RING1_0", "BASE_ADDR"                      , 0x00020230, 31, 0 },
{"MAC_DMA_RCV_CFG_RING1_1", "BUF_SIZE"                       , 0x00020234, 31, 16},
{"MAC_DMA_RCV_CFG_RING1_1", "NUM_DESCS"                      , 0x00020234, 15, 0 },
{"MAC_DMA_RCV_CFG_RING1_2", "RX_FRAGINFO_SWAP"               , 0x00020238, 25, 25},
{"MAC_DMA_RCV_CFG_RING1_2", "RX_ATTENTION_SWAP"              , 0x00020238, 24, 24},
{"MAC_DMA_RCV_CFG_RING1_2", "RX_MSDU_END_SWAP"               , 0x00020238, 23, 23},
{"MAC_DMA_RCV_CFG_RING1_2", "RX_MSDU_START_SWAP"             , 0x00020238, 22, 22},
{"MAC_DMA_RCV_CFG_RING1_2", "RX_MPDU_END_SWAP"               , 0x00020238, 21, 21},
{"MAC_DMA_RCV_CFG_RING1_2", "RX_MPDU_START_SWAP"             , 0x00020238, 20, 20},
{"MAC_DMA_RCV_CFG_RING1_2", "RX_PPDU_END_SWAP"               , 0x00020238, 19, 19},
{"MAC_DMA_RCV_CFG_RING1_2", "RX_PPDU_START_SWAP"             , 0x00020238, 18, 18},
{"MAC_DMA_RCV_CFG_RING1_2", "RX_PACKET_SWAP"                 , 0x00020238, 17, 17},
{"MAC_DMA_RCV_CFG_RING1_2", "RX_HEADER_SWAP"                 , 0x00020238, 16, 16},
{"MAC_DMA_RCV_CFG_RING1_2", "INTR_LWM_THRESH"                , 0x00020238, 7 , 0 },
{"MAC_DMA_RCV_CFG_RING1_3", "RX_PACKET_OFFSET"               , 0x0002023c, 25, 18},
{"MAC_DMA_RCV_CFG_RING1_3", "RX_HEADER_OFFSET"               , 0x0002023c, 9 , 2 },
{"MAC_DMA_RCV_CFG_RING1_4", "RX_PPDU_END_OFFSET"             , 0x00020240, 25, 18},
{"MAC_DMA_RCV_CFG_RING1_4", "RX_PPDU_START_OFFSET"           , 0x00020240, 9 , 2 },
{"MAC_DMA_RCV_CFG_RING1_5", "RX_MPDU_END_OFFSET"             , 0x00020244, 25, 18},
{"MAC_DMA_RCV_CFG_RING1_5", "RX_MPDU_START_OFFSET"           , 0x00020244, 9 , 2 },
{"MAC_DMA_RCV_CFG_RING1_6", "RX_MSDU_END_OFFSET"             , 0x00020248, 25, 18},
{"MAC_DMA_RCV_CFG_RING1_6", "RX_MSDU_START_OFFSET"           , 0x00020248, 9 , 2 },
{"MAC_DMA_RCV_CFG_RING1_7", "RX_FRAGINFO_OFFSET"             , 0x0002024c, 25, 18},
{"MAC_DMA_RCV_CFG_RING1_7", "RX_ATTENTION_OFFSET"            , 0x0002024c, 9 , 2 },
{"MAC_DMA_RCV_CFG_RING2_0", "BASE_ADDR"                      , 0x00020260, 31, 0 },
{"MAC_DMA_RCV_CFG_RING2_1", "BUF_SIZE"                       , 0x00020264, 31, 16},
{"MAC_DMA_RCV_CFG_RING2_1", "NUM_DESCS"                      , 0x00020264, 15, 0 },
{"MAC_DMA_RCV_CFG_RING2_2", "RX_FRAGINFO_SWAP"               , 0x00020268, 25, 25},
{"MAC_DMA_RCV_CFG_RING2_2", "RX_ATTENTION_SWAP"              , 0x00020268, 24, 24},
{"MAC_DMA_RCV_CFG_RING2_2", "RX_MSDU_END_SWAP"               , 0x00020268, 23, 23},
{"MAC_DMA_RCV_CFG_RING2_2", "RX_MSDU_START_SWAP"             , 0x00020268, 22, 22},
{"MAC_DMA_RCV_CFG_RING2_2", "RX_MPDU_END_SWAP"               , 0x00020268, 21, 21},
{"MAC_DMA_RCV_CFG_RING2_2", "RX_MPDU_START_SWAP"             , 0x00020268, 20, 20},
{"MAC_DMA_RCV_CFG_RING2_2", "RX_PPDU_END_SWAP"               , 0x00020268, 19, 19},
{"MAC_DMA_RCV_CFG_RING2_2", "RX_PPDU_START_SWAP"             , 0x00020268, 18, 18},
{"MAC_DMA_RCV_CFG_RING2_2", "RX_PACKET_SWAP"                 , 0x00020268, 17, 17},
{"MAC_DMA_RCV_CFG_RING2_2", "RX_HEADER_SWAP"                 , 0x00020268, 16, 16},
{"MAC_DMA_RCV_CFG_RING2_2", "INTR_LWM_THRESH"                , 0x00020268, 7 , 0 },
{"MAC_DMA_RCV_CFG_RING2_3", "RX_PACKET_OFFSET"               , 0x0002026c, 25, 18},
{"MAC_DMA_RCV_CFG_RING2_3", "RX_HEADER_OFFSET"               , 0x0002026c, 9 , 2 },
{"MAC_DMA_RCV_CFG_RING2_4", "RX_PPDU_END_OFFSET"             , 0x00020270, 25, 18},
{"MAC_DMA_RCV_CFG_RING2_4", "RX_PPDU_START_OFFSET"           , 0x00020270, 9 , 2 },
{"MAC_DMA_RCV_CFG_RING2_5", "RX_MPDU_END_OFFSET"             , 0x00020274, 25, 18},
{"MAC_DMA_RCV_CFG_RING2_5", "RX_MPDU_START_OFFSET"           , 0x00020274, 9 , 2 },
{"MAC_DMA_RCV_CFG_RING2_6", "RX_MSDU_END_OFFSET"             , 0x00020278, 25, 18},
{"MAC_DMA_RCV_CFG_RING2_6", "RX_MSDU_START_OFFSET"           , 0x00020278, 9 , 2 },
{"MAC_DMA_RCV_CFG_RING2_7", "RX_FRAGINFO_OFFSET"             , 0x0002027c, 25, 18},
{"MAC_DMA_RCV_CFG_RING2_7", "RX_ATTENTION_OFFSET"            , 0x0002027c, 9 , 2 },
{"MAC_DMA_RCV_CFG_RING3_0", "BASE_ADDR"                      , 0x00020290, 31, 0 },
{"MAC_DMA_RCV_CFG_RING3_1", "BUF_SIZE"                       , 0x00020294, 31, 16},
{"MAC_DMA_RCV_CFG_RING3_1", "NUM_DESCS"                      , 0x00020294, 15, 0 },
{"MAC_DMA_RCV_CFG_RING3_2", "RX_FRAGINFO_SWAP"               , 0x00020298, 25, 25},
{"MAC_DMA_RCV_CFG_RING3_2", "RX_ATTENTION_SWAP"              , 0x00020298, 24, 24},
{"MAC_DMA_RCV_CFG_RING3_2", "RX_MSDU_END_SWAP"               , 0x00020298, 23, 23},
{"MAC_DMA_RCV_CFG_RING3_2", "RX_MSDU_START_SWAP"             , 0x00020298, 22, 22},
{"MAC_DMA_RCV_CFG_RING3_2", "RX_MPDU_END_SWAP"               , 0x00020298, 21, 21},
{"MAC_DMA_RCV_CFG_RING3_2", "RX_MPDU_START_SWAP"             , 0x00020298, 20, 20},
{"MAC_DMA_RCV_CFG_RING3_2", "RX_PPDU_END_SWAP"               , 0x00020298, 19, 19},
{"MAC_DMA_RCV_CFG_RING3_2", "RX_PPDU_START_SWAP"             , 0x00020298, 18, 18},
{"MAC_DMA_RCV_CFG_RING3_2", "RX_PACKET_SWAP"                 , 0x00020298, 17, 17},
{"MAC_DMA_RCV_CFG_RING3_2", "RX_HEADER_SWAP"                 , 0x00020298, 16, 16},
{"MAC_DMA_RCV_CFG_RING3_2", "INTR_LWM_THRESH"                , 0x00020298, 7 , 0 },
{"MAC_DMA_RCV_CFG_RING3_3", "RX_PACKET_OFFSET"               , 0x0002029c, 25, 18},
{"MAC_DMA_RCV_CFG_RING3_3", "RX_HEADER_OFFSET"               , 0x0002029c, 9 , 2 },
{"MAC_DMA_RCV_CFG_RING3_4", "RX_PPDU_END_OFFSET"             , 0x000202a0, 25, 18},
{"MAC_DMA_RCV_CFG_RING3_4", "RX_PPDU_START_OFFSET"           , 0x000202a0, 9 , 2 },
{"MAC_DMA_RCV_CFG_RING3_5", "RX_MPDU_END_OFFSET"             , 0x000202a4, 25, 18},
{"MAC_DMA_RCV_CFG_RING3_5", "RX_MPDU_START_OFFSET"           , 0x000202a4, 9 , 2 },
{"MAC_DMA_RCV_CFG_RING3_6", "RX_MSDU_END_OFFSET"             , 0x000202a8, 25, 18},
{"MAC_DMA_RCV_CFG_RING3_6", "RX_MSDU_START_OFFSET"           , 0x000202a8, 9 , 2 },
{"MAC_DMA_RCV_CFG_RING3_7", "RX_FRAGINFO_OFFSET"             , 0x000202ac, 25, 18},
{"MAC_DMA_RCV_CFG_RING3_7", "RX_ATTENTION_OFFSET"            , 0x000202ac, 9 , 2 },
{"MAC_DMA_RCV_EN_ACT_0", "RING_ACTIVE"                       , 0x000202c0, 1 , 1 },
{"MAC_DMA_RCV_EN_ACT_0", "RING_ENABLE"                       , 0x000202c0, 0 , 0 },
{"MAC_DMA_RCV_EN_ACT_1", "RING_ACTIVE"                       , 0x000202c4, 1 , 1 },
{"MAC_DMA_RCV_EN_ACT_1", "RING_ENABLE"                       , 0x000202c4, 0 , 0 },
{"MAC_DMA_RCV_EN_ACT_2", "RING_ACTIVE"                       , 0x000202c8, 1 , 1 },
{"MAC_DMA_RCV_EN_ACT_2", "RING_ENABLE"                       , 0x000202c8, 0 , 0 },
{"MAC_DMA_RCV_EN_ACT_3", "RING_ACTIVE"                       , 0x000202cc, 1 , 1 },
{"MAC_DMA_RCV_EN_ACT_3", "RING_ENABLE"                       , 0x000202cc, 0 , 0 },
{"MAC_DMA_RCV_CFG_MISC_0", "MEM_BOUNDARY_BYTES_1"            , 0x000202d0, 31, 16},
{"MAC_DMA_RCV_CFG_MISC_0", "MEM_BOUNDARY_BYTES_0"            , 0x000202d0, 15, 0 },
{"MAC_DMA_RCV_CFG_MISC_1", "MEM_BOUNDARY_BYTES_3"            , 0x000202d4, 31, 16},
{"MAC_DMA_RCV_CFG_MISC_1", "MEM_BOUNDARY_BYTES_2"            , 0x000202d4, 15, 0 },
{"MAC_DMA_RCV_CFG_MISC_2", "LONG_DMA_PAUSE_FIX_DIS"          , 0x000202d8, 0 , 0 },
{"MAC_DMA_RCV_IDX_0", "RING_HW_IDX_OVERWRITE"                , 0x000202e0, 31, 31},
{"MAC_DMA_RCV_IDX_0", "RING_HW_IDX"                          , 0x000202e0, 30, 16},
{"MAC_DMA_RCV_IDX_0", "RING_FW_IDX"                          , 0x000202e0, 14, 0 },
{"MAC_DMA_RCV_IDX_1", "RING_HW_IDX_OVERWRITE"                , 0x000202e4, 31, 31},
{"MAC_DMA_RCV_IDX_1", "RING_HW_IDX"                          , 0x000202e4, 30, 16},
{"MAC_DMA_RCV_IDX_1", "RING_FW_IDX"                          , 0x000202e4, 14, 0 },
{"MAC_DMA_RCV_IDX_2", "RING_HW_IDX_OVERWRITE"                , 0x000202e8, 31, 31},
{"MAC_DMA_RCV_IDX_2", "RING_HW_IDX"                          , 0x000202e8, 30, 16},
{"MAC_DMA_RCV_IDX_2", "RING_FW_IDX"                          , 0x000202e8, 14, 0 },
{"MAC_DMA_RCV_IDX_3", "RING_HW_IDX_OVERWRITE"                , 0x000202ec, 31, 31},
{"MAC_DMA_RCV_IDX_3", "RING_HW_IDX"                          , 0x000202ec, 30, 16},
{"MAC_DMA_RCV_IDX_3", "RING_FW_IDX"                          , 0x000202ec, 14, 0 },
{"MAC_DMA_RCV_GLOBAL_RER", "ENABLE"                          , 0x000202f0, 0 , 0 },
{"MAC_DMA_RCV_OBS_BUS", "VALUE"                              , 0x000202fc, 31, 0 },
{"MAC_TRC", "OBS_BUS_SEL"                                    , 0x00020300, 11, 10},
{"MAC_TRC", "MAC_MODULE_SEL"                                 , 0x00020300, 9 , 8 },
{"MAC_TRC", "CPU_ACCESS_EN_VALUE"                            , 0x00020300, 4 , 4 },
{"MAC_TRC", "BUF_CFG_VALUE"                                  , 0x00020300, 1 , 1 },
{"MAC_TRC", "ENABLE_VALUE"                                   , 0x00020300, 0 , 0 },
{"MAC_TRC_BUF_INIT", "VALUE"                                 , 0x00020304, 0 , 0 },
{"MAC_TRC_ADDR", "END_VALUE"                                 , 0x00020308, 29, 16},
{"MAC_TRC_ADDR", "START_VALUE"                               , 0x00020308, 13, 0 },
{"MAC_TRC_WFT_CAPTURE_CTRL", "VALUE"                         , 0x0002030c, 31, 0 },
{"MAC_TRC_WFT_STATE_CTRL", "VALUE"                           , 0x00020310, 31, 0 },
{"MAC_TRC_TS1_CAPTURE_CTRL", "VALUE"                         , 0x00020314, 31, 0 },
{"MAC_TRC_TS1_STATE_CTRL", "VALUE"                           , 0x00020318, 31, 0 },
{"MAC_TRC_TS1_TRIG_MASK", "VALUE"                            , 0x0002031c, 31, 0 },
{"MAC_TRC_TS1_TRIG", "VALUE"                                 , 0x00020320, 31, 0 },
{"MAC_TRC_TS2_CAPTURE_CTRL", "VALUE"                         , 0x00020324, 31, 0 },
{"MAC_TRC_TS2_STATE_CTRL", "VALUE"                           , 0x00020328, 31, 0 },
{"MAC_TRC_TS2_TRIG_MASK", "VALUE"                            , 0x0002032c, 31, 0 },
{"MAC_TRC_TS2_TRIG", "VALUE"                                 , 0x00020330, 31, 0 },
{"MAC_TRC_TS3_CAPTURE_CTRL", "VALUE"                         , 0x00020334, 31, 0 },
{"MAC_TRC_TS3_STATE_CTRL", "VALUE"                           , 0x00020338, 31, 0 },
{"MAC_TRC_TS3_TRIG_MASK", "VALUE"                            , 0x0002033c, 31, 0 },
{"MAC_TRC_TS3_TRIG", "VALUE"                                 , 0x00020340, 31, 0 },
{"MAC_TRC_TS4_CAPTURE_CTRL", "VALUE"                         , 0x00020344, 31, 0 },
{"MAC_TRC_TS4_STATE_CTRL", "VALUE"                           , 0x00020348, 31, 0 },
{"MAC_TRC_TS4_TRIG_MASK", "VALUE"                            , 0x0002034c, 31, 0 },
{"MAC_TRC_TS4_TRIG", "VALUE"                                 , 0x00020350, 31, 0 },
{"MAC_TRC_TS5_CAPTURE_CTRL", "VALUE"                         , 0x00020354, 31, 0 },
{"MAC_TRC_TS5_STATE_CTRL", "VALUE"                           , 0x00020358, 31, 0 },
{"MAC_TRC_TS5_TRIG_MASK", "VALUE"                            , 0x0002035c, 31, 0 },
{"MAC_TRC_TS5_TRIG", "VALUE"                                 , 0x00020360, 31, 0 },
{"MAC_TRC_CPU_ADDR", "READ_VALUE"                            , 0x00020364, 31, 0 },
{"MAC_TRC_CPU_DATA", "VALUE"                                 , 0x00020368, 31, 0 },
{"MAC_TRC_STATUS_0", "BUF_INIT_DONE"                         , 0x0002036c, 1 , 1 },
{"MAC_TRC_STATUS_0", "BUF_FULL"                              , 0x0002036c, 0 , 0 },
{"MAC_TRC_STATUS_1", "BUF_RD_END_ADDR"                       , 0x00020370, 29, 16},
{"MAC_TRC_STATUS_1", "BUF_RD_START_ADDR"                     , 0x00020370, 13, 0 },
{"MAC_TRC_STATUS_2", "TRIG_EVENT_FLAGS"                      , 0x00020374, 12, 8 },
{"MAC_TRC_STATUS_2", "MAIN_CTL_STATE"                        , 0x00020374, 6 , 4 },
{"MAC_TRC_STATUS_2", "WRCTL_STATE"                           , 0x00020374, 2 , 0 },
{"MAC_TRC_STATUS_3", "TRIG_SAMPLE"                           , 0x00020378, 29, 0 },
{"MAC_BB_OBS_BUS_SEL", "VALUE"                               , 0x00020380, 31, 0 },
{"MAC_DMA_OBS_MUX_CONTROL", "VALUE"                          , 0x00020384, 19, 16},
{"MAC_DMA_OBS_MUX_CONTROL", "RCV_DMA"                        , 0x00020384, 15, 12},
{"MAC_DMA_OBS_MUX_CONTROL", "QCU"                            , 0x00020384, 11, 8 },
{"MAC_DMA_OBS_MUX_CONTROL", "AXI_ARB"                        , 0x00020384, 7 , 4 },
{"MAC_DMA_OBS_MUX_CONTROL", "DCU"                            , 0x00020384, 3 , 0 },
{"MAC_OLE_OBS_MUX_CONTROL", "DATA_SEL"                       , 0x00020388, 3 , 3 },
{"MAC_OLE_OBS_MUX_CONTROL", "SEL"                            , 0x00020388, 2 , 0 },
{"MAC_PCU_OBS_MUX_CONTROL", "VALUE"                          , 0x0002038c, 19, 16},
{"MAC_PCU_OBS_MUX_CONTROL", "PCU_TX_TLV"                     , 0x0002038c, 11, 8 },
{"MAC_PCU_OBS_MUX_CONTROL", "PCU_RX"                         , 0x0002038c, 7 , 4 },
{"MAC_PCU_OBS_MUX_CONTROL", "PCU_TX"                         , 0x0002038c, 3 , 0 },
{"MAC_QCU_TXDP[0]", "DATA"                                   , 0x00020800, 31, 0 },
{"MAC_QCU_TXDP[1]", "DATA"                                   , 0x00020804, 31, 0 },
{"MAC_QCU_TXDP[2]", "DATA"                                   , 0x00020808, 31, 0 },
{"MAC_QCU_TXDP[3]", "DATA"                                   , 0x0002080c, 31, 0 },
{"MAC_QCU_TXDP[4]", "DATA"                                   , 0x00020810, 31, 0 },
{"MAC_QCU_TXDP[5]", "DATA"                                   , 0x00020814, 31, 0 },
{"MAC_QCU_TXDP[6]", "DATA"                                   , 0x00020818, 31, 0 },
{"MAC_QCU_TXDP[7]", "DATA"                                   , 0x0002081c, 31, 0 },
{"MAC_QCU_TXDP[8]", "DATA"                                   , 0x00020820, 31, 0 },
{"MAC_QCU_TXDP[9]", "DATA"                                   , 0x00020824, 31, 0 },
{"MAC_QCU_TXE", "DATA"                                       , 0x00020840, 9 , 0 },
{"MAC_QCU_TXD", "DATA"                                       , 0x00020880, 9 , 0 },
{"MAC_QCU_CBR[0]", "OVF_THRESH"                              , 0x000208c0, 31, 24},
{"MAC_QCU_CBR[0]", "INTERVAL"                                , 0x000208c0, 23, 0 },
{"MAC_QCU_CBR[1]", "OVF_THRESH"                              , 0x000208c4, 31, 24},
{"MAC_QCU_CBR[1]", "INTERVAL"                                , 0x000208c4, 23, 0 },
{"MAC_QCU_CBR[2]", "OVF_THRESH"                              , 0x000208c8, 31, 24},
{"MAC_QCU_CBR[2]", "INTERVAL"                                , 0x000208c8, 23, 0 },
{"MAC_QCU_CBR[3]", "OVF_THRESH"                              , 0x000208cc, 31, 24},
{"MAC_QCU_CBR[3]", "INTERVAL"                                , 0x000208cc, 23, 0 },
{"MAC_QCU_CBR[4]", "OVF_THRESH"                              , 0x000208d0, 31, 24},
{"MAC_QCU_CBR[4]", "INTERVAL"                                , 0x000208d0, 23, 0 },
{"MAC_QCU_CBR[5]", "OVF_THRESH"                              , 0x000208d4, 31, 24},
{"MAC_QCU_CBR[5]", "INTERVAL"                                , 0x000208d4, 23, 0 },
{"MAC_QCU_CBR[6]", "OVF_THRESH"                              , 0x000208d8, 31, 24},
{"MAC_QCU_CBR[6]", "INTERVAL"                                , 0x000208d8, 23, 0 },
{"MAC_QCU_CBR[7]", "OVF_THRESH"                              , 0x000208dc, 31, 24},
{"MAC_QCU_CBR[7]", "INTERVAL"                                , 0x000208dc, 23, 0 },
{"MAC_QCU_CBR[8]", "OVF_THRESH"                              , 0x000208e0, 31, 24},
{"MAC_QCU_CBR[8]", "INTERVAL"                                , 0x000208e0, 23, 0 },
{"MAC_QCU_CBR[9]", "OVF_THRESH"                              , 0x000208e4, 31, 24},
{"MAC_QCU_CBR[9]", "INTERVAL"                                , 0x000208e4, 23, 0 },
{"MAC_QCU_RDYTIME[0]", "EN"                                  , 0x00020900, 24, 24},
{"MAC_QCU_RDYTIME[0]", "DURATION"                            , 0x00020900, 23, 0 },
{"MAC_QCU_RDYTIME[1]", "EN"                                  , 0x00020904, 24, 24},
{"MAC_QCU_RDYTIME[1]", "DURATION"                            , 0x00020904, 23, 0 },
{"MAC_QCU_RDYTIME[2]", "EN"                                  , 0x00020908, 24, 24},
{"MAC_QCU_RDYTIME[2]", "DURATION"                            , 0x00020908, 23, 0 },
{"MAC_QCU_RDYTIME[3]", "EN"                                  , 0x0002090c, 24, 24},
{"MAC_QCU_RDYTIME[3]", "DURATION"                            , 0x0002090c, 23, 0 },
{"MAC_QCU_RDYTIME[4]", "EN"                                  , 0x00020910, 24, 24},
{"MAC_QCU_RDYTIME[4]", "DURATION"                            , 0x00020910, 23, 0 },
{"MAC_QCU_RDYTIME[5]", "EN"                                  , 0x00020914, 24, 24},
{"MAC_QCU_RDYTIME[5]", "DURATION"                            , 0x00020914, 23, 0 },
{"MAC_QCU_RDYTIME[6]", "EN"                                  , 0x00020918, 24, 24},
{"MAC_QCU_RDYTIME[6]", "DURATION"                            , 0x00020918, 23, 0 },
{"MAC_QCU_RDYTIME[7]", "EN"                                  , 0x0002091c, 24, 24},
{"MAC_QCU_RDYTIME[7]", "DURATION"                            , 0x0002091c, 23, 0 },
{"MAC_QCU_RDYTIME[8]", "EN"                                  , 0x00020920, 24, 24},
{"MAC_QCU_RDYTIME[8]", "DURATION"                            , 0x00020920, 23, 0 },
{"MAC_QCU_RDYTIME[9]", "EN"                                  , 0x00020924, 24, 24},
{"MAC_QCU_RDYTIME[9]", "DURATION"                            , 0x00020924, 23, 0 },
{"MAC_QCU_ONESHOT_ARM_SC", "SET"                             , 0x00020940, 9 , 0 },
{"MAC_QCU_ONESHOT_ARM_CC", "CLEAR"                           , 0x00020980, 9 , 0 },
{"MAC_QCU_MISC[0]", "NON_ASAP_FRAME_BURST"                   , 0x000209c0, 12, 12},
{"MAC_QCU_MISC[0]", "FR_ABORT_REQ_EN"                        , 0x000209c0, 11, 11},
{"MAC_QCU_MISC[0]", "MMR_CBR_EXP_CNT_CLR_EN"                 , 0x000209c0, 10, 10},
{"MAC_QCU_MISC[0]", "TXE_CLR_ON_CBR_END"                     , 0x000209c0, 9 , 9 },
{"MAC_QCU_MISC[0]", "CBR_EXP_INC_LIMIT"                      , 0x000209c0, 8 , 8 },
{"MAC_QCU_MISC[0]", "IS_BCN"                                 , 0x000209c0, 7 , 7 },
{"MAC_QCU_MISC[0]", "CBR_EXP_INC_DIS_NOBCNFR"                , 0x000209c0, 6 , 6 },
{"MAC_QCU_MISC[0]", "CBR_EXP_INC_DIS_NOFR"                   , 0x000209c0, 5 , 5 },
{"MAC_QCU_MISC[0]", "ONESHOT_EN"                             , 0x000209c0, 4 , 4 },
{"MAC_QCU_MISC[0]", "FSP"                                    , 0x000209c0, 3 , 0 },
{"MAC_QCU_MISC[1]", "NON_ASAP_FRAME_BURST"                   , 0x000209c4, 12, 12},
{"MAC_QCU_MISC[1]", "FR_ABORT_REQ_EN"                        , 0x000209c4, 11, 11},
{"MAC_QCU_MISC[1]", "MMR_CBR_EXP_CNT_CLR_EN"                 , 0x000209c4, 10, 10},
{"MAC_QCU_MISC[1]", "TXE_CLR_ON_CBR_END"                     , 0x000209c4, 9 , 9 },
{"MAC_QCU_MISC[1]", "CBR_EXP_INC_LIMIT"                      , 0x000209c4, 8 , 8 },
{"MAC_QCU_MISC[1]", "IS_BCN"                                 , 0x000209c4, 7 , 7 },
{"MAC_QCU_MISC[1]", "CBR_EXP_INC_DIS_NOBCNFR"                , 0x000209c4, 6 , 6 },
{"MAC_QCU_MISC[1]", "CBR_EXP_INC_DIS_NOFR"                   , 0x000209c4, 5 , 5 },
{"MAC_QCU_MISC[1]", "ONESHOT_EN"                             , 0x000209c4, 4 , 4 },
{"MAC_QCU_MISC[1]", "FSP"                                    , 0x000209c4, 3 , 0 },
{"MAC_QCU_MISC[2]", "NON_ASAP_FRAME_BURST"                   , 0x000209c8, 12, 12},
{"MAC_QCU_MISC[2]", "FR_ABORT_REQ_EN"                        , 0x000209c8, 11, 11},
{"MAC_QCU_MISC[2]", "MMR_CBR_EXP_CNT_CLR_EN"                 , 0x000209c8, 10, 10},
{"MAC_QCU_MISC[2]", "TXE_CLR_ON_CBR_END"                     , 0x000209c8, 9 , 9 },
{"MAC_QCU_MISC[2]", "CBR_EXP_INC_LIMIT"                      , 0x000209c8, 8 , 8 },
{"MAC_QCU_MISC[2]", "IS_BCN"                                 , 0x000209c8, 7 , 7 },
{"MAC_QCU_MISC[2]", "CBR_EXP_INC_DIS_NOBCNFR"                , 0x000209c8, 6 , 6 },
{"MAC_QCU_MISC[2]", "CBR_EXP_INC_DIS_NOFR"                   , 0x000209c8, 5 , 5 },
{"MAC_QCU_MISC[2]", "ONESHOT_EN"                             , 0x000209c8, 4 , 4 },
{"MAC_QCU_MISC[2]", "FSP"                                    , 0x000209c8, 3 , 0 },
{"MAC_QCU_MISC[3]", "NON_ASAP_FRAME_BURST"                   , 0x000209cc, 12, 12},
{"MAC_QCU_MISC[3]", "FR_ABORT_REQ_EN"                        , 0x000209cc, 11, 11},
{"MAC_QCU_MISC[3]", "MMR_CBR_EXP_CNT_CLR_EN"                 , 0x000209cc, 10, 10},
{"MAC_QCU_MISC[3]", "TXE_CLR_ON_CBR_END"                     , 0x000209cc, 9 , 9 },
{"MAC_QCU_MISC[3]", "CBR_EXP_INC_LIMIT"                      , 0x000209cc, 8 , 8 },
{"MAC_QCU_MISC[3]", "IS_BCN"                                 , 0x000209cc, 7 , 7 },
{"MAC_QCU_MISC[3]", "CBR_EXP_INC_DIS_NOBCNFR"                , 0x000209cc, 6 , 6 },
{"MAC_QCU_MISC[3]", "CBR_EXP_INC_DIS_NOFR"                   , 0x000209cc, 5 , 5 },
{"MAC_QCU_MISC[3]", "ONESHOT_EN"                             , 0x000209cc, 4 , 4 },
{"MAC_QCU_MISC[3]", "FSP"                                    , 0x000209cc, 3 , 0 },
{"MAC_QCU_MISC[4]", "NON_ASAP_FRAME_BURST"                   , 0x000209d0, 12, 12},
{"MAC_QCU_MISC[4]", "FR_ABORT_REQ_EN"                        , 0x000209d0, 11, 11},
{"MAC_QCU_MISC[4]", "MMR_CBR_EXP_CNT_CLR_EN"                 , 0x000209d0, 10, 10},
{"MAC_QCU_MISC[4]", "TXE_CLR_ON_CBR_END"                     , 0x000209d0, 9 , 9 },
{"MAC_QCU_MISC[4]", "CBR_EXP_INC_LIMIT"                      , 0x000209d0, 8 , 8 },
{"MAC_QCU_MISC[4]", "IS_BCN"                                 , 0x000209d0, 7 , 7 },
{"MAC_QCU_MISC[4]", "CBR_EXP_INC_DIS_NOBCNFR"                , 0x000209d0, 6 , 6 },
{"MAC_QCU_MISC[4]", "CBR_EXP_INC_DIS_NOFR"                   , 0x000209d0, 5 , 5 },
{"MAC_QCU_MISC[4]", "ONESHOT_EN"                             , 0x000209d0, 4 , 4 },
{"MAC_QCU_MISC[4]", "FSP"                                    , 0x000209d0, 3 , 0 },
{"MAC_QCU_MISC[5]", "NON_ASAP_FRAME_BURST"                   , 0x000209d4, 12, 12},
{"MAC_QCU_MISC[5]", "FR_ABORT_REQ_EN"                        , 0x000209d4, 11, 11},
{"MAC_QCU_MISC[5]", "MMR_CBR_EXP_CNT_CLR_EN"                 , 0x000209d4, 10, 10},
{"MAC_QCU_MISC[5]", "TXE_CLR_ON_CBR_END"                     , 0x000209d4, 9 , 9 },
{"MAC_QCU_MISC[5]", "CBR_EXP_INC_LIMIT"                      , 0x000209d4, 8 , 8 },
{"MAC_QCU_MISC[5]", "IS_BCN"                                 , 0x000209d4, 7 , 7 },
{"MAC_QCU_MISC[5]", "CBR_EXP_INC_DIS_NOBCNFR"                , 0x000209d4, 6 , 6 },
{"MAC_QCU_MISC[5]", "CBR_EXP_INC_DIS_NOFR"                   , 0x000209d4, 5 , 5 },
{"MAC_QCU_MISC[5]", "ONESHOT_EN"                             , 0x000209d4, 4 , 4 },
{"MAC_QCU_MISC[5]", "FSP"                                    , 0x000209d4, 3 , 0 },
{"MAC_QCU_MISC[6]", "NON_ASAP_FRAME_BURST"                   , 0x000209d8, 12, 12},
{"MAC_QCU_MISC[6]", "FR_ABORT_REQ_EN"                        , 0x000209d8, 11, 11},
{"MAC_QCU_MISC[6]", "MMR_CBR_EXP_CNT_CLR_EN"                 , 0x000209d8, 10, 10},
{"MAC_QCU_MISC[6]", "TXE_CLR_ON_CBR_END"                     , 0x000209d8, 9 , 9 },
{"MAC_QCU_MISC[6]", "CBR_EXP_INC_LIMIT"                      , 0x000209d8, 8 , 8 },
{"MAC_QCU_MISC[6]", "IS_BCN"                                 , 0x000209d8, 7 , 7 },
{"MAC_QCU_MISC[6]", "CBR_EXP_INC_DIS_NOBCNFR"                , 0x000209d8, 6 , 6 },
{"MAC_QCU_MISC[6]", "CBR_EXP_INC_DIS_NOFR"                   , 0x000209d8, 5 , 5 },
{"MAC_QCU_MISC[6]", "ONESHOT_EN"                             , 0x000209d8, 4 , 4 },
{"MAC_QCU_MISC[6]", "FSP"                                    , 0x000209d8, 3 , 0 },
{"MAC_QCU_MISC[7]", "NON_ASAP_FRAME_BURST"                   , 0x000209dc, 12, 12},
{"MAC_QCU_MISC[7]", "FR_ABORT_REQ_EN"                        , 0x000209dc, 11, 11},
{"MAC_QCU_MISC[7]", "MMR_CBR_EXP_CNT_CLR_EN"                 , 0x000209dc, 10, 10},
{"MAC_QCU_MISC[7]", "TXE_CLR_ON_CBR_END"                     , 0x000209dc, 9 , 9 },
{"MAC_QCU_MISC[7]", "CBR_EXP_INC_LIMIT"                      , 0x000209dc, 8 , 8 },
{"MAC_QCU_MISC[7]", "IS_BCN"                                 , 0x000209dc, 7 , 7 },
{"MAC_QCU_MISC[7]", "CBR_EXP_INC_DIS_NOBCNFR"                , 0x000209dc, 6 , 6 },
{"MAC_QCU_MISC[7]", "CBR_EXP_INC_DIS_NOFR"                   , 0x000209dc, 5 , 5 },
{"MAC_QCU_MISC[7]", "ONESHOT_EN"                             , 0x000209dc, 4 , 4 },
{"MAC_QCU_MISC[7]", "FSP"                                    , 0x000209dc, 3 , 0 },
{"MAC_QCU_MISC[8]", "NON_ASAP_FRAME_BURST"                   , 0x000209e0, 12, 12},
{"MAC_QCU_MISC[8]", "FR_ABORT_REQ_EN"                        , 0x000209e0, 11, 11},
{"MAC_QCU_MISC[8]", "MMR_CBR_EXP_CNT_CLR_EN"                 , 0x000209e0, 10, 10},
{"MAC_QCU_MISC[8]", "TXE_CLR_ON_CBR_END"                     , 0x000209e0, 9 , 9 },
{"MAC_QCU_MISC[8]", "CBR_EXP_INC_LIMIT"                      , 0x000209e0, 8 , 8 },
{"MAC_QCU_MISC[8]", "IS_BCN"                                 , 0x000209e0, 7 , 7 },
{"MAC_QCU_MISC[8]", "CBR_EXP_INC_DIS_NOBCNFR"                , 0x000209e0, 6 , 6 },
{"MAC_QCU_MISC[8]", "CBR_EXP_INC_DIS_NOFR"                   , 0x000209e0, 5 , 5 },
{"MAC_QCU_MISC[8]", "ONESHOT_EN"                             , 0x000209e0, 4 , 4 },
{"MAC_QCU_MISC[8]", "FSP"                                    , 0x000209e0, 3 , 0 },
{"MAC_QCU_MISC[9]", "NON_ASAP_FRAME_BURST"                   , 0x000209e4, 12, 12},
{"MAC_QCU_MISC[9]", "FR_ABORT_REQ_EN"                        , 0x000209e4, 11, 11},
{"MAC_QCU_MISC[9]", "MMR_CBR_EXP_CNT_CLR_EN"                 , 0x000209e4, 10, 10},
{"MAC_QCU_MISC[9]", "TXE_CLR_ON_CBR_END"                     , 0x000209e4, 9 , 9 },
{"MAC_QCU_MISC[9]", "CBR_EXP_INC_LIMIT"                      , 0x000209e4, 8 , 8 },
{"MAC_QCU_MISC[9]", "IS_BCN"                                 , 0x000209e4, 7 , 7 },
{"MAC_QCU_MISC[9]", "CBR_EXP_INC_DIS_NOBCNFR"                , 0x000209e4, 6 , 6 },
{"MAC_QCU_MISC[9]", "CBR_EXP_INC_DIS_NOFR"                   , 0x000209e4, 5 , 5 },
{"MAC_QCU_MISC[9]", "ONESHOT_EN"                             , 0x000209e4, 4 , 4 },
{"MAC_QCU_MISC[9]", "FSP"                                    , 0x000209e4, 3 , 0 },
{"MAC_QCU_CNT[0]", "CBR_EXP"                                 , 0x00020a00, 15, 8 },
{"MAC_QCU_CNT[0]", "FR_PEND"                                 , 0x00020a00, 1 , 0 },
{"MAC_QCU_CNT[1]", "CBR_EXP"                                 , 0x00020a04, 15, 8 },
{"MAC_QCU_CNT[1]", "FR_PEND"                                 , 0x00020a04, 1 , 0 },
{"MAC_QCU_CNT[2]", "CBR_EXP"                                 , 0x00020a08, 15, 8 },
{"MAC_QCU_CNT[2]", "FR_PEND"                                 , 0x00020a08, 1 , 0 },
{"MAC_QCU_CNT[3]", "CBR_EXP"                                 , 0x00020a0c, 15, 8 },
{"MAC_QCU_CNT[3]", "FR_PEND"                                 , 0x00020a0c, 1 , 0 },
{"MAC_QCU_CNT[4]", "CBR_EXP"                                 , 0x00020a10, 15, 8 },
{"MAC_QCU_CNT[4]", "FR_PEND"                                 , 0x00020a10, 1 , 0 },
{"MAC_QCU_CNT[5]", "CBR_EXP"                                 , 0x00020a14, 15, 8 },
{"MAC_QCU_CNT[5]", "FR_PEND"                                 , 0x00020a14, 1 , 0 },
{"MAC_QCU_CNT[6]", "CBR_EXP"                                 , 0x00020a18, 15, 8 },
{"MAC_QCU_CNT[6]", "FR_PEND"                                 , 0x00020a18, 1 , 0 },
{"MAC_QCU_CNT[7]", "CBR_EXP"                                 , 0x00020a1c, 15, 8 },
{"MAC_QCU_CNT[7]", "FR_PEND"                                 , 0x00020a1c, 1 , 0 },
{"MAC_QCU_CNT[8]", "CBR_EXP"                                 , 0x00020a20, 15, 8 },
{"MAC_QCU_CNT[8]", "FR_PEND"                                 , 0x00020a20, 1 , 0 },
{"MAC_QCU_CNT[9]", "CBR_EXP"                                 , 0x00020a24, 15, 8 },
{"MAC_QCU_CNT[9]", "FR_PEND"                                 , 0x00020a24, 1 , 0 },
{"MAC_QCU_RDYTIME_SHDN", "SHUTDOWN"                          , 0x00020a40, 9 , 0 },
{"MAC_QCU_DESC_CRC_CHK", "EN"                                , 0x00020a44, 0 , 0 },
{"MAC_QCU_EOL", "DUR_CAL_EN"                                 , 0x00020a48, 9 , 0 },
{"MAC_QCU_TXQ_PAUSE", "Q9"                                   , 0x00020a4c, 9 , 9 },
{"MAC_QCU_TXQ_PAUSE", "Q8"                                   , 0x00020a4c, 8 , 8 },
{"MAC_QCU_TXQ_PAUSE", "Q7"                                   , 0x00020a4c, 7 , 7 },
{"MAC_QCU_TXQ_PAUSE", "Q6"                                   , 0x00020a4c, 6 , 6 },
{"MAC_QCU_TXQ_PAUSE", "Q5"                                   , 0x00020a4c, 5 , 5 },
{"MAC_QCU_TXQ_PAUSE", "Q4"                                   , 0x00020a4c, 4 , 4 },
{"MAC_QCU_TXQ_PAUSE", "Q3"                                   , 0x00020a4c, 3 , 3 },
{"MAC_QCU_TXQ_PAUSE", "Q2"                                   , 0x00020a4c, 2 , 2 },
{"MAC_QCU_TXQ_PAUSE", "Q1"                                   , 0x00020a4c, 1 , 1 },
{"MAC_QCU_TXQ_PAUSE", "Q0"                                   , 0x00020a4c, 0 , 0 },
{"MAC_DCU_QCUMASK[0]", "DATA"                                , 0x00021000, 9 , 0 },
{"MAC_DCU_QCUMASK[1]", "DATA"                                , 0x00021004, 9 , 0 },
{"MAC_DCU_QCUMASK[2]", "DATA"                                , 0x00021008, 9 , 0 },
{"MAC_DCU_QCUMASK[3]", "DATA"                                , 0x0002100c, 9 , 0 },
{"MAC_DCU_QCUMASK[4]", "DATA"                                , 0x00021010, 9 , 0 },
{"MAC_DCU_QCUMASK[5]", "DATA"                                , 0x00021014, 9 , 0 },
{"MAC_DCU_QCUMASK[6]", "DATA"                                , 0x00021018, 9 , 0 },
{"MAC_DCU_QCUMASK[7]", "DATA"                                , 0x0002101c, 9 , 0 },
{"MAC_DCU_QCUMASK[8]", "DATA"                                , 0x00021020, 9 , 0 },
{"MAC_DCU_QCUMASK[9]", "DATA"                                , 0x00021024, 9 , 0 },
{"MAC_DCU_GBL_IFS_SIFS", "DURATION"                          , 0x00021030, 15, 0 },
{"MAC_DCU_TXFILTER_DCU0_31_0", "DATA"                        , 0x00021038, 31, 0 },
{"MAC_DCU_TXFILTER_DCU8_31_0", "DATA"                        , 0x0002103c, 31, 0 },
{"MAC_DCU_LCL_IFS[0]", "LONG_AIFS"                           , 0x00021040, 28, 28},
{"MAC_DCU_LCL_IFS[0]", "AIFS"                                , 0x00021040, 27, 20},
{"MAC_DCU_LCL_IFS[0]", "CW_MAX"                              , 0x00021040, 19, 10},
{"MAC_DCU_LCL_IFS[0]", "CW_MIN"                              , 0x00021040, 9 , 0 },
{"MAC_DCU_LCL_IFS[1]", "LONG_AIFS"                           , 0x00021044, 28, 28},
{"MAC_DCU_LCL_IFS[1]", "AIFS"                                , 0x00021044, 27, 20},
{"MAC_DCU_LCL_IFS[1]", "CW_MAX"                              , 0x00021044, 19, 10},
{"MAC_DCU_LCL_IFS[1]", "CW_MIN"                              , 0x00021044, 9 , 0 },
{"MAC_DCU_LCL_IFS[2]", "LONG_AIFS"                           , 0x00021048, 28, 28},
{"MAC_DCU_LCL_IFS[2]", "AIFS"                                , 0x00021048, 27, 20},
{"MAC_DCU_LCL_IFS[2]", "CW_MAX"                              , 0x00021048, 19, 10},
{"MAC_DCU_LCL_IFS[2]", "CW_MIN"                              , 0x00021048, 9 , 0 },
{"MAC_DCU_LCL_IFS[3]", "LONG_AIFS"                           , 0x0002104c, 28, 28},
{"MAC_DCU_LCL_IFS[3]", "AIFS"                                , 0x0002104c, 27, 20},
{"MAC_DCU_LCL_IFS[3]", "CW_MAX"                              , 0x0002104c, 19, 10},
{"MAC_DCU_LCL_IFS[3]", "CW_MIN"                              , 0x0002104c, 9 , 0 },
{"MAC_DCU_LCL_IFS[4]", "LONG_AIFS"                           , 0x00021050, 28, 28},
{"MAC_DCU_LCL_IFS[4]", "AIFS"                                , 0x00021050, 27, 20},
{"MAC_DCU_LCL_IFS[4]", "CW_MAX"                              , 0x00021050, 19, 10},
{"MAC_DCU_LCL_IFS[4]", "CW_MIN"                              , 0x00021050, 9 , 0 },
{"MAC_DCU_LCL_IFS[5]", "LONG_AIFS"                           , 0x00021054, 28, 28},
{"MAC_DCU_LCL_IFS[5]", "AIFS"                                , 0x00021054, 27, 20},
{"MAC_DCU_LCL_IFS[5]", "CW_MAX"                              , 0x00021054, 19, 10},
{"MAC_DCU_LCL_IFS[5]", "CW_MIN"                              , 0x00021054, 9 , 0 },
{"MAC_DCU_LCL_IFS[6]", "LONG_AIFS"                           , 0x00021058, 28, 28},
{"MAC_DCU_LCL_IFS[6]", "AIFS"                                , 0x00021058, 27, 20},
{"MAC_DCU_LCL_IFS[6]", "CW_MAX"                              , 0x00021058, 19, 10},
{"MAC_DCU_LCL_IFS[6]", "CW_MIN"                              , 0x00021058, 9 , 0 },
{"MAC_DCU_LCL_IFS[7]", "LONG_AIFS"                           , 0x0002105c, 28, 28},
{"MAC_DCU_LCL_IFS[7]", "AIFS"                                , 0x0002105c, 27, 20},
{"MAC_DCU_LCL_IFS[7]", "CW_MAX"                              , 0x0002105c, 19, 10},
{"MAC_DCU_LCL_IFS[7]", "CW_MIN"                              , 0x0002105c, 9 , 0 },
{"MAC_DCU_LCL_IFS[8]", "LONG_AIFS"                           , 0x00021060, 28, 28},
{"MAC_DCU_LCL_IFS[8]", "AIFS"                                , 0x00021060, 27, 20},
{"MAC_DCU_LCL_IFS[8]", "CW_MAX"                              , 0x00021060, 19, 10},
{"MAC_DCU_LCL_IFS[8]", "CW_MIN"                              , 0x00021060, 9 , 0 },
{"MAC_DCU_LCL_IFS[9]", "LONG_AIFS"                           , 0x00021064, 28, 28},
{"MAC_DCU_LCL_IFS[9]", "AIFS"                                , 0x00021064, 27, 20},
{"MAC_DCU_LCL_IFS[9]", "CW_MAX"                              , 0x00021064, 19, 10},
{"MAC_DCU_LCL_IFS[9]", "CW_MIN"                              , 0x00021064, 9 , 0 },
{"MAC_DCU_GBL_IFS_SLOT", "DURATION"                          , 0x00021070, 15, 0 },
{"MAC_DCU_TXFILTER_DCU0_63_32", "DATA"                       , 0x00021078, 31, 0 },
{"MAC_DCU_TXFILTER_DCU8_63_32", "DATA"                       , 0x0002107c, 31, 0 },
{"MAC_DCU_RETRY_LIMIT[0]", "SDFL"                            , 0x00021080, 19, 14},
{"MAC_DCU_RETRY_LIMIT[0]", "SRFL"                            , 0x00021080, 13, 8 },
{"MAC_DCU_RETRY_LIMIT[0]", "FRFL"                            , 0x00021080, 3 , 0 },
{"MAC_DCU_RETRY_LIMIT[1]", "SDFL"                            , 0x00021084, 19, 14},
{"MAC_DCU_RETRY_LIMIT[1]", "SRFL"                            , 0x00021084, 13, 8 },
{"MAC_DCU_RETRY_LIMIT[1]", "FRFL"                            , 0x00021084, 3 , 0 },
{"MAC_DCU_RETRY_LIMIT[2]", "SDFL"                            , 0x00021088, 19, 14},
{"MAC_DCU_RETRY_LIMIT[2]", "SRFL"                            , 0x00021088, 13, 8 },
{"MAC_DCU_RETRY_LIMIT[2]", "FRFL"                            , 0x00021088, 3 , 0 },
{"MAC_DCU_RETRY_LIMIT[3]", "SDFL"                            , 0x0002108c, 19, 14},
{"MAC_DCU_RETRY_LIMIT[3]", "SRFL"                            , 0x0002108c, 13, 8 },
{"MAC_DCU_RETRY_LIMIT[3]", "FRFL"                            , 0x0002108c, 3 , 0 },
{"MAC_DCU_RETRY_LIMIT[4]", "SDFL"                            , 0x00021090, 19, 14},
{"MAC_DCU_RETRY_LIMIT[4]", "SRFL"                            , 0x00021090, 13, 8 },
{"MAC_DCU_RETRY_LIMIT[4]", "FRFL"                            , 0x00021090, 3 , 0 },
{"MAC_DCU_RETRY_LIMIT[5]", "SDFL"                            , 0x00021094, 19, 14},
{"MAC_DCU_RETRY_LIMIT[5]", "SRFL"                            , 0x00021094, 13, 8 },
{"MAC_DCU_RETRY_LIMIT[5]", "FRFL"                            , 0x00021094, 3 , 0 },
{"MAC_DCU_RETRY_LIMIT[6]", "SDFL"                            , 0x00021098, 19, 14},
{"MAC_DCU_RETRY_LIMIT[6]", "SRFL"                            , 0x00021098, 13, 8 },
{"MAC_DCU_RETRY_LIMIT[6]", "FRFL"                            , 0x00021098, 3 , 0 },
{"MAC_DCU_RETRY_LIMIT[7]", "SDFL"                            , 0x0002109c, 19, 14},
{"MAC_DCU_RETRY_LIMIT[7]", "SRFL"                            , 0x0002109c, 13, 8 },
{"MAC_DCU_RETRY_LIMIT[7]", "FRFL"                            , 0x0002109c, 3 , 0 },
{"MAC_DCU_RETRY_LIMIT[8]", "SDFL"                            , 0x000210a0, 19, 14},
{"MAC_DCU_RETRY_LIMIT[8]", "SRFL"                            , 0x000210a0, 13, 8 },
{"MAC_DCU_RETRY_LIMIT[8]", "FRFL"                            , 0x000210a0, 3 , 0 },
{"MAC_DCU_RETRY_LIMIT[9]", "SDFL"                            , 0x000210a4, 19, 14},
{"MAC_DCU_RETRY_LIMIT[9]", "SRFL"                            , 0x000210a4, 13, 8 },
{"MAC_DCU_RETRY_LIMIT[9]", "FRFL"                            , 0x000210a4, 3 , 0 },
{"MAC_DCU_GBL_IFS_EIFS", "DURATION"                          , 0x000210b0, 15, 0 },
{"MAC_DCU_TXFILTER_DCU0_95_64", "DATA"                       , 0x000210b8, 31, 0 },
{"MAC_DCU_TXFILTER_DCU8_95_64", "DATA"                       , 0x000210bc, 31, 0 },
{"MAC_DCU_CHANNEL_TIME[0]", "ENABLE"                         , 0x000210c0, 20, 20},
{"MAC_DCU_CHANNEL_TIME[0]", "DURATION"                       , 0x000210c0, 19, 0 },
{"MAC_DCU_CHANNEL_TIME[1]", "ENABLE"                         , 0x000210c4, 20, 20},
{"MAC_DCU_CHANNEL_TIME[1]", "DURATION"                       , 0x000210c4, 19, 0 },
{"MAC_DCU_CHANNEL_TIME[2]", "ENABLE"                         , 0x000210c8, 20, 20},
{"MAC_DCU_CHANNEL_TIME[2]", "DURATION"                       , 0x000210c8, 19, 0 },
{"MAC_DCU_CHANNEL_TIME[3]", "ENABLE"                         , 0x000210cc, 20, 20},
{"MAC_DCU_CHANNEL_TIME[3]", "DURATION"                       , 0x000210cc, 19, 0 },
{"MAC_DCU_CHANNEL_TIME[4]", "ENABLE"                         , 0x000210d0, 20, 20},
{"MAC_DCU_CHANNEL_TIME[4]", "DURATION"                       , 0x000210d0, 19, 0 },
{"MAC_DCU_CHANNEL_TIME[5]", "ENABLE"                         , 0x000210d4, 20, 20},
{"MAC_DCU_CHANNEL_TIME[5]", "DURATION"                       , 0x000210d4, 19, 0 },
{"MAC_DCU_CHANNEL_TIME[6]", "ENABLE"                         , 0x000210d8, 20, 20},
{"MAC_DCU_CHANNEL_TIME[6]", "DURATION"                       , 0x000210d8, 19, 0 },
{"MAC_DCU_CHANNEL_TIME[7]", "ENABLE"                         , 0x000210dc, 20, 20},
{"MAC_DCU_CHANNEL_TIME[7]", "DURATION"                       , 0x000210dc, 19, 0 },
{"MAC_DCU_CHANNEL_TIME[8]", "ENABLE"                         , 0x000210e0, 20, 20},
{"MAC_DCU_CHANNEL_TIME[8]", "DURATION"                       , 0x000210e0, 19, 0 },
{"MAC_DCU_CHANNEL_TIME[9]", "ENABLE"                         , 0x000210e4, 20, 20},
{"MAC_DCU_CHANNEL_TIME[9]", "DURATION"                       , 0x000210e4, 19, 0 },
{"MAC_DCU_GBL_IFS_MISC", "SLOT_COUNT_RST_UNCOND"             , 0x000210f0, 29, 29},
{"MAC_DCU_GBL_IFS_MISC", "IGNORE_BACKOFF"                    , 0x000210f0, 28, 28},
{"MAC_DCU_GBL_IFS_MISC", "CHAN_SLOT_ALWAYS"                  , 0x000210f0, 27, 27},
{"MAC_DCU_GBL_IFS_MISC", "CHAN_SLOT_WIN_DUR"                 , 0x000210f0, 26, 25},
{"MAC_DCU_GBL_IFS_MISC", "LFSR_SLICE_RANDOM_DIS"             , 0x000210f0, 24, 24},
{"MAC_DCU_GBL_IFS_MISC", "AIFS_RST_UNCOND"                   , 0x000210f0, 23, 23},
{"MAC_DCU_GBL_IFS_MISC", "SIFS_RST_UNCOND"                   , 0x000210f0, 22, 22},
{"MAC_DCU_GBL_IFS_MISC", "ARB_DLY"                           , 0x000210f0, 21, 20},
{"MAC_DCU_GBL_IFS_MISC", "SIFS_DUR_USEC"                     , 0x000210f0, 9 , 4 },
{"MAC_DCU_GBL_IFS_MISC", "TURBO_MODE"                        , 0x000210f0, 3 , 3 },
{"MAC_DCU_GBL_IFS_MISC", "LFSR_SLICE_SEL"                    , 0x000210f0, 2 , 0 },
{"MAC_DCU_TXFILTER_DCU0_127_96", "DATA"                      , 0x000210f8, 31, 0 },
{"MAC_DCU_TXFILTER_DCU8_127_96", "DATA"                      , 0x000210fc, 31, 0 },
{"MAC_DCU_MISC[0]", "SIFS_BURST_CHAN_BUSY_IGNORE"            , 0x00021100, 24, 24},
{"MAC_DCU_MISC[0]", "RETRY_ON_BLOWN_IFS_EN"                  , 0x00021100, 23, 23},
{"MAC_DCU_MISC[0]", "VIRT_COLL_CW_INC_EN"                    , 0x00021100, 22, 22},
{"MAC_DCU_MISC[0]", "POST_BKOFF_SKIP"                        , 0x00021100, 21, 21},
{"MAC_DCU_MISC[0]", "SEQNUM_FREEZE"                          , 0x00021100, 20, 20},
{"MAC_DCU_MISC[0]", "LOCKOUT_IGNORE"                         , 0x00021100, 19, 19},
{"MAC_DCU_MISC[0]", "LOCKOUT_GBL_EN"                         , 0x00021100, 18, 18},
{"MAC_DCU_MISC[0]", "ARB_LOCKOUT_IF_EN"                      , 0x00021100, 17, 17},
{"MAC_DCU_MISC[0]", "IS_BCN"                                 , 0x00021100, 16, 16},
{"MAC_DCU_MISC[0]", "VIRT_COLL_POLICY"                       , 0x00021100, 15, 14},
{"MAC_DCU_MISC[0]", "BKOFF_PF"                               , 0x00021100, 12, 12},
{"MAC_DCU_MISC[0]", "HCF_POLL_EN"                            , 0x00021100, 11, 11},
{"MAC_DCU_MISC[0]", "FRAG_BURST_BKOFF_EN"                    , 0x00021100, 9 , 9 },
{"MAC_DCU_MISC[0]", "FRAG_BURST_WAIT_QCU_EN"                 , 0x00021100, 8 , 8 },
{"MAC_DCU_MISC[0]", "CW_RST_AT_TS_END_DIS"                   , 0x00021100, 7 , 7 },
{"MAC_DCU_MISC[0]", "SFC_RST_AT_TS_END_EN"                   , 0x00021100, 6 , 6 },
{"MAC_DCU_MISC[0]", "BKOFF_THRESH"                           , 0x00021100, 5 , 0 },
{"MAC_DCU_MISC[1]", "SIFS_BURST_CHAN_BUSY_IGNORE"            , 0x00021104, 24, 24},
{"MAC_DCU_MISC[1]", "RETRY_ON_BLOWN_IFS_EN"                  , 0x00021104, 23, 23},
{"MAC_DCU_MISC[1]", "VIRT_COLL_CW_INC_EN"                    , 0x00021104, 22, 22},
{"MAC_DCU_MISC[1]", "POST_BKOFF_SKIP"                        , 0x00021104, 21, 21},
{"MAC_DCU_MISC[1]", "SEQNUM_FREEZE"                          , 0x00021104, 20, 20},
{"MAC_DCU_MISC[1]", "LOCKOUT_IGNORE"                         , 0x00021104, 19, 19},
{"MAC_DCU_MISC[1]", "LOCKOUT_GBL_EN"                         , 0x00021104, 18, 18},
{"MAC_DCU_MISC[1]", "ARB_LOCKOUT_IF_EN"                      , 0x00021104, 17, 17},
{"MAC_DCU_MISC[1]", "IS_BCN"                                 , 0x00021104, 16, 16},
{"MAC_DCU_MISC[1]", "VIRT_COLL_POLICY"                       , 0x00021104, 15, 14},
{"MAC_DCU_MISC[1]", "BKOFF_PF"                               , 0x00021104, 12, 12},
{"MAC_DCU_MISC[1]", "HCF_POLL_EN"                            , 0x00021104, 11, 11},
{"MAC_DCU_MISC[1]", "FRAG_BURST_BKOFF_EN"                    , 0x00021104, 9 , 9 },
{"MAC_DCU_MISC[1]", "FRAG_BURST_WAIT_QCU_EN"                 , 0x00021104, 8 , 8 },
{"MAC_DCU_MISC[1]", "CW_RST_AT_TS_END_DIS"                   , 0x00021104, 7 , 7 },
{"MAC_DCU_MISC[1]", "SFC_RST_AT_TS_END_EN"                   , 0x00021104, 6 , 6 },
{"MAC_DCU_MISC[1]", "BKOFF_THRESH"                           , 0x00021104, 5 , 0 },
{"MAC_DCU_MISC[2]", "SIFS_BURST_CHAN_BUSY_IGNORE"            , 0x00021108, 24, 24},
{"MAC_DCU_MISC[2]", "RETRY_ON_BLOWN_IFS_EN"                  , 0x00021108, 23, 23},
{"MAC_DCU_MISC[2]", "VIRT_COLL_CW_INC_EN"                    , 0x00021108, 22, 22},
{"MAC_DCU_MISC[2]", "POST_BKOFF_SKIP"                        , 0x00021108, 21, 21},
{"MAC_DCU_MISC[2]", "SEQNUM_FREEZE"                          , 0x00021108, 20, 20},
{"MAC_DCU_MISC[2]", "LOCKOUT_IGNORE"                         , 0x00021108, 19, 19},
{"MAC_DCU_MISC[2]", "LOCKOUT_GBL_EN"                         , 0x00021108, 18, 18},
{"MAC_DCU_MISC[2]", "ARB_LOCKOUT_IF_EN"                      , 0x00021108, 17, 17},
{"MAC_DCU_MISC[2]", "IS_BCN"                                 , 0x00021108, 16, 16},
{"MAC_DCU_MISC[2]", "VIRT_COLL_POLICY"                       , 0x00021108, 15, 14},
{"MAC_DCU_MISC[2]", "BKOFF_PF"                               , 0x00021108, 12, 12},
{"MAC_DCU_MISC[2]", "HCF_POLL_EN"                            , 0x00021108, 11, 11},
{"MAC_DCU_MISC[2]", "FRAG_BURST_BKOFF_EN"                    , 0x00021108, 9 , 9 },
{"MAC_DCU_MISC[2]", "FRAG_BURST_WAIT_QCU_EN"                 , 0x00021108, 8 , 8 },
{"MAC_DCU_MISC[2]", "CW_RST_AT_TS_END_DIS"                   , 0x00021108, 7 , 7 },
{"MAC_DCU_MISC[2]", "SFC_RST_AT_TS_END_EN"                   , 0x00021108, 6 , 6 },
{"MAC_DCU_MISC[2]", "BKOFF_THRESH"                           , 0x00021108, 5 , 0 },
{"MAC_DCU_MISC[3]", "SIFS_BURST_CHAN_BUSY_IGNORE"            , 0x0002110c, 24, 24},
{"MAC_DCU_MISC[3]", "RETRY_ON_BLOWN_IFS_EN"                  , 0x0002110c, 23, 23},
{"MAC_DCU_MISC[3]", "VIRT_COLL_CW_INC_EN"                    , 0x0002110c, 22, 22},
{"MAC_DCU_MISC[3]", "POST_BKOFF_SKIP"                        , 0x0002110c, 21, 21},
{"MAC_DCU_MISC[3]", "SEQNUM_FREEZE"                          , 0x0002110c, 20, 20},
{"MAC_DCU_MISC[3]", "LOCKOUT_IGNORE"                         , 0x0002110c, 19, 19},
{"MAC_DCU_MISC[3]", "LOCKOUT_GBL_EN"                         , 0x0002110c, 18, 18},
{"MAC_DCU_MISC[3]", "ARB_LOCKOUT_IF_EN"                      , 0x0002110c, 17, 17},
{"MAC_DCU_MISC[3]", "IS_BCN"                                 , 0x0002110c, 16, 16},
{"MAC_DCU_MISC[3]", "VIRT_COLL_POLICY"                       , 0x0002110c, 15, 14},
{"MAC_DCU_MISC[3]", "BKOFF_PF"                               , 0x0002110c, 12, 12},
{"MAC_DCU_MISC[3]", "HCF_POLL_EN"                            , 0x0002110c, 11, 11},
{"MAC_DCU_MISC[3]", "FRAG_BURST_BKOFF_EN"                    , 0x0002110c, 9 , 9 },
{"MAC_DCU_MISC[3]", "FRAG_BURST_WAIT_QCU_EN"                 , 0x0002110c, 8 , 8 },
{"MAC_DCU_MISC[3]", "CW_RST_AT_TS_END_DIS"                   , 0x0002110c, 7 , 7 },
{"MAC_DCU_MISC[3]", "SFC_RST_AT_TS_END_EN"                   , 0x0002110c, 6 , 6 },
{"MAC_DCU_MISC[3]", "BKOFF_THRESH"                           , 0x0002110c, 5 , 0 },
{"MAC_DCU_MISC[4]", "SIFS_BURST_CHAN_BUSY_IGNORE"            , 0x00021110, 24, 24},
{"MAC_DCU_MISC[4]", "RETRY_ON_BLOWN_IFS_EN"                  , 0x00021110, 23, 23},
{"MAC_DCU_MISC[4]", "VIRT_COLL_CW_INC_EN"                    , 0x00021110, 22, 22},
{"MAC_DCU_MISC[4]", "POST_BKOFF_SKIP"                        , 0x00021110, 21, 21},
{"MAC_DCU_MISC[4]", "SEQNUM_FREEZE"                          , 0x00021110, 20, 20},
{"MAC_DCU_MISC[4]", "LOCKOUT_IGNORE"                         , 0x00021110, 19, 19},
{"MAC_DCU_MISC[4]", "LOCKOUT_GBL_EN"                         , 0x00021110, 18, 18},
{"MAC_DCU_MISC[4]", "ARB_LOCKOUT_IF_EN"                      , 0x00021110, 17, 17},
{"MAC_DCU_MISC[4]", "IS_BCN"                                 , 0x00021110, 16, 16},
{"MAC_DCU_MISC[4]", "VIRT_COLL_POLICY"                       , 0x00021110, 15, 14},
{"MAC_DCU_MISC[4]", "BKOFF_PF"                               , 0x00021110, 12, 12},
{"MAC_DCU_MISC[4]", "HCF_POLL_EN"                            , 0x00021110, 11, 11},
{"MAC_DCU_MISC[4]", "FRAG_BURST_BKOFF_EN"                    , 0x00021110, 9 , 9 },
{"MAC_DCU_MISC[4]", "FRAG_BURST_WAIT_QCU_EN"                 , 0x00021110, 8 , 8 },
{"MAC_DCU_MISC[4]", "CW_RST_AT_TS_END_DIS"                   , 0x00021110, 7 , 7 },
{"MAC_DCU_MISC[4]", "SFC_RST_AT_TS_END_EN"                   , 0x00021110, 6 , 6 },
{"MAC_DCU_MISC[4]", "BKOFF_THRESH"                           , 0x00021110, 5 , 0 },
{"MAC_DCU_MISC[5]", "SIFS_BURST_CHAN_BUSY_IGNORE"            , 0x00021114, 24, 24},
{"MAC_DCU_MISC[5]", "RETRY_ON_BLOWN_IFS_EN"                  , 0x00021114, 23, 23},
{"MAC_DCU_MISC[5]", "VIRT_COLL_CW_INC_EN"                    , 0x00021114, 22, 22},
{"MAC_DCU_MISC[5]", "POST_BKOFF_SKIP"                        , 0x00021114, 21, 21},
{"MAC_DCU_MISC[5]", "SEQNUM_FREEZE"                          , 0x00021114, 20, 20},
{"MAC_DCU_MISC[5]", "LOCKOUT_IGNORE"                         , 0x00021114, 19, 19},
{"MAC_DCU_MISC[5]", "LOCKOUT_GBL_EN"                         , 0x00021114, 18, 18},
{"MAC_DCU_MISC[5]", "ARB_LOCKOUT_IF_EN"                      , 0x00021114, 17, 17},
{"MAC_DCU_MISC[5]", "IS_BCN"                                 , 0x00021114, 16, 16},
{"MAC_DCU_MISC[5]", "VIRT_COLL_POLICY"                       , 0x00021114, 15, 14},
{"MAC_DCU_MISC[5]", "BKOFF_PF"                               , 0x00021114, 12, 12},
{"MAC_DCU_MISC[5]", "HCF_POLL_EN"                            , 0x00021114, 11, 11},
{"MAC_DCU_MISC[5]", "FRAG_BURST_BKOFF_EN"                    , 0x00021114, 9 , 9 },
{"MAC_DCU_MISC[5]", "FRAG_BURST_WAIT_QCU_EN"                 , 0x00021114, 8 , 8 },
{"MAC_DCU_MISC[5]", "CW_RST_AT_TS_END_DIS"                   , 0x00021114, 7 , 7 },
{"MAC_DCU_MISC[5]", "SFC_RST_AT_TS_END_EN"                   , 0x00021114, 6 , 6 },
{"MAC_DCU_MISC[5]", "BKOFF_THRESH"                           , 0x00021114, 5 , 0 },
{"MAC_DCU_MISC[6]", "SIFS_BURST_CHAN_BUSY_IGNORE"            , 0x00021118, 24, 24},
{"MAC_DCU_MISC[6]", "RETRY_ON_BLOWN_IFS_EN"                  , 0x00021118, 23, 23},
{"MAC_DCU_MISC[6]", "VIRT_COLL_CW_INC_EN"                    , 0x00021118, 22, 22},
{"MAC_DCU_MISC[6]", "POST_BKOFF_SKIP"                        , 0x00021118, 21, 21},
{"MAC_DCU_MISC[6]", "SEQNUM_FREEZE"                          , 0x00021118, 20, 20},
{"MAC_DCU_MISC[6]", "LOCKOUT_IGNORE"                         , 0x00021118, 19, 19},
{"MAC_DCU_MISC[6]", "LOCKOUT_GBL_EN"                         , 0x00021118, 18, 18},
{"MAC_DCU_MISC[6]", "ARB_LOCKOUT_IF_EN"                      , 0x00021118, 17, 17},
{"MAC_DCU_MISC[6]", "IS_BCN"                                 , 0x00021118, 16, 16},
{"MAC_DCU_MISC[6]", "VIRT_COLL_POLICY"                       , 0x00021118, 15, 14},
{"MAC_DCU_MISC[6]", "BKOFF_PF"                               , 0x00021118, 12, 12},
{"MAC_DCU_MISC[6]", "HCF_POLL_EN"                            , 0x00021118, 11, 11},
{"MAC_DCU_MISC[6]", "FRAG_BURST_BKOFF_EN"                    , 0x00021118, 9 , 9 },
{"MAC_DCU_MISC[6]", "FRAG_BURST_WAIT_QCU_EN"                 , 0x00021118, 8 , 8 },
{"MAC_DCU_MISC[6]", "CW_RST_AT_TS_END_DIS"                   , 0x00021118, 7 , 7 },
{"MAC_DCU_MISC[6]", "SFC_RST_AT_TS_END_EN"                   , 0x00021118, 6 , 6 },
{"MAC_DCU_MISC[6]", "BKOFF_THRESH"                           , 0x00021118, 5 , 0 },
{"MAC_DCU_MISC[7]", "SIFS_BURST_CHAN_BUSY_IGNORE"            , 0x0002111c, 24, 24},
{"MAC_DCU_MISC[7]", "RETRY_ON_BLOWN_IFS_EN"                  , 0x0002111c, 23, 23},
{"MAC_DCU_MISC[7]", "VIRT_COLL_CW_INC_EN"                    , 0x0002111c, 22, 22},
{"MAC_DCU_MISC[7]", "POST_BKOFF_SKIP"                        , 0x0002111c, 21, 21},
{"MAC_DCU_MISC[7]", "SEQNUM_FREEZE"                          , 0x0002111c, 20, 20},
{"MAC_DCU_MISC[7]", "LOCKOUT_IGNORE"                         , 0x0002111c, 19, 19},
{"MAC_DCU_MISC[7]", "LOCKOUT_GBL_EN"                         , 0x0002111c, 18, 18},
{"MAC_DCU_MISC[7]", "ARB_LOCKOUT_IF_EN"                      , 0x0002111c, 17, 17},
{"MAC_DCU_MISC[7]", "IS_BCN"                                 , 0x0002111c, 16, 16},
{"MAC_DCU_MISC[7]", "VIRT_COLL_POLICY"                       , 0x0002111c, 15, 14},
{"MAC_DCU_MISC[7]", "BKOFF_PF"                               , 0x0002111c, 12, 12},
{"MAC_DCU_MISC[7]", "HCF_POLL_EN"                            , 0x0002111c, 11, 11},
{"MAC_DCU_MISC[7]", "FRAG_BURST_BKOFF_EN"                    , 0x0002111c, 9 , 9 },
{"MAC_DCU_MISC[7]", "FRAG_BURST_WAIT_QCU_EN"                 , 0x0002111c, 8 , 8 },
{"MAC_DCU_MISC[7]", "CW_RST_AT_TS_END_DIS"                   , 0x0002111c, 7 , 7 },
{"MAC_DCU_MISC[7]", "SFC_RST_AT_TS_END_EN"                   , 0x0002111c, 6 , 6 },
{"MAC_DCU_MISC[7]", "BKOFF_THRESH"                           , 0x0002111c, 5 , 0 },
{"MAC_DCU_MISC[8]", "SIFS_BURST_CHAN_BUSY_IGNORE"            , 0x00021120, 24, 24},
{"MAC_DCU_MISC[8]", "RETRY_ON_BLOWN_IFS_EN"                  , 0x00021120, 23, 23},
{"MAC_DCU_MISC[8]", "VIRT_COLL_CW_INC_EN"                    , 0x00021120, 22, 22},
{"MAC_DCU_MISC[8]", "POST_BKOFF_SKIP"                        , 0x00021120, 21, 21},
{"MAC_DCU_MISC[8]", "SEQNUM_FREEZE"                          , 0x00021120, 20, 20},
{"MAC_DCU_MISC[8]", "LOCKOUT_IGNORE"                         , 0x00021120, 19, 19},
{"MAC_DCU_MISC[8]", "LOCKOUT_GBL_EN"                         , 0x00021120, 18, 18},
{"MAC_DCU_MISC[8]", "ARB_LOCKOUT_IF_EN"                      , 0x00021120, 17, 17},
{"MAC_DCU_MISC[8]", "IS_BCN"                                 , 0x00021120, 16, 16},
{"MAC_DCU_MISC[8]", "VIRT_COLL_POLICY"                       , 0x00021120, 15, 14},
{"MAC_DCU_MISC[8]", "BKOFF_PF"                               , 0x00021120, 12, 12},
{"MAC_DCU_MISC[8]", "HCF_POLL_EN"                            , 0x00021120, 11, 11},
{"MAC_DCU_MISC[8]", "FRAG_BURST_BKOFF_EN"                    , 0x00021120, 9 , 9 },
{"MAC_DCU_MISC[8]", "FRAG_BURST_WAIT_QCU_EN"                 , 0x00021120, 8 , 8 },
{"MAC_DCU_MISC[8]", "CW_RST_AT_TS_END_DIS"                   , 0x00021120, 7 , 7 },
{"MAC_DCU_MISC[8]", "SFC_RST_AT_TS_END_EN"                   , 0x00021120, 6 , 6 },
{"MAC_DCU_MISC[8]", "BKOFF_THRESH"                           , 0x00021120, 5 , 0 },
{"MAC_DCU_MISC[9]", "SIFS_BURST_CHAN_BUSY_IGNORE"            , 0x00021124, 24, 24},
{"MAC_DCU_MISC[9]", "RETRY_ON_BLOWN_IFS_EN"                  , 0x00021124, 23, 23},
{"MAC_DCU_MISC[9]", "VIRT_COLL_CW_INC_EN"                    , 0x00021124, 22, 22},
{"MAC_DCU_MISC[9]", "POST_BKOFF_SKIP"                        , 0x00021124, 21, 21},
{"MAC_DCU_MISC[9]", "SEQNUM_FREEZE"                          , 0x00021124, 20, 20},
{"MAC_DCU_MISC[9]", "LOCKOUT_IGNORE"                         , 0x00021124, 19, 19},
{"MAC_DCU_MISC[9]", "LOCKOUT_GBL_EN"                         , 0x00021124, 18, 18},
{"MAC_DCU_MISC[9]", "ARB_LOCKOUT_IF_EN"                      , 0x00021124, 17, 17},
{"MAC_DCU_MISC[9]", "IS_BCN"                                 , 0x00021124, 16, 16},
{"MAC_DCU_MISC[9]", "VIRT_COLL_POLICY"                       , 0x00021124, 15, 14},
{"MAC_DCU_MISC[9]", "BKOFF_PF"                               , 0x00021124, 12, 12},
{"MAC_DCU_MISC[9]", "HCF_POLL_EN"                            , 0x00021124, 11, 11},
{"MAC_DCU_MISC[9]", "FRAG_BURST_BKOFF_EN"                    , 0x00021124, 9 , 9 },
{"MAC_DCU_MISC[9]", "FRAG_BURST_WAIT_QCU_EN"                 , 0x00021124, 8 , 8 },
{"MAC_DCU_MISC[9]", "CW_RST_AT_TS_END_DIS"                   , 0x00021124, 7 , 7 },
{"MAC_DCU_MISC[9]", "SFC_RST_AT_TS_END_EN"                   , 0x00021124, 6 , 6 },
{"MAC_DCU_MISC[9]", "BKOFF_THRESH"                           , 0x00021124, 5 , 0 },
{"MAC_DCU_TXFILTER_DCU1_31_0", "DATA"                        , 0x00021138, 31, 0 },
{"MAC_DCU_TXFILTER_DCU9_31_0", "DATA"                        , 0x0002113c, 31, 0 },
{"MAC_DCU_SEQ", "NUM"                                        , 0x00021140, 31, 0 },
{"MAC_DCU_TXFILTER_DCU1_63_32", "DATA"                       , 0x00021178, 31, 0 },
{"MAC_DCU_TXFILTER_DCU9_63_32", "DATA"                       , 0x0002117c, 31, 0 },
{"MAC_DCU_TXFILTER_DCU1_95_64", "DATA"                       , 0x000211b8, 31, 0 },
{"MAC_DCU_TXFILTER_DCU9_95_64", "DATA"                       , 0x000211bc, 31, 0 },
{"MAC_DCU_TXFILTER_DCU1_127_96", "DATA"                      , 0x000211f8, 31, 0 },
{"MAC_DCU_TXFILTER_DCU9_127_96", "DATA"                      , 0x000211fc, 31, 0 },
{"MAC_DCU_TXFILTER_DCU2_31_0", "DATA"                        , 0x00021238, 31, 0 },
{"MAC_DCU_PAUSE", "STATUS"                                   , 0x00021270, 16, 16},
{"MAC_DCU_PAUSE", "REQUEST"                                  , 0x00021270, 9 , 0 },
{"MAC_DCU_TXFILTER_DCU2_63_32", "DATA"                       , 0x00021278, 31, 0 },
{"MAC_DCU_WOW_KACFG", "RX_TIMEOUT_CNT"                       , 0x000212b0, 23, 12},
{"MAC_DCU_WOW_KACFG", "BCN_CNT"                              , 0x000212b0, 11, 4 },
{"MAC_DCU_WOW_KACFG", "TIM_EN"                               , 0x000212b0, 1 , 1 },
{"MAC_DCU_WOW_KACFG", "TX_EN"                                , 0x000212b0, 0 , 0 },
{"MAC_DCU_TXFILTER_DCU2_95_64", "DATA"                       , 0x000212b8, 31, 0 },
{"MAC_DCU_TXSLOT", "MASK"                                    , 0x000212f0, 15, 0 },
{"MAC_DCU_TXFILTER_DCU2_127_96", "DATA"                      , 0x000212f8, 31, 0 },
{"MAC_DCU_TXFILTER_DCU3_31_0", "DATA"                        , 0x00021338, 31, 0 },
{"MAC_DCU_TXFILTER_DCU3_63_32", "DATA"                       , 0x00021378, 31, 0 },
{"MAC_DCU_TXFILTER_DCU3_95_64", "DATA"                       , 0x000213b8, 31, 0 },
{"MAC_DCU_TXFILTER_DCU3_127_96", "DATA"                      , 0x000213f8, 31, 0 },
{"MAC_DCU_TXFILTER_DCU4_31_0", "DATA"                        , 0x00021438, 31, 0 },
{"MAC_DCU_TXFILTER_CLEAR", "DATA"                            , 0x0002143c, 31, 0 },
{"MAC_DCU_TXFILTER_DCU4_63_32", "DATA"                       , 0x00021478, 31, 0 },
{"MAC_DCU_TXFILTER_SET", "DATA"                              , 0x0002147c, 31, 0 },
{"MAC_DCU_TXFILTER_DCU4_95_64", "DATA"                       , 0x000214b8, 31, 0 },
{"MAC_DCU_TXFILTER_DCU4_127_96", "DATA"                      , 0x000214f8, 31, 0 },
{"MAC_DCU_TXFILTER_DCU5_31_0", "DATA"                        , 0x00021538, 31, 0 },
{"MAC_DCU_TXFILTER_DCU5_63_32", "DATA"                       , 0x00021578, 31, 0 },
{"MAC_DCU_TXFILTER_DCU5_95_64", "DATA"                       , 0x000215b8, 31, 0 },
{"MAC_DCU_TXFILTER_DCU5_127_96", "DATA"                      , 0x000215f8, 31, 0 },
{"MAC_DCU_TXFILTER_DCU6_31_0", "DATA"                        , 0x00021638, 31, 0 },
{"MAC_DCU_TXFILTER_DCU6_63_32", "DATA"                       , 0x00021678, 31, 0 },
{"MAC_DCU_TXFILTER_DCU6_95_64", "DATA"                       , 0x000216b8, 31, 0 },
{"MAC_DCU_TXFILTER_DCU6_127_96", "DATA"                      , 0x000216f8, 31, 0 },
{"MAC_DCU_TXFILTER_DCU7_31_0", "DATA"                        , 0x00021738, 31, 0 },
{"MAC_DCU_TXFILTER_DCU7_63_32", "DATA"                       , 0x00021778, 31, 0 },
{"MAC_DCU_TXFILTER_DCU7_95_64", "DATA"                       , 0x000217b8, 31, 0 },
{"MAC_DCU_TXFILTER_DCU7_127_96", "DATA"                      , 0x000217f8, 31, 0 },
{"OLE_L2_WLAN_LLC_0", "ENABLE"                               , 0x00027000, 24, 24},
{"OLE_L2_WLAN_LLC_0", "BYTE6"                                , 0x00027000, 23, 16},
{"OLE_L2_WLAN_LLC_0", "TYPE"                                 , 0x00027000, 15, 0 },
{"OLE_L2_WLAN_LLC_1", "ENABLE"                               , 0x00027004, 24, 24},
{"OLE_L2_WLAN_LLC_1", "BYTE6"                                , 0x00027004, 23, 16},
{"OLE_L2_WLAN_LLC_1", "TYPE"                                 , 0x00027004, 15, 0 },
{"OLE_L2_WLAN_LLC_2", "ENABLE"                               , 0x00027008, 24, 24},
{"OLE_L2_WLAN_LLC_2", "BYTE6"                                , 0x00027008, 23, 16},
{"OLE_L2_WLAN_LLC_2", "TYPE"                                 , 0x00027008, 15, 0 },
{"OLE_L2_WLAN_LLC_3", "ENABLE"                               , 0x0002700c, 24, 24},
{"OLE_L2_WLAN_LLC_3", "BYTE6"                                , 0x0002700c, 23, 16},
{"OLE_L2_WLAN_LLC_3", "TYPE"                                 , 0x0002700c, 15, 0 },
{"OLE_L2_WLAN_LLC_4", "ENABLE"                               , 0x00027010, 24, 24},
{"OLE_L2_WLAN_LLC_4", "BYTE6"                                , 0x00027010, 23, 16},
{"OLE_L2_WLAN_LLC_4", "TYPE"                                 , 0x00027010, 15, 0 },
{"OLE_L2_WLAN_LLC_5", "ENABLE"                               , 0x00027014, 24, 24},
{"OLE_L2_WLAN_LLC_5", "BYTE6"                                , 0x00027014, 23, 16},
{"OLE_L2_WLAN_LLC_5", "TYPE"                                 , 0x00027014, 15, 0 },
{"OLE_L2_WLAN_LLC_6", "ENABLE"                               , 0x00027018, 24, 24},
{"OLE_L2_WLAN_LLC_6", "BYTE6"                                , 0x00027018, 23, 16},
{"OLE_L2_WLAN_LLC_6", "TYPE"                                 , 0x00027018, 15, 0 },
{"OLE_RX_CONFIG", "RX_HDR_BYTELEN"                           , 0x00027020, 7 , 0 },
{"OLE_RX_CONFIG_RING0", "RESERVED_2"                         , 0x00027024, 31, 28},
{"OLE_RX_CONFIG_RING0", "ETHERNET_3"                         , 0x00027024, 27, 27},
{"OLE_RX_CONFIG_RING0", "ETHERNET_2"                         , 0x00027024, 26, 26},
{"OLE_RX_CONFIG_RING0", "ETHERNET_1"                         , 0x00027024, 25, 25},
{"OLE_RX_CONFIG_RING0", "ETHERNET_0"                         , 0x00027024, 24, 24},
{"OLE_RX_CONFIG_RING0", "RESERVED_1"                         , 0x00027024, 23, 22},
{"OLE_RX_CONFIG_RING0", "PHY_DATA_TYPE"                      , 0x00027024, 21, 21},
{"OLE_RX_CONFIG_RING0", "NULL_DATA_TYPE"                     , 0x00027024, 20, 20},
{"OLE_RX_CONFIG_RING0", "MCAST_DATA_TYPE"                    , 0x00027024, 19, 19},
{"OLE_RX_CONFIG_RING0", "UCAST_DATA_TYPE"                    , 0x00027024, 18, 18},
{"OLE_RX_CONFIG_RING0", "MGMT_TYPE"                          , 0x00027024, 17, 17},
{"OLE_RX_CONFIG_RING0", "CTRL_TYPE"                          , 0x00027024, 16, 16},
{"OLE_RX_CONFIG_RING0", "RESERVED_0"                         , 0x00027024, 15, 10},
{"OLE_RX_CONFIG_RING0", "FRAG_INFO"                          , 0x00027024, 9 , 9 },
{"OLE_RX_CONFIG_RING0", "ATTENTION"                          , 0x00027024, 8 , 8 },
{"OLE_RX_CONFIG_RING0", "PPDU_END"                           , 0x00027024, 7 , 7 },
{"OLE_RX_CONFIG_RING0", "MPDU_END"                           , 0x00027024, 6 , 6 },
{"OLE_RX_CONFIG_RING0", "MSDU_END"                           , 0x00027024, 5 , 5 },
{"OLE_RX_CONFIG_RING0", "PKT"                                , 0x00027024, 4 , 4 },
{"OLE_RX_CONFIG_RING0", "MSDU_START"                         , 0x00027024, 3 , 3 },
{"OLE_RX_CONFIG_RING0", "MPDU_START"                         , 0x00027024, 2 , 2 },
{"OLE_RX_CONFIG_RING0", "HDR"                                , 0x00027024, 1 , 1 },
{"OLE_RX_CONFIG_RING0", "PPDU_START"                         , 0x00027024, 0 , 0 },
{"OLE_RX_CONFIG_RING1", "RESERVED_2"                         , 0x00027028, 31, 28},
{"OLE_RX_CONFIG_RING1", "ETHERNET_3"                         , 0x00027028, 27, 27},
{"OLE_RX_CONFIG_RING1", "ETHERNET_2"                         , 0x00027028, 26, 26},
{"OLE_RX_CONFIG_RING1", "ETHERNET_1"                         , 0x00027028, 25, 25},
{"OLE_RX_CONFIG_RING1", "ETHERNET_0"                         , 0x00027028, 24, 24},
{"OLE_RX_CONFIG_RING1", "RESERVED_1"                         , 0x00027028, 23, 22},
{"OLE_RX_CONFIG_RING1", "PHY_DATA_TYPE"                      , 0x00027028, 21, 21},
{"OLE_RX_CONFIG_RING1", "NULL_DATA_TYPE"                     , 0x00027028, 20, 20},
{"OLE_RX_CONFIG_RING1", "MCAST_DATA_TYPE"                    , 0x00027028, 19, 19},
{"OLE_RX_CONFIG_RING1", "UCAST_DATA_TYPE"                    , 0x00027028, 18, 18},
{"OLE_RX_CONFIG_RING1", "MGMT_TYPE"                          , 0x00027028, 17, 17},
{"OLE_RX_CONFIG_RING1", "CTRL_TYPE"                          , 0x00027028, 16, 16},
{"OLE_RX_CONFIG_RING1", "RESERVED_0"                         , 0x00027028, 15, 10},
{"OLE_RX_CONFIG_RING1", "FRAG_INFO"                          , 0x00027028, 9 , 9 },
{"OLE_RX_CONFIG_RING1", "ATTENTION"                          , 0x00027028, 8 , 8 },
{"OLE_RX_CONFIG_RING1", "PPDU_END"                           , 0x00027028, 7 , 7 },
{"OLE_RX_CONFIG_RING1", "MPDU_END"                           , 0x00027028, 6 , 6 },
{"OLE_RX_CONFIG_RING1", "MSDU_END"                           , 0x00027028, 5 , 5 },
{"OLE_RX_CONFIG_RING1", "PKT"                                , 0x00027028, 4 , 4 },
{"OLE_RX_CONFIG_RING1", "MSDU_START"                         , 0x00027028, 3 , 3 },
{"OLE_RX_CONFIG_RING1", "MPDU_START"                         , 0x00027028, 2 , 2 },
{"OLE_RX_CONFIG_RING1", "HDR"                                , 0x00027028, 1 , 1 },
{"OLE_RX_CONFIG_RING1", "PPDU_START"                         , 0x00027028, 0 , 0 },
{"OLE_RX_CONFIG_RING2", "RESERVED_2"                         , 0x0002702c, 31, 28},
{"OLE_RX_CONFIG_RING2", "ETHERNET_3"                         , 0x0002702c, 27, 27},
{"OLE_RX_CONFIG_RING2", "ETHERNET_2"                         , 0x0002702c, 26, 26},
{"OLE_RX_CONFIG_RING2", "ETHERNET_1"                         , 0x0002702c, 25, 25},
{"OLE_RX_CONFIG_RING2", "ETHERNET_0"                         , 0x0002702c, 24, 24},
{"OLE_RX_CONFIG_RING2", "RESERVED_1"                         , 0x0002702c, 23, 22},
{"OLE_RX_CONFIG_RING2", "PHY_DATA_TYPE"                      , 0x0002702c, 21, 21},
{"OLE_RX_CONFIG_RING2", "NULL_DATA_TYPE"                     , 0x0002702c, 20, 20},
{"OLE_RX_CONFIG_RING2", "MCAST_DATA_TYPE"                    , 0x0002702c, 19, 19},
{"OLE_RX_CONFIG_RING2", "UCAST_DATA_TYPE"                    , 0x0002702c, 18, 18},
{"OLE_RX_CONFIG_RING2", "MGMT_TYPE"                          , 0x0002702c, 17, 17},
{"OLE_RX_CONFIG_RING2", "CTRL_TYPE"                          , 0x0002702c, 16, 16},
{"OLE_RX_CONFIG_RING2", "RESERVED_0"                         , 0x0002702c, 15, 10},
{"OLE_RX_CONFIG_RING2", "FRAG_INFO"                          , 0x0002702c, 9 , 9 },
{"OLE_RX_CONFIG_RING2", "ATTENTION"                          , 0x0002702c, 8 , 8 },
{"OLE_RX_CONFIG_RING2", "PPDU_END"                           , 0x0002702c, 7 , 7 },
{"OLE_RX_CONFIG_RING2", "MPDU_END"                           , 0x0002702c, 6 , 6 },
{"OLE_RX_CONFIG_RING2", "MSDU_END"                           , 0x0002702c, 5 , 5 },
{"OLE_RX_CONFIG_RING2", "PKT"                                , 0x0002702c, 4 , 4 },
{"OLE_RX_CONFIG_RING2", "MSDU_START"                         , 0x0002702c, 3 , 3 },
{"OLE_RX_CONFIG_RING2", "MPDU_START"                         , 0x0002702c, 2 , 2 },
{"OLE_RX_CONFIG_RING2", "HDR"                                , 0x0002702c, 1 , 1 },
{"OLE_RX_CONFIG_RING2", "PPDU_START"                         , 0x0002702c, 0 , 0 },
{"OLE_RX_CONFIG_RING3", "RESERVED_2"                         , 0x00027030, 31, 28},
{"OLE_RX_CONFIG_RING3", "ETHERNET_3"                         , 0x00027030, 27, 27},
{"OLE_RX_CONFIG_RING3", "ETHERNET_2"                         , 0x00027030, 26, 26},
{"OLE_RX_CONFIG_RING3", "ETHERNET_1"                         , 0x00027030, 25, 25},
{"OLE_RX_CONFIG_RING3", "ETHERNET_0"                         , 0x00027030, 24, 24},
{"OLE_RX_CONFIG_RING3", "RESERVED_1"                         , 0x00027030, 23, 22},
{"OLE_RX_CONFIG_RING3", "PHY_DATA_TYPE"                      , 0x00027030, 21, 21},
{"OLE_RX_CONFIG_RING3", "NULL_DATA_TYPE"                     , 0x00027030, 20, 20},
{"OLE_RX_CONFIG_RING3", "MCAST_DATA_TYPE"                    , 0x00027030, 19, 19},
{"OLE_RX_CONFIG_RING3", "UCAST_DATA_TYPE"                    , 0x00027030, 18, 18},
{"OLE_RX_CONFIG_RING3", "MGMT_TYPE"                          , 0x00027030, 17, 17},
{"OLE_RX_CONFIG_RING3", "CTRL_TYPE"                          , 0x00027030, 16, 16},
{"OLE_RX_CONFIG_RING3", "RESERVED_0"                         , 0x00027030, 15, 10},
{"OLE_RX_CONFIG_RING3", "FRAG_INFO"                          , 0x00027030, 9 , 9 },
{"OLE_RX_CONFIG_RING3", "ATTENTION"                          , 0x00027030, 8 , 8 },
{"OLE_RX_CONFIG_RING3", "PPDU_END"                           , 0x00027030, 7 , 7 },
{"OLE_RX_CONFIG_RING3", "MPDU_END"                           , 0x00027030, 6 , 6 },
{"OLE_RX_CONFIG_RING3", "MSDU_END"                           , 0x00027030, 5 , 5 },
{"OLE_RX_CONFIG_RING3", "PKT"                                , 0x00027030, 4 , 4 },
{"OLE_RX_CONFIG_RING3", "MSDU_START"                         , 0x00027030, 3 , 3 },
{"OLE_RX_CONFIG_RING3", "MPDU_START"                         , 0x00027030, 2 , 2 },
{"OLE_RX_CONFIG_RING3", "HDR"                                , 0x00027030, 1 , 1 },
{"OLE_RX_CONFIG_RING3", "PPDU_START"                         , 0x00027030, 0 , 0 },
{"OLE_DECAP_CONFIG", "CHECKSUM_TIMEOUT"                      , 0x00027034, 15, 8 },
{"OLE_DECAP_CONFIG", "CHECKSUM_DISABLE"                      , 0x00027034, 7 , 7 },
{"OLE_DECAP_CONFIG", "ONLY_DIRECTED_MCAST_BCAST"             , 0x00027034, 6 , 6 },
{"OLE_DECAP_CONFIG", "TCP_UDP_CHECKSUM_SEL"                  , 0x00027034, 5 , 5 },
{"OLE_DECAP_CONFIG", "IP_CHECKSUM_SEL"                       , 0x00027034, 4 , 4 },
{"OLE_DECAP_CONFIG", "UNKNOWN_LLC_DECAP_ENABLE"              , 0x00027034, 3 , 3 },
{"OLE_DECAP_CONFIG", "REMOVE_VLAN_TAG"                       , 0x00027034, 2 , 2 },
{"OLE_DECAP_CONFIG", "TARGET_FORMAT"                         , 0x00027034, 1 , 1 },
{"OLE_DECAP_CONFIG", "ENABLE"                                , 0x00027034, 0 , 0 },
{"OLE_HEADER_PADDING", "RX_INSERT_HEADER_PADDING"            , 0x00027038, 3 , 3 },
{"OLE_HEADER_PADDING", "RX_INPUT_HEADER_PADDING"             , 0x00027038, 2 , 2 },
{"OLE_HEADER_PADDING", "TX_INSERT_HEADER_PADDING"            , 0x00027038, 1 , 1 },
{"OLE_HEADER_PADDING", "TX_INPUT_HEADER_PADDING"             , 0x00027038, 0 , 0 },
{"OLE_DECAP_TABLE_0_HALF1", "SNAP_OR_TYPE2"                  , 0x0002703c, 25, 25},
{"OLE_DECAP_TABLE_0_HALF1", "ENABLE"                         , 0x0002703c, 24, 24},
{"OLE_DECAP_TABLE_0_HALF1", "OUI"                            , 0x0002703c, 23, 0 },
{"OLE_DECAP_TABLE_0_HALF2", "TYPE"                           , 0x00027040, 15, 0 },
{"OLE_DECAP_TABLE_1_HALF1", "SNAP_OR_TYPE2"                  , 0x00027044, 25, 25},
{"OLE_DECAP_TABLE_1_HALF1", "ENABLE"                         , 0x00027044, 24, 24},
{"OLE_DECAP_TABLE_1_HALF1", "OUI"                            , 0x00027044, 23, 0 },
{"OLE_DECAP_TABLE_1_HALF2", "TYPE"                           , 0x00027048, 15, 0 },
{"OLE_DECAP_TABLE_2_HALF1", "SNAP_OR_TYPE2"                  , 0x0002704c, 25, 25},
{"OLE_DECAP_TABLE_2_HALF1", "ENABLE"                         , 0x0002704c, 24, 24},
{"OLE_DECAP_TABLE_2_HALF1", "OUI"                            , 0x0002704c, 23, 0 },
{"OLE_DECAP_TABLE_2_HALF2", "TYPE"                           , 0x00027050, 15, 0 },
{"OLE_DECAP_TABLE_3_HALF1", "SNAP_OR_TYPE2"                  , 0x00027054, 25, 25},
{"OLE_DECAP_TABLE_3_HALF1", "ENABLE"                         , 0x00027054, 24, 24},
{"OLE_DECAP_TABLE_3_HALF1", "OUI"                            , 0x00027054, 23, 0 },
{"OLE_DECAP_TABLE_3_HALF2", "TYPE"                           , 0x00027058, 15, 0 },
{"OLE_DECAP_TABLE_4_HALF1", "SNAP_OR_TYPE2"                  , 0x0002705c, 25, 25},
{"OLE_DECAP_TABLE_4_HALF1", "ENABLE"                         , 0x0002705c, 24, 24},
{"OLE_DECAP_TABLE_4_HALF1", "OUI"                            , 0x0002705c, 23, 0 },
{"OLE_DECAP_TABLE_4_HALF2", "TYPE"                           , 0x00027060, 15, 0 },
{"OLE_DECAP_TABLE_5_HALF1", "SNAP_OR_TYPE2"                  , 0x00027064, 25, 25},
{"OLE_DECAP_TABLE_5_HALF1", "ENABLE"                         , 0x00027064, 24, 24},
{"OLE_DECAP_TABLE_5_HALF1", "OUI"                            , 0x00027064, 23, 0 },
{"OLE_DECAP_TABLE_5_HALF2", "TYPE"                           , 0x00027068, 15, 0 },
{"OLE_DECAP_TABLE_6_HALF1", "SNAP_OR_TYPE2"                  , 0x0002706c, 25, 25},
{"OLE_DECAP_TABLE_6_HALF1", "ENABLE"                         , 0x0002706c, 24, 24},
{"OLE_DECAP_TABLE_6_HALF1", "OUI"                            , 0x0002706c, 23, 0 },
{"OLE_DECAP_TABLE_6_HALF2", "TYPE"                           , 0x00027070, 15, 0 },
{"OLE_DECAP_TABLE_7_HALF1", "SNAP_OR_TYPE2"                  , 0x00027074, 25, 25},
{"OLE_DECAP_TABLE_7_HALF1", "ENABLE"                         , 0x00027074, 24, 24},
{"OLE_DECAP_TABLE_7_HALF1", "OUI"                            , 0x00027074, 23, 0 },
{"OLE_DECAP_TABLE_7_HALF2", "TYPE"                           , 0x00027078, 15, 0 },
{"OLE_ASE_AST_BASE_ADDR", "VALUE"                            , 0x0002707c, 31, 0 },
{"OLE_ASE_AST_SIZE", "VALUE"                                 , 0x00027080, 12, 0 },
{"OLE_ASE_SEARCH_CTRL", "TIMEOUT_THRESH"                     , 0x00027084, 31, 16},
{"OLE_ASE_SEARCH_CTRL", "ADDR_SEARCH_SWAP"                   , 0x00027084, 8 , 8 },
{"OLE_ASE_SEARCH_CTRL", "MAX_SEARCH"                         , 0x00027084, 7 , 0 },
{"OLE_ASE_HASH_CTRL", "CACHE_INVALIDATE"                     , 0x00027088, 23, 23},
{"OLE_ASE_HASH_CTRL", "CACHE_DISABLE"                        , 0x00027088, 22, 22},
{"OLE_ASE_HASH_CTRL", "HASH_MAC_31_0_IGNORE"                 , 0x00027088, 21, 21},
{"OLE_ASE_HASH_CTRL", "HASH_SEL"                             , 0x00027088, 20, 20},
{"OLE_ASE_HASH_CTRL", "HASH_MCAST_SHIFT"                     , 0x00027088, 19, 16},
{"OLE_ASE_HASH_CTRL", "HASH_XOR"                             , 0x00027088, 15, 0 },
{"OLE_CONFIG", "USE_BSSID_FOR_AMSDU"                         , 0x0002708c, 4 , 4 },
{"OLE_CONFIG", "TX_ABORT"                                    , 0x0002708c, 3 , 3 },
{"OLE_CONFIG", "RX_RESET"                                    , 0x0002708c, 2 , 2 },
{"OLE_CONFIG", "TX_RESET"                                    , 0x0002708c, 1 , 1 },
{"OLE_CONFIG", "RESET"                                       , 0x0002708c, 0 , 0 },
{"OLE_PN_SHIFT_FACTOR", "VALUE"                              , 0x00027090, 3 , 0 },
{"OLE_RX_CLASSIFY_ETHERNET_0", "ENABLE"                      , 0x00027094, 16, 16},
{"OLE_RX_CLASSIFY_ETHERNET_0", "TYPE"                        , 0x00027094, 15, 0 },
{"OLE_RX_CLASSIFY_ETHERNET_1", "ENABLE"                      , 0x00027098, 16, 16},
{"OLE_RX_CLASSIFY_ETHERNET_1", "TYPE"                        , 0x00027098, 15, 0 },
{"OLE_RX_CLASSIFY_ETHERNET_2", "ENABLE"                      , 0x0002709c, 16, 16},
{"OLE_RX_CLASSIFY_ETHERNET_2", "TYPE"                        , 0x0002709c, 15, 0 },
{"OLE_RX_CLASSIFY_ETHERNET_3", "ENABLE"                      , 0x000270a0, 16, 16},
{"OLE_RX_CLASSIFY_ETHERNET_3", "TYPE"                        , 0x000270a0, 15, 0 },
{"OLE_OBS", "VALUE"                                          , 0x000270a4, 31, 0 },
{"MAC_PCU_STA_ADDR_L32", "ADDR_31_0"                         , 0x00028000, 31, 0 },
{"MAC_PCU_STA_ADDR_U16", "ADHOC_MCAST_SEARCH"                , 0x00028004, 31, 31},
{"MAC_PCU_STA_ADDR_U16", "CBCIV_ENDIAN"                      , 0x00028004, 30, 30},
{"MAC_PCU_STA_ADDR_U16", "PRESERVE_SEQNUM"                   , 0x00028004, 29, 29},
{"MAC_PCU_STA_ADDR_U16", "KSRCH_MODE"                        , 0x00028004, 28, 28},
{"MAC_PCU_STA_ADDR_U16", "CRPT_MIC_ENABLE"                   , 0x00028004, 27, 27},
{"MAC_PCU_STA_ADDR_U16", "SECTOR_SELF_GEN"                   , 0x00028004, 26, 26},
{"MAC_PCU_STA_ADDR_U16", "BASE_RATE_11B"                     , 0x00028004, 25, 25},
{"MAC_PCU_STA_ADDR_U16", "ACKCTS_6MB"                        , 0x00028004, 24, 24},
{"MAC_PCU_STA_ADDR_U16", "RTS_USE_DEF"                       , 0x00028004, 23, 23},
{"MAC_PCU_STA_ADDR_U16", "DEFANT_UPDATE"                     , 0x00028004, 22, 22},
{"MAC_PCU_STA_ADDR_U16", "USE_DEFANT"                        , 0x00028004, 21, 21},
{"MAC_PCU_STA_ADDR_U16", "PCF"                               , 0x00028004, 20, 20},
{"MAC_PCU_STA_ADDR_U16", "KEYSRCH_DIS"                       , 0x00028004, 19, 19},
{"MAC_PCU_STA_ADDR_U16", "PW_SAVE"                           , 0x00028004, 18, 18},
{"MAC_PCU_STA_ADDR_U16", "ADHOC"                             , 0x00028004, 17, 17},
{"MAC_PCU_STA_ADDR_U16", "STA_AP"                            , 0x00028004, 16, 16},
{"MAC_PCU_STA_ADDR_U16", "ADDR_47_32"                        , 0x00028004, 15, 0 },
{"MAC_PCU_BSSID_L32", "ADDR"                                 , 0x00028008, 31, 0 },
{"MAC_PCU_BSSID_U16", "AID"                                  , 0x0002800c, 26, 16},
{"MAC_PCU_BSSID_U16", "ADDR"                                 , 0x0002800c, 15, 0 },
{"MAC_PCU_BCN_RSSI_AVE", "AVE_VALUE2"                        , 0x00028010, 27, 16},
{"MAC_PCU_BCN_RSSI_AVE", "AVE_VALUE"                         , 0x00028010, 11, 0 },
{"MAC_PCU_ACK_CTS_TIMEOUT", "CTS_TIMEOUT"                    , 0x00028014, 29, 16},
{"MAC_PCU_ACK_CTS_TIMEOUT", "ACK_TIMEOUT"                    , 0x00028014, 13, 0 },
{"MAC_PCU_BCN_RSSI_CTL", "RESET"                             , 0x00028018, 29, 29},
{"MAC_PCU_BCN_RSSI_CTL", "WEIGHT"                            , 0x00028018, 28, 24},
{"MAC_PCU_BCN_RSSI_CTL", "RSSI_HIGH_THRESH"                  , 0x00028018, 23, 16},
{"MAC_PCU_BCN_RSSI_CTL", "MISS_THRESH"                       , 0x00028018, 15, 8 },
{"MAC_PCU_BCN_RSSI_CTL", "RSSI_LOW_THRESH"                   , 0x00028018, 7 , 0 },
{"MAC_PCU_USEC_LATENCY", "RX_LATENCY"                        , 0x0002801c, 28, 23},
{"MAC_PCU_USEC_LATENCY", "TX_LATENCY"                        , 0x0002801c, 22, 14},
{"MAC_PCU_USEC_LATENCY", "USEC"                              , 0x0002801c, 7 , 0 },
{"MAC_PCU_BCN_RSSI_CTL2", "RESET2"                           , 0x00028020, 29, 29},
{"MAC_PCU_BCN_RSSI_CTL2", "RSSI2_HIGH_THRESH"                , 0x00028020, 23, 16},
{"MAC_PCU_BCN_RSSI_CTL2", "RSSI2_LOW_THRESH"                 , 0x00028020, 7 , 0 },
{"MAC_PCU_BT_WL_1", "WEIGHT"                                 , 0x00028024, 31, 0 },
{"MAC_PCU_BT_WL_2", "WEIGHT"                                 , 0x00028028, 31, 0 },
{"MAC_PCU_BT_WL_3", "WEIGHT"                                 , 0x0002802c, 31, 0 },
{"MAC_PCU_BT_WL_4", "WEIGHT"                                 , 0x00028030, 31, 0 },
{"MAC_PCU_COEX_EPTA", "WT_IDX"                               , 0x00028034, 12, 6 },
{"MAC_PCU_COEX_EPTA", "LINKID"                               , 0x00028034, 5 , 0 },
{"MAC_PCU_MAX_CFP_DUR", "USEC_FRAC_DENOMINATOR"              , 0x00028038, 27, 24},
{"MAC_PCU_MAX_CFP_DUR", "USEC_FRAC_NUMERATOR"                , 0x00028038, 19, 16},
{"MAC_PCU_MAX_CFP_DUR", "VALUE"                              , 0x00028038, 15, 0 },
{"MAC_PCU_RX_FILTER", "BSSID_BASED_MULTICAST"                , 0x0002803c, 31, 31},
{"MAC_PCU_RX_FILTER", "PHY_DATA"                             , 0x0002803c, 30, 30},
{"MAC_PCU_RX_FILTER", "MY_BEACON2"                           , 0x0002803c, 29, 29},
{"MAC_PCU_RX_FILTER", "GENERIC_FILTER"                       , 0x0002803c, 28, 27},
{"MAC_PCU_RX_FILTER", "GENERIC_FTYPE"                        , 0x0002803c, 26, 21},
{"MAC_PCU_RX_FILTER", "FROM_TO_DS"                           , 0x0002803c, 20, 20},
{"MAC_PCU_RX_FILTER", "CONTROL_WRAPPER"                      , 0x0002803c, 19, 19},
{"MAC_PCU_RX_FILTER", "MGMT_ACTION_MCAST"                    , 0x0002803c, 18, 18},
{"MAC_PCU_RX_FILTER", "HW_BCN_PROC_ENABLE"                   , 0x0002803c, 17, 17},
{"MAC_PCU_RX_FILTER", "RST_DLMTR_CNT_DISABLE"                , 0x0002803c, 16, 16},
{"MAC_PCU_RX_FILTER", "MCAST_BCAST_ALL"                      , 0x0002803c, 15, 15},
{"MAC_PCU_RX_FILTER", "PS_POLL"                              , 0x0002803c, 14, 14},
{"MAC_PCU_RX_FILTER", "RESERVED"                             , 0x0002803c, 13, 13},
{"MAC_PCU_RX_FILTER", "UNCOMPRESSED_BA_BAR"                  , 0x0002803c, 12, 12},
{"MAC_PCU_RX_FILTER", "COMPRESSED_BA"                        , 0x0002803c, 11, 11},
{"MAC_PCU_RX_FILTER", "COMPRESSED_BAR"                       , 0x0002803c, 10, 10},
{"MAC_PCU_RX_FILTER", "MY_BEACON"                            , 0x0002803c, 9 , 9 },
{"MAC_PCU_RX_FILTER", "SYNC_FRAME"                           , 0x0002803c, 8 , 8 },
{"MAC_PCU_RX_FILTER", "PROBE_REQ"                            , 0x0002803c, 7 , 7 },
{"MAC_PCU_RX_FILTER", "XR_POLL"                              , 0x0002803c, 6 , 6 },
{"MAC_PCU_RX_FILTER", "PROMISCUOUS"                          , 0x0002803c, 5 , 5 },
{"MAC_PCU_RX_FILTER", "BEACON"                               , 0x0002803c, 4 , 4 },
{"MAC_PCU_RX_FILTER", "CONTROL"                              , 0x0002803c, 3 , 3 },
{"MAC_PCU_RX_FILTER", "BROADCAST"                            , 0x0002803c, 2 , 2 },
{"MAC_PCU_RX_FILTER", "MULTICAST"                            , 0x0002803c, 1 , 1 },
{"MAC_PCU_RX_FILTER", "UNICAST"                              , 0x0002803c, 0 , 0 },
{"MAC_PCU_MCAST_FILTER_L32", "VALUE"                         , 0x00028040, 31, 0 },
{"MAC_PCU_MCAST_FILTER_U32", "VALUE"                         , 0x00028044, 31, 0 },
{"MAC_PCU_DIAG_SW", "DEBUG_MODE"                             , 0x00028048, 31, 30},
{"MAC_PCU_DIAG_SW", "RX_CLEAR_EXT_LOW"                       , 0x00028048, 29, 29},
{"MAC_PCU_DIAG_SW", "RX_CLEAR_CTL_LOW"                       , 0x00028048, 28, 28},
{"MAC_PCU_DIAG_SW", "OBS_SEL_2"                              , 0x00028048, 27, 27},
{"MAC_PCU_DIAG_SW", "SATURATE_CYCLE_CNT"                     , 0x00028048, 26, 26},
{"MAC_PCU_DIAG_SW", "FORCE_RX_ABORT"                         , 0x00028048, 25, 25},
{"MAC_PCU_DIAG_SW", "DUAL_CHAIN_CHAN_INFO"                   , 0x00028048, 24, 24},
{"MAC_PCU_DIAG_SW", "PHYERR_ENABLE_EIFS_CTL"                 , 0x00028048, 23, 23},
{"MAC_PCU_DIAG_SW", "CHAN_IDLE_HIGH"                         , 0x00028048, 22, 22},
{"MAC_PCU_DIAG_SW", "IGNORE_NAV"                             , 0x00028048, 21, 21},
{"MAC_PCU_DIAG_SW", "RX_CLEAR_HIGH"                          , 0x00028048, 20, 20},
{"MAC_PCU_DIAG_SW", "OBS_SEL_1_0"                            , 0x00028048, 19, 18},
{"MAC_PCU_DIAG_SW", "ACCEPT_NON_V0"                          , 0x00028048, 17, 17},
{"MAC_PCU_DIAG_SW", "DUMP_CHAN_INFO"                         , 0x00028048, 8 , 8 },
{"MAC_PCU_DIAG_SW", "CORRUPT_FCS"                            , 0x00028048, 7 , 7 },
{"MAC_PCU_DIAG_SW", "LOOP_BACK"                              , 0x00028048, 6 , 6 },
{"MAC_PCU_DIAG_SW", "HALT_RX"                                , 0x00028048, 5 , 5 },
{"MAC_PCU_DIAG_SW", "NO_DECRYPT"                             , 0x00028048, 4 , 4 },
{"MAC_PCU_DIAG_SW", "NO_ENCRYPT"                             , 0x00028048, 3 , 3 },
{"MAC_PCU_DIAG_SW", "NO_CTS"                                 , 0x00028048, 2 , 2 },
{"MAC_PCU_DIAG_SW", "NO_ACK"                                 , 0x00028048, 1 , 1 },
{"MAC_PCU_DIAG_SW", "INVALID_KEY_NO_ACK"                     , 0x00028048, 0 , 0 },
{"MAC_PCU_WARM_TX_CONTROL", "ENABLE_SELF_GEN"                , 0x0002804c, 31, 31},
{"MAC_PCU_WARM_TX_CONTROL", "ENABLE_DATA"                    , 0x0002804c, 30, 30},
{"MAC_PCU_WARM_TX_CONTROL", "SIFS_DUR"                       , 0x0002804c, 15, 0 },
{"MAC_PCU_TST_ADDAC", "TEST_ARM"                             , 0x00028054, 20, 20},
{"MAC_PCU_TST_ADDAC", "TEST_CAPTURE"                         , 0x00028054, 19, 19},
{"MAC_PCU_TST_ADDAC", "CONT_TEST"                            , 0x00028054, 18, 18},
{"MAC_PCU_TST_ADDAC", "TRIG_POLARITY"                        , 0x00028054, 17, 17},
{"MAC_PCU_TST_ADDAC", "TRIG_SEL"                             , 0x00028054, 16, 16},
{"MAC_PCU_TST_ADDAC", "SAMPLE_SIZE_2K"                       , 0x00028054, 15, 15},
{"MAC_PCU_TST_ADDAC", "UPPER_8B"                             , 0x00028054, 14, 14},
{"MAC_PCU_TST_ADDAC", "LOOP_LEN"                             , 0x00028054, 13, 3 },
{"MAC_PCU_TST_ADDAC", "LOOP"                                 , 0x00028054, 2 , 2 },
{"MAC_PCU_TST_ADDAC", "TESTMODE"                             , 0x00028054, 1 , 1 },
{"MAC_PCU_TST_ADDAC", "CONT_TX"                              , 0x00028054, 0 , 0 },
{"MAC_PCU_DEF_ANTENNA", "RX_ANT_DIV_ON"                      , 0x00028058, 31, 31},
{"MAC_PCU_DEF_ANTENNA", "RX_ANT_EN"                          , 0x00028058, 30, 30},
{"MAC_PCU_DEF_ANTENNA", "FAST_TX_ANT_EN"                     , 0x00028058, 29, 29},
{"MAC_PCU_DEF_ANTENNA", "RX_LNA_CONFIG_SEL"                  , 0x00028058, 28, 28},
{"MAC_PCU_DEF_ANTENNA", "FAST_DEF_ANT"                       , 0x00028058, 27, 27},
{"MAC_PCU_DEF_ANTENNA", "TX_CUR_ANT"                         , 0x00028058, 26, 26},
{"MAC_PCU_DEF_ANTENNA", "SLOW_TX_ANT_EN"                     , 0x00028058, 25, 25},
{"MAC_PCU_DEF_ANTENNA", "TX_DEF_ANT_SEL"                     , 0x00028058, 24, 24},
{"MAC_PCU_DEF_ANTENNA", "VALUE"                              , 0x00028058, 23, 0 },
{"MAC_PCU_AES_MUTE_MASK_0", "QOS"                            , 0x0002805c, 31, 16},
{"MAC_PCU_AES_MUTE_MASK_0", "FC"                             , 0x0002805c, 15, 0 },
{"MAC_PCU_AES_MUTE_MASK_1", "FC_MGMT"                        , 0x00028060, 31, 16},
{"MAC_PCU_AES_MUTE_MASK_1", "SEQ"                            , 0x00028060, 15, 0 },
{"MAC_PCU_GATED_CLKS", "GATED_REG"                           , 0x00028064, 3 , 3 },
{"MAC_PCU_GATED_CLKS", "GATED_RX"                            , 0x00028064, 2 , 2 },
{"MAC_PCU_GATED_CLKS", "GATED_TX"                            , 0x00028064, 1 , 1 },
{"MAC_PCU_OBS_BUS_2", "VALUE2"                               , 0x00028068, 31, 18},
{"MAC_PCU_OBS_BUS_2", "VALUE"                                , 0x00028068, 17, 0 },
{"MAC_PCU_OBS_BUS_1", "TX_STATE"                             , 0x0002806c, 30, 25},
{"MAC_PCU_OBS_BUS_1", "RX_STATE"                             , 0x0002806c, 24, 20},
{"MAC_PCU_OBS_BUS_1", "WEP_STATE"                            , 0x0002806c, 17, 12},
{"MAC_PCU_OBS_BUS_1", "RX_CLEAR"                             , 0x0002806c, 11, 11},
{"MAC_PCU_OBS_BUS_1", "RX_FRAME"                             , 0x0002806c, 10, 10},
{"MAC_PCU_OBS_BUS_1", "TX_FRAME"                             , 0x0002806c, 9 , 9 },
{"MAC_PCU_OBS_BUS_1", "TX_HOLD"                              , 0x0002806c, 8 , 8 },
{"MAC_PCU_OBS_BUS_1", "PCU_CHANNEL_IDLE"                     , 0x0002806c, 7 , 7 },
{"MAC_PCU_OBS_BUS_1", "TM_QUIET_TIME"                        , 0x0002806c, 6 , 6 },
{"MAC_PCU_OBS_BUS_1", "TX_HCF"                               , 0x0002806c, 5 , 5 },
{"MAC_PCU_OBS_BUS_1", "FILTER_PASS"                          , 0x0002806c, 4 , 4 },
{"MAC_PCU_OBS_BUS_1", "RX_MY_BEACON"                         , 0x0002806c, 3 , 3 },
{"MAC_PCU_OBS_BUS_1", "RX_WEP"                               , 0x0002806c, 2 , 2 },
{"MAC_PCU_OBS_BUS_1", "PCU_RX_END"                           , 0x0002806c, 1 , 1 },
{"MAC_PCU_OBS_BUS_1", "PCU_DIRECTED"                         , 0x0002806c, 0 , 0 },
{"MAC_PCU_DYM_MIMO_PWR_SAVE", "HI_PWR_CHAIN_MASK"            , 0x00028070, 10, 8 },
{"MAC_PCU_DYM_MIMO_PWR_SAVE", "LOW_PWR_CHAIN_MASK"           , 0x00028070, 6 , 4 },
{"MAC_PCU_DYM_MIMO_PWR_SAVE", "SW_CHAIN_MASK_SEL"            , 0x00028070, 2 , 2 },
{"MAC_PCU_DYM_MIMO_PWR_SAVE", "HW_CTRL_EN"                   , 0x00028070, 1 , 1 },
{"MAC_PCU_DYM_MIMO_PWR_SAVE", "USE_MAC_CTRL"                 , 0x00028070, 0 , 0 },
{"MAC_PCU_LAST_BEACON_TSF", "VALUE"                          , 0x00028080, 31, 0 },
{"MAC_PCU_NAV", "VALUE"                                      , 0x00028084, 25, 0 },
{"MAC_PCU_RTS_SUCCESS_CNT", "VALUE"                          , 0x00028088, 15, 0 },
{"MAC_PCU_RTS_FAIL_CNT", "VALUE"                             , 0x0002808c, 15, 0 },
{"MAC_PCU_ACK_FAIL_CNT", "VALUE"                             , 0x00028090, 15, 0 },
{"MAC_PCU_FCS_FAIL_CNT", "VALUE"                             , 0x00028094, 15, 0 },
{"MAC_PCU_BEACON_CNT", "VALUE"                               , 0x00028098, 15, 0 },
{"MAC_PCU_BEACON2_CNT", "VALUE"                              , 0x0002809c, 15, 0 },
{"MAC_PCU_BASIC_SET", "MCS"                                  , 0x000280a0, 31, 0 },
{"MAC_PCU_MGMT_SEQ", "MAX"                                   , 0x000280a4, 27, 16},
{"MAC_PCU_MGMT_SEQ", "MIN"                                   , 0x000280a4, 11, 0 },
{"MAC_PCU_BF_RPT1", "FRAME_TYPE_VALUE"                       , 0x000280a8, 29, 28},
{"MAC_PCU_BF_RPT1", "FRAME_SUBTYPE_VALUE"                    , 0x000280a8, 27, 24},
{"MAC_PCU_BF_RPT1", "CATEGORY_VALUE"                         , 0x000280a8, 23, 16},
{"MAC_PCU_BF_RPT1", "CV_ACTION_VALUE"                        , 0x000280a8, 15, 8 },
{"MAC_PCU_BF_RPT1", "V_ACTION_VALUE"                         , 0x000280a8, 7 , 0 },
{"MAC_PCU_BF_RPT2", "FRAME_SUBTYPE_VALUE"                    , 0x000280ac, 3 , 0 },
{"MAC_PCU_TX_ANT_1", "VALUE"                                 , 0x000280b0, 31, 0 },
{"MAC_PCU_TX_ANT_2", "VALUE"                                 , 0x000280b4, 31, 0 },
{"MAC_PCU_TX_ANT_3", "VALUE"                                 , 0x000280b8, 31, 0 },
{"MAC_PCU_TX_ANT_4", "VALUE"                                 , 0x000280bc, 31, 0 },
{"MAC_PCU_XRMODE", "FRAME_HOLD"                              , 0x000280c0, 31, 20},
{"MAC_PCU_XRMODE", "WAIT_FOR_POLL"                           , 0x000280c0, 7 , 7 },
{"MAC_PCU_XRMODE", "POLL_TYPE"                               , 0x000280c0, 5 , 0 },
{"MAC_PCU_XRDEL", "CHIRP_DATA_DELAY"                         , 0x000280c4, 31, 16},
{"MAC_PCU_XRDEL", "SLOT_DELAY"                               , 0x000280c4, 15, 0 },
{"MAC_PCU_XRTO", "POLL_TIMEOUT"                              , 0x000280c8, 31, 16},
{"MAC_PCU_XRTO", "CHIRP_TIMEOUT"                             , 0x000280c8, 15, 0 },
{"MAC_PCU_XRCRP", "CHIRP_GAP"                                , 0x000280cc, 31, 16},
{"MAC_PCU_XRCRP", "SEND_CHIRP"                               , 0x000280cc, 0 , 0 },
{"MAC_PCU_XRSTMP", "RX_ABORT_RSSI_THRESH"                    , 0x000280d0, 23, 16},
{"MAC_PCU_XRSTMP", "TX_STOMP_RSSI_THRESH"                    , 0x000280d0, 15, 8 },
{"MAC_PCU_XRSTMP", "RX_ABORT_DATA"                           , 0x000280d0, 5 , 5 },
{"MAC_PCU_XRSTMP", "TX_STOMP_DATA"                           , 0x000280d0, 4 , 4 },
{"MAC_PCU_XRSTMP", "TX_STOMP_BSSID"                          , 0x000280d0, 3 , 3 },
{"MAC_PCU_XRSTMP", "TX_STOMP_RSSI"                           , 0x000280d0, 2 , 2 },
{"MAC_PCU_XRSTMP", "RX_ABORT_BSSID"                          , 0x000280d0, 1 , 1 },
{"MAC_PCU_XRSTMP", "RX_ABORT_RSSI"                           , 0x000280d0, 0 , 0 },
{"MAC_PCU_SELF_GEN_DEFAULT", "STAGGER_SOUNDING"              , 0x000280dc, 5 , 5 },
{"MAC_PCU_SELF_GEN_DEFAULT", "CEC"                           , 0x000280dc, 4 , 3 },
{"MAC_PCU_SELF_GEN_DEFAULT", "MMSS"                          , 0x000280dc, 2 , 0 },
{"MAC_PCU_ADDR1_MASK_L32", "VALUE"                           , 0x000280e0, 31, 0 },
{"MAC_PCU_ADDR1_MASK_U16", "VALUE"                           , 0x000280e4, 15, 0 },
{"MAC_PCU_TPC", "TXBF_FB_PWR"                                , 0x000280e8, 29, 24},
{"MAC_PCU_TPC", "CHIRP_PWR"                                  , 0x000280e8, 21, 16},
{"MAC_PCU_TPC", "CTS_ACK_PWR_OFDM"                           , 0x000280e8, 13, 8 },
{"MAC_PCU_TPC", "CTS_ACK_PWR_CCK"                            , 0x000280e8, 5 , 0 },
{"MAC_PCU_TX_FRAME_CNT", "VALUE"                             , 0x000280ec, 31, 0 },
{"MAC_PCU_RX_FRAME_CNT", "VALUE"                             , 0x000280f0, 31, 0 },
{"MAC_PCU_RX_CLEAR_CNT", "VALUE"                             , 0x000280f4, 31, 0 },
{"MAC_PCU_CYCLE_CNT", "VALUE"                                , 0x000280f8, 31, 0 },
{"MAC_PCU_QUIET_TIME_1", "ACK_CTS_ENABLE"                    , 0x000280fc, 17, 17},
{"MAC_PCU_QUIET_TIME_2", "DURATION"                          , 0x00028100, 31, 16},
{"MAC_PCU_QUIET_TIME_2", "DURATION2"                         , 0x00028100, 15, 0 },
{"MAC_PCU_QOS_NO_ACK", "BYTE_OFFSET"                         , 0x00028108, 8 , 7 },
{"MAC_PCU_QOS_NO_ACK", "BIT_OFFSET"                          , 0x00028108, 6 , 4 },
{"MAC_PCU_QOS_NO_ACK", "TWO_BIT_VALUES"                      , 0x00028108, 3 , 0 },
{"MAC_PCU_PHY_ERROR_MASK", "VALUE"                           , 0x0002810c, 31, 0 },
{"MAC_PCU_XRLAT", "VALUE"                                    , 0x00028110, 11, 0 },
{"MAC_PCU_RXBUF", "REG_RD_ENABLE"                            , 0x00028114, 11, 11},
{"MAC_PCU_RXBUF", "HIGH_PRIORITY_THRSHD"                     , 0x00028114, 10, 0 },
{"MAC_PCU_MIC_QOS_CONTROL", "ENABLE"                         , 0x00028118, 16, 16},
{"MAC_PCU_MIC_QOS_CONTROL", "VALUE_7"                        , 0x00028118, 15, 14},
{"MAC_PCU_MIC_QOS_CONTROL", "VALUE_6"                        , 0x00028118, 13, 12},
{"MAC_PCU_MIC_QOS_CONTROL", "VALUE_5"                        , 0x00028118, 11, 10},
{"MAC_PCU_MIC_QOS_CONTROL", "VALUE_4"                        , 0x00028118, 9 , 8 },
{"MAC_PCU_MIC_QOS_CONTROL", "VALUE_3"                        , 0x00028118, 7 , 6 },
{"MAC_PCU_MIC_QOS_CONTROL", "VALUE_2"                        , 0x00028118, 5 , 4 },
{"MAC_PCU_MIC_QOS_CONTROL", "VALUE_1"                        , 0x00028118, 3 , 2 },
{"MAC_PCU_MIC_QOS_CONTROL", "VALUE_0"                        , 0x00028118, 1 , 0 },
{"MAC_PCU_MIC_QOS_SELECT", "VALUE_7"                         , 0x0002811c, 31, 28},
{"MAC_PCU_MIC_QOS_SELECT", "VALUE_6"                         , 0x0002811c, 27, 24},
{"MAC_PCU_MIC_QOS_SELECT", "VALUE_5"                         , 0x0002811c, 23, 20},
{"MAC_PCU_MIC_QOS_SELECT", "VALUE_4"                         , 0x0002811c, 19, 16},
{"MAC_PCU_MIC_QOS_SELECT", "VALUE_3"                         , 0x0002811c, 15, 12},
{"MAC_PCU_MIC_QOS_SELECT", "VALUE_2"                         , 0x0002811c, 11, 8 },
{"MAC_PCU_MIC_QOS_SELECT", "VALUE_1"                         , 0x0002811c, 7 , 4 },
{"MAC_PCU_MIC_QOS_SELECT", "VALUE_0"                         , 0x0002811c, 3 , 0 },
{"MAC_PCU_MISC_MODE", "DEBUG_MODE"                           , 0x00028120, 31, 30},
{"MAC_PCU_MISC_MODE", "USE_EOP_PTR_FOR_DMA_WR"               , 0x00028120, 29, 29},
{"MAC_PCU_MISC_MODE", "ALWAYS_PERFORM_KEY_SEARCH"            , 0x00028120, 28, 28},
{"MAC_PCU_MISC_MODE", "SEL_EVM"                              , 0x00028120, 27, 27},
{"MAC_PCU_MISC_MODE", "CLEAR_BA_VALID"                       , 0x00028120, 26, 26},
{"MAC_PCU_MISC_MODE", "CLEAR_FIRST_HCF"                      , 0x00028120, 25, 25},
{"MAC_PCU_MISC_MODE", "CLEAR_VMF"                            , 0x00028120, 24, 24},
{"MAC_PCU_MISC_MODE", "RX_HCF_POLL_ENABLE"                   , 0x00028120, 23, 23},
{"MAC_PCU_MISC_MODE", "HCF_POLL_CANCELS_NAV"                 , 0x00028120, 22, 22},
{"MAC_PCU_MISC_MODE", "TBTT_PROTECT"                         , 0x00028120, 21, 21},
{"MAC_PCU_MISC_MODE", "BT_ANT_PREVENTS_RX"                   , 0x00028120, 20, 20},
{"MAC_PCU_MISC_MODE", "FORCE_QUIET_COLLISION"                , 0x00028120, 18, 18},
{"MAC_PCU_MISC_MODE", "MISS_BEACON_IN_SLEEP"                 , 0x00028120, 14, 14},
{"MAC_PCU_MISC_MODE", "TXOP_TBTT_LIMIT_ENABLE"               , 0x00028120, 12, 12},
{"MAC_PCU_MISC_MODE", "KC_RX_ANT_UPDATE"                     , 0x00028120, 11, 11},
{"MAC_PCU_MISC_MODE", "DEBUG_MODE_SIFS"                      , 0x00028120, 10, 10},
{"MAC_PCU_MISC_MODE", "DEBUG_MODE_BA_BITMAP"                 , 0x00028120, 9 , 9 },
{"MAC_PCU_MISC_MODE", "RCV_DELAY_SOUNDING_IM_TXBF"           , 0x00028120, 6 , 6 },
{"MAC_PCU_MISC_MODE", "RXSM2SVD_PRE_RST"                     , 0x00028120, 5 , 5 },
{"MAC_PCU_MISC_MODE", "CCK_SIFS_MODE"                        , 0x00028120, 4 , 4 },
{"MAC_PCU_MISC_MODE", "TX_ADD_TSF"                           , 0x00028120, 3 , 3 },
{"MAC_PCU_MISC_MODE", "MIC_NEW_LOCATION_ENABLE"              , 0x00028120, 2 , 2 },
{"MAC_PCU_MISC_MODE", "DEBUG_MODE_AD"                        , 0x00028120, 1 , 1 },
{"MAC_PCU_MISC_MODE", "BSSID_MATCH_FORCE"                    , 0x00028120, 0 , 0 },
{"MAC_PCU_FILTER_OFDM_CNT", "VALUE"                          , 0x00028124, 23, 0 },
{"MAC_PCU_FILTER_CCK_CNT", "VALUE"                           , 0x00028128, 23, 0 },
{"MAC_PCU_PHY_ERR_CNT_1", "VALUE"                            , 0x0002812c, 23, 0 },
{"MAC_PCU_PHY_ERR_CNT_1_MASK", "VALUE"                       , 0x00028130, 31, 0 },
{"MAC_PCU_PHY_ERR_CNT_2", "VALUE"                            , 0x00028134, 23, 0 },
{"MAC_PCU_PHY_ERR_CNT_2_MASK", "VALUE"                       , 0x00028138, 31, 0 },
{"MAC_PCU_PHY_ERROR_EIFS_MASK", "VALUE"                      , 0x00028144, 31, 0 },
{"MAC_PCU_PHY_ERR_CNT_3", "VALUE"                            , 0x00028168, 23, 0 },
{"MAC_PCU_PHY_ERR_CNT_3_MASK", "VALUE"                       , 0x0002816c, 31, 0 },
{"MAC_PCU_BLUETOOTH_MODE", "FIRST_SLOT_TIME"                 , 0x00028170, 31, 24},
{"MAC_PCU_BLUETOOTH_MODE", "PRIORITY_TIME"                   , 0x00028170, 23, 18},
{"MAC_PCU_BLUETOOTH_MODE", "RX_CLEAR_POLARITY"               , 0x00028170, 17, 17},
{"MAC_PCU_BLUETOOTH_MODE", "QCU_THRESH"                      , 0x00028170, 16, 13},
{"MAC_PCU_BLUETOOTH_MODE", "QUIET"                           , 0x00028170, 12, 12},
{"MAC_PCU_BLUETOOTH_MODE", "MODE"                            , 0x00028170, 11, 10},
{"MAC_PCU_BLUETOOTH_MODE", "TX_FRAME_EXTEND"                 , 0x00028170, 9 , 9 },
{"MAC_PCU_BLUETOOTH_MODE", "TX_STATE_EXTEND"                 , 0x00028170, 8 , 8 },
{"MAC_PCU_BLUETOOTH_MODE", "TIME_EXTEND"                     , 0x00028170, 7 , 0 },
{"MAC_PCU_HCF_TIMEOUT", "VALUE"                              , 0x00028178, 15, 0 },
{"MAC_PCU_BLUETOOTH_MODE2", "PHY_ERR_BT_COLL_ENABLE"         , 0x0002817c, 31, 31},
{"MAC_PCU_BLUETOOTH_MODE2", "INTERRUPT_ENABLE"               , 0x0002817c, 30, 30},
{"MAC_PCU_BLUETOOTH_MODE2", "TSF_BT_PRIORITY_CTRL"           , 0x0002817c, 29, 28},
{"MAC_PCU_BLUETOOTH_MODE2", "TSF_BT_ACTIVE_CTRL"             , 0x0002817c, 27, 26},
{"MAC_PCU_BLUETOOTH_MODE2", "RS_DISCARD_EXTEND"              , 0x0002817c, 25, 25},
{"MAC_PCU_BLUETOOTH_MODE2", "WL_TXRX_SEPARATE"               , 0x0002817c, 24, 24},
{"MAC_PCU_BLUETOOTH_MODE2", "WL_ACTIVE_MODE"                 , 0x0002817c, 23, 22},
{"MAC_PCU_BLUETOOTH_MODE2", "QUIET_2_WIRE"                   , 0x0002817c, 21, 21},
{"MAC_PCU_BLUETOOTH_MODE2", "DISABLE_BT_ANT"                 , 0x0002817c, 20, 20},
{"MAC_PCU_BLUETOOTH_MODE2", "PROTECT_BT_AFTER_WAKEUP"        , 0x0002817c, 19, 19},
{"MAC_PCU_BLUETOOTH_MODE2", "SLEEP_ALLOW_BT_ACCESS"          , 0x0002817c, 17, 17},
{"MAC_PCU_BLUETOOTH_MODE2", "HOLD_RX_CLEAR"                  , 0x0002817c, 16, 16},
{"MAC_PCU_BLUETOOTH_MODE2", "BCN_MISS_CNT"                   , 0x0002817c, 15, 8 },
{"MAC_PCU_BLUETOOTH_MODE2", "BCN_MISS_THRESH"                , 0x0002817c, 7 , 0 },
{"MAC_PCU_BLUETOOTH_TSF_BT_ACTIVE", "VALUE"                  , 0x000281c8, 31, 0 },
{"MAC_PCU_BLUETOOTH_TSF_BT_PRIORITY", "VALUE"                , 0x000281cc, 31, 0 },
{"MAC_PCU_TXSIFS", "ACK_SHIFT"                               , 0x000281d0, 14, 12},
{"MAC_PCU_TXSIFS", "TX_LATENCY"                              , 0x000281d0, 11, 8 },
{"MAC_PCU_TXSIFS", "SIFS_TIME"                               , 0x000281d0, 7 , 0 },
{"MAC_PCU_BLUETOOTH_MODE3", "BT_PRIORITY_EXTEND_THRES"       , 0x000281d4, 31, 28},
{"MAC_PCU_BLUETOOTH_MODE3", "BT_TX_ON_EN"                    , 0x000281d4, 27, 27},
{"MAC_PCU_BLUETOOTH_MODE3", "SLOT_SLOP"                      , 0x000281d4, 26, 25},
{"MAC_PCU_BLUETOOTH_MODE3", "DYNAMIC_TOGGLE_WLA_EN"          , 0x000281d4, 24, 24},
{"MAC_PCU_BLUETOOTH_MODE3", "DYNAMIC_PRI_EN"                 , 0x000281d4, 23, 23},
{"MAC_PCU_BLUETOOTH_MODE3", "WL_PRIORITY_OFFSET_EN"          , 0x000281d4, 21, 21},
{"MAC_PCU_BLUETOOTH_MODE3", "AGC_SATURATION_CNT_ENABLE"      , 0x000281d4, 20, 20},
{"MAC_PCU_BLUETOOTH_MODE3", "ALLOW_CONCURRENT_ACCESS"        , 0x000281d4, 19, 16},
{"MAC_PCU_BLUETOOTH_MODE3", "WL_QC_TIME"                     , 0x000281d4, 15, 8 },
{"MAC_PCU_BLUETOOTH_MODE3", "WL_ACTIVE_TIME"                 , 0x000281d4, 7 , 0 },
{"MAC_PCU_BLUETOOTH_MODE4", "BT_PRIORITY_EXTEND"             , 0x000281d8, 31, 16},
{"MAC_PCU_BLUETOOTH_MODE4", "BT_ACTIVE_EXTEND"               , 0x000281d8, 15, 0 },
{"MAC_PCU_BLUETOOTH_MODE5", "FORCE_RX_CLEAR_VAL"             , 0x000281dc, 24, 24},
{"MAC_PCU_BLUETOOTH_MODE5", "FORCE_RX_CLEAR_EN"              , 0x000281dc, 23, 23},
{"MAC_PCU_BLUETOOTH_MODE5", "USE_D2_SLEEP"                   , 0x000281dc, 22, 22},
{"MAC_PCU_BLUETOOTH_MODE5", "USE_BTP_EXT"                    , 0x000281dc, 21, 21},
{"MAC_PCU_BLUETOOTH_MODE5", "SHARED_RX"                      , 0x000281dc, 20, 20},
{"MAC_PCU_BLUETOOTH_MODE5", "TIMER_TARGET"                   , 0x000281dc, 19, 4 },
{"MAC_PCU_BLUETOOTH_MODE5", "TX_ON_SRC"                      , 0x000281dc, 3 , 3 },
{"MAC_PCU_BLUETOOTH_MODE5", "MCI_WL_LEVEL_MULT"              , 0x000281dc, 2 , 0 },
{"MAC_PCU_BT_BT_ASYNC", "RXLP_WEIGHT"                        , 0x000281e4, 15, 12},
{"MAC_PCU_BT_BT_ASYNC", "RXHP_WEIGHT"                        , 0x000281e4, 11, 8 },
{"MAC_PCU_BT_BT_ASYNC", "TXLP_WEIGHT"                        , 0x000281e4, 7 , 4 },
{"MAC_PCU_BT_BT_ASYNC", "TXHP_WEIGHT"                        , 0x000281e4, 3 , 0 },
{"MAC_PCU_TXOP_X", "VALUE"                                   , 0x000281ec, 7 , 0 },
{"MAC_PCU_TXOP_0_3", "VALUE_3"                               , 0x000281f0, 31, 24},
{"MAC_PCU_TXOP_0_3", "VALUE_2"                               , 0x000281f0, 23, 16},
{"MAC_PCU_TXOP_0_3", "VALUE_1"                               , 0x000281f0, 15, 8 },
{"MAC_PCU_TXOP_0_3", "VALUE_0"                               , 0x000281f0, 7 , 0 },
{"MAC_PCU_TXOP_4_7", "VALUE_7"                               , 0x000281f4, 31, 24},
{"MAC_PCU_TXOP_4_7", "VALUE_6"                               , 0x000281f4, 23, 16},
{"MAC_PCU_TXOP_4_7", "VALUE_5"                               , 0x000281f4, 15, 8 },
{"MAC_PCU_TXOP_4_7", "VALUE_4"                               , 0x000281f4, 7 , 0 },
{"MAC_PCU_TXOP_8_11", "VALUE_11"                             , 0x000281f8, 31, 24},
{"MAC_PCU_TXOP_8_11", "VALUE_10"                             , 0x000281f8, 23, 16},
{"MAC_PCU_TXOP_8_11", "VALUE_9"                              , 0x000281f8, 15, 8 },
{"MAC_PCU_TXOP_8_11", "VALUE_8"                              , 0x000281f8, 7 , 0 },
{"MAC_PCU_TXOP_12_15", "VALUE_15"                            , 0x000281fc, 31, 24},
{"MAC_PCU_TXOP_12_15", "VALUE_14"                            , 0x000281fc, 23, 16},
{"MAC_PCU_TXOP_12_15", "VALUE_13"                            , 0x000281fc, 15, 8 },
{"MAC_PCU_TXOP_12_15", "VALUE_12"                            , 0x000281fc, 7 , 0 },
{"MAC_PCU_TDMA_TXFRAME_START_TIME_TRIGGER_LSB", "VALUE"      , 0x00028200, 31, 0 },
{"MAC_PCU_TDMA_TXFRAME_START_TIME_TRIGGER_MSB", "VALUE"      , 0x00028204, 31, 0 },
{"MAC_PCU_TDMA_SLOT_ALERT_CNTL", "VALUE"                     , 0x00028208, 15, 0 },
{"MAC_PCU_WOW1", "CW_BITS"                                   , 0x0002825c, 31, 28},
{"MAC_PCU_WOW1", "BEACON_FAIL"                               , 0x0002825c, 21, 21},
{"MAC_PCU_WOW1", "KEEP_ALIVE_FAIL"                           , 0x0002825c, 20, 20},
{"MAC_PCU_WOW1", "INTR_DETECT"                               , 0x0002825c, 19, 19},
{"MAC_PCU_WOW1", "INTR_ENABLE"                               , 0x0002825c, 18, 18},
{"MAC_PCU_WOW1", "MAGIC_DETECT"                              , 0x0002825c, 17, 17},
{"MAC_PCU_WOW1", "MAGIC_ENABLE"                              , 0x0002825c, 16, 16},
{"MAC_PCU_WOW1", "PATTERN_DETECT"                            , 0x0002825c, 15, 8 },
{"MAC_PCU_WOW1", "PATTERN_ENABLE"                            , 0x0002825c, 7 , 0 },
{"MAC_PCU_WOW2", "TRY_CNT"                                   , 0x00028260, 23, 16},
{"MAC_PCU_WOW2", "SLOT"                                      , 0x00028260, 15, 8 },
{"MAC_PCU_WOW2", "AIFS"                                      , 0x00028260, 7 , 0 },
{"MAC_PCU_LOGIC_ANALYZER", "DIAG_MODE"                       , 0x00028264, 31, 18},
{"MAC_PCU_LOGIC_ANALYZER", "INT_ADDR"                        , 0x00028264, 17, 8 },
{"MAC_PCU_LOGIC_ANALYZER", "QCU_SEL"                         , 0x00028264, 7 , 4 },
{"MAC_PCU_LOGIC_ANALYZER", "ENABLE"                          , 0x00028264, 3 , 3 },
{"MAC_PCU_LOGIC_ANALYZER", "STATE"                           , 0x00028264, 2 , 2 },
{"MAC_PCU_LOGIC_ANALYZER", "CLEAR"                           , 0x00028264, 1 , 1 },
{"MAC_PCU_LOGIC_ANALYZER", "HOLD"                            , 0x00028264, 0 , 0 },
{"MAC_PCU_LOGIC_ANALYZER_32L", "MASK"                        , 0x00028268, 31, 0 },
{"MAC_PCU_LOGIC_ANALYZER_16U", "MASK"                        , 0x0002826c, 15, 0 },
{"MAC_PCU_WOW3_BEACON_FAIL", "ENABLE"                        , 0x00028270, 0 , 0 },
{"MAC_PCU_WOW3_BEACON", "TIMEOUT"                            , 0x00028274, 31, 0 },
{"MAC_PCU_WOW3_KEEP_ALIVE", "TIMEOUT"                        , 0x00028278, 31, 0 },
{"MAC_PCU_WOW_KA", "BKOFF_CS_ENABLE"                         , 0x0002827c, 2 , 2 },
{"MAC_PCU_WOW_KA", "FAIL_DISABLE"                            , 0x0002827c, 1 , 1 },
{"MAC_PCU_WOW_KA", "AUTO_DISABLE"                            , 0x0002827c, 0 , 0 },
{"PCU_1US", "SCALER"                                         , 0x00028284, 6 , 0 },
{"PCU_KA", "DEL"                                             , 0x00028288, 11, 0 },
{"WOW_EXACT", "OFFSET"                                       , 0x0002828c, 15, 8 },
{"WOW_EXACT", "LENGTH"                                       , 0x0002828c, 7 , 0 },
{"PCU_WOW4", "OFFSET3"                                       , 0x00028294, 31, 24},
{"PCU_WOW4", "OFFSET2"                                       , 0x00028294, 23, 16},
{"PCU_WOW4", "OFFSET1"                                       , 0x00028294, 15, 8 },
{"PCU_WOW4", "OFFSET0"                                       , 0x00028294, 7 , 0 },
{"PCU_WOW5", "OFFSET7"                                       , 0x00028298, 31, 24},
{"PCU_WOW5", "OFFSET6"                                       , 0x00028298, 23, 16},
{"PCU_WOW5", "OFFSET5"                                       , 0x00028298, 15, 8 },
{"PCU_WOW5", "OFFSET4"                                       , 0x00028298, 7 , 0 },
{"MAC_PCU_PHY_ERR_CNT_1_MASK_CONT", "VALUE"                  , 0x0002829c, 31, 0 },
{"MAC_PCU_AZIMUTH_MODE", "PROXY_STA_FIX2_ENABLE"             , 0x00028300, 11, 11},
{"MAC_PCU_AZIMUTH_MODE", "PROXY_STA_FIX1_ENABLE"             , 0x00028300, 10, 10},
{"MAC_PCU_AZIMUTH_MODE", "FILTER_PASS_HOLD"                  , 0x00028300, 9 , 9 },
{"MAC_PCU_AZIMUTH_MODE", "WMAC_CLK_SEL"                      , 0x00028300, 8 , 8 },
{"MAC_PCU_AZIMUTH_MODE", "BA_USES_AD1"                       , 0x00028300, 7 , 7 },
{"MAC_PCU_AZIMUTH_MODE", "ACK_CTS_MATCH_TX_AD2"              , 0x00028300, 6 , 6 },
{"MAC_PCU_AZIMUTH_MODE", "TX_DESC_EN"                        , 0x00028300, 5 , 5 },
{"MAC_PCU_AZIMUTH_MODE", "CLK_EN"                            , 0x00028300, 4 , 4 },
{"MAC_PCU_AZIMUTH_MODE", "RX_TSF_STATUS_SEL"                 , 0x00028300, 3 , 3 },
{"MAC_PCU_AZIMUTH_MODE", "TX_TSF_STATUS_SEL"                 , 0x00028300, 2 , 2 },
{"MAC_PCU_AZIMUTH_MODE", "KEY_SEARCH_AD1"                    , 0x00028300, 1 , 1 },
{"MAC_PCU_AZIMUTH_MODE", "DISABLE_TSF_UPDATE"                , 0x00028300, 0 , 0 },
{"MAC_PCU_AZIMUTH_TIME_STAMP", "VALUE"                       , 0x00028314, 31, 0 },
{"MAC_PCU_20_40_MODE", "JOINED_RX_CLEAR_SEC80"               , 0x00028318, 17, 17},
{"MAC_PCU_20_40_MODE", "JOINED_RX_CLEAR_SEC40"               , 0x00028318, 16, 16},
{"MAC_PCU_20_40_MODE", "PIFS_CYCLES"                         , 0x00028318, 15, 4 },
{"MAC_PCU_20_40_MODE", "SWAMPED_FORCES_RX_CLEAR_CTL_IDLE"    , 0x00028318, 3 , 3 },
{"MAC_PCU_20_40_MODE", "TX_HT20_ON_EXT_BUSY"                 , 0x00028318, 2 , 2 },
{"MAC_PCU_20_40_MODE", "EXT_PIFS_ENABLE"                     , 0x00028318, 1 , 1 },
{"MAC_PCU_20_40_MODE", "JOINED_RX_CLEAR"                     , 0x00028318, 0 , 0 },
{"MAC_PCU_H_XFER_TIMEOUT", "EV_78384_FIX_DISABLE"            , 0x0002831c, 9 , 9 },
{"MAC_PCU_H_XFER_TIMEOUT", "EXTXBF_NOACK_NORPT"              , 0x0002831c, 8 , 8 },
{"MAC_PCU_H_XFER_TIMEOUT", "DELAY_EXTXBF_ONLY_UPLOAD_H"      , 0x0002831c, 7 , 7 },
{"MAC_PCU_H_XFER_TIMEOUT", "EXTXBF_IMMEDIATE_RESP"           , 0x0002831c, 6 , 6 },
{"MAC_PCU_H_XFER_TIMEOUT", "DISABLE"                         , 0x0002831c, 5 , 5 },
{"MAC_PCU_H_XFER_TIMEOUT", "VALUE"                           , 0x0002831c, 4 , 0 },
{"MAC_PCU_RX_CLEAR_DIFF_CNT", "VALUE"                        , 0x00028328, 31, 0 },
{"MAC_PCU_SELF_GEN_ANTENNA_MASK", "M_ACK_VALUE"              , 0x0002832c, 7 , 5 },
{"MAC_PCU_SELF_GEN_ANTENNA_MASK", "FORCE_CHAIN_0"            , 0x0002832c, 4 , 4 },
{"MAC_PCU_SELF_GEN_ANTENNA_MASK", "ONE_RESP_EN"              , 0x0002832c, 3 , 3 },
{"MAC_PCU_SELF_GEN_ANTENNA_MASK", "VALUE"                    , 0x0002832c, 2 , 0 },
{"MAC_PCU_BA_BAR_CONTROL", "SEARCH_DEPTH"                    , 0x00028330, 19, 16},
{"MAC_PCU_BA_BAR_CONTROL", "UPDATE_BA_BITMAP_QOS_NULL"       , 0x00028330, 12, 12},
{"MAC_PCU_BA_BAR_CONTROL", "TX_BA_CLEAR_BA_VALID"            , 0x00028330, 11, 11},
{"MAC_PCU_BA_BAR_CONTROL", "FORCE_NO_MATCH"                  , 0x00028330, 10, 10},
{"MAC_PCU_BA_BAR_CONTROL", "ACK_POLICY_VALUE"                , 0x00028330, 9 , 9 },
{"MAC_PCU_BA_BAR_CONTROL", "COMPRESSED_VALUE"                , 0x00028330, 8 , 8 },
{"MAC_PCU_BA_BAR_CONTROL", "ACK_POLICY_OFFSET"               , 0x00028330, 7 , 4 },
{"MAC_PCU_BA_BAR_CONTROL", "COMPRESSED_OFFSET"               , 0x00028330, 3 , 0 },
{"MAC_PCU_LEGACY_PLCP_SPOOF", "MIN_LENGTH"                   , 0x00028334, 12, 8 },
{"MAC_PCU_LEGACY_PLCP_SPOOF", "EIFS_MINUS_DIFS"              , 0x00028334, 7 , 0 },
{"MAC_PCU_PHY_ERROR_MASK_CONT", "VALUE"                      , 0x00028338, 31, 0 },
{"MAC_PCU_TX_TIMER", "QUIET_TIMER_ENABLE"                    , 0x0002833c, 25, 25},
{"MAC_PCU_TX_TIMER", "QUIET_TIMER"                           , 0x0002833c, 24, 20},
{"MAC_PCU_TX_TIMER", "RIFS_TIMER"                            , 0x0002833c, 19, 16},
{"MAC_PCU_TX_TIMER", "TX_TIMER_ENABLE"                       , 0x0002833c, 15, 15},
{"MAC_PCU_TX_TIMER", "TX_TIMER"                              , 0x0002833c, 14, 0 },
{"MAC_PCU_TXBUF_CTRL", "TX_FIFO_WRAP_ENABLE"                 , 0x00028340, 16, 16},
{"MAC_PCU_TXBUF_CTRL", "USABLE_ENTRIES"                      , 0x00028340, 11, 0 },
{"MAC_PCU_MISC_MODE2", "CLEAR_WEP_TXBUSY_ON_TXURN"           , 0x00028344, 31, 31},
{"MAC_PCU_MISC_MODE2", "PCU_LOOP_TXBF"                       , 0x00028344, 30, 30},
{"MAC_PCU_MISC_MODE2", "TXBF_ACT_RPT_DONE_PASS"              , 0x00028344, 29, 29},
{"MAC_PCU_MISC_MODE2", "H_TO_SW_DEBUG_MODE"                  , 0x00028344, 28, 28},
{"MAC_PCU_MISC_MODE2", "DECOUPLE_DECRYPTION"                 , 0x00028344, 27, 27},
{"MAC_PCU_MISC_MODE2", "RCV_TIMESTAMP_FIX"                   , 0x00028344, 25, 25},
{"MAC_PCU_MISC_MODE2", "MPDU_DENSITY_WAIT_WEP"               , 0x00028344, 24, 24},
{"MAC_PCU_MISC_MODE2", "MPDU_DENSITY_STS_FIX"                , 0x00028344, 23, 23},
{"MAC_PCU_MISC_MODE2", "IGNORE_TXOP_1ST_PKT"                 , 0x00028344, 22, 22},
{"MAC_PCU_MISC_MODE2", "CLEAR_MORE_FRAG"                     , 0x00028344, 21, 21},
{"MAC_PCU_MISC_MODE2", "BUG_28676"                           , 0x00028344, 20, 20},
{"MAC_PCU_MISC_MODE2", "DUR_ACCOUNT_BY_BA"                   , 0x00028344, 19, 19},
{"MAC_PCU_MISC_MODE2", "BC_MC_WAPI_MODE"                     , 0x00028344, 18, 18},
{"MAC_PCU_MISC_MODE2", "AGG_WEP"                             , 0x00028344, 17, 17},
{"MAC_PCU_MISC_MODE2", "ENABLE_LOAD_NAV_BEACON_DURATION"     , 0x00028344, 16, 16},
{"MAC_PCU_MISC_MODE2", "MGMT_QOS"                            , 0x00028344, 15, 8 },
{"MAC_PCU_MISC_MODE2", "CFP_IGNORE"                          , 0x00028344, 7 , 7 },
{"MAC_PCU_MISC_MODE2", "ADHOC_MCAST_KEYID_ENABLE"            , 0x00028344, 6 , 6 },
{"MAC_PCU_MISC_MODE2", "EV_76218_FIX_DISABLE"                , 0x00028344, 5 , 5 },
{"MAC_PCU_MISC_MODE2", "BUG_58057_FIX_ENABLE"                , 0x00028344, 4 , 4 },
{"MAC_PCU_MISC_MODE2", "BUG_58603_FIX_ENABLE"                , 0x00028344, 3 , 3 },
{"MAC_PCU_MISC_MODE2", "NO_CRYPTO_FOR_NON_DATA_PKT"          , 0x00028344, 2 , 2 },
{"MAC_PCU_MISC_MODE2", "MGMT_CRYPTO_ENABLE"                  , 0x00028344, 1 , 1 },
{"MAC_PCU_MISC_MODE2", "BUG_21532_FIX_ENABLE"                , 0x00028344, 0 , 0 },
{"MAC_PCU_ALT_AES_MUTE_MASK", "QOS"                          , 0x00028348, 31, 16},
{"MAC_PCU_WOW6", "RXBUF_START_ADDR"                          , 0x0002834c, 15, 0 },
{"MAC_PCU_WOW5", "RX_ABORT_ENABLE"                           , 0x0002835c, 15, 0 },
{"MAC_PCU_WOW_LENGTH1", "PATTERN_0"                          , 0x00028360, 31, 24},
{"MAC_PCU_WOW_LENGTH1", "PATTERN_1"                          , 0x00028360, 23, 16},
{"MAC_PCU_WOW_LENGTH1", "PATTERN_2"                          , 0x00028360, 15, 8 },
{"MAC_PCU_WOW_LENGTH1", "PATTERN_3"                          , 0x00028360, 7 , 0 },
{"MAC_PCU_WOW_LENGTH2", "PATTERN_4"                          , 0x00028364, 31, 24},
{"MAC_PCU_WOW_LENGTH2", "PATTERN_5"                          , 0x00028364, 23, 16},
{"MAC_PCU_WOW_LENGTH2", "PATTERN_6"                          , 0x00028364, 15, 8 },
{"MAC_PCU_WOW_LENGTH2", "PATTERN_7"                          , 0x00028364, 7 , 0 },
{"WOW_PATTERN_MATCH_LESS_THAN_256_BYTES", "EN"               , 0x00028368, 15, 0 },
{"MAC_PCU_WOW4", "PATTERN_DETECT"                            , 0x00028370, 15, 8 },
{"MAC_PCU_WOW4", "PATTERN_ENABLE"                            , 0x00028370, 7 , 0 },
{"WOW2_EXACT", "OFFSET"                                      , 0x00028374, 15, 8 },
{"WOW2_EXACT", "LENGTH"                                      , 0x00028374, 7 , 0 },
{"PCU_WOW6", "OFFSET11"                                      , 0x00028378, 31, 24},
{"PCU_WOW6", "OFFSET10"                                      , 0x00028378, 23, 16},
{"PCU_WOW6", "OFFSET9"                                       , 0x00028378, 15, 8 },
{"PCU_WOW6", "OFFSET8"                                       , 0x00028378, 7 , 0 },
{"PCU_WOW7", "OFFSET15"                                      , 0x0002837c, 31, 24},
{"PCU_WOW7", "OFFSET14"                                      , 0x0002837c, 23, 16},
{"PCU_WOW7", "OFFSET13"                                      , 0x0002837c, 15, 8 },
{"PCU_WOW7", "OFFSET12"                                      , 0x0002837c, 7 , 0 },
{"MAC_PCU_WOW_LENGTH3", "PATTERN_8"                          , 0x00028380, 31, 24},
{"MAC_PCU_WOW_LENGTH3", "PATTERN_9"                          , 0x00028380, 23, 16},
{"MAC_PCU_WOW_LENGTH3", "PATTERN_10"                         , 0x00028380, 15, 8 },
{"MAC_PCU_WOW_LENGTH3", "PATTERN_11"                         , 0x00028380, 7 , 0 },
{"MAC_PCU_WOW_LENGTH4", "PATTERN_12"                         , 0x00028384, 31, 24},
{"MAC_PCU_WOW_LENGTH4", "PATTERN_13"                         , 0x00028384, 23, 16},
{"MAC_PCU_WOW_LENGTH4", "PATTERN_14"                         , 0x00028384, 15, 8 },
{"MAC_PCU_WOW_LENGTH4", "PATTERN_15"                         , 0x00028384, 7 , 0 },
{"MAC_PCU_LOCATION_MODE_CONTROL", "UPLOAD_H_DISABLE"         , 0x00028388, 1 , 1 },
{"MAC_PCU_LOCATION_MODE_CONTROL", "ENABLE"                   , 0x00028388, 0 , 0 },
{"MAC_PCU_LOCATION_MODE_TIMER", "VALUE"                      , 0x0002838c, 31, 0 },
{"MAC_PCU_BSSID2_L32", "ADDR"                                , 0x00028398, 31, 0 },
{"MAC_PCU_BSSID2_U16", "AID"                                 , 0x0002839c, 30, 20},
{"MAC_PCU_BSSID2_U16", "ENABLE"                              , 0x0002839c, 16, 16},
{"MAC_PCU_BSSID2_U16", "ADDR"                                , 0x0002839c, 15, 0 },
{"MAC_PCU_DIRECT_CONNECT", "RESERVED_2"                      , 0x000283a0, 31, 17},
{"MAC_PCU_DIRECT_CONNECT", "SVD_TSF_SEL_EN"                  , 0x000283a0, 16, 16},
{"MAC_PCU_DIRECT_CONNECT", "BC_MC_WAPI_MODE_AP_SEL"          , 0x000283a0, 15, 15},
{"MAC_PCU_DIRECT_CONNECT", "RESERVED_1"                      , 0x000283a0, 14, 10},
{"MAC_PCU_DIRECT_CONNECT", "TSF1_CLK_REQ_DISABLE"            , 0x000283a0, 9 , 9 },
{"MAC_PCU_DIRECT_CONNECT", "RESERVED_0"                      , 0x000283a0, 8 , 8 },
{"MAC_PCU_DIRECT_CONNECT", "BMISS_CNT_OVERRIDE"              , 0x000283a0, 7 , 7 },
{"MAC_PCU_DIRECT_CONNECT", "BMISS_CNT_TSF_SEL"               , 0x000283a0, 6 , 6 },
{"MAC_PCU_DIRECT_CONNECT", "MY_BEACON2_OVERRIDE"             , 0x000283a0, 5 , 5 },
{"MAC_PCU_DIRECT_CONNECT", "MY_BEACON_OVERRIDE"              , 0x000283a0, 4 , 4 },
{"MAC_PCU_DIRECT_CONNECT", "TSF2_UPDATE"                     , 0x000283a0, 3 , 3 },
{"MAC_PCU_DIRECT_CONNECT", "TSF1_UPDATE"                     , 0x000283a0, 2 , 2 },
{"MAC_PCU_DIRECT_CONNECT", "TS_TSF_SEL"                      , 0x000283a0, 1 , 1 },
{"MAC_PCU_DIRECT_CONNECT", "TSF2_ENABLE"                     , 0x000283a0, 0 , 0 },
{"MAC_PCU_TID_TO_AC", "DATA"                                 , 0x000283a4, 31, 0 },
{"MAC_PCU_HP_QUEUE", "UAPSD_ONLY_QOS"                        , 0x000283a8, 24, 24},
{"MAC_PCU_HP_QUEUE", "UAPSD_AC_MUST_MATCH"                   , 0x000283a8, 23, 23},
{"MAC_PCU_HP_QUEUE", "NON_UAPSD_EN"                          , 0x000283a8, 22, 22},
{"MAC_PCU_HP_QUEUE", "PM_CHANGE"                             , 0x000283a8, 21, 21},
{"MAC_PCU_HP_QUEUE", "UAPSD_EN"                              , 0x000283a8, 20, 20},
{"MAC_PCU_HP_QUEUE", "FRAME_SUBTYPE_MASK0"                   , 0x000283a8, 19, 16},
{"MAC_PCU_HP_QUEUE", "FRAME_SUBTYPE0"                        , 0x000283a8, 15, 12},
{"MAC_PCU_HP_QUEUE", "FRAME_TYPE_MASK0"                      , 0x000283a8, 11, 10},
{"MAC_PCU_HP_QUEUE", "FRAME_TYPE0"                           , 0x000283a8, 9 , 8 },
{"MAC_PCU_HP_QUEUE", "FRAME_BSSID_MATCH0"                    , 0x000283a8, 7 , 7 },
{"MAC_PCU_HP_QUEUE", "FRAME_FILTER_ENABLE0"                  , 0x000283a8, 6 , 6 },
{"MAC_PCU_HP_QUEUE", "HPQON_UAPSD"                           , 0x000283a8, 5 , 5 },
{"MAC_PCU_HP_QUEUE", "AC_MASK_VO"                            , 0x000283a8, 4 , 4 },
{"MAC_PCU_HP_QUEUE", "AC_MASK_VI"                            , 0x000283a8, 3 , 3 },
{"MAC_PCU_HP_QUEUE", "AC_MASK_BK"                            , 0x000283a8, 2 , 2 },
{"MAC_PCU_HP_QUEUE", "AC_MASK_BE"                            , 0x000283a8, 1 , 1 },
{"MAC_PCU_HP_QUEUE", "ENABLE"                                , 0x000283a8, 0 , 0 },
{"MAC_PCU_AGC_SATURATION_CNT0", "VALUE"                      , 0x000283bc, 31, 0 },
{"MAC_PCU_AGC_SATURATION_CNT1", "VALUE"                      , 0x000283c0, 31, 0 },
{"MAC_PCU_AGC_SATURATION_CNT2", "VALUE"                      , 0x000283c4, 31, 0 },
{"MAC_PCU_HW_BCN_PROC1", "ELM2_ID"                           , 0x000283c8, 31, 24},
{"MAC_PCU_HW_BCN_PROC1", "ELM1_ID"                           , 0x000283c8, 23, 16},
{"MAC_PCU_HW_BCN_PROC1", "ELM0_ID"                           , 0x000283c8, 15, 8 },
{"MAC_PCU_HW_BCN_PROC1", "EXCLUDE_ELM2"                      , 0x000283c8, 7 , 7 },
{"MAC_PCU_HW_BCN_PROC1", "EXCLUDE_ELM1"                      , 0x000283c8, 6 , 6 },
{"MAC_PCU_HW_BCN_PROC1", "EXCLUDE_ELM0"                      , 0x000283c8, 5 , 5 },
{"MAC_PCU_HW_BCN_PROC1", "EXCLUDE_TIM_ELM"                   , 0x000283c8, 4 , 4 },
{"MAC_PCU_HW_BCN_PROC1", "EXCLUDE_CAP_INFO"                  , 0x000283c8, 3 , 3 },
{"MAC_PCU_HW_BCN_PROC1", "EXCLUDE_BCN_INTVL"                 , 0x000283c8, 2 , 2 },
{"MAC_PCU_HW_BCN_PROC1", "RESET_CRC"                         , 0x000283c8, 1 , 1 },
{"MAC_PCU_HW_BCN_PROC1", "CRC_ENABLE"                        , 0x000283c8, 0 , 0 },
{"MAC_PCU_HW_BCN_PROC2", "ELM3_ID"                           , 0x000283cc, 23, 16},
{"MAC_PCU_HW_BCN_PROC2", "FILTER_INTERVAL"                   , 0x000283cc, 15, 8 },
{"MAC_PCU_HW_BCN_PROC2", "EXCLUDE_ELM3"                      , 0x000283cc, 2 , 2 },
{"MAC_PCU_HW_BCN_PROC2", "RESET_INTERVAL"                    , 0x000283cc, 1 , 1 },
{"MAC_PCU_HW_BCN_PROC2", "FILTER_INTERVAL_ENABLE"            , 0x000283cc, 0 , 0 },
{"MAC_PCU_MISC_MODE3", "TIME_BASED_DISCARD_EN"               , 0x000283d0, 31, 31},
{"MAC_PCU_MISC_MODE3", "PER_STA_WEP_ENTRY_ENABLE"            , 0x000283d0, 30, 30},
{"MAC_PCU_MISC_MODE3", "KEY_MISS_FIX"                        , 0x000283d0, 29, 29},
{"MAC_PCU_MISC_MODE3", "PM_FIELD2_FOR_MGT"                   , 0x000283d0, 28, 28},
{"MAC_PCU_MISC_MODE3", "PM_FIELD2_FOR_DAT"                   , 0x000283d0, 27, 27},
{"MAC_PCU_MISC_MODE3", "PM_FIELD2_FOR_CTL"                   , 0x000283d0, 26, 26},
{"MAC_PCU_MISC_MODE3", "PM_FIELD_FOR_MGMT"                   , 0x000283d0, 25, 25},
{"MAC_PCU_MISC_MODE3", "PM_FIELD_FOR_DAT"                    , 0x000283d0, 24, 24},
{"MAC_PCU_MISC_MODE3", "BEACON_FROM_TO_DS_CHECK"             , 0x000283d0, 23, 23},
{"MAC_PCU_MISC_MODE3", "IGNORE_TXOP_IF_ZER0"                 , 0x000283d0, 22, 22},
{"MAC_PCU_MISC_MODE3", "ALLOW_RAC"                           , 0x000283d0, 21, 21},
{"MAC_PCU_MISC_MODE3", "SMOOTHING_FORCE"                     , 0x000283d0, 20, 20},
{"MAC_PCU_MISC_MODE3", "SELF_GEN_SMOOTHING"                  , 0x000283d0, 19, 19},
{"MAC_PCU_MISC_MODE3", "BB_LDPC_EN"                          , 0x000283d0, 18, 18},
{"MAC_PCU_MISC_MODE3", "WAPI_ORDER_MASK"                     , 0x000283d0, 17, 17},
{"MAC_PCU_MISC_MODE3", "MATCH_TID_FOR_BA"                    , 0x000283d0, 16, 16},
{"MAC_PCU_MISC_MODE3", "BA_FRAME_LENGTH"                     , 0x000283d0, 15, 8 },
{"MAC_PCU_MISC_MODE3", "CHECK_LENGTH_FOR_BA"                 , 0x000283d0, 7 , 7 },
{"MAC_PCU_MISC_MODE3", "BUG_61936_FIX_ENABLE"                , 0x000283d0, 6 , 6 },
{"MAC_PCU_MISC_MODE3", "WOW_ADDR1_MASK_ENABLE"               , 0x000283d0, 5 , 5 },
{"MAC_PCU_MISC_MODE3", "BUG_56991_FIX_ENABLE"                , 0x000283d0, 4 , 4 },
{"MAC_PCU_MISC_MODE3", "BUG_58011_FIX_ENABLE"                , 0x000283d0, 3 , 3 },
{"MAC_PCU_MISC_MODE3", "REGULAR_SOUNDING"                    , 0x000283d0, 2 , 2 },
{"MAC_PCU_MISC_MODE3", "AES_3STREAM"                         , 0x000283d0, 1 , 1 },
{"MAC_PCU_MISC_MODE3", "BUG_55702_FIX_ENABLE"                , 0x000283d0, 0 , 0 },
{"MAC_PCU_MISC_MODE4", "IGNORE_RXSM_INIT_STATE"              , 0x000283d4, 17, 17},
{"MAC_PCU_MISC_MODE4", "SMART_ANT_SEL"                       , 0x000283d4, 16, 16},
{"MAC_PCU_MISC_MODE4", "TX_CONFIG_PHY_ERR_ENABLE"            , 0x000283d4, 15, 15},
{"MAC_PCU_MISC_MODE4", "CTS2SELF_AD1_FIX_ENABLE"             , 0x000283d4, 14, 14},
{"MAC_PCU_MISC_MODE4", "ZEROLEN_CRYPTO_ENABLE"               , 0x000283d4, 13, 13},
{"MAC_PCU_MISC_MODE4", "HT_DYNAMIC_CBW"                      , 0x000283d4, 12, 12},
{"MAC_PCU_MISC_MODE4", "ENABLE_SF"                           , 0x000283d4, 11, 11},
{"MAC_PCU_MISC_MODE4", "PEER_ENTRY_SWAP"                     , 0x000283d4, 10, 10},
{"MAC_PCU_MISC_MODE4", "VHT_SERVICE_DYNAMIC"                 , 0x000283d4, 9 , 9 },
{"MAC_PCU_MISC_MODE4", "EV_83864_FIX_ENABLE"                 , 0x000283d4, 8 , 8 },
{"MAC_PCU_MISC_MODE4", "EV_78561_FIX_ENABLE"                 , 0x000283d4, 7 , 7 },
{"MAC_PCU_MISC_MODE4", "SYNC_TSF_ON_UCAST_PROBE_RESP"        , 0x000283d4, 6 , 6 },
{"MAC_PCU_MISC_MODE4", "SYNC_TSF_ON_UCAST_MOON_PROBE_RESP"   , 0x000283d4, 5 , 5 },
{"MAC_PCU_MISC_MODE4", "SYNC_TSF_ON_MCAST_PROBE_RESP"        , 0x000283d4, 4 , 4 },
{"MAC_PCU_MISC_MODE4", "SYNC_TSF_ON_BCAST_PROBE_RESP"        , 0x000283d4, 3 , 3 },
{"MAC_PCU_MISC_MODE4", "SYNC_TSF_ON_BEACON"                  , 0x000283d4, 2 , 2 },
{"MAC_PCU_MISC_MODE4", "BC_MC_WAPI_MODE2"                    , 0x000283d4, 1 , 1 },
{"MAC_PCU_MISC_MODE4", "BC_MC_WAPI_MODE2_EN"                 , 0x000283d4, 0 , 0 },
{"MAC_PCU_PS_FILTER", "PS_SAVE_ENABLE"                       , 0x000283dc, 1 , 1 },
{"MAC_PCU_PS_FILTER", "ENABLE"                               , 0x000283dc, 0 , 0 },
{"MAC_PCU_BASIC_RATE_SET0", "VALUE"                          , 0x000283e0, 29, 0 },
{"MAC_PCU_BASIC_RATE_SET1", "VALUE"                          , 0x000283e4, 29, 0 },
{"MAC_PCU_BASIC_RATE_SET2", "VALUE"                          , 0x000283e8, 29, 0 },
{"MAC_PCU_BASIC_RATE_SET3", "VALUE"                          , 0x000283ec, 24, 0 },
{"MAC_PCU_BASIC_RATE_SET4", "VALUE"                          , 0x000283f0, 9 , 0 },
{"MAC_PCU_TXBUF_BA[0]", "DATA"                               , 0x00028400, 31, 0 },
{"MAC_PCU_TXBUF_BA[1]", "DATA"                               , 0x00028404, 31, 0 },
{"MAC_PCU_TXBUF_BA[2]", "DATA"                               , 0x00028408, 31, 0 },
{"MAC_PCU_TXBUF_BA[3]", "DATA"                               , 0x0002840c, 31, 0 },
{"MAC_PCU_TXBUF_BA[4]", "DATA"                               , 0x00028410, 31, 0 },
{"MAC_PCU_TXBUF_BA[5]", "DATA"                               , 0x00028414, 31, 0 },
{"MAC_PCU_TXBUF_BA[6]", "DATA"                               , 0x00028418, 31, 0 },
{"MAC_PCU_TXBUF_BA[7]", "DATA"                               , 0x0002841c, 31, 0 },
{"MAC_PCU_TXBUF_BA[8]", "DATA"                               , 0x00028420, 31, 0 },
{"MAC_PCU_TXBUF_BA[9]", "DATA"                               , 0x00028424, 31, 0 },
{"MAC_PCU_TXBUF_BA[10]", "DATA"                              , 0x00028428, 31, 0 },
{"MAC_PCU_TXBUF_BA[11]", "DATA"                              , 0x0002842c, 31, 0 },
{"MAC_PCU_TXBUF_BA[12]", "DATA"                              , 0x00028430, 31, 0 },
{"MAC_PCU_TXBUF_BA[13]", "DATA"                              , 0x00028434, 31, 0 },
{"MAC_PCU_TXBUF_BA[14]", "DATA"                              , 0x00028438, 31, 0 },
{"MAC_PCU_TXBUF_BA[15]", "DATA"                              , 0x0002843c, 31, 0 },
{"MAC_PCU_TXBUF_BA[16]", "DATA"                              , 0x00028440, 31, 0 },
{"MAC_PCU_TXBUF_BA[17]", "DATA"                              , 0x00028444, 31, 0 },
{"MAC_PCU_TXBUF_BA[18]", "DATA"                              , 0x00028448, 31, 0 },
{"MAC_PCU_TXBUF_BA[19]", "DATA"                              , 0x0002844c, 31, 0 },
{"MAC_PCU_TXBUF_BA[20]", "DATA"                              , 0x00028450, 31, 0 },
{"MAC_PCU_TXBUF_BA[21]", "DATA"                              , 0x00028454, 31, 0 },
{"MAC_PCU_TXBUF_BA[22]", "DATA"                              , 0x00028458, 31, 0 },
{"MAC_PCU_TXBUF_BA[23]", "DATA"                              , 0x0002845c, 31, 0 },
{"MAC_PCU_TXBUF_BA[24]", "DATA"                              , 0x00028460, 31, 0 },
{"MAC_PCU_TXBUF_BA[25]", "DATA"                              , 0x00028464, 31, 0 },
{"MAC_PCU_TXBUF_BA[26]", "DATA"                              , 0x00028468, 31, 0 },
{"MAC_PCU_TXBUF_BA[27]", "DATA"                              , 0x0002846c, 31, 0 },
{"MAC_PCU_TXBUF_BA[28]", "DATA"                              , 0x00028470, 31, 0 },
{"MAC_PCU_TXBUF_BA[29]", "DATA"                              , 0x00028474, 31, 0 },
{"MAC_PCU_TXBUF_BA[30]", "DATA"                              , 0x00028478, 31, 0 },
{"MAC_PCU_TXBUF_BA[31]", "DATA"                              , 0x0002847c, 31, 0 },
{"MAC_PCU_TXBUF_BA[32]", "DATA"                              , 0x00028480, 31, 0 },
{"MAC_PCU_TXBUF_BA[33]", "DATA"                              , 0x00028484, 31, 0 },
{"MAC_PCU_TXBUF_BA[34]", "DATA"                              , 0x00028488, 31, 0 },
{"MAC_PCU_TXBUF_BA[35]", "DATA"                              , 0x0002848c, 31, 0 },
{"MAC_PCU_TXBUF_BA[36]", "DATA"                              , 0x00028490, 31, 0 },
{"MAC_PCU_TXBUF_BA[37]", "DATA"                              , 0x00028494, 31, 0 },
{"MAC_PCU_TXBUF_BA[38]", "DATA"                              , 0x00028498, 31, 0 },
{"MAC_PCU_TXBUF_BA[39]", "DATA"                              , 0x0002849c, 31, 0 },
{"MAC_PCU_TXBUF_BA[40]", "DATA"                              , 0x000284a0, 31, 0 },
{"MAC_PCU_TXBUF_BA[41]", "DATA"                              , 0x000284a4, 31, 0 },
{"MAC_PCU_TXBUF_BA[42]", "DATA"                              , 0x000284a8, 31, 0 },
{"MAC_PCU_TXBUF_BA[43]", "DATA"                              , 0x000284ac, 31, 0 },
{"MAC_PCU_TXBUF_BA[44]", "DATA"                              , 0x000284b0, 31, 0 },
{"MAC_PCU_TXBUF_BA[45]", "DATA"                              , 0x000284b4, 31, 0 },
{"MAC_PCU_TXBUF_BA[46]", "DATA"                              , 0x000284b8, 31, 0 },
{"MAC_PCU_TXBUF_BA[47]", "DATA"                              , 0x000284bc, 31, 0 },
{"MAC_PCU_TXBUF_BA[48]", "DATA"                              , 0x000284c0, 31, 0 },
{"MAC_PCU_TXBUF_BA[49]", "DATA"                              , 0x000284c4, 31, 0 },
{"MAC_PCU_TXBUF_BA[50]", "DATA"                              , 0x000284c8, 31, 0 },
{"MAC_PCU_TXBUF_BA[51]", "DATA"                              , 0x000284cc, 31, 0 },
{"MAC_PCU_TXBUF_BA[52]", "DATA"                              , 0x000284d0, 31, 0 },
{"MAC_PCU_TXBUF_BA[53]", "DATA"                              , 0x000284d4, 31, 0 },
{"MAC_PCU_TXBUF_BA[54]", "DATA"                              , 0x000284d8, 31, 0 },
{"MAC_PCU_TXBUF_BA[55]", "DATA"                              , 0x000284dc, 31, 0 },
{"MAC_PCU_TXBUF_BA[56]", "DATA"                              , 0x000284e0, 31, 0 },
{"MAC_PCU_TXBUF_BA[57]", "DATA"                              , 0x000284e4, 31, 0 },
{"MAC_PCU_TXBUF_BA[58]", "DATA"                              , 0x000284e8, 31, 0 },
{"MAC_PCU_TXBUF_BA[59]", "DATA"                              , 0x000284ec, 31, 0 },
{"MAC_PCU_TXBUF_BA[60]", "DATA"                              , 0x000284f0, 31, 0 },
{"MAC_PCU_TXBUF_BA[61]", "DATA"                              , 0x000284f4, 31, 0 },
{"MAC_PCU_TXBUF_BA[62]", "DATA"                              , 0x000284f8, 31, 0 },
{"MAC_PCU_TXBUF_BA[63]", "DATA"                              , 0x000284fc, 31, 0 },
{"MAC_PCU_BT_BT[0]", "WEIGHT"                                , 0x00028500, 31, 0 },
{"MAC_PCU_BT_BT[1]", "WEIGHT"                                , 0x00028504, 31, 0 },
{"MAC_PCU_BT_BT[2]", "WEIGHT"                                , 0x00028508, 31, 0 },
{"MAC_PCU_BT_BT[3]", "WEIGHT"                                , 0x0002850c, 31, 0 },
{"MAC_PCU_BT_BT[4]", "WEIGHT"                                , 0x00028510, 31, 0 },
{"MAC_PCU_BT_BT[5]", "WEIGHT"                                , 0x00028514, 31, 0 },
{"MAC_PCU_BT_BT[6]", "WEIGHT"                                , 0x00028518, 31, 0 },
{"MAC_PCU_BT_BT[7]", "WEIGHT"                                , 0x0002851c, 31, 0 },
{"MAC_PCU_BT_BT[8]", "WEIGHT"                                , 0x00028520, 31, 0 },
{"MAC_PCU_BT_BT[9]", "WEIGHT"                                , 0x00028524, 31, 0 },
{"MAC_PCU_BT_BT[10]", "WEIGHT"                               , 0x00028528, 31, 0 },
{"MAC_PCU_BT_BT[11]", "WEIGHT"                               , 0x0002852c, 31, 0 },
{"MAC_PCU_BT_BT[12]", "WEIGHT"                               , 0x00028530, 31, 0 },
{"MAC_PCU_BT_BT[13]", "WEIGHT"                               , 0x00028534, 31, 0 },
{"MAC_PCU_BT_BT[14]", "WEIGHT"                               , 0x00028538, 31, 0 },
{"MAC_PCU_BT_BT[15]", "WEIGHT"                               , 0x0002853c, 31, 0 },
{"MAC_PCU_BT_BT[16]", "WEIGHT"                               , 0x00028540, 31, 0 },
{"MAC_PCU_BT_BT[17]", "WEIGHT"                               , 0x00028544, 31, 0 },
{"MAC_PCU_BT_BT[18]", "WEIGHT"                               , 0x00028548, 31, 0 },
{"MAC_PCU_BT_BT[19]", "WEIGHT"                               , 0x0002854c, 31, 0 },
{"MAC_PCU_BT_BT[20]", "WEIGHT"                               , 0x00028550, 31, 0 },
{"MAC_PCU_BT_BT[21]", "WEIGHT"                               , 0x00028554, 31, 0 },
{"MAC_PCU_BT_BT[22]", "WEIGHT"                               , 0x00028558, 31, 0 },
{"MAC_PCU_BT_BT[23]", "WEIGHT"                               , 0x0002855c, 31, 0 },
{"MAC_PCU_BT_BT[24]", "WEIGHT"                               , 0x00028560, 31, 0 },
{"MAC_PCU_BT_BT[25]", "WEIGHT"                               , 0x00028564, 31, 0 },
{"MAC_PCU_BT_BT[26]", "WEIGHT"                               , 0x00028568, 31, 0 },
{"MAC_PCU_BT_BT[27]", "WEIGHT"                               , 0x0002856c, 31, 0 },
{"MAC_PCU_BT_BT[28]", "WEIGHT"                               , 0x00028570, 31, 0 },
{"MAC_PCU_BT_BT[29]", "WEIGHT"                               , 0x00028574, 31, 0 },
{"MAC_PCU_BT_BT[30]", "WEIGHT"                               , 0x00028578, 31, 0 },
{"MAC_PCU_BT_BT[31]", "WEIGHT"                               , 0x0002857c, 31, 0 },
{"MAC_PCU_BT_BT[32]", "WEIGHT"                               , 0x00028580, 31, 0 },
{"MAC_PCU_BT_BT[33]", "WEIGHT"                               , 0x00028584, 31, 0 },
{"MAC_PCU_BT_BT[34]", "WEIGHT"                               , 0x00028588, 31, 0 },
{"MAC_PCU_BT_BT[35]", "WEIGHT"                               , 0x0002858c, 31, 0 },
{"MAC_PCU_BT_BT[36]", "WEIGHT"                               , 0x00028590, 31, 0 },
{"MAC_PCU_BT_BT[37]", "WEIGHT"                               , 0x00028594, 31, 0 },
{"MAC_PCU_BT_BT[38]", "WEIGHT"                               , 0x00028598, 31, 0 },
{"MAC_PCU_BT_BT[39]", "WEIGHT"                               , 0x0002859c, 31, 0 },
{"MAC_PCU_BT_BT[40]", "WEIGHT"                               , 0x000285a0, 31, 0 },
{"MAC_PCU_BT_BT[41]", "WEIGHT"                               , 0x000285a4, 31, 0 },
{"MAC_PCU_BT_BT[42]", "WEIGHT"                               , 0x000285a8, 31, 0 },
{"MAC_PCU_BT_BT[43]", "WEIGHT"                               , 0x000285ac, 31, 0 },
{"MAC_PCU_BT_BT[44]", "WEIGHT"                               , 0x000285b0, 31, 0 },
{"MAC_PCU_BT_BT[45]", "WEIGHT"                               , 0x000285b4, 31, 0 },
{"MAC_PCU_BT_BT[46]", "WEIGHT"                               , 0x000285b8, 31, 0 },
{"MAC_PCU_BT_BT[47]", "WEIGHT"                               , 0x000285bc, 31, 0 },
{"MAC_PCU_BT_BT[48]", "WEIGHT"                               , 0x000285c0, 31, 0 },
{"MAC_PCU_BT_BT[49]", "WEIGHT"                               , 0x000285c4, 31, 0 },
{"MAC_PCU_BT_BT[50]", "WEIGHT"                               , 0x000285c8, 31, 0 },
{"MAC_PCU_BT_BT[51]", "WEIGHT"                               , 0x000285cc, 31, 0 },
{"MAC_PCU_BT_BT[52]", "WEIGHT"                               , 0x000285d0, 31, 0 },
{"MAC_PCU_BT_BT[53]", "WEIGHT"                               , 0x000285d4, 31, 0 },
{"MAC_PCU_BT_BT[54]", "WEIGHT"                               , 0x000285d8, 31, 0 },
{"MAC_PCU_BT_BT[55]", "WEIGHT"                               , 0x000285dc, 31, 0 },
{"MAC_PCU_BT_BT[56]", "WEIGHT"                               , 0x000285e0, 31, 0 },
{"MAC_PCU_BT_BT[57]", "WEIGHT"                               , 0x000285e4, 31, 0 },
{"MAC_PCU_BT_BT[58]", "WEIGHT"                               , 0x000285e8, 31, 0 },
{"MAC_PCU_BT_BT[59]", "WEIGHT"                               , 0x000285ec, 31, 0 },
{"MAC_PCU_BT_BT[60]", "WEIGHT"                               , 0x000285f0, 31, 0 },
{"MAC_PCU_BT_BT[61]", "WEIGHT"                               , 0x000285f4, 31, 0 },
{"MAC_PCU_BT_BT[62]", "WEIGHT"                               , 0x000285f8, 31, 0 },
{"MAC_PCU_BT_BT[63]", "WEIGHT"                               , 0x000285fc, 31, 0 },
{"MAC_PCU_RX_INT_STATUS0", "DURATION_H"                      , 0x00028600, 31, 24},
{"MAC_PCU_RX_INT_STATUS0", "DURATION_L"                      , 0x00028600, 23, 16},
{"MAC_PCU_RX_INT_STATUS0", "FRAME_CONTROL_H"                 , 0x00028600, 15, 8 },
{"MAC_PCU_RX_INT_STATUS0", "FRAME_CONTROL_L"                 , 0x00028600, 7 , 0 },
{"MAC_PCU_RX_INT_STATUS1", "VALUE"                           , 0x00028604, 17, 0 },
{"MAC_PCU_RX_INT_STATUS2", "VALUE"                           , 0x00028608, 26, 0 },
{"MAC_PCU_RX_INT_STATUS3", "VALUE"                           , 0x0002860c, 23, 0 },
{"HT_HALF_GI_RATE1", "MCS3"                                  , 0x00028610, 31, 24},
{"HT_HALF_GI_RATE1", "MCS2"                                  , 0x00028610, 23, 16},
{"HT_HALF_GI_RATE1", "MCS1"                                  , 0x00028610, 15, 8 },
{"HT_HALF_GI_RATE1", "MCS0"                                  , 0x00028610, 7 , 0 },
{"HT_HALF_GI_RATE2", "MCS7"                                  , 0x00028614, 31, 24},
{"HT_HALF_GI_RATE2", "MCS6"                                  , 0x00028614, 23, 16},
{"HT_HALF_GI_RATE2", "MCS5"                                  , 0x00028614, 15, 8 },
{"HT_HALF_GI_RATE2", "MCS4"                                  , 0x00028614, 7 , 0 },
{"HT_FULL_GI_RATE1", "MCS3"                                  , 0x00028618, 31, 24},
{"HT_FULL_GI_RATE1", "MCS2"                                  , 0x00028618, 23, 16},
{"HT_FULL_GI_RATE1", "MCS1"                                  , 0x00028618, 15, 8 },
{"HT_FULL_GI_RATE1", "MCS0"                                  , 0x00028618, 7 , 0 },
{"HT_FULL_GI_RATE2", "MCS7"                                  , 0x0002861c, 31, 24},
{"HT_FULL_GI_RATE2", "MCS6"                                  , 0x0002861c, 23, 16},
{"HT_FULL_GI_RATE2", "MCS5"                                  , 0x0002861c, 15, 8 },
{"HT_FULL_GI_RATE2", "MCS4"                                  , 0x0002861c, 7 , 0 },
{"LEGACY_RATE1", "RATE12"                                    , 0x00028620, 29, 24},
{"LEGACY_RATE1", "RATE11"                                    , 0x00028620, 23, 18},
{"LEGACY_RATE1", "RATE10"                                    , 0x00028620, 17, 12},
{"LEGACY_RATE1", "RATE9"                                     , 0x00028620, 11, 6 },
{"LEGACY_RATE1", "RATE8"                                     , 0x00028620, 5 , 0 },
{"LEGACY_RATE2", "RATE25"                                    , 0x00028624, 29, 24},
{"LEGACY_RATE2", "RATE24"                                    , 0x00028624, 23, 18},
{"LEGACY_RATE2", "RATE15"                                    , 0x00028624, 17, 12},
{"LEGACY_RATE2", "RATE14"                                    , 0x00028624, 11, 6 },
{"LEGACY_RATE2", "RATE13"                                    , 0x00028624, 5 , 0 },
{"LEGACY_RATE3", "RATE30"                                    , 0x00028628, 29, 24},
{"LEGACY_RATE3", "RATE29"                                    , 0x00028628, 23, 18},
{"LEGACY_RATE3", "RATE28"                                    , 0x00028628, 17, 12},
{"LEGACY_RATE3", "RATE27"                                    , 0x00028628, 11, 6 },
{"LEGACY_RATE3", "RATE26"                                    , 0x00028628, 5 , 0 },
{"RX_INT_FILTER", "RSSI_HIGH"                                , 0x0002862c, 18, 18},
{"RX_INT_FILTER", "BEACON"                                   , 0x0002862c, 17, 17},
{"RX_INT_FILTER", "AMPDU"                                    , 0x0002862c, 16, 16},
{"RX_INT_FILTER", "EOSP"                                     , 0x0002862c, 15, 15},
{"RX_INT_FILTER", "LENGTH_LOW"                               , 0x0002862c, 14, 14},
{"RX_INT_FILTER", "LENGTH_HIGH"                              , 0x0002862c, 13, 13},
{"RX_INT_FILTER", "RSSI"                                     , 0x0002862c, 12, 12},
{"RX_INT_FILTER", "RATE_LOW"                                 , 0x0002862c, 11, 11},
{"RX_INT_FILTER", "RATE_HIGH"                                , 0x0002862c, 10, 10},
{"RX_INT_FILTER", "MORE_FRAG"                                , 0x0002862c, 9 , 9 },
{"RX_INT_FILTER", "MORE_DATA"                                , 0x0002862c, 8 , 8 },
{"RX_INT_FILTER", "RETRY"                                    , 0x0002862c, 7 , 7 },
{"RX_INT_FILTER", "CTS"                                      , 0x0002862c, 6 , 6 },
{"RX_INT_FILTER", "ACK"                                      , 0x0002862c, 5 , 5 },
{"RX_INT_FILTER", "RTS"                                      , 0x0002862c, 4 , 4 },
{"RX_INT_FILTER", "MCAST"                                    , 0x0002862c, 3 , 3 },
{"RX_INT_FILTER", "BCAST"                                    , 0x0002862c, 2 , 2 },
{"RX_INT_FILTER", "DIRECTED"                                 , 0x0002862c, 1 , 1 },
{"RX_INT_FILTER", "ENABLE"                                   , 0x0002862c, 0 , 0 },
{"RX_INT_OVERFLOW", "STATUS"                                 , 0x00028630, 0 , 0 },
{"RX_FILTER_THRESH0", "RSSI_HIGH"                            , 0x00028634, 31, 24},
{"RX_FILTER_THRESH0", "RSSI_LOW"                             , 0x00028634, 23, 16},
{"RX_FILTER_THRESH0", "RATE_LOW"                             , 0x00028634, 15, 8 },
{"RX_FILTER_THRESH0", "RATE_HIGH"                            , 0x00028634, 7 , 0 },
{"RX_FILTER_THRESH1", "LENGTH_LOW"                           , 0x00028638, 23, 12},
{"RX_FILTER_THRESH1", "LENGTH_HIGH"                          , 0x00028638, 11, 0 },
{"RX_PRIORITY_THRESH0", "RSSI_LOW"                           , 0x0002863c, 31, 24},
{"RX_PRIORITY_THRESH0", "RSSI_HIGH"                          , 0x0002863c, 23, 16},
{"RX_PRIORITY_THRESH0", "RATE_LOW"                           , 0x0002863c, 15, 8 },
{"RX_PRIORITY_THRESH0", "RATE_HIGH"                          , 0x0002863c, 7 , 0 },
{"RX_PRIORITY_THRESH1", "XCAST_RSSI_HIGH"                    , 0x00028640, 31, 24},
{"RX_PRIORITY_THRESH1", "LENGTH_LOW"                         , 0x00028640, 23, 12},
{"RX_PRIORITY_THRESH1", "LENGTH_HIGH"                        , 0x00028640, 11, 0 },
{"RX_PRIORITY_THRESH2", "NULL_RSSI_HIGH"                     , 0x00028644, 31, 24},
{"RX_PRIORITY_THRESH2", "BEACON_RSSI_HIGH"                   , 0x00028644, 23, 16},
{"RX_PRIORITY_THRESH2", "MGMT_RSSI_HIGH"                     , 0x00028644, 15, 8 },
{"RX_PRIORITY_THRESH2", "PRESP_RSSI_HIGH"                    , 0x00028644, 7 , 0 },
{"RX_PRIORITY_THRESH3", "PS_POLL_RSSI_HIGH"                  , 0x00028648, 15, 8 },
{"RX_PRIORITY_THRESH3", "PREQ_RSSI_HIGH"                     , 0x00028648, 7 , 0 },
{"RX_PRIORITY_OFFSET0", "XCAST_RSSI_HIGH"                    , 0x0002864c, 29, 24},
{"RX_PRIORITY_OFFSET0", "RSSI_LOW"                           , 0x0002864c, 23, 18},
{"RX_PRIORITY_OFFSET0", "RSSI_HIGH"                          , 0x0002864c, 17, 12},
{"RX_PRIORITY_OFFSET0", "PHY_RATE_LOW"                       , 0x0002864c, 11, 6 },
{"RX_PRIORITY_OFFSET0", "PHY_RATE_HIGH"                      , 0x0002864c, 5 , 0 },
{"RX_PRIORITY_OFFSET1", "RTS"                                , 0x00028650, 29, 24},
{"RX_PRIORITY_OFFSET1", "RETX"                               , 0x00028650, 23, 18},
{"RX_PRIORITY_OFFSET1", "PRESP_RSSI_HIGH"                    , 0x00028650, 17, 12},
{"RX_PRIORITY_OFFSET1", "LENGTH_LOW"                         , 0x00028650, 11, 6 },
{"RX_PRIORITY_OFFSET1", "LENGTH_HIGH"                        , 0x00028650, 5 , 0 },
{"RX_PRIORITY_OFFSET2", "BEACON"                             , 0x00028654, 29, 24},
{"RX_PRIORITY_OFFSET2", "MGMT"                               , 0x00028654, 23, 18},
{"RX_PRIORITY_OFFSET2", "ATIM"                               , 0x00028654, 17, 12},
{"RX_PRIORITY_OFFSET2", "PRESP"                              , 0x00028654, 11, 6 },
{"RX_PRIORITY_OFFSET2", "XCAST"                              , 0x00028654, 5 , 0 },
{"RX_PRIORITY_OFFSET3", "PS_POLL"                            , 0x00028658, 29, 24},
{"RX_PRIORITY_OFFSET3", "AMSDU"                              , 0x00028658, 23, 18},
{"RX_PRIORITY_OFFSET3", "AMPDU"                              , 0x00028658, 17, 12},
{"RX_PRIORITY_OFFSET3", "EOSP"                               , 0x00028658, 11, 6 },
{"RX_PRIORITY_OFFSET3", "MORE"                               , 0x00028658, 5 , 0 },
{"RX_PRIORITY_OFFSET4", "BEACON_RSSI_HIGH"                   , 0x0002865c, 29, 24},
{"RX_PRIORITY_OFFSET4", "MGMT_RSSI_HIGH"                     , 0x0002865c, 23, 18},
{"RX_PRIORITY_OFFSET4", "BEACON_SSID"                        , 0x0002865c, 17, 12},
{"RX_PRIORITY_OFFSET4", "NULL"                               , 0x0002865c, 11, 6 },
{"RX_PRIORITY_OFFSET4", "PREQ"                               , 0x0002865c, 5 , 0 },
{"RX_PRIORITY_OFFSET5", "PS_POLL_RSSI_HIGH"                  , 0x00028660, 17, 12},
{"RX_PRIORITY_OFFSET5", "PREQ_RSSI_HIGH"                     , 0x00028660, 11, 6 },
{"RX_PRIORITY_OFFSET5", "NULL_RSSI_HIGH"                     , 0x00028660, 5 , 0 },
{"MAC_PCU_LAST_BEACON2_TSF", "VALUE"                         , 0x00028664, 31, 0 },
{"MAC_PCU_PHY_ERROR_AIFS", "MASK_ENABLE"                     , 0x00028668, 0 , 0 },
{"MAC_PCU_PHY_ERROR_AIFS_MASK", "VALUE"                      , 0x0002866c, 31, 0 },
{"MAC_PCU_FILTER_RSSI_AVE", "RESET"                          , 0x00028670, 12, 12},
{"MAC_PCU_FILTER_RSSI_AVE", "ENABLE"                         , 0x00028670, 11, 11},
{"MAC_PCU_FILTER_RSSI_AVE", "NUM_FRAMES_EXPONENT"            , 0x00028670, 10, 8 },
{"MAC_PCU_FILTER_RSSI_AVE", "AVE_VALUE"                      , 0x00028670, 7 , 0 },
{"MAC_PCU_TBD_FILTER", "USE_WBTIMER_RX_TS"                   , 0x00028674, 1 , 1 },
{"MAC_PCU_TBD_FILTER", "USE_WBTIMER_TX_TS"                   , 0x00028674, 0 , 0 },
{"MAC_PCU_BT_ANT_SLEEP_EXTEND", "CNT"                        , 0x00028678, 15, 0 },
{"MAC_ASE_AST_BASE_ADDR", "VALUE"                            , 0x0002867c, 31, 0 },
{"MAC_ASE_AST_SIZE", "VALUE"                                 , 0x00028680, 12, 0 },
{"MAC_ASE_SEARCH_CTRL", "TIMEOUT_THRESH"                     , 0x00028684, 31, 16},
{"MAC_ASE_SEARCH_CTRL", "ADDR_SEARCH_SWAP"                   , 0x00028684, 8 , 8 },
{"MAC_ASE_SEARCH_CTRL", "MAX_SEARCH"                         , 0x00028684, 7 , 0 },
{"MAC_ASE_HASH_CTRL", "CACHE_INVALIDATE"                     , 0x00028688, 23, 23},
{"MAC_ASE_HASH_CTRL", "CACHE_DISABLE"                        , 0x00028688, 22, 22},
{"MAC_ASE_HASH_CTRL", "HASH_MAC_31_0_IGNORE"                 , 0x00028688, 21, 21},
{"MAC_ASE_HASH_CTRL", "HASH_SEL"                             , 0x00028688, 20, 20},
{"MAC_ASE_HASH_CTRL", "HASH_MCAST_SHIFT"                     , 0x00028688, 19, 16},
{"MAC_ASE_HASH_CTRL", "HASH_XOR"                             , 0x00028688, 15, 0 },
{"MAC_PCU_BSSID3_L32", "ADDR"                                , 0x0002868c, 31, 0 },
{"MAC_PCU_BSSID3_U16", "ENABLE"                              , 0x00028690, 16, 16},
{"MAC_PCU_BSSID3_U16", "ADDR"                                , 0x00028690, 15, 0 },
{"MAC_PCU_BSSID4_L32", "ADDR"                                , 0x00028694, 31, 0 },
{"MAC_PCU_BSSID4_U16", "ENABLE"                              , 0x00028698, 16, 16},
{"MAC_PCU_BSSID4_U16", "ADDR"                                , 0x00028698, 15, 0 },
{"MAC_PCU_RX_FILTER2", "BSSID_BASED_UNICAST"                 , 0x0002869c, 3 , 0 },
{"MAC_PCU_RTT_CTRL", "ALLOW_HT_VHT_ACK_BA"                   , 0x000286a0, 16, 16},
{"MAC_PCU_RTT_CTRL", "ACTION"                                , 0x000286a0, 15, 8 },
{"MAC_PCU_RTT_CTRL", "CATEGORY"                              , 0x000286a0, 7 , 0 },
{"MAC_PCU_PHY_ERROR_CODE", "VALUE"                           , 0x000286a4, 7 , 0 },
{"MAC_PCU_PHY_ERROR_EIFS_MASK_CONT", "VALUE"                 , 0x000286a8, 31, 0 },
{"MAC_PCU_PHY_ERROR_AIFS_MASK_CONT", "VALUE"                 , 0x000286ac, 31, 0 },
{"MAC_PCU_PHY_ERR_CNT_2_MASK_CONT", "VALUE"                  , 0x000286b0, 31, 0 },
{"MAC_PCU_PHY_ERR_CNT_3_MASK_CONT", "VALUE"                  , 0x000286b4, 31, 0 },
{"MAC_PCU_PHY_DATA_LENGTH_THRESH", "ENABLE"                  , 0x000286b8, 16, 16},
{"MAC_PCU_PHY_DATA_LENGTH_THRESH", "VALUE"                   , 0x000286b8, 13, 0 },
{"MAC_PCU_SEC_CHANNEL_TX_PIFS_CNT", "VALUE"                  , 0x000286bc, 31, 0 },
{"MAC_PCU_SEC_CHANNEL_RX_PIFS_CNT", "VALUE"                  , 0x000286c0, 31, 0 },
{"BB_timing_controls_1", "fft_scaling"                       , 0x00029800, 31, 31},
{"BB_timing_controls_1", "coarse_ppm_select"                 , 0x00029800, 30, 29},
{"BB_timing_controls_1", "timing_leak_enable"                , 0x00029800, 28, 28},
{"BB_timing_controls_1", "enable_long_rescale"               , 0x00029800, 27, 27},
{"BB_timing_controls_1", "false_alarm"                       , 0x00029800, 26, 25},
{"BB_timing_controls_1", "enable_channel_filter"             , 0x00029800, 24, 24},
{"BB_timing_controls_1", "enable_rx_stbc"                    , 0x00029800, 23, 23},
{"BB_timing_controls_1", "enable_long_chanfil"               , 0x00029800, 22, 22},
{"BB_timing_controls_1", "ht_fine_ppm_qam"                   , 0x00029800, 21, 20},
{"BB_timing_controls_1", "ht_fine_ppm_stream"                , 0x00029800, 19, 18},
{"BB_timing_controls_1", "enable_ht_fine_ppm"                , 0x00029800, 17, 17},
{"BB_timing_controls_1", "timing_backoff"                    , 0x00029800, 16, 13},
{"BB_timing_controls_1", "ste_to_long1"                      , 0x00029800, 12, 7 },
{"BB_timing_controls_1", "ste_thr"                           , 0x00029800, 6 , 0 },
{"BB_timing_controls_2", "enable_ht_fine_timing"             , 0x00029804, 31, 31},
{"BB_timing_controls_2", "traceback128"                      , 0x00029804, 30, 30},
{"BB_timing_controls_2", "enable_weighting"                  , 0x00029804, 29, 29},
{"BB_timing_controls_2", "enable_dc_offset_track"            , 0x00029804, 28, 28},
{"BB_timing_controls_2", "enable_dc_offset"                  , 0x00029804, 27, 27},
{"BB_timing_controls_2", "dc_off_tim_const"                  , 0x00029804, 26, 24},
{"BB_timing_controls_2", "dc_off_deltaf_thres"               , 0x00029804, 22, 16},
{"BB_timing_controls_2", "enable_offset_filter"              , 0x00029804, 15, 15},
{"BB_timing_controls_2", "enable_slope_filter"               , 0x00029804, 14, 14},
{"BB_timing_controls_2", "enable_magnitude_track"            , 0x00029804, 13, 13},
{"BB_timing_controls_2", "force_delta_phi_symbol"            , 0x00029804, 12, 12},
{"BB_timing_controls_2", "forced_delta_phi_symbol"           , 0x00029804, 11, 0 },
{"BB_timing_controls_3", "delta_slope_coef_man"              , 0x00029808, 31, 17},
{"BB_timing_controls_3", "delta_slope_coef_exp"              , 0x00029808, 16, 13},
{"BB_timing_controls_3", "enable_df_chanest"                 , 0x00029808, 12, 12},
{"BB_timing_controls_3", "continuous_ppm_rescue"             , 0x00029808, 11, 11},
{"BB_timing_controls_3", "enable_fine_interp"                , 0x00029808, 10, 10},
{"BB_timing_controls_3", "enable_fine_ppm"                   , 0x00029808, 9 , 9 },
{"BB_timing_controls_3", "enable_ppm_rescue"                 , 0x00029808, 8 , 8 },
{"BB_timing_controls_3", "ppm_rescue_interval"               , 0x00029808, 7 , 0 },
{"BB_timing_control_4", "enable_spur_rssi"                   , 0x0002980c, 31, 31},
{"BB_timing_control_4", "enable_chan_mask"                   , 0x0002980c, 29, 29},
{"BB_timing_control_4", "enable_pilot_mask"                  , 0x0002980c, 28, 28},
{"BB_timing_control_4", "early_trigger_thr"                  , 0x0002980c, 27, 21},
{"BB_timing_control_4", "use_pilot_track_df"                 , 0x0002980c, 20, 17},
{"BB_timing_control_4", "do_gain_dc_iq_cal"                  , 0x0002980c, 16, 16},
{"BB_timing_control_4", "cal_lg_count_max"                   , 0x0002980c, 15, 12},
{"BB_timing_control_5", "enable_spur_filter"                 , 0x00029810, 31, 30},
{"BB_timing_control_5", "long_sc_thresh_hi_rssi"             , 0x00029810, 29, 23},
{"BB_timing_control_5", "rssi_thr1a"                         , 0x00029810, 22, 16},
{"BB_timing_control_5", "enable_rssi_thr1a"                  , 0x00029810, 15, 15},
{"BB_timing_control_5", "cycpwr_thr1"                        , 0x00029810, 7 , 1 },
{"BB_timing_control_5", "enable_cycpwr_thr1"                 , 0x00029810, 0 , 0 },
{"BB_timing_control_6", "ofdm_xcorr_thresh_hi_rssi"          , 0x00029814, 27, 21},
{"BB_timing_control_6", "ofdm_xcorr_thresh"                  , 0x00029814, 20, 15},
{"BB_timing_control_6", "early_trigger_thr_hi_rssi"          , 0x00029814, 14, 8 },
{"BB_timing_control_6", "hi_rssi_thresh"                     , 0x00029814, 7 , 0 },
{"BB_timing_control_11", "use_spur_filter_in_selfcor"        , 0x00029818, 31, 31},
{"BB_timing_control_11", "use_spur_filter_in_agc"            , 0x00029818, 30, 30},
{"BB_timing_control_11", "spur_freq_sd"                      , 0x00029818, 29, 20},
{"BB_timing_control_11", "spur_delta_phase"                  , 0x00029818, 19, 0 },
{"BB_spur_mask_controls", "enable_nf_rssi_spur_mit"          , 0x0002981c, 26, 26},
{"BB_spur_mask_controls", "mask_rate_cntl"                   , 0x0002981c, 25, 18},
{"BB_spur_mask_controls", "enable_mask_ppm"                  , 0x0002981c, 17, 17},
{"BB_spur_mask_controls", "en_vit_spur_rssi"                 , 0x0002981c, 8 , 8 },
{"BB_spur_mask_controls", "spur_rssi_thresh"                 , 0x0002981c, 7 , 0 },
{"BB_find_signal_low", "long_sc_thresh"                      , 0x00029820, 30, 24},
{"BB_find_signal_low", "ycok_max_low"                        , 0x00029820, 23, 20},
{"BB_find_signal_low", "firpwr_low"                          , 0x00029820, 19, 12},
{"BB_find_signal_low", "firstep_low"                         , 0x00029820, 11, 6 },
{"BB_find_signal_low", "relstep_low"                         , 0x00029820, 5 , 0 },
{"BB_sfcorr", "m2_thres"                                     , 0x00029824, 30, 24},
{"BB_sfcorr", "m1_thres"                                     , 0x00029824, 23, 17},
{"BB_sfcorr", "adcsat_icount"                                , 0x00029824, 16, 11},
{"BB_sfcorr", "adcsat_thresh"                                , 0x00029824, 10, 5 },
{"BB_sfcorr", "m2count_thr"                                  , 0x00029824, 4 , 0 },
{"BB_self_corr_low", "m2_thresh_low"                         , 0x00029828, 27, 21},
{"BB_self_corr_low", "m1_thresh_low"                         , 0x00029828, 20, 14},
{"BB_self_corr_low", "m2count_thr_low"                       , 0x00029828, 13, 8 },
{"BB_self_corr_low", "m1count_max_low"                       , 0x00029828, 7 , 1 },
{"BB_self_corr_low", "use_self_corr_low"                     , 0x00029828, 0 , 0 },
{"BB_timing_control_12", "spur_delta_phase_2nd"              , 0x0002982c, 19, 0 },
{"BB_radar_detection", "radar_firpwr_thresh"                 , 0x00029834, 30, 24},
{"BB_radar_detection", "pulse_drop_thresh"                   , 0x00029834, 23, 18},
{"BB_radar_detection", "pulse_height_thresh"                 , 0x00029834, 17, 12},
{"BB_radar_detection", "pulse_rssi_thresh"                   , 0x00029834, 11, 6 },
{"BB_radar_detection", "pulse_detect_enable"                 , 0x00029834, 0 , 0 },
{"BB_radar_detection_2", "enable_pulse_drop_check"           , 0x00029838, 30, 30},
{"BB_radar_detection_2", "enable_pulse_relpwr_check"         , 0x00029838, 29, 29},
{"BB_radar_detection_2", "enable_pulse_relstep_check"        , 0x00029838, 28, 28},
{"BB_radar_detection_2", "enable_pulse_gc_count_check"       , 0x00029838, 27, 27},
{"BB_radar_detection_2", "pulse_relpwr_thresh"               , 0x00029838, 20, 16},
{"BB_radar_detection_2", "pulse_relstep_thresh"              , 0x00029838, 12, 8 },
{"BB_radar_detection_2", "pulse_width_max"                   , 0x00029838, 7 , 0 },
{"BB_extension_radar", "radar_lb_dc_cap"                     , 0x0002983c, 31, 23},
{"BB_extension_radar", "lb_dc_cap_pulse_nb_mask"             , 0x0002983c, 21, 21},
{"BB_extension_radar", "lb_dc_cap_pulse_dc_mask"             , 0x0002983c, 20, 20},
{"BB_extension_radar", "radar_lb_dc_cap_fine"                , 0x0002983c, 16, 8 },
{"BB_extension_radar", "restart_lgdfspwr_delta"              , 0x0002983c, 5 , 0 },
{"BB_multichain_control", "enable_dyn_deweight"              , 0x00029880, 31, 31},
{"BB_multichain_control", "enable_static_deweight"           , 0x00029880, 30, 30},
{"BB_multichain_control", "force_sigma_zero"                 , 0x00029880, 29, 29},
{"BB_multichain_control", "forced_gain_diff_02"              , 0x00029880, 28, 22},
{"BB_multichain_control", "cf_short_sat"                     , 0x00029880, 20, 10},
{"BB_multichain_control", "use_posedge_refclk"               , 0x00029880, 9 , 9 },
{"BB_multichain_control", "sync_synthon"                     , 0x00029880, 8 , 8 },
{"BB_multichain_control", "forced_gain_diff_01"              , 0x00029880, 7 , 1 },
{"BB_multichain_control", "force_analog_gain_diff"           , 0x00029880, 0 , 0 },
{"BB_per_chain_csd", "overlap_window_bw80MHz"                , 0x00029884, 23, 21},
{"BB_per_chain_csd", "overlap_window_bw40MHz"                , 0x00029884, 20, 18},
{"BB_per_chain_csd", "overlap_window_bw20MHz"                , 0x00029884, 17, 15},
{"BB_per_chain_csd", "csd_chn2_3chains"                      , 0x00029884, 14, 10},
{"BB_per_chain_csd", "csd_chn1_3chains"                      , 0x00029884, 9 , 5 },
{"BB_per_chain_csd", "csd_chn1_2chains"                      , 0x00029884, 4 , 0 },
{"BB_pre_emphasis_bw20_b0", "pre_emp_db_neg_bw20_0"          , 0x00029888, 29, 15},
{"BB_pre_emphasis_bw20_b0", "pre_emp_db_pos_bw20_0"          , 0x00029888, 14, 0 },
{"BB_pre_emphasis_bw40_b0", "pre_emp_db_neg_bw40_0"          , 0x0002988c, 29, 15},
{"BB_pre_emphasis_bw40_b0", "pre_emp_db_pos_bw40_0"          , 0x0002988c, 14, 0 },
{"BB_pre_emphasis_bw80_b0", "pre_emp_db_neg_bw80_0"          , 0x00029890, 29, 15},
{"BB_pre_emphasis_bw80_b0", "pre_emp_db_pos_bw80_0"          , 0x00029890, 14, 0 },
{"BB_tstdac_constant", "cf_tstdac_constant_q"                , 0x000298a4, 21, 11},
{"BB_tstdac_constant", "cf_tstdac_constant_i"                , 0x000298a4, 10, 0 },
{"BB_spur_report_b0", "power_with_spur_removed_0"            , 0x000298a8, 31, 16},
{"BB_spur_report_b0", "spur_est_q_0"                         , 0x000298a8, 15, 8 },
{"BB_spur_report_b0", "spur_est_i_0"                         , 0x000298a8, 7 , 0 },
{"BB_txiqcal_control_3", "tx_iqcorr_en"                      , 0x000298b0, 31, 31},
{"BB_txiqcal_control_3", "desired_size_db"                   , 0x000298b0, 30, 29},
{"BB_txiqcal_control_3", "iqcal_meas_len"                    , 0x000298b0, 28, 27},
{"BB_txiqcal_control_3", "adc_sat_sel"                       , 0x000298b0, 26, 25},
{"BB_txiqcal_control_3", "adc_sat_len"                       , 0x000298b0, 24, 24},
{"BB_txiqcal_control_3", "dc_est_len"                        , 0x000298b0, 23, 22},
{"BB_txiqcal_control_3", "iqcal_tone_phs_step"               , 0x000298b0, 21, 12},
{"BB_txiqcal_control_3", "pwr_low_db"                        , 0x000298b0, 11, 6 },
{"BB_txiqcal_control_3", "pwr_high_db"                       , 0x000298b0, 5 , 0 },
{"BB_green_tx_control_1", "green_cases"                      , 0x000298bc, 1 , 1 },
{"BB_green_tx_control_1", "green_tx_enable"                  , 0x000298bc, 0 , 0 },
{"BB_iq_adc_meas_0_b0", "gain_dc_iq_cal_meas_0_0"            , 0x000298c0, 31, 0 },
{"BB_iq_adc_meas_1_b0", "gain_dc_iq_cal_meas_1_0"            , 0x000298c4, 31, 0 },
{"BB_iq_adc_meas_2_b0", "gain_dc_iq_cal_meas_2_0"            , 0x000298c8, 31, 0 },
{"BB_iq_adc_meas_3_b0", "gain_dc_iq_cal_meas_3_0"            , 0x000298cc, 31, 0 },
{"BB_tx_phase_ramp_b0", "cf_phase_ramp_alpha_0"              , 0x000298d0, 24, 17},
{"BB_tx_phase_ramp_b0", "cf_phase_ramp_init_0"               , 0x000298d0, 16, 7 },
{"BB_tx_phase_ramp_b0", "cf_phase_ramp_bias_0"               , 0x000298d0, 6 , 1 },
{"BB_tx_phase_ramp_b0", "cf_phase_ramp_enable_0"             , 0x000298d0, 0 , 0 },
{"BB_adc_gain_dc_corr_b0", "adc_dc_corr_enable"              , 0x000298d4, 31, 31},
{"BB_adc_gain_dc_corr_b0", "adc_gain_corr_enable"            , 0x000298d4, 30, 30},
{"BB_adc_gain_dc_corr_b0", "adc_dc_corr_i_coeff_0"           , 0x000298d4, 29, 21},
{"BB_adc_gain_dc_corr_b0", "adc_dc_corr_q_coeff_0"           , 0x000298d4, 20, 12},
{"BB_adc_gain_dc_corr_b0", "adc_gain_corr_i_coeff_0"         , 0x000298d4, 11, 6 },
{"BB_adc_gain_dc_corr_b0", "adc_gain_corr_q_coeff_0"         , 0x000298d4, 5 , 0 },
{"BB_rx_iq_corr_b0", "rx_iqcorr_enable"                      , 0x000298dc, 18, 18},
{"BB_rx_iq_corr_loopback_b0", "loopback_iqcorr_enable"       , 0x000298e0, 18, 18},
{"BB_rx_iq_corr_loopback_b0", "loopback_iqcorr_q_i_coff_0"   , 0x000298e0, 17, 9 },
{"BB_rx_iq_corr_loopback_b0", "loopback_iqcorr_q_q_coff_0"   , 0x000298e0, 8 , 0 },
{"BB_paprd_am2am_mask", "paprd_am2am_mask"                   , 0x000298e4, 30, 0 },
{"BB_paprd_am2pm_mask", "paprd_am2pm_mask"                   , 0x000298e8, 30, 0 },
{"BB_paprd_ht40_mask", "paprd_ht40_mask"                     , 0x000298ec, 30, 0 },
{"BB_paprd_ctrl0_b0", "paprd_mag_thrsh_0"                    , 0x000298f0, 31, 27},
{"BB_paprd_ctrl0_b0", "paprd_valid_gain_0"                   , 0x000298f0, 26, 2 },
{"BB_paprd_ctrl0_b0", "paprd_adaptive_use_single_table_0"    , 0x000298f0, 1 , 1 },
{"BB_paprd_ctrl0_b0", "paprd_enable_0"                       , 0x000298f0, 0 , 0 },
{"BB_paprd_ctrl1_b0", "paprd_trainer_iandq_sel_0"            , 0x000298f4, 27, 27},
{"BB_paprd_ctrl1_b0", "paprd_mag_scale_factor_0"             , 0x000298f4, 26, 17},
{"BB_paprd_ctrl1_b0", "pa_gain_scale_factor_0"               , 0x000298f4, 16, 9 },
{"BB_paprd_ctrl1_b0", "paprd_power_at_am2am_cal_0"           , 0x000298f4, 8 , 3 },
{"BB_paprd_ctrl1_b0", "paprd_adaptive_am2pm_enable_0"        , 0x000298f4, 2 , 2 },
{"BB_paprd_ctrl1_b0", "paprd_adaptive_am2am_enable_0"        , 0x000298f4, 1 , 1 },
{"BB_paprd_ctrl1_b0", "paprd_adaptive_scaling_enable_0"      , 0x000298f4, 0 , 0 },
{"BB_pa_gain123_b0", "pa_gain3_0"                            , 0x000298f8, 29, 20},
{"BB_pa_gain123_b0", "pa_gain2_0"                            , 0x000298f8, 19, 10},
{"BB_pa_gain123_b0", "pa_gain1_0"                            , 0x000298f8, 9 , 0 },
{"BB_pa_gain45_b0", "paprd_adaptive_table_valid_0"           , 0x000298fc, 24, 20},
{"BB_pa_gain45_b0", "pa_gain5_0"                             , 0x000298fc, 19, 10},
{"BB_pa_gain45_b0", "pa_gain4_0"                             , 0x000298fc, 9 , 0 },
{"BB_paprd_vht80_mask", "paprd_vht80_mask"                   , 0x00029900, 30, 0 },
{"BB_paprd_mem_tab_b0[0]", "paprd_mem"                       , 0x00029920, 21, 0 },
{"BB_paprd_mem_tab_b0[1]", "paprd_mem"                       , 0x00029924, 21, 0 },
{"BB_paprd_mem_tab_b0[2]", "paprd_mem"                       , 0x00029928, 21, 0 },
{"BB_paprd_mem_tab_b0[3]", "paprd_mem"                       , 0x0002992c, 21, 0 },
{"BB_paprd_mem_tab_b0[4]", "paprd_mem"                       , 0x00029930, 21, 0 },
{"BB_paprd_mem_tab_b0[5]", "paprd_mem"                       , 0x00029934, 21, 0 },
{"BB_paprd_mem_tab_b0[6]", "paprd_mem"                       , 0x00029938, 21, 0 },
{"BB_paprd_mem_tab_b0[7]", "paprd_mem"                       , 0x0002993c, 21, 0 },
{"BB_paprd_mem_tab_b0[8]", "paprd_mem"                       , 0x00029940, 21, 0 },
{"BB_paprd_mem_tab_b0[9]", "paprd_mem"                       , 0x00029944, 21, 0 },
{"BB_paprd_mem_tab_b0[10]", "paprd_mem"                      , 0x00029948, 21, 0 },
{"BB_paprd_mem_tab_b0[11]", "paprd_mem"                      , 0x0002994c, 21, 0 },
{"BB_paprd_mem_tab_b0[12]", "paprd_mem"                      , 0x00029950, 21, 0 },
{"BB_paprd_mem_tab_b0[13]", "paprd_mem"                      , 0x00029954, 21, 0 },
{"BB_paprd_mem_tab_b0[14]", "paprd_mem"                      , 0x00029958, 21, 0 },
{"BB_paprd_mem_tab_b0[15]", "paprd_mem"                      , 0x0002995c, 21, 0 },
{"BB_paprd_mem_tab_b0[16]", "paprd_mem"                      , 0x00029960, 21, 0 },
{"BB_paprd_mem_tab_b0[17]", "paprd_mem"                      , 0x00029964, 21, 0 },
{"BB_paprd_mem_tab_b0[18]", "paprd_mem"                      , 0x00029968, 21, 0 },
{"BB_paprd_mem_tab_b0[19]", "paprd_mem"                      , 0x0002996c, 21, 0 },
{"BB_paprd_mem_tab_b0[20]", "paprd_mem"                      , 0x00029970, 21, 0 },
{"BB_paprd_mem_tab_b0[21]", "paprd_mem"                      , 0x00029974, 21, 0 },
{"BB_paprd_mem_tab_b0[22]", "paprd_mem"                      , 0x00029978, 21, 0 },
{"BB_paprd_mem_tab_b0[23]", "paprd_mem"                      , 0x0002997c, 21, 0 },
{"BB_paprd_mem_tab_b0[24]", "paprd_mem"                      , 0x00029980, 21, 0 },
{"BB_paprd_mem_tab_b0[25]", "paprd_mem"                      , 0x00029984, 21, 0 },
{"BB_paprd_mem_tab_b0[26]", "paprd_mem"                      , 0x00029988, 21, 0 },
{"BB_paprd_mem_tab_b0[27]", "paprd_mem"                      , 0x0002998c, 21, 0 },
{"BB_paprd_mem_tab_b0[28]", "paprd_mem"                      , 0x00029990, 21, 0 },
{"BB_paprd_mem_tab_b0[29]", "paprd_mem"                      , 0x00029994, 21, 0 },
{"BB_paprd_mem_tab_b0[30]", "paprd_mem"                      , 0x00029998, 21, 0 },
{"BB_paprd_mem_tab_b0[31]", "paprd_mem"                      , 0x0002999c, 21, 0 },
{"BB_paprd_mem_tab_b0[32]", "paprd_mem"                      , 0x000299a0, 21, 0 },
{"BB_paprd_mem_tab_b0[33]", "paprd_mem"                      , 0x000299a4, 21, 0 },
{"BB_paprd_mem_tab_b0[34]", "paprd_mem"                      , 0x000299a8, 21, 0 },
{"BB_paprd_mem_tab_b0[35]", "paprd_mem"                      , 0x000299ac, 21, 0 },
{"BB_paprd_mem_tab_b0[36]", "paprd_mem"                      , 0x000299b0, 21, 0 },
{"BB_paprd_mem_tab_b0[37]", "paprd_mem"                      , 0x000299b4, 21, 0 },
{"BB_paprd_mem_tab_b0[38]", "paprd_mem"                      , 0x000299b8, 21, 0 },
{"BB_paprd_mem_tab_b0[39]", "paprd_mem"                      , 0x000299bc, 21, 0 },
{"BB_paprd_mem_tab_b0[40]", "paprd_mem"                      , 0x000299c0, 21, 0 },
{"BB_paprd_mem_tab_b0[41]", "paprd_mem"                      , 0x000299c4, 21, 0 },
{"BB_paprd_mem_tab_b0[42]", "paprd_mem"                      , 0x000299c8, 21, 0 },
{"BB_paprd_mem_tab_b0[43]", "paprd_mem"                      , 0x000299cc, 21, 0 },
{"BB_paprd_mem_tab_b0[44]", "paprd_mem"                      , 0x000299d0, 21, 0 },
{"BB_paprd_mem_tab_b0[45]", "paprd_mem"                      , 0x000299d4, 21, 0 },
{"BB_paprd_mem_tab_b0[46]", "paprd_mem"                      , 0x000299d8, 21, 0 },
{"BB_paprd_mem_tab_b0[47]", "paprd_mem"                      , 0x000299dc, 21, 0 },
{"BB_paprd_mem_tab_b0[48]", "paprd_mem"                      , 0x000299e0, 21, 0 },
{"BB_paprd_mem_tab_b0[49]", "paprd_mem"                      , 0x000299e4, 21, 0 },
{"BB_paprd_mem_tab_b0[50]", "paprd_mem"                      , 0x000299e8, 21, 0 },
{"BB_paprd_mem_tab_b0[51]", "paprd_mem"                      , 0x000299ec, 21, 0 },
{"BB_paprd_mem_tab_b0[52]", "paprd_mem"                      , 0x000299f0, 21, 0 },
{"BB_paprd_mem_tab_b0[53]", "paprd_mem"                      , 0x000299f4, 21, 0 },
{"BB_paprd_mem_tab_b0[54]", "paprd_mem"                      , 0x000299f8, 21, 0 },
{"BB_paprd_mem_tab_b0[55]", "paprd_mem"                      , 0x000299fc, 21, 0 },
{"BB_paprd_mem_tab_b0[56]", "paprd_mem"                      , 0x00029a00, 21, 0 },
{"BB_paprd_mem_tab_b0[57]", "paprd_mem"                      , 0x00029a04, 21, 0 },
{"BB_paprd_mem_tab_b0[58]", "paprd_mem"                      , 0x00029a08, 21, 0 },
{"BB_paprd_mem_tab_b0[59]", "paprd_mem"                      , 0x00029a0c, 21, 0 },
{"BB_paprd_mem_tab_b0[60]", "paprd_mem"                      , 0x00029a10, 21, 0 },
{"BB_paprd_mem_tab_b0[61]", "paprd_mem"                      , 0x00029a14, 21, 0 },
{"BB_paprd_mem_tab_b0[62]", "paprd_mem"                      , 0x00029a18, 21, 0 },
{"BB_paprd_mem_tab_b0[63]", "paprd_mem"                      , 0x00029a1c, 21, 0 },
{"BB_paprd_mem_tab_b0[64]", "paprd_mem"                      , 0x00029a20, 21, 0 },
{"BB_paprd_mem_tab_b0[65]", "paprd_mem"                      , 0x00029a24, 21, 0 },
{"BB_paprd_mem_tab_b0[66]", "paprd_mem"                      , 0x00029a28, 21, 0 },
{"BB_paprd_mem_tab_b0[67]", "paprd_mem"                      , 0x00029a2c, 21, 0 },
{"BB_paprd_mem_tab_b0[68]", "paprd_mem"                      , 0x00029a30, 21, 0 },
{"BB_paprd_mem_tab_b0[69]", "paprd_mem"                      , 0x00029a34, 21, 0 },
{"BB_paprd_mem_tab_b0[70]", "paprd_mem"                      , 0x00029a38, 21, 0 },
{"BB_paprd_mem_tab_b0[71]", "paprd_mem"                      , 0x00029a3c, 21, 0 },
{"BB_paprd_mem_tab_b0[72]", "paprd_mem"                      , 0x00029a40, 21, 0 },
{"BB_paprd_mem_tab_b0[73]", "paprd_mem"                      , 0x00029a44, 21, 0 },
{"BB_paprd_mem_tab_b0[74]", "paprd_mem"                      , 0x00029a48, 21, 0 },
{"BB_paprd_mem_tab_b0[75]", "paprd_mem"                      , 0x00029a4c, 21, 0 },
{"BB_paprd_mem_tab_b0[76]", "paprd_mem"                      , 0x00029a50, 21, 0 },
{"BB_paprd_mem_tab_b0[77]", "paprd_mem"                      , 0x00029a54, 21, 0 },
{"BB_paprd_mem_tab_b0[78]", "paprd_mem"                      , 0x00029a58, 21, 0 },
{"BB_paprd_mem_tab_b0[79]", "paprd_mem"                      , 0x00029a5c, 21, 0 },
{"BB_paprd_mem_tab_b0[80]", "paprd_mem"                      , 0x00029a60, 21, 0 },
{"BB_paprd_mem_tab_b0[81]", "paprd_mem"                      , 0x00029a64, 21, 0 },
{"BB_paprd_mem_tab_b0[82]", "paprd_mem"                      , 0x00029a68, 21, 0 },
{"BB_paprd_mem_tab_b0[83]", "paprd_mem"                      , 0x00029a6c, 21, 0 },
{"BB_paprd_mem_tab_b0[84]", "paprd_mem"                      , 0x00029a70, 21, 0 },
{"BB_paprd_mem_tab_b0[85]", "paprd_mem"                      , 0x00029a74, 21, 0 },
{"BB_paprd_mem_tab_b0[86]", "paprd_mem"                      , 0x00029a78, 21, 0 },
{"BB_paprd_mem_tab_b0[87]", "paprd_mem"                      , 0x00029a7c, 21, 0 },
{"BB_paprd_mem_tab_b0[88]", "paprd_mem"                      , 0x00029a80, 21, 0 },
{"BB_paprd_mem_tab_b0[89]", "paprd_mem"                      , 0x00029a84, 21, 0 },
{"BB_paprd_mem_tab_b0[90]", "paprd_mem"                      , 0x00029a88, 21, 0 },
{"BB_paprd_mem_tab_b0[91]", "paprd_mem"                      , 0x00029a8c, 21, 0 },
{"BB_paprd_mem_tab_b0[92]", "paprd_mem"                      , 0x00029a90, 21, 0 },
{"BB_paprd_mem_tab_b0[93]", "paprd_mem"                      , 0x00029a94, 21, 0 },
{"BB_paprd_mem_tab_b0[94]", "paprd_mem"                      , 0x00029a98, 21, 0 },
{"BB_paprd_mem_tab_b0[95]", "paprd_mem"                      , 0x00029a9c, 21, 0 },
{"BB_paprd_mem_tab_b0[96]", "paprd_mem"                      , 0x00029aa0, 21, 0 },
{"BB_paprd_mem_tab_b0[97]", "paprd_mem"                      , 0x00029aa4, 21, 0 },
{"BB_paprd_mem_tab_b0[98]", "paprd_mem"                      , 0x00029aa8, 21, 0 },
{"BB_paprd_mem_tab_b0[99]", "paprd_mem"                      , 0x00029aac, 21, 0 },
{"BB_paprd_mem_tab_b0[100]", "paprd_mem"                     , 0x00029ab0, 21, 0 },
{"BB_paprd_mem_tab_b0[101]", "paprd_mem"                     , 0x00029ab4, 21, 0 },
{"BB_paprd_mem_tab_b0[102]", "paprd_mem"                     , 0x00029ab8, 21, 0 },
{"BB_paprd_mem_tab_b0[103]", "paprd_mem"                     , 0x00029abc, 21, 0 },
{"BB_paprd_mem_tab_b0[104]", "paprd_mem"                     , 0x00029ac0, 21, 0 },
{"BB_paprd_mem_tab_b0[105]", "paprd_mem"                     , 0x00029ac4, 21, 0 },
{"BB_paprd_mem_tab_b0[106]", "paprd_mem"                     , 0x00029ac8, 21, 0 },
{"BB_paprd_mem_tab_b0[107]", "paprd_mem"                     , 0x00029acc, 21, 0 },
{"BB_paprd_mem_tab_b0[108]", "paprd_mem"                     , 0x00029ad0, 21, 0 },
{"BB_paprd_mem_tab_b0[109]", "paprd_mem"                     , 0x00029ad4, 21, 0 },
{"BB_paprd_mem_tab_b0[110]", "paprd_mem"                     , 0x00029ad8, 21, 0 },
{"BB_paprd_mem_tab_b0[111]", "paprd_mem"                     , 0x00029adc, 21, 0 },
{"BB_paprd_mem_tab_b0[112]", "paprd_mem"                     , 0x00029ae0, 21, 0 },
{"BB_paprd_mem_tab_b0[113]", "paprd_mem"                     , 0x00029ae4, 21, 0 },
{"BB_paprd_mem_tab_b0[114]", "paprd_mem"                     , 0x00029ae8, 21, 0 },
{"BB_paprd_mem_tab_b0[115]", "paprd_mem"                     , 0x00029aec, 21, 0 },
{"BB_paprd_mem_tab_b0[116]", "paprd_mem"                     , 0x00029af0, 21, 0 },
{"BB_paprd_mem_tab_b0[117]", "paprd_mem"                     , 0x00029af4, 21, 0 },
{"BB_paprd_mem_tab_b0[118]", "paprd_mem"                     , 0x00029af8, 21, 0 },
{"BB_paprd_mem_tab_b0[119]", "paprd_mem"                     , 0x00029afc, 21, 0 },
{"BB_chan_info_chan_tab_b0[0]", "chaninfo_word"              , 0x00029b00, 31, 0 },
{"BB_chan_info_chan_tab_b0[1]", "chaninfo_word"              , 0x00029b04, 31, 0 },
{"BB_chan_info_chan_tab_b0[2]", "chaninfo_word"              , 0x00029b08, 31, 0 },
{"BB_chan_info_chan_tab_b0[3]", "chaninfo_word"              , 0x00029b0c, 31, 0 },
{"BB_chan_info_chan_tab_b0[4]", "chaninfo_word"              , 0x00029b10, 31, 0 },
{"BB_chan_info_chan_tab_b0[5]", "chaninfo_word"              , 0x00029b14, 31, 0 },
{"BB_chan_info_chan_tab_b0[6]", "chaninfo_word"              , 0x00029b18, 31, 0 },
{"BB_chan_info_chan_tab_b0[7]", "chaninfo_word"              , 0x00029b1c, 31, 0 },
{"BB_chan_info_chan_tab_b0[8]", "chaninfo_word"              , 0x00029b20, 31, 0 },
{"BB_chan_info_chan_tab_b0[9]", "chaninfo_word"              , 0x00029b24, 31, 0 },
{"BB_chan_info_chan_tab_b0[10]", "chaninfo_word"             , 0x00029b28, 31, 0 },
{"BB_chan_info_chan_tab_b0[11]", "chaninfo_word"             , 0x00029b2c, 31, 0 },
{"BB_chan_info_chan_tab_b0[12]", "chaninfo_word"             , 0x00029b30, 31, 0 },
{"BB_chan_info_chan_tab_b0[13]", "chaninfo_word"             , 0x00029b34, 31, 0 },
{"BB_chan_info_chan_tab_b0[14]", "chaninfo_word"             , 0x00029b38, 31, 0 },
{"BB_chan_info_chan_tab_b0[15]", "chaninfo_word"             , 0x00029b3c, 31, 0 },
{"BB_chan_info_chan_tab_b0[16]", "chaninfo_word"             , 0x00029b40, 31, 0 },
{"BB_chan_info_chan_tab_b0[17]", "chaninfo_word"             , 0x00029b44, 31, 0 },
{"BB_chan_info_chan_tab_b0[18]", "chaninfo_word"             , 0x00029b48, 31, 0 },
{"BB_chan_info_chan_tab_b0[19]", "chaninfo_word"             , 0x00029b4c, 31, 0 },
{"BB_chan_info_chan_tab_b0[20]", "chaninfo_word"             , 0x00029b50, 31, 0 },
{"BB_chan_info_chan_tab_b0[21]", "chaninfo_word"             , 0x00029b54, 31, 0 },
{"BB_chan_info_chan_tab_b0[22]", "chaninfo_word"             , 0x00029b58, 31, 0 },
{"BB_chan_info_chan_tab_b0[23]", "chaninfo_word"             , 0x00029b5c, 31, 0 },
{"BB_chan_info_chan_tab_b0[24]", "chaninfo_word"             , 0x00029b60, 31, 0 },
{"BB_chan_info_chan_tab_b0[25]", "chaninfo_word"             , 0x00029b64, 31, 0 },
{"BB_chan_info_chan_tab_b0[26]", "chaninfo_word"             , 0x00029b68, 31, 0 },
{"BB_chan_info_chan_tab_b0[27]", "chaninfo_word"             , 0x00029b6c, 31, 0 },
{"BB_chan_info_chan_tab_b0[28]", "chaninfo_word"             , 0x00029b70, 31, 0 },
{"BB_chan_info_chan_tab_b0[29]", "chaninfo_word"             , 0x00029b74, 31, 0 },
{"BB_chan_info_chan_tab_b0[30]", "chaninfo_word"             , 0x00029b78, 31, 0 },
{"BB_chan_info_chan_tab_b0[31]", "chaninfo_word"             , 0x00029b7c, 31, 0 },
{"BB_chan_info_chan_tab_b0[32]", "chaninfo_word"             , 0x00029b80, 31, 0 },
{"BB_chan_info_chan_tab_b0[33]", "chaninfo_word"             , 0x00029b84, 31, 0 },
{"BB_chan_info_chan_tab_b0[34]", "chaninfo_word"             , 0x00029b88, 31, 0 },
{"BB_chan_info_chan_tab_b0[35]", "chaninfo_word"             , 0x00029b8c, 31, 0 },
{"BB_chan_info_chan_tab_b0[36]", "chaninfo_word"             , 0x00029b90, 31, 0 },
{"BB_chan_info_chan_tab_b0[37]", "chaninfo_word"             , 0x00029b94, 31, 0 },
{"BB_chan_info_chan_tab_b0[38]", "chaninfo_word"             , 0x00029b98, 31, 0 },
{"BB_chan_info_chan_tab_b0[39]", "chaninfo_word"             , 0x00029b9c, 31, 0 },
{"BB_chan_info_chan_tab_b0[40]", "chaninfo_word"             , 0x00029ba0, 31, 0 },
{"BB_chan_info_chan_tab_b0[41]", "chaninfo_word"             , 0x00029ba4, 31, 0 },
{"BB_chan_info_chan_tab_b0[42]", "chaninfo_word"             , 0x00029ba8, 31, 0 },
{"BB_chan_info_chan_tab_b0[43]", "chaninfo_word"             , 0x00029bac, 31, 0 },
{"BB_chan_info_chan_tab_b0[44]", "chaninfo_word"             , 0x00029bb0, 31, 0 },
{"BB_chan_info_chan_tab_b0[45]", "chaninfo_word"             , 0x00029bb4, 31, 0 },
{"BB_chan_info_chan_tab_b0[46]", "chaninfo_word"             , 0x00029bb8, 31, 0 },
{"BB_chan_info_chan_tab_b0[47]", "chaninfo_word"             , 0x00029bbc, 31, 0 },
{"BB_chan_info_chan_tab_b0[48]", "chaninfo_word"             , 0x00029bc0, 31, 0 },
{"BB_chan_info_chan_tab_b0[49]", "chaninfo_word"             , 0x00029bc4, 31, 0 },
{"BB_chan_info_chan_tab_b0[50]", "chaninfo_word"             , 0x00029bc8, 31, 0 },
{"BB_chan_info_chan_tab_b0[51]", "chaninfo_word"             , 0x00029bcc, 31, 0 },
{"BB_chan_info_chan_tab_b0[52]", "chaninfo_word"             , 0x00029bd0, 31, 0 },
{"BB_chan_info_chan_tab_b0[53]", "chaninfo_word"             , 0x00029bd4, 31, 0 },
{"BB_chan_info_chan_tab_b0[54]", "chaninfo_word"             , 0x00029bd8, 31, 0 },
{"BB_chan_info_chan_tab_b0[55]", "chaninfo_word"             , 0x00029bdc, 31, 0 },
{"BB_chan_info_chan_tab_b0[56]", "chaninfo_word"             , 0x00029be0, 31, 0 },
{"BB_chan_info_chan_tab_b0[57]", "chaninfo_word"             , 0x00029be4, 31, 0 },
{"BB_chan_info_chan_tab_b0[58]", "chaninfo_word"             , 0x00029be8, 31, 0 },
{"BB_chan_info_chan_tab_b0[59]", "chaninfo_word"             , 0x00029bec, 31, 0 },
{"BB_chn_tables_intf_addr", "chn_addr_auto_incr"             , 0x00029bf0, 31, 31},
{"BB_chn_tables_intf_addr", "chn_tables_addr"                , 0x00029bf0, 17, 2 },
{"BB_chn_tables_intf_data", "chn_tables_data"                , 0x00029bf4, 31, 0 },
{"BB_timing_control_3a", "use_non_ht_bw_for_cca"             , 0x00029c00, 9 , 9 },
{"BB_timing_control_3a", "use_vht_bw_for_cca"                , 0x00029c00, 8 , 8 },
{"BB_timing_control_3a", "ste_thr_hi_rssi"                   , 0x00029c00, 6 , 0 },
{"BB_ldpc_cntl1", "ldpc_llr_scaling0"                        , 0x00029c04, 31, 0 },
{"BB_ldpc_cntl2", "disable_ldpc_dec"                         , 0x00029c08, 27, 27},
{"BB_ldpc_cntl2", "ldpc_latency_lastcw"                      , 0x00029c08, 26, 16},
{"BB_ldpc_cntl2", "ldpc_llr_scaling1"                        , 0x00029c08, 15, 0 },
{"BB_vit_spur_mask_A", "cf_punc_mask_idx_A"                  , 0x00029c0c, 17, 10},
{"BB_vit_spur_mask_A", "cf_punc_mask_A"                      , 0x00029c0c, 9 , 0 },
{"BB_vit_spur_mask_B", "cf_punc_mask_idx_B"                  , 0x00029c10, 17, 10},
{"BB_vit_spur_mask_B", "cf_punc_mask_B"                      , 0x00029c10, 9 , 0 },
{"BB_pilot_spur_mask", "cf_pilot_mask_idx_B"                 , 0x00029c14, 25, 18},
{"BB_pilot_spur_mask", "cf_pilot_mask_B"                     , 0x00029c14, 17, 13},
{"BB_pilot_spur_mask", "cf_pilot_mask_idx_A"                 , 0x00029c14, 12, 5 },
{"BB_pilot_spur_mask", "cf_pilot_mask_A"                     , 0x00029c14, 4 , 0 },
{"BB_chan_spur_mask", "cf_chan_mask_idx_B"                   , 0x00029c18, 25, 18},
{"BB_chan_spur_mask", "cf_chan_mask_B"                       , 0x00029c18, 17, 13},
{"BB_chan_spur_mask", "cf_chan_mask_idx_A"                   , 0x00029c18, 12, 5 },
{"BB_chan_spur_mask", "cf_chan_mask_A"                       , 0x00029c18, 4 , 0 },
{"BB_short_gi_delta_slope", "delta_slope_coef_man_short_gi"  , 0x00029c1c, 18, 4 },
{"BB_short_gi_delta_slope", "delta_slope_coef_exp_short_gi"  , 0x00029c1c, 3 , 0 },
{"BB_ml_cntl1", "cf_is_flat_ch_thr_ml"                       , 0x00029c20, 31, 30},
{"BB_ml_cntl1", "cf_ml_2s_weight_table"                      , 0x00029c20, 29, 0 },
{"BB_ml_cntl2", "cf_is_flat_ch_thr_zf"                       , 0x00029c24, 31, 30},
{"BB_ml_cntl2", "cf_ml_3s_weight_table"                      , 0x00029c24, 29, 0 },
{"BB_tstadc", "tstadc_out_i"                                 , 0x00029c28, 19, 10},
{"BB_tstadc", "tstadc_out_q"                                 , 0x00029c28, 9 , 0 },
{"BB_vit_spur_mask_C", "cf_punc_mask_idx_C"                  , 0x00029c2c, 17, 10},
{"BB_vit_spur_mask_C", "cf_punc_mask_C"                      , 0x00029c2c, 9 , 0 },
{"BB_vit_spur_mask_D", "cf_punc_mask_idx_D"                  , 0x00029c30, 17, 10},
{"BB_vit_spur_mask_D", "cf_punc_mask_D"                      , 0x00029c30, 9 , 0 },
{"BB_pilot_spur_mask_CD", "cf_pilot_mask_idx_D"              , 0x00029c34, 25, 18},
{"BB_pilot_spur_mask_CD", "cf_pilot_mask_D"                  , 0x00029c34, 17, 13},
{"BB_pilot_spur_mask_CD", "cf_pilot_mask_idx_C"              , 0x00029c34, 12, 5 },
{"BB_pilot_spur_mask_CD", "cf_pilot_mask_C"                  , 0x00029c34, 4 , 0 },
{"BB_chan_spur_mask_CD", "cf_chan_mask_idx_D"                , 0x00029c38, 25, 18},
{"BB_chan_spur_mask_CD", "cf_chan_mask_D"                    , 0x00029c38, 17, 13},
{"BB_chan_spur_mask_CD", "cf_chan_mask_idx_C"                , 0x00029c38, 12, 5 },
{"BB_chan_spur_mask_CD", "cf_chan_mask_C"                    , 0x00029c38, 4 , 0 },
{"BB_vit_spur_mask_E", "cf_punc_mask_idx_E"                  , 0x00029c3c, 17, 10},
{"BB_vit_spur_mask_E", "cf_punc_mask_E"                      , 0x00029c3c, 9 , 0 },
{"BB_vit_spur_mask_F", "cf_punc_mask_idx_F"                  , 0x00029c40, 17, 10},
{"BB_vit_spur_mask_F", "cf_punc_mask_F"                      , 0x00029c40, 9 , 0 },
{"BB_pilot_spur_mask_EF", "cf_pilot_mask_idx_F"              , 0x00029c44, 25, 18},
{"BB_pilot_spur_mask_EF", "cf_pilot_mask_F"                  , 0x00029c44, 17, 13},
{"BB_pilot_spur_mask_EF", "cf_pilot_mask_idx_E"              , 0x00029c44, 12, 5 },
{"BB_pilot_spur_mask_EF", "cf_pilot_mask_E"                  , 0x00029c44, 4 , 0 },
{"BB_chan_spur_mask_EF", "cf_chan_mask_idx_F"                , 0x00029c48, 25, 18},
{"BB_chan_spur_mask_EF", "cf_chan_mask_F"                    , 0x00029c48, 17, 13},
{"BB_chan_spur_mask_EF", "cf_chan_mask_idx_E"                , 0x00029c48, 12, 5 },
{"BB_chan_spur_mask_EF", "cf_chan_mask_E"                    , 0x00029c48, 4 , 0 },
{"BB_vit_spur_mask_G", "cf_punc_mask_idx_G"                  , 0x00029c4c, 17, 10},
{"BB_vit_spur_mask_G", "cf_punc_mask_G"                      , 0x00029c4c, 9 , 0 },
{"BB_vit_spur_mask_H", "cf_punc_mask_idx_H"                  , 0x00029c50, 17, 10},
{"BB_vit_spur_mask_H", "cf_punc_mask_H"                      , 0x00029c50, 9 , 0 },
{"BB_pilot_spur_mask_GH", "cf_pilot_mask_idx_H"              , 0x00029c54, 25, 18},
{"BB_pilot_spur_mask_GH", "cf_pilot_mask_H"                  , 0x00029c54, 17, 13},
{"BB_pilot_spur_mask_GH", "cf_pilot_mask_idx_G"              , 0x00029c54, 12, 5 },
{"BB_pilot_spur_mask_GH", "cf_pilot_mask_G"                  , 0x00029c54, 4 , 0 },
{"BB_chan_spur_mask_GH", "cf_chan_mask_idx_H"                , 0x00029c58, 25, 18},
{"BB_chan_spur_mask_GH", "cf_chan_mask_H"                    , 0x00029c58, 17, 13},
{"BB_chan_spur_mask_GH", "cf_chan_mask_idx_G"                , 0x00029c58, 12, 5 },
{"BB_chan_spur_mask_GH", "cf_chan_mask_G"                    , 0x00029c58, 4 , 0 },
{"BB_ldpc_cntl3", "ldpc_latency_gap_pre2"                    , 0x00029c5c, 31, 21},
{"BB_ldpc_cntl3", "ldpc_latency_gap_pre"                     , 0x00029c5c, 20, 10},
{"BB_ldpc_cntl3", "ldpc_timeout_thresh"                      , 0x00029c5c, 9 , 0 },
{"BB_ldpc_cntl4", "ldpc_fast_inbuf_near_rdy"                 , 0x00029c60, 12, 12},
{"BB_ldpc_cntl4", "ldpc_inbuf_near_rdy_thresh"               , 0x00029c60, 11, 0 },
{"BB_bbb_rx_ctrl_1", "en_rx_abort_cck"                       , 0x00029d00, 24, 24},
{"BB_bbb_rx_ctrl_1", "recon_lms_step"                        , 0x00029d00, 23, 21},
{"BB_bbb_rx_ctrl_1", "max_bal_short"                         , 0x00029d00, 20, 16},
{"BB_bbb_rx_ctrl_1", "max_bal_long"                          , 0x00029d00, 15, 11},
{"BB_bbb_rx_ctrl_1", "coarse_tim_n_sync"                     , 0x00029d00, 10, 8 },
{"BB_bbb_rx_ctrl_1", "coarse_tim_threshold"                  , 0x00029d00, 7 , 3 },
{"BB_bbb_rx_ctrl_1", "coarse_tim_threshold_2"                , 0x00029d00, 2 , 0 },
{"BB_bbb_rx_ctrl_2", "loop_coef_dpsk_c2_data"                , 0x00029d04, 31, 26},
{"BB_bbb_rx_ctrl_2", "freq_est_scaling_period"               , 0x00029d04, 25, 22},
{"BB_bbb_rx_ctrl_2", "freq_track_update_period"              , 0x00029d04, 21, 17},
{"BB_bbb_rx_ctrl_2", "coarse_tim_threshold_3"                , 0x00029d04, 16, 12},
{"BB_bbb_rx_ctrl_2", "chan_avg_long"                         , 0x00029d04, 11, 6 },
{"BB_bbb_rx_ctrl_2", "freq_est_n_avg_long"                   , 0x00029d04, 5 , 0 },
{"BB_bbb_rx_ctrl_3", "timer_n_sfd"                           , 0x00029d08, 23, 16},
{"BB_bbb_rx_ctrl_3", "tim_adjust_freq_cck"                   , 0x00029d08, 15, 8 },
{"BB_bbb_rx_ctrl_3", "tim_adjust_freq_dpsk"                  , 0x00029d08, 7 , 0 },
{"BB_bbb_rx_ctrl_4", "use_mrc_weight"                        , 0x00029d0c, 31, 31},
{"BB_bbb_rx_ctrl_4", "chan_avg_short"                        , 0x00029d0c, 30, 25},
{"BB_bbb_rx_ctrl_4", "freq_est_n_avg_short"                  , 0x00029d0c, 24, 19},
{"BB_bbb_rx_ctrl_4", "short_preamble"                        , 0x00029d0c, 18, 18},
{"BB_bbb_rx_ctrl_4", "dynamic_pream_sel"                     , 0x00029d0c, 17, 17},
{"BB_bbb_rx_ctrl_4", "force_unlocked_clocks"                 , 0x00029d0c, 16, 16},
{"BB_bbb_rx_ctrl_4", "tim_adjust_timer_exp"                  , 0x00029d0c, 15, 4 },
{"BB_bbb_rx_ctrl_4", "timer_n_sync"                          , 0x00029d0c, 3 , 0 },
{"BB_bbb_rx_ctrl_5", "loop_coef_cck_c2"                      , 0x00029d10, 26, 21},
{"BB_bbb_rx_ctrl_5", "loop_coef_cck_c1"                      , 0x00029d10, 20, 16},
{"BB_bbb_rx_ctrl_5", "loop_coef_dpsk_c2_head"                , 0x00029d10, 15, 10},
{"BB_bbb_rx_ctrl_5", "loop_coef_dpsk_c1_head"                , 0x00029d10, 9 , 5 },
{"BB_bbb_rx_ctrl_5", "loop_coef_dpsk_c1_data"                , 0x00029d10, 4 , 0 },
{"BB_bbb_rx_ctrl_6", "force_center_index"                    , 0x00029d14, 25, 25},
{"BB_bbb_rx_ctrl_6", "force_cck_sel_chain"                   , 0x00029d14, 24, 24},
{"BB_bbb_rx_ctrl_6", "cck_sel_chain_by_eo"                   , 0x00029d14, 23, 23},
{"BB_bbb_rx_ctrl_6", "use_bkpwr_for_center_index"            , 0x00029d14, 22, 22},
{"BB_bbb_rx_ctrl_6", "use_mcorr_weight"                      , 0x00029d14, 21, 21},
{"BB_bbb_rx_ctrl_6", "start_iir_delay"                       , 0x00029d14, 20, 11},
{"BB_bbb_rx_ctrl_6", "map_1s_to_2s"                          , 0x00029d14, 10, 10},
{"BB_bbb_rx_ctrl_6", "sync_start_delay"                      , 0x00029d14, 9 , 0 },
{"BB_force_clken_cck", "force_txsm_clken"                    , 0x00029d18, 5 , 5 },
{"BB_force_clken_cck", "force_rx_always"                     , 0x00029d18, 4 , 4 },
{"BB_force_clken_cck", "force_rx_enable3"                    , 0x00029d18, 3 , 3 },
{"BB_force_clken_cck", "force_rx_enable2"                    , 0x00029d18, 2 , 2 },
{"BB_force_clken_cck", "force_rx_enable1"                    , 0x00029d18, 1 , 1 },
{"BB_force_clken_cck", "force_rx_enable0"                    , 0x00029d18, 0 , 0 },
{"BB_settling_time", "lbreset_advance"                       , 0x00029e00, 29, 26},
{"BB_settling_time", "adcsat_thrh"                           , 0x00029e00, 25, 20},
{"BB_settling_time", "adcsat_thrl"                           , 0x00029e00, 19, 14},
{"BB_settling_time", "switch_settling"                       , 0x00029e00, 13, 7 },
{"BB_settling_time", "agc_settling"                          , 0x00029e00, 6 , 0 },
{"BB_gain_force_max_gains_b0", "xatten2_hyst_margin_0"       , 0x00029e04, 31, 25},
{"BB_gain_force_max_gains_b0", "xatten1_hyst_margin_0"       , 0x00029e04, 24, 18},
{"BB_gain_force_max_gains_b0", "xatten2_sw_f_0"              , 0x00029e04, 17, 17},
{"BB_gain_force_max_gains_b0", "xatten1_sw_f_0"              , 0x00029e04, 16, 16},
{"BB_gain_force_max_gains_b0", "mb_gain_f_0"                 , 0x00029e04, 15, 8 },
{"BB_gain_force_max_gains_b0", "rf_gain_f_0"                 , 0x00029e04, 7 , 0 },
{"BB_gains_min_offsets", "enable_ant_fast_gc_ctrl"           , 0x00029e08, 24, 24},
{"BB_gains_min_offsets", "use_fixed_gain"                    , 0x00029e08, 23, 23},
{"BB_gains_min_offsets", "enable_srch_start_gain"            , 0x00029e08, 22, 22},
{"BB_gains_min_offsets", "cf_agc_hist_phy_err"               , 0x00029e08, 21, 21},
{"BB_gains_min_offsets", "cf_agc_hist_voting"                , 0x00029e08, 20, 20},
{"BB_gains_min_offsets", "cf_agc_hist_gc"                    , 0x00029e08, 19, 19},
{"BB_gains_min_offsets", "cf_agc_hist_enable"                , 0x00029e08, 18, 18},
{"BB_gains_min_offsets", "gain_force"                        , 0x00029e08, 17, 17},
{"BB_gains_min_offsets", "offsetC3"                          , 0x00029e08, 16, 12},
{"BB_gains_min_offsets", "offsetC2"                          , 0x00029e08, 11, 7 },
{"BB_gains_min_offsets", "offsetC1"                          , 0x00029e08, 6 , 0 },
{"BB_desired_sigsize", "ena_init_gain"                       , 0x00029e0c, 31, 31},
{"BB_desired_sigsize", "reduce_init_gc_count"                , 0x00029e0c, 30, 30},
{"BB_desired_sigsize", "init_gc_count_max"                   , 0x00029e0c, 29, 28},
{"BB_desired_sigsize", "total_desired"                       , 0x00029e0c, 27, 20},
{"BB_desired_sigsize", "adc_desired_size"                    , 0x00029e0c, 7 , 0 },
{"BB_find_signal", "m1count_max"                             , 0x00029e10, 31, 26},
{"BB_find_signal", "firpwr"                                  , 0x00029e10, 25, 18},
{"BB_find_signal", "firstep"                                 , 0x00029e10, 17, 12},
{"BB_find_signal", "relpwr"                                  , 0x00029e10, 11, 6 },
{"BB_find_signal", "relstep"                                 , 0x00029e10, 5 , 0 },
{"BB_agc", "rssi_out_select"                                 , 0x00029e14, 31, 30},
{"BB_agc", "quick_drop"                                      , 0x00029e14, 29, 22},
{"BB_agc", "coarse_high"                                     , 0x00029e14, 21, 15},
{"BB_agc", "coarse_low"                                      , 0x00029e14, 14, 7 },
{"BB_agc", "coarsepwr_const"                                 , 0x00029e14, 6 , 0 },
{"BB_ext_atten_switch_ctl_b0", "xlna_gain_db_0"              , 0x00029e18, 26, 22},
{"BB_ext_atten_switch_ctl_b0", "xatten2_margin_0"            , 0x00029e18, 21, 17},
{"BB_ext_atten_switch_ctl_b0", "xatten1_margin_0"            , 0x00029e18, 16, 12},
{"BB_ext_atten_switch_ctl_b0", "xatten2_db_0"                , 0x00029e18, 11, 6 },
{"BB_ext_atten_switch_ctl_b0", "xatten1_db_0"                , 0x00029e18, 5 , 0 },
{"BB_cca_b0", "minCCApwr_0"                                  , 0x00029e1c, 28, 20},
{"BB_cca_b0", "thr_cca"                                      , 0x00029e1c, 19, 12},
{"BB_cca_b0", "cf_cca_count_maxC"                            , 0x00029e1c, 11, 9 },
{"BB_cca_b0", "cf_maxCCApwr_0"                               , 0x00029e1c, 8 , 0 },
{"BB_cca_ctrl_2_b0", "minCCA_firpwr_thr"                     , 0x00029e20, 27, 20},
{"BB_cca_ctrl_2_b0", "cca_avg_ena"                           , 0x00029e20, 19, 19},
{"BB_cca_ctrl_2_b0", "thr_cca_mode"                          , 0x00029e20, 18, 18},
{"BB_cca_ctrl_2_b0", "NF_gain_comp_0"                        , 0x00029e20, 17, 10},
{"BB_cca_ctrl_2_b0", "enable_minCCApwr_thr"                  , 0x00029e20, 9 , 9 },
{"BB_cca_ctrl_2_b0", "minCCApwr_thr_0"                       , 0x00029e20, 8 , 0 },
{"BB_restart", "dfs_restart_mode"                            , 0x00029e24, 31, 31},
{"BB_restart", "dfs_restart_ena"                             , 0x00029e24, 30, 30},
{"BB_restart", "enable_pwr_drop_err_cck"                     , 0x00029e24, 29, 29},
{"BB_restart", "weak_rssi_vote_thr"                          , 0x00029e24, 28, 22},
{"BB_restart", "enable_ant_fast_div_m2flag"                  , 0x00029e24, 21, 21},
{"BB_restart", "ant_fast_div_gc_limit"                       , 0x00029e24, 20, 18},
{"BB_restart", "ofdm_cck_rssi_bias"                          , 0x00029e24, 17, 12},
{"BB_restart", "pwrdrop_lgfirpwr_delta"                      , 0x00029e24, 11, 7 },
{"BB_restart", "enable_pwr_drop_err"                         , 0x00029e24, 6 , 6 },
{"BB_restart", "restart_lgfirpwr_delta"                      , 0x00029e24, 5 , 1 },
{"BB_restart", "enable_restart"                              , 0x00029e24, 0 , 0 },
{"BB_multichain_gain_ctrl", "ant_div_sw_com_lock"            , 0x00029e28, 31, 31},
{"BB_multichain_gain_ctrl", "ant_div_main_gaintb"            , 0x00029e28, 30, 30},
{"BB_multichain_gain_ctrl", "ant_div_alt_gaintb"             , 0x00029e28, 29, 29},
{"BB_multichain_gain_ctrl", "ant_div_main_lnaconf"           , 0x00029e28, 28, 27},
{"BB_multichain_gain_ctrl", "ant_div_alt_lnaconf"            , 0x00029e28, 26, 25},
{"BB_multichain_gain_ctrl", "enable_ant_div_lnadiv"          , 0x00029e28, 24, 24},
{"BB_multichain_gain_ctrl", "enable_ant_sw_rx_prot"          , 0x00029e28, 23, 23},
{"BB_multichain_gain_ctrl", "cap_gain_ratio_mode"            , 0x00029e28, 22, 22},
{"BB_multichain_gain_ctrl", "cap_gain_ratio_ena"             , 0x00029e28, 21, 21},
{"BB_multichain_gain_ctrl", "cap_gain_ratio_SNR"             , 0x00029e28, 20, 15},
{"BB_multichain_gain_ctrl", "ant_fast_div_bias"              , 0x00029e28, 14, 9 },
{"BB_multichain_gain_ctrl", "enable_check_strong_ant"        , 0x00029e28, 8 , 8 },
{"BB_multichain_gain_ctrl", "quickdrop_low"                  , 0x00029e28, 7 , 0 },
{"BB_ext_chan_pwr_thr_1", "ant_div_alt_ant_deltaNF"          , 0x00029e2c, 26, 21},
{"BB_ext_chan_pwr_thr_1", "ant_div_alt_ant_deltaGainIdx"     , 0x00029e2c, 20, 16},
{"BB_ext_chan_pwr_thr_1", "ant_div_alt_ant_minGainIdx"       , 0x00029e2c, 15, 8 },
{"BB_ext_chan_pwr_thr_1", "thr_cca_ext40"                    , 0x00029e2c, 7 , 0 },
{"BB_ext_bw_pwr_thr", "minCCA_relpwr_thr"                    , 0x00029e30, 25, 18},
{"BB_ext_bw_pwr_thr", "bw_det_ext40_max_delta_db"            , 0x00029e30, 17, 12},
{"BB_ext_bw_pwr_thr", "bw_det_ext20_max_delta_db"            , 0x00029e30, 11, 6 },
{"BB_ext_bw_pwr_thr", "bw_det_min_rssi_db"                   , 0x00029e30, 5 , 0 },
{"BB_rifs_srch", "rifs_disable_cck_det"                      , 0x00029e38, 27, 27},
{"BB_rifs_srch", "rifs_disable_pwrlow_gc"                    , 0x00029e38, 26, 26},
{"BB_rifs_srch", "rifs_init_delay"                           , 0x00029e38, 25, 16},
{"BB_rifs_srch", "init_gain_dB_offset"                       , 0x00029e38, 15, 8 },
{"BB_peak_det_ctrl_1", "pwd_pkdet_during_rx"                 , 0x00029e3c, 31, 31},
{"BB_peak_det_ctrl_1", "pwd_pkdet_during_cal"                , 0x00029e3c, 30, 30},
{"BB_peak_det_ctrl_1", "peak_det_settling"                   , 0x00029e3c, 29, 23},
{"BB_peak_det_ctrl_1", "peak_det_tally_thr_high_0"           , 0x00029e3c, 22, 18},
{"BB_peak_det_ctrl_1", "peak_det_tally_thr_med_0"            , 0x00029e3c, 17, 13},
{"BB_peak_det_ctrl_1", "peak_det_tally_thr_low_0"            , 0x00029e3c, 12, 8 },
{"BB_peak_det_ctrl_1", "peak_det_win_len"                    , 0x00029e3c, 7 , 2 },
{"BB_peak_det_ctrl_1", "use_peak_det"                        , 0x00029e3c, 1 , 1 },
{"BB_peak_det_ctrl_1", "use_oc_gain_table"                   , 0x00029e3c, 0 , 0 },
{"BB_peak_det_ctrl_2", "enable_rfsat_restart"                , 0x00029e40, 30, 30},
{"BB_peak_det_ctrl_2", "rf_gain_drop_db_non_0"               , 0x00029e40, 29, 25},
{"BB_peak_det_ctrl_2", "rf_gain_drop_db_high_0"              , 0x00029e40, 24, 20},
{"BB_peak_det_ctrl_2", "rf_gain_drop_db_med_0"               , 0x00029e40, 19, 15},
{"BB_peak_det_ctrl_2", "rf_gain_drop_db_low_0"               , 0x00029e40, 14, 10},
{"BB_peak_det_ctrl_2", "rfsat_2_add_rfgain_del"              , 0x00029e40, 9 , 0 },
{"BB_rx_gain_bounds_1", "rf_mb_gain_delta_max_db"            , 0x00029e44, 31, 26},
{"BB_rx_gain_bounds_1", "rx_ocgain_sel_5G"                   , 0x00029e44, 25, 25},
{"BB_rx_gain_bounds_1", "rx_ocgain_sel_2G"                   , 0x00029e44, 24, 24},
{"BB_rx_gain_bounds_1", "rx_max_rf_gain"                     , 0x00029e44, 23, 16},
{"BB_rx_gain_bounds_1", "rx_max_rf_gain_ref"                 , 0x00029e44, 15, 8 },
{"BB_rx_gain_bounds_1", "rx_max_mb_gain"                     , 0x00029e44, 7 , 0 },
{"BB_rx_gain_bounds_2", "rf_gain_div_base_addr"              , 0x00029e48, 31, 24},
{"BB_rx_gain_bounds_2", "rf_gain_base_addr"                  , 0x00029e48, 23, 16},
{"BB_rx_gain_bounds_2", "rf_gain_ref_base_addr"              , 0x00029e48, 15, 8 },
{"BB_rx_gain_bounds_2", "gc_rssi_low_db"                     , 0x00029e48, 7 , 0 },
{"BB_peak_det_cal_ctrl", "pkdet_cal_meas_time_sel"           , 0x00029e4c, 13, 12},
{"BB_peak_det_cal_ctrl", "pkdet_cal_bias"                    , 0x00029e4c, 11, 6 },
{"BB_peak_det_cal_ctrl", "pkdet_cal_win_thr"                 , 0x00029e4c, 5 , 0 },
{"BB_agc_dig_dc_ctrl", "dig_dc_correct_cap_msb"              , 0x00029e50, 14, 11},
{"BB_agc_dig_dc_ctrl", "dig_dc_switch_cck"                   , 0x00029e50, 10, 10},
{"BB_agc_dig_dc_ctrl", "dig_dc_correct_cap"                  , 0x00029e50, 9 , 4 },
{"BB_agc_dig_dc_ctrl", "dig_dc_scale_bias"                   , 0x00029e50, 3 , 1 },
{"BB_agc_dig_dc_ctrl", "use_dig_dc"                          , 0x00029e50, 0 , 0 },
{"BB_bt_coex_1", "bt_rx_disable_NF_cal"                      , 0x00029e54, 31, 31},
{"BB_bt_coex_1", "bt_tx_disable_NF_cal"                      , 0x00029e54, 30, 30},
{"BB_bt_coex_1", "rf_gain_drop_db_high_1"                    , 0x00029e54, 29, 25},
{"BB_bt_coex_1", "rf_gain_drop_db_med_1"                     , 0x00029e54, 24, 20},
{"BB_bt_coex_1", "rf_gain_drop_db_low_1"                     , 0x00029e54, 19, 15},
{"BB_bt_coex_1", "peak_det_tally_thr_high_1"                 , 0x00029e54, 14, 10},
{"BB_bt_coex_1", "peak_det_tally_thr_med_1"                  , 0x00029e54, 9 , 5 },
{"BB_bt_coex_1", "peak_det_tally_thr_low_1"                  , 0x00029e54, 4 , 0 },
{"BB_bt_coex_2", "rfsat_rx_rx"                               , 0x00029e58, 31, 30},
{"BB_bt_coex_2", "rf_gain_drop_db_high_2"                    , 0x00029e58, 29, 25},
{"BB_bt_coex_2", "rf_gain_drop_db_med_2"                     , 0x00029e58, 24, 20},
{"BB_bt_coex_2", "rf_gain_drop_db_low_2"                     , 0x00029e58, 19, 15},
{"BB_bt_coex_2", "peak_det_tally_thr_high_2"                 , 0x00029e58, 14, 10},
{"BB_bt_coex_2", "peak_det_tally_thr_med_2"                  , 0x00029e58, 9 , 5 },
{"BB_bt_coex_2", "peak_det_tally_thr_low_2"                  , 0x00029e58, 4 , 0 },
{"BB_bt_coex_3", "bt_rx_firpwr_incr"                         , 0x00029e5c, 31, 28},
{"BB_bt_coex_3", "rf_gain_drop_db_non_2"                     , 0x00029e5c, 27, 23},
{"BB_bt_coex_3", "rf_gain_drop_db_non_1"                     , 0x00029e5c, 22, 18},
{"BB_bt_coex_3", "rfsat_eq_srch_rx"                          , 0x00029e5c, 17, 16},
{"BB_bt_coex_3", "rfsat_eq_rx_srch"                          , 0x00029e5c, 15, 14},
{"BB_bt_coex_3", "rfsat_eq_srch_srch"                        , 0x00029e5c, 13, 12},
{"BB_bt_coex_3", "rfsat_wlan_srch_rx"                        , 0x00029e5c, 11, 10},
{"BB_bt_coex_3", "rfsat_wlan_rx_srch"                        , 0x00029e5c, 9 , 8 },
{"BB_bt_coex_3", "rfsat_wlan_srch_srch"                      , 0x00029e5c, 7 , 6 },
{"BB_bt_coex_3", "rfsat_bt_srch_rx"                          , 0x00029e5c, 5 , 4 },
{"BB_bt_coex_3", "rfsat_bt_rx_srch"                          , 0x00029e5c, 3 , 2 },
{"BB_bt_coex_3", "rfsat_bt_srch_srch"                        , 0x00029e5c, 1 , 0 },
{"BB_bt_coex_4", "rfgain_eqv_lna_3"                          , 0x00029e60, 31, 24},
{"BB_bt_coex_4", "rfgain_eqv_lna_2"                          , 0x00029e60, 23, 16},
{"BB_bt_coex_4", "rfgain_eqv_lna_1"                          , 0x00029e60, 15, 8 },
{"BB_bt_coex_4", "rfgain_eqv_lna_0"                          , 0x00029e60, 7 , 0 },
{"BB_bt_coex_5", "rfgain_eqv_lna_7"                          , 0x00029e64, 31, 24},
{"BB_bt_coex_5", "rfgain_eqv_lna_6"                          , 0x00029e64, 23, 16},
{"BB_bt_coex_5", "rfgain_eqv_lna_5"                          , 0x00029e64, 15, 8 },
{"BB_bt_coex_5", "rfgain_eqv_lna_4"                          , 0x00029e64, 7 , 0 },
{"BB_dyn_adc_size_ctrl", "adc_size_desired_min_db2"          , 0x00029e68, 31, 24},
{"BB_dyn_adc_size_ctrl", "adc_size_desired_max_db2"          , 0x00029e68, 23, 16},
{"BB_dyn_adc_size_ctrl", "rssi_pri_high_thr"                 , 0x00029e68, 14, 8 },
{"BB_dyn_adc_size_ctrl", "alpha_adc_size_relpwr"             , 0x00029e68, 4 , 3 },
{"BB_dyn_adc_size_ctrl", "alpha_adc_size_rssi"               , 0x00029e68, 2 , 1 },
{"BB_dyn_adc_size_ctrl", "enable_dynamic_adc_sizing"         , 0x00029e68, 0 , 0 },
{"BB_rx_lo_dccal_ctrl", "calnum_txlb"                        , 0x00029e6c, 5 , 3 },
{"BB_rx_lo_dccal_ctrl", "calnum_rx"                          , 0x00029e6c, 2 , 0 },
{"BB_adc_capture", "adc_capture_chn_idx"                     , 0x00029e70, 23, 22},
{"BB_adc_capture", "adc_capture_length"                      , 0x00029e70, 21, 8 },
{"BB_adc_capture", "adc_capture_scale"                       , 0x00029e70, 7 , 6 },
{"BB_adc_capture", "adc_capture_gc_ena"                      , 0x00029e70, 5 , 5 },
{"BB_adc_capture", "adc_capture_format"                      , 0x00029e70, 4 , 4 },
{"BB_adc_capture", "adc_capture_overrun_flag"                , 0x00029e70, 3 , 3 },
{"BB_adc_capture", "adc_capture_sat_flag"                    , 0x00029e70, 2 , 2 },
{"BB_adc_capture", "adc_capture_error_flag"                  , 0x00029e70, 1 , 1 },
{"BB_adc_capture", "adc_capture_active"                      , 0x00029e70, 0 , 0 },
{"BB_find_signal_2", "disable_pwr_drop_last_two_sym_vht"     , 0x00029e74, 16, 16},
{"BB_find_signal_2", "found_low"                             , 0x00029e74, 15, 8 },
{"BB_find_signal_2", "found_low_ena"                         , 0x00029e74, 7 , 7 },
{"BB_find_signal_2", "relpwr_weak_db"                        , 0x00029e74, 5 , 0 },
{"BB_peak_det_ctrl_3", "agc_dbdac_reg_setting"               , 0x00029e78, 3 , 0 },
{"BB_srch_fft_ctrl_1", "pulse_check_srch_fft"                , 0x00029e80, 31, 31},
{"BB_srch_fft_ctrl_1", "spectral_scan_dBm_adj"               , 0x00029e80, 30, 30},
{"BB_srch_fft_ctrl_1", "radar_fft_dBm_adj"                   , 0x00029e80, 29, 29},
{"BB_srch_fft_ctrl_1", "fft_check_fine_ena"                  , 0x00029e80, 28, 28},
{"BB_srch_fft_ctrl_1", "radar_fft_long_period"               , 0x00029e80, 27, 24},
{"BB_srch_fft_ctrl_1", "srch_fft_scale_vec"                  , 0x00029e80, 23, 12},
{"BB_srch_fft_ctrl_1", "spectral_scan_bin_scale"             , 0x00029e80, 11, 10},
{"BB_srch_fft_ctrl_1", "radar_fft_bin_scale"                 , 0x00029e80, 9 , 8 },
{"BB_srch_fft_ctrl_1", "spectral_scan_rpt_mode"              , 0x00029e80, 7 , 6 },
{"BB_srch_fft_ctrl_1", "radar_fft_rpt_mode"                  , 0x00029e80, 5 , 4 },
{"BB_srch_fft_ctrl_1", "spectral_scan_pwr_format"            , 0x00029e80, 3 , 3 },
{"BB_srch_fft_ctrl_1", "radar_fft_pwr_format"                , 0x00029e80, 2 , 2 },
{"BB_srch_fft_ctrl_1", "fft_check_radar_ena"                 , 0x00029e80, 1 , 1 },
{"BB_srch_fft_ctrl_1", "fft_check_wlan_ena"                  , 0x00029e80, 0 , 0 },
{"BB_srch_fft_ctrl_2", "str_bin_thr_radar"                   , 0x00029e84, 31, 26},
{"BB_srch_fft_ctrl_2", "str_bin_thr_wlan"                    , 0x00029e84, 25, 20},
{"BB_srch_fft_ctrl_2", "srch_fft_ib_thr"                     , 0x00029e84, 18, 12},
{"BB_srch_fft_ctrl_2", "srch_fft_sb_freq"                    , 0x00029e84, 11, 0 },
{"BB_srch_fft_ctrl_3", "nb_tone_thr_radar_blk"               , 0x00029e88, 31, 24},
{"BB_srch_fft_ctrl_3", "nb_tone_thr_radar_fine"              , 0x00029e88, 23, 16},
{"BB_srch_fft_ctrl_3", "nb_tone_thr_radar_coarse"            , 0x00029e88, 15, 8 },
{"BB_srch_fft_ctrl_3", "nb_tone_thr_wlan"                    , 0x00029e88, 7 , 0 },
{"BB_srch_fft_ctrl_4", "radar_fft_short_rpt_sel"             , 0x00029e8c, 31, 31},
{"BB_srch_fft_ctrl_4", "srch_fft_dc_scale_inband"            , 0x00029e8c, 30, 28},
{"BB_srch_fft_ctrl_4", "srch_fft_pwr_drop_ratio"             , 0x00029e8c, 27, 24},
{"BB_srch_fft_ctrl_4", "srch_fft_pwr_low_cap"                , 0x00029e8c, 23, 18},
{"BB_srch_fft_ctrl_4", "srch_fft_rfsat_peakmag_thr"          , 0x00029e8c, 17, 8 },
{"BB_srch_fft_ctrl_4", "spectral_scan_chn_mask"              , 0x00029e8c, 7 , 4 },
{"BB_srch_fft_ctrl_4", "radar_fft_chn_mask"                  , 0x00029e8c, 3 , 0 },
{"BB_radar_chirp_detect", "chirp_max_num_fft_rpt"            , 0x00029e90, 27, 23},
{"BB_radar_chirp_detect", "srch_fft_str_rssi_thresh"         , 0x00029e90, 22, 17},
{"BB_radar_chirp_detect", "chirp_max_delta_diff"             , 0x00029e90, 16, 13},
{"BB_radar_chirp_detect", "chirp_max_delta_bin"              , 0x00029e90, 12, 8 },
{"BB_radar_chirp_detect", "chirp_min_delta_bin"              , 0x00029e90, 7 , 3 },
{"BB_radar_chirp_detect", "chirp_max_num_diff"               , 0x00029e90, 2 , 0 },
{"BB_spectral_scan_2", "spectral_scan_rssi_rpt_mode"         , 0x00029e98, 31, 31},
{"BB_spectral_scan_2", "spectral_scan_wb_rpt_mode"           , 0x00029e98, 30, 30},
{"BB_spectral_scan_2", "spectral_scan_str_bin_thr"           , 0x00029e98, 29, 24},
{"BB_spectral_scan_2", "spectral_scan_nb_tone_thr"           , 0x00029e98, 23, 16},
{"BB_spectral_scan_2", "spectral_scan_init_delay"            , 0x00029e98, 14, 8 },
{"BB_spectral_scan_2", "spectral_scan_noise_floor_ref"       , 0x00029e98, 7 , 0 },
{"BB_spectral_scan_3", "spectral_scan_rssi_thr"              , 0x00029e9c, 7 , 0 },
{"BB_agc_timeout_1", "sscan_sm_timeout"                      , 0x00029ea0, 15, 8 },
{"BB_agc_timeout_1", "radar_sm_timeout"                      , 0x00029ea0, 7 , 0 },
{"BB_rssi_b0", "rssi_ext80_0"                                , 0x00029f80, 31, 24},
{"BB_rssi_b0", "rssi_ext40_0"                                , 0x00029f80, 23, 16},
{"BB_rssi_b0", "rssi_ext20_0"                                , 0x00029f80, 15, 8 },
{"BB_rssi_b0", "rssi_pri20_0"                                , 0x00029f80, 7 , 0 },
{"BB_spur_est_cck_report_b0", "spur_est_q_0_cck"             , 0x00029f84, 31, 24},
{"BB_spur_est_cck_report_b0", "spur_est_i_0_cck"             , 0x00029f84, 23, 16},
{"BB_spur_est_cck_report_b0", "spur_est_sd_q_0_cck"          , 0x00029f84, 15, 8 },
{"BB_spur_est_cck_report_b0", "spur_est_sd_i_0_cck"          , 0x00029f84, 7 , 0 },
{"BB_agc_dig_dc_status_i_0_b0", "resdc_sw_write0_0"          , 0x00029f88, 30, 30},
{"BB_agc_dig_dc_status_i_0_b0", "dig_dc_mixer2_res_i_0"      , 0x00029f88, 29, 20},
{"BB_agc_dig_dc_status_i_0_b0", "dig_dc_mixer1_res_i_0"      , 0x00029f88, 19, 10},
{"BB_agc_dig_dc_status_i_0_b0", "dig_dc_mixer0_res_i_0"      , 0x00029f88, 9 , 0 },
{"BB_agc_dig_dc_status_i_1_b0", "resdc_sw_write1_0"          , 0x00029f8c, 30, 30},
{"BB_agc_dig_dc_status_i_1_b0", "dig_dc_mixer1_loopback_res_i_0", 0x00029f8c, 29, 20},
{"BB_agc_dig_dc_status_i_1_b0", "dig_dc_mixer0_loopback_res_i_0", 0x00029f8c, 19, 10},
{"BB_agc_dig_dc_status_i_1_b0", "dig_dc_mixer3_res_i_0"      , 0x00029f8c, 9 , 0 },
{"BB_agc_dig_dc_status_i_2_b0", "resdc_sw_write2_0"          , 0x00029f90, 30, 30},
{"BB_agc_dig_dc_status_i_2_b0", "dig_dc_mixer3_loopback_res_i_0", 0x00029f90, 19, 10},
{"BB_agc_dig_dc_status_i_2_b0", "dig_dc_mixer2_loopback_res_i_0", 0x00029f90, 9 , 0 },
{"BB_agc_dig_dc_status_q_0_b0", "resdc_sw_write3_0"          , 0x00029f94, 30, 30},
{"BB_agc_dig_dc_status_q_0_b0", "dig_dc_mixer2_res_q_0"      , 0x00029f94, 29, 20},
{"BB_agc_dig_dc_status_q_0_b0", "dig_dc_mixer1_res_q_0"      , 0x00029f94, 19, 10},
{"BB_agc_dig_dc_status_q_0_b0", "dig_dc_mixer0_res_q_0"      , 0x00029f94, 9 , 0 },
{"BB_agc_dig_dc_status_q_1_b0", "resdc_sw_write4_0"          , 0x00029f98, 30, 30},
{"BB_agc_dig_dc_status_q_1_b0", "dig_dc_mixer1_loopback_res_q_0", 0x00029f98, 29, 20},
{"BB_agc_dig_dc_status_q_1_b0", "dig_dc_mixer0_loopback_res_q_0", 0x00029f98, 19, 10},
{"BB_agc_dig_dc_status_q_1_b0", "dig_dc_mixer3_res_q_0"      , 0x00029f98, 9 , 0 },
{"BB_agc_dig_dc_status_q_2_b0", "resdc_sw_write5_0"          , 0x00029f9c, 30, 30},
{"BB_agc_dig_dc_status_q_2_b0", "dig_dc_mixer3_loopback_res_q_0", 0x00029f9c, 19, 10},
{"BB_agc_dig_dc_status_q_2_b0", "dig_dc_mixer2_loopback_res_q_0", 0x00029f9c, 9 , 0 },
{"BB_dc_cal_status_b0", "offsetC3Q_0"                        , 0x00029fa0, 29, 25},
{"BB_dc_cal_status_b0", "offsetC3I_0"                        , 0x00029fa0, 24, 20},
{"BB_dc_cal_status_b0", "offsetC2Q_0"                        , 0x00029fa0, 19, 15},
{"BB_dc_cal_status_b0", "offsetC2I_0"                        , 0x00029fa0, 14, 10},
{"BB_dc_cal_status_b0", "offsetC1Q_0"                        , 0x00029fa0, 9 , 5 },
{"BB_dc_cal_status_b0", "offsetC1I_0"                        , 0x00029fa0, 4 , 0 },
{"BB_bbb_sig_detect", "enable_barker_two_phase"              , 0x00029fc0, 31, 31},
{"BB_bbb_sig_detect", "disable_str_chain_sel_cck"            , 0x00029fc0, 30, 30},
{"BB_bbb_sig_detect", "ena_dc_est_bcorr"                     , 0x00029fc0, 29, 29},
{"BB_bbb_sig_detect", "delay_dagc_firpwr_meas"               , 0x00029fc0, 28, 28},
{"BB_bbb_sig_detect", "delay_start_dcoff_cck"                , 0x00029fc0, 27, 27},
{"BB_bbb_sig_detect", "delay_start_spur_cck"                 , 0x00029fc0, 26, 26},
{"BB_bbb_sig_detect", "start_dcoff_priority_cck"             , 0x00029fc0, 25, 25},
{"BB_bbb_sig_detect", "swap_default_chain_cck"               , 0x00029fc0, 24, 24},
{"BB_bbb_sig_detect", "bbb_mrc_off_no_swap"                  , 0x00029fc0, 23, 23},
{"BB_bbb_sig_detect", "use_dc_est_during_srch"               , 0x00029fc0, 22, 22},
{"BB_bbb_sig_detect", "delay_start_sync_cck"                 , 0x00029fc0, 21, 21},
{"BB_bbb_sig_detect", "enable_fine_dc_cck"                   , 0x00029fc0, 20, 20},
{"BB_bbb_sig_detect", "cyc256_fine_dc_est_cck"               , 0x00029fc0, 19, 19},
{"BB_bbb_sig_detect", "enable_coarse_dc_cck"                 , 0x00029fc0, 18, 18},
{"BB_bbb_sig_detect", "cyc64_coarse_dc_est_cck"              , 0x00029fc0, 17, 17},
{"BB_bbb_sig_detect", "cyc32_coarse_dc_est_cck"              , 0x00029fc0, 16, 16},
{"BB_bbb_sig_detect", "lb_rx_enable_cck"                     , 0x00029fc0, 15, 15},
{"BB_bbb_sig_detect", "lb_alpha_128_cck"                     , 0x00029fc0, 14, 14},
{"BB_bbb_sig_detect", "enable_ant_fast_div"                  , 0x00029fc0, 13, 13},
{"BB_bbb_sig_detect", "ant_switch_time"                      , 0x00029fc0, 12, 6 },
{"BB_bbb_sig_detect", "weak_sig_thr_cck"                     , 0x00029fc0, 5 , 0 },
{"BB_bbb_dagc_ctrl", "force_rx_chain_cck_1"                  , 0x00029fc4, 31, 30},
{"BB_bbb_dagc_ctrl", "force_rx_chain_cck_0"                  , 0x00029fc4, 29, 28},
{"BB_bbb_dagc_ctrl", "firstep_count_lgmax"                   , 0x00029fc4, 27, 24},
{"BB_bbb_dagc_ctrl", "firstep_2"                             , 0x00029fc4, 23, 18},
{"BB_bbb_dagc_ctrl", "enable_firstep_sel"                    , 0x00029fc4, 17, 17},
{"BB_bbb_dagc_ctrl", "barker_rssi_thr"                       , 0x00029fc4, 16, 10},
{"BB_bbb_dagc_ctrl", "enable_barker_rssi_thr"                , 0x00029fc4, 9 , 9 },
{"BB_bbb_dagc_ctrl", "dagc_target_pwr_cck"                   , 0x00029fc4, 8 , 1 },
{"BB_bbb_dagc_ctrl", "enable_dagc_cck"                       , 0x00029fc4, 0 , 0 },
{"BB_iqcorr_ctrl_cck", "cf_clc_init_rfgain"                  , 0x00029fc8, 20, 16},
{"BB_iqcorr_ctrl_cck", "clcal_meas_time_sel"                 , 0x00029fc8, 15, 14},
{"BB_iqcorr_ctrl_cck", "rxcal_meas_time_sel"                 , 0x00029fc8, 13, 12},
{"BB_cck_spur_mit", "spur_filter_type"                       , 0x00029fcc, 30, 29},
{"BB_cck_spur_mit", "cck_spur_freq"                          , 0x00029fcc, 28, 9 },
{"BB_cck_spur_mit", "spur_rssi_thr"                          , 0x00029fcc, 8 , 1 },
{"BB_cck_spur_mit", "use_cck_spur_mit"                       , 0x00029fcc, 0 , 0 },
{"BB_mrc_cck_ctrl", "agcdp_cck_min_value"                    , 0x00029fd0, 27, 22},
{"BB_mrc_cck_ctrl", "agcdp_cck_mrc_bk_thr_low"               , 0x00029fd0, 21, 17},
{"BB_mrc_cck_ctrl", "agcdp_cck_mrc_bk_thr_hi"                , 0x00029fd0, 16, 12},
{"BB_mrc_cck_ctrl", "agcdp_cck_barker_rssi_thr"              , 0x00029fd0, 11, 8 },
{"BB_mrc_cck_ctrl", "agcdp_cck_pd_accu_thr_low"              , 0x00029fd0, 7 , 5 },
{"BB_mrc_cck_ctrl", "agcdp_cck_pd_accu_thr_hi"               , 0x00029fd0, 4 , 2 },
{"BB_mrc_cck_ctrl", "agcdp_cck_mrc_mux_reg"                  , 0x00029fd0, 1 , 1 },
{"BB_mrc_cck_ctrl", "bbb_mrc_en"                             , 0x00029fd0, 0 , 0 },
{"BB_cck_blocker_det", "cck_det_ramp_thr"                    , 0x00029fd4, 31, 27},
{"BB_cck_blocker_det", "skip_ramp_enable"                    , 0x00029fd4, 26, 26},
{"BB_cck_blocker_det", "cck_blocker_monitor_time"            , 0x00029fd4, 25, 20},
{"BB_cck_blocker_det", "cck_blocker_det_delay_thr"           , 0x00029fd4, 19, 14},
{"BB_cck_blocker_det", "cck_blocker_det_thr"                 , 0x00029fd4, 13, 9 },
{"BB_cck_blocker_det", "bk_valid_delay"                      , 0x00029fd4, 8 , 6 },
{"BB_cck_blocker_det", "cck_blocker_det_bksum_num"           , 0x00029fd4, 5 , 2 },
{"BB_cck_blocker_det", "cck_blocker_det_restart_weak_sig"    , 0x00029fd4, 1 , 1 },
{"BB_cck_blocker_det", "cck_freq_shift_blocker_detection"    , 0x00029fd4, 0 , 0 },
{"BB_rx_ocgain[0]", "gain_entry"                             , 0x0002a000, 31, 0 },
{"BB_rx_ocgain[1]", "gain_entry"                             , 0x0002a004, 31, 0 },
{"BB_rx_ocgain[2]", "gain_entry"                             , 0x0002a008, 31, 0 },
{"BB_rx_ocgain[3]", "gain_entry"                             , 0x0002a00c, 31, 0 },
{"BB_rx_ocgain[4]", "gain_entry"                             , 0x0002a010, 31, 0 },
{"BB_rx_ocgain[5]", "gain_entry"                             , 0x0002a014, 31, 0 },
{"BB_rx_ocgain[6]", "gain_entry"                             , 0x0002a018, 31, 0 },
{"BB_rx_ocgain[7]", "gain_entry"                             , 0x0002a01c, 31, 0 },
{"BB_rx_ocgain[8]", "gain_entry"                             , 0x0002a020, 31, 0 },
{"BB_rx_ocgain[9]", "gain_entry"                             , 0x0002a024, 31, 0 },
{"BB_rx_ocgain[10]", "gain_entry"                            , 0x0002a028, 31, 0 },
{"BB_rx_ocgain[11]", "gain_entry"                            , 0x0002a02c, 31, 0 },
{"BB_rx_ocgain[12]", "gain_entry"                            , 0x0002a030, 31, 0 },
{"BB_rx_ocgain[13]", "gain_entry"                            , 0x0002a034, 31, 0 },
{"BB_rx_ocgain[14]", "gain_entry"                            , 0x0002a038, 31, 0 },
{"BB_rx_ocgain[15]", "gain_entry"                            , 0x0002a03c, 31, 0 },
{"BB_rx_ocgain[16]", "gain_entry"                            , 0x0002a040, 31, 0 },
{"BB_rx_ocgain[17]", "gain_entry"                            , 0x0002a044, 31, 0 },
{"BB_rx_ocgain[18]", "gain_entry"                            , 0x0002a048, 31, 0 },
{"BB_rx_ocgain[19]", "gain_entry"                            , 0x0002a04c, 31, 0 },
{"BB_rx_ocgain[20]", "gain_entry"                            , 0x0002a050, 31, 0 },
{"BB_rx_ocgain[21]", "gain_entry"                            , 0x0002a054, 31, 0 },
{"BB_rx_ocgain[22]", "gain_entry"                            , 0x0002a058, 31, 0 },
{"BB_rx_ocgain[23]", "gain_entry"                            , 0x0002a05c, 31, 0 },
{"BB_rx_ocgain[24]", "gain_entry"                            , 0x0002a060, 31, 0 },
{"BB_rx_ocgain[25]", "gain_entry"                            , 0x0002a064, 31, 0 },
{"BB_rx_ocgain[26]", "gain_entry"                            , 0x0002a068, 31, 0 },
{"BB_rx_ocgain[27]", "gain_entry"                            , 0x0002a06c, 31, 0 },
{"BB_rx_ocgain[28]", "gain_entry"                            , 0x0002a070, 31, 0 },
{"BB_rx_ocgain[29]", "gain_entry"                            , 0x0002a074, 31, 0 },
{"BB_rx_ocgain[30]", "gain_entry"                            , 0x0002a078, 31, 0 },
{"BB_rx_ocgain[31]", "gain_entry"                            , 0x0002a07c, 31, 0 },
{"BB_rx_ocgain[32]", "gain_entry"                            , 0x0002a080, 31, 0 },
{"BB_rx_ocgain[33]", "gain_entry"                            , 0x0002a084, 31, 0 },
{"BB_rx_ocgain[34]", "gain_entry"                            , 0x0002a088, 31, 0 },
{"BB_rx_ocgain[35]", "gain_entry"                            , 0x0002a08c, 31, 0 },
{"BB_rx_ocgain[36]", "gain_entry"                            , 0x0002a090, 31, 0 },
{"BB_rx_ocgain[37]", "gain_entry"                            , 0x0002a094, 31, 0 },
{"BB_rx_ocgain[38]", "gain_entry"                            , 0x0002a098, 31, 0 },
{"BB_rx_ocgain[39]", "gain_entry"                            , 0x0002a09c, 31, 0 },
{"BB_rx_ocgain[40]", "gain_entry"                            , 0x0002a0a0, 31, 0 },
{"BB_rx_ocgain[41]", "gain_entry"                            , 0x0002a0a4, 31, 0 },
{"BB_rx_ocgain[42]", "gain_entry"                            , 0x0002a0a8, 31, 0 },
{"BB_rx_ocgain[43]", "gain_entry"                            , 0x0002a0ac, 31, 0 },
{"BB_rx_ocgain[44]", "gain_entry"                            , 0x0002a0b0, 31, 0 },
{"BB_rx_ocgain[45]", "gain_entry"                            , 0x0002a0b4, 31, 0 },
{"BB_rx_ocgain[46]", "gain_entry"                            , 0x0002a0b8, 31, 0 },
{"BB_rx_ocgain[47]", "gain_entry"                            , 0x0002a0bc, 31, 0 },
{"BB_rx_ocgain[48]", "gain_entry"                            , 0x0002a0c0, 31, 0 },
{"BB_rx_ocgain[49]", "gain_entry"                            , 0x0002a0c4, 31, 0 },
{"BB_rx_ocgain[50]", "gain_entry"                            , 0x0002a0c8, 31, 0 },
{"BB_rx_ocgain[51]", "gain_entry"                            , 0x0002a0cc, 31, 0 },
{"BB_rx_ocgain[52]", "gain_entry"                            , 0x0002a0d0, 31, 0 },
{"BB_rx_ocgain[53]", "gain_entry"                            , 0x0002a0d4, 31, 0 },
{"BB_rx_ocgain[54]", "gain_entry"                            , 0x0002a0d8, 31, 0 },
{"BB_rx_ocgain[55]", "gain_entry"                            , 0x0002a0dc, 31, 0 },
{"BB_rx_ocgain[56]", "gain_entry"                            , 0x0002a0e0, 31, 0 },
{"BB_rx_ocgain[57]", "gain_entry"                            , 0x0002a0e4, 31, 0 },
{"BB_rx_ocgain[58]", "gain_entry"                            , 0x0002a0e8, 31, 0 },
{"BB_rx_ocgain[59]", "gain_entry"                            , 0x0002a0ec, 31, 0 },
{"BB_rx_ocgain[60]", "gain_entry"                            , 0x0002a0f0, 31, 0 },
{"BB_rx_ocgain[61]", "gain_entry"                            , 0x0002a0f4, 31, 0 },
{"BB_rx_ocgain[62]", "gain_entry"                            , 0x0002a0f8, 31, 0 },
{"BB_rx_ocgain[63]", "gain_entry"                            , 0x0002a0fc, 31, 0 },
{"BB_rx_ocgain[64]", "gain_entry"                            , 0x0002a100, 31, 0 },
{"BB_rx_ocgain[65]", "gain_entry"                            , 0x0002a104, 31, 0 },
{"BB_rx_ocgain[66]", "gain_entry"                            , 0x0002a108, 31, 0 },
{"BB_rx_ocgain[67]", "gain_entry"                            , 0x0002a10c, 31, 0 },
{"BB_rx_ocgain[68]", "gain_entry"                            , 0x0002a110, 31, 0 },
{"BB_rx_ocgain[69]", "gain_entry"                            , 0x0002a114, 31, 0 },
{"BB_rx_ocgain[70]", "gain_entry"                            , 0x0002a118, 31, 0 },
{"BB_rx_ocgain[71]", "gain_entry"                            , 0x0002a11c, 31, 0 },
{"BB_rx_ocgain[72]", "gain_entry"                            , 0x0002a120, 31, 0 },
{"BB_rx_ocgain[73]", "gain_entry"                            , 0x0002a124, 31, 0 },
{"BB_rx_ocgain[74]", "gain_entry"                            , 0x0002a128, 31, 0 },
{"BB_rx_ocgain[75]", "gain_entry"                            , 0x0002a12c, 31, 0 },
{"BB_rx_ocgain[76]", "gain_entry"                            , 0x0002a130, 31, 0 },
{"BB_rx_ocgain[77]", "gain_entry"                            , 0x0002a134, 31, 0 },
{"BB_rx_ocgain[78]", "gain_entry"                            , 0x0002a138, 31, 0 },
{"BB_rx_ocgain[79]", "gain_entry"                            , 0x0002a13c, 31, 0 },
{"BB_rx_ocgain[80]", "gain_entry"                            , 0x0002a140, 31, 0 },
{"BB_rx_ocgain[81]", "gain_entry"                            , 0x0002a144, 31, 0 },
{"BB_rx_ocgain[82]", "gain_entry"                            , 0x0002a148, 31, 0 },
{"BB_rx_ocgain[83]", "gain_entry"                            , 0x0002a14c, 31, 0 },
{"BB_rx_ocgain[84]", "gain_entry"                            , 0x0002a150, 31, 0 },
{"BB_rx_ocgain[85]", "gain_entry"                            , 0x0002a154, 31, 0 },
{"BB_rx_ocgain[86]", "gain_entry"                            , 0x0002a158, 31, 0 },
{"BB_rx_ocgain[87]", "gain_entry"                            , 0x0002a15c, 31, 0 },
{"BB_rx_ocgain[88]", "gain_entry"                            , 0x0002a160, 31, 0 },
{"BB_rx_ocgain[89]", "gain_entry"                            , 0x0002a164, 31, 0 },
{"BB_rx_ocgain[90]", "gain_entry"                            , 0x0002a168, 31, 0 },
{"BB_rx_ocgain[91]", "gain_entry"                            , 0x0002a16c, 31, 0 },
{"BB_rx_ocgain[92]", "gain_entry"                            , 0x0002a170, 31, 0 },
{"BB_rx_ocgain[93]", "gain_entry"                            , 0x0002a174, 31, 0 },
{"BB_rx_ocgain[94]", "gain_entry"                            , 0x0002a178, 31, 0 },
{"BB_rx_ocgain[95]", "gain_entry"                            , 0x0002a17c, 31, 0 },
{"BB_rx_ocgain[96]", "gain_entry"                            , 0x0002a180, 31, 0 },
{"BB_rx_ocgain[97]", "gain_entry"                            , 0x0002a184, 31, 0 },
{"BB_rx_ocgain[98]", "gain_entry"                            , 0x0002a188, 31, 0 },
{"BB_rx_ocgain[99]", "gain_entry"                            , 0x0002a18c, 31, 0 },
{"BB_rx_ocgain[100]", "gain_entry"                           , 0x0002a190, 31, 0 },
{"BB_rx_ocgain[101]", "gain_entry"                           , 0x0002a194, 31, 0 },
{"BB_rx_ocgain[102]", "gain_entry"                           , 0x0002a198, 31, 0 },
{"BB_rx_ocgain[103]", "gain_entry"                           , 0x0002a19c, 31, 0 },
{"BB_rx_ocgain[104]", "gain_entry"                           , 0x0002a1a0, 31, 0 },
{"BB_rx_ocgain[105]", "gain_entry"                           , 0x0002a1a4, 31, 0 },
{"BB_rx_ocgain[106]", "gain_entry"                           , 0x0002a1a8, 31, 0 },
{"BB_rx_ocgain[107]", "gain_entry"                           , 0x0002a1ac, 31, 0 },
{"BB_rx_ocgain[108]", "gain_entry"                           , 0x0002a1b0, 31, 0 },
{"BB_rx_ocgain[109]", "gain_entry"                           , 0x0002a1b4, 31, 0 },
{"BB_rx_ocgain[110]", "gain_entry"                           , 0x0002a1b8, 31, 0 },
{"BB_rx_ocgain[111]", "gain_entry"                           , 0x0002a1bc, 31, 0 },
{"BB_rx_ocgain[112]", "gain_entry"                           , 0x0002a1c0, 31, 0 },
{"BB_rx_ocgain[113]", "gain_entry"                           , 0x0002a1c4, 31, 0 },
{"BB_rx_ocgain[114]", "gain_entry"                           , 0x0002a1c8, 31, 0 },
{"BB_rx_ocgain[115]", "gain_entry"                           , 0x0002a1cc, 31, 0 },
{"BB_rx_ocgain[116]", "gain_entry"                           , 0x0002a1d0, 31, 0 },
{"BB_rx_ocgain[117]", "gain_entry"                           , 0x0002a1d4, 31, 0 },
{"BB_rx_ocgain[118]", "gain_entry"                           , 0x0002a1d8, 31, 0 },
{"BB_rx_ocgain[119]", "gain_entry"                           , 0x0002a1dc, 31, 0 },
{"BB_rx_ocgain[120]", "gain_entry"                           , 0x0002a1e0, 31, 0 },
{"BB_rx_ocgain[121]", "gain_entry"                           , 0x0002a1e4, 31, 0 },
{"BB_rx_ocgain[122]", "gain_entry"                           , 0x0002a1e8, 31, 0 },
{"BB_rx_ocgain[123]", "gain_entry"                           , 0x0002a1ec, 31, 0 },
{"BB_rx_ocgain[124]", "gain_entry"                           , 0x0002a1f0, 31, 0 },
{"BB_rx_ocgain[125]", "gain_entry"                           , 0x0002a1f4, 31, 0 },
{"BB_rx_ocgain[126]", "gain_entry"                           , 0x0002a1f8, 31, 0 },
{"BB_rx_ocgain[127]", "gain_entry"                           , 0x0002a1fc, 31, 0 },
{"BB_gen_controls", "enable_err_tx_illegal_rate"             , 0x0002a204, 29, 29},
{"BB_gen_controls", "enable_err_tx_bw_gt_dyn_bw"             , 0x0002a204, 28, 28},
{"BB_gen_controls", "enable_err_lsig_length_check"           , 0x0002a204, 27, 27},
{"BB_gen_controls", "enable_err_extra_sym_mismatch"          , 0x0002a204, 26, 26},
{"BB_gen_controls", "enable_err_tx_chain_mask_zero"          , 0x0002a204, 25, 25},
{"BB_gen_controls", "unsupp_ht_rate_threshold"               , 0x0002a204, 24, 18},
{"BB_gen_controls", "enable_csd_phase_dithering"             , 0x0002a204, 17, 17},
{"BB_gen_controls", "static20_mode_ht40_packet_error_rpt"    , 0x0002a204, 16, 16},
{"BB_gen_controls", "static20_mode_ht40_packet_handling"     , 0x0002a204, 15, 15},
{"BB_gen_controls", "bond_opt_chain_sel"                     , 0x0002a204, 14, 14},
{"BB_gen_controls", "enable_adc_async_fifo"                  , 0x0002a204, 13, 13},
{"BB_gen_controls", "enable_dac_async_fifo"                  , 0x0002a204, 12, 12},
{"BB_gen_controls", "gf_enable"                              , 0x0002a204, 11, 11},
{"BB_gen_controls", "cf_3_chains_use_walsh"                  , 0x0002a204, 10, 10},
{"BB_gen_controls", "cf_2_chains_use_walsh"                  , 0x0002a204, 9 , 9 },
{"BB_gen_controls", "allow_short_gi"                         , 0x0002a204, 8 , 8 },
{"BB_gen_controls", "vht_enable"                             , 0x0002a204, 7 , 7 },
{"BB_gen_controls", "dyn_non_contig"                         , 0x0002a204, 6 , 6 },
{"BB_gen_controls", "dyn_chn_gap"                            , 0x0002a204, 5 , 5 },
{"BB_gen_controls", "dyn_pri_chn"                            , 0x0002a204, 4 , 2 },
{"BB_gen_controls", "dyn_bw"                                 , 0x0002a204, 1 , 0 },
{"BB_modes_select", "en_err_vht_grp1to62"                    , 0x0002a208, 17, 17},
{"BB_modes_select", "en_err_vht_rx_nsym_lt_zero"             , 0x0002a208, 16, 16},
{"BB_modes_select", "en_err_vht_rx_ndp_or_zlf"               , 0x0002a208, 15, 15},
{"BB_modes_select", "en_err_vht_lsig_len_invalid"            , 0x0002a208, 14, 14},
{"BB_modes_select", "en_err_vht_rx_siga_unsup"               , 0x0002a208, 13, 13},
{"BB_modes_select", "skip_rx_grp_id_63"                      , 0x0002a208, 12, 12},
{"BB_modes_select", "skip_rx_grp_id_0"                       , 0x0002a208, 11, 11},
{"BB_modes_select", "ovsamp_clk_mode"                        , 0x0002a208, 10, 10},
{"BB_modes_select", "disable_dyn_cck_det"                    , 0x0002a208, 8 , 8 },
{"BB_modes_select", "mac_clk_mode"                           , 0x0002a208, 7 , 7 },
{"BB_modes_select", "quarter_rate_mode"                      , 0x0002a208, 6 , 6 },
{"BB_modes_select", "half_rate_mode"                         , 0x0002a208, 5 , 5 },
{"BB_modes_select", "dyn_ofdm_cck_mode"                      , 0x0002a208, 2 , 2 },
{"BB_modes_select", "cck_mode"                               , 0x0002a208, 0 , 0 },
{"BB_active", "cf_active"                                    , 0x0002a20c, 0 , 0 },
{"BB_spectral_scan", "spectral_scan_restart_ena"             , 0x0002a228, 31, 31},
{"BB_spectral_scan", "spectral_scan_gc_ena"                  , 0x0002a228, 30, 30},
{"BB_spectral_scan", "spectral_scan_priority"                , 0x0002a228, 29, 29},
{"BB_spectral_scan", "spectral_scan_count"                   , 0x0002a228, 27, 16},
{"BB_spectral_scan", "spectral_scan_period"                  , 0x0002a228, 15, 8 },
{"BB_spectral_scan", "spectral_scan_fft_size"                , 0x0002a228, 7 , 4 },
{"BB_spectral_scan", "spectral_scan_active"                  , 0x0002a228, 1 , 1 },
{"BB_spectral_scan", "spectral_scan_ena"                     , 0x0002a228, 0 , 0 },
{"BB_search_start_delay", "search_start_mask_sifs"           , 0x0002a230, 31, 28},
{"BB_search_start_delay", "search_start_delay_sifs"          , 0x0002a230, 27, 16},
{"BB_search_start_delay", "search_start_delay_rifs"          , 0x0002a230, 11, 0 },
{"BB_max_rx_length", "max_ht_duration"                       , 0x0002a234, 31, 30},
{"BB_max_rx_length", "max_ht_length"                         , 0x0002a234, 29, 12},
{"BB_max_rx_length", "max_rx_length"                         , 0x0002a234, 11, 0 },
{"BB_frame_control", "en_err_rx_abort"                       , 0x0002a238, 31, 31},
{"BB_frame_control", "en_err_tx_underrun"                    , 0x0002a238, 30, 30},
{"BB_frame_control", "en_err_service"                        , 0x0002a238, 29, 29},
{"BB_frame_control", "no_6mbps_service_err"                  , 0x0002a238, 28, 28},
{"BB_frame_control", "en_err_length_illegal"                 , 0x0002a238, 27, 27},
{"BB_frame_control", "en_err_rate_illegal"                   , 0x0002a238, 26, 26},
{"BB_frame_control", "en_err_signal_parity"                  , 0x0002a238, 25, 25},
{"BB_frame_control", "en_err_tim_timeout"                    , 0x0002a238, 24, 24},
{"BB_frame_control", "en_err_tim_early_trig"                 , 0x0002a238, 23, 23},
{"BB_frame_control", "en_err_tim_long1"                      , 0x0002a238, 22, 22},
{"BB_frame_control", "en_err_long_sc_thr"                    , 0x0002a238, 21, 21},
{"BB_frame_control", "en_err_ofdm_xcorr"                     , 0x0002a238, 20, 20},
{"BB_frame_control", "en_err_static20_mode_ht40_packet"      , 0x0002a238, 19, 19},
{"BB_frame_control", "en_err_green_field"                    , 0x0002a238, 18, 18},
{"BB_frame_control", "short_high_par_norm"                   , 0x0002a238, 17, 17},
{"BB_frame_control", "prepend_chan_info"                     , 0x0002a238, 16, 16},
{"BB_frame_control", "tx_end_adjust"                         , 0x0002a238, 15, 8 },
{"BB_frame_control", "cf_tx_doublesamp_dac"                  , 0x0002a238, 7 , 6 },
{"BB_frame_control", "cf_tx_clip"                            , 0x0002a238, 5 , 3 },
{"BB_frame_control", "cf_overlap_window"                     , 0x0002a238, 1 , 0 },
{"BB_rfbus_request", "rfbus_request"                         , 0x0002a23c, 0 , 0 },
{"BB_rfbus_grant", "bt_ant"                                  , 0x0002a240, 1 , 1 },
{"BB_rfbus_grant", "rfbus_grant"                             , 0x0002a240, 0 , 0 },
{"BB_rifs", "disable_rx_mask_mac_wait"                       , 0x0002a244, 27, 27},
{"BB_rifs", "enable_reset_tdomain"                           , 0x0002a244, 26, 26},
{"BB_rifs", "rifs_eco_disable"                               , 0x0002a244, 23, 0 },
{"BB_rx_clear_delay", "ofdm_rx_clear_delay"                  , 0x0002a250, 9 , 0 },
{"BB_analog_power_on_time", "active_to_receive"              , 0x0002a254, 13, 0 },
{"BB_tx_timing_1", "tx_frame_to_a2_tx_on"                    , 0x0002a258, 31, 24},
{"BB_tx_timing_1", "tx_frame_to_dac_on"                      , 0x0002a258, 23, 16},
{"BB_tx_timing_1", "tx_frame_to_a2_rx_off"                   , 0x0002a258, 15, 8 },
{"BB_tx_timing_1", "tx_frame_to_adc_off"                     , 0x0002a258, 7 , 0 },
{"BB_tx_timing_2", "tx_end_to_a2_tx_off"                     , 0x0002a25c, 31, 24},
{"BB_tx_timing_2", "tx_end_to_pa_off"                        , 0x0002a25c, 23, 16},
{"BB_tx_timing_2", "tx_frame_to_pa_on"                       , 0x0002a25c, 15, 8 },
{"BB_tx_timing_2", "tx_frame_to_tx_d_start"                  , 0x0002a25c, 7 , 0 },
{"BB_tx_timing_3", "tx_end_to_adc_on"                        , 0x0002a260, 31, 24},
{"BB_tx_timing_3", "tx_end_to_a2_rx_on"                      , 0x0002a260, 23, 16},
{"BB_tx_timing_3", "tx_frame_to_therm_chain_on"              , 0x0002a260, 15, 8 },
{"BB_tx_timing_3", "tx_end_to_dac_off"                       , 0x0002a260, 7 , 0 },
{"BB_xpa_timing_control", "tx_end_to_xpab_off"               , 0x0002a264, 31, 24},
{"BB_xpa_timing_control", "tx_end_to_xpaa_off"               , 0x0002a264, 23, 16},
{"BB_xpa_timing_control", "tx_frame_to_xpab_on"              , 0x0002a264, 15, 8 },
{"BB_xpa_timing_control", "tx_frame_to_xpaa_on"              , 0x0002a264, 7 , 0 },
{"BB_warm_tx", "num_extra_lstf_samples"                      , 0x0002a268, 8 , 1 },
{"BB_warm_tx", "enable_warm_tx"                              , 0x0002a268, 0 , 0 },
{"BB_misc_pa_control", "enable_xpab"                         , 0x0002a280, 3 , 3 },
{"BB_misc_pa_control", "enable_xpaa"                         , 0x0002a280, 2 , 2 },
{"BB_misc_pa_control", "xpab_active_high"                    , 0x0002a280, 1 , 1 },
{"BB_misc_pa_control", "xpaa_active_high"                    , 0x0002a280, 0 , 0 },
{"BB_switch_table_chn_b0", "switch_table_b_0"                , 0x0002a284, 11, 10},
{"BB_switch_table_chn_b0", "switch_table_rx12_0"             , 0x0002a284, 9 , 8 },
{"BB_switch_table_chn_b0", "switch_table_rx1_0"              , 0x0002a284, 7 , 6 },
{"BB_switch_table_chn_b0", "switch_table_r_0"                , 0x0002a284, 5 , 4 },
{"BB_switch_table_chn_b0", "switch_table_t_0"                , 0x0002a284, 3 , 2 },
{"BB_switch_table_chn_b0", "switch_table_idle_0"             , 0x0002a284, 1 , 0 },
{"BB_switch_table_com1", "switch_table_com_tx_1chn"          , 0x0002a288, 23, 20},
{"BB_switch_table_com1", "switch_table_com_idle_alt"         , 0x0002a288, 19, 16},
{"BB_switch_table_com1", "switch_table_com_b"                , 0x0002a288, 15, 12},
{"BB_switch_table_com1", "switch_table_com_t2"               , 0x0002a288, 11, 8 },
{"BB_switch_table_com1", "switch_table_com_t1"               , 0x0002a288, 7 , 4 },
{"BB_switch_table_com1", "switch_table_com_idle"             , 0x0002a288, 3 , 0 },
{"BB_switch_table_com2", "switch_table_com_ra12"             , 0x0002a28c, 19, 16},
{"BB_switch_table_com2", "switch_table_com_ra2l2"            , 0x0002a28c, 15, 12},
{"BB_switch_table_com2", "switch_table_com_ra1l2"            , 0x0002a28c, 11, 8 },
{"BB_switch_table_com2", "switch_table_com_ra2l1"            , 0x0002a28c, 7 , 4 },
{"BB_switch_table_com2", "switch_table_com_ra1l1"            , 0x0002a28c, 3 , 0 },
{"BB_multichain_enable", "rx_chain_mask"                     , 0x0002a2a0, 2 , 0 },
{"BB_cal_chain_mask", "cal_chain_mask"                       , 0x0002a2c0, 2 , 0 },
{"BB_agc_control", "enable_pkdet_cal"                        , 0x0002a2c4, 20, 20},
{"BB_agc_control", "clc_success"                             , 0x0002a2c4, 19, 19},
{"BB_agc_control", "extend_NF_pwr_meas"                      , 0x0002a2c4, 18, 18},
{"BB_agc_control", "no_update_noisefloor"                    , 0x0002a2c4, 17, 17},
{"BB_agc_control", "enable_fltr_cal"                         , 0x0002a2c4, 16, 16},
{"BB_agc_control", "enable_noisefloor"                       , 0x0002a2c4, 15, 15},
{"BB_agc_control", "CAL_enable"                              , 0x0002a2c4, 11, 11},
{"BB_agc_control", "leaky_bucket_enable"                     , 0x0002a2c4, 10, 10},
{"BB_agc_control", "ycok_max"                                , 0x0002a2c4, 9 , 6 },
{"BB_agc_control", "min_num_gain_change"                     , 0x0002a2c4, 5 , 3 },
{"BB_agc_control", "do_noisefloor"                           , 0x0002a2c4, 1 , 1 },
{"BB_agc_control", "do_calibrate"                            , 0x0002a2c4, 0 , 0 },
{"BB_iq_adc_cal_mode", "test_caladcoff"                      , 0x0002a2c8, 2 , 2 },
{"BB_iq_adc_cal_mode", "gain_dc_iq_cal_mode"                 , 0x0002a2c8, 1 , 0 },
{"BB_fcal_1", "flc_sb_atten"                                 , 0x0002a2cc, 29, 25},
{"BB_fcal_1", "flc_pb_atten"                                 , 0x0002a2cc, 24, 20},
{"BB_fcal_1", "flc_sb_fstep"                                 , 0x0002a2cc, 19, 10},
{"BB_fcal_1", "flc_pb_fstep"                                 , 0x0002a2cc, 9 , 0 },
{"BB_fcal_2_b0", "flc_cap_val_status_0"                      , 0x0002a2d0, 24, 20},
{"BB_fcal_2_b0", "flc_meas_win"                              , 0x0002a2d0, 18, 16},
{"BB_fcal_2_b0", "flc_sw_cap_set"                            , 0x0002a2d0, 15, 15},
{"BB_fcal_2_b0", "flc_bb6dbgain"                             , 0x0002a2d0, 14, 13},
{"BB_fcal_2_b0", "flc_bb1dbgain"                             , 0x0002a2d0, 12, 10},
{"BB_fcal_2_b0", "flc_bbmiscgain"                            , 0x0002a2d0, 9 , 8 },
{"BB_fcal_2_b0", "flc_sw_cap_val_0"                          , 0x0002a2d0, 7 , 3 },
{"BB_fcal_2_b0", "flc_pwr_thresh"                            , 0x0002a2d0, 2 , 0 },
{"BB_dft_tone_ctrl_b0", "dft_tone_freq_ang_0"                , 0x0002a2d4, 12, 4 },
{"BB_dft_tone_ctrl_b0", "dft_tone_amp_sel_0"                 , 0x0002a2d4, 3 , 2 },
{"BB_dft_tone_ctrl_b0", "dft_tone_en_0"                      , 0x0002a2d4, 0 , 0 },
{"BB_cl_cal_ctrl", "cl_map_hw_gen"                           , 0x0002a2d8, 31, 31},
{"BB_cl_cal_ctrl", "use_dac_cl_correction"                   , 0x0002a2d8, 30, 30},
{"BB_cl_cal_ctrl", "cf_adc_bound"                            , 0x0002a2d8, 29, 22},
{"BB_cl_cal_ctrl", "cf_clc_init_bbgain"                      , 0x0002a2d8, 21, 16},
{"BB_cl_cal_ctrl", "carr_leak_max_offset"                    , 0x0002a2d8, 15, 8 },
{"BB_cl_cal_ctrl", "cf_clc_forced_pagain"                    , 0x0002a2d8, 7 , 4 },
{"BB_cl_cal_ctrl", "cf_clc_test_point"                       , 0x0002a2d8, 3 , 2 },
{"BB_cl_cal_ctrl", "enable_cl_calibrate"                     , 0x0002a2d8, 1 , 1 },
{"BB_cl_cal_ctrl", "enable_parallel_cal"                     , 0x0002a2d8, 0 , 0 },
{"BB_cl_map_0_b0", "cl_map_0"                                , 0x0002a2dc, 31, 0 },
{"BB_cl_map_1_b0", "cl_map_1"                                , 0x0002a2e0, 31, 0 },
{"BB_cl_map_2_b0", "cl_map_2"                                , 0x0002a2e4, 31, 0 },
{"BB_cl_map_3_b0", "cl_map_3"                                , 0x0002a2e8, 31, 0 },
{"BB_cl_tab_b0[0]", "bb_gain"                                , 0x0002a300, 30, 27},
{"BB_cl_tab_b0[0]", "carr_lk_dc_add_I"                       , 0x0002a300, 26, 16},
{"BB_cl_tab_b0[0]", "carr_lk_dc_add_Q"                       , 0x0002a300, 15, 5 },
{"BB_cl_tab_b0[0]", "cl_gain_mod"                            , 0x0002a300, 4 , 0 },
{"BB_cl_tab_b0[1]", "bb_gain"                                , 0x0002a304, 30, 27},
{"BB_cl_tab_b0[1]", "carr_lk_dc_add_I"                       , 0x0002a304, 26, 16},
{"BB_cl_tab_b0[1]", "carr_lk_dc_add_Q"                       , 0x0002a304, 15, 5 },
{"BB_cl_tab_b0[1]", "cl_gain_mod"                            , 0x0002a304, 4 , 0 },
{"BB_cl_tab_b0[2]", "bb_gain"                                , 0x0002a308, 30, 27},
{"BB_cl_tab_b0[2]", "carr_lk_dc_add_I"                       , 0x0002a308, 26, 16},
{"BB_cl_tab_b0[2]", "carr_lk_dc_add_Q"                       , 0x0002a308, 15, 5 },
{"BB_cl_tab_b0[2]", "cl_gain_mod"                            , 0x0002a308, 4 , 0 },
{"BB_cl_tab_b0[3]", "bb_gain"                                , 0x0002a30c, 30, 27},
{"BB_cl_tab_b0[3]", "carr_lk_dc_add_I"                       , 0x0002a30c, 26, 16},
{"BB_cl_tab_b0[3]", "carr_lk_dc_add_Q"                       , 0x0002a30c, 15, 5 },
{"BB_cl_tab_b0[3]", "cl_gain_mod"                            , 0x0002a30c, 4 , 0 },
{"BB_cl_tab_b0[4]", "bb_gain"                                , 0x0002a310, 30, 27},
{"BB_cl_tab_b0[4]", "carr_lk_dc_add_I"                       , 0x0002a310, 26, 16},
{"BB_cl_tab_b0[4]", "carr_lk_dc_add_Q"                       , 0x0002a310, 15, 5 },
{"BB_cl_tab_b0[4]", "cl_gain_mod"                            , 0x0002a310, 4 , 0 },
{"BB_cl_tab_b0[5]", "bb_gain"                                , 0x0002a314, 30, 27},
{"BB_cl_tab_b0[5]", "carr_lk_dc_add_I"                       , 0x0002a314, 26, 16},
{"BB_cl_tab_b0[5]", "carr_lk_dc_add_Q"                       , 0x0002a314, 15, 5 },
{"BB_cl_tab_b0[5]", "cl_gain_mod"                            , 0x0002a314, 4 , 0 },
{"BB_cl_tab_b0[6]", "bb_gain"                                , 0x0002a318, 30, 27},
{"BB_cl_tab_b0[6]", "carr_lk_dc_add_I"                       , 0x0002a318, 26, 16},
{"BB_cl_tab_b0[6]", "carr_lk_dc_add_Q"                       , 0x0002a318, 15, 5 },
{"BB_cl_tab_b0[6]", "cl_gain_mod"                            , 0x0002a318, 4 , 0 },
{"BB_cl_tab_b0[7]", "bb_gain"                                , 0x0002a31c, 30, 27},
{"BB_cl_tab_b0[7]", "carr_lk_dc_add_I"                       , 0x0002a31c, 26, 16},
{"BB_cl_tab_b0[7]", "carr_lk_dc_add_Q"                       , 0x0002a31c, 15, 5 },
{"BB_cl_tab_b0[7]", "cl_gain_mod"                            , 0x0002a31c, 4 , 0 },
{"BB_cl_tab_b0[8]", "bb_gain"                                , 0x0002a320, 30, 27},
{"BB_cl_tab_b0[8]", "carr_lk_dc_add_I"                       , 0x0002a320, 26, 16},
{"BB_cl_tab_b0[8]", "carr_lk_dc_add_Q"                       , 0x0002a320, 15, 5 },
{"BB_cl_tab_b0[8]", "cl_gain_mod"                            , 0x0002a320, 4 , 0 },
{"BB_cl_tab_b0[9]", "bb_gain"                                , 0x0002a324, 30, 27},
{"BB_cl_tab_b0[9]", "carr_lk_dc_add_I"                       , 0x0002a324, 26, 16},
{"BB_cl_tab_b0[9]", "carr_lk_dc_add_Q"                       , 0x0002a324, 15, 5 },
{"BB_cl_tab_b0[9]", "cl_gain_mod"                            , 0x0002a324, 4 , 0 },
{"BB_cl_tab_b0[10]", "bb_gain"                               , 0x0002a328, 30, 27},
{"BB_cl_tab_b0[10]", "carr_lk_dc_add_I"                      , 0x0002a328, 26, 16},
{"BB_cl_tab_b0[10]", "carr_lk_dc_add_Q"                      , 0x0002a328, 15, 5 },
{"BB_cl_tab_b0[10]", "cl_gain_mod"                           , 0x0002a328, 4 , 0 },
{"BB_cl_tab_b0[11]", "bb_gain"                               , 0x0002a32c, 30, 27},
{"BB_cl_tab_b0[11]", "carr_lk_dc_add_I"                      , 0x0002a32c, 26, 16},
{"BB_cl_tab_b0[11]", "carr_lk_dc_add_Q"                      , 0x0002a32c, 15, 5 },
{"BB_cl_tab_b0[11]", "cl_gain_mod"                           , 0x0002a32c, 4 , 0 },
{"BB_cl_tab_b0[12]", "bb_gain"                               , 0x0002a330, 30, 27},
{"BB_cl_tab_b0[12]", "carr_lk_dc_add_I"                      , 0x0002a330, 26, 16},
{"BB_cl_tab_b0[12]", "carr_lk_dc_add_Q"                      , 0x0002a330, 15, 5 },
{"BB_cl_tab_b0[12]", "cl_gain_mod"                           , 0x0002a330, 4 , 0 },
{"BB_cl_tab_b0[13]", "bb_gain"                               , 0x0002a334, 30, 27},
{"BB_cl_tab_b0[13]", "carr_lk_dc_add_I"                      , 0x0002a334, 26, 16},
{"BB_cl_tab_b0[13]", "carr_lk_dc_add_Q"                      , 0x0002a334, 15, 5 },
{"BB_cl_tab_b0[13]", "cl_gain_mod"                           , 0x0002a334, 4 , 0 },
{"BB_cl_tab_b0[14]", "bb_gain"                               , 0x0002a338, 30, 27},
{"BB_cl_tab_b0[14]", "carr_lk_dc_add_I"                      , 0x0002a338, 26, 16},
{"BB_cl_tab_b0[14]", "carr_lk_dc_add_Q"                      , 0x0002a338, 15, 5 },
{"BB_cl_tab_b0[14]", "cl_gain_mod"                           , 0x0002a338, 4 , 0 },
{"BB_cl_tab_b0[15]", "bb_gain"                               , 0x0002a33c, 30, 27},
{"BB_cl_tab_b0[15]", "carr_lk_dc_add_I"                      , 0x0002a33c, 26, 16},
{"BB_cl_tab_b0[15]", "carr_lk_dc_add_Q"                      , 0x0002a33c, 15, 5 },
{"BB_cl_tab_b0[15]", "cl_gain_mod"                           , 0x0002a33c, 4 , 0 },
{"BB_synth_control", "rfsynth_ctrl_sshift"                   , 0x0002a340, 30, 30},
{"BB_synth_control", "rfbmode"                               , 0x0002a340, 29, 29},
{"BB_synth_control", "rfFracmode"                            , 0x0002a340, 28, 28},
{"BB_synth_control", "rfAmodeRefSel"                         , 0x0002a340, 27, 26},
{"BB_synth_control", "rfchannel"                             , 0x0002a340, 25, 17},
{"BB_synth_control", "rfchanFrac"                            , 0x0002a340, 16, 0 },
{"BB_addac_clk_select", "bb_adc_clk_select"                  , 0x0002a344, 7 , 4 },
{"BB_addac_clk_select", "bb_dac_clk_select"                  , 0x0002a344, 3 , 1 },
{"BB_pll_cntl", "bb_pll_settle_time"                         , 0x0002a348, 27, 17},
{"BB_pll_cntl", "bb_pllbypass"                               , 0x0002a348, 16, 16},
{"BB_pll_cntl", "bb_pll_clk_sel"                             , 0x0002a348, 15, 14},
{"BB_pll_cntl", "bb_pll_refdiv"                              , 0x0002a348, 13, 10},
{"BB_pll_cntl", "bb_pll_div"                                 , 0x0002a348, 9 , 0 },
{"BB_analog_swap", "analog_pkdet_dac_polarity"               , 0x0002a34c, 8 , 8 },
{"BB_analog_swap", "analog_dc_dac_polarity"                  , 0x0002a34c, 7 , 7 },
{"BB_analog_swap", "swap_alt_chn"                            , 0x0002a34c, 6 , 6 },
{"BB_analog_swap", "analog_tx_swap_cntl"                     , 0x0002a34c, 5 , 3 },
{"BB_analog_swap", "analog_rx_swap_cntl"                     , 0x0002a34c, 2 , 0 },
{"BB_addac_parallel_control", "on_pwdAdc"                    , 0x0002a350, 31, 31},
{"BB_addac_parallel_control", "on_pwdDac"                    , 0x0002a350, 29, 29},
{"BB_addac_parallel_control", "on_daclpmode"                 , 0x0002a350, 28, 28},
{"BB_addac_parallel_control", "off_pwdAdc"                   , 0x0002a350, 15, 15},
{"BB_addac_parallel_control", "off_pwdDac"                   , 0x0002a350, 13, 13},
{"BB_addac_parallel_control", "off_daclpmode"                , 0x0002a350, 12, 12},
{"BB_force_clock", "cf_synthon_in_activelow"                 , 0x0002a354, 18, 18},
{"BB_force_clock", "cf_double_tx_radio_bw"                   , 0x0002a354, 17, 17},
{"BB_force_clock", "cf_forced_clktadc"                       , 0x0002a354, 16, 14},
{"BB_force_clock", "cf_force_clktadc"                        , 0x0002a354, 13, 13},
{"BB_force_clock", "cf_forced_clkgen_bw"                     , 0x0002a354, 12, 10},
{"BB_force_clock", "cf_force_clkgen_bw"                      , 0x0002a354, 9 , 9 },
{"BB_force_clock", "cf_forced_radio_bw"                      , 0x0002a354, 8 , 6 },
{"BB_force_clock", "cf_force_radio_bw"                       , 0x0002a354, 5 , 5 },
{"BB_force_clock", "cf_forced_adc_clk_rate"                  , 0x0002a354, 2 , 1 },
{"BB_force_clock", "cf_force_adc_clk_rate"                   , 0x0002a354, 0 , 0 },
{"BB_force_analog", "forced_pdadc_pwd"                       , 0x0002a358, 7 , 5 },
{"BB_force_analog", "force_pdadc_pwd"                        , 0x0002a358, 4 , 4 },
{"BB_force_analog", "forced_xpaon"                           , 0x0002a358, 3 , 1 },
{"BB_force_analog", "force_xpaon"                            , 0x0002a358, 0 , 0 },
{"BB_test_controls", "tstdac_out_sel"                        , 0x0002a360, 31, 30},
{"BB_test_controls", "force_agc_clear"                       , 0x0002a360, 28, 28},
{"BB_test_controls", "agc_obs_sel_4"                         , 0x0002a360, 24, 24},
{"BB_test_controls", "rx_obs_sel_5th_bit"                    , 0x0002a360, 23, 23},
{"BB_test_controls", "cf_bbb_obs_sel"                        , 0x0002a360, 22, 19},
{"BB_test_controls", "agc_obs_sel_3"                         , 0x0002a360, 18, 18},
{"BB_test_controls", "slow_clk160"                           , 0x0002a360, 17, 17},
{"BB_test_controls", "enable_mini_obs"                       , 0x0002a360, 15, 15},
{"BB_test_controls", "enable_rfsilent_bb"                    , 0x0002a360, 13, 13},
{"BB_test_controls", "clkout_is_clk32"                       , 0x0002a360, 10, 10},
{"BB_test_controls", "cardbus_mode"                          , 0x0002a360, 9 , 8 },
{"BB_test_controls", "cf_rfshift_sel"                        , 0x0002a360, 6 , 5 },
{"BB_test_controls", "cf_tsttrig"                            , 0x0002a360, 4 , 4 },
{"BB_test_controls", "cf_tsttrig_sel"                        , 0x0002a360, 3 , 0 },
{"BB_test_controls_status", "cf_debugport_sel"               , 0x0002a364, 31, 29},
{"BB_test_controls_status", "cf_debugport_en"                , 0x0002a364, 28, 28},
{"BB_test_controls_status", "disable_agc_to_a2"              , 0x0002a364, 27, 27},
{"BB_test_controls_status", "cf_debugport_in"                , 0x0002a364, 23, 23},
{"BB_test_controls_status", "cf_enable_fft_dump"             , 0x0002a364, 19, 19},
{"BB_test_controls_status", "agc_obs_sel"                    , 0x0002a364, 18, 16},
{"BB_test_controls_status", "reset_a2"                       , 0x0002a364, 15, 15},
{"BB_test_controls_status", "disable_a2_warm_reset"          , 0x0002a364, 14, 14},
{"BB_test_controls_status", "rx_obs_sel"                     , 0x0002a364, 13, 10},
{"BB_test_controls_status", "cf_rx_src_is_tstadc"            , 0x0002a364, 9 , 9 },
{"BB_test_controls_status", "cf_tstadc_en"                   , 0x0002a364, 8 , 8 },
{"BB_test_controls_status", "cf_tx_src_alternate"            , 0x0002a364, 7 , 7 },
{"BB_test_controls_status", "cf_tx_obs_mux_sel"              , 0x0002a364, 6 , 5 },
{"BB_test_controls_status", "cf_tx_obs_sel"                  , 0x0002a364, 4 , 2 },
{"BB_test_controls_status", "cf_tx_src_is_tstdac"            , 0x0002a364, 1 , 1 },
{"BB_test_controls_status", "cf_tstdac_en"                   , 0x0002a364, 0 , 0 },
{"BB_tstdac", "tstdac_out_i"                                 , 0x0002a368, 19, 10},
{"BB_tstdac", "tstdac_out_q"                                 , 0x0002a368, 9 , 0 },
{"BB_channel_status", "ant_div_cfg_used"                     , 0x0002a36c, 16, 14},
{"BB_channel_status", "bb_sw_com_out"                        , 0x0002a36c, 13, 10},
{"BB_channel_status", "bb_sw_out_2"                          , 0x0002a36c, 9 , 8 },
{"BB_channel_status", "bb_sw_out_1"                          , 0x0002a36c, 7 , 6 },
{"BB_channel_status", "bb_sw_out_0"                          , 0x0002a36c, 5 , 4 },
{"BB_channel_status", "rx_clear_pad"                         , 0x0002a36c, 3 , 3 },
{"BB_channel_status", "rx_clear_mac"                         , 0x0002a36c, 2 , 2 },
{"BB_channel_status", "rx_clear_raw"                         , 0x0002a36c, 1 , 1 },
{"BB_channel_status", "bt_active"                            , 0x0002a36c, 0 , 0 },
{"BB_chaninfo_ctrl", "rtt_enable_cch_rot"                    , 0x0002a370, 7 , 7 },
{"BB_chaninfo_ctrl", "rtt_mac_phy_phase"                     , 0x0002a370, 6 , 6 },
{"BB_chaninfo_ctrl", "chaninfomem_bw"                        , 0x0002a370, 5 , 4 },
{"BB_chaninfo_ctrl", "chaninfomem_s2_read"                   , 0x0002a370, 3 , 3 },
{"BB_chaninfo_ctrl", "capture_sounding_packet"               , 0x0002a370, 2 , 2 },
{"BB_chaninfo_ctrl", "disable_chaninfomem"                   , 0x0002a370, 1 , 1 },
{"BB_chaninfo_ctrl", "capture_chan_info"                     , 0x0002a370, 0 , 0 },
{"BB_chan_info_noise_pwr", "noise_power"                     , 0x0002a374, 11, 0 },
{"BB_chan_info_gain_diff", "analog_gain_diff_02"             , 0x0002a378, 25, 19},
{"BB_chan_info_gain_diff", "analog_gain_diff_01"             , 0x0002a378, 18, 12},
{"BB_chan_info_gain_diff", "fine_ppm"                        , 0x0002a378, 11, 0 },
{"BB_chan_info_fine_timing", "fine_timing"                   , 0x0002a37c, 21, 12},
{"BB_chan_info_fine_timing", "coarse_ppm"                    , 0x0002a37c, 11, 0 },
{"BB_chan_info_gain_b0", "chan_info_xatten2_sw_0"            , 0x0002a380, 24, 24},
{"BB_chan_info_gain_b0", "chan_info_xatten1_sw_0"            , 0x0002a380, 23, 23},
{"BB_chan_info_gain_b0", "chan_info_mb_gain_0"               , 0x0002a380, 22, 16},
{"BB_chan_info_gain_b0", "chan_info_rf_gain_0"               , 0x0002a380, 15, 8 },
{"BB_chan_info_gain_b0", "chan_info_rssi_0"                  , 0x0002a380, 7 , 0 },
{"BB_scrambler_seed", "fixed_scrambler_seed"                 , 0x0002a390, 6 , 0 },
{"BB_bbb_tx_ctrl", "tx_cck_delay_2"                          , 0x0002a394, 11, 9 },
{"BB_bbb_tx_ctrl", "tx_cck_delay_1"                          , 0x0002a394, 8 , 6 },
{"BB_bbb_tx_ctrl", "allow_1mbps_short"                       , 0x0002a394, 5 , 5 },
{"BB_bbb_tx_ctrl", "txfir_japan_cck"                         , 0x0002a394, 4 , 4 },
{"BB_bbb_tx_ctrl", "tx_dac_scale_cck"                        , 0x0002a394, 3 , 2 },
{"BB_bbb_tx_ctrl", "use_scrambler_seed"                      , 0x0002a394, 1 , 1 },
{"BB_bbb_tx_ctrl", "disable_scrambler"                       , 0x0002a394, 0 , 0 },
{"BB_bbb_txfir_0", "txfir_coeff_h3"                          , 0x0002a398, 28, 24},
{"BB_bbb_txfir_0", "txfir_coeff_h2"                          , 0x0002a398, 20, 16},
{"BB_bbb_txfir_0", "txfir_coeff_h1"                          , 0x0002a398, 11, 8 },
{"BB_bbb_txfir_0", "txfir_coeff_h0"                          , 0x0002a398, 3 , 0 },
{"BB_bbb_txfir_1", "txfir_coeff_h7"                          , 0x0002a39c, 30, 24},
{"BB_bbb_txfir_1", "txfir_coeff_h6"                          , 0x0002a39c, 22, 16},
{"BB_bbb_txfir_1", "txfir_coeff_h5"                          , 0x0002a39c, 13, 8 },
{"BB_bbb_txfir_1", "txfir_coeff_h4"                          , 0x0002a39c, 5 , 0 },
{"BB_bbb_txfir_2", "txfir_coeff_h11"                         , 0x0002a3a0, 31, 24},
{"BB_bbb_txfir_2", "txfir_coeff_h10"                         , 0x0002a3a0, 23, 16},
{"BB_bbb_txfir_2", "txfir_coeff_h9"                          , 0x0002a3a0, 15, 8 },
{"BB_bbb_txfir_2", "txfir_coeff_h8"                          , 0x0002a3a0, 7 , 0 },
{"BB_heavy_clip_0", "heavy_clip_factor_qam3"                 , 0x0002a3a4, 31, 24},
{"BB_heavy_clip_0", "heavy_clip_factor_qam2"                 , 0x0002a3a4, 23, 16},
{"BB_heavy_clip_0", "heavy_clip_factor_qam1"                 , 0x0002a3a4, 15, 8 },
{"BB_heavy_clip_0", "heavy_clip_factor_qam0"                 , 0x0002a3a4, 7 , 0 },
{"BB_heavy_clip_1", "heavy_clip_enable"                      , 0x0002a3a8, 12, 8 },
{"BB_heavy_clip_1", "heavy_clip_factor_qam4"                 , 0x0002a3a8, 7 , 0 },
{"BB_sm_hist_0", "sm_rec_last_addr"                          , 0x0002a3b4, 31, 26},
{"BB_sm_hist_0", "sm_rec_mac_trig"                           , 0x0002a3b4, 24, 22},
{"BB_sm_hist_0", "sm_rec_agc_sel"                            , 0x0002a3b4, 21, 21},
{"BB_sm_hist_0", "sm_rec_data_num"                           , 0x0002a3b4, 20, 17},
{"BB_sm_hist_0", "sm_rec_chn_en"                             , 0x0002a3b4, 16, 14},
{"BB_sm_hist_0", "sm_rec_part_en"                            , 0x0002a3b4, 13, 4 },
{"BB_sm_hist_0", "sm_rec_time_res"                           , 0x0002a3b4, 3 , 2 },
{"BB_sm_hist_0", "sm_rec_mode"                               , 0x0002a3b4, 1 , 1 },
{"BB_sm_hist_0", "sm_rec_en"                                 , 0x0002a3b4, 0 , 0 },
{"BB_sm_hist_1", "sm_rec_ss_format"                          , 0x0002a3b8, 1 , 0 },
{"BB_powertx_max_sub", "powertx_sub_for_3chain"              , 0x0002a3f0, 19, 14},
{"BB_powertx_max_sub", "powertx_sub_for_2chain"              , 0x0002a3f0, 13, 8 },
{"BB_powertx_max_sub", "use_per_packet_olpc_gain_delta_adj"  , 0x0002a3f0, 7 , 7 },
{"BB_powertx_max_sub", "use_per_packet_powertx_max"          , 0x0002a3f0, 6 , 6 },
{"BB_tpc_1", "therm_gain_err_db_max"                         , 0x0002a3f8, 30, 26},
{"BB_tpc_1", "forced_pdadc_gain"                             , 0x0002a3f8, 25, 24},
{"BB_tpc_1", "force_pdadc_gain"                              , 0x0002a3f8, 23, 23},
{"BB_tpc_1", "pd_calibrate_wait"                             , 0x0002a3f8, 22, 17},
{"BB_tpc_1", "enable_pd_calibrate"                           , 0x0002a3f8, 16, 16},
{"BB_tpc_1", "pd_gain_setting3"                              , 0x0002a3f8, 15, 14},
{"BB_tpc_1", "pd_gain_setting2"                              , 0x0002a3f8, 13, 12},
{"BB_tpc_1", "pd_gain_setting1"                              , 0x0002a3f8, 11, 10},
{"BB_tpc_1", "num_pd_gain"                                   , 0x0002a3f8, 9 , 8 },
{"BB_tpc_1", "pd_dc_offset_target"                           , 0x0002a3f8, 7 , 0 },
{"BB_tpc_2", "forced_target_power"                           , 0x0002a3fc, 29, 25},
{"BB_tpc_2", "use_forced_target_power"                       , 0x0002a3fc, 24, 24},
{"BB_tpc_2", "tx_frame_to_pd_acc_cck"                        , 0x0002a3fc, 23, 16},
{"BB_tpc_2", "tx_frame_to_pd_acc_ofdm"                       , 0x0002a3fc, 15, 8 },
{"BB_tpc_2", "tx_frame_to_pdadc_on"                          , 0x0002a3fc, 7 , 0 },
{"BB_tpc_3", "tpc_clk_gate_enable"                           , 0x0002a400, 31, 31},
{"BB_tpc_3", "pd_acc_window_cck"                             , 0x0002a400, 27, 25},
{"BB_tpc_3", "pd_acc_window_ofdm"                            , 0x0002a400, 24, 22},
{"BB_tpc_3", "pd_acc_window_cal"                             , 0x0002a400, 21, 19},
{"BB_tpc_3", "pd_acc_window_dc_off"                          , 0x0002a400, 18, 16},
{"BB_tpc_3", "tx_end_to_pd_acc_on"                           , 0x0002a400, 15, 8 },
{"BB_tpc_3", "tx_end_to_pdadc_on"                            , 0x0002a400, 7 , 0 },
{"BB_tpc_4_b0", "error_est_update_power_thresh"              , 0x0002a404, 30, 25},
{"BB_tpc_4_b0", "rate_sent_0"                                , 0x0002a404, 24, 20},
{"BB_tpc_4_b0", "tx_gain_setting_0"                          , 0x0002a404, 19, 14},
{"BB_tpc_4_b0", "dac_gain_0"                                 , 0x0002a404, 13, 9 },
{"BB_tpc_4_b0", "pd_avg_out_0"                               , 0x0002a404, 8 , 1 },
{"BB_tpc_4_b0", "pd_avg_valid_0"                             , 0x0002a404, 0 , 0 },
{"BB_tpc_5_b0", "pd_gain_boundary_4_0"                       , 0x0002a408, 27, 22},
{"BB_tpc_5_b0", "pd_gain_boundary_3_0"                       , 0x0002a408, 21, 16},
{"BB_tpc_5_b0", "pd_gain_boundary_2_0"                       , 0x0002a408, 15, 10},
{"BB_tpc_5_b0", "pd_gain_boundary_1_0"                       , 0x0002a408, 9 , 4 },
{"BB_tpc_5_b0", "pd_gain_overlap"                            , 0x0002a408, 3 , 0 },
{"BB_tpc_6_b0", "error_est_filter_coeff"                     , 0x0002a40c, 28, 26},
{"BB_tpc_6_b0", "error_est_mode"                             , 0x0002a40c, 25, 24},
{"BB_tpc_6_b0", "pd_dac_setting_4_0"                         , 0x0002a40c, 23, 18},
{"BB_tpc_6_b0", "pd_dac_setting_3_0"                         , 0x0002a40c, 17, 12},
{"BB_tpc_6_b0", "pd_dac_setting_2_0"                         , 0x0002a40c, 11, 6 },
{"BB_tpc_6_b0", "pd_dac_setting_1_0"                         , 0x0002a40c, 5 , 0 },
{"BB_tpc_7", "forced_dac_gain"                               , 0x0002a410, 24, 17},
{"BB_tpc_7", "force_dac_gain"                                , 0x0002a410, 16, 16},
{"BB_tpc_7", "use_init_tx_gain_setting_after_warm_reset"     , 0x0002a410, 15, 15},
{"BB_tpc_7", "extend_tx_frame_for_tpc"                       , 0x0002a410, 14, 14},
{"BB_tpc_7", "use_tx_pd_in_xpa"                              , 0x0002a410, 13, 13},
{"BB_tpc_7", "en_cl_gain_mod"                                , 0x0002a410, 12, 12},
{"BB_tpc_7", "init_tx_gain_setting"                          , 0x0002a410, 11, 6 },
{"BB_tpc_7", "tx_gain_table_max"                             , 0x0002a410, 5 , 0 },
{"BB_tpc_9", "disable_pdadc_residual_dc_removal"             , 0x0002a418, 11, 11},
{"BB_tpc_9", "wait_caltx_settle"                             , 0x0002a418, 10, 7 },
{"BB_tpc_9", "pd_dc_offset_thr"                              , 0x0002a418, 6 , 1 },
{"BB_tpc_9", "en_pd_dc_offset_thr"                           , 0x0002a418, 0 , 0 },
{"BB_tpc_10_b0", "txgain_idx_cal_b_0"                        , 0x0002a41c, 29, 24},
{"BB_tpc_10_b0", "txgain_idx_cal_a_0"                        , 0x0002a41c, 21, 16},
{"BB_tpc_10_b0", "pwr_meas_cal_b_0"                          , 0x0002a41c, 15, 8 },
{"BB_tpc_10_b0", "pwr_meas_cal_a_0"                          , 0x0002a41c, 7 , 0 },
{"BB_tpc_11_b0", "forced_txgain_idx_0"                       , 0x0002a420, 15, 10},
{"BB_tpc_11_b0", "olpc_gain_delta_0_lsb_ext"                 , 0x0002a420, 9 , 8 },
{"BB_tpc_11_b0", "olpc_gain_delta_0"                         , 0x0002a420, 7 , 0 },
{"BB_tpc_12", "dac_gain_cal_b"                               , 0x0002a424, 15, 8 },
{"BB_tpc_12", "dac_gain_cal_a"                               , 0x0002a424, 7 , 0 },
{"BB_tpc_13", "min_dac_bo_qam0"                              , 0x0002a428, 29, 24},
{"BB_tpc_13", "max_dac_bo_qam0"                              , 0x0002a428, 21, 16},
{"BB_tpc_13", "min_dac_bo_cck"                               , 0x0002a428, 13, 8 },
{"BB_tpc_13", "max_dac_bo_cck"                               , 0x0002a428, 5 , 0 },
{"BB_tpc_14", "min_dac_bo_qam2"                              , 0x0002a42c, 29, 24},
{"BB_tpc_14", "max_dac_bo_qam2"                              , 0x0002a42c, 21, 16},
{"BB_tpc_14", "min_dac_bo_qam1"                              , 0x0002a42c, 13, 8 },
{"BB_tpc_14", "max_dac_bo_qam1"                              , 0x0002a42c, 5 , 0 },
{"BB_tpc_15", "min_dac_bo_qam4"                              , 0x0002a430, 29, 24},
{"BB_tpc_15", "max_dac_bo_qam4"                              , 0x0002a430, 21, 16},
{"BB_tpc_15", "min_dac_bo_qam3"                              , 0x0002a430, 13, 8 },
{"BB_tpc_15", "max_dac_bo_qam3"                              , 0x0002a430, 5 , 0 },
{"BB_tpc_16", "pdadc_par_corr_ht40"                          , 0x0002a434, 29, 24},
{"BB_tpc_16", "pdadc_par_corr_ofdm"                          , 0x0002a434, 21, 16},
{"BB_tpc_16", "pdadc_par_corr_cck"                           , 0x0002a434, 13, 8 },
{"BB_tpc_17", "force_txgain_idx"                             , 0x0002a438, 31, 31},
{"BB_tpc_17", "olpc_mode"                                    , 0x0002a438, 30, 30},
{"BB_tpc_17", "heavy_clip_comp_factor_qam4"                  , 0x0002a438, 29, 24},
{"BB_tpc_17", "heavy_clip_comp_factor_qam3"                  , 0x0002a438, 23, 18},
{"BB_tpc_17", "heavy_clip_comp_factor_qam2"                  , 0x0002a438, 17, 12},
{"BB_tpc_17", "heavy_clip_comp_factor_qam1"                  , 0x0002a438, 11, 6 },
{"BB_tpc_17", "heavy_clip_comp_factor_qam0"                  , 0x0002a438, 5 , 0 },
{"BB_tpc_18", "min_power_therm_volt_gain_corr"               , 0x0002a43c, 22, 17},
{"BB_tpc_18", "use_legacy_tpc"                               , 0x0002a43c, 16, 16},
{"BB_tpc_18", "volt_cal_value"                               , 0x0002a43c, 15, 8 },
{"BB_tpc_18", "therm_cal_value"                              , 0x0002a43c, 7 , 0 },
{"BB_tpc_19_b0", "alpha_volt_0"                              , 0x0002a440, 14, 8 },
{"BB_tpc_19_b0", "alpha_therm_0"                             , 0x0002a440, 7 , 0 },
{"BB_therm_adc_1", "therm_measure_reset"                     , 0x0002a448, 29, 29},
{"BB_therm_adc_1", "check_done_for_1st_adc_meas_of_each_frame", 0x0002a448, 28, 28},
{"BB_therm_adc_1", "force_therm_volt_atb_to_init_settings"   , 0x0002a448, 27, 27},
{"BB_therm_adc_1", "use_init_therm_volt_atb_after_warm_reset", 0x0002a448, 26, 26},
{"BB_therm_adc_1", "samples_cnt_coding"                      , 0x0002a448, 25, 24},
{"BB_therm_adc_1", "init_atb_setting"                        , 0x0002a448, 23, 16},
{"BB_therm_adc_1", "init_volt_setting"                       , 0x0002a448, 15, 8 },
{"BB_therm_adc_1", "init_therm_setting"                      , 0x0002a448, 7 , 0 },
{"BB_therm_adc_2", "measure_atb_freq"                        , 0x0002a44c, 31, 22},
{"BB_therm_adc_2", "measure_volt_freq"                       , 0x0002a44c, 21, 12},
{"BB_therm_adc_2", "measure_therm_freq"                      , 0x0002a44c, 11, 0 },
{"BB_therm_adc_3", "adc_interval"                            , 0x0002a450, 29, 17},
{"BB_therm_adc_3", "therm_adc_scaled_gain"                   , 0x0002a450, 16, 8 },
{"BB_therm_adc_3", "therm_adc_offset"                        , 0x0002a450, 7 , 0 },
{"BB_therm_adc_4", "preferred_therm_chain"                   , 0x0002a454, 27, 25},
{"BB_therm_adc_4", "force_therm_chain"                       , 0x0002a454, 24, 24},
{"BB_therm_adc_4", "latest_atb_value"                        , 0x0002a454, 23, 16},
{"BB_therm_adc_4", "latest_volt_value"                       , 0x0002a454, 15, 8 },
{"BB_therm_adc_4", "latest_therm_value"                      , 0x0002a454, 7 , 0 },
{"BB_tx_forced_gain", "forced_green_paprd_enable"            , 0x0002a458, 31, 31},
{"BB_tx_forced_gain", "forced_db"                            , 0x0002a458, 30, 28},
{"BB_tx_forced_gain", "forced_ob"                            , 0x0002a458, 27, 25},
{"BB_tx_forced_gain", "forced_enable_PAL"                    , 0x0002a458, 24, 24},
{"BB_tx_forced_gain", "forced_padrvgnD"                      , 0x0002a458, 23, 22},
{"BB_tx_forced_gain", "forced_padrvgnC"                      , 0x0002a458, 21, 18},
{"BB_tx_forced_gain", "forced_padrvgnB"                      , 0x0002a458, 17, 14},
{"BB_tx_forced_gain", "forced_padrvgnA"                      , 0x0002a458, 13, 10},
{"BB_tx_forced_gain", "forced_txmxrgain"                     , 0x0002a458, 9 , 6 },
{"BB_tx_forced_gain", "forced_txbb6dbgain"                   , 0x0002a458, 5 , 4 },
{"BB_tx_forced_gain", "forced_txbb1dbgain"                   , 0x0002a458, 3 , 1 },
{"BB_tx_forced_gain", "force_tx_gain"                        , 0x0002a458, 0 , 0 },
{"BB_pdadc_tab_b0[0]", "tab_entry"                           , 0x0002a480, 31, 0 },
{"BB_pdadc_tab_b0[1]", "tab_entry"                           , 0x0002a484, 31, 0 },
{"BB_pdadc_tab_b0[2]", "tab_entry"                           , 0x0002a488, 31, 0 },
{"BB_pdadc_tab_b0[3]", "tab_entry"                           , 0x0002a48c, 31, 0 },
{"BB_pdadc_tab_b0[4]", "tab_entry"                           , 0x0002a490, 31, 0 },
{"BB_pdadc_tab_b0[5]", "tab_entry"                           , 0x0002a494, 31, 0 },
{"BB_pdadc_tab_b0[6]", "tab_entry"                           , 0x0002a498, 31, 0 },
{"BB_pdadc_tab_b0[7]", "tab_entry"                           , 0x0002a49c, 31, 0 },
{"BB_pdadc_tab_b0[8]", "tab_entry"                           , 0x0002a4a0, 31, 0 },
{"BB_pdadc_tab_b0[9]", "tab_entry"                           , 0x0002a4a4, 31, 0 },
{"BB_pdadc_tab_b0[10]", "tab_entry"                          , 0x0002a4a8, 31, 0 },
{"BB_pdadc_tab_b0[11]", "tab_entry"                          , 0x0002a4ac, 31, 0 },
{"BB_pdadc_tab_b0[12]", "tab_entry"                          , 0x0002a4b0, 31, 0 },
{"BB_pdadc_tab_b0[13]", "tab_entry"                          , 0x0002a4b4, 31, 0 },
{"BB_pdadc_tab_b0[14]", "tab_entry"                          , 0x0002a4b8, 31, 0 },
{"BB_pdadc_tab_b0[15]", "tab_entry"                          , 0x0002a4bc, 31, 0 },
{"BB_pdadc_tab_b0[16]", "tab_entry"                          , 0x0002a4c0, 31, 0 },
{"BB_pdadc_tab_b0[17]", "tab_entry"                          , 0x0002a4c4, 31, 0 },
{"BB_pdadc_tab_b0[18]", "tab_entry"                          , 0x0002a4c8, 31, 0 },
{"BB_pdadc_tab_b0[19]", "tab_entry"                          , 0x0002a4cc, 31, 0 },
{"BB_pdadc_tab_b0[20]", "tab_entry"                          , 0x0002a4d0, 31, 0 },
{"BB_pdadc_tab_b0[21]", "tab_entry"                          , 0x0002a4d4, 31, 0 },
{"BB_pdadc_tab_b0[22]", "tab_entry"                          , 0x0002a4d8, 31, 0 },
{"BB_pdadc_tab_b0[23]", "tab_entry"                          , 0x0002a4dc, 31, 0 },
{"BB_pdadc_tab_b0[24]", "tab_entry"                          , 0x0002a4e0, 31, 0 },
{"BB_pdadc_tab_b0[25]", "tab_entry"                          , 0x0002a4e4, 31, 0 },
{"BB_pdadc_tab_b0[26]", "tab_entry"                          , 0x0002a4e8, 31, 0 },
{"BB_pdadc_tab_b0[27]", "tab_entry"                          , 0x0002a4ec, 31, 0 },
{"BB_pdadc_tab_b0[28]", "tab_entry"                          , 0x0002a4f0, 31, 0 },
{"BB_pdadc_tab_b0[29]", "tab_entry"                          , 0x0002a4f4, 31, 0 },
{"BB_pdadc_tab_b0[30]", "tab_entry"                          , 0x0002a4f8, 31, 0 },
{"BB_pdadc_tab_b0[31]", "tab_entry"                          , 0x0002a4fc, 31, 0 },
{"BB_tx_gain_tab_1", "tg_table1"                             , 0x0002a500, 31, 0 },
{"BB_tx_gain_tab_2", "tg_table2"                             , 0x0002a504, 31, 0 },
{"BB_tx_gain_tab_3", "tg_table3"                             , 0x0002a508, 31, 0 },
{"BB_tx_gain_tab_4", "tg_table4"                             , 0x0002a50c, 31, 0 },
{"BB_tx_gain_tab_5", "tg_table5"                             , 0x0002a510, 31, 0 },
{"BB_tx_gain_tab_6", "tg_table6"                             , 0x0002a514, 31, 0 },
{"BB_tx_gain_tab_7", "tg_table7"                             , 0x0002a518, 31, 0 },
{"BB_tx_gain_tab_8", "tg_table8"                             , 0x0002a51c, 31, 0 },
{"BB_tx_gain_tab_9", "tg_table9"                             , 0x0002a520, 31, 0 },
{"BB_tx_gain_tab_10", "tg_table10"                           , 0x0002a524, 31, 0 },
{"BB_tx_gain_tab_11", "tg_table11"                           , 0x0002a528, 31, 0 },
{"BB_tx_gain_tab_12", "tg_table12"                           , 0x0002a52c, 31, 0 },
{"BB_tx_gain_tab_13", "tg_table13"                           , 0x0002a530, 31, 0 },
{"BB_tx_gain_tab_14", "tg_table14"                           , 0x0002a534, 31, 0 },
{"BB_tx_gain_tab_15", "tg_table15"                           , 0x0002a538, 31, 0 },
{"BB_tx_gain_tab_16", "tg_table16"                           , 0x0002a53c, 31, 0 },
{"BB_tx_gain_tab_17", "tg_table17"                           , 0x0002a540, 31, 0 },
{"BB_tx_gain_tab_18", "tg_table18"                           , 0x0002a544, 31, 0 },
{"BB_tx_gain_tab_19", "tg_table19"                           , 0x0002a548, 31, 0 },
{"BB_tx_gain_tab_20", "tg_table20"                           , 0x0002a54c, 31, 0 },
{"BB_tx_gain_tab_21", "tg_table21"                           , 0x0002a550, 31, 0 },
{"BB_tx_gain_tab_22", "tg_table22"                           , 0x0002a554, 31, 0 },
{"BB_tx_gain_tab_23", "tg_table23"                           , 0x0002a558, 31, 0 },
{"BB_tx_gain_tab_24", "tg_table24"                           , 0x0002a55c, 31, 0 },
{"BB_tx_gain_tab_25", "tg_table25"                           , 0x0002a560, 31, 0 },
{"BB_tx_gain_tab_26", "tg_table26"                           , 0x0002a564, 31, 0 },
{"BB_tx_gain_tab_27", "tg_table27"                           , 0x0002a568, 31, 0 },
{"BB_tx_gain_tab_28", "tg_table28"                           , 0x0002a56c, 31, 0 },
{"BB_tx_gain_tab_29", "tg_table29"                           , 0x0002a570, 31, 0 },
{"BB_tx_gain_tab_30", "tg_table30"                           , 0x0002a574, 31, 0 },
{"BB_tx_gain_tab_31", "tg_table31"                           , 0x0002a578, 31, 0 },
{"BB_tx_gain_tab_32", "tg_table32"                           , 0x0002a57c, 31, 0 },
{"BB_rtt_ctrl", "force_radio_restore"                        , 0x0002a580, 7 , 7 },
{"BB_rtt_ctrl", "restore_mask"                               , 0x0002a580, 6 , 1 },
{"BB_rtt_ctrl", "ena_radio_retention"                        , 0x0002a580, 0 , 0 },
{"BB_rtt_table_sw_intf_b0", "sw_rtt_table_addr_offset_0"     , 0x0002a584, 5 , 5 },
{"BB_rtt_table_sw_intf_b0", "sw_rtt_table_addr_0"            , 0x0002a584, 4 , 2 },
{"BB_rtt_table_sw_intf_b0", "sw_rtt_table_write_0"           , 0x0002a584, 1 , 1 },
{"BB_rtt_table_sw_intf_b0", "sw_rtt_table_access_0"          , 0x0002a584, 0 , 0 },
{"BB_rtt_table_sw_intf_1_b0", "sw_rtt_table_data_0"          , 0x0002a588, 31, 0 },
{"BB_tx_gain_tab_1_16_lsb_ext", "tg_table1_16_lsb_ext"       , 0x0002a58c, 31, 0 },
{"BB_tx_gain_tab_17_32_lsb_ext", "tg_table17_32_lsb_ext"     , 0x0002a590, 31, 0 },
{"BB_caltx_gain_set_0", "caltx_gain_set_1"                   , 0x0002a600, 27, 14},
{"BB_caltx_gain_set_0", "caltx_gain_set_0"                   , 0x0002a600, 13, 0 },
{"BB_caltx_gain_set_2", "caltx_gain_set_3"                   , 0x0002a604, 27, 14},
{"BB_caltx_gain_set_2", "caltx_gain_set_2"                   , 0x0002a604, 13, 0 },
{"BB_caltx_gain_set_4", "caltx_gain_set_5"                   , 0x0002a608, 27, 14},
{"BB_caltx_gain_set_4", "caltx_gain_set_4"                   , 0x0002a608, 13, 0 },
{"BB_caltx_gain_set_6", "caltx_gain_set_7"                   , 0x0002a60c, 27, 14},
{"BB_caltx_gain_set_6", "caltx_gain_set_6"                   , 0x0002a60c, 13, 0 },
{"BB_caltx_gain_set_8", "caltx_gain_set_9"                   , 0x0002a610, 27, 14},
{"BB_caltx_gain_set_8", "caltx_gain_set_8"                   , 0x0002a610, 13, 0 },
{"BB_caltx_gain_set_10", "caltx_gain_set_11"                 , 0x0002a614, 27, 14},
{"BB_caltx_gain_set_10", "caltx_gain_set_10"                 , 0x0002a614, 13, 0 },
{"BB_caltx_gain_set_12", "caltx_gain_set_13"                 , 0x0002a618, 27, 14},
{"BB_caltx_gain_set_12", "caltx_gain_set_12"                 , 0x0002a618, 13, 0 },
{"BB_caltx_gain_set_14", "caltx_gain_set_15"                 , 0x0002a61c, 27, 14},
{"BB_caltx_gain_set_14", "caltx_gain_set_14"                 , 0x0002a61c, 13, 0 },
{"BB_caltx_gain_set_16", "caltx_gain_set_17"                 , 0x0002a620, 27, 14},
{"BB_caltx_gain_set_16", "caltx_gain_set_16"                 , 0x0002a620, 13, 0 },
{"BB_caltx_gain_set_18", "caltx_gain_set_19"                 , 0x0002a624, 27, 14},
{"BB_caltx_gain_set_18", "caltx_gain_set_18"                 , 0x0002a624, 13, 0 },
{"BB_caltx_gain_set_20", "caltx_gain_set_21"                 , 0x0002a628, 27, 14},
{"BB_caltx_gain_set_20", "caltx_gain_set_20"                 , 0x0002a628, 13, 0 },
{"BB_caltx_gain_set_22", "caltx_gain_set_23"                 , 0x0002a62c, 27, 14},
{"BB_caltx_gain_set_22", "caltx_gain_set_22"                 , 0x0002a62c, 13, 0 },
{"BB_caltx_gain_set_24", "caltx_gain_set_25"                 , 0x0002a630, 27, 14},
{"BB_caltx_gain_set_24", "caltx_gain_set_24"                 , 0x0002a630, 13, 0 },
{"BB_caltx_gain_set_26", "caltx_gain_set_27"                 , 0x0002a634, 27, 14},
{"BB_caltx_gain_set_26", "caltx_gain_set_26"                 , 0x0002a634, 13, 0 },
{"BB_caltx_gain_set_28", "caltx_gain_set_29"                 , 0x0002a638, 27, 14},
{"BB_caltx_gain_set_28", "caltx_gain_set_28"                 , 0x0002a638, 13, 0 },
{"BB_caltx_gain_set_30", "caltx_gain_set_31"                 , 0x0002a63c, 27, 14},
{"BB_caltx_gain_set_30", "caltx_gain_set_30"                 , 0x0002a63c, 13, 0 },
{"BB_txiqcal_control_0", "enable_txiq_calibrate"             , 0x0002a644, 31, 31},
{"BB_txiqcal_control_0", "enable_combined_carr_iq_cal"       , 0x0002a644, 30, 30},
{"BB_txiqcal_control_0", "loopback_delay"                    , 0x0002a644, 29, 23},
{"BB_txiqcal_control_0", "caltxshift_delay"                  , 0x0002a644, 22, 19},
{"BB_txiqcal_control_0", "min_tx_tone_gain"                  , 0x0002a644, 18, 13},
{"BB_txiqcal_control_0", "max_tx_tone_gain"                  , 0x0002a644, 12, 7 },
{"BB_txiqcal_control_0", "base_tx_tone_db"                   , 0x0002a644, 6 , 1 },
{"BB_txiqcal_control_0", "iqc_tx_table_sel"                  , 0x0002a644, 0 , 0 },
{"BB_txiqcal_control_1", "iqcal_disable_mixer"               , 0x0002a648, 27, 27},
{"BB_txiqcal_control_1", "iqcorr_i_q_coff_delpt"             , 0x0002a648, 26, 18},
{"BB_txiqcal_control_1", "min_rx_gain_db"                    , 0x0002a648, 17, 12},
{"BB_txiqcal_control_1", "max_rx_gain_db"                    , 0x0002a648, 11, 6 },
{"BB_txiqcal_control_1", "rx_init_gain_db"                   , 0x0002a648, 5 , 0 },
{"BB_txiqcal_control_2", "dither_ctl"                        , 0x0002a64c, 24, 22},
{"BB_txiqcal_control_2", "gain_update_delay"                 , 0x0002a64c, 21, 14},
{"BB_txiqcal_control_2", "iqcal_max_tx_gain"                 , 0x0002a64c, 13, 9 },
{"BB_txiqcal_control_2", "iqcal_min_tx_gain"                 , 0x0002a64c, 8 , 4 },
{"BB_txiqcal_control_2", "iqc_forced_pagain"                 , 0x0002a64c, 3 , 0 },
{"BB_cal_rxbb_gain_tbl_0", "txcal_rx_bb_gain_table_3"        , 0x0002a670, 31, 24},
{"BB_cal_rxbb_gain_tbl_0", "txcal_rx_bb_gain_table_2"        , 0x0002a670, 23, 16},
{"BB_cal_rxbb_gain_tbl_0", "txcal_rx_bb_gain_table_1"        , 0x0002a670, 15, 8 },
{"BB_cal_rxbb_gain_tbl_0", "txcal_rx_bb_gain_table_0"        , 0x0002a670, 7 , 0 },
{"BB_cal_rxbb_gain_tbl_4", "txcal_rx_bb_gain_table_7"        , 0x0002a674, 31, 24},
{"BB_cal_rxbb_gain_tbl_4", "txcal_rx_bb_gain_table_6"        , 0x0002a674, 23, 16},
{"BB_cal_rxbb_gain_tbl_4", "txcal_rx_bb_gain_table_5"        , 0x0002a674, 15, 8 },
{"BB_cal_rxbb_gain_tbl_4", "txcal_rx_bb_gain_table_4"        , 0x0002a674, 7 , 0 },
{"BB_cal_rxbb_gain_tbl_8", "txcal_rx_bb_gain_table_11"       , 0x0002a678, 31, 24},
{"BB_cal_rxbb_gain_tbl_8", "txcal_rx_bb_gain_table_10"       , 0x0002a678, 23, 16},
{"BB_cal_rxbb_gain_tbl_8", "txcal_rx_bb_gain_table_9"        , 0x0002a678, 15, 8 },
{"BB_cal_rxbb_gain_tbl_8", "txcal_rx_bb_gain_table_8"        , 0x0002a678, 7 , 0 },
{"BB_cal_rxbb_gain_tbl_12", "txcal_rx_bb_gain_table_15"      , 0x0002a67c, 31, 24},
{"BB_cal_rxbb_gain_tbl_12", "txcal_rx_bb_gain_table_14"      , 0x0002a67c, 23, 16},
{"BB_cal_rxbb_gain_tbl_12", "txcal_rx_bb_gain_table_13"      , 0x0002a67c, 15, 8 },
{"BB_cal_rxbb_gain_tbl_12", "txcal_rx_bb_gain_table_12"      , 0x0002a67c, 7 , 0 },
{"BB_cal_rxbb_gain_tbl_16", "txcal_rx_bb_gain_table_19"      , 0x0002a680, 31, 24},
{"BB_cal_rxbb_gain_tbl_16", "txcal_rx_bb_gain_table_18"      , 0x0002a680, 23, 16},
{"BB_cal_rxbb_gain_tbl_16", "txcal_rx_bb_gain_table_17"      , 0x0002a680, 15, 8 },
{"BB_cal_rxbb_gain_tbl_16", "txcal_rx_bb_gain_table_16"      , 0x0002a680, 7 , 0 },
{"BB_cal_rxbb_gain_tbl_20", "txcal_rx_bb_gain_table_23"      , 0x0002a684, 31, 24},
{"BB_cal_rxbb_gain_tbl_20", "txcal_rx_bb_gain_table_22"      , 0x0002a684, 23, 16},
{"BB_cal_rxbb_gain_tbl_20", "txcal_rx_bb_gain_table_21"      , 0x0002a684, 15, 8 },
{"BB_cal_rxbb_gain_tbl_20", "txcal_rx_bb_gain_table_20"      , 0x0002a684, 7 , 0 },
{"BB_cal_rxbb_gain_tbl_24", "txcal_rx_bb_gain_table_24"      , 0x0002a688, 7 , 0 },
{"BB_txiqcal_status_b0", "last_meas_addr_0"                  , 0x0002a68c, 23, 18},
{"BB_txiqcal_status_b0", "rx_gain_used_0"                    , 0x0002a68c, 17, 12},
{"BB_txiqcal_status_b0", "tone_gain_used_0"                  , 0x0002a68c, 11, 6 },
{"BB_txiqcal_status_b0", "calibrated_gains_0"                , 0x0002a68c, 5 , 1 },
{"BB_txiqcal_status_b0", "txiqcal_failed_0"                  , 0x0002a68c, 0 , 0 },
{"BB_paprd_trainer_cntl1", "cf_paprd_forced_fine_idx"        , 0x0002a690, 26, 25},
{"BB_paprd_trainer_cntl1", "cf_paprd_forced_coarse_idx"      , 0x0002a690, 24, 20},
{"BB_paprd_trainer_cntl1", "cf_paprd_corr_force"             , 0x0002a690, 19, 19},
{"BB_paprd_trainer_cntl1", "cf_paprd_lb_skip"                , 0x0002a690, 18, 12},
{"BB_paprd_trainer_cntl1", "cf_paprd_lb_enable"              , 0x0002a690, 11, 11},
{"BB_paprd_trainer_cntl1", "cf_paprd_tx_gain_force"          , 0x0002a690, 10, 10},
{"BB_paprd_trainer_cntl1", "cf_paprd_rx_bb_gain_force"       , 0x0002a690, 9 , 9 },
{"BB_paprd_trainer_cntl1", "cf_paprd_iqcorr_enable"          , 0x0002a690, 8 , 8 },
{"BB_paprd_trainer_cntl1", "cf_paprd_agc2_settling"          , 0x0002a690, 7 , 1 },
{"BB_paprd_trainer_cntl1", "cf_paprd_train_enable"           , 0x0002a690, 0 , 0 },
{"BB_paprd_trainer_cntl2", "cf_paprd_init_rx_bb_gain"        , 0x0002a694, 31, 0 },
{"BB_paprd_trainer_cntl3", "cf_paprd_bbtxmix_disable"        , 0x0002a698, 29, 29},
{"BB_paprd_trainer_cntl3", "cf_paprd_reuse_corr"             , 0x0002a698, 28, 28},
{"BB_paprd_trainer_cntl3", "cf_paprd_fine_corr_len"          , 0x0002a698, 27, 24},
{"BB_paprd_trainer_cntl3", "cf_paprd_coarse_corr_len"        , 0x0002a698, 23, 20},
{"BB_paprd_trainer_cntl3", "cf_paprd_num_corr_stages"        , 0x0002a698, 19, 17},
{"BB_paprd_trainer_cntl3", "cf_paprd_min_loopback_del"       , 0x0002a698, 16, 12},
{"BB_paprd_trainer_cntl3", "cf_paprd_quick_drop"             , 0x0002a698, 11, 6 },
{"BB_paprd_trainer_cntl3", "cf_paprd_adc_desired_size"       , 0x0002a698, 5 , 0 },
{"BB_paprd_trainer_cntl4", "cf_paprd_num_train_samples"      , 0x0002a69c, 25, 16},
{"BB_paprd_trainer_cntl4", "cf_paprd_safety_delta"           , 0x0002a69c, 15, 12},
{"BB_paprd_trainer_cntl4", "cf_paprd_min_corr"               , 0x0002a69c, 11, 0 },
{"BB_paprd_trainer_stat1", "paprd_agc2_pwr"                  , 0x0002a6a0, 16, 9 },
{"BB_paprd_trainer_stat1", "paprd_rx_gain_idx"               , 0x0002a6a0, 8 , 4 },
{"BB_paprd_trainer_stat1", "paprd_train_active"              , 0x0002a6a0, 3 , 3 },
{"BB_paprd_trainer_stat1", "paprd_corr_err"                  , 0x0002a6a0, 2 , 2 },
{"BB_paprd_trainer_stat1", "paprd_train_incomplete"          , 0x0002a6a0, 1 , 1 },
{"BB_paprd_trainer_stat1", "paprd_train_done"                , 0x0002a6a0, 0 , 0 },
{"BB_paprd_trainer_stat2", "paprd_fine_idx"                  , 0x0002a6a4, 22, 21},
{"BB_paprd_trainer_stat2", "paprd_coarse_idx"                , 0x0002a6a4, 20, 16},
{"BB_paprd_trainer_stat2", "paprd_fine_val"                  , 0x0002a6a4, 15, 0 },
{"BB_paprd_trainer_stat3", "paprd_train_samples_cnt"         , 0x0002a6a8, 19, 0 },
{"BB_rxiqcal_status_b0", "rxiqcal_last_meas_addr_0"          , 0x0002a6ac, 16, 11},
{"BB_rxiqcal_status_b0", "rxiqcal_txgain_idx_used_0"         , 0x0002a6ac, 10, 6 },
{"BB_rxiqcal_status_b0", "rxiqcal_calibrated_gains_0"        , 0x0002a6ac, 5 , 1 },
{"BB_rxiqcal_status_b0", "rxiqcal_failed_0"                  , 0x0002a6ac, 0 , 0 },
{"BB_aic_ctrl_0_b0", "aic_mon_enable_0"                      , 0x0002a6b0, 31, 31},
{"BB_aic_ctrl_0_b0", "aic_cal_max_hop_count"                 , 0x0002a6b0, 30, 24},
{"BB_aic_ctrl_0_b0", "aic_cal_min_valid_count"               , 0x0002a6b0, 23, 17},
{"BB_aic_ctrl_0_b0", "aic_f_wlan"                            , 0x0002a6b0, 16, 10},
{"BB_aic_ctrl_0_b0", "aic_cal_ch_valid_reset_0"              , 0x0002a6b0, 9 , 9 },
{"BB_aic_ctrl_0_b0", "aic_cal_enable_0"                      , 0x0002a6b0, 8 , 8 },
{"BB_aic_ctrl_0_b0", "aic_bttx_pwr_thr_0"                    , 0x0002a6b0, 7 , 1 },
{"BB_aic_ctrl_0_b0", "aic_enable_0"                          , 0x0002a6b0, 0 , 0 },
{"BB_aic_ctrl_1_b0", "aic_cal_bt_ref_delay"                  , 0x0002a6b4, 23, 20},
{"BB_aic_ctrl_1_b0", "aic_bt_idle_cfg"                       , 0x0002a6b4, 19, 19},
{"BB_aic_ctrl_1_b0", "aic_stdby_cond"                        , 0x0002a6b4, 18, 17},
{"BB_aic_ctrl_1_b0", "aic_stdby_rot_att_db"                  , 0x0002a6b4, 16, 11},
{"BB_aic_ctrl_1_b0", "aic_stdby_com_att_6db"                 , 0x0002a6b4, 10, 8 },
{"BB_aic_ctrl_1_b0", "aic_rssi_max_0"                        , 0x0002a6b4, 7 , 4 },
{"BB_aic_ctrl_1_b0", "aic_rssi_min_0"                        , 0x0002a6b4, 3 , 0 },
{"BB_aic_ctrl_2_b0", "aic_radio_delay"                       , 0x0002a6b8, 30, 24},
{"BB_aic_ctrl_2_b0", "aic_cal_step_size_corr"                , 0x0002a6b8, 23, 20},
{"BB_aic_ctrl_2_b0", "aic_cal_rot_idx_corr"                  , 0x0002a6b8, 19, 15},
{"BB_aic_ctrl_2_b0", "aic_cal_conv_check_factor"             , 0x0002a6b8, 14, 13},
{"BB_aic_ctrl_2_b0", "aic_cal_rot_idx_count_max"             , 0x0002a6b8, 12, 10},
{"BB_aic_ctrl_2_b0", "aic_cal_synth_toggle"                  , 0x0002a6b8, 9 , 9 },
{"BB_aic_ctrl_2_b0", "aic_cal_synth_after_btrx"              , 0x0002a6b8, 8 , 8 },
{"BB_aic_ctrl_2_b0", "aic_cal_synth_settling"                , 0x0002a6b8, 7 , 0 },
{"BB_aic_ctrl_3_b0", "aic_mon_max_hop_count"                 , 0x0002a6bc, 26, 20},
{"BB_aic_ctrl_3_b0", "aic_mon_min_stale_count"               , 0x0002a6bc, 19, 13},
{"BB_aic_ctrl_3_b0", "aic_mon_pwr_est_long"                  , 0x0002a6bc, 12, 12},
{"BB_aic_ctrl_3_b0", "aic_mon_pd_tally_scaling"              , 0x0002a6bc, 11, 10},
{"BB_aic_ctrl_3_b0", "aic_mon_perf_thr"                      , 0x0002a6bc, 9 , 5 },
{"BB_aic_ctrl_3_b0", "aic_cal_target_mag_setting"            , 0x0002a6bc, 4 , 3 },
{"BB_aic_ctrl_3_b0", "aic_cal_perf_check_factor"             , 0x0002a6bc, 2 , 1 },
{"BB_aic_ctrl_3_b0", "aic_cal_pwr_est_long"                  , 0x0002a6bc, 0 , 0 },
{"BB_aic_ctrl_4_b0", "aic_cal_rot_att_db_est_iso_0"          , 0x0002a6c0, 15, 13},
{"BB_aic_ctrl_4_b0", "aic_cal_com_att_db_est_iso_0"          , 0x0002a6c0, 12, 9 },
{"BB_aic_ctrl_4_b0", "aic_cal_iso_est_init_setting_0"        , 0x0002a6c0, 8 , 3 },
{"BB_aic_ctrl_4_b0", "aic_cal_com_att_db_backoff_0"          , 0x0002a6c0, 2 , 1 },
{"BB_aic_ctrl_4_b0", "aic_cal_com_att_db_fixed_0"            , 0x0002a6c0, 0 , 0 },
{"BB_aic_stat_0_b0", "aic_meas_count_0"                      , 0x0002a6c4, 29, 24},
{"BB_aic_stat_0_b0", "aic_cal_ant_iso_est_0"                 , 0x0002a6c4, 23, 18},
{"BB_aic_stat_0_b0", "aic_cal_hop_count_0"                   , 0x0002a6c4, 17, 11},
{"BB_aic_stat_0_b0", "aic_cal_valid_count_0"                 , 0x0002a6c4, 10, 4 },
{"BB_aic_stat_0_b0", "aic_cal_bt_too_weak_err_0"             , 0x0002a6c4, 3 , 3 },
{"BB_aic_stat_0_b0", "aic_cal_bt_too_strong_err_0"           , 0x0002a6c4, 2 , 2 },
{"BB_aic_stat_0_b0", "aic_cal_done_0"                        , 0x0002a6c4, 1 , 1 },
{"BB_aic_stat_0_b0", "aic_cal_active_0"                      , 0x0002a6c4, 0 , 0 },
{"BB_aic_stat_1_b0", "aic_meas_mag_min_0"                    , 0x0002a6c8, 23, 14},
{"BB_aic_stat_1_b0", "aic_chunk_count_0"                     , 0x0002a6c8, 13, 8 },
{"BB_aic_stat_1_b0", "r_cal_aic_sm_0"                        , 0x0002a6c8, 7 , 3 },
{"BB_aic_stat_1_b0", "r_aic_sm_0"                            , 0x0002a6c8, 2 , 0 },
{"BB_aic_stat_2_b0", "r_mon_aic_sm_0"                        , 0x0002a6cc, 25, 23},
{"BB_aic_stat_2_b0", "aic_mon_est_pwr_ratio_0"               , 0x0002a6cc, 22, 16},
{"BB_aic_stat_2_b0", "aic_mon_stale_count_0"                 , 0x0002a6cc, 15, 9 },
{"BB_aic_stat_2_b0", "aic_mon_hop_count_0"                   , 0x0002a6cc, 8 , 2 },
{"BB_aic_stat_2_b0", "aic_mon_done_0"                        , 0x0002a6cc, 1 , 1 },
{"BB_aic_stat_2_b0", "aic_mon_active_0"                      , 0x0002a6cc, 0 , 0 },
{"BB_hsprd_train_cntl_0", "cf_cal_xpa"                       , 0x0002a6d0, 4 , 4 },
{"BB_rxiqcal_control_0", "enable_rxiq_calibrate"             , 0x0002a700, 31, 31},
{"BB_rxiqcal_control_0", "rxcal_tx_gain_init_db"             , 0x0002a700, 29, 24},
{"BB_rxiqcal_control_0", "rxcal_tx_gain_max_db"              , 0x0002a700, 23, 18},
{"BB_rxiqcal_control_0", "rxcal_tx_gain_min_db"              , 0x0002a700, 17, 12},
{"BB_rxiqcal_control_0", "rxcal_max_rx_gain"                 , 0x0002a700, 11, 8 },
{"BB_rxiqcal_control_0", "rxcal_min_rx_gain"                 , 0x0002a700, 7 , 4 },
{"BB_rxiqcal_control_0", "rxcal_loopback_mode"               , 0x0002a700, 3 , 3 },
{"BB_dbg_mask_agc", "debug_mux_ena"                          , 0x0002a710, 31, 31},
{"BB_dbg_mask_agc", "dbg_bus_agc_sel_B"                      , 0x0002a710, 30, 28},
{"BB_dbg_mask_agc", "dbg_bus_agc_sel_A"                      , 0x0002a710, 26, 24},
{"BB_dbg_mask_agc", "dbg_mask_agc"                           , 0x0002a710, 23, 0 },
{"BB_dbg_mask_txsm", "dbg_bus_rxsm_sel_B"                    , 0x0002a714, 30, 28},
{"BB_dbg_mask_txsm", "dbg_bus_rxsm_sel_A"                    , 0x0002a714, 26, 24},
{"BB_dbg_mask_txsm", "dbg_mask_rxsm"                         , 0x0002a714, 23, 0 },
{"BB_dbg_mask_rxsm", "dbg_mask_txsm"                         , 0x0002a718, 23, 0 },
{"BB_dbg_mask_tctl", "dbg_mask_tctl"                         , 0x0002a71c, 23, 0 },
{"BB_dbg_mask_vit", "dbg_mask_vit"                           , 0x0002a720, 23, 0 },
{"BB_dbg_mask_dfs", "dbg_bus_dfs_sel_B"                      , 0x0002a724, 30, 28},
{"BB_dbg_mask_dfs", "dbg_bus_dfs_sel_A"                      , 0x0002a724, 26, 24},
{"BB_dbg_mask_dfs", "dbg_mask_dfs"                           , 0x0002a724, 23, 0 },
{"BB_dbg_mask_cal", "dbg_mask_cal"                           , 0x0002a728, 23, 0 },
{"BB_dbg_mask_svd", "dbg_mask_svd"                           , 0x0002a72c, 23, 0 },
{"BB_watchdog_status", "watchdog_status_8"                   , 0x0002a7c0, 31, 28},
{"BB_watchdog_status", "watchdog_status_7"                   , 0x0002a7c0, 27, 24},
{"BB_watchdog_status", "watchdog_status_6"                   , 0x0002a7c0, 23, 20},
{"BB_watchdog_status", "watchdog_status_5"                   , 0x0002a7c0, 19, 16},
{"BB_watchdog_status", "watchdog_status_4"                   , 0x0002a7c0, 15, 12},
{"BB_watchdog_status", "watchdog_status_3"                   , 0x0002a7c0, 11, 8 },
{"BB_watchdog_status", "watchdog_status_2"                   , 0x0002a7c0, 7 , 4 },
{"BB_watchdog_status", "watchdog_timeout"                    , 0x0002a7c0, 3 , 3 },
{"BB_watchdog_status", "watchdog_status_1"                   , 0x0002a7c0, 2 , 0 },
{"BB_watchdog_ctrl_1", "watchdog_timeout_reset_idle_limit"   , 0x0002a7c4, 31, 16},
{"BB_watchdog_ctrl_1", "watchdog_timeout_reset_non_idle_limit", 0x0002a7c4, 15, 2 },
{"BB_watchdog_ctrl_1", "enable_watchdog_timeout_reset_idle"  , 0x0002a7c4, 1 , 1 },
{"BB_watchdog_ctrl_1", "enable_watchdog_timeout_reset_non_idle", 0x0002a7c4, 0 , 0 },
{"BB_watchdog_ctrl_2", "enable_watchdog_radar_arb"           , 0x0002a7c8, 10, 10},
{"BB_watchdog_ctrl_2", "enable_watchdog_sscan"               , 0x0002a7c8, 9 , 9 },
{"BB_watchdog_ctrl_2", "enable_watchdog_radar"               , 0x0002a7c8, 8 , 8 },
{"BB_watchdog_ctrl_2", "sw_abort_active"                     , 0x0002a7c8, 3 , 3 },
{"BB_watchdog_ctrl_2", "watchdog_irq_ena"                    , 0x0002a7c8, 2 , 2 },
{"BB_watchdog_ctrl_2", "watchdog_timeout_reset_ena"          , 0x0002a7c8, 1 , 1 },
{"BB_watchdog_ctrl_2", "force_fast_adc_clk"                  , 0x0002a7c8, 0 , 0 },
{"BB_bluetooth_cntl", "bt_ant_halt_wlan"                     , 0x0002a7cc, 1 , 1 },
{"BB_bluetooth_cntl", "bt_break_cck_en"                      , 0x0002a7cc, 0 , 0 },
{"BB_phyonly_control", "en_low_freq_sleep"                   , 0x0002a7d4, 7 , 7 },
{"BB_phyonly_control", "static_rx_antenna"                   , 0x0002a7d4, 6 , 6 },
{"BB_phyonly_control", "rx_antenna_select"                   , 0x0002a7d4, 5 , 5 },
{"BB_phyonly_control", "static_tx_antenna"                   , 0x0002a7d4, 4 , 4 },
{"BB_phyonly_control", "tx_antenna_select"                   , 0x0002a7d4, 3 , 3 },
{"BB_phyonly_control", "generate_scrambler"                  , 0x0002a7d4, 2 , 2 },
{"BB_phyonly_control", "late_tx_signal_symbol"               , 0x0002a7d4, 1 , 1 },
{"BB_phyonly_control", "rx_drain_rate"                       , 0x0002a7d4, 0 , 0 },
{"BB_eco_ctrl", "eco_ctrl"                                   , 0x0002a7dc, 31, 0 },
{"BB_watchdog_status_B", "watchdog_status_B_reserved"        , 0x0002a7e0, 31, 26},
{"BB_watchdog_status_B", "watchdog_status_B_srchfft_pwr_sm"  , 0x0002a7e0, 25, 24},
{"BB_watchdog_status_B", "watchdog_status_B_srchfft_bw_sm"   , 0x0002a7e0, 23, 20},
{"BB_watchdog_status_B", "watchdog_status_B_srchfft_out_sm"  , 0x0002a7e0, 19, 18},
{"BB_watchdog_status_B", "watchdog_status_B_srchfft_in_sm"   , 0x0002a7e0, 17, 16},
{"BB_watchdog_status_B", "watchdog_status_B_srchfft_sem_lock", 0x0002a7e0, 15, 12},
{"BB_watchdog_status_B", "watchdog_status_B_sscan_sm"        , 0x0002a7e0, 11, 8 },
{"BB_watchdog_status_B", "watchdog_status_B_radar_sm"        , 0x0002a7e0, 7 , 4 },
{"BB_watchdog_status_B", "watchdog_status_B_hang_flags"      , 0x0002a7e0, 3 , 0 },
{"BB_tables_intf_addr_b0", "addr_auto_incr_0"                , 0x0002a7f0, 31, 31},
{"BB_tables_intf_addr_b0", "tables_addr_0"                   , 0x0002a7f0, 17, 2 },
{"BB_tables_intf_data_b0", "tables_data_0"                   , 0x0002a7f4, 31, 0 },
{"BB_pre_emphasis_bw20_b1", "pre_emp_db_neg_bw20_1"          , 0x0002a888, 29, 15},
{"BB_pre_emphasis_bw20_b1", "pre_emp_db_pos_bw20_1"          , 0x0002a888, 14, 0 },
{"BB_pre_emphasis_bw40_b1", "pre_emp_db_neg_bw40_1"          , 0x0002a88c, 29, 15},
{"BB_pre_emphasis_bw40_b1", "pre_emp_db_pos_bw40_1"          , 0x0002a88c, 14, 0 },
{"BB_pre_emphasis_bw80_b1", "pre_emp_db_neg_bw80_1"          , 0x0002a890, 29, 15},
{"BB_pre_emphasis_bw80_b1", "pre_emp_db_pos_bw80_1"          , 0x0002a890, 14, 0 },
{"BB_spur_report_b1", "power_with_spur_removed_1"            , 0x0002a8a8, 31, 16},
{"BB_spur_report_b1", "spur_est_q_1"                         , 0x0002a8a8, 15, 8 },
{"BB_spur_report_b1", "spur_est_i_1"                         , 0x0002a8a8, 7 , 0 },
{"BB_iq_adc_meas_0_b1", "gain_dc_iq_cal_meas_0_1"            , 0x0002a8c0, 31, 0 },
{"BB_iq_adc_meas_1_b1", "gain_dc_iq_cal_meas_1_1"            , 0x0002a8c4, 31, 0 },
{"BB_iq_adc_meas_2_b1", "gain_dc_iq_cal_meas_2_1"            , 0x0002a8c8, 31, 0 },
{"BB_iq_adc_meas_3_b1", "gain_dc_iq_cal_meas_3_1"            , 0x0002a8cc, 31, 0 },
{"BB_tx_phase_ramp_b1", "cf_phase_ramp_alpha_1"              , 0x0002a8d0, 24, 17},
{"BB_tx_phase_ramp_b1", "cf_phase_ramp_init_1"               , 0x0002a8d0, 16, 7 },
{"BB_tx_phase_ramp_b1", "cf_phase_ramp_bias_1"               , 0x0002a8d0, 6 , 1 },
{"BB_tx_phase_ramp_b1", "cf_phase_ramp_enable_1"             , 0x0002a8d0, 0 , 0 },
{"BB_adc_gain_dc_corr_b1", "adc_dc_corr_i_coeff_1"           , 0x0002a8d4, 29, 21},
{"BB_adc_gain_dc_corr_b1", "adc_dc_corr_q_coeff_1"           , 0x0002a8d4, 20, 12},
{"BB_adc_gain_dc_corr_b1", "adc_gain_corr_i_coeff_1"         , 0x0002a8d4, 11, 6 },
{"BB_adc_gain_dc_corr_b1", "adc_gain_corr_q_coeff_1"         , 0x0002a8d4, 5 , 0 },
{"BB_rx_iq_corr_loopback_b1", "loopback_iqcorr_q_i_coff_1"   , 0x0002a8e0, 17, 9 },
{"BB_rx_iq_corr_loopback_b1", "loopback_iqcorr_q_q_coff_1"   , 0x0002a8e0, 8 , 0 },
{"BB_paprd_ctrl0_b1", "paprd_mag_thrsh_1"                    , 0x0002a8f0, 31, 27},
{"BB_paprd_ctrl0_b1", "paprd_valid_gain_1"                   , 0x0002a8f0, 26, 2 },
{"BB_paprd_ctrl0_b1", "paprd_adaptive_use_single_table_1"    , 0x0002a8f0, 1 , 1 },
{"BB_paprd_ctrl0_b1", "paprd_enable_1"                       , 0x0002a8f0, 0 , 0 },
{"BB_paprd_ctrl1_b1", "paprd_trainer_iandq_sel_1"            , 0x0002a8f4, 27, 27},
{"BB_paprd_ctrl1_b1", "paprd_mag_scale_factor_1"             , 0x0002a8f4, 26, 17},
{"BB_paprd_ctrl1_b1", "pa_gain_scale_factor_1"               , 0x0002a8f4, 16, 9 },
{"BB_paprd_ctrl1_b1", "paprd_power_at_am2am_cal_1"           , 0x0002a8f4, 8 , 3 },
{"BB_paprd_ctrl1_b1", "paprd_adaptive_am2pm_enable_1"        , 0x0002a8f4, 2 , 2 },
{"BB_paprd_ctrl1_b1", "paprd_adaptive_am2am_enable_1"        , 0x0002a8f4, 1 , 1 },
{"BB_paprd_ctrl1_b1", "paprd_adaptive_scaling_enable_1"      , 0x0002a8f4, 0 , 0 },
{"BB_pa_gain123_b1", "pa_gain3_1"                            , 0x0002a8f8, 29, 20},
{"BB_pa_gain123_b1", "pa_gain2_1"                            , 0x0002a8f8, 19, 10},
{"BB_pa_gain123_b1", "pa_gain1_1"                            , 0x0002a8f8, 9 , 0 },
{"BB_pa_gain45_b1", "paprd_adaptive_table_valid_1"           , 0x0002a8fc, 24, 20},
{"BB_pa_gain45_b1", "pa_gain5_1"                             , 0x0002a8fc, 19, 10},
{"BB_pa_gain45_b1", "pa_gain4_1"                             , 0x0002a8fc, 9 , 0 },
{"BB_paprd_mem_tab_b1[0]", "paprd_mem"                       , 0x0002a920, 21, 0 },
{"BB_paprd_mem_tab_b1[1]", "paprd_mem"                       , 0x0002a924, 21, 0 },
{"BB_paprd_mem_tab_b1[2]", "paprd_mem"                       , 0x0002a928, 21, 0 },
{"BB_paprd_mem_tab_b1[3]", "paprd_mem"                       , 0x0002a92c, 21, 0 },
{"BB_paprd_mem_tab_b1[4]", "paprd_mem"                       , 0x0002a930, 21, 0 },
{"BB_paprd_mem_tab_b1[5]", "paprd_mem"                       , 0x0002a934, 21, 0 },
{"BB_paprd_mem_tab_b1[6]", "paprd_mem"                       , 0x0002a938, 21, 0 },
{"BB_paprd_mem_tab_b1[7]", "paprd_mem"                       , 0x0002a93c, 21, 0 },
{"BB_paprd_mem_tab_b1[8]", "paprd_mem"                       , 0x0002a940, 21, 0 },
{"BB_paprd_mem_tab_b1[9]", "paprd_mem"                       , 0x0002a944, 21, 0 },
{"BB_paprd_mem_tab_b1[10]", "paprd_mem"                      , 0x0002a948, 21, 0 },
{"BB_paprd_mem_tab_b1[11]", "paprd_mem"                      , 0x0002a94c, 21, 0 },
{"BB_paprd_mem_tab_b1[12]", "paprd_mem"                      , 0x0002a950, 21, 0 },
{"BB_paprd_mem_tab_b1[13]", "paprd_mem"                      , 0x0002a954, 21, 0 },
{"BB_paprd_mem_tab_b1[14]", "paprd_mem"                      , 0x0002a958, 21, 0 },
{"BB_paprd_mem_tab_b1[15]", "paprd_mem"                      , 0x0002a95c, 21, 0 },
{"BB_paprd_mem_tab_b1[16]", "paprd_mem"                      , 0x0002a960, 21, 0 },
{"BB_paprd_mem_tab_b1[17]", "paprd_mem"                      , 0x0002a964, 21, 0 },
{"BB_paprd_mem_tab_b1[18]", "paprd_mem"                      , 0x0002a968, 21, 0 },
{"BB_paprd_mem_tab_b1[19]", "paprd_mem"                      , 0x0002a96c, 21, 0 },
{"BB_paprd_mem_tab_b1[20]", "paprd_mem"                      , 0x0002a970, 21, 0 },
{"BB_paprd_mem_tab_b1[21]", "paprd_mem"                      , 0x0002a974, 21, 0 },
{"BB_paprd_mem_tab_b1[22]", "paprd_mem"                      , 0x0002a978, 21, 0 },
{"BB_paprd_mem_tab_b1[23]", "paprd_mem"                      , 0x0002a97c, 21, 0 },
{"BB_paprd_mem_tab_b1[24]", "paprd_mem"                      , 0x0002a980, 21, 0 },
{"BB_paprd_mem_tab_b1[25]", "paprd_mem"                      , 0x0002a984, 21, 0 },
{"BB_paprd_mem_tab_b1[26]", "paprd_mem"                      , 0x0002a988, 21, 0 },
{"BB_paprd_mem_tab_b1[27]", "paprd_mem"                      , 0x0002a98c, 21, 0 },
{"BB_paprd_mem_tab_b1[28]", "paprd_mem"                      , 0x0002a990, 21, 0 },
{"BB_paprd_mem_tab_b1[29]", "paprd_mem"                      , 0x0002a994, 21, 0 },
{"BB_paprd_mem_tab_b1[30]", "paprd_mem"                      , 0x0002a998, 21, 0 },
{"BB_paprd_mem_tab_b1[31]", "paprd_mem"                      , 0x0002a99c, 21, 0 },
{"BB_paprd_mem_tab_b1[32]", "paprd_mem"                      , 0x0002a9a0, 21, 0 },
{"BB_paprd_mem_tab_b1[33]", "paprd_mem"                      , 0x0002a9a4, 21, 0 },
{"BB_paprd_mem_tab_b1[34]", "paprd_mem"                      , 0x0002a9a8, 21, 0 },
{"BB_paprd_mem_tab_b1[35]", "paprd_mem"                      , 0x0002a9ac, 21, 0 },
{"BB_paprd_mem_tab_b1[36]", "paprd_mem"                      , 0x0002a9b0, 21, 0 },
{"BB_paprd_mem_tab_b1[37]", "paprd_mem"                      , 0x0002a9b4, 21, 0 },
{"BB_paprd_mem_tab_b1[38]", "paprd_mem"                      , 0x0002a9b8, 21, 0 },
{"BB_paprd_mem_tab_b1[39]", "paprd_mem"                      , 0x0002a9bc, 21, 0 },
{"BB_paprd_mem_tab_b1[40]", "paprd_mem"                      , 0x0002a9c0, 21, 0 },
{"BB_paprd_mem_tab_b1[41]", "paprd_mem"                      , 0x0002a9c4, 21, 0 },
{"BB_paprd_mem_tab_b1[42]", "paprd_mem"                      , 0x0002a9c8, 21, 0 },
{"BB_paprd_mem_tab_b1[43]", "paprd_mem"                      , 0x0002a9cc, 21, 0 },
{"BB_paprd_mem_tab_b1[44]", "paprd_mem"                      , 0x0002a9d0, 21, 0 },
{"BB_paprd_mem_tab_b1[45]", "paprd_mem"                      , 0x0002a9d4, 21, 0 },
{"BB_paprd_mem_tab_b1[46]", "paprd_mem"                      , 0x0002a9d8, 21, 0 },
{"BB_paprd_mem_tab_b1[47]", "paprd_mem"                      , 0x0002a9dc, 21, 0 },
{"BB_paprd_mem_tab_b1[48]", "paprd_mem"                      , 0x0002a9e0, 21, 0 },
{"BB_paprd_mem_tab_b1[49]", "paprd_mem"                      , 0x0002a9e4, 21, 0 },
{"BB_paprd_mem_tab_b1[50]", "paprd_mem"                      , 0x0002a9e8, 21, 0 },
{"BB_paprd_mem_tab_b1[51]", "paprd_mem"                      , 0x0002a9ec, 21, 0 },
{"BB_paprd_mem_tab_b1[52]", "paprd_mem"                      , 0x0002a9f0, 21, 0 },
{"BB_paprd_mem_tab_b1[53]", "paprd_mem"                      , 0x0002a9f4, 21, 0 },
{"BB_paprd_mem_tab_b1[54]", "paprd_mem"                      , 0x0002a9f8, 21, 0 },
{"BB_paprd_mem_tab_b1[55]", "paprd_mem"                      , 0x0002a9fc, 21, 0 },
{"BB_paprd_mem_tab_b1[56]", "paprd_mem"                      , 0x0002aa00, 21, 0 },
{"BB_paprd_mem_tab_b1[57]", "paprd_mem"                      , 0x0002aa04, 21, 0 },
{"BB_paprd_mem_tab_b1[58]", "paprd_mem"                      , 0x0002aa08, 21, 0 },
{"BB_paprd_mem_tab_b1[59]", "paprd_mem"                      , 0x0002aa0c, 21, 0 },
{"BB_paprd_mem_tab_b1[60]", "paprd_mem"                      , 0x0002aa10, 21, 0 },
{"BB_paprd_mem_tab_b1[61]", "paprd_mem"                      , 0x0002aa14, 21, 0 },
{"BB_paprd_mem_tab_b1[62]", "paprd_mem"                      , 0x0002aa18, 21, 0 },
{"BB_paprd_mem_tab_b1[63]", "paprd_mem"                      , 0x0002aa1c, 21, 0 },
{"BB_paprd_mem_tab_b1[64]", "paprd_mem"                      , 0x0002aa20, 21, 0 },
{"BB_paprd_mem_tab_b1[65]", "paprd_mem"                      , 0x0002aa24, 21, 0 },
{"BB_paprd_mem_tab_b1[66]", "paprd_mem"                      , 0x0002aa28, 21, 0 },
{"BB_paprd_mem_tab_b1[67]", "paprd_mem"                      , 0x0002aa2c, 21, 0 },
{"BB_paprd_mem_tab_b1[68]", "paprd_mem"                      , 0x0002aa30, 21, 0 },
{"BB_paprd_mem_tab_b1[69]", "paprd_mem"                      , 0x0002aa34, 21, 0 },
{"BB_paprd_mem_tab_b1[70]", "paprd_mem"                      , 0x0002aa38, 21, 0 },
{"BB_paprd_mem_tab_b1[71]", "paprd_mem"                      , 0x0002aa3c, 21, 0 },
{"BB_paprd_mem_tab_b1[72]", "paprd_mem"                      , 0x0002aa40, 21, 0 },
{"BB_paprd_mem_tab_b1[73]", "paprd_mem"                      , 0x0002aa44, 21, 0 },
{"BB_paprd_mem_tab_b1[74]", "paprd_mem"                      , 0x0002aa48, 21, 0 },
{"BB_paprd_mem_tab_b1[75]", "paprd_mem"                      , 0x0002aa4c, 21, 0 },
{"BB_paprd_mem_tab_b1[76]", "paprd_mem"                      , 0x0002aa50, 21, 0 },
{"BB_paprd_mem_tab_b1[77]", "paprd_mem"                      , 0x0002aa54, 21, 0 },
{"BB_paprd_mem_tab_b1[78]", "paprd_mem"                      , 0x0002aa58, 21, 0 },
{"BB_paprd_mem_tab_b1[79]", "paprd_mem"                      , 0x0002aa5c, 21, 0 },
{"BB_paprd_mem_tab_b1[80]", "paprd_mem"                      , 0x0002aa60, 21, 0 },
{"BB_paprd_mem_tab_b1[81]", "paprd_mem"                      , 0x0002aa64, 21, 0 },
{"BB_paprd_mem_tab_b1[82]", "paprd_mem"                      , 0x0002aa68, 21, 0 },
{"BB_paprd_mem_tab_b1[83]", "paprd_mem"                      , 0x0002aa6c, 21, 0 },
{"BB_paprd_mem_tab_b1[84]", "paprd_mem"                      , 0x0002aa70, 21, 0 },
{"BB_paprd_mem_tab_b1[85]", "paprd_mem"                      , 0x0002aa74, 21, 0 },
{"BB_paprd_mem_tab_b1[86]", "paprd_mem"                      , 0x0002aa78, 21, 0 },
{"BB_paprd_mem_tab_b1[87]", "paprd_mem"                      , 0x0002aa7c, 21, 0 },
{"BB_paprd_mem_tab_b1[88]", "paprd_mem"                      , 0x0002aa80, 21, 0 },
{"BB_paprd_mem_tab_b1[89]", "paprd_mem"                      , 0x0002aa84, 21, 0 },
{"BB_paprd_mem_tab_b1[90]", "paprd_mem"                      , 0x0002aa88, 21, 0 },
{"BB_paprd_mem_tab_b1[91]", "paprd_mem"                      , 0x0002aa8c, 21, 0 },
{"BB_paprd_mem_tab_b1[92]", "paprd_mem"                      , 0x0002aa90, 21, 0 },
{"BB_paprd_mem_tab_b1[93]", "paprd_mem"                      , 0x0002aa94, 21, 0 },
{"BB_paprd_mem_tab_b1[94]", "paprd_mem"                      , 0x0002aa98, 21, 0 },
{"BB_paprd_mem_tab_b1[95]", "paprd_mem"                      , 0x0002aa9c, 21, 0 },
{"BB_paprd_mem_tab_b1[96]", "paprd_mem"                      , 0x0002aaa0, 21, 0 },
{"BB_paprd_mem_tab_b1[97]", "paprd_mem"                      , 0x0002aaa4, 21, 0 },
{"BB_paprd_mem_tab_b1[98]", "paprd_mem"                      , 0x0002aaa8, 21, 0 },
{"BB_paprd_mem_tab_b1[99]", "paprd_mem"                      , 0x0002aaac, 21, 0 },
{"BB_paprd_mem_tab_b1[100]", "paprd_mem"                     , 0x0002aab0, 21, 0 },
{"BB_paprd_mem_tab_b1[101]", "paprd_mem"                     , 0x0002aab4, 21, 0 },
{"BB_paprd_mem_tab_b1[102]", "paprd_mem"                     , 0x0002aab8, 21, 0 },
{"BB_paprd_mem_tab_b1[103]", "paprd_mem"                     , 0x0002aabc, 21, 0 },
{"BB_paprd_mem_tab_b1[104]", "paprd_mem"                     , 0x0002aac0, 21, 0 },
{"BB_paprd_mem_tab_b1[105]", "paprd_mem"                     , 0x0002aac4, 21, 0 },
{"BB_paprd_mem_tab_b1[106]", "paprd_mem"                     , 0x0002aac8, 21, 0 },
{"BB_paprd_mem_tab_b1[107]", "paprd_mem"                     , 0x0002aacc, 21, 0 },
{"BB_paprd_mem_tab_b1[108]", "paprd_mem"                     , 0x0002aad0, 21, 0 },
{"BB_paprd_mem_tab_b1[109]", "paprd_mem"                     , 0x0002aad4, 21, 0 },
{"BB_paprd_mem_tab_b1[110]", "paprd_mem"                     , 0x0002aad8, 21, 0 },
{"BB_paprd_mem_tab_b1[111]", "paprd_mem"                     , 0x0002aadc, 21, 0 },
{"BB_paprd_mem_tab_b1[112]", "paprd_mem"                     , 0x0002aae0, 21, 0 },
{"BB_paprd_mem_tab_b1[113]", "paprd_mem"                     , 0x0002aae4, 21, 0 },
{"BB_paprd_mem_tab_b1[114]", "paprd_mem"                     , 0x0002aae8, 21, 0 },
{"BB_paprd_mem_tab_b1[115]", "paprd_mem"                     , 0x0002aaec, 21, 0 },
{"BB_paprd_mem_tab_b1[116]", "paprd_mem"                     , 0x0002aaf0, 21, 0 },
{"BB_paprd_mem_tab_b1[117]", "paprd_mem"                     , 0x0002aaf4, 21, 0 },
{"BB_paprd_mem_tab_b1[118]", "paprd_mem"                     , 0x0002aaf8, 21, 0 },
{"BB_paprd_mem_tab_b1[119]", "paprd_mem"                     , 0x0002aafc, 21, 0 },
{"BB_chan_info_chan_tab_b1[0]", "chaninfo_word"              , 0x0002ab00, 31, 0 },
{"BB_chan_info_chan_tab_b1[1]", "chaninfo_word"              , 0x0002ab04, 31, 0 },
{"BB_chan_info_chan_tab_b1[2]", "chaninfo_word"              , 0x0002ab08, 31, 0 },
{"BB_chan_info_chan_tab_b1[3]", "chaninfo_word"              , 0x0002ab0c, 31, 0 },
{"BB_chan_info_chan_tab_b1[4]", "chaninfo_word"              , 0x0002ab10, 31, 0 },
{"BB_chan_info_chan_tab_b1[5]", "chaninfo_word"              , 0x0002ab14, 31, 0 },
{"BB_chan_info_chan_tab_b1[6]", "chaninfo_word"              , 0x0002ab18, 31, 0 },
{"BB_chan_info_chan_tab_b1[7]", "chaninfo_word"              , 0x0002ab1c, 31, 0 },
{"BB_chan_info_chan_tab_b1[8]", "chaninfo_word"              , 0x0002ab20, 31, 0 },
{"BB_chan_info_chan_tab_b1[9]", "chaninfo_word"              , 0x0002ab24, 31, 0 },
{"BB_chan_info_chan_tab_b1[10]", "chaninfo_word"             , 0x0002ab28, 31, 0 },
{"BB_chan_info_chan_tab_b1[11]", "chaninfo_word"             , 0x0002ab2c, 31, 0 },
{"BB_chan_info_chan_tab_b1[12]", "chaninfo_word"             , 0x0002ab30, 31, 0 },
{"BB_chan_info_chan_tab_b1[13]", "chaninfo_word"             , 0x0002ab34, 31, 0 },
{"BB_chan_info_chan_tab_b1[14]", "chaninfo_word"             , 0x0002ab38, 31, 0 },
{"BB_chan_info_chan_tab_b1[15]", "chaninfo_word"             , 0x0002ab3c, 31, 0 },
{"BB_chan_info_chan_tab_b1[16]", "chaninfo_word"             , 0x0002ab40, 31, 0 },
{"BB_chan_info_chan_tab_b1[17]", "chaninfo_word"             , 0x0002ab44, 31, 0 },
{"BB_chan_info_chan_tab_b1[18]", "chaninfo_word"             , 0x0002ab48, 31, 0 },
{"BB_chan_info_chan_tab_b1[19]", "chaninfo_word"             , 0x0002ab4c, 31, 0 },
{"BB_chan_info_chan_tab_b1[20]", "chaninfo_word"             , 0x0002ab50, 31, 0 },
{"BB_chan_info_chan_tab_b1[21]", "chaninfo_word"             , 0x0002ab54, 31, 0 },
{"BB_chan_info_chan_tab_b1[22]", "chaninfo_word"             , 0x0002ab58, 31, 0 },
{"BB_chan_info_chan_tab_b1[23]", "chaninfo_word"             , 0x0002ab5c, 31, 0 },
{"BB_chan_info_chan_tab_b1[24]", "chaninfo_word"             , 0x0002ab60, 31, 0 },
{"BB_chan_info_chan_tab_b1[25]", "chaninfo_word"             , 0x0002ab64, 31, 0 },
{"BB_chan_info_chan_tab_b1[26]", "chaninfo_word"             , 0x0002ab68, 31, 0 },
{"BB_chan_info_chan_tab_b1[27]", "chaninfo_word"             , 0x0002ab6c, 31, 0 },
{"BB_chan_info_chan_tab_b1[28]", "chaninfo_word"             , 0x0002ab70, 31, 0 },
{"BB_chan_info_chan_tab_b1[29]", "chaninfo_word"             , 0x0002ab74, 31, 0 },
{"BB_chan_info_chan_tab_b1[30]", "chaninfo_word"             , 0x0002ab78, 31, 0 },
{"BB_chan_info_chan_tab_b1[31]", "chaninfo_word"             , 0x0002ab7c, 31, 0 },
{"BB_chan_info_chan_tab_b1[32]", "chaninfo_word"             , 0x0002ab80, 31, 0 },
{"BB_chan_info_chan_tab_b1[33]", "chaninfo_word"             , 0x0002ab84, 31, 0 },
{"BB_chan_info_chan_tab_b1[34]", "chaninfo_word"             , 0x0002ab88, 31, 0 },
{"BB_chan_info_chan_tab_b1[35]", "chaninfo_word"             , 0x0002ab8c, 31, 0 },
{"BB_chan_info_chan_tab_b1[36]", "chaninfo_word"             , 0x0002ab90, 31, 0 },
{"BB_chan_info_chan_tab_b1[37]", "chaninfo_word"             , 0x0002ab94, 31, 0 },
{"BB_chan_info_chan_tab_b1[38]", "chaninfo_word"             , 0x0002ab98, 31, 0 },
{"BB_chan_info_chan_tab_b1[39]", "chaninfo_word"             , 0x0002ab9c, 31, 0 },
{"BB_chan_info_chan_tab_b1[40]", "chaninfo_word"             , 0x0002aba0, 31, 0 },
{"BB_chan_info_chan_tab_b1[41]", "chaninfo_word"             , 0x0002aba4, 31, 0 },
{"BB_chan_info_chan_tab_b1[42]", "chaninfo_word"             , 0x0002aba8, 31, 0 },
{"BB_chan_info_chan_tab_b1[43]", "chaninfo_word"             , 0x0002abac, 31, 0 },
{"BB_chan_info_chan_tab_b1[44]", "chaninfo_word"             , 0x0002abb0, 31, 0 },
{"BB_chan_info_chan_tab_b1[45]", "chaninfo_word"             , 0x0002abb4, 31, 0 },
{"BB_chan_info_chan_tab_b1[46]", "chaninfo_word"             , 0x0002abb8, 31, 0 },
{"BB_chan_info_chan_tab_b1[47]", "chaninfo_word"             , 0x0002abbc, 31, 0 },
{"BB_chan_info_chan_tab_b1[48]", "chaninfo_word"             , 0x0002abc0, 31, 0 },
{"BB_chan_info_chan_tab_b1[49]", "chaninfo_word"             , 0x0002abc4, 31, 0 },
{"BB_chan_info_chan_tab_b1[50]", "chaninfo_word"             , 0x0002abc8, 31, 0 },
{"BB_chan_info_chan_tab_b1[51]", "chaninfo_word"             , 0x0002abcc, 31, 0 },
{"BB_chan_info_chan_tab_b1[52]", "chaninfo_word"             , 0x0002abd0, 31, 0 },
{"BB_chan_info_chan_tab_b1[53]", "chaninfo_word"             , 0x0002abd4, 31, 0 },
{"BB_chan_info_chan_tab_b1[54]", "chaninfo_word"             , 0x0002abd8, 31, 0 },
{"BB_chan_info_chan_tab_b1[55]", "chaninfo_word"             , 0x0002abdc, 31, 0 },
{"BB_chan_info_chan_tab_b1[56]", "chaninfo_word"             , 0x0002abe0, 31, 0 },
{"BB_chan_info_chan_tab_b1[57]", "chaninfo_word"             , 0x0002abe4, 31, 0 },
{"BB_chan_info_chan_tab_b1[58]", "chaninfo_word"             , 0x0002abe8, 31, 0 },
{"BB_chan_info_chan_tab_b1[59]", "chaninfo_word"             , 0x0002abec, 31, 0 },
{"BB_chn1_tables_intf_addr", "chn1_addr_auto_incr"           , 0x0002abf0, 31, 31},
{"BB_chn1_tables_intf_addr", "chn1_tables_addr"              , 0x0002abf0, 17, 2 },
{"BB_chn1_tables_intf_data", "chn1_tables_data"              , 0x0002abf4, 31, 0 },
{"BB_gain_force_max_gains_b1", "xatten2_hyst_margin_1"       , 0x0002ae04, 31, 25},
{"BB_gain_force_max_gains_b1", "xatten1_hyst_margin_1"       , 0x0002ae04, 24, 18},
{"BB_gain_force_max_gains_b1", "xatten2_sw_f_1"              , 0x0002ae04, 17, 17},
{"BB_gain_force_max_gains_b1", "xatten1_sw_f_1"              , 0x0002ae04, 16, 16},
{"BB_gain_force_max_gains_b1", "mb_gain_f_1"                 , 0x0002ae04, 15, 8 },
{"BB_gain_force_max_gains_b1", "rf_gain_f_1"                 , 0x0002ae04, 7 , 0 },
{"BB_ext_atten_switch_ctl_b1", "xlna_gain_db_1"              , 0x0002ae18, 26, 22},
{"BB_ext_atten_switch_ctl_b1", "xatten2_margin_1"            , 0x0002ae18, 21, 17},
{"BB_ext_atten_switch_ctl_b1", "xatten1_margin_1"            , 0x0002ae18, 16, 12},
{"BB_ext_atten_switch_ctl_b1", "xatten2_db_1"                , 0x0002ae18, 11, 6 },
{"BB_ext_atten_switch_ctl_b1", "xatten1_db_1"                , 0x0002ae18, 5 , 0 },
{"BB_cca_b1", "minCCApwr_1"                                  , 0x0002ae1c, 28, 20},
{"BB_cca_b1", "cf_maxCCApwr_1"                               , 0x0002ae1c, 8 , 0 },
{"BB_cca_ctrl_2_b1", "NF_gain_comp_1"                        , 0x0002ae20, 17, 10},
{"BB_cca_ctrl_2_b1", "minCCApwr_thr_1"                       , 0x0002ae20, 8 , 0 },
{"BB_rssi_b1", "rssi_ext80_1"                                , 0x0002af80, 31, 24},
{"BB_rssi_b1", "rssi_ext40_1"                                , 0x0002af80, 23, 16},
{"BB_rssi_b1", "rssi_ext20_1"                                , 0x0002af80, 15, 8 },
{"BB_rssi_b1", "rssi_pri20_1"                                , 0x0002af80, 7 , 0 },
{"BB_spur_est_cck_report_b1", "spur_est_q_1_cck"             , 0x0002af84, 31, 24},
{"BB_spur_est_cck_report_b1", "spur_est_i_1_cck"             , 0x0002af84, 23, 16},
{"BB_spur_est_cck_report_b1", "spur_est_sd_q_1_cck"          , 0x0002af84, 15, 8 },
{"BB_spur_est_cck_report_b1", "spur_est_sd_i_1_cck"          , 0x0002af84, 7 , 0 },
{"BB_agc_dig_dc_status_i_0_b1", "resdc_sw_write0_1"          , 0x0002af88, 30, 30},
{"BB_agc_dig_dc_status_i_0_b1", "dig_dc_mixer2_res_i_1"      , 0x0002af88, 29, 20},
{"BB_agc_dig_dc_status_i_0_b1", "dig_dc_mixer1_res_i_1"      , 0x0002af88, 19, 10},
{"BB_agc_dig_dc_status_i_0_b1", "dig_dc_mixer0_res_i_1"      , 0x0002af88, 9 , 0 },
{"BB_agc_dig_dc_status_i_1_b1", "resdc_sw_write1_1"          , 0x0002af8c, 30, 30},
{"BB_agc_dig_dc_status_i_1_b1", "dig_dc_mixer1_loopback_res_i_1", 0x0002af8c, 29, 20},
{"BB_agc_dig_dc_status_i_1_b1", "dig_dc_mixer0_loopback_res_i_1", 0x0002af8c, 19, 10},
{"BB_agc_dig_dc_status_i_1_b1", "dig_dc_mixer3_res_i_1"      , 0x0002af8c, 9 , 0 },
{"BB_agc_dig_dc_status_i_2_b1", "resdc_sw_write2_1"          , 0x0002af90, 30, 30},
{"BB_agc_dig_dc_status_i_2_b1", "dig_dc_mixer3_loopback_res_i_1", 0x0002af90, 19, 10},
{"BB_agc_dig_dc_status_i_2_b1", "dig_dc_mixer2_loopback_res_i_1", 0x0002af90, 9 , 0 },
{"BB_agc_dig_dc_status_q_0_b1", "resdc_sw_write3_1"          , 0x0002af94, 30, 30},
{"BB_agc_dig_dc_status_q_0_b1", "dig_dc_mixer2_res_q_1"      , 0x0002af94, 29, 20},
{"BB_agc_dig_dc_status_q_0_b1", "dig_dc_mixer1_res_q_1"      , 0x0002af94, 19, 10},
{"BB_agc_dig_dc_status_q_0_b1", "dig_dc_mixer0_res_q_1"      , 0x0002af94, 9 , 0 },
{"BB_agc_dig_dc_status_q_1_b1", "resdc_sw_write4_1"          , 0x0002af98, 30, 30},
{"BB_agc_dig_dc_status_q_1_b1", "dig_dc_mixer1_loopback_res_q_1", 0x0002af98, 29, 20},
{"BB_agc_dig_dc_status_q_1_b1", "dig_dc_mixer0_loopback_res_q_1", 0x0002af98, 19, 10},
{"BB_agc_dig_dc_status_q_1_b1", "dig_dc_mixer3_res_q_1"      , 0x0002af98, 9 , 0 },
{"BB_agc_dig_dc_status_q_2_b1", "resdc_sw_write5_1"          , 0x0002af9c, 30, 30},
{"BB_agc_dig_dc_status_q_2_b1", "dig_dc_mixer3_loopback_res_q_1", 0x0002af9c, 19, 10},
{"BB_agc_dig_dc_status_q_2_b1", "dig_dc_mixer2_loopback_res_q_1", 0x0002af9c, 9 , 0 },
{"BB_dc_cal_status_b1", "offsetC3Q_1"                        , 0x0002afa0, 29, 25},
{"BB_dc_cal_status_b1", "offsetC3I_1"                        , 0x0002afa0, 24, 20},
{"BB_dc_cal_status_b1", "offsetC2Q_1"                        , 0x0002afa0, 19, 15},
{"BB_dc_cal_status_b1", "offsetC2I_1"                        , 0x0002afa0, 14, 10},
{"BB_dc_cal_status_b1", "offsetC1Q_1"                        , 0x0002afa0, 9 , 5 },
{"BB_dc_cal_status_b1", "offsetC1I_1"                        , 0x0002afa0, 4 , 0 },
{"BB_rx_ocgain2[0]", "gain_entry2"                           , 0x0002b000, 31, 0 },
{"BB_rx_ocgain2[1]", "gain_entry2"                           , 0x0002b004, 31, 0 },
{"BB_rx_ocgain2[2]", "gain_entry2"                           , 0x0002b008, 31, 0 },
{"BB_rx_ocgain2[3]", "gain_entry2"                           , 0x0002b00c, 31, 0 },
{"BB_rx_ocgain2[4]", "gain_entry2"                           , 0x0002b010, 31, 0 },
{"BB_rx_ocgain2[5]", "gain_entry2"                           , 0x0002b014, 31, 0 },
{"BB_rx_ocgain2[6]", "gain_entry2"                           , 0x0002b018, 31, 0 },
{"BB_rx_ocgain2[7]", "gain_entry2"                           , 0x0002b01c, 31, 0 },
{"BB_rx_ocgain2[8]", "gain_entry2"                           , 0x0002b020, 31, 0 },
{"BB_rx_ocgain2[9]", "gain_entry2"                           , 0x0002b024, 31, 0 },
{"BB_rx_ocgain2[10]", "gain_entry2"                          , 0x0002b028, 31, 0 },
{"BB_rx_ocgain2[11]", "gain_entry2"                          , 0x0002b02c, 31, 0 },
{"BB_rx_ocgain2[12]", "gain_entry2"                          , 0x0002b030, 31, 0 },
{"BB_rx_ocgain2[13]", "gain_entry2"                          , 0x0002b034, 31, 0 },
{"BB_rx_ocgain2[14]", "gain_entry2"                          , 0x0002b038, 31, 0 },
{"BB_rx_ocgain2[15]", "gain_entry2"                          , 0x0002b03c, 31, 0 },
{"BB_rx_ocgain2[16]", "gain_entry2"                          , 0x0002b040, 31, 0 },
{"BB_rx_ocgain2[17]", "gain_entry2"                          , 0x0002b044, 31, 0 },
{"BB_rx_ocgain2[18]", "gain_entry2"                          , 0x0002b048, 31, 0 },
{"BB_rx_ocgain2[19]", "gain_entry2"                          , 0x0002b04c, 31, 0 },
{"BB_rx_ocgain2[20]", "gain_entry2"                          , 0x0002b050, 31, 0 },
{"BB_rx_ocgain2[21]", "gain_entry2"                          , 0x0002b054, 31, 0 },
{"BB_rx_ocgain2[22]", "gain_entry2"                          , 0x0002b058, 31, 0 },
{"BB_rx_ocgain2[23]", "gain_entry2"                          , 0x0002b05c, 31, 0 },
{"BB_rx_ocgain2[24]", "gain_entry2"                          , 0x0002b060, 31, 0 },
{"BB_rx_ocgain2[25]", "gain_entry2"                          , 0x0002b064, 31, 0 },
{"BB_rx_ocgain2[26]", "gain_entry2"                          , 0x0002b068, 31, 0 },
{"BB_rx_ocgain2[27]", "gain_entry2"                          , 0x0002b06c, 31, 0 },
{"BB_rx_ocgain2[28]", "gain_entry2"                          , 0x0002b070, 31, 0 },
{"BB_rx_ocgain2[29]", "gain_entry2"                          , 0x0002b074, 31, 0 },
{"BB_rx_ocgain2[30]", "gain_entry2"                          , 0x0002b078, 31, 0 },
{"BB_rx_ocgain2[31]", "gain_entry2"                          , 0x0002b07c, 31, 0 },
{"BB_rx_ocgain2[32]", "gain_entry2"                          , 0x0002b080, 31, 0 },
{"BB_rx_ocgain2[33]", "gain_entry2"                          , 0x0002b084, 31, 0 },
{"BB_rx_ocgain2[34]", "gain_entry2"                          , 0x0002b088, 31, 0 },
{"BB_rx_ocgain2[35]", "gain_entry2"                          , 0x0002b08c, 31, 0 },
{"BB_rx_ocgain2[36]", "gain_entry2"                          , 0x0002b090, 31, 0 },
{"BB_rx_ocgain2[37]", "gain_entry2"                          , 0x0002b094, 31, 0 },
{"BB_rx_ocgain2[38]", "gain_entry2"                          , 0x0002b098, 31, 0 },
{"BB_rx_ocgain2[39]", "gain_entry2"                          , 0x0002b09c, 31, 0 },
{"BB_rx_ocgain2[40]", "gain_entry2"                          , 0x0002b0a0, 31, 0 },
{"BB_rx_ocgain2[41]", "gain_entry2"                          , 0x0002b0a4, 31, 0 },
{"BB_rx_ocgain2[42]", "gain_entry2"                          , 0x0002b0a8, 31, 0 },
{"BB_rx_ocgain2[43]", "gain_entry2"                          , 0x0002b0ac, 31, 0 },
{"BB_rx_ocgain2[44]", "gain_entry2"                          , 0x0002b0b0, 31, 0 },
{"BB_rx_ocgain2[45]", "gain_entry2"                          , 0x0002b0b4, 31, 0 },
{"BB_rx_ocgain2[46]", "gain_entry2"                          , 0x0002b0b8, 31, 0 },
{"BB_rx_ocgain2[47]", "gain_entry2"                          , 0x0002b0bc, 31, 0 },
{"BB_rx_ocgain2[48]", "gain_entry2"                          , 0x0002b0c0, 31, 0 },
{"BB_rx_ocgain2[49]", "gain_entry2"                          , 0x0002b0c4, 31, 0 },
{"BB_rx_ocgain2[50]", "gain_entry2"                          , 0x0002b0c8, 31, 0 },
{"BB_rx_ocgain2[51]", "gain_entry2"                          , 0x0002b0cc, 31, 0 },
{"BB_rx_ocgain2[52]", "gain_entry2"                          , 0x0002b0d0, 31, 0 },
{"BB_rx_ocgain2[53]", "gain_entry2"                          , 0x0002b0d4, 31, 0 },
{"BB_rx_ocgain2[54]", "gain_entry2"                          , 0x0002b0d8, 31, 0 },
{"BB_rx_ocgain2[55]", "gain_entry2"                          , 0x0002b0dc, 31, 0 },
{"BB_rx_ocgain2[56]", "gain_entry2"                          , 0x0002b0e0, 31, 0 },
{"BB_rx_ocgain2[57]", "gain_entry2"                          , 0x0002b0e4, 31, 0 },
{"BB_rx_ocgain2[58]", "gain_entry2"                          , 0x0002b0e8, 31, 0 },
{"BB_rx_ocgain2[59]", "gain_entry2"                          , 0x0002b0ec, 31, 0 },
{"BB_rx_ocgain2[60]", "gain_entry2"                          , 0x0002b0f0, 31, 0 },
{"BB_rx_ocgain2[61]", "gain_entry2"                          , 0x0002b0f4, 31, 0 },
{"BB_rx_ocgain2[62]", "gain_entry2"                          , 0x0002b0f8, 31, 0 },
{"BB_rx_ocgain2[63]", "gain_entry2"                          , 0x0002b0fc, 31, 0 },
{"BB_rx_ocgain2[64]", "gain_entry2"                          , 0x0002b100, 31, 0 },
{"BB_rx_ocgain2[65]", "gain_entry2"                          , 0x0002b104, 31, 0 },
{"BB_rx_ocgain2[66]", "gain_entry2"                          , 0x0002b108, 31, 0 },
{"BB_rx_ocgain2[67]", "gain_entry2"                          , 0x0002b10c, 31, 0 },
{"BB_rx_ocgain2[68]", "gain_entry2"                          , 0x0002b110, 31, 0 },
{"BB_rx_ocgain2[69]", "gain_entry2"                          , 0x0002b114, 31, 0 },
{"BB_rx_ocgain2[70]", "gain_entry2"                          , 0x0002b118, 31, 0 },
{"BB_rx_ocgain2[71]", "gain_entry2"                          , 0x0002b11c, 31, 0 },
{"BB_rx_ocgain2[72]", "gain_entry2"                          , 0x0002b120, 31, 0 },
{"BB_rx_ocgain2[73]", "gain_entry2"                          , 0x0002b124, 31, 0 },
{"BB_rx_ocgain2[74]", "gain_entry2"                          , 0x0002b128, 31, 0 },
{"BB_rx_ocgain2[75]", "gain_entry2"                          , 0x0002b12c, 31, 0 },
{"BB_rx_ocgain2[76]", "gain_entry2"                          , 0x0002b130, 31, 0 },
{"BB_rx_ocgain2[77]", "gain_entry2"                          , 0x0002b134, 31, 0 },
{"BB_rx_ocgain2[78]", "gain_entry2"                          , 0x0002b138, 31, 0 },
{"BB_rx_ocgain2[79]", "gain_entry2"                          , 0x0002b13c, 31, 0 },
{"BB_rx_ocgain2[80]", "gain_entry2"                          , 0x0002b140, 31, 0 },
{"BB_rx_ocgain2[81]", "gain_entry2"                          , 0x0002b144, 31, 0 },
{"BB_rx_ocgain2[82]", "gain_entry2"                          , 0x0002b148, 31, 0 },
{"BB_rx_ocgain2[83]", "gain_entry2"                          , 0x0002b14c, 31, 0 },
{"BB_rx_ocgain2[84]", "gain_entry2"                          , 0x0002b150, 31, 0 },
{"BB_rx_ocgain2[85]", "gain_entry2"                          , 0x0002b154, 31, 0 },
{"BB_rx_ocgain2[86]", "gain_entry2"                          , 0x0002b158, 31, 0 },
{"BB_rx_ocgain2[87]", "gain_entry2"                          , 0x0002b15c, 31, 0 },
{"BB_rx_ocgain2[88]", "gain_entry2"                          , 0x0002b160, 31, 0 },
{"BB_rx_ocgain2[89]", "gain_entry2"                          , 0x0002b164, 31, 0 },
{"BB_rx_ocgain2[90]", "gain_entry2"                          , 0x0002b168, 31, 0 },
{"BB_rx_ocgain2[91]", "gain_entry2"                          , 0x0002b16c, 31, 0 },
{"BB_rx_ocgain2[92]", "gain_entry2"                          , 0x0002b170, 31, 0 },
{"BB_rx_ocgain2[93]", "gain_entry2"                          , 0x0002b174, 31, 0 },
{"BB_rx_ocgain2[94]", "gain_entry2"                          , 0x0002b178, 31, 0 },
{"BB_rx_ocgain2[95]", "gain_entry2"                          , 0x0002b17c, 31, 0 },
{"BB_rx_ocgain2[96]", "gain_entry2"                          , 0x0002b180, 31, 0 },
{"BB_rx_ocgain2[97]", "gain_entry2"                          , 0x0002b184, 31, 0 },
{"BB_rx_ocgain2[98]", "gain_entry2"                          , 0x0002b188, 31, 0 },
{"BB_rx_ocgain2[99]", "gain_entry2"                          , 0x0002b18c, 31, 0 },
{"BB_rx_ocgain2[100]", "gain_entry2"                         , 0x0002b190, 31, 0 },
{"BB_rx_ocgain2[101]", "gain_entry2"                         , 0x0002b194, 31, 0 },
{"BB_rx_ocgain2[102]", "gain_entry2"                         , 0x0002b198, 31, 0 },
{"BB_rx_ocgain2[103]", "gain_entry2"                         , 0x0002b19c, 31, 0 },
{"BB_rx_ocgain2[104]", "gain_entry2"                         , 0x0002b1a0, 31, 0 },
{"BB_rx_ocgain2[105]", "gain_entry2"                         , 0x0002b1a4, 31, 0 },
{"BB_rx_ocgain2[106]", "gain_entry2"                         , 0x0002b1a8, 31, 0 },
{"BB_rx_ocgain2[107]", "gain_entry2"                         , 0x0002b1ac, 31, 0 },
{"BB_rx_ocgain2[108]", "gain_entry2"                         , 0x0002b1b0, 31, 0 },
{"BB_rx_ocgain2[109]", "gain_entry2"                         , 0x0002b1b4, 31, 0 },
{"BB_rx_ocgain2[110]", "gain_entry2"                         , 0x0002b1b8, 31, 0 },
{"BB_rx_ocgain2[111]", "gain_entry2"                         , 0x0002b1bc, 31, 0 },
{"BB_rx_ocgain2[112]", "gain_entry2"                         , 0x0002b1c0, 31, 0 },
{"BB_rx_ocgain2[113]", "gain_entry2"                         , 0x0002b1c4, 31, 0 },
{"BB_rx_ocgain2[114]", "gain_entry2"                         , 0x0002b1c8, 31, 0 },
{"BB_rx_ocgain2[115]", "gain_entry2"                         , 0x0002b1cc, 31, 0 },
{"BB_rx_ocgain2[116]", "gain_entry2"                         , 0x0002b1d0, 31, 0 },
{"BB_rx_ocgain2[117]", "gain_entry2"                         , 0x0002b1d4, 31, 0 },
{"BB_rx_ocgain2[118]", "gain_entry2"                         , 0x0002b1d8, 31, 0 },
{"BB_rx_ocgain2[119]", "gain_entry2"                         , 0x0002b1dc, 31, 0 },
{"BB_rx_ocgain2[120]", "gain_entry2"                         , 0x0002b1e0, 31, 0 },
{"BB_rx_ocgain2[121]", "gain_entry2"                         , 0x0002b1e4, 31, 0 },
{"BB_rx_ocgain2[122]", "gain_entry2"                         , 0x0002b1e8, 31, 0 },
{"BB_rx_ocgain2[123]", "gain_entry2"                         , 0x0002b1ec, 31, 0 },
{"BB_rx_ocgain2[124]", "gain_entry2"                         , 0x0002b1f0, 31, 0 },
{"BB_rx_ocgain2[125]", "gain_entry2"                         , 0x0002b1f4, 31, 0 },
{"BB_rx_ocgain2[126]", "gain_entry2"                         , 0x0002b1f8, 31, 0 },
{"BB_rx_ocgain2[127]", "gain_entry2"                         , 0x0002b1fc, 31, 0 },
{"BB_switch_table_chn_b1", "switch_table_b_1"                , 0x0002b284, 11, 10},
{"BB_switch_table_chn_b1", "switch_table_rx12_1"             , 0x0002b284, 9 , 8 },
{"BB_switch_table_chn_b1", "switch_table_rx1_1"              , 0x0002b284, 7 , 6 },
{"BB_switch_table_chn_b1", "switch_table_r_1"                , 0x0002b284, 5 , 4 },
{"BB_switch_table_chn_b1", "switch_table_t_1"                , 0x0002b284, 3 , 2 },
{"BB_switch_table_chn_b1", "switch_table_idle_1"             , 0x0002b284, 1 , 0 },
{"BB_fcal_2_b1", "flc_cap_val_status_1"                      , 0x0002b2d0, 24, 20},
{"BB_fcal_2_b1", "flc_sw_cap_val_1"                          , 0x0002b2d0, 7 , 3 },
{"BB_dft_tone_ctrl_b1", "dft_tone_freq_ang_1"                , 0x0002b2d4, 12, 4 },
{"BB_dft_tone_ctrl_b1", "dft_tone_amp_sel_1"                 , 0x0002b2d4, 3 , 2 },
{"BB_dft_tone_ctrl_b1", "dft_tone_en_1"                      , 0x0002b2d4, 0 , 0 },
{"BB_cl_map_0_b1", "cl_map_0"                                , 0x0002b2dc, 31, 0 },
{"BB_cl_map_1_b1", "cl_map_1"                                , 0x0002b2e0, 31, 0 },
{"BB_cl_map_2_b1", "cl_map_2"                                , 0x0002b2e4, 31, 0 },
{"BB_cl_map_3_b1", "cl_map_3"                                , 0x0002b2e8, 31, 0 },
{"BB_cl_tab_b1[0]", "bb_gain"                                , 0x0002b300, 30, 27},
{"BB_cl_tab_b1[0]", "carr_lk_dc_add_I"                       , 0x0002b300, 26, 16},
{"BB_cl_tab_b1[0]", "carr_lk_dc_add_Q"                       , 0x0002b300, 15, 5 },
{"BB_cl_tab_b1[0]", "cl_gain_mod"                            , 0x0002b300, 4 , 0 },
{"BB_cl_tab_b1[1]", "bb_gain"                                , 0x0002b304, 30, 27},
{"BB_cl_tab_b1[1]", "carr_lk_dc_add_I"                       , 0x0002b304, 26, 16},
{"BB_cl_tab_b1[1]", "carr_lk_dc_add_Q"                       , 0x0002b304, 15, 5 },
{"BB_cl_tab_b1[1]", "cl_gain_mod"                            , 0x0002b304, 4 , 0 },
{"BB_cl_tab_b1[2]", "bb_gain"                                , 0x0002b308, 30, 27},
{"BB_cl_tab_b1[2]", "carr_lk_dc_add_I"                       , 0x0002b308, 26, 16},
{"BB_cl_tab_b1[2]", "carr_lk_dc_add_Q"                       , 0x0002b308, 15, 5 },
{"BB_cl_tab_b1[2]", "cl_gain_mod"                            , 0x0002b308, 4 , 0 },
{"BB_cl_tab_b1[3]", "bb_gain"                                , 0x0002b30c, 30, 27},
{"BB_cl_tab_b1[3]", "carr_lk_dc_add_I"                       , 0x0002b30c, 26, 16},
{"BB_cl_tab_b1[3]", "carr_lk_dc_add_Q"                       , 0x0002b30c, 15, 5 },
{"BB_cl_tab_b1[3]", "cl_gain_mod"                            , 0x0002b30c, 4 , 0 },
{"BB_cl_tab_b1[4]", "bb_gain"                                , 0x0002b310, 30, 27},
{"BB_cl_tab_b1[4]", "carr_lk_dc_add_I"                       , 0x0002b310, 26, 16},
{"BB_cl_tab_b1[4]", "carr_lk_dc_add_Q"                       , 0x0002b310, 15, 5 },
{"BB_cl_tab_b1[4]", "cl_gain_mod"                            , 0x0002b310, 4 , 0 },
{"BB_cl_tab_b1[5]", "bb_gain"                                , 0x0002b314, 30, 27},
{"BB_cl_tab_b1[5]", "carr_lk_dc_add_I"                       , 0x0002b314, 26, 16},
{"BB_cl_tab_b1[5]", "carr_lk_dc_add_Q"                       , 0x0002b314, 15, 5 },
{"BB_cl_tab_b1[5]", "cl_gain_mod"                            , 0x0002b314, 4 , 0 },
{"BB_cl_tab_b1[6]", "bb_gain"                                , 0x0002b318, 30, 27},
{"BB_cl_tab_b1[6]", "carr_lk_dc_add_I"                       , 0x0002b318, 26, 16},
{"BB_cl_tab_b1[6]", "carr_lk_dc_add_Q"                       , 0x0002b318, 15, 5 },
{"BB_cl_tab_b1[6]", "cl_gain_mod"                            , 0x0002b318, 4 , 0 },
{"BB_cl_tab_b1[7]", "bb_gain"                                , 0x0002b31c, 30, 27},
{"BB_cl_tab_b1[7]", "carr_lk_dc_add_I"                       , 0x0002b31c, 26, 16},
{"BB_cl_tab_b1[7]", "carr_lk_dc_add_Q"                       , 0x0002b31c, 15, 5 },
{"BB_cl_tab_b1[7]", "cl_gain_mod"                            , 0x0002b31c, 4 , 0 },
{"BB_cl_tab_b1[8]", "bb_gain"                                , 0x0002b320, 30, 27},
{"BB_cl_tab_b1[8]", "carr_lk_dc_add_I"                       , 0x0002b320, 26, 16},
{"BB_cl_tab_b1[8]", "carr_lk_dc_add_Q"                       , 0x0002b320, 15, 5 },
{"BB_cl_tab_b1[8]", "cl_gain_mod"                            , 0x0002b320, 4 , 0 },
{"BB_cl_tab_b1[9]", "bb_gain"                                , 0x0002b324, 30, 27},
{"BB_cl_tab_b1[9]", "carr_lk_dc_add_I"                       , 0x0002b324, 26, 16},
{"BB_cl_tab_b1[9]", "carr_lk_dc_add_Q"                       , 0x0002b324, 15, 5 },
{"BB_cl_tab_b1[9]", "cl_gain_mod"                            , 0x0002b324, 4 , 0 },
{"BB_cl_tab_b1[10]", "bb_gain"                               , 0x0002b328, 30, 27},
{"BB_cl_tab_b1[10]", "carr_lk_dc_add_I"                      , 0x0002b328, 26, 16},
{"BB_cl_tab_b1[10]", "carr_lk_dc_add_Q"                      , 0x0002b328, 15, 5 },
{"BB_cl_tab_b1[10]", "cl_gain_mod"                           , 0x0002b328, 4 , 0 },
{"BB_cl_tab_b1[11]", "bb_gain"                               , 0x0002b32c, 30, 27},
{"BB_cl_tab_b1[11]", "carr_lk_dc_add_I"                      , 0x0002b32c, 26, 16},
{"BB_cl_tab_b1[11]", "carr_lk_dc_add_Q"                      , 0x0002b32c, 15, 5 },
{"BB_cl_tab_b1[11]", "cl_gain_mod"                           , 0x0002b32c, 4 , 0 },
{"BB_cl_tab_b1[12]", "bb_gain"                               , 0x0002b330, 30, 27},
{"BB_cl_tab_b1[12]", "carr_lk_dc_add_I"                      , 0x0002b330, 26, 16},
{"BB_cl_tab_b1[12]", "carr_lk_dc_add_Q"                      , 0x0002b330, 15, 5 },
{"BB_cl_tab_b1[12]", "cl_gain_mod"                           , 0x0002b330, 4 , 0 },
{"BB_cl_tab_b1[13]", "bb_gain"                               , 0x0002b334, 30, 27},
{"BB_cl_tab_b1[13]", "carr_lk_dc_add_I"                      , 0x0002b334, 26, 16},
{"BB_cl_tab_b1[13]", "carr_lk_dc_add_Q"                      , 0x0002b334, 15, 5 },
{"BB_cl_tab_b1[13]", "cl_gain_mod"                           , 0x0002b334, 4 , 0 },
{"BB_cl_tab_b1[14]", "bb_gain"                               , 0x0002b338, 30, 27},
{"BB_cl_tab_b1[14]", "carr_lk_dc_add_I"                      , 0x0002b338, 26, 16},
{"BB_cl_tab_b1[14]", "carr_lk_dc_add_Q"                      , 0x0002b338, 15, 5 },
{"BB_cl_tab_b1[14]", "cl_gain_mod"                           , 0x0002b338, 4 , 0 },
{"BB_cl_tab_b1[15]", "bb_gain"                               , 0x0002b33c, 30, 27},
{"BB_cl_tab_b1[15]", "carr_lk_dc_add_I"                      , 0x0002b33c, 26, 16},
{"BB_cl_tab_b1[15]", "carr_lk_dc_add_Q"                      , 0x0002b33c, 15, 5 },
{"BB_cl_tab_b1[15]", "cl_gain_mod"                           , 0x0002b33c, 4 , 0 },
{"BB_chan_info_gain_b1", "chan_info_xatten2_sw_1"            , 0x0002b380, 24, 24},
{"BB_chan_info_gain_b1", "chan_info_xatten1_sw_1"            , 0x0002b380, 23, 23},
{"BB_chan_info_gain_b1", "chan_info_mb_gain_1"               , 0x0002b380, 22, 16},
{"BB_chan_info_gain_b1", "chan_info_rf_gain_1"               , 0x0002b380, 15, 8 },
{"BB_chan_info_gain_b1", "chan_info_rssi_1"                  , 0x0002b380, 7 , 0 },
{"BB_tpc_4_b1", "rate_sent_1"                                , 0x0002b404, 24, 20},
{"BB_tpc_4_b1", "tx_gain_setting_1"                          , 0x0002b404, 19, 14},
{"BB_tpc_4_b1", "dac_gain_1"                                 , 0x0002b404, 13, 9 },
{"BB_tpc_4_b1", "pd_avg_out_1"                               , 0x0002b404, 8 , 1 },
{"BB_tpc_4_b1", "pd_avg_valid_1"                             , 0x0002b404, 0 , 0 },
{"BB_tpc_5_b1", "pd_gain_boundary_4_1"                       , 0x0002b408, 27, 22},
{"BB_tpc_5_b1", "pd_gain_boundary_3_1"                       , 0x0002b408, 21, 16},
{"BB_tpc_5_b1", "pd_gain_boundary_2_1"                       , 0x0002b408, 15, 10},
{"BB_tpc_5_b1", "pd_gain_boundary_1_1"                       , 0x0002b408, 9 , 4 },
{"BB_tpc_6_b1", "error_est_filter_coeff"                     , 0x0002b40c, 28, 26},
{"BB_tpc_6_b1", "error_est_mode"                             , 0x0002b40c, 25, 24},
{"BB_tpc_6_b1", "pd_dac_setting_4_1"                         , 0x0002b40c, 23, 18},
{"BB_tpc_6_b1", "pd_dac_setting_3_1"                         , 0x0002b40c, 17, 12},
{"BB_tpc_6_b1", "pd_dac_setting_2_1"                         , 0x0002b40c, 11, 6 },
{"BB_tpc_6_b1", "pd_dac_setting_1_1"                         , 0x0002b40c, 5 , 0 },
{"BB_tpc_10_b1", "txgain_idx_cal_b_1"                        , 0x0002b41c, 29, 24},
{"BB_tpc_10_b1", "txgain_idx_cal_a_1"                        , 0x0002b41c, 21, 16},
{"BB_tpc_10_b1", "pwr_meas_cal_b_1"                          , 0x0002b41c, 15, 8 },
{"BB_tpc_10_b1", "pwr_meas_cal_a_1"                          , 0x0002b41c, 7 , 0 },
{"BB_tpc_11_b1", "forced_txgain_idx_1"                       , 0x0002b420, 15, 10},
{"BB_tpc_11_b1", "olpc_gain_delta_1_lsb_ext"                 , 0x0002b420, 9 , 8 },
{"BB_tpc_11_b1", "olpc_gain_delta_1"                         , 0x0002b420, 7 , 0 },
{"BB_tpc_19_b1", "alpha_volt_1"                              , 0x0002b440, 14, 8 },
{"BB_tpc_19_b1", "alpha_therm_1"                             , 0x0002b440, 7 , 0 },
{"BB_pdadc_tab_b1[0]", "tab_entry"                           , 0x0002b480, 31, 0 },
{"BB_pdadc_tab_b1[1]", "tab_entry"                           , 0x0002b484, 31, 0 },
{"BB_pdadc_tab_b1[2]", "tab_entry"                           , 0x0002b488, 31, 0 },
{"BB_pdadc_tab_b1[3]", "tab_entry"                           , 0x0002b48c, 31, 0 },
{"BB_pdadc_tab_b1[4]", "tab_entry"                           , 0x0002b490, 31, 0 },
{"BB_pdadc_tab_b1[5]", "tab_entry"                           , 0x0002b494, 31, 0 },
{"BB_pdadc_tab_b1[6]", "tab_entry"                           , 0x0002b498, 31, 0 },
{"BB_pdadc_tab_b1[7]", "tab_entry"                           , 0x0002b49c, 31, 0 },
{"BB_pdadc_tab_b1[8]", "tab_entry"                           , 0x0002b4a0, 31, 0 },
{"BB_pdadc_tab_b1[9]", "tab_entry"                           , 0x0002b4a4, 31, 0 },
{"BB_pdadc_tab_b1[10]", "tab_entry"                          , 0x0002b4a8, 31, 0 },
{"BB_pdadc_tab_b1[11]", "tab_entry"                          , 0x0002b4ac, 31, 0 },
{"BB_pdadc_tab_b1[12]", "tab_entry"                          , 0x0002b4b0, 31, 0 },
{"BB_pdadc_tab_b1[13]", "tab_entry"                          , 0x0002b4b4, 31, 0 },
{"BB_pdadc_tab_b1[14]", "tab_entry"                          , 0x0002b4b8, 31, 0 },
{"BB_pdadc_tab_b1[15]", "tab_entry"                          , 0x0002b4bc, 31, 0 },
{"BB_pdadc_tab_b1[16]", "tab_entry"                          , 0x0002b4c0, 31, 0 },
{"BB_pdadc_tab_b1[17]", "tab_entry"                          , 0x0002b4c4, 31, 0 },
{"BB_pdadc_tab_b1[18]", "tab_entry"                          , 0x0002b4c8, 31, 0 },
{"BB_pdadc_tab_b1[19]", "tab_entry"                          , 0x0002b4cc, 31, 0 },
{"BB_pdadc_tab_b1[20]", "tab_entry"                          , 0x0002b4d0, 31, 0 },
{"BB_pdadc_tab_b1[21]", "tab_entry"                          , 0x0002b4d4, 31, 0 },
{"BB_pdadc_tab_b1[22]", "tab_entry"                          , 0x0002b4d8, 31, 0 },
{"BB_pdadc_tab_b1[23]", "tab_entry"                          , 0x0002b4dc, 31, 0 },
{"BB_pdadc_tab_b1[24]", "tab_entry"                          , 0x0002b4e0, 31, 0 },
{"BB_pdadc_tab_b1[25]", "tab_entry"                          , 0x0002b4e4, 31, 0 },
{"BB_pdadc_tab_b1[26]", "tab_entry"                          , 0x0002b4e8, 31, 0 },
{"BB_pdadc_tab_b1[27]", "tab_entry"                          , 0x0002b4ec, 31, 0 },
{"BB_pdadc_tab_b1[28]", "tab_entry"                          , 0x0002b4f0, 31, 0 },
{"BB_pdadc_tab_b1[29]", "tab_entry"                          , 0x0002b4f4, 31, 0 },
{"BB_pdadc_tab_b1[30]", "tab_entry"                          , 0x0002b4f8, 31, 0 },
{"BB_pdadc_tab_b1[31]", "tab_entry"                          , 0x0002b4fc, 31, 0 },
{"BB_rtt_table_sw_intf_b1", "sw_rtt_table_addr_offset_1"     , 0x0002b584, 5 , 5 },
{"BB_rtt_table_sw_intf_b1", "sw_rtt_table_addr_1"            , 0x0002b584, 4 , 2 },
{"BB_rtt_table_sw_intf_b1", "sw_rtt_table_write_1"           , 0x0002b584, 1 , 1 },
{"BB_rtt_table_sw_intf_b1", "sw_rtt_table_access_1"          , 0x0002b584, 0 , 0 },
{"BB_rtt_table_sw_intf_1_b1", "sw_rtt_table_data_1"          , 0x0002b588, 31, 0 },
{"BB_txiqcal_status_b1", "last_meas_addr_1"                  , 0x0002b68c, 23, 18},
{"BB_txiqcal_status_b1", "rx_gain_used_1"                    , 0x0002b68c, 17, 12},
{"BB_txiqcal_status_b1", "tone_gain_used_1"                  , 0x0002b68c, 11, 6 },
{"BB_txiqcal_status_b1", "calibrated_gains_1"                , 0x0002b68c, 5 , 1 },
{"BB_txiqcal_status_b1", "txiqcal_failed_1"                  , 0x0002b68c, 0 , 0 },
{"BB_rxiqcal_status_b1", "rxiqcal_last_meas_addr_1"          , 0x0002b6ac, 16, 11},
{"BB_rxiqcal_status_b1", "rxiqcal_txgain_idx_used_1"         , 0x0002b6ac, 10, 6 },
{"BB_rxiqcal_status_b1", "rxiqcal_calibrated_gains_1"        , 0x0002b6ac, 5 , 1 },
{"BB_rxiqcal_status_b1", "rxiqcal_failed_1"                  , 0x0002b6ac, 0 , 0 },
{"BB_aic_ctrl_0_b1", "aic_mon_enable_1"                      , 0x0002b6b0, 31, 31},
{"BB_aic_ctrl_0_b1", "aic_cal_ch_valid_reset_1"              , 0x0002b6b0, 9 , 9 },
{"BB_aic_ctrl_0_b1", "aic_cal_enable_1"                      , 0x0002b6b0, 8 , 8 },
{"BB_aic_ctrl_0_b1", "aic_bttx_pwr_thr_1"                    , 0x0002b6b0, 7 , 1 },
{"BB_aic_ctrl_0_b1", "aic_enable_1"                          , 0x0002b6b0, 0 , 0 },
{"BB_aic_ctrl_1_b1", "aic_rssi_max_1"                        , 0x0002b6b4, 7 , 4 },
{"BB_aic_ctrl_1_b1", "aic_rssi_min_1"                        , 0x0002b6b4, 3 , 0 },
{"BB_aic_ctrl_4_b1", "aic_cal_rot_att_db_est_iso_1"          , 0x0002b6c0, 15, 13},
{"BB_aic_ctrl_4_b1", "aic_cal_com_att_db_est_iso_1"          , 0x0002b6c0, 12, 9 },
{"BB_aic_ctrl_4_b1", "aic_cal_iso_est_init_setting_1"        , 0x0002b6c0, 8 , 3 },
{"BB_aic_ctrl_4_b1", "aic_cal_com_att_db_backoff_1"          , 0x0002b6c0, 2 , 1 },
{"BB_aic_ctrl_4_b1", "aic_cal_com_att_db_fixed_1"            , 0x0002b6c0, 0 , 0 },
{"BB_aic_stat_0_b1", "aic_meas_count_1"                      , 0x0002b6c4, 29, 24},
{"BB_aic_stat_0_b1", "aic_cal_ant_iso_est_1"                 , 0x0002b6c4, 23, 18},
{"BB_aic_stat_0_b1", "aic_cal_hop_count_1"                   , 0x0002b6c4, 17, 11},
{"BB_aic_stat_0_b1", "aic_cal_valid_count_1"                 , 0x0002b6c4, 10, 4 },
{"BB_aic_stat_0_b1", "aic_cal_bt_too_weak_err_1"             , 0x0002b6c4, 3 , 3 },
{"BB_aic_stat_0_b1", "aic_cal_bt_too_strong_err_1"           , 0x0002b6c4, 2 , 2 },
{"BB_aic_stat_0_b1", "aic_cal_done_1"                        , 0x0002b6c4, 1 , 1 },
{"BB_aic_stat_0_b1", "aic_cal_active_1"                      , 0x0002b6c4, 0 , 0 },
{"BB_aic_stat_1_b1", "aic_meas_mag_min_1"                    , 0x0002b6c8, 23, 14},
{"BB_aic_stat_1_b1", "aic_chunk_count_1"                     , 0x0002b6c8, 13, 8 },
{"BB_aic_stat_1_b1", "r_cal_aic_sm_1"                        , 0x0002b6c8, 7 , 3 },
{"BB_aic_stat_1_b1", "r_aic_sm_1"                            , 0x0002b6c8, 2 , 0 },
{"BB_aic_stat_2_b1", "r_mon_aic_sm_1"                        , 0x0002b6cc, 25, 23},
{"BB_aic_stat_2_b1", "aic_mon_est_pwr_ratio_1"               , 0x0002b6cc, 22, 16},
{"BB_aic_stat_2_b1", "aic_mon_stale_count_1"                 , 0x0002b6cc, 15, 9 },
{"BB_aic_stat_2_b1", "aic_mon_hop_count_1"                   , 0x0002b6cc, 8 , 2 },
{"BB_aic_stat_2_b1", "aic_mon_done_1"                        , 0x0002b6cc, 1 , 1 },
{"BB_aic_stat_2_b1", "aic_mon_active_1"                      , 0x0002b6cc, 0 , 0 },
{"BB_tables_intf_addr_b1", "addr_auto_incr_1"                , 0x0002b7f0, 31, 31},
{"BB_tables_intf_addr_b1", "tables_addr_1"                   , 0x0002b7f0, 17, 2 },
{"BB_tables_intf_data_b1", "tables_data_1"                   , 0x0002b7f4, 31, 0 },
{"BB_pre_emphasis_bw20_b2", "pre_emp_db_neg_bw20_2"          , 0x0002b888, 29, 15},
{"BB_pre_emphasis_bw20_b2", "pre_emp_db_pos_bw20_2"          , 0x0002b888, 14, 0 },
{"BB_pre_emphasis_bw40_b2", "pre_emp_db_neg_bw40_2"          , 0x0002b88c, 29, 15},
{"BB_pre_emphasis_bw40_b2", "pre_emp_db_pos_bw40_2"          , 0x0002b88c, 14, 0 },
{"BB_pre_emphasis_bw80_b2", "pre_emp_db_neg_bw80_2"          , 0x0002b890, 29, 15},
{"BB_pre_emphasis_bw80_b2", "pre_emp_db_pos_bw80_2"          , 0x0002b890, 14, 0 },
{"BB_spur_report_b2", "power_with_spur_removed_2"            , 0x0002b8a8, 31, 16},
{"BB_spur_report_b2", "spur_est_q_2"                         , 0x0002b8a8, 15, 8 },
{"BB_spur_report_b2", "spur_est_i_2"                         , 0x0002b8a8, 7 , 0 },
{"BB_iq_adc_meas_0_b2", "gain_dc_iq_cal_meas_0_2"            , 0x0002b8c0, 31, 0 },
{"BB_iq_adc_meas_1_b2", "gain_dc_iq_cal_meas_1_2"            , 0x0002b8c4, 31, 0 },
{"BB_iq_adc_meas_2_b2", "gain_dc_iq_cal_meas_2_2"            , 0x0002b8c8, 31, 0 },
{"BB_iq_adc_meas_3_b2", "gain_dc_iq_cal_meas_3_2"            , 0x0002b8cc, 31, 0 },
{"BB_tx_phase_ramp_b2", "cf_phase_ramp_alpha_2"              , 0x0002b8d0, 24, 17},
{"BB_tx_phase_ramp_b2", "cf_phase_ramp_init_2"               , 0x0002b8d0, 16, 7 },
{"BB_tx_phase_ramp_b2", "cf_phase_ramp_bias_2"               , 0x0002b8d0, 6 , 1 },
{"BB_tx_phase_ramp_b2", "cf_phase_ramp_enable_2"             , 0x0002b8d0, 0 , 0 },
{"BB_adc_gain_dc_corr_b2", "adc_dc_corr_i_coeff_2"           , 0x0002b8d4, 29, 21},
{"BB_adc_gain_dc_corr_b2", "adc_dc_corr_q_coeff_2"           , 0x0002b8d4, 20, 12},
{"BB_adc_gain_dc_corr_b2", "adc_gain_corr_i_coeff_2"         , 0x0002b8d4, 11, 6 },
{"BB_adc_gain_dc_corr_b2", "adc_gain_corr_q_coeff_2"         , 0x0002b8d4, 5 , 0 },
{"BB_rx_iq_corr_loopback_b2", "loopback_iqcorr_q_i_coff_2"   , 0x0002b8e0, 17, 9 },
{"BB_rx_iq_corr_loopback_b2", "loopback_iqcorr_q_q_coff_2"   , 0x0002b8e0, 8 , 0 },
{"BB_paprd_ctrl0_b2", "paprd_mag_thrsh_2"                    , 0x0002b8f0, 31, 27},
{"BB_paprd_ctrl0_b2", "paprd_valid_gain_2"                   , 0x0002b8f0, 26, 2 },
{"BB_paprd_ctrl0_b2", "paprd_adaptive_use_single_table_2"    , 0x0002b8f0, 1 , 1 },
{"BB_paprd_ctrl0_b2", "paprd_enable_2"                       , 0x0002b8f0, 0 , 0 },
{"BB_paprd_ctrl1_b2", "paprd_trainer_iandq_sel_2"            , 0x0002b8f4, 27, 27},
{"BB_paprd_ctrl1_b2", "paprd_mag_scale_factor_2"             , 0x0002b8f4, 26, 17},
{"BB_paprd_ctrl1_b2", "pa_gain_scale_factor_2"               , 0x0002b8f4, 16, 9 },
{"BB_paprd_ctrl1_b2", "paprd_power_at_am2am_cal_2"           , 0x0002b8f4, 8 , 3 },
{"BB_paprd_ctrl1_b2", "paprd_adaptive_am2pm_enable_2"        , 0x0002b8f4, 2 , 2 },
{"BB_paprd_ctrl1_b2", "paprd_adaptive_am2am_enable_2"        , 0x0002b8f4, 1 , 1 },
{"BB_paprd_ctrl1_b2", "paprd_adaptive_scaling_enable_2"      , 0x0002b8f4, 0 , 0 },
{"BB_pa_gain123_b2", "pa_gain3_2"                            , 0x0002b8f8, 29, 20},
{"BB_pa_gain123_b2", "pa_gain2_2"                            , 0x0002b8f8, 19, 10},
{"BB_pa_gain123_b2", "pa_gain1_2"                            , 0x0002b8f8, 9 , 0 },
{"BB_pa_gain45_b2", "paprd_adaptive_table_valid_2"           , 0x0002b8fc, 24, 20},
{"BB_pa_gain45_b2", "pa_gain5_2"                             , 0x0002b8fc, 19, 10},
{"BB_pa_gain45_b2", "pa_gain4_2"                             , 0x0002b8fc, 9 , 0 },
{"BB_paprd_mem_tab_b2[0]", "paprd_mem"                       , 0x0002b920, 21, 0 },
{"BB_paprd_mem_tab_b2[1]", "paprd_mem"                       , 0x0002b924, 21, 0 },
{"BB_paprd_mem_tab_b2[2]", "paprd_mem"                       , 0x0002b928, 21, 0 },
{"BB_paprd_mem_tab_b2[3]", "paprd_mem"                       , 0x0002b92c, 21, 0 },
{"BB_paprd_mem_tab_b2[4]", "paprd_mem"                       , 0x0002b930, 21, 0 },
{"BB_paprd_mem_tab_b2[5]", "paprd_mem"                       , 0x0002b934, 21, 0 },
{"BB_paprd_mem_tab_b2[6]", "paprd_mem"                       , 0x0002b938, 21, 0 },
{"BB_paprd_mem_tab_b2[7]", "paprd_mem"                       , 0x0002b93c, 21, 0 },
{"BB_paprd_mem_tab_b2[8]", "paprd_mem"                       , 0x0002b940, 21, 0 },
{"BB_paprd_mem_tab_b2[9]", "paprd_mem"                       , 0x0002b944, 21, 0 },
{"BB_paprd_mem_tab_b2[10]", "paprd_mem"                      , 0x0002b948, 21, 0 },
{"BB_paprd_mem_tab_b2[11]", "paprd_mem"                      , 0x0002b94c, 21, 0 },
{"BB_paprd_mem_tab_b2[12]", "paprd_mem"                      , 0x0002b950, 21, 0 },
{"BB_paprd_mem_tab_b2[13]", "paprd_mem"                      , 0x0002b954, 21, 0 },
{"BB_paprd_mem_tab_b2[14]", "paprd_mem"                      , 0x0002b958, 21, 0 },
{"BB_paprd_mem_tab_b2[15]", "paprd_mem"                      , 0x0002b95c, 21, 0 },
{"BB_paprd_mem_tab_b2[16]", "paprd_mem"                      , 0x0002b960, 21, 0 },
{"BB_paprd_mem_tab_b2[17]", "paprd_mem"                      , 0x0002b964, 21, 0 },
{"BB_paprd_mem_tab_b2[18]", "paprd_mem"                      , 0x0002b968, 21, 0 },
{"BB_paprd_mem_tab_b2[19]", "paprd_mem"                      , 0x0002b96c, 21, 0 },
{"BB_paprd_mem_tab_b2[20]", "paprd_mem"                      , 0x0002b970, 21, 0 },
{"BB_paprd_mem_tab_b2[21]", "paprd_mem"                      , 0x0002b974, 21, 0 },
{"BB_paprd_mem_tab_b2[22]", "paprd_mem"                      , 0x0002b978, 21, 0 },
{"BB_paprd_mem_tab_b2[23]", "paprd_mem"                      , 0x0002b97c, 21, 0 },
{"BB_paprd_mem_tab_b2[24]", "paprd_mem"                      , 0x0002b980, 21, 0 },
{"BB_paprd_mem_tab_b2[25]", "paprd_mem"                      , 0x0002b984, 21, 0 },
{"BB_paprd_mem_tab_b2[26]", "paprd_mem"                      , 0x0002b988, 21, 0 },
{"BB_paprd_mem_tab_b2[27]", "paprd_mem"                      , 0x0002b98c, 21, 0 },
{"BB_paprd_mem_tab_b2[28]", "paprd_mem"                      , 0x0002b990, 21, 0 },
{"BB_paprd_mem_tab_b2[29]", "paprd_mem"                      , 0x0002b994, 21, 0 },
{"BB_paprd_mem_tab_b2[30]", "paprd_mem"                      , 0x0002b998, 21, 0 },
{"BB_paprd_mem_tab_b2[31]", "paprd_mem"                      , 0x0002b99c, 21, 0 },
{"BB_paprd_mem_tab_b2[32]", "paprd_mem"                      , 0x0002b9a0, 21, 0 },
{"BB_paprd_mem_tab_b2[33]", "paprd_mem"                      , 0x0002b9a4, 21, 0 },
{"BB_paprd_mem_tab_b2[34]", "paprd_mem"                      , 0x0002b9a8, 21, 0 },
{"BB_paprd_mem_tab_b2[35]", "paprd_mem"                      , 0x0002b9ac, 21, 0 },
{"BB_paprd_mem_tab_b2[36]", "paprd_mem"                      , 0x0002b9b0, 21, 0 },
{"BB_paprd_mem_tab_b2[37]", "paprd_mem"                      , 0x0002b9b4, 21, 0 },
{"BB_paprd_mem_tab_b2[38]", "paprd_mem"                      , 0x0002b9b8, 21, 0 },
{"BB_paprd_mem_tab_b2[39]", "paprd_mem"                      , 0x0002b9bc, 21, 0 },
{"BB_paprd_mem_tab_b2[40]", "paprd_mem"                      , 0x0002b9c0, 21, 0 },
{"BB_paprd_mem_tab_b2[41]", "paprd_mem"                      , 0x0002b9c4, 21, 0 },
{"BB_paprd_mem_tab_b2[42]", "paprd_mem"                      , 0x0002b9c8, 21, 0 },
{"BB_paprd_mem_tab_b2[43]", "paprd_mem"                      , 0x0002b9cc, 21, 0 },
{"BB_paprd_mem_tab_b2[44]", "paprd_mem"                      , 0x0002b9d0, 21, 0 },
{"BB_paprd_mem_tab_b2[45]", "paprd_mem"                      , 0x0002b9d4, 21, 0 },
{"BB_paprd_mem_tab_b2[46]", "paprd_mem"                      , 0x0002b9d8, 21, 0 },
{"BB_paprd_mem_tab_b2[47]", "paprd_mem"                      , 0x0002b9dc, 21, 0 },
{"BB_paprd_mem_tab_b2[48]", "paprd_mem"                      , 0x0002b9e0, 21, 0 },
{"BB_paprd_mem_tab_b2[49]", "paprd_mem"                      , 0x0002b9e4, 21, 0 },
{"BB_paprd_mem_tab_b2[50]", "paprd_mem"                      , 0x0002b9e8, 21, 0 },
{"BB_paprd_mem_tab_b2[51]", "paprd_mem"                      , 0x0002b9ec, 21, 0 },
{"BB_paprd_mem_tab_b2[52]", "paprd_mem"                      , 0x0002b9f0, 21, 0 },
{"BB_paprd_mem_tab_b2[53]", "paprd_mem"                      , 0x0002b9f4, 21, 0 },
{"BB_paprd_mem_tab_b2[54]", "paprd_mem"                      , 0x0002b9f8, 21, 0 },
{"BB_paprd_mem_tab_b2[55]", "paprd_mem"                      , 0x0002b9fc, 21, 0 },
{"BB_paprd_mem_tab_b2[56]", "paprd_mem"                      , 0x0002ba00, 21, 0 },
{"BB_paprd_mem_tab_b2[57]", "paprd_mem"                      , 0x0002ba04, 21, 0 },
{"BB_paprd_mem_tab_b2[58]", "paprd_mem"                      , 0x0002ba08, 21, 0 },
{"BB_paprd_mem_tab_b2[59]", "paprd_mem"                      , 0x0002ba0c, 21, 0 },
{"BB_paprd_mem_tab_b2[60]", "paprd_mem"                      , 0x0002ba10, 21, 0 },
{"BB_paprd_mem_tab_b2[61]", "paprd_mem"                      , 0x0002ba14, 21, 0 },
{"BB_paprd_mem_tab_b2[62]", "paprd_mem"                      , 0x0002ba18, 21, 0 },
{"BB_paprd_mem_tab_b2[63]", "paprd_mem"                      , 0x0002ba1c, 21, 0 },
{"BB_paprd_mem_tab_b2[64]", "paprd_mem"                      , 0x0002ba20, 21, 0 },
{"BB_paprd_mem_tab_b2[65]", "paprd_mem"                      , 0x0002ba24, 21, 0 },
{"BB_paprd_mem_tab_b2[66]", "paprd_mem"                      , 0x0002ba28, 21, 0 },
{"BB_paprd_mem_tab_b2[67]", "paprd_mem"                      , 0x0002ba2c, 21, 0 },
{"BB_paprd_mem_tab_b2[68]", "paprd_mem"                      , 0x0002ba30, 21, 0 },
{"BB_paprd_mem_tab_b2[69]", "paprd_mem"                      , 0x0002ba34, 21, 0 },
{"BB_paprd_mem_tab_b2[70]", "paprd_mem"                      , 0x0002ba38, 21, 0 },
{"BB_paprd_mem_tab_b2[71]", "paprd_mem"                      , 0x0002ba3c, 21, 0 },
{"BB_paprd_mem_tab_b2[72]", "paprd_mem"                      , 0x0002ba40, 21, 0 },
{"BB_paprd_mem_tab_b2[73]", "paprd_mem"                      , 0x0002ba44, 21, 0 },
{"BB_paprd_mem_tab_b2[74]", "paprd_mem"                      , 0x0002ba48, 21, 0 },
{"BB_paprd_mem_tab_b2[75]", "paprd_mem"                      , 0x0002ba4c, 21, 0 },
{"BB_paprd_mem_tab_b2[76]", "paprd_mem"                      , 0x0002ba50, 21, 0 },
{"BB_paprd_mem_tab_b2[77]", "paprd_mem"                      , 0x0002ba54, 21, 0 },
{"BB_paprd_mem_tab_b2[78]", "paprd_mem"                      , 0x0002ba58, 21, 0 },
{"BB_paprd_mem_tab_b2[79]", "paprd_mem"                      , 0x0002ba5c, 21, 0 },
{"BB_paprd_mem_tab_b2[80]", "paprd_mem"                      , 0x0002ba60, 21, 0 },
{"BB_paprd_mem_tab_b2[81]", "paprd_mem"                      , 0x0002ba64, 21, 0 },
{"BB_paprd_mem_tab_b2[82]", "paprd_mem"                      , 0x0002ba68, 21, 0 },
{"BB_paprd_mem_tab_b2[83]", "paprd_mem"                      , 0x0002ba6c, 21, 0 },
{"BB_paprd_mem_tab_b2[84]", "paprd_mem"                      , 0x0002ba70, 21, 0 },
{"BB_paprd_mem_tab_b2[85]", "paprd_mem"                      , 0x0002ba74, 21, 0 },
{"BB_paprd_mem_tab_b2[86]", "paprd_mem"                      , 0x0002ba78, 21, 0 },
{"BB_paprd_mem_tab_b2[87]", "paprd_mem"                      , 0x0002ba7c, 21, 0 },
{"BB_paprd_mem_tab_b2[88]", "paprd_mem"                      , 0x0002ba80, 21, 0 },
{"BB_paprd_mem_tab_b2[89]", "paprd_mem"                      , 0x0002ba84, 21, 0 },
{"BB_paprd_mem_tab_b2[90]", "paprd_mem"                      , 0x0002ba88, 21, 0 },
{"BB_paprd_mem_tab_b2[91]", "paprd_mem"                      , 0x0002ba8c, 21, 0 },
{"BB_paprd_mem_tab_b2[92]", "paprd_mem"                      , 0x0002ba90, 21, 0 },
{"BB_paprd_mem_tab_b2[93]", "paprd_mem"                      , 0x0002ba94, 21, 0 },
{"BB_paprd_mem_tab_b2[94]", "paprd_mem"                      , 0x0002ba98, 21, 0 },
{"BB_paprd_mem_tab_b2[95]", "paprd_mem"                      , 0x0002ba9c, 21, 0 },
{"BB_paprd_mem_tab_b2[96]", "paprd_mem"                      , 0x0002baa0, 21, 0 },
{"BB_paprd_mem_tab_b2[97]", "paprd_mem"                      , 0x0002baa4, 21, 0 },
{"BB_paprd_mem_tab_b2[98]", "paprd_mem"                      , 0x0002baa8, 21, 0 },
{"BB_paprd_mem_tab_b2[99]", "paprd_mem"                      , 0x0002baac, 21, 0 },
{"BB_paprd_mem_tab_b2[100]", "paprd_mem"                     , 0x0002bab0, 21, 0 },
{"BB_paprd_mem_tab_b2[101]", "paprd_mem"                     , 0x0002bab4, 21, 0 },
{"BB_paprd_mem_tab_b2[102]", "paprd_mem"                     , 0x0002bab8, 21, 0 },
{"BB_paprd_mem_tab_b2[103]", "paprd_mem"                     , 0x0002babc, 21, 0 },
{"BB_paprd_mem_tab_b2[104]", "paprd_mem"                     , 0x0002bac0, 21, 0 },
{"BB_paprd_mem_tab_b2[105]", "paprd_mem"                     , 0x0002bac4, 21, 0 },
{"BB_paprd_mem_tab_b2[106]", "paprd_mem"                     , 0x0002bac8, 21, 0 },
{"BB_paprd_mem_tab_b2[107]", "paprd_mem"                     , 0x0002bacc, 21, 0 },
{"BB_paprd_mem_tab_b2[108]", "paprd_mem"                     , 0x0002bad0, 21, 0 },
{"BB_paprd_mem_tab_b2[109]", "paprd_mem"                     , 0x0002bad4, 21, 0 },
{"BB_paprd_mem_tab_b2[110]", "paprd_mem"                     , 0x0002bad8, 21, 0 },
{"BB_paprd_mem_tab_b2[111]", "paprd_mem"                     , 0x0002badc, 21, 0 },
{"BB_paprd_mem_tab_b2[112]", "paprd_mem"                     , 0x0002bae0, 21, 0 },
{"BB_paprd_mem_tab_b2[113]", "paprd_mem"                     , 0x0002bae4, 21, 0 },
{"BB_paprd_mem_tab_b2[114]", "paprd_mem"                     , 0x0002bae8, 21, 0 },
{"BB_paprd_mem_tab_b2[115]", "paprd_mem"                     , 0x0002baec, 21, 0 },
{"BB_paprd_mem_tab_b2[116]", "paprd_mem"                     , 0x0002baf0, 21, 0 },
{"BB_paprd_mem_tab_b2[117]", "paprd_mem"                     , 0x0002baf4, 21, 0 },
{"BB_paprd_mem_tab_b2[118]", "paprd_mem"                     , 0x0002baf8, 21, 0 },
{"BB_paprd_mem_tab_b2[119]", "paprd_mem"                     , 0x0002bafc, 21, 0 },
{"BB_chan_info_chan_tab_b2[0]", "chaninfo_word"              , 0x0002bb00, 31, 0 },
{"BB_chan_info_chan_tab_b2[1]", "chaninfo_word"              , 0x0002bb04, 31, 0 },
{"BB_chan_info_chan_tab_b2[2]", "chaninfo_word"              , 0x0002bb08, 31, 0 },
{"BB_chan_info_chan_tab_b2[3]", "chaninfo_word"              , 0x0002bb0c, 31, 0 },
{"BB_chan_info_chan_tab_b2[4]", "chaninfo_word"              , 0x0002bb10, 31, 0 },
{"BB_chan_info_chan_tab_b2[5]", "chaninfo_word"              , 0x0002bb14, 31, 0 },
{"BB_chan_info_chan_tab_b2[6]", "chaninfo_word"              , 0x0002bb18, 31, 0 },
{"BB_chan_info_chan_tab_b2[7]", "chaninfo_word"              , 0x0002bb1c, 31, 0 },
{"BB_chan_info_chan_tab_b2[8]", "chaninfo_word"              , 0x0002bb20, 31, 0 },
{"BB_chan_info_chan_tab_b2[9]", "chaninfo_word"              , 0x0002bb24, 31, 0 },
{"BB_chan_info_chan_tab_b2[10]", "chaninfo_word"             , 0x0002bb28, 31, 0 },
{"BB_chan_info_chan_tab_b2[11]", "chaninfo_word"             , 0x0002bb2c, 31, 0 },
{"BB_chan_info_chan_tab_b2[12]", "chaninfo_word"             , 0x0002bb30, 31, 0 },
{"BB_chan_info_chan_tab_b2[13]", "chaninfo_word"             , 0x0002bb34, 31, 0 },
{"BB_chan_info_chan_tab_b2[14]", "chaninfo_word"             , 0x0002bb38, 31, 0 },
{"BB_chan_info_chan_tab_b2[15]", "chaninfo_word"             , 0x0002bb3c, 31, 0 },
{"BB_chan_info_chan_tab_b2[16]", "chaninfo_word"             , 0x0002bb40, 31, 0 },
{"BB_chan_info_chan_tab_b2[17]", "chaninfo_word"             , 0x0002bb44, 31, 0 },
{"BB_chan_info_chan_tab_b2[18]", "chaninfo_word"             , 0x0002bb48, 31, 0 },
{"BB_chan_info_chan_tab_b2[19]", "chaninfo_word"             , 0x0002bb4c, 31, 0 },
{"BB_chan_info_chan_tab_b2[20]", "chaninfo_word"             , 0x0002bb50, 31, 0 },
{"BB_chan_info_chan_tab_b2[21]", "chaninfo_word"             , 0x0002bb54, 31, 0 },
{"BB_chan_info_chan_tab_b2[22]", "chaninfo_word"             , 0x0002bb58, 31, 0 },
{"BB_chan_info_chan_tab_b2[23]", "chaninfo_word"             , 0x0002bb5c, 31, 0 },
{"BB_chan_info_chan_tab_b2[24]", "chaninfo_word"             , 0x0002bb60, 31, 0 },
{"BB_chan_info_chan_tab_b2[25]", "chaninfo_word"             , 0x0002bb64, 31, 0 },
{"BB_chan_info_chan_tab_b2[26]", "chaninfo_word"             , 0x0002bb68, 31, 0 },
{"BB_chan_info_chan_tab_b2[27]", "chaninfo_word"             , 0x0002bb6c, 31, 0 },
{"BB_chan_info_chan_tab_b2[28]", "chaninfo_word"             , 0x0002bb70, 31, 0 },
{"BB_chan_info_chan_tab_b2[29]", "chaninfo_word"             , 0x0002bb74, 31, 0 },
{"BB_chan_info_chan_tab_b2[30]", "chaninfo_word"             , 0x0002bb78, 31, 0 },
{"BB_chan_info_chan_tab_b2[31]", "chaninfo_word"             , 0x0002bb7c, 31, 0 },
{"BB_chan_info_chan_tab_b2[32]", "chaninfo_word"             , 0x0002bb80, 31, 0 },
{"BB_chan_info_chan_tab_b2[33]", "chaninfo_word"             , 0x0002bb84, 31, 0 },
{"BB_chan_info_chan_tab_b2[34]", "chaninfo_word"             , 0x0002bb88, 31, 0 },
{"BB_chan_info_chan_tab_b2[35]", "chaninfo_word"             , 0x0002bb8c, 31, 0 },
{"BB_chan_info_chan_tab_b2[36]", "chaninfo_word"             , 0x0002bb90, 31, 0 },
{"BB_chan_info_chan_tab_b2[37]", "chaninfo_word"             , 0x0002bb94, 31, 0 },
{"BB_chan_info_chan_tab_b2[38]", "chaninfo_word"             , 0x0002bb98, 31, 0 },
{"BB_chan_info_chan_tab_b2[39]", "chaninfo_word"             , 0x0002bb9c, 31, 0 },
{"BB_chan_info_chan_tab_b2[40]", "chaninfo_word"             , 0x0002bba0, 31, 0 },
{"BB_chan_info_chan_tab_b2[41]", "chaninfo_word"             , 0x0002bba4, 31, 0 },
{"BB_chan_info_chan_tab_b2[42]", "chaninfo_word"             , 0x0002bba8, 31, 0 },
{"BB_chan_info_chan_tab_b2[43]", "chaninfo_word"             , 0x0002bbac, 31, 0 },
{"BB_chan_info_chan_tab_b2[44]", "chaninfo_word"             , 0x0002bbb0, 31, 0 },
{"BB_chan_info_chan_tab_b2[45]", "chaninfo_word"             , 0x0002bbb4, 31, 0 },
{"BB_chan_info_chan_tab_b2[46]", "chaninfo_word"             , 0x0002bbb8, 31, 0 },
{"BB_chan_info_chan_tab_b2[47]", "chaninfo_word"             , 0x0002bbbc, 31, 0 },
{"BB_chan_info_chan_tab_b2[48]", "chaninfo_word"             , 0x0002bbc0, 31, 0 },
{"BB_chan_info_chan_tab_b2[49]", "chaninfo_word"             , 0x0002bbc4, 31, 0 },
{"BB_chan_info_chan_tab_b2[50]", "chaninfo_word"             , 0x0002bbc8, 31, 0 },
{"BB_chan_info_chan_tab_b2[51]", "chaninfo_word"             , 0x0002bbcc, 31, 0 },
{"BB_chan_info_chan_tab_b2[52]", "chaninfo_word"             , 0x0002bbd0, 31, 0 },
{"BB_chan_info_chan_tab_b2[53]", "chaninfo_word"             , 0x0002bbd4, 31, 0 },
{"BB_chan_info_chan_tab_b2[54]", "chaninfo_word"             , 0x0002bbd8, 31, 0 },
{"BB_chan_info_chan_tab_b2[55]", "chaninfo_word"             , 0x0002bbdc, 31, 0 },
{"BB_chan_info_chan_tab_b2[56]", "chaninfo_word"             , 0x0002bbe0, 31, 0 },
{"BB_chan_info_chan_tab_b2[57]", "chaninfo_word"             , 0x0002bbe4, 31, 0 },
{"BB_chan_info_chan_tab_b2[58]", "chaninfo_word"             , 0x0002bbe8, 31, 0 },
{"BB_chan_info_chan_tab_b2[59]", "chaninfo_word"             , 0x0002bbec, 31, 0 },
{"BB_chn2_tables_intf_addr", "chn2_addr_auto_incr"           , 0x0002bbf0, 31, 31},
{"BB_chn2_tables_intf_addr", "chn2_tables_addr"              , 0x0002bbf0, 17, 2 },
{"BB_chn2_tables_intf_data", "chn2_tables_data"              , 0x0002bbf4, 31, 0 },
{"BB_gain_force_max_gains_b2", "xatten2_hyst_margin_2"       , 0x0002be04, 31, 25},
{"BB_gain_force_max_gains_b2", "xatten1_hyst_margin_2"       , 0x0002be04, 24, 18},
{"BB_gain_force_max_gains_b2", "xatten2_sw_f_2"              , 0x0002be04, 17, 17},
{"BB_gain_force_max_gains_b2", "xatten1_sw_f_2"              , 0x0002be04, 16, 16},
{"BB_gain_force_max_gains_b2", "mb_gain_f_2"                 , 0x0002be04, 15, 8 },
{"BB_gain_force_max_gains_b2", "rf_gain_f_2"                 , 0x0002be04, 7 , 0 },
{"BB_ext_atten_switch_ctl_b2", "xlna_gain_db_2"              , 0x0002be18, 26, 22},
{"BB_ext_atten_switch_ctl_b2", "xatten2_margin_2"            , 0x0002be18, 21, 17},
{"BB_ext_atten_switch_ctl_b2", "xatten1_margin_2"            , 0x0002be18, 16, 12},
{"BB_ext_atten_switch_ctl_b2", "xatten2_db_2"                , 0x0002be18, 11, 6 },
{"BB_ext_atten_switch_ctl_b2", "xatten1_db_2"                , 0x0002be18, 5 , 0 },
{"BB_cca_b2", "minCCApwr_2"                                  , 0x0002be1c, 28, 20},
{"BB_cca_b2", "cf_maxCCApwr_2"                               , 0x0002be1c, 8 , 0 },
{"BB_cca_ctrl_2_b2", "NF_gain_comp_2"                        , 0x0002be20, 17, 10},
{"BB_cca_ctrl_2_b2", "minCCApwr_thr_2"                       , 0x0002be20, 8 , 0 },
{"BB_rssi_b2", "rssi_ext80_2"                                , 0x0002bf80, 31, 24},
{"BB_rssi_b2", "rssi_ext40_2"                                , 0x0002bf80, 23, 16},
{"BB_rssi_b2", "rssi_ext20_2"                                , 0x0002bf80, 15, 8 },
{"BB_rssi_b2", "rssi_pri20_2"                                , 0x0002bf80, 7 , 0 },
{"BB_agc_dig_dc_status_i_0_b2", "resdc_sw_write0_2"          , 0x0002bf88, 30, 30},
{"BB_agc_dig_dc_status_i_0_b2", "dig_dc_mixer2_res_i_2"      , 0x0002bf88, 29, 20},
{"BB_agc_dig_dc_status_i_0_b2", "dig_dc_mixer1_res_i_2"      , 0x0002bf88, 19, 10},
{"BB_agc_dig_dc_status_i_0_b2", "dig_dc_mixer0_res_i_2"      , 0x0002bf88, 9 , 0 },
{"BB_agc_dig_dc_status_i_1_b2", "resdc_sw_write1_2"          , 0x0002bf8c, 30, 30},
{"BB_agc_dig_dc_status_i_1_b2", "dig_dc_mixer1_loopback_res_i_2", 0x0002bf8c, 29, 20},
{"BB_agc_dig_dc_status_i_1_b2", "dig_dc_mixer0_loopback_res_i_2", 0x0002bf8c, 19, 10},
{"BB_agc_dig_dc_status_i_1_b2", "dig_dc_mixer3_res_i_2"      , 0x0002bf8c, 9 , 0 },
{"BB_agc_dig_dc_status_i_2_b2", "resdc_sw_write2_2"          , 0x0002bf90, 30, 30},
{"BB_agc_dig_dc_status_i_2_b2", "dig_dc_mixer3_loopback_res_i_2", 0x0002bf90, 19, 10},
{"BB_agc_dig_dc_status_i_2_b2", "dig_dc_mixer2_loopback_res_i_2", 0x0002bf90, 9 , 0 },
{"BB_agc_dig_dc_status_q_0_b2", "resdc_sw_write3_2"          , 0x0002bf94, 30, 30},
{"BB_agc_dig_dc_status_q_0_b2", "dig_dc_mixer2_res_q_2"      , 0x0002bf94, 29, 20},
{"BB_agc_dig_dc_status_q_0_b2", "dig_dc_mixer1_res_q_2"      , 0x0002bf94, 19, 10},
{"BB_agc_dig_dc_status_q_0_b2", "dig_dc_mixer0_res_q_2"      , 0x0002bf94, 9 , 0 },
{"BB_agc_dig_dc_status_q_1_b2", "resdc_sw_write4_2"          , 0x0002bf98, 30, 30},
{"BB_agc_dig_dc_status_q_1_b2", "dig_dc_mixer1_loopback_res_q_2", 0x0002bf98, 29, 20},
{"BB_agc_dig_dc_status_q_1_b2", "dig_dc_mixer0_loopback_res_q_2", 0x0002bf98, 19, 10},
{"BB_agc_dig_dc_status_q_1_b2", "dig_dc_mixer3_res_q_2"      , 0x0002bf98, 9 , 0 },
{"BB_agc_dig_dc_status_q_2_b2", "resdc_sw_write5_2"          , 0x0002bf9c, 30, 30},
{"BB_agc_dig_dc_status_q_2_b2", "dig_dc_mixer3_loopback_res_q_2", 0x0002bf9c, 19, 10},
{"BB_agc_dig_dc_status_q_2_b2", "dig_dc_mixer2_loopback_res_q_2", 0x0002bf9c, 9 , 0 },
{"BB_dc_cal_status_b2", "offsetC3Q_2"                        , 0x0002bfa0, 29, 25},
{"BB_dc_cal_status_b2", "offsetC3I_2"                        , 0x0002bfa0, 24, 20},
{"BB_dc_cal_status_b2", "offsetC2Q_2"                        , 0x0002bfa0, 19, 15},
{"BB_dc_cal_status_b2", "offsetC2I_2"                        , 0x0002bfa0, 14, 10},
{"BB_dc_cal_status_b2", "offsetC1Q_2"                        , 0x0002bfa0, 9 , 5 },
{"BB_dc_cal_status_b2", "offsetC1I_2"                        , 0x0002bfa0, 4 , 0 },
{"BB_switch_table_chn_b2", "switch_table_b_2"                , 0x0002c284, 11, 10},
{"BB_switch_table_chn_b2", "switch_table_rx12_2"             , 0x0002c284, 9 , 8 },
{"BB_switch_table_chn_b2", "switch_table_rx1_2"              , 0x0002c284, 7 , 6 },
{"BB_switch_table_chn_b2", "switch_table_r_2"                , 0x0002c284, 5 , 4 },
{"BB_switch_table_chn_b2", "switch_table_t_2"                , 0x0002c284, 3 , 2 },
{"BB_switch_table_chn_b2", "switch_table_idle_2"             , 0x0002c284, 1 , 0 },
{"BB_fcal_2_b2", "flc_cap_val_status_2"                      , 0x0002c2d0, 24, 20},
{"BB_fcal_2_b2", "flc_sw_cap_val_2"                          , 0x0002c2d0, 7 , 3 },
{"BB_dft_tone_ctrl_b2", "dft_tone_freq_ang_2"                , 0x0002c2d4, 12, 4 },
{"BB_dft_tone_ctrl_b2", "dft_tone_amp_sel_2"                 , 0x0002c2d4, 3 , 2 },
{"BB_dft_tone_ctrl_b2", "dft_tone_en_2"                      , 0x0002c2d4, 0 , 0 },
{"BB_cl_map_0_b2", "cl_map_0"                                , 0x0002c2dc, 31, 0 },
{"BB_cl_map_1_b2", "cl_map_1"                                , 0x0002c2e0, 31, 0 },
{"BB_cl_map_2_b2", "cl_map_2"                                , 0x0002c2e4, 31, 0 },
{"BB_cl_map_3_b2", "cl_map_3"                                , 0x0002c2e8, 31, 0 },
{"BB_cl_tab_b2[0]", "bb_gain"                                , 0x0002c300, 30, 27},
{"BB_cl_tab_b2[0]", "carr_lk_dc_add_I"                       , 0x0002c300, 26, 16},
{"BB_cl_tab_b2[0]", "carr_lk_dc_add_Q"                       , 0x0002c300, 15, 5 },
{"BB_cl_tab_b2[0]", "cl_gain_mod"                            , 0x0002c300, 4 , 0 },
{"BB_cl_tab_b2[1]", "bb_gain"                                , 0x0002c304, 30, 27},
{"BB_cl_tab_b2[1]", "carr_lk_dc_add_I"                       , 0x0002c304, 26, 16},
{"BB_cl_tab_b2[1]", "carr_lk_dc_add_Q"                       , 0x0002c304, 15, 5 },
{"BB_cl_tab_b2[1]", "cl_gain_mod"                            , 0x0002c304, 4 , 0 },
{"BB_cl_tab_b2[2]", "bb_gain"                                , 0x0002c308, 30, 27},
{"BB_cl_tab_b2[2]", "carr_lk_dc_add_I"                       , 0x0002c308, 26, 16},
{"BB_cl_tab_b2[2]", "carr_lk_dc_add_Q"                       , 0x0002c308, 15, 5 },
{"BB_cl_tab_b2[2]", "cl_gain_mod"                            , 0x0002c308, 4 , 0 },
{"BB_cl_tab_b2[3]", "bb_gain"                                , 0x0002c30c, 30, 27},
{"BB_cl_tab_b2[3]", "carr_lk_dc_add_I"                       , 0x0002c30c, 26, 16},
{"BB_cl_tab_b2[3]", "carr_lk_dc_add_Q"                       , 0x0002c30c, 15, 5 },
{"BB_cl_tab_b2[3]", "cl_gain_mod"                            , 0x0002c30c, 4 , 0 },
{"BB_cl_tab_b2[4]", "bb_gain"                                , 0x0002c310, 30, 27},
{"BB_cl_tab_b2[4]", "carr_lk_dc_add_I"                       , 0x0002c310, 26, 16},
{"BB_cl_tab_b2[4]", "carr_lk_dc_add_Q"                       , 0x0002c310, 15, 5 },
{"BB_cl_tab_b2[4]", "cl_gain_mod"                            , 0x0002c310, 4 , 0 },
{"BB_cl_tab_b2[5]", "bb_gain"                                , 0x0002c314, 30, 27},
{"BB_cl_tab_b2[5]", "carr_lk_dc_add_I"                       , 0x0002c314, 26, 16},
{"BB_cl_tab_b2[5]", "carr_lk_dc_add_Q"                       , 0x0002c314, 15, 5 },
{"BB_cl_tab_b2[5]", "cl_gain_mod"                            , 0x0002c314, 4 , 0 },
{"BB_cl_tab_b2[6]", "bb_gain"                                , 0x0002c318, 30, 27},
{"BB_cl_tab_b2[6]", "carr_lk_dc_add_I"                       , 0x0002c318, 26, 16},
{"BB_cl_tab_b2[6]", "carr_lk_dc_add_Q"                       , 0x0002c318, 15, 5 },
{"BB_cl_tab_b2[6]", "cl_gain_mod"                            , 0x0002c318, 4 , 0 },
{"BB_cl_tab_b2[7]", "bb_gain"                                , 0x0002c31c, 30, 27},
{"BB_cl_tab_b2[7]", "carr_lk_dc_add_I"                       , 0x0002c31c, 26, 16},
{"BB_cl_tab_b2[7]", "carr_lk_dc_add_Q"                       , 0x0002c31c, 15, 5 },
{"BB_cl_tab_b2[7]", "cl_gain_mod"                            , 0x0002c31c, 4 , 0 },
{"BB_cl_tab_b2[8]", "bb_gain"                                , 0x0002c320, 30, 27},
{"BB_cl_tab_b2[8]", "carr_lk_dc_add_I"                       , 0x0002c320, 26, 16},
{"BB_cl_tab_b2[8]", "carr_lk_dc_add_Q"                       , 0x0002c320, 15, 5 },
{"BB_cl_tab_b2[8]", "cl_gain_mod"                            , 0x0002c320, 4 , 0 },
{"BB_cl_tab_b2[9]", "bb_gain"                                , 0x0002c324, 30, 27},
{"BB_cl_tab_b2[9]", "carr_lk_dc_add_I"                       , 0x0002c324, 26, 16},
{"BB_cl_tab_b2[9]", "carr_lk_dc_add_Q"                       , 0x0002c324, 15, 5 },
{"BB_cl_tab_b2[9]", "cl_gain_mod"                            , 0x0002c324, 4 , 0 },
{"BB_cl_tab_b2[10]", "bb_gain"                               , 0x0002c328, 30, 27},
{"BB_cl_tab_b2[10]", "carr_lk_dc_add_I"                      , 0x0002c328, 26, 16},
{"BB_cl_tab_b2[10]", "carr_lk_dc_add_Q"                      , 0x0002c328, 15, 5 },
{"BB_cl_tab_b2[10]", "cl_gain_mod"                           , 0x0002c328, 4 , 0 },
{"BB_cl_tab_b2[11]", "bb_gain"                               , 0x0002c32c, 30, 27},
{"BB_cl_tab_b2[11]", "carr_lk_dc_add_I"                      , 0x0002c32c, 26, 16},
{"BB_cl_tab_b2[11]", "carr_lk_dc_add_Q"                      , 0x0002c32c, 15, 5 },
{"BB_cl_tab_b2[11]", "cl_gain_mod"                           , 0x0002c32c, 4 , 0 },
{"BB_cl_tab_b2[12]", "bb_gain"                               , 0x0002c330, 30, 27},
{"BB_cl_tab_b2[12]", "carr_lk_dc_add_I"                      , 0x0002c330, 26, 16},
{"BB_cl_tab_b2[12]", "carr_lk_dc_add_Q"                      , 0x0002c330, 15, 5 },
{"BB_cl_tab_b2[12]", "cl_gain_mod"                           , 0x0002c330, 4 , 0 },
{"BB_cl_tab_b2[13]", "bb_gain"                               , 0x0002c334, 30, 27},
{"BB_cl_tab_b2[13]", "carr_lk_dc_add_I"                      , 0x0002c334, 26, 16},
{"BB_cl_tab_b2[13]", "carr_lk_dc_add_Q"                      , 0x0002c334, 15, 5 },
{"BB_cl_tab_b2[13]", "cl_gain_mod"                           , 0x0002c334, 4 , 0 },
{"BB_cl_tab_b2[14]", "bb_gain"                               , 0x0002c338, 30, 27},
{"BB_cl_tab_b2[14]", "carr_lk_dc_add_I"                      , 0x0002c338, 26, 16},
{"BB_cl_tab_b2[14]", "carr_lk_dc_add_Q"                      , 0x0002c338, 15, 5 },
{"BB_cl_tab_b2[14]", "cl_gain_mod"                           , 0x0002c338, 4 , 0 },
{"BB_cl_tab_b2[15]", "bb_gain"                               , 0x0002c33c, 30, 27},
{"BB_cl_tab_b2[15]", "carr_lk_dc_add_I"                      , 0x0002c33c, 26, 16},
{"BB_cl_tab_b2[15]", "carr_lk_dc_add_Q"                      , 0x0002c33c, 15, 5 },
{"BB_cl_tab_b2[15]", "cl_gain_mod"                           , 0x0002c33c, 4 , 0 },
{"BB_chan_info_gain_b2", "chan_info_xatten2_sw_2"            , 0x0002c380, 24, 24},
{"BB_chan_info_gain_b2", "chan_info_xatten1_sw_2"            , 0x0002c380, 23, 23},
{"BB_chan_info_gain_b2", "chan_info_mb_gain_2"               , 0x0002c380, 22, 16},
{"BB_chan_info_gain_b2", "chan_info_rf_gain_2"               , 0x0002c380, 15, 8 },
{"BB_chan_info_gain_b2", "chan_info_rssi_2"                  , 0x0002c380, 7 , 0 },
{"BB_tpc_4_b2", "rate_sent_2"                                , 0x0002c404, 24, 20},
{"BB_tpc_4_b2", "tx_gain_setting_2"                          , 0x0002c404, 19, 14},
{"BB_tpc_4_b2", "dac_gain_2"                                 , 0x0002c404, 13, 9 },
{"BB_tpc_4_b2", "pd_avg_out_2"                               , 0x0002c404, 8 , 1 },
{"BB_tpc_4_b2", "pd_avg_valid_2"                             , 0x0002c404, 0 , 0 },
{"BB_tpc_5_b2", "pd_gain_boundary_4_2"                       , 0x0002c408, 27, 22},
{"BB_tpc_5_b2", "pd_gain_boundary_3_2"                       , 0x0002c408, 21, 16},
{"BB_tpc_5_b2", "pd_gain_boundary_2_2"                       , 0x0002c408, 15, 10},
{"BB_tpc_5_b2", "pd_gain_boundary_1_2"                       , 0x0002c408, 9 , 4 },
{"BB_tpc_6_b2", "error_est_filter_coeff"                     , 0x0002c40c, 28, 26},
{"BB_tpc_6_b2", "error_est_mode"                             , 0x0002c40c, 25, 24},
{"BB_tpc_6_b2", "pd_dac_setting_4_2"                         , 0x0002c40c, 23, 18},
{"BB_tpc_6_b2", "pd_dac_setting_3_2"                         , 0x0002c40c, 17, 12},
{"BB_tpc_6_b2", "pd_dac_setting_2_2"                         , 0x0002c40c, 11, 6 },
{"BB_tpc_6_b2", "pd_dac_setting_1_2"                         , 0x0002c40c, 5 , 0 },
{"BB_tpc_10_b2", "txgain_idx_cal_b_2"                        , 0x0002c41c, 29, 24},
{"BB_tpc_10_b2", "txgain_idx_cal_a_2"                        , 0x0002c41c, 21, 16},
{"BB_tpc_10_b2", "pwr_meas_cal_b_2"                          , 0x0002c41c, 15, 8 },
{"BB_tpc_10_b2", "pwr_meas_cal_a_2"                          , 0x0002c41c, 7 , 0 },
{"BB_tpc_11_b2", "forced_txgain_idx_2"                       , 0x0002c420, 15, 10},
{"BB_tpc_11_b2", "olpc_gain_delta_2_lsb_ext"                 , 0x0002c420, 9 , 8 },
{"BB_tpc_11_b2", "olpc_gain_delta_2"                         , 0x0002c420, 7 , 0 },
{"BB_tpc_19_b2", "alpha_volt_2"                              , 0x0002c440, 14, 8 },
{"BB_tpc_19_b2", "alpha_therm_2"                             , 0x0002c440, 7 , 0 },
{"BB_pdadc_tab_b2[0]", "tab_entry"                           , 0x0002c480, 31, 0 },
{"BB_pdadc_tab_b2[1]", "tab_entry"                           , 0x0002c484, 31, 0 },
{"BB_pdadc_tab_b2[2]", "tab_entry"                           , 0x0002c488, 31, 0 },
{"BB_pdadc_tab_b2[3]", "tab_entry"                           , 0x0002c48c, 31, 0 },
{"BB_pdadc_tab_b2[4]", "tab_entry"                           , 0x0002c490, 31, 0 },
{"BB_pdadc_tab_b2[5]", "tab_entry"                           , 0x0002c494, 31, 0 },
{"BB_pdadc_tab_b2[6]", "tab_entry"                           , 0x0002c498, 31, 0 },
{"BB_pdadc_tab_b2[7]", "tab_entry"                           , 0x0002c49c, 31, 0 },
{"BB_pdadc_tab_b2[8]", "tab_entry"                           , 0x0002c4a0, 31, 0 },
{"BB_pdadc_tab_b2[9]", "tab_entry"                           , 0x0002c4a4, 31, 0 },
{"BB_pdadc_tab_b2[10]", "tab_entry"                          , 0x0002c4a8, 31, 0 },
{"BB_pdadc_tab_b2[11]", "tab_entry"                          , 0x0002c4ac, 31, 0 },
{"BB_pdadc_tab_b2[12]", "tab_entry"                          , 0x0002c4b0, 31, 0 },
{"BB_pdadc_tab_b2[13]", "tab_entry"                          , 0x0002c4b4, 31, 0 },
{"BB_pdadc_tab_b2[14]", "tab_entry"                          , 0x0002c4b8, 31, 0 },
{"BB_pdadc_tab_b2[15]", "tab_entry"                          , 0x0002c4bc, 31, 0 },
{"BB_pdadc_tab_b2[16]", "tab_entry"                          , 0x0002c4c0, 31, 0 },
{"BB_pdadc_tab_b2[17]", "tab_entry"                          , 0x0002c4c4, 31, 0 },
{"BB_pdadc_tab_b2[18]", "tab_entry"                          , 0x0002c4c8, 31, 0 },
{"BB_pdadc_tab_b2[19]", "tab_entry"                          , 0x0002c4cc, 31, 0 },
{"BB_pdadc_tab_b2[20]", "tab_entry"                          , 0x0002c4d0, 31, 0 },
{"BB_pdadc_tab_b2[21]", "tab_entry"                          , 0x0002c4d4, 31, 0 },
{"BB_pdadc_tab_b2[22]", "tab_entry"                          , 0x0002c4d8, 31, 0 },
{"BB_pdadc_tab_b2[23]", "tab_entry"                          , 0x0002c4dc, 31, 0 },
{"BB_pdadc_tab_b2[24]", "tab_entry"                          , 0x0002c4e0, 31, 0 },
{"BB_pdadc_tab_b2[25]", "tab_entry"                          , 0x0002c4e4, 31, 0 },
{"BB_pdadc_tab_b2[26]", "tab_entry"                          , 0x0002c4e8, 31, 0 },
{"BB_pdadc_tab_b2[27]", "tab_entry"                          , 0x0002c4ec, 31, 0 },
{"BB_pdadc_tab_b2[28]", "tab_entry"                          , 0x0002c4f0, 31, 0 },
{"BB_pdadc_tab_b2[29]", "tab_entry"                          , 0x0002c4f4, 31, 0 },
{"BB_pdadc_tab_b2[30]", "tab_entry"                          , 0x0002c4f8, 31, 0 },
{"BB_pdadc_tab_b2[31]", "tab_entry"                          , 0x0002c4fc, 31, 0 },
{"BB_rtt_table_sw_intf_b2", "sw_rtt_table_addr_offset_2"     , 0x0002c584, 5 , 5 },
{"BB_rtt_table_sw_intf_b2", "sw_rtt_table_addr_2"            , 0x0002c584, 4 , 2 },
{"BB_rtt_table_sw_intf_b2", "sw_rtt_table_write_2"           , 0x0002c584, 1 , 1 },
{"BB_rtt_table_sw_intf_b2", "sw_rtt_table_access_2"          , 0x0002c584, 0 , 0 },
{"BB_rtt_table_sw_intf_1_b2", "sw_rtt_table_data_2"          , 0x0002c588, 31, 0 },
{"BB_txiqcal_status_b2", "last_meas_addr_2"                  , 0x0002c68c, 23, 18},
{"BB_txiqcal_status_b2", "rx_gain_used_2"                    , 0x0002c68c, 17, 12},
{"BB_txiqcal_status_b2", "tone_gain_used_2"                  , 0x0002c68c, 11, 6 },
{"BB_txiqcal_status_b2", "calibrated_gains_2"                , 0x0002c68c, 5 , 1 },
{"BB_txiqcal_status_b2", "txiqcal_failed_2"                  , 0x0002c68c, 0 , 0 },
{"BB_rxiqcal_status_b2", "rxiqcal_last_meas_addr_2"          , 0x0002c6ac, 16, 11},
{"BB_rxiqcal_status_b2", "rxiqcal_txgain_idx_used_2"         , 0x0002c6ac, 10, 6 },
{"BB_rxiqcal_status_b2", "rxiqcal_calibrated_gains_2"        , 0x0002c6ac, 5 , 1 },
{"BB_rxiqcal_status_b2", "rxiqcal_failed_2"                  , 0x0002c6ac, 0 , 0 },
{"BB_aic_ctrl_0_b2", "aic_mon_enable_2"                      , 0x0002c6b0, 31, 31},
{"BB_aic_ctrl_0_b2", "aic_cal_ch_valid_reset_2"              , 0x0002c6b0, 9 , 9 },
{"BB_aic_ctrl_0_b2", "aic_cal_enable_2"                      , 0x0002c6b0, 8 , 8 },
{"BB_aic_ctrl_0_b2", "aic_bttx_pwr_thr_2"                    , 0x0002c6b0, 7 , 1 },
{"BB_aic_ctrl_0_b2", "aic_enable_2"                          , 0x0002c6b0, 0 , 0 },
{"BB_aic_ctrl_1_b2", "aic_rssi_max_2"                        , 0x0002c6b4, 7 , 4 },
{"BB_aic_ctrl_1_b2", "aic_rssi_min_2"                        , 0x0002c6b4, 3 , 0 },
{"BB_aic_ctrl_4_b2", "aic_cal_rot_att_db_est_iso_2"          , 0x0002c6c0, 15, 13},
{"BB_aic_ctrl_4_b2", "aic_cal_com_att_db_est_iso_2"          , 0x0002c6c0, 12, 9 },
{"BB_aic_ctrl_4_b2", "aic_cal_iso_est_init_setting_2"        , 0x0002c6c0, 8 , 3 },
{"BB_aic_ctrl_4_b2", "aic_cal_com_att_db_backoff_2"          , 0x0002c6c0, 2 , 1 },
{"BB_aic_ctrl_4_b2", "aic_cal_com_att_db_fixed_2"            , 0x0002c6c0, 0 , 0 },
{"BB_aic_stat_0_b2", "aic_meas_count_2"                      , 0x0002c6c4, 29, 24},
{"BB_aic_stat_0_b2", "aic_cal_ant_iso_est_2"                 , 0x0002c6c4, 23, 18},
{"BB_aic_stat_0_b2", "aic_cal_hop_count_2"                   , 0x0002c6c4, 17, 11},
{"BB_aic_stat_0_b2", "aic_cal_valid_count_2"                 , 0x0002c6c4, 10, 4 },
{"BB_aic_stat_0_b2", "aic_cal_bt_too_weak_err_2"             , 0x0002c6c4, 3 , 3 },
{"BB_aic_stat_0_b2", "aic_cal_bt_too_strong_err_2"           , 0x0002c6c4, 2 , 2 },
{"BB_aic_stat_0_b2", "aic_cal_done_2"                        , 0x0002c6c4, 1 , 1 },
{"BB_aic_stat_0_b2", "aic_cal_active_2"                      , 0x0002c6c4, 0 , 0 },
{"BB_aic_stat_1_b2", "aic_meas_mag_min_2"                    , 0x0002c6c8, 23, 14},
{"BB_aic_stat_1_b2", "aic_chunk_count_2"                     , 0x0002c6c8, 13, 8 },
{"BB_aic_stat_1_b2", "r_cal_aic_sm_2"                        , 0x0002c6c8, 7 , 3 },
{"BB_aic_stat_1_b2", "r_aic_sm_2"                            , 0x0002c6c8, 2 , 0 },
{"BB_aic_stat_2_b2", "r_mon_aic_sm_2"                        , 0x0002c6cc, 25, 23},
{"BB_aic_stat_2_b2", "aic_mon_est_pwr_ratio_2"               , 0x0002c6cc, 22, 16},
{"BB_aic_stat_2_b2", "aic_mon_stale_count_2"                 , 0x0002c6cc, 15, 9 },
{"BB_aic_stat_2_b2", "aic_mon_hop_count_2"                   , 0x0002c6cc, 8 , 2 },
{"BB_aic_stat_2_b2", "aic_mon_done_2"                        , 0x0002c6cc, 1 , 1 },
{"BB_aic_stat_2_b2", "aic_mon_active_2"                      , 0x0002c6cc, 0 , 0 },
{"BB_tables_intf_addr_b2", "addr_auto_incr_2"                , 0x0002c7f0, 31, 31},
{"BB_tables_intf_addr_b2", "tables_addr_2"                   , 0x0002c7f0, 17, 2 },
{"BB_tables_intf_data_b2", "tables_data_2"                   , 0x0002c7f4, 31, 0 },
{"BB_rssi_b3", "rssi_ext80_3"                                , 0x0002cf80, 31, 24},
{"BB_rssi_b3", "rssi_ext40_3"                                , 0x0002cf80, 23, 16},
{"BB_rssi_b3", "rssi_ext20_3"                                , 0x0002cf80, 15, 8 },
{"BB_rssi_b3", "rssi_pri20_3"                                , 0x0002cf80, 7 , 0 },
{"MAC_PCU_BUF[0]", "DATA"                                    , 0x0002e000, 31, 0 },
{"MAC_PCU_BUF[1]", "DATA"                                    , 0x0002e004, 31, 0 },
{"MAC_PCU_BUF[2]", "DATA"                                    , 0x0002e008, 31, 0 },
{"MAC_PCU_BUF[3]", "DATA"                                    , 0x0002e00c, 31, 0 },
{"MAC_PCU_BUF[4]", "DATA"                                    , 0x0002e010, 31, 0 },
{"MAC_PCU_BUF[5]", "DATA"                                    , 0x0002e014, 31, 0 },
{"MAC_PCU_BUF[6]", "DATA"                                    , 0x0002e018, 31, 0 },
{"MAC_PCU_BUF[7]", "DATA"                                    , 0x0002e01c, 31, 0 },
{"MAC_PCU_BUF[8]", "DATA"                                    , 0x0002e020, 31, 0 },
{"MAC_PCU_BUF[9]", "DATA"                                    , 0x0002e024, 31, 0 },
{"MAC_PCU_BUF[10]", "DATA"                                   , 0x0002e028, 31, 0 },
{"MAC_PCU_BUF[11]", "DATA"                                   , 0x0002e02c, 31, 0 },
{"MAC_PCU_BUF[12]", "DATA"                                   , 0x0002e030, 31, 0 },
{"MAC_PCU_BUF[13]", "DATA"                                   , 0x0002e034, 31, 0 },
{"MAC_PCU_BUF[14]", "DATA"                                   , 0x0002e038, 31, 0 },
{"MAC_PCU_BUF[15]", "DATA"                                   , 0x0002e03c, 31, 0 },
{"MAC_PCU_BUF[16]", "DATA"                                   , 0x0002e040, 31, 0 },
{"MAC_PCU_BUF[17]", "DATA"                                   , 0x0002e044, 31, 0 },
{"MAC_PCU_BUF[18]", "DATA"                                   , 0x0002e048, 31, 0 },
{"MAC_PCU_BUF[19]", "DATA"                                   , 0x0002e04c, 31, 0 },
{"MAC_PCU_BUF[20]", "DATA"                                   , 0x0002e050, 31, 0 },
{"MAC_PCU_BUF[21]", "DATA"                                   , 0x0002e054, 31, 0 },
{"MAC_PCU_BUF[22]", "DATA"                                   , 0x0002e058, 31, 0 },
{"MAC_PCU_BUF[23]", "DATA"                                   , 0x0002e05c, 31, 0 },
{"MAC_PCU_BUF[24]", "DATA"                                   , 0x0002e060, 31, 0 },
{"MAC_PCU_BUF[25]", "DATA"                                   , 0x0002e064, 31, 0 },
{"MAC_PCU_BUF[26]", "DATA"                                   , 0x0002e068, 31, 0 },
{"MAC_PCU_BUF[27]", "DATA"                                   , 0x0002e06c, 31, 0 },
{"MAC_PCU_BUF[28]", "DATA"                                   , 0x0002e070, 31, 0 },
{"MAC_PCU_BUF[29]", "DATA"                                   , 0x0002e074, 31, 0 },
{"MAC_PCU_BUF[30]", "DATA"                                   , 0x0002e078, 31, 0 },
{"MAC_PCU_BUF[31]", "DATA"                                   , 0x0002e07c, 31, 0 },
{"MAC_PCU_BUF[32]", "DATA"                                   , 0x0002e080, 31, 0 },
{"MAC_PCU_BUF[33]", "DATA"                                   , 0x0002e084, 31, 0 },
{"MAC_PCU_BUF[34]", "DATA"                                   , 0x0002e088, 31, 0 },
{"MAC_PCU_BUF[35]", "DATA"                                   , 0x0002e08c, 31, 0 },
{"MAC_PCU_BUF[36]", "DATA"                                   , 0x0002e090, 31, 0 },
{"MAC_PCU_BUF[37]", "DATA"                                   , 0x0002e094, 31, 0 },
{"MAC_PCU_BUF[38]", "DATA"                                   , 0x0002e098, 31, 0 },
{"MAC_PCU_BUF[39]", "DATA"                                   , 0x0002e09c, 31, 0 },
{"MAC_PCU_BUF[40]", "DATA"                                   , 0x0002e0a0, 31, 0 },
{"MAC_PCU_BUF[41]", "DATA"                                   , 0x0002e0a4, 31, 0 },
{"MAC_PCU_BUF[42]", "DATA"                                   , 0x0002e0a8, 31, 0 },
{"MAC_PCU_BUF[43]", "DATA"                                   , 0x0002e0ac, 31, 0 },
{"MAC_PCU_BUF[44]", "DATA"                                   , 0x0002e0b0, 31, 0 },
{"MAC_PCU_BUF[45]", "DATA"                                   , 0x0002e0b4, 31, 0 },
{"MAC_PCU_BUF[46]", "DATA"                                   , 0x0002e0b8, 31, 0 },
{"MAC_PCU_BUF[47]", "DATA"                                   , 0x0002e0bc, 31, 0 },
{"MAC_PCU_BUF[48]", "DATA"                                   , 0x0002e0c0, 31, 0 },
{"MAC_PCU_BUF[49]", "DATA"                                   , 0x0002e0c4, 31, 0 },
{"MAC_PCU_BUF[50]", "DATA"                                   , 0x0002e0c8, 31, 0 },
{"MAC_PCU_BUF[51]", "DATA"                                   , 0x0002e0cc, 31, 0 },
{"MAC_PCU_BUF[52]", "DATA"                                   , 0x0002e0d0, 31, 0 },
{"MAC_PCU_BUF[53]", "DATA"                                   , 0x0002e0d4, 31, 0 },
{"MAC_PCU_BUF[54]", "DATA"                                   , 0x0002e0d8, 31, 0 },
{"MAC_PCU_BUF[55]", "DATA"                                   , 0x0002e0dc, 31, 0 },
{"MAC_PCU_BUF[56]", "DATA"                                   , 0x0002e0e0, 31, 0 },
{"MAC_PCU_BUF[57]", "DATA"                                   , 0x0002e0e4, 31, 0 },
{"MAC_PCU_BUF[58]", "DATA"                                   , 0x0002e0e8, 31, 0 },
{"MAC_PCU_BUF[59]", "DATA"                                   , 0x0002e0ec, 31, 0 },
{"MAC_PCU_BUF[60]", "DATA"                                   , 0x0002e0f0, 31, 0 },
{"MAC_PCU_BUF[61]", "DATA"                                   , 0x0002e0f4, 31, 0 },
{"MAC_PCU_BUF[62]", "DATA"                                   , 0x0002e0f8, 31, 0 },
{"MAC_PCU_BUF[63]", "DATA"                                   , 0x0002e0fc, 31, 0 },
{"MAC_PCU_BUF[64]", "DATA"                                   , 0x0002e100, 31, 0 },
{"MAC_PCU_BUF[65]", "DATA"                                   , 0x0002e104, 31, 0 },
{"MAC_PCU_BUF[66]", "DATA"                                   , 0x0002e108, 31, 0 },
{"MAC_PCU_BUF[67]", "DATA"                                   , 0x0002e10c, 31, 0 },
{"MAC_PCU_BUF[68]", "DATA"                                   , 0x0002e110, 31, 0 },
{"MAC_PCU_BUF[69]", "DATA"                                   , 0x0002e114, 31, 0 },
{"MAC_PCU_BUF[70]", "DATA"                                   , 0x0002e118, 31, 0 },
{"MAC_PCU_BUF[71]", "DATA"                                   , 0x0002e11c, 31, 0 },
{"MAC_PCU_BUF[72]", "DATA"                                   , 0x0002e120, 31, 0 },
{"MAC_PCU_BUF[73]", "DATA"                                   , 0x0002e124, 31, 0 },
{"MAC_PCU_BUF[74]", "DATA"                                   , 0x0002e128, 31, 0 },
{"MAC_PCU_BUF[75]", "DATA"                                   , 0x0002e12c, 31, 0 },
{"MAC_PCU_BUF[76]", "DATA"                                   , 0x0002e130, 31, 0 },
{"MAC_PCU_BUF[77]", "DATA"                                   , 0x0002e134, 31, 0 },
{"MAC_PCU_BUF[78]", "DATA"                                   , 0x0002e138, 31, 0 },
{"MAC_PCU_BUF[79]", "DATA"                                   , 0x0002e13c, 31, 0 },
{"MAC_PCU_BUF[80]", "DATA"                                   , 0x0002e140, 31, 0 },
{"MAC_PCU_BUF[81]", "DATA"                                   , 0x0002e144, 31, 0 },
{"MAC_PCU_BUF[82]", "DATA"                                   , 0x0002e148, 31, 0 },
{"MAC_PCU_BUF[83]", "DATA"                                   , 0x0002e14c, 31, 0 },
{"MAC_PCU_BUF[84]", "DATA"                                   , 0x0002e150, 31, 0 },
{"MAC_PCU_BUF[85]", "DATA"                                   , 0x0002e154, 31, 0 },
{"MAC_PCU_BUF[86]", "DATA"                                   , 0x0002e158, 31, 0 },
{"MAC_PCU_BUF[87]", "DATA"                                   , 0x0002e15c, 31, 0 },
{"MAC_PCU_BUF[88]", "DATA"                                   , 0x0002e160, 31, 0 },
{"MAC_PCU_BUF[89]", "DATA"                                   , 0x0002e164, 31, 0 },
{"MAC_PCU_BUF[90]", "DATA"                                   , 0x0002e168, 31, 0 },
{"MAC_PCU_BUF[91]", "DATA"                                   , 0x0002e16c, 31, 0 },
{"MAC_PCU_BUF[92]", "DATA"                                   , 0x0002e170, 31, 0 },
{"MAC_PCU_BUF[93]", "DATA"                                   , 0x0002e174, 31, 0 },
{"MAC_PCU_BUF[94]", "DATA"                                   , 0x0002e178, 31, 0 },
{"MAC_PCU_BUF[95]", "DATA"                                   , 0x0002e17c, 31, 0 },
{"MAC_PCU_BUF[96]", "DATA"                                   , 0x0002e180, 31, 0 },
{"MAC_PCU_BUF[97]", "DATA"                                   , 0x0002e184, 31, 0 },
{"MAC_PCU_BUF[98]", "DATA"                                   , 0x0002e188, 31, 0 },
{"MAC_PCU_BUF[99]", "DATA"                                   , 0x0002e18c, 31, 0 },
{"MAC_PCU_BUF[100]", "DATA"                                  , 0x0002e190, 31, 0 },
{"MAC_PCU_BUF[101]", "DATA"                                  , 0x0002e194, 31, 0 },
{"MAC_PCU_BUF[102]", "DATA"                                  , 0x0002e198, 31, 0 },
{"MAC_PCU_BUF[103]", "DATA"                                  , 0x0002e19c, 31, 0 },
{"MAC_PCU_BUF[104]", "DATA"                                  , 0x0002e1a0, 31, 0 },
{"MAC_PCU_BUF[105]", "DATA"                                  , 0x0002e1a4, 31, 0 },
{"MAC_PCU_BUF[106]", "DATA"                                  , 0x0002e1a8, 31, 0 },
{"MAC_PCU_BUF[107]", "DATA"                                  , 0x0002e1ac, 31, 0 },
{"MAC_PCU_BUF[108]", "DATA"                                  , 0x0002e1b0, 31, 0 },
{"MAC_PCU_BUF[109]", "DATA"                                  , 0x0002e1b4, 31, 0 },
{"MAC_PCU_BUF[110]", "DATA"                                  , 0x0002e1b8, 31, 0 },
{"MAC_PCU_BUF[111]", "DATA"                                  , 0x0002e1bc, 31, 0 },
{"MAC_PCU_BUF[112]", "DATA"                                  , 0x0002e1c0, 31, 0 },
{"MAC_PCU_BUF[113]", "DATA"                                  , 0x0002e1c4, 31, 0 },
{"MAC_PCU_BUF[114]", "DATA"                                  , 0x0002e1c8, 31, 0 },
{"MAC_PCU_BUF[115]", "DATA"                                  , 0x0002e1cc, 31, 0 },
{"MAC_PCU_BUF[116]", "DATA"                                  , 0x0002e1d0, 31, 0 },
{"MAC_PCU_BUF[117]", "DATA"                                  , 0x0002e1d4, 31, 0 },
{"MAC_PCU_BUF[118]", "DATA"                                  , 0x0002e1d8, 31, 0 },
{"MAC_PCU_BUF[119]", "DATA"                                  , 0x0002e1dc, 31, 0 },
{"MAC_PCU_BUF[120]", "DATA"                                  , 0x0002e1e0, 31, 0 },
{"MAC_PCU_BUF[121]", "DATA"                                  , 0x0002e1e4, 31, 0 },
{"MAC_PCU_BUF[122]", "DATA"                                  , 0x0002e1e8, 31, 0 },
{"MAC_PCU_BUF[123]", "DATA"                                  , 0x0002e1ec, 31, 0 },
{"MAC_PCU_BUF[124]", "DATA"                                  , 0x0002e1f0, 31, 0 },
{"MAC_PCU_BUF[125]", "DATA"                                  , 0x0002e1f4, 31, 0 },
{"MAC_PCU_BUF[126]", "DATA"                                  , 0x0002e1f8, 31, 0 },
{"MAC_PCU_BUF[127]", "DATA"                                  , 0x0002e1fc, 31, 0 },
{"MAC_PCU_BUF[128]", "DATA"                                  , 0x0002e200, 31, 0 },
{"MAC_PCU_BUF[129]", "DATA"                                  , 0x0002e204, 31, 0 },
{"MAC_PCU_BUF[130]", "DATA"                                  , 0x0002e208, 31, 0 },
{"MAC_PCU_BUF[131]", "DATA"                                  , 0x0002e20c, 31, 0 },
{"MAC_PCU_BUF[132]", "DATA"                                  , 0x0002e210, 31, 0 },
{"MAC_PCU_BUF[133]", "DATA"                                  , 0x0002e214, 31, 0 },
{"MAC_PCU_BUF[134]", "DATA"                                  , 0x0002e218, 31, 0 },
{"MAC_PCU_BUF[135]", "DATA"                                  , 0x0002e21c, 31, 0 },
{"MAC_PCU_BUF[136]", "DATA"                                  , 0x0002e220, 31, 0 },
{"MAC_PCU_BUF[137]", "DATA"                                  , 0x0002e224, 31, 0 },
{"MAC_PCU_BUF[138]", "DATA"                                  , 0x0002e228, 31, 0 },
{"MAC_PCU_BUF[139]", "DATA"                                  , 0x0002e22c, 31, 0 },
{"MAC_PCU_BUF[140]", "DATA"                                  , 0x0002e230, 31, 0 },
{"MAC_PCU_BUF[141]", "DATA"                                  , 0x0002e234, 31, 0 },
{"MAC_PCU_BUF[142]", "DATA"                                  , 0x0002e238, 31, 0 },
{"MAC_PCU_BUF[143]", "DATA"                                  , 0x0002e23c, 31, 0 },
{"MAC_PCU_BUF[144]", "DATA"                                  , 0x0002e240, 31, 0 },
{"MAC_PCU_BUF[145]", "DATA"                                  , 0x0002e244, 31, 0 },
{"MAC_PCU_BUF[146]", "DATA"                                  , 0x0002e248, 31, 0 },
{"MAC_PCU_BUF[147]", "DATA"                                  , 0x0002e24c, 31, 0 },
{"MAC_PCU_BUF[148]", "DATA"                                  , 0x0002e250, 31, 0 },
{"MAC_PCU_BUF[149]", "DATA"                                  , 0x0002e254, 31, 0 },
{"MAC_PCU_BUF[150]", "DATA"                                  , 0x0002e258, 31, 0 },
{"MAC_PCU_BUF[151]", "DATA"                                  , 0x0002e25c, 31, 0 },
{"MAC_PCU_BUF[152]", "DATA"                                  , 0x0002e260, 31, 0 },
{"MAC_PCU_BUF[153]", "DATA"                                  , 0x0002e264, 31, 0 },
{"MAC_PCU_BUF[154]", "DATA"                                  , 0x0002e268, 31, 0 },
{"MAC_PCU_BUF[155]", "DATA"                                  , 0x0002e26c, 31, 0 },
{"MAC_PCU_BUF[156]", "DATA"                                  , 0x0002e270, 31, 0 },
{"MAC_PCU_BUF[157]", "DATA"                                  , 0x0002e274, 31, 0 },
{"MAC_PCU_BUF[158]", "DATA"                                  , 0x0002e278, 31, 0 },
{"MAC_PCU_BUF[159]", "DATA"                                  , 0x0002e27c, 31, 0 },
{"MAC_PCU_BUF[160]", "DATA"                                  , 0x0002e280, 31, 0 },
{"MAC_PCU_BUF[161]", "DATA"                                  , 0x0002e284, 31, 0 },
{"MAC_PCU_BUF[162]", "DATA"                                  , 0x0002e288, 31, 0 },
{"MAC_PCU_BUF[163]", "DATA"                                  , 0x0002e28c, 31, 0 },
{"MAC_PCU_BUF[164]", "DATA"                                  , 0x0002e290, 31, 0 },
{"MAC_PCU_BUF[165]", "DATA"                                  , 0x0002e294, 31, 0 },
{"MAC_PCU_BUF[166]", "DATA"                                  , 0x0002e298, 31, 0 },
{"MAC_PCU_BUF[167]", "DATA"                                  , 0x0002e29c, 31, 0 },
{"MAC_PCU_BUF[168]", "DATA"                                  , 0x0002e2a0, 31, 0 },
{"MAC_PCU_BUF[169]", "DATA"                                  , 0x0002e2a4, 31, 0 },
{"MAC_PCU_BUF[170]", "DATA"                                  , 0x0002e2a8, 31, 0 },
{"MAC_PCU_BUF[171]", "DATA"                                  , 0x0002e2ac, 31, 0 },
{"MAC_PCU_BUF[172]", "DATA"                                  , 0x0002e2b0, 31, 0 },
{"MAC_PCU_BUF[173]", "DATA"                                  , 0x0002e2b4, 31, 0 },
{"MAC_PCU_BUF[174]", "DATA"                                  , 0x0002e2b8, 31, 0 },
{"MAC_PCU_BUF[175]", "DATA"                                  , 0x0002e2bc, 31, 0 },
{"MAC_PCU_BUF[176]", "DATA"                                  , 0x0002e2c0, 31, 0 },
{"MAC_PCU_BUF[177]", "DATA"                                  , 0x0002e2c4, 31, 0 },
{"MAC_PCU_BUF[178]", "DATA"                                  , 0x0002e2c8, 31, 0 },
{"MAC_PCU_BUF[179]", "DATA"                                  , 0x0002e2cc, 31, 0 },
{"MAC_PCU_BUF[180]", "DATA"                                  , 0x0002e2d0, 31, 0 },
{"MAC_PCU_BUF[181]", "DATA"                                  , 0x0002e2d4, 31, 0 },
{"MAC_PCU_BUF[182]", "DATA"                                  , 0x0002e2d8, 31, 0 },
{"MAC_PCU_BUF[183]", "DATA"                                  , 0x0002e2dc, 31, 0 },
{"MAC_PCU_BUF[184]", "DATA"                                  , 0x0002e2e0, 31, 0 },
{"MAC_PCU_BUF[185]", "DATA"                                  , 0x0002e2e4, 31, 0 },
{"MAC_PCU_BUF[186]", "DATA"                                  , 0x0002e2e8, 31, 0 },
{"MAC_PCU_BUF[187]", "DATA"                                  , 0x0002e2ec, 31, 0 },
{"MAC_PCU_BUF[188]", "DATA"                                  , 0x0002e2f0, 31, 0 },
{"MAC_PCU_BUF[189]", "DATA"                                  , 0x0002e2f4, 31, 0 },
{"MAC_PCU_BUF[190]", "DATA"                                  , 0x0002e2f8, 31, 0 },
{"MAC_PCU_BUF[191]", "DATA"                                  , 0x0002e2fc, 31, 0 },
{"MAC_PCU_BUF[192]", "DATA"                                  , 0x0002e300, 31, 0 },
{"MAC_PCU_BUF[193]", "DATA"                                  , 0x0002e304, 31, 0 },
{"MAC_PCU_BUF[194]", "DATA"                                  , 0x0002e308, 31, 0 },
{"MAC_PCU_BUF[195]", "DATA"                                  , 0x0002e30c, 31, 0 },
{"MAC_PCU_BUF[196]", "DATA"                                  , 0x0002e310, 31, 0 },
{"MAC_PCU_BUF[197]", "DATA"                                  , 0x0002e314, 31, 0 },
{"MAC_PCU_BUF[198]", "DATA"                                  , 0x0002e318, 31, 0 },
{"MAC_PCU_BUF[199]", "DATA"                                  , 0x0002e31c, 31, 0 },
{"MAC_PCU_BUF[200]", "DATA"                                  , 0x0002e320, 31, 0 },
{"MAC_PCU_BUF[201]", "DATA"                                  , 0x0002e324, 31, 0 },
{"MAC_PCU_BUF[202]", "DATA"                                  , 0x0002e328, 31, 0 },
{"MAC_PCU_BUF[203]", "DATA"                                  , 0x0002e32c, 31, 0 },
{"MAC_PCU_BUF[204]", "DATA"                                  , 0x0002e330, 31, 0 },
{"MAC_PCU_BUF[205]", "DATA"                                  , 0x0002e334, 31, 0 },
{"MAC_PCU_BUF[206]", "DATA"                                  , 0x0002e338, 31, 0 },
{"MAC_PCU_BUF[207]", "DATA"                                  , 0x0002e33c, 31, 0 },
{"MAC_PCU_BUF[208]", "DATA"                                  , 0x0002e340, 31, 0 },
{"MAC_PCU_BUF[209]", "DATA"                                  , 0x0002e344, 31, 0 },
{"MAC_PCU_BUF[210]", "DATA"                                  , 0x0002e348, 31, 0 },
{"MAC_PCU_BUF[211]", "DATA"                                  , 0x0002e34c, 31, 0 },
{"MAC_PCU_BUF[212]", "DATA"                                  , 0x0002e350, 31, 0 },
{"MAC_PCU_BUF[213]", "DATA"                                  , 0x0002e354, 31, 0 },
{"MAC_PCU_BUF[214]", "DATA"                                  , 0x0002e358, 31, 0 },
{"MAC_PCU_BUF[215]", "DATA"                                  , 0x0002e35c, 31, 0 },
{"MAC_PCU_BUF[216]", "DATA"                                  , 0x0002e360, 31, 0 },
{"MAC_PCU_BUF[217]", "DATA"                                  , 0x0002e364, 31, 0 },
{"MAC_PCU_BUF[218]", "DATA"                                  , 0x0002e368, 31, 0 },
{"MAC_PCU_BUF[219]", "DATA"                                  , 0x0002e36c, 31, 0 },
{"MAC_PCU_BUF[220]", "DATA"                                  , 0x0002e370, 31, 0 },
{"MAC_PCU_BUF[221]", "DATA"                                  , 0x0002e374, 31, 0 },
{"MAC_PCU_BUF[222]", "DATA"                                  , 0x0002e378, 31, 0 },
{"MAC_PCU_BUF[223]", "DATA"                                  , 0x0002e37c, 31, 0 },
{"MAC_PCU_BUF[224]", "DATA"                                  , 0x0002e380, 31, 0 },
{"MAC_PCU_BUF[225]", "DATA"                                  , 0x0002e384, 31, 0 },
{"MAC_PCU_BUF[226]", "DATA"                                  , 0x0002e388, 31, 0 },
{"MAC_PCU_BUF[227]", "DATA"                                  , 0x0002e38c, 31, 0 },
{"MAC_PCU_BUF[228]", "DATA"                                  , 0x0002e390, 31, 0 },
{"MAC_PCU_BUF[229]", "DATA"                                  , 0x0002e394, 31, 0 },
{"MAC_PCU_BUF[230]", "DATA"                                  , 0x0002e398, 31, 0 },
{"MAC_PCU_BUF[231]", "DATA"                                  , 0x0002e39c, 31, 0 },
{"MAC_PCU_BUF[232]", "DATA"                                  , 0x0002e3a0, 31, 0 },
{"MAC_PCU_BUF[233]", "DATA"                                  , 0x0002e3a4, 31, 0 },
{"MAC_PCU_BUF[234]", "DATA"                                  , 0x0002e3a8, 31, 0 },
{"MAC_PCU_BUF[235]", "DATA"                                  , 0x0002e3ac, 31, 0 },
{"MAC_PCU_BUF[236]", "DATA"                                  , 0x0002e3b0, 31, 0 },
{"MAC_PCU_BUF[237]", "DATA"                                  , 0x0002e3b4, 31, 0 },
{"MAC_PCU_BUF[238]", "DATA"                                  , 0x0002e3b8, 31, 0 },
{"MAC_PCU_BUF[239]", "DATA"                                  , 0x0002e3bc, 31, 0 },
{"MAC_PCU_BUF[240]", "DATA"                                  , 0x0002e3c0, 31, 0 },
{"MAC_PCU_BUF[241]", "DATA"                                  , 0x0002e3c4, 31, 0 },
{"MAC_PCU_BUF[242]", "DATA"                                  , 0x0002e3c8, 31, 0 },
{"MAC_PCU_BUF[243]", "DATA"                                  , 0x0002e3cc, 31, 0 },
{"MAC_PCU_BUF[244]", "DATA"                                  , 0x0002e3d0, 31, 0 },
{"MAC_PCU_BUF[245]", "DATA"                                  , 0x0002e3d4, 31, 0 },
{"MAC_PCU_BUF[246]", "DATA"                                  , 0x0002e3d8, 31, 0 },
{"MAC_PCU_BUF[247]", "DATA"                                  , 0x0002e3dc, 31, 0 },
{"MAC_PCU_BUF[248]", "DATA"                                  , 0x0002e3e0, 31, 0 },
{"MAC_PCU_BUF[249]", "DATA"                                  , 0x0002e3e4, 31, 0 },
{"MAC_PCU_BUF[250]", "DATA"                                  , 0x0002e3e8, 31, 0 },
{"MAC_PCU_BUF[251]", "DATA"                                  , 0x0002e3ec, 31, 0 },
{"MAC_PCU_BUF[252]", "DATA"                                  , 0x0002e3f0, 31, 0 },
{"MAC_PCU_BUF[253]", "DATA"                                  , 0x0002e3f4, 31, 0 },
{"MAC_PCU_BUF[254]", "DATA"                                  , 0x0002e3f8, 31, 0 },
{"MAC_PCU_BUF[255]", "DATA"                                  , 0x0002e3fc, 31, 0 },
{"MAC_PCU_BUF[256]", "DATA"                                  , 0x0002e400, 31, 0 },
{"MAC_PCU_BUF[257]", "DATA"                                  , 0x0002e404, 31, 0 },
{"MAC_PCU_BUF[258]", "DATA"                                  , 0x0002e408, 31, 0 },
{"MAC_PCU_BUF[259]", "DATA"                                  , 0x0002e40c, 31, 0 },
{"MAC_PCU_BUF[260]", "DATA"                                  , 0x0002e410, 31, 0 },
{"MAC_PCU_BUF[261]", "DATA"                                  , 0x0002e414, 31, 0 },
{"MAC_PCU_BUF[262]", "DATA"                                  , 0x0002e418, 31, 0 },
{"MAC_PCU_BUF[263]", "DATA"                                  , 0x0002e41c, 31, 0 },
{"MAC_PCU_BUF[264]", "DATA"                                  , 0x0002e420, 31, 0 },
{"MAC_PCU_BUF[265]", "DATA"                                  , 0x0002e424, 31, 0 },
{"MAC_PCU_BUF[266]", "DATA"                                  , 0x0002e428, 31, 0 },
{"MAC_PCU_BUF[267]", "DATA"                                  , 0x0002e42c, 31, 0 },
{"MAC_PCU_BUF[268]", "DATA"                                  , 0x0002e430, 31, 0 },
{"MAC_PCU_BUF[269]", "DATA"                                  , 0x0002e434, 31, 0 },
{"MAC_PCU_BUF[270]", "DATA"                                  , 0x0002e438, 31, 0 },
{"MAC_PCU_BUF[271]", "DATA"                                  , 0x0002e43c, 31, 0 },
{"MAC_PCU_BUF[272]", "DATA"                                  , 0x0002e440, 31, 0 },
{"MAC_PCU_BUF[273]", "DATA"                                  , 0x0002e444, 31, 0 },
{"MAC_PCU_BUF[274]", "DATA"                                  , 0x0002e448, 31, 0 },
{"MAC_PCU_BUF[275]", "DATA"                                  , 0x0002e44c, 31, 0 },
{"MAC_PCU_BUF[276]", "DATA"                                  , 0x0002e450, 31, 0 },
{"MAC_PCU_BUF[277]", "DATA"                                  , 0x0002e454, 31, 0 },
{"MAC_PCU_BUF[278]", "DATA"                                  , 0x0002e458, 31, 0 },
{"MAC_PCU_BUF[279]", "DATA"                                  , 0x0002e45c, 31, 0 },
{"MAC_PCU_BUF[280]", "DATA"                                  , 0x0002e460, 31, 0 },
{"MAC_PCU_BUF[281]", "DATA"                                  , 0x0002e464, 31, 0 },
{"MAC_PCU_BUF[282]", "DATA"                                  , 0x0002e468, 31, 0 },
{"MAC_PCU_BUF[283]", "DATA"                                  , 0x0002e46c, 31, 0 },
{"MAC_PCU_BUF[284]", "DATA"                                  , 0x0002e470, 31, 0 },
{"MAC_PCU_BUF[285]", "DATA"                                  , 0x0002e474, 31, 0 },
{"MAC_PCU_BUF[286]", "DATA"                                  , 0x0002e478, 31, 0 },
{"MAC_PCU_BUF[287]", "DATA"                                  , 0x0002e47c, 31, 0 },
{"MAC_PCU_BUF[288]", "DATA"                                  , 0x0002e480, 31, 0 },
{"MAC_PCU_BUF[289]", "DATA"                                  , 0x0002e484, 31, 0 },
{"MAC_PCU_BUF[290]", "DATA"                                  , 0x0002e488, 31, 0 },
{"MAC_PCU_BUF[291]", "DATA"                                  , 0x0002e48c, 31, 0 },
{"MAC_PCU_BUF[292]", "DATA"                                  , 0x0002e490, 31, 0 },
{"MAC_PCU_BUF[293]", "DATA"                                  , 0x0002e494, 31, 0 },
{"MAC_PCU_BUF[294]", "DATA"                                  , 0x0002e498, 31, 0 },
{"MAC_PCU_BUF[295]", "DATA"                                  , 0x0002e49c, 31, 0 },
{"MAC_PCU_BUF[296]", "DATA"                                  , 0x0002e4a0, 31, 0 },
{"MAC_PCU_BUF[297]", "DATA"                                  , 0x0002e4a4, 31, 0 },
{"MAC_PCU_BUF[298]", "DATA"                                  , 0x0002e4a8, 31, 0 },
{"MAC_PCU_BUF[299]", "DATA"                                  , 0x0002e4ac, 31, 0 },
{"MAC_PCU_BUF[300]", "DATA"                                  , 0x0002e4b0, 31, 0 },
{"MAC_PCU_BUF[301]", "DATA"                                  , 0x0002e4b4, 31, 0 },
{"MAC_PCU_BUF[302]", "DATA"                                  , 0x0002e4b8, 31, 0 },
{"MAC_PCU_BUF[303]", "DATA"                                  , 0x0002e4bc, 31, 0 },
{"MAC_PCU_BUF[304]", "DATA"                                  , 0x0002e4c0, 31, 0 },
{"MAC_PCU_BUF[305]", "DATA"                                  , 0x0002e4c4, 31, 0 },
{"MAC_PCU_BUF[306]", "DATA"                                  , 0x0002e4c8, 31, 0 },
{"MAC_PCU_BUF[307]", "DATA"                                  , 0x0002e4cc, 31, 0 },
{"MAC_PCU_BUF[308]", "DATA"                                  , 0x0002e4d0, 31, 0 },
{"MAC_PCU_BUF[309]", "DATA"                                  , 0x0002e4d4, 31, 0 },
{"MAC_PCU_BUF[310]", "DATA"                                  , 0x0002e4d8, 31, 0 },
{"MAC_PCU_BUF[311]", "DATA"                                  , 0x0002e4dc, 31, 0 },
{"MAC_PCU_BUF[312]", "DATA"                                  , 0x0002e4e0, 31, 0 },
{"MAC_PCU_BUF[313]", "DATA"                                  , 0x0002e4e4, 31, 0 },
{"MAC_PCU_BUF[314]", "DATA"                                  , 0x0002e4e8, 31, 0 },
{"MAC_PCU_BUF[315]", "DATA"                                  , 0x0002e4ec, 31, 0 },
{"MAC_PCU_BUF[316]", "DATA"                                  , 0x0002e4f0, 31, 0 },
{"MAC_PCU_BUF[317]", "DATA"                                  , 0x0002e4f4, 31, 0 },
{"MAC_PCU_BUF[318]", "DATA"                                  , 0x0002e4f8, 31, 0 },
{"MAC_PCU_BUF[319]", "DATA"                                  , 0x0002e4fc, 31, 0 },
{"MAC_PCU_BUF[320]", "DATA"                                  , 0x0002e500, 31, 0 },
{"MAC_PCU_BUF[321]", "DATA"                                  , 0x0002e504, 31, 0 },
{"MAC_PCU_BUF[322]", "DATA"                                  , 0x0002e508, 31, 0 },
{"MAC_PCU_BUF[323]", "DATA"                                  , 0x0002e50c, 31, 0 },
{"MAC_PCU_BUF[324]", "DATA"                                  , 0x0002e510, 31, 0 },
{"MAC_PCU_BUF[325]", "DATA"                                  , 0x0002e514, 31, 0 },
{"MAC_PCU_BUF[326]", "DATA"                                  , 0x0002e518, 31, 0 },
{"MAC_PCU_BUF[327]", "DATA"                                  , 0x0002e51c, 31, 0 },
{"MAC_PCU_BUF[328]", "DATA"                                  , 0x0002e520, 31, 0 },
{"MAC_PCU_BUF[329]", "DATA"                                  , 0x0002e524, 31, 0 },
{"MAC_PCU_BUF[330]", "DATA"                                  , 0x0002e528, 31, 0 },
{"MAC_PCU_BUF[331]", "DATA"                                  , 0x0002e52c, 31, 0 },
{"MAC_PCU_BUF[332]", "DATA"                                  , 0x0002e530, 31, 0 },
{"MAC_PCU_BUF[333]", "DATA"                                  , 0x0002e534, 31, 0 },
{"MAC_PCU_BUF[334]", "DATA"                                  , 0x0002e538, 31, 0 },
{"MAC_PCU_BUF[335]", "DATA"                                  , 0x0002e53c, 31, 0 },
{"MAC_PCU_BUF[336]", "DATA"                                  , 0x0002e540, 31, 0 },
{"MAC_PCU_BUF[337]", "DATA"                                  , 0x0002e544, 31, 0 },
{"MAC_PCU_BUF[338]", "DATA"                                  , 0x0002e548, 31, 0 },
{"MAC_PCU_BUF[339]", "DATA"                                  , 0x0002e54c, 31, 0 },
{"MAC_PCU_BUF[340]", "DATA"                                  , 0x0002e550, 31, 0 },
{"MAC_PCU_BUF[341]", "DATA"                                  , 0x0002e554, 31, 0 },
{"MAC_PCU_BUF[342]", "DATA"                                  , 0x0002e558, 31, 0 },
{"MAC_PCU_BUF[343]", "DATA"                                  , 0x0002e55c, 31, 0 },
{"MAC_PCU_BUF[344]", "DATA"                                  , 0x0002e560, 31, 0 },
{"MAC_PCU_BUF[345]", "DATA"                                  , 0x0002e564, 31, 0 },
{"MAC_PCU_BUF[346]", "DATA"                                  , 0x0002e568, 31, 0 },
{"MAC_PCU_BUF[347]", "DATA"                                  , 0x0002e56c, 31, 0 },
{"MAC_PCU_BUF[348]", "DATA"                                  , 0x0002e570, 31, 0 },
{"MAC_PCU_BUF[349]", "DATA"                                  , 0x0002e574, 31, 0 },
{"MAC_PCU_BUF[350]", "DATA"                                  , 0x0002e578, 31, 0 },
{"MAC_PCU_BUF[351]", "DATA"                                  , 0x0002e57c, 31, 0 },
{"MAC_PCU_BUF[352]", "DATA"                                  , 0x0002e580, 31, 0 },
{"MAC_PCU_BUF[353]", "DATA"                                  , 0x0002e584, 31, 0 },
{"MAC_PCU_BUF[354]", "DATA"                                  , 0x0002e588, 31, 0 },
{"MAC_PCU_BUF[355]", "DATA"                                  , 0x0002e58c, 31, 0 },
{"MAC_PCU_BUF[356]", "DATA"                                  , 0x0002e590, 31, 0 },
{"MAC_PCU_BUF[357]", "DATA"                                  , 0x0002e594, 31, 0 },
{"MAC_PCU_BUF[358]", "DATA"                                  , 0x0002e598, 31, 0 },
{"MAC_PCU_BUF[359]", "DATA"                                  , 0x0002e59c, 31, 0 },
{"MAC_PCU_BUF[360]", "DATA"                                  , 0x0002e5a0, 31, 0 },
{"MAC_PCU_BUF[361]", "DATA"                                  , 0x0002e5a4, 31, 0 },
{"MAC_PCU_BUF[362]", "DATA"                                  , 0x0002e5a8, 31, 0 },
{"MAC_PCU_BUF[363]", "DATA"                                  , 0x0002e5ac, 31, 0 },
{"MAC_PCU_BUF[364]", "DATA"                                  , 0x0002e5b0, 31, 0 },
{"MAC_PCU_BUF[365]", "DATA"                                  , 0x0002e5b4, 31, 0 },
{"MAC_PCU_BUF[366]", "DATA"                                  , 0x0002e5b8, 31, 0 },
{"MAC_PCU_BUF[367]", "DATA"                                  , 0x0002e5bc, 31, 0 },
{"MAC_PCU_BUF[368]", "DATA"                                  , 0x0002e5c0, 31, 0 },
{"MAC_PCU_BUF[369]", "DATA"                                  , 0x0002e5c4, 31, 0 },
{"MAC_PCU_BUF[370]", "DATA"                                  , 0x0002e5c8, 31, 0 },
{"MAC_PCU_BUF[371]", "DATA"                                  , 0x0002e5cc, 31, 0 },
{"MAC_PCU_BUF[372]", "DATA"                                  , 0x0002e5d0, 31, 0 },
{"MAC_PCU_BUF[373]", "DATA"                                  , 0x0002e5d4, 31, 0 },
{"MAC_PCU_BUF[374]", "DATA"                                  , 0x0002e5d8, 31, 0 },
{"MAC_PCU_BUF[375]", "DATA"                                  , 0x0002e5dc, 31, 0 },
{"MAC_PCU_BUF[376]", "DATA"                                  , 0x0002e5e0, 31, 0 },
{"MAC_PCU_BUF[377]", "DATA"                                  , 0x0002e5e4, 31, 0 },
{"MAC_PCU_BUF[378]", "DATA"                                  , 0x0002e5e8, 31, 0 },
{"MAC_PCU_BUF[379]", "DATA"                                  , 0x0002e5ec, 31, 0 },
{"MAC_PCU_BUF[380]", "DATA"                                  , 0x0002e5f0, 31, 0 },
{"MAC_PCU_BUF[381]", "DATA"                                  , 0x0002e5f4, 31, 0 },
{"MAC_PCU_BUF[382]", "DATA"                                  , 0x0002e5f8, 31, 0 },
{"MAC_PCU_BUF[383]", "DATA"                                  , 0x0002e5fc, 31, 0 },
{"MAC_PCU_BUF[384]", "DATA"                                  , 0x0002e600, 31, 0 },
{"MAC_PCU_BUF[385]", "DATA"                                  , 0x0002e604, 31, 0 },
{"MAC_PCU_BUF[386]", "DATA"                                  , 0x0002e608, 31, 0 },
{"MAC_PCU_BUF[387]", "DATA"                                  , 0x0002e60c, 31, 0 },
{"MAC_PCU_BUF[388]", "DATA"                                  , 0x0002e610, 31, 0 },
{"MAC_PCU_BUF[389]", "DATA"                                  , 0x0002e614, 31, 0 },
{"MAC_PCU_BUF[390]", "DATA"                                  , 0x0002e618, 31, 0 },
{"MAC_PCU_BUF[391]", "DATA"                                  , 0x0002e61c, 31, 0 },
{"MAC_PCU_BUF[392]", "DATA"                                  , 0x0002e620, 31, 0 },
{"MAC_PCU_BUF[393]", "DATA"                                  , 0x0002e624, 31, 0 },
{"MAC_PCU_BUF[394]", "DATA"                                  , 0x0002e628, 31, 0 },
{"MAC_PCU_BUF[395]", "DATA"                                  , 0x0002e62c, 31, 0 },
{"MAC_PCU_BUF[396]", "DATA"                                  , 0x0002e630, 31, 0 },
{"MAC_PCU_BUF[397]", "DATA"                                  , 0x0002e634, 31, 0 },
{"MAC_PCU_BUF[398]", "DATA"                                  , 0x0002e638, 31, 0 },
{"MAC_PCU_BUF[399]", "DATA"                                  , 0x0002e63c, 31, 0 },
{"MAC_PCU_BUF[400]", "DATA"                                  , 0x0002e640, 31, 0 },
{"MAC_PCU_BUF[401]", "DATA"                                  , 0x0002e644, 31, 0 },
{"MAC_PCU_BUF[402]", "DATA"                                  , 0x0002e648, 31, 0 },
{"MAC_PCU_BUF[403]", "DATA"                                  , 0x0002e64c, 31, 0 },
{"MAC_PCU_BUF[404]", "DATA"                                  , 0x0002e650, 31, 0 },
{"MAC_PCU_BUF[405]", "DATA"                                  , 0x0002e654, 31, 0 },
{"MAC_PCU_BUF[406]", "DATA"                                  , 0x0002e658, 31, 0 },
{"MAC_PCU_BUF[407]", "DATA"                                  , 0x0002e65c, 31, 0 },
{"MAC_PCU_BUF[408]", "DATA"                                  , 0x0002e660, 31, 0 },
{"MAC_PCU_BUF[409]", "DATA"                                  , 0x0002e664, 31, 0 },
{"MAC_PCU_BUF[410]", "DATA"                                  , 0x0002e668, 31, 0 },
{"MAC_PCU_BUF[411]", "DATA"                                  , 0x0002e66c, 31, 0 },
{"MAC_PCU_BUF[412]", "DATA"                                  , 0x0002e670, 31, 0 },
{"MAC_PCU_BUF[413]", "DATA"                                  , 0x0002e674, 31, 0 },
{"MAC_PCU_BUF[414]", "DATA"                                  , 0x0002e678, 31, 0 },
{"MAC_PCU_BUF[415]", "DATA"                                  , 0x0002e67c, 31, 0 },
{"MAC_PCU_BUF[416]", "DATA"                                  , 0x0002e680, 31, 0 },
{"MAC_PCU_BUF[417]", "DATA"                                  , 0x0002e684, 31, 0 },
{"MAC_PCU_BUF[418]", "DATA"                                  , 0x0002e688, 31, 0 },
{"MAC_PCU_BUF[419]", "DATA"                                  , 0x0002e68c, 31, 0 },
{"MAC_PCU_BUF[420]", "DATA"                                  , 0x0002e690, 31, 0 },
{"MAC_PCU_BUF[421]", "DATA"                                  , 0x0002e694, 31, 0 },
{"MAC_PCU_BUF[422]", "DATA"                                  , 0x0002e698, 31, 0 },
{"MAC_PCU_BUF[423]", "DATA"                                  , 0x0002e69c, 31, 0 },
{"MAC_PCU_BUF[424]", "DATA"                                  , 0x0002e6a0, 31, 0 },
{"MAC_PCU_BUF[425]", "DATA"                                  , 0x0002e6a4, 31, 0 },
{"MAC_PCU_BUF[426]", "DATA"                                  , 0x0002e6a8, 31, 0 },
{"MAC_PCU_BUF[427]", "DATA"                                  , 0x0002e6ac, 31, 0 },
{"MAC_PCU_BUF[428]", "DATA"                                  , 0x0002e6b0, 31, 0 },
{"MAC_PCU_BUF[429]", "DATA"                                  , 0x0002e6b4, 31, 0 },
{"MAC_PCU_BUF[430]", "DATA"                                  , 0x0002e6b8, 31, 0 },
{"MAC_PCU_BUF[431]", "DATA"                                  , 0x0002e6bc, 31, 0 },
{"MAC_PCU_BUF[432]", "DATA"                                  , 0x0002e6c0, 31, 0 },
{"MAC_PCU_BUF[433]", "DATA"                                  , 0x0002e6c4, 31, 0 },
{"MAC_PCU_BUF[434]", "DATA"                                  , 0x0002e6c8, 31, 0 },
{"MAC_PCU_BUF[435]", "DATA"                                  , 0x0002e6cc, 31, 0 },
{"MAC_PCU_BUF[436]", "DATA"                                  , 0x0002e6d0, 31, 0 },
{"MAC_PCU_BUF[437]", "DATA"                                  , 0x0002e6d4, 31, 0 },
{"MAC_PCU_BUF[438]", "DATA"                                  , 0x0002e6d8, 31, 0 },
{"MAC_PCU_BUF[439]", "DATA"                                  , 0x0002e6dc, 31, 0 },
{"MAC_PCU_BUF[440]", "DATA"                                  , 0x0002e6e0, 31, 0 },
{"MAC_PCU_BUF[441]", "DATA"                                  , 0x0002e6e4, 31, 0 },
{"MAC_PCU_BUF[442]", "DATA"                                  , 0x0002e6e8, 31, 0 },
{"MAC_PCU_BUF[443]", "DATA"                                  , 0x0002e6ec, 31, 0 },
{"MAC_PCU_BUF[444]", "DATA"                                  , 0x0002e6f0, 31, 0 },
{"MAC_PCU_BUF[445]", "DATA"                                  , 0x0002e6f4, 31, 0 },
{"MAC_PCU_BUF[446]", "DATA"                                  , 0x0002e6f8, 31, 0 },
{"MAC_PCU_BUF[447]", "DATA"                                  , 0x0002e6fc, 31, 0 },
{"MAC_PCU_BUF[448]", "DATA"                                  , 0x0002e700, 31, 0 },
{"MAC_PCU_BUF[449]", "DATA"                                  , 0x0002e704, 31, 0 },
{"MAC_PCU_BUF[450]", "DATA"                                  , 0x0002e708, 31, 0 },
{"MAC_PCU_BUF[451]", "DATA"                                  , 0x0002e70c, 31, 0 },
{"MAC_PCU_BUF[452]", "DATA"                                  , 0x0002e710, 31, 0 },
{"MAC_PCU_BUF[453]", "DATA"                                  , 0x0002e714, 31, 0 },
{"MAC_PCU_BUF[454]", "DATA"                                  , 0x0002e718, 31, 0 },
{"MAC_PCU_BUF[455]", "DATA"                                  , 0x0002e71c, 31, 0 },
{"MAC_PCU_BUF[456]", "DATA"                                  , 0x0002e720, 31, 0 },
{"MAC_PCU_BUF[457]", "DATA"                                  , 0x0002e724, 31, 0 },
{"MAC_PCU_BUF[458]", "DATA"                                  , 0x0002e728, 31, 0 },
{"MAC_PCU_BUF[459]", "DATA"                                  , 0x0002e72c, 31, 0 },
{"MAC_PCU_BUF[460]", "DATA"                                  , 0x0002e730, 31, 0 },
{"MAC_PCU_BUF[461]", "DATA"                                  , 0x0002e734, 31, 0 },
{"MAC_PCU_BUF[462]", "DATA"                                  , 0x0002e738, 31, 0 },
{"MAC_PCU_BUF[463]", "DATA"                                  , 0x0002e73c, 31, 0 },
{"MAC_PCU_BUF[464]", "DATA"                                  , 0x0002e740, 31, 0 },
{"MAC_PCU_BUF[465]", "DATA"                                  , 0x0002e744, 31, 0 },
{"MAC_PCU_BUF[466]", "DATA"                                  , 0x0002e748, 31, 0 },
{"MAC_PCU_BUF[467]", "DATA"                                  , 0x0002e74c, 31, 0 },
{"MAC_PCU_BUF[468]", "DATA"                                  , 0x0002e750, 31, 0 },
{"MAC_PCU_BUF[469]", "DATA"                                  , 0x0002e754, 31, 0 },
{"MAC_PCU_BUF[470]", "DATA"                                  , 0x0002e758, 31, 0 },
{"MAC_PCU_BUF[471]", "DATA"                                  , 0x0002e75c, 31, 0 },
{"MAC_PCU_BUF[472]", "DATA"                                  , 0x0002e760, 31, 0 },
{"MAC_PCU_BUF[473]", "DATA"                                  , 0x0002e764, 31, 0 },
{"MAC_PCU_BUF[474]", "DATA"                                  , 0x0002e768, 31, 0 },
{"MAC_PCU_BUF[475]", "DATA"                                  , 0x0002e76c, 31, 0 },
{"MAC_PCU_BUF[476]", "DATA"                                  , 0x0002e770, 31, 0 },
{"MAC_PCU_BUF[477]", "DATA"                                  , 0x0002e774, 31, 0 },
{"MAC_PCU_BUF[478]", "DATA"                                  , 0x0002e778, 31, 0 },
{"MAC_PCU_BUF[479]", "DATA"                                  , 0x0002e77c, 31, 0 },
{"MAC_PCU_BUF[480]", "DATA"                                  , 0x0002e780, 31, 0 },
{"MAC_PCU_BUF[481]", "DATA"                                  , 0x0002e784, 31, 0 },
{"MAC_PCU_BUF[482]", "DATA"                                  , 0x0002e788, 31, 0 },
{"MAC_PCU_BUF[483]", "DATA"                                  , 0x0002e78c, 31, 0 },
{"MAC_PCU_BUF[484]", "DATA"                                  , 0x0002e790, 31, 0 },
{"MAC_PCU_BUF[485]", "DATA"                                  , 0x0002e794, 31, 0 },
{"MAC_PCU_BUF[486]", "DATA"                                  , 0x0002e798, 31, 0 },
{"MAC_PCU_BUF[487]", "DATA"                                  , 0x0002e79c, 31, 0 },
{"MAC_PCU_BUF[488]", "DATA"                                  , 0x0002e7a0, 31, 0 },
{"MAC_PCU_BUF[489]", "DATA"                                  , 0x0002e7a4, 31, 0 },
{"MAC_PCU_BUF[490]", "DATA"                                  , 0x0002e7a8, 31, 0 },
{"MAC_PCU_BUF[491]", "DATA"                                  , 0x0002e7ac, 31, 0 },
{"MAC_PCU_BUF[492]", "DATA"                                  , 0x0002e7b0, 31, 0 },
{"MAC_PCU_BUF[493]", "DATA"                                  , 0x0002e7b4, 31, 0 },
{"MAC_PCU_BUF[494]", "DATA"                                  , 0x0002e7b8, 31, 0 },
{"MAC_PCU_BUF[495]", "DATA"                                  , 0x0002e7bc, 31, 0 },
{"MAC_PCU_BUF[496]", "DATA"                                  , 0x0002e7c0, 31, 0 },
{"MAC_PCU_BUF[497]", "DATA"                                  , 0x0002e7c4, 31, 0 },
{"MAC_PCU_BUF[498]", "DATA"                                  , 0x0002e7c8, 31, 0 },
{"MAC_PCU_BUF[499]", "DATA"                                  , 0x0002e7cc, 31, 0 },
{"MAC_PCU_BUF[500]", "DATA"                                  , 0x0002e7d0, 31, 0 },
{"MAC_PCU_BUF[501]", "DATA"                                  , 0x0002e7d4, 31, 0 },
{"MAC_PCU_BUF[502]", "DATA"                                  , 0x0002e7d8, 31, 0 },
{"MAC_PCU_BUF[503]", "DATA"                                  , 0x0002e7dc, 31, 0 },
{"MAC_PCU_BUF[504]", "DATA"                                  , 0x0002e7e0, 31, 0 },
{"MAC_PCU_BUF[505]", "DATA"                                  , 0x0002e7e4, 31, 0 },
{"MAC_PCU_BUF[506]", "DATA"                                  , 0x0002e7e8, 31, 0 },
{"MAC_PCU_BUF[507]", "DATA"                                  , 0x0002e7ec, 31, 0 },
{"MAC_PCU_BUF[508]", "DATA"                                  , 0x0002e7f0, 31, 0 },
{"MAC_PCU_BUF[509]", "DATA"                                  , 0x0002e7f4, 31, 0 },
{"MAC_PCU_BUF[510]", "DATA"                                  , 0x0002e7f8, 31, 0 },
{"MAC_PCU_BUF[511]", "DATA"                                  , 0x0002e7fc, 31, 0 },
{"MAC_PCU_BUF[512]", "DATA"                                  , 0x0002e800, 31, 0 },
{"MAC_PCU_BUF[513]", "DATA"                                  , 0x0002e804, 31, 0 },
{"MAC_PCU_BUF[514]", "DATA"                                  , 0x0002e808, 31, 0 },
{"MAC_PCU_BUF[515]", "DATA"                                  , 0x0002e80c, 31, 0 },
{"MAC_PCU_BUF[516]", "DATA"                                  , 0x0002e810, 31, 0 },
{"MAC_PCU_BUF[517]", "DATA"                                  , 0x0002e814, 31, 0 },
{"MAC_PCU_BUF[518]", "DATA"                                  , 0x0002e818, 31, 0 },
{"MAC_PCU_BUF[519]", "DATA"                                  , 0x0002e81c, 31, 0 },
{"MAC_PCU_BUF[520]", "DATA"                                  , 0x0002e820, 31, 0 },
{"MAC_PCU_BUF[521]", "DATA"                                  , 0x0002e824, 31, 0 },
{"MAC_PCU_BUF[522]", "DATA"                                  , 0x0002e828, 31, 0 },
{"MAC_PCU_BUF[523]", "DATA"                                  , 0x0002e82c, 31, 0 },
{"MAC_PCU_BUF[524]", "DATA"                                  , 0x0002e830, 31, 0 },
{"MAC_PCU_BUF[525]", "DATA"                                  , 0x0002e834, 31, 0 },
{"MAC_PCU_BUF[526]", "DATA"                                  , 0x0002e838, 31, 0 },
{"MAC_PCU_BUF[527]", "DATA"                                  , 0x0002e83c, 31, 0 },
{"MAC_PCU_BUF[528]", "DATA"                                  , 0x0002e840, 31, 0 },
{"MAC_PCU_BUF[529]", "DATA"                                  , 0x0002e844, 31, 0 },
{"MAC_PCU_BUF[530]", "DATA"                                  , 0x0002e848, 31, 0 },
{"MAC_PCU_BUF[531]", "DATA"                                  , 0x0002e84c, 31, 0 },
{"MAC_PCU_BUF[532]", "DATA"                                  , 0x0002e850, 31, 0 },
{"MAC_PCU_BUF[533]", "DATA"                                  , 0x0002e854, 31, 0 },
{"MAC_PCU_BUF[534]", "DATA"                                  , 0x0002e858, 31, 0 },
{"MAC_PCU_BUF[535]", "DATA"                                  , 0x0002e85c, 31, 0 },
{"MAC_PCU_BUF[536]", "DATA"                                  , 0x0002e860, 31, 0 },
{"MAC_PCU_BUF[537]", "DATA"                                  , 0x0002e864, 31, 0 },
{"MAC_PCU_BUF[538]", "DATA"                                  , 0x0002e868, 31, 0 },
{"MAC_PCU_BUF[539]", "DATA"                                  , 0x0002e86c, 31, 0 },
{"MAC_PCU_BUF[540]", "DATA"                                  , 0x0002e870, 31, 0 },
{"MAC_PCU_BUF[541]", "DATA"                                  , 0x0002e874, 31, 0 },
{"MAC_PCU_BUF[542]", "DATA"                                  , 0x0002e878, 31, 0 },
{"MAC_PCU_BUF[543]", "DATA"                                  , 0x0002e87c, 31, 0 },
{"MAC_PCU_BUF[544]", "DATA"                                  , 0x0002e880, 31, 0 },
{"MAC_PCU_BUF[545]", "DATA"                                  , 0x0002e884, 31, 0 },
{"MAC_PCU_BUF[546]", "DATA"                                  , 0x0002e888, 31, 0 },
{"MAC_PCU_BUF[547]", "DATA"                                  , 0x0002e88c, 31, 0 },
{"MAC_PCU_BUF[548]", "DATA"                                  , 0x0002e890, 31, 0 },
{"MAC_PCU_BUF[549]", "DATA"                                  , 0x0002e894, 31, 0 },
{"MAC_PCU_BUF[550]", "DATA"                                  , 0x0002e898, 31, 0 },
{"MAC_PCU_BUF[551]", "DATA"                                  , 0x0002e89c, 31, 0 },
{"MAC_PCU_BUF[552]", "DATA"                                  , 0x0002e8a0, 31, 0 },
{"MAC_PCU_BUF[553]", "DATA"                                  , 0x0002e8a4, 31, 0 },
{"MAC_PCU_BUF[554]", "DATA"                                  , 0x0002e8a8, 31, 0 },
{"MAC_PCU_BUF[555]", "DATA"                                  , 0x0002e8ac, 31, 0 },
{"MAC_PCU_BUF[556]", "DATA"                                  , 0x0002e8b0, 31, 0 },
{"MAC_PCU_BUF[557]", "DATA"                                  , 0x0002e8b4, 31, 0 },
{"MAC_PCU_BUF[558]", "DATA"                                  , 0x0002e8b8, 31, 0 },
{"MAC_PCU_BUF[559]", "DATA"                                  , 0x0002e8bc, 31, 0 },
{"MAC_PCU_BUF[560]", "DATA"                                  , 0x0002e8c0, 31, 0 },
{"MAC_PCU_BUF[561]", "DATA"                                  , 0x0002e8c4, 31, 0 },
{"MAC_PCU_BUF[562]", "DATA"                                  , 0x0002e8c8, 31, 0 },
{"MAC_PCU_BUF[563]", "DATA"                                  , 0x0002e8cc, 31, 0 },
{"MAC_PCU_BUF[564]", "DATA"                                  , 0x0002e8d0, 31, 0 },
{"MAC_PCU_BUF[565]", "DATA"                                  , 0x0002e8d4, 31, 0 },
{"MAC_PCU_BUF[566]", "DATA"                                  , 0x0002e8d8, 31, 0 },
{"MAC_PCU_BUF[567]", "DATA"                                  , 0x0002e8dc, 31, 0 },
{"MAC_PCU_BUF[568]", "DATA"                                  , 0x0002e8e0, 31, 0 },
{"MAC_PCU_BUF[569]", "DATA"                                  , 0x0002e8e4, 31, 0 },
{"MAC_PCU_BUF[570]", "DATA"                                  , 0x0002e8e8, 31, 0 },
{"MAC_PCU_BUF[571]", "DATA"                                  , 0x0002e8ec, 31, 0 },
{"MAC_PCU_BUF[572]", "DATA"                                  , 0x0002e8f0, 31, 0 },
{"MAC_PCU_BUF[573]", "DATA"                                  , 0x0002e8f4, 31, 0 },
{"MAC_PCU_BUF[574]", "DATA"                                  , 0x0002e8f8, 31, 0 },
{"MAC_PCU_BUF[575]", "DATA"                                  , 0x0002e8fc, 31, 0 },
{"MAC_PCU_BUF[576]", "DATA"                                  , 0x0002e900, 31, 0 },
{"MAC_PCU_BUF[577]", "DATA"                                  , 0x0002e904, 31, 0 },
{"MAC_PCU_BUF[578]", "DATA"                                  , 0x0002e908, 31, 0 },
{"MAC_PCU_BUF[579]", "DATA"                                  , 0x0002e90c, 31, 0 },
{"MAC_PCU_BUF[580]", "DATA"                                  , 0x0002e910, 31, 0 },
{"MAC_PCU_BUF[581]", "DATA"                                  , 0x0002e914, 31, 0 },
{"MAC_PCU_BUF[582]", "DATA"                                  , 0x0002e918, 31, 0 },
{"MAC_PCU_BUF[583]", "DATA"                                  , 0x0002e91c, 31, 0 },
{"MAC_PCU_BUF[584]", "DATA"                                  , 0x0002e920, 31, 0 },
{"MAC_PCU_BUF[585]", "DATA"                                  , 0x0002e924, 31, 0 },
{"MAC_PCU_BUF[586]", "DATA"                                  , 0x0002e928, 31, 0 },
{"MAC_PCU_BUF[587]", "DATA"                                  , 0x0002e92c, 31, 0 },
{"MAC_PCU_BUF[588]", "DATA"                                  , 0x0002e930, 31, 0 },
{"MAC_PCU_BUF[589]", "DATA"                                  , 0x0002e934, 31, 0 },
{"MAC_PCU_BUF[590]", "DATA"                                  , 0x0002e938, 31, 0 },
{"MAC_PCU_BUF[591]", "DATA"                                  , 0x0002e93c, 31, 0 },
{"MAC_PCU_BUF[592]", "DATA"                                  , 0x0002e940, 31, 0 },
{"MAC_PCU_BUF[593]", "DATA"                                  , 0x0002e944, 31, 0 },
{"MAC_PCU_BUF[594]", "DATA"                                  , 0x0002e948, 31, 0 },
{"MAC_PCU_BUF[595]", "DATA"                                  , 0x0002e94c, 31, 0 },
{"MAC_PCU_BUF[596]", "DATA"                                  , 0x0002e950, 31, 0 },
{"MAC_PCU_BUF[597]", "DATA"                                  , 0x0002e954, 31, 0 },
{"MAC_PCU_BUF[598]", "DATA"                                  , 0x0002e958, 31, 0 },
{"MAC_PCU_BUF[599]", "DATA"                                  , 0x0002e95c, 31, 0 },
{"MAC_PCU_BUF[600]", "DATA"                                  , 0x0002e960, 31, 0 },
{"MAC_PCU_BUF[601]", "DATA"                                  , 0x0002e964, 31, 0 },
{"MAC_PCU_BUF[602]", "DATA"                                  , 0x0002e968, 31, 0 },
{"MAC_PCU_BUF[603]", "DATA"                                  , 0x0002e96c, 31, 0 },
{"MAC_PCU_BUF[604]", "DATA"                                  , 0x0002e970, 31, 0 },
{"MAC_PCU_BUF[605]", "DATA"                                  , 0x0002e974, 31, 0 },
{"MAC_PCU_BUF[606]", "DATA"                                  , 0x0002e978, 31, 0 },
{"MAC_PCU_BUF[607]", "DATA"                                  , 0x0002e97c, 31, 0 },
{"MAC_PCU_BUF[608]", "DATA"                                  , 0x0002e980, 31, 0 },
{"MAC_PCU_BUF[609]", "DATA"                                  , 0x0002e984, 31, 0 },
{"MAC_PCU_BUF[610]", "DATA"                                  , 0x0002e988, 31, 0 },
{"MAC_PCU_BUF[611]", "DATA"                                  , 0x0002e98c, 31, 0 },
{"MAC_PCU_BUF[612]", "DATA"                                  , 0x0002e990, 31, 0 },
{"MAC_PCU_BUF[613]", "DATA"                                  , 0x0002e994, 31, 0 },
{"MAC_PCU_BUF[614]", "DATA"                                  , 0x0002e998, 31, 0 },
{"MAC_PCU_BUF[615]", "DATA"                                  , 0x0002e99c, 31, 0 },
{"MAC_PCU_BUF[616]", "DATA"                                  , 0x0002e9a0, 31, 0 },
{"MAC_PCU_BUF[617]", "DATA"                                  , 0x0002e9a4, 31, 0 },
{"MAC_PCU_BUF[618]", "DATA"                                  , 0x0002e9a8, 31, 0 },
{"MAC_PCU_BUF[619]", "DATA"                                  , 0x0002e9ac, 31, 0 },
{"MAC_PCU_BUF[620]", "DATA"                                  , 0x0002e9b0, 31, 0 },
{"MAC_PCU_BUF[621]", "DATA"                                  , 0x0002e9b4, 31, 0 },
{"MAC_PCU_BUF[622]", "DATA"                                  , 0x0002e9b8, 31, 0 },
{"MAC_PCU_BUF[623]", "DATA"                                  , 0x0002e9bc, 31, 0 },
{"MAC_PCU_BUF[624]", "DATA"                                  , 0x0002e9c0, 31, 0 },
{"MAC_PCU_BUF[625]", "DATA"                                  , 0x0002e9c4, 31, 0 },
{"MAC_PCU_BUF[626]", "DATA"                                  , 0x0002e9c8, 31, 0 },
{"MAC_PCU_BUF[627]", "DATA"                                  , 0x0002e9cc, 31, 0 },
{"MAC_PCU_BUF[628]", "DATA"                                  , 0x0002e9d0, 31, 0 },
{"MAC_PCU_BUF[629]", "DATA"                                  , 0x0002e9d4, 31, 0 },
{"MAC_PCU_BUF[630]", "DATA"                                  , 0x0002e9d8, 31, 0 },
{"MAC_PCU_BUF[631]", "DATA"                                  , 0x0002e9dc, 31, 0 },
{"MAC_PCU_BUF[632]", "DATA"                                  , 0x0002e9e0, 31, 0 },
{"MAC_PCU_BUF[633]", "DATA"                                  , 0x0002e9e4, 31, 0 },
{"MAC_PCU_BUF[634]", "DATA"                                  , 0x0002e9e8, 31, 0 },
{"MAC_PCU_BUF[635]", "DATA"                                  , 0x0002e9ec, 31, 0 },
{"MAC_PCU_BUF[636]", "DATA"                                  , 0x0002e9f0, 31, 0 },
{"MAC_PCU_BUF[637]", "DATA"                                  , 0x0002e9f4, 31, 0 },
{"MAC_PCU_BUF[638]", "DATA"                                  , 0x0002e9f8, 31, 0 },
{"MAC_PCU_BUF[639]", "DATA"                                  , 0x0002e9fc, 31, 0 },
{"MAC_PCU_BUF[640]", "DATA"                                  , 0x0002ea00, 31, 0 },
{"MAC_PCU_BUF[641]", "DATA"                                  , 0x0002ea04, 31, 0 },
{"MAC_PCU_BUF[642]", "DATA"                                  , 0x0002ea08, 31, 0 },
{"MAC_PCU_BUF[643]", "DATA"                                  , 0x0002ea0c, 31, 0 },
{"MAC_PCU_BUF[644]", "DATA"                                  , 0x0002ea10, 31, 0 },
{"MAC_PCU_BUF[645]", "DATA"                                  , 0x0002ea14, 31, 0 },
{"MAC_PCU_BUF[646]", "DATA"                                  , 0x0002ea18, 31, 0 },
{"MAC_PCU_BUF[647]", "DATA"                                  , 0x0002ea1c, 31, 0 },
{"MAC_PCU_BUF[648]", "DATA"                                  , 0x0002ea20, 31, 0 },
{"MAC_PCU_BUF[649]", "DATA"                                  , 0x0002ea24, 31, 0 },
{"MAC_PCU_BUF[650]", "DATA"                                  , 0x0002ea28, 31, 0 },
{"MAC_PCU_BUF[651]", "DATA"                                  , 0x0002ea2c, 31, 0 },
{"MAC_PCU_BUF[652]", "DATA"                                  , 0x0002ea30, 31, 0 },
{"MAC_PCU_BUF[653]", "DATA"                                  , 0x0002ea34, 31, 0 },
{"MAC_PCU_BUF[654]", "DATA"                                  , 0x0002ea38, 31, 0 },
{"MAC_PCU_BUF[655]", "DATA"                                  , 0x0002ea3c, 31, 0 },
{"MAC_PCU_BUF[656]", "DATA"                                  , 0x0002ea40, 31, 0 },
{"MAC_PCU_BUF[657]", "DATA"                                  , 0x0002ea44, 31, 0 },
{"MAC_PCU_BUF[658]", "DATA"                                  , 0x0002ea48, 31, 0 },
{"MAC_PCU_BUF[659]", "DATA"                                  , 0x0002ea4c, 31, 0 },
{"MAC_PCU_BUF[660]", "DATA"                                  , 0x0002ea50, 31, 0 },
{"MAC_PCU_BUF[661]", "DATA"                                  , 0x0002ea54, 31, 0 },
{"MAC_PCU_BUF[662]", "DATA"                                  , 0x0002ea58, 31, 0 },
{"MAC_PCU_BUF[663]", "DATA"                                  , 0x0002ea5c, 31, 0 },
{"MAC_PCU_BUF[664]", "DATA"                                  , 0x0002ea60, 31, 0 },
{"MAC_PCU_BUF[665]", "DATA"                                  , 0x0002ea64, 31, 0 },
{"MAC_PCU_BUF[666]", "DATA"                                  , 0x0002ea68, 31, 0 },
{"MAC_PCU_BUF[667]", "DATA"                                  , 0x0002ea6c, 31, 0 },
{"MAC_PCU_BUF[668]", "DATA"                                  , 0x0002ea70, 31, 0 },
{"MAC_PCU_BUF[669]", "DATA"                                  , 0x0002ea74, 31, 0 },
{"MAC_PCU_BUF[670]", "DATA"                                  , 0x0002ea78, 31, 0 },
{"MAC_PCU_BUF[671]", "DATA"                                  , 0x0002ea7c, 31, 0 },
{"MAC_PCU_BUF[672]", "DATA"                                  , 0x0002ea80, 31, 0 },
{"MAC_PCU_BUF[673]", "DATA"                                  , 0x0002ea84, 31, 0 },
{"MAC_PCU_BUF[674]", "DATA"                                  , 0x0002ea88, 31, 0 },
{"MAC_PCU_BUF[675]", "DATA"                                  , 0x0002ea8c, 31, 0 },
{"MAC_PCU_BUF[676]", "DATA"                                  , 0x0002ea90, 31, 0 },
{"MAC_PCU_BUF[677]", "DATA"                                  , 0x0002ea94, 31, 0 },
{"MAC_PCU_BUF[678]", "DATA"                                  , 0x0002ea98, 31, 0 },
{"MAC_PCU_BUF[679]", "DATA"                                  , 0x0002ea9c, 31, 0 },
{"MAC_PCU_BUF[680]", "DATA"                                  , 0x0002eaa0, 31, 0 },
{"MAC_PCU_BUF[681]", "DATA"                                  , 0x0002eaa4, 31, 0 },
{"MAC_PCU_BUF[682]", "DATA"                                  , 0x0002eaa8, 31, 0 },
{"MAC_PCU_BUF[683]", "DATA"                                  , 0x0002eaac, 31, 0 },
{"MAC_PCU_BUF[684]", "DATA"                                  , 0x0002eab0, 31, 0 },
{"MAC_PCU_BUF[685]", "DATA"                                  , 0x0002eab4, 31, 0 },
{"MAC_PCU_BUF[686]", "DATA"                                  , 0x0002eab8, 31, 0 },
{"MAC_PCU_BUF[687]", "DATA"                                  , 0x0002eabc, 31, 0 },
{"MAC_PCU_BUF[688]", "DATA"                                  , 0x0002eac0, 31, 0 },
{"MAC_PCU_BUF[689]", "DATA"                                  , 0x0002eac4, 31, 0 },
{"MAC_PCU_BUF[690]", "DATA"                                  , 0x0002eac8, 31, 0 },
{"MAC_PCU_BUF[691]", "DATA"                                  , 0x0002eacc, 31, 0 },
{"MAC_PCU_BUF[692]", "DATA"                                  , 0x0002ead0, 31, 0 },
{"MAC_PCU_BUF[693]", "DATA"                                  , 0x0002ead4, 31, 0 },
{"MAC_PCU_BUF[694]", "DATA"                                  , 0x0002ead8, 31, 0 },
{"MAC_PCU_BUF[695]", "DATA"                                  , 0x0002eadc, 31, 0 },
{"MAC_PCU_BUF[696]", "DATA"                                  , 0x0002eae0, 31, 0 },
{"MAC_PCU_BUF[697]", "DATA"                                  , 0x0002eae4, 31, 0 },
{"MAC_PCU_BUF[698]", "DATA"                                  , 0x0002eae8, 31, 0 },
{"MAC_PCU_BUF[699]", "DATA"                                  , 0x0002eaec, 31, 0 },
{"MAC_PCU_BUF[700]", "DATA"                                  , 0x0002eaf0, 31, 0 },
{"MAC_PCU_BUF[701]", "DATA"                                  , 0x0002eaf4, 31, 0 },
{"MAC_PCU_BUF[702]", "DATA"                                  , 0x0002eaf8, 31, 0 },
{"MAC_PCU_BUF[703]", "DATA"                                  , 0x0002eafc, 31, 0 },
{"MAC_PCU_BUF[704]", "DATA"                                  , 0x0002eb00, 31, 0 },
{"MAC_PCU_BUF[705]", "DATA"                                  , 0x0002eb04, 31, 0 },
{"MAC_PCU_BUF[706]", "DATA"                                  , 0x0002eb08, 31, 0 },
{"MAC_PCU_BUF[707]", "DATA"                                  , 0x0002eb0c, 31, 0 },
{"MAC_PCU_BUF[708]", "DATA"                                  , 0x0002eb10, 31, 0 },
{"MAC_PCU_BUF[709]", "DATA"                                  , 0x0002eb14, 31, 0 },
{"MAC_PCU_BUF[710]", "DATA"                                  , 0x0002eb18, 31, 0 },
{"MAC_PCU_BUF[711]", "DATA"                                  , 0x0002eb1c, 31, 0 },
{"MAC_PCU_BUF[712]", "DATA"                                  , 0x0002eb20, 31, 0 },
{"MAC_PCU_BUF[713]", "DATA"                                  , 0x0002eb24, 31, 0 },
{"MAC_PCU_BUF[714]", "DATA"                                  , 0x0002eb28, 31, 0 },
{"MAC_PCU_BUF[715]", "DATA"                                  , 0x0002eb2c, 31, 0 },
{"MAC_PCU_BUF[716]", "DATA"                                  , 0x0002eb30, 31, 0 },
{"MAC_PCU_BUF[717]", "DATA"                                  , 0x0002eb34, 31, 0 },
{"MAC_PCU_BUF[718]", "DATA"                                  , 0x0002eb38, 31, 0 },
{"MAC_PCU_BUF[719]", "DATA"                                  , 0x0002eb3c, 31, 0 },
{"MAC_PCU_BUF[720]", "DATA"                                  , 0x0002eb40, 31, 0 },
{"MAC_PCU_BUF[721]", "DATA"                                  , 0x0002eb44, 31, 0 },
{"MAC_PCU_BUF[722]", "DATA"                                  , 0x0002eb48, 31, 0 },
{"MAC_PCU_BUF[723]", "DATA"                                  , 0x0002eb4c, 31, 0 },
{"MAC_PCU_BUF[724]", "DATA"                                  , 0x0002eb50, 31, 0 },
{"MAC_PCU_BUF[725]", "DATA"                                  , 0x0002eb54, 31, 0 },
{"MAC_PCU_BUF[726]", "DATA"                                  , 0x0002eb58, 31, 0 },
{"MAC_PCU_BUF[727]", "DATA"                                  , 0x0002eb5c, 31, 0 },
{"MAC_PCU_BUF[728]", "DATA"                                  , 0x0002eb60, 31, 0 },
{"MAC_PCU_BUF[729]", "DATA"                                  , 0x0002eb64, 31, 0 },
{"MAC_PCU_BUF[730]", "DATA"                                  , 0x0002eb68, 31, 0 },
{"MAC_PCU_BUF[731]", "DATA"                                  , 0x0002eb6c, 31, 0 },
{"MAC_PCU_BUF[732]", "DATA"                                  , 0x0002eb70, 31, 0 },
{"MAC_PCU_BUF[733]", "DATA"                                  , 0x0002eb74, 31, 0 },
{"MAC_PCU_BUF[734]", "DATA"                                  , 0x0002eb78, 31, 0 },
{"MAC_PCU_BUF[735]", "DATA"                                  , 0x0002eb7c, 31, 0 },
{"MAC_PCU_BUF[736]", "DATA"                                  , 0x0002eb80, 31, 0 },
{"MAC_PCU_BUF[737]", "DATA"                                  , 0x0002eb84, 31, 0 },
{"MAC_PCU_BUF[738]", "DATA"                                  , 0x0002eb88, 31, 0 },
{"MAC_PCU_BUF[739]", "DATA"                                  , 0x0002eb8c, 31, 0 },
{"MAC_PCU_BUF[740]", "DATA"                                  , 0x0002eb90, 31, 0 },
{"MAC_PCU_BUF[741]", "DATA"                                  , 0x0002eb94, 31, 0 },
{"MAC_PCU_BUF[742]", "DATA"                                  , 0x0002eb98, 31, 0 },
{"MAC_PCU_BUF[743]", "DATA"                                  , 0x0002eb9c, 31, 0 },
{"MAC_PCU_BUF[744]", "DATA"                                  , 0x0002eba0, 31, 0 },
{"MAC_PCU_BUF[745]", "DATA"                                  , 0x0002eba4, 31, 0 },
{"MAC_PCU_BUF[746]", "DATA"                                  , 0x0002eba8, 31, 0 },
{"MAC_PCU_BUF[747]", "DATA"                                  , 0x0002ebac, 31, 0 },
{"MAC_PCU_BUF[748]", "DATA"                                  , 0x0002ebb0, 31, 0 },
{"MAC_PCU_BUF[749]", "DATA"                                  , 0x0002ebb4, 31, 0 },
{"MAC_PCU_BUF[750]", "DATA"                                  , 0x0002ebb8, 31, 0 },
{"MAC_PCU_BUF[751]", "DATA"                                  , 0x0002ebbc, 31, 0 },
{"MAC_PCU_BUF[752]", "DATA"                                  , 0x0002ebc0, 31, 0 },
{"MAC_PCU_BUF[753]", "DATA"                                  , 0x0002ebc4, 31, 0 },
{"MAC_PCU_BUF[754]", "DATA"                                  , 0x0002ebc8, 31, 0 },
{"MAC_PCU_BUF[755]", "DATA"                                  , 0x0002ebcc, 31, 0 },
{"MAC_PCU_BUF[756]", "DATA"                                  , 0x0002ebd0, 31, 0 },
{"MAC_PCU_BUF[757]", "DATA"                                  , 0x0002ebd4, 31, 0 },
{"MAC_PCU_BUF[758]", "DATA"                                  , 0x0002ebd8, 31, 0 },
{"MAC_PCU_BUF[759]", "DATA"                                  , 0x0002ebdc, 31, 0 },
{"MAC_PCU_BUF[760]", "DATA"                                  , 0x0002ebe0, 31, 0 },
{"MAC_PCU_BUF[761]", "DATA"                                  , 0x0002ebe4, 31, 0 },
{"MAC_PCU_BUF[762]", "DATA"                                  , 0x0002ebe8, 31, 0 },
{"MAC_PCU_BUF[763]", "DATA"                                  , 0x0002ebec, 31, 0 },
{"MAC_PCU_BUF[764]", "DATA"                                  , 0x0002ebf0, 31, 0 },
{"MAC_PCU_BUF[765]", "DATA"                                  , 0x0002ebf4, 31, 0 },
{"MAC_PCU_BUF[766]", "DATA"                                  , 0x0002ebf8, 31, 0 },
{"MAC_PCU_BUF[767]", "DATA"                                  , 0x0002ebfc, 31, 0 },
{"MAC_PCU_BUF[768]", "DATA"                                  , 0x0002ec00, 31, 0 },
{"MAC_PCU_BUF[769]", "DATA"                                  , 0x0002ec04, 31, 0 },
{"MAC_PCU_BUF[770]", "DATA"                                  , 0x0002ec08, 31, 0 },
{"MAC_PCU_BUF[771]", "DATA"                                  , 0x0002ec0c, 31, 0 },
{"MAC_PCU_BUF[772]", "DATA"                                  , 0x0002ec10, 31, 0 },
{"MAC_PCU_BUF[773]", "DATA"                                  , 0x0002ec14, 31, 0 },
{"MAC_PCU_BUF[774]", "DATA"                                  , 0x0002ec18, 31, 0 },
{"MAC_PCU_BUF[775]", "DATA"                                  , 0x0002ec1c, 31, 0 },
{"MAC_PCU_BUF[776]", "DATA"                                  , 0x0002ec20, 31, 0 },
{"MAC_PCU_BUF[777]", "DATA"                                  , 0x0002ec24, 31, 0 },
{"MAC_PCU_BUF[778]", "DATA"                                  , 0x0002ec28, 31, 0 },
{"MAC_PCU_BUF[779]", "DATA"                                  , 0x0002ec2c, 31, 0 },
{"MAC_PCU_BUF[780]", "DATA"                                  , 0x0002ec30, 31, 0 },
{"MAC_PCU_BUF[781]", "DATA"                                  , 0x0002ec34, 31, 0 },
{"MAC_PCU_BUF[782]", "DATA"                                  , 0x0002ec38, 31, 0 },
{"MAC_PCU_BUF[783]", "DATA"                                  , 0x0002ec3c, 31, 0 },
{"MAC_PCU_BUF[784]", "DATA"                                  , 0x0002ec40, 31, 0 },
{"MAC_PCU_BUF[785]", "DATA"                                  , 0x0002ec44, 31, 0 },
{"MAC_PCU_BUF[786]", "DATA"                                  , 0x0002ec48, 31, 0 },
{"MAC_PCU_BUF[787]", "DATA"                                  , 0x0002ec4c, 31, 0 },
{"MAC_PCU_BUF[788]", "DATA"                                  , 0x0002ec50, 31, 0 },
{"MAC_PCU_BUF[789]", "DATA"                                  , 0x0002ec54, 31, 0 },
{"MAC_PCU_BUF[790]", "DATA"                                  , 0x0002ec58, 31, 0 },
{"MAC_PCU_BUF[791]", "DATA"                                  , 0x0002ec5c, 31, 0 },
{"MAC_PCU_BUF[792]", "DATA"                                  , 0x0002ec60, 31, 0 },
{"MAC_PCU_BUF[793]", "DATA"                                  , 0x0002ec64, 31, 0 },
{"MAC_PCU_BUF[794]", "DATA"                                  , 0x0002ec68, 31, 0 },
{"MAC_PCU_BUF[795]", "DATA"                                  , 0x0002ec6c, 31, 0 },
{"MAC_PCU_BUF[796]", "DATA"                                  , 0x0002ec70, 31, 0 },
{"MAC_PCU_BUF[797]", "DATA"                                  , 0x0002ec74, 31, 0 },
{"MAC_PCU_BUF[798]", "DATA"                                  , 0x0002ec78, 31, 0 },
{"MAC_PCU_BUF[799]", "DATA"                                  , 0x0002ec7c, 31, 0 },
{"MAC_PCU_BUF[800]", "DATA"                                  , 0x0002ec80, 31, 0 },
{"MAC_PCU_BUF[801]", "DATA"                                  , 0x0002ec84, 31, 0 },
{"MAC_PCU_BUF[802]", "DATA"                                  , 0x0002ec88, 31, 0 },
{"MAC_PCU_BUF[803]", "DATA"                                  , 0x0002ec8c, 31, 0 },
{"MAC_PCU_BUF[804]", "DATA"                                  , 0x0002ec90, 31, 0 },
{"MAC_PCU_BUF[805]", "DATA"                                  , 0x0002ec94, 31, 0 },
{"MAC_PCU_BUF[806]", "DATA"                                  , 0x0002ec98, 31, 0 },
{"MAC_PCU_BUF[807]", "DATA"                                  , 0x0002ec9c, 31, 0 },
{"MAC_PCU_BUF[808]", "DATA"                                  , 0x0002eca0, 31, 0 },
{"MAC_PCU_BUF[809]", "DATA"                                  , 0x0002eca4, 31, 0 },
{"MAC_PCU_BUF[810]", "DATA"                                  , 0x0002eca8, 31, 0 },
{"MAC_PCU_BUF[811]", "DATA"                                  , 0x0002ecac, 31, 0 },
{"MAC_PCU_BUF[812]", "DATA"                                  , 0x0002ecb0, 31, 0 },
{"MAC_PCU_BUF[813]", "DATA"                                  , 0x0002ecb4, 31, 0 },
{"MAC_PCU_BUF[814]", "DATA"                                  , 0x0002ecb8, 31, 0 },
{"MAC_PCU_BUF[815]", "DATA"                                  , 0x0002ecbc, 31, 0 },
{"MAC_PCU_BUF[816]", "DATA"                                  , 0x0002ecc0, 31, 0 },
{"MAC_PCU_BUF[817]", "DATA"                                  , 0x0002ecc4, 31, 0 },
{"MAC_PCU_BUF[818]", "DATA"                                  , 0x0002ecc8, 31, 0 },
{"MAC_PCU_BUF[819]", "DATA"                                  , 0x0002eccc, 31, 0 },
{"MAC_PCU_BUF[820]", "DATA"                                  , 0x0002ecd0, 31, 0 },
{"MAC_PCU_BUF[821]", "DATA"                                  , 0x0002ecd4, 31, 0 },
{"MAC_PCU_BUF[822]", "DATA"                                  , 0x0002ecd8, 31, 0 },
{"MAC_PCU_BUF[823]", "DATA"                                  , 0x0002ecdc, 31, 0 },
{"MAC_PCU_BUF[824]", "DATA"                                  , 0x0002ece0, 31, 0 },
{"MAC_PCU_BUF[825]", "DATA"                                  , 0x0002ece4, 31, 0 },
{"MAC_PCU_BUF[826]", "DATA"                                  , 0x0002ece8, 31, 0 },
{"MAC_PCU_BUF[827]", "DATA"                                  , 0x0002ecec, 31, 0 },
{"MAC_PCU_BUF[828]", "DATA"                                  , 0x0002ecf0, 31, 0 },
{"MAC_PCU_BUF[829]", "DATA"                                  , 0x0002ecf4, 31, 0 },
{"MAC_PCU_BUF[830]", "DATA"                                  , 0x0002ecf8, 31, 0 },
{"MAC_PCU_BUF[831]", "DATA"                                  , 0x0002ecfc, 31, 0 },
{"MAC_PCU_BUF[832]", "DATA"                                  , 0x0002ed00, 31, 0 },
{"MAC_PCU_BUF[833]", "DATA"                                  , 0x0002ed04, 31, 0 },
{"MAC_PCU_BUF[834]", "DATA"                                  , 0x0002ed08, 31, 0 },
{"MAC_PCU_BUF[835]", "DATA"                                  , 0x0002ed0c, 31, 0 },
{"MAC_PCU_BUF[836]", "DATA"                                  , 0x0002ed10, 31, 0 },
{"MAC_PCU_BUF[837]", "DATA"                                  , 0x0002ed14, 31, 0 },
{"MAC_PCU_BUF[838]", "DATA"                                  , 0x0002ed18, 31, 0 },
{"MAC_PCU_BUF[839]", "DATA"                                  , 0x0002ed1c, 31, 0 },
{"MAC_PCU_BUF[840]", "DATA"                                  , 0x0002ed20, 31, 0 },
{"MAC_PCU_BUF[841]", "DATA"                                  , 0x0002ed24, 31, 0 },
{"MAC_PCU_BUF[842]", "DATA"                                  , 0x0002ed28, 31, 0 },
{"MAC_PCU_BUF[843]", "DATA"                                  , 0x0002ed2c, 31, 0 },
{"MAC_PCU_BUF[844]", "DATA"                                  , 0x0002ed30, 31, 0 },
{"MAC_PCU_BUF[845]", "DATA"                                  , 0x0002ed34, 31, 0 },
{"MAC_PCU_BUF[846]", "DATA"                                  , 0x0002ed38, 31, 0 },
{"MAC_PCU_BUF[847]", "DATA"                                  , 0x0002ed3c, 31, 0 },
{"MAC_PCU_BUF[848]", "DATA"                                  , 0x0002ed40, 31, 0 },
{"MAC_PCU_BUF[849]", "DATA"                                  , 0x0002ed44, 31, 0 },
{"MAC_PCU_BUF[850]", "DATA"                                  , 0x0002ed48, 31, 0 },
{"MAC_PCU_BUF[851]", "DATA"                                  , 0x0002ed4c, 31, 0 },
{"MAC_PCU_BUF[852]", "DATA"                                  , 0x0002ed50, 31, 0 },
{"MAC_PCU_BUF[853]", "DATA"                                  , 0x0002ed54, 31, 0 },
{"MAC_PCU_BUF[854]", "DATA"                                  , 0x0002ed58, 31, 0 },
{"MAC_PCU_BUF[855]", "DATA"                                  , 0x0002ed5c, 31, 0 },
{"MAC_PCU_BUF[856]", "DATA"                                  , 0x0002ed60, 31, 0 },
{"MAC_PCU_BUF[857]", "DATA"                                  , 0x0002ed64, 31, 0 },
{"MAC_PCU_BUF[858]", "DATA"                                  , 0x0002ed68, 31, 0 },
{"MAC_PCU_BUF[859]", "DATA"                                  , 0x0002ed6c, 31, 0 },
{"MAC_PCU_BUF[860]", "DATA"                                  , 0x0002ed70, 31, 0 },
{"MAC_PCU_BUF[861]", "DATA"                                  , 0x0002ed74, 31, 0 },
{"MAC_PCU_BUF[862]", "DATA"                                  , 0x0002ed78, 31, 0 },
{"MAC_PCU_BUF[863]", "DATA"                                  , 0x0002ed7c, 31, 0 },
{"MAC_PCU_BUF[864]", "DATA"                                  , 0x0002ed80, 31, 0 },
{"MAC_PCU_BUF[865]", "DATA"                                  , 0x0002ed84, 31, 0 },
{"MAC_PCU_BUF[866]", "DATA"                                  , 0x0002ed88, 31, 0 },
{"MAC_PCU_BUF[867]", "DATA"                                  , 0x0002ed8c, 31, 0 },
{"MAC_PCU_BUF[868]", "DATA"                                  , 0x0002ed90, 31, 0 },
{"MAC_PCU_BUF[869]", "DATA"                                  , 0x0002ed94, 31, 0 },
{"MAC_PCU_BUF[870]", "DATA"                                  , 0x0002ed98, 31, 0 },
{"MAC_PCU_BUF[871]", "DATA"                                  , 0x0002ed9c, 31, 0 },
{"MAC_PCU_BUF[872]", "DATA"                                  , 0x0002eda0, 31, 0 },
{"MAC_PCU_BUF[873]", "DATA"                                  , 0x0002eda4, 31, 0 },
{"MAC_PCU_BUF[874]", "DATA"                                  , 0x0002eda8, 31, 0 },
{"MAC_PCU_BUF[875]", "DATA"                                  , 0x0002edac, 31, 0 },
{"MAC_PCU_BUF[876]", "DATA"                                  , 0x0002edb0, 31, 0 },
{"MAC_PCU_BUF[877]", "DATA"                                  , 0x0002edb4, 31, 0 },
{"MAC_PCU_BUF[878]", "DATA"                                  , 0x0002edb8, 31, 0 },
{"MAC_PCU_BUF[879]", "DATA"                                  , 0x0002edbc, 31, 0 },
{"MAC_PCU_BUF[880]", "DATA"                                  , 0x0002edc0, 31, 0 },
{"MAC_PCU_BUF[881]", "DATA"                                  , 0x0002edc4, 31, 0 },
{"MAC_PCU_BUF[882]", "DATA"                                  , 0x0002edc8, 31, 0 },
{"MAC_PCU_BUF[883]", "DATA"                                  , 0x0002edcc, 31, 0 },
{"MAC_PCU_BUF[884]", "DATA"                                  , 0x0002edd0, 31, 0 },
{"MAC_PCU_BUF[885]", "DATA"                                  , 0x0002edd4, 31, 0 },
{"MAC_PCU_BUF[886]", "DATA"                                  , 0x0002edd8, 31, 0 },
{"MAC_PCU_BUF[887]", "DATA"                                  , 0x0002eddc, 31, 0 },
{"MAC_PCU_BUF[888]", "DATA"                                  , 0x0002ede0, 31, 0 },
{"MAC_PCU_BUF[889]", "DATA"                                  , 0x0002ede4, 31, 0 },
{"MAC_PCU_BUF[890]", "DATA"                                  , 0x0002ede8, 31, 0 },
{"MAC_PCU_BUF[891]", "DATA"                                  , 0x0002edec, 31, 0 },
{"MAC_PCU_BUF[892]", "DATA"                                  , 0x0002edf0, 31, 0 },
{"MAC_PCU_BUF[893]", "DATA"                                  , 0x0002edf4, 31, 0 },
{"MAC_PCU_BUF[894]", "DATA"                                  , 0x0002edf8, 31, 0 },
{"MAC_PCU_BUF[895]", "DATA"                                  , 0x0002edfc, 31, 0 },
{"MAC_PCU_BUF[896]", "DATA"                                  , 0x0002ee00, 31, 0 },
{"MAC_PCU_BUF[897]", "DATA"                                  , 0x0002ee04, 31, 0 },
{"MAC_PCU_BUF[898]", "DATA"                                  , 0x0002ee08, 31, 0 },
{"MAC_PCU_BUF[899]", "DATA"                                  , 0x0002ee0c, 31, 0 },
{"MAC_PCU_BUF[900]", "DATA"                                  , 0x0002ee10, 31, 0 },
{"MAC_PCU_BUF[901]", "DATA"                                  , 0x0002ee14, 31, 0 },
{"MAC_PCU_BUF[902]", "DATA"                                  , 0x0002ee18, 31, 0 },
{"MAC_PCU_BUF[903]", "DATA"                                  , 0x0002ee1c, 31, 0 },
{"MAC_PCU_BUF[904]", "DATA"                                  , 0x0002ee20, 31, 0 },
{"MAC_PCU_BUF[905]", "DATA"                                  , 0x0002ee24, 31, 0 },
{"MAC_PCU_BUF[906]", "DATA"                                  , 0x0002ee28, 31, 0 },
{"MAC_PCU_BUF[907]", "DATA"                                  , 0x0002ee2c, 31, 0 },
{"MAC_PCU_BUF[908]", "DATA"                                  , 0x0002ee30, 31, 0 },
{"MAC_PCU_BUF[909]", "DATA"                                  , 0x0002ee34, 31, 0 },
{"MAC_PCU_BUF[910]", "DATA"                                  , 0x0002ee38, 31, 0 },
{"MAC_PCU_BUF[911]", "DATA"                                  , 0x0002ee3c, 31, 0 },
{"MAC_PCU_BUF[912]", "DATA"                                  , 0x0002ee40, 31, 0 },
{"MAC_PCU_BUF[913]", "DATA"                                  , 0x0002ee44, 31, 0 },
{"MAC_PCU_BUF[914]", "DATA"                                  , 0x0002ee48, 31, 0 },
{"MAC_PCU_BUF[915]", "DATA"                                  , 0x0002ee4c, 31, 0 },
{"MAC_PCU_BUF[916]", "DATA"                                  , 0x0002ee50, 31, 0 },
{"MAC_PCU_BUF[917]", "DATA"                                  , 0x0002ee54, 31, 0 },
{"MAC_PCU_BUF[918]", "DATA"                                  , 0x0002ee58, 31, 0 },
{"MAC_PCU_BUF[919]", "DATA"                                  , 0x0002ee5c, 31, 0 },
{"MAC_PCU_BUF[920]", "DATA"                                  , 0x0002ee60, 31, 0 },
{"MAC_PCU_BUF[921]", "DATA"                                  , 0x0002ee64, 31, 0 },
{"MAC_PCU_BUF[922]", "DATA"                                  , 0x0002ee68, 31, 0 },
{"MAC_PCU_BUF[923]", "DATA"                                  , 0x0002ee6c, 31, 0 },
{"MAC_PCU_BUF[924]", "DATA"                                  , 0x0002ee70, 31, 0 },
{"MAC_PCU_BUF[925]", "DATA"                                  , 0x0002ee74, 31, 0 },
{"MAC_PCU_BUF[926]", "DATA"                                  , 0x0002ee78, 31, 0 },
{"MAC_PCU_BUF[927]", "DATA"                                  , 0x0002ee7c, 31, 0 },
{"MAC_PCU_BUF[928]", "DATA"                                  , 0x0002ee80, 31, 0 },
{"MAC_PCU_BUF[929]", "DATA"                                  , 0x0002ee84, 31, 0 },
{"MAC_PCU_BUF[930]", "DATA"                                  , 0x0002ee88, 31, 0 },
{"MAC_PCU_BUF[931]", "DATA"                                  , 0x0002ee8c, 31, 0 },
{"MAC_PCU_BUF[932]", "DATA"                                  , 0x0002ee90, 31, 0 },
{"MAC_PCU_BUF[933]", "DATA"                                  , 0x0002ee94, 31, 0 },
{"MAC_PCU_BUF[934]", "DATA"                                  , 0x0002ee98, 31, 0 },
{"MAC_PCU_BUF[935]", "DATA"                                  , 0x0002ee9c, 31, 0 },
{"MAC_PCU_BUF[936]", "DATA"                                  , 0x0002eea0, 31, 0 },
{"MAC_PCU_BUF[937]", "DATA"                                  , 0x0002eea4, 31, 0 },
{"MAC_PCU_BUF[938]", "DATA"                                  , 0x0002eea8, 31, 0 },
{"MAC_PCU_BUF[939]", "DATA"                                  , 0x0002eeac, 31, 0 },
{"MAC_PCU_BUF[940]", "DATA"                                  , 0x0002eeb0, 31, 0 },
{"MAC_PCU_BUF[941]", "DATA"                                  , 0x0002eeb4, 31, 0 },
{"MAC_PCU_BUF[942]", "DATA"                                  , 0x0002eeb8, 31, 0 },
{"MAC_PCU_BUF[943]", "DATA"                                  , 0x0002eebc, 31, 0 },
{"MAC_PCU_BUF[944]", "DATA"                                  , 0x0002eec0, 31, 0 },
{"MAC_PCU_BUF[945]", "DATA"                                  , 0x0002eec4, 31, 0 },
{"MAC_PCU_BUF[946]", "DATA"                                  , 0x0002eec8, 31, 0 },
{"MAC_PCU_BUF[947]", "DATA"                                  , 0x0002eecc, 31, 0 },
{"MAC_PCU_BUF[948]", "DATA"                                  , 0x0002eed0, 31, 0 },
{"MAC_PCU_BUF[949]", "DATA"                                  , 0x0002eed4, 31, 0 },
{"MAC_PCU_BUF[950]", "DATA"                                  , 0x0002eed8, 31, 0 },
{"MAC_PCU_BUF[951]", "DATA"                                  , 0x0002eedc, 31, 0 },
{"MAC_PCU_BUF[952]", "DATA"                                  , 0x0002eee0, 31, 0 },
{"MAC_PCU_BUF[953]", "DATA"                                  , 0x0002eee4, 31, 0 },
{"MAC_PCU_BUF[954]", "DATA"                                  , 0x0002eee8, 31, 0 },
{"MAC_PCU_BUF[955]", "DATA"                                  , 0x0002eeec, 31, 0 },
{"MAC_PCU_BUF[956]", "DATA"                                  , 0x0002eef0, 31, 0 },
{"MAC_PCU_BUF[957]", "DATA"                                  , 0x0002eef4, 31, 0 },
{"MAC_PCU_BUF[958]", "DATA"                                  , 0x0002eef8, 31, 0 },
{"MAC_PCU_BUF[959]", "DATA"                                  , 0x0002eefc, 31, 0 },
{"MAC_PCU_BUF[960]", "DATA"                                  , 0x0002ef00, 31, 0 },
{"MAC_PCU_BUF[961]", "DATA"                                  , 0x0002ef04, 31, 0 },
{"MAC_PCU_BUF[962]", "DATA"                                  , 0x0002ef08, 31, 0 },
{"MAC_PCU_BUF[963]", "DATA"                                  , 0x0002ef0c, 31, 0 },
{"MAC_PCU_BUF[964]", "DATA"                                  , 0x0002ef10, 31, 0 },
{"MAC_PCU_BUF[965]", "DATA"                                  , 0x0002ef14, 31, 0 },
{"MAC_PCU_BUF[966]", "DATA"                                  , 0x0002ef18, 31, 0 },
{"MAC_PCU_BUF[967]", "DATA"                                  , 0x0002ef1c, 31, 0 },
{"MAC_PCU_BUF[968]", "DATA"                                  , 0x0002ef20, 31, 0 },
{"MAC_PCU_BUF[969]", "DATA"                                  , 0x0002ef24, 31, 0 },
{"MAC_PCU_BUF[970]", "DATA"                                  , 0x0002ef28, 31, 0 },
{"MAC_PCU_BUF[971]", "DATA"                                  , 0x0002ef2c, 31, 0 },
{"MAC_PCU_BUF[972]", "DATA"                                  , 0x0002ef30, 31, 0 },
{"MAC_PCU_BUF[973]", "DATA"                                  , 0x0002ef34, 31, 0 },
{"MAC_PCU_BUF[974]", "DATA"                                  , 0x0002ef38, 31, 0 },
{"MAC_PCU_BUF[975]", "DATA"                                  , 0x0002ef3c, 31, 0 },
{"MAC_PCU_BUF[976]", "DATA"                                  , 0x0002ef40, 31, 0 },
{"MAC_PCU_BUF[977]", "DATA"                                  , 0x0002ef44, 31, 0 },
{"MAC_PCU_BUF[978]", "DATA"                                  , 0x0002ef48, 31, 0 },
{"MAC_PCU_BUF[979]", "DATA"                                  , 0x0002ef4c, 31, 0 },
{"MAC_PCU_BUF[980]", "DATA"                                  , 0x0002ef50, 31, 0 },
{"MAC_PCU_BUF[981]", "DATA"                                  , 0x0002ef54, 31, 0 },
{"MAC_PCU_BUF[982]", "DATA"                                  , 0x0002ef58, 31, 0 },
{"MAC_PCU_BUF[983]", "DATA"                                  , 0x0002ef5c, 31, 0 },
{"MAC_PCU_BUF[984]", "DATA"                                  , 0x0002ef60, 31, 0 },
{"MAC_PCU_BUF[985]", "DATA"                                  , 0x0002ef64, 31, 0 },
{"MAC_PCU_BUF[986]", "DATA"                                  , 0x0002ef68, 31, 0 },
{"MAC_PCU_BUF[987]", "DATA"                                  , 0x0002ef6c, 31, 0 },
{"MAC_PCU_BUF[988]", "DATA"                                  , 0x0002ef70, 31, 0 },
{"MAC_PCU_BUF[989]", "DATA"                                  , 0x0002ef74, 31, 0 },
{"MAC_PCU_BUF[990]", "DATA"                                  , 0x0002ef78, 31, 0 },
{"MAC_PCU_BUF[991]", "DATA"                                  , 0x0002ef7c, 31, 0 },
{"MAC_PCU_BUF[992]", "DATA"                                  , 0x0002ef80, 31, 0 },
{"MAC_PCU_BUF[993]", "DATA"                                  , 0x0002ef84, 31, 0 },
{"MAC_PCU_BUF[994]", "DATA"                                  , 0x0002ef88, 31, 0 },
{"MAC_PCU_BUF[995]", "DATA"                                  , 0x0002ef8c, 31, 0 },
{"MAC_PCU_BUF[996]", "DATA"                                  , 0x0002ef90, 31, 0 },
{"MAC_PCU_BUF[997]", "DATA"                                  , 0x0002ef94, 31, 0 },
{"MAC_PCU_BUF[998]", "DATA"                                  , 0x0002ef98, 31, 0 },
{"MAC_PCU_BUF[999]", "DATA"                                  , 0x0002ef9c, 31, 0 },
{"MAC_PCU_BUF[1000]", "DATA"                                 , 0x0002efa0, 31, 0 },
{"MAC_PCU_BUF[1001]", "DATA"                                 , 0x0002efa4, 31, 0 },
{"MAC_PCU_BUF[1002]", "DATA"                                 , 0x0002efa8, 31, 0 },
{"MAC_PCU_BUF[1003]", "DATA"                                 , 0x0002efac, 31, 0 },
{"MAC_PCU_BUF[1004]", "DATA"                                 , 0x0002efb0, 31, 0 },
{"MAC_PCU_BUF[1005]", "DATA"                                 , 0x0002efb4, 31, 0 },
{"MAC_PCU_BUF[1006]", "DATA"                                 , 0x0002efb8, 31, 0 },
{"MAC_PCU_BUF[1007]", "DATA"                                 , 0x0002efbc, 31, 0 },
{"MAC_PCU_BUF[1008]", "DATA"                                 , 0x0002efc0, 31, 0 },
{"MAC_PCU_BUF[1009]", "DATA"                                 , 0x0002efc4, 31, 0 },
{"MAC_PCU_BUF[1010]", "DATA"                                 , 0x0002efc8, 31, 0 },
{"MAC_PCU_BUF[1011]", "DATA"                                 , 0x0002efcc, 31, 0 },
{"MAC_PCU_BUF[1012]", "DATA"                                 , 0x0002efd0, 31, 0 },
{"MAC_PCU_BUF[1013]", "DATA"                                 , 0x0002efd4, 31, 0 },
{"MAC_PCU_BUF[1014]", "DATA"                                 , 0x0002efd8, 31, 0 },
{"MAC_PCU_BUF[1015]", "DATA"                                 , 0x0002efdc, 31, 0 },
{"MAC_PCU_BUF[1016]", "DATA"                                 , 0x0002efe0, 31, 0 },
{"MAC_PCU_BUF[1017]", "DATA"                                 , 0x0002efe4, 31, 0 },
{"MAC_PCU_BUF[1018]", "DATA"                                 , 0x0002efe8, 31, 0 },
{"MAC_PCU_BUF[1019]", "DATA"                                 , 0x0002efec, 31, 0 },
{"MAC_PCU_BUF[1020]", "DATA"                                 , 0x0002eff0, 31, 0 },
{"MAC_PCU_BUF[1021]", "DATA"                                 , 0x0002eff4, 31, 0 },
{"MAC_PCU_BUF[1022]", "DATA"                                 , 0x0002eff8, 31, 0 },
{"MAC_PCU_BUF[1023]", "DATA"                                 , 0x0002effc, 31, 0 },
{"MAC_PCU_BUF[1024]", "DATA"                                 , 0x0002f000, 31, 0 },
{"MAC_PCU_BUF[1025]", "DATA"                                 , 0x0002f004, 31, 0 },
{"MAC_PCU_BUF[1026]", "DATA"                                 , 0x0002f008, 31, 0 },
{"MAC_PCU_BUF[1027]", "DATA"                                 , 0x0002f00c, 31, 0 },
{"MAC_PCU_BUF[1028]", "DATA"                                 , 0x0002f010, 31, 0 },
{"MAC_PCU_BUF[1029]", "DATA"                                 , 0x0002f014, 31, 0 },
{"MAC_PCU_BUF[1030]", "DATA"                                 , 0x0002f018, 31, 0 },
{"MAC_PCU_BUF[1031]", "DATA"                                 , 0x0002f01c, 31, 0 },
{"MAC_PCU_BUF[1032]", "DATA"                                 , 0x0002f020, 31, 0 },
{"MAC_PCU_BUF[1033]", "DATA"                                 , 0x0002f024, 31, 0 },
{"MAC_PCU_BUF[1034]", "DATA"                                 , 0x0002f028, 31, 0 },
{"MAC_PCU_BUF[1035]", "DATA"                                 , 0x0002f02c, 31, 0 },
{"MAC_PCU_BUF[1036]", "DATA"                                 , 0x0002f030, 31, 0 },
{"MAC_PCU_BUF[1037]", "DATA"                                 , 0x0002f034, 31, 0 },
{"MAC_PCU_BUF[1038]", "DATA"                                 , 0x0002f038, 31, 0 },
{"MAC_PCU_BUF[1039]", "DATA"                                 , 0x0002f03c, 31, 0 },
{"MAC_PCU_BUF[1040]", "DATA"                                 , 0x0002f040, 31, 0 },
{"MAC_PCU_BUF[1041]", "DATA"                                 , 0x0002f044, 31, 0 },
{"MAC_PCU_BUF[1042]", "DATA"                                 , 0x0002f048, 31, 0 },
{"MAC_PCU_BUF[1043]", "DATA"                                 , 0x0002f04c, 31, 0 },
{"MAC_PCU_BUF[1044]", "DATA"                                 , 0x0002f050, 31, 0 },
{"MAC_PCU_BUF[1045]", "DATA"                                 , 0x0002f054, 31, 0 },
{"MAC_PCU_BUF[1046]", "DATA"                                 , 0x0002f058, 31, 0 },
{"MAC_PCU_BUF[1047]", "DATA"                                 , 0x0002f05c, 31, 0 },
{"MAC_PCU_BUF[1048]", "DATA"                                 , 0x0002f060, 31, 0 },
{"MAC_PCU_BUF[1049]", "DATA"                                 , 0x0002f064, 31, 0 },
{"MAC_PCU_BUF[1050]", "DATA"                                 , 0x0002f068, 31, 0 },
{"MAC_PCU_BUF[1051]", "DATA"                                 , 0x0002f06c, 31, 0 },
{"MAC_PCU_BUF[1052]", "DATA"                                 , 0x0002f070, 31, 0 },
{"MAC_PCU_BUF[1053]", "DATA"                                 , 0x0002f074, 31, 0 },
{"MAC_PCU_BUF[1054]", "DATA"                                 , 0x0002f078, 31, 0 },
{"MAC_PCU_BUF[1055]", "DATA"                                 , 0x0002f07c, 31, 0 },
{"MAC_PCU_BUF[1056]", "DATA"                                 , 0x0002f080, 31, 0 },
{"MAC_PCU_BUF[1057]", "DATA"                                 , 0x0002f084, 31, 0 },
{"MAC_PCU_BUF[1058]", "DATA"                                 , 0x0002f088, 31, 0 },
{"MAC_PCU_BUF[1059]", "DATA"                                 , 0x0002f08c, 31, 0 },
{"MAC_PCU_BUF[1060]", "DATA"                                 , 0x0002f090, 31, 0 },
{"MAC_PCU_BUF[1061]", "DATA"                                 , 0x0002f094, 31, 0 },
{"MAC_PCU_BUF[1062]", "DATA"                                 , 0x0002f098, 31, 0 },
{"MAC_PCU_BUF[1063]", "DATA"                                 , 0x0002f09c, 31, 0 },
{"MAC_PCU_BUF[1064]", "DATA"                                 , 0x0002f0a0, 31, 0 },
{"MAC_PCU_BUF[1065]", "DATA"                                 , 0x0002f0a4, 31, 0 },
{"MAC_PCU_BUF[1066]", "DATA"                                 , 0x0002f0a8, 31, 0 },
{"MAC_PCU_BUF[1067]", "DATA"                                 , 0x0002f0ac, 31, 0 },
{"MAC_PCU_BUF[1068]", "DATA"                                 , 0x0002f0b0, 31, 0 },
{"MAC_PCU_BUF[1069]", "DATA"                                 , 0x0002f0b4, 31, 0 },
{"MAC_PCU_BUF[1070]", "DATA"                                 , 0x0002f0b8, 31, 0 },
{"MAC_PCU_BUF[1071]", "DATA"                                 , 0x0002f0bc, 31, 0 },
{"MAC_PCU_BUF[1072]", "DATA"                                 , 0x0002f0c0, 31, 0 },
{"MAC_PCU_BUF[1073]", "DATA"                                 , 0x0002f0c4, 31, 0 },
{"MAC_PCU_BUF[1074]", "DATA"                                 , 0x0002f0c8, 31, 0 },
{"MAC_PCU_BUF[1075]", "DATA"                                 , 0x0002f0cc, 31, 0 },
{"MAC_PCU_BUF[1076]", "DATA"                                 , 0x0002f0d0, 31, 0 },
{"MAC_PCU_BUF[1077]", "DATA"                                 , 0x0002f0d4, 31, 0 },
{"MAC_PCU_BUF[1078]", "DATA"                                 , 0x0002f0d8, 31, 0 },
{"MAC_PCU_BUF[1079]", "DATA"                                 , 0x0002f0dc, 31, 0 },
{"MAC_PCU_BUF[1080]", "DATA"                                 , 0x0002f0e0, 31, 0 },
{"MAC_PCU_BUF[1081]", "DATA"                                 , 0x0002f0e4, 31, 0 },
{"MAC_PCU_BUF[1082]", "DATA"                                 , 0x0002f0e8, 31, 0 },
{"MAC_PCU_BUF[1083]", "DATA"                                 , 0x0002f0ec, 31, 0 },
{"MAC_PCU_BUF[1084]", "DATA"                                 , 0x0002f0f0, 31, 0 },
{"MAC_PCU_BUF[1085]", "DATA"                                 , 0x0002f0f4, 31, 0 },
{"MAC_PCU_BUF[1086]", "DATA"                                 , 0x0002f0f8, 31, 0 },
{"MAC_PCU_BUF[1087]", "DATA"                                 , 0x0002f0fc, 31, 0 },
{"MAC_PCU_BUF[1088]", "DATA"                                 , 0x0002f100, 31, 0 },
{"MAC_PCU_BUF[1089]", "DATA"                                 , 0x0002f104, 31, 0 },
{"MAC_PCU_BUF[1090]", "DATA"                                 , 0x0002f108, 31, 0 },
{"MAC_PCU_BUF[1091]", "DATA"                                 , 0x0002f10c, 31, 0 },
{"MAC_PCU_BUF[1092]", "DATA"                                 , 0x0002f110, 31, 0 },
{"MAC_PCU_BUF[1093]", "DATA"                                 , 0x0002f114, 31, 0 },
{"MAC_PCU_BUF[1094]", "DATA"                                 , 0x0002f118, 31, 0 },
{"MAC_PCU_BUF[1095]", "DATA"                                 , 0x0002f11c, 31, 0 },
{"MAC_PCU_BUF[1096]", "DATA"                                 , 0x0002f120, 31, 0 },
{"MAC_PCU_BUF[1097]", "DATA"                                 , 0x0002f124, 31, 0 },
{"MAC_PCU_BUF[1098]", "DATA"                                 , 0x0002f128, 31, 0 },
{"MAC_PCU_BUF[1099]", "DATA"                                 , 0x0002f12c, 31, 0 },
{"MAC_PCU_BUF[1100]", "DATA"                                 , 0x0002f130, 31, 0 },
{"MAC_PCU_BUF[1101]", "DATA"                                 , 0x0002f134, 31, 0 },
{"MAC_PCU_BUF[1102]", "DATA"                                 , 0x0002f138, 31, 0 },
{"MAC_PCU_BUF[1103]", "DATA"                                 , 0x0002f13c, 31, 0 },
{"MAC_PCU_BUF[1104]", "DATA"                                 , 0x0002f140, 31, 0 },
{"MAC_PCU_BUF[1105]", "DATA"                                 , 0x0002f144, 31, 0 },
{"MAC_PCU_BUF[1106]", "DATA"                                 , 0x0002f148, 31, 0 },
{"MAC_PCU_BUF[1107]", "DATA"                                 , 0x0002f14c, 31, 0 },
{"MAC_PCU_BUF[1108]", "DATA"                                 , 0x0002f150, 31, 0 },
{"MAC_PCU_BUF[1109]", "DATA"                                 , 0x0002f154, 31, 0 },
{"MAC_PCU_BUF[1110]", "DATA"                                 , 0x0002f158, 31, 0 },
{"MAC_PCU_BUF[1111]", "DATA"                                 , 0x0002f15c, 31, 0 },
{"MAC_PCU_BUF[1112]", "DATA"                                 , 0x0002f160, 31, 0 },
{"MAC_PCU_BUF[1113]", "DATA"                                 , 0x0002f164, 31, 0 },
{"MAC_PCU_BUF[1114]", "DATA"                                 , 0x0002f168, 31, 0 },
{"MAC_PCU_BUF[1115]", "DATA"                                 , 0x0002f16c, 31, 0 },
{"MAC_PCU_BUF[1116]", "DATA"                                 , 0x0002f170, 31, 0 },
{"MAC_PCU_BUF[1117]", "DATA"                                 , 0x0002f174, 31, 0 },
{"MAC_PCU_BUF[1118]", "DATA"                                 , 0x0002f178, 31, 0 },
{"MAC_PCU_BUF[1119]", "DATA"                                 , 0x0002f17c, 31, 0 },
{"MAC_PCU_BUF[1120]", "DATA"                                 , 0x0002f180, 31, 0 },
{"MAC_PCU_BUF[1121]", "DATA"                                 , 0x0002f184, 31, 0 },
{"MAC_PCU_BUF[1122]", "DATA"                                 , 0x0002f188, 31, 0 },
{"MAC_PCU_BUF[1123]", "DATA"                                 , 0x0002f18c, 31, 0 },
{"MAC_PCU_BUF[1124]", "DATA"                                 , 0x0002f190, 31, 0 },
{"MAC_PCU_BUF[1125]", "DATA"                                 , 0x0002f194, 31, 0 },
{"MAC_PCU_BUF[1126]", "DATA"                                 , 0x0002f198, 31, 0 },
{"MAC_PCU_BUF[1127]", "DATA"                                 , 0x0002f19c, 31, 0 },
{"MAC_PCU_BUF[1128]", "DATA"                                 , 0x0002f1a0, 31, 0 },
{"MAC_PCU_BUF[1129]", "DATA"                                 , 0x0002f1a4, 31, 0 },
{"MAC_PCU_BUF[1130]", "DATA"                                 , 0x0002f1a8, 31, 0 },
{"MAC_PCU_BUF[1131]", "DATA"                                 , 0x0002f1ac, 31, 0 },
{"MAC_PCU_BUF[1132]", "DATA"                                 , 0x0002f1b0, 31, 0 },
{"MAC_PCU_BUF[1133]", "DATA"                                 , 0x0002f1b4, 31, 0 },
{"MAC_PCU_BUF[1134]", "DATA"                                 , 0x0002f1b8, 31, 0 },
{"MAC_PCU_BUF[1135]", "DATA"                                 , 0x0002f1bc, 31, 0 },
{"MAC_PCU_BUF[1136]", "DATA"                                 , 0x0002f1c0, 31, 0 },
{"MAC_PCU_BUF[1137]", "DATA"                                 , 0x0002f1c4, 31, 0 },
{"MAC_PCU_BUF[1138]", "DATA"                                 , 0x0002f1c8, 31, 0 },
{"MAC_PCU_BUF[1139]", "DATA"                                 , 0x0002f1cc, 31, 0 },
{"MAC_PCU_BUF[1140]", "DATA"                                 , 0x0002f1d0, 31, 0 },
{"MAC_PCU_BUF[1141]", "DATA"                                 , 0x0002f1d4, 31, 0 },
{"MAC_PCU_BUF[1142]", "DATA"                                 , 0x0002f1d8, 31, 0 },
{"MAC_PCU_BUF[1143]", "DATA"                                 , 0x0002f1dc, 31, 0 },
{"MAC_PCU_BUF[1144]", "DATA"                                 , 0x0002f1e0, 31, 0 },
{"MAC_PCU_BUF[1145]", "DATA"                                 , 0x0002f1e4, 31, 0 },
{"MAC_PCU_BUF[1146]", "DATA"                                 , 0x0002f1e8, 31, 0 },
{"MAC_PCU_BUF[1147]", "DATA"                                 , 0x0002f1ec, 31, 0 },
{"MAC_PCU_BUF[1148]", "DATA"                                 , 0x0002f1f0, 31, 0 },
{"MAC_PCU_BUF[1149]", "DATA"                                 , 0x0002f1f4, 31, 0 },
{"MAC_PCU_BUF[1150]", "DATA"                                 , 0x0002f1f8, 31, 0 },
{"MAC_PCU_BUF[1151]", "DATA"                                 , 0x0002f1fc, 31, 0 },
{"MAC_PCU_BUF[1152]", "DATA"                                 , 0x0002f200, 31, 0 },
{"MAC_PCU_BUF[1153]", "DATA"                                 , 0x0002f204, 31, 0 },
{"MAC_PCU_BUF[1154]", "DATA"                                 , 0x0002f208, 31, 0 },
{"MAC_PCU_BUF[1155]", "DATA"                                 , 0x0002f20c, 31, 0 },
{"MAC_PCU_BUF[1156]", "DATA"                                 , 0x0002f210, 31, 0 },
{"MAC_PCU_BUF[1157]", "DATA"                                 , 0x0002f214, 31, 0 },
{"MAC_PCU_BUF[1158]", "DATA"                                 , 0x0002f218, 31, 0 },
{"MAC_PCU_BUF[1159]", "DATA"                                 , 0x0002f21c, 31, 0 },
{"MAC_PCU_BUF[1160]", "DATA"                                 , 0x0002f220, 31, 0 },
{"MAC_PCU_BUF[1161]", "DATA"                                 , 0x0002f224, 31, 0 },
{"MAC_PCU_BUF[1162]", "DATA"                                 , 0x0002f228, 31, 0 },
{"MAC_PCU_BUF[1163]", "DATA"                                 , 0x0002f22c, 31, 0 },
{"MAC_PCU_BUF[1164]", "DATA"                                 , 0x0002f230, 31, 0 },
{"MAC_PCU_BUF[1165]", "DATA"                                 , 0x0002f234, 31, 0 },
{"MAC_PCU_BUF[1166]", "DATA"                                 , 0x0002f238, 31, 0 },
{"MAC_PCU_BUF[1167]", "DATA"                                 , 0x0002f23c, 31, 0 },
{"MAC_PCU_BUF[1168]", "DATA"                                 , 0x0002f240, 31, 0 },
{"MAC_PCU_BUF[1169]", "DATA"                                 , 0x0002f244, 31, 0 },
{"MAC_PCU_BUF[1170]", "DATA"                                 , 0x0002f248, 31, 0 },
{"MAC_PCU_BUF[1171]", "DATA"                                 , 0x0002f24c, 31, 0 },
{"MAC_PCU_BUF[1172]", "DATA"                                 , 0x0002f250, 31, 0 },
{"MAC_PCU_BUF[1173]", "DATA"                                 , 0x0002f254, 31, 0 },
{"MAC_PCU_BUF[1174]", "DATA"                                 , 0x0002f258, 31, 0 },
{"MAC_PCU_BUF[1175]", "DATA"                                 , 0x0002f25c, 31, 0 },
{"MAC_PCU_BUF[1176]", "DATA"                                 , 0x0002f260, 31, 0 },
{"MAC_PCU_BUF[1177]", "DATA"                                 , 0x0002f264, 31, 0 },
{"MAC_PCU_BUF[1178]", "DATA"                                 , 0x0002f268, 31, 0 },
{"MAC_PCU_BUF[1179]", "DATA"                                 , 0x0002f26c, 31, 0 },
{"MAC_PCU_BUF[1180]", "DATA"                                 , 0x0002f270, 31, 0 },
{"MAC_PCU_BUF[1181]", "DATA"                                 , 0x0002f274, 31, 0 },
{"MAC_PCU_BUF[1182]", "DATA"                                 , 0x0002f278, 31, 0 },
{"MAC_PCU_BUF[1183]", "DATA"                                 , 0x0002f27c, 31, 0 },
{"MAC_PCU_BUF[1184]", "DATA"                                 , 0x0002f280, 31, 0 },
{"MAC_PCU_BUF[1185]", "DATA"                                 , 0x0002f284, 31, 0 },
{"MAC_PCU_BUF[1186]", "DATA"                                 , 0x0002f288, 31, 0 },
{"MAC_PCU_BUF[1187]", "DATA"                                 , 0x0002f28c, 31, 0 },
{"MAC_PCU_BUF[1188]", "DATA"                                 , 0x0002f290, 31, 0 },
{"MAC_PCU_BUF[1189]", "DATA"                                 , 0x0002f294, 31, 0 },
{"MAC_PCU_BUF[1190]", "DATA"                                 , 0x0002f298, 31, 0 },
{"MAC_PCU_BUF[1191]", "DATA"                                 , 0x0002f29c, 31, 0 },
{"MAC_PCU_BUF[1192]", "DATA"                                 , 0x0002f2a0, 31, 0 },
{"MAC_PCU_BUF[1193]", "DATA"                                 , 0x0002f2a4, 31, 0 },
{"MAC_PCU_BUF[1194]", "DATA"                                 , 0x0002f2a8, 31, 0 },
{"MAC_PCU_BUF[1195]", "DATA"                                 , 0x0002f2ac, 31, 0 },
{"MAC_PCU_BUF[1196]", "DATA"                                 , 0x0002f2b0, 31, 0 },
{"MAC_PCU_BUF[1197]", "DATA"                                 , 0x0002f2b4, 31, 0 },
{"MAC_PCU_BUF[1198]", "DATA"                                 , 0x0002f2b8, 31, 0 },
{"MAC_PCU_BUF[1199]", "DATA"                                 , 0x0002f2bc, 31, 0 },
{"MAC_PCU_BUF[1200]", "DATA"                                 , 0x0002f2c0, 31, 0 },
{"MAC_PCU_BUF[1201]", "DATA"                                 , 0x0002f2c4, 31, 0 },
{"MAC_PCU_BUF[1202]", "DATA"                                 , 0x0002f2c8, 31, 0 },
{"MAC_PCU_BUF[1203]", "DATA"                                 , 0x0002f2cc, 31, 0 },
{"MAC_PCU_BUF[1204]", "DATA"                                 , 0x0002f2d0, 31, 0 },
{"MAC_PCU_BUF[1205]", "DATA"                                 , 0x0002f2d4, 31, 0 },
{"MAC_PCU_BUF[1206]", "DATA"                                 , 0x0002f2d8, 31, 0 },
{"MAC_PCU_BUF[1207]", "DATA"                                 , 0x0002f2dc, 31, 0 },
{"MAC_PCU_BUF[1208]", "DATA"                                 , 0x0002f2e0, 31, 0 },
{"MAC_PCU_BUF[1209]", "DATA"                                 , 0x0002f2e4, 31, 0 },
{"MAC_PCU_BUF[1210]", "DATA"                                 , 0x0002f2e8, 31, 0 },
{"MAC_PCU_BUF[1211]", "DATA"                                 , 0x0002f2ec, 31, 0 },
{"MAC_PCU_BUF[1212]", "DATA"                                 , 0x0002f2f0, 31, 0 },
{"MAC_PCU_BUF[1213]", "DATA"                                 , 0x0002f2f4, 31, 0 },
{"MAC_PCU_BUF[1214]", "DATA"                                 , 0x0002f2f8, 31, 0 },
{"MAC_PCU_BUF[1215]", "DATA"                                 , 0x0002f2fc, 31, 0 },
{"MAC_PCU_BUF[1216]", "DATA"                                 , 0x0002f300, 31, 0 },
{"MAC_PCU_BUF[1217]", "DATA"                                 , 0x0002f304, 31, 0 },
{"MAC_PCU_BUF[1218]", "DATA"                                 , 0x0002f308, 31, 0 },
{"MAC_PCU_BUF[1219]", "DATA"                                 , 0x0002f30c, 31, 0 },
{"MAC_PCU_BUF[1220]", "DATA"                                 , 0x0002f310, 31, 0 },
{"MAC_PCU_BUF[1221]", "DATA"                                 , 0x0002f314, 31, 0 },
{"MAC_PCU_BUF[1222]", "DATA"                                 , 0x0002f318, 31, 0 },
{"MAC_PCU_BUF[1223]", "DATA"                                 , 0x0002f31c, 31, 0 },
{"MAC_PCU_BUF[1224]", "DATA"                                 , 0x0002f320, 31, 0 },
{"MAC_PCU_BUF[1225]", "DATA"                                 , 0x0002f324, 31, 0 },
{"MAC_PCU_BUF[1226]", "DATA"                                 , 0x0002f328, 31, 0 },
{"MAC_PCU_BUF[1227]", "DATA"                                 , 0x0002f32c, 31, 0 },
{"MAC_PCU_BUF[1228]", "DATA"                                 , 0x0002f330, 31, 0 },
{"MAC_PCU_BUF[1229]", "DATA"                                 , 0x0002f334, 31, 0 },
{"MAC_PCU_BUF[1230]", "DATA"                                 , 0x0002f338, 31, 0 },
{"MAC_PCU_BUF[1231]", "DATA"                                 , 0x0002f33c, 31, 0 },
{"MAC_PCU_BUF[1232]", "DATA"                                 , 0x0002f340, 31, 0 },
{"MAC_PCU_BUF[1233]", "DATA"                                 , 0x0002f344, 31, 0 },
{"MAC_PCU_BUF[1234]", "DATA"                                 , 0x0002f348, 31, 0 },
{"MAC_PCU_BUF[1235]", "DATA"                                 , 0x0002f34c, 31, 0 },
{"MAC_PCU_BUF[1236]", "DATA"                                 , 0x0002f350, 31, 0 },
{"MAC_PCU_BUF[1237]", "DATA"                                 , 0x0002f354, 31, 0 },
{"MAC_PCU_BUF[1238]", "DATA"                                 , 0x0002f358, 31, 0 },
{"MAC_PCU_BUF[1239]", "DATA"                                 , 0x0002f35c, 31, 0 },
{"MAC_PCU_BUF[1240]", "DATA"                                 , 0x0002f360, 31, 0 },
{"MAC_PCU_BUF[1241]", "DATA"                                 , 0x0002f364, 31, 0 },
{"MAC_PCU_BUF[1242]", "DATA"                                 , 0x0002f368, 31, 0 },
{"MAC_PCU_BUF[1243]", "DATA"                                 , 0x0002f36c, 31, 0 },
{"MAC_PCU_BUF[1244]", "DATA"                                 , 0x0002f370, 31, 0 },
{"MAC_PCU_BUF[1245]", "DATA"                                 , 0x0002f374, 31, 0 },
{"MAC_PCU_BUF[1246]", "DATA"                                 , 0x0002f378, 31, 0 },
{"MAC_PCU_BUF[1247]", "DATA"                                 , 0x0002f37c, 31, 0 },
{"MAC_PCU_BUF[1248]", "DATA"                                 , 0x0002f380, 31, 0 },
{"MAC_PCU_BUF[1249]", "DATA"                                 , 0x0002f384, 31, 0 },
{"MAC_PCU_BUF[1250]", "DATA"                                 , 0x0002f388, 31, 0 },
{"MAC_PCU_BUF[1251]", "DATA"                                 , 0x0002f38c, 31, 0 },
{"MAC_PCU_BUF[1252]", "DATA"                                 , 0x0002f390, 31, 0 },
{"MAC_PCU_BUF[1253]", "DATA"                                 , 0x0002f394, 31, 0 },
{"MAC_PCU_BUF[1254]", "DATA"                                 , 0x0002f398, 31, 0 },
{"MAC_PCU_BUF[1255]", "DATA"                                 , 0x0002f39c, 31, 0 },
{"MAC_PCU_BUF[1256]", "DATA"                                 , 0x0002f3a0, 31, 0 },
{"MAC_PCU_BUF[1257]", "DATA"                                 , 0x0002f3a4, 31, 0 },
{"MAC_PCU_BUF[1258]", "DATA"                                 , 0x0002f3a8, 31, 0 },
{"MAC_PCU_BUF[1259]", "DATA"                                 , 0x0002f3ac, 31, 0 },
{"MAC_PCU_BUF[1260]", "DATA"                                 , 0x0002f3b0, 31, 0 },
{"MAC_PCU_BUF[1261]", "DATA"                                 , 0x0002f3b4, 31, 0 },
{"MAC_PCU_BUF[1262]", "DATA"                                 , 0x0002f3b8, 31, 0 },
{"MAC_PCU_BUF[1263]", "DATA"                                 , 0x0002f3bc, 31, 0 },
{"MAC_PCU_BUF[1264]", "DATA"                                 , 0x0002f3c0, 31, 0 },
{"MAC_PCU_BUF[1265]", "DATA"                                 , 0x0002f3c4, 31, 0 },
{"MAC_PCU_BUF[1266]", "DATA"                                 , 0x0002f3c8, 31, 0 },
{"MAC_PCU_BUF[1267]", "DATA"                                 , 0x0002f3cc, 31, 0 },
{"MAC_PCU_BUF[1268]", "DATA"                                 , 0x0002f3d0, 31, 0 },
{"MAC_PCU_BUF[1269]", "DATA"                                 , 0x0002f3d4, 31, 0 },
{"MAC_PCU_BUF[1270]", "DATA"                                 , 0x0002f3d8, 31, 0 },
{"MAC_PCU_BUF[1271]", "DATA"                                 , 0x0002f3dc, 31, 0 },
{"MAC_PCU_BUF[1272]", "DATA"                                 , 0x0002f3e0, 31, 0 },
{"MAC_PCU_BUF[1273]", "DATA"                                 , 0x0002f3e4, 31, 0 },
{"MAC_PCU_BUF[1274]", "DATA"                                 , 0x0002f3e8, 31, 0 },
{"MAC_PCU_BUF[1275]", "DATA"                                 , 0x0002f3ec, 31, 0 },
{"MAC_PCU_BUF[1276]", "DATA"                                 , 0x0002f3f0, 31, 0 },
{"MAC_PCU_BUF[1277]", "DATA"                                 , 0x0002f3f4, 31, 0 },
{"MAC_PCU_BUF[1278]", "DATA"                                 , 0x0002f3f8, 31, 0 },
{"MAC_PCU_BUF[1279]", "DATA"                                 , 0x0002f3fc, 31, 0 },
{"MAC_PCU_BUF[1280]", "DATA"                                 , 0x0002f400, 31, 0 },
{"MAC_PCU_BUF[1281]", "DATA"                                 , 0x0002f404, 31, 0 },
{"MAC_PCU_BUF[1282]", "DATA"                                 , 0x0002f408, 31, 0 },
{"MAC_PCU_BUF[1283]", "DATA"                                 , 0x0002f40c, 31, 0 },
{"MAC_PCU_BUF[1284]", "DATA"                                 , 0x0002f410, 31, 0 },
{"MAC_PCU_BUF[1285]", "DATA"                                 , 0x0002f414, 31, 0 },
{"MAC_PCU_BUF[1286]", "DATA"                                 , 0x0002f418, 31, 0 },
{"MAC_PCU_BUF[1287]", "DATA"                                 , 0x0002f41c, 31, 0 },
{"MAC_PCU_BUF[1288]", "DATA"                                 , 0x0002f420, 31, 0 },
{"MAC_PCU_BUF[1289]", "DATA"                                 , 0x0002f424, 31, 0 },
{"MAC_PCU_BUF[1290]", "DATA"                                 , 0x0002f428, 31, 0 },
{"MAC_PCU_BUF[1291]", "DATA"                                 , 0x0002f42c, 31, 0 },
{"MAC_PCU_BUF[1292]", "DATA"                                 , 0x0002f430, 31, 0 },
{"MAC_PCU_BUF[1293]", "DATA"                                 , 0x0002f434, 31, 0 },
{"MAC_PCU_BUF[1294]", "DATA"                                 , 0x0002f438, 31, 0 },
{"MAC_PCU_BUF[1295]", "DATA"                                 , 0x0002f43c, 31, 0 },
{"MAC_PCU_BUF[1296]", "DATA"                                 , 0x0002f440, 31, 0 },
{"MAC_PCU_BUF[1297]", "DATA"                                 , 0x0002f444, 31, 0 },
{"MAC_PCU_BUF[1298]", "DATA"                                 , 0x0002f448, 31, 0 },
{"MAC_PCU_BUF[1299]", "DATA"                                 , 0x0002f44c, 31, 0 },
{"MAC_PCU_BUF[1300]", "DATA"                                 , 0x0002f450, 31, 0 },
{"MAC_PCU_BUF[1301]", "DATA"                                 , 0x0002f454, 31, 0 },
{"MAC_PCU_BUF[1302]", "DATA"                                 , 0x0002f458, 31, 0 },
{"MAC_PCU_BUF[1303]", "DATA"                                 , 0x0002f45c, 31, 0 },
{"MAC_PCU_BUF[1304]", "DATA"                                 , 0x0002f460, 31, 0 },
{"MAC_PCU_BUF[1305]", "DATA"                                 , 0x0002f464, 31, 0 },
{"MAC_PCU_BUF[1306]", "DATA"                                 , 0x0002f468, 31, 0 },
{"MAC_PCU_BUF[1307]", "DATA"                                 , 0x0002f46c, 31, 0 },
{"MAC_PCU_BUF[1308]", "DATA"                                 , 0x0002f470, 31, 0 },
{"MAC_PCU_BUF[1309]", "DATA"                                 , 0x0002f474, 31, 0 },
{"MAC_PCU_BUF[1310]", "DATA"                                 , 0x0002f478, 31, 0 },
{"MAC_PCU_BUF[1311]", "DATA"                                 , 0x0002f47c, 31, 0 },
{"MAC_PCU_BUF[1312]", "DATA"                                 , 0x0002f480, 31, 0 },
{"MAC_PCU_BUF[1313]", "DATA"                                 , 0x0002f484, 31, 0 },
{"MAC_PCU_BUF[1314]", "DATA"                                 , 0x0002f488, 31, 0 },
{"MAC_PCU_BUF[1315]", "DATA"                                 , 0x0002f48c, 31, 0 },
{"MAC_PCU_BUF[1316]", "DATA"                                 , 0x0002f490, 31, 0 },
{"MAC_PCU_BUF[1317]", "DATA"                                 , 0x0002f494, 31, 0 },
{"MAC_PCU_BUF[1318]", "DATA"                                 , 0x0002f498, 31, 0 },
{"MAC_PCU_BUF[1319]", "DATA"                                 , 0x0002f49c, 31, 0 },
{"MAC_PCU_BUF[1320]", "DATA"                                 , 0x0002f4a0, 31, 0 },
{"MAC_PCU_BUF[1321]", "DATA"                                 , 0x0002f4a4, 31, 0 },
{"MAC_PCU_BUF[1322]", "DATA"                                 , 0x0002f4a8, 31, 0 },
{"MAC_PCU_BUF[1323]", "DATA"                                 , 0x0002f4ac, 31, 0 },
{"MAC_PCU_BUF[1324]", "DATA"                                 , 0x0002f4b0, 31, 0 },
{"MAC_PCU_BUF[1325]", "DATA"                                 , 0x0002f4b4, 31, 0 },
{"MAC_PCU_BUF[1326]", "DATA"                                 , 0x0002f4b8, 31, 0 },
{"MAC_PCU_BUF[1327]", "DATA"                                 , 0x0002f4bc, 31, 0 },
{"MAC_PCU_BUF[1328]", "DATA"                                 , 0x0002f4c0, 31, 0 },
{"MAC_PCU_BUF[1329]", "DATA"                                 , 0x0002f4c4, 31, 0 },
{"MAC_PCU_BUF[1330]", "DATA"                                 , 0x0002f4c8, 31, 0 },
{"MAC_PCU_BUF[1331]", "DATA"                                 , 0x0002f4cc, 31, 0 },
{"MAC_PCU_BUF[1332]", "DATA"                                 , 0x0002f4d0, 31, 0 },
{"MAC_PCU_BUF[1333]", "DATA"                                 , 0x0002f4d4, 31, 0 },
{"MAC_PCU_BUF[1334]", "DATA"                                 , 0x0002f4d8, 31, 0 },
{"MAC_PCU_BUF[1335]", "DATA"                                 , 0x0002f4dc, 31, 0 },
{"MAC_PCU_BUF[1336]", "DATA"                                 , 0x0002f4e0, 31, 0 },
{"MAC_PCU_BUF[1337]", "DATA"                                 , 0x0002f4e4, 31, 0 },
{"MAC_PCU_BUF[1338]", "DATA"                                 , 0x0002f4e8, 31, 0 },
{"MAC_PCU_BUF[1339]", "DATA"                                 , 0x0002f4ec, 31, 0 },
{"MAC_PCU_BUF[1340]", "DATA"                                 , 0x0002f4f0, 31, 0 },
{"MAC_PCU_BUF[1341]", "DATA"                                 , 0x0002f4f4, 31, 0 },
{"MAC_PCU_BUF[1342]", "DATA"                                 , 0x0002f4f8, 31, 0 },
{"MAC_PCU_BUF[1343]", "DATA"                                 , 0x0002f4fc, 31, 0 },
{"MAC_PCU_BUF[1344]", "DATA"                                 , 0x0002f500, 31, 0 },
{"MAC_PCU_BUF[1345]", "DATA"                                 , 0x0002f504, 31, 0 },
{"MAC_PCU_BUF[1346]", "DATA"                                 , 0x0002f508, 31, 0 },
{"MAC_PCU_BUF[1347]", "DATA"                                 , 0x0002f50c, 31, 0 },
{"MAC_PCU_BUF[1348]", "DATA"                                 , 0x0002f510, 31, 0 },
{"MAC_PCU_BUF[1349]", "DATA"                                 , 0x0002f514, 31, 0 },
{"MAC_PCU_BUF[1350]", "DATA"                                 , 0x0002f518, 31, 0 },
{"MAC_PCU_BUF[1351]", "DATA"                                 , 0x0002f51c, 31, 0 },
{"MAC_PCU_BUF[1352]", "DATA"                                 , 0x0002f520, 31, 0 },
{"MAC_PCU_BUF[1353]", "DATA"                                 , 0x0002f524, 31, 0 },
{"MAC_PCU_BUF[1354]", "DATA"                                 , 0x0002f528, 31, 0 },
{"MAC_PCU_BUF[1355]", "DATA"                                 , 0x0002f52c, 31, 0 },
{"MAC_PCU_BUF[1356]", "DATA"                                 , 0x0002f530, 31, 0 },
{"MAC_PCU_BUF[1357]", "DATA"                                 , 0x0002f534, 31, 0 },
{"MAC_PCU_BUF[1358]", "DATA"                                 , 0x0002f538, 31, 0 },
{"MAC_PCU_BUF[1359]", "DATA"                                 , 0x0002f53c, 31, 0 },
{"MAC_PCU_BUF[1360]", "DATA"                                 , 0x0002f540, 31, 0 },
{"MAC_PCU_BUF[1361]", "DATA"                                 , 0x0002f544, 31, 0 },
{"MAC_PCU_BUF[1362]", "DATA"                                 , 0x0002f548, 31, 0 },
{"MAC_PCU_BUF[1363]", "DATA"                                 , 0x0002f54c, 31, 0 },
{"MAC_PCU_BUF[1364]", "DATA"                                 , 0x0002f550, 31, 0 },
{"MAC_PCU_BUF[1365]", "DATA"                                 , 0x0002f554, 31, 0 },
{"MAC_PCU_BUF[1366]", "DATA"                                 , 0x0002f558, 31, 0 },
{"MAC_PCU_BUF[1367]", "DATA"                                 , 0x0002f55c, 31, 0 },
{"MAC_PCU_BUF[1368]", "DATA"                                 , 0x0002f560, 31, 0 },
{"MAC_PCU_BUF[1369]", "DATA"                                 , 0x0002f564, 31, 0 },
{"MAC_PCU_BUF[1370]", "DATA"                                 , 0x0002f568, 31, 0 },
{"MAC_PCU_BUF[1371]", "DATA"                                 , 0x0002f56c, 31, 0 },
{"MAC_PCU_BUF[1372]", "DATA"                                 , 0x0002f570, 31, 0 },
{"MAC_PCU_BUF[1373]", "DATA"                                 , 0x0002f574, 31, 0 },
{"MAC_PCU_BUF[1374]", "DATA"                                 , 0x0002f578, 31, 0 },
{"MAC_PCU_BUF[1375]", "DATA"                                 , 0x0002f57c, 31, 0 },
{"MAC_PCU_BUF[1376]", "DATA"                                 , 0x0002f580, 31, 0 },
{"MAC_PCU_BUF[1377]", "DATA"                                 , 0x0002f584, 31, 0 },
{"MAC_PCU_BUF[1378]", "DATA"                                 , 0x0002f588, 31, 0 },
{"MAC_PCU_BUF[1379]", "DATA"                                 , 0x0002f58c, 31, 0 },
{"MAC_PCU_BUF[1380]", "DATA"                                 , 0x0002f590, 31, 0 },
{"MAC_PCU_BUF[1381]", "DATA"                                 , 0x0002f594, 31, 0 },
{"MAC_PCU_BUF[1382]", "DATA"                                 , 0x0002f598, 31, 0 },
{"MAC_PCU_BUF[1383]", "DATA"                                 , 0x0002f59c, 31, 0 },
{"MAC_PCU_BUF[1384]", "DATA"                                 , 0x0002f5a0, 31, 0 },
{"MAC_PCU_BUF[1385]", "DATA"                                 , 0x0002f5a4, 31, 0 },
{"MAC_PCU_BUF[1386]", "DATA"                                 , 0x0002f5a8, 31, 0 },
{"MAC_PCU_BUF[1387]", "DATA"                                 , 0x0002f5ac, 31, 0 },
{"MAC_PCU_BUF[1388]", "DATA"                                 , 0x0002f5b0, 31, 0 },
{"MAC_PCU_BUF[1389]", "DATA"                                 , 0x0002f5b4, 31, 0 },
{"MAC_PCU_BUF[1390]", "DATA"                                 , 0x0002f5b8, 31, 0 },
{"MAC_PCU_BUF[1391]", "DATA"                                 , 0x0002f5bc, 31, 0 },
{"MAC_PCU_BUF[1392]", "DATA"                                 , 0x0002f5c0, 31, 0 },
{"MAC_PCU_BUF[1393]", "DATA"                                 , 0x0002f5c4, 31, 0 },
{"MAC_PCU_BUF[1394]", "DATA"                                 , 0x0002f5c8, 31, 0 },
{"MAC_PCU_BUF[1395]", "DATA"                                 , 0x0002f5cc, 31, 0 },
{"MAC_PCU_BUF[1396]", "DATA"                                 , 0x0002f5d0, 31, 0 },
{"MAC_PCU_BUF[1397]", "DATA"                                 , 0x0002f5d4, 31, 0 },
{"MAC_PCU_BUF[1398]", "DATA"                                 , 0x0002f5d8, 31, 0 },
{"MAC_PCU_BUF[1399]", "DATA"                                 , 0x0002f5dc, 31, 0 },
{"MAC_PCU_BUF[1400]", "DATA"                                 , 0x0002f5e0, 31, 0 },
{"MAC_PCU_BUF[1401]", "DATA"                                 , 0x0002f5e4, 31, 0 },
{"MAC_PCU_BUF[1402]", "DATA"                                 , 0x0002f5e8, 31, 0 },
{"MAC_PCU_BUF[1403]", "DATA"                                 , 0x0002f5ec, 31, 0 },
{"MAC_PCU_BUF[1404]", "DATA"                                 , 0x0002f5f0, 31, 0 },
{"MAC_PCU_BUF[1405]", "DATA"                                 , 0x0002f5f4, 31, 0 },
{"MAC_PCU_BUF[1406]", "DATA"                                 , 0x0002f5f8, 31, 0 },
{"MAC_PCU_BUF[1407]", "DATA"                                 , 0x0002f5fc, 31, 0 },
{"MAC_PCU_BUF[1408]", "DATA"                                 , 0x0002f600, 31, 0 },
{"MAC_PCU_BUF[1409]", "DATA"                                 , 0x0002f604, 31, 0 },
{"MAC_PCU_BUF[1410]", "DATA"                                 , 0x0002f608, 31, 0 },
{"MAC_PCU_BUF[1411]", "DATA"                                 , 0x0002f60c, 31, 0 },
{"MAC_PCU_BUF[1412]", "DATA"                                 , 0x0002f610, 31, 0 },
{"MAC_PCU_BUF[1413]", "DATA"                                 , 0x0002f614, 31, 0 },
{"MAC_PCU_BUF[1414]", "DATA"                                 , 0x0002f618, 31, 0 },
{"MAC_PCU_BUF[1415]", "DATA"                                 , 0x0002f61c, 31, 0 },
{"MAC_PCU_BUF[1416]", "DATA"                                 , 0x0002f620, 31, 0 },
{"MAC_PCU_BUF[1417]", "DATA"                                 , 0x0002f624, 31, 0 },
{"MAC_PCU_BUF[1418]", "DATA"                                 , 0x0002f628, 31, 0 },
{"MAC_PCU_BUF[1419]", "DATA"                                 , 0x0002f62c, 31, 0 },
{"MAC_PCU_BUF[1420]", "DATA"                                 , 0x0002f630, 31, 0 },
{"MAC_PCU_BUF[1421]", "DATA"                                 , 0x0002f634, 31, 0 },
{"MAC_PCU_BUF[1422]", "DATA"                                 , 0x0002f638, 31, 0 },
{"MAC_PCU_BUF[1423]", "DATA"                                 , 0x0002f63c, 31, 0 },
{"MAC_PCU_BUF[1424]", "DATA"                                 , 0x0002f640, 31, 0 },
{"MAC_PCU_BUF[1425]", "DATA"                                 , 0x0002f644, 31, 0 },
{"MAC_PCU_BUF[1426]", "DATA"                                 , 0x0002f648, 31, 0 },
{"MAC_PCU_BUF[1427]", "DATA"                                 , 0x0002f64c, 31, 0 },
{"MAC_PCU_BUF[1428]", "DATA"                                 , 0x0002f650, 31, 0 },
{"MAC_PCU_BUF[1429]", "DATA"                                 , 0x0002f654, 31, 0 },
{"MAC_PCU_BUF[1430]", "DATA"                                 , 0x0002f658, 31, 0 },
{"MAC_PCU_BUF[1431]", "DATA"                                 , 0x0002f65c, 31, 0 },
{"MAC_PCU_BUF[1432]", "DATA"                                 , 0x0002f660, 31, 0 },
{"MAC_PCU_BUF[1433]", "DATA"                                 , 0x0002f664, 31, 0 },
{"MAC_PCU_BUF[1434]", "DATA"                                 , 0x0002f668, 31, 0 },
{"MAC_PCU_BUF[1435]", "DATA"                                 , 0x0002f66c, 31, 0 },
{"MAC_PCU_BUF[1436]", "DATA"                                 , 0x0002f670, 31, 0 },
{"MAC_PCU_BUF[1437]", "DATA"                                 , 0x0002f674, 31, 0 },
{"MAC_PCU_BUF[1438]", "DATA"                                 , 0x0002f678, 31, 0 },
{"MAC_PCU_BUF[1439]", "DATA"                                 , 0x0002f67c, 31, 0 },
{"MAC_PCU_BUF[1440]", "DATA"                                 , 0x0002f680, 31, 0 },
{"MAC_PCU_BUF[1441]", "DATA"                                 , 0x0002f684, 31, 0 },
{"MAC_PCU_BUF[1442]", "DATA"                                 , 0x0002f688, 31, 0 },
{"MAC_PCU_BUF[1443]", "DATA"                                 , 0x0002f68c, 31, 0 },
{"MAC_PCU_BUF[1444]", "DATA"                                 , 0x0002f690, 31, 0 },
{"MAC_PCU_BUF[1445]", "DATA"                                 , 0x0002f694, 31, 0 },
{"MAC_PCU_BUF[1446]", "DATA"                                 , 0x0002f698, 31, 0 },
{"MAC_PCU_BUF[1447]", "DATA"                                 , 0x0002f69c, 31, 0 },
{"MAC_PCU_BUF[1448]", "DATA"                                 , 0x0002f6a0, 31, 0 },
{"MAC_PCU_BUF[1449]", "DATA"                                 , 0x0002f6a4, 31, 0 },
{"MAC_PCU_BUF[1450]", "DATA"                                 , 0x0002f6a8, 31, 0 },
{"MAC_PCU_BUF[1451]", "DATA"                                 , 0x0002f6ac, 31, 0 },
{"MAC_PCU_BUF[1452]", "DATA"                                 , 0x0002f6b0, 31, 0 },
{"MAC_PCU_BUF[1453]", "DATA"                                 , 0x0002f6b4, 31, 0 },
{"MAC_PCU_BUF[1454]", "DATA"                                 , 0x0002f6b8, 31, 0 },
{"MAC_PCU_BUF[1455]", "DATA"                                 , 0x0002f6bc, 31, 0 },
{"MAC_PCU_BUF[1456]", "DATA"                                 , 0x0002f6c0, 31, 0 },
{"MAC_PCU_BUF[1457]", "DATA"                                 , 0x0002f6c4, 31, 0 },
{"MAC_PCU_BUF[1458]", "DATA"                                 , 0x0002f6c8, 31, 0 },
{"MAC_PCU_BUF[1459]", "DATA"                                 , 0x0002f6cc, 31, 0 },
{"MAC_PCU_BUF[1460]", "DATA"                                 , 0x0002f6d0, 31, 0 },
{"MAC_PCU_BUF[1461]", "DATA"                                 , 0x0002f6d4, 31, 0 },
{"MAC_PCU_BUF[1462]", "DATA"                                 , 0x0002f6d8, 31, 0 },
{"MAC_PCU_BUF[1463]", "DATA"                                 , 0x0002f6dc, 31, 0 },
{"MAC_PCU_BUF[1464]", "DATA"                                 , 0x0002f6e0, 31, 0 },
{"MAC_PCU_BUF[1465]", "DATA"                                 , 0x0002f6e4, 31, 0 },
{"MAC_PCU_BUF[1466]", "DATA"                                 , 0x0002f6e8, 31, 0 },
{"MAC_PCU_BUF[1467]", "DATA"                                 , 0x0002f6ec, 31, 0 },
{"MAC_PCU_BUF[1468]", "DATA"                                 , 0x0002f6f0, 31, 0 },
{"MAC_PCU_BUF[1469]", "DATA"                                 , 0x0002f6f4, 31, 0 },
{"MAC_PCU_BUF[1470]", "DATA"                                 , 0x0002f6f8, 31, 0 },
{"MAC_PCU_BUF[1471]", "DATA"                                 , 0x0002f6fc, 31, 0 },
{"MAC_PCU_BUF[1472]", "DATA"                                 , 0x0002f700, 31, 0 },
{"MAC_PCU_BUF[1473]", "DATA"                                 , 0x0002f704, 31, 0 },
{"MAC_PCU_BUF[1474]", "DATA"                                 , 0x0002f708, 31, 0 },
{"MAC_PCU_BUF[1475]", "DATA"                                 , 0x0002f70c, 31, 0 },
{"MAC_PCU_BUF[1476]", "DATA"                                 , 0x0002f710, 31, 0 },
{"MAC_PCU_BUF[1477]", "DATA"                                 , 0x0002f714, 31, 0 },
{"MAC_PCU_BUF[1478]", "DATA"                                 , 0x0002f718, 31, 0 },
{"MAC_PCU_BUF[1479]", "DATA"                                 , 0x0002f71c, 31, 0 },
{"MAC_PCU_BUF[1480]", "DATA"                                 , 0x0002f720, 31, 0 },
{"MAC_PCU_BUF[1481]", "DATA"                                 , 0x0002f724, 31, 0 },
{"MAC_PCU_BUF[1482]", "DATA"                                 , 0x0002f728, 31, 0 },
{"MAC_PCU_BUF[1483]", "DATA"                                 , 0x0002f72c, 31, 0 },
{"MAC_PCU_BUF[1484]", "DATA"                                 , 0x0002f730, 31, 0 },
{"MAC_PCU_BUF[1485]", "DATA"                                 , 0x0002f734, 31, 0 },
{"MAC_PCU_BUF[1486]", "DATA"                                 , 0x0002f738, 31, 0 },
{"MAC_PCU_BUF[1487]", "DATA"                                 , 0x0002f73c, 31, 0 },
{"MAC_PCU_BUF[1488]", "DATA"                                 , 0x0002f740, 31, 0 },
{"MAC_PCU_BUF[1489]", "DATA"                                 , 0x0002f744, 31, 0 },
{"MAC_PCU_BUF[1490]", "DATA"                                 , 0x0002f748, 31, 0 },
{"MAC_PCU_BUF[1491]", "DATA"                                 , 0x0002f74c, 31, 0 },
{"MAC_PCU_BUF[1492]", "DATA"                                 , 0x0002f750, 31, 0 },
{"MAC_PCU_BUF[1493]", "DATA"                                 , 0x0002f754, 31, 0 },
{"MAC_PCU_BUF[1494]", "DATA"                                 , 0x0002f758, 31, 0 },
{"MAC_PCU_BUF[1495]", "DATA"                                 , 0x0002f75c, 31, 0 },
{"MAC_PCU_BUF[1496]", "DATA"                                 , 0x0002f760, 31, 0 },
{"MAC_PCU_BUF[1497]", "DATA"                                 , 0x0002f764, 31, 0 },
{"MAC_PCU_BUF[1498]", "DATA"                                 , 0x0002f768, 31, 0 },
{"MAC_PCU_BUF[1499]", "DATA"                                 , 0x0002f76c, 31, 0 },
{"MAC_PCU_BUF[1500]", "DATA"                                 , 0x0002f770, 31, 0 },
{"MAC_PCU_BUF[1501]", "DATA"                                 , 0x0002f774, 31, 0 },
{"MAC_PCU_BUF[1502]", "DATA"                                 , 0x0002f778, 31, 0 },
{"MAC_PCU_BUF[1503]", "DATA"                                 , 0x0002f77c, 31, 0 },
{"MAC_PCU_BUF[1504]", "DATA"                                 , 0x0002f780, 31, 0 },
{"MAC_PCU_BUF[1505]", "DATA"                                 , 0x0002f784, 31, 0 },
{"MAC_PCU_BUF[1506]", "DATA"                                 , 0x0002f788, 31, 0 },
{"MAC_PCU_BUF[1507]", "DATA"                                 , 0x0002f78c, 31, 0 },
{"MAC_PCU_BUF[1508]", "DATA"                                 , 0x0002f790, 31, 0 },
{"MAC_PCU_BUF[1509]", "DATA"                                 , 0x0002f794, 31, 0 },
{"MAC_PCU_BUF[1510]", "DATA"                                 , 0x0002f798, 31, 0 },
{"MAC_PCU_BUF[1511]", "DATA"                                 , 0x0002f79c, 31, 0 },
{"MAC_PCU_BUF[1512]", "DATA"                                 , 0x0002f7a0, 31, 0 },
{"MAC_PCU_BUF[1513]", "DATA"                                 , 0x0002f7a4, 31, 0 },
{"MAC_PCU_BUF[1514]", "DATA"                                 , 0x0002f7a8, 31, 0 },
{"MAC_PCU_BUF[1515]", "DATA"                                 , 0x0002f7ac, 31, 0 },
{"MAC_PCU_BUF[1516]", "DATA"                                 , 0x0002f7b0, 31, 0 },
{"MAC_PCU_BUF[1517]", "DATA"                                 , 0x0002f7b4, 31, 0 },
{"MAC_PCU_BUF[1518]", "DATA"                                 , 0x0002f7b8, 31, 0 },
{"MAC_PCU_BUF[1519]", "DATA"                                 , 0x0002f7bc, 31, 0 },
{"MAC_PCU_BUF[1520]", "DATA"                                 , 0x0002f7c0, 31, 0 },
{"MAC_PCU_BUF[1521]", "DATA"                                 , 0x0002f7c4, 31, 0 },
{"MAC_PCU_BUF[1522]", "DATA"                                 , 0x0002f7c8, 31, 0 },
{"MAC_PCU_BUF[1523]", "DATA"                                 , 0x0002f7cc, 31, 0 },
{"MAC_PCU_BUF[1524]", "DATA"                                 , 0x0002f7d0, 31, 0 },
{"MAC_PCU_BUF[1525]", "DATA"                                 , 0x0002f7d4, 31, 0 },
{"MAC_PCU_BUF[1526]", "DATA"                                 , 0x0002f7d8, 31, 0 },
{"MAC_PCU_BUF[1527]", "DATA"                                 , 0x0002f7dc, 31, 0 },
{"MAC_PCU_BUF[1528]", "DATA"                                 , 0x0002f7e0, 31, 0 },
{"MAC_PCU_BUF[1529]", "DATA"                                 , 0x0002f7e4, 31, 0 },
{"MAC_PCU_BUF[1530]", "DATA"                                 , 0x0002f7e8, 31, 0 },
{"MAC_PCU_BUF[1531]", "DATA"                                 , 0x0002f7ec, 31, 0 },
{"MAC_PCU_BUF[1532]", "DATA"                                 , 0x0002f7f0, 31, 0 },
{"MAC_PCU_BUF[1533]", "DATA"                                 , 0x0002f7f4, 31, 0 },
{"MAC_PCU_BUF[1534]", "DATA"                                 , 0x0002f7f8, 31, 0 },
{"MAC_PCU_BUF[1535]", "DATA"                                 , 0x0002f7fc, 31, 0 },
{"MAC_PCU_BUF[1536]", "DATA"                                 , 0x0002f800, 31, 0 },
{"MAC_PCU_BUF[1537]", "DATA"                                 , 0x0002f804, 31, 0 },
{"MAC_PCU_BUF[1538]", "DATA"                                 , 0x0002f808, 31, 0 },
{"MAC_PCU_BUF[1539]", "DATA"                                 , 0x0002f80c, 31, 0 },
{"MAC_PCU_BUF[1540]", "DATA"                                 , 0x0002f810, 31, 0 },
{"MAC_PCU_BUF[1541]", "DATA"                                 , 0x0002f814, 31, 0 },
{"MAC_PCU_BUF[1542]", "DATA"                                 , 0x0002f818, 31, 0 },
{"MAC_PCU_BUF[1543]", "DATA"                                 , 0x0002f81c, 31, 0 },
{"MAC_PCU_BUF[1544]", "DATA"                                 , 0x0002f820, 31, 0 },
{"MAC_PCU_BUF[1545]", "DATA"                                 , 0x0002f824, 31, 0 },
{"MAC_PCU_BUF[1546]", "DATA"                                 , 0x0002f828, 31, 0 },
{"MAC_PCU_BUF[1547]", "DATA"                                 , 0x0002f82c, 31, 0 },
{"MAC_PCU_BUF[1548]", "DATA"                                 , 0x0002f830, 31, 0 },
{"MAC_PCU_BUF[1549]", "DATA"                                 , 0x0002f834, 31, 0 },
{"MAC_PCU_BUF[1550]", "DATA"                                 , 0x0002f838, 31, 0 },
{"MAC_PCU_BUF[1551]", "DATA"                                 , 0x0002f83c, 31, 0 },
{"MAC_PCU_BUF[1552]", "DATA"                                 , 0x0002f840, 31, 0 },
{"MAC_PCU_BUF[1553]", "DATA"                                 , 0x0002f844, 31, 0 },
{"MAC_PCU_BUF[1554]", "DATA"                                 , 0x0002f848, 31, 0 },
{"MAC_PCU_BUF[1555]", "DATA"                                 , 0x0002f84c, 31, 0 },
{"MAC_PCU_BUF[1556]", "DATA"                                 , 0x0002f850, 31, 0 },
{"MAC_PCU_BUF[1557]", "DATA"                                 , 0x0002f854, 31, 0 },
{"MAC_PCU_BUF[1558]", "DATA"                                 , 0x0002f858, 31, 0 },
{"MAC_PCU_BUF[1559]", "DATA"                                 , 0x0002f85c, 31, 0 },
{"MAC_PCU_BUF[1560]", "DATA"                                 , 0x0002f860, 31, 0 },
{"MAC_PCU_BUF[1561]", "DATA"                                 , 0x0002f864, 31, 0 },
{"MAC_PCU_BUF[1562]", "DATA"                                 , 0x0002f868, 31, 0 },
{"MAC_PCU_BUF[1563]", "DATA"                                 , 0x0002f86c, 31, 0 },
{"MAC_PCU_BUF[1564]", "DATA"                                 , 0x0002f870, 31, 0 },
{"MAC_PCU_BUF[1565]", "DATA"                                 , 0x0002f874, 31, 0 },
{"MAC_PCU_BUF[1566]", "DATA"                                 , 0x0002f878, 31, 0 },
{"MAC_PCU_BUF[1567]", "DATA"                                 , 0x0002f87c, 31, 0 },
{"MAC_PCU_BUF[1568]", "DATA"                                 , 0x0002f880, 31, 0 },
{"MAC_PCU_BUF[1569]", "DATA"                                 , 0x0002f884, 31, 0 },
{"MAC_PCU_BUF[1570]", "DATA"                                 , 0x0002f888, 31, 0 },
{"MAC_PCU_BUF[1571]", "DATA"                                 , 0x0002f88c, 31, 0 },
{"MAC_PCU_BUF[1572]", "DATA"                                 , 0x0002f890, 31, 0 },
{"MAC_PCU_BUF[1573]", "DATA"                                 , 0x0002f894, 31, 0 },
{"MAC_PCU_BUF[1574]", "DATA"                                 , 0x0002f898, 31, 0 },
{"MAC_PCU_BUF[1575]", "DATA"                                 , 0x0002f89c, 31, 0 },
{"MAC_PCU_BUF[1576]", "DATA"                                 , 0x0002f8a0, 31, 0 },
{"MAC_PCU_BUF[1577]", "DATA"                                 , 0x0002f8a4, 31, 0 },
{"MAC_PCU_BUF[1578]", "DATA"                                 , 0x0002f8a8, 31, 0 },
{"MAC_PCU_BUF[1579]", "DATA"                                 , 0x0002f8ac, 31, 0 },
{"MAC_PCU_BUF[1580]", "DATA"                                 , 0x0002f8b0, 31, 0 },
{"MAC_PCU_BUF[1581]", "DATA"                                 , 0x0002f8b4, 31, 0 },
{"MAC_PCU_BUF[1582]", "DATA"                                 , 0x0002f8b8, 31, 0 },
{"MAC_PCU_BUF[1583]", "DATA"                                 , 0x0002f8bc, 31, 0 },
{"MAC_PCU_BUF[1584]", "DATA"                                 , 0x0002f8c0, 31, 0 },
{"MAC_PCU_BUF[1585]", "DATA"                                 , 0x0002f8c4, 31, 0 },
{"MAC_PCU_BUF[1586]", "DATA"                                 , 0x0002f8c8, 31, 0 },
{"MAC_PCU_BUF[1587]", "DATA"                                 , 0x0002f8cc, 31, 0 },
{"MAC_PCU_BUF[1588]", "DATA"                                 , 0x0002f8d0, 31, 0 },
{"MAC_PCU_BUF[1589]", "DATA"                                 , 0x0002f8d4, 31, 0 },
{"MAC_PCU_BUF[1590]", "DATA"                                 , 0x0002f8d8, 31, 0 },
{"MAC_PCU_BUF[1591]", "DATA"                                 , 0x0002f8dc, 31, 0 },
{"MAC_PCU_BUF[1592]", "DATA"                                 , 0x0002f8e0, 31, 0 },
{"MAC_PCU_BUF[1593]", "DATA"                                 , 0x0002f8e4, 31, 0 },
{"MAC_PCU_BUF[1594]", "DATA"                                 , 0x0002f8e8, 31, 0 },
{"MAC_PCU_BUF[1595]", "DATA"                                 , 0x0002f8ec, 31, 0 },
{"MAC_PCU_BUF[1596]", "DATA"                                 , 0x0002f8f0, 31, 0 },
{"MAC_PCU_BUF[1597]", "DATA"                                 , 0x0002f8f4, 31, 0 },
{"MAC_PCU_BUF[1598]", "DATA"                                 , 0x0002f8f8, 31, 0 },
{"MAC_PCU_BUF[1599]", "DATA"                                 , 0x0002f8fc, 31, 0 },
{"MAC_PCU_BUF[1600]", "DATA"                                 , 0x0002f900, 31, 0 },
{"MAC_PCU_BUF[1601]", "DATA"                                 , 0x0002f904, 31, 0 },
{"MAC_PCU_BUF[1602]", "DATA"                                 , 0x0002f908, 31, 0 },
{"MAC_PCU_BUF[1603]", "DATA"                                 , 0x0002f90c, 31, 0 },
{"MAC_PCU_BUF[1604]", "DATA"                                 , 0x0002f910, 31, 0 },
{"MAC_PCU_BUF[1605]", "DATA"                                 , 0x0002f914, 31, 0 },
{"MAC_PCU_BUF[1606]", "DATA"                                 , 0x0002f918, 31, 0 },
{"MAC_PCU_BUF[1607]", "DATA"                                 , 0x0002f91c, 31, 0 },
{"MAC_PCU_BUF[1608]", "DATA"                                 , 0x0002f920, 31, 0 },
{"MAC_PCU_BUF[1609]", "DATA"                                 , 0x0002f924, 31, 0 },
{"MAC_PCU_BUF[1610]", "DATA"                                 , 0x0002f928, 31, 0 },
{"MAC_PCU_BUF[1611]", "DATA"                                 , 0x0002f92c, 31, 0 },
{"MAC_PCU_BUF[1612]", "DATA"                                 , 0x0002f930, 31, 0 },
{"MAC_PCU_BUF[1613]", "DATA"                                 , 0x0002f934, 31, 0 },
{"MAC_PCU_BUF[1614]", "DATA"                                 , 0x0002f938, 31, 0 },
{"MAC_PCU_BUF[1615]", "DATA"                                 , 0x0002f93c, 31, 0 },
{"MAC_PCU_BUF[1616]", "DATA"                                 , 0x0002f940, 31, 0 },
{"MAC_PCU_BUF[1617]", "DATA"                                 , 0x0002f944, 31, 0 },
{"MAC_PCU_BUF[1618]", "DATA"                                 , 0x0002f948, 31, 0 },
{"MAC_PCU_BUF[1619]", "DATA"                                 , 0x0002f94c, 31, 0 },
{"MAC_PCU_BUF[1620]", "DATA"                                 , 0x0002f950, 31, 0 },
{"MAC_PCU_BUF[1621]", "DATA"                                 , 0x0002f954, 31, 0 },
{"MAC_PCU_BUF[1622]", "DATA"                                 , 0x0002f958, 31, 0 },
{"MAC_PCU_BUF[1623]", "DATA"                                 , 0x0002f95c, 31, 0 },
{"MAC_PCU_BUF[1624]", "DATA"                                 , 0x0002f960, 31, 0 },
{"MAC_PCU_BUF[1625]", "DATA"                                 , 0x0002f964, 31, 0 },
{"MAC_PCU_BUF[1626]", "DATA"                                 , 0x0002f968, 31, 0 },
{"MAC_PCU_BUF[1627]", "DATA"                                 , 0x0002f96c, 31, 0 },
{"MAC_PCU_BUF[1628]", "DATA"                                 , 0x0002f970, 31, 0 },
{"MAC_PCU_BUF[1629]", "DATA"                                 , 0x0002f974, 31, 0 },
{"MAC_PCU_BUF[1630]", "DATA"                                 , 0x0002f978, 31, 0 },
{"MAC_PCU_BUF[1631]", "DATA"                                 , 0x0002f97c, 31, 0 },
{"MAC_PCU_BUF[1632]", "DATA"                                 , 0x0002f980, 31, 0 },
{"MAC_PCU_BUF[1633]", "DATA"                                 , 0x0002f984, 31, 0 },
{"MAC_PCU_BUF[1634]", "DATA"                                 , 0x0002f988, 31, 0 },
{"MAC_PCU_BUF[1635]", "DATA"                                 , 0x0002f98c, 31, 0 },
{"MAC_PCU_BUF[1636]", "DATA"                                 , 0x0002f990, 31, 0 },
{"MAC_PCU_BUF[1637]", "DATA"                                 , 0x0002f994, 31, 0 },
{"MAC_PCU_BUF[1638]", "DATA"                                 , 0x0002f998, 31, 0 },
{"MAC_PCU_BUF[1639]", "DATA"                                 , 0x0002f99c, 31, 0 },
{"MAC_PCU_BUF[1640]", "DATA"                                 , 0x0002f9a0, 31, 0 },
{"MAC_PCU_BUF[1641]", "DATA"                                 , 0x0002f9a4, 31, 0 },
{"MAC_PCU_BUF[1642]", "DATA"                                 , 0x0002f9a8, 31, 0 },
{"MAC_PCU_BUF[1643]", "DATA"                                 , 0x0002f9ac, 31, 0 },
{"MAC_PCU_BUF[1644]", "DATA"                                 , 0x0002f9b0, 31, 0 },
{"MAC_PCU_BUF[1645]", "DATA"                                 , 0x0002f9b4, 31, 0 },
{"MAC_PCU_BUF[1646]", "DATA"                                 , 0x0002f9b8, 31, 0 },
{"MAC_PCU_BUF[1647]", "DATA"                                 , 0x0002f9bc, 31, 0 },
{"MAC_PCU_BUF[1648]", "DATA"                                 , 0x0002f9c0, 31, 0 },
{"MAC_PCU_BUF[1649]", "DATA"                                 , 0x0002f9c4, 31, 0 },
{"MAC_PCU_BUF[1650]", "DATA"                                 , 0x0002f9c8, 31, 0 },
{"MAC_PCU_BUF[1651]", "DATA"                                 , 0x0002f9cc, 31, 0 },
{"MAC_PCU_BUF[1652]", "DATA"                                 , 0x0002f9d0, 31, 0 },
{"MAC_PCU_BUF[1653]", "DATA"                                 , 0x0002f9d4, 31, 0 },
{"MAC_PCU_BUF[1654]", "DATA"                                 , 0x0002f9d8, 31, 0 },
{"MAC_PCU_BUF[1655]", "DATA"                                 , 0x0002f9dc, 31, 0 },
{"MAC_PCU_BUF[1656]", "DATA"                                 , 0x0002f9e0, 31, 0 },
{"MAC_PCU_BUF[1657]", "DATA"                                 , 0x0002f9e4, 31, 0 },
{"MAC_PCU_BUF[1658]", "DATA"                                 , 0x0002f9e8, 31, 0 },
{"MAC_PCU_BUF[1659]", "DATA"                                 , 0x0002f9ec, 31, 0 },
{"MAC_PCU_BUF[1660]", "DATA"                                 , 0x0002f9f0, 31, 0 },
{"MAC_PCU_BUF[1661]", "DATA"                                 , 0x0002f9f4, 31, 0 },
{"MAC_PCU_BUF[1662]", "DATA"                                 , 0x0002f9f8, 31, 0 },
{"MAC_PCU_BUF[1663]", "DATA"                                 , 0x0002f9fc, 31, 0 },
{"MAC_PCU_BUF[1664]", "DATA"                                 , 0x0002fa00, 31, 0 },
{"MAC_PCU_BUF[1665]", "DATA"                                 , 0x0002fa04, 31, 0 },
{"MAC_PCU_BUF[1666]", "DATA"                                 , 0x0002fa08, 31, 0 },
{"MAC_PCU_BUF[1667]", "DATA"                                 , 0x0002fa0c, 31, 0 },
{"MAC_PCU_BUF[1668]", "DATA"                                 , 0x0002fa10, 31, 0 },
{"MAC_PCU_BUF[1669]", "DATA"                                 , 0x0002fa14, 31, 0 },
{"MAC_PCU_BUF[1670]", "DATA"                                 , 0x0002fa18, 31, 0 },
{"MAC_PCU_BUF[1671]", "DATA"                                 , 0x0002fa1c, 31, 0 },
{"MAC_PCU_BUF[1672]", "DATA"                                 , 0x0002fa20, 31, 0 },
{"MAC_PCU_BUF[1673]", "DATA"                                 , 0x0002fa24, 31, 0 },
{"MAC_PCU_BUF[1674]", "DATA"                                 , 0x0002fa28, 31, 0 },
{"MAC_PCU_BUF[1675]", "DATA"                                 , 0x0002fa2c, 31, 0 },
{"MAC_PCU_BUF[1676]", "DATA"                                 , 0x0002fa30, 31, 0 },
{"MAC_PCU_BUF[1677]", "DATA"                                 , 0x0002fa34, 31, 0 },
{"MAC_PCU_BUF[1678]", "DATA"                                 , 0x0002fa38, 31, 0 },
{"MAC_PCU_BUF[1679]", "DATA"                                 , 0x0002fa3c, 31, 0 },
{"MAC_PCU_BUF[1680]", "DATA"                                 , 0x0002fa40, 31, 0 },
{"MAC_PCU_BUF[1681]", "DATA"                                 , 0x0002fa44, 31, 0 },
{"MAC_PCU_BUF[1682]", "DATA"                                 , 0x0002fa48, 31, 0 },
{"MAC_PCU_BUF[1683]", "DATA"                                 , 0x0002fa4c, 31, 0 },
{"MAC_PCU_BUF[1684]", "DATA"                                 , 0x0002fa50, 31, 0 },
{"MAC_PCU_BUF[1685]", "DATA"                                 , 0x0002fa54, 31, 0 },
{"MAC_PCU_BUF[1686]", "DATA"                                 , 0x0002fa58, 31, 0 },
{"MAC_PCU_BUF[1687]", "DATA"                                 , 0x0002fa5c, 31, 0 },
{"MAC_PCU_BUF[1688]", "DATA"                                 , 0x0002fa60, 31, 0 },
{"MAC_PCU_BUF[1689]", "DATA"                                 , 0x0002fa64, 31, 0 },
{"MAC_PCU_BUF[1690]", "DATA"                                 , 0x0002fa68, 31, 0 },
{"MAC_PCU_BUF[1691]", "DATA"                                 , 0x0002fa6c, 31, 0 },
{"MAC_PCU_BUF[1692]", "DATA"                                 , 0x0002fa70, 31, 0 },
{"MAC_PCU_BUF[1693]", "DATA"                                 , 0x0002fa74, 31, 0 },
{"MAC_PCU_BUF[1694]", "DATA"                                 , 0x0002fa78, 31, 0 },
{"MAC_PCU_BUF[1695]", "DATA"                                 , 0x0002fa7c, 31, 0 },
{"MAC_PCU_BUF[1696]", "DATA"                                 , 0x0002fa80, 31, 0 },
{"MAC_PCU_BUF[1697]", "DATA"                                 , 0x0002fa84, 31, 0 },
{"MAC_PCU_BUF[1698]", "DATA"                                 , 0x0002fa88, 31, 0 },
{"MAC_PCU_BUF[1699]", "DATA"                                 , 0x0002fa8c, 31, 0 },
{"MAC_PCU_BUF[1700]", "DATA"                                 , 0x0002fa90, 31, 0 },
{"MAC_PCU_BUF[1701]", "DATA"                                 , 0x0002fa94, 31, 0 },
{"MAC_PCU_BUF[1702]", "DATA"                                 , 0x0002fa98, 31, 0 },
{"MAC_PCU_BUF[1703]", "DATA"                                 , 0x0002fa9c, 31, 0 },
{"MAC_PCU_BUF[1704]", "DATA"                                 , 0x0002faa0, 31, 0 },
{"MAC_PCU_BUF[1705]", "DATA"                                 , 0x0002faa4, 31, 0 },
{"MAC_PCU_BUF[1706]", "DATA"                                 , 0x0002faa8, 31, 0 },
{"MAC_PCU_BUF[1707]", "DATA"                                 , 0x0002faac, 31, 0 },
{"MAC_PCU_BUF[1708]", "DATA"                                 , 0x0002fab0, 31, 0 },
{"MAC_PCU_BUF[1709]", "DATA"                                 , 0x0002fab4, 31, 0 },
{"MAC_PCU_BUF[1710]", "DATA"                                 , 0x0002fab8, 31, 0 },
{"MAC_PCU_BUF[1711]", "DATA"                                 , 0x0002fabc, 31, 0 },
{"MAC_PCU_BUF[1712]", "DATA"                                 , 0x0002fac0, 31, 0 },
{"MAC_PCU_BUF[1713]", "DATA"                                 , 0x0002fac4, 31, 0 },
{"MAC_PCU_BUF[1714]", "DATA"                                 , 0x0002fac8, 31, 0 },
{"MAC_PCU_BUF[1715]", "DATA"                                 , 0x0002facc, 31, 0 },
{"MAC_PCU_BUF[1716]", "DATA"                                 , 0x0002fad0, 31, 0 },
{"MAC_PCU_BUF[1717]", "DATA"                                 , 0x0002fad4, 31, 0 },
{"MAC_PCU_BUF[1718]", "DATA"                                 , 0x0002fad8, 31, 0 },
{"MAC_PCU_BUF[1719]", "DATA"                                 , 0x0002fadc, 31, 0 },
{"MAC_PCU_BUF[1720]", "DATA"                                 , 0x0002fae0, 31, 0 },
{"MAC_PCU_BUF[1721]", "DATA"                                 , 0x0002fae4, 31, 0 },
{"MAC_PCU_BUF[1722]", "DATA"                                 , 0x0002fae8, 31, 0 },
{"MAC_PCU_BUF[1723]", "DATA"                                 , 0x0002faec, 31, 0 },
{"MAC_PCU_BUF[1724]", "DATA"                                 , 0x0002faf0, 31, 0 },
{"MAC_PCU_BUF[1725]", "DATA"                                 , 0x0002faf4, 31, 0 },
{"MAC_PCU_BUF[1726]", "DATA"                                 , 0x0002faf8, 31, 0 },
{"MAC_PCU_BUF[1727]", "DATA"                                 , 0x0002fafc, 31, 0 },
{"MAC_PCU_BUF[1728]", "DATA"                                 , 0x0002fb00, 31, 0 },
{"MAC_PCU_BUF[1729]", "DATA"                                 , 0x0002fb04, 31, 0 },
{"MAC_PCU_BUF[1730]", "DATA"                                 , 0x0002fb08, 31, 0 },
{"MAC_PCU_BUF[1731]", "DATA"                                 , 0x0002fb0c, 31, 0 },
{"MAC_PCU_BUF[1732]", "DATA"                                 , 0x0002fb10, 31, 0 },
{"MAC_PCU_BUF[1733]", "DATA"                                 , 0x0002fb14, 31, 0 },
{"MAC_PCU_BUF[1734]", "DATA"                                 , 0x0002fb18, 31, 0 },
{"MAC_PCU_BUF[1735]", "DATA"                                 , 0x0002fb1c, 31, 0 },
{"MAC_PCU_BUF[1736]", "DATA"                                 , 0x0002fb20, 31, 0 },
{"MAC_PCU_BUF[1737]", "DATA"                                 , 0x0002fb24, 31, 0 },
{"MAC_PCU_BUF[1738]", "DATA"                                 , 0x0002fb28, 31, 0 },
{"MAC_PCU_BUF[1739]", "DATA"                                 , 0x0002fb2c, 31, 0 },
{"MAC_PCU_BUF[1740]", "DATA"                                 , 0x0002fb30, 31, 0 },
{"MAC_PCU_BUF[1741]", "DATA"                                 , 0x0002fb34, 31, 0 },
{"MAC_PCU_BUF[1742]", "DATA"                                 , 0x0002fb38, 31, 0 },
{"MAC_PCU_BUF[1743]", "DATA"                                 , 0x0002fb3c, 31, 0 },
{"MAC_PCU_BUF[1744]", "DATA"                                 , 0x0002fb40, 31, 0 },
{"MAC_PCU_BUF[1745]", "DATA"                                 , 0x0002fb44, 31, 0 },
{"MAC_PCU_BUF[1746]", "DATA"                                 , 0x0002fb48, 31, 0 },
{"MAC_PCU_BUF[1747]", "DATA"                                 , 0x0002fb4c, 31, 0 },
{"MAC_PCU_BUF[1748]", "DATA"                                 , 0x0002fb50, 31, 0 },
{"MAC_PCU_BUF[1749]", "DATA"                                 , 0x0002fb54, 31, 0 },
{"MAC_PCU_BUF[1750]", "DATA"                                 , 0x0002fb58, 31, 0 },
{"MAC_PCU_BUF[1751]", "DATA"                                 , 0x0002fb5c, 31, 0 },
{"MAC_PCU_BUF[1752]", "DATA"                                 , 0x0002fb60, 31, 0 },
{"MAC_PCU_BUF[1753]", "DATA"                                 , 0x0002fb64, 31, 0 },
{"MAC_PCU_BUF[1754]", "DATA"                                 , 0x0002fb68, 31, 0 },
{"MAC_PCU_BUF[1755]", "DATA"                                 , 0x0002fb6c, 31, 0 },
{"MAC_PCU_BUF[1756]", "DATA"                                 , 0x0002fb70, 31, 0 },
{"MAC_PCU_BUF[1757]", "DATA"                                 , 0x0002fb74, 31, 0 },
{"MAC_PCU_BUF[1758]", "DATA"                                 , 0x0002fb78, 31, 0 },
{"MAC_PCU_BUF[1759]", "DATA"                                 , 0x0002fb7c, 31, 0 },
{"MAC_PCU_BUF[1760]", "DATA"                                 , 0x0002fb80, 31, 0 },
{"MAC_PCU_BUF[1761]", "DATA"                                 , 0x0002fb84, 31, 0 },
{"MAC_PCU_BUF[1762]", "DATA"                                 , 0x0002fb88, 31, 0 },
{"MAC_PCU_BUF[1763]", "DATA"                                 , 0x0002fb8c, 31, 0 },
{"MAC_PCU_BUF[1764]", "DATA"                                 , 0x0002fb90, 31, 0 },
{"MAC_PCU_BUF[1765]", "DATA"                                 , 0x0002fb94, 31, 0 },
{"MAC_PCU_BUF[1766]", "DATA"                                 , 0x0002fb98, 31, 0 },
{"MAC_PCU_BUF[1767]", "DATA"                                 , 0x0002fb9c, 31, 0 },
{"MAC_PCU_BUF[1768]", "DATA"                                 , 0x0002fba0, 31, 0 },
{"MAC_PCU_BUF[1769]", "DATA"                                 , 0x0002fba4, 31, 0 },
{"MAC_PCU_BUF[1770]", "DATA"                                 , 0x0002fba8, 31, 0 },
{"MAC_PCU_BUF[1771]", "DATA"                                 , 0x0002fbac, 31, 0 },
{"MAC_PCU_BUF[1772]", "DATA"                                 , 0x0002fbb0, 31, 0 },
{"MAC_PCU_BUF[1773]", "DATA"                                 , 0x0002fbb4, 31, 0 },
{"MAC_PCU_BUF[1774]", "DATA"                                 , 0x0002fbb8, 31, 0 },
{"MAC_PCU_BUF[1775]", "DATA"                                 , 0x0002fbbc, 31, 0 },
{"MAC_PCU_BUF[1776]", "DATA"                                 , 0x0002fbc0, 31, 0 },
{"MAC_PCU_BUF[1777]", "DATA"                                 , 0x0002fbc4, 31, 0 },
{"MAC_PCU_BUF[1778]", "DATA"                                 , 0x0002fbc8, 31, 0 },
{"MAC_PCU_BUF[1779]", "DATA"                                 , 0x0002fbcc, 31, 0 },
{"MAC_PCU_BUF[1780]", "DATA"                                 , 0x0002fbd0, 31, 0 },
{"MAC_PCU_BUF[1781]", "DATA"                                 , 0x0002fbd4, 31, 0 },
{"MAC_PCU_BUF[1782]", "DATA"                                 , 0x0002fbd8, 31, 0 },
{"MAC_PCU_BUF[1783]", "DATA"                                 , 0x0002fbdc, 31, 0 },
{"MAC_PCU_BUF[1784]", "DATA"                                 , 0x0002fbe0, 31, 0 },
{"MAC_PCU_BUF[1785]", "DATA"                                 , 0x0002fbe4, 31, 0 },
{"MAC_PCU_BUF[1786]", "DATA"                                 , 0x0002fbe8, 31, 0 },
{"MAC_PCU_BUF[1787]", "DATA"                                 , 0x0002fbec, 31, 0 },
{"MAC_PCU_BUF[1788]", "DATA"                                 , 0x0002fbf0, 31, 0 },
{"MAC_PCU_BUF[1789]", "DATA"                                 , 0x0002fbf4, 31, 0 },
{"MAC_PCU_BUF[1790]", "DATA"                                 , 0x0002fbf8, 31, 0 },
{"MAC_PCU_BUF[1791]", "DATA"                                 , 0x0002fbfc, 31, 0 },
{"MAC_PCU_BUF[1792]", "DATA"                                 , 0x0002fc00, 31, 0 },
{"MAC_PCU_BUF[1793]", "DATA"                                 , 0x0002fc04, 31, 0 },
{"MAC_PCU_BUF[1794]", "DATA"                                 , 0x0002fc08, 31, 0 },
{"MAC_PCU_BUF[1795]", "DATA"                                 , 0x0002fc0c, 31, 0 },
{"MAC_PCU_BUF[1796]", "DATA"                                 , 0x0002fc10, 31, 0 },
{"MAC_PCU_BUF[1797]", "DATA"                                 , 0x0002fc14, 31, 0 },
{"MAC_PCU_BUF[1798]", "DATA"                                 , 0x0002fc18, 31, 0 },
{"MAC_PCU_BUF[1799]", "DATA"                                 , 0x0002fc1c, 31, 0 },
{"MAC_PCU_BUF[1800]", "DATA"                                 , 0x0002fc20, 31, 0 },
{"MAC_PCU_BUF[1801]", "DATA"                                 , 0x0002fc24, 31, 0 },
{"MAC_PCU_BUF[1802]", "DATA"                                 , 0x0002fc28, 31, 0 },
{"MAC_PCU_BUF[1803]", "DATA"                                 , 0x0002fc2c, 31, 0 },
{"MAC_PCU_BUF[1804]", "DATA"                                 , 0x0002fc30, 31, 0 },
{"MAC_PCU_BUF[1805]", "DATA"                                 , 0x0002fc34, 31, 0 },
{"MAC_PCU_BUF[1806]", "DATA"                                 , 0x0002fc38, 31, 0 },
{"MAC_PCU_BUF[1807]", "DATA"                                 , 0x0002fc3c, 31, 0 },
{"MAC_PCU_BUF[1808]", "DATA"                                 , 0x0002fc40, 31, 0 },
{"MAC_PCU_BUF[1809]", "DATA"                                 , 0x0002fc44, 31, 0 },
{"MAC_PCU_BUF[1810]", "DATA"                                 , 0x0002fc48, 31, 0 },
{"MAC_PCU_BUF[1811]", "DATA"                                 , 0x0002fc4c, 31, 0 },
{"MAC_PCU_BUF[1812]", "DATA"                                 , 0x0002fc50, 31, 0 },
{"MAC_PCU_BUF[1813]", "DATA"                                 , 0x0002fc54, 31, 0 },
{"MAC_PCU_BUF[1814]", "DATA"                                 , 0x0002fc58, 31, 0 },
{"MAC_PCU_BUF[1815]", "DATA"                                 , 0x0002fc5c, 31, 0 },
{"MAC_PCU_BUF[1816]", "DATA"                                 , 0x0002fc60, 31, 0 },
{"MAC_PCU_BUF[1817]", "DATA"                                 , 0x0002fc64, 31, 0 },
{"MAC_PCU_BUF[1818]", "DATA"                                 , 0x0002fc68, 31, 0 },
{"MAC_PCU_BUF[1819]", "DATA"                                 , 0x0002fc6c, 31, 0 },
{"MAC_PCU_BUF[1820]", "DATA"                                 , 0x0002fc70, 31, 0 },
{"MAC_PCU_BUF[1821]", "DATA"                                 , 0x0002fc74, 31, 0 },
{"MAC_PCU_BUF[1822]", "DATA"                                 , 0x0002fc78, 31, 0 },
{"MAC_PCU_BUF[1823]", "DATA"                                 , 0x0002fc7c, 31, 0 },
{"MAC_PCU_BUF[1824]", "DATA"                                 , 0x0002fc80, 31, 0 },
{"MAC_PCU_BUF[1825]", "DATA"                                 , 0x0002fc84, 31, 0 },
{"MAC_PCU_BUF[1826]", "DATA"                                 , 0x0002fc88, 31, 0 },
{"MAC_PCU_BUF[1827]", "DATA"                                 , 0x0002fc8c, 31, 0 },
{"MAC_PCU_BUF[1828]", "DATA"                                 , 0x0002fc90, 31, 0 },
{"MAC_PCU_BUF[1829]", "DATA"                                 , 0x0002fc94, 31, 0 },
{"MAC_PCU_BUF[1830]", "DATA"                                 , 0x0002fc98, 31, 0 },
{"MAC_PCU_BUF[1831]", "DATA"                                 , 0x0002fc9c, 31, 0 },
{"MAC_PCU_BUF[1832]", "DATA"                                 , 0x0002fca0, 31, 0 },
{"MAC_PCU_BUF[1833]", "DATA"                                 , 0x0002fca4, 31, 0 },
{"MAC_PCU_BUF[1834]", "DATA"                                 , 0x0002fca8, 31, 0 },
{"MAC_PCU_BUF[1835]", "DATA"                                 , 0x0002fcac, 31, 0 },
{"MAC_PCU_BUF[1836]", "DATA"                                 , 0x0002fcb0, 31, 0 },
{"MAC_PCU_BUF[1837]", "DATA"                                 , 0x0002fcb4, 31, 0 },
{"MAC_PCU_BUF[1838]", "DATA"                                 , 0x0002fcb8, 31, 0 },
{"MAC_PCU_BUF[1839]", "DATA"                                 , 0x0002fcbc, 31, 0 },
{"MAC_PCU_BUF[1840]", "DATA"                                 , 0x0002fcc0, 31, 0 },
{"MAC_PCU_BUF[1841]", "DATA"                                 , 0x0002fcc4, 31, 0 },
{"MAC_PCU_BUF[1842]", "DATA"                                 , 0x0002fcc8, 31, 0 },
{"MAC_PCU_BUF[1843]", "DATA"                                 , 0x0002fccc, 31, 0 },
{"MAC_PCU_BUF[1844]", "DATA"                                 , 0x0002fcd0, 31, 0 },
{"MAC_PCU_BUF[1845]", "DATA"                                 , 0x0002fcd4, 31, 0 },
{"MAC_PCU_BUF[1846]", "DATA"                                 , 0x0002fcd8, 31, 0 },
{"MAC_PCU_BUF[1847]", "DATA"                                 , 0x0002fcdc, 31, 0 },
{"MAC_PCU_BUF[1848]", "DATA"                                 , 0x0002fce0, 31, 0 },
{"MAC_PCU_BUF[1849]", "DATA"                                 , 0x0002fce4, 31, 0 },
{"MAC_PCU_BUF[1850]", "DATA"                                 , 0x0002fce8, 31, 0 },
{"MAC_PCU_BUF[1851]", "DATA"                                 , 0x0002fcec, 31, 0 },
{"MAC_PCU_BUF[1852]", "DATA"                                 , 0x0002fcf0, 31, 0 },
{"MAC_PCU_BUF[1853]", "DATA"                                 , 0x0002fcf4, 31, 0 },
{"MAC_PCU_BUF[1854]", "DATA"                                 , 0x0002fcf8, 31, 0 },
{"MAC_PCU_BUF[1855]", "DATA"                                 , 0x0002fcfc, 31, 0 },
{"MAC_PCU_BUF[1856]", "DATA"                                 , 0x0002fd00, 31, 0 },
{"MAC_PCU_BUF[1857]", "DATA"                                 , 0x0002fd04, 31, 0 },
{"MAC_PCU_BUF[1858]", "DATA"                                 , 0x0002fd08, 31, 0 },
{"MAC_PCU_BUF[1859]", "DATA"                                 , 0x0002fd0c, 31, 0 },
{"MAC_PCU_BUF[1860]", "DATA"                                 , 0x0002fd10, 31, 0 },
{"MAC_PCU_BUF[1861]", "DATA"                                 , 0x0002fd14, 31, 0 },
{"MAC_PCU_BUF[1862]", "DATA"                                 , 0x0002fd18, 31, 0 },
{"MAC_PCU_BUF[1863]", "DATA"                                 , 0x0002fd1c, 31, 0 },
{"MAC_PCU_BUF[1864]", "DATA"                                 , 0x0002fd20, 31, 0 },
{"MAC_PCU_BUF[1865]", "DATA"                                 , 0x0002fd24, 31, 0 },
{"MAC_PCU_BUF[1866]", "DATA"                                 , 0x0002fd28, 31, 0 },
{"MAC_PCU_BUF[1867]", "DATA"                                 , 0x0002fd2c, 31, 0 },
{"MAC_PCU_BUF[1868]", "DATA"                                 , 0x0002fd30, 31, 0 },
{"MAC_PCU_BUF[1869]", "DATA"                                 , 0x0002fd34, 31, 0 },
{"MAC_PCU_BUF[1870]", "DATA"                                 , 0x0002fd38, 31, 0 },
{"MAC_PCU_BUF[1871]", "DATA"                                 , 0x0002fd3c, 31, 0 },
{"MAC_PCU_BUF[1872]", "DATA"                                 , 0x0002fd40, 31, 0 },
{"MAC_PCU_BUF[1873]", "DATA"                                 , 0x0002fd44, 31, 0 },
{"MAC_PCU_BUF[1874]", "DATA"                                 , 0x0002fd48, 31, 0 },
{"MAC_PCU_BUF[1875]", "DATA"                                 , 0x0002fd4c, 31, 0 },
{"MAC_PCU_BUF[1876]", "DATA"                                 , 0x0002fd50, 31, 0 },
{"MAC_PCU_BUF[1877]", "DATA"                                 , 0x0002fd54, 31, 0 },
{"MAC_PCU_BUF[1878]", "DATA"                                 , 0x0002fd58, 31, 0 },
{"MAC_PCU_BUF[1879]", "DATA"                                 , 0x0002fd5c, 31, 0 },
{"MAC_PCU_BUF[1880]", "DATA"                                 , 0x0002fd60, 31, 0 },
{"MAC_PCU_BUF[1881]", "DATA"                                 , 0x0002fd64, 31, 0 },
{"MAC_PCU_BUF[1882]", "DATA"                                 , 0x0002fd68, 31, 0 },
{"MAC_PCU_BUF[1883]", "DATA"                                 , 0x0002fd6c, 31, 0 },
{"MAC_PCU_BUF[1884]", "DATA"                                 , 0x0002fd70, 31, 0 },
{"MAC_PCU_BUF[1885]", "DATA"                                 , 0x0002fd74, 31, 0 },
{"MAC_PCU_BUF[1886]", "DATA"                                 , 0x0002fd78, 31, 0 },
{"MAC_PCU_BUF[1887]", "DATA"                                 , 0x0002fd7c, 31, 0 },
{"MAC_PCU_BUF[1888]", "DATA"                                 , 0x0002fd80, 31, 0 },
{"MAC_PCU_BUF[1889]", "DATA"                                 , 0x0002fd84, 31, 0 },
{"MAC_PCU_BUF[1890]", "DATA"                                 , 0x0002fd88, 31, 0 },
{"MAC_PCU_BUF[1891]", "DATA"                                 , 0x0002fd8c, 31, 0 },
{"MAC_PCU_BUF[1892]", "DATA"                                 , 0x0002fd90, 31, 0 },
{"MAC_PCU_BUF[1893]", "DATA"                                 , 0x0002fd94, 31, 0 },
{"MAC_PCU_BUF[1894]", "DATA"                                 , 0x0002fd98, 31, 0 },
{"MAC_PCU_BUF[1895]", "DATA"                                 , 0x0002fd9c, 31, 0 },
{"MAC_PCU_BUF[1896]", "DATA"                                 , 0x0002fda0, 31, 0 },
{"MAC_PCU_BUF[1897]", "DATA"                                 , 0x0002fda4, 31, 0 },
{"MAC_PCU_BUF[1898]", "DATA"                                 , 0x0002fda8, 31, 0 },
{"MAC_PCU_BUF[1899]", "DATA"                                 , 0x0002fdac, 31, 0 },
{"MAC_PCU_BUF[1900]", "DATA"                                 , 0x0002fdb0, 31, 0 },
{"MAC_PCU_BUF[1901]", "DATA"                                 , 0x0002fdb4, 31, 0 },
{"MAC_PCU_BUF[1902]", "DATA"                                 , 0x0002fdb8, 31, 0 },
{"MAC_PCU_BUF[1903]", "DATA"                                 , 0x0002fdbc, 31, 0 },
{"MAC_PCU_BUF[1904]", "DATA"                                 , 0x0002fdc0, 31, 0 },
{"MAC_PCU_BUF[1905]", "DATA"                                 , 0x0002fdc4, 31, 0 },
{"MAC_PCU_BUF[1906]", "DATA"                                 , 0x0002fdc8, 31, 0 },
{"MAC_PCU_BUF[1907]", "DATA"                                 , 0x0002fdcc, 31, 0 },
{"MAC_PCU_BUF[1908]", "DATA"                                 , 0x0002fdd0, 31, 0 },
{"MAC_PCU_BUF[1909]", "DATA"                                 , 0x0002fdd4, 31, 0 },
{"MAC_PCU_BUF[1910]", "DATA"                                 , 0x0002fdd8, 31, 0 },
{"MAC_PCU_BUF[1911]", "DATA"                                 , 0x0002fddc, 31, 0 },
{"MAC_PCU_BUF[1912]", "DATA"                                 , 0x0002fde0, 31, 0 },
{"MAC_PCU_BUF[1913]", "DATA"                                 , 0x0002fde4, 31, 0 },
{"MAC_PCU_BUF[1914]", "DATA"                                 , 0x0002fde8, 31, 0 },
{"MAC_PCU_BUF[1915]", "DATA"                                 , 0x0002fdec, 31, 0 },
{"MAC_PCU_BUF[1916]", "DATA"                                 , 0x0002fdf0, 31, 0 },
{"MAC_PCU_BUF[1917]", "DATA"                                 , 0x0002fdf4, 31, 0 },
{"MAC_PCU_BUF[1918]", "DATA"                                 , 0x0002fdf8, 31, 0 },
{"MAC_PCU_BUF[1919]", "DATA"                                 , 0x0002fdfc, 31, 0 },
{"MAC_PCU_BUF[1920]", "DATA"                                 , 0x0002fe00, 31, 0 },
{"MAC_PCU_BUF[1921]", "DATA"                                 , 0x0002fe04, 31, 0 },
{"MAC_PCU_BUF[1922]", "DATA"                                 , 0x0002fe08, 31, 0 },
{"MAC_PCU_BUF[1923]", "DATA"                                 , 0x0002fe0c, 31, 0 },
{"MAC_PCU_BUF[1924]", "DATA"                                 , 0x0002fe10, 31, 0 },
{"MAC_PCU_BUF[1925]", "DATA"                                 , 0x0002fe14, 31, 0 },
{"MAC_PCU_BUF[1926]", "DATA"                                 , 0x0002fe18, 31, 0 },
{"MAC_PCU_BUF[1927]", "DATA"                                 , 0x0002fe1c, 31, 0 },
{"MAC_PCU_BUF[1928]", "DATA"                                 , 0x0002fe20, 31, 0 },
{"MAC_PCU_BUF[1929]", "DATA"                                 , 0x0002fe24, 31, 0 },
{"MAC_PCU_BUF[1930]", "DATA"                                 , 0x0002fe28, 31, 0 },
{"MAC_PCU_BUF[1931]", "DATA"                                 , 0x0002fe2c, 31, 0 },
{"MAC_PCU_BUF[1932]", "DATA"                                 , 0x0002fe30, 31, 0 },
{"MAC_PCU_BUF[1933]", "DATA"                                 , 0x0002fe34, 31, 0 },
{"MAC_PCU_BUF[1934]", "DATA"                                 , 0x0002fe38, 31, 0 },
{"MAC_PCU_BUF[1935]", "DATA"                                 , 0x0002fe3c, 31, 0 },
{"MAC_PCU_BUF[1936]", "DATA"                                 , 0x0002fe40, 31, 0 },
{"MAC_PCU_BUF[1937]", "DATA"                                 , 0x0002fe44, 31, 0 },
{"MAC_PCU_BUF[1938]", "DATA"                                 , 0x0002fe48, 31, 0 },
{"MAC_PCU_BUF[1939]", "DATA"                                 , 0x0002fe4c, 31, 0 },
{"MAC_PCU_BUF[1940]", "DATA"                                 , 0x0002fe50, 31, 0 },
{"MAC_PCU_BUF[1941]", "DATA"                                 , 0x0002fe54, 31, 0 },
{"MAC_PCU_BUF[1942]", "DATA"                                 , 0x0002fe58, 31, 0 },
{"MAC_PCU_BUF[1943]", "DATA"                                 , 0x0002fe5c, 31, 0 },
{"MAC_PCU_BUF[1944]", "DATA"                                 , 0x0002fe60, 31, 0 },
{"MAC_PCU_BUF[1945]", "DATA"                                 , 0x0002fe64, 31, 0 },
{"MAC_PCU_BUF[1946]", "DATA"                                 , 0x0002fe68, 31, 0 },
{"MAC_PCU_BUF[1947]", "DATA"                                 , 0x0002fe6c, 31, 0 },
{"MAC_PCU_BUF[1948]", "DATA"                                 , 0x0002fe70, 31, 0 },
{"MAC_PCU_BUF[1949]", "DATA"                                 , 0x0002fe74, 31, 0 },
{"MAC_PCU_BUF[1950]", "DATA"                                 , 0x0002fe78, 31, 0 },
{"MAC_PCU_BUF[1951]", "DATA"                                 , 0x0002fe7c, 31, 0 },
{"MAC_PCU_BUF[1952]", "DATA"                                 , 0x0002fe80, 31, 0 },
{"MAC_PCU_BUF[1953]", "DATA"                                 , 0x0002fe84, 31, 0 },
{"MAC_PCU_BUF[1954]", "DATA"                                 , 0x0002fe88, 31, 0 },
{"MAC_PCU_BUF[1955]", "DATA"                                 , 0x0002fe8c, 31, 0 },
{"MAC_PCU_BUF[1956]", "DATA"                                 , 0x0002fe90, 31, 0 },
{"MAC_PCU_BUF[1957]", "DATA"                                 , 0x0002fe94, 31, 0 },
{"MAC_PCU_BUF[1958]", "DATA"                                 , 0x0002fe98, 31, 0 },
{"MAC_PCU_BUF[1959]", "DATA"                                 , 0x0002fe9c, 31, 0 },
{"MAC_PCU_BUF[1960]", "DATA"                                 , 0x0002fea0, 31, 0 },
{"MAC_PCU_BUF[1961]", "DATA"                                 , 0x0002fea4, 31, 0 },
{"MAC_PCU_BUF[1962]", "DATA"                                 , 0x0002fea8, 31, 0 },
{"MAC_PCU_BUF[1963]", "DATA"                                 , 0x0002feac, 31, 0 },
{"MAC_PCU_BUF[1964]", "DATA"                                 , 0x0002feb0, 31, 0 },
{"MAC_PCU_BUF[1965]", "DATA"                                 , 0x0002feb4, 31, 0 },
{"MAC_PCU_BUF[1966]", "DATA"                                 , 0x0002feb8, 31, 0 },
{"MAC_PCU_BUF[1967]", "DATA"                                 , 0x0002febc, 31, 0 },
{"MAC_PCU_BUF[1968]", "DATA"                                 , 0x0002fec0, 31, 0 },
{"MAC_PCU_BUF[1969]", "DATA"                                 , 0x0002fec4, 31, 0 },
{"MAC_PCU_BUF[1970]", "DATA"                                 , 0x0002fec8, 31, 0 },
{"MAC_PCU_BUF[1971]", "DATA"                                 , 0x0002fecc, 31, 0 },
{"MAC_PCU_BUF[1972]", "DATA"                                 , 0x0002fed0, 31, 0 },
{"MAC_PCU_BUF[1973]", "DATA"                                 , 0x0002fed4, 31, 0 },
{"MAC_PCU_BUF[1974]", "DATA"                                 , 0x0002fed8, 31, 0 },
{"MAC_PCU_BUF[1975]", "DATA"                                 , 0x0002fedc, 31, 0 },
{"MAC_PCU_BUF[1976]", "DATA"                                 , 0x0002fee0, 31, 0 },
{"MAC_PCU_BUF[1977]", "DATA"                                 , 0x0002fee4, 31, 0 },
{"MAC_PCU_BUF[1978]", "DATA"                                 , 0x0002fee8, 31, 0 },
{"MAC_PCU_BUF[1979]", "DATA"                                 , 0x0002feec, 31, 0 },
{"MAC_PCU_BUF[1980]", "DATA"                                 , 0x0002fef0, 31, 0 },
{"MAC_PCU_BUF[1981]", "DATA"                                 , 0x0002fef4, 31, 0 },
{"MAC_PCU_BUF[1982]", "DATA"                                 , 0x0002fef8, 31, 0 },
{"MAC_PCU_BUF[1983]", "DATA"                                 , 0x0002fefc, 31, 0 },
{"MAC_PCU_BUF[1984]", "DATA"                                 , 0x0002ff00, 31, 0 },
{"MAC_PCU_BUF[1985]", "DATA"                                 , 0x0002ff04, 31, 0 },
{"MAC_PCU_BUF[1986]", "DATA"                                 , 0x0002ff08, 31, 0 },
{"MAC_PCU_BUF[1987]", "DATA"                                 , 0x0002ff0c, 31, 0 },
{"MAC_PCU_BUF[1988]", "DATA"                                 , 0x0002ff10, 31, 0 },
{"MAC_PCU_BUF[1989]", "DATA"                                 , 0x0002ff14, 31, 0 },
{"MAC_PCU_BUF[1990]", "DATA"                                 , 0x0002ff18, 31, 0 },
{"MAC_PCU_BUF[1991]", "DATA"                                 , 0x0002ff1c, 31, 0 },
{"MAC_PCU_BUF[1992]", "DATA"                                 , 0x0002ff20, 31, 0 },
{"MAC_PCU_BUF[1993]", "DATA"                                 , 0x0002ff24, 31, 0 },
{"MAC_PCU_BUF[1994]", "DATA"                                 , 0x0002ff28, 31, 0 },
{"MAC_PCU_BUF[1995]", "DATA"                                 , 0x0002ff2c, 31, 0 },
{"MAC_PCU_BUF[1996]", "DATA"                                 , 0x0002ff30, 31, 0 },
{"MAC_PCU_BUF[1997]", "DATA"                                 , 0x0002ff34, 31, 0 },
{"MAC_PCU_BUF[1998]", "DATA"                                 , 0x0002ff38, 31, 0 },
{"MAC_PCU_BUF[1999]", "DATA"                                 , 0x0002ff3c, 31, 0 },
{"MAC_PCU_BUF[2000]", "DATA"                                 , 0x0002ff40, 31, 0 },
{"MAC_PCU_BUF[2001]", "DATA"                                 , 0x0002ff44, 31, 0 },
{"MAC_PCU_BUF[2002]", "DATA"                                 , 0x0002ff48, 31, 0 },
{"MAC_PCU_BUF[2003]", "DATA"                                 , 0x0002ff4c, 31, 0 },
{"MAC_PCU_BUF[2004]", "DATA"                                 , 0x0002ff50, 31, 0 },
{"MAC_PCU_BUF[2005]", "DATA"                                 , 0x0002ff54, 31, 0 },
{"MAC_PCU_BUF[2006]", "DATA"                                 , 0x0002ff58, 31, 0 },
{"MAC_PCU_BUF[2007]", "DATA"                                 , 0x0002ff5c, 31, 0 },
{"MAC_PCU_BUF[2008]", "DATA"                                 , 0x0002ff60, 31, 0 },
{"MAC_PCU_BUF[2009]", "DATA"                                 , 0x0002ff64, 31, 0 },
{"MAC_PCU_BUF[2010]", "DATA"                                 , 0x0002ff68, 31, 0 },
{"MAC_PCU_BUF[2011]", "DATA"                                 , 0x0002ff6c, 31, 0 },
{"MAC_PCU_BUF[2012]", "DATA"                                 , 0x0002ff70, 31, 0 },
{"MAC_PCU_BUF[2013]", "DATA"                                 , 0x0002ff74, 31, 0 },
{"MAC_PCU_BUF[2014]", "DATA"                                 , 0x0002ff78, 31, 0 },
{"MAC_PCU_BUF[2015]", "DATA"                                 , 0x0002ff7c, 31, 0 },
{"MAC_PCU_BUF[2016]", "DATA"                                 , 0x0002ff80, 31, 0 },
{"MAC_PCU_BUF[2017]", "DATA"                                 , 0x0002ff84, 31, 0 },
{"MAC_PCU_BUF[2018]", "DATA"                                 , 0x0002ff88, 31, 0 },
{"MAC_PCU_BUF[2019]", "DATA"                                 , 0x0002ff8c, 31, 0 },
{"MAC_PCU_BUF[2020]", "DATA"                                 , 0x0002ff90, 31, 0 },
{"MAC_PCU_BUF[2021]", "DATA"                                 , 0x0002ff94, 31, 0 },
{"MAC_PCU_BUF[2022]", "DATA"                                 , 0x0002ff98, 31, 0 },
{"MAC_PCU_BUF[2023]", "DATA"                                 , 0x0002ff9c, 31, 0 },
{"MAC_PCU_BUF[2024]", "DATA"                                 , 0x0002ffa0, 31, 0 },
{"MAC_PCU_BUF[2025]", "DATA"                                 , 0x0002ffa4, 31, 0 },
{"MAC_PCU_BUF[2026]", "DATA"                                 , 0x0002ffa8, 31, 0 },
{"MAC_PCU_BUF[2027]", "DATA"                                 , 0x0002ffac, 31, 0 },
{"MAC_PCU_BUF[2028]", "DATA"                                 , 0x0002ffb0, 31, 0 },
{"MAC_PCU_BUF[2029]", "DATA"                                 , 0x0002ffb4, 31, 0 },
{"MAC_PCU_BUF[2030]", "DATA"                                 , 0x0002ffb8, 31, 0 },
{"MAC_PCU_BUF[2031]", "DATA"                                 , 0x0002ffbc, 31, 0 },
{"MAC_PCU_BUF[2032]", "DATA"                                 , 0x0002ffc0, 31, 0 },
{"MAC_PCU_BUF[2033]", "DATA"                                 , 0x0002ffc4, 31, 0 },
{"MAC_PCU_BUF[2034]", "DATA"                                 , 0x0002ffc8, 31, 0 },
{"MAC_PCU_BUF[2035]", "DATA"                                 , 0x0002ffcc, 31, 0 },
{"MAC_PCU_BUF[2036]", "DATA"                                 , 0x0002ffd0, 31, 0 },
{"MAC_PCU_BUF[2037]", "DATA"                                 , 0x0002ffd4, 31, 0 },
{"MAC_PCU_BUF[2038]", "DATA"                                 , 0x0002ffd8, 31, 0 },
{"MAC_PCU_BUF[2039]", "DATA"                                 , 0x0002ffdc, 31, 0 },
{"MAC_PCU_BUF[2040]", "DATA"                                 , 0x0002ffe0, 31, 0 },
{"MAC_PCU_BUF[2041]", "DATA"                                 , 0x0002ffe4, 31, 0 },
{"MAC_PCU_BUF[2042]", "DATA"                                 , 0x0002ffe8, 31, 0 },
{"MAC_PCU_BUF[2043]", "DATA"                                 , 0x0002ffec, 31, 0 },
{"MAC_PCU_BUF[2044]", "DATA"                                 , 0x0002fff0, 31, 0 },
{"MAC_PCU_BUF[2045]", "DATA"                                 , 0x0002fff4, 31, 0 },
{"MAC_PCU_BUF[2046]", "DATA"                                 , 0x0002fff8, 31, 0 },
{"MAC_PCU_BUF[2047]", "DATA"                                 , 0x0002fffc, 31, 0 },
{"EFUSE_WR_ENABLE_REG", "V"                                  , 0x00030000, 0 , 0 },
{"EFUSE_INT_ENABLE_REG", "V"                                 , 0x00030004, 0 , 0 },
{"EFUSE_INT_STATUS_REG", "V"                                 , 0x00030008, 0 , 0 },
{"BITMASK_WR_REG", "V"                                       , 0x0003000c, 31, 0 },
{"VDDQ_SETTLE_TIME_REG", "V"                                 , 0x00030010, 31, 0 },
{"VDDQ_HOLD_TIME_REG", "V"                                   , 0x00030014, 31, 0 },
{"RD_STROBE_PW_REG", "V"                                     , 0x00030018, 31, 0 },
{"PG_STROBE_PW_REG", "V"                                     , 0x0003001c, 31, 0 },
{"PGENB_SETUP_HOLD_TIME_REG", "V"                            , 0x00030020, 31, 0 },
{"STROBE_PULSE_INTERVAL_REG", "V"                            , 0x00030024, 31, 0 },
{"CSB_ADDR_LOAD_SETUP_HOLD_REG", "V"                         , 0x00030028, 31, 0 },
{"EFUSE_INTF0", "R"                                          , 0x00030800, 31, 0 },
{"EFUSE_INTF1", "R"                                          , 0x00031000, 31, 0 },
{"FPGA_PHY_LAYER_REVID", "FPGA_BASEBAND_FEATURE_INDEX"       , 0x00039000, 31, 16},
{"FPGA_PHY_LAYER_REVID", "FPGA_RADIO_FEATURE_INDEX"          , 0x00039000, 15, 0 },
{"FPGA_LINK_LAYER_REVID", "FPGA_SOC_FEATURE_INDEX"           , 0x00039004, 31, 16},
{"FPGA_LINK_LAYER_REVID", "FPGA_MAC_FEATURE_INDEX"           , 0x00039004, 15, 0 },
{"FPGA_REG1", "SPARE1"                                       , 0x00039008, 31, 21},
{"FPGA_REG1", "long_shift_sample_phase"                      , 0x00039008, 20, 16},
{"FPGA_REG1", "long_shift_drive_phase"                       , 0x00039008, 15, 11},
{"FPGA_REG1", "enable_long_shift_chain_override_index"       , 0x00039008, 10, 10},
{"FPGA_REG1", "long_shift_chain_override_index"              , 0x00039008, 9 , 8 },
{"FPGA_REG1", "emulation_clock_ratio"                        , 0x00039008, 7 , 4 },
{"FPGA_REG1", "SPARE0"                                       , 0x00039008, 3 , 3 },
{"FPGA_REG1", "dcm_release"                                  , 0x00039008, 2 , 2 },
{"FPGA_REG1", "mask_rx_rf"                                   , 0x00039008, 1 , 1 },
{"FPGA_REG1", "spare_reg1_bit0"                              , 0x00039008, 0 , 0 },
{"FPGA_REG2", "TxPipeIFInjErrInDataK"                        , 0x0003900c, 3 , 3 },
{"FPGA_REG2", "RxPipeIFInjErrInDataK"                        , 0x0003900c, 2 , 2 },
{"FPGA_REG2", "TxPipeIFerrInjEn"                             , 0x0003900c, 1 , 1 },
{"FPGA_REG2", "RxPipeIFerrInjEn"                             , 0x0003900c, 0 , 0 },
{"FPGA_REG3", "fpga_changelist"                              , 0x00039010, 31, 0 },
{"FPGA_REG4", "software_owns_jtag"                           , 0x00039014, 17, 17},
{"FPGA_REG4", "radio_trstl"                                  , 0x00039014, 16, 16},
{"FPGA_REG4", "radio_3_tdo"                                  , 0x00039014, 15, 15},
{"FPGA_REG4", "radio_3_tms"                                  , 0x00039014, 14, 14},
{"FPGA_REG4", "radio_3_tdi"                                  , 0x00039014, 13, 13},
{"FPGA_REG4", "radio_3_tck"                                  , 0x00039014, 12, 12},
{"FPGA_REG4", "radio_2_tdo"                                  , 0x00039014, 11, 11},
{"FPGA_REG4", "radio_2_tms"                                  , 0x00039014, 10, 10},
{"FPGA_REG4", "radio_2_tdi"                                  , 0x00039014, 9 , 9 },
{"FPGA_REG4", "radio_2_tck"                                  , 0x00039014, 8 , 8 },
{"FPGA_REG4", "radio_1_tdo"                                  , 0x00039014, 7 , 7 },
{"FPGA_REG4", "radio_1_tms"                                  , 0x00039014, 6 , 6 },
{"FPGA_REG4", "radio_1_tdi"                                  , 0x00039014, 5 , 5 },
{"FPGA_REG4", "radio_1_tck"                                  , 0x00039014, 4 , 4 },
{"FPGA_REG4", "radio_0_tdo"                                  , 0x00039014, 3 , 3 },
{"FPGA_REG4", "radio_0_tms"                                  , 0x00039014, 2 , 2 },
{"FPGA_REG4", "radio_0_tdi"                                  , 0x00039014, 1 , 1 },
{"FPGA_REG4", "radio_0_tck"                                  , 0x00039014, 0 , 0 },
{"FPGA_REG5", "drp_din"                                      , 0x00039018, 31, 16},
{"FPGA_REG5", "drp_reserved"                                 , 0x00039018, 15, 8 },
{"FPGA_REG5", "drp_address"                                  , 0x00039018, 7 , 3 },
{"FPGA_REG5", "drp_reset"                                    , 0x00039018, 2 , 2 },
{"FPGA_REG5", "drp_dwe"                                      , 0x00039018, 1 , 1 },
{"FPGA_REG5", "drp_den"                                      , 0x00039018, 0 , 0 },
{"FPGA_REG6", "drp_dout"                                     , 0x0003901c, 31, 16},
{"FPGA_REG6", "drp_drdy"                                     , 0x0003901c, 0 , 0 },
{"FPGA_REG7", "RxPipeIFerrInjMsk"                            , 0x00039020, 31, 0 },
{"FPGA_REG8", "TxPipeIFerrInjMsk"                            , 0x00039024, 31, 0 },
{"FPGA_REG9", "TxPipeIFDataErrMsk"                           , 0x00039028, 31, 16},
{"FPGA_REG9", "RxPipeIFDataErrMsk"                           , 0x00039028, 15, 0 },
{"FPGA_REG10", "TxPipeIFSpdMsk"                              , 0x0003902c, 31, 16},
{"FPGA_REG10", "RxPipeIFSpdMsk"                              , 0x0003902c, 15, 0 },
{"FPGA_REG11", "fake_bb_lfsr_spread"                         , 0x00039030, 31, 0 },
{"FPGA_REG12", "fake_bb_lfsr_dnsty_msk"                      , 0x00039034, 31, 0 },
{"FPGA_REG13", "fake_bb_err_inject_enable"                   , 0x00039038, 0 , 0 },
{"FPGA_REG14", "rx_clr_stomp_enable"                         , 0x0003903c, 3 , 0 },
{"FPGA_REG15", "pri_clr_cnt"                                 , 0x00039040, 31, 0 },
{"FPGA_REG16", "pri_busy_cnt"                                , 0x00039044, 15, 0 },
{"FPGA_REG17", "sec20_clr_cnt"                               , 0x00039048, 31, 0 },
{"FPGA_REG18", "sec20_busy_cnt"                              , 0x0003904c, 15, 0 },
{"FPGA_REG19", "sec40_clr_cnt"                               , 0x00039050, 31, 0 },
{"FPGA_REG20", "sec40_busy_cnt"                              , 0x00039054, 15, 0 },
{"FPGA_REG21", "sec80_clr_cnt"                               , 0x00039058, 31, 0 },
{"FPGA_REG22", "sec80_busy_cnt"                              , 0x0003905c, 15, 0 },
{"UartData", "UartTxCsr"                                     , 0x00054c00, 9 , 9 },
{"UartData", "UartRxCsr"                                     , 0x00054c00, 8 , 8 },
{"UartData", "UartTxRxData"                                  , 0x00054c00, 7 , 0 },
{"UartCs", "UartRxBusy"                                      , 0x00054c04, 15, 15},
{"UartCs", "UartTxBusy"                                      , 0x00054c04, 14, 14},
{"UartCs", "UartHostIntEn"                                   , 0x00054c04, 13, 13},
{"UartCs", "UartHostInt"                                     , 0x00054c04, 12, 12},
{"UartCs", "UartTxBreak"                                     , 0x00054c04, 11, 11},
{"UartCs", "UartRxBreak"                                     , 0x00054c04, 10, 10},
{"UartCs", "UartSeriaTxReady"                                , 0x00054c04, 9 , 9 },
{"UartCs", "UartTxReadyOride"                                , 0x00054c04, 8 , 8 },
{"UartCs", "UartRxReadyOride"                                , 0x00054c04, 7 , 7 },
{"UartCs", "UartDmaEn"                                       , 0x00054c04, 6 , 6 },
{"UartCs", "UartFlowControlMode"                             , 0x00054c04, 5 , 4 },
{"UartCs", "UartInterfaceMode"                               , 0x00054c04, 3 , 2 },
{"UartCs", "UartParityMode"                                  , 0x00054c04, 1 , 0 },
{"UartClock", "UartClockScale"                               , 0x00054c08, 23, 16},
{"UartClock", "UartClockStep"                                , 0x00054c08, 15, 0 },
{"UartInt", "UartTxEmptyInt"                                 , 0x00054c0c, 9 , 9 },
{"UartInt", "UartRxFullInt"                                  , 0x00054c0c, 8 , 8 },
{"UartInt", "UartRxBreakOffInt"                              , 0x00054c0c, 7 , 7 },
{"UartInt", "UartRxBreakOnInt"                               , 0x00054c0c, 6 , 6 },
{"UartInt", "UartRxParityErrInt"                             , 0x00054c0c, 5 , 5 },
{"UartInt", "UartTxOflowErrInt"                              , 0x00054c0c, 4 , 4 },
{"UartInt", "UartRxOflowErrInt"                              , 0x00054c0c, 3 , 3 },
{"UartInt", "UartRxFramingErrInt"                            , 0x00054c0c, 2 , 2 },
{"UartInt", "UartTxReadyInt"                                 , 0x00054c0c, 1 , 1 },
{"UartInt", "UartRxValidInt"                                 , 0x00054c0c, 0 , 0 },
{"UartIntEn", "UartTxEmptyIntEn"                             , 0x00054c10, 9 , 9 },
{"UartIntEn", "UartRxFullIntEn"                              , 0x00054c10, 8 , 8 },
{"UartIntEn", "UartRxBreakOffIntEn"                          , 0x00054c10, 7 , 7 },
{"UartIntEn", "UartRxBreakOnIntEn"                           , 0x00054c10, 6 , 6 },
{"UartIntEn", "UartRxParityErrIntEn"                         , 0x00054c10, 5 , 5 },
{"UartIntEn", "UartTxOflowErrIntEn"                          , 0x00054c10, 4 , 4 },
{"UartIntEn", "UartRxOflowErrIntEn"                          , 0x00054c10, 3 , 3 },
{"UartIntEn", "UartRxFramingErrIntEn"                        , 0x00054c10, 2 , 2 },
{"UartIntEn", "UartTxReadyIntEn"                             , 0x00054c10, 1 , 1 },
{"UartIntEn", "UartRxValidIntEn"                             , 0x00054c10, 0 , 0 },
{"CE_WRAPPER_INTERRUPT_SUMMARY", "HOST_MSI"                  , 0x00057000, 15, 8 },
{"CE_WRAPPER_INTERRUPT_SUMMARY", "MISC"                      , 0x00057000, 7 , 0 },
{"NUM_AXI_OUTSTANDING", "WRITES"                             , 0x00057004, 9 , 5 },
{"NUM_AXI_OUTSTANDING", "READS"                              , 0x00057004, 4 , 0 },
{"CE_WRAPPER_DEBUG", "SEL"                                   , 0x00057008, 5 , 0 },
{"SR_BA", "V"                                                , 0x00057400, 31, 0 },
{"SR_SIZE", "V"                                              , 0x00057404, 15, 0 },
{"DR_BA", "V"                                                , 0x00057408, 31, 0 },
{"DR_SIZE", "V"                                              , 0x0005740c, 15, 0 },
{"CE_CTRL1", "MSI_EN"                                        , 0x00057410, 18, 18},
{"CE_CTRL1", "DST_RING_BYTE_SWAP_EN"                         , 0x00057410, 17, 17},
{"CE_CTRL1", "SRC_RING_BYTE_SWAP_EN"                         , 0x00057410, 16, 16},
{"CE_CTRL1", "DMAX_LENGTH"                                   , 0x00057410, 15, 0 },
{"CE_CTRL2", "NUM_AXI_OUTSTANDING_WRITES"                    , 0x00057414, 29, 25},
{"CE_CTRL2", "NUM_AXI_OUTSTANDING_READS"                     , 0x00057414, 24, 20},
{"CE_CTRL2", "AXI_TIMEOUT"                                   , 0x00057414, 19, 4 },
{"CE_CTRL2", "DEST_AXI_MAX_LEN"                              , 0x00057414, 3 , 2 },
{"CE_CTRL2", "SRC_AXI_MAX_LEN"                               , 0x00057414, 1 , 0 },
{"CE_CMD", "HALT_STATUS"                                     , 0x00057418, 3 , 3 },
{"CE_CMD", "DST_FLUSH"                                       , 0x00057418, 2 , 2 },
{"CE_CMD", "SRC_FLUSH"                                       , 0x00057418, 1 , 1 },
{"CE_CMD", "HALT"                                            , 0x00057418, 0 , 0 },
{"MSI_ADDR", "V"                                             , 0x0005741c, 31, 0 },
{"MSI_DATA", "V"                                             , 0x00057420, 31, 0 },
{"TARGET_IE", "DST_RING_LOW_WATERMARK"                       , 0x00057424, 4 , 4 },
{"TARGET_IE", "DST_RING_HIGH_WATERMARK"                      , 0x00057424, 3 , 3 },
{"TARGET_IE", "SRC_RING_LOW_WATERMARK"                       , 0x00057424, 2 , 2 },
{"TARGET_IE", "SRC_RING_HIGH_WATERMARK"                      , 0x00057424, 1 , 1 },
{"TARGET_IE", "COPY_COMPLETE"                                , 0x00057424, 0 , 0 },
{"TARGET_IS", "DST_RING_LOW_WATERMARK"                       , 0x00057428, 4 , 4 },
{"TARGET_IS", "DST_RING_HIGH_WATERMARK"                      , 0x00057428, 3 , 3 },
{"TARGET_IS", "SRC_RING_LOW_WATERMARK"                       , 0x00057428, 2 , 2 },
{"TARGET_IS", "SRC_RING_HIGH_WATERMARK"                      , 0x00057428, 1 , 1 },
{"TARGET_IS", "COPY_COMPLETE"                                , 0x00057428, 0 , 0 },
{"HOST_IE", "DST_RING_LOW_WATERMARK"                         , 0x0005742c, 4 , 4 },
{"HOST_IE", "DST_RING_HIGH_WATERMARK"                        , 0x0005742c, 3 , 3 },
{"HOST_IE", "SRC_RING_LOW_WATERMARK"                         , 0x0005742c, 2 , 2 },
{"HOST_IE", "SRC_RING_HIGH_WATERMARK"                        , 0x0005742c, 1 , 1 },
{"HOST_IE", "COPY_COMPLETE"                                  , 0x0005742c, 0 , 0 },
{"HOST_IS", "DST_RING_LOW_WATERMARK"                         , 0x00057430, 4 , 4 },
{"HOST_IS", "DST_RING_HIGH_WATERMARK"                        , 0x00057430, 3 , 3 },
{"HOST_IS", "SRC_RING_LOW_WATERMARK"                         , 0x00057430, 2 , 2 },
{"HOST_IS", "SRC_RING_HIGH_WATERMARK"                        , 0x00057430, 1 , 1 },
{"HOST_IS", "COPY_COMPLETE"                                  , 0x00057430, 0 , 0 },
{"MISC_IE", "AXI_ERR"                                        , 0x00057434, 10, 10},
{"MISC_IE", "DST_ADDR_ERR"                                   , 0x00057434, 9 , 9 },
{"MISC_IE", "SRC_LEN_ERR"                                    , 0x00057434, 8 , 8 },
{"MISC_IE", "DST_MAX_LEN_VIO"                                , 0x00057434, 7 , 7 },
{"MISC_IE", "DST_RING_OVERFLOW"                              , 0x00057434, 6 , 6 },
{"MISC_IE", "SRC_RING_OVERFLOW"                              , 0x00057434, 5 , 5 },
{"MISC_IE", "DST_RING_LOW_WATERMARK"                         , 0x00057434, 4 , 4 },
{"MISC_IE", "DST_RING_HIGH_WATERMARK"                        , 0x00057434, 3 , 3 },
{"MISC_IE", "SRC_RING_LOW_WATERMARK"                         , 0x00057434, 2 , 2 },
{"MISC_IE", "SRC_RING_HIGH_WATERMARK"                        , 0x00057434, 1 , 1 },
{"MISC_IE", "COPY_COMPLETE"                                  , 0x00057434, 0 , 0 },
{"MISC_IS", "AXI_ERR"                                        , 0x00057438, 10, 10},
{"MISC_IS", "DST_ADDR_ERR"                                   , 0x00057438, 9 , 9 },
{"MISC_IS", "SRC_LEN_ERR"                                    , 0x00057438, 8 , 8 },
{"MISC_IS", "DST_MAX_LEN_VIO"                                , 0x00057438, 7 , 7 },
{"MISC_IS", "DST_RING_OVERFLOW"                              , 0x00057438, 6 , 6 },
{"MISC_IS", "SRC_RING_OVERFLOW"                              , 0x00057438, 5 , 5 },
{"MISC_IS", "DST_RING_LOW_WATERMARK"                         , 0x00057438, 4 , 4 },
{"MISC_IS", "DST_RING_HIGH_WATERMARK"                        , 0x00057438, 3 , 3 },
{"MISC_IS", "SRC_RING_LOW_WATERMARK"                         , 0x00057438, 2 , 2 },
{"MISC_IS", "SRC_RING_HIGH_WATERMARK"                        , 0x00057438, 1 , 1 },
{"MISC_IS", "COPY_COMPLETE"                                  , 0x00057438, 0 , 0 },
{"SR_WR_INDEX", "V"                                          , 0x0005743c, 15, 0 },
{"DST_WR_INDEX", "V"                                         , 0x00057440, 15, 0 },
{"CURRENT_SRRI", "V"                                         , 0x00057444, 15, 0 },
{"CURRENT_DRRI", "V"                                         , 0x00057448, 15, 0 },
{"SRC_WATERMARK", "LOW"                                      , 0x0005744c, 31, 16},
{"SRC_WATERMARK", "HIGH"                                     , 0x0005744c, 15, 0 },
{"DST_WATERMARK", "LOW"                                      , 0x00057450, 31, 16},
{"DST_WATERMARK", "HIGH"                                     , 0x00057450, 15, 0 },
{"CE_DEBUG", "SEL"                                           , 0x00057454, 5 , 0 },
{"SR_BA", "V"                                                , 0x00057800, 31, 0 },
{"SR_SIZE", "V"                                              , 0x00057804, 15, 0 },
{"DR_BA", "V"                                                , 0x00057808, 31, 0 },
{"DR_SIZE", "V"                                              , 0x0005780c, 15, 0 },
{"CE_CTRL1", "MSI_EN"                                        , 0x00057810, 18, 18},
{"CE_CTRL1", "DST_RING_BYTE_SWAP_EN"                         , 0x00057810, 17, 17},
{"CE_CTRL1", "SRC_RING_BYTE_SWAP_EN"                         , 0x00057810, 16, 16},
{"CE_CTRL1", "DMAX_LENGTH"                                   , 0x00057810, 15, 0 },
{"CE_CTRL2", "NUM_AXI_OUTSTANDING_WRITES"                    , 0x00057814, 29, 25},
{"CE_CTRL2", "NUM_AXI_OUTSTANDING_READS"                     , 0x00057814, 24, 20},
{"CE_CTRL2", "AXI_TIMEOUT"                                   , 0x00057814, 19, 4 },
{"CE_CTRL2", "DEST_AXI_MAX_LEN"                              , 0x00057814, 3 , 2 },
{"CE_CTRL2", "SRC_AXI_MAX_LEN"                               , 0x00057814, 1 , 0 },
{"CE_CMD", "HALT_STATUS"                                     , 0x00057818, 3 , 3 },
{"CE_CMD", "DST_FLUSH"                                       , 0x00057818, 2 , 2 },
{"CE_CMD", "SRC_FLUSH"                                       , 0x00057818, 1 , 1 },
{"CE_CMD", "HALT"                                            , 0x00057818, 0 , 0 },
{"MSI_ADDR", "V"                                             , 0x0005781c, 31, 0 },
{"MSI_DATA", "V"                                             , 0x00057820, 31, 0 },
{"TARGET_IE", "DST_RING_LOW_WATERMARK"                       , 0x00057824, 4 , 4 },
{"TARGET_IE", "DST_RING_HIGH_WATERMARK"                      , 0x00057824, 3 , 3 },
{"TARGET_IE", "SRC_RING_LOW_WATERMARK"                       , 0x00057824, 2 , 2 },
{"TARGET_IE", "SRC_RING_HIGH_WATERMARK"                      , 0x00057824, 1 , 1 },
{"TARGET_IE", "COPY_COMPLETE"                                , 0x00057824, 0 , 0 },
{"TARGET_IS", "DST_RING_LOW_WATERMARK"                       , 0x00057828, 4 , 4 },
{"TARGET_IS", "DST_RING_HIGH_WATERMARK"                      , 0x00057828, 3 , 3 },
{"TARGET_IS", "SRC_RING_LOW_WATERMARK"                       , 0x00057828, 2 , 2 },
{"TARGET_IS", "SRC_RING_HIGH_WATERMARK"                      , 0x00057828, 1 , 1 },
{"TARGET_IS", "COPY_COMPLETE"                                , 0x00057828, 0 , 0 },
{"HOST_IE", "DST_RING_LOW_WATERMARK"                         , 0x0005782c, 4 , 4 },
{"HOST_IE", "DST_RING_HIGH_WATERMARK"                        , 0x0005782c, 3 , 3 },
{"HOST_IE", "SRC_RING_LOW_WATERMARK"                         , 0x0005782c, 2 , 2 },
{"HOST_IE", "SRC_RING_HIGH_WATERMARK"                        , 0x0005782c, 1 , 1 },
{"HOST_IE", "COPY_COMPLETE"                                  , 0x0005782c, 0 , 0 },
{"HOST_IS", "DST_RING_LOW_WATERMARK"                         , 0x00057830, 4 , 4 },
{"HOST_IS", "DST_RING_HIGH_WATERMARK"                        , 0x00057830, 3 , 3 },
{"HOST_IS", "SRC_RING_LOW_WATERMARK"                         , 0x00057830, 2 , 2 },
{"HOST_IS", "SRC_RING_HIGH_WATERMARK"                        , 0x00057830, 1 , 1 },
{"HOST_IS", "COPY_COMPLETE"                                  , 0x00057830, 0 , 0 },
{"MISC_IE", "AXI_ERR"                                        , 0x00057834, 10, 10},
{"MISC_IE", "DST_ADDR_ERR"                                   , 0x00057834, 9 , 9 },
{"MISC_IE", "SRC_LEN_ERR"                                    , 0x00057834, 8 , 8 },
{"MISC_IE", "DST_MAX_LEN_VIO"                                , 0x00057834, 7 , 7 },
{"MISC_IE", "DST_RING_OVERFLOW"                              , 0x00057834, 6 , 6 },
{"MISC_IE", "SRC_RING_OVERFLOW"                              , 0x00057834, 5 , 5 },
{"MISC_IE", "DST_RING_LOW_WATERMARK"                         , 0x00057834, 4 , 4 },
{"MISC_IE", "DST_RING_HIGH_WATERMARK"                        , 0x00057834, 3 , 3 },
{"MISC_IE", "SRC_RING_LOW_WATERMARK"                         , 0x00057834, 2 , 2 },
{"MISC_IE", "SRC_RING_HIGH_WATERMARK"                        , 0x00057834, 1 , 1 },
{"MISC_IE", "COPY_COMPLETE"                                  , 0x00057834, 0 , 0 },
{"MISC_IS", "AXI_ERR"                                        , 0x00057838, 10, 10},
{"MISC_IS", "DST_ADDR_ERR"                                   , 0x00057838, 9 , 9 },
{"MISC_IS", "SRC_LEN_ERR"                                    , 0x00057838, 8 , 8 },
{"MISC_IS", "DST_MAX_LEN_VIO"                                , 0x00057838, 7 , 7 },
{"MISC_IS", "DST_RING_OVERFLOW"                              , 0x00057838, 6 , 6 },
{"MISC_IS", "SRC_RING_OVERFLOW"                              , 0x00057838, 5 , 5 },
{"MISC_IS", "DST_RING_LOW_WATERMARK"                         , 0x00057838, 4 , 4 },
{"MISC_IS", "DST_RING_HIGH_WATERMARK"                        , 0x00057838, 3 , 3 },
{"MISC_IS", "SRC_RING_LOW_WATERMARK"                         , 0x00057838, 2 , 2 },
{"MISC_IS", "SRC_RING_HIGH_WATERMARK"                        , 0x00057838, 1 , 1 },
{"MISC_IS", "COPY_COMPLETE"                                  , 0x00057838, 0 , 0 },
{"SR_WR_INDEX", "V"                                          , 0x0005783c, 15, 0 },
{"DST_WR_INDEX", "V"                                         , 0x00057840, 15, 0 },
{"CURRENT_SRRI", "V"                                         , 0x00057844, 15, 0 },
{"CURRENT_DRRI", "V"                                         , 0x00057848, 15, 0 },
{"SRC_WATERMARK", "LOW"                                      , 0x0005784c, 31, 16},
{"SRC_WATERMARK", "HIGH"                                     , 0x0005784c, 15, 0 },
{"DST_WATERMARK", "LOW"                                      , 0x00057850, 31, 16},
{"DST_WATERMARK", "HIGH"                                     , 0x00057850, 15, 0 },
{"CE_DEBUG", "SEL"                                           , 0x00057854, 5 , 0 },
{"SR_BA", "V"                                                , 0x00057c00, 31, 0 },
{"SR_SIZE", "V"                                              , 0x00057c04, 15, 0 },
{"DR_BA", "V"                                                , 0x00057c08, 31, 0 },
{"DR_SIZE", "V"                                              , 0x00057c0c, 15, 0 },
{"CE_CTRL1", "MSI_EN"                                        , 0x00057c10, 18, 18},
{"CE_CTRL1", "DST_RING_BYTE_SWAP_EN"                         , 0x00057c10, 17, 17},
{"CE_CTRL1", "SRC_RING_BYTE_SWAP_EN"                         , 0x00057c10, 16, 16},
{"CE_CTRL1", "DMAX_LENGTH"                                   , 0x00057c10, 15, 0 },
{"CE_CTRL2", "NUM_AXI_OUTSTANDING_WRITES"                    , 0x00057c14, 29, 25},
{"CE_CTRL2", "NUM_AXI_OUTSTANDING_READS"                     , 0x00057c14, 24, 20},
{"CE_CTRL2", "AXI_TIMEOUT"                                   , 0x00057c14, 19, 4 },
{"CE_CTRL2", "DEST_AXI_MAX_LEN"                              , 0x00057c14, 3 , 2 },
{"CE_CTRL2", "SRC_AXI_MAX_LEN"                               , 0x00057c14, 1 , 0 },
{"CE_CMD", "HALT_STATUS"                                     , 0x00057c18, 3 , 3 },
{"CE_CMD", "DST_FLUSH"                                       , 0x00057c18, 2 , 2 },
{"CE_CMD", "SRC_FLUSH"                                       , 0x00057c18, 1 , 1 },
{"CE_CMD", "HALT"                                            , 0x00057c18, 0 , 0 },
{"MSI_ADDR", "V"                                             , 0x00057c1c, 31, 0 },
{"MSI_DATA", "V"                                             , 0x00057c20, 31, 0 },
{"TARGET_IE", "DST_RING_LOW_WATERMARK"                       , 0x00057c24, 4 , 4 },
{"TARGET_IE", "DST_RING_HIGH_WATERMARK"                      , 0x00057c24, 3 , 3 },
{"TARGET_IE", "SRC_RING_LOW_WATERMARK"                       , 0x00057c24, 2 , 2 },
{"TARGET_IE", "SRC_RING_HIGH_WATERMARK"                      , 0x00057c24, 1 , 1 },
{"TARGET_IE", "COPY_COMPLETE"                                , 0x00057c24, 0 , 0 },
{"TARGET_IS", "DST_RING_LOW_WATERMARK"                       , 0x00057c28, 4 , 4 },
{"TARGET_IS", "DST_RING_HIGH_WATERMARK"                      , 0x00057c28, 3 , 3 },
{"TARGET_IS", "SRC_RING_LOW_WATERMARK"                       , 0x00057c28, 2 , 2 },
{"TARGET_IS", "SRC_RING_HIGH_WATERMARK"                      , 0x00057c28, 1 , 1 },
{"TARGET_IS", "COPY_COMPLETE"                                , 0x00057c28, 0 , 0 },
{"HOST_IE", "DST_RING_LOW_WATERMARK"                         , 0x00057c2c, 4 , 4 },
{"HOST_IE", "DST_RING_HIGH_WATERMARK"                        , 0x00057c2c, 3 , 3 },
{"HOST_IE", "SRC_RING_LOW_WATERMARK"                         , 0x00057c2c, 2 , 2 },
{"HOST_IE", "SRC_RING_HIGH_WATERMARK"                        , 0x00057c2c, 1 , 1 },
{"HOST_IE", "COPY_COMPLETE"                                  , 0x00057c2c, 0 , 0 },
{"HOST_IS", "DST_RING_LOW_WATERMARK"                         , 0x00057c30, 4 , 4 },
{"HOST_IS", "DST_RING_HIGH_WATERMARK"                        , 0x00057c30, 3 , 3 },
{"HOST_IS", "SRC_RING_LOW_WATERMARK"                         , 0x00057c30, 2 , 2 },
{"HOST_IS", "SRC_RING_HIGH_WATERMARK"                        , 0x00057c30, 1 , 1 },
{"HOST_IS", "COPY_COMPLETE"                                  , 0x00057c30, 0 , 0 },
{"MISC_IE", "AXI_ERR"                                        , 0x00057c34, 10, 10},
{"MISC_IE", "DST_ADDR_ERR"                                   , 0x00057c34, 9 , 9 },
{"MISC_IE", "SRC_LEN_ERR"                                    , 0x00057c34, 8 , 8 },
{"MISC_IE", "DST_MAX_LEN_VIO"                                , 0x00057c34, 7 , 7 },
{"MISC_IE", "DST_RING_OVERFLOW"                              , 0x00057c34, 6 , 6 },
{"MISC_IE", "SRC_RING_OVERFLOW"                              , 0x00057c34, 5 , 5 },
{"MISC_IE", "DST_RING_LOW_WATERMARK"                         , 0x00057c34, 4 , 4 },
{"MISC_IE", "DST_RING_HIGH_WATERMARK"                        , 0x00057c34, 3 , 3 },
{"MISC_IE", "SRC_RING_LOW_WATERMARK"                         , 0x00057c34, 2 , 2 },
{"MISC_IE", "SRC_RING_HIGH_WATERMARK"                        , 0x00057c34, 1 , 1 },
{"MISC_IE", "COPY_COMPLETE"                                  , 0x00057c34, 0 , 0 },
{"MISC_IS", "AXI_ERR"                                        , 0x00057c38, 10, 10},
{"MISC_IS", "DST_ADDR_ERR"                                   , 0x00057c38, 9 , 9 },
{"MISC_IS", "SRC_LEN_ERR"                                    , 0x00057c38, 8 , 8 },
{"MISC_IS", "DST_MAX_LEN_VIO"                                , 0x00057c38, 7 , 7 },
{"MISC_IS", "DST_RING_OVERFLOW"                              , 0x00057c38, 6 , 6 },
{"MISC_IS", "SRC_RING_OVERFLOW"                              , 0x00057c38, 5 , 5 },
{"MISC_IS", "DST_RING_LOW_WATERMARK"                         , 0x00057c38, 4 , 4 },
{"MISC_IS", "DST_RING_HIGH_WATERMARK"                        , 0x00057c38, 3 , 3 },
{"MISC_IS", "SRC_RING_LOW_WATERMARK"                         , 0x00057c38, 2 , 2 },
{"MISC_IS", "SRC_RING_HIGH_WATERMARK"                        , 0x00057c38, 1 , 1 },
{"MISC_IS", "COPY_COMPLETE"                                  , 0x00057c38, 0 , 0 },
{"SR_WR_INDEX", "V"                                          , 0x00057c3c, 15, 0 },
{"DST_WR_INDEX", "V"                                         , 0x00057c40, 15, 0 },
{"CURRENT_SRRI", "V"                                         , 0x00057c44, 15, 0 },
{"CURRENT_DRRI", "V"                                         , 0x00057c48, 15, 0 },
{"SRC_WATERMARK", "LOW"                                      , 0x00057c4c, 31, 16},
{"SRC_WATERMARK", "HIGH"                                     , 0x00057c4c, 15, 0 },
{"DST_WATERMARK", "LOW"                                      , 0x00057c50, 31, 16},
{"DST_WATERMARK", "HIGH"                                     , 0x00057c50, 15, 0 },
{"CE_DEBUG", "SEL"                                           , 0x00057c54, 5 , 0 },
{"SR_BA", "V"                                                , 0x00058000, 31, 0 },
{"SR_SIZE", "V"                                              , 0x00058004, 15, 0 },
{"DR_BA", "V"                                                , 0x00058008, 31, 0 },
{"DR_SIZE", "V"                                              , 0x0005800c, 15, 0 },
{"CE_CTRL1", "MSI_EN"                                        , 0x00058010, 18, 18},
{"CE_CTRL1", "DST_RING_BYTE_SWAP_EN"                         , 0x00058010, 17, 17},
{"CE_CTRL1", "SRC_RING_BYTE_SWAP_EN"                         , 0x00058010, 16, 16},
{"CE_CTRL1", "DMAX_LENGTH"                                   , 0x00058010, 15, 0 },
{"CE_CTRL2", "NUM_AXI_OUTSTANDING_WRITES"                    , 0x00058014, 29, 25},
{"CE_CTRL2", "NUM_AXI_OUTSTANDING_READS"                     , 0x00058014, 24, 20},
{"CE_CTRL2", "AXI_TIMEOUT"                                   , 0x00058014, 19, 4 },
{"CE_CTRL2", "DEST_AXI_MAX_LEN"                              , 0x00058014, 3 , 2 },
{"CE_CTRL2", "SRC_AXI_MAX_LEN"                               , 0x00058014, 1 , 0 },
{"CE_CMD", "HALT_STATUS"                                     , 0x00058018, 3 , 3 },
{"CE_CMD", "DST_FLUSH"                                       , 0x00058018, 2 , 2 },
{"CE_CMD", "SRC_FLUSH"                                       , 0x00058018, 1 , 1 },
{"CE_CMD", "HALT"                                            , 0x00058018, 0 , 0 },
{"MSI_ADDR", "V"                                             , 0x0005801c, 31, 0 },
{"MSI_DATA", "V"                                             , 0x00058020, 31, 0 },
{"TARGET_IE", "DST_RING_LOW_WATERMARK"                       , 0x00058024, 4 , 4 },
{"TARGET_IE", "DST_RING_HIGH_WATERMARK"                      , 0x00058024, 3 , 3 },
{"TARGET_IE", "SRC_RING_LOW_WATERMARK"                       , 0x00058024, 2 , 2 },
{"TARGET_IE", "SRC_RING_HIGH_WATERMARK"                      , 0x00058024, 1 , 1 },
{"TARGET_IE", "COPY_COMPLETE"                                , 0x00058024, 0 , 0 },
{"TARGET_IS", "DST_RING_LOW_WATERMARK"                       , 0x00058028, 4 , 4 },
{"TARGET_IS", "DST_RING_HIGH_WATERMARK"                      , 0x00058028, 3 , 3 },
{"TARGET_IS", "SRC_RING_LOW_WATERMARK"                       , 0x00058028, 2 , 2 },
{"TARGET_IS", "SRC_RING_HIGH_WATERMARK"                      , 0x00058028, 1 , 1 },
{"TARGET_IS", "COPY_COMPLETE"                                , 0x00058028, 0 , 0 },
{"HOST_IE", "DST_RING_LOW_WATERMARK"                         , 0x0005802c, 4 , 4 },
{"HOST_IE", "DST_RING_HIGH_WATERMARK"                        , 0x0005802c, 3 , 3 },
{"HOST_IE", "SRC_RING_LOW_WATERMARK"                         , 0x0005802c, 2 , 2 },
{"HOST_IE", "SRC_RING_HIGH_WATERMARK"                        , 0x0005802c, 1 , 1 },
{"HOST_IE", "COPY_COMPLETE"                                  , 0x0005802c, 0 , 0 },
{"HOST_IS", "DST_RING_LOW_WATERMARK"                         , 0x00058030, 4 , 4 },
{"HOST_IS", "DST_RING_HIGH_WATERMARK"                        , 0x00058030, 3 , 3 },
{"HOST_IS", "SRC_RING_LOW_WATERMARK"                         , 0x00058030, 2 , 2 },
{"HOST_IS", "SRC_RING_HIGH_WATERMARK"                        , 0x00058030, 1 , 1 },
{"HOST_IS", "COPY_COMPLETE"                                  , 0x00058030, 0 , 0 },
{"MISC_IE", "AXI_ERR"                                        , 0x00058034, 10, 10},
{"MISC_IE", "DST_ADDR_ERR"                                   , 0x00058034, 9 , 9 },
{"MISC_IE", "SRC_LEN_ERR"                                    , 0x00058034, 8 , 8 },
{"MISC_IE", "DST_MAX_LEN_VIO"                                , 0x00058034, 7 , 7 },
{"MISC_IE", "DST_RING_OVERFLOW"                              , 0x00058034, 6 , 6 },
{"MISC_IE", "SRC_RING_OVERFLOW"                              , 0x00058034, 5 , 5 },
{"MISC_IE", "DST_RING_LOW_WATERMARK"                         , 0x00058034, 4 , 4 },
{"MISC_IE", "DST_RING_HIGH_WATERMARK"                        , 0x00058034, 3 , 3 },
{"MISC_IE", "SRC_RING_LOW_WATERMARK"                         , 0x00058034, 2 , 2 },
{"MISC_IE", "SRC_RING_HIGH_WATERMARK"                        , 0x00058034, 1 , 1 },
{"MISC_IE", "COPY_COMPLETE"                                  , 0x00058034, 0 , 0 },
{"MISC_IS", "AXI_ERR"                                        , 0x00058038, 10, 10},
{"MISC_IS", "DST_ADDR_ERR"                                   , 0x00058038, 9 , 9 },
{"MISC_IS", "SRC_LEN_ERR"                                    , 0x00058038, 8 , 8 },
{"MISC_IS", "DST_MAX_LEN_VIO"                                , 0x00058038, 7 , 7 },
{"MISC_IS", "DST_RING_OVERFLOW"                              , 0x00058038, 6 , 6 },
{"MISC_IS", "SRC_RING_OVERFLOW"                              , 0x00058038, 5 , 5 },
{"MISC_IS", "DST_RING_LOW_WATERMARK"                         , 0x00058038, 4 , 4 },
{"MISC_IS", "DST_RING_HIGH_WATERMARK"                        , 0x00058038, 3 , 3 },
{"MISC_IS", "SRC_RING_LOW_WATERMARK"                         , 0x00058038, 2 , 2 },
{"MISC_IS", "SRC_RING_HIGH_WATERMARK"                        , 0x00058038, 1 , 1 },
{"MISC_IS", "COPY_COMPLETE"                                  , 0x00058038, 0 , 0 },
{"SR_WR_INDEX", "V"                                          , 0x0005803c, 15, 0 },
{"DST_WR_INDEX", "V"                                         , 0x00058040, 15, 0 },
{"CURRENT_SRRI", "V"                                         , 0x00058044, 15, 0 },
{"CURRENT_DRRI", "V"                                         , 0x00058048, 15, 0 },
{"SRC_WATERMARK", "LOW"                                      , 0x0005804c, 31, 16},
{"SRC_WATERMARK", "HIGH"                                     , 0x0005804c, 15, 0 },
{"DST_WATERMARK", "LOW"                                      , 0x00058050, 31, 16},
{"DST_WATERMARK", "HIGH"                                     , 0x00058050, 15, 0 },
{"CE_DEBUG", "SEL"                                           , 0x00058054, 5 , 0 },
{"SR_BA", "V"                                                , 0x00058400, 31, 0 },
{"SR_SIZE", "V"                                              , 0x00058404, 15, 0 },
{"DR_BA", "V"                                                , 0x00058408, 31, 0 },
{"DR_SIZE", "V"                                              , 0x0005840c, 15, 0 },
{"CE_CTRL1", "MSI_EN"                                        , 0x00058410, 18, 18},
{"CE_CTRL1", "DST_RING_BYTE_SWAP_EN"                         , 0x00058410, 17, 17},
{"CE_CTRL1", "SRC_RING_BYTE_SWAP_EN"                         , 0x00058410, 16, 16},
{"CE_CTRL1", "DMAX_LENGTH"                                   , 0x00058410, 15, 0 },
{"CE_CTRL2", "NUM_AXI_OUTSTANDING_WRITES"                    , 0x00058414, 29, 25},
{"CE_CTRL2", "NUM_AXI_OUTSTANDING_READS"                     , 0x00058414, 24, 20},
{"CE_CTRL2", "AXI_TIMEOUT"                                   , 0x00058414, 19, 4 },
{"CE_CTRL2", "DEST_AXI_MAX_LEN"                              , 0x00058414, 3 , 2 },
{"CE_CTRL2", "SRC_AXI_MAX_LEN"                               , 0x00058414, 1 , 0 },
{"CE_CMD", "HALT_STATUS"                                     , 0x00058418, 3 , 3 },
{"CE_CMD", "DST_FLUSH"                                       , 0x00058418, 2 , 2 },
{"CE_CMD", "SRC_FLUSH"                                       , 0x00058418, 1 , 1 },
{"CE_CMD", "HALT"                                            , 0x00058418, 0 , 0 },
{"MSI_ADDR", "V"                                             , 0x0005841c, 31, 0 },
{"MSI_DATA", "V"                                             , 0x00058420, 31, 0 },
{"TARGET_IE", "DST_RING_LOW_WATERMARK"                       , 0x00058424, 4 , 4 },
{"TARGET_IE", "DST_RING_HIGH_WATERMARK"                      , 0x00058424, 3 , 3 },
{"TARGET_IE", "SRC_RING_LOW_WATERMARK"                       , 0x00058424, 2 , 2 },
{"TARGET_IE", "SRC_RING_HIGH_WATERMARK"                      , 0x00058424, 1 , 1 },
{"TARGET_IE", "COPY_COMPLETE"                                , 0x00058424, 0 , 0 },
{"TARGET_IS", "DST_RING_LOW_WATERMARK"                       , 0x00058428, 4 , 4 },
{"TARGET_IS", "DST_RING_HIGH_WATERMARK"                      , 0x00058428, 3 , 3 },
{"TARGET_IS", "SRC_RING_LOW_WATERMARK"                       , 0x00058428, 2 , 2 },
{"TARGET_IS", "SRC_RING_HIGH_WATERMARK"                      , 0x00058428, 1 , 1 },
{"TARGET_IS", "COPY_COMPLETE"                                , 0x00058428, 0 , 0 },
{"HOST_IE", "DST_RING_LOW_WATERMARK"                         , 0x0005842c, 4 , 4 },
{"HOST_IE", "DST_RING_HIGH_WATERMARK"                        , 0x0005842c, 3 , 3 },
{"HOST_IE", "SRC_RING_LOW_WATERMARK"                         , 0x0005842c, 2 , 2 },
{"HOST_IE", "SRC_RING_HIGH_WATERMARK"                        , 0x0005842c, 1 , 1 },
{"HOST_IE", "COPY_COMPLETE"                                  , 0x0005842c, 0 , 0 },
{"HOST_IS", "DST_RING_LOW_WATERMARK"                         , 0x00058430, 4 , 4 },
{"HOST_IS", "DST_RING_HIGH_WATERMARK"                        , 0x00058430, 3 , 3 },
{"HOST_IS", "SRC_RING_LOW_WATERMARK"                         , 0x00058430, 2 , 2 },
{"HOST_IS", "SRC_RING_HIGH_WATERMARK"                        , 0x00058430, 1 , 1 },
{"HOST_IS", "COPY_COMPLETE"                                  , 0x00058430, 0 , 0 },
{"MISC_IE", "AXI_ERR"                                        , 0x00058434, 10, 10},
{"MISC_IE", "DST_ADDR_ERR"                                   , 0x00058434, 9 , 9 },
{"MISC_IE", "SRC_LEN_ERR"                                    , 0x00058434, 8 , 8 },
{"MISC_IE", "DST_MAX_LEN_VIO"                                , 0x00058434, 7 , 7 },
{"MISC_IE", "DST_RING_OVERFLOW"                              , 0x00058434, 6 , 6 },
{"MISC_IE", "SRC_RING_OVERFLOW"                              , 0x00058434, 5 , 5 },
{"MISC_IE", "DST_RING_LOW_WATERMARK"                         , 0x00058434, 4 , 4 },
{"MISC_IE", "DST_RING_HIGH_WATERMARK"                        , 0x00058434, 3 , 3 },
{"MISC_IE", "SRC_RING_LOW_WATERMARK"                         , 0x00058434, 2 , 2 },
{"MISC_IE", "SRC_RING_HIGH_WATERMARK"                        , 0x00058434, 1 , 1 },
{"MISC_IE", "COPY_COMPLETE"                                  , 0x00058434, 0 , 0 },
{"MISC_IS", "AXI_ERR"                                        , 0x00058438, 10, 10},
{"MISC_IS", "DST_ADDR_ERR"                                   , 0x00058438, 9 , 9 },
{"MISC_IS", "SRC_LEN_ERR"                                    , 0x00058438, 8 , 8 },
{"MISC_IS", "DST_MAX_LEN_VIO"                                , 0x00058438, 7 , 7 },
{"MISC_IS", "DST_RING_OVERFLOW"                              , 0x00058438, 6 , 6 },
{"MISC_IS", "SRC_RING_OVERFLOW"                              , 0x00058438, 5 , 5 },
{"MISC_IS", "DST_RING_LOW_WATERMARK"                         , 0x00058438, 4 , 4 },
{"MISC_IS", "DST_RING_HIGH_WATERMARK"                        , 0x00058438, 3 , 3 },
{"MISC_IS", "SRC_RING_LOW_WATERMARK"                         , 0x00058438, 2 , 2 },
{"MISC_IS", "SRC_RING_HIGH_WATERMARK"                        , 0x00058438, 1 , 1 },
{"MISC_IS", "COPY_COMPLETE"                                  , 0x00058438, 0 , 0 },
{"SR_WR_INDEX", "V"                                          , 0x0005843c, 15, 0 },
{"DST_WR_INDEX", "V"                                         , 0x00058440, 15, 0 },
{"CURRENT_SRRI", "V"                                         , 0x00058444, 15, 0 },
{"CURRENT_DRRI", "V"                                         , 0x00058448, 15, 0 },
{"SRC_WATERMARK", "LOW"                                      , 0x0005844c, 31, 16},
{"SRC_WATERMARK", "HIGH"                                     , 0x0005844c, 15, 0 },
{"DST_WATERMARK", "LOW"                                      , 0x00058450, 31, 16},
{"DST_WATERMARK", "HIGH"                                     , 0x00058450, 15, 0 },
{"CE_DEBUG", "SEL"                                           , 0x00058454, 5 , 0 },
{"SR_BA", "V"                                                , 0x00058800, 31, 0 },
{"SR_SIZE", "V"                                              , 0x00058804, 15, 0 },
{"DR_BA", "V"                                                , 0x00058808, 31, 0 },
{"DR_SIZE", "V"                                              , 0x0005880c, 15, 0 },
{"CE_CTRL1", "MSI_EN"                                        , 0x00058810, 18, 18},
{"CE_CTRL1", "DST_RING_BYTE_SWAP_EN"                         , 0x00058810, 17, 17},
{"CE_CTRL1", "SRC_RING_BYTE_SWAP_EN"                         , 0x00058810, 16, 16},
{"CE_CTRL1", "DMAX_LENGTH"                                   , 0x00058810, 15, 0 },
{"CE_CTRL2", "NUM_AXI_OUTSTANDING_WRITES"                    , 0x00058814, 29, 25},
{"CE_CTRL2", "NUM_AXI_OUTSTANDING_READS"                     , 0x00058814, 24, 20},
{"CE_CTRL2", "AXI_TIMEOUT"                                   , 0x00058814, 19, 4 },
{"CE_CTRL2", "DEST_AXI_MAX_LEN"                              , 0x00058814, 3 , 2 },
{"CE_CTRL2", "SRC_AXI_MAX_LEN"                               , 0x00058814, 1 , 0 },
{"CE_CMD", "HALT_STATUS"                                     , 0x00058818, 3 , 3 },
{"CE_CMD", "DST_FLUSH"                                       , 0x00058818, 2 , 2 },
{"CE_CMD", "SRC_FLUSH"                                       , 0x00058818, 1 , 1 },
{"CE_CMD", "HALT"                                            , 0x00058818, 0 , 0 },
{"MSI_ADDR", "V"                                             , 0x0005881c, 31, 0 },
{"MSI_DATA", "V"                                             , 0x00058820, 31, 0 },
{"TARGET_IE", "DST_RING_LOW_WATERMARK"                       , 0x00058824, 4 , 4 },
{"TARGET_IE", "DST_RING_HIGH_WATERMARK"                      , 0x00058824, 3 , 3 },
{"TARGET_IE", "SRC_RING_LOW_WATERMARK"                       , 0x00058824, 2 , 2 },
{"TARGET_IE", "SRC_RING_HIGH_WATERMARK"                      , 0x00058824, 1 , 1 },
{"TARGET_IE", "COPY_COMPLETE"                                , 0x00058824, 0 , 0 },
{"TARGET_IS", "DST_RING_LOW_WATERMARK"                       , 0x00058828, 4 , 4 },
{"TARGET_IS", "DST_RING_HIGH_WATERMARK"                      , 0x00058828, 3 , 3 },
{"TARGET_IS", "SRC_RING_LOW_WATERMARK"                       , 0x00058828, 2 , 2 },
{"TARGET_IS", "SRC_RING_HIGH_WATERMARK"                      , 0x00058828, 1 , 1 },
{"TARGET_IS", "COPY_COMPLETE"                                , 0x00058828, 0 , 0 },
{"HOST_IE", "DST_RING_LOW_WATERMARK"                         , 0x0005882c, 4 , 4 },
{"HOST_IE", "DST_RING_HIGH_WATERMARK"                        , 0x0005882c, 3 , 3 },
{"HOST_IE", "SRC_RING_LOW_WATERMARK"                         , 0x0005882c, 2 , 2 },
{"HOST_IE", "SRC_RING_HIGH_WATERMARK"                        , 0x0005882c, 1 , 1 },
{"HOST_IE", "COPY_COMPLETE"                                  , 0x0005882c, 0 , 0 },
{"HOST_IS", "DST_RING_LOW_WATERMARK"                         , 0x00058830, 4 , 4 },
{"HOST_IS", "DST_RING_HIGH_WATERMARK"                        , 0x00058830, 3 , 3 },
{"HOST_IS", "SRC_RING_LOW_WATERMARK"                         , 0x00058830, 2 , 2 },
{"HOST_IS", "SRC_RING_HIGH_WATERMARK"                        , 0x00058830, 1 , 1 },
{"HOST_IS", "COPY_COMPLETE"                                  , 0x00058830, 0 , 0 },
{"MISC_IE", "AXI_ERR"                                        , 0x00058834, 10, 10},
{"MISC_IE", "DST_ADDR_ERR"                                   , 0x00058834, 9 , 9 },
{"MISC_IE", "SRC_LEN_ERR"                                    , 0x00058834, 8 , 8 },
{"MISC_IE", "DST_MAX_LEN_VIO"                                , 0x00058834, 7 , 7 },
{"MISC_IE", "DST_RING_OVERFLOW"                              , 0x00058834, 6 , 6 },
{"MISC_IE", "SRC_RING_OVERFLOW"                              , 0x00058834, 5 , 5 },
{"MISC_IE", "DST_RING_LOW_WATERMARK"                         , 0x00058834, 4 , 4 },
{"MISC_IE", "DST_RING_HIGH_WATERMARK"                        , 0x00058834, 3 , 3 },
{"MISC_IE", "SRC_RING_LOW_WATERMARK"                         , 0x00058834, 2 , 2 },
{"MISC_IE", "SRC_RING_HIGH_WATERMARK"                        , 0x00058834, 1 , 1 },
{"MISC_IE", "COPY_COMPLETE"                                  , 0x00058834, 0 , 0 },
{"MISC_IS", "AXI_ERR"                                        , 0x00058838, 10, 10},
{"MISC_IS", "DST_ADDR_ERR"                                   , 0x00058838, 9 , 9 },
{"MISC_IS", "SRC_LEN_ERR"                                    , 0x00058838, 8 , 8 },
{"MISC_IS", "DST_MAX_LEN_VIO"                                , 0x00058838, 7 , 7 },
{"MISC_IS", "DST_RING_OVERFLOW"                              , 0x00058838, 6 , 6 },
{"MISC_IS", "SRC_RING_OVERFLOW"                              , 0x00058838, 5 , 5 },
{"MISC_IS", "DST_RING_LOW_WATERMARK"                         , 0x00058838, 4 , 4 },
{"MISC_IS", "DST_RING_HIGH_WATERMARK"                        , 0x00058838, 3 , 3 },
{"MISC_IS", "SRC_RING_LOW_WATERMARK"                         , 0x00058838, 2 , 2 },
{"MISC_IS", "SRC_RING_HIGH_WATERMARK"                        , 0x00058838, 1 , 1 },
{"MISC_IS", "COPY_COMPLETE"                                  , 0x00058838, 0 , 0 },
{"SR_WR_INDEX", "V"                                          , 0x0005883c, 15, 0 },
{"DST_WR_INDEX", "V"                                         , 0x00058840, 15, 0 },
{"CURRENT_SRRI", "V"                                         , 0x00058844, 15, 0 },
{"CURRENT_DRRI", "V"                                         , 0x00058848, 15, 0 },
{"SRC_WATERMARK", "LOW"                                      , 0x0005884c, 31, 16},
{"SRC_WATERMARK", "HIGH"                                     , 0x0005884c, 15, 0 },
{"DST_WATERMARK", "LOW"                                      , 0x00058850, 31, 16},
{"DST_WATERMARK", "HIGH"                                     , 0x00058850, 15, 0 },
{"CE_DEBUG", "SEL"                                           , 0x00058854, 5 , 0 },
{"SR_BA", "V"                                                , 0x00058c00, 31, 0 },
{"SR_SIZE", "V"                                              , 0x00058c04, 15, 0 },
{"DR_BA", "V"                                                , 0x00058c08, 31, 0 },
{"DR_SIZE", "V"                                              , 0x00058c0c, 15, 0 },
{"CE_CTRL1", "MSI_EN"                                        , 0x00058c10, 18, 18},
{"CE_CTRL1", "DST_RING_BYTE_SWAP_EN"                         , 0x00058c10, 17, 17},
{"CE_CTRL1", "SRC_RING_BYTE_SWAP_EN"                         , 0x00058c10, 16, 16},
{"CE_CTRL1", "DMAX_LENGTH"                                   , 0x00058c10, 15, 0 },
{"CE_CTRL2", "NUM_AXI_OUTSTANDING_WRITES"                    , 0x00058c14, 29, 25},
{"CE_CTRL2", "NUM_AXI_OUTSTANDING_READS"                     , 0x00058c14, 24, 20},
{"CE_CTRL2", "AXI_TIMEOUT"                                   , 0x00058c14, 19, 4 },
{"CE_CTRL2", "DEST_AXI_MAX_LEN"                              , 0x00058c14, 3 , 2 },
{"CE_CTRL2", "SRC_AXI_MAX_LEN"                               , 0x00058c14, 1 , 0 },
{"CE_CMD", "HALT_STATUS"                                     , 0x00058c18, 3 , 3 },
{"CE_CMD", "DST_FLUSH"                                       , 0x00058c18, 2 , 2 },
{"CE_CMD", "SRC_FLUSH"                                       , 0x00058c18, 1 , 1 },
{"CE_CMD", "HALT"                                            , 0x00058c18, 0 , 0 },
{"MSI_ADDR", "V"                                             , 0x00058c1c, 31, 0 },
{"MSI_DATA", "V"                                             , 0x00058c20, 31, 0 },
{"TARGET_IE", "DST_RING_LOW_WATERMARK"                       , 0x00058c24, 4 , 4 },
{"TARGET_IE", "DST_RING_HIGH_WATERMARK"                      , 0x00058c24, 3 , 3 },
{"TARGET_IE", "SRC_RING_LOW_WATERMARK"                       , 0x00058c24, 2 , 2 },
{"TARGET_IE", "SRC_RING_HIGH_WATERMARK"                      , 0x00058c24, 1 , 1 },
{"TARGET_IE", "COPY_COMPLETE"                                , 0x00058c24, 0 , 0 },
{"TARGET_IS", "DST_RING_LOW_WATERMARK"                       , 0x00058c28, 4 , 4 },
{"TARGET_IS", "DST_RING_HIGH_WATERMARK"                      , 0x00058c28, 3 , 3 },
{"TARGET_IS", "SRC_RING_LOW_WATERMARK"                       , 0x00058c28, 2 , 2 },
{"TARGET_IS", "SRC_RING_HIGH_WATERMARK"                      , 0x00058c28, 1 , 1 },
{"TARGET_IS", "COPY_COMPLETE"                                , 0x00058c28, 0 , 0 },
{"HOST_IE", "DST_RING_LOW_WATERMARK"                         , 0x00058c2c, 4 , 4 },
{"HOST_IE", "DST_RING_HIGH_WATERMARK"                        , 0x00058c2c, 3 , 3 },
{"HOST_IE", "SRC_RING_LOW_WATERMARK"                         , 0x00058c2c, 2 , 2 },
{"HOST_IE", "SRC_RING_HIGH_WATERMARK"                        , 0x00058c2c, 1 , 1 },
{"HOST_IE", "COPY_COMPLETE"                                  , 0x00058c2c, 0 , 0 },
{"HOST_IS", "DST_RING_LOW_WATERMARK"                         , 0x00058c30, 4 , 4 },
{"HOST_IS", "DST_RING_HIGH_WATERMARK"                        , 0x00058c30, 3 , 3 },
{"HOST_IS", "SRC_RING_LOW_WATERMARK"                         , 0x00058c30, 2 , 2 },
{"HOST_IS", "SRC_RING_HIGH_WATERMARK"                        , 0x00058c30, 1 , 1 },
{"HOST_IS", "COPY_COMPLETE"                                  , 0x00058c30, 0 , 0 },
{"MISC_IE", "AXI_ERR"                                        , 0x00058c34, 10, 10},
{"MISC_IE", "DST_ADDR_ERR"                                   , 0x00058c34, 9 , 9 },
{"MISC_IE", "SRC_LEN_ERR"                                    , 0x00058c34, 8 , 8 },
{"MISC_IE", "DST_MAX_LEN_VIO"                                , 0x00058c34, 7 , 7 },
{"MISC_IE", "DST_RING_OVERFLOW"                              , 0x00058c34, 6 , 6 },
{"MISC_IE", "SRC_RING_OVERFLOW"                              , 0x00058c34, 5 , 5 },
{"MISC_IE", "DST_RING_LOW_WATERMARK"                         , 0x00058c34, 4 , 4 },
{"MISC_IE", "DST_RING_HIGH_WATERMARK"                        , 0x00058c34, 3 , 3 },
{"MISC_IE", "SRC_RING_LOW_WATERMARK"                         , 0x00058c34, 2 , 2 },
{"MISC_IE", "SRC_RING_HIGH_WATERMARK"                        , 0x00058c34, 1 , 1 },
{"MISC_IE", "COPY_COMPLETE"                                  , 0x00058c34, 0 , 0 },
{"MISC_IS", "AXI_ERR"                                        , 0x00058c38, 10, 10},
{"MISC_IS", "DST_ADDR_ERR"                                   , 0x00058c38, 9 , 9 },
{"MISC_IS", "SRC_LEN_ERR"                                    , 0x00058c38, 8 , 8 },
{"MISC_IS", "DST_MAX_LEN_VIO"                                , 0x00058c38, 7 , 7 },
{"MISC_IS", "DST_RING_OVERFLOW"                              , 0x00058c38, 6 , 6 },
{"MISC_IS", "SRC_RING_OVERFLOW"                              , 0x00058c38, 5 , 5 },
{"MISC_IS", "DST_RING_LOW_WATERMARK"                         , 0x00058c38, 4 , 4 },
{"MISC_IS", "DST_RING_HIGH_WATERMARK"                        , 0x00058c38, 3 , 3 },
{"MISC_IS", "SRC_RING_LOW_WATERMARK"                         , 0x00058c38, 2 , 2 },
{"MISC_IS", "SRC_RING_HIGH_WATERMARK"                        , 0x00058c38, 1 , 1 },
{"MISC_IS", "COPY_COMPLETE"                                  , 0x00058c38, 0 , 0 },
{"SR_WR_INDEX", "V"                                          , 0x00058c3c, 15, 0 },
{"DST_WR_INDEX", "V"                                         , 0x00058c40, 15, 0 },
{"CURRENT_SRRI", "V"                                         , 0x00058c44, 15, 0 },
{"CURRENT_DRRI", "V"                                         , 0x00058c48, 15, 0 },
{"SRC_WATERMARK", "LOW"                                      , 0x00058c4c, 31, 16},
{"SRC_WATERMARK", "HIGH"                                     , 0x00058c4c, 15, 0 },
{"DST_WATERMARK", "LOW"                                      , 0x00058c50, 31, 16},
{"DST_WATERMARK", "HIGH"                                     , 0x00058c50, 15, 0 },
{"CE_DEBUG", "SEL"                                           , 0x00058c54, 5 , 0 },
{"SR_BA", "V"                                                , 0x00059000, 31, 0 },
{"SR_SIZE", "V"                                              , 0x00059004, 15, 0 },
{"DR_BA", "V"                                                , 0x00059008, 31, 0 },
{"DR_SIZE", "V"                                              , 0x0005900c, 15, 0 },
{"CE_CTRL1", "MSI_EN"                                        , 0x00059010, 18, 18},
{"CE_CTRL1", "DST_RING_BYTE_SWAP_EN"                         , 0x00059010, 17, 17},
{"CE_CTRL1", "SRC_RING_BYTE_SWAP_EN"                         , 0x00059010, 16, 16},
{"CE_CTRL1", "DMAX_LENGTH"                                   , 0x00059010, 15, 0 },
{"CE_CTRL2", "NUM_AXI_OUTSTANDING_WRITES"                    , 0x00059014, 29, 25},
{"CE_CTRL2", "NUM_AXI_OUTSTANDING_READS"                     , 0x00059014, 24, 20},
{"CE_CTRL2", "AXI_TIMEOUT"                                   , 0x00059014, 19, 4 },
{"CE_CTRL2", "DEST_AXI_MAX_LEN"                              , 0x00059014, 3 , 2 },
{"CE_CTRL2", "SRC_AXI_MAX_LEN"                               , 0x00059014, 1 , 0 },
{"CE_CMD", "HALT_STATUS"                                     , 0x00059018, 3 , 3 },
{"CE_CMD", "DST_FLUSH"                                       , 0x00059018, 2 , 2 },
{"CE_CMD", "SRC_FLUSH"                                       , 0x00059018, 1 , 1 },
{"CE_CMD", "HALT"                                            , 0x00059018, 0 , 0 },
{"MSI_ADDR", "V"                                             , 0x0005901c, 31, 0 },
{"MSI_DATA", "V"                                             , 0x00059020, 31, 0 },
{"TARGET_IE", "DST_RING_LOW_WATERMARK"                       , 0x00059024, 4 , 4 },
{"TARGET_IE", "DST_RING_HIGH_WATERMARK"                      , 0x00059024, 3 , 3 },
{"TARGET_IE", "SRC_RING_LOW_WATERMARK"                       , 0x00059024, 2 , 2 },
{"TARGET_IE", "SRC_RING_HIGH_WATERMARK"                      , 0x00059024, 1 , 1 },
{"TARGET_IE", "COPY_COMPLETE"                                , 0x00059024, 0 , 0 },
{"TARGET_IS", "DST_RING_LOW_WATERMARK"                       , 0x00059028, 4 , 4 },
{"TARGET_IS", "DST_RING_HIGH_WATERMARK"                      , 0x00059028, 3 , 3 },
{"TARGET_IS", "SRC_RING_LOW_WATERMARK"                       , 0x00059028, 2 , 2 },
{"TARGET_IS", "SRC_RING_HIGH_WATERMARK"                      , 0x00059028, 1 , 1 },
{"TARGET_IS", "COPY_COMPLETE"                                , 0x00059028, 0 , 0 },
{"HOST_IE", "DST_RING_LOW_WATERMARK"                         , 0x0005902c, 4 , 4 },
{"HOST_IE", "DST_RING_HIGH_WATERMARK"                        , 0x0005902c, 3 , 3 },
{"HOST_IE", "SRC_RING_LOW_WATERMARK"                         , 0x0005902c, 2 , 2 },
{"HOST_IE", "SRC_RING_HIGH_WATERMARK"                        , 0x0005902c, 1 , 1 },
{"HOST_IE", "COPY_COMPLETE"                                  , 0x0005902c, 0 , 0 },
{"HOST_IS", "DST_RING_LOW_WATERMARK"                         , 0x00059030, 4 , 4 },
{"HOST_IS", "DST_RING_HIGH_WATERMARK"                        , 0x00059030, 3 , 3 },
{"HOST_IS", "SRC_RING_LOW_WATERMARK"                         , 0x00059030, 2 , 2 },
{"HOST_IS", "SRC_RING_HIGH_WATERMARK"                        , 0x00059030, 1 , 1 },
{"HOST_IS", "COPY_COMPLETE"                                  , 0x00059030, 0 , 0 },
{"MISC_IE", "AXI_ERR"                                        , 0x00059034, 10, 10},
{"MISC_IE", "DST_ADDR_ERR"                                   , 0x00059034, 9 , 9 },
{"MISC_IE", "SRC_LEN_ERR"                                    , 0x00059034, 8 , 8 },
{"MISC_IE", "DST_MAX_LEN_VIO"                                , 0x00059034, 7 , 7 },
{"MISC_IE", "DST_RING_OVERFLOW"                              , 0x00059034, 6 , 6 },
{"MISC_IE", "SRC_RING_OVERFLOW"                              , 0x00059034, 5 , 5 },
{"MISC_IE", "DST_RING_LOW_WATERMARK"                         , 0x00059034, 4 , 4 },
{"MISC_IE", "DST_RING_HIGH_WATERMARK"                        , 0x00059034, 3 , 3 },
{"MISC_IE", "SRC_RING_LOW_WATERMARK"                         , 0x00059034, 2 , 2 },
{"MISC_IE", "SRC_RING_HIGH_WATERMARK"                        , 0x00059034, 1 , 1 },
{"MISC_IE", "COPY_COMPLETE"                                  , 0x00059034, 0 , 0 },
{"MISC_IS", "AXI_ERR"                                        , 0x00059038, 10, 10},
{"MISC_IS", "DST_ADDR_ERR"                                   , 0x00059038, 9 , 9 },
{"MISC_IS", "SRC_LEN_ERR"                                    , 0x00059038, 8 , 8 },
{"MISC_IS", "DST_MAX_LEN_VIO"                                , 0x00059038, 7 , 7 },
{"MISC_IS", "DST_RING_OVERFLOW"                              , 0x00059038, 6 , 6 },
{"MISC_IS", "SRC_RING_OVERFLOW"                              , 0x00059038, 5 , 5 },
{"MISC_IS", "DST_RING_LOW_WATERMARK"                         , 0x00059038, 4 , 4 },
{"MISC_IS", "DST_RING_HIGH_WATERMARK"                        , 0x00059038, 3 , 3 },
{"MISC_IS", "SRC_RING_LOW_WATERMARK"                         , 0x00059038, 2 , 2 },
{"MISC_IS", "SRC_RING_HIGH_WATERMARK"                        , 0x00059038, 1 , 1 },
{"MISC_IS", "COPY_COMPLETE"                                  , 0x00059038, 0 , 0 },
{"SR_WR_INDEX", "V"                                          , 0x0005903c, 15, 0 },
{"DST_WR_INDEX", "V"                                         , 0x00059040, 15, 0 },
{"CURRENT_SRRI", "V"                                         , 0x00059044, 15, 0 },
{"CURRENT_DRRI", "V"                                         , 0x00059048, 15, 0 },
{"SRC_WATERMARK", "LOW"                                      , 0x0005904c, 31, 16},
{"SRC_WATERMARK", "HIGH"                                     , 0x0005904c, 15, 0 },
{"DST_WATERMARK", "LOW"                                      , 0x00059050, 31, 16},
{"DST_WATERMARK", "HIGH"                                     , 0x00059050, 15, 0 },
{"CE_DEBUG", "SEL"                                           , 0x00059054, 5 , 0 },
{"DBI_WINDOW_reg", "DATA"                                    , 0x00060000, 31, 0 },
{"pcie_phy_pcie_phy_reg_1", "serdes_dis_rximp"               , 0x0006c640, 31, 31},
{"pcie_phy_pcie_phy_reg_1", "serdes_txdr_ctrl"               , 0x0006c640, 30, 29},
{"pcie_phy_pcie_phy_reg_1", "PerstDelay"                     , 0x0006c640, 28, 27},
{"pcie_phy_pcie_phy_reg_1", "ClkObsSel"                      , 0x0006c640, 26, 25},
{"pcie_phy_pcie_phy_reg_1", "DataObsEn"                      , 0x0006c640, 24, 24},
{"pcie_phy_pcie_phy_reg_1", "FuncTestEn"                     , 0x0006c640, 23, 23},
{"pcie_phy_pcie_phy_reg_1", "serdes_disable"                 , 0x0006c640, 22, 22},
{"pcie_phy_pcie_phy_reg_1", "RxClkInv"                       , 0x0006c640, 21, 21},
{"pcie_phy_pcie_phy_reg_1", "FuncTestRxClkInv"               , 0x0006c640, 20, 20},
{"pcie_phy_pcie_phy_reg_1", "FuncTestTxClkInv"               , 0x0006c640, 19, 19},
{"pcie_phy_pcie_phy_reg_1", "EnableClkReq"                   , 0x0006c640, 18, 18},
{"pcie_phy_pcie_phy_reg_1", "ForceLoopBack"                  , 0x0006c640, 17, 17},
{"pcie_phy_pcie_phy_reg_1", "sel_clk"                        , 0x0006c640, 16, 15},
{"pcie_phy_pcie_phy_reg_1", "serdes_rx_eq"                   , 0x0006c640, 14, 14},
{"pcie_phy_pcie_phy_reg_1", "serdes_en_lckdt"                , 0x0006c640, 13, 13},
{"pcie_phy_pcie_phy_reg_1", "serdes_pll_disable_l1"          , 0x0006c640, 12, 12},
{"pcie_phy_pcie_phy_reg_1", "serdes_power_save"              , 0x0006c640, 11, 11},
{"pcie_phy_pcie_phy_reg_1", "serdes_cdr_bw"                  , 0x0006c640, 10, 9 },
{"pcie_phy_pcie_phy_reg_1", "serdes_th_los"                  , 0x0006c640, 8 , 7 },
{"pcie_phy_pcie_phy_reg_1", "serdes_en_deemp"                , 0x0006c640, 6 , 6 },
{"pcie_phy_pcie_phy_reg_1", "serdes_halftxdr"                , 0x0006c640, 5 , 5 },
{"pcie_phy_pcie_phy_reg_1", "serdes_sel_hsp"                 , 0x0006c640, 4 , 4 },
{"pcie_phy_pcie_phy_reg_1", "s"                              , 0x0006c640, 3 , 0 },
{"pcie_phy_pcie_phy_reg_2", "prbs_error_count"               , 0x0006c644, 31, 24},
{"pcie_phy_pcie_phy_reg_2", "sds_sdm_rxelecidle"             , 0x0006c644, 23, 23},
{"pcie_phy_pcie_phy_reg_2", "sds_sdm_rxdetected"             , 0x0006c644, 22, 22},
{"pcie_phy_pcie_phy_reg_2", "prbs_scramble"                  , 0x0006c644, 21, 21},
{"pcie_phy_pcie_phy_reg_2", "prbs_start"                     , 0x0006c644, 20, 20},
{"pcie_phy_pcie_phy_reg_2", "prbs_ts_num"                    , 0x0006c644, 19, 13},
{"pcie_phy_pcie_phy_reg_2", "TxDetRxOvrValue"                , 0x0006c644, 12, 12},
{"pcie_phy_pcie_phy_reg_2", "TxDetRxOvrEn"                   , 0x0006c644, 11, 11},
{"pcie_phy_pcie_phy_reg_2", "DataObsPrbsErr"                 , 0x0006c644, 10, 10},
{"pcie_phy_pcie_phy_reg_2", "CDRReadyTimer"                  , 0x0006c644, 9 , 6 },
{"pcie_phy_pcie_phy_reg_2", "TxDetRxTargetDelay"             , 0x0006c644, 5 , 1 },
{"pcie_phy_pcie_phy_reg_2", "ForceDetect"                    , 0x0006c644, 0 , 0 },
{"pcie_phy_pcie_phy_reg_3", "serdes_reg"                     , 0x0006c648, 20, 16},
{"pcie_phy_pcie_phy_reg_3", "SPARE"                          , 0x0006c648, 15, 11},
{"pcie_phy_pcie_phy_reg_3", "sel_clk100"                     , 0x0006c648, 10, 10},
{"pcie_phy_pcie_phy_reg_3", "en_beacongen"                   , 0x0006c648, 9 , 9 },
{"pcie_phy_pcie_phy_reg_3", "txelecidle"                     , 0x0006c648, 8 , 8 },
{"pcie_phy_pcie_phy_reg_3", "sel_clk"                        , 0x0006c648, 7 , 6 },
{"pcie_phy_pcie_phy_reg_3", "rx_det_req"                     , 0x0006c648, 5 , 5 },
{"pcie_phy_pcie_phy_reg_3", "mode_oclk_in"                   , 0x0006c648, 4 , 4 },
{"pcie_phy_pcie_phy_reg_3", "en_pll"                         , 0x0006c648, 3 , 3 },
{"pcie_phy_pcie_phy_reg_3", "en_lckdt"                       , 0x0006c648, 2 , 2 },
{"pcie_phy_pcie_phy_reg_3", "en_bufs_rx"                     , 0x0006c648, 1 , 1 },
{"pcie_phy_pcie_phy_reg_3", "en"                             , 0x0006c648, 0 , 0 },
{"RTC_STATE", "COLD_RESET"                                   , 0x00080000, 10, 10},
{"RTC_STATE", "XTAL_COUNT"                                   , 0x00080000, 9 , 3 },
{"RTC_STATE", "V"                                            , 0x00080000, 2 , 0 },
{"PCIE_SOC_WAKE", "V"                                        , 0x00080004, 0 , 0 },
{"SOC_GLOBAL_RESET", "V"                                     , 0x00080008, 0 , 0 },
{"PCIE_OBS1", "V"                                            , 0x0008000c, 17, 0 },
{"PCIE_OBS2", "V"                                            , 0x00080010, 17, 0 },
{"PCIE_OBS3", "V"                                            , 0x00080014, 17, 0 },
{"PCIE_OBS4", "V"                                            , 0x00080018, 17, 0 },
{"AXI_SLAVE_RD_OBS", "V"                                     , 0x0008001c, 17, 0 },
{"AXI_SLAVE_WR_OBS", "V"                                     , 0x00080020, 17, 0 },
};

#endif /* _PEREGRINE_REG_MAP_ART_TEMPLATE_H_ */
