/*
 Copyright (c) 2006Qualcomm Atheros, Inc..
 All Rights Reserved.
 Qualcomm Atheros Confidential and Proprietary.
 */

// "ACI $Id: //depot/bringup/ar9k/test_jet/sw/src2/art2_main/src/art2/devlib/ar9300/mEepStruct9300.h#5 $, $Header: //depot/bringup/ar9k/test_jet/sw/src2/art2_main/src/art2/devlib/ar9300/mEepStruct9300.h#5 $"

#ifndef _OSPREY_EEPROM_STRUCT_H_
#define _OSPREY_EEPROM_STRUCT_H_

#ifdef _WINDOWS
#ifdef AR9300DLL
		#define AR9300DLLSPEC __declspec(dllexport)
	#else
		#define AR9300DLLSPEC __declspec(dllimport)
	#endif
#else
	#define AR9300DLLSPEC
#endif



extern AR9300DLLSPEC A_INT32 Ar9300MacAddressGet(unsigned char *mac);
extern AR9300DLLSPEC A_INT32 Ar9300CustomerDataGet(unsigned char *data, int len);
extern AR9300DLLSPEC int Ar9300CalibrationPierSet(int pierIdx, int freq, int chain, 
                          int pwrCorrection, int volt_meas, int temp_meas);
extern AR9300DLLSPEC int Ar9300CalInfoCalibrationPierSet(int pier, int frequency, int chain, 
							int gain, int gainIndex, int dacGain, double power, 
							int correction, int voltage, int temperature, int calPoint);
extern AR9300DLLSPEC int Ar9300CalibrationTxgainCAPSet(int *txgainmax);
extern AR9300DLLSPEC int Ar9300RegulatoryDomainGet(void);
extern AR9300DLLSPEC int Ar9300RegulatoryDomainOverride(unsigned int regdmn);
extern AR9300DLLSPEC int Ar9300NoiseFloorGet(int frequency, int ichain);
extern AR9300DLLSPEC int Ar9300NoiseFloorPowerGet(int frequency, int ichain);
extern AR9300DLLSPEC A_INT32 Ar9300CaldataMemoryTypeGet(A_UCHAR *memType, A_INT32 maxlength);


    const static char *sRatePrintHT[32] = 
	{
		"MCS0 ",
		"MCS1 ", 
		"MCS2 ",
		"MCS3 ",
		"MCS4 ",
		"MCS5 ",
		"MCS6 ",
		"MCS7 ",
		"MCS8 ",
		"MCS9 ",
		"MCS10",
		"MCS11",
		"MCS12",
		"MCS13",
		"MCS14",
		"MCS15",
		"MCS16",
		"MCS17",
		"MCS18",
		"MCS19",
		"MCS20",
		"MCS21",
		"MCS22",
		"MCS23",
        "MCS24",
        "MCS25",
        "MCS26",
        "MCS27",
        "MCS28",
        "MCS29",
        "MCS30",
        "MCS31"
	};


    const static char *sRatePrintLegacy[4] = 
	{
		"6-24",
		" 36 ", 
		" 48 ", 
		" 54 "
	};



    const static char *sRatePrintCck[4] = 
	{
		"1L-5L",
		" 5S  ", 
		" 11L ", 
		" 11S "
	};



    const static char *sDeviceType[] = {
      "UNKNOWN",
      "Cardbus",
      "PCI    ",
      "MiniPCI",
      "AP     ",
      "PCIE   ",
      "UNKNOWN",
      "UNKNOWN",
    };

    const static char *sCtlType[] = {
        "[ 11A base mode ]",
        "[ 11B base mode ]",
        "[ 11G base mode ]",
        "[ INVALID       ]",
        "[ INVALID       ]",
        "[ 2G HT20 mode  ]",
        "[ 5G HT20 mode  ]",
        "[ 2G HT40 mode  ]",
        "[ 5G HT40 mode  ]",
    };


extern int Ar9300FutureGet(int *value, int ix, int *num, int iBand);
extern int Ar9300AntDivCtrlGet(void);
//	extern int Ar9300PaprdTrainningPowerGet(void);
//	extern int Ar9300IqMaskGet(void);
//	extern int Ar9300XtalTargetPpmGet(void);
//	extern int Ar9300XtalTolerancePpmGet(void);
extern int Ar9300ReconfigMiscGet(void);
extern int Ar9300ReconfigDriveStrengthGet(void);
extern int Ar9300ReconfigQuickDropGet(void);
extern int Ar9300Reconfig8TempGet(void);
extern int Ar9300EnableFeatureGet(void);
extern int Ar9300EnableTempCompensationGet(void);
extern int Ar9300EnableVoltCompensationGet(void);
extern int Ar9300EnableFastClockGet(void);
extern int Ar9300EnableDoublingGet(void);
extern int Ar9300InternalRegulatorGet(void);
extern int Ar9300PapdGet(void);
extern int Ar9300EnableTuningCapsGet(void);
extern int Ar9300EnableTxFrameToXpaOnGet(void);
extern int Ar9300PapdRateMaskHt20Get(int iBand);
//	extern int Ar9300PapdRateMask4ssHt20Get(int iBand);
extern int Ar9300PapdRateMaskHt40Get(int iBand);
//	extern int Ar9300PapdRateMask4ssHt40Get(int iBand);
extern int Ar9300WlanSpdtSwitchGlobalControlGet(int iBand);
extern int Ar9300EnableXLNABiasStrengthGet(void);
extern int Ar9300XLANBiasStrengthGet(int *value, int ix, int *num, int iBand);
extern int Ar9300EnableRFGainCAPGet(void);
extern int Ar9300EnableTXGainCAPGet(void);
extern int Ar9300EnableMinCCAPwrThresholdGet(void);
extern int Ar9300RFGainCAPGet(int iBand);
extern int Ar9300TXGainCAPGet(int iBand);

extern int Ar9300_SWREG_Get(void);

extern int Ar9300eepromVersionGet(void);
extern int Ar9300templateVersionGet(void);
extern int Ar9300regDmnGet(int *value, int ix, int *num);
extern int Ar9300txrxMaskGet(void);
extern int Ar9300txMaskGet(void);
extern int Ar9300rxMaskGet(void);
extern int Ar9300opFlagsGet(void);
extern int Ar9300opFlags2Get(void);
extern int Ar9300eepMiscGet(void);
extern int Ar9300rfSilentGet(void);
extern int Ar9300rfSilentB0Get(void);
extern int Ar9300rfSilentB1Get(void);
extern int Ar9300rfSilentGPIOGet(void);
extern int Ar9300blueToothOptionsGet(void);
extern int Ar9300deviceCapGet(void);
extern int Ar9300deviceTypeGet(void);
extern int Ar9300pwrTableOffsetGet(void);
extern int Ar9300pwrTuningCapsParamsGet(int *value, int ix, int *num);
extern int Ar9300TxGainGet(void);
extern int Ar9300RxGainGet(void);

extern int Ar9300TempSlopeGet(int *value, int iBand);
extern int Ar9300TempSlopeLowGet(int *value);
extern int Ar9300TempSlopeHighGet(int *value);
extern int Ar9300TempSlopeExtensionGet(int *value, int ix, int *num);
extern int Ar9300VoltSlopeGet(int iBand);
extern int Ar9300QuickDropGet(int iBand);
extern int Ar9300QuickDropLowGet();
extern int Ar9300QuickDropHighGet();
extern int Ar9300xpaBiasLvlGet(int iBand);
extern int Ar9300txFrameToDataStartGet(int iBand);
extern int Ar9300txFrameToPaOnGet(int iBand);
extern int Ar9300txClipGet(int iBand);
extern int Ar9300dac_scale_cckGet(int iBand);
extern int Ar9300antennaGainGet(int iBand);
extern int Ar9300adcDesiredSizeGet(int iBand);
extern int Ar9300switchSettlingGet(int iBand);
extern int Ar9300txEndToXpaOffGet(int iBand);
extern int Ar9300txEndToRxOnGet(int iBand);
extern int Ar9300txFrameToXpaOnGet(int iBand);
extern int Ar9300thresh62Get(int iBand);

//extern A_INT32 Ar9300CalTgtPwrGet(int *pwrArr, int band, int htMode, int iFreqNum);
//extern A_INT32 Ar9300CalTgtFreqGet(int *freqArr, int band, int htMode);

extern A_INT32 Ar9300calFreqTGTcckGet(int *value, int ix, int iy, int iz, int *num, int iBand);
extern A_INT32 Ar9300calFreqTGTLegacyOFDMGet(int *value, int ix, int iy, int iz, int *num, int iBand);
extern A_INT32 Ar9300calFreqTGTHT20Get(int *value, int ix, int iy, int iz, int *num, int iBand);
extern A_INT32 Ar9300calFreqTGTHT40Get(int *value, int ix, int iy, int iz, int *num, int iBand);
extern A_INT32 Ar9300calTGTPwrCCKGet(double *value, int ix, int iy, int iz, int *num, int iBand);
extern A_INT32 Ar9300calTGTPwrLegacyOFDMGet(double *value, int ix, int iy, int iz, int *num, int iBand);
extern A_INT32 Ar9300calTGTPwrHT20Get(double *value, int ix, int iy, int iz, int *num, int iBand);
extern A_INT32 Ar9300calTGTPwrHT40Get(double *value, int ix, int iy, int iz, int *num, int iBand);

extern A_INT32 Ar9300calFreqPierGet(int *value, int ix, int iy, int iz, int *num, int iBand);
extern A_INT32 Ar9300calPierDataRefPowerGet(int *value, int ix, int iy, int iz, int *num, int iBand);
extern A_INT32 Ar9300calPierDataVoltMeasGet(int *value, int ix, int iy, int iz, int *num, int iBand);
extern A_INT32 Ar9300calPierDataTempMeasGet(int *value, int ix, int iy, int iz, int *num, int iBand);
extern A_INT32 Ar9300calPierDataRxNoisefloorCalGet(int *value, int ix, int iy, int iz, int *num, int iBand);
extern A_INT32 Ar9300calPierDataRxNoisefloorPowerGet(int *value, int ix, int iy, int iz, int *num, int iBand);
extern A_INT32 Ar9300calPierDataRxTempMeasGet(int *value, int ix, int iy, int iz, int *num, int iBand);

extern A_INT32 Ar9300ctlIndexGet(int *value, int ix, int iy, int iz, int *num, int iBand);
extern A_INT32 Ar9300ctlFreqGet(int *value, int ix, int iy, int iz, int *num, int iBand);
extern A_INT32 Ar9300ctlPowerGet(double *value, int ix, int iy, int iz, int *num, int iBand);
extern A_INT32 Ar9300ctlFlagGet(int *value, int ix, int iy, int iz, int *num, int iBand);

extern A_INT32 Ar9300MinCCAPwrThreshChGet(int *value, int ix, int *num, int iBand);
extern A_INT32 Ar9300ObdboffstAux1ChGet(int *value, int ix, int *num, int iBand);
extern A_INT32 Ar9300ObdboffstAux2ChGet(int *value, int ix, int *num, int iBand);
extern A_INT32 Ar9300ReservedGet(int *value, int ix, int *num, int iBand);
extern A_INT32 Ar9300spurChansGet(int *value, int ix, int *num, int iBand);
extern int Ar9300AntCtrlCommonGet(int iBand);
extern int Ar9300AntCtrlCommon2Get(int iBand);
extern A_INT32 Ar9300antCtrlChainGet(int *value, int ix, int *num, int iBand);
extern A_INT32 Ar9300xatten1DBGet(int *value, int ix, int *num, int iBand);
extern A_INT32 Ar9300xatten1MarginGet(int *value, int ix, int *num, int iBand);
extern A_INT32 Ar9300xatten1DBLowGet(int *value, int ix, int *num, int iBand);
extern A_INT32 Ar9300xatten1MarginLowGet(int *value, int ix, int *num, int iBand);
extern A_INT32 Ar9300xatten1DBHighGet(int *value, int ix, int *num, int iBand);
extern A_INT32 Ar9300xatten1MarginHighGet(int *value, int ix, int *num, int iBand);

extern void Ar9300EepromPaPredistortionSet(int value);
extern int Ar9300EepromPaPredistortionGet(void);
extern int Ar9300EepromCalibrationValid(void);

//	extern int Ar9300Aux12LBOffsetGet(void);
//	extern int Ar9300Aux12HBOffsetGet(void);
//	extern int Ar9300NartVersionGet();
//	extern int Ar9300RefFileVersionGet();
//	extern int Ar9300BoardIdGet();

//==============================================================
//
// Jet Function
//
//==============================================================
extern AR9300DLLSPEC A_INT32 Ar5500MacAddressGet(unsigned char *mac);
extern AR9300DLLSPEC A_INT32 Ar5500CustomerDataGet(unsigned char *data, int len);
extern AR9300DLLSPEC int Ar5500CalibrationPierSet(int pierIdx, int freq, int chain, 
                          int pwrCorrection, int volt_meas, int temp_meas);
extern AR9300DLLSPEC int Ar5500CalInfoCalibrationPierSet(int pier, int frequency, int chain, 
							int gain, int gainIndex, int dacGain, double power, 
							int correction, int voltage, int temperature, int calPoint);
extern AR9300DLLSPEC int Ar5500CalibrationTxgainCAPSet(int *txgainmax);
extern AR9300DLLSPEC int Ar5500RegulatoryDomainGet(void);
extern AR9300DLLSPEC int Ar5500RegulatoryDomainOverride(unsigned int regdmn);
extern AR9300DLLSPEC int Ar5500NoiseFloorGet(int frequency, int ichain);
extern AR9300DLLSPEC int Ar5500NoiseFloorPowerGet(int frequency, int ichain);
extern AR9300DLLSPEC A_INT32 Ar5500CaldataMemoryTypeGet(A_UCHAR *memType, A_INT32 maxlength);

extern int Ar5500FutureGet(int *value, int ix, int *num, int iBand);
extern int Ar5500AntDivCtrlGet(void);
extern int Ar5500PaprdTrainningPowerGet(void);
extern int Ar5500IqMaskGet(void);
extern int Ar5500XtalTargetPpmGet(void);
extern int Ar5500XtalTolerancePpmGet(void);
extern int Ar5500ReconfigMiscGet(void);
extern int Ar5500ReconfigDriveStrengthGet(void);
extern int Ar5500ReconfigQuickDropGet(void);
extern int Ar5500Reconfig8TempGet(void);
extern int Ar5500EnableFeatureGet(void);
extern int Ar5500EnableTempCompensationGet(void);
extern int Ar5500EnableVoltCompensationGet(void);
extern int Ar5500EnableFastClockGet(void);
extern int Ar5500EnableDoublingGet(void);
extern int Ar5500InternalRegulatorGet(void);
extern int Ar5500PapdGet(void);
extern int Ar5500EnableTuningCapsGet(void);
extern int Ar5500EnableTxFrameToXpaOnGet(void);
extern int Ar5500PapdRateMaskHt20Get(int iBand);
extern int Ar5500PapdRateMask4ssHt20Get(int iBand);
extern int Ar5500PapdRateMaskHt40Get(int iBand);
extern int Ar5500PapdRateMask4ssHt40Get(int iBand);
extern int Ar5500WlanSpdtSwitchGlobalControlGet(int iBand);
extern int Ar5500EnableXLNABiasStrengthGet(void);
extern int Ar5500XLANBiasStrengthGet(int *value, int ix, int *num, int iBand);
extern int Ar5500EnableRFGainCAPGet(void);
extern int Ar5500EnableTXGainCAPGet(void);
extern int Ar5500EnableMinCCAPwrThresholdGet(void);
extern int Ar5500RFGainCAPGet(int iBand);
extern int Ar5500TXGainCAPGet(int iBand);

extern int Ar5500_SWREG_Get(void);

extern int Ar5500eepromVersionGet(void);
extern int Ar5500templateVersionGet(void);
extern int Ar5500regDmnGet(int *value, int ix, int *num);
extern int Ar5500txrxMaskGet(void);
extern int Ar5500txMaskGet(void);
extern int Ar5500rxMaskGet(void);
extern int Ar5500opFlagsGet(void);
extern int Ar5500opFlags2Get(void);
extern int Ar5500eepMiscGet(void);
extern int Ar5500rfSilentGet(void);
extern int Ar5500rfSilentB0Get(void);
extern int Ar5500rfSilentB1Get(void);
extern int Ar5500rfSilentGPIOGet(void);
extern int Ar5500blueToothOptionsGet(void);
extern int Ar5500deviceCapGet(void);
extern int Ar5500deviceTypeGet(void);
extern int Ar5500pwrTableOffsetGet(void);
extern int Ar5500pwrTuningCapsParamsGet(int *value, int ix, int *num);
extern int Ar5500TxGainGet(void);
extern int Ar5500RxGainGet(void);

extern int Ar5500TempSlopeGet(int *value, int iBand);
extern int Ar5500TempSlopeLowGet(int *value);
extern int Ar5500TempSlopeHighGet(int *value);
extern int Ar5500TempSlopeExtensionGet(int *value, int ix, int *num);
extern int Ar5500VoltSlopeGet(int iBand);
extern int Ar5500QuickDropGet(int iBand);
extern int Ar5500QuickDropLowGet();
extern int Ar5500QuickDropHighGet();
extern int Ar5500xpaBiasLvlGet(int iBand);
extern int Ar5500txFrameToDataStartGet(int iBand);
extern int Ar5500txFrameToPaOnGet(int iBand);
extern int Ar5500txClipGet(int iBand);
extern int Ar5500dac_scale_cckGet(int iBand);
extern int Ar5500antennaGainGet(int iBand);
extern int Ar5500adcDesiredSizeGet(int iBand);
extern int Ar5500switchSettlingGet(int iBand);
extern int Ar5500txEndToXpaOffGet(int iBand);
extern int Ar5500txEndToRxOnGet(int iBand);
extern int Ar5500txFrameToXpaOnGet(int iBand);
extern int Ar5500thresh62Get(int iBand);

//extern A_INT32 Ar5500CalTgtPwrGet(int *pwrArr, int band, int htMode, int iFreqNum);
//extern A_INT32 Ar5500CalTgtFreqGet(int *freqArr, int band, int htMode);

extern A_INT32 Ar5500calFreqTGTcckGet(int *value, int ix, int iy, int iz, int *num, int iBand);
extern A_INT32 Ar5500calFreqTGTLegacyOFDMGet(int *value, int ix, int iy, int iz, int *num, int iBand);
extern A_INT32 Ar5500calFreqTGTHT20Get(int *value, int ix, int iy, int iz, int *num, int iBand);
extern A_INT32 Ar5500calFreqTGTHT40Get(int *value, int ix, int iy, int iz, int *num, int iBand);
extern A_INT32 Ar5500calTGTPwrCCKGet(double *value, int ix, int iy, int iz, int *num, int iBand);
extern A_INT32 Ar5500calTGTPwrLegacyOFDMGet(double *value, int ix, int iy, int iz, int *num, int iBand);
extern A_INT32 Ar5500calTGTPwrHT20Get(double *value, int ix, int iy, int iz, int *num, int iBand);
extern A_INT32 Ar5500calTGTPwrHT40Get(double *value, int ix, int iy, int iz, int *num, int iBand);

extern A_INT32 Ar5500calFreqPierGet(int *value, int ix, int iy, int iz, int *num, int iBand);
extern A_INT32 Ar5500calPierDataRefPowerGet(int *value, int ix, int iy, int iz, int *num, int iBand);
extern A_INT32 Ar5500calPierDataVoltMeasGet(int *value, int ix, int iy, int iz, int *num, int iBand);
extern A_INT32 Ar5500calPierDataTempMeasGet(int *value, int ix, int iy, int iz, int *num, int iBand);
extern A_INT32 Ar5500calPierDataRxNoisefloorCalGet(int *value, int ix, int iy, int iz, int *num, int iBand);
extern A_INT32 Ar5500calPierDataRxNoisefloorPowerGet(int *value, int ix, int iy, int iz, int *num, int iBand);
extern A_INT32 Ar5500calPierDataRxTempMeasGet(int *value, int ix, int iy, int iz, int *num, int iBand);

extern A_INT32 Ar5500ctlIndexGet(int *value, int ix, int iy, int iz, int *num, int iBand);
extern A_INT32 Ar5500ctlFreqGet(int *value, int ix, int iy, int iz, int *num, int iBand);
extern A_INT32 Ar5500ctlPowerGet(double *value, int ix, int iy, int iz, int *num, int iBand);
extern A_INT32 Ar5500ctlFlagGet(int *value, int ix, int iy, int iz, int *num, int iBand);

extern A_INT32 Ar5500MinCCAPwrThreshChGet(int *value, int ix, int *num, int iBand);
extern A_INT32 Ar5500ObdboffstAux1ChGet(int *value, int ix, int *num, int iBand);
extern A_INT32 Ar5500ObdboffstAux2ChGet(int *value, int ix, int *num, int iBand);
extern A_INT32 Ar5500ReservedGet(int *value, int ix, int *num, int iBand);
extern A_INT32 Ar5500spurChansGet(int *value, int ix, int *num, int iBand);
extern int Ar5500AntCtrlCommonGet(int iBand);
extern int Ar5500AntCtrlCommon2Get(int iBand);
extern A_INT32 Ar5500antCtrlChainGet(int *value, int ix, int *num, int iBand);
extern A_INT32 Ar5500xatten1DBGet(int *value, int ix, int *num, int iBand);
extern A_INT32 Ar5500xatten1MarginGet(int *value, int ix, int *num, int iBand);
extern A_INT32 Ar5500xatten1DBLowGet(int *value, int ix, int *num, int iBand);
extern A_INT32 Ar5500xatten1MarginLowGet(int *value, int ix, int *num, int iBand);
extern A_INT32 Ar5500xatten1DBHighGet(int *value, int ix, int *num, int iBand);
extern A_INT32 Ar5500xatten1MarginHighGet(int *value, int ix, int *num, int iBand);

extern void Ar5500EepromPaPredistortionSet(int value);
extern int Ar5500EepromPaPredistortionGet(void);
extern int Ar5500EepromCalibrationValid(void);

extern int Ar5500Aux12LBOffsetGet(void);
extern int Ar5500Aux12HBOffsetGet(void);
extern int Ar5500NartVersionGet();
extern int Ar5500RefFileVersionGet();
extern int Ar5500BoardIdGet();
#endif //_OSPREY_EEPROM_STRUCT_H_
