


#include "ParameterConfigDef.h"
#include "ConfigurationStatus.h"

extern ar9300_eeprom_t *Ar9300EepromStructGet(void);
//	extern A_INT32 Ar9300PaprdTrainningPower(int value);
//	extern A_INT32 Ar9300IqMask(int value);
//	extern A_INT32 Ar9300XtalTargetPpmSet(int value); 
//	extern A_INT32 Ar9300XtalTolerancePpmSet(int value); 
extern A_INT32 Ar9300eepromVersion(int value);
extern A_INT32 Ar9300templateVersion(int value);
extern A_INT32 Ar9300CustomerDataSet(unsigned char *data, A_INT32 len);
extern A_INT32 Ar9300MacAddressSet(unsigned char *mac);
extern A_INT32 Ar9300FutureSet(int *value, int ix, int iy, int iz, int num, int iBand);
extern A_INT32 Ar9300AntDivCtrlSet(int value);
extern A_INT32 Ar9300ReconfigDriveStrengthSet(int value);
extern A_INT32 Ar9300ReconfigQuickDropSet(int value);
extern A_INT32 Ar9300ReconfigTempSlopExtensionSet(int value);
extern A_INT32 Ar9300ThermometerGet(void);
extern A_INT32 Ar9300ThermometerSet(int value);
extern A_INT32 Ar9300ChainMaskReduceGet(void);
extern A_INT32 Ar9300ChainMaskReduceSet(int value);
extern A_INT32 Ar9300TxGainSet(int value);
extern A_INT32 Ar9300RxGainSet(int value);
extern A_INT32 Ar9300EnableTempCompensationSet(int value);
extern A_INT32 Ar9300EnableVoltCompensationSet(int value);
extern A_INT32 Ar9300EnableFastClockSet(int value);
extern A_INT32 Ar9300EnableDoublingSet(int value);
extern A_INT32 Ar9300InternalRegulatorSet(int value);
extern A_INT32 Ar9300PapdSet(int value);
extern A_INT32 Ar9300EnableTuningCapsSet(int value);
extern A_INT32 Ar9300EnableTxFrameToXpaOnSet(int value);
extern A_INT32 Ar9300PapdRateMaskHt20Set(int value, int iBand);
//	extern A_INT32 Ar9300PapdRateMask4ssHt20Set(int value, int iBand);
extern A_INT32 Ar9300PapdRateMaskHt40Set(int value, int iBand);
//	extern A_INT32 Ar9300PapdRateMask4ssHt40Set(int value, int iBand);
extern A_INT32 Ar9300WlanSpdtSwitchGlobalControlSet(int value, int iBand);
extern A_INT32 Ar9300EnableXLNABiasStrengthSet(int value);
extern A_INT32 Ar9300XLANBiasStrengthSet(int *value, int ix, int iy, int iz, int num, int iBand);
extern A_INT32 Ar9300EnableRFGainCAPSet(int value);
extern A_INT32 Ar9300RFGainCAPSet(int value, int iBand);
extern A_INT32 Ar9300EnableTXGainCAPSet(int value);
extern A_INT32 Ar9300TXGainCAPSet(int value, int iBand);
extern A_INT32 Ar9300EnableMinCCAPwrThresholdSet(int value);
extern A_INT32 Ar9300_SWREG_Set(int value);
extern A_INT32 Ar9300_SWREG_PROGRAM_Set(int value);

extern A_INT32 Ar9300AntCtrlCommonSet(int value, int iBand);
extern A_INT32 Ar9300AntCtrlCommon2Set(int value, int iBand);
extern A_INT32 Ar9300TempSlopeSet(int *value, int ix, int iy, int iz,int num, int iBand);
extern A_INT32 Ar9300VoltSlopeSet(int value, int iBand);
extern A_INT32 Ar9300TempSlopeLowSet(int *value, int ix, int iy, int iz);
extern A_INT32 Ar9300TempSlopeHighSet(int *value, int ix, int iy, int iz );
extern A_INT32 Ar9300TempSlopeExtensionSet(int *value, int ix, int iy, int iz, int num, int iBand);
extern A_INT32 Ar9300QuickDropSet(int value, int iBand);
extern A_INT32 Ar9300QuickDropLowSet(int value);
extern A_INT32 Ar9300QuickDropHighSet(int value);
extern A_INT32 Ar9300xpaBiasLvlSet(int value, int iBand);
extern A_INT32 Ar9300txFrameToDataStartSet(int value, int iBand);
extern A_INT32 Ar9300txFrameToPaOnSet(int value, int iBand);
extern A_INT32 Ar9300txClipSet(int value, int iBand);
extern A_INT32 Ar9300dac_scale_cckSet(int value, int iBand);
extern A_INT32 Ar9300antennaGainSet(int value, int iBand);
extern A_INT32 Ar9300adcDesiredSizeSet(int value, int iBand);
extern A_INT32 Ar9300switchSettlingSet(int value, int iBand);
extern A_INT32 Ar9300txEndToXpaOffSet(int value, int iBand);
extern A_INT32 Ar9300txEndToRxOnSet(int value, int iBand);
extern A_INT32 Ar9300txFrameToXpaOnSet(int value, int iBand);
extern A_INT32 Ar9300thresh62Set(int value, int iBand);

extern A_INT32 Ar9300pwrTableOffsetSet(int value);
extern A_INT32 Ar9300pwrTuningCapsParamsSet(int *value, int ix, int iy, int iz, int num, int iBand);

extern A_INT32 Ar9300calFreqTGTcckSet(int *value, int ix, int iy, int iz, int num, int iBand);
extern A_INT32 Ar9300calFreqTGTLegacyOFDMSet(int *value, int ix, int iy, int iz, int num, int iBand);
extern A_INT32 Ar9300calFreqTGTHT20Set(int *value, int ix, int iy, int iz, int num, int iBand);
extern A_INT32 Ar9300calFreqTGTHT40Set(int *value, int ix, int iy, int iz, int num, int iBand);
extern A_INT32 Ar9300calTGTPwrLegacyOFDMSet(double *value, int ix, int iy, int iz, int num, int iBand);
extern A_INT32 Ar9300calTGTPwrCCKSet(double *value, int ix, int iy, int iz, int num, int iBand);
extern A_INT32 Ar9300calTGTPwrHT20Set(double *value, int ix, int iy, int iz, int num, int iBand);
extern A_INT32 Ar9300calTGTPwrHT40Set(double *value, int ix, int iy, int iz, int num, int iBand);

extern A_INT32 Ar9300calFreqPierSet(int *value, int ix, int iy, int iz, int num, int iBand);
extern A_INT32 Ar9300calPierDataRefPowerSet(int *value, int ix, int iy, int iz, int num, int iBand);
extern A_INT32 Ar9300calPierDataVoltMeasSet(int *value, int ix, int iy, int iz, int num, int iBand);
extern A_INT32 Ar9300calPierDataTempMeasSet(int *value, int ix, int iy, int iz, int num, int iBand);
extern A_INT32 Ar9300calPierDataRxNoisefloorCalSet(int *value, int ix, int iy, int iz, int num, int iBand);
extern A_INT32 Ar9300calPierDataRxNoisefloorPowerSet(int *value, int ix, int iy, int iz, int num, int iBand);
extern A_INT32 Ar9300calPierDataRxTempMeaSet(int *value, int ix, int iy, int iz, int num, int iBand);

extern A_INT32 Ar9300ctlIndexSet(int *value, int ix, int iy, int iz, int num, int iBand);
extern A_INT32 Ar9300ctlFreqSet(int *value, int ix, int iy, int iz, int num, int iBand);
extern A_INT32 Ar9300ctlFlagSet(int *value, int ix, int iy, int iz, int num, int iBand);
extern A_INT32 Ar9300ctlPowerSet(double *value, int ix, int iy, int iz, int num, int iBand);

extern int Ar9300EepromWriteEnableGpioSet(int value);
extern int Ar9300EepromWriteEnableGpioGet(void);

extern int Ar9300WlanDisableGpioSet(int value);
extern int Ar9300WlanDisableGpioGet(void);

extern int Ar9300WlanLedGpioSet(int value);
extern int Ar9300WlanLedGpioGet(void);

extern int Ar9300RxBandSelectGpioSet(int value);
extern int Ar9300RxBandSelectGpioGet(void);
extern A_INT32 Ar9300MinCCAPwrThreshChSet(int *value, int ix, int iy, int iz, int num, int iBand);
extern A_INT32 Ar9300ObdboffstAux1Set(int *value, int ix, int iy, int iz, int num, int iBand);
extern A_INT32 Ar9300ObdboffstAux2Set(int *value, int ix, int iy, int iz, int num, int iBand);
extern A_INT32 Ar9300ReservedSet(int *value, int ix, int iy, int iz, int num, int iBand);
extern A_INT32 Ar9300spurChansSet(int *value, int ix, int iy, int iz, int num, int iBand);
extern A_INT32 Ar9300antCtrlChainSet(int *value, int ix, int iy, int iz, int num, int iBand);
extern A_INT32 Ar9300xatten1DBSet(int *value, int ix, int iy, int iz, int num, int iBand);
extern A_INT32 Ar9300xatten1MarginSet(int *value, int ix, int iy, int iz, int num, int iBand);
extern A_INT32 Ar9300xatten1DBLowSet(int *value, int ix, int iy, int iz, int num, int iBand);
extern A_INT32 Ar9300xatten1MarginLowSet(int *value, int ix, int iy, int iz, int num, int iBand);
extern A_INT32 Ar9300xatten1DBHighSet(int *value, int ix, int iy, int iz, int num, int iBand);
extern A_INT32 Ar9300xatten1MarginHighSet(int *value, int ix, int iy, int iz, int num, int iBand);
extern A_INT32 Ar9300regDmnSet(int *value, int ix, int iy, int iz, int num, int iBand);
extern A_INT32 Ar9300txMaskSet(int value);
extern A_INT32 Ar9300rxMaskSet(int value);
extern A_INT32 Ar9300opFlagsSet(int value);
extern A_INT32 Ar9300eepMiscSet(int value);
extern A_INT32 Ar9300rfSilentSet(int value);
extern A_INT32 Ar9300rfSilentB0Set(int value);
extern A_INT32 Ar9300rfSilentB1Set(int value);
extern A_INT32 Ar9300rfSilentGPIOSet(int value);
extern A_INT32 Ar9300deviceCapSet(int value);
extern A_INT32 Ar9300blueToothOptionsSet(int value);
extern A_INT32 Ar9300deviceTypetSet(int value);
//
// returns 0 on success, negative error code on problem
//
extern AR9300DLLSPEC int Ar9300NoiseFloorSet(int frequency, int ichain, int nf);
extern AR9300DLLSPEC int Ar9300NoiseFloorPowerSet(int frequency, int ichain, int nfpower);
extern int Ar9300NoiseFloorTemperatureSet(int frequency, int ichain, int temperature);

extern A_INT32 Ar9300EnableFeatureSet(int value);
extern A_INT32 Ar9300MiscConfigurationSet(int value);
extern A_INT32 Ar9300CaldataMemoryTypeSet(A_UCHAR *memType);

extern A_INT32 Ar9300PsatPowerSet(double *value, int ix, int iy, int iz, int num, int iBand);
extern int Ar9300PsatPowerGet(double *value, int ix, int iy, int iz, int *num, int iBand);
extern int Ar9300PsatDiffGet(double *value, int ix, int iy, int iz, int *num, int iBand);
extern A_INT32 Ar9300PsatDiffSet(double *value, int ix, int iy, int iz, int num, int iBand);

extern A_INT32 Ar9300Aux12LBOffsetSet(int value);
extern A_INT32 Ar9300Aux12HBOffsetSet(int value);
extern A_INT32 Ar9300NartVersionSet(int value);
extern A_INT32 Ar9300RefFileVersionSet(int value);
extern A_INT32 Ar9300BoardIdSet(int value);

//=====================================================================
//
// Jet Function
//
//=====================================================================

extern ar5500_eeprom_t *Ar5500EepromStructGet(void);
extern A_INT32 Ar5500PaprdTrainningPower(int value);
extern A_INT32 Ar5500IqMask(int value);
extern A_INT32 Ar5500XtalTargetPpmSet(int value); 
extern A_INT32 Ar5500XtalTolerancePpmSet(int value); 
extern A_INT32 Ar5500eepromVersion(int value);
extern A_INT32 Ar5500templateVersion(int value);
extern A_INT32 Ar5500CustomerDataSet(unsigned char *data, A_INT32 len);
extern A_INT32 Ar5500MacAddressSet(unsigned char *mac);
extern A_INT32 Ar5500FutureSet(int *value, int ix, int iy, int iz, int num, int iBand);
extern A_INT32 Ar5500AntDivCtrlSet(int value);
extern A_INT32 Ar5500ReconfigDriveStrengthSet(int value);
extern A_INT32 Ar5500ReconfigQuickDropSet(int value);
extern A_INT32 Ar5500ReconfigTempSlopExtensionSet(int value);
extern A_INT32 Ar5500ThermometerGet(void);
extern A_INT32 Ar5500ThermometerSet(int value);
extern A_INT32 Ar5500ChainMaskReduceGet(void);
extern A_INT32 Ar5500ChainMaskReduceSet(int value);
extern A_INT32 Ar5500TxGainSet(int value);
extern A_INT32 Ar5500RxGainSet(int value);
extern A_INT32 Ar5500EnableTempCompensationSet(int value);
extern A_INT32 Ar5500EnableVoltCompensationSet(int value);
extern A_INT32 Ar5500EnableFastClockSet(int value);
extern A_INT32 Ar5500EnableDoublingSet(int value);
extern A_INT32 Ar5500InternalRegulatorSet(int value);
extern A_INT32 Ar5500PapdSet(int value);
extern A_INT32 Ar5500EnableTuningCapsSet(int value);
extern A_INT32 Ar5500EnableTxFrameToXpaOnSet(int value);
extern A_INT32 Ar5500PapdRateMaskHt20Set(int value, int iBand);
extern A_INT32 Ar5500PapdRateMask4ssHt20Set(int value, int iBand);
extern A_INT32 Ar5500PapdRateMaskHt40Set(int value, int iBand);
extern A_INT32 Ar5500PapdRateMask4ssHt40Set(int value, int iBand);
extern A_INT32 Ar5500WlanSpdtSwitchGlobalControlSet(int value, int iBand);
extern A_INT32 Ar5500EnableXLNABiasStrengthSet(int value);
extern A_INT32 Ar5500XLANBiasStrengthSet(int *value, int ix, int iy, int iz, int num, int iBand);
extern A_INT32 Ar5500EnableRFGainCAPSet(int value);
extern A_INT32 Ar5500RFGainCAPSet(int value, int iBand);
extern A_INT32 Ar5500EnableTXGainCAPSet(int value);
extern A_INT32 Ar5500TXGainCAPSet(int value, int iBand);
extern A_INT32 Ar5500EnableMinCCAPwrThresholdSet(int value);
extern A_INT32 Ar5500_SWREG_Set(int value);
extern A_INT32 Ar5500_SWREG_PROGRAM_Set(int value);

extern A_INT32 Ar5500AntCtrlCommonSet(int value, int iBand);
extern A_INT32 Ar5500AntCtrlCommon2Set(int value, int iBand);
extern A_INT32 Ar5500TempSlopeSet(int *value, int ix, int iy, int iz,int num, int iBand);
extern A_INT32 Ar5500VoltSlopeSet(int value, int iBand);
extern A_INT32 Ar5500TempSlopeLowSet(int *value, int ix, int iy, int iz);
extern A_INT32 Ar5500TempSlopeHighSet(int *value, int ix, int iy, int iz );
extern A_INT32 Ar5500TempSlopeExtensionSet(int *value, int ix, int iy, int iz, int num, int iBand);
extern A_INT32 Ar5500QuickDropSet(int value, int iBand);
extern A_INT32 Ar5500QuickDropLowSet(int value);
extern A_INT32 Ar5500QuickDropHighSet(int value);
extern A_INT32 Ar5500xpaBiasLvlSet(int value, int iBand);
extern A_INT32 Ar5500txFrameToDataStartSet(int value, int iBand);
extern A_INT32 Ar5500txFrameToPaOnSet(int value, int iBand);
extern A_INT32 Ar5500txClipSet(int value, int iBand);
extern A_INT32 Ar5500dac_scale_cckSet(int value, int iBand);
extern A_INT32 Ar5500antennaGainSet(int value, int iBand);
extern A_INT32 Ar5500adcDesiredSizeSet(int value, int iBand);
extern A_INT32 Ar5500switchSettlingSet(int value, int iBand);
extern A_INT32 Ar5500txEndToXpaOffSet(int value, int iBand);
extern A_INT32 Ar5500txEndToRxOnSet(int value, int iBand);
extern A_INT32 Ar5500txFrameToXpaOnSet(int value, int iBand);
extern A_INT32 Ar5500thresh62Set(int value, int iBand);

extern A_INT32 Ar5500pwrTableOffsetSet(int value);
extern A_INT32 Ar5500pwrTuningCapsParamsSet(int *value, int ix, int iy, int iz, int num, int iBand);

extern A_INT32 Ar5500calFreqTGTcckSet(int *value, int ix, int iy, int iz, int num, int iBand);
extern A_INT32 Ar5500calFreqTGTLegacyOFDMSet(int *value, int ix, int iy, int iz, int num, int iBand);
extern A_INT32 Ar5500calFreqTGTHT20Set(int *value, int ix, int iy, int iz, int num, int iBand);
extern A_INT32 Ar5500calFreqTGTHT40Set(int *value, int ix, int iy, int iz, int num, int iBand);
extern A_INT32 Ar5500calTGTPwrLegacyOFDMSet(double *value, int ix, int iy, int iz, int num, int iBand);
extern A_INT32 Ar5500calTGTPwrCCKSet(double *value, int ix, int iy, int iz, int num, int iBand);
extern A_INT32 Ar5500calTGTPwrHT20Set(double *value, int ix, int iy, int iz, int num, int iBand);
extern A_INT32 Ar5500calTGTPwrHT40Set(double *value, int ix, int iy, int iz, int num, int iBand);

extern A_INT32 Ar5500calFreqPierSet(int *value, int ix, int iy, int iz, int num, int iBand);
extern A_INT32 Ar5500calPierDataRefPowerSet(int *value, int ix, int iy, int iz, int num, int iBand);
extern A_INT32 Ar5500calPierDataVoltMeasSet(int *value, int ix, int iy, int iz, int num, int iBand);
extern A_INT32 Ar5500calPierDataTempMeasSet(int *value, int ix, int iy, int iz, int num, int iBand);
extern A_INT32 Ar5500calPierDataRxNoisefloorCalSet(int *value, int ix, int iy, int iz, int num, int iBand);
extern A_INT32 Ar5500calPierDataRxNoisefloorPowerSet(int *value, int ix, int iy, int iz, int num, int iBand);
extern A_INT32 Ar5500calPierDataRxTempMeaSet(int *value, int ix, int iy, int iz, int num, int iBand);

extern A_INT32 Ar5500ctlIndexSet(int *value, int ix, int iy, int iz, int num, int iBand);
extern A_INT32 Ar5500ctlFreqSet(int *value, int ix, int iy, int iz, int num, int iBand);
extern A_INT32 Ar5500ctlFlagSet(int *value, int ix, int iy, int iz, int num, int iBand);
extern A_INT32 Ar5500ctlPowerSet(double *value, int ix, int iy, int iz, int num, int iBand);

extern int Ar5500EepromWriteEnableGpioSet(int value);
extern int Ar5500EepromWriteEnableGpioGet(void);

extern int Ar5500WlanDisableGpioSet(int value);
extern int Ar5500WlanDisableGpioGet(void);

extern int Ar5500WlanLedGpioSet(int value);
extern int Ar5500WlanLedGpioGet(void);

extern int Ar5500RxBandSelectGpioSet(int value);
extern int Ar5500RxBandSelectGpioGet(void);
extern A_INT32 Ar5500MinCCAPwrThreshChSet(int *value, int ix, int iy, int iz, int num, int iBand);
extern A_INT32 Ar5500ObdboffstAux1Set(int *value, int ix, int iy, int iz, int num, int iBand);
extern A_INT32 Ar5500ObdboffstAux2Set(int *value, int ix, int iy, int iz, int num, int iBand);
extern A_INT32 Ar5500ReservedSet(int *value, int ix, int iy, int iz, int num, int iBand);
extern A_INT32 Ar5500spurChansSet(int *value, int ix, int iy, int iz, int num, int iBand);
extern A_INT32 Ar5500antCtrlChainSet(int *value, int ix, int iy, int iz, int num, int iBand);
extern A_INT32 Ar5500xatten1DBSet(int *value, int ix, int iy, int iz, int num, int iBand);
extern A_INT32 Ar5500xatten1MarginSet(int *value, int ix, int iy, int iz, int num, int iBand);
extern A_INT32 Ar5500xatten1DBLowSet(int *value, int ix, int iy, int iz, int num, int iBand);
extern A_INT32 Ar5500xatten1MarginLowSet(int *value, int ix, int iy, int iz, int num, int iBand);
extern A_INT32 Ar5500xatten1DBHighSet(int *value, int ix, int iy, int iz, int num, int iBand);
extern A_INT32 Ar5500xatten1MarginHighSet(int *value, int ix, int iy, int iz, int num, int iBand);
extern A_INT32 Ar5500regDmnSet(int *value, int ix, int iy, int iz, int num, int iBand);
extern A_INT32 Ar5500txMaskSet(int value);
extern A_INT32 Ar5500rxMaskSet(int value);
extern A_INT32 Ar5500opFlagsSet(int value);
extern A_INT32 Ar5500eepMiscSet(int value);
extern A_INT32 Ar5500rfSilentSet(int value);
extern A_INT32 Ar5500rfSilentB0Set(int value);
extern A_INT32 Ar5500rfSilentB1Set(int value);
extern A_INT32 Ar5500rfSilentGPIOSet(int value);
extern A_INT32 Ar5500deviceCapSet(int value);
extern A_INT32 Ar5500blueToothOptionsSet(int value);
extern A_INT32 Ar5500deviceTypetSet(int value);
//
// returns 0 on success, negative error code on problem
//
extern AR9300DLLSPEC int Ar5500NoiseFloorSet(int frequency, int ichain, int nf);
extern AR9300DLLSPEC int Ar5500NoiseFloorPowerSet(int frequency, int ichain, int nfpower);
extern int Ar5500NoiseFloorTemperatureSet(int frequency, int ichain, int temperature);

extern A_INT32 Ar5500EnableFeatureSet(int value);
extern A_INT32 Ar5500MiscConfigurationSet(int value);
extern A_INT32 Ar5500CaldataMemoryTypeSet(A_UCHAR *memType);

extern A_INT32 Ar5500PsatPowerSet(double *value, int ix, int iy, int iz, int num, int iBand);
extern int Ar5500PsatPowerGet(double *value, int ix, int iy, int iz, int *num, int iBand);
extern int Ar5500PsatDiffGet(double *value, int ix, int iy, int iz, int *num, int iBand);
extern A_INT32 Ar5500PsatDiffSet(double *value, int ix, int iy, int iz, int num, int iBand);

extern A_INT32 Ar5500Aux12LBOffsetSet(int value);
extern A_INT32 Ar5500Aux12HBOffsetSet(int value);
extern A_INT32 Ar5500NartVersionSet(int value);
extern A_INT32 Ar5500RefFileVersionSet(int value);
extern A_INT32 Ar5500BoardIdSet(int value);

extern bool Ar5500EepromConfigAddrGet(u_int32_t *EepAddr,u_int32_t *value, int *num,u_int32_t *(*NextAddr));
extern bool Ar5500EepromConfigAddrSet(u_int32_t *EepAddr, u_int32_t *value, int num, u_int32_t *NextAddr);
extern A_INT32 Ar5500ConfigAddrSet(int *value, int ix, int iy, int iz, int num, int iBand);
extern A_INT32 Ar5500PwrOffsetHT20Set(double *value, int ix, int iy, int iz, int num, int iBand);
extern A_INT32 Ar5500PwrOffsetHT40Set(double *value, int ix, int iy, int iz, int num, int iBand);
extern A_INT32 Ar5500SpurControlsSet(int value);
extern A_INT32 Ar5500XtalBiasSet(int value);

