#ifdef _WINDOWS
#ifdef ANWIDLL
		#define ANWIDLLSPEC __declspec(dllexport)
	#else
		#define ANWIDLLSPEC __declspec(dllimport)
	#endif
#else
	#define ANWIDLLSPEC
#include "ah_osdep.h"
#ifdef __LINUX_MIPS64_ARCH__
#include <linux/version.h>
#endif
#if LINUX_VERSION_CODE >= KERNEL_VERSION(3,2,0)

#if defined(THIRD_PARTY_INTEL)
#if !defined(__LINUX_MIPS64_ARCH__) && !defined(__LINUX_ARM_ARCH__)&& !defined(__i386__)
typedef unsigned int        uintptr_t;
#endif
#else
#if !defined(__LINUX_MIPS64_ARCH__) && !defined(__LINUX_ARM_ARCH__) /* old */
typedef unsigned int        uintptr_t;
#endif
#endif
#endif
#endif

extern ANWIDLLSPEC int AnwiDriverDetach(void);

//
// Grab the device id from the pci bus
// is there anything else we should check, like an Atheros id?
// how do we get this for other bus types?
//
extern ANWIDLLSPEC int AnwiDriverDeviceIdGet(void);

	
extern ANWIDLLSPEC int AnwiDriverAttach(int devid);

#if defined(THIRD_PARTY_INTEL)
extern ANWIDLLSPEC unsigned int AnwiDriverMemoryMap(void);
#else
extern ANWIDLLSPEC uintptr_t AnwiDriverMemoryMap(void); /* old*/
#endif

extern ANWIDLLSPEC int AnwiDriverMemorySize(void);


#if defined(THIRD_PARTY_INTEL)
extern ANWIDLLSPEC unsigned int AnwiDriverRegisterMap(void);
#else
extern ANWIDLLSPEC uintptr_t AnwiDriverRegisterMap(void); /*old*/
#endif

//
// returns 1 if the Anwi driver is successfully loaded
//
extern ANWIDLLSPEC int AnwiDriverValid(void);


extern ANWIDLLSPEC void MyRegisterDebug(int state);


extern ANWIDLLSPEC int MyRegisterRead(unsigned int address, unsigned int *value);


extern ANWIDLLSPEC int MyRegisterWrite(unsigned int address, unsigned int value);


extern ANWIDLLSPEC unsigned int MaskCreate(int low, int high);


extern ANWIDLLSPEC int MyFieldRead(unsigned int address, int low, int high, unsigned int *value);


extern ANWIDLLSPEC int MyFieldWrite(unsigned int address, int low, int high, unsigned int value);


#if defined(THIRD_PARTY_INTEL)
extern ANWIDLLSPEC unsigned int MyMemoryBase(void);
#else
extern ANWIDLLSPEC uintptr_t MyMemoryBase(void);/*old*/
#endif

extern ANWIDLLSPEC unsigned char *MyMemoryPtr(unsigned int address);


extern ANWIDLLSPEC int MyMemoryRead(unsigned int address, unsigned int *buffer, int many);


extern ANWIDLLSPEC int MyMemoryWrite(unsigned int address, unsigned int *buffer, int many);

