/************************************************************************
Copyright (c) 2015-2016, The Linux Foundation. All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are
met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above
      copyright notice, this list of conditions and the following
      disclaimer in the documentation and/or other materials provided
      with the distribution.
    * Neither the name of The Linux Foundation nor the names of its
      contributors may be used to endorse or promote products derived
      from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESS OR IMPLIED
WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT
ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
************************************************************************/

/**
 * @file datatop_dual_line_poll.h
 * @brief Declares methods held in datatop_dual_line_poll.c
 */

#ifndef DATATOP_DUAL_LINE_POLL_H
#define DATATOP_DUAL_LINE_POLL_H

void dtop_dual_line_init(char *name);
void dtop_single_line_init(char *name);
void dtop_value_only_init(char *name);
void dtop_meminfo_init(void);
void dtop_dev_init(void);
void dtop_stat_init(void);
void dtop_ip_table_init(char *out_dir);
void *dtop_ip_table_start_poll(void * arg);
void dtop_cpu_stats_init(void);
int dtop_value_only_poll(struct dtop_data_point_gatherer *dpg);
void dtop_value_only_dpg_deconstructor
			(struct dtop_data_point_gatherer *dpset);

#endif /* DATATOP_DUAL_LINE_POLL_H */
