#
# Copyright (c) 2017 Qualcomm Technologies, Inc.
# All Rights Reserved.
# Confidential and Proprietary - Qualcomm Technologies, Inc.
#

#
# Copyright (c) 2015, The Linux Foundation. All rights reserved.
#

if [ "$ACTION" = "pressed" -a "$BUTTON" = "wps" ]; then
	if [ -r /var/run/son.conf ] ||
		[ -r /var/run/son_active ]; then
		exit 0
	fi
	[ -r /var/run/wifi-wps-enhc-extn.conf ] || exit 0
	echo "" > /dev/console
	echo "WPS PUSH BUTTON EVENT DETECTED" > /dev/console
	/sbin/led_state_event.sh "WPS_PUSHED"

	num=`grep -w "RADIO" /var/run/wifi-wps-enhc-extn.conf | wc -l`

	if [ -r /var/run/wifi-wps-enhc-extn.pid ]; then
		kill "$(cat "/var/run/wifi-wps-enhc-extn.pid")"
		sleep 1
	fi

	if [ -r /var/run/wifi-wps-enhc-extn.pid ]; then
		rm -f /var/run/wifi-wps-enhc-extn.pid
		exit 0
	fi
	if [ "$METHOD" = "virtual" ]; then
		# Remove Fronthaul VAP from configuration
		fh2_ifname=$(uci -q -P /var/state get wireless.FhAp2.ifname)
		fh5_ifname=$(uci -q -P /var/state get wireless.FhAp5.ifname)
		fh5h_ifname=$(uci -q -P /var/state get wireless.FhAp5h.ifname)

		[ -n "$fh2_ifname" ] && sed "/VAP/ {N;/^VAP\n\(${fh2_ifname}:\)/d}" \
                        /var/run/wifi-wps-enhc-extn.conf > /var/run/wifi-wps-enhc-extn_vpb.conf
		[ -n "$fh5_ifname" ] && sed -i "/VAP/ {N;/^VAP\n\(${fh5_ifname}:\)/d}" \
                        /var/run/wifi-wps-enhc-extn_vpb.conf
		[ -n "$fh5h_ifname" ] && sed -i "/VAP/ {N;/^VAP\n\(${fh5h_ifname}:\)/d}" \
                        /var/run/wifi-wps-enhc-extn_vpb.conf
		wps_enhc_extn_config="/var/run/wifi-wps-enhc-extn_vpb.conf"
		echo "START APP TO HANDLE WPS PUSH VIRTUAL BUTTON EVENT" > /dev/console
	else
		wps_enhc_extn_config="/var/run/wifi-wps-enhc-extn.conf"
		echo "START APP TO HANDLE WPS PUSH BUTTON EVENT" > /dev/console
	fi
	/usr/sbin/wps_enhc -b /var/run/wifi-wps-enhc-extn.pid -n $num \
				-d 128 -l /var/run/wifi-wps-enhc-extn.log \
				-f "$wps_enhc_extn_config"
fi

