: '
/*
 * Copyright (c) 2019 Qualcomm Technologies, Inc.
 *
 * All Rights Reserved.
 * Confidential and Proprietary - Qualcomm Technologies, Inc.
 */
'

#!/bin/ash

GCC_BLSP1_SLEEP_CBCR=0x01801004
GCC_BLSP1_AHB_CBCR=0x01801008
GCC_BLSP1_QUP1_SPI_APPS_CBCR=0x01802004
GCC_BLSP1_QUP1_I2C_APPS_CBCR=0x01802008
GCC_BLSP1_UART1_APPS_CBCR=0x0180203C
GCC_BLSP1_QUP2_SPI_APPS_CBCR=0x0180300C
GCC_BLSP1_QUP2_I2C_APPS_CBCR=0x01803010
GCC_BLSP1_UART2_APPS_CBCR=0x0180302C
GCC_BLSP1_QUP3_SPI_APPS_CBCR=0x0180400C
GCC_BLSP1_QUP3_I2C_APPS_CBCR=0x01804010
GCC_BLSP1_UART3_APPS_CBCR=0x0180402C
GCC_BLSP1_QUP4_SPI_APPS_CBCR=0x0180500C
GCC_BLSP1_QUP4_I2C_APPS_CBCR=0x01805010
GCC_BLSP1_UART4_APPS_CBCR=0x0180502C
GCC_BLSP1_QUP5_SPI_APPS_CBCR=0x0180600C
GCC_BLSP1_QUP5_I2C_APPS_CBCR=0x01806010
GCC_BLSP1_UART5_APPS_CBCR=0x0180602C
GCC_BLSP1_QUP6_SPI_APPS_CBCR=0x0180700C
GCC_BLSP1_QUP6_I2C_APPS_CBCR=0x01807010
GCC_BLSP1_UART6_APPS_CBCR=0x0180702C
GCC_GP1_CBCR=0x01808000
GCC_GP2_CBCR=0x01809000
GCC_GP3_CBCR=0x0180A000
GCC_IMEM_AXI_CBCR=0x0180E004
GCC_IMEM_CFG_AHB_CBCR=0x0180E008
GCC_PCIE0_TBU_CBCR=0x01812014
GCC_APSS_TCU_ASYNC_CBCR=0x01812018
GCC_PCIE1_TBU_CBCR=0x01812024
GCC_WCSS_CORE_TBU_CBCR=0x01812028
GCC_WCSS_Q6_TBU_CBCR=0x0181202C
GCC_PCNOC_TBU_CBCR=0x01812030
GCC_SMMU_CFG_CBCR=0x01812038
GCC_USB0_TBU_CBCR=0x0181203C
GCC_NSS_NOC_TBU_CBCR=0x01812040
GCC_USB1_TBU_CBCR=0x01812090
GCC_PRNG_AHB_CBCR=0x01813004
GCC_BOOT_ROM_AHB_CBCR=0x0181300C
GCC_CRYPTO_CBCR=0x0181601C
GCC_CRYPTO_AXI_CBCR=0x01816020
GCC_CRYPTO_AHB_CBCR=0x01816024
GCC_NOC_CONF_XPU_AHB_CBCR=0x01817000
GCC_RPM_CFG_XPU_CBCR=0x01817004
GCC_PCNOC_MPU_CFG_AHB_CBCR=0x0181700C
GCC_SMMU_XPU_CBCR=0x01817010
GCC_SEC_CTRL_ACC_CBCR=0x0181A020
GCC_SEC_CTRL_AHB_CBCR=0x0181A024
GCC_SEC_CTRL_CBCR=0x0181A028
GCC_SEC_CTRL_SENSE_CBCR=0x0181A02C
GCC_SEC_CTRL_BOOT_ROM_PATCH_CBCR=0x0181A030
GCC_ADSS_PWM_CBCR=0x0181C020
GCC_DDRSS_AHB_CBCR=0x0181D00C
GCC_MEM_NOC_SNOC_AXI_CBCR=0x0181D014
GCC_MEM_NOC_AHB_CBCR=0x0181D01C
GCC_MEM_NOC_APSS_AXI_CBCR=0x0181D020
GCC_DDRSS_4X_CBCR=0x0181D030
GCC_DDRSS_1X_CBCR=0x0181D034
GCC_MEM_NOC_Q6_AXI_CBCR=0x0181D038
GCC_MEM_NOC_NSS_AXI_CBCR=0x0181D03C
GCC_DDRSS_ATB_CBCR=0x0181D040
GCC_MEM_NOC_APSS_TCU_CBCR=0x0181D048
GCC_SYS_NOC_AXI_CBCR=0x01826020
GCC_SYS_NOC_QDSS_STM_AXI_CBCR=0x01826024
GCC_SYS_NOC_APSS_AHB_CBCR=0x01826028
GCC_SNOC_PCNOC_AHB_CBCR=0x0182602C
GCC_SYS_NOC_AT_CBCR=0x01826030
GCC_SYS_NOC_WCSS_AHB_CBCR=0x01826034
GCC_SYS_NOC_USB0_AXI_CBCR=0x01826040
GCC_SYS_NOC_USB1_AXI_CBCR=0x01826044
GCC_SYS_NOC_PCIE0_AXI_CBCR=0x01826048
GCC_SYS_NOC_PCIE1_AXI_CBCR=0x0182604C
GCC_SYS_MM_NOC_TPRB_CBCR=0x01826068
GCC_PCNOC_AHB_CBCR=0x0182701C
GCC_PCNOC_AT_CBCR=0x01827028
GCC_TCSR_AHB_CBCR=0x01828004
GCC_QDSS_DAP_AHB_CBCR=0x01829004
GCC_QDSS_CFG_AHB_CBCR=0x01829008
GCC_QDSS_AT_CBCR=0x01829024
GCC_QDSS_ETR_USB_CBCR=0x01829028
GCC_QDSS_STM_CBCR=0x01829044
GCC_QDSS_TRACECLKIN_CBCR=0x01829060
GCC_QDSS_TSCTR_DIV2_CBCR=0x0182907C
GCC_QDSS_TSCTR_DIV3_CBCR=0x01829080
GCC_QDSS_DAP_CBCR=0x01829084
GCC_QDSS_TSCTR_DIV4_CBCR=0x01829088
GCC_QDSS_TSCTR_DIV8_CBCR=0x0182908C
GCC_QDSS_TSCTR_DIV16_CBCR=0x01829090
GCC_QDSS_APB2JTAG_CBCR=0x01829094
GCC_DCD_XO_CBCR=0x0182A004
GCC_MSG_RAM_AHB_CBCR=0x0182B004
GCC_MPM_AHB_CBCR=0x0182C008
GCC_RPM_PROC_HCLK_CBCR=0x0182D000
GCC_RPM_BUS_AHB_CBCR=0x0182D004
GCC_RPM_SLEEP_CBCR=0x0182D008
GCC_RPM_TIMER_CBCR=0x0182D00C
GCC_RPM_MST_M2_NOC_AHB_CBCR=0x0182D02C
GCC_RPM_NOC_MST_AHB_CBCR=0x0182D030
GCC_SPMI_SER_CBCR=0x0182E01C
GCC_SPMI_PCNOC_AHB_CBCR=0x0182E020
GCC_SPMI_AHB_CBCR=0x0182E03C
GCC_SPDM_CFG_AHB_CBCR=0x0182F004
GCC_SPDM_MSTR_AHB_CBCR=0x0182F008
GCC_SPDM_FF_CBCR=0x0182F00C
GCC_SPDM_SNOC_CY_CBCR=0x0182F014
GCC_SPDM_DEBUG_CY_CBCR=0x0182F018
GCC_SPDM_PCNOC_CY_CBCR=0x0182F01C
GCC_SPDM_RPM_CY_CBCR=0x0182F020
GCC_SPDM_BIMC_DDR_CH0_CY_CBCR=0x0182F054
GCC_GCC_AHB_CBCR=0x01830014
GCC_GCC_XO_CBCR=0x01830030
GCC_GCC_XO_DIV4_CBCR=0x01830034
GCC_GCC_IM_SLEEP_CBCR=0x01830038
GCC_RBCPR_CBCR=0x01833004
GCC_RBCPR_AHB_CBCR=0x01833008
GCC_RBCPR_MX_CBCR=0x01833018
GCC_RBCPR_MX_AHB_CBCR=0x0183301C
GCC_TLMM_AHB_CBCR=0x01834004
GCC_TLMM_CBCR=0x01834008
GCC_RBCPR_WCSS_CBCR=0x0183A004
GCC_RBCPR_WCSS_AHB_CBCR=0x0183A008
GCC_USB0_MASTER_CBCR=0x0183E000
GCC_USB0_SLEEP_CBCR=0x0183E004
GCC_USB0_MOCK_UTMI_CBCR=0x0183E008
GCC_USB0_PIPE_CBCR=0x0183E040
GCC_USB0_AUX_CBCR=0x0183E044
GCC_USB0_PHY_CFG_AHB_CBCR=0x0183E080
GCC_USB1_MASTER_CBCR=0x0183F000
GCC_USB1_SLEEP_CBCR=0x0183F004
GCC_USB1_MOCK_UTMI_CBCR=0x0183F008
GCC_USB1_PIPE_CBCR=0x0183F040
GCC_USB1_AUX_CBCR=0x0183F044
GCC_USB1_PHY_CFG_AHB_CBCR=0x0183F080
GCC_SDCC1_APPS_CBCR=0x01842018
GCC_SDCC1_AHB_CBCR=0x0184201C
GCC_SDCC2_APPS_CBCR=0x01843018
GCC_SDCC2_AHB_CBCR=0x0184301C
GCC_APSS_AHB_CBCR=0x0184601C
GCC_APSS_AXI_CBCR=0x01846020
GCC_SNOC_BUS_TIMEOUT0_AHB_CBCR=0x01847004
GCC_SNOC_BUS_TIMEOUT2_AHB_CBCR=0x0184700C
GCC_SNOC_BUS_TIMEOUT3_AHB_CBCR=0x01847014
GCC_PCNOC_BUS_TIMEOUT0_AHB_CBCR=0x01848004
GCC_PCNOC_BUS_TIMEOUT1_AHB_CBCR=0x0184800C
GCC_PCNOC_BUS_TIMEOUT2_AHB_CBCR=0x01848014
GCC_PCNOC_BUS_TIMEOUT3_AHB_CBCR=0x0184801C
GCC_PCNOC_BUS_TIMEOUT4_AHB_CBCR=0x01848024
GCC_PCNOC_BUS_TIMEOUT5_AHB_CBCR=0x0184802C
GCC_PCNOC_BUS_TIMEOUT6_AHB_CBCR=0x01848034
GCC_PCNOC_BUS_TIMEOUT7_AHB_CBCR=0x0184803C
GCC_PCNOC_BUS_TIMEOUT8_AHB_CBCR=0x01848044
GCC_PCNOC_BUS_TIMEOUT9_AHB_CBCR=0x0184804C
GCC_UNIPHY0_AHB_CBCR=0x01856008
GCC_UNIPHY0_SYS_CBCR=0x0185600C
GCC_UNIPHY0_PORT1_RX_CBCR=0x01856010
GCC_UNIPHY0_PORT1_TX_CBCR=0x01856014
GCC_UNIPHY0_PORT2_RX_CBCR=0x01856018
GCC_UNIPHY0_PORT2_TX_CBCR=0x0185601C
GCC_UNIPHY0_PORT3_RX_CBCR=0x01856020
GCC_UNIPHY0_PORT3_TX_CBCR=0x01856024
GCC_UNIPHY0_PORT4_RX_CBCR=0x01856028
GCC_UNIPHY0_PORT4_TX_CBCR=0x0185602C
GCC_UNIPHY0_PORT5_RX_CBCR=0x01856030
GCC_UNIPHY0_PORT5_TX_CBCR=0x01856034
GCC_UNIPHY1_AHB_CBCR=0x01856108
GCC_UNIPHY1_SYS_CBCR=0x0185610C
GCC_UNIPHY1_PORT5_RX_CBCR=0x01856110
GCC_UNIPHY1_PORT5_TX_CBCR=0x01856114
GCC_UNIPHY2_AHB_CBCR=0x01856208
GCC_UNIPHY2_SYS_CBCR=0x0185620C
GCC_UNIPHY2_PORT6_RX_CBCR=0x01856210
GCC_UNIPHY2_PORT6_TX_CBCR=0x01856214
GCC_CMN_12GPLL_AHB_CBCR=0x01856308
GCC_CMN_12GPLL_SYS_CBCR=0x0185630C
GCC_QPIC_CBCR=0x01857020
GCC_QPIC_AHB_CBCR=0x01857024
GCC_QPIC_SLEEP_CBCR=0x01857028
GCC_MDIO_AHB_CBCR=0x01858004
GCC_WCSS_SLEEP_CBCR=0x01859030
GCC_WCSS_AHB_S_CBCR=0x01859034
GCC_WCSS_ECAHB_CBCR=0x01859038
GCC_WCSS_AXI_M_CBCR=0x0185903C
GCC_WCSS_DBG_IFC_APB_CBCR=0x01859040
GCC_WCSS_DBG_IFC_ATB_CBCR=0x01859044
GCC_WCSS_DBG_IFC_NTS_CBCR=0x01859048
GCC_WCSS_A2AB_CBCR=0x0185904C
GCC_WCSS_DBG_IFC_APB_BDG_CBCR=0x01859050
GCC_WCSS_DBG_IFC_ATB_BDG_CBCR=0x01859054
GCC_WCSS_DBG_IFC_NTS_BDG_CBCR=0x01859058
GCC_WCSS_DBG_IFC_DAPBUS_CBCR=0x0185905C
GCC_WCSS_DBG_IFC_DAPBUS_BDG_CBCR=0x01859060
GCC_WCSS_ACMT_CBCR=0x01859064
GCC_Q6_AHB_CBCR=0x01859138
GCC_Q6_AXIM_CBCR=0x0185913C
GCC_Q6SS_PCLKDBG_CBCR=0x01859140
GCC_Q6SS_ATBM_CBCR=0x01859144
GCC_Q6_TSCTR_1TO2_CBCR=0x01859148
GCC_Q6_AHB_S_CBCR=0x0185914C
GCC_Q6_AXIM2_CBCR=0x01859150
GCC_SDCC1_ICE_CORE_CBCR=0x0185D014
GCC_NSS_CFG_CBCR=0x01868160
GCC_NSS_CRYPTO_CBCR=0x01868164
GCC_NSS_NOC_CBCR=0x01868168
GCC_NSS_PTP_REF_CBCR=0x0186816C
GCC_NSS_CE_AXI_CBCR=0x01868170
GCC_NSS_CE_APB_CBCR=0x01868174
GCC_NSS_IMEM_CBCR=0x01868178
GCC_NSSNOC_QOSGEN_REF_CBCR=0x01868180
GCC_NSSNOC_TIMEOUT_REF_CBCR=0x01868184
GCC_NSSNOC_SNOC_CBCR=0x01868188
GCC_NSSNOC_ATB_CBCR=0x0186818C
GCC_NSS_PPE_CBCR=0x01868190
GCC_NSS_PPE_CFG_CBCR=0x01868194
GCC_NSS_EDMA_CBCR=0x01868198
GCC_NSS_EDMA_CFG_CBCR=0x0186819C
GCC_UBI0_AXI_CBCR=0x01868200
GCC_UBI0_NC_AXI_CBCR=0x01868204
GCC_UBI0_MPT_CBCR=0x01868208
GCC_UBI0_AHB_CBCR=0x0186820C
GCC_UBI0_CORE_CBCR=0x01868210
GCC_UBI0_DBG_CBCR=0x01868214
GCC_UBI1_AXI_CBCR=0x01868220
GCC_UBI1_NC_AXI_CBCR=0x01868224
GCC_UBI1_MPT_CBCR=0x01868228
GCC_UBI1_AHB_CBCR=0x0186822C
GCC_UBI1_CORE_CBCR=0x01868230
GCC_UBI1_DBG_CBCR=0x01868234
GCC_NSS_PORT1_RX_CBCR=0x01868240
GCC_NSS_PORT1_TX_CBCR=0x01868244
GCC_NSS_PORT2_RX_CBCR=0x01868248
GCC_NSS_PORT2_TX_CBCR=0x0186824C
GCC_NSS_PORT3_RX_CBCR=0x01868250
GCC_NSS_PORT3_TX_CBCR=0x01868254
GCC_NSS_PORT4_RX_CBCR=0x01868258
GCC_NSS_PORT4_TX_CBCR=0x0186825C
GCC_NSS_PORT5_RX_CBCR=0x01868260
GCC_NSS_PORT5_TX_CBCR=0x01868264
GCC_NSS_PORT6_RX_CBCR=0x01868268
GCC_NSS_PORT6_TX_CBCR=0x0186826C
GCC_NSSNOC_UBI0_AHB_CBCR=0x01868270
GCC_NSSNOC_UBI1_AHB_CBCR=0x01868274
GCC_NSSNOC_PPE_CBCR=0x01868300
GCC_NSSNOC_PPE_CFG_CBCR=0x01868304
GCC_NSSNOC_CE_AXI_CBCR=0x01868308
GCC_NSSNOC_CE_APB_CBCR=0x0186830C
GCC_CRYPTO_PPE_CBCR=0x01868310
GCC_NSSNOC_CRYPTO_CBCR=0x01868314
GCC_NSS_CSR_CBCR=0x01868318
GCC_PORT1_MAC_CBCR=0x01868320
GCC_PORT2_MAC_CBCR=0x01868324
GCC_PORT3_MAC_CBCR=0x01868328
GCC_PORT4_MAC_CBCR=0x0186832C
GCC_PORT5_MAC_CBCR=0x01868330
GCC_PORT6_MAC_CBCR=0x01868334
GCC_NSS_PPE_IPE_CBCR=0x01868338
GCC_NSS_PPE_BTQ_CBCR=0x0186833C
GCC_PCIE0_AXI_M_CBCR=0x01875008
GCC_PCIE0_AXI_S_CBCR=0x0187500C
GCC_PCIE0_AHB_CBCR=0x01875010
GCC_PCIE0_AUX_CBCR=0x01875014
GCC_PCIE0_PIPE_CBCR=0x01875018
GCC_PCIE1_AXI_M_CBCR=0x01876008
GCC_PCIE1_AXI_S_CBCR=0x0187600C
GCC_PCIE1_AHB_CBCR=0x01876010
GCC_PCIE1_AUX_CBCR=0x01876014
GCC_PCIE1_PIPE_CBCR=0x01876018
GCC_DCC_CBCR=0x01877004
GCC_APC0_VOLTAGE_DROOP_DETECTOR_GPLL0_CBCR=0x01878004
GCC_APC1_VOLTAGE_DROOP_DETECTOR_GPLL0_CBCR=0x01879004
GCC_SMMU_CATS_CBCR=0x0187C004

function calculate_clk(){
GCC_GCC_DEBUG_CLK_CTL=0x01874000
GCC_GCC_XO_DIV4_CBCR=0x01830034
GCC_CLOCK_FRQ_MEASURE_CTL=0x01874004
GCC_CLOCK_FRQ_MEASURE_STATUS=0x01874008
GCC_GCC_XO_CBCR=0x01830030
FREQ_XO_DIV4=4.8
Bit16=65536
Bit20=1048576
Bit25=33554432
Bit31=2147483648
RandomCnt1=67584
RandomCnt2=67618
Constant1pt5=1.5
Constant3pt5=3.5
post_div=12288
multiplier=4
bcalculateclk=0
#Reading user input for clock selection
#echo Provide the Mux selection for DEBUG_CLK_CTL
ClockSel=$2
#echo entered clock $ClockSel
#Select clock mux and write on memory
var1=$(expr "$ClockSel" + "$Bit16" + "$post_div")
devmem $GCC_GCC_DEBUG_CLK_CTL 32 $var1

#echo mux $var1

#Disable Freq Measure control
devmem $GCC_CLOCK_FRQ_MEASURE_CTL 32 0x0

#Write Freq Measure control with random count with Bit20 set
devmem $GCC_CLOCK_FRQ_MEASURE_CTL 32 $(expr "$RandomCnt1" + "$Bit20")

#Read Frq measure status
var1=$(devmem $GCC_CLOCK_FRQ_MEASURE_STATUS)

#echo Freq Measure Status First Cnt : $var1
#Convert the var1 to decimal
var1=$(($var1))
#Check the Bit25 for counter terminates or not
while [ $var1 -le $Bit25 ]
do
var1=$(devmem $GCC_CLOCK_FRQ_MEASURE_STATUS)
#echo Freq Measure Status First Cnt : $var1
#convert the value to decimal
var1=$(($var1))
done

#Get the CBCR Register name
cbcrname=$1
#echo cbcr $cbcrname

cbcrstring=CBCR

cbcrname=${cbcrname/CLK/$cbcrstring}

#Get the Address
eval "cbcraddress=\${$cbcrname}"
#echo cbcraddress $cbcraddress
#print clock name
printf "%s""$1";
#Check for CBCR register is present or not
if [ "$(($cbcraddress))" == 0 ]
then
#No CBCR register is present for this clock, check for register differences
#Disable Freq Measure control
devmem $GCC_CLOCK_FRQ_MEASURE_CTL 32 0x0

#Load again Freq Measure control with next random count with Bit20 set
devmem $GCC_CLOCK_FRQ_MEASURE_CTL 32 $(expr "$RandomCnt2" + "$Bit20")

#Read Frq measure status
var2=$(devmem $GCC_CLOCK_FRQ_MEASURE_STATUS)
#echo Freq Measure Status Second Cnt : $var2
#Convert the var2 to decimal
var2=$(($var2))
#Check the Bit25 for counter terminates or not
while [ $var2 -le $Bit25 ]
do
var2=$(devmem $GCC_CLOCK_FRQ_MEASURE_STATUS)
#echo Freq Measure Status Second Cnt : $var2
#convert the value to decimal
var2=$(($var2))
done

if [ "$var1" == "$var2" ]
then
printf "\t\t\t""OFF \t\tnone";
else
bcalculateclk=1
printf "\t\t\t""ON \t\tnone";
fi

else
#CBCR register is present for this clock, read CBCR register
clkstate=$(devmem $cbcraddress)
#check Clock is enabled or not
if [ "$(($clkstate))" -ge "$Bit31" ]
then
printf "\t\t\t""OFF \t\tcbcr";
else
#Set clock read to ONE
bcalculateclk=1
printf "\t\t\t""ON \t\tcbcr";
fi
fi
if [ "$bcalculateclk" == 1 ]
then
#Eliminate the Bit25 in Frq Measure status
var1=$(expr "$var1" - "$Bit25")

#Measure_CNT+1.5
var2=`echo - | awk '{print "'"$var1"'" + "'"$Constant1pt5"'" }'`

#XO_DIV4_TERM_CNT+3.5
var3=`echo - | awk '{print "'"$RandomCnt1"'" + "'"$Constant3pt5"'" }'`

#Freq(XO_DIV4)*var2/var3
var1=`echo - | awk '{print "'"$FREQ_XO_DIV4"'" *  "'"$var2"'" }'`

var2=`echo - | awk '{print "'"$var1"'" /  "'"$var3"'" }'`
#Apply multiplier
var2=`echo - | awk '{print "'"$var2"'" *  "'"$multiplier"'" }'`
#convert to Hz
var3=`echo - | awk '{print "'"$var2"'" * "'"1000000"'" }'`
printf "\t%12.0f" "$var3";

else
printf "\t----------";
fi
printf "\r\n"

}

inputstr=$1
if [[ "$inputstr" == HELP || "$inputstr" == help ]]
then
echo "Execute the script and grep for desired register string"
exit 0
fi

echo -e "   Clock Name   \t State \t CBCR Type \t Frequency(Hz)"
echo "--------------------------------------------------------------------------"

calculate_clk GCC_SYS_NOC_AXI_CLK 0
calculate_clk GCC_SYS_NOC_USB0_AXI_CLK 1
calculate_clk GCC_SYS_NOC_QDSS_STM_AXI_CLK 2
calculate_clk GCC_SYS_NOC_APSS_AHB_CLK 3
calculate_clk GCC_SNOC_PCNOC_AHB_CLK 4
calculate_clk GCC_SYS_NOC_USB1_AXI_CLK 5
calculate_clk GCC_SYS_NOC_AT_CLK 6
calculate_clk GCC_PCNOC_AHB_CLK 8
calculate_clk GCC_PCNOC_TIC_CLK 11
calculate_clk GCC_PCNOC_AT_CLK 12
calculate_clk GCC_DCC_CLK 13
calculate_clk GCC_GP1_CLK 16
calculate_clk GCC_GP2_CLK 17
calculate_clk GCC_GP3_CLK 18
calculate_clk USB3PHY0_CC_PIPE_CLK 24
calculate_clk USB3PHY_1_CC_PIPE_CLK 25
calculate_clk PCIE20_PHY0_PIPE_CLK 26
calculate_clk GCC_NOC_CONF_XPU_AHB_CLK 27
calculate_clk GCC_APC0_VOLTAGE_DROOP_DETECTOR_GPLL0_CLK 28
calculate_clk MPM_GCC_TEMP_SENSOR_RINGOSC_CLK 29
calculate_clk PCIE20_PHY1_PIPE_CLK 30
calculate_clk GCC_APC1_VOLTAGE_DROOP_DETECTOR_GPLL0_CLK 31
calculate_clk GCC_IMEM_AXI_CLK 32
calculate_clk GCC_IMEM_CFG_AHB_CLK 33
calculate_clk GCC_PCIE0_PIPE_CLK 40
calculate_clk GCC_PCIE0_AHB_CLK 41
calculate_clk GCC_PCIE0_AXI_M_CLK 42
calculate_clk GCC_PCIE0_AXI_S_CLK 43
calculate_clk GCC_PCIE0_AUX_CLK 44
calculate_clk GCC_PCIE1_PIPE_CLK 48
calculate_clk GCC_PCIE1_AHB_CLK 49
calculate_clk GCC_PCIE1_AXI_M_CLK 50
calculate_clk GCC_PCIE1_AXI_S_CLK 51
calculate_clk GCC_PCIE1_AUX_CLK 52
calculate_clk UNIPHY0_GCC_RX_CLK 56
calculate_clk UNIPHY0_GCC_TX_CLK 57
calculate_clk UNIPHY1_GCC_RX_CLK 58
calculate_clk UNIPHY1_GCC_TX_CLK 59
calculate_clk UNIPHY2_GCC_RX_CLK 60
calculate_clk UNIPHY2_GCC_TX_CLK 61
calculate_clk BIAS_PLL_CC_CLK 62
calculate_clk BIAS_PLL_NSS_NOC_CLK 63
calculate_clk GCC_QDSS_DAP_AHB_CLK 64
calculate_clk GCC_QDSS_CFG_AHB_CLK 65
calculate_clk GCC_QDSS_AT_CLK 66
calculate_clk GCC_QDSS_ETR_USB_CLK 67
calculate_clk GCC_QDSS_STM_CLK 68
calculate_clk GCC_QDSS_TRACECLKIN_CLK 69
calculate_clk GCC_QDSS_TSCTR_DIV2_CLK 70
calculate_clk GCC_QDSS_APB2JTAG_CLK 71
calculate_clk GCC_QDSS_TSCTR_DIV3_CLK 72
calculate_clk GCC_QDSS_DAP_CLK 73
calculate_clk GCC_QDSS_TSCTR_DIV4_CLK 74
calculate_clk GCC_QDSS_TSCTR_DIV8_CLK 75
calculate_clk GCC_QDSS_TSCTR_DIV16_CLK 76
calculate_clk GCC_APSS_TCU_ASYNC_CLK 80
calculate_clk GCC_NSS_NOC_TBU_CLK 83
calculate_clk GCC_PCIE0_TBU_CLK 84
calculate_clk GCC_PCIE1_TBU_CLK 85
calculate_clk GCC_WCSS_CORE_TBU_CLK 86
calculate_clk GCC_WCSS_Q6_TBU_CLK 87
calculate_clk GCC_SMMU_XPU_CLK 89
calculate_clk GCC_USB0_TBU_CLK 90
calculate_clk GCC_SMMU_CFG_CLK 91
calculate_clk GCC_USB1_TBU_CLK 92
calculate_clk GCC_PCNOC_TBU_CLK 93
calculate_clk GCC_SMMU_CATS_CLK 95
calculate_clk GCC_USB0_MASTER_CLK 96
calculate_clk GCC_USB0_SLEEP_CLK 97
calculate_clk GCC_USB0_MOCK_UTMI_CLK 98
calculate_clk GCC_USB0_PHY_CFG_AHB_CLK 99
calculate_clk USB0_HSPW_CLK_480M_TEST 100
calculate_clk USB30S_0_UTMI_CLK 101
calculate_clk GCC_USB0_PIPE_CLK 102
calculate_clk GCC_USB0_AUX_CLK 103
calculate_clk GCC_SDCC1_APPS_CLK 104
calculate_clk GCC_SDCC1_AHB_CLK 105
calculate_clk GCC_SDCC1_ICE_CORE_CLK 106
calculate_clk GCC_SDCC2_APPS_CLK 112
calculate_clk GCC_SDCC2_AHB_CLK 113
calculate_clk GCC_BLSP1_AHB_CLK 136
calculate_clk GCC_BLSP1_SLEEP_CLK 137
calculate_clk GCC_BLSP1_QUP1_SPI_APPS_CLK 138
calculate_clk GCC_BLSP1_QUP1_I2C_APPS_CLK 139
calculate_clk GCC_BLSP1_UART1_APPS_CLK 140
calculate_clk GCC_BLSP1_QUP2_SPI_APPS_CLK 142
calculate_clk GCC_BLSP1_QUP2_I2C_APPS_CLK 144
calculate_clk GCC_BLSP1_UART2_APPS_CLK 145
calculate_clk GCC_BLSP1_QUP3_SPI_APPS_CLK 147
calculate_clk GCC_BLSP1_QUP3_I2C_APPS_CLK 148
calculate_clk GCC_BLSP1_UART3_APPS_CLK 149
calculate_clk GCC_BLSP1_QUP4_SPI_APPS_CLK 152
calculate_clk GCC_BLSP1_QUP4_I2C_APPS_CLK 153
calculate_clk GCC_BLSP1_UART4_APPS_CLK 154
calculate_clk GCC_BLSP1_QUP5_SPI_APPS_CLK 156
calculate_clk GCC_BLSP1_QUP5_I2C_APPS_CLK 157
calculate_clk GCC_BLSP1_UART5_APPS_CLK 158
calculate_clk GCC_BLSP1_QUP6_SPI_APPS_CLK 161
calculate_clk GCC_BLSP1_QUP6_I2C_APPS_CLK 162
calculate_clk GCC_BLSP1_UART6_APPS_CLK 163
calculate_clk GCC_UNIPHY0_AHB_CLK 168
calculate_clk GCC_UNIPHY0_SYS_CLK 169
calculate_clk GCC_UNIPHY0_PORT1_RX_CLK 170
calculate_clk GCC_UNIPHY0_PORT1_TX_CLK 171
calculate_clk GCC_UNIPHY0_PORT2_RX_CLK 172
calculate_clk GCC_UNIPHY0_PORT2_TX_CLK 173
calculate_clk GCC_UNIPHY0_PORT3_RX_CLK 174
calculate_clk GCC_UNIPHY0_PORT3_TX_CLK 175
calculate_clk GCC_UNIPHY1_AHB_CLK 176
calculate_clk GCC_UNIPHY1_SYS_CLK 177
calculate_clk GCC_UNIPHY1_PORT5_RX_CLK 178
calculate_clk GCC_UNIPHY1_PORT5_TX_CLK 179
calculate_clk GCC_UNIPHY2_AHB_CLK 184
calculate_clk GCC_UNIPHY2_SYS_CLK 185
calculate_clk GCC_UNIPHY2_PORT6_RX_CLK 186
calculate_clk GCC_UNIPHY2_PORT6_TX_CLK 187
calculate_clk GCC_PCNOC_MPU_CFG_AHB_CLK 193
calculate_clk GCC_Q6_AXIM_CLK 200
calculate_clk GCC_Q6_AXIM2_CLK 201
calculate_clk GCC_Q6_AHB_CLK 202
calculate_clk GCC_Q6_AHB_S_CLK 203
calculate_clk GCC_Q6SS_ATBM_CLK 204
calculate_clk GCC_Q6_TSCTR_1TO2_CLK 205
calculate_clk GCC_Q6SS_PCLKDBG_CLK 206
calculate_clk Q6SS_GCC_DBG_CLK 207
calculate_clk GCC_CMN_12GPLL_AHB_CLK 208
calculate_clk GCC_CMN_12GPLL_SYS_CLK 209
calculate_clk GCC_WCSS_AHB_S_CLK 216
calculate_clk GCC_WCSS_ECAHB_CLK 217
calculate_clk GCC_WCSS_A2AB_CLK 219
calculate_clk GCC_WCSS_ACMT_CLK 220
calculate_clk GCC_WCSS_AXI_M_CLK 221
calculate_clk WCSS_GCC_DBG_CLK 222
calculate_clk WCSS_ZINC_DBG_OUT_CLK 223
calculate_clk GCC_WCSS_DBG_IFC_APB_CLK 224
calculate_clk GCC_WCSS_DBG_IFC_ATB_CLK 225
calculate_clk GCC_WCSS_DBG_IFC_NTS_CLK 226
calculate_clk GCC_WCSS_DBG_IFC_DAPBUS_CLK 227
calculate_clk GCC_WCSS_DBG_IFC_APB_BDG_CLK 228
calculate_clk GCC_WCSS_DBG_IFC_ATB_BDG_CLK 229
calculate_clk GCC_WCSS_DBG_IFC_NTS_BDG_CLK 230
calculate_clk GCC_WCSS_DBG_IFC_DAPBUS_BDG_CLK 231
calculate_clk GCC_TCSR_AHB_CLK 232
calculate_clk GCC_TIC_CLK 233
calculate_clk USB2_PHY_GCC_ATEST_ULPI_0_CLK 234
calculate_clk USB2_PHY_GCC_ATEST_ULPI_1_CLK 235
calculate_clk GCC_PRNG_AHB_CLK 236
calculate_clk GCC_MDIO_AHB_CLK 237
calculate_clk GCC_RPM_CFG_XPU_CLK 238
calculate_clk Q6SS_PLL_DTEST 239
calculate_clk GCC_BOOT_ROM_AHB_CLK 248
calculate_clk GCC_MSG_RAM_AHB_CLK 256
calculate_clk GCC_TLMM_AHB_CLK 264
calculate_clk GCC_TLMM_CLK 265
calculate_clk GCC_MPM_AHB_CLK 272
calculate_clk GCC_RPM_PROC_FCLK 280
calculate_clk GCC_RPM_PROC_HCLK 281
calculate_clk GCC_RPM_BUS_AHB_CLK 282
calculate_clk GCC_RPM_SLEEP_CLK 283
calculate_clk GCC_RPM_TIMER_CLK 284
calculate_clk GCC_RPM_MST_M2_NOC_AHB_CLK 285
calculate_clk GCC_RPM_NOC_MST_AHB_CLK 286
calculate_clk GCC_SEC_CTRL_ACC_CLK 288
calculate_clk GCC_SEC_CTRL_AHB_CLK 289
calculate_clk GCC_SEC_CTRL_CLK 290
calculate_clk GCC_SEC_CTRL_SENSE_CLK 291
calculate_clk GCC_SEC_CTRL_BOOT_ROM_PATCH_CLK 292
calculate_clk GCC_SPMI_SER_CLK 296
calculate_clk GCC_SPMI_PCNOC_AHB_CLK 297
calculate_clk GCC_SPMI_AHB_CLK 298
calculate_clk GCC_SPDM_CFG_AHB_CLK 304
calculate_clk GCC_SPDM_MSTR_AHB_CLK 305
calculate_clk GCC_SPDM_FF_CLK 306
calculate_clk GCC_SPDM_SNOC_CY_CLK 308
calculate_clk GCC_SPDM_PCNOC_CY_CLK 309
calculate_clk GCC_SPDM_RPM_CY_CLK 310
calculate_clk GCC_CRYPTO_CLK 312
calculate_clk GCC_CRYPTO_AXI_CLK 313
calculate_clk GCC_CRYPTO_AHB_CLK 314
calculate_clk GCC_SYS_NOC_PCIE0_AXI_CLK 320
calculate_clk GCC_SYS_NOC_PCIE1_AXI_CLK 321
calculate_clk GCC_SYS_NOC_WCSS_AHB_CLK 322
calculate_clk GCC_SYS_MM_NOC_TPRB_CLK 323
calculate_clk GCC_SNOC_QOSGEN_EXTREF 324
calculate_clk GCC_AHB_CLK 328
calculate_clk GCC_XO_CLK 329
calculate_clk GCC_XO_DIV4_CLK 330
calculate_clk GCC_IM_SLEEP_CLK 331
calculate_clk GCC_MEM_NOC_AHB_CLK 336
calculate_clk GCC_DDRSS_AHB_CLK 337
calculate_clk GCC_MEM_NOC_Q6_AXI_CLK 338
calculate_clk GCC_MEM_NOC_NSS_AXI_CLK 339
calculate_clk GCC_MEM_NOC_SNOC_AXI_CLK 340
calculate_clk GCC_MEM_NOC_APSS_AXI_CLK 341
calculate_clk GCC_MEM_NOC_APSS_TCU_CLK 342
calculate_clk GCC_DDRSS_ATB_CLK 343
calculate_clk GCC_USB1_MASTER_CLK 344
calculate_clk GCC_USB1_SLEEP_CLK 345
calculate_clk GCC_USB1_MOCK_UTMI_CLK 346
calculate_clk GCC_USB1_PHY_CFG_AHB_CLK 347
calculate_clk USB1_HSPW_CLK_480M_TEST 348
calculate_clk USB30S_1_UTMI_CLK 349
calculate_clk GCC_USB1_PIPE_CLK 350
calculate_clk GCC_USB1_AUX_CLK 351
calculate_clk GCC_DDRSS_4X_CLK 352
calculate_clk GCC_DDRSS_1X_CLK 353
calculate_clk GCC_APSS_AHB_CLK 360
calculate_clk GCC_APSS_AXI_CLK 361
calculate_clk APSS_GCC_DBG_CLK 362
calculate_clk GCC_SNOC_BUS_TIMEOUT0_AHB_CLK 368
calculate_clk GCC_SNOC_BUS_TIMEOUT2_AHB_CLK 369
calculate_clk GCC_SNOC_BUS_TIMEOUT3_AHB_CLK 370
calculate_clk GCC_PCNOC_BUS_TIMEOUT0_AHB_CLK 376
calculate_clk GCC_PCNOC_BUS_TIMEOUT1_AHB_CLK 377
calculate_clk GCC_PCNOC_BUS_TIMEOUT2_AHB_CLK 378
calculate_clk GCC_PCNOC_BUS_TIMEOUT3_AHB_CLK 379
calculate_clk GCC_PCNOC_BUS_TIMEOUT4_AHB_CLK 380
calculate_clk GCC_PCNOC_BUS_TIMEOUT5_AHB_CLK 384
calculate_clk GCC_PCNOC_BUS_TIMEOUT6_AHB_CLK 385
calculate_clk GCC_PCNOC_BUS_TIMEOUT7_AHB_CLK 386
calculate_clk GCC_PCNOC_BUS_TIMEOUT8_AHB_CLK 387
calculate_clk GCC_PCNOC_BUS_TIMEOUT9_AHB_CLK 388
calculate_clk GCC_DCD_XO_CLK 392
calculate_clk GCC_RBCPR_CLK 400
calculate_clk GCC_RBCPR_AHB_CLK 401
calculate_clk GCC_RBCPR_MX_CLK 416
calculate_clk GCC_RBCPR_MX_AHB_CLK 417
calculate_clk GCC_RBCPR_WCSS_CLK 418
calculate_clk GCC_RBCPR_WCSS_AHB_CLK 419
calculate_clk GCC_UNIPHY0_PORT4_RX_CLK 420
calculate_clk GCC_UNIPHY0_PORT4_TX_CLK 421
calculate_clk GCC_UNIPHY0_PORT5_RX_CLK 422
calculate_clk GCC_UNIPHY0_PORT5_TX_CLK 423
calculate_clk GCC_ADSS_PWM_CLK 424
calculate_clk GCC_ADSS_AHB_CLK 425
calculate_clk GCC_QPIC_AHB_CLK 432
calculate_clk GCC_QPIC_CLK 433
calculate_clk GCC_QPIC_SLEEP_CLK 434
calculate_clk GPLL0_DTEST 440
calculate_clk GPLL0_LOCK_DET 441
calculate_clk GPLL2_DTEST 442
calculate_clk GPLL2_LOCK_DET 443
calculate_clk DDR_PLL_DTEST 444
calculate_clk DDR_PLL_LOCK_DET 445
calculate_clk AUDIO_PLL_DTEST 446
calculate_clk AUDIO_PLL_LOCK_DET 447
calculate_clk NSS_CRYPTO_PLL_DTEST 448
calculate_clk NSS_CRYPTO_PLL_LOCK_DET 449
calculate_clk GPLL4_DTEST 450
calculate_clk GPLL4_LOCK_DET 451
calculate_clk UBI32_PLL_DTEST 452
calculate_clk UBI32_PLL_LOCK_DET 453
calculate_clk GPLL6_DTEST 454
calculate_clk GPLL6_LOCK_DET 455
calculate_clk GCC_NSS_PORT1_RX_CLK 456
calculate_clk GCC_NSS_PORT1_TX_CLK 457
calculate_clk GCC_NSS_PORT2_RX_CLK 458
calculate_clk GCC_NSS_PORT2_TX_CLK 459
calculate_clk GCC_NSS_PORT3_RX_CLK 460
calculate_clk GCC_NSS_PORT3_TX_CLK 461
calculate_clk GCC_NSS_PORT4_RX_CLK 462
calculate_clk GCC_NSS_PORT4_TX_CLK 463
calculate_clk GCC_NSS_PORT5_RX_CLK 464
calculate_clk GCC_NSS_PORT5_TX_CLK 465
calculate_clk GCC_NSS_PORT6_RX_CLK 466
calculate_clk GCC_NSS_PORT6_TX_CLK 467
calculate_clk GCC_NSS_PPE_CFG_CLK 468
calculate_clk GCC_NSS_EDMA_CLK 469
calculate_clk GCC_NSS_EDMA_CFG_CLK 470
calculate_clk GCC_NSS_PTP_REF_CLK 471
calculate_clk GCC_NSS_PPE_CLK 472
calculate_clk GCC_NSSNOC_PPE_CLK 473
calculate_clk GCC_NSSNOC_PPE_CFG_CLK 474
calculate_clk GCC_CRYPTO_PPE_CLK 475
calculate_clk GCC_PORT1_MAC_CLK 476
calculate_clk GCC_PORT2_MAC_CLK 477
calculate_clk GCC_PORT3_MAC_CLK 478
calculate_clk GCC_PORT4_MAC_CLK 479
calculate_clk GCC_PORT5_MAC_CLK 480
calculate_clk GCC_PORT6_MAC_CLK 481
calculate_clk GCC_NSS_PPE_IPE_CLK 482
calculate_clk GCC_NSS_PPE_BTQ_CLK 483
calculate_clk GCC_UBI0_CORE_CLK 484
calculate_clk GCC_UBI0_MPT_CLK 485
calculate_clk GCC_UBI0_DBG_CLK 486
calculate_clk GCC_UBI0_AXI_CLK 487
calculate_clk GCC_UBI0_NC_AXI_CLK 488
calculate_clk GCC_UBI0_AHB_CLK 489
calculate_clk GCC_UBI1_CORE_CLK 490
calculate_clk GCC_UBI1_MPT_CLK 491
calculate_clk GCC_UBI1_DBG_CLK 492
calculate_clk GCC_UBI1_AXI_CLK 493
calculate_clk GCC_UBI1_NC_AXI_CLK 494
calculate_clk GCC_UBI1_AHB_CLK 495
calculate_clk GCC_NSS_CRYPTO_CLK 496
calculate_clk GCC_NSSNOC_CRYPTO_CLK 497
calculate_clk GCC_NSSNOC_SNOC_CLK 498
calculate_clk GCC_NSSNOC_ATB_CLK 499
calculate_clk GCC_NSSNOC_QOSGEN_REF_CLK 500
calculate_clk GCC_NSSNOC_TIMEOUT_REF_CLK 501
calculate_clk GCC_NSS_NOC_CLK 502
calculate_clk GCC_NSS_CE_AXI_CLK 503
calculate_clk GCC_NSS_CE_APB_CLK 504
calculate_clk GCC_NSSNOC_CE_AXI_CLK 505
calculate_clk GCC_NSSNOC_CE_APB_CLK 506
calculate_clk GCC_NSSNOC_UBI0_AHB_CLK 507
calculate_clk GCC_NSSNOC_UBI1_AHB_CLK 508
calculate_clk GCC_NSS_CSR_CLK 509
calculate_clk GCC_NSS_IMEM_CLK 510
calculate_clk GCC_NSS_CFG_CLK 511
