#!/bin/sh

. /lib/functions.sh
. ../netifd-proto.sh

DHCPNAME="/tmp/dhcp_name.conf"

init_proto "$@"

proto_dhcp_init_config() {
	renew_handler=1

	proto_config_add_string ifname
	proto_config_add_string domain
	proto_config_add_string hostname
	proto_config_add_string peerdns
	proto_config_add_string dns
}

proto_dhcp_setup() {
	local config="$1"
	local iface="$2"

	local ipaddr
	json_get_vars ifname hostname domain peerdns dns
	
	local orbi_type
	json_load "`cat /tmp/cache/systeminfo/sysinfo.info`"
	json_get_var orbi_type "orbi_type"

	local opmode
	local ap_option=""
	local dhcp_script="/lib/netifd/dhcp.script"

	if [ "$(uci get opmode.operate.mode)" = "apmode" ]; then
		ap_option="-a"
		dhcp_script="/lib/netifd/dhcp.script.ap"
	fi
	
	proto_export "INTERFACE=$config"

	if [ "$orbi_type" = "Base" ]; then

		proto_run_command "$config" udhcpc $ap_option -f -i "$iface" \
			-h $DHCPNAME ${ipaddr:+-r $ipaddr} ${domain:+-d $domain} \
			-s $dhcp_script
	else
		dhcp_script="/lib/netifd/dhcp.script.ext"
		proto_run_command "$config" udhcpc-ext $ap_option -f -i "$iface" \
			-h $DHCPNAME ${ipaddr:+-r $ipaddr} ${domain:+-d $domain} \
			-s $dhcp_script
	fi
}

#proto_dhcp_renew() {
#	local interface="$1"
#	# SIGUSR1 forces udhcpc to renew its lease
#	local sigusr1="$(kill -l SIGUSR1)"
#	[ -n "$sigusr1" ] && proto_kill_command "$interface" $sigusr1
#}

proto_dhcp_teardown() {
	local interface="$1"
	proto_kill_command "$interface"
}

add_protocol dhcp
