#!/bin/sh

. /lib/functions.sh
. /usr/share/libubox/jshn.sh
. /lib/netifd/netifd-proto.sh
# [ "$ACTION" = ifup ] || exit 0

#opmode="$(uci get opmode.operate.mode)"
#wan_proto="$(uci get network.wan1.proto)"

json_load "`cat /tmp/cache/network/dhcp.conf`"
json_get_vars ip gateway serverid leasetime
json_load "`cat /tmp/cache/network/network.conf`"
json_get_vars wan_protocol wan_interface wan_network_iface lan_protocol lan_interface lan_iface opmode
json_load "`cat /tmp/cache/systeminfo/ethinfo.info`"
json_get_vars wan_net_section "wan_net_section"
json_get_vars wan_net_if "wan_net_if"

reconfigure_interface_static() {
	ip_static="$(uci get network.${wan_interface}.ipaddr)"
	netmask_static="$(uci get network.${wan_interface}.netmask)"
	gateway_static="$(uci get network.${wan_interface}.gateway)"
	ifconfig $wan_network_iface $ip_static netmask $netmask_static
	route add default gw $gateway_static
	ipconflict $ip_static $netmask_static
}

deconfigure_interface_static(){
	ifconfig $wan_network_iface 0.0.0.0
	gateway_static="$(uci get network.${wan_net_section}.gateway)"
	route del default gw $gateway_static
}

reconfigure_interface() {
	proto_init_update "*" 1
	proto_add_ipv4_address "$ip" "255.255.255.0"
	proto_send_update "$wan_interface"
}

deconfig_interface() {
	proto_init_update "*" 0
	proto_send_update "$wan_interface"
}

linkup_ppp_state() {
	proto_wan1="$(uci get network.${wan_net_section}.proto)"
	if [ "$proto_wan1" = "dhcp" ]; then
		proto_init_update "*" 1
		proto_add_ipv4_address "$ip" "255.255.255.0"
		proto_send_update $wan_net_section
		killall -SIGUSR1 udhcpc
	else
		ifconfig $wan_net_if `uci get network.${wan_net_section}.ipaddr` 
	fi
}

linkdown_ppp_state() {
	proto_wan1="$(uci get network.${wan_net_section}.proto)"
	if [ "$proto_wan1" = "dhcp" ]; then
		proto_init_update "*" 0
		proto_send_update $wan_net_section
	else
		ifconfig $wan_net_if 0.0.0.0
	fi
}

[ "$opmode" = "apmode" ] && exit 0
[ "$PORT_TYPE" = "WAN_PORT" -a "$INIT_EVENT" = "0"  ] || exit 0

case "$wan_protocol" in
	dhcp)
		if [ "$ACTION" = "link_up" ]; then
			reconfigure_interface
			killall -SIGUSR1 udhcpc
		elif [ "$ACTION" = "link_down" ]; then
			deconfig_interface
		fi
		;;
	pptp|l2tp)
		if [ "$ACTION" = "link_up" ]; then
			linkup_ppp_state	
		elif [ "$ACTION" = "link_down" ]; then
			linkdown_ppp_state
		fi
		;;
	static)
		if [ "$ACTION" = "link_up" ]; then
			reconfigure_interface_static
		elif [ "$ACTION" = "link_down" ]; then
			deconfigure_interface_static
		fi
		;;
	*)
		echo "pppoe will have no action" >/dev/console
		;;
esac


