#!/bin/sh /etc/rc.common

. /lib/functions/network.sh
. /usr/share/libubox/jshn.sh

START=80

DHCPCONF_GUEST="/tmp/udhcpd_guest.conf"
PIDFILE_GUEST="/var/run/udhcpd_guest.pid"
LEASEFILE_GUEST="/tmp/udhcpd_guest.leases"

USE_PROCD=1
PROG=/sbin/guest_udhcpd

generate_guest_vlan_udhcpd_conf()
{
	rm -f $DHCPCONF_GUEST
	
	lan_iface="br-guest"

	config_load network
	config_get lan_ip guest ipaddr
	config_get lan_netmask guest netmask

	config_load dhcp
	config_get dhcp_start guest start
	config_get dhcp_limit guest limit
	

	echo "pidfile "$PIDFILE_GUEST >>$DHCPCONF_GUEST
	echo "start "$dhcp_start >>$DHCPCONF_GUEST
	echo "end "$dhcp_limit >>$DHCPCONF_GUEST
	echo "interface "$lan_iface >>$DHCPCONF_GUEST
	echo "remaining yes" >>$DHCPCONF_GUEST
	echo "auto_time 5" >>$DHCPCONF_GUEST
	echo "lease_file "$LEASEFILE_GUEST >>$DHCPCONF_GUEST
	echo "option subnet "$lan_netmask >>$DHCPCONF_GUEST
	echo "option router "$lan_ip >>$DHCPCONF_GUEST
	echo "option dns "$lan_ip >>$DHCPCONF_GUEST
	echo "option lease 1800" >>$DHCPCONF_GUEST

}

service_triggers()
{
	procd_add_reload_trigger "dhcp"
}

start_service() 
{
	dhcp_process=`ps  | grep '/sbin/guest_udhcpd' | grep -v grep | awk '{print $1}'`
	if [ "$dhcp_process" != "" ]; then
		echo "guest udhcp server still running, sleep 2s to check again! " >/dev/console
		sleep 2
		dhcp_process=`ps  | grep '/sbin/guest_udhcpd' | grep -v grep | awk '{print $1}'`
		if [ "$dhcp_process" != "" ]; then
			echo "guest udhcp server still running, kill pid $dhcp_process to start a new!" >/dev/console
			kill -9 $dhcp_process
			stop_service
		fi
	fi


	json_load "`cat /tmp/cache/systeminfo/sysinfo.info`"
	json_get_var orbi_type "orbi_type"
	
	json_load "`cat /tmp/cache/systeminfo/dgc_data.info`"
	json_get_var guest_vlan "dgc_func_have_guest_vlan"

	json_load "`cat /tmp/cache/network/network.conf`"
	json_get_var opmode "opmode"

	[ "$orbi_type" = "Base" ] || exit 0

	if [ "$guest_vlan" = "1" ]; then
		echo "guest vlan udhcp server start " >/dev/console
		generate_guest_vlan_udhcpd_conf
		procd_open_instance
		procd_set_param command $PROG $DHCPCONF_GUEST
		procd_set_param respawn
		procd_close_instance

	fi
}

stop_service()
{
	echo "guest udhcp server stop " >/dev/console
}

