#!/bin/sh /etc/rc.common

. /lib/functions/network.sh
. /usr/share/libubox/jshn.sh

START=80

DHCPNAME="/tmp/dhcp_name.conf"
DHCPCONF="/tmp/udhcpd.conf"
PIDFILE="/var/run/udhcpd.pid"
LEASEFILE="/tmp/udhcpd.leases"

USE_PROCD=1
PROG=/sbin/udhcpd

generate_udhcpd_conf()
{
	local n=0

	rm -f $DHCPCONF
	json_load "`cat /tmp/cache/network/network.conf`"
	json_get_var lan_iface "lan_iface"
	
	config_load network
	config_get lan_ip lan ipaddr
	config_get lan_netmask lan netmask

	config_load dhcp
	config_get dhcp_start lan start
	config_get dhcp_limit lan limit
	config_get dhcp_lease lan leasetime
	

	echo "pidfile "$PIDFILE >>$DHCPCONF
	echo "start "$dhcp_start >>$DHCPCONF
	echo "end "$dhcp_limit >>$DHCPCONF
	echo "interface "$lan_iface >>$DHCPCONF
	echo "remaining yes" >>$DHCPCONF
	echo "auto_time 5" >>$DHCPCONF
	echo "lease_file "$LEASEFILE >>$DHCPCONF
	echo "option subnet "$lan_netmask >>$DHCPCONF
	echo "option router "$lan_ip >>$DHCPCONF
	echo "option dns "$lan_ip >>$DHCPCONF
	echo "option lease "$dhcp_lease >>$DHCPCONF

	while : ; do
		static_lease="$(uci get dhcp.host_$n)"
		if [ "x$static_lease" = "x" ]; then
			break
		fi
		lease_ip="$(uci get dhcp.host_$n.ip)"
		lease_mac="$(uci get dhcp.host_$n.mac)"
		lease_name="$(uci get dhcp.host_$n.name)"
		echo "static_lease $lease_ip $lease_mac $lease_name" >>$DHCPCONF
		n=$(($n + 1))
	done

}

service_triggers()
{
	procd_add_reload_trigger "dhcp"
}

start_service() 
{
	dhcp_process=`ps  | grep '/sbin/udhcpd' | grep -v grep | awk '{print $1}'`
	if [ "$dhcp_process" != "" ]; then
		echo "udhcp server still running, sleep 2s to check again! " >/dev/console
		sleep 2
		dhcp_process=`ps  | grep '/sbin/udhcpd' | grep -v grep | awk '{print $1}'`
		if [ "$dhcp_process" != "" ]; then
			echo "udhcp server still running, kill pid $dhcp_process to start a new!" >/dev/console
			kill -9 $dhcp_process
			stop_service
		fi
	fi

	json_load "`cat /tmp/cache/systeminfo/sysinfo.info`"
	json_get_var orbi_type "orbi_type"

	json_load "`cat /tmp/cache/network/network.conf`"
	json_get_var opmode "opmode"

	[ "$orbi_type" = "Base" ] || exit 0

	if [ "$(uci get dhcp.lan.ignore)" != "1" ]; then
		echo "udhcp server start " >/dev/console
		generate_udhcpd_conf
	
		procd_open_instance
		procd_set_param command $PROG $DHCPCONF
		procd_set_param respawn
		procd_close_instance
	fi

}

stop_service()
{
	echo "udhcp server stop " >/dev/console
}


