#!/bin/sh

[ -x /usr/sbin/ppp-nas ] || exit 0
[ -x /usr/sbin/pppd ] || exit 0

[ -n "$INCLUDE_ONLY" ] || {
	. /lib/functions.sh
	. /lib/functions/network.sh
	. ../netifd-proto.sh
	init_proto "$@"
}

proto_mulpppoe_init_config()
{
	proto_config_add_string ifname
	proto_config_add_string session
	proto_config_add_string username
	proto_config_add_string password
	proto_config_add_string service
	proto_config_add_int connmode
	proto_config_add_int demand
	proto_config_add_string ipaddr
	proto_config_add_boolean peerdns
	proto_config_add_string dns
	proto_config_add_int mtu
	proto_config_add_int run_test
	lasterror=1
}

print_primary_options()
{
cat <<EOF
$1
$2
lcp-echo-interval 20
lcp-echo-failure 6
$3 
defaultroute
ip-up-script $4
ip-down-script $5
no-replace-dns
noipdefault
hide-password
noauth
$6
mru $7
mtu $7
noaccomp
default-asyncmap
plugin rp-pppoe.so $8
$9
user $10
unit 0
$11
EOF
}

print_second_options()
{
cat <<EOF
$1
nodefaultroute
persist
lcp-echo-interval 20
lcp-echo-failure 6
ip-up-script $2
ip-down-script $3
pap-file /etc/ppp/pap1-secrets
chap-file /etc/ppp/chap1-secrets
no-replace-dns
noipdefault
hide-password
noauth
$4
mru $5
mtu $5
noaccomp
default-asyncmap
plugin rp-pppoe.so $6
$7
user $8
unit 1
EOF
}

print_secret()
{
	if [ "$1" = "session1" ]; then
		echo "$2	*	$3	*" > /etc/ppp/pap-secrets
		echo "$2	*	$3	*" > /etc/ppp/chap-secrets
	elif [ "$1" = "session2" ]; then
		echo "$2	*	$3	*" > /etc/ppp/pap1-secrets
		echo "$2	*	$3	*" > /etc/ppp/chap1-secrets
	fi
}

proto_mulpppoe_setup()
{
	local config="$1"
	local iface="$2"
	local load idle remotename 
	local dod_test=

	S1_IPUP_SCRIPT="/etc/ppp/pppoe1-ip-up"
	S1_IPDOWN_SCRIPT="/etc/ppp/pppoe1-ip-down"
	S2_IPUP_SCRIPT="/etc/ppp/pppoe2-ip-up"
	S2_IPDOWN_SCRIPT="/etc/ppp/pppoe2-ip-down"

    mknod /dev/ppp c 108 0
    mkdir -p /tmp/ppp
    mkdir -p /etc/ppp/peers

	for module in slhc ppp_generic pppox pppoe; do
		/sbin/insmod $module 2>&- >&-
	done
	[ "$load" = "1" ] && sleep 1

	json_get_vars ifname session username password service ipaddr peerdns dns mtu run_test

	[ "$peerdns" = "1" ] && peerdns="usepeerdns" || peerdns=""
	[ -n "$service" ] && remotename="remotename $service" || remotename=""
	[ -n "$ipaddr" ] && ipaddr="$ipaddr:"

	if [ "$session" = "session1" ]; then
		json_get_vars connmode demand

		if [ "$connmode" = "1" ]; then
			if [ "$demand" = "0" ]; then
				connmode="persist"
			else
				idle="idle $demand"
				connmode="demand"
				[ "$run_test" = "1" ] && dod_test="test"
			fi
		elif [ "$connmode" = "2" ]; then
			connmode="runone"
			proto_block_restart "$config"
		else
			connmode="persist"
		fi

		print_primary_options "$idle" "$connmode" "$remotename" "$S1_IPUP_SCRIPT" "$S1_IPDOWN_SCRIPT" "$peerdns" "$mtu" "$ifname" "$ipaddr" "$username" "$dod_test" > /etc/ppp/peers/pppoe-session1
		print_secret $session $username $password
		ppp-nas pppoe-session1 start

	elif [ "$session" = "session2" ]; then
		touch /etc/ppp/enable_ppp1

		print_second_options "$remotename" "$S2_IPUP_SCRIPT" "$S2_IPDOWN_SCRIPT" "$peerdns" "$mtu" "$ifname" "$ipaddr" "$username" > /etc/ppp/peers/pppoe-session2
		print_secret $session $username $password 
		ppp-nas pppoe-session2 start
	fi

}

proto_mulpppoe_teardown()
{
	json_get_var session "session"
	if [ "$session" = "session1" ]; then
		ppp-nas pppoe-session1 stop
	elif [ "$session" = "session2" ]; then
		[ -f /etc/ppp/pppoe2-domain.conf ] && rm /etc/ppp/pppoe2-domain.conf
		[ -f /etc/ppp/enable_ppp1 ] && rm /etc/ppp/enable_ppp1
		ppp-nas pppoe-session2 stop
	fi
}

[ -n "$INCLUDE_ONLY" ] || {
	[ -f /usr/lib/pppd/*/rp-pppoe.so ] && add_protocol mulpppoe
}

