#!/bin/sh

. /lib/functions.sh
. ../netifd-proto.sh
init_proto "$@"

interface_info=`cat /tmp/cache/systeminfo/ethinfo.info`
json_load "$interface_info"
json_get_var v4waniface wan_net_if

dhcp6c_write_config() {
	local wan6_ifname=$1
	local wan6_type=$2
	local dhcp6c_script=$3

	printf 'interface %s {\n' "$wan6_ifname"
	if [ "$wan6_type" = "dhcpv6" -o "$wan6_type" = "pppoe" ]; then
		printf '\tsend ia-na 1;\n'
	fi
	printf '\tsend ia-pd 11;\n'
	printf '\trequest domain-name;\n'
	printf '\trequest domain-name-servers;\n'
	printf '\trequest ntp-servers;\n'
	printf '\trequest sip-server-domain-name;\n'
	printf '\trequest sip-server-address;\n'
	printf '\tscript "%s";\n' "$dhcp6c_script"
	printf '};\n'
	printf '\n'
	if [ "$wan6_type" = "dhcpv6" -o "$wan6_type" = "pppoe" ]; then
		printf 'id-assoc na 1 {\n'
		printf '};\n'
	fi
	printf 'id-assoc pd 11 {\n'
	printf '};\n'
}

proto_dhcpv6_init_config() {
	renew_handler=1

	proto_config_add_string "userclass"
	proto_config_add_string "domain_name"
	proto_config_add_string "ipv6_type"
	proto_config_add_string "dhcp6cscript"
}

proto_dhcpv6_setup() {
	local config="$1"
	local iface="$2"
	local dhcp6c_conf="/etc/dhcp6c.conf"

	local userclass ipv6_type dhcp6cscript domain_name

	json_get_vars userclass ipv6_type dhcp6cscript domain_name


	# Configure
	local opts=""

	script="${dhcp6cscript:-/lib/netifd/dhcpv6.script}"

	[ -n "$userclass" ] && append opts "-u $userclass"
	[ -n "$domain_name" ] && append opts "-U $domain_name"

	#For pppoe mode,we need to ifentify the harware interface to let dhcpv6 create duid
	[ "$ipv6_type" = "pppoe" ] && append opts "-h ${v4waniface}"
	#Netifd need the daemon to running in foreground to get the status
	append opts "-3 -f"


	dhcp6c_write_config $iface "$ipv6_type" "$script" > $dhcp6c_conf

	if [ "$ipv6_type" = "dhcpv6" ]; then	
		sysctl -w net.ipv6.conf."$iface".forwarding=1
	elif [ "$ipv6_type" = "autoconfig" -o "$ipv6_type" = "pppoe" ]; then
		sysctl -w net.ipv6.conf."$iface".forwarding=0
		rs_send -i $iface -c 3 -t 4 &
	fi

	proto_run_command "$config" dhcp6c \
		-c $dhcp6c_conf \
		$opts $iface

}

proto_dhcpv6_renew() {
	local interface="$1"
	# SIGUSR1 forces dhcp6c to renew its lease
	local sigusr1="$(kill -l SIGUSR1)"
	[ -n "$sigusr1" ] && proto_kill_command "$interface" $sigusr1
}

proto_dhcpv6_teardown() {
	local interface="$1"
	local iface="$2"

	#For AutoConfig mode,we need to toggle the proc disable_ipv6 to clean the ip6addr and default route from RA
	sysctl -w net.ipv6.conf."$iface".forwarding=1
	sysctl -w net.ipv6.conf."$iface".disable_ipv6=1
	sysctl -w net.ipv6.conf."$iface".disable_ipv6=0

	proto_kill_command "$interface"
	/lib/netifd/dhcpv6.script teardown
}

add_protocol dhcpv6

