#!/bin/sh

#check base
is_base=`uci get wireless.BhSta2.device`
if [ ! -z "$is_base" ]; then
        echo "Device is not base $is_base !" >> /dev/console
        exit 0
fi

#check AP mode
mode=`uci get network.wan.type`
if [ -z "$mode"  ]; then
        echo "Device is in ap mode" >> /dev/console
        exit 0
fi

#check for PR SKU
. /tmp/product_data
if [ "$region_name" = "pr" ]; then
	echo "PR SKU, do not support Armor" >> /dev/console
	exit 0
fi

if [ ! -e "/tmp/ntgrdata/armor/bitdefender/upper" ] || [ ! -e "/tmp/ntgrdata/armor/bitdefender/work" ]; then
    #overlay for bitdefender has to be created
    mkdir -p /tmp/ntgrdata/armor/bitdefender/upper
    mkdir -p /tmp/ntgrdata/armor/bitdefender/work
fi

#Check current and new BD version and mount overlay for bitdefender
new_bd_version=`grep VERSION /opt/bitdefender/bitdefender-release | cut -d= -f2 | cut -d~ -f1`
curr_bd_version=`grep VERSION /tmp/ntgrdata/armor/bitdefender/upper/bitdefender-release | cut -d= -f2 | cut -d~ -f1`

if [ -z "$new_bd_version" ] || [ -z "$curr_bd_version" ] || [ "$new_bd_version" = "$curr_bd_version" ]; then
    echo "No update in BD agent just mount the overlay partition for bitdefender" > /dev/console
else
    if [ -e "/tmp/ntgrdata/armor/bitdefender/upper/etc/storage.data" ]; then
        echo "BD agent version is changing, remove the overlay changes except storage.data" > dev/console
        mv /tmp/ntgrdata/armor/bitdefender/upper/etc/storage.data /tmp/storage.data
        rm -rf /tmp/ntgrdata/armor/bitdefender/upper/*
        cp /tmp/storage.data /tmp/ntgrdata/armor/bitdefender/upper/etc/storage.data
    fi
fi

if [ -e "/tmp/ntgrdata/armor/bitdefender/upper" ] && [ -e "/tmp/ntgrdata/armor/bitdefender/work" ]; then
    mount -o noatime,lowerdir=/opt/bitdefender/,upperdir=/tmp/ntgrdata/armor/bitdefender/upper,workdir=/tmp/ntgrdata/armor/bitdefender/work \
        -t overlay "/tmp/ntgrdata/armor/bitdefender/upper" /opt/bitdefender
    #echo "$? mount status" > /dev/console
fi

#Remove the change as BD agent auto update mechanism is not used here
#check bdupd updater daemon is in /opt
#if [ ! -e "/opt/bitdefender/bin/bdupd" ]; then
#        mkdir -p /opt/bitdefender
#        [ -e /lib/armor/phase2-upd.tar.gz ] && tar -zxvf /lib/armor/phase2-upd.tar.gz -C /opt/bitdefender
#fi

#change to root privilege
#Removing this content as this change adds /opt/bitdefender dir completely in /overlay
#chown -R root:root /opt/bitdefender/

#check for update using bdupd function calls
#nvram variable holds bdupd url for testing purpose. Should be removed after QA testing
#Commenting the changes in the BD init script, as the BD package files are added directly in the firmware itself
#echo `nvram get bdupdserver_url` > /opt/bitdefender/etc/bdupd.server
#serverip=`cut -d/ -f1 /opt/bitdefender/etc/bdupd.server | cut -d= -f2`

#ping_result=1

#if [ ! -z $serverip ]; then
#	ping -c4 $serverip
#	ping_result=$?

#	count=0
#	while [ "$ping_result" = "1" ]
#	do
#		echo "Not able to connect to server" > /dev/console
#		sleep 30
#		ping -c4 $serverip
#		ping_result=$?
#		if [ "$count" -ge "5" ]; then
#			echo "Max tries done, server not reachable" > /dev/console
#			break
#		fi
#		count=$(( $count + 1 ))
#	done
#fi

#Check for update and apply update only when bdupd server is reachable
#if [ "$ping_result" = "0" ]; then
#	is_update_avail=`/opt/bitdefender/bin/bdupd check-update | grep false`
#	if [ "$is_update_avail" = "" ]; then
#		echo "Update is available" >> /dev/console
#		is_updated=`/opt/bitdefender/bin/bdupd apply-update | grep false`
#		if [ "$is_updated" = "" ]; then
#			echo "Update is successful" >> /dev/console
#		else
#			echo "Update is not successful" >> /dev/console
#		fi
#	else
#		echo "Update is not available" >> /dev/console
#	fi
#fi

#create chain for BD_FILTER and add it in the first entry in FORWARD chain
create_chain_ipv4() {
        iptables -N BD_FILTER
        iptables -I FORWARD -j BD_FILTER
}
create_chain_ipv6() {
	ip6tables -N BD_FILTER
	ip6tables -I FORWARD -j BD_FILTER
}


#start BD services when BD files are there. Don't start BD services when there is no required files
if [ -e "/opt/bitdefender/bin/bd" ] && [ -e "/opt/bitdefender/bin/bd_procd" ]; then
	#Change SOT to NTGR
	#cd /opt/bitdefender/bin/
	#rm bdleases
	#ln -s bdleases-ng bdleases

    #script to check the armor protection status and start acceleration decision based on that
    /usr/share/armor/acceleration_decision.sh &
	#stop BD services before starting them
	/opt/bitdefender/bin/bd stop

	#Set appropriate permissions to all files
        #Removing the contents as this change adds /opt/bitdefender dir completely in /overlay
	#chown -R root:root /opt/bitdefender/
	#chmod +x /opt/bitdefender/guster/scripts/*

	#Give delay for some time, to start the Bit Defender Services
 	#sleep 60

	#Adding these rules to ensure proper armor activation
	# Commenting this change as ODM firewall module is adding these rules.
	#create_chain_ipv4
	#create_chain_ipv6

	echo "Starting BD services in the device"
	/opt/bitdefender/bin/bd_procd start

	#copy the brokerd library to /opt/bitdefender before starting ASH

	echo "Start Armor Service Handler"
	/etc/init.d/ASH stop
	/etc/init.d/ASH start

fi
