#!/usr/bin/awk -f

function isMacAddressInStr(str)
{
	return match(toupper(str), "([0-9A-F]{2}:){5}[0-9A-F]{2}")
}

function isIpAddr(str) {
	return match(str,"([0-9]{1,3}\\.){3}[0-9]{1,3}")
}

function printKey(key) {
	dq="\42"
	printf "%s%s%s:", dq, key, dq
}

function printKeyAndValue(key, value) {
	dq="\42"
	printf "%s%s%s:%s%s%s,\n", dq, key, dq, dq, value, dq
}

function printValuewithComma(key) {
	co="\54"
	dq="\42"
	printf "%s%s%s%s",dq, key, dq, co
}
function printValue(value) {
	dq="\42"
	printf "%s%s%s",dq, value, dq
}

BEGIN {
	get_conn_type=0
	connection_type=0
	check_var=0
	#RS="\r\n"
	printf "{"
		printKey("nodes")
		print "["
		# Return error status if no records found
		status=0
		entry_num=-1
	}

	# New record contain "IEEE 1905.1 device"
	/IEEE 1905.1 device/ {
		# Reset variables for new record processing
		fill_device_list=0
		fill_sta_list=0
		device_count=0
		sta_count=0;

		maci=isMacAddressInStr($0)
		if (maci)
			mac=substr($0,maci,17)
		else
			mac=""
		ipaddri=isIpAddr($0)
		if (ipaddri) {
			ipaddr=substr($0,ipaddri)
			# Variable ipaddr contains some text after ipaddress
			# Split words by space separator and take first element of array
			split(ipaddr, var, " ")
			ipaddr=var[1];
		} else {
		ipaddr=""
		# Mesh formation is not completed
		# Missing ipaddr
		status=1
	}
	if (match($1, "#")) {
		# DB entry started with #<entry number>: (#1: QCA IEEE 1905.1 device)
		entry_num++
		get_conn_type=1
		# Close previous record
		print "]},"
	} else {
	# Self (ME) record is the first
	entry_num=0
}

# Write fields to output
print "{"
	printKeyAndValue("mac_addr", mac);
	printKeyAndValue("ipaddr", ipaddr);
	next
}

/Upstream Device/ {
	# Upstream device (parent) MAC address
	upstream=$3
	printKeyAndValue("parent", upstream);
	next
}

/Legacy Devices/ || /Bridged addresses/ {
	# Start accumulating connected devices
	fill_device_list=1
	printKey("dev_list"); print "["
	next
}
/Interface eth/ {
	connection_type=1
	next
}
/Interface ath0/ {
	connection_type=2
	next
}
/Interface ath1/ {
	connection_type=3
	next
}
isMacAddressInStr($4) && get_conn_type == 1 {
	printKeyAndValue("Connected_interface",$3);
	printKeyAndValue("Connection_type","Satellite");
	check_var=$2
	get_conn_type=2
}
isMacAddressInStr($0) && fill_device_list == 1 {
	if (device_count != 0) {
		print ","
	}
	print "{"
		printKey("dev_mac");
		printValue($1);
		print "}"
		device_count++
		next
	}

END {
	print "]\n}\n]\n}"
	if (entry_num == -1) {
		# Topology file is empty or doesn't contain any record
		status=2
	}
	exit status
}
