#!/bin/sh

d=`date '+%d_%b_%Y_%H_%M_%S_%Z'`
dirname="$1"
filename="$1":date:"$d"
win_filename=`/bin/echo $filename |sed  's/:exe//; s/:date//; s/:pid//; s/:ver//; s/:/./g'`
win_dirname=`/bin/echo $dirname | sed 's/:/_/g'`
mkdir -p /tmp/cores/"$win_dirname"
cd /tmp/cores/"$win_dirname"
/bin/echo $filename  | sed 's/core/core info\n/; s/:exe/\nexe/; s/:date/\ndate/; s/:pid/\npid/; s/:ver/\nversion/; s/:sig/\nsignal/'> info.txt
/bin/gzip > "$win_filename".gz
/bin/tar -cf "$win_filename".tar info.txt "$win_filename".gz
/bin/mv "$win_filename".tar /var/log
cd ..
/bin/rm -rf /tmp/cores/$win_dirname
cdlr_dir="/var/log"

coredumped=$(ls -l ${cdlr_dir}/core.* 2>/dev/null | wc -l)
if [ $coredumped -gt 0 ]; then
    #echo 'Coredump file stored to ${cdlr_dir}/core.xxx.xxx'
    if [ $coredumped -gt 4 ]; then
	removals=`expr $coredumped - 4`
	#echo 'Removing '$removals' coredumps older than 4 entries'
	while [ $coredumped -gt 4 ]; do
	    rm `ls -rt ${cdlr_dir}/core.* 2>/dev/null | head -1`
            coredumped=$(ls -l ${cdlr_dir}/core.* 2>/dev/null | wc -l)
	done
    fi

    # check and remove largest core file if total size exceeds limit 7.0M i.e 7340032 bytes
    let total_size=0; largest_size=0; largest_file="";
    for f in `ls ${cdlr_dir}/core.*`;
    do
        s=$(stat -c '%s' $f);
        let total_size=$total_size+$s;
        if [ $s -gt $largest_size ]; then
            largest_size=$s;
            largest_file=$f;
        fi
    done
    if [ $total_size -gt 7340032 ]; then
        rm $largest_file
        touch $largest_file
    fi
    exit 0
fi

