#
# Copyright (C) 2011 OpenWrt.org
#

USE_REFRESH=1

. /lib/ipq806x.sh
. /lib/upgrade/common.sh

RAMFS_COPY_DATA=/lib/ipq806x.sh
RAMFS_COPY_BIN="/usr/bin/dumpimage /bin/mktemp /usr/sbin/mkfs.ubifs
	/usr/sbin/ubiattach /usr/sbin/ubidetach /usr/sbin/ubiformat /usr/sbin/ubimkvol
	/usr/sbin/ubiupdatevol /usr/bin/basename /bin/rm /usr/bin/find
	/usr/sbin/mkfs.ext4"

get_full_section_name() {
	local img=$1
	local sec=$2

	dumpimage -l ${img} | grep "^ Image.*(${sec})" | \
		sed 's,^ Image.*(\(.*\)),\1,'
}

image_contains() {
	local img=$1
	local sec=$2
	dumpimage -l ${img} | grep -q "^ Image.*(${sec}.*)" || return 1
}

print_sections() {
	local img=$1

	dumpimage -l ${img} | awk '/^ Image.*(.*)/ { print gensub(/Image .* \((.*)\)/,"\\1", $0) }'
}

image_has_mandatory_section() {
	local img=$1
	local mandatory_sections=$2

	for sec in ${mandatory_sections}; do
		image_contains $img ${sec} || {\
			return 1
		}
	done
}

check_platform_details () {

    local metadata_file=$1
    local model_id_new=`grep -nr "MODEL_ID" $metadata_file | awk '{print $3}'`
    echo "the new model_id id $model_id_new"
    local model_id_present=`board_data -r board_model_id`
    echo "the old model_id id $model_id_present"
    local version_new=`grep  -nr "VERSION" $metadata_file | awk '{print $3}'`
    echo "the version is id $version_new"

    if [ "$model_id_new" != "$model_id_present" ]; then
        echo " MODEL_ID Does not match"
        return 1
    fi
}

image_demux() {
	local img=$1

	for sec in $(print_sections ${img}); do
		local fullname=$(get_full_section_name ${img} ${sec})

		local position=$(dumpimage -l ${img} | grep "(${fullname})" | awk '{print $2}')
		dumpimage -i ${img} -o /tmp/${fullname}.bin -T "flat_dt" -p "${position}" ${fullname} > /dev/null || { \
			echo "Error while extracting \"${sec}\" from ${img}"
			return 1
		}

		if [ "${sec}" == "txt" ]; then
			echo "came into txt section"
			check_platform_details /tmp/${fullname}.bin
			if [ "$?" == 0 ]; then
				return 0
			else
			 	echo "Error in firmware, Flash proper firmware"
				return 1
			fi
		fi
	done
	return 0
}

image_is_FIT() {
	if ! dumpimage -l $1 > /dev/null 2>&1; then
		echo "$1 is not a valid FIT image"
		echo "INVALID_FIT_IMAGE" > /tmp/fwupgradestatus
		return 1
	fi
	return 0
}


platform_check_image() {
	local board=$(ipq806x_board_name)

	local mandatory_nand="txt ubi"
	local mandatory_nor_emmc="hlos fs"
	local mandatory_nor="hlos"
	local mandatory_section_found=0
	local ddr_section="ddr"
	local optional="sb11 sbl2 u-boot lkboot ddr-${board} ssd tz rpm"
	local ignored="mibib bootconfig"

	image_is_FIT $1 || return 1

	image_has_mandatory_section $1 ${mandatory_nand} && {\
		mandatory_section_found=1
	}

	image_has_mandatory_section $1 ${mandatory_nor_emmc} && {\
		mandatory_section_found=1
	}

	image_has_mandatory_section $1 ${mandatory_nor} && {\
		mandatory_section_found=1
	}

	if [ $mandatory_section_found -eq 0 ]; then
		echo "Error: mandatory section(s) missing from \"$1\". Abort..."
		echo "SECTION_MISSING" > /tmp/fwupgradestatus
		return 1
	fi

	image_demux $1 || {\
		echo "Error: \"$1\" couldn't be extracted. Abort..."
		echo "SECTION_EXTRACTION_ISSUE" > /tmp/fwupgradestatus
		return 1
	}

	dumpimage -c $1
	if [[ "$?" == 0 ]];then
		return $?
	fi
	echo "Rebooting the system"
	reboot
}

platform_check_image $1

if [ "$?" == 0 ]; then
	echo "Firmware properly Validated" > /tmp/fwupgradestatus
	return 0
else
	return 1
fi
