#!/bin/sh

source "/opt/bitdefender/share/scripts/lib/setter.sh"

CHARON_BIN="/opt/bitdefender/bin/charon"
DUMP_CFG_BIN="/opt/bitdefender/bin/dump_config"
CHARON_CMD="LD_LIBRARY_PATH=/opt/bitdefender/lib ${CHARON_BIN}"

KATASTIF_SERVICE="minidump"


logmsg() { echo "$*" >&2; }

get_dump_directory() {
  local app_id="$1"
  local dump_directory="/opt/bitdefender/var/crash/"
  if [ "${app_id}" == "com.netgear.boxlight" ] || [ "${app_id}" == "com.netgear.boxse" ]; then
    dump_directory="/tmp/bdlogs/opt/bitdefender/var/crash/"
  fi

  echo "${dump_directory}"
}

get_ark_directory() {
  local app_id="$1"
  local ark_directory="/opt/bitdefender/var/arks/"
  if [ "${app_id}" == "com.netgear.boxlight" ] || [ "${app_id}" == "com.netgear.boxse" ]; then
    ark_directory="/tmp/bdlogs/opt/bitdefender/var/arks/"
  fi

  echo "${ark_directory}"
}

get_module_version(){
  local app_id="$1"
  local module_name="$2"
  local version_file="/etc/bitdefender-release"
  if [ "${app_id}" == "com.netgear.boxlight" ] || [ "${app_id}" == "com.netgear.boxse" ]; then
    version_file="/opt/bitdefender/bitdefender-release"
  fi

  grep -E '^VERSION=' "${version_file}" 2>/dev/null | awk -F'[=~'] '{print $2}'
}

try_upload(){
  local app_id="$2"
  local dump_directory=$(get_dump_directory "${app_id}")
  local ark_directory=$(get_ark_directory "${app_id}")

  mkdir -p "${ark_directory}"
  local dmp="${1}"
  archivename=""
  timestamp=`date +%s`

  if [ "${app_id}" == "com.netgear.boxlight" ] || [ "${app_id}" == "com.netgear.boxse" ]; then
    gzip -c -f "${dump_directory}${dmp}" > "${dump_directory}${dmp}.gz"
    rm "${dump_directory}${dmp}"
    dmp="${dmp}.gz"
  fi

  # create the config.cfg file
    LD_LIBRARY_PATH=/opt/bitdefender/lib ${DUMP_CFG_BIN} -target_file="${dump_directory}config.cfg"
  # fi

  if [ "${app_id}" == "com.netgear.boxlight" ] || [ "${app_id}" == "com.netgear.boxse" ]; then
    # Netgear format: bddevicediscovery-0.dmp.gz
    local exe_name=$(basename ${dmp} | cut -d '.' -f 1 | cut -d '-' -f 1)
    local patch_ver="$(basename ${dmp} | cut -d '.' -f 1).patch.ver"
  else
    # BOX format: 1538485020.bddevicediscovery.4318.core.gz
    local exe_name=$(basename ${dmp} | cut -d '.' -f 2)
    local patch_ver="$(basename ${dmp} | cut -d '.' -f 1-3).patch.ver"
  fi

  random=`dd if=/dev/urandom bs=4 count=12 2>/dev/null | tr -dc 'a-zA-Z0-9' | cut -c1-6`
  archivename=d_${random}_${timestamp}.tar

  tar -cf "${ark_directory}${archivename}" -C "${dump_directory}" "${dmp}" "${patch_ver}" config.cfg 2> /dev/null
  rm -rf "${dump_directory}${dmp}"
  rm -rf "${dump_directory}${patch_ver}"

  if [ -f ${CHARON_BIN} ];
  then
    uuid=`LD_LIBRARY_PATH="/opt/bitdefender/lib" "${CHARON_BIN}" -c submit -s "${KATASTIF_SERVICE}" -i "${ark_directory}${archivename}"`
  fi

  local module_version=$(get_module_version "${app_id}")
  local extra_json="{\"crash_info\":{\"module_name\":\"${exe_name}\", \"module_version\" : \"${module_version}\", \"katastif\" : \"${uuid}\"}}"
  LD_LIBRARY_PATH="/opt/bitdefender/lib" "/opt/bitdefender/bin/karma" -submit -event_type=bd_module_crashed -extra_json "${extra_json}"
}

check_dumps(){
  local app_id=`LD_LIBRARY_PATH="/opt/bitdefender/lib" "${CHARON_BIN}" -c get_config -m app_id`
  files=`ls $(get_dump_directory "${app_id}") | grep -ve ".cfg\|.patch.ver"`
  set -x
  for i in $files
  do
    try_upload "${i}" "${app_id}"
  done
}

check_pending_dumps(){
  local app_id=`LD_LIBRARY_PATH="/opt/bitdefender/lib" "${CHARON_BIN}" -c get_config -m app_id`
  local dump_directory=$(get_dump_directory "${app_id}")
  local ark_directory=$(get_ark_directory "${app_id}")
  files=`ls "${ark_directory}" 2> /dev/null | grep tar`

  for i in ${files}
  do

    if [ -f "${CHARON_BIN}" ];
    then
      LD_LIBRARY_PATH="/opt/bitdefender/lib" "${CHARON_BIN}" -c submit -s "${KATASTIF_SERVICE}" -i "${ark_directory}${i}"
    fi
  done
}

check_dumps

check_pending_dumps
