/*
 * Copyright (c) 2016 Qualcomm Atheros, Inc.
 * All Rights Reserved.
 * Qualcomm Atheros Confidential and Proprietary.
 */

#ifndef _RATE_2_RATE_BIT_INDEX_H_
#define _RATE_2_RATE_BIT_INDEX_H_

#include "tcmdHostInternal.h"

/*
 * This table converts rate to the rateBitIndex
 */

A_UINT32 rate2RateBitIndex[MASK_RATE_MAX] = {
    0, /* ATH_RATE_1M */    //0
    1, /* ATH_RATE_2M */
    3, /* ATH_RATE_5_5M */
    5, /* ATH_RATE_11M */   //3

    8, /* ATH_RATE_6M */    //4
    9, /* ATH_RATE_9M */
    10, /* ATH_RATE_12M */
    11, /* ATH_RATE_18M */
    12, /* ATH_RATE_24M */
    13, /* ATH_RATE_36M */
    14, /* ATH_RATE_48M */
    15, /* ATH_RATE_54M */  //11

    16, /* ATH_RATE_6_5M */
    17, /* ATH_RATE_13M */
    18, /* ATH_RATE_19_5M */
    19, /* ATH_RATE_26M */
    20, /* ATH_RATE_39M */
    21, /* ATH_RATE_52M */
    22, /* ATH_RATE_58_5M */
    23, /* ATH_RATE_65M */  //19

//#if (WHAL_RX_NUM_CHAIN > 1)
    32, /* ATH_RATE_HT20_MCS8_13M */
    33, /* ATH_RATE_HT20_MCS9_26M */
    34, /* ATH_RATE_HT20_MCS10_39M */
    35, /* ATH_RATE_HT20_MCS11_52M */
    36, /* ATH_RATE_HT20_MCS12_78M */
    37, /* ATH_RATE_HT20_MCS13_104M */
    38, /* ATH_RATE_HT20_MCS14_107M (117M) */
    39, /* ATH_RATE_HT20_MCS15_130M */  //27
//#endif

//#if (WHAL_RX_NUM_CHAIN > 2)
    48, /* ATH_RATE_HT20_MCS16_19_5M */
    49, /* ATH_RATE_HT20_MCS17_39M */
    50, /* ATH_RATE_HT20_MCS18_58_5M */
    51, /* ATH_RATE_HT20_MCS19_78M */
    52, /* ATH_RATE_HT20_MCS20_117M */
    53, /* ATH_RATE_HT20_MCS21_156M */
    54, /* ATH_RATE_HT20_MCS22_175_5M */
    55, /* ATH_RATE_HT20_MCS23_195M */    //35
//#endif

    24, /* ATH_RATE_HT40_13_5M */
    25, /* ATH_RATE_HT40_27M */
    26, /* ATH_RATE_HT40_40_5M */
    27, /* ATH_RATE_HT40_54M */
    28, /* ATH_RATE_HT40_81M */
    29, /* ATH_RATE_HT40_108M */
    30, /* ATH_RATE_HT40_121_5M */
    31, /* ATH_RATE_HT40_135M */    //43

//#if (WHAL_RX_NUM_CHAIN > 1)
    40, /* ATH_RATE_HT40_MCS8_27M */
    41, /* ATH_RATE_HT40_MCS9_54M */
    42, /* ATH_RATE_HT40_MCS10_81M */
    43, /* ATH_RATE_HT40_MCS11_108M */
    44, /* ATH_RATE_HT40_MCS12_162M */
    45, /* ATH_RATE_HT40_MCS13_216M */
    46, /* ATH_RATE_HT40_MCS14_243M */
    47, /* ATH_RATE_HT40_MCS15_270M */  //51
//#endif

//#if (WHAL_RX_NUM_CHAIN > 2)
    56, /* ATH_RATE_HT40_MCS16_40_5M */
    57, /* ATH_RATE_HT40_MCS17_81M */
    58, /* ATH_RATE_HT40_MCS18_121_5M */
    59, /* ATH_RATE_HT40_MCS19_162M */
    60, /* ATH_RATE_HT40_MCS20_243M */
    61, /* ATH_RATE_HT40_MCS21_324M */
    62, /* ATH_RATE_HT40_MCS22_364_5M */
    63, /* ATH_RATE_HT40_MCS23_405M */    //59
//#endif

/// 11AC ..
//VHT20S1
    64, //ATH_RATE_VHT20_NSS1_MCS0,	//60
    65, //ATH_RATE_VHT20_NSS1_MCS1,
    66, //ATH_RATE_VHT20_NSS1_MCS2,
    67, //ATH_RATE_VHT20_NSS1_MCS3,
    68, //ATH_RATE_VHT20_NSS1_MCS4,
    69, //ATH_RATE_VHT20_NSS1_MCS5,
    70, //ATH_RATE_VHT20_NSS1_MCS6,
    71, //ATH_RATE_VHT20_NSS1_MCS7,
    72, //ATH_RATE_VHT20_NSS1_MCS8,
    73, //ATH_RATE_VHT20_NSS1_MCS9,	//69
//#if (WHAL_RX_NUM_CHAIN > 1)
//VHT20S2
    100, //ATH_RATE_VHT20_NSS2_MCS0,	//70
    101, //ATH_RATE_VHT20_NSS2_MCS1,
    102, //ATH_RATE_VHT20_NSS2_MCS2,
    103, //ATH_RATE_VHT20_NSS2_MCS3,
    104, //ATH_RATE_VHT20_NSS2_MCS4,
    105, //ATH_RATE_VHT20_NSS2_MCS5,
    106, //ATH_RATE_VHT20_NSS2_MCS6,
    107, //ATH_RATE_VHT20_NSS2_MCS7,
    108, //ATH_RATE_VHT20_NSS2_MCS8,
    109, //ATH_RATE_VHT20_NSS2_MCS9,	//79
//#endif
//#if (WHAL_RX_NUM_CHAIN > 2)
//VHT20S3
    136, //ATH_RATE_VHT20_NSS3_MCS0,	//80
    137, //ATH_RATE_VHT20_NSS3_MCS1,
    138, //ATH_RATE_VHT20_NSS3_MCS2,
    139, //ATH_RATE_VHT20_NSS3_MCS3,
    140, //ATH_RATE_VHT20_NSS3_MCS4,
    141, //ATH_RATE_VHT20_NSS3_MCS5,
    142, //ATH_RATE_VHT20_NSS3_MCS6,
    143, //ATH_RATE_VHT20_NSS3_MCS7,
    144, //ATH_RATE_VHT20_NSS3_MCS8,
    145, //ATH_RATE_VHT20_NSS3_MCS9,	//89
//#endif
//VHT40S1
    76, //ATH_RATE_VHT40_NSS1_MCS0,	//90
    77, //ATH_RATE_VHT40_NSS1_MCS1,
    78, //ATH_RATE_VHT40_NSS1_MCS2,
    79, //ATH_RATE_VHT40_NSS1_MCS3,
    80, //ATH_RATE_VHT40_NSS1_MCS4,
    81, //ATH_RATE_VHT40_NSS1_MCS5,
    82, //ATH_RATE_VHT40_NSS1_MCS6,
    83, //ATH_RATE_VHT40_NSS1_MCS7,
    84, //ATH_RATE_VHT40_NSS1_MCS8,
    85, //ATH_RATE_VHT40_NSS1_MCS9,	//99
//#if (WHAL_RX_NUM_CHAIN > 1)
//VHT40S2
    112, //ATH_RATE_VHT40_NSS2_MCS0,	//100
    113, //ATH_RATE_VHT40_NSS2_MCS1,
    114, //ATH_RATE_VHT40_NSS2_MCS2,
    115, //ATH_RATE_VHT40_NSS2_MCS3,
    116, //ATH_RATE_VHT40_NSS2_MCS4,
    117, //ATH_RATE_VHT40_NSS2_MCS5,
    118, //ATH_RATE_VHT40_NSS2_MCS6,
    119, //ATH_RATE_VHT40_NSS2_MCS7,
    120, //ATH_RATE_VHT40_NSS2_MCS8,
    121, //ATH_RATE_VHT40_NSS2_MCS9,	//109
//#endif
//#if (WHAL_RX_NUM_CHAIN > 2)
//VHT40S3
    148, //ATH_RATE_VHT40_NSS3_MCS0,	//110
    149, //ATH_RATE_VHT40_NSS3_MCS1,
    150, //ATH_RATE_VHT40_NSS3_MCS2,
    151, //ATH_RATE_VHT40_NSS3_MCS3,
    152, //ATH_RATE_VHT40_NSS3_MCS4,
    153, //ATH_RATE_VHT40_NSS3_MCS5,
    154, //ATH_RATE_VHT40_NSS3_MCS6,
    155, //ATH_RATE_VHT40_NSS3_MCS7,
    156, //ATH_RATE_VHT40_NSS3_MCS8,
    157, //ATH_RATE_VHT40_NSS3_MCS9,	//119
//#endif
//VHT80S1
    88, //ATH_RATE_VHT80_NSS1_MCS0,	//120
    89, //ATH_RATE_VHT80_NSS1_MCS1,
    90, //ATH_RATE_VHT80_NSS1_MCS2,
    91, //ATH_RATE_VHT80_NSS1_MCS3,
    92, //ATH_RATE_VHT80_NSS1_MCS4,
    93, //ATH_RATE_VHT80_NSS1_MCS5,
    94, //ATH_RATE_VHT80_NSS1_MCS6,
    95, //ATH_RATE_VHT80_NSS1_MCS7,
    96, //ATH_RATE_VHT80_NSS1_MCS8,
    97, //ATH_RATE_VHT80_NSS1_MCS9,	//129
//#if (WHAL_RX_NUM_CHAIN > 1)
//VHT80S2
    124, //ATH_RATE_VHT80_NSS2_MCS0,	//130
    125, //ATH_RATE_VHT80_NSS2_MCS1,
    126, //ATH_RATE_VHT80_NSS2_MCS2,
    127, //ATH_RATE_VHT80_NSS2_MCS3,
    128, //ATH_RATE_VHT80_NSS2_MCS4,
    129, //ATH_RATE_VHT80_NSS2_MCS5,
    130, //ATH_RATE_VHT80_NSS2_MCS6,
    131, //ATH_RATE_VHT80_NSS2_MCS7,
    132, //ATH_RATE_VHT40_NSS2_MCS8,
    133, //ATH_RATE_VHT40_NSS2_MCS9,	//139
//#endif
//#if (WHAL_RX_NUM_CHAIN > 2)
//VHT80S3
    160, //ATH_RATE_VHT80_NSS3_MCS0,	//140
    161, //ATH_RATE_VHT80_NSS3_MCS1,
    162, //ATH_RATE_VHT80_NSS3_MCS2,
    163, //ATH_RATE_VHT80_NSS3_MCS3,
    164, //ATH_RATE_VHT80_NSS3_MCS4,
    165, //ATH_RATE_VHT80_NSS3_MCS5,
    166, //ATH_RATE_VHT80_NSS3_MCS6,
    167, //ATH_RATE_VHT80_NSS3_MCS7,
    168, //ATH_RATE_VHT80_NSS3_MCS8,
    169, //ATH_RATE_VHT80_NSS3_MCS9,	//149
//#endif

    2, /* ATH_RATE_2M SHORT CCK */	//150
    4, /* ATH_RATE_5_5M SHORT CCK */	//151
    6, /* ATH_RATE_11M SHORT CCK */	//152

//#if (WHAL_RX_NUM_CHAIN > 3)
    192, //ATH_RATE_VHT20_NSS4_MCS0 	change from 172 to 192 according to Mask2Rate table//153
    193, //ATH_RATE_VHT20_NSS4_MCS1
    194, //ATH_RATE_VHT20_NSS4_MCS2
    195, //ATH_RATE_VHT20_NSS4_MCS3
    196, //ATH_RATE_VHT20_NSS4_MCS4
    197, //ATH_RATE_VHT20_NSS4_MCS5
    198, //ATH_RATE_VHT20_NSS4_MCS6
    199, //ATH_RATE_VHT20_NSS4_MCS7
    200, //ATH_RATE_VHT20_NSS4_MCS8
    201, //ATH_RATE_VHT20_NSS4_MCS9 	//162
    202, //ATH_RATE_VHT40_NSS4_MCS0 	//163
    203, //ATH_RATE_VHT40_NSS4_MCS1
    204, //ATH_RATE_VHT40_NSS4_MCS2
    205, //ATH_RATE_VHT40_NSS4_MCS3
    206, //ATH_RATE_VHT40_NSS4_MCS4
    207, //ATH_RATE_VHT40_NSS4_MCS5
    208, //ATH_RATE_VHT40_NSS4_MCS6
    209, //ATH_RATE_VHT40_NSS4_MCS7
    210, //ATH_RATE_VHT40_NSS4_MCS8
    211, //ATH_RATE_VHT40_NSS4_MCS9 	//172
    212, //ATH_RATE_VHT80_NSS4_MCS0 	//173
    213, //ATH_RATE_VHT80_NSS4_MCS1
    214, //ATH_RATE_VHT80_NSS4_MCS2
    215, //ATH_RATE_VHT80_NSS4_MCS3
    216, //ATH_RATE_VHT80_NSS4_MCS4
    217, //ATH_RATE_VHT80_NSS4_MCS5
    218, //ATH_RATE_VHT80_NSS4_MCS6
    219, //ATH_RATE_VHT80_NSS4_MCS7
    220, //ATH_RATE_VHT80_NSS4_MCS8
    221, //ATH_RATE_VHT80_NSS4_MCS9 	//182
//#endif
    224, //ATH_RATE_VHT160_NSS1_MCS0, //183
    225, //ATH_RATE_VHT160_NSS1_MCS1,
    226, //ATH_RATE_VHT160_NSS1_MCS2,
    227, //ATH_RATE_VHT160_NSS1_MCS3,
    228, //ATH_RATE_VHT160_NSS1_MCS4,
    229, //ATH_RATE_VHT160_NSS1_MCS5,
    230, //ATH_RATE_VHT160_NSS1_MCS6,
    231, //ATH_RATE_VHT160_NSS1_MCS7,
    232, //ATH_RATE_VHT160_NSS1_MCS8,
    233, //ATH_RATE_VHT160_NSS1_MCS9,

    234, //ATH_RATE_VHT160_NSS2_MCS0,
    235, //ATH_RATE_VHT160_NSS2_MCS1,
    236, //ATH_RATE_VHT160_NSS2_MCS2,
    237, //ATH_RATE_VHT160_NSS2_MCS3,
    238, //ATH_RATE_VHT160_NSS2_MCS4,
    239, //ATH_RATE_VHT160_NSS2_MCS5,
    240, //ATH_RATE_VHT160_NSS2_MCS6,
    241, //ATH_RATE_VHT160_NSS2_MCS7,
    242, //ATH_RATE_VHT160_NSS2_MCS8,
    243, //ATH_RATE_VHT160_NSS2_MCS9,	//202

    256, //ATH_RATE_HT20_MCS24,		//203
    257, //ATH_RATE_HT20_MCS25,
    258, //ATH_RATE_HT20_MCS26,
    259, //ATH_RATE_HT20_MCS27,
    260, //ATH_RATE_HT20_MCS28,
    261, //ATH_RATE_HT20_MCS29,
    262, //ATH_RATE_HT20_MCS30,
    263, //ATH_RATE_HT20_MCS31,		//210

    264, //ATH_RATE_HT40_MCS24,		//211
    265, //ATH_RATE_HT40_MCS25,
    266, //ATH_RATE_HT40_MCS26,
    267, //ATH_RATE_HT40_MCS27,
    268, //ATH_RATE_HT40_MCS28,
    269, //ATH_RATE_HT40_MCS29,
    270, //ATH_RATE_HT40_MCS30,
    271, //ATH_RATE_HT40_MCS31,		//218
};


#endif //_RATE_2_RATE_BIT_INDEX_H_

