/*
 * Copyright (c) 2016 Qualcomm Atheros, Inc.
 * All Rights Reserved.
 * Qualcomm Atheros Confidential and Proprietary.
 */

#if !defined(_MASK_RATE_COMMON_H)
#define _MASK_RATE_COMMON_H

_AthDataRate Mask2Rate[RATE_MASK_ROW_MAX][RATE_MASK_BIT_MAX] = {
{
    ATH_RATE_1M, //1M
    ATH_RATE_2M,
    ATH_RATE_2M,
    ATH_RATE_5_5M,
    ATH_RATE_5_5M,
    ATH_RATE_11M,
    ATH_RATE_11M,
    ATH_RATE_11M, // none should be tx here

    ATH_RATE_6M,
    ATH_RATE_9M,
    ATH_RATE_12M,
    ATH_RATE_18M,
    ATH_RATE_24M,
    ATH_RATE_36M,
    ATH_RATE_48M,
    ATH_RATE_54M,

    ATH_RATE_6_5M,
    ATH_RATE_13M,
    ATH_RATE_19_5M,
    ATH_RATE_26M,
    ATH_RATE_39M,
    ATH_RATE_52M,
    ATH_RATE_58_5M,
    ATH_RATE_65M,

    ATH_RATE_HT40_13_5M,
    ATH_RATE_HT40_27M,
    ATH_RATE_HT40_40_5M,
    ATH_RATE_HT40_54M,
    ATH_RATE_HT40_81M,
    ATH_RATE_HT40_108M,
    ATH_RATE_HT40_121_5M,
    ATH_RATE_HT40_135M,
},

{
// should be MCS8 - 15 for HT20 and HT40
    ATH_RATE_HT20_MCS8_13M,
    ATH_RATE_HT20_MCS9_26M,
    ATH_RATE_HT20_MCS10_39M,
    ATH_RATE_HT20_MCS11_52M,
    ATH_RATE_HT20_MCS12_78M,
    ATH_RATE_HT20_MCS13_104M,
    ATH_RATE_HT20_MCS14_107M,
    ATH_RATE_HT20_MCS15_130M,

    ATH_RATE_HT40_MCS8_27M,
    ATH_RATE_HT40_MCS9_54M,
    ATH_RATE_HT40_MCS10_81M,
    ATH_RATE_HT40_MCS11_108M,
    ATH_RATE_HT40_MCS12_162M,
    ATH_RATE_HT40_MCS13_216M,
    ATH_RATE_HT40_MCS14_243M,
    ATH_RATE_HT40_MCS15_270M,

// MCS16 - MCS23 for HT20, HT40, stream3
    ATH_RATE_HT20_MCS16_19_5M,
    ATH_RATE_HT20_MCS17_39M,
    ATH_RATE_HT20_MCS18_58_5M,
    ATH_RATE_HT20_MCS19_78M,
    ATH_RATE_HT20_MCS20_117M,
    ATH_RATE_HT20_MCS21_156M,
    ATH_RATE_HT20_MCS22_175_5M,
    ATH_RATE_HT20_MCS23_195M,

    ATH_RATE_HT40_MCS16_40_5M,
    ATH_RATE_HT40_MCS17_81M,
    ATH_RATE_HT40_MCS18_121_5M,
    ATH_RATE_HT40_MCS19_162M,
    ATH_RATE_HT40_MCS20_243M,
    ATH_RATE_HT40_MCS21_324M,
    ATH_RATE_HT40_MCS22_364_5M,
    ATH_RATE_HT40_MCS23_405M,
},

{
    ATH_RATE_VHT20_NSS1_MCS0,
    ATH_RATE_VHT20_NSS1_MCS1,
    ATH_RATE_VHT20_NSS1_MCS2,
    ATH_RATE_VHT20_NSS1_MCS3,
    ATH_RATE_VHT20_NSS1_MCS4,
    ATH_RATE_VHT20_NSS1_MCS5,
    ATH_RATE_VHT20_NSS1_MCS6,
    ATH_RATE_VHT20_NSS1_MCS7,

    ATH_RATE_VHT20_NSS1_MCS8,
    ATH_RATE_VHT20_NSS1_MCS9,
    ATH_RATE_VHT20_NSS1_MCS9,   // Ignore dummy placeholder
    ATH_RATE_VHT20_NSS1_MCS9,   // Ignore dummy placeholder
    ATH_RATE_VHT40_NSS1_MCS0,
    ATH_RATE_VHT40_NSS1_MCS1,
    ATH_RATE_VHT40_NSS1_MCS2,
    ATH_RATE_VHT40_NSS1_MCS3,

    ATH_RATE_VHT40_NSS1_MCS4,
    ATH_RATE_VHT40_NSS1_MCS5,
    ATH_RATE_VHT40_NSS1_MCS6,
    ATH_RATE_VHT40_NSS1_MCS7,
    ATH_RATE_VHT40_NSS1_MCS8,
    ATH_RATE_VHT40_NSS1_MCS9,
    ATH_RATE_VHT40_NSS1_MCS9,   // Ignore dummy placeholder
    ATH_RATE_VHT40_NSS1_MCS9,   // Ignore dummy placeholder

    ATH_RATE_VHT80_NSS1_MCS0,
    ATH_RATE_VHT80_NSS1_MCS1,
    ATH_RATE_VHT80_NSS1_MCS2,
    ATH_RATE_VHT80_NSS1_MCS3,
    ATH_RATE_VHT80_NSS1_MCS4,
    ATH_RATE_VHT80_NSS1_MCS5,
    ATH_RATE_VHT80_NSS1_MCS6,
    ATH_RATE_VHT80_NSS1_MCS7,
},

{
    ATH_RATE_VHT80_NSS1_MCS8,
    ATH_RATE_VHT80_NSS1_MCS9,
    ATH_RATE_VHT80_NSS1_MCS9,    // Ignore dummy placeholder
    ATH_RATE_VHT80_NSS1_MCS9,    // Ignore dummy placeholder
    ATH_RATE_VHT20_NSS2_MCS0,
    ATH_RATE_VHT20_NSS2_MCS1,
    ATH_RATE_VHT20_NSS2_MCS2,
    ATH_RATE_VHT20_NSS2_MCS3,

    ATH_RATE_VHT20_NSS2_MCS4,
    ATH_RATE_VHT20_NSS2_MCS5,
    ATH_RATE_VHT20_NSS2_MCS6,
    ATH_RATE_VHT20_NSS2_MCS7,
    ATH_RATE_VHT20_NSS2_MCS8,
    ATH_RATE_VHT20_NSS2_MCS9,
    ATH_RATE_VHT20_NSS2_MCS9,    // Ignore dummy placeholder
    ATH_RATE_VHT20_NSS2_MCS9,    // Ignore dummy placeholder

    ATH_RATE_VHT40_NSS2_MCS0,
    ATH_RATE_VHT40_NSS2_MCS1,
    ATH_RATE_VHT40_NSS2_MCS2,
    ATH_RATE_VHT40_NSS2_MCS3,
    ATH_RATE_VHT40_NSS2_MCS4,
    ATH_RATE_VHT40_NSS2_MCS5,
    ATH_RATE_VHT40_NSS2_MCS6,
    ATH_RATE_VHT40_NSS2_MCS7,

    ATH_RATE_VHT40_NSS2_MCS8,
    ATH_RATE_VHT40_NSS2_MCS9,
    ATH_RATE_VHT40_NSS2_MCS9,    // Ignore dummy placeholder
    ATH_RATE_VHT40_NSS2_MCS9,    // Ignore dummy placeholder
    ATH_RATE_VHT80_NSS2_MCS0,
    ATH_RATE_VHT80_NSS2_MCS1,
    ATH_RATE_VHT80_NSS2_MCS2,
    ATH_RATE_VHT80_NSS2_MCS3,
},

{
    ATH_RATE_VHT80_NSS2_MCS4,
    ATH_RATE_VHT80_NSS2_MCS5,
    ATH_RATE_VHT80_NSS2_MCS6,
    ATH_RATE_VHT80_NSS2_MCS7,
    ATH_RATE_VHT80_NSS2_MCS8,
    ATH_RATE_VHT80_NSS2_MCS9,
    ATH_RATE_VHT80_NSS2_MCS9,    // Ignore dummy placeholder
    ATH_RATE_VHT80_NSS2_MCS9,    // Ignore dummy placeholder

    ATH_RATE_VHT20_NSS3_MCS0,
    ATH_RATE_VHT20_NSS3_MCS1,
    ATH_RATE_VHT20_NSS3_MCS2,
    ATH_RATE_VHT20_NSS3_MCS3,
    ATH_RATE_VHT20_NSS3_MCS4,
    ATH_RATE_VHT20_NSS3_MCS5,
    ATH_RATE_VHT20_NSS3_MCS6,
    ATH_RATE_VHT20_NSS3_MCS7,

    ATH_RATE_VHT20_NSS3_MCS8,
    ATH_RATE_VHT20_NSS3_MCS9,
    ATH_RATE_VHT20_NSS3_MCS9,    // Ignore dummy placeholder
    ATH_RATE_VHT20_NSS3_MCS9,    // Ignore dummy placeholder
    ATH_RATE_VHT40_NSS3_MCS0,
    ATH_RATE_VHT40_NSS3_MCS1,
    ATH_RATE_VHT40_NSS3_MCS2,
    ATH_RATE_VHT40_NSS3_MCS3,

    ATH_RATE_VHT40_NSS3_MCS4,
    ATH_RATE_VHT40_NSS3_MCS5,
    ATH_RATE_VHT40_NSS3_MCS6,
    ATH_RATE_VHT40_NSS3_MCS7,
    ATH_RATE_VHT40_NSS3_MCS8,
    ATH_RATE_VHT40_NSS3_MCS9,
    ATH_RATE_VHT40_NSS3_MCS9,    // Ignore dummy placeholder
    ATH_RATE_VHT40_NSS3_MCS9,    // Ignore dummy placeholder
},

{
    ATH_RATE_VHT80_NSS3_MCS0,
    ATH_RATE_VHT80_NSS3_MCS1,
    ATH_RATE_VHT80_NSS3_MCS2,
    ATH_RATE_VHT80_NSS3_MCS3,
    ATH_RATE_VHT80_NSS3_MCS4,
    ATH_RATE_VHT80_NSS3_MCS5,
    ATH_RATE_VHT80_NSS3_MCS6,
    ATH_RATE_VHT80_NSS3_MCS7,

    ATH_RATE_VHT80_NSS3_MCS8,
    ATH_RATE_VHT80_NSS3_MCS9,
    ATH_RATE_VHT80_NSS3_MCS9,    // Ignore dummy placeholder
    ATH_RATE_VHT80_NSS3_MCS9,    // Ignore dummy placeholder
    ATH_RATE_VHT20_NSS3_MCS0,    // NOT valid..
    ATH_RATE_VHT20_NSS3_MCS0,    // NOT valid..
    ATH_RATE_VHT20_NSS3_MCS0,    // NOT valid..
    ATH_RATE_VHT20_NSS3_MCS0,    // NOT valid..

    ATH_RATE_VHT20_NSS3_MCS0,    // NOT valid..
    ATH_RATE_VHT20_NSS3_MCS0,    // NOT valid..
    ATH_RATE_VHT20_NSS3_MCS0,    // NOT valid..
    ATH_RATE_VHT20_NSS3_MCS0,    // NOT valid..
    ATH_RATE_VHT20_NSS3_MCS0,    // NOT valid..
    ATH_RATE_VHT20_NSS3_MCS0,    // NOT valid..
    ATH_RATE_VHT20_NSS3_MCS0,    // NOT valid..
    ATH_RATE_VHT20_NSS3_MCS0,    // NOT valid..

    ATH_RATE_VHT20_NSS3_MCS0,    // NOT valid..
    ATH_RATE_VHT20_NSS3_MCS0,    // NOT valid..
    ATH_RATE_VHT20_NSS3_MCS0,    // NOT valid..
    ATH_RATE_VHT20_NSS3_MCS0,    // NOT valid..
    ATH_RATE_VHT20_NSS3_MCS0,    // NOT valid..
    ATH_RATE_VHT20_NSS3_MCS0,    // NOT valid..
    ATH_RATE_VHT20_NSS3_MCS0,    // NOT valid..
    ATH_RATE_VHT20_NSS3_MCS0,    // NOT valid..
},

{
    ATH_RATE_VHT20_NSS4_MCS0,
    ATH_RATE_VHT20_NSS4_MCS1,
    ATH_RATE_VHT20_NSS4_MCS2,
    ATH_RATE_VHT20_NSS4_MCS3,
    ATH_RATE_VHT20_NSS4_MCS4,
    ATH_RATE_VHT20_NSS4_MCS5,
    ATH_RATE_VHT20_NSS4_MCS6,
    ATH_RATE_VHT20_NSS4_MCS7,

    ATH_RATE_VHT20_NSS4_MCS8,
    ATH_RATE_VHT20_NSS4_MCS9,
    ATH_RATE_VHT40_NSS4_MCS0,
    ATH_RATE_VHT40_NSS4_MCS1,
    ATH_RATE_VHT40_NSS4_MCS2,
    ATH_RATE_VHT40_NSS4_MCS3,
    ATH_RATE_VHT40_NSS4_MCS4,
    ATH_RATE_VHT40_NSS4_MCS5,

    ATH_RATE_VHT40_NSS4_MCS6,
    ATH_RATE_VHT40_NSS4_MCS7,
    ATH_RATE_VHT40_NSS4_MCS8,
    ATH_RATE_VHT40_NSS4_MCS9,
    ATH_RATE_VHT80_NSS4_MCS0,
    ATH_RATE_VHT80_NSS4_MCS1,
    ATH_RATE_VHT80_NSS4_MCS2,
    ATH_RATE_VHT80_NSS4_MCS3,

    ATH_RATE_VHT80_NSS4_MCS4,
    ATH_RATE_VHT80_NSS4_MCS5,
    ATH_RATE_VHT80_NSS4_MCS6,
    ATH_RATE_VHT80_NSS4_MCS7,
    ATH_RATE_VHT80_NSS4_MCS8,
    ATH_RATE_VHT80_NSS4_MCS9,
    ATH_RATE_VHT80_NSS4_MCS9,    //Ignore dummy placeholder
    ATH_RATE_VHT80_NSS4_MCS9,    //Ignore dummy placeholder
},
{
	ATH_RATE_VHT160_NSS1_MCS0,
	ATH_RATE_VHT160_NSS1_MCS1,
	ATH_RATE_VHT160_NSS1_MCS2,
	ATH_RATE_VHT160_NSS1_MCS3,
	ATH_RATE_VHT160_NSS1_MCS4,
	ATH_RATE_VHT160_NSS1_MCS5,
	ATH_RATE_VHT160_NSS1_MCS6,
	ATH_RATE_VHT160_NSS1_MCS7,

	ATH_RATE_VHT160_NSS1_MCS8,
	ATH_RATE_VHT160_NSS1_MCS9,
	ATH_RATE_VHT160_NSS2_MCS0,
	ATH_RATE_VHT160_NSS2_MCS1,
	ATH_RATE_VHT160_NSS2_MCS2,
	ATH_RATE_VHT160_NSS2_MCS3,
	ATH_RATE_VHT160_NSS2_MCS4,
	ATH_RATE_VHT160_NSS2_MCS5,
	ATH_RATE_VHT160_NSS2_MCS6,
	ATH_RATE_VHT160_NSS2_MCS7,
	ATH_RATE_VHT160_NSS2_MCS8,
	ATH_RATE_VHT160_NSS2_MCS9,

	 //Ignore dummy placeholder_
	ATH_RATE_VHT160_NSS2_MCS6,
	ATH_RATE_VHT160_NSS2_MCS7,
	ATH_RATE_VHT160_NSS2_MCS8,
	ATH_RATE_VHT160_NSS2_MCS9,

	ATH_RATE_VHT160_NSS2_MCS8,
	ATH_RATE_VHT160_NSS2_MCS9,
	ATH_RATE_VHT160_NSS2_MCS0,
	ATH_RATE_VHT160_NSS2_MCS1,
	ATH_RATE_VHT160_NSS2_MCS2,
	ATH_RATE_VHT160_NSS2_MCS3,
	ATH_RATE_VHT160_NSS2_MCS4,
	ATH_RATE_VHT160_NSS2_MCS5,
	//_Ignore dummy placeholder
},
{
	ATH_RATE_HT20_MCS24,
	ATH_RATE_HT20_MCS25,
	ATH_RATE_HT20_MCS26,
	ATH_RATE_HT20_MCS27,
	ATH_RATE_HT20_MCS28,
	ATH_RATE_HT20_MCS29,
	ATH_RATE_HT20_MCS30,
	ATH_RATE_HT20_MCS31,

	ATH_RATE_HT40_MCS24,
	ATH_RATE_HT40_MCS25,
	ATH_RATE_HT40_MCS26,
	ATH_RATE_HT40_MCS27,
	ATH_RATE_HT40_MCS28,
	ATH_RATE_HT40_MCS29,
	ATH_RATE_HT40_MCS30,
	ATH_RATE_HT40_MCS31,

	ATH_RATE_HT20_MCS24,     //Ignore dummy placeholder
	ATH_RATE_HT20_MCS25,     //Ignore dummy placeholder
	ATH_RATE_HT20_MCS26,     //Ignore dummy placeholder
	ATH_RATE_HT20_MCS27,     //Ignore dummy placeholder
	ATH_RATE_HT20_MCS28,     //Ignore dummy placeholder
	ATH_RATE_HT20_MCS29,     //Ignore dummy placeholder
	ATH_RATE_HT20_MCS30,     //Ignore dummy placeholder
	ATH_RATE_HT20_MCS31,     //Ignore dummy placeholder

	ATH_RATE_HT40_MCS24,     //Ignore dummy placeholder
	ATH_RATE_HT40_MCS25,     //Ignore dummy placeholder
	ATH_RATE_HT40_MCS26,     //Ignore dummy placeholder
	ATH_RATE_HT40_MCS27,     //Ignore dummy placeholder
	ATH_RATE_HT40_MCS28,     //Ignore dummy placeholder
	ATH_RATE_HT40_MCS29,     //Ignore dummy placeholder
	ATH_RATE_HT40_MCS30,     //Ignore dummy placeholder
	ATH_RATE_HT40_MCS31,     //Ignore dummy placeholder
},
};
#endif

