// Copyright (c) 2014 Qualcomm Atheros, Inc.  All rights reserved.
// $ATH_LICENSE_HW_HDR_C$
//
// DO NOT EDIT!  This file is automatically generated
//               These definitions are tied to a particular hardware layout


#ifndef _PPDU_SS_11N_INFO_H_
#define _PPDU_SS_11N_INFO_H_
#if !defined(__ASSEMBLER__)
#endif

// ################ START SUMMARY #################
//
//	Dword	Fields
//	0	struct l_sig_a l_sig_a_bw20;
//	1	struct l_sig_a l_sig_a_bw40;
//	2-3	struct ht_sig ht_sig_bw20;
//	4-5	struct ht_sig ht_sig_bw40;
//	6	struct tx_service tx_service_bw20;
//	7	struct tx_service tx_service_bw40;
//	10-8	struct tx_pcu_info tx_pcu_info_bw20;
//	13-11	struct tx_pcu_info tx_pcu_info_bw40;
//	14	duration_bw20[15:0], duration_bw40[31:16]
//	15	set_fc_more_data_bw20[0], set_fc_more_data_bw40[1], set_fc_pwr_mgt[2], set_qc_eosp_bw20[3], set_qc_eosp_bw40[4], pcu_data_threshold_20[8:5], pcu_data_threshold_40[12:9], reserved[31:13]
//
// ################ END SUMMARY #################

#define NUM_OF_DWORDS_PPDU_SS_11N_INFO 16

struct ppdu_ss_11n_info {
    struct            l_sig_a                       l_sig_a_bw20;
    struct            l_sig_a                       l_sig_a_bw40;
    struct            ht_sig                       ht_sig_bw20;
    struct            ht_sig                       ht_sig_bw40;
    struct            tx_service                       tx_service_bw20;
    struct            tx_service                       tx_service_bw40;
    struct            tx_pcu_info                       tx_pcu_info_bw20;
    struct            tx_pcu_info                       tx_pcu_info_bw40;
    volatile uint32_t duration_bw20                   : 16, //[15:0]
                      duration_bw40                   : 16; //[31:16]
    volatile uint32_t set_fc_more_data_bw20           :  1, //[0]
                      set_fc_more_data_bw40           :  1, //[1]
                      set_fc_pwr_mgt                  :  1, //[2]
                      set_qc_eosp_bw20                :  1, //[3]
                      set_qc_eosp_bw40                :  1, //[4]
                      pcu_data_threshold_20           :  4, //[8:5]
                      pcu_data_threshold_40           :  4, //[12:9]
                      reserved                        : 19; //[31:13]
};

/*

struct l_sig_a l_sig_a_bw20
			
			This field has exactly the same contents as the L_SIG_A
			TLV (without the tag/length word)

struct l_sig_a l_sig_a_bw40
			
			This field has exactly the same contents as the L_SIG_A
			TLV (without the tag/length word)

struct ht_sig ht_sig_bw20
			
			HT SIG field setting for 20 MHz transmission
			
			This field has exactly the same contents as the HT_SIG
			TLV (without the tag/length word)

struct ht_sig ht_sig_bw40
			
			HT SIG field setting for 40 MHz transmission
			
			This field has exactly the same contents as the HT_SIG
			TLV (without the tag/length word)

struct tx_service tx_service_bw20
			
			HT SERVICE field setting for 20 MHz transmission
			
			This field has exactly the same contents as the
			TX_SERVICE TLV (without the tag/length word)

struct tx_service tx_service_bw40
			
			HT SERVICE field setting for 40 MHz transmission
			
			This field has exactly the same contents as the
			TX_SERVICE TLV (without the tag/length word)

struct tx_pcu_info tx_pcu_info_bw20
			
			Info for tx_pcu for 20 MHz BW

struct tx_pcu_info tx_pcu_info_bw40
			
			Info for tx_pcu for 40 MHz BW

duration_bw20
			
			Duration field value to be inserted in the MPDUs when
			transmitting at 20 MHz BW.
			
			<legal all>

duration_bw40
			
			Duration field value to be inserted in the MPDUs when
			transmitting at 40 MHz BW
			
			<legal all>

set_fc_more_data_bw20
			
			For 20 MHz Bandwidth:
			
			When set, the TX PCU will set the more data bit in the
			Frame Control field for the transmitted frames.
			
			<legal all>

set_fc_more_data_bw40
			
			For 40 MHz Bandwidth:
			
			When set, the TX PCU will set the more data bit in the
			Frame Control field for the transmitted frames.
			
			<legal all>

set_fc_pwr_mgt
			
			When set, the TX PCU will set the power management bit
			in the Frame Control field for the transmitted frames.
			
			This will only be set for the SW generated path.
			
			<legal all>

set_qc_eosp_bw20
			
			For 20 MHz Bandwidth:
			
			When set, the PCU will set the eosp bit in the QoS
			Control field for the transmitted frames.
			
			<legal all>

set_qc_eosp_bw40
			
			For 40 MHz Bandwidth:
			
			When set, the PCU will set the eosp bit in the QoS
			Control field for the transmitted frames.
			
			<legal all>

pcu_data_threshold_20
			
			Field only used in case of 20 MHz transmission.
			
			The minimum amount of MPDU data present in the TX PCU
			buffer, before TX PCU allows this MPDU data to transfer to
			the PHY. This threshold prevents or reduces data underrun
			conditions during an MPDU transmission. 
			
			If an entire MPDU frame is present in the TX PCU buffer
			that is smaller than this threshold value, this threshold is
			ignored, and MPDU data transfer to the PHY is allowed to
			start.
			
			In units of 256 bytes, except for value 0xF, which means
			that only when the entire frame is present in the TX PCU
			buffer, the transmission is allowed to start.
			
			<legal all>

pcu_data_threshold_40
			
			Field only used in case of 40 MHz transmission.
			
			The minimum amount of MPDU data present in the TX PCU
			buffer, before TX PCU allows this MPDU data to transfer to
			the PHY. This threshold prevents or reduces data underrun
			conditions during an MPDU transmission. 
			
			If an entire MPDU frame is present in the TX PCU buffer
			that is smaller than this threshold value, this threshold is
			ignored, and MPDU data transfer to the PHY is allowed to
			start.
			
			In units of 256 bytes, except for value 0xF, which means
			that only when the entire frame is present in the TX PCU
			buffer, the transmission is allowed to start.
			
			<legal all>

reserved
			
			<legal 0>
*/

#define PPDU_SS_11N_INFO_0_L_SIG_A_L_SIG_A_BW20_OFFSET               0x00000000
#define PPDU_SS_11N_INFO_0_L_SIG_A_L_SIG_A_BW20_LSB                  13
#define PPDU_SS_11N_INFO_0_L_SIG_A_L_SIG_A_BW20_MASK                 0xffffffff
#define PPDU_SS_11N_INFO_1_L_SIG_A_L_SIG_A_BW40_OFFSET               0x00000004
#define PPDU_SS_11N_INFO_1_L_SIG_A_L_SIG_A_BW40_LSB                  13
#define PPDU_SS_11N_INFO_1_L_SIG_A_L_SIG_A_BW40_MASK                 0xffffffff
#define PPDU_SS_11N_INFO_2_HT_SIG_HT_SIG_BW20_OFFSET                 0x00000008
#define PPDU_SS_11N_INFO_2_HT_SIG_HT_SIG_BW20_LSB                    13
#define PPDU_SS_11N_INFO_2_HT_SIG_HT_SIG_BW20_MASK                   0xffffffff
#define PPDU_SS_11N_INFO_3_HT_SIG_HT_SIG_BW20_OFFSET                 0x0000000c
#define PPDU_SS_11N_INFO_3_HT_SIG_HT_SIG_BW20_LSB                    13
#define PPDU_SS_11N_INFO_3_HT_SIG_HT_SIG_BW20_MASK                   0xffffffff
#define PPDU_SS_11N_INFO_4_HT_SIG_HT_SIG_BW40_OFFSET                 0x00000010
#define PPDU_SS_11N_INFO_4_HT_SIG_HT_SIG_BW40_LSB                    13
#define PPDU_SS_11N_INFO_4_HT_SIG_HT_SIG_BW40_MASK                   0xffffffff
#define PPDU_SS_11N_INFO_5_HT_SIG_HT_SIG_BW40_OFFSET                 0x00000014
#define PPDU_SS_11N_INFO_5_HT_SIG_HT_SIG_BW40_LSB                    13
#define PPDU_SS_11N_INFO_5_HT_SIG_HT_SIG_BW40_MASK                   0xffffffff
#define PPDU_SS_11N_INFO_6_TX_SERVICE_TX_SERVICE_BW20_OFFSET         0x00000018
#define PPDU_SS_11N_INFO_6_TX_SERVICE_TX_SERVICE_BW20_LSB            13
#define PPDU_SS_11N_INFO_6_TX_SERVICE_TX_SERVICE_BW20_MASK           0xffffffff
#define PPDU_SS_11N_INFO_7_TX_SERVICE_TX_SERVICE_BW40_OFFSET         0x0000001c
#define PPDU_SS_11N_INFO_7_TX_SERVICE_TX_SERVICE_BW40_LSB            13
#define PPDU_SS_11N_INFO_7_TX_SERVICE_TX_SERVICE_BW40_MASK           0xffffffff

/* Description		PPDU_SS_11N_INFO_14_DURATION_BW20
			
			Duration field value to be inserted in the MPDUs when
			transmitting at 20 MHz BW.
			
			<legal all>
*/
#define PPDU_SS_11N_INFO_14_DURATION_BW20_OFFSET                     0x00000038
#define PPDU_SS_11N_INFO_14_DURATION_BW20_LSB                        0
#define PPDU_SS_11N_INFO_14_DURATION_BW20_MASK                       0x0000ffff

/* Description		PPDU_SS_11N_INFO_14_DURATION_BW40
			
			Duration field value to be inserted in the MPDUs when
			transmitting at 40 MHz BW
			
			<legal all>
*/
#define PPDU_SS_11N_INFO_14_DURATION_BW40_OFFSET                     0x00000038
#define PPDU_SS_11N_INFO_14_DURATION_BW40_LSB                        16
#define PPDU_SS_11N_INFO_14_DURATION_BW40_MASK                       0xffff0000

/* Description		PPDU_SS_11N_INFO_15_SET_FC_MORE_DATA_BW20
			
			For 20 MHz Bandwidth:
			
			When set, the TX PCU will set the more data bit in the
			Frame Control field for the transmitted frames.
			
			<legal all>
*/
#define PPDU_SS_11N_INFO_15_SET_FC_MORE_DATA_BW20_OFFSET             0x0000003c
#define PPDU_SS_11N_INFO_15_SET_FC_MORE_DATA_BW20_LSB                0
#define PPDU_SS_11N_INFO_15_SET_FC_MORE_DATA_BW20_MASK               0x00000001

/* Description		PPDU_SS_11N_INFO_15_SET_FC_MORE_DATA_BW40
			
			For 40 MHz Bandwidth:
			
			When set, the TX PCU will set the more data bit in the
			Frame Control field for the transmitted frames.
			
			<legal all>
*/
#define PPDU_SS_11N_INFO_15_SET_FC_MORE_DATA_BW40_OFFSET             0x0000003c
#define PPDU_SS_11N_INFO_15_SET_FC_MORE_DATA_BW40_LSB                1
#define PPDU_SS_11N_INFO_15_SET_FC_MORE_DATA_BW40_MASK               0x00000002

/* Description		PPDU_SS_11N_INFO_15_SET_FC_PWR_MGT
			
			When set, the TX PCU will set the power management bit
			in the Frame Control field for the transmitted frames.
			
			This will only be set for the SW generated path.
			
			<legal all>
*/
#define PPDU_SS_11N_INFO_15_SET_FC_PWR_MGT_OFFSET                    0x0000003c
#define PPDU_SS_11N_INFO_15_SET_FC_PWR_MGT_LSB                       2
#define PPDU_SS_11N_INFO_15_SET_FC_PWR_MGT_MASK                      0x00000004

/* Description		PPDU_SS_11N_INFO_15_SET_QC_EOSP_BW20
			
			For 20 MHz Bandwidth:
			
			When set, the PCU will set the eosp bit in the QoS
			Control field for the transmitted frames.
			
			<legal all>
*/
#define PPDU_SS_11N_INFO_15_SET_QC_EOSP_BW20_OFFSET                  0x0000003c
#define PPDU_SS_11N_INFO_15_SET_QC_EOSP_BW20_LSB                     3
#define PPDU_SS_11N_INFO_15_SET_QC_EOSP_BW20_MASK                    0x00000008

/* Description		PPDU_SS_11N_INFO_15_SET_QC_EOSP_BW40
			
			For 40 MHz Bandwidth:
			
			When set, the PCU will set the eosp bit in the QoS
			Control field for the transmitted frames.
			
			<legal all>
*/
#define PPDU_SS_11N_INFO_15_SET_QC_EOSP_BW40_OFFSET                  0x0000003c
#define PPDU_SS_11N_INFO_15_SET_QC_EOSP_BW40_LSB                     4
#define PPDU_SS_11N_INFO_15_SET_QC_EOSP_BW40_MASK                    0x00000010

/* Description		PPDU_SS_11N_INFO_15_PCU_DATA_THRESHOLD_20
			
			Field only used in case of 20 MHz transmission.
			
			The minimum amount of MPDU data present in the TX PCU
			buffer, before TX PCU allows this MPDU data to transfer to
			the PHY. This threshold prevents or reduces data underrun
			conditions during an MPDU transmission. 
			
			If an entire MPDU frame is present in the TX PCU buffer
			that is smaller than this threshold value, this threshold is
			ignored, and MPDU data transfer to the PHY is allowed to
			start.
			
			In units of 256 bytes, except for value 0xF, which means
			that only when the entire frame is present in the TX PCU
			buffer, the transmission is allowed to start.
			
			<legal all>
*/
#define PPDU_SS_11N_INFO_15_PCU_DATA_THRESHOLD_20_OFFSET             0x0000003c
#define PPDU_SS_11N_INFO_15_PCU_DATA_THRESHOLD_20_LSB                5
#define PPDU_SS_11N_INFO_15_PCU_DATA_THRESHOLD_20_MASK               0x000001e0

/* Description		PPDU_SS_11N_INFO_15_PCU_DATA_THRESHOLD_40
			
			Field only used in case of 40 MHz transmission.
			
			The minimum amount of MPDU data present in the TX PCU
			buffer, before TX PCU allows this MPDU data to transfer to
			the PHY. This threshold prevents or reduces data underrun
			conditions during an MPDU transmission. 
			
			If an entire MPDU frame is present in the TX PCU buffer
			that is smaller than this threshold value, this threshold is
			ignored, and MPDU data transfer to the PHY is allowed to
			start.
			
			In units of 256 bytes, except for value 0xF, which means
			that only when the entire frame is present in the TX PCU
			buffer, the transmission is allowed to start.
			
			<legal all>
*/
#define PPDU_SS_11N_INFO_15_PCU_DATA_THRESHOLD_40_OFFSET             0x0000003c
#define PPDU_SS_11N_INFO_15_PCU_DATA_THRESHOLD_40_LSB                9
#define PPDU_SS_11N_INFO_15_PCU_DATA_THRESHOLD_40_MASK               0x00001e00

/* Description		PPDU_SS_11N_INFO_15_RESERVED
			
			<legal 0>
*/
#define PPDU_SS_11N_INFO_15_RESERVED_OFFSET                          0x0000003c
#define PPDU_SS_11N_INFO_15_RESERVED_LSB                             13
#define PPDU_SS_11N_INFO_15_RESERVED_MASK                            0xffffe000


#endif // _PPDU_SS_11N_INFO_H_
