// Copyright (c) 2014 Qualcomm Atheros, Inc.  All rights reserved.
// $ATH_LICENSE_HW_HDR_C$
//
// DO NOT EDIT!  This file is automatically generated
//               These definitions are tied to a particular hardware layout


#ifndef _MPDU_QUEUE_HEAD_INFO_H_
#define _MPDU_QUEUE_HEAD_INFO_H_
#if !defined(__ASSEMBLER__)
#endif

// ################ START SUMMARY #################
//
//	Dword	Fields
//	0	mpdu_index[13:0], reserved_0[15:14], end_of_lifetime[31:16]
//	1	rate_offset[1:0], ba_flow_enabled[2], bar_tx_needed[3], bar_tx_reason[4], queue_paused[5], qm_paused[6], mpdu_retry_count[15:7], invalid_qid_requested[16], reserved_1[31:17]
//
// ################ END SUMMARY #################

#define NUM_OF_DWORDS_MPDU_QUEUE_HEAD_INFO 2

struct mpdu_queue_head_info {
    volatile uint32_t mpdu_index                      : 14, //[13:0]
                      reserved_0                      :  2, //[15:14]
                      end_of_lifetime                 : 16; //[31:16]
    volatile uint32_t rate_offset                     :  2, //[1:0]
                      ba_flow_enabled                 :  1, //[2]
                      bar_tx_needed                   :  1, //[3]
                      bar_tx_reason                   :  1, //[4]
                      queue_paused                    :  1, //[5]
                      qm_paused                       :  1, //[6]
                      mpdu_retry_count                :  9, //[15:7]
                      invalid_qid_requested           :  1, //[16]
                      reserved_1                      : 15; //[31:17]
};

/*

mpdu_index
			
			When any of the ..._paused fields are set, this field
			should be set to 0 (NULL pointer).
			
			Index of the MPDU at the head of the queue. If the queue
			is empty, the NULL pointer shall be returned.
			
			Info in this field is coming from the MPDU_queue
			descriptor.
			
			<legal all>

reserved_0
			
			Generator should set to 0, consumer will ignore.  <legal
			0>

end_of_lifetime
			
			Field only valid when MPDU index is NOT a NULL pointer.
			
			The units of this value is programmed in a global
			configuration register.
			
			The value is the absolute time (using the Always running
			clock) that indicates till when the frame is allowed to
			remain in the queue. After this time, the frame should be
			removed and not transmitted anymore. 
			
			Info in this field is coming from the MPDU_link_ext
			descriptor.
			
			 <legal all>

rate_offset
			
			Field only valid when MPDU index is NOT a NULL pointer.
			
			This field is the Rate_offset field value in the
			MPDU_link descriptor of the queue head mpdu frame.
			
			The Rate Offset influences the final transmit rate
			selected for this frame.
			
			<enum 0 Max_column_A>  Maximum transmit rate comes from
			column A
			
			<enum 1 Max_column_B> Maximum transmit rate comes from
			column B
			
			<enum 2 Max_column_C> Maximum transmit rate comes from
			column C
			
			<enum 3 Max_column_D> Maximum transmit rate comes from
			column D
			
			Details of Rate_offset handling are described in chapter
			REF _Ref329693574 \w \h 10.1 
			
			Info in this field is coming from the MPDU_link
			descriptor.

ba_flow_enabled
			
			Field only valid when MPDU index is NOT a NULL pointer.
			
			Block Ack flow
			
			When set, a Block Ack flow is ongoing.
			
			Info in this field is coming from the MPDU_link_ext
			descriptor.

bar_tx_needed
			
			Field only valid when MPDU index is NOT a NULL pointer.
			
			When set, a HW initiated BAR transmission is needed for
			this queue
			
			Info in this field is coming from the MPDU_queue_ext
			descriptor.
			
			<legal all>

bar_tx_reason
			
			Field only valid when MPDU index is NOT a NULL pointer.
			
			Field only valid when bar_tx_needed is set.
			
			
			
			0: frame_del_max_retry
			
			1: frame_del_by_scheduler
			
			If in the MPDU_queue_ext descriptor both reasons were
			set, only frame_del_by_scheduler will be reported.
			
			
			
			Info in this field is coming from the MPDU_queue_ext
			descriptor.
			
			<legal all>

queue_paused
			
			0: No action
			
			1: The queue has been paused, and all transmission for
			this queue needs to be halted.
			
			The scheduler should pause the execution of this
			scheduler command ring, till SW has re-enabled this
			scheduler ring using a control register in the scheduler.
			
			<legal all>

qm_paused
			
			0: No action
			
			1: The entire QM has been paused, and all interactions
			with the QM (asking for MPDU_QUEUE_HEAD_INFO needs to be
			stopped for all scheduler command rings. In this mode, the
			scheduler can only continue with SW controlled FES
			transmissions.
			
			The scheduler can only resume with HW controlled FES
			transmissions when SW has indicated this to the scheduler
			using a control register in the scheduler.
			
			<legal all>

mpdu_retry_count
			
			This is the MPDU retry count MPDU at the head of the
			queue.<legal all>

invalid_qid_requested
			
			When set, the SCH asked QID info for an invalid QID (=>
			That is outside the allowed QiD range)
			
			<legal all>

reserved_1
			
			<legal 0>
*/


/* Description		MPDU_QUEUE_HEAD_INFO_0_MPDU_INDEX
			
			When any of the ..._paused fields are set, this field
			should be set to 0 (NULL pointer).
			
			Index of the MPDU at the head of the queue. If the queue
			is empty, the NULL pointer shall be returned.
			
			Info in this field is coming from the MPDU_queue
			descriptor.
			
			<legal all>
*/
#define MPDU_QUEUE_HEAD_INFO_0_MPDU_INDEX_OFFSET                     0x00000000
#define MPDU_QUEUE_HEAD_INFO_0_MPDU_INDEX_LSB                        0
#define MPDU_QUEUE_HEAD_INFO_0_MPDU_INDEX_MASK                       0x00003fff

/* Description		MPDU_QUEUE_HEAD_INFO_0_RESERVED_0
			
			Generator should set to 0, consumer will ignore.  <legal
			0>
*/
#define MPDU_QUEUE_HEAD_INFO_0_RESERVED_0_OFFSET                     0x00000000
#define MPDU_QUEUE_HEAD_INFO_0_RESERVED_0_LSB                        14
#define MPDU_QUEUE_HEAD_INFO_0_RESERVED_0_MASK                       0x0000c000

/* Description		MPDU_QUEUE_HEAD_INFO_0_END_OF_LIFETIME
			
			Field only valid when MPDU index is NOT a NULL pointer.
			
			The units of this value is programmed in a global
			configuration register.
			
			The value is the absolute time (using the Always running
			clock) that indicates till when the frame is allowed to
			remain in the queue. After this time, the frame should be
			removed and not transmitted anymore. 
			
			Info in this field is coming from the MPDU_link_ext
			descriptor.
			
			 <legal all>
*/
#define MPDU_QUEUE_HEAD_INFO_0_END_OF_LIFETIME_OFFSET                0x00000000
#define MPDU_QUEUE_HEAD_INFO_0_END_OF_LIFETIME_LSB                   16
#define MPDU_QUEUE_HEAD_INFO_0_END_OF_LIFETIME_MASK                  0xffff0000

/* Description		MPDU_QUEUE_HEAD_INFO_1_RATE_OFFSET
			
			Field only valid when MPDU index is NOT a NULL pointer.
			
			This field is the Rate_offset field value in the
			MPDU_link descriptor of the queue head mpdu frame.
			
			The Rate Offset influences the final transmit rate
			selected for this frame.
			
			<enum 0 Max_column_A>  Maximum transmit rate comes from
			column A
			
			<enum 1 Max_column_B> Maximum transmit rate comes from
			column B
			
			<enum 2 Max_column_C> Maximum transmit rate comes from
			column C
			
			<enum 3 Max_column_D> Maximum transmit rate comes from
			column D
			
			Details of Rate_offset handling are described in chapter
			REF _Ref329693574 \w \h 10.1 
			
			Info in this field is coming from the MPDU_link
			descriptor.
*/
#define MPDU_QUEUE_HEAD_INFO_1_RATE_OFFSET_OFFSET                    0x00000004
#define MPDU_QUEUE_HEAD_INFO_1_RATE_OFFSET_LSB                       0
#define MPDU_QUEUE_HEAD_INFO_1_RATE_OFFSET_MASK                      0x00000003

/* Description		MPDU_QUEUE_HEAD_INFO_1_BA_FLOW_ENABLED
			
			Field only valid when MPDU index is NOT a NULL pointer.
			
			Block Ack flow
			
			When set, a Block Ack flow is ongoing.
			
			Info in this field is coming from the MPDU_link_ext
			descriptor.
*/
#define MPDU_QUEUE_HEAD_INFO_1_BA_FLOW_ENABLED_OFFSET                0x00000004
#define MPDU_QUEUE_HEAD_INFO_1_BA_FLOW_ENABLED_LSB                   2
#define MPDU_QUEUE_HEAD_INFO_1_BA_FLOW_ENABLED_MASK                  0x00000004

/* Description		MPDU_QUEUE_HEAD_INFO_1_BAR_TX_NEEDED
			
			Field only valid when MPDU index is NOT a NULL pointer.
			
			When set, a HW initiated BAR transmission is needed for
			this queue
			
			Info in this field is coming from the MPDU_queue_ext
			descriptor.
			
			<legal all>
*/
#define MPDU_QUEUE_HEAD_INFO_1_BAR_TX_NEEDED_OFFSET                  0x00000004
#define MPDU_QUEUE_HEAD_INFO_1_BAR_TX_NEEDED_LSB                     3
#define MPDU_QUEUE_HEAD_INFO_1_BAR_TX_NEEDED_MASK                    0x00000008

/* Description		MPDU_QUEUE_HEAD_INFO_1_BAR_TX_REASON
			
			Field only valid when MPDU index is NOT a NULL pointer.
			
			Field only valid when bar_tx_needed is set.
			
			
			
			0: frame_del_max_retry
			
			1: frame_del_by_scheduler
			
			If in the MPDU_queue_ext descriptor both reasons were
			set, only frame_del_by_scheduler will be reported.
			
			
			
			Info in this field is coming from the MPDU_queue_ext
			descriptor.
			
			<legal all>
*/
#define MPDU_QUEUE_HEAD_INFO_1_BAR_TX_REASON_OFFSET                  0x00000004
#define MPDU_QUEUE_HEAD_INFO_1_BAR_TX_REASON_LSB                     4
#define MPDU_QUEUE_HEAD_INFO_1_BAR_TX_REASON_MASK                    0x00000010

/* Description		MPDU_QUEUE_HEAD_INFO_1_QUEUE_PAUSED
			
			0: No action
			
			1: The queue has been paused, and all transmission for
			this queue needs to be halted.
			
			The scheduler should pause the execution of this
			scheduler command ring, till SW has re-enabled this
			scheduler ring using a control register in the scheduler.
			
			<legal all>
*/
#define MPDU_QUEUE_HEAD_INFO_1_QUEUE_PAUSED_OFFSET                   0x00000004
#define MPDU_QUEUE_HEAD_INFO_1_QUEUE_PAUSED_LSB                      5
#define MPDU_QUEUE_HEAD_INFO_1_QUEUE_PAUSED_MASK                     0x00000020

/* Description		MPDU_QUEUE_HEAD_INFO_1_QM_PAUSED
			
			0: No action
			
			1: The entire QM has been paused, and all interactions
			with the QM (asking for MPDU_QUEUE_HEAD_INFO needs to be
			stopped for all scheduler command rings. In this mode, the
			scheduler can only continue with SW controlled FES
			transmissions.
			
			The scheduler can only resume with HW controlled FES
			transmissions when SW has indicated this to the scheduler
			using a control register in the scheduler.
			
			<legal all>
*/
#define MPDU_QUEUE_HEAD_INFO_1_QM_PAUSED_OFFSET                      0x00000004
#define MPDU_QUEUE_HEAD_INFO_1_QM_PAUSED_LSB                         6
#define MPDU_QUEUE_HEAD_INFO_1_QM_PAUSED_MASK                        0x00000040

/* Description		MPDU_QUEUE_HEAD_INFO_1_MPDU_RETRY_COUNT
			
			This is the MPDU retry count MPDU at the head of the
			queue.<legal all>
*/
#define MPDU_QUEUE_HEAD_INFO_1_MPDU_RETRY_COUNT_OFFSET               0x00000004
#define MPDU_QUEUE_HEAD_INFO_1_MPDU_RETRY_COUNT_LSB                  7
#define MPDU_QUEUE_HEAD_INFO_1_MPDU_RETRY_COUNT_MASK                 0x0000ff80

/* Description		MPDU_QUEUE_HEAD_INFO_1_INVALID_QID_REQUESTED
			
			When set, the SCH asked QID info for an invalid QID (=>
			That is outside the allowed QiD range)
			
			<legal all>
*/
#define MPDU_QUEUE_HEAD_INFO_1_INVALID_QID_REQUESTED_OFFSET          0x00000004
#define MPDU_QUEUE_HEAD_INFO_1_INVALID_QID_REQUESTED_LSB             16
#define MPDU_QUEUE_HEAD_INFO_1_INVALID_QID_REQUESTED_MASK            0x00010000

/* Description		MPDU_QUEUE_HEAD_INFO_1_RESERVED_1
			
			<legal 0>
*/
#define MPDU_QUEUE_HEAD_INFO_1_RESERVED_1_OFFSET                     0x00000004
#define MPDU_QUEUE_HEAD_INFO_1_RESERVED_1_LSB                        17
#define MPDU_QUEUE_HEAD_INFO_1_RESERVED_1_MASK                       0xfffe0000


#endif // _MPDU_QUEUE_HEAD_INFO_H_
