//
// -----------------------------------------------------------------------------
// Copyright (c) 2011-2014 Qualcomm Atheros, Inc.  All rights reserved.
// -----------------------------------------------------------------------------
// FILE         : pcie_phy_reg.h
// DESCRIPTION  : Software Header File for WiFi 2.5
// THIS FILE IS AUTOMATICALLY GENERATED BY DENALI BLUEPRINT, DO NOT EDIT
// -----------------------------------------------------------------------------
//

#ifndef _PCIE_PHY_REG_H_
#define _PCIE_PHY_REG_H_


#ifndef __PCIE_PHY_REG_BASE_ADDRESS
#define __PCIE_PHY_REG_BASE_ADDRESS (0x8d000)
#endif


// 0x0 (IDCODE_LO)
#define IDCODE_LO_IDCODE_LO_LSB                                                0
#define IDCODE_LO_IDCODE_LO_MSB                                                15
#define IDCODE_LO_IDCODE_LO_MASK                                               0xffff
#define IDCODE_LO_IDCODE_LO_GET(x)                                             (((x) & IDCODE_LO_IDCODE_LO_MASK) >> IDCODE_LO_IDCODE_LO_LSB)
#define IDCODE_LO_IDCODE_LO_SET(x)                                             (((0 | (x)) << IDCODE_LO_IDCODE_LO_LSB) & IDCODE_LO_IDCODE_LO_MASK)
#define IDCODE_LO_IDCODE_LO_RESET                                              0x64cd
#define IDCODE_LO_ADDRESS                                                      (0x0 + __PCIE_PHY_REG_BASE_ADDRESS)
#define IDCODE_LO_RSTMASK                                                      0xffff
#define IDCODE_LO_RESET                                                        0x64cd

// 0x4 (IDCODE_HI)
#define IDCODE_HI_IDCODE_HI_LSB                                                0
#define IDCODE_HI_IDCODE_HI_MSB                                                15
#define IDCODE_HI_IDCODE_HI_MASK                                               0xffff
#define IDCODE_HI_IDCODE_HI_GET(x)                                             (((x) & IDCODE_HI_IDCODE_HI_MASK) >> IDCODE_HI_IDCODE_HI_LSB)
#define IDCODE_HI_IDCODE_HI_SET(x)                                             (((0 | (x)) << IDCODE_HI_IDCODE_HI_LSB) & IDCODE_HI_IDCODE_HI_MASK)
#define IDCODE_HI_IDCODE_HI_RESET                                              0x9218
#define IDCODE_HI_ADDRESS                                                      (0x4 + __PCIE_PHY_REG_BASE_ADDRESS)
#define IDCODE_HI_RSTMASK                                                      0xffff
#define IDCODE_HI_RESET                                                        0x9218

// 0x8 (DEBUG)
#define DEBUG_DTB_SEL_LSB                                                      5
#define DEBUG_DTB_SEL_MSB                                                      6
#define DEBUG_DTB_SEL_MASK                                                     0x60
#define DEBUG_DTB_SEL_GET(x)                                                   (((x) & DEBUG_DTB_SEL_MASK) >> DEBUG_DTB_SEL_LSB)
#define DEBUG_DTB_SEL_SET(x)                                                   (((0 | (x)) << DEBUG_DTB_SEL_LSB) & DEBUG_DTB_SEL_MASK)
#define DEBUG_DTB_SEL_RESET                                                    0x0
#define DEBUG_TX_VREF_SEL_LSB                                                  0
#define DEBUG_TX_VREF_SEL_MSB                                                  4
#define DEBUG_TX_VREF_SEL_MASK                                                 0x1f
#define DEBUG_TX_VREF_SEL_GET(x)                                               (((x) & DEBUG_TX_VREF_SEL_MASK) >> DEBUG_TX_VREF_SEL_LSB)
#define DEBUG_TX_VREF_SEL_SET(x)                                               (((0 | (x)) << DEBUG_TX_VREF_SEL_LSB) & DEBUG_TX_VREF_SEL_MASK)
#define DEBUG_TX_VREF_SEL_RESET                                                0xa
#define DEBUG_ADDRESS                                                          (0x8 + __PCIE_PHY_REG_BASE_ADDRESS)
#define DEBUG_RSTMASK                                                          0x7f
#define DEBUG_RESET                                                            0xa

// 0xc (RTUNE_DEBUG)
#define RTUNE_DEBUG_VALUE_LSB                                                  5
#define RTUNE_DEBUG_VALUE_MSB                                                  14
#define RTUNE_DEBUG_VALUE_MASK                                                 0x7fe0
#define RTUNE_DEBUG_VALUE_GET(x)                                               (((x) & RTUNE_DEBUG_VALUE_MASK) >> RTUNE_DEBUG_VALUE_LSB)
#define RTUNE_DEBUG_VALUE_SET(x)                                               (((0 | (x)) << RTUNE_DEBUG_VALUE_LSB) & RTUNE_DEBUG_VALUE_MASK)
#define RTUNE_DEBUG_VALUE_RESET                                                0x0
#define RTUNE_DEBUG_TYPE_LSB                                                   3
#define RTUNE_DEBUG_TYPE_MSB                                                   4
#define RTUNE_DEBUG_TYPE_MASK                                                  0x18
#define RTUNE_DEBUG_TYPE_GET(x)                                                (((x) & RTUNE_DEBUG_TYPE_MASK) >> RTUNE_DEBUG_TYPE_LSB)
#define RTUNE_DEBUG_TYPE_SET(x)                                                (((0 | (x)) << RTUNE_DEBUG_TYPE_LSB) & RTUNE_DEBUG_TYPE_MASK)
#define RTUNE_DEBUG_TYPE_RESET                                                 0x0
#define RTUNE_DEBUG_SET_VAL_LSB                                                2
#define RTUNE_DEBUG_SET_VAL_MSB                                                2
#define RTUNE_DEBUG_SET_VAL_MASK                                               0x4
#define RTUNE_DEBUG_SET_VAL_GET(x)                                             (((x) & RTUNE_DEBUG_SET_VAL_MASK) >> RTUNE_DEBUG_SET_VAL_LSB)
#define RTUNE_DEBUG_SET_VAL_SET(x)                                             (((0 | (x)) << RTUNE_DEBUG_SET_VAL_LSB) & RTUNE_DEBUG_SET_VAL_MASK)
#define RTUNE_DEBUG_SET_VAL_RESET                                              0x0
#define RTUNE_DEBUG_MAN_TUNE_LSB                                               1
#define RTUNE_DEBUG_MAN_TUNE_MSB                                               1
#define RTUNE_DEBUG_MAN_TUNE_MASK                                              0x2
#define RTUNE_DEBUG_MAN_TUNE_GET(x)                                            (((x) & RTUNE_DEBUG_MAN_TUNE_MASK) >> RTUNE_DEBUG_MAN_TUNE_LSB)
#define RTUNE_DEBUG_MAN_TUNE_SET(x)                                            (((0 | (x)) << RTUNE_DEBUG_MAN_TUNE_LSB) & RTUNE_DEBUG_MAN_TUNE_MASK)
#define RTUNE_DEBUG_MAN_TUNE_RESET                                             0x0
#define RTUNE_DEBUG_FLIP_COMP_LSB                                              0
#define RTUNE_DEBUG_FLIP_COMP_MSB                                              0
#define RTUNE_DEBUG_FLIP_COMP_MASK                                             0x1
#define RTUNE_DEBUG_FLIP_COMP_GET(x)                                           (((x) & RTUNE_DEBUG_FLIP_COMP_MASK) >> RTUNE_DEBUG_FLIP_COMP_LSB)
#define RTUNE_DEBUG_FLIP_COMP_SET(x)                                           (((0 | (x)) << RTUNE_DEBUG_FLIP_COMP_LSB) & RTUNE_DEBUG_FLIP_COMP_MASK)
#define RTUNE_DEBUG_FLIP_COMP_RESET                                            0x0
#define RTUNE_DEBUG_ADDRESS                                                    (0xc + __PCIE_PHY_REG_BASE_ADDRESS)
#define RTUNE_DEBUG_RSTMASK                                                    0x7fff
#define RTUNE_DEBUG_RESET                                                      0x0

// 0x10 (RTUNE_STAT)
#define RTUNE_STAT_STAT_LSB                                                    0
#define RTUNE_STAT_STAT_MSB                                                    9
#define RTUNE_STAT_STAT_MASK                                                   0x3ff
#define RTUNE_STAT_STAT_GET(x)                                                 (((x) & RTUNE_STAT_STAT_MASK) >> RTUNE_STAT_STAT_LSB)
#define RTUNE_STAT_STAT_SET(x)                                                 (((0 | (x)) << RTUNE_STAT_STAT_LSB) & RTUNE_STAT_STAT_MASK)
#define RTUNE_STAT_STAT_RESET                                                  0x0
#define RTUNE_STAT_ADDRESS                                                     (0x10 + __PCIE_PHY_REG_BASE_ADDRESS)
#define RTUNE_STAT_RSTMASK                                                     0x3ff
#define RTUNE_STAT_RESET                                                       0x0

// 0x14 (SS_PHASE)
#define SS_PHASE_REF_SEL_DIV_LSB                                               13
#define SS_PHASE_REF_SEL_DIV_MSB                                               15
#define SS_PHASE_REF_SEL_DIV_MASK                                              0xe000
#define SS_PHASE_REF_SEL_DIV_GET(x)                                            (((x) & SS_PHASE_REF_SEL_DIV_MASK) >> SS_PHASE_REF_SEL_DIV_LSB)
#define SS_PHASE_REF_SEL_DIV_SET(x)                                            (((0 | (x)) << SS_PHASE_REF_SEL_DIV_LSB) & SS_PHASE_REF_SEL_DIV_MASK)
#define SS_PHASE_REF_SEL_DIV_RESET                                             0x4
#define SS_PHASE_PH_SEL_LSB                                                    12
#define SS_PHASE_PH_SEL_MSB                                                    12
#define SS_PHASE_PH_SEL_MASK                                                   0x1000
#define SS_PHASE_PH_SEL_GET(x)                                                 (((x) & SS_PHASE_PH_SEL_MASK) >> SS_PHASE_PH_SEL_LSB)
#define SS_PHASE_PH_SEL_SET(x)                                                 (((0 | (x)) << SS_PHASE_PH_SEL_LSB) & SS_PHASE_PH_SEL_MASK)
#define SS_PHASE_PH_SEL_RESET                                                  0x0
#define SS_PHASE_ZERO_FREQ_LSB                                                 11
#define SS_PHASE_ZERO_FREQ_MSB                                                 11
#define SS_PHASE_ZERO_FREQ_MASK                                                0x800
#define SS_PHASE_ZERO_FREQ_GET(x)                                              (((x) & SS_PHASE_ZERO_FREQ_MASK) >> SS_PHASE_ZERO_FREQ_LSB)
#define SS_PHASE_ZERO_FREQ_SET(x)                                              (((0 | (x)) << SS_PHASE_ZERO_FREQ_LSB) & SS_PHASE_ZERO_FREQ_MASK)
#define SS_PHASE_ZERO_FREQ_RESET                                               0x0
#define SS_PHASE_VAL_LSB                                                       2
#define SS_PHASE_VAL_MSB                                                       10
#define SS_PHASE_VAL_MASK                                                      0x7fc
#define SS_PHASE_VAL_GET(x)                                                    (((x) & SS_PHASE_VAL_MASK) >> SS_PHASE_VAL_LSB)
#define SS_PHASE_VAL_SET(x)                                                    (((0 | (x)) << SS_PHASE_VAL_LSB) & SS_PHASE_VAL_MASK)
#define SS_PHASE_VAL_RESET                                                     0x0
#define SS_PHASE_DTHR_LSB                                                      0
#define SS_PHASE_DTHR_MSB                                                      1
#define SS_PHASE_DTHR_MASK                                                     0x3
#define SS_PHASE_DTHR_GET(x)                                                   (((x) & SS_PHASE_DTHR_MASK) >> SS_PHASE_DTHR_LSB)
#define SS_PHASE_DTHR_SET(x)                                                   (((0 | (x)) << SS_PHASE_DTHR_LSB) & SS_PHASE_DTHR_MASK)
#define SS_PHASE_DTHR_RESET                                                    0x0
#define SS_PHASE_ADDRESS                                                       (0x14 + __PCIE_PHY_REG_BASE_ADDRESS)
#define SS_PHASE_RSTMASK                                                       0xffff
#define SS_PHASE_RESET                                                         0x8000

// 0x18 (SS_FREQ)
#define SS_FREQ_FREQ_OVRD_LSB                                                  14
#define SS_FREQ_FREQ_OVRD_MSB                                                  14
#define SS_FREQ_FREQ_OVRD_MASK                                                 0x4000
#define SS_FREQ_FREQ_OVRD_GET(x)                                               (((x) & SS_FREQ_FREQ_OVRD_MASK) >> SS_FREQ_FREQ_OVRD_LSB)
#define SS_FREQ_FREQ_OVRD_SET(x)                                               (((0 | (x)) << SS_FREQ_FREQ_OVRD_LSB) & SS_FREQ_FREQ_OVRD_MASK)
#define SS_FREQ_FREQ_OVRD_RESET                                                0x0
#define SS_FREQ_FREQ_PK_LSB                                                    7
#define SS_FREQ_FREQ_PK_MSB                                                    13
#define SS_FREQ_FREQ_PK_MASK                                                   0x3f80
#define SS_FREQ_FREQ_PK_GET(x)                                                 (((x) & SS_FREQ_FREQ_PK_MASK) >> SS_FREQ_FREQ_PK_LSB)
#define SS_FREQ_FREQ_PK_SET(x)                                                 (((0 | (x)) << SS_FREQ_FREQ_PK_LSB) & SS_FREQ_FREQ_PK_MASK)
#define SS_FREQ_FREQ_PK_RESET                                                  0x66
#define SS_FREQ_FREQ_CNT_INIT_LSB                                              0
#define SS_FREQ_FREQ_CNT_INIT_MSB                                              6
#define SS_FREQ_FREQ_CNT_INIT_MASK                                             0x7f
#define SS_FREQ_FREQ_CNT_INIT_GET(x)                                           (((x) & SS_FREQ_FREQ_CNT_INIT_MASK) >> SS_FREQ_FREQ_CNT_INIT_LSB)
#define SS_FREQ_FREQ_CNT_INIT_SET(x)                                           (((0 | (x)) << SS_FREQ_FREQ_CNT_INIT_LSB) & SS_FREQ_FREQ_CNT_INIT_MASK)
#define SS_FREQ_FREQ_CNT_INIT_RESET                                            0x27
#define SS_FREQ_ADDRESS                                                        (0x18 + __PCIE_PHY_REG_BASE_ADDRESS)
#define SS_FREQ_RSTMASK                                                        0x7fff
#define SS_FREQ_RESET                                                          0x3327

// 0x40 (ATEOVRD)
#define ATEOVRD_ATEOVRD_EN_LSB                                                 2
#define ATEOVRD_ATEOVRD_EN_MSB                                                 2
#define ATEOVRD_ATEOVRD_EN_MASK                                                0x4
#define ATEOVRD_ATEOVRD_EN_GET(x)                                              (((x) & ATEOVRD_ATEOVRD_EN_MASK) >> ATEOVRD_ATEOVRD_EN_LSB)
#define ATEOVRD_ATEOVRD_EN_SET(x)                                              (((0 | (x)) << ATEOVRD_ATEOVRD_EN_LSB) & ATEOVRD_ATEOVRD_EN_MASK)
#define ATEOVRD_ATEOVRD_EN_RESET                                               0x0
#define ATEOVRD_REF_USB2_EN_LSB                                                1
#define ATEOVRD_REF_USB2_EN_MSB                                                1
#define ATEOVRD_REF_USB2_EN_MASK                                               0x2
#define ATEOVRD_REF_USB2_EN_GET(x)                                             (((x) & ATEOVRD_REF_USB2_EN_MASK) >> ATEOVRD_REF_USB2_EN_LSB)
#define ATEOVRD_REF_USB2_EN_SET(x)                                             (((0 | (x)) << ATEOVRD_REF_USB2_EN_LSB) & ATEOVRD_REF_USB2_EN_MASK)
#define ATEOVRD_REF_USB2_EN_RESET                                              0x0
#define ATEOVRD_REF_CLKDIV2_LSB                                                0
#define ATEOVRD_REF_CLKDIV2_MSB                                                0
#define ATEOVRD_REF_CLKDIV2_MASK                                               0x1
#define ATEOVRD_REF_CLKDIV2_GET(x)                                             (((x) & ATEOVRD_REF_CLKDIV2_MASK) >> ATEOVRD_REF_CLKDIV2_LSB)
#define ATEOVRD_REF_CLKDIV2_SET(x)                                             (((0 | (x)) << ATEOVRD_REF_CLKDIV2_LSB) & ATEOVRD_REF_CLKDIV2_MASK)
#define ATEOVRD_REF_CLKDIV2_RESET                                              0x0
#define ATEOVRD_ADDRESS                                                        (0x40 + __PCIE_PHY_REG_BASE_ADDRESS)
#define ATEOVRD_RSTMASK                                                        0x7
#define ATEOVRD_RESET                                                          0x0

// 0x44 (MPLL_OVRD_IN_LO)
#define MPLL_OVRD_IN_LO_RES_ACK_IN_OVRD_LSB                                    15
#define MPLL_OVRD_IN_LO_RES_ACK_IN_OVRD_MSB                                    15
#define MPLL_OVRD_IN_LO_RES_ACK_IN_OVRD_MASK                                   0x8000
#define MPLL_OVRD_IN_LO_RES_ACK_IN_OVRD_GET(x)                                 (((x) & MPLL_OVRD_IN_LO_RES_ACK_IN_OVRD_MASK) >> MPLL_OVRD_IN_LO_RES_ACK_IN_OVRD_LSB)
#define MPLL_OVRD_IN_LO_RES_ACK_IN_OVRD_SET(x)                                 (((0 | (x)) << MPLL_OVRD_IN_LO_RES_ACK_IN_OVRD_LSB) & MPLL_OVRD_IN_LO_RES_ACK_IN_OVRD_MASK)
#define MPLL_OVRD_IN_LO_RES_ACK_IN_OVRD_RESET                                  0x0
#define MPLL_OVRD_IN_LO_RES_ACK_IN_LSB                                         14
#define MPLL_OVRD_IN_LO_RES_ACK_IN_MSB                                         14
#define MPLL_OVRD_IN_LO_RES_ACK_IN_MASK                                        0x4000
#define MPLL_OVRD_IN_LO_RES_ACK_IN_GET(x)                                      (((x) & MPLL_OVRD_IN_LO_RES_ACK_IN_MASK) >> MPLL_OVRD_IN_LO_RES_ACK_IN_LSB)
#define MPLL_OVRD_IN_LO_RES_ACK_IN_SET(x)                                      (((0 | (x)) << MPLL_OVRD_IN_LO_RES_ACK_IN_LSB) & MPLL_OVRD_IN_LO_RES_ACK_IN_MASK)
#define MPLL_OVRD_IN_LO_RES_ACK_IN_RESET                                       0x0
#define MPLL_OVRD_IN_LO_RES_REQ_IN_OVRD_LSB                                    13
#define MPLL_OVRD_IN_LO_RES_REQ_IN_OVRD_MSB                                    13
#define MPLL_OVRD_IN_LO_RES_REQ_IN_OVRD_MASK                                   0x2000
#define MPLL_OVRD_IN_LO_RES_REQ_IN_OVRD_GET(x)                                 (((x) & MPLL_OVRD_IN_LO_RES_REQ_IN_OVRD_MASK) >> MPLL_OVRD_IN_LO_RES_REQ_IN_OVRD_LSB)
#define MPLL_OVRD_IN_LO_RES_REQ_IN_OVRD_SET(x)                                 (((0 | (x)) << MPLL_OVRD_IN_LO_RES_REQ_IN_OVRD_LSB) & MPLL_OVRD_IN_LO_RES_REQ_IN_OVRD_MASK)
#define MPLL_OVRD_IN_LO_RES_REQ_IN_OVRD_RESET                                  0x0
#define MPLL_OVRD_IN_LO_RES_REQ_IN_LSB                                         12
#define MPLL_OVRD_IN_LO_RES_REQ_IN_MSB                                         12
#define MPLL_OVRD_IN_LO_RES_REQ_IN_MASK                                        0x1000
#define MPLL_OVRD_IN_LO_RES_REQ_IN_GET(x)                                      (((x) & MPLL_OVRD_IN_LO_RES_REQ_IN_MASK) >> MPLL_OVRD_IN_LO_RES_REQ_IN_LSB)
#define MPLL_OVRD_IN_LO_RES_REQ_IN_SET(x)                                      (((0 | (x)) << MPLL_OVRD_IN_LO_RES_REQ_IN_LSB) & MPLL_OVRD_IN_LO_RES_REQ_IN_MASK)
#define MPLL_OVRD_IN_LO_RES_REQ_IN_RESET                                       0x0
#define MPLL_OVRD_IN_LO_RTUNE_REQ_OVRD_LSB                                     11
#define MPLL_OVRD_IN_LO_RTUNE_REQ_OVRD_MSB                                     11
#define MPLL_OVRD_IN_LO_RTUNE_REQ_OVRD_MASK                                    0x800
#define MPLL_OVRD_IN_LO_RTUNE_REQ_OVRD_GET(x)                                  (((x) & MPLL_OVRD_IN_LO_RTUNE_REQ_OVRD_MASK) >> MPLL_OVRD_IN_LO_RTUNE_REQ_OVRD_LSB)
#define MPLL_OVRD_IN_LO_RTUNE_REQ_OVRD_SET(x)                                  (((0 | (x)) << MPLL_OVRD_IN_LO_RTUNE_REQ_OVRD_LSB) & MPLL_OVRD_IN_LO_RTUNE_REQ_OVRD_MASK)
#define MPLL_OVRD_IN_LO_RTUNE_REQ_OVRD_RESET                                   0x0
#define MPLL_OVRD_IN_LO_RTUNE_REQ_LSB                                          10
#define MPLL_OVRD_IN_LO_RTUNE_REQ_MSB                                          10
#define MPLL_OVRD_IN_LO_RTUNE_REQ_MASK                                         0x400
#define MPLL_OVRD_IN_LO_RTUNE_REQ_GET(x)                                       (((x) & MPLL_OVRD_IN_LO_RTUNE_REQ_MASK) >> MPLL_OVRD_IN_LO_RTUNE_REQ_LSB)
#define MPLL_OVRD_IN_LO_RTUNE_REQ_SET(x)                                       (((0 | (x)) << MPLL_OVRD_IN_LO_RTUNE_REQ_LSB) & MPLL_OVRD_IN_LO_RTUNE_REQ_MASK)
#define MPLL_OVRD_IN_LO_RTUNE_REQ_RESET                                        0x0
#define MPLL_OVRD_IN_LO_MPLL_MULTIPLIER_OVRD_LSB                               9
#define MPLL_OVRD_IN_LO_MPLL_MULTIPLIER_OVRD_MSB                               9
#define MPLL_OVRD_IN_LO_MPLL_MULTIPLIER_OVRD_MASK                              0x200
#define MPLL_OVRD_IN_LO_MPLL_MULTIPLIER_OVRD_GET(x)                            (((x) & MPLL_OVRD_IN_LO_MPLL_MULTIPLIER_OVRD_MASK) >> MPLL_OVRD_IN_LO_MPLL_MULTIPLIER_OVRD_LSB)
#define MPLL_OVRD_IN_LO_MPLL_MULTIPLIER_OVRD_SET(x)                            (((0 | (x)) << MPLL_OVRD_IN_LO_MPLL_MULTIPLIER_OVRD_LSB) & MPLL_OVRD_IN_LO_MPLL_MULTIPLIER_OVRD_MASK)
#define MPLL_OVRD_IN_LO_MPLL_MULTIPLIER_OVRD_RESET                             0x0
#define MPLL_OVRD_IN_LO_MPLL_MULTIPLIER_LSB                                    2
#define MPLL_OVRD_IN_LO_MPLL_MULTIPLIER_MSB                                    8
#define MPLL_OVRD_IN_LO_MPLL_MULTIPLIER_MASK                                   0x1fc
#define MPLL_OVRD_IN_LO_MPLL_MULTIPLIER_GET(x)                                 (((x) & MPLL_OVRD_IN_LO_MPLL_MULTIPLIER_MASK) >> MPLL_OVRD_IN_LO_MPLL_MULTIPLIER_LSB)
#define MPLL_OVRD_IN_LO_MPLL_MULTIPLIER_SET(x)                                 (((0 | (x)) << MPLL_OVRD_IN_LO_MPLL_MULTIPLIER_LSB) & MPLL_OVRD_IN_LO_MPLL_MULTIPLIER_MASK)
#define MPLL_OVRD_IN_LO_MPLL_MULTIPLIER_RESET                                  0x13
#define MPLL_OVRD_IN_LO_MPLL_EN_OVRD_LSB                                       1
#define MPLL_OVRD_IN_LO_MPLL_EN_OVRD_MSB                                       1
#define MPLL_OVRD_IN_LO_MPLL_EN_OVRD_MASK                                      0x2
#define MPLL_OVRD_IN_LO_MPLL_EN_OVRD_GET(x)                                    (((x) & MPLL_OVRD_IN_LO_MPLL_EN_OVRD_MASK) >> MPLL_OVRD_IN_LO_MPLL_EN_OVRD_LSB)
#define MPLL_OVRD_IN_LO_MPLL_EN_OVRD_SET(x)                                    (((0 | (x)) << MPLL_OVRD_IN_LO_MPLL_EN_OVRD_LSB) & MPLL_OVRD_IN_LO_MPLL_EN_OVRD_MASK)
#define MPLL_OVRD_IN_LO_MPLL_EN_OVRD_RESET                                     0x0
#define MPLL_OVRD_IN_LO_MPLL_EN_LSB                                            0
#define MPLL_OVRD_IN_LO_MPLL_EN_MSB                                            0
#define MPLL_OVRD_IN_LO_MPLL_EN_MASK                                           0x1
#define MPLL_OVRD_IN_LO_MPLL_EN_GET(x)                                         (((x) & MPLL_OVRD_IN_LO_MPLL_EN_MASK) >> MPLL_OVRD_IN_LO_MPLL_EN_LSB)
#define MPLL_OVRD_IN_LO_MPLL_EN_SET(x)                                         (((0 | (x)) << MPLL_OVRD_IN_LO_MPLL_EN_LSB) & MPLL_OVRD_IN_LO_MPLL_EN_MASK)
#define MPLL_OVRD_IN_LO_MPLL_EN_RESET                                          0x0
#define MPLL_OVRD_IN_LO_ADDRESS                                                (0x44 + __PCIE_PHY_REG_BASE_ADDRESS)
#define MPLL_OVRD_IN_LO_RSTMASK                                                0xffff
#define MPLL_OVRD_IN_LO_RESET                                                  0x4c

// 0x48 (MPLL_OVRD_IN_HI)
#define MPLL_OVRD_IN_HI_TX_VBOOST_LVL_LSB                                      13
#define MPLL_OVRD_IN_HI_TX_VBOOST_LVL_MSB                                      15
#define MPLL_OVRD_IN_HI_TX_VBOOST_LVL_MASK                                     0xe000
#define MPLL_OVRD_IN_HI_TX_VBOOST_LVL_GET(x)                                   (((x) & MPLL_OVRD_IN_HI_TX_VBOOST_LVL_MASK) >> MPLL_OVRD_IN_HI_TX_VBOOST_LVL_LSB)
#define MPLL_OVRD_IN_HI_TX_VBOOST_LVL_SET(x)                                   (((0 | (x)) << MPLL_OVRD_IN_HI_TX_VBOOST_LVL_LSB) & MPLL_OVRD_IN_HI_TX_VBOOST_LVL_MASK)
#define MPLL_OVRD_IN_HI_TX_VBOOST_LVL_RESET                                    0x0
#define MPLL_OVRD_IN_HI_MPLL_REFSSC_CLK_EN_OVRD_LSB                            12
#define MPLL_OVRD_IN_HI_MPLL_REFSSC_CLK_EN_OVRD_MSB                            12
#define MPLL_OVRD_IN_HI_MPLL_REFSSC_CLK_EN_OVRD_MASK                           0x1000
#define MPLL_OVRD_IN_HI_MPLL_REFSSC_CLK_EN_OVRD_GET(x)                         (((x) & MPLL_OVRD_IN_HI_MPLL_REFSSC_CLK_EN_OVRD_MASK) >> MPLL_OVRD_IN_HI_MPLL_REFSSC_CLK_EN_OVRD_LSB)
#define MPLL_OVRD_IN_HI_MPLL_REFSSC_CLK_EN_OVRD_SET(x)                         (((0 | (x)) << MPLL_OVRD_IN_HI_MPLL_REFSSC_CLK_EN_OVRD_LSB) & MPLL_OVRD_IN_HI_MPLL_REFSSC_CLK_EN_OVRD_MASK)
#define MPLL_OVRD_IN_HI_MPLL_REFSSC_CLK_EN_OVRD_RESET                          0x0
#define MPLL_OVRD_IN_HI_MPLL_REFSSC_CLK_EN_LSB                                 11
#define MPLL_OVRD_IN_HI_MPLL_REFSSC_CLK_EN_MSB                                 11
#define MPLL_OVRD_IN_HI_MPLL_REFSSC_CLK_EN_MASK                                0x800
#define MPLL_OVRD_IN_HI_MPLL_REFSSC_CLK_EN_GET(x)                              (((x) & MPLL_OVRD_IN_HI_MPLL_REFSSC_CLK_EN_MASK) >> MPLL_OVRD_IN_HI_MPLL_REFSSC_CLK_EN_LSB)
#define MPLL_OVRD_IN_HI_MPLL_REFSSC_CLK_EN_SET(x)                              (((0 | (x)) << MPLL_OVRD_IN_HI_MPLL_REFSSC_CLK_EN_LSB) & MPLL_OVRD_IN_HI_MPLL_REFSSC_CLK_EN_MASK)
#define MPLL_OVRD_IN_HI_MPLL_REFSSC_CLK_EN_RESET                               0x0
#define MPLL_OVRD_IN_HI_MPLL_RST_LSB                                           10
#define MPLL_OVRD_IN_HI_MPLL_RST_MSB                                           10
#define MPLL_OVRD_IN_HI_MPLL_RST_MASK                                          0x400
#define MPLL_OVRD_IN_HI_MPLL_RST_GET(x)                                        (((x) & MPLL_OVRD_IN_HI_MPLL_RST_MASK) >> MPLL_OVRD_IN_HI_MPLL_RST_LSB)
#define MPLL_OVRD_IN_HI_MPLL_RST_SET(x)                                        (((0 | (x)) << MPLL_OVRD_IN_HI_MPLL_RST_LSB) & MPLL_OVRD_IN_HI_MPLL_RST_MASK)
#define MPLL_OVRD_IN_HI_MPLL_RST_RESET                                         0x0
#define MPLL_OVRD_IN_HI_FSEL_OVRD_LSB                                          9
#define MPLL_OVRD_IN_HI_FSEL_OVRD_MSB                                          9
#define MPLL_OVRD_IN_HI_FSEL_OVRD_MASK                                         0x200
#define MPLL_OVRD_IN_HI_FSEL_OVRD_GET(x)                                       (((x) & MPLL_OVRD_IN_HI_FSEL_OVRD_MASK) >> MPLL_OVRD_IN_HI_FSEL_OVRD_LSB)
#define MPLL_OVRD_IN_HI_FSEL_OVRD_SET(x)                                       (((0 | (x)) << MPLL_OVRD_IN_HI_FSEL_OVRD_LSB) & MPLL_OVRD_IN_HI_FSEL_OVRD_MASK)
#define MPLL_OVRD_IN_HI_FSEL_OVRD_RESET                                        0x0
#define MPLL_OVRD_IN_HI_FSEL_LSB                                               6
#define MPLL_OVRD_IN_HI_FSEL_MSB                                               8
#define MPLL_OVRD_IN_HI_FSEL_MASK                                              0x1c0
#define MPLL_OVRD_IN_HI_FSEL_GET(x)                                            (((x) & MPLL_OVRD_IN_HI_FSEL_MASK) >> MPLL_OVRD_IN_HI_FSEL_LSB)
#define MPLL_OVRD_IN_HI_FSEL_SET(x)                                            (((0 | (x)) << MPLL_OVRD_IN_HI_FSEL_LSB) & MPLL_OVRD_IN_HI_FSEL_MASK)
#define MPLL_OVRD_IN_HI_FSEL_RESET                                             0x0
#define MPLL_OVRD_IN_HI_MPLL_WORD_CLK_EN_OVRD_LSB                              5
#define MPLL_OVRD_IN_HI_MPLL_WORD_CLK_EN_OVRD_MSB                              5
#define MPLL_OVRD_IN_HI_MPLL_WORD_CLK_EN_OVRD_MASK                             0x20
#define MPLL_OVRD_IN_HI_MPLL_WORD_CLK_EN_OVRD_GET(x)                           (((x) & MPLL_OVRD_IN_HI_MPLL_WORD_CLK_EN_OVRD_MASK) >> MPLL_OVRD_IN_HI_MPLL_WORD_CLK_EN_OVRD_LSB)
#define MPLL_OVRD_IN_HI_MPLL_WORD_CLK_EN_OVRD_SET(x)                           (((0 | (x)) << MPLL_OVRD_IN_HI_MPLL_WORD_CLK_EN_OVRD_LSB) & MPLL_OVRD_IN_HI_MPLL_WORD_CLK_EN_OVRD_MASK)
#define MPLL_OVRD_IN_HI_MPLL_WORD_CLK_EN_OVRD_RESET                            0x0
#define MPLL_OVRD_IN_HI_MPLL_WORD_CLK_EN_LSB                                   4
#define MPLL_OVRD_IN_HI_MPLL_WORD_CLK_EN_MSB                                   4
#define MPLL_OVRD_IN_HI_MPLL_WORD_CLK_EN_MASK                                  0x10
#define MPLL_OVRD_IN_HI_MPLL_WORD_CLK_EN_GET(x)                                (((x) & MPLL_OVRD_IN_HI_MPLL_WORD_CLK_EN_MASK) >> MPLL_OVRD_IN_HI_MPLL_WORD_CLK_EN_LSB)
#define MPLL_OVRD_IN_HI_MPLL_WORD_CLK_EN_SET(x)                                (((0 | (x)) << MPLL_OVRD_IN_HI_MPLL_WORD_CLK_EN_LSB) & MPLL_OVRD_IN_HI_MPLL_WORD_CLK_EN_MASK)
#define MPLL_OVRD_IN_HI_MPLL_WORD_CLK_EN_RESET                                 0x0
#define MPLL_OVRD_IN_HI_MPLL_DWORD_CLK_EN_OVRD_LSB                             3
#define MPLL_OVRD_IN_HI_MPLL_DWORD_CLK_EN_OVRD_MSB                             3
#define MPLL_OVRD_IN_HI_MPLL_DWORD_CLK_EN_OVRD_MASK                            0x8
#define MPLL_OVRD_IN_HI_MPLL_DWORD_CLK_EN_OVRD_GET(x)                          (((x) & MPLL_OVRD_IN_HI_MPLL_DWORD_CLK_EN_OVRD_MASK) >> MPLL_OVRD_IN_HI_MPLL_DWORD_CLK_EN_OVRD_LSB)
#define MPLL_OVRD_IN_HI_MPLL_DWORD_CLK_EN_OVRD_SET(x)                          (((0 | (x)) << MPLL_OVRD_IN_HI_MPLL_DWORD_CLK_EN_OVRD_LSB) & MPLL_OVRD_IN_HI_MPLL_DWORD_CLK_EN_OVRD_MASK)
#define MPLL_OVRD_IN_HI_MPLL_DWORD_CLK_EN_OVRD_RESET                           0x0
#define MPLL_OVRD_IN_HI_MPLL_DWORD_CLK_EN_LSB                                  2
#define MPLL_OVRD_IN_HI_MPLL_DWORD_CLK_EN_MSB                                  2
#define MPLL_OVRD_IN_HI_MPLL_DWORD_CLK_EN_MASK                                 0x4
#define MPLL_OVRD_IN_HI_MPLL_DWORD_CLK_EN_GET(x)                               (((x) & MPLL_OVRD_IN_HI_MPLL_DWORD_CLK_EN_MASK) >> MPLL_OVRD_IN_HI_MPLL_DWORD_CLK_EN_LSB)
#define MPLL_OVRD_IN_HI_MPLL_DWORD_CLK_EN_SET(x)                               (((0 | (x)) << MPLL_OVRD_IN_HI_MPLL_DWORD_CLK_EN_LSB) & MPLL_OVRD_IN_HI_MPLL_DWORD_CLK_EN_MASK)
#define MPLL_OVRD_IN_HI_MPLL_DWORD_CLK_EN_RESET                                0x0
#define MPLL_OVRD_IN_HI_MPLL_QWORD_CLK_EN_OVRD_LSB                             1
#define MPLL_OVRD_IN_HI_MPLL_QWORD_CLK_EN_OVRD_MSB                             1
#define MPLL_OVRD_IN_HI_MPLL_QWORD_CLK_EN_OVRD_MASK                            0x2
#define MPLL_OVRD_IN_HI_MPLL_QWORD_CLK_EN_OVRD_GET(x)                          (((x) & MPLL_OVRD_IN_HI_MPLL_QWORD_CLK_EN_OVRD_MASK) >> MPLL_OVRD_IN_HI_MPLL_QWORD_CLK_EN_OVRD_LSB)
#define MPLL_OVRD_IN_HI_MPLL_QWORD_CLK_EN_OVRD_SET(x)                          (((0 | (x)) << MPLL_OVRD_IN_HI_MPLL_QWORD_CLK_EN_OVRD_LSB) & MPLL_OVRD_IN_HI_MPLL_QWORD_CLK_EN_OVRD_MASK)
#define MPLL_OVRD_IN_HI_MPLL_QWORD_CLK_EN_OVRD_RESET                           0x0
#define MPLL_OVRD_IN_HI_MPLL_QWORD_CLK_EN_LSB                                  0
#define MPLL_OVRD_IN_HI_MPLL_QWORD_CLK_EN_MSB                                  0
#define MPLL_OVRD_IN_HI_MPLL_QWORD_CLK_EN_MASK                                 0x1
#define MPLL_OVRD_IN_HI_MPLL_QWORD_CLK_EN_GET(x)                               (((x) & MPLL_OVRD_IN_HI_MPLL_QWORD_CLK_EN_MASK) >> MPLL_OVRD_IN_HI_MPLL_QWORD_CLK_EN_LSB)
#define MPLL_OVRD_IN_HI_MPLL_QWORD_CLK_EN_SET(x)                               (((0 | (x)) << MPLL_OVRD_IN_HI_MPLL_QWORD_CLK_EN_LSB) & MPLL_OVRD_IN_HI_MPLL_QWORD_CLK_EN_MASK)
#define MPLL_OVRD_IN_HI_MPLL_QWORD_CLK_EN_RESET                                0x0
#define MPLL_OVRD_IN_HI_ADDRESS                                                (0x48 + __PCIE_PHY_REG_BASE_ADDRESS)
#define MPLL_OVRD_IN_HI_RSTMASK                                                0xffff
#define MPLL_OVRD_IN_HI_RESET                                                  0x0

// 0x4c (SSC_OVRD_IN)
#define SSC_OVRD_IN_SSC_OVRD_IN_EN_LSB                                         13
#define SSC_OVRD_IN_SSC_OVRD_IN_EN_MSB                                         13
#define SSC_OVRD_IN_SSC_OVRD_IN_EN_MASK                                        0x2000
#define SSC_OVRD_IN_SSC_OVRD_IN_EN_GET(x)                                      (((x) & SSC_OVRD_IN_SSC_OVRD_IN_EN_MASK) >> SSC_OVRD_IN_SSC_OVRD_IN_EN_LSB)
#define SSC_OVRD_IN_SSC_OVRD_IN_EN_SET(x)                                      (((0 | (x)) << SSC_OVRD_IN_SSC_OVRD_IN_EN_LSB) & SSC_OVRD_IN_SSC_OVRD_IN_EN_MASK)
#define SSC_OVRD_IN_SSC_OVRD_IN_EN_RESET                                       0x0
#define SSC_OVRD_IN_SSC_EN_LSB                                                 12
#define SSC_OVRD_IN_SSC_EN_MSB                                                 12
#define SSC_OVRD_IN_SSC_EN_MASK                                                0x1000
#define SSC_OVRD_IN_SSC_EN_GET(x)                                              (((x) & SSC_OVRD_IN_SSC_EN_MASK) >> SSC_OVRD_IN_SSC_EN_LSB)
#define SSC_OVRD_IN_SSC_EN_SET(x)                                              (((0 | (x)) << SSC_OVRD_IN_SSC_EN_LSB) & SSC_OVRD_IN_SSC_EN_MASK)
#define SSC_OVRD_IN_SSC_EN_RESET                                               0x0
#define SSC_OVRD_IN_SSC_RANGE_LSB                                              9
#define SSC_OVRD_IN_SSC_RANGE_MSB                                              11
#define SSC_OVRD_IN_SSC_RANGE_MASK                                             0xe00
#define SSC_OVRD_IN_SSC_RANGE_GET(x)                                           (((x) & SSC_OVRD_IN_SSC_RANGE_MASK) >> SSC_OVRD_IN_SSC_RANGE_LSB)
#define SSC_OVRD_IN_SSC_RANGE_SET(x)                                           (((0 | (x)) << SSC_OVRD_IN_SSC_RANGE_LSB) & SSC_OVRD_IN_SSC_RANGE_MASK)
#define SSC_OVRD_IN_SSC_RANGE_RESET                                            0x0
#define SSC_OVRD_IN_SSC_REF_CLK_SEL_LSB                                        0
#define SSC_OVRD_IN_SSC_REF_CLK_SEL_MSB                                        8
#define SSC_OVRD_IN_SSC_REF_CLK_SEL_MASK                                       0x1ff
#define SSC_OVRD_IN_SSC_REF_CLK_SEL_GET(x)                                     (((x) & SSC_OVRD_IN_SSC_REF_CLK_SEL_MASK) >> SSC_OVRD_IN_SSC_REF_CLK_SEL_LSB)
#define SSC_OVRD_IN_SSC_REF_CLK_SEL_SET(x)                                     (((0 | (x)) << SSC_OVRD_IN_SSC_REF_CLK_SEL_LSB) & SSC_OVRD_IN_SSC_REF_CLK_SEL_MASK)
#define SSC_OVRD_IN_SSC_REF_CLK_SEL_RESET                                      0x0
#define SSC_OVRD_IN_ADDRESS                                                    (0x4c + __PCIE_PHY_REG_BASE_ADDRESS)
#define SSC_OVRD_IN_RSTMASK                                                    0x3fff
#define SSC_OVRD_IN_RESET                                                      0x0

// 0x50 (BS_OVRD_IN)
#define BS_OVRD_IN_EN_LSB                                                      11
#define BS_OVRD_IN_EN_MSB                                                      11
#define BS_OVRD_IN_EN_MASK                                                     0x800
#define BS_OVRD_IN_EN_GET(x)                                                   (((x) & BS_OVRD_IN_EN_MASK) >> BS_OVRD_IN_EN_LSB)
#define BS_OVRD_IN_EN_SET(x)                                                   (((0 | (x)) << BS_OVRD_IN_EN_LSB) & BS_OVRD_IN_EN_MASK)
#define BS_OVRD_IN_EN_RESET                                                    0x0
#define BS_OVRD_IN_INVERT_LSB                                                  10
#define BS_OVRD_IN_INVERT_MSB                                                  10
#define BS_OVRD_IN_INVERT_MASK                                                 0x400
#define BS_OVRD_IN_INVERT_GET(x)                                               (((x) & BS_OVRD_IN_INVERT_MASK) >> BS_OVRD_IN_INVERT_LSB)
#define BS_OVRD_IN_INVERT_SET(x)                                               (((0 | (x)) << BS_OVRD_IN_INVERT_LSB) & BS_OVRD_IN_INVERT_MASK)
#define BS_OVRD_IN_INVERT_RESET                                                0x0
#define BS_OVRD_IN_INIT_LSB                                                    9
#define BS_OVRD_IN_INIT_MSB                                                    9
#define BS_OVRD_IN_INIT_MASK                                                   0x200
#define BS_OVRD_IN_INIT_GET(x)                                                 (((x) & BS_OVRD_IN_INIT_MASK) >> BS_OVRD_IN_INIT_LSB)
#define BS_OVRD_IN_INIT_SET(x)                                                 (((0 | (x)) << BS_OVRD_IN_INIT_LSB) & BS_OVRD_IN_INIT_MASK)
#define BS_OVRD_IN_INIT_RESET                                                  0x0
#define BS_OVRD_IN_HIGHZ_LSB                                                   8
#define BS_OVRD_IN_HIGHZ_MSB                                                   8
#define BS_OVRD_IN_HIGHZ_MASK                                                  0x100
#define BS_OVRD_IN_HIGHZ_GET(x)                                                (((x) & BS_OVRD_IN_HIGHZ_MASK) >> BS_OVRD_IN_HIGHZ_LSB)
#define BS_OVRD_IN_HIGHZ_SET(x)                                                (((0 | (x)) << BS_OVRD_IN_HIGHZ_LSB) & BS_OVRD_IN_HIGHZ_MASK)
#define BS_OVRD_IN_HIGHZ_RESET                                                 0x0
#define BS_OVRD_IN_CLAMP_LSB                                                   7
#define BS_OVRD_IN_CLAMP_MSB                                                   7
#define BS_OVRD_IN_CLAMP_MASK                                                  0x80
#define BS_OVRD_IN_CLAMP_GET(x)                                                (((x) & BS_OVRD_IN_CLAMP_MASK) >> BS_OVRD_IN_CLAMP_LSB)
#define BS_OVRD_IN_CLAMP_SET(x)                                                (((0 | (x)) << BS_OVRD_IN_CLAMP_LSB) & BS_OVRD_IN_CLAMP_MASK)
#define BS_OVRD_IN_CLAMP_RESET                                                 0x0
#define BS_OVRD_IN_EXTEST_AC_LSB                                               6
#define BS_OVRD_IN_EXTEST_AC_MSB                                               6
#define BS_OVRD_IN_EXTEST_AC_MASK                                              0x40
#define BS_OVRD_IN_EXTEST_AC_GET(x)                                            (((x) & BS_OVRD_IN_EXTEST_AC_MASK) >> BS_OVRD_IN_EXTEST_AC_LSB)
#define BS_OVRD_IN_EXTEST_AC_SET(x)                                            (((0 | (x)) << BS_OVRD_IN_EXTEST_AC_LSB) & BS_OVRD_IN_EXTEST_AC_MASK)
#define BS_OVRD_IN_EXTEST_AC_RESET                                             0x0
#define BS_OVRD_IN_EXTEST_LSB                                                  5
#define BS_OVRD_IN_EXTEST_MSB                                                  5
#define BS_OVRD_IN_EXTEST_MASK                                                 0x20
#define BS_OVRD_IN_EXTEST_GET(x)                                               (((x) & BS_OVRD_IN_EXTEST_MASK) >> BS_OVRD_IN_EXTEST_LSB)
#define BS_OVRD_IN_EXTEST_SET(x)                                               (((0 | (x)) << BS_OVRD_IN_EXTEST_LSB) & BS_OVRD_IN_EXTEST_MASK)
#define BS_OVRD_IN_EXTEST_RESET                                                0x0
#define BS_OVRD_IN_PRELOAD_LSB                                                 4
#define BS_OVRD_IN_PRELOAD_MSB                                                 4
#define BS_OVRD_IN_PRELOAD_MASK                                                0x10
#define BS_OVRD_IN_PRELOAD_GET(x)                                              (((x) & BS_OVRD_IN_PRELOAD_MASK) >> BS_OVRD_IN_PRELOAD_LSB)
#define BS_OVRD_IN_PRELOAD_SET(x)                                              (((0 | (x)) << BS_OVRD_IN_PRELOAD_LSB) & BS_OVRD_IN_PRELOAD_MASK)
#define BS_OVRD_IN_PRELOAD_RESET                                               0x0
#define BS_OVRD_IN_UPDATE_DR_LSB                                               3
#define BS_OVRD_IN_UPDATE_DR_MSB                                               3
#define BS_OVRD_IN_UPDATE_DR_MASK                                              0x8
#define BS_OVRD_IN_UPDATE_DR_GET(x)                                            (((x) & BS_OVRD_IN_UPDATE_DR_MASK) >> BS_OVRD_IN_UPDATE_DR_LSB)
#define BS_OVRD_IN_UPDATE_DR_SET(x)                                            (((0 | (x)) << BS_OVRD_IN_UPDATE_DR_LSB) & BS_OVRD_IN_UPDATE_DR_MASK)
#define BS_OVRD_IN_UPDATE_DR_RESET                                             0x0
#define BS_OVRD_IN_CAPTURE_DR_LSB                                              2
#define BS_OVRD_IN_CAPTURE_DR_MSB                                              2
#define BS_OVRD_IN_CAPTURE_DR_MASK                                             0x4
#define BS_OVRD_IN_CAPTURE_DR_GET(x)                                           (((x) & BS_OVRD_IN_CAPTURE_DR_MASK) >> BS_OVRD_IN_CAPTURE_DR_LSB)
#define BS_OVRD_IN_CAPTURE_DR_SET(x)                                           (((0 | (x)) << BS_OVRD_IN_CAPTURE_DR_LSB) & BS_OVRD_IN_CAPTURE_DR_MASK)
#define BS_OVRD_IN_CAPTURE_DR_RESET                                            0x0
#define BS_OVRD_IN_SHIFT_DR_LSB                                                1
#define BS_OVRD_IN_SHIFT_DR_MSB                                                1
#define BS_OVRD_IN_SHIFT_DR_MASK                                               0x2
#define BS_OVRD_IN_SHIFT_DR_GET(x)                                             (((x) & BS_OVRD_IN_SHIFT_DR_MASK) >> BS_OVRD_IN_SHIFT_DR_LSB)
#define BS_OVRD_IN_SHIFT_DR_SET(x)                                             (((0 | (x)) << BS_OVRD_IN_SHIFT_DR_LSB) & BS_OVRD_IN_SHIFT_DR_MASK)
#define BS_OVRD_IN_SHIFT_DR_RESET                                              0x0
#define BS_OVRD_IN_IN_LSB                                                      0
#define BS_OVRD_IN_IN_MSB                                                      0
#define BS_OVRD_IN_IN_MASK                                                     0x1
#define BS_OVRD_IN_IN_GET(x)                                                   (((x) & BS_OVRD_IN_IN_MASK) >> BS_OVRD_IN_IN_LSB)
#define BS_OVRD_IN_IN_SET(x)                                                   (((0 | (x)) << BS_OVRD_IN_IN_LSB) & BS_OVRD_IN_IN_MASK)
#define BS_OVRD_IN_IN_RESET                                                    0x0
#define BS_OVRD_IN_ADDRESS                                                     (0x50 + __PCIE_PHY_REG_BASE_ADDRESS)
#define BS_OVRD_IN_RSTMASK                                                     0xfff
#define BS_OVRD_IN_RESET                                                       0x0

// 0x54 (LEVEL_OVRD_IN)
#define LEVEL_OVRD_IN_LOS_BIAS_LSB                                             13
#define LEVEL_OVRD_IN_LOS_BIAS_MSB                                             15
#define LEVEL_OVRD_IN_LOS_BIAS_MASK                                            0xe000
#define LEVEL_OVRD_IN_LOS_BIAS_GET(x)                                          (((x) & LEVEL_OVRD_IN_LOS_BIAS_MASK) >> LEVEL_OVRD_IN_LOS_BIAS_LSB)
#define LEVEL_OVRD_IN_LOS_BIAS_SET(x)                                          (((0 | (x)) << LEVEL_OVRD_IN_LOS_BIAS_LSB) & LEVEL_OVRD_IN_LOS_BIAS_MASK)
#define LEVEL_OVRD_IN_LOS_BIAS_RESET                                           0x0
#define LEVEL_OVRD_IN_MPLL_HALF_RATE_OVRD_LSB                                  12
#define LEVEL_OVRD_IN_MPLL_HALF_RATE_OVRD_MSB                                  12
#define LEVEL_OVRD_IN_MPLL_HALF_RATE_OVRD_MASK                                 0x1000
#define LEVEL_OVRD_IN_MPLL_HALF_RATE_OVRD_GET(x)                               (((x) & LEVEL_OVRD_IN_MPLL_HALF_RATE_OVRD_MASK) >> LEVEL_OVRD_IN_MPLL_HALF_RATE_OVRD_LSB)
#define LEVEL_OVRD_IN_MPLL_HALF_RATE_OVRD_SET(x)                               (((0 | (x)) << LEVEL_OVRD_IN_MPLL_HALF_RATE_OVRD_LSB) & LEVEL_OVRD_IN_MPLL_HALF_RATE_OVRD_MASK)
#define LEVEL_OVRD_IN_MPLL_HALF_RATE_OVRD_RESET                                0x0
#define LEVEL_OVRD_IN_MPLL_HALF_RATE_LSB                                       11
#define LEVEL_OVRD_IN_MPLL_HALF_RATE_MSB                                       11
#define LEVEL_OVRD_IN_MPLL_HALF_RATE_MASK                                      0x800
#define LEVEL_OVRD_IN_MPLL_HALF_RATE_GET(x)                                    (((x) & LEVEL_OVRD_IN_MPLL_HALF_RATE_MASK) >> LEVEL_OVRD_IN_MPLL_HALF_RATE_LSB)
#define LEVEL_OVRD_IN_MPLL_HALF_RATE_SET(x)                                    (((0 | (x)) << LEVEL_OVRD_IN_MPLL_HALF_RATE_LSB) & LEVEL_OVRD_IN_MPLL_HALF_RATE_MASK)
#define LEVEL_OVRD_IN_MPLL_HALF_RATE_RESET                                     0x0
#define LEVEL_OVRD_IN_LEVEL_EN_LSB                                             10
#define LEVEL_OVRD_IN_LEVEL_EN_MSB                                             10
#define LEVEL_OVRD_IN_LEVEL_EN_MASK                                            0x400
#define LEVEL_OVRD_IN_LEVEL_EN_GET(x)                                          (((x) & LEVEL_OVRD_IN_LEVEL_EN_MASK) >> LEVEL_OVRD_IN_LEVEL_EN_LSB)
#define LEVEL_OVRD_IN_LEVEL_EN_SET(x)                                          (((0 | (x)) << LEVEL_OVRD_IN_LEVEL_EN_LSB) & LEVEL_OVRD_IN_LEVEL_EN_MASK)
#define LEVEL_OVRD_IN_LEVEL_EN_RESET                                           0x0
#define LEVEL_OVRD_IN_ACJT_LEVEL_LSB                                           5
#define LEVEL_OVRD_IN_ACJT_LEVEL_MSB                                           9
#define LEVEL_OVRD_IN_ACJT_LEVEL_MASK                                          0x3e0
#define LEVEL_OVRD_IN_ACJT_LEVEL_GET(x)                                        (((x) & LEVEL_OVRD_IN_ACJT_LEVEL_MASK) >> LEVEL_OVRD_IN_ACJT_LEVEL_LSB)
#define LEVEL_OVRD_IN_ACJT_LEVEL_SET(x)                                        (((0 | (x)) << LEVEL_OVRD_IN_ACJT_LEVEL_LSB) & LEVEL_OVRD_IN_ACJT_LEVEL_MASK)
#define LEVEL_OVRD_IN_ACJT_LEVEL_RESET                                         0x0
#define LEVEL_OVRD_IN_LOS_LEVEL_LSB                                            0
#define LEVEL_OVRD_IN_LOS_LEVEL_MSB                                            4
#define LEVEL_OVRD_IN_LOS_LEVEL_MASK                                           0x1f
#define LEVEL_OVRD_IN_LOS_LEVEL_GET(x)                                         (((x) & LEVEL_OVRD_IN_LOS_LEVEL_MASK) >> LEVEL_OVRD_IN_LOS_LEVEL_LSB)
#define LEVEL_OVRD_IN_LOS_LEVEL_SET(x)                                         (((0 | (x)) << LEVEL_OVRD_IN_LOS_LEVEL_LSB) & LEVEL_OVRD_IN_LOS_LEVEL_MASK)
#define LEVEL_OVRD_IN_LOS_LEVEL_RESET                                          0x0
#define LEVEL_OVRD_IN_ADDRESS                                                  (0x54 + __PCIE_PHY_REG_BASE_ADDRESS)
#define LEVEL_OVRD_IN_RSTMASK                                                  0xffff
#define LEVEL_OVRD_IN_RESET                                                    0x0

// 0x58 (SUP_OVRD_OUT)
#define SUP_OVRD_OUT_MPLL_STATE_OVRD_LSB                                       9
#define SUP_OVRD_OUT_MPLL_STATE_OVRD_MSB                                       9
#define SUP_OVRD_OUT_MPLL_STATE_OVRD_MASK                                      0x200
#define SUP_OVRD_OUT_MPLL_STATE_OVRD_GET(x)                                    (((x) & SUP_OVRD_OUT_MPLL_STATE_OVRD_MASK) >> SUP_OVRD_OUT_MPLL_STATE_OVRD_LSB)
#define SUP_OVRD_OUT_MPLL_STATE_OVRD_SET(x)                                    (((0 | (x)) << SUP_OVRD_OUT_MPLL_STATE_OVRD_LSB) & SUP_OVRD_OUT_MPLL_STATE_OVRD_MASK)
#define SUP_OVRD_OUT_MPLL_STATE_OVRD_RESET                                     0x0
#define SUP_OVRD_OUT_MPLL_STATE_LSB                                            8
#define SUP_OVRD_OUT_MPLL_STATE_MSB                                            8
#define SUP_OVRD_OUT_MPLL_STATE_MASK                                           0x100
#define SUP_OVRD_OUT_MPLL_STATE_GET(x)                                         (((x) & SUP_OVRD_OUT_MPLL_STATE_MASK) >> SUP_OVRD_OUT_MPLL_STATE_LSB)
#define SUP_OVRD_OUT_MPLL_STATE_SET(x)                                         (((0 | (x)) << SUP_OVRD_OUT_MPLL_STATE_LSB) & SUP_OVRD_OUT_MPLL_STATE_MASK)
#define SUP_OVRD_OUT_MPLL_STATE_RESET                                          0x1
#define SUP_OVRD_OUT_BS_OUT_OVRD_LSB                                           7
#define SUP_OVRD_OUT_BS_OUT_OVRD_MSB                                           7
#define SUP_OVRD_OUT_BS_OUT_OVRD_MASK                                          0x80
#define SUP_OVRD_OUT_BS_OUT_OVRD_GET(x)                                        (((x) & SUP_OVRD_OUT_BS_OUT_OVRD_MASK) >> SUP_OVRD_OUT_BS_OUT_OVRD_LSB)
#define SUP_OVRD_OUT_BS_OUT_OVRD_SET(x)                                        (((0 | (x)) << SUP_OVRD_OUT_BS_OUT_OVRD_LSB) & SUP_OVRD_OUT_BS_OUT_OVRD_MASK)
#define SUP_OVRD_OUT_BS_OUT_OVRD_RESET                                         0x0
#define SUP_OVRD_OUT_BS_OUT_LSB                                                6
#define SUP_OVRD_OUT_BS_OUT_MSB                                                6
#define SUP_OVRD_OUT_BS_OUT_MASK                                               0x40
#define SUP_OVRD_OUT_BS_OUT_GET(x)                                             (((x) & SUP_OVRD_OUT_BS_OUT_MASK) >> SUP_OVRD_OUT_BS_OUT_LSB)
#define SUP_OVRD_OUT_BS_OUT_SET(x)                                             (((0 | (x)) << SUP_OVRD_OUT_BS_OUT_LSB) & SUP_OVRD_OUT_BS_OUT_MASK)
#define SUP_OVRD_OUT_BS_OUT_RESET                                              0x0
#define SUP_OVRD_OUT_RTUNE_ACK_OVRD_LSB                                        5
#define SUP_OVRD_OUT_RTUNE_ACK_OVRD_MSB                                        5
#define SUP_OVRD_OUT_RTUNE_ACK_OVRD_MASK                                       0x20
#define SUP_OVRD_OUT_RTUNE_ACK_OVRD_GET(x)                                     (((x) & SUP_OVRD_OUT_RTUNE_ACK_OVRD_MASK) >> SUP_OVRD_OUT_RTUNE_ACK_OVRD_LSB)
#define SUP_OVRD_OUT_RTUNE_ACK_OVRD_SET(x)                                     (((0 | (x)) << SUP_OVRD_OUT_RTUNE_ACK_OVRD_LSB) & SUP_OVRD_OUT_RTUNE_ACK_OVRD_MASK)
#define SUP_OVRD_OUT_RTUNE_ACK_OVRD_RESET                                      0x0
#define SUP_OVRD_OUT_RTUNE_ACK_LSB                                             4
#define SUP_OVRD_OUT_RTUNE_ACK_MSB                                             4
#define SUP_OVRD_OUT_RTUNE_ACK_MASK                                            0x10
#define SUP_OVRD_OUT_RTUNE_ACK_GET(x)                                          (((x) & SUP_OVRD_OUT_RTUNE_ACK_MASK) >> SUP_OVRD_OUT_RTUNE_ACK_LSB)
#define SUP_OVRD_OUT_RTUNE_ACK_SET(x)                                          (((0 | (x)) << SUP_OVRD_OUT_RTUNE_ACK_LSB) & SUP_OVRD_OUT_RTUNE_ACK_MASK)
#define SUP_OVRD_OUT_RTUNE_ACK_RESET                                           0x0
#define SUP_OVRD_OUT_RES_REQ_OUT_OVRD_LSB                                      3
#define SUP_OVRD_OUT_RES_REQ_OUT_OVRD_MSB                                      3
#define SUP_OVRD_OUT_RES_REQ_OUT_OVRD_MASK                                     0x8
#define SUP_OVRD_OUT_RES_REQ_OUT_OVRD_GET(x)                                   (((x) & SUP_OVRD_OUT_RES_REQ_OUT_OVRD_MASK) >> SUP_OVRD_OUT_RES_REQ_OUT_OVRD_LSB)
#define SUP_OVRD_OUT_RES_REQ_OUT_OVRD_SET(x)                                   (((0 | (x)) << SUP_OVRD_OUT_RES_REQ_OUT_OVRD_LSB) & SUP_OVRD_OUT_RES_REQ_OUT_OVRD_MASK)
#define SUP_OVRD_OUT_RES_REQ_OUT_OVRD_RESET                                    0x0
#define SUP_OVRD_OUT_RES_REQ_OUT_LSB                                           2
#define SUP_OVRD_OUT_RES_REQ_OUT_MSB                                           2
#define SUP_OVRD_OUT_RES_REQ_OUT_MASK                                          0x4
#define SUP_OVRD_OUT_RES_REQ_OUT_GET(x)                                        (((x) & SUP_OVRD_OUT_RES_REQ_OUT_MASK) >> SUP_OVRD_OUT_RES_REQ_OUT_LSB)
#define SUP_OVRD_OUT_RES_REQ_OUT_SET(x)                                        (((0 | (x)) << SUP_OVRD_OUT_RES_REQ_OUT_LSB) & SUP_OVRD_OUT_RES_REQ_OUT_MASK)
#define SUP_OVRD_OUT_RES_REQ_OUT_RESET                                         0x0
#define SUP_OVRD_OUT_RES_ACK_OUT_OVRD_LSB                                      1
#define SUP_OVRD_OUT_RES_ACK_OUT_OVRD_MSB                                      1
#define SUP_OVRD_OUT_RES_ACK_OUT_OVRD_MASK                                     0x2
#define SUP_OVRD_OUT_RES_ACK_OUT_OVRD_GET(x)                                   (((x) & SUP_OVRD_OUT_RES_ACK_OUT_OVRD_MASK) >> SUP_OVRD_OUT_RES_ACK_OUT_OVRD_LSB)
#define SUP_OVRD_OUT_RES_ACK_OUT_OVRD_SET(x)                                   (((0 | (x)) << SUP_OVRD_OUT_RES_ACK_OUT_OVRD_LSB) & SUP_OVRD_OUT_RES_ACK_OUT_OVRD_MASK)
#define SUP_OVRD_OUT_RES_ACK_OUT_OVRD_RESET                                    0x0
#define SUP_OVRD_OUT_RES_ACK_OUT_LSB                                           0
#define SUP_OVRD_OUT_RES_ACK_OUT_MSB                                           0
#define SUP_OVRD_OUT_RES_ACK_OUT_MASK                                          0x1
#define SUP_OVRD_OUT_RES_ACK_OUT_GET(x)                                        (((x) & SUP_OVRD_OUT_RES_ACK_OUT_MASK) >> SUP_OVRD_OUT_RES_ACK_OUT_LSB)
#define SUP_OVRD_OUT_RES_ACK_OUT_SET(x)                                        (((0 | (x)) << SUP_OVRD_OUT_RES_ACK_OUT_LSB) & SUP_OVRD_OUT_RES_ACK_OUT_MASK)
#define SUP_OVRD_OUT_RES_ACK_OUT_RESET                                         0x1
#define SUP_OVRD_OUT_ADDRESS                                                   (0x58 + __PCIE_PHY_REG_BASE_ADDRESS)
#define SUP_OVRD_OUT_RSTMASK                                                   0x3ff
#define SUP_OVRD_OUT_RESET                                                     0x101

// 0x5c (MPLL_ASIC_IN)
#define MPLL_ASIC_IN_MPLL_REFSSC_CLK_EN_LSB                                    14
#define MPLL_ASIC_IN_MPLL_REFSSC_CLK_EN_MSB                                    14
#define MPLL_ASIC_IN_MPLL_REFSSC_CLK_EN_MASK                                   0x4000
#define MPLL_ASIC_IN_MPLL_REFSSC_CLK_EN_GET(x)                                 (((x) & MPLL_ASIC_IN_MPLL_REFSSC_CLK_EN_MASK) >> MPLL_ASIC_IN_MPLL_REFSSC_CLK_EN_LSB)
#define MPLL_ASIC_IN_MPLL_REFSSC_CLK_EN_SET(x)                                 (((0 | (x)) << MPLL_ASIC_IN_MPLL_REFSSC_CLK_EN_LSB) & MPLL_ASIC_IN_MPLL_REFSSC_CLK_EN_MASK)
#define MPLL_ASIC_IN_MPLL_REFSSC_CLK_EN_RESET                                  0x0
#define MPLL_ASIC_IN_MPLL_WORD_CLK_EN_LSB                                      13
#define MPLL_ASIC_IN_MPLL_WORD_CLK_EN_MSB                                      13
#define MPLL_ASIC_IN_MPLL_WORD_CLK_EN_MASK                                     0x2000
#define MPLL_ASIC_IN_MPLL_WORD_CLK_EN_GET(x)                                   (((x) & MPLL_ASIC_IN_MPLL_WORD_CLK_EN_MASK) >> MPLL_ASIC_IN_MPLL_WORD_CLK_EN_LSB)
#define MPLL_ASIC_IN_MPLL_WORD_CLK_EN_SET(x)                                   (((0 | (x)) << MPLL_ASIC_IN_MPLL_WORD_CLK_EN_LSB) & MPLL_ASIC_IN_MPLL_WORD_CLK_EN_MASK)
#define MPLL_ASIC_IN_MPLL_WORD_CLK_EN_RESET                                    0x0
#define MPLL_ASIC_IN_MPLL_DWORD_CLK_EN_LSB                                     12
#define MPLL_ASIC_IN_MPLL_DWORD_CLK_EN_MSB                                     12
#define MPLL_ASIC_IN_MPLL_DWORD_CLK_EN_MASK                                    0x1000
#define MPLL_ASIC_IN_MPLL_DWORD_CLK_EN_GET(x)                                  (((x) & MPLL_ASIC_IN_MPLL_DWORD_CLK_EN_MASK) >> MPLL_ASIC_IN_MPLL_DWORD_CLK_EN_LSB)
#define MPLL_ASIC_IN_MPLL_DWORD_CLK_EN_SET(x)                                  (((0 | (x)) << MPLL_ASIC_IN_MPLL_DWORD_CLK_EN_LSB) & MPLL_ASIC_IN_MPLL_DWORD_CLK_EN_MASK)
#define MPLL_ASIC_IN_MPLL_DWORD_CLK_EN_RESET                                   0x0
#define MPLL_ASIC_IN_MPLL_QWORD_CLK_EN_LSB                                     11
#define MPLL_ASIC_IN_MPLL_QWORD_CLK_EN_MSB                                     11
#define MPLL_ASIC_IN_MPLL_QWORD_CLK_EN_MASK                                    0x800
#define MPLL_ASIC_IN_MPLL_QWORD_CLK_EN_GET(x)                                  (((x) & MPLL_ASIC_IN_MPLL_QWORD_CLK_EN_MASK) >> MPLL_ASIC_IN_MPLL_QWORD_CLK_EN_LSB)
#define MPLL_ASIC_IN_MPLL_QWORD_CLK_EN_SET(x)                                  (((0 | (x)) << MPLL_ASIC_IN_MPLL_QWORD_CLK_EN_LSB) & MPLL_ASIC_IN_MPLL_QWORD_CLK_EN_MASK)
#define MPLL_ASIC_IN_MPLL_QWORD_CLK_EN_RESET                                   0x0
#define MPLL_ASIC_IN_RES_ACK_IN_LSB                                            10
#define MPLL_ASIC_IN_RES_ACK_IN_MSB                                            10
#define MPLL_ASIC_IN_RES_ACK_IN_MASK                                           0x400
#define MPLL_ASIC_IN_RES_ACK_IN_GET(x)                                         (((x) & MPLL_ASIC_IN_RES_ACK_IN_MASK) >> MPLL_ASIC_IN_RES_ACK_IN_LSB)
#define MPLL_ASIC_IN_RES_ACK_IN_SET(x)                                         (((0 | (x)) << MPLL_ASIC_IN_RES_ACK_IN_LSB) & MPLL_ASIC_IN_RES_ACK_IN_MASK)
#define MPLL_ASIC_IN_RES_ACK_IN_RESET                                          0x0
#define MPLL_ASIC_IN_RES_REQ_IN_LSB                                            9
#define MPLL_ASIC_IN_RES_REQ_IN_MSB                                            9
#define MPLL_ASIC_IN_RES_REQ_IN_MASK                                           0x200
#define MPLL_ASIC_IN_RES_REQ_IN_GET(x)                                         (((x) & MPLL_ASIC_IN_RES_REQ_IN_MASK) >> MPLL_ASIC_IN_RES_REQ_IN_LSB)
#define MPLL_ASIC_IN_RES_REQ_IN_SET(x)                                         (((0 | (x)) << MPLL_ASIC_IN_RES_REQ_IN_LSB) & MPLL_ASIC_IN_RES_REQ_IN_MASK)
#define MPLL_ASIC_IN_RES_REQ_IN_RESET                                          0x0
#define MPLL_ASIC_IN_RTUNE_REQ_LSB                                             8
#define MPLL_ASIC_IN_RTUNE_REQ_MSB                                             8
#define MPLL_ASIC_IN_RTUNE_REQ_MASK                                            0x100
#define MPLL_ASIC_IN_RTUNE_REQ_GET(x)                                          (((x) & MPLL_ASIC_IN_RTUNE_REQ_MASK) >> MPLL_ASIC_IN_RTUNE_REQ_LSB)
#define MPLL_ASIC_IN_RTUNE_REQ_SET(x)                                          (((0 | (x)) << MPLL_ASIC_IN_RTUNE_REQ_LSB) & MPLL_ASIC_IN_RTUNE_REQ_MASK)
#define MPLL_ASIC_IN_RTUNE_REQ_RESET                                           0x0
#define MPLL_ASIC_IN_MPLL_MULTIPLIER_LSB                                       1
#define MPLL_ASIC_IN_MPLL_MULTIPLIER_MSB                                       7
#define MPLL_ASIC_IN_MPLL_MULTIPLIER_MASK                                      0xfe
#define MPLL_ASIC_IN_MPLL_MULTIPLIER_GET(x)                                    (((x) & MPLL_ASIC_IN_MPLL_MULTIPLIER_MASK) >> MPLL_ASIC_IN_MPLL_MULTIPLIER_LSB)
#define MPLL_ASIC_IN_MPLL_MULTIPLIER_SET(x)                                    (((0 | (x)) << MPLL_ASIC_IN_MPLL_MULTIPLIER_LSB) & MPLL_ASIC_IN_MPLL_MULTIPLIER_MASK)
#define MPLL_ASIC_IN_MPLL_MULTIPLIER_RESET                                     0x0
#define MPLL_ASIC_IN_MPLL_EN_LSB                                               0
#define MPLL_ASIC_IN_MPLL_EN_MSB                                               0
#define MPLL_ASIC_IN_MPLL_EN_MASK                                              0x1
#define MPLL_ASIC_IN_MPLL_EN_GET(x)                                            (((x) & MPLL_ASIC_IN_MPLL_EN_MASK) >> MPLL_ASIC_IN_MPLL_EN_LSB)
#define MPLL_ASIC_IN_MPLL_EN_SET(x)                                            (((0 | (x)) << MPLL_ASIC_IN_MPLL_EN_LSB) & MPLL_ASIC_IN_MPLL_EN_MASK)
#define MPLL_ASIC_IN_MPLL_EN_RESET                                             0x0
#define MPLL_ASIC_IN_ADDRESS                                                   (0x5c + __PCIE_PHY_REG_BASE_ADDRESS)
#define MPLL_ASIC_IN_RSTMASK                                                   0x7fff
#define MPLL_ASIC_IN_RESET                                                     0x0

// 0x60 (BS_ASIC_IN)
#define BS_ASIC_IN_TX_VBOOST_LVL_LSB                                           11
#define BS_ASIC_IN_TX_VBOOST_LVL_MSB                                           13
#define BS_ASIC_IN_TX_VBOOST_LVL_MASK                                          0x3800
#define BS_ASIC_IN_TX_VBOOST_LVL_GET(x)                                        (((x) & BS_ASIC_IN_TX_VBOOST_LVL_MASK) >> BS_ASIC_IN_TX_VBOOST_LVL_LSB)
#define BS_ASIC_IN_TX_VBOOST_LVL_SET(x)                                        (((0 | (x)) << BS_ASIC_IN_TX_VBOOST_LVL_LSB) & BS_ASIC_IN_TX_VBOOST_LVL_MASK)
#define BS_ASIC_IN_TX_VBOOST_LVL_RESET                                         0x0
#define BS_ASIC_IN_INVERT_LSB                                                  10
#define BS_ASIC_IN_INVERT_MSB                                                  10
#define BS_ASIC_IN_INVERT_MASK                                                 0x400
#define BS_ASIC_IN_INVERT_GET(x)                                               (((x) & BS_ASIC_IN_INVERT_MASK) >> BS_ASIC_IN_INVERT_LSB)
#define BS_ASIC_IN_INVERT_SET(x)                                               (((0 | (x)) << BS_ASIC_IN_INVERT_LSB) & BS_ASIC_IN_INVERT_MASK)
#define BS_ASIC_IN_INVERT_RESET                                                0x0
#define BS_ASIC_IN_INIT_LSB                                                    9
#define BS_ASIC_IN_INIT_MSB                                                    9
#define BS_ASIC_IN_INIT_MASK                                                   0x200
#define BS_ASIC_IN_INIT_GET(x)                                                 (((x) & BS_ASIC_IN_INIT_MASK) >> BS_ASIC_IN_INIT_LSB)
#define BS_ASIC_IN_INIT_SET(x)                                                 (((0 | (x)) << BS_ASIC_IN_INIT_LSB) & BS_ASIC_IN_INIT_MASK)
#define BS_ASIC_IN_INIT_RESET                                                  0x0
#define BS_ASIC_IN_HIGHZ_LSB                                                   8
#define BS_ASIC_IN_HIGHZ_MSB                                                   8
#define BS_ASIC_IN_HIGHZ_MASK                                                  0x100
#define BS_ASIC_IN_HIGHZ_GET(x)                                                (((x) & BS_ASIC_IN_HIGHZ_MASK) >> BS_ASIC_IN_HIGHZ_LSB)
#define BS_ASIC_IN_HIGHZ_SET(x)                                                (((0 | (x)) << BS_ASIC_IN_HIGHZ_LSB) & BS_ASIC_IN_HIGHZ_MASK)
#define BS_ASIC_IN_HIGHZ_RESET                                                 0x0
#define BS_ASIC_IN_CLAMP_LSB                                                   7
#define BS_ASIC_IN_CLAMP_MSB                                                   7
#define BS_ASIC_IN_CLAMP_MASK                                                  0x80
#define BS_ASIC_IN_CLAMP_GET(x)                                                (((x) & BS_ASIC_IN_CLAMP_MASK) >> BS_ASIC_IN_CLAMP_LSB)
#define BS_ASIC_IN_CLAMP_SET(x)                                                (((0 | (x)) << BS_ASIC_IN_CLAMP_LSB) & BS_ASIC_IN_CLAMP_MASK)
#define BS_ASIC_IN_CLAMP_RESET                                                 0x0
#define BS_ASIC_IN_EXTEST_AC_LSB                                               6
#define BS_ASIC_IN_EXTEST_AC_MSB                                               6
#define BS_ASIC_IN_EXTEST_AC_MASK                                              0x40
#define BS_ASIC_IN_EXTEST_AC_GET(x)                                            (((x) & BS_ASIC_IN_EXTEST_AC_MASK) >> BS_ASIC_IN_EXTEST_AC_LSB)
#define BS_ASIC_IN_EXTEST_AC_SET(x)                                            (((0 | (x)) << BS_ASIC_IN_EXTEST_AC_LSB) & BS_ASIC_IN_EXTEST_AC_MASK)
#define BS_ASIC_IN_EXTEST_AC_RESET                                             0x0
#define BS_ASIC_IN_EXTEST_LSB                                                  5
#define BS_ASIC_IN_EXTEST_MSB                                                  5
#define BS_ASIC_IN_EXTEST_MASK                                                 0x20
#define BS_ASIC_IN_EXTEST_GET(x)                                               (((x) & BS_ASIC_IN_EXTEST_MASK) >> BS_ASIC_IN_EXTEST_LSB)
#define BS_ASIC_IN_EXTEST_SET(x)                                               (((0 | (x)) << BS_ASIC_IN_EXTEST_LSB) & BS_ASIC_IN_EXTEST_MASK)
#define BS_ASIC_IN_EXTEST_RESET                                                0x0
#define BS_ASIC_IN_PRELOAD_LSB                                                 4
#define BS_ASIC_IN_PRELOAD_MSB                                                 4
#define BS_ASIC_IN_PRELOAD_MASK                                                0x10
#define BS_ASIC_IN_PRELOAD_GET(x)                                              (((x) & BS_ASIC_IN_PRELOAD_MASK) >> BS_ASIC_IN_PRELOAD_LSB)
#define BS_ASIC_IN_PRELOAD_SET(x)                                              (((0 | (x)) << BS_ASIC_IN_PRELOAD_LSB) & BS_ASIC_IN_PRELOAD_MASK)
#define BS_ASIC_IN_PRELOAD_RESET                                               0x0
#define BS_ASIC_IN_UPDATE_DR_LSB                                               3
#define BS_ASIC_IN_UPDATE_DR_MSB                                               3
#define BS_ASIC_IN_UPDATE_DR_MASK                                              0x8
#define BS_ASIC_IN_UPDATE_DR_GET(x)                                            (((x) & BS_ASIC_IN_UPDATE_DR_MASK) >> BS_ASIC_IN_UPDATE_DR_LSB)
#define BS_ASIC_IN_UPDATE_DR_SET(x)                                            (((0 | (x)) << BS_ASIC_IN_UPDATE_DR_LSB) & BS_ASIC_IN_UPDATE_DR_MASK)
#define BS_ASIC_IN_UPDATE_DR_RESET                                             0x0
#define BS_ASIC_IN_CAPTURE_DR_LSB                                              2
#define BS_ASIC_IN_CAPTURE_DR_MSB                                              2
#define BS_ASIC_IN_CAPTURE_DR_MASK                                             0x4
#define BS_ASIC_IN_CAPTURE_DR_GET(x)                                           (((x) & BS_ASIC_IN_CAPTURE_DR_MASK) >> BS_ASIC_IN_CAPTURE_DR_LSB)
#define BS_ASIC_IN_CAPTURE_DR_SET(x)                                           (((0 | (x)) << BS_ASIC_IN_CAPTURE_DR_LSB) & BS_ASIC_IN_CAPTURE_DR_MASK)
#define BS_ASIC_IN_CAPTURE_DR_RESET                                            0x0
#define BS_ASIC_IN_SHIFT_DR_LSB                                                1
#define BS_ASIC_IN_SHIFT_DR_MSB                                                1
#define BS_ASIC_IN_SHIFT_DR_MASK                                               0x2
#define BS_ASIC_IN_SHIFT_DR_GET(x)                                             (((x) & BS_ASIC_IN_SHIFT_DR_MASK) >> BS_ASIC_IN_SHIFT_DR_LSB)
#define BS_ASIC_IN_SHIFT_DR_SET(x)                                             (((0 | (x)) << BS_ASIC_IN_SHIFT_DR_LSB) & BS_ASIC_IN_SHIFT_DR_MASK)
#define BS_ASIC_IN_SHIFT_DR_RESET                                              0x0
#define BS_ASIC_IN_IN_LSB                                                      0
#define BS_ASIC_IN_IN_MSB                                                      0
#define BS_ASIC_IN_IN_MASK                                                     0x1
#define BS_ASIC_IN_IN_GET(x)                                                   (((x) & BS_ASIC_IN_IN_MASK) >> BS_ASIC_IN_IN_LSB)
#define BS_ASIC_IN_IN_SET(x)                                                   (((0 | (x)) << BS_ASIC_IN_IN_LSB) & BS_ASIC_IN_IN_MASK)
#define BS_ASIC_IN_IN_RESET                                                    0x0
#define BS_ASIC_IN_ADDRESS                                                     (0x60 + __PCIE_PHY_REG_BASE_ADDRESS)
#define BS_ASIC_IN_RSTMASK                                                     0x3fff
#define BS_ASIC_IN_RESET                                                       0x0

// 0x64 (LEVEL_ASIC_IN)
#define LEVEL_ASIC_IN_LOS_BIAS_LSB                                             12
#define LEVEL_ASIC_IN_LOS_BIAS_MSB                                             14
#define LEVEL_ASIC_IN_LOS_BIAS_MASK                                            0x7000
#define LEVEL_ASIC_IN_LOS_BIAS_GET(x)                                          (((x) & LEVEL_ASIC_IN_LOS_BIAS_MASK) >> LEVEL_ASIC_IN_LOS_BIAS_LSB)
#define LEVEL_ASIC_IN_LOS_BIAS_SET(x)                                          (((0 | (x)) << LEVEL_ASIC_IN_LOS_BIAS_LSB) & LEVEL_ASIC_IN_LOS_BIAS_MASK)
#define LEVEL_ASIC_IN_LOS_BIAS_RESET                                           0x0
#define LEVEL_ASIC_IN_MPLL_HALF_RATE_LSB                                       11
#define LEVEL_ASIC_IN_MPLL_HALF_RATE_MSB                                       11
#define LEVEL_ASIC_IN_MPLL_HALF_RATE_MASK                                      0x800
#define LEVEL_ASIC_IN_MPLL_HALF_RATE_GET(x)                                    (((x) & LEVEL_ASIC_IN_MPLL_HALF_RATE_MASK) >> LEVEL_ASIC_IN_MPLL_HALF_RATE_LSB)
#define LEVEL_ASIC_IN_MPLL_HALF_RATE_SET(x)                                    (((0 | (x)) << LEVEL_ASIC_IN_MPLL_HALF_RATE_LSB) & LEVEL_ASIC_IN_MPLL_HALF_RATE_MASK)
#define LEVEL_ASIC_IN_MPLL_HALF_RATE_RESET                                     0x0
#define LEVEL_ASIC_IN_VREG_BYPASS_LSB                                          10
#define LEVEL_ASIC_IN_VREG_BYPASS_MSB                                          10
#define LEVEL_ASIC_IN_VREG_BYPASS_MASK                                         0x400
#define LEVEL_ASIC_IN_VREG_BYPASS_GET(x)                                       (((x) & LEVEL_ASIC_IN_VREG_BYPASS_MASK) >> LEVEL_ASIC_IN_VREG_BYPASS_LSB)
#define LEVEL_ASIC_IN_VREG_BYPASS_SET(x)                                       (((0 | (x)) << LEVEL_ASIC_IN_VREG_BYPASS_LSB) & LEVEL_ASIC_IN_VREG_BYPASS_MASK)
#define LEVEL_ASIC_IN_VREG_BYPASS_RESET                                        0x0
#define LEVEL_ASIC_IN_ACJT_LEVEL_LSB                                           5
#define LEVEL_ASIC_IN_ACJT_LEVEL_MSB                                           9
#define LEVEL_ASIC_IN_ACJT_LEVEL_MASK                                          0x3e0
#define LEVEL_ASIC_IN_ACJT_LEVEL_GET(x)                                        (((x) & LEVEL_ASIC_IN_ACJT_LEVEL_MASK) >> LEVEL_ASIC_IN_ACJT_LEVEL_LSB)
#define LEVEL_ASIC_IN_ACJT_LEVEL_SET(x)                                        (((0 | (x)) << LEVEL_ASIC_IN_ACJT_LEVEL_LSB) & LEVEL_ASIC_IN_ACJT_LEVEL_MASK)
#define LEVEL_ASIC_IN_ACJT_LEVEL_RESET                                         0x0
#define LEVEL_ASIC_IN_LOS_LEVEL_LSB                                            0
#define LEVEL_ASIC_IN_LOS_LEVEL_MSB                                            4
#define LEVEL_ASIC_IN_LOS_LEVEL_MASK                                           0x1f
#define LEVEL_ASIC_IN_LOS_LEVEL_GET(x)                                         (((x) & LEVEL_ASIC_IN_LOS_LEVEL_MASK) >> LEVEL_ASIC_IN_LOS_LEVEL_LSB)
#define LEVEL_ASIC_IN_LOS_LEVEL_SET(x)                                         (((0 | (x)) << LEVEL_ASIC_IN_LOS_LEVEL_LSB) & LEVEL_ASIC_IN_LOS_LEVEL_MASK)
#define LEVEL_ASIC_IN_LOS_LEVEL_RESET                                          0x0
#define LEVEL_ASIC_IN_ADDRESS                                                  (0x64 + __PCIE_PHY_REG_BASE_ADDRESS)
#define LEVEL_ASIC_IN_RSTMASK                                                  0x7fff
#define LEVEL_ASIC_IN_RESET                                                    0x0

// 0x68 (SSC_ASIC_IN)
#define SSC_ASIC_IN_SS_EN_LSB                                                  15
#define SSC_ASIC_IN_SS_EN_MSB                                                  15
#define SSC_ASIC_IN_SS_EN_MASK                                                 0x8000
#define SSC_ASIC_IN_SS_EN_GET(x)                                               (((x) & SSC_ASIC_IN_SS_EN_MASK) >> SSC_ASIC_IN_SS_EN_LSB)
#define SSC_ASIC_IN_SS_EN_SET(x)                                               (((0 | (x)) << SSC_ASIC_IN_SS_EN_LSB) & SSC_ASIC_IN_SS_EN_MASK)
#define SSC_ASIC_IN_SS_EN_RESET                                                0x0
#define SSC_ASIC_IN_SSC_RANGE_LSB                                              12
#define SSC_ASIC_IN_SSC_RANGE_MSB                                              14
#define SSC_ASIC_IN_SSC_RANGE_MASK                                             0x7000
#define SSC_ASIC_IN_SSC_RANGE_GET(x)                                           (((x) & SSC_ASIC_IN_SSC_RANGE_MASK) >> SSC_ASIC_IN_SSC_RANGE_LSB)
#define SSC_ASIC_IN_SSC_RANGE_SET(x)                                           (((0 | (x)) << SSC_ASIC_IN_SSC_RANGE_LSB) & SSC_ASIC_IN_SSC_RANGE_MASK)
#define SSC_ASIC_IN_SSC_RANGE_RESET                                            0x0
#define SSC_ASIC_IN_SSC_REF_CLK_SEL_LSB                                        3
#define SSC_ASIC_IN_SSC_REF_CLK_SEL_MSB                                        11
#define SSC_ASIC_IN_SSC_REF_CLK_SEL_MASK                                       0xff8
#define SSC_ASIC_IN_SSC_REF_CLK_SEL_GET(x)                                     (((x) & SSC_ASIC_IN_SSC_REF_CLK_SEL_MASK) >> SSC_ASIC_IN_SSC_REF_CLK_SEL_LSB)
#define SSC_ASIC_IN_SSC_REF_CLK_SEL_SET(x)                                     (((0 | (x)) << SSC_ASIC_IN_SSC_REF_CLK_SEL_LSB) & SSC_ASIC_IN_SSC_REF_CLK_SEL_MASK)
#define SSC_ASIC_IN_SSC_REF_CLK_SEL_RESET                                      0x0
#define SSC_ASIC_IN_FSEL_LSB                                                   0
#define SSC_ASIC_IN_FSEL_MSB                                                   2
#define SSC_ASIC_IN_FSEL_MASK                                                  0x7
#define SSC_ASIC_IN_FSEL_GET(x)                                                (((x) & SSC_ASIC_IN_FSEL_MASK) >> SSC_ASIC_IN_FSEL_LSB)
#define SSC_ASIC_IN_FSEL_SET(x)                                                (((0 | (x)) << SSC_ASIC_IN_FSEL_LSB) & SSC_ASIC_IN_FSEL_MASK)
#define SSC_ASIC_IN_FSEL_RESET                                                 0x0
#define SSC_ASIC_IN_ADDRESS                                                    (0x68 + __PCIE_PHY_REG_BASE_ADDRESS)
#define SSC_ASIC_IN_RSTMASK                                                    0xffff
#define SSC_ASIC_IN_RESET                                                      0x0

// 0x6c (SUP_ASIC_OUT)
#define SUP_ASIC_OUT_MPLL_STATE_LSB                                            4
#define SUP_ASIC_OUT_MPLL_STATE_MSB                                            4
#define SUP_ASIC_OUT_MPLL_STATE_MASK                                           0x10
#define SUP_ASIC_OUT_MPLL_STATE_GET(x)                                         (((x) & SUP_ASIC_OUT_MPLL_STATE_MASK) >> SUP_ASIC_OUT_MPLL_STATE_LSB)
#define SUP_ASIC_OUT_MPLL_STATE_SET(x)                                         (((0 | (x)) << SUP_ASIC_OUT_MPLL_STATE_LSB) & SUP_ASIC_OUT_MPLL_STATE_MASK)
#define SUP_ASIC_OUT_MPLL_STATE_RESET                                          0x0
#define SUP_ASIC_OUT_BS_OUT_LSB                                                3
#define SUP_ASIC_OUT_BS_OUT_MSB                                                3
#define SUP_ASIC_OUT_BS_OUT_MASK                                               0x8
#define SUP_ASIC_OUT_BS_OUT_GET(x)                                             (((x) & SUP_ASIC_OUT_BS_OUT_MASK) >> SUP_ASIC_OUT_BS_OUT_LSB)
#define SUP_ASIC_OUT_BS_OUT_SET(x)                                             (((0 | (x)) << SUP_ASIC_OUT_BS_OUT_LSB) & SUP_ASIC_OUT_BS_OUT_MASK)
#define SUP_ASIC_OUT_BS_OUT_RESET                                              0x0
#define SUP_ASIC_OUT_RTUNE_ACK_LSB                                             2
#define SUP_ASIC_OUT_RTUNE_ACK_MSB                                             2
#define SUP_ASIC_OUT_RTUNE_ACK_MASK                                            0x4
#define SUP_ASIC_OUT_RTUNE_ACK_GET(x)                                          (((x) & SUP_ASIC_OUT_RTUNE_ACK_MASK) >> SUP_ASIC_OUT_RTUNE_ACK_LSB)
#define SUP_ASIC_OUT_RTUNE_ACK_SET(x)                                          (((0 | (x)) << SUP_ASIC_OUT_RTUNE_ACK_LSB) & SUP_ASIC_OUT_RTUNE_ACK_MASK)
#define SUP_ASIC_OUT_RTUNE_ACK_RESET                                           0x0
#define SUP_ASIC_OUT_RES_REQ_OUT_LSB                                           1
#define SUP_ASIC_OUT_RES_REQ_OUT_MSB                                           1
#define SUP_ASIC_OUT_RES_REQ_OUT_MASK                                          0x2
#define SUP_ASIC_OUT_RES_REQ_OUT_GET(x)                                        (((x) & SUP_ASIC_OUT_RES_REQ_OUT_MASK) >> SUP_ASIC_OUT_RES_REQ_OUT_LSB)
#define SUP_ASIC_OUT_RES_REQ_OUT_SET(x)                                        (((0 | (x)) << SUP_ASIC_OUT_RES_REQ_OUT_LSB) & SUP_ASIC_OUT_RES_REQ_OUT_MASK)
#define SUP_ASIC_OUT_RES_REQ_OUT_RESET                                         0x0
#define SUP_ASIC_OUT_RES_ACK_OUT_LSB                                           0
#define SUP_ASIC_OUT_RES_ACK_OUT_MSB                                           0
#define SUP_ASIC_OUT_RES_ACK_OUT_MASK                                          0x1
#define SUP_ASIC_OUT_RES_ACK_OUT_GET(x)                                        (((x) & SUP_ASIC_OUT_RES_ACK_OUT_MASK) >> SUP_ASIC_OUT_RES_ACK_OUT_LSB)
#define SUP_ASIC_OUT_RES_ACK_OUT_SET(x)                                        (((0 | (x)) << SUP_ASIC_OUT_RES_ACK_OUT_LSB) & SUP_ASIC_OUT_RES_ACK_OUT_MASK)
#define SUP_ASIC_OUT_RES_ACK_OUT_RESET                                         0x0
#define SUP_ASIC_OUT_ADDRESS                                                   (0x6c + __PCIE_PHY_REG_BASE_ADDRESS)
#define SUP_ASIC_OUT_RSTMASK                                                   0x1f
#define SUP_ASIC_OUT_RESET                                                     0x0

// 0x70 (ATEOVRD_STATUS)
#define ATEOVRD_STATUS_REF_SSP_EN_LSB                                          7
#define ATEOVRD_STATUS_REF_SSP_EN_MSB                                          7
#define ATEOVRD_STATUS_REF_SSP_EN_MASK                                         0x80
#define ATEOVRD_STATUS_REF_SSP_EN_GET(x)                                       (((x) & ATEOVRD_STATUS_REF_SSP_EN_MASK) >> ATEOVRD_STATUS_REF_SSP_EN_LSB)
#define ATEOVRD_STATUS_REF_SSP_EN_SET(x)                                       (((0 | (x)) << ATEOVRD_STATUS_REF_SSP_EN_LSB) & ATEOVRD_STATUS_REF_SSP_EN_MASK)
#define ATEOVRD_STATUS_REF_SSP_EN_RESET                                        0x0
#define ATEOVRD_STATUS_REF_USE_PAD_LSB                                         6
#define ATEOVRD_STATUS_REF_USE_PAD_MSB                                         6
#define ATEOVRD_STATUS_REF_USE_PAD_MASK                                        0x40
#define ATEOVRD_STATUS_REF_USE_PAD_GET(x)                                      (((x) & ATEOVRD_STATUS_REF_USE_PAD_MASK) >> ATEOVRD_STATUS_REF_USE_PAD_LSB)
#define ATEOVRD_STATUS_REF_USE_PAD_SET(x)                                      (((0 | (x)) << ATEOVRD_STATUS_REF_USE_PAD_LSB) & ATEOVRD_STATUS_REF_USE_PAD_MASK)
#define ATEOVRD_STATUS_REF_USE_PAD_RESET                                       0x0
#define ATEOVRD_STATUS_PHY_RESET_IN_LSB                                        5
#define ATEOVRD_STATUS_PHY_RESET_IN_MSB                                        5
#define ATEOVRD_STATUS_PHY_RESET_IN_MASK                                       0x20
#define ATEOVRD_STATUS_PHY_RESET_IN_GET(x)                                     (((x) & ATEOVRD_STATUS_PHY_RESET_IN_MASK) >> ATEOVRD_STATUS_PHY_RESET_IN_LSB)
#define ATEOVRD_STATUS_PHY_RESET_IN_SET(x)                                     (((0 | (x)) << ATEOVRD_STATUS_PHY_RESET_IN_LSB) & ATEOVRD_STATUS_PHY_RESET_IN_MASK)
#define ATEOVRD_STATUS_PHY_RESET_IN_RESET                                      0x0
#define ATEOVRD_STATUS_REF_CLKDIV2_IN_LSB                                      4
#define ATEOVRD_STATUS_REF_CLKDIV2_IN_MSB                                      4
#define ATEOVRD_STATUS_REF_CLKDIV2_IN_MASK                                     0x10
#define ATEOVRD_STATUS_REF_CLKDIV2_IN_GET(x)                                   (((x) & ATEOVRD_STATUS_REF_CLKDIV2_IN_MASK) >> ATEOVRD_STATUS_REF_CLKDIV2_IN_LSB)
#define ATEOVRD_STATUS_REF_CLKDIV2_IN_SET(x)                                   (((0 | (x)) << ATEOVRD_STATUS_REF_CLKDIV2_IN_LSB) & ATEOVRD_STATUS_REF_CLKDIV2_IN_MASK)
#define ATEOVRD_STATUS_REF_CLKDIV2_IN_RESET                                    0x0
#define ATEOVRD_STATUS_REF_USB2_EN_IN_LSB                                      3
#define ATEOVRD_STATUS_REF_USB2_EN_IN_MSB                                      3
#define ATEOVRD_STATUS_REF_USB2_EN_IN_MASK                                     0x8
#define ATEOVRD_STATUS_REF_USB2_EN_IN_GET(x)                                   (((x) & ATEOVRD_STATUS_REF_USB2_EN_IN_MASK) >> ATEOVRD_STATUS_REF_USB2_EN_IN_LSB)
#define ATEOVRD_STATUS_REF_USB2_EN_IN_SET(x)                                   (((0 | (x)) << ATEOVRD_STATUS_REF_USB2_EN_IN_LSB) & ATEOVRD_STATUS_REF_USB2_EN_IN_MASK)
#define ATEOVRD_STATUS_REF_USB2_EN_IN_RESET                                    0x0
#define ATEOVRD_STATUS_ATEOVRD_EN_LSB                                          2
#define ATEOVRD_STATUS_ATEOVRD_EN_MSB                                          2
#define ATEOVRD_STATUS_ATEOVRD_EN_MASK                                         0x4
#define ATEOVRD_STATUS_ATEOVRD_EN_GET(x)                                       (((x) & ATEOVRD_STATUS_ATEOVRD_EN_MASK) >> ATEOVRD_STATUS_ATEOVRD_EN_LSB)
#define ATEOVRD_STATUS_ATEOVRD_EN_SET(x)                                       (((0 | (x)) << ATEOVRD_STATUS_ATEOVRD_EN_LSB) & ATEOVRD_STATUS_ATEOVRD_EN_MASK)
#define ATEOVRD_STATUS_ATEOVRD_EN_RESET                                        0x0
#define ATEOVRD_STATUS_REF_CLKDIV2_OUT_LSB                                     1
#define ATEOVRD_STATUS_REF_CLKDIV2_OUT_MSB                                     1
#define ATEOVRD_STATUS_REF_CLKDIV2_OUT_MASK                                    0x2
#define ATEOVRD_STATUS_REF_CLKDIV2_OUT_GET(x)                                  (((x) & ATEOVRD_STATUS_REF_CLKDIV2_OUT_MASK) >> ATEOVRD_STATUS_REF_CLKDIV2_OUT_LSB)
#define ATEOVRD_STATUS_REF_CLKDIV2_OUT_SET(x)                                  (((0 | (x)) << ATEOVRD_STATUS_REF_CLKDIV2_OUT_LSB) & ATEOVRD_STATUS_REF_CLKDIV2_OUT_MASK)
#define ATEOVRD_STATUS_REF_CLKDIV2_OUT_RESET                                   0x0
#define ATEOVRD_STATUS_REF_USB2_EN_OUT_LSB                                     0
#define ATEOVRD_STATUS_REF_USB2_EN_OUT_MSB                                     0
#define ATEOVRD_STATUS_REF_USB2_EN_OUT_MASK                                    0x1
#define ATEOVRD_STATUS_REF_USB2_EN_OUT_GET(x)                                  (((x) & ATEOVRD_STATUS_REF_USB2_EN_OUT_MASK) >> ATEOVRD_STATUS_REF_USB2_EN_OUT_LSB)
#define ATEOVRD_STATUS_REF_USB2_EN_OUT_SET(x)                                  (((0 | (x)) << ATEOVRD_STATUS_REF_USB2_EN_OUT_LSB) & ATEOVRD_STATUS_REF_USB2_EN_OUT_MASK)
#define ATEOVRD_STATUS_REF_USB2_EN_OUT_RESET                                   0x0
#define ATEOVRD_STATUS_ADDRESS                                                 (0x70 + __PCIE_PHY_REG_BASE_ADDRESS)
#define ATEOVRD_STATUS_RSTMASK                                                 0xff
#define ATEOVRD_STATUS_RESET                                                   0x0

// 0x80 (SCOPE_ENABLES)
#define SCOPE_ENABLES_LANE_SELECT_LSB                                          3
#define SCOPE_ENABLES_LANE_SELECT_MSB                                          4
#define SCOPE_ENABLES_LANE_SELECT_MASK                                         0x18
#define SCOPE_ENABLES_LANE_SELECT_GET(x)                                       (((x) & SCOPE_ENABLES_LANE_SELECT_MASK) >> SCOPE_ENABLES_LANE_SELECT_LSB)
#define SCOPE_ENABLES_LANE_SELECT_SET(x)                                       (((0 | (x)) << SCOPE_ENABLES_LANE_SELECT_LSB) & SCOPE_ENABLES_LANE_SELECT_MASK)
#define SCOPE_ENABLES_LANE_SELECT_RESET                                        0x0
#define SCOPE_ENABLES_MASK_SATURATION_MODE_LSB                                 2
#define SCOPE_ENABLES_MASK_SATURATION_MODE_MSB                                 2
#define SCOPE_ENABLES_MASK_SATURATION_MODE_MASK                                0x4
#define SCOPE_ENABLES_MASK_SATURATION_MODE_GET(x)                              (((x) & SCOPE_ENABLES_MASK_SATURATION_MODE_MASK) >> SCOPE_ENABLES_MASK_SATURATION_MODE_LSB)
#define SCOPE_ENABLES_MASK_SATURATION_MODE_SET(x)                              (((0 | (x)) << SCOPE_ENABLES_MASK_SATURATION_MODE_LSB) & SCOPE_ENABLES_MASK_SATURATION_MODE_MASK)
#define SCOPE_ENABLES_MASK_SATURATION_MODE_RESET                               0x0
#define SCOPE_ENABLES_MASK_EN_LSB                                              1
#define SCOPE_ENABLES_MASK_EN_MSB                                              1
#define SCOPE_ENABLES_MASK_EN_MASK                                             0x2
#define SCOPE_ENABLES_MASK_EN_GET(x)                                           (((x) & SCOPE_ENABLES_MASK_EN_MASK) >> SCOPE_ENABLES_MASK_EN_LSB)
#define SCOPE_ENABLES_MASK_EN_SET(x)                                           (((0 | (x)) << SCOPE_ENABLES_MASK_EN_LSB) & SCOPE_ENABLES_MASK_EN_MASK)
#define SCOPE_ENABLES_MASK_EN_RESET                                            0x0
#define SCOPE_ENABLES_XOR_EN_LSB                                               0
#define SCOPE_ENABLES_XOR_EN_MSB                                               0
#define SCOPE_ENABLES_XOR_EN_MASK                                              0x1
#define SCOPE_ENABLES_XOR_EN_GET(x)                                            (((x) & SCOPE_ENABLES_XOR_EN_MASK) >> SCOPE_ENABLES_XOR_EN_LSB)
#define SCOPE_ENABLES_XOR_EN_SET(x)                                            (((0 | (x)) << SCOPE_ENABLES_XOR_EN_LSB) & SCOPE_ENABLES_XOR_EN_MASK)
#define SCOPE_ENABLES_XOR_EN_RESET                                             0x0
#define SCOPE_ENABLES_ADDRESS                                                  (0x80 + __PCIE_PHY_REG_BASE_ADDRESS)
#define SCOPE_ENABLES_RSTMASK                                                  0x1f
#define SCOPE_ENABLES_RESET                                                    0x0

// 0x84 (SCOPE_SAMPLES)
#define SCOPE_SAMPLES_SAMPLES_LSB                                              0
#define SCOPE_SAMPLES_SAMPLES_MSB                                              15
#define SCOPE_SAMPLES_SAMPLES_MASK                                             0xffff
#define SCOPE_SAMPLES_SAMPLES_GET(x)                                           (((x) & SCOPE_SAMPLES_SAMPLES_MASK) >> SCOPE_SAMPLES_SAMPLES_LSB)
#define SCOPE_SAMPLES_SAMPLES_SET(x)                                           (((0 | (x)) << SCOPE_SAMPLES_SAMPLES_LSB) & SCOPE_SAMPLES_SAMPLES_MASK)
#define SCOPE_SAMPLES_SAMPLES_RESET                                            0x100
#define SCOPE_SAMPLES_ADDRESS                                                  (0x84 + __PCIE_PHY_REG_BASE_ADDRESS)
#define SCOPE_SAMPLES_RSTMASK                                                  0xffff
#define SCOPE_SAMPLES_RESET                                                    0x100

// 0x88 (SCOPE_COUNT)
#define SCOPE_COUNT_COUNT_LSB                                                  0
#define SCOPE_COUNT_COUNT_MSB                                                  15
#define SCOPE_COUNT_COUNT_MASK                                                 0xffff
#define SCOPE_COUNT_COUNT_GET(x)                                               (((x) & SCOPE_COUNT_COUNT_MASK) >> SCOPE_COUNT_COUNT_LSB)
#define SCOPE_COUNT_COUNT_SET(x)                                               (((0 | (x)) << SCOPE_COUNT_COUNT_LSB) & SCOPE_COUNT_COUNT_MASK)
#define SCOPE_COUNT_COUNT_RESET                                                0x0
#define SCOPE_COUNT_ADDRESS                                                    (0x88 + __PCIE_PHY_REG_BASE_ADDRESS)
#define SCOPE_COUNT_RSTMASK                                                    0xffff
#define SCOPE_COUNT_RESET                                                      0x0

// 0x8c (SCOPE_CTL)
#define SCOPE_CTL_MASK_START_LSB                                               1
#define SCOPE_CTL_MASK_START_MSB                                               1
#define SCOPE_CTL_MASK_START_MASK                                              0x2
#define SCOPE_CTL_MASK_START_GET(x)                                            (((x) & SCOPE_CTL_MASK_START_MASK) >> SCOPE_CTL_MASK_START_LSB)
#define SCOPE_CTL_MASK_START_SET(x)                                            (((0 | (x)) << SCOPE_CTL_MASK_START_LSB) & SCOPE_CTL_MASK_START_MASK)
#define SCOPE_CTL_MASK_START_RESET                                             0x0
#define SCOPE_CTL_MASK_SATURATION_LSB                                          0
#define SCOPE_CTL_MASK_SATURATION_MSB                                          0
#define SCOPE_CTL_MASK_SATURATION_MASK                                         0x1
#define SCOPE_CTL_MASK_SATURATION_GET(x)                                       (((x) & SCOPE_CTL_MASK_SATURATION_MASK) >> SCOPE_CTL_MASK_SATURATION_LSB)
#define SCOPE_CTL_MASK_SATURATION_SET(x)                                       (((0 | (x)) << SCOPE_CTL_MASK_SATURATION_LSB) & SCOPE_CTL_MASK_SATURATION_MASK)
#define SCOPE_CTL_MASK_SATURATION_RESET                                        0x0
#define SCOPE_CTL_ADDRESS                                                      (0x8c + __PCIE_PHY_REG_BASE_ADDRESS)
#define SCOPE_CTL_RSTMASK                                                      0x3
#define SCOPE_CTL_RESET                                                        0x0

// 0x90 (SCOPE_MASK_000)
#define SCOPE_MASK_000_MASK_VAL_000_LSB                                        0
#define SCOPE_MASK_000_MASK_VAL_000_MSB                                        15
#define SCOPE_MASK_000_MASK_VAL_000_MASK                                       0xffff
#define SCOPE_MASK_000_MASK_VAL_000_GET(x)                                     (((x) & SCOPE_MASK_000_MASK_VAL_000_MASK) >> SCOPE_MASK_000_MASK_VAL_000_LSB)
#define SCOPE_MASK_000_MASK_VAL_000_SET(x)                                     (((0 | (x)) << SCOPE_MASK_000_MASK_VAL_000_LSB) & SCOPE_MASK_000_MASK_VAL_000_MASK)
#define SCOPE_MASK_000_MASK_VAL_000_RESET                                      0x0
#define SCOPE_MASK_000_ADDRESS                                                 (0x90 + __PCIE_PHY_REG_BASE_ADDRESS)
#define SCOPE_MASK_000_RSTMASK                                                 0xffff
#define SCOPE_MASK_000_RESET                                                   0x0

// 0x94 (SCOPE_MASK_001)
#define SCOPE_MASK_001_MASK_VAL_001_LSB                                        0
#define SCOPE_MASK_001_MASK_VAL_001_MSB                                        15
#define SCOPE_MASK_001_MASK_VAL_001_MASK                                       0xffff
#define SCOPE_MASK_001_MASK_VAL_001_GET(x)                                     (((x) & SCOPE_MASK_001_MASK_VAL_001_MASK) >> SCOPE_MASK_001_MASK_VAL_001_LSB)
#define SCOPE_MASK_001_MASK_VAL_001_SET(x)                                     (((0 | (x)) << SCOPE_MASK_001_MASK_VAL_001_LSB) & SCOPE_MASK_001_MASK_VAL_001_MASK)
#define SCOPE_MASK_001_MASK_VAL_001_RESET                                      0x0
#define SCOPE_MASK_001_ADDRESS                                                 (0x94 + __PCIE_PHY_REG_BASE_ADDRESS)
#define SCOPE_MASK_001_RSTMASK                                                 0xffff
#define SCOPE_MASK_001_RESET                                                   0x0

// 0x98 (SCOPE_MASK_010)
#define SCOPE_MASK_010_MASK_VAL_010_LSB                                        0
#define SCOPE_MASK_010_MASK_VAL_010_MSB                                        15
#define SCOPE_MASK_010_MASK_VAL_010_MASK                                       0xffff
#define SCOPE_MASK_010_MASK_VAL_010_GET(x)                                     (((x) & SCOPE_MASK_010_MASK_VAL_010_MASK) >> SCOPE_MASK_010_MASK_VAL_010_LSB)
#define SCOPE_MASK_010_MASK_VAL_010_SET(x)                                     (((0 | (x)) << SCOPE_MASK_010_MASK_VAL_010_LSB) & SCOPE_MASK_010_MASK_VAL_010_MASK)
#define SCOPE_MASK_010_MASK_VAL_010_RESET                                      0x0
#define SCOPE_MASK_010_ADDRESS                                                 (0x98 + __PCIE_PHY_REG_BASE_ADDRESS)
#define SCOPE_MASK_010_RSTMASK                                                 0xffff
#define SCOPE_MASK_010_RESET                                                   0x0

// 0x9c (SCOPE_MASK_011)
#define SCOPE_MASK_011_MASK_VAL_011_LSB                                        0
#define SCOPE_MASK_011_MASK_VAL_011_MSB                                        15
#define SCOPE_MASK_011_MASK_VAL_011_MASK                                       0xffff
#define SCOPE_MASK_011_MASK_VAL_011_GET(x)                                     (((x) & SCOPE_MASK_011_MASK_VAL_011_MASK) >> SCOPE_MASK_011_MASK_VAL_011_LSB)
#define SCOPE_MASK_011_MASK_VAL_011_SET(x)                                     (((0 | (x)) << SCOPE_MASK_011_MASK_VAL_011_LSB) & SCOPE_MASK_011_MASK_VAL_011_MASK)
#define SCOPE_MASK_011_MASK_VAL_011_RESET                                      0x0
#define SCOPE_MASK_011_ADDRESS                                                 (0x9c + __PCIE_PHY_REG_BASE_ADDRESS)
#define SCOPE_MASK_011_RSTMASK                                                 0xffff
#define SCOPE_MASK_011_RESET                                                   0x0

// 0xa0 (SCOPE_MASK_100)
#define SCOPE_MASK_100_MASK_VAL_100_LSB                                        0
#define SCOPE_MASK_100_MASK_VAL_100_MSB                                        15
#define SCOPE_MASK_100_MASK_VAL_100_MASK                                       0xffff
#define SCOPE_MASK_100_MASK_VAL_100_GET(x)                                     (((x) & SCOPE_MASK_100_MASK_VAL_100_MASK) >> SCOPE_MASK_100_MASK_VAL_100_LSB)
#define SCOPE_MASK_100_MASK_VAL_100_SET(x)                                     (((0 | (x)) << SCOPE_MASK_100_MASK_VAL_100_LSB) & SCOPE_MASK_100_MASK_VAL_100_MASK)
#define SCOPE_MASK_100_MASK_VAL_100_RESET                                      0x0
#define SCOPE_MASK_100_ADDRESS                                                 (0xa0 + __PCIE_PHY_REG_BASE_ADDRESS)
#define SCOPE_MASK_100_RSTMASK                                                 0xffff
#define SCOPE_MASK_100_RESET                                                   0x0

// 0xa4 (SCOPE_MASK_101)
#define SCOPE_MASK_101_MASK_VAL_101_LSB                                        0
#define SCOPE_MASK_101_MASK_VAL_101_MSB                                        15
#define SCOPE_MASK_101_MASK_VAL_101_MASK                                       0xffff
#define SCOPE_MASK_101_MASK_VAL_101_GET(x)                                     (((x) & SCOPE_MASK_101_MASK_VAL_101_MASK) >> SCOPE_MASK_101_MASK_VAL_101_LSB)
#define SCOPE_MASK_101_MASK_VAL_101_SET(x)                                     (((0 | (x)) << SCOPE_MASK_101_MASK_VAL_101_LSB) & SCOPE_MASK_101_MASK_VAL_101_MASK)
#define SCOPE_MASK_101_MASK_VAL_101_RESET                                      0x0
#define SCOPE_MASK_101_ADDRESS                                                 (0xa4 + __PCIE_PHY_REG_BASE_ADDRESS)
#define SCOPE_MASK_101_RSTMASK                                                 0xffff
#define SCOPE_MASK_101_RESET                                                   0x0

// 0xa8 (SCOPE_MASK_110)
#define SCOPE_MASK_110_MASK_VAL_110_LSB                                        0
#define SCOPE_MASK_110_MASK_VAL_110_MSB                                        15
#define SCOPE_MASK_110_MASK_VAL_110_MASK                                       0xffff
#define SCOPE_MASK_110_MASK_VAL_110_GET(x)                                     (((x) & SCOPE_MASK_110_MASK_VAL_110_MASK) >> SCOPE_MASK_110_MASK_VAL_110_LSB)
#define SCOPE_MASK_110_MASK_VAL_110_SET(x)                                     (((0 | (x)) << SCOPE_MASK_110_MASK_VAL_110_LSB) & SCOPE_MASK_110_MASK_VAL_110_MASK)
#define SCOPE_MASK_110_MASK_VAL_110_RESET                                      0x0
#define SCOPE_MASK_110_ADDRESS                                                 (0xa8 + __PCIE_PHY_REG_BASE_ADDRESS)
#define SCOPE_MASK_110_RSTMASK                                                 0xffff
#define SCOPE_MASK_110_RESET                                                   0x0

// 0xac (SCOPE_MASK_111)
#define SCOPE_MASK_111_MASK_VAL_111_LSB                                        0
#define SCOPE_MASK_111_MASK_VAL_111_MSB                                        15
#define SCOPE_MASK_111_MASK_VAL_111_MASK                                       0xffff
#define SCOPE_MASK_111_MASK_VAL_111_GET(x)                                     (((x) & SCOPE_MASK_111_MASK_VAL_111_MASK) >> SCOPE_MASK_111_MASK_VAL_111_LSB)
#define SCOPE_MASK_111_MASK_VAL_111_SET(x)                                     (((0 | (x)) << SCOPE_MASK_111_MASK_VAL_111_LSB) & SCOPE_MASK_111_MASK_VAL_111_MASK)
#define SCOPE_MASK_111_MASK_VAL_111_RESET                                      0x0
#define SCOPE_MASK_111_ADDRESS                                                 (0xac + __PCIE_PHY_REG_BASE_ADDRESS)
#define SCOPE_MASK_111_RSTMASK                                                 0xffff
#define SCOPE_MASK_111_RESET                                                   0x0

// 0xc0 (MPLL_LOOP_CTL)
#define MPLL_LOOP_CTL_PROP_CNTRL_LSB                                           4
#define MPLL_LOOP_CTL_PROP_CNTRL_MSB                                           7
#define MPLL_LOOP_CTL_PROP_CNTRL_MASK                                          0xf0
#define MPLL_LOOP_CTL_PROP_CNTRL_GET(x)                                        (((x) & MPLL_LOOP_CTL_PROP_CNTRL_MASK) >> MPLL_LOOP_CTL_PROP_CNTRL_LSB)
#define MPLL_LOOP_CTL_PROP_CNTRL_SET(x)                                        (((0 | (x)) << MPLL_LOOP_CTL_PROP_CNTRL_LSB) & MPLL_LOOP_CTL_PROP_CNTRL_MASK)
#define MPLL_LOOP_CTL_PROP_CNTRL_RESET                                         0xe
#define MPLL_LOOP_CTL_INT_CNTRL_LSB                                            2
#define MPLL_LOOP_CTL_INT_CNTRL_MSB                                            3
#define MPLL_LOOP_CTL_INT_CNTRL_MASK                                           0xc
#define MPLL_LOOP_CTL_INT_CNTRL_GET(x)                                         (((x) & MPLL_LOOP_CTL_INT_CNTRL_MASK) >> MPLL_LOOP_CTL_INT_CNTRL_LSB)
#define MPLL_LOOP_CTL_INT_CNTRL_SET(x)                                         (((0 | (x)) << MPLL_LOOP_CTL_INT_CNTRL_LSB) & MPLL_LOOP_CTL_INT_CNTRL_MASK)
#define MPLL_LOOP_CTL_INT_CNTRL_RESET                                          0x0
#define MPLL_LOOP_CTL_GD_LSB                                                   1
#define MPLL_LOOP_CTL_GD_MSB                                                   1
#define MPLL_LOOP_CTL_GD_MASK                                                  0x2
#define MPLL_LOOP_CTL_GD_GET(x)                                                (((x) & MPLL_LOOP_CTL_GD_MASK) >> MPLL_LOOP_CTL_GD_LSB)
#define MPLL_LOOP_CTL_GD_SET(x)                                                (((0 | (x)) << MPLL_LOOP_CTL_GD_LSB) & MPLL_LOOP_CTL_GD_MASK)
#define MPLL_LOOP_CTL_GD_RESET                                                 0x0
#define MPLL_LOOP_CTL_VMB_LSB                                                  0
#define MPLL_LOOP_CTL_VMB_MSB                                                  0
#define MPLL_LOOP_CTL_VMB_MASK                                                 0x1
#define MPLL_LOOP_CTL_VMB_GET(x)                                               (((x) & MPLL_LOOP_CTL_VMB_MASK) >> MPLL_LOOP_CTL_VMB_LSB)
#define MPLL_LOOP_CTL_VMB_SET(x)                                               (((0 | (x)) << MPLL_LOOP_CTL_VMB_LSB) & MPLL_LOOP_CTL_VMB_MASK)
#define MPLL_LOOP_CTL_VMB_RESET                                                0x0
#define MPLL_LOOP_CTL_ADDRESS                                                  (0xc0 + __PCIE_PHY_REG_BASE_ADDRESS)
#define MPLL_LOOP_CTL_RSTMASK                                                  0xff
#define MPLL_LOOP_CTL_RESET                                                    0xe0

// 0xc4 (MPLL_ATB_MEAS1)
#define MPLL_ATB_MEAS1_VPSF_LSB                                                7
#define MPLL_ATB_MEAS1_VPSF_MSB                                                7
#define MPLL_ATB_MEAS1_VPSF_MASK                                               0x80
#define MPLL_ATB_MEAS1_VPSF_GET(x)                                             (((x) & MPLL_ATB_MEAS1_VPSF_MASK) >> MPLL_ATB_MEAS1_VPSF_LSB)
#define MPLL_ATB_MEAS1_VPSF_SET(x)                                             (((0 | (x)) << MPLL_ATB_MEAS1_VPSF_LSB) & MPLL_ATB_MEAS1_VPSF_MASK)
#define MPLL_ATB_MEAS1_VPSF_RESET                                              0x0
#define MPLL_ATB_MEAS1_VREF_LSB                                                6
#define MPLL_ATB_MEAS1_VREF_MSB                                                6
#define MPLL_ATB_MEAS1_VREF_MASK                                               0x40
#define MPLL_ATB_MEAS1_VREF_GET(x)                                             (((x) & MPLL_ATB_MEAS1_VREF_MASK) >> MPLL_ATB_MEAS1_VREF_LSB)
#define MPLL_ATB_MEAS1_VREF_SET(x)                                             (((0 | (x)) << MPLL_ATB_MEAS1_VREF_LSB) & MPLL_ATB_MEAS1_VREF_MASK)
#define MPLL_ATB_MEAS1_VREF_RESET                                              0x0
#define MPLL_ATB_MEAS1_VCNTRL_LSB                                              5
#define MPLL_ATB_MEAS1_VCNTRL_MSB                                              5
#define MPLL_ATB_MEAS1_VCNTRL_MASK                                             0x20
#define MPLL_ATB_MEAS1_VCNTRL_GET(x)                                           (((x) & MPLL_ATB_MEAS1_VCNTRL_MASK) >> MPLL_ATB_MEAS1_VCNTRL_LSB)
#define MPLL_ATB_MEAS1_VCNTRL_SET(x)                                           (((0 | (x)) << MPLL_ATB_MEAS1_VCNTRL_LSB) & MPLL_ATB_MEAS1_VCNTRL_MASK)
#define MPLL_ATB_MEAS1_VCNTRL_RESET                                            0x0
#define MPLL_ATB_MEAS1_GD_LSB                                                  4
#define MPLL_ATB_MEAS1_GD_MSB                                                  4
#define MPLL_ATB_MEAS1_GD_MASK                                                 0x10
#define MPLL_ATB_MEAS1_GD_GET(x)                                               (((x) & MPLL_ATB_MEAS1_GD_MASK) >> MPLL_ATB_MEAS1_GD_LSB)
#define MPLL_ATB_MEAS1_GD_SET(x)                                               (((0 | (x)) << MPLL_ATB_MEAS1_GD_LSB) & MPLL_ATB_MEAS1_GD_MASK)
#define MPLL_ATB_MEAS1_GD_RESET                                                0x0
#define MPLL_ATB_MEAS1_IVCO_LSB                                                3
#define MPLL_ATB_MEAS1_IVCO_MSB                                                3
#define MPLL_ATB_MEAS1_IVCO_MASK                                               0x8
#define MPLL_ATB_MEAS1_IVCO_GET(x)                                             (((x) & MPLL_ATB_MEAS1_IVCO_MASK) >> MPLL_ATB_MEAS1_IVCO_LSB)
#define MPLL_ATB_MEAS1_IVCO_SET(x)                                             (((0 | (x)) << MPLL_ATB_MEAS1_IVCO_LSB) & MPLL_ATB_MEAS1_IVCO_MASK)
#define MPLL_ATB_MEAS1_IVCO_RESET                                              0x0
#define MPLL_ATB_MEAS1_VP_LSB                                                  2
#define MPLL_ATB_MEAS1_VP_MSB                                                  2
#define MPLL_ATB_MEAS1_VP_MASK                                                 0x4
#define MPLL_ATB_MEAS1_VP_GET(x)                                               (((x) & MPLL_ATB_MEAS1_VP_MASK) >> MPLL_ATB_MEAS1_VP_LSB)
#define MPLL_ATB_MEAS1_VP_SET(x)                                               (((0 | (x)) << MPLL_ATB_MEAS1_VP_LSB) & MPLL_ATB_MEAS1_VP_MASK)
#define MPLL_ATB_MEAS1_VP_RESET                                                0x0
#define MPLL_ATB_MEAS1_VP_CP_LSB                                               1
#define MPLL_ATB_MEAS1_VP_CP_MSB                                               1
#define MPLL_ATB_MEAS1_VP_CP_MASK                                              0x2
#define MPLL_ATB_MEAS1_VP_CP_GET(x)                                            (((x) & MPLL_ATB_MEAS1_VP_CP_MASK) >> MPLL_ATB_MEAS1_VP_CP_LSB)
#define MPLL_ATB_MEAS1_VP_CP_SET(x)                                            (((0 | (x)) << MPLL_ATB_MEAS1_VP_CP_LSB) & MPLL_ATB_MEAS1_VP_CP_MASK)
#define MPLL_ATB_MEAS1_VP_CP_RESET                                             0x0
#define MPLL_ATB_MEAS1_VREG_MPLL_LSB                                           0
#define MPLL_ATB_MEAS1_VREG_MPLL_MSB                                           0
#define MPLL_ATB_MEAS1_VREG_MPLL_MASK                                          0x1
#define MPLL_ATB_MEAS1_VREG_MPLL_GET(x)                                        (((x) & MPLL_ATB_MEAS1_VREG_MPLL_MASK) >> MPLL_ATB_MEAS1_VREG_MPLL_LSB)
#define MPLL_ATB_MEAS1_VREG_MPLL_SET(x)                                        (((0 | (x)) << MPLL_ATB_MEAS1_VREG_MPLL_LSB) & MPLL_ATB_MEAS1_VREG_MPLL_MASK)
#define MPLL_ATB_MEAS1_VREG_MPLL_RESET                                         0x0
#define MPLL_ATB_MEAS1_ADDRESS                                                 (0xc4 + __PCIE_PHY_REG_BASE_ADDRESS)
#define MPLL_ATB_MEAS1_RSTMASK                                                 0xff
#define MPLL_ATB_MEAS1_RESET                                                   0x0

// 0xc8 (MPLL_ATB_MEAS2)
#define MPLL_ATB_MEAS2_IVCO_FILT_LSB                                           7
#define MPLL_ATB_MEAS2_IVCO_FILT_MSB                                           7
#define MPLL_ATB_MEAS2_IVCO_FILT_MASK                                          0x80
#define MPLL_ATB_MEAS2_IVCO_FILT_GET(x)                                        (((x) & MPLL_ATB_MEAS2_IVCO_FILT_MASK) >> MPLL_ATB_MEAS2_IVCO_FILT_LSB)
#define MPLL_ATB_MEAS2_IVCO_FILT_SET(x)                                        (((0 | (x)) << MPLL_ATB_MEAS2_IVCO_FILT_LSB) & MPLL_ATB_MEAS2_IVCO_FILT_MASK)
#define MPLL_ATB_MEAS2_IVCO_FILT_RESET                                         0x0
#define MPLL_ATB_MEAS2_VCNTRL_M_LSB                                            6
#define MPLL_ATB_MEAS2_VCNTRL_M_MSB                                            6
#define MPLL_ATB_MEAS2_VCNTRL_M_MASK                                           0x40
#define MPLL_ATB_MEAS2_VCNTRL_M_GET(x)                                         (((x) & MPLL_ATB_MEAS2_VCNTRL_M_MASK) >> MPLL_ATB_MEAS2_VCNTRL_M_LSB)
#define MPLL_ATB_MEAS2_VCNTRL_M_SET(x)                                         (((0 | (x)) << MPLL_ATB_MEAS2_VCNTRL_M_LSB) & MPLL_ATB_MEAS2_VCNTRL_M_MASK)
#define MPLL_ATB_MEAS2_VCNTRL_M_RESET                                          0x0
#define MPLL_ATB_MEAS2_VCNTRL_P_LSB                                            5
#define MPLL_ATB_MEAS2_VCNTRL_P_MSB                                            5
#define MPLL_ATB_MEAS2_VCNTRL_P_MASK                                           0x20
#define MPLL_ATB_MEAS2_VCNTRL_P_GET(x)                                         (((x) & MPLL_ATB_MEAS2_VCNTRL_P_MASK) >> MPLL_ATB_MEAS2_VCNTRL_P_LSB)
#define MPLL_ATB_MEAS2_VCNTRL_P_SET(x)                                         (((0 | (x)) << MPLL_ATB_MEAS2_VCNTRL_P_LSB) & MPLL_ATB_MEAS2_VCNTRL_P_MASK)
#define MPLL_ATB_MEAS2_VCNTRL_P_RESET                                          0x0
#define MPLL_ATB_MEAS2_ATB_SENSE_SEL_LSB                                       4
#define MPLL_ATB_MEAS2_ATB_SENSE_SEL_MSB                                       4
#define MPLL_ATB_MEAS2_ATB_SENSE_SEL_MASK                                      0x10
#define MPLL_ATB_MEAS2_ATB_SENSE_SEL_GET(x)                                    (((x) & MPLL_ATB_MEAS2_ATB_SENSE_SEL_MASK) >> MPLL_ATB_MEAS2_ATB_SENSE_SEL_LSB)
#define MPLL_ATB_MEAS2_ATB_SENSE_SEL_SET(x)                                    (((0 | (x)) << MPLL_ATB_MEAS2_ATB_SENSE_SEL_LSB) & MPLL_ATB_MEAS2_ATB_SENSE_SEL_MASK)
#define MPLL_ATB_MEAS2_ATB_SENSE_SEL_RESET                                     0x0
#define MPLL_ATB_MEAS2_MEAS_TEMP_LSB                                           3
#define MPLL_ATB_MEAS2_MEAS_TEMP_MSB                                           3
#define MPLL_ATB_MEAS2_MEAS_TEMP_MASK                                          0x8
#define MPLL_ATB_MEAS2_MEAS_TEMP_GET(x)                                        (((x) & MPLL_ATB_MEAS2_MEAS_TEMP_MASK) >> MPLL_ATB_MEAS2_MEAS_TEMP_LSB)
#define MPLL_ATB_MEAS2_MEAS_TEMP_SET(x)                                        (((0 | (x)) << MPLL_ATB_MEAS2_MEAS_TEMP_LSB) & MPLL_ATB_MEAS2_MEAS_TEMP_MASK)
#define MPLL_ATB_MEAS2_MEAS_TEMP_RESET                                         0x0
#define MPLL_ATB_MEAS2_FRC_MPMIX_VPMIX_LSB                                     2
#define MPLL_ATB_MEAS2_FRC_MPMIX_VPMIX_MSB                                     2
#define MPLL_ATB_MEAS2_FRC_MPMIX_VPMIX_MASK                                    0x4
#define MPLL_ATB_MEAS2_FRC_MPMIX_VPMIX_GET(x)                                  (((x) & MPLL_ATB_MEAS2_FRC_MPMIX_VPMIX_MASK) >> MPLL_ATB_MEAS2_FRC_MPMIX_VPMIX_LSB)
#define MPLL_ATB_MEAS2_FRC_MPMIX_VPMIX_SET(x)                                  (((0 | (x)) << MPLL_ATB_MEAS2_FRC_MPMIX_VPMIX_LSB) & MPLL_ATB_MEAS2_FRC_MPMIX_VPMIX_MASK)
#define MPLL_ATB_MEAS2_FRC_MPMIX_VPMIX_RESET                                   0x0
#define MPLL_ATB_MEAS2_EN_MPMIX_VPMIX_LSB                                      1
#define MPLL_ATB_MEAS2_EN_MPMIX_VPMIX_MSB                                      1
#define MPLL_ATB_MEAS2_EN_MPMIX_VPMIX_MASK                                     0x2
#define MPLL_ATB_MEAS2_EN_MPMIX_VPMIX_GET(x)                                   (((x) & MPLL_ATB_MEAS2_EN_MPMIX_VPMIX_MASK) >> MPLL_ATB_MEAS2_EN_MPMIX_VPMIX_LSB)
#define MPLL_ATB_MEAS2_EN_MPMIX_VPMIX_SET(x)                                   (((0 | (x)) << MPLL_ATB_MEAS2_EN_MPMIX_VPMIX_LSB) & MPLL_ATB_MEAS2_EN_MPMIX_VPMIX_MASK)
#define MPLL_ATB_MEAS2_EN_MPMIX_VPMIX_RESET                                    0x0
#define MPLL_ATB_MEAS2_VDCC_IO_LSB                                             0
#define MPLL_ATB_MEAS2_VDCC_IO_MSB                                             0
#define MPLL_ATB_MEAS2_VDCC_IO_MASK                                            0x1
#define MPLL_ATB_MEAS2_VDCC_IO_GET(x)                                          (((x) & MPLL_ATB_MEAS2_VDCC_IO_MASK) >> MPLL_ATB_MEAS2_VDCC_IO_LSB)
#define MPLL_ATB_MEAS2_VDCC_IO_SET(x)                                          (((0 | (x)) << MPLL_ATB_MEAS2_VDCC_IO_LSB) & MPLL_ATB_MEAS2_VDCC_IO_MASK)
#define MPLL_ATB_MEAS2_VDCC_IO_RESET                                           0x0
#define MPLL_ATB_MEAS2_ADDRESS                                                 (0xc8 + __PCIE_PHY_REG_BASE_ADDRESS)
#define MPLL_ATB_MEAS2_RSTMASK                                                 0xff
#define MPLL_ATB_MEAS2_RESET                                                   0x0

// 0xcc (MPLL_OVRD)
#define MPLL_OVRD_PWRON_LCL_LSB                                                7
#define MPLL_OVRD_PWRON_LCL_MSB                                                7
#define MPLL_OVRD_PWRON_LCL_MASK                                               0x80
#define MPLL_OVRD_PWRON_LCL_GET(x)                                             (((x) & MPLL_OVRD_PWRON_LCL_MASK) >> MPLL_OVRD_PWRON_LCL_LSB)
#define MPLL_OVRD_PWRON_LCL_SET(x)                                             (((0 | (x)) << MPLL_OVRD_PWRON_LCL_LSB) & MPLL_OVRD_PWRON_LCL_MASK)
#define MPLL_OVRD_PWRON_LCL_RESET                                              0x0
#define MPLL_OVRD_EN_PWRON_LCL_LSB                                             6
#define MPLL_OVRD_EN_PWRON_LCL_MSB                                             6
#define MPLL_OVRD_EN_PWRON_LCL_MASK                                            0x40
#define MPLL_OVRD_EN_PWRON_LCL_GET(x)                                          (((x) & MPLL_OVRD_EN_PWRON_LCL_MASK) >> MPLL_OVRD_EN_PWRON_LCL_LSB)
#define MPLL_OVRD_EN_PWRON_LCL_SET(x)                                          (((0 | (x)) << MPLL_OVRD_EN_PWRON_LCL_LSB) & MPLL_OVRD_EN_PWRON_LCL_MASK)
#define MPLL_OVRD_EN_PWRON_LCL_RESET                                           0x0
#define MPLL_OVRD_GS_LCL_LSB                                                   5
#define MPLL_OVRD_GS_LCL_MSB                                                   5
#define MPLL_OVRD_GS_LCL_MASK                                                  0x20
#define MPLL_OVRD_GS_LCL_GET(x)                                                (((x) & MPLL_OVRD_GS_LCL_MASK) >> MPLL_OVRD_GS_LCL_LSB)
#define MPLL_OVRD_GS_LCL_SET(x)                                                (((0 | (x)) << MPLL_OVRD_GS_LCL_LSB) & MPLL_OVRD_GS_LCL_MASK)
#define MPLL_OVRD_GS_LCL_RESET                                                 0x0
#define MPLL_OVRD_EN_GS_LCL_LSB                                                4
#define MPLL_OVRD_EN_GS_LCL_MSB                                                4
#define MPLL_OVRD_EN_GS_LCL_MASK                                               0x10
#define MPLL_OVRD_EN_GS_LCL_GET(x)                                             (((x) & MPLL_OVRD_EN_GS_LCL_MASK) >> MPLL_OVRD_EN_GS_LCL_LSB)
#define MPLL_OVRD_EN_GS_LCL_SET(x)                                             (((0 | (x)) << MPLL_OVRD_EN_GS_LCL_LSB) & MPLL_OVRD_EN_GS_LCL_MASK)
#define MPLL_OVRD_EN_GS_LCL_RESET                                              0x0
#define MPLL_OVRD_RST_LCL_LSB                                                  3
#define MPLL_OVRD_RST_LCL_MSB                                                  3
#define MPLL_OVRD_RST_LCL_MASK                                                 0x8
#define MPLL_OVRD_RST_LCL_GET(x)                                               (((x) & MPLL_OVRD_RST_LCL_MASK) >> MPLL_OVRD_RST_LCL_LSB)
#define MPLL_OVRD_RST_LCL_SET(x)                                               (((0 | (x)) << MPLL_OVRD_RST_LCL_LSB) & MPLL_OVRD_RST_LCL_MASK)
#define MPLL_OVRD_RST_LCL_RESET                                                0x0
#define MPLL_OVRD_EN_RST_LCL_LSB                                               2
#define MPLL_OVRD_EN_RST_LCL_MSB                                               2
#define MPLL_OVRD_EN_RST_LCL_MASK                                              0x4
#define MPLL_OVRD_EN_RST_LCL_GET(x)                                            (((x) & MPLL_OVRD_EN_RST_LCL_MASK) >> MPLL_OVRD_EN_RST_LCL_LSB)
#define MPLL_OVRD_EN_RST_LCL_SET(x)                                            (((0 | (x)) << MPLL_OVRD_EN_RST_LCL_LSB) & MPLL_OVRD_EN_RST_LCL_MASK)
#define MPLL_OVRD_EN_RST_LCL_RESET                                             0x0
#define MPLL_OVRD_PMIX_CLK_SEL_LCL_LSB                                         1
#define MPLL_OVRD_PMIX_CLK_SEL_LCL_MSB                                         1
#define MPLL_OVRD_PMIX_CLK_SEL_LCL_MASK                                        0x2
#define MPLL_OVRD_PMIX_CLK_SEL_LCL_GET(x)                                      (((x) & MPLL_OVRD_PMIX_CLK_SEL_LCL_MASK) >> MPLL_OVRD_PMIX_CLK_SEL_LCL_LSB)
#define MPLL_OVRD_PMIX_CLK_SEL_LCL_SET(x)                                      (((0 | (x)) << MPLL_OVRD_PMIX_CLK_SEL_LCL_LSB) & MPLL_OVRD_PMIX_CLK_SEL_LCL_MASK)
#define MPLL_OVRD_PMIX_CLK_SEL_LCL_RESET                                       0x0
#define MPLL_OVRD_EN_PMIX_CLK_SEL_LCL_LSB                                      0
#define MPLL_OVRD_EN_PMIX_CLK_SEL_LCL_MSB                                      0
#define MPLL_OVRD_EN_PMIX_CLK_SEL_LCL_MASK                                     0x1
#define MPLL_OVRD_EN_PMIX_CLK_SEL_LCL_GET(x)                                   (((x) & MPLL_OVRD_EN_PMIX_CLK_SEL_LCL_MASK) >> MPLL_OVRD_EN_PMIX_CLK_SEL_LCL_LSB)
#define MPLL_OVRD_EN_PMIX_CLK_SEL_LCL_SET(x)                                   (((0 | (x)) << MPLL_OVRD_EN_PMIX_CLK_SEL_LCL_LSB) & MPLL_OVRD_EN_PMIX_CLK_SEL_LCL_MASK)
#define MPLL_OVRD_EN_PMIX_CLK_SEL_LCL_RESET                                    0x0
#define MPLL_OVRD_ADDRESS                                                      (0xcc + __PCIE_PHY_REG_BASE_ADDRESS)
#define MPLL_OVRD_RSTMASK                                                      0xff
#define MPLL_OVRD_RESET                                                        0x0

// 0xd0 (RTUNE_RTUNE_CTRL)
#define RTUNE_RTUNE_CTRL_RT_PWRON_FRC_ON_LSB                                   7
#define RTUNE_RTUNE_CTRL_RT_PWRON_FRC_ON_MSB                                   7
#define RTUNE_RTUNE_CTRL_RT_PWRON_FRC_ON_MASK                                  0x80
#define RTUNE_RTUNE_CTRL_RT_PWRON_FRC_ON_GET(x)                                (((x) & RTUNE_RTUNE_CTRL_RT_PWRON_FRC_ON_MASK) >> RTUNE_RTUNE_CTRL_RT_PWRON_FRC_ON_LSB)
#define RTUNE_RTUNE_CTRL_RT_PWRON_FRC_ON_SET(x)                                (((0 | (x)) << RTUNE_RTUNE_CTRL_RT_PWRON_FRC_ON_LSB) & RTUNE_RTUNE_CTRL_RT_PWRON_FRC_ON_MASK)
#define RTUNE_RTUNE_CTRL_RT_PWRON_FRC_ON_RESET                                 0x0
#define RTUNE_RTUNE_CTRL_X4_FRC_OFF_LSB                                        6
#define RTUNE_RTUNE_CTRL_X4_FRC_OFF_MSB                                        6
#define RTUNE_RTUNE_CTRL_X4_FRC_OFF_MASK                                       0x40
#define RTUNE_RTUNE_CTRL_X4_FRC_OFF_GET(x)                                     (((x) & RTUNE_RTUNE_CTRL_X4_FRC_OFF_MASK) >> RTUNE_RTUNE_CTRL_X4_FRC_OFF_LSB)
#define RTUNE_RTUNE_CTRL_X4_FRC_OFF_SET(x)                                     (((0 | (x)) << RTUNE_RTUNE_CTRL_X4_FRC_OFF_LSB) & RTUNE_RTUNE_CTRL_X4_FRC_OFF_MASK)
#define RTUNE_RTUNE_CTRL_X4_FRC_OFF_RESET                                      0x0
#define RTUNE_RTUNE_CTRL_RT_DAC_MODE_LSB                                       4
#define RTUNE_RTUNE_CTRL_RT_DAC_MODE_MSB                                       5
#define RTUNE_RTUNE_CTRL_RT_DAC_MODE_MASK                                      0x30
#define RTUNE_RTUNE_CTRL_RT_DAC_MODE_GET(x)                                    (((x) & RTUNE_RTUNE_CTRL_RT_DAC_MODE_MASK) >> RTUNE_RTUNE_CTRL_RT_DAC_MODE_LSB)
#define RTUNE_RTUNE_CTRL_RT_DAC_MODE_SET(x)                                    (((0 | (x)) << RTUNE_RTUNE_CTRL_RT_DAC_MODE_LSB) & RTUNE_RTUNE_CTRL_RT_DAC_MODE_MASK)
#define RTUNE_RTUNE_CTRL_RT_DAC_MODE_RESET                                     0x0
#define RTUNE_RTUNE_CTRL_RT_DAC_CHOP_LSB                                       3
#define RTUNE_RTUNE_CTRL_RT_DAC_CHOP_MSB                                       3
#define RTUNE_RTUNE_CTRL_RT_DAC_CHOP_MASK                                      0x8
#define RTUNE_RTUNE_CTRL_RT_DAC_CHOP_GET(x)                                    (((x) & RTUNE_RTUNE_CTRL_RT_DAC_CHOP_MASK) >> RTUNE_RTUNE_CTRL_RT_DAC_CHOP_LSB)
#define RTUNE_RTUNE_CTRL_RT_DAC_CHOP_SET(x)                                    (((0 | (x)) << RTUNE_RTUNE_CTRL_RT_DAC_CHOP_LSB) & RTUNE_RTUNE_CTRL_RT_DAC_CHOP_MASK)
#define RTUNE_RTUNE_CTRL_RT_DAC_CHOP_RESET                                     0x0
#define RTUNE_RTUNE_CTRL_RT_ATB_LSB                                            2
#define RTUNE_RTUNE_CTRL_RT_ATB_MSB                                            2
#define RTUNE_RTUNE_CTRL_RT_ATB_MASK                                           0x4
#define RTUNE_RTUNE_CTRL_RT_ATB_GET(x)                                         (((x) & RTUNE_RTUNE_CTRL_RT_ATB_MASK) >> RTUNE_RTUNE_CTRL_RT_ATB_LSB)
#define RTUNE_RTUNE_CTRL_RT_ATB_SET(x)                                         (((0 | (x)) << RTUNE_RTUNE_CTRL_RT_ATB_LSB) & RTUNE_RTUNE_CTRL_RT_ATB_MASK)
#define RTUNE_RTUNE_CTRL_RT_ATB_RESET                                          0x0
#define RTUNE_RTUNE_CTRL_RT_SEL_ATBP_LSB                                       1
#define RTUNE_RTUNE_CTRL_RT_SEL_ATBP_MSB                                       1
#define RTUNE_RTUNE_CTRL_RT_SEL_ATBP_MASK                                      0x2
#define RTUNE_RTUNE_CTRL_RT_SEL_ATBP_GET(x)                                    (((x) & RTUNE_RTUNE_CTRL_RT_SEL_ATBP_MASK) >> RTUNE_RTUNE_CTRL_RT_SEL_ATBP_LSB)
#define RTUNE_RTUNE_CTRL_RT_SEL_ATBP_SET(x)                                    (((0 | (x)) << RTUNE_RTUNE_CTRL_RT_SEL_ATBP_LSB) & RTUNE_RTUNE_CTRL_RT_SEL_ATBP_MASK)
#define RTUNE_RTUNE_CTRL_RT_SEL_ATBP_RESET                                     0x0
#define RTUNE_RTUNE_CTRL_RT_SEL_ATBF_LSB                                       0
#define RTUNE_RTUNE_CTRL_RT_SEL_ATBF_MSB                                       0
#define RTUNE_RTUNE_CTRL_RT_SEL_ATBF_MASK                                      0x1
#define RTUNE_RTUNE_CTRL_RT_SEL_ATBF_GET(x)                                    (((x) & RTUNE_RTUNE_CTRL_RT_SEL_ATBF_MASK) >> RTUNE_RTUNE_CTRL_RT_SEL_ATBF_LSB)
#define RTUNE_RTUNE_CTRL_RT_SEL_ATBF_SET(x)                                    (((0 | (x)) << RTUNE_RTUNE_CTRL_RT_SEL_ATBF_LSB) & RTUNE_RTUNE_CTRL_RT_SEL_ATBF_MASK)
#define RTUNE_RTUNE_CTRL_RT_SEL_ATBF_RESET                                     0x0
#define RTUNE_RTUNE_CTRL_ADDRESS                                               (0xd0 + __PCIE_PHY_REG_BASE_ADDRESS)
#define RTUNE_RTUNE_CTRL_RSTMASK                                               0xff
#define RTUNE_RTUNE_CTRL_RESET                                                 0x0

// 0xd4 (ATB_SWITCHYARD_CTRL)
#define ATB_SWITCHYARD_CTRL_ASM_GD_LSB                                         7
#define ATB_SWITCHYARD_CTRL_ASM_GD_MSB                                         7
#define ATB_SWITCHYARD_CTRL_ASM_GD_MASK                                        0x80
#define ATB_SWITCHYARD_CTRL_ASM_GD_GET(x)                                      (((x) & ATB_SWITCHYARD_CTRL_ASM_GD_MASK) >> ATB_SWITCHYARD_CTRL_ASM_GD_LSB)
#define ATB_SWITCHYARD_CTRL_ASM_GD_SET(x)                                      (((0 | (x)) << ATB_SWITCHYARD_CTRL_ASM_GD_LSB) & ATB_SWITCHYARD_CTRL_ASM_GD_MASK)
#define ATB_SWITCHYARD_CTRL_ASM_GD_RESET                                       0x0
#define ATB_SWITCHYARD_CTRL_ASP_VP_LSB                                         6
#define ATB_SWITCHYARD_CTRL_ASP_VP_MSB                                         6
#define ATB_SWITCHYARD_CTRL_ASP_VP_MASK                                        0x40
#define ATB_SWITCHYARD_CTRL_ASP_VP_GET(x)                                      (((x) & ATB_SWITCHYARD_CTRL_ASP_VP_MASK) >> ATB_SWITCHYARD_CTRL_ASP_VP_LSB)
#define ATB_SWITCHYARD_CTRL_ASP_VP_SET(x)                                      (((0 | (x)) << ATB_SWITCHYARD_CTRL_ASP_VP_LSB) & ATB_SWITCHYARD_CTRL_ASP_VP_MASK)
#define ATB_SWITCHYARD_CTRL_ASP_VP_RESET                                       0x0
#define ATB_SWITCHYARD_CTRL_ATB_VBG_LSB                                        5
#define ATB_SWITCHYARD_CTRL_ATB_VBG_MSB                                        5
#define ATB_SWITCHYARD_CTRL_ATB_VBG_MASK                                       0x20
#define ATB_SWITCHYARD_CTRL_ATB_VBG_GET(x)                                     (((x) & ATB_SWITCHYARD_CTRL_ATB_VBG_MASK) >> ATB_SWITCHYARD_CTRL_ATB_VBG_LSB)
#define ATB_SWITCHYARD_CTRL_ATB_VBG_SET(x)                                     (((0 | (x)) << ATB_SWITCHYARD_CTRL_ATB_VBG_LSB) & ATB_SWITCHYARD_CTRL_ATB_VBG_MASK)
#define ATB_SWITCHYARD_CTRL_ATB_VBG_RESET                                      0x0
#define ATB_SWITCHYARD_CTRL_ASP_VPGREG_LSB                                     4
#define ATB_SWITCHYARD_CTRL_ASP_VPGREG_MSB                                     4
#define ATB_SWITCHYARD_CTRL_ASP_VPGREG_MASK                                    0x10
#define ATB_SWITCHYARD_CTRL_ASP_VPGREG_GET(x)                                  (((x) & ATB_SWITCHYARD_CTRL_ASP_VPGREG_MASK) >> ATB_SWITCHYARD_CTRL_ASP_VPGREG_LSB)
#define ATB_SWITCHYARD_CTRL_ASP_VPGREG_SET(x)                                  (((0 | (x)) << ATB_SWITCHYARD_CTRL_ASP_VPGREG_LSB) & ATB_SWITCHYARD_CTRL_ASP_VPGREG_MASK)
#define ATB_SWITCHYARD_CTRL_ASP_VPGREG_RESET                                   0x0
#define ATB_SWITCHYARD_CTRL_ATEST_AFM_LSB                                      3
#define ATB_SWITCHYARD_CTRL_ATEST_AFM_MSB                                      3
#define ATB_SWITCHYARD_CTRL_ATEST_AFM_MASK                                     0x8
#define ATB_SWITCHYARD_CTRL_ATEST_AFM_GET(x)                                   (((x) & ATB_SWITCHYARD_CTRL_ATEST_AFM_MASK) >> ATB_SWITCHYARD_CTRL_ATEST_AFM_LSB)
#define ATB_SWITCHYARD_CTRL_ATEST_AFM_SET(x)                                   (((0 | (x)) << ATB_SWITCHYARD_CTRL_ATEST_AFM_LSB) & ATB_SWITCHYARD_CTRL_ATEST_AFM_MASK)
#define ATB_SWITCHYARD_CTRL_ATEST_AFM_RESET                                    0x0
#define ATB_SWITCHYARD_CTRL_ATEST_AFP_LSB                                      2
#define ATB_SWITCHYARD_CTRL_ATEST_AFP_MSB                                      2
#define ATB_SWITCHYARD_CTRL_ATEST_AFP_MASK                                     0x4
#define ATB_SWITCHYARD_CTRL_ATEST_AFP_GET(x)                                   (((x) & ATB_SWITCHYARD_CTRL_ATEST_AFP_MASK) >> ATB_SWITCHYARD_CTRL_ATEST_AFP_LSB)
#define ATB_SWITCHYARD_CTRL_ATEST_AFP_SET(x)                                   (((0 | (x)) << ATB_SWITCHYARD_CTRL_ATEST_AFP_LSB) & ATB_SWITCHYARD_CTRL_ATEST_AFP_MASK)
#define ATB_SWITCHYARD_CTRL_ATEST_AFP_RESET                                    0x0
#define ATB_SWITCHYARD_CTRL_ATEST_ASM_LSB                                      1
#define ATB_SWITCHYARD_CTRL_ATEST_ASM_MSB                                      1
#define ATB_SWITCHYARD_CTRL_ATEST_ASM_MASK                                     0x2
#define ATB_SWITCHYARD_CTRL_ATEST_ASM_GET(x)                                   (((x) & ATB_SWITCHYARD_CTRL_ATEST_ASM_MASK) >> ATB_SWITCHYARD_CTRL_ATEST_ASM_LSB)
#define ATB_SWITCHYARD_CTRL_ATEST_ASM_SET(x)                                   (((0 | (x)) << ATB_SWITCHYARD_CTRL_ATEST_ASM_LSB) & ATB_SWITCHYARD_CTRL_ATEST_ASM_MASK)
#define ATB_SWITCHYARD_CTRL_ATEST_ASM_RESET                                    0x0
#define ATB_SWITCHYARD_CTRL_ATEST_ASP_LSB                                      0
#define ATB_SWITCHYARD_CTRL_ATEST_ASP_MSB                                      0
#define ATB_SWITCHYARD_CTRL_ATEST_ASP_MASK                                     0x1
#define ATB_SWITCHYARD_CTRL_ATEST_ASP_GET(x)                                   (((x) & ATB_SWITCHYARD_CTRL_ATEST_ASP_MASK) >> ATB_SWITCHYARD_CTRL_ATEST_ASP_LSB)
#define ATB_SWITCHYARD_CTRL_ATEST_ASP_SET(x)                                   (((0 | (x)) << ATB_SWITCHYARD_CTRL_ATEST_ASP_LSB) & ATB_SWITCHYARD_CTRL_ATEST_ASP_MASK)
#define ATB_SWITCHYARD_CTRL_ATEST_ASP_RESET                                    0x0
#define ATB_SWITCHYARD_CTRL_ADDRESS                                            (0xd4 + __PCIE_PHY_REG_BASE_ADDRESS)
#define ATB_SWITCHYARD_CTRL_RSTMASK                                            0xff
#define ATB_SWITCHYARD_CTRL_RESET                                              0x0

// 0xd8 (SSC_CLK_CNTRL)
#define SSC_CLK_CNTRL_NC_LSB                                                   7
#define SSC_CLK_CNTRL_NC_MSB                                                   7
#define SSC_CLK_CNTRL_NC_MASK                                                  0x80
#define SSC_CLK_CNTRL_NC_GET(x)                                                (((x) & SSC_CLK_CNTRL_NC_MASK) >> SSC_CLK_CNTRL_NC_LSB)
#define SSC_CLK_CNTRL_NC_SET(x)                                                (((0 | (x)) << SSC_CLK_CNTRL_NC_LSB) & SSC_CLK_CNTRL_NC_MASK)
#define SSC_CLK_CNTRL_NC_RESET                                                 0x0
#define SSC_CLK_CNTRL_SSC_CLK_DIV125_LSB                                       0
#define SSC_CLK_CNTRL_SSC_CLK_DIV125_MSB                                       6
#define SSC_CLK_CNTRL_SSC_CLK_DIV125_MASK                                      0x7f
#define SSC_CLK_CNTRL_SSC_CLK_DIV125_GET(x)                                    (((x) & SSC_CLK_CNTRL_SSC_CLK_DIV125_MASK) >> SSC_CLK_CNTRL_SSC_CLK_DIV125_LSB)
#define SSC_CLK_CNTRL_SSC_CLK_DIV125_SET(x)                                    (((0 | (x)) << SSC_CLK_CNTRL_SSC_CLK_DIV125_LSB) & SSC_CLK_CNTRL_SSC_CLK_DIV125_MASK)
#define SSC_CLK_CNTRL_SSC_CLK_DIV125_RESET                                     0x7d
#define SSC_CLK_CNTRL_ADDRESS                                                  (0xd8 + __PCIE_PHY_REG_BASE_ADDRESS)
#define SSC_CLK_CNTRL_RSTMASK                                                  0xff
#define SSC_CLK_CNTRL_RESET                                                    0x7d

// 0x4000 (TX_OVRD_IN_LO)
#define TX_OVRD_IN_LO_TX_DETECT_RX_REQ_OVRD_LSB                                13
#define TX_OVRD_IN_LO_TX_DETECT_RX_REQ_OVRD_MSB                                13
#define TX_OVRD_IN_LO_TX_DETECT_RX_REQ_OVRD_MASK                               0x2000
#define TX_OVRD_IN_LO_TX_DETECT_RX_REQ_OVRD_GET(x)                             (((x) & TX_OVRD_IN_LO_TX_DETECT_RX_REQ_OVRD_MASK) >> TX_OVRD_IN_LO_TX_DETECT_RX_REQ_OVRD_LSB)
#define TX_OVRD_IN_LO_TX_DETECT_RX_REQ_OVRD_SET(x)                             (((0 | (x)) << TX_OVRD_IN_LO_TX_DETECT_RX_REQ_OVRD_LSB) & TX_OVRD_IN_LO_TX_DETECT_RX_REQ_OVRD_MASK)
#define TX_OVRD_IN_LO_TX_DETECT_RX_REQ_OVRD_RESET                              0x0
#define TX_OVRD_IN_LO_TX_DETECT_RX_REQ_LSB                                     12
#define TX_OVRD_IN_LO_TX_DETECT_RX_REQ_MSB                                     12
#define TX_OVRD_IN_LO_TX_DETECT_RX_REQ_MASK                                    0x1000
#define TX_OVRD_IN_LO_TX_DETECT_RX_REQ_GET(x)                                  (((x) & TX_OVRD_IN_LO_TX_DETECT_RX_REQ_MASK) >> TX_OVRD_IN_LO_TX_DETECT_RX_REQ_LSB)
#define TX_OVRD_IN_LO_TX_DETECT_RX_REQ_SET(x)                                  (((0 | (x)) << TX_OVRD_IN_LO_TX_DETECT_RX_REQ_LSB) & TX_OVRD_IN_LO_TX_DETECT_RX_REQ_MASK)
#define TX_OVRD_IN_LO_TX_DETECT_RX_REQ_RESET                                   0x0
#define TX_OVRD_IN_LO_TX_BEACON_EN_OVRD_LSB                                    11
#define TX_OVRD_IN_LO_TX_BEACON_EN_OVRD_MSB                                    11
#define TX_OVRD_IN_LO_TX_BEACON_EN_OVRD_MASK                                   0x800
#define TX_OVRD_IN_LO_TX_BEACON_EN_OVRD_GET(x)                                 (((x) & TX_OVRD_IN_LO_TX_BEACON_EN_OVRD_MASK) >> TX_OVRD_IN_LO_TX_BEACON_EN_OVRD_LSB)
#define TX_OVRD_IN_LO_TX_BEACON_EN_OVRD_SET(x)                                 (((0 | (x)) << TX_OVRD_IN_LO_TX_BEACON_EN_OVRD_LSB) & TX_OVRD_IN_LO_TX_BEACON_EN_OVRD_MASK)
#define TX_OVRD_IN_LO_TX_BEACON_EN_OVRD_RESET                                  0x0
#define TX_OVRD_IN_LO_TX_BEACON_EN_LSB                                         10
#define TX_OVRD_IN_LO_TX_BEACON_EN_MSB                                         10
#define TX_OVRD_IN_LO_TX_BEACON_EN_MASK                                        0x400
#define TX_OVRD_IN_LO_TX_BEACON_EN_GET(x)                                      (((x) & TX_OVRD_IN_LO_TX_BEACON_EN_MASK) >> TX_OVRD_IN_LO_TX_BEACON_EN_LSB)
#define TX_OVRD_IN_LO_TX_BEACON_EN_SET(x)                                      (((0 | (x)) << TX_OVRD_IN_LO_TX_BEACON_EN_LSB) & TX_OVRD_IN_LO_TX_BEACON_EN_MASK)
#define TX_OVRD_IN_LO_TX_BEACON_EN_RESET                                       0x0
#define TX_OVRD_IN_LO_TX_CM_EN_OVRD_LSB                                        9
#define TX_OVRD_IN_LO_TX_CM_EN_OVRD_MSB                                        9
#define TX_OVRD_IN_LO_TX_CM_EN_OVRD_MASK                                       0x200
#define TX_OVRD_IN_LO_TX_CM_EN_OVRD_GET(x)                                     (((x) & TX_OVRD_IN_LO_TX_CM_EN_OVRD_MASK) >> TX_OVRD_IN_LO_TX_CM_EN_OVRD_LSB)
#define TX_OVRD_IN_LO_TX_CM_EN_OVRD_SET(x)                                     (((0 | (x)) << TX_OVRD_IN_LO_TX_CM_EN_OVRD_LSB) & TX_OVRD_IN_LO_TX_CM_EN_OVRD_MASK)
#define TX_OVRD_IN_LO_TX_CM_EN_OVRD_RESET                                      0x0
#define TX_OVRD_IN_LO_TX_CM_EN_LSB                                             8
#define TX_OVRD_IN_LO_TX_CM_EN_MSB                                             8
#define TX_OVRD_IN_LO_TX_CM_EN_MASK                                            0x100
#define TX_OVRD_IN_LO_TX_CM_EN_GET(x)                                          (((x) & TX_OVRD_IN_LO_TX_CM_EN_MASK) >> TX_OVRD_IN_LO_TX_CM_EN_LSB)
#define TX_OVRD_IN_LO_TX_CM_EN_SET(x)                                          (((0 | (x)) << TX_OVRD_IN_LO_TX_CM_EN_LSB) & TX_OVRD_IN_LO_TX_CM_EN_MASK)
#define TX_OVRD_IN_LO_TX_CM_EN_RESET                                           0x0
#define TX_OVRD_IN_LO_TX_EN_OVRD_LSB                                           7
#define TX_OVRD_IN_LO_TX_EN_OVRD_MSB                                           7
#define TX_OVRD_IN_LO_TX_EN_OVRD_MASK                                          0x80
#define TX_OVRD_IN_LO_TX_EN_OVRD_GET(x)                                        (((x) & TX_OVRD_IN_LO_TX_EN_OVRD_MASK) >> TX_OVRD_IN_LO_TX_EN_OVRD_LSB)
#define TX_OVRD_IN_LO_TX_EN_OVRD_SET(x)                                        (((0 | (x)) << TX_OVRD_IN_LO_TX_EN_OVRD_LSB) & TX_OVRD_IN_LO_TX_EN_OVRD_MASK)
#define TX_OVRD_IN_LO_TX_EN_OVRD_RESET                                         0x0
#define TX_OVRD_IN_LO_TX_EN_LSB                                                6
#define TX_OVRD_IN_LO_TX_EN_MSB                                                6
#define TX_OVRD_IN_LO_TX_EN_MASK                                               0x40
#define TX_OVRD_IN_LO_TX_EN_GET(x)                                             (((x) & TX_OVRD_IN_LO_TX_EN_MASK) >> TX_OVRD_IN_LO_TX_EN_LSB)
#define TX_OVRD_IN_LO_TX_EN_SET(x)                                             (((0 | (x)) << TX_OVRD_IN_LO_TX_EN_LSB) & TX_OVRD_IN_LO_TX_EN_MASK)
#define TX_OVRD_IN_LO_TX_EN_RESET                                              0x0
#define TX_OVRD_IN_LO_TX_DATA_EN_OVRD_LSB                                      5
#define TX_OVRD_IN_LO_TX_DATA_EN_OVRD_MSB                                      5
#define TX_OVRD_IN_LO_TX_DATA_EN_OVRD_MASK                                     0x20
#define TX_OVRD_IN_LO_TX_DATA_EN_OVRD_GET(x)                                   (((x) & TX_OVRD_IN_LO_TX_DATA_EN_OVRD_MASK) >> TX_OVRD_IN_LO_TX_DATA_EN_OVRD_LSB)
#define TX_OVRD_IN_LO_TX_DATA_EN_OVRD_SET(x)                                   (((0 | (x)) << TX_OVRD_IN_LO_TX_DATA_EN_OVRD_LSB) & TX_OVRD_IN_LO_TX_DATA_EN_OVRD_MASK)
#define TX_OVRD_IN_LO_TX_DATA_EN_OVRD_RESET                                    0x0
#define TX_OVRD_IN_LO_TX_DATA_EN_LSB                                           4
#define TX_OVRD_IN_LO_TX_DATA_EN_MSB                                           4
#define TX_OVRD_IN_LO_TX_DATA_EN_MASK                                          0x10
#define TX_OVRD_IN_LO_TX_DATA_EN_GET(x)                                        (((x) & TX_OVRD_IN_LO_TX_DATA_EN_MASK) >> TX_OVRD_IN_LO_TX_DATA_EN_LSB)
#define TX_OVRD_IN_LO_TX_DATA_EN_SET(x)                                        (((0 | (x)) << TX_OVRD_IN_LO_TX_DATA_EN_LSB) & TX_OVRD_IN_LO_TX_DATA_EN_MASK)
#define TX_OVRD_IN_LO_TX_DATA_EN_RESET                                         0x0
#define TX_OVRD_IN_LO_TX_INVERT_OVRD_LSB                                       3
#define TX_OVRD_IN_LO_TX_INVERT_OVRD_MSB                                       3
#define TX_OVRD_IN_LO_TX_INVERT_OVRD_MASK                                      0x8
#define TX_OVRD_IN_LO_TX_INVERT_OVRD_GET(x)                                    (((x) & TX_OVRD_IN_LO_TX_INVERT_OVRD_MASK) >> TX_OVRD_IN_LO_TX_INVERT_OVRD_LSB)
#define TX_OVRD_IN_LO_TX_INVERT_OVRD_SET(x)                                    (((0 | (x)) << TX_OVRD_IN_LO_TX_INVERT_OVRD_LSB) & TX_OVRD_IN_LO_TX_INVERT_OVRD_MASK)
#define TX_OVRD_IN_LO_TX_INVERT_OVRD_RESET                                     0x0
#define TX_OVRD_IN_LO_TX_INVERT_LSB                                            2
#define TX_OVRD_IN_LO_TX_INVERT_MSB                                            2
#define TX_OVRD_IN_LO_TX_INVERT_MASK                                           0x4
#define TX_OVRD_IN_LO_TX_INVERT_GET(x)                                         (((x) & TX_OVRD_IN_LO_TX_INVERT_MASK) >> TX_OVRD_IN_LO_TX_INVERT_LSB)
#define TX_OVRD_IN_LO_TX_INVERT_SET(x)                                         (((0 | (x)) << TX_OVRD_IN_LO_TX_INVERT_LSB) & TX_OVRD_IN_LO_TX_INVERT_MASK)
#define TX_OVRD_IN_LO_TX_INVERT_RESET                                          0x0
#define TX_OVRD_IN_LO_TX_LOOPBK_EN_OVRD_LSB                                    1
#define TX_OVRD_IN_LO_TX_LOOPBK_EN_OVRD_MSB                                    1
#define TX_OVRD_IN_LO_TX_LOOPBK_EN_OVRD_MASK                                   0x2
#define TX_OVRD_IN_LO_TX_LOOPBK_EN_OVRD_GET(x)                                 (((x) & TX_OVRD_IN_LO_TX_LOOPBK_EN_OVRD_MASK) >> TX_OVRD_IN_LO_TX_LOOPBK_EN_OVRD_LSB)
#define TX_OVRD_IN_LO_TX_LOOPBK_EN_OVRD_SET(x)                                 (((0 | (x)) << TX_OVRD_IN_LO_TX_LOOPBK_EN_OVRD_LSB) & TX_OVRD_IN_LO_TX_LOOPBK_EN_OVRD_MASK)
#define TX_OVRD_IN_LO_TX_LOOPBK_EN_OVRD_RESET                                  0x0
#define TX_OVRD_IN_LO_LOOPBK_EN_LSB                                            0
#define TX_OVRD_IN_LO_LOOPBK_EN_MSB                                            0
#define TX_OVRD_IN_LO_LOOPBK_EN_MASK                                           0x1
#define TX_OVRD_IN_LO_LOOPBK_EN_GET(x)                                         (((x) & TX_OVRD_IN_LO_LOOPBK_EN_MASK) >> TX_OVRD_IN_LO_LOOPBK_EN_LSB)
#define TX_OVRD_IN_LO_LOOPBK_EN_SET(x)                                         (((0 | (x)) << TX_OVRD_IN_LO_LOOPBK_EN_LSB) & TX_OVRD_IN_LO_LOOPBK_EN_MASK)
#define TX_OVRD_IN_LO_LOOPBK_EN_RESET                                          0x0
#define TX_OVRD_IN_LO_ADDRESS                                                  (0x4000 + __PCIE_PHY_REG_BASE_ADDRESS)
#define TX_OVRD_IN_LO_RSTMASK                                                  0x3fff
#define TX_OVRD_IN_LO_RESET                                                    0x0

// 0x4004 (TX_OVRD_IN_HI)
#define TX_OVRD_IN_HI_TX_VBOOST_EN_OVRD_LSB                                    9
#define TX_OVRD_IN_HI_TX_VBOOST_EN_OVRD_MSB                                    9
#define TX_OVRD_IN_HI_TX_VBOOST_EN_OVRD_MASK                                   0x200
#define TX_OVRD_IN_HI_TX_VBOOST_EN_OVRD_GET(x)                                 (((x) & TX_OVRD_IN_HI_TX_VBOOST_EN_OVRD_MASK) >> TX_OVRD_IN_HI_TX_VBOOST_EN_OVRD_LSB)
#define TX_OVRD_IN_HI_TX_VBOOST_EN_OVRD_SET(x)                                 (((0 | (x)) << TX_OVRD_IN_HI_TX_VBOOST_EN_OVRD_LSB) & TX_OVRD_IN_HI_TX_VBOOST_EN_OVRD_MASK)
#define TX_OVRD_IN_HI_TX_VBOOST_EN_OVRD_RESET                                  0x0
#define TX_OVRD_IN_HI_TX_VBOOST_EN_LSB                                         8
#define TX_OVRD_IN_HI_TX_VBOOST_EN_MSB                                         8
#define TX_OVRD_IN_HI_TX_VBOOST_EN_MASK                                        0x100
#define TX_OVRD_IN_HI_TX_VBOOST_EN_GET(x)                                      (((x) & TX_OVRD_IN_HI_TX_VBOOST_EN_MASK) >> TX_OVRD_IN_HI_TX_VBOOST_EN_LSB)
#define TX_OVRD_IN_HI_TX_VBOOST_EN_SET(x)                                      (((0 | (x)) << TX_OVRD_IN_HI_TX_VBOOST_EN_LSB) & TX_OVRD_IN_HI_TX_VBOOST_EN_MASK)
#define TX_OVRD_IN_HI_TX_VBOOST_EN_RESET                                       0x0
#define TX_OVRD_IN_HI_TX_RESET_OVRD_LSB                                        7
#define TX_OVRD_IN_HI_TX_RESET_OVRD_MSB                                        7
#define TX_OVRD_IN_HI_TX_RESET_OVRD_MASK                                       0x80
#define TX_OVRD_IN_HI_TX_RESET_OVRD_GET(x)                                     (((x) & TX_OVRD_IN_HI_TX_RESET_OVRD_MASK) >> TX_OVRD_IN_HI_TX_RESET_OVRD_LSB)
#define TX_OVRD_IN_HI_TX_RESET_OVRD_SET(x)                                     (((0 | (x)) << TX_OVRD_IN_HI_TX_RESET_OVRD_LSB) & TX_OVRD_IN_HI_TX_RESET_OVRD_MASK)
#define TX_OVRD_IN_HI_TX_RESET_OVRD_RESET                                      0x0
#define TX_OVRD_IN_HI_TX_RESET_LSB                                             6
#define TX_OVRD_IN_HI_TX_RESET_MSB                                             6
#define TX_OVRD_IN_HI_TX_RESET_MASK                                            0x40
#define TX_OVRD_IN_HI_TX_RESET_GET(x)                                          (((x) & TX_OVRD_IN_HI_TX_RESET_MASK) >> TX_OVRD_IN_HI_TX_RESET_LSB)
#define TX_OVRD_IN_HI_TX_RESET_SET(x)                                          (((0 | (x)) << TX_OVRD_IN_HI_TX_RESET_LSB) & TX_OVRD_IN_HI_TX_RESET_MASK)
#define TX_OVRD_IN_HI_TX_RESET_RESET                                           0x0
#define TX_OVRD_IN_HI_TX_NYQUIST_DATA_LSB                                      5
#define TX_OVRD_IN_HI_TX_NYQUIST_DATA_MSB                                      5
#define TX_OVRD_IN_HI_TX_NYQUIST_DATA_MASK                                     0x20
#define TX_OVRD_IN_HI_TX_NYQUIST_DATA_GET(x)                                   (((x) & TX_OVRD_IN_HI_TX_NYQUIST_DATA_MASK) >> TX_OVRD_IN_HI_TX_NYQUIST_DATA_LSB)
#define TX_OVRD_IN_HI_TX_NYQUIST_DATA_SET(x)                                   (((0 | (x)) << TX_OVRD_IN_HI_TX_NYQUIST_DATA_LSB) & TX_OVRD_IN_HI_TX_NYQUIST_DATA_MASK)
#define TX_OVRD_IN_HI_TX_NYQUIST_DATA_RESET                                    0x0
#define TX_OVRD_IN_HI_TX_CLK_OUT_EN_OVRD_LSB                                   4
#define TX_OVRD_IN_HI_TX_CLK_OUT_EN_OVRD_MSB                                   4
#define TX_OVRD_IN_HI_TX_CLK_OUT_EN_OVRD_MASK                                  0x10
#define TX_OVRD_IN_HI_TX_CLK_OUT_EN_OVRD_GET(x)                                (((x) & TX_OVRD_IN_HI_TX_CLK_OUT_EN_OVRD_MASK) >> TX_OVRD_IN_HI_TX_CLK_OUT_EN_OVRD_LSB)
#define TX_OVRD_IN_HI_TX_CLK_OUT_EN_OVRD_SET(x)                                (((0 | (x)) << TX_OVRD_IN_HI_TX_CLK_OUT_EN_OVRD_LSB) & TX_OVRD_IN_HI_TX_CLK_OUT_EN_OVRD_MASK)
#define TX_OVRD_IN_HI_TX_CLK_OUT_EN_OVRD_RESET                                 0x0
#define TX_OVRD_IN_HI_TX_CLK_OUT_EN_LSB                                        3
#define TX_OVRD_IN_HI_TX_CLK_OUT_EN_MSB                                        3
#define TX_OVRD_IN_HI_TX_CLK_OUT_EN_MASK                                       0x8
#define TX_OVRD_IN_HI_TX_CLK_OUT_EN_GET(x)                                     (((x) & TX_OVRD_IN_HI_TX_CLK_OUT_EN_MASK) >> TX_OVRD_IN_HI_TX_CLK_OUT_EN_LSB)
#define TX_OVRD_IN_HI_TX_CLK_OUT_EN_SET(x)                                     (((0 | (x)) << TX_OVRD_IN_HI_TX_CLK_OUT_EN_LSB) & TX_OVRD_IN_HI_TX_CLK_OUT_EN_MASK)
#define TX_OVRD_IN_HI_TX_CLK_OUT_EN_RESET                                      0x0
#define TX_OVRD_IN_HI_TX_RATE_OVRD_LSB                                         2
#define TX_OVRD_IN_HI_TX_RATE_OVRD_MSB                                         2
#define TX_OVRD_IN_HI_TX_RATE_OVRD_MASK                                        0x4
#define TX_OVRD_IN_HI_TX_RATE_OVRD_GET(x)                                      (((x) & TX_OVRD_IN_HI_TX_RATE_OVRD_MASK) >> TX_OVRD_IN_HI_TX_RATE_OVRD_LSB)
#define TX_OVRD_IN_HI_TX_RATE_OVRD_SET(x)                                      (((0 | (x)) << TX_OVRD_IN_HI_TX_RATE_OVRD_LSB) & TX_OVRD_IN_HI_TX_RATE_OVRD_MASK)
#define TX_OVRD_IN_HI_TX_RATE_OVRD_RESET                                       0x0
#define TX_OVRD_IN_HI_TX_RATE_LSB                                              0
#define TX_OVRD_IN_HI_TX_RATE_MSB                                              1
#define TX_OVRD_IN_HI_TX_RATE_MASK                                             0x3
#define TX_OVRD_IN_HI_TX_RATE_GET(x)                                           (((x) & TX_OVRD_IN_HI_TX_RATE_MASK) >> TX_OVRD_IN_HI_TX_RATE_LSB)
#define TX_OVRD_IN_HI_TX_RATE_SET(x)                                           (((0 | (x)) << TX_OVRD_IN_HI_TX_RATE_LSB) & TX_OVRD_IN_HI_TX_RATE_MASK)
#define TX_OVRD_IN_HI_TX_RATE_RESET                                            0x0
#define TX_OVRD_IN_HI_ADDRESS                                                  (0x4004 + __PCIE_PHY_REG_BASE_ADDRESS)
#define TX_OVRD_IN_HI_RSTMASK                                                  0x3ff
#define TX_OVRD_IN_HI_RESET                                                    0x0

// 0x4008 (TX_OVRD_DRV_LO)
#define TX_OVRD_DRV_LO_EN_LSB                                                  14
#define TX_OVRD_DRV_LO_EN_MSB                                                  14
#define TX_OVRD_DRV_LO_EN_MASK                                                 0x4000
#define TX_OVRD_DRV_LO_EN_GET(x)                                               (((x) & TX_OVRD_DRV_LO_EN_MASK) >> TX_OVRD_DRV_LO_EN_LSB)
#define TX_OVRD_DRV_LO_EN_SET(x)                                               (((0 | (x)) << TX_OVRD_DRV_LO_EN_LSB) & TX_OVRD_DRV_LO_EN_MASK)
#define TX_OVRD_DRV_LO_EN_RESET                                                0x0
#define TX_OVRD_DRV_LO_PREEMPH_LSB                                             7
#define TX_OVRD_DRV_LO_PREEMPH_MSB                                             13
#define TX_OVRD_DRV_LO_PREEMPH_MASK                                            0x3f80
#define TX_OVRD_DRV_LO_PREEMPH_GET(x)                                          (((x) & TX_OVRD_DRV_LO_PREEMPH_MASK) >> TX_OVRD_DRV_LO_PREEMPH_LSB)
#define TX_OVRD_DRV_LO_PREEMPH_SET(x)                                          (((0 | (x)) << TX_OVRD_DRV_LO_PREEMPH_LSB) & TX_OVRD_DRV_LO_PREEMPH_MASK)
#define TX_OVRD_DRV_LO_PREEMPH_RESET                                           0x0
#define TX_OVRD_DRV_LO_AMPLITUDE_LSB                                           0
#define TX_OVRD_DRV_LO_AMPLITUDE_MSB                                           6
#define TX_OVRD_DRV_LO_AMPLITUDE_MASK                                          0x7f
#define TX_OVRD_DRV_LO_AMPLITUDE_GET(x)                                        (((x) & TX_OVRD_DRV_LO_AMPLITUDE_MASK) >> TX_OVRD_DRV_LO_AMPLITUDE_LSB)
#define TX_OVRD_DRV_LO_AMPLITUDE_SET(x)                                        (((0 | (x)) << TX_OVRD_DRV_LO_AMPLITUDE_LSB) & TX_OVRD_DRV_LO_AMPLITUDE_MASK)
#define TX_OVRD_DRV_LO_AMPLITUDE_RESET                                         0x0
#define TX_OVRD_DRV_LO_ADDRESS                                                 (0x4008 + __PCIE_PHY_REG_BASE_ADDRESS)
#define TX_OVRD_DRV_LO_RSTMASK                                                 0x7fff
#define TX_OVRD_DRV_LO_RESET                                                   0x0

// 0x400c (TX_OVRD_DRV_HI)
#define TX_OVRD_DRV_HI_EN_LSB                                                  5
#define TX_OVRD_DRV_HI_EN_MSB                                                  5
#define TX_OVRD_DRV_HI_EN_MASK                                                 0x20
#define TX_OVRD_DRV_HI_EN_GET(x)                                               (((x) & TX_OVRD_DRV_HI_EN_MASK) >> TX_OVRD_DRV_HI_EN_LSB)
#define TX_OVRD_DRV_HI_EN_SET(x)                                               (((0 | (x)) << TX_OVRD_DRV_HI_EN_LSB) & TX_OVRD_DRV_HI_EN_MASK)
#define TX_OVRD_DRV_HI_EN_RESET                                                0x0
#define TX_OVRD_DRV_HI_TERM_OFFSET_LSB                                         0
#define TX_OVRD_DRV_HI_TERM_OFFSET_MSB                                         4
#define TX_OVRD_DRV_HI_TERM_OFFSET_MASK                                        0x1f
#define TX_OVRD_DRV_HI_TERM_OFFSET_GET(x)                                      (((x) & TX_OVRD_DRV_HI_TERM_OFFSET_MASK) >> TX_OVRD_DRV_HI_TERM_OFFSET_LSB)
#define TX_OVRD_DRV_HI_TERM_OFFSET_SET(x)                                      (((0 | (x)) << TX_OVRD_DRV_HI_TERM_OFFSET_LSB) & TX_OVRD_DRV_HI_TERM_OFFSET_MASK)
#define TX_OVRD_DRV_HI_TERM_OFFSET_RESET                                       0x0
#define TX_OVRD_DRV_HI_ADDRESS                                                 (0x400c + __PCIE_PHY_REG_BASE_ADDRESS)
#define TX_OVRD_DRV_HI_RSTMASK                                                 0x3f
#define TX_OVRD_DRV_HI_RESET                                                   0x0

// 0x4010 (TX_OVRD_OUT)
#define TX_OVRD_OUT_TX_STATE_OVRD_LSB                                          7
#define TX_OVRD_OUT_TX_STATE_OVRD_MSB                                          7
#define TX_OVRD_OUT_TX_STATE_OVRD_MASK                                         0x80
#define TX_OVRD_OUT_TX_STATE_OVRD_GET(x)                                       (((x) & TX_OVRD_OUT_TX_STATE_OVRD_MASK) >> TX_OVRD_OUT_TX_STATE_OVRD_LSB)
#define TX_OVRD_OUT_TX_STATE_OVRD_SET(x)                                       (((0 | (x)) << TX_OVRD_OUT_TX_STATE_OVRD_LSB) & TX_OVRD_OUT_TX_STATE_OVRD_MASK)
#define TX_OVRD_OUT_TX_STATE_OVRD_RESET                                        0x0
#define TX_OVRD_OUT_TX_STATE_LSB                                               6
#define TX_OVRD_OUT_TX_STATE_MSB                                               6
#define TX_OVRD_OUT_TX_STATE_MASK                                              0x40
#define TX_OVRD_OUT_TX_STATE_GET(x)                                            (((x) & TX_OVRD_OUT_TX_STATE_MASK) >> TX_OVRD_OUT_TX_STATE_LSB)
#define TX_OVRD_OUT_TX_STATE_SET(x)                                            (((0 | (x)) << TX_OVRD_OUT_TX_STATE_LSB) & TX_OVRD_OUT_TX_STATE_MASK)
#define TX_OVRD_OUT_TX_STATE_RESET                                             0x0
#define TX_OVRD_OUT_TX_CM_STATE_OVRD_LSB                                       5
#define TX_OVRD_OUT_TX_CM_STATE_OVRD_MSB                                       5
#define TX_OVRD_OUT_TX_CM_STATE_OVRD_MASK                                      0x20
#define TX_OVRD_OUT_TX_CM_STATE_OVRD_GET(x)                                    (((x) & TX_OVRD_OUT_TX_CM_STATE_OVRD_MASK) >> TX_OVRD_OUT_TX_CM_STATE_OVRD_LSB)
#define TX_OVRD_OUT_TX_CM_STATE_OVRD_SET(x)                                    (((0 | (x)) << TX_OVRD_OUT_TX_CM_STATE_OVRD_LSB) & TX_OVRD_OUT_TX_CM_STATE_OVRD_MASK)
#define TX_OVRD_OUT_TX_CM_STATE_OVRD_RESET                                     0x0
#define TX_OVRD_OUT_TX_CM_STATE_LSB                                            4
#define TX_OVRD_OUT_TX_CM_STATE_MSB                                            4
#define TX_OVRD_OUT_TX_CM_STATE_MASK                                           0x10
#define TX_OVRD_OUT_TX_CM_STATE_GET(x)                                         (((x) & TX_OVRD_OUT_TX_CM_STATE_MASK) >> TX_OVRD_OUT_TX_CM_STATE_LSB)
#define TX_OVRD_OUT_TX_CM_STATE_SET(x)                                         (((0 | (x)) << TX_OVRD_OUT_TX_CM_STATE_LSB) & TX_OVRD_OUT_TX_CM_STATE_MASK)
#define TX_OVRD_OUT_TX_CM_STATE_RESET                                          0x0
#define TX_OVRD_OUT_TX_DETECT_RX_ACK_OVRD_LSB                                  3
#define TX_OVRD_OUT_TX_DETECT_RX_ACK_OVRD_MSB                                  3
#define TX_OVRD_OUT_TX_DETECT_RX_ACK_OVRD_MASK                                 0x8
#define TX_OVRD_OUT_TX_DETECT_RX_ACK_OVRD_GET(x)                               (((x) & TX_OVRD_OUT_TX_DETECT_RX_ACK_OVRD_MASK) >> TX_OVRD_OUT_TX_DETECT_RX_ACK_OVRD_LSB)
#define TX_OVRD_OUT_TX_DETECT_RX_ACK_OVRD_SET(x)                               (((0 | (x)) << TX_OVRD_OUT_TX_DETECT_RX_ACK_OVRD_LSB) & TX_OVRD_OUT_TX_DETECT_RX_ACK_OVRD_MASK)
#define TX_OVRD_OUT_TX_DETECT_RX_ACK_OVRD_RESET                                0x0
#define TX_OVRD_OUT_TX_DETECT_RX_ACK_LSB                                       2
#define TX_OVRD_OUT_TX_DETECT_RX_ACK_MSB                                       2
#define TX_OVRD_OUT_TX_DETECT_RX_ACK_MASK                                      0x4
#define TX_OVRD_OUT_TX_DETECT_RX_ACK_GET(x)                                    (((x) & TX_OVRD_OUT_TX_DETECT_RX_ACK_MASK) >> TX_OVRD_OUT_TX_DETECT_RX_ACK_LSB)
#define TX_OVRD_OUT_TX_DETECT_RX_ACK_SET(x)                                    (((0 | (x)) << TX_OVRD_OUT_TX_DETECT_RX_ACK_LSB) & TX_OVRD_OUT_TX_DETECT_RX_ACK_MASK)
#define TX_OVRD_OUT_TX_DETECT_RX_ACK_RESET                                     0x0
#define TX_OVRD_OUT_DETECT_RX_RES_OVRD_LSB                                     1
#define TX_OVRD_OUT_DETECT_RX_RES_OVRD_MSB                                     1
#define TX_OVRD_OUT_DETECT_RX_RES_OVRD_MASK                                    0x2
#define TX_OVRD_OUT_DETECT_RX_RES_OVRD_GET(x)                                  (((x) & TX_OVRD_OUT_DETECT_RX_RES_OVRD_MASK) >> TX_OVRD_OUT_DETECT_RX_RES_OVRD_LSB)
#define TX_OVRD_OUT_DETECT_RX_RES_OVRD_SET(x)                                  (((0 | (x)) << TX_OVRD_OUT_DETECT_RX_RES_OVRD_LSB) & TX_OVRD_OUT_DETECT_RX_RES_OVRD_MASK)
#define TX_OVRD_OUT_DETECT_RX_RES_OVRD_RESET                                   0x0
#define TX_OVRD_OUT_DETECT_RX_RES_LSB                                          0
#define TX_OVRD_OUT_DETECT_RX_RES_MSB                                          0
#define TX_OVRD_OUT_DETECT_RX_RES_MASK                                         0x1
#define TX_OVRD_OUT_DETECT_RX_RES_GET(x)                                       (((x) & TX_OVRD_OUT_DETECT_RX_RES_MASK) >> TX_OVRD_OUT_DETECT_RX_RES_LSB)
#define TX_OVRD_OUT_DETECT_RX_RES_SET(x)                                       (((0 | (x)) << TX_OVRD_OUT_DETECT_RX_RES_LSB) & TX_OVRD_OUT_DETECT_RX_RES_MASK)
#define TX_OVRD_OUT_DETECT_RX_RES_RESET                                        0x0
#define TX_OVRD_OUT_ADDRESS                                                    (0x4010 + __PCIE_PHY_REG_BASE_ADDRESS)
#define TX_OVRD_OUT_RSTMASK                                                    0xff
#define TX_OVRD_OUT_RESET                                                      0x0

// 0x4014 (RX_OVRD_IN_LO)
#define RX_OVRD_IN_LO_RX_LOS_EN_OVRD_LSB                                       13
#define RX_OVRD_IN_LO_RX_LOS_EN_OVRD_MSB                                       13
#define RX_OVRD_IN_LO_RX_LOS_EN_OVRD_MASK                                      0x2000
#define RX_OVRD_IN_LO_RX_LOS_EN_OVRD_GET(x)                                    (((x) & RX_OVRD_IN_LO_RX_LOS_EN_OVRD_MASK) >> RX_OVRD_IN_LO_RX_LOS_EN_OVRD_LSB)
#define RX_OVRD_IN_LO_RX_LOS_EN_OVRD_SET(x)                                    (((0 | (x)) << RX_OVRD_IN_LO_RX_LOS_EN_OVRD_LSB) & RX_OVRD_IN_LO_RX_LOS_EN_OVRD_MASK)
#define RX_OVRD_IN_LO_RX_LOS_EN_OVRD_RESET                                     0x0
#define RX_OVRD_IN_LO_RX_LOS_EN_LSB                                            12
#define RX_OVRD_IN_LO_RX_LOS_EN_MSB                                            12
#define RX_OVRD_IN_LO_RX_LOS_EN_MASK                                           0x1000
#define RX_OVRD_IN_LO_RX_LOS_EN_GET(x)                                         (((x) & RX_OVRD_IN_LO_RX_LOS_EN_MASK) >> RX_OVRD_IN_LO_RX_LOS_EN_LSB)
#define RX_OVRD_IN_LO_RX_LOS_EN_SET(x)                                         (((0 | (x)) << RX_OVRD_IN_LO_RX_LOS_EN_LSB) & RX_OVRD_IN_LO_RX_LOS_EN_MASK)
#define RX_OVRD_IN_LO_RX_LOS_EN_RESET                                          0x0
#define RX_OVRD_IN_LO_RX_TERM_EN_OVRD_LSB                                      11
#define RX_OVRD_IN_LO_RX_TERM_EN_OVRD_MSB                                      11
#define RX_OVRD_IN_LO_RX_TERM_EN_OVRD_MASK                                     0x800
#define RX_OVRD_IN_LO_RX_TERM_EN_OVRD_GET(x)                                   (((x) & RX_OVRD_IN_LO_RX_TERM_EN_OVRD_MASK) >> RX_OVRD_IN_LO_RX_TERM_EN_OVRD_LSB)
#define RX_OVRD_IN_LO_RX_TERM_EN_OVRD_SET(x)                                   (((0 | (x)) << RX_OVRD_IN_LO_RX_TERM_EN_OVRD_LSB) & RX_OVRD_IN_LO_RX_TERM_EN_OVRD_MASK)
#define RX_OVRD_IN_LO_RX_TERM_EN_OVRD_RESET                                    0x0
#define RX_OVRD_IN_LO_RX_TERM_EN_LSB                                           10
#define RX_OVRD_IN_LO_RX_TERM_EN_MSB                                           10
#define RX_OVRD_IN_LO_RX_TERM_EN_MASK                                          0x400
#define RX_OVRD_IN_LO_RX_TERM_EN_GET(x)                                        (((x) & RX_OVRD_IN_LO_RX_TERM_EN_MASK) >> RX_OVRD_IN_LO_RX_TERM_EN_LSB)
#define RX_OVRD_IN_LO_RX_TERM_EN_SET(x)                                        (((0 | (x)) << RX_OVRD_IN_LO_RX_TERM_EN_LSB) & RX_OVRD_IN_LO_RX_TERM_EN_MASK)
#define RX_OVRD_IN_LO_RX_TERM_EN_RESET                                         0x0
#define RX_OVRD_IN_LO_RX_BIT_SHIFT_OVRD_LSB                                    9
#define RX_OVRD_IN_LO_RX_BIT_SHIFT_OVRD_MSB                                    9
#define RX_OVRD_IN_LO_RX_BIT_SHIFT_OVRD_MASK                                   0x200
#define RX_OVRD_IN_LO_RX_BIT_SHIFT_OVRD_GET(x)                                 (((x) & RX_OVRD_IN_LO_RX_BIT_SHIFT_OVRD_MASK) >> RX_OVRD_IN_LO_RX_BIT_SHIFT_OVRD_LSB)
#define RX_OVRD_IN_LO_RX_BIT_SHIFT_OVRD_SET(x)                                 (((0 | (x)) << RX_OVRD_IN_LO_RX_BIT_SHIFT_OVRD_LSB) & RX_OVRD_IN_LO_RX_BIT_SHIFT_OVRD_MASK)
#define RX_OVRD_IN_LO_RX_BIT_SHIFT_OVRD_RESET                                  0x0
#define RX_OVRD_IN_LO_RX_BIT_SHIFT_LSB                                         8
#define RX_OVRD_IN_LO_RX_BIT_SHIFT_MSB                                         8
#define RX_OVRD_IN_LO_RX_BIT_SHIFT_MASK                                        0x100
#define RX_OVRD_IN_LO_RX_BIT_SHIFT_GET(x)                                      (((x) & RX_OVRD_IN_LO_RX_BIT_SHIFT_MASK) >> RX_OVRD_IN_LO_RX_BIT_SHIFT_LSB)
#define RX_OVRD_IN_LO_RX_BIT_SHIFT_SET(x)                                      (((0 | (x)) << RX_OVRD_IN_LO_RX_BIT_SHIFT_LSB) & RX_OVRD_IN_LO_RX_BIT_SHIFT_MASK)
#define RX_OVRD_IN_LO_RX_BIT_SHIFT_RESET                                       0x0
#define RX_OVRD_IN_LO_RX_ALIGN_EN_OVRD_LSB                                     7
#define RX_OVRD_IN_LO_RX_ALIGN_EN_OVRD_MSB                                     7
#define RX_OVRD_IN_LO_RX_ALIGN_EN_OVRD_MASK                                    0x80
#define RX_OVRD_IN_LO_RX_ALIGN_EN_OVRD_GET(x)                                  (((x) & RX_OVRD_IN_LO_RX_ALIGN_EN_OVRD_MASK) >> RX_OVRD_IN_LO_RX_ALIGN_EN_OVRD_LSB)
#define RX_OVRD_IN_LO_RX_ALIGN_EN_OVRD_SET(x)                                  (((0 | (x)) << RX_OVRD_IN_LO_RX_ALIGN_EN_OVRD_LSB) & RX_OVRD_IN_LO_RX_ALIGN_EN_OVRD_MASK)
#define RX_OVRD_IN_LO_RX_ALIGN_EN_OVRD_RESET                                   0x0
#define RX_OVRD_IN_LO_RX_ALIGN_EN_LSB                                          6
#define RX_OVRD_IN_LO_RX_ALIGN_EN_MSB                                          6
#define RX_OVRD_IN_LO_RX_ALIGN_EN_MASK                                         0x40
#define RX_OVRD_IN_LO_RX_ALIGN_EN_GET(x)                                       (((x) & RX_OVRD_IN_LO_RX_ALIGN_EN_MASK) >> RX_OVRD_IN_LO_RX_ALIGN_EN_LSB)
#define RX_OVRD_IN_LO_RX_ALIGN_EN_SET(x)                                       (((0 | (x)) << RX_OVRD_IN_LO_RX_ALIGN_EN_LSB) & RX_OVRD_IN_LO_RX_ALIGN_EN_MASK)
#define RX_OVRD_IN_LO_RX_ALIGN_EN_RESET                                        0x0
#define RX_OVRD_IN_LO_RX_DATA_EN_OVRD_LSB                                      5
#define RX_OVRD_IN_LO_RX_DATA_EN_OVRD_MSB                                      5
#define RX_OVRD_IN_LO_RX_DATA_EN_OVRD_MASK                                     0x20
#define RX_OVRD_IN_LO_RX_DATA_EN_OVRD_GET(x)                                   (((x) & RX_OVRD_IN_LO_RX_DATA_EN_OVRD_MASK) >> RX_OVRD_IN_LO_RX_DATA_EN_OVRD_LSB)
#define RX_OVRD_IN_LO_RX_DATA_EN_OVRD_SET(x)                                   (((0 | (x)) << RX_OVRD_IN_LO_RX_DATA_EN_OVRD_LSB) & RX_OVRD_IN_LO_RX_DATA_EN_OVRD_MASK)
#define RX_OVRD_IN_LO_RX_DATA_EN_OVRD_RESET                                    0x0
#define RX_OVRD_IN_LO_RX_DATA_EN_LSB                                           4
#define RX_OVRD_IN_LO_RX_DATA_EN_MSB                                           4
#define RX_OVRD_IN_LO_RX_DATA_EN_MASK                                          0x10
#define RX_OVRD_IN_LO_RX_DATA_EN_GET(x)                                        (((x) & RX_OVRD_IN_LO_RX_DATA_EN_MASK) >> RX_OVRD_IN_LO_RX_DATA_EN_LSB)
#define RX_OVRD_IN_LO_RX_DATA_EN_SET(x)                                        (((0 | (x)) << RX_OVRD_IN_LO_RX_DATA_EN_LSB) & RX_OVRD_IN_LO_RX_DATA_EN_MASK)
#define RX_OVRD_IN_LO_RX_DATA_EN_RESET                                         0x0
#define RX_OVRD_IN_LO_RX_PLL_EN_OVRD_LSB                                       3
#define RX_OVRD_IN_LO_RX_PLL_EN_OVRD_MSB                                       3
#define RX_OVRD_IN_LO_RX_PLL_EN_OVRD_MASK                                      0x8
#define RX_OVRD_IN_LO_RX_PLL_EN_OVRD_GET(x)                                    (((x) & RX_OVRD_IN_LO_RX_PLL_EN_OVRD_MASK) >> RX_OVRD_IN_LO_RX_PLL_EN_OVRD_LSB)
#define RX_OVRD_IN_LO_RX_PLL_EN_OVRD_SET(x)                                    (((0 | (x)) << RX_OVRD_IN_LO_RX_PLL_EN_OVRD_LSB) & RX_OVRD_IN_LO_RX_PLL_EN_OVRD_MASK)
#define RX_OVRD_IN_LO_RX_PLL_EN_OVRD_RESET                                     0x0
#define RX_OVRD_IN_LO_RX_PLL_EN_LSB                                            2
#define RX_OVRD_IN_LO_RX_PLL_EN_MSB                                            2
#define RX_OVRD_IN_LO_RX_PLL_EN_MASK                                           0x4
#define RX_OVRD_IN_LO_RX_PLL_EN_GET(x)                                         (((x) & RX_OVRD_IN_LO_RX_PLL_EN_MASK) >> RX_OVRD_IN_LO_RX_PLL_EN_LSB)
#define RX_OVRD_IN_LO_RX_PLL_EN_SET(x)                                         (((0 | (x)) << RX_OVRD_IN_LO_RX_PLL_EN_LSB) & RX_OVRD_IN_LO_RX_PLL_EN_MASK)
#define RX_OVRD_IN_LO_RX_PLL_EN_RESET                                          0x0
#define RX_OVRD_IN_LO_RX_INVERT_OVRD_LSB                                       1
#define RX_OVRD_IN_LO_RX_INVERT_OVRD_MSB                                       1
#define RX_OVRD_IN_LO_RX_INVERT_OVRD_MASK                                      0x2
#define RX_OVRD_IN_LO_RX_INVERT_OVRD_GET(x)                                    (((x) & RX_OVRD_IN_LO_RX_INVERT_OVRD_MASK) >> RX_OVRD_IN_LO_RX_INVERT_OVRD_LSB)
#define RX_OVRD_IN_LO_RX_INVERT_OVRD_SET(x)                                    (((0 | (x)) << RX_OVRD_IN_LO_RX_INVERT_OVRD_LSB) & RX_OVRD_IN_LO_RX_INVERT_OVRD_MASK)
#define RX_OVRD_IN_LO_RX_INVERT_OVRD_RESET                                     0x0
#define RX_OVRD_IN_LO_RX_INVERT_LSB                                            0
#define RX_OVRD_IN_LO_RX_INVERT_MSB                                            0
#define RX_OVRD_IN_LO_RX_INVERT_MASK                                           0x1
#define RX_OVRD_IN_LO_RX_INVERT_GET(x)                                         (((x) & RX_OVRD_IN_LO_RX_INVERT_MASK) >> RX_OVRD_IN_LO_RX_INVERT_LSB)
#define RX_OVRD_IN_LO_RX_INVERT_SET(x)                                         (((0 | (x)) << RX_OVRD_IN_LO_RX_INVERT_LSB) & RX_OVRD_IN_LO_RX_INVERT_MASK)
#define RX_OVRD_IN_LO_RX_INVERT_RESET                                          0x0
#define RX_OVRD_IN_LO_ADDRESS                                                  (0x4014 + __PCIE_PHY_REG_BASE_ADDRESS)
#define RX_OVRD_IN_LO_RSTMASK                                                  0x3fff
#define RX_OVRD_IN_LO_RESET                                                    0x0

// 0x4018 (RX_OVRD_IN_HI)
#define RX_OVRD_IN_HI_RX_RESET_OVRD_LSB                                        13
#define RX_OVRD_IN_HI_RX_RESET_OVRD_MSB                                        13
#define RX_OVRD_IN_HI_RX_RESET_OVRD_MASK                                       0x2000
#define RX_OVRD_IN_HI_RX_RESET_OVRD_GET(x)                                     (((x) & RX_OVRD_IN_HI_RX_RESET_OVRD_MASK) >> RX_OVRD_IN_HI_RX_RESET_OVRD_LSB)
#define RX_OVRD_IN_HI_RX_RESET_OVRD_SET(x)                                     (((0 | (x)) << RX_OVRD_IN_HI_RX_RESET_OVRD_LSB) & RX_OVRD_IN_HI_RX_RESET_OVRD_MASK)
#define RX_OVRD_IN_HI_RX_RESET_OVRD_RESET                                      0x0
#define RX_OVRD_IN_HI_RX_RESET_LSB                                             12
#define RX_OVRD_IN_HI_RX_RESET_MSB                                             12
#define RX_OVRD_IN_HI_RX_RESET_MASK                                            0x1000
#define RX_OVRD_IN_HI_RX_RESET_GET(x)                                          (((x) & RX_OVRD_IN_HI_RX_RESET_MASK) >> RX_OVRD_IN_HI_RX_RESET_LSB)
#define RX_OVRD_IN_HI_RX_RESET_SET(x)                                          (((0 | (x)) << RX_OVRD_IN_HI_RX_RESET_LSB) & RX_OVRD_IN_HI_RX_RESET_MASK)
#define RX_OVRD_IN_HI_RX_RESET_RESET                                           0x0
#define RX_OVRD_IN_HI_RX_EQ_OVRD_LSB                                           11
#define RX_OVRD_IN_HI_RX_EQ_OVRD_MSB                                           11
#define RX_OVRD_IN_HI_RX_EQ_OVRD_MASK                                          0x800
#define RX_OVRD_IN_HI_RX_EQ_OVRD_GET(x)                                        (((x) & RX_OVRD_IN_HI_RX_EQ_OVRD_MASK) >> RX_OVRD_IN_HI_RX_EQ_OVRD_LSB)
#define RX_OVRD_IN_HI_RX_EQ_OVRD_SET(x)                                        (((0 | (x)) << RX_OVRD_IN_HI_RX_EQ_OVRD_LSB) & RX_OVRD_IN_HI_RX_EQ_OVRD_MASK)
#define RX_OVRD_IN_HI_RX_EQ_OVRD_RESET                                         0x0
#define RX_OVRD_IN_HI_RX_EQ_LSB                                                8
#define RX_OVRD_IN_HI_RX_EQ_MSB                                                10
#define RX_OVRD_IN_HI_RX_EQ_MASK                                               0x700
#define RX_OVRD_IN_HI_RX_EQ_GET(x)                                             (((x) & RX_OVRD_IN_HI_RX_EQ_MASK) >> RX_OVRD_IN_HI_RX_EQ_LSB)
#define RX_OVRD_IN_HI_RX_EQ_SET(x)                                             (((0 | (x)) << RX_OVRD_IN_HI_RX_EQ_LSB) & RX_OVRD_IN_HI_RX_EQ_MASK)
#define RX_OVRD_IN_HI_RX_EQ_RESET                                              0x0
#define RX_OVRD_IN_HI_RX_EQ_EN_OVRD_LSB                                        7
#define RX_OVRD_IN_HI_RX_EQ_EN_OVRD_MSB                                        7
#define RX_OVRD_IN_HI_RX_EQ_EN_OVRD_MASK                                       0x80
#define RX_OVRD_IN_HI_RX_EQ_EN_OVRD_GET(x)                                     (((x) & RX_OVRD_IN_HI_RX_EQ_EN_OVRD_MASK) >> RX_OVRD_IN_HI_RX_EQ_EN_OVRD_LSB)
#define RX_OVRD_IN_HI_RX_EQ_EN_OVRD_SET(x)                                     (((0 | (x)) << RX_OVRD_IN_HI_RX_EQ_EN_OVRD_LSB) & RX_OVRD_IN_HI_RX_EQ_EN_OVRD_MASK)
#define RX_OVRD_IN_HI_RX_EQ_EN_OVRD_RESET                                      0x0
#define RX_OVRD_IN_HI_RX_EQ_EN_LSB                                             6
#define RX_OVRD_IN_HI_RX_EQ_EN_MSB                                             6
#define RX_OVRD_IN_HI_RX_EQ_EN_MASK                                            0x40
#define RX_OVRD_IN_HI_RX_EQ_EN_GET(x)                                          (((x) & RX_OVRD_IN_HI_RX_EQ_EN_MASK) >> RX_OVRD_IN_HI_RX_EQ_EN_LSB)
#define RX_OVRD_IN_HI_RX_EQ_EN_SET(x)                                          (((0 | (x)) << RX_OVRD_IN_HI_RX_EQ_EN_LSB) & RX_OVRD_IN_HI_RX_EQ_EN_MASK)
#define RX_OVRD_IN_HI_RX_EQ_EN_RESET                                           0x0
#define RX_OVRD_IN_HI_RX_LOS_FILTER_OVRD_LSB                                   5
#define RX_OVRD_IN_HI_RX_LOS_FILTER_OVRD_MSB                                   5
#define RX_OVRD_IN_HI_RX_LOS_FILTER_OVRD_MASK                                  0x20
#define RX_OVRD_IN_HI_RX_LOS_FILTER_OVRD_GET(x)                                (((x) & RX_OVRD_IN_HI_RX_LOS_FILTER_OVRD_MASK) >> RX_OVRD_IN_HI_RX_LOS_FILTER_OVRD_LSB)
#define RX_OVRD_IN_HI_RX_LOS_FILTER_OVRD_SET(x)                                (((0 | (x)) << RX_OVRD_IN_HI_RX_LOS_FILTER_OVRD_LSB) & RX_OVRD_IN_HI_RX_LOS_FILTER_OVRD_MASK)
#define RX_OVRD_IN_HI_RX_LOS_FILTER_OVRD_RESET                                 0x0
#define RX_OVRD_IN_HI_RX_LOS_FILTER_LSB                                        3
#define RX_OVRD_IN_HI_RX_LOS_FILTER_MSB                                        4
#define RX_OVRD_IN_HI_RX_LOS_FILTER_MASK                                       0x18
#define RX_OVRD_IN_HI_RX_LOS_FILTER_GET(x)                                     (((x) & RX_OVRD_IN_HI_RX_LOS_FILTER_MASK) >> RX_OVRD_IN_HI_RX_LOS_FILTER_LSB)
#define RX_OVRD_IN_HI_RX_LOS_FILTER_SET(x)                                     (((0 | (x)) << RX_OVRD_IN_HI_RX_LOS_FILTER_LSB) & RX_OVRD_IN_HI_RX_LOS_FILTER_MASK)
#define RX_OVRD_IN_HI_RX_LOS_FILTER_RESET                                      0x0
#define RX_OVRD_IN_HI_RX_RATE_OVRD_LSB                                         2
#define RX_OVRD_IN_HI_RX_RATE_OVRD_MSB                                         2
#define RX_OVRD_IN_HI_RX_RATE_OVRD_MASK                                        0x4
#define RX_OVRD_IN_HI_RX_RATE_OVRD_GET(x)                                      (((x) & RX_OVRD_IN_HI_RX_RATE_OVRD_MASK) >> RX_OVRD_IN_HI_RX_RATE_OVRD_LSB)
#define RX_OVRD_IN_HI_RX_RATE_OVRD_SET(x)                                      (((0 | (x)) << RX_OVRD_IN_HI_RX_RATE_OVRD_LSB) & RX_OVRD_IN_HI_RX_RATE_OVRD_MASK)
#define RX_OVRD_IN_HI_RX_RATE_OVRD_RESET                                       0x0
#define RX_OVRD_IN_HI_RX_RATE_LSB                                              0
#define RX_OVRD_IN_HI_RX_RATE_MSB                                              1
#define RX_OVRD_IN_HI_RX_RATE_MASK                                             0x3
#define RX_OVRD_IN_HI_RX_RATE_GET(x)                                           (((x) & RX_OVRD_IN_HI_RX_RATE_MASK) >> RX_OVRD_IN_HI_RX_RATE_LSB)
#define RX_OVRD_IN_HI_RX_RATE_SET(x)                                           (((0 | (x)) << RX_OVRD_IN_HI_RX_RATE_LSB) & RX_OVRD_IN_HI_RX_RATE_MASK)
#define RX_OVRD_IN_HI_RX_RATE_RESET                                            0x0
#define RX_OVRD_IN_HI_ADDRESS                                                  (0x4018 + __PCIE_PHY_REG_BASE_ADDRESS)
#define RX_OVRD_IN_HI_RSTMASK                                                  0x3fff
#define RX_OVRD_IN_HI_RESET                                                    0x0

// 0x401c (RX_OVRD_OUT)
#define RX_OVRD_OUT_ZERO_DATA_LSB                                              6
#define RX_OVRD_OUT_ZERO_DATA_MSB                                              6
#define RX_OVRD_OUT_ZERO_DATA_MASK                                             0x40
#define RX_OVRD_OUT_ZERO_DATA_GET(x)                                           (((x) & RX_OVRD_OUT_ZERO_DATA_MASK) >> RX_OVRD_OUT_ZERO_DATA_LSB)
#define RX_OVRD_OUT_ZERO_DATA_SET(x)                                           (((0 | (x)) << RX_OVRD_OUT_ZERO_DATA_LSB) & RX_OVRD_OUT_ZERO_DATA_MASK)
#define RX_OVRD_OUT_ZERO_DATA_RESET                                            0x0
#define RX_OVRD_OUT_LOS_OVRD_LSB                                               5
#define RX_OVRD_OUT_LOS_OVRD_MSB                                               5
#define RX_OVRD_OUT_LOS_OVRD_MASK                                              0x20
#define RX_OVRD_OUT_LOS_OVRD_GET(x)                                            (((x) & RX_OVRD_OUT_LOS_OVRD_MASK) >> RX_OVRD_OUT_LOS_OVRD_LSB)
#define RX_OVRD_OUT_LOS_OVRD_SET(x)                                            (((0 | (x)) << RX_OVRD_OUT_LOS_OVRD_LSB) & RX_OVRD_OUT_LOS_OVRD_MASK)
#define RX_OVRD_OUT_LOS_OVRD_RESET                                             0x0
#define RX_OVRD_OUT_LOS_LSB                                                    4
#define RX_OVRD_OUT_LOS_MSB                                                    4
#define RX_OVRD_OUT_LOS_MASK                                                   0x10
#define RX_OVRD_OUT_LOS_GET(x)                                                 (((x) & RX_OVRD_OUT_LOS_MASK) >> RX_OVRD_OUT_LOS_LSB)
#define RX_OVRD_OUT_LOS_SET(x)                                                 (((0 | (x)) << RX_OVRD_OUT_LOS_LSB) & RX_OVRD_OUT_LOS_MASK)
#define RX_OVRD_OUT_LOS_RESET                                                  0x0
#define RX_OVRD_OUT_PLL_STATE_OVRD_LSB                                         3
#define RX_OVRD_OUT_PLL_STATE_OVRD_MSB                                         3
#define RX_OVRD_OUT_PLL_STATE_OVRD_MASK                                        0x8
#define RX_OVRD_OUT_PLL_STATE_OVRD_GET(x)                                      (((x) & RX_OVRD_OUT_PLL_STATE_OVRD_MASK) >> RX_OVRD_OUT_PLL_STATE_OVRD_LSB)
#define RX_OVRD_OUT_PLL_STATE_OVRD_SET(x)                                      (((0 | (x)) << RX_OVRD_OUT_PLL_STATE_OVRD_LSB) & RX_OVRD_OUT_PLL_STATE_OVRD_MASK)
#define RX_OVRD_OUT_PLL_STATE_OVRD_RESET                                       0x0
#define RX_OVRD_OUT_PLL_STATE_LSB                                              2
#define RX_OVRD_OUT_PLL_STATE_MSB                                              2
#define RX_OVRD_OUT_PLL_STATE_MASK                                             0x4
#define RX_OVRD_OUT_PLL_STATE_GET(x)                                           (((x) & RX_OVRD_OUT_PLL_STATE_MASK) >> RX_OVRD_OUT_PLL_STATE_LSB)
#define RX_OVRD_OUT_PLL_STATE_SET(x)                                           (((0 | (x)) << RX_OVRD_OUT_PLL_STATE_LSB) & RX_OVRD_OUT_PLL_STATE_MASK)
#define RX_OVRD_OUT_PLL_STATE_RESET                                            0x0
#define RX_OVRD_OUT_VALID_OVRD_LSB                                             1
#define RX_OVRD_OUT_VALID_OVRD_MSB                                             1
#define RX_OVRD_OUT_VALID_OVRD_MASK                                            0x2
#define RX_OVRD_OUT_VALID_OVRD_GET(x)                                          (((x) & RX_OVRD_OUT_VALID_OVRD_MASK) >> RX_OVRD_OUT_VALID_OVRD_LSB)
#define RX_OVRD_OUT_VALID_OVRD_SET(x)                                          (((0 | (x)) << RX_OVRD_OUT_VALID_OVRD_LSB) & RX_OVRD_OUT_VALID_OVRD_MASK)
#define RX_OVRD_OUT_VALID_OVRD_RESET                                           0x0
#define RX_OVRD_OUT_VALID_LSB                                                  0
#define RX_OVRD_OUT_VALID_MSB                                                  0
#define RX_OVRD_OUT_VALID_MASK                                                 0x1
#define RX_OVRD_OUT_VALID_GET(x)                                               (((x) & RX_OVRD_OUT_VALID_MASK) >> RX_OVRD_OUT_VALID_LSB)
#define RX_OVRD_OUT_VALID_SET(x)                                               (((0 | (x)) << RX_OVRD_OUT_VALID_LSB) & RX_OVRD_OUT_VALID_MASK)
#define RX_OVRD_OUT_VALID_RESET                                                0x0
#define RX_OVRD_OUT_ADDRESS                                                    (0x401c + __PCIE_PHY_REG_BASE_ADDRESS)
#define RX_OVRD_OUT_RSTMASK                                                    0x7f
#define RX_OVRD_OUT_RESET                                                      0x0

// 0x4020 (TX_ASIC_IN)
#define TX_ASIC_IN_TX_VBOOST_EN_LSB                                            11
#define TX_ASIC_IN_TX_VBOOST_EN_MSB                                            11
#define TX_ASIC_IN_TX_VBOOST_EN_MASK                                           0x800
#define TX_ASIC_IN_TX_VBOOST_EN_GET(x)                                         (((x) & TX_ASIC_IN_TX_VBOOST_EN_MASK) >> TX_ASIC_IN_TX_VBOOST_EN_LSB)
#define TX_ASIC_IN_TX_VBOOST_EN_SET(x)                                         (((0 | (x)) << TX_ASIC_IN_TX_VBOOST_EN_LSB) & TX_ASIC_IN_TX_VBOOST_EN_MASK)
#define TX_ASIC_IN_TX_VBOOST_EN_RESET                                          0x0
#define TX_ASIC_IN_TX_CLK_OUT_EN_LSB                                           10
#define TX_ASIC_IN_TX_CLK_OUT_EN_MSB                                           10
#define TX_ASIC_IN_TX_CLK_OUT_EN_MASK                                          0x400
#define TX_ASIC_IN_TX_CLK_OUT_EN_GET(x)                                        (((x) & TX_ASIC_IN_TX_CLK_OUT_EN_MASK) >> TX_ASIC_IN_TX_CLK_OUT_EN_LSB)
#define TX_ASIC_IN_TX_CLK_OUT_EN_SET(x)                                        (((0 | (x)) << TX_ASIC_IN_TX_CLK_OUT_EN_LSB) & TX_ASIC_IN_TX_CLK_OUT_EN_MASK)
#define TX_ASIC_IN_TX_CLK_OUT_EN_RESET                                         0x0
#define TX_ASIC_IN_DETECT_RX_REQ_LSB                                           9
#define TX_ASIC_IN_DETECT_RX_REQ_MSB                                           9
#define TX_ASIC_IN_DETECT_RX_REQ_MASK                                          0x200
#define TX_ASIC_IN_DETECT_RX_REQ_GET(x)                                        (((x) & TX_ASIC_IN_DETECT_RX_REQ_MASK) >> TX_ASIC_IN_DETECT_RX_REQ_LSB)
#define TX_ASIC_IN_DETECT_RX_REQ_SET(x)                                        (((0 | (x)) << TX_ASIC_IN_DETECT_RX_REQ_LSB) & TX_ASIC_IN_DETECT_RX_REQ_MASK)
#define TX_ASIC_IN_DETECT_RX_REQ_RESET                                         0x0
#define TX_ASIC_IN_BEACON_EN_LSB                                               8
#define TX_ASIC_IN_BEACON_EN_MSB                                               8
#define TX_ASIC_IN_BEACON_EN_MASK                                              0x100
#define TX_ASIC_IN_BEACON_EN_GET(x)                                            (((x) & TX_ASIC_IN_BEACON_EN_MASK) >> TX_ASIC_IN_BEACON_EN_LSB)
#define TX_ASIC_IN_BEACON_EN_SET(x)                                            (((0 | (x)) << TX_ASIC_IN_BEACON_EN_LSB) & TX_ASIC_IN_BEACON_EN_MASK)
#define TX_ASIC_IN_BEACON_EN_RESET                                             0x0
#define TX_ASIC_IN_CM_EN_LSB                                                   7
#define TX_ASIC_IN_CM_EN_MSB                                                   7
#define TX_ASIC_IN_CM_EN_MASK                                                  0x80
#define TX_ASIC_IN_CM_EN_GET(x)                                                (((x) & TX_ASIC_IN_CM_EN_MASK) >> TX_ASIC_IN_CM_EN_LSB)
#define TX_ASIC_IN_CM_EN_SET(x)                                                (((0 | (x)) << TX_ASIC_IN_CM_EN_LSB) & TX_ASIC_IN_CM_EN_MASK)
#define TX_ASIC_IN_CM_EN_RESET                                                 0x0
#define TX_ASIC_IN_TX_EN_LSB                                                   6
#define TX_ASIC_IN_TX_EN_MSB                                                   6
#define TX_ASIC_IN_TX_EN_MASK                                                  0x40
#define TX_ASIC_IN_TX_EN_GET(x)                                                (((x) & TX_ASIC_IN_TX_EN_MASK) >> TX_ASIC_IN_TX_EN_LSB)
#define TX_ASIC_IN_TX_EN_SET(x)                                                (((0 | (x)) << TX_ASIC_IN_TX_EN_LSB) & TX_ASIC_IN_TX_EN_MASK)
#define TX_ASIC_IN_TX_EN_RESET                                                 0x0
#define TX_ASIC_IN_DATA_EN_LSB                                                 5
#define TX_ASIC_IN_DATA_EN_MSB                                                 5
#define TX_ASIC_IN_DATA_EN_MASK                                                0x20
#define TX_ASIC_IN_DATA_EN_GET(x)                                              (((x) & TX_ASIC_IN_DATA_EN_MASK) >> TX_ASIC_IN_DATA_EN_LSB)
#define TX_ASIC_IN_DATA_EN_SET(x)                                              (((0 | (x)) << TX_ASIC_IN_DATA_EN_LSB) & TX_ASIC_IN_DATA_EN_MASK)
#define TX_ASIC_IN_DATA_EN_RESET                                               0x0
#define TX_ASIC_IN_TX_RESET_LSB                                                4
#define TX_ASIC_IN_TX_RESET_MSB                                                4
#define TX_ASIC_IN_TX_RESET_MASK                                               0x10
#define TX_ASIC_IN_TX_RESET_GET(x)                                             (((x) & TX_ASIC_IN_TX_RESET_MASK) >> TX_ASIC_IN_TX_RESET_LSB)
#define TX_ASIC_IN_TX_RESET_SET(x)                                             (((0 | (x)) << TX_ASIC_IN_TX_RESET_LSB) & TX_ASIC_IN_TX_RESET_MASK)
#define TX_ASIC_IN_TX_RESET_RESET                                              0x0
#define TX_ASIC_IN_INVERT_LSB                                                  3
#define TX_ASIC_IN_INVERT_MSB                                                  3
#define TX_ASIC_IN_INVERT_MASK                                                 0x8
#define TX_ASIC_IN_INVERT_GET(x)                                               (((x) & TX_ASIC_IN_INVERT_MASK) >> TX_ASIC_IN_INVERT_LSB)
#define TX_ASIC_IN_INVERT_SET(x)                                               (((0 | (x)) << TX_ASIC_IN_INVERT_LSB) & TX_ASIC_IN_INVERT_MASK)
#define TX_ASIC_IN_INVERT_RESET                                                0x0
#define TX_ASIC_IN_LOOPBK_EN_LSB                                               2
#define TX_ASIC_IN_LOOPBK_EN_MSB                                               2
#define TX_ASIC_IN_LOOPBK_EN_MASK                                              0x4
#define TX_ASIC_IN_LOOPBK_EN_GET(x)                                            (((x) & TX_ASIC_IN_LOOPBK_EN_MASK) >> TX_ASIC_IN_LOOPBK_EN_LSB)
#define TX_ASIC_IN_LOOPBK_EN_SET(x)                                            (((0 | (x)) << TX_ASIC_IN_LOOPBK_EN_LSB) & TX_ASIC_IN_LOOPBK_EN_MASK)
#define TX_ASIC_IN_LOOPBK_EN_RESET                                             0x0
#define TX_ASIC_IN_TX_RATE_LSB                                                 0
#define TX_ASIC_IN_TX_RATE_MSB                                                 1
#define TX_ASIC_IN_TX_RATE_MASK                                                0x3
#define TX_ASIC_IN_TX_RATE_GET(x)                                              (((x) & TX_ASIC_IN_TX_RATE_MASK) >> TX_ASIC_IN_TX_RATE_LSB)
#define TX_ASIC_IN_TX_RATE_SET(x)                                              (((0 | (x)) << TX_ASIC_IN_TX_RATE_LSB) & TX_ASIC_IN_TX_RATE_MASK)
#define TX_ASIC_IN_TX_RATE_RESET                                               0x0
#define TX_ASIC_IN_ADDRESS                                                     (0x4020 + __PCIE_PHY_REG_BASE_ADDRESS)
#define TX_ASIC_IN_RSTMASK                                                     0xfff
#define TX_ASIC_IN_RESET                                                       0x0

// 0x4024 (TX_ASIC_DRV_LO)
#define TX_ASIC_DRV_LO_PREEMPH_LSB                                             7
#define TX_ASIC_DRV_LO_PREEMPH_MSB                                             13
#define TX_ASIC_DRV_LO_PREEMPH_MASK                                            0x3f80
#define TX_ASIC_DRV_LO_PREEMPH_GET(x)                                          (((x) & TX_ASIC_DRV_LO_PREEMPH_MASK) >> TX_ASIC_DRV_LO_PREEMPH_LSB)
#define TX_ASIC_DRV_LO_PREEMPH_SET(x)                                          (((0 | (x)) << TX_ASIC_DRV_LO_PREEMPH_LSB) & TX_ASIC_DRV_LO_PREEMPH_MASK)
#define TX_ASIC_DRV_LO_PREEMPH_RESET                                           0x0
#define TX_ASIC_DRV_LO_AMPLITUDE_LSB                                           0
#define TX_ASIC_DRV_LO_AMPLITUDE_MSB                                           6
#define TX_ASIC_DRV_LO_AMPLITUDE_MASK                                          0x7f
#define TX_ASIC_DRV_LO_AMPLITUDE_GET(x)                                        (((x) & TX_ASIC_DRV_LO_AMPLITUDE_MASK) >> TX_ASIC_DRV_LO_AMPLITUDE_LSB)
#define TX_ASIC_DRV_LO_AMPLITUDE_SET(x)                                        (((0 | (x)) << TX_ASIC_DRV_LO_AMPLITUDE_LSB) & TX_ASIC_DRV_LO_AMPLITUDE_MASK)
#define TX_ASIC_DRV_LO_AMPLITUDE_RESET                                         0x0
#define TX_ASIC_DRV_LO_ADDRESS                                                 (0x4024 + __PCIE_PHY_REG_BASE_ADDRESS)
#define TX_ASIC_DRV_LO_RSTMASK                                                 0x3fff
#define TX_ASIC_DRV_LO_RESET                                                   0x0

// 0x4028 (TX_ASIC_DRV_HI)
#define TX_ASIC_DRV_HI_TERM_OFFSET_LSB                                         0
#define TX_ASIC_DRV_HI_TERM_OFFSET_MSB                                         4
#define TX_ASIC_DRV_HI_TERM_OFFSET_MASK                                        0x1f
#define TX_ASIC_DRV_HI_TERM_OFFSET_GET(x)                                      (((x) & TX_ASIC_DRV_HI_TERM_OFFSET_MASK) >> TX_ASIC_DRV_HI_TERM_OFFSET_LSB)
#define TX_ASIC_DRV_HI_TERM_OFFSET_SET(x)                                      (((0 | (x)) << TX_ASIC_DRV_HI_TERM_OFFSET_LSB) & TX_ASIC_DRV_HI_TERM_OFFSET_MASK)
#define TX_ASIC_DRV_HI_TERM_OFFSET_RESET                                       0x0
#define TX_ASIC_DRV_HI_ADDRESS                                                 (0x4028 + __PCIE_PHY_REG_BASE_ADDRESS)
#define TX_ASIC_DRV_HI_RSTMASK                                                 0x1f
#define TX_ASIC_DRV_HI_RESET                                                   0x0

// 0x402c (TX_ASIC_OUT)
#define TX_ASIC_OUT_STATE_LSB                                                  4
#define TX_ASIC_OUT_STATE_MSB                                                  4
#define TX_ASIC_OUT_STATE_MASK                                                 0x10
#define TX_ASIC_OUT_STATE_GET(x)                                               (((x) & TX_ASIC_OUT_STATE_MASK) >> TX_ASIC_OUT_STATE_LSB)
#define TX_ASIC_OUT_STATE_SET(x)                                               (((0 | (x)) << TX_ASIC_OUT_STATE_LSB) & TX_ASIC_OUT_STATE_MASK)
#define TX_ASIC_OUT_STATE_RESET                                                0x0
#define TX_ASIC_OUT_CM_STATE_LSB                                               3
#define TX_ASIC_OUT_CM_STATE_MSB                                               3
#define TX_ASIC_OUT_CM_STATE_MASK                                              0x8
#define TX_ASIC_OUT_CM_STATE_GET(x)                                            (((x) & TX_ASIC_OUT_CM_STATE_MASK) >> TX_ASIC_OUT_CM_STATE_LSB)
#define TX_ASIC_OUT_CM_STATE_SET(x)                                            (((0 | (x)) << TX_ASIC_OUT_CM_STATE_LSB) & TX_ASIC_OUT_CM_STATE_MASK)
#define TX_ASIC_OUT_CM_STATE_RESET                                             0x0
#define TX_ASIC_OUT_DETECT_RX_ACK_LSB                                          2
#define TX_ASIC_OUT_DETECT_RX_ACK_MSB                                          2
#define TX_ASIC_OUT_DETECT_RX_ACK_MASK                                         0x4
#define TX_ASIC_OUT_DETECT_RX_ACK_GET(x)                                       (((x) & TX_ASIC_OUT_DETECT_RX_ACK_MASK) >> TX_ASIC_OUT_DETECT_RX_ACK_LSB)
#define TX_ASIC_OUT_DETECT_RX_ACK_SET(x)                                       (((0 | (x)) << TX_ASIC_OUT_DETECT_RX_ACK_LSB) & TX_ASIC_OUT_DETECT_RX_ACK_MASK)
#define TX_ASIC_OUT_DETECT_RX_ACK_RESET                                        0x0
#define TX_ASIC_OUT_RESERVED_LSB                                               1
#define TX_ASIC_OUT_RESERVED_MSB                                               1
#define TX_ASIC_OUT_RESERVED_MASK                                              0x2
#define TX_ASIC_OUT_RESERVED_GET(x)                                            (((x) & TX_ASIC_OUT_RESERVED_MASK) >> TX_ASIC_OUT_RESERVED_LSB)
#define TX_ASIC_OUT_RESERVED_SET(x)                                            (((0 | (x)) << TX_ASIC_OUT_RESERVED_LSB) & TX_ASIC_OUT_RESERVED_MASK)
#define TX_ASIC_OUT_RESERVED_RESET                                             0x0
#define TX_ASIC_OUT_DETECT_RX_RES_LSB                                          0
#define TX_ASIC_OUT_DETECT_RX_RES_MSB                                          0
#define TX_ASIC_OUT_DETECT_RX_RES_MASK                                         0x1
#define TX_ASIC_OUT_DETECT_RX_RES_GET(x)                                       (((x) & TX_ASIC_OUT_DETECT_RX_RES_MASK) >> TX_ASIC_OUT_DETECT_RX_RES_LSB)
#define TX_ASIC_OUT_DETECT_RX_RES_SET(x)                                       (((0 | (x)) << TX_ASIC_OUT_DETECT_RX_RES_LSB) & TX_ASIC_OUT_DETECT_RX_RES_MASK)
#define TX_ASIC_OUT_DETECT_RX_RES_RESET                                        0x0
#define TX_ASIC_OUT_ADDRESS                                                    (0x402c + __PCIE_PHY_REG_BASE_ADDRESS)
#define TX_ASIC_OUT_RSTMASK                                                    0x1f
#define TX_ASIC_OUT_RESET                                                      0x0

// 0x4030 (RX_ASIC_IN)
#define RX_ASIC_IN_RX_EQ_EN_LSB                                                15
#define RX_ASIC_IN_RX_EQ_EN_MSB                                                15
#define RX_ASIC_IN_RX_EQ_EN_MASK                                               0x8000
#define RX_ASIC_IN_RX_EQ_EN_GET(x)                                             (((x) & RX_ASIC_IN_RX_EQ_EN_MASK) >> RX_ASIC_IN_RX_EQ_EN_LSB)
#define RX_ASIC_IN_RX_EQ_EN_SET(x)                                             (((0 | (x)) << RX_ASIC_IN_RX_EQ_EN_LSB) & RX_ASIC_IN_RX_EQ_EN_MASK)
#define RX_ASIC_IN_RX_EQ_EN_RESET                                              0x0
#define RX_ASIC_IN_RX_EQ_LSB                                                   12
#define RX_ASIC_IN_RX_EQ_MSB                                                   14
#define RX_ASIC_IN_RX_EQ_MASK                                                  0x7000
#define RX_ASIC_IN_RX_EQ_GET(x)                                                (((x) & RX_ASIC_IN_RX_EQ_MASK) >> RX_ASIC_IN_RX_EQ_LSB)
#define RX_ASIC_IN_RX_EQ_SET(x)                                                (((0 | (x)) << RX_ASIC_IN_RX_EQ_LSB) & RX_ASIC_IN_RX_EQ_MASK)
#define RX_ASIC_IN_RX_EQ_RESET                                                 0x0
#define RX_ASIC_IN_LOS_FILTER_LSB                                              10
#define RX_ASIC_IN_LOS_FILTER_MSB                                              11
#define RX_ASIC_IN_LOS_FILTER_MASK                                             0xc00
#define RX_ASIC_IN_LOS_FILTER_GET(x)                                           (((x) & RX_ASIC_IN_LOS_FILTER_MASK) >> RX_ASIC_IN_LOS_FILTER_LSB)
#define RX_ASIC_IN_LOS_FILTER_SET(x)                                           (((0 | (x)) << RX_ASIC_IN_LOS_FILTER_LSB) & RX_ASIC_IN_LOS_FILTER_MASK)
#define RX_ASIC_IN_LOS_FILTER_RESET                                            0x0
#define RX_ASIC_IN_LOS_EN_LSB                                                  9
#define RX_ASIC_IN_LOS_EN_MSB                                                  9
#define RX_ASIC_IN_LOS_EN_MASK                                                 0x200
#define RX_ASIC_IN_LOS_EN_GET(x)                                               (((x) & RX_ASIC_IN_LOS_EN_MASK) >> RX_ASIC_IN_LOS_EN_LSB)
#define RX_ASIC_IN_LOS_EN_SET(x)                                               (((0 | (x)) << RX_ASIC_IN_LOS_EN_LSB) & RX_ASIC_IN_LOS_EN_MASK)
#define RX_ASIC_IN_LOS_EN_RESET                                                0x0
#define RX_ASIC_IN_TERM_EN_LSB                                                 8
#define RX_ASIC_IN_TERM_EN_MSB                                                 8
#define RX_ASIC_IN_TERM_EN_MASK                                                0x100
#define RX_ASIC_IN_TERM_EN_GET(x)                                              (((x) & RX_ASIC_IN_TERM_EN_MASK) >> RX_ASIC_IN_TERM_EN_LSB)
#define RX_ASIC_IN_TERM_EN_SET(x)                                              (((0 | (x)) << RX_ASIC_IN_TERM_EN_LSB) & RX_ASIC_IN_TERM_EN_MASK)
#define RX_ASIC_IN_TERM_EN_RESET                                               0x0
#define RX_ASIC_IN_CLK_SHIFT_LSB                                               7
#define RX_ASIC_IN_CLK_SHIFT_MSB                                               7
#define RX_ASIC_IN_CLK_SHIFT_MASK                                              0x80
#define RX_ASIC_IN_CLK_SHIFT_GET(x)                                            (((x) & RX_ASIC_IN_CLK_SHIFT_MASK) >> RX_ASIC_IN_CLK_SHIFT_LSB)
#define RX_ASIC_IN_CLK_SHIFT_SET(x)                                            (((0 | (x)) << RX_ASIC_IN_CLK_SHIFT_LSB) & RX_ASIC_IN_CLK_SHIFT_MASK)
#define RX_ASIC_IN_CLK_SHIFT_RESET                                             0x0
#define RX_ASIC_IN_ALIGN_EN_LSB                                                6
#define RX_ASIC_IN_ALIGN_EN_MSB                                                6
#define RX_ASIC_IN_ALIGN_EN_MASK                                               0x40
#define RX_ASIC_IN_ALIGN_EN_GET(x)                                             (((x) & RX_ASIC_IN_ALIGN_EN_MASK) >> RX_ASIC_IN_ALIGN_EN_LSB)
#define RX_ASIC_IN_ALIGN_EN_SET(x)                                             (((0 | (x)) << RX_ASIC_IN_ALIGN_EN_LSB) & RX_ASIC_IN_ALIGN_EN_MASK)
#define RX_ASIC_IN_ALIGN_EN_RESET                                              0x0
#define RX_ASIC_IN_DATA_EN_LSB                                                 5
#define RX_ASIC_IN_DATA_EN_MSB                                                 5
#define RX_ASIC_IN_DATA_EN_MASK                                                0x20
#define RX_ASIC_IN_DATA_EN_GET(x)                                              (((x) & RX_ASIC_IN_DATA_EN_MASK) >> RX_ASIC_IN_DATA_EN_LSB)
#define RX_ASIC_IN_DATA_EN_SET(x)                                              (((0 | (x)) << RX_ASIC_IN_DATA_EN_LSB) & RX_ASIC_IN_DATA_EN_MASK)
#define RX_ASIC_IN_DATA_EN_RESET                                               0x0
#define RX_ASIC_IN_PLL_EN_LSB                                                  4
#define RX_ASIC_IN_PLL_EN_MSB                                                  4
#define RX_ASIC_IN_PLL_EN_MASK                                                 0x10
#define RX_ASIC_IN_PLL_EN_GET(x)                                               (((x) & RX_ASIC_IN_PLL_EN_MASK) >> RX_ASIC_IN_PLL_EN_LSB)
#define RX_ASIC_IN_PLL_EN_SET(x)                                               (((0 | (x)) << RX_ASIC_IN_PLL_EN_LSB) & RX_ASIC_IN_PLL_EN_MASK)
#define RX_ASIC_IN_PLL_EN_RESET                                                0x0
#define RX_ASIC_IN_RX_RESET_LSB                                                3
#define RX_ASIC_IN_RX_RESET_MSB                                                3
#define RX_ASIC_IN_RX_RESET_MASK                                               0x8
#define RX_ASIC_IN_RX_RESET_GET(x)                                             (((x) & RX_ASIC_IN_RX_RESET_MASK) >> RX_ASIC_IN_RX_RESET_LSB)
#define RX_ASIC_IN_RX_RESET_SET(x)                                             (((0 | (x)) << RX_ASIC_IN_RX_RESET_LSB) & RX_ASIC_IN_RX_RESET_MASK)
#define RX_ASIC_IN_RX_RESET_RESET                                              0x0
#define RX_ASIC_IN_INVERT_LSB                                                  2
#define RX_ASIC_IN_INVERT_MSB                                                  2
#define RX_ASIC_IN_INVERT_MASK                                                 0x4
#define RX_ASIC_IN_INVERT_GET(x)                                               (((x) & RX_ASIC_IN_INVERT_MASK) >> RX_ASIC_IN_INVERT_LSB)
#define RX_ASIC_IN_INVERT_SET(x)                                               (((0 | (x)) << RX_ASIC_IN_INVERT_LSB) & RX_ASIC_IN_INVERT_MASK)
#define RX_ASIC_IN_INVERT_RESET                                                0x0
#define RX_ASIC_IN_RX_RATE_LSB                                                 0
#define RX_ASIC_IN_RX_RATE_MSB                                                 1
#define RX_ASIC_IN_RX_RATE_MASK                                                0x3
#define RX_ASIC_IN_RX_RATE_GET(x)                                              (((x) & RX_ASIC_IN_RX_RATE_MASK) >> RX_ASIC_IN_RX_RATE_LSB)
#define RX_ASIC_IN_RX_RATE_SET(x)                                              (((0 | (x)) << RX_ASIC_IN_RX_RATE_LSB) & RX_ASIC_IN_RX_RATE_MASK)
#define RX_ASIC_IN_RX_RATE_RESET                                               0x0
#define RX_ASIC_IN_ADDRESS                                                     (0x4030 + __PCIE_PHY_REG_BASE_ADDRESS)
#define RX_ASIC_IN_RSTMASK                                                     0xffff
#define RX_ASIC_IN_RESET                                                       0x0

// 0x4034 (RX_ASIC_OUT)
#define RX_ASIC_OUT_LOS_LSB                                                    2
#define RX_ASIC_OUT_LOS_MSB                                                    2
#define RX_ASIC_OUT_LOS_MASK                                                   0x4
#define RX_ASIC_OUT_LOS_GET(x)                                                 (((x) & RX_ASIC_OUT_LOS_MASK) >> RX_ASIC_OUT_LOS_LSB)
#define RX_ASIC_OUT_LOS_SET(x)                                                 (((0 | (x)) << RX_ASIC_OUT_LOS_LSB) & RX_ASIC_OUT_LOS_MASK)
#define RX_ASIC_OUT_LOS_RESET                                                  0x0
#define RX_ASIC_OUT_PLL_STATE_LSB                                              1
#define RX_ASIC_OUT_PLL_STATE_MSB                                              1
#define RX_ASIC_OUT_PLL_STATE_MASK                                             0x2
#define RX_ASIC_OUT_PLL_STATE_GET(x)                                           (((x) & RX_ASIC_OUT_PLL_STATE_MASK) >> RX_ASIC_OUT_PLL_STATE_LSB)
#define RX_ASIC_OUT_PLL_STATE_SET(x)                                           (((0 | (x)) << RX_ASIC_OUT_PLL_STATE_LSB) & RX_ASIC_OUT_PLL_STATE_MASK)
#define RX_ASIC_OUT_PLL_STATE_RESET                                            0x0
#define RX_ASIC_OUT_VALID_LSB                                                  0
#define RX_ASIC_OUT_VALID_MSB                                                  0
#define RX_ASIC_OUT_VALID_MASK                                                 0x1
#define RX_ASIC_OUT_VALID_GET(x)                                               (((x) & RX_ASIC_OUT_VALID_MASK) >> RX_ASIC_OUT_VALID_LSB)
#define RX_ASIC_OUT_VALID_SET(x)                                               (((0 | (x)) << RX_ASIC_OUT_VALID_LSB) & RX_ASIC_OUT_VALID_MASK)
#define RX_ASIC_OUT_VALID_RESET                                                0x0
#define RX_ASIC_OUT_ADDRESS                                                    (0x4034 + __PCIE_PHY_REG_BASE_ADDRESS)
#define RX_ASIC_OUT_RSTMASK                                                    0x7
#define RX_ASIC_OUT_RESET                                                      0x0

// 0x4040 (TX_DEBUG)
#define TX_DEBUG_RXDET_MEAS_TIME_LSB                                           4
#define TX_DEBUG_RXDET_MEAS_TIME_MSB                                           11
#define TX_DEBUG_RXDET_MEAS_TIME_MASK                                          0xff0
#define TX_DEBUG_RXDET_MEAS_TIME_GET(x)                                        (((x) & TX_DEBUG_RXDET_MEAS_TIME_MASK) >> TX_DEBUG_RXDET_MEAS_TIME_LSB)
#define TX_DEBUG_RXDET_MEAS_TIME_SET(x)                                        (((0 | (x)) << TX_DEBUG_RXDET_MEAS_TIME_LSB) & TX_DEBUG_RXDET_MEAS_TIME_MASK)
#define TX_DEBUG_RXDET_MEAS_TIME_RESET                                         0x10
#define TX_DEBUG_DETECT_RX_ALWAYS_LSB                                          3
#define TX_DEBUG_DETECT_RX_ALWAYS_MSB                                          3
#define TX_DEBUG_DETECT_RX_ALWAYS_MASK                                         0x8
#define TX_DEBUG_DETECT_RX_ALWAYS_GET(x)                                       (((x) & TX_DEBUG_DETECT_RX_ALWAYS_MASK) >> TX_DEBUG_DETECT_RX_ALWAYS_LSB)
#define TX_DEBUG_DETECT_RX_ALWAYS_SET(x)                                       (((0 | (x)) << TX_DEBUG_DETECT_RX_ALWAYS_LSB) & TX_DEBUG_DETECT_RX_ALWAYS_MASK)
#define TX_DEBUG_DETECT_RX_ALWAYS_RESET                                        0x0
#define TX_DEBUG_DTB_SEL_LSB                                                   0
#define TX_DEBUG_DTB_SEL_MSB                                                   2
#define TX_DEBUG_DTB_SEL_MASK                                                  0x7
#define TX_DEBUG_DTB_SEL_GET(x)                                                (((x) & TX_DEBUG_DTB_SEL_MASK) >> TX_DEBUG_DTB_SEL_LSB)
#define TX_DEBUG_DTB_SEL_SET(x)                                                (((0 | (x)) << TX_DEBUG_DTB_SEL_LSB) & TX_DEBUG_DTB_SEL_MASK)
#define TX_DEBUG_DTB_SEL_RESET                                                 0x0
#define TX_DEBUG_ADDRESS                                                       (0x4040 + __PCIE_PHY_REG_BASE_ADDRESS)
#define TX_DEBUG_RSTMASK                                                       0xfff
#define TX_DEBUG_RESET                                                         0x100

// 0x4044 (TX_CM_WAIT_TIME_OVRD)
#define TX_CM_WAIT_TIME_OVRD_CM_TIME_OVRD_EN_LSB                               10
#define TX_CM_WAIT_TIME_OVRD_CM_TIME_OVRD_EN_MSB                               10
#define TX_CM_WAIT_TIME_OVRD_CM_TIME_OVRD_EN_MASK                              0x400
#define TX_CM_WAIT_TIME_OVRD_CM_TIME_OVRD_EN_GET(x)                            (((x) & TX_CM_WAIT_TIME_OVRD_CM_TIME_OVRD_EN_MASK) >> TX_CM_WAIT_TIME_OVRD_CM_TIME_OVRD_EN_LSB)
#define TX_CM_WAIT_TIME_OVRD_CM_TIME_OVRD_EN_SET(x)                            (((0 | (x)) << TX_CM_WAIT_TIME_OVRD_CM_TIME_OVRD_EN_LSB) & TX_CM_WAIT_TIME_OVRD_CM_TIME_OVRD_EN_MASK)
#define TX_CM_WAIT_TIME_OVRD_CM_TIME_OVRD_EN_RESET                             0x0
#define TX_CM_WAIT_TIME_OVRD_CM_TIME_OVRD_LSB                                  0
#define TX_CM_WAIT_TIME_OVRD_CM_TIME_OVRD_MSB                                  9
#define TX_CM_WAIT_TIME_OVRD_CM_TIME_OVRD_MASK                                 0x3ff
#define TX_CM_WAIT_TIME_OVRD_CM_TIME_OVRD_GET(x)                               (((x) & TX_CM_WAIT_TIME_OVRD_CM_TIME_OVRD_MASK) >> TX_CM_WAIT_TIME_OVRD_CM_TIME_OVRD_LSB)
#define TX_CM_WAIT_TIME_OVRD_CM_TIME_OVRD_SET(x)                               (((0 | (x)) << TX_CM_WAIT_TIME_OVRD_CM_TIME_OVRD_LSB) & TX_CM_WAIT_TIME_OVRD_CM_TIME_OVRD_MASK)
#define TX_CM_WAIT_TIME_OVRD_CM_TIME_OVRD_RESET                                0x9f
#define TX_CM_WAIT_TIME_OVRD_ADDRESS                                           (0x4044 + __PCIE_PHY_REG_BASE_ADDRESS)
#define TX_CM_WAIT_TIME_OVRD_RSTMASK                                           0x7ff
#define TX_CM_WAIT_TIME_OVRD_RESET                                             0x9f

// 0x4048 (TX_VMD_FSM_TX_VCM_0)
#define TX_VMD_FSM_TX_VCM_0_SHIFT_OUT_LSB                                      15
#define TX_VMD_FSM_TX_VCM_0_SHIFT_OUT_MSB                                      15
#define TX_VMD_FSM_TX_VCM_0_SHIFT_OUT_MASK                                     0x8000
#define TX_VMD_FSM_TX_VCM_0_SHIFT_OUT_GET(x)                                   (((x) & TX_VMD_FSM_TX_VCM_0_SHIFT_OUT_MASK) >> TX_VMD_FSM_TX_VCM_0_SHIFT_OUT_LSB)
#define TX_VMD_FSM_TX_VCM_0_SHIFT_OUT_SET(x)                                   (((0 | (x)) << TX_VMD_FSM_TX_VCM_0_SHIFT_OUT_LSB) & TX_VMD_FSM_TX_VCM_0_SHIFT_OUT_MASK)
#define TX_VMD_FSM_TX_VCM_0_SHIFT_OUT_RESET                                    0x0
#define TX_VMD_FSM_TX_VCM_0_DONE_LSB                                           14
#define TX_VMD_FSM_TX_VCM_0_DONE_MSB                                           14
#define TX_VMD_FSM_TX_VCM_0_DONE_MASK                                          0x4000
#define TX_VMD_FSM_TX_VCM_0_DONE_GET(x)                                        (((x) & TX_VMD_FSM_TX_VCM_0_DONE_MASK) >> TX_VMD_FSM_TX_VCM_0_DONE_LSB)
#define TX_VMD_FSM_TX_VCM_0_DONE_SET(x)                                        (((0 | (x)) << TX_VMD_FSM_TX_VCM_0_DONE_LSB) & TX_VMD_FSM_TX_VCM_0_DONE_MASK)
#define TX_VMD_FSM_TX_VCM_0_DONE_RESET                                         0x0
#define TX_VMD_FSM_TX_VCM_0_N_USE_LSB                                          7
#define TX_VMD_FSM_TX_VCM_0_N_USE_MSB                                          13
#define TX_VMD_FSM_TX_VCM_0_N_USE_MASK                                         0x3f80
#define TX_VMD_FSM_TX_VCM_0_N_USE_GET(x)                                       (((x) & TX_VMD_FSM_TX_VCM_0_N_USE_MASK) >> TX_VMD_FSM_TX_VCM_0_N_USE_LSB)
#define TX_VMD_FSM_TX_VCM_0_N_USE_SET(x)                                       (((0 | (x)) << TX_VMD_FSM_TX_VCM_0_N_USE_LSB) & TX_VMD_FSM_TX_VCM_0_N_USE_MASK)
#define TX_VMD_FSM_TX_VCM_0_N_USE_RESET                                        0x0
#define TX_VMD_FSM_TX_VCM_0_N_TRISTATE_LSB                                     0
#define TX_VMD_FSM_TX_VCM_0_N_TRISTATE_MSB                                     6
#define TX_VMD_FSM_TX_VCM_0_N_TRISTATE_MASK                                    0x7f
#define TX_VMD_FSM_TX_VCM_0_N_TRISTATE_GET(x)                                  (((x) & TX_VMD_FSM_TX_VCM_0_N_TRISTATE_MASK) >> TX_VMD_FSM_TX_VCM_0_N_TRISTATE_LSB)
#define TX_VMD_FSM_TX_VCM_0_N_TRISTATE_SET(x)                                  (((0 | (x)) << TX_VMD_FSM_TX_VCM_0_N_TRISTATE_LSB) & TX_VMD_FSM_TX_VCM_0_N_TRISTATE_MASK)
#define TX_VMD_FSM_TX_VCM_0_N_TRISTATE_RESET                                   0x0
#define TX_VMD_FSM_TX_VCM_0_ADDRESS                                            (0x4048 + __PCIE_PHY_REG_BASE_ADDRESS)
#define TX_VMD_FSM_TX_VCM_0_RSTMASK                                            0xffff
#define TX_VMD_FSM_TX_VCM_0_RESET                                              0x0

// 0x404c (TX_VMD_FSM_TX_VCM_1)
#define TX_VMD_FSM_TX_VCM_1_FIXED_DONE_LSB                                     15
#define TX_VMD_FSM_TX_VCM_1_FIXED_DONE_MSB                                     15
#define TX_VMD_FSM_TX_VCM_1_FIXED_DONE_MASK                                    0x8000
#define TX_VMD_FSM_TX_VCM_1_FIXED_DONE_GET(x)                                  (((x) & TX_VMD_FSM_TX_VCM_1_FIXED_DONE_MASK) >> TX_VMD_FSM_TX_VCM_1_FIXED_DONE_LSB)
#define TX_VMD_FSM_TX_VCM_1_FIXED_DONE_SET(x)                                  (((0 | (x)) << TX_VMD_FSM_TX_VCM_1_FIXED_DONE_LSB) & TX_VMD_FSM_TX_VCM_1_FIXED_DONE_MASK)
#define TX_VMD_FSM_TX_VCM_1_FIXED_DONE_RESET                                   0x0
#define TX_VMD_FSM_TX_VCM_1_TRA_DONE_LSB                                       14
#define TX_VMD_FSM_TX_VCM_1_TRA_DONE_MSB                                       14
#define TX_VMD_FSM_TX_VCM_1_TRA_DONE_MASK                                      0x4000
#define TX_VMD_FSM_TX_VCM_1_TRA_DONE_GET(x)                                    (((x) & TX_VMD_FSM_TX_VCM_1_TRA_DONE_MASK) >> TX_VMD_FSM_TX_VCM_1_TRA_DONE_LSB)
#define TX_VMD_FSM_TX_VCM_1_TRA_DONE_SET(x)                                    (((0 | (x)) << TX_VMD_FSM_TX_VCM_1_TRA_DONE_LSB) & TX_VMD_FSM_TX_VCM_1_TRA_DONE_MASK)
#define TX_VMD_FSM_TX_VCM_1_TRA_DONE_RESET                                     0x0
#define TX_VMD_FSM_TX_VCM_1_N_FIXED_LSB                                        7
#define TX_VMD_FSM_TX_VCM_1_N_FIXED_MSB                                        13
#define TX_VMD_FSM_TX_VCM_1_N_FIXED_MASK                                       0x3f80
#define TX_VMD_FSM_TX_VCM_1_N_FIXED_GET(x)                                     (((x) & TX_VMD_FSM_TX_VCM_1_N_FIXED_MASK) >> TX_VMD_FSM_TX_VCM_1_N_FIXED_LSB)
#define TX_VMD_FSM_TX_VCM_1_N_FIXED_SET(x)                                     (((0 | (x)) << TX_VMD_FSM_TX_VCM_1_N_FIXED_LSB) & TX_VMD_FSM_TX_VCM_1_N_FIXED_MASK)
#define TX_VMD_FSM_TX_VCM_1_N_FIXED_RESET                                      0x0
#define TX_VMD_FSM_TX_VCM_1_N_TRAILER_LSB                                      0
#define TX_VMD_FSM_TX_VCM_1_N_TRAILER_MSB                                      6
#define TX_VMD_FSM_TX_VCM_1_N_TRAILER_MASK                                     0x7f
#define TX_VMD_FSM_TX_VCM_1_N_TRAILER_GET(x)                                   (((x) & TX_VMD_FSM_TX_VCM_1_N_TRAILER_MASK) >> TX_VMD_FSM_TX_VCM_1_N_TRAILER_LSB)
#define TX_VMD_FSM_TX_VCM_1_N_TRAILER_SET(x)                                   (((0 | (x)) << TX_VMD_FSM_TX_VCM_1_N_TRAILER_LSB) & TX_VMD_FSM_TX_VCM_1_N_TRAILER_MASK)
#define TX_VMD_FSM_TX_VCM_1_N_TRAILER_RESET                                    0x0
#define TX_VMD_FSM_TX_VCM_1_ADDRESS                                            (0x404c + __PCIE_PHY_REG_BASE_ADDRESS)
#define TX_VMD_FSM_TX_VCM_1_RSTMASK                                            0xffff
#define TX_VMD_FSM_TX_VCM_1_RESET                                              0x0

// 0x4050 (TX_VMD_FSM_TX_VCM_DEBUG_IN)
#define TX_VMD_FSM_TX_VCM_DEBUG_IN_CONFIG_OVRD_LSB                             3
#define TX_VMD_FSM_TX_VCM_DEBUG_IN_CONFIG_OVRD_MSB                             3
#define TX_VMD_FSM_TX_VCM_DEBUG_IN_CONFIG_OVRD_MASK                            0x8
#define TX_VMD_FSM_TX_VCM_DEBUG_IN_CONFIG_OVRD_GET(x)                          (((x) & TX_VMD_FSM_TX_VCM_DEBUG_IN_CONFIG_OVRD_MASK) >> TX_VMD_FSM_TX_VCM_DEBUG_IN_CONFIG_OVRD_LSB)
#define TX_VMD_FSM_TX_VCM_DEBUG_IN_CONFIG_OVRD_SET(x)                          (((0 | (x)) << TX_VMD_FSM_TX_VCM_DEBUG_IN_CONFIG_OVRD_LSB) & TX_VMD_FSM_TX_VCM_DEBUG_IN_CONFIG_OVRD_MASK)
#define TX_VMD_FSM_TX_VCM_DEBUG_IN_CONFIG_OVRD_RESET                           0x0
#define TX_VMD_FSM_TX_VCM_DEBUG_IN_CONFIG_LOAD_LSB                             2
#define TX_VMD_FSM_TX_VCM_DEBUG_IN_CONFIG_LOAD_MSB                             2
#define TX_VMD_FSM_TX_VCM_DEBUG_IN_CONFIG_LOAD_MASK                            0x4
#define TX_VMD_FSM_TX_VCM_DEBUG_IN_CONFIG_LOAD_GET(x)                          (((x) & TX_VMD_FSM_TX_VCM_DEBUG_IN_CONFIG_LOAD_MASK) >> TX_VMD_FSM_TX_VCM_DEBUG_IN_CONFIG_LOAD_LSB)
#define TX_VMD_FSM_TX_VCM_DEBUG_IN_CONFIG_LOAD_SET(x)                          (((0 | (x)) << TX_VMD_FSM_TX_VCM_DEBUG_IN_CONFIG_LOAD_LSB) & TX_VMD_FSM_TX_VCM_DEBUG_IN_CONFIG_LOAD_MASK)
#define TX_VMD_FSM_TX_VCM_DEBUG_IN_CONFIG_LOAD_RESET                           0x0
#define TX_VMD_FSM_TX_VCM_DEBUG_IN_CONFIG_CLK_LSB                              1
#define TX_VMD_FSM_TX_VCM_DEBUG_IN_CONFIG_CLK_MSB                              1
#define TX_VMD_FSM_TX_VCM_DEBUG_IN_CONFIG_CLK_MASK                             0x2
#define TX_VMD_FSM_TX_VCM_DEBUG_IN_CONFIG_CLK_GET(x)                           (((x) & TX_VMD_FSM_TX_VCM_DEBUG_IN_CONFIG_CLK_MASK) >> TX_VMD_FSM_TX_VCM_DEBUG_IN_CONFIG_CLK_LSB)
#define TX_VMD_FSM_TX_VCM_DEBUG_IN_CONFIG_CLK_SET(x)                           (((0 | (x)) << TX_VMD_FSM_TX_VCM_DEBUG_IN_CONFIG_CLK_LSB) & TX_VMD_FSM_TX_VCM_DEBUG_IN_CONFIG_CLK_MASK)
#define TX_VMD_FSM_TX_VCM_DEBUG_IN_CONFIG_CLK_RESET                            0x0
#define TX_VMD_FSM_TX_VCM_DEBUG_IN_CONFIG_DATA_LSB                             0
#define TX_VMD_FSM_TX_VCM_DEBUG_IN_CONFIG_DATA_MSB                             0
#define TX_VMD_FSM_TX_VCM_DEBUG_IN_CONFIG_DATA_MASK                            0x1
#define TX_VMD_FSM_TX_VCM_DEBUG_IN_CONFIG_DATA_GET(x)                          (((x) & TX_VMD_FSM_TX_VCM_DEBUG_IN_CONFIG_DATA_MASK) >> TX_VMD_FSM_TX_VCM_DEBUG_IN_CONFIG_DATA_LSB)
#define TX_VMD_FSM_TX_VCM_DEBUG_IN_CONFIG_DATA_SET(x)                          (((0 | (x)) << TX_VMD_FSM_TX_VCM_DEBUG_IN_CONFIG_DATA_LSB) & TX_VMD_FSM_TX_VCM_DEBUG_IN_CONFIG_DATA_MASK)
#define TX_VMD_FSM_TX_VCM_DEBUG_IN_CONFIG_DATA_RESET                           0x0
#define TX_VMD_FSM_TX_VCM_DEBUG_IN_ADDRESS                                     (0x4050 + __PCIE_PHY_REG_BASE_ADDRESS)
#define TX_VMD_FSM_TX_VCM_DEBUG_IN_RSTMASK                                     0xf
#define TX_VMD_FSM_TX_VCM_DEBUG_IN_RESET                                       0x0

// 0x4054 (TX_LBERT_CTL)
#define TX_LBERT_CTL_PAT0_LSB                                                  5
#define TX_LBERT_CTL_PAT0_MSB                                                  14
#define TX_LBERT_CTL_PAT0_MASK                                                 0x7fe0
#define TX_LBERT_CTL_PAT0_GET(x)                                               (((x) & TX_LBERT_CTL_PAT0_MASK) >> TX_LBERT_CTL_PAT0_LSB)
#define TX_LBERT_CTL_PAT0_SET(x)                                               (((0 | (x)) << TX_LBERT_CTL_PAT0_LSB) & TX_LBERT_CTL_PAT0_MASK)
#define TX_LBERT_CTL_PAT0_RESET                                                0x0
#define TX_LBERT_CTL_TRIGGER_ERR_LSB                                           4
#define TX_LBERT_CTL_TRIGGER_ERR_MSB                                           4
#define TX_LBERT_CTL_TRIGGER_ERR_MASK                                          0x10
#define TX_LBERT_CTL_TRIGGER_ERR_GET(x)                                        (((x) & TX_LBERT_CTL_TRIGGER_ERR_MASK) >> TX_LBERT_CTL_TRIGGER_ERR_LSB)
#define TX_LBERT_CTL_TRIGGER_ERR_SET(x)                                        (((0 | (x)) << TX_LBERT_CTL_TRIGGER_ERR_LSB) & TX_LBERT_CTL_TRIGGER_ERR_MASK)
#define TX_LBERT_CTL_TRIGGER_ERR_RESET                                         0x0
#define TX_LBERT_CTL_MODE_LSB                                                  0
#define TX_LBERT_CTL_MODE_MSB                                                  3
#define TX_LBERT_CTL_MODE_MASK                                                 0xf
#define TX_LBERT_CTL_MODE_GET(x)                                               (((x) & TX_LBERT_CTL_MODE_MASK) >> TX_LBERT_CTL_MODE_LSB)
#define TX_LBERT_CTL_MODE_SET(x)                                               (((0 | (x)) << TX_LBERT_CTL_MODE_LSB) & TX_LBERT_CTL_MODE_MASK)
#define TX_LBERT_CTL_MODE_RESET                                                0x0
#define TX_LBERT_CTL_ADDRESS                                                   (0x4054 + __PCIE_PHY_REG_BASE_ADDRESS)
#define TX_LBERT_CTL_RSTMASK                                                   0x7fff
#define TX_LBERT_CTL_RESET                                                     0x0

// 0x4058 (RX_LBERT_CTL)
#define RX_LBERT_CTL_SYNC_LSB                                                  3
#define RX_LBERT_CTL_SYNC_MSB                                                  3
#define RX_LBERT_CTL_SYNC_MASK                                                 0x8
#define RX_LBERT_CTL_SYNC_GET(x)                                               (((x) & RX_LBERT_CTL_SYNC_MASK) >> RX_LBERT_CTL_SYNC_LSB)
#define RX_LBERT_CTL_SYNC_SET(x)                                               (((0 | (x)) << RX_LBERT_CTL_SYNC_LSB) & RX_LBERT_CTL_SYNC_MASK)
#define RX_LBERT_CTL_SYNC_RESET                                                0x0
#define RX_LBERT_CTL_MODE_LSB                                                  0
#define RX_LBERT_CTL_MODE_MSB                                                  2
#define RX_LBERT_CTL_MODE_MASK                                                 0x7
#define RX_LBERT_CTL_MODE_GET(x)                                               (((x) & RX_LBERT_CTL_MODE_MASK) >> RX_LBERT_CTL_MODE_LSB)
#define RX_LBERT_CTL_MODE_SET(x)                                               (((0 | (x)) << RX_LBERT_CTL_MODE_LSB) & RX_LBERT_CTL_MODE_MASK)
#define RX_LBERT_CTL_MODE_RESET                                                0x0
#define RX_LBERT_CTL_ADDRESS                                                   (0x4058 + __PCIE_PHY_REG_BASE_ADDRESS)
#define RX_LBERT_CTL_RSTMASK                                                   0xf
#define RX_LBERT_CTL_RESET                                                     0x0

// 0x405c (RX_LBERT_ERR)
#define RX_LBERT_ERR_OV14_LSB                                                  15
#define RX_LBERT_ERR_OV14_MSB                                                  15
#define RX_LBERT_ERR_OV14_MASK                                                 0x8000
#define RX_LBERT_ERR_OV14_GET(x)                                               (((x) & RX_LBERT_ERR_OV14_MASK) >> RX_LBERT_ERR_OV14_LSB)
#define RX_LBERT_ERR_OV14_SET(x)                                               (((0 | (x)) << RX_LBERT_ERR_OV14_LSB) & RX_LBERT_ERR_OV14_MASK)
#define RX_LBERT_ERR_OV14_RESET                                                0x0
#define RX_LBERT_ERR_COUNT_LSB                                                 0
#define RX_LBERT_ERR_COUNT_MSB                                                 14
#define RX_LBERT_ERR_COUNT_MASK                                                0x7fff
#define RX_LBERT_ERR_COUNT_GET(x)                                              (((x) & RX_LBERT_ERR_COUNT_MASK) >> RX_LBERT_ERR_COUNT_LSB)
#define RX_LBERT_ERR_COUNT_SET(x)                                              (((0 | (x)) << RX_LBERT_ERR_COUNT_LSB) & RX_LBERT_ERR_COUNT_MASK)
#define RX_LBERT_ERR_COUNT_RESET                                               0x0
#define RX_LBERT_ERR_ADDRESS                                                   (0x405c + __PCIE_PHY_REG_BASE_ADDRESS)
#define RX_LBERT_ERR_RSTMASK                                                   0xffff
#define RX_LBERT_ERR_RESET                                                     0x0

// 0x4060 (RX_SCOPE_CTL)
#define RX_SCOPE_CTL_RX_VALID_CTL_LSB                                          12
#define RX_SCOPE_CTL_RX_VALID_CTL_MSB                                          13
#define RX_SCOPE_CTL_RX_VALID_CTL_MASK                                         0x3000
#define RX_SCOPE_CTL_RX_VALID_CTL_GET(x)                                       (((x) & RX_SCOPE_CTL_RX_VALID_CTL_MASK) >> RX_SCOPE_CTL_RX_VALID_CTL_LSB)
#define RX_SCOPE_CTL_RX_VALID_CTL_SET(x)                                       (((0 | (x)) << RX_SCOPE_CTL_RX_VALID_CTL_LSB) & RX_SCOPE_CTL_RX_VALID_CTL_MASK)
#define RX_SCOPE_CTL_RX_VALID_CTL_RESET                                        0x0
#define RX_SCOPE_CTL_DELAY_LSB                                                 3
#define RX_SCOPE_CTL_DELAY_MSB                                                 11
#define RX_SCOPE_CTL_DELAY_MASK                                                0xff8
#define RX_SCOPE_CTL_DELAY_GET(x)                                              (((x) & RX_SCOPE_CTL_DELAY_MASK) >> RX_SCOPE_CTL_DELAY_LSB)
#define RX_SCOPE_CTL_DELAY_SET(x)                                              (((0 | (x)) << RX_SCOPE_CTL_DELAY_LSB) & RX_SCOPE_CTL_DELAY_MASK)
#define RX_SCOPE_CTL_DELAY_RESET                                               0x0
#define RX_SCOPE_CTL_MODE_LSB                                                  0
#define RX_SCOPE_CTL_MODE_MSB                                                  2
#define RX_SCOPE_CTL_MODE_MASK                                                 0x7
#define RX_SCOPE_CTL_MODE_GET(x)                                               (((x) & RX_SCOPE_CTL_MODE_MASK) >> RX_SCOPE_CTL_MODE_LSB)
#define RX_SCOPE_CTL_MODE_SET(x)                                               (((0 | (x)) << RX_SCOPE_CTL_MODE_LSB) & RX_SCOPE_CTL_MODE_MASK)
#define RX_SCOPE_CTL_MODE_RESET                                                0x0
#define RX_SCOPE_CTL_ADDRESS                                                   (0x4060 + __PCIE_PHY_REG_BASE_ADDRESS)
#define RX_SCOPE_CTL_RSTMASK                                                   0x3fff
#define RX_SCOPE_CTL_RESET                                                     0x0

// 0x4064 (RX_SCOPE_PHASE)
#define RX_SCOPE_PHASE_BASE_LSB                                                10
#define RX_SCOPE_PHASE_BASE_MSB                                                14
#define RX_SCOPE_PHASE_BASE_MASK                                               0x7c00
#define RX_SCOPE_PHASE_BASE_GET(x)                                             (((x) & RX_SCOPE_PHASE_BASE_MASK) >> RX_SCOPE_PHASE_BASE_LSB)
#define RX_SCOPE_PHASE_BASE_SET(x)                                             (((0 | (x)) << RX_SCOPE_PHASE_BASE_LSB) & RX_SCOPE_PHASE_BASE_MASK)
#define RX_SCOPE_PHASE_BASE_RESET                                              0x0
#define RX_SCOPE_PHASE_SCOPE_DELAY_LSB                                         8
#define RX_SCOPE_PHASE_SCOPE_DELAY_MSB                                         9
#define RX_SCOPE_PHASE_SCOPE_DELAY_MASK                                        0x300
#define RX_SCOPE_PHASE_SCOPE_DELAY_GET(x)                                      (((x) & RX_SCOPE_PHASE_SCOPE_DELAY_MASK) >> RX_SCOPE_PHASE_SCOPE_DELAY_LSB)
#define RX_SCOPE_PHASE_SCOPE_DELAY_SET(x)                                      (((0 | (x)) << RX_SCOPE_PHASE_SCOPE_DELAY_LSB) & RX_SCOPE_PHASE_SCOPE_DELAY_MASK)
#define RX_SCOPE_PHASE_SCOPE_DELAY_RESET                                       0x0
#define RX_SCOPE_PHASE_SCOPE_SEL_LSB                                           7
#define RX_SCOPE_PHASE_SCOPE_SEL_MSB                                           7
#define RX_SCOPE_PHASE_SCOPE_SEL_MASK                                          0x80
#define RX_SCOPE_PHASE_SCOPE_SEL_GET(x)                                        (((x) & RX_SCOPE_PHASE_SCOPE_SEL_MASK) >> RX_SCOPE_PHASE_SCOPE_SEL_LSB)
#define RX_SCOPE_PHASE_SCOPE_SEL_SET(x)                                        (((0 | (x)) << RX_SCOPE_PHASE_SCOPE_SEL_LSB) & RX_SCOPE_PHASE_SCOPE_SEL_MASK)
#define RX_SCOPE_PHASE_SCOPE_SEL_RESET                                         0x0
#define RX_SCOPE_PHASE_UPDATE_LSB                                              6
#define RX_SCOPE_PHASE_UPDATE_MSB                                              6
#define RX_SCOPE_PHASE_UPDATE_MASK                                             0x40
#define RX_SCOPE_PHASE_UPDATE_GET(x)                                           (((x) & RX_SCOPE_PHASE_UPDATE_MASK) >> RX_SCOPE_PHASE_UPDATE_LSB)
#define RX_SCOPE_PHASE_UPDATE_SET(x)                                           (((0 | (x)) << RX_SCOPE_PHASE_UPDATE_LSB) & RX_SCOPE_PHASE_UPDATE_MASK)
#define RX_SCOPE_PHASE_UPDATE_RESET                                            0x0
#define RX_SCOPE_PHASE_SAMPLE_PHASE_LSB                                        0
#define RX_SCOPE_PHASE_SAMPLE_PHASE_MSB                                        5
#define RX_SCOPE_PHASE_SAMPLE_PHASE_MASK                                       0x3f
#define RX_SCOPE_PHASE_SAMPLE_PHASE_GET(x)                                     (((x) & RX_SCOPE_PHASE_SAMPLE_PHASE_MASK) >> RX_SCOPE_PHASE_SAMPLE_PHASE_LSB)
#define RX_SCOPE_PHASE_SAMPLE_PHASE_SET(x)                                     (((0 | (x)) << RX_SCOPE_PHASE_SAMPLE_PHASE_LSB) & RX_SCOPE_PHASE_SAMPLE_PHASE_MASK)
#define RX_SCOPE_PHASE_SAMPLE_PHASE_RESET                                      0x0
#define RX_SCOPE_PHASE_ADDRESS                                                 (0x4064 + __PCIE_PHY_REG_BASE_ADDRESS)
#define RX_SCOPE_PHASE_RSTMASK                                                 0x7fff
#define RX_SCOPE_PHASE_RESET                                                   0x0

// 0x4068 (RX_DPLL_FREQ)
#define RX_DPLL_FREQ_VAL_LSB                                                   1
#define RX_DPLL_FREQ_VAL_MSB                                                   12
#define RX_DPLL_FREQ_VAL_MASK                                                  0x1ffe
#define RX_DPLL_FREQ_VAL_GET(x)                                                (((x) & RX_DPLL_FREQ_VAL_MASK) >> RX_DPLL_FREQ_VAL_LSB)
#define RX_DPLL_FREQ_VAL_SET(x)                                                (((0 | (x)) << RX_DPLL_FREQ_VAL_LSB) & RX_DPLL_FREQ_VAL_MASK)
#define RX_DPLL_FREQ_VAL_RESET                                                 0x0
#define RX_DPLL_FREQ_DTHR_LSB                                                  0
#define RX_DPLL_FREQ_DTHR_MSB                                                  0
#define RX_DPLL_FREQ_DTHR_MASK                                                 0x1
#define RX_DPLL_FREQ_DTHR_GET(x)                                               (((x) & RX_DPLL_FREQ_DTHR_MASK) >> RX_DPLL_FREQ_DTHR_LSB)
#define RX_DPLL_FREQ_DTHR_SET(x)                                               (((0 | (x)) << RX_DPLL_FREQ_DTHR_LSB) & RX_DPLL_FREQ_DTHR_MASK)
#define RX_DPLL_FREQ_DTHR_RESET                                                0x0
#define RX_DPLL_FREQ_ADDRESS                                                   (0x4068 + __PCIE_PHY_REG_BASE_ADDRESS)
#define RX_DPLL_FREQ_RSTMASK                                                   0x1fff
#define RX_DPLL_FREQ_RESET                                                     0x0

// 0x406c (RX_CDR_CTL)
#define RX_CDR_CTL_DTB_SEL_LSB                                                 12
#define RX_CDR_CTL_DTB_SEL_MSB                                                 15
#define RX_CDR_CTL_DTB_SEL_MASK                                                0xf000
#define RX_CDR_CTL_DTB_SEL_GET(x)                                              (((x) & RX_CDR_CTL_DTB_SEL_MASK) >> RX_CDR_CTL_DTB_SEL_LSB)
#define RX_CDR_CTL_DTB_SEL_SET(x)                                              (((0 | (x)) << RX_CDR_CTL_DTB_SEL_LSB) & RX_CDR_CTL_DTB_SEL_MASK)
#define RX_CDR_CTL_DTB_SEL_RESET                                               0x0
#define RX_CDR_CTL_ALWAYS_REALIGN_LSB                                          11
#define RX_CDR_CTL_ALWAYS_REALIGN_MSB                                          11
#define RX_CDR_CTL_ALWAYS_REALIGN_MASK                                         0x800
#define RX_CDR_CTL_ALWAYS_REALIGN_GET(x)                                       (((x) & RX_CDR_CTL_ALWAYS_REALIGN_MASK) >> RX_CDR_CTL_ALWAYS_REALIGN_LSB)
#define RX_CDR_CTL_ALWAYS_REALIGN_SET(x)                                       (((0 | (x)) << RX_CDR_CTL_ALWAYS_REALIGN_LSB) & RX_CDR_CTL_ALWAYS_REALIGN_MASK)
#define RX_CDR_CTL_ALWAYS_REALIGN_RESET                                        0x0
#define RX_CDR_CTL_FAST_START_LSB                                              10
#define RX_CDR_CTL_FAST_START_MSB                                              10
#define RX_CDR_CTL_FAST_START_MASK                                             0x400
#define RX_CDR_CTL_FAST_START_GET(x)                                           (((x) & RX_CDR_CTL_FAST_START_MASK) >> RX_CDR_CTL_FAST_START_LSB)
#define RX_CDR_CTL_FAST_START_SET(x)                                           (((0 | (x)) << RX_CDR_CTL_FAST_START_LSB) & RX_CDR_CTL_FAST_START_MASK)
#define RX_CDR_CTL_FAST_START_RESET                                            0x0
#define RX_CDR_CTL_FRUG_VALUE_LSB                                              8
#define RX_CDR_CTL_FRUG_VALUE_MSB                                              9
#define RX_CDR_CTL_FRUG_VALUE_MASK                                             0x300
#define RX_CDR_CTL_FRUG_VALUE_GET(x)                                           (((x) & RX_CDR_CTL_FRUG_VALUE_MASK) >> RX_CDR_CTL_FRUG_VALUE_LSB)
#define RX_CDR_CTL_FRUG_VALUE_SET(x)                                           (((0 | (x)) << RX_CDR_CTL_FRUG_VALUE_LSB) & RX_CDR_CTL_FRUG_VALUE_MASK)
#define RX_CDR_CTL_FRUG_VALUE_RESET                                            0x0
#define RX_CDR_CTL_PHUG_VALUE_LSB                                              6
#define RX_CDR_CTL_PHUG_VALUE_MSB                                              7
#define RX_CDR_CTL_PHUG_VALUE_MASK                                             0xc0
#define RX_CDR_CTL_PHUG_VALUE_GET(x)                                           (((x) & RX_CDR_CTL_PHUG_VALUE_MASK) >> RX_CDR_CTL_PHUG_VALUE_LSB)
#define RX_CDR_CTL_PHUG_VALUE_SET(x)                                           (((0 | (x)) << RX_CDR_CTL_PHUG_VALUE_LSB) & RX_CDR_CTL_PHUG_VALUE_MASK)
#define RX_CDR_CTL_PHUG_VALUE_RESET                                            0x0
#define RX_CDR_CTL_OVRD_DPLL_GAIN_LSB                                          5
#define RX_CDR_CTL_OVRD_DPLL_GAIN_MSB                                          5
#define RX_CDR_CTL_OVRD_DPLL_GAIN_MASK                                         0x20
#define RX_CDR_CTL_OVRD_DPLL_GAIN_GET(x)                                       (((x) & RX_CDR_CTL_OVRD_DPLL_GAIN_MASK) >> RX_CDR_CTL_OVRD_DPLL_GAIN_LSB)
#define RX_CDR_CTL_OVRD_DPLL_GAIN_SET(x)                                       (((0 | (x)) << RX_CDR_CTL_OVRD_DPLL_GAIN_LSB) & RX_CDR_CTL_OVRD_DPLL_GAIN_MASK)
#define RX_CDR_CTL_OVRD_DPLL_GAIN_RESET                                        0x0
#define RX_CDR_CTL_PHDET_POL_LSB                                               4
#define RX_CDR_CTL_PHDET_POL_MSB                                               4
#define RX_CDR_CTL_PHDET_POL_MASK                                              0x10
#define RX_CDR_CTL_PHDET_POL_GET(x)                                            (((x) & RX_CDR_CTL_PHDET_POL_MASK) >> RX_CDR_CTL_PHDET_POL_LSB)
#define RX_CDR_CTL_PHDET_POL_SET(x)                                            (((0 | (x)) << RX_CDR_CTL_PHDET_POL_LSB) & RX_CDR_CTL_PHDET_POL_MASK)
#define RX_CDR_CTL_PHDET_POL_RESET                                             0x0
#define RX_CDR_CTL_PHDET_EDGE_LSB                                              2
#define RX_CDR_CTL_PHDET_EDGE_MSB                                              3
#define RX_CDR_CTL_PHDET_EDGE_MASK                                             0xc
#define RX_CDR_CTL_PHDET_EDGE_GET(x)                                           (((x) & RX_CDR_CTL_PHDET_EDGE_MASK) >> RX_CDR_CTL_PHDET_EDGE_LSB)
#define RX_CDR_CTL_PHDET_EDGE_SET(x)                                           (((0 | (x)) << RX_CDR_CTL_PHDET_EDGE_LSB) & RX_CDR_CTL_PHDET_EDGE_MASK)
#define RX_CDR_CTL_PHDET_EDGE_RESET                                            0x3
#define RX_CDR_CTL_PHDET_EN_LSB                                                0
#define RX_CDR_CTL_PHDET_EN_MSB                                                1
#define RX_CDR_CTL_PHDET_EN_MASK                                               0x3
#define RX_CDR_CTL_PHDET_EN_GET(x)                                             (((x) & RX_CDR_CTL_PHDET_EN_MASK) >> RX_CDR_CTL_PHDET_EN_LSB)
#define RX_CDR_CTL_PHDET_EN_SET(x)                                             (((0 | (x)) << RX_CDR_CTL_PHDET_EN_LSB) & RX_CDR_CTL_PHDET_EN_MASK)
#define RX_CDR_CTL_PHDET_EN_RESET                                              0x3
#define RX_CDR_CTL_ADDRESS                                                     (0x406c + __PCIE_PHY_REG_BASE_ADDRESS)
#define RX_CDR_CTL_RSTMASK                                                     0xffff
#define RX_CDR_CTL_RESET                                                       0xf

// 0x4070 (RX_CDR_CDR_FSM_DEBUG)
#define RX_CDR_CDR_FSM_DEBUG_ADAP_RX_EQ_LSB                                    13
#define RX_CDR_CDR_FSM_DEBUG_ADAP_RX_EQ_MSB                                    15
#define RX_CDR_CDR_FSM_DEBUG_ADAP_RX_EQ_MASK                                   0xe000
#define RX_CDR_CDR_FSM_DEBUG_ADAP_RX_EQ_GET(x)                                 (((x) & RX_CDR_CDR_FSM_DEBUG_ADAP_RX_EQ_MASK) >> RX_CDR_CDR_FSM_DEBUG_ADAP_RX_EQ_LSB)
#define RX_CDR_CDR_FSM_DEBUG_ADAP_RX_EQ_SET(x)                                 (((0 | (x)) << RX_CDR_CDR_FSM_DEBUG_ADAP_RX_EQ_LSB) & RX_CDR_CDR_FSM_DEBUG_ADAP_RX_EQ_MASK)
#define RX_CDR_CDR_FSM_DEBUG_ADAP_RX_EQ_RESET                                  0x0
#define RX_CDR_CDR_FSM_DEBUG_RX_EQ_CTR_LSB                                     10
#define RX_CDR_CDR_FSM_DEBUG_RX_EQ_CTR_MSB                                     12
#define RX_CDR_CDR_FSM_DEBUG_RX_EQ_CTR_MASK                                    0x1c00
#define RX_CDR_CDR_FSM_DEBUG_RX_EQ_CTR_GET(x)                                  (((x) & RX_CDR_CDR_FSM_DEBUG_RX_EQ_CTR_MASK) >> RX_CDR_CDR_FSM_DEBUG_RX_EQ_CTR_LSB)
#define RX_CDR_CDR_FSM_DEBUG_RX_EQ_CTR_SET(x)                                  (((0 | (x)) << RX_CDR_CDR_FSM_DEBUG_RX_EQ_CTR_LSB) & RX_CDR_CDR_FSM_DEBUG_RX_EQ_CTR_MASK)
#define RX_CDR_CDR_FSM_DEBUG_RX_EQ_CTR_RESET                                   0x0
#define RX_CDR_CDR_FSM_DEBUG_RX_ANA_EQ_LSB                                     7
#define RX_CDR_CDR_FSM_DEBUG_RX_ANA_EQ_MSB                                     9
#define RX_CDR_CDR_FSM_DEBUG_RX_ANA_EQ_MASK                                    0x380
#define RX_CDR_CDR_FSM_DEBUG_RX_ANA_EQ_GET(x)                                  (((x) & RX_CDR_CDR_FSM_DEBUG_RX_ANA_EQ_MASK) >> RX_CDR_CDR_FSM_DEBUG_RX_ANA_EQ_LSB)
#define RX_CDR_CDR_FSM_DEBUG_RX_ANA_EQ_SET(x)                                  (((0 | (x)) << RX_CDR_CDR_FSM_DEBUG_RX_ANA_EQ_LSB) & RX_CDR_CDR_FSM_DEBUG_RX_ANA_EQ_MASK)
#define RX_CDR_CDR_FSM_DEBUG_RX_ANA_EQ_RESET                                   0x0
#define RX_CDR_CDR_FSM_DEBUG_ADAP_RX_VALID_LSB                                 6
#define RX_CDR_CDR_FSM_DEBUG_ADAP_RX_VALID_MSB                                 6
#define RX_CDR_CDR_FSM_DEBUG_ADAP_RX_VALID_MASK                                0x40
#define RX_CDR_CDR_FSM_DEBUG_ADAP_RX_VALID_GET(x)                              (((x) & RX_CDR_CDR_FSM_DEBUG_ADAP_RX_VALID_MASK) >> RX_CDR_CDR_FSM_DEBUG_ADAP_RX_VALID_LSB)
#define RX_CDR_CDR_FSM_DEBUG_ADAP_RX_VALID_SET(x)                              (((0 | (x)) << RX_CDR_CDR_FSM_DEBUG_ADAP_RX_VALID_LSB) & RX_CDR_CDR_FSM_DEBUG_ADAP_RX_VALID_MASK)
#define RX_CDR_CDR_FSM_DEBUG_ADAP_RX_VALID_RESET                               0x0
#define RX_CDR_CDR_FSM_DEBUG_CDR_EN_ADAP_LSB                                   5
#define RX_CDR_CDR_FSM_DEBUG_CDR_EN_ADAP_MSB                                   5
#define RX_CDR_CDR_FSM_DEBUG_CDR_EN_ADAP_MASK                                  0x20
#define RX_CDR_CDR_FSM_DEBUG_CDR_EN_ADAP_GET(x)                                (((x) & RX_CDR_CDR_FSM_DEBUG_CDR_EN_ADAP_MASK) >> RX_CDR_CDR_FSM_DEBUG_CDR_EN_ADAP_LSB)
#define RX_CDR_CDR_FSM_DEBUG_CDR_EN_ADAP_SET(x)                                (((0 | (x)) << RX_CDR_CDR_FSM_DEBUG_CDR_EN_ADAP_LSB) & RX_CDR_CDR_FSM_DEBUG_CDR_EN_ADAP_MASK)
#define RX_CDR_CDR_FSM_DEBUG_CDR_EN_ADAP_RESET                                 0x0
#define RX_CDR_CDR_FSM_DEBUG_CDR_EN_EQ_LSB                                     4
#define RX_CDR_CDR_FSM_DEBUG_CDR_EN_EQ_MSB                                     4
#define RX_CDR_CDR_FSM_DEBUG_CDR_EN_EQ_MASK                                    0x10
#define RX_CDR_CDR_FSM_DEBUG_CDR_EN_EQ_GET(x)                                  (((x) & RX_CDR_CDR_FSM_DEBUG_CDR_EN_EQ_MASK) >> RX_CDR_CDR_FSM_DEBUG_CDR_EN_EQ_LSB)
#define RX_CDR_CDR_FSM_DEBUG_CDR_EN_EQ_SET(x)                                  (((0 | (x)) << RX_CDR_CDR_FSM_DEBUG_CDR_EN_EQ_LSB) & RX_CDR_CDR_FSM_DEBUG_CDR_EN_EQ_MASK)
#define RX_CDR_CDR_FSM_DEBUG_CDR_EN_EQ_RESET                                   0x0
#define RX_CDR_CDR_FSM_DEBUG_ALIGNED_LSB                                       3
#define RX_CDR_CDR_FSM_DEBUG_ALIGNED_MSB                                       3
#define RX_CDR_CDR_FSM_DEBUG_ALIGNED_MASK                                      0x8
#define RX_CDR_CDR_FSM_DEBUG_ALIGNED_GET(x)                                    (((x) & RX_CDR_CDR_FSM_DEBUG_ALIGNED_MASK) >> RX_CDR_CDR_FSM_DEBUG_ALIGNED_LSB)
#define RX_CDR_CDR_FSM_DEBUG_ALIGNED_SET(x)                                    (((0 | (x)) << RX_CDR_CDR_FSM_DEBUG_ALIGNED_LSB) & RX_CDR_CDR_FSM_DEBUG_ALIGNED_MASK)
#define RX_CDR_CDR_FSM_DEBUG_ALIGNED_RESET                                     0x0
#define RX_CDR_CDR_FSM_DEBUG_CDR_RX_VALID_LSB                                  2
#define RX_CDR_CDR_FSM_DEBUG_CDR_RX_VALID_MSB                                  2
#define RX_CDR_CDR_FSM_DEBUG_CDR_RX_VALID_MASK                                 0x4
#define RX_CDR_CDR_FSM_DEBUG_CDR_RX_VALID_GET(x)                               (((x) & RX_CDR_CDR_FSM_DEBUG_CDR_RX_VALID_MASK) >> RX_CDR_CDR_FSM_DEBUG_CDR_RX_VALID_LSB)
#define RX_CDR_CDR_FSM_DEBUG_CDR_RX_VALID_SET(x)                               (((0 | (x)) << RX_CDR_CDR_FSM_DEBUG_CDR_RX_VALID_LSB) & RX_CDR_CDR_FSM_DEBUG_CDR_RX_VALID_MASK)
#define RX_CDR_CDR_FSM_DEBUG_CDR_RX_VALID_RESET                                0x0
#define RX_CDR_CDR_FSM_DEBUG_CDR_TIMEOUT_LSB                                   1
#define RX_CDR_CDR_FSM_DEBUG_CDR_TIMEOUT_MSB                                   1
#define RX_CDR_CDR_FSM_DEBUG_CDR_TIMEOUT_MASK                                  0x2
#define RX_CDR_CDR_FSM_DEBUG_CDR_TIMEOUT_GET(x)                                (((x) & RX_CDR_CDR_FSM_DEBUG_CDR_TIMEOUT_MASK) >> RX_CDR_CDR_FSM_DEBUG_CDR_TIMEOUT_LSB)
#define RX_CDR_CDR_FSM_DEBUG_CDR_TIMEOUT_SET(x)                                (((0 | (x)) << RX_CDR_CDR_FSM_DEBUG_CDR_TIMEOUT_LSB) & RX_CDR_CDR_FSM_DEBUG_CDR_TIMEOUT_MASK)
#define RX_CDR_CDR_FSM_DEBUG_CDR_TIMEOUT_RESET                                 0x0
#define RX_CDR_CDR_FSM_DEBUG_CDR_EN_LSB                                        0
#define RX_CDR_CDR_FSM_DEBUG_CDR_EN_MSB                                        0
#define RX_CDR_CDR_FSM_DEBUG_CDR_EN_MASK                                       0x1
#define RX_CDR_CDR_FSM_DEBUG_CDR_EN_GET(x)                                     (((x) & RX_CDR_CDR_FSM_DEBUG_CDR_EN_MASK) >> RX_CDR_CDR_FSM_DEBUG_CDR_EN_LSB)
#define RX_CDR_CDR_FSM_DEBUG_CDR_EN_SET(x)                                     (((0 | (x)) << RX_CDR_CDR_FSM_DEBUG_CDR_EN_LSB) & RX_CDR_CDR_FSM_DEBUG_CDR_EN_MASK)
#define RX_CDR_CDR_FSM_DEBUG_CDR_EN_RESET                                      0x0
#define RX_CDR_CDR_FSM_DEBUG_ADDRESS                                           (0x4070 + __PCIE_PHY_REG_BASE_ADDRESS)
#define RX_CDR_CDR_FSM_DEBUG_RSTMASK                                           0xffff
#define RX_CDR_CDR_FSM_DEBUG_RESET                                             0x0

// 0x4074 (RX_CDR_LOCK_VEC_OVRD)
#define RX_CDR_LOCK_VEC_OVRD_ADAP_CTR_LEVEL_LSB                                11
#define RX_CDR_LOCK_VEC_OVRD_ADAP_CTR_LEVEL_MSB                                15
#define RX_CDR_LOCK_VEC_OVRD_ADAP_CTR_LEVEL_MASK                               0xf800
#define RX_CDR_LOCK_VEC_OVRD_ADAP_CTR_LEVEL_GET(x)                             (((x) & RX_CDR_LOCK_VEC_OVRD_ADAP_CTR_LEVEL_MASK) >> RX_CDR_LOCK_VEC_OVRD_ADAP_CTR_LEVEL_LSB)
#define RX_CDR_LOCK_VEC_OVRD_ADAP_CTR_LEVEL_SET(x)                             (((0 | (x)) << RX_CDR_LOCK_VEC_OVRD_ADAP_CTR_LEVEL_LSB) & RX_CDR_LOCK_VEC_OVRD_ADAP_CTR_LEVEL_MASK)
#define RX_CDR_LOCK_VEC_OVRD_ADAP_CTR_LEVEL_RESET                              0x10
#define RX_CDR_LOCK_VEC_OVRD_ADAP_POLARITY_LSB                                 10
#define RX_CDR_LOCK_VEC_OVRD_ADAP_POLARITY_MSB                                 10
#define RX_CDR_LOCK_VEC_OVRD_ADAP_POLARITY_MASK                                0x400
#define RX_CDR_LOCK_VEC_OVRD_ADAP_POLARITY_GET(x)                              (((x) & RX_CDR_LOCK_VEC_OVRD_ADAP_POLARITY_MASK) >> RX_CDR_LOCK_VEC_OVRD_ADAP_POLARITY_LSB)
#define RX_CDR_LOCK_VEC_OVRD_ADAP_POLARITY_SET(x)                              (((0 | (x)) << RX_CDR_LOCK_VEC_OVRD_ADAP_POLARITY_LSB) & RX_CDR_LOCK_VEC_OVRD_ADAP_POLARITY_MASK)
#define RX_CDR_LOCK_VEC_OVRD_ADAP_POLARITY_RESET                               0x0
#define RX_CDR_LOCK_VEC_OVRD_LOCK_VECTOR_OVRD_LSB                              9
#define RX_CDR_LOCK_VEC_OVRD_LOCK_VECTOR_OVRD_MSB                              9
#define RX_CDR_LOCK_VEC_OVRD_LOCK_VECTOR_OVRD_MASK                             0x200
#define RX_CDR_LOCK_VEC_OVRD_LOCK_VECTOR_OVRD_GET(x)                           (((x) & RX_CDR_LOCK_VEC_OVRD_LOCK_VECTOR_OVRD_MASK) >> RX_CDR_LOCK_VEC_OVRD_LOCK_VECTOR_OVRD_LSB)
#define RX_CDR_LOCK_VEC_OVRD_LOCK_VECTOR_OVRD_SET(x)                           (((0 | (x)) << RX_CDR_LOCK_VEC_OVRD_LOCK_VECTOR_OVRD_LSB) & RX_CDR_LOCK_VEC_OVRD_LOCK_VECTOR_OVRD_MASK)
#define RX_CDR_LOCK_VEC_OVRD_LOCK_VECTOR_OVRD_RESET                            0x0
#define RX_CDR_LOCK_VEC_OVRD_LOCK_VECTOR_EN_LSB                                8
#define RX_CDR_LOCK_VEC_OVRD_LOCK_VECTOR_EN_MSB                                8
#define RX_CDR_LOCK_VEC_OVRD_LOCK_VECTOR_EN_MASK                               0x100
#define RX_CDR_LOCK_VEC_OVRD_LOCK_VECTOR_EN_GET(x)                             (((x) & RX_CDR_LOCK_VEC_OVRD_LOCK_VECTOR_EN_MASK) >> RX_CDR_LOCK_VEC_OVRD_LOCK_VECTOR_EN_LSB)
#define RX_CDR_LOCK_VEC_OVRD_LOCK_VECTOR_EN_SET(x)                             (((0 | (x)) << RX_CDR_LOCK_VEC_OVRD_LOCK_VECTOR_EN_LSB) & RX_CDR_LOCK_VEC_OVRD_LOCK_VECTOR_EN_MASK)
#define RX_CDR_LOCK_VEC_OVRD_LOCK_VECTOR_EN_RESET                              0x0
#define RX_CDR_LOCK_VEC_OVRD_LOCK_VECTOR_LSB                                   0
#define RX_CDR_LOCK_VEC_OVRD_LOCK_VECTOR_MSB                                   7
#define RX_CDR_LOCK_VEC_OVRD_LOCK_VECTOR_MASK                                  0xff
#define RX_CDR_LOCK_VEC_OVRD_LOCK_VECTOR_GET(x)                                (((x) & RX_CDR_LOCK_VEC_OVRD_LOCK_VECTOR_MASK) >> RX_CDR_LOCK_VEC_OVRD_LOCK_VECTOR_LSB)
#define RX_CDR_LOCK_VEC_OVRD_LOCK_VECTOR_SET(x)                                (((0 | (x)) << RX_CDR_LOCK_VEC_OVRD_LOCK_VECTOR_LSB) & RX_CDR_LOCK_VEC_OVRD_LOCK_VECTOR_MASK)
#define RX_CDR_LOCK_VEC_OVRD_LOCK_VECTOR_RESET                                 0x0
#define RX_CDR_LOCK_VEC_OVRD_ADDRESS                                           (0x4074 + __PCIE_PHY_REG_BASE_ADDRESS)
#define RX_CDR_LOCK_VEC_OVRD_RSTMASK                                           0xffff
#define RX_CDR_LOCK_VEC_OVRD_RESET                                             0x8000

// 0x4078 (RX_CDR_LOCK_VEC)
#define RX_CDR_LOCK_VEC_EQ_RX_EQ_LSB                                           9
#define RX_CDR_LOCK_VEC_EQ_RX_EQ_MSB                                           11
#define RX_CDR_LOCK_VEC_EQ_RX_EQ_MASK                                          0xe00
#define RX_CDR_LOCK_VEC_EQ_RX_EQ_GET(x)                                        (((x) & RX_CDR_LOCK_VEC_EQ_RX_EQ_MASK) >> RX_CDR_LOCK_VEC_EQ_RX_EQ_LSB)
#define RX_CDR_LOCK_VEC_EQ_RX_EQ_SET(x)                                        (((0 | (x)) << RX_CDR_LOCK_VEC_EQ_RX_EQ_LSB) & RX_CDR_LOCK_VEC_EQ_RX_EQ_MASK)
#define RX_CDR_LOCK_VEC_EQ_RX_EQ_RESET                                         0x0
#define RX_CDR_LOCK_VEC_EQ_LOCKED_VECTOR_EN_LSB                                8
#define RX_CDR_LOCK_VEC_EQ_LOCKED_VECTOR_EN_MSB                                8
#define RX_CDR_LOCK_VEC_EQ_LOCKED_VECTOR_EN_MASK                               0x100
#define RX_CDR_LOCK_VEC_EQ_LOCKED_VECTOR_EN_GET(x)                             (((x) & RX_CDR_LOCK_VEC_EQ_LOCKED_VECTOR_EN_MASK) >> RX_CDR_LOCK_VEC_EQ_LOCKED_VECTOR_EN_LSB)
#define RX_CDR_LOCK_VEC_EQ_LOCKED_VECTOR_EN_SET(x)                             (((0 | (x)) << RX_CDR_LOCK_VEC_EQ_LOCKED_VECTOR_EN_LSB) & RX_CDR_LOCK_VEC_EQ_LOCKED_VECTOR_EN_MASK)
#define RX_CDR_LOCK_VEC_EQ_LOCKED_VECTOR_EN_RESET                              0x0
#define RX_CDR_LOCK_VEC_EQ_LOCKED_VECTOR_LSB                                   0
#define RX_CDR_LOCK_VEC_EQ_LOCKED_VECTOR_MSB                                   7
#define RX_CDR_LOCK_VEC_EQ_LOCKED_VECTOR_MASK                                  0xff
#define RX_CDR_LOCK_VEC_EQ_LOCKED_VECTOR_GET(x)                                (((x) & RX_CDR_LOCK_VEC_EQ_LOCKED_VECTOR_MASK) >> RX_CDR_LOCK_VEC_EQ_LOCKED_VECTOR_LSB)
#define RX_CDR_LOCK_VEC_EQ_LOCKED_VECTOR_SET(x)                                (((0 | (x)) << RX_CDR_LOCK_VEC_EQ_LOCKED_VECTOR_LSB) & RX_CDR_LOCK_VEC_EQ_LOCKED_VECTOR_MASK)
#define RX_CDR_LOCK_VEC_EQ_LOCKED_VECTOR_RESET                                 0x0
#define RX_CDR_LOCK_VEC_ADDRESS                                                (0x4078 + __PCIE_PHY_REG_BASE_ADDRESS)
#define RX_CDR_LOCK_VEC_RSTMASK                                                0xfff
#define RX_CDR_LOCK_VEC_RESET                                                  0x0

// 0x407c (RX_CDR_ADAP_FSM)
#define RX_CDR_ADAP_FSM_MSTR_CTR_LSB                                           11
#define RX_CDR_ADAP_FSM_MSTR_CTR_MSB                                           15
#define RX_CDR_ADAP_FSM_MSTR_CTR_MASK                                          0xf800
#define RX_CDR_ADAP_FSM_MSTR_CTR_GET(x)                                        (((x) & RX_CDR_ADAP_FSM_MSTR_CTR_MASK) >> RX_CDR_ADAP_FSM_MSTR_CTR_LSB)
#define RX_CDR_ADAP_FSM_MSTR_CTR_SET(x)                                        (((0 | (x)) << RX_CDR_ADAP_FSM_MSTR_CTR_LSB) & RX_CDR_ADAP_FSM_MSTR_CTR_MASK)
#define RX_CDR_ADAP_FSM_MSTR_CTR_RESET                                         0x0
#define RX_CDR_ADAP_FSM_LOOP_CTR_LSB                                           7
#define RX_CDR_ADAP_FSM_LOOP_CTR_MSB                                           10
#define RX_CDR_ADAP_FSM_LOOP_CTR_MASK                                          0x780
#define RX_CDR_ADAP_FSM_LOOP_CTR_GET(x)                                        (((x) & RX_CDR_ADAP_FSM_LOOP_CTR_MASK) >> RX_CDR_ADAP_FSM_LOOP_CTR_LSB)
#define RX_CDR_ADAP_FSM_LOOP_CTR_SET(x)                                        (((0 | (x)) << RX_CDR_ADAP_FSM_LOOP_CTR_LSB) & RX_CDR_ADAP_FSM_LOOP_CTR_MASK)
#define RX_CDR_ADAP_FSM_LOOP_CTR_RESET                                         0x0
#define RX_CDR_ADAP_FSM_ADAP_CTR_LSB                                           3
#define RX_CDR_ADAP_FSM_ADAP_CTR_MSB                                           6
#define RX_CDR_ADAP_FSM_ADAP_CTR_MASK                                          0x78
#define RX_CDR_ADAP_FSM_ADAP_CTR_GET(x)                                        (((x) & RX_CDR_ADAP_FSM_ADAP_CTR_MASK) >> RX_CDR_ADAP_FSM_ADAP_CTR_LSB)
#define RX_CDR_ADAP_FSM_ADAP_CTR_SET(x)                                        (((0 | (x)) << RX_CDR_ADAP_FSM_ADAP_CTR_LSB) & RX_CDR_ADAP_FSM_ADAP_CTR_MASK)
#define RX_CDR_ADAP_FSM_ADAP_CTR_RESET                                         0x0
#define RX_CDR_ADAP_FSM_ADAP_STATE_LSB                                         0
#define RX_CDR_ADAP_FSM_ADAP_STATE_MSB                                         2
#define RX_CDR_ADAP_FSM_ADAP_STATE_MASK                                        0x7
#define RX_CDR_ADAP_FSM_ADAP_STATE_GET(x)                                      (((x) & RX_CDR_ADAP_FSM_ADAP_STATE_MASK) >> RX_CDR_ADAP_FSM_ADAP_STATE_LSB)
#define RX_CDR_ADAP_FSM_ADAP_STATE_SET(x)                                      (((0 | (x)) << RX_CDR_ADAP_FSM_ADAP_STATE_LSB) & RX_CDR_ADAP_FSM_ADAP_STATE_MASK)
#define RX_CDR_ADAP_FSM_ADAP_STATE_RESET                                       0x0
#define RX_CDR_ADAP_FSM_ADDRESS                                                (0x407c + __PCIE_PHY_REG_BASE_ADDRESS)
#define RX_CDR_ADAP_FSM_RSTMASK                                                0xffff
#define RX_CDR_ADAP_FSM_RESET                                                  0x0

// 0x4080 (RX_ATB0)
#define RX_ATB0_EN_ATB_LSB                                                     7
#define RX_ATB0_EN_ATB_MSB                                                     7
#define RX_ATB0_EN_ATB_MASK                                                    0x80
#define RX_ATB0_EN_ATB_GET(x)                                                  (((x) & RX_ATB0_EN_ATB_MASK) >> RX_ATB0_EN_ATB_LSB)
#define RX_ATB0_EN_ATB_SET(x)                                                  (((0 | (x)) << RX_ATB0_EN_ATB_LSB) & RX_ATB0_EN_ATB_MASK)
#define RX_ATB0_EN_ATB_RESET                                                   0x0
#define RX_ATB0_EN_MARG_LSB                                                    6
#define RX_ATB0_EN_MARG_MSB                                                    6
#define RX_ATB0_EN_MARG_MASK                                                   0x40
#define RX_ATB0_EN_MARG_GET(x)                                                 (((x) & RX_ATB0_EN_MARG_MASK) >> RX_ATB0_EN_MARG_LSB)
#define RX_ATB0_EN_MARG_SET(x)                                                 (((0 | (x)) << RX_ATB0_EN_MARG_LSB) & RX_ATB0_EN_MARG_MASK)
#define RX_ATB0_EN_MARG_RESET                                                  0x0
#define RX_ATB0_EN_ATB_RM_F_LSB                                                5
#define RX_ATB0_EN_ATB_RM_F_MSB                                                5
#define RX_ATB0_EN_ATB_RM_F_MASK                                               0x20
#define RX_ATB0_EN_ATB_RM_F_GET(x)                                             (((x) & RX_ATB0_EN_ATB_RM_F_MASK) >> RX_ATB0_EN_ATB_RM_F_LSB)
#define RX_ATB0_EN_ATB_RM_F_SET(x)                                             (((0 | (x)) << RX_ATB0_EN_ATB_RM_F_LSB) & RX_ATB0_EN_ATB_RM_F_MASK)
#define RX_ATB0_EN_ATB_RM_F_RESET                                              0x0
#define RX_ATB0_EN_ATB_RM_S_LSB                                                4
#define RX_ATB0_EN_ATB_RM_S_MSB                                                4
#define RX_ATB0_EN_ATB_RM_S_MASK                                               0x10
#define RX_ATB0_EN_ATB_RM_S_GET(x)                                             (((x) & RX_ATB0_EN_ATB_RM_S_MASK) >> RX_ATB0_EN_ATB_RM_S_LSB)
#define RX_ATB0_EN_ATB_RM_S_SET(x)                                             (((0 | (x)) << RX_ATB0_EN_ATB_RM_S_LSB) & RX_ATB0_EN_ATB_RM_S_MASK)
#define RX_ATB0_EN_ATB_RM_S_RESET                                              0x0
#define RX_ATB0_EN_ATB_RP_F_LSB                                                3
#define RX_ATB0_EN_ATB_RP_F_MSB                                                3
#define RX_ATB0_EN_ATB_RP_F_MASK                                               0x8
#define RX_ATB0_EN_ATB_RP_F_GET(x)                                             (((x) & RX_ATB0_EN_ATB_RP_F_MASK) >> RX_ATB0_EN_ATB_RP_F_LSB)
#define RX_ATB0_EN_ATB_RP_F_SET(x)                                             (((0 | (x)) << RX_ATB0_EN_ATB_RP_F_LSB) & RX_ATB0_EN_ATB_RP_F_MASK)
#define RX_ATB0_EN_ATB_RP_F_RESET                                              0x0
#define RX_ATB0_EN_ATB_RP_S_LSB                                                2
#define RX_ATB0_EN_ATB_RP_S_MSB                                                2
#define RX_ATB0_EN_ATB_RP_S_MASK                                               0x4
#define RX_ATB0_EN_ATB_RP_S_GET(x)                                             (((x) & RX_ATB0_EN_ATB_RP_S_MASK) >> RX_ATB0_EN_ATB_RP_S_LSB)
#define RX_ATB0_EN_ATB_RP_S_SET(x)                                             (((0 | (x)) << RX_ATB0_EN_ATB_RP_S_LSB) & RX_ATB0_EN_ATB_RP_S_MASK)
#define RX_ATB0_EN_ATB_RP_S_RESET                                              0x0
#define RX_ATB0_EN_ATB_VOS_LSB                                                 1
#define RX_ATB0_EN_ATB_VOS_MSB                                                 1
#define RX_ATB0_EN_ATB_VOS_MASK                                                0x2
#define RX_ATB0_EN_ATB_VOS_GET(x)                                              (((x) & RX_ATB0_EN_ATB_VOS_MASK) >> RX_ATB0_EN_ATB_VOS_LSB)
#define RX_ATB0_EN_ATB_VOS_SET(x)                                              (((0 | (x)) << RX_ATB0_EN_ATB_VOS_LSB) & RX_ATB0_EN_ATB_VOS_MASK)
#define RX_ATB0_EN_ATB_VOS_RESET                                               0x0
#define RX_ATB0_EN_ATB_VOFF_LSB                                                0
#define RX_ATB0_EN_ATB_VOFF_MSB                                                0
#define RX_ATB0_EN_ATB_VOFF_MASK                                               0x1
#define RX_ATB0_EN_ATB_VOFF_GET(x)                                             (((x) & RX_ATB0_EN_ATB_VOFF_MASK) >> RX_ATB0_EN_ATB_VOFF_LSB)
#define RX_ATB0_EN_ATB_VOFF_SET(x)                                             (((0 | (x)) << RX_ATB0_EN_ATB_VOFF_LSB) & RX_ATB0_EN_ATB_VOFF_MASK)
#define RX_ATB0_EN_ATB_VOFF_RESET                                              0x0
#define RX_ATB0_ADDRESS                                                        (0x4080 + __PCIE_PHY_REG_BASE_ADDRESS)
#define RX_ATB0_RSTMASK                                                        0xff
#define RX_ATB0_RESET                                                          0x0

// 0x4084 (RX_ATB1)
#define RX_ATB1_VLOS_MAX_LSB                                                   7
#define RX_ATB1_VLOS_MAX_MSB                                                   7
#define RX_ATB1_VLOS_MAX_MASK                                                  0x80
#define RX_ATB1_VLOS_MAX_GET(x)                                                (((x) & RX_ATB1_VLOS_MAX_MASK) >> RX_ATB1_VLOS_MAX_LSB)
#define RX_ATB1_VLOS_MAX_SET(x)                                                (((0 | (x)) << RX_ATB1_VLOS_MAX_LSB) & RX_ATB1_VLOS_MAX_MASK)
#define RX_ATB1_VLOS_MAX_RESET                                                 0x0
#define RX_ATB1_VLOS_MIN_LSB                                                   6
#define RX_ATB1_VLOS_MIN_MSB                                                   6
#define RX_ATB1_VLOS_MIN_MASK                                                  0x40
#define RX_ATB1_VLOS_MIN_GET(x)                                                (((x) & RX_ATB1_VLOS_MIN_MASK) >> RX_ATB1_VLOS_MIN_LSB)
#define RX_ATB1_VLOS_MIN_SET(x)                                                (((0 | (x)) << RX_ATB1_VLOS_MIN_LSB) & RX_ATB1_VLOS_MIN_MASK)
#define RX_ATB1_VLOS_MIN_RESET                                                 0x0
#define RX_ATB1_EN_ATB_VLOS_LSB                                                5
#define RX_ATB1_EN_ATB_VLOS_MSB                                                5
#define RX_ATB1_EN_ATB_VLOS_MASK                                               0x20
#define RX_ATB1_EN_ATB_VLOS_GET(x)                                             (((x) & RX_ATB1_EN_ATB_VLOS_MASK) >> RX_ATB1_EN_ATB_VLOS_LSB)
#define RX_ATB1_EN_ATB_VLOS_SET(x)                                             (((0 | (x)) << RX_ATB1_EN_ATB_VLOS_LSB) & RX_ATB1_EN_ATB_VLOS_MASK)
#define RX_ATB1_EN_ATB_VLOS_RESET                                              0x0
#define RX_ATB1_EN_ATB_VRF_LSB                                                 4
#define RX_ATB1_EN_ATB_VRF_MSB                                                 4
#define RX_ATB1_EN_ATB_VRF_MASK                                                0x10
#define RX_ATB1_EN_ATB_VRF_GET(x)                                              (((x) & RX_ATB1_EN_ATB_VRF_MASK) >> RX_ATB1_EN_ATB_VRF_LSB)
#define RX_ATB1_EN_ATB_VRF_SET(x)                                              (((0 | (x)) << RX_ATB1_EN_ATB_VRF_LSB) & RX_ATB1_EN_ATB_VRF_MASK)
#define RX_ATB1_EN_ATB_VRF_RESET                                               0x0
#define RX_ATB1_MEAS_GD_LSB                                                    3
#define RX_ATB1_MEAS_GD_MSB                                                    3
#define RX_ATB1_MEAS_GD_MASK                                                   0x8
#define RX_ATB1_MEAS_GD_GET(x)                                                 (((x) & RX_ATB1_MEAS_GD_MASK) >> RX_ATB1_MEAS_GD_LSB)
#define RX_ATB1_MEAS_GD_SET(x)                                                 (((0 | (x)) << RX_ATB1_MEAS_GD_LSB) & RX_ATB1_MEAS_GD_MASK)
#define RX_ATB1_MEAS_GD_RESET                                                  0x0
#define RX_ATB1_MEAS_VP_LSB                                                    2
#define RX_ATB1_MEAS_VP_MSB                                                    2
#define RX_ATB1_MEAS_VP_MASK                                                   0x4
#define RX_ATB1_MEAS_VP_GET(x)                                                 (((x) & RX_ATB1_MEAS_VP_MASK) >> RX_ATB1_MEAS_VP_LSB)
#define RX_ATB1_MEAS_VP_SET(x)                                                 (((0 | (x)) << RX_ATB1_MEAS_VP_LSB) & RX_ATB1_MEAS_VP_MASK)
#define RX_ATB1_MEAS_VP_RESET                                                  0x0
#define RX_ATB1_EN_VLOS_USB3_LSB                                               1
#define RX_ATB1_EN_VLOS_USB3_MSB                                               1
#define RX_ATB1_EN_VLOS_USB3_MASK                                              0x2
#define RX_ATB1_EN_VLOS_USB3_GET(x)                                            (((x) & RX_ATB1_EN_VLOS_USB3_MASK) >> RX_ATB1_EN_VLOS_USB3_LSB)
#define RX_ATB1_EN_VLOS_USB3_SET(x)                                            (((0 | (x)) << RX_ATB1_EN_VLOS_USB3_LSB) & RX_ATB1_EN_VLOS_USB3_MASK)
#define RX_ATB1_EN_VLOS_USB3_RESET                                             0x0
#define RX_ATB1_RX_NC0_LSB                                                     0
#define RX_ATB1_RX_NC0_MSB                                                     0
#define RX_ATB1_RX_NC0_MASK                                                    0x1
#define RX_ATB1_RX_NC0_GET(x)                                                  (((x) & RX_ATB1_RX_NC0_MASK) >> RX_ATB1_RX_NC0_LSB)
#define RX_ATB1_RX_NC0_SET(x)                                                  (((0 | (x)) << RX_ATB1_RX_NC0_LSB) & RX_ATB1_RX_NC0_MASK)
#define RX_ATB1_RX_NC0_RESET                                                   0x0
#define RX_ATB1_ADDRESS                                                        (0x4084 + __PCIE_PHY_REG_BASE_ADDRESS)
#define RX_ATB1_RSTMASK                                                        0xff
#define RX_ATB1_RESET                                                          0x0

// 0x4088 (RX_ENPWR0)
#define RX_ENPWR0_CTL_RXPWRON_LSB                                              7
#define RX_ENPWR0_CTL_RXPWRON_MSB                                              7
#define RX_ENPWR0_CTL_RXPWRON_MASK                                             0x80
#define RX_ENPWR0_CTL_RXPWRON_GET(x)                                           (((x) & RX_ENPWR0_CTL_RXPWRON_MASK) >> RX_ENPWR0_CTL_RXPWRON_LSB)
#define RX_ENPWR0_CTL_RXPWRON_SET(x)                                           (((0 | (x)) << RX_ENPWR0_CTL_RXPWRON_LSB) & RX_ENPWR0_CTL_RXPWRON_MASK)
#define RX_ENPWR0_CTL_RXPWRON_RESET                                            0x0
#define RX_ENPWR0_LCL_RXPWRON_LSB                                              6
#define RX_ENPWR0_LCL_RXPWRON_MSB                                              6
#define RX_ENPWR0_LCL_RXPWRON_MASK                                             0x40
#define RX_ENPWR0_LCL_RXPWRON_GET(x)                                           (((x) & RX_ENPWR0_LCL_RXPWRON_MASK) >> RX_ENPWR0_LCL_RXPWRON_LSB)
#define RX_ENPWR0_LCL_RXPWRON_SET(x)                                           (((0 | (x)) << RX_ENPWR0_LCL_RXPWRON_LSB) & RX_ENPWR0_LCL_RXPWRON_MASK)
#define RX_ENPWR0_LCL_RXPWRON_RESET                                            0x0
#define RX_ENPWR0_CTL_EN_LOS_LSB                                               5
#define RX_ENPWR0_CTL_EN_LOS_MSB                                               5
#define RX_ENPWR0_CTL_EN_LOS_MASK                                              0x20
#define RX_ENPWR0_CTL_EN_LOS_GET(x)                                            (((x) & RX_ENPWR0_CTL_EN_LOS_MASK) >> RX_ENPWR0_CTL_EN_LOS_LSB)
#define RX_ENPWR0_CTL_EN_LOS_SET(x)                                            (((0 | (x)) << RX_ENPWR0_CTL_EN_LOS_LSB) & RX_ENPWR0_CTL_EN_LOS_MASK)
#define RX_ENPWR0_CTL_EN_LOS_RESET                                             0x0
#define RX_ENPWR0_LCL_EN_LOS_LSB                                               4
#define RX_ENPWR0_LCL_EN_LOS_MSB                                               4
#define RX_ENPWR0_LCL_EN_LOS_MASK                                              0x10
#define RX_ENPWR0_LCL_EN_LOS_GET(x)                                            (((x) & RX_ENPWR0_LCL_EN_LOS_MASK) >> RX_ENPWR0_LCL_EN_LOS_LSB)
#define RX_ENPWR0_LCL_EN_LOS_SET(x)                                            (((0 | (x)) << RX_ENPWR0_LCL_EN_LOS_LSB) & RX_ENPWR0_LCL_EN_LOS_MASK)
#define RX_ENPWR0_LCL_EN_LOS_RESET                                             0x0
#define RX_ENPWR0_CTL_RXCK_LSB                                                 3
#define RX_ENPWR0_CTL_RXCK_MSB                                                 3
#define RX_ENPWR0_CTL_RXCK_MASK                                                0x8
#define RX_ENPWR0_CTL_RXCK_GET(x)                                              (((x) & RX_ENPWR0_CTL_RXCK_MASK) >> RX_ENPWR0_CTL_RXCK_LSB)
#define RX_ENPWR0_CTL_RXCK_SET(x)                                              (((0 | (x)) << RX_ENPWR0_CTL_RXCK_LSB) & RX_ENPWR0_CTL_RXCK_MASK)
#define RX_ENPWR0_CTL_RXCK_RESET                                               0x0
#define RX_ENPWR0_LCL_RXCK_LSB                                                 2
#define RX_ENPWR0_LCL_RXCK_MSB                                                 2
#define RX_ENPWR0_LCL_RXCK_MASK                                                0x4
#define RX_ENPWR0_LCL_RXCK_GET(x)                                              (((x) & RX_ENPWR0_LCL_RXCK_MASK) >> RX_ENPWR0_LCL_RXCK_LSB)
#define RX_ENPWR0_LCL_RXCK_SET(x)                                              (((0 | (x)) << RX_ENPWR0_LCL_RXCK_LSB) & RX_ENPWR0_LCL_RXCK_MASK)
#define RX_ENPWR0_LCL_RXCK_RESET                                               0x0
#define RX_ENPWR0_CTL_ACJT_LSB                                                 1
#define RX_ENPWR0_CTL_ACJT_MSB                                                 1
#define RX_ENPWR0_CTL_ACJT_MASK                                                0x2
#define RX_ENPWR0_CTL_ACJT_GET(x)                                              (((x) & RX_ENPWR0_CTL_ACJT_MASK) >> RX_ENPWR0_CTL_ACJT_LSB)
#define RX_ENPWR0_CTL_ACJT_SET(x)                                              (((0 | (x)) << RX_ENPWR0_CTL_ACJT_LSB) & RX_ENPWR0_CTL_ACJT_MASK)
#define RX_ENPWR0_CTL_ACJT_RESET                                               0x0
#define RX_ENPWR0_LCL_ACJT_LSB                                                 0
#define RX_ENPWR0_LCL_ACJT_MSB                                                 0
#define RX_ENPWR0_LCL_ACJT_MASK                                                0x1
#define RX_ENPWR0_LCL_ACJT_GET(x)                                              (((x) & RX_ENPWR0_LCL_ACJT_MASK) >> RX_ENPWR0_LCL_ACJT_LSB)
#define RX_ENPWR0_LCL_ACJT_SET(x)                                              (((0 | (x)) << RX_ENPWR0_LCL_ACJT_LSB) & RX_ENPWR0_LCL_ACJT_MASK)
#define RX_ENPWR0_LCL_ACJT_RESET                                               0x0
#define RX_ENPWR0_ADDRESS                                                      (0x4088 + __PCIE_PHY_REG_BASE_ADDRESS)
#define RX_ENPWR0_RSTMASK                                                      0xff
#define RX_ENPWR0_RESET                                                        0x0

// 0x408c (RX_PMIX_PHASE)
#define RX_PMIX_PHASE_PHASE_LSB                                                0
#define RX_PMIX_PHASE_PHASE_MSB                                                7
#define RX_PMIX_PHASE_PHASE_MASK                                               0xff
#define RX_PMIX_PHASE_PHASE_GET(x)                                             (((x) & RX_PMIX_PHASE_PHASE_MASK) >> RX_PMIX_PHASE_PHASE_LSB)
#define RX_PMIX_PHASE_PHASE_SET(x)                                             (((0 | (x)) << RX_PMIX_PHASE_PHASE_LSB) & RX_PMIX_PHASE_PHASE_MASK)
#define RX_PMIX_PHASE_PHASE_RESET                                              0x0
#define RX_PMIX_PHASE_ADDRESS                                                  (0x408c + __PCIE_PHY_REG_BASE_ADDRESS)
#define RX_PMIX_PHASE_RSTMASK                                                  0xff
#define RX_PMIX_PHASE_RESET                                                    0x0

// 0x4090 (RX_ENPWR1)
#define RX_ENPWR1_CTL_PHASE_REG_RST_LSB                                        7
#define RX_ENPWR1_CTL_PHASE_REG_RST_MSB                                        7
#define RX_ENPWR1_CTL_PHASE_REG_RST_MASK                                       0x80
#define RX_ENPWR1_CTL_PHASE_REG_RST_GET(x)                                     (((x) & RX_ENPWR1_CTL_PHASE_REG_RST_MASK) >> RX_ENPWR1_CTL_PHASE_REG_RST_LSB)
#define RX_ENPWR1_CTL_PHASE_REG_RST_SET(x)                                     (((0 | (x)) << RX_ENPWR1_CTL_PHASE_REG_RST_LSB) & RX_ENPWR1_CTL_PHASE_REG_RST_MASK)
#define RX_ENPWR1_CTL_PHASE_REG_RST_RESET                                      0x0
#define RX_ENPWR1_LCL_PHASE_REG_RST_LSB                                        6
#define RX_ENPWR1_LCL_PHASE_REG_RST_MSB                                        6
#define RX_ENPWR1_LCL_PHASE_REG_RST_MASK                                       0x40
#define RX_ENPWR1_LCL_PHASE_REG_RST_GET(x)                                     (((x) & RX_ENPWR1_LCL_PHASE_REG_RST_MASK) >> RX_ENPWR1_LCL_PHASE_REG_RST_LSB)
#define RX_ENPWR1_LCL_PHASE_REG_RST_SET(x)                                     (((0 | (x)) << RX_ENPWR1_LCL_PHASE_REG_RST_LSB) & RX_ENPWR1_LCL_PHASE_REG_RST_MASK)
#define RX_ENPWR1_LCL_PHASE_REG_RST_RESET                                      0x0
#define RX_ENPWR1_CTL_BST_LSB                                                  5
#define RX_ENPWR1_CTL_BST_MSB                                                  5
#define RX_ENPWR1_CTL_BST_MASK                                                 0x20
#define RX_ENPWR1_CTL_BST_GET(x)                                               (((x) & RX_ENPWR1_CTL_BST_MASK) >> RX_ENPWR1_CTL_BST_LSB)
#define RX_ENPWR1_CTL_BST_SET(x)                                               (((0 | (x)) << RX_ENPWR1_CTL_BST_LSB) & RX_ENPWR1_CTL_BST_MASK)
#define RX_ENPWR1_CTL_BST_RESET                                                0x0
#define RX_ENPWR1_LCL_BST_LSB                                                  2
#define RX_ENPWR1_LCL_BST_MSB                                                  4
#define RX_ENPWR1_LCL_BST_MASK                                                 0x1c
#define RX_ENPWR1_LCL_BST_GET(x)                                               (((x) & RX_ENPWR1_LCL_BST_MASK) >> RX_ENPWR1_LCL_BST_LSB)
#define RX_ENPWR1_LCL_BST_SET(x)                                               (((0 | (x)) << RX_ENPWR1_LCL_BST_LSB) & RX_ENPWR1_LCL_BST_MASK)
#define RX_ENPWR1_LCL_BST_RESET                                                0x0
#define RX_ENPWR1_CTL_RXTERM_LSB                                               1
#define RX_ENPWR1_CTL_RXTERM_MSB                                               1
#define RX_ENPWR1_CTL_RXTERM_MASK                                              0x2
#define RX_ENPWR1_CTL_RXTERM_GET(x)                                            (((x) & RX_ENPWR1_CTL_RXTERM_MASK) >> RX_ENPWR1_CTL_RXTERM_LSB)
#define RX_ENPWR1_CTL_RXTERM_SET(x)                                            (((0 | (x)) << RX_ENPWR1_CTL_RXTERM_LSB) & RX_ENPWR1_CTL_RXTERM_MASK)
#define RX_ENPWR1_CTL_RXTERM_RESET                                             0x0
#define RX_ENPWR1_LCL_RXTERM_LSB                                               0
#define RX_ENPWR1_LCL_RXTERM_MSB                                               0
#define RX_ENPWR1_LCL_RXTERM_MASK                                              0x1
#define RX_ENPWR1_LCL_RXTERM_GET(x)                                            (((x) & RX_ENPWR1_LCL_RXTERM_MASK) >> RX_ENPWR1_LCL_RXTERM_LSB)
#define RX_ENPWR1_LCL_RXTERM_SET(x)                                            (((0 | (x)) << RX_ENPWR1_LCL_RXTERM_LSB) & RX_ENPWR1_LCL_RXTERM_MASK)
#define RX_ENPWR1_LCL_RXTERM_RESET                                             0x0
#define RX_ENPWR1_ADDRESS                                                      (0x4090 + __PCIE_PHY_REG_BASE_ADDRESS)
#define RX_ENPWR1_RSTMASK                                                      0xff
#define RX_ENPWR1_RESET                                                        0x0

// 0x4094 (RX_ENPWR2)
#define RX_ENPWR2_EN_RXPMIX_TST_LSB                                            7
#define RX_ENPWR2_EN_RXPMIX_TST_MSB                                            7
#define RX_ENPWR2_EN_RXPMIX_TST_MASK                                           0x80
#define RX_ENPWR2_EN_RXPMIX_TST_GET(x)                                         (((x) & RX_ENPWR2_EN_RXPMIX_TST_MASK) >> RX_ENPWR2_EN_RXPMIX_TST_LSB)
#define RX_ENPWR2_EN_RXPMIX_TST_SET(x)                                         (((0 | (x)) << RX_ENPWR2_EN_RXPMIX_TST_LSB) & RX_ENPWR2_EN_RXPMIX_TST_MASK)
#define RX_ENPWR2_EN_RXPMIX_TST_RESET                                          0x0
#define RX_ENPWR2_EN_RXPMIX_VPMIX_LSB                                          6
#define RX_ENPWR2_EN_RXPMIX_VPMIX_MSB                                          6
#define RX_ENPWR2_EN_RXPMIX_VPMIX_MASK                                         0x40
#define RX_ENPWR2_EN_RXPMIX_VPMIX_GET(x)                                       (((x) & RX_ENPWR2_EN_RXPMIX_VPMIX_MASK) >> RX_ENPWR2_EN_RXPMIX_VPMIX_LSB)
#define RX_ENPWR2_EN_RXPMIX_VPMIX_SET(x)                                       (((0 | (x)) << RX_ENPWR2_EN_RXPMIX_VPMIX_LSB) & RX_ENPWR2_EN_RXPMIX_VPMIX_MASK)
#define RX_ENPWR2_EN_RXPMIX_VPMIX_RESET                                        0x0
#define RX_ENPWR2_EN_RXPMIX_VRX_LSB                                            5
#define RX_ENPWR2_EN_RXPMIX_VRX_MSB                                            5
#define RX_ENPWR2_EN_RXPMIX_VRX_MASK                                           0x20
#define RX_ENPWR2_EN_RXPMIX_VRX_GET(x)                                         (((x) & RX_ENPWR2_EN_RXPMIX_VRX_MASK) >> RX_ENPWR2_EN_RXPMIX_VRX_LSB)
#define RX_ENPWR2_EN_RXPMIX_VRX_SET(x)                                         (((0 | (x)) << RX_ENPWR2_EN_RXPMIX_VRX_LSB) & RX_ENPWR2_EN_RXPMIX_VRX_MASK)
#define RX_ENPWR2_EN_RXPMIX_VRX_RESET                                          0x0
#define RX_ENPWR2_EN_RXPMIX_VOSC_LSB                                           4
#define RX_ENPWR2_EN_RXPMIX_VOSC_MSB                                           4
#define RX_ENPWR2_EN_RXPMIX_VOSC_MASK                                          0x10
#define RX_ENPWR2_EN_RXPMIX_VOSC_GET(x)                                        (((x) & RX_ENPWR2_EN_RXPMIX_VOSC_MASK) >> RX_ENPWR2_EN_RXPMIX_VOSC_LSB)
#define RX_ENPWR2_EN_RXPMIX_VOSC_SET(x)                                        (((0 | (x)) << RX_ENPWR2_EN_RXPMIX_VOSC_LSB) & RX_ENPWR2_EN_RXPMIX_VOSC_MASK)
#define RX_ENPWR2_EN_RXPMIX_VOSC_RESET                                         0x0
#define RX_ENPWR2_NC_LSB                                                       3
#define RX_ENPWR2_NC_MSB                                                       3
#define RX_ENPWR2_NC_MASK                                                      0x8
#define RX_ENPWR2_NC_GET(x)                                                    (((x) & RX_ENPWR2_NC_MASK) >> RX_ENPWR2_NC_LSB)
#define RX_ENPWR2_NC_SET(x)                                                    (((0 | (x)) << RX_ENPWR2_NC_LSB) & RX_ENPWR2_NC_MASK)
#define RX_ENPWR2_NC_RESET                                                     0x0
#define RX_ENPWR2_RX_SCOPE_ATB_2_LSB                                           2
#define RX_ENPWR2_RX_SCOPE_ATB_2_MSB                                           2
#define RX_ENPWR2_RX_SCOPE_ATB_2_MASK                                          0x4
#define RX_ENPWR2_RX_SCOPE_ATB_2_GET(x)                                        (((x) & RX_ENPWR2_RX_SCOPE_ATB_2_MASK) >> RX_ENPWR2_RX_SCOPE_ATB_2_LSB)
#define RX_ENPWR2_RX_SCOPE_ATB_2_SET(x)                                        (((0 | (x)) << RX_ENPWR2_RX_SCOPE_ATB_2_LSB) & RX_ENPWR2_RX_SCOPE_ATB_2_MASK)
#define RX_ENPWR2_RX_SCOPE_ATB_2_RESET                                         0x0
#define RX_ENPWR2_RX_SCOPE_ATB_1_LSB                                           1
#define RX_ENPWR2_RX_SCOPE_ATB_1_MSB                                           1
#define RX_ENPWR2_RX_SCOPE_ATB_1_MASK                                          0x2
#define RX_ENPWR2_RX_SCOPE_ATB_1_GET(x)                                        (((x) & RX_ENPWR2_RX_SCOPE_ATB_1_MASK) >> RX_ENPWR2_RX_SCOPE_ATB_1_LSB)
#define RX_ENPWR2_RX_SCOPE_ATB_1_SET(x)                                        (((0 | (x)) << RX_ENPWR2_RX_SCOPE_ATB_1_LSB) & RX_ENPWR2_RX_SCOPE_ATB_1_MASK)
#define RX_ENPWR2_RX_SCOPE_ATB_1_RESET                                         0x0
#define RX_ENPWR2_RX_SCOPE_ATB_0_LSB                                           0
#define RX_ENPWR2_RX_SCOPE_ATB_0_MSB                                           0
#define RX_ENPWR2_RX_SCOPE_ATB_0_MASK                                          0x1
#define RX_ENPWR2_RX_SCOPE_ATB_0_GET(x)                                        (((x) & RX_ENPWR2_RX_SCOPE_ATB_0_MASK) >> RX_ENPWR2_RX_SCOPE_ATB_0_LSB)
#define RX_ENPWR2_RX_SCOPE_ATB_0_SET(x)                                        (((0 | (x)) << RX_ENPWR2_RX_SCOPE_ATB_0_LSB) & RX_ENPWR2_RX_SCOPE_ATB_0_MASK)
#define RX_ENPWR2_RX_SCOPE_ATB_0_RESET                                         0x0
#define RX_ENPWR2_ADDRESS                                                      (0x4094 + __PCIE_PHY_REG_BASE_ADDRESS)
#define RX_ENPWR2_RSTMASK                                                      0xff
#define RX_ENPWR2_RESET                                                        0x0

// 0x4098 (RX_SCOPE_VDCC)
#define RX_SCOPE_VDCC_VDCC_LSB                                                 6
#define RX_SCOPE_VDCC_VDCC_MSB                                                 7
#define RX_SCOPE_VDCC_VDCC_MASK                                                0xc0
#define RX_SCOPE_VDCC_VDCC_GET(x)                                              (((x) & RX_SCOPE_VDCC_VDCC_MASK) >> RX_SCOPE_VDCC_VDCC_LSB)
#define RX_SCOPE_VDCC_VDCC_SET(x)                                              (((0 | (x)) << RX_SCOPE_VDCC_VDCC_LSB) & RX_SCOPE_VDCC_VDCC_MASK)
#define RX_SCOPE_VDCC_VDCC_RESET                                               0x0
#define RX_SCOPE_VDCC_NC5_LSB                                                  5
#define RX_SCOPE_VDCC_NC5_MSB                                                  5
#define RX_SCOPE_VDCC_NC5_MASK                                                 0x20
#define RX_SCOPE_VDCC_NC5_GET(x)                                               (((x) & RX_SCOPE_VDCC_NC5_MASK) >> RX_SCOPE_VDCC_NC5_LSB)
#define RX_SCOPE_VDCC_NC5_SET(x)                                               (((0 | (x)) << RX_SCOPE_VDCC_NC5_LSB) & RX_SCOPE_VDCC_NC5_MASK)
#define RX_SCOPE_VDCC_NC5_RESET                                                0x0
#define RX_SCOPE_VDCC_RX_SCOPE_SLEW_LSB                                        4
#define RX_SCOPE_VDCC_RX_SCOPE_SLEW_MSB                                        4
#define RX_SCOPE_VDCC_RX_SCOPE_SLEW_MASK                                       0x10
#define RX_SCOPE_VDCC_RX_SCOPE_SLEW_GET(x)                                     (((x) & RX_SCOPE_VDCC_RX_SCOPE_SLEW_MASK) >> RX_SCOPE_VDCC_RX_SCOPE_SLEW_LSB)
#define RX_SCOPE_VDCC_RX_SCOPE_SLEW_SET(x)                                     (((0 | (x)) << RX_SCOPE_VDCC_RX_SCOPE_SLEW_LSB) & RX_SCOPE_VDCC_RX_SCOPE_SLEW_MASK)
#define RX_SCOPE_VDCC_RX_SCOPE_SLEW_RESET                                      0x0
#define RX_SCOPE_VDCC_RX_SCOPE_FDIV20_LSB                                      3
#define RX_SCOPE_VDCC_RX_SCOPE_FDIV20_MSB                                      3
#define RX_SCOPE_VDCC_RX_SCOPE_FDIV20_MASK                                     0x8
#define RX_SCOPE_VDCC_RX_SCOPE_FDIV20_GET(x)                                   (((x) & RX_SCOPE_VDCC_RX_SCOPE_FDIV20_MASK) >> RX_SCOPE_VDCC_RX_SCOPE_FDIV20_LSB)
#define RX_SCOPE_VDCC_RX_SCOPE_FDIV20_SET(x)                                   (((0 | (x)) << RX_SCOPE_VDCC_RX_SCOPE_FDIV20_LSB) & RX_SCOPE_VDCC_RX_SCOPE_FDIV20_MASK)
#define RX_SCOPE_VDCC_RX_SCOPE_FDIV20_RESET                                    0x0
#define RX_SCOPE_VDCC_RX_NC1_LSB                                               1
#define RX_SCOPE_VDCC_RX_NC1_MSB                                               2
#define RX_SCOPE_VDCC_RX_NC1_MASK                                              0x6
#define RX_SCOPE_VDCC_RX_NC1_GET(x)                                            (((x) & RX_SCOPE_VDCC_RX_NC1_MASK) >> RX_SCOPE_VDCC_RX_NC1_LSB)
#define RX_SCOPE_VDCC_RX_NC1_SET(x)                                            (((0 | (x)) << RX_SCOPE_VDCC_RX_NC1_LSB) & RX_SCOPE_VDCC_RX_NC1_MASK)
#define RX_SCOPE_VDCC_RX_NC1_RESET                                             0x0
#define RX_SCOPE_VDCC_RX_SCOPE_LFPS_EN_LSB                                     0
#define RX_SCOPE_VDCC_RX_SCOPE_LFPS_EN_MSB                                     0
#define RX_SCOPE_VDCC_RX_SCOPE_LFPS_EN_MASK                                    0x1
#define RX_SCOPE_VDCC_RX_SCOPE_LFPS_EN_GET(x)                                  (((x) & RX_SCOPE_VDCC_RX_SCOPE_LFPS_EN_MASK) >> RX_SCOPE_VDCC_RX_SCOPE_LFPS_EN_LSB)
#define RX_SCOPE_VDCC_RX_SCOPE_LFPS_EN_SET(x)                                  (((0 | (x)) << RX_SCOPE_VDCC_RX_SCOPE_LFPS_EN_LSB) & RX_SCOPE_VDCC_RX_SCOPE_LFPS_EN_MASK)
#define RX_SCOPE_VDCC_RX_SCOPE_LFPS_EN_RESET                                   0x0
#define RX_SCOPE_VDCC_ADDRESS                                                  (0x4098 + __PCIE_PHY_REG_BASE_ADDRESS)
#define RX_SCOPE_VDCC_RSTMASK                                                  0xff
#define RX_SCOPE_VDCC_RESET                                                    0x0

// 0x40ac (TX_TXDRV_CNTRL)
#define TX_TXDRV_CNTRL_PULL_DN_REG_LSB                                         7
#define TX_TXDRV_CNTRL_PULL_DN_REG_MSB                                         7
#define TX_TXDRV_CNTRL_PULL_DN_REG_MASK                                        0x80
#define TX_TXDRV_CNTRL_PULL_DN_REG_GET(x)                                      (((x) & TX_TXDRV_CNTRL_PULL_DN_REG_MASK) >> TX_TXDRV_CNTRL_PULL_DN_REG_LSB)
#define TX_TXDRV_CNTRL_PULL_DN_REG_SET(x)                                      (((0 | (x)) << TX_TXDRV_CNTRL_PULL_DN_REG_LSB) & TX_TXDRV_CNTRL_PULL_DN_REG_MASK)
#define TX_TXDRV_CNTRL_PULL_DN_REG_RESET                                       0x0
#define TX_TXDRV_CNTRL_PULL_UP_REG_LSB                                         6
#define TX_TXDRV_CNTRL_PULL_UP_REG_MSB                                         6
#define TX_TXDRV_CNTRL_PULL_UP_REG_MASK                                        0x40
#define TX_TXDRV_CNTRL_PULL_UP_REG_GET(x)                                      (((x) & TX_TXDRV_CNTRL_PULL_UP_REG_MASK) >> TX_TXDRV_CNTRL_PULL_UP_REG_LSB)
#define TX_TXDRV_CNTRL_PULL_UP_REG_SET(x)                                      (((0 | (x)) << TX_TXDRV_CNTRL_PULL_UP_REG_LSB) & TX_TXDRV_CNTRL_PULL_UP_REG_MASK)
#define TX_TXDRV_CNTRL_PULL_UP_REG_RESET                                       0x0
#define TX_TXDRV_CNTRL_OVRD_PULL_UP_LSB                                        5
#define TX_TXDRV_CNTRL_OVRD_PULL_UP_MSB                                        5
#define TX_TXDRV_CNTRL_OVRD_PULL_UP_MASK                                       0x20
#define TX_TXDRV_CNTRL_OVRD_PULL_UP_GET(x)                                     (((x) & TX_TXDRV_CNTRL_OVRD_PULL_UP_MASK) >> TX_TXDRV_CNTRL_OVRD_PULL_UP_LSB)
#define TX_TXDRV_CNTRL_OVRD_PULL_UP_SET(x)                                     (((0 | (x)) << TX_TXDRV_CNTRL_OVRD_PULL_UP_LSB) & TX_TXDRV_CNTRL_OVRD_PULL_UP_MASK)
#define TX_TXDRV_CNTRL_OVRD_PULL_UP_RESET                                      0x0
#define TX_TXDRV_CNTRL_VCM_HOLD_REG_LSB                                        4
#define TX_TXDRV_CNTRL_VCM_HOLD_REG_MSB                                        4
#define TX_TXDRV_CNTRL_VCM_HOLD_REG_MASK                                       0x10
#define TX_TXDRV_CNTRL_VCM_HOLD_REG_GET(x)                                     (((x) & TX_TXDRV_CNTRL_VCM_HOLD_REG_MASK) >> TX_TXDRV_CNTRL_VCM_HOLD_REG_LSB)
#define TX_TXDRV_CNTRL_VCM_HOLD_REG_SET(x)                                     (((0 | (x)) << TX_TXDRV_CNTRL_VCM_HOLD_REG_LSB) & TX_TXDRV_CNTRL_VCM_HOLD_REG_MASK)
#define TX_TXDRV_CNTRL_VCM_HOLD_REG_RESET                                      0x0
#define TX_TXDRV_CNTRL_OVRD_VCM_HOLD_LSB                                       3
#define TX_TXDRV_CNTRL_OVRD_VCM_HOLD_MSB                                       3
#define TX_TXDRV_CNTRL_OVRD_VCM_HOLD_MASK                                      0x8
#define TX_TXDRV_CNTRL_OVRD_VCM_HOLD_GET(x)                                    (((x) & TX_TXDRV_CNTRL_OVRD_VCM_HOLD_MASK) >> TX_TXDRV_CNTRL_OVRD_VCM_HOLD_LSB)
#define TX_TXDRV_CNTRL_OVRD_VCM_HOLD_SET(x)                                    (((0 | (x)) << TX_TXDRV_CNTRL_OVRD_VCM_HOLD_LSB) & TX_TXDRV_CNTRL_OVRD_VCM_HOLD_MASK)
#define TX_TXDRV_CNTRL_OVRD_VCM_HOLD_RESET                                     0x0
#define TX_TXDRV_CNTRL_NOCONN_8_LSB                                            2
#define TX_TXDRV_CNTRL_NOCONN_8_MSB                                            2
#define TX_TXDRV_CNTRL_NOCONN_8_MASK                                           0x4
#define TX_TXDRV_CNTRL_NOCONN_8_GET(x)                                         (((x) & TX_TXDRV_CNTRL_NOCONN_8_MASK) >> TX_TXDRV_CNTRL_NOCONN_8_LSB)
#define TX_TXDRV_CNTRL_NOCONN_8_SET(x)                                         (((0 | (x)) << TX_TXDRV_CNTRL_NOCONN_8_LSB) & TX_TXDRV_CNTRL_NOCONN_8_MASK)
#define TX_TXDRV_CNTRL_NOCONN_8_RESET                                          0x1
#define TX_TXDRV_CNTRL_NOCONN_7_LSB                                            1
#define TX_TXDRV_CNTRL_NOCONN_7_MSB                                            1
#define TX_TXDRV_CNTRL_NOCONN_7_MASK                                           0x2
#define TX_TXDRV_CNTRL_NOCONN_7_GET(x)                                         (((x) & TX_TXDRV_CNTRL_NOCONN_7_MASK) >> TX_TXDRV_CNTRL_NOCONN_7_LSB)
#define TX_TXDRV_CNTRL_NOCONN_7_SET(x)                                         (((0 | (x)) << TX_TXDRV_CNTRL_NOCONN_7_LSB) & TX_TXDRV_CNTRL_NOCONN_7_MASK)
#define TX_TXDRV_CNTRL_NOCONN_7_RESET                                          0x0
#define TX_TXDRV_CNTRL_NOCONN_6_LSB                                            0
#define TX_TXDRV_CNTRL_NOCONN_6_MSB                                            0
#define TX_TXDRV_CNTRL_NOCONN_6_MASK                                           0x1
#define TX_TXDRV_CNTRL_NOCONN_6_GET(x)                                         (((x) & TX_TXDRV_CNTRL_NOCONN_6_MASK) >> TX_TXDRV_CNTRL_NOCONN_6_LSB)
#define TX_TXDRV_CNTRL_NOCONN_6_SET(x)                                         (((0 | (x)) << TX_TXDRV_CNTRL_NOCONN_6_LSB) & TX_TXDRV_CNTRL_NOCONN_6_MASK)
#define TX_TXDRV_CNTRL_NOCONN_6_RESET                                          0x0
#define TX_TXDRV_CNTRL_ADDRESS                                                 (0x40ac + __PCIE_PHY_REG_BASE_ADDRESS)
#define TX_TXDRV_CNTRL_RSTMASK                                                 0xff
#define TX_TXDRV_CNTRL_RESET                                                   0x4

// 0x40b0 (TX_POWER_CTL)
#define TX_POWER_CTL_OVRD_EN_LSB                                               7
#define TX_POWER_CTL_OVRD_EN_MSB                                               7
#define TX_POWER_CTL_OVRD_EN_MASK                                              0x80
#define TX_POWER_CTL_OVRD_EN_GET(x)                                            (((x) & TX_POWER_CTL_OVRD_EN_MASK) >> TX_POWER_CTL_OVRD_EN_LSB)
#define TX_POWER_CTL_OVRD_EN_SET(x)                                            (((0 | (x)) << TX_POWER_CTL_OVRD_EN_LSB) & TX_POWER_CTL_OVRD_EN_MASK)
#define TX_POWER_CTL_OVRD_EN_RESET                                             0x0
#define TX_POWER_CTL_SERIAL_EN_REG_LSB                                         6
#define TX_POWER_CTL_SERIAL_EN_REG_MSB                                         6
#define TX_POWER_CTL_SERIAL_EN_REG_MASK                                        0x40
#define TX_POWER_CTL_SERIAL_EN_REG_GET(x)                                      (((x) & TX_POWER_CTL_SERIAL_EN_REG_MASK) >> TX_POWER_CTL_SERIAL_EN_REG_LSB)
#define TX_POWER_CTL_SERIAL_EN_REG_SET(x)                                      (((0 | (x)) << TX_POWER_CTL_SERIAL_EN_REG_LSB) & TX_POWER_CTL_SERIAL_EN_REG_MASK)
#define TX_POWER_CTL_SERIAL_EN_REG_RESET                                       0x0
#define TX_POWER_CTL_CLK_EN_REG_LSB                                            5
#define TX_POWER_CTL_CLK_EN_REG_MSB                                            5
#define TX_POWER_CTL_CLK_EN_REG_MASK                                           0x20
#define TX_POWER_CTL_CLK_EN_REG_GET(x)                                         (((x) & TX_POWER_CTL_CLK_EN_REG_MASK) >> TX_POWER_CTL_CLK_EN_REG_LSB)
#define TX_POWER_CTL_CLK_EN_REG_SET(x)                                         (((0 | (x)) << TX_POWER_CTL_CLK_EN_REG_LSB) & TX_POWER_CTL_CLK_EN_REG_MASK)
#define TX_POWER_CTL_CLK_EN_REG_RESET                                          0x0
#define TX_POWER_CTL_DATA_EN_REG_LSB                                           4
#define TX_POWER_CTL_DATA_EN_REG_MSB                                           4
#define TX_POWER_CTL_DATA_EN_REG_MASK                                          0x10
#define TX_POWER_CTL_DATA_EN_REG_GET(x)                                        (((x) & TX_POWER_CTL_DATA_EN_REG_MASK) >> TX_POWER_CTL_DATA_EN_REG_LSB)
#define TX_POWER_CTL_DATA_EN_REG_SET(x)                                        (((0 | (x)) << TX_POWER_CTL_DATA_EN_REG_LSB) & TX_POWER_CTL_DATA_EN_REG_MASK)
#define TX_POWER_CTL_DATA_EN_REG_RESET                                         0x0
#define TX_POWER_CTL_REFGEN_EN_REG_LSB                                         3
#define TX_POWER_CTL_REFGEN_EN_REG_MSB                                         3
#define TX_POWER_CTL_REFGEN_EN_REG_MASK                                        0x8
#define TX_POWER_CTL_REFGEN_EN_REG_GET(x)                                      (((x) & TX_POWER_CTL_REFGEN_EN_REG_MASK) >> TX_POWER_CTL_REFGEN_EN_REG_LSB)
#define TX_POWER_CTL_REFGEN_EN_REG_SET(x)                                      (((0 | (x)) << TX_POWER_CTL_REFGEN_EN_REG_LSB) & TX_POWER_CTL_REFGEN_EN_REG_MASK)
#define TX_POWER_CTL_REFGEN_EN_REG_RESET                                       0x0
#define TX_POWER_CTL_TX_DIV_CLK_EN_LSB                                         2
#define TX_POWER_CTL_TX_DIV_CLK_EN_MSB                                         2
#define TX_POWER_CTL_TX_DIV_CLK_EN_MASK                                        0x4
#define TX_POWER_CTL_TX_DIV_CLK_EN_GET(x)                                      (((x) & TX_POWER_CTL_TX_DIV_CLK_EN_MASK) >> TX_POWER_CTL_TX_DIV_CLK_EN_LSB)
#define TX_POWER_CTL_TX_DIV_CLK_EN_SET(x)                                      (((0 | (x)) << TX_POWER_CTL_TX_DIV_CLK_EN_LSB) & TX_POWER_CTL_TX_DIV_CLK_EN_MASK)
#define TX_POWER_CTL_TX_DIV_CLK_EN_RESET                                       0x0
#define TX_POWER_CTL_REFGEN_PDN_REG_LSB                                        1
#define TX_POWER_CTL_REFGEN_PDN_REG_MSB                                        1
#define TX_POWER_CTL_REFGEN_PDN_REG_MASK                                       0x2
#define TX_POWER_CTL_REFGEN_PDN_REG_GET(x)                                     (((x) & TX_POWER_CTL_REFGEN_PDN_REG_MASK) >> TX_POWER_CTL_REFGEN_PDN_REG_LSB)
#define TX_POWER_CTL_REFGEN_PDN_REG_SET(x)                                     (((0 | (x)) << TX_POWER_CTL_REFGEN_PDN_REG_LSB) & TX_POWER_CTL_REFGEN_PDN_REG_MASK)
#define TX_POWER_CTL_REFGEN_PDN_REG_RESET                                      0x0
#define TX_POWER_CTL_LFPS_HIGH_PRIORITY_LSB                                    0
#define TX_POWER_CTL_LFPS_HIGH_PRIORITY_MSB                                    0
#define TX_POWER_CTL_LFPS_HIGH_PRIORITY_MASK                                   0x1
#define TX_POWER_CTL_LFPS_HIGH_PRIORITY_GET(x)                                 (((x) & TX_POWER_CTL_LFPS_HIGH_PRIORITY_MASK) >> TX_POWER_CTL_LFPS_HIGH_PRIORITY_LSB)
#define TX_POWER_CTL_LFPS_HIGH_PRIORITY_SET(x)                                 (((0 | (x)) << TX_POWER_CTL_LFPS_HIGH_PRIORITY_LSB) & TX_POWER_CTL_LFPS_HIGH_PRIORITY_MASK)
#define TX_POWER_CTL_LFPS_HIGH_PRIORITY_RESET                                  0x0
#define TX_POWER_CTL_ADDRESS                                                   (0x40b0 + __PCIE_PHY_REG_BASE_ADDRESS)
#define TX_POWER_CTL_RSTMASK                                                   0xff
#define TX_POWER_CTL_RESET                                                     0x0

// 0x40b4 (TX_ALT_BLOCK)
#define TX_ALT_BLOCK_EN_ALT_BUS_LSB                                            7
#define TX_ALT_BLOCK_EN_ALT_BUS_MSB                                            7
#define TX_ALT_BLOCK_EN_ALT_BUS_MASK                                           0x80
#define TX_ALT_BLOCK_EN_ALT_BUS_GET(x)                                         (((x) & TX_ALT_BLOCK_EN_ALT_BUS_MASK) >> TX_ALT_BLOCK_EN_ALT_BUS_LSB)
#define TX_ALT_BLOCK_EN_ALT_BUS_SET(x)                                         (((0 | (x)) << TX_ALT_BLOCK_EN_ALT_BUS_LSB) & TX_ALT_BLOCK_EN_ALT_BUS_MASK)
#define TX_ALT_BLOCK_EN_ALT_BUS_RESET                                          0x0
#define TX_ALT_BLOCK_DRV_SOURCE_REG_LSB                                        5
#define TX_ALT_BLOCK_DRV_SOURCE_REG_MSB                                        6
#define TX_ALT_BLOCK_DRV_SOURCE_REG_MASK                                       0x60
#define TX_ALT_BLOCK_DRV_SOURCE_REG_GET(x)                                     (((x) & TX_ALT_BLOCK_DRV_SOURCE_REG_MASK) >> TX_ALT_BLOCK_DRV_SOURCE_REG_LSB)
#define TX_ALT_BLOCK_DRV_SOURCE_REG_SET(x)                                     (((0 | (x)) << TX_ALT_BLOCK_DRV_SOURCE_REG_LSB) & TX_ALT_BLOCK_DRV_SOURCE_REG_MASK)
#define TX_ALT_BLOCK_DRV_SOURCE_REG_RESET                                      0x0
#define TX_ALT_BLOCK_JTAG_DATA_REG_LSB                                         4
#define TX_ALT_BLOCK_JTAG_DATA_REG_MSB                                         4
#define TX_ALT_BLOCK_JTAG_DATA_REG_MASK                                        0x10
#define TX_ALT_BLOCK_JTAG_DATA_REG_GET(x)                                      (((x) & TX_ALT_BLOCK_JTAG_DATA_REG_MASK) >> TX_ALT_BLOCK_JTAG_DATA_REG_LSB)
#define TX_ALT_BLOCK_JTAG_DATA_REG_SET(x)                                      (((0 | (x)) << TX_ALT_BLOCK_JTAG_DATA_REG_LSB) & TX_ALT_BLOCK_JTAG_DATA_REG_MASK)
#define TX_ALT_BLOCK_JTAG_DATA_REG_RESET                                       0x0
#define TX_ALT_BLOCK_ALT_OSC_VP_LSB                                            3
#define TX_ALT_BLOCK_ALT_OSC_VP_MSB                                            3
#define TX_ALT_BLOCK_ALT_OSC_VP_MASK                                           0x8
#define TX_ALT_BLOCK_ALT_OSC_VP_GET(x)                                         (((x) & TX_ALT_BLOCK_ALT_OSC_VP_MASK) >> TX_ALT_BLOCK_ALT_OSC_VP_LSB)
#define TX_ALT_BLOCK_ALT_OSC_VP_SET(x)                                         (((0 | (x)) << TX_ALT_BLOCK_ALT_OSC_VP_LSB) & TX_ALT_BLOCK_ALT_OSC_VP_MASK)
#define TX_ALT_BLOCK_ALT_OSC_VP_RESET                                          0x0
#define TX_ALT_BLOCK_ALT_OSC_VPTX_LSB                                          2
#define TX_ALT_BLOCK_ALT_OSC_VPTX_MSB                                          2
#define TX_ALT_BLOCK_ALT_OSC_VPTX_MASK                                         0x4
#define TX_ALT_BLOCK_ALT_OSC_VPTX_GET(x)                                       (((x) & TX_ALT_BLOCK_ALT_OSC_VPTX_MASK) >> TX_ALT_BLOCK_ALT_OSC_VPTX_LSB)
#define TX_ALT_BLOCK_ALT_OSC_VPTX_SET(x)                                       (((0 | (x)) << TX_ALT_BLOCK_ALT_OSC_VPTX_LSB) & TX_ALT_BLOCK_ALT_OSC_VPTX_MASK)
#define TX_ALT_BLOCK_ALT_OSC_VPTX_RESET                                        0x0
#define TX_ALT_BLOCK_ALT_OSC_VPHREG_LSB                                        1
#define TX_ALT_BLOCK_ALT_OSC_VPHREG_MSB                                        1
#define TX_ALT_BLOCK_ALT_OSC_VPHREG_MASK                                       0x2
#define TX_ALT_BLOCK_ALT_OSC_VPHREG_GET(x)                                     (((x) & TX_ALT_BLOCK_ALT_OSC_VPHREG_MASK) >> TX_ALT_BLOCK_ALT_OSC_VPHREG_LSB)
#define TX_ALT_BLOCK_ALT_OSC_VPHREG_SET(x)                                     (((0 | (x)) << TX_ALT_BLOCK_ALT_OSC_VPHREG_LSB) & TX_ALT_BLOCK_ALT_OSC_VPHREG_MASK)
#define TX_ALT_BLOCK_ALT_OSC_VPHREG_RESET                                      0x0
#define TX_ALT_BLOCK_OVRD_ALT_BUS_LSB                                          0
#define TX_ALT_BLOCK_OVRD_ALT_BUS_MSB                                          0
#define TX_ALT_BLOCK_OVRD_ALT_BUS_MASK                                         0x1
#define TX_ALT_BLOCK_OVRD_ALT_BUS_GET(x)                                       (((x) & TX_ALT_BLOCK_OVRD_ALT_BUS_MASK) >> TX_ALT_BLOCK_OVRD_ALT_BUS_LSB)
#define TX_ALT_BLOCK_OVRD_ALT_BUS_SET(x)                                       (((0 | (x)) << TX_ALT_BLOCK_OVRD_ALT_BUS_LSB) & TX_ALT_BLOCK_OVRD_ALT_BUS_MASK)
#define TX_ALT_BLOCK_OVRD_ALT_BUS_RESET                                        0x0
#define TX_ALT_BLOCK_ADDRESS                                                   (0x40b4 + __PCIE_PHY_REG_BASE_ADDRESS)
#define TX_ALT_BLOCK_RSTMASK                                                   0xff
#define TX_ALT_BLOCK_RESET                                                     0x0

// 0x40b8 (TX_ALT_AND_LOOPBACK)
#define TX_ALT_AND_LOOPBACK_OVRD_TX_LB_LSB                                     7
#define TX_ALT_AND_LOOPBACK_OVRD_TX_LB_MSB                                     7
#define TX_ALT_AND_LOOPBACK_OVRD_TX_LB_MASK                                    0x80
#define TX_ALT_AND_LOOPBACK_OVRD_TX_LB_GET(x)                                  (((x) & TX_ALT_AND_LOOPBACK_OVRD_TX_LB_MASK) >> TX_ALT_AND_LOOPBACK_OVRD_TX_LB_LSB)
#define TX_ALT_AND_LOOPBACK_OVRD_TX_LB_SET(x)                                  (((0 | (x)) << TX_ALT_AND_LOOPBACK_OVRD_TX_LB_LSB) & TX_ALT_AND_LOOPBACK_OVRD_TX_LB_MASK)
#define TX_ALT_AND_LOOPBACK_OVRD_TX_LB_RESET                                   0x0
#define TX_ALT_AND_LOOPBACK_TX_LB_EN_REG_LSB                                   6
#define TX_ALT_AND_LOOPBACK_TX_LB_EN_REG_MSB                                   6
#define TX_ALT_AND_LOOPBACK_TX_LB_EN_REG_MASK                                  0x40
#define TX_ALT_AND_LOOPBACK_TX_LB_EN_REG_GET(x)                                (((x) & TX_ALT_AND_LOOPBACK_TX_LB_EN_REG_MASK) >> TX_ALT_AND_LOOPBACK_TX_LB_EN_REG_LSB)
#define TX_ALT_AND_LOOPBACK_TX_LB_EN_REG_SET(x)                                (((0 | (x)) << TX_ALT_AND_LOOPBACK_TX_LB_EN_REG_LSB) & TX_ALT_AND_LOOPBACK_TX_LB_EN_REG_MASK)
#define TX_ALT_AND_LOOPBACK_TX_LB_EN_REG_RESET                                 0x0
#define TX_ALT_AND_LOOPBACK_ATB_VPTX_LSB                                       5
#define TX_ALT_AND_LOOPBACK_ATB_VPTX_MSB                                       5
#define TX_ALT_AND_LOOPBACK_ATB_VPTX_MASK                                      0x20
#define TX_ALT_AND_LOOPBACK_ATB_VPTX_GET(x)                                    (((x) & TX_ALT_AND_LOOPBACK_ATB_VPTX_MASK) >> TX_ALT_AND_LOOPBACK_ATB_VPTX_LSB)
#define TX_ALT_AND_LOOPBACK_ATB_VPTX_SET(x)                                    (((0 | (x)) << TX_ALT_AND_LOOPBACK_ATB_VPTX_LSB) & TX_ALT_AND_LOOPBACK_ATB_VPTX_MASK)
#define TX_ALT_AND_LOOPBACK_ATB_VPTX_RESET                                     0x0
#define TX_ALT_AND_LOOPBACK_ATB_VREG_TX_LSB                                    4
#define TX_ALT_AND_LOOPBACK_ATB_VREG_TX_MSB                                    4
#define TX_ALT_AND_LOOPBACK_ATB_VREG_TX_MASK                                   0x10
#define TX_ALT_AND_LOOPBACK_ATB_VREG_TX_GET(x)                                 (((x) & TX_ALT_AND_LOOPBACK_ATB_VREG_TX_MASK) >> TX_ALT_AND_LOOPBACK_ATB_VREG_TX_LSB)
#define TX_ALT_AND_LOOPBACK_ATB_VREG_TX_SET(x)                                 (((0 | (x)) << TX_ALT_AND_LOOPBACK_ATB_VREG_TX_LSB) & TX_ALT_AND_LOOPBACK_ATB_VREG_TX_MASK)
#define TX_ALT_AND_LOOPBACK_ATB_VREG_TX_RESET                                  0x0
#define TX_ALT_AND_LOOPBACK_ATB_VDCCP_LSB                                      3
#define TX_ALT_AND_LOOPBACK_ATB_VDCCP_MSB                                      3
#define TX_ALT_AND_LOOPBACK_ATB_VDCCP_MASK                                     0x8
#define TX_ALT_AND_LOOPBACK_ATB_VDCCP_GET(x)                                   (((x) & TX_ALT_AND_LOOPBACK_ATB_VDCCP_MASK) >> TX_ALT_AND_LOOPBACK_ATB_VDCCP_LSB)
#define TX_ALT_AND_LOOPBACK_ATB_VDCCP_SET(x)                                   (((0 | (x)) << TX_ALT_AND_LOOPBACK_ATB_VDCCP_LSB) & TX_ALT_AND_LOOPBACK_ATB_VDCCP_MASK)
#define TX_ALT_AND_LOOPBACK_ATB_VDCCP_RESET                                    0x0
#define TX_ALT_AND_LOOPBACK_ATB_VDCCM_LSB                                      2
#define TX_ALT_AND_LOOPBACK_ATB_VDCCM_MSB                                      2
#define TX_ALT_AND_LOOPBACK_ATB_VDCCM_MASK                                     0x4
#define TX_ALT_AND_LOOPBACK_ATB_VDCCM_GET(x)                                   (((x) & TX_ALT_AND_LOOPBACK_ATB_VDCCM_MASK) >> TX_ALT_AND_LOOPBACK_ATB_VDCCM_LSB)
#define TX_ALT_AND_LOOPBACK_ATB_VDCCM_SET(x)                                   (((0 | (x)) << TX_ALT_AND_LOOPBACK_ATB_VDCCM_LSB) & TX_ALT_AND_LOOPBACK_ATB_VDCCM_MASK)
#define TX_ALT_AND_LOOPBACK_ATB_VDCCM_RESET                                    0x0
#define TX_ALT_AND_LOOPBACK_NOCONN_01_LSB                                      1
#define TX_ALT_AND_LOOPBACK_NOCONN_01_MSB                                      1
#define TX_ALT_AND_LOOPBACK_NOCONN_01_MASK                                     0x2
#define TX_ALT_AND_LOOPBACK_NOCONN_01_GET(x)                                   (((x) & TX_ALT_AND_LOOPBACK_NOCONN_01_MASK) >> TX_ALT_AND_LOOPBACK_NOCONN_01_LSB)
#define TX_ALT_AND_LOOPBACK_NOCONN_01_SET(x)                                   (((0 | (x)) << TX_ALT_AND_LOOPBACK_NOCONN_01_LSB) & TX_ALT_AND_LOOPBACK_NOCONN_01_MASK)
#define TX_ALT_AND_LOOPBACK_NOCONN_01_RESET                                    0x0
#define TX_ALT_AND_LOOPBACK_SELECT_PMIX_CLK_LSB                                0
#define TX_ALT_AND_LOOPBACK_SELECT_PMIX_CLK_MSB                                0
#define TX_ALT_AND_LOOPBACK_SELECT_PMIX_CLK_MASK                               0x1
#define TX_ALT_AND_LOOPBACK_SELECT_PMIX_CLK_GET(x)                             (((x) & TX_ALT_AND_LOOPBACK_SELECT_PMIX_CLK_MASK) >> TX_ALT_AND_LOOPBACK_SELECT_PMIX_CLK_LSB)
#define TX_ALT_AND_LOOPBACK_SELECT_PMIX_CLK_SET(x)                             (((0 | (x)) << TX_ALT_AND_LOOPBACK_SELECT_PMIX_CLK_LSB) & TX_ALT_AND_LOOPBACK_SELECT_PMIX_CLK_MASK)
#define TX_ALT_AND_LOOPBACK_SELECT_PMIX_CLK_RESET                              0x0
#define TX_ALT_AND_LOOPBACK_ADDRESS                                            (0x40b8 + __PCIE_PHY_REG_BASE_ADDRESS)
#define TX_ALT_AND_LOOPBACK_RSTMASK                                            0xff
#define TX_ALT_AND_LOOPBACK_RESET                                              0x0

// 0x40bc (TX_TX_ATB_REG)
#define TX_TX_ATB_REG_ATB_PBIAS_LSB                                            7
#define TX_TX_ATB_REG_ATB_PBIAS_MSB                                            7
#define TX_TX_ATB_REG_ATB_PBIAS_MASK                                           0x80
#define TX_TX_ATB_REG_ATB_PBIAS_GET(x)                                         (((x) & TX_TX_ATB_REG_ATB_PBIAS_MASK) >> TX_TX_ATB_REG_ATB_PBIAS_LSB)
#define TX_TX_ATB_REG_ATB_PBIAS_SET(x)                                         (((0 | (x)) << TX_TX_ATB_REG_ATB_PBIAS_LSB) & TX_TX_ATB_REG_ATB_PBIAS_MASK)
#define TX_TX_ATB_REG_ATB_PBIAS_RESET                                          0x0
#define TX_TX_ATB_REG_ATB_VCM_REP_LSB                                          6
#define TX_TX_ATB_REG_ATB_VCM_REP_MSB                                          6
#define TX_TX_ATB_REG_ATB_VCM_REP_MASK                                         0x40
#define TX_TX_ATB_REG_ATB_VCM_REP_GET(x)                                       (((x) & TX_TX_ATB_REG_ATB_VCM_REP_MASK) >> TX_TX_ATB_REG_ATB_VCM_REP_LSB)
#define TX_TX_ATB_REG_ATB_VCM_REP_SET(x)                                       (((0 | (x)) << TX_TX_ATB_REG_ATB_VCM_REP_LSB) & TX_TX_ATB_REG_ATB_VCM_REP_MASK)
#define TX_TX_ATB_REG_ATB_VCM_REP_RESET                                        0x0
#define TX_TX_ATB_REG_ATB_RXDETREF_LSB                                         5
#define TX_TX_ATB_REG_ATB_RXDETREF_MSB                                         5
#define TX_TX_ATB_REG_ATB_RXDETREF_MASK                                        0x20
#define TX_TX_ATB_REG_ATB_RXDETREF_GET(x)                                      (((x) & TX_TX_ATB_REG_ATB_RXDETREF_MASK) >> TX_TX_ATB_REG_ATB_RXDETREF_LSB)
#define TX_TX_ATB_REG_ATB_RXDETREF_SET(x)                                      (((0 | (x)) << TX_TX_ATB_REG_ATB_RXDETREF_LSB) & TX_TX_ATB_REG_ATB_RXDETREF_MASK)
#define TX_TX_ATB_REG_ATB_RXDETREF_RESET                                       0x0
#define TX_TX_ATB_REG_ATB_TXFP_LSB                                             4
#define TX_TX_ATB_REG_ATB_TXFP_MSB                                             4
#define TX_TX_ATB_REG_ATB_TXFP_MASK                                            0x10
#define TX_TX_ATB_REG_ATB_TXFP_GET(x)                                          (((x) & TX_TX_ATB_REG_ATB_TXFP_MASK) >> TX_TX_ATB_REG_ATB_TXFP_LSB)
#define TX_TX_ATB_REG_ATB_TXFP_SET(x)                                          (((0 | (x)) << TX_TX_ATB_REG_ATB_TXFP_LSB) & TX_TX_ATB_REG_ATB_TXFP_MASK)
#define TX_TX_ATB_REG_ATB_TXFP_RESET                                           0x0
#define TX_TX_ATB_REG_ATB_TXFM_LSB                                             3
#define TX_TX_ATB_REG_ATB_TXFM_MSB                                             3
#define TX_TX_ATB_REG_ATB_TXFM_MASK                                            0x8
#define TX_TX_ATB_REG_ATB_TXFM_GET(x)                                          (((x) & TX_TX_ATB_REG_ATB_TXFM_MASK) >> TX_TX_ATB_REG_ATB_TXFM_LSB)
#define TX_TX_ATB_REG_ATB_TXFM_SET(x)                                          (((0 | (x)) << TX_TX_ATB_REG_ATB_TXFM_LSB) & TX_TX_ATB_REG_ATB_TXFM_MASK)
#define TX_TX_ATB_REG_ATB_TXFM_RESET                                           0x0
#define TX_TX_ATB_REG_ATB_TXSP_LSB                                             2
#define TX_TX_ATB_REG_ATB_TXSP_MSB                                             2
#define TX_TX_ATB_REG_ATB_TXSP_MASK                                            0x4
#define TX_TX_ATB_REG_ATB_TXSP_GET(x)                                          (((x) & TX_TX_ATB_REG_ATB_TXSP_MASK) >> TX_TX_ATB_REG_ATB_TXSP_LSB)
#define TX_TX_ATB_REG_ATB_TXSP_SET(x)                                          (((0 | (x)) << TX_TX_ATB_REG_ATB_TXSP_LSB) & TX_TX_ATB_REG_ATB_TXSP_MASK)
#define TX_TX_ATB_REG_ATB_TXSP_RESET                                           0x0
#define TX_TX_ATB_REG_ATB_TXSM_LSB                                             1
#define TX_TX_ATB_REG_ATB_TXSM_MSB                                             1
#define TX_TX_ATB_REG_ATB_TXSM_MASK                                            0x2
#define TX_TX_ATB_REG_ATB_TXSM_GET(x)                                          (((x) & TX_TX_ATB_REG_ATB_TXSM_MASK) >> TX_TX_ATB_REG_ATB_TXSM_LSB)
#define TX_TX_ATB_REG_ATB_TXSM_SET(x)                                          (((0 | (x)) << TX_TX_ATB_REG_ATB_TXSM_LSB) & TX_TX_ATB_REG_ATB_TXSM_MASK)
#define TX_TX_ATB_REG_ATB_TXSM_RESET                                           0x0
#define TX_TX_ATB_REG_ATB_VCM_LSB                                              0
#define TX_TX_ATB_REG_ATB_VCM_MSB                                              0
#define TX_TX_ATB_REG_ATB_VCM_MASK                                             0x1
#define TX_TX_ATB_REG_ATB_VCM_GET(x)                                           (((x) & TX_TX_ATB_REG_ATB_VCM_MASK) >> TX_TX_ATB_REG_ATB_VCM_LSB)
#define TX_TX_ATB_REG_ATB_VCM_SET(x)                                           (((0 | (x)) << TX_TX_ATB_REG_ATB_VCM_LSB) & TX_TX_ATB_REG_ATB_VCM_MASK)
#define TX_TX_ATB_REG_ATB_VCM_RESET                                            0x0
#define TX_TX_ATB_REG_ADDRESS                                                  (0x40bc + __PCIE_PHY_REG_BASE_ADDRESS)
#define TX_TX_ATB_REG_RSTMASK                                                  0xff
#define TX_TX_ATB_REG_RESET                                                    0x0



#endif /* _PCIE_PHY_REG_H_ */
