//
// -----------------------------------------------------------------------------
// Copyright (c) 2011-2014 Qualcomm Atheros, Inc.  All rights reserved.
// -----------------------------------------------------------------------------
// FILE         : mac_rxpcu_reg.h
// DESCRIPTION  : Software Header File for WiFi 2.5
// THIS FILE IS AUTOMATICALLY GENERATED BY DENALI BLUEPRINT, DO NOT EDIT
// -----------------------------------------------------------------------------
//

#ifndef _MAC_RXPCU_REG_H_
#define _MAC_RXPCU_REG_H_


#ifndef __MAC_RXPCU_REG_BASE_ADDRESS
#define __MAC_RXPCU_REG_BASE_ADDRESS (0x32000)
#endif


// 0x0 (RXPCU_BSSID2_L32)
#define RXPCU_BSSID2_L32_ADDR_LSB                                              0
#define RXPCU_BSSID2_L32_ADDR_MSB                                              31
#define RXPCU_BSSID2_L32_ADDR_MASK                                             0xffffffff
#define RXPCU_BSSID2_L32_ADDR_GET(x)                                           (((x) & RXPCU_BSSID2_L32_ADDR_MASK) >> RXPCU_BSSID2_L32_ADDR_LSB)
#define RXPCU_BSSID2_L32_ADDR_SET(x)                                           (((0 | (x)) << RXPCU_BSSID2_L32_ADDR_LSB) & RXPCU_BSSID2_L32_ADDR_MASK)
#define RXPCU_BSSID2_L32_ADDR_RESET                                            0x0
#define RXPCU_BSSID2_L32_ADDRESS                                               (0x0 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_BSSID2_L32_RSTMASK                                               0xffffffff
#define RXPCU_BSSID2_L32_RESET                                                 0x0

// 0x4 (RXPCU_BSSID2_U16)
#define RXPCU_BSSID2_U16_AID_LSB                                               20
#define RXPCU_BSSID2_U16_AID_MSB                                               30
#define RXPCU_BSSID2_U16_AID_MASK                                              0x7ff00000
#define RXPCU_BSSID2_U16_AID_GET(x)                                            (((x) & RXPCU_BSSID2_U16_AID_MASK) >> RXPCU_BSSID2_U16_AID_LSB)
#define RXPCU_BSSID2_U16_AID_SET(x)                                            (((0 | (x)) << RXPCU_BSSID2_U16_AID_LSB) & RXPCU_BSSID2_U16_AID_MASK)
#define RXPCU_BSSID2_U16_AID_RESET                                             0x0
#define RXPCU_BSSID2_U16_ENABLE_LSB                                            16
#define RXPCU_BSSID2_U16_ENABLE_MSB                                            16
#define RXPCU_BSSID2_U16_ENABLE_MASK                                           0x10000
#define RXPCU_BSSID2_U16_ENABLE_GET(x)                                         (((x) & RXPCU_BSSID2_U16_ENABLE_MASK) >> RXPCU_BSSID2_U16_ENABLE_LSB)
#define RXPCU_BSSID2_U16_ENABLE_SET(x)                                         (((0 | (x)) << RXPCU_BSSID2_U16_ENABLE_LSB) & RXPCU_BSSID2_U16_ENABLE_MASK)
#define RXPCU_BSSID2_U16_ENABLE_RESET                                          0x0
#define RXPCU_BSSID2_U16_ADDR_LSB                                              0
#define RXPCU_BSSID2_U16_ADDR_MSB                                              15
#define RXPCU_BSSID2_U16_ADDR_MASK                                             0xffff
#define RXPCU_BSSID2_U16_ADDR_GET(x)                                           (((x) & RXPCU_BSSID2_U16_ADDR_MASK) >> RXPCU_BSSID2_U16_ADDR_LSB)
#define RXPCU_BSSID2_U16_ADDR_SET(x)                                           (((0 | (x)) << RXPCU_BSSID2_U16_ADDR_LSB) & RXPCU_BSSID2_U16_ADDR_MASK)
#define RXPCU_BSSID2_U16_ADDR_RESET                                            0x0
#define RXPCU_BSSID2_U16_ADDRESS                                               (0x4 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_BSSID2_U16_RSTMASK                                               0x7ff1ffff
#define RXPCU_BSSID2_U16_RESET                                                 0x0

// 0x8 (RXPCU_BSSID3_L32)
#define RXPCU_BSSID3_L32_ADDR_LSB                                              0
#define RXPCU_BSSID3_L32_ADDR_MSB                                              31
#define RXPCU_BSSID3_L32_ADDR_MASK                                             0xffffffff
#define RXPCU_BSSID3_L32_ADDR_GET(x)                                           (((x) & RXPCU_BSSID3_L32_ADDR_MASK) >> RXPCU_BSSID3_L32_ADDR_LSB)
#define RXPCU_BSSID3_L32_ADDR_SET(x)                                           (((0 | (x)) << RXPCU_BSSID3_L32_ADDR_LSB) & RXPCU_BSSID3_L32_ADDR_MASK)
#define RXPCU_BSSID3_L32_ADDR_RESET                                            0x0
#define RXPCU_BSSID3_L32_ADDRESS                                               (0x8 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_BSSID3_L32_RSTMASK                                               0xffffffff
#define RXPCU_BSSID3_L32_RESET                                                 0x0

// 0xc (RXPCU_BSSID3_U16)
#define RXPCU_BSSID3_U16_ENABLE_LSB                                            16
#define RXPCU_BSSID3_U16_ENABLE_MSB                                            16
#define RXPCU_BSSID3_U16_ENABLE_MASK                                           0x10000
#define RXPCU_BSSID3_U16_ENABLE_GET(x)                                         (((x) & RXPCU_BSSID3_U16_ENABLE_MASK) >> RXPCU_BSSID3_U16_ENABLE_LSB)
#define RXPCU_BSSID3_U16_ENABLE_SET(x)                                         (((0 | (x)) << RXPCU_BSSID3_U16_ENABLE_LSB) & RXPCU_BSSID3_U16_ENABLE_MASK)
#define RXPCU_BSSID3_U16_ENABLE_RESET                                          0x0
#define RXPCU_BSSID3_U16_ADDR_LSB                                              0
#define RXPCU_BSSID3_U16_ADDR_MSB                                              15
#define RXPCU_BSSID3_U16_ADDR_MASK                                             0xffff
#define RXPCU_BSSID3_U16_ADDR_GET(x)                                           (((x) & RXPCU_BSSID3_U16_ADDR_MASK) >> RXPCU_BSSID3_U16_ADDR_LSB)
#define RXPCU_BSSID3_U16_ADDR_SET(x)                                           (((0 | (x)) << RXPCU_BSSID3_U16_ADDR_LSB) & RXPCU_BSSID3_U16_ADDR_MASK)
#define RXPCU_BSSID3_U16_ADDR_RESET                                            0x0
#define RXPCU_BSSID3_U16_ADDRESS                                               (0xc + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_BSSID3_U16_RSTMASK                                               0x1ffff
#define RXPCU_BSSID3_U16_RESET                                                 0x0

// 0x10 (RXPCU_BSSID4_L32)
#define RXPCU_BSSID4_L32_ADDR_LSB                                              0
#define RXPCU_BSSID4_L32_ADDR_MSB                                              31
#define RXPCU_BSSID4_L32_ADDR_MASK                                             0xffffffff
#define RXPCU_BSSID4_L32_ADDR_GET(x)                                           (((x) & RXPCU_BSSID4_L32_ADDR_MASK) >> RXPCU_BSSID4_L32_ADDR_LSB)
#define RXPCU_BSSID4_L32_ADDR_SET(x)                                           (((0 | (x)) << RXPCU_BSSID4_L32_ADDR_LSB) & RXPCU_BSSID4_L32_ADDR_MASK)
#define RXPCU_BSSID4_L32_ADDR_RESET                                            0x0
#define RXPCU_BSSID4_L32_ADDRESS                                               (0x10 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_BSSID4_L32_RSTMASK                                               0xffffffff
#define RXPCU_BSSID4_L32_RESET                                                 0x0

// 0x14 (RXPCU_BSSID4_U16)
#define RXPCU_BSSID4_U16_ENABLE_LSB                                            16
#define RXPCU_BSSID4_U16_ENABLE_MSB                                            16
#define RXPCU_BSSID4_U16_ENABLE_MASK                                           0x10000
#define RXPCU_BSSID4_U16_ENABLE_GET(x)                                         (((x) & RXPCU_BSSID4_U16_ENABLE_MASK) >> RXPCU_BSSID4_U16_ENABLE_LSB)
#define RXPCU_BSSID4_U16_ENABLE_SET(x)                                         (((0 | (x)) << RXPCU_BSSID4_U16_ENABLE_LSB) & RXPCU_BSSID4_U16_ENABLE_MASK)
#define RXPCU_BSSID4_U16_ENABLE_RESET                                          0x0
#define RXPCU_BSSID4_U16_ADDR_LSB                                              0
#define RXPCU_BSSID4_U16_ADDR_MSB                                              15
#define RXPCU_BSSID4_U16_ADDR_MASK                                             0xffff
#define RXPCU_BSSID4_U16_ADDR_GET(x)                                           (((x) & RXPCU_BSSID4_U16_ADDR_MASK) >> RXPCU_BSSID4_U16_ADDR_LSB)
#define RXPCU_BSSID4_U16_ADDR_SET(x)                                           (((0 | (x)) << RXPCU_BSSID4_U16_ADDR_LSB) & RXPCU_BSSID4_U16_ADDR_MASK)
#define RXPCU_BSSID4_U16_ADDR_RESET                                            0x0
#define RXPCU_BSSID4_U16_ADDRESS                                               (0x14 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_BSSID4_U16_RSTMASK                                               0x1ffff
#define RXPCU_BSSID4_U16_RESET                                                 0x0

// 0x18 (RXPCU_ADDR1_MASK_L32)
#define RXPCU_ADDR1_MASK_L32_VALUE_LSB                                         0
#define RXPCU_ADDR1_MASK_L32_VALUE_MSB                                         31
#define RXPCU_ADDR1_MASK_L32_VALUE_MASK                                        0xffffffff
#define RXPCU_ADDR1_MASK_L32_VALUE_GET(x)                                      (((x) & RXPCU_ADDR1_MASK_L32_VALUE_MASK) >> RXPCU_ADDR1_MASK_L32_VALUE_LSB)
#define RXPCU_ADDR1_MASK_L32_VALUE_SET(x)                                      (((0 | (x)) << RXPCU_ADDR1_MASK_L32_VALUE_LSB) & RXPCU_ADDR1_MASK_L32_VALUE_MASK)
#define RXPCU_ADDR1_MASK_L32_VALUE_RESET                                       0xffffffff
#define RXPCU_ADDR1_MASK_L32_ADDRESS                                           (0x18 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_ADDR1_MASK_L32_RSTMASK                                           0xffffffff
#define RXPCU_ADDR1_MASK_L32_RESET                                             0xffffffff

// 0x1c (RXPCU_ADDR1_MASK_U16)
#define RXPCU_ADDR1_MASK_U16_VALUE_LSB                                         0
#define RXPCU_ADDR1_MASK_U16_VALUE_MSB                                         15
#define RXPCU_ADDR1_MASK_U16_VALUE_MASK                                        0xffff
#define RXPCU_ADDR1_MASK_U16_VALUE_GET(x)                                      (((x) & RXPCU_ADDR1_MASK_U16_VALUE_MASK) >> RXPCU_ADDR1_MASK_U16_VALUE_LSB)
#define RXPCU_ADDR1_MASK_U16_VALUE_SET(x)                                      (((0 | (x)) << RXPCU_ADDR1_MASK_U16_VALUE_LSB) & RXPCU_ADDR1_MASK_U16_VALUE_MASK)
#define RXPCU_ADDR1_MASK_U16_VALUE_RESET                                       0xffff
#define RXPCU_ADDR1_MASK_U16_ADDRESS                                           (0x1c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_ADDR1_MASK_U16_RSTMASK                                           0xffff
#define RXPCU_ADDR1_MASK_U16_RESET                                             0xffff

// 0x20 (RXPCU_MCAST_FILTER_L32)
#define RXPCU_MCAST_FILTER_L32_VALUE_LSB                                       0
#define RXPCU_MCAST_FILTER_L32_VALUE_MSB                                       31
#define RXPCU_MCAST_FILTER_L32_VALUE_MASK                                      0xffffffff
#define RXPCU_MCAST_FILTER_L32_VALUE_GET(x)                                    (((x) & RXPCU_MCAST_FILTER_L32_VALUE_MASK) >> RXPCU_MCAST_FILTER_L32_VALUE_LSB)
#define RXPCU_MCAST_FILTER_L32_VALUE_SET(x)                                    (((0 | (x)) << RXPCU_MCAST_FILTER_L32_VALUE_LSB) & RXPCU_MCAST_FILTER_L32_VALUE_MASK)
#define RXPCU_MCAST_FILTER_L32_VALUE_RESET                                     0x0
#define RXPCU_MCAST_FILTER_L32_ADDRESS                                         (0x20 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_MCAST_FILTER_L32_RSTMASK                                         0xffffffff
#define RXPCU_MCAST_FILTER_L32_RESET                                           0x0

// 0x24 (RXPCU_MCAST_FILTER_U32)
#define RXPCU_MCAST_FILTER_U32_VALUE_LSB                                       0
#define RXPCU_MCAST_FILTER_U32_VALUE_MSB                                       31
#define RXPCU_MCAST_FILTER_U32_VALUE_MASK                                      0xffffffff
#define RXPCU_MCAST_FILTER_U32_VALUE_GET(x)                                    (((x) & RXPCU_MCAST_FILTER_U32_VALUE_MASK) >> RXPCU_MCAST_FILTER_U32_VALUE_LSB)
#define RXPCU_MCAST_FILTER_U32_VALUE_SET(x)                                    (((0 | (x)) << RXPCU_MCAST_FILTER_U32_VALUE_LSB) & RXPCU_MCAST_FILTER_U32_VALUE_MASK)
#define RXPCU_MCAST_FILTER_U32_VALUE_RESET                                     0x0
#define RXPCU_MCAST_FILTER_U32_ADDRESS                                         (0x24 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_MCAST_FILTER_U32_RSTMASK                                         0xffffffff
#define RXPCU_MCAST_FILTER_U32_RESET                                           0x0

// 0x28 (RXPCU_RX_FILTER)
#define RXPCU_RX_FILTER_BSSID_BASED_MULTICAST_LSB                              31
#define RXPCU_RX_FILTER_BSSID_BASED_MULTICAST_MSB                              31
#define RXPCU_RX_FILTER_BSSID_BASED_MULTICAST_MASK                             0x80000000
#define RXPCU_RX_FILTER_BSSID_BASED_MULTICAST_GET(x)                           (((x) & RXPCU_RX_FILTER_BSSID_BASED_MULTICAST_MASK) >> RXPCU_RX_FILTER_BSSID_BASED_MULTICAST_LSB)
#define RXPCU_RX_FILTER_BSSID_BASED_MULTICAST_SET(x)                           (((0 | (x)) << RXPCU_RX_FILTER_BSSID_BASED_MULTICAST_LSB) & RXPCU_RX_FILTER_BSSID_BASED_MULTICAST_MASK)
#define RXPCU_RX_FILTER_BSSID_BASED_MULTICAST_RESET                            0x0
#define RXPCU_RX_FILTER_PHY_DATA_LSB                                           30
#define RXPCU_RX_FILTER_PHY_DATA_MSB                                           30
#define RXPCU_RX_FILTER_PHY_DATA_MASK                                          0x40000000
#define RXPCU_RX_FILTER_PHY_DATA_GET(x)                                        (((x) & RXPCU_RX_FILTER_PHY_DATA_MASK) >> RXPCU_RX_FILTER_PHY_DATA_LSB)
#define RXPCU_RX_FILTER_PHY_DATA_SET(x)                                        (((0 | (x)) << RXPCU_RX_FILTER_PHY_DATA_LSB) & RXPCU_RX_FILTER_PHY_DATA_MASK)
#define RXPCU_RX_FILTER_PHY_DATA_RESET                                         0x0
#define RXPCU_RX_FILTER_MY_BEACON2_LSB                                         29
#define RXPCU_RX_FILTER_MY_BEACON2_MSB                                         29
#define RXPCU_RX_FILTER_MY_BEACON2_MASK                                        0x20000000
#define RXPCU_RX_FILTER_MY_BEACON2_GET(x)                                      (((x) & RXPCU_RX_FILTER_MY_BEACON2_MASK) >> RXPCU_RX_FILTER_MY_BEACON2_LSB)
#define RXPCU_RX_FILTER_MY_BEACON2_SET(x)                                      (((0 | (x)) << RXPCU_RX_FILTER_MY_BEACON2_LSB) & RXPCU_RX_FILTER_MY_BEACON2_MASK)
#define RXPCU_RX_FILTER_MY_BEACON2_RESET                                       0x0
#define RXPCU_RX_FILTER_GENERIC_FILTER_LSB                                     27
#define RXPCU_RX_FILTER_GENERIC_FILTER_MSB                                     28
#define RXPCU_RX_FILTER_GENERIC_FILTER_MASK                                    0x18000000
#define RXPCU_RX_FILTER_GENERIC_FILTER_GET(x)                                  (((x) & RXPCU_RX_FILTER_GENERIC_FILTER_MASK) >> RXPCU_RX_FILTER_GENERIC_FILTER_LSB)
#define RXPCU_RX_FILTER_GENERIC_FILTER_SET(x)                                  (((0 | (x)) << RXPCU_RX_FILTER_GENERIC_FILTER_LSB) & RXPCU_RX_FILTER_GENERIC_FILTER_MASK)
#define RXPCU_RX_FILTER_GENERIC_FILTER_RESET                                   0x0
#define RXPCU_RX_FILTER_GENERIC_FTYPE_LSB                                      21
#define RXPCU_RX_FILTER_GENERIC_FTYPE_MSB                                      26
#define RXPCU_RX_FILTER_GENERIC_FTYPE_MASK                                     0x7e00000
#define RXPCU_RX_FILTER_GENERIC_FTYPE_GET(x)                                   (((x) & RXPCU_RX_FILTER_GENERIC_FTYPE_MASK) >> RXPCU_RX_FILTER_GENERIC_FTYPE_LSB)
#define RXPCU_RX_FILTER_GENERIC_FTYPE_SET(x)                                   (((0 | (x)) << RXPCU_RX_FILTER_GENERIC_FTYPE_LSB) & RXPCU_RX_FILTER_GENERIC_FTYPE_MASK)
#define RXPCU_RX_FILTER_GENERIC_FTYPE_RESET                                    0x0
#define RXPCU_RX_FILTER_FROM_TO_DS_LSB                                         20
#define RXPCU_RX_FILTER_FROM_TO_DS_MSB                                         20
#define RXPCU_RX_FILTER_FROM_TO_DS_MASK                                        0x100000
#define RXPCU_RX_FILTER_FROM_TO_DS_GET(x)                                      (((x) & RXPCU_RX_FILTER_FROM_TO_DS_MASK) >> RXPCU_RX_FILTER_FROM_TO_DS_LSB)
#define RXPCU_RX_FILTER_FROM_TO_DS_SET(x)                                      (((0 | (x)) << RXPCU_RX_FILTER_FROM_TO_DS_LSB) & RXPCU_RX_FILTER_FROM_TO_DS_MASK)
#define RXPCU_RX_FILTER_FROM_TO_DS_RESET                                       0x0
#define RXPCU_RX_FILTER_CONTROL_WRAPPER_LSB                                    19
#define RXPCU_RX_FILTER_CONTROL_WRAPPER_MSB                                    19
#define RXPCU_RX_FILTER_CONTROL_WRAPPER_MASK                                   0x80000
#define RXPCU_RX_FILTER_CONTROL_WRAPPER_GET(x)                                 (((x) & RXPCU_RX_FILTER_CONTROL_WRAPPER_MASK) >> RXPCU_RX_FILTER_CONTROL_WRAPPER_LSB)
#define RXPCU_RX_FILTER_CONTROL_WRAPPER_SET(x)                                 (((0 | (x)) << RXPCU_RX_FILTER_CONTROL_WRAPPER_LSB) & RXPCU_RX_FILTER_CONTROL_WRAPPER_MASK)
#define RXPCU_RX_FILTER_CONTROL_WRAPPER_RESET                                  0x0
#define RXPCU_RX_FILTER_MGMT_ACTION_MCAST_LSB                                  18
#define RXPCU_RX_FILTER_MGMT_ACTION_MCAST_MSB                                  18
#define RXPCU_RX_FILTER_MGMT_ACTION_MCAST_MASK                                 0x40000
#define RXPCU_RX_FILTER_MGMT_ACTION_MCAST_GET(x)                               (((x) & RXPCU_RX_FILTER_MGMT_ACTION_MCAST_MASK) >> RXPCU_RX_FILTER_MGMT_ACTION_MCAST_LSB)
#define RXPCU_RX_FILTER_MGMT_ACTION_MCAST_SET(x)                               (((0 | (x)) << RXPCU_RX_FILTER_MGMT_ACTION_MCAST_LSB) & RXPCU_RX_FILTER_MGMT_ACTION_MCAST_MASK)
#define RXPCU_RX_FILTER_MGMT_ACTION_MCAST_RESET                                0x0
#define RXPCU_RX_FILTER_HW_BCN_PROC_ENABLE_LSB                                 17
#define RXPCU_RX_FILTER_HW_BCN_PROC_ENABLE_MSB                                 17
#define RXPCU_RX_FILTER_HW_BCN_PROC_ENABLE_MASK                                0x20000
#define RXPCU_RX_FILTER_HW_BCN_PROC_ENABLE_GET(x)                              (((x) & RXPCU_RX_FILTER_HW_BCN_PROC_ENABLE_MASK) >> RXPCU_RX_FILTER_HW_BCN_PROC_ENABLE_LSB)
#define RXPCU_RX_FILTER_HW_BCN_PROC_ENABLE_SET(x)                              (((0 | (x)) << RXPCU_RX_FILTER_HW_BCN_PROC_ENABLE_LSB) & RXPCU_RX_FILTER_HW_BCN_PROC_ENABLE_MASK)
#define RXPCU_RX_FILTER_HW_BCN_PROC_ENABLE_RESET                               0x0
#define RXPCU_RX_FILTER_MCAST_BCAST_ALL_LSB                                    15
#define RXPCU_RX_FILTER_MCAST_BCAST_ALL_MSB                                    15
#define RXPCU_RX_FILTER_MCAST_BCAST_ALL_MASK                                   0x8000
#define RXPCU_RX_FILTER_MCAST_BCAST_ALL_GET(x)                                 (((x) & RXPCU_RX_FILTER_MCAST_BCAST_ALL_MASK) >> RXPCU_RX_FILTER_MCAST_BCAST_ALL_LSB)
#define RXPCU_RX_FILTER_MCAST_BCAST_ALL_SET(x)                                 (((0 | (x)) << RXPCU_RX_FILTER_MCAST_BCAST_ALL_LSB) & RXPCU_RX_FILTER_MCAST_BCAST_ALL_MASK)
#define RXPCU_RX_FILTER_MCAST_BCAST_ALL_RESET                                  0x0
#define RXPCU_RX_FILTER_PS_POLL_LSB                                            14
#define RXPCU_RX_FILTER_PS_POLL_MSB                                            14
#define RXPCU_RX_FILTER_PS_POLL_MASK                                           0x4000
#define RXPCU_RX_FILTER_PS_POLL_GET(x)                                         (((x) & RXPCU_RX_FILTER_PS_POLL_MASK) >> RXPCU_RX_FILTER_PS_POLL_LSB)
#define RXPCU_RX_FILTER_PS_POLL_SET(x)                                         (((0 | (x)) << RXPCU_RX_FILTER_PS_POLL_LSB) & RXPCU_RX_FILTER_PS_POLL_MASK)
#define RXPCU_RX_FILTER_PS_POLL_RESET                                          0x0
#define RXPCU_RX_FILTER_RESERVED_0_LSB                                         13
#define RXPCU_RX_FILTER_RESERVED_0_MSB                                         13
#define RXPCU_RX_FILTER_RESERVED_0_MASK                                        0x2000
#define RXPCU_RX_FILTER_RESERVED_0_GET(x)                                      (((x) & RXPCU_RX_FILTER_RESERVED_0_MASK) >> RXPCU_RX_FILTER_RESERVED_0_LSB)
#define RXPCU_RX_FILTER_RESERVED_0_SET(x)                                      (((0 | (x)) << RXPCU_RX_FILTER_RESERVED_0_LSB) & RXPCU_RX_FILTER_RESERVED_0_MASK)
#define RXPCU_RX_FILTER_RESERVED_0_RESET                                       0x0
#define RXPCU_RX_FILTER_UNCOMPRESSED_BA_BAR_LSB                                12
#define RXPCU_RX_FILTER_UNCOMPRESSED_BA_BAR_MSB                                12
#define RXPCU_RX_FILTER_UNCOMPRESSED_BA_BAR_MASK                               0x1000
#define RXPCU_RX_FILTER_UNCOMPRESSED_BA_BAR_GET(x)                             (((x) & RXPCU_RX_FILTER_UNCOMPRESSED_BA_BAR_MASK) >> RXPCU_RX_FILTER_UNCOMPRESSED_BA_BAR_LSB)
#define RXPCU_RX_FILTER_UNCOMPRESSED_BA_BAR_SET(x)                             (((0 | (x)) << RXPCU_RX_FILTER_UNCOMPRESSED_BA_BAR_LSB) & RXPCU_RX_FILTER_UNCOMPRESSED_BA_BAR_MASK)
#define RXPCU_RX_FILTER_UNCOMPRESSED_BA_BAR_RESET                              0x0
#define RXPCU_RX_FILTER_COMPRESSED_BA_LSB                                      11
#define RXPCU_RX_FILTER_COMPRESSED_BA_MSB                                      11
#define RXPCU_RX_FILTER_COMPRESSED_BA_MASK                                     0x800
#define RXPCU_RX_FILTER_COMPRESSED_BA_GET(x)                                   (((x) & RXPCU_RX_FILTER_COMPRESSED_BA_MASK) >> RXPCU_RX_FILTER_COMPRESSED_BA_LSB)
#define RXPCU_RX_FILTER_COMPRESSED_BA_SET(x)                                   (((0 | (x)) << RXPCU_RX_FILTER_COMPRESSED_BA_LSB) & RXPCU_RX_FILTER_COMPRESSED_BA_MASK)
#define RXPCU_RX_FILTER_COMPRESSED_BA_RESET                                    0x0
#define RXPCU_RX_FILTER_COMPRESSED_BAR_LSB                                     10
#define RXPCU_RX_FILTER_COMPRESSED_BAR_MSB                                     10
#define RXPCU_RX_FILTER_COMPRESSED_BAR_MASK                                    0x400
#define RXPCU_RX_FILTER_COMPRESSED_BAR_GET(x)                                  (((x) & RXPCU_RX_FILTER_COMPRESSED_BAR_MASK) >> RXPCU_RX_FILTER_COMPRESSED_BAR_LSB)
#define RXPCU_RX_FILTER_COMPRESSED_BAR_SET(x)                                  (((0 | (x)) << RXPCU_RX_FILTER_COMPRESSED_BAR_LSB) & RXPCU_RX_FILTER_COMPRESSED_BAR_MASK)
#define RXPCU_RX_FILTER_COMPRESSED_BAR_RESET                                   0x0
#define RXPCU_RX_FILTER_MY_BEACON_LSB                                          9
#define RXPCU_RX_FILTER_MY_BEACON_MSB                                          9
#define RXPCU_RX_FILTER_MY_BEACON_MASK                                         0x200
#define RXPCU_RX_FILTER_MY_BEACON_GET(x)                                       (((x) & RXPCU_RX_FILTER_MY_BEACON_MASK) >> RXPCU_RX_FILTER_MY_BEACON_LSB)
#define RXPCU_RX_FILTER_MY_BEACON_SET(x)                                       (((0 | (x)) << RXPCU_RX_FILTER_MY_BEACON_LSB) & RXPCU_RX_FILTER_MY_BEACON_MASK)
#define RXPCU_RX_FILTER_MY_BEACON_RESET                                        0x0
#define RXPCU_RX_FILTER_PROBE_REQ_LSB                                          7
#define RXPCU_RX_FILTER_PROBE_REQ_MSB                                          7
#define RXPCU_RX_FILTER_PROBE_REQ_MASK                                         0x80
#define RXPCU_RX_FILTER_PROBE_REQ_GET(x)                                       (((x) & RXPCU_RX_FILTER_PROBE_REQ_MASK) >> RXPCU_RX_FILTER_PROBE_REQ_LSB)
#define RXPCU_RX_FILTER_PROBE_REQ_SET(x)                                       (((0 | (x)) << RXPCU_RX_FILTER_PROBE_REQ_LSB) & RXPCU_RX_FILTER_PROBE_REQ_MASK)
#define RXPCU_RX_FILTER_PROBE_REQ_RESET                                        0x0
#define RXPCU_RX_FILTER_PROMISCUOUS_LSB                                        5
#define RXPCU_RX_FILTER_PROMISCUOUS_MSB                                        5
#define RXPCU_RX_FILTER_PROMISCUOUS_MASK                                       0x20
#define RXPCU_RX_FILTER_PROMISCUOUS_GET(x)                                     (((x) & RXPCU_RX_FILTER_PROMISCUOUS_MASK) >> RXPCU_RX_FILTER_PROMISCUOUS_LSB)
#define RXPCU_RX_FILTER_PROMISCUOUS_SET(x)                                     (((0 | (x)) << RXPCU_RX_FILTER_PROMISCUOUS_LSB) & RXPCU_RX_FILTER_PROMISCUOUS_MASK)
#define RXPCU_RX_FILTER_PROMISCUOUS_RESET                                      0x0
#define RXPCU_RX_FILTER_BEACON_LSB                                             4
#define RXPCU_RX_FILTER_BEACON_MSB                                             4
#define RXPCU_RX_FILTER_BEACON_MASK                                            0x10
#define RXPCU_RX_FILTER_BEACON_GET(x)                                          (((x) & RXPCU_RX_FILTER_BEACON_MASK) >> RXPCU_RX_FILTER_BEACON_LSB)
#define RXPCU_RX_FILTER_BEACON_SET(x)                                          (((0 | (x)) << RXPCU_RX_FILTER_BEACON_LSB) & RXPCU_RX_FILTER_BEACON_MASK)
#define RXPCU_RX_FILTER_BEACON_RESET                                           0x0
#define RXPCU_RX_FILTER_CONTROL_LSB                                            3
#define RXPCU_RX_FILTER_CONTROL_MSB                                            3
#define RXPCU_RX_FILTER_CONTROL_MASK                                           0x8
#define RXPCU_RX_FILTER_CONTROL_GET(x)                                         (((x) & RXPCU_RX_FILTER_CONTROL_MASK) >> RXPCU_RX_FILTER_CONTROL_LSB)
#define RXPCU_RX_FILTER_CONTROL_SET(x)                                         (((0 | (x)) << RXPCU_RX_FILTER_CONTROL_LSB) & RXPCU_RX_FILTER_CONTROL_MASK)
#define RXPCU_RX_FILTER_CONTROL_RESET                                          0x0
#define RXPCU_RX_FILTER_BROADCAST_LSB                                          2
#define RXPCU_RX_FILTER_BROADCAST_MSB                                          2
#define RXPCU_RX_FILTER_BROADCAST_MASK                                         0x4
#define RXPCU_RX_FILTER_BROADCAST_GET(x)                                       (((x) & RXPCU_RX_FILTER_BROADCAST_MASK) >> RXPCU_RX_FILTER_BROADCAST_LSB)
#define RXPCU_RX_FILTER_BROADCAST_SET(x)                                       (((0 | (x)) << RXPCU_RX_FILTER_BROADCAST_LSB) & RXPCU_RX_FILTER_BROADCAST_MASK)
#define RXPCU_RX_FILTER_BROADCAST_RESET                                        0x0
#define RXPCU_RX_FILTER_MULTICAST_LSB                                          1
#define RXPCU_RX_FILTER_MULTICAST_MSB                                          1
#define RXPCU_RX_FILTER_MULTICAST_MASK                                         0x2
#define RXPCU_RX_FILTER_MULTICAST_GET(x)                                       (((x) & RXPCU_RX_FILTER_MULTICAST_MASK) >> RXPCU_RX_FILTER_MULTICAST_LSB)
#define RXPCU_RX_FILTER_MULTICAST_SET(x)                                       (((0 | (x)) << RXPCU_RX_FILTER_MULTICAST_LSB) & RXPCU_RX_FILTER_MULTICAST_MASK)
#define RXPCU_RX_FILTER_MULTICAST_RESET                                        0x0
#define RXPCU_RX_FILTER_UNICAST_LSB                                            0
#define RXPCU_RX_FILTER_UNICAST_MSB                                            0
#define RXPCU_RX_FILTER_UNICAST_MASK                                           0x1
#define RXPCU_RX_FILTER_UNICAST_GET(x)                                         (((x) & RXPCU_RX_FILTER_UNICAST_MASK) >> RXPCU_RX_FILTER_UNICAST_LSB)
#define RXPCU_RX_FILTER_UNICAST_SET(x)                                         (((0 | (x)) << RXPCU_RX_FILTER_UNICAST_LSB) & RXPCU_RX_FILTER_UNICAST_MASK)
#define RXPCU_RX_FILTER_UNICAST_RESET                                          0x0
#define RXPCU_RX_FILTER_ADDRESS                                                (0x28 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RX_FILTER_RSTMASK                                                0xfffefebf
#define RXPCU_RX_FILTER_RESET                                                  0x0

// 0x2c (RXPCU_RX_FILTER2)
#define RXPCU_RX_FILTER2_BRPOLL_LSB                                            5
#define RXPCU_RX_FILTER2_BRPOLL_MSB                                            5
#define RXPCU_RX_FILTER2_BRPOLL_MASK                                           0x20
#define RXPCU_RX_FILTER2_BRPOLL_GET(x)                                         (((x) & RXPCU_RX_FILTER2_BRPOLL_MASK) >> RXPCU_RX_FILTER2_BRPOLL_LSB)
#define RXPCU_RX_FILTER2_BRPOLL_SET(x)                                         (((0 | (x)) << RXPCU_RX_FILTER2_BRPOLL_LSB) & RXPCU_RX_FILTER2_BRPOLL_MASK)
#define RXPCU_RX_FILTER2_BRPOLL_RESET                                          0x0
#define RXPCU_RX_FILTER2_NDPA_LSB                                              4
#define RXPCU_RX_FILTER2_NDPA_MSB                                              4
#define RXPCU_RX_FILTER2_NDPA_MASK                                             0x10
#define RXPCU_RX_FILTER2_NDPA_GET(x)                                           (((x) & RXPCU_RX_FILTER2_NDPA_MASK) >> RXPCU_RX_FILTER2_NDPA_LSB)
#define RXPCU_RX_FILTER2_NDPA_SET(x)                                           (((0 | (x)) << RXPCU_RX_FILTER2_NDPA_LSB) & RXPCU_RX_FILTER2_NDPA_MASK)
#define RXPCU_RX_FILTER2_NDPA_RESET                                            0x0
#define RXPCU_RX_FILTER2_BSSID_BASED_UNICAST_LSB                               0
#define RXPCU_RX_FILTER2_BSSID_BASED_UNICAST_MSB                               3
#define RXPCU_RX_FILTER2_BSSID_BASED_UNICAST_MASK                              0xf
#define RXPCU_RX_FILTER2_BSSID_BASED_UNICAST_GET(x)                            (((x) & RXPCU_RX_FILTER2_BSSID_BASED_UNICAST_MASK) >> RXPCU_RX_FILTER2_BSSID_BASED_UNICAST_LSB)
#define RXPCU_RX_FILTER2_BSSID_BASED_UNICAST_SET(x)                            (((0 | (x)) << RXPCU_RX_FILTER2_BSSID_BASED_UNICAST_LSB) & RXPCU_RX_FILTER2_BSSID_BASED_UNICAST_MASK)
#define RXPCU_RX_FILTER2_BSSID_BASED_UNICAST_RESET                             0x0
#define RXPCU_RX_FILTER2_ADDRESS                                               (0x2c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RX_FILTER2_RSTMASK                                               0x3f
#define RXPCU_RX_FILTER2_RESET                                                 0x0

// 0x30 (RXPCU_PHY_DATA_LENGTH_THRESH)
#define RXPCU_PHY_DATA_LENGTH_THRESH_ENABLE_LSB                                16
#define RXPCU_PHY_DATA_LENGTH_THRESH_ENABLE_MSB                                16
#define RXPCU_PHY_DATA_LENGTH_THRESH_ENABLE_MASK                               0x10000
#define RXPCU_PHY_DATA_LENGTH_THRESH_ENABLE_GET(x)                             (((x) & RXPCU_PHY_DATA_LENGTH_THRESH_ENABLE_MASK) >> RXPCU_PHY_DATA_LENGTH_THRESH_ENABLE_LSB)
#define RXPCU_PHY_DATA_LENGTH_THRESH_ENABLE_SET(x)                             (((0 | (x)) << RXPCU_PHY_DATA_LENGTH_THRESH_ENABLE_LSB) & RXPCU_PHY_DATA_LENGTH_THRESH_ENABLE_MASK)
#define RXPCU_PHY_DATA_LENGTH_THRESH_ENABLE_RESET                              0x0
#define RXPCU_PHY_DATA_LENGTH_THRESH_VALUE_LSB                                 0
#define RXPCU_PHY_DATA_LENGTH_THRESH_VALUE_MSB                                 13
#define RXPCU_PHY_DATA_LENGTH_THRESH_VALUE_MASK                                0x3fff
#define RXPCU_PHY_DATA_LENGTH_THRESH_VALUE_GET(x)                              (((x) & RXPCU_PHY_DATA_LENGTH_THRESH_VALUE_MASK) >> RXPCU_PHY_DATA_LENGTH_THRESH_VALUE_LSB)
#define RXPCU_PHY_DATA_LENGTH_THRESH_VALUE_SET(x)                              (((0 | (x)) << RXPCU_PHY_DATA_LENGTH_THRESH_VALUE_LSB) & RXPCU_PHY_DATA_LENGTH_THRESH_VALUE_MASK)
#define RXPCU_PHY_DATA_LENGTH_THRESH_VALUE_RESET                               0x64
#define RXPCU_PHY_DATA_LENGTH_THRESH_ADDRESS                                   (0x30 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_PHY_DATA_LENGTH_THRESH_RSTMASK                                   0x13fff
#define RXPCU_PHY_DATA_LENGTH_THRESH_RESET                                     0x64

// 0x34 (RXPCU_BCN_RSSI_CTL)
#define RXPCU_BCN_RSSI_CTL_RESET_LSB                                           29
#define RXPCU_BCN_RSSI_CTL_RESET_MSB                                           29
#define RXPCU_BCN_RSSI_CTL_RESET_MASK                                          0x20000000
#define RXPCU_BCN_RSSI_CTL_RESET_GET(x)                                        (((x) & RXPCU_BCN_RSSI_CTL_RESET_MASK) >> RXPCU_BCN_RSSI_CTL_RESET_LSB)
#define RXPCU_BCN_RSSI_CTL_RESET_SET(x)                                        (((0 | (x)) << RXPCU_BCN_RSSI_CTL_RESET_LSB) & RXPCU_BCN_RSSI_CTL_RESET_MASK)
#define RXPCU_BCN_RSSI_CTL_RESET_RESET                                         0x0
#define RXPCU_BCN_RSSI_CTL_WEIGHT_LSB                                          24
#define RXPCU_BCN_RSSI_CTL_WEIGHT_MSB                                          28
#define RXPCU_BCN_RSSI_CTL_WEIGHT_MASK                                         0x1f000000
#define RXPCU_BCN_RSSI_CTL_WEIGHT_GET(x)                                       (((x) & RXPCU_BCN_RSSI_CTL_WEIGHT_MASK) >> RXPCU_BCN_RSSI_CTL_WEIGHT_LSB)
#define RXPCU_BCN_RSSI_CTL_WEIGHT_SET(x)                                       (((0 | (x)) << RXPCU_BCN_RSSI_CTL_WEIGHT_LSB) & RXPCU_BCN_RSSI_CTL_WEIGHT_MASK)
#define RXPCU_BCN_RSSI_CTL_WEIGHT_RESET                                        0x0
#define RXPCU_BCN_RSSI_CTL_RSSI_HIGH_THRESH_LSB                                16
#define RXPCU_BCN_RSSI_CTL_RSSI_HIGH_THRESH_MSB                                23
#define RXPCU_BCN_RSSI_CTL_RSSI_HIGH_THRESH_MASK                               0xff0000
#define RXPCU_BCN_RSSI_CTL_RSSI_HIGH_THRESH_GET(x)                             (((x) & RXPCU_BCN_RSSI_CTL_RSSI_HIGH_THRESH_MASK) >> RXPCU_BCN_RSSI_CTL_RSSI_HIGH_THRESH_LSB)
#define RXPCU_BCN_RSSI_CTL_RSSI_HIGH_THRESH_SET(x)                             (((0 | (x)) << RXPCU_BCN_RSSI_CTL_RSSI_HIGH_THRESH_LSB) & RXPCU_BCN_RSSI_CTL_RSSI_HIGH_THRESH_MASK)
#define RXPCU_BCN_RSSI_CTL_RSSI_HIGH_THRESH_RESET                              0x0
#define RXPCU_BCN_RSSI_CTL_MISS_THRESH_LSB                                     8
#define RXPCU_BCN_RSSI_CTL_MISS_THRESH_MSB                                     15
#define RXPCU_BCN_RSSI_CTL_MISS_THRESH_MASK                                    0xff00
#define RXPCU_BCN_RSSI_CTL_MISS_THRESH_GET(x)                                  (((x) & RXPCU_BCN_RSSI_CTL_MISS_THRESH_MASK) >> RXPCU_BCN_RSSI_CTL_MISS_THRESH_LSB)
#define RXPCU_BCN_RSSI_CTL_MISS_THRESH_SET(x)                                  (((0 | (x)) << RXPCU_BCN_RSSI_CTL_MISS_THRESH_LSB) & RXPCU_BCN_RSSI_CTL_MISS_THRESH_MASK)
#define RXPCU_BCN_RSSI_CTL_MISS_THRESH_RESET                                   0x0
#define RXPCU_BCN_RSSI_CTL_RSSI_LOW_THRESH_LSB                                 0
#define RXPCU_BCN_RSSI_CTL_RSSI_LOW_THRESH_MSB                                 7
#define RXPCU_BCN_RSSI_CTL_RSSI_LOW_THRESH_MASK                                0xff
#define RXPCU_BCN_RSSI_CTL_RSSI_LOW_THRESH_GET(x)                              (((x) & RXPCU_BCN_RSSI_CTL_RSSI_LOW_THRESH_MASK) >> RXPCU_BCN_RSSI_CTL_RSSI_LOW_THRESH_LSB)
#define RXPCU_BCN_RSSI_CTL_RSSI_LOW_THRESH_SET(x)                              (((0 | (x)) << RXPCU_BCN_RSSI_CTL_RSSI_LOW_THRESH_LSB) & RXPCU_BCN_RSSI_CTL_RSSI_LOW_THRESH_MASK)
#define RXPCU_BCN_RSSI_CTL_RSSI_LOW_THRESH_RESET                               0x0
#define RXPCU_BCN_RSSI_CTL_ADDRESS                                             (0x34 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_BCN_RSSI_CTL_RSTMASK                                             0x3fffffff
#define RXPCU_BCN_RSSI_CTL_RESET                                               0x0

// 0x38 (RXPCU_BCN_RSSI_CTL2)
#define RXPCU_BCN_RSSI_CTL2_RESET2_LSB                                         29
#define RXPCU_BCN_RSSI_CTL2_RESET2_MSB                                         29
#define RXPCU_BCN_RSSI_CTL2_RESET2_MASK                                        0x20000000
#define RXPCU_BCN_RSSI_CTL2_RESET2_GET(x)                                      (((x) & RXPCU_BCN_RSSI_CTL2_RESET2_MASK) >> RXPCU_BCN_RSSI_CTL2_RESET2_LSB)
#define RXPCU_BCN_RSSI_CTL2_RESET2_SET(x)                                      (((0 | (x)) << RXPCU_BCN_RSSI_CTL2_RESET2_LSB) & RXPCU_BCN_RSSI_CTL2_RESET2_MASK)
#define RXPCU_BCN_RSSI_CTL2_RESET2_RESET                                       0x0
#define RXPCU_BCN_RSSI_CTL2_RSSI2_HIGH_THRESH_LSB                              16
#define RXPCU_BCN_RSSI_CTL2_RSSI2_HIGH_THRESH_MSB                              23
#define RXPCU_BCN_RSSI_CTL2_RSSI2_HIGH_THRESH_MASK                             0xff0000
#define RXPCU_BCN_RSSI_CTL2_RSSI2_HIGH_THRESH_GET(x)                           (((x) & RXPCU_BCN_RSSI_CTL2_RSSI2_HIGH_THRESH_MASK) >> RXPCU_BCN_RSSI_CTL2_RSSI2_HIGH_THRESH_LSB)
#define RXPCU_BCN_RSSI_CTL2_RSSI2_HIGH_THRESH_SET(x)                           (((0 | (x)) << RXPCU_BCN_RSSI_CTL2_RSSI2_HIGH_THRESH_LSB) & RXPCU_BCN_RSSI_CTL2_RSSI2_HIGH_THRESH_MASK)
#define RXPCU_BCN_RSSI_CTL2_RSSI2_HIGH_THRESH_RESET                            0x0
#define RXPCU_BCN_RSSI_CTL2_RSSI2_LOW_THRESH_LSB                               0
#define RXPCU_BCN_RSSI_CTL2_RSSI2_LOW_THRESH_MSB                               7
#define RXPCU_BCN_RSSI_CTL2_RSSI2_LOW_THRESH_MASK                              0xff
#define RXPCU_BCN_RSSI_CTL2_RSSI2_LOW_THRESH_GET(x)                            (((x) & RXPCU_BCN_RSSI_CTL2_RSSI2_LOW_THRESH_MASK) >> RXPCU_BCN_RSSI_CTL2_RSSI2_LOW_THRESH_LSB)
#define RXPCU_BCN_RSSI_CTL2_RSSI2_LOW_THRESH_SET(x)                            (((0 | (x)) << RXPCU_BCN_RSSI_CTL2_RSSI2_LOW_THRESH_LSB) & RXPCU_BCN_RSSI_CTL2_RSSI2_LOW_THRESH_MASK)
#define RXPCU_BCN_RSSI_CTL2_RSSI2_LOW_THRESH_RESET                             0x0
#define RXPCU_BCN_RSSI_CTL2_ADDRESS                                            (0x38 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_BCN_RSSI_CTL2_RSTMASK                                            0x20ff00ff
#define RXPCU_BCN_RSSI_CTL2_RESET                                              0x0

// 0x3c (RXPCU_BCN_RSSI_AVE)
#define RXPCU_BCN_RSSI_AVE_AVE_VALUE2_LSB                                      16
#define RXPCU_BCN_RSSI_AVE_AVE_VALUE2_MSB                                      27
#define RXPCU_BCN_RSSI_AVE_AVE_VALUE2_MASK                                     0xfff0000
#define RXPCU_BCN_RSSI_AVE_AVE_VALUE2_GET(x)                                   (((x) & RXPCU_BCN_RSSI_AVE_AVE_VALUE2_MASK) >> RXPCU_BCN_RSSI_AVE_AVE_VALUE2_LSB)
#define RXPCU_BCN_RSSI_AVE_AVE_VALUE2_SET(x)                                   (((0 | (x)) << RXPCU_BCN_RSSI_AVE_AVE_VALUE2_LSB) & RXPCU_BCN_RSSI_AVE_AVE_VALUE2_MASK)
#define RXPCU_BCN_RSSI_AVE_AVE_VALUE2_RESET                                    0x800
#define RXPCU_BCN_RSSI_AVE_AVE_VALUE_LSB                                       0
#define RXPCU_BCN_RSSI_AVE_AVE_VALUE_MSB                                       11
#define RXPCU_BCN_RSSI_AVE_AVE_VALUE_MASK                                      0xfff
#define RXPCU_BCN_RSSI_AVE_AVE_VALUE_GET(x)                                    (((x) & RXPCU_BCN_RSSI_AVE_AVE_VALUE_MASK) >> RXPCU_BCN_RSSI_AVE_AVE_VALUE_LSB)
#define RXPCU_BCN_RSSI_AVE_AVE_VALUE_SET(x)                                    (((0 | (x)) << RXPCU_BCN_RSSI_AVE_AVE_VALUE_LSB) & RXPCU_BCN_RSSI_AVE_AVE_VALUE_MASK)
#define RXPCU_BCN_RSSI_AVE_AVE_VALUE_RESET                                     0x800
#define RXPCU_BCN_RSSI_AVE_ADDRESS                                             (0x3c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_BCN_RSSI_AVE_RSTMASK                                             0xfff0fff
#define RXPCU_BCN_RSSI_AVE_RESET                                               0x8000800

// 0x40 (RXPCU_FILTER_RSSI_AVE)
#define RXPCU_FILTER_RSSI_AVE_RESET_LSB                                        12
#define RXPCU_FILTER_RSSI_AVE_RESET_MSB                                        12
#define RXPCU_FILTER_RSSI_AVE_RESET_MASK                                       0x1000
#define RXPCU_FILTER_RSSI_AVE_RESET_GET(x)                                     (((x) & RXPCU_FILTER_RSSI_AVE_RESET_MASK) >> RXPCU_FILTER_RSSI_AVE_RESET_LSB)
#define RXPCU_FILTER_RSSI_AVE_RESET_SET(x)                                     (((0 | (x)) << RXPCU_FILTER_RSSI_AVE_RESET_LSB) & RXPCU_FILTER_RSSI_AVE_RESET_MASK)
#define RXPCU_FILTER_RSSI_AVE_RESET_RESET                                      0x0
#define RXPCU_FILTER_RSSI_AVE_ENABLE_LSB                                       11
#define RXPCU_FILTER_RSSI_AVE_ENABLE_MSB                                       11
#define RXPCU_FILTER_RSSI_AVE_ENABLE_MASK                                      0x800
#define RXPCU_FILTER_RSSI_AVE_ENABLE_GET(x)                                    (((x) & RXPCU_FILTER_RSSI_AVE_ENABLE_MASK) >> RXPCU_FILTER_RSSI_AVE_ENABLE_LSB)
#define RXPCU_FILTER_RSSI_AVE_ENABLE_SET(x)                                    (((0 | (x)) << RXPCU_FILTER_RSSI_AVE_ENABLE_LSB) & RXPCU_FILTER_RSSI_AVE_ENABLE_MASK)
#define RXPCU_FILTER_RSSI_AVE_ENABLE_RESET                                     0x0
#define RXPCU_FILTER_RSSI_AVE_NUM_FRAMES_EXPONENT_LSB                          8
#define RXPCU_FILTER_RSSI_AVE_NUM_FRAMES_EXPONENT_MSB                          10
#define RXPCU_FILTER_RSSI_AVE_NUM_FRAMES_EXPONENT_MASK                         0x700
#define RXPCU_FILTER_RSSI_AVE_NUM_FRAMES_EXPONENT_GET(x)                       (((x) & RXPCU_FILTER_RSSI_AVE_NUM_FRAMES_EXPONENT_MASK) >> RXPCU_FILTER_RSSI_AVE_NUM_FRAMES_EXPONENT_LSB)
#define RXPCU_FILTER_RSSI_AVE_NUM_FRAMES_EXPONENT_SET(x)                       (((0 | (x)) << RXPCU_FILTER_RSSI_AVE_NUM_FRAMES_EXPONENT_LSB) & RXPCU_FILTER_RSSI_AVE_NUM_FRAMES_EXPONENT_MASK)
#define RXPCU_FILTER_RSSI_AVE_NUM_FRAMES_EXPONENT_RESET                        0x5
#define RXPCU_FILTER_RSSI_AVE_AVE_VALUE_LSB                                    0
#define RXPCU_FILTER_RSSI_AVE_AVE_VALUE_MSB                                    7
#define RXPCU_FILTER_RSSI_AVE_AVE_VALUE_MASK                                   0xff
#define RXPCU_FILTER_RSSI_AVE_AVE_VALUE_GET(x)                                 (((x) & RXPCU_FILTER_RSSI_AVE_AVE_VALUE_MASK) >> RXPCU_FILTER_RSSI_AVE_AVE_VALUE_LSB)
#define RXPCU_FILTER_RSSI_AVE_AVE_VALUE_SET(x)                                 (((0 | (x)) << RXPCU_FILTER_RSSI_AVE_AVE_VALUE_LSB) & RXPCU_FILTER_RSSI_AVE_AVE_VALUE_MASK)
#define RXPCU_FILTER_RSSI_AVE_AVE_VALUE_RESET                                  0x80
#define RXPCU_FILTER_RSSI_AVE_ADDRESS                                          (0x40 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_FILTER_RSSI_AVE_RSTMASK                                          0x1fff
#define RXPCU_FILTER_RSSI_AVE_RESET                                            0x580

// 0x44 (RXPCU_BA_BAR_CONTROL)
#define RXPCU_BA_BAR_CONTROL_SEARCH_DEPTH_LSB                                  16
#define RXPCU_BA_BAR_CONTROL_SEARCH_DEPTH_MSB                                  19
#define RXPCU_BA_BAR_CONTROL_SEARCH_DEPTH_MASK                                 0xf0000
#define RXPCU_BA_BAR_CONTROL_SEARCH_DEPTH_GET(x)                               (((x) & RXPCU_BA_BAR_CONTROL_SEARCH_DEPTH_MASK) >> RXPCU_BA_BAR_CONTROL_SEARCH_DEPTH_LSB)
#define RXPCU_BA_BAR_CONTROL_SEARCH_DEPTH_SET(x)                               (((0 | (x)) << RXPCU_BA_BAR_CONTROL_SEARCH_DEPTH_LSB) & RXPCU_BA_BAR_CONTROL_SEARCH_DEPTH_MASK)
#define RXPCU_BA_BAR_CONTROL_SEARCH_DEPTH_RESET                                0x3
#define RXPCU_BA_BAR_CONTROL_FORCE_NO_MATCH_LSB                                10
#define RXPCU_BA_BAR_CONTROL_FORCE_NO_MATCH_MSB                                10
#define RXPCU_BA_BAR_CONTROL_FORCE_NO_MATCH_MASK                               0x400
#define RXPCU_BA_BAR_CONTROL_FORCE_NO_MATCH_GET(x)                             (((x) & RXPCU_BA_BAR_CONTROL_FORCE_NO_MATCH_MASK) >> RXPCU_BA_BAR_CONTROL_FORCE_NO_MATCH_LSB)
#define RXPCU_BA_BAR_CONTROL_FORCE_NO_MATCH_SET(x)                             (((0 | (x)) << RXPCU_BA_BAR_CONTROL_FORCE_NO_MATCH_LSB) & RXPCU_BA_BAR_CONTROL_FORCE_NO_MATCH_MASK)
#define RXPCU_BA_BAR_CONTROL_FORCE_NO_MATCH_RESET                              0x0
#define RXPCU_BA_BAR_CONTROL_ADDRESS                                           (0x44 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_BA_BAR_CONTROL_RSTMASK                                           0xf0400
#define RXPCU_BA_BAR_CONTROL_RESET                                             0x30000

// 0x48 (RXPCU_RTT_CTRL)
#define RXPCU_RTT_CTRL_CATEGORY_LSB                                            24
#define RXPCU_RTT_CTRL_CATEGORY_MSB                                            31
#define RXPCU_RTT_CTRL_CATEGORY_MASK                                           0xff000000
#define RXPCU_RTT_CTRL_CATEGORY_GET(x)                                         (((x) & RXPCU_RTT_CTRL_CATEGORY_MASK) >> RXPCU_RTT_CTRL_CATEGORY_LSB)
#define RXPCU_RTT_CTRL_CATEGORY_SET(x)                                         (((0 | (x)) << RXPCU_RTT_CTRL_CATEGORY_LSB) & RXPCU_RTT_CTRL_CATEGORY_MASK)
#define RXPCU_RTT_CTRL_CATEGORY_RESET                                          0xb
#define RXPCU_RTT_CTRL_ALLOW_HT_VHT_ACK_BA_LSB                                 16
#define RXPCU_RTT_CTRL_ALLOW_HT_VHT_ACK_BA_MSB                                 16
#define RXPCU_RTT_CTRL_ALLOW_HT_VHT_ACK_BA_MASK                                0x10000
#define RXPCU_RTT_CTRL_ALLOW_HT_VHT_ACK_BA_GET(x)                              (((x) & RXPCU_RTT_CTRL_ALLOW_HT_VHT_ACK_BA_MASK) >> RXPCU_RTT_CTRL_ALLOW_HT_VHT_ACK_BA_LSB)
#define RXPCU_RTT_CTRL_ALLOW_HT_VHT_ACK_BA_SET(x)                              (((0 | (x)) << RXPCU_RTT_CTRL_ALLOW_HT_VHT_ACK_BA_LSB) & RXPCU_RTT_CTRL_ALLOW_HT_VHT_ACK_BA_MASK)
#define RXPCU_RTT_CTRL_ALLOW_HT_VHT_ACK_BA_RESET                               0x0
#define RXPCU_RTT_CTRL_ACTION_LSB                                              8
#define RXPCU_RTT_CTRL_ACTION_MSB                                              15
#define RXPCU_RTT_CTRL_ACTION_MASK                                             0xff00
#define RXPCU_RTT_CTRL_ACTION_GET(x)                                           (((x) & RXPCU_RTT_CTRL_ACTION_MASK) >> RXPCU_RTT_CTRL_ACTION_LSB)
#define RXPCU_RTT_CTRL_ACTION_SET(x)                                           (((0 | (x)) << RXPCU_RTT_CTRL_ACTION_LSB) & RXPCU_RTT_CTRL_ACTION_MASK)
#define RXPCU_RTT_CTRL_ACTION_RESET                                            0x1
#define RXPCU_RTT_CTRL_FREEZE_CHANNEL_CAPTURE_CLEAR_LSB                        0
#define RXPCU_RTT_CTRL_FREEZE_CHANNEL_CAPTURE_CLEAR_MSB                        0
#define RXPCU_RTT_CTRL_FREEZE_CHANNEL_CAPTURE_CLEAR_MASK                       0x1
#define RXPCU_RTT_CTRL_FREEZE_CHANNEL_CAPTURE_CLEAR_GET(x)                     (((x) & RXPCU_RTT_CTRL_FREEZE_CHANNEL_CAPTURE_CLEAR_MASK) >> RXPCU_RTT_CTRL_FREEZE_CHANNEL_CAPTURE_CLEAR_LSB)
#define RXPCU_RTT_CTRL_FREEZE_CHANNEL_CAPTURE_CLEAR_SET(x)                     (((0 | (x)) << RXPCU_RTT_CTRL_FREEZE_CHANNEL_CAPTURE_CLEAR_LSB) & RXPCU_RTT_CTRL_FREEZE_CHANNEL_CAPTURE_CLEAR_MASK)
#define RXPCU_RTT_CTRL_FREEZE_CHANNEL_CAPTURE_CLEAR_RESET                      0x0
#define RXPCU_RTT_CTRL_ADDRESS                                                 (0x48 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RTT_CTRL_RSTMASK                                                 0xff01ff01
#define RXPCU_RTT_CTRL_RESET                                                   0xb000100

// 0x4c (RXPCU_XRSTMP)
#define RXPCU_XRSTMP_RX_ABORT_RSSI_THRESH_LSB                                  16
#define RXPCU_XRSTMP_RX_ABORT_RSSI_THRESH_MSB                                  23
#define RXPCU_XRSTMP_RX_ABORT_RSSI_THRESH_MASK                                 0xff0000
#define RXPCU_XRSTMP_RX_ABORT_RSSI_THRESH_GET(x)                               (((x) & RXPCU_XRSTMP_RX_ABORT_RSSI_THRESH_MASK) >> RXPCU_XRSTMP_RX_ABORT_RSSI_THRESH_LSB)
#define RXPCU_XRSTMP_RX_ABORT_RSSI_THRESH_SET(x)                               (((0 | (x)) << RXPCU_XRSTMP_RX_ABORT_RSSI_THRESH_LSB) & RXPCU_XRSTMP_RX_ABORT_RSSI_THRESH_MASK)
#define RXPCU_XRSTMP_RX_ABORT_RSSI_THRESH_RESET                                0x25
#define RXPCU_XRSTMP_RX_ABORT_DATA_LSB                                         5
#define RXPCU_XRSTMP_RX_ABORT_DATA_MSB                                         5
#define RXPCU_XRSTMP_RX_ABORT_DATA_MASK                                        0x20
#define RXPCU_XRSTMP_RX_ABORT_DATA_GET(x)                                      (((x) & RXPCU_XRSTMP_RX_ABORT_DATA_MASK) >> RXPCU_XRSTMP_RX_ABORT_DATA_LSB)
#define RXPCU_XRSTMP_RX_ABORT_DATA_SET(x)                                      (((0 | (x)) << RXPCU_XRSTMP_RX_ABORT_DATA_LSB) & RXPCU_XRSTMP_RX_ABORT_DATA_MASK)
#define RXPCU_XRSTMP_RX_ABORT_DATA_RESET                                       0x0
#define RXPCU_XRSTMP_RX_ABORT_BSSID_LSB                                        1
#define RXPCU_XRSTMP_RX_ABORT_BSSID_MSB                                        1
#define RXPCU_XRSTMP_RX_ABORT_BSSID_MASK                                       0x2
#define RXPCU_XRSTMP_RX_ABORT_BSSID_GET(x)                                     (((x) & RXPCU_XRSTMP_RX_ABORT_BSSID_MASK) >> RXPCU_XRSTMP_RX_ABORT_BSSID_LSB)
#define RXPCU_XRSTMP_RX_ABORT_BSSID_SET(x)                                     (((0 | (x)) << RXPCU_XRSTMP_RX_ABORT_BSSID_LSB) & RXPCU_XRSTMP_RX_ABORT_BSSID_MASK)
#define RXPCU_XRSTMP_RX_ABORT_BSSID_RESET                                      0x0
#define RXPCU_XRSTMP_RX_ABORT_RSSI_LSB                                         0
#define RXPCU_XRSTMP_RX_ABORT_RSSI_MSB                                         0
#define RXPCU_XRSTMP_RX_ABORT_RSSI_MASK                                        0x1
#define RXPCU_XRSTMP_RX_ABORT_RSSI_GET(x)                                      (((x) & RXPCU_XRSTMP_RX_ABORT_RSSI_MASK) >> RXPCU_XRSTMP_RX_ABORT_RSSI_LSB)
#define RXPCU_XRSTMP_RX_ABORT_RSSI_SET(x)                                      (((0 | (x)) << RXPCU_XRSTMP_RX_ABORT_RSSI_LSB) & RXPCU_XRSTMP_RX_ABORT_RSSI_MASK)
#define RXPCU_XRSTMP_RX_ABORT_RSSI_RESET                                       0x0
#define RXPCU_XRSTMP_ADDRESS                                                   (0x4c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_XRSTMP_RSTMASK                                                   0xff0023
#define RXPCU_XRSTMP_RESET                                                     0x250000

// 0x50 (RXPCU_TXBF_CNTL)
#define RXPCU_TXBF_CNTL_NDP_TIMEOUT_VALUE_LSB                                  16
#define RXPCU_TXBF_CNTL_NDP_TIMEOUT_VALUE_MSB                                  31
#define RXPCU_TXBF_CNTL_NDP_TIMEOUT_VALUE_MASK                                 0xffff0000
#define RXPCU_TXBF_CNTL_NDP_TIMEOUT_VALUE_GET(x)                               (((x) & RXPCU_TXBF_CNTL_NDP_TIMEOUT_VALUE_MASK) >> RXPCU_TXBF_CNTL_NDP_TIMEOUT_VALUE_LSB)
#define RXPCU_TXBF_CNTL_NDP_TIMEOUT_VALUE_SET(x)                               (((0 | (x)) << RXPCU_TXBF_CNTL_NDP_TIMEOUT_VALUE_LSB) & RXPCU_TXBF_CNTL_NDP_TIMEOUT_VALUE_MASK)
#define RXPCU_TXBF_CNTL_NDP_TIMEOUT_VALUE_RESET                                0x780
#define RXPCU_TXBF_CNTL_SIFS_TIME_LSB                                          8
#define RXPCU_TXBF_CNTL_SIFS_TIME_MSB                                          15
#define RXPCU_TXBF_CNTL_SIFS_TIME_MASK                                         0xff00
#define RXPCU_TXBF_CNTL_SIFS_TIME_GET(x)                                       (((x) & RXPCU_TXBF_CNTL_SIFS_TIME_MASK) >> RXPCU_TXBF_CNTL_SIFS_TIME_LSB)
#define RXPCU_TXBF_CNTL_SIFS_TIME_SET(x)                                       (((0 | (x)) << RXPCU_TXBF_CNTL_SIFS_TIME_LSB) & RXPCU_TXBF_CNTL_SIFS_TIME_MASK)
#define RXPCU_TXBF_CNTL_SIFS_TIME_RESET                                        0x0
#define RXPCU_TXBF_CNTL_MAX_NC_INDEX_LSB                                       1
#define RXPCU_TXBF_CNTL_MAX_NC_INDEX_MSB                                       3
#define RXPCU_TXBF_CNTL_MAX_NC_INDEX_MASK                                      0xe
#define RXPCU_TXBF_CNTL_MAX_NC_INDEX_GET(x)                                    (((x) & RXPCU_TXBF_CNTL_MAX_NC_INDEX_MASK) >> RXPCU_TXBF_CNTL_MAX_NC_INDEX_LSB)
#define RXPCU_TXBF_CNTL_MAX_NC_INDEX_SET(x)                                    (((0 | (x)) << RXPCU_TXBF_CNTL_MAX_NC_INDEX_LSB) & RXPCU_TXBF_CNTL_MAX_NC_INDEX_MASK)
#define RXPCU_TXBF_CNTL_MAX_NC_INDEX_RESET                                     0x1
#define RXPCU_TXBF_CNTL_CHECK_CH_STATUS_EN_LSB                                 0
#define RXPCU_TXBF_CNTL_CHECK_CH_STATUS_EN_MSB                                 0
#define RXPCU_TXBF_CNTL_CHECK_CH_STATUS_EN_MASK                                0x1
#define RXPCU_TXBF_CNTL_CHECK_CH_STATUS_EN_GET(x)                              (((x) & RXPCU_TXBF_CNTL_CHECK_CH_STATUS_EN_MASK) >> RXPCU_TXBF_CNTL_CHECK_CH_STATUS_EN_LSB)
#define RXPCU_TXBF_CNTL_CHECK_CH_STATUS_EN_SET(x)                              (((0 | (x)) << RXPCU_TXBF_CNTL_CHECK_CH_STATUS_EN_LSB) & RXPCU_TXBF_CNTL_CHECK_CH_STATUS_EN_MASK)
#define RXPCU_TXBF_CNTL_CHECK_CH_STATUS_EN_RESET                               0x0
#define RXPCU_TXBF_CNTL_ADDRESS                                                (0x50 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_TXBF_CNTL_RSTMASK                                                0xffffff0f
#define RXPCU_TXBF_CNTL_RESET                                                  0x7800002

// 0x54 (RXPCU_IMPLICIT_BF_CTRL)
#define RXPCU_IMPLICIT_BF_CTRL_TIMEOUT_VALUE_LSB                               0
#define RXPCU_IMPLICIT_BF_CTRL_TIMEOUT_VALUE_MSB                               11
#define RXPCU_IMPLICIT_BF_CTRL_TIMEOUT_VALUE_MASK                              0xfff
#define RXPCU_IMPLICIT_BF_CTRL_TIMEOUT_VALUE_GET(x)                            (((x) & RXPCU_IMPLICIT_BF_CTRL_TIMEOUT_VALUE_MASK) >> RXPCU_IMPLICIT_BF_CTRL_TIMEOUT_VALUE_LSB)
#define RXPCU_IMPLICIT_BF_CTRL_TIMEOUT_VALUE_SET(x)                            (((0 | (x)) << RXPCU_IMPLICIT_BF_CTRL_TIMEOUT_VALUE_LSB) & RXPCU_IMPLICIT_BF_CTRL_TIMEOUT_VALUE_MASK)
#define RXPCU_IMPLICIT_BF_CTRL_TIMEOUT_VALUE_RESET                             0x780
#define RXPCU_IMPLICIT_BF_CTRL_ADDRESS                                         (0x54 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_IMPLICIT_BF_CTRL_RSTMASK                                         0xfff
#define RXPCU_IMPLICIT_BF_CTRL_RESET                                           0x780

// 0x58 (RXPCU_SEC_CHANNEL_RX_PIFS_CNT)
#define RXPCU_SEC_CHANNEL_RX_PIFS_CNT_VALUE_LSB                                0
#define RXPCU_SEC_CHANNEL_RX_PIFS_CNT_VALUE_MSB                                31
#define RXPCU_SEC_CHANNEL_RX_PIFS_CNT_VALUE_MASK                               0xffffffff
#define RXPCU_SEC_CHANNEL_RX_PIFS_CNT_VALUE_GET(x)                             (((x) & RXPCU_SEC_CHANNEL_RX_PIFS_CNT_VALUE_MASK) >> RXPCU_SEC_CHANNEL_RX_PIFS_CNT_VALUE_LSB)
#define RXPCU_SEC_CHANNEL_RX_PIFS_CNT_VALUE_SET(x)                             (((0 | (x)) << RXPCU_SEC_CHANNEL_RX_PIFS_CNT_VALUE_LSB) & RXPCU_SEC_CHANNEL_RX_PIFS_CNT_VALUE_MASK)
#define RXPCU_SEC_CHANNEL_RX_PIFS_CNT_VALUE_RESET                              0xa50
#define RXPCU_SEC_CHANNEL_RX_PIFS_CNT_ADDRESS                                  (0x58 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_SEC_CHANNEL_RX_PIFS_CNT_RSTMASK                                  0xffffffff
#define RXPCU_SEC_CHANNEL_RX_PIFS_CNT_RESET                                    0xa50

// 0x5c (RXPCU_PROXY_STA)
#define RXPCU_PROXY_STA_MERU_VC_MODE_LSB                                       8
#define RXPCU_PROXY_STA_MERU_VC_MODE_MSB                                       8
#define RXPCU_PROXY_STA_MERU_VC_MODE_MASK                                      0x100
#define RXPCU_PROXY_STA_MERU_VC_MODE_GET(x)                                    (((x) & RXPCU_PROXY_STA_MERU_VC_MODE_MASK) >> RXPCU_PROXY_STA_MERU_VC_MODE_LSB)
#define RXPCU_PROXY_STA_MERU_VC_MODE_SET(x)                                    (((0 | (x)) << RXPCU_PROXY_STA_MERU_VC_MODE_LSB) & RXPCU_PROXY_STA_MERU_VC_MODE_MASK)
#define RXPCU_PROXY_STA_MERU_VC_MODE_RESET                                     0x0
#define RXPCU_PROXY_STA_INVALID_ENTRY_NO_ACK_BSSID4_LSB                        7
#define RXPCU_PROXY_STA_INVALID_ENTRY_NO_ACK_BSSID4_MSB                        7
#define RXPCU_PROXY_STA_INVALID_ENTRY_NO_ACK_BSSID4_MASK                       0x80
#define RXPCU_PROXY_STA_INVALID_ENTRY_NO_ACK_BSSID4_GET(x)                     (((x) & RXPCU_PROXY_STA_INVALID_ENTRY_NO_ACK_BSSID4_MASK) >> RXPCU_PROXY_STA_INVALID_ENTRY_NO_ACK_BSSID4_LSB)
#define RXPCU_PROXY_STA_INVALID_ENTRY_NO_ACK_BSSID4_SET(x)                     (((0 | (x)) << RXPCU_PROXY_STA_INVALID_ENTRY_NO_ACK_BSSID4_LSB) & RXPCU_PROXY_STA_INVALID_ENTRY_NO_ACK_BSSID4_MASK)
#define RXPCU_PROXY_STA_INVALID_ENTRY_NO_ACK_BSSID4_RESET                      0x0
#define RXPCU_PROXY_STA_INVALID_ENTRY_NO_ACK_BSSID3_LSB                        6
#define RXPCU_PROXY_STA_INVALID_ENTRY_NO_ACK_BSSID3_MSB                        6
#define RXPCU_PROXY_STA_INVALID_ENTRY_NO_ACK_BSSID3_MASK                       0x40
#define RXPCU_PROXY_STA_INVALID_ENTRY_NO_ACK_BSSID3_GET(x)                     (((x) & RXPCU_PROXY_STA_INVALID_ENTRY_NO_ACK_BSSID3_MASK) >> RXPCU_PROXY_STA_INVALID_ENTRY_NO_ACK_BSSID3_LSB)
#define RXPCU_PROXY_STA_INVALID_ENTRY_NO_ACK_BSSID3_SET(x)                     (((0 | (x)) << RXPCU_PROXY_STA_INVALID_ENTRY_NO_ACK_BSSID3_LSB) & RXPCU_PROXY_STA_INVALID_ENTRY_NO_ACK_BSSID3_MASK)
#define RXPCU_PROXY_STA_INVALID_ENTRY_NO_ACK_BSSID3_RESET                      0x0
#define RXPCU_PROXY_STA_INVALID_ENTRY_NO_ACK_BSSID2_LSB                        5
#define RXPCU_PROXY_STA_INVALID_ENTRY_NO_ACK_BSSID2_MSB                        5
#define RXPCU_PROXY_STA_INVALID_ENTRY_NO_ACK_BSSID2_MASK                       0x20
#define RXPCU_PROXY_STA_INVALID_ENTRY_NO_ACK_BSSID2_GET(x)                     (((x) & RXPCU_PROXY_STA_INVALID_ENTRY_NO_ACK_BSSID2_MASK) >> RXPCU_PROXY_STA_INVALID_ENTRY_NO_ACK_BSSID2_LSB)
#define RXPCU_PROXY_STA_INVALID_ENTRY_NO_ACK_BSSID2_SET(x)                     (((0 | (x)) << RXPCU_PROXY_STA_INVALID_ENTRY_NO_ACK_BSSID2_LSB) & RXPCU_PROXY_STA_INVALID_ENTRY_NO_ACK_BSSID2_MASK)
#define RXPCU_PROXY_STA_INVALID_ENTRY_NO_ACK_BSSID2_RESET                      0x0
#define RXPCU_PROXY_STA_INVALID_ENTRY_NO_ACK_BSSID1_LSB                        4
#define RXPCU_PROXY_STA_INVALID_ENTRY_NO_ACK_BSSID1_MSB                        4
#define RXPCU_PROXY_STA_INVALID_ENTRY_NO_ACK_BSSID1_MASK                       0x10
#define RXPCU_PROXY_STA_INVALID_ENTRY_NO_ACK_BSSID1_GET(x)                     (((x) & RXPCU_PROXY_STA_INVALID_ENTRY_NO_ACK_BSSID1_MASK) >> RXPCU_PROXY_STA_INVALID_ENTRY_NO_ACK_BSSID1_LSB)
#define RXPCU_PROXY_STA_INVALID_ENTRY_NO_ACK_BSSID1_SET(x)                     (((0 | (x)) << RXPCU_PROXY_STA_INVALID_ENTRY_NO_ACK_BSSID1_LSB) & RXPCU_PROXY_STA_INVALID_ENTRY_NO_ACK_BSSID1_MASK)
#define RXPCU_PROXY_STA_INVALID_ENTRY_NO_ACK_BSSID1_RESET                      0x0
#define RXPCU_PROXY_STA_PROXY_STA_AD1_SEARCH_BSSID4_LSB                        3
#define RXPCU_PROXY_STA_PROXY_STA_AD1_SEARCH_BSSID4_MSB                        3
#define RXPCU_PROXY_STA_PROXY_STA_AD1_SEARCH_BSSID4_MASK                       0x8
#define RXPCU_PROXY_STA_PROXY_STA_AD1_SEARCH_BSSID4_GET(x)                     (((x) & RXPCU_PROXY_STA_PROXY_STA_AD1_SEARCH_BSSID4_MASK) >> RXPCU_PROXY_STA_PROXY_STA_AD1_SEARCH_BSSID4_LSB)
#define RXPCU_PROXY_STA_PROXY_STA_AD1_SEARCH_BSSID4_SET(x)                     (((0 | (x)) << RXPCU_PROXY_STA_PROXY_STA_AD1_SEARCH_BSSID4_LSB) & RXPCU_PROXY_STA_PROXY_STA_AD1_SEARCH_BSSID4_MASK)
#define RXPCU_PROXY_STA_PROXY_STA_AD1_SEARCH_BSSID4_RESET                      0x0
#define RXPCU_PROXY_STA_PROXY_STA_AD1_SEARCH_BSSID3_LSB                        2
#define RXPCU_PROXY_STA_PROXY_STA_AD1_SEARCH_BSSID3_MSB                        2
#define RXPCU_PROXY_STA_PROXY_STA_AD1_SEARCH_BSSID3_MASK                       0x4
#define RXPCU_PROXY_STA_PROXY_STA_AD1_SEARCH_BSSID3_GET(x)                     (((x) & RXPCU_PROXY_STA_PROXY_STA_AD1_SEARCH_BSSID3_MASK) >> RXPCU_PROXY_STA_PROXY_STA_AD1_SEARCH_BSSID3_LSB)
#define RXPCU_PROXY_STA_PROXY_STA_AD1_SEARCH_BSSID3_SET(x)                     (((0 | (x)) << RXPCU_PROXY_STA_PROXY_STA_AD1_SEARCH_BSSID3_LSB) & RXPCU_PROXY_STA_PROXY_STA_AD1_SEARCH_BSSID3_MASK)
#define RXPCU_PROXY_STA_PROXY_STA_AD1_SEARCH_BSSID3_RESET                      0x0
#define RXPCU_PROXY_STA_PROXY_STA_AD1_SEARCH_BSSID2_LSB                        1
#define RXPCU_PROXY_STA_PROXY_STA_AD1_SEARCH_BSSID2_MSB                        1
#define RXPCU_PROXY_STA_PROXY_STA_AD1_SEARCH_BSSID2_MASK                       0x2
#define RXPCU_PROXY_STA_PROXY_STA_AD1_SEARCH_BSSID2_GET(x)                     (((x) & RXPCU_PROXY_STA_PROXY_STA_AD1_SEARCH_BSSID2_MASK) >> RXPCU_PROXY_STA_PROXY_STA_AD1_SEARCH_BSSID2_LSB)
#define RXPCU_PROXY_STA_PROXY_STA_AD1_SEARCH_BSSID2_SET(x)                     (((0 | (x)) << RXPCU_PROXY_STA_PROXY_STA_AD1_SEARCH_BSSID2_LSB) & RXPCU_PROXY_STA_PROXY_STA_AD1_SEARCH_BSSID2_MASK)
#define RXPCU_PROXY_STA_PROXY_STA_AD1_SEARCH_BSSID2_RESET                      0x0
#define RXPCU_PROXY_STA_PROXY_STA_AD1_SEARCH_BSSID1_LSB                        0
#define RXPCU_PROXY_STA_PROXY_STA_AD1_SEARCH_BSSID1_MSB                        0
#define RXPCU_PROXY_STA_PROXY_STA_AD1_SEARCH_BSSID1_MASK                       0x1
#define RXPCU_PROXY_STA_PROXY_STA_AD1_SEARCH_BSSID1_GET(x)                     (((x) & RXPCU_PROXY_STA_PROXY_STA_AD1_SEARCH_BSSID1_MASK) >> RXPCU_PROXY_STA_PROXY_STA_AD1_SEARCH_BSSID1_LSB)
#define RXPCU_PROXY_STA_PROXY_STA_AD1_SEARCH_BSSID1_SET(x)                     (((0 | (x)) << RXPCU_PROXY_STA_PROXY_STA_AD1_SEARCH_BSSID1_LSB) & RXPCU_PROXY_STA_PROXY_STA_AD1_SEARCH_BSSID1_MASK)
#define RXPCU_PROXY_STA_PROXY_STA_AD1_SEARCH_BSSID1_RESET                      0x0
#define RXPCU_PROXY_STA_ADDRESS                                                (0x5c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_PROXY_STA_RSTMASK                                                0x1ff
#define RXPCU_PROXY_STA_RESET                                                  0x0

// 0x60 (RXPCU_RX_ANTENNA)
#define RXPCU_RX_ANTENNA_VALUE_LSB                                             0
#define RXPCU_RX_ANTENNA_VALUE_MSB                                             23
#define RXPCU_RX_ANTENNA_VALUE_MASK                                            0xffffff
#define RXPCU_RX_ANTENNA_VALUE_GET(x)                                          (((x) & RXPCU_RX_ANTENNA_VALUE_MASK) >> RXPCU_RX_ANTENNA_VALUE_LSB)
#define RXPCU_RX_ANTENNA_VALUE_SET(x)                                          (((0 | (x)) << RXPCU_RX_ANTENNA_VALUE_LSB) & RXPCU_RX_ANTENNA_VALUE_MASK)
#define RXPCU_RX_ANTENNA_VALUE_RESET                                           0x0
#define RXPCU_RX_ANTENNA_ADDRESS                                               (0x60 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RX_ANTENNA_RSTMASK                                               0xffffff
#define RXPCU_RX_ANTENNA_RESET                                                 0x0

// 0x64 (RXPCU_CLASS_1_FRAME_CFG1)
#define RXPCU_CLASS_1_FRAME_CFG1_CTL_BITMAP_LSB                                16
#define RXPCU_CLASS_1_FRAME_CFG1_CTL_BITMAP_MSB                                31
#define RXPCU_CLASS_1_FRAME_CFG1_CTL_BITMAP_MASK                               0xffff0000
#define RXPCU_CLASS_1_FRAME_CFG1_CTL_BITMAP_GET(x)                             (((x) & RXPCU_CLASS_1_FRAME_CFG1_CTL_BITMAP_MASK) >> RXPCU_CLASS_1_FRAME_CFG1_CTL_BITMAP_LSB)
#define RXPCU_CLASS_1_FRAME_CFG1_CTL_BITMAP_SET(x)                             (((0 | (x)) << RXPCU_CLASS_1_FRAME_CFG1_CTL_BITMAP_LSB) & RXPCU_CLASS_1_FRAME_CFG1_CTL_BITMAP_MASK)
#define RXPCU_CLASS_1_FRAME_CFG1_CTL_BITMAP_RESET                              0x0
#define RXPCU_CLASS_1_FRAME_CFG1_MGMT_BITMAP_LSB                               0
#define RXPCU_CLASS_1_FRAME_CFG1_MGMT_BITMAP_MSB                               15
#define RXPCU_CLASS_1_FRAME_CFG1_MGMT_BITMAP_MASK                              0xffff
#define RXPCU_CLASS_1_FRAME_CFG1_MGMT_BITMAP_GET(x)                            (((x) & RXPCU_CLASS_1_FRAME_CFG1_MGMT_BITMAP_MASK) >> RXPCU_CLASS_1_FRAME_CFG1_MGMT_BITMAP_LSB)
#define RXPCU_CLASS_1_FRAME_CFG1_MGMT_BITMAP_SET(x)                            (((0 | (x)) << RXPCU_CLASS_1_FRAME_CFG1_MGMT_BITMAP_LSB) & RXPCU_CLASS_1_FRAME_CFG1_MGMT_BITMAP_MASK)
#define RXPCU_CLASS_1_FRAME_CFG1_MGMT_BITMAP_RESET                             0x0
#define RXPCU_CLASS_1_FRAME_CFG1_ADDRESS                                       (0x64 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_CLASS_1_FRAME_CFG1_RSTMASK                                       0xffffffff
#define RXPCU_CLASS_1_FRAME_CFG1_RESET                                         0x0

// 0x68 (RXPCU_NAV_CFG)
#define RXPCU_NAV_CFG_EN_11G_MODE_LSB                                          25
#define RXPCU_NAV_CFG_EN_11G_MODE_MSB                                          25
#define RXPCU_NAV_CFG_EN_11G_MODE_MASK                                         0x2000000
#define RXPCU_NAV_CFG_EN_11G_MODE_GET(x)                                       (((x) & RXPCU_NAV_CFG_EN_11G_MODE_MASK) >> RXPCU_NAV_CFG_EN_11G_MODE_LSB)
#define RXPCU_NAV_CFG_EN_11G_MODE_SET(x)                                       (((0 | (x)) << RXPCU_NAV_CFG_EN_11G_MODE_LSB) & RXPCU_NAV_CFG_EN_11G_MODE_MASK)
#define RXPCU_NAV_CFG_EN_11G_MODE_RESET                                        0x0
#define RXPCU_NAV_CFG_NAV_UPDATE_FOR_MU_EN_LSB                                 24
#define RXPCU_NAV_CFG_NAV_UPDATE_FOR_MU_EN_MSB                                 24
#define RXPCU_NAV_CFG_NAV_UPDATE_FOR_MU_EN_MASK                                0x1000000
#define RXPCU_NAV_CFG_NAV_UPDATE_FOR_MU_EN_GET(x)                              (((x) & RXPCU_NAV_CFG_NAV_UPDATE_FOR_MU_EN_MASK) >> RXPCU_NAV_CFG_NAV_UPDATE_FOR_MU_EN_LSB)
#define RXPCU_NAV_CFG_NAV_UPDATE_FOR_MU_EN_SET(x)                              (((0 | (x)) << RXPCU_NAV_CFG_NAV_UPDATE_FOR_MU_EN_LSB) & RXPCU_NAV_CFG_NAV_UPDATE_FOR_MU_EN_MASK)
#define RXPCU_NAV_CFG_NAV_UPDATE_FOR_MU_EN_RESET                               0x0
#define RXPCU_NAV_CFG_OFDM_LSB                                                 12
#define RXPCU_NAV_CFG_OFDM_MSB                                                 23
#define RXPCU_NAV_CFG_OFDM_MASK                                                0xfff000
#define RXPCU_NAV_CFG_OFDM_GET(x)                                              (((x) & RXPCU_NAV_CFG_OFDM_MASK) >> RXPCU_NAV_CFG_OFDM_LSB)
#define RXPCU_NAV_CFG_OFDM_SET(x)                                              (((0 | (x)) << RXPCU_NAV_CFG_OFDM_LSB) & RXPCU_NAV_CFG_OFDM_MASK)
#define RXPCU_NAV_CFG_OFDM_RESET                                               0x3c
#define RXPCU_NAV_CFG_CCK_LSB                                                  0
#define RXPCU_NAV_CFG_CCK_MSB                                                  11
#define RXPCU_NAV_CFG_CCK_MASK                                                 0xfff
#define RXPCU_NAV_CFG_CCK_GET(x)                                               (((x) & RXPCU_NAV_CFG_CCK_MASK) >> RXPCU_NAV_CFG_CCK_LSB)
#define RXPCU_NAV_CFG_CCK_SET(x)                                               (((0 | (x)) << RXPCU_NAV_CFG_CCK_LSB) & RXPCU_NAV_CFG_CCK_MASK)
#define RXPCU_NAV_CFG_CCK_RESET                                                0x13a
#define RXPCU_NAV_CFG_ADDRESS                                                  (0x68 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_NAV_CFG_RSTMASK                                                  0x3ffffff
#define RXPCU_NAV_CFG_RESET                                                    0x3c13a

// 0x6c (RXPCU_CLASS_1_FRAME_CFG2)
#define RXPCU_CLASS_1_FRAME_CFG2_TYPE11_BITMAP_LSB                             16
#define RXPCU_CLASS_1_FRAME_CFG2_TYPE11_BITMAP_MSB                             31
#define RXPCU_CLASS_1_FRAME_CFG2_TYPE11_BITMAP_MASK                            0xffff0000
#define RXPCU_CLASS_1_FRAME_CFG2_TYPE11_BITMAP_GET(x)                          (((x) & RXPCU_CLASS_1_FRAME_CFG2_TYPE11_BITMAP_MASK) >> RXPCU_CLASS_1_FRAME_CFG2_TYPE11_BITMAP_LSB)
#define RXPCU_CLASS_1_FRAME_CFG2_TYPE11_BITMAP_SET(x)                          (((0 | (x)) << RXPCU_CLASS_1_FRAME_CFG2_TYPE11_BITMAP_LSB) & RXPCU_CLASS_1_FRAME_CFG2_TYPE11_BITMAP_MASK)
#define RXPCU_CLASS_1_FRAME_CFG2_TYPE11_BITMAP_RESET                           0x0
#define RXPCU_CLASS_1_FRAME_CFG2_DATA_BITMAP_LSB                               0
#define RXPCU_CLASS_1_FRAME_CFG2_DATA_BITMAP_MSB                               15
#define RXPCU_CLASS_1_FRAME_CFG2_DATA_BITMAP_MASK                              0xffff
#define RXPCU_CLASS_1_FRAME_CFG2_DATA_BITMAP_GET(x)                            (((x) & RXPCU_CLASS_1_FRAME_CFG2_DATA_BITMAP_MASK) >> RXPCU_CLASS_1_FRAME_CFG2_DATA_BITMAP_LSB)
#define RXPCU_CLASS_1_FRAME_CFG2_DATA_BITMAP_SET(x)                            (((0 | (x)) << RXPCU_CLASS_1_FRAME_CFG2_DATA_BITMAP_LSB) & RXPCU_CLASS_1_FRAME_CFG2_DATA_BITMAP_MASK)
#define RXPCU_CLASS_1_FRAME_CFG2_DATA_BITMAP_RESET                             0x0
#define RXPCU_CLASS_1_FRAME_CFG2_ADDRESS                                       (0x6c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_CLASS_1_FRAME_CFG2_RSTMASK                                       0xffffffff
#define RXPCU_CLASS_1_FRAME_CFG2_RESET                                         0x0

// 0x70 (RXPCU_DIRECT_CONNECT)
#define RXPCU_DIRECT_CONNECT_ONE_USEC_LSB                                      24
#define RXPCU_DIRECT_CONNECT_ONE_USEC_MSB                                      31
#define RXPCU_DIRECT_CONNECT_ONE_USEC_MASK                                     0xff000000
#define RXPCU_DIRECT_CONNECT_ONE_USEC_GET(x)                                   (((x) & RXPCU_DIRECT_CONNECT_ONE_USEC_MASK) >> RXPCU_DIRECT_CONNECT_ONE_USEC_LSB)
#define RXPCU_DIRECT_CONNECT_ONE_USEC_SET(x)                                   (((0 | (x)) << RXPCU_DIRECT_CONNECT_ONE_USEC_LSB) & RXPCU_DIRECT_CONNECT_ONE_USEC_MASK)
#define RXPCU_DIRECT_CONNECT_ONE_USEC_RESET                                    0x81
#define RXPCU_DIRECT_CONNECT_SYNC_TSF_ON_UCAST_PROBE_RESP_LSB                  19
#define RXPCU_DIRECT_CONNECT_SYNC_TSF_ON_UCAST_PROBE_RESP_MSB                  19
#define RXPCU_DIRECT_CONNECT_SYNC_TSF_ON_UCAST_PROBE_RESP_MASK                 0x80000
#define RXPCU_DIRECT_CONNECT_SYNC_TSF_ON_UCAST_PROBE_RESP_GET(x)               (((x) & RXPCU_DIRECT_CONNECT_SYNC_TSF_ON_UCAST_PROBE_RESP_MASK) >> RXPCU_DIRECT_CONNECT_SYNC_TSF_ON_UCAST_PROBE_RESP_LSB)
#define RXPCU_DIRECT_CONNECT_SYNC_TSF_ON_UCAST_PROBE_RESP_SET(x)               (((0 | (x)) << RXPCU_DIRECT_CONNECT_SYNC_TSF_ON_UCAST_PROBE_RESP_LSB) & RXPCU_DIRECT_CONNECT_SYNC_TSF_ON_UCAST_PROBE_RESP_MASK)
#define RXPCU_DIRECT_CONNECT_SYNC_TSF_ON_UCAST_PROBE_RESP_RESET                0x0
#define RXPCU_DIRECT_CONNECT_SYNC_TSF_ON_UCAST_MOON_PROBE_RESP_LSB             18
#define RXPCU_DIRECT_CONNECT_SYNC_TSF_ON_UCAST_MOON_PROBE_RESP_MSB             18
#define RXPCU_DIRECT_CONNECT_SYNC_TSF_ON_UCAST_MOON_PROBE_RESP_MASK            0x40000
#define RXPCU_DIRECT_CONNECT_SYNC_TSF_ON_UCAST_MOON_PROBE_RESP_GET(x)          (((x) & RXPCU_DIRECT_CONNECT_SYNC_TSF_ON_UCAST_MOON_PROBE_RESP_MASK) >> RXPCU_DIRECT_CONNECT_SYNC_TSF_ON_UCAST_MOON_PROBE_RESP_LSB)
#define RXPCU_DIRECT_CONNECT_SYNC_TSF_ON_UCAST_MOON_PROBE_RESP_SET(x)          (((0 | (x)) << RXPCU_DIRECT_CONNECT_SYNC_TSF_ON_UCAST_MOON_PROBE_RESP_LSB) & RXPCU_DIRECT_CONNECT_SYNC_TSF_ON_UCAST_MOON_PROBE_RESP_MASK)
#define RXPCU_DIRECT_CONNECT_SYNC_TSF_ON_UCAST_MOON_PROBE_RESP_RESET           0x0
#define RXPCU_DIRECT_CONNECT_SYNC_TSF_ON_MCAST_PROBE_RESP_LSB                  17
#define RXPCU_DIRECT_CONNECT_SYNC_TSF_ON_MCAST_PROBE_RESP_MSB                  17
#define RXPCU_DIRECT_CONNECT_SYNC_TSF_ON_MCAST_PROBE_RESP_MASK                 0x20000
#define RXPCU_DIRECT_CONNECT_SYNC_TSF_ON_MCAST_PROBE_RESP_GET(x)               (((x) & RXPCU_DIRECT_CONNECT_SYNC_TSF_ON_MCAST_PROBE_RESP_MASK) >> RXPCU_DIRECT_CONNECT_SYNC_TSF_ON_MCAST_PROBE_RESP_LSB)
#define RXPCU_DIRECT_CONNECT_SYNC_TSF_ON_MCAST_PROBE_RESP_SET(x)               (((0 | (x)) << RXPCU_DIRECT_CONNECT_SYNC_TSF_ON_MCAST_PROBE_RESP_LSB) & RXPCU_DIRECT_CONNECT_SYNC_TSF_ON_MCAST_PROBE_RESP_MASK)
#define RXPCU_DIRECT_CONNECT_SYNC_TSF_ON_MCAST_PROBE_RESP_RESET                0x0
#define RXPCU_DIRECT_CONNECT_SYNC_TSF_ON_BCAST_PROBE_RESP_LSB                  16
#define RXPCU_DIRECT_CONNECT_SYNC_TSF_ON_BCAST_PROBE_RESP_MSB                  16
#define RXPCU_DIRECT_CONNECT_SYNC_TSF_ON_BCAST_PROBE_RESP_MASK                 0x10000
#define RXPCU_DIRECT_CONNECT_SYNC_TSF_ON_BCAST_PROBE_RESP_GET(x)               (((x) & RXPCU_DIRECT_CONNECT_SYNC_TSF_ON_BCAST_PROBE_RESP_MASK) >> RXPCU_DIRECT_CONNECT_SYNC_TSF_ON_BCAST_PROBE_RESP_LSB)
#define RXPCU_DIRECT_CONNECT_SYNC_TSF_ON_BCAST_PROBE_RESP_SET(x)               (((0 | (x)) << RXPCU_DIRECT_CONNECT_SYNC_TSF_ON_BCAST_PROBE_RESP_LSB) & RXPCU_DIRECT_CONNECT_SYNC_TSF_ON_BCAST_PROBE_RESP_MASK)
#define RXPCU_DIRECT_CONNECT_SYNC_TSF_ON_BCAST_PROBE_RESP_RESET                0x0
#define RXPCU_DIRECT_CONNECT_SYNC_TSF_ON_BEACON_LSB                            15
#define RXPCU_DIRECT_CONNECT_SYNC_TSF_ON_BEACON_MSB                            15
#define RXPCU_DIRECT_CONNECT_SYNC_TSF_ON_BEACON_MASK                           0x8000
#define RXPCU_DIRECT_CONNECT_SYNC_TSF_ON_BEACON_GET(x)                         (((x) & RXPCU_DIRECT_CONNECT_SYNC_TSF_ON_BEACON_MASK) >> RXPCU_DIRECT_CONNECT_SYNC_TSF_ON_BEACON_LSB)
#define RXPCU_DIRECT_CONNECT_SYNC_TSF_ON_BEACON_SET(x)                         (((0 | (x)) << RXPCU_DIRECT_CONNECT_SYNC_TSF_ON_BEACON_LSB) & RXPCU_DIRECT_CONNECT_SYNC_TSF_ON_BEACON_MASK)
#define RXPCU_DIRECT_CONNECT_SYNC_TSF_ON_BEACON_RESET                          0x1
#define RXPCU_DIRECT_CONNECT_RX_LATENCY_LSB                                    9
#define RXPCU_DIRECT_CONNECT_RX_LATENCY_MSB                                    14
#define RXPCU_DIRECT_CONNECT_RX_LATENCY_MASK                                   0x7e00
#define RXPCU_DIRECT_CONNECT_RX_LATENCY_GET(x)                                 (((x) & RXPCU_DIRECT_CONNECT_RX_LATENCY_MASK) >> RXPCU_DIRECT_CONNECT_RX_LATENCY_LSB)
#define RXPCU_DIRECT_CONNECT_RX_LATENCY_SET(x)                                 (((0 | (x)) << RXPCU_DIRECT_CONNECT_RX_LATENCY_LSB) & RXPCU_DIRECT_CONNECT_RX_LATENCY_MASK)
#define RXPCU_DIRECT_CONNECT_RX_LATENCY_RESET                                  0x10
#define RXPCU_DIRECT_CONNECT_BMISS_CNT_OVERRIDE_LSB                            7
#define RXPCU_DIRECT_CONNECT_BMISS_CNT_OVERRIDE_MSB                            7
#define RXPCU_DIRECT_CONNECT_BMISS_CNT_OVERRIDE_MASK                           0x80
#define RXPCU_DIRECT_CONNECT_BMISS_CNT_OVERRIDE_GET(x)                         (((x) & RXPCU_DIRECT_CONNECT_BMISS_CNT_OVERRIDE_MASK) >> RXPCU_DIRECT_CONNECT_BMISS_CNT_OVERRIDE_LSB)
#define RXPCU_DIRECT_CONNECT_BMISS_CNT_OVERRIDE_SET(x)                         (((0 | (x)) << RXPCU_DIRECT_CONNECT_BMISS_CNT_OVERRIDE_LSB) & RXPCU_DIRECT_CONNECT_BMISS_CNT_OVERRIDE_MASK)
#define RXPCU_DIRECT_CONNECT_BMISS_CNT_OVERRIDE_RESET                          0x0
#define RXPCU_DIRECT_CONNECT_MY_BEACON2_OVERRIDE_LSB                           5
#define RXPCU_DIRECT_CONNECT_MY_BEACON2_OVERRIDE_MSB                           5
#define RXPCU_DIRECT_CONNECT_MY_BEACON2_OVERRIDE_MASK                          0x20
#define RXPCU_DIRECT_CONNECT_MY_BEACON2_OVERRIDE_GET(x)                        (((x) & RXPCU_DIRECT_CONNECT_MY_BEACON2_OVERRIDE_MASK) >> RXPCU_DIRECT_CONNECT_MY_BEACON2_OVERRIDE_LSB)
#define RXPCU_DIRECT_CONNECT_MY_BEACON2_OVERRIDE_SET(x)                        (((0 | (x)) << RXPCU_DIRECT_CONNECT_MY_BEACON2_OVERRIDE_LSB) & RXPCU_DIRECT_CONNECT_MY_BEACON2_OVERRIDE_MASK)
#define RXPCU_DIRECT_CONNECT_MY_BEACON2_OVERRIDE_RESET                         0x0
#define RXPCU_DIRECT_CONNECT_MY_BEACON_OVERRIDE_LSB                            4
#define RXPCU_DIRECT_CONNECT_MY_BEACON_OVERRIDE_MSB                            4
#define RXPCU_DIRECT_CONNECT_MY_BEACON_OVERRIDE_MASK                           0x10
#define RXPCU_DIRECT_CONNECT_MY_BEACON_OVERRIDE_GET(x)                         (((x) & RXPCU_DIRECT_CONNECT_MY_BEACON_OVERRIDE_MASK) >> RXPCU_DIRECT_CONNECT_MY_BEACON_OVERRIDE_LSB)
#define RXPCU_DIRECT_CONNECT_MY_BEACON_OVERRIDE_SET(x)                         (((0 | (x)) << RXPCU_DIRECT_CONNECT_MY_BEACON_OVERRIDE_LSB) & RXPCU_DIRECT_CONNECT_MY_BEACON_OVERRIDE_MASK)
#define RXPCU_DIRECT_CONNECT_MY_BEACON_OVERRIDE_RESET                          0x0
#define RXPCU_DIRECT_CONNECT_ADDRESS                                           (0x70 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_DIRECT_CONNECT_RSTMASK                                           0xff0ffeb0
#define RXPCU_DIRECT_CONNECT_RESET                                             0x8100a000

// 0x74 (RXPCU_LAST_BEACON_TSF)
#define RXPCU_LAST_BEACON_TSF_VALUE_LSB                                        0
#define RXPCU_LAST_BEACON_TSF_VALUE_MSB                                        31
#define RXPCU_LAST_BEACON_TSF_VALUE_MASK                                       0xffffffff
#define RXPCU_LAST_BEACON_TSF_VALUE_GET(x)                                     (((x) & RXPCU_LAST_BEACON_TSF_VALUE_MASK) >> RXPCU_LAST_BEACON_TSF_VALUE_LSB)
#define RXPCU_LAST_BEACON_TSF_VALUE_SET(x)                                     (((0 | (x)) << RXPCU_LAST_BEACON_TSF_VALUE_LSB) & RXPCU_LAST_BEACON_TSF_VALUE_MASK)
#define RXPCU_LAST_BEACON_TSF_VALUE_RESET                                      0x0
#define RXPCU_LAST_BEACON_TSF_ADDRESS                                          (0x74 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_LAST_BEACON_TSF_RSTMASK                                          0xffffffff
#define RXPCU_LAST_BEACON_TSF_RESET                                            0x0

// 0x78 (RXPCU_LAST_BEACON2_TSF)
#define RXPCU_LAST_BEACON2_TSF_VALUE_LSB                                       0
#define RXPCU_LAST_BEACON2_TSF_VALUE_MSB                                       31
#define RXPCU_LAST_BEACON2_TSF_VALUE_MASK                                      0xffffffff
#define RXPCU_LAST_BEACON2_TSF_VALUE_GET(x)                                    (((x) & RXPCU_LAST_BEACON2_TSF_VALUE_MASK) >> RXPCU_LAST_BEACON2_TSF_VALUE_LSB)
#define RXPCU_LAST_BEACON2_TSF_VALUE_SET(x)                                    (((0 | (x)) << RXPCU_LAST_BEACON2_TSF_VALUE_LSB) & RXPCU_LAST_BEACON2_TSF_VALUE_MASK)
#define RXPCU_LAST_BEACON2_TSF_VALUE_RESET                                     0x0
#define RXPCU_LAST_BEACON2_TSF_ADDRESS                                         (0x78 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_LAST_BEACON2_TSF_RSTMASK                                         0xffffffff
#define RXPCU_LAST_BEACON2_TSF_RESET                                           0x0

// 0x7c (RXPCU_HW_BCN_PROC1)
#define RXPCU_HW_BCN_PROC1_ELM2_ID_LSB                                         24
#define RXPCU_HW_BCN_PROC1_ELM2_ID_MSB                                         31
#define RXPCU_HW_BCN_PROC1_ELM2_ID_MASK                                        0xff000000
#define RXPCU_HW_BCN_PROC1_ELM2_ID_GET(x)                                      (((x) & RXPCU_HW_BCN_PROC1_ELM2_ID_MASK) >> RXPCU_HW_BCN_PROC1_ELM2_ID_LSB)
#define RXPCU_HW_BCN_PROC1_ELM2_ID_SET(x)                                      (((0 | (x)) << RXPCU_HW_BCN_PROC1_ELM2_ID_LSB) & RXPCU_HW_BCN_PROC1_ELM2_ID_MASK)
#define RXPCU_HW_BCN_PROC1_ELM2_ID_RESET                                       0x0
#define RXPCU_HW_BCN_PROC1_ELM1_ID_LSB                                         16
#define RXPCU_HW_BCN_PROC1_ELM1_ID_MSB                                         23
#define RXPCU_HW_BCN_PROC1_ELM1_ID_MASK                                        0xff0000
#define RXPCU_HW_BCN_PROC1_ELM1_ID_GET(x)                                      (((x) & RXPCU_HW_BCN_PROC1_ELM1_ID_MASK) >> RXPCU_HW_BCN_PROC1_ELM1_ID_LSB)
#define RXPCU_HW_BCN_PROC1_ELM1_ID_SET(x)                                      (((0 | (x)) << RXPCU_HW_BCN_PROC1_ELM1_ID_LSB) & RXPCU_HW_BCN_PROC1_ELM1_ID_MASK)
#define RXPCU_HW_BCN_PROC1_ELM1_ID_RESET                                       0x0
#define RXPCU_HW_BCN_PROC1_ELM0_ID_LSB                                         8
#define RXPCU_HW_BCN_PROC1_ELM0_ID_MSB                                         15
#define RXPCU_HW_BCN_PROC1_ELM0_ID_MASK                                        0xff00
#define RXPCU_HW_BCN_PROC1_ELM0_ID_GET(x)                                      (((x) & RXPCU_HW_BCN_PROC1_ELM0_ID_MASK) >> RXPCU_HW_BCN_PROC1_ELM0_ID_LSB)
#define RXPCU_HW_BCN_PROC1_ELM0_ID_SET(x)                                      (((0 | (x)) << RXPCU_HW_BCN_PROC1_ELM0_ID_LSB) & RXPCU_HW_BCN_PROC1_ELM0_ID_MASK)
#define RXPCU_HW_BCN_PROC1_ELM0_ID_RESET                                       0x0
#define RXPCU_HW_BCN_PROC1_EXCLUDE_ELM2_LSB                                    7
#define RXPCU_HW_BCN_PROC1_EXCLUDE_ELM2_MSB                                    7
#define RXPCU_HW_BCN_PROC1_EXCLUDE_ELM2_MASK                                   0x80
#define RXPCU_HW_BCN_PROC1_EXCLUDE_ELM2_GET(x)                                 (((x) & RXPCU_HW_BCN_PROC1_EXCLUDE_ELM2_MASK) >> RXPCU_HW_BCN_PROC1_EXCLUDE_ELM2_LSB)
#define RXPCU_HW_BCN_PROC1_EXCLUDE_ELM2_SET(x)                                 (((0 | (x)) << RXPCU_HW_BCN_PROC1_EXCLUDE_ELM2_LSB) & RXPCU_HW_BCN_PROC1_EXCLUDE_ELM2_MASK)
#define RXPCU_HW_BCN_PROC1_EXCLUDE_ELM2_RESET                                  0x0
#define RXPCU_HW_BCN_PROC1_EXCLUDE_ELM1_LSB                                    6
#define RXPCU_HW_BCN_PROC1_EXCLUDE_ELM1_MSB                                    6
#define RXPCU_HW_BCN_PROC1_EXCLUDE_ELM1_MASK                                   0x40
#define RXPCU_HW_BCN_PROC1_EXCLUDE_ELM1_GET(x)                                 (((x) & RXPCU_HW_BCN_PROC1_EXCLUDE_ELM1_MASK) >> RXPCU_HW_BCN_PROC1_EXCLUDE_ELM1_LSB)
#define RXPCU_HW_BCN_PROC1_EXCLUDE_ELM1_SET(x)                                 (((0 | (x)) << RXPCU_HW_BCN_PROC1_EXCLUDE_ELM1_LSB) & RXPCU_HW_BCN_PROC1_EXCLUDE_ELM1_MASK)
#define RXPCU_HW_BCN_PROC1_EXCLUDE_ELM1_RESET                                  0x0
#define RXPCU_HW_BCN_PROC1_EXCLUDE_ELM0_LSB                                    5
#define RXPCU_HW_BCN_PROC1_EXCLUDE_ELM0_MSB                                    5
#define RXPCU_HW_BCN_PROC1_EXCLUDE_ELM0_MASK                                   0x20
#define RXPCU_HW_BCN_PROC1_EXCLUDE_ELM0_GET(x)                                 (((x) & RXPCU_HW_BCN_PROC1_EXCLUDE_ELM0_MASK) >> RXPCU_HW_BCN_PROC1_EXCLUDE_ELM0_LSB)
#define RXPCU_HW_BCN_PROC1_EXCLUDE_ELM0_SET(x)                                 (((0 | (x)) << RXPCU_HW_BCN_PROC1_EXCLUDE_ELM0_LSB) & RXPCU_HW_BCN_PROC1_EXCLUDE_ELM0_MASK)
#define RXPCU_HW_BCN_PROC1_EXCLUDE_ELM0_RESET                                  0x0
#define RXPCU_HW_BCN_PROC1_EXCLUDE_TIM_ELM_LSB                                 4
#define RXPCU_HW_BCN_PROC1_EXCLUDE_TIM_ELM_MSB                                 4
#define RXPCU_HW_BCN_PROC1_EXCLUDE_TIM_ELM_MASK                                0x10
#define RXPCU_HW_BCN_PROC1_EXCLUDE_TIM_ELM_GET(x)                              (((x) & RXPCU_HW_BCN_PROC1_EXCLUDE_TIM_ELM_MASK) >> RXPCU_HW_BCN_PROC1_EXCLUDE_TIM_ELM_LSB)
#define RXPCU_HW_BCN_PROC1_EXCLUDE_TIM_ELM_SET(x)                              (((0 | (x)) << RXPCU_HW_BCN_PROC1_EXCLUDE_TIM_ELM_LSB) & RXPCU_HW_BCN_PROC1_EXCLUDE_TIM_ELM_MASK)
#define RXPCU_HW_BCN_PROC1_EXCLUDE_TIM_ELM_RESET                               0x0
#define RXPCU_HW_BCN_PROC1_EXCLUDE_CAP_INFO_LSB                                3
#define RXPCU_HW_BCN_PROC1_EXCLUDE_CAP_INFO_MSB                                3
#define RXPCU_HW_BCN_PROC1_EXCLUDE_CAP_INFO_MASK                               0x8
#define RXPCU_HW_BCN_PROC1_EXCLUDE_CAP_INFO_GET(x)                             (((x) & RXPCU_HW_BCN_PROC1_EXCLUDE_CAP_INFO_MASK) >> RXPCU_HW_BCN_PROC1_EXCLUDE_CAP_INFO_LSB)
#define RXPCU_HW_BCN_PROC1_EXCLUDE_CAP_INFO_SET(x)                             (((0 | (x)) << RXPCU_HW_BCN_PROC1_EXCLUDE_CAP_INFO_LSB) & RXPCU_HW_BCN_PROC1_EXCLUDE_CAP_INFO_MASK)
#define RXPCU_HW_BCN_PROC1_EXCLUDE_CAP_INFO_RESET                              0x0
#define RXPCU_HW_BCN_PROC1_EXCLUDE_BCN_INTVL_LSB                               2
#define RXPCU_HW_BCN_PROC1_EXCLUDE_BCN_INTVL_MSB                               2
#define RXPCU_HW_BCN_PROC1_EXCLUDE_BCN_INTVL_MASK                              0x4
#define RXPCU_HW_BCN_PROC1_EXCLUDE_BCN_INTVL_GET(x)                            (((x) & RXPCU_HW_BCN_PROC1_EXCLUDE_BCN_INTVL_MASK) >> RXPCU_HW_BCN_PROC1_EXCLUDE_BCN_INTVL_LSB)
#define RXPCU_HW_BCN_PROC1_EXCLUDE_BCN_INTVL_SET(x)                            (((0 | (x)) << RXPCU_HW_BCN_PROC1_EXCLUDE_BCN_INTVL_LSB) & RXPCU_HW_BCN_PROC1_EXCLUDE_BCN_INTVL_MASK)
#define RXPCU_HW_BCN_PROC1_EXCLUDE_BCN_INTVL_RESET                             0x0
#define RXPCU_HW_BCN_PROC1_RESET_CRC_LSB                                       1
#define RXPCU_HW_BCN_PROC1_RESET_CRC_MSB                                       1
#define RXPCU_HW_BCN_PROC1_RESET_CRC_MASK                                      0x2
#define RXPCU_HW_BCN_PROC1_RESET_CRC_GET(x)                                    (((x) & RXPCU_HW_BCN_PROC1_RESET_CRC_MASK) >> RXPCU_HW_BCN_PROC1_RESET_CRC_LSB)
#define RXPCU_HW_BCN_PROC1_RESET_CRC_SET(x)                                    (((0 | (x)) << RXPCU_HW_BCN_PROC1_RESET_CRC_LSB) & RXPCU_HW_BCN_PROC1_RESET_CRC_MASK)
#define RXPCU_HW_BCN_PROC1_RESET_CRC_RESET                                     0x0
#define RXPCU_HW_BCN_PROC1_CRC_ENABLE_LSB                                      0
#define RXPCU_HW_BCN_PROC1_CRC_ENABLE_MSB                                      0
#define RXPCU_HW_BCN_PROC1_CRC_ENABLE_MASK                                     0x1
#define RXPCU_HW_BCN_PROC1_CRC_ENABLE_GET(x)                                   (((x) & RXPCU_HW_BCN_PROC1_CRC_ENABLE_MASK) >> RXPCU_HW_BCN_PROC1_CRC_ENABLE_LSB)
#define RXPCU_HW_BCN_PROC1_CRC_ENABLE_SET(x)                                   (((0 | (x)) << RXPCU_HW_BCN_PROC1_CRC_ENABLE_LSB) & RXPCU_HW_BCN_PROC1_CRC_ENABLE_MASK)
#define RXPCU_HW_BCN_PROC1_CRC_ENABLE_RESET                                    0x0
#define RXPCU_HW_BCN_PROC1_ADDRESS                                             (0x7c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_HW_BCN_PROC1_RSTMASK                                             0xffffffff
#define RXPCU_HW_BCN_PROC1_RESET                                               0x0

// 0x80 (RXPCU_HW_BCN_PROC2)
#define RXPCU_HW_BCN_PROC2_ELM3_ID_LSB                                         16
#define RXPCU_HW_BCN_PROC2_ELM3_ID_MSB                                         23
#define RXPCU_HW_BCN_PROC2_ELM3_ID_MASK                                        0xff0000
#define RXPCU_HW_BCN_PROC2_ELM3_ID_GET(x)                                      (((x) & RXPCU_HW_BCN_PROC2_ELM3_ID_MASK) >> RXPCU_HW_BCN_PROC2_ELM3_ID_LSB)
#define RXPCU_HW_BCN_PROC2_ELM3_ID_SET(x)                                      (((0 | (x)) << RXPCU_HW_BCN_PROC2_ELM3_ID_LSB) & RXPCU_HW_BCN_PROC2_ELM3_ID_MASK)
#define RXPCU_HW_BCN_PROC2_ELM3_ID_RESET                                       0x0
#define RXPCU_HW_BCN_PROC2_FILTER_INTERVAL_LSB                                 8
#define RXPCU_HW_BCN_PROC2_FILTER_INTERVAL_MSB                                 15
#define RXPCU_HW_BCN_PROC2_FILTER_INTERVAL_MASK                                0xff00
#define RXPCU_HW_BCN_PROC2_FILTER_INTERVAL_GET(x)                              (((x) & RXPCU_HW_BCN_PROC2_FILTER_INTERVAL_MASK) >> RXPCU_HW_BCN_PROC2_FILTER_INTERVAL_LSB)
#define RXPCU_HW_BCN_PROC2_FILTER_INTERVAL_SET(x)                              (((0 | (x)) << RXPCU_HW_BCN_PROC2_FILTER_INTERVAL_LSB) & RXPCU_HW_BCN_PROC2_FILTER_INTERVAL_MASK)
#define RXPCU_HW_BCN_PROC2_FILTER_INTERVAL_RESET                               0x2
#define RXPCU_HW_BCN_PROC2_EXCLUDE_ELM3_LSB                                    2
#define RXPCU_HW_BCN_PROC2_EXCLUDE_ELM3_MSB                                    2
#define RXPCU_HW_BCN_PROC2_EXCLUDE_ELM3_MASK                                   0x4
#define RXPCU_HW_BCN_PROC2_EXCLUDE_ELM3_GET(x)                                 (((x) & RXPCU_HW_BCN_PROC2_EXCLUDE_ELM3_MASK) >> RXPCU_HW_BCN_PROC2_EXCLUDE_ELM3_LSB)
#define RXPCU_HW_BCN_PROC2_EXCLUDE_ELM3_SET(x)                                 (((0 | (x)) << RXPCU_HW_BCN_PROC2_EXCLUDE_ELM3_LSB) & RXPCU_HW_BCN_PROC2_EXCLUDE_ELM3_MASK)
#define RXPCU_HW_BCN_PROC2_EXCLUDE_ELM3_RESET                                  0x0
#define RXPCU_HW_BCN_PROC2_RESET_INTERVAL_LSB                                  1
#define RXPCU_HW_BCN_PROC2_RESET_INTERVAL_MSB                                  1
#define RXPCU_HW_BCN_PROC2_RESET_INTERVAL_MASK                                 0x2
#define RXPCU_HW_BCN_PROC2_RESET_INTERVAL_GET(x)                               (((x) & RXPCU_HW_BCN_PROC2_RESET_INTERVAL_MASK) >> RXPCU_HW_BCN_PROC2_RESET_INTERVAL_LSB)
#define RXPCU_HW_BCN_PROC2_RESET_INTERVAL_SET(x)                               (((0 | (x)) << RXPCU_HW_BCN_PROC2_RESET_INTERVAL_LSB) & RXPCU_HW_BCN_PROC2_RESET_INTERVAL_MASK)
#define RXPCU_HW_BCN_PROC2_RESET_INTERVAL_RESET                                0x0
#define RXPCU_HW_BCN_PROC2_FILTER_INTERVAL_ENABLE_LSB                          0
#define RXPCU_HW_BCN_PROC2_FILTER_INTERVAL_ENABLE_MSB                          0
#define RXPCU_HW_BCN_PROC2_FILTER_INTERVAL_ENABLE_MASK                         0x1
#define RXPCU_HW_BCN_PROC2_FILTER_INTERVAL_ENABLE_GET(x)                       (((x) & RXPCU_HW_BCN_PROC2_FILTER_INTERVAL_ENABLE_MASK) >> RXPCU_HW_BCN_PROC2_FILTER_INTERVAL_ENABLE_LSB)
#define RXPCU_HW_BCN_PROC2_FILTER_INTERVAL_ENABLE_SET(x)                       (((0 | (x)) << RXPCU_HW_BCN_PROC2_FILTER_INTERVAL_ENABLE_LSB) & RXPCU_HW_BCN_PROC2_FILTER_INTERVAL_ENABLE_MASK)
#define RXPCU_HW_BCN_PROC2_FILTER_INTERVAL_ENABLE_RESET                        0x0
#define RXPCU_HW_BCN_PROC2_ADDRESS                                             (0x80 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_HW_BCN_PROC2_RSTMASK                                             0xffff07
#define RXPCU_HW_BCN_PROC2_RESET                                               0x200

// 0x84 (RXPCU_DYM_MIMO_PWR_SAVE)
#define RXPCU_DYM_MIMO_PWR_SAVE_HI_PWR_CHAIN_MASK_LSB                          8
#define RXPCU_DYM_MIMO_PWR_SAVE_HI_PWR_CHAIN_MASK_MSB                          10
#define RXPCU_DYM_MIMO_PWR_SAVE_HI_PWR_CHAIN_MASK_MASK                         0x700
#define RXPCU_DYM_MIMO_PWR_SAVE_HI_PWR_CHAIN_MASK_GET(x)                       (((x) & RXPCU_DYM_MIMO_PWR_SAVE_HI_PWR_CHAIN_MASK_MASK) >> RXPCU_DYM_MIMO_PWR_SAVE_HI_PWR_CHAIN_MASK_LSB)
#define RXPCU_DYM_MIMO_PWR_SAVE_HI_PWR_CHAIN_MASK_SET(x)                       (((0 | (x)) << RXPCU_DYM_MIMO_PWR_SAVE_HI_PWR_CHAIN_MASK_LSB) & RXPCU_DYM_MIMO_PWR_SAVE_HI_PWR_CHAIN_MASK_MASK)
#define RXPCU_DYM_MIMO_PWR_SAVE_HI_PWR_CHAIN_MASK_RESET                        0x3
#define RXPCU_DYM_MIMO_PWR_SAVE_LOW_PWR_CHAIN_MASK_LSB                         4
#define RXPCU_DYM_MIMO_PWR_SAVE_LOW_PWR_CHAIN_MASK_MSB                         6
#define RXPCU_DYM_MIMO_PWR_SAVE_LOW_PWR_CHAIN_MASK_MASK                        0x70
#define RXPCU_DYM_MIMO_PWR_SAVE_LOW_PWR_CHAIN_MASK_GET(x)                      (((x) & RXPCU_DYM_MIMO_PWR_SAVE_LOW_PWR_CHAIN_MASK_MASK) >> RXPCU_DYM_MIMO_PWR_SAVE_LOW_PWR_CHAIN_MASK_LSB)
#define RXPCU_DYM_MIMO_PWR_SAVE_LOW_PWR_CHAIN_MASK_SET(x)                      (((0 | (x)) << RXPCU_DYM_MIMO_PWR_SAVE_LOW_PWR_CHAIN_MASK_LSB) & RXPCU_DYM_MIMO_PWR_SAVE_LOW_PWR_CHAIN_MASK_MASK)
#define RXPCU_DYM_MIMO_PWR_SAVE_LOW_PWR_CHAIN_MASK_RESET                       0x1
#define RXPCU_DYM_MIMO_PWR_SAVE_SW_CHAIN_MASK_SEL_LSB                          2
#define RXPCU_DYM_MIMO_PWR_SAVE_SW_CHAIN_MASK_SEL_MSB                          2
#define RXPCU_DYM_MIMO_PWR_SAVE_SW_CHAIN_MASK_SEL_MASK                         0x4
#define RXPCU_DYM_MIMO_PWR_SAVE_SW_CHAIN_MASK_SEL_GET(x)                       (((x) & RXPCU_DYM_MIMO_PWR_SAVE_SW_CHAIN_MASK_SEL_MASK) >> RXPCU_DYM_MIMO_PWR_SAVE_SW_CHAIN_MASK_SEL_LSB)
#define RXPCU_DYM_MIMO_PWR_SAVE_SW_CHAIN_MASK_SEL_SET(x)                       (((0 | (x)) << RXPCU_DYM_MIMO_PWR_SAVE_SW_CHAIN_MASK_SEL_LSB) & RXPCU_DYM_MIMO_PWR_SAVE_SW_CHAIN_MASK_SEL_MASK)
#define RXPCU_DYM_MIMO_PWR_SAVE_SW_CHAIN_MASK_SEL_RESET                        0x0
#define RXPCU_DYM_MIMO_PWR_SAVE_HW_CTRL_EN_LSB                                 1
#define RXPCU_DYM_MIMO_PWR_SAVE_HW_CTRL_EN_MSB                                 1
#define RXPCU_DYM_MIMO_PWR_SAVE_HW_CTRL_EN_MASK                                0x2
#define RXPCU_DYM_MIMO_PWR_SAVE_HW_CTRL_EN_GET(x)                              (((x) & RXPCU_DYM_MIMO_PWR_SAVE_HW_CTRL_EN_MASK) >> RXPCU_DYM_MIMO_PWR_SAVE_HW_CTRL_EN_LSB)
#define RXPCU_DYM_MIMO_PWR_SAVE_HW_CTRL_EN_SET(x)                              (((0 | (x)) << RXPCU_DYM_MIMO_PWR_SAVE_HW_CTRL_EN_LSB) & RXPCU_DYM_MIMO_PWR_SAVE_HW_CTRL_EN_MASK)
#define RXPCU_DYM_MIMO_PWR_SAVE_HW_CTRL_EN_RESET                               0x0
#define RXPCU_DYM_MIMO_PWR_SAVE_USE_MAC_CTRL_LSB                               0
#define RXPCU_DYM_MIMO_PWR_SAVE_USE_MAC_CTRL_MSB                               0
#define RXPCU_DYM_MIMO_PWR_SAVE_USE_MAC_CTRL_MASK                              0x1
#define RXPCU_DYM_MIMO_PWR_SAVE_USE_MAC_CTRL_GET(x)                            (((x) & RXPCU_DYM_MIMO_PWR_SAVE_USE_MAC_CTRL_MASK) >> RXPCU_DYM_MIMO_PWR_SAVE_USE_MAC_CTRL_LSB)
#define RXPCU_DYM_MIMO_PWR_SAVE_USE_MAC_CTRL_SET(x)                            (((0 | (x)) << RXPCU_DYM_MIMO_PWR_SAVE_USE_MAC_CTRL_LSB) & RXPCU_DYM_MIMO_PWR_SAVE_USE_MAC_CTRL_MASK)
#define RXPCU_DYM_MIMO_PWR_SAVE_USE_MAC_CTRL_RESET                             0x0
#define RXPCU_DYM_MIMO_PWR_SAVE_ADDRESS                                        (0x84 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_DYM_MIMO_PWR_SAVE_RSTMASK                                        0x777
#define RXPCU_DYM_MIMO_PWR_SAVE_RESET                                          0x310

// 0x88 (RXPCU_POWER_SAVE_0)
#define RXPCU_POWER_SAVE_0_PHY_ON_OFF_DELAY_LSB                                20
#define RXPCU_POWER_SAVE_0_PHY_ON_OFF_DELAY_MSB                                31
#define RXPCU_POWER_SAVE_0_PHY_ON_OFF_DELAY_MASK                               0xfff00000
#define RXPCU_POWER_SAVE_0_PHY_ON_OFF_DELAY_GET(x)                             (((x) & RXPCU_POWER_SAVE_0_PHY_ON_OFF_DELAY_MASK) >> RXPCU_POWER_SAVE_0_PHY_ON_OFF_DELAY_LSB)
#define RXPCU_POWER_SAVE_0_PHY_ON_OFF_DELAY_SET(x)                             (((0 | (x)) << RXPCU_POWER_SAVE_0_PHY_ON_OFF_DELAY_LSB) & RXPCU_POWER_SAVE_0_PHY_ON_OFF_DELAY_MASK)
#define RXPCU_POWER_SAVE_0_PHY_ON_OFF_DELAY_RESET                              0xc8
#define RXPCU_POWER_SAVE_0_CONSIDER_FILTER_PASS_LSB                            14
#define RXPCU_POWER_SAVE_0_CONSIDER_FILTER_PASS_MSB                            14
#define RXPCU_POWER_SAVE_0_CONSIDER_FILTER_PASS_MASK                           0x4000
#define RXPCU_POWER_SAVE_0_CONSIDER_FILTER_PASS_GET(x)                         (((x) & RXPCU_POWER_SAVE_0_CONSIDER_FILTER_PASS_MASK) >> RXPCU_POWER_SAVE_0_CONSIDER_FILTER_PASS_LSB)
#define RXPCU_POWER_SAVE_0_CONSIDER_FILTER_PASS_SET(x)                         (((0 | (x)) << RXPCU_POWER_SAVE_0_CONSIDER_FILTER_PASS_LSB) & RXPCU_POWER_SAVE_0_CONSIDER_FILTER_PASS_MASK)
#define RXPCU_POWER_SAVE_0_CONSIDER_FILTER_PASS_RESET                          0x0
#define RXPCU_POWER_SAVE_0_ADDR_MISMATCH_DATA_ENABLE_LSB                       13
#define RXPCU_POWER_SAVE_0_ADDR_MISMATCH_DATA_ENABLE_MSB                       13
#define RXPCU_POWER_SAVE_0_ADDR_MISMATCH_DATA_ENABLE_MASK                      0x2000
#define RXPCU_POWER_SAVE_0_ADDR_MISMATCH_DATA_ENABLE_GET(x)                    (((x) & RXPCU_POWER_SAVE_0_ADDR_MISMATCH_DATA_ENABLE_MASK) >> RXPCU_POWER_SAVE_0_ADDR_MISMATCH_DATA_ENABLE_LSB)
#define RXPCU_POWER_SAVE_0_ADDR_MISMATCH_DATA_ENABLE_SET(x)                    (((0 | (x)) << RXPCU_POWER_SAVE_0_ADDR_MISMATCH_DATA_ENABLE_LSB) & RXPCU_POWER_SAVE_0_ADDR_MISMATCH_DATA_ENABLE_MASK)
#define RXPCU_POWER_SAVE_0_ADDR_MISMATCH_DATA_ENABLE_RESET                     0x0
#define RXPCU_POWER_SAVE_0_ADDR_MISMATCH_MGMT_ENABLE_LSB                       12
#define RXPCU_POWER_SAVE_0_ADDR_MISMATCH_MGMT_ENABLE_MSB                       12
#define RXPCU_POWER_SAVE_0_ADDR_MISMATCH_MGMT_ENABLE_MASK                      0x1000
#define RXPCU_POWER_SAVE_0_ADDR_MISMATCH_MGMT_ENABLE_GET(x)                    (((x) & RXPCU_POWER_SAVE_0_ADDR_MISMATCH_MGMT_ENABLE_MASK) >> RXPCU_POWER_SAVE_0_ADDR_MISMATCH_MGMT_ENABLE_LSB)
#define RXPCU_POWER_SAVE_0_ADDR_MISMATCH_MGMT_ENABLE_SET(x)                    (((0 | (x)) << RXPCU_POWER_SAVE_0_ADDR_MISMATCH_MGMT_ENABLE_LSB) & RXPCU_POWER_SAVE_0_ADDR_MISMATCH_MGMT_ENABLE_MASK)
#define RXPCU_POWER_SAVE_0_ADDR_MISMATCH_MGMT_ENABLE_RESET                     0x0
#define RXPCU_POWER_SAVE_0_ADDR_MISMATCH_CNTL_ENABLE_LSB                       11
#define RXPCU_POWER_SAVE_0_ADDR_MISMATCH_CNTL_ENABLE_MSB                       11
#define RXPCU_POWER_SAVE_0_ADDR_MISMATCH_CNTL_ENABLE_MASK                      0x800
#define RXPCU_POWER_SAVE_0_ADDR_MISMATCH_CNTL_ENABLE_GET(x)                    (((x) & RXPCU_POWER_SAVE_0_ADDR_MISMATCH_CNTL_ENABLE_MASK) >> RXPCU_POWER_SAVE_0_ADDR_MISMATCH_CNTL_ENABLE_LSB)
#define RXPCU_POWER_SAVE_0_ADDR_MISMATCH_CNTL_ENABLE_SET(x)                    (((0 | (x)) << RXPCU_POWER_SAVE_0_ADDR_MISMATCH_CNTL_ENABLE_LSB) & RXPCU_POWER_SAVE_0_ADDR_MISMATCH_CNTL_ENABLE_MASK)
#define RXPCU_POWER_SAVE_0_ADDR_MISMATCH_CNTL_ENABLE_RESET                     0x0
#define RXPCU_POWER_SAVE_0_PHY_NAP_EIFS_ENABLE_LSB                             10
#define RXPCU_POWER_SAVE_0_PHY_NAP_EIFS_ENABLE_MSB                             10
#define RXPCU_POWER_SAVE_0_PHY_NAP_EIFS_ENABLE_MASK                            0x400
#define RXPCU_POWER_SAVE_0_PHY_NAP_EIFS_ENABLE_GET(x)                          (((x) & RXPCU_POWER_SAVE_0_PHY_NAP_EIFS_ENABLE_MASK) >> RXPCU_POWER_SAVE_0_PHY_NAP_EIFS_ENABLE_LSB)
#define RXPCU_POWER_SAVE_0_PHY_NAP_EIFS_ENABLE_SET(x)                          (((0 | (x)) << RXPCU_POWER_SAVE_0_PHY_NAP_EIFS_ENABLE_LSB) & RXPCU_POWER_SAVE_0_PHY_NAP_EIFS_ENABLE_MASK)
#define RXPCU_POWER_SAVE_0_PHY_NAP_EIFS_ENABLE_RESET                           0x0
#define RXPCU_POWER_SAVE_0_RSSI_CHECK_ENABLE_LSB                               9
#define RXPCU_POWER_SAVE_0_RSSI_CHECK_ENABLE_MSB                               9
#define RXPCU_POWER_SAVE_0_RSSI_CHECK_ENABLE_MASK                              0x200
#define RXPCU_POWER_SAVE_0_RSSI_CHECK_ENABLE_GET(x)                            (((x) & RXPCU_POWER_SAVE_0_RSSI_CHECK_ENABLE_MASK) >> RXPCU_POWER_SAVE_0_RSSI_CHECK_ENABLE_LSB)
#define RXPCU_POWER_SAVE_0_RSSI_CHECK_ENABLE_SET(x)                            (((0 | (x)) << RXPCU_POWER_SAVE_0_RSSI_CHECK_ENABLE_LSB) & RXPCU_POWER_SAVE_0_RSSI_CHECK_ENABLE_MASK)
#define RXPCU_POWER_SAVE_0_RSSI_CHECK_ENABLE_RESET                             0x0
#define RXPCU_POWER_SAVE_0_GID_NSTS_ZERO_ENABLE_LSB                            8
#define RXPCU_POWER_SAVE_0_GID_NSTS_ZERO_ENABLE_MSB                            8
#define RXPCU_POWER_SAVE_0_GID_NSTS_ZERO_ENABLE_MASK                           0x100
#define RXPCU_POWER_SAVE_0_GID_NSTS_ZERO_ENABLE_GET(x)                         (((x) & RXPCU_POWER_SAVE_0_GID_NSTS_ZERO_ENABLE_MASK) >> RXPCU_POWER_SAVE_0_GID_NSTS_ZERO_ENABLE_LSB)
#define RXPCU_POWER_SAVE_0_GID_NSTS_ZERO_ENABLE_SET(x)                         (((0 | (x)) << RXPCU_POWER_SAVE_0_GID_NSTS_ZERO_ENABLE_LSB) & RXPCU_POWER_SAVE_0_GID_NSTS_ZERO_ENABLE_MASK)
#define RXPCU_POWER_SAVE_0_GID_NSTS_ZERO_ENABLE_RESET                          0x0
#define RXPCU_POWER_SAVE_0_DELIMITER_CRC_FAIL_ENABLE_LSB                       7
#define RXPCU_POWER_SAVE_0_DELIMITER_CRC_FAIL_ENABLE_MSB                       7
#define RXPCU_POWER_SAVE_0_DELIMITER_CRC_FAIL_ENABLE_MASK                      0x80
#define RXPCU_POWER_SAVE_0_DELIMITER_CRC_FAIL_ENABLE_GET(x)                    (((x) & RXPCU_POWER_SAVE_0_DELIMITER_CRC_FAIL_ENABLE_MASK) >> RXPCU_POWER_SAVE_0_DELIMITER_CRC_FAIL_ENABLE_LSB)
#define RXPCU_POWER_SAVE_0_DELIMITER_CRC_FAIL_ENABLE_SET(x)                    (((0 | (x)) << RXPCU_POWER_SAVE_0_DELIMITER_CRC_FAIL_ENABLE_LSB) & RXPCU_POWER_SAVE_0_DELIMITER_CRC_FAIL_ENABLE_MASK)
#define RXPCU_POWER_SAVE_0_DELIMITER_CRC_FAIL_ENABLE_RESET                     0x0
#define RXPCU_POWER_SAVE_0_MAC_ADDRESS_MISMATCH_ENABLE_LSB                     6
#define RXPCU_POWER_SAVE_0_MAC_ADDRESS_MISMATCH_ENABLE_MSB                     6
#define RXPCU_POWER_SAVE_0_MAC_ADDRESS_MISMATCH_ENABLE_MASK                    0x40
#define RXPCU_POWER_SAVE_0_MAC_ADDRESS_MISMATCH_ENABLE_GET(x)                  (((x) & RXPCU_POWER_SAVE_0_MAC_ADDRESS_MISMATCH_ENABLE_MASK) >> RXPCU_POWER_SAVE_0_MAC_ADDRESS_MISMATCH_ENABLE_LSB)
#define RXPCU_POWER_SAVE_0_MAC_ADDRESS_MISMATCH_ENABLE_SET(x)                  (((0 | (x)) << RXPCU_POWER_SAVE_0_MAC_ADDRESS_MISMATCH_ENABLE_LSB) & RXPCU_POWER_SAVE_0_MAC_ADDRESS_MISMATCH_ENABLE_MASK)
#define RXPCU_POWER_SAVE_0_MAC_ADDRESS_MISMATCH_ENABLE_RESET                   0x0
#define RXPCU_POWER_SAVE_0_EARLY_DTIM_CLEAR_ENABLE_LSB                         4
#define RXPCU_POWER_SAVE_0_EARLY_DTIM_CLEAR_ENABLE_MSB                         4
#define RXPCU_POWER_SAVE_0_EARLY_DTIM_CLEAR_ENABLE_MASK                        0x10
#define RXPCU_POWER_SAVE_0_EARLY_DTIM_CLEAR_ENABLE_GET(x)                      (((x) & RXPCU_POWER_SAVE_0_EARLY_DTIM_CLEAR_ENABLE_MASK) >> RXPCU_POWER_SAVE_0_EARLY_DTIM_CLEAR_ENABLE_LSB)
#define RXPCU_POWER_SAVE_0_EARLY_DTIM_CLEAR_ENABLE_SET(x)                      (((0 | (x)) << RXPCU_POWER_SAVE_0_EARLY_DTIM_CLEAR_ENABLE_LSB) & RXPCU_POWER_SAVE_0_EARLY_DTIM_CLEAR_ENABLE_MASK)
#define RXPCU_POWER_SAVE_0_EARLY_DTIM_CLEAR_ENABLE_RESET                       0x0
#define RXPCU_POWER_SAVE_0_EARLY_TIM_CLEAR_ENABLE_LSB                          3
#define RXPCU_POWER_SAVE_0_EARLY_TIM_CLEAR_ENABLE_MSB                          3
#define RXPCU_POWER_SAVE_0_EARLY_TIM_CLEAR_ENABLE_MASK                         0x8
#define RXPCU_POWER_SAVE_0_EARLY_TIM_CLEAR_ENABLE_GET(x)                       (((x) & RXPCU_POWER_SAVE_0_EARLY_TIM_CLEAR_ENABLE_MASK) >> RXPCU_POWER_SAVE_0_EARLY_TIM_CLEAR_ENABLE_LSB)
#define RXPCU_POWER_SAVE_0_EARLY_TIM_CLEAR_ENABLE_SET(x)                       (((0 | (x)) << RXPCU_POWER_SAVE_0_EARLY_TIM_CLEAR_ENABLE_LSB) & RXPCU_POWER_SAVE_0_EARLY_TIM_CLEAR_ENABLE_MASK)
#define RXPCU_POWER_SAVE_0_EARLY_TIM_CLEAR_ENABLE_RESET                        0x0
#define RXPCU_POWER_SAVE_0_EOF_PAD_DELIMITER_ENABLE_LSB                        2
#define RXPCU_POWER_SAVE_0_EOF_PAD_DELIMITER_ENABLE_MSB                        2
#define RXPCU_POWER_SAVE_0_EOF_PAD_DELIMITER_ENABLE_MASK                       0x4
#define RXPCU_POWER_SAVE_0_EOF_PAD_DELIMITER_ENABLE_GET(x)                     (((x) & RXPCU_POWER_SAVE_0_EOF_PAD_DELIMITER_ENABLE_MASK) >> RXPCU_POWER_SAVE_0_EOF_PAD_DELIMITER_ENABLE_LSB)
#define RXPCU_POWER_SAVE_0_EOF_PAD_DELIMITER_ENABLE_SET(x)                     (((0 | (x)) << RXPCU_POWER_SAVE_0_EOF_PAD_DELIMITER_ENABLE_LSB) & RXPCU_POWER_SAVE_0_EOF_PAD_DELIMITER_ENABLE_MASK)
#define RXPCU_POWER_SAVE_0_EOF_PAD_DELIMITER_ENABLE_RESET                      0x0
#define RXPCU_POWER_SAVE_0_GID_MATCH_ENABLE_LSB                                1
#define RXPCU_POWER_SAVE_0_GID_MATCH_ENABLE_MSB                                1
#define RXPCU_POWER_SAVE_0_GID_MATCH_ENABLE_MASK                               0x2
#define RXPCU_POWER_SAVE_0_GID_MATCH_ENABLE_GET(x)                             (((x) & RXPCU_POWER_SAVE_0_GID_MATCH_ENABLE_MASK) >> RXPCU_POWER_SAVE_0_GID_MATCH_ENABLE_LSB)
#define RXPCU_POWER_SAVE_0_GID_MATCH_ENABLE_SET(x)                             (((0 | (x)) << RXPCU_POWER_SAVE_0_GID_MATCH_ENABLE_LSB) & RXPCU_POWER_SAVE_0_GID_MATCH_ENABLE_MASK)
#define RXPCU_POWER_SAVE_0_GID_MATCH_ENABLE_RESET                              0x0
#define RXPCU_POWER_SAVE_0_PARTIAL_AID_MATCH_ENABLE_LSB                        0
#define RXPCU_POWER_SAVE_0_PARTIAL_AID_MATCH_ENABLE_MSB                        0
#define RXPCU_POWER_SAVE_0_PARTIAL_AID_MATCH_ENABLE_MASK                       0x1
#define RXPCU_POWER_SAVE_0_PARTIAL_AID_MATCH_ENABLE_GET(x)                     (((x) & RXPCU_POWER_SAVE_0_PARTIAL_AID_MATCH_ENABLE_MASK) >> RXPCU_POWER_SAVE_0_PARTIAL_AID_MATCH_ENABLE_LSB)
#define RXPCU_POWER_SAVE_0_PARTIAL_AID_MATCH_ENABLE_SET(x)                     (((0 | (x)) << RXPCU_POWER_SAVE_0_PARTIAL_AID_MATCH_ENABLE_LSB) & RXPCU_POWER_SAVE_0_PARTIAL_AID_MATCH_ENABLE_MASK)
#define RXPCU_POWER_SAVE_0_PARTIAL_AID_MATCH_ENABLE_RESET                      0x0
#define RXPCU_POWER_SAVE_0_ADDRESS                                             (0x88 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_POWER_SAVE_0_RSTMASK                                             0xfff07fdf
#define RXPCU_POWER_SAVE_0_RESET                                               0xc800000

// 0x8c (RXPCU_POWER_SAVE_1)
#define RXPCU_POWER_SAVE_1_P_AID_2_MATCH_EN_LSB                                29
#define RXPCU_POWER_SAVE_1_P_AID_2_MATCH_EN_MSB                                29
#define RXPCU_POWER_SAVE_1_P_AID_2_MATCH_EN_MASK                               0x20000000
#define RXPCU_POWER_SAVE_1_P_AID_2_MATCH_EN_GET(x)                             (((x) & RXPCU_POWER_SAVE_1_P_AID_2_MATCH_EN_MASK) >> RXPCU_POWER_SAVE_1_P_AID_2_MATCH_EN_LSB)
#define RXPCU_POWER_SAVE_1_P_AID_2_MATCH_EN_SET(x)                             (((0 | (x)) << RXPCU_POWER_SAVE_1_P_AID_2_MATCH_EN_LSB) & RXPCU_POWER_SAVE_1_P_AID_2_MATCH_EN_MASK)
#define RXPCU_POWER_SAVE_1_P_AID_2_MATCH_EN_RESET                              0x0
#define RXPCU_POWER_SAVE_1_P_AID_2_MATCH_VALUE_LSB                             20
#define RXPCU_POWER_SAVE_1_P_AID_2_MATCH_VALUE_MSB                             28
#define RXPCU_POWER_SAVE_1_P_AID_2_MATCH_VALUE_MASK                            0x1ff00000
#define RXPCU_POWER_SAVE_1_P_AID_2_MATCH_VALUE_GET(x)                          (((x) & RXPCU_POWER_SAVE_1_P_AID_2_MATCH_VALUE_MASK) >> RXPCU_POWER_SAVE_1_P_AID_2_MATCH_VALUE_LSB)
#define RXPCU_POWER_SAVE_1_P_AID_2_MATCH_VALUE_SET(x)                          (((0 | (x)) << RXPCU_POWER_SAVE_1_P_AID_2_MATCH_VALUE_LSB) & RXPCU_POWER_SAVE_1_P_AID_2_MATCH_VALUE_MASK)
#define RXPCU_POWER_SAVE_1_P_AID_2_MATCH_VALUE_RESET                           0x0
#define RXPCU_POWER_SAVE_1_P_AID_1_MATCH_EN_LSB                                19
#define RXPCU_POWER_SAVE_1_P_AID_1_MATCH_EN_MSB                                19
#define RXPCU_POWER_SAVE_1_P_AID_1_MATCH_EN_MASK                               0x80000
#define RXPCU_POWER_SAVE_1_P_AID_1_MATCH_EN_GET(x)                             (((x) & RXPCU_POWER_SAVE_1_P_AID_1_MATCH_EN_MASK) >> RXPCU_POWER_SAVE_1_P_AID_1_MATCH_EN_LSB)
#define RXPCU_POWER_SAVE_1_P_AID_1_MATCH_EN_SET(x)                             (((0 | (x)) << RXPCU_POWER_SAVE_1_P_AID_1_MATCH_EN_LSB) & RXPCU_POWER_SAVE_1_P_AID_1_MATCH_EN_MASK)
#define RXPCU_POWER_SAVE_1_P_AID_1_MATCH_EN_RESET                              0x0
#define RXPCU_POWER_SAVE_1_P_AID_1_MATCH_VALUE_LSB                             10
#define RXPCU_POWER_SAVE_1_P_AID_1_MATCH_VALUE_MSB                             18
#define RXPCU_POWER_SAVE_1_P_AID_1_MATCH_VALUE_MASK                            0x7fc00
#define RXPCU_POWER_SAVE_1_P_AID_1_MATCH_VALUE_GET(x)                          (((x) & RXPCU_POWER_SAVE_1_P_AID_1_MATCH_VALUE_MASK) >> RXPCU_POWER_SAVE_1_P_AID_1_MATCH_VALUE_LSB)
#define RXPCU_POWER_SAVE_1_P_AID_1_MATCH_VALUE_SET(x)                          (((0 | (x)) << RXPCU_POWER_SAVE_1_P_AID_1_MATCH_VALUE_LSB) & RXPCU_POWER_SAVE_1_P_AID_1_MATCH_VALUE_MASK)
#define RXPCU_POWER_SAVE_1_P_AID_1_MATCH_VALUE_RESET                           0x0
#define RXPCU_POWER_SAVE_1_P_AID_0_MATCH_EN_LSB                                9
#define RXPCU_POWER_SAVE_1_P_AID_0_MATCH_EN_MSB                                9
#define RXPCU_POWER_SAVE_1_P_AID_0_MATCH_EN_MASK                               0x200
#define RXPCU_POWER_SAVE_1_P_AID_0_MATCH_EN_GET(x)                             (((x) & RXPCU_POWER_SAVE_1_P_AID_0_MATCH_EN_MASK) >> RXPCU_POWER_SAVE_1_P_AID_0_MATCH_EN_LSB)
#define RXPCU_POWER_SAVE_1_P_AID_0_MATCH_EN_SET(x)                             (((0 | (x)) << RXPCU_POWER_SAVE_1_P_AID_0_MATCH_EN_LSB) & RXPCU_POWER_SAVE_1_P_AID_0_MATCH_EN_MASK)
#define RXPCU_POWER_SAVE_1_P_AID_0_MATCH_EN_RESET                              0x0
#define RXPCU_POWER_SAVE_1_P_AID_0_MATCH_VALUE_LSB                             0
#define RXPCU_POWER_SAVE_1_P_AID_0_MATCH_VALUE_MSB                             8
#define RXPCU_POWER_SAVE_1_P_AID_0_MATCH_VALUE_MASK                            0x1ff
#define RXPCU_POWER_SAVE_1_P_AID_0_MATCH_VALUE_GET(x)                          (((x) & RXPCU_POWER_SAVE_1_P_AID_0_MATCH_VALUE_MASK) >> RXPCU_POWER_SAVE_1_P_AID_0_MATCH_VALUE_LSB)
#define RXPCU_POWER_SAVE_1_P_AID_0_MATCH_VALUE_SET(x)                          (((0 | (x)) << RXPCU_POWER_SAVE_1_P_AID_0_MATCH_VALUE_LSB) & RXPCU_POWER_SAVE_1_P_AID_0_MATCH_VALUE_MASK)
#define RXPCU_POWER_SAVE_1_P_AID_0_MATCH_VALUE_RESET                           0x0
#define RXPCU_POWER_SAVE_1_ADDRESS                                             (0x8c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_POWER_SAVE_1_RSTMASK                                             0x3fffffff
#define RXPCU_POWER_SAVE_1_RESET                                               0x0

// 0x90 (RXPCU_POWER_SAVE_2)
#define RXPCU_POWER_SAVE_2_P_AID_5_MATCH_EN_LSB                                29
#define RXPCU_POWER_SAVE_2_P_AID_5_MATCH_EN_MSB                                29
#define RXPCU_POWER_SAVE_2_P_AID_5_MATCH_EN_MASK                               0x20000000
#define RXPCU_POWER_SAVE_2_P_AID_5_MATCH_EN_GET(x)                             (((x) & RXPCU_POWER_SAVE_2_P_AID_5_MATCH_EN_MASK) >> RXPCU_POWER_SAVE_2_P_AID_5_MATCH_EN_LSB)
#define RXPCU_POWER_SAVE_2_P_AID_5_MATCH_EN_SET(x)                             (((0 | (x)) << RXPCU_POWER_SAVE_2_P_AID_5_MATCH_EN_LSB) & RXPCU_POWER_SAVE_2_P_AID_5_MATCH_EN_MASK)
#define RXPCU_POWER_SAVE_2_P_AID_5_MATCH_EN_RESET                              0x0
#define RXPCU_POWER_SAVE_2_P_AID_5_MATCH_VALUE_LSB                             20
#define RXPCU_POWER_SAVE_2_P_AID_5_MATCH_VALUE_MSB                             28
#define RXPCU_POWER_SAVE_2_P_AID_5_MATCH_VALUE_MASK                            0x1ff00000
#define RXPCU_POWER_SAVE_2_P_AID_5_MATCH_VALUE_GET(x)                          (((x) & RXPCU_POWER_SAVE_2_P_AID_5_MATCH_VALUE_MASK) >> RXPCU_POWER_SAVE_2_P_AID_5_MATCH_VALUE_LSB)
#define RXPCU_POWER_SAVE_2_P_AID_5_MATCH_VALUE_SET(x)                          (((0 | (x)) << RXPCU_POWER_SAVE_2_P_AID_5_MATCH_VALUE_LSB) & RXPCU_POWER_SAVE_2_P_AID_5_MATCH_VALUE_MASK)
#define RXPCU_POWER_SAVE_2_P_AID_5_MATCH_VALUE_RESET                           0x0
#define RXPCU_POWER_SAVE_2_P_AID_4_MATCH_EN_LSB                                19
#define RXPCU_POWER_SAVE_2_P_AID_4_MATCH_EN_MSB                                19
#define RXPCU_POWER_SAVE_2_P_AID_4_MATCH_EN_MASK                               0x80000
#define RXPCU_POWER_SAVE_2_P_AID_4_MATCH_EN_GET(x)                             (((x) & RXPCU_POWER_SAVE_2_P_AID_4_MATCH_EN_MASK) >> RXPCU_POWER_SAVE_2_P_AID_4_MATCH_EN_LSB)
#define RXPCU_POWER_SAVE_2_P_AID_4_MATCH_EN_SET(x)                             (((0 | (x)) << RXPCU_POWER_SAVE_2_P_AID_4_MATCH_EN_LSB) & RXPCU_POWER_SAVE_2_P_AID_4_MATCH_EN_MASK)
#define RXPCU_POWER_SAVE_2_P_AID_4_MATCH_EN_RESET                              0x0
#define RXPCU_POWER_SAVE_2_P_AID_4_MATCH_VALUE_LSB                             10
#define RXPCU_POWER_SAVE_2_P_AID_4_MATCH_VALUE_MSB                             18
#define RXPCU_POWER_SAVE_2_P_AID_4_MATCH_VALUE_MASK                            0x7fc00
#define RXPCU_POWER_SAVE_2_P_AID_4_MATCH_VALUE_GET(x)                          (((x) & RXPCU_POWER_SAVE_2_P_AID_4_MATCH_VALUE_MASK) >> RXPCU_POWER_SAVE_2_P_AID_4_MATCH_VALUE_LSB)
#define RXPCU_POWER_SAVE_2_P_AID_4_MATCH_VALUE_SET(x)                          (((0 | (x)) << RXPCU_POWER_SAVE_2_P_AID_4_MATCH_VALUE_LSB) & RXPCU_POWER_SAVE_2_P_AID_4_MATCH_VALUE_MASK)
#define RXPCU_POWER_SAVE_2_P_AID_4_MATCH_VALUE_RESET                           0x0
#define RXPCU_POWER_SAVE_2_P_AID_3_MATCH_EN_LSB                                9
#define RXPCU_POWER_SAVE_2_P_AID_3_MATCH_EN_MSB                                9
#define RXPCU_POWER_SAVE_2_P_AID_3_MATCH_EN_MASK                               0x200
#define RXPCU_POWER_SAVE_2_P_AID_3_MATCH_EN_GET(x)                             (((x) & RXPCU_POWER_SAVE_2_P_AID_3_MATCH_EN_MASK) >> RXPCU_POWER_SAVE_2_P_AID_3_MATCH_EN_LSB)
#define RXPCU_POWER_SAVE_2_P_AID_3_MATCH_EN_SET(x)                             (((0 | (x)) << RXPCU_POWER_SAVE_2_P_AID_3_MATCH_EN_LSB) & RXPCU_POWER_SAVE_2_P_AID_3_MATCH_EN_MASK)
#define RXPCU_POWER_SAVE_2_P_AID_3_MATCH_EN_RESET                              0x0
#define RXPCU_POWER_SAVE_2_P_AID_3_MATCH_VALUE_LSB                             0
#define RXPCU_POWER_SAVE_2_P_AID_3_MATCH_VALUE_MSB                             8
#define RXPCU_POWER_SAVE_2_P_AID_3_MATCH_VALUE_MASK                            0x1ff
#define RXPCU_POWER_SAVE_2_P_AID_3_MATCH_VALUE_GET(x)                          (((x) & RXPCU_POWER_SAVE_2_P_AID_3_MATCH_VALUE_MASK) >> RXPCU_POWER_SAVE_2_P_AID_3_MATCH_VALUE_LSB)
#define RXPCU_POWER_SAVE_2_P_AID_3_MATCH_VALUE_SET(x)                          (((0 | (x)) << RXPCU_POWER_SAVE_2_P_AID_3_MATCH_VALUE_LSB) & RXPCU_POWER_SAVE_2_P_AID_3_MATCH_VALUE_MASK)
#define RXPCU_POWER_SAVE_2_P_AID_3_MATCH_VALUE_RESET                           0x0
#define RXPCU_POWER_SAVE_2_ADDRESS                                             (0x90 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_POWER_SAVE_2_RSTMASK                                             0x3fffffff
#define RXPCU_POWER_SAVE_2_RESET                                               0x0

// 0x94 (RXPCU_POWER_SAVE_3)
#define RXPCU_POWER_SAVE_3_GID_LSB_BITMAP_VALUE_LSB                            0
#define RXPCU_POWER_SAVE_3_GID_LSB_BITMAP_VALUE_MSB                            31
#define RXPCU_POWER_SAVE_3_GID_LSB_BITMAP_VALUE_MASK                           0xffffffff
#define RXPCU_POWER_SAVE_3_GID_LSB_BITMAP_VALUE_GET(x)                         (((x) & RXPCU_POWER_SAVE_3_GID_LSB_BITMAP_VALUE_MASK) >> RXPCU_POWER_SAVE_3_GID_LSB_BITMAP_VALUE_LSB)
#define RXPCU_POWER_SAVE_3_GID_LSB_BITMAP_VALUE_SET(x)                         (((0 | (x)) << RXPCU_POWER_SAVE_3_GID_LSB_BITMAP_VALUE_LSB) & RXPCU_POWER_SAVE_3_GID_LSB_BITMAP_VALUE_MASK)
#define RXPCU_POWER_SAVE_3_GID_LSB_BITMAP_VALUE_RESET                          0x0
#define RXPCU_POWER_SAVE_3_ADDRESS                                             (0x94 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_POWER_SAVE_3_RSTMASK                                             0xffffffff
#define RXPCU_POWER_SAVE_3_RESET                                               0x0

// 0x98 (RXPCU_POWER_SAVE_4)
#define RXPCU_POWER_SAVE_4_GID_MSB_BITMAP_VALUE_LSB                            0
#define RXPCU_POWER_SAVE_4_GID_MSB_BITMAP_VALUE_MSB                            31
#define RXPCU_POWER_SAVE_4_GID_MSB_BITMAP_VALUE_MASK                           0xffffffff
#define RXPCU_POWER_SAVE_4_GID_MSB_BITMAP_VALUE_GET(x)                         (((x) & RXPCU_POWER_SAVE_4_GID_MSB_BITMAP_VALUE_MASK) >> RXPCU_POWER_SAVE_4_GID_MSB_BITMAP_VALUE_LSB)
#define RXPCU_POWER_SAVE_4_GID_MSB_BITMAP_VALUE_SET(x)                         (((0 | (x)) << RXPCU_POWER_SAVE_4_GID_MSB_BITMAP_VALUE_LSB) & RXPCU_POWER_SAVE_4_GID_MSB_BITMAP_VALUE_MASK)
#define RXPCU_POWER_SAVE_4_GID_MSB_BITMAP_VALUE_RESET                          0x0
#define RXPCU_POWER_SAVE_4_ADDRESS                                             (0x98 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_POWER_SAVE_4_RSTMASK                                             0xffffffff
#define RXPCU_POWER_SAVE_4_RESET                                               0x0

// 0x9c (RXPCU_POWER_SAVE_5)
#define RXPCU_POWER_SAVE_5_GID_USER_NUMBER_REGISTER_0_LSB                      0
#define RXPCU_POWER_SAVE_5_GID_USER_NUMBER_REGISTER_0_MSB                      31
#define RXPCU_POWER_SAVE_5_GID_USER_NUMBER_REGISTER_0_MASK                     0xffffffff
#define RXPCU_POWER_SAVE_5_GID_USER_NUMBER_REGISTER_0_GET(x)                   (((x) & RXPCU_POWER_SAVE_5_GID_USER_NUMBER_REGISTER_0_MASK) >> RXPCU_POWER_SAVE_5_GID_USER_NUMBER_REGISTER_0_LSB)
#define RXPCU_POWER_SAVE_5_GID_USER_NUMBER_REGISTER_0_SET(x)                   (((0 | (x)) << RXPCU_POWER_SAVE_5_GID_USER_NUMBER_REGISTER_0_LSB) & RXPCU_POWER_SAVE_5_GID_USER_NUMBER_REGISTER_0_MASK)
#define RXPCU_POWER_SAVE_5_GID_USER_NUMBER_REGISTER_0_RESET                    0x0
#define RXPCU_POWER_SAVE_5_ADDRESS                                             (0x9c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_POWER_SAVE_5_RSTMASK                                             0xffffffff
#define RXPCU_POWER_SAVE_5_RESET                                               0x0

// 0xa0 (RXPCU_POWER_SAVE_6)
#define RXPCU_POWER_SAVE_6_GID_USER_NUMBER_REGISTER_1_LSB                      0
#define RXPCU_POWER_SAVE_6_GID_USER_NUMBER_REGISTER_1_MSB                      31
#define RXPCU_POWER_SAVE_6_GID_USER_NUMBER_REGISTER_1_MASK                     0xffffffff
#define RXPCU_POWER_SAVE_6_GID_USER_NUMBER_REGISTER_1_GET(x)                   (((x) & RXPCU_POWER_SAVE_6_GID_USER_NUMBER_REGISTER_1_MASK) >> RXPCU_POWER_SAVE_6_GID_USER_NUMBER_REGISTER_1_LSB)
#define RXPCU_POWER_SAVE_6_GID_USER_NUMBER_REGISTER_1_SET(x)                   (((0 | (x)) << RXPCU_POWER_SAVE_6_GID_USER_NUMBER_REGISTER_1_LSB) & RXPCU_POWER_SAVE_6_GID_USER_NUMBER_REGISTER_1_MASK)
#define RXPCU_POWER_SAVE_6_GID_USER_NUMBER_REGISTER_1_RESET                    0x0
#define RXPCU_POWER_SAVE_6_ADDRESS                                             (0xa0 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_POWER_SAVE_6_RSTMASK                                             0xffffffff
#define RXPCU_POWER_SAVE_6_RESET                                               0x0

// 0xa4 (RXPCU_POWER_SAVE_7)
#define RXPCU_POWER_SAVE_7_GID_USER_NUMBER_REGISTER_2_LSB                      0
#define RXPCU_POWER_SAVE_7_GID_USER_NUMBER_REGISTER_2_MSB                      31
#define RXPCU_POWER_SAVE_7_GID_USER_NUMBER_REGISTER_2_MASK                     0xffffffff
#define RXPCU_POWER_SAVE_7_GID_USER_NUMBER_REGISTER_2_GET(x)                   (((x) & RXPCU_POWER_SAVE_7_GID_USER_NUMBER_REGISTER_2_MASK) >> RXPCU_POWER_SAVE_7_GID_USER_NUMBER_REGISTER_2_LSB)
#define RXPCU_POWER_SAVE_7_GID_USER_NUMBER_REGISTER_2_SET(x)                   (((0 | (x)) << RXPCU_POWER_SAVE_7_GID_USER_NUMBER_REGISTER_2_LSB) & RXPCU_POWER_SAVE_7_GID_USER_NUMBER_REGISTER_2_MASK)
#define RXPCU_POWER_SAVE_7_GID_USER_NUMBER_REGISTER_2_RESET                    0x0
#define RXPCU_POWER_SAVE_7_ADDRESS                                             (0xa4 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_POWER_SAVE_7_RSTMASK                                             0xffffffff
#define RXPCU_POWER_SAVE_7_RESET                                               0x0

// 0xa8 (RXPCU_POWER_SAVE_8)
#define RXPCU_POWER_SAVE_8_GID_USER_NUMBER_REGISTER_3_LSB                      0
#define RXPCU_POWER_SAVE_8_GID_USER_NUMBER_REGISTER_3_MSB                      31
#define RXPCU_POWER_SAVE_8_GID_USER_NUMBER_REGISTER_3_MASK                     0xffffffff
#define RXPCU_POWER_SAVE_8_GID_USER_NUMBER_REGISTER_3_GET(x)                   (((x) & RXPCU_POWER_SAVE_8_GID_USER_NUMBER_REGISTER_3_MASK) >> RXPCU_POWER_SAVE_8_GID_USER_NUMBER_REGISTER_3_LSB)
#define RXPCU_POWER_SAVE_8_GID_USER_NUMBER_REGISTER_3_SET(x)                   (((0 | (x)) << RXPCU_POWER_SAVE_8_GID_USER_NUMBER_REGISTER_3_LSB) & RXPCU_POWER_SAVE_8_GID_USER_NUMBER_REGISTER_3_MASK)
#define RXPCU_POWER_SAVE_8_GID_USER_NUMBER_REGISTER_3_RESET                    0x0
#define RXPCU_POWER_SAVE_8_ADDRESS                                             (0xa8 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_POWER_SAVE_8_RSTMASK                                             0xffffffff
#define RXPCU_POWER_SAVE_8_RESET                                               0x0

// 0xb0 (RXPCU_RX_CLEAR_PHY_DLY_SEC20)
#define RXPCU_RX_CLEAR_PHY_DLY_SEC20_EN_LSB                                    8
#define RXPCU_RX_CLEAR_PHY_DLY_SEC20_EN_MSB                                    8
#define RXPCU_RX_CLEAR_PHY_DLY_SEC20_EN_MASK                                   0x100
#define RXPCU_RX_CLEAR_PHY_DLY_SEC20_EN_GET(x)                                 (((x) & RXPCU_RX_CLEAR_PHY_DLY_SEC20_EN_MASK) >> RXPCU_RX_CLEAR_PHY_DLY_SEC20_EN_LSB)
#define RXPCU_RX_CLEAR_PHY_DLY_SEC20_EN_SET(x)                                 (((0 | (x)) << RXPCU_RX_CLEAR_PHY_DLY_SEC20_EN_LSB) & RXPCU_RX_CLEAR_PHY_DLY_SEC20_EN_MASK)
#define RXPCU_RX_CLEAR_PHY_DLY_SEC20_EN_RESET                                  0x0
#define RXPCU_RX_CLEAR_PHY_DLY_SEC20_CNT_LSB                                   0
#define RXPCU_RX_CLEAR_PHY_DLY_SEC20_CNT_MSB                                   7
#define RXPCU_RX_CLEAR_PHY_DLY_SEC20_CNT_MASK                                  0xff
#define RXPCU_RX_CLEAR_PHY_DLY_SEC20_CNT_GET(x)                                (((x) & RXPCU_RX_CLEAR_PHY_DLY_SEC20_CNT_MASK) >> RXPCU_RX_CLEAR_PHY_DLY_SEC20_CNT_LSB)
#define RXPCU_RX_CLEAR_PHY_DLY_SEC20_CNT_SET(x)                                (((0 | (x)) << RXPCU_RX_CLEAR_PHY_DLY_SEC20_CNT_LSB) & RXPCU_RX_CLEAR_PHY_DLY_SEC20_CNT_MASK)
#define RXPCU_RX_CLEAR_PHY_DLY_SEC20_CNT_RESET                                 0x77
#define RXPCU_RX_CLEAR_PHY_DLY_SEC20_ADDRESS                                   (0xb0 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RX_CLEAR_PHY_DLY_SEC20_RSTMASK                                   0x1ff
#define RXPCU_RX_CLEAR_PHY_DLY_SEC20_RESET                                     0x77

// 0xb4 (RXPCU_RX_CLEAR_PHY_DLY_SEC40)
#define RXPCU_RX_CLEAR_PHY_DLY_SEC40_EN_LSB                                    8
#define RXPCU_RX_CLEAR_PHY_DLY_SEC40_EN_MSB                                    8
#define RXPCU_RX_CLEAR_PHY_DLY_SEC40_EN_MASK                                   0x100
#define RXPCU_RX_CLEAR_PHY_DLY_SEC40_EN_GET(x)                                 (((x) & RXPCU_RX_CLEAR_PHY_DLY_SEC40_EN_MASK) >> RXPCU_RX_CLEAR_PHY_DLY_SEC40_EN_LSB)
#define RXPCU_RX_CLEAR_PHY_DLY_SEC40_EN_SET(x)                                 (((0 | (x)) << RXPCU_RX_CLEAR_PHY_DLY_SEC40_EN_LSB) & RXPCU_RX_CLEAR_PHY_DLY_SEC40_EN_MASK)
#define RXPCU_RX_CLEAR_PHY_DLY_SEC40_EN_RESET                                  0x0
#define RXPCU_RX_CLEAR_PHY_DLY_SEC40_CNT_LSB                                   0
#define RXPCU_RX_CLEAR_PHY_DLY_SEC40_CNT_MSB                                   7
#define RXPCU_RX_CLEAR_PHY_DLY_SEC40_CNT_MASK                                  0xff
#define RXPCU_RX_CLEAR_PHY_DLY_SEC40_CNT_GET(x)                                (((x) & RXPCU_RX_CLEAR_PHY_DLY_SEC40_CNT_MASK) >> RXPCU_RX_CLEAR_PHY_DLY_SEC40_CNT_LSB)
#define RXPCU_RX_CLEAR_PHY_DLY_SEC40_CNT_SET(x)                                (((0 | (x)) << RXPCU_RX_CLEAR_PHY_DLY_SEC40_CNT_LSB) & RXPCU_RX_CLEAR_PHY_DLY_SEC40_CNT_MASK)
#define RXPCU_RX_CLEAR_PHY_DLY_SEC40_CNT_RESET                                 0x77
#define RXPCU_RX_CLEAR_PHY_DLY_SEC40_ADDRESS                                   (0xb4 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RX_CLEAR_PHY_DLY_SEC40_RSTMASK                                   0x1ff
#define RXPCU_RX_CLEAR_PHY_DLY_SEC40_RESET                                     0x77

// 0xb8 (RXPCU_RX_CLEAR_PHY_DLY_SEC80)
#define RXPCU_RX_CLEAR_PHY_DLY_SEC80_EN_LSB                                    8
#define RXPCU_RX_CLEAR_PHY_DLY_SEC80_EN_MSB                                    8
#define RXPCU_RX_CLEAR_PHY_DLY_SEC80_EN_MASK                                   0x100
#define RXPCU_RX_CLEAR_PHY_DLY_SEC80_EN_GET(x)                                 (((x) & RXPCU_RX_CLEAR_PHY_DLY_SEC80_EN_MASK) >> RXPCU_RX_CLEAR_PHY_DLY_SEC80_EN_LSB)
#define RXPCU_RX_CLEAR_PHY_DLY_SEC80_EN_SET(x)                                 (((0 | (x)) << RXPCU_RX_CLEAR_PHY_DLY_SEC80_EN_LSB) & RXPCU_RX_CLEAR_PHY_DLY_SEC80_EN_MASK)
#define RXPCU_RX_CLEAR_PHY_DLY_SEC80_EN_RESET                                  0x0
#define RXPCU_RX_CLEAR_PHY_DLY_SEC80_CNT_LSB                                   0
#define RXPCU_RX_CLEAR_PHY_DLY_SEC80_CNT_MSB                                   7
#define RXPCU_RX_CLEAR_PHY_DLY_SEC80_CNT_MASK                                  0xff
#define RXPCU_RX_CLEAR_PHY_DLY_SEC80_CNT_GET(x)                                (((x) & RXPCU_RX_CLEAR_PHY_DLY_SEC80_CNT_MASK) >> RXPCU_RX_CLEAR_PHY_DLY_SEC80_CNT_LSB)
#define RXPCU_RX_CLEAR_PHY_DLY_SEC80_CNT_SET(x)                                (((0 | (x)) << RXPCU_RX_CLEAR_PHY_DLY_SEC80_CNT_LSB) & RXPCU_RX_CLEAR_PHY_DLY_SEC80_CNT_MASK)
#define RXPCU_RX_CLEAR_PHY_DLY_SEC80_CNT_RESET                                 0x77
#define RXPCU_RX_CLEAR_PHY_DLY_SEC80_ADDRESS                                   (0xb8 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RX_CLEAR_PHY_DLY_SEC80_RSTMASK                                   0x1ff
#define RXPCU_RX_CLEAR_PHY_DLY_SEC80_RESET                                     0x77

// 0xbc (RXPCU_AST_TIMEOUT)
#define RXPCU_AST_TIMEOUT_VALUE_LSB                                            0
#define RXPCU_AST_TIMEOUT_VALUE_MSB                                            11
#define RXPCU_AST_TIMEOUT_VALUE_MASK                                           0xfff
#define RXPCU_AST_TIMEOUT_VALUE_GET(x)                                         (((x) & RXPCU_AST_TIMEOUT_VALUE_MASK) >> RXPCU_AST_TIMEOUT_VALUE_LSB)
#define RXPCU_AST_TIMEOUT_VALUE_SET(x)                                         (((0 | (x)) << RXPCU_AST_TIMEOUT_VALUE_LSB) & RXPCU_AST_TIMEOUT_VALUE_MASK)
#define RXPCU_AST_TIMEOUT_VALUE_RESET                                          0x4b0
#define RXPCU_AST_TIMEOUT_ADDRESS                                              (0xbc + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_AST_TIMEOUT_RSTMASK                                              0xfff
#define RXPCU_AST_TIMEOUT_RESET                                                0x4b0

// 0xc0 (RXPCU_ASE_AST_BASE_ADDR)
#define RXPCU_ASE_AST_BASE_ADDR_VALUE_LSB                                      0
#define RXPCU_ASE_AST_BASE_ADDR_VALUE_MSB                                      31
#define RXPCU_ASE_AST_BASE_ADDR_VALUE_MASK                                     0xffffffff
#define RXPCU_ASE_AST_BASE_ADDR_VALUE_GET(x)                                   (((x) & RXPCU_ASE_AST_BASE_ADDR_VALUE_MASK) >> RXPCU_ASE_AST_BASE_ADDR_VALUE_LSB)
#define RXPCU_ASE_AST_BASE_ADDR_VALUE_SET(x)                                   (((0 | (x)) << RXPCU_ASE_AST_BASE_ADDR_VALUE_LSB) & RXPCU_ASE_AST_BASE_ADDR_VALUE_MASK)
#define RXPCU_ASE_AST_BASE_ADDR_VALUE_RESET                                    0x0
#define RXPCU_ASE_AST_BASE_ADDR_ADDRESS                                        (0xc0 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_ASE_AST_BASE_ADDR_RSTMASK                                        0xffffffff
#define RXPCU_ASE_AST_BASE_ADDR_RESET                                          0x0

// 0xc4 (RXPCU_ASE_AST_SIZE)
#define RXPCU_ASE_AST_SIZE_VALUE_LSB                                           0
#define RXPCU_ASE_AST_SIZE_VALUE_MSB                                           12
#define RXPCU_ASE_AST_SIZE_VALUE_MASK                                          0x1fff
#define RXPCU_ASE_AST_SIZE_VALUE_GET(x)                                        (((x) & RXPCU_ASE_AST_SIZE_VALUE_MASK) >> RXPCU_ASE_AST_SIZE_VALUE_LSB)
#define RXPCU_ASE_AST_SIZE_VALUE_SET(x)                                        (((0 | (x)) << RXPCU_ASE_AST_SIZE_VALUE_LSB) & RXPCU_ASE_AST_SIZE_VALUE_MASK)
#define RXPCU_ASE_AST_SIZE_VALUE_RESET                                         0x0
#define RXPCU_ASE_AST_SIZE_ADDRESS                                             (0xc4 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_ASE_AST_SIZE_RSTMASK                                             0x1fff
#define RXPCU_ASE_AST_SIZE_RESET                                               0x0

// 0xc8 (RXPCU_ASE_SEARCH_CTRL)
#define RXPCU_ASE_SEARCH_CTRL_TIMEOUT_THRESH_LSB                               16
#define RXPCU_ASE_SEARCH_CTRL_TIMEOUT_THRESH_MSB                               31
#define RXPCU_ASE_SEARCH_CTRL_TIMEOUT_THRESH_MASK                              0xffff0000
#define RXPCU_ASE_SEARCH_CTRL_TIMEOUT_THRESH_GET(x)                            (((x) & RXPCU_ASE_SEARCH_CTRL_TIMEOUT_THRESH_MASK) >> RXPCU_ASE_SEARCH_CTRL_TIMEOUT_THRESH_LSB)
#define RXPCU_ASE_SEARCH_CTRL_TIMEOUT_THRESH_SET(x)                            (((0 | (x)) << RXPCU_ASE_SEARCH_CTRL_TIMEOUT_THRESH_LSB) & RXPCU_ASE_SEARCH_CTRL_TIMEOUT_THRESH_MASK)
#define RXPCU_ASE_SEARCH_CTRL_TIMEOUT_THRESH_RESET                             0x0
#define RXPCU_ASE_SEARCH_CTRL_ADDR_SEARCH_SWAP_LSB                             8
#define RXPCU_ASE_SEARCH_CTRL_ADDR_SEARCH_SWAP_MSB                             8
#define RXPCU_ASE_SEARCH_CTRL_ADDR_SEARCH_SWAP_MASK                            0x100
#define RXPCU_ASE_SEARCH_CTRL_ADDR_SEARCH_SWAP_GET(x)                          (((x) & RXPCU_ASE_SEARCH_CTRL_ADDR_SEARCH_SWAP_MASK) >> RXPCU_ASE_SEARCH_CTRL_ADDR_SEARCH_SWAP_LSB)
#define RXPCU_ASE_SEARCH_CTRL_ADDR_SEARCH_SWAP_SET(x)                          (((0 | (x)) << RXPCU_ASE_SEARCH_CTRL_ADDR_SEARCH_SWAP_LSB) & RXPCU_ASE_SEARCH_CTRL_ADDR_SEARCH_SWAP_MASK)
#define RXPCU_ASE_SEARCH_CTRL_ADDR_SEARCH_SWAP_RESET                           0x0
#define RXPCU_ASE_SEARCH_CTRL_MAX_SEARCH_LSB                                   0
#define RXPCU_ASE_SEARCH_CTRL_MAX_SEARCH_MSB                                   7
#define RXPCU_ASE_SEARCH_CTRL_MAX_SEARCH_MASK                                  0xff
#define RXPCU_ASE_SEARCH_CTRL_MAX_SEARCH_GET(x)                                (((x) & RXPCU_ASE_SEARCH_CTRL_MAX_SEARCH_MASK) >> RXPCU_ASE_SEARCH_CTRL_MAX_SEARCH_LSB)
#define RXPCU_ASE_SEARCH_CTRL_MAX_SEARCH_SET(x)                                (((0 | (x)) << RXPCU_ASE_SEARCH_CTRL_MAX_SEARCH_LSB) & RXPCU_ASE_SEARCH_CTRL_MAX_SEARCH_MASK)
#define RXPCU_ASE_SEARCH_CTRL_MAX_SEARCH_RESET                                 0x0
#define RXPCU_ASE_SEARCH_CTRL_ADDRESS                                          (0xc8 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_ASE_SEARCH_CTRL_RSTMASK                                          0xffff01ff
#define RXPCU_ASE_SEARCH_CTRL_RESET                                            0x0

// 0xcc (RXPCU_ASE_HASH_CTRL)
#define RXPCU_ASE_HASH_CTRL_CACHE_INVALIDATE_LSB                               23
#define RXPCU_ASE_HASH_CTRL_CACHE_INVALIDATE_MSB                               23
#define RXPCU_ASE_HASH_CTRL_CACHE_INVALIDATE_MASK                              0x800000
#define RXPCU_ASE_HASH_CTRL_CACHE_INVALIDATE_GET(x)                            (((x) & RXPCU_ASE_HASH_CTRL_CACHE_INVALIDATE_MASK) >> RXPCU_ASE_HASH_CTRL_CACHE_INVALIDATE_LSB)
#define RXPCU_ASE_HASH_CTRL_CACHE_INVALIDATE_SET(x)                            (((0 | (x)) << RXPCU_ASE_HASH_CTRL_CACHE_INVALIDATE_LSB) & RXPCU_ASE_HASH_CTRL_CACHE_INVALIDATE_MASK)
#define RXPCU_ASE_HASH_CTRL_CACHE_INVALIDATE_RESET                             0x0
#define RXPCU_ASE_HASH_CTRL_CACHE_DISABLE_LSB                                  22
#define RXPCU_ASE_HASH_CTRL_CACHE_DISABLE_MSB                                  22
#define RXPCU_ASE_HASH_CTRL_CACHE_DISABLE_MASK                                 0x400000
#define RXPCU_ASE_HASH_CTRL_CACHE_DISABLE_GET(x)                               (((x) & RXPCU_ASE_HASH_CTRL_CACHE_DISABLE_MASK) >> RXPCU_ASE_HASH_CTRL_CACHE_DISABLE_LSB)
#define RXPCU_ASE_HASH_CTRL_CACHE_DISABLE_SET(x)                               (((0 | (x)) << RXPCU_ASE_HASH_CTRL_CACHE_DISABLE_LSB) & RXPCU_ASE_HASH_CTRL_CACHE_DISABLE_MASK)
#define RXPCU_ASE_HASH_CTRL_CACHE_DISABLE_RESET                                0x0
#define RXPCU_ASE_HASH_CTRL_HASH_MAC_31_0_IGNORE_LSB                           21
#define RXPCU_ASE_HASH_CTRL_HASH_MAC_31_0_IGNORE_MSB                           21
#define RXPCU_ASE_HASH_CTRL_HASH_MAC_31_0_IGNORE_MASK                          0x200000
#define RXPCU_ASE_HASH_CTRL_HASH_MAC_31_0_IGNORE_GET(x)                        (((x) & RXPCU_ASE_HASH_CTRL_HASH_MAC_31_0_IGNORE_MASK) >> RXPCU_ASE_HASH_CTRL_HASH_MAC_31_0_IGNORE_LSB)
#define RXPCU_ASE_HASH_CTRL_HASH_MAC_31_0_IGNORE_SET(x)                        (((0 | (x)) << RXPCU_ASE_HASH_CTRL_HASH_MAC_31_0_IGNORE_LSB) & RXPCU_ASE_HASH_CTRL_HASH_MAC_31_0_IGNORE_MASK)
#define RXPCU_ASE_HASH_CTRL_HASH_MAC_31_0_IGNORE_RESET                         0x0
#define RXPCU_ASE_HASH_CTRL_HASH_SEL_LSB                                       20
#define RXPCU_ASE_HASH_CTRL_HASH_SEL_MSB                                       20
#define RXPCU_ASE_HASH_CTRL_HASH_SEL_MASK                                      0x100000
#define RXPCU_ASE_HASH_CTRL_HASH_SEL_GET(x)                                    (((x) & RXPCU_ASE_HASH_CTRL_HASH_SEL_MASK) >> RXPCU_ASE_HASH_CTRL_HASH_SEL_LSB)
#define RXPCU_ASE_HASH_CTRL_HASH_SEL_SET(x)                                    (((0 | (x)) << RXPCU_ASE_HASH_CTRL_HASH_SEL_LSB) & RXPCU_ASE_HASH_CTRL_HASH_SEL_MASK)
#define RXPCU_ASE_HASH_CTRL_HASH_SEL_RESET                                     0x0
#define RXPCU_ASE_HASH_CTRL_HASH_MCAST_SHIFT_LSB                               16
#define RXPCU_ASE_HASH_CTRL_HASH_MCAST_SHIFT_MSB                               19
#define RXPCU_ASE_HASH_CTRL_HASH_MCAST_SHIFT_MASK                              0xf0000
#define RXPCU_ASE_HASH_CTRL_HASH_MCAST_SHIFT_GET(x)                            (((x) & RXPCU_ASE_HASH_CTRL_HASH_MCAST_SHIFT_MASK) >> RXPCU_ASE_HASH_CTRL_HASH_MCAST_SHIFT_LSB)
#define RXPCU_ASE_HASH_CTRL_HASH_MCAST_SHIFT_SET(x)                            (((0 | (x)) << RXPCU_ASE_HASH_CTRL_HASH_MCAST_SHIFT_LSB) & RXPCU_ASE_HASH_CTRL_HASH_MCAST_SHIFT_MASK)
#define RXPCU_ASE_HASH_CTRL_HASH_MCAST_SHIFT_RESET                             0x2
#define RXPCU_ASE_HASH_CTRL_HASH_XOR_LSB                                       0
#define RXPCU_ASE_HASH_CTRL_HASH_XOR_MSB                                       15
#define RXPCU_ASE_HASH_CTRL_HASH_XOR_MASK                                      0xffff
#define RXPCU_ASE_HASH_CTRL_HASH_XOR_GET(x)                                    (((x) & RXPCU_ASE_HASH_CTRL_HASH_XOR_MASK) >> RXPCU_ASE_HASH_CTRL_HASH_XOR_LSB)
#define RXPCU_ASE_HASH_CTRL_HASH_XOR_SET(x)                                    (((0 | (x)) << RXPCU_ASE_HASH_CTRL_HASH_XOR_LSB) & RXPCU_ASE_HASH_CTRL_HASH_XOR_MASK)
#define RXPCU_ASE_HASH_CTRL_HASH_XOR_RESET                                     0xabcd
#define RXPCU_ASE_HASH_CTRL_ADDRESS                                            (0xcc + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_ASE_HASH_CTRL_RSTMASK                                            0xffffff
#define RXPCU_ASE_HASH_CTRL_RESET                                              0x2abcd

// 0xd0 (RXPCU_MISC_MODE)
#define RXPCU_MISC_MODE_ALWAYS_PERFORM_KEY_SEARCH_LSB                          28
#define RXPCU_MISC_MODE_ALWAYS_PERFORM_KEY_SEARCH_MSB                          28
#define RXPCU_MISC_MODE_ALWAYS_PERFORM_KEY_SEARCH_MASK                         0x10000000
#define RXPCU_MISC_MODE_ALWAYS_PERFORM_KEY_SEARCH_GET(x)                       (((x) & RXPCU_MISC_MODE_ALWAYS_PERFORM_KEY_SEARCH_MASK) >> RXPCU_MISC_MODE_ALWAYS_PERFORM_KEY_SEARCH_LSB)
#define RXPCU_MISC_MODE_ALWAYS_PERFORM_KEY_SEARCH_SET(x)                       (((0 | (x)) << RXPCU_MISC_MODE_ALWAYS_PERFORM_KEY_SEARCH_LSB) & RXPCU_MISC_MODE_ALWAYS_PERFORM_KEY_SEARCH_MASK)
#define RXPCU_MISC_MODE_ALWAYS_PERFORM_KEY_SEARCH_RESET                        0x0
#define RXPCU_MISC_MODE_CLEAR_BA_VALID_LSB                                     26
#define RXPCU_MISC_MODE_CLEAR_BA_VALID_MSB                                     26
#define RXPCU_MISC_MODE_CLEAR_BA_VALID_MASK                                    0x4000000
#define RXPCU_MISC_MODE_CLEAR_BA_VALID_GET(x)                                  (((x) & RXPCU_MISC_MODE_CLEAR_BA_VALID_MASK) >> RXPCU_MISC_MODE_CLEAR_BA_VALID_LSB)
#define RXPCU_MISC_MODE_CLEAR_BA_VALID_SET(x)                                  (((0 | (x)) << RXPCU_MISC_MODE_CLEAR_BA_VALID_LSB) & RXPCU_MISC_MODE_CLEAR_BA_VALID_MASK)
#define RXPCU_MISC_MODE_CLEAR_BA_VALID_RESET                                   0x0
#define RXPCU_MISC_MODE_MISS_BEACON_IN_SLEEP_LSB                               14
#define RXPCU_MISC_MODE_MISS_BEACON_IN_SLEEP_MSB                               14
#define RXPCU_MISC_MODE_MISS_BEACON_IN_SLEEP_MASK                              0x4000
#define RXPCU_MISC_MODE_MISS_BEACON_IN_SLEEP_GET(x)                            (((x) & RXPCU_MISC_MODE_MISS_BEACON_IN_SLEEP_MASK) >> RXPCU_MISC_MODE_MISS_BEACON_IN_SLEEP_LSB)
#define RXPCU_MISC_MODE_MISS_BEACON_IN_SLEEP_SET(x)                            (((0 | (x)) << RXPCU_MISC_MODE_MISS_BEACON_IN_SLEEP_LSB) & RXPCU_MISC_MODE_MISS_BEACON_IN_SLEEP_MASK)
#define RXPCU_MISC_MODE_MISS_BEACON_IN_SLEEP_RESET                             0x1
#define RXPCU_MISC_MODE_DEBUG_MODE_BA_BITMAP_LSB                               9
#define RXPCU_MISC_MODE_DEBUG_MODE_BA_BITMAP_MSB                               9
#define RXPCU_MISC_MODE_DEBUG_MODE_BA_BITMAP_MASK                              0x200
#define RXPCU_MISC_MODE_DEBUG_MODE_BA_BITMAP_GET(x)                            (((x) & RXPCU_MISC_MODE_DEBUG_MODE_BA_BITMAP_MASK) >> RXPCU_MISC_MODE_DEBUG_MODE_BA_BITMAP_LSB)
#define RXPCU_MISC_MODE_DEBUG_MODE_BA_BITMAP_SET(x)                            (((0 | (x)) << RXPCU_MISC_MODE_DEBUG_MODE_BA_BITMAP_LSB) & RXPCU_MISC_MODE_DEBUG_MODE_BA_BITMAP_MASK)
#define RXPCU_MISC_MODE_DEBUG_MODE_BA_BITMAP_RESET                             0x0
#define RXPCU_MISC_MODE_PHY_ERR_BT_COLL_ENABLE_LSB                             2
#define RXPCU_MISC_MODE_PHY_ERR_BT_COLL_ENABLE_MSB                             2
#define RXPCU_MISC_MODE_PHY_ERR_BT_COLL_ENABLE_MASK                            0x4
#define RXPCU_MISC_MODE_PHY_ERR_BT_COLL_ENABLE_GET(x)                          (((x) & RXPCU_MISC_MODE_PHY_ERR_BT_COLL_ENABLE_MASK) >> RXPCU_MISC_MODE_PHY_ERR_BT_COLL_ENABLE_LSB)
#define RXPCU_MISC_MODE_PHY_ERR_BT_COLL_ENABLE_SET(x)                          (((0 | (x)) << RXPCU_MISC_MODE_PHY_ERR_BT_COLL_ENABLE_LSB) & RXPCU_MISC_MODE_PHY_ERR_BT_COLL_ENABLE_MASK)
#define RXPCU_MISC_MODE_PHY_ERR_BT_COLL_ENABLE_RESET                           0x0
#define RXPCU_MISC_MODE_ENABLE_COEX_AUTO_PHY_OFF_LSB                           1
#define RXPCU_MISC_MODE_ENABLE_COEX_AUTO_PHY_OFF_MSB                           1
#define RXPCU_MISC_MODE_ENABLE_COEX_AUTO_PHY_OFF_MASK                          0x2
#define RXPCU_MISC_MODE_ENABLE_COEX_AUTO_PHY_OFF_GET(x)                        (((x) & RXPCU_MISC_MODE_ENABLE_COEX_AUTO_PHY_OFF_MASK) >> RXPCU_MISC_MODE_ENABLE_COEX_AUTO_PHY_OFF_LSB)
#define RXPCU_MISC_MODE_ENABLE_COEX_AUTO_PHY_OFF_SET(x)                        (((0 | (x)) << RXPCU_MISC_MODE_ENABLE_COEX_AUTO_PHY_OFF_LSB) & RXPCU_MISC_MODE_ENABLE_COEX_AUTO_PHY_OFF_MASK)
#define RXPCU_MISC_MODE_ENABLE_COEX_AUTO_PHY_OFF_RESET                         0x1
#define RXPCU_MISC_MODE_BSSID_MATCH_FORCE_LSB                                  0
#define RXPCU_MISC_MODE_BSSID_MATCH_FORCE_MSB                                  0
#define RXPCU_MISC_MODE_BSSID_MATCH_FORCE_MASK                                 0x1
#define RXPCU_MISC_MODE_BSSID_MATCH_FORCE_GET(x)                               (((x) & RXPCU_MISC_MODE_BSSID_MATCH_FORCE_MASK) >> RXPCU_MISC_MODE_BSSID_MATCH_FORCE_LSB)
#define RXPCU_MISC_MODE_BSSID_MATCH_FORCE_SET(x)                               (((0 | (x)) << RXPCU_MISC_MODE_BSSID_MATCH_FORCE_LSB) & RXPCU_MISC_MODE_BSSID_MATCH_FORCE_MASK)
#define RXPCU_MISC_MODE_BSSID_MATCH_FORCE_RESET                                0x0
#define RXPCU_MISC_MODE_ADDRESS                                                (0xd0 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_MISC_MODE_RSTMASK                                                0x14004207
#define RXPCU_MISC_MODE_RESET                                                  0x4002

// 0xd4 (RXPCU_MISC_MODE2)
#define RXPCU_MISC_MODE2_MPDU_DENSITY_STS_FIX_LSB                              23
#define RXPCU_MISC_MODE2_MPDU_DENSITY_STS_FIX_MSB                              23
#define RXPCU_MISC_MODE2_MPDU_DENSITY_STS_FIX_MASK                             0x800000
#define RXPCU_MISC_MODE2_MPDU_DENSITY_STS_FIX_GET(x)                           (((x) & RXPCU_MISC_MODE2_MPDU_DENSITY_STS_FIX_MASK) >> RXPCU_MISC_MODE2_MPDU_DENSITY_STS_FIX_LSB)
#define RXPCU_MISC_MODE2_MPDU_DENSITY_STS_FIX_SET(x)                           (((0 | (x)) << RXPCU_MISC_MODE2_MPDU_DENSITY_STS_FIX_LSB) & RXPCU_MISC_MODE2_MPDU_DENSITY_STS_FIX_MASK)
#define RXPCU_MISC_MODE2_MPDU_DENSITY_STS_FIX_RESET                            0x0
#define RXPCU_MISC_MODE2_NO_CRYPTO_FOR_NON_DATA_PKT_LSB                        2
#define RXPCU_MISC_MODE2_NO_CRYPTO_FOR_NON_DATA_PKT_MSB                        2
#define RXPCU_MISC_MODE2_NO_CRYPTO_FOR_NON_DATA_PKT_MASK                       0x4
#define RXPCU_MISC_MODE2_NO_CRYPTO_FOR_NON_DATA_PKT_GET(x)                     (((x) & RXPCU_MISC_MODE2_NO_CRYPTO_FOR_NON_DATA_PKT_MASK) >> RXPCU_MISC_MODE2_NO_CRYPTO_FOR_NON_DATA_PKT_LSB)
#define RXPCU_MISC_MODE2_NO_CRYPTO_FOR_NON_DATA_PKT_SET(x)                     (((0 | (x)) << RXPCU_MISC_MODE2_NO_CRYPTO_FOR_NON_DATA_PKT_LSB) & RXPCU_MISC_MODE2_NO_CRYPTO_FOR_NON_DATA_PKT_MASK)
#define RXPCU_MISC_MODE2_NO_CRYPTO_FOR_NON_DATA_PKT_RESET                      0x0
#define RXPCU_MISC_MODE2_ADDRESS                                               (0xd4 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_MISC_MODE2_RSTMASK                                               0x800004
#define RXPCU_MISC_MODE2_RESET                                                 0x0

// 0xd8 (RXPCU_MISC_MODE3)
#define RXPCU_MISC_MODE3_KEY_MISS_FIX_LSB                                      29
#define RXPCU_MISC_MODE3_KEY_MISS_FIX_MSB                                      29
#define RXPCU_MISC_MODE3_KEY_MISS_FIX_MASK                                     0x20000000
#define RXPCU_MISC_MODE3_KEY_MISS_FIX_GET(x)                                   (((x) & RXPCU_MISC_MODE3_KEY_MISS_FIX_MASK) >> RXPCU_MISC_MODE3_KEY_MISS_FIX_LSB)
#define RXPCU_MISC_MODE3_KEY_MISS_FIX_SET(x)                                   (((0 | (x)) << RXPCU_MISC_MODE3_KEY_MISS_FIX_LSB) & RXPCU_MISC_MODE3_KEY_MISS_FIX_MASK)
#define RXPCU_MISC_MODE3_KEY_MISS_FIX_RESET                                    0x1
#define RXPCU_MISC_MODE3_BEACON_FROM_TO_DS_CHECK_LSB                           23
#define RXPCU_MISC_MODE3_BEACON_FROM_TO_DS_CHECK_MSB                           23
#define RXPCU_MISC_MODE3_BEACON_FROM_TO_DS_CHECK_MASK                          0x800000
#define RXPCU_MISC_MODE3_BEACON_FROM_TO_DS_CHECK_GET(x)                        (((x) & RXPCU_MISC_MODE3_BEACON_FROM_TO_DS_CHECK_MASK) >> RXPCU_MISC_MODE3_BEACON_FROM_TO_DS_CHECK_LSB)
#define RXPCU_MISC_MODE3_BEACON_FROM_TO_DS_CHECK_SET(x)                        (((0 | (x)) << RXPCU_MISC_MODE3_BEACON_FROM_TO_DS_CHECK_LSB) & RXPCU_MISC_MODE3_BEACON_FROM_TO_DS_CHECK_MASK)
#define RXPCU_MISC_MODE3_BEACON_FROM_TO_DS_CHECK_RESET                         0x1
#define RXPCU_MISC_MODE3_ALLOW_RAC_LSB                                         21
#define RXPCU_MISC_MODE3_ALLOW_RAC_MSB                                         21
#define RXPCU_MISC_MODE3_ALLOW_RAC_MASK                                        0x200000
#define RXPCU_MISC_MODE3_ALLOW_RAC_GET(x)                                      (((x) & RXPCU_MISC_MODE3_ALLOW_RAC_MASK) >> RXPCU_MISC_MODE3_ALLOW_RAC_LSB)
#define RXPCU_MISC_MODE3_ALLOW_RAC_SET(x)                                      (((0 | (x)) << RXPCU_MISC_MODE3_ALLOW_RAC_LSB) & RXPCU_MISC_MODE3_ALLOW_RAC_MASK)
#define RXPCU_MISC_MODE3_ALLOW_RAC_RESET                                       0x0
#define RXPCU_MISC_MODE3_WL_MED_BUSY_TIMER_TARGET_LSB                          0
#define RXPCU_MISC_MODE3_WL_MED_BUSY_TIMER_TARGET_MSB                          15
#define RXPCU_MISC_MODE3_WL_MED_BUSY_TIMER_TARGET_MASK                         0xffff
#define RXPCU_MISC_MODE3_WL_MED_BUSY_TIMER_TARGET_GET(x)                       (((x) & RXPCU_MISC_MODE3_WL_MED_BUSY_TIMER_TARGET_MASK) >> RXPCU_MISC_MODE3_WL_MED_BUSY_TIMER_TARGET_LSB)
#define RXPCU_MISC_MODE3_WL_MED_BUSY_TIMER_TARGET_SET(x)                       (((0 | (x)) << RXPCU_MISC_MODE3_WL_MED_BUSY_TIMER_TARGET_LSB) & RXPCU_MISC_MODE3_WL_MED_BUSY_TIMER_TARGET_MASK)
#define RXPCU_MISC_MODE3_WL_MED_BUSY_TIMER_TARGET_RESET                        0xffff
#define RXPCU_MISC_MODE3_ADDRESS                                               (0xd8 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_MISC_MODE3_RSTMASK                                               0x20a0ffff
#define RXPCU_MISC_MODE3_RESET                                                 0x2080ffff

// 0xdc (RXPCU_MISC_MODE4)
#define RXPCU_MISC_MODE4_HT_RTS_PIFS_CHECK_EN_LSB                              14
#define RXPCU_MISC_MODE4_HT_RTS_PIFS_CHECK_EN_MSB                              14
#define RXPCU_MISC_MODE4_HT_RTS_PIFS_CHECK_EN_MASK                             0x4000
#define RXPCU_MISC_MODE4_HT_RTS_PIFS_CHECK_EN_GET(x)                           (((x) & RXPCU_MISC_MODE4_HT_RTS_PIFS_CHECK_EN_MASK) >> RXPCU_MISC_MODE4_HT_RTS_PIFS_CHECK_EN_LSB)
#define RXPCU_MISC_MODE4_HT_RTS_PIFS_CHECK_EN_SET(x)                           (((0 | (x)) << RXPCU_MISC_MODE4_HT_RTS_PIFS_CHECK_EN_LSB) & RXPCU_MISC_MODE4_HT_RTS_PIFS_CHECK_EN_MASK)
#define RXPCU_MISC_MODE4_HT_RTS_PIFS_CHECK_EN_RESET                            0x0
#define RXPCU_MISC_MODE4_HT_RTS_DYNAMIC_EN_LSB                                 13
#define RXPCU_MISC_MODE4_HT_RTS_DYNAMIC_EN_MSB                                 13
#define RXPCU_MISC_MODE4_HT_RTS_DYNAMIC_EN_MASK                                0x2000
#define RXPCU_MISC_MODE4_HT_RTS_DYNAMIC_EN_GET(x)                              (((x) & RXPCU_MISC_MODE4_HT_RTS_DYNAMIC_EN_MASK) >> RXPCU_MISC_MODE4_HT_RTS_DYNAMIC_EN_LSB)
#define RXPCU_MISC_MODE4_HT_RTS_DYNAMIC_EN_SET(x)                              (((0 | (x)) << RXPCU_MISC_MODE4_HT_RTS_DYNAMIC_EN_LSB) & RXPCU_MISC_MODE4_HT_RTS_DYNAMIC_EN_MASK)
#define RXPCU_MISC_MODE4_HT_RTS_DYNAMIC_EN_RESET                               0x0
#define RXPCU_MISC_MODE4_ACK_TO_PCF_HCF_EN_LSB                                 12
#define RXPCU_MISC_MODE4_ACK_TO_PCF_HCF_EN_MSB                                 12
#define RXPCU_MISC_MODE4_ACK_TO_PCF_HCF_EN_MASK                                0x1000
#define RXPCU_MISC_MODE4_ACK_TO_PCF_HCF_EN_GET(x)                              (((x) & RXPCU_MISC_MODE4_ACK_TO_PCF_HCF_EN_MASK) >> RXPCU_MISC_MODE4_ACK_TO_PCF_HCF_EN_LSB)
#define RXPCU_MISC_MODE4_ACK_TO_PCF_HCF_EN_SET(x)                              (((0 | (x)) << RXPCU_MISC_MODE4_ACK_TO_PCF_HCF_EN_LSB) & RXPCU_MISC_MODE4_ACK_TO_PCF_HCF_EN_MASK)
#define RXPCU_MISC_MODE4_ACK_TO_PCF_HCF_EN_RESET                               0x1
#define RXPCU_MISC_MODE4_EIFS_FOR_MU_EN_LSB                                    11
#define RXPCU_MISC_MODE4_EIFS_FOR_MU_EN_MSB                                    11
#define RXPCU_MISC_MODE4_EIFS_FOR_MU_EN_MASK                                   0x800
#define RXPCU_MISC_MODE4_EIFS_FOR_MU_EN_GET(x)                                 (((x) & RXPCU_MISC_MODE4_EIFS_FOR_MU_EN_MASK) >> RXPCU_MISC_MODE4_EIFS_FOR_MU_EN_LSB)
#define RXPCU_MISC_MODE4_EIFS_FOR_MU_EN_SET(x)                                 (((0 | (x)) << RXPCU_MISC_MODE4_EIFS_FOR_MU_EN_LSB) & RXPCU_MISC_MODE4_EIFS_FOR_MU_EN_MASK)
#define RXPCU_MISC_MODE4_EIFS_FOR_MU_EN_RESET                                  0x0
#define RXPCU_MISC_MODE4_PEER_ENTRY_SWAP_LSB                                   10
#define RXPCU_MISC_MODE4_PEER_ENTRY_SWAP_MSB                                   10
#define RXPCU_MISC_MODE4_PEER_ENTRY_SWAP_MASK                                  0x400
#define RXPCU_MISC_MODE4_PEER_ENTRY_SWAP_GET(x)                                (((x) & RXPCU_MISC_MODE4_PEER_ENTRY_SWAP_MASK) >> RXPCU_MISC_MODE4_PEER_ENTRY_SWAP_LSB)
#define RXPCU_MISC_MODE4_PEER_ENTRY_SWAP_SET(x)                                (((0 | (x)) << RXPCU_MISC_MODE4_PEER_ENTRY_SWAP_LSB) & RXPCU_MISC_MODE4_PEER_ENTRY_SWAP_MASK)
#define RXPCU_MISC_MODE4_PEER_ENTRY_SWAP_RESET                                 0x0
#define RXPCU_MISC_MODE4_IGNORE_FCS_ERR_FOR_EIFS_LSB                           9
#define RXPCU_MISC_MODE4_IGNORE_FCS_ERR_FOR_EIFS_MSB                           9
#define RXPCU_MISC_MODE4_IGNORE_FCS_ERR_FOR_EIFS_MASK                          0x200
#define RXPCU_MISC_MODE4_IGNORE_FCS_ERR_FOR_EIFS_GET(x)                        (((x) & RXPCU_MISC_MODE4_IGNORE_FCS_ERR_FOR_EIFS_MASK) >> RXPCU_MISC_MODE4_IGNORE_FCS_ERR_FOR_EIFS_LSB)
#define RXPCU_MISC_MODE4_IGNORE_FCS_ERR_FOR_EIFS_SET(x)                        (((0 | (x)) << RXPCU_MISC_MODE4_IGNORE_FCS_ERR_FOR_EIFS_LSB) & RXPCU_MISC_MODE4_IGNORE_FCS_ERR_FOR_EIFS_MASK)
#define RXPCU_MISC_MODE4_IGNORE_FCS_ERR_FOR_EIFS_RESET                         0x0
#define RXPCU_MISC_MODE4_ALWAYS_REQ_IMPLICIT_FB_LSB                            8
#define RXPCU_MISC_MODE4_ALWAYS_REQ_IMPLICIT_FB_MSB                            8
#define RXPCU_MISC_MODE4_ALWAYS_REQ_IMPLICIT_FB_MASK                           0x100
#define RXPCU_MISC_MODE4_ALWAYS_REQ_IMPLICIT_FB_GET(x)                         (((x) & RXPCU_MISC_MODE4_ALWAYS_REQ_IMPLICIT_FB_MASK) >> RXPCU_MISC_MODE4_ALWAYS_REQ_IMPLICIT_FB_LSB)
#define RXPCU_MISC_MODE4_ALWAYS_REQ_IMPLICIT_FB_SET(x)                         (((0 | (x)) << RXPCU_MISC_MODE4_ALWAYS_REQ_IMPLICIT_FB_LSB) & RXPCU_MISC_MODE4_ALWAYS_REQ_IMPLICIT_FB_MASK)
#define RXPCU_MISC_MODE4_ALWAYS_REQ_IMPLICIT_FB_RESET                          0x0
#define RXPCU_MISC_MODE4_WAPI_BSSID4_LSB                                       7
#define RXPCU_MISC_MODE4_WAPI_BSSID4_MSB                                       7
#define RXPCU_MISC_MODE4_WAPI_BSSID4_MASK                                      0x80
#define RXPCU_MISC_MODE4_WAPI_BSSID4_GET(x)                                    (((x) & RXPCU_MISC_MODE4_WAPI_BSSID4_MASK) >> RXPCU_MISC_MODE4_WAPI_BSSID4_LSB)
#define RXPCU_MISC_MODE4_WAPI_BSSID4_SET(x)                                    (((0 | (x)) << RXPCU_MISC_MODE4_WAPI_BSSID4_LSB) & RXPCU_MISC_MODE4_WAPI_BSSID4_MASK)
#define RXPCU_MISC_MODE4_WAPI_BSSID4_RESET                                     0x0
#define RXPCU_MISC_MODE4_WAPI_BSSID3_LSB                                       6
#define RXPCU_MISC_MODE4_WAPI_BSSID3_MSB                                       6
#define RXPCU_MISC_MODE4_WAPI_BSSID3_MASK                                      0x40
#define RXPCU_MISC_MODE4_WAPI_BSSID3_GET(x)                                    (((x) & RXPCU_MISC_MODE4_WAPI_BSSID3_MASK) >> RXPCU_MISC_MODE4_WAPI_BSSID3_LSB)
#define RXPCU_MISC_MODE4_WAPI_BSSID3_SET(x)                                    (((0 | (x)) << RXPCU_MISC_MODE4_WAPI_BSSID3_LSB) & RXPCU_MISC_MODE4_WAPI_BSSID3_MASK)
#define RXPCU_MISC_MODE4_WAPI_BSSID3_RESET                                     0x0
#define RXPCU_MISC_MODE4_WAPI_BSSID2_LSB                                       5
#define RXPCU_MISC_MODE4_WAPI_BSSID2_MSB                                       5
#define RXPCU_MISC_MODE4_WAPI_BSSID2_MASK                                      0x20
#define RXPCU_MISC_MODE4_WAPI_BSSID2_GET(x)                                    (((x) & RXPCU_MISC_MODE4_WAPI_BSSID2_MASK) >> RXPCU_MISC_MODE4_WAPI_BSSID2_LSB)
#define RXPCU_MISC_MODE4_WAPI_BSSID2_SET(x)                                    (((0 | (x)) << RXPCU_MISC_MODE4_WAPI_BSSID2_LSB) & RXPCU_MISC_MODE4_WAPI_BSSID2_MASK)
#define RXPCU_MISC_MODE4_WAPI_BSSID2_RESET                                     0x0
#define RXPCU_MISC_MODE4_WAPI_BSSID1_LSB                                       4
#define RXPCU_MISC_MODE4_WAPI_BSSID1_MSB                                       4
#define RXPCU_MISC_MODE4_WAPI_BSSID1_MASK                                      0x10
#define RXPCU_MISC_MODE4_WAPI_BSSID1_GET(x)                                    (((x) & RXPCU_MISC_MODE4_WAPI_BSSID1_MASK) >> RXPCU_MISC_MODE4_WAPI_BSSID1_LSB)
#define RXPCU_MISC_MODE4_WAPI_BSSID1_SET(x)                                    (((0 | (x)) << RXPCU_MISC_MODE4_WAPI_BSSID1_LSB) & RXPCU_MISC_MODE4_WAPI_BSSID1_MASK)
#define RXPCU_MISC_MODE4_WAPI_BSSID1_RESET                                     0x0
#define RXPCU_MISC_MODE4_ADDRESS                                               (0xdc + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_MISC_MODE4_RSTMASK                                               0x7ff0
#define RXPCU_MISC_MODE4_RESET                                                 0x1000

// 0xe0 (RXPCU_DIAGNOSTIC_MODE)
#define RXPCU_DIAGNOSTIC_MODE_RXBUF_DEBUG_EN_LSB                               1
#define RXPCU_DIAGNOSTIC_MODE_RXBUF_DEBUG_EN_MSB                               1
#define RXPCU_DIAGNOSTIC_MODE_RXBUF_DEBUG_EN_MASK                              0x2
#define RXPCU_DIAGNOSTIC_MODE_RXBUF_DEBUG_EN_GET(x)                            (((x) & RXPCU_DIAGNOSTIC_MODE_RXBUF_DEBUG_EN_MASK) >> RXPCU_DIAGNOSTIC_MODE_RXBUF_DEBUG_EN_LSB)
#define RXPCU_DIAGNOSTIC_MODE_RXBUF_DEBUG_EN_SET(x)                            (((0 | (x)) << RXPCU_DIAGNOSTIC_MODE_RXBUF_DEBUG_EN_LSB) & RXPCU_DIAGNOSTIC_MODE_RXBUF_DEBUG_EN_MASK)
#define RXPCU_DIAGNOSTIC_MODE_RXBUF_DEBUG_EN_RESET                             0x0
#define RXPCU_DIAGNOSTIC_MODE_ADDRESS                                          (0xe0 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_DIAGNOSTIC_MODE_RSTMASK                                          0x2
#define RXPCU_DIAGNOSTIC_MODE_RESET                                            0x0

// 0xe4 (RXPCU_WATCHDOG)
#define RXPCU_WATCHDOG_STATUS_LSB                                              16
#define RXPCU_WATCHDOG_STATUS_MSB                                              31
#define RXPCU_WATCHDOG_STATUS_MASK                                             0xffff0000
#define RXPCU_WATCHDOG_STATUS_GET(x)                                           (((x) & RXPCU_WATCHDOG_STATUS_MASK) >> RXPCU_WATCHDOG_STATUS_LSB)
#define RXPCU_WATCHDOG_STATUS_SET(x)                                           (((0 | (x)) << RXPCU_WATCHDOG_STATUS_LSB) & RXPCU_WATCHDOG_STATUS_MASK)
#define RXPCU_WATCHDOG_STATUS_RESET                                            0x0
#define RXPCU_WATCHDOG_LIMIT_LSB                                               0
#define RXPCU_WATCHDOG_LIMIT_MSB                                               15
#define RXPCU_WATCHDOG_LIMIT_MASK                                              0xffff
#define RXPCU_WATCHDOG_LIMIT_GET(x)                                            (((x) & RXPCU_WATCHDOG_LIMIT_MASK) >> RXPCU_WATCHDOG_LIMIT_LSB)
#define RXPCU_WATCHDOG_LIMIT_SET(x)                                            (((0 | (x)) << RXPCU_WATCHDOG_LIMIT_LSB) & RXPCU_WATCHDOG_LIMIT_MASK)
#define RXPCU_WATCHDOG_LIMIT_RESET                                             0xffff
#define RXPCU_WATCHDOG_ADDRESS                                                 (0xe4 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_WATCHDOG_RSTMASK                                                 0xffffffff
#define RXPCU_WATCHDOG_RESET                                                   0xffff

// 0xe8 (RXPCU_MISC_MODE5)
#define RXPCU_MISC_MODE5_WAPI_VAP_ENABLE_LSB                                   16
#define RXPCU_MISC_MODE5_WAPI_VAP_ENABLE_MSB                                   31
#define RXPCU_MISC_MODE5_WAPI_VAP_ENABLE_MASK                                  0xffff0000
#define RXPCU_MISC_MODE5_WAPI_VAP_ENABLE_GET(x)                                (((x) & RXPCU_MISC_MODE5_WAPI_VAP_ENABLE_MASK) >> RXPCU_MISC_MODE5_WAPI_VAP_ENABLE_LSB)
#define RXPCU_MISC_MODE5_WAPI_VAP_ENABLE_SET(x)                                (((0 | (x)) << RXPCU_MISC_MODE5_WAPI_VAP_ENABLE_LSB) & RXPCU_MISC_MODE5_WAPI_VAP_ENABLE_MASK)
#define RXPCU_MISC_MODE5_WAPI_VAP_ENABLE_RESET                                 0x0
#define RXPCU_MISC_MODE5_FIRST_MPDU_SET_FOR_PASSING_LSB                        9
#define RXPCU_MISC_MODE5_FIRST_MPDU_SET_FOR_PASSING_MSB                        9
#define RXPCU_MISC_MODE5_FIRST_MPDU_SET_FOR_PASSING_MASK                       0x200
#define RXPCU_MISC_MODE5_FIRST_MPDU_SET_FOR_PASSING_GET(x)                     (((x) & RXPCU_MISC_MODE5_FIRST_MPDU_SET_FOR_PASSING_MASK) >> RXPCU_MISC_MODE5_FIRST_MPDU_SET_FOR_PASSING_LSB)
#define RXPCU_MISC_MODE5_FIRST_MPDU_SET_FOR_PASSING_SET(x)                     (((0 | (x)) << RXPCU_MISC_MODE5_FIRST_MPDU_SET_FOR_PASSING_LSB) & RXPCU_MISC_MODE5_FIRST_MPDU_SET_FOR_PASSING_MASK)
#define RXPCU_MISC_MODE5_FIRST_MPDU_SET_FOR_PASSING_RESET                      0x0
#define RXPCU_MISC_MODE5_ALLOW_FREEZE_ON_PROBE_RESPONSE_LSB                    8
#define RXPCU_MISC_MODE5_ALLOW_FREEZE_ON_PROBE_RESPONSE_MSB                    8
#define RXPCU_MISC_MODE5_ALLOW_FREEZE_ON_PROBE_RESPONSE_MASK                   0x100
#define RXPCU_MISC_MODE5_ALLOW_FREEZE_ON_PROBE_RESPONSE_GET(x)                 (((x) & RXPCU_MISC_MODE5_ALLOW_FREEZE_ON_PROBE_RESPONSE_MASK) >> RXPCU_MISC_MODE5_ALLOW_FREEZE_ON_PROBE_RESPONSE_LSB)
#define RXPCU_MISC_MODE5_ALLOW_FREEZE_ON_PROBE_RESPONSE_SET(x)                 (((0 | (x)) << RXPCU_MISC_MODE5_ALLOW_FREEZE_ON_PROBE_RESPONSE_LSB) & RXPCU_MISC_MODE5_ALLOW_FREEZE_ON_PROBE_RESPONSE_MASK)
#define RXPCU_MISC_MODE5_ALLOW_FREEZE_ON_PROBE_RESPONSE_RESET                  0x0
#define RXPCU_MISC_MODE5_WAPI_WDS_ENABLE_LSB                                   7
#define RXPCU_MISC_MODE5_WAPI_WDS_ENABLE_MSB                                   7
#define RXPCU_MISC_MODE5_WAPI_WDS_ENABLE_MASK                                  0x80
#define RXPCU_MISC_MODE5_WAPI_WDS_ENABLE_GET(x)                                (((x) & RXPCU_MISC_MODE5_WAPI_WDS_ENABLE_MASK) >> RXPCU_MISC_MODE5_WAPI_WDS_ENABLE_LSB)
#define RXPCU_MISC_MODE5_WAPI_WDS_ENABLE_SET(x)                                (((0 | (x)) << RXPCU_MISC_MODE5_WAPI_WDS_ENABLE_LSB) & RXPCU_MISC_MODE5_WAPI_WDS_ENABLE_MASK)
#define RXPCU_MISC_MODE5_WAPI_WDS_ENABLE_RESET                                 0x0
#define RXPCU_MISC_MODE5_WAPI_WDS_USE_ADDR1_LSB                                6
#define RXPCU_MISC_MODE5_WAPI_WDS_USE_ADDR1_MSB                                6
#define RXPCU_MISC_MODE5_WAPI_WDS_USE_ADDR1_MASK                               0x40
#define RXPCU_MISC_MODE5_WAPI_WDS_USE_ADDR1_GET(x)                             (((x) & RXPCU_MISC_MODE5_WAPI_WDS_USE_ADDR1_MASK) >> RXPCU_MISC_MODE5_WAPI_WDS_USE_ADDR1_LSB)
#define RXPCU_MISC_MODE5_WAPI_WDS_USE_ADDR1_SET(x)                             (((0 | (x)) << RXPCU_MISC_MODE5_WAPI_WDS_USE_ADDR1_LSB) & RXPCU_MISC_MODE5_WAPI_WDS_USE_ADDR1_MASK)
#define RXPCU_MISC_MODE5_WAPI_WDS_USE_ADDR1_RESET                              0x0
#define RXPCU_MISC_MODE5_WAPI_VAP_OFFSET_LSB_LSB                               0
#define RXPCU_MISC_MODE5_WAPI_VAP_OFFSET_LSB_MSB                               5
#define RXPCU_MISC_MODE5_WAPI_VAP_OFFSET_LSB_MASK                              0x3f
#define RXPCU_MISC_MODE5_WAPI_VAP_OFFSET_LSB_GET(x)                            (((x) & RXPCU_MISC_MODE5_WAPI_VAP_OFFSET_LSB_MASK) >> RXPCU_MISC_MODE5_WAPI_VAP_OFFSET_LSB_LSB)
#define RXPCU_MISC_MODE5_WAPI_VAP_OFFSET_LSB_SET(x)                            (((0 | (x)) << RXPCU_MISC_MODE5_WAPI_VAP_OFFSET_LSB_LSB) & RXPCU_MISC_MODE5_WAPI_VAP_OFFSET_LSB_MASK)
#define RXPCU_MISC_MODE5_WAPI_VAP_OFFSET_LSB_RESET                             0x2
#define RXPCU_MISC_MODE5_ADDRESS                                               (0xe8 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_MISC_MODE5_RSTMASK                                               0xffff03ff
#define RXPCU_MISC_MODE5_RESET                                                 0x2

// 0xf0 (RXPCU_FCS_FAIL_CNT)
#define RXPCU_FCS_FAIL_CNT_VALUE_LSB                                           0
#define RXPCU_FCS_FAIL_CNT_VALUE_MSB                                           15
#define RXPCU_FCS_FAIL_CNT_VALUE_MASK                                          0xffff
#define RXPCU_FCS_FAIL_CNT_VALUE_GET(x)                                        (((x) & RXPCU_FCS_FAIL_CNT_VALUE_MASK) >> RXPCU_FCS_FAIL_CNT_VALUE_LSB)
#define RXPCU_FCS_FAIL_CNT_VALUE_SET(x)                                        (((0 | (x)) << RXPCU_FCS_FAIL_CNT_VALUE_LSB) & RXPCU_FCS_FAIL_CNT_VALUE_MASK)
#define RXPCU_FCS_FAIL_CNT_VALUE_RESET                                         0x0
#define RXPCU_FCS_FAIL_CNT_ADDRESS                                             (0xf0 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_FCS_FAIL_CNT_RSTMASK                                             0xffff
#define RXPCU_FCS_FAIL_CNT_RESET                                               0x0

// 0xf4 (RXPCU_BEACON_CNT)
#define RXPCU_BEACON_CNT_VALUE_LSB                                             0
#define RXPCU_BEACON_CNT_VALUE_MSB                                             15
#define RXPCU_BEACON_CNT_VALUE_MASK                                            0xffff
#define RXPCU_BEACON_CNT_VALUE_GET(x)                                          (((x) & RXPCU_BEACON_CNT_VALUE_MASK) >> RXPCU_BEACON_CNT_VALUE_LSB)
#define RXPCU_BEACON_CNT_VALUE_SET(x)                                          (((0 | (x)) << RXPCU_BEACON_CNT_VALUE_LSB) & RXPCU_BEACON_CNT_VALUE_MASK)
#define RXPCU_BEACON_CNT_VALUE_RESET                                           0x0
#define RXPCU_BEACON_CNT_ADDRESS                                               (0xf4 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_BEACON_CNT_RSTMASK                                               0xffff
#define RXPCU_BEACON_CNT_RESET                                                 0x0

// 0xf8 (RXPCU_BEACON2_CNT)
#define RXPCU_BEACON2_CNT_VALUE_LSB                                            0
#define RXPCU_BEACON2_CNT_VALUE_MSB                                            15
#define RXPCU_BEACON2_CNT_VALUE_MASK                                           0xffff
#define RXPCU_BEACON2_CNT_VALUE_GET(x)                                         (((x) & RXPCU_BEACON2_CNT_VALUE_MASK) >> RXPCU_BEACON2_CNT_VALUE_LSB)
#define RXPCU_BEACON2_CNT_VALUE_SET(x)                                         (((0 | (x)) << RXPCU_BEACON2_CNT_VALUE_LSB) & RXPCU_BEACON2_CNT_VALUE_MASK)
#define RXPCU_BEACON2_CNT_VALUE_RESET                                          0x0
#define RXPCU_BEACON2_CNT_ADDRESS                                              (0xf8 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_BEACON2_CNT_RSTMASK                                              0xffff
#define RXPCU_BEACON2_CNT_RESET                                                0x0

// 0x104 (RXPCU_FILTER_OFDM_CNT)
#define RXPCU_FILTER_OFDM_CNT_VALUE_LSB                                        0
#define RXPCU_FILTER_OFDM_CNT_VALUE_MSB                                        23
#define RXPCU_FILTER_OFDM_CNT_VALUE_MASK                                       0xffffff
#define RXPCU_FILTER_OFDM_CNT_VALUE_GET(x)                                     (((x) & RXPCU_FILTER_OFDM_CNT_VALUE_MASK) >> RXPCU_FILTER_OFDM_CNT_VALUE_LSB)
#define RXPCU_FILTER_OFDM_CNT_VALUE_SET(x)                                     (((0 | (x)) << RXPCU_FILTER_OFDM_CNT_VALUE_LSB) & RXPCU_FILTER_OFDM_CNT_VALUE_MASK)
#define RXPCU_FILTER_OFDM_CNT_VALUE_RESET                                      0x0
#define RXPCU_FILTER_OFDM_CNT_ADDRESS                                          (0x104 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_FILTER_OFDM_CNT_RSTMASK                                          0xffffff
#define RXPCU_FILTER_OFDM_CNT_RESET                                            0x0

// 0x108 (RXPCU_FILTER_CCK_CNT)
#define RXPCU_FILTER_CCK_CNT_VALUE_LSB                                         0
#define RXPCU_FILTER_CCK_CNT_VALUE_MSB                                         23
#define RXPCU_FILTER_CCK_CNT_VALUE_MASK                                        0xffffff
#define RXPCU_FILTER_CCK_CNT_VALUE_GET(x)                                      (((x) & RXPCU_FILTER_CCK_CNT_VALUE_MASK) >> RXPCU_FILTER_CCK_CNT_VALUE_LSB)
#define RXPCU_FILTER_CCK_CNT_VALUE_SET(x)                                      (((0 | (x)) << RXPCU_FILTER_CCK_CNT_VALUE_LSB) & RXPCU_FILTER_CCK_CNT_VALUE_MASK)
#define RXPCU_FILTER_CCK_CNT_VALUE_RESET                                       0x0
#define RXPCU_FILTER_CCK_CNT_ADDRESS                                           (0x108 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_FILTER_CCK_CNT_RSTMASK                                           0xffffff
#define RXPCU_FILTER_CCK_CNT_RESET                                             0x0

// 0x10c (RXPCU_SIFS_RESP_STATUS)
#define RXPCU_SIFS_RESP_STATUS_SEQUENCE_CONTROL_LSB                            16
#define RXPCU_SIFS_RESP_STATUS_SEQUENCE_CONTROL_MSB                            31
#define RXPCU_SIFS_RESP_STATUS_SEQUENCE_CONTROL_MASK                           0xffff0000
#define RXPCU_SIFS_RESP_STATUS_SEQUENCE_CONTROL_GET(x)                         (((x) & RXPCU_SIFS_RESP_STATUS_SEQUENCE_CONTROL_MASK) >> RXPCU_SIFS_RESP_STATUS_SEQUENCE_CONTROL_LSB)
#define RXPCU_SIFS_RESP_STATUS_SEQUENCE_CONTROL_SET(x)                         (((0 | (x)) << RXPCU_SIFS_RESP_STATUS_SEQUENCE_CONTROL_LSB) & RXPCU_SIFS_RESP_STATUS_SEQUENCE_CONTROL_MASK)
#define RXPCU_SIFS_RESP_STATUS_SEQUENCE_CONTROL_RESET                          0x0
#define RXPCU_SIFS_RESP_STATUS_QOS_CONTROL_LSB                                 0
#define RXPCU_SIFS_RESP_STATUS_QOS_CONTROL_MSB                                 15
#define RXPCU_SIFS_RESP_STATUS_QOS_CONTROL_MASK                                0xffff
#define RXPCU_SIFS_RESP_STATUS_QOS_CONTROL_GET(x)                              (((x) & RXPCU_SIFS_RESP_STATUS_QOS_CONTROL_MASK) >> RXPCU_SIFS_RESP_STATUS_QOS_CONTROL_LSB)
#define RXPCU_SIFS_RESP_STATUS_QOS_CONTROL_SET(x)                              (((0 | (x)) << RXPCU_SIFS_RESP_STATUS_QOS_CONTROL_LSB) & RXPCU_SIFS_RESP_STATUS_QOS_CONTROL_MASK)
#define RXPCU_SIFS_RESP_STATUS_QOS_CONTROL_RESET                               0x0
#define RXPCU_SIFS_RESP_STATUS_ADDRESS                                         (0x10c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_SIFS_RESP_STATUS_RSTMASK                                         0xffffffff
#define RXPCU_SIFS_RESP_STATUS_RESET                                           0x0

// 0x110 (RXPCU_SIFS_RESP_STATUS2)
#define RXPCU_SIFS_RESP_STATUS2_BW_LSB                                         12
#define RXPCU_SIFS_RESP_STATUS2_BW_MSB                                         13
#define RXPCU_SIFS_RESP_STATUS2_BW_MASK                                        0x3000
#define RXPCU_SIFS_RESP_STATUS2_BW_GET(x)                                      (((x) & RXPCU_SIFS_RESP_STATUS2_BW_MASK) >> RXPCU_SIFS_RESP_STATUS2_BW_LSB)
#define RXPCU_SIFS_RESP_STATUS2_BW_SET(x)                                      (((0 | (x)) << RXPCU_SIFS_RESP_STATUS2_BW_LSB) & RXPCU_SIFS_RESP_STATUS2_BW_MASK)
#define RXPCU_SIFS_RESP_STATUS2_BW_RESET                                       0x0
#define RXPCU_SIFS_RESP_STATUS2_PEER_IDX_LSB                                   0
#define RXPCU_SIFS_RESP_STATUS2_PEER_IDX_MSB                                   10
#define RXPCU_SIFS_RESP_STATUS2_PEER_IDX_MASK                                  0x7ff
#define RXPCU_SIFS_RESP_STATUS2_PEER_IDX_GET(x)                                (((x) & RXPCU_SIFS_RESP_STATUS2_PEER_IDX_MASK) >> RXPCU_SIFS_RESP_STATUS2_PEER_IDX_LSB)
#define RXPCU_SIFS_RESP_STATUS2_PEER_IDX_SET(x)                                (((0 | (x)) << RXPCU_SIFS_RESP_STATUS2_PEER_IDX_LSB) & RXPCU_SIFS_RESP_STATUS2_PEER_IDX_MASK)
#define RXPCU_SIFS_RESP_STATUS2_PEER_IDX_RESET                                 0x0
#define RXPCU_SIFS_RESP_STATUS2_ADDRESS                                        (0x110 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_SIFS_RESP_STATUS2_RSTMASK                                        0x37ff
#define RXPCU_SIFS_RESP_STATUS2_RESET                                          0x0

// 0x114 (RXPCU_SIFS_RESP_STATUS3)
#define RXPCU_SIFS_RESP_STATUS3_AID_LSB                                        16
#define RXPCU_SIFS_RESP_STATUS3_AID_MSB                                        31
#define RXPCU_SIFS_RESP_STATUS3_AID_MASK                                       0xffff0000
#define RXPCU_SIFS_RESP_STATUS3_AID_GET(x)                                     (((x) & RXPCU_SIFS_RESP_STATUS3_AID_MASK) >> RXPCU_SIFS_RESP_STATUS3_AID_LSB)
#define RXPCU_SIFS_RESP_STATUS3_AID_SET(x)                                     (((0 | (x)) << RXPCU_SIFS_RESP_STATUS3_AID_LSB) & RXPCU_SIFS_RESP_STATUS3_AID_MASK)
#define RXPCU_SIFS_RESP_STATUS3_AID_RESET                                      0x0
#define RXPCU_SIFS_RESP_STATUS3_FRAME_CONTOL_LSB                               0
#define RXPCU_SIFS_RESP_STATUS3_FRAME_CONTOL_MSB                               15
#define RXPCU_SIFS_RESP_STATUS3_FRAME_CONTOL_MASK                              0xffff
#define RXPCU_SIFS_RESP_STATUS3_FRAME_CONTOL_GET(x)                            (((x) & RXPCU_SIFS_RESP_STATUS3_FRAME_CONTOL_MASK) >> RXPCU_SIFS_RESP_STATUS3_FRAME_CONTOL_LSB)
#define RXPCU_SIFS_RESP_STATUS3_FRAME_CONTOL_SET(x)                            (((0 | (x)) << RXPCU_SIFS_RESP_STATUS3_FRAME_CONTOL_LSB) & RXPCU_SIFS_RESP_STATUS3_FRAME_CONTOL_MASK)
#define RXPCU_SIFS_RESP_STATUS3_FRAME_CONTOL_RESET                             0x0
#define RXPCU_SIFS_RESP_STATUS3_ADDRESS                                        (0x114 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_SIFS_RESP_STATUS3_RSTMASK                                        0xffffffff
#define RXPCU_SIFS_RESP_STATUS3_RESET                                          0x0

// 0x120 (RXPCU_PHY_ERROR_MASK)
#define RXPCU_PHY_ERROR_MASK_VALUE_LSB                                         0
#define RXPCU_PHY_ERROR_MASK_VALUE_MSB                                         31
#define RXPCU_PHY_ERROR_MASK_VALUE_MASK                                        0xffffffff
#define RXPCU_PHY_ERROR_MASK_VALUE_GET(x)                                      (((x) & RXPCU_PHY_ERROR_MASK_VALUE_MASK) >> RXPCU_PHY_ERROR_MASK_VALUE_LSB)
#define RXPCU_PHY_ERROR_MASK_VALUE_SET(x)                                      (((0 | (x)) << RXPCU_PHY_ERROR_MASK_VALUE_LSB) & RXPCU_PHY_ERROR_MASK_VALUE_MASK)
#define RXPCU_PHY_ERROR_MASK_VALUE_RESET                                       0x0
#define RXPCU_PHY_ERROR_MASK_ADDRESS                                           (0x120 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_PHY_ERROR_MASK_RSTMASK                                           0xffffffff
#define RXPCU_PHY_ERROR_MASK_RESET                                             0x0

// 0x124 (RXPCU_PHY_ERROR_MASK_CONT)
#define RXPCU_PHY_ERROR_MASK_CONT_VALUE_LSB                                    0
#define RXPCU_PHY_ERROR_MASK_CONT_VALUE_MSB                                    31
#define RXPCU_PHY_ERROR_MASK_CONT_VALUE_MASK                                   0xffffffff
#define RXPCU_PHY_ERROR_MASK_CONT_VALUE_GET(x)                                 (((x) & RXPCU_PHY_ERROR_MASK_CONT_VALUE_MASK) >> RXPCU_PHY_ERROR_MASK_CONT_VALUE_LSB)
#define RXPCU_PHY_ERROR_MASK_CONT_VALUE_SET(x)                                 (((0 | (x)) << RXPCU_PHY_ERROR_MASK_CONT_VALUE_LSB) & RXPCU_PHY_ERROR_MASK_CONT_VALUE_MASK)
#define RXPCU_PHY_ERROR_MASK_CONT_VALUE_RESET                                  0x0
#define RXPCU_PHY_ERROR_MASK_CONT_ADDRESS                                      (0x124 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_PHY_ERROR_MASK_CONT_RSTMASK                                      0xffffffff
#define RXPCU_PHY_ERROR_MASK_CONT_RESET                                        0x0

// 0x128 (RXPCU_PHY_ERROR_EIFS_MASK)
#define RXPCU_PHY_ERROR_EIFS_MASK_VALUE_LSB                                    0
#define RXPCU_PHY_ERROR_EIFS_MASK_VALUE_MSB                                    31
#define RXPCU_PHY_ERROR_EIFS_MASK_VALUE_MASK                                   0xffffffff
#define RXPCU_PHY_ERROR_EIFS_MASK_VALUE_GET(x)                                 (((x) & RXPCU_PHY_ERROR_EIFS_MASK_VALUE_MASK) >> RXPCU_PHY_ERROR_EIFS_MASK_VALUE_LSB)
#define RXPCU_PHY_ERROR_EIFS_MASK_VALUE_SET(x)                                 (((0 | (x)) << RXPCU_PHY_ERROR_EIFS_MASK_VALUE_LSB) & RXPCU_PHY_ERROR_EIFS_MASK_VALUE_MASK)
#define RXPCU_PHY_ERROR_EIFS_MASK_VALUE_RESET                                  0x0
#define RXPCU_PHY_ERROR_EIFS_MASK_ADDRESS                                      (0x128 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_PHY_ERROR_EIFS_MASK_RSTMASK                                      0xffffffff
#define RXPCU_PHY_ERROR_EIFS_MASK_RESET                                        0x0

// 0x12c (RXPCU_PHY_ERROR_EIFS_MASK_CONT)
#define RXPCU_PHY_ERROR_EIFS_MASK_CONT_VALUE_LSB                               0
#define RXPCU_PHY_ERROR_EIFS_MASK_CONT_VALUE_MSB                               31
#define RXPCU_PHY_ERROR_EIFS_MASK_CONT_VALUE_MASK                              0xffffffff
#define RXPCU_PHY_ERROR_EIFS_MASK_CONT_VALUE_GET(x)                            (((x) & RXPCU_PHY_ERROR_EIFS_MASK_CONT_VALUE_MASK) >> RXPCU_PHY_ERROR_EIFS_MASK_CONT_VALUE_LSB)
#define RXPCU_PHY_ERROR_EIFS_MASK_CONT_VALUE_SET(x)                            (((0 | (x)) << RXPCU_PHY_ERROR_EIFS_MASK_CONT_VALUE_LSB) & RXPCU_PHY_ERROR_EIFS_MASK_CONT_VALUE_MASK)
#define RXPCU_PHY_ERROR_EIFS_MASK_CONT_VALUE_RESET                             0x0
#define RXPCU_PHY_ERROR_EIFS_MASK_CONT_ADDRESS                                 (0x12c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_PHY_ERROR_EIFS_MASK_CONT_RSTMASK                                 0xffffffff
#define RXPCU_PHY_ERROR_EIFS_MASK_CONT_RESET                                   0x0

// 0x130 (RXPCU_PHY_ERROR_AIFS)
#define RXPCU_PHY_ERROR_AIFS_MASK_ENABLE_LSB                                   0
#define RXPCU_PHY_ERROR_AIFS_MASK_ENABLE_MSB                                   0
#define RXPCU_PHY_ERROR_AIFS_MASK_ENABLE_MASK                                  0x1
#define RXPCU_PHY_ERROR_AIFS_MASK_ENABLE_GET(x)                                (((x) & RXPCU_PHY_ERROR_AIFS_MASK_ENABLE_MASK) >> RXPCU_PHY_ERROR_AIFS_MASK_ENABLE_LSB)
#define RXPCU_PHY_ERROR_AIFS_MASK_ENABLE_SET(x)                                (((0 | (x)) << RXPCU_PHY_ERROR_AIFS_MASK_ENABLE_LSB) & RXPCU_PHY_ERROR_AIFS_MASK_ENABLE_MASK)
#define RXPCU_PHY_ERROR_AIFS_MASK_ENABLE_RESET                                 0x0
#define RXPCU_PHY_ERROR_AIFS_ADDRESS                                           (0x130 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_PHY_ERROR_AIFS_RSTMASK                                           0x1
#define RXPCU_PHY_ERROR_AIFS_RESET                                             0x0

// 0x134 (RXPCU_PHY_ERROR_AIFS_MASK)
#define RXPCU_PHY_ERROR_AIFS_MASK_VALUE_LSB                                    0
#define RXPCU_PHY_ERROR_AIFS_MASK_VALUE_MSB                                    31
#define RXPCU_PHY_ERROR_AIFS_MASK_VALUE_MASK                                   0xffffffff
#define RXPCU_PHY_ERROR_AIFS_MASK_VALUE_GET(x)                                 (((x) & RXPCU_PHY_ERROR_AIFS_MASK_VALUE_MASK) >> RXPCU_PHY_ERROR_AIFS_MASK_VALUE_LSB)
#define RXPCU_PHY_ERROR_AIFS_MASK_VALUE_SET(x)                                 (((0 | (x)) << RXPCU_PHY_ERROR_AIFS_MASK_VALUE_LSB) & RXPCU_PHY_ERROR_AIFS_MASK_VALUE_MASK)
#define RXPCU_PHY_ERROR_AIFS_MASK_VALUE_RESET                                  0x0
#define RXPCU_PHY_ERROR_AIFS_MASK_ADDRESS                                      (0x134 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_PHY_ERROR_AIFS_MASK_RSTMASK                                      0xffffffff
#define RXPCU_PHY_ERROR_AIFS_MASK_RESET                                        0x0

// 0x138 (RXPCU_PHY_ERROR_AIFS_MASK_CONT)
#define RXPCU_PHY_ERROR_AIFS_MASK_CONT_VALUE_LSB                               0
#define RXPCU_PHY_ERROR_AIFS_MASK_CONT_VALUE_MSB                               31
#define RXPCU_PHY_ERROR_AIFS_MASK_CONT_VALUE_MASK                              0xffffffff
#define RXPCU_PHY_ERROR_AIFS_MASK_CONT_VALUE_GET(x)                            (((x) & RXPCU_PHY_ERROR_AIFS_MASK_CONT_VALUE_MASK) >> RXPCU_PHY_ERROR_AIFS_MASK_CONT_VALUE_LSB)
#define RXPCU_PHY_ERROR_AIFS_MASK_CONT_VALUE_SET(x)                            (((0 | (x)) << RXPCU_PHY_ERROR_AIFS_MASK_CONT_VALUE_LSB) & RXPCU_PHY_ERROR_AIFS_MASK_CONT_VALUE_MASK)
#define RXPCU_PHY_ERROR_AIFS_MASK_CONT_VALUE_RESET                             0x0
#define RXPCU_PHY_ERROR_AIFS_MASK_CONT_ADDRESS                                 (0x138 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_PHY_ERROR_AIFS_MASK_CONT_RSTMASK                                 0xffffffff
#define RXPCU_PHY_ERROR_AIFS_MASK_CONT_RESET                                   0x0

// 0x13c (RXPCU_PHY_ERR_CNT_1)
#define RXPCU_PHY_ERR_CNT_1_VALUE_LSB                                          0
#define RXPCU_PHY_ERR_CNT_1_VALUE_MSB                                          23
#define RXPCU_PHY_ERR_CNT_1_VALUE_MASK                                         0xffffff
#define RXPCU_PHY_ERR_CNT_1_VALUE_GET(x)                                       (((x) & RXPCU_PHY_ERR_CNT_1_VALUE_MASK) >> RXPCU_PHY_ERR_CNT_1_VALUE_LSB)
#define RXPCU_PHY_ERR_CNT_1_VALUE_SET(x)                                       (((0 | (x)) << RXPCU_PHY_ERR_CNT_1_VALUE_LSB) & RXPCU_PHY_ERR_CNT_1_VALUE_MASK)
#define RXPCU_PHY_ERR_CNT_1_VALUE_RESET                                        0x0
#define RXPCU_PHY_ERR_CNT_1_ADDRESS                                            (0x13c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_PHY_ERR_CNT_1_RSTMASK                                            0xffffff
#define RXPCU_PHY_ERR_CNT_1_RESET                                              0x0

// 0x140 (RXPCU_PHY_ERR_CNT_1_MASK)
#define RXPCU_PHY_ERR_CNT_1_MASK_VALUE_LSB                                     0
#define RXPCU_PHY_ERR_CNT_1_MASK_VALUE_MSB                                     31
#define RXPCU_PHY_ERR_CNT_1_MASK_VALUE_MASK                                    0xffffffff
#define RXPCU_PHY_ERR_CNT_1_MASK_VALUE_GET(x)                                  (((x) & RXPCU_PHY_ERR_CNT_1_MASK_VALUE_MASK) >> RXPCU_PHY_ERR_CNT_1_MASK_VALUE_LSB)
#define RXPCU_PHY_ERR_CNT_1_MASK_VALUE_SET(x)                                  (((0 | (x)) << RXPCU_PHY_ERR_CNT_1_MASK_VALUE_LSB) & RXPCU_PHY_ERR_CNT_1_MASK_VALUE_MASK)
#define RXPCU_PHY_ERR_CNT_1_MASK_VALUE_RESET                                   0x0
#define RXPCU_PHY_ERR_CNT_1_MASK_ADDRESS                                       (0x140 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_PHY_ERR_CNT_1_MASK_RSTMASK                                       0xffffffff
#define RXPCU_PHY_ERR_CNT_1_MASK_RESET                                         0x0

// 0x144 (RXPCU_PHY_ERR_CNT_1_MASK_CONT)
#define RXPCU_PHY_ERR_CNT_1_MASK_CONT_VALUE_LSB                                0
#define RXPCU_PHY_ERR_CNT_1_MASK_CONT_VALUE_MSB                                31
#define RXPCU_PHY_ERR_CNT_1_MASK_CONT_VALUE_MASK                               0xffffffff
#define RXPCU_PHY_ERR_CNT_1_MASK_CONT_VALUE_GET(x)                             (((x) & RXPCU_PHY_ERR_CNT_1_MASK_CONT_VALUE_MASK) >> RXPCU_PHY_ERR_CNT_1_MASK_CONT_VALUE_LSB)
#define RXPCU_PHY_ERR_CNT_1_MASK_CONT_VALUE_SET(x)                             (((0 | (x)) << RXPCU_PHY_ERR_CNT_1_MASK_CONT_VALUE_LSB) & RXPCU_PHY_ERR_CNT_1_MASK_CONT_VALUE_MASK)
#define RXPCU_PHY_ERR_CNT_1_MASK_CONT_VALUE_RESET                              0x0
#define RXPCU_PHY_ERR_CNT_1_MASK_CONT_ADDRESS                                  (0x144 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_PHY_ERR_CNT_1_MASK_CONT_RSTMASK                                  0xffffffff
#define RXPCU_PHY_ERR_CNT_1_MASK_CONT_RESET                                    0x0

// 0x148 (RXPCU_PHY_ERR_CNT_2)
#define RXPCU_PHY_ERR_CNT_2_VALUE_LSB                                          0
#define RXPCU_PHY_ERR_CNT_2_VALUE_MSB                                          23
#define RXPCU_PHY_ERR_CNT_2_VALUE_MASK                                         0xffffff
#define RXPCU_PHY_ERR_CNT_2_VALUE_GET(x)                                       (((x) & RXPCU_PHY_ERR_CNT_2_VALUE_MASK) >> RXPCU_PHY_ERR_CNT_2_VALUE_LSB)
#define RXPCU_PHY_ERR_CNT_2_VALUE_SET(x)                                       (((0 | (x)) << RXPCU_PHY_ERR_CNT_2_VALUE_LSB) & RXPCU_PHY_ERR_CNT_2_VALUE_MASK)
#define RXPCU_PHY_ERR_CNT_2_VALUE_RESET                                        0x0
#define RXPCU_PHY_ERR_CNT_2_ADDRESS                                            (0x148 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_PHY_ERR_CNT_2_RSTMASK                                            0xffffff
#define RXPCU_PHY_ERR_CNT_2_RESET                                              0x0

// 0x14c (RXPCU_PHY_ERR_CNT_2_MASK)
#define RXPCU_PHY_ERR_CNT_2_MASK_VALUE_LSB                                     0
#define RXPCU_PHY_ERR_CNT_2_MASK_VALUE_MSB                                     31
#define RXPCU_PHY_ERR_CNT_2_MASK_VALUE_MASK                                    0xffffffff
#define RXPCU_PHY_ERR_CNT_2_MASK_VALUE_GET(x)                                  (((x) & RXPCU_PHY_ERR_CNT_2_MASK_VALUE_MASK) >> RXPCU_PHY_ERR_CNT_2_MASK_VALUE_LSB)
#define RXPCU_PHY_ERR_CNT_2_MASK_VALUE_SET(x)                                  (((0 | (x)) << RXPCU_PHY_ERR_CNT_2_MASK_VALUE_LSB) & RXPCU_PHY_ERR_CNT_2_MASK_VALUE_MASK)
#define RXPCU_PHY_ERR_CNT_2_MASK_VALUE_RESET                                   0x0
#define RXPCU_PHY_ERR_CNT_2_MASK_ADDRESS                                       (0x14c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_PHY_ERR_CNT_2_MASK_RSTMASK                                       0xffffffff
#define RXPCU_PHY_ERR_CNT_2_MASK_RESET                                         0x0

// 0x150 (RXPCU_PHY_ERR_CNT_2_MASK_CONT)
#define RXPCU_PHY_ERR_CNT_2_MASK_CONT_VALUE_LSB                                0
#define RXPCU_PHY_ERR_CNT_2_MASK_CONT_VALUE_MSB                                31
#define RXPCU_PHY_ERR_CNT_2_MASK_CONT_VALUE_MASK                               0xffffffff
#define RXPCU_PHY_ERR_CNT_2_MASK_CONT_VALUE_GET(x)                             (((x) & RXPCU_PHY_ERR_CNT_2_MASK_CONT_VALUE_MASK) >> RXPCU_PHY_ERR_CNT_2_MASK_CONT_VALUE_LSB)
#define RXPCU_PHY_ERR_CNT_2_MASK_CONT_VALUE_SET(x)                             (((0 | (x)) << RXPCU_PHY_ERR_CNT_2_MASK_CONT_VALUE_LSB) & RXPCU_PHY_ERR_CNT_2_MASK_CONT_VALUE_MASK)
#define RXPCU_PHY_ERR_CNT_2_MASK_CONT_VALUE_RESET                              0x0
#define RXPCU_PHY_ERR_CNT_2_MASK_CONT_ADDRESS                                  (0x150 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_PHY_ERR_CNT_2_MASK_CONT_RSTMASK                                  0xffffffff
#define RXPCU_PHY_ERR_CNT_2_MASK_CONT_RESET                                    0x0

// 0x154 (RXPCU_PHY_ERR_CNT_3)
#define RXPCU_PHY_ERR_CNT_3_VALUE_LSB                                          0
#define RXPCU_PHY_ERR_CNT_3_VALUE_MSB                                          23
#define RXPCU_PHY_ERR_CNT_3_VALUE_MASK                                         0xffffff
#define RXPCU_PHY_ERR_CNT_3_VALUE_GET(x)                                       (((x) & RXPCU_PHY_ERR_CNT_3_VALUE_MASK) >> RXPCU_PHY_ERR_CNT_3_VALUE_LSB)
#define RXPCU_PHY_ERR_CNT_3_VALUE_SET(x)                                       (((0 | (x)) << RXPCU_PHY_ERR_CNT_3_VALUE_LSB) & RXPCU_PHY_ERR_CNT_3_VALUE_MASK)
#define RXPCU_PHY_ERR_CNT_3_VALUE_RESET                                        0x0
#define RXPCU_PHY_ERR_CNT_3_ADDRESS                                            (0x154 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_PHY_ERR_CNT_3_RSTMASK                                            0xffffff
#define RXPCU_PHY_ERR_CNT_3_RESET                                              0x0

// 0x158 (RXPCU_PHY_ERR_CNT_3_MASK)
#define RXPCU_PHY_ERR_CNT_3_MASK_VALUE_LSB                                     0
#define RXPCU_PHY_ERR_CNT_3_MASK_VALUE_MSB                                     31
#define RXPCU_PHY_ERR_CNT_3_MASK_VALUE_MASK                                    0xffffffff
#define RXPCU_PHY_ERR_CNT_3_MASK_VALUE_GET(x)                                  (((x) & RXPCU_PHY_ERR_CNT_3_MASK_VALUE_MASK) >> RXPCU_PHY_ERR_CNT_3_MASK_VALUE_LSB)
#define RXPCU_PHY_ERR_CNT_3_MASK_VALUE_SET(x)                                  (((0 | (x)) << RXPCU_PHY_ERR_CNT_3_MASK_VALUE_LSB) & RXPCU_PHY_ERR_CNT_3_MASK_VALUE_MASK)
#define RXPCU_PHY_ERR_CNT_3_MASK_VALUE_RESET                                   0x0
#define RXPCU_PHY_ERR_CNT_3_MASK_ADDRESS                                       (0x158 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_PHY_ERR_CNT_3_MASK_RSTMASK                                       0xffffffff
#define RXPCU_PHY_ERR_CNT_3_MASK_RESET                                         0x0

// 0x15c (RXPCU_PHY_ERR_CNT_3_MASK_CONT)
#define RXPCU_PHY_ERR_CNT_3_MASK_CONT_VALUE_LSB                                0
#define RXPCU_PHY_ERR_CNT_3_MASK_CONT_VALUE_MSB                                31
#define RXPCU_PHY_ERR_CNT_3_MASK_CONT_VALUE_MASK                               0xffffffff
#define RXPCU_PHY_ERR_CNT_3_MASK_CONT_VALUE_GET(x)                             (((x) & RXPCU_PHY_ERR_CNT_3_MASK_CONT_VALUE_MASK) >> RXPCU_PHY_ERR_CNT_3_MASK_CONT_VALUE_LSB)
#define RXPCU_PHY_ERR_CNT_3_MASK_CONT_VALUE_SET(x)                             (((0 | (x)) << RXPCU_PHY_ERR_CNT_3_MASK_CONT_VALUE_LSB) & RXPCU_PHY_ERR_CNT_3_MASK_CONT_VALUE_MASK)
#define RXPCU_PHY_ERR_CNT_3_MASK_CONT_VALUE_RESET                              0x0
#define RXPCU_PHY_ERR_CNT_3_MASK_CONT_ADDRESS                                  (0x15c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_PHY_ERR_CNT_3_MASK_CONT_RSTMASK                                  0xffffffff
#define RXPCU_PHY_ERR_CNT_3_MASK_CONT_RESET                                    0x0

// 0x160 (RXPCU_TEST_CFG)
#define RXPCU_TEST_CFG_TESTBUS_SEL_LSB                                         8
#define RXPCU_TEST_CFG_TESTBUS_SEL_MSB                                         10
#define RXPCU_TEST_CFG_TESTBUS_SEL_MASK                                        0x700
#define RXPCU_TEST_CFG_TESTBUS_SEL_GET(x)                                      (((x) & RXPCU_TEST_CFG_TESTBUS_SEL_MASK) >> RXPCU_TEST_CFG_TESTBUS_SEL_LSB)
#define RXPCU_TEST_CFG_TESTBUS_SEL_SET(x)                                      (((0 | (x)) << RXPCU_TEST_CFG_TESTBUS_SEL_LSB) & RXPCU_TEST_CFG_TESTBUS_SEL_MASK)
#define RXPCU_TEST_CFG_TESTBUS_SEL_RESET                                       0x0
#define RXPCU_TEST_CFG_SEL_LSB                                                 0
#define RXPCU_TEST_CFG_SEL_MSB                                                 7
#define RXPCU_TEST_CFG_SEL_MASK                                                0xff
#define RXPCU_TEST_CFG_SEL_GET(x)                                              (((x) & RXPCU_TEST_CFG_SEL_MASK) >> RXPCU_TEST_CFG_SEL_LSB)
#define RXPCU_TEST_CFG_SEL_SET(x)                                              (((0 | (x)) << RXPCU_TEST_CFG_SEL_LSB) & RXPCU_TEST_CFG_SEL_MASK)
#define RXPCU_TEST_CFG_SEL_RESET                                               0x0
#define RXPCU_TEST_CFG_ADDRESS                                                 (0x160 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_TEST_CFG_RSTMASK                                                 0x7ff
#define RXPCU_TEST_CFG_RESET                                                   0x0

// 0x164 (RXPCU_TESTBUS)
#define RXPCU_TESTBUS_VALUE_LSB                                                0
#define RXPCU_TESTBUS_VALUE_MSB                                                31
#define RXPCU_TESTBUS_VALUE_MASK                                               0xffffffff
#define RXPCU_TESTBUS_VALUE_GET(x)                                             (((x) & RXPCU_TESTBUS_VALUE_MASK) >> RXPCU_TESTBUS_VALUE_LSB)
#define RXPCU_TESTBUS_VALUE_SET(x)                                             (((0 | (x)) << RXPCU_TESTBUS_VALUE_LSB) & RXPCU_TESTBUS_VALUE_MASK)
#define RXPCU_TESTBUS_VALUE_RESET                                              0x0
#define RXPCU_TESTBUS_ADDRESS                                                  (0x164 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_TESTBUS_RSTMASK                                                  0xffffffff
#define RXPCU_TESTBUS_RESET                                                    0x0

// 0x168 (RXPCU_FSM_STATUS)
#define RXPCU_FSM_STATUS_VALUE_LSB                                             0
#define RXPCU_FSM_STATUS_VALUE_MSB                                             31
#define RXPCU_FSM_STATUS_VALUE_MASK                                            0xffffffff
#define RXPCU_FSM_STATUS_VALUE_GET(x)                                          (((x) & RXPCU_FSM_STATUS_VALUE_MASK) >> RXPCU_FSM_STATUS_VALUE_LSB)
#define RXPCU_FSM_STATUS_VALUE_SET(x)                                          (((0 | (x)) << RXPCU_FSM_STATUS_VALUE_LSB) & RXPCU_FSM_STATUS_VALUE_MASK)
#define RXPCU_FSM_STATUS_VALUE_RESET                                           0x0
#define RXPCU_FSM_STATUS_ADDRESS                                               (0x168 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_FSM_STATUS_RSTMASK                                               0xffffffff
#define RXPCU_FSM_STATUS_RESET                                                 0x0

// 0x16c (RXPCU_SPARE_REG1)
#define RXPCU_SPARE_REG1_VALUE_LSB                                             0
#define RXPCU_SPARE_REG1_VALUE_MSB                                             31
#define RXPCU_SPARE_REG1_VALUE_MASK                                            0xffffffff
#define RXPCU_SPARE_REG1_VALUE_GET(x)                                          (((x) & RXPCU_SPARE_REG1_VALUE_MASK) >> RXPCU_SPARE_REG1_VALUE_LSB)
#define RXPCU_SPARE_REG1_VALUE_SET(x)                                          (((0 | (x)) << RXPCU_SPARE_REG1_VALUE_LSB) & RXPCU_SPARE_REG1_VALUE_MASK)
#define RXPCU_SPARE_REG1_VALUE_RESET                                           0x0
#define RXPCU_SPARE_REG1_ADDRESS                                               (0x16c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_SPARE_REG1_RSTMASK                                               0xffffffff
#define RXPCU_SPARE_REG1_RESET                                                 0x0

// 0x170 (RXPCU_SPARE_REG2)
#define RXPCU_SPARE_REG2_VALUE_LSB                                             0
#define RXPCU_SPARE_REG2_VALUE_MSB                                             31
#define RXPCU_SPARE_REG2_VALUE_MASK                                            0xffffffff
#define RXPCU_SPARE_REG2_VALUE_GET(x)                                          (((x) & RXPCU_SPARE_REG2_VALUE_MASK) >> RXPCU_SPARE_REG2_VALUE_LSB)
#define RXPCU_SPARE_REG2_VALUE_SET(x)                                          (((0 | (x)) << RXPCU_SPARE_REG2_VALUE_LSB) & RXPCU_SPARE_REG2_VALUE_MASK)
#define RXPCU_SPARE_REG2_VALUE_RESET                                           0x200
#define RXPCU_SPARE_REG2_ADDRESS                                               (0x170 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_SPARE_REG2_RSTMASK                                               0xffffffff
#define RXPCU_SPARE_REG2_RESET                                                 0x200

// 0x174 (RXPCU_PHY_INTF_TLV_CNT1)
#define RXPCU_PHY_INTF_TLV_CNT1_RX_PHY_PPDU_END_CNT_LSB                        16
#define RXPCU_PHY_INTF_TLV_CNT1_RX_PHY_PPDU_END_CNT_MSB                        31
#define RXPCU_PHY_INTF_TLV_CNT1_RX_PHY_PPDU_END_CNT_MASK                       0xffff0000
#define RXPCU_PHY_INTF_TLV_CNT1_RX_PHY_PPDU_END_CNT_GET(x)                     (((x) & RXPCU_PHY_INTF_TLV_CNT1_RX_PHY_PPDU_END_CNT_MASK) >> RXPCU_PHY_INTF_TLV_CNT1_RX_PHY_PPDU_END_CNT_LSB)
#define RXPCU_PHY_INTF_TLV_CNT1_RX_PHY_PPDU_END_CNT_SET(x)                     (((0 | (x)) << RXPCU_PHY_INTF_TLV_CNT1_RX_PHY_PPDU_END_CNT_LSB) & RXPCU_PHY_INTF_TLV_CNT1_RX_PHY_PPDU_END_CNT_MASK)
#define RXPCU_PHY_INTF_TLV_CNT1_RX_PHY_PPDU_END_CNT_RESET                      0x0
#define RXPCU_PHY_INTF_TLV_CNT1_RX_RSSI_LEGACY_CNT_LSB                         0
#define RXPCU_PHY_INTF_TLV_CNT1_RX_RSSI_LEGACY_CNT_MSB                         15
#define RXPCU_PHY_INTF_TLV_CNT1_RX_RSSI_LEGACY_CNT_MASK                        0xffff
#define RXPCU_PHY_INTF_TLV_CNT1_RX_RSSI_LEGACY_CNT_GET(x)                      (((x) & RXPCU_PHY_INTF_TLV_CNT1_RX_RSSI_LEGACY_CNT_MASK) >> RXPCU_PHY_INTF_TLV_CNT1_RX_RSSI_LEGACY_CNT_LSB)
#define RXPCU_PHY_INTF_TLV_CNT1_RX_RSSI_LEGACY_CNT_SET(x)                      (((0 | (x)) << RXPCU_PHY_INTF_TLV_CNT1_RX_RSSI_LEGACY_CNT_LSB) & RXPCU_PHY_INTF_TLV_CNT1_RX_RSSI_LEGACY_CNT_MASK)
#define RXPCU_PHY_INTF_TLV_CNT1_RX_RSSI_LEGACY_CNT_RESET                       0x0
#define RXPCU_PHY_INTF_TLV_CNT1_ADDRESS                                        (0x174 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_PHY_INTF_TLV_CNT1_RSTMASK                                        0xffffffff
#define RXPCU_PHY_INTF_TLV_CNT1_RESET                                          0x0

// 0x178 (RXPCU_PHY_INTF_TLV_CNT2)
#define RXPCU_PHY_INTF_TLV_CNT2_RX_11B_PKT_CNT_LSB                             24
#define RXPCU_PHY_INTF_TLV_CNT2_RX_11B_PKT_CNT_MSB                             31
#define RXPCU_PHY_INTF_TLV_CNT2_RX_11B_PKT_CNT_MASK                            0xff000000
#define RXPCU_PHY_INTF_TLV_CNT2_RX_11B_PKT_CNT_GET(x)                          (((x) & RXPCU_PHY_INTF_TLV_CNT2_RX_11B_PKT_CNT_MASK) >> RXPCU_PHY_INTF_TLV_CNT2_RX_11B_PKT_CNT_LSB)
#define RXPCU_PHY_INTF_TLV_CNT2_RX_11B_PKT_CNT_SET(x)                          (((0 | (x)) << RXPCU_PHY_INTF_TLV_CNT2_RX_11B_PKT_CNT_LSB) & RXPCU_PHY_INTF_TLV_CNT2_RX_11B_PKT_CNT_MASK)
#define RXPCU_PHY_INTF_TLV_CNT2_RX_11B_PKT_CNT_RESET                           0x0
#define RXPCU_PHY_INTF_TLV_CNT2_RX_PKT_END_CNT_LSB                             16
#define RXPCU_PHY_INTF_TLV_CNT2_RX_PKT_END_CNT_MSB                             23
#define RXPCU_PHY_INTF_TLV_CNT2_RX_PKT_END_CNT_MASK                            0xff0000
#define RXPCU_PHY_INTF_TLV_CNT2_RX_PKT_END_CNT_GET(x)                          (((x) & RXPCU_PHY_INTF_TLV_CNT2_RX_PKT_END_CNT_MASK) >> RXPCU_PHY_INTF_TLV_CNT2_RX_PKT_END_CNT_LSB)
#define RXPCU_PHY_INTF_TLV_CNT2_RX_PKT_END_CNT_SET(x)                          (((0 | (x)) << RXPCU_PHY_INTF_TLV_CNT2_RX_PKT_END_CNT_LSB) & RXPCU_PHY_INTF_TLV_CNT2_RX_PKT_END_CNT_MASK)
#define RXPCU_PHY_INTF_TLV_CNT2_RX_PKT_END_CNT_RESET                           0x0
#define RXPCU_PHY_INTF_TLV_CNT2_RX_PKT_USER0_CNT_LSB                           8
#define RXPCU_PHY_INTF_TLV_CNT2_RX_PKT_USER0_CNT_MSB                           15
#define RXPCU_PHY_INTF_TLV_CNT2_RX_PKT_USER0_CNT_MASK                          0xff00
#define RXPCU_PHY_INTF_TLV_CNT2_RX_PKT_USER0_CNT_GET(x)                        (((x) & RXPCU_PHY_INTF_TLV_CNT2_RX_PKT_USER0_CNT_MASK) >> RXPCU_PHY_INTF_TLV_CNT2_RX_PKT_USER0_CNT_LSB)
#define RXPCU_PHY_INTF_TLV_CNT2_RX_PKT_USER0_CNT_SET(x)                        (((0 | (x)) << RXPCU_PHY_INTF_TLV_CNT2_RX_PKT_USER0_CNT_LSB) & RXPCU_PHY_INTF_TLV_CNT2_RX_PKT_USER0_CNT_MASK)
#define RXPCU_PHY_INTF_TLV_CNT2_RX_PKT_USER0_CNT_RESET                         0x0
#define RXPCU_PHY_INTF_TLV_CNT2_RX_TERMINATE_CNT_LSB                           0
#define RXPCU_PHY_INTF_TLV_CNT2_RX_TERMINATE_CNT_MSB                           7
#define RXPCU_PHY_INTF_TLV_CNT2_RX_TERMINATE_CNT_MASK                          0xff
#define RXPCU_PHY_INTF_TLV_CNT2_RX_TERMINATE_CNT_GET(x)                        (((x) & RXPCU_PHY_INTF_TLV_CNT2_RX_TERMINATE_CNT_MASK) >> RXPCU_PHY_INTF_TLV_CNT2_RX_TERMINATE_CNT_LSB)
#define RXPCU_PHY_INTF_TLV_CNT2_RX_TERMINATE_CNT_SET(x)                        (((0 | (x)) << RXPCU_PHY_INTF_TLV_CNT2_RX_TERMINATE_CNT_LSB) & RXPCU_PHY_INTF_TLV_CNT2_RX_TERMINATE_CNT_MASK)
#define RXPCU_PHY_INTF_TLV_CNT2_RX_TERMINATE_CNT_RESET                         0x0
#define RXPCU_PHY_INTF_TLV_CNT2_ADDRESS                                        (0x178 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_PHY_INTF_TLV_CNT2_RSTMASK                                        0xffffffff
#define RXPCU_PHY_INTF_TLV_CNT2_RESET                                          0x0

// 0x17c (RXPCU_PHY_INTF_TLV_CNT3)
#define RXPCU_PHY_INTF_TLV_CNT3_RX_11AC_MU_PKT_CNT_LSB                         24
#define RXPCU_PHY_INTF_TLV_CNT3_RX_11AC_MU_PKT_CNT_MSB                         31
#define RXPCU_PHY_INTF_TLV_CNT3_RX_11AC_MU_PKT_CNT_MASK                        0xff000000
#define RXPCU_PHY_INTF_TLV_CNT3_RX_11AC_MU_PKT_CNT_GET(x)                      (((x) & RXPCU_PHY_INTF_TLV_CNT3_RX_11AC_MU_PKT_CNT_MASK) >> RXPCU_PHY_INTF_TLV_CNT3_RX_11AC_MU_PKT_CNT_LSB)
#define RXPCU_PHY_INTF_TLV_CNT3_RX_11AC_MU_PKT_CNT_SET(x)                      (((0 | (x)) << RXPCU_PHY_INTF_TLV_CNT3_RX_11AC_MU_PKT_CNT_LSB) & RXPCU_PHY_INTF_TLV_CNT3_RX_11AC_MU_PKT_CNT_MASK)
#define RXPCU_PHY_INTF_TLV_CNT3_RX_11AC_MU_PKT_CNT_RESET                       0x0
#define RXPCU_PHY_INTF_TLV_CNT3_RX_11AC_SU_PKT_CNT_LSB                         16
#define RXPCU_PHY_INTF_TLV_CNT3_RX_11AC_SU_PKT_CNT_MSB                         23
#define RXPCU_PHY_INTF_TLV_CNT3_RX_11AC_SU_PKT_CNT_MASK                        0xff0000
#define RXPCU_PHY_INTF_TLV_CNT3_RX_11AC_SU_PKT_CNT_GET(x)                      (((x) & RXPCU_PHY_INTF_TLV_CNT3_RX_11AC_SU_PKT_CNT_MASK) >> RXPCU_PHY_INTF_TLV_CNT3_RX_11AC_SU_PKT_CNT_LSB)
#define RXPCU_PHY_INTF_TLV_CNT3_RX_11AC_SU_PKT_CNT_SET(x)                      (((0 | (x)) << RXPCU_PHY_INTF_TLV_CNT3_RX_11AC_SU_PKT_CNT_LSB) & RXPCU_PHY_INTF_TLV_CNT3_RX_11AC_SU_PKT_CNT_MASK)
#define RXPCU_PHY_INTF_TLV_CNT3_RX_11AC_SU_PKT_CNT_RESET                       0x0
#define RXPCU_PHY_INTF_TLV_CNT3_RX_11N_PKT_CNT_LSB                             8
#define RXPCU_PHY_INTF_TLV_CNT3_RX_11N_PKT_CNT_MSB                             15
#define RXPCU_PHY_INTF_TLV_CNT3_RX_11N_PKT_CNT_MASK                            0xff00
#define RXPCU_PHY_INTF_TLV_CNT3_RX_11N_PKT_CNT_GET(x)                          (((x) & RXPCU_PHY_INTF_TLV_CNT3_RX_11N_PKT_CNT_MASK) >> RXPCU_PHY_INTF_TLV_CNT3_RX_11N_PKT_CNT_LSB)
#define RXPCU_PHY_INTF_TLV_CNT3_RX_11N_PKT_CNT_SET(x)                          (((0 | (x)) << RXPCU_PHY_INTF_TLV_CNT3_RX_11N_PKT_CNT_LSB) & RXPCU_PHY_INTF_TLV_CNT3_RX_11N_PKT_CNT_MASK)
#define RXPCU_PHY_INTF_TLV_CNT3_RX_11N_PKT_CNT_RESET                           0x0
#define RXPCU_PHY_INTF_TLV_CNT3_RX_11A_PKT_CNT_LSB                             0
#define RXPCU_PHY_INTF_TLV_CNT3_RX_11A_PKT_CNT_MSB                             7
#define RXPCU_PHY_INTF_TLV_CNT3_RX_11A_PKT_CNT_MASK                            0xff
#define RXPCU_PHY_INTF_TLV_CNT3_RX_11A_PKT_CNT_GET(x)                          (((x) & RXPCU_PHY_INTF_TLV_CNT3_RX_11A_PKT_CNT_MASK) >> RXPCU_PHY_INTF_TLV_CNT3_RX_11A_PKT_CNT_LSB)
#define RXPCU_PHY_INTF_TLV_CNT3_RX_11A_PKT_CNT_SET(x)                          (((0 | (x)) << RXPCU_PHY_INTF_TLV_CNT3_RX_11A_PKT_CNT_LSB) & RXPCU_PHY_INTF_TLV_CNT3_RX_11A_PKT_CNT_MASK)
#define RXPCU_PHY_INTF_TLV_CNT3_RX_11A_PKT_CNT_RESET                           0x0
#define RXPCU_PHY_INTF_TLV_CNT3_ADDRESS                                        (0x17c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_PHY_INTF_TLV_CNT3_RSTMASK                                        0xffffffff
#define RXPCU_PHY_INTF_TLV_CNT3_RESET                                          0x0

// 0x184 (RXPCU_PHY_INTF_TLV_RCVD)
#define RXPCU_PHY_INTF_TLV_RCVD_BITMAP_PREVIOUS_LSB                            16
#define RXPCU_PHY_INTF_TLV_RCVD_BITMAP_PREVIOUS_MSB                            31
#define RXPCU_PHY_INTF_TLV_RCVD_BITMAP_PREVIOUS_MASK                           0xffff0000
#define RXPCU_PHY_INTF_TLV_RCVD_BITMAP_PREVIOUS_GET(x)                         (((x) & RXPCU_PHY_INTF_TLV_RCVD_BITMAP_PREVIOUS_MASK) >> RXPCU_PHY_INTF_TLV_RCVD_BITMAP_PREVIOUS_LSB)
#define RXPCU_PHY_INTF_TLV_RCVD_BITMAP_PREVIOUS_SET(x)                         (((0 | (x)) << RXPCU_PHY_INTF_TLV_RCVD_BITMAP_PREVIOUS_LSB) & RXPCU_PHY_INTF_TLV_RCVD_BITMAP_PREVIOUS_MASK)
#define RXPCU_PHY_INTF_TLV_RCVD_BITMAP_PREVIOUS_RESET                          0x0
#define RXPCU_PHY_INTF_TLV_RCVD_BITMAP_CURRENT_LSB                             0
#define RXPCU_PHY_INTF_TLV_RCVD_BITMAP_CURRENT_MSB                             15
#define RXPCU_PHY_INTF_TLV_RCVD_BITMAP_CURRENT_MASK                            0xffff
#define RXPCU_PHY_INTF_TLV_RCVD_BITMAP_CURRENT_GET(x)                          (((x) & RXPCU_PHY_INTF_TLV_RCVD_BITMAP_CURRENT_MASK) >> RXPCU_PHY_INTF_TLV_RCVD_BITMAP_CURRENT_LSB)
#define RXPCU_PHY_INTF_TLV_RCVD_BITMAP_CURRENT_SET(x)                          (((0 | (x)) << RXPCU_PHY_INTF_TLV_RCVD_BITMAP_CURRENT_LSB) & RXPCU_PHY_INTF_TLV_RCVD_BITMAP_CURRENT_MASK)
#define RXPCU_PHY_INTF_TLV_RCVD_BITMAP_CURRENT_RESET                           0x0
#define RXPCU_PHY_INTF_TLV_RCVD_ADDRESS                                        (0x184 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_PHY_INTF_TLV_RCVD_RSTMASK                                        0xffffffff
#define RXPCU_PHY_INTF_TLV_RCVD_RESET                                          0x0

// 0x190 (RXPCU_TXPCU_INTF_TLV_CNT1)
#define RXPCU_TXPCU_INTF_TLV_CNT1_TX_FRAME_INFO_CNT_LSB                        0
#define RXPCU_TXPCU_INTF_TLV_CNT1_TX_FRAME_INFO_CNT_MSB                        7
#define RXPCU_TXPCU_INTF_TLV_CNT1_TX_FRAME_INFO_CNT_MASK                       0xff
#define RXPCU_TXPCU_INTF_TLV_CNT1_TX_FRAME_INFO_CNT_GET(x)                     (((x) & RXPCU_TXPCU_INTF_TLV_CNT1_TX_FRAME_INFO_CNT_MASK) >> RXPCU_TXPCU_INTF_TLV_CNT1_TX_FRAME_INFO_CNT_LSB)
#define RXPCU_TXPCU_INTF_TLV_CNT1_TX_FRAME_INFO_CNT_SET(x)                     (((0 | (x)) << RXPCU_TXPCU_INTF_TLV_CNT1_TX_FRAME_INFO_CNT_LSB) & RXPCU_TXPCU_INTF_TLV_CNT1_TX_FRAME_INFO_CNT_MASK)
#define RXPCU_TXPCU_INTF_TLV_CNT1_TX_FRAME_INFO_CNT_RESET                      0x0
#define RXPCU_TXPCU_INTF_TLV_CNT1_ADDRESS                                      (0x190 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_TXPCU_INTF_TLV_CNT1_RSTMASK                                      0xff
#define RXPCU_TXPCU_INTF_TLV_CNT1_RESET                                        0x0

// 0x194 (RXPCU_TXPCU_INTF_TLV_CNT2)
#define RXPCU_TXPCU_INTF_TLV_CNT2_RX_MESSAGE_CNT_LSB                           24
#define RXPCU_TXPCU_INTF_TLV_CNT2_RX_MESSAGE_CNT_MSB                           31
#define RXPCU_TXPCU_INTF_TLV_CNT2_RX_MESSAGE_CNT_MASK                          0xff000000
#define RXPCU_TXPCU_INTF_TLV_CNT2_RX_MESSAGE_CNT_GET(x)                        (((x) & RXPCU_TXPCU_INTF_TLV_CNT2_RX_MESSAGE_CNT_MASK) >> RXPCU_TXPCU_INTF_TLV_CNT2_RX_MESSAGE_CNT_LSB)
#define RXPCU_TXPCU_INTF_TLV_CNT2_RX_MESSAGE_CNT_SET(x)                        (((0 | (x)) << RXPCU_TXPCU_INTF_TLV_CNT2_RX_MESSAGE_CNT_LSB) & RXPCU_TXPCU_INTF_TLV_CNT2_RX_MESSAGE_CNT_MASK)
#define RXPCU_TXPCU_INTF_TLV_CNT2_RX_MESSAGE_CNT_RESET                         0x0
#define RXPCU_TXPCU_INTF_TLV_CNT2_RX_RESP_CNT_LSB                              16
#define RXPCU_TXPCU_INTF_TLV_CNT2_RX_RESP_CNT_MSB                              23
#define RXPCU_TXPCU_INTF_TLV_CNT2_RX_RESP_CNT_MASK                             0xff0000
#define RXPCU_TXPCU_INTF_TLV_CNT2_RX_RESP_CNT_GET(x)                           (((x) & RXPCU_TXPCU_INTF_TLV_CNT2_RX_RESP_CNT_MASK) >> RXPCU_TXPCU_INTF_TLV_CNT2_RX_RESP_CNT_LSB)
#define RXPCU_TXPCU_INTF_TLV_CNT2_RX_RESP_CNT_SET(x)                           (((0 | (x)) << RXPCU_TXPCU_INTF_TLV_CNT2_RX_RESP_CNT_LSB) & RXPCU_TXPCU_INTF_TLV_CNT2_RX_RESP_CNT_MASK)
#define RXPCU_TXPCU_INTF_TLV_CNT2_RX_RESP_CNT_RESET                            0x0
#define RXPCU_TXPCU_INTF_TLV_CNT2_RX_FRAME_INFO_CNT_LSB                        8
#define RXPCU_TXPCU_INTF_TLV_CNT2_RX_FRAME_INFO_CNT_MSB                        15
#define RXPCU_TXPCU_INTF_TLV_CNT2_RX_FRAME_INFO_CNT_MASK                       0xff00
#define RXPCU_TXPCU_INTF_TLV_CNT2_RX_FRAME_INFO_CNT_GET(x)                     (((x) & RXPCU_TXPCU_INTF_TLV_CNT2_RX_FRAME_INFO_CNT_MASK) >> RXPCU_TXPCU_INTF_TLV_CNT2_RX_FRAME_INFO_CNT_LSB)
#define RXPCU_TXPCU_INTF_TLV_CNT2_RX_FRAME_INFO_CNT_SET(x)                     (((0 | (x)) << RXPCU_TXPCU_INTF_TLV_CNT2_RX_FRAME_INFO_CNT_LSB) & RXPCU_TXPCU_INTF_TLV_CNT2_RX_FRAME_INFO_CNT_MASK)
#define RXPCU_TXPCU_INTF_TLV_CNT2_RX_FRAME_INFO_CNT_RESET                      0x0
#define RXPCU_TXPCU_INTF_TLV_CNT2_IMPLICIT_FB_CNT_LSB                          0
#define RXPCU_TXPCU_INTF_TLV_CNT2_IMPLICIT_FB_CNT_MSB                          7
#define RXPCU_TXPCU_INTF_TLV_CNT2_IMPLICIT_FB_CNT_MASK                         0xff
#define RXPCU_TXPCU_INTF_TLV_CNT2_IMPLICIT_FB_CNT_GET(x)                       (((x) & RXPCU_TXPCU_INTF_TLV_CNT2_IMPLICIT_FB_CNT_MASK) >> RXPCU_TXPCU_INTF_TLV_CNT2_IMPLICIT_FB_CNT_LSB)
#define RXPCU_TXPCU_INTF_TLV_CNT2_IMPLICIT_FB_CNT_SET(x)                       (((0 | (x)) << RXPCU_TXPCU_INTF_TLV_CNT2_IMPLICIT_FB_CNT_LSB) & RXPCU_TXPCU_INTF_TLV_CNT2_IMPLICIT_FB_CNT_MASK)
#define RXPCU_TXPCU_INTF_TLV_CNT2_IMPLICIT_FB_CNT_RESET                        0x0
#define RXPCU_TXPCU_INTF_TLV_CNT2_ADDRESS                                      (0x194 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_TXPCU_INTF_TLV_CNT2_RSTMASK                                      0xffffffff
#define RXPCU_TXPCU_INTF_TLV_CNT2_RESET                                        0x0

// 0x198 (RXPCU_TXPCU_INTF_TLV_CNT3)
#define RXPCU_TXPCU_INTF_TLV_CNT3_NDP_NOT_RCVD_CNT_LSB                         24
#define RXPCU_TXPCU_INTF_TLV_CNT3_NDP_NOT_RCVD_CNT_MSB                         29
#define RXPCU_TXPCU_INTF_TLV_CNT3_NDP_NOT_RCVD_CNT_MASK                        0x3f000000
#define RXPCU_TXPCU_INTF_TLV_CNT3_NDP_NOT_RCVD_CNT_GET(x)                      (((x) & RXPCU_TXPCU_INTF_TLV_CNT3_NDP_NOT_RCVD_CNT_MASK) >> RXPCU_TXPCU_INTF_TLV_CNT3_NDP_NOT_RCVD_CNT_LSB)
#define RXPCU_TXPCU_INTF_TLV_CNT3_NDP_NOT_RCVD_CNT_SET(x)                      (((0 | (x)) << RXPCU_TXPCU_INTF_TLV_CNT3_NDP_NOT_RCVD_CNT_LSB) & RXPCU_TXPCU_INTF_TLV_CNT3_NDP_NOT_RCVD_CNT_MASK)
#define RXPCU_TXPCU_INTF_TLV_CNT3_NDP_NOT_RCVD_CNT_RESET                       0x0
#define RXPCU_TXPCU_INTF_TLV_CNT3_NDP_TIMEOUT_CNT_LSB                          18
#define RXPCU_TXPCU_INTF_TLV_CNT3_NDP_TIMEOUT_CNT_MSB                          23
#define RXPCU_TXPCU_INTF_TLV_CNT3_NDP_TIMEOUT_CNT_MASK                         0xfc0000
#define RXPCU_TXPCU_INTF_TLV_CNT3_NDP_TIMEOUT_CNT_GET(x)                       (((x) & RXPCU_TXPCU_INTF_TLV_CNT3_NDP_TIMEOUT_CNT_MASK) >> RXPCU_TXPCU_INTF_TLV_CNT3_NDP_TIMEOUT_CNT_LSB)
#define RXPCU_TXPCU_INTF_TLV_CNT3_NDP_TIMEOUT_CNT_SET(x)                       (((0 | (x)) << RXPCU_TXPCU_INTF_TLV_CNT3_NDP_TIMEOUT_CNT_LSB) & RXPCU_TXPCU_INTF_TLV_CNT3_NDP_TIMEOUT_CNT_MASK)
#define RXPCU_TXPCU_INTF_TLV_CNT3_NDP_TIMEOUT_CNT_RESET                        0x0
#define RXPCU_TXPCU_INTF_TLV_CNT3_TX_CBF_INFO_CNT_LSB                          12
#define RXPCU_TXPCU_INTF_TLV_CNT3_TX_CBF_INFO_CNT_MSB                          17
#define RXPCU_TXPCU_INTF_TLV_CNT3_TX_CBF_INFO_CNT_MASK                         0x3f000
#define RXPCU_TXPCU_INTF_TLV_CNT3_TX_CBF_INFO_CNT_GET(x)                       (((x) & RXPCU_TXPCU_INTF_TLV_CNT3_TX_CBF_INFO_CNT_MASK) >> RXPCU_TXPCU_INTF_TLV_CNT3_TX_CBF_INFO_CNT_LSB)
#define RXPCU_TXPCU_INTF_TLV_CNT3_TX_CBF_INFO_CNT_SET(x)                       (((0 | (x)) << RXPCU_TXPCU_INTF_TLV_CNT3_TX_CBF_INFO_CNT_LSB) & RXPCU_TXPCU_INTF_TLV_CNT3_TX_CBF_INFO_CNT_MASK)
#define RXPCU_TXPCU_INTF_TLV_CNT3_TX_CBF_INFO_CNT_RESET                        0x0
#define RXPCU_TXPCU_INTF_TLV_CNT3_EXPECT_NDP_CNT_LSB                           6
#define RXPCU_TXPCU_INTF_TLV_CNT3_EXPECT_NDP_CNT_MSB                           11
#define RXPCU_TXPCU_INTF_TLV_CNT3_EXPECT_NDP_CNT_MASK                          0xfc0
#define RXPCU_TXPCU_INTF_TLV_CNT3_EXPECT_NDP_CNT_GET(x)                        (((x) & RXPCU_TXPCU_INTF_TLV_CNT3_EXPECT_NDP_CNT_MASK) >> RXPCU_TXPCU_INTF_TLV_CNT3_EXPECT_NDP_CNT_LSB)
#define RXPCU_TXPCU_INTF_TLV_CNT3_EXPECT_NDP_CNT_SET(x)                        (((0 | (x)) << RXPCU_TXPCU_INTF_TLV_CNT3_EXPECT_NDP_CNT_LSB) & RXPCU_TXPCU_INTF_TLV_CNT3_EXPECT_NDP_CNT_MASK)
#define RXPCU_TXPCU_INTF_TLV_CNT3_EXPECT_NDP_CNT_RESET                         0x0
#define RXPCU_TXPCU_INTF_TLV_CNT3_NDPA_RCVD_CNT_LSB                            0
#define RXPCU_TXPCU_INTF_TLV_CNT3_NDPA_RCVD_CNT_MSB                            5
#define RXPCU_TXPCU_INTF_TLV_CNT3_NDPA_RCVD_CNT_MASK                           0x3f
#define RXPCU_TXPCU_INTF_TLV_CNT3_NDPA_RCVD_CNT_GET(x)                         (((x) & RXPCU_TXPCU_INTF_TLV_CNT3_NDPA_RCVD_CNT_MASK) >> RXPCU_TXPCU_INTF_TLV_CNT3_NDPA_RCVD_CNT_LSB)
#define RXPCU_TXPCU_INTF_TLV_CNT3_NDPA_RCVD_CNT_SET(x)                         (((0 | (x)) << RXPCU_TXPCU_INTF_TLV_CNT3_NDPA_RCVD_CNT_LSB) & RXPCU_TXPCU_INTF_TLV_CNT3_NDPA_RCVD_CNT_MASK)
#define RXPCU_TXPCU_INTF_TLV_CNT3_NDPA_RCVD_CNT_RESET                          0x0
#define RXPCU_TXPCU_INTF_TLV_CNT3_ADDRESS                                      (0x198 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_TXPCU_INTF_TLV_CNT3_RSTMASK                                      0x3fffffff
#define RXPCU_TXPCU_INTF_TLV_CNT3_RESET                                        0x0

// 0x19c (RXPCU_TXPCU_INTF_TLV_CNT4)
#define RXPCU_TXPCU_INTF_TLV_CNT4_TX_FREEZE_CNT_LSB                            24
#define RXPCU_TXPCU_INTF_TLV_CNT4_TX_FREEZE_CNT_MSB                            31
#define RXPCU_TXPCU_INTF_TLV_CNT4_TX_FREEZE_CNT_MASK                           0xff000000
#define RXPCU_TXPCU_INTF_TLV_CNT4_TX_FREEZE_CNT_GET(x)                         (((x) & RXPCU_TXPCU_INTF_TLV_CNT4_TX_FREEZE_CNT_MASK) >> RXPCU_TXPCU_INTF_TLV_CNT4_TX_FREEZE_CNT_LSB)
#define RXPCU_TXPCU_INTF_TLV_CNT4_TX_FREEZE_CNT_SET(x)                         (((0 | (x)) << RXPCU_TXPCU_INTF_TLV_CNT4_TX_FREEZE_CNT_LSB) & RXPCU_TXPCU_INTF_TLV_CNT4_TX_FREEZE_CNT_MASK)
#define RXPCU_TXPCU_INTF_TLV_CNT4_TX_FREEZE_CNT_RESET                          0x0
#define RXPCU_TXPCU_INTF_TLV_CNT4_PHY_NAP_CNT_LSB                              16
#define RXPCU_TXPCU_INTF_TLV_CNT4_PHY_NAP_CNT_MSB                              23
#define RXPCU_TXPCU_INTF_TLV_CNT4_PHY_NAP_CNT_MASK                             0xff0000
#define RXPCU_TXPCU_INTF_TLV_CNT4_PHY_NAP_CNT_GET(x)                           (((x) & RXPCU_TXPCU_INTF_TLV_CNT4_PHY_NAP_CNT_MASK) >> RXPCU_TXPCU_INTF_TLV_CNT4_PHY_NAP_CNT_LSB)
#define RXPCU_TXPCU_INTF_TLV_CNT4_PHY_NAP_CNT_SET(x)                           (((0 | (x)) << RXPCU_TXPCU_INTF_TLV_CNT4_PHY_NAP_CNT_LSB) & RXPCU_TXPCU_INTF_TLV_CNT4_PHY_NAP_CNT_MASK)
#define RXPCU_TXPCU_INTF_TLV_CNT4_PHY_NAP_CNT_RESET                            0x0
#define RXPCU_TXPCU_INTF_TLV_CNT4_PHY_OFF_CNT_LSB                              8
#define RXPCU_TXPCU_INTF_TLV_CNT4_PHY_OFF_CNT_MSB                              15
#define RXPCU_TXPCU_INTF_TLV_CNT4_PHY_OFF_CNT_MASK                             0xff00
#define RXPCU_TXPCU_INTF_TLV_CNT4_PHY_OFF_CNT_GET(x)                           (((x) & RXPCU_TXPCU_INTF_TLV_CNT4_PHY_OFF_CNT_MASK) >> RXPCU_TXPCU_INTF_TLV_CNT4_PHY_OFF_CNT_LSB)
#define RXPCU_TXPCU_INTF_TLV_CNT4_PHY_OFF_CNT_SET(x)                           (((0 | (x)) << RXPCU_TXPCU_INTF_TLV_CNT4_PHY_OFF_CNT_LSB) & RXPCU_TXPCU_INTF_TLV_CNT4_PHY_OFF_CNT_MASK)
#define RXPCU_TXPCU_INTF_TLV_CNT4_PHY_OFF_CNT_RESET                            0x0
#define RXPCU_TXPCU_INTF_TLV_CNT4_PHY_ON_CNT_LSB                               0
#define RXPCU_TXPCU_INTF_TLV_CNT4_PHY_ON_CNT_MSB                               7
#define RXPCU_TXPCU_INTF_TLV_CNT4_PHY_ON_CNT_MASK                              0xff
#define RXPCU_TXPCU_INTF_TLV_CNT4_PHY_ON_CNT_GET(x)                            (((x) & RXPCU_TXPCU_INTF_TLV_CNT4_PHY_ON_CNT_MASK) >> RXPCU_TXPCU_INTF_TLV_CNT4_PHY_ON_CNT_LSB)
#define RXPCU_TXPCU_INTF_TLV_CNT4_PHY_ON_CNT_SET(x)                            (((0 | (x)) << RXPCU_TXPCU_INTF_TLV_CNT4_PHY_ON_CNT_LSB) & RXPCU_TXPCU_INTF_TLV_CNT4_PHY_ON_CNT_MASK)
#define RXPCU_TXPCU_INTF_TLV_CNT4_PHY_ON_CNT_RESET                             0x0
#define RXPCU_TXPCU_INTF_TLV_CNT4_ADDRESS                                      (0x19c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_TXPCU_INTF_TLV_CNT4_RSTMASK                                      0xffffffff
#define RXPCU_TXPCU_INTF_TLV_CNT4_RESET                                        0x0

// 0x1a0 (RXPCU_TXPCU_INTF_TLV_BITMAP)
#define RXPCU_TXPCU_INTF_TLV_BITMAP_BITMAP_LSB                                 0
#define RXPCU_TXPCU_INTF_TLV_BITMAP_BITMAP_MSB                                 31
#define RXPCU_TXPCU_INTF_TLV_BITMAP_BITMAP_MASK                                0xffffffff
#define RXPCU_TXPCU_INTF_TLV_BITMAP_BITMAP_GET(x)                              (((x) & RXPCU_TXPCU_INTF_TLV_BITMAP_BITMAP_MASK) >> RXPCU_TXPCU_INTF_TLV_BITMAP_BITMAP_LSB)
#define RXPCU_TXPCU_INTF_TLV_BITMAP_BITMAP_SET(x)                              (((0 | (x)) << RXPCU_TXPCU_INTF_TLV_BITMAP_BITMAP_LSB) & RXPCU_TXPCU_INTF_TLV_BITMAP_BITMAP_MASK)
#define RXPCU_TXPCU_INTF_TLV_BITMAP_BITMAP_RESET                               0x0
#define RXPCU_TXPCU_INTF_TLV_BITMAP_ADDRESS                                    (0x1a0 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_TXPCU_INTF_TLV_BITMAP_RSTMASK                                    0xffffffff
#define RXPCU_TXPCU_INTF_TLV_BITMAP_RESET                                      0x0

// 0x1b0 (RXPCU_CRYPTO_INTF_TLV_CNT1)
#define RXPCU_CRYPTO_INTF_TLV_CNT1_RX_MPDU_END_CNT_LSB                         24
#define RXPCU_CRYPTO_INTF_TLV_CNT1_RX_MPDU_END_CNT_MSB                         31
#define RXPCU_CRYPTO_INTF_TLV_CNT1_RX_MPDU_END_CNT_MASK                        0xff000000
#define RXPCU_CRYPTO_INTF_TLV_CNT1_RX_MPDU_END_CNT_GET(x)                      (((x) & RXPCU_CRYPTO_INTF_TLV_CNT1_RX_MPDU_END_CNT_MASK) >> RXPCU_CRYPTO_INTF_TLV_CNT1_RX_MPDU_END_CNT_LSB)
#define RXPCU_CRYPTO_INTF_TLV_CNT1_RX_MPDU_END_CNT_SET(x)                      (((0 | (x)) << RXPCU_CRYPTO_INTF_TLV_CNT1_RX_MPDU_END_CNT_LSB) & RXPCU_CRYPTO_INTF_TLV_CNT1_RX_MPDU_END_CNT_MASK)
#define RXPCU_CRYPTO_INTF_TLV_CNT1_RX_MPDU_END_CNT_RESET                       0x0
#define RXPCU_CRYPTO_INTF_TLV_CNT1_RX_MPDU_PCU_START_CNT_LSB                   16
#define RXPCU_CRYPTO_INTF_TLV_CNT1_RX_MPDU_PCU_START_CNT_MSB                   23
#define RXPCU_CRYPTO_INTF_TLV_CNT1_RX_MPDU_PCU_START_CNT_MASK                  0xff0000
#define RXPCU_CRYPTO_INTF_TLV_CNT1_RX_MPDU_PCU_START_CNT_GET(x)                (((x) & RXPCU_CRYPTO_INTF_TLV_CNT1_RX_MPDU_PCU_START_CNT_MASK) >> RXPCU_CRYPTO_INTF_TLV_CNT1_RX_MPDU_PCU_START_CNT_LSB)
#define RXPCU_CRYPTO_INTF_TLV_CNT1_RX_MPDU_PCU_START_CNT_SET(x)                (((0 | (x)) << RXPCU_CRYPTO_INTF_TLV_CNT1_RX_MPDU_PCU_START_CNT_LSB) & RXPCU_CRYPTO_INTF_TLV_CNT1_RX_MPDU_PCU_START_CNT_MASK)
#define RXPCU_CRYPTO_INTF_TLV_CNT1_RX_MPDU_PCU_START_CNT_RESET                 0x0
#define RXPCU_CRYPTO_INTF_TLV_CNT1_RX_PPDU_END_CNT_LSB                         8
#define RXPCU_CRYPTO_INTF_TLV_CNT1_RX_PPDU_END_CNT_MSB                         15
#define RXPCU_CRYPTO_INTF_TLV_CNT1_RX_PPDU_END_CNT_MASK                        0xff00
#define RXPCU_CRYPTO_INTF_TLV_CNT1_RX_PPDU_END_CNT_GET(x)                      (((x) & RXPCU_CRYPTO_INTF_TLV_CNT1_RX_PPDU_END_CNT_MASK) >> RXPCU_CRYPTO_INTF_TLV_CNT1_RX_PPDU_END_CNT_LSB)
#define RXPCU_CRYPTO_INTF_TLV_CNT1_RX_PPDU_END_CNT_SET(x)                      (((0 | (x)) << RXPCU_CRYPTO_INTF_TLV_CNT1_RX_PPDU_END_CNT_LSB) & RXPCU_CRYPTO_INTF_TLV_CNT1_RX_PPDU_END_CNT_MASK)
#define RXPCU_CRYPTO_INTF_TLV_CNT1_RX_PPDU_END_CNT_RESET                       0x0
#define RXPCU_CRYPTO_INTF_TLV_CNT1_RX_PPDU_START_CNT_LSB                       0
#define RXPCU_CRYPTO_INTF_TLV_CNT1_RX_PPDU_START_CNT_MSB                       7
#define RXPCU_CRYPTO_INTF_TLV_CNT1_RX_PPDU_START_CNT_MASK                      0xff
#define RXPCU_CRYPTO_INTF_TLV_CNT1_RX_PPDU_START_CNT_GET(x)                    (((x) & RXPCU_CRYPTO_INTF_TLV_CNT1_RX_PPDU_START_CNT_MASK) >> RXPCU_CRYPTO_INTF_TLV_CNT1_RX_PPDU_START_CNT_LSB)
#define RXPCU_CRYPTO_INTF_TLV_CNT1_RX_PPDU_START_CNT_SET(x)                    (((0 | (x)) << RXPCU_CRYPTO_INTF_TLV_CNT1_RX_PPDU_START_CNT_LSB) & RXPCU_CRYPTO_INTF_TLV_CNT1_RX_PPDU_START_CNT_MASK)
#define RXPCU_CRYPTO_INTF_TLV_CNT1_RX_PPDU_START_CNT_RESET                     0x0
#define RXPCU_CRYPTO_INTF_TLV_CNT1_ADDRESS                                     (0x1b0 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_CRYPTO_INTF_TLV_CNT1_RSTMASK                                     0xffffffff
#define RXPCU_CRYPTO_INTF_TLV_CNT1_RESET                                       0x0

// 0x1b4 (RXPCU_TRIC_FSM_STATUS)
#define RXPCU_TRIC_FSM_STATUS_FSM_STATUS_LSB                                   0
#define RXPCU_TRIC_FSM_STATUS_FSM_STATUS_MSB                                   31
#define RXPCU_TRIC_FSM_STATUS_FSM_STATUS_MASK                                  0xffffffff
#define RXPCU_TRIC_FSM_STATUS_FSM_STATUS_GET(x)                                (((x) & RXPCU_TRIC_FSM_STATUS_FSM_STATUS_MASK) >> RXPCU_TRIC_FSM_STATUS_FSM_STATUS_LSB)
#define RXPCU_TRIC_FSM_STATUS_FSM_STATUS_SET(x)                                (((0 | (x)) << RXPCU_TRIC_FSM_STATUS_FSM_STATUS_LSB) & RXPCU_TRIC_FSM_STATUS_FSM_STATUS_MASK)
#define RXPCU_TRIC_FSM_STATUS_FSM_STATUS_RESET                                 0x0
#define RXPCU_TRIC_FSM_STATUS_ADDRESS                                          (0x1b4 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_TRIC_FSM_STATUS_RSTMASK                                          0xffffffff
#define RXPCU_TRIC_FSM_STATUS_RESET                                            0x0

// 0x1b8 (RXPCU_TRIC_DEBUG_STATUS)
#define RXPCU_TRIC_DEBUG_STATUS_DEBUG_STATUS_LSB                               0
#define RXPCU_TRIC_DEBUG_STATUS_DEBUG_STATUS_MSB                               31
#define RXPCU_TRIC_DEBUG_STATUS_DEBUG_STATUS_MASK                              0xffffffff
#define RXPCU_TRIC_DEBUG_STATUS_DEBUG_STATUS_GET(x)                            (((x) & RXPCU_TRIC_DEBUG_STATUS_DEBUG_STATUS_MASK) >> RXPCU_TRIC_DEBUG_STATUS_DEBUG_STATUS_LSB)
#define RXPCU_TRIC_DEBUG_STATUS_DEBUG_STATUS_SET(x)                            (((0 | (x)) << RXPCU_TRIC_DEBUG_STATUS_DEBUG_STATUS_LSB) & RXPCU_TRIC_DEBUG_STATUS_DEBUG_STATUS_MASK)
#define RXPCU_TRIC_DEBUG_STATUS_DEBUG_STATUS_RESET                             0x0
#define RXPCU_TRIC_DEBUG_STATUS_ADDRESS                                        (0x1b8 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_TRIC_DEBUG_STATUS_RSTMASK                                        0xffffffff
#define RXPCU_TRIC_DEBUG_STATUS_RESET                                          0x0

// 0x1c0 (RXPCU_DPSM_FSM_STATUS)
#define RXPCU_DPSM_FSM_STATUS_FSM_STATUS_LSB                                   0
#define RXPCU_DPSM_FSM_STATUS_FSM_STATUS_MSB                                   31
#define RXPCU_DPSM_FSM_STATUS_FSM_STATUS_MASK                                  0xffffffff
#define RXPCU_DPSM_FSM_STATUS_FSM_STATUS_GET(x)                                (((x) & RXPCU_DPSM_FSM_STATUS_FSM_STATUS_MASK) >> RXPCU_DPSM_FSM_STATUS_FSM_STATUS_LSB)
#define RXPCU_DPSM_FSM_STATUS_FSM_STATUS_SET(x)                                (((0 | (x)) << RXPCU_DPSM_FSM_STATUS_FSM_STATUS_LSB) & RXPCU_DPSM_FSM_STATUS_FSM_STATUS_MASK)
#define RXPCU_DPSM_FSM_STATUS_FSM_STATUS_RESET                                 0x0
#define RXPCU_DPSM_FSM_STATUS_ADDRESS                                          (0x1c0 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_DPSM_FSM_STATUS_RSTMASK                                          0xffffffff
#define RXPCU_DPSM_FSM_STATUS_RESET                                            0x0

// 0x1c4 (RXPCU_DPSM_DEBUG_STATUS)
#define RXPCU_DPSM_DEBUG_STATUS_DEBUG_STATUS_LSB                               0
#define RXPCU_DPSM_DEBUG_STATUS_DEBUG_STATUS_MSB                               31
#define RXPCU_DPSM_DEBUG_STATUS_DEBUG_STATUS_MASK                              0xffffffff
#define RXPCU_DPSM_DEBUG_STATUS_DEBUG_STATUS_GET(x)                            (((x) & RXPCU_DPSM_DEBUG_STATUS_DEBUG_STATUS_MASK) >> RXPCU_DPSM_DEBUG_STATUS_DEBUG_STATUS_LSB)
#define RXPCU_DPSM_DEBUG_STATUS_DEBUG_STATUS_SET(x)                            (((0 | (x)) << RXPCU_DPSM_DEBUG_STATUS_DEBUG_STATUS_LSB) & RXPCU_DPSM_DEBUG_STATUS_DEBUG_STATUS_MASK)
#define RXPCU_DPSM_DEBUG_STATUS_DEBUG_STATUS_RESET                             0x0
#define RXPCU_DPSM_DEBUG_STATUS_ADDRESS                                        (0x1c4 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_DPSM_DEBUG_STATUS_RSTMASK                                        0xffffffff
#define RXPCU_DPSM_DEBUG_STATUS_RESET                                          0x0

// 0x1d0 (RXPCU_RXSM_FSM_STATUS)
#define RXPCU_RXSM_FSM_STATUS_FSM_STATUS_LSB                                   0
#define RXPCU_RXSM_FSM_STATUS_FSM_STATUS_MSB                                   31
#define RXPCU_RXSM_FSM_STATUS_FSM_STATUS_MASK                                  0xffffffff
#define RXPCU_RXSM_FSM_STATUS_FSM_STATUS_GET(x)                                (((x) & RXPCU_RXSM_FSM_STATUS_FSM_STATUS_MASK) >> RXPCU_RXSM_FSM_STATUS_FSM_STATUS_LSB)
#define RXPCU_RXSM_FSM_STATUS_FSM_STATUS_SET(x)                                (((0 | (x)) << RXPCU_RXSM_FSM_STATUS_FSM_STATUS_LSB) & RXPCU_RXSM_FSM_STATUS_FSM_STATUS_MASK)
#define RXPCU_RXSM_FSM_STATUS_FSM_STATUS_RESET                                 0x0
#define RXPCU_RXSM_FSM_STATUS_ADDRESS                                          (0x1d0 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXSM_FSM_STATUS_RSTMASK                                          0xffffffff
#define RXPCU_RXSM_FSM_STATUS_RESET                                            0x0

// 0x1d4 (RXPCU_PKT_DEBUG_CNT1)
#define RXPCU_PKT_DEBUG_CNT1_AMPDU_CNT_LSB                                     16
#define RXPCU_PKT_DEBUG_CNT1_AMPDU_CNT_MSB                                     31
#define RXPCU_PKT_DEBUG_CNT1_AMPDU_CNT_MASK                                    0xffff0000
#define RXPCU_PKT_DEBUG_CNT1_AMPDU_CNT_GET(x)                                  (((x) & RXPCU_PKT_DEBUG_CNT1_AMPDU_CNT_MASK) >> RXPCU_PKT_DEBUG_CNT1_AMPDU_CNT_LSB)
#define RXPCU_PKT_DEBUG_CNT1_AMPDU_CNT_SET(x)                                  (((0 | (x)) << RXPCU_PKT_DEBUG_CNT1_AMPDU_CNT_LSB) & RXPCU_PKT_DEBUG_CNT1_AMPDU_CNT_MASK)
#define RXPCU_PKT_DEBUG_CNT1_AMPDU_CNT_RESET                                   0x0
#define RXPCU_PKT_DEBUG_CNT1_MPDU_CNT_LSB                                      0
#define RXPCU_PKT_DEBUG_CNT1_MPDU_CNT_MSB                                      15
#define RXPCU_PKT_DEBUG_CNT1_MPDU_CNT_MASK                                     0xffff
#define RXPCU_PKT_DEBUG_CNT1_MPDU_CNT_GET(x)                                   (((x) & RXPCU_PKT_DEBUG_CNT1_MPDU_CNT_MASK) >> RXPCU_PKT_DEBUG_CNT1_MPDU_CNT_LSB)
#define RXPCU_PKT_DEBUG_CNT1_MPDU_CNT_SET(x)                                   (((0 | (x)) << RXPCU_PKT_DEBUG_CNT1_MPDU_CNT_LSB) & RXPCU_PKT_DEBUG_CNT1_MPDU_CNT_MASK)
#define RXPCU_PKT_DEBUG_CNT1_MPDU_CNT_RESET                                    0x0
#define RXPCU_PKT_DEBUG_CNT1_ADDRESS                                           (0x1d4 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_PKT_DEBUG_CNT1_RSTMASK                                           0xffffffff
#define RXPCU_PKT_DEBUG_CNT1_RESET                                             0x0

// 0x1d8 (RXPCU_PKT_DEBUG_CNT2)
#define RXPCU_PKT_DEBUG_CNT2_FILTER_OUT_CNT_LSB                                16
#define RXPCU_PKT_DEBUG_CNT2_FILTER_OUT_CNT_MSB                                31
#define RXPCU_PKT_DEBUG_CNT2_FILTER_OUT_CNT_MASK                               0xffff0000
#define RXPCU_PKT_DEBUG_CNT2_FILTER_OUT_CNT_GET(x)                             (((x) & RXPCU_PKT_DEBUG_CNT2_FILTER_OUT_CNT_MASK) >> RXPCU_PKT_DEBUG_CNT2_FILTER_OUT_CNT_LSB)
#define RXPCU_PKT_DEBUG_CNT2_FILTER_OUT_CNT_SET(x)                             (((0 | (x)) << RXPCU_PKT_DEBUG_CNT2_FILTER_OUT_CNT_LSB) & RXPCU_PKT_DEBUG_CNT2_FILTER_OUT_CNT_MASK)
#define RXPCU_PKT_DEBUG_CNT2_FILTER_OUT_CNT_RESET                              0x0
#define RXPCU_PKT_DEBUG_CNT2_FILTER_IN_CNT_LSB                                 0
#define RXPCU_PKT_DEBUG_CNT2_FILTER_IN_CNT_MSB                                 15
#define RXPCU_PKT_DEBUG_CNT2_FILTER_IN_CNT_MASK                                0xffff
#define RXPCU_PKT_DEBUG_CNT2_FILTER_IN_CNT_GET(x)                              (((x) & RXPCU_PKT_DEBUG_CNT2_FILTER_IN_CNT_MASK) >> RXPCU_PKT_DEBUG_CNT2_FILTER_IN_CNT_LSB)
#define RXPCU_PKT_DEBUG_CNT2_FILTER_IN_CNT_SET(x)                              (((0 | (x)) << RXPCU_PKT_DEBUG_CNT2_FILTER_IN_CNT_LSB) & RXPCU_PKT_DEBUG_CNT2_FILTER_IN_CNT_MASK)
#define RXPCU_PKT_DEBUG_CNT2_FILTER_IN_CNT_RESET                               0x0
#define RXPCU_PKT_DEBUG_CNT2_ADDRESS                                           (0x1d8 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_PKT_DEBUG_CNT2_RSTMASK                                           0xffffffff
#define RXPCU_PKT_DEBUG_CNT2_RESET                                             0x0

// 0x1dc (RXPCU_EVENTBUS_MASK1)
#define RXPCU_EVENTBUS_MASK1_VALUE_LSB                                         0
#define RXPCU_EVENTBUS_MASK1_VALUE_MSB                                         31
#define RXPCU_EVENTBUS_MASK1_VALUE_MASK                                        0xffffffff
#define RXPCU_EVENTBUS_MASK1_VALUE_GET(x)                                      (((x) & RXPCU_EVENTBUS_MASK1_VALUE_MASK) >> RXPCU_EVENTBUS_MASK1_VALUE_LSB)
#define RXPCU_EVENTBUS_MASK1_VALUE_SET(x)                                      (((0 | (x)) << RXPCU_EVENTBUS_MASK1_VALUE_LSB) & RXPCU_EVENTBUS_MASK1_VALUE_MASK)
#define RXPCU_EVENTBUS_MASK1_VALUE_RESET                                       0x0
#define RXPCU_EVENTBUS_MASK1_ADDRESS                                           (0x1dc + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_EVENTBUS_MASK1_RSTMASK                                           0xffffffff
#define RXPCU_EVENTBUS_MASK1_RESET                                             0x0

// 0x1e0 (RXPCU_EVENTBUS_MASK2)
#define RXPCU_EVENTBUS_MASK2_VALUE_LSB                                         0
#define RXPCU_EVENTBUS_MASK2_VALUE_MSB                                         31
#define RXPCU_EVENTBUS_MASK2_VALUE_MASK                                        0xffffffff
#define RXPCU_EVENTBUS_MASK2_VALUE_GET(x)                                      (((x) & RXPCU_EVENTBUS_MASK2_VALUE_MASK) >> RXPCU_EVENTBUS_MASK2_VALUE_LSB)
#define RXPCU_EVENTBUS_MASK2_VALUE_SET(x)                                      (((0 | (x)) << RXPCU_EVENTBUS_MASK2_VALUE_LSB) & RXPCU_EVENTBUS_MASK2_VALUE_MASK)
#define RXPCU_EVENTBUS_MASK2_VALUE_RESET                                       0x0
#define RXPCU_EVENTBUS_MASK2_ADDRESS                                           (0x1e0 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_EVENTBUS_MASK2_RSTMASK                                           0xffffffff
#define RXPCU_EVENTBUS_MASK2_RESET                                             0x0

// 0x1e4 (RXPCU_CMNTRIG_CFG)
#define RXPCU_CMNTRIG_CFG_TESTBUS_SEL_LSB                                      8
#define RXPCU_CMNTRIG_CFG_TESTBUS_SEL_MSB                                      10
#define RXPCU_CMNTRIG_CFG_TESTBUS_SEL_MASK                                     0x700
#define RXPCU_CMNTRIG_CFG_TESTBUS_SEL_GET(x)                                   (((x) & RXPCU_CMNTRIG_CFG_TESTBUS_SEL_MASK) >> RXPCU_CMNTRIG_CFG_TESTBUS_SEL_LSB)
#define RXPCU_CMNTRIG_CFG_TESTBUS_SEL_SET(x)                                   (((0 | (x)) << RXPCU_CMNTRIG_CFG_TESTBUS_SEL_LSB) & RXPCU_CMNTRIG_CFG_TESTBUS_SEL_MASK)
#define RXPCU_CMNTRIG_CFG_TESTBUS_SEL_RESET                                    0x0
#define RXPCU_CMNTRIG_CFG_SEL_LSB                                              0
#define RXPCU_CMNTRIG_CFG_SEL_MSB                                              7
#define RXPCU_CMNTRIG_CFG_SEL_MASK                                             0xff
#define RXPCU_CMNTRIG_CFG_SEL_GET(x)                                           (((x) & RXPCU_CMNTRIG_CFG_SEL_MASK) >> RXPCU_CMNTRIG_CFG_SEL_LSB)
#define RXPCU_CMNTRIG_CFG_SEL_SET(x)                                           (((0 | (x)) << RXPCU_CMNTRIG_CFG_SEL_LSB) & RXPCU_CMNTRIG_CFG_SEL_MASK)
#define RXPCU_CMNTRIG_CFG_SEL_RESET                                            0x0
#define RXPCU_CMNTRIG_CFG_ADDRESS                                              (0x1e4 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_CMNTRIG_CFG_RSTMASK                                              0x7ff
#define RXPCU_CMNTRIG_CFG_RESET                                                0x0

// 0x1e8 (RXPCU_CMNTRIG_MASK_L32)
#define RXPCU_CMNTRIG_MASK_L32_VALUE_LSB                                       0
#define RXPCU_CMNTRIG_MASK_L32_VALUE_MSB                                       31
#define RXPCU_CMNTRIG_MASK_L32_VALUE_MASK                                      0xffffffff
#define RXPCU_CMNTRIG_MASK_L32_VALUE_GET(x)                                    (((x) & RXPCU_CMNTRIG_MASK_L32_VALUE_MASK) >> RXPCU_CMNTRIG_MASK_L32_VALUE_LSB)
#define RXPCU_CMNTRIG_MASK_L32_VALUE_SET(x)                                    (((0 | (x)) << RXPCU_CMNTRIG_MASK_L32_VALUE_LSB) & RXPCU_CMNTRIG_MASK_L32_VALUE_MASK)
#define RXPCU_CMNTRIG_MASK_L32_VALUE_RESET                                     0x0
#define RXPCU_CMNTRIG_MASK_L32_ADDRESS                                         (0x1e8 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_CMNTRIG_MASK_L32_RSTMASK                                         0xffffffff
#define RXPCU_CMNTRIG_MASK_L32_RESET                                           0x0

// 0x1ec (RXPCU_CMNTRIG_MASK_U03)
#define RXPCU_CMNTRIG_MASK_U03_VALUE_LSB                                       0
#define RXPCU_CMNTRIG_MASK_U03_VALUE_MSB                                       2
#define RXPCU_CMNTRIG_MASK_U03_VALUE_MASK                                      0x7
#define RXPCU_CMNTRIG_MASK_U03_VALUE_GET(x)                                    (((x) & RXPCU_CMNTRIG_MASK_U03_VALUE_MASK) >> RXPCU_CMNTRIG_MASK_U03_VALUE_LSB)
#define RXPCU_CMNTRIG_MASK_U03_VALUE_SET(x)                                    (((0 | (x)) << RXPCU_CMNTRIG_MASK_U03_VALUE_LSB) & RXPCU_CMNTRIG_MASK_U03_VALUE_MASK)
#define RXPCU_CMNTRIG_MASK_U03_VALUE_RESET                                     0x0
#define RXPCU_CMNTRIG_MASK_U03_ADDRESS                                         (0x1ec + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_CMNTRIG_MASK_U03_RSTMASK                                         0x7
#define RXPCU_CMNTRIG_MASK_U03_RESET                                           0x0

// 0x1f0 (RXPCU_CMNTRIG_MATCH_L32)
#define RXPCU_CMNTRIG_MATCH_L32_VALUE_LSB                                      0
#define RXPCU_CMNTRIG_MATCH_L32_VALUE_MSB                                      31
#define RXPCU_CMNTRIG_MATCH_L32_VALUE_MASK                                     0xffffffff
#define RXPCU_CMNTRIG_MATCH_L32_VALUE_GET(x)                                   (((x) & RXPCU_CMNTRIG_MATCH_L32_VALUE_MASK) >> RXPCU_CMNTRIG_MATCH_L32_VALUE_LSB)
#define RXPCU_CMNTRIG_MATCH_L32_VALUE_SET(x)                                   (((0 | (x)) << RXPCU_CMNTRIG_MATCH_L32_VALUE_LSB) & RXPCU_CMNTRIG_MATCH_L32_VALUE_MASK)
#define RXPCU_CMNTRIG_MATCH_L32_VALUE_RESET                                    0x0
#define RXPCU_CMNTRIG_MATCH_L32_ADDRESS                                        (0x1f0 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_CMNTRIG_MATCH_L32_RSTMASK                                        0xffffffff
#define RXPCU_CMNTRIG_MATCH_L32_RESET                                          0x0

// 0x1f4 (RXPCU_CMNTRIG_MATCH_U03)
#define RXPCU_CMNTRIG_MATCH_U03_VALUE_LSB                                      0
#define RXPCU_CMNTRIG_MATCH_U03_VALUE_MSB                                      2
#define RXPCU_CMNTRIG_MATCH_U03_VALUE_MASK                                     0x7
#define RXPCU_CMNTRIG_MATCH_U03_VALUE_GET(x)                                   (((x) & RXPCU_CMNTRIG_MATCH_U03_VALUE_MASK) >> RXPCU_CMNTRIG_MATCH_U03_VALUE_LSB)
#define RXPCU_CMNTRIG_MATCH_U03_VALUE_SET(x)                                   (((0 | (x)) << RXPCU_CMNTRIG_MATCH_U03_VALUE_LSB) & RXPCU_CMNTRIG_MATCH_U03_VALUE_MASK)
#define RXPCU_CMNTRIG_MATCH_U03_VALUE_RESET                                    0x0
#define RXPCU_CMNTRIG_MATCH_U03_ADDRESS                                        (0x1f4 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_CMNTRIG_MATCH_U03_RSTMASK                                        0x7
#define RXPCU_CMNTRIG_MATCH_U03_RESET                                          0x0

// 0x1f8 (RXPCU_CRYPTO_INTF_TLV_CNT2)
#define RXPCU_CRYPTO_INTF_TLV_CNT2_RX_PPDU_START_CNT_LSB                       0
#define RXPCU_CRYPTO_INTF_TLV_CNT2_RX_PPDU_START_CNT_MSB                       7
#define RXPCU_CRYPTO_INTF_TLV_CNT2_RX_PPDU_START_CNT_MASK                      0xff
#define RXPCU_CRYPTO_INTF_TLV_CNT2_RX_PPDU_START_CNT_GET(x)                    (((x) & RXPCU_CRYPTO_INTF_TLV_CNT2_RX_PPDU_START_CNT_MASK) >> RXPCU_CRYPTO_INTF_TLV_CNT2_RX_PPDU_START_CNT_LSB)
#define RXPCU_CRYPTO_INTF_TLV_CNT2_RX_PPDU_START_CNT_SET(x)                    (((0 | (x)) << RXPCU_CRYPTO_INTF_TLV_CNT2_RX_PPDU_START_CNT_LSB) & RXPCU_CRYPTO_INTF_TLV_CNT2_RX_PPDU_START_CNT_MASK)
#define RXPCU_CRYPTO_INTF_TLV_CNT2_RX_PPDU_START_CNT_RESET                     0x0
#define RXPCU_CRYPTO_INTF_TLV_CNT2_ADDRESS                                     (0x1f8 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_CRYPTO_INTF_TLV_CNT2_RSTMASK                                     0xff
#define RXPCU_CRYPTO_INTF_TLV_CNT2_RESET                                       0x0

// 0x200 (RXPCU_MAX_RX_LENGTH_DATA)
#define RXPCU_MAX_RX_LENGTH_DATA_VALUE_LSB                                     0
#define RXPCU_MAX_RX_LENGTH_DATA_VALUE_MSB                                     13
#define RXPCU_MAX_RX_LENGTH_DATA_VALUE_MASK                                    0x3fff
#define RXPCU_MAX_RX_LENGTH_DATA_VALUE_GET(x)                                  (((x) & RXPCU_MAX_RX_LENGTH_DATA_VALUE_MASK) >> RXPCU_MAX_RX_LENGTH_DATA_VALUE_LSB)
#define RXPCU_MAX_RX_LENGTH_DATA_VALUE_SET(x)                                  (((0 | (x)) << RXPCU_MAX_RX_LENGTH_DATA_VALUE_LSB) & RXPCU_MAX_RX_LENGTH_DATA_VALUE_MASK)
#define RXPCU_MAX_RX_LENGTH_DATA_VALUE_RESET                                   0x0
#define RXPCU_MAX_RX_LENGTH_DATA_ADDRESS                                       (0x200 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_MAX_RX_LENGTH_DATA_RSTMASK                                       0x3fff
#define RXPCU_MAX_RX_LENGTH_DATA_RESET                                         0x0

// 0x204 (RXPCU_MAX_RX_LENGTH_CTRL)
#define RXPCU_MAX_RX_LENGTH_CTRL_VALUE_LSB                                     0
#define RXPCU_MAX_RX_LENGTH_CTRL_VALUE_MSB                                     13
#define RXPCU_MAX_RX_LENGTH_CTRL_VALUE_MASK                                    0x3fff
#define RXPCU_MAX_RX_LENGTH_CTRL_VALUE_GET(x)                                  (((x) & RXPCU_MAX_RX_LENGTH_CTRL_VALUE_MASK) >> RXPCU_MAX_RX_LENGTH_CTRL_VALUE_LSB)
#define RXPCU_MAX_RX_LENGTH_CTRL_VALUE_SET(x)                                  (((0 | (x)) << RXPCU_MAX_RX_LENGTH_CTRL_VALUE_LSB) & RXPCU_MAX_RX_LENGTH_CTRL_VALUE_MASK)
#define RXPCU_MAX_RX_LENGTH_CTRL_VALUE_RESET                                   0x0
#define RXPCU_MAX_RX_LENGTH_CTRL_ADDRESS                                       (0x204 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_MAX_RX_LENGTH_CTRL_RSTMASK                                       0x3fff
#define RXPCU_MAX_RX_LENGTH_CTRL_RESET                                         0x0

// 0x208 (RXPCU_MAX_RX_LENGTH_MGMT)
#define RXPCU_MAX_RX_LENGTH_MGMT_VALUE_LSB                                     0
#define RXPCU_MAX_RX_LENGTH_MGMT_VALUE_MSB                                     13
#define RXPCU_MAX_RX_LENGTH_MGMT_VALUE_MASK                                    0x3fff
#define RXPCU_MAX_RX_LENGTH_MGMT_VALUE_GET(x)                                  (((x) & RXPCU_MAX_RX_LENGTH_MGMT_VALUE_MASK) >> RXPCU_MAX_RX_LENGTH_MGMT_VALUE_LSB)
#define RXPCU_MAX_RX_LENGTH_MGMT_VALUE_SET(x)                                  (((0 | (x)) << RXPCU_MAX_RX_LENGTH_MGMT_VALUE_LSB) & RXPCU_MAX_RX_LENGTH_MGMT_VALUE_MASK)
#define RXPCU_MAX_RX_LENGTH_MGMT_VALUE_RESET                                   0x0
#define RXPCU_MAX_RX_LENGTH_MGMT_ADDRESS                                       (0x208 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_MAX_RX_LENGTH_MGMT_RSTMASK                                       0x3fff
#define RXPCU_MAX_RX_LENGTH_MGMT_RESET                                         0x0

// 0x20c (RXPCU_MAX_RX_LENGTH_ERR_CNT)
#define RXPCU_MAX_RX_LENGTH_ERR_CNT_MGMT_ERR_CNT_LSB                           16
#define RXPCU_MAX_RX_LENGTH_ERR_CNT_MGMT_ERR_CNT_MSB                           23
#define RXPCU_MAX_RX_LENGTH_ERR_CNT_MGMT_ERR_CNT_MASK                          0xff0000
#define RXPCU_MAX_RX_LENGTH_ERR_CNT_MGMT_ERR_CNT_GET(x)                        (((x) & RXPCU_MAX_RX_LENGTH_ERR_CNT_MGMT_ERR_CNT_MASK) >> RXPCU_MAX_RX_LENGTH_ERR_CNT_MGMT_ERR_CNT_LSB)
#define RXPCU_MAX_RX_LENGTH_ERR_CNT_MGMT_ERR_CNT_SET(x)                        (((0 | (x)) << RXPCU_MAX_RX_LENGTH_ERR_CNT_MGMT_ERR_CNT_LSB) & RXPCU_MAX_RX_LENGTH_ERR_CNT_MGMT_ERR_CNT_MASK)
#define RXPCU_MAX_RX_LENGTH_ERR_CNT_MGMT_ERR_CNT_RESET                         0x0
#define RXPCU_MAX_RX_LENGTH_ERR_CNT_CTRL_ERR_CNT_LSB                           8
#define RXPCU_MAX_RX_LENGTH_ERR_CNT_CTRL_ERR_CNT_MSB                           15
#define RXPCU_MAX_RX_LENGTH_ERR_CNT_CTRL_ERR_CNT_MASK                          0xff00
#define RXPCU_MAX_RX_LENGTH_ERR_CNT_CTRL_ERR_CNT_GET(x)                        (((x) & RXPCU_MAX_RX_LENGTH_ERR_CNT_CTRL_ERR_CNT_MASK) >> RXPCU_MAX_RX_LENGTH_ERR_CNT_CTRL_ERR_CNT_LSB)
#define RXPCU_MAX_RX_LENGTH_ERR_CNT_CTRL_ERR_CNT_SET(x)                        (((0 | (x)) << RXPCU_MAX_RX_LENGTH_ERR_CNT_CTRL_ERR_CNT_LSB) & RXPCU_MAX_RX_LENGTH_ERR_CNT_CTRL_ERR_CNT_MASK)
#define RXPCU_MAX_RX_LENGTH_ERR_CNT_CTRL_ERR_CNT_RESET                         0x0
#define RXPCU_MAX_RX_LENGTH_ERR_CNT_DATA_ERR_CNT_LSB                           0
#define RXPCU_MAX_RX_LENGTH_ERR_CNT_DATA_ERR_CNT_MSB                           7
#define RXPCU_MAX_RX_LENGTH_ERR_CNT_DATA_ERR_CNT_MASK                          0xff
#define RXPCU_MAX_RX_LENGTH_ERR_CNT_DATA_ERR_CNT_GET(x)                        (((x) & RXPCU_MAX_RX_LENGTH_ERR_CNT_DATA_ERR_CNT_MASK) >> RXPCU_MAX_RX_LENGTH_ERR_CNT_DATA_ERR_CNT_LSB)
#define RXPCU_MAX_RX_LENGTH_ERR_CNT_DATA_ERR_CNT_SET(x)                        (((0 | (x)) << RXPCU_MAX_RX_LENGTH_ERR_CNT_DATA_ERR_CNT_LSB) & RXPCU_MAX_RX_LENGTH_ERR_CNT_DATA_ERR_CNT_MASK)
#define RXPCU_MAX_RX_LENGTH_ERR_CNT_DATA_ERR_CNT_RESET                         0x0
#define RXPCU_MAX_RX_LENGTH_ERR_CNT_ADDRESS                                    (0x20c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_MAX_RX_LENGTH_ERR_CNT_RSTMASK                                    0xffffff
#define RXPCU_MAX_RX_LENGTH_ERR_CNT_RESET                                      0x0

// 0x210 (RXPCU_CLKGATE_EN)
#define RXPCU_CLKGATE_EN_CLKGATE_EN_LSB                                        0
#define RXPCU_CLKGATE_EN_CLKGATE_EN_MSB                                        15
#define RXPCU_CLKGATE_EN_CLKGATE_EN_MASK                                       0xffff
#define RXPCU_CLKGATE_EN_CLKGATE_EN_GET(x)                                     (((x) & RXPCU_CLKGATE_EN_CLKGATE_EN_MASK) >> RXPCU_CLKGATE_EN_CLKGATE_EN_LSB)
#define RXPCU_CLKGATE_EN_CLKGATE_EN_SET(x)                                     (((0 | (x)) << RXPCU_CLKGATE_EN_CLKGATE_EN_LSB) & RXPCU_CLKGATE_EN_CLKGATE_EN_MASK)
#define RXPCU_CLKGATE_EN_CLKGATE_EN_RESET                                      0x0
#define RXPCU_CLKGATE_EN_ADDRESS                                               (0x210 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_CLKGATE_EN_RSTMASK                                               0xffff
#define RXPCU_CLKGATE_EN_RESET                                                 0x0

// 0x214 (RXPCU_PHY_ERROR_PROMISCUOUS_MASK)
#define RXPCU_PHY_ERROR_PROMISCUOUS_MASK_VALUE_LSB                             0
#define RXPCU_PHY_ERROR_PROMISCUOUS_MASK_VALUE_MSB                             31
#define RXPCU_PHY_ERROR_PROMISCUOUS_MASK_VALUE_MASK                            0xffffffff
#define RXPCU_PHY_ERROR_PROMISCUOUS_MASK_VALUE_GET(x)                          (((x) & RXPCU_PHY_ERROR_PROMISCUOUS_MASK_VALUE_MASK) >> RXPCU_PHY_ERROR_PROMISCUOUS_MASK_VALUE_LSB)
#define RXPCU_PHY_ERROR_PROMISCUOUS_MASK_VALUE_SET(x)                          (((0 | (x)) << RXPCU_PHY_ERROR_PROMISCUOUS_MASK_VALUE_LSB) & RXPCU_PHY_ERROR_PROMISCUOUS_MASK_VALUE_MASK)
#define RXPCU_PHY_ERROR_PROMISCUOUS_MASK_VALUE_RESET                           0x0
#define RXPCU_PHY_ERROR_PROMISCUOUS_MASK_ADDRESS                               (0x214 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_PHY_ERROR_PROMISCUOUS_MASK_RSTMASK                               0xffffffff
#define RXPCU_PHY_ERROR_PROMISCUOUS_MASK_RESET                                 0x0

// 0x218 (RXPCU_PHY_ERROR_PROMISCUOUS_MASK_CONT)
#define RXPCU_PHY_ERROR_PROMISCUOUS_MASK_CONT_VALUE_LSB                        0
#define RXPCU_PHY_ERROR_PROMISCUOUS_MASK_CONT_VALUE_MSB                        31
#define RXPCU_PHY_ERROR_PROMISCUOUS_MASK_CONT_VALUE_MASK                       0xffffffff
#define RXPCU_PHY_ERROR_PROMISCUOUS_MASK_CONT_VALUE_GET(x)                     (((x) & RXPCU_PHY_ERROR_PROMISCUOUS_MASK_CONT_VALUE_MASK) >> RXPCU_PHY_ERROR_PROMISCUOUS_MASK_CONT_VALUE_LSB)
#define RXPCU_PHY_ERROR_PROMISCUOUS_MASK_CONT_VALUE_SET(x)                     (((0 | (x)) << RXPCU_PHY_ERROR_PROMISCUOUS_MASK_CONT_VALUE_LSB) & RXPCU_PHY_ERROR_PROMISCUOUS_MASK_CONT_VALUE_MASK)
#define RXPCU_PHY_ERROR_PROMISCUOUS_MASK_CONT_VALUE_RESET                      0x0
#define RXPCU_PHY_ERROR_PROMISCUOUS_MASK_CONT_ADDRESS                          (0x218 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_PHY_ERROR_PROMISCUOUS_MASK_CONT_RSTMASK                          0xffffffff
#define RXPCU_PHY_ERROR_PROMISCUOUS_MASK_CONT_RESET                            0x0

// 0x1000 (RXPCU_RXBUF)
#define RXPCU_RXBUF_DATA_LSB                                                   0
#define RXPCU_RXBUF_DATA_MSB                                                   31
#define RXPCU_RXBUF_DATA_MASK                                                  0xffffffff
#define RXPCU_RXBUF_DATA_GET(x)                                                (((x) & RXPCU_RXBUF_DATA_MASK) >> RXPCU_RXBUF_DATA_LSB)
#define RXPCU_RXBUF_DATA_SET(x)                                                (((0 | (x)) << RXPCU_RXBUF_DATA_LSB) & RXPCU_RXBUF_DATA_MASK)
#define RXPCU_RXBUF_DATA_RESET                                                 0x0
#define RXPCU_RXBUF_ADDRESS                                                    (0x1000 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_RSTMASK                                                    0xffffffff
#define RXPCU_RXBUF_RESET                                                      0x0

// 0x1000 (RXPCU_RXBUF_0)
#define RXPCU_RXBUF_DATA_0_LSB                                                 0
#define RXPCU_RXBUF_DATA_0_MSB                                                 31
#define RXPCU_RXBUF_DATA_0_MASK                                                0xffffffff
#define RXPCU_RXBUF_DATA_0_GET(x)                                              (((x) & RXPCU_RXBUF_DATA_0_MASK) >> RXPCU_RXBUF_DATA_0_LSB)
#define RXPCU_RXBUF_DATA_0_SET(x)                                              (((0 | (x)) << RXPCU_RXBUF_DATA_0_LSB) & RXPCU_RXBUF_DATA_0_MASK)
#define RXPCU_RXBUF_DATA_0_RESET                                               0x0
#define RXPCU_RXBUF_0_ADDRESS                                                  (0x1000 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_0_RSTMASK                                                  0xffffffff
#define RXPCU_RXBUF_0_RESET                                                    0x0

// 0x1004 (RXPCU_RXBUF_1)
#define RXPCU_RXBUF_DATA_1_LSB                                                 0
#define RXPCU_RXBUF_DATA_1_MSB                                                 31
#define RXPCU_RXBUF_DATA_1_MASK                                                0xffffffff
#define RXPCU_RXBUF_DATA_1_GET(x)                                              (((x) & RXPCU_RXBUF_DATA_1_MASK) >> RXPCU_RXBUF_DATA_1_LSB)
#define RXPCU_RXBUF_DATA_1_SET(x)                                              (((0 | (x)) << RXPCU_RXBUF_DATA_1_LSB) & RXPCU_RXBUF_DATA_1_MASK)
#define RXPCU_RXBUF_DATA_1_RESET                                               0x0
#define RXPCU_RXBUF_1_ADDRESS                                                  (0x1004 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_1_RSTMASK                                                  0xffffffff
#define RXPCU_RXBUF_1_RESET                                                    0x0

// 0x1008 (RXPCU_RXBUF_2)
#define RXPCU_RXBUF_DATA_2_LSB                                                 0
#define RXPCU_RXBUF_DATA_2_MSB                                                 31
#define RXPCU_RXBUF_DATA_2_MASK                                                0xffffffff
#define RXPCU_RXBUF_DATA_2_GET(x)                                              (((x) & RXPCU_RXBUF_DATA_2_MASK) >> RXPCU_RXBUF_DATA_2_LSB)
#define RXPCU_RXBUF_DATA_2_SET(x)                                              (((0 | (x)) << RXPCU_RXBUF_DATA_2_LSB) & RXPCU_RXBUF_DATA_2_MASK)
#define RXPCU_RXBUF_DATA_2_RESET                                               0x0
#define RXPCU_RXBUF_2_ADDRESS                                                  (0x1008 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_2_RSTMASK                                                  0xffffffff
#define RXPCU_RXBUF_2_RESET                                                    0x0

// 0x100c (RXPCU_RXBUF_3)
#define RXPCU_RXBUF_DATA_3_LSB                                                 0
#define RXPCU_RXBUF_DATA_3_MSB                                                 31
#define RXPCU_RXBUF_DATA_3_MASK                                                0xffffffff
#define RXPCU_RXBUF_DATA_3_GET(x)                                              (((x) & RXPCU_RXBUF_DATA_3_MASK) >> RXPCU_RXBUF_DATA_3_LSB)
#define RXPCU_RXBUF_DATA_3_SET(x)                                              (((0 | (x)) << RXPCU_RXBUF_DATA_3_LSB) & RXPCU_RXBUF_DATA_3_MASK)
#define RXPCU_RXBUF_DATA_3_RESET                                               0x0
#define RXPCU_RXBUF_3_ADDRESS                                                  (0x100c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_3_RSTMASK                                                  0xffffffff
#define RXPCU_RXBUF_3_RESET                                                    0x0

// 0x1010 (RXPCU_RXBUF_4)
#define RXPCU_RXBUF_DATA_4_LSB                                                 0
#define RXPCU_RXBUF_DATA_4_MSB                                                 31
#define RXPCU_RXBUF_DATA_4_MASK                                                0xffffffff
#define RXPCU_RXBUF_DATA_4_GET(x)                                              (((x) & RXPCU_RXBUF_DATA_4_MASK) >> RXPCU_RXBUF_DATA_4_LSB)
#define RXPCU_RXBUF_DATA_4_SET(x)                                              (((0 | (x)) << RXPCU_RXBUF_DATA_4_LSB) & RXPCU_RXBUF_DATA_4_MASK)
#define RXPCU_RXBUF_DATA_4_RESET                                               0x0
#define RXPCU_RXBUF_4_ADDRESS                                                  (0x1010 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_4_RSTMASK                                                  0xffffffff
#define RXPCU_RXBUF_4_RESET                                                    0x0

// 0x1014 (RXPCU_RXBUF_5)
#define RXPCU_RXBUF_DATA_5_LSB                                                 0
#define RXPCU_RXBUF_DATA_5_MSB                                                 31
#define RXPCU_RXBUF_DATA_5_MASK                                                0xffffffff
#define RXPCU_RXBUF_DATA_5_GET(x)                                              (((x) & RXPCU_RXBUF_DATA_5_MASK) >> RXPCU_RXBUF_DATA_5_LSB)
#define RXPCU_RXBUF_DATA_5_SET(x)                                              (((0 | (x)) << RXPCU_RXBUF_DATA_5_LSB) & RXPCU_RXBUF_DATA_5_MASK)
#define RXPCU_RXBUF_DATA_5_RESET                                               0x0
#define RXPCU_RXBUF_5_ADDRESS                                                  (0x1014 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_5_RSTMASK                                                  0xffffffff
#define RXPCU_RXBUF_5_RESET                                                    0x0

// 0x1018 (RXPCU_RXBUF_6)
#define RXPCU_RXBUF_DATA_6_LSB                                                 0
#define RXPCU_RXBUF_DATA_6_MSB                                                 31
#define RXPCU_RXBUF_DATA_6_MASK                                                0xffffffff
#define RXPCU_RXBUF_DATA_6_GET(x)                                              (((x) & RXPCU_RXBUF_DATA_6_MASK) >> RXPCU_RXBUF_DATA_6_LSB)
#define RXPCU_RXBUF_DATA_6_SET(x)                                              (((0 | (x)) << RXPCU_RXBUF_DATA_6_LSB) & RXPCU_RXBUF_DATA_6_MASK)
#define RXPCU_RXBUF_DATA_6_RESET                                               0x0
#define RXPCU_RXBUF_6_ADDRESS                                                  (0x1018 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_6_RSTMASK                                                  0xffffffff
#define RXPCU_RXBUF_6_RESET                                                    0x0

// 0x101c (RXPCU_RXBUF_7)
#define RXPCU_RXBUF_DATA_7_LSB                                                 0
#define RXPCU_RXBUF_DATA_7_MSB                                                 31
#define RXPCU_RXBUF_DATA_7_MASK                                                0xffffffff
#define RXPCU_RXBUF_DATA_7_GET(x)                                              (((x) & RXPCU_RXBUF_DATA_7_MASK) >> RXPCU_RXBUF_DATA_7_LSB)
#define RXPCU_RXBUF_DATA_7_SET(x)                                              (((0 | (x)) << RXPCU_RXBUF_DATA_7_LSB) & RXPCU_RXBUF_DATA_7_MASK)
#define RXPCU_RXBUF_DATA_7_RESET                                               0x0
#define RXPCU_RXBUF_7_ADDRESS                                                  (0x101c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_7_RSTMASK                                                  0xffffffff
#define RXPCU_RXBUF_7_RESET                                                    0x0

// 0x1020 (RXPCU_RXBUF_8)
#define RXPCU_RXBUF_DATA_8_LSB                                                 0
#define RXPCU_RXBUF_DATA_8_MSB                                                 31
#define RXPCU_RXBUF_DATA_8_MASK                                                0xffffffff
#define RXPCU_RXBUF_DATA_8_GET(x)                                              (((x) & RXPCU_RXBUF_DATA_8_MASK) >> RXPCU_RXBUF_DATA_8_LSB)
#define RXPCU_RXBUF_DATA_8_SET(x)                                              (((0 | (x)) << RXPCU_RXBUF_DATA_8_LSB) & RXPCU_RXBUF_DATA_8_MASK)
#define RXPCU_RXBUF_DATA_8_RESET                                               0x0
#define RXPCU_RXBUF_8_ADDRESS                                                  (0x1020 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_8_RSTMASK                                                  0xffffffff
#define RXPCU_RXBUF_8_RESET                                                    0x0

// 0x1024 (RXPCU_RXBUF_9)
#define RXPCU_RXBUF_DATA_9_LSB                                                 0
#define RXPCU_RXBUF_DATA_9_MSB                                                 31
#define RXPCU_RXBUF_DATA_9_MASK                                                0xffffffff
#define RXPCU_RXBUF_DATA_9_GET(x)                                              (((x) & RXPCU_RXBUF_DATA_9_MASK) >> RXPCU_RXBUF_DATA_9_LSB)
#define RXPCU_RXBUF_DATA_9_SET(x)                                              (((0 | (x)) << RXPCU_RXBUF_DATA_9_LSB) & RXPCU_RXBUF_DATA_9_MASK)
#define RXPCU_RXBUF_DATA_9_RESET                                               0x0
#define RXPCU_RXBUF_9_ADDRESS                                                  (0x1024 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_9_RSTMASK                                                  0xffffffff
#define RXPCU_RXBUF_9_RESET                                                    0x0

// 0x1028 (RXPCU_RXBUF_10)
#define RXPCU_RXBUF_DATA_10_LSB                                                0
#define RXPCU_RXBUF_DATA_10_MSB                                                31
#define RXPCU_RXBUF_DATA_10_MASK                                               0xffffffff
#define RXPCU_RXBUF_DATA_10_GET(x)                                             (((x) & RXPCU_RXBUF_DATA_10_MASK) >> RXPCU_RXBUF_DATA_10_LSB)
#define RXPCU_RXBUF_DATA_10_SET(x)                                             (((0 | (x)) << RXPCU_RXBUF_DATA_10_LSB) & RXPCU_RXBUF_DATA_10_MASK)
#define RXPCU_RXBUF_DATA_10_RESET                                              0x0
#define RXPCU_RXBUF_10_ADDRESS                                                 (0x1028 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_10_RSTMASK                                                 0xffffffff
#define RXPCU_RXBUF_10_RESET                                                   0x0

// 0x102c (RXPCU_RXBUF_11)
#define RXPCU_RXBUF_DATA_11_LSB                                                0
#define RXPCU_RXBUF_DATA_11_MSB                                                31
#define RXPCU_RXBUF_DATA_11_MASK                                               0xffffffff
#define RXPCU_RXBUF_DATA_11_GET(x)                                             (((x) & RXPCU_RXBUF_DATA_11_MASK) >> RXPCU_RXBUF_DATA_11_LSB)
#define RXPCU_RXBUF_DATA_11_SET(x)                                             (((0 | (x)) << RXPCU_RXBUF_DATA_11_LSB) & RXPCU_RXBUF_DATA_11_MASK)
#define RXPCU_RXBUF_DATA_11_RESET                                              0x0
#define RXPCU_RXBUF_11_ADDRESS                                                 (0x102c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_11_RSTMASK                                                 0xffffffff
#define RXPCU_RXBUF_11_RESET                                                   0x0

// 0x1030 (RXPCU_RXBUF_12)
#define RXPCU_RXBUF_DATA_12_LSB                                                0
#define RXPCU_RXBUF_DATA_12_MSB                                                31
#define RXPCU_RXBUF_DATA_12_MASK                                               0xffffffff
#define RXPCU_RXBUF_DATA_12_GET(x)                                             (((x) & RXPCU_RXBUF_DATA_12_MASK) >> RXPCU_RXBUF_DATA_12_LSB)
#define RXPCU_RXBUF_DATA_12_SET(x)                                             (((0 | (x)) << RXPCU_RXBUF_DATA_12_LSB) & RXPCU_RXBUF_DATA_12_MASK)
#define RXPCU_RXBUF_DATA_12_RESET                                              0x0
#define RXPCU_RXBUF_12_ADDRESS                                                 (0x1030 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_12_RSTMASK                                                 0xffffffff
#define RXPCU_RXBUF_12_RESET                                                   0x0

// 0x1034 (RXPCU_RXBUF_13)
#define RXPCU_RXBUF_DATA_13_LSB                                                0
#define RXPCU_RXBUF_DATA_13_MSB                                                31
#define RXPCU_RXBUF_DATA_13_MASK                                               0xffffffff
#define RXPCU_RXBUF_DATA_13_GET(x)                                             (((x) & RXPCU_RXBUF_DATA_13_MASK) >> RXPCU_RXBUF_DATA_13_LSB)
#define RXPCU_RXBUF_DATA_13_SET(x)                                             (((0 | (x)) << RXPCU_RXBUF_DATA_13_LSB) & RXPCU_RXBUF_DATA_13_MASK)
#define RXPCU_RXBUF_DATA_13_RESET                                              0x0
#define RXPCU_RXBUF_13_ADDRESS                                                 (0x1034 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_13_RSTMASK                                                 0xffffffff
#define RXPCU_RXBUF_13_RESET                                                   0x0

// 0x1038 (RXPCU_RXBUF_14)
#define RXPCU_RXBUF_DATA_14_LSB                                                0
#define RXPCU_RXBUF_DATA_14_MSB                                                31
#define RXPCU_RXBUF_DATA_14_MASK                                               0xffffffff
#define RXPCU_RXBUF_DATA_14_GET(x)                                             (((x) & RXPCU_RXBUF_DATA_14_MASK) >> RXPCU_RXBUF_DATA_14_LSB)
#define RXPCU_RXBUF_DATA_14_SET(x)                                             (((0 | (x)) << RXPCU_RXBUF_DATA_14_LSB) & RXPCU_RXBUF_DATA_14_MASK)
#define RXPCU_RXBUF_DATA_14_RESET                                              0x0
#define RXPCU_RXBUF_14_ADDRESS                                                 (0x1038 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_14_RSTMASK                                                 0xffffffff
#define RXPCU_RXBUF_14_RESET                                                   0x0

// 0x103c (RXPCU_RXBUF_15)
#define RXPCU_RXBUF_DATA_15_LSB                                                0
#define RXPCU_RXBUF_DATA_15_MSB                                                31
#define RXPCU_RXBUF_DATA_15_MASK                                               0xffffffff
#define RXPCU_RXBUF_DATA_15_GET(x)                                             (((x) & RXPCU_RXBUF_DATA_15_MASK) >> RXPCU_RXBUF_DATA_15_LSB)
#define RXPCU_RXBUF_DATA_15_SET(x)                                             (((0 | (x)) << RXPCU_RXBUF_DATA_15_LSB) & RXPCU_RXBUF_DATA_15_MASK)
#define RXPCU_RXBUF_DATA_15_RESET                                              0x0
#define RXPCU_RXBUF_15_ADDRESS                                                 (0x103c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_15_RSTMASK                                                 0xffffffff
#define RXPCU_RXBUF_15_RESET                                                   0x0

// 0x1040 (RXPCU_RXBUF_16)
#define RXPCU_RXBUF_DATA_16_LSB                                                0
#define RXPCU_RXBUF_DATA_16_MSB                                                31
#define RXPCU_RXBUF_DATA_16_MASK                                               0xffffffff
#define RXPCU_RXBUF_DATA_16_GET(x)                                             (((x) & RXPCU_RXBUF_DATA_16_MASK) >> RXPCU_RXBUF_DATA_16_LSB)
#define RXPCU_RXBUF_DATA_16_SET(x)                                             (((0 | (x)) << RXPCU_RXBUF_DATA_16_LSB) & RXPCU_RXBUF_DATA_16_MASK)
#define RXPCU_RXBUF_DATA_16_RESET                                              0x0
#define RXPCU_RXBUF_16_ADDRESS                                                 (0x1040 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_16_RSTMASK                                                 0xffffffff
#define RXPCU_RXBUF_16_RESET                                                   0x0

// 0x1044 (RXPCU_RXBUF_17)
#define RXPCU_RXBUF_DATA_17_LSB                                                0
#define RXPCU_RXBUF_DATA_17_MSB                                                31
#define RXPCU_RXBUF_DATA_17_MASK                                               0xffffffff
#define RXPCU_RXBUF_DATA_17_GET(x)                                             (((x) & RXPCU_RXBUF_DATA_17_MASK) >> RXPCU_RXBUF_DATA_17_LSB)
#define RXPCU_RXBUF_DATA_17_SET(x)                                             (((0 | (x)) << RXPCU_RXBUF_DATA_17_LSB) & RXPCU_RXBUF_DATA_17_MASK)
#define RXPCU_RXBUF_DATA_17_RESET                                              0x0
#define RXPCU_RXBUF_17_ADDRESS                                                 (0x1044 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_17_RSTMASK                                                 0xffffffff
#define RXPCU_RXBUF_17_RESET                                                   0x0

// 0x1048 (RXPCU_RXBUF_18)
#define RXPCU_RXBUF_DATA_18_LSB                                                0
#define RXPCU_RXBUF_DATA_18_MSB                                                31
#define RXPCU_RXBUF_DATA_18_MASK                                               0xffffffff
#define RXPCU_RXBUF_DATA_18_GET(x)                                             (((x) & RXPCU_RXBUF_DATA_18_MASK) >> RXPCU_RXBUF_DATA_18_LSB)
#define RXPCU_RXBUF_DATA_18_SET(x)                                             (((0 | (x)) << RXPCU_RXBUF_DATA_18_LSB) & RXPCU_RXBUF_DATA_18_MASK)
#define RXPCU_RXBUF_DATA_18_RESET                                              0x0
#define RXPCU_RXBUF_18_ADDRESS                                                 (0x1048 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_18_RSTMASK                                                 0xffffffff
#define RXPCU_RXBUF_18_RESET                                                   0x0

// 0x104c (RXPCU_RXBUF_19)
#define RXPCU_RXBUF_DATA_19_LSB                                                0
#define RXPCU_RXBUF_DATA_19_MSB                                                31
#define RXPCU_RXBUF_DATA_19_MASK                                               0xffffffff
#define RXPCU_RXBUF_DATA_19_GET(x)                                             (((x) & RXPCU_RXBUF_DATA_19_MASK) >> RXPCU_RXBUF_DATA_19_LSB)
#define RXPCU_RXBUF_DATA_19_SET(x)                                             (((0 | (x)) << RXPCU_RXBUF_DATA_19_LSB) & RXPCU_RXBUF_DATA_19_MASK)
#define RXPCU_RXBUF_DATA_19_RESET                                              0x0
#define RXPCU_RXBUF_19_ADDRESS                                                 (0x104c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_19_RSTMASK                                                 0xffffffff
#define RXPCU_RXBUF_19_RESET                                                   0x0

// 0x1050 (RXPCU_RXBUF_20)
#define RXPCU_RXBUF_DATA_20_LSB                                                0
#define RXPCU_RXBUF_DATA_20_MSB                                                31
#define RXPCU_RXBUF_DATA_20_MASK                                               0xffffffff
#define RXPCU_RXBUF_DATA_20_GET(x)                                             (((x) & RXPCU_RXBUF_DATA_20_MASK) >> RXPCU_RXBUF_DATA_20_LSB)
#define RXPCU_RXBUF_DATA_20_SET(x)                                             (((0 | (x)) << RXPCU_RXBUF_DATA_20_LSB) & RXPCU_RXBUF_DATA_20_MASK)
#define RXPCU_RXBUF_DATA_20_RESET                                              0x0
#define RXPCU_RXBUF_20_ADDRESS                                                 (0x1050 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_20_RSTMASK                                                 0xffffffff
#define RXPCU_RXBUF_20_RESET                                                   0x0

// 0x1054 (RXPCU_RXBUF_21)
#define RXPCU_RXBUF_DATA_21_LSB                                                0
#define RXPCU_RXBUF_DATA_21_MSB                                                31
#define RXPCU_RXBUF_DATA_21_MASK                                               0xffffffff
#define RXPCU_RXBUF_DATA_21_GET(x)                                             (((x) & RXPCU_RXBUF_DATA_21_MASK) >> RXPCU_RXBUF_DATA_21_LSB)
#define RXPCU_RXBUF_DATA_21_SET(x)                                             (((0 | (x)) << RXPCU_RXBUF_DATA_21_LSB) & RXPCU_RXBUF_DATA_21_MASK)
#define RXPCU_RXBUF_DATA_21_RESET                                              0x0
#define RXPCU_RXBUF_21_ADDRESS                                                 (0x1054 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_21_RSTMASK                                                 0xffffffff
#define RXPCU_RXBUF_21_RESET                                                   0x0

// 0x1058 (RXPCU_RXBUF_22)
#define RXPCU_RXBUF_DATA_22_LSB                                                0
#define RXPCU_RXBUF_DATA_22_MSB                                                31
#define RXPCU_RXBUF_DATA_22_MASK                                               0xffffffff
#define RXPCU_RXBUF_DATA_22_GET(x)                                             (((x) & RXPCU_RXBUF_DATA_22_MASK) >> RXPCU_RXBUF_DATA_22_LSB)
#define RXPCU_RXBUF_DATA_22_SET(x)                                             (((0 | (x)) << RXPCU_RXBUF_DATA_22_LSB) & RXPCU_RXBUF_DATA_22_MASK)
#define RXPCU_RXBUF_DATA_22_RESET                                              0x0
#define RXPCU_RXBUF_22_ADDRESS                                                 (0x1058 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_22_RSTMASK                                                 0xffffffff
#define RXPCU_RXBUF_22_RESET                                                   0x0

// 0x105c (RXPCU_RXBUF_23)
#define RXPCU_RXBUF_DATA_23_LSB                                                0
#define RXPCU_RXBUF_DATA_23_MSB                                                31
#define RXPCU_RXBUF_DATA_23_MASK                                               0xffffffff
#define RXPCU_RXBUF_DATA_23_GET(x)                                             (((x) & RXPCU_RXBUF_DATA_23_MASK) >> RXPCU_RXBUF_DATA_23_LSB)
#define RXPCU_RXBUF_DATA_23_SET(x)                                             (((0 | (x)) << RXPCU_RXBUF_DATA_23_LSB) & RXPCU_RXBUF_DATA_23_MASK)
#define RXPCU_RXBUF_DATA_23_RESET                                              0x0
#define RXPCU_RXBUF_23_ADDRESS                                                 (0x105c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_23_RSTMASK                                                 0xffffffff
#define RXPCU_RXBUF_23_RESET                                                   0x0

// 0x1060 (RXPCU_RXBUF_24)
#define RXPCU_RXBUF_DATA_24_LSB                                                0
#define RXPCU_RXBUF_DATA_24_MSB                                                31
#define RXPCU_RXBUF_DATA_24_MASK                                               0xffffffff
#define RXPCU_RXBUF_DATA_24_GET(x)                                             (((x) & RXPCU_RXBUF_DATA_24_MASK) >> RXPCU_RXBUF_DATA_24_LSB)
#define RXPCU_RXBUF_DATA_24_SET(x)                                             (((0 | (x)) << RXPCU_RXBUF_DATA_24_LSB) & RXPCU_RXBUF_DATA_24_MASK)
#define RXPCU_RXBUF_DATA_24_RESET                                              0x0
#define RXPCU_RXBUF_24_ADDRESS                                                 (0x1060 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_24_RSTMASK                                                 0xffffffff
#define RXPCU_RXBUF_24_RESET                                                   0x0

// 0x1064 (RXPCU_RXBUF_25)
#define RXPCU_RXBUF_DATA_25_LSB                                                0
#define RXPCU_RXBUF_DATA_25_MSB                                                31
#define RXPCU_RXBUF_DATA_25_MASK                                               0xffffffff
#define RXPCU_RXBUF_DATA_25_GET(x)                                             (((x) & RXPCU_RXBUF_DATA_25_MASK) >> RXPCU_RXBUF_DATA_25_LSB)
#define RXPCU_RXBUF_DATA_25_SET(x)                                             (((0 | (x)) << RXPCU_RXBUF_DATA_25_LSB) & RXPCU_RXBUF_DATA_25_MASK)
#define RXPCU_RXBUF_DATA_25_RESET                                              0x0
#define RXPCU_RXBUF_25_ADDRESS                                                 (0x1064 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_25_RSTMASK                                                 0xffffffff
#define RXPCU_RXBUF_25_RESET                                                   0x0

// 0x1068 (RXPCU_RXBUF_26)
#define RXPCU_RXBUF_DATA_26_LSB                                                0
#define RXPCU_RXBUF_DATA_26_MSB                                                31
#define RXPCU_RXBUF_DATA_26_MASK                                               0xffffffff
#define RXPCU_RXBUF_DATA_26_GET(x)                                             (((x) & RXPCU_RXBUF_DATA_26_MASK) >> RXPCU_RXBUF_DATA_26_LSB)
#define RXPCU_RXBUF_DATA_26_SET(x)                                             (((0 | (x)) << RXPCU_RXBUF_DATA_26_LSB) & RXPCU_RXBUF_DATA_26_MASK)
#define RXPCU_RXBUF_DATA_26_RESET                                              0x0
#define RXPCU_RXBUF_26_ADDRESS                                                 (0x1068 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_26_RSTMASK                                                 0xffffffff
#define RXPCU_RXBUF_26_RESET                                                   0x0

// 0x106c (RXPCU_RXBUF_27)
#define RXPCU_RXBUF_DATA_27_LSB                                                0
#define RXPCU_RXBUF_DATA_27_MSB                                                31
#define RXPCU_RXBUF_DATA_27_MASK                                               0xffffffff
#define RXPCU_RXBUF_DATA_27_GET(x)                                             (((x) & RXPCU_RXBUF_DATA_27_MASK) >> RXPCU_RXBUF_DATA_27_LSB)
#define RXPCU_RXBUF_DATA_27_SET(x)                                             (((0 | (x)) << RXPCU_RXBUF_DATA_27_LSB) & RXPCU_RXBUF_DATA_27_MASK)
#define RXPCU_RXBUF_DATA_27_RESET                                              0x0
#define RXPCU_RXBUF_27_ADDRESS                                                 (0x106c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_27_RSTMASK                                                 0xffffffff
#define RXPCU_RXBUF_27_RESET                                                   0x0

// 0x1070 (RXPCU_RXBUF_28)
#define RXPCU_RXBUF_DATA_28_LSB                                                0
#define RXPCU_RXBUF_DATA_28_MSB                                                31
#define RXPCU_RXBUF_DATA_28_MASK                                               0xffffffff
#define RXPCU_RXBUF_DATA_28_GET(x)                                             (((x) & RXPCU_RXBUF_DATA_28_MASK) >> RXPCU_RXBUF_DATA_28_LSB)
#define RXPCU_RXBUF_DATA_28_SET(x)                                             (((0 | (x)) << RXPCU_RXBUF_DATA_28_LSB) & RXPCU_RXBUF_DATA_28_MASK)
#define RXPCU_RXBUF_DATA_28_RESET                                              0x0
#define RXPCU_RXBUF_28_ADDRESS                                                 (0x1070 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_28_RSTMASK                                                 0xffffffff
#define RXPCU_RXBUF_28_RESET                                                   0x0

// 0x1074 (RXPCU_RXBUF_29)
#define RXPCU_RXBUF_DATA_29_LSB                                                0
#define RXPCU_RXBUF_DATA_29_MSB                                                31
#define RXPCU_RXBUF_DATA_29_MASK                                               0xffffffff
#define RXPCU_RXBUF_DATA_29_GET(x)                                             (((x) & RXPCU_RXBUF_DATA_29_MASK) >> RXPCU_RXBUF_DATA_29_LSB)
#define RXPCU_RXBUF_DATA_29_SET(x)                                             (((0 | (x)) << RXPCU_RXBUF_DATA_29_LSB) & RXPCU_RXBUF_DATA_29_MASK)
#define RXPCU_RXBUF_DATA_29_RESET                                              0x0
#define RXPCU_RXBUF_29_ADDRESS                                                 (0x1074 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_29_RSTMASK                                                 0xffffffff
#define RXPCU_RXBUF_29_RESET                                                   0x0

// 0x1078 (RXPCU_RXBUF_30)
#define RXPCU_RXBUF_DATA_30_LSB                                                0
#define RXPCU_RXBUF_DATA_30_MSB                                                31
#define RXPCU_RXBUF_DATA_30_MASK                                               0xffffffff
#define RXPCU_RXBUF_DATA_30_GET(x)                                             (((x) & RXPCU_RXBUF_DATA_30_MASK) >> RXPCU_RXBUF_DATA_30_LSB)
#define RXPCU_RXBUF_DATA_30_SET(x)                                             (((0 | (x)) << RXPCU_RXBUF_DATA_30_LSB) & RXPCU_RXBUF_DATA_30_MASK)
#define RXPCU_RXBUF_DATA_30_RESET                                              0x0
#define RXPCU_RXBUF_30_ADDRESS                                                 (0x1078 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_30_RSTMASK                                                 0xffffffff
#define RXPCU_RXBUF_30_RESET                                                   0x0

// 0x107c (RXPCU_RXBUF_31)
#define RXPCU_RXBUF_DATA_31_LSB                                                0
#define RXPCU_RXBUF_DATA_31_MSB                                                31
#define RXPCU_RXBUF_DATA_31_MASK                                               0xffffffff
#define RXPCU_RXBUF_DATA_31_GET(x)                                             (((x) & RXPCU_RXBUF_DATA_31_MASK) >> RXPCU_RXBUF_DATA_31_LSB)
#define RXPCU_RXBUF_DATA_31_SET(x)                                             (((0 | (x)) << RXPCU_RXBUF_DATA_31_LSB) & RXPCU_RXBUF_DATA_31_MASK)
#define RXPCU_RXBUF_DATA_31_RESET                                              0x0
#define RXPCU_RXBUF_31_ADDRESS                                                 (0x107c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_31_RSTMASK                                                 0xffffffff
#define RXPCU_RXBUF_31_RESET                                                   0x0

// 0x1080 (RXPCU_RXBUF_32)
#define RXPCU_RXBUF_DATA_32_LSB                                                0
#define RXPCU_RXBUF_DATA_32_MSB                                                31
#define RXPCU_RXBUF_DATA_32_MASK                                               0xffffffff
#define RXPCU_RXBUF_DATA_32_GET(x)                                             (((x) & RXPCU_RXBUF_DATA_32_MASK) >> RXPCU_RXBUF_DATA_32_LSB)
#define RXPCU_RXBUF_DATA_32_SET(x)                                             (((0 | (x)) << RXPCU_RXBUF_DATA_32_LSB) & RXPCU_RXBUF_DATA_32_MASK)
#define RXPCU_RXBUF_DATA_32_RESET                                              0x0
#define RXPCU_RXBUF_32_ADDRESS                                                 (0x1080 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_32_RSTMASK                                                 0xffffffff
#define RXPCU_RXBUF_32_RESET                                                   0x0

// 0x1084 (RXPCU_RXBUF_33)
#define RXPCU_RXBUF_DATA_33_LSB                                                0
#define RXPCU_RXBUF_DATA_33_MSB                                                31
#define RXPCU_RXBUF_DATA_33_MASK                                               0xffffffff
#define RXPCU_RXBUF_DATA_33_GET(x)                                             (((x) & RXPCU_RXBUF_DATA_33_MASK) >> RXPCU_RXBUF_DATA_33_LSB)
#define RXPCU_RXBUF_DATA_33_SET(x)                                             (((0 | (x)) << RXPCU_RXBUF_DATA_33_LSB) & RXPCU_RXBUF_DATA_33_MASK)
#define RXPCU_RXBUF_DATA_33_RESET                                              0x0
#define RXPCU_RXBUF_33_ADDRESS                                                 (0x1084 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_33_RSTMASK                                                 0xffffffff
#define RXPCU_RXBUF_33_RESET                                                   0x0

// 0x1088 (RXPCU_RXBUF_34)
#define RXPCU_RXBUF_DATA_34_LSB                                                0
#define RXPCU_RXBUF_DATA_34_MSB                                                31
#define RXPCU_RXBUF_DATA_34_MASK                                               0xffffffff
#define RXPCU_RXBUF_DATA_34_GET(x)                                             (((x) & RXPCU_RXBUF_DATA_34_MASK) >> RXPCU_RXBUF_DATA_34_LSB)
#define RXPCU_RXBUF_DATA_34_SET(x)                                             (((0 | (x)) << RXPCU_RXBUF_DATA_34_LSB) & RXPCU_RXBUF_DATA_34_MASK)
#define RXPCU_RXBUF_DATA_34_RESET                                              0x0
#define RXPCU_RXBUF_34_ADDRESS                                                 (0x1088 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_34_RSTMASK                                                 0xffffffff
#define RXPCU_RXBUF_34_RESET                                                   0x0

// 0x108c (RXPCU_RXBUF_35)
#define RXPCU_RXBUF_DATA_35_LSB                                                0
#define RXPCU_RXBUF_DATA_35_MSB                                                31
#define RXPCU_RXBUF_DATA_35_MASK                                               0xffffffff
#define RXPCU_RXBUF_DATA_35_GET(x)                                             (((x) & RXPCU_RXBUF_DATA_35_MASK) >> RXPCU_RXBUF_DATA_35_LSB)
#define RXPCU_RXBUF_DATA_35_SET(x)                                             (((0 | (x)) << RXPCU_RXBUF_DATA_35_LSB) & RXPCU_RXBUF_DATA_35_MASK)
#define RXPCU_RXBUF_DATA_35_RESET                                              0x0
#define RXPCU_RXBUF_35_ADDRESS                                                 (0x108c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_35_RSTMASK                                                 0xffffffff
#define RXPCU_RXBUF_35_RESET                                                   0x0

// 0x1090 (RXPCU_RXBUF_36)
#define RXPCU_RXBUF_DATA_36_LSB                                                0
#define RXPCU_RXBUF_DATA_36_MSB                                                31
#define RXPCU_RXBUF_DATA_36_MASK                                               0xffffffff
#define RXPCU_RXBUF_DATA_36_GET(x)                                             (((x) & RXPCU_RXBUF_DATA_36_MASK) >> RXPCU_RXBUF_DATA_36_LSB)
#define RXPCU_RXBUF_DATA_36_SET(x)                                             (((0 | (x)) << RXPCU_RXBUF_DATA_36_LSB) & RXPCU_RXBUF_DATA_36_MASK)
#define RXPCU_RXBUF_DATA_36_RESET                                              0x0
#define RXPCU_RXBUF_36_ADDRESS                                                 (0x1090 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_36_RSTMASK                                                 0xffffffff
#define RXPCU_RXBUF_36_RESET                                                   0x0

// 0x1094 (RXPCU_RXBUF_37)
#define RXPCU_RXBUF_DATA_37_LSB                                                0
#define RXPCU_RXBUF_DATA_37_MSB                                                31
#define RXPCU_RXBUF_DATA_37_MASK                                               0xffffffff
#define RXPCU_RXBUF_DATA_37_GET(x)                                             (((x) & RXPCU_RXBUF_DATA_37_MASK) >> RXPCU_RXBUF_DATA_37_LSB)
#define RXPCU_RXBUF_DATA_37_SET(x)                                             (((0 | (x)) << RXPCU_RXBUF_DATA_37_LSB) & RXPCU_RXBUF_DATA_37_MASK)
#define RXPCU_RXBUF_DATA_37_RESET                                              0x0
#define RXPCU_RXBUF_37_ADDRESS                                                 (0x1094 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_37_RSTMASK                                                 0xffffffff
#define RXPCU_RXBUF_37_RESET                                                   0x0

// 0x1098 (RXPCU_RXBUF_38)
#define RXPCU_RXBUF_DATA_38_LSB                                                0
#define RXPCU_RXBUF_DATA_38_MSB                                                31
#define RXPCU_RXBUF_DATA_38_MASK                                               0xffffffff
#define RXPCU_RXBUF_DATA_38_GET(x)                                             (((x) & RXPCU_RXBUF_DATA_38_MASK) >> RXPCU_RXBUF_DATA_38_LSB)
#define RXPCU_RXBUF_DATA_38_SET(x)                                             (((0 | (x)) << RXPCU_RXBUF_DATA_38_LSB) & RXPCU_RXBUF_DATA_38_MASK)
#define RXPCU_RXBUF_DATA_38_RESET                                              0x0
#define RXPCU_RXBUF_38_ADDRESS                                                 (0x1098 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_38_RSTMASK                                                 0xffffffff
#define RXPCU_RXBUF_38_RESET                                                   0x0

// 0x109c (RXPCU_RXBUF_39)
#define RXPCU_RXBUF_DATA_39_LSB                                                0
#define RXPCU_RXBUF_DATA_39_MSB                                                31
#define RXPCU_RXBUF_DATA_39_MASK                                               0xffffffff
#define RXPCU_RXBUF_DATA_39_GET(x)                                             (((x) & RXPCU_RXBUF_DATA_39_MASK) >> RXPCU_RXBUF_DATA_39_LSB)
#define RXPCU_RXBUF_DATA_39_SET(x)                                             (((0 | (x)) << RXPCU_RXBUF_DATA_39_LSB) & RXPCU_RXBUF_DATA_39_MASK)
#define RXPCU_RXBUF_DATA_39_RESET                                              0x0
#define RXPCU_RXBUF_39_ADDRESS                                                 (0x109c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_39_RSTMASK                                                 0xffffffff
#define RXPCU_RXBUF_39_RESET                                                   0x0

// 0x10a0 (RXPCU_RXBUF_40)
#define RXPCU_RXBUF_DATA_40_LSB                                                0
#define RXPCU_RXBUF_DATA_40_MSB                                                31
#define RXPCU_RXBUF_DATA_40_MASK                                               0xffffffff
#define RXPCU_RXBUF_DATA_40_GET(x)                                             (((x) & RXPCU_RXBUF_DATA_40_MASK) >> RXPCU_RXBUF_DATA_40_LSB)
#define RXPCU_RXBUF_DATA_40_SET(x)                                             (((0 | (x)) << RXPCU_RXBUF_DATA_40_LSB) & RXPCU_RXBUF_DATA_40_MASK)
#define RXPCU_RXBUF_DATA_40_RESET                                              0x0
#define RXPCU_RXBUF_40_ADDRESS                                                 (0x10a0 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_40_RSTMASK                                                 0xffffffff
#define RXPCU_RXBUF_40_RESET                                                   0x0

// 0x10a4 (RXPCU_RXBUF_41)
#define RXPCU_RXBUF_DATA_41_LSB                                                0
#define RXPCU_RXBUF_DATA_41_MSB                                                31
#define RXPCU_RXBUF_DATA_41_MASK                                               0xffffffff
#define RXPCU_RXBUF_DATA_41_GET(x)                                             (((x) & RXPCU_RXBUF_DATA_41_MASK) >> RXPCU_RXBUF_DATA_41_LSB)
#define RXPCU_RXBUF_DATA_41_SET(x)                                             (((0 | (x)) << RXPCU_RXBUF_DATA_41_LSB) & RXPCU_RXBUF_DATA_41_MASK)
#define RXPCU_RXBUF_DATA_41_RESET                                              0x0
#define RXPCU_RXBUF_41_ADDRESS                                                 (0x10a4 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_41_RSTMASK                                                 0xffffffff
#define RXPCU_RXBUF_41_RESET                                                   0x0

// 0x10a8 (RXPCU_RXBUF_42)
#define RXPCU_RXBUF_DATA_42_LSB                                                0
#define RXPCU_RXBUF_DATA_42_MSB                                                31
#define RXPCU_RXBUF_DATA_42_MASK                                               0xffffffff
#define RXPCU_RXBUF_DATA_42_GET(x)                                             (((x) & RXPCU_RXBUF_DATA_42_MASK) >> RXPCU_RXBUF_DATA_42_LSB)
#define RXPCU_RXBUF_DATA_42_SET(x)                                             (((0 | (x)) << RXPCU_RXBUF_DATA_42_LSB) & RXPCU_RXBUF_DATA_42_MASK)
#define RXPCU_RXBUF_DATA_42_RESET                                              0x0
#define RXPCU_RXBUF_42_ADDRESS                                                 (0x10a8 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_42_RSTMASK                                                 0xffffffff
#define RXPCU_RXBUF_42_RESET                                                   0x0

// 0x10ac (RXPCU_RXBUF_43)
#define RXPCU_RXBUF_DATA_43_LSB                                                0
#define RXPCU_RXBUF_DATA_43_MSB                                                31
#define RXPCU_RXBUF_DATA_43_MASK                                               0xffffffff
#define RXPCU_RXBUF_DATA_43_GET(x)                                             (((x) & RXPCU_RXBUF_DATA_43_MASK) >> RXPCU_RXBUF_DATA_43_LSB)
#define RXPCU_RXBUF_DATA_43_SET(x)                                             (((0 | (x)) << RXPCU_RXBUF_DATA_43_LSB) & RXPCU_RXBUF_DATA_43_MASK)
#define RXPCU_RXBUF_DATA_43_RESET                                              0x0
#define RXPCU_RXBUF_43_ADDRESS                                                 (0x10ac + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_43_RSTMASK                                                 0xffffffff
#define RXPCU_RXBUF_43_RESET                                                   0x0

// 0x10b0 (RXPCU_RXBUF_44)
#define RXPCU_RXBUF_DATA_44_LSB                                                0
#define RXPCU_RXBUF_DATA_44_MSB                                                31
#define RXPCU_RXBUF_DATA_44_MASK                                               0xffffffff
#define RXPCU_RXBUF_DATA_44_GET(x)                                             (((x) & RXPCU_RXBUF_DATA_44_MASK) >> RXPCU_RXBUF_DATA_44_LSB)
#define RXPCU_RXBUF_DATA_44_SET(x)                                             (((0 | (x)) << RXPCU_RXBUF_DATA_44_LSB) & RXPCU_RXBUF_DATA_44_MASK)
#define RXPCU_RXBUF_DATA_44_RESET                                              0x0
#define RXPCU_RXBUF_44_ADDRESS                                                 (0x10b0 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_44_RSTMASK                                                 0xffffffff
#define RXPCU_RXBUF_44_RESET                                                   0x0

// 0x10b4 (RXPCU_RXBUF_45)
#define RXPCU_RXBUF_DATA_45_LSB                                                0
#define RXPCU_RXBUF_DATA_45_MSB                                                31
#define RXPCU_RXBUF_DATA_45_MASK                                               0xffffffff
#define RXPCU_RXBUF_DATA_45_GET(x)                                             (((x) & RXPCU_RXBUF_DATA_45_MASK) >> RXPCU_RXBUF_DATA_45_LSB)
#define RXPCU_RXBUF_DATA_45_SET(x)                                             (((0 | (x)) << RXPCU_RXBUF_DATA_45_LSB) & RXPCU_RXBUF_DATA_45_MASK)
#define RXPCU_RXBUF_DATA_45_RESET                                              0x0
#define RXPCU_RXBUF_45_ADDRESS                                                 (0x10b4 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_45_RSTMASK                                                 0xffffffff
#define RXPCU_RXBUF_45_RESET                                                   0x0

// 0x10b8 (RXPCU_RXBUF_46)
#define RXPCU_RXBUF_DATA_46_LSB                                                0
#define RXPCU_RXBUF_DATA_46_MSB                                                31
#define RXPCU_RXBUF_DATA_46_MASK                                               0xffffffff
#define RXPCU_RXBUF_DATA_46_GET(x)                                             (((x) & RXPCU_RXBUF_DATA_46_MASK) >> RXPCU_RXBUF_DATA_46_LSB)
#define RXPCU_RXBUF_DATA_46_SET(x)                                             (((0 | (x)) << RXPCU_RXBUF_DATA_46_LSB) & RXPCU_RXBUF_DATA_46_MASK)
#define RXPCU_RXBUF_DATA_46_RESET                                              0x0
#define RXPCU_RXBUF_46_ADDRESS                                                 (0x10b8 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_46_RSTMASK                                                 0xffffffff
#define RXPCU_RXBUF_46_RESET                                                   0x0

// 0x10bc (RXPCU_RXBUF_47)
#define RXPCU_RXBUF_DATA_47_LSB                                                0
#define RXPCU_RXBUF_DATA_47_MSB                                                31
#define RXPCU_RXBUF_DATA_47_MASK                                               0xffffffff
#define RXPCU_RXBUF_DATA_47_GET(x)                                             (((x) & RXPCU_RXBUF_DATA_47_MASK) >> RXPCU_RXBUF_DATA_47_LSB)
#define RXPCU_RXBUF_DATA_47_SET(x)                                             (((0 | (x)) << RXPCU_RXBUF_DATA_47_LSB) & RXPCU_RXBUF_DATA_47_MASK)
#define RXPCU_RXBUF_DATA_47_RESET                                              0x0
#define RXPCU_RXBUF_47_ADDRESS                                                 (0x10bc + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_47_RSTMASK                                                 0xffffffff
#define RXPCU_RXBUF_47_RESET                                                   0x0

// 0x10c0 (RXPCU_RXBUF_48)
#define RXPCU_RXBUF_DATA_48_LSB                                                0
#define RXPCU_RXBUF_DATA_48_MSB                                                31
#define RXPCU_RXBUF_DATA_48_MASK                                               0xffffffff
#define RXPCU_RXBUF_DATA_48_GET(x)                                             (((x) & RXPCU_RXBUF_DATA_48_MASK) >> RXPCU_RXBUF_DATA_48_LSB)
#define RXPCU_RXBUF_DATA_48_SET(x)                                             (((0 | (x)) << RXPCU_RXBUF_DATA_48_LSB) & RXPCU_RXBUF_DATA_48_MASK)
#define RXPCU_RXBUF_DATA_48_RESET                                              0x0
#define RXPCU_RXBUF_48_ADDRESS                                                 (0x10c0 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_48_RSTMASK                                                 0xffffffff
#define RXPCU_RXBUF_48_RESET                                                   0x0

// 0x10c4 (RXPCU_RXBUF_49)
#define RXPCU_RXBUF_DATA_49_LSB                                                0
#define RXPCU_RXBUF_DATA_49_MSB                                                31
#define RXPCU_RXBUF_DATA_49_MASK                                               0xffffffff
#define RXPCU_RXBUF_DATA_49_GET(x)                                             (((x) & RXPCU_RXBUF_DATA_49_MASK) >> RXPCU_RXBUF_DATA_49_LSB)
#define RXPCU_RXBUF_DATA_49_SET(x)                                             (((0 | (x)) << RXPCU_RXBUF_DATA_49_LSB) & RXPCU_RXBUF_DATA_49_MASK)
#define RXPCU_RXBUF_DATA_49_RESET                                              0x0
#define RXPCU_RXBUF_49_ADDRESS                                                 (0x10c4 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_49_RSTMASK                                                 0xffffffff
#define RXPCU_RXBUF_49_RESET                                                   0x0

// 0x10c8 (RXPCU_RXBUF_50)
#define RXPCU_RXBUF_DATA_50_LSB                                                0
#define RXPCU_RXBUF_DATA_50_MSB                                                31
#define RXPCU_RXBUF_DATA_50_MASK                                               0xffffffff
#define RXPCU_RXBUF_DATA_50_GET(x)                                             (((x) & RXPCU_RXBUF_DATA_50_MASK) >> RXPCU_RXBUF_DATA_50_LSB)
#define RXPCU_RXBUF_DATA_50_SET(x)                                             (((0 | (x)) << RXPCU_RXBUF_DATA_50_LSB) & RXPCU_RXBUF_DATA_50_MASK)
#define RXPCU_RXBUF_DATA_50_RESET                                              0x0
#define RXPCU_RXBUF_50_ADDRESS                                                 (0x10c8 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_50_RSTMASK                                                 0xffffffff
#define RXPCU_RXBUF_50_RESET                                                   0x0

// 0x10cc (RXPCU_RXBUF_51)
#define RXPCU_RXBUF_DATA_51_LSB                                                0
#define RXPCU_RXBUF_DATA_51_MSB                                                31
#define RXPCU_RXBUF_DATA_51_MASK                                               0xffffffff
#define RXPCU_RXBUF_DATA_51_GET(x)                                             (((x) & RXPCU_RXBUF_DATA_51_MASK) >> RXPCU_RXBUF_DATA_51_LSB)
#define RXPCU_RXBUF_DATA_51_SET(x)                                             (((0 | (x)) << RXPCU_RXBUF_DATA_51_LSB) & RXPCU_RXBUF_DATA_51_MASK)
#define RXPCU_RXBUF_DATA_51_RESET                                              0x0
#define RXPCU_RXBUF_51_ADDRESS                                                 (0x10cc + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_51_RSTMASK                                                 0xffffffff
#define RXPCU_RXBUF_51_RESET                                                   0x0

// 0x10d0 (RXPCU_RXBUF_52)
#define RXPCU_RXBUF_DATA_52_LSB                                                0
#define RXPCU_RXBUF_DATA_52_MSB                                                31
#define RXPCU_RXBUF_DATA_52_MASK                                               0xffffffff
#define RXPCU_RXBUF_DATA_52_GET(x)                                             (((x) & RXPCU_RXBUF_DATA_52_MASK) >> RXPCU_RXBUF_DATA_52_LSB)
#define RXPCU_RXBUF_DATA_52_SET(x)                                             (((0 | (x)) << RXPCU_RXBUF_DATA_52_LSB) & RXPCU_RXBUF_DATA_52_MASK)
#define RXPCU_RXBUF_DATA_52_RESET                                              0x0
#define RXPCU_RXBUF_52_ADDRESS                                                 (0x10d0 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_52_RSTMASK                                                 0xffffffff
#define RXPCU_RXBUF_52_RESET                                                   0x0

// 0x10d4 (RXPCU_RXBUF_53)
#define RXPCU_RXBUF_DATA_53_LSB                                                0
#define RXPCU_RXBUF_DATA_53_MSB                                                31
#define RXPCU_RXBUF_DATA_53_MASK                                               0xffffffff
#define RXPCU_RXBUF_DATA_53_GET(x)                                             (((x) & RXPCU_RXBUF_DATA_53_MASK) >> RXPCU_RXBUF_DATA_53_LSB)
#define RXPCU_RXBUF_DATA_53_SET(x)                                             (((0 | (x)) << RXPCU_RXBUF_DATA_53_LSB) & RXPCU_RXBUF_DATA_53_MASK)
#define RXPCU_RXBUF_DATA_53_RESET                                              0x0
#define RXPCU_RXBUF_53_ADDRESS                                                 (0x10d4 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_53_RSTMASK                                                 0xffffffff
#define RXPCU_RXBUF_53_RESET                                                   0x0

// 0x10d8 (RXPCU_RXBUF_54)
#define RXPCU_RXBUF_DATA_54_LSB                                                0
#define RXPCU_RXBUF_DATA_54_MSB                                                31
#define RXPCU_RXBUF_DATA_54_MASK                                               0xffffffff
#define RXPCU_RXBUF_DATA_54_GET(x)                                             (((x) & RXPCU_RXBUF_DATA_54_MASK) >> RXPCU_RXBUF_DATA_54_LSB)
#define RXPCU_RXBUF_DATA_54_SET(x)                                             (((0 | (x)) << RXPCU_RXBUF_DATA_54_LSB) & RXPCU_RXBUF_DATA_54_MASK)
#define RXPCU_RXBUF_DATA_54_RESET                                              0x0
#define RXPCU_RXBUF_54_ADDRESS                                                 (0x10d8 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_54_RSTMASK                                                 0xffffffff
#define RXPCU_RXBUF_54_RESET                                                   0x0

// 0x10dc (RXPCU_RXBUF_55)
#define RXPCU_RXBUF_DATA_55_LSB                                                0
#define RXPCU_RXBUF_DATA_55_MSB                                                31
#define RXPCU_RXBUF_DATA_55_MASK                                               0xffffffff
#define RXPCU_RXBUF_DATA_55_GET(x)                                             (((x) & RXPCU_RXBUF_DATA_55_MASK) >> RXPCU_RXBUF_DATA_55_LSB)
#define RXPCU_RXBUF_DATA_55_SET(x)                                             (((0 | (x)) << RXPCU_RXBUF_DATA_55_LSB) & RXPCU_RXBUF_DATA_55_MASK)
#define RXPCU_RXBUF_DATA_55_RESET                                              0x0
#define RXPCU_RXBUF_55_ADDRESS                                                 (0x10dc + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_55_RSTMASK                                                 0xffffffff
#define RXPCU_RXBUF_55_RESET                                                   0x0

// 0x10e0 (RXPCU_RXBUF_56)
#define RXPCU_RXBUF_DATA_56_LSB                                                0
#define RXPCU_RXBUF_DATA_56_MSB                                                31
#define RXPCU_RXBUF_DATA_56_MASK                                               0xffffffff
#define RXPCU_RXBUF_DATA_56_GET(x)                                             (((x) & RXPCU_RXBUF_DATA_56_MASK) >> RXPCU_RXBUF_DATA_56_LSB)
#define RXPCU_RXBUF_DATA_56_SET(x)                                             (((0 | (x)) << RXPCU_RXBUF_DATA_56_LSB) & RXPCU_RXBUF_DATA_56_MASK)
#define RXPCU_RXBUF_DATA_56_RESET                                              0x0
#define RXPCU_RXBUF_56_ADDRESS                                                 (0x10e0 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_56_RSTMASK                                                 0xffffffff
#define RXPCU_RXBUF_56_RESET                                                   0x0

// 0x10e4 (RXPCU_RXBUF_57)
#define RXPCU_RXBUF_DATA_57_LSB                                                0
#define RXPCU_RXBUF_DATA_57_MSB                                                31
#define RXPCU_RXBUF_DATA_57_MASK                                               0xffffffff
#define RXPCU_RXBUF_DATA_57_GET(x)                                             (((x) & RXPCU_RXBUF_DATA_57_MASK) >> RXPCU_RXBUF_DATA_57_LSB)
#define RXPCU_RXBUF_DATA_57_SET(x)                                             (((0 | (x)) << RXPCU_RXBUF_DATA_57_LSB) & RXPCU_RXBUF_DATA_57_MASK)
#define RXPCU_RXBUF_DATA_57_RESET                                              0x0
#define RXPCU_RXBUF_57_ADDRESS                                                 (0x10e4 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_57_RSTMASK                                                 0xffffffff
#define RXPCU_RXBUF_57_RESET                                                   0x0

// 0x10e8 (RXPCU_RXBUF_58)
#define RXPCU_RXBUF_DATA_58_LSB                                                0
#define RXPCU_RXBUF_DATA_58_MSB                                                31
#define RXPCU_RXBUF_DATA_58_MASK                                               0xffffffff
#define RXPCU_RXBUF_DATA_58_GET(x)                                             (((x) & RXPCU_RXBUF_DATA_58_MASK) >> RXPCU_RXBUF_DATA_58_LSB)
#define RXPCU_RXBUF_DATA_58_SET(x)                                             (((0 | (x)) << RXPCU_RXBUF_DATA_58_LSB) & RXPCU_RXBUF_DATA_58_MASK)
#define RXPCU_RXBUF_DATA_58_RESET                                              0x0
#define RXPCU_RXBUF_58_ADDRESS                                                 (0x10e8 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_58_RSTMASK                                                 0xffffffff
#define RXPCU_RXBUF_58_RESET                                                   0x0

// 0x10ec (RXPCU_RXBUF_59)
#define RXPCU_RXBUF_DATA_59_LSB                                                0
#define RXPCU_RXBUF_DATA_59_MSB                                                31
#define RXPCU_RXBUF_DATA_59_MASK                                               0xffffffff
#define RXPCU_RXBUF_DATA_59_GET(x)                                             (((x) & RXPCU_RXBUF_DATA_59_MASK) >> RXPCU_RXBUF_DATA_59_LSB)
#define RXPCU_RXBUF_DATA_59_SET(x)                                             (((0 | (x)) << RXPCU_RXBUF_DATA_59_LSB) & RXPCU_RXBUF_DATA_59_MASK)
#define RXPCU_RXBUF_DATA_59_RESET                                              0x0
#define RXPCU_RXBUF_59_ADDRESS                                                 (0x10ec + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_59_RSTMASK                                                 0xffffffff
#define RXPCU_RXBUF_59_RESET                                                   0x0

// 0x10f0 (RXPCU_RXBUF_60)
#define RXPCU_RXBUF_DATA_60_LSB                                                0
#define RXPCU_RXBUF_DATA_60_MSB                                                31
#define RXPCU_RXBUF_DATA_60_MASK                                               0xffffffff
#define RXPCU_RXBUF_DATA_60_GET(x)                                             (((x) & RXPCU_RXBUF_DATA_60_MASK) >> RXPCU_RXBUF_DATA_60_LSB)
#define RXPCU_RXBUF_DATA_60_SET(x)                                             (((0 | (x)) << RXPCU_RXBUF_DATA_60_LSB) & RXPCU_RXBUF_DATA_60_MASK)
#define RXPCU_RXBUF_DATA_60_RESET                                              0x0
#define RXPCU_RXBUF_60_ADDRESS                                                 (0x10f0 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_60_RSTMASK                                                 0xffffffff
#define RXPCU_RXBUF_60_RESET                                                   0x0

// 0x10f4 (RXPCU_RXBUF_61)
#define RXPCU_RXBUF_DATA_61_LSB                                                0
#define RXPCU_RXBUF_DATA_61_MSB                                                31
#define RXPCU_RXBUF_DATA_61_MASK                                               0xffffffff
#define RXPCU_RXBUF_DATA_61_GET(x)                                             (((x) & RXPCU_RXBUF_DATA_61_MASK) >> RXPCU_RXBUF_DATA_61_LSB)
#define RXPCU_RXBUF_DATA_61_SET(x)                                             (((0 | (x)) << RXPCU_RXBUF_DATA_61_LSB) & RXPCU_RXBUF_DATA_61_MASK)
#define RXPCU_RXBUF_DATA_61_RESET                                              0x0
#define RXPCU_RXBUF_61_ADDRESS                                                 (0x10f4 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_61_RSTMASK                                                 0xffffffff
#define RXPCU_RXBUF_61_RESET                                                   0x0

// 0x10f8 (RXPCU_RXBUF_62)
#define RXPCU_RXBUF_DATA_62_LSB                                                0
#define RXPCU_RXBUF_DATA_62_MSB                                                31
#define RXPCU_RXBUF_DATA_62_MASK                                               0xffffffff
#define RXPCU_RXBUF_DATA_62_GET(x)                                             (((x) & RXPCU_RXBUF_DATA_62_MASK) >> RXPCU_RXBUF_DATA_62_LSB)
#define RXPCU_RXBUF_DATA_62_SET(x)                                             (((0 | (x)) << RXPCU_RXBUF_DATA_62_LSB) & RXPCU_RXBUF_DATA_62_MASK)
#define RXPCU_RXBUF_DATA_62_RESET                                              0x0
#define RXPCU_RXBUF_62_ADDRESS                                                 (0x10f8 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_62_RSTMASK                                                 0xffffffff
#define RXPCU_RXBUF_62_RESET                                                   0x0

// 0x10fc (RXPCU_RXBUF_63)
#define RXPCU_RXBUF_DATA_63_LSB                                                0
#define RXPCU_RXBUF_DATA_63_MSB                                                31
#define RXPCU_RXBUF_DATA_63_MASK                                               0xffffffff
#define RXPCU_RXBUF_DATA_63_GET(x)                                             (((x) & RXPCU_RXBUF_DATA_63_MASK) >> RXPCU_RXBUF_DATA_63_LSB)
#define RXPCU_RXBUF_DATA_63_SET(x)                                             (((0 | (x)) << RXPCU_RXBUF_DATA_63_LSB) & RXPCU_RXBUF_DATA_63_MASK)
#define RXPCU_RXBUF_DATA_63_RESET                                              0x0
#define RXPCU_RXBUF_63_ADDRESS                                                 (0x10fc + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_63_RSTMASK                                                 0xffffffff
#define RXPCU_RXBUF_63_RESET                                                   0x0

// 0x1100 (RXPCU_RXBUF_64)
#define RXPCU_RXBUF_DATA_64_LSB                                                0
#define RXPCU_RXBUF_DATA_64_MSB                                                31
#define RXPCU_RXBUF_DATA_64_MASK                                               0xffffffff
#define RXPCU_RXBUF_DATA_64_GET(x)                                             (((x) & RXPCU_RXBUF_DATA_64_MASK) >> RXPCU_RXBUF_DATA_64_LSB)
#define RXPCU_RXBUF_DATA_64_SET(x)                                             (((0 | (x)) << RXPCU_RXBUF_DATA_64_LSB) & RXPCU_RXBUF_DATA_64_MASK)
#define RXPCU_RXBUF_DATA_64_RESET                                              0x0
#define RXPCU_RXBUF_64_ADDRESS                                                 (0x1100 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_64_RSTMASK                                                 0xffffffff
#define RXPCU_RXBUF_64_RESET                                                   0x0

// 0x1104 (RXPCU_RXBUF_65)
#define RXPCU_RXBUF_DATA_65_LSB                                                0
#define RXPCU_RXBUF_DATA_65_MSB                                                31
#define RXPCU_RXBUF_DATA_65_MASK                                               0xffffffff
#define RXPCU_RXBUF_DATA_65_GET(x)                                             (((x) & RXPCU_RXBUF_DATA_65_MASK) >> RXPCU_RXBUF_DATA_65_LSB)
#define RXPCU_RXBUF_DATA_65_SET(x)                                             (((0 | (x)) << RXPCU_RXBUF_DATA_65_LSB) & RXPCU_RXBUF_DATA_65_MASK)
#define RXPCU_RXBUF_DATA_65_RESET                                              0x0
#define RXPCU_RXBUF_65_ADDRESS                                                 (0x1104 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_65_RSTMASK                                                 0xffffffff
#define RXPCU_RXBUF_65_RESET                                                   0x0

// 0x1108 (RXPCU_RXBUF_66)
#define RXPCU_RXBUF_DATA_66_LSB                                                0
#define RXPCU_RXBUF_DATA_66_MSB                                                31
#define RXPCU_RXBUF_DATA_66_MASK                                               0xffffffff
#define RXPCU_RXBUF_DATA_66_GET(x)                                             (((x) & RXPCU_RXBUF_DATA_66_MASK) >> RXPCU_RXBUF_DATA_66_LSB)
#define RXPCU_RXBUF_DATA_66_SET(x)                                             (((0 | (x)) << RXPCU_RXBUF_DATA_66_LSB) & RXPCU_RXBUF_DATA_66_MASK)
#define RXPCU_RXBUF_DATA_66_RESET                                              0x0
#define RXPCU_RXBUF_66_ADDRESS                                                 (0x1108 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_66_RSTMASK                                                 0xffffffff
#define RXPCU_RXBUF_66_RESET                                                   0x0

// 0x110c (RXPCU_RXBUF_67)
#define RXPCU_RXBUF_DATA_67_LSB                                                0
#define RXPCU_RXBUF_DATA_67_MSB                                                31
#define RXPCU_RXBUF_DATA_67_MASK                                               0xffffffff
#define RXPCU_RXBUF_DATA_67_GET(x)                                             (((x) & RXPCU_RXBUF_DATA_67_MASK) >> RXPCU_RXBUF_DATA_67_LSB)
#define RXPCU_RXBUF_DATA_67_SET(x)                                             (((0 | (x)) << RXPCU_RXBUF_DATA_67_LSB) & RXPCU_RXBUF_DATA_67_MASK)
#define RXPCU_RXBUF_DATA_67_RESET                                              0x0
#define RXPCU_RXBUF_67_ADDRESS                                                 (0x110c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_67_RSTMASK                                                 0xffffffff
#define RXPCU_RXBUF_67_RESET                                                   0x0

// 0x1110 (RXPCU_RXBUF_68)
#define RXPCU_RXBUF_DATA_68_LSB                                                0
#define RXPCU_RXBUF_DATA_68_MSB                                                31
#define RXPCU_RXBUF_DATA_68_MASK                                               0xffffffff
#define RXPCU_RXBUF_DATA_68_GET(x)                                             (((x) & RXPCU_RXBUF_DATA_68_MASK) >> RXPCU_RXBUF_DATA_68_LSB)
#define RXPCU_RXBUF_DATA_68_SET(x)                                             (((0 | (x)) << RXPCU_RXBUF_DATA_68_LSB) & RXPCU_RXBUF_DATA_68_MASK)
#define RXPCU_RXBUF_DATA_68_RESET                                              0x0
#define RXPCU_RXBUF_68_ADDRESS                                                 (0x1110 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_68_RSTMASK                                                 0xffffffff
#define RXPCU_RXBUF_68_RESET                                                   0x0

// 0x1114 (RXPCU_RXBUF_69)
#define RXPCU_RXBUF_DATA_69_LSB                                                0
#define RXPCU_RXBUF_DATA_69_MSB                                                31
#define RXPCU_RXBUF_DATA_69_MASK                                               0xffffffff
#define RXPCU_RXBUF_DATA_69_GET(x)                                             (((x) & RXPCU_RXBUF_DATA_69_MASK) >> RXPCU_RXBUF_DATA_69_LSB)
#define RXPCU_RXBUF_DATA_69_SET(x)                                             (((0 | (x)) << RXPCU_RXBUF_DATA_69_LSB) & RXPCU_RXBUF_DATA_69_MASK)
#define RXPCU_RXBUF_DATA_69_RESET                                              0x0
#define RXPCU_RXBUF_69_ADDRESS                                                 (0x1114 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_69_RSTMASK                                                 0xffffffff
#define RXPCU_RXBUF_69_RESET                                                   0x0

// 0x1118 (RXPCU_RXBUF_70)
#define RXPCU_RXBUF_DATA_70_LSB                                                0
#define RXPCU_RXBUF_DATA_70_MSB                                                31
#define RXPCU_RXBUF_DATA_70_MASK                                               0xffffffff
#define RXPCU_RXBUF_DATA_70_GET(x)                                             (((x) & RXPCU_RXBUF_DATA_70_MASK) >> RXPCU_RXBUF_DATA_70_LSB)
#define RXPCU_RXBUF_DATA_70_SET(x)                                             (((0 | (x)) << RXPCU_RXBUF_DATA_70_LSB) & RXPCU_RXBUF_DATA_70_MASK)
#define RXPCU_RXBUF_DATA_70_RESET                                              0x0
#define RXPCU_RXBUF_70_ADDRESS                                                 (0x1118 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_70_RSTMASK                                                 0xffffffff
#define RXPCU_RXBUF_70_RESET                                                   0x0

// 0x111c (RXPCU_RXBUF_71)
#define RXPCU_RXBUF_DATA_71_LSB                                                0
#define RXPCU_RXBUF_DATA_71_MSB                                                31
#define RXPCU_RXBUF_DATA_71_MASK                                               0xffffffff
#define RXPCU_RXBUF_DATA_71_GET(x)                                             (((x) & RXPCU_RXBUF_DATA_71_MASK) >> RXPCU_RXBUF_DATA_71_LSB)
#define RXPCU_RXBUF_DATA_71_SET(x)                                             (((0 | (x)) << RXPCU_RXBUF_DATA_71_LSB) & RXPCU_RXBUF_DATA_71_MASK)
#define RXPCU_RXBUF_DATA_71_RESET                                              0x0
#define RXPCU_RXBUF_71_ADDRESS                                                 (0x111c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_71_RSTMASK                                                 0xffffffff
#define RXPCU_RXBUF_71_RESET                                                   0x0

// 0x1120 (RXPCU_RXBUF_72)
#define RXPCU_RXBUF_DATA_72_LSB                                                0
#define RXPCU_RXBUF_DATA_72_MSB                                                31
#define RXPCU_RXBUF_DATA_72_MASK                                               0xffffffff
#define RXPCU_RXBUF_DATA_72_GET(x)                                             (((x) & RXPCU_RXBUF_DATA_72_MASK) >> RXPCU_RXBUF_DATA_72_LSB)
#define RXPCU_RXBUF_DATA_72_SET(x)                                             (((0 | (x)) << RXPCU_RXBUF_DATA_72_LSB) & RXPCU_RXBUF_DATA_72_MASK)
#define RXPCU_RXBUF_DATA_72_RESET                                              0x0
#define RXPCU_RXBUF_72_ADDRESS                                                 (0x1120 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_72_RSTMASK                                                 0xffffffff
#define RXPCU_RXBUF_72_RESET                                                   0x0

// 0x1124 (RXPCU_RXBUF_73)
#define RXPCU_RXBUF_DATA_73_LSB                                                0
#define RXPCU_RXBUF_DATA_73_MSB                                                31
#define RXPCU_RXBUF_DATA_73_MASK                                               0xffffffff
#define RXPCU_RXBUF_DATA_73_GET(x)                                             (((x) & RXPCU_RXBUF_DATA_73_MASK) >> RXPCU_RXBUF_DATA_73_LSB)
#define RXPCU_RXBUF_DATA_73_SET(x)                                             (((0 | (x)) << RXPCU_RXBUF_DATA_73_LSB) & RXPCU_RXBUF_DATA_73_MASK)
#define RXPCU_RXBUF_DATA_73_RESET                                              0x0
#define RXPCU_RXBUF_73_ADDRESS                                                 (0x1124 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_73_RSTMASK                                                 0xffffffff
#define RXPCU_RXBUF_73_RESET                                                   0x0

// 0x1128 (RXPCU_RXBUF_74)
#define RXPCU_RXBUF_DATA_74_LSB                                                0
#define RXPCU_RXBUF_DATA_74_MSB                                                31
#define RXPCU_RXBUF_DATA_74_MASK                                               0xffffffff
#define RXPCU_RXBUF_DATA_74_GET(x)                                             (((x) & RXPCU_RXBUF_DATA_74_MASK) >> RXPCU_RXBUF_DATA_74_LSB)
#define RXPCU_RXBUF_DATA_74_SET(x)                                             (((0 | (x)) << RXPCU_RXBUF_DATA_74_LSB) & RXPCU_RXBUF_DATA_74_MASK)
#define RXPCU_RXBUF_DATA_74_RESET                                              0x0
#define RXPCU_RXBUF_74_ADDRESS                                                 (0x1128 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_74_RSTMASK                                                 0xffffffff
#define RXPCU_RXBUF_74_RESET                                                   0x0

// 0x112c (RXPCU_RXBUF_75)
#define RXPCU_RXBUF_DATA_75_LSB                                                0
#define RXPCU_RXBUF_DATA_75_MSB                                                31
#define RXPCU_RXBUF_DATA_75_MASK                                               0xffffffff
#define RXPCU_RXBUF_DATA_75_GET(x)                                             (((x) & RXPCU_RXBUF_DATA_75_MASK) >> RXPCU_RXBUF_DATA_75_LSB)
#define RXPCU_RXBUF_DATA_75_SET(x)                                             (((0 | (x)) << RXPCU_RXBUF_DATA_75_LSB) & RXPCU_RXBUF_DATA_75_MASK)
#define RXPCU_RXBUF_DATA_75_RESET                                              0x0
#define RXPCU_RXBUF_75_ADDRESS                                                 (0x112c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_75_RSTMASK                                                 0xffffffff
#define RXPCU_RXBUF_75_RESET                                                   0x0

// 0x1130 (RXPCU_RXBUF_76)
#define RXPCU_RXBUF_DATA_76_LSB                                                0
#define RXPCU_RXBUF_DATA_76_MSB                                                31
#define RXPCU_RXBUF_DATA_76_MASK                                               0xffffffff
#define RXPCU_RXBUF_DATA_76_GET(x)                                             (((x) & RXPCU_RXBUF_DATA_76_MASK) >> RXPCU_RXBUF_DATA_76_LSB)
#define RXPCU_RXBUF_DATA_76_SET(x)                                             (((0 | (x)) << RXPCU_RXBUF_DATA_76_LSB) & RXPCU_RXBUF_DATA_76_MASK)
#define RXPCU_RXBUF_DATA_76_RESET                                              0x0
#define RXPCU_RXBUF_76_ADDRESS                                                 (0x1130 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_76_RSTMASK                                                 0xffffffff
#define RXPCU_RXBUF_76_RESET                                                   0x0

// 0x1134 (RXPCU_RXBUF_77)
#define RXPCU_RXBUF_DATA_77_LSB                                                0
#define RXPCU_RXBUF_DATA_77_MSB                                                31
#define RXPCU_RXBUF_DATA_77_MASK                                               0xffffffff
#define RXPCU_RXBUF_DATA_77_GET(x)                                             (((x) & RXPCU_RXBUF_DATA_77_MASK) >> RXPCU_RXBUF_DATA_77_LSB)
#define RXPCU_RXBUF_DATA_77_SET(x)                                             (((0 | (x)) << RXPCU_RXBUF_DATA_77_LSB) & RXPCU_RXBUF_DATA_77_MASK)
#define RXPCU_RXBUF_DATA_77_RESET                                              0x0
#define RXPCU_RXBUF_77_ADDRESS                                                 (0x1134 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_77_RSTMASK                                                 0xffffffff
#define RXPCU_RXBUF_77_RESET                                                   0x0

// 0x1138 (RXPCU_RXBUF_78)
#define RXPCU_RXBUF_DATA_78_LSB                                                0
#define RXPCU_RXBUF_DATA_78_MSB                                                31
#define RXPCU_RXBUF_DATA_78_MASK                                               0xffffffff
#define RXPCU_RXBUF_DATA_78_GET(x)                                             (((x) & RXPCU_RXBUF_DATA_78_MASK) >> RXPCU_RXBUF_DATA_78_LSB)
#define RXPCU_RXBUF_DATA_78_SET(x)                                             (((0 | (x)) << RXPCU_RXBUF_DATA_78_LSB) & RXPCU_RXBUF_DATA_78_MASK)
#define RXPCU_RXBUF_DATA_78_RESET                                              0x0
#define RXPCU_RXBUF_78_ADDRESS                                                 (0x1138 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_78_RSTMASK                                                 0xffffffff
#define RXPCU_RXBUF_78_RESET                                                   0x0

// 0x113c (RXPCU_RXBUF_79)
#define RXPCU_RXBUF_DATA_79_LSB                                                0
#define RXPCU_RXBUF_DATA_79_MSB                                                31
#define RXPCU_RXBUF_DATA_79_MASK                                               0xffffffff
#define RXPCU_RXBUF_DATA_79_GET(x)                                             (((x) & RXPCU_RXBUF_DATA_79_MASK) >> RXPCU_RXBUF_DATA_79_LSB)
#define RXPCU_RXBUF_DATA_79_SET(x)                                             (((0 | (x)) << RXPCU_RXBUF_DATA_79_LSB) & RXPCU_RXBUF_DATA_79_MASK)
#define RXPCU_RXBUF_DATA_79_RESET                                              0x0
#define RXPCU_RXBUF_79_ADDRESS                                                 (0x113c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_79_RSTMASK                                                 0xffffffff
#define RXPCU_RXBUF_79_RESET                                                   0x0

// 0x1140 (RXPCU_RXBUF_80)
#define RXPCU_RXBUF_DATA_80_LSB                                                0
#define RXPCU_RXBUF_DATA_80_MSB                                                31
#define RXPCU_RXBUF_DATA_80_MASK                                               0xffffffff
#define RXPCU_RXBUF_DATA_80_GET(x)                                             (((x) & RXPCU_RXBUF_DATA_80_MASK) >> RXPCU_RXBUF_DATA_80_LSB)
#define RXPCU_RXBUF_DATA_80_SET(x)                                             (((0 | (x)) << RXPCU_RXBUF_DATA_80_LSB) & RXPCU_RXBUF_DATA_80_MASK)
#define RXPCU_RXBUF_DATA_80_RESET                                              0x0
#define RXPCU_RXBUF_80_ADDRESS                                                 (0x1140 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_80_RSTMASK                                                 0xffffffff
#define RXPCU_RXBUF_80_RESET                                                   0x0

// 0x1144 (RXPCU_RXBUF_81)
#define RXPCU_RXBUF_DATA_81_LSB                                                0
#define RXPCU_RXBUF_DATA_81_MSB                                                31
#define RXPCU_RXBUF_DATA_81_MASK                                               0xffffffff
#define RXPCU_RXBUF_DATA_81_GET(x)                                             (((x) & RXPCU_RXBUF_DATA_81_MASK) >> RXPCU_RXBUF_DATA_81_LSB)
#define RXPCU_RXBUF_DATA_81_SET(x)                                             (((0 | (x)) << RXPCU_RXBUF_DATA_81_LSB) & RXPCU_RXBUF_DATA_81_MASK)
#define RXPCU_RXBUF_DATA_81_RESET                                              0x0
#define RXPCU_RXBUF_81_ADDRESS                                                 (0x1144 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_81_RSTMASK                                                 0xffffffff
#define RXPCU_RXBUF_81_RESET                                                   0x0

// 0x1148 (RXPCU_RXBUF_82)
#define RXPCU_RXBUF_DATA_82_LSB                                                0
#define RXPCU_RXBUF_DATA_82_MSB                                                31
#define RXPCU_RXBUF_DATA_82_MASK                                               0xffffffff
#define RXPCU_RXBUF_DATA_82_GET(x)                                             (((x) & RXPCU_RXBUF_DATA_82_MASK) >> RXPCU_RXBUF_DATA_82_LSB)
#define RXPCU_RXBUF_DATA_82_SET(x)                                             (((0 | (x)) << RXPCU_RXBUF_DATA_82_LSB) & RXPCU_RXBUF_DATA_82_MASK)
#define RXPCU_RXBUF_DATA_82_RESET                                              0x0
#define RXPCU_RXBUF_82_ADDRESS                                                 (0x1148 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_82_RSTMASK                                                 0xffffffff
#define RXPCU_RXBUF_82_RESET                                                   0x0

// 0x114c (RXPCU_RXBUF_83)
#define RXPCU_RXBUF_DATA_83_LSB                                                0
#define RXPCU_RXBUF_DATA_83_MSB                                                31
#define RXPCU_RXBUF_DATA_83_MASK                                               0xffffffff
#define RXPCU_RXBUF_DATA_83_GET(x)                                             (((x) & RXPCU_RXBUF_DATA_83_MASK) >> RXPCU_RXBUF_DATA_83_LSB)
#define RXPCU_RXBUF_DATA_83_SET(x)                                             (((0 | (x)) << RXPCU_RXBUF_DATA_83_LSB) & RXPCU_RXBUF_DATA_83_MASK)
#define RXPCU_RXBUF_DATA_83_RESET                                              0x0
#define RXPCU_RXBUF_83_ADDRESS                                                 (0x114c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_83_RSTMASK                                                 0xffffffff
#define RXPCU_RXBUF_83_RESET                                                   0x0

// 0x1150 (RXPCU_RXBUF_84)
#define RXPCU_RXBUF_DATA_84_LSB                                                0
#define RXPCU_RXBUF_DATA_84_MSB                                                31
#define RXPCU_RXBUF_DATA_84_MASK                                               0xffffffff
#define RXPCU_RXBUF_DATA_84_GET(x)                                             (((x) & RXPCU_RXBUF_DATA_84_MASK) >> RXPCU_RXBUF_DATA_84_LSB)
#define RXPCU_RXBUF_DATA_84_SET(x)                                             (((0 | (x)) << RXPCU_RXBUF_DATA_84_LSB) & RXPCU_RXBUF_DATA_84_MASK)
#define RXPCU_RXBUF_DATA_84_RESET                                              0x0
#define RXPCU_RXBUF_84_ADDRESS                                                 (0x1150 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_84_RSTMASK                                                 0xffffffff
#define RXPCU_RXBUF_84_RESET                                                   0x0

// 0x1154 (RXPCU_RXBUF_85)
#define RXPCU_RXBUF_DATA_85_LSB                                                0
#define RXPCU_RXBUF_DATA_85_MSB                                                31
#define RXPCU_RXBUF_DATA_85_MASK                                               0xffffffff
#define RXPCU_RXBUF_DATA_85_GET(x)                                             (((x) & RXPCU_RXBUF_DATA_85_MASK) >> RXPCU_RXBUF_DATA_85_LSB)
#define RXPCU_RXBUF_DATA_85_SET(x)                                             (((0 | (x)) << RXPCU_RXBUF_DATA_85_LSB) & RXPCU_RXBUF_DATA_85_MASK)
#define RXPCU_RXBUF_DATA_85_RESET                                              0x0
#define RXPCU_RXBUF_85_ADDRESS                                                 (0x1154 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_85_RSTMASK                                                 0xffffffff
#define RXPCU_RXBUF_85_RESET                                                   0x0

// 0x1158 (RXPCU_RXBUF_86)
#define RXPCU_RXBUF_DATA_86_LSB                                                0
#define RXPCU_RXBUF_DATA_86_MSB                                                31
#define RXPCU_RXBUF_DATA_86_MASK                                               0xffffffff
#define RXPCU_RXBUF_DATA_86_GET(x)                                             (((x) & RXPCU_RXBUF_DATA_86_MASK) >> RXPCU_RXBUF_DATA_86_LSB)
#define RXPCU_RXBUF_DATA_86_SET(x)                                             (((0 | (x)) << RXPCU_RXBUF_DATA_86_LSB) & RXPCU_RXBUF_DATA_86_MASK)
#define RXPCU_RXBUF_DATA_86_RESET                                              0x0
#define RXPCU_RXBUF_86_ADDRESS                                                 (0x1158 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_86_RSTMASK                                                 0xffffffff
#define RXPCU_RXBUF_86_RESET                                                   0x0

// 0x115c (RXPCU_RXBUF_87)
#define RXPCU_RXBUF_DATA_87_LSB                                                0
#define RXPCU_RXBUF_DATA_87_MSB                                                31
#define RXPCU_RXBUF_DATA_87_MASK                                               0xffffffff
#define RXPCU_RXBUF_DATA_87_GET(x)                                             (((x) & RXPCU_RXBUF_DATA_87_MASK) >> RXPCU_RXBUF_DATA_87_LSB)
#define RXPCU_RXBUF_DATA_87_SET(x)                                             (((0 | (x)) << RXPCU_RXBUF_DATA_87_LSB) & RXPCU_RXBUF_DATA_87_MASK)
#define RXPCU_RXBUF_DATA_87_RESET                                              0x0
#define RXPCU_RXBUF_87_ADDRESS                                                 (0x115c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_87_RSTMASK                                                 0xffffffff
#define RXPCU_RXBUF_87_RESET                                                   0x0

// 0x1160 (RXPCU_RXBUF_88)
#define RXPCU_RXBUF_DATA_88_LSB                                                0
#define RXPCU_RXBUF_DATA_88_MSB                                                31
#define RXPCU_RXBUF_DATA_88_MASK                                               0xffffffff
#define RXPCU_RXBUF_DATA_88_GET(x)                                             (((x) & RXPCU_RXBUF_DATA_88_MASK) >> RXPCU_RXBUF_DATA_88_LSB)
#define RXPCU_RXBUF_DATA_88_SET(x)                                             (((0 | (x)) << RXPCU_RXBUF_DATA_88_LSB) & RXPCU_RXBUF_DATA_88_MASK)
#define RXPCU_RXBUF_DATA_88_RESET                                              0x0
#define RXPCU_RXBUF_88_ADDRESS                                                 (0x1160 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_88_RSTMASK                                                 0xffffffff
#define RXPCU_RXBUF_88_RESET                                                   0x0

// 0x1164 (RXPCU_RXBUF_89)
#define RXPCU_RXBUF_DATA_89_LSB                                                0
#define RXPCU_RXBUF_DATA_89_MSB                                                31
#define RXPCU_RXBUF_DATA_89_MASK                                               0xffffffff
#define RXPCU_RXBUF_DATA_89_GET(x)                                             (((x) & RXPCU_RXBUF_DATA_89_MASK) >> RXPCU_RXBUF_DATA_89_LSB)
#define RXPCU_RXBUF_DATA_89_SET(x)                                             (((0 | (x)) << RXPCU_RXBUF_DATA_89_LSB) & RXPCU_RXBUF_DATA_89_MASK)
#define RXPCU_RXBUF_DATA_89_RESET                                              0x0
#define RXPCU_RXBUF_89_ADDRESS                                                 (0x1164 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_89_RSTMASK                                                 0xffffffff
#define RXPCU_RXBUF_89_RESET                                                   0x0

// 0x1168 (RXPCU_RXBUF_90)
#define RXPCU_RXBUF_DATA_90_LSB                                                0
#define RXPCU_RXBUF_DATA_90_MSB                                                31
#define RXPCU_RXBUF_DATA_90_MASK                                               0xffffffff
#define RXPCU_RXBUF_DATA_90_GET(x)                                             (((x) & RXPCU_RXBUF_DATA_90_MASK) >> RXPCU_RXBUF_DATA_90_LSB)
#define RXPCU_RXBUF_DATA_90_SET(x)                                             (((0 | (x)) << RXPCU_RXBUF_DATA_90_LSB) & RXPCU_RXBUF_DATA_90_MASK)
#define RXPCU_RXBUF_DATA_90_RESET                                              0x0
#define RXPCU_RXBUF_90_ADDRESS                                                 (0x1168 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_90_RSTMASK                                                 0xffffffff
#define RXPCU_RXBUF_90_RESET                                                   0x0

// 0x116c (RXPCU_RXBUF_91)
#define RXPCU_RXBUF_DATA_91_LSB                                                0
#define RXPCU_RXBUF_DATA_91_MSB                                                31
#define RXPCU_RXBUF_DATA_91_MASK                                               0xffffffff
#define RXPCU_RXBUF_DATA_91_GET(x)                                             (((x) & RXPCU_RXBUF_DATA_91_MASK) >> RXPCU_RXBUF_DATA_91_LSB)
#define RXPCU_RXBUF_DATA_91_SET(x)                                             (((0 | (x)) << RXPCU_RXBUF_DATA_91_LSB) & RXPCU_RXBUF_DATA_91_MASK)
#define RXPCU_RXBUF_DATA_91_RESET                                              0x0
#define RXPCU_RXBUF_91_ADDRESS                                                 (0x116c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_91_RSTMASK                                                 0xffffffff
#define RXPCU_RXBUF_91_RESET                                                   0x0

// 0x1170 (RXPCU_RXBUF_92)
#define RXPCU_RXBUF_DATA_92_LSB                                                0
#define RXPCU_RXBUF_DATA_92_MSB                                                31
#define RXPCU_RXBUF_DATA_92_MASK                                               0xffffffff
#define RXPCU_RXBUF_DATA_92_GET(x)                                             (((x) & RXPCU_RXBUF_DATA_92_MASK) >> RXPCU_RXBUF_DATA_92_LSB)
#define RXPCU_RXBUF_DATA_92_SET(x)                                             (((0 | (x)) << RXPCU_RXBUF_DATA_92_LSB) & RXPCU_RXBUF_DATA_92_MASK)
#define RXPCU_RXBUF_DATA_92_RESET                                              0x0
#define RXPCU_RXBUF_92_ADDRESS                                                 (0x1170 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_92_RSTMASK                                                 0xffffffff
#define RXPCU_RXBUF_92_RESET                                                   0x0

// 0x1174 (RXPCU_RXBUF_93)
#define RXPCU_RXBUF_DATA_93_LSB                                                0
#define RXPCU_RXBUF_DATA_93_MSB                                                31
#define RXPCU_RXBUF_DATA_93_MASK                                               0xffffffff
#define RXPCU_RXBUF_DATA_93_GET(x)                                             (((x) & RXPCU_RXBUF_DATA_93_MASK) >> RXPCU_RXBUF_DATA_93_LSB)
#define RXPCU_RXBUF_DATA_93_SET(x)                                             (((0 | (x)) << RXPCU_RXBUF_DATA_93_LSB) & RXPCU_RXBUF_DATA_93_MASK)
#define RXPCU_RXBUF_DATA_93_RESET                                              0x0
#define RXPCU_RXBUF_93_ADDRESS                                                 (0x1174 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_93_RSTMASK                                                 0xffffffff
#define RXPCU_RXBUF_93_RESET                                                   0x0

// 0x1178 (RXPCU_RXBUF_94)
#define RXPCU_RXBUF_DATA_94_LSB                                                0
#define RXPCU_RXBUF_DATA_94_MSB                                                31
#define RXPCU_RXBUF_DATA_94_MASK                                               0xffffffff
#define RXPCU_RXBUF_DATA_94_GET(x)                                             (((x) & RXPCU_RXBUF_DATA_94_MASK) >> RXPCU_RXBUF_DATA_94_LSB)
#define RXPCU_RXBUF_DATA_94_SET(x)                                             (((0 | (x)) << RXPCU_RXBUF_DATA_94_LSB) & RXPCU_RXBUF_DATA_94_MASK)
#define RXPCU_RXBUF_DATA_94_RESET                                              0x0
#define RXPCU_RXBUF_94_ADDRESS                                                 (0x1178 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_94_RSTMASK                                                 0xffffffff
#define RXPCU_RXBUF_94_RESET                                                   0x0

// 0x117c (RXPCU_RXBUF_95)
#define RXPCU_RXBUF_DATA_95_LSB                                                0
#define RXPCU_RXBUF_DATA_95_MSB                                                31
#define RXPCU_RXBUF_DATA_95_MASK                                               0xffffffff
#define RXPCU_RXBUF_DATA_95_GET(x)                                             (((x) & RXPCU_RXBUF_DATA_95_MASK) >> RXPCU_RXBUF_DATA_95_LSB)
#define RXPCU_RXBUF_DATA_95_SET(x)                                             (((0 | (x)) << RXPCU_RXBUF_DATA_95_LSB) & RXPCU_RXBUF_DATA_95_MASK)
#define RXPCU_RXBUF_DATA_95_RESET                                              0x0
#define RXPCU_RXBUF_95_ADDRESS                                                 (0x117c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_95_RSTMASK                                                 0xffffffff
#define RXPCU_RXBUF_95_RESET                                                   0x0

// 0x1180 (RXPCU_RXBUF_96)
#define RXPCU_RXBUF_DATA_96_LSB                                                0
#define RXPCU_RXBUF_DATA_96_MSB                                                31
#define RXPCU_RXBUF_DATA_96_MASK                                               0xffffffff
#define RXPCU_RXBUF_DATA_96_GET(x)                                             (((x) & RXPCU_RXBUF_DATA_96_MASK) >> RXPCU_RXBUF_DATA_96_LSB)
#define RXPCU_RXBUF_DATA_96_SET(x)                                             (((0 | (x)) << RXPCU_RXBUF_DATA_96_LSB) & RXPCU_RXBUF_DATA_96_MASK)
#define RXPCU_RXBUF_DATA_96_RESET                                              0x0
#define RXPCU_RXBUF_96_ADDRESS                                                 (0x1180 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_96_RSTMASK                                                 0xffffffff
#define RXPCU_RXBUF_96_RESET                                                   0x0

// 0x1184 (RXPCU_RXBUF_97)
#define RXPCU_RXBUF_DATA_97_LSB                                                0
#define RXPCU_RXBUF_DATA_97_MSB                                                31
#define RXPCU_RXBUF_DATA_97_MASK                                               0xffffffff
#define RXPCU_RXBUF_DATA_97_GET(x)                                             (((x) & RXPCU_RXBUF_DATA_97_MASK) >> RXPCU_RXBUF_DATA_97_LSB)
#define RXPCU_RXBUF_DATA_97_SET(x)                                             (((0 | (x)) << RXPCU_RXBUF_DATA_97_LSB) & RXPCU_RXBUF_DATA_97_MASK)
#define RXPCU_RXBUF_DATA_97_RESET                                              0x0
#define RXPCU_RXBUF_97_ADDRESS                                                 (0x1184 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_97_RSTMASK                                                 0xffffffff
#define RXPCU_RXBUF_97_RESET                                                   0x0

// 0x1188 (RXPCU_RXBUF_98)
#define RXPCU_RXBUF_DATA_98_LSB                                                0
#define RXPCU_RXBUF_DATA_98_MSB                                                31
#define RXPCU_RXBUF_DATA_98_MASK                                               0xffffffff
#define RXPCU_RXBUF_DATA_98_GET(x)                                             (((x) & RXPCU_RXBUF_DATA_98_MASK) >> RXPCU_RXBUF_DATA_98_LSB)
#define RXPCU_RXBUF_DATA_98_SET(x)                                             (((0 | (x)) << RXPCU_RXBUF_DATA_98_LSB) & RXPCU_RXBUF_DATA_98_MASK)
#define RXPCU_RXBUF_DATA_98_RESET                                              0x0
#define RXPCU_RXBUF_98_ADDRESS                                                 (0x1188 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_98_RSTMASK                                                 0xffffffff
#define RXPCU_RXBUF_98_RESET                                                   0x0

// 0x118c (RXPCU_RXBUF_99)
#define RXPCU_RXBUF_DATA_99_LSB                                                0
#define RXPCU_RXBUF_DATA_99_MSB                                                31
#define RXPCU_RXBUF_DATA_99_MASK                                               0xffffffff
#define RXPCU_RXBUF_DATA_99_GET(x)                                             (((x) & RXPCU_RXBUF_DATA_99_MASK) >> RXPCU_RXBUF_DATA_99_LSB)
#define RXPCU_RXBUF_DATA_99_SET(x)                                             (((0 | (x)) << RXPCU_RXBUF_DATA_99_LSB) & RXPCU_RXBUF_DATA_99_MASK)
#define RXPCU_RXBUF_DATA_99_RESET                                              0x0
#define RXPCU_RXBUF_99_ADDRESS                                                 (0x118c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_99_RSTMASK                                                 0xffffffff
#define RXPCU_RXBUF_99_RESET                                                   0x0

// 0x1190 (RXPCU_RXBUF_100)
#define RXPCU_RXBUF_DATA_100_LSB                                               0
#define RXPCU_RXBUF_DATA_100_MSB                                               31
#define RXPCU_RXBUF_DATA_100_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_100_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_100_MASK) >> RXPCU_RXBUF_DATA_100_LSB)
#define RXPCU_RXBUF_DATA_100_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_100_LSB) & RXPCU_RXBUF_DATA_100_MASK)
#define RXPCU_RXBUF_DATA_100_RESET                                             0x0
#define RXPCU_RXBUF_100_ADDRESS                                                (0x1190 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_100_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_100_RESET                                                  0x0

// 0x1194 (RXPCU_RXBUF_101)
#define RXPCU_RXBUF_DATA_101_LSB                                               0
#define RXPCU_RXBUF_DATA_101_MSB                                               31
#define RXPCU_RXBUF_DATA_101_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_101_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_101_MASK) >> RXPCU_RXBUF_DATA_101_LSB)
#define RXPCU_RXBUF_DATA_101_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_101_LSB) & RXPCU_RXBUF_DATA_101_MASK)
#define RXPCU_RXBUF_DATA_101_RESET                                             0x0
#define RXPCU_RXBUF_101_ADDRESS                                                (0x1194 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_101_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_101_RESET                                                  0x0

// 0x1198 (RXPCU_RXBUF_102)
#define RXPCU_RXBUF_DATA_102_LSB                                               0
#define RXPCU_RXBUF_DATA_102_MSB                                               31
#define RXPCU_RXBUF_DATA_102_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_102_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_102_MASK) >> RXPCU_RXBUF_DATA_102_LSB)
#define RXPCU_RXBUF_DATA_102_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_102_LSB) & RXPCU_RXBUF_DATA_102_MASK)
#define RXPCU_RXBUF_DATA_102_RESET                                             0x0
#define RXPCU_RXBUF_102_ADDRESS                                                (0x1198 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_102_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_102_RESET                                                  0x0

// 0x119c (RXPCU_RXBUF_103)
#define RXPCU_RXBUF_DATA_103_LSB                                               0
#define RXPCU_RXBUF_DATA_103_MSB                                               31
#define RXPCU_RXBUF_DATA_103_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_103_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_103_MASK) >> RXPCU_RXBUF_DATA_103_LSB)
#define RXPCU_RXBUF_DATA_103_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_103_LSB) & RXPCU_RXBUF_DATA_103_MASK)
#define RXPCU_RXBUF_DATA_103_RESET                                             0x0
#define RXPCU_RXBUF_103_ADDRESS                                                (0x119c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_103_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_103_RESET                                                  0x0

// 0x11a0 (RXPCU_RXBUF_104)
#define RXPCU_RXBUF_DATA_104_LSB                                               0
#define RXPCU_RXBUF_DATA_104_MSB                                               31
#define RXPCU_RXBUF_DATA_104_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_104_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_104_MASK) >> RXPCU_RXBUF_DATA_104_LSB)
#define RXPCU_RXBUF_DATA_104_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_104_LSB) & RXPCU_RXBUF_DATA_104_MASK)
#define RXPCU_RXBUF_DATA_104_RESET                                             0x0
#define RXPCU_RXBUF_104_ADDRESS                                                (0x11a0 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_104_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_104_RESET                                                  0x0

// 0x11a4 (RXPCU_RXBUF_105)
#define RXPCU_RXBUF_DATA_105_LSB                                               0
#define RXPCU_RXBUF_DATA_105_MSB                                               31
#define RXPCU_RXBUF_DATA_105_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_105_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_105_MASK) >> RXPCU_RXBUF_DATA_105_LSB)
#define RXPCU_RXBUF_DATA_105_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_105_LSB) & RXPCU_RXBUF_DATA_105_MASK)
#define RXPCU_RXBUF_DATA_105_RESET                                             0x0
#define RXPCU_RXBUF_105_ADDRESS                                                (0x11a4 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_105_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_105_RESET                                                  0x0

// 0x11a8 (RXPCU_RXBUF_106)
#define RXPCU_RXBUF_DATA_106_LSB                                               0
#define RXPCU_RXBUF_DATA_106_MSB                                               31
#define RXPCU_RXBUF_DATA_106_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_106_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_106_MASK) >> RXPCU_RXBUF_DATA_106_LSB)
#define RXPCU_RXBUF_DATA_106_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_106_LSB) & RXPCU_RXBUF_DATA_106_MASK)
#define RXPCU_RXBUF_DATA_106_RESET                                             0x0
#define RXPCU_RXBUF_106_ADDRESS                                                (0x11a8 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_106_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_106_RESET                                                  0x0

// 0x11ac (RXPCU_RXBUF_107)
#define RXPCU_RXBUF_DATA_107_LSB                                               0
#define RXPCU_RXBUF_DATA_107_MSB                                               31
#define RXPCU_RXBUF_DATA_107_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_107_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_107_MASK) >> RXPCU_RXBUF_DATA_107_LSB)
#define RXPCU_RXBUF_DATA_107_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_107_LSB) & RXPCU_RXBUF_DATA_107_MASK)
#define RXPCU_RXBUF_DATA_107_RESET                                             0x0
#define RXPCU_RXBUF_107_ADDRESS                                                (0x11ac + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_107_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_107_RESET                                                  0x0

// 0x11b0 (RXPCU_RXBUF_108)
#define RXPCU_RXBUF_DATA_108_LSB                                               0
#define RXPCU_RXBUF_DATA_108_MSB                                               31
#define RXPCU_RXBUF_DATA_108_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_108_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_108_MASK) >> RXPCU_RXBUF_DATA_108_LSB)
#define RXPCU_RXBUF_DATA_108_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_108_LSB) & RXPCU_RXBUF_DATA_108_MASK)
#define RXPCU_RXBUF_DATA_108_RESET                                             0x0
#define RXPCU_RXBUF_108_ADDRESS                                                (0x11b0 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_108_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_108_RESET                                                  0x0

// 0x11b4 (RXPCU_RXBUF_109)
#define RXPCU_RXBUF_DATA_109_LSB                                               0
#define RXPCU_RXBUF_DATA_109_MSB                                               31
#define RXPCU_RXBUF_DATA_109_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_109_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_109_MASK) >> RXPCU_RXBUF_DATA_109_LSB)
#define RXPCU_RXBUF_DATA_109_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_109_LSB) & RXPCU_RXBUF_DATA_109_MASK)
#define RXPCU_RXBUF_DATA_109_RESET                                             0x0
#define RXPCU_RXBUF_109_ADDRESS                                                (0x11b4 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_109_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_109_RESET                                                  0x0

// 0x11b8 (RXPCU_RXBUF_110)
#define RXPCU_RXBUF_DATA_110_LSB                                               0
#define RXPCU_RXBUF_DATA_110_MSB                                               31
#define RXPCU_RXBUF_DATA_110_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_110_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_110_MASK) >> RXPCU_RXBUF_DATA_110_LSB)
#define RXPCU_RXBUF_DATA_110_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_110_LSB) & RXPCU_RXBUF_DATA_110_MASK)
#define RXPCU_RXBUF_DATA_110_RESET                                             0x0
#define RXPCU_RXBUF_110_ADDRESS                                                (0x11b8 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_110_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_110_RESET                                                  0x0

// 0x11bc (RXPCU_RXBUF_111)
#define RXPCU_RXBUF_DATA_111_LSB                                               0
#define RXPCU_RXBUF_DATA_111_MSB                                               31
#define RXPCU_RXBUF_DATA_111_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_111_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_111_MASK) >> RXPCU_RXBUF_DATA_111_LSB)
#define RXPCU_RXBUF_DATA_111_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_111_LSB) & RXPCU_RXBUF_DATA_111_MASK)
#define RXPCU_RXBUF_DATA_111_RESET                                             0x0
#define RXPCU_RXBUF_111_ADDRESS                                                (0x11bc + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_111_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_111_RESET                                                  0x0

// 0x11c0 (RXPCU_RXBUF_112)
#define RXPCU_RXBUF_DATA_112_LSB                                               0
#define RXPCU_RXBUF_DATA_112_MSB                                               31
#define RXPCU_RXBUF_DATA_112_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_112_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_112_MASK) >> RXPCU_RXBUF_DATA_112_LSB)
#define RXPCU_RXBUF_DATA_112_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_112_LSB) & RXPCU_RXBUF_DATA_112_MASK)
#define RXPCU_RXBUF_DATA_112_RESET                                             0x0
#define RXPCU_RXBUF_112_ADDRESS                                                (0x11c0 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_112_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_112_RESET                                                  0x0

// 0x11c4 (RXPCU_RXBUF_113)
#define RXPCU_RXBUF_DATA_113_LSB                                               0
#define RXPCU_RXBUF_DATA_113_MSB                                               31
#define RXPCU_RXBUF_DATA_113_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_113_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_113_MASK) >> RXPCU_RXBUF_DATA_113_LSB)
#define RXPCU_RXBUF_DATA_113_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_113_LSB) & RXPCU_RXBUF_DATA_113_MASK)
#define RXPCU_RXBUF_DATA_113_RESET                                             0x0
#define RXPCU_RXBUF_113_ADDRESS                                                (0x11c4 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_113_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_113_RESET                                                  0x0

// 0x11c8 (RXPCU_RXBUF_114)
#define RXPCU_RXBUF_DATA_114_LSB                                               0
#define RXPCU_RXBUF_DATA_114_MSB                                               31
#define RXPCU_RXBUF_DATA_114_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_114_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_114_MASK) >> RXPCU_RXBUF_DATA_114_LSB)
#define RXPCU_RXBUF_DATA_114_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_114_LSB) & RXPCU_RXBUF_DATA_114_MASK)
#define RXPCU_RXBUF_DATA_114_RESET                                             0x0
#define RXPCU_RXBUF_114_ADDRESS                                                (0x11c8 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_114_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_114_RESET                                                  0x0

// 0x11cc (RXPCU_RXBUF_115)
#define RXPCU_RXBUF_DATA_115_LSB                                               0
#define RXPCU_RXBUF_DATA_115_MSB                                               31
#define RXPCU_RXBUF_DATA_115_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_115_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_115_MASK) >> RXPCU_RXBUF_DATA_115_LSB)
#define RXPCU_RXBUF_DATA_115_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_115_LSB) & RXPCU_RXBUF_DATA_115_MASK)
#define RXPCU_RXBUF_DATA_115_RESET                                             0x0
#define RXPCU_RXBUF_115_ADDRESS                                                (0x11cc + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_115_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_115_RESET                                                  0x0

// 0x11d0 (RXPCU_RXBUF_116)
#define RXPCU_RXBUF_DATA_116_LSB                                               0
#define RXPCU_RXBUF_DATA_116_MSB                                               31
#define RXPCU_RXBUF_DATA_116_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_116_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_116_MASK) >> RXPCU_RXBUF_DATA_116_LSB)
#define RXPCU_RXBUF_DATA_116_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_116_LSB) & RXPCU_RXBUF_DATA_116_MASK)
#define RXPCU_RXBUF_DATA_116_RESET                                             0x0
#define RXPCU_RXBUF_116_ADDRESS                                                (0x11d0 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_116_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_116_RESET                                                  0x0

// 0x11d4 (RXPCU_RXBUF_117)
#define RXPCU_RXBUF_DATA_117_LSB                                               0
#define RXPCU_RXBUF_DATA_117_MSB                                               31
#define RXPCU_RXBUF_DATA_117_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_117_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_117_MASK) >> RXPCU_RXBUF_DATA_117_LSB)
#define RXPCU_RXBUF_DATA_117_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_117_LSB) & RXPCU_RXBUF_DATA_117_MASK)
#define RXPCU_RXBUF_DATA_117_RESET                                             0x0
#define RXPCU_RXBUF_117_ADDRESS                                                (0x11d4 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_117_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_117_RESET                                                  0x0

// 0x11d8 (RXPCU_RXBUF_118)
#define RXPCU_RXBUF_DATA_118_LSB                                               0
#define RXPCU_RXBUF_DATA_118_MSB                                               31
#define RXPCU_RXBUF_DATA_118_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_118_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_118_MASK) >> RXPCU_RXBUF_DATA_118_LSB)
#define RXPCU_RXBUF_DATA_118_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_118_LSB) & RXPCU_RXBUF_DATA_118_MASK)
#define RXPCU_RXBUF_DATA_118_RESET                                             0x0
#define RXPCU_RXBUF_118_ADDRESS                                                (0x11d8 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_118_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_118_RESET                                                  0x0

// 0x11dc (RXPCU_RXBUF_119)
#define RXPCU_RXBUF_DATA_119_LSB                                               0
#define RXPCU_RXBUF_DATA_119_MSB                                               31
#define RXPCU_RXBUF_DATA_119_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_119_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_119_MASK) >> RXPCU_RXBUF_DATA_119_LSB)
#define RXPCU_RXBUF_DATA_119_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_119_LSB) & RXPCU_RXBUF_DATA_119_MASK)
#define RXPCU_RXBUF_DATA_119_RESET                                             0x0
#define RXPCU_RXBUF_119_ADDRESS                                                (0x11dc + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_119_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_119_RESET                                                  0x0

// 0x11e0 (RXPCU_RXBUF_120)
#define RXPCU_RXBUF_DATA_120_LSB                                               0
#define RXPCU_RXBUF_DATA_120_MSB                                               31
#define RXPCU_RXBUF_DATA_120_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_120_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_120_MASK) >> RXPCU_RXBUF_DATA_120_LSB)
#define RXPCU_RXBUF_DATA_120_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_120_LSB) & RXPCU_RXBUF_DATA_120_MASK)
#define RXPCU_RXBUF_DATA_120_RESET                                             0x0
#define RXPCU_RXBUF_120_ADDRESS                                                (0x11e0 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_120_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_120_RESET                                                  0x0

// 0x11e4 (RXPCU_RXBUF_121)
#define RXPCU_RXBUF_DATA_121_LSB                                               0
#define RXPCU_RXBUF_DATA_121_MSB                                               31
#define RXPCU_RXBUF_DATA_121_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_121_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_121_MASK) >> RXPCU_RXBUF_DATA_121_LSB)
#define RXPCU_RXBUF_DATA_121_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_121_LSB) & RXPCU_RXBUF_DATA_121_MASK)
#define RXPCU_RXBUF_DATA_121_RESET                                             0x0
#define RXPCU_RXBUF_121_ADDRESS                                                (0x11e4 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_121_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_121_RESET                                                  0x0

// 0x11e8 (RXPCU_RXBUF_122)
#define RXPCU_RXBUF_DATA_122_LSB                                               0
#define RXPCU_RXBUF_DATA_122_MSB                                               31
#define RXPCU_RXBUF_DATA_122_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_122_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_122_MASK) >> RXPCU_RXBUF_DATA_122_LSB)
#define RXPCU_RXBUF_DATA_122_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_122_LSB) & RXPCU_RXBUF_DATA_122_MASK)
#define RXPCU_RXBUF_DATA_122_RESET                                             0x0
#define RXPCU_RXBUF_122_ADDRESS                                                (0x11e8 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_122_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_122_RESET                                                  0x0

// 0x11ec (RXPCU_RXBUF_123)
#define RXPCU_RXBUF_DATA_123_LSB                                               0
#define RXPCU_RXBUF_DATA_123_MSB                                               31
#define RXPCU_RXBUF_DATA_123_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_123_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_123_MASK) >> RXPCU_RXBUF_DATA_123_LSB)
#define RXPCU_RXBUF_DATA_123_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_123_LSB) & RXPCU_RXBUF_DATA_123_MASK)
#define RXPCU_RXBUF_DATA_123_RESET                                             0x0
#define RXPCU_RXBUF_123_ADDRESS                                                (0x11ec + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_123_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_123_RESET                                                  0x0

// 0x11f0 (RXPCU_RXBUF_124)
#define RXPCU_RXBUF_DATA_124_LSB                                               0
#define RXPCU_RXBUF_DATA_124_MSB                                               31
#define RXPCU_RXBUF_DATA_124_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_124_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_124_MASK) >> RXPCU_RXBUF_DATA_124_LSB)
#define RXPCU_RXBUF_DATA_124_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_124_LSB) & RXPCU_RXBUF_DATA_124_MASK)
#define RXPCU_RXBUF_DATA_124_RESET                                             0x0
#define RXPCU_RXBUF_124_ADDRESS                                                (0x11f0 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_124_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_124_RESET                                                  0x0

// 0x11f4 (RXPCU_RXBUF_125)
#define RXPCU_RXBUF_DATA_125_LSB                                               0
#define RXPCU_RXBUF_DATA_125_MSB                                               31
#define RXPCU_RXBUF_DATA_125_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_125_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_125_MASK) >> RXPCU_RXBUF_DATA_125_LSB)
#define RXPCU_RXBUF_DATA_125_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_125_LSB) & RXPCU_RXBUF_DATA_125_MASK)
#define RXPCU_RXBUF_DATA_125_RESET                                             0x0
#define RXPCU_RXBUF_125_ADDRESS                                                (0x11f4 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_125_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_125_RESET                                                  0x0

// 0x11f8 (RXPCU_RXBUF_126)
#define RXPCU_RXBUF_DATA_126_LSB                                               0
#define RXPCU_RXBUF_DATA_126_MSB                                               31
#define RXPCU_RXBUF_DATA_126_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_126_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_126_MASK) >> RXPCU_RXBUF_DATA_126_LSB)
#define RXPCU_RXBUF_DATA_126_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_126_LSB) & RXPCU_RXBUF_DATA_126_MASK)
#define RXPCU_RXBUF_DATA_126_RESET                                             0x0
#define RXPCU_RXBUF_126_ADDRESS                                                (0x11f8 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_126_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_126_RESET                                                  0x0

// 0x11fc (RXPCU_RXBUF_127)
#define RXPCU_RXBUF_DATA_127_LSB                                               0
#define RXPCU_RXBUF_DATA_127_MSB                                               31
#define RXPCU_RXBUF_DATA_127_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_127_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_127_MASK) >> RXPCU_RXBUF_DATA_127_LSB)
#define RXPCU_RXBUF_DATA_127_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_127_LSB) & RXPCU_RXBUF_DATA_127_MASK)
#define RXPCU_RXBUF_DATA_127_RESET                                             0x0
#define RXPCU_RXBUF_127_ADDRESS                                                (0x11fc + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_127_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_127_RESET                                                  0x0

// 0x1200 (RXPCU_RXBUF_128)
#define RXPCU_RXBUF_DATA_128_LSB                                               0
#define RXPCU_RXBUF_DATA_128_MSB                                               31
#define RXPCU_RXBUF_DATA_128_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_128_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_128_MASK) >> RXPCU_RXBUF_DATA_128_LSB)
#define RXPCU_RXBUF_DATA_128_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_128_LSB) & RXPCU_RXBUF_DATA_128_MASK)
#define RXPCU_RXBUF_DATA_128_RESET                                             0x0
#define RXPCU_RXBUF_128_ADDRESS                                                (0x1200 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_128_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_128_RESET                                                  0x0

// 0x1204 (RXPCU_RXBUF_129)
#define RXPCU_RXBUF_DATA_129_LSB                                               0
#define RXPCU_RXBUF_DATA_129_MSB                                               31
#define RXPCU_RXBUF_DATA_129_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_129_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_129_MASK) >> RXPCU_RXBUF_DATA_129_LSB)
#define RXPCU_RXBUF_DATA_129_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_129_LSB) & RXPCU_RXBUF_DATA_129_MASK)
#define RXPCU_RXBUF_DATA_129_RESET                                             0x0
#define RXPCU_RXBUF_129_ADDRESS                                                (0x1204 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_129_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_129_RESET                                                  0x0

// 0x1208 (RXPCU_RXBUF_130)
#define RXPCU_RXBUF_DATA_130_LSB                                               0
#define RXPCU_RXBUF_DATA_130_MSB                                               31
#define RXPCU_RXBUF_DATA_130_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_130_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_130_MASK) >> RXPCU_RXBUF_DATA_130_LSB)
#define RXPCU_RXBUF_DATA_130_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_130_LSB) & RXPCU_RXBUF_DATA_130_MASK)
#define RXPCU_RXBUF_DATA_130_RESET                                             0x0
#define RXPCU_RXBUF_130_ADDRESS                                                (0x1208 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_130_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_130_RESET                                                  0x0

// 0x120c (RXPCU_RXBUF_131)
#define RXPCU_RXBUF_DATA_131_LSB                                               0
#define RXPCU_RXBUF_DATA_131_MSB                                               31
#define RXPCU_RXBUF_DATA_131_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_131_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_131_MASK) >> RXPCU_RXBUF_DATA_131_LSB)
#define RXPCU_RXBUF_DATA_131_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_131_LSB) & RXPCU_RXBUF_DATA_131_MASK)
#define RXPCU_RXBUF_DATA_131_RESET                                             0x0
#define RXPCU_RXBUF_131_ADDRESS                                                (0x120c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_131_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_131_RESET                                                  0x0

// 0x1210 (RXPCU_RXBUF_132)
#define RXPCU_RXBUF_DATA_132_LSB                                               0
#define RXPCU_RXBUF_DATA_132_MSB                                               31
#define RXPCU_RXBUF_DATA_132_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_132_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_132_MASK) >> RXPCU_RXBUF_DATA_132_LSB)
#define RXPCU_RXBUF_DATA_132_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_132_LSB) & RXPCU_RXBUF_DATA_132_MASK)
#define RXPCU_RXBUF_DATA_132_RESET                                             0x0
#define RXPCU_RXBUF_132_ADDRESS                                                (0x1210 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_132_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_132_RESET                                                  0x0

// 0x1214 (RXPCU_RXBUF_133)
#define RXPCU_RXBUF_DATA_133_LSB                                               0
#define RXPCU_RXBUF_DATA_133_MSB                                               31
#define RXPCU_RXBUF_DATA_133_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_133_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_133_MASK) >> RXPCU_RXBUF_DATA_133_LSB)
#define RXPCU_RXBUF_DATA_133_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_133_LSB) & RXPCU_RXBUF_DATA_133_MASK)
#define RXPCU_RXBUF_DATA_133_RESET                                             0x0
#define RXPCU_RXBUF_133_ADDRESS                                                (0x1214 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_133_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_133_RESET                                                  0x0

// 0x1218 (RXPCU_RXBUF_134)
#define RXPCU_RXBUF_DATA_134_LSB                                               0
#define RXPCU_RXBUF_DATA_134_MSB                                               31
#define RXPCU_RXBUF_DATA_134_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_134_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_134_MASK) >> RXPCU_RXBUF_DATA_134_LSB)
#define RXPCU_RXBUF_DATA_134_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_134_LSB) & RXPCU_RXBUF_DATA_134_MASK)
#define RXPCU_RXBUF_DATA_134_RESET                                             0x0
#define RXPCU_RXBUF_134_ADDRESS                                                (0x1218 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_134_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_134_RESET                                                  0x0

// 0x121c (RXPCU_RXBUF_135)
#define RXPCU_RXBUF_DATA_135_LSB                                               0
#define RXPCU_RXBUF_DATA_135_MSB                                               31
#define RXPCU_RXBUF_DATA_135_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_135_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_135_MASK) >> RXPCU_RXBUF_DATA_135_LSB)
#define RXPCU_RXBUF_DATA_135_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_135_LSB) & RXPCU_RXBUF_DATA_135_MASK)
#define RXPCU_RXBUF_DATA_135_RESET                                             0x0
#define RXPCU_RXBUF_135_ADDRESS                                                (0x121c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_135_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_135_RESET                                                  0x0

// 0x1220 (RXPCU_RXBUF_136)
#define RXPCU_RXBUF_DATA_136_LSB                                               0
#define RXPCU_RXBUF_DATA_136_MSB                                               31
#define RXPCU_RXBUF_DATA_136_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_136_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_136_MASK) >> RXPCU_RXBUF_DATA_136_LSB)
#define RXPCU_RXBUF_DATA_136_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_136_LSB) & RXPCU_RXBUF_DATA_136_MASK)
#define RXPCU_RXBUF_DATA_136_RESET                                             0x0
#define RXPCU_RXBUF_136_ADDRESS                                                (0x1220 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_136_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_136_RESET                                                  0x0

// 0x1224 (RXPCU_RXBUF_137)
#define RXPCU_RXBUF_DATA_137_LSB                                               0
#define RXPCU_RXBUF_DATA_137_MSB                                               31
#define RXPCU_RXBUF_DATA_137_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_137_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_137_MASK) >> RXPCU_RXBUF_DATA_137_LSB)
#define RXPCU_RXBUF_DATA_137_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_137_LSB) & RXPCU_RXBUF_DATA_137_MASK)
#define RXPCU_RXBUF_DATA_137_RESET                                             0x0
#define RXPCU_RXBUF_137_ADDRESS                                                (0x1224 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_137_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_137_RESET                                                  0x0

// 0x1228 (RXPCU_RXBUF_138)
#define RXPCU_RXBUF_DATA_138_LSB                                               0
#define RXPCU_RXBUF_DATA_138_MSB                                               31
#define RXPCU_RXBUF_DATA_138_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_138_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_138_MASK) >> RXPCU_RXBUF_DATA_138_LSB)
#define RXPCU_RXBUF_DATA_138_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_138_LSB) & RXPCU_RXBUF_DATA_138_MASK)
#define RXPCU_RXBUF_DATA_138_RESET                                             0x0
#define RXPCU_RXBUF_138_ADDRESS                                                (0x1228 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_138_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_138_RESET                                                  0x0

// 0x122c (RXPCU_RXBUF_139)
#define RXPCU_RXBUF_DATA_139_LSB                                               0
#define RXPCU_RXBUF_DATA_139_MSB                                               31
#define RXPCU_RXBUF_DATA_139_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_139_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_139_MASK) >> RXPCU_RXBUF_DATA_139_LSB)
#define RXPCU_RXBUF_DATA_139_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_139_LSB) & RXPCU_RXBUF_DATA_139_MASK)
#define RXPCU_RXBUF_DATA_139_RESET                                             0x0
#define RXPCU_RXBUF_139_ADDRESS                                                (0x122c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_139_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_139_RESET                                                  0x0

// 0x1230 (RXPCU_RXBUF_140)
#define RXPCU_RXBUF_DATA_140_LSB                                               0
#define RXPCU_RXBUF_DATA_140_MSB                                               31
#define RXPCU_RXBUF_DATA_140_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_140_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_140_MASK) >> RXPCU_RXBUF_DATA_140_LSB)
#define RXPCU_RXBUF_DATA_140_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_140_LSB) & RXPCU_RXBUF_DATA_140_MASK)
#define RXPCU_RXBUF_DATA_140_RESET                                             0x0
#define RXPCU_RXBUF_140_ADDRESS                                                (0x1230 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_140_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_140_RESET                                                  0x0

// 0x1234 (RXPCU_RXBUF_141)
#define RXPCU_RXBUF_DATA_141_LSB                                               0
#define RXPCU_RXBUF_DATA_141_MSB                                               31
#define RXPCU_RXBUF_DATA_141_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_141_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_141_MASK) >> RXPCU_RXBUF_DATA_141_LSB)
#define RXPCU_RXBUF_DATA_141_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_141_LSB) & RXPCU_RXBUF_DATA_141_MASK)
#define RXPCU_RXBUF_DATA_141_RESET                                             0x0
#define RXPCU_RXBUF_141_ADDRESS                                                (0x1234 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_141_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_141_RESET                                                  0x0

// 0x1238 (RXPCU_RXBUF_142)
#define RXPCU_RXBUF_DATA_142_LSB                                               0
#define RXPCU_RXBUF_DATA_142_MSB                                               31
#define RXPCU_RXBUF_DATA_142_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_142_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_142_MASK) >> RXPCU_RXBUF_DATA_142_LSB)
#define RXPCU_RXBUF_DATA_142_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_142_LSB) & RXPCU_RXBUF_DATA_142_MASK)
#define RXPCU_RXBUF_DATA_142_RESET                                             0x0
#define RXPCU_RXBUF_142_ADDRESS                                                (0x1238 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_142_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_142_RESET                                                  0x0

// 0x123c (RXPCU_RXBUF_143)
#define RXPCU_RXBUF_DATA_143_LSB                                               0
#define RXPCU_RXBUF_DATA_143_MSB                                               31
#define RXPCU_RXBUF_DATA_143_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_143_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_143_MASK) >> RXPCU_RXBUF_DATA_143_LSB)
#define RXPCU_RXBUF_DATA_143_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_143_LSB) & RXPCU_RXBUF_DATA_143_MASK)
#define RXPCU_RXBUF_DATA_143_RESET                                             0x0
#define RXPCU_RXBUF_143_ADDRESS                                                (0x123c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_143_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_143_RESET                                                  0x0

// 0x1240 (RXPCU_RXBUF_144)
#define RXPCU_RXBUF_DATA_144_LSB                                               0
#define RXPCU_RXBUF_DATA_144_MSB                                               31
#define RXPCU_RXBUF_DATA_144_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_144_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_144_MASK) >> RXPCU_RXBUF_DATA_144_LSB)
#define RXPCU_RXBUF_DATA_144_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_144_LSB) & RXPCU_RXBUF_DATA_144_MASK)
#define RXPCU_RXBUF_DATA_144_RESET                                             0x0
#define RXPCU_RXBUF_144_ADDRESS                                                (0x1240 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_144_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_144_RESET                                                  0x0

// 0x1244 (RXPCU_RXBUF_145)
#define RXPCU_RXBUF_DATA_145_LSB                                               0
#define RXPCU_RXBUF_DATA_145_MSB                                               31
#define RXPCU_RXBUF_DATA_145_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_145_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_145_MASK) >> RXPCU_RXBUF_DATA_145_LSB)
#define RXPCU_RXBUF_DATA_145_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_145_LSB) & RXPCU_RXBUF_DATA_145_MASK)
#define RXPCU_RXBUF_DATA_145_RESET                                             0x0
#define RXPCU_RXBUF_145_ADDRESS                                                (0x1244 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_145_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_145_RESET                                                  0x0

// 0x1248 (RXPCU_RXBUF_146)
#define RXPCU_RXBUF_DATA_146_LSB                                               0
#define RXPCU_RXBUF_DATA_146_MSB                                               31
#define RXPCU_RXBUF_DATA_146_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_146_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_146_MASK) >> RXPCU_RXBUF_DATA_146_LSB)
#define RXPCU_RXBUF_DATA_146_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_146_LSB) & RXPCU_RXBUF_DATA_146_MASK)
#define RXPCU_RXBUF_DATA_146_RESET                                             0x0
#define RXPCU_RXBUF_146_ADDRESS                                                (0x1248 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_146_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_146_RESET                                                  0x0

// 0x124c (RXPCU_RXBUF_147)
#define RXPCU_RXBUF_DATA_147_LSB                                               0
#define RXPCU_RXBUF_DATA_147_MSB                                               31
#define RXPCU_RXBUF_DATA_147_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_147_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_147_MASK) >> RXPCU_RXBUF_DATA_147_LSB)
#define RXPCU_RXBUF_DATA_147_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_147_LSB) & RXPCU_RXBUF_DATA_147_MASK)
#define RXPCU_RXBUF_DATA_147_RESET                                             0x0
#define RXPCU_RXBUF_147_ADDRESS                                                (0x124c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_147_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_147_RESET                                                  0x0

// 0x1250 (RXPCU_RXBUF_148)
#define RXPCU_RXBUF_DATA_148_LSB                                               0
#define RXPCU_RXBUF_DATA_148_MSB                                               31
#define RXPCU_RXBUF_DATA_148_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_148_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_148_MASK) >> RXPCU_RXBUF_DATA_148_LSB)
#define RXPCU_RXBUF_DATA_148_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_148_LSB) & RXPCU_RXBUF_DATA_148_MASK)
#define RXPCU_RXBUF_DATA_148_RESET                                             0x0
#define RXPCU_RXBUF_148_ADDRESS                                                (0x1250 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_148_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_148_RESET                                                  0x0

// 0x1254 (RXPCU_RXBUF_149)
#define RXPCU_RXBUF_DATA_149_LSB                                               0
#define RXPCU_RXBUF_DATA_149_MSB                                               31
#define RXPCU_RXBUF_DATA_149_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_149_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_149_MASK) >> RXPCU_RXBUF_DATA_149_LSB)
#define RXPCU_RXBUF_DATA_149_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_149_LSB) & RXPCU_RXBUF_DATA_149_MASK)
#define RXPCU_RXBUF_DATA_149_RESET                                             0x0
#define RXPCU_RXBUF_149_ADDRESS                                                (0x1254 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_149_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_149_RESET                                                  0x0

// 0x1258 (RXPCU_RXBUF_150)
#define RXPCU_RXBUF_DATA_150_LSB                                               0
#define RXPCU_RXBUF_DATA_150_MSB                                               31
#define RXPCU_RXBUF_DATA_150_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_150_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_150_MASK) >> RXPCU_RXBUF_DATA_150_LSB)
#define RXPCU_RXBUF_DATA_150_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_150_LSB) & RXPCU_RXBUF_DATA_150_MASK)
#define RXPCU_RXBUF_DATA_150_RESET                                             0x0
#define RXPCU_RXBUF_150_ADDRESS                                                (0x1258 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_150_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_150_RESET                                                  0x0

// 0x125c (RXPCU_RXBUF_151)
#define RXPCU_RXBUF_DATA_151_LSB                                               0
#define RXPCU_RXBUF_DATA_151_MSB                                               31
#define RXPCU_RXBUF_DATA_151_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_151_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_151_MASK) >> RXPCU_RXBUF_DATA_151_LSB)
#define RXPCU_RXBUF_DATA_151_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_151_LSB) & RXPCU_RXBUF_DATA_151_MASK)
#define RXPCU_RXBUF_DATA_151_RESET                                             0x0
#define RXPCU_RXBUF_151_ADDRESS                                                (0x125c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_151_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_151_RESET                                                  0x0

// 0x1260 (RXPCU_RXBUF_152)
#define RXPCU_RXBUF_DATA_152_LSB                                               0
#define RXPCU_RXBUF_DATA_152_MSB                                               31
#define RXPCU_RXBUF_DATA_152_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_152_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_152_MASK) >> RXPCU_RXBUF_DATA_152_LSB)
#define RXPCU_RXBUF_DATA_152_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_152_LSB) & RXPCU_RXBUF_DATA_152_MASK)
#define RXPCU_RXBUF_DATA_152_RESET                                             0x0
#define RXPCU_RXBUF_152_ADDRESS                                                (0x1260 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_152_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_152_RESET                                                  0x0

// 0x1264 (RXPCU_RXBUF_153)
#define RXPCU_RXBUF_DATA_153_LSB                                               0
#define RXPCU_RXBUF_DATA_153_MSB                                               31
#define RXPCU_RXBUF_DATA_153_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_153_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_153_MASK) >> RXPCU_RXBUF_DATA_153_LSB)
#define RXPCU_RXBUF_DATA_153_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_153_LSB) & RXPCU_RXBUF_DATA_153_MASK)
#define RXPCU_RXBUF_DATA_153_RESET                                             0x0
#define RXPCU_RXBUF_153_ADDRESS                                                (0x1264 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_153_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_153_RESET                                                  0x0

// 0x1268 (RXPCU_RXBUF_154)
#define RXPCU_RXBUF_DATA_154_LSB                                               0
#define RXPCU_RXBUF_DATA_154_MSB                                               31
#define RXPCU_RXBUF_DATA_154_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_154_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_154_MASK) >> RXPCU_RXBUF_DATA_154_LSB)
#define RXPCU_RXBUF_DATA_154_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_154_LSB) & RXPCU_RXBUF_DATA_154_MASK)
#define RXPCU_RXBUF_DATA_154_RESET                                             0x0
#define RXPCU_RXBUF_154_ADDRESS                                                (0x1268 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_154_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_154_RESET                                                  0x0

// 0x126c (RXPCU_RXBUF_155)
#define RXPCU_RXBUF_DATA_155_LSB                                               0
#define RXPCU_RXBUF_DATA_155_MSB                                               31
#define RXPCU_RXBUF_DATA_155_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_155_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_155_MASK) >> RXPCU_RXBUF_DATA_155_LSB)
#define RXPCU_RXBUF_DATA_155_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_155_LSB) & RXPCU_RXBUF_DATA_155_MASK)
#define RXPCU_RXBUF_DATA_155_RESET                                             0x0
#define RXPCU_RXBUF_155_ADDRESS                                                (0x126c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_155_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_155_RESET                                                  0x0

// 0x1270 (RXPCU_RXBUF_156)
#define RXPCU_RXBUF_DATA_156_LSB                                               0
#define RXPCU_RXBUF_DATA_156_MSB                                               31
#define RXPCU_RXBUF_DATA_156_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_156_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_156_MASK) >> RXPCU_RXBUF_DATA_156_LSB)
#define RXPCU_RXBUF_DATA_156_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_156_LSB) & RXPCU_RXBUF_DATA_156_MASK)
#define RXPCU_RXBUF_DATA_156_RESET                                             0x0
#define RXPCU_RXBUF_156_ADDRESS                                                (0x1270 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_156_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_156_RESET                                                  0x0

// 0x1274 (RXPCU_RXBUF_157)
#define RXPCU_RXBUF_DATA_157_LSB                                               0
#define RXPCU_RXBUF_DATA_157_MSB                                               31
#define RXPCU_RXBUF_DATA_157_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_157_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_157_MASK) >> RXPCU_RXBUF_DATA_157_LSB)
#define RXPCU_RXBUF_DATA_157_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_157_LSB) & RXPCU_RXBUF_DATA_157_MASK)
#define RXPCU_RXBUF_DATA_157_RESET                                             0x0
#define RXPCU_RXBUF_157_ADDRESS                                                (0x1274 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_157_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_157_RESET                                                  0x0

// 0x1278 (RXPCU_RXBUF_158)
#define RXPCU_RXBUF_DATA_158_LSB                                               0
#define RXPCU_RXBUF_DATA_158_MSB                                               31
#define RXPCU_RXBUF_DATA_158_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_158_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_158_MASK) >> RXPCU_RXBUF_DATA_158_LSB)
#define RXPCU_RXBUF_DATA_158_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_158_LSB) & RXPCU_RXBUF_DATA_158_MASK)
#define RXPCU_RXBUF_DATA_158_RESET                                             0x0
#define RXPCU_RXBUF_158_ADDRESS                                                (0x1278 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_158_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_158_RESET                                                  0x0

// 0x127c (RXPCU_RXBUF_159)
#define RXPCU_RXBUF_DATA_159_LSB                                               0
#define RXPCU_RXBUF_DATA_159_MSB                                               31
#define RXPCU_RXBUF_DATA_159_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_159_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_159_MASK) >> RXPCU_RXBUF_DATA_159_LSB)
#define RXPCU_RXBUF_DATA_159_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_159_LSB) & RXPCU_RXBUF_DATA_159_MASK)
#define RXPCU_RXBUF_DATA_159_RESET                                             0x0
#define RXPCU_RXBUF_159_ADDRESS                                                (0x127c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_159_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_159_RESET                                                  0x0

// 0x1280 (RXPCU_RXBUF_160)
#define RXPCU_RXBUF_DATA_160_LSB                                               0
#define RXPCU_RXBUF_DATA_160_MSB                                               31
#define RXPCU_RXBUF_DATA_160_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_160_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_160_MASK) >> RXPCU_RXBUF_DATA_160_LSB)
#define RXPCU_RXBUF_DATA_160_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_160_LSB) & RXPCU_RXBUF_DATA_160_MASK)
#define RXPCU_RXBUF_DATA_160_RESET                                             0x0
#define RXPCU_RXBUF_160_ADDRESS                                                (0x1280 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_160_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_160_RESET                                                  0x0

// 0x1284 (RXPCU_RXBUF_161)
#define RXPCU_RXBUF_DATA_161_LSB                                               0
#define RXPCU_RXBUF_DATA_161_MSB                                               31
#define RXPCU_RXBUF_DATA_161_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_161_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_161_MASK) >> RXPCU_RXBUF_DATA_161_LSB)
#define RXPCU_RXBUF_DATA_161_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_161_LSB) & RXPCU_RXBUF_DATA_161_MASK)
#define RXPCU_RXBUF_DATA_161_RESET                                             0x0
#define RXPCU_RXBUF_161_ADDRESS                                                (0x1284 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_161_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_161_RESET                                                  0x0

// 0x1288 (RXPCU_RXBUF_162)
#define RXPCU_RXBUF_DATA_162_LSB                                               0
#define RXPCU_RXBUF_DATA_162_MSB                                               31
#define RXPCU_RXBUF_DATA_162_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_162_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_162_MASK) >> RXPCU_RXBUF_DATA_162_LSB)
#define RXPCU_RXBUF_DATA_162_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_162_LSB) & RXPCU_RXBUF_DATA_162_MASK)
#define RXPCU_RXBUF_DATA_162_RESET                                             0x0
#define RXPCU_RXBUF_162_ADDRESS                                                (0x1288 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_162_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_162_RESET                                                  0x0

// 0x128c (RXPCU_RXBUF_163)
#define RXPCU_RXBUF_DATA_163_LSB                                               0
#define RXPCU_RXBUF_DATA_163_MSB                                               31
#define RXPCU_RXBUF_DATA_163_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_163_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_163_MASK) >> RXPCU_RXBUF_DATA_163_LSB)
#define RXPCU_RXBUF_DATA_163_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_163_LSB) & RXPCU_RXBUF_DATA_163_MASK)
#define RXPCU_RXBUF_DATA_163_RESET                                             0x0
#define RXPCU_RXBUF_163_ADDRESS                                                (0x128c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_163_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_163_RESET                                                  0x0

// 0x1290 (RXPCU_RXBUF_164)
#define RXPCU_RXBUF_DATA_164_LSB                                               0
#define RXPCU_RXBUF_DATA_164_MSB                                               31
#define RXPCU_RXBUF_DATA_164_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_164_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_164_MASK) >> RXPCU_RXBUF_DATA_164_LSB)
#define RXPCU_RXBUF_DATA_164_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_164_LSB) & RXPCU_RXBUF_DATA_164_MASK)
#define RXPCU_RXBUF_DATA_164_RESET                                             0x0
#define RXPCU_RXBUF_164_ADDRESS                                                (0x1290 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_164_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_164_RESET                                                  0x0

// 0x1294 (RXPCU_RXBUF_165)
#define RXPCU_RXBUF_DATA_165_LSB                                               0
#define RXPCU_RXBUF_DATA_165_MSB                                               31
#define RXPCU_RXBUF_DATA_165_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_165_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_165_MASK) >> RXPCU_RXBUF_DATA_165_LSB)
#define RXPCU_RXBUF_DATA_165_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_165_LSB) & RXPCU_RXBUF_DATA_165_MASK)
#define RXPCU_RXBUF_DATA_165_RESET                                             0x0
#define RXPCU_RXBUF_165_ADDRESS                                                (0x1294 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_165_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_165_RESET                                                  0x0

// 0x1298 (RXPCU_RXBUF_166)
#define RXPCU_RXBUF_DATA_166_LSB                                               0
#define RXPCU_RXBUF_DATA_166_MSB                                               31
#define RXPCU_RXBUF_DATA_166_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_166_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_166_MASK) >> RXPCU_RXBUF_DATA_166_LSB)
#define RXPCU_RXBUF_DATA_166_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_166_LSB) & RXPCU_RXBUF_DATA_166_MASK)
#define RXPCU_RXBUF_DATA_166_RESET                                             0x0
#define RXPCU_RXBUF_166_ADDRESS                                                (0x1298 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_166_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_166_RESET                                                  0x0

// 0x129c (RXPCU_RXBUF_167)
#define RXPCU_RXBUF_DATA_167_LSB                                               0
#define RXPCU_RXBUF_DATA_167_MSB                                               31
#define RXPCU_RXBUF_DATA_167_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_167_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_167_MASK) >> RXPCU_RXBUF_DATA_167_LSB)
#define RXPCU_RXBUF_DATA_167_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_167_LSB) & RXPCU_RXBUF_DATA_167_MASK)
#define RXPCU_RXBUF_DATA_167_RESET                                             0x0
#define RXPCU_RXBUF_167_ADDRESS                                                (0x129c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_167_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_167_RESET                                                  0x0

// 0x12a0 (RXPCU_RXBUF_168)
#define RXPCU_RXBUF_DATA_168_LSB                                               0
#define RXPCU_RXBUF_DATA_168_MSB                                               31
#define RXPCU_RXBUF_DATA_168_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_168_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_168_MASK) >> RXPCU_RXBUF_DATA_168_LSB)
#define RXPCU_RXBUF_DATA_168_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_168_LSB) & RXPCU_RXBUF_DATA_168_MASK)
#define RXPCU_RXBUF_DATA_168_RESET                                             0x0
#define RXPCU_RXBUF_168_ADDRESS                                                (0x12a0 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_168_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_168_RESET                                                  0x0

// 0x12a4 (RXPCU_RXBUF_169)
#define RXPCU_RXBUF_DATA_169_LSB                                               0
#define RXPCU_RXBUF_DATA_169_MSB                                               31
#define RXPCU_RXBUF_DATA_169_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_169_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_169_MASK) >> RXPCU_RXBUF_DATA_169_LSB)
#define RXPCU_RXBUF_DATA_169_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_169_LSB) & RXPCU_RXBUF_DATA_169_MASK)
#define RXPCU_RXBUF_DATA_169_RESET                                             0x0
#define RXPCU_RXBUF_169_ADDRESS                                                (0x12a4 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_169_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_169_RESET                                                  0x0

// 0x12a8 (RXPCU_RXBUF_170)
#define RXPCU_RXBUF_DATA_170_LSB                                               0
#define RXPCU_RXBUF_DATA_170_MSB                                               31
#define RXPCU_RXBUF_DATA_170_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_170_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_170_MASK) >> RXPCU_RXBUF_DATA_170_LSB)
#define RXPCU_RXBUF_DATA_170_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_170_LSB) & RXPCU_RXBUF_DATA_170_MASK)
#define RXPCU_RXBUF_DATA_170_RESET                                             0x0
#define RXPCU_RXBUF_170_ADDRESS                                                (0x12a8 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_170_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_170_RESET                                                  0x0

// 0x12ac (RXPCU_RXBUF_171)
#define RXPCU_RXBUF_DATA_171_LSB                                               0
#define RXPCU_RXBUF_DATA_171_MSB                                               31
#define RXPCU_RXBUF_DATA_171_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_171_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_171_MASK) >> RXPCU_RXBUF_DATA_171_LSB)
#define RXPCU_RXBUF_DATA_171_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_171_LSB) & RXPCU_RXBUF_DATA_171_MASK)
#define RXPCU_RXBUF_DATA_171_RESET                                             0x0
#define RXPCU_RXBUF_171_ADDRESS                                                (0x12ac + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_171_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_171_RESET                                                  0x0

// 0x12b0 (RXPCU_RXBUF_172)
#define RXPCU_RXBUF_DATA_172_LSB                                               0
#define RXPCU_RXBUF_DATA_172_MSB                                               31
#define RXPCU_RXBUF_DATA_172_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_172_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_172_MASK) >> RXPCU_RXBUF_DATA_172_LSB)
#define RXPCU_RXBUF_DATA_172_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_172_LSB) & RXPCU_RXBUF_DATA_172_MASK)
#define RXPCU_RXBUF_DATA_172_RESET                                             0x0
#define RXPCU_RXBUF_172_ADDRESS                                                (0x12b0 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_172_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_172_RESET                                                  0x0

// 0x12b4 (RXPCU_RXBUF_173)
#define RXPCU_RXBUF_DATA_173_LSB                                               0
#define RXPCU_RXBUF_DATA_173_MSB                                               31
#define RXPCU_RXBUF_DATA_173_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_173_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_173_MASK) >> RXPCU_RXBUF_DATA_173_LSB)
#define RXPCU_RXBUF_DATA_173_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_173_LSB) & RXPCU_RXBUF_DATA_173_MASK)
#define RXPCU_RXBUF_DATA_173_RESET                                             0x0
#define RXPCU_RXBUF_173_ADDRESS                                                (0x12b4 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_173_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_173_RESET                                                  0x0

// 0x12b8 (RXPCU_RXBUF_174)
#define RXPCU_RXBUF_DATA_174_LSB                                               0
#define RXPCU_RXBUF_DATA_174_MSB                                               31
#define RXPCU_RXBUF_DATA_174_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_174_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_174_MASK) >> RXPCU_RXBUF_DATA_174_LSB)
#define RXPCU_RXBUF_DATA_174_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_174_LSB) & RXPCU_RXBUF_DATA_174_MASK)
#define RXPCU_RXBUF_DATA_174_RESET                                             0x0
#define RXPCU_RXBUF_174_ADDRESS                                                (0x12b8 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_174_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_174_RESET                                                  0x0

// 0x12bc (RXPCU_RXBUF_175)
#define RXPCU_RXBUF_DATA_175_LSB                                               0
#define RXPCU_RXBUF_DATA_175_MSB                                               31
#define RXPCU_RXBUF_DATA_175_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_175_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_175_MASK) >> RXPCU_RXBUF_DATA_175_LSB)
#define RXPCU_RXBUF_DATA_175_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_175_LSB) & RXPCU_RXBUF_DATA_175_MASK)
#define RXPCU_RXBUF_DATA_175_RESET                                             0x0
#define RXPCU_RXBUF_175_ADDRESS                                                (0x12bc + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_175_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_175_RESET                                                  0x0

// 0x12c0 (RXPCU_RXBUF_176)
#define RXPCU_RXBUF_DATA_176_LSB                                               0
#define RXPCU_RXBUF_DATA_176_MSB                                               31
#define RXPCU_RXBUF_DATA_176_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_176_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_176_MASK) >> RXPCU_RXBUF_DATA_176_LSB)
#define RXPCU_RXBUF_DATA_176_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_176_LSB) & RXPCU_RXBUF_DATA_176_MASK)
#define RXPCU_RXBUF_DATA_176_RESET                                             0x0
#define RXPCU_RXBUF_176_ADDRESS                                                (0x12c0 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_176_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_176_RESET                                                  0x0

// 0x12c4 (RXPCU_RXBUF_177)
#define RXPCU_RXBUF_DATA_177_LSB                                               0
#define RXPCU_RXBUF_DATA_177_MSB                                               31
#define RXPCU_RXBUF_DATA_177_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_177_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_177_MASK) >> RXPCU_RXBUF_DATA_177_LSB)
#define RXPCU_RXBUF_DATA_177_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_177_LSB) & RXPCU_RXBUF_DATA_177_MASK)
#define RXPCU_RXBUF_DATA_177_RESET                                             0x0
#define RXPCU_RXBUF_177_ADDRESS                                                (0x12c4 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_177_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_177_RESET                                                  0x0

// 0x12c8 (RXPCU_RXBUF_178)
#define RXPCU_RXBUF_DATA_178_LSB                                               0
#define RXPCU_RXBUF_DATA_178_MSB                                               31
#define RXPCU_RXBUF_DATA_178_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_178_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_178_MASK) >> RXPCU_RXBUF_DATA_178_LSB)
#define RXPCU_RXBUF_DATA_178_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_178_LSB) & RXPCU_RXBUF_DATA_178_MASK)
#define RXPCU_RXBUF_DATA_178_RESET                                             0x0
#define RXPCU_RXBUF_178_ADDRESS                                                (0x12c8 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_178_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_178_RESET                                                  0x0

// 0x12cc (RXPCU_RXBUF_179)
#define RXPCU_RXBUF_DATA_179_LSB                                               0
#define RXPCU_RXBUF_DATA_179_MSB                                               31
#define RXPCU_RXBUF_DATA_179_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_179_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_179_MASK) >> RXPCU_RXBUF_DATA_179_LSB)
#define RXPCU_RXBUF_DATA_179_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_179_LSB) & RXPCU_RXBUF_DATA_179_MASK)
#define RXPCU_RXBUF_DATA_179_RESET                                             0x0
#define RXPCU_RXBUF_179_ADDRESS                                                (0x12cc + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_179_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_179_RESET                                                  0x0

// 0x12d0 (RXPCU_RXBUF_180)
#define RXPCU_RXBUF_DATA_180_LSB                                               0
#define RXPCU_RXBUF_DATA_180_MSB                                               31
#define RXPCU_RXBUF_DATA_180_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_180_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_180_MASK) >> RXPCU_RXBUF_DATA_180_LSB)
#define RXPCU_RXBUF_DATA_180_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_180_LSB) & RXPCU_RXBUF_DATA_180_MASK)
#define RXPCU_RXBUF_DATA_180_RESET                                             0x0
#define RXPCU_RXBUF_180_ADDRESS                                                (0x12d0 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_180_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_180_RESET                                                  0x0

// 0x12d4 (RXPCU_RXBUF_181)
#define RXPCU_RXBUF_DATA_181_LSB                                               0
#define RXPCU_RXBUF_DATA_181_MSB                                               31
#define RXPCU_RXBUF_DATA_181_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_181_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_181_MASK) >> RXPCU_RXBUF_DATA_181_LSB)
#define RXPCU_RXBUF_DATA_181_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_181_LSB) & RXPCU_RXBUF_DATA_181_MASK)
#define RXPCU_RXBUF_DATA_181_RESET                                             0x0
#define RXPCU_RXBUF_181_ADDRESS                                                (0x12d4 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_181_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_181_RESET                                                  0x0

// 0x12d8 (RXPCU_RXBUF_182)
#define RXPCU_RXBUF_DATA_182_LSB                                               0
#define RXPCU_RXBUF_DATA_182_MSB                                               31
#define RXPCU_RXBUF_DATA_182_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_182_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_182_MASK) >> RXPCU_RXBUF_DATA_182_LSB)
#define RXPCU_RXBUF_DATA_182_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_182_LSB) & RXPCU_RXBUF_DATA_182_MASK)
#define RXPCU_RXBUF_DATA_182_RESET                                             0x0
#define RXPCU_RXBUF_182_ADDRESS                                                (0x12d8 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_182_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_182_RESET                                                  0x0

// 0x12dc (RXPCU_RXBUF_183)
#define RXPCU_RXBUF_DATA_183_LSB                                               0
#define RXPCU_RXBUF_DATA_183_MSB                                               31
#define RXPCU_RXBUF_DATA_183_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_183_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_183_MASK) >> RXPCU_RXBUF_DATA_183_LSB)
#define RXPCU_RXBUF_DATA_183_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_183_LSB) & RXPCU_RXBUF_DATA_183_MASK)
#define RXPCU_RXBUF_DATA_183_RESET                                             0x0
#define RXPCU_RXBUF_183_ADDRESS                                                (0x12dc + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_183_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_183_RESET                                                  0x0

// 0x12e0 (RXPCU_RXBUF_184)
#define RXPCU_RXBUF_DATA_184_LSB                                               0
#define RXPCU_RXBUF_DATA_184_MSB                                               31
#define RXPCU_RXBUF_DATA_184_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_184_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_184_MASK) >> RXPCU_RXBUF_DATA_184_LSB)
#define RXPCU_RXBUF_DATA_184_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_184_LSB) & RXPCU_RXBUF_DATA_184_MASK)
#define RXPCU_RXBUF_DATA_184_RESET                                             0x0
#define RXPCU_RXBUF_184_ADDRESS                                                (0x12e0 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_184_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_184_RESET                                                  0x0

// 0x12e4 (RXPCU_RXBUF_185)
#define RXPCU_RXBUF_DATA_185_LSB                                               0
#define RXPCU_RXBUF_DATA_185_MSB                                               31
#define RXPCU_RXBUF_DATA_185_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_185_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_185_MASK) >> RXPCU_RXBUF_DATA_185_LSB)
#define RXPCU_RXBUF_DATA_185_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_185_LSB) & RXPCU_RXBUF_DATA_185_MASK)
#define RXPCU_RXBUF_DATA_185_RESET                                             0x0
#define RXPCU_RXBUF_185_ADDRESS                                                (0x12e4 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_185_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_185_RESET                                                  0x0

// 0x12e8 (RXPCU_RXBUF_186)
#define RXPCU_RXBUF_DATA_186_LSB                                               0
#define RXPCU_RXBUF_DATA_186_MSB                                               31
#define RXPCU_RXBUF_DATA_186_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_186_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_186_MASK) >> RXPCU_RXBUF_DATA_186_LSB)
#define RXPCU_RXBUF_DATA_186_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_186_LSB) & RXPCU_RXBUF_DATA_186_MASK)
#define RXPCU_RXBUF_DATA_186_RESET                                             0x0
#define RXPCU_RXBUF_186_ADDRESS                                                (0x12e8 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_186_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_186_RESET                                                  0x0

// 0x12ec (RXPCU_RXBUF_187)
#define RXPCU_RXBUF_DATA_187_LSB                                               0
#define RXPCU_RXBUF_DATA_187_MSB                                               31
#define RXPCU_RXBUF_DATA_187_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_187_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_187_MASK) >> RXPCU_RXBUF_DATA_187_LSB)
#define RXPCU_RXBUF_DATA_187_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_187_LSB) & RXPCU_RXBUF_DATA_187_MASK)
#define RXPCU_RXBUF_DATA_187_RESET                                             0x0
#define RXPCU_RXBUF_187_ADDRESS                                                (0x12ec + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_187_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_187_RESET                                                  0x0

// 0x12f0 (RXPCU_RXBUF_188)
#define RXPCU_RXBUF_DATA_188_LSB                                               0
#define RXPCU_RXBUF_DATA_188_MSB                                               31
#define RXPCU_RXBUF_DATA_188_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_188_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_188_MASK) >> RXPCU_RXBUF_DATA_188_LSB)
#define RXPCU_RXBUF_DATA_188_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_188_LSB) & RXPCU_RXBUF_DATA_188_MASK)
#define RXPCU_RXBUF_DATA_188_RESET                                             0x0
#define RXPCU_RXBUF_188_ADDRESS                                                (0x12f0 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_188_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_188_RESET                                                  0x0

// 0x12f4 (RXPCU_RXBUF_189)
#define RXPCU_RXBUF_DATA_189_LSB                                               0
#define RXPCU_RXBUF_DATA_189_MSB                                               31
#define RXPCU_RXBUF_DATA_189_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_189_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_189_MASK) >> RXPCU_RXBUF_DATA_189_LSB)
#define RXPCU_RXBUF_DATA_189_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_189_LSB) & RXPCU_RXBUF_DATA_189_MASK)
#define RXPCU_RXBUF_DATA_189_RESET                                             0x0
#define RXPCU_RXBUF_189_ADDRESS                                                (0x12f4 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_189_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_189_RESET                                                  0x0

// 0x12f8 (RXPCU_RXBUF_190)
#define RXPCU_RXBUF_DATA_190_LSB                                               0
#define RXPCU_RXBUF_DATA_190_MSB                                               31
#define RXPCU_RXBUF_DATA_190_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_190_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_190_MASK) >> RXPCU_RXBUF_DATA_190_LSB)
#define RXPCU_RXBUF_DATA_190_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_190_LSB) & RXPCU_RXBUF_DATA_190_MASK)
#define RXPCU_RXBUF_DATA_190_RESET                                             0x0
#define RXPCU_RXBUF_190_ADDRESS                                                (0x12f8 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_190_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_190_RESET                                                  0x0

// 0x12fc (RXPCU_RXBUF_191)
#define RXPCU_RXBUF_DATA_191_LSB                                               0
#define RXPCU_RXBUF_DATA_191_MSB                                               31
#define RXPCU_RXBUF_DATA_191_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_191_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_191_MASK) >> RXPCU_RXBUF_DATA_191_LSB)
#define RXPCU_RXBUF_DATA_191_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_191_LSB) & RXPCU_RXBUF_DATA_191_MASK)
#define RXPCU_RXBUF_DATA_191_RESET                                             0x0
#define RXPCU_RXBUF_191_ADDRESS                                                (0x12fc + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_191_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_191_RESET                                                  0x0

// 0x1300 (RXPCU_RXBUF_192)
#define RXPCU_RXBUF_DATA_192_LSB                                               0
#define RXPCU_RXBUF_DATA_192_MSB                                               31
#define RXPCU_RXBUF_DATA_192_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_192_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_192_MASK) >> RXPCU_RXBUF_DATA_192_LSB)
#define RXPCU_RXBUF_DATA_192_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_192_LSB) & RXPCU_RXBUF_DATA_192_MASK)
#define RXPCU_RXBUF_DATA_192_RESET                                             0x0
#define RXPCU_RXBUF_192_ADDRESS                                                (0x1300 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_192_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_192_RESET                                                  0x0

// 0x1304 (RXPCU_RXBUF_193)
#define RXPCU_RXBUF_DATA_193_LSB                                               0
#define RXPCU_RXBUF_DATA_193_MSB                                               31
#define RXPCU_RXBUF_DATA_193_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_193_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_193_MASK) >> RXPCU_RXBUF_DATA_193_LSB)
#define RXPCU_RXBUF_DATA_193_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_193_LSB) & RXPCU_RXBUF_DATA_193_MASK)
#define RXPCU_RXBUF_DATA_193_RESET                                             0x0
#define RXPCU_RXBUF_193_ADDRESS                                                (0x1304 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_193_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_193_RESET                                                  0x0

// 0x1308 (RXPCU_RXBUF_194)
#define RXPCU_RXBUF_DATA_194_LSB                                               0
#define RXPCU_RXBUF_DATA_194_MSB                                               31
#define RXPCU_RXBUF_DATA_194_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_194_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_194_MASK) >> RXPCU_RXBUF_DATA_194_LSB)
#define RXPCU_RXBUF_DATA_194_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_194_LSB) & RXPCU_RXBUF_DATA_194_MASK)
#define RXPCU_RXBUF_DATA_194_RESET                                             0x0
#define RXPCU_RXBUF_194_ADDRESS                                                (0x1308 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_194_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_194_RESET                                                  0x0

// 0x130c (RXPCU_RXBUF_195)
#define RXPCU_RXBUF_DATA_195_LSB                                               0
#define RXPCU_RXBUF_DATA_195_MSB                                               31
#define RXPCU_RXBUF_DATA_195_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_195_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_195_MASK) >> RXPCU_RXBUF_DATA_195_LSB)
#define RXPCU_RXBUF_DATA_195_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_195_LSB) & RXPCU_RXBUF_DATA_195_MASK)
#define RXPCU_RXBUF_DATA_195_RESET                                             0x0
#define RXPCU_RXBUF_195_ADDRESS                                                (0x130c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_195_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_195_RESET                                                  0x0

// 0x1310 (RXPCU_RXBUF_196)
#define RXPCU_RXBUF_DATA_196_LSB                                               0
#define RXPCU_RXBUF_DATA_196_MSB                                               31
#define RXPCU_RXBUF_DATA_196_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_196_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_196_MASK) >> RXPCU_RXBUF_DATA_196_LSB)
#define RXPCU_RXBUF_DATA_196_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_196_LSB) & RXPCU_RXBUF_DATA_196_MASK)
#define RXPCU_RXBUF_DATA_196_RESET                                             0x0
#define RXPCU_RXBUF_196_ADDRESS                                                (0x1310 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_196_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_196_RESET                                                  0x0

// 0x1314 (RXPCU_RXBUF_197)
#define RXPCU_RXBUF_DATA_197_LSB                                               0
#define RXPCU_RXBUF_DATA_197_MSB                                               31
#define RXPCU_RXBUF_DATA_197_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_197_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_197_MASK) >> RXPCU_RXBUF_DATA_197_LSB)
#define RXPCU_RXBUF_DATA_197_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_197_LSB) & RXPCU_RXBUF_DATA_197_MASK)
#define RXPCU_RXBUF_DATA_197_RESET                                             0x0
#define RXPCU_RXBUF_197_ADDRESS                                                (0x1314 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_197_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_197_RESET                                                  0x0

// 0x1318 (RXPCU_RXBUF_198)
#define RXPCU_RXBUF_DATA_198_LSB                                               0
#define RXPCU_RXBUF_DATA_198_MSB                                               31
#define RXPCU_RXBUF_DATA_198_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_198_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_198_MASK) >> RXPCU_RXBUF_DATA_198_LSB)
#define RXPCU_RXBUF_DATA_198_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_198_LSB) & RXPCU_RXBUF_DATA_198_MASK)
#define RXPCU_RXBUF_DATA_198_RESET                                             0x0
#define RXPCU_RXBUF_198_ADDRESS                                                (0x1318 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_198_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_198_RESET                                                  0x0

// 0x131c (RXPCU_RXBUF_199)
#define RXPCU_RXBUF_DATA_199_LSB                                               0
#define RXPCU_RXBUF_DATA_199_MSB                                               31
#define RXPCU_RXBUF_DATA_199_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_199_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_199_MASK) >> RXPCU_RXBUF_DATA_199_LSB)
#define RXPCU_RXBUF_DATA_199_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_199_LSB) & RXPCU_RXBUF_DATA_199_MASK)
#define RXPCU_RXBUF_DATA_199_RESET                                             0x0
#define RXPCU_RXBUF_199_ADDRESS                                                (0x131c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_199_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_199_RESET                                                  0x0

// 0x1320 (RXPCU_RXBUF_200)
#define RXPCU_RXBUF_DATA_200_LSB                                               0
#define RXPCU_RXBUF_DATA_200_MSB                                               31
#define RXPCU_RXBUF_DATA_200_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_200_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_200_MASK) >> RXPCU_RXBUF_DATA_200_LSB)
#define RXPCU_RXBUF_DATA_200_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_200_LSB) & RXPCU_RXBUF_DATA_200_MASK)
#define RXPCU_RXBUF_DATA_200_RESET                                             0x0
#define RXPCU_RXBUF_200_ADDRESS                                                (0x1320 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_200_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_200_RESET                                                  0x0

// 0x1324 (RXPCU_RXBUF_201)
#define RXPCU_RXBUF_DATA_201_LSB                                               0
#define RXPCU_RXBUF_DATA_201_MSB                                               31
#define RXPCU_RXBUF_DATA_201_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_201_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_201_MASK) >> RXPCU_RXBUF_DATA_201_LSB)
#define RXPCU_RXBUF_DATA_201_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_201_LSB) & RXPCU_RXBUF_DATA_201_MASK)
#define RXPCU_RXBUF_DATA_201_RESET                                             0x0
#define RXPCU_RXBUF_201_ADDRESS                                                (0x1324 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_201_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_201_RESET                                                  0x0

// 0x1328 (RXPCU_RXBUF_202)
#define RXPCU_RXBUF_DATA_202_LSB                                               0
#define RXPCU_RXBUF_DATA_202_MSB                                               31
#define RXPCU_RXBUF_DATA_202_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_202_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_202_MASK) >> RXPCU_RXBUF_DATA_202_LSB)
#define RXPCU_RXBUF_DATA_202_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_202_LSB) & RXPCU_RXBUF_DATA_202_MASK)
#define RXPCU_RXBUF_DATA_202_RESET                                             0x0
#define RXPCU_RXBUF_202_ADDRESS                                                (0x1328 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_202_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_202_RESET                                                  0x0

// 0x132c (RXPCU_RXBUF_203)
#define RXPCU_RXBUF_DATA_203_LSB                                               0
#define RXPCU_RXBUF_DATA_203_MSB                                               31
#define RXPCU_RXBUF_DATA_203_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_203_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_203_MASK) >> RXPCU_RXBUF_DATA_203_LSB)
#define RXPCU_RXBUF_DATA_203_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_203_LSB) & RXPCU_RXBUF_DATA_203_MASK)
#define RXPCU_RXBUF_DATA_203_RESET                                             0x0
#define RXPCU_RXBUF_203_ADDRESS                                                (0x132c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_203_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_203_RESET                                                  0x0

// 0x1330 (RXPCU_RXBUF_204)
#define RXPCU_RXBUF_DATA_204_LSB                                               0
#define RXPCU_RXBUF_DATA_204_MSB                                               31
#define RXPCU_RXBUF_DATA_204_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_204_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_204_MASK) >> RXPCU_RXBUF_DATA_204_LSB)
#define RXPCU_RXBUF_DATA_204_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_204_LSB) & RXPCU_RXBUF_DATA_204_MASK)
#define RXPCU_RXBUF_DATA_204_RESET                                             0x0
#define RXPCU_RXBUF_204_ADDRESS                                                (0x1330 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_204_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_204_RESET                                                  0x0

// 0x1334 (RXPCU_RXBUF_205)
#define RXPCU_RXBUF_DATA_205_LSB                                               0
#define RXPCU_RXBUF_DATA_205_MSB                                               31
#define RXPCU_RXBUF_DATA_205_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_205_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_205_MASK) >> RXPCU_RXBUF_DATA_205_LSB)
#define RXPCU_RXBUF_DATA_205_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_205_LSB) & RXPCU_RXBUF_DATA_205_MASK)
#define RXPCU_RXBUF_DATA_205_RESET                                             0x0
#define RXPCU_RXBUF_205_ADDRESS                                                (0x1334 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_205_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_205_RESET                                                  0x0

// 0x1338 (RXPCU_RXBUF_206)
#define RXPCU_RXBUF_DATA_206_LSB                                               0
#define RXPCU_RXBUF_DATA_206_MSB                                               31
#define RXPCU_RXBUF_DATA_206_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_206_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_206_MASK) >> RXPCU_RXBUF_DATA_206_LSB)
#define RXPCU_RXBUF_DATA_206_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_206_LSB) & RXPCU_RXBUF_DATA_206_MASK)
#define RXPCU_RXBUF_DATA_206_RESET                                             0x0
#define RXPCU_RXBUF_206_ADDRESS                                                (0x1338 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_206_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_206_RESET                                                  0x0

// 0x133c (RXPCU_RXBUF_207)
#define RXPCU_RXBUF_DATA_207_LSB                                               0
#define RXPCU_RXBUF_DATA_207_MSB                                               31
#define RXPCU_RXBUF_DATA_207_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_207_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_207_MASK) >> RXPCU_RXBUF_DATA_207_LSB)
#define RXPCU_RXBUF_DATA_207_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_207_LSB) & RXPCU_RXBUF_DATA_207_MASK)
#define RXPCU_RXBUF_DATA_207_RESET                                             0x0
#define RXPCU_RXBUF_207_ADDRESS                                                (0x133c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_207_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_207_RESET                                                  0x0

// 0x1340 (RXPCU_RXBUF_208)
#define RXPCU_RXBUF_DATA_208_LSB                                               0
#define RXPCU_RXBUF_DATA_208_MSB                                               31
#define RXPCU_RXBUF_DATA_208_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_208_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_208_MASK) >> RXPCU_RXBUF_DATA_208_LSB)
#define RXPCU_RXBUF_DATA_208_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_208_LSB) & RXPCU_RXBUF_DATA_208_MASK)
#define RXPCU_RXBUF_DATA_208_RESET                                             0x0
#define RXPCU_RXBUF_208_ADDRESS                                                (0x1340 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_208_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_208_RESET                                                  0x0

// 0x1344 (RXPCU_RXBUF_209)
#define RXPCU_RXBUF_DATA_209_LSB                                               0
#define RXPCU_RXBUF_DATA_209_MSB                                               31
#define RXPCU_RXBUF_DATA_209_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_209_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_209_MASK) >> RXPCU_RXBUF_DATA_209_LSB)
#define RXPCU_RXBUF_DATA_209_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_209_LSB) & RXPCU_RXBUF_DATA_209_MASK)
#define RXPCU_RXBUF_DATA_209_RESET                                             0x0
#define RXPCU_RXBUF_209_ADDRESS                                                (0x1344 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_209_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_209_RESET                                                  0x0

// 0x1348 (RXPCU_RXBUF_210)
#define RXPCU_RXBUF_DATA_210_LSB                                               0
#define RXPCU_RXBUF_DATA_210_MSB                                               31
#define RXPCU_RXBUF_DATA_210_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_210_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_210_MASK) >> RXPCU_RXBUF_DATA_210_LSB)
#define RXPCU_RXBUF_DATA_210_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_210_LSB) & RXPCU_RXBUF_DATA_210_MASK)
#define RXPCU_RXBUF_DATA_210_RESET                                             0x0
#define RXPCU_RXBUF_210_ADDRESS                                                (0x1348 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_210_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_210_RESET                                                  0x0

// 0x134c (RXPCU_RXBUF_211)
#define RXPCU_RXBUF_DATA_211_LSB                                               0
#define RXPCU_RXBUF_DATA_211_MSB                                               31
#define RXPCU_RXBUF_DATA_211_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_211_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_211_MASK) >> RXPCU_RXBUF_DATA_211_LSB)
#define RXPCU_RXBUF_DATA_211_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_211_LSB) & RXPCU_RXBUF_DATA_211_MASK)
#define RXPCU_RXBUF_DATA_211_RESET                                             0x0
#define RXPCU_RXBUF_211_ADDRESS                                                (0x134c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_211_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_211_RESET                                                  0x0

// 0x1350 (RXPCU_RXBUF_212)
#define RXPCU_RXBUF_DATA_212_LSB                                               0
#define RXPCU_RXBUF_DATA_212_MSB                                               31
#define RXPCU_RXBUF_DATA_212_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_212_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_212_MASK) >> RXPCU_RXBUF_DATA_212_LSB)
#define RXPCU_RXBUF_DATA_212_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_212_LSB) & RXPCU_RXBUF_DATA_212_MASK)
#define RXPCU_RXBUF_DATA_212_RESET                                             0x0
#define RXPCU_RXBUF_212_ADDRESS                                                (0x1350 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_212_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_212_RESET                                                  0x0

// 0x1354 (RXPCU_RXBUF_213)
#define RXPCU_RXBUF_DATA_213_LSB                                               0
#define RXPCU_RXBUF_DATA_213_MSB                                               31
#define RXPCU_RXBUF_DATA_213_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_213_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_213_MASK) >> RXPCU_RXBUF_DATA_213_LSB)
#define RXPCU_RXBUF_DATA_213_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_213_LSB) & RXPCU_RXBUF_DATA_213_MASK)
#define RXPCU_RXBUF_DATA_213_RESET                                             0x0
#define RXPCU_RXBUF_213_ADDRESS                                                (0x1354 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_213_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_213_RESET                                                  0x0

// 0x1358 (RXPCU_RXBUF_214)
#define RXPCU_RXBUF_DATA_214_LSB                                               0
#define RXPCU_RXBUF_DATA_214_MSB                                               31
#define RXPCU_RXBUF_DATA_214_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_214_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_214_MASK) >> RXPCU_RXBUF_DATA_214_LSB)
#define RXPCU_RXBUF_DATA_214_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_214_LSB) & RXPCU_RXBUF_DATA_214_MASK)
#define RXPCU_RXBUF_DATA_214_RESET                                             0x0
#define RXPCU_RXBUF_214_ADDRESS                                                (0x1358 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_214_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_214_RESET                                                  0x0

// 0x135c (RXPCU_RXBUF_215)
#define RXPCU_RXBUF_DATA_215_LSB                                               0
#define RXPCU_RXBUF_DATA_215_MSB                                               31
#define RXPCU_RXBUF_DATA_215_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_215_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_215_MASK) >> RXPCU_RXBUF_DATA_215_LSB)
#define RXPCU_RXBUF_DATA_215_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_215_LSB) & RXPCU_RXBUF_DATA_215_MASK)
#define RXPCU_RXBUF_DATA_215_RESET                                             0x0
#define RXPCU_RXBUF_215_ADDRESS                                                (0x135c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_215_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_215_RESET                                                  0x0

// 0x1360 (RXPCU_RXBUF_216)
#define RXPCU_RXBUF_DATA_216_LSB                                               0
#define RXPCU_RXBUF_DATA_216_MSB                                               31
#define RXPCU_RXBUF_DATA_216_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_216_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_216_MASK) >> RXPCU_RXBUF_DATA_216_LSB)
#define RXPCU_RXBUF_DATA_216_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_216_LSB) & RXPCU_RXBUF_DATA_216_MASK)
#define RXPCU_RXBUF_DATA_216_RESET                                             0x0
#define RXPCU_RXBUF_216_ADDRESS                                                (0x1360 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_216_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_216_RESET                                                  0x0

// 0x1364 (RXPCU_RXBUF_217)
#define RXPCU_RXBUF_DATA_217_LSB                                               0
#define RXPCU_RXBUF_DATA_217_MSB                                               31
#define RXPCU_RXBUF_DATA_217_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_217_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_217_MASK) >> RXPCU_RXBUF_DATA_217_LSB)
#define RXPCU_RXBUF_DATA_217_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_217_LSB) & RXPCU_RXBUF_DATA_217_MASK)
#define RXPCU_RXBUF_DATA_217_RESET                                             0x0
#define RXPCU_RXBUF_217_ADDRESS                                                (0x1364 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_217_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_217_RESET                                                  0x0

// 0x1368 (RXPCU_RXBUF_218)
#define RXPCU_RXBUF_DATA_218_LSB                                               0
#define RXPCU_RXBUF_DATA_218_MSB                                               31
#define RXPCU_RXBUF_DATA_218_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_218_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_218_MASK) >> RXPCU_RXBUF_DATA_218_LSB)
#define RXPCU_RXBUF_DATA_218_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_218_LSB) & RXPCU_RXBUF_DATA_218_MASK)
#define RXPCU_RXBUF_DATA_218_RESET                                             0x0
#define RXPCU_RXBUF_218_ADDRESS                                                (0x1368 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_218_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_218_RESET                                                  0x0

// 0x136c (RXPCU_RXBUF_219)
#define RXPCU_RXBUF_DATA_219_LSB                                               0
#define RXPCU_RXBUF_DATA_219_MSB                                               31
#define RXPCU_RXBUF_DATA_219_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_219_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_219_MASK) >> RXPCU_RXBUF_DATA_219_LSB)
#define RXPCU_RXBUF_DATA_219_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_219_LSB) & RXPCU_RXBUF_DATA_219_MASK)
#define RXPCU_RXBUF_DATA_219_RESET                                             0x0
#define RXPCU_RXBUF_219_ADDRESS                                                (0x136c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_219_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_219_RESET                                                  0x0

// 0x1370 (RXPCU_RXBUF_220)
#define RXPCU_RXBUF_DATA_220_LSB                                               0
#define RXPCU_RXBUF_DATA_220_MSB                                               31
#define RXPCU_RXBUF_DATA_220_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_220_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_220_MASK) >> RXPCU_RXBUF_DATA_220_LSB)
#define RXPCU_RXBUF_DATA_220_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_220_LSB) & RXPCU_RXBUF_DATA_220_MASK)
#define RXPCU_RXBUF_DATA_220_RESET                                             0x0
#define RXPCU_RXBUF_220_ADDRESS                                                (0x1370 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_220_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_220_RESET                                                  0x0

// 0x1374 (RXPCU_RXBUF_221)
#define RXPCU_RXBUF_DATA_221_LSB                                               0
#define RXPCU_RXBUF_DATA_221_MSB                                               31
#define RXPCU_RXBUF_DATA_221_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_221_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_221_MASK) >> RXPCU_RXBUF_DATA_221_LSB)
#define RXPCU_RXBUF_DATA_221_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_221_LSB) & RXPCU_RXBUF_DATA_221_MASK)
#define RXPCU_RXBUF_DATA_221_RESET                                             0x0
#define RXPCU_RXBUF_221_ADDRESS                                                (0x1374 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_221_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_221_RESET                                                  0x0

// 0x1378 (RXPCU_RXBUF_222)
#define RXPCU_RXBUF_DATA_222_LSB                                               0
#define RXPCU_RXBUF_DATA_222_MSB                                               31
#define RXPCU_RXBUF_DATA_222_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_222_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_222_MASK) >> RXPCU_RXBUF_DATA_222_LSB)
#define RXPCU_RXBUF_DATA_222_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_222_LSB) & RXPCU_RXBUF_DATA_222_MASK)
#define RXPCU_RXBUF_DATA_222_RESET                                             0x0
#define RXPCU_RXBUF_222_ADDRESS                                                (0x1378 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_222_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_222_RESET                                                  0x0

// 0x137c (RXPCU_RXBUF_223)
#define RXPCU_RXBUF_DATA_223_LSB                                               0
#define RXPCU_RXBUF_DATA_223_MSB                                               31
#define RXPCU_RXBUF_DATA_223_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_223_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_223_MASK) >> RXPCU_RXBUF_DATA_223_LSB)
#define RXPCU_RXBUF_DATA_223_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_223_LSB) & RXPCU_RXBUF_DATA_223_MASK)
#define RXPCU_RXBUF_DATA_223_RESET                                             0x0
#define RXPCU_RXBUF_223_ADDRESS                                                (0x137c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_223_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_223_RESET                                                  0x0

// 0x1380 (RXPCU_RXBUF_224)
#define RXPCU_RXBUF_DATA_224_LSB                                               0
#define RXPCU_RXBUF_DATA_224_MSB                                               31
#define RXPCU_RXBUF_DATA_224_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_224_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_224_MASK) >> RXPCU_RXBUF_DATA_224_LSB)
#define RXPCU_RXBUF_DATA_224_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_224_LSB) & RXPCU_RXBUF_DATA_224_MASK)
#define RXPCU_RXBUF_DATA_224_RESET                                             0x0
#define RXPCU_RXBUF_224_ADDRESS                                                (0x1380 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_224_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_224_RESET                                                  0x0

// 0x1384 (RXPCU_RXBUF_225)
#define RXPCU_RXBUF_DATA_225_LSB                                               0
#define RXPCU_RXBUF_DATA_225_MSB                                               31
#define RXPCU_RXBUF_DATA_225_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_225_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_225_MASK) >> RXPCU_RXBUF_DATA_225_LSB)
#define RXPCU_RXBUF_DATA_225_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_225_LSB) & RXPCU_RXBUF_DATA_225_MASK)
#define RXPCU_RXBUF_DATA_225_RESET                                             0x0
#define RXPCU_RXBUF_225_ADDRESS                                                (0x1384 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_225_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_225_RESET                                                  0x0

// 0x1388 (RXPCU_RXBUF_226)
#define RXPCU_RXBUF_DATA_226_LSB                                               0
#define RXPCU_RXBUF_DATA_226_MSB                                               31
#define RXPCU_RXBUF_DATA_226_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_226_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_226_MASK) >> RXPCU_RXBUF_DATA_226_LSB)
#define RXPCU_RXBUF_DATA_226_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_226_LSB) & RXPCU_RXBUF_DATA_226_MASK)
#define RXPCU_RXBUF_DATA_226_RESET                                             0x0
#define RXPCU_RXBUF_226_ADDRESS                                                (0x1388 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_226_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_226_RESET                                                  0x0

// 0x138c (RXPCU_RXBUF_227)
#define RXPCU_RXBUF_DATA_227_LSB                                               0
#define RXPCU_RXBUF_DATA_227_MSB                                               31
#define RXPCU_RXBUF_DATA_227_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_227_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_227_MASK) >> RXPCU_RXBUF_DATA_227_LSB)
#define RXPCU_RXBUF_DATA_227_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_227_LSB) & RXPCU_RXBUF_DATA_227_MASK)
#define RXPCU_RXBUF_DATA_227_RESET                                             0x0
#define RXPCU_RXBUF_227_ADDRESS                                                (0x138c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_227_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_227_RESET                                                  0x0

// 0x1390 (RXPCU_RXBUF_228)
#define RXPCU_RXBUF_DATA_228_LSB                                               0
#define RXPCU_RXBUF_DATA_228_MSB                                               31
#define RXPCU_RXBUF_DATA_228_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_228_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_228_MASK) >> RXPCU_RXBUF_DATA_228_LSB)
#define RXPCU_RXBUF_DATA_228_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_228_LSB) & RXPCU_RXBUF_DATA_228_MASK)
#define RXPCU_RXBUF_DATA_228_RESET                                             0x0
#define RXPCU_RXBUF_228_ADDRESS                                                (0x1390 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_228_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_228_RESET                                                  0x0

// 0x1394 (RXPCU_RXBUF_229)
#define RXPCU_RXBUF_DATA_229_LSB                                               0
#define RXPCU_RXBUF_DATA_229_MSB                                               31
#define RXPCU_RXBUF_DATA_229_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_229_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_229_MASK) >> RXPCU_RXBUF_DATA_229_LSB)
#define RXPCU_RXBUF_DATA_229_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_229_LSB) & RXPCU_RXBUF_DATA_229_MASK)
#define RXPCU_RXBUF_DATA_229_RESET                                             0x0
#define RXPCU_RXBUF_229_ADDRESS                                                (0x1394 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_229_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_229_RESET                                                  0x0

// 0x1398 (RXPCU_RXBUF_230)
#define RXPCU_RXBUF_DATA_230_LSB                                               0
#define RXPCU_RXBUF_DATA_230_MSB                                               31
#define RXPCU_RXBUF_DATA_230_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_230_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_230_MASK) >> RXPCU_RXBUF_DATA_230_LSB)
#define RXPCU_RXBUF_DATA_230_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_230_LSB) & RXPCU_RXBUF_DATA_230_MASK)
#define RXPCU_RXBUF_DATA_230_RESET                                             0x0
#define RXPCU_RXBUF_230_ADDRESS                                                (0x1398 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_230_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_230_RESET                                                  0x0

// 0x139c (RXPCU_RXBUF_231)
#define RXPCU_RXBUF_DATA_231_LSB                                               0
#define RXPCU_RXBUF_DATA_231_MSB                                               31
#define RXPCU_RXBUF_DATA_231_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_231_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_231_MASK) >> RXPCU_RXBUF_DATA_231_LSB)
#define RXPCU_RXBUF_DATA_231_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_231_LSB) & RXPCU_RXBUF_DATA_231_MASK)
#define RXPCU_RXBUF_DATA_231_RESET                                             0x0
#define RXPCU_RXBUF_231_ADDRESS                                                (0x139c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_231_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_231_RESET                                                  0x0

// 0x13a0 (RXPCU_RXBUF_232)
#define RXPCU_RXBUF_DATA_232_LSB                                               0
#define RXPCU_RXBUF_DATA_232_MSB                                               31
#define RXPCU_RXBUF_DATA_232_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_232_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_232_MASK) >> RXPCU_RXBUF_DATA_232_LSB)
#define RXPCU_RXBUF_DATA_232_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_232_LSB) & RXPCU_RXBUF_DATA_232_MASK)
#define RXPCU_RXBUF_DATA_232_RESET                                             0x0
#define RXPCU_RXBUF_232_ADDRESS                                                (0x13a0 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_232_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_232_RESET                                                  0x0

// 0x13a4 (RXPCU_RXBUF_233)
#define RXPCU_RXBUF_DATA_233_LSB                                               0
#define RXPCU_RXBUF_DATA_233_MSB                                               31
#define RXPCU_RXBUF_DATA_233_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_233_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_233_MASK) >> RXPCU_RXBUF_DATA_233_LSB)
#define RXPCU_RXBUF_DATA_233_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_233_LSB) & RXPCU_RXBUF_DATA_233_MASK)
#define RXPCU_RXBUF_DATA_233_RESET                                             0x0
#define RXPCU_RXBUF_233_ADDRESS                                                (0x13a4 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_233_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_233_RESET                                                  0x0

// 0x13a8 (RXPCU_RXBUF_234)
#define RXPCU_RXBUF_DATA_234_LSB                                               0
#define RXPCU_RXBUF_DATA_234_MSB                                               31
#define RXPCU_RXBUF_DATA_234_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_234_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_234_MASK) >> RXPCU_RXBUF_DATA_234_LSB)
#define RXPCU_RXBUF_DATA_234_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_234_LSB) & RXPCU_RXBUF_DATA_234_MASK)
#define RXPCU_RXBUF_DATA_234_RESET                                             0x0
#define RXPCU_RXBUF_234_ADDRESS                                                (0x13a8 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_234_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_234_RESET                                                  0x0

// 0x13ac (RXPCU_RXBUF_235)
#define RXPCU_RXBUF_DATA_235_LSB                                               0
#define RXPCU_RXBUF_DATA_235_MSB                                               31
#define RXPCU_RXBUF_DATA_235_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_235_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_235_MASK) >> RXPCU_RXBUF_DATA_235_LSB)
#define RXPCU_RXBUF_DATA_235_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_235_LSB) & RXPCU_RXBUF_DATA_235_MASK)
#define RXPCU_RXBUF_DATA_235_RESET                                             0x0
#define RXPCU_RXBUF_235_ADDRESS                                                (0x13ac + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_235_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_235_RESET                                                  0x0

// 0x13b0 (RXPCU_RXBUF_236)
#define RXPCU_RXBUF_DATA_236_LSB                                               0
#define RXPCU_RXBUF_DATA_236_MSB                                               31
#define RXPCU_RXBUF_DATA_236_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_236_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_236_MASK) >> RXPCU_RXBUF_DATA_236_LSB)
#define RXPCU_RXBUF_DATA_236_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_236_LSB) & RXPCU_RXBUF_DATA_236_MASK)
#define RXPCU_RXBUF_DATA_236_RESET                                             0x0
#define RXPCU_RXBUF_236_ADDRESS                                                (0x13b0 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_236_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_236_RESET                                                  0x0

// 0x13b4 (RXPCU_RXBUF_237)
#define RXPCU_RXBUF_DATA_237_LSB                                               0
#define RXPCU_RXBUF_DATA_237_MSB                                               31
#define RXPCU_RXBUF_DATA_237_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_237_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_237_MASK) >> RXPCU_RXBUF_DATA_237_LSB)
#define RXPCU_RXBUF_DATA_237_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_237_LSB) & RXPCU_RXBUF_DATA_237_MASK)
#define RXPCU_RXBUF_DATA_237_RESET                                             0x0
#define RXPCU_RXBUF_237_ADDRESS                                                (0x13b4 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_237_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_237_RESET                                                  0x0

// 0x13b8 (RXPCU_RXBUF_238)
#define RXPCU_RXBUF_DATA_238_LSB                                               0
#define RXPCU_RXBUF_DATA_238_MSB                                               31
#define RXPCU_RXBUF_DATA_238_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_238_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_238_MASK) >> RXPCU_RXBUF_DATA_238_LSB)
#define RXPCU_RXBUF_DATA_238_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_238_LSB) & RXPCU_RXBUF_DATA_238_MASK)
#define RXPCU_RXBUF_DATA_238_RESET                                             0x0
#define RXPCU_RXBUF_238_ADDRESS                                                (0x13b8 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_238_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_238_RESET                                                  0x0

// 0x13bc (RXPCU_RXBUF_239)
#define RXPCU_RXBUF_DATA_239_LSB                                               0
#define RXPCU_RXBUF_DATA_239_MSB                                               31
#define RXPCU_RXBUF_DATA_239_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_239_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_239_MASK) >> RXPCU_RXBUF_DATA_239_LSB)
#define RXPCU_RXBUF_DATA_239_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_239_LSB) & RXPCU_RXBUF_DATA_239_MASK)
#define RXPCU_RXBUF_DATA_239_RESET                                             0x0
#define RXPCU_RXBUF_239_ADDRESS                                                (0x13bc + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_239_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_239_RESET                                                  0x0

// 0x13c0 (RXPCU_RXBUF_240)
#define RXPCU_RXBUF_DATA_240_LSB                                               0
#define RXPCU_RXBUF_DATA_240_MSB                                               31
#define RXPCU_RXBUF_DATA_240_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_240_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_240_MASK) >> RXPCU_RXBUF_DATA_240_LSB)
#define RXPCU_RXBUF_DATA_240_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_240_LSB) & RXPCU_RXBUF_DATA_240_MASK)
#define RXPCU_RXBUF_DATA_240_RESET                                             0x0
#define RXPCU_RXBUF_240_ADDRESS                                                (0x13c0 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_240_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_240_RESET                                                  0x0

// 0x13c4 (RXPCU_RXBUF_241)
#define RXPCU_RXBUF_DATA_241_LSB                                               0
#define RXPCU_RXBUF_DATA_241_MSB                                               31
#define RXPCU_RXBUF_DATA_241_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_241_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_241_MASK) >> RXPCU_RXBUF_DATA_241_LSB)
#define RXPCU_RXBUF_DATA_241_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_241_LSB) & RXPCU_RXBUF_DATA_241_MASK)
#define RXPCU_RXBUF_DATA_241_RESET                                             0x0
#define RXPCU_RXBUF_241_ADDRESS                                                (0x13c4 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_241_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_241_RESET                                                  0x0

// 0x13c8 (RXPCU_RXBUF_242)
#define RXPCU_RXBUF_DATA_242_LSB                                               0
#define RXPCU_RXBUF_DATA_242_MSB                                               31
#define RXPCU_RXBUF_DATA_242_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_242_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_242_MASK) >> RXPCU_RXBUF_DATA_242_LSB)
#define RXPCU_RXBUF_DATA_242_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_242_LSB) & RXPCU_RXBUF_DATA_242_MASK)
#define RXPCU_RXBUF_DATA_242_RESET                                             0x0
#define RXPCU_RXBUF_242_ADDRESS                                                (0x13c8 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_242_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_242_RESET                                                  0x0

// 0x13cc (RXPCU_RXBUF_243)
#define RXPCU_RXBUF_DATA_243_LSB                                               0
#define RXPCU_RXBUF_DATA_243_MSB                                               31
#define RXPCU_RXBUF_DATA_243_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_243_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_243_MASK) >> RXPCU_RXBUF_DATA_243_LSB)
#define RXPCU_RXBUF_DATA_243_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_243_LSB) & RXPCU_RXBUF_DATA_243_MASK)
#define RXPCU_RXBUF_DATA_243_RESET                                             0x0
#define RXPCU_RXBUF_243_ADDRESS                                                (0x13cc + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_243_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_243_RESET                                                  0x0

// 0x13d0 (RXPCU_RXBUF_244)
#define RXPCU_RXBUF_DATA_244_LSB                                               0
#define RXPCU_RXBUF_DATA_244_MSB                                               31
#define RXPCU_RXBUF_DATA_244_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_244_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_244_MASK) >> RXPCU_RXBUF_DATA_244_LSB)
#define RXPCU_RXBUF_DATA_244_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_244_LSB) & RXPCU_RXBUF_DATA_244_MASK)
#define RXPCU_RXBUF_DATA_244_RESET                                             0x0
#define RXPCU_RXBUF_244_ADDRESS                                                (0x13d0 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_244_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_244_RESET                                                  0x0

// 0x13d4 (RXPCU_RXBUF_245)
#define RXPCU_RXBUF_DATA_245_LSB                                               0
#define RXPCU_RXBUF_DATA_245_MSB                                               31
#define RXPCU_RXBUF_DATA_245_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_245_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_245_MASK) >> RXPCU_RXBUF_DATA_245_LSB)
#define RXPCU_RXBUF_DATA_245_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_245_LSB) & RXPCU_RXBUF_DATA_245_MASK)
#define RXPCU_RXBUF_DATA_245_RESET                                             0x0
#define RXPCU_RXBUF_245_ADDRESS                                                (0x13d4 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_245_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_245_RESET                                                  0x0

// 0x13d8 (RXPCU_RXBUF_246)
#define RXPCU_RXBUF_DATA_246_LSB                                               0
#define RXPCU_RXBUF_DATA_246_MSB                                               31
#define RXPCU_RXBUF_DATA_246_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_246_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_246_MASK) >> RXPCU_RXBUF_DATA_246_LSB)
#define RXPCU_RXBUF_DATA_246_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_246_LSB) & RXPCU_RXBUF_DATA_246_MASK)
#define RXPCU_RXBUF_DATA_246_RESET                                             0x0
#define RXPCU_RXBUF_246_ADDRESS                                                (0x13d8 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_246_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_246_RESET                                                  0x0

// 0x13dc (RXPCU_RXBUF_247)
#define RXPCU_RXBUF_DATA_247_LSB                                               0
#define RXPCU_RXBUF_DATA_247_MSB                                               31
#define RXPCU_RXBUF_DATA_247_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_247_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_247_MASK) >> RXPCU_RXBUF_DATA_247_LSB)
#define RXPCU_RXBUF_DATA_247_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_247_LSB) & RXPCU_RXBUF_DATA_247_MASK)
#define RXPCU_RXBUF_DATA_247_RESET                                             0x0
#define RXPCU_RXBUF_247_ADDRESS                                                (0x13dc + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_247_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_247_RESET                                                  0x0

// 0x13e0 (RXPCU_RXBUF_248)
#define RXPCU_RXBUF_DATA_248_LSB                                               0
#define RXPCU_RXBUF_DATA_248_MSB                                               31
#define RXPCU_RXBUF_DATA_248_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_248_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_248_MASK) >> RXPCU_RXBUF_DATA_248_LSB)
#define RXPCU_RXBUF_DATA_248_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_248_LSB) & RXPCU_RXBUF_DATA_248_MASK)
#define RXPCU_RXBUF_DATA_248_RESET                                             0x0
#define RXPCU_RXBUF_248_ADDRESS                                                (0x13e0 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_248_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_248_RESET                                                  0x0

// 0x13e4 (RXPCU_RXBUF_249)
#define RXPCU_RXBUF_DATA_249_LSB                                               0
#define RXPCU_RXBUF_DATA_249_MSB                                               31
#define RXPCU_RXBUF_DATA_249_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_249_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_249_MASK) >> RXPCU_RXBUF_DATA_249_LSB)
#define RXPCU_RXBUF_DATA_249_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_249_LSB) & RXPCU_RXBUF_DATA_249_MASK)
#define RXPCU_RXBUF_DATA_249_RESET                                             0x0
#define RXPCU_RXBUF_249_ADDRESS                                                (0x13e4 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_249_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_249_RESET                                                  0x0

// 0x13e8 (RXPCU_RXBUF_250)
#define RXPCU_RXBUF_DATA_250_LSB                                               0
#define RXPCU_RXBUF_DATA_250_MSB                                               31
#define RXPCU_RXBUF_DATA_250_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_250_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_250_MASK) >> RXPCU_RXBUF_DATA_250_LSB)
#define RXPCU_RXBUF_DATA_250_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_250_LSB) & RXPCU_RXBUF_DATA_250_MASK)
#define RXPCU_RXBUF_DATA_250_RESET                                             0x0
#define RXPCU_RXBUF_250_ADDRESS                                                (0x13e8 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_250_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_250_RESET                                                  0x0

// 0x13ec (RXPCU_RXBUF_251)
#define RXPCU_RXBUF_DATA_251_LSB                                               0
#define RXPCU_RXBUF_DATA_251_MSB                                               31
#define RXPCU_RXBUF_DATA_251_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_251_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_251_MASK) >> RXPCU_RXBUF_DATA_251_LSB)
#define RXPCU_RXBUF_DATA_251_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_251_LSB) & RXPCU_RXBUF_DATA_251_MASK)
#define RXPCU_RXBUF_DATA_251_RESET                                             0x0
#define RXPCU_RXBUF_251_ADDRESS                                                (0x13ec + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_251_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_251_RESET                                                  0x0

// 0x13f0 (RXPCU_RXBUF_252)
#define RXPCU_RXBUF_DATA_252_LSB                                               0
#define RXPCU_RXBUF_DATA_252_MSB                                               31
#define RXPCU_RXBUF_DATA_252_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_252_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_252_MASK) >> RXPCU_RXBUF_DATA_252_LSB)
#define RXPCU_RXBUF_DATA_252_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_252_LSB) & RXPCU_RXBUF_DATA_252_MASK)
#define RXPCU_RXBUF_DATA_252_RESET                                             0x0
#define RXPCU_RXBUF_252_ADDRESS                                                (0x13f0 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_252_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_252_RESET                                                  0x0

// 0x13f4 (RXPCU_RXBUF_253)
#define RXPCU_RXBUF_DATA_253_LSB                                               0
#define RXPCU_RXBUF_DATA_253_MSB                                               31
#define RXPCU_RXBUF_DATA_253_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_253_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_253_MASK) >> RXPCU_RXBUF_DATA_253_LSB)
#define RXPCU_RXBUF_DATA_253_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_253_LSB) & RXPCU_RXBUF_DATA_253_MASK)
#define RXPCU_RXBUF_DATA_253_RESET                                             0x0
#define RXPCU_RXBUF_253_ADDRESS                                                (0x13f4 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_253_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_253_RESET                                                  0x0

// 0x13f8 (RXPCU_RXBUF_254)
#define RXPCU_RXBUF_DATA_254_LSB                                               0
#define RXPCU_RXBUF_DATA_254_MSB                                               31
#define RXPCU_RXBUF_DATA_254_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_254_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_254_MASK) >> RXPCU_RXBUF_DATA_254_LSB)
#define RXPCU_RXBUF_DATA_254_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_254_LSB) & RXPCU_RXBUF_DATA_254_MASK)
#define RXPCU_RXBUF_DATA_254_RESET                                             0x0
#define RXPCU_RXBUF_254_ADDRESS                                                (0x13f8 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_254_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_254_RESET                                                  0x0

// 0x13fc (RXPCU_RXBUF_255)
#define RXPCU_RXBUF_DATA_255_LSB                                               0
#define RXPCU_RXBUF_DATA_255_MSB                                               31
#define RXPCU_RXBUF_DATA_255_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_255_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_255_MASK) >> RXPCU_RXBUF_DATA_255_LSB)
#define RXPCU_RXBUF_DATA_255_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_255_LSB) & RXPCU_RXBUF_DATA_255_MASK)
#define RXPCU_RXBUF_DATA_255_RESET                                             0x0
#define RXPCU_RXBUF_255_ADDRESS                                                (0x13fc + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_255_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_255_RESET                                                  0x0

// 0x1400 (RXPCU_RXBUF_256)
#define RXPCU_RXBUF_DATA_256_LSB                                               0
#define RXPCU_RXBUF_DATA_256_MSB                                               31
#define RXPCU_RXBUF_DATA_256_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_256_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_256_MASK) >> RXPCU_RXBUF_DATA_256_LSB)
#define RXPCU_RXBUF_DATA_256_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_256_LSB) & RXPCU_RXBUF_DATA_256_MASK)
#define RXPCU_RXBUF_DATA_256_RESET                                             0x0
#define RXPCU_RXBUF_256_ADDRESS                                                (0x1400 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_256_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_256_RESET                                                  0x0

// 0x1404 (RXPCU_RXBUF_257)
#define RXPCU_RXBUF_DATA_257_LSB                                               0
#define RXPCU_RXBUF_DATA_257_MSB                                               31
#define RXPCU_RXBUF_DATA_257_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_257_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_257_MASK) >> RXPCU_RXBUF_DATA_257_LSB)
#define RXPCU_RXBUF_DATA_257_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_257_LSB) & RXPCU_RXBUF_DATA_257_MASK)
#define RXPCU_RXBUF_DATA_257_RESET                                             0x0
#define RXPCU_RXBUF_257_ADDRESS                                                (0x1404 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_257_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_257_RESET                                                  0x0

// 0x1408 (RXPCU_RXBUF_258)
#define RXPCU_RXBUF_DATA_258_LSB                                               0
#define RXPCU_RXBUF_DATA_258_MSB                                               31
#define RXPCU_RXBUF_DATA_258_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_258_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_258_MASK) >> RXPCU_RXBUF_DATA_258_LSB)
#define RXPCU_RXBUF_DATA_258_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_258_LSB) & RXPCU_RXBUF_DATA_258_MASK)
#define RXPCU_RXBUF_DATA_258_RESET                                             0x0
#define RXPCU_RXBUF_258_ADDRESS                                                (0x1408 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_258_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_258_RESET                                                  0x0

// 0x140c (RXPCU_RXBUF_259)
#define RXPCU_RXBUF_DATA_259_LSB                                               0
#define RXPCU_RXBUF_DATA_259_MSB                                               31
#define RXPCU_RXBUF_DATA_259_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_259_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_259_MASK) >> RXPCU_RXBUF_DATA_259_LSB)
#define RXPCU_RXBUF_DATA_259_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_259_LSB) & RXPCU_RXBUF_DATA_259_MASK)
#define RXPCU_RXBUF_DATA_259_RESET                                             0x0
#define RXPCU_RXBUF_259_ADDRESS                                                (0x140c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_259_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_259_RESET                                                  0x0

// 0x1410 (RXPCU_RXBUF_260)
#define RXPCU_RXBUF_DATA_260_LSB                                               0
#define RXPCU_RXBUF_DATA_260_MSB                                               31
#define RXPCU_RXBUF_DATA_260_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_260_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_260_MASK) >> RXPCU_RXBUF_DATA_260_LSB)
#define RXPCU_RXBUF_DATA_260_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_260_LSB) & RXPCU_RXBUF_DATA_260_MASK)
#define RXPCU_RXBUF_DATA_260_RESET                                             0x0
#define RXPCU_RXBUF_260_ADDRESS                                                (0x1410 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_260_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_260_RESET                                                  0x0

// 0x1414 (RXPCU_RXBUF_261)
#define RXPCU_RXBUF_DATA_261_LSB                                               0
#define RXPCU_RXBUF_DATA_261_MSB                                               31
#define RXPCU_RXBUF_DATA_261_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_261_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_261_MASK) >> RXPCU_RXBUF_DATA_261_LSB)
#define RXPCU_RXBUF_DATA_261_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_261_LSB) & RXPCU_RXBUF_DATA_261_MASK)
#define RXPCU_RXBUF_DATA_261_RESET                                             0x0
#define RXPCU_RXBUF_261_ADDRESS                                                (0x1414 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_261_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_261_RESET                                                  0x0

// 0x1418 (RXPCU_RXBUF_262)
#define RXPCU_RXBUF_DATA_262_LSB                                               0
#define RXPCU_RXBUF_DATA_262_MSB                                               31
#define RXPCU_RXBUF_DATA_262_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_262_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_262_MASK) >> RXPCU_RXBUF_DATA_262_LSB)
#define RXPCU_RXBUF_DATA_262_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_262_LSB) & RXPCU_RXBUF_DATA_262_MASK)
#define RXPCU_RXBUF_DATA_262_RESET                                             0x0
#define RXPCU_RXBUF_262_ADDRESS                                                (0x1418 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_262_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_262_RESET                                                  0x0

// 0x141c (RXPCU_RXBUF_263)
#define RXPCU_RXBUF_DATA_263_LSB                                               0
#define RXPCU_RXBUF_DATA_263_MSB                                               31
#define RXPCU_RXBUF_DATA_263_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_263_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_263_MASK) >> RXPCU_RXBUF_DATA_263_LSB)
#define RXPCU_RXBUF_DATA_263_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_263_LSB) & RXPCU_RXBUF_DATA_263_MASK)
#define RXPCU_RXBUF_DATA_263_RESET                                             0x0
#define RXPCU_RXBUF_263_ADDRESS                                                (0x141c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_263_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_263_RESET                                                  0x0

// 0x1420 (RXPCU_RXBUF_264)
#define RXPCU_RXBUF_DATA_264_LSB                                               0
#define RXPCU_RXBUF_DATA_264_MSB                                               31
#define RXPCU_RXBUF_DATA_264_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_264_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_264_MASK) >> RXPCU_RXBUF_DATA_264_LSB)
#define RXPCU_RXBUF_DATA_264_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_264_LSB) & RXPCU_RXBUF_DATA_264_MASK)
#define RXPCU_RXBUF_DATA_264_RESET                                             0x0
#define RXPCU_RXBUF_264_ADDRESS                                                (0x1420 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_264_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_264_RESET                                                  0x0

// 0x1424 (RXPCU_RXBUF_265)
#define RXPCU_RXBUF_DATA_265_LSB                                               0
#define RXPCU_RXBUF_DATA_265_MSB                                               31
#define RXPCU_RXBUF_DATA_265_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_265_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_265_MASK) >> RXPCU_RXBUF_DATA_265_LSB)
#define RXPCU_RXBUF_DATA_265_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_265_LSB) & RXPCU_RXBUF_DATA_265_MASK)
#define RXPCU_RXBUF_DATA_265_RESET                                             0x0
#define RXPCU_RXBUF_265_ADDRESS                                                (0x1424 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_265_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_265_RESET                                                  0x0

// 0x1428 (RXPCU_RXBUF_266)
#define RXPCU_RXBUF_DATA_266_LSB                                               0
#define RXPCU_RXBUF_DATA_266_MSB                                               31
#define RXPCU_RXBUF_DATA_266_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_266_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_266_MASK) >> RXPCU_RXBUF_DATA_266_LSB)
#define RXPCU_RXBUF_DATA_266_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_266_LSB) & RXPCU_RXBUF_DATA_266_MASK)
#define RXPCU_RXBUF_DATA_266_RESET                                             0x0
#define RXPCU_RXBUF_266_ADDRESS                                                (0x1428 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_266_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_266_RESET                                                  0x0

// 0x142c (RXPCU_RXBUF_267)
#define RXPCU_RXBUF_DATA_267_LSB                                               0
#define RXPCU_RXBUF_DATA_267_MSB                                               31
#define RXPCU_RXBUF_DATA_267_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_267_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_267_MASK) >> RXPCU_RXBUF_DATA_267_LSB)
#define RXPCU_RXBUF_DATA_267_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_267_LSB) & RXPCU_RXBUF_DATA_267_MASK)
#define RXPCU_RXBUF_DATA_267_RESET                                             0x0
#define RXPCU_RXBUF_267_ADDRESS                                                (0x142c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_267_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_267_RESET                                                  0x0

// 0x1430 (RXPCU_RXBUF_268)
#define RXPCU_RXBUF_DATA_268_LSB                                               0
#define RXPCU_RXBUF_DATA_268_MSB                                               31
#define RXPCU_RXBUF_DATA_268_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_268_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_268_MASK) >> RXPCU_RXBUF_DATA_268_LSB)
#define RXPCU_RXBUF_DATA_268_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_268_LSB) & RXPCU_RXBUF_DATA_268_MASK)
#define RXPCU_RXBUF_DATA_268_RESET                                             0x0
#define RXPCU_RXBUF_268_ADDRESS                                                (0x1430 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_268_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_268_RESET                                                  0x0

// 0x1434 (RXPCU_RXBUF_269)
#define RXPCU_RXBUF_DATA_269_LSB                                               0
#define RXPCU_RXBUF_DATA_269_MSB                                               31
#define RXPCU_RXBUF_DATA_269_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_269_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_269_MASK) >> RXPCU_RXBUF_DATA_269_LSB)
#define RXPCU_RXBUF_DATA_269_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_269_LSB) & RXPCU_RXBUF_DATA_269_MASK)
#define RXPCU_RXBUF_DATA_269_RESET                                             0x0
#define RXPCU_RXBUF_269_ADDRESS                                                (0x1434 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_269_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_269_RESET                                                  0x0

// 0x1438 (RXPCU_RXBUF_270)
#define RXPCU_RXBUF_DATA_270_LSB                                               0
#define RXPCU_RXBUF_DATA_270_MSB                                               31
#define RXPCU_RXBUF_DATA_270_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_270_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_270_MASK) >> RXPCU_RXBUF_DATA_270_LSB)
#define RXPCU_RXBUF_DATA_270_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_270_LSB) & RXPCU_RXBUF_DATA_270_MASK)
#define RXPCU_RXBUF_DATA_270_RESET                                             0x0
#define RXPCU_RXBUF_270_ADDRESS                                                (0x1438 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_270_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_270_RESET                                                  0x0

// 0x143c (RXPCU_RXBUF_271)
#define RXPCU_RXBUF_DATA_271_LSB                                               0
#define RXPCU_RXBUF_DATA_271_MSB                                               31
#define RXPCU_RXBUF_DATA_271_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_271_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_271_MASK) >> RXPCU_RXBUF_DATA_271_LSB)
#define RXPCU_RXBUF_DATA_271_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_271_LSB) & RXPCU_RXBUF_DATA_271_MASK)
#define RXPCU_RXBUF_DATA_271_RESET                                             0x0
#define RXPCU_RXBUF_271_ADDRESS                                                (0x143c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_271_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_271_RESET                                                  0x0

// 0x1440 (RXPCU_RXBUF_272)
#define RXPCU_RXBUF_DATA_272_LSB                                               0
#define RXPCU_RXBUF_DATA_272_MSB                                               31
#define RXPCU_RXBUF_DATA_272_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_272_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_272_MASK) >> RXPCU_RXBUF_DATA_272_LSB)
#define RXPCU_RXBUF_DATA_272_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_272_LSB) & RXPCU_RXBUF_DATA_272_MASK)
#define RXPCU_RXBUF_DATA_272_RESET                                             0x0
#define RXPCU_RXBUF_272_ADDRESS                                                (0x1440 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_272_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_272_RESET                                                  0x0

// 0x1444 (RXPCU_RXBUF_273)
#define RXPCU_RXBUF_DATA_273_LSB                                               0
#define RXPCU_RXBUF_DATA_273_MSB                                               31
#define RXPCU_RXBUF_DATA_273_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_273_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_273_MASK) >> RXPCU_RXBUF_DATA_273_LSB)
#define RXPCU_RXBUF_DATA_273_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_273_LSB) & RXPCU_RXBUF_DATA_273_MASK)
#define RXPCU_RXBUF_DATA_273_RESET                                             0x0
#define RXPCU_RXBUF_273_ADDRESS                                                (0x1444 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_273_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_273_RESET                                                  0x0

// 0x1448 (RXPCU_RXBUF_274)
#define RXPCU_RXBUF_DATA_274_LSB                                               0
#define RXPCU_RXBUF_DATA_274_MSB                                               31
#define RXPCU_RXBUF_DATA_274_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_274_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_274_MASK) >> RXPCU_RXBUF_DATA_274_LSB)
#define RXPCU_RXBUF_DATA_274_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_274_LSB) & RXPCU_RXBUF_DATA_274_MASK)
#define RXPCU_RXBUF_DATA_274_RESET                                             0x0
#define RXPCU_RXBUF_274_ADDRESS                                                (0x1448 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_274_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_274_RESET                                                  0x0

// 0x144c (RXPCU_RXBUF_275)
#define RXPCU_RXBUF_DATA_275_LSB                                               0
#define RXPCU_RXBUF_DATA_275_MSB                                               31
#define RXPCU_RXBUF_DATA_275_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_275_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_275_MASK) >> RXPCU_RXBUF_DATA_275_LSB)
#define RXPCU_RXBUF_DATA_275_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_275_LSB) & RXPCU_RXBUF_DATA_275_MASK)
#define RXPCU_RXBUF_DATA_275_RESET                                             0x0
#define RXPCU_RXBUF_275_ADDRESS                                                (0x144c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_275_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_275_RESET                                                  0x0

// 0x1450 (RXPCU_RXBUF_276)
#define RXPCU_RXBUF_DATA_276_LSB                                               0
#define RXPCU_RXBUF_DATA_276_MSB                                               31
#define RXPCU_RXBUF_DATA_276_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_276_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_276_MASK) >> RXPCU_RXBUF_DATA_276_LSB)
#define RXPCU_RXBUF_DATA_276_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_276_LSB) & RXPCU_RXBUF_DATA_276_MASK)
#define RXPCU_RXBUF_DATA_276_RESET                                             0x0
#define RXPCU_RXBUF_276_ADDRESS                                                (0x1450 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_276_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_276_RESET                                                  0x0

// 0x1454 (RXPCU_RXBUF_277)
#define RXPCU_RXBUF_DATA_277_LSB                                               0
#define RXPCU_RXBUF_DATA_277_MSB                                               31
#define RXPCU_RXBUF_DATA_277_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_277_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_277_MASK) >> RXPCU_RXBUF_DATA_277_LSB)
#define RXPCU_RXBUF_DATA_277_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_277_LSB) & RXPCU_RXBUF_DATA_277_MASK)
#define RXPCU_RXBUF_DATA_277_RESET                                             0x0
#define RXPCU_RXBUF_277_ADDRESS                                                (0x1454 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_277_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_277_RESET                                                  0x0

// 0x1458 (RXPCU_RXBUF_278)
#define RXPCU_RXBUF_DATA_278_LSB                                               0
#define RXPCU_RXBUF_DATA_278_MSB                                               31
#define RXPCU_RXBUF_DATA_278_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_278_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_278_MASK) >> RXPCU_RXBUF_DATA_278_LSB)
#define RXPCU_RXBUF_DATA_278_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_278_LSB) & RXPCU_RXBUF_DATA_278_MASK)
#define RXPCU_RXBUF_DATA_278_RESET                                             0x0
#define RXPCU_RXBUF_278_ADDRESS                                                (0x1458 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_278_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_278_RESET                                                  0x0

// 0x145c (RXPCU_RXBUF_279)
#define RXPCU_RXBUF_DATA_279_LSB                                               0
#define RXPCU_RXBUF_DATA_279_MSB                                               31
#define RXPCU_RXBUF_DATA_279_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_279_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_279_MASK) >> RXPCU_RXBUF_DATA_279_LSB)
#define RXPCU_RXBUF_DATA_279_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_279_LSB) & RXPCU_RXBUF_DATA_279_MASK)
#define RXPCU_RXBUF_DATA_279_RESET                                             0x0
#define RXPCU_RXBUF_279_ADDRESS                                                (0x145c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_279_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_279_RESET                                                  0x0

// 0x1460 (RXPCU_RXBUF_280)
#define RXPCU_RXBUF_DATA_280_LSB                                               0
#define RXPCU_RXBUF_DATA_280_MSB                                               31
#define RXPCU_RXBUF_DATA_280_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_280_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_280_MASK) >> RXPCU_RXBUF_DATA_280_LSB)
#define RXPCU_RXBUF_DATA_280_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_280_LSB) & RXPCU_RXBUF_DATA_280_MASK)
#define RXPCU_RXBUF_DATA_280_RESET                                             0x0
#define RXPCU_RXBUF_280_ADDRESS                                                (0x1460 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_280_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_280_RESET                                                  0x0

// 0x1464 (RXPCU_RXBUF_281)
#define RXPCU_RXBUF_DATA_281_LSB                                               0
#define RXPCU_RXBUF_DATA_281_MSB                                               31
#define RXPCU_RXBUF_DATA_281_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_281_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_281_MASK) >> RXPCU_RXBUF_DATA_281_LSB)
#define RXPCU_RXBUF_DATA_281_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_281_LSB) & RXPCU_RXBUF_DATA_281_MASK)
#define RXPCU_RXBUF_DATA_281_RESET                                             0x0
#define RXPCU_RXBUF_281_ADDRESS                                                (0x1464 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_281_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_281_RESET                                                  0x0

// 0x1468 (RXPCU_RXBUF_282)
#define RXPCU_RXBUF_DATA_282_LSB                                               0
#define RXPCU_RXBUF_DATA_282_MSB                                               31
#define RXPCU_RXBUF_DATA_282_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_282_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_282_MASK) >> RXPCU_RXBUF_DATA_282_LSB)
#define RXPCU_RXBUF_DATA_282_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_282_LSB) & RXPCU_RXBUF_DATA_282_MASK)
#define RXPCU_RXBUF_DATA_282_RESET                                             0x0
#define RXPCU_RXBUF_282_ADDRESS                                                (0x1468 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_282_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_282_RESET                                                  0x0

// 0x146c (RXPCU_RXBUF_283)
#define RXPCU_RXBUF_DATA_283_LSB                                               0
#define RXPCU_RXBUF_DATA_283_MSB                                               31
#define RXPCU_RXBUF_DATA_283_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_283_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_283_MASK) >> RXPCU_RXBUF_DATA_283_LSB)
#define RXPCU_RXBUF_DATA_283_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_283_LSB) & RXPCU_RXBUF_DATA_283_MASK)
#define RXPCU_RXBUF_DATA_283_RESET                                             0x0
#define RXPCU_RXBUF_283_ADDRESS                                                (0x146c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_283_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_283_RESET                                                  0x0

// 0x1470 (RXPCU_RXBUF_284)
#define RXPCU_RXBUF_DATA_284_LSB                                               0
#define RXPCU_RXBUF_DATA_284_MSB                                               31
#define RXPCU_RXBUF_DATA_284_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_284_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_284_MASK) >> RXPCU_RXBUF_DATA_284_LSB)
#define RXPCU_RXBUF_DATA_284_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_284_LSB) & RXPCU_RXBUF_DATA_284_MASK)
#define RXPCU_RXBUF_DATA_284_RESET                                             0x0
#define RXPCU_RXBUF_284_ADDRESS                                                (0x1470 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_284_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_284_RESET                                                  0x0

// 0x1474 (RXPCU_RXBUF_285)
#define RXPCU_RXBUF_DATA_285_LSB                                               0
#define RXPCU_RXBUF_DATA_285_MSB                                               31
#define RXPCU_RXBUF_DATA_285_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_285_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_285_MASK) >> RXPCU_RXBUF_DATA_285_LSB)
#define RXPCU_RXBUF_DATA_285_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_285_LSB) & RXPCU_RXBUF_DATA_285_MASK)
#define RXPCU_RXBUF_DATA_285_RESET                                             0x0
#define RXPCU_RXBUF_285_ADDRESS                                                (0x1474 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_285_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_285_RESET                                                  0x0

// 0x1478 (RXPCU_RXBUF_286)
#define RXPCU_RXBUF_DATA_286_LSB                                               0
#define RXPCU_RXBUF_DATA_286_MSB                                               31
#define RXPCU_RXBUF_DATA_286_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_286_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_286_MASK) >> RXPCU_RXBUF_DATA_286_LSB)
#define RXPCU_RXBUF_DATA_286_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_286_LSB) & RXPCU_RXBUF_DATA_286_MASK)
#define RXPCU_RXBUF_DATA_286_RESET                                             0x0
#define RXPCU_RXBUF_286_ADDRESS                                                (0x1478 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_286_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_286_RESET                                                  0x0

// 0x147c (RXPCU_RXBUF_287)
#define RXPCU_RXBUF_DATA_287_LSB                                               0
#define RXPCU_RXBUF_DATA_287_MSB                                               31
#define RXPCU_RXBUF_DATA_287_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_287_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_287_MASK) >> RXPCU_RXBUF_DATA_287_LSB)
#define RXPCU_RXBUF_DATA_287_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_287_LSB) & RXPCU_RXBUF_DATA_287_MASK)
#define RXPCU_RXBUF_DATA_287_RESET                                             0x0
#define RXPCU_RXBUF_287_ADDRESS                                                (0x147c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_287_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_287_RESET                                                  0x0

// 0x1480 (RXPCU_RXBUF_288)
#define RXPCU_RXBUF_DATA_288_LSB                                               0
#define RXPCU_RXBUF_DATA_288_MSB                                               31
#define RXPCU_RXBUF_DATA_288_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_288_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_288_MASK) >> RXPCU_RXBUF_DATA_288_LSB)
#define RXPCU_RXBUF_DATA_288_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_288_LSB) & RXPCU_RXBUF_DATA_288_MASK)
#define RXPCU_RXBUF_DATA_288_RESET                                             0x0
#define RXPCU_RXBUF_288_ADDRESS                                                (0x1480 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_288_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_288_RESET                                                  0x0

// 0x1484 (RXPCU_RXBUF_289)
#define RXPCU_RXBUF_DATA_289_LSB                                               0
#define RXPCU_RXBUF_DATA_289_MSB                                               31
#define RXPCU_RXBUF_DATA_289_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_289_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_289_MASK) >> RXPCU_RXBUF_DATA_289_LSB)
#define RXPCU_RXBUF_DATA_289_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_289_LSB) & RXPCU_RXBUF_DATA_289_MASK)
#define RXPCU_RXBUF_DATA_289_RESET                                             0x0
#define RXPCU_RXBUF_289_ADDRESS                                                (0x1484 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_289_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_289_RESET                                                  0x0

// 0x1488 (RXPCU_RXBUF_290)
#define RXPCU_RXBUF_DATA_290_LSB                                               0
#define RXPCU_RXBUF_DATA_290_MSB                                               31
#define RXPCU_RXBUF_DATA_290_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_290_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_290_MASK) >> RXPCU_RXBUF_DATA_290_LSB)
#define RXPCU_RXBUF_DATA_290_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_290_LSB) & RXPCU_RXBUF_DATA_290_MASK)
#define RXPCU_RXBUF_DATA_290_RESET                                             0x0
#define RXPCU_RXBUF_290_ADDRESS                                                (0x1488 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_290_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_290_RESET                                                  0x0

// 0x148c (RXPCU_RXBUF_291)
#define RXPCU_RXBUF_DATA_291_LSB                                               0
#define RXPCU_RXBUF_DATA_291_MSB                                               31
#define RXPCU_RXBUF_DATA_291_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_291_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_291_MASK) >> RXPCU_RXBUF_DATA_291_LSB)
#define RXPCU_RXBUF_DATA_291_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_291_LSB) & RXPCU_RXBUF_DATA_291_MASK)
#define RXPCU_RXBUF_DATA_291_RESET                                             0x0
#define RXPCU_RXBUF_291_ADDRESS                                                (0x148c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_291_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_291_RESET                                                  0x0

// 0x1490 (RXPCU_RXBUF_292)
#define RXPCU_RXBUF_DATA_292_LSB                                               0
#define RXPCU_RXBUF_DATA_292_MSB                                               31
#define RXPCU_RXBUF_DATA_292_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_292_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_292_MASK) >> RXPCU_RXBUF_DATA_292_LSB)
#define RXPCU_RXBUF_DATA_292_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_292_LSB) & RXPCU_RXBUF_DATA_292_MASK)
#define RXPCU_RXBUF_DATA_292_RESET                                             0x0
#define RXPCU_RXBUF_292_ADDRESS                                                (0x1490 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_292_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_292_RESET                                                  0x0

// 0x1494 (RXPCU_RXBUF_293)
#define RXPCU_RXBUF_DATA_293_LSB                                               0
#define RXPCU_RXBUF_DATA_293_MSB                                               31
#define RXPCU_RXBUF_DATA_293_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_293_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_293_MASK) >> RXPCU_RXBUF_DATA_293_LSB)
#define RXPCU_RXBUF_DATA_293_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_293_LSB) & RXPCU_RXBUF_DATA_293_MASK)
#define RXPCU_RXBUF_DATA_293_RESET                                             0x0
#define RXPCU_RXBUF_293_ADDRESS                                                (0x1494 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_293_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_293_RESET                                                  0x0

// 0x1498 (RXPCU_RXBUF_294)
#define RXPCU_RXBUF_DATA_294_LSB                                               0
#define RXPCU_RXBUF_DATA_294_MSB                                               31
#define RXPCU_RXBUF_DATA_294_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_294_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_294_MASK) >> RXPCU_RXBUF_DATA_294_LSB)
#define RXPCU_RXBUF_DATA_294_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_294_LSB) & RXPCU_RXBUF_DATA_294_MASK)
#define RXPCU_RXBUF_DATA_294_RESET                                             0x0
#define RXPCU_RXBUF_294_ADDRESS                                                (0x1498 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_294_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_294_RESET                                                  0x0

// 0x149c (RXPCU_RXBUF_295)
#define RXPCU_RXBUF_DATA_295_LSB                                               0
#define RXPCU_RXBUF_DATA_295_MSB                                               31
#define RXPCU_RXBUF_DATA_295_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_295_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_295_MASK) >> RXPCU_RXBUF_DATA_295_LSB)
#define RXPCU_RXBUF_DATA_295_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_295_LSB) & RXPCU_RXBUF_DATA_295_MASK)
#define RXPCU_RXBUF_DATA_295_RESET                                             0x0
#define RXPCU_RXBUF_295_ADDRESS                                                (0x149c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_295_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_295_RESET                                                  0x0

// 0x14a0 (RXPCU_RXBUF_296)
#define RXPCU_RXBUF_DATA_296_LSB                                               0
#define RXPCU_RXBUF_DATA_296_MSB                                               31
#define RXPCU_RXBUF_DATA_296_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_296_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_296_MASK) >> RXPCU_RXBUF_DATA_296_LSB)
#define RXPCU_RXBUF_DATA_296_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_296_LSB) & RXPCU_RXBUF_DATA_296_MASK)
#define RXPCU_RXBUF_DATA_296_RESET                                             0x0
#define RXPCU_RXBUF_296_ADDRESS                                                (0x14a0 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_296_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_296_RESET                                                  0x0

// 0x14a4 (RXPCU_RXBUF_297)
#define RXPCU_RXBUF_DATA_297_LSB                                               0
#define RXPCU_RXBUF_DATA_297_MSB                                               31
#define RXPCU_RXBUF_DATA_297_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_297_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_297_MASK) >> RXPCU_RXBUF_DATA_297_LSB)
#define RXPCU_RXBUF_DATA_297_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_297_LSB) & RXPCU_RXBUF_DATA_297_MASK)
#define RXPCU_RXBUF_DATA_297_RESET                                             0x0
#define RXPCU_RXBUF_297_ADDRESS                                                (0x14a4 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_297_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_297_RESET                                                  0x0

// 0x14a8 (RXPCU_RXBUF_298)
#define RXPCU_RXBUF_DATA_298_LSB                                               0
#define RXPCU_RXBUF_DATA_298_MSB                                               31
#define RXPCU_RXBUF_DATA_298_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_298_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_298_MASK) >> RXPCU_RXBUF_DATA_298_LSB)
#define RXPCU_RXBUF_DATA_298_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_298_LSB) & RXPCU_RXBUF_DATA_298_MASK)
#define RXPCU_RXBUF_DATA_298_RESET                                             0x0
#define RXPCU_RXBUF_298_ADDRESS                                                (0x14a8 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_298_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_298_RESET                                                  0x0

// 0x14ac (RXPCU_RXBUF_299)
#define RXPCU_RXBUF_DATA_299_LSB                                               0
#define RXPCU_RXBUF_DATA_299_MSB                                               31
#define RXPCU_RXBUF_DATA_299_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_299_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_299_MASK) >> RXPCU_RXBUF_DATA_299_LSB)
#define RXPCU_RXBUF_DATA_299_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_299_LSB) & RXPCU_RXBUF_DATA_299_MASK)
#define RXPCU_RXBUF_DATA_299_RESET                                             0x0
#define RXPCU_RXBUF_299_ADDRESS                                                (0x14ac + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_299_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_299_RESET                                                  0x0

// 0x14b0 (RXPCU_RXBUF_300)
#define RXPCU_RXBUF_DATA_300_LSB                                               0
#define RXPCU_RXBUF_DATA_300_MSB                                               31
#define RXPCU_RXBUF_DATA_300_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_300_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_300_MASK) >> RXPCU_RXBUF_DATA_300_LSB)
#define RXPCU_RXBUF_DATA_300_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_300_LSB) & RXPCU_RXBUF_DATA_300_MASK)
#define RXPCU_RXBUF_DATA_300_RESET                                             0x0
#define RXPCU_RXBUF_300_ADDRESS                                                (0x14b0 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_300_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_300_RESET                                                  0x0

// 0x14b4 (RXPCU_RXBUF_301)
#define RXPCU_RXBUF_DATA_301_LSB                                               0
#define RXPCU_RXBUF_DATA_301_MSB                                               31
#define RXPCU_RXBUF_DATA_301_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_301_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_301_MASK) >> RXPCU_RXBUF_DATA_301_LSB)
#define RXPCU_RXBUF_DATA_301_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_301_LSB) & RXPCU_RXBUF_DATA_301_MASK)
#define RXPCU_RXBUF_DATA_301_RESET                                             0x0
#define RXPCU_RXBUF_301_ADDRESS                                                (0x14b4 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_301_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_301_RESET                                                  0x0

// 0x14b8 (RXPCU_RXBUF_302)
#define RXPCU_RXBUF_DATA_302_LSB                                               0
#define RXPCU_RXBUF_DATA_302_MSB                                               31
#define RXPCU_RXBUF_DATA_302_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_302_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_302_MASK) >> RXPCU_RXBUF_DATA_302_LSB)
#define RXPCU_RXBUF_DATA_302_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_302_LSB) & RXPCU_RXBUF_DATA_302_MASK)
#define RXPCU_RXBUF_DATA_302_RESET                                             0x0
#define RXPCU_RXBUF_302_ADDRESS                                                (0x14b8 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_302_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_302_RESET                                                  0x0

// 0x14bc (RXPCU_RXBUF_303)
#define RXPCU_RXBUF_DATA_303_LSB                                               0
#define RXPCU_RXBUF_DATA_303_MSB                                               31
#define RXPCU_RXBUF_DATA_303_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_303_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_303_MASK) >> RXPCU_RXBUF_DATA_303_LSB)
#define RXPCU_RXBUF_DATA_303_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_303_LSB) & RXPCU_RXBUF_DATA_303_MASK)
#define RXPCU_RXBUF_DATA_303_RESET                                             0x0
#define RXPCU_RXBUF_303_ADDRESS                                                (0x14bc + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_303_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_303_RESET                                                  0x0

// 0x14c0 (RXPCU_RXBUF_304)
#define RXPCU_RXBUF_DATA_304_LSB                                               0
#define RXPCU_RXBUF_DATA_304_MSB                                               31
#define RXPCU_RXBUF_DATA_304_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_304_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_304_MASK) >> RXPCU_RXBUF_DATA_304_LSB)
#define RXPCU_RXBUF_DATA_304_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_304_LSB) & RXPCU_RXBUF_DATA_304_MASK)
#define RXPCU_RXBUF_DATA_304_RESET                                             0x0
#define RXPCU_RXBUF_304_ADDRESS                                                (0x14c0 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_304_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_304_RESET                                                  0x0

// 0x14c4 (RXPCU_RXBUF_305)
#define RXPCU_RXBUF_DATA_305_LSB                                               0
#define RXPCU_RXBUF_DATA_305_MSB                                               31
#define RXPCU_RXBUF_DATA_305_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_305_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_305_MASK) >> RXPCU_RXBUF_DATA_305_LSB)
#define RXPCU_RXBUF_DATA_305_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_305_LSB) & RXPCU_RXBUF_DATA_305_MASK)
#define RXPCU_RXBUF_DATA_305_RESET                                             0x0
#define RXPCU_RXBUF_305_ADDRESS                                                (0x14c4 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_305_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_305_RESET                                                  0x0

// 0x14c8 (RXPCU_RXBUF_306)
#define RXPCU_RXBUF_DATA_306_LSB                                               0
#define RXPCU_RXBUF_DATA_306_MSB                                               31
#define RXPCU_RXBUF_DATA_306_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_306_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_306_MASK) >> RXPCU_RXBUF_DATA_306_LSB)
#define RXPCU_RXBUF_DATA_306_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_306_LSB) & RXPCU_RXBUF_DATA_306_MASK)
#define RXPCU_RXBUF_DATA_306_RESET                                             0x0
#define RXPCU_RXBUF_306_ADDRESS                                                (0x14c8 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_306_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_306_RESET                                                  0x0

// 0x14cc (RXPCU_RXBUF_307)
#define RXPCU_RXBUF_DATA_307_LSB                                               0
#define RXPCU_RXBUF_DATA_307_MSB                                               31
#define RXPCU_RXBUF_DATA_307_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_307_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_307_MASK) >> RXPCU_RXBUF_DATA_307_LSB)
#define RXPCU_RXBUF_DATA_307_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_307_LSB) & RXPCU_RXBUF_DATA_307_MASK)
#define RXPCU_RXBUF_DATA_307_RESET                                             0x0
#define RXPCU_RXBUF_307_ADDRESS                                                (0x14cc + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_307_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_307_RESET                                                  0x0

// 0x14d0 (RXPCU_RXBUF_308)
#define RXPCU_RXBUF_DATA_308_LSB                                               0
#define RXPCU_RXBUF_DATA_308_MSB                                               31
#define RXPCU_RXBUF_DATA_308_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_308_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_308_MASK) >> RXPCU_RXBUF_DATA_308_LSB)
#define RXPCU_RXBUF_DATA_308_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_308_LSB) & RXPCU_RXBUF_DATA_308_MASK)
#define RXPCU_RXBUF_DATA_308_RESET                                             0x0
#define RXPCU_RXBUF_308_ADDRESS                                                (0x14d0 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_308_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_308_RESET                                                  0x0

// 0x14d4 (RXPCU_RXBUF_309)
#define RXPCU_RXBUF_DATA_309_LSB                                               0
#define RXPCU_RXBUF_DATA_309_MSB                                               31
#define RXPCU_RXBUF_DATA_309_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_309_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_309_MASK) >> RXPCU_RXBUF_DATA_309_LSB)
#define RXPCU_RXBUF_DATA_309_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_309_LSB) & RXPCU_RXBUF_DATA_309_MASK)
#define RXPCU_RXBUF_DATA_309_RESET                                             0x0
#define RXPCU_RXBUF_309_ADDRESS                                                (0x14d4 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_309_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_309_RESET                                                  0x0

// 0x14d8 (RXPCU_RXBUF_310)
#define RXPCU_RXBUF_DATA_310_LSB                                               0
#define RXPCU_RXBUF_DATA_310_MSB                                               31
#define RXPCU_RXBUF_DATA_310_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_310_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_310_MASK) >> RXPCU_RXBUF_DATA_310_LSB)
#define RXPCU_RXBUF_DATA_310_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_310_LSB) & RXPCU_RXBUF_DATA_310_MASK)
#define RXPCU_RXBUF_DATA_310_RESET                                             0x0
#define RXPCU_RXBUF_310_ADDRESS                                                (0x14d8 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_310_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_310_RESET                                                  0x0

// 0x14dc (RXPCU_RXBUF_311)
#define RXPCU_RXBUF_DATA_311_LSB                                               0
#define RXPCU_RXBUF_DATA_311_MSB                                               31
#define RXPCU_RXBUF_DATA_311_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_311_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_311_MASK) >> RXPCU_RXBUF_DATA_311_LSB)
#define RXPCU_RXBUF_DATA_311_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_311_LSB) & RXPCU_RXBUF_DATA_311_MASK)
#define RXPCU_RXBUF_DATA_311_RESET                                             0x0
#define RXPCU_RXBUF_311_ADDRESS                                                (0x14dc + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_311_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_311_RESET                                                  0x0

// 0x14e0 (RXPCU_RXBUF_312)
#define RXPCU_RXBUF_DATA_312_LSB                                               0
#define RXPCU_RXBUF_DATA_312_MSB                                               31
#define RXPCU_RXBUF_DATA_312_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_312_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_312_MASK) >> RXPCU_RXBUF_DATA_312_LSB)
#define RXPCU_RXBUF_DATA_312_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_312_LSB) & RXPCU_RXBUF_DATA_312_MASK)
#define RXPCU_RXBUF_DATA_312_RESET                                             0x0
#define RXPCU_RXBUF_312_ADDRESS                                                (0x14e0 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_312_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_312_RESET                                                  0x0

// 0x14e4 (RXPCU_RXBUF_313)
#define RXPCU_RXBUF_DATA_313_LSB                                               0
#define RXPCU_RXBUF_DATA_313_MSB                                               31
#define RXPCU_RXBUF_DATA_313_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_313_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_313_MASK) >> RXPCU_RXBUF_DATA_313_LSB)
#define RXPCU_RXBUF_DATA_313_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_313_LSB) & RXPCU_RXBUF_DATA_313_MASK)
#define RXPCU_RXBUF_DATA_313_RESET                                             0x0
#define RXPCU_RXBUF_313_ADDRESS                                                (0x14e4 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_313_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_313_RESET                                                  0x0

// 0x14e8 (RXPCU_RXBUF_314)
#define RXPCU_RXBUF_DATA_314_LSB                                               0
#define RXPCU_RXBUF_DATA_314_MSB                                               31
#define RXPCU_RXBUF_DATA_314_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_314_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_314_MASK) >> RXPCU_RXBUF_DATA_314_LSB)
#define RXPCU_RXBUF_DATA_314_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_314_LSB) & RXPCU_RXBUF_DATA_314_MASK)
#define RXPCU_RXBUF_DATA_314_RESET                                             0x0
#define RXPCU_RXBUF_314_ADDRESS                                                (0x14e8 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_314_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_314_RESET                                                  0x0

// 0x14ec (RXPCU_RXBUF_315)
#define RXPCU_RXBUF_DATA_315_LSB                                               0
#define RXPCU_RXBUF_DATA_315_MSB                                               31
#define RXPCU_RXBUF_DATA_315_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_315_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_315_MASK) >> RXPCU_RXBUF_DATA_315_LSB)
#define RXPCU_RXBUF_DATA_315_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_315_LSB) & RXPCU_RXBUF_DATA_315_MASK)
#define RXPCU_RXBUF_DATA_315_RESET                                             0x0
#define RXPCU_RXBUF_315_ADDRESS                                                (0x14ec + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_315_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_315_RESET                                                  0x0

// 0x14f0 (RXPCU_RXBUF_316)
#define RXPCU_RXBUF_DATA_316_LSB                                               0
#define RXPCU_RXBUF_DATA_316_MSB                                               31
#define RXPCU_RXBUF_DATA_316_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_316_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_316_MASK) >> RXPCU_RXBUF_DATA_316_LSB)
#define RXPCU_RXBUF_DATA_316_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_316_LSB) & RXPCU_RXBUF_DATA_316_MASK)
#define RXPCU_RXBUF_DATA_316_RESET                                             0x0
#define RXPCU_RXBUF_316_ADDRESS                                                (0x14f0 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_316_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_316_RESET                                                  0x0

// 0x14f4 (RXPCU_RXBUF_317)
#define RXPCU_RXBUF_DATA_317_LSB                                               0
#define RXPCU_RXBUF_DATA_317_MSB                                               31
#define RXPCU_RXBUF_DATA_317_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_317_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_317_MASK) >> RXPCU_RXBUF_DATA_317_LSB)
#define RXPCU_RXBUF_DATA_317_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_317_LSB) & RXPCU_RXBUF_DATA_317_MASK)
#define RXPCU_RXBUF_DATA_317_RESET                                             0x0
#define RXPCU_RXBUF_317_ADDRESS                                                (0x14f4 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_317_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_317_RESET                                                  0x0

// 0x14f8 (RXPCU_RXBUF_318)
#define RXPCU_RXBUF_DATA_318_LSB                                               0
#define RXPCU_RXBUF_DATA_318_MSB                                               31
#define RXPCU_RXBUF_DATA_318_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_318_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_318_MASK) >> RXPCU_RXBUF_DATA_318_LSB)
#define RXPCU_RXBUF_DATA_318_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_318_LSB) & RXPCU_RXBUF_DATA_318_MASK)
#define RXPCU_RXBUF_DATA_318_RESET                                             0x0
#define RXPCU_RXBUF_318_ADDRESS                                                (0x14f8 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_318_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_318_RESET                                                  0x0

// 0x14fc (RXPCU_RXBUF_319)
#define RXPCU_RXBUF_DATA_319_LSB                                               0
#define RXPCU_RXBUF_DATA_319_MSB                                               31
#define RXPCU_RXBUF_DATA_319_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_319_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_319_MASK) >> RXPCU_RXBUF_DATA_319_LSB)
#define RXPCU_RXBUF_DATA_319_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_319_LSB) & RXPCU_RXBUF_DATA_319_MASK)
#define RXPCU_RXBUF_DATA_319_RESET                                             0x0
#define RXPCU_RXBUF_319_ADDRESS                                                (0x14fc + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_319_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_319_RESET                                                  0x0

// 0x1500 (RXPCU_RXBUF_320)
#define RXPCU_RXBUF_DATA_320_LSB                                               0
#define RXPCU_RXBUF_DATA_320_MSB                                               31
#define RXPCU_RXBUF_DATA_320_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_320_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_320_MASK) >> RXPCU_RXBUF_DATA_320_LSB)
#define RXPCU_RXBUF_DATA_320_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_320_LSB) & RXPCU_RXBUF_DATA_320_MASK)
#define RXPCU_RXBUF_DATA_320_RESET                                             0x0
#define RXPCU_RXBUF_320_ADDRESS                                                (0x1500 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_320_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_320_RESET                                                  0x0

// 0x1504 (RXPCU_RXBUF_321)
#define RXPCU_RXBUF_DATA_321_LSB                                               0
#define RXPCU_RXBUF_DATA_321_MSB                                               31
#define RXPCU_RXBUF_DATA_321_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_321_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_321_MASK) >> RXPCU_RXBUF_DATA_321_LSB)
#define RXPCU_RXBUF_DATA_321_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_321_LSB) & RXPCU_RXBUF_DATA_321_MASK)
#define RXPCU_RXBUF_DATA_321_RESET                                             0x0
#define RXPCU_RXBUF_321_ADDRESS                                                (0x1504 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_321_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_321_RESET                                                  0x0

// 0x1508 (RXPCU_RXBUF_322)
#define RXPCU_RXBUF_DATA_322_LSB                                               0
#define RXPCU_RXBUF_DATA_322_MSB                                               31
#define RXPCU_RXBUF_DATA_322_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_322_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_322_MASK) >> RXPCU_RXBUF_DATA_322_LSB)
#define RXPCU_RXBUF_DATA_322_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_322_LSB) & RXPCU_RXBUF_DATA_322_MASK)
#define RXPCU_RXBUF_DATA_322_RESET                                             0x0
#define RXPCU_RXBUF_322_ADDRESS                                                (0x1508 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_322_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_322_RESET                                                  0x0

// 0x150c (RXPCU_RXBUF_323)
#define RXPCU_RXBUF_DATA_323_LSB                                               0
#define RXPCU_RXBUF_DATA_323_MSB                                               31
#define RXPCU_RXBUF_DATA_323_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_323_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_323_MASK) >> RXPCU_RXBUF_DATA_323_LSB)
#define RXPCU_RXBUF_DATA_323_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_323_LSB) & RXPCU_RXBUF_DATA_323_MASK)
#define RXPCU_RXBUF_DATA_323_RESET                                             0x0
#define RXPCU_RXBUF_323_ADDRESS                                                (0x150c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_323_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_323_RESET                                                  0x0

// 0x1510 (RXPCU_RXBUF_324)
#define RXPCU_RXBUF_DATA_324_LSB                                               0
#define RXPCU_RXBUF_DATA_324_MSB                                               31
#define RXPCU_RXBUF_DATA_324_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_324_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_324_MASK) >> RXPCU_RXBUF_DATA_324_LSB)
#define RXPCU_RXBUF_DATA_324_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_324_LSB) & RXPCU_RXBUF_DATA_324_MASK)
#define RXPCU_RXBUF_DATA_324_RESET                                             0x0
#define RXPCU_RXBUF_324_ADDRESS                                                (0x1510 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_324_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_324_RESET                                                  0x0

// 0x1514 (RXPCU_RXBUF_325)
#define RXPCU_RXBUF_DATA_325_LSB                                               0
#define RXPCU_RXBUF_DATA_325_MSB                                               31
#define RXPCU_RXBUF_DATA_325_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_325_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_325_MASK) >> RXPCU_RXBUF_DATA_325_LSB)
#define RXPCU_RXBUF_DATA_325_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_325_LSB) & RXPCU_RXBUF_DATA_325_MASK)
#define RXPCU_RXBUF_DATA_325_RESET                                             0x0
#define RXPCU_RXBUF_325_ADDRESS                                                (0x1514 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_325_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_325_RESET                                                  0x0

// 0x1518 (RXPCU_RXBUF_326)
#define RXPCU_RXBUF_DATA_326_LSB                                               0
#define RXPCU_RXBUF_DATA_326_MSB                                               31
#define RXPCU_RXBUF_DATA_326_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_326_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_326_MASK) >> RXPCU_RXBUF_DATA_326_LSB)
#define RXPCU_RXBUF_DATA_326_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_326_LSB) & RXPCU_RXBUF_DATA_326_MASK)
#define RXPCU_RXBUF_DATA_326_RESET                                             0x0
#define RXPCU_RXBUF_326_ADDRESS                                                (0x1518 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_326_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_326_RESET                                                  0x0

// 0x151c (RXPCU_RXBUF_327)
#define RXPCU_RXBUF_DATA_327_LSB                                               0
#define RXPCU_RXBUF_DATA_327_MSB                                               31
#define RXPCU_RXBUF_DATA_327_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_327_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_327_MASK) >> RXPCU_RXBUF_DATA_327_LSB)
#define RXPCU_RXBUF_DATA_327_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_327_LSB) & RXPCU_RXBUF_DATA_327_MASK)
#define RXPCU_RXBUF_DATA_327_RESET                                             0x0
#define RXPCU_RXBUF_327_ADDRESS                                                (0x151c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_327_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_327_RESET                                                  0x0

// 0x1520 (RXPCU_RXBUF_328)
#define RXPCU_RXBUF_DATA_328_LSB                                               0
#define RXPCU_RXBUF_DATA_328_MSB                                               31
#define RXPCU_RXBUF_DATA_328_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_328_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_328_MASK) >> RXPCU_RXBUF_DATA_328_LSB)
#define RXPCU_RXBUF_DATA_328_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_328_LSB) & RXPCU_RXBUF_DATA_328_MASK)
#define RXPCU_RXBUF_DATA_328_RESET                                             0x0
#define RXPCU_RXBUF_328_ADDRESS                                                (0x1520 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_328_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_328_RESET                                                  0x0

// 0x1524 (RXPCU_RXBUF_329)
#define RXPCU_RXBUF_DATA_329_LSB                                               0
#define RXPCU_RXBUF_DATA_329_MSB                                               31
#define RXPCU_RXBUF_DATA_329_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_329_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_329_MASK) >> RXPCU_RXBUF_DATA_329_LSB)
#define RXPCU_RXBUF_DATA_329_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_329_LSB) & RXPCU_RXBUF_DATA_329_MASK)
#define RXPCU_RXBUF_DATA_329_RESET                                             0x0
#define RXPCU_RXBUF_329_ADDRESS                                                (0x1524 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_329_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_329_RESET                                                  0x0

// 0x1528 (RXPCU_RXBUF_330)
#define RXPCU_RXBUF_DATA_330_LSB                                               0
#define RXPCU_RXBUF_DATA_330_MSB                                               31
#define RXPCU_RXBUF_DATA_330_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_330_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_330_MASK) >> RXPCU_RXBUF_DATA_330_LSB)
#define RXPCU_RXBUF_DATA_330_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_330_LSB) & RXPCU_RXBUF_DATA_330_MASK)
#define RXPCU_RXBUF_DATA_330_RESET                                             0x0
#define RXPCU_RXBUF_330_ADDRESS                                                (0x1528 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_330_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_330_RESET                                                  0x0

// 0x152c (RXPCU_RXBUF_331)
#define RXPCU_RXBUF_DATA_331_LSB                                               0
#define RXPCU_RXBUF_DATA_331_MSB                                               31
#define RXPCU_RXBUF_DATA_331_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_331_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_331_MASK) >> RXPCU_RXBUF_DATA_331_LSB)
#define RXPCU_RXBUF_DATA_331_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_331_LSB) & RXPCU_RXBUF_DATA_331_MASK)
#define RXPCU_RXBUF_DATA_331_RESET                                             0x0
#define RXPCU_RXBUF_331_ADDRESS                                                (0x152c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_331_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_331_RESET                                                  0x0

// 0x1530 (RXPCU_RXBUF_332)
#define RXPCU_RXBUF_DATA_332_LSB                                               0
#define RXPCU_RXBUF_DATA_332_MSB                                               31
#define RXPCU_RXBUF_DATA_332_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_332_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_332_MASK) >> RXPCU_RXBUF_DATA_332_LSB)
#define RXPCU_RXBUF_DATA_332_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_332_LSB) & RXPCU_RXBUF_DATA_332_MASK)
#define RXPCU_RXBUF_DATA_332_RESET                                             0x0
#define RXPCU_RXBUF_332_ADDRESS                                                (0x1530 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_332_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_332_RESET                                                  0x0

// 0x1534 (RXPCU_RXBUF_333)
#define RXPCU_RXBUF_DATA_333_LSB                                               0
#define RXPCU_RXBUF_DATA_333_MSB                                               31
#define RXPCU_RXBUF_DATA_333_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_333_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_333_MASK) >> RXPCU_RXBUF_DATA_333_LSB)
#define RXPCU_RXBUF_DATA_333_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_333_LSB) & RXPCU_RXBUF_DATA_333_MASK)
#define RXPCU_RXBUF_DATA_333_RESET                                             0x0
#define RXPCU_RXBUF_333_ADDRESS                                                (0x1534 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_333_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_333_RESET                                                  0x0

// 0x1538 (RXPCU_RXBUF_334)
#define RXPCU_RXBUF_DATA_334_LSB                                               0
#define RXPCU_RXBUF_DATA_334_MSB                                               31
#define RXPCU_RXBUF_DATA_334_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_334_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_334_MASK) >> RXPCU_RXBUF_DATA_334_LSB)
#define RXPCU_RXBUF_DATA_334_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_334_LSB) & RXPCU_RXBUF_DATA_334_MASK)
#define RXPCU_RXBUF_DATA_334_RESET                                             0x0
#define RXPCU_RXBUF_334_ADDRESS                                                (0x1538 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_334_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_334_RESET                                                  0x0

// 0x153c (RXPCU_RXBUF_335)
#define RXPCU_RXBUF_DATA_335_LSB                                               0
#define RXPCU_RXBUF_DATA_335_MSB                                               31
#define RXPCU_RXBUF_DATA_335_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_335_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_335_MASK) >> RXPCU_RXBUF_DATA_335_LSB)
#define RXPCU_RXBUF_DATA_335_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_335_LSB) & RXPCU_RXBUF_DATA_335_MASK)
#define RXPCU_RXBUF_DATA_335_RESET                                             0x0
#define RXPCU_RXBUF_335_ADDRESS                                                (0x153c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_335_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_335_RESET                                                  0x0

// 0x1540 (RXPCU_RXBUF_336)
#define RXPCU_RXBUF_DATA_336_LSB                                               0
#define RXPCU_RXBUF_DATA_336_MSB                                               31
#define RXPCU_RXBUF_DATA_336_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_336_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_336_MASK) >> RXPCU_RXBUF_DATA_336_LSB)
#define RXPCU_RXBUF_DATA_336_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_336_LSB) & RXPCU_RXBUF_DATA_336_MASK)
#define RXPCU_RXBUF_DATA_336_RESET                                             0x0
#define RXPCU_RXBUF_336_ADDRESS                                                (0x1540 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_336_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_336_RESET                                                  0x0

// 0x1544 (RXPCU_RXBUF_337)
#define RXPCU_RXBUF_DATA_337_LSB                                               0
#define RXPCU_RXBUF_DATA_337_MSB                                               31
#define RXPCU_RXBUF_DATA_337_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_337_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_337_MASK) >> RXPCU_RXBUF_DATA_337_LSB)
#define RXPCU_RXBUF_DATA_337_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_337_LSB) & RXPCU_RXBUF_DATA_337_MASK)
#define RXPCU_RXBUF_DATA_337_RESET                                             0x0
#define RXPCU_RXBUF_337_ADDRESS                                                (0x1544 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_337_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_337_RESET                                                  0x0

// 0x1548 (RXPCU_RXBUF_338)
#define RXPCU_RXBUF_DATA_338_LSB                                               0
#define RXPCU_RXBUF_DATA_338_MSB                                               31
#define RXPCU_RXBUF_DATA_338_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_338_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_338_MASK) >> RXPCU_RXBUF_DATA_338_LSB)
#define RXPCU_RXBUF_DATA_338_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_338_LSB) & RXPCU_RXBUF_DATA_338_MASK)
#define RXPCU_RXBUF_DATA_338_RESET                                             0x0
#define RXPCU_RXBUF_338_ADDRESS                                                (0x1548 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_338_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_338_RESET                                                  0x0

// 0x154c (RXPCU_RXBUF_339)
#define RXPCU_RXBUF_DATA_339_LSB                                               0
#define RXPCU_RXBUF_DATA_339_MSB                                               31
#define RXPCU_RXBUF_DATA_339_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_339_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_339_MASK) >> RXPCU_RXBUF_DATA_339_LSB)
#define RXPCU_RXBUF_DATA_339_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_339_LSB) & RXPCU_RXBUF_DATA_339_MASK)
#define RXPCU_RXBUF_DATA_339_RESET                                             0x0
#define RXPCU_RXBUF_339_ADDRESS                                                (0x154c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_339_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_339_RESET                                                  0x0

// 0x1550 (RXPCU_RXBUF_340)
#define RXPCU_RXBUF_DATA_340_LSB                                               0
#define RXPCU_RXBUF_DATA_340_MSB                                               31
#define RXPCU_RXBUF_DATA_340_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_340_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_340_MASK) >> RXPCU_RXBUF_DATA_340_LSB)
#define RXPCU_RXBUF_DATA_340_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_340_LSB) & RXPCU_RXBUF_DATA_340_MASK)
#define RXPCU_RXBUF_DATA_340_RESET                                             0x0
#define RXPCU_RXBUF_340_ADDRESS                                                (0x1550 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_340_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_340_RESET                                                  0x0

// 0x1554 (RXPCU_RXBUF_341)
#define RXPCU_RXBUF_DATA_341_LSB                                               0
#define RXPCU_RXBUF_DATA_341_MSB                                               31
#define RXPCU_RXBUF_DATA_341_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_341_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_341_MASK) >> RXPCU_RXBUF_DATA_341_LSB)
#define RXPCU_RXBUF_DATA_341_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_341_LSB) & RXPCU_RXBUF_DATA_341_MASK)
#define RXPCU_RXBUF_DATA_341_RESET                                             0x0
#define RXPCU_RXBUF_341_ADDRESS                                                (0x1554 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_341_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_341_RESET                                                  0x0

// 0x1558 (RXPCU_RXBUF_342)
#define RXPCU_RXBUF_DATA_342_LSB                                               0
#define RXPCU_RXBUF_DATA_342_MSB                                               31
#define RXPCU_RXBUF_DATA_342_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_342_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_342_MASK) >> RXPCU_RXBUF_DATA_342_LSB)
#define RXPCU_RXBUF_DATA_342_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_342_LSB) & RXPCU_RXBUF_DATA_342_MASK)
#define RXPCU_RXBUF_DATA_342_RESET                                             0x0
#define RXPCU_RXBUF_342_ADDRESS                                                (0x1558 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_342_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_342_RESET                                                  0x0

// 0x155c (RXPCU_RXBUF_343)
#define RXPCU_RXBUF_DATA_343_LSB                                               0
#define RXPCU_RXBUF_DATA_343_MSB                                               31
#define RXPCU_RXBUF_DATA_343_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_343_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_343_MASK) >> RXPCU_RXBUF_DATA_343_LSB)
#define RXPCU_RXBUF_DATA_343_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_343_LSB) & RXPCU_RXBUF_DATA_343_MASK)
#define RXPCU_RXBUF_DATA_343_RESET                                             0x0
#define RXPCU_RXBUF_343_ADDRESS                                                (0x155c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_343_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_343_RESET                                                  0x0

// 0x1560 (RXPCU_RXBUF_344)
#define RXPCU_RXBUF_DATA_344_LSB                                               0
#define RXPCU_RXBUF_DATA_344_MSB                                               31
#define RXPCU_RXBUF_DATA_344_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_344_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_344_MASK) >> RXPCU_RXBUF_DATA_344_LSB)
#define RXPCU_RXBUF_DATA_344_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_344_LSB) & RXPCU_RXBUF_DATA_344_MASK)
#define RXPCU_RXBUF_DATA_344_RESET                                             0x0
#define RXPCU_RXBUF_344_ADDRESS                                                (0x1560 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_344_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_344_RESET                                                  0x0

// 0x1564 (RXPCU_RXBUF_345)
#define RXPCU_RXBUF_DATA_345_LSB                                               0
#define RXPCU_RXBUF_DATA_345_MSB                                               31
#define RXPCU_RXBUF_DATA_345_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_345_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_345_MASK) >> RXPCU_RXBUF_DATA_345_LSB)
#define RXPCU_RXBUF_DATA_345_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_345_LSB) & RXPCU_RXBUF_DATA_345_MASK)
#define RXPCU_RXBUF_DATA_345_RESET                                             0x0
#define RXPCU_RXBUF_345_ADDRESS                                                (0x1564 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_345_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_345_RESET                                                  0x0

// 0x1568 (RXPCU_RXBUF_346)
#define RXPCU_RXBUF_DATA_346_LSB                                               0
#define RXPCU_RXBUF_DATA_346_MSB                                               31
#define RXPCU_RXBUF_DATA_346_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_346_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_346_MASK) >> RXPCU_RXBUF_DATA_346_LSB)
#define RXPCU_RXBUF_DATA_346_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_346_LSB) & RXPCU_RXBUF_DATA_346_MASK)
#define RXPCU_RXBUF_DATA_346_RESET                                             0x0
#define RXPCU_RXBUF_346_ADDRESS                                                (0x1568 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_346_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_346_RESET                                                  0x0

// 0x156c (RXPCU_RXBUF_347)
#define RXPCU_RXBUF_DATA_347_LSB                                               0
#define RXPCU_RXBUF_DATA_347_MSB                                               31
#define RXPCU_RXBUF_DATA_347_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_347_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_347_MASK) >> RXPCU_RXBUF_DATA_347_LSB)
#define RXPCU_RXBUF_DATA_347_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_347_LSB) & RXPCU_RXBUF_DATA_347_MASK)
#define RXPCU_RXBUF_DATA_347_RESET                                             0x0
#define RXPCU_RXBUF_347_ADDRESS                                                (0x156c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_347_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_347_RESET                                                  0x0

// 0x1570 (RXPCU_RXBUF_348)
#define RXPCU_RXBUF_DATA_348_LSB                                               0
#define RXPCU_RXBUF_DATA_348_MSB                                               31
#define RXPCU_RXBUF_DATA_348_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_348_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_348_MASK) >> RXPCU_RXBUF_DATA_348_LSB)
#define RXPCU_RXBUF_DATA_348_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_348_LSB) & RXPCU_RXBUF_DATA_348_MASK)
#define RXPCU_RXBUF_DATA_348_RESET                                             0x0
#define RXPCU_RXBUF_348_ADDRESS                                                (0x1570 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_348_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_348_RESET                                                  0x0

// 0x1574 (RXPCU_RXBUF_349)
#define RXPCU_RXBUF_DATA_349_LSB                                               0
#define RXPCU_RXBUF_DATA_349_MSB                                               31
#define RXPCU_RXBUF_DATA_349_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_349_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_349_MASK) >> RXPCU_RXBUF_DATA_349_LSB)
#define RXPCU_RXBUF_DATA_349_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_349_LSB) & RXPCU_RXBUF_DATA_349_MASK)
#define RXPCU_RXBUF_DATA_349_RESET                                             0x0
#define RXPCU_RXBUF_349_ADDRESS                                                (0x1574 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_349_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_349_RESET                                                  0x0

// 0x1578 (RXPCU_RXBUF_350)
#define RXPCU_RXBUF_DATA_350_LSB                                               0
#define RXPCU_RXBUF_DATA_350_MSB                                               31
#define RXPCU_RXBUF_DATA_350_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_350_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_350_MASK) >> RXPCU_RXBUF_DATA_350_LSB)
#define RXPCU_RXBUF_DATA_350_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_350_LSB) & RXPCU_RXBUF_DATA_350_MASK)
#define RXPCU_RXBUF_DATA_350_RESET                                             0x0
#define RXPCU_RXBUF_350_ADDRESS                                                (0x1578 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_350_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_350_RESET                                                  0x0

// 0x157c (RXPCU_RXBUF_351)
#define RXPCU_RXBUF_DATA_351_LSB                                               0
#define RXPCU_RXBUF_DATA_351_MSB                                               31
#define RXPCU_RXBUF_DATA_351_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_351_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_351_MASK) >> RXPCU_RXBUF_DATA_351_LSB)
#define RXPCU_RXBUF_DATA_351_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_351_LSB) & RXPCU_RXBUF_DATA_351_MASK)
#define RXPCU_RXBUF_DATA_351_RESET                                             0x0
#define RXPCU_RXBUF_351_ADDRESS                                                (0x157c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_351_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_351_RESET                                                  0x0

// 0x1580 (RXPCU_RXBUF_352)
#define RXPCU_RXBUF_DATA_352_LSB                                               0
#define RXPCU_RXBUF_DATA_352_MSB                                               31
#define RXPCU_RXBUF_DATA_352_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_352_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_352_MASK) >> RXPCU_RXBUF_DATA_352_LSB)
#define RXPCU_RXBUF_DATA_352_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_352_LSB) & RXPCU_RXBUF_DATA_352_MASK)
#define RXPCU_RXBUF_DATA_352_RESET                                             0x0
#define RXPCU_RXBUF_352_ADDRESS                                                (0x1580 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_352_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_352_RESET                                                  0x0

// 0x1584 (RXPCU_RXBUF_353)
#define RXPCU_RXBUF_DATA_353_LSB                                               0
#define RXPCU_RXBUF_DATA_353_MSB                                               31
#define RXPCU_RXBUF_DATA_353_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_353_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_353_MASK) >> RXPCU_RXBUF_DATA_353_LSB)
#define RXPCU_RXBUF_DATA_353_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_353_LSB) & RXPCU_RXBUF_DATA_353_MASK)
#define RXPCU_RXBUF_DATA_353_RESET                                             0x0
#define RXPCU_RXBUF_353_ADDRESS                                                (0x1584 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_353_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_353_RESET                                                  0x0

// 0x1588 (RXPCU_RXBUF_354)
#define RXPCU_RXBUF_DATA_354_LSB                                               0
#define RXPCU_RXBUF_DATA_354_MSB                                               31
#define RXPCU_RXBUF_DATA_354_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_354_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_354_MASK) >> RXPCU_RXBUF_DATA_354_LSB)
#define RXPCU_RXBUF_DATA_354_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_354_LSB) & RXPCU_RXBUF_DATA_354_MASK)
#define RXPCU_RXBUF_DATA_354_RESET                                             0x0
#define RXPCU_RXBUF_354_ADDRESS                                                (0x1588 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_354_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_354_RESET                                                  0x0

// 0x158c (RXPCU_RXBUF_355)
#define RXPCU_RXBUF_DATA_355_LSB                                               0
#define RXPCU_RXBUF_DATA_355_MSB                                               31
#define RXPCU_RXBUF_DATA_355_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_355_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_355_MASK) >> RXPCU_RXBUF_DATA_355_LSB)
#define RXPCU_RXBUF_DATA_355_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_355_LSB) & RXPCU_RXBUF_DATA_355_MASK)
#define RXPCU_RXBUF_DATA_355_RESET                                             0x0
#define RXPCU_RXBUF_355_ADDRESS                                                (0x158c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_355_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_355_RESET                                                  0x0

// 0x1590 (RXPCU_RXBUF_356)
#define RXPCU_RXBUF_DATA_356_LSB                                               0
#define RXPCU_RXBUF_DATA_356_MSB                                               31
#define RXPCU_RXBUF_DATA_356_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_356_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_356_MASK) >> RXPCU_RXBUF_DATA_356_LSB)
#define RXPCU_RXBUF_DATA_356_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_356_LSB) & RXPCU_RXBUF_DATA_356_MASK)
#define RXPCU_RXBUF_DATA_356_RESET                                             0x0
#define RXPCU_RXBUF_356_ADDRESS                                                (0x1590 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_356_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_356_RESET                                                  0x0

// 0x1594 (RXPCU_RXBUF_357)
#define RXPCU_RXBUF_DATA_357_LSB                                               0
#define RXPCU_RXBUF_DATA_357_MSB                                               31
#define RXPCU_RXBUF_DATA_357_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_357_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_357_MASK) >> RXPCU_RXBUF_DATA_357_LSB)
#define RXPCU_RXBUF_DATA_357_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_357_LSB) & RXPCU_RXBUF_DATA_357_MASK)
#define RXPCU_RXBUF_DATA_357_RESET                                             0x0
#define RXPCU_RXBUF_357_ADDRESS                                                (0x1594 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_357_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_357_RESET                                                  0x0

// 0x1598 (RXPCU_RXBUF_358)
#define RXPCU_RXBUF_DATA_358_LSB                                               0
#define RXPCU_RXBUF_DATA_358_MSB                                               31
#define RXPCU_RXBUF_DATA_358_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_358_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_358_MASK) >> RXPCU_RXBUF_DATA_358_LSB)
#define RXPCU_RXBUF_DATA_358_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_358_LSB) & RXPCU_RXBUF_DATA_358_MASK)
#define RXPCU_RXBUF_DATA_358_RESET                                             0x0
#define RXPCU_RXBUF_358_ADDRESS                                                (0x1598 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_358_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_358_RESET                                                  0x0

// 0x159c (RXPCU_RXBUF_359)
#define RXPCU_RXBUF_DATA_359_LSB                                               0
#define RXPCU_RXBUF_DATA_359_MSB                                               31
#define RXPCU_RXBUF_DATA_359_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_359_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_359_MASK) >> RXPCU_RXBUF_DATA_359_LSB)
#define RXPCU_RXBUF_DATA_359_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_359_LSB) & RXPCU_RXBUF_DATA_359_MASK)
#define RXPCU_RXBUF_DATA_359_RESET                                             0x0
#define RXPCU_RXBUF_359_ADDRESS                                                (0x159c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_359_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_359_RESET                                                  0x0

// 0x15a0 (RXPCU_RXBUF_360)
#define RXPCU_RXBUF_DATA_360_LSB                                               0
#define RXPCU_RXBUF_DATA_360_MSB                                               31
#define RXPCU_RXBUF_DATA_360_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_360_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_360_MASK) >> RXPCU_RXBUF_DATA_360_LSB)
#define RXPCU_RXBUF_DATA_360_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_360_LSB) & RXPCU_RXBUF_DATA_360_MASK)
#define RXPCU_RXBUF_DATA_360_RESET                                             0x0
#define RXPCU_RXBUF_360_ADDRESS                                                (0x15a0 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_360_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_360_RESET                                                  0x0

// 0x15a4 (RXPCU_RXBUF_361)
#define RXPCU_RXBUF_DATA_361_LSB                                               0
#define RXPCU_RXBUF_DATA_361_MSB                                               31
#define RXPCU_RXBUF_DATA_361_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_361_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_361_MASK) >> RXPCU_RXBUF_DATA_361_LSB)
#define RXPCU_RXBUF_DATA_361_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_361_LSB) & RXPCU_RXBUF_DATA_361_MASK)
#define RXPCU_RXBUF_DATA_361_RESET                                             0x0
#define RXPCU_RXBUF_361_ADDRESS                                                (0x15a4 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_361_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_361_RESET                                                  0x0

// 0x15a8 (RXPCU_RXBUF_362)
#define RXPCU_RXBUF_DATA_362_LSB                                               0
#define RXPCU_RXBUF_DATA_362_MSB                                               31
#define RXPCU_RXBUF_DATA_362_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_362_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_362_MASK) >> RXPCU_RXBUF_DATA_362_LSB)
#define RXPCU_RXBUF_DATA_362_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_362_LSB) & RXPCU_RXBUF_DATA_362_MASK)
#define RXPCU_RXBUF_DATA_362_RESET                                             0x0
#define RXPCU_RXBUF_362_ADDRESS                                                (0x15a8 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_362_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_362_RESET                                                  0x0

// 0x15ac (RXPCU_RXBUF_363)
#define RXPCU_RXBUF_DATA_363_LSB                                               0
#define RXPCU_RXBUF_DATA_363_MSB                                               31
#define RXPCU_RXBUF_DATA_363_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_363_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_363_MASK) >> RXPCU_RXBUF_DATA_363_LSB)
#define RXPCU_RXBUF_DATA_363_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_363_LSB) & RXPCU_RXBUF_DATA_363_MASK)
#define RXPCU_RXBUF_DATA_363_RESET                                             0x0
#define RXPCU_RXBUF_363_ADDRESS                                                (0x15ac + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_363_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_363_RESET                                                  0x0

// 0x15b0 (RXPCU_RXBUF_364)
#define RXPCU_RXBUF_DATA_364_LSB                                               0
#define RXPCU_RXBUF_DATA_364_MSB                                               31
#define RXPCU_RXBUF_DATA_364_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_364_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_364_MASK) >> RXPCU_RXBUF_DATA_364_LSB)
#define RXPCU_RXBUF_DATA_364_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_364_LSB) & RXPCU_RXBUF_DATA_364_MASK)
#define RXPCU_RXBUF_DATA_364_RESET                                             0x0
#define RXPCU_RXBUF_364_ADDRESS                                                (0x15b0 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_364_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_364_RESET                                                  0x0

// 0x15b4 (RXPCU_RXBUF_365)
#define RXPCU_RXBUF_DATA_365_LSB                                               0
#define RXPCU_RXBUF_DATA_365_MSB                                               31
#define RXPCU_RXBUF_DATA_365_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_365_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_365_MASK) >> RXPCU_RXBUF_DATA_365_LSB)
#define RXPCU_RXBUF_DATA_365_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_365_LSB) & RXPCU_RXBUF_DATA_365_MASK)
#define RXPCU_RXBUF_DATA_365_RESET                                             0x0
#define RXPCU_RXBUF_365_ADDRESS                                                (0x15b4 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_365_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_365_RESET                                                  0x0

// 0x15b8 (RXPCU_RXBUF_366)
#define RXPCU_RXBUF_DATA_366_LSB                                               0
#define RXPCU_RXBUF_DATA_366_MSB                                               31
#define RXPCU_RXBUF_DATA_366_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_366_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_366_MASK) >> RXPCU_RXBUF_DATA_366_LSB)
#define RXPCU_RXBUF_DATA_366_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_366_LSB) & RXPCU_RXBUF_DATA_366_MASK)
#define RXPCU_RXBUF_DATA_366_RESET                                             0x0
#define RXPCU_RXBUF_366_ADDRESS                                                (0x15b8 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_366_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_366_RESET                                                  0x0

// 0x15bc (RXPCU_RXBUF_367)
#define RXPCU_RXBUF_DATA_367_LSB                                               0
#define RXPCU_RXBUF_DATA_367_MSB                                               31
#define RXPCU_RXBUF_DATA_367_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_367_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_367_MASK) >> RXPCU_RXBUF_DATA_367_LSB)
#define RXPCU_RXBUF_DATA_367_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_367_LSB) & RXPCU_RXBUF_DATA_367_MASK)
#define RXPCU_RXBUF_DATA_367_RESET                                             0x0
#define RXPCU_RXBUF_367_ADDRESS                                                (0x15bc + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_367_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_367_RESET                                                  0x0

// 0x15c0 (RXPCU_RXBUF_368)
#define RXPCU_RXBUF_DATA_368_LSB                                               0
#define RXPCU_RXBUF_DATA_368_MSB                                               31
#define RXPCU_RXBUF_DATA_368_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_368_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_368_MASK) >> RXPCU_RXBUF_DATA_368_LSB)
#define RXPCU_RXBUF_DATA_368_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_368_LSB) & RXPCU_RXBUF_DATA_368_MASK)
#define RXPCU_RXBUF_DATA_368_RESET                                             0x0
#define RXPCU_RXBUF_368_ADDRESS                                                (0x15c0 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_368_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_368_RESET                                                  0x0

// 0x15c4 (RXPCU_RXBUF_369)
#define RXPCU_RXBUF_DATA_369_LSB                                               0
#define RXPCU_RXBUF_DATA_369_MSB                                               31
#define RXPCU_RXBUF_DATA_369_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_369_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_369_MASK) >> RXPCU_RXBUF_DATA_369_LSB)
#define RXPCU_RXBUF_DATA_369_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_369_LSB) & RXPCU_RXBUF_DATA_369_MASK)
#define RXPCU_RXBUF_DATA_369_RESET                                             0x0
#define RXPCU_RXBUF_369_ADDRESS                                                (0x15c4 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_369_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_369_RESET                                                  0x0

// 0x15c8 (RXPCU_RXBUF_370)
#define RXPCU_RXBUF_DATA_370_LSB                                               0
#define RXPCU_RXBUF_DATA_370_MSB                                               31
#define RXPCU_RXBUF_DATA_370_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_370_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_370_MASK) >> RXPCU_RXBUF_DATA_370_LSB)
#define RXPCU_RXBUF_DATA_370_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_370_LSB) & RXPCU_RXBUF_DATA_370_MASK)
#define RXPCU_RXBUF_DATA_370_RESET                                             0x0
#define RXPCU_RXBUF_370_ADDRESS                                                (0x15c8 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_370_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_370_RESET                                                  0x0

// 0x15cc (RXPCU_RXBUF_371)
#define RXPCU_RXBUF_DATA_371_LSB                                               0
#define RXPCU_RXBUF_DATA_371_MSB                                               31
#define RXPCU_RXBUF_DATA_371_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_371_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_371_MASK) >> RXPCU_RXBUF_DATA_371_LSB)
#define RXPCU_RXBUF_DATA_371_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_371_LSB) & RXPCU_RXBUF_DATA_371_MASK)
#define RXPCU_RXBUF_DATA_371_RESET                                             0x0
#define RXPCU_RXBUF_371_ADDRESS                                                (0x15cc + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_371_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_371_RESET                                                  0x0

// 0x15d0 (RXPCU_RXBUF_372)
#define RXPCU_RXBUF_DATA_372_LSB                                               0
#define RXPCU_RXBUF_DATA_372_MSB                                               31
#define RXPCU_RXBUF_DATA_372_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_372_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_372_MASK) >> RXPCU_RXBUF_DATA_372_LSB)
#define RXPCU_RXBUF_DATA_372_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_372_LSB) & RXPCU_RXBUF_DATA_372_MASK)
#define RXPCU_RXBUF_DATA_372_RESET                                             0x0
#define RXPCU_RXBUF_372_ADDRESS                                                (0x15d0 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_372_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_372_RESET                                                  0x0

// 0x15d4 (RXPCU_RXBUF_373)
#define RXPCU_RXBUF_DATA_373_LSB                                               0
#define RXPCU_RXBUF_DATA_373_MSB                                               31
#define RXPCU_RXBUF_DATA_373_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_373_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_373_MASK) >> RXPCU_RXBUF_DATA_373_LSB)
#define RXPCU_RXBUF_DATA_373_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_373_LSB) & RXPCU_RXBUF_DATA_373_MASK)
#define RXPCU_RXBUF_DATA_373_RESET                                             0x0
#define RXPCU_RXBUF_373_ADDRESS                                                (0x15d4 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_373_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_373_RESET                                                  0x0

// 0x15d8 (RXPCU_RXBUF_374)
#define RXPCU_RXBUF_DATA_374_LSB                                               0
#define RXPCU_RXBUF_DATA_374_MSB                                               31
#define RXPCU_RXBUF_DATA_374_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_374_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_374_MASK) >> RXPCU_RXBUF_DATA_374_LSB)
#define RXPCU_RXBUF_DATA_374_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_374_LSB) & RXPCU_RXBUF_DATA_374_MASK)
#define RXPCU_RXBUF_DATA_374_RESET                                             0x0
#define RXPCU_RXBUF_374_ADDRESS                                                (0x15d8 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_374_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_374_RESET                                                  0x0

// 0x15dc (RXPCU_RXBUF_375)
#define RXPCU_RXBUF_DATA_375_LSB                                               0
#define RXPCU_RXBUF_DATA_375_MSB                                               31
#define RXPCU_RXBUF_DATA_375_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_375_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_375_MASK) >> RXPCU_RXBUF_DATA_375_LSB)
#define RXPCU_RXBUF_DATA_375_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_375_LSB) & RXPCU_RXBUF_DATA_375_MASK)
#define RXPCU_RXBUF_DATA_375_RESET                                             0x0
#define RXPCU_RXBUF_375_ADDRESS                                                (0x15dc + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_375_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_375_RESET                                                  0x0

// 0x15e0 (RXPCU_RXBUF_376)
#define RXPCU_RXBUF_DATA_376_LSB                                               0
#define RXPCU_RXBUF_DATA_376_MSB                                               31
#define RXPCU_RXBUF_DATA_376_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_376_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_376_MASK) >> RXPCU_RXBUF_DATA_376_LSB)
#define RXPCU_RXBUF_DATA_376_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_376_LSB) & RXPCU_RXBUF_DATA_376_MASK)
#define RXPCU_RXBUF_DATA_376_RESET                                             0x0
#define RXPCU_RXBUF_376_ADDRESS                                                (0x15e0 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_376_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_376_RESET                                                  0x0

// 0x15e4 (RXPCU_RXBUF_377)
#define RXPCU_RXBUF_DATA_377_LSB                                               0
#define RXPCU_RXBUF_DATA_377_MSB                                               31
#define RXPCU_RXBUF_DATA_377_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_377_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_377_MASK) >> RXPCU_RXBUF_DATA_377_LSB)
#define RXPCU_RXBUF_DATA_377_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_377_LSB) & RXPCU_RXBUF_DATA_377_MASK)
#define RXPCU_RXBUF_DATA_377_RESET                                             0x0
#define RXPCU_RXBUF_377_ADDRESS                                                (0x15e4 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_377_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_377_RESET                                                  0x0

// 0x15e8 (RXPCU_RXBUF_378)
#define RXPCU_RXBUF_DATA_378_LSB                                               0
#define RXPCU_RXBUF_DATA_378_MSB                                               31
#define RXPCU_RXBUF_DATA_378_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_378_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_378_MASK) >> RXPCU_RXBUF_DATA_378_LSB)
#define RXPCU_RXBUF_DATA_378_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_378_LSB) & RXPCU_RXBUF_DATA_378_MASK)
#define RXPCU_RXBUF_DATA_378_RESET                                             0x0
#define RXPCU_RXBUF_378_ADDRESS                                                (0x15e8 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_378_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_378_RESET                                                  0x0

// 0x15ec (RXPCU_RXBUF_379)
#define RXPCU_RXBUF_DATA_379_LSB                                               0
#define RXPCU_RXBUF_DATA_379_MSB                                               31
#define RXPCU_RXBUF_DATA_379_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_379_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_379_MASK) >> RXPCU_RXBUF_DATA_379_LSB)
#define RXPCU_RXBUF_DATA_379_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_379_LSB) & RXPCU_RXBUF_DATA_379_MASK)
#define RXPCU_RXBUF_DATA_379_RESET                                             0x0
#define RXPCU_RXBUF_379_ADDRESS                                                (0x15ec + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_379_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_379_RESET                                                  0x0

// 0x15f0 (RXPCU_RXBUF_380)
#define RXPCU_RXBUF_DATA_380_LSB                                               0
#define RXPCU_RXBUF_DATA_380_MSB                                               31
#define RXPCU_RXBUF_DATA_380_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_380_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_380_MASK) >> RXPCU_RXBUF_DATA_380_LSB)
#define RXPCU_RXBUF_DATA_380_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_380_LSB) & RXPCU_RXBUF_DATA_380_MASK)
#define RXPCU_RXBUF_DATA_380_RESET                                             0x0
#define RXPCU_RXBUF_380_ADDRESS                                                (0x15f0 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_380_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_380_RESET                                                  0x0

// 0x15f4 (RXPCU_RXBUF_381)
#define RXPCU_RXBUF_DATA_381_LSB                                               0
#define RXPCU_RXBUF_DATA_381_MSB                                               31
#define RXPCU_RXBUF_DATA_381_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_381_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_381_MASK) >> RXPCU_RXBUF_DATA_381_LSB)
#define RXPCU_RXBUF_DATA_381_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_381_LSB) & RXPCU_RXBUF_DATA_381_MASK)
#define RXPCU_RXBUF_DATA_381_RESET                                             0x0
#define RXPCU_RXBUF_381_ADDRESS                                                (0x15f4 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_381_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_381_RESET                                                  0x0

// 0x15f8 (RXPCU_RXBUF_382)
#define RXPCU_RXBUF_DATA_382_LSB                                               0
#define RXPCU_RXBUF_DATA_382_MSB                                               31
#define RXPCU_RXBUF_DATA_382_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_382_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_382_MASK) >> RXPCU_RXBUF_DATA_382_LSB)
#define RXPCU_RXBUF_DATA_382_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_382_LSB) & RXPCU_RXBUF_DATA_382_MASK)
#define RXPCU_RXBUF_DATA_382_RESET                                             0x0
#define RXPCU_RXBUF_382_ADDRESS                                                (0x15f8 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_382_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_382_RESET                                                  0x0

// 0x15fc (RXPCU_RXBUF_383)
#define RXPCU_RXBUF_DATA_383_LSB                                               0
#define RXPCU_RXBUF_DATA_383_MSB                                               31
#define RXPCU_RXBUF_DATA_383_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_383_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_383_MASK) >> RXPCU_RXBUF_DATA_383_LSB)
#define RXPCU_RXBUF_DATA_383_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_383_LSB) & RXPCU_RXBUF_DATA_383_MASK)
#define RXPCU_RXBUF_DATA_383_RESET                                             0x0
#define RXPCU_RXBUF_383_ADDRESS                                                (0x15fc + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_383_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_383_RESET                                                  0x0

// 0x1600 (RXPCU_RXBUF_384)
#define RXPCU_RXBUF_DATA_384_LSB                                               0
#define RXPCU_RXBUF_DATA_384_MSB                                               31
#define RXPCU_RXBUF_DATA_384_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_384_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_384_MASK) >> RXPCU_RXBUF_DATA_384_LSB)
#define RXPCU_RXBUF_DATA_384_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_384_LSB) & RXPCU_RXBUF_DATA_384_MASK)
#define RXPCU_RXBUF_DATA_384_RESET                                             0x0
#define RXPCU_RXBUF_384_ADDRESS                                                (0x1600 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_384_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_384_RESET                                                  0x0

// 0x1604 (RXPCU_RXBUF_385)
#define RXPCU_RXBUF_DATA_385_LSB                                               0
#define RXPCU_RXBUF_DATA_385_MSB                                               31
#define RXPCU_RXBUF_DATA_385_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_385_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_385_MASK) >> RXPCU_RXBUF_DATA_385_LSB)
#define RXPCU_RXBUF_DATA_385_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_385_LSB) & RXPCU_RXBUF_DATA_385_MASK)
#define RXPCU_RXBUF_DATA_385_RESET                                             0x0
#define RXPCU_RXBUF_385_ADDRESS                                                (0x1604 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_385_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_385_RESET                                                  0x0

// 0x1608 (RXPCU_RXBUF_386)
#define RXPCU_RXBUF_DATA_386_LSB                                               0
#define RXPCU_RXBUF_DATA_386_MSB                                               31
#define RXPCU_RXBUF_DATA_386_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_386_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_386_MASK) >> RXPCU_RXBUF_DATA_386_LSB)
#define RXPCU_RXBUF_DATA_386_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_386_LSB) & RXPCU_RXBUF_DATA_386_MASK)
#define RXPCU_RXBUF_DATA_386_RESET                                             0x0
#define RXPCU_RXBUF_386_ADDRESS                                                (0x1608 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_386_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_386_RESET                                                  0x0

// 0x160c (RXPCU_RXBUF_387)
#define RXPCU_RXBUF_DATA_387_LSB                                               0
#define RXPCU_RXBUF_DATA_387_MSB                                               31
#define RXPCU_RXBUF_DATA_387_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_387_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_387_MASK) >> RXPCU_RXBUF_DATA_387_LSB)
#define RXPCU_RXBUF_DATA_387_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_387_LSB) & RXPCU_RXBUF_DATA_387_MASK)
#define RXPCU_RXBUF_DATA_387_RESET                                             0x0
#define RXPCU_RXBUF_387_ADDRESS                                                (0x160c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_387_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_387_RESET                                                  0x0

// 0x1610 (RXPCU_RXBUF_388)
#define RXPCU_RXBUF_DATA_388_LSB                                               0
#define RXPCU_RXBUF_DATA_388_MSB                                               31
#define RXPCU_RXBUF_DATA_388_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_388_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_388_MASK) >> RXPCU_RXBUF_DATA_388_LSB)
#define RXPCU_RXBUF_DATA_388_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_388_LSB) & RXPCU_RXBUF_DATA_388_MASK)
#define RXPCU_RXBUF_DATA_388_RESET                                             0x0
#define RXPCU_RXBUF_388_ADDRESS                                                (0x1610 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_388_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_388_RESET                                                  0x0

// 0x1614 (RXPCU_RXBUF_389)
#define RXPCU_RXBUF_DATA_389_LSB                                               0
#define RXPCU_RXBUF_DATA_389_MSB                                               31
#define RXPCU_RXBUF_DATA_389_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_389_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_389_MASK) >> RXPCU_RXBUF_DATA_389_LSB)
#define RXPCU_RXBUF_DATA_389_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_389_LSB) & RXPCU_RXBUF_DATA_389_MASK)
#define RXPCU_RXBUF_DATA_389_RESET                                             0x0
#define RXPCU_RXBUF_389_ADDRESS                                                (0x1614 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_389_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_389_RESET                                                  0x0

// 0x1618 (RXPCU_RXBUF_390)
#define RXPCU_RXBUF_DATA_390_LSB                                               0
#define RXPCU_RXBUF_DATA_390_MSB                                               31
#define RXPCU_RXBUF_DATA_390_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_390_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_390_MASK) >> RXPCU_RXBUF_DATA_390_LSB)
#define RXPCU_RXBUF_DATA_390_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_390_LSB) & RXPCU_RXBUF_DATA_390_MASK)
#define RXPCU_RXBUF_DATA_390_RESET                                             0x0
#define RXPCU_RXBUF_390_ADDRESS                                                (0x1618 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_390_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_390_RESET                                                  0x0

// 0x161c (RXPCU_RXBUF_391)
#define RXPCU_RXBUF_DATA_391_LSB                                               0
#define RXPCU_RXBUF_DATA_391_MSB                                               31
#define RXPCU_RXBUF_DATA_391_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_391_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_391_MASK) >> RXPCU_RXBUF_DATA_391_LSB)
#define RXPCU_RXBUF_DATA_391_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_391_LSB) & RXPCU_RXBUF_DATA_391_MASK)
#define RXPCU_RXBUF_DATA_391_RESET                                             0x0
#define RXPCU_RXBUF_391_ADDRESS                                                (0x161c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_391_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_391_RESET                                                  0x0

// 0x1620 (RXPCU_RXBUF_392)
#define RXPCU_RXBUF_DATA_392_LSB                                               0
#define RXPCU_RXBUF_DATA_392_MSB                                               31
#define RXPCU_RXBUF_DATA_392_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_392_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_392_MASK) >> RXPCU_RXBUF_DATA_392_LSB)
#define RXPCU_RXBUF_DATA_392_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_392_LSB) & RXPCU_RXBUF_DATA_392_MASK)
#define RXPCU_RXBUF_DATA_392_RESET                                             0x0
#define RXPCU_RXBUF_392_ADDRESS                                                (0x1620 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_392_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_392_RESET                                                  0x0

// 0x1624 (RXPCU_RXBUF_393)
#define RXPCU_RXBUF_DATA_393_LSB                                               0
#define RXPCU_RXBUF_DATA_393_MSB                                               31
#define RXPCU_RXBUF_DATA_393_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_393_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_393_MASK) >> RXPCU_RXBUF_DATA_393_LSB)
#define RXPCU_RXBUF_DATA_393_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_393_LSB) & RXPCU_RXBUF_DATA_393_MASK)
#define RXPCU_RXBUF_DATA_393_RESET                                             0x0
#define RXPCU_RXBUF_393_ADDRESS                                                (0x1624 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_393_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_393_RESET                                                  0x0

// 0x1628 (RXPCU_RXBUF_394)
#define RXPCU_RXBUF_DATA_394_LSB                                               0
#define RXPCU_RXBUF_DATA_394_MSB                                               31
#define RXPCU_RXBUF_DATA_394_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_394_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_394_MASK) >> RXPCU_RXBUF_DATA_394_LSB)
#define RXPCU_RXBUF_DATA_394_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_394_LSB) & RXPCU_RXBUF_DATA_394_MASK)
#define RXPCU_RXBUF_DATA_394_RESET                                             0x0
#define RXPCU_RXBUF_394_ADDRESS                                                (0x1628 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_394_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_394_RESET                                                  0x0

// 0x162c (RXPCU_RXBUF_395)
#define RXPCU_RXBUF_DATA_395_LSB                                               0
#define RXPCU_RXBUF_DATA_395_MSB                                               31
#define RXPCU_RXBUF_DATA_395_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_395_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_395_MASK) >> RXPCU_RXBUF_DATA_395_LSB)
#define RXPCU_RXBUF_DATA_395_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_395_LSB) & RXPCU_RXBUF_DATA_395_MASK)
#define RXPCU_RXBUF_DATA_395_RESET                                             0x0
#define RXPCU_RXBUF_395_ADDRESS                                                (0x162c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_395_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_395_RESET                                                  0x0

// 0x1630 (RXPCU_RXBUF_396)
#define RXPCU_RXBUF_DATA_396_LSB                                               0
#define RXPCU_RXBUF_DATA_396_MSB                                               31
#define RXPCU_RXBUF_DATA_396_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_396_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_396_MASK) >> RXPCU_RXBUF_DATA_396_LSB)
#define RXPCU_RXBUF_DATA_396_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_396_LSB) & RXPCU_RXBUF_DATA_396_MASK)
#define RXPCU_RXBUF_DATA_396_RESET                                             0x0
#define RXPCU_RXBUF_396_ADDRESS                                                (0x1630 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_396_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_396_RESET                                                  0x0

// 0x1634 (RXPCU_RXBUF_397)
#define RXPCU_RXBUF_DATA_397_LSB                                               0
#define RXPCU_RXBUF_DATA_397_MSB                                               31
#define RXPCU_RXBUF_DATA_397_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_397_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_397_MASK) >> RXPCU_RXBUF_DATA_397_LSB)
#define RXPCU_RXBUF_DATA_397_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_397_LSB) & RXPCU_RXBUF_DATA_397_MASK)
#define RXPCU_RXBUF_DATA_397_RESET                                             0x0
#define RXPCU_RXBUF_397_ADDRESS                                                (0x1634 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_397_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_397_RESET                                                  0x0

// 0x1638 (RXPCU_RXBUF_398)
#define RXPCU_RXBUF_DATA_398_LSB                                               0
#define RXPCU_RXBUF_DATA_398_MSB                                               31
#define RXPCU_RXBUF_DATA_398_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_398_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_398_MASK) >> RXPCU_RXBUF_DATA_398_LSB)
#define RXPCU_RXBUF_DATA_398_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_398_LSB) & RXPCU_RXBUF_DATA_398_MASK)
#define RXPCU_RXBUF_DATA_398_RESET                                             0x0
#define RXPCU_RXBUF_398_ADDRESS                                                (0x1638 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_398_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_398_RESET                                                  0x0

// 0x163c (RXPCU_RXBUF_399)
#define RXPCU_RXBUF_DATA_399_LSB                                               0
#define RXPCU_RXBUF_DATA_399_MSB                                               31
#define RXPCU_RXBUF_DATA_399_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_399_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_399_MASK) >> RXPCU_RXBUF_DATA_399_LSB)
#define RXPCU_RXBUF_DATA_399_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_399_LSB) & RXPCU_RXBUF_DATA_399_MASK)
#define RXPCU_RXBUF_DATA_399_RESET                                             0x0
#define RXPCU_RXBUF_399_ADDRESS                                                (0x163c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_399_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_399_RESET                                                  0x0

// 0x1640 (RXPCU_RXBUF_400)
#define RXPCU_RXBUF_DATA_400_LSB                                               0
#define RXPCU_RXBUF_DATA_400_MSB                                               31
#define RXPCU_RXBUF_DATA_400_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_400_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_400_MASK) >> RXPCU_RXBUF_DATA_400_LSB)
#define RXPCU_RXBUF_DATA_400_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_400_LSB) & RXPCU_RXBUF_DATA_400_MASK)
#define RXPCU_RXBUF_DATA_400_RESET                                             0x0
#define RXPCU_RXBUF_400_ADDRESS                                                (0x1640 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_400_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_400_RESET                                                  0x0

// 0x1644 (RXPCU_RXBUF_401)
#define RXPCU_RXBUF_DATA_401_LSB                                               0
#define RXPCU_RXBUF_DATA_401_MSB                                               31
#define RXPCU_RXBUF_DATA_401_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_401_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_401_MASK) >> RXPCU_RXBUF_DATA_401_LSB)
#define RXPCU_RXBUF_DATA_401_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_401_LSB) & RXPCU_RXBUF_DATA_401_MASK)
#define RXPCU_RXBUF_DATA_401_RESET                                             0x0
#define RXPCU_RXBUF_401_ADDRESS                                                (0x1644 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_401_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_401_RESET                                                  0x0

// 0x1648 (RXPCU_RXBUF_402)
#define RXPCU_RXBUF_DATA_402_LSB                                               0
#define RXPCU_RXBUF_DATA_402_MSB                                               31
#define RXPCU_RXBUF_DATA_402_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_402_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_402_MASK) >> RXPCU_RXBUF_DATA_402_LSB)
#define RXPCU_RXBUF_DATA_402_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_402_LSB) & RXPCU_RXBUF_DATA_402_MASK)
#define RXPCU_RXBUF_DATA_402_RESET                                             0x0
#define RXPCU_RXBUF_402_ADDRESS                                                (0x1648 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_402_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_402_RESET                                                  0x0

// 0x164c (RXPCU_RXBUF_403)
#define RXPCU_RXBUF_DATA_403_LSB                                               0
#define RXPCU_RXBUF_DATA_403_MSB                                               31
#define RXPCU_RXBUF_DATA_403_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_403_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_403_MASK) >> RXPCU_RXBUF_DATA_403_LSB)
#define RXPCU_RXBUF_DATA_403_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_403_LSB) & RXPCU_RXBUF_DATA_403_MASK)
#define RXPCU_RXBUF_DATA_403_RESET                                             0x0
#define RXPCU_RXBUF_403_ADDRESS                                                (0x164c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_403_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_403_RESET                                                  0x0

// 0x1650 (RXPCU_RXBUF_404)
#define RXPCU_RXBUF_DATA_404_LSB                                               0
#define RXPCU_RXBUF_DATA_404_MSB                                               31
#define RXPCU_RXBUF_DATA_404_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_404_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_404_MASK) >> RXPCU_RXBUF_DATA_404_LSB)
#define RXPCU_RXBUF_DATA_404_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_404_LSB) & RXPCU_RXBUF_DATA_404_MASK)
#define RXPCU_RXBUF_DATA_404_RESET                                             0x0
#define RXPCU_RXBUF_404_ADDRESS                                                (0x1650 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_404_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_404_RESET                                                  0x0

// 0x1654 (RXPCU_RXBUF_405)
#define RXPCU_RXBUF_DATA_405_LSB                                               0
#define RXPCU_RXBUF_DATA_405_MSB                                               31
#define RXPCU_RXBUF_DATA_405_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_405_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_405_MASK) >> RXPCU_RXBUF_DATA_405_LSB)
#define RXPCU_RXBUF_DATA_405_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_405_LSB) & RXPCU_RXBUF_DATA_405_MASK)
#define RXPCU_RXBUF_DATA_405_RESET                                             0x0
#define RXPCU_RXBUF_405_ADDRESS                                                (0x1654 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_405_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_405_RESET                                                  0x0

// 0x1658 (RXPCU_RXBUF_406)
#define RXPCU_RXBUF_DATA_406_LSB                                               0
#define RXPCU_RXBUF_DATA_406_MSB                                               31
#define RXPCU_RXBUF_DATA_406_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_406_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_406_MASK) >> RXPCU_RXBUF_DATA_406_LSB)
#define RXPCU_RXBUF_DATA_406_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_406_LSB) & RXPCU_RXBUF_DATA_406_MASK)
#define RXPCU_RXBUF_DATA_406_RESET                                             0x0
#define RXPCU_RXBUF_406_ADDRESS                                                (0x1658 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_406_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_406_RESET                                                  0x0

// 0x165c (RXPCU_RXBUF_407)
#define RXPCU_RXBUF_DATA_407_LSB                                               0
#define RXPCU_RXBUF_DATA_407_MSB                                               31
#define RXPCU_RXBUF_DATA_407_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_407_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_407_MASK) >> RXPCU_RXBUF_DATA_407_LSB)
#define RXPCU_RXBUF_DATA_407_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_407_LSB) & RXPCU_RXBUF_DATA_407_MASK)
#define RXPCU_RXBUF_DATA_407_RESET                                             0x0
#define RXPCU_RXBUF_407_ADDRESS                                                (0x165c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_407_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_407_RESET                                                  0x0

// 0x1660 (RXPCU_RXBUF_408)
#define RXPCU_RXBUF_DATA_408_LSB                                               0
#define RXPCU_RXBUF_DATA_408_MSB                                               31
#define RXPCU_RXBUF_DATA_408_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_408_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_408_MASK) >> RXPCU_RXBUF_DATA_408_LSB)
#define RXPCU_RXBUF_DATA_408_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_408_LSB) & RXPCU_RXBUF_DATA_408_MASK)
#define RXPCU_RXBUF_DATA_408_RESET                                             0x0
#define RXPCU_RXBUF_408_ADDRESS                                                (0x1660 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_408_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_408_RESET                                                  0x0

// 0x1664 (RXPCU_RXBUF_409)
#define RXPCU_RXBUF_DATA_409_LSB                                               0
#define RXPCU_RXBUF_DATA_409_MSB                                               31
#define RXPCU_RXBUF_DATA_409_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_409_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_409_MASK) >> RXPCU_RXBUF_DATA_409_LSB)
#define RXPCU_RXBUF_DATA_409_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_409_LSB) & RXPCU_RXBUF_DATA_409_MASK)
#define RXPCU_RXBUF_DATA_409_RESET                                             0x0
#define RXPCU_RXBUF_409_ADDRESS                                                (0x1664 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_409_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_409_RESET                                                  0x0

// 0x1668 (RXPCU_RXBUF_410)
#define RXPCU_RXBUF_DATA_410_LSB                                               0
#define RXPCU_RXBUF_DATA_410_MSB                                               31
#define RXPCU_RXBUF_DATA_410_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_410_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_410_MASK) >> RXPCU_RXBUF_DATA_410_LSB)
#define RXPCU_RXBUF_DATA_410_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_410_LSB) & RXPCU_RXBUF_DATA_410_MASK)
#define RXPCU_RXBUF_DATA_410_RESET                                             0x0
#define RXPCU_RXBUF_410_ADDRESS                                                (0x1668 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_410_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_410_RESET                                                  0x0

// 0x166c (RXPCU_RXBUF_411)
#define RXPCU_RXBUF_DATA_411_LSB                                               0
#define RXPCU_RXBUF_DATA_411_MSB                                               31
#define RXPCU_RXBUF_DATA_411_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_411_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_411_MASK) >> RXPCU_RXBUF_DATA_411_LSB)
#define RXPCU_RXBUF_DATA_411_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_411_LSB) & RXPCU_RXBUF_DATA_411_MASK)
#define RXPCU_RXBUF_DATA_411_RESET                                             0x0
#define RXPCU_RXBUF_411_ADDRESS                                                (0x166c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_411_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_411_RESET                                                  0x0

// 0x1670 (RXPCU_RXBUF_412)
#define RXPCU_RXBUF_DATA_412_LSB                                               0
#define RXPCU_RXBUF_DATA_412_MSB                                               31
#define RXPCU_RXBUF_DATA_412_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_412_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_412_MASK) >> RXPCU_RXBUF_DATA_412_LSB)
#define RXPCU_RXBUF_DATA_412_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_412_LSB) & RXPCU_RXBUF_DATA_412_MASK)
#define RXPCU_RXBUF_DATA_412_RESET                                             0x0
#define RXPCU_RXBUF_412_ADDRESS                                                (0x1670 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_412_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_412_RESET                                                  0x0

// 0x1674 (RXPCU_RXBUF_413)
#define RXPCU_RXBUF_DATA_413_LSB                                               0
#define RXPCU_RXBUF_DATA_413_MSB                                               31
#define RXPCU_RXBUF_DATA_413_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_413_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_413_MASK) >> RXPCU_RXBUF_DATA_413_LSB)
#define RXPCU_RXBUF_DATA_413_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_413_LSB) & RXPCU_RXBUF_DATA_413_MASK)
#define RXPCU_RXBUF_DATA_413_RESET                                             0x0
#define RXPCU_RXBUF_413_ADDRESS                                                (0x1674 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_413_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_413_RESET                                                  0x0

// 0x1678 (RXPCU_RXBUF_414)
#define RXPCU_RXBUF_DATA_414_LSB                                               0
#define RXPCU_RXBUF_DATA_414_MSB                                               31
#define RXPCU_RXBUF_DATA_414_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_414_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_414_MASK) >> RXPCU_RXBUF_DATA_414_LSB)
#define RXPCU_RXBUF_DATA_414_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_414_LSB) & RXPCU_RXBUF_DATA_414_MASK)
#define RXPCU_RXBUF_DATA_414_RESET                                             0x0
#define RXPCU_RXBUF_414_ADDRESS                                                (0x1678 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_414_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_414_RESET                                                  0x0

// 0x167c (RXPCU_RXBUF_415)
#define RXPCU_RXBUF_DATA_415_LSB                                               0
#define RXPCU_RXBUF_DATA_415_MSB                                               31
#define RXPCU_RXBUF_DATA_415_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_415_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_415_MASK) >> RXPCU_RXBUF_DATA_415_LSB)
#define RXPCU_RXBUF_DATA_415_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_415_LSB) & RXPCU_RXBUF_DATA_415_MASK)
#define RXPCU_RXBUF_DATA_415_RESET                                             0x0
#define RXPCU_RXBUF_415_ADDRESS                                                (0x167c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_415_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_415_RESET                                                  0x0

// 0x1680 (RXPCU_RXBUF_416)
#define RXPCU_RXBUF_DATA_416_LSB                                               0
#define RXPCU_RXBUF_DATA_416_MSB                                               31
#define RXPCU_RXBUF_DATA_416_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_416_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_416_MASK) >> RXPCU_RXBUF_DATA_416_LSB)
#define RXPCU_RXBUF_DATA_416_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_416_LSB) & RXPCU_RXBUF_DATA_416_MASK)
#define RXPCU_RXBUF_DATA_416_RESET                                             0x0
#define RXPCU_RXBUF_416_ADDRESS                                                (0x1680 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_416_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_416_RESET                                                  0x0

// 0x1684 (RXPCU_RXBUF_417)
#define RXPCU_RXBUF_DATA_417_LSB                                               0
#define RXPCU_RXBUF_DATA_417_MSB                                               31
#define RXPCU_RXBUF_DATA_417_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_417_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_417_MASK) >> RXPCU_RXBUF_DATA_417_LSB)
#define RXPCU_RXBUF_DATA_417_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_417_LSB) & RXPCU_RXBUF_DATA_417_MASK)
#define RXPCU_RXBUF_DATA_417_RESET                                             0x0
#define RXPCU_RXBUF_417_ADDRESS                                                (0x1684 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_417_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_417_RESET                                                  0x0

// 0x1688 (RXPCU_RXBUF_418)
#define RXPCU_RXBUF_DATA_418_LSB                                               0
#define RXPCU_RXBUF_DATA_418_MSB                                               31
#define RXPCU_RXBUF_DATA_418_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_418_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_418_MASK) >> RXPCU_RXBUF_DATA_418_LSB)
#define RXPCU_RXBUF_DATA_418_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_418_LSB) & RXPCU_RXBUF_DATA_418_MASK)
#define RXPCU_RXBUF_DATA_418_RESET                                             0x0
#define RXPCU_RXBUF_418_ADDRESS                                                (0x1688 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_418_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_418_RESET                                                  0x0

// 0x168c (RXPCU_RXBUF_419)
#define RXPCU_RXBUF_DATA_419_LSB                                               0
#define RXPCU_RXBUF_DATA_419_MSB                                               31
#define RXPCU_RXBUF_DATA_419_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_419_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_419_MASK) >> RXPCU_RXBUF_DATA_419_LSB)
#define RXPCU_RXBUF_DATA_419_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_419_LSB) & RXPCU_RXBUF_DATA_419_MASK)
#define RXPCU_RXBUF_DATA_419_RESET                                             0x0
#define RXPCU_RXBUF_419_ADDRESS                                                (0x168c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_419_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_419_RESET                                                  0x0

// 0x1690 (RXPCU_RXBUF_420)
#define RXPCU_RXBUF_DATA_420_LSB                                               0
#define RXPCU_RXBUF_DATA_420_MSB                                               31
#define RXPCU_RXBUF_DATA_420_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_420_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_420_MASK) >> RXPCU_RXBUF_DATA_420_LSB)
#define RXPCU_RXBUF_DATA_420_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_420_LSB) & RXPCU_RXBUF_DATA_420_MASK)
#define RXPCU_RXBUF_DATA_420_RESET                                             0x0
#define RXPCU_RXBUF_420_ADDRESS                                                (0x1690 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_420_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_420_RESET                                                  0x0

// 0x1694 (RXPCU_RXBUF_421)
#define RXPCU_RXBUF_DATA_421_LSB                                               0
#define RXPCU_RXBUF_DATA_421_MSB                                               31
#define RXPCU_RXBUF_DATA_421_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_421_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_421_MASK) >> RXPCU_RXBUF_DATA_421_LSB)
#define RXPCU_RXBUF_DATA_421_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_421_LSB) & RXPCU_RXBUF_DATA_421_MASK)
#define RXPCU_RXBUF_DATA_421_RESET                                             0x0
#define RXPCU_RXBUF_421_ADDRESS                                                (0x1694 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_421_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_421_RESET                                                  0x0

// 0x1698 (RXPCU_RXBUF_422)
#define RXPCU_RXBUF_DATA_422_LSB                                               0
#define RXPCU_RXBUF_DATA_422_MSB                                               31
#define RXPCU_RXBUF_DATA_422_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_422_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_422_MASK) >> RXPCU_RXBUF_DATA_422_LSB)
#define RXPCU_RXBUF_DATA_422_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_422_LSB) & RXPCU_RXBUF_DATA_422_MASK)
#define RXPCU_RXBUF_DATA_422_RESET                                             0x0
#define RXPCU_RXBUF_422_ADDRESS                                                (0x1698 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_422_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_422_RESET                                                  0x0

// 0x169c (RXPCU_RXBUF_423)
#define RXPCU_RXBUF_DATA_423_LSB                                               0
#define RXPCU_RXBUF_DATA_423_MSB                                               31
#define RXPCU_RXBUF_DATA_423_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_423_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_423_MASK) >> RXPCU_RXBUF_DATA_423_LSB)
#define RXPCU_RXBUF_DATA_423_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_423_LSB) & RXPCU_RXBUF_DATA_423_MASK)
#define RXPCU_RXBUF_DATA_423_RESET                                             0x0
#define RXPCU_RXBUF_423_ADDRESS                                                (0x169c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_423_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_423_RESET                                                  0x0

// 0x16a0 (RXPCU_RXBUF_424)
#define RXPCU_RXBUF_DATA_424_LSB                                               0
#define RXPCU_RXBUF_DATA_424_MSB                                               31
#define RXPCU_RXBUF_DATA_424_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_424_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_424_MASK) >> RXPCU_RXBUF_DATA_424_LSB)
#define RXPCU_RXBUF_DATA_424_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_424_LSB) & RXPCU_RXBUF_DATA_424_MASK)
#define RXPCU_RXBUF_DATA_424_RESET                                             0x0
#define RXPCU_RXBUF_424_ADDRESS                                                (0x16a0 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_424_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_424_RESET                                                  0x0

// 0x16a4 (RXPCU_RXBUF_425)
#define RXPCU_RXBUF_DATA_425_LSB                                               0
#define RXPCU_RXBUF_DATA_425_MSB                                               31
#define RXPCU_RXBUF_DATA_425_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_425_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_425_MASK) >> RXPCU_RXBUF_DATA_425_LSB)
#define RXPCU_RXBUF_DATA_425_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_425_LSB) & RXPCU_RXBUF_DATA_425_MASK)
#define RXPCU_RXBUF_DATA_425_RESET                                             0x0
#define RXPCU_RXBUF_425_ADDRESS                                                (0x16a4 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_425_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_425_RESET                                                  0x0

// 0x16a8 (RXPCU_RXBUF_426)
#define RXPCU_RXBUF_DATA_426_LSB                                               0
#define RXPCU_RXBUF_DATA_426_MSB                                               31
#define RXPCU_RXBUF_DATA_426_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_426_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_426_MASK) >> RXPCU_RXBUF_DATA_426_LSB)
#define RXPCU_RXBUF_DATA_426_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_426_LSB) & RXPCU_RXBUF_DATA_426_MASK)
#define RXPCU_RXBUF_DATA_426_RESET                                             0x0
#define RXPCU_RXBUF_426_ADDRESS                                                (0x16a8 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_426_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_426_RESET                                                  0x0

// 0x16ac (RXPCU_RXBUF_427)
#define RXPCU_RXBUF_DATA_427_LSB                                               0
#define RXPCU_RXBUF_DATA_427_MSB                                               31
#define RXPCU_RXBUF_DATA_427_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_427_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_427_MASK) >> RXPCU_RXBUF_DATA_427_LSB)
#define RXPCU_RXBUF_DATA_427_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_427_LSB) & RXPCU_RXBUF_DATA_427_MASK)
#define RXPCU_RXBUF_DATA_427_RESET                                             0x0
#define RXPCU_RXBUF_427_ADDRESS                                                (0x16ac + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_427_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_427_RESET                                                  0x0

// 0x16b0 (RXPCU_RXBUF_428)
#define RXPCU_RXBUF_DATA_428_LSB                                               0
#define RXPCU_RXBUF_DATA_428_MSB                                               31
#define RXPCU_RXBUF_DATA_428_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_428_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_428_MASK) >> RXPCU_RXBUF_DATA_428_LSB)
#define RXPCU_RXBUF_DATA_428_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_428_LSB) & RXPCU_RXBUF_DATA_428_MASK)
#define RXPCU_RXBUF_DATA_428_RESET                                             0x0
#define RXPCU_RXBUF_428_ADDRESS                                                (0x16b0 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_428_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_428_RESET                                                  0x0

// 0x16b4 (RXPCU_RXBUF_429)
#define RXPCU_RXBUF_DATA_429_LSB                                               0
#define RXPCU_RXBUF_DATA_429_MSB                                               31
#define RXPCU_RXBUF_DATA_429_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_429_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_429_MASK) >> RXPCU_RXBUF_DATA_429_LSB)
#define RXPCU_RXBUF_DATA_429_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_429_LSB) & RXPCU_RXBUF_DATA_429_MASK)
#define RXPCU_RXBUF_DATA_429_RESET                                             0x0
#define RXPCU_RXBUF_429_ADDRESS                                                (0x16b4 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_429_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_429_RESET                                                  0x0

// 0x16b8 (RXPCU_RXBUF_430)
#define RXPCU_RXBUF_DATA_430_LSB                                               0
#define RXPCU_RXBUF_DATA_430_MSB                                               31
#define RXPCU_RXBUF_DATA_430_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_430_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_430_MASK) >> RXPCU_RXBUF_DATA_430_LSB)
#define RXPCU_RXBUF_DATA_430_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_430_LSB) & RXPCU_RXBUF_DATA_430_MASK)
#define RXPCU_RXBUF_DATA_430_RESET                                             0x0
#define RXPCU_RXBUF_430_ADDRESS                                                (0x16b8 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_430_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_430_RESET                                                  0x0

// 0x16bc (RXPCU_RXBUF_431)
#define RXPCU_RXBUF_DATA_431_LSB                                               0
#define RXPCU_RXBUF_DATA_431_MSB                                               31
#define RXPCU_RXBUF_DATA_431_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_431_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_431_MASK) >> RXPCU_RXBUF_DATA_431_LSB)
#define RXPCU_RXBUF_DATA_431_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_431_LSB) & RXPCU_RXBUF_DATA_431_MASK)
#define RXPCU_RXBUF_DATA_431_RESET                                             0x0
#define RXPCU_RXBUF_431_ADDRESS                                                (0x16bc + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_431_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_431_RESET                                                  0x0

// 0x16c0 (RXPCU_RXBUF_432)
#define RXPCU_RXBUF_DATA_432_LSB                                               0
#define RXPCU_RXBUF_DATA_432_MSB                                               31
#define RXPCU_RXBUF_DATA_432_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_432_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_432_MASK) >> RXPCU_RXBUF_DATA_432_LSB)
#define RXPCU_RXBUF_DATA_432_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_432_LSB) & RXPCU_RXBUF_DATA_432_MASK)
#define RXPCU_RXBUF_DATA_432_RESET                                             0x0
#define RXPCU_RXBUF_432_ADDRESS                                                (0x16c0 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_432_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_432_RESET                                                  0x0

// 0x16c4 (RXPCU_RXBUF_433)
#define RXPCU_RXBUF_DATA_433_LSB                                               0
#define RXPCU_RXBUF_DATA_433_MSB                                               31
#define RXPCU_RXBUF_DATA_433_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_433_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_433_MASK) >> RXPCU_RXBUF_DATA_433_LSB)
#define RXPCU_RXBUF_DATA_433_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_433_LSB) & RXPCU_RXBUF_DATA_433_MASK)
#define RXPCU_RXBUF_DATA_433_RESET                                             0x0
#define RXPCU_RXBUF_433_ADDRESS                                                (0x16c4 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_433_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_433_RESET                                                  0x0

// 0x16c8 (RXPCU_RXBUF_434)
#define RXPCU_RXBUF_DATA_434_LSB                                               0
#define RXPCU_RXBUF_DATA_434_MSB                                               31
#define RXPCU_RXBUF_DATA_434_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_434_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_434_MASK) >> RXPCU_RXBUF_DATA_434_LSB)
#define RXPCU_RXBUF_DATA_434_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_434_LSB) & RXPCU_RXBUF_DATA_434_MASK)
#define RXPCU_RXBUF_DATA_434_RESET                                             0x0
#define RXPCU_RXBUF_434_ADDRESS                                                (0x16c8 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_434_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_434_RESET                                                  0x0

// 0x16cc (RXPCU_RXBUF_435)
#define RXPCU_RXBUF_DATA_435_LSB                                               0
#define RXPCU_RXBUF_DATA_435_MSB                                               31
#define RXPCU_RXBUF_DATA_435_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_435_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_435_MASK) >> RXPCU_RXBUF_DATA_435_LSB)
#define RXPCU_RXBUF_DATA_435_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_435_LSB) & RXPCU_RXBUF_DATA_435_MASK)
#define RXPCU_RXBUF_DATA_435_RESET                                             0x0
#define RXPCU_RXBUF_435_ADDRESS                                                (0x16cc + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_435_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_435_RESET                                                  0x0

// 0x16d0 (RXPCU_RXBUF_436)
#define RXPCU_RXBUF_DATA_436_LSB                                               0
#define RXPCU_RXBUF_DATA_436_MSB                                               31
#define RXPCU_RXBUF_DATA_436_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_436_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_436_MASK) >> RXPCU_RXBUF_DATA_436_LSB)
#define RXPCU_RXBUF_DATA_436_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_436_LSB) & RXPCU_RXBUF_DATA_436_MASK)
#define RXPCU_RXBUF_DATA_436_RESET                                             0x0
#define RXPCU_RXBUF_436_ADDRESS                                                (0x16d0 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_436_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_436_RESET                                                  0x0

// 0x16d4 (RXPCU_RXBUF_437)
#define RXPCU_RXBUF_DATA_437_LSB                                               0
#define RXPCU_RXBUF_DATA_437_MSB                                               31
#define RXPCU_RXBUF_DATA_437_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_437_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_437_MASK) >> RXPCU_RXBUF_DATA_437_LSB)
#define RXPCU_RXBUF_DATA_437_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_437_LSB) & RXPCU_RXBUF_DATA_437_MASK)
#define RXPCU_RXBUF_DATA_437_RESET                                             0x0
#define RXPCU_RXBUF_437_ADDRESS                                                (0x16d4 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_437_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_437_RESET                                                  0x0

// 0x16d8 (RXPCU_RXBUF_438)
#define RXPCU_RXBUF_DATA_438_LSB                                               0
#define RXPCU_RXBUF_DATA_438_MSB                                               31
#define RXPCU_RXBUF_DATA_438_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_438_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_438_MASK) >> RXPCU_RXBUF_DATA_438_LSB)
#define RXPCU_RXBUF_DATA_438_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_438_LSB) & RXPCU_RXBUF_DATA_438_MASK)
#define RXPCU_RXBUF_DATA_438_RESET                                             0x0
#define RXPCU_RXBUF_438_ADDRESS                                                (0x16d8 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_438_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_438_RESET                                                  0x0

// 0x16dc (RXPCU_RXBUF_439)
#define RXPCU_RXBUF_DATA_439_LSB                                               0
#define RXPCU_RXBUF_DATA_439_MSB                                               31
#define RXPCU_RXBUF_DATA_439_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_439_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_439_MASK) >> RXPCU_RXBUF_DATA_439_LSB)
#define RXPCU_RXBUF_DATA_439_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_439_LSB) & RXPCU_RXBUF_DATA_439_MASK)
#define RXPCU_RXBUF_DATA_439_RESET                                             0x0
#define RXPCU_RXBUF_439_ADDRESS                                                (0x16dc + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_439_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_439_RESET                                                  0x0

// 0x16e0 (RXPCU_RXBUF_440)
#define RXPCU_RXBUF_DATA_440_LSB                                               0
#define RXPCU_RXBUF_DATA_440_MSB                                               31
#define RXPCU_RXBUF_DATA_440_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_440_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_440_MASK) >> RXPCU_RXBUF_DATA_440_LSB)
#define RXPCU_RXBUF_DATA_440_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_440_LSB) & RXPCU_RXBUF_DATA_440_MASK)
#define RXPCU_RXBUF_DATA_440_RESET                                             0x0
#define RXPCU_RXBUF_440_ADDRESS                                                (0x16e0 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_440_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_440_RESET                                                  0x0

// 0x16e4 (RXPCU_RXBUF_441)
#define RXPCU_RXBUF_DATA_441_LSB                                               0
#define RXPCU_RXBUF_DATA_441_MSB                                               31
#define RXPCU_RXBUF_DATA_441_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_441_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_441_MASK) >> RXPCU_RXBUF_DATA_441_LSB)
#define RXPCU_RXBUF_DATA_441_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_441_LSB) & RXPCU_RXBUF_DATA_441_MASK)
#define RXPCU_RXBUF_DATA_441_RESET                                             0x0
#define RXPCU_RXBUF_441_ADDRESS                                                (0x16e4 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_441_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_441_RESET                                                  0x0

// 0x16e8 (RXPCU_RXBUF_442)
#define RXPCU_RXBUF_DATA_442_LSB                                               0
#define RXPCU_RXBUF_DATA_442_MSB                                               31
#define RXPCU_RXBUF_DATA_442_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_442_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_442_MASK) >> RXPCU_RXBUF_DATA_442_LSB)
#define RXPCU_RXBUF_DATA_442_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_442_LSB) & RXPCU_RXBUF_DATA_442_MASK)
#define RXPCU_RXBUF_DATA_442_RESET                                             0x0
#define RXPCU_RXBUF_442_ADDRESS                                                (0x16e8 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_442_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_442_RESET                                                  0x0

// 0x16ec (RXPCU_RXBUF_443)
#define RXPCU_RXBUF_DATA_443_LSB                                               0
#define RXPCU_RXBUF_DATA_443_MSB                                               31
#define RXPCU_RXBUF_DATA_443_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_443_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_443_MASK) >> RXPCU_RXBUF_DATA_443_LSB)
#define RXPCU_RXBUF_DATA_443_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_443_LSB) & RXPCU_RXBUF_DATA_443_MASK)
#define RXPCU_RXBUF_DATA_443_RESET                                             0x0
#define RXPCU_RXBUF_443_ADDRESS                                                (0x16ec + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_443_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_443_RESET                                                  0x0

// 0x16f0 (RXPCU_RXBUF_444)
#define RXPCU_RXBUF_DATA_444_LSB                                               0
#define RXPCU_RXBUF_DATA_444_MSB                                               31
#define RXPCU_RXBUF_DATA_444_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_444_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_444_MASK) >> RXPCU_RXBUF_DATA_444_LSB)
#define RXPCU_RXBUF_DATA_444_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_444_LSB) & RXPCU_RXBUF_DATA_444_MASK)
#define RXPCU_RXBUF_DATA_444_RESET                                             0x0
#define RXPCU_RXBUF_444_ADDRESS                                                (0x16f0 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_444_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_444_RESET                                                  0x0

// 0x16f4 (RXPCU_RXBUF_445)
#define RXPCU_RXBUF_DATA_445_LSB                                               0
#define RXPCU_RXBUF_DATA_445_MSB                                               31
#define RXPCU_RXBUF_DATA_445_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_445_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_445_MASK) >> RXPCU_RXBUF_DATA_445_LSB)
#define RXPCU_RXBUF_DATA_445_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_445_LSB) & RXPCU_RXBUF_DATA_445_MASK)
#define RXPCU_RXBUF_DATA_445_RESET                                             0x0
#define RXPCU_RXBUF_445_ADDRESS                                                (0x16f4 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_445_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_445_RESET                                                  0x0

// 0x16f8 (RXPCU_RXBUF_446)
#define RXPCU_RXBUF_DATA_446_LSB                                               0
#define RXPCU_RXBUF_DATA_446_MSB                                               31
#define RXPCU_RXBUF_DATA_446_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_446_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_446_MASK) >> RXPCU_RXBUF_DATA_446_LSB)
#define RXPCU_RXBUF_DATA_446_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_446_LSB) & RXPCU_RXBUF_DATA_446_MASK)
#define RXPCU_RXBUF_DATA_446_RESET                                             0x0
#define RXPCU_RXBUF_446_ADDRESS                                                (0x16f8 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_446_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_446_RESET                                                  0x0

// 0x16fc (RXPCU_RXBUF_447)
#define RXPCU_RXBUF_DATA_447_LSB                                               0
#define RXPCU_RXBUF_DATA_447_MSB                                               31
#define RXPCU_RXBUF_DATA_447_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_447_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_447_MASK) >> RXPCU_RXBUF_DATA_447_LSB)
#define RXPCU_RXBUF_DATA_447_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_447_LSB) & RXPCU_RXBUF_DATA_447_MASK)
#define RXPCU_RXBUF_DATA_447_RESET                                             0x0
#define RXPCU_RXBUF_447_ADDRESS                                                (0x16fc + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_447_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_447_RESET                                                  0x0

// 0x1700 (RXPCU_RXBUF_448)
#define RXPCU_RXBUF_DATA_448_LSB                                               0
#define RXPCU_RXBUF_DATA_448_MSB                                               31
#define RXPCU_RXBUF_DATA_448_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_448_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_448_MASK) >> RXPCU_RXBUF_DATA_448_LSB)
#define RXPCU_RXBUF_DATA_448_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_448_LSB) & RXPCU_RXBUF_DATA_448_MASK)
#define RXPCU_RXBUF_DATA_448_RESET                                             0x0
#define RXPCU_RXBUF_448_ADDRESS                                                (0x1700 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_448_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_448_RESET                                                  0x0

// 0x1704 (RXPCU_RXBUF_449)
#define RXPCU_RXBUF_DATA_449_LSB                                               0
#define RXPCU_RXBUF_DATA_449_MSB                                               31
#define RXPCU_RXBUF_DATA_449_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_449_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_449_MASK) >> RXPCU_RXBUF_DATA_449_LSB)
#define RXPCU_RXBUF_DATA_449_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_449_LSB) & RXPCU_RXBUF_DATA_449_MASK)
#define RXPCU_RXBUF_DATA_449_RESET                                             0x0
#define RXPCU_RXBUF_449_ADDRESS                                                (0x1704 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_449_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_449_RESET                                                  0x0

// 0x1708 (RXPCU_RXBUF_450)
#define RXPCU_RXBUF_DATA_450_LSB                                               0
#define RXPCU_RXBUF_DATA_450_MSB                                               31
#define RXPCU_RXBUF_DATA_450_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_450_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_450_MASK) >> RXPCU_RXBUF_DATA_450_LSB)
#define RXPCU_RXBUF_DATA_450_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_450_LSB) & RXPCU_RXBUF_DATA_450_MASK)
#define RXPCU_RXBUF_DATA_450_RESET                                             0x0
#define RXPCU_RXBUF_450_ADDRESS                                                (0x1708 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_450_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_450_RESET                                                  0x0

// 0x170c (RXPCU_RXBUF_451)
#define RXPCU_RXBUF_DATA_451_LSB                                               0
#define RXPCU_RXBUF_DATA_451_MSB                                               31
#define RXPCU_RXBUF_DATA_451_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_451_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_451_MASK) >> RXPCU_RXBUF_DATA_451_LSB)
#define RXPCU_RXBUF_DATA_451_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_451_LSB) & RXPCU_RXBUF_DATA_451_MASK)
#define RXPCU_RXBUF_DATA_451_RESET                                             0x0
#define RXPCU_RXBUF_451_ADDRESS                                                (0x170c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_451_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_451_RESET                                                  0x0

// 0x1710 (RXPCU_RXBUF_452)
#define RXPCU_RXBUF_DATA_452_LSB                                               0
#define RXPCU_RXBUF_DATA_452_MSB                                               31
#define RXPCU_RXBUF_DATA_452_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_452_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_452_MASK) >> RXPCU_RXBUF_DATA_452_LSB)
#define RXPCU_RXBUF_DATA_452_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_452_LSB) & RXPCU_RXBUF_DATA_452_MASK)
#define RXPCU_RXBUF_DATA_452_RESET                                             0x0
#define RXPCU_RXBUF_452_ADDRESS                                                (0x1710 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_452_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_452_RESET                                                  0x0

// 0x1714 (RXPCU_RXBUF_453)
#define RXPCU_RXBUF_DATA_453_LSB                                               0
#define RXPCU_RXBUF_DATA_453_MSB                                               31
#define RXPCU_RXBUF_DATA_453_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_453_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_453_MASK) >> RXPCU_RXBUF_DATA_453_LSB)
#define RXPCU_RXBUF_DATA_453_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_453_LSB) & RXPCU_RXBUF_DATA_453_MASK)
#define RXPCU_RXBUF_DATA_453_RESET                                             0x0
#define RXPCU_RXBUF_453_ADDRESS                                                (0x1714 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_453_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_453_RESET                                                  0x0

// 0x1718 (RXPCU_RXBUF_454)
#define RXPCU_RXBUF_DATA_454_LSB                                               0
#define RXPCU_RXBUF_DATA_454_MSB                                               31
#define RXPCU_RXBUF_DATA_454_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_454_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_454_MASK) >> RXPCU_RXBUF_DATA_454_LSB)
#define RXPCU_RXBUF_DATA_454_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_454_LSB) & RXPCU_RXBUF_DATA_454_MASK)
#define RXPCU_RXBUF_DATA_454_RESET                                             0x0
#define RXPCU_RXBUF_454_ADDRESS                                                (0x1718 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_454_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_454_RESET                                                  0x0

// 0x171c (RXPCU_RXBUF_455)
#define RXPCU_RXBUF_DATA_455_LSB                                               0
#define RXPCU_RXBUF_DATA_455_MSB                                               31
#define RXPCU_RXBUF_DATA_455_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_455_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_455_MASK) >> RXPCU_RXBUF_DATA_455_LSB)
#define RXPCU_RXBUF_DATA_455_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_455_LSB) & RXPCU_RXBUF_DATA_455_MASK)
#define RXPCU_RXBUF_DATA_455_RESET                                             0x0
#define RXPCU_RXBUF_455_ADDRESS                                                (0x171c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_455_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_455_RESET                                                  0x0

// 0x1720 (RXPCU_RXBUF_456)
#define RXPCU_RXBUF_DATA_456_LSB                                               0
#define RXPCU_RXBUF_DATA_456_MSB                                               31
#define RXPCU_RXBUF_DATA_456_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_456_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_456_MASK) >> RXPCU_RXBUF_DATA_456_LSB)
#define RXPCU_RXBUF_DATA_456_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_456_LSB) & RXPCU_RXBUF_DATA_456_MASK)
#define RXPCU_RXBUF_DATA_456_RESET                                             0x0
#define RXPCU_RXBUF_456_ADDRESS                                                (0x1720 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_456_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_456_RESET                                                  0x0

// 0x1724 (RXPCU_RXBUF_457)
#define RXPCU_RXBUF_DATA_457_LSB                                               0
#define RXPCU_RXBUF_DATA_457_MSB                                               31
#define RXPCU_RXBUF_DATA_457_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_457_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_457_MASK) >> RXPCU_RXBUF_DATA_457_LSB)
#define RXPCU_RXBUF_DATA_457_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_457_LSB) & RXPCU_RXBUF_DATA_457_MASK)
#define RXPCU_RXBUF_DATA_457_RESET                                             0x0
#define RXPCU_RXBUF_457_ADDRESS                                                (0x1724 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_457_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_457_RESET                                                  0x0

// 0x1728 (RXPCU_RXBUF_458)
#define RXPCU_RXBUF_DATA_458_LSB                                               0
#define RXPCU_RXBUF_DATA_458_MSB                                               31
#define RXPCU_RXBUF_DATA_458_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_458_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_458_MASK) >> RXPCU_RXBUF_DATA_458_LSB)
#define RXPCU_RXBUF_DATA_458_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_458_LSB) & RXPCU_RXBUF_DATA_458_MASK)
#define RXPCU_RXBUF_DATA_458_RESET                                             0x0
#define RXPCU_RXBUF_458_ADDRESS                                                (0x1728 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_458_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_458_RESET                                                  0x0

// 0x172c (RXPCU_RXBUF_459)
#define RXPCU_RXBUF_DATA_459_LSB                                               0
#define RXPCU_RXBUF_DATA_459_MSB                                               31
#define RXPCU_RXBUF_DATA_459_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_459_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_459_MASK) >> RXPCU_RXBUF_DATA_459_LSB)
#define RXPCU_RXBUF_DATA_459_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_459_LSB) & RXPCU_RXBUF_DATA_459_MASK)
#define RXPCU_RXBUF_DATA_459_RESET                                             0x0
#define RXPCU_RXBUF_459_ADDRESS                                                (0x172c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_459_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_459_RESET                                                  0x0

// 0x1730 (RXPCU_RXBUF_460)
#define RXPCU_RXBUF_DATA_460_LSB                                               0
#define RXPCU_RXBUF_DATA_460_MSB                                               31
#define RXPCU_RXBUF_DATA_460_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_460_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_460_MASK) >> RXPCU_RXBUF_DATA_460_LSB)
#define RXPCU_RXBUF_DATA_460_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_460_LSB) & RXPCU_RXBUF_DATA_460_MASK)
#define RXPCU_RXBUF_DATA_460_RESET                                             0x0
#define RXPCU_RXBUF_460_ADDRESS                                                (0x1730 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_460_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_460_RESET                                                  0x0

// 0x1734 (RXPCU_RXBUF_461)
#define RXPCU_RXBUF_DATA_461_LSB                                               0
#define RXPCU_RXBUF_DATA_461_MSB                                               31
#define RXPCU_RXBUF_DATA_461_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_461_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_461_MASK) >> RXPCU_RXBUF_DATA_461_LSB)
#define RXPCU_RXBUF_DATA_461_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_461_LSB) & RXPCU_RXBUF_DATA_461_MASK)
#define RXPCU_RXBUF_DATA_461_RESET                                             0x0
#define RXPCU_RXBUF_461_ADDRESS                                                (0x1734 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_461_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_461_RESET                                                  0x0

// 0x1738 (RXPCU_RXBUF_462)
#define RXPCU_RXBUF_DATA_462_LSB                                               0
#define RXPCU_RXBUF_DATA_462_MSB                                               31
#define RXPCU_RXBUF_DATA_462_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_462_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_462_MASK) >> RXPCU_RXBUF_DATA_462_LSB)
#define RXPCU_RXBUF_DATA_462_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_462_LSB) & RXPCU_RXBUF_DATA_462_MASK)
#define RXPCU_RXBUF_DATA_462_RESET                                             0x0
#define RXPCU_RXBUF_462_ADDRESS                                                (0x1738 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_462_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_462_RESET                                                  0x0

// 0x173c (RXPCU_RXBUF_463)
#define RXPCU_RXBUF_DATA_463_LSB                                               0
#define RXPCU_RXBUF_DATA_463_MSB                                               31
#define RXPCU_RXBUF_DATA_463_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_463_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_463_MASK) >> RXPCU_RXBUF_DATA_463_LSB)
#define RXPCU_RXBUF_DATA_463_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_463_LSB) & RXPCU_RXBUF_DATA_463_MASK)
#define RXPCU_RXBUF_DATA_463_RESET                                             0x0
#define RXPCU_RXBUF_463_ADDRESS                                                (0x173c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_463_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_463_RESET                                                  0x0

// 0x1740 (RXPCU_RXBUF_464)
#define RXPCU_RXBUF_DATA_464_LSB                                               0
#define RXPCU_RXBUF_DATA_464_MSB                                               31
#define RXPCU_RXBUF_DATA_464_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_464_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_464_MASK) >> RXPCU_RXBUF_DATA_464_LSB)
#define RXPCU_RXBUF_DATA_464_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_464_LSB) & RXPCU_RXBUF_DATA_464_MASK)
#define RXPCU_RXBUF_DATA_464_RESET                                             0x0
#define RXPCU_RXBUF_464_ADDRESS                                                (0x1740 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_464_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_464_RESET                                                  0x0

// 0x1744 (RXPCU_RXBUF_465)
#define RXPCU_RXBUF_DATA_465_LSB                                               0
#define RXPCU_RXBUF_DATA_465_MSB                                               31
#define RXPCU_RXBUF_DATA_465_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_465_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_465_MASK) >> RXPCU_RXBUF_DATA_465_LSB)
#define RXPCU_RXBUF_DATA_465_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_465_LSB) & RXPCU_RXBUF_DATA_465_MASK)
#define RXPCU_RXBUF_DATA_465_RESET                                             0x0
#define RXPCU_RXBUF_465_ADDRESS                                                (0x1744 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_465_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_465_RESET                                                  0x0

// 0x1748 (RXPCU_RXBUF_466)
#define RXPCU_RXBUF_DATA_466_LSB                                               0
#define RXPCU_RXBUF_DATA_466_MSB                                               31
#define RXPCU_RXBUF_DATA_466_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_466_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_466_MASK) >> RXPCU_RXBUF_DATA_466_LSB)
#define RXPCU_RXBUF_DATA_466_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_466_LSB) & RXPCU_RXBUF_DATA_466_MASK)
#define RXPCU_RXBUF_DATA_466_RESET                                             0x0
#define RXPCU_RXBUF_466_ADDRESS                                                (0x1748 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_466_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_466_RESET                                                  0x0

// 0x174c (RXPCU_RXBUF_467)
#define RXPCU_RXBUF_DATA_467_LSB                                               0
#define RXPCU_RXBUF_DATA_467_MSB                                               31
#define RXPCU_RXBUF_DATA_467_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_467_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_467_MASK) >> RXPCU_RXBUF_DATA_467_LSB)
#define RXPCU_RXBUF_DATA_467_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_467_LSB) & RXPCU_RXBUF_DATA_467_MASK)
#define RXPCU_RXBUF_DATA_467_RESET                                             0x0
#define RXPCU_RXBUF_467_ADDRESS                                                (0x174c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_467_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_467_RESET                                                  0x0

// 0x1750 (RXPCU_RXBUF_468)
#define RXPCU_RXBUF_DATA_468_LSB                                               0
#define RXPCU_RXBUF_DATA_468_MSB                                               31
#define RXPCU_RXBUF_DATA_468_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_468_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_468_MASK) >> RXPCU_RXBUF_DATA_468_LSB)
#define RXPCU_RXBUF_DATA_468_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_468_LSB) & RXPCU_RXBUF_DATA_468_MASK)
#define RXPCU_RXBUF_DATA_468_RESET                                             0x0
#define RXPCU_RXBUF_468_ADDRESS                                                (0x1750 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_468_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_468_RESET                                                  0x0

// 0x1754 (RXPCU_RXBUF_469)
#define RXPCU_RXBUF_DATA_469_LSB                                               0
#define RXPCU_RXBUF_DATA_469_MSB                                               31
#define RXPCU_RXBUF_DATA_469_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_469_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_469_MASK) >> RXPCU_RXBUF_DATA_469_LSB)
#define RXPCU_RXBUF_DATA_469_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_469_LSB) & RXPCU_RXBUF_DATA_469_MASK)
#define RXPCU_RXBUF_DATA_469_RESET                                             0x0
#define RXPCU_RXBUF_469_ADDRESS                                                (0x1754 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_469_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_469_RESET                                                  0x0

// 0x1758 (RXPCU_RXBUF_470)
#define RXPCU_RXBUF_DATA_470_LSB                                               0
#define RXPCU_RXBUF_DATA_470_MSB                                               31
#define RXPCU_RXBUF_DATA_470_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_470_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_470_MASK) >> RXPCU_RXBUF_DATA_470_LSB)
#define RXPCU_RXBUF_DATA_470_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_470_LSB) & RXPCU_RXBUF_DATA_470_MASK)
#define RXPCU_RXBUF_DATA_470_RESET                                             0x0
#define RXPCU_RXBUF_470_ADDRESS                                                (0x1758 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_470_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_470_RESET                                                  0x0

// 0x175c (RXPCU_RXBUF_471)
#define RXPCU_RXBUF_DATA_471_LSB                                               0
#define RXPCU_RXBUF_DATA_471_MSB                                               31
#define RXPCU_RXBUF_DATA_471_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_471_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_471_MASK) >> RXPCU_RXBUF_DATA_471_LSB)
#define RXPCU_RXBUF_DATA_471_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_471_LSB) & RXPCU_RXBUF_DATA_471_MASK)
#define RXPCU_RXBUF_DATA_471_RESET                                             0x0
#define RXPCU_RXBUF_471_ADDRESS                                                (0x175c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_471_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_471_RESET                                                  0x0

// 0x1760 (RXPCU_RXBUF_472)
#define RXPCU_RXBUF_DATA_472_LSB                                               0
#define RXPCU_RXBUF_DATA_472_MSB                                               31
#define RXPCU_RXBUF_DATA_472_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_472_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_472_MASK) >> RXPCU_RXBUF_DATA_472_LSB)
#define RXPCU_RXBUF_DATA_472_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_472_LSB) & RXPCU_RXBUF_DATA_472_MASK)
#define RXPCU_RXBUF_DATA_472_RESET                                             0x0
#define RXPCU_RXBUF_472_ADDRESS                                                (0x1760 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_472_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_472_RESET                                                  0x0

// 0x1764 (RXPCU_RXBUF_473)
#define RXPCU_RXBUF_DATA_473_LSB                                               0
#define RXPCU_RXBUF_DATA_473_MSB                                               31
#define RXPCU_RXBUF_DATA_473_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_473_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_473_MASK) >> RXPCU_RXBUF_DATA_473_LSB)
#define RXPCU_RXBUF_DATA_473_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_473_LSB) & RXPCU_RXBUF_DATA_473_MASK)
#define RXPCU_RXBUF_DATA_473_RESET                                             0x0
#define RXPCU_RXBUF_473_ADDRESS                                                (0x1764 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_473_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_473_RESET                                                  0x0

// 0x1768 (RXPCU_RXBUF_474)
#define RXPCU_RXBUF_DATA_474_LSB                                               0
#define RXPCU_RXBUF_DATA_474_MSB                                               31
#define RXPCU_RXBUF_DATA_474_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_474_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_474_MASK) >> RXPCU_RXBUF_DATA_474_LSB)
#define RXPCU_RXBUF_DATA_474_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_474_LSB) & RXPCU_RXBUF_DATA_474_MASK)
#define RXPCU_RXBUF_DATA_474_RESET                                             0x0
#define RXPCU_RXBUF_474_ADDRESS                                                (0x1768 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_474_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_474_RESET                                                  0x0

// 0x176c (RXPCU_RXBUF_475)
#define RXPCU_RXBUF_DATA_475_LSB                                               0
#define RXPCU_RXBUF_DATA_475_MSB                                               31
#define RXPCU_RXBUF_DATA_475_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_475_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_475_MASK) >> RXPCU_RXBUF_DATA_475_LSB)
#define RXPCU_RXBUF_DATA_475_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_475_LSB) & RXPCU_RXBUF_DATA_475_MASK)
#define RXPCU_RXBUF_DATA_475_RESET                                             0x0
#define RXPCU_RXBUF_475_ADDRESS                                                (0x176c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_475_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_475_RESET                                                  0x0

// 0x1770 (RXPCU_RXBUF_476)
#define RXPCU_RXBUF_DATA_476_LSB                                               0
#define RXPCU_RXBUF_DATA_476_MSB                                               31
#define RXPCU_RXBUF_DATA_476_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_476_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_476_MASK) >> RXPCU_RXBUF_DATA_476_LSB)
#define RXPCU_RXBUF_DATA_476_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_476_LSB) & RXPCU_RXBUF_DATA_476_MASK)
#define RXPCU_RXBUF_DATA_476_RESET                                             0x0
#define RXPCU_RXBUF_476_ADDRESS                                                (0x1770 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_476_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_476_RESET                                                  0x0

// 0x1774 (RXPCU_RXBUF_477)
#define RXPCU_RXBUF_DATA_477_LSB                                               0
#define RXPCU_RXBUF_DATA_477_MSB                                               31
#define RXPCU_RXBUF_DATA_477_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_477_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_477_MASK) >> RXPCU_RXBUF_DATA_477_LSB)
#define RXPCU_RXBUF_DATA_477_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_477_LSB) & RXPCU_RXBUF_DATA_477_MASK)
#define RXPCU_RXBUF_DATA_477_RESET                                             0x0
#define RXPCU_RXBUF_477_ADDRESS                                                (0x1774 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_477_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_477_RESET                                                  0x0

// 0x1778 (RXPCU_RXBUF_478)
#define RXPCU_RXBUF_DATA_478_LSB                                               0
#define RXPCU_RXBUF_DATA_478_MSB                                               31
#define RXPCU_RXBUF_DATA_478_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_478_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_478_MASK) >> RXPCU_RXBUF_DATA_478_LSB)
#define RXPCU_RXBUF_DATA_478_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_478_LSB) & RXPCU_RXBUF_DATA_478_MASK)
#define RXPCU_RXBUF_DATA_478_RESET                                             0x0
#define RXPCU_RXBUF_478_ADDRESS                                                (0x1778 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_478_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_478_RESET                                                  0x0

// 0x177c (RXPCU_RXBUF_479)
#define RXPCU_RXBUF_DATA_479_LSB                                               0
#define RXPCU_RXBUF_DATA_479_MSB                                               31
#define RXPCU_RXBUF_DATA_479_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_479_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_479_MASK) >> RXPCU_RXBUF_DATA_479_LSB)
#define RXPCU_RXBUF_DATA_479_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_479_LSB) & RXPCU_RXBUF_DATA_479_MASK)
#define RXPCU_RXBUF_DATA_479_RESET                                             0x0
#define RXPCU_RXBUF_479_ADDRESS                                                (0x177c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_479_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_479_RESET                                                  0x0

// 0x1780 (RXPCU_RXBUF_480)
#define RXPCU_RXBUF_DATA_480_LSB                                               0
#define RXPCU_RXBUF_DATA_480_MSB                                               31
#define RXPCU_RXBUF_DATA_480_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_480_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_480_MASK) >> RXPCU_RXBUF_DATA_480_LSB)
#define RXPCU_RXBUF_DATA_480_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_480_LSB) & RXPCU_RXBUF_DATA_480_MASK)
#define RXPCU_RXBUF_DATA_480_RESET                                             0x0
#define RXPCU_RXBUF_480_ADDRESS                                                (0x1780 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_480_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_480_RESET                                                  0x0

// 0x1784 (RXPCU_RXBUF_481)
#define RXPCU_RXBUF_DATA_481_LSB                                               0
#define RXPCU_RXBUF_DATA_481_MSB                                               31
#define RXPCU_RXBUF_DATA_481_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_481_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_481_MASK) >> RXPCU_RXBUF_DATA_481_LSB)
#define RXPCU_RXBUF_DATA_481_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_481_LSB) & RXPCU_RXBUF_DATA_481_MASK)
#define RXPCU_RXBUF_DATA_481_RESET                                             0x0
#define RXPCU_RXBUF_481_ADDRESS                                                (0x1784 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_481_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_481_RESET                                                  0x0

// 0x1788 (RXPCU_RXBUF_482)
#define RXPCU_RXBUF_DATA_482_LSB                                               0
#define RXPCU_RXBUF_DATA_482_MSB                                               31
#define RXPCU_RXBUF_DATA_482_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_482_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_482_MASK) >> RXPCU_RXBUF_DATA_482_LSB)
#define RXPCU_RXBUF_DATA_482_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_482_LSB) & RXPCU_RXBUF_DATA_482_MASK)
#define RXPCU_RXBUF_DATA_482_RESET                                             0x0
#define RXPCU_RXBUF_482_ADDRESS                                                (0x1788 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_482_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_482_RESET                                                  0x0

// 0x178c (RXPCU_RXBUF_483)
#define RXPCU_RXBUF_DATA_483_LSB                                               0
#define RXPCU_RXBUF_DATA_483_MSB                                               31
#define RXPCU_RXBUF_DATA_483_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_483_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_483_MASK) >> RXPCU_RXBUF_DATA_483_LSB)
#define RXPCU_RXBUF_DATA_483_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_483_LSB) & RXPCU_RXBUF_DATA_483_MASK)
#define RXPCU_RXBUF_DATA_483_RESET                                             0x0
#define RXPCU_RXBUF_483_ADDRESS                                                (0x178c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_483_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_483_RESET                                                  0x0

// 0x1790 (RXPCU_RXBUF_484)
#define RXPCU_RXBUF_DATA_484_LSB                                               0
#define RXPCU_RXBUF_DATA_484_MSB                                               31
#define RXPCU_RXBUF_DATA_484_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_484_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_484_MASK) >> RXPCU_RXBUF_DATA_484_LSB)
#define RXPCU_RXBUF_DATA_484_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_484_LSB) & RXPCU_RXBUF_DATA_484_MASK)
#define RXPCU_RXBUF_DATA_484_RESET                                             0x0
#define RXPCU_RXBUF_484_ADDRESS                                                (0x1790 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_484_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_484_RESET                                                  0x0

// 0x1794 (RXPCU_RXBUF_485)
#define RXPCU_RXBUF_DATA_485_LSB                                               0
#define RXPCU_RXBUF_DATA_485_MSB                                               31
#define RXPCU_RXBUF_DATA_485_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_485_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_485_MASK) >> RXPCU_RXBUF_DATA_485_LSB)
#define RXPCU_RXBUF_DATA_485_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_485_LSB) & RXPCU_RXBUF_DATA_485_MASK)
#define RXPCU_RXBUF_DATA_485_RESET                                             0x0
#define RXPCU_RXBUF_485_ADDRESS                                                (0x1794 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_485_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_485_RESET                                                  0x0

// 0x1798 (RXPCU_RXBUF_486)
#define RXPCU_RXBUF_DATA_486_LSB                                               0
#define RXPCU_RXBUF_DATA_486_MSB                                               31
#define RXPCU_RXBUF_DATA_486_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_486_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_486_MASK) >> RXPCU_RXBUF_DATA_486_LSB)
#define RXPCU_RXBUF_DATA_486_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_486_LSB) & RXPCU_RXBUF_DATA_486_MASK)
#define RXPCU_RXBUF_DATA_486_RESET                                             0x0
#define RXPCU_RXBUF_486_ADDRESS                                                (0x1798 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_486_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_486_RESET                                                  0x0

// 0x179c (RXPCU_RXBUF_487)
#define RXPCU_RXBUF_DATA_487_LSB                                               0
#define RXPCU_RXBUF_DATA_487_MSB                                               31
#define RXPCU_RXBUF_DATA_487_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_487_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_487_MASK) >> RXPCU_RXBUF_DATA_487_LSB)
#define RXPCU_RXBUF_DATA_487_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_487_LSB) & RXPCU_RXBUF_DATA_487_MASK)
#define RXPCU_RXBUF_DATA_487_RESET                                             0x0
#define RXPCU_RXBUF_487_ADDRESS                                                (0x179c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_487_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_487_RESET                                                  0x0

// 0x17a0 (RXPCU_RXBUF_488)
#define RXPCU_RXBUF_DATA_488_LSB                                               0
#define RXPCU_RXBUF_DATA_488_MSB                                               31
#define RXPCU_RXBUF_DATA_488_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_488_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_488_MASK) >> RXPCU_RXBUF_DATA_488_LSB)
#define RXPCU_RXBUF_DATA_488_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_488_LSB) & RXPCU_RXBUF_DATA_488_MASK)
#define RXPCU_RXBUF_DATA_488_RESET                                             0x0
#define RXPCU_RXBUF_488_ADDRESS                                                (0x17a0 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_488_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_488_RESET                                                  0x0

// 0x17a4 (RXPCU_RXBUF_489)
#define RXPCU_RXBUF_DATA_489_LSB                                               0
#define RXPCU_RXBUF_DATA_489_MSB                                               31
#define RXPCU_RXBUF_DATA_489_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_489_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_489_MASK) >> RXPCU_RXBUF_DATA_489_LSB)
#define RXPCU_RXBUF_DATA_489_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_489_LSB) & RXPCU_RXBUF_DATA_489_MASK)
#define RXPCU_RXBUF_DATA_489_RESET                                             0x0
#define RXPCU_RXBUF_489_ADDRESS                                                (0x17a4 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_489_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_489_RESET                                                  0x0

// 0x17a8 (RXPCU_RXBUF_490)
#define RXPCU_RXBUF_DATA_490_LSB                                               0
#define RXPCU_RXBUF_DATA_490_MSB                                               31
#define RXPCU_RXBUF_DATA_490_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_490_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_490_MASK) >> RXPCU_RXBUF_DATA_490_LSB)
#define RXPCU_RXBUF_DATA_490_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_490_LSB) & RXPCU_RXBUF_DATA_490_MASK)
#define RXPCU_RXBUF_DATA_490_RESET                                             0x0
#define RXPCU_RXBUF_490_ADDRESS                                                (0x17a8 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_490_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_490_RESET                                                  0x0

// 0x17ac (RXPCU_RXBUF_491)
#define RXPCU_RXBUF_DATA_491_LSB                                               0
#define RXPCU_RXBUF_DATA_491_MSB                                               31
#define RXPCU_RXBUF_DATA_491_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_491_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_491_MASK) >> RXPCU_RXBUF_DATA_491_LSB)
#define RXPCU_RXBUF_DATA_491_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_491_LSB) & RXPCU_RXBUF_DATA_491_MASK)
#define RXPCU_RXBUF_DATA_491_RESET                                             0x0
#define RXPCU_RXBUF_491_ADDRESS                                                (0x17ac + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_491_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_491_RESET                                                  0x0

// 0x17b0 (RXPCU_RXBUF_492)
#define RXPCU_RXBUF_DATA_492_LSB                                               0
#define RXPCU_RXBUF_DATA_492_MSB                                               31
#define RXPCU_RXBUF_DATA_492_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_492_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_492_MASK) >> RXPCU_RXBUF_DATA_492_LSB)
#define RXPCU_RXBUF_DATA_492_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_492_LSB) & RXPCU_RXBUF_DATA_492_MASK)
#define RXPCU_RXBUF_DATA_492_RESET                                             0x0
#define RXPCU_RXBUF_492_ADDRESS                                                (0x17b0 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_492_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_492_RESET                                                  0x0

// 0x17b4 (RXPCU_RXBUF_493)
#define RXPCU_RXBUF_DATA_493_LSB                                               0
#define RXPCU_RXBUF_DATA_493_MSB                                               31
#define RXPCU_RXBUF_DATA_493_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_493_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_493_MASK) >> RXPCU_RXBUF_DATA_493_LSB)
#define RXPCU_RXBUF_DATA_493_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_493_LSB) & RXPCU_RXBUF_DATA_493_MASK)
#define RXPCU_RXBUF_DATA_493_RESET                                             0x0
#define RXPCU_RXBUF_493_ADDRESS                                                (0x17b4 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_493_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_493_RESET                                                  0x0

// 0x17b8 (RXPCU_RXBUF_494)
#define RXPCU_RXBUF_DATA_494_LSB                                               0
#define RXPCU_RXBUF_DATA_494_MSB                                               31
#define RXPCU_RXBUF_DATA_494_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_494_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_494_MASK) >> RXPCU_RXBUF_DATA_494_LSB)
#define RXPCU_RXBUF_DATA_494_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_494_LSB) & RXPCU_RXBUF_DATA_494_MASK)
#define RXPCU_RXBUF_DATA_494_RESET                                             0x0
#define RXPCU_RXBUF_494_ADDRESS                                                (0x17b8 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_494_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_494_RESET                                                  0x0

// 0x17bc (RXPCU_RXBUF_495)
#define RXPCU_RXBUF_DATA_495_LSB                                               0
#define RXPCU_RXBUF_DATA_495_MSB                                               31
#define RXPCU_RXBUF_DATA_495_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_495_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_495_MASK) >> RXPCU_RXBUF_DATA_495_LSB)
#define RXPCU_RXBUF_DATA_495_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_495_LSB) & RXPCU_RXBUF_DATA_495_MASK)
#define RXPCU_RXBUF_DATA_495_RESET                                             0x0
#define RXPCU_RXBUF_495_ADDRESS                                                (0x17bc + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_495_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_495_RESET                                                  0x0

// 0x17c0 (RXPCU_RXBUF_496)
#define RXPCU_RXBUF_DATA_496_LSB                                               0
#define RXPCU_RXBUF_DATA_496_MSB                                               31
#define RXPCU_RXBUF_DATA_496_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_496_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_496_MASK) >> RXPCU_RXBUF_DATA_496_LSB)
#define RXPCU_RXBUF_DATA_496_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_496_LSB) & RXPCU_RXBUF_DATA_496_MASK)
#define RXPCU_RXBUF_DATA_496_RESET                                             0x0
#define RXPCU_RXBUF_496_ADDRESS                                                (0x17c0 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_496_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_496_RESET                                                  0x0

// 0x17c4 (RXPCU_RXBUF_497)
#define RXPCU_RXBUF_DATA_497_LSB                                               0
#define RXPCU_RXBUF_DATA_497_MSB                                               31
#define RXPCU_RXBUF_DATA_497_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_497_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_497_MASK) >> RXPCU_RXBUF_DATA_497_LSB)
#define RXPCU_RXBUF_DATA_497_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_497_LSB) & RXPCU_RXBUF_DATA_497_MASK)
#define RXPCU_RXBUF_DATA_497_RESET                                             0x0
#define RXPCU_RXBUF_497_ADDRESS                                                (0x17c4 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_497_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_497_RESET                                                  0x0

// 0x17c8 (RXPCU_RXBUF_498)
#define RXPCU_RXBUF_DATA_498_LSB                                               0
#define RXPCU_RXBUF_DATA_498_MSB                                               31
#define RXPCU_RXBUF_DATA_498_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_498_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_498_MASK) >> RXPCU_RXBUF_DATA_498_LSB)
#define RXPCU_RXBUF_DATA_498_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_498_LSB) & RXPCU_RXBUF_DATA_498_MASK)
#define RXPCU_RXBUF_DATA_498_RESET                                             0x0
#define RXPCU_RXBUF_498_ADDRESS                                                (0x17c8 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_498_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_498_RESET                                                  0x0

// 0x17cc (RXPCU_RXBUF_499)
#define RXPCU_RXBUF_DATA_499_LSB                                               0
#define RXPCU_RXBUF_DATA_499_MSB                                               31
#define RXPCU_RXBUF_DATA_499_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_499_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_499_MASK) >> RXPCU_RXBUF_DATA_499_LSB)
#define RXPCU_RXBUF_DATA_499_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_499_LSB) & RXPCU_RXBUF_DATA_499_MASK)
#define RXPCU_RXBUF_DATA_499_RESET                                             0x0
#define RXPCU_RXBUF_499_ADDRESS                                                (0x17cc + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_499_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_499_RESET                                                  0x0

// 0x17d0 (RXPCU_RXBUF_500)
#define RXPCU_RXBUF_DATA_500_LSB                                               0
#define RXPCU_RXBUF_DATA_500_MSB                                               31
#define RXPCU_RXBUF_DATA_500_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_500_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_500_MASK) >> RXPCU_RXBUF_DATA_500_LSB)
#define RXPCU_RXBUF_DATA_500_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_500_LSB) & RXPCU_RXBUF_DATA_500_MASK)
#define RXPCU_RXBUF_DATA_500_RESET                                             0x0
#define RXPCU_RXBUF_500_ADDRESS                                                (0x17d0 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_500_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_500_RESET                                                  0x0

// 0x17d4 (RXPCU_RXBUF_501)
#define RXPCU_RXBUF_DATA_501_LSB                                               0
#define RXPCU_RXBUF_DATA_501_MSB                                               31
#define RXPCU_RXBUF_DATA_501_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_501_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_501_MASK) >> RXPCU_RXBUF_DATA_501_LSB)
#define RXPCU_RXBUF_DATA_501_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_501_LSB) & RXPCU_RXBUF_DATA_501_MASK)
#define RXPCU_RXBUF_DATA_501_RESET                                             0x0
#define RXPCU_RXBUF_501_ADDRESS                                                (0x17d4 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_501_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_501_RESET                                                  0x0

// 0x17d8 (RXPCU_RXBUF_502)
#define RXPCU_RXBUF_DATA_502_LSB                                               0
#define RXPCU_RXBUF_DATA_502_MSB                                               31
#define RXPCU_RXBUF_DATA_502_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_502_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_502_MASK) >> RXPCU_RXBUF_DATA_502_LSB)
#define RXPCU_RXBUF_DATA_502_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_502_LSB) & RXPCU_RXBUF_DATA_502_MASK)
#define RXPCU_RXBUF_DATA_502_RESET                                             0x0
#define RXPCU_RXBUF_502_ADDRESS                                                (0x17d8 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_502_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_502_RESET                                                  0x0

// 0x17dc (RXPCU_RXBUF_503)
#define RXPCU_RXBUF_DATA_503_LSB                                               0
#define RXPCU_RXBUF_DATA_503_MSB                                               31
#define RXPCU_RXBUF_DATA_503_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_503_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_503_MASK) >> RXPCU_RXBUF_DATA_503_LSB)
#define RXPCU_RXBUF_DATA_503_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_503_LSB) & RXPCU_RXBUF_DATA_503_MASK)
#define RXPCU_RXBUF_DATA_503_RESET                                             0x0
#define RXPCU_RXBUF_503_ADDRESS                                                (0x17dc + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_503_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_503_RESET                                                  0x0

// 0x17e0 (RXPCU_RXBUF_504)
#define RXPCU_RXBUF_DATA_504_LSB                                               0
#define RXPCU_RXBUF_DATA_504_MSB                                               31
#define RXPCU_RXBUF_DATA_504_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_504_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_504_MASK) >> RXPCU_RXBUF_DATA_504_LSB)
#define RXPCU_RXBUF_DATA_504_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_504_LSB) & RXPCU_RXBUF_DATA_504_MASK)
#define RXPCU_RXBUF_DATA_504_RESET                                             0x0
#define RXPCU_RXBUF_504_ADDRESS                                                (0x17e0 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_504_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_504_RESET                                                  0x0

// 0x17e4 (RXPCU_RXBUF_505)
#define RXPCU_RXBUF_DATA_505_LSB                                               0
#define RXPCU_RXBUF_DATA_505_MSB                                               31
#define RXPCU_RXBUF_DATA_505_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_505_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_505_MASK) >> RXPCU_RXBUF_DATA_505_LSB)
#define RXPCU_RXBUF_DATA_505_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_505_LSB) & RXPCU_RXBUF_DATA_505_MASK)
#define RXPCU_RXBUF_DATA_505_RESET                                             0x0
#define RXPCU_RXBUF_505_ADDRESS                                                (0x17e4 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_505_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_505_RESET                                                  0x0

// 0x17e8 (RXPCU_RXBUF_506)
#define RXPCU_RXBUF_DATA_506_LSB                                               0
#define RXPCU_RXBUF_DATA_506_MSB                                               31
#define RXPCU_RXBUF_DATA_506_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_506_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_506_MASK) >> RXPCU_RXBUF_DATA_506_LSB)
#define RXPCU_RXBUF_DATA_506_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_506_LSB) & RXPCU_RXBUF_DATA_506_MASK)
#define RXPCU_RXBUF_DATA_506_RESET                                             0x0
#define RXPCU_RXBUF_506_ADDRESS                                                (0x17e8 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_506_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_506_RESET                                                  0x0

// 0x17ec (RXPCU_RXBUF_507)
#define RXPCU_RXBUF_DATA_507_LSB                                               0
#define RXPCU_RXBUF_DATA_507_MSB                                               31
#define RXPCU_RXBUF_DATA_507_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_507_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_507_MASK) >> RXPCU_RXBUF_DATA_507_LSB)
#define RXPCU_RXBUF_DATA_507_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_507_LSB) & RXPCU_RXBUF_DATA_507_MASK)
#define RXPCU_RXBUF_DATA_507_RESET                                             0x0
#define RXPCU_RXBUF_507_ADDRESS                                                (0x17ec + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_507_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_507_RESET                                                  0x0

// 0x17f0 (RXPCU_RXBUF_508)
#define RXPCU_RXBUF_DATA_508_LSB                                               0
#define RXPCU_RXBUF_DATA_508_MSB                                               31
#define RXPCU_RXBUF_DATA_508_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_508_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_508_MASK) >> RXPCU_RXBUF_DATA_508_LSB)
#define RXPCU_RXBUF_DATA_508_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_508_LSB) & RXPCU_RXBUF_DATA_508_MASK)
#define RXPCU_RXBUF_DATA_508_RESET                                             0x0
#define RXPCU_RXBUF_508_ADDRESS                                                (0x17f0 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_508_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_508_RESET                                                  0x0

// 0x17f4 (RXPCU_RXBUF_509)
#define RXPCU_RXBUF_DATA_509_LSB                                               0
#define RXPCU_RXBUF_DATA_509_MSB                                               31
#define RXPCU_RXBUF_DATA_509_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_509_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_509_MASK) >> RXPCU_RXBUF_DATA_509_LSB)
#define RXPCU_RXBUF_DATA_509_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_509_LSB) & RXPCU_RXBUF_DATA_509_MASK)
#define RXPCU_RXBUF_DATA_509_RESET                                             0x0
#define RXPCU_RXBUF_509_ADDRESS                                                (0x17f4 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_509_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_509_RESET                                                  0x0

// 0x17f8 (RXPCU_RXBUF_510)
#define RXPCU_RXBUF_DATA_510_LSB                                               0
#define RXPCU_RXBUF_DATA_510_MSB                                               31
#define RXPCU_RXBUF_DATA_510_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_510_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_510_MASK) >> RXPCU_RXBUF_DATA_510_LSB)
#define RXPCU_RXBUF_DATA_510_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_510_LSB) & RXPCU_RXBUF_DATA_510_MASK)
#define RXPCU_RXBUF_DATA_510_RESET                                             0x0
#define RXPCU_RXBUF_510_ADDRESS                                                (0x17f8 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_510_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_510_RESET                                                  0x0

// 0x17fc (RXPCU_RXBUF_511)
#define RXPCU_RXBUF_DATA_511_LSB                                               0
#define RXPCU_RXBUF_DATA_511_MSB                                               31
#define RXPCU_RXBUF_DATA_511_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_511_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_511_MASK) >> RXPCU_RXBUF_DATA_511_LSB)
#define RXPCU_RXBUF_DATA_511_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_511_LSB) & RXPCU_RXBUF_DATA_511_MASK)
#define RXPCU_RXBUF_DATA_511_RESET                                             0x0
#define RXPCU_RXBUF_511_ADDRESS                                                (0x17fc + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_511_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_511_RESET                                                  0x0

// 0x1800 (RXPCU_RXBUF_512)
#define RXPCU_RXBUF_DATA_512_LSB                                               0
#define RXPCU_RXBUF_DATA_512_MSB                                               31
#define RXPCU_RXBUF_DATA_512_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_512_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_512_MASK) >> RXPCU_RXBUF_DATA_512_LSB)
#define RXPCU_RXBUF_DATA_512_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_512_LSB) & RXPCU_RXBUF_DATA_512_MASK)
#define RXPCU_RXBUF_DATA_512_RESET                                             0x0
#define RXPCU_RXBUF_512_ADDRESS                                                (0x1800 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_512_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_512_RESET                                                  0x0

// 0x1804 (RXPCU_RXBUF_513)
#define RXPCU_RXBUF_DATA_513_LSB                                               0
#define RXPCU_RXBUF_DATA_513_MSB                                               31
#define RXPCU_RXBUF_DATA_513_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_513_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_513_MASK) >> RXPCU_RXBUF_DATA_513_LSB)
#define RXPCU_RXBUF_DATA_513_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_513_LSB) & RXPCU_RXBUF_DATA_513_MASK)
#define RXPCU_RXBUF_DATA_513_RESET                                             0x0
#define RXPCU_RXBUF_513_ADDRESS                                                (0x1804 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_513_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_513_RESET                                                  0x0

// 0x1808 (RXPCU_RXBUF_514)
#define RXPCU_RXBUF_DATA_514_LSB                                               0
#define RXPCU_RXBUF_DATA_514_MSB                                               31
#define RXPCU_RXBUF_DATA_514_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_514_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_514_MASK) >> RXPCU_RXBUF_DATA_514_LSB)
#define RXPCU_RXBUF_DATA_514_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_514_LSB) & RXPCU_RXBUF_DATA_514_MASK)
#define RXPCU_RXBUF_DATA_514_RESET                                             0x0
#define RXPCU_RXBUF_514_ADDRESS                                                (0x1808 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_514_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_514_RESET                                                  0x0

// 0x180c (RXPCU_RXBUF_515)
#define RXPCU_RXBUF_DATA_515_LSB                                               0
#define RXPCU_RXBUF_DATA_515_MSB                                               31
#define RXPCU_RXBUF_DATA_515_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_515_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_515_MASK) >> RXPCU_RXBUF_DATA_515_LSB)
#define RXPCU_RXBUF_DATA_515_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_515_LSB) & RXPCU_RXBUF_DATA_515_MASK)
#define RXPCU_RXBUF_DATA_515_RESET                                             0x0
#define RXPCU_RXBUF_515_ADDRESS                                                (0x180c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_515_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_515_RESET                                                  0x0

// 0x1810 (RXPCU_RXBUF_516)
#define RXPCU_RXBUF_DATA_516_LSB                                               0
#define RXPCU_RXBUF_DATA_516_MSB                                               31
#define RXPCU_RXBUF_DATA_516_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_516_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_516_MASK) >> RXPCU_RXBUF_DATA_516_LSB)
#define RXPCU_RXBUF_DATA_516_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_516_LSB) & RXPCU_RXBUF_DATA_516_MASK)
#define RXPCU_RXBUF_DATA_516_RESET                                             0x0
#define RXPCU_RXBUF_516_ADDRESS                                                (0x1810 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_516_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_516_RESET                                                  0x0

// 0x1814 (RXPCU_RXBUF_517)
#define RXPCU_RXBUF_DATA_517_LSB                                               0
#define RXPCU_RXBUF_DATA_517_MSB                                               31
#define RXPCU_RXBUF_DATA_517_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_517_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_517_MASK) >> RXPCU_RXBUF_DATA_517_LSB)
#define RXPCU_RXBUF_DATA_517_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_517_LSB) & RXPCU_RXBUF_DATA_517_MASK)
#define RXPCU_RXBUF_DATA_517_RESET                                             0x0
#define RXPCU_RXBUF_517_ADDRESS                                                (0x1814 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_517_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_517_RESET                                                  0x0

// 0x1818 (RXPCU_RXBUF_518)
#define RXPCU_RXBUF_DATA_518_LSB                                               0
#define RXPCU_RXBUF_DATA_518_MSB                                               31
#define RXPCU_RXBUF_DATA_518_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_518_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_518_MASK) >> RXPCU_RXBUF_DATA_518_LSB)
#define RXPCU_RXBUF_DATA_518_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_518_LSB) & RXPCU_RXBUF_DATA_518_MASK)
#define RXPCU_RXBUF_DATA_518_RESET                                             0x0
#define RXPCU_RXBUF_518_ADDRESS                                                (0x1818 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_518_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_518_RESET                                                  0x0

// 0x181c (RXPCU_RXBUF_519)
#define RXPCU_RXBUF_DATA_519_LSB                                               0
#define RXPCU_RXBUF_DATA_519_MSB                                               31
#define RXPCU_RXBUF_DATA_519_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_519_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_519_MASK) >> RXPCU_RXBUF_DATA_519_LSB)
#define RXPCU_RXBUF_DATA_519_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_519_LSB) & RXPCU_RXBUF_DATA_519_MASK)
#define RXPCU_RXBUF_DATA_519_RESET                                             0x0
#define RXPCU_RXBUF_519_ADDRESS                                                (0x181c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_519_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_519_RESET                                                  0x0

// 0x1820 (RXPCU_RXBUF_520)
#define RXPCU_RXBUF_DATA_520_LSB                                               0
#define RXPCU_RXBUF_DATA_520_MSB                                               31
#define RXPCU_RXBUF_DATA_520_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_520_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_520_MASK) >> RXPCU_RXBUF_DATA_520_LSB)
#define RXPCU_RXBUF_DATA_520_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_520_LSB) & RXPCU_RXBUF_DATA_520_MASK)
#define RXPCU_RXBUF_DATA_520_RESET                                             0x0
#define RXPCU_RXBUF_520_ADDRESS                                                (0x1820 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_520_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_520_RESET                                                  0x0

// 0x1824 (RXPCU_RXBUF_521)
#define RXPCU_RXBUF_DATA_521_LSB                                               0
#define RXPCU_RXBUF_DATA_521_MSB                                               31
#define RXPCU_RXBUF_DATA_521_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_521_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_521_MASK) >> RXPCU_RXBUF_DATA_521_LSB)
#define RXPCU_RXBUF_DATA_521_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_521_LSB) & RXPCU_RXBUF_DATA_521_MASK)
#define RXPCU_RXBUF_DATA_521_RESET                                             0x0
#define RXPCU_RXBUF_521_ADDRESS                                                (0x1824 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_521_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_521_RESET                                                  0x0

// 0x1828 (RXPCU_RXBUF_522)
#define RXPCU_RXBUF_DATA_522_LSB                                               0
#define RXPCU_RXBUF_DATA_522_MSB                                               31
#define RXPCU_RXBUF_DATA_522_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_522_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_522_MASK) >> RXPCU_RXBUF_DATA_522_LSB)
#define RXPCU_RXBUF_DATA_522_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_522_LSB) & RXPCU_RXBUF_DATA_522_MASK)
#define RXPCU_RXBUF_DATA_522_RESET                                             0x0
#define RXPCU_RXBUF_522_ADDRESS                                                (0x1828 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_522_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_522_RESET                                                  0x0

// 0x182c (RXPCU_RXBUF_523)
#define RXPCU_RXBUF_DATA_523_LSB                                               0
#define RXPCU_RXBUF_DATA_523_MSB                                               31
#define RXPCU_RXBUF_DATA_523_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_523_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_523_MASK) >> RXPCU_RXBUF_DATA_523_LSB)
#define RXPCU_RXBUF_DATA_523_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_523_LSB) & RXPCU_RXBUF_DATA_523_MASK)
#define RXPCU_RXBUF_DATA_523_RESET                                             0x0
#define RXPCU_RXBUF_523_ADDRESS                                                (0x182c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_523_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_523_RESET                                                  0x0

// 0x1830 (RXPCU_RXBUF_524)
#define RXPCU_RXBUF_DATA_524_LSB                                               0
#define RXPCU_RXBUF_DATA_524_MSB                                               31
#define RXPCU_RXBUF_DATA_524_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_524_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_524_MASK) >> RXPCU_RXBUF_DATA_524_LSB)
#define RXPCU_RXBUF_DATA_524_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_524_LSB) & RXPCU_RXBUF_DATA_524_MASK)
#define RXPCU_RXBUF_DATA_524_RESET                                             0x0
#define RXPCU_RXBUF_524_ADDRESS                                                (0x1830 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_524_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_524_RESET                                                  0x0

// 0x1834 (RXPCU_RXBUF_525)
#define RXPCU_RXBUF_DATA_525_LSB                                               0
#define RXPCU_RXBUF_DATA_525_MSB                                               31
#define RXPCU_RXBUF_DATA_525_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_525_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_525_MASK) >> RXPCU_RXBUF_DATA_525_LSB)
#define RXPCU_RXBUF_DATA_525_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_525_LSB) & RXPCU_RXBUF_DATA_525_MASK)
#define RXPCU_RXBUF_DATA_525_RESET                                             0x0
#define RXPCU_RXBUF_525_ADDRESS                                                (0x1834 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_525_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_525_RESET                                                  0x0

// 0x1838 (RXPCU_RXBUF_526)
#define RXPCU_RXBUF_DATA_526_LSB                                               0
#define RXPCU_RXBUF_DATA_526_MSB                                               31
#define RXPCU_RXBUF_DATA_526_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_526_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_526_MASK) >> RXPCU_RXBUF_DATA_526_LSB)
#define RXPCU_RXBUF_DATA_526_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_526_LSB) & RXPCU_RXBUF_DATA_526_MASK)
#define RXPCU_RXBUF_DATA_526_RESET                                             0x0
#define RXPCU_RXBUF_526_ADDRESS                                                (0x1838 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_526_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_526_RESET                                                  0x0

// 0x183c (RXPCU_RXBUF_527)
#define RXPCU_RXBUF_DATA_527_LSB                                               0
#define RXPCU_RXBUF_DATA_527_MSB                                               31
#define RXPCU_RXBUF_DATA_527_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_527_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_527_MASK) >> RXPCU_RXBUF_DATA_527_LSB)
#define RXPCU_RXBUF_DATA_527_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_527_LSB) & RXPCU_RXBUF_DATA_527_MASK)
#define RXPCU_RXBUF_DATA_527_RESET                                             0x0
#define RXPCU_RXBUF_527_ADDRESS                                                (0x183c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_527_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_527_RESET                                                  0x0

// 0x1840 (RXPCU_RXBUF_528)
#define RXPCU_RXBUF_DATA_528_LSB                                               0
#define RXPCU_RXBUF_DATA_528_MSB                                               31
#define RXPCU_RXBUF_DATA_528_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_528_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_528_MASK) >> RXPCU_RXBUF_DATA_528_LSB)
#define RXPCU_RXBUF_DATA_528_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_528_LSB) & RXPCU_RXBUF_DATA_528_MASK)
#define RXPCU_RXBUF_DATA_528_RESET                                             0x0
#define RXPCU_RXBUF_528_ADDRESS                                                (0x1840 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_528_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_528_RESET                                                  0x0

// 0x1844 (RXPCU_RXBUF_529)
#define RXPCU_RXBUF_DATA_529_LSB                                               0
#define RXPCU_RXBUF_DATA_529_MSB                                               31
#define RXPCU_RXBUF_DATA_529_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_529_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_529_MASK) >> RXPCU_RXBUF_DATA_529_LSB)
#define RXPCU_RXBUF_DATA_529_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_529_LSB) & RXPCU_RXBUF_DATA_529_MASK)
#define RXPCU_RXBUF_DATA_529_RESET                                             0x0
#define RXPCU_RXBUF_529_ADDRESS                                                (0x1844 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_529_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_529_RESET                                                  0x0

// 0x1848 (RXPCU_RXBUF_530)
#define RXPCU_RXBUF_DATA_530_LSB                                               0
#define RXPCU_RXBUF_DATA_530_MSB                                               31
#define RXPCU_RXBUF_DATA_530_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_530_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_530_MASK) >> RXPCU_RXBUF_DATA_530_LSB)
#define RXPCU_RXBUF_DATA_530_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_530_LSB) & RXPCU_RXBUF_DATA_530_MASK)
#define RXPCU_RXBUF_DATA_530_RESET                                             0x0
#define RXPCU_RXBUF_530_ADDRESS                                                (0x1848 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_530_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_530_RESET                                                  0x0

// 0x184c (RXPCU_RXBUF_531)
#define RXPCU_RXBUF_DATA_531_LSB                                               0
#define RXPCU_RXBUF_DATA_531_MSB                                               31
#define RXPCU_RXBUF_DATA_531_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_531_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_531_MASK) >> RXPCU_RXBUF_DATA_531_LSB)
#define RXPCU_RXBUF_DATA_531_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_531_LSB) & RXPCU_RXBUF_DATA_531_MASK)
#define RXPCU_RXBUF_DATA_531_RESET                                             0x0
#define RXPCU_RXBUF_531_ADDRESS                                                (0x184c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_531_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_531_RESET                                                  0x0

// 0x1850 (RXPCU_RXBUF_532)
#define RXPCU_RXBUF_DATA_532_LSB                                               0
#define RXPCU_RXBUF_DATA_532_MSB                                               31
#define RXPCU_RXBUF_DATA_532_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_532_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_532_MASK) >> RXPCU_RXBUF_DATA_532_LSB)
#define RXPCU_RXBUF_DATA_532_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_532_LSB) & RXPCU_RXBUF_DATA_532_MASK)
#define RXPCU_RXBUF_DATA_532_RESET                                             0x0
#define RXPCU_RXBUF_532_ADDRESS                                                (0x1850 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_532_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_532_RESET                                                  0x0

// 0x1854 (RXPCU_RXBUF_533)
#define RXPCU_RXBUF_DATA_533_LSB                                               0
#define RXPCU_RXBUF_DATA_533_MSB                                               31
#define RXPCU_RXBUF_DATA_533_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_533_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_533_MASK) >> RXPCU_RXBUF_DATA_533_LSB)
#define RXPCU_RXBUF_DATA_533_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_533_LSB) & RXPCU_RXBUF_DATA_533_MASK)
#define RXPCU_RXBUF_DATA_533_RESET                                             0x0
#define RXPCU_RXBUF_533_ADDRESS                                                (0x1854 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_533_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_533_RESET                                                  0x0

// 0x1858 (RXPCU_RXBUF_534)
#define RXPCU_RXBUF_DATA_534_LSB                                               0
#define RXPCU_RXBUF_DATA_534_MSB                                               31
#define RXPCU_RXBUF_DATA_534_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_534_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_534_MASK) >> RXPCU_RXBUF_DATA_534_LSB)
#define RXPCU_RXBUF_DATA_534_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_534_LSB) & RXPCU_RXBUF_DATA_534_MASK)
#define RXPCU_RXBUF_DATA_534_RESET                                             0x0
#define RXPCU_RXBUF_534_ADDRESS                                                (0x1858 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_534_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_534_RESET                                                  0x0

// 0x185c (RXPCU_RXBUF_535)
#define RXPCU_RXBUF_DATA_535_LSB                                               0
#define RXPCU_RXBUF_DATA_535_MSB                                               31
#define RXPCU_RXBUF_DATA_535_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_535_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_535_MASK) >> RXPCU_RXBUF_DATA_535_LSB)
#define RXPCU_RXBUF_DATA_535_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_535_LSB) & RXPCU_RXBUF_DATA_535_MASK)
#define RXPCU_RXBUF_DATA_535_RESET                                             0x0
#define RXPCU_RXBUF_535_ADDRESS                                                (0x185c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_535_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_535_RESET                                                  0x0

// 0x1860 (RXPCU_RXBUF_536)
#define RXPCU_RXBUF_DATA_536_LSB                                               0
#define RXPCU_RXBUF_DATA_536_MSB                                               31
#define RXPCU_RXBUF_DATA_536_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_536_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_536_MASK) >> RXPCU_RXBUF_DATA_536_LSB)
#define RXPCU_RXBUF_DATA_536_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_536_LSB) & RXPCU_RXBUF_DATA_536_MASK)
#define RXPCU_RXBUF_DATA_536_RESET                                             0x0
#define RXPCU_RXBUF_536_ADDRESS                                                (0x1860 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_536_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_536_RESET                                                  0x0

// 0x1864 (RXPCU_RXBUF_537)
#define RXPCU_RXBUF_DATA_537_LSB                                               0
#define RXPCU_RXBUF_DATA_537_MSB                                               31
#define RXPCU_RXBUF_DATA_537_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_537_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_537_MASK) >> RXPCU_RXBUF_DATA_537_LSB)
#define RXPCU_RXBUF_DATA_537_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_537_LSB) & RXPCU_RXBUF_DATA_537_MASK)
#define RXPCU_RXBUF_DATA_537_RESET                                             0x0
#define RXPCU_RXBUF_537_ADDRESS                                                (0x1864 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_537_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_537_RESET                                                  0x0

// 0x1868 (RXPCU_RXBUF_538)
#define RXPCU_RXBUF_DATA_538_LSB                                               0
#define RXPCU_RXBUF_DATA_538_MSB                                               31
#define RXPCU_RXBUF_DATA_538_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_538_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_538_MASK) >> RXPCU_RXBUF_DATA_538_LSB)
#define RXPCU_RXBUF_DATA_538_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_538_LSB) & RXPCU_RXBUF_DATA_538_MASK)
#define RXPCU_RXBUF_DATA_538_RESET                                             0x0
#define RXPCU_RXBUF_538_ADDRESS                                                (0x1868 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_538_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_538_RESET                                                  0x0

// 0x186c (RXPCU_RXBUF_539)
#define RXPCU_RXBUF_DATA_539_LSB                                               0
#define RXPCU_RXBUF_DATA_539_MSB                                               31
#define RXPCU_RXBUF_DATA_539_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_539_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_539_MASK) >> RXPCU_RXBUF_DATA_539_LSB)
#define RXPCU_RXBUF_DATA_539_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_539_LSB) & RXPCU_RXBUF_DATA_539_MASK)
#define RXPCU_RXBUF_DATA_539_RESET                                             0x0
#define RXPCU_RXBUF_539_ADDRESS                                                (0x186c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_539_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_539_RESET                                                  0x0

// 0x1870 (RXPCU_RXBUF_540)
#define RXPCU_RXBUF_DATA_540_LSB                                               0
#define RXPCU_RXBUF_DATA_540_MSB                                               31
#define RXPCU_RXBUF_DATA_540_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_540_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_540_MASK) >> RXPCU_RXBUF_DATA_540_LSB)
#define RXPCU_RXBUF_DATA_540_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_540_LSB) & RXPCU_RXBUF_DATA_540_MASK)
#define RXPCU_RXBUF_DATA_540_RESET                                             0x0
#define RXPCU_RXBUF_540_ADDRESS                                                (0x1870 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_540_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_540_RESET                                                  0x0

// 0x1874 (RXPCU_RXBUF_541)
#define RXPCU_RXBUF_DATA_541_LSB                                               0
#define RXPCU_RXBUF_DATA_541_MSB                                               31
#define RXPCU_RXBUF_DATA_541_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_541_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_541_MASK) >> RXPCU_RXBUF_DATA_541_LSB)
#define RXPCU_RXBUF_DATA_541_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_541_LSB) & RXPCU_RXBUF_DATA_541_MASK)
#define RXPCU_RXBUF_DATA_541_RESET                                             0x0
#define RXPCU_RXBUF_541_ADDRESS                                                (0x1874 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_541_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_541_RESET                                                  0x0

// 0x1878 (RXPCU_RXBUF_542)
#define RXPCU_RXBUF_DATA_542_LSB                                               0
#define RXPCU_RXBUF_DATA_542_MSB                                               31
#define RXPCU_RXBUF_DATA_542_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_542_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_542_MASK) >> RXPCU_RXBUF_DATA_542_LSB)
#define RXPCU_RXBUF_DATA_542_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_542_LSB) & RXPCU_RXBUF_DATA_542_MASK)
#define RXPCU_RXBUF_DATA_542_RESET                                             0x0
#define RXPCU_RXBUF_542_ADDRESS                                                (0x1878 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_542_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_542_RESET                                                  0x0

// 0x187c (RXPCU_RXBUF_543)
#define RXPCU_RXBUF_DATA_543_LSB                                               0
#define RXPCU_RXBUF_DATA_543_MSB                                               31
#define RXPCU_RXBUF_DATA_543_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_543_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_543_MASK) >> RXPCU_RXBUF_DATA_543_LSB)
#define RXPCU_RXBUF_DATA_543_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_543_LSB) & RXPCU_RXBUF_DATA_543_MASK)
#define RXPCU_RXBUF_DATA_543_RESET                                             0x0
#define RXPCU_RXBUF_543_ADDRESS                                                (0x187c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_543_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_543_RESET                                                  0x0

// 0x1880 (RXPCU_RXBUF_544)
#define RXPCU_RXBUF_DATA_544_LSB                                               0
#define RXPCU_RXBUF_DATA_544_MSB                                               31
#define RXPCU_RXBUF_DATA_544_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_544_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_544_MASK) >> RXPCU_RXBUF_DATA_544_LSB)
#define RXPCU_RXBUF_DATA_544_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_544_LSB) & RXPCU_RXBUF_DATA_544_MASK)
#define RXPCU_RXBUF_DATA_544_RESET                                             0x0
#define RXPCU_RXBUF_544_ADDRESS                                                (0x1880 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_544_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_544_RESET                                                  0x0

// 0x1884 (RXPCU_RXBUF_545)
#define RXPCU_RXBUF_DATA_545_LSB                                               0
#define RXPCU_RXBUF_DATA_545_MSB                                               31
#define RXPCU_RXBUF_DATA_545_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_545_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_545_MASK) >> RXPCU_RXBUF_DATA_545_LSB)
#define RXPCU_RXBUF_DATA_545_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_545_LSB) & RXPCU_RXBUF_DATA_545_MASK)
#define RXPCU_RXBUF_DATA_545_RESET                                             0x0
#define RXPCU_RXBUF_545_ADDRESS                                                (0x1884 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_545_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_545_RESET                                                  0x0

// 0x1888 (RXPCU_RXBUF_546)
#define RXPCU_RXBUF_DATA_546_LSB                                               0
#define RXPCU_RXBUF_DATA_546_MSB                                               31
#define RXPCU_RXBUF_DATA_546_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_546_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_546_MASK) >> RXPCU_RXBUF_DATA_546_LSB)
#define RXPCU_RXBUF_DATA_546_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_546_LSB) & RXPCU_RXBUF_DATA_546_MASK)
#define RXPCU_RXBUF_DATA_546_RESET                                             0x0
#define RXPCU_RXBUF_546_ADDRESS                                                (0x1888 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_546_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_546_RESET                                                  0x0

// 0x188c (RXPCU_RXBUF_547)
#define RXPCU_RXBUF_DATA_547_LSB                                               0
#define RXPCU_RXBUF_DATA_547_MSB                                               31
#define RXPCU_RXBUF_DATA_547_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_547_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_547_MASK) >> RXPCU_RXBUF_DATA_547_LSB)
#define RXPCU_RXBUF_DATA_547_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_547_LSB) & RXPCU_RXBUF_DATA_547_MASK)
#define RXPCU_RXBUF_DATA_547_RESET                                             0x0
#define RXPCU_RXBUF_547_ADDRESS                                                (0x188c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_547_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_547_RESET                                                  0x0

// 0x1890 (RXPCU_RXBUF_548)
#define RXPCU_RXBUF_DATA_548_LSB                                               0
#define RXPCU_RXBUF_DATA_548_MSB                                               31
#define RXPCU_RXBUF_DATA_548_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_548_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_548_MASK) >> RXPCU_RXBUF_DATA_548_LSB)
#define RXPCU_RXBUF_DATA_548_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_548_LSB) & RXPCU_RXBUF_DATA_548_MASK)
#define RXPCU_RXBUF_DATA_548_RESET                                             0x0
#define RXPCU_RXBUF_548_ADDRESS                                                (0x1890 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_548_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_548_RESET                                                  0x0

// 0x1894 (RXPCU_RXBUF_549)
#define RXPCU_RXBUF_DATA_549_LSB                                               0
#define RXPCU_RXBUF_DATA_549_MSB                                               31
#define RXPCU_RXBUF_DATA_549_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_549_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_549_MASK) >> RXPCU_RXBUF_DATA_549_LSB)
#define RXPCU_RXBUF_DATA_549_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_549_LSB) & RXPCU_RXBUF_DATA_549_MASK)
#define RXPCU_RXBUF_DATA_549_RESET                                             0x0
#define RXPCU_RXBUF_549_ADDRESS                                                (0x1894 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_549_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_549_RESET                                                  0x0

// 0x1898 (RXPCU_RXBUF_550)
#define RXPCU_RXBUF_DATA_550_LSB                                               0
#define RXPCU_RXBUF_DATA_550_MSB                                               31
#define RXPCU_RXBUF_DATA_550_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_550_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_550_MASK) >> RXPCU_RXBUF_DATA_550_LSB)
#define RXPCU_RXBUF_DATA_550_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_550_LSB) & RXPCU_RXBUF_DATA_550_MASK)
#define RXPCU_RXBUF_DATA_550_RESET                                             0x0
#define RXPCU_RXBUF_550_ADDRESS                                                (0x1898 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_550_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_550_RESET                                                  0x0

// 0x189c (RXPCU_RXBUF_551)
#define RXPCU_RXBUF_DATA_551_LSB                                               0
#define RXPCU_RXBUF_DATA_551_MSB                                               31
#define RXPCU_RXBUF_DATA_551_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_551_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_551_MASK) >> RXPCU_RXBUF_DATA_551_LSB)
#define RXPCU_RXBUF_DATA_551_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_551_LSB) & RXPCU_RXBUF_DATA_551_MASK)
#define RXPCU_RXBUF_DATA_551_RESET                                             0x0
#define RXPCU_RXBUF_551_ADDRESS                                                (0x189c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_551_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_551_RESET                                                  0x0

// 0x18a0 (RXPCU_RXBUF_552)
#define RXPCU_RXBUF_DATA_552_LSB                                               0
#define RXPCU_RXBUF_DATA_552_MSB                                               31
#define RXPCU_RXBUF_DATA_552_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_552_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_552_MASK) >> RXPCU_RXBUF_DATA_552_LSB)
#define RXPCU_RXBUF_DATA_552_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_552_LSB) & RXPCU_RXBUF_DATA_552_MASK)
#define RXPCU_RXBUF_DATA_552_RESET                                             0x0
#define RXPCU_RXBUF_552_ADDRESS                                                (0x18a0 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_552_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_552_RESET                                                  0x0

// 0x18a4 (RXPCU_RXBUF_553)
#define RXPCU_RXBUF_DATA_553_LSB                                               0
#define RXPCU_RXBUF_DATA_553_MSB                                               31
#define RXPCU_RXBUF_DATA_553_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_553_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_553_MASK) >> RXPCU_RXBUF_DATA_553_LSB)
#define RXPCU_RXBUF_DATA_553_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_553_LSB) & RXPCU_RXBUF_DATA_553_MASK)
#define RXPCU_RXBUF_DATA_553_RESET                                             0x0
#define RXPCU_RXBUF_553_ADDRESS                                                (0x18a4 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_553_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_553_RESET                                                  0x0

// 0x18a8 (RXPCU_RXBUF_554)
#define RXPCU_RXBUF_DATA_554_LSB                                               0
#define RXPCU_RXBUF_DATA_554_MSB                                               31
#define RXPCU_RXBUF_DATA_554_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_554_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_554_MASK) >> RXPCU_RXBUF_DATA_554_LSB)
#define RXPCU_RXBUF_DATA_554_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_554_LSB) & RXPCU_RXBUF_DATA_554_MASK)
#define RXPCU_RXBUF_DATA_554_RESET                                             0x0
#define RXPCU_RXBUF_554_ADDRESS                                                (0x18a8 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_554_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_554_RESET                                                  0x0

// 0x18ac (RXPCU_RXBUF_555)
#define RXPCU_RXBUF_DATA_555_LSB                                               0
#define RXPCU_RXBUF_DATA_555_MSB                                               31
#define RXPCU_RXBUF_DATA_555_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_555_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_555_MASK) >> RXPCU_RXBUF_DATA_555_LSB)
#define RXPCU_RXBUF_DATA_555_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_555_LSB) & RXPCU_RXBUF_DATA_555_MASK)
#define RXPCU_RXBUF_DATA_555_RESET                                             0x0
#define RXPCU_RXBUF_555_ADDRESS                                                (0x18ac + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_555_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_555_RESET                                                  0x0

// 0x18b0 (RXPCU_RXBUF_556)
#define RXPCU_RXBUF_DATA_556_LSB                                               0
#define RXPCU_RXBUF_DATA_556_MSB                                               31
#define RXPCU_RXBUF_DATA_556_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_556_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_556_MASK) >> RXPCU_RXBUF_DATA_556_LSB)
#define RXPCU_RXBUF_DATA_556_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_556_LSB) & RXPCU_RXBUF_DATA_556_MASK)
#define RXPCU_RXBUF_DATA_556_RESET                                             0x0
#define RXPCU_RXBUF_556_ADDRESS                                                (0x18b0 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_556_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_556_RESET                                                  0x0

// 0x18b4 (RXPCU_RXBUF_557)
#define RXPCU_RXBUF_DATA_557_LSB                                               0
#define RXPCU_RXBUF_DATA_557_MSB                                               31
#define RXPCU_RXBUF_DATA_557_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_557_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_557_MASK) >> RXPCU_RXBUF_DATA_557_LSB)
#define RXPCU_RXBUF_DATA_557_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_557_LSB) & RXPCU_RXBUF_DATA_557_MASK)
#define RXPCU_RXBUF_DATA_557_RESET                                             0x0
#define RXPCU_RXBUF_557_ADDRESS                                                (0x18b4 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_557_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_557_RESET                                                  0x0

// 0x18b8 (RXPCU_RXBUF_558)
#define RXPCU_RXBUF_DATA_558_LSB                                               0
#define RXPCU_RXBUF_DATA_558_MSB                                               31
#define RXPCU_RXBUF_DATA_558_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_558_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_558_MASK) >> RXPCU_RXBUF_DATA_558_LSB)
#define RXPCU_RXBUF_DATA_558_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_558_LSB) & RXPCU_RXBUF_DATA_558_MASK)
#define RXPCU_RXBUF_DATA_558_RESET                                             0x0
#define RXPCU_RXBUF_558_ADDRESS                                                (0x18b8 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_558_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_558_RESET                                                  0x0

// 0x18bc (RXPCU_RXBUF_559)
#define RXPCU_RXBUF_DATA_559_LSB                                               0
#define RXPCU_RXBUF_DATA_559_MSB                                               31
#define RXPCU_RXBUF_DATA_559_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_559_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_559_MASK) >> RXPCU_RXBUF_DATA_559_LSB)
#define RXPCU_RXBUF_DATA_559_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_559_LSB) & RXPCU_RXBUF_DATA_559_MASK)
#define RXPCU_RXBUF_DATA_559_RESET                                             0x0
#define RXPCU_RXBUF_559_ADDRESS                                                (0x18bc + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_559_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_559_RESET                                                  0x0

// 0x18c0 (RXPCU_RXBUF_560)
#define RXPCU_RXBUF_DATA_560_LSB                                               0
#define RXPCU_RXBUF_DATA_560_MSB                                               31
#define RXPCU_RXBUF_DATA_560_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_560_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_560_MASK) >> RXPCU_RXBUF_DATA_560_LSB)
#define RXPCU_RXBUF_DATA_560_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_560_LSB) & RXPCU_RXBUF_DATA_560_MASK)
#define RXPCU_RXBUF_DATA_560_RESET                                             0x0
#define RXPCU_RXBUF_560_ADDRESS                                                (0x18c0 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_560_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_560_RESET                                                  0x0

// 0x18c4 (RXPCU_RXBUF_561)
#define RXPCU_RXBUF_DATA_561_LSB                                               0
#define RXPCU_RXBUF_DATA_561_MSB                                               31
#define RXPCU_RXBUF_DATA_561_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_561_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_561_MASK) >> RXPCU_RXBUF_DATA_561_LSB)
#define RXPCU_RXBUF_DATA_561_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_561_LSB) & RXPCU_RXBUF_DATA_561_MASK)
#define RXPCU_RXBUF_DATA_561_RESET                                             0x0
#define RXPCU_RXBUF_561_ADDRESS                                                (0x18c4 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_561_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_561_RESET                                                  0x0

// 0x18c8 (RXPCU_RXBUF_562)
#define RXPCU_RXBUF_DATA_562_LSB                                               0
#define RXPCU_RXBUF_DATA_562_MSB                                               31
#define RXPCU_RXBUF_DATA_562_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_562_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_562_MASK) >> RXPCU_RXBUF_DATA_562_LSB)
#define RXPCU_RXBUF_DATA_562_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_562_LSB) & RXPCU_RXBUF_DATA_562_MASK)
#define RXPCU_RXBUF_DATA_562_RESET                                             0x0
#define RXPCU_RXBUF_562_ADDRESS                                                (0x18c8 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_562_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_562_RESET                                                  0x0

// 0x18cc (RXPCU_RXBUF_563)
#define RXPCU_RXBUF_DATA_563_LSB                                               0
#define RXPCU_RXBUF_DATA_563_MSB                                               31
#define RXPCU_RXBUF_DATA_563_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_563_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_563_MASK) >> RXPCU_RXBUF_DATA_563_LSB)
#define RXPCU_RXBUF_DATA_563_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_563_LSB) & RXPCU_RXBUF_DATA_563_MASK)
#define RXPCU_RXBUF_DATA_563_RESET                                             0x0
#define RXPCU_RXBUF_563_ADDRESS                                                (0x18cc + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_563_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_563_RESET                                                  0x0

// 0x18d0 (RXPCU_RXBUF_564)
#define RXPCU_RXBUF_DATA_564_LSB                                               0
#define RXPCU_RXBUF_DATA_564_MSB                                               31
#define RXPCU_RXBUF_DATA_564_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_564_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_564_MASK) >> RXPCU_RXBUF_DATA_564_LSB)
#define RXPCU_RXBUF_DATA_564_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_564_LSB) & RXPCU_RXBUF_DATA_564_MASK)
#define RXPCU_RXBUF_DATA_564_RESET                                             0x0
#define RXPCU_RXBUF_564_ADDRESS                                                (0x18d0 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_564_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_564_RESET                                                  0x0

// 0x18d4 (RXPCU_RXBUF_565)
#define RXPCU_RXBUF_DATA_565_LSB                                               0
#define RXPCU_RXBUF_DATA_565_MSB                                               31
#define RXPCU_RXBUF_DATA_565_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_565_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_565_MASK) >> RXPCU_RXBUF_DATA_565_LSB)
#define RXPCU_RXBUF_DATA_565_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_565_LSB) & RXPCU_RXBUF_DATA_565_MASK)
#define RXPCU_RXBUF_DATA_565_RESET                                             0x0
#define RXPCU_RXBUF_565_ADDRESS                                                (0x18d4 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_565_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_565_RESET                                                  0x0

// 0x18d8 (RXPCU_RXBUF_566)
#define RXPCU_RXBUF_DATA_566_LSB                                               0
#define RXPCU_RXBUF_DATA_566_MSB                                               31
#define RXPCU_RXBUF_DATA_566_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_566_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_566_MASK) >> RXPCU_RXBUF_DATA_566_LSB)
#define RXPCU_RXBUF_DATA_566_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_566_LSB) & RXPCU_RXBUF_DATA_566_MASK)
#define RXPCU_RXBUF_DATA_566_RESET                                             0x0
#define RXPCU_RXBUF_566_ADDRESS                                                (0x18d8 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_566_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_566_RESET                                                  0x0

// 0x18dc (RXPCU_RXBUF_567)
#define RXPCU_RXBUF_DATA_567_LSB                                               0
#define RXPCU_RXBUF_DATA_567_MSB                                               31
#define RXPCU_RXBUF_DATA_567_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_567_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_567_MASK) >> RXPCU_RXBUF_DATA_567_LSB)
#define RXPCU_RXBUF_DATA_567_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_567_LSB) & RXPCU_RXBUF_DATA_567_MASK)
#define RXPCU_RXBUF_DATA_567_RESET                                             0x0
#define RXPCU_RXBUF_567_ADDRESS                                                (0x18dc + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_567_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_567_RESET                                                  0x0

// 0x18e0 (RXPCU_RXBUF_568)
#define RXPCU_RXBUF_DATA_568_LSB                                               0
#define RXPCU_RXBUF_DATA_568_MSB                                               31
#define RXPCU_RXBUF_DATA_568_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_568_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_568_MASK) >> RXPCU_RXBUF_DATA_568_LSB)
#define RXPCU_RXBUF_DATA_568_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_568_LSB) & RXPCU_RXBUF_DATA_568_MASK)
#define RXPCU_RXBUF_DATA_568_RESET                                             0x0
#define RXPCU_RXBUF_568_ADDRESS                                                (0x18e0 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_568_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_568_RESET                                                  0x0

// 0x18e4 (RXPCU_RXBUF_569)
#define RXPCU_RXBUF_DATA_569_LSB                                               0
#define RXPCU_RXBUF_DATA_569_MSB                                               31
#define RXPCU_RXBUF_DATA_569_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_569_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_569_MASK) >> RXPCU_RXBUF_DATA_569_LSB)
#define RXPCU_RXBUF_DATA_569_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_569_LSB) & RXPCU_RXBUF_DATA_569_MASK)
#define RXPCU_RXBUF_DATA_569_RESET                                             0x0
#define RXPCU_RXBUF_569_ADDRESS                                                (0x18e4 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_569_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_569_RESET                                                  0x0

// 0x18e8 (RXPCU_RXBUF_570)
#define RXPCU_RXBUF_DATA_570_LSB                                               0
#define RXPCU_RXBUF_DATA_570_MSB                                               31
#define RXPCU_RXBUF_DATA_570_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_570_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_570_MASK) >> RXPCU_RXBUF_DATA_570_LSB)
#define RXPCU_RXBUF_DATA_570_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_570_LSB) & RXPCU_RXBUF_DATA_570_MASK)
#define RXPCU_RXBUF_DATA_570_RESET                                             0x0
#define RXPCU_RXBUF_570_ADDRESS                                                (0x18e8 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_570_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_570_RESET                                                  0x0

// 0x18ec (RXPCU_RXBUF_571)
#define RXPCU_RXBUF_DATA_571_LSB                                               0
#define RXPCU_RXBUF_DATA_571_MSB                                               31
#define RXPCU_RXBUF_DATA_571_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_571_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_571_MASK) >> RXPCU_RXBUF_DATA_571_LSB)
#define RXPCU_RXBUF_DATA_571_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_571_LSB) & RXPCU_RXBUF_DATA_571_MASK)
#define RXPCU_RXBUF_DATA_571_RESET                                             0x0
#define RXPCU_RXBUF_571_ADDRESS                                                (0x18ec + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_571_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_571_RESET                                                  0x0

// 0x18f0 (RXPCU_RXBUF_572)
#define RXPCU_RXBUF_DATA_572_LSB                                               0
#define RXPCU_RXBUF_DATA_572_MSB                                               31
#define RXPCU_RXBUF_DATA_572_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_572_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_572_MASK) >> RXPCU_RXBUF_DATA_572_LSB)
#define RXPCU_RXBUF_DATA_572_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_572_LSB) & RXPCU_RXBUF_DATA_572_MASK)
#define RXPCU_RXBUF_DATA_572_RESET                                             0x0
#define RXPCU_RXBUF_572_ADDRESS                                                (0x18f0 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_572_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_572_RESET                                                  0x0

// 0x18f4 (RXPCU_RXBUF_573)
#define RXPCU_RXBUF_DATA_573_LSB                                               0
#define RXPCU_RXBUF_DATA_573_MSB                                               31
#define RXPCU_RXBUF_DATA_573_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_573_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_573_MASK) >> RXPCU_RXBUF_DATA_573_LSB)
#define RXPCU_RXBUF_DATA_573_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_573_LSB) & RXPCU_RXBUF_DATA_573_MASK)
#define RXPCU_RXBUF_DATA_573_RESET                                             0x0
#define RXPCU_RXBUF_573_ADDRESS                                                (0x18f4 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_573_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_573_RESET                                                  0x0

// 0x18f8 (RXPCU_RXBUF_574)
#define RXPCU_RXBUF_DATA_574_LSB                                               0
#define RXPCU_RXBUF_DATA_574_MSB                                               31
#define RXPCU_RXBUF_DATA_574_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_574_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_574_MASK) >> RXPCU_RXBUF_DATA_574_LSB)
#define RXPCU_RXBUF_DATA_574_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_574_LSB) & RXPCU_RXBUF_DATA_574_MASK)
#define RXPCU_RXBUF_DATA_574_RESET                                             0x0
#define RXPCU_RXBUF_574_ADDRESS                                                (0x18f8 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_574_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_574_RESET                                                  0x0

// 0x18fc (RXPCU_RXBUF_575)
#define RXPCU_RXBUF_DATA_575_LSB                                               0
#define RXPCU_RXBUF_DATA_575_MSB                                               31
#define RXPCU_RXBUF_DATA_575_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_575_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_575_MASK) >> RXPCU_RXBUF_DATA_575_LSB)
#define RXPCU_RXBUF_DATA_575_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_575_LSB) & RXPCU_RXBUF_DATA_575_MASK)
#define RXPCU_RXBUF_DATA_575_RESET                                             0x0
#define RXPCU_RXBUF_575_ADDRESS                                                (0x18fc + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_575_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_575_RESET                                                  0x0

// 0x1900 (RXPCU_RXBUF_576)
#define RXPCU_RXBUF_DATA_576_LSB                                               0
#define RXPCU_RXBUF_DATA_576_MSB                                               31
#define RXPCU_RXBUF_DATA_576_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_576_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_576_MASK) >> RXPCU_RXBUF_DATA_576_LSB)
#define RXPCU_RXBUF_DATA_576_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_576_LSB) & RXPCU_RXBUF_DATA_576_MASK)
#define RXPCU_RXBUF_DATA_576_RESET                                             0x0
#define RXPCU_RXBUF_576_ADDRESS                                                (0x1900 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_576_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_576_RESET                                                  0x0

// 0x1904 (RXPCU_RXBUF_577)
#define RXPCU_RXBUF_DATA_577_LSB                                               0
#define RXPCU_RXBUF_DATA_577_MSB                                               31
#define RXPCU_RXBUF_DATA_577_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_577_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_577_MASK) >> RXPCU_RXBUF_DATA_577_LSB)
#define RXPCU_RXBUF_DATA_577_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_577_LSB) & RXPCU_RXBUF_DATA_577_MASK)
#define RXPCU_RXBUF_DATA_577_RESET                                             0x0
#define RXPCU_RXBUF_577_ADDRESS                                                (0x1904 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_577_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_577_RESET                                                  0x0

// 0x1908 (RXPCU_RXBUF_578)
#define RXPCU_RXBUF_DATA_578_LSB                                               0
#define RXPCU_RXBUF_DATA_578_MSB                                               31
#define RXPCU_RXBUF_DATA_578_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_578_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_578_MASK) >> RXPCU_RXBUF_DATA_578_LSB)
#define RXPCU_RXBUF_DATA_578_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_578_LSB) & RXPCU_RXBUF_DATA_578_MASK)
#define RXPCU_RXBUF_DATA_578_RESET                                             0x0
#define RXPCU_RXBUF_578_ADDRESS                                                (0x1908 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_578_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_578_RESET                                                  0x0

// 0x190c (RXPCU_RXBUF_579)
#define RXPCU_RXBUF_DATA_579_LSB                                               0
#define RXPCU_RXBUF_DATA_579_MSB                                               31
#define RXPCU_RXBUF_DATA_579_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_579_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_579_MASK) >> RXPCU_RXBUF_DATA_579_LSB)
#define RXPCU_RXBUF_DATA_579_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_579_LSB) & RXPCU_RXBUF_DATA_579_MASK)
#define RXPCU_RXBUF_DATA_579_RESET                                             0x0
#define RXPCU_RXBUF_579_ADDRESS                                                (0x190c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_579_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_579_RESET                                                  0x0

// 0x1910 (RXPCU_RXBUF_580)
#define RXPCU_RXBUF_DATA_580_LSB                                               0
#define RXPCU_RXBUF_DATA_580_MSB                                               31
#define RXPCU_RXBUF_DATA_580_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_580_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_580_MASK) >> RXPCU_RXBUF_DATA_580_LSB)
#define RXPCU_RXBUF_DATA_580_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_580_LSB) & RXPCU_RXBUF_DATA_580_MASK)
#define RXPCU_RXBUF_DATA_580_RESET                                             0x0
#define RXPCU_RXBUF_580_ADDRESS                                                (0x1910 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_580_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_580_RESET                                                  0x0

// 0x1914 (RXPCU_RXBUF_581)
#define RXPCU_RXBUF_DATA_581_LSB                                               0
#define RXPCU_RXBUF_DATA_581_MSB                                               31
#define RXPCU_RXBUF_DATA_581_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_581_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_581_MASK) >> RXPCU_RXBUF_DATA_581_LSB)
#define RXPCU_RXBUF_DATA_581_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_581_LSB) & RXPCU_RXBUF_DATA_581_MASK)
#define RXPCU_RXBUF_DATA_581_RESET                                             0x0
#define RXPCU_RXBUF_581_ADDRESS                                                (0x1914 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_581_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_581_RESET                                                  0x0

// 0x1918 (RXPCU_RXBUF_582)
#define RXPCU_RXBUF_DATA_582_LSB                                               0
#define RXPCU_RXBUF_DATA_582_MSB                                               31
#define RXPCU_RXBUF_DATA_582_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_582_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_582_MASK) >> RXPCU_RXBUF_DATA_582_LSB)
#define RXPCU_RXBUF_DATA_582_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_582_LSB) & RXPCU_RXBUF_DATA_582_MASK)
#define RXPCU_RXBUF_DATA_582_RESET                                             0x0
#define RXPCU_RXBUF_582_ADDRESS                                                (0x1918 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_582_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_582_RESET                                                  0x0

// 0x191c (RXPCU_RXBUF_583)
#define RXPCU_RXBUF_DATA_583_LSB                                               0
#define RXPCU_RXBUF_DATA_583_MSB                                               31
#define RXPCU_RXBUF_DATA_583_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_583_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_583_MASK) >> RXPCU_RXBUF_DATA_583_LSB)
#define RXPCU_RXBUF_DATA_583_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_583_LSB) & RXPCU_RXBUF_DATA_583_MASK)
#define RXPCU_RXBUF_DATA_583_RESET                                             0x0
#define RXPCU_RXBUF_583_ADDRESS                                                (0x191c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_583_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_583_RESET                                                  0x0

// 0x1920 (RXPCU_RXBUF_584)
#define RXPCU_RXBUF_DATA_584_LSB                                               0
#define RXPCU_RXBUF_DATA_584_MSB                                               31
#define RXPCU_RXBUF_DATA_584_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_584_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_584_MASK) >> RXPCU_RXBUF_DATA_584_LSB)
#define RXPCU_RXBUF_DATA_584_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_584_LSB) & RXPCU_RXBUF_DATA_584_MASK)
#define RXPCU_RXBUF_DATA_584_RESET                                             0x0
#define RXPCU_RXBUF_584_ADDRESS                                                (0x1920 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_584_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_584_RESET                                                  0x0

// 0x1924 (RXPCU_RXBUF_585)
#define RXPCU_RXBUF_DATA_585_LSB                                               0
#define RXPCU_RXBUF_DATA_585_MSB                                               31
#define RXPCU_RXBUF_DATA_585_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_585_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_585_MASK) >> RXPCU_RXBUF_DATA_585_LSB)
#define RXPCU_RXBUF_DATA_585_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_585_LSB) & RXPCU_RXBUF_DATA_585_MASK)
#define RXPCU_RXBUF_DATA_585_RESET                                             0x0
#define RXPCU_RXBUF_585_ADDRESS                                                (0x1924 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_585_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_585_RESET                                                  0x0

// 0x1928 (RXPCU_RXBUF_586)
#define RXPCU_RXBUF_DATA_586_LSB                                               0
#define RXPCU_RXBUF_DATA_586_MSB                                               31
#define RXPCU_RXBUF_DATA_586_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_586_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_586_MASK) >> RXPCU_RXBUF_DATA_586_LSB)
#define RXPCU_RXBUF_DATA_586_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_586_LSB) & RXPCU_RXBUF_DATA_586_MASK)
#define RXPCU_RXBUF_DATA_586_RESET                                             0x0
#define RXPCU_RXBUF_586_ADDRESS                                                (0x1928 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_586_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_586_RESET                                                  0x0

// 0x192c (RXPCU_RXBUF_587)
#define RXPCU_RXBUF_DATA_587_LSB                                               0
#define RXPCU_RXBUF_DATA_587_MSB                                               31
#define RXPCU_RXBUF_DATA_587_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_587_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_587_MASK) >> RXPCU_RXBUF_DATA_587_LSB)
#define RXPCU_RXBUF_DATA_587_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_587_LSB) & RXPCU_RXBUF_DATA_587_MASK)
#define RXPCU_RXBUF_DATA_587_RESET                                             0x0
#define RXPCU_RXBUF_587_ADDRESS                                                (0x192c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_587_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_587_RESET                                                  0x0

// 0x1930 (RXPCU_RXBUF_588)
#define RXPCU_RXBUF_DATA_588_LSB                                               0
#define RXPCU_RXBUF_DATA_588_MSB                                               31
#define RXPCU_RXBUF_DATA_588_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_588_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_588_MASK) >> RXPCU_RXBUF_DATA_588_LSB)
#define RXPCU_RXBUF_DATA_588_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_588_LSB) & RXPCU_RXBUF_DATA_588_MASK)
#define RXPCU_RXBUF_DATA_588_RESET                                             0x0
#define RXPCU_RXBUF_588_ADDRESS                                                (0x1930 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_588_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_588_RESET                                                  0x0

// 0x1934 (RXPCU_RXBUF_589)
#define RXPCU_RXBUF_DATA_589_LSB                                               0
#define RXPCU_RXBUF_DATA_589_MSB                                               31
#define RXPCU_RXBUF_DATA_589_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_589_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_589_MASK) >> RXPCU_RXBUF_DATA_589_LSB)
#define RXPCU_RXBUF_DATA_589_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_589_LSB) & RXPCU_RXBUF_DATA_589_MASK)
#define RXPCU_RXBUF_DATA_589_RESET                                             0x0
#define RXPCU_RXBUF_589_ADDRESS                                                (0x1934 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_589_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_589_RESET                                                  0x0

// 0x1938 (RXPCU_RXBUF_590)
#define RXPCU_RXBUF_DATA_590_LSB                                               0
#define RXPCU_RXBUF_DATA_590_MSB                                               31
#define RXPCU_RXBUF_DATA_590_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_590_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_590_MASK) >> RXPCU_RXBUF_DATA_590_LSB)
#define RXPCU_RXBUF_DATA_590_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_590_LSB) & RXPCU_RXBUF_DATA_590_MASK)
#define RXPCU_RXBUF_DATA_590_RESET                                             0x0
#define RXPCU_RXBUF_590_ADDRESS                                                (0x1938 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_590_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_590_RESET                                                  0x0

// 0x193c (RXPCU_RXBUF_591)
#define RXPCU_RXBUF_DATA_591_LSB                                               0
#define RXPCU_RXBUF_DATA_591_MSB                                               31
#define RXPCU_RXBUF_DATA_591_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_591_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_591_MASK) >> RXPCU_RXBUF_DATA_591_LSB)
#define RXPCU_RXBUF_DATA_591_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_591_LSB) & RXPCU_RXBUF_DATA_591_MASK)
#define RXPCU_RXBUF_DATA_591_RESET                                             0x0
#define RXPCU_RXBUF_591_ADDRESS                                                (0x193c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_591_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_591_RESET                                                  0x0

// 0x1940 (RXPCU_RXBUF_592)
#define RXPCU_RXBUF_DATA_592_LSB                                               0
#define RXPCU_RXBUF_DATA_592_MSB                                               31
#define RXPCU_RXBUF_DATA_592_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_592_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_592_MASK) >> RXPCU_RXBUF_DATA_592_LSB)
#define RXPCU_RXBUF_DATA_592_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_592_LSB) & RXPCU_RXBUF_DATA_592_MASK)
#define RXPCU_RXBUF_DATA_592_RESET                                             0x0
#define RXPCU_RXBUF_592_ADDRESS                                                (0x1940 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_592_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_592_RESET                                                  0x0

// 0x1944 (RXPCU_RXBUF_593)
#define RXPCU_RXBUF_DATA_593_LSB                                               0
#define RXPCU_RXBUF_DATA_593_MSB                                               31
#define RXPCU_RXBUF_DATA_593_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_593_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_593_MASK) >> RXPCU_RXBUF_DATA_593_LSB)
#define RXPCU_RXBUF_DATA_593_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_593_LSB) & RXPCU_RXBUF_DATA_593_MASK)
#define RXPCU_RXBUF_DATA_593_RESET                                             0x0
#define RXPCU_RXBUF_593_ADDRESS                                                (0x1944 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_593_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_593_RESET                                                  0x0

// 0x1948 (RXPCU_RXBUF_594)
#define RXPCU_RXBUF_DATA_594_LSB                                               0
#define RXPCU_RXBUF_DATA_594_MSB                                               31
#define RXPCU_RXBUF_DATA_594_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_594_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_594_MASK) >> RXPCU_RXBUF_DATA_594_LSB)
#define RXPCU_RXBUF_DATA_594_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_594_LSB) & RXPCU_RXBUF_DATA_594_MASK)
#define RXPCU_RXBUF_DATA_594_RESET                                             0x0
#define RXPCU_RXBUF_594_ADDRESS                                                (0x1948 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_594_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_594_RESET                                                  0x0

// 0x194c (RXPCU_RXBUF_595)
#define RXPCU_RXBUF_DATA_595_LSB                                               0
#define RXPCU_RXBUF_DATA_595_MSB                                               31
#define RXPCU_RXBUF_DATA_595_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_595_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_595_MASK) >> RXPCU_RXBUF_DATA_595_LSB)
#define RXPCU_RXBUF_DATA_595_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_595_LSB) & RXPCU_RXBUF_DATA_595_MASK)
#define RXPCU_RXBUF_DATA_595_RESET                                             0x0
#define RXPCU_RXBUF_595_ADDRESS                                                (0x194c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_595_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_595_RESET                                                  0x0

// 0x1950 (RXPCU_RXBUF_596)
#define RXPCU_RXBUF_DATA_596_LSB                                               0
#define RXPCU_RXBUF_DATA_596_MSB                                               31
#define RXPCU_RXBUF_DATA_596_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_596_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_596_MASK) >> RXPCU_RXBUF_DATA_596_LSB)
#define RXPCU_RXBUF_DATA_596_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_596_LSB) & RXPCU_RXBUF_DATA_596_MASK)
#define RXPCU_RXBUF_DATA_596_RESET                                             0x0
#define RXPCU_RXBUF_596_ADDRESS                                                (0x1950 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_596_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_596_RESET                                                  0x0

// 0x1954 (RXPCU_RXBUF_597)
#define RXPCU_RXBUF_DATA_597_LSB                                               0
#define RXPCU_RXBUF_DATA_597_MSB                                               31
#define RXPCU_RXBUF_DATA_597_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_597_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_597_MASK) >> RXPCU_RXBUF_DATA_597_LSB)
#define RXPCU_RXBUF_DATA_597_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_597_LSB) & RXPCU_RXBUF_DATA_597_MASK)
#define RXPCU_RXBUF_DATA_597_RESET                                             0x0
#define RXPCU_RXBUF_597_ADDRESS                                                (0x1954 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_597_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_597_RESET                                                  0x0

// 0x1958 (RXPCU_RXBUF_598)
#define RXPCU_RXBUF_DATA_598_LSB                                               0
#define RXPCU_RXBUF_DATA_598_MSB                                               31
#define RXPCU_RXBUF_DATA_598_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_598_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_598_MASK) >> RXPCU_RXBUF_DATA_598_LSB)
#define RXPCU_RXBUF_DATA_598_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_598_LSB) & RXPCU_RXBUF_DATA_598_MASK)
#define RXPCU_RXBUF_DATA_598_RESET                                             0x0
#define RXPCU_RXBUF_598_ADDRESS                                                (0x1958 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_598_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_598_RESET                                                  0x0

// 0x195c (RXPCU_RXBUF_599)
#define RXPCU_RXBUF_DATA_599_LSB                                               0
#define RXPCU_RXBUF_DATA_599_MSB                                               31
#define RXPCU_RXBUF_DATA_599_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_599_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_599_MASK) >> RXPCU_RXBUF_DATA_599_LSB)
#define RXPCU_RXBUF_DATA_599_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_599_LSB) & RXPCU_RXBUF_DATA_599_MASK)
#define RXPCU_RXBUF_DATA_599_RESET                                             0x0
#define RXPCU_RXBUF_599_ADDRESS                                                (0x195c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_599_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_599_RESET                                                  0x0

// 0x1960 (RXPCU_RXBUF_600)
#define RXPCU_RXBUF_DATA_600_LSB                                               0
#define RXPCU_RXBUF_DATA_600_MSB                                               31
#define RXPCU_RXBUF_DATA_600_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_600_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_600_MASK) >> RXPCU_RXBUF_DATA_600_LSB)
#define RXPCU_RXBUF_DATA_600_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_600_LSB) & RXPCU_RXBUF_DATA_600_MASK)
#define RXPCU_RXBUF_DATA_600_RESET                                             0x0
#define RXPCU_RXBUF_600_ADDRESS                                                (0x1960 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_600_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_600_RESET                                                  0x0

// 0x1964 (RXPCU_RXBUF_601)
#define RXPCU_RXBUF_DATA_601_LSB                                               0
#define RXPCU_RXBUF_DATA_601_MSB                                               31
#define RXPCU_RXBUF_DATA_601_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_601_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_601_MASK) >> RXPCU_RXBUF_DATA_601_LSB)
#define RXPCU_RXBUF_DATA_601_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_601_LSB) & RXPCU_RXBUF_DATA_601_MASK)
#define RXPCU_RXBUF_DATA_601_RESET                                             0x0
#define RXPCU_RXBUF_601_ADDRESS                                                (0x1964 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_601_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_601_RESET                                                  0x0

// 0x1968 (RXPCU_RXBUF_602)
#define RXPCU_RXBUF_DATA_602_LSB                                               0
#define RXPCU_RXBUF_DATA_602_MSB                                               31
#define RXPCU_RXBUF_DATA_602_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_602_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_602_MASK) >> RXPCU_RXBUF_DATA_602_LSB)
#define RXPCU_RXBUF_DATA_602_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_602_LSB) & RXPCU_RXBUF_DATA_602_MASK)
#define RXPCU_RXBUF_DATA_602_RESET                                             0x0
#define RXPCU_RXBUF_602_ADDRESS                                                (0x1968 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_602_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_602_RESET                                                  0x0

// 0x196c (RXPCU_RXBUF_603)
#define RXPCU_RXBUF_DATA_603_LSB                                               0
#define RXPCU_RXBUF_DATA_603_MSB                                               31
#define RXPCU_RXBUF_DATA_603_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_603_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_603_MASK) >> RXPCU_RXBUF_DATA_603_LSB)
#define RXPCU_RXBUF_DATA_603_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_603_LSB) & RXPCU_RXBUF_DATA_603_MASK)
#define RXPCU_RXBUF_DATA_603_RESET                                             0x0
#define RXPCU_RXBUF_603_ADDRESS                                                (0x196c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_603_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_603_RESET                                                  0x0

// 0x1970 (RXPCU_RXBUF_604)
#define RXPCU_RXBUF_DATA_604_LSB                                               0
#define RXPCU_RXBUF_DATA_604_MSB                                               31
#define RXPCU_RXBUF_DATA_604_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_604_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_604_MASK) >> RXPCU_RXBUF_DATA_604_LSB)
#define RXPCU_RXBUF_DATA_604_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_604_LSB) & RXPCU_RXBUF_DATA_604_MASK)
#define RXPCU_RXBUF_DATA_604_RESET                                             0x0
#define RXPCU_RXBUF_604_ADDRESS                                                (0x1970 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_604_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_604_RESET                                                  0x0

// 0x1974 (RXPCU_RXBUF_605)
#define RXPCU_RXBUF_DATA_605_LSB                                               0
#define RXPCU_RXBUF_DATA_605_MSB                                               31
#define RXPCU_RXBUF_DATA_605_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_605_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_605_MASK) >> RXPCU_RXBUF_DATA_605_LSB)
#define RXPCU_RXBUF_DATA_605_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_605_LSB) & RXPCU_RXBUF_DATA_605_MASK)
#define RXPCU_RXBUF_DATA_605_RESET                                             0x0
#define RXPCU_RXBUF_605_ADDRESS                                                (0x1974 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_605_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_605_RESET                                                  0x0

// 0x1978 (RXPCU_RXBUF_606)
#define RXPCU_RXBUF_DATA_606_LSB                                               0
#define RXPCU_RXBUF_DATA_606_MSB                                               31
#define RXPCU_RXBUF_DATA_606_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_606_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_606_MASK) >> RXPCU_RXBUF_DATA_606_LSB)
#define RXPCU_RXBUF_DATA_606_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_606_LSB) & RXPCU_RXBUF_DATA_606_MASK)
#define RXPCU_RXBUF_DATA_606_RESET                                             0x0
#define RXPCU_RXBUF_606_ADDRESS                                                (0x1978 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_606_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_606_RESET                                                  0x0

// 0x197c (RXPCU_RXBUF_607)
#define RXPCU_RXBUF_DATA_607_LSB                                               0
#define RXPCU_RXBUF_DATA_607_MSB                                               31
#define RXPCU_RXBUF_DATA_607_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_607_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_607_MASK) >> RXPCU_RXBUF_DATA_607_LSB)
#define RXPCU_RXBUF_DATA_607_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_607_LSB) & RXPCU_RXBUF_DATA_607_MASK)
#define RXPCU_RXBUF_DATA_607_RESET                                             0x0
#define RXPCU_RXBUF_607_ADDRESS                                                (0x197c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_607_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_607_RESET                                                  0x0

// 0x1980 (RXPCU_RXBUF_608)
#define RXPCU_RXBUF_DATA_608_LSB                                               0
#define RXPCU_RXBUF_DATA_608_MSB                                               31
#define RXPCU_RXBUF_DATA_608_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_608_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_608_MASK) >> RXPCU_RXBUF_DATA_608_LSB)
#define RXPCU_RXBUF_DATA_608_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_608_LSB) & RXPCU_RXBUF_DATA_608_MASK)
#define RXPCU_RXBUF_DATA_608_RESET                                             0x0
#define RXPCU_RXBUF_608_ADDRESS                                                (0x1980 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_608_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_608_RESET                                                  0x0

// 0x1984 (RXPCU_RXBUF_609)
#define RXPCU_RXBUF_DATA_609_LSB                                               0
#define RXPCU_RXBUF_DATA_609_MSB                                               31
#define RXPCU_RXBUF_DATA_609_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_609_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_609_MASK) >> RXPCU_RXBUF_DATA_609_LSB)
#define RXPCU_RXBUF_DATA_609_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_609_LSB) & RXPCU_RXBUF_DATA_609_MASK)
#define RXPCU_RXBUF_DATA_609_RESET                                             0x0
#define RXPCU_RXBUF_609_ADDRESS                                                (0x1984 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_609_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_609_RESET                                                  0x0

// 0x1988 (RXPCU_RXBUF_610)
#define RXPCU_RXBUF_DATA_610_LSB                                               0
#define RXPCU_RXBUF_DATA_610_MSB                                               31
#define RXPCU_RXBUF_DATA_610_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_610_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_610_MASK) >> RXPCU_RXBUF_DATA_610_LSB)
#define RXPCU_RXBUF_DATA_610_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_610_LSB) & RXPCU_RXBUF_DATA_610_MASK)
#define RXPCU_RXBUF_DATA_610_RESET                                             0x0
#define RXPCU_RXBUF_610_ADDRESS                                                (0x1988 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_610_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_610_RESET                                                  0x0

// 0x198c (RXPCU_RXBUF_611)
#define RXPCU_RXBUF_DATA_611_LSB                                               0
#define RXPCU_RXBUF_DATA_611_MSB                                               31
#define RXPCU_RXBUF_DATA_611_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_611_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_611_MASK) >> RXPCU_RXBUF_DATA_611_LSB)
#define RXPCU_RXBUF_DATA_611_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_611_LSB) & RXPCU_RXBUF_DATA_611_MASK)
#define RXPCU_RXBUF_DATA_611_RESET                                             0x0
#define RXPCU_RXBUF_611_ADDRESS                                                (0x198c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_611_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_611_RESET                                                  0x0

// 0x1990 (RXPCU_RXBUF_612)
#define RXPCU_RXBUF_DATA_612_LSB                                               0
#define RXPCU_RXBUF_DATA_612_MSB                                               31
#define RXPCU_RXBUF_DATA_612_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_612_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_612_MASK) >> RXPCU_RXBUF_DATA_612_LSB)
#define RXPCU_RXBUF_DATA_612_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_612_LSB) & RXPCU_RXBUF_DATA_612_MASK)
#define RXPCU_RXBUF_DATA_612_RESET                                             0x0
#define RXPCU_RXBUF_612_ADDRESS                                                (0x1990 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_612_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_612_RESET                                                  0x0

// 0x1994 (RXPCU_RXBUF_613)
#define RXPCU_RXBUF_DATA_613_LSB                                               0
#define RXPCU_RXBUF_DATA_613_MSB                                               31
#define RXPCU_RXBUF_DATA_613_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_613_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_613_MASK) >> RXPCU_RXBUF_DATA_613_LSB)
#define RXPCU_RXBUF_DATA_613_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_613_LSB) & RXPCU_RXBUF_DATA_613_MASK)
#define RXPCU_RXBUF_DATA_613_RESET                                             0x0
#define RXPCU_RXBUF_613_ADDRESS                                                (0x1994 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_613_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_613_RESET                                                  0x0

// 0x1998 (RXPCU_RXBUF_614)
#define RXPCU_RXBUF_DATA_614_LSB                                               0
#define RXPCU_RXBUF_DATA_614_MSB                                               31
#define RXPCU_RXBUF_DATA_614_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_614_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_614_MASK) >> RXPCU_RXBUF_DATA_614_LSB)
#define RXPCU_RXBUF_DATA_614_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_614_LSB) & RXPCU_RXBUF_DATA_614_MASK)
#define RXPCU_RXBUF_DATA_614_RESET                                             0x0
#define RXPCU_RXBUF_614_ADDRESS                                                (0x1998 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_614_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_614_RESET                                                  0x0

// 0x199c (RXPCU_RXBUF_615)
#define RXPCU_RXBUF_DATA_615_LSB                                               0
#define RXPCU_RXBUF_DATA_615_MSB                                               31
#define RXPCU_RXBUF_DATA_615_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_615_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_615_MASK) >> RXPCU_RXBUF_DATA_615_LSB)
#define RXPCU_RXBUF_DATA_615_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_615_LSB) & RXPCU_RXBUF_DATA_615_MASK)
#define RXPCU_RXBUF_DATA_615_RESET                                             0x0
#define RXPCU_RXBUF_615_ADDRESS                                                (0x199c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_615_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_615_RESET                                                  0x0

// 0x19a0 (RXPCU_RXBUF_616)
#define RXPCU_RXBUF_DATA_616_LSB                                               0
#define RXPCU_RXBUF_DATA_616_MSB                                               31
#define RXPCU_RXBUF_DATA_616_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_616_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_616_MASK) >> RXPCU_RXBUF_DATA_616_LSB)
#define RXPCU_RXBUF_DATA_616_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_616_LSB) & RXPCU_RXBUF_DATA_616_MASK)
#define RXPCU_RXBUF_DATA_616_RESET                                             0x0
#define RXPCU_RXBUF_616_ADDRESS                                                (0x19a0 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_616_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_616_RESET                                                  0x0

// 0x19a4 (RXPCU_RXBUF_617)
#define RXPCU_RXBUF_DATA_617_LSB                                               0
#define RXPCU_RXBUF_DATA_617_MSB                                               31
#define RXPCU_RXBUF_DATA_617_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_617_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_617_MASK) >> RXPCU_RXBUF_DATA_617_LSB)
#define RXPCU_RXBUF_DATA_617_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_617_LSB) & RXPCU_RXBUF_DATA_617_MASK)
#define RXPCU_RXBUF_DATA_617_RESET                                             0x0
#define RXPCU_RXBUF_617_ADDRESS                                                (0x19a4 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_617_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_617_RESET                                                  0x0

// 0x19a8 (RXPCU_RXBUF_618)
#define RXPCU_RXBUF_DATA_618_LSB                                               0
#define RXPCU_RXBUF_DATA_618_MSB                                               31
#define RXPCU_RXBUF_DATA_618_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_618_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_618_MASK) >> RXPCU_RXBUF_DATA_618_LSB)
#define RXPCU_RXBUF_DATA_618_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_618_LSB) & RXPCU_RXBUF_DATA_618_MASK)
#define RXPCU_RXBUF_DATA_618_RESET                                             0x0
#define RXPCU_RXBUF_618_ADDRESS                                                (0x19a8 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_618_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_618_RESET                                                  0x0

// 0x19ac (RXPCU_RXBUF_619)
#define RXPCU_RXBUF_DATA_619_LSB                                               0
#define RXPCU_RXBUF_DATA_619_MSB                                               31
#define RXPCU_RXBUF_DATA_619_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_619_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_619_MASK) >> RXPCU_RXBUF_DATA_619_LSB)
#define RXPCU_RXBUF_DATA_619_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_619_LSB) & RXPCU_RXBUF_DATA_619_MASK)
#define RXPCU_RXBUF_DATA_619_RESET                                             0x0
#define RXPCU_RXBUF_619_ADDRESS                                                (0x19ac + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_619_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_619_RESET                                                  0x0

// 0x19b0 (RXPCU_RXBUF_620)
#define RXPCU_RXBUF_DATA_620_LSB                                               0
#define RXPCU_RXBUF_DATA_620_MSB                                               31
#define RXPCU_RXBUF_DATA_620_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_620_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_620_MASK) >> RXPCU_RXBUF_DATA_620_LSB)
#define RXPCU_RXBUF_DATA_620_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_620_LSB) & RXPCU_RXBUF_DATA_620_MASK)
#define RXPCU_RXBUF_DATA_620_RESET                                             0x0
#define RXPCU_RXBUF_620_ADDRESS                                                (0x19b0 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_620_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_620_RESET                                                  0x0

// 0x19b4 (RXPCU_RXBUF_621)
#define RXPCU_RXBUF_DATA_621_LSB                                               0
#define RXPCU_RXBUF_DATA_621_MSB                                               31
#define RXPCU_RXBUF_DATA_621_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_621_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_621_MASK) >> RXPCU_RXBUF_DATA_621_LSB)
#define RXPCU_RXBUF_DATA_621_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_621_LSB) & RXPCU_RXBUF_DATA_621_MASK)
#define RXPCU_RXBUF_DATA_621_RESET                                             0x0
#define RXPCU_RXBUF_621_ADDRESS                                                (0x19b4 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_621_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_621_RESET                                                  0x0

// 0x19b8 (RXPCU_RXBUF_622)
#define RXPCU_RXBUF_DATA_622_LSB                                               0
#define RXPCU_RXBUF_DATA_622_MSB                                               31
#define RXPCU_RXBUF_DATA_622_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_622_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_622_MASK) >> RXPCU_RXBUF_DATA_622_LSB)
#define RXPCU_RXBUF_DATA_622_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_622_LSB) & RXPCU_RXBUF_DATA_622_MASK)
#define RXPCU_RXBUF_DATA_622_RESET                                             0x0
#define RXPCU_RXBUF_622_ADDRESS                                                (0x19b8 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_622_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_622_RESET                                                  0x0

// 0x19bc (RXPCU_RXBUF_623)
#define RXPCU_RXBUF_DATA_623_LSB                                               0
#define RXPCU_RXBUF_DATA_623_MSB                                               31
#define RXPCU_RXBUF_DATA_623_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_623_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_623_MASK) >> RXPCU_RXBUF_DATA_623_LSB)
#define RXPCU_RXBUF_DATA_623_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_623_LSB) & RXPCU_RXBUF_DATA_623_MASK)
#define RXPCU_RXBUF_DATA_623_RESET                                             0x0
#define RXPCU_RXBUF_623_ADDRESS                                                (0x19bc + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_623_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_623_RESET                                                  0x0

// 0x19c0 (RXPCU_RXBUF_624)
#define RXPCU_RXBUF_DATA_624_LSB                                               0
#define RXPCU_RXBUF_DATA_624_MSB                                               31
#define RXPCU_RXBUF_DATA_624_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_624_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_624_MASK) >> RXPCU_RXBUF_DATA_624_LSB)
#define RXPCU_RXBUF_DATA_624_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_624_LSB) & RXPCU_RXBUF_DATA_624_MASK)
#define RXPCU_RXBUF_DATA_624_RESET                                             0x0
#define RXPCU_RXBUF_624_ADDRESS                                                (0x19c0 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_624_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_624_RESET                                                  0x0

// 0x19c4 (RXPCU_RXBUF_625)
#define RXPCU_RXBUF_DATA_625_LSB                                               0
#define RXPCU_RXBUF_DATA_625_MSB                                               31
#define RXPCU_RXBUF_DATA_625_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_625_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_625_MASK) >> RXPCU_RXBUF_DATA_625_LSB)
#define RXPCU_RXBUF_DATA_625_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_625_LSB) & RXPCU_RXBUF_DATA_625_MASK)
#define RXPCU_RXBUF_DATA_625_RESET                                             0x0
#define RXPCU_RXBUF_625_ADDRESS                                                (0x19c4 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_625_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_625_RESET                                                  0x0

// 0x19c8 (RXPCU_RXBUF_626)
#define RXPCU_RXBUF_DATA_626_LSB                                               0
#define RXPCU_RXBUF_DATA_626_MSB                                               31
#define RXPCU_RXBUF_DATA_626_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_626_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_626_MASK) >> RXPCU_RXBUF_DATA_626_LSB)
#define RXPCU_RXBUF_DATA_626_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_626_LSB) & RXPCU_RXBUF_DATA_626_MASK)
#define RXPCU_RXBUF_DATA_626_RESET                                             0x0
#define RXPCU_RXBUF_626_ADDRESS                                                (0x19c8 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_626_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_626_RESET                                                  0x0

// 0x19cc (RXPCU_RXBUF_627)
#define RXPCU_RXBUF_DATA_627_LSB                                               0
#define RXPCU_RXBUF_DATA_627_MSB                                               31
#define RXPCU_RXBUF_DATA_627_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_627_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_627_MASK) >> RXPCU_RXBUF_DATA_627_LSB)
#define RXPCU_RXBUF_DATA_627_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_627_LSB) & RXPCU_RXBUF_DATA_627_MASK)
#define RXPCU_RXBUF_DATA_627_RESET                                             0x0
#define RXPCU_RXBUF_627_ADDRESS                                                (0x19cc + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_627_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_627_RESET                                                  0x0

// 0x19d0 (RXPCU_RXBUF_628)
#define RXPCU_RXBUF_DATA_628_LSB                                               0
#define RXPCU_RXBUF_DATA_628_MSB                                               31
#define RXPCU_RXBUF_DATA_628_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_628_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_628_MASK) >> RXPCU_RXBUF_DATA_628_LSB)
#define RXPCU_RXBUF_DATA_628_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_628_LSB) & RXPCU_RXBUF_DATA_628_MASK)
#define RXPCU_RXBUF_DATA_628_RESET                                             0x0
#define RXPCU_RXBUF_628_ADDRESS                                                (0x19d0 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_628_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_628_RESET                                                  0x0

// 0x19d4 (RXPCU_RXBUF_629)
#define RXPCU_RXBUF_DATA_629_LSB                                               0
#define RXPCU_RXBUF_DATA_629_MSB                                               31
#define RXPCU_RXBUF_DATA_629_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_629_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_629_MASK) >> RXPCU_RXBUF_DATA_629_LSB)
#define RXPCU_RXBUF_DATA_629_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_629_LSB) & RXPCU_RXBUF_DATA_629_MASK)
#define RXPCU_RXBUF_DATA_629_RESET                                             0x0
#define RXPCU_RXBUF_629_ADDRESS                                                (0x19d4 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_629_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_629_RESET                                                  0x0

// 0x19d8 (RXPCU_RXBUF_630)
#define RXPCU_RXBUF_DATA_630_LSB                                               0
#define RXPCU_RXBUF_DATA_630_MSB                                               31
#define RXPCU_RXBUF_DATA_630_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_630_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_630_MASK) >> RXPCU_RXBUF_DATA_630_LSB)
#define RXPCU_RXBUF_DATA_630_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_630_LSB) & RXPCU_RXBUF_DATA_630_MASK)
#define RXPCU_RXBUF_DATA_630_RESET                                             0x0
#define RXPCU_RXBUF_630_ADDRESS                                                (0x19d8 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_630_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_630_RESET                                                  0x0

// 0x19dc (RXPCU_RXBUF_631)
#define RXPCU_RXBUF_DATA_631_LSB                                               0
#define RXPCU_RXBUF_DATA_631_MSB                                               31
#define RXPCU_RXBUF_DATA_631_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_631_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_631_MASK) >> RXPCU_RXBUF_DATA_631_LSB)
#define RXPCU_RXBUF_DATA_631_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_631_LSB) & RXPCU_RXBUF_DATA_631_MASK)
#define RXPCU_RXBUF_DATA_631_RESET                                             0x0
#define RXPCU_RXBUF_631_ADDRESS                                                (0x19dc + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_631_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_631_RESET                                                  0x0

// 0x19e0 (RXPCU_RXBUF_632)
#define RXPCU_RXBUF_DATA_632_LSB                                               0
#define RXPCU_RXBUF_DATA_632_MSB                                               31
#define RXPCU_RXBUF_DATA_632_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_632_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_632_MASK) >> RXPCU_RXBUF_DATA_632_LSB)
#define RXPCU_RXBUF_DATA_632_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_632_LSB) & RXPCU_RXBUF_DATA_632_MASK)
#define RXPCU_RXBUF_DATA_632_RESET                                             0x0
#define RXPCU_RXBUF_632_ADDRESS                                                (0x19e0 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_632_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_632_RESET                                                  0x0

// 0x19e4 (RXPCU_RXBUF_633)
#define RXPCU_RXBUF_DATA_633_LSB                                               0
#define RXPCU_RXBUF_DATA_633_MSB                                               31
#define RXPCU_RXBUF_DATA_633_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_633_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_633_MASK) >> RXPCU_RXBUF_DATA_633_LSB)
#define RXPCU_RXBUF_DATA_633_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_633_LSB) & RXPCU_RXBUF_DATA_633_MASK)
#define RXPCU_RXBUF_DATA_633_RESET                                             0x0
#define RXPCU_RXBUF_633_ADDRESS                                                (0x19e4 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_633_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_633_RESET                                                  0x0

// 0x19e8 (RXPCU_RXBUF_634)
#define RXPCU_RXBUF_DATA_634_LSB                                               0
#define RXPCU_RXBUF_DATA_634_MSB                                               31
#define RXPCU_RXBUF_DATA_634_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_634_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_634_MASK) >> RXPCU_RXBUF_DATA_634_LSB)
#define RXPCU_RXBUF_DATA_634_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_634_LSB) & RXPCU_RXBUF_DATA_634_MASK)
#define RXPCU_RXBUF_DATA_634_RESET                                             0x0
#define RXPCU_RXBUF_634_ADDRESS                                                (0x19e8 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_634_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_634_RESET                                                  0x0

// 0x19ec (RXPCU_RXBUF_635)
#define RXPCU_RXBUF_DATA_635_LSB                                               0
#define RXPCU_RXBUF_DATA_635_MSB                                               31
#define RXPCU_RXBUF_DATA_635_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_635_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_635_MASK) >> RXPCU_RXBUF_DATA_635_LSB)
#define RXPCU_RXBUF_DATA_635_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_635_LSB) & RXPCU_RXBUF_DATA_635_MASK)
#define RXPCU_RXBUF_DATA_635_RESET                                             0x0
#define RXPCU_RXBUF_635_ADDRESS                                                (0x19ec + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_635_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_635_RESET                                                  0x0

// 0x19f0 (RXPCU_RXBUF_636)
#define RXPCU_RXBUF_DATA_636_LSB                                               0
#define RXPCU_RXBUF_DATA_636_MSB                                               31
#define RXPCU_RXBUF_DATA_636_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_636_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_636_MASK) >> RXPCU_RXBUF_DATA_636_LSB)
#define RXPCU_RXBUF_DATA_636_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_636_LSB) & RXPCU_RXBUF_DATA_636_MASK)
#define RXPCU_RXBUF_DATA_636_RESET                                             0x0
#define RXPCU_RXBUF_636_ADDRESS                                                (0x19f0 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_636_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_636_RESET                                                  0x0

// 0x19f4 (RXPCU_RXBUF_637)
#define RXPCU_RXBUF_DATA_637_LSB                                               0
#define RXPCU_RXBUF_DATA_637_MSB                                               31
#define RXPCU_RXBUF_DATA_637_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_637_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_637_MASK) >> RXPCU_RXBUF_DATA_637_LSB)
#define RXPCU_RXBUF_DATA_637_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_637_LSB) & RXPCU_RXBUF_DATA_637_MASK)
#define RXPCU_RXBUF_DATA_637_RESET                                             0x0
#define RXPCU_RXBUF_637_ADDRESS                                                (0x19f4 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_637_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_637_RESET                                                  0x0

// 0x19f8 (RXPCU_RXBUF_638)
#define RXPCU_RXBUF_DATA_638_LSB                                               0
#define RXPCU_RXBUF_DATA_638_MSB                                               31
#define RXPCU_RXBUF_DATA_638_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_638_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_638_MASK) >> RXPCU_RXBUF_DATA_638_LSB)
#define RXPCU_RXBUF_DATA_638_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_638_LSB) & RXPCU_RXBUF_DATA_638_MASK)
#define RXPCU_RXBUF_DATA_638_RESET                                             0x0
#define RXPCU_RXBUF_638_ADDRESS                                                (0x19f8 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_638_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_638_RESET                                                  0x0

// 0x19fc (RXPCU_RXBUF_639)
#define RXPCU_RXBUF_DATA_639_LSB                                               0
#define RXPCU_RXBUF_DATA_639_MSB                                               31
#define RXPCU_RXBUF_DATA_639_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_639_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_639_MASK) >> RXPCU_RXBUF_DATA_639_LSB)
#define RXPCU_RXBUF_DATA_639_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_639_LSB) & RXPCU_RXBUF_DATA_639_MASK)
#define RXPCU_RXBUF_DATA_639_RESET                                             0x0
#define RXPCU_RXBUF_639_ADDRESS                                                (0x19fc + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_639_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_639_RESET                                                  0x0

// 0x1a00 (RXPCU_RXBUF_640)
#define RXPCU_RXBUF_DATA_640_LSB                                               0
#define RXPCU_RXBUF_DATA_640_MSB                                               31
#define RXPCU_RXBUF_DATA_640_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_640_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_640_MASK) >> RXPCU_RXBUF_DATA_640_LSB)
#define RXPCU_RXBUF_DATA_640_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_640_LSB) & RXPCU_RXBUF_DATA_640_MASK)
#define RXPCU_RXBUF_DATA_640_RESET                                             0x0
#define RXPCU_RXBUF_640_ADDRESS                                                (0x1a00 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_640_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_640_RESET                                                  0x0

// 0x1a04 (RXPCU_RXBUF_641)
#define RXPCU_RXBUF_DATA_641_LSB                                               0
#define RXPCU_RXBUF_DATA_641_MSB                                               31
#define RXPCU_RXBUF_DATA_641_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_641_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_641_MASK) >> RXPCU_RXBUF_DATA_641_LSB)
#define RXPCU_RXBUF_DATA_641_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_641_LSB) & RXPCU_RXBUF_DATA_641_MASK)
#define RXPCU_RXBUF_DATA_641_RESET                                             0x0
#define RXPCU_RXBUF_641_ADDRESS                                                (0x1a04 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_641_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_641_RESET                                                  0x0

// 0x1a08 (RXPCU_RXBUF_642)
#define RXPCU_RXBUF_DATA_642_LSB                                               0
#define RXPCU_RXBUF_DATA_642_MSB                                               31
#define RXPCU_RXBUF_DATA_642_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_642_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_642_MASK) >> RXPCU_RXBUF_DATA_642_LSB)
#define RXPCU_RXBUF_DATA_642_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_642_LSB) & RXPCU_RXBUF_DATA_642_MASK)
#define RXPCU_RXBUF_DATA_642_RESET                                             0x0
#define RXPCU_RXBUF_642_ADDRESS                                                (0x1a08 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_642_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_642_RESET                                                  0x0

// 0x1a0c (RXPCU_RXBUF_643)
#define RXPCU_RXBUF_DATA_643_LSB                                               0
#define RXPCU_RXBUF_DATA_643_MSB                                               31
#define RXPCU_RXBUF_DATA_643_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_643_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_643_MASK) >> RXPCU_RXBUF_DATA_643_LSB)
#define RXPCU_RXBUF_DATA_643_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_643_LSB) & RXPCU_RXBUF_DATA_643_MASK)
#define RXPCU_RXBUF_DATA_643_RESET                                             0x0
#define RXPCU_RXBUF_643_ADDRESS                                                (0x1a0c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_643_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_643_RESET                                                  0x0

// 0x1a10 (RXPCU_RXBUF_644)
#define RXPCU_RXBUF_DATA_644_LSB                                               0
#define RXPCU_RXBUF_DATA_644_MSB                                               31
#define RXPCU_RXBUF_DATA_644_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_644_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_644_MASK) >> RXPCU_RXBUF_DATA_644_LSB)
#define RXPCU_RXBUF_DATA_644_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_644_LSB) & RXPCU_RXBUF_DATA_644_MASK)
#define RXPCU_RXBUF_DATA_644_RESET                                             0x0
#define RXPCU_RXBUF_644_ADDRESS                                                (0x1a10 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_644_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_644_RESET                                                  0x0

// 0x1a14 (RXPCU_RXBUF_645)
#define RXPCU_RXBUF_DATA_645_LSB                                               0
#define RXPCU_RXBUF_DATA_645_MSB                                               31
#define RXPCU_RXBUF_DATA_645_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_645_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_645_MASK) >> RXPCU_RXBUF_DATA_645_LSB)
#define RXPCU_RXBUF_DATA_645_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_645_LSB) & RXPCU_RXBUF_DATA_645_MASK)
#define RXPCU_RXBUF_DATA_645_RESET                                             0x0
#define RXPCU_RXBUF_645_ADDRESS                                                (0x1a14 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_645_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_645_RESET                                                  0x0

// 0x1a18 (RXPCU_RXBUF_646)
#define RXPCU_RXBUF_DATA_646_LSB                                               0
#define RXPCU_RXBUF_DATA_646_MSB                                               31
#define RXPCU_RXBUF_DATA_646_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_646_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_646_MASK) >> RXPCU_RXBUF_DATA_646_LSB)
#define RXPCU_RXBUF_DATA_646_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_646_LSB) & RXPCU_RXBUF_DATA_646_MASK)
#define RXPCU_RXBUF_DATA_646_RESET                                             0x0
#define RXPCU_RXBUF_646_ADDRESS                                                (0x1a18 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_646_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_646_RESET                                                  0x0

// 0x1a1c (RXPCU_RXBUF_647)
#define RXPCU_RXBUF_DATA_647_LSB                                               0
#define RXPCU_RXBUF_DATA_647_MSB                                               31
#define RXPCU_RXBUF_DATA_647_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_647_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_647_MASK) >> RXPCU_RXBUF_DATA_647_LSB)
#define RXPCU_RXBUF_DATA_647_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_647_LSB) & RXPCU_RXBUF_DATA_647_MASK)
#define RXPCU_RXBUF_DATA_647_RESET                                             0x0
#define RXPCU_RXBUF_647_ADDRESS                                                (0x1a1c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_647_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_647_RESET                                                  0x0

// 0x1a20 (RXPCU_RXBUF_648)
#define RXPCU_RXBUF_DATA_648_LSB                                               0
#define RXPCU_RXBUF_DATA_648_MSB                                               31
#define RXPCU_RXBUF_DATA_648_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_648_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_648_MASK) >> RXPCU_RXBUF_DATA_648_LSB)
#define RXPCU_RXBUF_DATA_648_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_648_LSB) & RXPCU_RXBUF_DATA_648_MASK)
#define RXPCU_RXBUF_DATA_648_RESET                                             0x0
#define RXPCU_RXBUF_648_ADDRESS                                                (0x1a20 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_648_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_648_RESET                                                  0x0

// 0x1a24 (RXPCU_RXBUF_649)
#define RXPCU_RXBUF_DATA_649_LSB                                               0
#define RXPCU_RXBUF_DATA_649_MSB                                               31
#define RXPCU_RXBUF_DATA_649_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_649_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_649_MASK) >> RXPCU_RXBUF_DATA_649_LSB)
#define RXPCU_RXBUF_DATA_649_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_649_LSB) & RXPCU_RXBUF_DATA_649_MASK)
#define RXPCU_RXBUF_DATA_649_RESET                                             0x0
#define RXPCU_RXBUF_649_ADDRESS                                                (0x1a24 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_649_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_649_RESET                                                  0x0

// 0x1a28 (RXPCU_RXBUF_650)
#define RXPCU_RXBUF_DATA_650_LSB                                               0
#define RXPCU_RXBUF_DATA_650_MSB                                               31
#define RXPCU_RXBUF_DATA_650_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_650_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_650_MASK) >> RXPCU_RXBUF_DATA_650_LSB)
#define RXPCU_RXBUF_DATA_650_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_650_LSB) & RXPCU_RXBUF_DATA_650_MASK)
#define RXPCU_RXBUF_DATA_650_RESET                                             0x0
#define RXPCU_RXBUF_650_ADDRESS                                                (0x1a28 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_650_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_650_RESET                                                  0x0

// 0x1a2c (RXPCU_RXBUF_651)
#define RXPCU_RXBUF_DATA_651_LSB                                               0
#define RXPCU_RXBUF_DATA_651_MSB                                               31
#define RXPCU_RXBUF_DATA_651_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_651_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_651_MASK) >> RXPCU_RXBUF_DATA_651_LSB)
#define RXPCU_RXBUF_DATA_651_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_651_LSB) & RXPCU_RXBUF_DATA_651_MASK)
#define RXPCU_RXBUF_DATA_651_RESET                                             0x0
#define RXPCU_RXBUF_651_ADDRESS                                                (0x1a2c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_651_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_651_RESET                                                  0x0

// 0x1a30 (RXPCU_RXBUF_652)
#define RXPCU_RXBUF_DATA_652_LSB                                               0
#define RXPCU_RXBUF_DATA_652_MSB                                               31
#define RXPCU_RXBUF_DATA_652_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_652_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_652_MASK) >> RXPCU_RXBUF_DATA_652_LSB)
#define RXPCU_RXBUF_DATA_652_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_652_LSB) & RXPCU_RXBUF_DATA_652_MASK)
#define RXPCU_RXBUF_DATA_652_RESET                                             0x0
#define RXPCU_RXBUF_652_ADDRESS                                                (0x1a30 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_652_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_652_RESET                                                  0x0

// 0x1a34 (RXPCU_RXBUF_653)
#define RXPCU_RXBUF_DATA_653_LSB                                               0
#define RXPCU_RXBUF_DATA_653_MSB                                               31
#define RXPCU_RXBUF_DATA_653_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_653_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_653_MASK) >> RXPCU_RXBUF_DATA_653_LSB)
#define RXPCU_RXBUF_DATA_653_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_653_LSB) & RXPCU_RXBUF_DATA_653_MASK)
#define RXPCU_RXBUF_DATA_653_RESET                                             0x0
#define RXPCU_RXBUF_653_ADDRESS                                                (0x1a34 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_653_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_653_RESET                                                  0x0

// 0x1a38 (RXPCU_RXBUF_654)
#define RXPCU_RXBUF_DATA_654_LSB                                               0
#define RXPCU_RXBUF_DATA_654_MSB                                               31
#define RXPCU_RXBUF_DATA_654_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_654_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_654_MASK) >> RXPCU_RXBUF_DATA_654_LSB)
#define RXPCU_RXBUF_DATA_654_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_654_LSB) & RXPCU_RXBUF_DATA_654_MASK)
#define RXPCU_RXBUF_DATA_654_RESET                                             0x0
#define RXPCU_RXBUF_654_ADDRESS                                                (0x1a38 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_654_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_654_RESET                                                  0x0

// 0x1a3c (RXPCU_RXBUF_655)
#define RXPCU_RXBUF_DATA_655_LSB                                               0
#define RXPCU_RXBUF_DATA_655_MSB                                               31
#define RXPCU_RXBUF_DATA_655_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_655_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_655_MASK) >> RXPCU_RXBUF_DATA_655_LSB)
#define RXPCU_RXBUF_DATA_655_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_655_LSB) & RXPCU_RXBUF_DATA_655_MASK)
#define RXPCU_RXBUF_DATA_655_RESET                                             0x0
#define RXPCU_RXBUF_655_ADDRESS                                                (0x1a3c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_655_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_655_RESET                                                  0x0

// 0x1a40 (RXPCU_RXBUF_656)
#define RXPCU_RXBUF_DATA_656_LSB                                               0
#define RXPCU_RXBUF_DATA_656_MSB                                               31
#define RXPCU_RXBUF_DATA_656_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_656_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_656_MASK) >> RXPCU_RXBUF_DATA_656_LSB)
#define RXPCU_RXBUF_DATA_656_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_656_LSB) & RXPCU_RXBUF_DATA_656_MASK)
#define RXPCU_RXBUF_DATA_656_RESET                                             0x0
#define RXPCU_RXBUF_656_ADDRESS                                                (0x1a40 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_656_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_656_RESET                                                  0x0

// 0x1a44 (RXPCU_RXBUF_657)
#define RXPCU_RXBUF_DATA_657_LSB                                               0
#define RXPCU_RXBUF_DATA_657_MSB                                               31
#define RXPCU_RXBUF_DATA_657_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_657_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_657_MASK) >> RXPCU_RXBUF_DATA_657_LSB)
#define RXPCU_RXBUF_DATA_657_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_657_LSB) & RXPCU_RXBUF_DATA_657_MASK)
#define RXPCU_RXBUF_DATA_657_RESET                                             0x0
#define RXPCU_RXBUF_657_ADDRESS                                                (0x1a44 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_657_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_657_RESET                                                  0x0

// 0x1a48 (RXPCU_RXBUF_658)
#define RXPCU_RXBUF_DATA_658_LSB                                               0
#define RXPCU_RXBUF_DATA_658_MSB                                               31
#define RXPCU_RXBUF_DATA_658_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_658_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_658_MASK) >> RXPCU_RXBUF_DATA_658_LSB)
#define RXPCU_RXBUF_DATA_658_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_658_LSB) & RXPCU_RXBUF_DATA_658_MASK)
#define RXPCU_RXBUF_DATA_658_RESET                                             0x0
#define RXPCU_RXBUF_658_ADDRESS                                                (0x1a48 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_658_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_658_RESET                                                  0x0

// 0x1a4c (RXPCU_RXBUF_659)
#define RXPCU_RXBUF_DATA_659_LSB                                               0
#define RXPCU_RXBUF_DATA_659_MSB                                               31
#define RXPCU_RXBUF_DATA_659_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_659_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_659_MASK) >> RXPCU_RXBUF_DATA_659_LSB)
#define RXPCU_RXBUF_DATA_659_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_659_LSB) & RXPCU_RXBUF_DATA_659_MASK)
#define RXPCU_RXBUF_DATA_659_RESET                                             0x0
#define RXPCU_RXBUF_659_ADDRESS                                                (0x1a4c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_659_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_659_RESET                                                  0x0

// 0x1a50 (RXPCU_RXBUF_660)
#define RXPCU_RXBUF_DATA_660_LSB                                               0
#define RXPCU_RXBUF_DATA_660_MSB                                               31
#define RXPCU_RXBUF_DATA_660_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_660_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_660_MASK) >> RXPCU_RXBUF_DATA_660_LSB)
#define RXPCU_RXBUF_DATA_660_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_660_LSB) & RXPCU_RXBUF_DATA_660_MASK)
#define RXPCU_RXBUF_DATA_660_RESET                                             0x0
#define RXPCU_RXBUF_660_ADDRESS                                                (0x1a50 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_660_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_660_RESET                                                  0x0

// 0x1a54 (RXPCU_RXBUF_661)
#define RXPCU_RXBUF_DATA_661_LSB                                               0
#define RXPCU_RXBUF_DATA_661_MSB                                               31
#define RXPCU_RXBUF_DATA_661_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_661_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_661_MASK) >> RXPCU_RXBUF_DATA_661_LSB)
#define RXPCU_RXBUF_DATA_661_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_661_LSB) & RXPCU_RXBUF_DATA_661_MASK)
#define RXPCU_RXBUF_DATA_661_RESET                                             0x0
#define RXPCU_RXBUF_661_ADDRESS                                                (0x1a54 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_661_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_661_RESET                                                  0x0

// 0x1a58 (RXPCU_RXBUF_662)
#define RXPCU_RXBUF_DATA_662_LSB                                               0
#define RXPCU_RXBUF_DATA_662_MSB                                               31
#define RXPCU_RXBUF_DATA_662_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_662_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_662_MASK) >> RXPCU_RXBUF_DATA_662_LSB)
#define RXPCU_RXBUF_DATA_662_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_662_LSB) & RXPCU_RXBUF_DATA_662_MASK)
#define RXPCU_RXBUF_DATA_662_RESET                                             0x0
#define RXPCU_RXBUF_662_ADDRESS                                                (0x1a58 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_662_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_662_RESET                                                  0x0

// 0x1a5c (RXPCU_RXBUF_663)
#define RXPCU_RXBUF_DATA_663_LSB                                               0
#define RXPCU_RXBUF_DATA_663_MSB                                               31
#define RXPCU_RXBUF_DATA_663_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_663_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_663_MASK) >> RXPCU_RXBUF_DATA_663_LSB)
#define RXPCU_RXBUF_DATA_663_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_663_LSB) & RXPCU_RXBUF_DATA_663_MASK)
#define RXPCU_RXBUF_DATA_663_RESET                                             0x0
#define RXPCU_RXBUF_663_ADDRESS                                                (0x1a5c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_663_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_663_RESET                                                  0x0

// 0x1a60 (RXPCU_RXBUF_664)
#define RXPCU_RXBUF_DATA_664_LSB                                               0
#define RXPCU_RXBUF_DATA_664_MSB                                               31
#define RXPCU_RXBUF_DATA_664_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_664_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_664_MASK) >> RXPCU_RXBUF_DATA_664_LSB)
#define RXPCU_RXBUF_DATA_664_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_664_LSB) & RXPCU_RXBUF_DATA_664_MASK)
#define RXPCU_RXBUF_DATA_664_RESET                                             0x0
#define RXPCU_RXBUF_664_ADDRESS                                                (0x1a60 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_664_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_664_RESET                                                  0x0

// 0x1a64 (RXPCU_RXBUF_665)
#define RXPCU_RXBUF_DATA_665_LSB                                               0
#define RXPCU_RXBUF_DATA_665_MSB                                               31
#define RXPCU_RXBUF_DATA_665_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_665_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_665_MASK) >> RXPCU_RXBUF_DATA_665_LSB)
#define RXPCU_RXBUF_DATA_665_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_665_LSB) & RXPCU_RXBUF_DATA_665_MASK)
#define RXPCU_RXBUF_DATA_665_RESET                                             0x0
#define RXPCU_RXBUF_665_ADDRESS                                                (0x1a64 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_665_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_665_RESET                                                  0x0

// 0x1a68 (RXPCU_RXBUF_666)
#define RXPCU_RXBUF_DATA_666_LSB                                               0
#define RXPCU_RXBUF_DATA_666_MSB                                               31
#define RXPCU_RXBUF_DATA_666_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_666_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_666_MASK) >> RXPCU_RXBUF_DATA_666_LSB)
#define RXPCU_RXBUF_DATA_666_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_666_LSB) & RXPCU_RXBUF_DATA_666_MASK)
#define RXPCU_RXBUF_DATA_666_RESET                                             0x0
#define RXPCU_RXBUF_666_ADDRESS                                                (0x1a68 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_666_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_666_RESET                                                  0x0

// 0x1a6c (RXPCU_RXBUF_667)
#define RXPCU_RXBUF_DATA_667_LSB                                               0
#define RXPCU_RXBUF_DATA_667_MSB                                               31
#define RXPCU_RXBUF_DATA_667_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_667_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_667_MASK) >> RXPCU_RXBUF_DATA_667_LSB)
#define RXPCU_RXBUF_DATA_667_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_667_LSB) & RXPCU_RXBUF_DATA_667_MASK)
#define RXPCU_RXBUF_DATA_667_RESET                                             0x0
#define RXPCU_RXBUF_667_ADDRESS                                                (0x1a6c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_667_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_667_RESET                                                  0x0

// 0x1a70 (RXPCU_RXBUF_668)
#define RXPCU_RXBUF_DATA_668_LSB                                               0
#define RXPCU_RXBUF_DATA_668_MSB                                               31
#define RXPCU_RXBUF_DATA_668_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_668_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_668_MASK) >> RXPCU_RXBUF_DATA_668_LSB)
#define RXPCU_RXBUF_DATA_668_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_668_LSB) & RXPCU_RXBUF_DATA_668_MASK)
#define RXPCU_RXBUF_DATA_668_RESET                                             0x0
#define RXPCU_RXBUF_668_ADDRESS                                                (0x1a70 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_668_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_668_RESET                                                  0x0

// 0x1a74 (RXPCU_RXBUF_669)
#define RXPCU_RXBUF_DATA_669_LSB                                               0
#define RXPCU_RXBUF_DATA_669_MSB                                               31
#define RXPCU_RXBUF_DATA_669_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_669_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_669_MASK) >> RXPCU_RXBUF_DATA_669_LSB)
#define RXPCU_RXBUF_DATA_669_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_669_LSB) & RXPCU_RXBUF_DATA_669_MASK)
#define RXPCU_RXBUF_DATA_669_RESET                                             0x0
#define RXPCU_RXBUF_669_ADDRESS                                                (0x1a74 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_669_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_669_RESET                                                  0x0

// 0x1a78 (RXPCU_RXBUF_670)
#define RXPCU_RXBUF_DATA_670_LSB                                               0
#define RXPCU_RXBUF_DATA_670_MSB                                               31
#define RXPCU_RXBUF_DATA_670_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_670_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_670_MASK) >> RXPCU_RXBUF_DATA_670_LSB)
#define RXPCU_RXBUF_DATA_670_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_670_LSB) & RXPCU_RXBUF_DATA_670_MASK)
#define RXPCU_RXBUF_DATA_670_RESET                                             0x0
#define RXPCU_RXBUF_670_ADDRESS                                                (0x1a78 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_670_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_670_RESET                                                  0x0

// 0x1a7c (RXPCU_RXBUF_671)
#define RXPCU_RXBUF_DATA_671_LSB                                               0
#define RXPCU_RXBUF_DATA_671_MSB                                               31
#define RXPCU_RXBUF_DATA_671_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_671_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_671_MASK) >> RXPCU_RXBUF_DATA_671_LSB)
#define RXPCU_RXBUF_DATA_671_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_671_LSB) & RXPCU_RXBUF_DATA_671_MASK)
#define RXPCU_RXBUF_DATA_671_RESET                                             0x0
#define RXPCU_RXBUF_671_ADDRESS                                                (0x1a7c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_671_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_671_RESET                                                  0x0

// 0x1a80 (RXPCU_RXBUF_672)
#define RXPCU_RXBUF_DATA_672_LSB                                               0
#define RXPCU_RXBUF_DATA_672_MSB                                               31
#define RXPCU_RXBUF_DATA_672_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_672_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_672_MASK) >> RXPCU_RXBUF_DATA_672_LSB)
#define RXPCU_RXBUF_DATA_672_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_672_LSB) & RXPCU_RXBUF_DATA_672_MASK)
#define RXPCU_RXBUF_DATA_672_RESET                                             0x0
#define RXPCU_RXBUF_672_ADDRESS                                                (0x1a80 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_672_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_672_RESET                                                  0x0

// 0x1a84 (RXPCU_RXBUF_673)
#define RXPCU_RXBUF_DATA_673_LSB                                               0
#define RXPCU_RXBUF_DATA_673_MSB                                               31
#define RXPCU_RXBUF_DATA_673_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_673_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_673_MASK) >> RXPCU_RXBUF_DATA_673_LSB)
#define RXPCU_RXBUF_DATA_673_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_673_LSB) & RXPCU_RXBUF_DATA_673_MASK)
#define RXPCU_RXBUF_DATA_673_RESET                                             0x0
#define RXPCU_RXBUF_673_ADDRESS                                                (0x1a84 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_673_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_673_RESET                                                  0x0

// 0x1a88 (RXPCU_RXBUF_674)
#define RXPCU_RXBUF_DATA_674_LSB                                               0
#define RXPCU_RXBUF_DATA_674_MSB                                               31
#define RXPCU_RXBUF_DATA_674_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_674_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_674_MASK) >> RXPCU_RXBUF_DATA_674_LSB)
#define RXPCU_RXBUF_DATA_674_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_674_LSB) & RXPCU_RXBUF_DATA_674_MASK)
#define RXPCU_RXBUF_DATA_674_RESET                                             0x0
#define RXPCU_RXBUF_674_ADDRESS                                                (0x1a88 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_674_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_674_RESET                                                  0x0

// 0x1a8c (RXPCU_RXBUF_675)
#define RXPCU_RXBUF_DATA_675_LSB                                               0
#define RXPCU_RXBUF_DATA_675_MSB                                               31
#define RXPCU_RXBUF_DATA_675_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_675_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_675_MASK) >> RXPCU_RXBUF_DATA_675_LSB)
#define RXPCU_RXBUF_DATA_675_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_675_LSB) & RXPCU_RXBUF_DATA_675_MASK)
#define RXPCU_RXBUF_DATA_675_RESET                                             0x0
#define RXPCU_RXBUF_675_ADDRESS                                                (0x1a8c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_675_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_675_RESET                                                  0x0

// 0x1a90 (RXPCU_RXBUF_676)
#define RXPCU_RXBUF_DATA_676_LSB                                               0
#define RXPCU_RXBUF_DATA_676_MSB                                               31
#define RXPCU_RXBUF_DATA_676_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_676_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_676_MASK) >> RXPCU_RXBUF_DATA_676_LSB)
#define RXPCU_RXBUF_DATA_676_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_676_LSB) & RXPCU_RXBUF_DATA_676_MASK)
#define RXPCU_RXBUF_DATA_676_RESET                                             0x0
#define RXPCU_RXBUF_676_ADDRESS                                                (0x1a90 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_676_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_676_RESET                                                  0x0

// 0x1a94 (RXPCU_RXBUF_677)
#define RXPCU_RXBUF_DATA_677_LSB                                               0
#define RXPCU_RXBUF_DATA_677_MSB                                               31
#define RXPCU_RXBUF_DATA_677_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_677_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_677_MASK) >> RXPCU_RXBUF_DATA_677_LSB)
#define RXPCU_RXBUF_DATA_677_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_677_LSB) & RXPCU_RXBUF_DATA_677_MASK)
#define RXPCU_RXBUF_DATA_677_RESET                                             0x0
#define RXPCU_RXBUF_677_ADDRESS                                                (0x1a94 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_677_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_677_RESET                                                  0x0

// 0x1a98 (RXPCU_RXBUF_678)
#define RXPCU_RXBUF_DATA_678_LSB                                               0
#define RXPCU_RXBUF_DATA_678_MSB                                               31
#define RXPCU_RXBUF_DATA_678_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_678_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_678_MASK) >> RXPCU_RXBUF_DATA_678_LSB)
#define RXPCU_RXBUF_DATA_678_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_678_LSB) & RXPCU_RXBUF_DATA_678_MASK)
#define RXPCU_RXBUF_DATA_678_RESET                                             0x0
#define RXPCU_RXBUF_678_ADDRESS                                                (0x1a98 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_678_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_678_RESET                                                  0x0

// 0x1a9c (RXPCU_RXBUF_679)
#define RXPCU_RXBUF_DATA_679_LSB                                               0
#define RXPCU_RXBUF_DATA_679_MSB                                               31
#define RXPCU_RXBUF_DATA_679_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_679_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_679_MASK) >> RXPCU_RXBUF_DATA_679_LSB)
#define RXPCU_RXBUF_DATA_679_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_679_LSB) & RXPCU_RXBUF_DATA_679_MASK)
#define RXPCU_RXBUF_DATA_679_RESET                                             0x0
#define RXPCU_RXBUF_679_ADDRESS                                                (0x1a9c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_679_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_679_RESET                                                  0x0

// 0x1aa0 (RXPCU_RXBUF_680)
#define RXPCU_RXBUF_DATA_680_LSB                                               0
#define RXPCU_RXBUF_DATA_680_MSB                                               31
#define RXPCU_RXBUF_DATA_680_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_680_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_680_MASK) >> RXPCU_RXBUF_DATA_680_LSB)
#define RXPCU_RXBUF_DATA_680_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_680_LSB) & RXPCU_RXBUF_DATA_680_MASK)
#define RXPCU_RXBUF_DATA_680_RESET                                             0x0
#define RXPCU_RXBUF_680_ADDRESS                                                (0x1aa0 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_680_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_680_RESET                                                  0x0

// 0x1aa4 (RXPCU_RXBUF_681)
#define RXPCU_RXBUF_DATA_681_LSB                                               0
#define RXPCU_RXBUF_DATA_681_MSB                                               31
#define RXPCU_RXBUF_DATA_681_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_681_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_681_MASK) >> RXPCU_RXBUF_DATA_681_LSB)
#define RXPCU_RXBUF_DATA_681_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_681_LSB) & RXPCU_RXBUF_DATA_681_MASK)
#define RXPCU_RXBUF_DATA_681_RESET                                             0x0
#define RXPCU_RXBUF_681_ADDRESS                                                (0x1aa4 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_681_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_681_RESET                                                  0x0

// 0x1aa8 (RXPCU_RXBUF_682)
#define RXPCU_RXBUF_DATA_682_LSB                                               0
#define RXPCU_RXBUF_DATA_682_MSB                                               31
#define RXPCU_RXBUF_DATA_682_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_682_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_682_MASK) >> RXPCU_RXBUF_DATA_682_LSB)
#define RXPCU_RXBUF_DATA_682_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_682_LSB) & RXPCU_RXBUF_DATA_682_MASK)
#define RXPCU_RXBUF_DATA_682_RESET                                             0x0
#define RXPCU_RXBUF_682_ADDRESS                                                (0x1aa8 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_682_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_682_RESET                                                  0x0

// 0x1aac (RXPCU_RXBUF_683)
#define RXPCU_RXBUF_DATA_683_LSB                                               0
#define RXPCU_RXBUF_DATA_683_MSB                                               31
#define RXPCU_RXBUF_DATA_683_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_683_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_683_MASK) >> RXPCU_RXBUF_DATA_683_LSB)
#define RXPCU_RXBUF_DATA_683_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_683_LSB) & RXPCU_RXBUF_DATA_683_MASK)
#define RXPCU_RXBUF_DATA_683_RESET                                             0x0
#define RXPCU_RXBUF_683_ADDRESS                                                (0x1aac + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_683_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_683_RESET                                                  0x0

// 0x1ab0 (RXPCU_RXBUF_684)
#define RXPCU_RXBUF_DATA_684_LSB                                               0
#define RXPCU_RXBUF_DATA_684_MSB                                               31
#define RXPCU_RXBUF_DATA_684_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_684_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_684_MASK) >> RXPCU_RXBUF_DATA_684_LSB)
#define RXPCU_RXBUF_DATA_684_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_684_LSB) & RXPCU_RXBUF_DATA_684_MASK)
#define RXPCU_RXBUF_DATA_684_RESET                                             0x0
#define RXPCU_RXBUF_684_ADDRESS                                                (0x1ab0 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_684_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_684_RESET                                                  0x0

// 0x1ab4 (RXPCU_RXBUF_685)
#define RXPCU_RXBUF_DATA_685_LSB                                               0
#define RXPCU_RXBUF_DATA_685_MSB                                               31
#define RXPCU_RXBUF_DATA_685_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_685_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_685_MASK) >> RXPCU_RXBUF_DATA_685_LSB)
#define RXPCU_RXBUF_DATA_685_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_685_LSB) & RXPCU_RXBUF_DATA_685_MASK)
#define RXPCU_RXBUF_DATA_685_RESET                                             0x0
#define RXPCU_RXBUF_685_ADDRESS                                                (0x1ab4 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_685_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_685_RESET                                                  0x0

// 0x1ab8 (RXPCU_RXBUF_686)
#define RXPCU_RXBUF_DATA_686_LSB                                               0
#define RXPCU_RXBUF_DATA_686_MSB                                               31
#define RXPCU_RXBUF_DATA_686_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_686_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_686_MASK) >> RXPCU_RXBUF_DATA_686_LSB)
#define RXPCU_RXBUF_DATA_686_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_686_LSB) & RXPCU_RXBUF_DATA_686_MASK)
#define RXPCU_RXBUF_DATA_686_RESET                                             0x0
#define RXPCU_RXBUF_686_ADDRESS                                                (0x1ab8 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_686_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_686_RESET                                                  0x0

// 0x1abc (RXPCU_RXBUF_687)
#define RXPCU_RXBUF_DATA_687_LSB                                               0
#define RXPCU_RXBUF_DATA_687_MSB                                               31
#define RXPCU_RXBUF_DATA_687_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_687_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_687_MASK) >> RXPCU_RXBUF_DATA_687_LSB)
#define RXPCU_RXBUF_DATA_687_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_687_LSB) & RXPCU_RXBUF_DATA_687_MASK)
#define RXPCU_RXBUF_DATA_687_RESET                                             0x0
#define RXPCU_RXBUF_687_ADDRESS                                                (0x1abc + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_687_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_687_RESET                                                  0x0

// 0x1ac0 (RXPCU_RXBUF_688)
#define RXPCU_RXBUF_DATA_688_LSB                                               0
#define RXPCU_RXBUF_DATA_688_MSB                                               31
#define RXPCU_RXBUF_DATA_688_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_688_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_688_MASK) >> RXPCU_RXBUF_DATA_688_LSB)
#define RXPCU_RXBUF_DATA_688_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_688_LSB) & RXPCU_RXBUF_DATA_688_MASK)
#define RXPCU_RXBUF_DATA_688_RESET                                             0x0
#define RXPCU_RXBUF_688_ADDRESS                                                (0x1ac0 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_688_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_688_RESET                                                  0x0

// 0x1ac4 (RXPCU_RXBUF_689)
#define RXPCU_RXBUF_DATA_689_LSB                                               0
#define RXPCU_RXBUF_DATA_689_MSB                                               31
#define RXPCU_RXBUF_DATA_689_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_689_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_689_MASK) >> RXPCU_RXBUF_DATA_689_LSB)
#define RXPCU_RXBUF_DATA_689_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_689_LSB) & RXPCU_RXBUF_DATA_689_MASK)
#define RXPCU_RXBUF_DATA_689_RESET                                             0x0
#define RXPCU_RXBUF_689_ADDRESS                                                (0x1ac4 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_689_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_689_RESET                                                  0x0

// 0x1ac8 (RXPCU_RXBUF_690)
#define RXPCU_RXBUF_DATA_690_LSB                                               0
#define RXPCU_RXBUF_DATA_690_MSB                                               31
#define RXPCU_RXBUF_DATA_690_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_690_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_690_MASK) >> RXPCU_RXBUF_DATA_690_LSB)
#define RXPCU_RXBUF_DATA_690_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_690_LSB) & RXPCU_RXBUF_DATA_690_MASK)
#define RXPCU_RXBUF_DATA_690_RESET                                             0x0
#define RXPCU_RXBUF_690_ADDRESS                                                (0x1ac8 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_690_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_690_RESET                                                  0x0

// 0x1acc (RXPCU_RXBUF_691)
#define RXPCU_RXBUF_DATA_691_LSB                                               0
#define RXPCU_RXBUF_DATA_691_MSB                                               31
#define RXPCU_RXBUF_DATA_691_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_691_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_691_MASK) >> RXPCU_RXBUF_DATA_691_LSB)
#define RXPCU_RXBUF_DATA_691_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_691_LSB) & RXPCU_RXBUF_DATA_691_MASK)
#define RXPCU_RXBUF_DATA_691_RESET                                             0x0
#define RXPCU_RXBUF_691_ADDRESS                                                (0x1acc + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_691_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_691_RESET                                                  0x0

// 0x1ad0 (RXPCU_RXBUF_692)
#define RXPCU_RXBUF_DATA_692_LSB                                               0
#define RXPCU_RXBUF_DATA_692_MSB                                               31
#define RXPCU_RXBUF_DATA_692_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_692_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_692_MASK) >> RXPCU_RXBUF_DATA_692_LSB)
#define RXPCU_RXBUF_DATA_692_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_692_LSB) & RXPCU_RXBUF_DATA_692_MASK)
#define RXPCU_RXBUF_DATA_692_RESET                                             0x0
#define RXPCU_RXBUF_692_ADDRESS                                                (0x1ad0 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_692_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_692_RESET                                                  0x0

// 0x1ad4 (RXPCU_RXBUF_693)
#define RXPCU_RXBUF_DATA_693_LSB                                               0
#define RXPCU_RXBUF_DATA_693_MSB                                               31
#define RXPCU_RXBUF_DATA_693_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_693_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_693_MASK) >> RXPCU_RXBUF_DATA_693_LSB)
#define RXPCU_RXBUF_DATA_693_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_693_LSB) & RXPCU_RXBUF_DATA_693_MASK)
#define RXPCU_RXBUF_DATA_693_RESET                                             0x0
#define RXPCU_RXBUF_693_ADDRESS                                                (0x1ad4 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_693_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_693_RESET                                                  0x0

// 0x1ad8 (RXPCU_RXBUF_694)
#define RXPCU_RXBUF_DATA_694_LSB                                               0
#define RXPCU_RXBUF_DATA_694_MSB                                               31
#define RXPCU_RXBUF_DATA_694_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_694_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_694_MASK) >> RXPCU_RXBUF_DATA_694_LSB)
#define RXPCU_RXBUF_DATA_694_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_694_LSB) & RXPCU_RXBUF_DATA_694_MASK)
#define RXPCU_RXBUF_DATA_694_RESET                                             0x0
#define RXPCU_RXBUF_694_ADDRESS                                                (0x1ad8 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_694_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_694_RESET                                                  0x0

// 0x1adc (RXPCU_RXBUF_695)
#define RXPCU_RXBUF_DATA_695_LSB                                               0
#define RXPCU_RXBUF_DATA_695_MSB                                               31
#define RXPCU_RXBUF_DATA_695_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_695_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_695_MASK) >> RXPCU_RXBUF_DATA_695_LSB)
#define RXPCU_RXBUF_DATA_695_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_695_LSB) & RXPCU_RXBUF_DATA_695_MASK)
#define RXPCU_RXBUF_DATA_695_RESET                                             0x0
#define RXPCU_RXBUF_695_ADDRESS                                                (0x1adc + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_695_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_695_RESET                                                  0x0

// 0x1ae0 (RXPCU_RXBUF_696)
#define RXPCU_RXBUF_DATA_696_LSB                                               0
#define RXPCU_RXBUF_DATA_696_MSB                                               31
#define RXPCU_RXBUF_DATA_696_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_696_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_696_MASK) >> RXPCU_RXBUF_DATA_696_LSB)
#define RXPCU_RXBUF_DATA_696_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_696_LSB) & RXPCU_RXBUF_DATA_696_MASK)
#define RXPCU_RXBUF_DATA_696_RESET                                             0x0
#define RXPCU_RXBUF_696_ADDRESS                                                (0x1ae0 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_696_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_696_RESET                                                  0x0

// 0x1ae4 (RXPCU_RXBUF_697)
#define RXPCU_RXBUF_DATA_697_LSB                                               0
#define RXPCU_RXBUF_DATA_697_MSB                                               31
#define RXPCU_RXBUF_DATA_697_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_697_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_697_MASK) >> RXPCU_RXBUF_DATA_697_LSB)
#define RXPCU_RXBUF_DATA_697_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_697_LSB) & RXPCU_RXBUF_DATA_697_MASK)
#define RXPCU_RXBUF_DATA_697_RESET                                             0x0
#define RXPCU_RXBUF_697_ADDRESS                                                (0x1ae4 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_697_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_697_RESET                                                  0x0

// 0x1ae8 (RXPCU_RXBUF_698)
#define RXPCU_RXBUF_DATA_698_LSB                                               0
#define RXPCU_RXBUF_DATA_698_MSB                                               31
#define RXPCU_RXBUF_DATA_698_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_698_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_698_MASK) >> RXPCU_RXBUF_DATA_698_LSB)
#define RXPCU_RXBUF_DATA_698_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_698_LSB) & RXPCU_RXBUF_DATA_698_MASK)
#define RXPCU_RXBUF_DATA_698_RESET                                             0x0
#define RXPCU_RXBUF_698_ADDRESS                                                (0x1ae8 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_698_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_698_RESET                                                  0x0

// 0x1aec (RXPCU_RXBUF_699)
#define RXPCU_RXBUF_DATA_699_LSB                                               0
#define RXPCU_RXBUF_DATA_699_MSB                                               31
#define RXPCU_RXBUF_DATA_699_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_699_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_699_MASK) >> RXPCU_RXBUF_DATA_699_LSB)
#define RXPCU_RXBUF_DATA_699_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_699_LSB) & RXPCU_RXBUF_DATA_699_MASK)
#define RXPCU_RXBUF_DATA_699_RESET                                             0x0
#define RXPCU_RXBUF_699_ADDRESS                                                (0x1aec + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_699_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_699_RESET                                                  0x0

// 0x1af0 (RXPCU_RXBUF_700)
#define RXPCU_RXBUF_DATA_700_LSB                                               0
#define RXPCU_RXBUF_DATA_700_MSB                                               31
#define RXPCU_RXBUF_DATA_700_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_700_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_700_MASK) >> RXPCU_RXBUF_DATA_700_LSB)
#define RXPCU_RXBUF_DATA_700_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_700_LSB) & RXPCU_RXBUF_DATA_700_MASK)
#define RXPCU_RXBUF_DATA_700_RESET                                             0x0
#define RXPCU_RXBUF_700_ADDRESS                                                (0x1af0 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_700_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_700_RESET                                                  0x0

// 0x1af4 (RXPCU_RXBUF_701)
#define RXPCU_RXBUF_DATA_701_LSB                                               0
#define RXPCU_RXBUF_DATA_701_MSB                                               31
#define RXPCU_RXBUF_DATA_701_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_701_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_701_MASK) >> RXPCU_RXBUF_DATA_701_LSB)
#define RXPCU_RXBUF_DATA_701_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_701_LSB) & RXPCU_RXBUF_DATA_701_MASK)
#define RXPCU_RXBUF_DATA_701_RESET                                             0x0
#define RXPCU_RXBUF_701_ADDRESS                                                (0x1af4 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_701_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_701_RESET                                                  0x0

// 0x1af8 (RXPCU_RXBUF_702)
#define RXPCU_RXBUF_DATA_702_LSB                                               0
#define RXPCU_RXBUF_DATA_702_MSB                                               31
#define RXPCU_RXBUF_DATA_702_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_702_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_702_MASK) >> RXPCU_RXBUF_DATA_702_LSB)
#define RXPCU_RXBUF_DATA_702_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_702_LSB) & RXPCU_RXBUF_DATA_702_MASK)
#define RXPCU_RXBUF_DATA_702_RESET                                             0x0
#define RXPCU_RXBUF_702_ADDRESS                                                (0x1af8 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_702_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_702_RESET                                                  0x0

// 0x1afc (RXPCU_RXBUF_703)
#define RXPCU_RXBUF_DATA_703_LSB                                               0
#define RXPCU_RXBUF_DATA_703_MSB                                               31
#define RXPCU_RXBUF_DATA_703_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_703_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_703_MASK) >> RXPCU_RXBUF_DATA_703_LSB)
#define RXPCU_RXBUF_DATA_703_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_703_LSB) & RXPCU_RXBUF_DATA_703_MASK)
#define RXPCU_RXBUF_DATA_703_RESET                                             0x0
#define RXPCU_RXBUF_703_ADDRESS                                                (0x1afc + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_703_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_703_RESET                                                  0x0

// 0x1b00 (RXPCU_RXBUF_704)
#define RXPCU_RXBUF_DATA_704_LSB                                               0
#define RXPCU_RXBUF_DATA_704_MSB                                               31
#define RXPCU_RXBUF_DATA_704_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_704_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_704_MASK) >> RXPCU_RXBUF_DATA_704_LSB)
#define RXPCU_RXBUF_DATA_704_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_704_LSB) & RXPCU_RXBUF_DATA_704_MASK)
#define RXPCU_RXBUF_DATA_704_RESET                                             0x0
#define RXPCU_RXBUF_704_ADDRESS                                                (0x1b00 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_704_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_704_RESET                                                  0x0

// 0x1b04 (RXPCU_RXBUF_705)
#define RXPCU_RXBUF_DATA_705_LSB                                               0
#define RXPCU_RXBUF_DATA_705_MSB                                               31
#define RXPCU_RXBUF_DATA_705_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_705_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_705_MASK) >> RXPCU_RXBUF_DATA_705_LSB)
#define RXPCU_RXBUF_DATA_705_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_705_LSB) & RXPCU_RXBUF_DATA_705_MASK)
#define RXPCU_RXBUF_DATA_705_RESET                                             0x0
#define RXPCU_RXBUF_705_ADDRESS                                                (0x1b04 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_705_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_705_RESET                                                  0x0

// 0x1b08 (RXPCU_RXBUF_706)
#define RXPCU_RXBUF_DATA_706_LSB                                               0
#define RXPCU_RXBUF_DATA_706_MSB                                               31
#define RXPCU_RXBUF_DATA_706_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_706_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_706_MASK) >> RXPCU_RXBUF_DATA_706_LSB)
#define RXPCU_RXBUF_DATA_706_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_706_LSB) & RXPCU_RXBUF_DATA_706_MASK)
#define RXPCU_RXBUF_DATA_706_RESET                                             0x0
#define RXPCU_RXBUF_706_ADDRESS                                                (0x1b08 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_706_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_706_RESET                                                  0x0

// 0x1b0c (RXPCU_RXBUF_707)
#define RXPCU_RXBUF_DATA_707_LSB                                               0
#define RXPCU_RXBUF_DATA_707_MSB                                               31
#define RXPCU_RXBUF_DATA_707_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_707_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_707_MASK) >> RXPCU_RXBUF_DATA_707_LSB)
#define RXPCU_RXBUF_DATA_707_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_707_LSB) & RXPCU_RXBUF_DATA_707_MASK)
#define RXPCU_RXBUF_DATA_707_RESET                                             0x0
#define RXPCU_RXBUF_707_ADDRESS                                                (0x1b0c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_707_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_707_RESET                                                  0x0

// 0x1b10 (RXPCU_RXBUF_708)
#define RXPCU_RXBUF_DATA_708_LSB                                               0
#define RXPCU_RXBUF_DATA_708_MSB                                               31
#define RXPCU_RXBUF_DATA_708_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_708_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_708_MASK) >> RXPCU_RXBUF_DATA_708_LSB)
#define RXPCU_RXBUF_DATA_708_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_708_LSB) & RXPCU_RXBUF_DATA_708_MASK)
#define RXPCU_RXBUF_DATA_708_RESET                                             0x0
#define RXPCU_RXBUF_708_ADDRESS                                                (0x1b10 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_708_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_708_RESET                                                  0x0

// 0x1b14 (RXPCU_RXBUF_709)
#define RXPCU_RXBUF_DATA_709_LSB                                               0
#define RXPCU_RXBUF_DATA_709_MSB                                               31
#define RXPCU_RXBUF_DATA_709_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_709_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_709_MASK) >> RXPCU_RXBUF_DATA_709_LSB)
#define RXPCU_RXBUF_DATA_709_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_709_LSB) & RXPCU_RXBUF_DATA_709_MASK)
#define RXPCU_RXBUF_DATA_709_RESET                                             0x0
#define RXPCU_RXBUF_709_ADDRESS                                                (0x1b14 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_709_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_709_RESET                                                  0x0

// 0x1b18 (RXPCU_RXBUF_710)
#define RXPCU_RXBUF_DATA_710_LSB                                               0
#define RXPCU_RXBUF_DATA_710_MSB                                               31
#define RXPCU_RXBUF_DATA_710_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_710_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_710_MASK) >> RXPCU_RXBUF_DATA_710_LSB)
#define RXPCU_RXBUF_DATA_710_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_710_LSB) & RXPCU_RXBUF_DATA_710_MASK)
#define RXPCU_RXBUF_DATA_710_RESET                                             0x0
#define RXPCU_RXBUF_710_ADDRESS                                                (0x1b18 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_710_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_710_RESET                                                  0x0

// 0x1b1c (RXPCU_RXBUF_711)
#define RXPCU_RXBUF_DATA_711_LSB                                               0
#define RXPCU_RXBUF_DATA_711_MSB                                               31
#define RXPCU_RXBUF_DATA_711_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_711_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_711_MASK) >> RXPCU_RXBUF_DATA_711_LSB)
#define RXPCU_RXBUF_DATA_711_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_711_LSB) & RXPCU_RXBUF_DATA_711_MASK)
#define RXPCU_RXBUF_DATA_711_RESET                                             0x0
#define RXPCU_RXBUF_711_ADDRESS                                                (0x1b1c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_711_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_711_RESET                                                  0x0

// 0x1b20 (RXPCU_RXBUF_712)
#define RXPCU_RXBUF_DATA_712_LSB                                               0
#define RXPCU_RXBUF_DATA_712_MSB                                               31
#define RXPCU_RXBUF_DATA_712_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_712_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_712_MASK) >> RXPCU_RXBUF_DATA_712_LSB)
#define RXPCU_RXBUF_DATA_712_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_712_LSB) & RXPCU_RXBUF_DATA_712_MASK)
#define RXPCU_RXBUF_DATA_712_RESET                                             0x0
#define RXPCU_RXBUF_712_ADDRESS                                                (0x1b20 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_712_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_712_RESET                                                  0x0

// 0x1b24 (RXPCU_RXBUF_713)
#define RXPCU_RXBUF_DATA_713_LSB                                               0
#define RXPCU_RXBUF_DATA_713_MSB                                               31
#define RXPCU_RXBUF_DATA_713_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_713_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_713_MASK) >> RXPCU_RXBUF_DATA_713_LSB)
#define RXPCU_RXBUF_DATA_713_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_713_LSB) & RXPCU_RXBUF_DATA_713_MASK)
#define RXPCU_RXBUF_DATA_713_RESET                                             0x0
#define RXPCU_RXBUF_713_ADDRESS                                                (0x1b24 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_713_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_713_RESET                                                  0x0

// 0x1b28 (RXPCU_RXBUF_714)
#define RXPCU_RXBUF_DATA_714_LSB                                               0
#define RXPCU_RXBUF_DATA_714_MSB                                               31
#define RXPCU_RXBUF_DATA_714_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_714_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_714_MASK) >> RXPCU_RXBUF_DATA_714_LSB)
#define RXPCU_RXBUF_DATA_714_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_714_LSB) & RXPCU_RXBUF_DATA_714_MASK)
#define RXPCU_RXBUF_DATA_714_RESET                                             0x0
#define RXPCU_RXBUF_714_ADDRESS                                                (0x1b28 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_714_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_714_RESET                                                  0x0

// 0x1b2c (RXPCU_RXBUF_715)
#define RXPCU_RXBUF_DATA_715_LSB                                               0
#define RXPCU_RXBUF_DATA_715_MSB                                               31
#define RXPCU_RXBUF_DATA_715_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_715_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_715_MASK) >> RXPCU_RXBUF_DATA_715_LSB)
#define RXPCU_RXBUF_DATA_715_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_715_LSB) & RXPCU_RXBUF_DATA_715_MASK)
#define RXPCU_RXBUF_DATA_715_RESET                                             0x0
#define RXPCU_RXBUF_715_ADDRESS                                                (0x1b2c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_715_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_715_RESET                                                  0x0

// 0x1b30 (RXPCU_RXBUF_716)
#define RXPCU_RXBUF_DATA_716_LSB                                               0
#define RXPCU_RXBUF_DATA_716_MSB                                               31
#define RXPCU_RXBUF_DATA_716_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_716_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_716_MASK) >> RXPCU_RXBUF_DATA_716_LSB)
#define RXPCU_RXBUF_DATA_716_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_716_LSB) & RXPCU_RXBUF_DATA_716_MASK)
#define RXPCU_RXBUF_DATA_716_RESET                                             0x0
#define RXPCU_RXBUF_716_ADDRESS                                                (0x1b30 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_716_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_716_RESET                                                  0x0

// 0x1b34 (RXPCU_RXBUF_717)
#define RXPCU_RXBUF_DATA_717_LSB                                               0
#define RXPCU_RXBUF_DATA_717_MSB                                               31
#define RXPCU_RXBUF_DATA_717_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_717_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_717_MASK) >> RXPCU_RXBUF_DATA_717_LSB)
#define RXPCU_RXBUF_DATA_717_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_717_LSB) & RXPCU_RXBUF_DATA_717_MASK)
#define RXPCU_RXBUF_DATA_717_RESET                                             0x0
#define RXPCU_RXBUF_717_ADDRESS                                                (0x1b34 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_717_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_717_RESET                                                  0x0

// 0x1b38 (RXPCU_RXBUF_718)
#define RXPCU_RXBUF_DATA_718_LSB                                               0
#define RXPCU_RXBUF_DATA_718_MSB                                               31
#define RXPCU_RXBUF_DATA_718_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_718_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_718_MASK) >> RXPCU_RXBUF_DATA_718_LSB)
#define RXPCU_RXBUF_DATA_718_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_718_LSB) & RXPCU_RXBUF_DATA_718_MASK)
#define RXPCU_RXBUF_DATA_718_RESET                                             0x0
#define RXPCU_RXBUF_718_ADDRESS                                                (0x1b38 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_718_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_718_RESET                                                  0x0

// 0x1b3c (RXPCU_RXBUF_719)
#define RXPCU_RXBUF_DATA_719_LSB                                               0
#define RXPCU_RXBUF_DATA_719_MSB                                               31
#define RXPCU_RXBUF_DATA_719_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_719_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_719_MASK) >> RXPCU_RXBUF_DATA_719_LSB)
#define RXPCU_RXBUF_DATA_719_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_719_LSB) & RXPCU_RXBUF_DATA_719_MASK)
#define RXPCU_RXBUF_DATA_719_RESET                                             0x0
#define RXPCU_RXBUF_719_ADDRESS                                                (0x1b3c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_719_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_719_RESET                                                  0x0

// 0x1b40 (RXPCU_RXBUF_720)
#define RXPCU_RXBUF_DATA_720_LSB                                               0
#define RXPCU_RXBUF_DATA_720_MSB                                               31
#define RXPCU_RXBUF_DATA_720_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_720_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_720_MASK) >> RXPCU_RXBUF_DATA_720_LSB)
#define RXPCU_RXBUF_DATA_720_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_720_LSB) & RXPCU_RXBUF_DATA_720_MASK)
#define RXPCU_RXBUF_DATA_720_RESET                                             0x0
#define RXPCU_RXBUF_720_ADDRESS                                                (0x1b40 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_720_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_720_RESET                                                  0x0

// 0x1b44 (RXPCU_RXBUF_721)
#define RXPCU_RXBUF_DATA_721_LSB                                               0
#define RXPCU_RXBUF_DATA_721_MSB                                               31
#define RXPCU_RXBUF_DATA_721_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_721_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_721_MASK) >> RXPCU_RXBUF_DATA_721_LSB)
#define RXPCU_RXBUF_DATA_721_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_721_LSB) & RXPCU_RXBUF_DATA_721_MASK)
#define RXPCU_RXBUF_DATA_721_RESET                                             0x0
#define RXPCU_RXBUF_721_ADDRESS                                                (0x1b44 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_721_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_721_RESET                                                  0x0

// 0x1b48 (RXPCU_RXBUF_722)
#define RXPCU_RXBUF_DATA_722_LSB                                               0
#define RXPCU_RXBUF_DATA_722_MSB                                               31
#define RXPCU_RXBUF_DATA_722_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_722_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_722_MASK) >> RXPCU_RXBUF_DATA_722_LSB)
#define RXPCU_RXBUF_DATA_722_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_722_LSB) & RXPCU_RXBUF_DATA_722_MASK)
#define RXPCU_RXBUF_DATA_722_RESET                                             0x0
#define RXPCU_RXBUF_722_ADDRESS                                                (0x1b48 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_722_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_722_RESET                                                  0x0

// 0x1b4c (RXPCU_RXBUF_723)
#define RXPCU_RXBUF_DATA_723_LSB                                               0
#define RXPCU_RXBUF_DATA_723_MSB                                               31
#define RXPCU_RXBUF_DATA_723_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_723_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_723_MASK) >> RXPCU_RXBUF_DATA_723_LSB)
#define RXPCU_RXBUF_DATA_723_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_723_LSB) & RXPCU_RXBUF_DATA_723_MASK)
#define RXPCU_RXBUF_DATA_723_RESET                                             0x0
#define RXPCU_RXBUF_723_ADDRESS                                                (0x1b4c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_723_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_723_RESET                                                  0x0

// 0x1b50 (RXPCU_RXBUF_724)
#define RXPCU_RXBUF_DATA_724_LSB                                               0
#define RXPCU_RXBUF_DATA_724_MSB                                               31
#define RXPCU_RXBUF_DATA_724_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_724_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_724_MASK) >> RXPCU_RXBUF_DATA_724_LSB)
#define RXPCU_RXBUF_DATA_724_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_724_LSB) & RXPCU_RXBUF_DATA_724_MASK)
#define RXPCU_RXBUF_DATA_724_RESET                                             0x0
#define RXPCU_RXBUF_724_ADDRESS                                                (0x1b50 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_724_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_724_RESET                                                  0x0

// 0x1b54 (RXPCU_RXBUF_725)
#define RXPCU_RXBUF_DATA_725_LSB                                               0
#define RXPCU_RXBUF_DATA_725_MSB                                               31
#define RXPCU_RXBUF_DATA_725_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_725_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_725_MASK) >> RXPCU_RXBUF_DATA_725_LSB)
#define RXPCU_RXBUF_DATA_725_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_725_LSB) & RXPCU_RXBUF_DATA_725_MASK)
#define RXPCU_RXBUF_DATA_725_RESET                                             0x0
#define RXPCU_RXBUF_725_ADDRESS                                                (0x1b54 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_725_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_725_RESET                                                  0x0

// 0x1b58 (RXPCU_RXBUF_726)
#define RXPCU_RXBUF_DATA_726_LSB                                               0
#define RXPCU_RXBUF_DATA_726_MSB                                               31
#define RXPCU_RXBUF_DATA_726_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_726_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_726_MASK) >> RXPCU_RXBUF_DATA_726_LSB)
#define RXPCU_RXBUF_DATA_726_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_726_LSB) & RXPCU_RXBUF_DATA_726_MASK)
#define RXPCU_RXBUF_DATA_726_RESET                                             0x0
#define RXPCU_RXBUF_726_ADDRESS                                                (0x1b58 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_726_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_726_RESET                                                  0x0

// 0x1b5c (RXPCU_RXBUF_727)
#define RXPCU_RXBUF_DATA_727_LSB                                               0
#define RXPCU_RXBUF_DATA_727_MSB                                               31
#define RXPCU_RXBUF_DATA_727_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_727_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_727_MASK) >> RXPCU_RXBUF_DATA_727_LSB)
#define RXPCU_RXBUF_DATA_727_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_727_LSB) & RXPCU_RXBUF_DATA_727_MASK)
#define RXPCU_RXBUF_DATA_727_RESET                                             0x0
#define RXPCU_RXBUF_727_ADDRESS                                                (0x1b5c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_727_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_727_RESET                                                  0x0

// 0x1b60 (RXPCU_RXBUF_728)
#define RXPCU_RXBUF_DATA_728_LSB                                               0
#define RXPCU_RXBUF_DATA_728_MSB                                               31
#define RXPCU_RXBUF_DATA_728_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_728_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_728_MASK) >> RXPCU_RXBUF_DATA_728_LSB)
#define RXPCU_RXBUF_DATA_728_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_728_LSB) & RXPCU_RXBUF_DATA_728_MASK)
#define RXPCU_RXBUF_DATA_728_RESET                                             0x0
#define RXPCU_RXBUF_728_ADDRESS                                                (0x1b60 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_728_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_728_RESET                                                  0x0

// 0x1b64 (RXPCU_RXBUF_729)
#define RXPCU_RXBUF_DATA_729_LSB                                               0
#define RXPCU_RXBUF_DATA_729_MSB                                               31
#define RXPCU_RXBUF_DATA_729_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_729_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_729_MASK) >> RXPCU_RXBUF_DATA_729_LSB)
#define RXPCU_RXBUF_DATA_729_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_729_LSB) & RXPCU_RXBUF_DATA_729_MASK)
#define RXPCU_RXBUF_DATA_729_RESET                                             0x0
#define RXPCU_RXBUF_729_ADDRESS                                                (0x1b64 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_729_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_729_RESET                                                  0x0

// 0x1b68 (RXPCU_RXBUF_730)
#define RXPCU_RXBUF_DATA_730_LSB                                               0
#define RXPCU_RXBUF_DATA_730_MSB                                               31
#define RXPCU_RXBUF_DATA_730_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_730_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_730_MASK) >> RXPCU_RXBUF_DATA_730_LSB)
#define RXPCU_RXBUF_DATA_730_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_730_LSB) & RXPCU_RXBUF_DATA_730_MASK)
#define RXPCU_RXBUF_DATA_730_RESET                                             0x0
#define RXPCU_RXBUF_730_ADDRESS                                                (0x1b68 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_730_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_730_RESET                                                  0x0

// 0x1b6c (RXPCU_RXBUF_731)
#define RXPCU_RXBUF_DATA_731_LSB                                               0
#define RXPCU_RXBUF_DATA_731_MSB                                               31
#define RXPCU_RXBUF_DATA_731_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_731_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_731_MASK) >> RXPCU_RXBUF_DATA_731_LSB)
#define RXPCU_RXBUF_DATA_731_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_731_LSB) & RXPCU_RXBUF_DATA_731_MASK)
#define RXPCU_RXBUF_DATA_731_RESET                                             0x0
#define RXPCU_RXBUF_731_ADDRESS                                                (0x1b6c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_731_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_731_RESET                                                  0x0

// 0x1b70 (RXPCU_RXBUF_732)
#define RXPCU_RXBUF_DATA_732_LSB                                               0
#define RXPCU_RXBUF_DATA_732_MSB                                               31
#define RXPCU_RXBUF_DATA_732_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_732_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_732_MASK) >> RXPCU_RXBUF_DATA_732_LSB)
#define RXPCU_RXBUF_DATA_732_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_732_LSB) & RXPCU_RXBUF_DATA_732_MASK)
#define RXPCU_RXBUF_DATA_732_RESET                                             0x0
#define RXPCU_RXBUF_732_ADDRESS                                                (0x1b70 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_732_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_732_RESET                                                  0x0

// 0x1b74 (RXPCU_RXBUF_733)
#define RXPCU_RXBUF_DATA_733_LSB                                               0
#define RXPCU_RXBUF_DATA_733_MSB                                               31
#define RXPCU_RXBUF_DATA_733_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_733_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_733_MASK) >> RXPCU_RXBUF_DATA_733_LSB)
#define RXPCU_RXBUF_DATA_733_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_733_LSB) & RXPCU_RXBUF_DATA_733_MASK)
#define RXPCU_RXBUF_DATA_733_RESET                                             0x0
#define RXPCU_RXBUF_733_ADDRESS                                                (0x1b74 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_733_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_733_RESET                                                  0x0

// 0x1b78 (RXPCU_RXBUF_734)
#define RXPCU_RXBUF_DATA_734_LSB                                               0
#define RXPCU_RXBUF_DATA_734_MSB                                               31
#define RXPCU_RXBUF_DATA_734_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_734_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_734_MASK) >> RXPCU_RXBUF_DATA_734_LSB)
#define RXPCU_RXBUF_DATA_734_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_734_LSB) & RXPCU_RXBUF_DATA_734_MASK)
#define RXPCU_RXBUF_DATA_734_RESET                                             0x0
#define RXPCU_RXBUF_734_ADDRESS                                                (0x1b78 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_734_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_734_RESET                                                  0x0

// 0x1b7c (RXPCU_RXBUF_735)
#define RXPCU_RXBUF_DATA_735_LSB                                               0
#define RXPCU_RXBUF_DATA_735_MSB                                               31
#define RXPCU_RXBUF_DATA_735_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_735_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_735_MASK) >> RXPCU_RXBUF_DATA_735_LSB)
#define RXPCU_RXBUF_DATA_735_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_735_LSB) & RXPCU_RXBUF_DATA_735_MASK)
#define RXPCU_RXBUF_DATA_735_RESET                                             0x0
#define RXPCU_RXBUF_735_ADDRESS                                                (0x1b7c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_735_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_735_RESET                                                  0x0

// 0x1b80 (RXPCU_RXBUF_736)
#define RXPCU_RXBUF_DATA_736_LSB                                               0
#define RXPCU_RXBUF_DATA_736_MSB                                               31
#define RXPCU_RXBUF_DATA_736_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_736_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_736_MASK) >> RXPCU_RXBUF_DATA_736_LSB)
#define RXPCU_RXBUF_DATA_736_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_736_LSB) & RXPCU_RXBUF_DATA_736_MASK)
#define RXPCU_RXBUF_DATA_736_RESET                                             0x0
#define RXPCU_RXBUF_736_ADDRESS                                                (0x1b80 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_736_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_736_RESET                                                  0x0

// 0x1b84 (RXPCU_RXBUF_737)
#define RXPCU_RXBUF_DATA_737_LSB                                               0
#define RXPCU_RXBUF_DATA_737_MSB                                               31
#define RXPCU_RXBUF_DATA_737_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_737_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_737_MASK) >> RXPCU_RXBUF_DATA_737_LSB)
#define RXPCU_RXBUF_DATA_737_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_737_LSB) & RXPCU_RXBUF_DATA_737_MASK)
#define RXPCU_RXBUF_DATA_737_RESET                                             0x0
#define RXPCU_RXBUF_737_ADDRESS                                                (0x1b84 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_737_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_737_RESET                                                  0x0

// 0x1b88 (RXPCU_RXBUF_738)
#define RXPCU_RXBUF_DATA_738_LSB                                               0
#define RXPCU_RXBUF_DATA_738_MSB                                               31
#define RXPCU_RXBUF_DATA_738_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_738_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_738_MASK) >> RXPCU_RXBUF_DATA_738_LSB)
#define RXPCU_RXBUF_DATA_738_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_738_LSB) & RXPCU_RXBUF_DATA_738_MASK)
#define RXPCU_RXBUF_DATA_738_RESET                                             0x0
#define RXPCU_RXBUF_738_ADDRESS                                                (0x1b88 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_738_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_738_RESET                                                  0x0

// 0x1b8c (RXPCU_RXBUF_739)
#define RXPCU_RXBUF_DATA_739_LSB                                               0
#define RXPCU_RXBUF_DATA_739_MSB                                               31
#define RXPCU_RXBUF_DATA_739_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_739_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_739_MASK) >> RXPCU_RXBUF_DATA_739_LSB)
#define RXPCU_RXBUF_DATA_739_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_739_LSB) & RXPCU_RXBUF_DATA_739_MASK)
#define RXPCU_RXBUF_DATA_739_RESET                                             0x0
#define RXPCU_RXBUF_739_ADDRESS                                                (0x1b8c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_739_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_739_RESET                                                  0x0

// 0x1b90 (RXPCU_RXBUF_740)
#define RXPCU_RXBUF_DATA_740_LSB                                               0
#define RXPCU_RXBUF_DATA_740_MSB                                               31
#define RXPCU_RXBUF_DATA_740_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_740_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_740_MASK) >> RXPCU_RXBUF_DATA_740_LSB)
#define RXPCU_RXBUF_DATA_740_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_740_LSB) & RXPCU_RXBUF_DATA_740_MASK)
#define RXPCU_RXBUF_DATA_740_RESET                                             0x0
#define RXPCU_RXBUF_740_ADDRESS                                                (0x1b90 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_740_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_740_RESET                                                  0x0

// 0x1b94 (RXPCU_RXBUF_741)
#define RXPCU_RXBUF_DATA_741_LSB                                               0
#define RXPCU_RXBUF_DATA_741_MSB                                               31
#define RXPCU_RXBUF_DATA_741_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_741_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_741_MASK) >> RXPCU_RXBUF_DATA_741_LSB)
#define RXPCU_RXBUF_DATA_741_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_741_LSB) & RXPCU_RXBUF_DATA_741_MASK)
#define RXPCU_RXBUF_DATA_741_RESET                                             0x0
#define RXPCU_RXBUF_741_ADDRESS                                                (0x1b94 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_741_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_741_RESET                                                  0x0

// 0x1b98 (RXPCU_RXBUF_742)
#define RXPCU_RXBUF_DATA_742_LSB                                               0
#define RXPCU_RXBUF_DATA_742_MSB                                               31
#define RXPCU_RXBUF_DATA_742_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_742_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_742_MASK) >> RXPCU_RXBUF_DATA_742_LSB)
#define RXPCU_RXBUF_DATA_742_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_742_LSB) & RXPCU_RXBUF_DATA_742_MASK)
#define RXPCU_RXBUF_DATA_742_RESET                                             0x0
#define RXPCU_RXBUF_742_ADDRESS                                                (0x1b98 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_742_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_742_RESET                                                  0x0

// 0x1b9c (RXPCU_RXBUF_743)
#define RXPCU_RXBUF_DATA_743_LSB                                               0
#define RXPCU_RXBUF_DATA_743_MSB                                               31
#define RXPCU_RXBUF_DATA_743_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_743_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_743_MASK) >> RXPCU_RXBUF_DATA_743_LSB)
#define RXPCU_RXBUF_DATA_743_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_743_LSB) & RXPCU_RXBUF_DATA_743_MASK)
#define RXPCU_RXBUF_DATA_743_RESET                                             0x0
#define RXPCU_RXBUF_743_ADDRESS                                                (0x1b9c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_743_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_743_RESET                                                  0x0

// 0x1ba0 (RXPCU_RXBUF_744)
#define RXPCU_RXBUF_DATA_744_LSB                                               0
#define RXPCU_RXBUF_DATA_744_MSB                                               31
#define RXPCU_RXBUF_DATA_744_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_744_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_744_MASK) >> RXPCU_RXBUF_DATA_744_LSB)
#define RXPCU_RXBUF_DATA_744_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_744_LSB) & RXPCU_RXBUF_DATA_744_MASK)
#define RXPCU_RXBUF_DATA_744_RESET                                             0x0
#define RXPCU_RXBUF_744_ADDRESS                                                (0x1ba0 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_744_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_744_RESET                                                  0x0

// 0x1ba4 (RXPCU_RXBUF_745)
#define RXPCU_RXBUF_DATA_745_LSB                                               0
#define RXPCU_RXBUF_DATA_745_MSB                                               31
#define RXPCU_RXBUF_DATA_745_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_745_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_745_MASK) >> RXPCU_RXBUF_DATA_745_LSB)
#define RXPCU_RXBUF_DATA_745_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_745_LSB) & RXPCU_RXBUF_DATA_745_MASK)
#define RXPCU_RXBUF_DATA_745_RESET                                             0x0
#define RXPCU_RXBUF_745_ADDRESS                                                (0x1ba4 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_745_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_745_RESET                                                  0x0

// 0x1ba8 (RXPCU_RXBUF_746)
#define RXPCU_RXBUF_DATA_746_LSB                                               0
#define RXPCU_RXBUF_DATA_746_MSB                                               31
#define RXPCU_RXBUF_DATA_746_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_746_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_746_MASK) >> RXPCU_RXBUF_DATA_746_LSB)
#define RXPCU_RXBUF_DATA_746_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_746_LSB) & RXPCU_RXBUF_DATA_746_MASK)
#define RXPCU_RXBUF_DATA_746_RESET                                             0x0
#define RXPCU_RXBUF_746_ADDRESS                                                (0x1ba8 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_746_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_746_RESET                                                  0x0

// 0x1bac (RXPCU_RXBUF_747)
#define RXPCU_RXBUF_DATA_747_LSB                                               0
#define RXPCU_RXBUF_DATA_747_MSB                                               31
#define RXPCU_RXBUF_DATA_747_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_747_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_747_MASK) >> RXPCU_RXBUF_DATA_747_LSB)
#define RXPCU_RXBUF_DATA_747_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_747_LSB) & RXPCU_RXBUF_DATA_747_MASK)
#define RXPCU_RXBUF_DATA_747_RESET                                             0x0
#define RXPCU_RXBUF_747_ADDRESS                                                (0x1bac + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_747_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_747_RESET                                                  0x0

// 0x1bb0 (RXPCU_RXBUF_748)
#define RXPCU_RXBUF_DATA_748_LSB                                               0
#define RXPCU_RXBUF_DATA_748_MSB                                               31
#define RXPCU_RXBUF_DATA_748_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_748_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_748_MASK) >> RXPCU_RXBUF_DATA_748_LSB)
#define RXPCU_RXBUF_DATA_748_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_748_LSB) & RXPCU_RXBUF_DATA_748_MASK)
#define RXPCU_RXBUF_DATA_748_RESET                                             0x0
#define RXPCU_RXBUF_748_ADDRESS                                                (0x1bb0 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_748_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_748_RESET                                                  0x0

// 0x1bb4 (RXPCU_RXBUF_749)
#define RXPCU_RXBUF_DATA_749_LSB                                               0
#define RXPCU_RXBUF_DATA_749_MSB                                               31
#define RXPCU_RXBUF_DATA_749_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_749_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_749_MASK) >> RXPCU_RXBUF_DATA_749_LSB)
#define RXPCU_RXBUF_DATA_749_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_749_LSB) & RXPCU_RXBUF_DATA_749_MASK)
#define RXPCU_RXBUF_DATA_749_RESET                                             0x0
#define RXPCU_RXBUF_749_ADDRESS                                                (0x1bb4 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_749_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_749_RESET                                                  0x0

// 0x1bb8 (RXPCU_RXBUF_750)
#define RXPCU_RXBUF_DATA_750_LSB                                               0
#define RXPCU_RXBUF_DATA_750_MSB                                               31
#define RXPCU_RXBUF_DATA_750_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_750_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_750_MASK) >> RXPCU_RXBUF_DATA_750_LSB)
#define RXPCU_RXBUF_DATA_750_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_750_LSB) & RXPCU_RXBUF_DATA_750_MASK)
#define RXPCU_RXBUF_DATA_750_RESET                                             0x0
#define RXPCU_RXBUF_750_ADDRESS                                                (0x1bb8 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_750_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_750_RESET                                                  0x0

// 0x1bbc (RXPCU_RXBUF_751)
#define RXPCU_RXBUF_DATA_751_LSB                                               0
#define RXPCU_RXBUF_DATA_751_MSB                                               31
#define RXPCU_RXBUF_DATA_751_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_751_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_751_MASK) >> RXPCU_RXBUF_DATA_751_LSB)
#define RXPCU_RXBUF_DATA_751_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_751_LSB) & RXPCU_RXBUF_DATA_751_MASK)
#define RXPCU_RXBUF_DATA_751_RESET                                             0x0
#define RXPCU_RXBUF_751_ADDRESS                                                (0x1bbc + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_751_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_751_RESET                                                  0x0

// 0x1bc0 (RXPCU_RXBUF_752)
#define RXPCU_RXBUF_DATA_752_LSB                                               0
#define RXPCU_RXBUF_DATA_752_MSB                                               31
#define RXPCU_RXBUF_DATA_752_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_752_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_752_MASK) >> RXPCU_RXBUF_DATA_752_LSB)
#define RXPCU_RXBUF_DATA_752_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_752_LSB) & RXPCU_RXBUF_DATA_752_MASK)
#define RXPCU_RXBUF_DATA_752_RESET                                             0x0
#define RXPCU_RXBUF_752_ADDRESS                                                (0x1bc0 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_752_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_752_RESET                                                  0x0

// 0x1bc4 (RXPCU_RXBUF_753)
#define RXPCU_RXBUF_DATA_753_LSB                                               0
#define RXPCU_RXBUF_DATA_753_MSB                                               31
#define RXPCU_RXBUF_DATA_753_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_753_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_753_MASK) >> RXPCU_RXBUF_DATA_753_LSB)
#define RXPCU_RXBUF_DATA_753_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_753_LSB) & RXPCU_RXBUF_DATA_753_MASK)
#define RXPCU_RXBUF_DATA_753_RESET                                             0x0
#define RXPCU_RXBUF_753_ADDRESS                                                (0x1bc4 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_753_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_753_RESET                                                  0x0

// 0x1bc8 (RXPCU_RXBUF_754)
#define RXPCU_RXBUF_DATA_754_LSB                                               0
#define RXPCU_RXBUF_DATA_754_MSB                                               31
#define RXPCU_RXBUF_DATA_754_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_754_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_754_MASK) >> RXPCU_RXBUF_DATA_754_LSB)
#define RXPCU_RXBUF_DATA_754_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_754_LSB) & RXPCU_RXBUF_DATA_754_MASK)
#define RXPCU_RXBUF_DATA_754_RESET                                             0x0
#define RXPCU_RXBUF_754_ADDRESS                                                (0x1bc8 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_754_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_754_RESET                                                  0x0

// 0x1bcc (RXPCU_RXBUF_755)
#define RXPCU_RXBUF_DATA_755_LSB                                               0
#define RXPCU_RXBUF_DATA_755_MSB                                               31
#define RXPCU_RXBUF_DATA_755_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_755_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_755_MASK) >> RXPCU_RXBUF_DATA_755_LSB)
#define RXPCU_RXBUF_DATA_755_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_755_LSB) & RXPCU_RXBUF_DATA_755_MASK)
#define RXPCU_RXBUF_DATA_755_RESET                                             0x0
#define RXPCU_RXBUF_755_ADDRESS                                                (0x1bcc + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_755_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_755_RESET                                                  0x0

// 0x1bd0 (RXPCU_RXBUF_756)
#define RXPCU_RXBUF_DATA_756_LSB                                               0
#define RXPCU_RXBUF_DATA_756_MSB                                               31
#define RXPCU_RXBUF_DATA_756_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_756_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_756_MASK) >> RXPCU_RXBUF_DATA_756_LSB)
#define RXPCU_RXBUF_DATA_756_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_756_LSB) & RXPCU_RXBUF_DATA_756_MASK)
#define RXPCU_RXBUF_DATA_756_RESET                                             0x0
#define RXPCU_RXBUF_756_ADDRESS                                                (0x1bd0 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_756_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_756_RESET                                                  0x0

// 0x1bd4 (RXPCU_RXBUF_757)
#define RXPCU_RXBUF_DATA_757_LSB                                               0
#define RXPCU_RXBUF_DATA_757_MSB                                               31
#define RXPCU_RXBUF_DATA_757_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_757_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_757_MASK) >> RXPCU_RXBUF_DATA_757_LSB)
#define RXPCU_RXBUF_DATA_757_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_757_LSB) & RXPCU_RXBUF_DATA_757_MASK)
#define RXPCU_RXBUF_DATA_757_RESET                                             0x0
#define RXPCU_RXBUF_757_ADDRESS                                                (0x1bd4 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_757_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_757_RESET                                                  0x0

// 0x1bd8 (RXPCU_RXBUF_758)
#define RXPCU_RXBUF_DATA_758_LSB                                               0
#define RXPCU_RXBUF_DATA_758_MSB                                               31
#define RXPCU_RXBUF_DATA_758_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_758_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_758_MASK) >> RXPCU_RXBUF_DATA_758_LSB)
#define RXPCU_RXBUF_DATA_758_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_758_LSB) & RXPCU_RXBUF_DATA_758_MASK)
#define RXPCU_RXBUF_DATA_758_RESET                                             0x0
#define RXPCU_RXBUF_758_ADDRESS                                                (0x1bd8 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_758_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_758_RESET                                                  0x0

// 0x1bdc (RXPCU_RXBUF_759)
#define RXPCU_RXBUF_DATA_759_LSB                                               0
#define RXPCU_RXBUF_DATA_759_MSB                                               31
#define RXPCU_RXBUF_DATA_759_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_759_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_759_MASK) >> RXPCU_RXBUF_DATA_759_LSB)
#define RXPCU_RXBUF_DATA_759_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_759_LSB) & RXPCU_RXBUF_DATA_759_MASK)
#define RXPCU_RXBUF_DATA_759_RESET                                             0x0
#define RXPCU_RXBUF_759_ADDRESS                                                (0x1bdc + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_759_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_759_RESET                                                  0x0

// 0x1be0 (RXPCU_RXBUF_760)
#define RXPCU_RXBUF_DATA_760_LSB                                               0
#define RXPCU_RXBUF_DATA_760_MSB                                               31
#define RXPCU_RXBUF_DATA_760_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_760_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_760_MASK) >> RXPCU_RXBUF_DATA_760_LSB)
#define RXPCU_RXBUF_DATA_760_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_760_LSB) & RXPCU_RXBUF_DATA_760_MASK)
#define RXPCU_RXBUF_DATA_760_RESET                                             0x0
#define RXPCU_RXBUF_760_ADDRESS                                                (0x1be0 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_760_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_760_RESET                                                  0x0

// 0x1be4 (RXPCU_RXBUF_761)
#define RXPCU_RXBUF_DATA_761_LSB                                               0
#define RXPCU_RXBUF_DATA_761_MSB                                               31
#define RXPCU_RXBUF_DATA_761_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_761_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_761_MASK) >> RXPCU_RXBUF_DATA_761_LSB)
#define RXPCU_RXBUF_DATA_761_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_761_LSB) & RXPCU_RXBUF_DATA_761_MASK)
#define RXPCU_RXBUF_DATA_761_RESET                                             0x0
#define RXPCU_RXBUF_761_ADDRESS                                                (0x1be4 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_761_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_761_RESET                                                  0x0

// 0x1be8 (RXPCU_RXBUF_762)
#define RXPCU_RXBUF_DATA_762_LSB                                               0
#define RXPCU_RXBUF_DATA_762_MSB                                               31
#define RXPCU_RXBUF_DATA_762_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_762_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_762_MASK) >> RXPCU_RXBUF_DATA_762_LSB)
#define RXPCU_RXBUF_DATA_762_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_762_LSB) & RXPCU_RXBUF_DATA_762_MASK)
#define RXPCU_RXBUF_DATA_762_RESET                                             0x0
#define RXPCU_RXBUF_762_ADDRESS                                                (0x1be8 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_762_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_762_RESET                                                  0x0

// 0x1bec (RXPCU_RXBUF_763)
#define RXPCU_RXBUF_DATA_763_LSB                                               0
#define RXPCU_RXBUF_DATA_763_MSB                                               31
#define RXPCU_RXBUF_DATA_763_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_763_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_763_MASK) >> RXPCU_RXBUF_DATA_763_LSB)
#define RXPCU_RXBUF_DATA_763_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_763_LSB) & RXPCU_RXBUF_DATA_763_MASK)
#define RXPCU_RXBUF_DATA_763_RESET                                             0x0
#define RXPCU_RXBUF_763_ADDRESS                                                (0x1bec + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_763_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_763_RESET                                                  0x0

// 0x1bf0 (RXPCU_RXBUF_764)
#define RXPCU_RXBUF_DATA_764_LSB                                               0
#define RXPCU_RXBUF_DATA_764_MSB                                               31
#define RXPCU_RXBUF_DATA_764_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_764_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_764_MASK) >> RXPCU_RXBUF_DATA_764_LSB)
#define RXPCU_RXBUF_DATA_764_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_764_LSB) & RXPCU_RXBUF_DATA_764_MASK)
#define RXPCU_RXBUF_DATA_764_RESET                                             0x0
#define RXPCU_RXBUF_764_ADDRESS                                                (0x1bf0 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_764_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_764_RESET                                                  0x0

// 0x1bf4 (RXPCU_RXBUF_765)
#define RXPCU_RXBUF_DATA_765_LSB                                               0
#define RXPCU_RXBUF_DATA_765_MSB                                               31
#define RXPCU_RXBUF_DATA_765_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_765_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_765_MASK) >> RXPCU_RXBUF_DATA_765_LSB)
#define RXPCU_RXBUF_DATA_765_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_765_LSB) & RXPCU_RXBUF_DATA_765_MASK)
#define RXPCU_RXBUF_DATA_765_RESET                                             0x0
#define RXPCU_RXBUF_765_ADDRESS                                                (0x1bf4 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_765_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_765_RESET                                                  0x0

// 0x1bf8 (RXPCU_RXBUF_766)
#define RXPCU_RXBUF_DATA_766_LSB                                               0
#define RXPCU_RXBUF_DATA_766_MSB                                               31
#define RXPCU_RXBUF_DATA_766_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_766_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_766_MASK) >> RXPCU_RXBUF_DATA_766_LSB)
#define RXPCU_RXBUF_DATA_766_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_766_LSB) & RXPCU_RXBUF_DATA_766_MASK)
#define RXPCU_RXBUF_DATA_766_RESET                                             0x0
#define RXPCU_RXBUF_766_ADDRESS                                                (0x1bf8 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_766_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_766_RESET                                                  0x0

// 0x1bfc (RXPCU_RXBUF_767)
#define RXPCU_RXBUF_DATA_767_LSB                                               0
#define RXPCU_RXBUF_DATA_767_MSB                                               31
#define RXPCU_RXBUF_DATA_767_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_767_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_767_MASK) >> RXPCU_RXBUF_DATA_767_LSB)
#define RXPCU_RXBUF_DATA_767_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_767_LSB) & RXPCU_RXBUF_DATA_767_MASK)
#define RXPCU_RXBUF_DATA_767_RESET                                             0x0
#define RXPCU_RXBUF_767_ADDRESS                                                (0x1bfc + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_767_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_767_RESET                                                  0x0

// 0x1c00 (RXPCU_RXBUF_768)
#define RXPCU_RXBUF_DATA_768_LSB                                               0
#define RXPCU_RXBUF_DATA_768_MSB                                               31
#define RXPCU_RXBUF_DATA_768_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_768_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_768_MASK) >> RXPCU_RXBUF_DATA_768_LSB)
#define RXPCU_RXBUF_DATA_768_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_768_LSB) & RXPCU_RXBUF_DATA_768_MASK)
#define RXPCU_RXBUF_DATA_768_RESET                                             0x0
#define RXPCU_RXBUF_768_ADDRESS                                                (0x1c00 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_768_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_768_RESET                                                  0x0

// 0x1c04 (RXPCU_RXBUF_769)
#define RXPCU_RXBUF_DATA_769_LSB                                               0
#define RXPCU_RXBUF_DATA_769_MSB                                               31
#define RXPCU_RXBUF_DATA_769_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_769_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_769_MASK) >> RXPCU_RXBUF_DATA_769_LSB)
#define RXPCU_RXBUF_DATA_769_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_769_LSB) & RXPCU_RXBUF_DATA_769_MASK)
#define RXPCU_RXBUF_DATA_769_RESET                                             0x0
#define RXPCU_RXBUF_769_ADDRESS                                                (0x1c04 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_769_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_769_RESET                                                  0x0

// 0x1c08 (RXPCU_RXBUF_770)
#define RXPCU_RXBUF_DATA_770_LSB                                               0
#define RXPCU_RXBUF_DATA_770_MSB                                               31
#define RXPCU_RXBUF_DATA_770_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_770_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_770_MASK) >> RXPCU_RXBUF_DATA_770_LSB)
#define RXPCU_RXBUF_DATA_770_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_770_LSB) & RXPCU_RXBUF_DATA_770_MASK)
#define RXPCU_RXBUF_DATA_770_RESET                                             0x0
#define RXPCU_RXBUF_770_ADDRESS                                                (0x1c08 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_770_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_770_RESET                                                  0x0

// 0x1c0c (RXPCU_RXBUF_771)
#define RXPCU_RXBUF_DATA_771_LSB                                               0
#define RXPCU_RXBUF_DATA_771_MSB                                               31
#define RXPCU_RXBUF_DATA_771_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_771_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_771_MASK) >> RXPCU_RXBUF_DATA_771_LSB)
#define RXPCU_RXBUF_DATA_771_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_771_LSB) & RXPCU_RXBUF_DATA_771_MASK)
#define RXPCU_RXBUF_DATA_771_RESET                                             0x0
#define RXPCU_RXBUF_771_ADDRESS                                                (0x1c0c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_771_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_771_RESET                                                  0x0

// 0x1c10 (RXPCU_RXBUF_772)
#define RXPCU_RXBUF_DATA_772_LSB                                               0
#define RXPCU_RXBUF_DATA_772_MSB                                               31
#define RXPCU_RXBUF_DATA_772_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_772_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_772_MASK) >> RXPCU_RXBUF_DATA_772_LSB)
#define RXPCU_RXBUF_DATA_772_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_772_LSB) & RXPCU_RXBUF_DATA_772_MASK)
#define RXPCU_RXBUF_DATA_772_RESET                                             0x0
#define RXPCU_RXBUF_772_ADDRESS                                                (0x1c10 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_772_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_772_RESET                                                  0x0

// 0x1c14 (RXPCU_RXBUF_773)
#define RXPCU_RXBUF_DATA_773_LSB                                               0
#define RXPCU_RXBUF_DATA_773_MSB                                               31
#define RXPCU_RXBUF_DATA_773_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_773_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_773_MASK) >> RXPCU_RXBUF_DATA_773_LSB)
#define RXPCU_RXBUF_DATA_773_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_773_LSB) & RXPCU_RXBUF_DATA_773_MASK)
#define RXPCU_RXBUF_DATA_773_RESET                                             0x0
#define RXPCU_RXBUF_773_ADDRESS                                                (0x1c14 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_773_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_773_RESET                                                  0x0

// 0x1c18 (RXPCU_RXBUF_774)
#define RXPCU_RXBUF_DATA_774_LSB                                               0
#define RXPCU_RXBUF_DATA_774_MSB                                               31
#define RXPCU_RXBUF_DATA_774_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_774_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_774_MASK) >> RXPCU_RXBUF_DATA_774_LSB)
#define RXPCU_RXBUF_DATA_774_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_774_LSB) & RXPCU_RXBUF_DATA_774_MASK)
#define RXPCU_RXBUF_DATA_774_RESET                                             0x0
#define RXPCU_RXBUF_774_ADDRESS                                                (0x1c18 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_774_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_774_RESET                                                  0x0

// 0x1c1c (RXPCU_RXBUF_775)
#define RXPCU_RXBUF_DATA_775_LSB                                               0
#define RXPCU_RXBUF_DATA_775_MSB                                               31
#define RXPCU_RXBUF_DATA_775_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_775_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_775_MASK) >> RXPCU_RXBUF_DATA_775_LSB)
#define RXPCU_RXBUF_DATA_775_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_775_LSB) & RXPCU_RXBUF_DATA_775_MASK)
#define RXPCU_RXBUF_DATA_775_RESET                                             0x0
#define RXPCU_RXBUF_775_ADDRESS                                                (0x1c1c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_775_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_775_RESET                                                  0x0

// 0x1c20 (RXPCU_RXBUF_776)
#define RXPCU_RXBUF_DATA_776_LSB                                               0
#define RXPCU_RXBUF_DATA_776_MSB                                               31
#define RXPCU_RXBUF_DATA_776_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_776_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_776_MASK) >> RXPCU_RXBUF_DATA_776_LSB)
#define RXPCU_RXBUF_DATA_776_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_776_LSB) & RXPCU_RXBUF_DATA_776_MASK)
#define RXPCU_RXBUF_DATA_776_RESET                                             0x0
#define RXPCU_RXBUF_776_ADDRESS                                                (0x1c20 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_776_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_776_RESET                                                  0x0

// 0x1c24 (RXPCU_RXBUF_777)
#define RXPCU_RXBUF_DATA_777_LSB                                               0
#define RXPCU_RXBUF_DATA_777_MSB                                               31
#define RXPCU_RXBUF_DATA_777_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_777_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_777_MASK) >> RXPCU_RXBUF_DATA_777_LSB)
#define RXPCU_RXBUF_DATA_777_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_777_LSB) & RXPCU_RXBUF_DATA_777_MASK)
#define RXPCU_RXBUF_DATA_777_RESET                                             0x0
#define RXPCU_RXBUF_777_ADDRESS                                                (0x1c24 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_777_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_777_RESET                                                  0x0

// 0x1c28 (RXPCU_RXBUF_778)
#define RXPCU_RXBUF_DATA_778_LSB                                               0
#define RXPCU_RXBUF_DATA_778_MSB                                               31
#define RXPCU_RXBUF_DATA_778_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_778_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_778_MASK) >> RXPCU_RXBUF_DATA_778_LSB)
#define RXPCU_RXBUF_DATA_778_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_778_LSB) & RXPCU_RXBUF_DATA_778_MASK)
#define RXPCU_RXBUF_DATA_778_RESET                                             0x0
#define RXPCU_RXBUF_778_ADDRESS                                                (0x1c28 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_778_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_778_RESET                                                  0x0

// 0x1c2c (RXPCU_RXBUF_779)
#define RXPCU_RXBUF_DATA_779_LSB                                               0
#define RXPCU_RXBUF_DATA_779_MSB                                               31
#define RXPCU_RXBUF_DATA_779_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_779_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_779_MASK) >> RXPCU_RXBUF_DATA_779_LSB)
#define RXPCU_RXBUF_DATA_779_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_779_LSB) & RXPCU_RXBUF_DATA_779_MASK)
#define RXPCU_RXBUF_DATA_779_RESET                                             0x0
#define RXPCU_RXBUF_779_ADDRESS                                                (0x1c2c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_779_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_779_RESET                                                  0x0

// 0x1c30 (RXPCU_RXBUF_780)
#define RXPCU_RXBUF_DATA_780_LSB                                               0
#define RXPCU_RXBUF_DATA_780_MSB                                               31
#define RXPCU_RXBUF_DATA_780_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_780_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_780_MASK) >> RXPCU_RXBUF_DATA_780_LSB)
#define RXPCU_RXBUF_DATA_780_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_780_LSB) & RXPCU_RXBUF_DATA_780_MASK)
#define RXPCU_RXBUF_DATA_780_RESET                                             0x0
#define RXPCU_RXBUF_780_ADDRESS                                                (0x1c30 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_780_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_780_RESET                                                  0x0

// 0x1c34 (RXPCU_RXBUF_781)
#define RXPCU_RXBUF_DATA_781_LSB                                               0
#define RXPCU_RXBUF_DATA_781_MSB                                               31
#define RXPCU_RXBUF_DATA_781_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_781_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_781_MASK) >> RXPCU_RXBUF_DATA_781_LSB)
#define RXPCU_RXBUF_DATA_781_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_781_LSB) & RXPCU_RXBUF_DATA_781_MASK)
#define RXPCU_RXBUF_DATA_781_RESET                                             0x0
#define RXPCU_RXBUF_781_ADDRESS                                                (0x1c34 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_781_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_781_RESET                                                  0x0

// 0x1c38 (RXPCU_RXBUF_782)
#define RXPCU_RXBUF_DATA_782_LSB                                               0
#define RXPCU_RXBUF_DATA_782_MSB                                               31
#define RXPCU_RXBUF_DATA_782_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_782_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_782_MASK) >> RXPCU_RXBUF_DATA_782_LSB)
#define RXPCU_RXBUF_DATA_782_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_782_LSB) & RXPCU_RXBUF_DATA_782_MASK)
#define RXPCU_RXBUF_DATA_782_RESET                                             0x0
#define RXPCU_RXBUF_782_ADDRESS                                                (0x1c38 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_782_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_782_RESET                                                  0x0

// 0x1c3c (RXPCU_RXBUF_783)
#define RXPCU_RXBUF_DATA_783_LSB                                               0
#define RXPCU_RXBUF_DATA_783_MSB                                               31
#define RXPCU_RXBUF_DATA_783_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_783_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_783_MASK) >> RXPCU_RXBUF_DATA_783_LSB)
#define RXPCU_RXBUF_DATA_783_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_783_LSB) & RXPCU_RXBUF_DATA_783_MASK)
#define RXPCU_RXBUF_DATA_783_RESET                                             0x0
#define RXPCU_RXBUF_783_ADDRESS                                                (0x1c3c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_783_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_783_RESET                                                  0x0

// 0x1c40 (RXPCU_RXBUF_784)
#define RXPCU_RXBUF_DATA_784_LSB                                               0
#define RXPCU_RXBUF_DATA_784_MSB                                               31
#define RXPCU_RXBUF_DATA_784_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_784_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_784_MASK) >> RXPCU_RXBUF_DATA_784_LSB)
#define RXPCU_RXBUF_DATA_784_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_784_LSB) & RXPCU_RXBUF_DATA_784_MASK)
#define RXPCU_RXBUF_DATA_784_RESET                                             0x0
#define RXPCU_RXBUF_784_ADDRESS                                                (0x1c40 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_784_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_784_RESET                                                  0x0

// 0x1c44 (RXPCU_RXBUF_785)
#define RXPCU_RXBUF_DATA_785_LSB                                               0
#define RXPCU_RXBUF_DATA_785_MSB                                               31
#define RXPCU_RXBUF_DATA_785_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_785_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_785_MASK) >> RXPCU_RXBUF_DATA_785_LSB)
#define RXPCU_RXBUF_DATA_785_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_785_LSB) & RXPCU_RXBUF_DATA_785_MASK)
#define RXPCU_RXBUF_DATA_785_RESET                                             0x0
#define RXPCU_RXBUF_785_ADDRESS                                                (0x1c44 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_785_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_785_RESET                                                  0x0

// 0x1c48 (RXPCU_RXBUF_786)
#define RXPCU_RXBUF_DATA_786_LSB                                               0
#define RXPCU_RXBUF_DATA_786_MSB                                               31
#define RXPCU_RXBUF_DATA_786_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_786_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_786_MASK) >> RXPCU_RXBUF_DATA_786_LSB)
#define RXPCU_RXBUF_DATA_786_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_786_LSB) & RXPCU_RXBUF_DATA_786_MASK)
#define RXPCU_RXBUF_DATA_786_RESET                                             0x0
#define RXPCU_RXBUF_786_ADDRESS                                                (0x1c48 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_786_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_786_RESET                                                  0x0

// 0x1c4c (RXPCU_RXBUF_787)
#define RXPCU_RXBUF_DATA_787_LSB                                               0
#define RXPCU_RXBUF_DATA_787_MSB                                               31
#define RXPCU_RXBUF_DATA_787_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_787_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_787_MASK) >> RXPCU_RXBUF_DATA_787_LSB)
#define RXPCU_RXBUF_DATA_787_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_787_LSB) & RXPCU_RXBUF_DATA_787_MASK)
#define RXPCU_RXBUF_DATA_787_RESET                                             0x0
#define RXPCU_RXBUF_787_ADDRESS                                                (0x1c4c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_787_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_787_RESET                                                  0x0

// 0x1c50 (RXPCU_RXBUF_788)
#define RXPCU_RXBUF_DATA_788_LSB                                               0
#define RXPCU_RXBUF_DATA_788_MSB                                               31
#define RXPCU_RXBUF_DATA_788_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_788_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_788_MASK) >> RXPCU_RXBUF_DATA_788_LSB)
#define RXPCU_RXBUF_DATA_788_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_788_LSB) & RXPCU_RXBUF_DATA_788_MASK)
#define RXPCU_RXBUF_DATA_788_RESET                                             0x0
#define RXPCU_RXBUF_788_ADDRESS                                                (0x1c50 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_788_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_788_RESET                                                  0x0

// 0x1c54 (RXPCU_RXBUF_789)
#define RXPCU_RXBUF_DATA_789_LSB                                               0
#define RXPCU_RXBUF_DATA_789_MSB                                               31
#define RXPCU_RXBUF_DATA_789_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_789_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_789_MASK) >> RXPCU_RXBUF_DATA_789_LSB)
#define RXPCU_RXBUF_DATA_789_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_789_LSB) & RXPCU_RXBUF_DATA_789_MASK)
#define RXPCU_RXBUF_DATA_789_RESET                                             0x0
#define RXPCU_RXBUF_789_ADDRESS                                                (0x1c54 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_789_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_789_RESET                                                  0x0

// 0x1c58 (RXPCU_RXBUF_790)
#define RXPCU_RXBUF_DATA_790_LSB                                               0
#define RXPCU_RXBUF_DATA_790_MSB                                               31
#define RXPCU_RXBUF_DATA_790_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_790_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_790_MASK) >> RXPCU_RXBUF_DATA_790_LSB)
#define RXPCU_RXBUF_DATA_790_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_790_LSB) & RXPCU_RXBUF_DATA_790_MASK)
#define RXPCU_RXBUF_DATA_790_RESET                                             0x0
#define RXPCU_RXBUF_790_ADDRESS                                                (0x1c58 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_790_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_790_RESET                                                  0x0

// 0x1c5c (RXPCU_RXBUF_791)
#define RXPCU_RXBUF_DATA_791_LSB                                               0
#define RXPCU_RXBUF_DATA_791_MSB                                               31
#define RXPCU_RXBUF_DATA_791_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_791_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_791_MASK) >> RXPCU_RXBUF_DATA_791_LSB)
#define RXPCU_RXBUF_DATA_791_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_791_LSB) & RXPCU_RXBUF_DATA_791_MASK)
#define RXPCU_RXBUF_DATA_791_RESET                                             0x0
#define RXPCU_RXBUF_791_ADDRESS                                                (0x1c5c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_791_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_791_RESET                                                  0x0

// 0x1c60 (RXPCU_RXBUF_792)
#define RXPCU_RXBUF_DATA_792_LSB                                               0
#define RXPCU_RXBUF_DATA_792_MSB                                               31
#define RXPCU_RXBUF_DATA_792_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_792_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_792_MASK) >> RXPCU_RXBUF_DATA_792_LSB)
#define RXPCU_RXBUF_DATA_792_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_792_LSB) & RXPCU_RXBUF_DATA_792_MASK)
#define RXPCU_RXBUF_DATA_792_RESET                                             0x0
#define RXPCU_RXBUF_792_ADDRESS                                                (0x1c60 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_792_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_792_RESET                                                  0x0

// 0x1c64 (RXPCU_RXBUF_793)
#define RXPCU_RXBUF_DATA_793_LSB                                               0
#define RXPCU_RXBUF_DATA_793_MSB                                               31
#define RXPCU_RXBUF_DATA_793_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_793_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_793_MASK) >> RXPCU_RXBUF_DATA_793_LSB)
#define RXPCU_RXBUF_DATA_793_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_793_LSB) & RXPCU_RXBUF_DATA_793_MASK)
#define RXPCU_RXBUF_DATA_793_RESET                                             0x0
#define RXPCU_RXBUF_793_ADDRESS                                                (0x1c64 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_793_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_793_RESET                                                  0x0

// 0x1c68 (RXPCU_RXBUF_794)
#define RXPCU_RXBUF_DATA_794_LSB                                               0
#define RXPCU_RXBUF_DATA_794_MSB                                               31
#define RXPCU_RXBUF_DATA_794_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_794_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_794_MASK) >> RXPCU_RXBUF_DATA_794_LSB)
#define RXPCU_RXBUF_DATA_794_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_794_LSB) & RXPCU_RXBUF_DATA_794_MASK)
#define RXPCU_RXBUF_DATA_794_RESET                                             0x0
#define RXPCU_RXBUF_794_ADDRESS                                                (0x1c68 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_794_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_794_RESET                                                  0x0

// 0x1c6c (RXPCU_RXBUF_795)
#define RXPCU_RXBUF_DATA_795_LSB                                               0
#define RXPCU_RXBUF_DATA_795_MSB                                               31
#define RXPCU_RXBUF_DATA_795_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_795_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_795_MASK) >> RXPCU_RXBUF_DATA_795_LSB)
#define RXPCU_RXBUF_DATA_795_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_795_LSB) & RXPCU_RXBUF_DATA_795_MASK)
#define RXPCU_RXBUF_DATA_795_RESET                                             0x0
#define RXPCU_RXBUF_795_ADDRESS                                                (0x1c6c + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_795_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_795_RESET                                                  0x0

// 0x1c70 (RXPCU_RXBUF_796)
#define RXPCU_RXBUF_DATA_796_LSB                                               0
#define RXPCU_RXBUF_DATA_796_MSB                                               31
#define RXPCU_RXBUF_DATA_796_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_796_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_796_MASK) >> RXPCU_RXBUF_DATA_796_LSB)
#define RXPCU_RXBUF_DATA_796_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_796_LSB) & RXPCU_RXBUF_DATA_796_MASK)
#define RXPCU_RXBUF_DATA_796_RESET                                             0x0
#define RXPCU_RXBUF_796_ADDRESS                                                (0x1c70 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_796_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_796_RESET                                                  0x0

// 0x1c74 (RXPCU_RXBUF_797)
#define RXPCU_RXBUF_DATA_797_LSB                                               0
#define RXPCU_RXBUF_DATA_797_MSB                                               31
#define RXPCU_RXBUF_DATA_797_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_797_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_797_MASK) >> RXPCU_RXBUF_DATA_797_LSB)
#define RXPCU_RXBUF_DATA_797_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_797_LSB) & RXPCU_RXBUF_DATA_797_MASK)
#define RXPCU_RXBUF_DATA_797_RESET                                             0x0
#define RXPCU_RXBUF_797_ADDRESS                                                (0x1c74 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_797_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_797_RESET                                                  0x0

// 0x1c78 (RXPCU_RXBUF_798)
#define RXPCU_RXBUF_DATA_798_LSB                                               0
#define RXPCU_RXBUF_DATA_798_MSB                                               31
#define RXPCU_RXBUF_DATA_798_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_798_GET(x)                                            (((x) & RXPCU_RXBUF_DATA_798_MASK) >> RXPCU_RXBUF_DATA_798_LSB)
#define RXPCU_RXBUF_DATA_798_SET(x)                                            (((0 | (x)) << RXPCU_RXBUF_DATA_798_LSB) & RXPCU_RXBUF_DATA_798_MASK)
#define RXPCU_RXBUF_DATA_798_RESET                                             0x0
#define RXPCU_RXBUF_798_ADDRESS                                                (0x1c78 + __MAC_RXPCU_REG_BASE_ADDRESS)
#define RXPCU_RXBUF_798_RSTMASK                                                0xffffffff
#define RXPCU_RXBUF_798_RESET                                                  0x0

// 0x1c7c (RXPCU_RXBUF_799)
#define RXPCU_RXBUF_DATA_799_LSB                                               0
#define RXPCU_RXBUF_DATA_799_MSB                                               31
#define RXPCU_RXBUF_DATA_799_MASK                                              0xffffffff
#define RXPCU_RXBUF_DATA_799_GET(x)                                            (((x) & R