// Copyright (c) 2014 Qualcomm Atheros, Inc.  All rights reserved.
// $ATH_LICENSE_HW_HDR_C$
//
// DO NOT EDIT!  This file is automatically generated
//               These definitions are tied to a particular hardware layout


#ifndef _TX_MSDU_START_USERX_H_
#define _TX_MSDU_START_USERX_H_
#if !defined(__ASSEMBLER__)
#endif

// ################ START SUMMARY #################
//
//	Dword	Fields
//	0	msdu_len[13:0], first_msdu[14], last_msdu[15], encap_type[17:16], wds[18], ipv4_checksum_en[19], udp_over_ipv4_checksum_en[20], udp_over_ipv6_checksum_en[21], tcp_over_ipv4_checksum_en[22], tcp_over_ipv6_checksum_en[23], reserved_0[31:24]
//	1	tso_enable[0], reserved_1a[6:1], tcp_flag[15:7], tcp_flag_mask[24:16], reserved_1b[31:25]
//	2	l2_length[15:0], ip_length[31:16]
//	3	tcp_seq_number[31:0]
//	4	ip_identification[15:0], reserved_4a[31:16]
//
// ################ END SUMMARY #################

#define NUM_OF_DWORDS_TX_MSDU_START_USERX 5

struct tx_msdu_start_userx {
    volatile uint32_t msdu_len                        : 14, //[13:0]
                      first_msdu                      :  1, //[14]
                      last_msdu                       :  1, //[15]
                      encap_type                      :  2, //[17:16]
                      wds                             :  1, //[18]
                      ipv4_checksum_en                :  1, //[19]
                      udp_over_ipv4_checksum_en       :  1, //[20]
                      udp_over_ipv6_checksum_en       :  1, //[21]
                      tcp_over_ipv4_checksum_en       :  1, //[22]
                      tcp_over_ipv6_checksum_en       :  1, //[23]
                      reserved_0                      :  8; //[31:24]
    volatile uint32_t tso_enable                      :  1, //[0]
                      reserved_1a                     :  6, //[6:1]
                      tcp_flag                        :  9, //[15:7]
                      tcp_flag_mask                   :  9, //[24:16]
                      reserved_1b                     :  7; //[31:25]
    volatile uint32_t l2_length                       : 16, //[15:0]
                      ip_length                       : 16; //[31:16]
    volatile uint32_t tcp_seq_number                  : 32; //[31:0]
    volatile uint32_t ip_identification               : 16, //[15:0]
                      reserved_4a                     : 16; //[31:16]
};

/*

msdu_len
			
			MSDU length before encapsulation. It is the same value
			as the length in the MSDU packet TLV

first_msdu
			
			If set the current MSDU is the first MSDU in MPDU.  Used
			by the OLE during encapsulation.

last_msdu
			
			If set the current MSDU is the last MSDU in MPDU.  Used
			by the OLE during encapsulation.

encap_type
			
			Indicates the encapsulation that HW will perform:
			
			<enum 0 RAW> No encapsulation
			
			<enum 1 Native_WiFi>
			
			<enum 2 Ethernet> Ethernet 2 (DIX)  
			
			<enum 3 802_3> 802.3 (uses SNAP/LLC)
			
			Used by the OLE during encapsulation.
			
			<legal all>

wds
			
			If set the current packet is 4-address frame.  Required
			because an aggregate can include some frames with 3 address
			format and other frames with 4 address format.  The wds bit
			is only valid when first_msdu bit is set.  Used by the OLE
			during encapsulation.  

ipv4_checksum_en
			
			Enable IPv4 checksum replacement

udp_over_ipv4_checksum_en
			
			Enable UDP over IPv4 checksum replacement.  UDP checksum
			over IPv4 is optional for TCP/IP stacks.

udp_over_ipv6_checksum_en
			
			Enable UDP over IPv6 checksum replacement.  UDP checksum
			over IPv6 is mandatory for TCP/IP stacks.

tcp_over_ipv4_checksum_en
			
			Enable TCP checksum over IPv4 replacement

tcp_over_ipv6_checksum_en
			
			Enable TCP checksum over IPv6 eplacement

reserved_0
			
			FW will set to 0, MAC will ignore.  <legal 0>

tso_enable
			
			Enable transmit segmentation offload <legal all>

reserved_1a
			
			FW will set to 0, MAC will ignore.  <legal 0>

tcp_flag
			
			TCP flags
			
			{NS,CWR,ECE,URG,ACK,PSH, RST ,SYN,FIN}<legal all>

tcp_flag_mask
			
			TCP flag mask. Tcp_flag is inserted into the header
			based on the mask, if tso is enabled

reserved_1b
			
			FW will set to 0, MAC will ignore.  <legal 0>

l2_length
			
			L2 length for the msdu, if tso is enabled <legal all>

ip_length
			
			Ip length for the msdu, if tso is enabled <legal all>

tcp_seq_number
			
			Tcp_seq_number for the msdu, if tso is enabled <legal
			all>

ip_identification
			
			Ip_identification for the msdu, if tso is enabled <legal
			all>

reserved_4a
			
			FW will set to 0, MAC will ignore.  <legal 0>
*/


/* Description		TX_MSDU_START_USERX_0_MSDU_LEN
			
			MSDU length before encapsulation. It is the same value
			as the length in the MSDU packet TLV
*/
#define TX_MSDU_START_USERX_0_MSDU_LEN_OFFSET                        0x00000000
#define TX_MSDU_START_USERX_0_MSDU_LEN_LSB                           0
#define TX_MSDU_START_USERX_0_MSDU_LEN_MASK                          0x00003fff

/* Description		TX_MSDU_START_USERX_0_FIRST_MSDU
			
			If set the current MSDU is the first MSDU in MPDU.  Used
			by the OLE during encapsulation.
*/
#define TX_MSDU_START_USERX_0_FIRST_MSDU_OFFSET                      0x00000000
#define TX_MSDU_START_USERX_0_FIRST_MSDU_LSB                         14
#define TX_MSDU_START_USERX_0_FIRST_MSDU_MASK                        0x00004000

/* Description		TX_MSDU_START_USERX_0_LAST_MSDU
			
			If set the current MSDU is the last MSDU in MPDU.  Used
			by the OLE during encapsulation.
*/
#define TX_MSDU_START_USERX_0_LAST_MSDU_OFFSET                       0x00000000
#define TX_MSDU_START_USERX_0_LAST_MSDU_LSB                          15
#define TX_MSDU_START_USERX_0_LAST_MSDU_MASK                         0x00008000

/* Description		TX_MSDU_START_USERX_0_ENCAP_TYPE
			
			Indicates the encapsulation that HW will perform:
			
			<enum 0 RAW> No encapsulation
			
			<enum 1 Native_WiFi>
			
			<enum 2 Ethernet> Ethernet 2 (DIX)  
			
			<enum 3 802_3> 802.3 (uses SNAP/LLC)
			
			Used by the OLE during encapsulation.
			
			<legal all>
*/
#define TX_MSDU_START_USERX_0_ENCAP_TYPE_OFFSET                      0x00000000
#define TX_MSDU_START_USERX_0_ENCAP_TYPE_LSB                         16
#define TX_MSDU_START_USERX_0_ENCAP_TYPE_MASK                        0x00030000

/* Description		TX_MSDU_START_USERX_0_WDS
			
			If set the current packet is 4-address frame.  Required
			because an aggregate can include some frames with 3 address
			format and other frames with 4 address format.  The wds bit
			is only valid when first_msdu bit is set.  Used by the OLE
			during encapsulation.  
*/
#define TX_MSDU_START_USERX_0_WDS_OFFSET                             0x00000000
#define TX_MSDU_START_USERX_0_WDS_LSB                                18
#define TX_MSDU_START_USERX_0_WDS_MASK                               0x00040000

/* Description		TX_MSDU_START_USERX_0_IPV4_CHECKSUM_EN
			
			Enable IPv4 checksum replacement
*/
#define TX_MSDU_START_USERX_0_IPV4_CHECKSUM_EN_OFFSET                0x00000000
#define TX_MSDU_START_USERX_0_IPV4_CHECKSUM_EN_LSB                   19
#define TX_MSDU_START_USERX_0_IPV4_CHECKSUM_EN_MASK                  0x00080000

/* Description		TX_MSDU_START_USERX_0_UDP_OVER_IPV4_CHECKSUM_EN
			
			Enable UDP over IPv4 checksum replacement.  UDP checksum
			over IPv4 is optional for TCP/IP stacks.
*/
#define TX_MSDU_START_USERX_0_UDP_OVER_IPV4_CHECKSUM_EN_OFFSET       0x00000000
#define TX_MSDU_START_USERX_0_UDP_OVER_IPV4_CHECKSUM_EN_LSB          20
#define TX_MSDU_START_USERX_0_UDP_OVER_IPV4_CHECKSUM_EN_MASK         0x00100000

/* Description		TX_MSDU_START_USERX_0_UDP_OVER_IPV6_CHECKSUM_EN
			
			Enable UDP over IPv6 checksum replacement.  UDP checksum
			over IPv6 is mandatory for TCP/IP stacks.
*/
#define TX_MSDU_START_USERX_0_UDP_OVER_IPV6_CHECKSUM_EN_OFFSET       0x00000000
#define TX_MSDU_START_USERX_0_UDP_OVER_IPV6_CHECKSUM_EN_LSB          21
#define TX_MSDU_START_USERX_0_UDP_OVER_IPV6_CHECKSUM_EN_MASK         0x00200000

/* Description		TX_MSDU_START_USERX_0_TCP_OVER_IPV4_CHECKSUM_EN
			
			Enable TCP checksum over IPv4 replacement
*/
#define TX_MSDU_START_USERX_0_TCP_OVER_IPV4_CHECKSUM_EN_OFFSET       0x00000000
#define TX_MSDU_START_USERX_0_TCP_OVER_IPV4_CHECKSUM_EN_LSB          22
#define TX_MSDU_START_USERX_0_TCP_OVER_IPV4_CHECKSUM_EN_MASK         0x00400000

/* Description		TX_MSDU_START_USERX_0_TCP_OVER_IPV6_CHECKSUM_EN
			
			Enable TCP checksum over IPv6 eplacement
*/
#define TX_MSDU_START_USERX_0_TCP_OVER_IPV6_CHECKSUM_EN_OFFSET       0x00000000
#define TX_MSDU_START_USERX_0_TCP_OVER_IPV6_CHECKSUM_EN_LSB          23
#define TX_MSDU_START_USERX_0_TCP_OVER_IPV6_CHECKSUM_EN_MASK         0x00800000

/* Description		TX_MSDU_START_USERX_0_RESERVED_0
			
			FW will set to 0, MAC will ignore.  <legal 0>
*/
#define TX_MSDU_START_USERX_0_RESERVED_0_OFFSET                      0x00000000
#define TX_MSDU_START_USERX_0_RESERVED_0_LSB                         24
#define TX_MSDU_START_USERX_0_RESERVED_0_MASK                        0xff000000

/* Description		TX_MSDU_START_USERX_1_TSO_ENABLE
			
			Enable transmit segmentation offload <legal all>
*/
#define TX_MSDU_START_USERX_1_TSO_ENABLE_OFFSET                      0x00000004
#define TX_MSDU_START_USERX_1_TSO_ENABLE_LSB                         0
#define TX_MSDU_START_USERX_1_TSO_ENABLE_MASK                        0x00000001

/* Description		TX_MSDU_START_USERX_1_RESERVED_1A
			
			FW will set to 0, MAC will ignore.  <legal 0>
*/
#define TX_MSDU_START_USERX_1_RESERVED_1A_OFFSET                     0x00000004
#define TX_MSDU_START_USERX_1_RESERVED_1A_LSB                        1
#define TX_MSDU_START_USERX_1_RESERVED_1A_MASK                       0x0000007e

/* Description		TX_MSDU_START_USERX_1_TCP_FLAG
			
			TCP flags
			
			{NS,CWR,ECE,URG,ACK,PSH, RST ,SYN,FIN}<legal all>
*/
#define TX_MSDU_START_USERX_1_TCP_FLAG_OFFSET                        0x00000004
#define TX_MSDU_START_USERX_1_TCP_FLAG_LSB                           7
#define TX_MSDU_START_USERX_1_TCP_FLAG_MASK                          0x0000ff80

/* Description		TX_MSDU_START_USERX_1_TCP_FLAG_MASK
			
			TCP flag mask. Tcp_flag is inserted into the header
			based on the mask, if tso is enabled
*/
#define TX_MSDU_START_USERX_1_TCP_FLAG_MASK_OFFSET                   0x00000004
#define TX_MSDU_START_USERX_1_TCP_FLAG_MASK_LSB                      16
#define TX_MSDU_START_USERX_1_TCP_FLAG_MASK_MASK                     0x01ff0000

/* Description		TX_MSDU_START_USERX_1_RESERVED_1B
			
			FW will set to 0, MAC will ignore.  <legal 0>
*/
#define TX_MSDU_START_USERX_1_RESERVED_1B_OFFSET                     0x00000004
#define TX_MSDU_START_USERX_1_RESERVED_1B_LSB                        25
#define TX_MSDU_START_USERX_1_RESERVED_1B_MASK                       0xfe000000

/* Description		TX_MSDU_START_USERX_2_L2_LENGTH
			
			L2 length for the msdu, if tso is enabled <legal all>
*/
#define TX_MSDU_START_USERX_2_L2_LENGTH_OFFSET                       0x00000008
#define TX_MSDU_START_USERX_2_L2_LENGTH_LSB                          0
#define TX_MSDU_START_USERX_2_L2_LENGTH_MASK                         0x0000ffff

/* Description		TX_MSDU_START_USERX_2_IP_LENGTH
			
			Ip length for the msdu, if tso is enabled <legal all>
*/
#define TX_MSDU_START_USERX_2_IP_LENGTH_OFFSET                       0x00000008
#define TX_MSDU_START_USERX_2_IP_LENGTH_LSB                          16
#define TX_MSDU_START_USERX_2_IP_LENGTH_MASK                         0xffff0000

/* Description		TX_MSDU_START_USERX_3_TCP_SEQ_NUMBER
			
			Tcp_seq_number for the msdu, if tso is enabled <legal
			all>
*/
#define TX_MSDU_START_USERX_3_TCP_SEQ_NUMBER_OFFSET                  0x0000000c
#define TX_MSDU_START_USERX_3_TCP_SEQ_NUMBER_LSB                     0
#define TX_MSDU_START_USERX_3_TCP_SEQ_NUMBER_MASK                    0xffffffff

/* Description		TX_MSDU_START_USERX_4_IP_IDENTIFICATION
			
			Ip_identification for the msdu, if tso is enabled <legal
			all>
*/
#define TX_MSDU_START_USERX_4_IP_IDENTIFICATION_OFFSET               0x00000010
#define TX_MSDU_START_USERX_4_IP_IDENTIFICATION_LSB                  0
#define TX_MSDU_START_USERX_4_IP_IDENTIFICATION_MASK                 0x0000ffff

/* Description		TX_MSDU_START_USERX_4_RESERVED_4A
			
			FW will set to 0, MAC will ignore.  <legal 0>
*/
#define TX_MSDU_START_USERX_4_RESERVED_4A_OFFSET                     0x00000010
#define TX_MSDU_START_USERX_4_RESERVED_4A_LSB                        16
#define TX_MSDU_START_USERX_4_RESERVED_4A_MASK                       0xffff0000


#endif // _TX_MSDU_START_USERX_H_
