// Copyright (c) 2014 Qualcomm Atheros, Inc.  All rights reserved.
// $ATH_LICENSE_HW_HDR_C$
//
// DO NOT EDIT!  This file is automatically generated
//               These definitions are tied to a particular hardware layout


#ifndef _MPDU_QUEUE_H_
#define _MPDU_QUEUE_H_
#if !defined(__ASSEMBLER__)
#endif

// ################ START SUMMARY #################
//
//	Dword	Fields
//	0	head_mpdu_index[13:0], reserved_0a[15:14], tail_mpdu_index[29:16], queue_paused[30], frame_del_max_retry[31]
//	1	tail_msdu_index[15:0], mpdu_cnt[29:16], frame_del_by_sch_or_sw[30] , mpdu_last_index_read[31]
//
// ################ END SUMMARY #################

#define NUM_OF_DWORDS_MPDU_QUEUE 2

struct mpdu_queue {
    volatile uint32_t head_mpdu_index                 : 14, //[13:0]
                      reserved_0a                     :  2, //[15:14]
                      tail_mpdu_index                 : 14, //[29:16]
                      queue_paused                    :  1, //[30]
                      frame_del_max_retry             :  1; //[31]
    volatile uint32_t tail_msdu_index                 : 16, //[15:0]
                      mpdu_cnt                        : 14, //[29:16]
                      frame_del_by_sch_or_sw          :  1, //[30] 
                      mpdu_last_index_read            :  1; //[31]
};

/*

head_mpdu_index
			
			The index of the MPDU frame that is at the head of the
			queue. 
			
			Being head of the queue means that this frame will be
			transmitted first.
			
			New frames are added at the tail of the queue.
			
			Value: 0x0represents the NULL pointer, and is used when
			the queue is empty. <legal 0>

reserved_0a
			
			FW will set to 0, MAC will ignore.  <legal 0>

tail_mpdu_index
			
			The index of the MPDU frame that is at the tail end of
			the queue. 
			
			Being tail of the queue means that this frame will be
			transmitted last.
			
			New frames are added at the tail of the queue.
			
			Value: 0x0 represents the NULL pointer, and is used when
			the queue is empty.

queue_paused
			
			
			
			Queue paused
			
			When set, the queue is paused. This means, no more
			operations are allowed to be performed on this queue by the
			HW. <legal 0>

frame_del_max_retry
			
			Frame deleted because max retry count has been reached.
			
			This bit should only be set if a BA session is ongoing,
			which is indicated by bit: BA_flow_enabled in the MPDU queue
			ext data structure.
			
			Setting gets cleared when a BAR frame has been
			successfully  transmitted <legal all>

tail_msdu_index
			
			The index of the MSDU frame  that is at the tail end of 
			the A-MSDU within the MPDU. 
			
			Being at the tail means that this frame will be
			transmitted last. An additional MSDU added to this MPDU will
			be linked to this MSDU.
			
			This value is the Null pointer 0x0, when the MPDU cnt in
			the queue is 0. <legal all>

mpdu_cnt
			
			MPDU count: The number of MPDUs linked in this queue.
			<legal all>

frame_del_by_sch_or_sw
			
			Frame deleted by scheduler
			
			0: No frame has been deleted from this queue by the
			scheduler
			
			1: At least one frame has been deleted from this queue
			by the scheduler.
			
			The Queue manager sets this bit when it received a frame
			delete command from the scheduler.
			
			This bit should only be set if a BA session is ongoing,
			which is indicated by bit: BA_flow_enabled in the MPDU queue
			ext data structure.
			
			Setting gets cleared when a BAR frame has been
			successfully  transmitted <legal all>

mpdu_last_index_read
			
			0: The PPDU descriptor generator has not read the most
			recent last_MPDU_index value. It is OK if the length of the
			last MPDU is updated by adding MSDUs to the A-MSDU
			
			1: The PPDU descriptor generator has read the most
			recent last_MPDU_index value. It is NOT OK to modify the
			length of the last MPDU
			
			Note: The field gets cleared (to 0) every time a new
			MPDU is added to the queue.
			
			The field gets set when the length of the last MPDU in
			the queue has been given to the PPDU descriptor generator.
			<legal all>
*/


/* Description		MPDU_QUEUE_0_HEAD_MPDU_INDEX
			
			The index of the MPDU frame that is at the head of the
			queue. 
			
			Being head of the queue means that this frame will be
			transmitted first.
			
			New frames are added at the tail of the queue.
			
			Value: 0x0represents the NULL pointer, and is used when
			the queue is empty. <legal 0>
*/
#define MPDU_QUEUE_0_HEAD_MPDU_INDEX_OFFSET                          0x00000000
#define MPDU_QUEUE_0_HEAD_MPDU_INDEX_LSB                             0
#define MPDU_QUEUE_0_HEAD_MPDU_INDEX_MASK                            0x00003fff

/* Description		MPDU_QUEUE_0_RESERVED_0A
			
			FW will set to 0, MAC will ignore.  <legal 0>
*/
#define MPDU_QUEUE_0_RESERVED_0A_OFFSET                              0x00000000
#define MPDU_QUEUE_0_RESERVED_0A_LSB                                 14
#define MPDU_QUEUE_0_RESERVED_0A_MASK                                0x0000c000

/* Description		MPDU_QUEUE_0_TAIL_MPDU_INDEX
			
			The index of the MPDU frame that is at the tail end of
			the queue. 
			
			Being tail of the queue means that this frame will be
			transmitted last.
			
			New frames are added at the tail of the queue.
			
			Value: 0x0 represents the NULL pointer, and is used when
			the queue is empty.
*/
#define MPDU_QUEUE_0_TAIL_MPDU_INDEX_OFFSET                          0x00000000
#define MPDU_QUEUE_0_TAIL_MPDU_INDEX_LSB                             16
#define MPDU_QUEUE_0_TAIL_MPDU_INDEX_MASK                            0x3fff0000

/* Description		MPDU_QUEUE_0_QUEUE_PAUSED
			
			
			
			Queue paused
			
			When set, the queue is paused. This means, no more
			operations are allowed to be performed on this queue by the
			HW. <legal 0>
*/
#define MPDU_QUEUE_0_QUEUE_PAUSED_OFFSET                             0x00000000
#define MPDU_QUEUE_0_QUEUE_PAUSED_LSB                                30
#define MPDU_QUEUE_0_QUEUE_PAUSED_MASK                               0x40000000

/* Description		MPDU_QUEUE_0_FRAME_DEL_MAX_RETRY
			
			Frame deleted because max retry count has been reached.
			
			This bit should only be set if a BA session is ongoing,
			which is indicated by bit: BA_flow_enabled in the MPDU queue
			ext data structure.
			
			Setting gets cleared when a BAR frame has been
			successfully  transmitted <legal all>
*/
#define MPDU_QUEUE_0_FRAME_DEL_MAX_RETRY_OFFSET                      0x00000000
#define MPDU_QUEUE_0_FRAME_DEL_MAX_RETRY_LSB                         31
#define MPDU_QUEUE_0_FRAME_DEL_MAX_RETRY_MASK                        0x80000000

/* Description		MPDU_QUEUE_1_TAIL_MSDU_INDEX
			
			The index of the MSDU frame  that is at the tail end of 
			the A-MSDU within the MPDU. 
			
			Being at the tail means that this frame will be
			transmitted last. An additional MSDU added to this MPDU will
			be linked to this MSDU.
			
			This value is the Null pointer 0x0, when the MPDU cnt in
			the queue is 0. <legal all>
*/
#define MPDU_QUEUE_1_TAIL_MSDU_INDEX_OFFSET                          0x00000004
#define MPDU_QUEUE_1_TAIL_MSDU_INDEX_LSB                             0
#define MPDU_QUEUE_1_TAIL_MSDU_INDEX_MASK                            0x0000ffff

/* Description		MPDU_QUEUE_1_MPDU_CNT
			
			MPDU count: The number of MPDUs linked in this queue.
			<legal all>
*/
#define MPDU_QUEUE_1_MPDU_CNT_OFFSET                                 0x00000004
#define MPDU_QUEUE_1_MPDU_CNT_LSB                                    16
#define MPDU_QUEUE_1_MPDU_CNT_MASK                                   0x3fff0000

/* Description		MPDU_QUEUE_1_FRAME_DEL_BY_SCH_OR_SW
			
			Frame deleted by scheduler
			
			0: No frame has been deleted from this queue by the
			scheduler
			
			1: At least one frame has been deleted from this queue
			by the scheduler.
			
			The Queue manager sets this bit when it received a frame
			delete command from the scheduler.
			
			This bit should only be set if a BA session is ongoing,
			which is indicated by bit: BA_flow_enabled in the MPDU queue
			ext data structure.
			
			Setting gets cleared when a BAR frame has been
			successfully  transmitted <legal all>
*/
#define MPDU_QUEUE_1_FRAME_DEL_BY_SCH_OR_SW_OFFSET                   0x00000004
#define MPDU_QUEUE_1_FRAME_DEL_BY_SCH_OR_SW_LSB                      30
#define MPDU_QUEUE_1_FRAME_DEL_BY_SCH_OR_SW_MASK                     0x40000000

/* Description		MPDU_QUEUE_1_MPDU_LAST_INDEX_READ
			
			0: The PPDU descriptor generator has not read the most
			recent last_MPDU_index value. It is OK if the length of the
			last MPDU is updated by adding MSDUs to the A-MSDU
			
			1: The PPDU descriptor generator has read the most
			recent last_MPDU_index value. It is NOT OK to modify the
			length of the last MPDU
			
			Note: The field gets cleared (to 0) every time a new
			MPDU is added to the queue.
			
			The field gets set when the length of the last MPDU in
			the queue has been given to the PPDU descriptor generator.
			<legal all>
*/
#define MPDU_QUEUE_1_MPDU_LAST_INDEX_READ_OFFSET                     0x00000004
#define MPDU_QUEUE_1_MPDU_LAST_INDEX_READ_LSB                        31
#define MPDU_QUEUE_1_MPDU_LAST_INDEX_READ_MASK                       0x80000000


#endif // _MPDU_QUEUE_H_
