// Copyright (c) 2014 Qualcomm Atheros, Inc.  All rights reserved.
// $ATH_LICENSE_HW_HDR_C$
//
// DO NOT EDIT!  This file is automatically generated
//               These definitions are tied to a particular hardware layout


#ifndef _ADDR_SEARCH_ENTRY_H_
#define _ADDR_SEARCH_ENTRY_H_
#if !defined(__ASSEMBLER__)
#endif

// ################ START SUMMARY #################
//
//	Dword	Fields
//	0	mac_addr_31_0[31:0]
//	1	mac_addr_47_32[15:0], key_id[17:16], mcast[18], next_hop[19], no_ack[20], ad1_match[21], reserved_1[30:22], valid[31]
//	2	peer_entry_ptr[31:0]
//
// ################ END SUMMARY #################

#define NUM_OF_DWORDS_ADDR_SEARCH_ENTRY 3

struct addr_search_entry {
    volatile uint32_t mac_addr_31_0                   : 32; //[31:0]
    volatile uint32_t mac_addr_47_32                  : 16, //[15:0]
                      key_id                          :  2, //[17:16]
                      mcast                           :  1, //[18]
                      next_hop                        :  1, //[19]
                      no_ack                          :  1, //[20]
                      ad1_match                       :  1, //[21]
                      reserved_1                      :  9, //[30:22]
                      valid                           :  1; //[31]
    volatile uint32_t peer_entry_ptr                  : 32; //[31:0]
};

/*

mac_addr_31_0
			
			Lower 32 bits of the MAC address of the peer station

mac_addr_47_32
			
			Upper 16 bits of the MAC address of the peer station

key_id
			
			Key ID value from the IV field

mcast
			
			If set indicates that this is an entry to associated
			with a multicast key

next_hop
			
			If set indicates that this STA is not attached directly
			but can be reached by forwarding to the next hop entry (not
			used by HW but forwarded via descriptor status for SW/FW).

no_ack
			
			If set indicates that Ack/BA should not be transmitted
			on receive of a packet from this STA.  A configuration mode
			register needs to also be set to enable this feature.

ad1_match
			
			If set, indicates that {mac_addr_47_32, mac_addr_31_0}
			of addr_search_entry should be matched with address1 field
			of received frame. Othrewise, it should be matched with
			address2 of received frame. This field is used for Proxy STA
			mode or WRAP mode. 

reserved_1
			
			Generator should set to 0, consumer shall ignore. 
			<legal 0>

valid
			
			Indicates validity of entry

peer_entry_ptr
			
			Pointer to the associated peer entry
*/


/* Description		ADDR_SEARCH_ENTRY_0_MAC_ADDR_31_0
			
			Lower 32 bits of the MAC address of the peer station
*/
#define ADDR_SEARCH_ENTRY_0_MAC_ADDR_31_0_OFFSET                     0x00000000
#define ADDR_SEARCH_ENTRY_0_MAC_ADDR_31_0_LSB                        0
#define ADDR_SEARCH_ENTRY_0_MAC_ADDR_31_0_MASK                       0xffffffff

/* Description		ADDR_SEARCH_ENTRY_1_MAC_ADDR_47_32
			
			Upper 16 bits of the MAC address of the peer station
*/
#define ADDR_SEARCH_ENTRY_1_MAC_ADDR_47_32_OFFSET                    0x00000004
#define ADDR_SEARCH_ENTRY_1_MAC_ADDR_47_32_LSB                       0
#define ADDR_SEARCH_ENTRY_1_MAC_ADDR_47_32_MASK                      0x0000ffff

/* Description		ADDR_SEARCH_ENTRY_1_KEY_ID
			
			Key ID value from the IV field
*/
#define ADDR_SEARCH_ENTRY_1_KEY_ID_OFFSET                            0x00000004
#define ADDR_SEARCH_ENTRY_1_KEY_ID_LSB                               16
#define ADDR_SEARCH_ENTRY_1_KEY_ID_MASK                              0x00030000

/* Description		ADDR_SEARCH_ENTRY_1_MCAST
			
			If set indicates that this is an entry to associated
			with a multicast key
*/
#define ADDR_SEARCH_ENTRY_1_MCAST_OFFSET                             0x00000004
#define ADDR_SEARCH_ENTRY_1_MCAST_LSB                                18
#define ADDR_SEARCH_ENTRY_1_MCAST_MASK                               0x00040000

/* Description		ADDR_SEARCH_ENTRY_1_NEXT_HOP
			
			If set indicates that this STA is not attached directly
			but can be reached by forwarding to the next hop entry (not
			used by HW but forwarded via descriptor status for SW/FW).
*/
#define ADDR_SEARCH_ENTRY_1_NEXT_HOP_OFFSET                          0x00000004
#define ADDR_SEARCH_ENTRY_1_NEXT_HOP_LSB                             19
#define ADDR_SEARCH_ENTRY_1_NEXT_HOP_MASK                            0x00080000

/* Description		ADDR_SEARCH_ENTRY_1_NO_ACK
			
			If set indicates that Ack/BA should not be transmitted
			on receive of a packet from this STA.  A configuration mode
			register needs to also be set to enable this feature.
*/
#define ADDR_SEARCH_ENTRY_1_NO_ACK_OFFSET                            0x00000004
#define ADDR_SEARCH_ENTRY_1_NO_ACK_LSB                               20
#define ADDR_SEARCH_ENTRY_1_NO_ACK_MASK                              0x00100000

/* Description		ADDR_SEARCH_ENTRY_1_AD1_MATCH
			
			If set, indicates that {mac_addr_47_32, mac_addr_31_0}
			of addr_search_entry should be matched with address1 field
			of received frame. Othrewise, it should be matched with
			address2 of received frame. This field is used for Proxy STA
			mode or WRAP mode. 
*/
#define ADDR_SEARCH_ENTRY_1_AD1_MATCH_OFFSET                         0x00000004
#define ADDR_SEARCH_ENTRY_1_AD1_MATCH_LSB                            21
#define ADDR_SEARCH_ENTRY_1_AD1_MATCH_MASK                           0x00200000

/* Description		ADDR_SEARCH_ENTRY_1_RESERVED_1
			
			Generator should set to 0, consumer shall ignore. 
			<legal 0>
*/
#define ADDR_SEARCH_ENTRY_1_RESERVED_1_OFFSET                        0x00000004
#define ADDR_SEARCH_ENTRY_1_RESERVED_1_LSB                           22
#define ADDR_SEARCH_ENTRY_1_RESERVED_1_MASK                          0x7fc00000

/* Description		ADDR_SEARCH_ENTRY_1_VALID
			
			Indicates validity of entry
*/
#define ADDR_SEARCH_ENTRY_1_VALID_OFFSET                             0x00000004
#define ADDR_SEARCH_ENTRY_1_VALID_LSB                                31
#define ADDR_SEARCH_ENTRY_1_VALID_MASK                               0x80000000

/* Description		ADDR_SEARCH_ENTRY_2_PEER_ENTRY_PTR
			
			Pointer to the associated peer entry
*/
#define ADDR_SEARCH_ENTRY_2_PEER_ENTRY_PTR_OFFSET                    0x00000008
#define ADDR_SEARCH_ENTRY_2_PEER_ENTRY_PTR_LSB                       0
#define ADDR_SEARCH_ENTRY_2_PEER_ENTRY_PTR_MASK                      0xffffffff


#endif // _ADDR_SEARCH_ENTRY_H_
