// Copyright (c) 2014 Qualcomm Atheros, Inc.  All rights reserved.
// $ATH_LICENSE_HW_HDR_C$
//
// DO NOT EDIT!  This file is automatically generated
//               These definitions are tied to a particular hardware layout


#ifndef _TX_FRAME_INFO_H_
#define _TX_FRAME_INFO_H_
#if !defined(__ASSEMBLER__)
#endif

// ################ START SUMMARY #################
//
//	Dword	Fields
//	0	tx_ad2_31_0[31:0]
//	1	tx_ad2_47_32[15:0], reserved_0[31:16]
//	2	ts_rs_real_ant[23:0], reserved_1[31:24]
//	3	peer_idx[10:0], reserved_3a[14:11], capture_ack_ba_sounding[15], capture_sounding_1str_20mhz[16], capture_sounding_2str_20mhz[17], capture_sounding_3str_20mhz[18], capture_sounding_4str_20mhz[19], capture_sounding_1str_40mhz[20], capture_sounding_2str_40mhz[21], capture_sounding_3str_40mhz[22], capture_sounding_4str_40mhz[23], capture_sounding_1str_80mhz[24], capture_sounding_2str_80mhz[25], capture_sounding_3str_80mhz[26], capture_sounding_4str_80mhz[27], capture_sounding_1str_160mhz[28], capture_sounding_2str_160mhz[29], capture_sounding_3str_160mhz[30], capture_sounding_4str_160mhz[31]
//
// ################ END SUMMARY #################

#define NUM_OF_DWORDS_TX_FRAME_INFO 4

struct tx_frame_info {
    volatile uint32_t tx_ad2_31_0                     : 32; //[31:0]
    volatile uint32_t tx_ad2_47_32                    : 16, //[15:0]
                      reserved_0                      : 16; //[31:16]
    volatile uint32_t ts_rs_real_ant                  : 24, //[23:0]
                      reserved_1                      :  8; //[31:24]
    volatile uint32_t peer_idx                        : 11, //[10:0]
                      reserved_3a                     :  4, //[14:11]
                      capture_ack_ba_sounding         :  1, //[15]
                      capture_sounding_1str_20mhz     :  1, //[16]
                      capture_sounding_2str_20mhz     :  1, //[17]
                      capture_sounding_3str_20mhz     :  1, //[18]
                      capture_sounding_4str_20mhz     :  1, //[19]
                      capture_sounding_1str_40mhz     :  1, //[20]
                      capture_sounding_2str_40mhz     :  1, //[21]
                      capture_sounding_3str_40mhz     :  1, //[22]
                      capture_sounding_4str_40mhz     :  1, //[23]
                      capture_sounding_1str_80mhz     :  1, //[24]
                      capture_sounding_2str_80mhz     :  1, //[25]
                      capture_sounding_3str_80mhz     :  1, //[26]
                      capture_sounding_4str_80mhz     :  1, //[27]
                      capture_sounding_1str_160mhz    :  1, //[28]
                      capture_sounding_2str_160mhz    :  1, //[29]
                      capture_sounding_3str_160mhz    :  1, //[30]
                      capture_sounding_4str_160mhz    :  1; //[31]
};

/*

tx_ad2_31_0
			
			Lower 32 bits of the transmitter address (AD2) of the
			last packet which was transmitted, which is used by RXPCU in
			Proxy STA mode.

tx_ad2_47_32
			
			Upper 16 bits of the transmitter address (AD2) of the
			last packet which was transmitted, which is used by RXPCU in
			Proxy STA mode.

reserved_0
			
			Reserved: Generator should set to 0, consumer shall
			ignore <legal 0>

ts_rs_real_ant
			
			Antenna information which is updated on every transmit
			packet, or whenever the medium is cleared and default
			antenna has changed. 
			
			Used to update the default antenna information in the
			PPDU End Status in RXPCU.
			
			Antenna is parked on the default antenna once the medium
			clears by shifting the antenna information from TXPCU.

reserved_1
			
			Reserved: Generator should set to 0, consumer shall
			ignore <legal 0>

peer_idx
			
			The peer index of the receive Ack/BA.  This information
			is provided from the TXPCU to the RXPCU for receive Ack/BA.

reserved_3a
			
			Reserved: Generator should set to 0, consumer shall
			ignore <legal 0>

capture_ack_ba_sounding
			
			If set enables capture of sounding on Ack or BA as long
			as the corresponding capture_sounding_1str_##mhz bits is
			set.  If clear the capture of sounding on Ack or BA is
			disabled even if the corresponding
			capture_sounding_1str_##mhz is set.

capture_sounding_1str_20mhz
			
			Capture sounding for 1 stream 20 MHz receive packets

capture_sounding_2str_20mhz
			
			Capture sounding for 2 stream 20 MHz receive packets

capture_sounding_3str_20mhz
			
			Capture sounding for 3 stream 20 MHz receive packets

capture_sounding_4str_20mhz
			
			Capture sounding for 4 stream 20 MHz receive packets

capture_sounding_1str_40mhz
			
			Capture sounding for 1 stream 40 MHz receive packets

capture_sounding_2str_40mhz
			
			Capture sounding for 2 stream 40 MHz receive packets

capture_sounding_3str_40mhz
			
			Capture sounding for 3 stream 40 MHz receive packets

capture_sounding_4str_40mhz
			
			Capture sounding for 4 stream 40 MHz receive packets

capture_sounding_1str_80mhz
			
			Capture sounding for 1 stream 80 MHz receive packets

capture_sounding_2str_80mhz
			
			Capture sounding for 2 stream 80 MHz receive packets

capture_sounding_3str_80mhz
			
			Capture sounding for 3 stream 80 MHz receive packets

capture_sounding_4str_80mhz
			
			Capture sounding for 4 stream 80 MHz receive packets

capture_sounding_1str_160mhz
			
			Capture sounding for 1 stream 160 MHz receive packets

capture_sounding_2str_160mhz
			
			Capture sounding for 2 stream 160 MHz receive packets

capture_sounding_3str_160mhz
			
			Capture sounding for 3 stream 160 MHz receive packets

capture_sounding_4str_160mhz
			
			Capture sounding for 4 stream 160 MHz receive packets
*/


/* Description		TX_FRAME_INFO_0_TX_AD2_31_0
			
			Lower 32 bits of the transmitter address (AD2) of the
			last packet which was transmitted, which is used by RXPCU in
			Proxy STA mode.
*/
#define TX_FRAME_INFO_0_TX_AD2_31_0_OFFSET                           0x00000000
#define TX_FRAME_INFO_0_TX_AD2_31_0_LSB                              0
#define TX_FRAME_INFO_0_TX_AD2_31_0_MASK                             0xffffffff

/* Description		TX_FRAME_INFO_1_TX_AD2_47_32
			
			Upper 16 bits of the transmitter address (AD2) of the
			last packet which was transmitted, which is used by RXPCU in
			Proxy STA mode.
*/
#define TX_FRAME_INFO_1_TX_AD2_47_32_OFFSET                          0x00000004
#define TX_FRAME_INFO_1_TX_AD2_47_32_LSB                             0
#define TX_FRAME_INFO_1_TX_AD2_47_32_MASK                            0x0000ffff

/* Description		TX_FRAME_INFO_1_RESERVED_0
			
			Reserved: Generator should set to 0, consumer shall
			ignore <legal 0>
*/
#define TX_FRAME_INFO_1_RESERVED_0_OFFSET                            0x00000004
#define TX_FRAME_INFO_1_RESERVED_0_LSB                               16
#define TX_FRAME_INFO_1_RESERVED_0_MASK                              0xffff0000

/* Description		TX_FRAME_INFO_2_TS_RS_REAL_ANT
			
			Antenna information which is updated on every transmit
			packet, or whenever the medium is cleared and default
			antenna has changed. 
			
			Used to update the default antenna information in the
			PPDU End Status in RXPCU.
			
			Antenna is parked on the default antenna once the medium
			clears by shifting the antenna information from TXPCU.
*/
#define TX_FRAME_INFO_2_TS_RS_REAL_ANT_OFFSET                        0x00000008
#define TX_FRAME_INFO_2_TS_RS_REAL_ANT_LSB                           0
#define TX_FRAME_INFO_2_TS_RS_REAL_ANT_MASK                          0x00ffffff

/* Description		TX_FRAME_INFO_2_RESERVED_1
			
			Reserved: Generator should set to 0, consumer shall
			ignore <legal 0>
*/
#define TX_FRAME_INFO_2_RESERVED_1_OFFSET                            0x00000008
#define TX_FRAME_INFO_2_RESERVED_1_LSB                               24
#define TX_FRAME_INFO_2_RESERVED_1_MASK                              0xff000000

/* Description		TX_FRAME_INFO_3_PEER_IDX
			
			The peer index of the receive Ack/BA.  This information
			is provided from the TXPCU to the RXPCU for receive Ack/BA.
*/
#define TX_FRAME_INFO_3_PEER_IDX_OFFSET                              0x0000000c
#define TX_FRAME_INFO_3_PEER_IDX_LSB                                 0
#define TX_FRAME_INFO_3_PEER_IDX_MASK                                0x000007ff

/* Description		TX_FRAME_INFO_3_RESERVED_3A
			
			Reserved: Generator should set to 0, consumer shall
			ignore <legal 0>
*/
#define TX_FRAME_INFO_3_RESERVED_3A_OFFSET                           0x0000000c
#define TX_FRAME_INFO_3_RESERVED_3A_LSB                              11
#define TX_FRAME_INFO_3_RESERVED_3A_MASK                             0x00007800

/* Description		TX_FRAME_INFO_3_CAPTURE_ACK_BA_SOUNDING
			
			If set enables capture of sounding on Ack or BA as long
			as the corresponding capture_sounding_1str_##mhz bits is
			set.  If clear the capture of sounding on Ack or BA is
			disabled even if the corresponding
			capture_sounding_1str_##mhz is set.
*/
#define TX_FRAME_INFO_3_CAPTURE_ACK_BA_SOUNDING_OFFSET               0x0000000c
#define TX_FRAME_INFO_3_CAPTURE_ACK_BA_SOUNDING_LSB                  15
#define TX_FRAME_INFO_3_CAPTURE_ACK_BA_SOUNDING_MASK                 0x00008000

/* Description		TX_FRAME_INFO_3_CAPTURE_SOUNDING_1STR_20MHZ
			
			Capture sounding for 1 stream 20 MHz receive packets
*/
#define TX_FRAME_INFO_3_CAPTURE_SOUNDING_1STR_20MHZ_OFFSET           0x0000000c
#define TX_FRAME_INFO_3_CAPTURE_SOUNDING_1STR_20MHZ_LSB              16
#define TX_FRAME_INFO_3_CAPTURE_SOUNDING_1STR_20MHZ_MASK             0x00010000

/* Description		TX_FRAME_INFO_3_CAPTURE_SOUNDING_2STR_20MHZ
			
			Capture sounding for 2 stream 20 MHz receive packets
*/
#define TX_FRAME_INFO_3_CAPTURE_SOUNDING_2STR_20MHZ_OFFSET           0x0000000c
#define TX_FRAME_INFO_3_CAPTURE_SOUNDING_2STR_20MHZ_LSB              17
#define TX_FRAME_INFO_3_CAPTURE_SOUNDING_2STR_20MHZ_MASK             0x00020000

/* Description		TX_FRAME_INFO_3_CAPTURE_SOUNDING_3STR_20MHZ
			
			Capture sounding for 3 stream 20 MHz receive packets
*/
#define TX_FRAME_INFO_3_CAPTURE_SOUNDING_3STR_20MHZ_OFFSET           0x0000000c
#define TX_FRAME_INFO_3_CAPTURE_SOUNDING_3STR_20MHZ_LSB              18
#define TX_FRAME_INFO_3_CAPTURE_SOUNDING_3STR_20MHZ_MASK             0x00040000

/* Description		TX_FRAME_INFO_3_CAPTURE_SOUNDING_4STR_20MHZ
			
			Capture sounding for 4 stream 20 MHz receive packets
*/
#define TX_FRAME_INFO_3_CAPTURE_SOUNDING_4STR_20MHZ_OFFSET           0x0000000c
#define TX_FRAME_INFO_3_CAPTURE_SOUNDING_4STR_20MHZ_LSB              19
#define TX_FRAME_INFO_3_CAPTURE_SOUNDING_4STR_20MHZ_MASK             0x00080000

/* Description		TX_FRAME_INFO_3_CAPTURE_SOUNDING_1STR_40MHZ
			
			Capture sounding for 1 stream 40 MHz receive packets
*/
#define TX_FRAME_INFO_3_CAPTURE_SOUNDING_1STR_40MHZ_OFFSET           0x0000000c
#define TX_FRAME_INFO_3_CAPTURE_SOUNDING_1STR_40MHZ_LSB              20
#define TX_FRAME_INFO_3_CAPTURE_SOUNDING_1STR_40MHZ_MASK             0x00100000

/* Description		TX_FRAME_INFO_3_CAPTURE_SOUNDING_2STR_40MHZ
			
			Capture sounding for 2 stream 40 MHz receive packets
*/
#define TX_FRAME_INFO_3_CAPTURE_SOUNDING_2STR_40MHZ_OFFSET           0x0000000c
#define TX_FRAME_INFO_3_CAPTURE_SOUNDING_2STR_40MHZ_LSB              21
#define TX_FRAME_INFO_3_CAPTURE_SOUNDING_2STR_40MHZ_MASK             0x00200000

/* Description		TX_FRAME_INFO_3_CAPTURE_SOUNDING_3STR_40MHZ
			
			Capture sounding for 3 stream 40 MHz receive packets
*/
#define TX_FRAME_INFO_3_CAPTURE_SOUNDING_3STR_40MHZ_OFFSET           0x0000000c
#define TX_FRAME_INFO_3_CAPTURE_SOUNDING_3STR_40MHZ_LSB              22
#define TX_FRAME_INFO_3_CAPTURE_SOUNDING_3STR_40MHZ_MASK             0x00400000

/* Description		TX_FRAME_INFO_3_CAPTURE_SOUNDING_4STR_40MHZ
			
			Capture sounding for 4 stream 40 MHz receive packets
*/
#define TX_FRAME_INFO_3_CAPTURE_SOUNDING_4STR_40MHZ_OFFSET           0x0000000c
#define TX_FRAME_INFO_3_CAPTURE_SOUNDING_4STR_40MHZ_LSB              23
#define TX_FRAME_INFO_3_CAPTURE_SOUNDING_4STR_40MHZ_MASK             0x00800000

/* Description		TX_FRAME_INFO_3_CAPTURE_SOUNDING_1STR_80MHZ
			
			Capture sounding for 1 stream 80 MHz receive packets
*/
#define TX_FRAME_INFO_3_CAPTURE_SOUNDING_1STR_80MHZ_OFFSET           0x0000000c
#define TX_FRAME_INFO_3_CAPTURE_SOUNDING_1STR_80MHZ_LSB              24
#define TX_FRAME_INFO_3_CAPTURE_SOUNDING_1STR_80MHZ_MASK             0x01000000

/* Description		TX_FRAME_INFO_3_CAPTURE_SOUNDING_2STR_80MHZ
			
			Capture sounding for 2 stream 80 MHz receive packets
*/
#define TX_FRAME_INFO_3_CAPTURE_SOUNDING_2STR_80MHZ_OFFSET           0x0000000c
#define TX_FRAME_INFO_3_CAPTURE_SOUNDING_2STR_80MHZ_LSB              25
#define TX_FRAME_INFO_3_CAPTURE_SOUNDING_2STR_80MHZ_MASK             0x02000000

/* Description		TX_FRAME_INFO_3_CAPTURE_SOUNDING_3STR_80MHZ
			
			Capture sounding for 3 stream 80 MHz receive packets
*/
#define TX_FRAME_INFO_3_CAPTURE_SOUNDING_3STR_80MHZ_OFFSET           0x0000000c
#define TX_FRAME_INFO_3_CAPTURE_SOUNDING_3STR_80MHZ_LSB              26
#define TX_FRAME_INFO_3_CAPTURE_SOUNDING_3STR_80MHZ_MASK             0x04000000

/* Description		TX_FRAME_INFO_3_CAPTURE_SOUNDING_4STR_80MHZ
			
			Capture sounding for 4 stream 80 MHz receive packets
*/
#define TX_FRAME_INFO_3_CAPTURE_SOUNDING_4STR_80MHZ_OFFSET           0x0000000c
#define TX_FRAME_INFO_3_CAPTURE_SOUNDING_4STR_80MHZ_LSB              27
#define TX_FRAME_INFO_3_CAPTURE_SOUNDING_4STR_80MHZ_MASK             0x08000000

/* Description		TX_FRAME_INFO_3_CAPTURE_SOUNDING_1STR_160MHZ
			
			Capture sounding for 1 stream 160 MHz receive packets
*/
#define TX_FRAME_INFO_3_CAPTURE_SOUNDING_1STR_160MHZ_OFFSET          0x0000000c
#define TX_FRAME_INFO_3_CAPTURE_SOUNDING_1STR_160MHZ_LSB             28
#define TX_FRAME_INFO_3_CAPTURE_SOUNDING_1STR_160MHZ_MASK            0x10000000

/* Description		TX_FRAME_INFO_3_CAPTURE_SOUNDING_2STR_160MHZ
			
			Capture sounding for 2 stream 160 MHz receive packets
*/
#define TX_FRAME_INFO_3_CAPTURE_SOUNDING_2STR_160MHZ_OFFSET          0x0000000c
#define TX_FRAME_INFO_3_CAPTURE_SOUNDING_2STR_160MHZ_LSB             29
#define TX_FRAME_INFO_3_CAPTURE_SOUNDING_2STR_160MHZ_MASK            0x20000000

/* Description		TX_FRAME_INFO_3_CAPTURE_SOUNDING_3STR_160MHZ
			
			Capture sounding for 3 stream 160 MHz receive packets
*/
#define TX_FRAME_INFO_3_CAPTURE_SOUNDING_3STR_160MHZ_OFFSET          0x0000000c
#define TX_FRAME_INFO_3_CAPTURE_SOUNDING_3STR_160MHZ_LSB             30
#define TX_FRAME_INFO_3_CAPTURE_SOUNDING_3STR_160MHZ_MASK            0x40000000

/* Description		TX_FRAME_INFO_3_CAPTURE_SOUNDING_4STR_160MHZ
			
			Capture sounding for 4 stream 160 MHz receive packets
*/
#define TX_FRAME_INFO_3_CAPTURE_SOUNDING_4STR_160MHZ_OFFSET          0x0000000c
#define TX_FRAME_INFO_3_CAPTURE_SOUNDING_4STR_160MHZ_LSB             31
#define TX_FRAME_INFO_3_CAPTURE_SOUNDING_4STR_160MHZ_MASK            0x80000000


#endif // _TX_FRAME_INFO_H_
