// Copyright (c) 2014 Qualcomm Atheros, Inc.  All rights reserved.
// $ATH_LICENSE_HW_HDR_C$
//
// DO NOT EDIT!  This file is automatically generated
//               These definitions are tied to a particular hardware layout


#ifndef _RX_MESSAGE_H_
#define _RX_MESSAGE_H_
#if !defined(__ASSEMBLER__)
#endif

// ################ START SUMMARY #################
//
//	Dword	Fields
//	0	message_type[3:0], rx_chain_mask[7:4], reserved_0a[8], nc_index[11:9], ndp_feedback_type[12], cbf_hdr_offset[20:13], request_feedback[21], freeze[22], reserved_0b[31:23]
//
// ################ END SUMMARY #################

#define NUM_OF_DWORDS_RX_MESSAGE 1

struct rx_message {
    volatile uint32_t message_type                    :  4, //[3:0]
                      rx_chain_mask                   :  4, //[7:4]
                      reserved_0a                     :  1, //[8]
                      nc_index                        :  3, //[11:9]
                      ndp_feedback_type               :  1, //[12]
                      cbf_hdr_offset                  :  8, //[20:13]
                      request_feedback                :  1, //[21]
                      freeze                          :  1, //[22]
                      reserved_0b                     :  9; //[31:23]
};

/*

message_type
			
			<enum 0 RX_MSG_RX_PHY_OFF>
			
			<enum 1 RX_MSG_RX_PHY_ON>
			
			<enum 2 RX_MSG_RX_PHY_NAP>
			
			<enum 3 RX_MSG_RX_CHAIN_MASK>
			
			<enum 4 RX_MSG_TX_EXPECT_NDP>
			
			<enum 5 RX_MSG_REQ_IMPLICIT_FB>
			
			<enum 6 RX_MSG_TX_MAC_TIMEOUT>
			
			<enum 7 RX_MSG_TX_CBF_OFFSET>
			
			<enum 8 RX_MSG_CLEAR_NDPA_FLAG>  This will clear NDPA
			flag in TXPCU.  This should be set when expect_ndp was sent
			
			<enum 9 RX_MSG_TX_FREEZE_CAPTURE_CHANNEL>
			
			<legal 0-9>

rx_chain_mask
			
			Rx chain mask to support up to 4 antennas. Valid only if
			message_type is RX_CHAIN_MASK. 

reserved_0a
			
			Reserved: HW should fill with 0

nc_index
			
			The NC value when TX_EXPECT_NDP is used and nc_override
			is set.

ndp_feedback_type
			
			This field is only valid when TX_EXPECT_NDP is set.
			
			This field is inserted into the TX_EXPECT_NDP TLV
			generated by the TX PCU.
			
			
			
			<enum 0     11ac_su>  Expect 11ac NDP and create SU
			feedback
			
			<enum 1     11ac_mu>  Expect 11ac NDP and create MU
			feedback
			
			<legal 0-1>

cbf_hdr_offset
			
			Number of bytes to the Action Field of the CBF frame. 
			This should always be a multiple of 4.

request_feedback
			
			request_feedback field in REQ_IMPLICT_FB TLV

freeze
			
			freeze field in TX_FREEZE_CAPTURE_CHANNEL TLV
			
			
			
			<enum 0 allow_channel_capture>
			
			<enum 1 freeze_channel_capture>
			
			<legal all>

reserved_0b
			
			Reserved: HW should fill with 0
*/


/* Description		RX_MESSAGE_0_MESSAGE_TYPE
			
			<enum 0 RX_MSG_RX_PHY_OFF>
			
			<enum 1 RX_MSG_RX_PHY_ON>
			
			<enum 2 RX_MSG_RX_PHY_NAP>
			
			<enum 3 RX_MSG_RX_CHAIN_MASK>
			
			<enum 4 RX_MSG_TX_EXPECT_NDP>
			
			<enum 5 RX_MSG_REQ_IMPLICIT_FB>
			
			<enum 6 RX_MSG_TX_MAC_TIMEOUT>
			
			<enum 7 RX_MSG_TX_CBF_OFFSET>
			
			<enum 8 RX_MSG_CLEAR_NDPA_FLAG>  This will clear NDPA
			flag in TXPCU.  This should be set when expect_ndp was sent
			
			<enum 9 RX_MSG_TX_FREEZE_CAPTURE_CHANNEL>
			
			<legal 0-9>
*/
#define RX_MESSAGE_0_MESSAGE_TYPE_OFFSET                             0x00000000
#define RX_MESSAGE_0_MESSAGE_TYPE_LSB                                0
#define RX_MESSAGE_0_MESSAGE_TYPE_MASK                               0x0000000f

/* Description		RX_MESSAGE_0_RX_CHAIN_MASK
			
			Rx chain mask to support up to 4 antennas. Valid only if
			message_type is RX_CHAIN_MASK. 
*/
#define RX_MESSAGE_0_RX_CHAIN_MASK_OFFSET                            0x00000000
#define RX_MESSAGE_0_RX_CHAIN_MASK_LSB                               4
#define RX_MESSAGE_0_RX_CHAIN_MASK_MASK                              0x000000f0

/* Description		RX_MESSAGE_0_RESERVED_0A
			
			Reserved: HW should fill with 0
*/
#define RX_MESSAGE_0_RESERVED_0A_OFFSET                              0x00000000
#define RX_MESSAGE_0_RESERVED_0A_LSB                                 8
#define RX_MESSAGE_0_RESERVED_0A_MASK                                0x00000100

/* Description		RX_MESSAGE_0_NC_INDEX
			
			The NC value when TX_EXPECT_NDP is used and nc_override
			is set.
*/
#define RX_MESSAGE_0_NC_INDEX_OFFSET                                 0x00000000
#define RX_MESSAGE_0_NC_INDEX_LSB                                    9
#define RX_MESSAGE_0_NC_INDEX_MASK                                   0x00000e00

/* Description		RX_MESSAGE_0_NDP_FEEDBACK_TYPE
			
			This field is only valid when TX_EXPECT_NDP is set.
			
			This field is inserted into the TX_EXPECT_NDP TLV
			generated by the TX PCU.
			
			
			
			<enum 0     11ac_su>  Expect 11ac NDP and create SU
			feedback
			
			<enum 1     11ac_mu>  Expect 11ac NDP and create MU
			feedback
			
			<legal 0-1>
*/
#define RX_MESSAGE_0_NDP_FEEDBACK_TYPE_OFFSET                        0x00000000
#define RX_MESSAGE_0_NDP_FEEDBACK_TYPE_LSB                           12
#define RX_MESSAGE_0_NDP_FEEDBACK_TYPE_MASK                          0x00001000

/* Description		RX_MESSAGE_0_CBF_HDR_OFFSET
			
			Number of bytes to the Action Field of the CBF frame. 
			This should always be a multiple of 4.
*/
#define RX_MESSAGE_0_CBF_HDR_OFFSET_OFFSET                           0x00000000
#define RX_MESSAGE_0_CBF_HDR_OFFSET_LSB                              13
#define RX_MESSAGE_0_CBF_HDR_OFFSET_MASK                             0x001fe000

/* Description		RX_MESSAGE_0_REQUEST_FEEDBACK
			
			request_feedback field in REQ_IMPLICT_FB TLV
*/
#define RX_MESSAGE_0_REQUEST_FEEDBACK_OFFSET                         0x00000000
#define RX_MESSAGE_0_REQUEST_FEEDBACK_LSB                            21
#define RX_MESSAGE_0_REQUEST_FEEDBACK_MASK                           0x00200000

/* Description		RX_MESSAGE_0_FREEZE
			
			freeze field in TX_FREEZE_CAPTURE_CHANNEL TLV
			
			
			
			<enum 0 allow_channel_capture>
			
			<enum 1 freeze_channel_capture>
			
			<legal all>
*/
#define RX_MESSAGE_0_FREEZE_OFFSET                                   0x00000000
#define RX_MESSAGE_0_FREEZE_LSB                                      22
#define RX_MESSAGE_0_FREEZE_MASK                                     0x00400000

/* Description		RX_MESSAGE_0_RESERVED_0B
			
			Reserved: HW should fill with 0
*/
#define RX_MESSAGE_0_RESERVED_0B_OFFSET                              0x00000000
#define RX_MESSAGE_0_RESERVED_0B_LSB                                 23
#define RX_MESSAGE_0_RESERVED_0B_MASK                                0xff800000


#endif // _RX_MESSAGE_H_
