/*
 * Copyright (c) 2015 Qualcomm Atheros, Inc.
 * All Rights Reserved.
 * Qualcomm Atheros Confidential and Proprietary.
 */

#ifndef _MAC_AMPI_REG_H_
#define _MAC_AMPI_REG_H_


#ifndef __MAC_AMPI_REG_BASE_ADDRESS
#define __MAC_AMPI_REG_BASE_ADDRESS (0x3a000)
#endif


// 0x0 (AMPI_TX_SIFS_REG)
#define AMPI_TX_SIFS_REG_TX_SIFS_VALUE_LSB                                     0
#define AMPI_TX_SIFS_REG_TX_SIFS_VALUE_MSB                                     31
#define AMPI_TX_SIFS_REG_TX_SIFS_VALUE_MASK                                    0xffffffff
#define AMPI_TX_SIFS_REG_TX_SIFS_VALUE_GET(x)                                  (((x) & AMPI_TX_SIFS_REG_TX_SIFS_VALUE_MASK) >> AMPI_TX_SIFS_REG_TX_SIFS_VALUE_LSB)
#define AMPI_TX_SIFS_REG_TX_SIFS_VALUE_SET(x)                                  (((0 | (x)) << AMPI_TX_SIFS_REG_TX_SIFS_VALUE_LSB) & AMPI_TX_SIFS_REG_TX_SIFS_VALUE_MASK)
#define AMPI_TX_SIFS_REG_TX_SIFS_VALUE_RESET                                   0x0
#define AMPI_TX_SIFS_REG_ADDRESS                                               (0x0 + __MAC_AMPI_REG_BASE_ADDRESS)
#define AMPI_TX_SIFS_REG_RSTMASK                                               0xffffffff
#define AMPI_TX_SIFS_REG_RESET                                                 0x0

// 0x4 (AMPI_CURRENT_TIMESTAMP_REG)
#define AMPI_CURRENT_TIMESTAMP_REG_CURRENT_TIMESTAMP_LSB                       0
#define AMPI_CURRENT_TIMESTAMP_REG_CURRENT_TIMESTAMP_MSB                       31
#define AMPI_CURRENT_TIMESTAMP_REG_CURRENT_TIMESTAMP_MASK                      0xffffffff
#define AMPI_CURRENT_TIMESTAMP_REG_CURRENT_TIMESTAMP_GET(x)                    (((x) & AMPI_CURRENT_TIMESTAMP_REG_CURRENT_TIMESTAMP_MASK) >> AMPI_CURRENT_TIMESTAMP_REG_CURRENT_TIMESTAMP_LSB)
#define AMPI_CURRENT_TIMESTAMP_REG_CURRENT_TIMESTAMP_SET(x)                    (((0 | (x)) << AMPI_CURRENT_TIMESTAMP_REG_CURRENT_TIMESTAMP_LSB) & AMPI_CURRENT_TIMESTAMP_REG_CURRENT_TIMESTAMP_MASK)
#define AMPI_CURRENT_TIMESTAMP_REG_CURRENT_TIMESTAMP_RESET                     0x0
#define AMPI_CURRENT_TIMESTAMP_REG_ADDRESS                                     (0x4 + __MAC_AMPI_REG_BASE_ADDRESS)
#define AMPI_CURRENT_TIMESTAMP_REG_RSTMASK                                     0xffffffff
#define AMPI_CURRENT_TIMESTAMP_REG_RESET                                       0x0

// 0x8 (AMPI_PHY_TIMESTAMP1_REG)
#define AMPI_PHY_TIMESTAMP1_REG_PHY_TIMESTAMP1_LSB                             0
#define AMPI_PHY_TIMESTAMP1_REG_PHY_TIMESTAMP1_MSB                             31
#define AMPI_PHY_TIMESTAMP1_REG_PHY_TIMESTAMP1_MASK                            0xffffffff
#define AMPI_PHY_TIMESTAMP1_REG_PHY_TIMESTAMP1_GET(x)                          (((x) & AMPI_PHY_TIMESTAMP1_REG_PHY_TIMESTAMP1_MASK) >> AMPI_PHY_TIMESTAMP1_REG_PHY_TIMESTAMP1_LSB)
#define AMPI_PHY_TIMESTAMP1_REG_PHY_TIMESTAMP1_SET(x)                          (((0 | (x)) << AMPI_PHY_TIMESTAMP1_REG_PHY_TIMESTAMP1_LSB) & AMPI_PHY_TIMESTAMP1_REG_PHY_TIMESTAMP1_MASK)
#define AMPI_PHY_TIMESTAMP1_REG_PHY_TIMESTAMP1_RESET                           0x0
#define AMPI_PHY_TIMESTAMP1_REG_ADDRESS                                        (0x8 + __MAC_AMPI_REG_BASE_ADDRESS)
#define AMPI_PHY_TIMESTAMP1_REG_RSTMASK                                        0xffffffff
#define AMPI_PHY_TIMESTAMP1_REG_RESET                                          0x0

// 0xc (AMPI_PHY_TIMESTAMP2_REG)
#define AMPI_PHY_TIMESTAMP2_REG_PHY_TIMESTAMP2_LSB                             0
#define AMPI_PHY_TIMESTAMP2_REG_PHY_TIMESTAMP2_MSB                             31
#define AMPI_PHY_TIMESTAMP2_REG_PHY_TIMESTAMP2_MASK                            0xffffffff
#define AMPI_PHY_TIMESTAMP2_REG_PHY_TIMESTAMP2_GET(x)                          (((x) & AMPI_PHY_TIMESTAMP2_REG_PHY_TIMESTAMP2_MASK) >> AMPI_PHY_TIMESTAMP2_REG_PHY_TIMESTAMP2_LSB)
#define AMPI_PHY_TIMESTAMP2_REG_PHY_TIMESTAMP2_SET(x)                          (((0 | (x)) << AMPI_PHY_TIMESTAMP2_REG_PHY_TIMESTAMP2_LSB) & AMPI_PHY_TIMESTAMP2_REG_PHY_TIMESTAMP2_MASK)
#define AMPI_PHY_TIMESTAMP2_REG_PHY_TIMESTAMP2_RESET                           0x0
#define AMPI_PHY_TIMESTAMP2_REG_ADDRESS                                        (0xc + __MAC_AMPI_REG_BASE_ADDRESS)
#define AMPI_PHY_TIMESTAMP2_REG_RSTMASK                                        0xffffffff
#define AMPI_PHY_TIMESTAMP2_REG_RESET                                          0x0

// 0x10 (AMPI_DEBUG_MODE_SELECT)
#define AMPI_DEBUG_MODE_SELECT_DEBUG_MODE_SELECT_LSB                           0
#define AMPI_DEBUG_MODE_SELECT_DEBUG_MODE_SELECT_MSB                           31
#define AMPI_DEBUG_MODE_SELECT_DEBUG_MODE_SELECT_MASK                          0xffffffff
#define AMPI_DEBUG_MODE_SELECT_DEBUG_MODE_SELECT_GET(x)                        (((x) & AMPI_DEBUG_MODE_SELECT_DEBUG_MODE_SELECT_MASK) >> AMPI_DEBUG_MODE_SELECT_DEBUG_MODE_SELECT_LSB)
#define AMPI_DEBUG_MODE_SELECT_DEBUG_MODE_SELECT_SET(x)                        (((0 | (x)) << AMPI_DEBUG_MODE_SELECT_DEBUG_MODE_SELECT_LSB) & AMPI_DEBUG_MODE_SELECT_DEBUG_MODE_SELECT_MASK)
#define AMPI_DEBUG_MODE_SELECT_DEBUG_MODE_SELECT_RESET                         0x0
#define AMPI_DEBUG_MODE_SELECT_ADDRESS                                         (0x10 + __MAC_AMPI_REG_BASE_ADDRESS)
#define AMPI_DEBUG_MODE_SELECT_RSTMASK                                         0xffffffff
#define AMPI_DEBUG_MODE_SELECT_RESET                                           0x0

// 0x14 (AMPI_PHY_CLOCK_GATE_DISABLE)
#define AMPI_PHY_CLOCK_GATE_DISABLE_CLOCK_GATE_DISABLE_LSB                     0
#define AMPI_PHY_CLOCK_GATE_DISABLE_CLOCK_GATE_DISABLE_MSB                     5
#define AMPI_PHY_CLOCK_GATE_DISABLE_CLOCK_GATE_DISABLE_MASK                    0x3f
#define AMPI_PHY_CLOCK_GATE_DISABLE_CLOCK_GATE_DISABLE_GET(x)                  (((x) & AMPI_PHY_CLOCK_GATE_DISABLE_CLOCK_GATE_DISABLE_MASK) >> AMPI_PHY_CLOCK_GATE_DISABLE_CLOCK_GATE_DISABLE_LSB)
#define AMPI_PHY_CLOCK_GATE_DISABLE_CLOCK_GATE_DISABLE_SET(x)                  (((0 | (x)) << AMPI_PHY_CLOCK_GATE_DISABLE_CLOCK_GATE_DISABLE_LSB) & AMPI_PHY_CLOCK_GATE_DISABLE_CLOCK_GATE_DISABLE_MASK)
#define AMPI_PHY_CLOCK_GATE_DISABLE_CLOCK_GATE_DISABLE_RESET                   0x3f
#define AMPI_PHY_CLOCK_GATE_DISABLE_ADDRESS                                    (0x14 + __MAC_AMPI_REG_BASE_ADDRESS)
#define AMPI_PHY_CLOCK_GATE_DISABLE_RSTMASK                                    0x3f
#define AMPI_PHY_CLOCK_GATE_DISABLE_RESET                                      0x3f

// 0x18 (AMPI_DEBUG_RX_ERROR_COUNT)
#define AMPI_DEBUG_RX_ERROR_COUNT_RX_TLV_ERROR_COUNT_LSB                       0
#define AMPI_DEBUG_RX_ERROR_COUNT_RX_TLV_ERROR_COUNT_MSB                       15
#define AMPI_DEBUG_RX_ERROR_COUNT_RX_TLV_ERROR_COUNT_MASK                      0xffff
#define AMPI_DEBUG_RX_ERROR_COUNT_RX_TLV_ERROR_COUNT_GET(x)                    (((x) & AMPI_DEBUG_RX_ERROR_COUNT_RX_TLV_ERROR_COUNT_MASK) >> AMPI_DEBUG_RX_ERROR_COUNT_RX_TLV_ERROR_COUNT_LSB)
#define AMPI_DEBUG_RX_ERROR_COUNT_RX_TLV_ERROR_COUNT_SET(x)                    (((0 | (x)) << AMPI_DEBUG_RX_ERROR_COUNT_RX_TLV_ERROR_COUNT_LSB) & AMPI_DEBUG_RX_ERROR_COUNT_RX_TLV_ERROR_COUNT_MASK)
#define AMPI_DEBUG_RX_ERROR_COUNT_RX_TLV_ERROR_COUNT_RESET                     0x0
#define AMPI_DEBUG_RX_ERROR_COUNT_ADDRESS                                      (0x18 + __MAC_AMPI_REG_BASE_ADDRESS)
#define AMPI_DEBUG_RX_ERROR_COUNT_RSTMASK                                      0xffff
#define AMPI_DEBUG_RX_ERROR_COUNT_RESET                                        0x0

// 0x1c (AMPI_DEBUG_TX_ERROR_COUNT)
#define AMPI_DEBUG_TX_ERROR_COUNT_TX_TLV_ERROR_COUNT_LSB                       0
#define AMPI_DEBUG_TX_ERROR_COUNT_TX_TLV_ERROR_COUNT_MSB                       15
#define AMPI_DEBUG_TX_ERROR_COUNT_TX_TLV_ERROR_COUNT_MASK                      0xffff
#define AMPI_DEBUG_TX_ERROR_COUNT_TX_TLV_ERROR_COUNT_GET(x)                    (((x) & AMPI_DEBUG_TX_ERROR_COUNT_TX_TLV_ERROR_COUNT_MASK) >> AMPI_DEBUG_TX_ERROR_COUNT_TX_TLV_ERROR_COUNT_LSB)
#define AMPI_DEBUG_TX_ERROR_COUNT_TX_TLV_ERROR_COUNT_SET(x)                    (((0 | (x)) << AMPI_DEBUG_TX_ERROR_COUNT_TX_TLV_ERROR_COUNT_LSB) & AMPI_DEBUG_TX_ERROR_COUNT_TX_TLV_ERROR_COUNT_MASK)
#define AMPI_DEBUG_TX_ERROR_COUNT_TX_TLV_ERROR_COUNT_RESET                     0x0
#define AMPI_DEBUG_TX_ERROR_COUNT_ADDRESS                                      (0x1c + __MAC_AMPI_REG_BASE_ADDRESS)
#define AMPI_DEBUG_TX_ERROR_COUNT_RSTMASK                                      0xffff
#define AMPI_DEBUG_TX_ERROR_COUNT_RESET                                        0x0

// 0x20 (AMPI_STALE_TIMESTAMP_COUNT)
#define AMPI_STALE_TIMESTAMP_COUNT_STALE_TIMESTAMP_COUNT_LSB                   0
#define AMPI_STALE_TIMESTAMP_COUNT_STALE_TIMESTAMP_COUNT_MSB                   15
#define AMPI_STALE_TIMESTAMP_COUNT_STALE_TIMESTAMP_COUNT_MASK                  0xffff
#define AMPI_STALE_TIMESTAMP_COUNT_STALE_TIMESTAMP_COUNT_GET(x)                (((x) & AMPI_STALE_TIMESTAMP_COUNT_STALE_TIMESTAMP_COUNT_MASK) >> AMPI_STALE_TIMESTAMP_COUNT_STALE_TIMESTAMP_COUNT_LSB)
#define AMPI_STALE_TIMESTAMP_COUNT_STALE_TIMESTAMP_COUNT_SET(x)                (((0 | (x)) << AMPI_STALE_TIMESTAMP_COUNT_STALE_TIMESTAMP_COUNT_LSB) & AMPI_STALE_TIMESTAMP_COUNT_STALE_TIMESTAMP_COUNT_MASK)
#define AMPI_STALE_TIMESTAMP_COUNT_STALE_TIMESTAMP_COUNT_RESET                 0x0
#define AMPI_STALE_TIMESTAMP_COUNT_ADDRESS                                     (0x20 + __MAC_AMPI_REG_BASE_ADDRESS)
#define AMPI_STALE_TIMESTAMP_COUNT_RSTMASK                                     0xffff
#define AMPI_STALE_TIMESTAMP_COUNT_RESET                                       0x0

// 0x24 (AMPI_RX_SYNC_EVENT_COUNT)
#define AMPI_RX_SYNC_EVENT_COUNT_RX_SYNC_EVENT_COUNT_LSB                       0
#define AMPI_RX_SYNC_EVENT_COUNT_RX_SYNC_EVENT_COUNT_MSB                       15
#define AMPI_RX_SYNC_EVENT_COUNT_RX_SYNC_EVENT_COUNT_MASK                      0xffff
#define AMPI_RX_SYNC_EVENT_COUNT_RX_SYNC_EVENT_COUNT_GET(x)                    (((x) & AMPI_RX_SYNC_EVENT_COUNT_RX_SYNC_EVENT_COUNT_MASK) >> AMPI_RX_SYNC_EVENT_COUNT_RX_SYNC_EVENT_COUNT_LSB)
#define AMPI_RX_SYNC_EVENT_COUNT_RX_SYNC_EVENT_COUNT_SET(x)                    (((0 | (x)) << AMPI_RX_SYNC_EVENT_COUNT_RX_SYNC_EVENT_COUNT_LSB) & AMPI_RX_SYNC_EVENT_COUNT_RX_SYNC_EVENT_COUNT_MASK)
#define AMPI_RX_SYNC_EVENT_COUNT_RX_SYNC_EVENT_COUNT_RESET                     0x0
#define AMPI_RX_SYNC_EVENT_COUNT_ADDRESS                                       (0x24 + __MAC_AMPI_REG_BASE_ADDRESS)
#define AMPI_RX_SYNC_EVENT_COUNT_RSTMASK                                       0xffff
#define AMPI_RX_SYNC_EVENT_COUNT_RESET                                         0x0

// 0x28 (AMPI_INSERT_TIMESTAMP_COUNT)
#define AMPI_INSERT_TIMESTAMP_COUNT_INSERT_TIMESTAMP_COUNT_LSB                 0
#define AMPI_INSERT_TIMESTAMP_COUNT_INSERT_TIMESTAMP_COUNT_MSB                 15
#define AMPI_INSERT_TIMESTAMP_COUNT_INSERT_TIMESTAMP_COUNT_MASK                0xffff
#define AMPI_INSERT_TIMESTAMP_COUNT_INSERT_TIMESTAMP_COUNT_GET(x)              (((x) & AMPI_INSERT_TIMESTAMP_COUNT_INSERT_TIMESTAMP_COUNT_MASK) >> AMPI_INSERT_TIMESTAMP_COUNT_INSERT_TIMESTAMP_COUNT_LSB)
#define AMPI_INSERT_TIMESTAMP_COUNT_INSERT_TIMESTAMP_COUNT_SET(x)              (((0 | (x)) << AMPI_INSERT_TIMESTAMP_COUNT_INSERT_TIMESTAMP_COUNT_LSB) & AMPI_INSERT_TIMESTAMP_COUNT_INSERT_TIMESTAMP_COUNT_MASK)
#define AMPI_INSERT_TIMESTAMP_COUNT_INSERT_TIMESTAMP_COUNT_RESET               0x0
#define AMPI_INSERT_TIMESTAMP_COUNT_ADDRESS                                    (0x28 + __MAC_AMPI_REG_BASE_ADDRESS)
#define AMPI_INSERT_TIMESTAMP_COUNT_RSTMASK                                    0xffff
#define AMPI_INSERT_TIMESTAMP_COUNT_RESET                                      0x0

// 0x2c (AMPI_FEATURE_DISABLE)
#define AMPI_FEATURE_DISABLE_TOD_CAPTURE_INVALID_LSB                           7
#define AMPI_FEATURE_DISABLE_TOD_CAPTURE_INVALID_MSB                           7
#define AMPI_FEATURE_DISABLE_TOD_CAPTURE_INVALID_MASK                          0x80
#define AMPI_FEATURE_DISABLE_TOD_CAPTURE_INVALID_GET(x)                        (((x) & AMPI_FEATURE_DISABLE_TOD_CAPTURE_INVALID_MASK) >> AMPI_FEATURE_DISABLE_TOD_CAPTURE_INVALID_LSB)
#define AMPI_FEATURE_DISABLE_TOD_CAPTURE_INVALID_SET(x)                        (((0 | (x)) << AMPI_FEATURE_DISABLE_TOD_CAPTURE_INVALID_LSB) & AMPI_FEATURE_DISABLE_TOD_CAPTURE_INVALID_MASK)
#define AMPI_FEATURE_DISABLE_TOD_CAPTURE_INVALID_RESET                         0x0
#define AMPI_FEATURE_DISABLE_TOD_CAPTURE_VALID_LSB                             6
#define AMPI_FEATURE_DISABLE_TOD_CAPTURE_VALID_MSB                             6
#define AMPI_FEATURE_DISABLE_TOD_CAPTURE_VALID_MASK                            0x40
#define AMPI_FEATURE_DISABLE_TOD_CAPTURE_VALID_GET(x)                          (((x) & AMPI_FEATURE_DISABLE_TOD_CAPTURE_VALID_MASK) >> AMPI_FEATURE_DISABLE_TOD_CAPTURE_VALID_LSB)
#define AMPI_FEATURE_DISABLE_TOD_CAPTURE_VALID_SET(x)                          (((0 | (x)) << AMPI_FEATURE_DISABLE_TOD_CAPTURE_VALID_LSB) & AMPI_FEATURE_DISABLE_TOD_CAPTURE_VALID_MASK)
#define AMPI_FEATURE_DISABLE_TOD_CAPTURE_VALID_RESET                           0x0
#define AMPI_FEATURE_DISABLE_TOD_CAPTURE_EXPECTED_LSB                          5
#define AMPI_FEATURE_DISABLE_TOD_CAPTURE_EXPECTED_MSB                          5
#define AMPI_FEATURE_DISABLE_TOD_CAPTURE_EXPECTED_MASK                         0x20
#define AMPI_FEATURE_DISABLE_TOD_CAPTURE_EXPECTED_GET(x)                       (((x) & AMPI_FEATURE_DISABLE_TOD_CAPTURE_EXPECTED_MASK) >> AMPI_FEATURE_DISABLE_TOD_CAPTURE_EXPECTED_LSB)
#define AMPI_FEATURE_DISABLE_TOD_CAPTURE_EXPECTED_SET(x)                       (((0 | (x)) << AMPI_FEATURE_DISABLE_TOD_CAPTURE_EXPECTED_LSB) & AMPI_FEATURE_DISABLE_TOD_CAPTURE_EXPECTED_MASK)
#define AMPI_FEATURE_DISABLE_TOD_CAPTURE_EXPECTED_RESET                        0x0
#define AMPI_FEATURE_DISABLE_ENABLE_ECO_LSB                                    3
#define AMPI_FEATURE_DISABLE_ENABLE_ECO_MSB                                    4
#define AMPI_FEATURE_DISABLE_ENABLE_ECO_MASK                                   0x18
#define AMPI_FEATURE_DISABLE_ENABLE_ECO_GET(x)                                 (((x) & AMPI_FEATURE_DISABLE_ENABLE_ECO_MASK) >> AMPI_FEATURE_DISABLE_ENABLE_ECO_LSB)
#define AMPI_FEATURE_DISABLE_ENABLE_ECO_SET(x)                                 (((0 | (x)) << AMPI_FEATURE_DISABLE_ENABLE_ECO_LSB) & AMPI_FEATURE_DISABLE_ENABLE_ECO_MASK)
#define AMPI_FEATURE_DISABLE_ENABLE_ECO_RESET                                  0x0
#define AMPI_FEATURE_DISABLE_DISABLE_RX_CLEAR_FILTER_LSB                       2
#define AMPI_FEATURE_DISABLE_DISABLE_RX_CLEAR_FILTER_MSB                       2
#define AMPI_FEATURE_DISABLE_DISABLE_RX_CLEAR_FILTER_MASK                      0x4
#define AMPI_FEATURE_DISABLE_DISABLE_RX_CLEAR_FILTER_GET(x)                    (((x) & AMPI_FEATURE_DISABLE_DISABLE_RX_CLEAR_FILTER_MASK) >> AMPI_FEATURE_DISABLE_DISABLE_RX_CLEAR_FILTER_LSB)
#define AMPI_FEATURE_DISABLE_DISABLE_RX_CLEAR_FILTER_SET(x)                    (((0 | (x)) << AMPI_FEATURE_DISABLE_DISABLE_RX_CLEAR_FILTER_LSB) & AMPI_FEATURE_DISABLE_DISABLE_RX_CLEAR_FILTER_MASK)
#define AMPI_FEATURE_DISABLE_DISABLE_RX_CLEAR_FILTER_RESET                     0x0
#define AMPI_FEATURE_DISABLE_DISABLE_TIMESTAMP_INSERTION_LSB                   1
#define AMPI_FEATURE_DISABLE_DISABLE_TIMESTAMP_INSERTION_MSB                   1
#define AMPI_FEATURE_DISABLE_DISABLE_TIMESTAMP_INSERTION_MASK                  0x2
#define AMPI_FEATURE_DISABLE_DISABLE_TIMESTAMP_INSERTION_GET(x)                (((x) & AMPI_FEATURE_DISABLE_DISABLE_TIMESTAMP_INSERTION_MASK) >> AMPI_FEATURE_DISABLE_DISABLE_TIMESTAMP_INSERTION_LSB)
#define AMPI_FEATURE_DISABLE_DISABLE_TIMESTAMP_INSERTION_SET(x)                (((0 | (x)) << AMPI_FEATURE_DISABLE_DISABLE_TIMESTAMP_INSERTION_LSB) & AMPI_FEATURE_DISABLE_DISABLE_TIMESTAMP_INSERTION_MASK)
#define AMPI_FEATURE_DISABLE_DISABLE_TIMESTAMP_INSERTION_RESET                 0x0
#define AMPI_FEATURE_DISABLE_DISABLE_STALE_TIMESTAMP_DETECTION_LSB             0
#define AMPI_FEATURE_DISABLE_DISABLE_STALE_TIMESTAMP_DETECTION_MSB             0
#define AMPI_FEATURE_DISABLE_DISABLE_STALE_TIMESTAMP_DETECTION_MASK            0x1
#define AMPI_FEATURE_DISABLE_DISABLE_STALE_TIMESTAMP_DETECTION_GET(x)          (((x) & AMPI_FEATURE_DISABLE_DISABLE_STALE_TIMESTAMP_DETECTION_MASK) >> AMPI_FEATURE_DISABLE_DISABLE_STALE_TIMESTAMP_DETECTION_LSB)
#define AMPI_FEATURE_DISABLE_DISABLE_STALE_TIMESTAMP_DETECTION_SET(x)          (((0 | (x)) << AMPI_FEATURE_DISABLE_DISABLE_STALE_TIMESTAMP_DETECTION_LSB) & AMPI_FEATURE_DISABLE_DISABLE_STALE_TIMESTAMP_DETECTION_MASK)
#define AMPI_FEATURE_DISABLE_DISABLE_STALE_TIMESTAMP_DETECTION_RESET           0x0
#define AMPI_FEATURE_DISABLE_ADDRESS                                           (0x2c + __MAC_AMPI_REG_BASE_ADDRESS)
#define AMPI_FEATURE_DISABLE_RSTMASK                                           0xff
#define AMPI_FEATURE_DISABLE_RESET                                             0x0

// 0x30 (AMPI_PHY_CAPTURED_TOA_REG)
#define AMPI_PHY_CAPTURED_TOA_REG_PHY_CAPTURED_TOA_LSB                         0
#define AMPI_PHY_CAPTURED_TOA_REG_PHY_CAPTURED_TOA_MSB                         31
#define AMPI_PHY_CAPTURED_TOA_REG_PHY_CAPTURED_TOA_MASK                        0xffffffff
#define AMPI_PHY_CAPTURED_TOA_REG_PHY_CAPTURED_TOA_GET(x)                      (((x) & AMPI_PHY_CAPTURED_TOA_REG_PHY_CAPTURED_TOA_MASK) >> AMPI_PHY_CAPTURED_TOA_REG_PHY_CAPTURED_TOA_LSB)
#define AMPI_PHY_CAPTURED_TOA_REG_PHY_CAPTURED_TOA_SET(x)                      (((0 | (x)) << AMPI_PHY_CAPTURED_TOA_REG_PHY_CAPTURED_TOA_LSB) & AMPI_PHY_CAPTURED_TOA_REG_PHY_CAPTURED_TOA_MASK)
#define AMPI_PHY_CAPTURED_TOA_REG_PHY_CAPTURED_TOA_RESET                       0x0
#define AMPI_PHY_CAPTURED_TOA_REG_ADDRESS                                      (0x30 + __MAC_AMPI_REG_BASE_ADDRESS)
#define AMPI_PHY_CAPTURED_TOA_REG_RSTMASK                                      0xffffffff
#define AMPI_PHY_CAPTURED_TOA_REG_RESET                                        0x0

// 0x34 (AMPI_PHY_CAPTURED_TOD_REG)
#define AMPI_PHY_CAPTURED_TOD_REG_PHY_CAPTURED_TOD_LSB                         0
#define AMPI_PHY_CAPTURED_TOD_REG_PHY_CAPTURED_TOD_MSB                         31
#define AMPI_PHY_CAPTURED_TOD_REG_PHY_CAPTURED_TOD_MASK                        0xffffffff
#define AMPI_PHY_CAPTURED_TOD_REG_PHY_CAPTURED_TOD_GET(x)                      (((x) & AMPI_PHY_CAPTURED_TOD_REG_PHY_CAPTURED_TOD_MASK) >> AMPI_PHY_CAPTURED_TOD_REG_PHY_CAPTURED_TOD_LSB)
#define AMPI_PHY_CAPTURED_TOD_REG_PHY_CAPTURED_TOD_SET(x)                      (((0 | (x)) << AMPI_PHY_CAPTURED_TOD_REG_PHY_CAPTURED_TOD_LSB) & AMPI_PHY_CAPTURED_TOD_REG_PHY_CAPTURED_TOD_MASK)
#define AMPI_PHY_CAPTURED_TOD_REG_PHY_CAPTURED_TOD_RESET                       0x0
#define AMPI_PHY_CAPTURED_TOD_REG_ADDRESS                                      (0x34 + __MAC_AMPI_REG_BASE_ADDRESS)
#define AMPI_PHY_CAPTURED_TOD_REG_RSTMASK                                      0xffffffff
#define AMPI_PHY_CAPTURED_TOD_REG_RESET                                        0x0

// 0x818 (AMPI_MAC_CLOCK_GATE_DISABLE)
#define AMPI_MAC_CLOCK_GATE_DISABLE_CLOCK_GATE_DISABLE_LSB                     0
#define AMPI_MAC_CLOCK_GATE_DISABLE_CLOCK_GATE_DISABLE_MSB                     3
#define AMPI_MAC_CLOCK_GATE_DISABLE_CLOCK_GATE_DISABLE_MASK                    0xf
#define AMPI_MAC_CLOCK_GATE_DISABLE_CLOCK_GATE_DISABLE_GET(x)                  (((x) & AMPI_MAC_CLOCK_GATE_DISABLE_CLOCK_GATE_DISABLE_MASK) >> AMPI_MAC_CLOCK_GATE_DISABLE_CLOCK_GATE_DISABLE_LSB)
#define AMPI_MAC_CLOCK_GATE_DISABLE_CLOCK_GATE_DISABLE_SET(x)                  (((0 | (x)) << AMPI_MAC_CLOCK_GATE_DISABLE_CLOCK_GATE_DISABLE_LSB) & AMPI_MAC_CLOCK_GATE_DISABLE_CLOCK_GATE_DISABLE_MASK)
#define AMPI_MAC_CLOCK_GATE_DISABLE_CLOCK_GATE_DISABLE_RESET                   0xf
#define AMPI_MAC_CLOCK_GATE_DISABLE_ADDRESS                                    (0x818 + __MAC_AMPI_REG_BASE_ADDRESS)
#define AMPI_MAC_CLOCK_GATE_DISABLE_RSTMASK                                    0xf
#define AMPI_MAC_CLOCK_GATE_DISABLE_RESET                                      0xf



#endif /* _MAC_AMPI_REG_H_ */
