// Copyright (c) 2014 Qualcomm Atheros, Inc.  All rights reserved.
// $ATH_LICENSE_HW_HDR_C$
//
// DO NOT EDIT!  This file is automatically generated
//               These definitions are tied to a particular hardware layout


#ifndef _VECTOR_TRANSFER_START_H_
#define _VECTOR_TRANSFER_START_H_
#if !defined(__ASSEMBLER__)
#endif

// ################ START SUMMARY #################
//
//	Dword	Fields
//	0	tx_chain_mask[3:0], user_number[5:4], length[21:6], bf_type[23:22], txbf_per_packet_no_csd_no_walsh[24], reserved[31:25]
//
// ################ END SUMMARY #################

#define NUM_OF_DWORDS_VECTOR_TRANSFER_START 1

struct vector_transfer_start {
    volatile uint32_t tx_chain_mask                   :  4, //[3:0]
                      user_number                     :  2, //[5:4]
                      length                          : 16, //[21:6]
                      bf_type                         :  2, //[23:22]
                      txbf_per_packet_no_csd_no_walsh :  1, //[24]
                      reserved                        :  7; //[31:25]
};

/*

tx_chain_mask
			
			Tx chain mask to support up to 4 antennas.  <legal:
			1-15>

user_number
			
			Indicates user number for TX BF_CV transfer<legal 0-2>

length
			
			Number of octets in current vector frame - limited to
			64kbytes.  <legal all>   #### Actually 0 is not allowed

bf_type
			
			Defines the type of beamforming that is required using
			this CV data
			
			<enum 0    reserved>
			
			<enum 1    LEGACY_BF>
			
			<enum 2    SU_BF>
			
			<enum 3    MU_BF>
			
			 <legal 1-3>

txbf_per_packet_no_csd_no_walsh
			
			If set, no_csd and no_walsh is applied to steering
			packet.

reserved
			
			Reserved: Generator should set to 0 and the consumer
			shall ignore. <legal 0>
*/


/* Description		VECTOR_TRANSFER_START_0_TX_CHAIN_MASK
			
			Tx chain mask to support up to 4 antennas.  <legal:
			1-15>
*/
#define VECTOR_TRANSFER_START_0_TX_CHAIN_MASK_OFFSET                 0x00000000
#define VECTOR_TRANSFER_START_0_TX_CHAIN_MASK_LSB                    0
#define VECTOR_TRANSFER_START_0_TX_CHAIN_MASK_MASK                   0x0000000f

/* Description		VECTOR_TRANSFER_START_0_USER_NUMBER
			
			Indicates user number for TX BF_CV transfer<legal 0-2>
*/
#define VECTOR_TRANSFER_START_0_USER_NUMBER_OFFSET                   0x00000000
#define VECTOR_TRANSFER_START_0_USER_NUMBER_LSB                      4
#define VECTOR_TRANSFER_START_0_USER_NUMBER_MASK                     0x00000030

/* Description		VECTOR_TRANSFER_START_0_LENGTH
			
			Number of octets in current vector frame - limited to
			64kbytes.  <legal all>   #### Actually 0 is not allowed
*/
#define VECTOR_TRANSFER_START_0_LENGTH_OFFSET                        0x00000000
#define VECTOR_TRANSFER_START_0_LENGTH_LSB                           6
#define VECTOR_TRANSFER_START_0_LENGTH_MASK                          0x003fffc0

/* Description		VECTOR_TRANSFER_START_0_BF_TYPE
			
			Defines the type of beamforming that is required using
			this CV data
			
			<enum 0    reserved>
			
			<enum 1    LEGACY_BF>
			
			<enum 2    SU_BF>
			
			<enum 3    MU_BF>
			
			 <legal 1-3>
*/
#define VECTOR_TRANSFER_START_0_BF_TYPE_OFFSET                       0x00000000
#define VECTOR_TRANSFER_START_0_BF_TYPE_LSB                          22
#define VECTOR_TRANSFER_START_0_BF_TYPE_MASK                         0x00c00000

/* Description		VECTOR_TRANSFER_START_0_TXBF_PER_PACKET_NO_CSD_NO_WALSH
			
			If set, no_csd and no_walsh is applied to steering
			packet.
*/
#define VECTOR_TRANSFER_START_0_TXBF_PER_PACKET_NO_CSD_NO_WALSH_OFFSET 0x00000000
#define VECTOR_TRANSFER_START_0_TXBF_PER_PACKET_NO_CSD_NO_WALSH_LSB  24
#define VECTOR_TRANSFER_START_0_TXBF_PER_PACKET_NO_CSD_NO_WALSH_MASK 0x01000000

/* Description		VECTOR_TRANSFER_START_0_RESERVED
			
			Reserved: Generator should set to 0 and the consumer
			shall ignore. <legal 0>
*/
#define VECTOR_TRANSFER_START_0_RESERVED_OFFSET                      0x00000000
#define VECTOR_TRANSFER_START_0_RESERVED_LSB                         25
#define VECTOR_TRANSFER_START_0_RESERVED_MASK                        0xfe000000


#endif // _VECTOR_TRANSFER_START_H_
