// Copyright (c) 2014 Qualcomm Atheros, Inc.  All rights reserved.
// $ATH_LICENSE_HW_HDR_C$
//
// DO NOT EDIT!  This file is automatically generated
//               These definitions are tied to a particular hardware layout


#ifndef _TX_FLOW_CONTROL_H_
#define _TX_FLOW_CONTROL_H_
#if !defined(__ASSEMBLER__)
#endif

// ################ START SUMMARY #################
//
//	Dword	Fields
//	0	user0_fifo[7:0], user1_fifo[15:8], user2_fifo[23:16], reserved[31:24]
//
// ################ END SUMMARY #################

#define NUM_OF_DWORDS_TX_FLOW_CONTROL 1

struct tx_flow_control {
    volatile uint32_t user0_fifo                      :  8, //[7:0]
                      user1_fifo                      :  8, //[15:8]
                      user2_fifo                      :  8, //[23:16]
                      reserved                        :  8; //[31:24]
};

/*

user0_fifo
			
			Defines the number of dwords consumed by hardware user
			0. This number includes the TLV header dword. The MAC shall
			respond by sending a corresponding number of dwords of data
			to fill the FIFO for user 0. The data stored in this FIFO is
			limited to user 0 payload (includes SU payload) and all SIMO
			data (signal fields and SIMO payload). <legal all>

user1_fifo
			
			Defines the number of dwords consumed by hardware user
			1. The MAC shall respond by sending a corresponding number
			of dwords of data to fill the FIFO for user 1. The data
			stored in this FIFO is limited to user 1 payload.  <legal
			all>

user2_fifo
			
			Defines the number of dwords consumed by hardware user
			2. The MAC shall respond by sending a corresponding number
			of dwords of data to fill the FIFO for user 2. The data
			stored in this FIFO is limited to user 2 payload.  <legal
			all>

reserved
			
			Reserved field - PHY to set the value of this field to 0
			<legal 0>
*/


/* Description		TX_FLOW_CONTROL_0_USER0_FIFO
			
			Defines the number of dwords consumed by hardware user
			0. This number includes the TLV header dword. The MAC shall
			respond by sending a corresponding number of dwords of data
			to fill the FIFO for user 0. The data stored in this FIFO is
			limited to user 0 payload (includes SU payload) and all SIMO
			data (signal fields and SIMO payload). <legal all>
*/
#define TX_FLOW_CONTROL_0_USER0_FIFO_OFFSET                          0x00000000
#define TX_FLOW_CONTROL_0_USER0_FIFO_LSB                             0
#define TX_FLOW_CONTROL_0_USER0_FIFO_MASK                            0x000000ff

/* Description		TX_FLOW_CONTROL_0_USER1_FIFO
			
			Defines the number of dwords consumed by hardware user
			1. The MAC shall respond by sending a corresponding number
			of dwords of data to fill the FIFO for user 1. The data
			stored in this FIFO is limited to user 1 payload.  <legal
			all>
*/
#define TX_FLOW_CONTROL_0_USER1_FIFO_OFFSET                          0x00000000
#define TX_FLOW_CONTROL_0_USER1_FIFO_LSB                             8
#define TX_FLOW_CONTROL_0_USER1_FIFO_MASK                            0x0000ff00

/* Description		TX_FLOW_CONTROL_0_USER2_FIFO
			
			Defines the number of dwords consumed by hardware user
			2. The MAC shall respond by sending a corresponding number
			of dwords of data to fill the FIFO for user 2. The data
			stored in this FIFO is limited to user 2 payload.  <legal
			all>
*/
#define TX_FLOW_CONTROL_0_USER2_FIFO_OFFSET                          0x00000000
#define TX_FLOW_CONTROL_0_USER2_FIFO_LSB                             16
#define TX_FLOW_CONTROL_0_USER2_FIFO_MASK                            0x00ff0000

/* Description		TX_FLOW_CONTROL_0_RESERVED
			
			Reserved field - PHY to set the value of this field to 0
			<legal 0>
*/
#define TX_FLOW_CONTROL_0_RESERVED_OFFSET                            0x00000000
#define TX_FLOW_CONTROL_0_RESERVED_LSB                               24
#define TX_FLOW_CONTROL_0_RESERVED_MASK                              0xff000000


#endif // _TX_FLOW_CONTROL_H_
