// Copyright (c) 2014 Qualcomm Atheros, Inc.  All rights reserved.
// $ATH_LICENSE_HW_HDR_C$
//
// DO NOT EDIT!  This file is automatically generated
//               These definitions are tied to a particular hardware layout


#ifndef _CV_LENGTH_H_
#define _CV_LENGTH_H_
#if !defined(__ASSEMBLER__)
#endif

// ################ START SUMMARY #################
//
//	Dword	Fields
//	0	length[15:0], reserved[31:16]
//
// ################ END SUMMARY #################

#define NUM_OF_DWORDS_CV_LENGTH 1

struct cv_length {
    volatile uint32_t length                          : 16, //[15:0]
                      reserved                        : 16; //[31:16]
};

/*

length
			
			Length of the CV data that will eventually be forwarded
			to the MAC from the PHY via the VECTOR_FRAGMENT mechanism. 
			After receiving the NDPA and NDP, the MAC needs to know the
			number of bytes in the CBF frame.  But the VECTOR_FRAGMENT
			for the CV may not be available at SIFS due to the SVD
			processing delay of the NDP.  Since the MAC needs to
			transmit by SIFS, it needs an early indication of the CBF
			size before the VECTOR_FRAGMENT arrives.

reserved
			
			Reserved - PHY to set this field to 0, MAC to ignore
			this field.  <legal 0>
*/


/* Description		CV_LENGTH_0_LENGTH
			
			Length of the CV data that will eventually be forwarded
			to the MAC from the PHY via the VECTOR_FRAGMENT mechanism. 
			After receiving the NDPA and NDP, the MAC needs to know the
			number of bytes in the CBF frame.  But the VECTOR_FRAGMENT
			for the CV may not be available at SIFS due to the SVD
			processing delay of the NDP.  Since the MAC needs to
			transmit by SIFS, it needs an early indication of the CBF
			size before the VECTOR_FRAGMENT arrives.
*/
#define CV_LENGTH_0_LENGTH_OFFSET                                    0x00000000
#define CV_LENGTH_0_LENGTH_LSB                                       0
#define CV_LENGTH_0_LENGTH_MASK                                      0x0000ffff

/* Description		CV_LENGTH_0_RESERVED
			
			Reserved - PHY to set this field to 0, MAC to ignore
			this field.  <legal 0>
*/
#define CV_LENGTH_0_RESERVED_OFFSET                                  0x00000000
#define CV_LENGTH_0_RESERVED_LSB                                     16
#define CV_LENGTH_0_RESERVED_MASK                                    0xffff0000


#endif // _CV_LENGTH_H_
