// Copyright (c) 2014 Qualcomm Atheros, Inc.  All rights reserved.
// $ATH_LICENSE_HW_HDR_C$
//
// DO NOT EDIT!  This file is automatically generated
//               These definitions are tied to a particular hardware layout


#ifndef _PRE_TX_PHY_DESC_H_
#define _PRE_TX_PHY_DESC_H_
#if !defined(__ASSEMBLER__)
#endif

// ################ START SUMMARY #################
//
//	Dword	Fields
//	0	chain_mask[3:0], paprd_chain_mask[7:4], bf_type[9:8], wait_sifs[10], reserved_0b[14:11], dot11b_preamble_type[15], pkt_type[18:16], reserved_0c[20:19], bandwidth[22:21], res_ndp[23], res_ack_response[24], reserved_0d[29:25], channel_capture[30], res_warm_tx[31]
//	1	tpc_init_pwr_cfg[2:0], dpd_enable[3], tx_pwr[10:4], clpc_en[11], measure_power[12], payload_mcs[16:13], ibfcal_enable[17], mu_ndp[18], heavy_clip_nss[21:19], txbf_per_packet_no_csd_no_walsh[22], tx_pwr_sec80[29:23], reserved_1b[31:30]
//
// ################ END SUMMARY #################

#define NUM_OF_DWORDS_PRE_TX_PHY_DESC 2

struct pre_tx_phy_desc {
    volatile uint32_t chain_mask                      :  4, //[3:0]
                      paprd_chain_mask                :  4, //[7:4]
                      bf_type                         :  2, //[9:8]
                      wait_sifs                       :  1, //[10]
                      reserved_0b                     :  4, //[14:11]
                      dot11b_preamble_type            :  1, //[15]
                      pkt_type                        :  3, //[18:16]
                      reserved_0c                     :  2, //[20:19]
                      bandwidth                       :  2, //[22:21]
                      res_ndp                         :  1, //[23]
                      res_ack_response                :  1, //[24]
                      reserved_0d                     :  5, //[29:25]
                      channel_capture                 :  1, //[30]
                      res_warm_tx                     :  1; //[31]
    volatile uint32_t tpc_init_pwr_cfg                :  3, //[2:0]
                      dpd_enable                      :  1, //[3]
                      tx_pwr                          :  7, //[10:4]
                      clpc_en                         :  1, //[11]
                      measure_power                   :  1, //[12]
                      payload_mcs                     :  4, //[16:13]
                      ibfcal_enable                   :  1, //[17]
                      mu_ndp                          :  1, //[18]
                      heavy_clip_nss                  :  3, //[21:19]
                      txbf_per_packet_no_csd_no_walsh :  1, //[22]
                      tx_pwr_sec80                    :  7, //[29:23]
                      reserved_1b                     :  2; //[31:30]
};

/*

chain_mask
			
			Chain mask to support up to 4 antennas. 
			
			<legal: 1-15>

paprd_chain_mask
			
			Chain mask for the PA predistortion function. 
			
			<legal: 0,1,2,4,8>  

bf_type
			
			<enum_typedef tx_phy_desc bf_type>
			
			<enum 0     NO_BF> Transmit a non-beamformed packet
			
			<enum 1     LEGACY_BF> Transmit a legacy beamformed
			packet.  This means beamforming starts at the L-STF.  The
			possible preamble formats are 11a, 11n mixed mode and 11ac. 
			This is used to support legacy implicit beamforming. 
			
			<enum 2     SU_BF> Transmit a single-user beamformed
			packet starting at the HT-STF or VHT-STF.
			
			<enum 3     MU_BF> Transmit a multi-user beamformed
			packet starting at the VHT-STF.
			
			<legal 0-3>

wait_sifs
			
			If set, the AMPI will hold this tx_phy_desc TLV from the
			TX PCU until SIFS has elapsed and then forward the
			tx_phy_desc to the PHY.  The PHY should ignore this bit. 
			This bit is used to make sure that transmit SIFS response to
			a receive frame is cycle accurate and consistent to enable
			accurate RTT measurement.   

reserved_0b
			
			Reserved: <legal 0>

dot11b_preamble_type
			
			Valid for 802.11b packets only.
			
			<enum_typedef tx_phy_desc dot11b_preamble_type>
			
			<enum 0     short_preamble>
			
			<enum 1     long_preamble>
			
			<legal 0-1>

pkt_type
			
			Packet type:
			
			<enum_typedef tx_phy_desc pkt_type>
			
			<enum 0     dot11a>
			
			<enum 1     dot11b>
			
			<enum 2     dot11n_mm>
			
			<enum 3     dot11ac>
			
			<enum 4     dot11n_gf>
			
			Note: HT Greenfield packet type is not supported
			
			<legal 0-4>

reserved_0c
			
			Reserved: <legal 0>

bandwidth
			
			Packet bandwidth:
			
			<enum_typedef tx_phy_desc bandwidth>
			
			<enum 0     20_mhz>
			
			<enum 1     40_mhz>
			
			<enum 2     80_mhz>
			
			<enum 3     160_mhz> 
			
			<legal 0-3>

res_ndp
			
			Reserved for NDP flag. Field will be overwritten by TX
			PCU when generating the TX_PHY_DESC.
			
			<legal 0>

res_ack_response
			
			Reserved for ack_response. Indicate that the MAC expects
			a response for the transmission or not. Overwritten by TXPCU
			<legal 0>

reserved_0d
			
			Reserved: <legal 0>

channel_capture
			
			Indicates that the BB should be armed to capture the
			channel on the next received packet. This channel estimate
			is passed to the MAC if the packet is successfully received.
			<legal 0-1>

res_warm_tx
			
			Field will be overwritten by TX PCU when generating the
			TX_PHY_DESC.
			
			
			
			Reserved_for warm_tx flag. <legal 0>

tpc_init_pwr_cfg
			
			0~4: traverse mode
			
			Initial analog gain and PA configuration setting where 0
			has the highest power consumption and best EVM,  and 4 has
			the lowest power consumption and worst EVM 
			
			5~7: low power mode
			
			No traverse. Force TPC to select the specified GLUT set
			(5, 6 or 7) for the low power mode or other special
			purposes.
			
			<legal 0-7>

dpd_enable
			
			<enum 0     dpd_off> DPD profile not applied to current
			packet
			
			<enum 1     dpd_on> DPD profile applied to current
			packet if available
			
			<legal 0-1>

tx_pwr
			
			Transmit Power (signed value) in units of 0.5 dBm <legal
			all>

clpc_en
			
			This field enables closed-loop TPC operation by enabling
			CLPC adjustment of DAC gain for the next packet.
			
			<enum 0     clpc_off> TPC error update disabled
			
			<enum 1     clpc_on> TPC error will be applied to DAC
			gain setting for the next packet
			
			<legal 0-1>

measure_power
			
			This field enables the TPC to use power measurement for
			current packet in CLPC updates.
			
			<enum 0 measure_dis> TPC will not latch power
			measurement result for current packet
			
			<enum 1 measure_en> TPC will latch power measurement
			result for current packet

payload_mcs
			
			This field defines the MCS value to be used for
			transmitting the payload. It must match the 4-bit MCS value
			that is sent in the appropriate signal field for the given
			packet type. For 11a/b packets, this field must match the
			RATE field in the L_SIG_A/L_SIG_B TLV.For 11n packets, the
			most-significant bit set to zero, and the remaining
			least-significant 3 bits indicate MCS field of HT-SIG. For
			11ac SU packets, this field must match the 4-bit MCS field
			in VHT_SIG_A TLV. For 11ac MU packets, this field must match
			the highest 4-bit MCS field in all the VHT_SIG_B TLVs that
			are to be sent to the PHY. <legal all>

ibfcal_enable
			
			Defines the current packet as test packet for implicit
			BF calibration purposes  <legal 0-1>

mu_ndp
			
			If set indicates that this packet is an NDP used for MU
			channel estimation.  This bit will be used by the TPC to
			signal that the analog gain settings can be updated. The
			analog gain settings will not change for subsequent MU data
			packets.

heavy_clip_nss
			
			Number of active spatial streams in current packet. This
			parameter is used by the heavy clip function in the
			transmitter. In case of MU PPDU, this is total Nss of all
			users. 
			
			
			
			In sw_trasnmit_mode, this field shall be set by SW. In
			pdg_trasnmit_mode, this field will be set by PDG for mprot
			frame as well as ppdu frame.
			
			
			
			<enum 0 1_spatial_stream>
			
			<enum 1 2_spatial_streams>
			
			<enum 2 3_spatial_streams>
			
			<enum 3 4_spatial_streams>
			
			<legal 0-3>

txbf_per_packet_no_csd_no_walsh
			
			If set, no_csd and no_walsh is applied to steering
			packet.

tx_pwr_sec80
			
			Transmit Power (signed value) in units of 0.5 dBm for
			second segment. Used to control tx power of sec80 channel in
			80+80. Should be set to same value as tx_pwr for all other
			modes. <legal all>

reserved_1b
			
			Reserved<legal 0>
*/


/* Description		PRE_TX_PHY_DESC_0_CHAIN_MASK
			
			Chain mask to support up to 4 antennas. 
			
			<legal: 1-15>
*/
#define PRE_TX_PHY_DESC_0_CHAIN_MASK_OFFSET                          0x00000000
#define PRE_TX_PHY_DESC_0_CHAIN_MASK_LSB                             0
#define PRE_TX_PHY_DESC_0_CHAIN_MASK_MASK                            0x0000000f

/* Description		PRE_TX_PHY_DESC_0_PAPRD_CHAIN_MASK
			
			Chain mask for the PA predistortion function. 
			
			<legal: 0,1,2,4,8>  
*/
#define PRE_TX_PHY_DESC_0_PAPRD_CHAIN_MASK_OFFSET                    0x00000000
#define PRE_TX_PHY_DESC_0_PAPRD_CHAIN_MASK_LSB                       4
#define PRE_TX_PHY_DESC_0_PAPRD_CHAIN_MASK_MASK                      0x000000f0

/* Description		PRE_TX_PHY_DESC_0_BF_TYPE
			
			<enum_typedef tx_phy_desc bf_type>
			
			<enum 0     NO_BF> Transmit a non-beamformed packet
			
			<enum 1     LEGACY_BF> Transmit a legacy beamformed
			packet.  This means beamforming starts at the L-STF.  The
			possible preamble formats are 11a, 11n mixed mode and 11ac. 
			This is used to support legacy implicit beamforming. 
			
			<enum 2     SU_BF> Transmit a single-user beamformed
			packet starting at the HT-STF or VHT-STF.
			
			<enum 3     MU_BF> Transmit a multi-user beamformed
			packet starting at the VHT-STF.
			
			<legal 0-3>
*/
#define PRE_TX_PHY_DESC_0_BF_TYPE_OFFSET                             0x00000000
#define PRE_TX_PHY_DESC_0_BF_TYPE_LSB                                8
#define PRE_TX_PHY_DESC_0_BF_TYPE_MASK                               0x00000300

/* Description		PRE_TX_PHY_DESC_0_WAIT_SIFS
			
			If set, the AMPI will hold this tx_phy_desc TLV from the
			TX PCU until SIFS has elapsed and then forward the
			tx_phy_desc to the PHY.  The PHY should ignore this bit. 
			This bit is used to make sure that transmit SIFS response to
			a receive frame is cycle accurate and consistent to enable
			accurate RTT measurement.   
*/
#define PRE_TX_PHY_DESC_0_WAIT_SIFS_OFFSET                           0x00000000
#define PRE_TX_PHY_DESC_0_WAIT_SIFS_LSB                              10
#define PRE_TX_PHY_DESC_0_WAIT_SIFS_MASK                             0x00000400

/* Description		PRE_TX_PHY_DESC_0_RESERVED_0B
			
			Reserved: <legal 0>
*/
#define PRE_TX_PHY_DESC_0_RESERVED_0B_OFFSET                         0x00000000
#define PRE_TX_PHY_DESC_0_RESERVED_0B_LSB                            11
#define PRE_TX_PHY_DESC_0_RESERVED_0B_MASK                           0x00007800

/* Description		PRE_TX_PHY_DESC_0_DOT11B_PREAMBLE_TYPE
			
			Valid for 802.11b packets only.
			
			<enum_typedef tx_phy_desc dot11b_preamble_type>
			
			<enum 0     short_preamble>
			
			<enum 1     long_preamble>
			
			<legal 0-1>
*/
#define PRE_TX_PHY_DESC_0_DOT11B_PREAMBLE_TYPE_OFFSET                0x00000000
#define PRE_TX_PHY_DESC_0_DOT11B_PREAMBLE_TYPE_LSB                   15
#define PRE_TX_PHY_DESC_0_DOT11B_PREAMBLE_TYPE_MASK                  0x00008000

/* Description		PRE_TX_PHY_DESC_0_PKT_TYPE
			
			Packet type:
			
			<enum_typedef tx_phy_desc pkt_type>
			
			<enum 0     dot11a>
			
			<enum 1     dot11b>
			
			<enum 2     dot11n_mm>
			
			<enum 3     dot11ac>
			
			<enum 4     dot11n_gf>
			
			Note: HT Greenfield packet type is not supported
			
			<legal 0-4>
*/
#define PRE_TX_PHY_DESC_0_PKT_TYPE_OFFSET                            0x00000000
#define PRE_TX_PHY_DESC_0_PKT_TYPE_LSB                               16
#define PRE_TX_PHY_DESC_0_PKT_TYPE_MASK                              0x00070000

/* Description		PRE_TX_PHY_DESC_0_RESERVED_0C
			
			Reserved: <legal 0>
*/
#define PRE_TX_PHY_DESC_0_RESERVED_0C_OFFSET                         0x00000000
#define PRE_TX_PHY_DESC_0_RESERVED_0C_LSB                            19
#define PRE_TX_PHY_DESC_0_RESERVED_0C_MASK                           0x00180000

/* Description		PRE_TX_PHY_DESC_0_BANDWIDTH
			
			Packet bandwidth:
			
			<enum_typedef tx_phy_desc bandwidth>
			
			<enum 0     20_mhz>
			
			<enum 1     40_mhz>
			
			<enum 2     80_mhz>
			
			<enum 3     160_mhz> 
			
			<legal 0-3>
*/
#define PRE_TX_PHY_DESC_0_BANDWIDTH_OFFSET                           0x00000000
#define PRE_TX_PHY_DESC_0_BANDWIDTH_LSB                              21
#define PRE_TX_PHY_DESC_0_BANDWIDTH_MASK                             0x00600000

/* Description		PRE_TX_PHY_DESC_0_RES_NDP
			
			Reserved for NDP flag. Field will be overwritten by TX
			PCU when generating the TX_PHY_DESC.
			
			<legal 0>
*/
#define PRE_TX_PHY_DESC_0_RES_NDP_OFFSET                             0x00000000
#define PRE_TX_PHY_DESC_0_RES_NDP_LSB                                23
#define PRE_TX_PHY_DESC_0_RES_NDP_MASK                               0x00800000

/* Description		PRE_TX_PHY_DESC_0_RES_ACK_RESPONSE
			
			Reserved for ack_response. Indicate that the MAC expects
			a response for the transmission or not. Overwritten by TXPCU
			<legal 0>
*/
#define PRE_TX_PHY_DESC_0_RES_ACK_RESPONSE_OFFSET                    0x00000000
#define PRE_TX_PHY_DESC_0_RES_ACK_RESPONSE_LSB                       24
#define PRE_TX_PHY_DESC_0_RES_ACK_RESPONSE_MASK                      0x01000000

/* Description		PRE_TX_PHY_DESC_0_RESERVED_0D
			
			Reserved: <legal 0>
*/
#define PRE_TX_PHY_DESC_0_RESERVED_0D_OFFSET                         0x00000000
#define PRE_TX_PHY_DESC_0_RESERVED_0D_LSB                            25
#define PRE_TX_PHY_DESC_0_RESERVED_0D_MASK                           0x3e000000

/* Description		PRE_TX_PHY_DESC_0_CHANNEL_CAPTURE
			
			Indicates that the BB should be armed to capture the
			channel on the next received packet. This channel estimate
			is passed to the MAC if the packet is successfully received.
			<legal 0-1>
*/
#define PRE_TX_PHY_DESC_0_CHANNEL_CAPTURE_OFFSET                     0x00000000
#define PRE_TX_PHY_DESC_0_CHANNEL_CAPTURE_LSB                        30
#define PRE_TX_PHY_DESC_0_CHANNEL_CAPTURE_MASK                       0x40000000

/* Description		PRE_TX_PHY_DESC_0_RES_WARM_TX
			
			Field will be overwritten by TX PCU when generating the
			TX_PHY_DESC.
			
			
			
			Reserved_for warm_tx flag. <legal 0>
*/
#define PRE_TX_PHY_DESC_0_RES_WARM_TX_OFFSET                         0x00000000
#define PRE_TX_PHY_DESC_0_RES_WARM_TX_LSB                            31
#define PRE_TX_PHY_DESC_0_RES_WARM_TX_MASK                           0x80000000

/* Description		PRE_TX_PHY_DESC_1_TPC_INIT_PWR_CFG
			
			0~4: traverse mode
			
			Initial analog gain and PA configuration setting where 0
			has the highest power consumption and best EVM,  and 4 has
			the lowest power consumption and worst EVM 
			
			5~7: low power mode
			
			No traverse. Force TPC to select the specified GLUT set
			(5, 6 or 7) for the low power mode or other special
			purposes.
			
			<legal 0-7>
*/
#define PRE_TX_PHY_DESC_1_TPC_INIT_PWR_CFG_OFFSET                    0x00000004
#define PRE_TX_PHY_DESC_1_TPC_INIT_PWR_CFG_LSB                       0
#define PRE_TX_PHY_DESC_1_TPC_INIT_PWR_CFG_MASK                      0x00000007

/* Description		PRE_TX_PHY_DESC_1_DPD_ENABLE
			
			<enum 0     dpd_off> DPD profile not applied to current
			packet
			
			<enum 1     dpd_on> DPD profile applied to current
			packet if available
			
			<legal 0-1>
*/
#define PRE_TX_PHY_DESC_1_DPD_ENABLE_OFFSET                          0x00000004
#define PRE_TX_PHY_DESC_1_DPD_ENABLE_LSB                             3
#define PRE_TX_PHY_DESC_1_DPD_ENABLE_MASK                            0x00000008

/* Description		PRE_TX_PHY_DESC_1_TX_PWR
			
			Transmit Power (signed value) in units of 0.5 dBm <legal
			all>
*/
#define PRE_TX_PHY_DESC_1_TX_PWR_OFFSET                              0x00000004
#define PRE_TX_PHY_DESC_1_TX_PWR_LSB                                 4
#define PRE_TX_PHY_DESC_1_TX_PWR_MASK                                0x000007f0

/* Description		PRE_TX_PHY_DESC_1_CLPC_EN
			
			This field enables closed-loop TPC operation by enabling
			CLPC adjustment of DAC gain for the next packet.
			
			<enum 0     clpc_off> TPC error update disabled
			
			<enum 1     clpc_on> TPC error will be applied to DAC
			gain setting for the next packet
			
			<legal 0-1>
*/
#define PRE_TX_PHY_DESC_1_CLPC_EN_OFFSET                             0x00000004
#define PRE_TX_PHY_DESC_1_CLPC_EN_LSB                                11
#define PRE_TX_PHY_DESC_1_CLPC_EN_MASK                               0x00000800

/* Description		PRE_TX_PHY_DESC_1_MEASURE_POWER
			
			This field enables the TPC to use power measurement for
			current packet in CLPC updates.
			
			<enum 0 measure_dis> TPC will not latch power
			measurement result for current packet
			
			<enum 1 measure_en> TPC will latch power measurement
			result for current packet
*/
#define PRE_TX_PHY_DESC_1_MEASURE_POWER_OFFSET                       0x00000004
#define PRE_TX_PHY_DESC_1_MEASURE_POWER_LSB                          12
#define PRE_TX_PHY_DESC_1_MEASURE_POWER_MASK                         0x00001000

/* Description		PRE_TX_PHY_DESC_1_PAYLOAD_MCS
			
			This field defines the MCS value to be used for
			transmitting the payload. It must match the 4-bit MCS value
			that is sent in the appropriate signal field for the given
			packet type. For 11a/b packets, this field must match the
			RATE field in the L_SIG_A/L_SIG_B TLV.For 11n packets, the
			most-significant bit set to zero, and the remaining
			least-significant 3 bits indicate MCS field of HT-SIG. For
			11ac SU packets, this field must match the 4-bit MCS field
			in VHT_SIG_A TLV. For 11ac MU packets, this field must match
			the highest 4-bit MCS field in all the VHT_SIG_B TLVs that
			are to be sent to the PHY. <legal all>
*/
#define PRE_TX_PHY_DESC_1_PAYLOAD_MCS_OFFSET                         0x00000004
#define PRE_TX_PHY_DESC_1_PAYLOAD_MCS_LSB                            13
#define PRE_TX_PHY_DESC_1_PAYLOAD_MCS_MASK                           0x0001e000

/* Description		PRE_TX_PHY_DESC_1_IBFCAL_ENABLE
			
			Defines the current packet as test packet for implicit
			BF calibration purposes  <legal 0-1>
*/
#define PRE_TX_PHY_DESC_1_IBFCAL_ENABLE_OFFSET                       0x00000004
#define PRE_TX_PHY_DESC_1_IBFCAL_ENABLE_LSB                          17
#define PRE_TX_PHY_DESC_1_IBFCAL_ENABLE_MASK                         0x00020000

/* Description		PRE_TX_PHY_DESC_1_MU_NDP
			
			If set indicates that this packet is an NDP used for MU
			channel estimation.  This bit will be used by the TPC to
			signal that the analog gain settings can be updated. The
			analog gain settings will not change for subsequent MU data
			packets.
*/
#define PRE_TX_PHY_DESC_1_MU_NDP_OFFSET                              0x00000004
#define PRE_TX_PHY_DESC_1_MU_NDP_LSB                                 18
#define PRE_TX_PHY_DESC_1_MU_NDP_MASK                                0x00040000

/* Description		PRE_TX_PHY_DESC_1_HEAVY_CLIP_NSS
			
			Number of active spatial streams in current packet. This
			parameter is used by the heavy clip function in the
			transmitter. In case of MU PPDU, this is total Nss of all
			users. 
			
			
			
			In sw_trasnmit_mode, this field shall be set by SW. In
			pdg_trasnmit_mode, this field will be set by PDG for mprot
			frame as well as ppdu frame.
			
			
			
			<enum 0 1_spatial_stream>
			
			<enum 1 2_spatial_streams>
			
			<enum 2 3_spatial_streams>
			
			<enum 3 4_spatial_streams>
			
			<legal 0-3>
*/
#define PRE_TX_PHY_DESC_1_HEAVY_CLIP_NSS_OFFSET                      0x00000004
#define PRE_TX_PHY_DESC_1_HEAVY_CLIP_NSS_LSB                         19
#define PRE_TX_PHY_DESC_1_HEAVY_CLIP_NSS_MASK                        0x00380000

/* Description		PRE_TX_PHY_DESC_1_TXBF_PER_PACKET_NO_CSD_NO_WALSH
			
			If set, no_csd and no_walsh is applied to steering
			packet.
*/
#define PRE_TX_PHY_DESC_1_TXBF_PER_PACKET_NO_CSD_NO_WALSH_OFFSET     0x00000004
#define PRE_TX_PHY_DESC_1_TXBF_PER_PACKET_NO_CSD_NO_WALSH_LSB        22
#define PRE_TX_PHY_DESC_1_TXBF_PER_PACKET_NO_CSD_NO_WALSH_MASK       0x00400000

/* Description		PRE_TX_PHY_DESC_1_TX_PWR_SEC80
			
			Transmit Power (signed value) in units of 0.5 dBm for
			second segment. Used to control tx power of sec80 channel in
			80+80. Should be set to same value as tx_pwr for all other
			modes. <legal all>
*/
#define PRE_TX_PHY_DESC_1_TX_PWR_SEC80_OFFSET                        0x00000004
#define PRE_TX_PHY_DESC_1_TX_PWR_SEC80_LSB                           23
#define PRE_TX_PHY_DESC_1_TX_PWR_SEC80_MASK                          0x3f800000

/* Description		PRE_TX_PHY_DESC_1_RESERVED_1B
			
			Reserved<legal 0>
*/
#define PRE_TX_PHY_DESC_1_RESERVED_1B_OFFSET                         0x00000004
#define PRE_TX_PHY_DESC_1_RESERVED_1B_LSB                            30
#define PRE_TX_PHY_DESC_1_RESERVED_1B_MASK                           0xc0000000


#endif // _PRE_TX_PHY_DESC_H_
