/*
 * Copyright (c) 2015 Qualcomm Atheros, Inc.
 * All Rights Reserved.
 * Qualcomm Atheros Confidential and Proprietary.
 */

package RegAccess;
use strict;
use Class::Struct;

use constant regMapStruct => {
###################################################################
## pcie_local_reg Register/Field definitions
###################################################################
    "RTC_STATE"                                                           => {
                                                                             type => "reg",
                                                                             addr => 0x0,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO"
                                                                             },
    "RTC_STATE.COLD_RESET"                                                => {
                                                                             type => "field",
                                                                             addr => 0x0,
                                                                             width => 1,
                                                                             bitOffset => 13,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0x0
                                                                             },
    "RTC_STATE.XTAL_COUNT"                                                => {
                                                                             type => "field",
                                                                             addr => 0x0,
                                                                             width => 10,
                                                                             bitOffset => 3,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0x0
                                                                             },
    "RTC_STATE.V"                                                         => {
                                                                             type => "field",
                                                                             addr => 0x0,
                                                                             width => 3,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0x0
                                                                             },
    "PCIE_SOC_WAKE"                                                       => {
                                                                             type => "reg",
                                                                             addr => 0x4,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "PCIE_SOC_WAKE.V"                                                     => {
                                                                             type => "field",
                                                                             addr => 0x4,
                                                                             width => 1,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "SOC_GLOBAL_RESET"                                                    => {
                                                                             type => "reg",
                                                                             addr => 0x8,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "SOC_GLOBAL_RESET.MASK_SOC_RST_TO_PCIE_BRIDGE"                        => {
                                                                             type => "field",
                                                                             addr => 0x8,
                                                                             width => 1,
                                                                             bitOffset => 1,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x1
                                                                             },
    "SOC_GLOBAL_RESET.V"                                                  => {
                                                                             type => "field",
                                                                             addr => 0x8,
                                                                             width => 1,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "PCIE_LOCAL_CTRL_OBS_MUX"                                             => {
                                                                             type => "reg",
                                                                             addr => 0x10,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "PCIE_LOCAL_CTRL_OBS_MUX.SEL"                                         => {
                                                                             type => "field",
                                                                             addr => 0x10,
                                                                             width => 6,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "PCIE_DEBUG_LOCAL"                                                    => {
                                                                             type => "reg",
                                                                             addr => 0x14,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO"
                                                                             },
    "PCIE_DEBUG_LOCAL.V"                                                  => {
                                                                             type => "field",
                                                                             addr => 0x14,
                                                                             width => 10,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0x0
                                                                             },
    "PCIE_BAR_VALID"                                                      => {
                                                                             type => "reg",
                                                                             addr => 0x18,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "PCIE_BAR_VALID.DBG"                                                  => {
                                                                             type => "field",
                                                                             addr => 0x18,
                                                                             width => 1,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "PCIE_SOC_RDY_STATUS"                                                 => {
                                                                             type => "reg",
                                                                             addr => 0x1c,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO"
                                                                             },
    "PCIE_SOC_RDY_STATUS.VAL"                                             => {
                                                                             type => "field",
                                                                             addr => 0x1c,
                                                                             width => 31,
                                                                             bitOffset => 1,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0x0
                                                                             },
    "PCIE_SOC_RDY_STATUS.BAR"                                             => {
                                                                             type => "field",
                                                                             addr => 0x1c,
                                                                             width => 1,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0x0
                                                                             },
###################################################################
## bb_reg_map Register/Field definitions
###################################################################
###################################################################
## bb_reg_map.bb_agc_reg_map Register/Field definitions
###################################################################
    "BB_settling_time"                                                    => {
                                                                             type => "reg",
                                                                             addr => 0x10000,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_settling_time.lbreset_advance"                                    => {
                                                                             type => "field",
                                                                             addr => 0x10000,
                                                                             width => 4,
                                                                             bitOffset => 26,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_settling_time.switch_settling"                                    => {
                                                                             type => "field",
                                                                             addr => 0x10000,
                                                                             width => 7,
                                                                             bitOffset => 7,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_settling_time.agc_settling"                                       => {
                                                                             type => "field",
                                                                             addr => 0x10000,
                                                                             width => 7,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_gain_force_max_gains_b0"                                          => {
                                                                             type => "reg",
                                                                             addr => 0x10004,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_gain_force_max_gains_b0.xatten2_hyst_margin_0"                    => {
                                                                             type => "field",
                                                                             addr => 0x10004,
                                                                             width => 7,
                                                                             bitOffset => 25,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_gain_force_max_gains_b0.xatten1_hyst_margin_0"                    => {
                                                                             type => "field",
                                                                             addr => 0x10004,
                                                                             width => 7,
                                                                             bitOffset => 18,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_gain_force_max_gains_b0.xatten2_sw_f_0"                           => {
                                                                             type => "field",
                                                                             addr => 0x10004,
                                                                             width => 1,
                                                                             bitOffset => 17,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_gain_force_max_gains_b0.xatten1_sw_f_0"                           => {
                                                                             type => "field",
                                                                             addr => 0x10004,
                                                                             width => 1,
                                                                             bitOffset => 16,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_gain_force_max_gains_b0.mb_gain_f_0"                              => {
                                                                             type => "field",
                                                                             addr => 0x10004,
                                                                             width => 8,
                                                                             bitOffset => 8,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_gain_force_max_gains_b0.rf_gain_f_0"                              => {
                                                                             type => "field",
                                                                             addr => 0x10004,
                                                                             width => 8,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_gains_min_offsets"                                                => {
                                                                             type => "reg",
                                                                             addr => 0x10008,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_gains_min_offsets.enable_ant_fast_gc_ctrl"                        => {
                                                                             type => "field",
                                                                             addr => 0x10008,
                                                                             width => 1,
                                                                             bitOffset => 24,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_gains_min_offsets.use_fixed_gain"                                 => {
                                                                             type => "field",
                                                                             addr => 0x10008,
                                                                             width => 1,
                                                                             bitOffset => 23,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_gains_min_offsets.enable_srch_start_gain"                         => {
                                                                             type => "field",
                                                                             addr => 0x10008,
                                                                             width => 1,
                                                                             bitOffset => 22,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_gains_min_offsets.cf_agc_hist_phy_err"                            => {
                                                                             type => "field",
                                                                             addr => 0x10008,
                                                                             width => 1,
                                                                             bitOffset => 21,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_gains_min_offsets.cf_agc_hist_voting"                             => {
                                                                             type => "field",
                                                                             addr => 0x10008,
                                                                             width => 1,
                                                                             bitOffset => 20,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_gains_min_offsets.cf_agc_hist_gc"                                 => {
                                                                             type => "field",
                                                                             addr => 0x10008,
                                                                             width => 1,
                                                                             bitOffset => 19,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_gains_min_offsets.cf_agc_hist_enable"                             => {
                                                                             type => "field",
                                                                             addr => 0x10008,
                                                                             width => 1,
                                                                             bitOffset => 18,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_gains_min_offsets.gain_force"                                     => {
                                                                             type => "field",
                                                                             addr => 0x10008,
                                                                             width => 1,
                                                                             bitOffset => 17,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_gains_min_offsets.offsetC3"                                       => {
                                                                             type => "field",
                                                                             addr => 0x10008,
                                                                             width => 5,
                                                                             bitOffset => 12,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_gains_min_offsets.offsetC2"                                       => {
                                                                             type => "field",
                                                                             addr => 0x10008,
                                                                             width => 5,
                                                                             bitOffset => 7,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_gains_min_offsets.offsetC1"                                       => {
                                                                             type => "field",
                                                                             addr => 0x10008,
                                                                             width => 7,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_desired_sigsize"                                                  => {
                                                                             type => "reg",
                                                                             addr => 0x1000c,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_desired_sigsize.ena_init_gain"                                    => {
                                                                             type => "field",
                                                                             addr => 0x1000c,
                                                                             width => 1,
                                                                             bitOffset => 31,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_desired_sigsize.reduce_init_gc_count"                             => {
                                                                             type => "field",
                                                                             addr => 0x1000c,
                                                                             width => 1,
                                                                             bitOffset => 30,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_desired_sigsize.init_gc_count_max"                                => {
                                                                             type => "field",
                                                                             addr => 0x1000c,
                                                                             width => 2,
                                                                             bitOffset => 28,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_desired_sigsize.total_desired"                                    => {
                                                                             type => "field",
                                                                             addr => 0x1000c,
                                                                             width => 8,
                                                                             bitOffset => 20,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_desired_sigsize.disable_fine_rfsat"                               => {
                                                                             type => "field",
                                                                             addr => 0x1000c,
                                                                             width => 1,
                                                                             bitOffset => 8,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x1
                                                                             },
    "BB_desired_sigsize.adc_desired_size"                                 => {
                                                                             type => "field",
                                                                             addr => 0x1000c,
                                                                             width => 8,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_find_signal"                                                      => {
                                                                             type => "reg",
                                                                             addr => 0x10010,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_find_signal.m1count_max"                                          => {
                                                                             type => "field",
                                                                             addr => 0x10010,
                                                                             width => 6,
                                                                             bitOffset => 26,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x1f
                                                                             },
    "BB_find_signal.firpwr"                                               => {
                                                                             type => "field",
                                                                             addr => 0x10010,
                                                                             width => 8,
                                                                             bitOffset => 18,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0xb2
                                                                             },
    "BB_find_signal.firstep"                                              => {
                                                                             type => "field",
                                                                             addr => 0x10010,
                                                                             width => 6,
                                                                             bitOffset => 12,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x04
                                                                             },
    "BB_find_signal.relstep"                                              => {
                                                                             type => "field",
                                                                             addr => 0x10010,
                                                                             width => 6,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x2e
                                                                             },
    "BB_agc"                                                              => {
                                                                             type => "reg",
                                                                             addr => 0x10014,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_agc.rssi_out_select"                                              => {
                                                                             type => "field",
                                                                             addr => 0x10014,
                                                                             width => 2,
                                                                             bitOffset => 30,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_agc.pwrlow_gain_thr"                                              => {
                                                                             type => "field",
                                                                             addr => 0x10014,
                                                                             width => 8,
                                                                             bitOffset => 22,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 40
                                                                             },
    "BB_agc.coarse_high"                                                  => {
                                                                             type => "field",
                                                                             addr => 0x10014,
                                                                             width => 7,
                                                                             bitOffset => 15,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_agc.coarse_low"                                                   => {
                                                                             type => "field",
                                                                             addr => 0x10014,
                                                                             width => 8,
                                                                             bitOffset => 7,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_agc.coarsepwr_const"                                              => {
                                                                             type => "field",
                                                                             addr => 0x10014,
                                                                             width => 7,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_ext_atten_switch_ctl_b0"                                          => {
                                                                             type => "reg",
                                                                             addr => 0x10018,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_ext_atten_switch_ctl_b0.xlna_gain_db_0"                           => {
                                                                             type => "field",
                                                                             addr => 0x10018,
                                                                             width => 5,
                                                                             bitOffset => 24,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_ext_atten_switch_ctl_b0.xatten2_margin_0"                         => {
                                                                             type => "field",
                                                                             addr => 0x10018,
                                                                             width => 6,
                                                                             bitOffset => 18,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_ext_atten_switch_ctl_b0.xatten1_margin_0"                         => {
                                                                             type => "field",
                                                                             addr => 0x10018,
                                                                             width => 6,
                                                                             bitOffset => 12,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 50
                                                                             },
    "BB_ext_atten_switch_ctl_b0.xatten2_db_0"                             => {
                                                                             type => "field",
                                                                             addr => 0x10018,
                                                                             width => 6,
                                                                             bitOffset => 6,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_ext_atten_switch_ctl_b0.xatten1_db_0"                             => {
                                                                             type => "field",
                                                                             addr => 0x10018,
                                                                             width => 6,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_cca_b0"                                                           => {
                                                                             type => "reg",
                                                                             addr => 0x1001c,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_cca_b0.minCCApwr_0"                                               => {
                                                                             type => "field",
                                                                             addr => 0x1001c,
                                                                             width => 9,
                                                                             bitOffset => 20,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0x0
                                                                             },
    "BB_cca_b0.thr_cca"                                                   => {
                                                                             type => "field",
                                                                             addr => 0x1001c,
                                                                             width => 8,
                                                                             bitOffset => 12,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 28
                                                                             },
    "BB_cca_b0.cf_cca_count_maxC"                                         => {
                                                                             type => "field",
                                                                             addr => 0x1001c,
                                                                             width => 3,
                                                                             bitOffset => 9,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x3
                                                                             },
    "BB_cca_b0.cf_maxCCApwr_0"                                            => {
                                                                             type => "field",
                                                                             addr => 0x1001c,
                                                                             width => 9,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x1a6
                                                                             },
    "BB_cca_ctrl_2_b0"                                                    => {
                                                                             type => "reg",
                                                                             addr => 0x10020,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_cca_ctrl_2_b0.minCCA_same_per_segment"                            => {
                                                                             type => "field",
                                                                             addr => 0x10020,
                                                                             width => 1,
                                                                             bitOffset => 28,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_cca_ctrl_2_b0.minCCA_firpwr_thr"                                  => {
                                                                             type => "field",
                                                                             addr => 0x10020,
                                                                             width => 8,
                                                                             bitOffset => 20,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0xa6
                                                                             },
    "BB_cca_ctrl_2_b0.cca_avg_ena"                                        => {
                                                                             type => "field",
                                                                             addr => 0x10020,
                                                                             width => 1,
                                                                             bitOffset => 19,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x1
                                                                             },
    "BB_cca_ctrl_2_b0.thr_cca_mode"                                       => {
                                                                             type => "field",
                                                                             addr => 0x10020,
                                                                             width => 1,
                                                                             bitOffset => 18,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_cca_ctrl_2_b0.NF_gain_comp_0"                                     => {
                                                                             type => "field",
                                                                             addr => 0x10020,
                                                                             width => 8,
                                                                             bitOffset => 10,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_cca_ctrl_2_b0.enable_minCCApwr_thr"                               => {
                                                                             type => "field",
                                                                             addr => 0x10020,
                                                                             width => 1,
                                                                             bitOffset => 9,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_cca_ctrl_2_b0.minCCApwr_thr_0"                                    => {
                                                                             type => "field",
                                                                             addr => 0x10020,
                                                                             width => 9,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_restart"                                                          => {
                                                                             type => "reg",
                                                                             addr => 0x10024,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_restart.dfs_restart_mode"                                         => {
                                                                             type => "field",
                                                                             addr => 0x10024,
                                                                             width => 1,
                                                                             bitOffset => 31,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x1
                                                                             },
    "BB_restart.dfs_restart_ena"                                          => {
                                                                             type => "field",
                                                                             addr => 0x10024,
                                                                             width => 1,
                                                                             bitOffset => 30,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x1
                                                                             },
    "BB_restart.enable_pwr_drop_err_cck"                                  => {
                                                                             type => "field",
                                                                             addr => 0x10024,
                                                                             width => 1,
                                                                             bitOffset => 29,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0x0
                                                                             },
    "BB_restart.weak_rssi_vote_thr"                                       => {
                                                                             type => "field",
                                                                             addr => 0x10024,
                                                                             width => 7,
                                                                             bitOffset => 22,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0x0
                                                                             },
    "BB_restart.enable_ant_fast_div_m2flag"                               => {
                                                                             type => "field",
                                                                             addr => 0x10024,
                                                                             width => 1,
                                                                             bitOffset => 21,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_restart.ant_fast_div_gc_limit"                                    => {
                                                                             type => "field",
                                                                             addr => 0x10024,
                                                                             width => 3,
                                                                             bitOffset => 18,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 2
                                                                             },
    "BB_restart.ofdm_cck_rssi_bias"                                       => {
                                                                             type => "field",
                                                                             addr => 0x10024,
                                                                             width => 6,
                                                                             bitOffset => 12,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0x0
                                                                             },
    "BB_restart.pwrdrop_lgfirpwr_delta"                                   => {
                                                                             type => "field",
                                                                             addr => 0x10024,
                                                                             width => 5,
                                                                             bitOffset => 7,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 10
                                                                             },
    "BB_restart.enable_pwr_drop_err"                                      => {
                                                                             type => "field",
                                                                             addr => 0x10024,
                                                                             width => 1,
                                                                             bitOffset => 6,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_restart.restart_lgfirpwr_delta"                                   => {
                                                                             type => "field",
                                                                             addr => 0x10024,
                                                                             width => 5,
                                                                             bitOffset => 1,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 10
                                                                             },
    "BB_restart.enable_restart"                                           => {
                                                                             type => "field",
                                                                             addr => 0x10024,
                                                                             width => 1,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_multichain_gain_ctrl"                                             => {
                                                                             type => "reg",
                                                                             addr => 0x10028,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_multichain_gain_ctrl.ant_div_sw_com_lock"                         => {
                                                                             type => "field",
                                                                             addr => 0x10028,
                                                                             width => 1,
                                                                             bitOffset => 31,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_multichain_gain_ctrl.ant_div_main_gaintb"                         => {
                                                                             type => "field",
                                                                             addr => 0x10028,
                                                                             width => 1,
                                                                             bitOffset => 30,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_multichain_gain_ctrl.ant_div_alt_gaintb"                          => {
                                                                             type => "field",
                                                                             addr => 0x10028,
                                                                             width => 1,
                                                                             bitOffset => 29,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_multichain_gain_ctrl.ant_div_main_lnaconf"                        => {
                                                                             type => "field",
                                                                             addr => 0x10028,
                                                                             width => 2,
                                                                             bitOffset => 27,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 2
                                                                             },
    "BB_multichain_gain_ctrl.ant_div_alt_lnaconf"                         => {
                                                                             type => "field",
                                                                             addr => 0x10028,
                                                                             width => 2,
                                                                             bitOffset => 25,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 1
                                                                             },
    "BB_multichain_gain_ctrl.enable_ant_div_lnadiv"                       => {
                                                                             type => "field",
                                                                             addr => 0x10028,
                                                                             width => 1,
                                                                             bitOffset => 24,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_multichain_gain_ctrl.enable_ant_sw_rx_prot"                       => {
                                                                             type => "field",
                                                                             addr => 0x10028,
                                                                             width => 1,
                                                                             bitOffset => 23,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_multichain_gain_ctrl.quant_noise_floor_ena"                       => {
                                                                             type => "field",
                                                                             addr => 0x10028,
                                                                             width => 1,
                                                                             bitOffset => 21,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_multichain_gain_ctrl.quant_noise_floor_db"                        => {
                                                                             type => "field",
                                                                             addr => 0x10028,
                                                                             width => 6,
                                                                             bitOffset => 15,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_multichain_gain_ctrl.ant_fast_div_bias"                           => {
                                                                             type => "field",
                                                                             addr => 0x10028,
                                                                             width => 6,
                                                                             bitOffset => 9,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_multichain_gain_ctrl.enable_check_strong_ant"                     => {
                                                                             type => "field",
                                                                             addr => 0x10028,
                                                                             width => 1,
                                                                             bitOffset => 8,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_ext_chan_pwr_thr_1"                                               => {
                                                                             type => "reg",
                                                                             addr => 0x1002c,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_ext_chan_pwr_thr_1.ant_div_alt_ant_deltaNF"                       => {
                                                                             type => "field",
                                                                             addr => 0x1002c,
                                                                             width => 6,
                                                                             bitOffset => 21,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_ext_chan_pwr_thr_1.ant_div_alt_ant_deltaGainIdx"                  => {
                                                                             type => "field",
                                                                             addr => 0x1002c,
                                                                             width => 5,
                                                                             bitOffset => 16,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_ext_chan_pwr_thr_1.ant_div_alt_ant_minGainIdx"                    => {
                                                                             type => "field",
                                                                             addr => 0x1002c,
                                                                             width => 8,
                                                                             bitOffset => 8,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_ext_chan_pwr_thr_1.thr_cca_ext40"                                 => {
                                                                             type => "field",
                                                                             addr => 0x1002c,
                                                                             width => 8,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_ext_bw_pwr_thr"                                                   => {
                                                                             type => "reg",
                                                                             addr => 0x10030,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_ext_bw_pwr_thr.minCCA_relpwr_thr"                                 => {
                                                                             type => "field",
                                                                             addr => 0x10030,
                                                                             width => 8,
                                                                             bitOffset => 18,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0xe0
                                                                             },
    "BB_ext_bw_pwr_thr.bw_det_ext40_max_delta_db"                         => {
                                                                             type => "field",
                                                                             addr => 0x10030,
                                                                             width => 6,
                                                                             bitOffset => 12,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 10
                                                                             },
    "BB_ext_bw_pwr_thr.bw_det_ext20_max_delta_db"                         => {
                                                                             type => "field",
                                                                             addr => 0x10030,
                                                                             width => 6,
                                                                             bitOffset => 6,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 10
                                                                             },
    "BB_ext_bw_pwr_thr.bw_det_pri20_min_rssi_db"                          => {
                                                                             type => "field",
                                                                             addr => 0x10030,
                                                                             width => 6,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 8
                                                                             },
    "BB_ext_bw_pwr_thr_2"                                                 => {
                                                                             type => "reg",
                                                                             addr => 0x10034,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_ext_bw_pwr_thr_2.thr_cca_ext80"                                   => {
                                                                             type => "field",
                                                                             addr => 0x10034,
                                                                             width => 8,
                                                                             bitOffset => 16,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_ext_bw_pwr_thr_2.bw_det_ext40_min_rssi_db"                        => {
                                                                             type => "field",
                                                                             addr => 0x10034,
                                                                             width => 6,
                                                                             bitOffset => 8,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 8
                                                                             },
    "BB_ext_bw_pwr_thr_2.bw_det_ext20_min_rssi_db"                        => {
                                                                             type => "field",
                                                                             addr => 0x10034,
                                                                             width => 6,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 5
                                                                             },
    "BB_rifs_srch"                                                        => {
                                                                             type => "reg",
                                                                             addr => 0x10038,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_rifs_srch.rifs_disable_cck_det"                                   => {
                                                                             type => "field",
                                                                             addr => 0x10038,
                                                                             width => 1,
                                                                             bitOffset => 27,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0x0
                                                                             },
    "BB_rifs_srch.rifs_disable_pwrlow_gc"                                 => {
                                                                             type => "field",
                                                                             addr => 0x10038,
                                                                             width => 1,
                                                                             bitOffset => 26,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x1
                                                                             },
    "BB_rifs_srch.rifs_init_delay"                                        => {
                                                                             type => "field",
                                                                             addr => 0x10038,
                                                                             width => 10,
                                                                             bitOffset => 16,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 400
                                                                             },
    "BB_rifs_srch.init_gain_dB_offset"                                    => {
                                                                             type => "field",
                                                                             addr => 0x10038,
                                                                             width => 8,
                                                                             bitOffset => 8,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 12
                                                                             },
    "BB_peak_det_ctrl_1"                                                  => {
                                                                             type => "reg",
                                                                             addr => 0x1003c,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_peak_det_ctrl_1.pwd_pkdet_during_rx"                              => {
                                                                             type => "field",
                                                                             addr => 0x1003c,
                                                                             width => 1,
                                                                             bitOffset => 31,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x1
                                                                             },
    "BB_peak_det_ctrl_1.pwd_pkdet_during_cal"                             => {
                                                                             type => "field",
                                                                             addr => 0x1003c,
                                                                             width => 1,
                                                                             bitOffset => 30,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x1
                                                                             },
    "BB_peak_det_ctrl_1.peak_det_settling"                                => {
                                                                             type => "field",
                                                                             addr => 0x1003c,
                                                                             width => 7,
                                                                             bitOffset => 23,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 31
                                                                             },
    "BB_peak_det_ctrl_1.peak_det_tally_thr_high_0"                        => {
                                                                             type => "field",
                                                                             addr => 0x1003c,
                                                                             width => 5,
                                                                             bitOffset => 18,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 15
                                                                             },
    "BB_peak_det_ctrl_1.peak_det_tally_thr_med_0"                         => {
                                                                             type => "field",
                                                                             addr => 0x1003c,
                                                                             width => 5,
                                                                             bitOffset => 13,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 15
                                                                             },
    "BB_peak_det_ctrl_1.peak_det_tally_thr_low_0"                         => {
                                                                             type => "field",
                                                                             addr => 0x1003c,
                                                                             width => 5,
                                                                             bitOffset => 8,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 15
                                                                             },
    "BB_peak_det_ctrl_1.peak_det_win_len"                                 => {
                                                                             type => "field",
                                                                             addr => 0x1003c,
                                                                             width => 6,
                                                                             bitOffset => 2,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 16
                                                                             },
    "BB_peak_det_ctrl_1.use_peak_det"                                     => {
                                                                             type => "field",
                                                                             addr => 0x1003c,
                                                                             width => 1,
                                                                             bitOffset => 1,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x1
                                                                             },
    "BB_peak_det_ctrl_1.use_oc_gain_table"                                => {
                                                                             type => "field",
                                                                             addr => 0x1003c,
                                                                             width => 1,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_peak_det_ctrl_2"                                                  => {
                                                                             type => "reg",
                                                                             addr => 0x10040,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_peak_det_ctrl_2.enable_rfsat_strong"                              => {
                                                                             type => "field",
                                                                             addr => 0x10040,
                                                                             width => 1,
                                                                             bitOffset => 31,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x1
                                                                             },
    "BB_peak_det_ctrl_2.enable_rfsat_restart"                             => {
                                                                             type => "field",
                                                                             addr => 0x10040,
                                                                             width => 1,
                                                                             bitOffset => 30,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_peak_det_ctrl_2.rf_gain_drop_db_non_0"                            => {
                                                                             type => "field",
                                                                             addr => 0x10040,
                                                                             width => 5,
                                                                             bitOffset => 18,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 10
                                                                             },
    "BB_peak_det_ctrl_2.rf_gain_drop_db_high_0"                           => {
                                                                             type => "field",
                                                                             addr => 0x10040,
                                                                             width => 5,
                                                                             bitOffset => 12,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 28
                                                                             },
    "BB_peak_det_ctrl_2.rf_gain_drop_db_med_0"                            => {
                                                                             type => "field",
                                                                             addr => 0x10040,
                                                                             width => 5,
                                                                             bitOffset => 6,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 12
                                                                             },
    "BB_peak_det_ctrl_2.rf_gain_drop_db_low_0"                            => {
                                                                             type => "field",
                                                                             addr => 0x10040,
                                                                             width => 5,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 6
                                                                             },
    "BB_rx_gain_bounds_1"                                                 => {
                                                                             type => "reg",
                                                                             addr => 0x10044,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_rx_gain_bounds_1.rf_mb_gain_delta_max_db"                         => {
                                                                             type => "field",
                                                                             addr => 0x10044,
                                                                             width => 6,
                                                                             bitOffset => 26,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 63
                                                                             },
    "BB_rx_gain_bounds_1.rx_ocgain_sel_5G"                                => {
                                                                             type => "field",
                                                                             addr => 0x10044,
                                                                             width => 1,
                                                                             bitOffset => 25,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_rx_gain_bounds_1.rx_ocgain_sel_2G"                                => {
                                                                             type => "field",
                                                                             addr => 0x10044,
                                                                             width => 1,
                                                                             bitOffset => 24,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_rx_gain_bounds_1.rx_max_rf_gain"                                  => {
                                                                             type => "field",
                                                                             addr => 0x10044,
                                                                             width => 8,
                                                                             bitOffset => 16,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 46
                                                                             },
    "BB_rx_gain_bounds_1.rx_max_rf_gain_ref"                              => {
                                                                             type => "field",
                                                                             addr => 0x10044,
                                                                             width => 8,
                                                                             bitOffset => 8,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 40
                                                                             },
    "BB_rx_gain_bounds_1.rx_max_mb_gain"                                  => {
                                                                             type => "field",
                                                                             addr => 0x10044,
                                                                             width => 8,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 39
                                                                             },
    "BB_rx_gain_bounds_2"                                                 => {
                                                                             type => "reg",
                                                                             addr => 0x10048,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_rx_gain_bounds_2.rf_gain_div_base_addr"                           => {
                                                                             type => "field",
                                                                             addr => 0x10048,
                                                                             width => 8,
                                                                             bitOffset => 24,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 80
                                                                             },
    "BB_rx_gain_bounds_2.rf_gain_base_addr"                               => {
                                                                             type => "field",
                                                                             addr => 0x10048,
                                                                             width => 8,
                                                                             bitOffset => 16,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 48
                                                                             },
    "BB_rx_gain_bounds_2.rf_gain_ref_base_addr"                           => {
                                                                             type => "field",
                                                                             addr => 0x10048,
                                                                             width => 8,
                                                                             bitOffset => 8,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 32
                                                                             },
    "BB_rx_gain_bounds_2.gc_rssi_low_db"                                  => {
                                                                             type => "field",
                                                                             addr => 0x10048,
                                                                             width => 8,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 3
                                                                             },
    "BB_peak_det_cal_ctrl"                                                => {
                                                                             type => "reg",
                                                                             addr => 0x1004c,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_peak_det_cal_ctrl.pkdet_cal_meas_time_sel"                        => {
                                                                             type => "field",
                                                                             addr => 0x1004c,
                                                                             width => 2,
                                                                             bitOffset => 13,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 1
                                                                             },
    "BB_peak_det_cal_ctrl.pkdet_cal_bias"                                 => {
                                                                             type => "field",
                                                                             addr => 0x1004c,
                                                                             width => 6,
                                                                             bitOffset => 7,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_peak_det_cal_ctrl.pkdet_cal_win_thr"                              => {
                                                                             type => "field",
                                                                             addr => 0x1004c,
                                                                             width => 7,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 4
                                                                             },
    "BB_agc_dig_dc_ctrl"                                                  => {
                                                                             type => "reg",
                                                                             addr => 0x10050,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_agc_dig_dc_ctrl.dig_dc_switch_cck"                                => {
                                                                             type => "field",
                                                                             addr => 0x10050,
                                                                             width => 1,
                                                                             bitOffset => 10,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0x0
                                                                             },
    "BB_agc_dig_dc_ctrl.use_dig_dc"                                       => {
                                                                             type => "field",
                                                                             addr => 0x10050,
                                                                             width => 1,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x1
                                                                             },
    "BB_bt_coex_1"                                                        => {
                                                                             type => "reg",
                                                                             addr => 0x10054,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_bt_coex_1.bt_rx_disable_NF_cal"                                   => {
                                                                             type => "field",
                                                                             addr => 0x10054,
                                                                             width => 1,
                                                                             bitOffset => 31,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_bt_coex_1.bt_tx_disable_NF_cal"                                   => {
                                                                             type => "field",
                                                                             addr => 0x10054,
                                                                             width => 1,
                                                                             bitOffset => 30,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_bt_coex_1.rf_gain_drop_db_high_1"                                 => {
                                                                             type => "field",
                                                                             addr => 0x10054,
                                                                             width => 5,
                                                                             bitOffset => 25,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_bt_coex_1.rf_gain_drop_db_med_1"                                  => {
                                                                             type => "field",
                                                                             addr => 0x10054,
                                                                             width => 5,
                                                                             bitOffset => 20,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_bt_coex_1.rf_gain_drop_db_low_1"                                  => {
                                                                             type => "field",
                                                                             addr => 0x10054,
                                                                             width => 5,
                                                                             bitOffset => 15,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_bt_coex_1.peak_det_tally_thr_high_1"                              => {
                                                                             type => "field",
                                                                             addr => 0x10054,
                                                                             width => 5,
                                                                             bitOffset => 10,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_bt_coex_1.peak_det_tally_thr_med_1"                               => {
                                                                             type => "field",
                                                                             addr => 0x10054,
                                                                             width => 5,
                                                                             bitOffset => 5,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_bt_coex_1.peak_det_tally_thr_low_1"                               => {
                                                                             type => "field",
                                                                             addr => 0x10054,
                                                                             width => 5,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_bt_coex_2"                                                        => {
                                                                             type => "reg",
                                                                             addr => 0x10058,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_bt_coex_2.rfsat_rx_rx"                                            => {
                                                                             type => "field",
                                                                             addr => 0x10058,
                                                                             width => 2,
                                                                             bitOffset => 30,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_bt_coex_2.rf_gain_drop_db_high_2"                                 => {
                                                                             type => "field",
                                                                             addr => 0x10058,
                                                                             width => 5,
                                                                             bitOffset => 25,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_bt_coex_2.rf_gain_drop_db_med_2"                                  => {
                                                                             type => "field",
                                                                             addr => 0x10058,
                                                                             width => 5,
                                                                             bitOffset => 20,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_bt_coex_2.rf_gain_drop_db_low_2"                                  => {
                                                                             type => "field",
                                                                             addr => 0x10058,
                                                                             width => 5,
                                                                             bitOffset => 15,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_bt_coex_2.peak_det_tally_thr_high_2"                              => {
                                                                             type => "field",
                                                                             addr => 0x10058,
                                                                             width => 5,
                                                                             bitOffset => 10,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_bt_coex_2.peak_det_tally_thr_med_2"                               => {
                                                                             type => "field",
                                                                             addr => 0x10058,
                                                                             width => 5,
                                                                             bitOffset => 5,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_bt_coex_2.peak_det_tally_thr_low_2"                               => {
                                                                             type => "field",
                                                                             addr => 0x10058,
                                                                             width => 5,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_bt_coex_3"                                                        => {
                                                                             type => "reg",
                                                                             addr => 0x1005c,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_bt_coex_3.bt_rx_firpwr_incr"                                      => {
                                                                             type => "field",
                                                                             addr => 0x1005c,
                                                                             width => 4,
                                                                             bitOffset => 28,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_bt_coex_3.rf_gain_drop_db_non_2"                                  => {
                                                                             type => "field",
                                                                             addr => 0x1005c,
                                                                             width => 5,
                                                                             bitOffset => 23,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_bt_coex_3.rf_gain_drop_db_non_1"                                  => {
                                                                             type => "field",
                                                                             addr => 0x1005c,
                                                                             width => 5,
                                                                             bitOffset => 18,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_bt_coex_3.rfsat_eq_srch_rx"                                       => {
                                                                             type => "field",
                                                                             addr => 0x1005c,
                                                                             width => 2,
                                                                             bitOffset => 16,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_bt_coex_3.rfsat_eq_rx_srch"                                       => {
                                                                             type => "field",
                                                                             addr => 0x1005c,
                                                                             width => 2,
                                                                             bitOffset => 14,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_bt_coex_3.rfsat_eq_srch_srch"                                     => {
                                                                             type => "field",
                                                                             addr => 0x1005c,
                                                                             width => 2,
                                                                             bitOffset => 12,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_bt_coex_3.rfsat_wlan_srch_rx"                                     => {
                                                                             type => "field",
                                                                             addr => 0x1005c,
                                                                             width => 2,
                                                                             bitOffset => 10,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_bt_coex_3.rfsat_wlan_rx_srch"                                     => {
                                                                             type => "field",
                                                                             addr => 0x1005c,
                                                                             width => 2,
                                                                             bitOffset => 8,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_bt_coex_3.rfsat_wlan_srch_srch"                                   => {
                                                                             type => "field",
                                                                             addr => 0x1005c,
                                                                             width => 2,
                                                                             bitOffset => 6,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_bt_coex_3.rfsat_bt_srch_rx"                                       => {
                                                                             type => "field",
                                                                             addr => 0x1005c,
                                                                             width => 2,
                                                                             bitOffset => 4,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_bt_coex_3.rfsat_bt_rx_srch"                                       => {
                                                                             type => "field",
                                                                             addr => 0x1005c,
                                                                             width => 2,
                                                                             bitOffset => 2,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_bt_coex_3.rfsat_bt_srch_srch"                                     => {
                                                                             type => "field",
                                                                             addr => 0x1005c,
                                                                             width => 2,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_bt_coex_4"                                                        => {
                                                                             type => "reg",
                                                                             addr => 0x10060,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_bt_coex_4.rfgain_eqv_lna_3"                                       => {
                                                                             type => "field",
                                                                             addr => 0x10060,
                                                                             width => 8,
                                                                             bitOffset => 24,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_bt_coex_4.rfgain_eqv_lna_2"                                       => {
                                                                             type => "field",
                                                                             addr => 0x10060,
                                                                             width => 8,
                                                                             bitOffset => 16,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_bt_coex_4.rfgain_eqv_lna_1"                                       => {
                                                                             type => "field",
                                                                             addr => 0x10060,
                                                                             width => 8,
                                                                             bitOffset => 8,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_bt_coex_4.rfgain_eqv_lna_0"                                       => {
                                                                             type => "field",
                                                                             addr => 0x10060,
                                                                             width => 8,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_bt_coex_5"                                                        => {
                                                                             type => "reg",
                                                                             addr => 0x10064,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_bt_coex_5.rfgain_eqv_lna_7"                                       => {
                                                                             type => "field",
                                                                             addr => 0x10064,
                                                                             width => 8,
                                                                             bitOffset => 24,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_bt_coex_5.rfgain_eqv_lna_6"                                       => {
                                                                             type => "field",
                                                                             addr => 0x10064,
                                                                             width => 8,
                                                                             bitOffset => 16,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_bt_coex_5.rfgain_eqv_lna_5"                                       => {
                                                                             type => "field",
                                                                             addr => 0x10064,
                                                                             width => 8,
                                                                             bitOffset => 8,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_bt_coex_5.rfgain_eqv_lna_4"                                       => {
                                                                             type => "field",
                                                                             addr => 0x10064,
                                                                             width => 8,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_dyn_adc_size_ctrl"                                                => {
                                                                             type => "reg",
                                                                             addr => 0x10068,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_dyn_adc_size_ctrl.adc_size_desired_min_db2"                       => {
                                                                             type => "field",
                                                                             addr => 0x10068,
                                                                             width => 8,
                                                                             bitOffset => 24,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0xB6
                                                                             },
    "BB_dyn_adc_size_ctrl.adc_size_desired_max_db2"                       => {
                                                                             type => "field",
                                                                             addr => 0x10068,
                                                                             width => 8,
                                                                             bitOffset => 16,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0xe2
                                                                             },
    "BB_dyn_adc_size_ctrl.rssi_pri_high_thr"                              => {
                                                                             type => "field",
                                                                             addr => 0x10068,
                                                                             width => 7,
                                                                             bitOffset => 8,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 37
                                                                             },
    "BB_dyn_adc_size_ctrl.alpha_adc_size_relpwr"                          => {
                                                                             type => "field",
                                                                             addr => 0x10068,
                                                                             width => 2,
                                                                             bitOffset => 3,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_dyn_adc_size_ctrl.alpha_adc_size_rssi"                            => {
                                                                             type => "field",
                                                                             addr => 0x10068,
                                                                             width => 2,
                                                                             bitOffset => 1,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 1
                                                                             },
    "BB_dyn_adc_size_ctrl.enable_dynamic_adc_sizing"                      => {
                                                                             type => "field",
                                                                             addr => 0x10068,
                                                                             width => 1,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_rx_lo_dccal_ctrl"                                                 => {
                                                                             type => "reg",
                                                                             addr => 0x1006c,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_rx_lo_dccal_ctrl.calnum_txlb"                                     => {
                                                                             type => "field",
                                                                             addr => 0x1006c,
                                                                             width => 3,
                                                                             bitOffset => 3,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x4
                                                                             },
    "BB_rx_lo_dccal_ctrl.calnum_rx"                                       => {
                                                                             type => "field",
                                                                             addr => 0x1006c,
                                                                             width => 3,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x4
                                                                             },
    "BB_adc_capture"                                                      => {
                                                                             type => "reg",
                                                                             addr => 0x10070,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_adc_capture.adc_capture_chn_idx"                                  => {
                                                                             type => "field",
                                                                             addr => 0x10070,
                                                                             width => 2,
                                                                             bitOffset => 22,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_adc_capture.adc_capture_length"                                   => {
                                                                             type => "field",
                                                                             addr => 0x10070,
                                                                             width => 14,
                                                                             bitOffset => 8,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 2048
                                                                             },
    "BB_adc_capture.adc_capture_scale"                                    => {
                                                                             type => "field",
                                                                             addr => 0x10070,
                                                                             width => 2,
                                                                             bitOffset => 6,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_adc_capture.adc_capture_gc_ena"                                   => {
                                                                             type => "field",
                                                                             addr => 0x10070,
                                                                             width => 1,
                                                                             bitOffset => 5,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x1
                                                                             },
    "BB_adc_capture.adc_capture_format"                                   => {
                                                                             type => "field",
                                                                             addr => 0x10070,
                                                                             width => 1,
                                                                             bitOffset => 4,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_adc_capture.adc_capture_overrun_flag"                             => {
                                                                             type => "field",
                                                                             addr => 0x10070,
                                                                             width => 1,
                                                                             bitOffset => 3,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_adc_capture.adc_capture_sat_flag"                                 => {
                                                                             type => "field",
                                                                             addr => 0x10070,
                                                                             width => 1,
                                                                             bitOffset => 2,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_adc_capture.adc_capture_error_flag"                               => {
                                                                             type => "field",
                                                                             addr => 0x10070,
                                                                             width => 1,
                                                                             bitOffset => 1,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_adc_capture.adc_capture_active"                                   => {
                                                                             type => "field",
                                                                             addr => 0x10070,
                                                                             width => 1,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_find_signal_2"                                                    => {
                                                                             type => "reg",
                                                                             addr => 0x10074,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_find_signal_2.rssi_thr1b"                                         => {
                                                                             type => "field",
                                                                             addr => 0x10074,
                                                                             width => 7,
                                                                             bitOffset => 25,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_find_signal_2.enable_rssi_thr1b"                                  => {
                                                                             type => "field",
                                                                             addr => 0x10074,
                                                                             width => 1,
                                                                             bitOffset => 24,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_find_signal_2.agcsm_skip_cal_after_reset"                         => {
                                                                             type => "field",
                                                                             addr => 0x10074,
                                                                             width => 1,
                                                                             bitOffset => 17,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_find_signal_2.disable_pwr_drop_last_two_sym_vht"                  => {
                                                                             type => "field",
                                                                             addr => 0x10074,
                                                                             width => 1,
                                                                             bitOffset => 16,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_find_signal_2.found_low"                                          => {
                                                                             type => "field",
                                                                             addr => 0x10074,
                                                                             width => 8,
                                                                             bitOffset => 8,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0xc4
                                                                             },
    "BB_find_signal_2.found_low_ena"                                      => {
                                                                             type => "field",
                                                                             addr => 0x10074,
                                                                             width => 1,
                                                                             bitOffset => 7,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x1
                                                                             },
    "BB_find_signal_2.relpwr_weak_db"                                     => {
                                                                             type => "field",
                                                                             addr => 0x10074,
                                                                             width => 6,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x2c
                                                                             },
    "BB_peak_det_ctrl_3"                                                  => {
                                                                             type => "reg",
                                                                             addr => 0x10078,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_peak_det_ctrl_3.first_rfsat_gain_increase"                        => {
                                                                             type => "field",
                                                                             addr => 0x10078,
                                                                             width => 1,
                                                                             bitOffset => 30,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x1
                                                                             },
    "BB_peak_det_ctrl_3.xrf_gain_drop_db"                                 => {
                                                                             type => "field",
                                                                             addr => 0x10078,
                                                                             width => 5,
                                                                             bitOffset => 25,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 15
                                                                             },
    "BB_peak_det_ctrl_3.xrf_gain_drop_ena"                                => {
                                                                             type => "field",
                                                                             addr => 0x10078,
                                                                             width => 1,
                                                                             bitOffset => 24,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x1
                                                                             },
    "BB_peak_det_ctrl_3.use_common_rf_gain_drop"                          => {
                                                                             type => "field",
                                                                             addr => 0x10078,
                                                                             width => 1,
                                                                             bitOffset => 23,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x1
                                                                             },
    "BB_peak_det_ctrl_3.peak_det_4win_thr"                                => {
                                                                             type => "field",
                                                                             addr => 0x10078,
                                                                             width => 2,
                                                                             bitOffset => 21,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_peak_det_ctrl_3.peak_det_4win_ena"                                => {
                                                                             type => "field",
                                                                             addr => 0x10078,
                                                                             width => 1,
                                                                             bitOffset => 20,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x1
                                                                             },
    "BB_peak_det_ctrl_3.rfsat_2_add_rfgain_del"                           => {
                                                                             type => "field",
                                                                             addr => 0x10078,
                                                                             width => 16,
                                                                             bitOffset => 4,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 32
                                                                             },
    "BB_peak_det_ctrl_3.agc_dbdac_reg_setting"                            => {
                                                                             type => "field",
                                                                             addr => 0x10078,
                                                                             width => 4,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_find_signal2"                                                     => {
                                                                             type => "reg",
                                                                             addr => 0x1007c,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_find_signal2.relpwr"                                              => {
                                                                             type => "field",
                                                                             addr => 0x1007c,
                                                                             width => 7,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x24
                                                                             },
    "BB_srch_fft_ctrl_1"                                                  => {
                                                                             type => "reg",
                                                                             addr => 0x10080,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_srch_fft_ctrl_1.pulse_check_srch_fft"                             => {
                                                                             type => "field",
                                                                             addr => 0x10080,
                                                                             width => 1,
                                                                             bitOffset => 31,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_srch_fft_ctrl_1.spectral_scan_dBm_adj"                            => {
                                                                             type => "field",
                                                                             addr => 0x10080,
                                                                             width => 1,
                                                                             bitOffset => 30,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 1
                                                                             },
    "BB_srch_fft_ctrl_1.radar_fft_dBm_adj"                                => {
                                                                             type => "field",
                                                                             addr => 0x10080,
                                                                             width => 1,
                                                                             bitOffset => 29,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_srch_fft_ctrl_1.fft_check_fine_ena"                               => {
                                                                             type => "field",
                                                                             addr => 0x10080,
                                                                             width => 1,
                                                                             bitOffset => 28,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_srch_fft_ctrl_1.radar_fft_long_period"                            => {
                                                                             type => "field",
                                                                             addr => 0x10080,
                                                                             width => 4,
                                                                             bitOffset => 24,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 8
                                                                             },
    "BB_srch_fft_ctrl_1.srch_fft_scale_vec"                               => {
                                                                             type => "field",
                                                                             addr => 0x10080,
                                                                             width => 12,
                                                                             bitOffset => 12,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0xfff
                                                                             },
    "BB_srch_fft_ctrl_1.spectral_scan_bin_scale"                          => {
                                                                             type => "field",
                                                                             addr => 0x10080,
                                                                             width => 2,
                                                                             bitOffset => 10,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_srch_fft_ctrl_1.radar_fft_bin_scale"                              => {
                                                                             type => "field",
                                                                             addr => 0x10080,
                                                                             width => 2,
                                                                             bitOffset => 8,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_srch_fft_ctrl_1.spectral_scan_rpt_mode"                           => {
                                                                             type => "field",
                                                                             addr => 0x10080,
                                                                             width => 2,
                                                                             bitOffset => 6,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 2
                                                                             },
    "BB_srch_fft_ctrl_1.radar_fft_rpt_mode"                               => {
                                                                             type => "field",
                                                                             addr => 0x10080,
                                                                             width => 2,
                                                                             bitOffset => 4,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 1
                                                                             },
    "BB_srch_fft_ctrl_1.spectral_scan_pwr_format"                         => {
                                                                             type => "field",
                                                                             addr => 0x10080,
                                                                             width => 1,
                                                                             bitOffset => 3,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 1
                                                                             },
    "BB_srch_fft_ctrl_1.radar_fft_pwr_format"                             => {
                                                                             type => "field",
                                                                             addr => 0x10080,
                                                                             width => 1,
                                                                             bitOffset => 2,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 1
                                                                             },
    "BB_srch_fft_ctrl_1.fft_check_radar_ena"                              => {
                                                                             type => "field",
                                                                             addr => 0x10080,
                                                                             width => 1,
                                                                             bitOffset => 1,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_srch_fft_ctrl_1.fft_check_wlan_ena"                               => {
                                                                             type => "field",
                                                                             addr => 0x10080,
                                                                             width => 1,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_srch_fft_ctrl_2"                                                  => {
                                                                             type => "reg",
                                                                             addr => 0x10084,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_srch_fft_ctrl_2.str_bin_thr_radar"                                => {
                                                                             type => "field",
                                                                             addr => 0x10084,
                                                                             width => 6,
                                                                             bitOffset => 26,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 8
                                                                             },
    "BB_srch_fft_ctrl_2.str_bin_thr_wlan"                                 => {
                                                                             type => "field",
                                                                             addr => 0x10084,
                                                                             width => 6,
                                                                             bitOffset => 20,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 12
                                                                             },
    "BB_srch_fft_ctrl_2.radar_fft_bw_priority"                            => {
                                                                             type => "field",
                                                                             addr => 0x10084,
                                                                             width => 1,
                                                                             bitOffset => 19,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_srch_fft_ctrl_2.srch_fft_ib_thr"                                  => {
                                                                             type => "field",
                                                                             addr => 0x10084,
                                                                             width => 7,
                                                                             bitOffset => 12,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_srch_fft_ctrl_2.srch_fft_sb_freq"                                 => {
                                                                             type => "field",
                                                                             addr => 0x10084,
                                                                             width => 12,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 931
                                                                             },
    "BB_srch_fft_ctrl_3"                                                  => {
                                                                             type => "reg",
                                                                             addr => 0x10088,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_srch_fft_ctrl_3.nb_tone_thr_radar_blk"                            => {
                                                                             type => "field",
                                                                             addr => 0x10088,
                                                                             width => 8,
                                                                             bitOffset => 24,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 20
                                                                             },
    "BB_srch_fft_ctrl_3.nb_tone_thr_radar_fine"                           => {
                                                                             type => "field",
                                                                             addr => 0x10088,
                                                                             width => 8,
                                                                             bitOffset => 16,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 8
                                                                             },
    "BB_srch_fft_ctrl_3.nb_tone_thr_radar_coarse"                         => {
                                                                             type => "field",
                                                                             addr => 0x10088,
                                                                             width => 8,
                                                                             bitOffset => 8,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 12
                                                                             },
    "BB_srch_fft_ctrl_3.nb_tone_thr_wlan"                                 => {
                                                                             type => "field",
                                                                             addr => 0x10088,
                                                                             width => 8,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 20
                                                                             },
    "BB_srch_fft_ctrl_4"                                                  => {
                                                                             type => "reg",
                                                                             addr => 0x1008c,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_srch_fft_ctrl_4.radar_fft_short_rpt_sel"                          => {
                                                                             type => "field",
                                                                             addr => 0x1008c,
                                                                             width => 1,
                                                                             bitOffset => 31,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_srch_fft_ctrl_4.srch_fft_dc_scale_inband"                         => {
                                                                             type => "field",
                                                                             addr => 0x1008c,
                                                                             width => 3,
                                                                             bitOffset => 28,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 2
                                                                             },
    "BB_srch_fft_ctrl_4.srch_fft_pwr_drop_ratio"                          => {
                                                                             type => "field",
                                                                             addr => 0x1008c,
                                                                             width => 4,
                                                                             bitOffset => 24,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 3
                                                                             },
    "BB_srch_fft_ctrl_4.srch_fft_pwr_low_cap"                             => {
                                                                             type => "field",
                                                                             addr => 0x1008c,
                                                                             width => 6,
                                                                             bitOffset => 18,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 25
                                                                             },
    "BB_srch_fft_ctrl_4.srch_fft_rfsat_peakmag_thr"                       => {
                                                                             type => "field",
                                                                             addr => 0x1008c,
                                                                             width => 10,
                                                                             bitOffset => 8,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 255
                                                                             },
    "BB_srch_fft_ctrl_4.spectral_scan_chn_mask"                           => {
                                                                             type => "field",
                                                                             addr => 0x1008c,
                                                                             width => 4,
                                                                             bitOffset => 4,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 1
                                                                             },
    "BB_srch_fft_ctrl_4.radar_fft_chn_mask"                               => {
                                                                             type => "field",
                                                                             addr => 0x1008c,
                                                                             width => 4,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 1
                                                                             },
    "BB_radar_chirp_detect"                                               => {
                                                                             type => "reg",
                                                                             addr => 0x10090,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_radar_chirp_detect.chirp_fft_bw_check_ena"                        => {
                                                                             type => "field",
                                                                             addr => 0x10090,
                                                                             width => 1,
                                                                             bitOffset => 29,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x1
                                                                             },
    "BB_radar_chirp_detect.nonlin_vel_check_ena"                          => {
                                                                             type => "field",
                                                                             addr => 0x10090,
                                                                             width => 1,
                                                                             bitOffset => 28,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x1
                                                                             },
    "BB_radar_chirp_detect.chirp_max_num_fft_rpt"                         => {
                                                                             type => "field",
                                                                             addr => 0x10090,
                                                                             width => 5,
                                                                             bitOffset => 23,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 4
                                                                             },
    "BB_radar_chirp_detect.srch_fft_str_rssi_thresh"                      => {
                                                                             type => "field",
                                                                             addr => 0x10090,
                                                                             width => 6,
                                                                             bitOffset => 17,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 15
                                                                             },
    "BB_radar_chirp_detect.chirp_max_delta_diff"                          => {
                                                                             type => "field",
                                                                             addr => 0x10090,
                                                                             width => 4,
                                                                             bitOffset => 13,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 2
                                                                             },
    "BB_radar_chirp_detect.chirp_max_delta_bin"                           => {
                                                                             type => "field",
                                                                             addr => 0x10090,
                                                                             width => 5,
                                                                             bitOffset => 8,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 11
                                                                             },
    "BB_radar_chirp_detect.chirp_min_delta_bin"                           => {
                                                                             type => "field",
                                                                             addr => 0x10090,
                                                                             width => 5,
                                                                             bitOffset => 3,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 1
                                                                             },
    "BB_radar_chirp_detect.chirp_max_num_diff"                            => {
                                                                             type => "field",
                                                                             addr => 0x10090,
                                                                             width => 3,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 3
                                                                             },
    "BB_spectral_scan_2"                                                  => {
                                                                             type => "reg",
                                                                             addr => 0x10098,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_spectral_scan_2.spectral_scan_rssi_rpt_mode"                      => {
                                                                             type => "field",
                                                                             addr => 0x10098,
                                                                             width => 1,
                                                                             bitOffset => 31,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_spectral_scan_2.spectral_scan_wb_rpt_mode"                        => {
                                                                             type => "field",
                                                                             addr => 0x10098,
                                                                             width => 1,
                                                                             bitOffset => 30,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_spectral_scan_2.spectral_scan_str_bin_thr"                        => {
                                                                             type => "field",
                                                                             addr => 0x10098,
                                                                             width => 6,
                                                                             bitOffset => 24,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 8
                                                                             },
    "BB_spectral_scan_2.spectral_scan_nb_tone_thr"                        => {
                                                                             type => "field",
                                                                             addr => 0x10098,
                                                                             width => 8,
                                                                             bitOffset => 16,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 12
                                                                             },
    "BB_spectral_scan_2.spectral_scan_init_delay"                         => {
                                                                             type => "field",
                                                                             addr => 0x10098,
                                                                             width => 7,
                                                                             bitOffset => 8,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 80
                                                                             },
    "BB_spectral_scan_2.spectral_scan_noise_floor_ref"                    => {
                                                                             type => "field",
                                                                             addr => 0x10098,
                                                                             width => 8,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0xa0
                                                                             },
    "BB_spectral_scan_3"                                                  => {
                                                                             type => "reg",
                                                                             addr => 0x1009c,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_spectral_scan_3.spectral_scan_rssi_thr"                           => {
                                                                             type => "field",
                                                                             addr => 0x1009c,
                                                                             width => 8,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0xf0
                                                                             },
    "BB_agc_timeout_1"                                                    => {
                                                                             type => "reg",
                                                                             addr => 0x100a0,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_agc_timeout_1.agc_ht_stf_sm_timeout"                              => {
                                                                             type => "field",
                                                                             addr => 0x100a0,
                                                                             width => 8,
                                                                             bitOffset => 16,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x00
                                                                             },
    "BB_agc_timeout_1.sscan_sm_timeout"                                   => {
                                                                             type => "field",
                                                                             addr => 0x100a0,
                                                                             width => 8,
                                                                             bitOffset => 8,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x00
                                                                             },
    "BB_agc_timeout_1.radar_sm_timeout"                                   => {
                                                                             type => "field",
                                                                             addr => 0x100a0,
                                                                             width => 8,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x00
                                                                             },
    "BB_adcsat_ctrl_1"                                                    => {
                                                                             type => "reg",
                                                                             addr => 0x100a4,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_adcsat_ctrl_1.adcsat_cnt_thr"                                     => {
                                                                             type => "field",
                                                                             addr => 0x100a4,
                                                                             width => 5,
                                                                             bitOffset => 21,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 8
                                                                             },
    "BB_adcsat_ctrl_1.adcsat_win_len"                                     => {
                                                                             type => "field",
                                                                             addr => 0x100a4,
                                                                             width => 5,
                                                                             bitOffset => 16,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 16
                                                                             },
    "BB_adcsat_ctrl_1.adcsat_clip_found_thr"                              => {
                                                                             type => "field",
                                                                             addr => 0x100a4,
                                                                             width => 8,
                                                                             bitOffset => 8,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 247
                                                                             },
    "BB_adcsat_ctrl_1.adcsat_clip_coarse_thr"                             => {
                                                                             type => "field",
                                                                             addr => 0x100a4,
                                                                             width => 8,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 145
                                                                             },
    "BB_adcsat_ctrl_2"                                                    => {
                                                                             type => "reg",
                                                                             addr => 0x100a8,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_adcsat_ctrl_2.use_rf_gain_for_xatten_control"                     => {
                                                                             type => "field",
                                                                             addr => 0x100a8,
                                                                             width => 1,
                                                                             bitOffset => 31,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_adcsat_ctrl_2.rf_reduce_only_gcmode1_recent_rfsat"                => {
                                                                             type => "field",
                                                                             addr => 0x100a8,
                                                                             width => 1,
                                                                             bitOffset => 24,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_adcsat_ctrl_2.quickdrop_other"                                    => {
                                                                             type => "field",
                                                                             addr => 0x100a8,
                                                                             width => 8,
                                                                             bitOffset => 16,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0xec
                                                                             },
    "BB_adcsat_ctrl_2.quickdrop_found"                                    => {
                                                                             type => "field",
                                                                             addr => 0x100a8,
                                                                             width => 8,
                                                                             bitOffset => 8,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0xd8
                                                                             },
    "BB_adcsat_ctrl_2.quickdrop_coarse"                                   => {
                                                                             type => "field",
                                                                             addr => 0x100a8,
                                                                             width => 8,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0xd8
                                                                             },
    "BB_agc_spare_01"                                                     => {
                                                                             type => "reg",
                                                                             addr => 0x100ac,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_agc_spare_01.agc_eco_ctrl"                                        => {
                                                                             type => "field",
                                                                             addr => 0x100ac,
                                                                             width => 32,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_agc_ht_stf_ctrl_1"                                                => {
                                                                             type => "reg",
                                                                             addr => 0x100b0,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_agc_ht_stf_ctrl_1.agc_ht_stf_min_adc_pwr"                         => {
                                                                             type => "field",
                                                                             addr => 0x100b0,
                                                                             width => 8,
                                                                             bitOffset => 24,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0xe2
                                                                             },
    "BB_agc_ht_stf_ctrl_1.agc_ht_stf_min_lstf_pwr"                        => {
                                                                             type => "field",
                                                                             addr => 0x100b0,
                                                                             width => 8,
                                                                             bitOffset => 16,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0xd8
                                                                             },
    "BB_agc_ht_stf_ctrl_1.agc_ht_stf_weak_size_desired"                   => {
                                                                             type => "field",
                                                                             addr => 0x100b0,
                                                                             width => 8,
                                                                             bitOffset => 8,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0xc4
                                                                             },
    "BB_agc_ht_stf_ctrl_1.agc_ht_stf_pwr_delay"                           => {
                                                                             type => "field",
                                                                             addr => 0x100b0,
                                                                             width => 6,
                                                                             bitOffset => 2,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 35
                                                                             },
    "BB_agc_ht_stf_ctrl_1.agc_ht_stf_allow_gain_incr"                     => {
                                                                             type => "field",
                                                                             addr => 0x100b0,
                                                                             width => 1,
                                                                             bitOffset => 1,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x1
                                                                             },
    "BB_agc_ht_stf_ctrl_1.agc_ht_stf_ena"                                 => {
                                                                             type => "field",
                                                                             addr => 0x100b0,
                                                                             width => 1,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x1
                                                                             },
    "BB_agc_ht_stf_ctrl_2"                                                => {
                                                                             type => "reg",
                                                                             addr => 0x100b4,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_agc_ht_stf_ctrl_2.agc_ht_stf_settling"                            => {
                                                                             type => "field",
                                                                             addr => 0x100b4,
                                                                             width => 7,
                                                                             bitOffset => 23,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 22
                                                                             },
    "BB_agc_ht_stf_ctrl_2.agc_ht_stf_allow_rf"                            => {
                                                                             type => "field",
                                                                             addr => 0x100b4,
                                                                             width => 1,
                                                                             bitOffset => 22,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_agc_ht_stf_ctrl_2.agc_ht_stf_dc_est_win_sel"                      => {
                                                                             type => "field",
                                                                             addr => 0x100b4,
                                                                             width => 1,
                                                                             bitOffset => 21,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x1
                                                                             },
    "BB_agc_ht_stf_ctrl_2.agc_ht_stf_dc_est_ena"                          => {
                                                                             type => "field",
                                                                             addr => 0x100b4,
                                                                             width => 1,
                                                                             bitOffset => 20,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x1
                                                                             },
    "BB_agc_ht_stf_ctrl_2.vht_sym_det_num_bins"                           => {
                                                                             type => "field",
                                                                             addr => 0x100b4,
                                                                             width => 4,
                                                                             bitOffset => 16,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 11
                                                                             },
    "BB_agc_ht_stf_ctrl_2.agc_ht_stf_pwr_low_gc_thr"                      => {
                                                                             type => "field",
                                                                             addr => 0x100b4,
                                                                             width => 8,
                                                                             bitOffset => 8,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 12
                                                                             },
    "BB_agc_ht_stf_ctrl_2.agc_ht_stf_pwr_high_gc_thr"                     => {
                                                                             type => "field",
                                                                             addr => 0x100b4,
                                                                             width => 8,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 12
                                                                             },
    "BB_agc_ht_stf_ctrl_3"                                                => {
                                                                             type => "reg",
                                                                             addr => 0x100b8,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_agc_ht_stf_ctrl_3.agc_ht_stf_lsig_len_min"                        => {
                                                                             type => "field",
                                                                             addr => 0x100b8,
                                                                             width => 8,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 8
                                                                             },
    "BB_radar_lb_control"                                                 => {
                                                                             type => "reg",
                                                                             addr => 0x100bc,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_radar_lb_control.force_adc_lb_bypass"                             => {
                                                                             type => "field",
                                                                             addr => 0x100bc,
                                                                             width => 1,
                                                                             bitOffset => 31,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_radar_lb_control.force_pwr_lb_bypass"                             => {
                                                                             type => "field",
                                                                             addr => 0x100bc,
                                                                             width => 1,
                                                                             bitOffset => 30,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_radar_lb_control.chirp_over_dc_interval"                          => {
                                                                             type => "field",
                                                                             addr => 0x100bc,
                                                                             width => 6,
                                                                             bitOffset => 24,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 20
                                                                             },
    "BB_radar_lb_control.chirp_over_dc_skip_ena"                          => {
                                                                             type => "field",
                                                                             addr => 0x100bc,
                                                                             width => 1,
                                                                             bitOffset => 23,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_radar_lb_control.radar_lb_adapt_cmp_thr"                          => {
                                                                             type => "field",
                                                                             addr => 0x100bc,
                                                                             width => 5,
                                                                             bitOffset => 18,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 10
                                                                             },
    "BB_radar_lb_control.radar_lb_conv_factor"                            => {
                                                                             type => "field",
                                                                             addr => 0x100bc,
                                                                             width => 8,
                                                                             bitOffset => 10,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 100
                                                                             },
    "BB_radar_lb_control.radar_lb_dc_cap_at_dc"                           => {
                                                                             type => "field",
                                                                             addr => 0x100bc,
                                                                             width => 9,
                                                                             bitOffset => 1,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 20
                                                                             },
    "BB_radar_lb_control.radar_lb_mode"                                   => {
                                                                             type => "field",
                                                                             addr => 0x100bc,
                                                                             width => 1,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 1
                                                                             },
    "BB_radar_pulse_thres1"                                               => {
                                                                             type => "reg",
                                                                             addr => 0x100c0,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_radar_pulse_thres1.radar_1st_fft_delay"                           => {
                                                                             type => "field",
                                                                             addr => 0x100c0,
                                                                             width => 6,
                                                                             bitOffset => 26,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_radar_pulse_thres1.pursue_ext80_radar"                            => {
                                                                             type => "field",
                                                                             addr => 0x100c0,
                                                                             width => 1,
                                                                             bitOffset => 25,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_radar_pulse_thres1.radar_fft_80p80_rel_thrsh"                     => {
                                                                             type => "field",
                                                                             addr => 0x100c0,
                                                                             width => 6,
                                                                             bitOffset => 19,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_radar_pulse_thres1.pulse_at_dc_rssi_thresh"                       => {
                                                                             type => "field",
                                                                             addr => 0x100c0,
                                                                             width => 6,
                                                                             bitOffset => 13,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 10
                                                                             },
    "BB_radar_pulse_thres1.long_pulse_rssi_thresh"                        => {
                                                                             type => "field",
                                                                             addr => 0x100c0,
                                                                             width => 6,
                                                                             bitOffset => 7,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 10
                                                                             },
    "BB_radar_pulse_thres1.long_pulse_at_dc_rssi_thresh"                  => {
                                                                             type => "field",
                                                                             addr => 0x100c0,
                                                                             width => 6,
                                                                             bitOffset => 1,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 10
                                                                             },
    "BB_radar_pulse_thres1.long_pulse_rssi_check_ena"                     => {
                                                                             type => "field",
                                                                             addr => 0x100c0,
                                                                             width => 1,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 1
                                                                             },
    "BB_radar_pulse_thres2"                                               => {
                                                                             type => "reg",
                                                                             addr => 0x100c4,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_radar_pulse_thres2.srch_fft_adcsat_peakmag_thr"                   => {
                                                                             type => "field",
                                                                             addr => 0x100c4,
                                                                             width => 10,
                                                                             bitOffset => 20,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 100
                                                                             },
    "BB_radar_pulse_thres2.nb_tone_thres_radar_chirp"                     => {
                                                                             type => "field",
                                                                             addr => 0x100c4,
                                                                             width => 8,
                                                                             bitOffset => 12,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 8
                                                                             },
    "BB_radar_pulse_thres2.str_bin_thr_radar_chirp"                       => {
                                                                             type => "field",
                                                                             addr => 0x100c4,
                                                                             width => 6,
                                                                             bitOffset => 6,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 6
                                                                             },
    "BB_radar_pulse_thres2.str_bin_thr_radar_fine"                        => {
                                                                             type => "field",
                                                                             addr => 0x100c4,
                                                                             width => 6,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 6
                                                                             },
    "BB_ss_gain_ctrl_1"                                                   => {
                                                                             type => "reg",
                                                                             addr => 0x100c8,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_ss_gain_ctrl_1.ss_copy_target_power"                              => {
                                                                             type => "field",
                                                                             addr => 0x100c8,
                                                                             width => 1,
                                                                             bitOffset => 24,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_ss_gain_ctrl_1.ss_gain_copy_reduce_db2"                           => {
                                                                             type => "field",
                                                                             addr => 0x100c8,
                                                                             width => 6,
                                                                             bitOffset => 16,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_ss_gain_ctrl_1.ss_settle_time"                                    => {
                                                                             type => "field",
                                                                             addr => 0x100c8,
                                                                             width => 7,
                                                                             bitOffset => 8,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 12
                                                                             },
    "BB_ss_gain_ctrl_1.second_agc_use_16"                                 => {
                                                                             type => "field",
                                                                             addr => 0x100c8,
                                                                             width => 1,
                                                                             bitOffset => 1,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_ss_gain_ctrl_1.ss_gain_copy_ena"                                  => {
                                                                             type => "field",
                                                                             addr => 0x100c8,
                                                                             width => 1,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x1
                                                                             },
    "BB_agc_rtt_ctrl"                                                     => {
                                                                             type => "reg",
                                                                             addr => 0x100d0,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_agc_rtt_ctrl.fixed_str_chain_rtt_en"                              => {
                                                                             type => "field",
                                                                             addr => 0x100d0,
                                                                             width => 1,
                                                                             bitOffset => 18,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_agc_rtt_ctrl.fixed_str_chain_rtt"                                 => {
                                                                             type => "field",
                                                                             addr => 0x100d0,
                                                                             width => 2,
                                                                             bitOffset => 16,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_agc_rtt_ctrl.rtt_chain_sel_th_4"                                  => {
                                                                             type => "field",
                                                                             addr => 0x100d0,
                                                                             width => 10,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_rx_gain_nf_en"                                                    => {
                                                                             type => "reg",
                                                                             addr => 0x10170,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_rx_gain_nf_en.capture_nf_gain"                                    => {
                                                                             type => "field",
                                                                             addr => 0x10170,
                                                                             width => 1,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_rssi_b0"                                                          => {
                                                                             type => "reg",
                                                                             addr => 0x10180,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO"
                                                                             },
    "BB_rssi_b0.rssi_ext80_0"                                             => {
                                                                             type => "field",
                                                                             addr => 0x10180,
                                                                             width => 8,
                                                                             bitOffset => 24,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0
                                                                             },
    "BB_rssi_b0.rssi_ext40_0"                                             => {
                                                                             type => "field",
                                                                             addr => 0x10180,
                                                                             width => 8,
                                                                             bitOffset => 16,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0
                                                                             },
    "BB_rssi_b0.rssi_ext20_0"                                             => {
                                                                             type => "field",
                                                                             addr => 0x10180,
                                                                             width => 8,
                                                                             bitOffset => 8,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0
                                                                             },
    "BB_rssi_b0.rssi_pri20_0"                                             => {
                                                                             type => "field",
                                                                             addr => 0x10180,
                                                                             width => 8,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0
                                                                             },
    "BB_agc_dig_dc_status_b0"                                             => {
                                                                             type => "reg",
                                                                             addr => 0x10188,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_agc_dig_dc_status_b0.dc_cal_residual_dc_q_0"                      => {
                                                                             type => "field",
                                                                             addr => 0x10188,
                                                                             width => 10,
                                                                             bitOffset => 10,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_agc_dig_dc_status_b0.dc_cal_residual_dc_i_0"                      => {
                                                                             type => "field",
                                                                             addr => 0x10188,
                                                                             width => 10,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_dc_cal_status_b0"                                                 => {
                                                                             type => "reg",
                                                                             addr => 0x101a0,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO"
                                                                             },
    "BB_dc_cal_status_b0.offsetC2Q_0"                                     => {
                                                                             type => "field",
                                                                             addr => 0x101a0,
                                                                             width => 8,
                                                                             bitOffset => 24,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0
                                                                             },
    "BB_dc_cal_status_b0.offsetC2I_0"                                     => {
                                                                             type => "field",
                                                                             addr => 0x101a0,
                                                                             width => 8,
                                                                             bitOffset => 16,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0
                                                                             },
    "BB_dc_cal_status_b0.offsetC1Q_0"                                     => {
                                                                             type => "field",
                                                                             addr => 0x101a0,
                                                                             width => 8,
                                                                             bitOffset => 8,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0
                                                                             },
    "BB_dc_cal_status_b0.offsetC1I_0"                                     => {
                                                                             type => "field",
                                                                             addr => 0x101a0,
                                                                             width => 8,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0
                                                                             },
    "BB_dc_cal_status_2_b0"                                               => {
                                                                             type => "reg",
                                                                             addr => 0x101a4,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO"
                                                                             },
    "BB_dc_cal_status_2_b0.offsetC4Q_0"                                   => {
                                                                             type => "field",
                                                                             addr => 0x101a4,
                                                                             width => 8,
                                                                             bitOffset => 24,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0
                                                                             },
    "BB_dc_cal_status_2_b0.offsetC4I_0"                                   => {
                                                                             type => "field",
                                                                             addr => 0x101a4,
                                                                             width => 8,
                                                                             bitOffset => 16,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0
                                                                             },
    "BB_dc_cal_status_2_b0.offsetC3Q_0"                                   => {
                                                                             type => "field",
                                                                             addr => 0x101a4,
                                                                             width => 8,
                                                                             bitOffset => 8,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0
                                                                             },
    "BB_dc_cal_status_2_b0.offsetC3I_0"                                   => {
                                                                             type => "field",
                                                                             addr => 0x101a4,
                                                                             width => 8,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0
                                                                             },
    "BB_dc_cal_status_3_b0"                                               => {
                                                                             type => "reg",
                                                                             addr => 0x101a8,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO"
                                                                             },
    "BB_dc_cal_status_3_b0.offsetC6Q_0"                                   => {
                                                                             type => "field",
                                                                             addr => 0x101a8,
                                                                             width => 8,
                                                                             bitOffset => 24,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => "NL"
                                                                             },
    "BB_dc_cal_status_3_b0.offsetC6I_0"                                   => {
                                                                             type => "field",
                                                                             addr => 0x101a8,
                                                                             width => 8,
                                                                             bitOffset => 16,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => "NL"
                                                                             },
    "BB_dc_cal_status_3_b0.offsetC5Q_0"                                   => {
                                                                             type => "field",
                                                                             addr => 0x101a8,
                                                                             width => 8,
                                                                             bitOffset => 8,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => "NL"
                                                                             },
    "BB_dc_cal_status_3_b0.offsetC5I_0"                                   => {
                                                                             type => "field",
                                                                             addr => 0x101a8,
                                                                             width => 8,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => "NL"
                                                                             },
    "BB_dc_cal_status_4_b0"                                               => {
                                                                             type => "reg",
                                                                             addr => 0x101ac,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO"
                                                                             },
    "BB_dc_cal_status_4_b0.offsetC7Q_0"                                   => {
                                                                             type => "field",
                                                                             addr => 0x101ac,
                                                                             width => 8,
                                                                             bitOffset => 8,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => "NL"
                                                                             },
    "BB_dc_cal_status_4_b0.offsetC7I_0"                                   => {
                                                                             type => "field",
                                                                             addr => 0x101ac,
                                                                             width => 8,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => "NL"
                                                                             },
    "BB_rx_gain_nf_b0"                                                    => {
                                                                             type => "reg",
                                                                             addr => 0x101b0,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO"
                                                                             },
    "BB_rx_gain_nf_b0.gain_val_after_nf_0"                                => {
                                                                             type => "field",
                                                                             addr => 0x101b0,
                                                                             width => 17,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => "NL"
                                                                             },
    "BB_bbb_sig_detect"                                                   => {
                                                                             type => "reg",
                                                                             addr => 0x101c0,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_bbb_sig_detect.disable_str_chain_sel_cck"                         => {
                                                                             type => "field",
                                                                             addr => 0x101c0,
                                                                             width => 1,
                                                                             bitOffset => 31,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0x0
                                                                             },
    "BB_bbb_sig_detect.ena_dc_est_bcorr"                                  => {
                                                                             type => "field",
                                                                             addr => 0x101c0,
                                                                             width => 1,
                                                                             bitOffset => 30,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0x0
                                                                             },
    "BB_bbb_sig_detect.delay_start_dcoff_cck"                             => {
                                                                             type => "field",
                                                                             addr => 0x101c0,
                                                                             width => 1,
                                                                             bitOffset => 29,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0x0
                                                                             },
    "BB_bbb_sig_detect.delay_start_spur_cck"                              => {
                                                                             type => "field",
                                                                             addr => 0x101c0,
                                                                             width => 1,
                                                                             bitOffset => 28,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0x0
                                                                             },
    "BB_bbb_sig_detect.start_dcoff_priority_cck"                          => {
                                                                             type => "field",
                                                                             addr => 0x101c0,
                                                                             width => 1,
                                                                             bitOffset => 27,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0x0
                                                                             },
    "BB_bbb_sig_detect.use_dc_est_during_srch"                            => {
                                                                             type => "field",
                                                                             addr => 0x101c0,
                                                                             width => 1,
                                                                             bitOffset => 26,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_bbb_sig_detect.delay_start_sync_cck"                              => {
                                                                             type => "field",
                                                                             addr => 0x101c0,
                                                                             width => 1,
                                                                             bitOffset => 25,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0x0
                                                                             },
    "BB_bbb_sig_detect.enable_fine_dc_cck"                                => {
                                                                             type => "field",
                                                                             addr => 0x101c0,
                                                                             width => 1,
                                                                             bitOffset => 24,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0x0
                                                                             },
    "BB_bbb_sig_detect.cyc256_fine_dc_est_cck"                            => {
                                                                             type => "field",
                                                                             addr => 0x101c0,
                                                                             width => 1,
                                                                             bitOffset => 23,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0x0
                                                                             },
    "BB_bbb_sig_detect.enable_coarse_dc_cck"                              => {
                                                                             type => "field",
                                                                             addr => 0x101c0,
                                                                             width => 1,
                                                                             bitOffset => 22,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0x0
                                                                             },
    "BB_bbb_sig_detect.cyc64_coarse_dc_est_cck"                           => {
                                                                             type => "field",
                                                                             addr => 0x101c0,
                                                                             width => 1,
                                                                             bitOffset => 21,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0x0
                                                                             },
    "BB_bbb_sig_detect.cyc32_coarse_dc_est_cck"                           => {
                                                                             type => "field",
                                                                             addr => 0x101c0,
                                                                             width => 1,
                                                                             bitOffset => 20,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0x0
                                                                             },
    "BB_bbb_sig_detect.ant_switch_time"                                   => {
                                                                             type => "field",
                                                                             addr => 0x101c0,
                                                                             width => 7,
                                                                             bitOffset => 13,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_bbb_sig_detect.agcreg_channel_freq"                               => {
                                                                             type => "field",
                                                                             addr => 0x101c0,
                                                                             width => 13,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0x0
                                                                             },
    "BB_bbb_dagc_ctrl"                                                    => {
                                                                             type => "reg",
                                                                             addr => 0x101c4,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_bbb_dagc_ctrl.bk_in_scale_coarse"                                 => {
                                                                             type => "field",
                                                                             addr => 0x101c4,
                                                                             width => 2,
                                                                             bitOffset => 30,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0x0
                                                                             },
    "BB_bbb_dagc_ctrl.rxb_det_strong_chn_default"                         => {
                                                                             type => "field",
                                                                             addr => 0x101c4,
                                                                             width => 2,
                                                                             bitOffset => 28,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0x0
                                                                             },
    "BB_bbb_dagc_ctrl.firstep_count_lgmax"                                => {
                                                                             type => "field",
                                                                             addr => 0x101c4,
                                                                             width => 4,
                                                                             bitOffset => 24,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_bbb_dagc_ctrl.firstep_2"                                          => {
                                                                             type => "field",
                                                                             addr => 0x101c4,
                                                                             width => 6,
                                                                             bitOffset => 18,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 12
                                                                             },
    "BB_bbb_dagc_ctrl.enable_firstep_sel"                                 => {
                                                                             type => "field",
                                                                             addr => 0x101c4,
                                                                             width => 1,
                                                                             bitOffset => 17,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_bbb_dagc_ctrl.barker_rssi_thr"                                    => {
                                                                             type => "field",
                                                                             addr => 0x101c4,
                                                                             width => 7,
                                                                             bitOffset => 10,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0x0
                                                                             },
    "BB_bbb_dagc_ctrl.enable_barker_rssi_thr"                             => {
                                                                             type => "field",
                                                                             addr => 0x101c4,
                                                                             width => 1,
                                                                             bitOffset => 9,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0x0
                                                                             },
    "BB_bbb_dagc_ctrl.dagc_target_pwr_cck"                                => {
                                                                             type => "field",
                                                                             addr => 0x101c4,
                                                                             width => 8,
                                                                             bitOffset => 1,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0x0
                                                                             },
    "BB_bbb_dagc_ctrl.enable_dagc_cck"                                    => {
                                                                             type => "field",
                                                                             addr => 0x101c4,
                                                                             width => 1,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0x0
                                                                             },
    "BB_iqcorr_ctrl_cck"                                                  => {
                                                                             type => "reg",
                                                                             addr => 0x101c8,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_iqcorr_ctrl_cck.cf_clc_init_rfgain"                               => {
                                                                             type => "field",
                                                                             addr => 0x101c8,
                                                                             width => 5,
                                                                             bitOffset => 16,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 2
                                                                             },
    "BB_iqcorr_ctrl_cck.clcal_meas_time_sel"                              => {
                                                                             type => "field",
                                                                             addr => 0x101c8,
                                                                             width => 2,
                                                                             bitOffset => 14,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 2
                                                                             },
    "BB_iqcorr_ctrl_cck.rxcal_meas_time_sel"                              => {
                                                                             type => "field",
                                                                             addr => 0x101c8,
                                                                             width => 2,
                                                                             bitOffset => 12,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 2
                                                                             },
    "BB_cck_spur_mit"                                                     => {
                                                                             type => "reg",
                                                                             addr => 0x101cc,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO"
                                                                             },
    "BB_cck_spur_mit.spur_filter_type"                                    => {
                                                                             type => "field",
                                                                             addr => 0x101cc,
                                                                             width => 2,
                                                                             bitOffset => 29,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0x0
                                                                             },
    "BB_cck_spur_mit.cck_spur_freq"                                       => {
                                                                             type => "field",
                                                                             addr => 0x101cc,
                                                                             width => 20,
                                                                             bitOffset => 9,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0x0
                                                                             },
    "BB_cck_spur_mit.spur_rssi_thr"                                       => {
                                                                             type => "field",
                                                                             addr => 0x101cc,
                                                                             width => 8,
                                                                             bitOffset => 1,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0x0
                                                                             },
    "BB_cck_spur_mit.use_cck_spur_mit"                                    => {
                                                                             type => "field",
                                                                             addr => 0x101cc,
                                                                             width => 1,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0x0
                                                                             },
    "BB_mrc_cck_ctrl"                                                     => {
                                                                             type => "reg",
                                                                             addr => 0x101d0,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO"
                                                                             },
    "BB_mrc_cck_ctrl.agcreg_th_d0_b_tf_est"                               => {
                                                                             type => "field",
                                                                             addr => 0x101d0,
                                                                             width => 8,
                                                                             bitOffset => 24,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0x0
                                                                             },
    "BB_mrc_cck_ctrl.agcreg_th_d0_b"                                      => {
                                                                             type => "field",
                                                                             addr => 0x101d0,
                                                                             width => 8,
                                                                             bitOffset => 16,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0x0
                                                                             },
    "BB_mrc_cck_ctrl.agcreg_c11bp"                                        => {
                                                                             type => "field",
                                                                             addr => 0x101d0,
                                                                             width => 8,
                                                                             bitOffset => 8,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0x0
                                                                             },
    "BB_mrc_cck_ctrl.agcreg_c11b"                                         => {
                                                                             type => "field",
                                                                             addr => 0x101d0,
                                                                             width => 8,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0x0
                                                                             },
    "BB_cck_blocker_det"                                                  => {
                                                                             type => "reg",
                                                                             addr => 0x101d4,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_cck_blocker_det.cck_det_ramp_thr"                                 => {
                                                                             type => "field",
                                                                             addr => 0x101d4,
                                                                             width => 5,
                                                                             bitOffset => 27,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0x0
                                                                             },
    "BB_cck_blocker_det.skip_ramp_enable"                                 => {
                                                                             type => "field",
                                                                             addr => 0x101d4,
                                                                             width => 1,
                                                                             bitOffset => 26,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x1
                                                                             },
    "BB_cck_blocker_det.cck_blocker_monitor_time"                         => {
                                                                             type => "field",
                                                                             addr => 0x101d4,
                                                                             width => 6,
                                                                             bitOffset => 20,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0x0
                                                                             },
    "BB_cck_blocker_det.cck_blocker_det_delay_thr"                        => {
                                                                             type => "field",
                                                                             addr => 0x101d4,
                                                                             width => 6,
                                                                             bitOffset => 14,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0x0
                                                                             },
    "BB_cck_blocker_det.cck_blocker_det_thr"                              => {
                                                                             type => "field",
                                                                             addr => 0x101d4,
                                                                             width => 5,
                                                                             bitOffset => 9,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0x0
                                                                             },
    "BB_cck_blocker_det.bk_valid_delay"                                   => {
                                                                             type => "field",
                                                                             addr => 0x101d4,
                                                                             width => 3,
                                                                             bitOffset => 6,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0x0
                                                                             },
    "BB_cck_blocker_det.cck_blocker_det_bksum_num"                        => {
                                                                             type => "field",
                                                                             addr => 0x101d4,
                                                                             width => 4,
                                                                             bitOffset => 2,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0x0
                                                                             },
    "BB_cck_blocker_det.cck_blocker_det_restart_weak_sig"                 => {
                                                                             type => "field",
                                                                             addr => 0x101d4,
                                                                             width => 1,
                                                                             bitOffset => 1,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0x0
                                                                             },
    "BB_cck_blocker_det.cck_freq_shift_blocker_detection"                 => {
                                                                             type => "field",
                                                                             addr => 0x101d4,
                                                                             width => 1,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0x0
                                                                             },
    "BB_bk_corr_settings"                                                 => {
                                                                             type => "reg",
                                                                             addr => 0x101d8,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_bk_corr_settings.bk_in_scale_tf"                                  => {
                                                                             type => "field",
                                                                             addr => 0x101d8,
                                                                             width => 3,
                                                                             bitOffset => 16,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 2
                                                                             },
    "BB_bk_corr_settings.bk_in_backoff"                                   => {
                                                                             type => "field",
                                                                             addr => 0x101d8,
                                                                             width => 8,
                                                                             bitOffset => 8,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0xba
                                                                             },
    "BB_bk_corr_settings.bk_in_min_backoff"                               => {
                                                                             type => "field",
                                                                             addr => 0x101d8,
                                                                             width => 8,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0xa6
                                                                             },
    "BB_cck_blocker_det2"                                                 => {
                                                                             type => "reg",
                                                                             addr => 0x101e0,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_cck_blocker_det2.disable_m1ok_11b"                                => {
                                                                             type => "field",
                                                                             addr => 0x101e0,
                                                                             width => 1,
                                                                             bitOffset => 12,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0x0
                                                                             },
    "BB_cck_blocker_det2.cckpdp_valid_thr"                                => {
                                                                             type => "field",
                                                                             addr => 0x101e0,
                                                                             width => 3,
                                                                             bitOffset => 8,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0x0
                                                                             },
    "BB_cck_blocker_det2.firpwr_str"                                      => {
                                                                             type => "field",
                                                                             addr => 0x101e0,
                                                                             width => 8,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0xa6
                                                                             },
    "BB_detection_mask_cntl"                                              => {
                                                                             type => "reg",
                                                                             addr => 0x101e4,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_detection_mask_cntl.rssi_comb_dm_apply"                           => {
                                                                             type => "field",
                                                                             addr => 0x101e4,
                                                                             width => 1,
                                                                             bitOffset => 7,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x1
                                                                             },
    "BB_detection_mask_cntl.flag_firpwr_dm_apply"                         => {
                                                                             type => "field",
                                                                             addr => 0x101e4,
                                                                             width => 1,
                                                                             bitOffset => 6,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x1
                                                                             },
    "BB_detection_mask_cntl.flag_relpwr_dm_apply"                         => {
                                                                             type => "field",
                                                                             addr => 0x101e4,
                                                                             width => 1,
                                                                             bitOffset => 5,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x1
                                                                             },
    "BB_detection_mask_cntl.m2flag_dm_apply"                              => {
                                                                             type => "field",
                                                                             addr => 0x101e4,
                                                                             width => 1,
                                                                             bitOffset => 4,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x1
                                                                             },
    "BB_detection_mask_cntl.in_range_dm_apply"                            => {
                                                                             type => "field",
                                                                             addr => 0x101e4,
                                                                             width => 1,
                                                                             bitOffset => 3,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_detection_mask_cntl.gain_dropped_dm_apply"                        => {
                                                                             type => "field",
                                                                             addr => 0x101e4,
                                                                             width => 1,
                                                                             bitOffset => 2,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_detection_mask_cntl.rfsat_dm_apply"                               => {
                                                                             type => "field",
                                                                             addr => 0x101e4,
                                                                             width => 1,
                                                                             bitOffset => 1,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_detection_mask_cntl.adcsat_dm_apply"                              => {
                                                                             type => "field",
                                                                             addr => 0x101e4,
                                                                             width => 1,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_rx_ocgain"                                                        => {
                                                                             type => "reg",
                                                                             addr => 0x10200,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             depth => 128,
                                                                             incr => 4
                                                                             },
    "BB_rx_ocgain.gain_entry"                                             => {
                                                                             type => "field",
                                                                             addr => 0x10200,
                                                                             width => 32,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
###################################################################
## bb_reg_map.bb_chn_reg_map Register/Field definitions
###################################################################
    "BB_timing_controls_1"                                                => {
                                                                             type => "reg",
                                                                             addr => 0x10400,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_timing_controls_1.fft_scaling"                                    => {
                                                                             type => "field",
                                                                             addr => 0x10400,
                                                                             width => 1,
                                                                             bitOffset => 31,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_timing_controls_1.coarse_ppm_select"                              => {
                                                                             type => "field",
                                                                             addr => 0x10400,
                                                                             width => 2,
                                                                             bitOffset => 29,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_timing_controls_1.timing_leak_enable"                             => {
                                                                             type => "field",
                                                                             addr => 0x10400,
                                                                             width => 1,
                                                                             bitOffset => 28,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_timing_controls_1.enable_long_rescale"                            => {
                                                                             type => "field",
                                                                             addr => 0x10400,
                                                                             width => 1,
                                                                             bitOffset => 27,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_timing_controls_1.false_alarm"                                    => {
                                                                             type => "field",
                                                                             addr => 0x10400,
                                                                             width => 2,
                                                                             bitOffset => 25,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_timing_controls_1.enable_channel_filter"                          => {
                                                                             type => "field",
                                                                             addr => 0x10400,
                                                                             width => 1,
                                                                             bitOffset => 24,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_timing_controls_1.enable_rx_stbc"                                 => {
                                                                             type => "field",
                                                                             addr => 0x10400,
                                                                             width => 1,
                                                                             bitOffset => 23,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_timing_controls_1.enable_long_chanfil"                            => {
                                                                             type => "field",
                                                                             addr => 0x10400,
                                                                             width => 1,
                                                                             bitOffset => 22,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_timing_controls_1.ht_fine_ppm_qam"                                => {
                                                                             type => "field",
                                                                             addr => 0x10400,
                                                                             width => 2,
                                                                             bitOffset => 20,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_timing_controls_1.ht_fine_ppm_stream"                             => {
                                                                             type => "field",
                                                                             addr => 0x10400,
                                                                             width => 2,
                                                                             bitOffset => 18,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_timing_controls_1.ste_to_long1"                                   => {
                                                                             type => "field",
                                                                             addr => 0x10400,
                                                                             width => 6,
                                                                             bitOffset => 7,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_timing_controls_1.ste_thr"                                        => {
                                                                             type => "field",
                                                                             addr => 0x10400,
                                                                             width => 7,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_timing_controls_2"                                                => {
                                                                             type => "reg",
                                                                             addr => 0x10404,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_timing_controls_2.enable_ht_fine_timing"                          => {
                                                                             type => "field",
                                                                             addr => 0x10404,
                                                                             width => 1,
                                                                             bitOffset => 31,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_timing_controls_2.traceback128"                                   => {
                                                                             type => "field",
                                                                             addr => 0x10404,
                                                                             width => 1,
                                                                             bitOffset => 30,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_timing_controls_2.enable_weighting"                               => {
                                                                             type => "field",
                                                                             addr => 0x10404,
                                                                             width => 1,
                                                                             bitOffset => 29,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_timing_controls_2.enable_dc_offset_track"                         => {
                                                                             type => "field",
                                                                             addr => 0x10404,
                                                                             width => 1,
                                                                             bitOffset => 28,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_timing_controls_2.enable_dc_offset"                               => {
                                                                             type => "field",
                                                                             addr => 0x10404,
                                                                             width => 1,
                                                                             bitOffset => 27,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_timing_controls_2.dc_off_tim_const"                               => {
                                                                             type => "field",
                                                                             addr => 0x10404,
                                                                             width => 3,
                                                                             bitOffset => 24,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_timing_controls_2.enable_pilot_interpolation"                     => {
                                                                             type => "field",
                                                                             addr => 0x10404,
                                                                             width => 1,
                                                                             bitOffset => 23,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_timing_controls_2.dc_off_deltaf_thres"                            => {
                                                                             type => "field",
                                                                             addr => 0x10404,
                                                                             width => 7,
                                                                             bitOffset => 16,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 20
                                                                             },
    "BB_timing_controls_2.enable_offset_filter"                           => {
                                                                             type => "field",
                                                                             addr => 0x10404,
                                                                             width => 1,
                                                                             bitOffset => 15,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_timing_controls_2.enable_magnitude_track_mimo"                    => {
                                                                             type => "field",
                                                                             addr => 0x10404,
                                                                             width => 1,
                                                                             bitOffset => 14,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_timing_controls_2.enable_magnitude_track"                         => {
                                                                             type => "field",
                                                                             addr => 0x10404,
                                                                             width => 1,
                                                                             bitOffset => 13,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_timing_controls_2.force_delta_phi_symbol"                         => {
                                                                             type => "field",
                                                                             addr => 0x10404,
                                                                             width => 1,
                                                                             bitOffset => 12,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_timing_controls_2.forced_delta_phi_symbol"                        => {
                                                                             type => "field",
                                                                             addr => 0x10404,
                                                                             width => 12,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_timing_controls_3"                                                => {
                                                                             type => "reg",
                                                                             addr => 0x10408,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_timing_controls_3.delta_slope_coef_man"                           => {
                                                                             type => "field",
                                                                             addr => 0x10408,
                                                                             width => 15,
                                                                             bitOffset => 17,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_timing_controls_3.delta_slope_coef_exp"                           => {
                                                                             type => "field",
                                                                             addr => 0x10408,
                                                                             width => 4,
                                                                             bitOffset => 13,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_timing_controls_3.enable_df_chanest"                              => {
                                                                             type => "field",
                                                                             addr => 0x10408,
                                                                             width => 1,
                                                                             bitOffset => 12,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_timing_controls_3.continuous_ppm_rescue"                          => {
                                                                             type => "field",
                                                                             addr => 0x10408,
                                                                             width => 1,
                                                                             bitOffset => 11,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 1
                                                                             },
    "BB_timing_controls_3.enable_fine_interp"                             => {
                                                                             type => "field",
                                                                             addr => 0x10408,
                                                                             width => 1,
                                                                             bitOffset => 10,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_timing_controls_3.enable_fine_ppm"                                => {
                                                                             type => "field",
                                                                             addr => 0x10408,
                                                                             width => 1,
                                                                             bitOffset => 9,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_timing_controls_3.enable_ppm_rescue"                              => {
                                                                             type => "field",
                                                                             addr => 0x10408,
                                                                             width => 1,
                                                                             bitOffset => 8,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_timing_controls_3.ppm_rescue_interval"                            => {
                                                                             type => "field",
                                                                             addr => 0x10408,
                                                                             width => 8,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_timing_control_4"                                                 => {
                                                                             type => "reg",
                                                                             addr => 0x1040c,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_timing_control_4.enable_spur_rssi"                                => {
                                                                             type => "field",
                                                                             addr => 0x1040c,
                                                                             width => 1,
                                                                             bitOffset => 31,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_timing_control_4.enable_chan_mask"                                => {
                                                                             type => "field",
                                                                             addr => 0x1040c,
                                                                             width => 1,
                                                                             bitOffset => 29,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_timing_control_4.enable_pilot_mask"                               => {
                                                                             type => "field",
                                                                             addr => 0x1040c,
                                                                             width => 1,
                                                                             bitOffset => 28,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_timing_control_4.early_trigger_thr"                               => {
                                                                             type => "field",
                                                                             addr => 0x1040c,
                                                                             width => 7,
                                                                             bitOffset => 21,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_timing_control_4.use_pilot_track_df"                              => {
                                                                             type => "field",
                                                                             addr => 0x1040c,
                                                                             width => 4,
                                                                             bitOffset => 17,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0xe
                                                                             },
    "BB_timing_control_4.do_gain_dc_iq_cal"                               => {
                                                                             type => "field",
                                                                             addr => 0x1040c,
                                                                             width => 1,
                                                                             bitOffset => 16,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_timing_control_4.cal_lg_count_max"                                => {
                                                                             type => "field",
                                                                             addr => 0x1040c,
                                                                             width => 4,
                                                                             bitOffset => 12,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_timing_control_4.use_data_as_pilot_df"                            => {
                                                                             type => "field",
                                                                             addr => 0x1040c,
                                                                             width => 1,
                                                                             bitOffset => 11,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_timing_control_4.enable_magnitude_track_11n_mimo"                 => {
                                                                             type => "field",
                                                                             addr => 0x1040c,
                                                                             width => 1,
                                                                             bitOffset => 1,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_timing_control_4.enable_ht_fine_ppm"                              => {
                                                                             type => "field",
                                                                             addr => 0x1040c,
                                                                             width => 1,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 1
                                                                             },
    "BB_timing_control_5"                                                 => {
                                                                             type => "reg",
                                                                             addr => 0x10410,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_timing_control_5.long_sc_thresh_hi_rssi"                          => {
                                                                             type => "field",
                                                                             addr => 0x10410,
                                                                             width => 7,
                                                                             bitOffset => 23,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 64
                                                                             },
    "BB_timing_control_5.rssi_thr1a"                                      => {
                                                                             type => "field",
                                                                             addr => 0x10410,
                                                                             width => 7,
                                                                             bitOffset => 16,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_timing_control_5.enable_rssi_thr1a"                               => {
                                                                             type => "field",
                                                                             addr => 0x10410,
                                                                             width => 1,
                                                                             bitOffset => 15,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_timing_control_5.cycpwr_thr1"                                     => {
                                                                             type => "field",
                                                                             addr => 0x10410,
                                                                             width => 7,
                                                                             bitOffset => 1,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_timing_control_5.enable_cycpwr_thr1"                              => {
                                                                             type => "field",
                                                                             addr => 0x10410,
                                                                             width => 1,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_timing_control_6"                                                 => {
                                                                             type => "reg",
                                                                             addr => 0x10414,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_timing_control_6.add_back_ofdm_dc_cck_bw40"                       => {
                                                                             type => "field",
                                                                             addr => 0x10414,
                                                                             width => 1,
                                                                             bitOffset => 29,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0x0
                                                                             },
    "BB_timing_control_6.add_back_ofdm_dc_cck_bw20"                       => {
                                                                             type => "field",
                                                                             addr => 0x10414,
                                                                             width => 1,
                                                                             bitOffset => 28,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0x0
                                                                             },
    "BB_timing_control_6.ofdm_xcorr_thresh_hi_rssi"                       => {
                                                                             type => "field",
                                                                             addr => 0x10414,
                                                                             width => 7,
                                                                             bitOffset => 21,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_timing_control_6.ofdm_xcorr_thresh"                               => {
                                                                             type => "field",
                                                                             addr => 0x10414,
                                                                             width => 6,
                                                                             bitOffset => 15,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_timing_control_6.early_trigger_thr_hi_rssi"                       => {
                                                                             type => "field",
                                                                             addr => 0x10414,
                                                                             width => 7,
                                                                             bitOffset => 8,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_timing_control_6.hi_rssi_thresh"                                  => {
                                                                             type => "field",
                                                                             addr => 0x10414,
                                                                             width => 8,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 10
                                                                             },
    "BB_timing_control_11"                                                => {
                                                                             type => "reg",
                                                                             addr => 0x10418,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_timing_control_11.use_spur_filter_in_selfcor"                     => {
                                                                             type => "field",
                                                                             addr => 0x10418,
                                                                             width => 1,
                                                                             bitOffset => 31,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_timing_control_11.use_spur_filter_in_agc"                         => {
                                                                             type => "field",
                                                                             addr => 0x10418,
                                                                             width => 1,
                                                                             bitOffset => 30,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_timing_control_11.spur_freq_sd"                                   => {
                                                                             type => "field",
                                                                             addr => 0x10418,
                                                                             width => 10,
                                                                             bitOffset => 20,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_spur_mask_controls"                                               => {
                                                                             type => "reg",
                                                                             addr => 0x1041c,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_spur_mask_controls.enable_nf_rssi_spur_mit"                       => {
                                                                             type => "field",
                                                                             addr => 0x1041c,
                                                                             width => 1,
                                                                             bitOffset => 26,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_spur_mask_controls.mask_rate_cntl"                                => {
                                                                             type => "field",
                                                                             addr => 0x1041c,
                                                                             width => 8,
                                                                             bitOffset => 18,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_spur_mask_controls.enable_mask_ppm"                               => {
                                                                             type => "field",
                                                                             addr => 0x1041c,
                                                                             width => 1,
                                                                             bitOffset => 17,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_spur_mask_controls.en_vit_spur_rssi"                              => {
                                                                             type => "field",
                                                                             addr => 0x1041c,
                                                                             width => 1,
                                                                             bitOffset => 8,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_spur_mask_controls.spur_rssi_thresh"                              => {
                                                                             type => "field",
                                                                             addr => 0x1041c,
                                                                             width => 8,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_find_signal_low"                                                  => {
                                                                             type => "reg",
                                                                             addr => 0x10420,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_find_signal_low.long_sc_thresh"                                   => {
                                                                             type => "field",
                                                                             addr => 0x10420,
                                                                             width => 7,
                                                                             bitOffset => 24,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 24
                                                                             },
    "BB_find_signal_low.ycok_max_low"                                     => {
                                                                             type => "field",
                                                                             addr => 0x10420,
                                                                             width => 4,
                                                                             bitOffset => 20,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_find_signal_low.firpwr_low"                                       => {
                                                                             type => "field",
                                                                             addr => 0x10420,
                                                                             width => 8,
                                                                             bitOffset => 12,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_find_signal_low.firstep_low"                                      => {
                                                                             type => "field",
                                                                             addr => 0x10420,
                                                                             width => 6,
                                                                             bitOffset => 6,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_find_signal_low.relstep_low"                                      => {
                                                                             type => "field",
                                                                             addr => 0x10420,
                                                                             width => 6,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_sfcorr"                                                           => {
                                                                             type => "reg",
                                                                             addr => 0x10424,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_sfcorr.m2_thres"                                                  => {
                                                                             type => "field",
                                                                             addr => 0x10424,
                                                                             width => 7,
                                                                             bitOffset => 24,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_sfcorr.m1_thres"                                                  => {
                                                                             type => "field",
                                                                             addr => 0x10424,
                                                                             width => 7,
                                                                             bitOffset => 17,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_sfcorr.m2count_thr"                                               => {
                                                                             type => "field",
                                                                             addr => 0x10424,
                                                                             width => 5,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_self_corr_low"                                                    => {
                                                                             type => "reg",
                                                                             addr => 0x10428,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_self_corr_low.m2_thresh_low"                                      => {
                                                                             type => "field",
                                                                             addr => 0x10428,
                                                                             width => 7,
                                                                             bitOffset => 21,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_self_corr_low.m1_thresh_low"                                      => {
                                                                             type => "field",
                                                                             addr => 0x10428,
                                                                             width => 7,
                                                                             bitOffset => 14,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_self_corr_low.m2count_thr_low"                                    => {
                                                                             type => "field",
                                                                             addr => 0x10428,
                                                                             width => 6,
                                                                             bitOffset => 8,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_self_corr_low.m1count_max_low"                                    => {
                                                                             type => "field",
                                                                             addr => 0x10428,
                                                                             width => 7,
                                                                             bitOffset => 1,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_self_corr_low.use_self_corr_low"                                  => {
                                                                             type => "field",
                                                                             addr => 0x10428,
                                                                             width => 1,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_timing_control_13"                                                => {
                                                                             type => "reg",
                                                                             addr => 0x10430,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_timing_control_13.tb_rssi_th2"                                    => {
                                                                             type => "field",
                                                                             addr => 0x10430,
                                                                             width => 8,
                                                                             bitOffset => 23,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 26
                                                                             },
    "BB_timing_control_13.tb_rssi_th1"                                    => {
                                                                             type => "field",
                                                                             addr => 0x10430,
                                                                             width => 8,
                                                                             bitOffset => 15,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 16
                                                                             },
    "BB_timing_control_13.timing_backoff_high_rssi"                       => {
                                                                             type => "field",
                                                                             addr => 0x10430,
                                                                             width => 5,
                                                                             bitOffset => 10,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 1
                                                                             },
    "BB_timing_control_13.timing_backoff_mid_rssi"                        => {
                                                                             type => "field",
                                                                             addr => 0x10430,
                                                                             width => 5,
                                                                             bitOffset => 5,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 2
                                                                             },
    "BB_timing_control_13.timing_backoff_low_rssi"                        => {
                                                                             type => "field",
                                                                             addr => 0x10430,
                                                                             width => 5,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 4
                                                                             },
    "BB_radar_detection"                                                  => {
                                                                             type => "reg",
                                                                             addr => 0x10434,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_radar_detection.radar_firpwr_thresh"                              => {
                                                                             type => "field",
                                                                             addr => 0x10434,
                                                                             width => 7,
                                                                             bitOffset => 24,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_radar_detection.pulse_drop_thresh"                                => {
                                                                             type => "field",
                                                                             addr => 0x10434,
                                                                             width => 6,
                                                                             bitOffset => 18,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_radar_detection.pulse_height_thresh"                              => {
                                                                             type => "field",
                                                                             addr => 0x10434,
                                                                             width => 6,
                                                                             bitOffset => 12,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_radar_detection.pulse_rssi_thresh"                                => {
                                                                             type => "field",
                                                                             addr => 0x10434,
                                                                             width => 6,
                                                                             bitOffset => 6,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_radar_detection.fft_check_coarse_ena"                             => {
                                                                             type => "field",
                                                                             addr => 0x10434,
                                                                             width => 1,
                                                                             bitOffset => 5,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_radar_detection.dfs_restart_ena_sec"                              => {
                                                                             type => "field",
                                                                             addr => 0x10434,
                                                                             width => 1,
                                                                             bitOffset => 4,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_radar_detection.dfs_restart_ena_pri"                              => {
                                                                             type => "field",
                                                                             addr => 0x10434,
                                                                             width => 1,
                                                                             bitOffset => 3,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_radar_detection.dfs_sec80_enable"                                 => {
                                                                             type => "field",
                                                                             addr => 0x10434,
                                                                             width => 1,
                                                                             bitOffset => 2,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_radar_detection.dfs_pri80_enable"                                 => {
                                                                             type => "field",
                                                                             addr => 0x10434,
                                                                             width => 1,
                                                                             bitOffset => 1,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_radar_detection.pulse_detect_enable"                              => {
                                                                             type => "field",
                                                                             addr => 0x10434,
                                                                             width => 1,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_radar_detection_2"                                                => {
                                                                             type => "reg",
                                                                             addr => 0x10438,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_radar_detection_2.enable_pulse_drop_check"                        => {
                                                                             type => "field",
                                                                             addr => 0x10438,
                                                                             width => 1,
                                                                             bitOffset => 30,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_radar_detection_2.enable_pulse_relpwr_check"                      => {
                                                                             type => "field",
                                                                             addr => 0x10438,
                                                                             width => 1,
                                                                             bitOffset => 29,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_radar_detection_2.enable_pulse_relstep_check"                     => {
                                                                             type => "field",
                                                                             addr => 0x10438,
                                                                             width => 1,
                                                                             bitOffset => 28,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_radar_detection_2.enable_pulse_gc_count_check"                    => {
                                                                             type => "field",
                                                                             addr => 0x10438,
                                                                             width => 1,
                                                                             bitOffset => 27,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_radar_detection_2.pulse_relpwr_thresh"                            => {
                                                                             type => "field",
                                                                             addr => 0x10438,
                                                                             width => 5,
                                                                             bitOffset => 16,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_radar_detection_2.dfs_cont_80p80"                                 => {
                                                                             type => "field",
                                                                             addr => 0x10438,
                                                                             width => 1,
                                                                             bitOffset => 13,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_radar_detection_2.pulse_relstep_thresh"                           => {
                                                                             type => "field",
                                                                             addr => 0x10438,
                                                                             width => 5,
                                                                             bitOffset => 8,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_radar_detection_2.pulse_width_max"                                => {
                                                                             type => "field",
                                                                             addr => 0x10438,
                                                                             width => 8,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_extension_radar"                                                  => {
                                                                             type => "reg",
                                                                             addr => 0x1043c,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_extension_radar.radar_lb_dc_cap"                                  => {
                                                                             type => "field",
                                                                             addr => 0x1043c,
                                                                             width => 9,
                                                                             bitOffset => 23,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x1ff
                                                                             },
    "BB_extension_radar.radar_fft_datapath_sel"                           => {
                                                                             type => "field",
                                                                             addr => 0x1043c,
                                                                             width => 1,
                                                                             bitOffset => 22,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x1
                                                                             },
    "BB_extension_radar.lb_dc_cap_pulse_nb_mask"                          => {
                                                                             type => "field",
                                                                             addr => 0x1043c,
                                                                             width => 1,
                                                                             bitOffset => 21,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x1
                                                                             },
    "BB_extension_radar.lb_dc_cap_pulse_dc_mask"                          => {
                                                                             type => "field",
                                                                             addr => 0x1043c,
                                                                             width => 1,
                                                                             bitOffset => 20,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x1
                                                                             },
    "BB_extension_radar.radar_lb_dc_cap_fine"                             => {
                                                                             type => "field",
                                                                             addr => 0x1043c,
                                                                             width => 9,
                                                                             bitOffset => 8,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x1ff
                                                                             },
    "BB_extension_radar.radar_path_sel"                                   => {
                                                                             type => "field",
                                                                             addr => 0x1043c,
                                                                             width => 2,
                                                                             bitOffset => 6,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x1
                                                                             },
    "BB_extension_radar.restart_lgdfspwr_delta"                           => {
                                                                             type => "field",
                                                                             addr => 0x1043c,
                                                                             width => 6,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 15
                                                                             },
    "BB_ibf_ctrl"                                                         => {
                                                                             type => "reg",
                                                                             addr => 0x10440,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_ibf_ctrl.chn_phase_align"                                         => {
                                                                             type => "field",
                                                                             addr => 0x10440,
                                                                             width => 4,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_chn_spare_01"                                                     => {
                                                                             type => "reg",
                                                                             addr => 0x10450,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_chn_spare_01.chn_eco_ctrl"                                        => {
                                                                             type => "field",
                                                                             addr => 0x10450,
                                                                             width => 32,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_timing_controls_2a"                                               => {
                                                                             type => "reg",
                                                                             addr => 0x10454,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_timing_controls_2a.coarse_dc_delay"                               => {
                                                                             type => "field",
                                                                             addr => 0x10454,
                                                                             width => 5,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_rx_notch_cntl_2_pri_b0"                                           => {
                                                                             type => "reg",
                                                                             addr => 0x10458,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_rx_notch_cntl_2_pri_b0.notch_corr_spur1_q_pri_b0"                 => {
                                                                             type => "field",
                                                                             addr => 0x10458,
                                                                             width => 12,
                                                                             bitOffset => 16,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_rx_notch_cntl_2_pri_b0.notch_corr_spur1_i_pri_b0"                 => {
                                                                             type => "field",
                                                                             addr => 0x10458,
                                                                             width => 12,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x400
                                                                             },
    "BB_rx_notch_cntl_3_pri_b0"                                           => {
                                                                             type => "reg",
                                                                             addr => 0x1045c,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_rx_notch_cntl_3_pri_b0.notch_corr_spur2_q_pri_b0"                 => {
                                                                             type => "field",
                                                                             addr => 0x1045c,
                                                                             width => 12,
                                                                             bitOffset => 16,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_rx_notch_cntl_3_pri_b0.notch_corr_spur2_i_pri_b0"                 => {
                                                                             type => "field",
                                                                             addr => 0x1045c,
                                                                             width => 12,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x400
                                                                             },
    "BB_rx_notch_cntl_4_pri_b0"                                           => {
                                                                             type => "reg",
                                                                             addr => 0x10460,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_rx_notch_cntl_4_pri_b0.notch_corr_dc_q_pri_b0"                    => {
                                                                             type => "field",
                                                                             addr => 0x10460,
                                                                             width => 12,
                                                                             bitOffset => 16,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_rx_notch_cntl_4_pri_b0.notch_corr_dc_i_pri_b0"                    => {
                                                                             type => "field",
                                                                             addr => 0x10460,
                                                                             width => 12,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x400
                                                                             },
    "BB_rx_notch_cntl_5_pri_b0"                                           => {
                                                                             type => "reg",
                                                                             addr => 0x10464,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_rx_notch_cntl_5_pri_b0.notch_corr_agg_i_pri_b0"                   => {
                                                                             type => "field",
                                                                             addr => 0x10464,
                                                                             width => 12,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x400
                                                                             },
    "BB_rx_notch_cntl_2_ext_b0"                                           => {
                                                                             type => "reg",
                                                                             addr => 0x10468,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_rx_notch_cntl_2_ext_b0.notch_corr_spur1_q_ext_b0"                 => {
                                                                             type => "field",
                                                                             addr => 0x10468,
                                                                             width => 12,
                                                                             bitOffset => 16,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_rx_notch_cntl_2_ext_b0.notch_corr_spur1_i_ext_b0"                 => {
                                                                             type => "field",
                                                                             addr => 0x10468,
                                                                             width => 12,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x400
                                                                             },
    "BB_rx_notch_cntl_3_ext_b0"                                           => {
                                                                             type => "reg",
                                                                             addr => 0x1046c,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_rx_notch_cntl_3_ext_b0.notch_corr_spur2_q_ext_b0"                 => {
                                                                             type => "field",
                                                                             addr => 0x1046c,
                                                                             width => 12,
                                                                             bitOffset => 16,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_rx_notch_cntl_3_ext_b0.notch_corr_spur2_i_ext_b0"                 => {
                                                                             type => "field",
                                                                             addr => 0x1046c,
                                                                             width => 12,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x400
                                                                             },
    "BB_rx_notch_cntl_4_ext_b0"                                           => {
                                                                             type => "reg",
                                                                             addr => 0x10470,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_rx_notch_cntl_4_ext_b0.notch_corr_dc_q_ext_b0"                    => {
                                                                             type => "field",
                                                                             addr => 0x10470,
                                                                             width => 12,
                                                                             bitOffset => 16,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_rx_notch_cntl_4_ext_b0.notch_corr_dc_i_ext_b0"                    => {
                                                                             type => "field",
                                                                             addr => 0x10470,
                                                                             width => 12,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x400
                                                                             },
    "BB_rx_notch_cntl_5_ext_b0"                                           => {
                                                                             type => "reg",
                                                                             addr => 0x10474,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_rx_notch_cntl_5_ext_b0.notch_corr_agg_i_ext_b0"                   => {
                                                                             type => "field",
                                                                             addr => 0x10474,
                                                                             width => 12,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x400
                                                                             },
    "BB_multichain_control"                                               => {
                                                                             type => "reg",
                                                                             addr => 0x10480,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_multichain_control.enable_dyn_deweight"                           => {
                                                                             type => "field",
                                                                             addr => 0x10480,
                                                                             width => 1,
                                                                             bitOffset => 31,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_multichain_control.enable_static_deweight"                        => {
                                                                             type => "field",
                                                                             addr => 0x10480,
                                                                             width => 1,
                                                                             bitOffset => 30,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_multichain_control.force_sigma_zero"                              => {
                                                                             type => "field",
                                                                             addr => 0x10480,
                                                                             width => 1,
                                                                             bitOffset => 29,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_multichain_control.forced_gain_diff_02"                           => {
                                                                             type => "field",
                                                                             addr => 0x10480,
                                                                             width => 7,
                                                                             bitOffset => 22,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_multichain_control.cf_short_sat"                                  => {
                                                                             type => "field",
                                                                             addr => 0x10480,
                                                                             width => 11,
                                                                             bitOffset => 10,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_multichain_control.use_posedge_refclk"                            => {
                                                                             type => "field",
                                                                             addr => 0x10480,
                                                                             width => 1,
                                                                             bitOffset => 9,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_multichain_control.sync_synthon"                                  => {
                                                                             type => "field",
                                                                             addr => 0x10480,
                                                                             width => 1,
                                                                             bitOffset => 8,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_multichain_control.forced_gain_diff_01"                           => {
                                                                             type => "field",
                                                                             addr => 0x10480,
                                                                             width => 7,
                                                                             bitOffset => 1,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_multichain_control.force_analog_gain_diff"                        => {
                                                                             type => "field",
                                                                             addr => 0x10480,
                                                                             width => 1,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_per_chain_ht_csd"                                                 => {
                                                                             type => "reg",
                                                                             addr => 0x10484,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_per_chain_ht_csd.ht_csd_chn3_4chains"                             => {
                                                                             type => "field",
                                                                             addr => 0x10484,
                                                                             width => 5,
                                                                             bitOffset => 25,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 6
                                                                             },
    "BB_per_chain_ht_csd.ht_csd_chn2_4chains"                             => {
                                                                             type => "field",
                                                                             addr => 0x10484,
                                                                             width => 5,
                                                                             bitOffset => 20,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 4
                                                                             },
    "BB_per_chain_ht_csd.ht_csd_chn1_4chains"                             => {
                                                                             type => "field",
                                                                             addr => 0x10484,
                                                                             width => 5,
                                                                             bitOffset => 15,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 2
                                                                             },
    "BB_per_chain_ht_csd.ht_csd_chn2_3chains"                             => {
                                                                             type => "field",
                                                                             addr => 0x10484,
                                                                             width => 5,
                                                                             bitOffset => 10,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 4
                                                                             },
    "BB_per_chain_ht_csd.ht_csd_chn1_3chains"                             => {
                                                                             type => "field",
                                                                             addr => 0x10484,
                                                                             width => 5,
                                                                             bitOffset => 5,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 2
                                                                             },
    "BB_per_chain_ht_csd.ht_csd_chn1_2chains"                             => {
                                                                             type => "field",
                                                                             addr => 0x10484,
                                                                             width => 5,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 2
                                                                             },
    "BB_pre_emphasis_bw20_b0"                                             => {
                                                                             type => "reg",
                                                                             addr => 0x10488,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_pre_emphasis_bw20_b0.pre_emp_db_neg_bw20_0"                       => {
                                                                             type => "field",
                                                                             addr => 0x10488,
                                                                             width => 15,
                                                                             bitOffset => 15,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_pre_emphasis_bw20_b0.pre_emp_db_pos_bw20_0"                       => {
                                                                             type => "field",
                                                                             addr => 0x10488,
                                                                             width => 15,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_pre_emphasis_bw40_b0"                                             => {
                                                                             type => "reg",
                                                                             addr => 0x1048c,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_pre_emphasis_bw40_b0.pre_emp_db_neg_bw40_0"                       => {
                                                                             type => "field",
                                                                             addr => 0x1048c,
                                                                             width => 15,
                                                                             bitOffset => 15,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_pre_emphasis_bw40_b0.pre_emp_db_pos_bw40_0"                       => {
                                                                             type => "field",
                                                                             addr => 0x1048c,
                                                                             width => 15,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_pre_emphasis_bw80_b0"                                             => {
                                                                             type => "reg",
                                                                             addr => 0x10490,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_pre_emphasis_bw80_b0.pre_emp_db_neg_bw80_0"                       => {
                                                                             type => "field",
                                                                             addr => 0x10490,
                                                                             width => 15,
                                                                             bitOffset => 15,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_pre_emphasis_bw80_b0.pre_emp_db_pos_bw80_0"                       => {
                                                                             type => "field",
                                                                             addr => 0x10490,
                                                                             width => 15,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_chn_tables_intf_addr"                                             => {
                                                                             type => "reg",
                                                                             addr => 0x10494,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_chn_tables_intf_addr.chn_addr_auto_incr"                          => {
                                                                             type => "field",
                                                                             addr => 0x10494,
                                                                             width => 1,
                                                                             bitOffset => 31,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0,
                                                                             athPortalAttr => "chn_table_map.autoIncr"
                                                                             },
    "BB_chn_tables_intf_addr.chn_tables_addr"                             => {
                                                                             type => "field",
                                                                             addr => 0x10494,
                                                                             width => 16,
                                                                             bitOffset => 2,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0,
                                                                             athPortalAttr => "chn_table_map.addr"
                                                                             },
    "BB_chn_tables_intf_data"                                             => {
                                                                             type => "reg",
                                                                             addr => 0x10498,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_chn_tables_intf_data.chn_tables_data"                             => {
                                                                             type => "field",
                                                                             addr => 0x10498,
                                                                             width => 32,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0,
                                                                             athPortalAttr => "chn_table_map.data"
                                                                             },
    "BB_phydbg_control1"                                                  => {
                                                                             type => "reg",
                                                                             addr => 0x1049c,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_phydbg_control1.phydbg_cap_chn_sel"                               => {
                                                                             type => "field",
                                                                             addr => 0x1049c,
                                                                             width => 2,
                                                                             bitOffset => 30,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_phydbg_control1.phydbg_plybck_count"                              => {
                                                                             type => "field",
                                                                             addr => 0x1049c,
                                                                             width => 14,
                                                                             bitOffset => 16,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_phydbg_control1.phydbg_cap_trig_mode"                             => {
                                                                             type => "field",
                                                                             addr => 0x1049c,
                                                                             width => 1,
                                                                             bitOffset => 15,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_phydbg_control1.phydbg_plybck_trig_mode"                          => {
                                                                             type => "field",
                                                                             addr => 0x1049c,
                                                                             width => 1,
                                                                             bitOffset => 14,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_phydbg_control1.phydbg_cap_pre_store"                             => {
                                                                             type => "field",
                                                                             addr => 0x1049c,
                                                                             width => 14,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_phydbg_control2"                                                  => {
                                                                             type => "reg",
                                                                             addr => 0x104a0,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_phydbg_control2.phydbg_cap_en"                                    => {
                                                                             type => "field",
                                                                             addr => 0x104a0,
                                                                             width => 1,
                                                                             bitOffset => 31,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_phydbg_control2.phydbg_cap_trig_addr"                             => {
                                                                             type => "field",
                                                                             addr => 0x104a0,
                                                                             width => 15,
                                                                             bitOffset => 16,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0x0
                                                                             },
    "BB_phydbg_control2.phydbg_cap_trig_select"                           => {
                                                                             type => "field",
                                                                             addr => 0x104a0,
                                                                             width => 5,
                                                                             bitOffset => 11,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_phydbg_control2.phydbg_fsmstate"                                  => {
                                                                             type => "field",
                                                                             addr => 0x104a0,
                                                                             width => 4,
                                                                             bitOffset => 7,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_phydbg_control2.phydbg_apb_autoincr"                              => {
                                                                             type => "field",
                                                                             addr => 0x104a0,
                                                                             width => 2,
                                                                             bitOffset => 5,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_phydbg_control2.phydbg_plybck_en"                                 => {
                                                                             type => "field",
                                                                             addr => 0x104a0,
                                                                             width => 1,
                                                                             bitOffset => 4,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_phydbg_control2.phydbg_mode"                                      => {
                                                                             type => "field",
                                                                             addr => 0x104a0,
                                                                             width => 4,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0xf
                                                                             },
    "BB_tstdac_constant"                                                  => {
                                                                             type => "reg",
                                                                             addr => 0x104a4,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_tstdac_constant.cf_tstdac_constant_q"                             => {
                                                                             type => "field",
                                                                             addr => 0x104a4,
                                                                             width => 11,
                                                                             bitOffset => 11,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_tstdac_constant.cf_tstdac_constant_i"                             => {
                                                                             type => "field",
                                                                             addr => 0x104a4,
                                                                             width => 11,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_spur_report_b0"                                                   => {
                                                                             type => "reg",
                                                                             addr => 0x104a8,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO"
                                                                             },
    "BB_spur_report_b0.power_with_spur_removed_0"                         => {
                                                                             type => "field",
                                                                             addr => 0x104a8,
                                                                             width => 16,
                                                                             bitOffset => 16,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0
                                                                             },
    "BB_spur_report_b0.spur_est_q_0"                                      => {
                                                                             type => "field",
                                                                             addr => 0x104a8,
                                                                             width => 8,
                                                                             bitOffset => 8,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0
                                                                             },
    "BB_spur_report_b0.spur_est_i_0"                                      => {
                                                                             type => "field",
                                                                             addr => 0x104a8,
                                                                             width => 8,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0
                                                                             },
    "BB_green_tx_control_1"                                               => {
                                                                             type => "reg",
                                                                             addr => 0x104bc,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_green_tx_control_1.green_cases"                                   => {
                                                                             type => "field",
                                                                             addr => 0x104bc,
                                                                             width => 1,
                                                                             bitOffset => 1,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x1
                                                                             },
    "BB_green_tx_control_1.green_tx_enable"                               => {
                                                                             type => "field",
                                                                             addr => 0x104bc,
                                                                             width => 1,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_iq_adc_meas_0_b0"                                                 => {
                                                                             type => "reg",
                                                                             addr => 0x104c0,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO"
                                                                             },
    "BB_iq_adc_meas_0_b0.gain_dc_iq_cal_meas_0_0"                         => {
                                                                             type => "field",
                                                                             addr => 0x104c0,
                                                                             width => 32,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0
                                                                             },
    "BB_iq_adc_meas_1_b0"                                                 => {
                                                                             type => "reg",
                                                                             addr => 0x104c4,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO"
                                                                             },
    "BB_iq_adc_meas_1_b0.gain_dc_iq_cal_meas_1_0"                         => {
                                                                             type => "field",
                                                                             addr => 0x104c4,
                                                                             width => 32,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0
                                                                             },
    "BB_iq_adc_meas_2_b0"                                                 => {
                                                                             type => "reg",
                                                                             addr => 0x104c8,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO"
                                                                             },
    "BB_iq_adc_meas_2_b0.gain_dc_iq_cal_meas_2_0"                         => {
                                                                             type => "field",
                                                                             addr => 0x104c8,
                                                                             width => 32,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0
                                                                             },
    "BB_iq_adc_meas_3_b0"                                                 => {
                                                                             type => "reg",
                                                                             addr => 0x104cc,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO"
                                                                             },
    "BB_iq_adc_meas_3_b0.gain_dc_iq_cal_meas_3_0"                         => {
                                                                             type => "field",
                                                                             addr => 0x104cc,
                                                                             width => 32,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0
                                                                             },
    "BB_tx_phase_ramp_b0"                                                 => {
                                                                             type => "reg",
                                                                             addr => 0x104d0,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_tx_phase_ramp_b0.cf_phase_ramp_alpha_0"                           => {
                                                                             type => "field",
                                                                             addr => 0x104d0,
                                                                             width => 8,
                                                                             bitOffset => 17,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_tx_phase_ramp_b0.cf_phase_ramp_init_0"                            => {
                                                                             type => "field",
                                                                             addr => 0x104d0,
                                                                             width => 10,
                                                                             bitOffset => 7,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_tx_phase_ramp_b0.cf_phase_ramp_bias_0"                            => {
                                                                             type => "field",
                                                                             addr => 0x104d0,
                                                                             width => 6,
                                                                             bitOffset => 1,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_tx_phase_ramp_b0.cf_phase_ramp_enable_0"                          => {
                                                                             type => "field",
                                                                             addr => 0x104d0,
                                                                             width => 1,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_adc_gain_corr_b0"                                                 => {
                                                                             type => "reg",
                                                                             addr => 0x104d4,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_adc_gain_corr_b0.adc_fixed_gain"                                  => {
                                                                             type => "field",
                                                                             addr => 0x104d4,
                                                                             width => 9,
                                                                             bitOffset => 20,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 256
                                                                             },
    "BB_adc_gain_corr_b0.enable_bw_mode_sel_for_tiadc_corr"               => {
                                                                             type => "field",
                                                                             addr => 0x104d4,
                                                                             width => 1,
                                                                             bitOffset => 19,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_adc_gain_corr_b0.adc_gain_corr_enable"                            => {
                                                                             type => "field",
                                                                             addr => 0x104d4,
                                                                             width => 1,
                                                                             bitOffset => 18,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_adc_gain_corr_b0.adc_gain_corr_i_coeff_0"                         => {
                                                                             type => "field",
                                                                             addr => 0x104d4,
                                                                             width => 9,
                                                                             bitOffset => 9,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 32
                                                                             },
    "BB_adc_gain_corr_b0.adc_gain_corr_q_coeff_0"                         => {
                                                                             type => "field",
                                                                             addr => 0x104d4,
                                                                             width => 9,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 32
                                                                             },
    "BB_adc_dc_corr_b0"                                                   => {
                                                                             type => "reg",
                                                                             addr => 0x104d8,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_adc_dc_corr_b0.adc_dc_corr_enable"                                => {
                                                                             type => "field",
                                                                             addr => 0x104d8,
                                                                             width => 1,
                                                                             bitOffset => 18,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_adc_dc_corr_b0.adc_dc_corr_i_coeff_0"                             => {
                                                                             type => "field",
                                                                             addr => 0x104d8,
                                                                             width => 9,
                                                                             bitOffset => 9,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_adc_dc_corr_b0.adc_dc_corr_q_coeff_0"                             => {
                                                                             type => "field",
                                                                             addr => 0x104d8,
                                                                             width => 9,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_rx_iq_corr_b0"                                                    => {
                                                                             type => "reg",
                                                                             addr => 0x104dc,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_rx_iq_corr_b0.rx_iqcorr_bypass_lb"                                => {
                                                                             type => "field",
                                                                             addr => 0x104dc,
                                                                             width => 1,
                                                                             bitOffset => 3,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_rx_iq_corr_b0.rx_iqc_use_onetap"                                  => {
                                                                             type => "field",
                                                                             addr => 0x104dc,
                                                                             width => 1,
                                                                             bitOffset => 2,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_rx_iq_corr_b0.rx_iqcorr_bypass_in_agc"                            => {
                                                                             type => "field",
                                                                             addr => 0x104dc,
                                                                             width => 1,
                                                                             bitOffset => 1,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_rx_iq_corr_b0.rx_iqcorr_enable"                                   => {
                                                                             type => "field",
                                                                             addr => 0x104dc,
                                                                             width => 1,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_rx_iq_corr_loopback_b0"                                           => {
                                                                             type => "reg",
                                                                             addr => 0x104e0,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_rx_iq_corr_loopback_b0.loopback_iqcorr_enable"                    => {
                                                                             type => "field",
                                                                             addr => 0x104e0,
                                                                             width => 1,
                                                                             bitOffset => 18,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_rx_iq_corr_loopback_b0.loopback_iqcorr_q_i_coff_0"                => {
                                                                             type => "field",
                                                                             addr => 0x104e0,
                                                                             width => 9,
                                                                             bitOffset => 9,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_rx_iq_corr_loopback_b0.loopback_iqcorr_q_q_coff_0"                => {
                                                                             type => "field",
                                                                             addr => 0x104e0,
                                                                             width => 9,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_paprd_am2am_mask"                                                 => {
                                                                             type => "reg",
                                                                             addr => 0x104e4,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_paprd_am2am_mask.paprd_am2am_mask"                                => {
                                                                             type => "field",
                                                                             addr => 0x104e4,
                                                                             width => 31,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_paprd_am2pm_mask"                                                 => {
                                                                             type => "reg",
                                                                             addr => 0x104e8,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_paprd_am2pm_mask.paprd_am2pm_mask"                                => {
                                                                             type => "field",
                                                                             addr => 0x104e8,
                                                                             width => 31,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_paprd_ht40_mask"                                                  => {
                                                                             type => "reg",
                                                                             addr => 0x104ec,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_paprd_ht40_mask.paprd_ht40_mask"                                  => {
                                                                             type => "field",
                                                                             addr => 0x104ec,
                                                                             width => 31,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_paprd_ctrl0_b0"                                                   => {
                                                                             type => "reg",
                                                                             addr => 0x104f0,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_paprd_ctrl0_b0.paprd_valid_gain_5_0_0"                            => {
                                                                             type => "field",
                                                                             addr => 0x104f0,
                                                                             width => 30,
                                                                             bitOffset => 2,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_paprd_ctrl0_b0.paprd_reg_chain_indexed"                           => {
                                                                             type => "field",
                                                                             addr => 0x104f0,
                                                                             width => 1,
                                                                             bitOffset => 1,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x1
                                                                             },
    "BB_paprd_ctrl0_b0.paprd_enable_0"                                    => {
                                                                             type => "field",
                                                                             addr => 0x104f0,
                                                                             width => 1,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_paprd_ctrl1_b0"                                                   => {
                                                                             type => "reg",
                                                                             addr => 0x104f4,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_paprd_ctrl1_b0.paprd_trainer_iandq_sel_0"                         => {
                                                                             type => "field",
                                                                             addr => 0x104f4,
                                                                             width => 1,
                                                                             bitOffset => 29,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_paprd_ctrl1_b0.paprd_target_pwr_min_0"                            => {
                                                                             type => "field",
                                                                             addr => 0x104f4,
                                                                             width => 6,
                                                                             bitOffset => 8,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_paprd_ctrl1_b0.paprd_target_pwr_max_0"                            => {
                                                                             type => "field",
                                                                             addr => 0x104f4,
                                                                             width => 6,
                                                                             bitOffset => 2,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_paprd_ctrl1_b0.paprd_adaptive_am2pm_enable_0"                     => {
                                                                             type => "field",
                                                                             addr => 0x104f4,
                                                                             width => 1,
                                                                             bitOffset => 1,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_paprd_ctrl1_b0.paprd_adaptive_am2am_enable_0"                     => {
                                                                             type => "field",
                                                                             addr => 0x104f4,
                                                                             width => 1,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_paprd_ctrl2_b0"                                                   => {
                                                                             type => "reg",
                                                                             addr => 0x104f8,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_paprd_ctrl2_b0.paprd_mag_thrsh_0"                                 => {
                                                                             type => "field",
                                                                             addr => 0x104f8,
                                                                             width => 5,
                                                                             bitOffset => 27,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_paprd_ctrl2_b0.paprd_table_rfbmode_0"                             => {
                                                                             type => "field",
                                                                             addr => 0x104f8,
                                                                             width => 3,
                                                                             bitOffset => 24,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_paprd_ctrl2_b0.paprd_adaptive_table_valid_0"                      => {
                                                                             type => "field",
                                                                             addr => 0x104f8,
                                                                             width => 6,
                                                                             bitOffset => 18,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_paprd_ctrl2_b0.paprd_valid_pa_setting_0"                          => {
                                                                             type => "field",
                                                                             addr => 0x104f8,
                                                                             width => 18,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_paprd_vht80_mask"                                                 => {
                                                                             type => "reg",
                                                                             addr => 0x104fc,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_paprd_vht80_mask.paprd_vht80_mask"                                => {
                                                                             type => "field",
                                                                             addr => 0x104fc,
                                                                             width => 31,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_phydbg_mem_addr"                                                  => {
                                                                             type => "reg",
                                                                             addr => 0x10500,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_phydbg_mem_addr.phydbg_mem_addr"                                  => {
                                                                             type => "field",
                                                                             addr => 0x10500,
                                                                             width => 15,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_phydbg_mem_data"                                                  => {
                                                                             type => "reg",
                                                                             addr => 0x10504,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_phydbg_mem_data.phydbg_mem_data"                                  => {
                                                                             type => "field",
                                                                             addr => 0x10504,
                                                                             width => 32,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => "NL"
                                                                             },
    "BB_btcf_config"                                                      => {
                                                                             type => "reg",
                                                                             addr => 0x10508,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_btcf_config.btcf_finetim_corr_en"                                 => {
                                                                             type => "field",
                                                                             addr => 0x10508,
                                                                             width => 1,
                                                                             bitOffset => 31,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x1
                                                                             },
    "BB_btcf_config.btcf_en"                                              => {
                                                                             type => "field",
                                                                             addr => 0x10508,
                                                                             width => 1,
                                                                             bitOffset => 30,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x1
                                                                             },
    "BB_btcf_config.btcf_lgfirpwr_ideal"                                  => {
                                                                             type => "field",
                                                                             addr => 0x10508,
                                                                             width => 12,
                                                                             bitOffset => 18,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0xE8B
                                                                             },
    "BB_btcf_config.btcf_det_dshift"                                      => {
                                                                             type => "field",
                                                                             addr => 0x10508,
                                                                             width => 3,
                                                                             bitOffset => 15,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 1
                                                                             },
    "BB_btcf_config.btcf_det_ratio"                                       => {
                                                                             type => "field",
                                                                             addr => 0x10508,
                                                                             width => 3,
                                                                             bitOffset => 12,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_btcf_config.fft_toffset256"                                       => {
                                                                             type => "field",
                                                                             addr => 0x10508,
                                                                             width => 4,
                                                                             bitOffset => 8,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0xe
                                                                             },
    "BB_btcf_config.fft_toffset128"                                       => {
                                                                             type => "field",
                                                                             addr => 0x10508,
                                                                             width => 4,
                                                                             bitOffset => 4,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0xd
                                                                             },
    "BB_btcf_config.fft_toffset64"                                        => {
                                                                             type => "field",
                                                                             addr => 0x10508,
                                                                             width => 4,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0xd
                                                                             },
    "BB_btcf_th_config"                                                   => {
                                                                             type => "reg",
                                                                             addr => 0x1050c,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_btcf_th_config.btcf_low_snr_branch"                               => {
                                                                             type => "field",
                                                                             addr => 0x1050c,
                                                                             width => 1,
                                                                             bitOffset => 24,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_btcf_th_config.btcf_snr_th_db"                                    => {
                                                                             type => "field",
                                                                             addr => 0x1050c,
                                                                             width => 8,
                                                                             bitOffset => 16,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 15
                                                                             },
    "BB_btcf_th_config.btcf_th2"                                          => {
                                                                             type => "field",
                                                                             addr => 0x1050c,
                                                                             width => 8,
                                                                             bitOffset => 8,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 34
                                                                             },
    "BB_btcf_th_config.btcf_th1"                                          => {
                                                                             type => "field",
                                                                             addr => 0x1050c,
                                                                             width => 8,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 36
                                                                             },
    "BB_btcf_dcn_config"                                                  => {
                                                                             type => "reg",
                                                                             addr => 0x10510,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_btcf_dcn_config.dcn_bypass"                                       => {
                                                                             type => "field",
                                                                             addr => 0x10510,
                                                                             width => 1,
                                                                             bitOffset => 31,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_btcf_dcn_config.dcn_alpha_sel"                                    => {
                                                                             type => "field",
                                                                             addr => 0x10510,
                                                                             width => 1,
                                                                             bitOffset => 30,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_btcf_dcn_config.btcf_agc_dly"                                     => {
                                                                             type => "field",
                                                                             addr => 0x10510,
                                                                             width => 9,
                                                                             bitOffset => 18,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 320
                                                                             },
    "BB_btcf_dcn_config.dcn_alpha2"                                       => {
                                                                             type => "field",
                                                                             addr => 0x10510,
                                                                             width => 9,
                                                                             bitOffset => 9,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 300
                                                                             },
    "BB_btcf_dcn_config.dcn_alpha1"                                       => {
                                                                             type => "field",
                                                                             addr => 0x10510,
                                                                             width => 9,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 300
                                                                             },
    "BB_btcf_tim_cpature"                                                 => {
                                                                             type => "reg",
                                                                             addr => 0x10514,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO"
                                                                             },
    "BB_btcf_tim_cpature.btcf_cap_skip_btcf"                              => {
                                                                             type => "field",
                                                                             addr => 0x10514,
                                                                             width => 8,
                                                                             bitOffset => 18,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0
                                                                             },
    "BB_btcf_tim_cpature.btcf_cap_skip"                                   => {
                                                                             type => "field",
                                                                             addr => 0x10514,
                                                                             width => 8,
                                                                             bitOffset => 10,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0
                                                                             },
    "BB_btcf_tim_cpature.btcf_cap_coarse_sb"                              => {
                                                                             type => "field",
                                                                             addr => 0x10514,
                                                                             width => 10,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0
                                                                             },
    "BB_btcf_idx_cpature"                                                 => {
                                                                             type => "reg",
                                                                             addr => 0x10518,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO"
                                                                             },
    "BB_btcf_idx_cpature.btcf_cap_picked_idx"                             => {
                                                                             type => "field",
                                                                             addr => 0x10518,
                                                                             width => 3,
                                                                             bitOffset => 3,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0
                                                                             },
    "BB_btcf_idx_cpature.btcf_cap_min_idx"                                => {
                                                                             type => "field",
                                                                             addr => 0x10518,
                                                                             width => 3,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0
                                                                             },
    "BB_btcf_fftstartstore"                                               => {
                                                                             type => "reg",
                                                                             addr => 0x1051c,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_btcf_fftstartstore.btcf_freeze"                                   => {
                                                                             type => "field",
                                                                             addr => 0x1051c,
                                                                             width => 1,
                                                                             bitOffset => 20,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_btcf_fftstartstore.btcf_br2_fftstart"                             => {
                                                                             type => "field",
                                                                             addr => 0x1051c,
                                                                             width => 10,
                                                                             bitOffset => 10,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0
                                                                             },
    "BB_btcf_fftstartstore.btcf_br1_fftstart"                             => {
                                                                             type => "field",
                                                                             addr => 0x1051c,
                                                                             width => 10,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0
                                                                             },
    "BB_btcf_pwr_atmin_169"                                               => {
                                                                             type => "reg",
                                                                             addr => 0x10528,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO"
                                                                             },
    "BB_btcf_pwr_atmin_169.btcf_pwr_atmin_d169_value"                     => {
                                                                             type => "field",
                                                                             addr => 0x10528,
                                                                             width => 16,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0
                                                                             },
    "BB_bcf_offscnt_atmin_169"                                            => {
                                                                             type => "reg",
                                                                             addr => 0x1052c,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_bcf_offscnt_atmin_169.btcf_delta_neg_lim"                         => {
                                                                             type => "field",
                                                                             addr => 0x1052c,
                                                                             width => 9,
                                                                             bitOffset => 17,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x1F9
                                                                             },
    "BB_bcf_offscnt_atmin_169.btcf_delta_pos_lim"                         => {
                                                                             type => "field",
                                                                             addr => 0x1052c,
                                                                             width => 9,
                                                                             bitOffset => 8,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 31
                                                                             },
    "BB_bcf_offscnt_atmin_169.btcf_offscnt_atmin_d169_value"              => {
                                                                             type => "field",
                                                                             addr => 0x1052c,
                                                                             width => 8,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0
                                                                             },
    "BB_btcf_abort_cnt"                                                   => {
                                                                             type => "reg",
                                                                             addr => 0x10530,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RCLR"
                                                                             },
    "BB_btcf_abort_cnt.btcf_abort_count"                                  => {
                                                                             type => "field",
                                                                             addr => 0x10530,
                                                                             width => 16,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RCLR",
                                                                             resetVal => 0
                                                                             },
    "BB_bcf_minstore_br1"                                                 => {
                                                                             type => "reg",
                                                                             addr => 0x10538,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_bcf_minstore_br1.btcf_br1_value"                                  => {
                                                                             type => "field",
                                                                             addr => 0x10538,
                                                                             width => 21,
                                                                             bitOffset => 8,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0x1FFFFF
                                                                             },
    "BB_bcf_minstore_br1.btcf_br1_postminindx"                            => {
                                                                             type => "field",
                                                                             addr => 0x10538,
                                                                             width => 5,
                                                                             bitOffset => 3,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_bcf_minstore_br1.btcf_br1_id"                                     => {
                                                                             type => "field",
                                                                             addr => 0x10538,
                                                                             width => 3,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_bcf_minstore_br2"                                                 => {
                                                                             type => "reg",
                                                                             addr => 0x1053c,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_bcf_minstore_br2.btcf_br2_value"                                  => {
                                                                             type => "field",
                                                                             addr => 0x1053c,
                                                                             width => 21,
                                                                             bitOffset => 8,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0x1FFFFF
                                                                             },
    "BB_bcf_minstore_br2.btcf_br2_postminindx"                            => {
                                                                             type => "field",
                                                                             addr => 0x1053c,
                                                                             width => 5,
                                                                             bitOffset => 3,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_bcf_minstore_br2.btcf_br2_id"                                     => {
                                                                             type => "field",
                                                                             addr => 0x1053c,
                                                                             width => 3,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_tx_overlap_window"                                                => {
                                                                             type => "reg",
                                                                             addr => 0x10540,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_tx_overlap_window.overlap_window_bw80MHz"                         => {
                                                                             type => "field",
                                                                             addr => 0x10540,
                                                                             width => 4,
                                                                             bitOffset => 8,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_tx_overlap_window.overlap_window_bw40MHz"                         => {
                                                                             type => "field",
                                                                             addr => 0x10540,
                                                                             width => 4,
                                                                             bitOffset => 4,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_tx_overlap_window.overlap_window_bw20MHz"                         => {
                                                                             type => "field",
                                                                             addr => 0x10540,
                                                                             width => 4,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_per_chain_legacy_csd"                                             => {
                                                                             type => "reg",
                                                                             addr => 0x10544,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_per_chain_legacy_csd.leg_csd_chn3_4chains"                        => {
                                                                             type => "field",
                                                                             addr => 0x10544,
                                                                             width => 5,
                                                                             bitOffset => 25,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 6
                                                                             },
    "BB_per_chain_legacy_csd.leg_csd_chn2_4chains"                        => {
                                                                             type => "field",
                                                                             addr => 0x10544,
                                                                             width => 5,
                                                                             bitOffset => 20,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 4
                                                                             },
    "BB_per_chain_legacy_csd.leg_csd_chn1_4chains"                        => {
                                                                             type => "field",
                                                                             addr => 0x10544,
                                                                             width => 5,
                                                                             bitOffset => 15,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 2
                                                                             },
    "BB_per_chain_legacy_csd.leg_csd_chn2_3chains"                        => {
                                                                             type => "field",
                                                                             addr => 0x10544,
                                                                             width => 5,
                                                                             bitOffset => 10,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 8
                                                                             },
    "BB_per_chain_legacy_csd.leg_csd_chn1_3chains"                        => {
                                                                             type => "field",
                                                                             addr => 0x10544,
                                                                             width => 5,
                                                                             bitOffset => 5,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 4
                                                                             },
    "BB_per_chain_legacy_csd.leg_csd_chn1_2chains"                        => {
                                                                             type => "field",
                                                                             addr => 0x10544,
                                                                             width => 5,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 8
                                                                             },
    "BB_fdtg_control0"                                                    => {
                                                                             type => "reg",
                                                                             addr => 0x10548,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_fdtg_control0.fdtg_suppress_preamble"                             => {
                                                                             type => "field",
                                                                             addr => 0x10548,
                                                                             width => 1,
                                                                             bitOffset => 17,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x1
                                                                             },
    "BB_fdtg_control0.fdtg_ss0_b_addr"                                    => {
                                                                             type => "field",
                                                                             addr => 0x10548,
                                                                             width => 8,
                                                                             bitOffset => 9,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_fdtg_control0.fdtg_ss0_a_addr"                                    => {
                                                                             type => "field",
                                                                             addr => 0x10548,
                                                                             width => 8,
                                                                             bitOffset => 1,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_fdtg_control0.fdtg_enable"                                        => {
                                                                             type => "field",
                                                                             addr => 0x10548,
                                                                             width => 1,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_fdtg_control1"                                                    => {
                                                                             type => "reg",
                                                                             addr => 0x1054c,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_fdtg_control1.fdtg_ss2_b_addr"                                    => {
                                                                             type => "field",
                                                                             addr => 0x1054c,
                                                                             width => 8,
                                                                             bitOffset => 24,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_fdtg_control1.fdtg_ss2_a_addr"                                    => {
                                                                             type => "field",
                                                                             addr => 0x1054c,
                                                                             width => 8,
                                                                             bitOffset => 16,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_fdtg_control1.fdtg_ss1_b_addr"                                    => {
                                                                             type => "field",
                                                                             addr => 0x1054c,
                                                                             width => 8,
                                                                             bitOffset => 8,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_fdtg_control1.fdtg_ss1_a_addr"                                    => {
                                                                             type => "field",
                                                                             addr => 0x1054c,
                                                                             width => 8,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_fdtg_ss0_data_b0"                                                 => {
                                                                             type => "reg",
                                                                             addr => 0x10550,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_fdtg_ss0_data_b0.fdtg_ss0_b_data_im_0"                            => {
                                                                             type => "field",
                                                                             addr => 0x10550,
                                                                             width => 8,
                                                                             bitOffset => 24,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_fdtg_ss0_data_b0.fdtg_ss0_b_data_re_0"                            => {
                                                                             type => "field",
                                                                             addr => 0x10550,
                                                                             width => 8,
                                                                             bitOffset => 16,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_fdtg_ss0_data_b0.fdtg_ss0_a_data_im_0"                            => {
                                                                             type => "field",
                                                                             addr => 0x10550,
                                                                             width => 8,
                                                                             bitOffset => 8,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_fdtg_ss0_data_b0.fdtg_ss0_a_data_re_0"                            => {
                                                                             type => "field",
                                                                             addr => 0x10550,
                                                                             width => 8,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_fdtg_ss1_data_b0"                                                 => {
                                                                             type => "reg",
                                                                             addr => 0x10554,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_fdtg_ss1_data_b0.fdtg_ss1_b_data_im_0"                            => {
                                                                             type => "field",
                                                                             addr => 0x10554,
                                                                             width => 8,
                                                                             bitOffset => 24,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_fdtg_ss1_data_b0.fdtg_ss1_b_data_re_0"                            => {
                                                                             type => "field",
                                                                             addr => 0x10554,
                                                                             width => 8,
                                                                             bitOffset => 16,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_fdtg_ss1_data_b0.fdtg_ss1_a_data_im_0"                            => {
                                                                             type => "field",
                                                                             addr => 0x10554,
                                                                             width => 8,
                                                                             bitOffset => 8,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_fdtg_ss1_data_b0.fdtg_ss1_a_data_re_0"                            => {
                                                                             type => "field",
                                                                             addr => 0x10554,
                                                                             width => 8,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_fdtg_ss2_data_b0"                                                 => {
                                                                             type => "reg",
                                                                             addr => 0x10558,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_fdtg_ss2_data_b0.fdtg_ss2_b_data_im_0"                            => {
                                                                             type => "field",
                                                                             addr => 0x10558,
                                                                             width => 8,
                                                                             bitOffset => 24,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_fdtg_ss2_data_b0.fdtg_ss2_b_data_re_0"                            => {
                                                                             type => "field",
                                                                             addr => 0x10558,
                                                                             width => 8,
                                                                             bitOffset => 16,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_fdtg_ss2_data_b0.fdtg_ss2_a_data_im_0"                            => {
                                                                             type => "field",
                                                                             addr => 0x10558,
                                                                             width => 8,
                                                                             bitOffset => 8,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_fdtg_ss2_data_b0.fdtg_ss2_a_data_re_0"                            => {
                                                                             type => "field",
                                                                             addr => 0x10558,
                                                                             width => 8,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_paprd_am2am_mask2"                                                => {
                                                                             type => "reg",
                                                                             addr => 0x1055c,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_paprd_am2am_mask2.paprd_am2am_mask2"                              => {
                                                                             type => "field",
                                                                             addr => 0x1055c,
                                                                             width => 10,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_paprd_am2pm_mask2"                                                => {
                                                                             type => "reg",
                                                                             addr => 0x10560,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_paprd_am2pm_mask2.paprd_am2pm_mask2"                              => {
                                                                             type => "field",
                                                                             addr => 0x10560,
                                                                             width => 10,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_paprd_ht40_mask2"                                                 => {
                                                                             type => "reg",
                                                                             addr => 0x10564,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_paprd_ht40_mask2.paprd_ht40_mask2"                                => {
                                                                             type => "field",
                                                                             addr => 0x10564,
                                                                             width => 10,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_paprd_vht80_mask2"                                                => {
                                                                             type => "reg",
                                                                             addr => 0x10568,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_paprd_vht80_mask2.paprd_vht80_mask2"                              => {
                                                                             type => "field",
                                                                             addr => 0x10568,
                                                                             width => 10,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_spur_ctrl1_pri_b0"                                                => {
                                                                             type => "reg",
                                                                             addr => 0x1056c,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_spur_ctrl1_pri_b0.enable_spur_filter_pri_b0"                      => {
                                                                             type => "field",
                                                                             addr => 0x1056c,
                                                                             width => 2,
                                                                             bitOffset => 30,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_spur_ctrl1_pri_b0.agc_ht_stf_spur_filter_ena_pri_b0"              => {
                                                                             type => "field",
                                                                             addr => 0x1056c,
                                                                             width => 1,
                                                                             bitOffset => 29,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x1
                                                                             },
    "BB_spur_ctrl1_pri_b0.spur_delta_phase_pri_b0"                        => {
                                                                             type => "field",
                                                                             addr => 0x1056c,
                                                                             width => 20,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_spur_ctrl2_pri_b0"                                                => {
                                                                             type => "reg",
                                                                             addr => 0x10570,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_spur_ctrl2_pri_b0.spur_delta_phase_2nd_pri_b0"                    => {
                                                                             type => "field",
                                                                             addr => 0x10570,
                                                                             width => 20,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_spur_ctrl1_ext_b0"                                                => {
                                                                             type => "reg",
                                                                             addr => 0x10574,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_spur_ctrl1_ext_b0.enable_spur_filter_ext_b0"                      => {
                                                                             type => "field",
                                                                             addr => 0x10574,
                                                                             width => 2,
                                                                             bitOffset => 30,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_spur_ctrl1_ext_b0.agc_ht_stf_spur_filter_ena_ext_b0"              => {
                                                                             type => "field",
                                                                             addr => 0x10574,
                                                                             width => 1,
                                                                             bitOffset => 29,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x1
                                                                             },
    "BB_spur_ctrl1_ext_b0.spur_delta_phase_ext_b0"                        => {
                                                                             type => "field",
                                                                             addr => 0x10574,
                                                                             width => 20,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_spur_ctrl2_ext_b0"                                                => {
                                                                             type => "reg",
                                                                             addr => 0x10578,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_spur_ctrl2_ext_b0.spur_delta_phase_2nd_ext_b0"                    => {
                                                                             type => "field",
                                                                             addr => 0x10578,
                                                                             width => 20,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_fdtg_ss3_data_b0"                                                 => {
                                                                             type => "reg",
                                                                             addr => 0x1057c,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_fdtg_ss3_data_b0.fdtg_ss3_b_data_im_0"                            => {
                                                                             type => "field",
                                                                             addr => 0x1057c,
                                                                             width => 8,
                                                                             bitOffset => 24,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_fdtg_ss3_data_b0.fdtg_ss3_b_data_re_0"                            => {
                                                                             type => "field",
                                                                             addr => 0x1057c,
                                                                             width => 8,
                                                                             bitOffset => 16,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_fdtg_ss3_data_b0.fdtg_ss3_a_data_im_0"                            => {
                                                                             type => "field",
                                                                             addr => 0x1057c,
                                                                             width => 8,
                                                                             bitOffset => 8,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_fdtg_ss3_data_b0.fdtg_ss3_a_data_re_0"                            => {
                                                                             type => "field",
                                                                             addr => 0x1057c,
                                                                             width => 8,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_fdtg_control2"                                                    => {
                                                                             type => "reg",
                                                                             addr => 0x10580,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_fdtg_control2.fdtg_ss3_b_addr"                                    => {
                                                                             type => "field",
                                                                             addr => 0x10580,
                                                                             width => 8,
                                                                             bitOffset => 8,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_fdtg_control2.fdtg_ss3_a_addr"                                    => {
                                                                             type => "field",
                                                                             addr => 0x10580,
                                                                             width => 8,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_pdc_a1_0_m0"                                                      => {
                                                                             type => "reg",
                                                                             addr => 0x10584,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_pdc_a1_0_m0.pdc_a1_0_m0"                                          => {
                                                                             type => "field",
                                                                             addr => 0x10584,
                                                                             width => 18,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0xabcd
                                                                             },
    "BB_pdc_b1_0_m0"                                                      => {
                                                                             type => "reg",
                                                                             addr => 0x10588,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_pdc_b1_0_m0.pdc_b1_0_m0"                                          => {
                                                                             type => "field",
                                                                             addr => 0x10588,
                                                                             width => 18,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0xabcd
                                                                             },
    "BB_pdc_b2_0_m0"                                                      => {
                                                                             type => "reg",
                                                                             addr => 0x1058c,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_pdc_b2_0_m0.pdc_b2_0_m0"                                          => {
                                                                             type => "field",
                                                                             addr => 0x1058c,
                                                                             width => 18,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0xabcd
                                                                             },
    "BB_pdc_a1_0_m1"                                                      => {
                                                                             type => "reg",
                                                                             addr => 0x10590,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_pdc_a1_0_m1.pdc_a1_0_m1"                                          => {
                                                                             type => "field",
                                                                             addr => 0x10590,
                                                                             width => 18,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0xabcd
                                                                             },
    "BB_pdc_b1_0_m1"                                                      => {
                                                                             type => "reg",
                                                                             addr => 0x10594,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_pdc_b1_0_m1.pdc_b1_0_m1"                                          => {
                                                                             type => "field",
                                                                             addr => 0x10594,
                                                                             width => 18,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0xabcd
                                                                             },
    "BB_pdc_b2_0_m1"                                                      => {
                                                                             type => "reg",
                                                                             addr => 0x10598,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_pdc_b2_0_m1.pdc_b2_0_m1"                                          => {
                                                                             type => "field",
                                                                             addr => 0x10598,
                                                                             width => 18,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0xabcd
                                                                             },
    "BB_pdc_a1_0_m2"                                                      => {
                                                                             type => "reg",
                                                                             addr => 0x1059c,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_pdc_a1_0_m2.pdc_a1_0_m2"                                          => {
                                                                             type => "field",
                                                                             addr => 0x1059c,
                                                                             width => 18,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0xabcd
                                                                             },
    "BB_pdc_b1_0_m2"                                                      => {
                                                                             type => "reg",
                                                                             addr => 0x105a0,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_pdc_b1_0_m2.pdc_b1_0_m2"                                          => {
                                                                             type => "field",
                                                                             addr => 0x105a0,
                                                                             width => 18,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0xabcd
                                                                             },
    "BB_pdc_b2_0_m2"                                                      => {
                                                                             type => "reg",
                                                                             addr => 0x105a4,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_pdc_b2_0_m2.pdc_b2_0_m2"                                          => {
                                                                             type => "field",
                                                                             addr => 0x105a4,
                                                                             width => 18,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0xabcd
                                                                             },
    "BB_pdc_step_p1_0"                                                    => {
                                                                             type => "reg",
                                                                             addr => 0x105a8,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_pdc_step_p1_0.pdc_step_p1_0"                                      => {
                                                                             type => "field",
                                                                             addr => 0x105a8,
                                                                             width => 32,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_pdc_step_p2_0"                                                    => {
                                                                             type => "reg",
                                                                             addr => 0x105ac,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_pdc_step_p2_0.pdc_step_p2_0"                                      => {
                                                                             type => "field",
                                                                             addr => 0x105ac,
                                                                             width => 32,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_pdc_gap_time_0"                                                   => {
                                                                             type => "reg",
                                                                             addr => 0x105b0,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO"
                                                                             },
    "BB_pdc_gap_time_0.pdc_gap_time_0"                                    => {
                                                                             type => "field",
                                                                             addr => 0x105b0,
                                                                             width => 32,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0x0
                                                                             },
    "BB_pdc_time_0"                                                       => {
                                                                             type => "reg",
                                                                             addr => 0x105b4,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO"
                                                                             },
    "BB_pdc_time_0.pdc_time_0"                                            => {
                                                                             type => "field",
                                                                             addr => 0x105b4,
                                                                             width => 32,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0x0
                                                                             },
    "BB_pdc_disable"                                                      => {
                                                                             type => "reg",
                                                                             addr => 0x105b8,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_pdc_disable.pdc_disable"                                          => {
                                                                             type => "field",
                                                                             addr => 0x105b8,
                                                                             width => 1,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x1
                                                                             },
    "BB_pdc_num_p1_max"                                                   => {
                                                                             type => "reg",
                                                                             addr => 0x105bc,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_pdc_num_p1_max.pdc_num_p1_max"                                    => {
                                                                             type => "field",
                                                                             addr => 0x105bc,
                                                                             width => 8,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_pdc_num_p2_max"                                                   => {
                                                                             type => "reg",
                                                                             addr => 0x105c0,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_pdc_num_p2_max.pdc_num_p2_max"                                    => {
                                                                             type => "field",
                                                                             addr => 0x105c0,
                                                                             width => 8,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_pdc_gap_th1"                                                      => {
                                                                             type => "reg",
                                                                             addr => 0x105c4,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_pdc_gap_th1.pdc_gap_th1"                                          => {
                                                                             type => "field",
                                                                             addr => 0x105c4,
                                                                             width => 32,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x00000
                                                                             },
    "BB_pdc_gap_th2"                                                      => {
                                                                             type => "reg",
                                                                             addr => 0x105c8,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_pdc_gap_th2.pdc_gap_th2"                                          => {
                                                                             type => "field",
                                                                             addr => 0x105c8,
                                                                             width => 32,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x00000
                                                                             },
    "BB_pdc_dly_tl"                                                       => {
                                                                             type => "reg",
                                                                             addr => 0x105cc,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_pdc_dly_tl.pdc_dly_tl"                                            => {
                                                                             type => "field",
                                                                             addr => 0x105cc,
                                                                             width => 32,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x00000
                                                                             },
    "BB_pdc_gap_tl"                                                       => {
                                                                             type => "reg",
                                                                             addr => 0x105d0,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_pdc_gap_tl.pdc_gap_tl"                                            => {
                                                                             type => "field",
                                                                             addr => 0x105d0,
                                                                             width => 32,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x00000
                                                                             },
    "BB_pdc_tl"                                                           => {
                                                                             type => "reg",
                                                                             addr => 0x105d4,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_pdc_tl.pdc_tl"                                                    => {
                                                                             type => "field",
                                                                             addr => 0x105d4,
                                                                             width => 32,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x00000
                                                                             },
    "BB_pdc_num_step_p1"                                                  => {
                                                                             type => "reg",
                                                                             addr => 0x105d8,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_pdc_num_step_p1.pdc_num_step_p1"                                  => {
                                                                             type => "field",
                                                                             addr => 0x105d8,
                                                                             width => 8,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x10
                                                                             },
###################################################################
## bb_reg_map.bb_sm_reg_map Register/Field definitions
###################################################################
    "BB_gen_controls"                                                     => {
                                                                             type => "reg",
                                                                             addr => 0x10604,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_gen_controls.enable_err_tpc_miss"                                 => {
                                                                             type => "field",
                                                                             addr => 0x10604,
                                                                             width => 1,
                                                                             bitOffset => 30,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_gen_controls.enable_err_tx_illegal_rate"                          => {
                                                                             type => "field",
                                                                             addr => 0x10604,
                                                                             width => 1,
                                                                             bitOffset => 29,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x1
                                                                             },
    "BB_gen_controls.enable_err_tx_bw_gt_dyn_bw"                          => {
                                                                             type => "field",
                                                                             addr => 0x10604,
                                                                             width => 1,
                                                                             bitOffset => 28,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x1
                                                                             },
    "BB_gen_controls.enable_err_lsig_length_check"                        => {
                                                                             type => "field",
                                                                             addr => 0x10604,
                                                                             width => 1,
                                                                             bitOffset => 27,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x1
                                                                             },
    "BB_gen_controls.enable_err_extra_sym_mismatch"                       => {
                                                                             type => "field",
                                                                             addr => 0x10604,
                                                                             width => 1,
                                                                             bitOffset => 26,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x1
                                                                             },
    "BB_gen_controls.enable_err_tx_chain_mask_zero"                       => {
                                                                             type => "field",
                                                                             addr => 0x10604,
                                                                             width => 1,
                                                                             bitOffset => 25,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x1
                                                                             },
    "BB_gen_controls.unsupp_ht_rate_threshold"                            => {
                                                                             type => "field",
                                                                             addr => 0x10604,
                                                                             width => 7,
                                                                             bitOffset => 18,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 76
                                                                             },
    "BB_gen_controls.chain0_upper_segment"                                => {
                                                                             type => "field",
                                                                             addr => 0x10604,
                                                                             width => 1,
                                                                             bitOffset => 17,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_gen_controls.static20_mode_ht40_packet_error_rpt"                 => {
                                                                             type => "field",
                                                                             addr => 0x10604,
                                                                             width => 1,
                                                                             bitOffset => 16,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_gen_controls.static20_mode_ht40_packet_handling"                  => {
                                                                             type => "field",
                                                                             addr => 0x10604,
                                                                             width => 1,
                                                                             bitOffset => 15,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_gen_controls.enable_adc_async_fifo"                               => {
                                                                             type => "field",
                                                                             addr => 0x10604,
                                                                             width => 1,
                                                                             bitOffset => 13,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x1
                                                                             },
    "BB_gen_controls.enable_dac_async_fifo"                               => {
                                                                             type => "field",
                                                                             addr => 0x10604,
                                                                             width => 1,
                                                                             bitOffset => 12,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x1
                                                                             },
    "BB_gen_controls.gf_enable"                                           => {
                                                                             type => "field",
                                                                             addr => 0x10604,
                                                                             width => 1,
                                                                             bitOffset => 11,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_gen_controls.apply_walsh_on_legacy"                               => {
                                                                             type => "field",
                                                                             addr => 0x10604,
                                                                             width => 1,
                                                                             bitOffset => 10,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x1
                                                                             },
    "BB_gen_controls.use_walsh_for_nsts_eq_ntx"                           => {
                                                                             type => "field",
                                                                             addr => 0x10604,
                                                                             width => 1,
                                                                             bitOffset => 9,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x1
                                                                             },
    "BB_gen_controls.allow_short_gi"                                      => {
                                                                             type => "field",
                                                                             addr => 0x10604,
                                                                             width => 1,
                                                                             bitOffset => 8,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x1
                                                                             },
    "BB_gen_controls.vht_enable"                                          => {
                                                                             type => "field",
                                                                             addr => 0x10604,
                                                                             width => 1,
                                                                             bitOffset => 7,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x1
                                                                             },
    "BB_gen_controls.dyn_non_contig"                                      => {
                                                                             type => "field",
                                                                             addr => 0x10604,
                                                                             width => 1,
                                                                             bitOffset => 6,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_gen_controls.dyn_chn_gap"                                         => {
                                                                             type => "field",
                                                                             addr => 0x10604,
                                                                             width => 1,
                                                                             bitOffset => 5,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_gen_controls.dyn_pri_chn"                                         => {
                                                                             type => "field",
                                                                             addr => 0x10604,
                                                                             width => 3,
                                                                             bitOffset => 2,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_gen_controls.dyn_bw"                                              => {
                                                                             type => "field",
                                                                             addr => 0x10604,
                                                                             width => 2,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_modes_select"                                                     => {
                                                                             type => "reg",
                                                                             addr => 0x10608,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_modes_select.pmi_fifo_threshold"                                  => {
                                                                             type => "field",
                                                                             addr => 0x10608,
                                                                             width => 5,
                                                                             bitOffset => 19,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 24
                                                                             },
    "BB_modes_select.en_err_crc_abort"                                    => {
                                                                             type => "field",
                                                                             addr => 0x10608,
                                                                             width => 1,
                                                                             bitOffset => 18,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x1
                                                                             },
    "BB_modes_select.en_err_vht_grp1to62"                                 => {
                                                                             type => "field",
                                                                             addr => 0x10608,
                                                                             width => 1,
                                                                             bitOffset => 17,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x1
                                                                             },
    "BB_modes_select.en_err_vht_rx_nsym_lt_zero"                          => {
                                                                             type => "field",
                                                                             addr => 0x10608,
                                                                             width => 1,
                                                                             bitOffset => 16,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x1
                                                                             },
    "BB_modes_select.en_err_vht_rx_ndp_or_zlf"                            => {
                                                                             type => "field",
                                                                             addr => 0x10608,
                                                                             width => 1,
                                                                             bitOffset => 15,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x1
                                                                             },
    "BB_modes_select.en_err_vht_lsig_len_invalid"                         => {
                                                                             type => "field",
                                                                             addr => 0x10608,
                                                                             width => 1,
                                                                             bitOffset => 14,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x1
                                                                             },
    "BB_modes_select.en_err_vht_rx_siga_unsup"                            => {
                                                                             type => "field",
                                                                             addr => 0x10608,
                                                                             width => 1,
                                                                             bitOffset => 13,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x1
                                                                             },
    "BB_modes_select.skip_rx_grp_id_63"                                   => {
                                                                             type => "field",
                                                                             addr => 0x10608,
                                                                             width => 1,
                                                                             bitOffset => 12,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_modes_select.skip_rx_grp_id_0"                                    => {
                                                                             type => "field",
                                                                             addr => 0x10608,
                                                                             width => 1,
                                                                             bitOffset => 11,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_modes_select.ovsamp_clk_mode"                                     => {
                                                                             type => "field",
                                                                             addr => 0x10608,
                                                                             width => 1,
                                                                             bitOffset => 10,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0x0
                                                                             },
    "BB_modes_select.disable_dyn_cck_det"                                 => {
                                                                             type => "field",
                                                                             addr => 0x10608,
                                                                             width => 1,
                                                                             bitOffset => 8,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_modes_select.mac_clk_mode"                                        => {
                                                                             type => "field",
                                                                             addr => 0x10608,
                                                                             width => 1,
                                                                             bitOffset => 7,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_modes_select.quarter_rate_mode"                                   => {
                                                                             type => "field",
                                                                             addr => 0x10608,
                                                                             width => 1,
                                                                             bitOffset => 6,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_modes_select.half_rate_mode"                                      => {
                                                                             type => "field",
                                                                             addr => 0x10608,
                                                                             width => 1,
                                                                             bitOffset => 5,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_modes_select.dyn_ofdm_cck_mode"                                   => {
                                                                             type => "field",
                                                                             addr => 0x10608,
                                                                             width => 1,
                                                                             bitOffset => 2,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_modes_select.cck_mode"                                            => {
                                                                             type => "field",
                                                                             addr => 0x10608,
                                                                             width => 1,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_active"                                                           => {
                                                                             type => "reg",
                                                                             addr => 0x1060c,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_active.cf_reset_core"                                             => {
                                                                             type => "field",
                                                                             addr => 0x1060c,
                                                                             width => 1,
                                                                             bitOffset => 1,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_active.cf_active"                                                 => {
                                                                             type => "field",
                                                                             addr => 0x1060c,
                                                                             width => 1,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_spare_01"                                                         => {
                                                                             type => "reg",
                                                                             addr => 0x10610,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_spare_01.sm_eco_ctrl"                                             => {
                                                                             type => "field",
                                                                             addr => 0x10610,
                                                                             width => 32,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_spectral_scan"                                                    => {
                                                                             type => "reg",
                                                                             addr => 0x10628,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_spectral_scan.spectral_scan_restart_ena"                          => {
                                                                             type => "field",
                                                                             addr => 0x10628,
                                                                             width => 1,
                                                                             bitOffset => 31,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x1
                                                                             },
    "BB_spectral_scan.spectral_scan_gc_ena"                               => {
                                                                             type => "field",
                                                                             addr => 0x10628,
                                                                             width => 1,
                                                                             bitOffset => 30,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x1
                                                                             },
    "BB_spectral_scan.spectral_scan_priority"                             => {
                                                                             type => "field",
                                                                             addr => 0x10628,
                                                                             width => 1,
                                                                             bitOffset => 29,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x1
                                                                             },
    "BB_spectral_scan.spectral_scan_count"                                => {
                                                                             type => "field",
                                                                             addr => 0x10628,
                                                                             width => 12,
                                                                             bitOffset => 16,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_spectral_scan.spectral_scan_period"                               => {
                                                                             type => "field",
                                                                             addr => 0x10628,
                                                                             width => 8,
                                                                             bitOffset => 8,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 35
                                                                             },
    "BB_spectral_scan.spectral_scan_fft_size"                             => {
                                                                             type => "field",
                                                                             addr => 0x10628,
                                                                             width => 4,
                                                                             bitOffset => 4,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 9
                                                                             },
    "BB_spectral_scan.sscan_path_sel"                                     => {
                                                                             type => "field",
                                                                             addr => 0x10628,
                                                                             width => 2,
                                                                             bitOffset => 2,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x2
                                                                             },
    "BB_spectral_scan.spectral_scan_active"                               => {
                                                                             type => "field",
                                                                             addr => 0x10628,
                                                                             width => 1,
                                                                             bitOffset => 1,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_spectral_scan.spectral_scan_ena"                                  => {
                                                                             type => "field",
                                                                             addr => 0x10628,
                                                                             width => 1,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_search_start_delay"                                               => {
                                                                             type => "reg",
                                                                             addr => 0x10630,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_search_start_delay.search_start_mask_sifs"                        => {
                                                                             type => "field",
                                                                             addr => 0x10630,
                                                                             width => 4,
                                                                             bitOffset => 28,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x1
                                                                             },
    "BB_search_start_delay.search_start_delay_sifs"                       => {
                                                                             type => "field",
                                                                             addr => 0x10630,
                                                                             width => 12,
                                                                             bitOffset => 16,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 240
                                                                             },
    "BB_search_start_delay.search_start_delay_rifs"                       => {
                                                                             type => "field",
                                                                             addr => 0x10630,
                                                                             width => 12,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 20
                                                                             },
    "BB_max_rx_length"                                                    => {
                                                                             type => "reg",
                                                                             addr => 0x10634,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_max_rx_length.max_ht_duration"                                    => {
                                                                             type => "field",
                                                                             addr => 0x10634,
                                                                             width => 2,
                                                                             bitOffset => 30,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 3
                                                                             },
    "BB_max_rx_length.max_ht_length"                                      => {
                                                                             type => "field",
                                                                             addr => 0x10634,
                                                                             width => 18,
                                                                             bitOffset => 12,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_max_rx_length.max_rx_length"                                      => {
                                                                             type => "field",
                                                                             addr => 0x10634,
                                                                             width => 12,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 4095
                                                                             },
    "BB_frame_control"                                                    => {
                                                                             type => "reg",
                                                                             addr => 0x10638,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_frame_control.en_err_rx_abort"                                    => {
                                                                             type => "field",
                                                                             addr => 0x10638,
                                                                             width => 1,
                                                                             bitOffset => 31,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_frame_control.en_err_tx_underrun"                                 => {
                                                                             type => "field",
                                                                             addr => 0x10638,
                                                                             width => 1,
                                                                             bitOffset => 30,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_frame_control.en_err_service"                                     => {
                                                                             type => "field",
                                                                             addr => 0x10638,
                                                                             width => 1,
                                                                             bitOffset => 29,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_frame_control.no_6mbps_service_err"                               => {
                                                                             type => "field",
                                                                             addr => 0x10638,
                                                                             width => 1,
                                                                             bitOffset => 28,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_frame_control.en_err_length_illegal"                              => {
                                                                             type => "field",
                                                                             addr => 0x10638,
                                                                             width => 1,
                                                                             bitOffset => 27,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_frame_control.en_err_rate_illegal"                                => {
                                                                             type => "field",
                                                                             addr => 0x10638,
                                                                             width => 1,
                                                                             bitOffset => 26,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_frame_control.en_err_signal_parity"                               => {
                                                                             type => "field",
                                                                             addr => 0x10638,
                                                                             width => 1,
                                                                             bitOffset => 25,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_frame_control.en_err_tim_timeout"                                 => {
                                                                             type => "field",
                                                                             addr => 0x10638,
                                                                             width => 1,
                                                                             bitOffset => 24,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_frame_control.en_err_tim_early_trig"                              => {
                                                                             type => "field",
                                                                             addr => 0x10638,
                                                                             width => 1,
                                                                             bitOffset => 23,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_frame_control.en_err_tim_long1"                                   => {
                                                                             type => "field",
                                                                             addr => 0x10638,
                                                                             width => 1,
                                                                             bitOffset => 22,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_frame_control.en_err_long_sc_thr"                                 => {
                                                                             type => "field",
                                                                             addr => 0x10638,
                                                                             width => 1,
                                                                             bitOffset => 21,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_frame_control.en_err_ofdm_xcorr"                                  => {
                                                                             type => "field",
                                                                             addr => 0x10638,
                                                                             width => 1,
                                                                             bitOffset => 20,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_frame_control.en_err_static20_mode_ht40_packet"                   => {
                                                                             type => "field",
                                                                             addr => 0x10638,
                                                                             width => 1,
                                                                             bitOffset => 19,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_frame_control.en_err_green_field"                                 => {
                                                                             type => "field",
                                                                             addr => 0x10638,
                                                                             width => 1,
                                                                             bitOffset => 18,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_frame_control.short_high_par_norm"                                => {
                                                                             type => "field",
                                                                             addr => 0x10638,
                                                                             width => 1,
                                                                             bitOffset => 17,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_frame_control.prepend_chan_info"                                  => {
                                                                             type => "field",
                                                                             addr => 0x10638,
                                                                             width => 1,
                                                                             bitOffset => 16,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_frame_control.tx_end_adjust"                                      => {
                                                                             type => "field",
                                                                             addr => 0x10638,
                                                                             width => 8,
                                                                             bitOffset => 8,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 16
                                                                             },
    "BB_frame_control.cf_tx_doublesamp_dac"                               => {
                                                                             type => "field",
                                                                             addr => 0x10638,
                                                                             width => 2,
                                                                             bitOffset => 6,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_frame_control.cf_tx_clip"                                         => {
                                                                             type => "field",
                                                                             addr => 0x10638,
                                                                             width => 3,
                                                                             bitOffset => 3,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x3
                                                                             },
    "BB_frame_control.cf_overlap_window"                                  => {
                                                                             type => "field",
                                                                             addr => 0x10638,
                                                                             width => 2,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_rfbus_request"                                                    => {
                                                                             type => "reg",
                                                                             addr => 0x1063c,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_rfbus_request.rfbus_request"                                      => {
                                                                             type => "field",
                                                                             addr => 0x1063c,
                                                                             width => 1,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_rfbus_grant"                                                      => {
                                                                             type => "reg",
                                                                             addr => 0x10640,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO"
                                                                             },
    "BB_rfbus_grant.bt_ant"                                               => {
                                                                             type => "field",
                                                                             addr => 0x10640,
                                                                             width => 1,
                                                                             bitOffset => 1,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0
                                                                             },
    "BB_rfbus_grant.rfbus_grant"                                          => {
                                                                             type => "field",
                                                                             addr => 0x10640,
                                                                             width => 1,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0
                                                                             },
    "BB_rifs"                                                             => {
                                                                             type => "reg",
                                                                             addr => 0x10644,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_rifs.disable_rx_mask_mac_wait"                                    => {
                                                                             type => "field",
                                                                             addr => 0x10644,
                                                                             width => 1,
                                                                             bitOffset => 27,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_rifs.enable_reset_tdomain"                                        => {
                                                                             type => "field",
                                                                             addr => 0x10644,
                                                                             width => 1,
                                                                             bitOffset => 26,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_rifs.rifs_eco_disable"                                            => {
                                                                             type => "field",
                                                                             addr => 0x10644,
                                                                             width => 24,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_pmi_debug_status"                                                 => {
                                                                             type => "reg",
                                                                             addr => 0x10648,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO"
                                                                             },
    "BB_pmi_debug_status.pmi_debug_status"                                => {
                                                                             type => "field",
                                                                             addr => 0x10648,
                                                                             width => 32,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0x000000ff
                                                                             },
    "BB_rx_clear_delay"                                                   => {
                                                                             type => "reg",
                                                                             addr => 0x10650,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_rx_clear_delay.ndp_timeout_fdomain_delay"                         => {
                                                                             type => "field",
                                                                             addr => 0x10650,
                                                                             width => 3,
                                                                             bitOffset => 10,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x4
                                                                             },
    "BB_rx_clear_delay.ofdm_rx_clear_delay"                               => {
                                                                             type => "field",
                                                                             addr => 0x10650,
                                                                             width => 10,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_analog_power_on_time"                                             => {
                                                                             type => "reg",
                                                                             addr => 0x10654,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_analog_power_on_time.active_to_receive"                           => {
                                                                             type => "field",
                                                                             addr => 0x10654,
                                                                             width => 14,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_tx_timing_1"                                                      => {
                                                                             type => "reg",
                                                                             addr => 0x10658,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_tx_timing_1.tx_frame_to_a2_tx_on"                                 => {
                                                                             type => "field",
                                                                             addr => 0x10658,
                                                                             width => 8,
                                                                             bitOffset => 24,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_tx_timing_1.tx_frame_to_dac_on"                                   => {
                                                                             type => "field",
                                                                             addr => 0x10658,
                                                                             width => 8,
                                                                             bitOffset => 16,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_tx_timing_1.tx_frame_to_a2_rx_off"                                => {
                                                                             type => "field",
                                                                             addr => 0x10658,
                                                                             width => 8,
                                                                             bitOffset => 8,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_tx_timing_1.tx_frame_to_adc_off"                                  => {
                                                                             type => "field",
                                                                             addr => 0x10658,
                                                                             width => 8,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_tx_timing_2"                                                      => {
                                                                             type => "reg",
                                                                             addr => 0x1065c,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_tx_timing_2.tx_end_to_a2_tx_off"                                  => {
                                                                             type => "field",
                                                                             addr => 0x1065c,
                                                                             width => 8,
                                                                             bitOffset => 24,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_tx_timing_2.tx_end_to_pa_off"                                     => {
                                                                             type => "field",
                                                                             addr => 0x1065c,
                                                                             width => 8,
                                                                             bitOffset => 16,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_tx_timing_2.tx_frame_to_pa_on"                                    => {
                                                                             type => "field",
                                                                             addr => 0x1065c,
                                                                             width => 8,
                                                                             bitOffset => 8,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_tx_timing_2.tx_frame_to_tx_d_start"                               => {
                                                                             type => "field",
                                                                             addr => 0x1065c,
                                                                             width => 8,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_tx_timing_3"                                                      => {
                                                                             type => "reg",
                                                                             addr => 0x10660,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_tx_timing_3.tx_end_to_adc_on"                                     => {
                                                                             type => "field",
                                                                             addr => 0x10660,
                                                                             width => 8,
                                                                             bitOffset => 24,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_tx_timing_3.tx_end_to_a2_rx_on"                                   => {
                                                                             type => "field",
                                                                             addr => 0x10660,
                                                                             width => 8,
                                                                             bitOffset => 16,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_tx_timing_3.tx_frame_to_therm_chain_on"                           => {
                                                                             type => "field",
                                                                             addr => 0x10660,
                                                                             width => 8,
                                                                             bitOffset => 8,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_tx_timing_3.tx_end_to_dac_off"                                    => {
                                                                             type => "field",
                                                                             addr => 0x10660,
                                                                             width => 8,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_xpa_timing_control"                                               => {
                                                                             type => "reg",
                                                                             addr => 0x10664,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_xpa_timing_control.tx_end_to_xpab_off"                            => {
                                                                             type => "field",
                                                                             addr => 0x10664,
                                                                             width => 8,
                                                                             bitOffset => 24,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_xpa_timing_control.tx_end_to_xpaa_off"                            => {
                                                                             type => "field",
                                                                             addr => 0x10664,
                                                                             width => 8,
                                                                             bitOffset => 16,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_xpa_timing_control.tx_frame_to_xpab_on"                           => {
                                                                             type => "field",
                                                                             addr => 0x10664,
                                                                             width => 8,
                                                                             bitOffset => 8,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_xpa_timing_control.tx_frame_to_xpaa_on"                           => {
                                                                             type => "field",
                                                                             addr => 0x10664,
                                                                             width => 8,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_warm_tx"                                                          => {
                                                                             type => "reg",
                                                                             addr => 0x10668,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_warm_tx.num_extra_lstf_samples"                                   => {
                                                                             type => "field",
                                                                             addr => 0x10668,
                                                                             width => 8,
                                                                             bitOffset => 1,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 128
                                                                             },
    "BB_warm_tx.enable_warm_tx"                                           => {
                                                                             type => "field",
                                                                             addr => 0x10668,
                                                                             width => 1,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_en_power_optim"                                                   => {
                                                                             type => "reg",
                                                                             addr => 0x1066c,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_en_power_optim.rssi_nap_thr"                                      => {
                                                                             type => "field",
                                                                             addr => 0x1066c,
                                                                             width => 8,
                                                                             bitOffset => 24,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_en_power_optim.enable_power_optim_paprd"                          => {
                                                                             type => "field",
                                                                             addr => 0x1066c,
                                                                             width => 1,
                                                                             bitOffset => 3,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_en_power_optim.enable_power_optim_sm"                             => {
                                                                             type => "field",
                                                                             addr => 0x1066c,
                                                                             width => 1,
                                                                             bitOffset => 2,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_en_power_optim.enable_power_optim_mrc"                            => {
                                                                             type => "field",
                                                                             addr => 0x1066c,
                                                                             width => 1,
                                                                             bitOffset => 1,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_en_power_optim.enable_power_optim_chn"                            => {
                                                                             type => "field",
                                                                             addr => 0x1066c,
                                                                             width => 1,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_misc_pa_control"                                                  => {
                                                                             type => "reg",
                                                                             addr => 0x10680,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_misc_pa_control.enable_xpab"                                      => {
                                                                             type => "field",
                                                                             addr => 0x10680,
                                                                             width => 1,
                                                                             bitOffset => 3,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_misc_pa_control.enable_xpaa"                                      => {
                                                                             type => "field",
                                                                             addr => 0x10680,
                                                                             width => 1,
                                                                             bitOffset => 2,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_misc_pa_control.xpab_active_high"                                 => {
                                                                             type => "field",
                                                                             addr => 0x10680,
                                                                             width => 1,
                                                                             bitOffset => 1,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x1
                                                                             },
    "BB_misc_pa_control.xpaa_active_high"                                 => {
                                                                             type => "field",
                                                                             addr => 0x10680,
                                                                             width => 1,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x1
                                                                             },
    "BB_switch_table_chn_b0"                                              => {
                                                                             type => "reg",
                                                                             addr => 0x10684,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_switch_table_chn_b0.enable_bt_override"                           => {
                                                                             type => "field",
                                                                             addr => 0x10684,
                                                                             width => 1,
                                                                             bitOffset => 31,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_switch_table_chn_b0.bt_in_tx_xlna_override"                       => {
                                                                             type => "field",
                                                                             addr => 0x10684,
                                                                             width => 1,
                                                                             bitOffset => 30,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x1
                                                                             },
    "BB_switch_table_chn_b0.switch_table_b_0"                             => {
                                                                             type => "field",
                                                                             addr => 0x10684,
                                                                             width => 2,
                                                                             bitOffset => 10,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_switch_table_chn_b0.switch_table_rx12_0"                          => {
                                                                             type => "field",
                                                                             addr => 0x10684,
                                                                             width => 2,
                                                                             bitOffset => 8,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_switch_table_chn_b0.switch_table_rx1_0"                           => {
                                                                             type => "field",
                                                                             addr => 0x10684,
                                                                             width => 2,
                                                                             bitOffset => 6,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_switch_table_chn_b0.switch_table_r_0"                             => {
                                                                             type => "field",
                                                                             addr => 0x10684,
                                                                             width => 2,
                                                                             bitOffset => 4,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_switch_table_chn_b0.switch_table_t_0"                             => {
                                                                             type => "field",
                                                                             addr => 0x10684,
                                                                             width => 2,
                                                                             bitOffset => 2,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_switch_table_chn_b0.switch_table_idle_0"                          => {
                                                                             type => "field",
                                                                             addr => 0x10684,
                                                                             width => 2,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_switch_table_com1"                                                => {
                                                                             type => "reg",
                                                                             addr => 0x10688,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_switch_table_com1.switch_table_com_tx_1chn"                       => {
                                                                             type => "field",
                                                                             addr => 0x10688,
                                                                             width => 4,
                                                                             bitOffset => 28,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_switch_table_com1.switch_table_com_idle_alt"                      => {
                                                                             type => "field",
                                                                             addr => 0x10688,
                                                                             width => 6,
                                                                             bitOffset => 22,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0xa
                                                                             },
    "BB_switch_table_com1.switch_table_com_b"                             => {
                                                                             type => "field",
                                                                             addr => 0x10688,
                                                                             width => 6,
                                                                             bitOffset => 16,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_switch_table_com1.switch_table_com_t2"                            => {
                                                                             type => "field",
                                                                             addr => 0x10688,
                                                                             width => 4,
                                                                             bitOffset => 12,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_switch_table_com1.switch_table_com_t1"                            => {
                                                                             type => "field",
                                                                             addr => 0x10688,
                                                                             width => 6,
                                                                             bitOffset => 6,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_switch_table_com1.switch_table_com_idle"                          => {
                                                                             type => "field",
                                                                             addr => 0x10688,
                                                                             width => 6,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_switch_table_com2"                                                => {
                                                                             type => "reg",
                                                                             addr => 0x1068c,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_switch_table_com2.switch_table_com_ra12"                          => {
                                                                             type => "field",
                                                                             addr => 0x1068c,
                                                                             width => 4,
                                                                             bitOffset => 18,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_switch_table_com2.switch_table_com_ra2l2"                         => {
                                                                             type => "field",
                                                                             addr => 0x1068c,
                                                                             width => 4,
                                                                             bitOffset => 14,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_switch_table_com2.switch_table_com_ra1l2"                         => {
                                                                             type => "field",
                                                                             addr => 0x1068c,
                                                                             width => 4,
                                                                             bitOffset => 10,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_switch_table_com2.switch_table_com_ra2l1"                         => {
                                                                             type => "field",
                                                                             addr => 0x1068c,
                                                                             width => 4,
                                                                             bitOffset => 6,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_switch_table_com2.switch_table_com_ra1l1"                         => {
                                                                             type => "field",
                                                                             addr => 0x1068c,
                                                                             width => 6,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_multichain_enable"                                                => {
                                                                             type => "reg",
                                                                             addr => 0x106a0,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_multichain_enable.disable_dyn_listen"                             => {
                                                                             type => "field",
                                                                             addr => 0x106a0,
                                                                             width => 2,
                                                                             bitOffset => 30,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_multichain_enable.cf_VHT160_pkswitch_use_pbd"                     => {
                                                                             type => "field",
                                                                             addr => 0x106a0,
                                                                             width => 1,
                                                                             bitOffset => 23,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_multichain_enable.cf_VHT160_mode_forced"                          => {
                                                                             type => "field",
                                                                             addr => 0x106a0,
                                                                             width => 2,
                                                                             bitOffset => 21,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_multichain_enable.cf_VHT160_mode_force"                           => {
                                                                             type => "field",
                                                                             addr => 0x106a0,
                                                                             width => 1,
                                                                             bitOffset => 20,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_multichain_enable.ack_response_timeout"                           => {
                                                                             type => "field",
                                                                             addr => 0x106a0,
                                                                             width => 12,
                                                                             bitOffset => 8,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x000
                                                                             },
    "BB_multichain_enable.dyn_listen_mask"                                => {
                                                                             type => "field",
                                                                             addr => 0x106a0,
                                                                             width => 4,
                                                                             bitOffset => 4,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_multichain_enable.rx_chain_mask"                                  => {
                                                                             type => "field",
                                                                             addr => 0x106a0,
                                                                             width => 4,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x1
                                                                             },
    "BB_rx_notch_cntl_0"                                                  => {
                                                                             type => "reg",
                                                                             addr => 0x106a4,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_rx_notch_cntl_0.htstf_end_dc_notch_count"                         => {
                                                                             type => "field",
                                                                             addr => 0x106a4,
                                                                             width => 11,
                                                                             bitOffset => 16,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 150
                                                                             },
    "BB_rx_notch_cntl_0.enable_dc_notch_filter_htstf"                     => {
                                                                             type => "field",
                                                                             addr => 0x106a4,
                                                                             width => 1,
                                                                             bitOffset => 6,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x1
                                                                             },
    "BB_rx_notch_cntl_0.enable_dc_notch_filter_ofdm"                      => {
                                                                             type => "field",
                                                                             addr => 0x106a4,
                                                                             width => 1,
                                                                             bitOffset => 5,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x1
                                                                             },
    "BB_rx_notch_cntl_0.enable_dc_notch_filter_11b"                       => {
                                                                             type => "field",
                                                                             addr => 0x106a4,
                                                                             width => 1,
                                                                             bitOffset => 4,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_rx_notch_cntl_0.enable_dc_notch_filter_detect"                    => {
                                                                             type => "field",
                                                                             addr => 0x106a4,
                                                                             width => 1,
                                                                             bitOffset => 3,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x1
                                                                             },
    "BB_rx_notch_cntl_0.enable_dc_notch_fd_ht_only"                       => {
                                                                             type => "field",
                                                                             addr => 0x106a4,
                                                                             width => 1,
                                                                             bitOffset => 2,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_rx_notch_cntl_0.enable_dc_notch_fd"                               => {
                                                                             type => "field",
                                                                             addr => 0x106a4,
                                                                             width => 1,
                                                                             bitOffset => 1,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_rx_notch_cntl_0.enable_dc_notch_filter"                           => {
                                                                             type => "field",
                                                                             addr => 0x106a4,
                                                                             width => 1,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_rx_notch_cntl_1"                                                  => {
                                                                             type => "reg",
                                                                             addr => 0x106a8,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_rx_notch_cntl_1.spur_gain_thr_ena"                                => {
                                                                             type => "field",
                                                                             addr => 0x106a8,
                                                                             width => 1,
                                                                             bitOffset => 28,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_rx_notch_cntl_1.spur_gain_thr"                                    => {
                                                                             type => "field",
                                                                             addr => 0x106a8,
                                                                             width => 10,
                                                                             bitOffset => 16,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x200
                                                                             },
    "BB_rx_notch_cntl_1.alpha_dc"                                         => {
                                                                             type => "field",
                                                                             addr => 0x106a8,
                                                                             width => 3,
                                                                             bitOffset => 8,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 4
                                                                             },
    "BB_rx_notch_cntl_1.alpha_spur2"                                      => {
                                                                             type => "field",
                                                                             addr => 0x106a8,
                                                                             width => 3,
                                                                             bitOffset => 4,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 4
                                                                             },
    "BB_rx_notch_cntl_1.alpha_spur1"                                      => {
                                                                             type => "field",
                                                                             addr => 0x106a8,
                                                                             width => 3,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 4
                                                                             },
    "BB_vht160mode_debug"                                                 => {
                                                                             type => "reg",
                                                                             addr => 0x106bc,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_vht160mode_debug.cf_force_rxtimed_switchtime"                     => {
                                                                             type => "field",
                                                                             addr => 0x106bc,
                                                                             width => 14,
                                                                             bitOffset => 8,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_vht160mode_debug.cf_force_rxtimed_final_val"                      => {
                                                                             type => "field",
                                                                             addr => 0x106bc,
                                                                             width => 2,
                                                                             bitOffset => 6,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_vht160mode_debug.cf_force_rxtimed_start_val"                      => {
                                                                             type => "field",
                                                                             addr => 0x106bc,
                                                                             width => 2,
                                                                             bitOffset => 4,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_vht160mode_debug.cf_VHT160_mode_rxtimed"                          => {
                                                                             type => "field",
                                                                             addr => 0x106bc,
                                                                             width => 1,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_cal_chain_mask"                                                   => {
                                                                             type => "reg",
                                                                             addr => 0x106c0,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_cal_chain_mask.cal_chain_mask"                                    => {
                                                                             type => "field",
                                                                             addr => 0x106c0,
                                                                             width => 4,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 15
                                                                             },
    "BB_agc_control"                                                      => {
                                                                             type => "reg",
                                                                             addr => 0x106c4,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_agc_control.max_gainchanges"                                      => {
                                                                             type => "field",
                                                                             addr => 0x106c4,
                                                                             width => 4,
                                                                             bitOffset => 21,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_agc_control.enable_pkdet_cal"                                     => {
                                                                             type => "field",
                                                                             addr => 0x106c4,
                                                                             width => 1,
                                                                             bitOffset => 20,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_agc_control.clc_success"                                          => {
                                                                             type => "field",
                                                                             addr => 0x106c4,
                                                                             width => 1,
                                                                             bitOffset => 19,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0x0
                                                                             },
    "BB_agc_control.extend_NF_pwr_meas"                                   => {
                                                                             type => "field",
                                                                             addr => 0x106c4,
                                                                             width => 1,
                                                                             bitOffset => 18,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x1
                                                                             },
    "BB_agc_control.no_update_noisefloor"                                 => {
                                                                             type => "field",
                                                                             addr => 0x106c4,
                                                                             width => 1,
                                                                             bitOffset => 17,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_agc_control.enable_fltr_cal"                                      => {
                                                                             type => "field",
                                                                             addr => 0x106c4,
                                                                             width => 1,
                                                                             bitOffset => 16,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_agc_control.enable_noisefloor"                                    => {
                                                                             type => "field",
                                                                             addr => 0x106c4,
                                                                             width => 1,
                                                                             bitOffset => 15,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x1
                                                                             },
    "BB_agc_control.CAL_enable"                                           => {
                                                                             type => "field",
                                                                             addr => 0x106c4,
                                                                             width => 1,
                                                                             bitOffset => 11,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_agc_control.leaky_bucket_enable"                                  => {
                                                                             type => "field",
                                                                             addr => 0x106c4,
                                                                             width => 1,
                                                                             bitOffset => 10,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_agc_control.ycok_max"                                             => {
                                                                             type => "field",
                                                                             addr => 0x106c4,
                                                                             width => 4,
                                                                             bitOffset => 6,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_agc_control.min_num_gain_change"                                  => {
                                                                             type => "field",
                                                                             addr => 0x106c4,
                                                                             width => 3,
                                                                             bitOffset => 3,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_agc_control.do_noisefloor"                                        => {
                                                                             type => "field",
                                                                             addr => 0x106c4,
                                                                             width => 1,
                                                                             bitOffset => 1,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_agc_control.do_calibrate"                                         => {
                                                                             type => "field",
                                                                             addr => 0x106c4,
                                                                             width => 1,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_iq_adc_cal_mode"                                                  => {
                                                                             type => "reg",
                                                                             addr => 0x106c8,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_iq_adc_cal_mode.test_caladcoff"                                   => {
                                                                             type => "field",
                                                                             addr => 0x106c8,
                                                                             width => 1,
                                                                             bitOffset => 2,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_iq_adc_cal_mode.gain_dc_iq_cal_mode"                              => {
                                                                             type => "field",
                                                                             addr => 0x106c8,
                                                                             width => 2,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_fcal_1"                                                           => {
                                                                             type => "reg",
                                                                             addr => 0x106cc,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_fcal_1.flc_sb_atten"                                              => {
                                                                             type => "field",
                                                                             addr => 0x106cc,
                                                                             width => 5,
                                                                             bitOffset => 25,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 12
                                                                             },
    "BB_fcal_1.flc_pb_atten"                                              => {
                                                                             type => "field",
                                                                             addr => 0x106cc,
                                                                             width => 5,
                                                                             bitOffset => 20,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 12
                                                                             },
    "BB_fcal_1.flc_sb_fstep"                                              => {
                                                                             type => "field",
                                                                             addr => 0x106cc,
                                                                             width => 10,
                                                                             bitOffset => 10,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 269
                                                                             },
    "BB_fcal_1.flc_pb_fstep"                                              => {
                                                                             type => "field",
                                                                             addr => 0x106cc,
                                                                             width => 10,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 51
                                                                             },
    "BB_fcal_2_b0"                                                        => {
                                                                             type => "reg",
                                                                             addr => 0x106d0,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_fcal_2_b0.flc_txbb6dbgain"                                        => {
                                                                             type => "field",
                                                                             addr => 0x106d0,
                                                                             width => 2,
                                                                             bitOffset => 29,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_fcal_2_b0.flc_txbb1dbgain"                                        => {
                                                                             type => "field",
                                                                             addr => 0x106d0,
                                                                             width => 4,
                                                                             bitOffset => 25,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_fcal_2_b0.flc_cap_val_status_0"                                   => {
                                                                             type => "field",
                                                                             addr => 0x106d0,
                                                                             width => 5,
                                                                             bitOffset => 20,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0
                                                                             },
    "BB_fcal_2_b0.flc_meas_win"                                           => {
                                                                             type => "field",
                                                                             addr => 0x106d0,
                                                                             width => 3,
                                                                             bitOffset => 17,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 3
                                                                             },
    "BB_fcal_2_b0.flc_sw_cap_set"                                         => {
                                                                             type => "field",
                                                                             addr => 0x106d0,
                                                                             width => 1,
                                                                             bitOffset => 16,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_fcal_2_b0.flc_bb6dbgain"                                          => {
                                                                             type => "field",
                                                                             addr => 0x106d0,
                                                                             width => 2,
                                                                             bitOffset => 14,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_fcal_2_b0.flc_bb1dbgain"                                          => {
                                                                             type => "field",
                                                                             addr => 0x106d0,
                                                                             width => 4,
                                                                             bitOffset => 10,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_fcal_2_b0.flc_bbmiscgain"                                         => {
                                                                             type => "field",
                                                                             addr => 0x106d0,
                                                                             width => 2,
                                                                             bitOffset => 8,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_fcal_2_b0.flc_sw_cap_val_0"                                       => {
                                                                             type => "field",
                                                                             addr => 0x106d0,
                                                                             width => 5,
                                                                             bitOffset => 3,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 15
                                                                             },
    "BB_fcal_2_b0.flc_pwr_thresh"                                         => {
                                                                             type => "field",
                                                                             addr => 0x106d0,
                                                                             width => 3,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 1
                                                                             },
    "BB_dft_tone_ctrl_b0"                                                 => {
                                                                             type => "reg",
                                                                             addr => 0x106d4,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_dft_tone_ctrl_b0.dft_tone_freq_ang_0"                             => {
                                                                             type => "field",
                                                                             addr => 0x106d4,
                                                                             width => 9,
                                                                             bitOffset => 4,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_dft_tone_ctrl_b0.dft_tone_amp_sel_0"                              => {
                                                                             type => "field",
                                                                             addr => 0x106d4,
                                                                             width => 2,
                                                                             bitOffset => 2,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_dft_tone_ctrl_b0.dft_tone_en_0"                                   => {
                                                                             type => "field",
                                                                             addr => 0x106d4,
                                                                             width => 1,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_cl_cal_ctrl"                                                      => {
                                                                             type => "reg",
                                                                             addr => 0x106d8,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_cl_cal_ctrl.cl_map_hw_gen"                                        => {
                                                                             type => "field",
                                                                             addr => 0x106d8,
                                                                             width => 1,
                                                                             bitOffset => 31,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_cl_cal_ctrl.use_dac_cl_correction"                                => {
                                                                             type => "field",
                                                                             addr => 0x106d8,
                                                                             width => 1,
                                                                             bitOffset => 30,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_cl_cal_ctrl.cf_adc_bound"                                         => {
                                                                             type => "field",
                                                                             addr => 0x106d8,
                                                                             width => 8,
                                                                             bitOffset => 22,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_cl_cal_ctrl.cf_clc_init_bbgain"                                   => {
                                                                             type => "field",
                                                                             addr => 0x106d8,
                                                                             width => 6,
                                                                             bitOffset => 16,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 25
                                                                             },
    "BB_cl_cal_ctrl.carr_leak_max_offset"                                 => {
                                                                             type => "field",
                                                                             addr => 0x106d8,
                                                                             width => 8,
                                                                             bitOffset => 8,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_cl_cal_ctrl.cf_clc_forced_pagain"                                 => {
                                                                             type => "field",
                                                                             addr => 0x106d8,
                                                                             width => 4,
                                                                             bitOffset => 4,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_cl_cal_ctrl.cf_clc_test_point"                                    => {
                                                                             type => "field",
                                                                             addr => 0x106d8,
                                                                             width => 2,
                                                                             bitOffset => 2,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_cl_cal_ctrl.enable_cl_calibrate"                                  => {
                                                                             type => "field",
                                                                             addr => 0x106d8,
                                                                             width => 1,
                                                                             bitOffset => 1,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0x0
                                                                             },
    "BB_cl_cal_ctrl.enable_parallel_cal"                                  => {
                                                                             type => "field",
                                                                             addr => 0x106d8,
                                                                             width => 1,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_cl_map_0_b0"                                                      => {
                                                                             type => "reg",
                                                                             addr => 0x106dc,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_cl_map_0_b0.cl_map_0"                                             => {
                                                                             type => "field",
                                                                             addr => 0x106dc,
                                                                             width => 32,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_cl_map_1_b0"                                                      => {
                                                                             type => "reg",
                                                                             addr => 0x106e0,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_cl_map_1_b0.cl_map_1"                                             => {
                                                                             type => "field",
                                                                             addr => 0x106e0,
                                                                             width => 32,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_cl_map_2_b0"                                                      => {
                                                                             type => "reg",
                                                                             addr => 0x106e4,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_cl_map_2_b0.cl_map_2"                                             => {
                                                                             type => "field",
                                                                             addr => 0x106e4,
                                                                             width => 32,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_cl_map_3_b0"                                                      => {
                                                                             type => "reg",
                                                                             addr => 0x106e8,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_cl_map_3_b0.cl_map_3"                                             => {
                                                                             type => "field",
                                                                             addr => 0x106e8,
                                                                             width => 32,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_cl_tab_b0"                                                        => {
                                                                             type => "reg",
                                                                             addr => 0x10700,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             depth => 16,
                                                                             incr => 4
                                                                             },
    "BB_cl_tab_b0.bb_gain"                                                => {
                                                                             type => "field",
                                                                             addr => 0x10700,
                                                                             width => 4,
                                                                             bitOffset => 27,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_cl_tab_b0.carr_lk_dc_add_I"                                       => {
                                                                             type => "field",
                                                                             addr => 0x10700,
                                                                             width => 11,
                                                                             bitOffset => 16,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_cl_tab_b0.carr_lk_dc_add_Q"                                       => {
                                                                             type => "field",
                                                                             addr => 0x10700,
                                                                             width => 11,
                                                                             bitOffset => 5,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_cl_tab_b0.cl_gain_mod"                                            => {
                                                                             type => "field",
                                                                             addr => 0x10700,
                                                                             width => 5,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_synth_control"                                                    => {
                                                                             type => "reg",
                                                                             addr => 0x10740,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_synth_control.sel_alt_tables"                                     => {
                                                                             type => "field",
                                                                             addr => 0x10740,
                                                                             width => 1,
                                                                             bitOffset => 31,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_synth_control.rfsynth_ctrl_sshift"                                => {
                                                                             type => "field",
                                                                             addr => 0x10740,
                                                                             width => 1,
                                                                             bitOffset => 30,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_synth_control.rfbmode"                                            => {
                                                                             type => "field",
                                                                             addr => 0x10740,
                                                                             width => 1,
                                                                             bitOffset => 29,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_synth_control.rfFracmode"                                         => {
                                                                             type => "field",
                                                                             addr => 0x10740,
                                                                             width => 1,
                                                                             bitOffset => 28,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_synth_control.rfAmodeRefSel"                                      => {
                                                                             type => "field",
                                                                             addr => 0x10740,
                                                                             width => 2,
                                                                             bitOffset => 26,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_synth_control.rfchannel"                                          => {
                                                                             type => "field",
                                                                             addr => 0x10740,
                                                                             width => 9,
                                                                             bitOffset => 17,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_synth_control.rfchanFrac"                                         => {
                                                                             type => "field",
                                                                             addr => 0x10740,
                                                                             width => 17,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_addac_clk_select"                                                 => {
                                                                             type => "reg",
                                                                             addr => 0x10744,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_addac_clk_select.bb_adc_clk_select_ch3"                           => {
                                                                             type => "field",
                                                                             addr => 0x10744,
                                                                             width => 2,
                                                                             bitOffset => 10,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_addac_clk_select.bb_adc_clk_select_ch2"                           => {
                                                                             type => "field",
                                                                             addr => 0x10744,
                                                                             width => 2,
                                                                             bitOffset => 8,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_addac_clk_select.bb_adc_clk_select_ch1"                           => {
                                                                             type => "field",
                                                                             addr => 0x10744,
                                                                             width => 2,
                                                                             bitOffset => 6,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_addac_clk_select.bb_adc_clk_select_ch0"                           => {
                                                                             type => "field",
                                                                             addr => 0x10744,
                                                                             width => 2,
                                                                             bitOffset => 4,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_addac_clk_select.bb_dac_clk_select"                               => {
                                                                             type => "field",
                                                                             addr => 0x10744,
                                                                             width => 4,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_pll_cntl"                                                         => {
                                                                             type => "reg",
                                                                             addr => 0x10748,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_pll_cntl.bb_pll_settle_time"                                      => {
                                                                             type => "field",
                                                                             addr => 0x10748,
                                                                             width => 11,
                                                                             bitOffset => 17,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 1024
                                                                             },
    "BB_pll_cntl.bb_pllbypass"                                            => {
                                                                             type => "field",
                                                                             addr => 0x10748,
                                                                             width => 1,
                                                                             bitOffset => 16,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x1
                                                                             },
    "BB_pll_cntl.bb_pll_clk_sel"                                          => {
                                                                             type => "field",
                                                                             addr => 0x10748,
                                                                             width => 2,
                                                                             bitOffset => 14,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_pll_cntl.bb_pll_refdiv"                                           => {
                                                                             type => "field",
                                                                             addr => 0x10748,
                                                                             width => 4,
                                                                             bitOffset => 10,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 5
                                                                             },
    "BB_pll_cntl.bb_pll_div"                                              => {
                                                                             type => "field",
                                                                             addr => 0x10748,
                                                                             width => 10,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 50
                                                                             },
    "BB_analog_swap"                                                      => {
                                                                             type => "reg",
                                                                             addr => 0x1074c,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_analog_swap.analog_pkdet_dac_polarity"                            => {
                                                                             type => "field",
                                                                             addr => 0x1074c,
                                                                             width => 1,
                                                                             bitOffset => 8,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_analog_swap.analog_dc_dac_polarity"                               => {
                                                                             type => "field",
                                                                             addr => 0x1074c,
                                                                             width => 1,
                                                                             bitOffset => 7,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_analog_swap.swap_alt_chn"                                         => {
                                                                             type => "field",
                                                                             addr => 0x1074c,
                                                                             width => 1,
                                                                             bitOffset => 6,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_analog_swap.analog_tx_swap_cntl"                                  => {
                                                                             type => "field",
                                                                             addr => 0x1074c,
                                                                             width => 3,
                                                                             bitOffset => 3,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_analog_swap.analog_rx_swap_cntl"                                  => {
                                                                             type => "field",
                                                                             addr => 0x1074c,
                                                                             width => 3,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_addac_parallel_control"                                           => {
                                                                             type => "reg",
                                                                             addr => 0x10750,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_addac_parallel_control.on_pwdAdc"                                 => {
                                                                             type => "field",
                                                                             addr => 0x10750,
                                                                             width => 1,
                                                                             bitOffset => 31,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_addac_parallel_control.on_pwdDac"                                 => {
                                                                             type => "field",
                                                                             addr => 0x10750,
                                                                             width => 1,
                                                                             bitOffset => 29,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_addac_parallel_control.on_daclpmode"                              => {
                                                                             type => "field",
                                                                             addr => 0x10750,
                                                                             width => 1,
                                                                             bitOffset => 28,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_addac_parallel_control.off_pwdAdc"                                => {
                                                                             type => "field",
                                                                             addr => 0x10750,
                                                                             width => 1,
                                                                             bitOffset => 15,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x1
                                                                             },
    "BB_addac_parallel_control.off_pwdDac"                                => {
                                                                             type => "field",
                                                                             addr => 0x10750,
                                                                             width => 1,
                                                                             bitOffset => 13,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x1
                                                                             },
    "BB_addac_parallel_control.off_daclpmode"                             => {
                                                                             type => "field",
                                                                             addr => 0x10750,
                                                                             width => 1,
                                                                             bitOffset => 12,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_force_clock"                                                      => {
                                                                             type => "reg",
                                                                             addr => 0x10754,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_force_clock.ena_reg_clk_gating"                                   => {
                                                                             type => "field",
                                                                             addr => 0x10754,
                                                                             width => 1,
                                                                             bitOffset => 26,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_force_clock.cf_dpd_tx_radio_bw"                                   => {
                                                                             type => "field",
                                                                             addr => 0x10754,
                                                                             width => 3,
                                                                             bitOffset => 23,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 2
                                                                             },
    "BB_force_clock.cf_forced_tx_radio_bw"                                => {
                                                                             type => "field",
                                                                             addr => 0x10754,
                                                                             width => 3,
                                                                             bitOffset => 20,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 5
                                                                             },
    "BB_force_clock.cf_force_tx_radio_bw"                                 => {
                                                                             type => "field",
                                                                             addr => 0x10754,
                                                                             width => 1,
                                                                             bitOffset => 19,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_force_clock.cf_synthon_in_activelow"                              => {
                                                                             type => "field",
                                                                             addr => 0x10754,
                                                                             width => 1,
                                                                             bitOffset => 18,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_force_clock.cf_double_tx_radio_bw"                                => {
                                                                             type => "field",
                                                                             addr => 0x10754,
                                                                             width => 1,
                                                                             bitOffset => 17,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_force_clock.cf_forced_clktadc"                                    => {
                                                                             type => "field",
                                                                             addr => 0x10754,
                                                                             width => 3,
                                                                             bitOffset => 14,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_force_clock.cf_force_clktadc"                                     => {
                                                                             type => "field",
                                                                             addr => 0x10754,
                                                                             width => 1,
                                                                             bitOffset => 13,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_force_clock.cf_forced_clkgen_bw"                                  => {
                                                                             type => "field",
                                                                             addr => 0x10754,
                                                                             width => 3,
                                                                             bitOffset => 10,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_force_clock.cf_force_clkgen_bw"                                   => {
                                                                             type => "field",
                                                                             addr => 0x10754,
                                                                             width => 1,
                                                                             bitOffset => 9,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_force_clock.cf_forced_radio_bw"                                   => {
                                                                             type => "field",
                                                                             addr => 0x10754,
                                                                             width => 3,
                                                                             bitOffset => 6,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_force_clock.cf_force_radio_bw"                                    => {
                                                                             type => "field",
                                                                             addr => 0x10754,
                                                                             width => 1,
                                                                             bitOffset => 5,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_force_clock.cf_forced_adc_clk_rate"                               => {
                                                                             type => "field",
                                                                             addr => 0x10754,
                                                                             width => 2,
                                                                             bitOffset => 1,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_force_clock.cf_force_adc_clk_rate"                                => {
                                                                             type => "field",
                                                                             addr => 0x10754,
                                                                             width => 1,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_force_analog"                                                     => {
                                                                             type => "reg",
                                                                             addr => 0x10758,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_force_analog.forced_paprd_xpaon"                                  => {
                                                                             type => "field",
                                                                             addr => 0x10758,
                                                                             width => 4,
                                                                             bitOffset => 5,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_force_analog.forced_xpaon"                                        => {
                                                                             type => "field",
                                                                             addr => 0x10758,
                                                                             width => 3,
                                                                             bitOffset => 1,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_force_analog.force_xpaon"                                         => {
                                                                             type => "field",
                                                                             addr => 0x10758,
                                                                             width => 1,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_force_ss_ctrl"                                                    => {
                                                                             type => "reg",
                                                                             addr => 0x1075c,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_force_ss_ctrl.update_offset_sw_en"                                => {
                                                                             type => "field",
                                                                             addr => 0x1075c,
                                                                             width => 1,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_test_controls"                                                    => {
                                                                             type => "reg",
                                                                             addr => 0x10760,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_test_controls.tstdac_out_sel"                                     => {
                                                                             type => "field",
                                                                             addr => 0x10760,
                                                                             width => 2,
                                                                             bitOffset => 30,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_test_controls.force_agc_clear"                                    => {
                                                                             type => "field",
                                                                             addr => 0x10760,
                                                                             width => 1,
                                                                             bitOffset => 28,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_test_controls.agc_obs_sel_4"                                      => {
                                                                             type => "field",
                                                                             addr => 0x10760,
                                                                             width => 1,
                                                                             bitOffset => 24,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_test_controls.rx_obs_sel_5th_bit"                                 => {
                                                                             type => "field",
                                                                             addr => 0x10760,
                                                                             width => 1,
                                                                             bitOffset => 23,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_test_controls.cf_bbb_obs_sel"                                     => {
                                                                             type => "field",
                                                                             addr => 0x10760,
                                                                             width => 4,
                                                                             bitOffset => 19,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_test_controls.agc_obs_sel_3"                                      => {
                                                                             type => "field",
                                                                             addr => 0x10760,
                                                                             width => 1,
                                                                             bitOffset => 18,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_test_controls.slow_clk160"                                        => {
                                                                             type => "field",
                                                                             addr => 0x10760,
                                                                             width => 1,
                                                                             bitOffset => 17,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_test_controls.enable_mini_obs"                                    => {
                                                                             type => "field",
                                                                             addr => 0x10760,
                                                                             width => 1,
                                                                             bitOffset => 15,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_test_controls.enable_rfsilent_bb"                                 => {
                                                                             type => "field",
                                                                             addr => 0x10760,
                                                                             width => 1,
                                                                             bitOffset => 13,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_test_controls.clkout_is_clk32"                                    => {
                                                                             type => "field",
                                                                             addr => 0x10760,
                                                                             width => 1,
                                                                             bitOffset => 10,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_test_controls.cardbus_mode"                                       => {
                                                                             type => "field",
                                                                             addr => 0x10760,
                                                                             width => 2,
                                                                             bitOffset => 8,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_test_controls.cf_rfshift_sel"                                     => {
                                                                             type => "field",
                                                                             addr => 0x10760,
                                                                             width => 2,
                                                                             bitOffset => 5,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_test_controls.cf_tsttrig"                                         => {
                                                                             type => "field",
                                                                             addr => 0x10760,
                                                                             width => 1,
                                                                             bitOffset => 4,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_test_controls.cf_tsttrig_sel"                                     => {
                                                                             type => "field",
                                                                             addr => 0x10760,
                                                                             width => 4,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_test_controls_status"                                             => {
                                                                             type => "reg",
                                                                             addr => 0x10764,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_test_controls_status.cf_debugport_sel"                            => {
                                                                             type => "field",
                                                                             addr => 0x10764,
                                                                             width => 3,
                                                                             bitOffset => 29,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_test_controls_status.cf_debugport_en"                             => {
                                                                             type => "field",
                                                                             addr => 0x10764,
                                                                             width => 1,
                                                                             bitOffset => 28,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_test_controls_status.disable_agc_to_a2"                           => {
                                                                             type => "field",
                                                                             addr => 0x10764,
                                                                             width => 1,
                                                                             bitOffset => 27,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_test_controls_status.cf_debugport_in"                             => {
                                                                             type => "field",
                                                                             addr => 0x10764,
                                                                             width => 1,
                                                                             bitOffset => 23,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_test_controls_status.cf_enable_fft_dump"                          => {
                                                                             type => "field",
                                                                             addr => 0x10764,
                                                                             width => 1,
                                                                             bitOffset => 19,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_test_controls_status.agc_obs_sel"                                 => {
                                                                             type => "field",
                                                                             addr => 0x10764,
                                                                             width => 3,
                                                                             bitOffset => 16,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_test_controls_status.reset_a2"                                    => {
                                                                             type => "field",
                                                                             addr => 0x10764,
                                                                             width => 1,
                                                                             bitOffset => 15,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_test_controls_status.disable_a2_warm_reset"                       => {
                                                                             type => "field",
                                                                             addr => 0x10764,
                                                                             width => 1,
                                                                             bitOffset => 14,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_test_controls_status.rx_obs_sel"                                  => {
                                                                             type => "field",
                                                                             addr => 0x10764,
                                                                             width => 4,
                                                                             bitOffset => 10,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_test_controls_status.cf_rx_src_is_tstadc"                         => {
                                                                             type => "field",
                                                                             addr => 0x10764,
                                                                             width => 1,
                                                                             bitOffset => 9,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_test_controls_status.cf_tstadc_en"                                => {
                                                                             type => "field",
                                                                             addr => 0x10764,
                                                                             width => 1,
                                                                             bitOffset => 8,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_test_controls_status.cf_tx_src_alternate"                         => {
                                                                             type => "field",
                                                                             addr => 0x10764,
                                                                             width => 1,
                                                                             bitOffset => 7,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_test_controls_status.cf_tx_obs_mux_sel"                           => {
                                                                             type => "field",
                                                                             addr => 0x10764,
                                                                             width => 2,
                                                                             bitOffset => 5,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_test_controls_status.cf_tx_obs_sel"                               => {
                                                                             type => "field",
                                                                             addr => 0x10764,
                                                                             width => 3,
                                                                             bitOffset => 2,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_test_controls_status.cf_tx_src_is_tstdac"                         => {
                                                                             type => "field",
                                                                             addr => 0x10764,
                                                                             width => 1,
                                                                             bitOffset => 1,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_test_controls_status.cf_tstdac_en"                                => {
                                                                             type => "field",
                                                                             addr => 0x10764,
                                                                             width => 1,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_tstdac"                                                           => {
                                                                             type => "reg",
                                                                             addr => 0x10768,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO"
                                                                             },
    "BB_tstdac.tstdac_out_i"                                              => {
                                                                             type => "field",
                                                                             addr => 0x10768,
                                                                             width => 12,
                                                                             bitOffset => 12,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0
                                                                             },
    "BB_tstdac.tstdac_out_q"                                              => {
                                                                             type => "field",
                                                                             addr => 0x10768,
                                                                             width => 12,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0
                                                                             },
    "BB_channel_status"                                                   => {
                                                                             type => "reg",
                                                                             addr => 0x1076c,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO"
                                                                             },
    "BB_channel_status.ant_div_cfg_used"                                  => {
                                                                             type => "field",
                                                                             addr => 0x1076c,
                                                                             width => 3,
                                                                             bitOffset => 18,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0
                                                                             },
    "BB_channel_status.bb_sw_com_out"                                     => {
                                                                             type => "field",
                                                                             addr => 0x1076c,
                                                                             width => 6,
                                                                             bitOffset => 12,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0
                                                                             },
    "BB_channel_status.bb_sw_out_3"                                       => {
                                                                             type => "field",
                                                                             addr => 0x1076c,
                                                                             width => 2,
                                                                             bitOffset => 10,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0
                                                                             },
    "BB_channel_status.bb_sw_out_2"                                       => {
                                                                             type => "field",
                                                                             addr => 0x1076c,
                                                                             width => 2,
                                                                             bitOffset => 8,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0
                                                                             },
    "BB_channel_status.bb_sw_out_1"                                       => {
                                                                             type => "field",
                                                                             addr => 0x1076c,
                                                                             width => 2,
                                                                             bitOffset => 6,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0
                                                                             },
    "BB_channel_status.bb_sw_out_0"                                       => {
                                                                             type => "field",
                                                                             addr => 0x1076c,
                                                                             width => 2,
                                                                             bitOffset => 4,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0
                                                                             },
    "BB_channel_status.rx_clear_pad"                                      => {
                                                                             type => "field",
                                                                             addr => 0x1076c,
                                                                             width => 1,
                                                                             bitOffset => 3,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0
                                                                             },
    "BB_channel_status.rx_clear_mac"                                      => {
                                                                             type => "field",
                                                                             addr => 0x1076c,
                                                                             width => 1,
                                                                             bitOffset => 2,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0
                                                                             },
    "BB_channel_status.rx_clear_raw"                                      => {
                                                                             type => "field",
                                                                             addr => 0x1076c,
                                                                             width => 1,
                                                                             bitOffset => 1,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0
                                                                             },
    "BB_channel_status.bt_active"                                         => {
                                                                             type => "field",
                                                                             addr => 0x1076c,
                                                                             width => 1,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0
                                                                             },
    "BB_chaninfo_ctrl"                                                    => {
                                                                             type => "reg",
                                                                             addr => 0x10770,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_chaninfo_ctrl.rtt_rxsm_delay_enable"                              => {
                                                                             type => "field",
                                                                             addr => 0x10770,
                                                                             width => 1,
                                                                             bitOffset => 31,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_chaninfo_ctrl.rtt_mu_filt_enable"                                 => {
                                                                             type => "field",
                                                                             addr => 0x10770,
                                                                             width => 1,
                                                                             bitOffset => 30,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x1
                                                                             },
    "BB_chaninfo_ctrl.rtt_mimo_stbc_filt_enable"                          => {
                                                                             type => "field",
                                                                             addr => 0x10770,
                                                                             width => 1,
                                                                             bitOffset => 29,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x1
                                                                             },
    "BB_chaninfo_ctrl.rtt_itp_cnt_rx_begin_data"                          => {
                                                                             type => "field",
                                                                             addr => 0x10770,
                                                                             width => 4,
                                                                             bitOffset => 25,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0
                                                                             },
    "BB_chaninfo_ctrl.agc_str_chain_rtt"                                  => {
                                                                             type => "field",
                                                                             addr => 0x10770,
                                                                             width => 2,
                                                                             bitOffset => 23,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0
                                                                             },
    "BB_chaninfo_ctrl.rtt_post_chan_mask_en"                              => {
                                                                             type => "field",
                                                                             addr => 0x10770,
                                                                             width => 1,
                                                                             bitOffset => 22,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x1
                                                                             },
    "BB_chaninfo_ctrl.rtt_det_thr"                                        => {
                                                                             type => "field",
                                                                             addr => 0x10770,
                                                                             width => 5,
                                                                             bitOffset => 17,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 9
                                                                             },
    "BB_chaninfo_ctrl.rtt_srch_window"                                    => {
                                                                             type => "field",
                                                                             addr => 0x10770,
                                                                             width => 8,
                                                                             bitOffset => 9,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 20
                                                                             },
    "BB_chaninfo_ctrl.rtt_hardware_iFFT"                                  => {
                                                                             type => "field",
                                                                             addr => 0x10770,
                                                                             width => 1,
                                                                             bitOffset => 8,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x1
                                                                             },
    "BB_chaninfo_ctrl.rtt_enable_cch_rot"                                 => {
                                                                             type => "field",
                                                                             addr => 0x10770,
                                                                             width => 1,
                                                                             bitOffset => 7,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_chaninfo_ctrl.rtt_mac_phy_phase"                                  => {
                                                                             type => "field",
                                                                             addr => 0x10770,
                                                                             width => 1,
                                                                             bitOffset => 6,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0
                                                                             },
    "BB_chaninfo_ctrl.chaninfomem_bw"                                     => {
                                                                             type => "field",
                                                                             addr => 0x10770,
                                                                             width => 2,
                                                                             bitOffset => 4,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0
                                                                             },
    "BB_chaninfo_ctrl.chaninfomem_s2_read"                                => {
                                                                             type => "field",
                                                                             addr => 0x10770,
                                                                             width => 1,
                                                                             bitOffset => 3,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_chaninfo_ctrl.capture_sounding_packet"                            => {
                                                                             type => "field",
                                                                             addr => 0x10770,
                                                                             width => 1,
                                                                             bitOffset => 2,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_chaninfo_ctrl.disable_chaninfomem"                                => {
                                                                             type => "field",
                                                                             addr => 0x10770,
                                                                             width => 1,
                                                                             bitOffset => 1,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_chaninfo_ctrl.capture_chan_info"                                  => {
                                                                             type => "field",
                                                                             addr => 0x10770,
                                                                             width => 1,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_chan_info_noise_pwr_b0"                                           => {
                                                                             type => "reg",
                                                                             addr => 0x10774,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO"
                                                                             },
    "BB_chan_info_noise_pwr_b0.chan_info_fine_dc_q_0"                     => {
                                                                             type => "field",
                                                                             addr => 0x10774,
                                                                             width => 8,
                                                                             bitOffset => 20,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0
                                                                             },
    "BB_chan_info_noise_pwr_b0.chan_info_fine_dc_i_0"                     => {
                                                                             type => "field",
                                                                             addr => 0x10774,
                                                                             width => 8,
                                                                             bitOffset => 12,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0
                                                                             },
    "BB_chan_info_noise_pwr_b0.noise_power"                               => {
                                                                             type => "field",
                                                                             addr => 0x10774,
                                                                             width => 12,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0
                                                                             },
    "BB_chan_info_gain_diff"                                              => {
                                                                             type => "reg",
                                                                             addr => 0x10778,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO"
                                                                             },
    "BB_chan_info_gain_diff.analog_gain_diff_01"                          => {
                                                                             type => "field",
                                                                             addr => 0x10778,
                                                                             width => 7,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0
                                                                             },
    "BB_chan_info_fine_timing"                                            => {
                                                                             type => "reg",
                                                                             addr => 0x1077c,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO"
                                                                             },
    "BB_chan_info_fine_timing.fine_timing"                                => {
                                                                             type => "field",
                                                                             addr => 0x1077c,
                                                                             width => 10,
                                                                             bitOffset => 12,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0
                                                                             },
    "BB_chan_info_fine_timing.coarse_ppm"                                 => {
                                                                             type => "field",
                                                                             addr => 0x1077c,
                                                                             width => 12,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0
                                                                             },
    "BB_chan_info_gain_b0"                                                => {
                                                                             type => "reg",
                                                                             addr => 0x10780,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO"
                                                                             },
    "BB_chan_info_gain_b0.chan_info_xatten2_sw_0"                         => {
                                                                             type => "field",
                                                                             addr => 0x10780,
                                                                             width => 1,
                                                                             bitOffset => 24,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0
                                                                             },
    "BB_chan_info_gain_b0.chan_info_xatten1_sw_0"                         => {
                                                                             type => "field",
                                                                             addr => 0x10780,
                                                                             width => 1,
                                                                             bitOffset => 23,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0
                                                                             },
    "BB_chan_info_gain_b0.chan_info_mb_gain_0"                            => {
                                                                             type => "field",
                                                                             addr => 0x10780,
                                                                             width => 7,
                                                                             bitOffset => 16,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0
                                                                             },
    "BB_chan_info_gain_b0.chan_info_rf_gain_0"                            => {
                                                                             type => "field",
                                                                             addr => 0x10780,
                                                                             width => 8,
                                                                             bitOffset => 8,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0
                                                                             },
    "BB_chan_info_gain_b0.chan_info_rssi_0"                               => {
                                                                             type => "field",
                                                                             addr => 0x10780,
                                                                             width => 8,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0
                                                                             },
    "BB_rtt_corr_value"                                                   => {
                                                                             type => "reg",
                                                                             addr => 0x10784,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO"
                                                                             },
    "BB_rtt_corr_value.rtt_TM_Rx_rxclr_phase"                             => {
                                                                             type => "field",
                                                                             addr => 0x10784,
                                                                             width => 1,
                                                                             bitOffset => 31,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => "NL"
                                                                             },
    "BB_rtt_corr_value.rtt_tx_data_start_x_phase"                         => {
                                                                             type => "field",
                                                                             addr => 0x10784,
                                                                             width => 1,
                                                                             bitOffset => 30,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => "NL"
                                                                             },
    "BB_rtt_corr_value.rtt_cfr_ready"                                     => {
                                                                             type => "field",
                                                                             addr => 0x10784,
                                                                             width => 1,
                                                                             bitOffset => 29,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => "NL"
                                                                             },
    "BB_rtt_corr_value.rtt_cir_ready"                                     => {
                                                                             type => "field",
                                                                             addr => 0x10784,
                                                                             width => 1,
                                                                             bitOffset => 28,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => "NL"
                                                                             },
    "BB_rtt_corr_value.rtt_fac_status"                                    => {
                                                                             type => "field",
                                                                             addr => 0x10784,
                                                                             width => 2,
                                                                             bitOffset => 26,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => "NL"
                                                                             },
    "BB_rtt_corr_value.rtt_async_fifo_phase"                              => {
                                                                             type => "field",
                                                                             addr => 0x10784,
                                                                             width => 5,
                                                                             bitOffset => 21,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => "NL"
                                                                             },
    "BB_rtt_corr_value.rtt_tx_frame_phase"                                => {
                                                                             type => "field",
                                                                             addr => 0x10784,
                                                                             width => 4,
                                                                             bitOffset => 17,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => "NL"
                                                                             },
    "BB_rtt_corr_value.rtt_corr_value"                                    => {
                                                                             type => "field",
                                                                             addr => 0x10784,
                                                                             width => 17,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0
                                                                             },
    "BB_nf_dcoff_b0"                                                      => {
                                                                             type => "reg",
                                                                             addr => 0x10788,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO"
                                                                             },
    "BB_nf_dcoff_b0.dc_off_q_0"                                           => {
                                                                             type => "field",
                                                                             addr => 0x10788,
                                                                             width => 8,
                                                                             bitOffset => 8,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0
                                                                             },
    "BB_nf_dcoff_b0.dc_off_i_0"                                           => {
                                                                             type => "field",
                                                                             addr => 0x10788,
                                                                             width => 8,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0
                                                                             },
    "BB_chan_info_fine_ppm"                                               => {
                                                                             type => "reg",
                                                                             addr => 0x1078c,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO"
                                                                             },
    "BB_chan_info_fine_ppm.fine_ppm"                                      => {
                                                                             type => "field",
                                                                             addr => 0x1078c,
                                                                             width => 12,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0
                                                                             },
    "BB_scrambler_seed"                                                   => {
                                                                             type => "reg",
                                                                             addr => 0x10790,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_scrambler_seed.fixed_scrambler_seed"                              => {
                                                                             type => "field",
                                                                             addr => 0x10790,
                                                                             width => 7,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_bbb_tx_ctrl"                                                      => {
                                                                             type => "reg",
                                                                             addr => 0x10794,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_bbb_tx_ctrl.tx_cck_delay_3"                                       => {
                                                                             type => "field",
                                                                             addr => 0x10794,
                                                                             width => 3,
                                                                             bitOffset => 12,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0x0
                                                                             },
    "BB_bbb_tx_ctrl.tx_cck_delay_2"                                       => {
                                                                             type => "field",
                                                                             addr => 0x10794,
                                                                             width => 3,
                                                                             bitOffset => 9,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0x0
                                                                             },
    "BB_bbb_tx_ctrl.tx_cck_delay_1"                                       => {
                                                                             type => "field",
                                                                             addr => 0x10794,
                                                                             width => 3,
                                                                             bitOffset => 6,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0x0
                                                                             },
    "BB_bbb_tx_ctrl.allow_1mbps_short"                                    => {
                                                                             type => "field",
                                                                             addr => 0x10794,
                                                                             width => 1,
                                                                             bitOffset => 5,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0x0
                                                                             },
    "BB_bbb_tx_ctrl.txfir_japan_cck"                                      => {
                                                                             type => "field",
                                                                             addr => 0x10794,
                                                                             width => 1,
                                                                             bitOffset => 4,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0x0
                                                                             },
    "BB_bbb_tx_ctrl.tx_dac_scale_cck"                                     => {
                                                                             type => "field",
                                                                             addr => 0x10794,
                                                                             width => 2,
                                                                             bitOffset => 2,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0x0
                                                                             },
    "BB_bbb_tx_ctrl.use_scrambler_seed"                                   => {
                                                                             type => "field",
                                                                             addr => 0x10794,
                                                                             width => 1,
                                                                             bitOffset => 1,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_bbb_tx_ctrl.disable_scrambler"                                    => {
                                                                             type => "field",
                                                                             addr => 0x10794,
                                                                             width => 1,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0x0
                                                                             },
    "BB_bbb_txfir_0"                                                      => {
                                                                             type => "reg",
                                                                             addr => 0x10798,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO"
                                                                             },
    "BB_bbb_txfir_0.txfir_coeff_h3"                                       => {
                                                                             type => "field",
                                                                             addr => 0x10798,
                                                                             width => 5,
                                                                             bitOffset => 24,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0x0
                                                                             },
    "BB_bbb_txfir_0.txfir_coeff_h2"                                       => {
                                                                             type => "field",
                                                                             addr => 0x10798,
                                                                             width => 5,
                                                                             bitOffset => 16,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0x0
                                                                             },
    "BB_bbb_txfir_0.txfir_coeff_h1"                                       => {
                                                                             type => "field",
                                                                             addr => 0x10798,
                                                                             width => 4,
                                                                             bitOffset => 8,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0x0
                                                                             },
    "BB_bbb_txfir_0.txfir_coeff_h0"                                       => {
                                                                             type => "field",
                                                                             addr => 0x10798,
                                                                             width => 4,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0x0
                                                                             },
    "BB_bbb_txfir_1"                                                      => {
                                                                             type => "reg",
                                                                             addr => 0x1079c,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO"
                                                                             },
    "BB_bbb_txfir_1.txfir_coeff_h7"                                       => {
                                                                             type => "field",
                                                                             addr => 0x1079c,
                                                                             width => 7,
                                                                             bitOffset => 24,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0x0
                                                                             },
    "BB_bbb_txfir_1.txfir_coeff_h6"                                       => {
                                                                             type => "field",
                                                                             addr => 0x1079c,
                                                                             width => 7,
                                                                             bitOffset => 16,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0x0
                                                                             },
    "BB_bbb_txfir_1.txfir_coeff_h5"                                       => {
                                                                             type => "field",
                                                                             addr => 0x1079c,
                                                                             width => 6,
                                                                             bitOffset => 8,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0x0
                                                                             },
    "BB_bbb_txfir_1.txfir_coeff_h4"                                       => {
                                                                             type => "field",
                                                                             addr => 0x1079c,
                                                                             width => 6,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0x0
                                                                             },
    "BB_bbb_txfir_2"                                                      => {
                                                                             type => "reg",
                                                                             addr => 0x107a0,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO"
                                                                             },
    "BB_bbb_txfir_2.txfir_coeff_h11"                                      => {
                                                                             type => "field",
                                                                             addr => 0x107a0,
                                                                             width => 8,
                                                                             bitOffset => 24,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0x0
                                                                             },
    "BB_bbb_txfir_2.txfir_coeff_h10"                                      => {
                                                                             type => "field",
                                                                             addr => 0x107a0,
                                                                             width => 8,
                                                                             bitOffset => 16,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0x0
                                                                             },
    "BB_bbb_txfir_2.txfir_coeff_h9"                                       => {
                                                                             type => "field",
                                                                             addr => 0x107a0,
                                                                             width => 8,
                                                                             bitOffset => 8,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0x0
                                                                             },
    "BB_bbb_txfir_2.txfir_coeff_h8"                                       => {
                                                                             type => "field",
                                                                             addr => 0x107a0,
                                                                             width => 8,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RO",
                                                                             resetVal => 0x0
                                                                             },
    "BB_heavy_clip_0"                                                     => {
                                                                             type => "reg",
                                                                             addr => 0x107a4,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_heavy_clip_0.heavy_clip_factor_qam3"                              => {
                                                                             type => "field",
                                                                             addr => 0x107a4,
                                                                             width => 8,
                                                                             bitOffset => 24,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_heavy_clip_0.heavy_clip_factor_qam2"                              => {
                                                                             type => "field",
                                                                             addr => 0x107a4,
                                                                             width => 8,
                                                                             bitOffset => 16,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_heavy_clip_0.heavy_clip_factor_qam1"                              => {
                                                                             type => "field",
                                                                             addr => 0x107a4,
                                                                             width => 8,
                                                                             bitOffset => 8,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_heavy_clip_0.heavy_clip_factor_qam0"                              => {
                                                                             type => "field",
                                                                             addr => 0x107a4,
                                                                             width => 8,
                                                                             bitOffset => 0,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_heavy_clip_1"                                                     => {
                                                                             type => "reg",
                                                                             addr => 0x107a8,
                                                                             width => 32,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW"
                                                                             },
    "BB_heavy_clip_1.heavy_clip_factor_qam7"                              => {
                                                                             type => "field",
                                                                             addr => 0x107a8,
                                                                             width => 8,
                                                                             bitOffset => 24,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_heavy_clip_1.heavy_clip_factor_qam6"                              => {
                                                                             type => "field",
                                                                             addr => 0x107a8,
                                                                             width => 8,
                                                                             bitOffset => 16,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_heavy_clip_1.heavy_clip_factor_qam5"                              => {
                                                                             type => "field",
                                                                             addr => 0x107a8,
                                                                             width => 8,
                                                                             bitOffset => 8,
                                                                             athEmulAttr => 0,
                                                                             acc => "RW",
                                                                             resetVal => 0
                                                                             },
    "BB_heavy_clip_1.heavy_clip_factor_qam4"                              => {
                                                                             type =>