// Copyright (c) 2014 Qualcomm Atheros, Inc.  All rights reserved.
// $ATH_LICENSE_HW_HDR_C$
//
// DO NOT EDIT!  This file is automatically generated
//               These definitions are tied to a particular hardware layout


#ifndef _TX_CBF_INFO_H_
#define _TX_CBF_INFO_H_
#if !defined(__ASSEMBLER__)
#endif

// ################ START SUMMARY #################
//
//	Dword	Fields
//	0	sounding_sequence_number[7:0], bandwidth[9:8], ndp_feedback_type[10], reserved_0[15:11], pre_cbf_duration[31:16]
//	1	addr1_31_0[31:0]
//	2	addr1_47_32[15:0], addr2_15_0[31:16]
//	3	addr2_47_16[31:0]
//	4	addr3_31_0[31:0]
//	5	addr3_47_32[15:0], partial_aid[24:16], group_id[30:25], cbf_resp_pwr_mgmt[31]
//
// ################ END SUMMARY #################

#define NUM_OF_DWORDS_TX_CBF_INFO 6

struct tx_cbf_info {
    volatile uint32_t sounding_sequence_number        :  8, //[7:0]
                      bandwidth                       :  2, //[9:8]
                      ndp_feedback_type               :  1, //[10]
                      reserved_0                      :  5, //[15:11]
                      pre_cbf_duration                : 16; //[31:16]
    volatile uint32_t addr1_31_0                      : 32; //[31:0]
    volatile uint32_t addr1_47_32                     : 16, //[15:0]
                      addr2_15_0                      : 16; //[31:16]
    volatile uint32_t addr2_47_16                     : 32; //[31:0]
    volatile uint32_t addr3_31_0                      : 32; //[31:0]
    volatile uint32_t addr3_47_32                     : 16, //[15:0]
                      partial_aid                     :  9, //[24:16]
                      group_id                        :  6, //[30:25]
                      cbf_resp_pwr_mgmt               :  1; //[31]
};

/*

sounding_sequence_number
			
			TXPCU will fill it in the MIMO Control field [23:16]

bandwidth
			
			The bandwidth that TXPCU needs to send the CBF.
			
			<enum_typedef tx_phy_desc bandwidth>
			
			<enum 0     20_mhz>
			
			<enum 1     40_mhz>
			
			<enum 2     80_mhz>
			
			<enum 3     160_mhz> 
			
			<legal 0-3>

ndp_feedback_type
			
			TXPCU will fill it in the MIMO Control field [11]:
			
			<enum 0     11ac_su>  SU feedback
			
			<enum 1     11ac_mu>  MU feedback
			
			<legal 0-1>

reserved_0
			
			Reserved: Generator should set to 0, consumer shall
			ignore <legal 0>

pre_cbf_duration
			
			NPDA_duration_field - SIFS - NDP_pkt_time or
			BRPOLL_duration_field.  The cbf_duration_field =
			pre_cbf_duration - cbf_pkt_time

addr1_31_0
			
			CBF address1[31:0]

addr1_47_32
			
			CBF address1[47:32]

addr2_15_0
			
			CBF address2[15:0]

addr2_47_16
			
			CBF address2[47:16]

addr3_31_0
			
			CBF address3[31:0]

addr3_47_32
			
			CBF address3[47:16]

partial_aid
			
			Partial AID field

group_id
			
			Group ID field

cbf_resp_pwr_mgmt
			
			Power management bit of the response CBF frame
*/


/* Description		TX_CBF_INFO_0_SOUNDING_SEQUENCE_NUMBER
			
			TXPCU will fill it in the MIMO Control field [23:16]
*/
#define TX_CBF_INFO_0_SOUNDING_SEQUENCE_NUMBER_OFFSET                0x00000000
#define TX_CBF_INFO_0_SOUNDING_SEQUENCE_NUMBER_LSB                   0
#define TX_CBF_INFO_0_SOUNDING_SEQUENCE_NUMBER_MASK                  0x000000ff

/* Description		TX_CBF_INFO_0_BANDWIDTH
			
			The bandwidth that TXPCU needs to send the CBF.
			
			<enum_typedef tx_phy_desc bandwidth>
			
			<enum 0     20_mhz>
			
			<enum 1     40_mhz>
			
			<enum 2     80_mhz>
			
			<enum 3     160_mhz> 
			
			<legal 0-3>
*/
#define TX_CBF_INFO_0_BANDWIDTH_OFFSET                               0x00000000
#define TX_CBF_INFO_0_BANDWIDTH_LSB                                  8
#define TX_CBF_INFO_0_BANDWIDTH_MASK                                 0x00000300

/* Description		TX_CBF_INFO_0_NDP_FEEDBACK_TYPE
			
			TXPCU will fill it in the MIMO Control field [11]:
			
			<enum 0     11ac_su>  SU feedback
			
			<enum 1     11ac_mu>  MU feedback
			
			<legal 0-1>
*/
#define TX_CBF_INFO_0_NDP_FEEDBACK_TYPE_OFFSET                       0x00000000
#define TX_CBF_INFO_0_NDP_FEEDBACK_TYPE_LSB                          10
#define TX_CBF_INFO_0_NDP_FEEDBACK_TYPE_MASK                         0x00000400

/* Description		TX_CBF_INFO_0_RESERVED_0
			
			Reserved: Generator should set to 0, consumer shall
			ignore <legal 0>
*/
#define TX_CBF_INFO_0_RESERVED_0_OFFSET                              0x00000000
#define TX_CBF_INFO_0_RESERVED_0_LSB                                 11
#define TX_CBF_INFO_0_RESERVED_0_MASK                                0x0000f800

/* Description		TX_CBF_INFO_0_PRE_CBF_DURATION
			
			NPDA_duration_field - SIFS - NDP_pkt_time or
			BRPOLL_duration_field.  The cbf_duration_field =
			pre_cbf_duration - cbf_pkt_time
*/
#define TX_CBF_INFO_0_PRE_CBF_DURATION_OFFSET                        0x00000000
#define TX_CBF_INFO_0_PRE_CBF_DURATION_LSB                           16
#define TX_CBF_INFO_0_PRE_CBF_DURATION_MASK                          0xffff0000

/* Description		TX_CBF_INFO_1_ADDR1_31_0
			
			CBF address1[31:0]
*/
#define TX_CBF_INFO_1_ADDR1_31_0_OFFSET                              0x00000004
#define TX_CBF_INFO_1_ADDR1_31_0_LSB                                 0
#define TX_CBF_INFO_1_ADDR1_31_0_MASK                                0xffffffff

/* Description		TX_CBF_INFO_2_ADDR1_47_32
			
			CBF address1[47:32]
*/
#define TX_CBF_INFO_2_ADDR1_47_32_OFFSET                             0x00000008
#define TX_CBF_INFO_2_ADDR1_47_32_LSB                                0
#define TX_CBF_INFO_2_ADDR1_47_32_MASK                               0x0000ffff

/* Description		TX_CBF_INFO_2_ADDR2_15_0
			
			CBF address2[15:0]
*/
#define TX_CBF_INFO_2_ADDR2_15_0_OFFSET                              0x00000008
#define TX_CBF_INFO_2_ADDR2_15_0_LSB                                 16
#define TX_CBF_INFO_2_ADDR2_15_0_MASK                                0xffff0000

/* Description		TX_CBF_INFO_3_ADDR2_47_16
			
			CBF address2[47:16]
*/
#define TX_CBF_INFO_3_ADDR2_47_16_OFFSET                             0x0000000c
#define TX_CBF_INFO_3_ADDR2_47_16_LSB                                0
#define TX_CBF_INFO_3_ADDR2_47_16_MASK                               0xffffffff

/* Description		TX_CBF_INFO_4_ADDR3_31_0
			
			CBF address3[31:0]
*/
#define TX_CBF_INFO_4_ADDR3_31_0_OFFSET                              0x00000010
#define TX_CBF_INFO_4_ADDR3_31_0_LSB                                 0
#define TX_CBF_INFO_4_ADDR3_31_0_MASK                                0xffffffff

/* Description		TX_CBF_INFO_5_ADDR3_47_32
			
			CBF address3[47:16]
*/
#define TX_CBF_INFO_5_ADDR3_47_32_OFFSET                             0x00000014
#define TX_CBF_INFO_5_ADDR3_47_32_LSB                                0
#define TX_CBF_INFO_5_ADDR3_47_32_MASK                               0x0000ffff

/* Description		TX_CBF_INFO_5_PARTIAL_AID
			
			Partial AID field
*/
#define TX_CBF_INFO_5_PARTIAL_AID_OFFSET                             0x00000014
#define TX_CBF_INFO_5_PARTIAL_AID_LSB                                16
#define TX_CBF_INFO_5_PARTIAL_AID_MASK                               0x01ff0000

/* Description		TX_CBF_INFO_5_GROUP_ID
			
			Group ID field
*/
#define TX_CBF_INFO_5_GROUP_ID_OFFSET                                0x00000014
#define TX_CBF_INFO_5_GROUP_ID_LSB                                   25
#define TX_CBF_INFO_5_GROUP_ID_MASK                                  0x7e000000

/* Description		TX_CBF_INFO_5_CBF_RESP_PWR_MGMT
			
			Power management bit of the response CBF frame
*/
#define TX_CBF_INFO_5_CBF_RESP_PWR_MGMT_OFFSET                       0x00000014
#define TX_CBF_INFO_5_CBF_RESP_PWR_MGMT_LSB                          31
#define TX_CBF_INFO_5_CBF_RESP_PWR_MGMT_MASK                         0x80000000


#endif // _TX_CBF_INFO_H_
