// Copyright (c) 2014 Qualcomm Atheros, Inc.  All rights reserved.
// $ATH_LICENSE_HW_HDR_C$
//
// DO NOT EDIT!  This file is automatically generated
//               These definitions are tied to a particular hardware layout


#ifndef _MPDU_LIMIT_STATUS_H_
#define _MPDU_LIMIT_STATUS_H_
#if !defined(__ASSEMBLER__)
#endif

// ################ START SUMMARY #################
//
//	Dword	Fields
//	0	num_mpdu_user0[6:0], num_mpdu_user1[13:7], num_mpdu_user2[20:14], reserved[31:21]
//
// ################ END SUMMARY #################

#define NUM_OF_DWORDS_MPDU_LIMIT_STATUS 1

struct mpdu_limit_status {
    volatile uint32_t num_mpdu_user0                  :  7, //[6:0]
                      num_mpdu_user1                  :  7, //[13:7]
                      num_mpdu_user2                  :  7, //[20:14]
                      reserved                        : 11; //[31:21]
};

/*

num_mpdu_user0
			
			Final Number of MPDUs to be transmitted for user0 by TX
			PCU based on the bandwidth selection made
			
			<legal 0-64>

num_mpdu_user1
			
			Final Number of MPDUs to be transmitted for user1 by TX
			PCU based on the bandwidth selection made
			
			<legal 0-64>

num_mpdu_user2
			
			Final Number of MPDUs to be transmitted for user 2 by TX
			PCU based on the bandwidth selection made
			
			<legal 0-64>

reserved
			
			0
*/


/* Description		MPDU_LIMIT_STATUS_0_NUM_MPDU_USER0
			
			Final Number of MPDUs to be transmitted for user0 by TX
			PCU based on the bandwidth selection made
			
			<legal 0-64>
*/
#define MPDU_LIMIT_STATUS_0_NUM_MPDU_USER0_OFFSET                    0x00000000
#define MPDU_LIMIT_STATUS_0_NUM_MPDU_USER0_LSB                       0
#define MPDU_LIMIT_STATUS_0_NUM_MPDU_USER0_MASK                      0x0000007f

/* Description		MPDU_LIMIT_STATUS_0_NUM_MPDU_USER1
			
			Final Number of MPDUs to be transmitted for user1 by TX
			PCU based on the bandwidth selection made
			
			<legal 0-64>
*/
#define MPDU_LIMIT_STATUS_0_NUM_MPDU_USER1_OFFSET                    0x00000000
#define MPDU_LIMIT_STATUS_0_NUM_MPDU_USER1_LSB                       7
#define MPDU_LIMIT_STATUS_0_NUM_MPDU_USER1_MASK                      0x00003f80

/* Description		MPDU_LIMIT_STATUS_0_NUM_MPDU_USER2
			
			Final Number of MPDUs to be transmitted for user 2 by TX
			PCU based on the bandwidth selection made
			
			<legal 0-64>
*/
#define MPDU_LIMIT_STATUS_0_NUM_MPDU_USER2_OFFSET                    0x00000000
#define MPDU_LIMIT_STATUS_0_NUM_MPDU_USER2_LSB                       14
#define MPDU_LIMIT_STATUS_0_NUM_MPDU_USER2_MASK                      0x001fc000

/* Description		MPDU_LIMIT_STATUS_0_RESERVED
			
			0
*/
#define MPDU_LIMIT_STATUS_0_RESERVED_OFFSET                          0x00000000
#define MPDU_LIMIT_STATUS_0_RESERVED_LSB                             21
#define MPDU_LIMIT_STATUS_0_RESERVED_MASK                            0xffe00000


#endif // _MPDU_LIMIT_STATUS_H_
