/*
 * Copyright (c) 2015 Qualcomm Atheros, Inc.
 * All Rights Reserved.
 * Qualcomm Atheros Confidential and Proprietary.
 */

#ifndef __REG_CHIP_TOP_REG_FPGA_MAP_MACRO_H__
#define __REG_CHIP_TOP_REG_FPGA_MAP_MACRO_H__


/* macros for BlueprintGlobalNameSpace::RTC_STATE */
#ifndef __RTC_STATE_MACRO__
#define __RTC_STATE_MACRO__

/* macros for field V */
#define RTC_STATE__V__SHIFT                                                   0
#define RTC_STATE__V__WIDTH                                                   3
#define RTC_STATE__V__MASK                                          0x00000007U
#define RTC_STATE__V__READ(src)                  (u_int32_t)(src) & 0x00000007U

/* macros for field XTAL_COUNT */
#define RTC_STATE__XTAL_COUNT__SHIFT                                          3
#define RTC_STATE__XTAL_COUNT__WIDTH                                         10
#define RTC_STATE__XTAL_COUNT__MASK                                 0x00001ff8U
#define RTC_STATE__XTAL_COUNT__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00001ff8U) >> 3)

/* macros for field COLD_RESET */
#define RTC_STATE__COLD_RESET__SHIFT                                         13
#define RTC_STATE__COLD_RESET__WIDTH                                          1
#define RTC_STATE__COLD_RESET__MASK                                 0x00002000U
#define RTC_STATE__COLD_RESET__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00002000U) >> 13)
#define RTC_STATE__COLD_RESET__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00002000U) | ((u_int32_t)(1) << 13)
#define RTC_STATE__COLD_RESET__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00002000U) | ((u_int32_t)(0) << 13)
#define RTC_STATE__TYPE                                               u_int32_t
#define RTC_STATE__READ                                             0x00003fffU

#endif /* __RTC_STATE_MACRO__ */


/* macros for pcie_local_reg.RTC_STATE */
#define INST_PCIE_LOCAL_REG__RTC_STATE__NUM                                   1

/* macros for BlueprintGlobalNameSpace::PCIE_SOC_WAKE */
#ifndef __PCIE_SOC_WAKE_MACRO__
#define __PCIE_SOC_WAKE_MACRO__

/* macros for field V */
#define PCIE_SOC_WAKE__V__SHIFT                                               0
#define PCIE_SOC_WAKE__V__WIDTH                                               1
#define PCIE_SOC_WAKE__V__MASK                                      0x00000001U
#define PCIE_SOC_WAKE__V__READ(src)              (u_int32_t)(src) & 0x00000001U
#define PCIE_SOC_WAKE__V__WRITE(src)           ((u_int32_t)(src) & 0x00000001U)
#define PCIE_SOC_WAKE__V__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | ((u_int32_t)(src) &\
                    0x00000001U)
#define PCIE_SOC_WAKE__V__VERIFY(src)    (!(((u_int32_t)(src) & ~0x00000001U)))
#define PCIE_SOC_WAKE__V__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(1)
#define PCIE_SOC_WAKE__V__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(0)
#define PCIE_SOC_WAKE__TYPE                                           u_int32_t
#define PCIE_SOC_WAKE__READ                                         0x00000001U
#define PCIE_SOC_WAKE__WRITE                                        0x00000001U

#endif /* __PCIE_SOC_WAKE_MACRO__ */


/* macros for pcie_local_reg.PCIE_SOC_WAKE */
#define INST_PCIE_LOCAL_REG__PCIE_SOC_WAKE__NUM                               1

/* macros for BlueprintGlobalNameSpace::SOC_GLOBAL_RESET */
#ifndef __SOC_GLOBAL_RESET_MACRO__
#define __SOC_GLOBAL_RESET_MACRO__

/* macros for field V */
#define SOC_GLOBAL_RESET__V__SHIFT                                            0
#define SOC_GLOBAL_RESET__V__WIDTH                                            1
#define SOC_GLOBAL_RESET__V__MASK                                   0x00000001U
#define SOC_GLOBAL_RESET__V__READ(src)           (u_int32_t)(src) & 0x00000001U
#define SOC_GLOBAL_RESET__V__WRITE(src)        ((u_int32_t)(src) & 0x00000001U)
#define SOC_GLOBAL_RESET__V__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | ((u_int32_t)(src) &\
                    0x00000001U)
#define SOC_GLOBAL_RESET__V__VERIFY(src) (!(((u_int32_t)(src) & ~0x00000001U)))
#define SOC_GLOBAL_RESET__V__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(1)
#define SOC_GLOBAL_RESET__V__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(0)

/* macros for field MASK_SOC_RST_TO_PCIE_BRIDGE */
#define SOC_GLOBAL_RESET__MASK_SOC_RST_TO_PCIE_BRIDGE__SHIFT                  1
#define SOC_GLOBAL_RESET__MASK_SOC_RST_TO_PCIE_BRIDGE__WIDTH                  1
#define SOC_GLOBAL_RESET__MASK_SOC_RST_TO_PCIE_BRIDGE__MASK         0x00000002U
#define SOC_GLOBAL_RESET__MASK_SOC_RST_TO_PCIE_BRIDGE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000002U) >> 1)
#define SOC_GLOBAL_RESET__MASK_SOC_RST_TO_PCIE_BRIDGE__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 1) & 0x00000002U)
#define SOC_GLOBAL_RESET__MASK_SOC_RST_TO_PCIE_BRIDGE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | (((u_int32_t)(src) <<\
                    1) & 0x00000002U)
#define SOC_GLOBAL_RESET__MASK_SOC_RST_TO_PCIE_BRIDGE__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 1) & ~0x00000002U)))
#define SOC_GLOBAL_RESET__MASK_SOC_RST_TO_PCIE_BRIDGE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | ((u_int32_t)(1) << 1)
#define SOC_GLOBAL_RESET__MASK_SOC_RST_TO_PCIE_BRIDGE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | ((u_int32_t)(0) << 1)
#define SOC_GLOBAL_RESET__TYPE                                        u_int32_t
#define SOC_GLOBAL_RESET__READ                                      0x00000003U
#define SOC_GLOBAL_RESET__WRITE                                     0x00000003U

#endif /* __SOC_GLOBAL_RESET_MACRO__ */


/* macros for pcie_local_reg.SOC_GLOBAL_RESET */
#define INST_PCIE_LOCAL_REG__SOC_GLOBAL_RESET__NUM                            1

/* macros for BlueprintGlobalNameSpace::PCIE_LOCAL_CTRL_OBS_MUX */
#ifndef __PCIE_LOCAL_CTRL_OBS_MUX_MACRO__
#define __PCIE_LOCAL_CTRL_OBS_MUX_MACRO__

/* macros for field SEL */
#define PCIE_LOCAL_CTRL_OBS_MUX__SEL__SHIFT                                   0
#define PCIE_LOCAL_CTRL_OBS_MUX__SEL__WIDTH                                   6
#define PCIE_LOCAL_CTRL_OBS_MUX__SEL__MASK                          0x0000003fU
#define PCIE_LOCAL_CTRL_OBS_MUX__SEL__READ(src)  (u_int32_t)(src) & 0x0000003fU
#define PCIE_LOCAL_CTRL_OBS_MUX__SEL__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x0000003fU)
#define PCIE_LOCAL_CTRL_OBS_MUX__SEL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000003fU) | ((u_int32_t)(src) &\
                    0x0000003fU)
#define PCIE_LOCAL_CTRL_OBS_MUX__SEL__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x0000003fU)))
#define PCIE_LOCAL_CTRL_OBS_MUX__TYPE                                 u_int32_t
#define PCIE_LOCAL_CTRL_OBS_MUX__READ                               0x0000003fU
#define PCIE_LOCAL_CTRL_OBS_MUX__WRITE                              0x0000003fU

#endif /* __PCIE_LOCAL_CTRL_OBS_MUX_MACRO__ */


/* macros for pcie_local_reg.PCIE_LOCAL_CTRL_OBS_MUX */
#define INST_PCIE_LOCAL_REG__PCIE_LOCAL_CTRL_OBS_MUX__NUM                     1

/* macros for BlueprintGlobalNameSpace::PCIE_DEBUG_LOCAL */
#ifndef __PCIE_DEBUG_LOCAL_MACRO__
#define __PCIE_DEBUG_LOCAL_MACRO__

/* macros for field V */
#define PCIE_DEBUG_LOCAL__V__SHIFT                                            0
#define PCIE_DEBUG_LOCAL__V__WIDTH                                           10
#define PCIE_DEBUG_LOCAL__V__MASK                                   0x000003ffU
#define PCIE_DEBUG_LOCAL__V__READ(src)           (u_int32_t)(src) & 0x000003ffU
#define PCIE_DEBUG_LOCAL__TYPE                                        u_int32_t
#define PCIE_DEBUG_LOCAL__READ                                      0x000003ffU

#endif /* __PCIE_DEBUG_LOCAL_MACRO__ */


/* macros for pcie_local_reg.PCIE_DEBUG_LOCAL */
#define INST_PCIE_LOCAL_REG__PCIE_DEBUG_LOCAL__NUM                            1

/* macros for BlueprintGlobalNameSpace::PCIE_BAR_VALID */
#ifndef __PCIE_BAR_VALID_MACRO__
#define __PCIE_BAR_VALID_MACRO__

/* macros for field DBG */
#define PCIE_BAR_VALID__DBG__SHIFT                                            0
#define PCIE_BAR_VALID__DBG__WIDTH                                            1
#define PCIE_BAR_VALID__DBG__MASK                                   0x00000001U
#define PCIE_BAR_VALID__DBG__READ(src)           (u_int32_t)(src) & 0x00000001U
#define PCIE_BAR_VALID__DBG__WRITE(src)        ((u_int32_t)(src) & 0x00000001U)
#define PCIE_BAR_VALID__DBG__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | ((u_int32_t)(src) &\
                    0x00000001U)
#define PCIE_BAR_VALID__DBG__VERIFY(src) (!(((u_int32_t)(src) & ~0x00000001U)))
#define PCIE_BAR_VALID__DBG__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(1)
#define PCIE_BAR_VALID__DBG__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(0)
#define PCIE_BAR_VALID__TYPE                                          u_int32_t
#define PCIE_BAR_VALID__READ                                        0x00000001U
#define PCIE_BAR_VALID__WRITE                                       0x00000001U

#endif /* __PCIE_BAR_VALID_MACRO__ */


/* macros for pcie_local_reg.PCIE_BAR_VALID */
#define INST_PCIE_LOCAL_REG__PCIE_BAR_VALID__NUM                              1

/* macros for BlueprintGlobalNameSpace::PCIE_SOC_RDY_STATUS */
#ifndef __PCIE_SOC_RDY_STATUS_MACRO__
#define __PCIE_SOC_RDY_STATUS_MACRO__

/* macros for field BAR */
#define PCIE_SOC_RDY_STATUS__BAR__SHIFT                                       0
#define PCIE_SOC_RDY_STATUS__BAR__WIDTH                                       1
#define PCIE_SOC_RDY_STATUS__BAR__MASK                              0x00000001U
#define PCIE_SOC_RDY_STATUS__BAR__READ(src)      (u_int32_t)(src) & 0x00000001U
#define PCIE_SOC_RDY_STATUS__BAR__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(1)
#define PCIE_SOC_RDY_STATUS__BAR__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(0)

/* macros for field VAL */
#define PCIE_SOC_RDY_STATUS__VAL__SHIFT                                       1
#define PCIE_SOC_RDY_STATUS__VAL__WIDTH                                      31
#define PCIE_SOC_RDY_STATUS__VAL__MASK                              0xfffffffeU
#define PCIE_SOC_RDY_STATUS__VAL__READ(src) \
                    (((u_int32_t)(src)\
                    & 0xfffffffeU) >> 1)
#define PCIE_SOC_RDY_STATUS__TYPE                                     u_int32_t
#define PCIE_SOC_RDY_STATUS__READ                                   0xffffffffU

#endif /* __PCIE_SOC_RDY_STATUS_MACRO__ */


/* macros for pcie_local_reg.PCIE_SOC_RDY_STATUS */
#define INST_PCIE_LOCAL_REG__PCIE_SOC_RDY_STATUS__NUM                         1

/* macros for BlueprintGlobalNameSpace::settling_time */
#ifndef __SETTLING_TIME_MACRO__
#define __SETTLING_TIME_MACRO__

/* macros for field agc_settling */
#define SETTLING_TIME__AGC_SETTLING__SHIFT                                    0
#define SETTLING_TIME__AGC_SETTLING__WIDTH                                    7
#define SETTLING_TIME__AGC_SETTLING__MASK                           0x0000007fU
#define SETTLING_TIME__AGC_SETTLING__READ(src)   (u_int32_t)(src) & 0x0000007fU
#define SETTLING_TIME__AGC_SETTLING__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x0000007fU)
#define SETTLING_TIME__AGC_SETTLING__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000007fU) | ((u_int32_t)(src) &\
                    0x0000007fU)
#define SETTLING_TIME__AGC_SETTLING__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x0000007fU)))

/* macros for field switch_settling */
#define SETTLING_TIME__SWITCH_SETTLING__SHIFT                                 7
#define SETTLING_TIME__SWITCH_SETTLING__WIDTH                                 7
#define SETTLING_TIME__SWITCH_SETTLING__MASK                        0x00003f80U
#define SETTLING_TIME__SWITCH_SETTLING__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00003f80U) >> 7)
#define SETTLING_TIME__SWITCH_SETTLING__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 7) & 0x00003f80U)
#define SETTLING_TIME__SWITCH_SETTLING__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00003f80U) | (((u_int32_t)(src) <<\
                    7) & 0x00003f80U)
#define SETTLING_TIME__SWITCH_SETTLING__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 7) & ~0x00003f80U)))

/* macros for field lbreset_advance */
#define SETTLING_TIME__LBRESET_ADVANCE__SHIFT                                26
#define SETTLING_TIME__LBRESET_ADVANCE__WIDTH                                 4
#define SETTLING_TIME__LBRESET_ADVANCE__MASK                        0x3c000000U
#define SETTLING_TIME__LBRESET_ADVANCE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x3c000000U) >> 26)
#define SETTLING_TIME__LBRESET_ADVANCE__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 26) & 0x3c000000U)
#define SETTLING_TIME__LBRESET_ADVANCE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x3c000000U) | (((u_int32_t)(src) <<\
                    26) & 0x3c000000U)
#define SETTLING_TIME__LBRESET_ADVANCE__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 26) & ~0x3c000000U)))
#define SETTLING_TIME__TYPE                                           u_int32_t
#define SETTLING_TIME__READ                                         0x3c003fffU
#define SETTLING_TIME__WRITE                                        0x3c003fffU

#endif /* __SETTLING_TIME_MACRO__ */


/* macros for bb_reg_map.bb_agc_reg_map.BB_settling_time */
#define INST_BB_REG_MAP__BB_AGC_REG_MAP__BB_SETTLING_TIME__NUM                1

/* macros for BlueprintGlobalNameSpace::gain_force_max_gains_b0 */
#ifndef __GAIN_FORCE_MAX_GAINS_B0_MACRO__
#define __GAIN_FORCE_MAX_GAINS_B0_MACRO__

/* macros for field rf_gain_f_0 */
#define GAIN_FORCE_MAX_GAINS_B0__RF_GAIN_F_0__SHIFT                           0
#define GAIN_FORCE_MAX_GAINS_B0__RF_GAIN_F_0__WIDTH                           8
#define GAIN_FORCE_MAX_GAINS_B0__RF_GAIN_F_0__MASK                  0x000000ffU
#define GAIN_FORCE_MAX_GAINS_B0__RF_GAIN_F_0__READ(src) \
                    (u_int32_t)(src)\
                    & 0x000000ffU
#define GAIN_FORCE_MAX_GAINS_B0__RF_GAIN_F_0__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x000000ffU)
#define GAIN_FORCE_MAX_GAINS_B0__RF_GAIN_F_0__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000000ffU) | ((u_int32_t)(src) &\
                    0x000000ffU)
#define GAIN_FORCE_MAX_GAINS_B0__RF_GAIN_F_0__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x000000ffU)))

/* macros for field mb_gain_f_0 */
#define GAIN_FORCE_MAX_GAINS_B0__MB_GAIN_F_0__SHIFT                           8
#define GAIN_FORCE_MAX_GAINS_B0__MB_GAIN_F_0__WIDTH                           8
#define GAIN_FORCE_MAX_GAINS_B0__MB_GAIN_F_0__MASK                  0x0000ff00U
#define GAIN_FORCE_MAX_GAINS_B0__MB_GAIN_F_0__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0000ff00U) >> 8)
#define GAIN_FORCE_MAX_GAINS_B0__MB_GAIN_F_0__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 8) & 0x0000ff00U)
#define GAIN_FORCE_MAX_GAINS_B0__MB_GAIN_F_0__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000ff00U) | (((u_int32_t)(src) <<\
                    8) & 0x0000ff00U)
#define GAIN_FORCE_MAX_GAINS_B0__MB_GAIN_F_0__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 8) & ~0x0000ff00U)))

/* macros for field xatten1_sw_f_0 */
#define GAIN_FORCE_MAX_GAINS_B0__XATTEN1_SW_F_0__SHIFT                       16
#define GAIN_FORCE_MAX_GAINS_B0__XATTEN1_SW_F_0__WIDTH                        1
#define GAIN_FORCE_MAX_GAINS_B0__XATTEN1_SW_F_0__MASK               0x00010000U
#define GAIN_FORCE_MAX_GAINS_B0__XATTEN1_SW_F_0__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00010000U) >> 16)
#define GAIN_FORCE_MAX_GAINS_B0__XATTEN1_SW_F_0__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 16) & 0x00010000U)
#define GAIN_FORCE_MAX_GAINS_B0__XATTEN1_SW_F_0__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00010000U) | (((u_int32_t)(src) <<\
                    16) & 0x00010000U)
#define GAIN_FORCE_MAX_GAINS_B0__XATTEN1_SW_F_0__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 16) & ~0x00010000U)))
#define GAIN_FORCE_MAX_GAINS_B0__XATTEN1_SW_F_0__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00010000U) | ((u_int32_t)(1) << 16)
#define GAIN_FORCE_MAX_GAINS_B0__XATTEN1_SW_F_0__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00010000U) | ((u_int32_t)(0) << 16)

/* macros for field xatten2_sw_f_0 */
#define GAIN_FORCE_MAX_GAINS_B0__XATTEN2_SW_F_0__SHIFT                       17
#define GAIN_FORCE_MAX_GAINS_B0__XATTEN2_SW_F_0__WIDTH                        1
#define GAIN_FORCE_MAX_GAINS_B0__XATTEN2_SW_F_0__MASK               0x00020000U
#define GAIN_FORCE_MAX_GAINS_B0__XATTEN2_SW_F_0__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00020000U) >> 17)
#define GAIN_FORCE_MAX_GAINS_B0__XATTEN2_SW_F_0__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 17) & 0x00020000U)
#define GAIN_FORCE_MAX_GAINS_B0__XATTEN2_SW_F_0__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00020000U) | (((u_int32_t)(src) <<\
                    17) & 0x00020000U)
#define GAIN_FORCE_MAX_GAINS_B0__XATTEN2_SW_F_0__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 17) & ~0x00020000U)))
#define GAIN_FORCE_MAX_GAINS_B0__XATTEN2_SW_F_0__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00020000U) | ((u_int32_t)(1) << 17)
#define GAIN_FORCE_MAX_GAINS_B0__XATTEN2_SW_F_0__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00020000U) | ((u_int32_t)(0) << 17)

/* macros for field xatten1_hyst_margin_0 */
#define GAIN_FORCE_MAX_GAINS_B0__XATTEN1_HYST_MARGIN_0__SHIFT                18
#define GAIN_FORCE_MAX_GAINS_B0__XATTEN1_HYST_MARGIN_0__WIDTH                 7
#define GAIN_FORCE_MAX_GAINS_B0__XATTEN1_HYST_MARGIN_0__MASK        0x01fc0000U
#define GAIN_FORCE_MAX_GAINS_B0__XATTEN1_HYST_MARGIN_0__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x01fc0000U) >> 18)
#define GAIN_FORCE_MAX_GAINS_B0__XATTEN1_HYST_MARGIN_0__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 18) & 0x01fc0000U)
#define GAIN_FORCE_MAX_GAINS_B0__XATTEN1_HYST_MARGIN_0__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x01fc0000U) | (((u_int32_t)(src) <<\
                    18) & 0x01fc0000U)
#define GAIN_FORCE_MAX_GAINS_B0__XATTEN1_HYST_MARGIN_0__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 18) & ~0x01fc0000U)))

/* macros for field xatten2_hyst_margin_0 */
#define GAIN_FORCE_MAX_GAINS_B0__XATTEN2_HYST_MARGIN_0__SHIFT                25
#define GAIN_FORCE_MAX_GAINS_B0__XATTEN2_HYST_MARGIN_0__WIDTH                 7
#define GAIN_FORCE_MAX_GAINS_B0__XATTEN2_HYST_MARGIN_0__MASK        0xfe000000U
#define GAIN_FORCE_MAX_GAINS_B0__XATTEN2_HYST_MARGIN_0__READ(src) \
                    (((u_int32_t)(src)\
                    & 0xfe000000U) >> 25)
#define GAIN_FORCE_MAX_GAINS_B0__XATTEN2_HYST_MARGIN_0__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 25) & 0xfe000000U)
#define GAIN_FORCE_MAX_GAINS_B0__XATTEN2_HYST_MARGIN_0__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xfe000000U) | (((u_int32_t)(src) <<\
                    25) & 0xfe000000U)
#define GAIN_FORCE_MAX_GAINS_B0__XATTEN2_HYST_MARGIN_0__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 25) & ~0xfe000000U)))
#define GAIN_FORCE_MAX_GAINS_B0__TYPE                                 u_int32_t
#define GAIN_FORCE_MAX_GAINS_B0__READ                               0xffffffffU
#define GAIN_FORCE_MAX_GAINS_B0__WRITE                              0xffffffffU

#endif /* __GAIN_FORCE_MAX_GAINS_B0_MACRO__ */


/* macros for bb_reg_map.bb_agc_reg_map.BB_gain_force_max_gains_b0 */
#define INST_BB_REG_MAP__BB_AGC_REG_MAP__BB_GAIN_FORCE_MAX_GAINS_B0__NUM      1

/* macros for BlueprintGlobalNameSpace::gains_min_offsets */
#ifndef __GAINS_MIN_OFFSETS_MACRO__
#define __GAINS_MIN_OFFSETS_MACRO__

/* macros for field offsetC1 */
#define GAINS_MIN_OFFSETS__OFFSETC1__SHIFT                                    0
#define GAINS_MIN_OFFSETS__OFFSETC1__WIDTH                                    7
#define GAINS_MIN_OFFSETS__OFFSETC1__MASK                           0x0000007fU
#define GAINS_MIN_OFFSETS__OFFSETC1__READ(src)   (u_int32_t)(src) & 0x0000007fU
#define GAINS_MIN_OFFSETS__OFFSETC1__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x0000007fU)
#define GAINS_MIN_OFFSETS__OFFSETC1__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000007fU) | ((u_int32_t)(src) &\
                    0x0000007fU)
#define GAINS_MIN_OFFSETS__OFFSETC1__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x0000007fU)))

/* macros for field offsetC2 */
#define GAINS_MIN_OFFSETS__OFFSETC2__SHIFT                                    7
#define GAINS_MIN_OFFSETS__OFFSETC2__WIDTH                                    5
#define GAINS_MIN_OFFSETS__OFFSETC2__MASK                           0x00000f80U
#define GAINS_MIN_OFFSETS__OFFSETC2__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000f80U) >> 7)
#define GAINS_MIN_OFFSETS__OFFSETC2__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 7) & 0x00000f80U)
#define GAINS_MIN_OFFSETS__OFFSETC2__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000f80U) | (((u_int32_t)(src) <<\
                    7) & 0x00000f80U)
#define GAINS_MIN_OFFSETS__OFFSETC2__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 7) & ~0x00000f80U)))

/* macros for field offsetC3 */
#define GAINS_MIN_OFFSETS__OFFSETC3__SHIFT                                   12
#define GAINS_MIN_OFFSETS__OFFSETC3__WIDTH                                    5
#define GAINS_MIN_OFFSETS__OFFSETC3__MASK                           0x0001f000U
#define GAINS_MIN_OFFSETS__OFFSETC3__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0001f000U) >> 12)
#define GAINS_MIN_OFFSETS__OFFSETC3__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 12) & 0x0001f000U)
#define GAINS_MIN_OFFSETS__OFFSETC3__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0001f000U) | (((u_int32_t)(src) <<\
                    12) & 0x0001f000U)
#define GAINS_MIN_OFFSETS__OFFSETC3__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 12) & ~0x0001f000U)))

/* macros for field gain_force */
#define GAINS_MIN_OFFSETS__GAIN_FORCE__SHIFT                                 17
#define GAINS_MIN_OFFSETS__GAIN_FORCE__WIDTH                                  1
#define GAINS_MIN_OFFSETS__GAIN_FORCE__MASK                         0x00020000U
#define GAINS_MIN_OFFSETS__GAIN_FORCE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00020000U) >> 17)
#define GAINS_MIN_OFFSETS__GAIN_FORCE__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 17) & 0x00020000U)
#define GAINS_MIN_OFFSETS__GAIN_FORCE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00020000U) | (((u_int32_t)(src) <<\
                    17) & 0x00020000U)
#define GAINS_MIN_OFFSETS__GAIN_FORCE__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 17) & ~0x00020000U)))
#define GAINS_MIN_OFFSETS__GAIN_FORCE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00020000U) | ((u_int32_t)(1) << 17)
#define GAINS_MIN_OFFSETS__GAIN_FORCE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00020000U) | ((u_int32_t)(0) << 17)

/* macros for field cf_agc_hist_enable */
#define GAINS_MIN_OFFSETS__CF_AGC_HIST_ENABLE__SHIFT                         18
#define GAINS_MIN_OFFSETS__CF_AGC_HIST_ENABLE__WIDTH                          1
#define GAINS_MIN_OFFSETS__CF_AGC_HIST_ENABLE__MASK                 0x00040000U
#define GAINS_MIN_OFFSETS__CF_AGC_HIST_ENABLE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00040000U) >> 18)
#define GAINS_MIN_OFFSETS__CF_AGC_HIST_ENABLE__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 18) & 0x00040000U)
#define GAINS_MIN_OFFSETS__CF_AGC_HIST_ENABLE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00040000U) | (((u_int32_t)(src) <<\
                    18) & 0x00040000U)
#define GAINS_MIN_OFFSETS__CF_AGC_HIST_ENABLE__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 18) & ~0x00040000U)))
#define GAINS_MIN_OFFSETS__CF_AGC_HIST_ENABLE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00040000U) | ((u_int32_t)(1) << 18)
#define GAINS_MIN_OFFSETS__CF_AGC_HIST_ENABLE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00040000U) | ((u_int32_t)(0) << 18)

/* macros for field cf_agc_hist_gc */
#define GAINS_MIN_OFFSETS__CF_AGC_HIST_GC__SHIFT                             19
#define GAINS_MIN_OFFSETS__CF_AGC_HIST_GC__WIDTH                              1
#define GAINS_MIN_OFFSETS__CF_AGC_HIST_GC__MASK                     0x00080000U
#define GAINS_MIN_OFFSETS__CF_AGC_HIST_GC__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00080000U) >> 19)
#define GAINS_MIN_OFFSETS__CF_AGC_HIST_GC__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 19) & 0x00080000U)
#define GAINS_MIN_OFFSETS__CF_AGC_HIST_GC__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00080000U) | (((u_int32_t)(src) <<\
                    19) & 0x00080000U)
#define GAINS_MIN_OFFSETS__CF_AGC_HIST_GC__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 19) & ~0x00080000U)))
#define GAINS_MIN_OFFSETS__CF_AGC_HIST_GC__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00080000U) | ((u_int32_t)(1) << 19)
#define GAINS_MIN_OFFSETS__CF_AGC_HIST_GC__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00080000U) | ((u_int32_t)(0) << 19)

/* macros for field cf_agc_hist_voting */
#define GAINS_MIN_OFFSETS__CF_AGC_HIST_VOTING__SHIFT                         20
#define GAINS_MIN_OFFSETS__CF_AGC_HIST_VOTING__WIDTH                          1
#define GAINS_MIN_OFFSETS__CF_AGC_HIST_VOTING__MASK                 0x00100000U
#define GAINS_MIN_OFFSETS__CF_AGC_HIST_VOTING__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00100000U) >> 20)
#define GAINS_MIN_OFFSETS__CF_AGC_HIST_VOTING__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 20) & 0x00100000U)
#define GAINS_MIN_OFFSETS__CF_AGC_HIST_VOTING__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00100000U) | (((u_int32_t)(src) <<\
                    20) & 0x00100000U)
#define GAINS_MIN_OFFSETS__CF_AGC_HIST_VOTING__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 20) & ~0x00100000U)))
#define GAINS_MIN_OFFSETS__CF_AGC_HIST_VOTING__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00100000U) | ((u_int32_t)(1) << 20)
#define GAINS_MIN_OFFSETS__CF_AGC_HIST_VOTING__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00100000U) | ((u_int32_t)(0) << 20)

/* macros for field cf_agc_hist_phy_err */
#define GAINS_MIN_OFFSETS__CF_AGC_HIST_PHY_ERR__SHIFT                        21
#define GAINS_MIN_OFFSETS__CF_AGC_HIST_PHY_ERR__WIDTH                         1
#define GAINS_MIN_OFFSETS__CF_AGC_HIST_PHY_ERR__MASK                0x00200000U
#define GAINS_MIN_OFFSETS__CF_AGC_HIST_PHY_ERR__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00200000U) >> 21)
#define GAINS_MIN_OFFSETS__CF_AGC_HIST_PHY_ERR__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 21) & 0x00200000U)
#define GAINS_MIN_OFFSETS__CF_AGC_HIST_PHY_ERR__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00200000U) | (((u_int32_t)(src) <<\
                    21) & 0x00200000U)
#define GAINS_MIN_OFFSETS__CF_AGC_HIST_PHY_ERR__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 21) & ~0x00200000U)))
#define GAINS_MIN_OFFSETS__CF_AGC_HIST_PHY_ERR__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00200000U) | ((u_int32_t)(1) << 21)
#define GAINS_MIN_OFFSETS__CF_AGC_HIST_PHY_ERR__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00200000U) | ((u_int32_t)(0) << 21)

/* macros for field enable_srch_start_gain */
#define GAINS_MIN_OFFSETS__ENABLE_SRCH_START_GAIN__SHIFT                     22
#define GAINS_MIN_OFFSETS__ENABLE_SRCH_START_GAIN__WIDTH                      1
#define GAINS_MIN_OFFSETS__ENABLE_SRCH_START_GAIN__MASK             0x00400000U
#define GAINS_MIN_OFFSETS__ENABLE_SRCH_START_GAIN__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00400000U) >> 22)
#define GAINS_MIN_OFFSETS__ENABLE_SRCH_START_GAIN__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 22) & 0x00400000U)
#define GAINS_MIN_OFFSETS__ENABLE_SRCH_START_GAIN__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00400000U) | (((u_int32_t)(src) <<\
                    22) & 0x00400000U)
#define GAINS_MIN_OFFSETS__ENABLE_SRCH_START_GAIN__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 22) & ~0x00400000U)))
#define GAINS_MIN_OFFSETS__ENABLE_SRCH_START_GAIN__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00400000U) | ((u_int32_t)(1) << 22)
#define GAINS_MIN_OFFSETS__ENABLE_SRCH_START_GAIN__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00400000U) | ((u_int32_t)(0) << 22)

/* macros for field use_fixed_gain */
#define GAINS_MIN_OFFSETS__USE_FIXED_GAIN__SHIFT                             23
#define GAINS_MIN_OFFSETS__USE_FIXED_GAIN__WIDTH                              1
#define GAINS_MIN_OFFSETS__USE_FIXED_GAIN__MASK                     0x00800000U
#define GAINS_MIN_OFFSETS__USE_FIXED_GAIN__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00800000U) >> 23)
#define GAINS_MIN_OFFSETS__USE_FIXED_GAIN__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 23) & 0x00800000U)
#define GAINS_MIN_OFFSETS__USE_FIXED_GAIN__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00800000U) | (((u_int32_t)(src) <<\
                    23) & 0x00800000U)
#define GAINS_MIN_OFFSETS__USE_FIXED_GAIN__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 23) & ~0x00800000U)))
#define GAINS_MIN_OFFSETS__USE_FIXED_GAIN__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00800000U) | ((u_int32_t)(1) << 23)
#define GAINS_MIN_OFFSETS__USE_FIXED_GAIN__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00800000U) | ((u_int32_t)(0) << 23)

/* macros for field enable_ant_fast_gc_ctrl */
#define GAINS_MIN_OFFSETS__ENABLE_ANT_FAST_GC_CTRL__SHIFT                    24
#define GAINS_MIN_OFFSETS__ENABLE_ANT_FAST_GC_CTRL__WIDTH                     1
#define GAINS_MIN_OFFSETS__ENABLE_ANT_FAST_GC_CTRL__MASK            0x01000000U
#define GAINS_MIN_OFFSETS__ENABLE_ANT_FAST_GC_CTRL__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x01000000U) >> 24)
#define GAINS_MIN_OFFSETS__ENABLE_ANT_FAST_GC_CTRL__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 24) & 0x01000000U)
#define GAINS_MIN_OFFSETS__ENABLE_ANT_FAST_GC_CTRL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x01000000U) | (((u_int32_t)(src) <<\
                    24) & 0x01000000U)
#define GAINS_MIN_OFFSETS__ENABLE_ANT_FAST_GC_CTRL__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 24) & ~0x01000000U)))
#define GAINS_MIN_OFFSETS__ENABLE_ANT_FAST_GC_CTRL__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x01000000U) | ((u_int32_t)(1) << 24)
#define GAINS_MIN_OFFSETS__ENABLE_ANT_FAST_GC_CTRL__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x01000000U) | ((u_int32_t)(0) << 24)
#define GAINS_MIN_OFFSETS__TYPE                                       u_int32_t
#define GAINS_MIN_OFFSETS__READ                                     0x01ffffffU
#define GAINS_MIN_OFFSETS__WRITE                                    0x01ffffffU

#endif /* __GAINS_MIN_OFFSETS_MACRO__ */


/* macros for bb_reg_map.bb_agc_reg_map.BB_gains_min_offsets */
#define INST_BB_REG_MAP__BB_AGC_REG_MAP__BB_GAINS_MIN_OFFSETS__NUM            1

/* macros for BlueprintGlobalNameSpace::desired_sigsize */
#ifndef __DESIRED_SIGSIZE_MACRO__
#define __DESIRED_SIGSIZE_MACRO__

/* macros for field adc_desired_size */
#define DESIRED_SIGSIZE__ADC_DESIRED_SIZE__SHIFT                              0
#define DESIRED_SIGSIZE__ADC_DESIRED_SIZE__WIDTH                              8
#define DESIRED_SIGSIZE__ADC_DESIRED_SIZE__MASK                     0x000000ffU
#define DESIRED_SIGSIZE__ADC_DESIRED_SIZE__READ(src) \
                    (u_int32_t)(src)\
                    & 0x000000ffU
#define DESIRED_SIGSIZE__ADC_DESIRED_SIZE__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x000000ffU)
#define DESIRED_SIGSIZE__ADC_DESIRED_SIZE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000000ffU) | ((u_int32_t)(src) &\
                    0x000000ffU)
#define DESIRED_SIGSIZE__ADC_DESIRED_SIZE__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x000000ffU)))

/* macros for field disable_fine_rfsat */
#define DESIRED_SIGSIZE__DISABLE_FINE_RFSAT__SHIFT                            8
#define DESIRED_SIGSIZE__DISABLE_FINE_RFSAT__WIDTH                            1
#define DESIRED_SIGSIZE__DISABLE_FINE_RFSAT__MASK                   0x00000100U
#define DESIRED_SIGSIZE__DISABLE_FINE_RFSAT__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000100U) >> 8)
#define DESIRED_SIGSIZE__DISABLE_FINE_RFSAT__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 8) & 0x00000100U)
#define DESIRED_SIGSIZE__DISABLE_FINE_RFSAT__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000100U) | (((u_int32_t)(src) <<\
                    8) & 0x00000100U)
#define DESIRED_SIGSIZE__DISABLE_FINE_RFSAT__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 8) & ~0x00000100U)))
#define DESIRED_SIGSIZE__DISABLE_FINE_RFSAT__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000100U) | ((u_int32_t)(1) << 8)
#define DESIRED_SIGSIZE__DISABLE_FINE_RFSAT__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000100U) | ((u_int32_t)(0) << 8)

/* macros for field total_desired */
#define DESIRED_SIGSIZE__TOTAL_DESIRED__SHIFT                                20
#define DESIRED_SIGSIZE__TOTAL_DESIRED__WIDTH                                 8
#define DESIRED_SIGSIZE__TOTAL_DESIRED__MASK                        0x0ff00000U
#define DESIRED_SIGSIZE__TOTAL_DESIRED__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0ff00000U) >> 20)
#define DESIRED_SIGSIZE__TOTAL_DESIRED__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 20) & 0x0ff00000U)
#define DESIRED_SIGSIZE__TOTAL_DESIRED__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0ff00000U) | (((u_int32_t)(src) <<\
                    20) & 0x0ff00000U)
#define DESIRED_SIGSIZE__TOTAL_DESIRED__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 20) & ~0x0ff00000U)))

/* macros for field init_gc_count_max */
#define DESIRED_SIGSIZE__INIT_GC_COUNT_MAX__SHIFT                            28
#define DESIRED_SIGSIZE__INIT_GC_COUNT_MAX__WIDTH                             2
#define DESIRED_SIGSIZE__INIT_GC_COUNT_MAX__MASK                    0x30000000U
#define DESIRED_SIGSIZE__INIT_GC_COUNT_MAX__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x30000000U) >> 28)
#define DESIRED_SIGSIZE__INIT_GC_COUNT_MAX__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 28) & 0x30000000U)
#define DESIRED_SIGSIZE__INIT_GC_COUNT_MAX__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x30000000U) | (((u_int32_t)(src) <<\
                    28) & 0x30000000U)
#define DESIRED_SIGSIZE__INIT_GC_COUNT_MAX__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 28) & ~0x30000000U)))

/* macros for field reduce_init_gc_count */
#define DESIRED_SIGSIZE__REDUCE_INIT_GC_COUNT__SHIFT                         30
#define DESIRED_SIGSIZE__REDUCE_INIT_GC_COUNT__WIDTH                          1
#define DESIRED_SIGSIZE__REDUCE_INIT_GC_COUNT__MASK                 0x40000000U
#define DESIRED_SIGSIZE__REDUCE_INIT_GC_COUNT__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x40000000U) >> 30)
#define DESIRED_SIGSIZE__REDUCE_INIT_GC_COUNT__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 30) & 0x40000000U)
#define DESIRED_SIGSIZE__REDUCE_INIT_GC_COUNT__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x40000000U) | (((u_int32_t)(src) <<\
                    30) & 0x40000000U)
#define DESIRED_SIGSIZE__REDUCE_INIT_GC_COUNT__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 30) & ~0x40000000U)))
#define DESIRED_SIGSIZE__REDUCE_INIT_GC_COUNT__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x40000000U) | ((u_int32_t)(1) << 30)
#define DESIRED_SIGSIZE__REDUCE_INIT_GC_COUNT__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x40000000U) | ((u_int32_t)(0) << 30)

/* macros for field ena_init_gain */
#define DESIRED_SIGSIZE__ENA_INIT_GAIN__SHIFT                                31
#define DESIRED_SIGSIZE__ENA_INIT_GAIN__WIDTH                                 1
#define DESIRED_SIGSIZE__ENA_INIT_GAIN__MASK                        0x80000000U
#define DESIRED_SIGSIZE__ENA_INIT_GAIN__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x80000000U) >> 31)
#define DESIRED_SIGSIZE__ENA_INIT_GAIN__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 31) & 0x80000000U)
#define DESIRED_SIGSIZE__ENA_INIT_GAIN__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x80000000U) | (((u_int32_t)(src) <<\
                    31) & 0x80000000U)
#define DESIRED_SIGSIZE__ENA_INIT_GAIN__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 31) & ~0x80000000U)))
#define DESIRED_SIGSIZE__ENA_INIT_GAIN__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x80000000U) | ((u_int32_t)(1) << 31)
#define DESIRED_SIGSIZE__ENA_INIT_GAIN__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x80000000U) | ((u_int32_t)(0) << 31)
#define DESIRED_SIGSIZE__TYPE                                         u_int32_t
#define DESIRED_SIGSIZE__READ                                       0xfff001ffU
#define DESIRED_SIGSIZE__WRITE                                      0xfff001ffU

#endif /* __DESIRED_SIGSIZE_MACRO__ */


/* macros for bb_reg_map.bb_agc_reg_map.BB_desired_sigsize */
#define INST_BB_REG_MAP__BB_AGC_REG_MAP__BB_DESIRED_SIGSIZE__NUM              1

/* macros for BlueprintGlobalNameSpace::find_signal */
#ifndef __FIND_SIGNAL_MACRO__
#define __FIND_SIGNAL_MACRO__

/* macros for field relstep */
#define FIND_SIGNAL__RELSTEP__SHIFT                                           0
#define FIND_SIGNAL__RELSTEP__WIDTH                                           6
#define FIND_SIGNAL__RELSTEP__MASK                                  0x0000003fU
#define FIND_SIGNAL__RELSTEP__READ(src)          (u_int32_t)(src) & 0x0000003fU
#define FIND_SIGNAL__RELSTEP__WRITE(src)       ((u_int32_t)(src) & 0x0000003fU)
#define FIND_SIGNAL__RELSTEP__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000003fU) | ((u_int32_t)(src) &\
                    0x0000003fU)
#define FIND_SIGNAL__RELSTEP__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x0000003fU)))

/* macros for field firstep */
#define FIND_SIGNAL__FIRSTEP__SHIFT                                          12
#define FIND_SIGNAL__FIRSTEP__WIDTH                                           6
#define FIND_SIGNAL__FIRSTEP__MASK                                  0x0003f000U
#define FIND_SIGNAL__FIRSTEP__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0003f000U) >> 12)
#define FIND_SIGNAL__FIRSTEP__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 12) & 0x0003f000U)
#define FIND_SIGNAL__FIRSTEP__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0003f000U) | (((u_int32_t)(src) <<\
                    12) & 0x0003f000U)
#define FIND_SIGNAL__FIRSTEP__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 12) & ~0x0003f000U)))

/* macros for field firpwr */
#define FIND_SIGNAL__FIRPWR__SHIFT                                           18
#define FIND_SIGNAL__FIRPWR__WIDTH                                            8
#define FIND_SIGNAL__FIRPWR__MASK                                   0x03fc0000U
#define FIND_SIGNAL__FIRPWR__READ(src) (((u_int32_t)(src) & 0x03fc0000U) >> 18)
#define FIND_SIGNAL__FIRPWR__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 18) & 0x03fc0000U)
#define FIND_SIGNAL__FIRPWR__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x03fc0000U) | (((u_int32_t)(src) <<\
                    18) & 0x03fc0000U)
#define FIND_SIGNAL__FIRPWR__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 18) & ~0x03fc0000U)))

/* macros for field m1count_max */
#define FIND_SIGNAL__M1COUNT_MAX__SHIFT                                      26
#define FIND_SIGNAL__M1COUNT_MAX__WIDTH                                       6
#define FIND_SIGNAL__M1COUNT_MAX__MASK                              0xfc000000U
#define FIND_SIGNAL__M1COUNT_MAX__READ(src) \
                    (((u_int32_t)(src)\
                    & 0xfc000000U) >> 26)
#define FIND_SIGNAL__M1COUNT_MAX__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 26) & 0xfc000000U)
#define FIND_SIGNAL__M1COUNT_MAX__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xfc000000U) | (((u_int32_t)(src) <<\
                    26) & 0xfc000000U)
#define FIND_SIGNAL__M1COUNT_MAX__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 26) & ~0xfc000000U)))
#define FIND_SIGNAL__TYPE                                             u_int32_t
#define FIND_SIGNAL__READ                                           0xfffff03fU
#define FIND_SIGNAL__WRITE                                          0xfffff03fU

#endif /* __FIND_SIGNAL_MACRO__ */


/* macros for bb_reg_map.bb_agc_reg_map.BB_find_signal */
#define INST_BB_REG_MAP__BB_AGC_REG_MAP__BB_FIND_SIGNAL__NUM                  1

/* macros for BlueprintGlobalNameSpace::agc */
#ifndef __AGC_MACRO__
#define __AGC_MACRO__

/* macros for field coarsepwr_const */
#define AGC__COARSEPWR_CONST__SHIFT                                           0
#define AGC__COARSEPWR_CONST__WIDTH                                           7
#define AGC__COARSEPWR_CONST__MASK                                  0x0000007fU
#define AGC__COARSEPWR_CONST__READ(src)          (u_int32_t)(src) & 0x0000007fU
#define AGC__COARSEPWR_CONST__WRITE(src)       ((u_int32_t)(src) & 0x0000007fU)
#define AGC__COARSEPWR_CONST__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000007fU) | ((u_int32_t)(src) &\
                    0x0000007fU)
#define AGC__COARSEPWR_CONST__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x0000007fU)))

/* macros for field coarse_low */
#define AGC__COARSE_LOW__SHIFT                                                7
#define AGC__COARSE_LOW__WIDTH                                                8
#define AGC__COARSE_LOW__MASK                                       0x00007f80U
#define AGC__COARSE_LOW__READ(src)      (((u_int32_t)(src) & 0x00007f80U) >> 7)
#define AGC__COARSE_LOW__WRITE(src)     (((u_int32_t)(src) << 7) & 0x00007f80U)
#define AGC__COARSE_LOW__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00007f80U) | (((u_int32_t)(src) <<\
                    7) & 0x00007f80U)
#define AGC__COARSE_LOW__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 7) & ~0x00007f80U)))

/* macros for field coarse_high */
#define AGC__COARSE_HIGH__SHIFT                                              15
#define AGC__COARSE_HIGH__WIDTH                                               7
#define AGC__COARSE_HIGH__MASK                                      0x003f8000U
#define AGC__COARSE_HIGH__READ(src)    (((u_int32_t)(src) & 0x003f8000U) >> 15)
#define AGC__COARSE_HIGH__WRITE(src)   (((u_int32_t)(src) << 15) & 0x003f8000U)
#define AGC__COARSE_HIGH__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x003f8000U) | (((u_int32_t)(src) <<\
                    15) & 0x003f8000U)
#define AGC__COARSE_HIGH__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 15) & ~0x003f8000U)))

/* macros for field pwrlow_gain_thr */
#define AGC__PWRLOW_GAIN_THR__SHIFT                                          22
#define AGC__PWRLOW_GAIN_THR__WIDTH                                           8
#define AGC__PWRLOW_GAIN_THR__MASK                                  0x3fc00000U
#define AGC__PWRLOW_GAIN_THR__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x3fc00000U) >> 22)
#define AGC__PWRLOW_GAIN_THR__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 22) & 0x3fc00000U)
#define AGC__PWRLOW_GAIN_THR__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x3fc00000U) | (((u_int32_t)(src) <<\
                    22) & 0x3fc00000U)
#define AGC__PWRLOW_GAIN_THR__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 22) & ~0x3fc00000U)))

/* macros for field rssi_out_select */
#define AGC__RSSI_OUT_SELECT__SHIFT                                          30
#define AGC__RSSI_OUT_SELECT__WIDTH                                           2
#define AGC__RSSI_OUT_SELECT__MASK                                  0xc0000000U
#define AGC__RSSI_OUT_SELECT__READ(src) \
                    (((u_int32_t)(src)\
                    & 0xc0000000U) >> 30)
#define AGC__RSSI_OUT_SELECT__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 30) & 0xc0000000U)
#define AGC__RSSI_OUT_SELECT__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xc0000000U) | (((u_int32_t)(src) <<\
                    30) & 0xc0000000U)
#define AGC__RSSI_OUT_SELECT__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 30) & ~0xc0000000U)))
#define AGC__TYPE                                                     u_int32_t
#define AGC__READ                                                   0xffffffffU
#define AGC__WRITE                                                  0xffffffffU

#endif /* __AGC_MACRO__ */


/* macros for bb_reg_map.bb_agc_reg_map.BB_agc */
#define INST_BB_REG_MAP__BB_AGC_REG_MAP__BB_AGC__NUM                          1

/* macros for BlueprintGlobalNameSpace::ext_atten_switch_ctl_b0 */
#ifndef __EXT_ATTEN_SWITCH_CTL_B0_MACRO__
#define __EXT_ATTEN_SWITCH_CTL_B0_MACRO__

/* macros for field xatten1_db_0 */
#define EXT_ATTEN_SWITCH_CTL_B0__XATTEN1_DB_0__SHIFT                          0
#define EXT_ATTEN_SWITCH_CTL_B0__XATTEN1_DB_0__WIDTH                          6
#define EXT_ATTEN_SWITCH_CTL_B0__XATTEN1_DB_0__MASK                 0x0000003fU
#define EXT_ATTEN_SWITCH_CTL_B0__XATTEN1_DB_0__READ(src) \
                    (u_int32_t)(src)\
                    & 0x0000003fU
#define EXT_ATTEN_SWITCH_CTL_B0__XATTEN1_DB_0__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x0000003fU)
#define EXT_ATTEN_SWITCH_CTL_B0__XATTEN1_DB_0__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000003fU) | ((u_int32_t)(src) &\
                    0x0000003fU)
#define EXT_ATTEN_SWITCH_CTL_B0__XATTEN1_DB_0__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x0000003fU)))

/* macros for field xatten2_db_0 */
#define EXT_ATTEN_SWITCH_CTL_B0__XATTEN2_DB_0__SHIFT                          6
#define EXT_ATTEN_SWITCH_CTL_B0__XATTEN2_DB_0__WIDTH                          6
#define EXT_ATTEN_SWITCH_CTL_B0__XATTEN2_DB_0__MASK                 0x00000fc0U
#define EXT_ATTEN_SWITCH_CTL_B0__XATTEN2_DB_0__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000fc0U) >> 6)
#define EXT_ATTEN_SWITCH_CTL_B0__XATTEN2_DB_0__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 6) & 0x00000fc0U)
#define EXT_ATTEN_SWITCH_CTL_B0__XATTEN2_DB_0__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000fc0U) | (((u_int32_t)(src) <<\
                    6) & 0x00000fc0U)
#define EXT_ATTEN_SWITCH_CTL_B0__XATTEN2_DB_0__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 6) & ~0x00000fc0U)))

/* macros for field xatten1_margin_0 */
#define EXT_ATTEN_SWITCH_CTL_B0__XATTEN1_MARGIN_0__SHIFT                     12
#define EXT_ATTEN_SWITCH_CTL_B0__XATTEN1_MARGIN_0__WIDTH                      6
#define EXT_ATTEN_SWITCH_CTL_B0__XATTEN1_MARGIN_0__MASK             0x0003f000U
#define EXT_ATTEN_SWITCH_CTL_B0__XATTEN1_MARGIN_0__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0003f000U) >> 12)
#define EXT_ATTEN_SWITCH_CTL_B0__XATTEN1_MARGIN_0__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 12) & 0x0003f000U)
#define EXT_ATTEN_SWITCH_CTL_B0__XATTEN1_MARGIN_0__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0003f000U) | (((u_int32_t)(src) <<\
                    12) & 0x0003f000U)
#define EXT_ATTEN_SWITCH_CTL_B0__XATTEN1_MARGIN_0__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 12) & ~0x0003f000U)))

/* macros for field xatten2_margin_0 */
#define EXT_ATTEN_SWITCH_CTL_B0__XATTEN2_MARGIN_0__SHIFT                     18
#define EXT_ATTEN_SWITCH_CTL_B0__XATTEN2_MARGIN_0__WIDTH                      6
#define EXT_ATTEN_SWITCH_CTL_B0__XATTEN2_MARGIN_0__MASK             0x00fc0000U
#define EXT_ATTEN_SWITCH_CTL_B0__XATTEN2_MARGIN_0__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00fc0000U) >> 18)
#define EXT_ATTEN_SWITCH_CTL_B0__XATTEN2_MARGIN_0__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 18) & 0x00fc0000U)
#define EXT_ATTEN_SWITCH_CTL_B0__XATTEN2_MARGIN_0__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00fc0000U) | (((u_int32_t)(src) <<\
                    18) & 0x00fc0000U)
#define EXT_ATTEN_SWITCH_CTL_B0__XATTEN2_MARGIN_0__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 18) & ~0x00fc0000U)))

/* macros for field xlna_gain_db_0 */
#define EXT_ATTEN_SWITCH_CTL_B0__XLNA_GAIN_DB_0__SHIFT                       24
#define EXT_ATTEN_SWITCH_CTL_B0__XLNA_GAIN_DB_0__WIDTH                        5
#define EXT_ATTEN_SWITCH_CTL_B0__XLNA_GAIN_DB_0__MASK               0x1f000000U
#define EXT_ATTEN_SWITCH_CTL_B0__XLNA_GAIN_DB_0__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x1f000000U) >> 24)
#define EXT_ATTEN_SWITCH_CTL_B0__XLNA_GAIN_DB_0__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 24) & 0x1f000000U)
#define EXT_ATTEN_SWITCH_CTL_B0__XLNA_GAIN_DB_0__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x1f000000U) | (((u_int32_t)(src) <<\
                    24) & 0x1f000000U)
#define EXT_ATTEN_SWITCH_CTL_B0__XLNA_GAIN_DB_0__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 24) & ~0x1f000000U)))
#define EXT_ATTEN_SWITCH_CTL_B0__TYPE                                 u_int32_t
#define EXT_ATTEN_SWITCH_CTL_B0__READ                               0x1fffffffU
#define EXT_ATTEN_SWITCH_CTL_B0__WRITE                              0x1fffffffU

#endif /* __EXT_ATTEN_SWITCH_CTL_B0_MACRO__ */


/* macros for bb_reg_map.bb_agc_reg_map.BB_ext_atten_switch_ctl_b0 */
#define INST_BB_REG_MAP__BB_AGC_REG_MAP__BB_EXT_ATTEN_SWITCH_CTL_B0__NUM      1

/* macros for BlueprintGlobalNameSpace::cca_b0 */
#ifndef __CCA_B0_MACRO__
#define __CCA_B0_MACRO__

/* macros for field cf_maxCCApwr_0 */
#define CCA_B0__CF_MAXCCAPWR_0__SHIFT                                         0
#define CCA_B0__CF_MAXCCAPWR_0__WIDTH                                         9
#define CCA_B0__CF_MAXCCAPWR_0__MASK                                0x000001ffU
#define CCA_B0__CF_MAXCCAPWR_0__READ(src)        (u_int32_t)(src) & 0x000001ffU
#define CCA_B0__CF_MAXCCAPWR_0__WRITE(src)     ((u_int32_t)(src) & 0x000001ffU)
#define CCA_B0__CF_MAXCCAPWR_0__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000001ffU) | ((u_int32_t)(src) &\
                    0x000001ffU)
#define CCA_B0__CF_MAXCCAPWR_0__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x000001ffU)))

/* macros for field cf_cca_count_maxC */
#define CCA_B0__CF_CCA_COUNT_MAXC__SHIFT                                      9
#define CCA_B0__CF_CCA_COUNT_MAXC__WIDTH                                      3
#define CCA_B0__CF_CCA_COUNT_MAXC__MASK                             0x00000e00U
#define CCA_B0__CF_CCA_COUNT_MAXC__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000e00U) >> 9)
#define CCA_B0__CF_CCA_COUNT_MAXC__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 9) & 0x00000e00U)
#define CCA_B0__CF_CCA_COUNT_MAXC__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000e00U) | (((u_int32_t)(src) <<\
                    9) & 0x00000e00U)
#define CCA_B0__CF_CCA_COUNT_MAXC__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 9) & ~0x00000e00U)))

/* macros for field thr_cca */
#define CCA_B0__THR_CCA__SHIFT                                               12
#define CCA_B0__THR_CCA__WIDTH                                                8
#define CCA_B0__THR_CCA__MASK                                       0x000ff000U
#define CCA_B0__THR_CCA__READ(src)     (((u_int32_t)(src) & 0x000ff000U) >> 12)
#define CCA_B0__THR_CCA__WRITE(src)    (((u_int32_t)(src) << 12) & 0x000ff000U)
#define CCA_B0__THR_CCA__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000ff000U) | (((u_int32_t)(src) <<\
                    12) & 0x000ff000U)
#define CCA_B0__THR_CCA__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 12) & ~0x000ff000U)))

/* macros for field minCCApwr_0 */
#define CCA_B0__MINCCAPWR_0__SHIFT                                           20
#define CCA_B0__MINCCAPWR_0__WIDTH                                            9
#define CCA_B0__MINCCAPWR_0__MASK                                   0x1ff00000U
#define CCA_B0__MINCCAPWR_0__READ(src) (((u_int32_t)(src) & 0x1ff00000U) >> 20)
#define CCA_B0__TYPE                                                  u_int32_t
#define CCA_B0__READ                                                0x1fffffffU
#define CCA_B0__WRITE                                               0x1fffffffU

#endif /* __CCA_B0_MACRO__ */


/* macros for bb_reg_map.bb_agc_reg_map.BB_cca_b0 */
#define INST_BB_REG_MAP__BB_AGC_REG_MAP__BB_CCA_B0__NUM                       1

/* macros for BlueprintGlobalNameSpace::cca_ctrl_2_b0 */
#ifndef __CCA_CTRL_2_B0_MACRO__
#define __CCA_CTRL_2_B0_MACRO__

/* macros for field minCCApwr_thr_0 */
#define CCA_CTRL_2_B0__MINCCAPWR_THR_0__SHIFT                                 0
#define CCA_CTRL_2_B0__MINCCAPWR_THR_0__WIDTH                                 9
#define CCA_CTRL_2_B0__MINCCAPWR_THR_0__MASK                        0x000001ffU
#define CCA_CTRL_2_B0__MINCCAPWR_THR_0__READ(src) \
                    (u_int32_t)(src)\
                    & 0x000001ffU
#define CCA_CTRL_2_B0__MINCCAPWR_THR_0__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x000001ffU)
#define CCA_CTRL_2_B0__MINCCAPWR_THR_0__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000001ffU) | ((u_int32_t)(src) &\
                    0x000001ffU)
#define CCA_CTRL_2_B0__MINCCAPWR_THR_0__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x000001ffU)))

/* macros for field enable_minCCApwr_thr */
#define CCA_CTRL_2_B0__ENABLE_MINCCAPWR_THR__SHIFT                            9
#define CCA_CTRL_2_B0__ENABLE_MINCCAPWR_THR__WIDTH                            1
#define CCA_CTRL_2_B0__ENABLE_MINCCAPWR_THR__MASK                   0x00000200U
#define CCA_CTRL_2_B0__ENABLE_MINCCAPWR_THR__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000200U) >> 9)
#define CCA_CTRL_2_B0__ENABLE_MINCCAPWR_THR__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 9) & 0x00000200U)
#define CCA_CTRL_2_B0__ENABLE_MINCCAPWR_THR__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000200U) | (((u_int32_t)(src) <<\
                    9) & 0x00000200U)
#define CCA_CTRL_2_B0__ENABLE_MINCCAPWR_THR__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 9) & ~0x00000200U)))
#define CCA_CTRL_2_B0__ENABLE_MINCCAPWR_THR__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000200U) | ((u_int32_t)(1) << 9)
#define CCA_CTRL_2_B0__ENABLE_MINCCAPWR_THR__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000200U) | ((u_int32_t)(0) << 9)

/* macros for field NF_gain_comp_0 */
#define CCA_CTRL_2_B0__NF_GAIN_COMP_0__SHIFT                                 10
#define CCA_CTRL_2_B0__NF_GAIN_COMP_0__WIDTH                                  8
#define CCA_CTRL_2_B0__NF_GAIN_COMP_0__MASK                         0x0003fc00U
#define CCA_CTRL_2_B0__NF_GAIN_COMP_0__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0003fc00U) >> 10)
#define CCA_CTRL_2_B0__NF_GAIN_COMP_0__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 10) & 0x0003fc00U)
#define CCA_CTRL_2_B0__NF_GAIN_COMP_0__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0003fc00U) | (((u_int32_t)(src) <<\
                    10) & 0x0003fc00U)
#define CCA_CTRL_2_B0__NF_GAIN_COMP_0__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 10) & ~0x0003fc00U)))

/* macros for field thr_cca_mode */
#define CCA_CTRL_2_B0__THR_CCA_MODE__SHIFT                                   18
#define CCA_CTRL_2_B0__THR_CCA_MODE__WIDTH                                    1
#define CCA_CTRL_2_B0__THR_CCA_MODE__MASK                           0x00040000U
#define CCA_CTRL_2_B0__THR_CCA_MODE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00040000U) >> 18)
#define CCA_CTRL_2_B0__THR_CCA_MODE__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 18) & 0x00040000U)
#define CCA_CTRL_2_B0__THR_CCA_MODE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00040000U) | (((u_int32_t)(src) <<\
                    18) & 0x00040000U)
#define CCA_CTRL_2_B0__THR_CCA_MODE__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 18) & ~0x00040000U)))
#define CCA_CTRL_2_B0__THR_CCA_MODE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00040000U) | ((u_int32_t)(1) << 18)
#define CCA_CTRL_2_B0__THR_CCA_MODE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00040000U) | ((u_int32_t)(0) << 18)

/* macros for field cca_avg_ena */
#define CCA_CTRL_2_B0__CCA_AVG_ENA__SHIFT                                    19
#define CCA_CTRL_2_B0__CCA_AVG_ENA__WIDTH                                     1
#define CCA_CTRL_2_B0__CCA_AVG_ENA__MASK                            0x00080000U
#define CCA_CTRL_2_B0__CCA_AVG_ENA__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00080000U) >> 19)
#define CCA_CTRL_2_B0__CCA_AVG_ENA__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 19) & 0x00080000U)
#define CCA_CTRL_2_B0__CCA_AVG_ENA__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00080000U) | (((u_int32_t)(src) <<\
                    19) & 0x00080000U)
#define CCA_CTRL_2_B0__CCA_AVG_ENA__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 19) & ~0x00080000U)))
#define CCA_CTRL_2_B0__CCA_AVG_ENA__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00080000U) | ((u_int32_t)(1) << 19)
#define CCA_CTRL_2_B0__CCA_AVG_ENA__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00080000U) | ((u_int32_t)(0) << 19)

/* macros for field minCCA_firpwr_thr */
#define CCA_CTRL_2_B0__MINCCA_FIRPWR_THR__SHIFT                              20
#define CCA_CTRL_2_B0__MINCCA_FIRPWR_THR__WIDTH                               8
#define CCA_CTRL_2_B0__MINCCA_FIRPWR_THR__MASK                      0x0ff00000U
#define CCA_CTRL_2_B0__MINCCA_FIRPWR_THR__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0ff00000U) >> 20)
#define CCA_CTRL_2_B0__MINCCA_FIRPWR_THR__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 20) & 0x0ff00000U)
#define CCA_CTRL_2_B0__MINCCA_FIRPWR_THR__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0ff00000U) | (((u_int32_t)(src) <<\
                    20) & 0x0ff00000U)
#define CCA_CTRL_2_B0__MINCCA_FIRPWR_THR__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 20) & ~0x0ff00000U)))

/* macros for field minCCA_same_per_segment */
#define CCA_CTRL_2_B0__MINCCA_SAME_PER_SEGMENT__SHIFT                        28
#define CCA_CTRL_2_B0__MINCCA_SAME_PER_SEGMENT__WIDTH                         1
#define CCA_CTRL_2_B0__MINCCA_SAME_PER_SEGMENT__MASK                0x10000000U
#define CCA_CTRL_2_B0__MINCCA_SAME_PER_SEGMENT__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x10000000U) >> 28)
#define CCA_CTRL_2_B0__MINCCA_SAME_PER_SEGMENT__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 28) & 0x10000000U)
#define CCA_CTRL_2_B0__MINCCA_SAME_PER_SEGMENT__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x10000000U) | (((u_int32_t)(src) <<\
                    28) & 0x10000000U)
#define CCA_CTRL_2_B0__MINCCA_SAME_PER_SEGMENT__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 28) & ~0x10000000U)))
#define CCA_CTRL_2_B0__MINCCA_SAME_PER_SEGMENT__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x10000000U) | ((u_int32_t)(1) << 28)
#define CCA_CTRL_2_B0__MINCCA_SAME_PER_SEGMENT__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x10000000U) | ((u_int32_t)(0) << 28)
#define CCA_CTRL_2_B0__TYPE                                           u_int32_t
#define CCA_CTRL_2_B0__READ                                         0x1fffffffU
#define CCA_CTRL_2_B0__WRITE                                        0x1fffffffU

#endif /* __CCA_CTRL_2_B0_MACRO__ */


/* macros for bb_reg_map.bb_agc_reg_map.BB_cca_ctrl_2_b0 */
#define INST_BB_REG_MAP__BB_AGC_REG_MAP__BB_CCA_CTRL_2_B0__NUM                1

/* macros for BlueprintGlobalNameSpace::restart */
#ifndef __RESTART_MACRO__
#define __RESTART_MACRO__

/* macros for field enable_restart */
#define RESTART__ENABLE_RESTART__SHIFT                                        0
#define RESTART__ENABLE_RESTART__WIDTH                                        1
#define RESTART__ENABLE_RESTART__MASK                               0x00000001U
#define RESTART__ENABLE_RESTART__READ(src)       (u_int32_t)(src) & 0x00000001U
#define RESTART__ENABLE_RESTART__WRITE(src)    ((u_int32_t)(src) & 0x00000001U)
#define RESTART__ENABLE_RESTART__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | ((u_int32_t)(src) &\
                    0x00000001U)
#define RESTART__ENABLE_RESTART__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00000001U)))
#define RESTART__ENABLE_RESTART__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(1)
#define RESTART__ENABLE_RESTART__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(0)

/* macros for field restart_lgfirpwr_delta */
#define RESTART__RESTART_LGFIRPWR_DELTA__SHIFT                                1
#define RESTART__RESTART_LGFIRPWR_DELTA__WIDTH                                5
#define RESTART__RESTART_LGFIRPWR_DELTA__MASK                       0x0000003eU
#define RESTART__RESTART_LGFIRPWR_DELTA__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0000003eU) >> 1)
#define RESTART__RESTART_LGFIRPWR_DELTA__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 1) & 0x0000003eU)
#define RESTART__RESTART_LGFIRPWR_DELTA__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000003eU) | (((u_int32_t)(src) <<\
                    1) & 0x0000003eU)
#define RESTART__RESTART_LGFIRPWR_DELTA__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 1) & ~0x0000003eU)))

/* macros for field enable_pwr_drop_err */
#define RESTART__ENABLE_PWR_DROP_ERR__SHIFT                                   6
#define RESTART__ENABLE_PWR_DROP_ERR__WIDTH                                   1
#define RESTART__ENABLE_PWR_DROP_ERR__MASK                          0x00000040U
#define RESTART__ENABLE_PWR_DROP_ERR__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000040U) >> 6)
#define RESTART__ENABLE_PWR_DROP_ERR__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 6) & 0x00000040U)
#define RESTART__ENABLE_PWR_DROP_ERR__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000040U) | (((u_int32_t)(src) <<\
                    6) & 0x00000040U)
#define RESTART__ENABLE_PWR_DROP_ERR__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 6) & ~0x00000040U)))
#define RESTART__ENABLE_PWR_DROP_ERR__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000040U) | ((u_int32_t)(1) << 6)
#define RESTART__ENABLE_PWR_DROP_ERR__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000040U) | ((u_int32_t)(0) << 6)

/* macros for field pwrdrop_lgfirpwr_delta */
#define RESTART__PWRDROP_LGFIRPWR_DELTA__SHIFT                                7
#define RESTART__PWRDROP_LGFIRPWR_DELTA__WIDTH                                5
#define RESTART__PWRDROP_LGFIRPWR_DELTA__MASK                       0x00000f80U
#define RESTART__PWRDROP_LGFIRPWR_DELTA__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000f80U) >> 7)
#define RESTART__PWRDROP_LGFIRPWR_DELTA__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 7) & 0x00000f80U)
#define RESTART__PWRDROP_LGFIRPWR_DELTA__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000f80U) | (((u_int32_t)(src) <<\
                    7) & 0x00000f80U)
#define RESTART__PWRDROP_LGFIRPWR_DELTA__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 7) & ~0x00000f80U)))

/* macros for field ofdm_cck_rssi_bias */
#define RESTART__OFDM_CCK_RSSI_BIAS__SHIFT                                   12
#define RESTART__OFDM_CCK_RSSI_BIAS__WIDTH                                    6
#define RESTART__OFDM_CCK_RSSI_BIAS__MASK                           0x0003f000U
#define RESTART__OFDM_CCK_RSSI_BIAS__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0003f000U) >> 12)

/* macros for field ant_fast_div_gc_limit */
#define RESTART__ANT_FAST_DIV_GC_LIMIT__SHIFT                                18
#define RESTART__ANT_FAST_DIV_GC_LIMIT__WIDTH                                 3
#define RESTART__ANT_FAST_DIV_GC_LIMIT__MASK                        0x001c0000U
#define RESTART__ANT_FAST_DIV_GC_LIMIT__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x001c0000U) >> 18)
#define RESTART__ANT_FAST_DIV_GC_LIMIT__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 18) & 0x001c0000U)
#define RESTART__ANT_FAST_DIV_GC_LIMIT__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x001c0000U) | (((u_int32_t)(src) <<\
                    18) & 0x001c0000U)
#define RESTART__ANT_FAST_DIV_GC_LIMIT__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 18) & ~0x001c0000U)))

/* macros for field enable_ant_fast_div_m2flag */
#define RESTART__ENABLE_ANT_FAST_DIV_M2FLAG__SHIFT                           21
#define RESTART__ENABLE_ANT_FAST_DIV_M2FLAG__WIDTH                            1
#define RESTART__ENABLE_ANT_FAST_DIV_M2FLAG__MASK                   0x00200000U
#define RESTART__ENABLE_ANT_FAST_DIV_M2FLAG__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00200000U) >> 21)
#define RESTART__ENABLE_ANT_FAST_DIV_M2FLAG__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 21) & 0x00200000U)
#define RESTART__ENABLE_ANT_FAST_DIV_M2FLAG__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00200000U) | (((u_int32_t)(src) <<\
                    21) & 0x00200000U)
#define RESTART__ENABLE_ANT_FAST_DIV_M2FLAG__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 21) & ~0x00200000U)))
#define RESTART__ENABLE_ANT_FAST_DIV_M2FLAG__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00200000U) | ((u_int32_t)(1) << 21)
#define RESTART__ENABLE_ANT_FAST_DIV_M2FLAG__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00200000U) | ((u_int32_t)(0) << 21)

/* macros for field weak_rssi_vote_thr */
#define RESTART__WEAK_RSSI_VOTE_THR__SHIFT                                   22
#define RESTART__WEAK_RSSI_VOTE_THR__WIDTH                                    7
#define RESTART__WEAK_RSSI_VOTE_THR__MASK                           0x1fc00000U
#define RESTART__WEAK_RSSI_VOTE_THR__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x1fc00000U) >> 22)

/* macros for field enable_pwr_drop_err_cck */
#define RESTART__ENABLE_PWR_DROP_ERR_CCK__SHIFT                              29
#define RESTART__ENABLE_PWR_DROP_ERR_CCK__WIDTH                               1
#define RESTART__ENABLE_PWR_DROP_ERR_CCK__MASK                      0x20000000U
#define RESTART__ENABLE_PWR_DROP_ERR_CCK__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x20000000U) >> 29)
#define RESTART__ENABLE_PWR_DROP_ERR_CCK__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x20000000U) | ((u_int32_t)(1) << 29)
#define RESTART__ENABLE_PWR_DROP_ERR_CCK__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x20000000U) | ((u_int32_t)(0) << 29)

/* macros for field dfs_restart_ena */
#define RESTART__DFS_RESTART_ENA__SHIFT                                      30
#define RESTART__DFS_RESTART_ENA__WIDTH                                       1
#define RESTART__DFS_RESTART_ENA__MASK                              0x40000000U
#define RESTART__DFS_RESTART_ENA__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x40000000U) >> 30)
#define RESTART__DFS_RESTART_ENA__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 30) & 0x40000000U)
#define RESTART__DFS_RESTART_ENA__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x40000000U) | (((u_int32_t)(src) <<\
                    30) & 0x40000000U)
#define RESTART__DFS_RESTART_ENA__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 30) & ~0x40000000U)))
#define RESTART__DFS_RESTART_ENA__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x40000000U) | ((u_int32_t)(1) << 30)
#define RESTART__DFS_RESTART_ENA__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x40000000U) | ((u_int32_t)(0) << 30)

/* macros for field dfs_restart_mode */
#define RESTART__DFS_RESTART_MODE__SHIFT                                     31
#define RESTART__DFS_RESTART_MODE__WIDTH                                      1
#define RESTART__DFS_RESTART_MODE__MASK                             0x80000000U
#define RESTART__DFS_RESTART_MODE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x80000000U) >> 31)
#define RESTART__DFS_RESTART_MODE__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 31) & 0x80000000U)
#define RESTART__DFS_RESTART_MODE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x80000000U) | (((u_int32_t)(src) <<\
                    31) & 0x80000000U)
#define RESTART__DFS_RESTART_MODE__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 31) & ~0x80000000U)))
#define RESTART__DFS_RESTART_MODE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x80000000U) | ((u_int32_t)(1) << 31)
#define RESTART__DFS_RESTART_MODE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x80000000U) | ((u_int32_t)(0) << 31)
#define RESTART__TYPE                                                 u_int32_t
#define RESTART__READ                                               0xffffffffU
#define RESTART__WRITE                                              0xffffffffU

#endif /* __RESTART_MACRO__ */


/* macros for bb_reg_map.bb_agc_reg_map.BB_restart */
#define INST_BB_REG_MAP__BB_AGC_REG_MAP__BB_RESTART__NUM                      1

/* macros for BlueprintGlobalNameSpace::multichain_gain_ctrl */
#ifndef __MULTICHAIN_GAIN_CTRL_MACRO__
#define __MULTICHAIN_GAIN_CTRL_MACRO__

/* macros for field enable_check_strong_ant */
#define MULTICHAIN_GAIN_CTRL__ENABLE_CHECK_STRONG_ANT__SHIFT                  8
#define MULTICHAIN_GAIN_CTRL__ENABLE_CHECK_STRONG_ANT__WIDTH                  1
#define MULTICHAIN_GAIN_CTRL__ENABLE_CHECK_STRONG_ANT__MASK         0x00000100U
#define MULTICHAIN_GAIN_CTRL__ENABLE_CHECK_STRONG_ANT__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000100U) >> 8)
#define MULTICHAIN_GAIN_CTRL__ENABLE_CHECK_STRONG_ANT__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 8) & 0x00000100U)
#define MULTICHAIN_GAIN_CTRL__ENABLE_CHECK_STRONG_ANT__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000100U) | (((u_int32_t)(src) <<\
                    8) & 0x00000100U)
#define MULTICHAIN_GAIN_CTRL__ENABLE_CHECK_STRONG_ANT__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 8) & ~0x00000100U)))
#define MULTICHAIN_GAIN_CTRL__ENABLE_CHECK_STRONG_ANT__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000100U) | ((u_int32_t)(1) << 8)
#define MULTICHAIN_GAIN_CTRL__ENABLE_CHECK_STRONG_ANT__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000100U) | ((u_int32_t)(0) << 8)

/* macros for field ant_fast_div_bias */
#define MULTICHAIN_GAIN_CTRL__ANT_FAST_DIV_BIAS__SHIFT                        9
#define MULTICHAIN_GAIN_CTRL__ANT_FAST_DIV_BIAS__WIDTH                        6
#define MULTICHAIN_GAIN_CTRL__ANT_FAST_DIV_BIAS__MASK               0x00007e00U
#define MULTICHAIN_GAIN_CTRL__ANT_FAST_DIV_BIAS__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00007e00U) >> 9)
#define MULTICHAIN_GAIN_CTRL__ANT_FAST_DIV_BIAS__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 9) & 0x00007e00U)
#define MULTICHAIN_GAIN_CTRL__ANT_FAST_DIV_BIAS__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00007e00U) | (((u_int32_t)(src) <<\
                    9) & 0x00007e00U)
#define MULTICHAIN_GAIN_CTRL__ANT_FAST_DIV_BIAS__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 9) & ~0x00007e00U)))

/* macros for field quant_noise_floor_db */
#define MULTICHAIN_GAIN_CTRL__QUANT_NOISE_FLOOR_DB__SHIFT                    15
#define MULTICHAIN_GAIN_CTRL__QUANT_NOISE_FLOOR_DB__WIDTH                     6
#define MULTICHAIN_GAIN_CTRL__QUANT_NOISE_FLOOR_DB__MASK            0x001f8000U
#define MULTICHAIN_GAIN_CTRL__QUANT_NOISE_FLOOR_DB__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x001f8000U) >> 15)
#define MULTICHAIN_GAIN_CTRL__QUANT_NOISE_FLOOR_DB__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 15) & 0x001f8000U)
#define MULTICHAIN_GAIN_CTRL__QUANT_NOISE_FLOOR_DB__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x001f8000U) | (((u_int32_t)(src) <<\
                    15) & 0x001f8000U)
#define MULTICHAIN_GAIN_CTRL__QUANT_NOISE_FLOOR_DB__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 15) & ~0x001f8000U)))

/* macros for field quant_noise_floor_ena */
#define MULTICHAIN_GAIN_CTRL__QUANT_NOISE_FLOOR_ENA__SHIFT                   21
#define MULTICHAIN_GAIN_CTRL__QUANT_NOISE_FLOOR_ENA__WIDTH                    1
#define MULTICHAIN_GAIN_CTRL__QUANT_NOISE_FLOOR_ENA__MASK           0x00200000U
#define MULTICHAIN_GAIN_CTRL__QUANT_NOISE_FLOOR_ENA__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00200000U) >> 21)
#define MULTICHAIN_GAIN_CTRL__QUANT_NOISE_FLOOR_ENA__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 21) & 0x00200000U)
#define MULTICHAIN_GAIN_CTRL__QUANT_NOISE_FLOOR_ENA__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00200000U) | (((u_int32_t)(src) <<\
                    21) & 0x00200000U)
#define MULTICHAIN_GAIN_CTRL__QUANT_NOISE_FLOOR_ENA__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 21) & ~0x00200000U)))
#define MULTICHAIN_GAIN_CTRL__QUANT_NOISE_FLOOR_ENA__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00200000U) | ((u_int32_t)(1) << 21)
#define MULTICHAIN_GAIN_CTRL__QUANT_NOISE_FLOOR_ENA__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00200000U) | ((u_int32_t)(0) << 21)

/* macros for field enable_ant_sw_rx_prot */
#define MULTICHAIN_GAIN_CTRL__ENABLE_ANT_SW_RX_PROT__SHIFT                   23
#define MULTICHAIN_GAIN_CTRL__ENABLE_ANT_SW_RX_PROT__WIDTH                    1
#define MULTICHAIN_GAIN_CTRL__ENABLE_ANT_SW_RX_PROT__MASK           0x00800000U
#define MULTICHAIN_GAIN_CTRL__ENABLE_ANT_SW_RX_PROT__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00800000U) >> 23)
#define MULTICHAIN_GAIN_CTRL__ENABLE_ANT_SW_RX_PROT__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 23) & 0x00800000U)
#define MULTICHAIN_GAIN_CTRL__ENABLE_ANT_SW_RX_PROT__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00800000U) | (((u_int32_t)(src) <<\
                    23) & 0x00800000U)
#define MULTICHAIN_GAIN_CTRL__ENABLE_ANT_SW_RX_PROT__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 23) & ~0x00800000U)))
#define MULTICHAIN_GAIN_CTRL__ENABLE_ANT_SW_RX_PROT__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00800000U) | ((u_int32_t)(1) << 23)
#define MULTICHAIN_GAIN_CTRL__ENABLE_ANT_SW_RX_PROT__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00800000U) | ((u_int32_t)(0) << 23)

/* macros for field enable_ant_div_lnadiv */
#define MULTICHAIN_GAIN_CTRL__ENABLE_ANT_DIV_LNADIV__SHIFT                   24
#define MULTICHAIN_GAIN_CTRL__ENABLE_ANT_DIV_LNADIV__WIDTH                    1
#define MULTICHAIN_GAIN_CTRL__ENABLE_ANT_DIV_LNADIV__MASK           0x01000000U
#define MULTICHAIN_GAIN_CTRL__ENABLE_ANT_DIV_LNADIV__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x01000000U) >> 24)
#define MULTICHAIN_GAIN_CTRL__ENABLE_ANT_DIV_LNADIV__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 24) & 0x01000000U)
#define MULTICHAIN_GAIN_CTRL__ENABLE_ANT_DIV_LNADIV__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x01000000U) | (((u_int32_t)(src) <<\
                    24) & 0x01000000U)
#define MULTICHAIN_GAIN_CTRL__ENABLE_ANT_DIV_LNADIV__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 24) & ~0x01000000U)))
#define MULTICHAIN_GAIN_CTRL__ENABLE_ANT_DIV_LNADIV__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x01000000U) | ((u_int32_t)(1) << 24)
#define MULTICHAIN_GAIN_CTRL__ENABLE_ANT_DIV_LNADIV__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x01000000U) | ((u_int32_t)(0) << 24)

/* macros for field ant_div_alt_lnaconf */
#define MULTICHAIN_GAIN_CTRL__ANT_DIV_ALT_LNACONF__SHIFT                     25
#define MULTICHAIN_GAIN_CTRL__ANT_DIV_ALT_LNACONF__WIDTH                      2
#define MULTICHAIN_GAIN_CTRL__ANT_DIV_ALT_LNACONF__MASK             0x06000000U
#define MULTICHAIN_GAIN_CTRL__ANT_DIV_ALT_LNACONF__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x06000000U) >> 25)
#define MULTICHAIN_GAIN_CTRL__ANT_DIV_ALT_LNACONF__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 25) & 0x06000000U)
#define MULTICHAIN_GAIN_CTRL__ANT_DIV_ALT_LNACONF__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x06000000U) | (((u_int32_t)(src) <<\
                    25) & 0x06000000U)
#define MULTICHAIN_GAIN_CTRL__ANT_DIV_ALT_LNACONF__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 25) & ~0x06000000U)))

/* macros for field ant_div_main_lnaconf */
#define MULTICHAIN_GAIN_CTRL__ANT_DIV_MAIN_LNACONF__SHIFT                    27
#define MULTICHAIN_GAIN_CTRL__ANT_DIV_MAIN_LNACONF__WIDTH                     2
#define MULTICHAIN_GAIN_CTRL__ANT_DIV_MAIN_LNACONF__MASK            0x18000000U
#define MULTICHAIN_GAIN_CTRL__ANT_DIV_MAIN_LNACONF__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x18000000U) >> 27)
#define MULTICHAIN_GAIN_CTRL__ANT_DIV_MAIN_LNACONF__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 27) & 0x18000000U)
#define MULTICHAIN_GAIN_CTRL__ANT_DIV_MAIN_LNACONF__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x18000000U) | (((u_int32_t)(src) <<\
                    27) & 0x18000000U)
#define MULTICHAIN_GAIN_CTRL__ANT_DIV_MAIN_LNACONF__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 27) & ~0x18000000U)))

/* macros for field ant_div_alt_gaintb */
#define MULTICHAIN_GAIN_CTRL__ANT_DIV_ALT_GAINTB__SHIFT                      29
#define MULTICHAIN_GAIN_CTRL__ANT_DIV_ALT_GAINTB__WIDTH                       1
#define MULTICHAIN_GAIN_CTRL__ANT_DIV_ALT_GAINTB__MASK              0x20000000U
#define MULTICHAIN_GAIN_CTRL__ANT_DIV_ALT_GAINTB__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x20000000U) >> 29)
#define MULTICHAIN_GAIN_CTRL__ANT_DIV_ALT_GAINTB__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 29) & 0x20000000U)
#define MULTICHAIN_GAIN_CTRL__ANT_DIV_ALT_GAINTB__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x20000000U) | (((u_int32_t)(src) <<\
                    29) & 0x20000000U)
#define MULTICHAIN_GAIN_CTRL__ANT_DIV_ALT_GAINTB__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 29) & ~0x20000000U)))
#define MULTICHAIN_GAIN_CTRL__ANT_DIV_ALT_GAINTB__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x20000000U) | ((u_int32_t)(1) << 29)
#define MULTICHAIN_GAIN_CTRL__ANT_DIV_ALT_GAINTB__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x20000000U) | ((u_int32_t)(0) << 29)

/* macros for field ant_div_main_gaintb */
#define MULTICHAIN_GAIN_CTRL__ANT_DIV_MAIN_GAINTB__SHIFT                     30
#define MULTICHAIN_GAIN_CTRL__ANT_DIV_MAIN_GAINTB__WIDTH                      1
#define MULTICHAIN_GAIN_CTRL__ANT_DIV_MAIN_GAINTB__MASK             0x40000000U
#define MULTICHAIN_GAIN_CTRL__ANT_DIV_MAIN_GAINTB__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x40000000U) >> 30)
#define MULTICHAIN_GAIN_CTRL__ANT_DIV_MAIN_GAINTB__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 30) & 0x40000000U)
#define MULTICHAIN_GAIN_CTRL__ANT_DIV_MAIN_GAINTB__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x40000000U) | (((u_int32_t)(src) <<\
                    30) & 0x40000000U)
#define MULTICHAIN_GAIN_CTRL__ANT_DIV_MAIN_GAINTB__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 30) & ~0x40000000U)))
#define MULTICHAIN_GAIN_CTRL__ANT_DIV_MAIN_GAINTB__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x40000000U) | ((u_int32_t)(1) << 30)
#define MULTICHAIN_GAIN_CTRL__ANT_DIV_MAIN_GAINTB__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x40000000U) | ((u_int32_t)(0) << 30)

/* macros for field ant_div_sw_com_lock */
#define MULTICHAIN_GAIN_CTRL__ANT_DIV_SW_COM_LOCK__SHIFT                     31
#define MULTICHAIN_GAIN_CTRL__ANT_DIV_SW_COM_LOCK__WIDTH                      1
#define MULTICHAIN_GAIN_CTRL__ANT_DIV_SW_COM_LOCK__MASK             0x80000000U
#define MULTICHAIN_GAIN_CTRL__ANT_DIV_SW_COM_LOCK__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x80000000U) >> 31)
#define MULTICHAIN_GAIN_CTRL__ANT_DIV_SW_COM_LOCK__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 31) & 0x80000000U)
#define MULTICHAIN_GAIN_CTRL__ANT_DIV_SW_COM_LOCK__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x80000000U) | (((u_int32_t)(src) <<\
                    31) & 0x80000000U)
#define MULTICHAIN_GAIN_CTRL__ANT_DIV_SW_COM_LOCK__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 31) & ~0x80000000U)))
#define MULTICHAIN_GAIN_CTRL__ANT_DIV_SW_COM_LOCK__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x80000000U) | ((u_int32_t)(1) << 31)
#define MULTICHAIN_GAIN_CTRL__ANT_DIV_SW_COM_LOCK__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x80000000U) | ((u_int32_t)(0) << 31)
#define MULTICHAIN_GAIN_CTRL__TYPE                                    u_int32_t
#define MULTICHAIN_GAIN_CTRL__READ                                  0xffbfff00U
#define MULTICHAIN_GAIN_CTRL__WRITE                                 0xffbfff00U

#endif /* __MULTICHAIN_GAIN_CTRL_MACRO__ */


/* macros for bb_reg_map.bb_agc_reg_map.BB_multichain_gain_ctrl */
#define INST_BB_REG_MAP__BB_AGC_REG_MAP__BB_MULTICHAIN_GAIN_CTRL__NUM         1

/* macros for BlueprintGlobalNameSpace::ext_chan_pwr_thr_1 */
#ifndef __EXT_CHAN_PWR_THR_1_MACRO__
#define __EXT_CHAN_PWR_THR_1_MACRO__

/* macros for field thr_cca_ext40 */
#define EXT_CHAN_PWR_THR_1__THR_CCA_EXT40__SHIFT                              0
#define EXT_CHAN_PWR_THR_1__THR_CCA_EXT40__WIDTH                              8
#define EXT_CHAN_PWR_THR_1__THR_CCA_EXT40__MASK                     0x000000ffU
#define EXT_CHAN_PWR_THR_1__THR_CCA_EXT40__READ(src) \
                    (u_int32_t)(src)\
                    & 0x000000ffU
#define EXT_CHAN_PWR_THR_1__THR_CCA_EXT40__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x000000ffU)
#define EXT_CHAN_PWR_THR_1__THR_CCA_EXT40__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000000ffU) | ((u_int32_t)(src) &\
                    0x000000ffU)
#define EXT_CHAN_PWR_THR_1__THR_CCA_EXT40__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x000000ffU)))

/* macros for field ant_div_alt_ant_minGainIdx */
#define EXT_CHAN_PWR_THR_1__ANT_DIV_ALT_ANT_MINGAINIDX__SHIFT                 8
#define EXT_CHAN_PWR_THR_1__ANT_DIV_ALT_ANT_MINGAINIDX__WIDTH                 8
#define EXT_CHAN_PWR_THR_1__ANT_DIV_ALT_ANT_MINGAINIDX__MASK        0x0000ff00U
#define EXT_CHAN_PWR_THR_1__ANT_DIV_ALT_ANT_MINGAINIDX__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0000ff00U) >> 8)
#define EXT_CHAN_PWR_THR_1__ANT_DIV_ALT_ANT_MINGAINIDX__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 8) & 0x0000ff00U)
#define EXT_CHAN_PWR_THR_1__ANT_DIV_ALT_ANT_MINGAINIDX__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000ff00U) | (((u_int32_t)(src) <<\
                    8) & 0x0000ff00U)
#define EXT_CHAN_PWR_THR_1__ANT_DIV_ALT_ANT_MINGAINIDX__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 8) & ~0x0000ff00U)))

/* macros for field ant_div_alt_ant_deltaGainIdx */
#define EXT_CHAN_PWR_THR_1__ANT_DIV_ALT_ANT_DELTAGAINIDX__SHIFT              16
#define EXT_CHAN_PWR_THR_1__ANT_DIV_ALT_ANT_DELTAGAINIDX__WIDTH               5
#define EXT_CHAN_PWR_THR_1__ANT_DIV_ALT_ANT_DELTAGAINIDX__MASK      0x001f0000U
#define EXT_CHAN_PWR_THR_1__ANT_DIV_ALT_ANT_DELTAGAINIDX__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x001f0000U) >> 16)
#define EXT_CHAN_PWR_THR_1__ANT_DIV_ALT_ANT_DELTAGAINIDX__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 16) & 0x001f0000U)
#define EXT_CHAN_PWR_THR_1__ANT_DIV_ALT_ANT_DELTAGAINIDX__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x001f0000U) | (((u_int32_t)(src) <<\
                    16) & 0x001f0000U)
#define EXT_CHAN_PWR_THR_1__ANT_DIV_ALT_ANT_DELTAGAINIDX__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 16) & ~0x001f0000U)))

/* macros for field ant_div_alt_ant_deltaNF */
#define EXT_CHAN_PWR_THR_1__ANT_DIV_ALT_ANT_DELTANF__SHIFT                   21
#define EXT_CHAN_PWR_THR_1__ANT_DIV_ALT_ANT_DELTANF__WIDTH                    6
#define EXT_CHAN_PWR_THR_1__ANT_DIV_ALT_ANT_DELTANF__MASK           0x07e00000U
#define EXT_CHAN_PWR_THR_1__ANT_DIV_ALT_ANT_DELTANF__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x07e00000U) >> 21)
#define EXT_CHAN_PWR_THR_1__ANT_DIV_ALT_ANT_DELTANF__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 21) & 0x07e00000U)
#define EXT_CHAN_PWR_THR_1__ANT_DIV_ALT_ANT_DELTANF__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x07e00000U) | (((u_int32_t)(src) <<\
                    21) & 0x07e00000U)
#define EXT_CHAN_PWR_THR_1__ANT_DIV_ALT_ANT_DELTANF__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 21) & ~0x07e00000U)))
#define EXT_CHAN_PWR_THR_1__TYPE                                      u_int32_t
#define EXT_CHAN_PWR_THR_1__READ                                    0x07ffffffU
#define EXT_CHAN_PWR_THR_1__WRITE                                   0x07ffffffU

#endif /* __EXT_CHAN_PWR_THR_1_MACRO__ */


/* macros for bb_reg_map.bb_agc_reg_map.BB_ext_chan_pwr_thr_1 */
#define INST_BB_REG_MAP__BB_AGC_REG_MAP__BB_EXT_CHAN_PWR_THR_1__NUM           1

/* macros for BlueprintGlobalNameSpace::ext_bw_pwr_thr */
#ifndef __EXT_BW_PWR_THR_MACRO__
#define __EXT_BW_PWR_THR_MACRO__

/* macros for field bw_det_pri20_min_rssi_db */
#define EXT_BW_PWR_THR__BW_DET_PRI20_MIN_RSSI_DB__SHIFT                       0
#define EXT_BW_PWR_THR__BW_DET_PRI20_MIN_RSSI_DB__WIDTH                       6
#define EXT_BW_PWR_THR__BW_DET_PRI20_MIN_RSSI_DB__MASK              0x0000003fU
#define EXT_BW_PWR_THR__BW_DET_PRI20_MIN_RSSI_DB__READ(src) \
                    (u_int32_t)(src)\
                    & 0x0000003fU
#define EXT_BW_PWR_THR__BW_DET_PRI20_MIN_RSSI_DB__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x0000003fU)
#define EXT_BW_PWR_THR__BW_DET_PRI20_MIN_RSSI_DB__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000003fU) | ((u_int32_t)(src) &\
                    0x0000003fU)
#define EXT_BW_PWR_THR__BW_DET_PRI20_MIN_RSSI_DB__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x0000003fU)))

/* macros for field bw_det_ext20_max_delta_db */
#define EXT_BW_PWR_THR__BW_DET_EXT20_MAX_DELTA_DB__SHIFT                      6
#define EXT_BW_PWR_THR__BW_DET_EXT20_MAX_DELTA_DB__WIDTH                      6
#define EXT_BW_PWR_THR__BW_DET_EXT20_MAX_DELTA_DB__MASK             0x00000fc0U
#define EXT_BW_PWR_THR__BW_DET_EXT20_MAX_DELTA_DB__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000fc0U) >> 6)
#define EXT_BW_PWR_THR__BW_DET_EXT20_MAX_DELTA_DB__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 6) & 0x00000fc0U)
#define EXT_BW_PWR_THR__BW_DET_EXT20_MAX_DELTA_DB__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000fc0U) | (((u_int32_t)(src) <<\
                    6) & 0x00000fc0U)
#define EXT_BW_PWR_THR__BW_DET_EXT20_MAX_DELTA_DB__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 6) & ~0x00000fc0U)))

/* macros for field bw_det_ext40_max_delta_db */
#define EXT_BW_PWR_THR__BW_DET_EXT40_MAX_DELTA_DB__SHIFT                     12
#define EXT_BW_PWR_THR__BW_DET_EXT40_MAX_DELTA_DB__WIDTH                      6
#define EXT_BW_PWR_THR__BW_DET_EXT40_MAX_DELTA_DB__MASK             0x0003f000U
#define EXT_BW_PWR_THR__BW_DET_EXT40_MAX_DELTA_DB__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0003f000U) >> 12)
#define EXT_BW_PWR_THR__BW_DET_EXT40_MAX_DELTA_DB__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 12) & 0x0003f000U)
#define EXT_BW_PWR_THR__BW_DET_EXT40_MAX_DELTA_DB__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0003f000U) | (((u_int32_t)(src) <<\
                    12) & 0x0003f000U)
#define EXT_BW_PWR_THR__BW_DET_EXT40_MAX_DELTA_DB__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 12) & ~0x0003f000U)))

/* macros for field minCCA_relpwr_thr */
#define EXT_BW_PWR_THR__MINCCA_RELPWR_THR__SHIFT                             18
#define EXT_BW_PWR_THR__MINCCA_RELPWR_THR__WIDTH                              8
#define EXT_BW_PWR_THR__MINCCA_RELPWR_THR__MASK                     0x03fc0000U
#define EXT_BW_PWR_THR__MINCCA_RELPWR_THR__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x03fc0000U) >> 18)
#define EXT_BW_PWR_THR__MINCCA_RELPWR_THR__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 18) & 0x03fc0000U)
#define EXT_BW_PWR_THR__MINCCA_RELPWR_THR__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x03fc0000U) | (((u_int32_t)(src) <<\
                    18) & 0x03fc0000U)
#define EXT_BW_PWR_THR__MINCCA_RELPWR_THR__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 18) & ~0x03fc0000U)))
#define EXT_BW_PWR_THR__TYPE                                          u_int32_t
#define EXT_BW_PWR_THR__READ                                        0x03ffffffU
#define EXT_BW_PWR_THR__WRITE                                       0x03ffffffU

#endif /* __EXT_BW_PWR_THR_MACRO__ */


/* macros for bb_reg_map.bb_agc_reg_map.BB_ext_bw_pwr_thr */
#define INST_BB_REG_MAP__BB_AGC_REG_MAP__BB_EXT_BW_PWR_THR__NUM               1

/* macros for BlueprintGlobalNameSpace::ext_bw_pwr_thr_2 */
#ifndef __EXT_BW_PWR_THR_2_MACRO__
#define __EXT_BW_PWR_THR_2_MACRO__

/* macros for field bw_det_ext20_min_rssi_db */
#define EXT_BW_PWR_THR_2__BW_DET_EXT20_MIN_RSSI_DB__SHIFT                     0
#define EXT_BW_PWR_THR_2__BW_DET_EXT20_MIN_RSSI_DB__WIDTH                     6
#define EXT_BW_PWR_THR_2__BW_DET_EXT20_MIN_RSSI_DB__MASK            0x0000003fU
#define EXT_BW_PWR_THR_2__BW_DET_EXT20_MIN_RSSI_DB__READ(src) \
                    (u_int32_t)(src)\
                    & 0x0000003fU
#define EXT_BW_PWR_THR_2__BW_DET_EXT20_MIN_RSSI_DB__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x0000003fU)
#define EXT_BW_PWR_THR_2__BW_DET_EXT20_MIN_RSSI_DB__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000003fU) | ((u_int32_t)(src) &\
                    0x0000003fU)
#define EXT_BW_PWR_THR_2__BW_DET_EXT20_MIN_RSSI_DB__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x0000003fU)))

/* macros for field bw_det_ext40_min_rssi_db */
#define EXT_BW_PWR_THR_2__BW_DET_EXT40_MIN_RSSI_DB__SHIFT                     8
#define EXT_BW_PWR_THR_2__BW_DET_EXT40_MIN_RSSI_DB__WIDTH                     6
#define EXT_BW_PWR_THR_2__BW_DET_EXT40_MIN_RSSI_DB__MASK            0x00003f00U
#define EXT_BW_PWR_THR_2__BW_DET_EXT40_MIN_RSSI_DB__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00003f00U) >> 8)
#define EXT_BW_PWR_THR_2__BW_DET_EXT40_MIN_RSSI_DB__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 8) & 0x00003f00U)
#define EXT_BW_PWR_THR_2__BW_DET_EXT40_MIN_RSSI_DB__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00003f00U) | (((u_int32_t)(src) <<\
                    8) & 0x00003f00U)
#define EXT_BW_PWR_THR_2__BW_DET_EXT40_MIN_RSSI_DB__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 8) & ~0x00003f00U)))

/* macros for field thr_cca_ext80 */
#define EXT_BW_PWR_THR_2__THR_CCA_EXT80__SHIFT                               16
#define EXT_BW_PWR_THR_2__THR_CCA_EXT80__WIDTH                                8
#define EXT_BW_PWR_THR_2__THR_CCA_EXT80__MASK                       0x00ff0000U
#define EXT_BW_PWR_THR_2__THR_CCA_EXT80__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00ff0000U) >> 16)
#define EXT_BW_PWR_THR_2__THR_CCA_EXT80__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 16) & 0x00ff0000U)
#define EXT_BW_PWR_THR_2__THR_CCA_EXT80__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00ff0000U) | (((u_int32_t)(src) <<\
                    16) & 0x00ff0000U)
#define EXT_BW_PWR_THR_2__THR_CCA_EXT80__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 16) & ~0x00ff0000U)))
#define EXT_BW_PWR_THR_2__TYPE                                        u_int32_t
#define EXT_BW_PWR_THR_2__READ                                      0x00ff3f3fU
#define EXT_BW_PWR_THR_2__WRITE                                     0x00ff3f3fU

#endif /* __EXT_BW_PWR_THR_2_MACRO__ */


/* macros for bb_reg_map.bb_agc_reg_map.BB_ext_bw_pwr_thr_2 */
#define INST_BB_REG_MAP__BB_AGC_REG_MAP__BB_EXT_BW_PWR_THR_2__NUM             1

/* macros for BlueprintGlobalNameSpace::rifs_srch */
#ifndef __RIFS_SRCH_MACRO__
#define __RIFS_SRCH_MACRO__

/* macros for field init_gain_dB_offset */
#define RIFS_SRCH__INIT_GAIN_DB_OFFSET__SHIFT                                 8
#define RIFS_SRCH__INIT_GAIN_DB_OFFSET__WIDTH                                 8
#define RIFS_SRCH__INIT_GAIN_DB_OFFSET__MASK                        0x0000ff00U
#define RIFS_SRCH__INIT_GAIN_DB_OFFSET__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0000ff00U) >> 8)
#define RIFS_SRCH__INIT_GAIN_DB_OFFSET__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 8) & 0x0000ff00U)
#define RIFS_SRCH__INIT_GAIN_DB_OFFSET__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000ff00U) | (((u_int32_t)(src) <<\
                    8) & 0x0000ff00U)
#define RIFS_SRCH__INIT_GAIN_DB_OFFSET__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 8) & ~0x0000ff00U)))

/* macros for field rifs_init_delay */
#define RIFS_SRCH__RIFS_INIT_DELAY__SHIFT                                    16
#define RIFS_SRCH__RIFS_INIT_DELAY__WIDTH                                    10
#define RIFS_SRCH__RIFS_INIT_DELAY__MASK                            0x03ff0000U
#define RIFS_SRCH__RIFS_INIT_DELAY__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x03ff0000U) >> 16)
#define RIFS_SRCH__RIFS_INIT_DELAY__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 16) & 0x03ff0000U)
#define RIFS_SRCH__RIFS_INIT_DELAY__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x03ff0000U) | (((u_int32_t)(src) <<\
                    16) & 0x03ff0000U)
#define RIFS_SRCH__RIFS_INIT_DELAY__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 16) & ~0x03ff0000U)))

/* macros for field rifs_disable_pwrlow_gc */
#define RIFS_SRCH__RIFS_DISABLE_PWRLOW_GC__SHIFT                             26
#define RIFS_SRCH__RIFS_DISABLE_PWRLOW_GC__WIDTH                              1
#define RIFS_SRCH__RIFS_DISABLE_PWRLOW_GC__MASK                     0x04000000U
#define RIFS_SRCH__RIFS_DISABLE_PWRLOW_GC__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x04000000U) >> 26)
#define RIFS_SRCH__RIFS_DISABLE_PWRLOW_GC__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 26) & 0x04000000U)
#define RIFS_SRCH__RIFS_DISABLE_PWRLOW_GC__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x04000000U) | (((u_int32_t)(src) <<\
                    26) & 0x04000000U)
#define RIFS_SRCH__RIFS_DISABLE_PWRLOW_GC__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 26) & ~0x04000000U)))
#define RIFS_SRCH__RIFS_DISABLE_PWRLOW_GC__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x04000000U) | ((u_int32_t)(1) << 26)
#define RIFS_SRCH__RIFS_DISABLE_PWRLOW_GC__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x04000000U) | ((u_int32_t)(0) << 26)

/* macros for field rifs_disable_cck_det */
#define RIFS_SRCH__RIFS_DISABLE_CCK_DET__SHIFT                               27
#define RIFS_SRCH__RIFS_DISABLE_CCK_DET__WIDTH                                1
#define RIFS_SRCH__RIFS_DISABLE_CCK_DET__MASK                       0x08000000U
#define RIFS_SRCH__RIFS_DISABLE_CCK_DET__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x08000000U) >> 27)
#define RIFS_SRCH__RIFS_DISABLE_CCK_DET__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x08000000U) | ((u_int32_t)(1) << 27)
#define RIFS_SRCH__RIFS_DISABLE_CCK_DET__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x08000000U) | ((u_int32_t)(0) << 27)
#define RIFS_SRCH__TYPE                                               u_int32_t
#define RIFS_SRCH__READ                                             0x0fffff00U
#define RIFS_SRCH__WRITE                                            0x0fffff00U

#endif /* __RIFS_SRCH_MACRO__ */


/* macros for bb_reg_map.bb_agc_reg_map.BB_rifs_srch */
#define INST_BB_REG_MAP__BB_AGC_REG_MAP__BB_RIFS_SRCH__NUM                    1

/* macros for BlueprintGlobalNameSpace::peak_det_ctrl_1 */
#ifndef __PEAK_DET_CTRL_1_MACRO__
#define __PEAK_DET_CTRL_1_MACRO__

/* macros for field use_oc_gain_table */
#define PEAK_DET_CTRL_1__USE_OC_GAIN_TABLE__SHIFT                             0
#define PEAK_DET_CTRL_1__USE_OC_GAIN_TABLE__WIDTH                             1
#define PEAK_DET_CTRL_1__USE_OC_GAIN_TABLE__MASK                    0x00000001U
#define PEAK_DET_CTRL_1__USE_OC_GAIN_TABLE__READ(src) \
                    (u_int32_t)(src)\
                    & 0x00000001U
#define PEAK_DET_CTRL_1__USE_OC_GAIN_TABLE__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x00000001U)
#define PEAK_DET_CTRL_1__USE_OC_GAIN_TABLE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | ((u_int32_t)(src) &\
                    0x00000001U)
#define PEAK_DET_CTRL_1__USE_OC_GAIN_TABLE__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00000001U)))
#define PEAK_DET_CTRL_1__USE_OC_GAIN_TABLE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(1)
#define PEAK_DET_CTRL_1__USE_OC_GAIN_TABLE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(0)

/* macros for field use_peak_det */
#define PEAK_DET_CTRL_1__USE_PEAK_DET__SHIFT                                  1
#define PEAK_DET_CTRL_1__USE_PEAK_DET__WIDTH                                  1
#define PEAK_DET_CTRL_1__USE_PEAK_DET__MASK                         0x00000002U
#define PEAK_DET_CTRL_1__USE_PEAK_DET__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000002U) >> 1)
#define PEAK_DET_CTRL_1__USE_PEAK_DET__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 1) & 0x00000002U)
#define PEAK_DET_CTRL_1__USE_PEAK_DET__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | (((u_int32_t)(src) <<\
                    1) & 0x00000002U)
#define PEAK_DET_CTRL_1__USE_PEAK_DET__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 1) & ~0x00000002U)))
#define PEAK_DET_CTRL_1__USE_PEAK_DET__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | ((u_int32_t)(1) << 1)
#define PEAK_DET_CTRL_1__USE_PEAK_DET__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | ((u_int32_t)(0) << 1)

/* macros for field peak_det_win_len */
#define PEAK_DET_CTRL_1__PEAK_DET_WIN_LEN__SHIFT                              2
#define PEAK_DET_CTRL_1__PEAK_DET_WIN_LEN__WIDTH                              6
#define PEAK_DET_CTRL_1__PEAK_DET_WIN_LEN__MASK                     0x000000fcU
#define PEAK_DET_CTRL_1__PEAK_DET_WIN_LEN__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x000000fcU) >> 2)
#define PEAK_DET_CTRL_1__PEAK_DET_WIN_LEN__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 2) & 0x000000fcU)
#define PEAK_DET_CTRL_1__PEAK_DET_WIN_LEN__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000000fcU) | (((u_int32_t)(src) <<\
                    2) & 0x000000fcU)
#define PEAK_DET_CTRL_1__PEAK_DET_WIN_LEN__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 2) & ~0x000000fcU)))

/* macros for field peak_det_tally_thr_low_0 */
#define PEAK_DET_CTRL_1__PEAK_DET_TALLY_THR_LOW_0__SHIFT                      8
#define PEAK_DET_CTRL_1__PEAK_DET_TALLY_THR_LOW_0__WIDTH                      5
#define PEAK_DET_CTRL_1__PEAK_DET_TALLY_THR_LOW_0__MASK             0x00001f00U
#define PEAK_DET_CTRL_1__PEAK_DET_TALLY_THR_LOW_0__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00001f00U) >> 8)
#define PEAK_DET_CTRL_1__PEAK_DET_TALLY_THR_LOW_0__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 8) & 0x00001f00U)
#define PEAK_DET_CTRL_1__PEAK_DET_TALLY_THR_LOW_0__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00001f00U) | (((u_int32_t)(src) <<\
                    8) & 0x00001f00U)
#define PEAK_DET_CTRL_1__PEAK_DET_TALLY_THR_LOW_0__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 8) & ~0x00001f00U)))

/* macros for field peak_det_tally_thr_med_0 */
#define PEAK_DET_CTRL_1__PEAK_DET_TALLY_THR_MED_0__SHIFT                     13
#define PEAK_DET_CTRL_1__PEAK_DET_TALLY_THR_MED_0__WIDTH                      5
#define PEAK_DET_CTRL_1__PEAK_DET_TALLY_THR_MED_0__MASK             0x0003e000U
#define PEAK_DET_CTRL_1__PEAK_DET_TALLY_THR_MED_0__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0003e000U) >> 13)
#define PEAK_DET_CTRL_1__PEAK_DET_TALLY_THR_MED_0__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 13) & 0x0003e000U)
#define PEAK_DET_CTRL_1__PEAK_DET_TALLY_THR_MED_0__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0003e000U) | (((u_int32_t)(src) <<\
                    13) & 0x0003e000U)
#define PEAK_DET_CTRL_1__PEAK_DET_TALLY_THR_MED_0__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 13) & ~0x0003e000U)))

/* macros for field peak_det_tally_thr_high_0 */
#define PEAK_DET_CTRL_1__PEAK_DET_TALLY_THR_HIGH_0__SHIFT                    18
#define PEAK_DET_CTRL_1__PEAK_DET_TALLY_THR_HIGH_0__WIDTH                     5
#define PEAK_DET_CTRL_1__PEAK_DET_TALLY_THR_HIGH_0__MASK            0x007c0000U
#define PEAK_DET_CTRL_1__PEAK_DET_TALLY_THR_HIGH_0__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x007c0000U) >> 18)
#define PEAK_DET_CTRL_1__PEAK_DET_TALLY_THR_HIGH_0__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 18) & 0x007c0000U)
#define PEAK_DET_CTRL_1__PEAK_DET_TALLY_THR_HIGH_0__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x007c0000U) | (((u_int32_t)(src) <<\
                    18) & 0x007c0000U)
#define PEAK_DET_CTRL_1__PEAK_DET_TALLY_THR_HIGH_0__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 18) & ~0x007c0000U)))

/* macros for field peak_det_settling */
#define PEAK_DET_CTRL_1__PEAK_DET_SETTLING__SHIFT                            23
#define PEAK_DET_CTRL_1__PEAK_DET_SETTLING__WIDTH                             7
#define PEAK_DET_CTRL_1__PEAK_DET_SETTLING__MASK                    0x3f800000U
#define PEAK_DET_CTRL_1__PEAK_DET_SETTLING__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x3f800000U) >> 23)
#define PEAK_DET_CTRL_1__PEAK_DET_SETTLING__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 23) & 0x3f800000U)
#define PEAK_DET_CTRL_1__PEAK_DET_SETTLING__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x3f800000U) | (((u_int32_t)(src) <<\
                    23) & 0x3f800000U)
#define PEAK_DET_CTRL_1__PEAK_DET_SETTLING__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 23) & ~0x3f800000U)))

/* macros for field pwd_pkdet_during_cal */
#define PEAK_DET_CTRL_1__PWD_PKDET_DURING_CAL__SHIFT                         30
#define PEAK_DET_CTRL_1__PWD_PKDET_DURING_CAL__WIDTH                          1
#define PEAK_DET_CTRL_1__PWD_PKDET_DURING_CAL__MASK                 0x40000000U
#define PEAK_DET_CTRL_1__PWD_PKDET_DURING_CAL__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x40000000U) >> 30)
#define PEAK_DET_CTRL_1__PWD_PKDET_DURING_CAL__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 30) & 0x40000000U)
#define PEAK_DET_CTRL_1__PWD_PKDET_DURING_CAL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x40000000U) | (((u_int32_t)(src) <<\
                    30) & 0x40000000U)
#define PEAK_DET_CTRL_1__PWD_PKDET_DURING_CAL__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 30) & ~0x40000000U)))
#define PEAK_DET_CTRL_1__PWD_PKDET_DURING_CAL__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x40000000U) | ((u_int32_t)(1) << 30)
#define PEAK_DET_CTRL_1__PWD_PKDET_DURING_CAL__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x40000000U) | ((u_int32_t)(0) << 30)

/* macros for field pwd_pkdet_during_rx */
#define PEAK_DET_CTRL_1__PWD_PKDET_DURING_RX__SHIFT                          31
#define PEAK_DET_CTRL_1__PWD_PKDET_DURING_RX__WIDTH                           1
#define PEAK_DET_CTRL_1__PWD_PKDET_DURING_RX__MASK                  0x80000000U
#define PEAK_DET_CTRL_1__PWD_PKDET_DURING_RX__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x80000000U) >> 31)
#define PEAK_DET_CTRL_1__PWD_PKDET_DURING_RX__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 31) & 0x80000000U)
#define PEAK_DET_CTRL_1__PWD_PKDET_DURING_RX__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x80000000U) | (((u_int32_t)(src) <<\
                    31) & 0x80000000U)
#define PEAK_DET_CTRL_1__PWD_PKDET_DURING_RX__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 31) & ~0x80000000U)))
#define PEAK_DET_CTRL_1__PWD_PKDET_DURING_RX__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x80000000U) | ((u_int32_t)(1) << 31)
#define PEAK_DET_CTRL_1__PWD_PKDET_DURING_RX__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x80000000U) | ((u_int32_t)(0) << 31)
#define PEAK_DET_CTRL_1__TYPE                                         u_int32_t
#define PEAK_DET_CTRL_1__READ                                       0xffffffffU
#define PEAK_DET_CTRL_1__WRITE                                      0xffffffffU

#endif /* __PEAK_DET_CTRL_1_MACRO__ */


/* macros for bb_reg_map.bb_agc_reg_map.BB_peak_det_ctrl_1 */
#define INST_BB_REG_MAP__BB_AGC_REG_MAP__BB_PEAK_DET_CTRL_1__NUM              1

/* macros for BlueprintGlobalNameSpace::peak_det_ctrl_2 */
#ifndef __PEAK_DET_CTRL_2_MACRO__
#define __PEAK_DET_CTRL_2_MACRO__

/* macros for field rf_gain_drop_db_low_0 */
#define PEAK_DET_CTRL_2__RF_GAIN_DROP_DB_LOW_0__SHIFT                         0
#define PEAK_DET_CTRL_2__RF_GAIN_DROP_DB_LOW_0__WIDTH                         5
#define PEAK_DET_CTRL_2__RF_GAIN_DROP_DB_LOW_0__MASK                0x0000001fU
#define PEAK_DET_CTRL_2__RF_GAIN_DROP_DB_LOW_0__READ(src) \
                    (u_int32_t)(src)\
                    & 0x0000001fU
#define PEAK_DET_CTRL_2__RF_GAIN_DROP_DB_LOW_0__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x0000001fU)
#define PEAK_DET_CTRL_2__RF_GAIN_DROP_DB_LOW_0__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000001fU) | ((u_int32_t)(src) &\
                    0x0000001fU)
#define PEAK_DET_CTRL_2__RF_GAIN_DROP_DB_LOW_0__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x0000001fU)))

/* macros for field rf_gain_drop_db_med_0 */
#define PEAK_DET_CTRL_2__RF_GAIN_DROP_DB_MED_0__SHIFT                         6
#define PEAK_DET_CTRL_2__RF_GAIN_DROP_DB_MED_0__WIDTH                         5
#define PEAK_DET_CTRL_2__RF_GAIN_DROP_DB_MED_0__MASK                0x000007c0U
#define PEAK_DET_CTRL_2__RF_GAIN_DROP_DB_MED_0__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x000007c0U) >> 6)
#define PEAK_DET_CTRL_2__RF_GAIN_DROP_DB_MED_0__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 6) & 0x000007c0U)
#define PEAK_DET_CTRL_2__RF_GAIN_DROP_DB_MED_0__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000007c0U) | (((u_int32_t)(src) <<\
                    6) & 0x000007c0U)
#define PEAK_DET_CTRL_2__RF_GAIN_DROP_DB_MED_0__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 6) & ~0x000007c0U)))

/* macros for field rf_gain_drop_db_high_0 */
#define PEAK_DET_CTRL_2__RF_GAIN_DROP_DB_HIGH_0__SHIFT                       12
#define PEAK_DET_CTRL_2__RF_GAIN_DROP_DB_HIGH_0__WIDTH                        5
#define PEAK_DET_CTRL_2__RF_GAIN_DROP_DB_HIGH_0__MASK               0x0001f000U
#define PEAK_DET_CTRL_2__RF_GAIN_DROP_DB_HIGH_0__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0001f000U) >> 12)
#define PEAK_DET_CTRL_2__RF_GAIN_DROP_DB_HIGH_0__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 12) & 0x0001f000U)
#define PEAK_DET_CTRL_2__RF_GAIN_DROP_DB_HIGH_0__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0001f000U) | (((u_int32_t)(src) <<\
                    12) & 0x0001f000U)
#define PEAK_DET_CTRL_2__RF_GAIN_DROP_DB_HIGH_0__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 12) & ~0x0001f000U)))

/* macros for field rf_gain_drop_db_non_0 */
#define PEAK_DET_CTRL_2__RF_GAIN_DROP_DB_NON_0__SHIFT                        18
#define PEAK_DET_CTRL_2__RF_GAIN_DROP_DB_NON_0__WIDTH                         5
#define PEAK_DET_CTRL_2__RF_GAIN_DROP_DB_NON_0__MASK                0x007c0000U
#define PEAK_DET_CTRL_2__RF_GAIN_DROP_DB_NON_0__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x007c0000U) >> 18)
#define PEAK_DET_CTRL_2__RF_GAIN_DROP_DB_NON_0__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 18) & 0x007c0000U)
#define PEAK_DET_CTRL_2__RF_GAIN_DROP_DB_NON_0__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x007c0000U) | (((u_int32_t)(src) <<\
                    18) & 0x007c0000U)
#define PEAK_DET_CTRL_2__RF_GAIN_DROP_DB_NON_0__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 18) & ~0x007c0000U)))

/* macros for field enable_rfsat_restart */
#define PEAK_DET_CTRL_2__ENABLE_RFSAT_RESTART__SHIFT                         30
#define PEAK_DET_CTRL_2__ENABLE_RFSAT_RESTART__WIDTH                          1
#define PEAK_DET_CTRL_2__ENABLE_RFSAT_RESTART__MASK                 0x40000000U
#define PEAK_DET_CTRL_2__ENABLE_RFSAT_RESTART__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x40000000U) >> 30)
#define PEAK_DET_CTRL_2__ENABLE_RFSAT_RESTART__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 30) & 0x40000000U)
#define PEAK_DET_CTRL_2__ENABLE_RFSAT_RESTART__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x40000000U) | (((u_int32_t)(src) <<\
                    30) & 0x40000000U)
#define PEAK_DET_CTRL_2__ENABLE_RFSAT_RESTART__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 30) & ~0x40000000U)))
#define PEAK_DET_CTRL_2__ENABLE_RFSAT_RESTART__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x40000000U) | ((u_int32_t)(1) << 30)
#define PEAK_DET_CTRL_2__ENABLE_RFSAT_RESTART__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x40000000U) | ((u_int32_t)(0) << 30)

/* macros for field enable_rfsat_strong */
#define PEAK_DET_CTRL_2__ENABLE_RFSAT_STRONG__SHIFT                          31
#define PEAK_DET_CTRL_2__ENABLE_RFSAT_STRONG__WIDTH                           1
#define PEAK_DET_CTRL_2__ENABLE_RFSAT_STRONG__MASK                  0x80000000U
#define PEAK_DET_CTRL_2__ENABLE_RFSAT_STRONG__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x80000000U) >> 31)
#define PEAK_DET_CTRL_2__ENABLE_RFSAT_STRONG__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 31) & 0x80000000U)
#define PEAK_DET_CTRL_2__ENABLE_RFSAT_STRONG__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x80000000U) | (((u_int32_t)(src) <<\
                    31) & 0x80000000U)
#define PEAK_DET_CTRL_2__ENABLE_RFSAT_STRONG__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 31) & ~0x80000000U)))
#define PEAK_DET_CTRL_2__ENABLE_RFSAT_STRONG__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x80000000U) | ((u_int32_t)(1) << 31)
#define PEAK_DET_CTRL_2__ENABLE_RFSAT_STRONG__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x80000000U) | ((u_int32_t)(0) << 31)
#define PEAK_DET_CTRL_2__TYPE                                         u_int32_t
#define PEAK_DET_CTRL_2__READ                                       0xc07df7dfU
#define PEAK_DET_CTRL_2__WRITE                                      0xc07df7dfU

#endif /* __PEAK_DET_CTRL_2_MACRO__ */


/* macros for bb_reg_map.bb_agc_reg_map.BB_peak_det_ctrl_2 */
#define INST_BB_REG_MAP__BB_AGC_REG_MAP__BB_PEAK_DET_CTRL_2__NUM              1

/* macros for BlueprintGlobalNameSpace::rx_gain_bounds_1 */
#ifndef __RX_GAIN_BOUNDS_1_MACRO__
#define __RX_GAIN_BOUNDS_1_MACRO__

/* macros for field rx_max_mb_gain */
#define RX_GAIN_BOUNDS_1__RX_MAX_MB_GAIN__SHIFT                               0
#define RX_GAIN_BOUNDS_1__RX_MAX_MB_GAIN__WIDTH                               8
#define RX_GAIN_BOUNDS_1__RX_MAX_MB_GAIN__MASK                      0x000000ffU
#define RX_GAIN_BOUNDS_1__RX_MAX_MB_GAIN__READ(src) \
                    (u_int32_t)(src)\
                    & 0x000000ffU
#define RX_GAIN_BOUNDS_1__RX_MAX_MB_GAIN__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x000000ffU)
#define RX_GAIN_BOUNDS_1__RX_MAX_MB_GAIN__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000000ffU) | ((u_int32_t)(src) &\
                    0x000000ffU)
#define RX_GAIN_BOUNDS_1__RX_MAX_MB_GAIN__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x000000ffU)))

/* macros for field rx_max_rf_gain_ref */
#define RX_GAIN_BOUNDS_1__RX_MAX_RF_GAIN_REF__SHIFT                           8
#define RX_GAIN_BOUNDS_1__RX_MAX_RF_GAIN_REF__WIDTH                           8
#define RX_GAIN_BOUNDS_1__RX_MAX_RF_GAIN_REF__MASK                  0x0000ff00U
#define RX_GAIN_BOUNDS_1__RX_MAX_RF_GAIN_REF__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0000ff00U) >> 8)
#define RX_GAIN_BOUNDS_1__RX_MAX_RF_GAIN_REF__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 8) & 0x0000ff00U)
#define RX_GAIN_BOUNDS_1__RX_MAX_RF_GAIN_REF__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000ff00U) | (((u_int32_t)(src) <<\
                    8) & 0x0000ff00U)
#define RX_GAIN_BOUNDS_1__RX_MAX_RF_GAIN_REF__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 8) & ~0x0000ff00U)))

/* macros for field rx_max_rf_gain */
#define RX_GAIN_BOUNDS_1__RX_MAX_RF_GAIN__SHIFT                              16
#define RX_GAIN_BOUNDS_1__RX_MAX_RF_GAIN__WIDTH                               8
#define RX_GAIN_BOUNDS_1__RX_MAX_RF_GAIN__MASK                      0x00ff0000U
#define RX_GAIN_BOUNDS_1__RX_MAX_RF_GAIN__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00ff0000U) >> 16)
#define RX_GAIN_BOUNDS_1__RX_MAX_RF_GAIN__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 16) & 0x00ff0000U)
#define RX_GAIN_BOUNDS_1__RX_MAX_RF_GAIN__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00ff0000U) | (((u_int32_t)(src) <<\
                    16) & 0x00ff0000U)
#define RX_GAIN_BOUNDS_1__RX_MAX_RF_GAIN__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 16) & ~0x00ff0000U)))

/* macros for field rx_ocgain_sel_2G */
#define RX_GAIN_BOUNDS_1__RX_OCGAIN_SEL_2G__SHIFT                            24
#define RX_GAIN_BOUNDS_1__RX_OCGAIN_SEL_2G__WIDTH                             1
#define RX_GAIN_BOUNDS_1__RX_OCGAIN_SEL_2G__MASK                    0x01000000U
#define RX_GAIN_BOUNDS_1__RX_OCGAIN_SEL_2G__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x01000000U) >> 24)
#define RX_GAIN_BOUNDS_1__RX_OCGAIN_SEL_2G__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 24) & 0x01000000U)
#define RX_GAIN_BOUNDS_1__RX_OCGAIN_SEL_2G__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x01000000U) | (((u_int32_t)(src) <<\
                    24) & 0x01000000U)
#define RX_GAIN_BOUNDS_1__RX_OCGAIN_SEL_2G__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 24) & ~0x01000000U)))
#define RX_GAIN_BOUNDS_1__RX_OCGAIN_SEL_2G__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x01000000U) | ((u_int32_t)(1) << 24)
#define RX_GAIN_BOUNDS_1__RX_OCGAIN_SEL_2G__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x01000000U) | ((u_int32_t)(0) << 24)

/* macros for field rx_ocgain_sel_5G */
#define RX_GAIN_BOUNDS_1__RX_OCGAIN_SEL_5G__SHIFT                            25
#define RX_GAIN_BOUNDS_1__RX_OCGAIN_SEL_5G__WIDTH                             1
#define RX_GAIN_BOUNDS_1__RX_OCGAIN_SEL_5G__MASK                    0x02000000U
#define RX_GAIN_BOUNDS_1__RX_OCGAIN_SEL_5G__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x02000000U) >> 25)
#define RX_GAIN_BOUNDS_1__RX_OCGAIN_SEL_5G__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 25) & 0x02000000U)
#define RX_GAIN_BOUNDS_1__RX_OCGAIN_SEL_5G__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x02000000U) | (((u_int32_t)(src) <<\
                    25) & 0x02000000U)
#define RX_GAIN_BOUNDS_1__RX_OCGAIN_SEL_5G__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 25) & ~0x02000000U)))
#define RX_GAIN_BOUNDS_1__RX_OCGAIN_SEL_5G__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x02000000U) | ((u_int32_t)(1) << 25)
#define RX_GAIN_BOUNDS_1__RX_OCGAIN_SEL_5G__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x02000000U) | ((u_int32_t)(0) << 25)

/* macros for field rf_mb_gain_delta_max_db */
#define RX_GAIN_BOUNDS_1__RF_MB_GAIN_DELTA_MAX_DB__SHIFT                     26
#define RX_GAIN_BOUNDS_1__RF_MB_GAIN_DELTA_MAX_DB__WIDTH                      6
#define RX_GAIN_BOUNDS_1__RF_MB_GAIN_DELTA_MAX_DB__MASK             0xfc000000U
#define RX_GAIN_BOUNDS_1__RF_MB_GAIN_DELTA_MAX_DB__READ(src) \
                    (((u_int32_t)(src)\
                    & 0xfc000000U) >> 26)
#define RX_GAIN_BOUNDS_1__RF_MB_GAIN_DELTA_MAX_DB__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 26) & 0xfc000000U)
#define RX_GAIN_BOUNDS_1__RF_MB_GAIN_DELTA_MAX_DB__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xfc000000U) | (((u_int32_t)(src) <<\
                    26) & 0xfc000000U)
#define RX_GAIN_BOUNDS_1__RF_MB_GAIN_DELTA_MAX_DB__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 26) & ~0xfc000000U)))
#define RX_GAIN_BOUNDS_1__TYPE                                        u_int32_t
#define RX_GAIN_BOUNDS_1__READ                                      0xffffffffU
#define RX_GAIN_BOUNDS_1__WRITE                                     0xffffffffU

#endif /* __RX_GAIN_BOUNDS_1_MACRO__ */


/* macros for bb_reg_map.bb_agc_reg_map.BB_rx_gain_bounds_1 */
#define INST_BB_REG_MAP__BB_AGC_REG_MAP__BB_RX_GAIN_BOUNDS_1__NUM             1

/* macros for BlueprintGlobalNameSpace::rx_gain_bounds_2 */
#ifndef __RX_GAIN_BOUNDS_2_MACRO__
#define __RX_GAIN_BOUNDS_2_MACRO__

/* macros for field gc_rssi_low_db */
#define RX_GAIN_BOUNDS_2__GC_RSSI_LOW_DB__SHIFT                               0
#define RX_GAIN_BOUNDS_2__GC_RSSI_LOW_DB__WIDTH                               8
#define RX_GAIN_BOUNDS_2__GC_RSSI_LOW_DB__MASK                      0x000000ffU
#define RX_GAIN_BOUNDS_2__GC_RSSI_LOW_DB__READ(src) \
                    (u_int32_t)(src)\
                    & 0x000000ffU
#define RX_GAIN_BOUNDS_2__GC_RSSI_LOW_DB__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x000000ffU)
#define RX_GAIN_BOUNDS_2__GC_RSSI_LOW_DB__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000000ffU) | ((u_int32_t)(src) &\
                    0x000000ffU)
#define RX_GAIN_BOUNDS_2__GC_RSSI_LOW_DB__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x000000ffU)))

/* macros for field rf_gain_ref_base_addr */
#define RX_GAIN_BOUNDS_2__RF_GAIN_REF_BASE_ADDR__SHIFT                        8
#define RX_GAIN_BOUNDS_2__RF_GAIN_REF_BASE_ADDR__WIDTH                        8
#define RX_GAIN_BOUNDS_2__RF_GAIN_REF_BASE_ADDR__MASK               0x0000ff00U
#define RX_GAIN_BOUNDS_2__RF_GAIN_REF_BASE_ADDR__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0000ff00U) >> 8)
#define RX_GAIN_BOUNDS_2__RF_GAIN_REF_BASE_ADDR__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 8) & 0x0000ff00U)
#define RX_GAIN_BOUNDS_2__RF_GAIN_REF_BASE_ADDR__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000ff00U) | (((u_int32_t)(src) <<\
                    8) & 0x0000ff00U)
#define RX_GAIN_BOUNDS_2__RF_GAIN_REF_BASE_ADDR__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 8) & ~0x0000ff00U)))

/* macros for field rf_gain_base_addr */
#define RX_GAIN_BOUNDS_2__RF_GAIN_BASE_ADDR__SHIFT                           16
#define RX_GAIN_BOUNDS_2__RF_GAIN_BASE_ADDR__WIDTH                            8
#define RX_GAIN_BOUNDS_2__RF_GAIN_BASE_ADDR__MASK                   0x00ff0000U
#define RX_GAIN_BOUNDS_2__RF_GAIN_BASE_ADDR__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00ff0000U) >> 16)
#define RX_GAIN_BOUNDS_2__RF_GAIN_BASE_ADDR__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 16) & 0x00ff0000U)
#define RX_GAIN_BOUNDS_2__RF_GAIN_BASE_ADDR__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00ff0000U) | (((u_int32_t)(src) <<\
                    16) & 0x00ff0000U)
#define RX_GAIN_BOUNDS_2__RF_GAIN_BASE_ADDR__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 16) & ~0x00ff0000U)))

/* macros for field rf_gain_div_base_addr */
#define RX_GAIN_BOUNDS_2__RF_GAIN_DIV_BASE_ADDR__SHIFT                       24
#define RX_GAIN_BOUNDS_2__RF_GAIN_DIV_BASE_ADDR__WIDTH                        8
#define RX_GAIN_BOUNDS_2__RF_GAIN_DIV_BASE_ADDR__MASK               0xff000000U
#define RX_GAIN_BOUNDS_2__RF_GAIN_DIV_BASE_ADDR__READ(src) \
                    (((u_int32_t)(src)\
                    & 0xff000000U) >> 24)
#define RX_GAIN_BOUNDS_2__RF_GAIN_DIV_BASE_ADDR__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 24) & 0xff000000U)
#define RX_GAIN_BOUNDS_2__RF_GAIN_DIV_BASE_ADDR__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xff000000U) | (((u_int32_t)(src) <<\
                    24) & 0xff000000U)
#define RX_GAIN_BOUNDS_2__RF_GAIN_DIV_BASE_ADDR__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 24) & ~0xff000000U)))
#define RX_GAIN_BOUNDS_2__TYPE                                        u_int32_t
#define RX_GAIN_BOUNDS_2__READ                                      0xffffffffU
#define RX_GAIN_BOUNDS_2__WRITE                                     0xffffffffU

#endif /* __RX_GAIN_BOUNDS_2_MACRO__ */


/* macros for bb_reg_map.bb_agc_reg_map.BB_rx_gain_bounds_2 */
#define INST_BB_REG_MAP__BB_AGC_REG_MAP__BB_RX_GAIN_BOUNDS_2__NUM             1

/* macros for BlueprintGlobalNameSpace::peak_det_cal_ctrl */
#ifndef __PEAK_DET_CAL_CTRL_MACRO__
#define __PEAK_DET_CAL_CTRL_MACRO__

/* macros for field pkdet_cal_win_thr */
#define PEAK_DET_CAL_CTRL__PKDET_CAL_WIN_THR__SHIFT                           0
#define PEAK_DET_CAL_CTRL__PKDET_CAL_WIN_THR__WIDTH                           7
#define PEAK_DET_CAL_CTRL__PKDET_CAL_WIN_THR__MASK                  0x0000007fU
#define PEAK_DET_CAL_CTRL__PKDET_CAL_WIN_THR__READ(src) \
                    (u_int32_t)(src)\
                    & 0x0000007fU
#define PEAK_DET_CAL_CTRL__PKDET_CAL_WIN_THR__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x0000007fU)
#define PEAK_DET_CAL_CTRL__PKDET_CAL_WIN_THR__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000007fU) | ((u_int32_t)(src) &\
                    0x0000007fU)
#define PEAK_DET_CAL_CTRL__PKDET_CAL_WIN_THR__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x0000007fU)))

/* macros for field pkdet_cal_bias */
#define PEAK_DET_CAL_CTRL__PKDET_CAL_BIAS__SHIFT                              7
#define PEAK_DET_CAL_CTRL__PKDET_CAL_BIAS__WIDTH                              6
#define PEAK_DET_CAL_CTRL__PKDET_CAL_BIAS__MASK                     0x00001f80U
#define PEAK_DET_CAL_CTRL__PKDET_CAL_BIAS__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00001f80U) >> 7)
#define PEAK_DET_CAL_CTRL__PKDET_CAL_BIAS__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 7) & 0x00001f80U)
#define PEAK_DET_CAL_CTRL__PKDET_CAL_BIAS__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00001f80U) | (((u_int32_t)(src) <<\
                    7) & 0x00001f80U)
#define PEAK_DET_CAL_CTRL__PKDET_CAL_BIAS__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 7) & ~0x00001f80U)))

/* macros for field pkdet_cal_meas_time_sel */
#define PEAK_DET_CAL_CTRL__PKDET_CAL_MEAS_TIME_SEL__SHIFT                    13
#define PEAK_DET_CAL_CTRL__PKDET_CAL_MEAS_TIME_SEL__WIDTH                     2
#define PEAK_DET_CAL_CTRL__PKDET_CAL_MEAS_TIME_SEL__MASK            0x00006000U
#define PEAK_DET_CAL_CTRL__PKDET_CAL_MEAS_TIME_SEL__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00006000U) >> 13)
#define PEAK_DET_CAL_CTRL__PKDET_CAL_MEAS_TIME_SEL__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 13) & 0x00006000U)
#define PEAK_DET_CAL_CTRL__PKDET_CAL_MEAS_TIME_SEL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00006000U) | (((u_int32_t)(src) <<\
                    13) & 0x00006000U)
#define PEAK_DET_CAL_CTRL__PKDET_CAL_MEAS_TIME_SEL__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 13) & ~0x00006000U)))
#define PEAK_DET_CAL_CTRL__TYPE                                       u_int32_t
#define PEAK_DET_CAL_CTRL__READ                                     0x00007fffU
#define PEAK_DET_CAL_CTRL__WRITE                                    0x00007fffU

#endif /* __PEAK_DET_CAL_CTRL_MACRO__ */


/* macros for bb_reg_map.bb_agc_reg_map.BB_peak_det_cal_ctrl */
#define INST_BB_REG_MAP__BB_AGC_REG_MAP__BB_PEAK_DET_CAL_CTRL__NUM            1

/* macros for BlueprintGlobalNameSpace::agc_dig_dc_ctrl */
#ifndef __AGC_DIG_DC_CTRL_MACRO__
#define __AGC_DIG_DC_CTRL_MACRO__

/* macros for field use_dig_dc */
#define AGC_DIG_DC_CTRL__USE_DIG_DC__SHIFT                                    0
#define AGC_DIG_DC_CTRL__USE_DIG_DC__WIDTH                                    1
#define AGC_DIG_DC_CTRL__USE_DIG_DC__MASK                           0x00000001U
#define AGC_DIG_DC_CTRL__USE_DIG_DC__READ(src)   (u_int32_t)(src) & 0x00000001U
#define AGC_DIG_DC_CTRL__USE_DIG_DC__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x00000001U)
#define AGC_DIG_DC_CTRL__USE_DIG_DC__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | ((u_int32_t)(src) &\
                    0x00000001U)
#define AGC_DIG_DC_CTRL__USE_DIG_DC__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00000001U)))
#define AGC_DIG_DC_CTRL__USE_DIG_DC__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(1)
#define AGC_DIG_DC_CTRL__USE_DIG_DC__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(0)

/* macros for field dig_dc_switch_cck */
#define AGC_DIG_DC_CTRL__DIG_DC_SWITCH_CCK__SHIFT                            10
#define AGC_DIG_DC_CTRL__DIG_DC_SWITCH_CCK__WIDTH                             1
#define AGC_DIG_DC_CTRL__DIG_DC_SWITCH_CCK__MASK                    0x00000400U
#define AGC_DIG_DC_CTRL__DIG_DC_SWITCH_CCK__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000400U) >> 10)
#define AGC_DIG_DC_CTRL__DIG_DC_SWITCH_CCK__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000400U) | ((u_int32_t)(1) << 10)
#define AGC_DIG_DC_CTRL__DIG_DC_SWITCH_CCK__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000400U) | ((u_int32_t)(0) << 10)
#define AGC_DIG_DC_CTRL__TYPE                                         u_int32_t
#define AGC_DIG_DC_CTRL__READ                                       0x00000401U
#define AGC_DIG_DC_CTRL__WRITE                                      0x00000401U

#endif /* __AGC_DIG_DC_CTRL_MACRO__ */


/* macros for bb_reg_map.bb_agc_reg_map.BB_agc_dig_dc_ctrl */
#define INST_BB_REG_MAP__BB_AGC_REG_MAP__BB_AGC_DIG_DC_CTRL__NUM              1

/* macros for BlueprintGlobalNameSpace::bt_coex_1 */
#ifndef __BT_COEX_1_MACRO__
#define __BT_COEX_1_MACRO__

/* macros for field peak_det_tally_thr_low_1 */
#define BT_COEX_1__PEAK_DET_TALLY_THR_LOW_1__SHIFT                            0
#define BT_COEX_1__PEAK_DET_TALLY_THR_LOW_1__WIDTH                            5
#define BT_COEX_1__PEAK_DET_TALLY_THR_LOW_1__MASK                   0x0000001fU
#define BT_COEX_1__PEAK_DET_TALLY_THR_LOW_1__READ(src) \
                    (u_int32_t)(src)\
                    & 0x0000001fU
#define BT_COEX_1__PEAK_DET_TALLY_THR_LOW_1__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x0000001fU)
#define BT_COEX_1__PEAK_DET_TALLY_THR_LOW_1__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000001fU) | ((u_int32_t)(src) &\
                    0x0000001fU)
#define BT_COEX_1__PEAK_DET_TALLY_THR_LOW_1__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x0000001fU)))

/* macros for field peak_det_tally_thr_med_1 */
#define BT_COEX_1__PEAK_DET_TALLY_THR_MED_1__SHIFT                            5
#define BT_COEX_1__PEAK_DET_TALLY_THR_MED_1__WIDTH                            5
#define BT_COEX_1__PEAK_DET_TALLY_THR_MED_1__MASK                   0x000003e0U
#define BT_COEX_1__PEAK_DET_TALLY_THR_MED_1__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x000003e0U) >> 5)
#define BT_COEX_1__PEAK_DET_TALLY_THR_MED_1__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 5) & 0x000003e0U)
#define BT_COEX_1__PEAK_DET_TALLY_THR_MED_1__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000003e0U) | (((u_int32_t)(src) <<\
                    5) & 0x000003e0U)
#define BT_COEX_1__PEAK_DET_TALLY_THR_MED_1__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 5) & ~0x000003e0U)))

/* macros for field peak_det_tally_thr_high_1 */
#define BT_COEX_1__PEAK_DET_TALLY_THR_HIGH_1__SHIFT                          10
#define BT_COEX_1__PEAK_DET_TALLY_THR_HIGH_1__WIDTH                           5
#define BT_COEX_1__PEAK_DET_TALLY_THR_HIGH_1__MASK                  0x00007c00U
#define BT_COEX_1__PEAK_DET_TALLY_THR_HIGH_1__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00007c00U) >> 10)
#define BT_COEX_1__PEAK_DET_TALLY_THR_HIGH_1__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 10) & 0x00007c00U)
#define BT_COEX_1__PEAK_DET_TALLY_THR_HIGH_1__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00007c00U) | (((u_int32_t)(src) <<\
                    10) & 0x00007c00U)
#define BT_COEX_1__PEAK_DET_TALLY_THR_HIGH_1__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 10) & ~0x00007c00U)))

/* macros for field rf_gain_drop_db_low_1 */
#define BT_COEX_1__RF_GAIN_DROP_DB_LOW_1__SHIFT                              15
#define BT_COEX_1__RF_GAIN_DROP_DB_LOW_1__WIDTH                               5
#define BT_COEX_1__RF_GAIN_DROP_DB_LOW_1__MASK                      0x000f8000U
#define BT_COEX_1__RF_GAIN_DROP_DB_LOW_1__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x000f8000U) >> 15)
#define BT_COEX_1__RF_GAIN_DROP_DB_LOW_1__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 15) & 0x000f8000U)
#define BT_COEX_1__RF_GAIN_DROP_DB_LOW_1__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000f8000U) | (((u_int32_t)(src) <<\
                    15) & 0x000f8000U)
#define BT_COEX_1__RF_GAIN_DROP_DB_LOW_1__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 15) & ~0x000f8000U)))

/* macros for field rf_gain_drop_db_med_1 */
#define BT_COEX_1__RF_GAIN_DROP_DB_MED_1__SHIFT                              20
#define BT_COEX_1__RF_GAIN_DROP_DB_MED_1__WIDTH                               5
#define BT_COEX_1__RF_GAIN_DROP_DB_MED_1__MASK                      0x01f00000U
#define BT_COEX_1__RF_GAIN_DROP_DB_MED_1__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x01f00000U) >> 20)
#define BT_COEX_1__RF_GAIN_DROP_DB_MED_1__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 20) & 0x01f00000U)
#define BT_COEX_1__RF_GAIN_DROP_DB_MED_1__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x01f00000U) | (((u_int32_t)(src) <<\
                    20) & 0x01f00000U)
#define BT_COEX_1__RF_GAIN_DROP_DB_MED_1__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 20) & ~0x01f00000U)))

/* macros for field rf_gain_drop_db_high_1 */
#define BT_COEX_1__RF_GAIN_DROP_DB_HIGH_1__SHIFT                             25
#define BT_COEX_1__RF_GAIN_DROP_DB_HIGH_1__WIDTH                              5
#define BT_COEX_1__RF_GAIN_DROP_DB_HIGH_1__MASK                     0x3e000000U
#define BT_COEX_1__RF_GAIN_DROP_DB_HIGH_1__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x3e000000U) >> 25)
#define BT_COEX_1__RF_GAIN_DROP_DB_HIGH_1__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 25) & 0x3e000000U)
#define BT_COEX_1__RF_GAIN_DROP_DB_HIGH_1__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x3e000000U) | (((u_int32_t)(src) <<\
                    25) & 0x3e000000U)
#define BT_COEX_1__RF_GAIN_DROP_DB_HIGH_1__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 25) & ~0x3e000000U)))

/* macros for field bt_tx_disable_NF_cal */
#define BT_COEX_1__BT_TX_DISABLE_NF_CAL__SHIFT                               30
#define BT_COEX_1__BT_TX_DISABLE_NF_CAL__WIDTH                                1
#define BT_COEX_1__BT_TX_DISABLE_NF_CAL__MASK                       0x40000000U
#define BT_COEX_1__BT_TX_DISABLE_NF_CAL__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x40000000U) >> 30)
#define BT_COEX_1__BT_TX_DISABLE_NF_CAL__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 30) & 0x40000000U)
#define BT_COEX_1__BT_TX_DISABLE_NF_CAL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x40000000U) | (((u_int32_t)(src) <<\
                    30) & 0x40000000U)
#define BT_COEX_1__BT_TX_DISABLE_NF_CAL__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 30) & ~0x40000000U)))
#define BT_COEX_1__BT_TX_DISABLE_NF_CAL__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x40000000U) | ((u_int32_t)(1) << 30)
#define BT_COEX_1__BT_TX_DISABLE_NF_CAL__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x40000000U) | ((u_int32_t)(0) << 30)

/* macros for field bt_rx_disable_NF_cal */
#define BT_COEX_1__BT_RX_DISABLE_NF_CAL__SHIFT                               31
#define BT_COEX_1__BT_RX_DISABLE_NF_CAL__WIDTH                                1
#define BT_COEX_1__BT_RX_DISABLE_NF_CAL__MASK                       0x80000000U
#define BT_COEX_1__BT_RX_DISABLE_NF_CAL__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x80000000U) >> 31)
#define BT_COEX_1__BT_RX_DISABLE_NF_CAL__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 31) & 0x80000000U)
#define BT_COEX_1__BT_RX_DISABLE_NF_CAL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x80000000U) | (((u_int32_t)(src) <<\
                    31) & 0x80000000U)
#define BT_COEX_1__BT_RX_DISABLE_NF_CAL__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 31) & ~0x80000000U)))
#define BT_COEX_1__BT_RX_DISABLE_NF_CAL__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x80000000U) | ((u_int32_t)(1) << 31)
#define BT_COEX_1__BT_RX_DISABLE_NF_CAL__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x80000000U) | ((u_int32_t)(0) << 31)
#define BT_COEX_1__TYPE                                               u_int32_t
#define BT_COEX_1__READ                                             0xffffffffU
#define BT_COEX_1__WRITE                                            0xffffffffU

#endif /* __BT_COEX_1_MACRO__ */


/* macros for bb_reg_map.bb_agc_reg_map.BB_bt_coex_1 */
#define INST_BB_REG_MAP__BB_AGC_REG_MAP__BB_BT_COEX_1__NUM                    1

/* macros for BlueprintGlobalNameSpace::bt_coex_2 */
#ifndef __BT_COEX_2_MACRO__
#define __BT_COEX_2_MACRO__

/* macros for field peak_det_tally_thr_low_2 */
#define BT_COEX_2__PEAK_DET_TALLY_THR_LOW_2__SHIFT                            0
#define BT_COEX_2__PEAK_DET_TALLY_THR_LOW_2__WIDTH                            5
#define BT_COEX_2__PEAK_DET_TALLY_THR_LOW_2__MASK                   0x0000001fU
#define BT_COEX_2__PEAK_DET_TALLY_THR_LOW_2__READ(src) \
                    (u_int32_t)(src)\
                    & 0x0000001fU
#define BT_COEX_2__PEAK_DET_TALLY_THR_LOW_2__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x0000001fU)
#define BT_COEX_2__PEAK_DET_TALLY_THR_LOW_2__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000001fU) | ((u_int32_t)(src) &\
                    0x0000001fU)
#define BT_COEX_2__PEAK_DET_TALLY_THR_LOW_2__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x0000001fU)))

/* macros for field peak_det_tally_thr_med_2 */
#define BT_COEX_2__PEAK_DET_TALLY_THR_MED_2__SHIFT                            5
#define BT_COEX_2__PEAK_DET_TALLY_THR_MED_2__WIDTH                            5
#define BT_COEX_2__PEAK_DET_TALLY_THR_MED_2__MASK                   0x000003e0U
#define BT_COEX_2__PEAK_DET_TALLY_THR_MED_2__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x000003e0U) >> 5)
#define BT_COEX_2__PEAK_DET_TALLY_THR_MED_2__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 5) & 0x000003e0U)
#define BT_COEX_2__PEAK_DET_TALLY_THR_MED_2__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000003e0U) | (((u_int32_t)(src) <<\
                    5) & 0x000003e0U)
#define BT_COEX_2__PEAK_DET_TALLY_THR_MED_2__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 5) & ~0x000003e0U)))

/* macros for field peak_det_tally_thr_high_2 */
#define BT_COEX_2__PEAK_DET_TALLY_THR_HIGH_2__SHIFT                          10
#define BT_COEX_2__PEAK_DET_TALLY_THR_HIGH_2__WIDTH                           5
#define BT_COEX_2__PEAK_DET_TALLY_THR_HIGH_2__MASK                  0x00007c00U
#define BT_COEX_2__PEAK_DET_TALLY_THR_HIGH_2__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00007c00U) >> 10)
#define BT_COEX_2__PEAK_DET_TALLY_THR_HIGH_2__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 10) & 0x00007c00U)
#define BT_COEX_2__PEAK_DET_TALLY_THR_HIGH_2__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00007c00U) | (((u_int32_t)(src) <<\
                    10) & 0x00007c00U)
#define BT_COEX_2__PEAK_DET_TALLY_THR_HIGH_2__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 10) & ~0x00007c00U)))

/* macros for field rf_gain_drop_db_low_2 */
#define BT_COEX_2__RF_GAIN_DROP_DB_LOW_2__SHIFT                              15
#define BT_COEX_2__RF_GAIN_DROP_DB_LOW_2__WIDTH                               5
#define BT_COEX_2__RF_GAIN_DROP_DB_LOW_2__MASK                      0x000f8000U
#define BT_COEX_2__RF_GAIN_DROP_DB_LOW_2__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x000f8000U) >> 15)
#define BT_COEX_2__RF_GAIN_DROP_DB_LOW_2__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 15) & 0x000f8000U)
#define BT_COEX_2__RF_GAIN_DROP_DB_LOW_2__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000f8000U) | (((u_int32_t)(src) <<\
                    15) & 0x000f8000U)
#define BT_COEX_2__RF_GAIN_DROP_DB_LOW_2__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 15) & ~0x000f8000U)))

/* macros for field rf_gain_drop_db_med_2 */
#define BT_COEX_2__RF_GAIN_DROP_DB_MED_2__SHIFT                              20
#define BT_COEX_2__RF_GAIN_DROP_DB_MED_2__WIDTH                               5
#define BT_COEX_2__RF_GAIN_DROP_DB_MED_2__MASK                      0x01f00000U
#define BT_COEX_2__RF_GAIN_DROP_DB_MED_2__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x01f00000U) >> 20)
#define BT_COEX_2__RF_GAIN_DROP_DB_MED_2__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 20) & 0x01f00000U)
#define BT_COEX_2__RF_GAIN_DROP_DB_MED_2__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x01f00000U) | (((u_int32_t)(src) <<\
                    20) & 0x01f00000U)
#define BT_COEX_2__RF_GAIN_DROP_DB_MED_2__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 20) & ~0x01f00000U)))

/* macros for field rf_gain_drop_db_high_2 */
#define BT_COEX_2__RF_GAIN_DROP_DB_HIGH_2__SHIFT                             25
#define BT_COEX_2__RF_GAIN_DROP_DB_HIGH_2__WIDTH                              5
#define BT_COEX_2__RF_GAIN_DROP_DB_HIGH_2__MASK                     0x3e000000U
#define BT_COEX_2__RF_GAIN_DROP_DB_HIGH_2__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x3e000000U) >> 25)
#define BT_COEX_2__RF_GAIN_DROP_DB_HIGH_2__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 25) & 0x3e000000U)
#define BT_COEX_2__RF_GAIN_DROP_DB_HIGH_2__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x3e000000U) | (((u_int32_t)(src) <<\
                    25) & 0x3e000000U)
#define BT_COEX_2__RF_GAIN_DROP_DB_HIGH_2__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 25) & ~0x3e000000U)))

/* macros for field rfsat_rx_rx */
#define BT_COEX_2__RFSAT_RX_RX__SHIFT                                        30
#define BT_COEX_2__RFSAT_RX_RX__WIDTH                                         2
#define BT_COEX_2__RFSAT_RX_RX__MASK                                0xc0000000U
#define BT_COEX_2__RFSAT_RX_RX__READ(src) \
                    (((u_int32_t)(src)\
                    & 0xc0000000U) >> 30)
#define BT_COEX_2__RFSAT_RX_RX__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 30) & 0xc0000000U)
#define BT_COEX_2__RFSAT_RX_RX__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xc0000000U) | (((u_int32_t)(src) <<\
                    30) & 0xc0000000U)
#define BT_COEX_2__RFSAT_RX_RX__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 30) & ~0xc0000000U)))
#define BT_COEX_2__TYPE                                               u_int32_t
#define BT_COEX_2__READ                                             0xffffffffU
#define BT_COEX_2__WRITE                                            0xffffffffU

#endif /* __BT_COEX_2_MACRO__ */


/* macros for bb_reg_map.bb_agc_reg_map.BB_bt_coex_2 */
#define INST_BB_REG_MAP__BB_AGC_REG_MAP__BB_BT_COEX_2__NUM                    1

/* macros for BlueprintGlobalNameSpace::bt_coex_3 */
#ifndef __BT_COEX_3_MACRO__
#define __BT_COEX_3_MACRO__

/* macros for field rfsat_bt_srch_srch */
#define BT_COEX_3__RFSAT_BT_SRCH_SRCH__SHIFT                                  0
#define BT_COEX_3__RFSAT_BT_SRCH_SRCH__WIDTH                                  2
#define BT_COEX_3__RFSAT_BT_SRCH_SRCH__MASK                         0x00000003U
#define BT_COEX_3__RFSAT_BT_SRCH_SRCH__READ(src) (u_int32_t)(src) & 0x00000003U
#define BT_COEX_3__RFSAT_BT_SRCH_SRCH__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x00000003U)
#define BT_COEX_3__RFSAT_BT_SRCH_SRCH__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000003U) | ((u_int32_t)(src) &\
                    0x00000003U)
#define BT_COEX_3__RFSAT_BT_SRCH_SRCH__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00000003U)))

/* macros for field rfsat_bt_rx_srch */
#define BT_COEX_3__RFSAT_BT_RX_SRCH__SHIFT                                    2
#define BT_COEX_3__RFSAT_BT_RX_SRCH__WIDTH                                    2
#define BT_COEX_3__RFSAT_BT_RX_SRCH__MASK                           0x0000000cU
#define BT_COEX_3__RFSAT_BT_RX_SRCH__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0000000cU) >> 2)
#define BT_COEX_3__RFSAT_BT_RX_SRCH__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 2) & 0x0000000cU)
#define BT_COEX_3__RFSAT_BT_RX_SRCH__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000000cU) | (((u_int32_t)(src) <<\
                    2) & 0x0000000cU)
#define BT_COEX_3__RFSAT_BT_RX_SRCH__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 2) & ~0x0000000cU)))

/* macros for field rfsat_bt_srch_rx */
#define BT_COEX_3__RFSAT_BT_SRCH_RX__SHIFT                                    4
#define BT_COEX_3__RFSAT_BT_SRCH_RX__WIDTH                                    2
#define BT_COEX_3__RFSAT_BT_SRCH_RX__MASK                           0x00000030U
#define BT_COEX_3__RFSAT_BT_SRCH_RX__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000030U) >> 4)
#define BT_COEX_3__RFSAT_BT_SRCH_RX__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 4) & 0x00000030U)
#define BT_COEX_3__RFSAT_BT_SRCH_RX__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000030U) | (((u_int32_t)(src) <<\
                    4) & 0x00000030U)
#define BT_COEX_3__RFSAT_BT_SRCH_RX__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 4) & ~0x00000030U)))

/* macros for field rfsat_wlan_srch_srch */
#define BT_COEX_3__RFSAT_WLAN_SRCH_SRCH__SHIFT                                6
#define BT_COEX_3__RFSAT_WLAN_SRCH_SRCH__WIDTH                                2
#define BT_COEX_3__RFSAT_WLAN_SRCH_SRCH__MASK                       0x000000c0U
#define BT_COEX_3__RFSAT_WLAN_SRCH_SRCH__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x000000c0U) >> 6)
#define BT_COEX_3__RFSAT_WLAN_SRCH_SRCH__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 6) & 0x000000c0U)
#define BT_COEX_3__RFSAT_WLAN_SRCH_SRCH__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000000c0U) | (((u_int32_t)(src) <<\
                    6) & 0x000000c0U)
#define BT_COEX_3__RFSAT_WLAN_SRCH_SRCH__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 6) & ~0x000000c0U)))

/* macros for field rfsat_wlan_rx_srch */
#define BT_COEX_3__RFSAT_WLAN_RX_SRCH__SHIFT                                  8
#define BT_COEX_3__RFSAT_WLAN_RX_SRCH__WIDTH                                  2
#define BT_COEX_3__RFSAT_WLAN_RX_SRCH__MASK                         0x00000300U
#define BT_COEX_3__RFSAT_WLAN_RX_SRCH__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000300U) >> 8)
#define BT_COEX_3__RFSAT_WLAN_RX_SRCH__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 8) & 0x00000300U)
#define BT_COEX_3__RFSAT_WLAN_RX_SRCH__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000300U) | (((u_int32_t)(src) <<\
                    8) & 0x00000300U)
#define BT_COEX_3__RFSAT_WLAN_RX_SRCH__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 8) & ~0x00000300U)))

/* macros for field rfsat_wlan_srch_rx */
#define BT_COEX_3__RFSAT_WLAN_SRCH_RX__SHIFT                                 10
#define BT_COEX_3__RFSAT_WLAN_SRCH_RX__WIDTH                                  2
#define BT_COEX_3__RFSAT_WLAN_SRCH_RX__MASK                         0x00000c00U
#define BT_COEX_3__RFSAT_WLAN_SRCH_RX__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000c00U) >> 10)
#define BT_COEX_3__RFSAT_WLAN_SRCH_RX__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 10) & 0x00000c00U)
#define BT_COEX_3__RFSAT_WLAN_SRCH_RX__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000c00U) | (((u_int32_t)(src) <<\
                    10) & 0x00000c00U)
#define BT_COEX_3__RFSAT_WLAN_SRCH_RX__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 10) & ~0x00000c00U)))

/* macros for field rfsat_eq_srch_srch */
#define BT_COEX_3__RFSAT_EQ_SRCH_SRCH__SHIFT                                 12
#define BT_COEX_3__RFSAT_EQ_SRCH_SRCH__WIDTH                                  2
#define BT_COEX_3__RFSAT_EQ_SRCH_SRCH__MASK                         0x00003000U
#define BT_COEX_3__RFSAT_EQ_SRCH_SRCH__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00003000U) >> 12)
#define BT_COEX_3__RFSAT_EQ_SRCH_SRCH__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 12) & 0x00003000U)
#define BT_COEX_3__RFSAT_EQ_SRCH_SRCH__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00003000U) | (((u_int32_t)(src) <<\
                    12) & 0x00003000U)
#define BT_COEX_3__RFSAT_EQ_SRCH_SRCH__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 12) & ~0x00003000U)))

/* macros for field rfsat_eq_rx_srch */
#define BT_COEX_3__RFSAT_EQ_RX_SRCH__SHIFT                                   14
#define BT_COEX_3__RFSAT_EQ_RX_SRCH__WIDTH                                    2
#define BT_COEX_3__RFSAT_EQ_RX_SRCH__MASK                           0x0000c000U
#define BT_COEX_3__RFSAT_EQ_RX_SRCH__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0000c000U) >> 14)
#define BT_COEX_3__RFSAT_EQ_RX_SRCH__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 14) & 0x0000c000U)
#define BT_COEX_3__RFSAT_EQ_RX_SRCH__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000c000U) | (((u_int32_t)(src) <<\
                    14) & 0x0000c000U)
#define BT_COEX_3__RFSAT_EQ_RX_SRCH__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 14) & ~0x0000c000U)))

/* macros for field rfsat_eq_srch_rx */
#define BT_COEX_3__RFSAT_EQ_SRCH_RX__SHIFT                                   16
#define BT_COEX_3__RFSAT_EQ_SRCH_RX__WIDTH                                    2
#define BT_COEX_3__RFSAT_EQ_SRCH_RX__MASK                           0x00030000U
#define BT_COEX_3__RFSAT_EQ_SRCH_RX__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00030000U) >> 16)
#define BT_COEX_3__RFSAT_EQ_SRCH_RX__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 16) & 0x00030000U)
#define BT_COEX_3__RFSAT_EQ_SRCH_RX__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00030000U) | (((u_int32_t)(src) <<\
                    16) & 0x00030000U)
#define BT_COEX_3__RFSAT_EQ_SRCH_RX__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 16) & ~0x00030000U)))

/* macros for field rf_gain_drop_db_non_1 */
#define BT_COEX_3__RF_GAIN_DROP_DB_NON_1__SHIFT                              18
#define BT_COEX_3__RF_GAIN_DROP_DB_NON_1__WIDTH                               5
#define BT_COEX_3__RF_GAIN_DROP_DB_NON_1__MASK                      0x007c0000U
#define BT_COEX_3__RF_GAIN_DROP_DB_NON_1__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x007c0000U) >> 18)
#define BT_COEX_3__RF_GAIN_DROP_DB_NON_1__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 18) & 0x007c0000U)
#define BT_COEX_3__RF_GAIN_DROP_DB_NON_1__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x007c0000U) | (((u_int32_t)(src) <<\
                    18) & 0x007c0000U)
#define BT_COEX_3__RF_GAIN_DROP_DB_NON_1__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 18) & ~0x007c0000U)))

/* macros for field rf_gain_drop_db_non_2 */
#define BT_COEX_3__RF_GAIN_DROP_DB_NON_2__SHIFT                              23
#define BT_COEX_3__RF_GAIN_DROP_DB_NON_2__WIDTH                               5
#define BT_COEX_3__RF_GAIN_DROP_DB_NON_2__MASK                      0x0f800000U
#define BT_COEX_3__RF_GAIN_DROP_DB_NON_2__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0f800000U) >> 23)
#define BT_COEX_3__RF_GAIN_DROP_DB_NON_2__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 23) & 0x0f800000U)
#define BT_COEX_3__RF_GAIN_DROP_DB_NON_2__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0f800000U) | (((u_int32_t)(src) <<\
                    23) & 0x0f800000U)
#define BT_COEX_3__RF_GAIN_DROP_DB_NON_2__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 23) & ~0x0f800000U)))

/* macros for field bt_rx_firpwr_incr */
#define BT_COEX_3__BT_RX_FIRPWR_INCR__SHIFT                                  28
#define BT_COEX_3__BT_RX_FIRPWR_INCR__WIDTH                                   4
#define BT_COEX_3__BT_RX_FIRPWR_INCR__MASK                          0xf0000000U
#define BT_COEX_3__BT_RX_FIRPWR_INCR__READ(src) \
                    (((u_int32_t)(src)\
                    & 0xf0000000U) >> 28)
#define BT_COEX_3__BT_RX_FIRPWR_INCR__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 28) & 0xf0000000U)
#define BT_COEX_3__BT_RX_FIRPWR_INCR__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xf0000000U) | (((u_int32_t)(src) <<\
                    28) & 0xf0000000U)
#define BT_COEX_3__BT_RX_FIRPWR_INCR__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 28) & ~0xf0000000U)))
#define BT_COEX_3__TYPE                                               u_int32_t
#define BT_COEX_3__READ                                             0xffffffffU
#define BT_COEX_3__WRITE                                            0xffffffffU

#endif /* __BT_COEX_3_MACRO__ */


/* macros for bb_reg_map.bb_agc_reg_map.BB_bt_coex_3 */
#define INST_BB_REG_MAP__BB_AGC_REG_MAP__BB_BT_COEX_3__NUM                    1

/* macros for BlueprintGlobalNameSpace::bt_coex_4 */
#ifndef __BT_COEX_4_MACRO__
#define __BT_COEX_4_MACRO__

/* macros for field rfgain_eqv_lna_0 */
#define BT_COEX_4__RFGAIN_EQV_LNA_0__SHIFT                                    0
#define BT_COEX_4__RFGAIN_EQV_LNA_0__WIDTH                                    8
#define BT_COEX_4__RFGAIN_EQV_LNA_0__MASK                           0x000000ffU
#define BT_COEX_4__RFGAIN_EQV_LNA_0__READ(src)   (u_int32_t)(src) & 0x000000ffU
#define BT_COEX_4__RFGAIN_EQV_LNA_0__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x000000ffU)
#define BT_COEX_4__RFGAIN_EQV_LNA_0__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000000ffU) | ((u_int32_t)(src) &\
                    0x000000ffU)
#define BT_COEX_4__RFGAIN_EQV_LNA_0__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x000000ffU)))

/* macros for field rfgain_eqv_lna_1 */
#define BT_COEX_4__RFGAIN_EQV_LNA_1__SHIFT                                    8
#define BT_COEX_4__RFGAIN_EQV_LNA_1__WIDTH                                    8
#define BT_COEX_4__RFGAIN_EQV_LNA_1__MASK                           0x0000ff00U
#define BT_COEX_4__RFGAIN_EQV_LNA_1__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0000ff00U) >> 8)
#define BT_COEX_4__RFGAIN_EQV_LNA_1__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 8) & 0x0000ff00U)
#define BT_COEX_4__RFGAIN_EQV_LNA_1__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000ff00U) | (((u_int32_t)(src) <<\
                    8) & 0x0000ff00U)
#define BT_COEX_4__RFGAIN_EQV_LNA_1__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 8) & ~0x0000ff00U)))

/* macros for field rfgain_eqv_lna_2 */
#define BT_COEX_4__RFGAIN_EQV_LNA_2__SHIFT                                   16
#define BT_COEX_4__RFGAIN_EQV_LNA_2__WIDTH                                    8
#define BT_COEX_4__RFGAIN_EQV_LNA_2__MASK                           0x00ff0000U
#define BT_COEX_4__RFGAIN_EQV_LNA_2__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00ff0000U) >> 16)
#define BT_COEX_4__RFGAIN_EQV_LNA_2__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 16) & 0x00ff0000U)
#define BT_COEX_4__RFGAIN_EQV_LNA_2__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00ff0000U) | (((u_int32_t)(src) <<\
                    16) & 0x00ff0000U)
#define BT_COEX_4__RFGAIN_EQV_LNA_2__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 16) & ~0x00ff0000U)))

/* macros for field rfgain_eqv_lna_3 */
#define BT_COEX_4__RFGAIN_EQV_LNA_3__SHIFT                                   24
#define BT_COEX_4__RFGAIN_EQV_LNA_3__WIDTH                                    8
#define BT_COEX_4__RFGAIN_EQV_LNA_3__MASK                           0xff000000U
#define BT_COEX_4__RFGAIN_EQV_LNA_3__READ(src) \
                    (((u_int32_t)(src)\
                    & 0xff000000U) >> 24)
#define BT_COEX_4__RFGAIN_EQV_LNA_3__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 24) & 0xff000000U)
#define BT_COEX_4__RFGAIN_EQV_LNA_3__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xff000000U) | (((u_int32_t)(src) <<\
                    24) & 0xff000000U)
#define BT_COEX_4__RFGAIN_EQV_LNA_3__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 24) & ~0xff000000U)))
#define BT_COEX_4__TYPE                                               u_int32_t
#define BT_COEX_4__READ                                             0xffffffffU
#define BT_COEX_4__WRITE                                            0xffffffffU

#endif /* __BT_COEX_4_MACRO__ */


/* macros for bb_reg_map.bb_agc_reg_map.BB_bt_coex_4 */
#define INST_BB_REG_MAP__BB_AGC_REG_MAP__BB_BT_COEX_4__NUM                    1

/* macros for BlueprintGlobalNameSpace::bt_coex_5 */
#ifndef __BT_COEX_5_MACRO__
#define __BT_COEX_5_MACRO__

/* macros for field rfgain_eqv_lna_4 */
#define BT_COEX_5__RFGAIN_EQV_LNA_4__SHIFT                                    0
#define BT_COEX_5__RFGAIN_EQV_LNA_4__WIDTH                                    8
#define BT_COEX_5__RFGAIN_EQV_LNA_4__MASK                           0x000000ffU
#define BT_COEX_5__RFGAIN_EQV_LNA_4__READ(src)   (u_int32_t)(src) & 0x000000ffU
#define BT_COEX_5__RFGAIN_EQV_LNA_4__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x000000ffU)
#define BT_COEX_5__RFGAIN_EQV_LNA_4__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000000ffU) | ((u_int32_t)(src) &\
                    0x000000ffU)
#define BT_COEX_5__RFGAIN_EQV_LNA_4__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x000000ffU)))

/* macros for field rfgain_eqv_lna_5 */
#define BT_COEX_5__RFGAIN_EQV_LNA_5__SHIFT                                    8
#define BT_COEX_5__RFGAIN_EQV_LNA_5__WIDTH                                    8
#define BT_COEX_5__RFGAIN_EQV_LNA_5__MASK                           0x0000ff00U
#define BT_COEX_5__RFGAIN_EQV_LNA_5__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0000ff00U) >> 8)
#define BT_COEX_5__RFGAIN_EQV_LNA_5__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 8) & 0x0000ff00U)
#define BT_COEX_5__RFGAIN_EQV_LNA_5__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000ff00U) | (((u_int32_t)(src) <<\
                    8) & 0x0000ff00U)
#define BT_COEX_5__RFGAIN_EQV_LNA_5__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 8) & ~0x0000ff00U)))

/* macros for field rfgain_eqv_lna_6 */
#define BT_COEX_5__RFGAIN_EQV_LNA_6__SHIFT                                   16
#define BT_COEX_5__RFGAIN_EQV_LNA_6__WIDTH                                    8
#define BT_COEX_5__RFGAIN_EQV_LNA_6__MASK                           0x00ff0000U
#define BT_COEX_5__RFGAIN_EQV_LNA_6__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00ff0000U) >> 16)
#define BT_COEX_5__RFGAIN_EQV_LNA_6__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 16) & 0x00ff0000U)
#define BT_COEX_5__RFGAIN_EQV_LNA_6__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00ff0000U) | (((u_int32_t)(src) <<\
                    16) & 0x00ff0000U)
#define BT_COEX_5__RFGAIN_EQV_LNA_6__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 16) & ~0x00ff0000U)))

/* macros for field rfgain_eqv_lna_7 */
#define BT_COEX_5__RFGAIN_EQV_LNA_7__SHIFT                                   24
#define BT_COEX_5__RFGAIN_EQV_LNA_7__WIDTH                                    8
#define BT_COEX_5__RFGAIN_EQV_LNA_7__MASK                           0xff000000U
#define BT_COEX_5__RFGAIN_EQV_LNA_7__READ(src) \
                    (((u_int32_t)(src)\
                    & 0xff000000U) >> 24)
#define BT_COEX_5__RFGAIN_EQV_LNA_7__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 24) & 0xff000000U)
#define BT_COEX_5__RFGAIN_EQV_LNA_7__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xff000000U) | (((u_int32_t)(src) <<\
                    24) & 0xff000000U)
#define BT_COEX_5__RFGAIN_EQV_LNA_7__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 24) & ~0xff000000U)))
#define BT_COEX_5__TYPE                                               u_int32_t
#define BT_COEX_5__READ                                             0xffffffffU
#define BT_COEX_5__WRITE                                            0xffffffffU

#endif /* __BT_COEX_5_MACRO__ */


/* macros for bb_reg_map.bb_agc_reg_map.BB_bt_coex_5 */
#define INST_BB_REG_MAP__BB_AGC_REG_MAP__BB_BT_COEX_5__NUM                    1

/* macros for BlueprintGlobalNameSpace::dyn_adc_size_ctrl */
#ifndef __DYN_ADC_SIZE_CTRL_MACRO__
#define __DYN_ADC_SIZE_CTRL_MACRO__

/* macros for field enable_dynamic_adc_sizing */
#define DYN_ADC_SIZE_CTRL__ENABLE_DYNAMIC_ADC_SIZING__SHIFT                   0
#define DYN_ADC_SIZE_CTRL__ENABLE_DYNAMIC_ADC_SIZING__WIDTH                   1
#define DYN_ADC_SIZE_CTRL__ENABLE_DYNAMIC_ADC_SIZING__MASK          0x00000001U
#define DYN_ADC_SIZE_CTRL__ENABLE_DYNAMIC_ADC_SIZING__READ(src) \
                    (u_int32_t)(src)\
                    & 0x00000001U
#define DYN_ADC_SIZE_CTRL__ENABLE_DYNAMIC_ADC_SIZING__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x00000001U)
#define DYN_ADC_SIZE_CTRL__ENABLE_DYNAMIC_ADC_SIZING__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | ((u_int32_t)(src) &\
                    0x00000001U)
#define DYN_ADC_SIZE_CTRL__ENABLE_DYNAMIC_ADC_SIZING__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00000001U)))
#define DYN_ADC_SIZE_CTRL__ENABLE_DYNAMIC_ADC_SIZING__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(1)
#define DYN_ADC_SIZE_CTRL__ENABLE_DYNAMIC_ADC_SIZING__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(0)

/* macros for field alpha_adc_size_rssi */
#define DYN_ADC_SIZE_CTRL__ALPHA_ADC_SIZE_RSSI__SHIFT                         1
#define DYN_ADC_SIZE_CTRL__ALPHA_ADC_SIZE_RSSI__WIDTH                         2
#define DYN_ADC_SIZE_CTRL__ALPHA_ADC_SIZE_RSSI__MASK                0x00000006U
#define DYN_ADC_SIZE_CTRL__ALPHA_ADC_SIZE_RSSI__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000006U) >> 1)
#define DYN_ADC_SIZE_CTRL__ALPHA_ADC_SIZE_RSSI__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 1) & 0x00000006U)
#define DYN_ADC_SIZE_CTRL__ALPHA_ADC_SIZE_RSSI__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000006U) | (((u_int32_t)(src) <<\
                    1) & 0x00000006U)
#define DYN_ADC_SIZE_CTRL__ALPHA_ADC_SIZE_RSSI__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 1) & ~0x00000006U)))

/* macros for field alpha_adc_size_relpwr */
#define DYN_ADC_SIZE_CTRL__ALPHA_ADC_SIZE_RELPWR__SHIFT                       3
#define DYN_ADC_SIZE_CTRL__ALPHA_ADC_SIZE_RELPWR__WIDTH                       2
#define DYN_ADC_SIZE_CTRL__ALPHA_ADC_SIZE_RELPWR__MASK              0x00000018U
#define DYN_ADC_SIZE_CTRL__ALPHA_ADC_SIZE_RELPWR__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000018U) >> 3)
#define DYN_ADC_SIZE_CTRL__ALPHA_ADC_SIZE_RELPWR__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 3) & 0x00000018U)
#define DYN_ADC_SIZE_CTRL__ALPHA_ADC_SIZE_RELPWR__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000018U) | (((u_int32_t)(src) <<\
                    3) & 0x00000018U)
#define DYN_ADC_SIZE_CTRL__ALPHA_ADC_SIZE_RELPWR__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 3) & ~0x00000018U)))

/* macros for field rssi_pri_high_thr */
#define DYN_ADC_SIZE_CTRL__RSSI_PRI_HIGH_THR__SHIFT                           8
#define DYN_ADC_SIZE_CTRL__RSSI_PRI_HIGH_THR__WIDTH                           7
#define DYN_ADC_SIZE_CTRL__RSSI_PRI_HIGH_THR__MASK                  0x00007f00U
#define DYN_ADC_SIZE_CTRL__RSSI_PRI_HIGH_THR__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00007f00U) >> 8)
#define DYN_ADC_SIZE_CTRL__RSSI_PRI_HIGH_THR__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 8) & 0x00007f00U)
#define DYN_ADC_SIZE_CTRL__RSSI_PRI_HIGH_THR__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00007f00U) | (((u_int32_t)(src) <<\
                    8) & 0x00007f00U)
#define DYN_ADC_SIZE_CTRL__RSSI_PRI_HIGH_THR__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 8) & ~0x00007f00U)))

/* macros for field adc_size_desired_max_db2 */
#define DYN_ADC_SIZE_CTRL__ADC_SIZE_DESIRED_MAX_DB2__SHIFT                   16
#define DYN_ADC_SIZE_CTRL__ADC_SIZE_DESIRED_MAX_DB2__WIDTH                    8
#define DYN_ADC_SIZE_CTRL__ADC_SIZE_DESIRED_MAX_DB2__MASK           0x00ff0000U
#define DYN_ADC_SIZE_CTRL__ADC_SIZE_DESIRED_MAX_DB2__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00ff0000U) >> 16)
#define DYN_ADC_SIZE_CTRL__ADC_SIZE_DESIRED_MAX_DB2__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 16) & 0x00ff0000U)
#define DYN_ADC_SIZE_CTRL__ADC_SIZE_DESIRED_MAX_DB2__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00ff0000U) | (((u_int32_t)(src) <<\
                    16) & 0x00ff0000U)
#define DYN_ADC_SIZE_CTRL__ADC_SIZE_DESIRED_MAX_DB2__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 16) & ~0x00ff0000U)))

/* macros for field adc_size_desired_min_db2 */
#define DYN_ADC_SIZE_CTRL__ADC_SIZE_DESIRED_MIN_DB2__SHIFT                   24
#define DYN_ADC_SIZE_CTRL__ADC_SIZE_DESIRED_MIN_DB2__WIDTH                    8
#define DYN_ADC_SIZE_CTRL__ADC_SIZE_DESIRED_MIN_DB2__MASK           0xff000000U
#define DYN_ADC_SIZE_CTRL__ADC_SIZE_DESIRED_MIN_DB2__READ(src) \
                    (((u_int32_t)(src)\
                    & 0xff000000U) >> 24)
#define DYN_ADC_SIZE_CTRL__ADC_SIZE_DESIRED_MIN_DB2__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 24) & 0xff000000U)
#define DYN_ADC_SIZE_CTRL__ADC_SIZE_DESIRED_MIN_DB2__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xff000000U) | (((u_int32_t)(src) <<\
                    24) & 0xff000000U)
#define DYN_ADC_SIZE_CTRL__ADC_SIZE_DESIRED_MIN_DB2__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 24) & ~0xff000000U)))
#define DYN_ADC_SIZE_CTRL__TYPE                                       u_int32_t
#define DYN_ADC_SIZE_CTRL__READ                                     0xffff7f1fU
#define DYN_ADC_SIZE_CTRL__WRITE                                    0xffff7f1fU

#endif /* __DYN_ADC_SIZE_CTRL_MACRO__ */


/* macros for bb_reg_map.bb_agc_reg_map.BB_dyn_adc_size_ctrl */
#define INST_BB_REG_MAP__BB_AGC_REG_MAP__BB_DYN_ADC_SIZE_CTRL__NUM            1

/* macros for BlueprintGlobalNameSpace::rx_lo_dccal_ctrl */
#ifndef __RX_LO_DCCAL_CTRL_MACRO__
#define __RX_LO_DCCAL_CTRL_MACRO__

/* macros for field calnum_rx */
#define RX_LO_DCCAL_CTRL__CALNUM_RX__SHIFT                                    0
#define RX_LO_DCCAL_CTRL__CALNUM_RX__WIDTH                                    3
#define RX_LO_DCCAL_CTRL__CALNUM_RX__MASK                           0x00000007U
#define RX_LO_DCCAL_CTRL__CALNUM_RX__READ(src)   (u_int32_t)(src) & 0x00000007U
#define RX_LO_DCCAL_CTRL__CALNUM_RX__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x00000007U)
#define RX_LO_DCCAL_CTRL__CALNUM_RX__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000007U) | ((u_int32_t)(src) &\
                    0x00000007U)
#define RX_LO_DCCAL_CTRL__CALNUM_RX__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00000007U)))

/* macros for field calnum_txlb */
#define RX_LO_DCCAL_CTRL__CALNUM_TXLB__SHIFT                                  3
#define RX_LO_DCCAL_CTRL__CALNUM_TXLB__WIDTH                                  3
#define RX_LO_DCCAL_CTRL__CALNUM_TXLB__MASK                         0x00000038U
#define RX_LO_DCCAL_CTRL__CALNUM_TXLB__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000038U) >> 3)
#define RX_LO_DCCAL_CTRL__CALNUM_TXLB__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 3) & 0x00000038U)
#define RX_LO_DCCAL_CTRL__CALNUM_TXLB__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000038U) | (((u_int32_t)(src) <<\
                    3) & 0x00000038U)
#define RX_LO_DCCAL_CTRL__CALNUM_TXLB__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 3) & ~0x00000038U)))
#define RX_LO_DCCAL_CTRL__TYPE                                        u_int32_t
#define RX_LO_DCCAL_CTRL__READ                                      0x0000003fU
#define RX_LO_DCCAL_CTRL__WRITE                                     0x0000003fU

#endif /* __RX_LO_DCCAL_CTRL_MACRO__ */


/* macros for bb_reg_map.bb_agc_reg_map.BB_rx_lo_dccal_ctrl */
#define INST_BB_REG_MAP__BB_AGC_REG_MAP__BB_RX_LO_DCCAL_CTRL__NUM             1

/* macros for BlueprintGlobalNameSpace::adc_capture */
#ifndef __ADC_CAPTURE_MACRO__
#define __ADC_CAPTURE_MACRO__

/* macros for field adc_capture_active */
#define ADC_CAPTURE__ADC_CAPTURE_ACTIVE__SHIFT                                0
#define ADC_CAPTURE__ADC_CAPTURE_ACTIVE__WIDTH                                1
#define ADC_CAPTURE__ADC_CAPTURE_ACTIVE__MASK                       0x00000001U
#define ADC_CAPTURE__ADC_CAPTURE_ACTIVE__READ(src) \
                    (u_int32_t)(src)\
                    & 0x00000001U
#define ADC_CAPTURE__ADC_CAPTURE_ACTIVE__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x00000001U)
#define ADC_CAPTURE__ADC_CAPTURE_ACTIVE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | ((u_int32_t)(src) &\
                    0x00000001U)
#define ADC_CAPTURE__ADC_CAPTURE_ACTIVE__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00000001U)))
#define ADC_CAPTURE__ADC_CAPTURE_ACTIVE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(1)
#define ADC_CAPTURE__ADC_CAPTURE_ACTIVE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(0)

/* macros for field adc_capture_error_flag */
#define ADC_CAPTURE__ADC_CAPTURE_ERROR_FLAG__SHIFT                            1
#define ADC_CAPTURE__ADC_CAPTURE_ERROR_FLAG__WIDTH                            1
#define ADC_CAPTURE__ADC_CAPTURE_ERROR_FLAG__MASK                   0x00000002U
#define ADC_CAPTURE__ADC_CAPTURE_ERROR_FLAG__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000002U) >> 1)
#define ADC_CAPTURE__ADC_CAPTURE_ERROR_FLAG__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 1) & 0x00000002U)
#define ADC_CAPTURE__ADC_CAPTURE_ERROR_FLAG__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | (((u_int32_t)(src) <<\
                    1) & 0x00000002U)
#define ADC_CAPTURE__ADC_CAPTURE_ERROR_FLAG__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 1) & ~0x00000002U)))
#define ADC_CAPTURE__ADC_CAPTURE_ERROR_FLAG__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | ((u_int32_t)(1) << 1)
#define ADC_CAPTURE__ADC_CAPTURE_ERROR_FLAG__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | ((u_int32_t)(0) << 1)

/* macros for field adc_capture_sat_flag */
#define ADC_CAPTURE__ADC_CAPTURE_SAT_FLAG__SHIFT                              2
#define ADC_CAPTURE__ADC_CAPTURE_SAT_FLAG__WIDTH                              1
#define ADC_CAPTURE__ADC_CAPTURE_SAT_FLAG__MASK                     0x00000004U
#define ADC_CAPTURE__ADC_CAPTURE_SAT_FLAG__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000004U) >> 2)
#define ADC_CAPTURE__ADC_CAPTURE_SAT_FLAG__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 2) & 0x00000004U)
#define ADC_CAPTURE__ADC_CAPTURE_SAT_FLAG__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000004U) | (((u_int32_t)(src) <<\
                    2) & 0x00000004U)
#define ADC_CAPTURE__ADC_CAPTURE_SAT_FLAG__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 2) & ~0x00000004U)))
#define ADC_CAPTURE__ADC_CAPTURE_SAT_FLAG__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000004U) | ((u_int32_t)(1) << 2)
#define ADC_CAPTURE__ADC_CAPTURE_SAT_FLAG__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000004U) | ((u_int32_t)(0) << 2)

/* macros for field adc_capture_overrun_flag */
#define ADC_CAPTURE__ADC_CAPTURE_OVERRUN_FLAG__SHIFT                          3
#define ADC_CAPTURE__ADC_CAPTURE_OVERRUN_FLAG__WIDTH                          1
#define ADC_CAPTURE__ADC_CAPTURE_OVERRUN_FLAG__MASK                 0x00000008U
#define ADC_CAPTURE__ADC_CAPTURE_OVERRUN_FLAG__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000008U) >> 3)
#define ADC_CAPTURE__ADC_CAPTURE_OVERRUN_FLAG__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 3) & 0x00000008U)
#define ADC_CAPTURE__ADC_CAPTURE_OVERRUN_FLAG__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000008U) | (((u_int32_t)(src) <<\
                    3) & 0x00000008U)
#define ADC_CAPTURE__ADC_CAPTURE_OVERRUN_FLAG__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 3) & ~0x00000008U)))
#define ADC_CAPTURE__ADC_CAPTURE_OVERRUN_FLAG__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000008U) | ((u_int32_t)(1) << 3)
#define ADC_CAPTURE__ADC_CAPTURE_OVERRUN_FLAG__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000008U) | ((u_int32_t)(0) << 3)

/* macros for field adc_capture_format */
#define ADC_CAPTURE__ADC_CAPTURE_FORMAT__SHIFT                                4
#define ADC_CAPTURE__ADC_CAPTURE_FORMAT__WIDTH                                1
#define ADC_CAPTURE__ADC_CAPTURE_FORMAT__MASK                       0x00000010U
#define ADC_CAPTURE__ADC_CAPTURE_FORMAT__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000010U) >> 4)
#define ADC_CAPTURE__ADC_CAPTURE_FORMAT__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 4) & 0x00000010U)
#define ADC_CAPTURE__ADC_CAPTURE_FORMAT__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000010U) | (((u_int32_t)(src) <<\
                    4) & 0x00000010U)
#define ADC_CAPTURE__ADC_CAPTURE_FORMAT__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 4) & ~0x00000010U)))
#define ADC_CAPTURE__ADC_CAPTURE_FORMAT__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000010U) | ((u_int32_t)(1) << 4)
#define ADC_CAPTURE__ADC_CAPTURE_FORMAT__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000010U) | ((u_int32_t)(0) << 4)

/* macros for field adc_capture_gc_ena */
#define ADC_CAPTURE__ADC_CAPTURE_GC_ENA__SHIFT                                5
#define ADC_CAPTURE__ADC_CAPTURE_GC_ENA__WIDTH                                1
#define ADC_CAPTURE__ADC_CAPTURE_GC_ENA__MASK                       0x00000020U
#define ADC_CAPTURE__ADC_CAPTURE_GC_ENA__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000020U) >> 5)
#define ADC_CAPTURE__ADC_CAPTURE_GC_ENA__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 5) & 0x00000020U)
#define ADC_CAPTURE__ADC_CAPTURE_GC_ENA__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000020U) | (((u_int32_t)(src) <<\
                    5) & 0x00000020U)
#define ADC_CAPTURE__ADC_CAPTURE_GC_ENA__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 5) & ~0x00000020U)))
#define ADC_CAPTURE__ADC_CAPTURE_GC_ENA__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000020U) | ((u_int32_t)(1) << 5)
#define ADC_CAPTURE__ADC_CAPTURE_GC_ENA__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000020U) | ((u_int32_t)(0) << 5)

/* macros for field adc_capture_scale */
#define ADC_CAPTURE__ADC_CAPTURE_SCALE__SHIFT                                 6
#define ADC_CAPTURE__ADC_CAPTURE_SCALE__WIDTH                                 2
#define ADC_CAPTURE__ADC_CAPTURE_SCALE__MASK                        0x000000c0U
#define ADC_CAPTURE__ADC_CAPTURE_SCALE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x000000c0U) >> 6)
#define ADC_CAPTURE__ADC_CAPTURE_SCALE__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 6) & 0x000000c0U)
#define ADC_CAPTURE__ADC_CAPTURE_SCALE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000000c0U) | (((u_int32_t)(src) <<\
                    6) & 0x000000c0U)
#define ADC_CAPTURE__ADC_CAPTURE_SCALE__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 6) & ~0x000000c0U)))

/* macros for field adc_capture_length */
#define ADC_CAPTURE__ADC_CAPTURE_LENGTH__SHIFT                                8
#define ADC_CAPTURE__ADC_CAPTURE_LENGTH__WIDTH                               14
#define ADC_CAPTURE__ADC_CAPTURE_LENGTH__MASK                       0x003fff00U
#define ADC_CAPTURE__ADC_CAPTURE_LENGTH__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x003fff00U) >> 8)
#define ADC_CAPTURE__ADC_CAPTURE_LENGTH__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 8) & 0x003fff00U)
#define ADC_CAPTURE__ADC_CAPTURE_LENGTH__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x003fff00U) | (((u_int32_t)(src) <<\
                    8) & 0x003fff00U)
#define ADC_CAPTURE__ADC_CAPTURE_LENGTH__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 8) & ~0x003fff00U)))

/* macros for field adc_capture_chn_idx */
#define ADC_CAPTURE__ADC_CAPTURE_CHN_IDX__SHIFT                              22
#define ADC_CAPTURE__ADC_CAPTURE_CHN_IDX__WIDTH                               2
#define ADC_CAPTURE__ADC_CAPTURE_CHN_IDX__MASK                      0x00c00000U
#define ADC_CAPTURE__ADC_CAPTURE_CHN_IDX__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00c00000U) >> 22)
#define ADC_CAPTURE__ADC_CAPTURE_CHN_IDX__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 22) & 0x00c00000U)
#define ADC_CAPTURE__ADC_CAPTURE_CHN_IDX__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00c00000U) | (((u_int32_t)(src) <<\
                    22) & 0x00c00000U)
#define ADC_CAPTURE__ADC_CAPTURE_CHN_IDX__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 22) & ~0x00c00000U)))
#define ADC_CAPTURE__TYPE                                             u_int32_t
#define ADC_CAPTURE__READ                                           0x00ffffffU
#define ADC_CAPTURE__WRITE                                          0x00ffffffU

#endif /* __ADC_CAPTURE_MACRO__ */


/* macros for bb_reg_map.bb_agc_reg_map.BB_adc_capture */
#define INST_BB_REG_MAP__BB_AGC_REG_MAP__BB_ADC_CAPTURE__NUM                  1

/* macros for BlueprintGlobalNameSpace::find_signal_2 */
#ifndef __FIND_SIGNAL_2_MACRO__
#define __FIND_SIGNAL_2_MACRO__

/* macros for field relpwr_weak_db */
#define FIND_SIGNAL_2__RELPWR_WEAK_DB__SHIFT                                  0
#define FIND_SIGNAL_2__RELPWR_WEAK_DB__WIDTH                                  6
#define FIND_SIGNAL_2__RELPWR_WEAK_DB__MASK                         0x0000003fU
#define FIND_SIGNAL_2__RELPWR_WEAK_DB__READ(src) (u_int32_t)(src) & 0x0000003fU
#define FIND_SIGNAL_2__RELPWR_WEAK_DB__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x0000003fU)
#define FIND_SIGNAL_2__RELPWR_WEAK_DB__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000003fU) | ((u_int32_t)(src) &\
                    0x0000003fU)
#define FIND_SIGNAL_2__RELPWR_WEAK_DB__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x0000003fU)))

/* macros for field found_low_ena */
#define FIND_SIGNAL_2__FOUND_LOW_ENA__SHIFT                                   7
#define FIND_SIGNAL_2__FOUND_LOW_ENA__WIDTH                                   1
#define FIND_SIGNAL_2__FOUND_LOW_ENA__MASK                          0x00000080U
#define FIND_SIGNAL_2__FOUND_LOW_ENA__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000080U) >> 7)
#define FIND_SIGNAL_2__FOUND_LOW_ENA__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 7) & 0x00000080U)
#define FIND_SIGNAL_2__FOUND_LOW_ENA__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000080U) | (((u_int32_t)(src) <<\
                    7) & 0x00000080U)
#define FIND_SIGNAL_2__FOUND_LOW_ENA__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 7) & ~0x00000080U)))
#define FIND_SIGNAL_2__FOUND_LOW_ENA__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000080U) | ((u_int32_t)(1) << 7)
#define FIND_SIGNAL_2__FOUND_LOW_ENA__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000080U) | ((u_int32_t)(0) << 7)

/* macros for field found_low */
#define FIND_SIGNAL_2__FOUND_LOW__SHIFT                                       8
#define FIND_SIGNAL_2__FOUND_LOW__WIDTH                                       8
#define FIND_SIGNAL_2__FOUND_LOW__MASK                              0x0000ff00U
#define FIND_SIGNAL_2__FOUND_LOW__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0000ff00U) >> 8)
#define FIND_SIGNAL_2__FOUND_LOW__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 8) & 0x0000ff00U)
#define FIND_SIGNAL_2__FOUND_LOW__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000ff00U) | (((u_int32_t)(src) <<\
                    8) & 0x0000ff00U)
#define FIND_SIGNAL_2__FOUND_LOW__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 8) & ~0x0000ff00U)))

/* macros for field disable_pwr_drop_last_two_sym_vht */
#define FIND_SIGNAL_2__DISABLE_PWR_DROP_LAST_TWO_SYM_VHT__SHIFT              16
#define FIND_SIGNAL_2__DISABLE_PWR_DROP_LAST_TWO_SYM_VHT__WIDTH               1
#define FIND_SIGNAL_2__DISABLE_PWR_DROP_LAST_TWO_SYM_VHT__MASK      0x00010000U
#define FIND_SIGNAL_2__DISABLE_PWR_DROP_LAST_TWO_SYM_VHT__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00010000U) >> 16)
#define FIND_SIGNAL_2__DISABLE_PWR_DROP_LAST_TWO_SYM_VHT__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 16) & 0x00010000U)
#define FIND_SIGNAL_2__DISABLE_PWR_DROP_LAST_TWO_SYM_VHT__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00010000U) | (((u_int32_t)(src) <<\
                    16) & 0x00010000U)
#define FIND_SIGNAL_2__DISABLE_PWR_DROP_LAST_TWO_SYM_VHT__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 16) & ~0x00010000U)))
#define FIND_SIGNAL_2__DISABLE_PWR_DROP_LAST_TWO_SYM_VHT__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00010000U) | ((u_int32_t)(1) << 16)
#define FIND_SIGNAL_2__DISABLE_PWR_DROP_LAST_TWO_SYM_VHT__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00010000U) | ((u_int32_t)(0) << 16)

/* macros for field agcsm_skip_cal_after_reset */
#define FIND_SIGNAL_2__AGCSM_SKIP_CAL_AFTER_RESET__SHIFT                     17
#define FIND_SIGNAL_2__AGCSM_SKIP_CAL_AFTER_RESET__WIDTH                      1
#define FIND_SIGNAL_2__AGCSM_SKIP_CAL_AFTER_RESET__MASK             0x00020000U
#define FIND_SIGNAL_2__AGCSM_SKIP_CAL_AFTER_RESET__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00020000U) >> 17)
#define FIND_SIGNAL_2__AGCSM_SKIP_CAL_AFTER_RESET__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 17) & 0x00020000U)
#define FIND_SIGNAL_2__AGCSM_SKIP_CAL_AFTER_RESET__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00020000U) | (((u_int32_t)(src) <<\
                    17) & 0x00020000U)
#define FIND_SIGNAL_2__AGCSM_SKIP_CAL_AFTER_RESET__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 17) & ~0x00020000U)))
#define FIND_SIGNAL_2__AGCSM_SKIP_CAL_AFTER_RESET__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00020000U) | ((u_int32_t)(1) << 17)
#define FIND_SIGNAL_2__AGCSM_SKIP_CAL_AFTER_RESET__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00020000U) | ((u_int32_t)(0) << 17)

/* macros for field enable_rssi_thr1b */
#define FIND_SIGNAL_2__ENABLE_RSSI_THR1B__SHIFT                              24
#define FIND_SIGNAL_2__ENABLE_RSSI_THR1B__WIDTH                               1
#define FIND_SIGNAL_2__ENABLE_RSSI_THR1B__MASK                      0x01000000U
#define FIND_SIGNAL_2__ENABLE_RSSI_THR1B__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x01000000U) >> 24)
#define FIND_SIGNAL_2__ENABLE_RSSI_THR1B__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 24) & 0x01000000U)
#define FIND_SIGNAL_2__ENABLE_RSSI_THR1B__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x01000000U) | (((u_int32_t)(src) <<\
                    24) & 0x01000000U)
#define FIND_SIGNAL_2__ENABLE_RSSI_THR1B__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 24) & ~0x01000000U)))
#define FIND_SIGNAL_2__ENABLE_RSSI_THR1B__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x01000000U) | ((u_int32_t)(1) << 24)
#define FIND_SIGNAL_2__ENABLE_RSSI_THR1B__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x01000000U) | ((u_int32_t)(0) << 24)

/* macros for field rssi_thr1b */
#define FIND_SIGNAL_2__RSSI_THR1B__SHIFT                                     25
#define FIND_SIGNAL_2__RSSI_THR1B__WIDTH                                      7
#define FIND_SIGNAL_2__RSSI_THR1B__MASK                             0xfe000000U
#define FIND_SIGNAL_2__RSSI_THR1B__READ(src) \
                    (((u_int32_t)(src)\
                    & 0xfe000000U) >> 25)
#define FIND_SIGNAL_2__RSSI_THR1B__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 25) & 0xfe000000U)
#define FIND_SIGNAL_2__RSSI_THR1B__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xfe000000U) | (((u_int32_t)(src) <<\
                    25) & 0xfe000000U)
#define FIND_SIGNAL_2__RSSI_THR1B__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 25) & ~0xfe000000U)))
#define FIND_SIGNAL_2__TYPE                                           u_int32_t
#define FIND_SIGNAL_2__READ                                         0xff03ffbfU
#define FIND_SIGNAL_2__WRITE                                        0xff03ffbfU

#endif /* __FIND_SIGNAL_2_MACRO__ */


/* macros for bb_reg_map.bb_agc_reg_map.BB_find_signal_2 */
#define INST_BB_REG_MAP__BB_AGC_REG_MAP__BB_FIND_SIGNAL_2__NUM                1

/* macros for BlueprintGlobalNameSpace::peak_det_ctrl_3 */
#ifndef __PEAK_DET_CTRL_3_MACRO__
#define __PEAK_DET_CTRL_3_MACRO__

/* macros for field agc_dbdac_reg_setting */
#define PEAK_DET_CTRL_3__AGC_DBDAC_REG_SETTING__SHIFT                         0
#define PEAK_DET_CTRL_3__AGC_DBDAC_REG_SETTING__WIDTH                         4
#define PEAK_DET_CTRL_3__AGC_DBDAC_REG_SETTING__MASK                0x0000000fU
#define PEAK_DET_CTRL_3__AGC_DBDAC_REG_SETTING__READ(src) \
                    (u_int32_t)(src)\
                    & 0x0000000fU
#define PEAK_DET_CTRL_3__AGC_DBDAC_REG_SETTING__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x0000000fU)
#define PEAK_DET_CTRL_3__AGC_DBDAC_REG_SETTING__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000000fU) | ((u_int32_t)(src) &\
                    0x0000000fU)
#define PEAK_DET_CTRL_3__AGC_DBDAC_REG_SETTING__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x0000000fU)))

/* macros for field rfsat_2_add_rfgain_del */
#define PEAK_DET_CTRL_3__RFSAT_2_ADD_RFGAIN_DEL__SHIFT                        4
#define PEAK_DET_CTRL_3__RFSAT_2_ADD_RFGAIN_DEL__WIDTH                       16
#define PEAK_DET_CTRL_3__RFSAT_2_ADD_RFGAIN_DEL__MASK               0x000ffff0U
#define PEAK_DET_CTRL_3__RFSAT_2_ADD_RFGAIN_DEL__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x000ffff0U) >> 4)
#define PEAK_DET_CTRL_3__RFSAT_2_ADD_RFGAIN_DEL__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 4) & 0x000ffff0U)
#define PEAK_DET_CTRL_3__RFSAT_2_ADD_RFGAIN_DEL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000ffff0U) | (((u_int32_t)(src) <<\
                    4) & 0x000ffff0U)
#define PEAK_DET_CTRL_3__RFSAT_2_ADD_RFGAIN_DEL__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 4) & ~0x000ffff0U)))

/* macros for field peak_det_4win_ena */
#define PEAK_DET_CTRL_3__PEAK_DET_4WIN_ENA__SHIFT                            20
#define PEAK_DET_CTRL_3__PEAK_DET_4WIN_ENA__WIDTH                             1
#define PEAK_DET_CTRL_3__PEAK_DET_4WIN_ENA__MASK                    0x00100000U
#define PEAK_DET_CTRL_3__PEAK_DET_4WIN_ENA__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00100000U) >> 20)
#define PEAK_DET_CTRL_3__PEAK_DET_4WIN_ENA__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 20) & 0x00100000U)
#define PEAK_DET_CTRL_3__PEAK_DET_4WIN_ENA__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00100000U) | (((u_int32_t)(src) <<\
                    20) & 0x00100000U)
#define PEAK_DET_CTRL_3__PEAK_DET_4WIN_ENA__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 20) & ~0x00100000U)))
#define PEAK_DET_CTRL_3__PEAK_DET_4WIN_ENA__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00100000U) | ((u_int32_t)(1) << 20)
#define PEAK_DET_CTRL_3__PEAK_DET_4WIN_ENA__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00100000U) | ((u_int32_t)(0) << 20)

/* macros for field peak_det_4win_thr */
#define PEAK_DET_CTRL_3__PEAK_DET_4WIN_THR__SHIFT                            21
#define PEAK_DET_CTRL_3__PEAK_DET_4WIN_THR__WIDTH                             2
#define PEAK_DET_CTRL_3__PEAK_DET_4WIN_THR__MASK                    0x00600000U
#define PEAK_DET_CTRL_3__PEAK_DET_4WIN_THR__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00600000U) >> 21)
#define PEAK_DET_CTRL_3__PEAK_DET_4WIN_THR__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 21) & 0x00600000U)
#define PEAK_DET_CTRL_3__PEAK_DET_4WIN_THR__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00600000U) | (((u_int32_t)(src) <<\
                    21) & 0x00600000U)
#define PEAK_DET_CTRL_3__PEAK_DET_4WIN_THR__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 21) & ~0x00600000U)))

/* macros for field use_common_rf_gain_drop */
#define PEAK_DET_CTRL_3__USE_COMMON_RF_GAIN_DROP__SHIFT                      23
#define PEAK_DET_CTRL_3__USE_COMMON_RF_GAIN_DROP__WIDTH                       1
#define PEAK_DET_CTRL_3__USE_COMMON_RF_GAIN_DROP__MASK              0x00800000U
#define PEAK_DET_CTRL_3__USE_COMMON_RF_GAIN_DROP__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00800000U) >> 23)
#define PEAK_DET_CTRL_3__USE_COMMON_RF_GAIN_DROP__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 23) & 0x00800000U)
#define PEAK_DET_CTRL_3__USE_COMMON_RF_GAIN_DROP__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00800000U) | (((u_int32_t)(src) <<\
                    23) & 0x00800000U)
#define PEAK_DET_CTRL_3__USE_COMMON_RF_GAIN_DROP__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 23) & ~0x00800000U)))
#define PEAK_DET_CTRL_3__USE_COMMON_RF_GAIN_DROP__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00800000U) | ((u_int32_t)(1) << 23)
#define PEAK_DET_CTRL_3__USE_COMMON_RF_GAIN_DROP__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00800000U) | ((u_int32_t)(0) << 23)

/* macros for field xrf_gain_drop_ena */
#define PEAK_DET_CTRL_3__XRF_GAIN_DROP_ENA__SHIFT                            24
#define PEAK_DET_CTRL_3__XRF_GAIN_DROP_ENA__WIDTH                             1
#define PEAK_DET_CTRL_3__XRF_GAIN_DROP_ENA__MASK                    0x01000000U
#define PEAK_DET_CTRL_3__XRF_GAIN_DROP_ENA__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x01000000U) >> 24)
#define PEAK_DET_CTRL_3__XRF_GAIN_DROP_ENA__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 24) & 0x01000000U)
#define PEAK_DET_CTRL_3__XRF_GAIN_DROP_ENA__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x01000000U) | (((u_int32_t)(src) <<\
                    24) & 0x01000000U)
#define PEAK_DET_CTRL_3__XRF_GAIN_DROP_ENA__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 24) & ~0x01000000U)))
#define PEAK_DET_CTRL_3__XRF_GAIN_DROP_ENA__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x01000000U) | ((u_int32_t)(1) << 24)
#define PEAK_DET_CTRL_3__XRF_GAIN_DROP_ENA__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x01000000U) | ((u_int32_t)(0) << 24)

/* macros for field xrf_gain_drop_db */
#define PEAK_DET_CTRL_3__XRF_GAIN_DROP_DB__SHIFT                             25
#define PEAK_DET_CTRL_3__XRF_GAIN_DROP_DB__WIDTH                              5
#define PEAK_DET_CTRL_3__XRF_GAIN_DROP_DB__MASK                     0x3e000000U
#define PEAK_DET_CTRL_3__XRF_GAIN_DROP_DB__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x3e000000U) >> 25)
#define PEAK_DET_CTRL_3__XRF_GAIN_DROP_DB__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 25) & 0x3e000000U)
#define PEAK_DET_CTRL_3__XRF_GAIN_DROP_DB__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x3e000000U) | (((u_int32_t)(src) <<\
                    25) & 0x3e000000U)
#define PEAK_DET_CTRL_3__XRF_GAIN_DROP_DB__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 25) & ~0x3e000000U)))

/* macros for field first_rfsat_gain_increase */
#define PEAK_DET_CTRL_3__FIRST_RFSAT_GAIN_INCREASE__SHIFT                    30
#define PEAK_DET_CTRL_3__FIRST_RFSAT_GAIN_INCREASE__WIDTH                     1
#define PEAK_DET_CTRL_3__FIRST_RFSAT_GAIN_INCREASE__MASK            0x40000000U
#define PEAK_DET_CTRL_3__FIRST_RFSAT_GAIN_INCREASE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x40000000U) >> 30)
#define PEAK_DET_CTRL_3__FIRST_RFSAT_GAIN_INCREASE__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 30) & 0x40000000U)
#define PEAK_DET_CTRL_3__FIRST_RFSAT_GAIN_INCREASE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x40000000U) | (((u_int32_t)(src) <<\
                    30) & 0x40000000U)
#define PEAK_DET_CTRL_3__FIRST_RFSAT_GAIN_INCREASE__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 30) & ~0x40000000U)))
#define PEAK_DET_CTRL_3__FIRST_RFSAT_GAIN_INCREASE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x40000000U) | ((u_int32_t)(1) << 30)
#define PEAK_DET_CTRL_3__FIRST_RFSAT_GAIN_INCREASE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x40000000U) | ((u_int32_t)(0) << 30)
#define PEAK_DET_CTRL_3__TYPE                                         u_int32_t
#define PEAK_DET_CTRL_3__READ                                       0x7fffffffU
#define PEAK_DET_CTRL_3__WRITE                                      0x7fffffffU

#endif /* __PEAK_DET_CTRL_3_MACRO__ */


/* macros for bb_reg_map.bb_agc_reg_map.BB_peak_det_ctrl_3 */
#define INST_BB_REG_MAP__BB_AGC_REG_MAP__BB_PEAK_DET_CTRL_3__NUM              1

/* macros for BlueprintGlobalNameSpace::find_signal2 */
#ifndef __FIND_SIGNAL2_MACRO__
#define __FIND_SIGNAL2_MACRO__

/* macros for field relpwr */
#define FIND_SIGNAL2__RELPWR__SHIFT                                           0
#define FIND_SIGNAL2__RELPWR__WIDTH                                           7
#define FIND_SIGNAL2__RELPWR__MASK                                  0x0000007fU
#define FIND_SIGNAL2__RELPWR__READ(src)          (u_int32_t)(src) & 0x0000007fU
#define FIND_SIGNAL2__RELPWR__WRITE(src)       ((u_int32_t)(src) & 0x0000007fU)
#define FIND_SIGNAL2__RELPWR__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000007fU) | ((u_int32_t)(src) &\
                    0x0000007fU)
#define FIND_SIGNAL2__RELPWR__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x0000007fU)))
#define FIND_SIGNAL2__TYPE                                            u_int32_t
#define FIND_SIGNAL2__READ                                          0x0000007fU
#define FIND_SIGNAL2__WRITE                                         0x0000007fU

#endif /* __FIND_SIGNAL2_MACRO__ */


/* macros for bb_reg_map.bb_agc_reg_map.BB_find_signal2 */
#define INST_BB_REG_MAP__BB_AGC_REG_MAP__BB_FIND_SIGNAL2__NUM                 1

/* macros for BlueprintGlobalNameSpace::srch_fft_ctrl_1 */
#ifndef __SRCH_FFT_CTRL_1_MACRO__
#define __SRCH_FFT_CTRL_1_MACRO__

/* macros for field fft_check_wlan_ena */
#define SRCH_FFT_CTRL_1__FFT_CHECK_WLAN_ENA__SHIFT                            0
#define SRCH_FFT_CTRL_1__FFT_CHECK_WLAN_ENA__WIDTH                            1
#define SRCH_FFT_CTRL_1__FFT_CHECK_WLAN_ENA__MASK                   0x00000001U
#define SRCH_FFT_CTRL_1__FFT_CHECK_WLAN_ENA__READ(src) \
                    (u_int32_t)(src)\
                    & 0x00000001U
#define SRCH_FFT_CTRL_1__FFT_CHECK_WLAN_ENA__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x00000001U)
#define SRCH_FFT_CTRL_1__FFT_CHECK_WLAN_ENA__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | ((u_int32_t)(src) &\
                    0x00000001U)
#define SRCH_FFT_CTRL_1__FFT_CHECK_WLAN_ENA__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00000001U)))
#define SRCH_FFT_CTRL_1__FFT_CHECK_WLAN_ENA__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(1)
#define SRCH_FFT_CTRL_1__FFT_CHECK_WLAN_ENA__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(0)

/* macros for field fft_check_radar_ena */
#define SRCH_FFT_CTRL_1__FFT_CHECK_RADAR_ENA__SHIFT                           1
#define SRCH_FFT_CTRL_1__FFT_CHECK_RADAR_ENA__WIDTH                           1
#define SRCH_FFT_CTRL_1__FFT_CHECK_RADAR_ENA__MASK                  0x00000002U
#define SRCH_FFT_CTRL_1__FFT_CHECK_RADAR_ENA__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000002U) >> 1)
#define SRCH_FFT_CTRL_1__FFT_CHECK_RADAR_ENA__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 1) & 0x00000002U)
#define SRCH_FFT_CTRL_1__FFT_CHECK_RADAR_ENA__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | (((u_int32_t)(src) <<\
                    1) & 0x00000002U)
#define SRCH_FFT_CTRL_1__FFT_CHECK_RADAR_ENA__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 1) & ~0x00000002U)))
#define SRCH_FFT_CTRL_1__FFT_CHECK_RADAR_ENA__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | ((u_int32_t)(1) << 1)
#define SRCH_FFT_CTRL_1__FFT_CHECK_RADAR_ENA__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | ((u_int32_t)(0) << 1)

/* macros for field radar_fft_pwr_format */
#define SRCH_FFT_CTRL_1__RADAR_FFT_PWR_FORMAT__SHIFT                          2
#define SRCH_FFT_CTRL_1__RADAR_FFT_PWR_FORMAT__WIDTH                          1
#define SRCH_FFT_CTRL_1__RADAR_FFT_PWR_FORMAT__MASK                 0x00000004U
#define SRCH_FFT_CTRL_1__RADAR_FFT_PWR_FORMAT__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000004U) >> 2)
#define SRCH_FFT_CTRL_1__RADAR_FFT_PWR_FORMAT__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 2) & 0x00000004U)
#define SRCH_FFT_CTRL_1__RADAR_FFT_PWR_FORMAT__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000004U) | (((u_int32_t)(src) <<\
                    2) & 0x00000004U)
#define SRCH_FFT_CTRL_1__RADAR_FFT_PWR_FORMAT__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 2) & ~0x00000004U)))
#define SRCH_FFT_CTRL_1__RADAR_FFT_PWR_FORMAT__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000004U) | ((u_int32_t)(1) << 2)
#define SRCH_FFT_CTRL_1__RADAR_FFT_PWR_FORMAT__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000004U) | ((u_int32_t)(0) << 2)

/* macros for field spectral_scan_pwr_format */
#define SRCH_FFT_CTRL_1__SPECTRAL_SCAN_PWR_FORMAT__SHIFT                      3
#define SRCH_FFT_CTRL_1__SPECTRAL_SCAN_PWR_FORMAT__WIDTH                      1
#define SRCH_FFT_CTRL_1__SPECTRAL_SCAN_PWR_FORMAT__MASK             0x00000008U
#define SRCH_FFT_CTRL_1__SPECTRAL_SCAN_PWR_FORMAT__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000008U) >> 3)
#define SRCH_FFT_CTRL_1__SPECTRAL_SCAN_PWR_FORMAT__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 3) & 0x00000008U)
#define SRCH_FFT_CTRL_1__SPECTRAL_SCAN_PWR_FORMAT__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000008U) | (((u_int32_t)(src) <<\
                    3) & 0x00000008U)
#define SRCH_FFT_CTRL_1__SPECTRAL_SCAN_PWR_FORMAT__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 3) & ~0x00000008U)))
#define SRCH_FFT_CTRL_1__SPECTRAL_SCAN_PWR_FORMAT__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000008U) | ((u_int32_t)(1) << 3)
#define SRCH_FFT_CTRL_1__SPECTRAL_SCAN_PWR_FORMAT__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000008U) | ((u_int32_t)(0) << 3)

/* macros for field radar_fft_rpt_mode */
#define SRCH_FFT_CTRL_1__RADAR_FFT_RPT_MODE__SHIFT                            4
#define SRCH_FFT_CTRL_1__RADAR_FFT_RPT_MODE__WIDTH                            2
#define SRCH_FFT_CTRL_1__RADAR_FFT_RPT_MODE__MASK                   0x00000030U
#define SRCH_FFT_CTRL_1__RADAR_FFT_RPT_MODE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000030U) >> 4)
#define SRCH_FFT_CTRL_1__RADAR_FFT_RPT_MODE__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 4) & 0x00000030U)
#define SRCH_FFT_CTRL_1__RADAR_FFT_RPT_MODE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000030U) | (((u_int32_t)(src) <<\
                    4) & 0x00000030U)
#define SRCH_FFT_CTRL_1__RADAR_FFT_RPT_MODE__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 4) & ~0x00000030U)))

/* macros for field spectral_scan_rpt_mode */
#define SRCH_FFT_CTRL_1__SPECTRAL_SCAN_RPT_MODE__SHIFT                        6
#define SRCH_FFT_CTRL_1__SPECTRAL_SCAN_RPT_MODE__WIDTH                        2
#define SRCH_FFT_CTRL_1__SPECTRAL_SCAN_RPT_MODE__MASK               0x000000c0U
#define SRCH_FFT_CTRL_1__SPECTRAL_SCAN_RPT_MODE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x000000c0U) >> 6)
#define SRCH_FFT_CTRL_1__SPECTRAL_SCAN_RPT_MODE__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 6) & 0x000000c0U)
#define SRCH_FFT_CTRL_1__SPECTRAL_SCAN_RPT_MODE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000000c0U) | (((u_int32_t)(src) <<\
                    6) & 0x000000c0U)
#define SRCH_FFT_CTRL_1__SPECTRAL_SCAN_RPT_MODE__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 6) & ~0x000000c0U)))

/* macros for field radar_fft_bin_scale */
#define SRCH_FFT_CTRL_1__RADAR_FFT_BIN_SCALE__SHIFT                           8
#define SRCH_FFT_CTRL_1__RADAR_FFT_BIN_SCALE__WIDTH                           2
#define SRCH_FFT_CTRL_1__RADAR_FFT_BIN_SCALE__MASK                  0x00000300U
#define SRCH_FFT_CTRL_1__RADAR_FFT_BIN_SCALE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000300U) >> 8)
#define SRCH_FFT_CTRL_1__RADAR_FFT_BIN_SCALE__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 8) & 0x00000300U)
#define SRCH_FFT_CTRL_1__RADAR_FFT_BIN_SCALE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000300U) | (((u_int32_t)(src) <<\
                    8) & 0x00000300U)
#define SRCH_FFT_CTRL_1__RADAR_FFT_BIN_SCALE__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 8) & ~0x00000300U)))

/* macros for field spectral_scan_bin_scale */
#define SRCH_FFT_CTRL_1__SPECTRAL_SCAN_BIN_SCALE__SHIFT                      10
#define SRCH_FFT_CTRL_1__SPECTRAL_SCAN_BIN_SCALE__WIDTH                       2
#define SRCH_FFT_CTRL_1__SPECTRAL_SCAN_BIN_SCALE__MASK              0x00000c00U
#define SRCH_FFT_CTRL_1__SPECTRAL_SCAN_BIN_SCALE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000c00U) >> 10)
#define SRCH_FFT_CTRL_1__SPECTRAL_SCAN_BIN_SCALE__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 10) & 0x00000c00U)
#define SRCH_FFT_CTRL_1__SPECTRAL_SCAN_BIN_SCALE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000c00U) | (((u_int32_t)(src) <<\
                    10) & 0x00000c00U)
#define SRCH_FFT_CTRL_1__SPECTRAL_SCAN_BIN_SCALE__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 10) & ~0x00000c00U)))

/* macros for field srch_fft_scale_vec */
#define SRCH_FFT_CTRL_1__SRCH_FFT_SCALE_VEC__SHIFT                           12
#define SRCH_FFT_CTRL_1__SRCH_FFT_SCALE_VEC__WIDTH                           12
#define SRCH_FFT_CTRL_1__SRCH_FFT_SCALE_VEC__MASK                   0x00fff000U
#define SRCH_FFT_CTRL_1__SRCH_FFT_SCALE_VEC__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00fff000U) >> 12)
#define SRCH_FFT_CTRL_1__SRCH_FFT_SCALE_VEC__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 12) & 0x00fff000U)
#define SRCH_FFT_CTRL_1__SRCH_FFT_SCALE_VEC__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00fff000U) | (((u_int32_t)(src) <<\
                    12) & 0x00fff000U)
#define SRCH_FFT_CTRL_1__SRCH_FFT_SCALE_VEC__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 12) & ~0x00fff000U)))

/* macros for field radar_fft_long_period */
#define SRCH_FFT_CTRL_1__RADAR_FFT_LONG_PERIOD__SHIFT                        24
#define SRCH_FFT_CTRL_1__RADAR_FFT_LONG_PERIOD__WIDTH                         4
#define SRCH_FFT_CTRL_1__RADAR_FFT_LONG_PERIOD__MASK                0x0f000000U
#define SRCH_FFT_CTRL_1__RADAR_FFT_LONG_PERIOD__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0f000000U) >> 24)
#define SRCH_FFT_CTRL_1__RADAR_FFT_LONG_PERIOD__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 24) & 0x0f000000U)
#define SRCH_FFT_CTRL_1__RADAR_FFT_LONG_PERIOD__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0f000000U) | (((u_int32_t)(src) <<\
                    24) & 0x0f000000U)
#define SRCH_FFT_CTRL_1__RADAR_FFT_LONG_PERIOD__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 24) & ~0x0f000000U)))

/* macros for field fft_check_fine_ena */
#define SRCH_FFT_CTRL_1__FFT_CHECK_FINE_ENA__SHIFT                           28
#define SRCH_FFT_CTRL_1__FFT_CHECK_FINE_ENA__WIDTH                            1
#define SRCH_FFT_CTRL_1__FFT_CHECK_FINE_ENA__MASK                   0x10000000U
#define SRCH_FFT_CTRL_1__FFT_CHECK_FINE_ENA__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x10000000U) >> 28)
#define SRCH_FFT_CTRL_1__FFT_CHECK_FINE_ENA__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 28) & 0x10000000U)
#define SRCH_FFT_CTRL_1__FFT_CHECK_FINE_ENA__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x10000000U) | (((u_int32_t)(src) <<\
                    28) & 0x10000000U)
#define SRCH_FFT_CTRL_1__FFT_CHECK_FINE_ENA__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 28) & ~0x10000000U)))
#define SRCH_FFT_CTRL_1__FFT_CHECK_FINE_ENA__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x10000000U) | ((u_int32_t)(1) << 28)
#define SRCH_FFT_CTRL_1__FFT_CHECK_FINE_ENA__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x10000000U) | ((u_int32_t)(0) << 28)

/* macros for field radar_fft_dBm_adj */
#define SRCH_FFT_CTRL_1__RADAR_FFT_DBM_ADJ__SHIFT                            29
#define SRCH_FFT_CTRL_1__RADAR_FFT_DBM_ADJ__WIDTH                             1
#define SRCH_FFT_CTRL_1__RADAR_FFT_DBM_ADJ__MASK                    0x20000000U
#define SRCH_FFT_CTRL_1__RADAR_FFT_DBM_ADJ__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x20000000U) >> 29)
#define SRCH_FFT_CTRL_1__RADAR_FFT_DBM_ADJ__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 29) & 0x20000000U)
#define SRCH_FFT_CTRL_1__RADAR_FFT_DBM_ADJ__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x20000000U) | (((u_int32_t)(src) <<\
                    29) & 0x20000000U)
#define SRCH_FFT_CTRL_1__RADAR_FFT_DBM_ADJ__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 29) & ~0x20000000U)))
#define SRCH_FFT_CTRL_1__RADAR_FFT_DBM_ADJ__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x20000000U) | ((u_int32_t)(1) << 29)
#define SRCH_FFT_CTRL_1__RADAR_FFT_DBM_ADJ__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x20000000U) | ((u_int32_t)(0) << 29)

/* macros for field spectral_scan_dBm_adj */
#define SRCH_FFT_CTRL_1__SPECTRAL_SCAN_DBM_ADJ__SHIFT                        30
#define SRCH_FFT_CTRL_1__SPECTRAL_SCAN_DBM_ADJ__WIDTH                         1
#define SRCH_FFT_CTRL_1__SPECTRAL_SCAN_DBM_ADJ__MASK                0x40000000U
#define SRCH_FFT_CTRL_1__SPECTRAL_SCAN_DBM_ADJ__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x40000000U) >> 30)
#define SRCH_FFT_CTRL_1__SPECTRAL_SCAN_DBM_ADJ__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 30) & 0x40000000U)
#define SRCH_FFT_CTRL_1__SPECTRAL_SCAN_DBM_ADJ__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x40000000U) | (((u_int32_t)(src) <<\
                    30) & 0x40000000U)
#define SRCH_FFT_CTRL_1__SPECTRAL_SCAN_DBM_ADJ__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 30) & ~0x40000000U)))
#define SRCH_FFT_CTRL_1__SPECTRAL_SCAN_DBM_ADJ__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x40000000U) | ((u_int32_t)(1) << 30)
#define SRCH_FFT_CTRL_1__SPECTRAL_SCAN_DBM_ADJ__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x40000000U) | ((u_int32_t)(0) << 30)

/* macros for field pulse_check_srch_fft */
#define SRCH_FFT_CTRL_1__PULSE_CHECK_SRCH_FFT__SHIFT                         31
#define SRCH_FFT_CTRL_1__PULSE_CHECK_SRCH_FFT__WIDTH                          1
#define SRCH_FFT_CTRL_1__PULSE_CHECK_SRCH_FFT__MASK                 0x80000000U
#define SRCH_FFT_CTRL_1__PULSE_CHECK_SRCH_FFT__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x80000000U) >> 31)
#define SRCH_FFT_CTRL_1__PULSE_CHECK_SRCH_FFT__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 31) & 0x80000000U)
#define SRCH_FFT_CTRL_1__PULSE_CHECK_SRCH_FFT__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x80000000U) | (((u_int32_t)(src) <<\
                    31) & 0x80000000U)
#define SRCH_FFT_CTRL_1__PULSE_CHECK_SRCH_FFT__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 31) & ~0x80000000U)))
#define SRCH_FFT_CTRL_1__PULSE_CHECK_SRCH_FFT__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x80000000U) | ((u_int32_t)(1) << 31)
#define SRCH_FFT_CTRL_1__PULSE_CHECK_SRCH_FFT__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x80000000U) | ((u_int32_t)(0) << 31)
#define SRCH_FFT_CTRL_1__TYPE                                         u_int32_t
#define SRCH_FFT_CTRL_1__READ                                       0xffffffffU
#define SRCH_FFT_CTRL_1__WRITE                                      0xffffffffU

#endif /* __SRCH_FFT_CTRL_1_MACRO__ */


/* macros for bb_reg_map.bb_agc_reg_map.BB_srch_fft_ctrl_1 */
#define INST_BB_REG_MAP__BB_AGC_REG_MAP__BB_SRCH_FFT_CTRL_1__NUM              1

/* macros for BlueprintGlobalNameSpace::srch_fft_ctrl_2 */
#ifndef __SRCH_FFT_CTRL_2_MACRO__
#define __SRCH_FFT_CTRL_2_MACRO__

/* macros for field srch_fft_sb_freq */
#define SRCH_FFT_CTRL_2__SRCH_FFT_SB_FREQ__SHIFT                              0
#define SRCH_FFT_CTRL_2__SRCH_FFT_SB_FREQ__WIDTH                             12
#define SRCH_FFT_CTRL_2__SRCH_FFT_SB_FREQ__MASK                     0x00000fffU
#define SRCH_FFT_CTRL_2__SRCH_FFT_SB_FREQ__READ(src) \
                    (u_int32_t)(src)\
                    & 0x00000fffU
#define SRCH_FFT_CTRL_2__SRCH_FFT_SB_FREQ__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x00000fffU)
#define SRCH_FFT_CTRL_2__SRCH_FFT_SB_FREQ__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000fffU) | ((u_int32_t)(src) &\
                    0x00000fffU)
#define SRCH_FFT_CTRL_2__SRCH_FFT_SB_FREQ__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00000fffU)))

/* macros for field srch_fft_ib_thr */
#define SRCH_FFT_CTRL_2__SRCH_FFT_IB_THR__SHIFT                              12
#define SRCH_FFT_CTRL_2__SRCH_FFT_IB_THR__WIDTH                               7
#define SRCH_FFT_CTRL_2__SRCH_FFT_IB_THR__MASK                      0x0007f000U
#define SRCH_FFT_CTRL_2__SRCH_FFT_IB_THR__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0007f000U) >> 12)
#define SRCH_FFT_CTRL_2__SRCH_FFT_IB_THR__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 12) & 0x0007f000U)
#define SRCH_FFT_CTRL_2__SRCH_FFT_IB_THR__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0007f000U) | (((u_int32_t)(src) <<\
                    12) & 0x0007f000U)
#define SRCH_FFT_CTRL_2__SRCH_FFT_IB_THR__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 12) & ~0x0007f000U)))

/* macros for field radar_fft_bw_priority */
#define SRCH_FFT_CTRL_2__RADAR_FFT_BW_PRIORITY__SHIFT                        19
#define SRCH_FFT_CTRL_2__RADAR_FFT_BW_PRIORITY__WIDTH                         1
#define SRCH_FFT_CTRL_2__RADAR_FFT_BW_PRIORITY__MASK                0x00080000U
#define SRCH_FFT_CTRL_2__RADAR_FFT_BW_PRIORITY__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00080000U) >> 19)
#define SRCH_FFT_CTRL_2__RADAR_FFT_BW_PRIORITY__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 19) & 0x00080000U)
#define SRCH_FFT_CTRL_2__RADAR_FFT_BW_PRIORITY__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00080000U) | (((u_int32_t)(src) <<\
                    19) & 0x00080000U)
#define SRCH_FFT_CTRL_2__RADAR_FFT_BW_PRIORITY__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 19) & ~0x00080000U)))
#define SRCH_FFT_CTRL_2__RADAR_FFT_BW_PRIORITY__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00080000U) | ((u_int32_t)(1) << 19)
#define SRCH_FFT_CTRL_2__RADAR_FFT_BW_PRIORITY__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00080000U) | ((u_int32_t)(0) << 19)

/* macros for field str_bin_thr_wlan */
#define SRCH_FFT_CTRL_2__STR_BIN_THR_WLAN__SHIFT                             20
#define SRCH_FFT_CTRL_2__STR_BIN_THR_WLAN__WIDTH                              6
#define SRCH_FFT_CTRL_2__STR_BIN_THR_WLAN__MASK                     0x03f00000U
#define SRCH_FFT_CTRL_2__STR_BIN_THR_WLAN__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x03f00000U) >> 20)
#define SRCH_FFT_CTRL_2__STR_BIN_THR_WLAN__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 20) & 0x03f00000U)
#define SRCH_FFT_CTRL_2__STR_BIN_THR_WLAN__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x03f00000U) | (((u_int32_t)(src) <<\
                    20) & 0x03f00000U)
#define SRCH_FFT_CTRL_2__STR_BIN_THR_WLAN__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 20) & ~0x03f00000U)))

/* macros for field str_bin_thr_radar */
#define SRCH_FFT_CTRL_2__STR_BIN_THR_RADAR__SHIFT                            26
#define SRCH_FFT_CTRL_2__STR_BIN_THR_RADAR__WIDTH                             6
#define SRCH_FFT_CTRL_2__STR_BIN_THR_RADAR__MASK                    0xfc000000U
#define SRCH_FFT_CTRL_2__STR_BIN_THR_RADAR__READ(src) \
                    (((u_int32_t)(src)\
                    & 0xfc000000U) >> 26)
#define SRCH_FFT_CTRL_2__STR_BIN_THR_RADAR__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 26) & 0xfc000000U)
#define SRCH_FFT_CTRL_2__STR_BIN_THR_RADAR__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xfc000000U) | (((u_int32_t)(src) <<\
                    26) & 0xfc000000U)
#define SRCH_FFT_CTRL_2__STR_BIN_THR_RADAR__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 26) & ~0xfc000000U)))
#define SRCH_FFT_CTRL_2__TYPE                                         u_int32_t
#define SRCH_FFT_CTRL_2__READ                                       0xffffffffU
#define SRCH_FFT_CTRL_2__WRITE                                      0xffffffffU

#endif /* __SRCH_FFT_CTRL_2_MACRO__ */


/* macros for bb_reg_map.bb_agc_reg_map.BB_srch_fft_ctrl_2 */
#define INST_BB_REG_MAP__BB_AGC_REG_MAP__BB_SRCH_FFT_CTRL_2__NUM              1

/* macros for BlueprintGlobalNameSpace::srch_fft_ctrl_3 */
#ifndef __SRCH_FFT_CTRL_3_MACRO__
#define __SRCH_FFT_CTRL_3_MACRO__

/* macros for field nb_tone_thr_wlan */
#define SRCH_FFT_CTRL_3__NB_TONE_THR_WLAN__SHIFT                              0
#define SRCH_FFT_CTRL_3__NB_TONE_THR_WLAN__WIDTH                              8
#define SRCH_FFT_CTRL_3__NB_TONE_THR_WLAN__MASK                     0x000000ffU
#define SRCH_FFT_CTRL_3__NB_TONE_THR_WLAN__READ(src) \
                    (u_int32_t)(src)\
                    & 0x000000ffU
#define SRCH_FFT_CTRL_3__NB_TONE_THR_WLAN__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x000000ffU)
#define SRCH_FFT_CTRL_3__NB_TONE_THR_WLAN__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000000ffU) | ((u_int32_t)(src) &\
                    0x000000ffU)
#define SRCH_FFT_CTRL_3__NB_TONE_THR_WLAN__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x000000ffU)))

/* macros for field nb_tone_thr_radar_coarse */
#define SRCH_FFT_CTRL_3__NB_TONE_THR_RADAR_COARSE__SHIFT                      8
#define SRCH_FFT_CTRL_3__NB_TONE_THR_RADAR_COARSE__WIDTH                      8
#define SRCH_FFT_CTRL_3__NB_TONE_THR_RADAR_COARSE__MASK             0x0000ff00U
#define SRCH_FFT_CTRL_3__NB_TONE_THR_RADAR_COARSE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0000ff00U) >> 8)
#define SRCH_FFT_CTRL_3__NB_TONE_THR_RADAR_COARSE__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 8) & 0x0000ff00U)
#define SRCH_FFT_CTRL_3__NB_TONE_THR_RADAR_COARSE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000ff00U) | (((u_int32_t)(src) <<\
                    8) & 0x0000ff00U)
#define SRCH_FFT_CTRL_3__NB_TONE_THR_RADAR_COARSE__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 8) & ~0x0000ff00U)))

/* macros for field nb_tone_thr_radar_fine */
#define SRCH_FFT_CTRL_3__NB_TONE_THR_RADAR_FINE__SHIFT                       16
#define SRCH_FFT_CTRL_3__NB_TONE_THR_RADAR_FINE__WIDTH                        8
#define SRCH_FFT_CTRL_3__NB_TONE_THR_RADAR_FINE__MASK               0x00ff0000U
#define SRCH_FFT_CTRL_3__NB_TONE_THR_RADAR_FINE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00ff0000U) >> 16)
#define SRCH_FFT_CTRL_3__NB_TONE_THR_RADAR_FINE__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 16) & 0x00ff0000U)
#define SRCH_FFT_CTRL_3__NB_TONE_THR_RADAR_FINE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00ff0000U) | (((u_int32_t)(src) <<\
                    16) & 0x00ff0000U)
#define SRCH_FFT_CTRL_3__NB_TONE_THR_RADAR_FINE__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 16) & ~0x00ff0000U)))

/* macros for field nb_tone_thr_radar_blk */
#define SRCH_FFT_CTRL_3__NB_TONE_THR_RADAR_BLK__SHIFT                        24
#define SRCH_FFT_CTRL_3__NB_TONE_THR_RADAR_BLK__WIDTH                         8
#define SRCH_FFT_CTRL_3__NB_TONE_THR_RADAR_BLK__MASK                0xff000000U
#define SRCH_FFT_CTRL_3__NB_TONE_THR_RADAR_BLK__READ(src) \
                    (((u_int32_t)(src)\
                    & 0xff000000U) >> 24)
#define SRCH_FFT_CTRL_3__NB_TONE_THR_RADAR_BLK__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 24) & 0xff000000U)
#define SRCH_FFT_CTRL_3__NB_TONE_THR_RADAR_BLK__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xff000000U) | (((u_int32_t)(src) <<\
                    24) & 0xff000000U)
#define SRCH_FFT_CTRL_3__NB_TONE_THR_RADAR_BLK__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 24) & ~0xff000000U)))
#define SRCH_FFT_CTRL_3__TYPE                                         u_int32_t
#define SRCH_FFT_CTRL_3__READ                                       0xffffffffU
#define SRCH_FFT_CTRL_3__WRITE                                      0xffffffffU

#endif /* __SRCH_FFT_CTRL_3_MACRO__ */


/* macros for bb_reg_map.bb_agc_reg_map.BB_srch_fft_ctrl_3 */
#define INST_BB_REG_MAP__BB_AGC_REG_MAP__BB_SRCH_FFT_CTRL_3__NUM              1

/* macros for BlueprintGlobalNameSpace::srch_fft_ctrl_4 */
#ifndef __SRCH_FFT_CTRL_4_MACRO__
#define __SRCH_FFT_CTRL_4_MACRO__

/* macros for field radar_fft_chn_mask */
#define SRCH_FFT_CTRL_4__RADAR_FFT_CHN_MASK__SHIFT                            0
#define SRCH_FFT_CTRL_4__RADAR_FFT_CHN_MASK__WIDTH                            4
#define SRCH_FFT_CTRL_4__RADAR_FFT_CHN_MASK__MASK                   0x0000000fU
#define SRCH_FFT_CTRL_4__RADAR_FFT_CHN_MASK__READ(src) \
                    (u_int32_t)(src)\
                    & 0x0000000fU
#define SRCH_FFT_CTRL_4__RADAR_FFT_CHN_MASK__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x0000000fU)
#define SRCH_FFT_CTRL_4__RADAR_FFT_CHN_MASK__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000000fU) | ((u_int32_t)(src) &\
                    0x0000000fU)
#define SRCH_FFT_CTRL_4__RADAR_FFT_CHN_MASK__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x0000000fU)))

/* macros for field spectral_scan_chn_mask */
#define SRCH_FFT_CTRL_4__SPECTRAL_SCAN_CHN_MASK__SHIFT                        4
#define SRCH_FFT_CTRL_4__SPECTRAL_SCAN_CHN_MASK__WIDTH                        4
#define SRCH_FFT_CTRL_4__SPECTRAL_SCAN_CHN_MASK__MASK               0x000000f0U
#define SRCH_FFT_CTRL_4__SPECTRAL_SCAN_CHN_MASK__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x000000f0U) >> 4)
#define SRCH_FFT_CTRL_4__SPECTRAL_SCAN_CHN_MASK__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 4) & 0x000000f0U)
#define SRCH_FFT_CTRL_4__SPECTRAL_SCAN_CHN_MASK__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000000f0U) | (((u_int32_t)(src) <<\
                    4) & 0x000000f0U)
#define SRCH_FFT_CTRL_4__SPECTRAL_SCAN_CHN_MASK__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 4) & ~0x000000f0U)))

/* macros for field srch_fft_rfsat_peakmag_thr */
#define SRCH_FFT_CTRL_4__SRCH_FFT_RFSAT_PEAKMAG_THR__SHIFT                    8
#define SRCH_FFT_CTRL_4__SRCH_FFT_RFSAT_PEAKMAG_THR__WIDTH                   10
#define SRCH_FFT_CTRL_4__SRCH_FFT_RFSAT_PEAKMAG_THR__MASK           0x0003ff00U
#define SRCH_FFT_CTRL_4__SRCH_FFT_RFSAT_PEAKMAG_THR__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0003ff00U) >> 8)
#define SRCH_FFT_CTRL_4__SRCH_FFT_RFSAT_PEAKMAG_THR__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 8) & 0x0003ff00U)
#define SRCH_FFT_CTRL_4__SRCH_FFT_RFSAT_PEAKMAG_THR__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0003ff00U) | (((u_int32_t)(src) <<\
                    8) & 0x0003ff00U)
#define SRCH_FFT_CTRL_4__SRCH_FFT_RFSAT_PEAKMAG_THR__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 8) & ~0x0003ff00U)))

/* macros for field srch_fft_pwr_low_cap */
#define SRCH_FFT_CTRL_4__SRCH_FFT_PWR_LOW_CAP__SHIFT                         18
#define SRCH_FFT_CTRL_4__SRCH_FFT_PWR_LOW_CAP__WIDTH                          6
#define SRCH_FFT_CTRL_4__SRCH_FFT_PWR_LOW_CAP__MASK                 0x00fc0000U
#define SRCH_FFT_CTRL_4__SRCH_FFT_PWR_LOW_CAP__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00fc0000U) >> 18)
#define SRCH_FFT_CTRL_4__SRCH_FFT_PWR_LOW_CAP__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 18) & 0x00fc0000U)
#define SRCH_FFT_CTRL_4__SRCH_FFT_PWR_LOW_CAP__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00fc0000U) | (((u_int32_t)(src) <<\
                    18) & 0x00fc0000U)
#define SRCH_FFT_CTRL_4__SRCH_FFT_PWR_LOW_CAP__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 18) & ~0x00fc0000U)))

/* macros for field srch_fft_pwr_drop_ratio */
#define SRCH_FFT_CTRL_4__SRCH_FFT_PWR_DROP_RATIO__SHIFT                      24
#define SRCH_FFT_CTRL_4__SRCH_FFT_PWR_DROP_RATIO__WIDTH                       4
#define SRCH_FFT_CTRL_4__SRCH_FFT_PWR_DROP_RATIO__MASK              0x0f000000U
#define SRCH_FFT_CTRL_4__SRCH_FFT_PWR_DROP_RATIO__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0f000000U) >> 24)
#define SRCH_FFT_CTRL_4__SRCH_FFT_PWR_DROP_RATIO__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 24) & 0x0f000000U)
#define SRCH_FFT_CTRL_4__SRCH_FFT_PWR_DROP_RATIO__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0f000000U) | (((u_int32_t)(src) <<\
                    24) & 0x0f000000U)
#define SRCH_FFT_CTRL_4__SRCH_FFT_PWR_DROP_RATIO__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 24) & ~0x0f000000U)))

/* macros for field srch_fft_dc_scale_inband */
#define SRCH_FFT_CTRL_4__SRCH_FFT_DC_SCALE_INBAND__SHIFT                     28
#define SRCH_FFT_CTRL_4__SRCH_FFT_DC_SCALE_INBAND__WIDTH                      3
#define SRCH_FFT_CTRL_4__SRCH_FFT_DC_SCALE_INBAND__MASK             0x70000000U
#define SRCH_FFT_CTRL_4__SRCH_FFT_DC_SCALE_INBAND__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x70000000U) >> 28)
#define SRCH_FFT_CTRL_4__SRCH_FFT_DC_SCALE_INBAND__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 28) & 0x70000000U)
#define SRCH_FFT_CTRL_4__SRCH_FFT_DC_SCALE_INBAND__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x70000000U) | (((u_int32_t)(src) <<\
                    28) & 0x70000000U)
#define SRCH_FFT_CTRL_4__SRCH_FFT_DC_SCALE_INBAND__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 28) & ~0x70000000U)))

/* macros for field radar_fft_short_rpt_sel */
#define SRCH_FFT_CTRL_4__RADAR_FFT_SHORT_RPT_SEL__SHIFT                      31
#define SRCH_FFT_CTRL_4__RADAR_FFT_SHORT_RPT_SEL__WIDTH                       1
#define SRCH_FFT_CTRL_4__RADAR_FFT_SHORT_RPT_SEL__MASK              0x80000000U
#define SRCH_FFT_CTRL_4__RADAR_FFT_SHORT_RPT_SEL__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x80000000U) >> 31)
#define SRCH_FFT_CTRL_4__RADAR_FFT_SHORT_RPT_SEL__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 31) & 0x80000000U)
#define SRCH_FFT_CTRL_4__RADAR_FFT_SHORT_RPT_SEL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x80000000U) | (((u_int32_t)(src) <<\
                    31) & 0x80000000U)
#define SRCH_FFT_CTRL_4__RADAR_FFT_SHORT_RPT_SEL__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 31) & ~0x80000000U)))
#define SRCH_FFT_CTRL_4__RADAR_FFT_SHORT_RPT_SEL__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x80000000U) | ((u_int32_t)(1) << 31)
#define SRCH_FFT_CTRL_4__RADAR_FFT_SHORT_RPT_SEL__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x80000000U) | ((u_int32_t)(0) << 31)
#define SRCH_FFT_CTRL_4__TYPE                                         u_int32_t
#define SRCH_FFT_CTRL_4__READ                                       0xffffffffU
#define SRCH_FFT_CTRL_4__WRITE                                      0xffffffffU

#endif /* __SRCH_FFT_CTRL_4_MACRO__ */


/* macros for bb_reg_map.bb_agc_reg_map.BB_srch_fft_ctrl_4 */
#define INST_BB_REG_MAP__BB_AGC_REG_MAP__BB_SRCH_FFT_CTRL_4__NUM              1

/* macros for BlueprintGlobalNameSpace::radar_chirp_detect */
#ifndef __RADAR_CHIRP_DETECT_MACRO__
#define __RADAR_CHIRP_DETECT_MACRO__

/* macros for field chirp_max_num_diff */
#define RADAR_CHIRP_DETECT__CHIRP_MAX_NUM_DIFF__SHIFT                         0
#define RADAR_CHIRP_DETECT__CHIRP_MAX_NUM_DIFF__WIDTH                         3
#define RADAR_CHIRP_DETECT__CHIRP_MAX_NUM_DIFF__MASK                0x00000007U
#define RADAR_CHIRP_DETECT__CHIRP_MAX_NUM_DIFF__READ(src) \
                    (u_int32_t)(src)\
                    & 0x00000007U
#define RADAR_CHIRP_DETECT__CHIRP_MAX_NUM_DIFF__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x00000007U)
#define RADAR_CHIRP_DETECT__CHIRP_MAX_NUM_DIFF__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000007U) | ((u_int32_t)(src) &\
                    0x00000007U)
#define RADAR_CHIRP_DETECT__CHIRP_MAX_NUM_DIFF__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00000007U)))

/* macros for field chirp_min_delta_bin */
#define RADAR_CHIRP_DETECT__CHIRP_MIN_DELTA_BIN__SHIFT                        3
#define RADAR_CHIRP_DETECT__CHIRP_MIN_DELTA_BIN__WIDTH                        5
#define RADAR_CHIRP_DETECT__CHIRP_MIN_DELTA_BIN__MASK               0x000000f8U
#define RADAR_CHIRP_DETECT__CHIRP_MIN_DELTA_BIN__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x000000f8U) >> 3)
#define RADAR_CHIRP_DETECT__CHIRP_MIN_DELTA_BIN__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 3) & 0x000000f8U)
#define RADAR_CHIRP_DETECT__CHIRP_MIN_DELTA_BIN__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000000f8U) | (((u_int32_t)(src) <<\
                    3) & 0x000000f8U)
#define RADAR_CHIRP_DETECT__CHIRP_MIN_DELTA_BIN__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 3) & ~0x000000f8U)))

/* macros for field chirp_max_delta_bin */
#define RADAR_CHIRP_DETECT__CHIRP_MAX_DELTA_BIN__SHIFT                        8
#define RADAR_CHIRP_DETECT__CHIRP_MAX_DELTA_BIN__WIDTH                        5
#define RADAR_CHIRP_DETECT__CHIRP_MAX_DELTA_BIN__MASK               0x00001f00U
#define RADAR_CHIRP_DETECT__CHIRP_MAX_DELTA_BIN__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00001f00U) >> 8)
#define RADAR_CHIRP_DETECT__CHIRP_MAX_DELTA_BIN__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 8) & 0x00001f00U)
#define RADAR_CHIRP_DETECT__CHIRP_MAX_DELTA_BIN__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00001f00U) | (((u_int32_t)(src) <<\
                    8) & 0x00001f00U)
#define RADAR_CHIRP_DETECT__CHIRP_MAX_DELTA_BIN__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 8) & ~0x00001f00U)))

/* macros for field chirp_max_delta_diff */
#define RADAR_CHIRP_DETECT__CHIRP_MAX_DELTA_DIFF__SHIFT                      13
#define RADAR_CHIRP_DETECT__CHIRP_MAX_DELTA_DIFF__WIDTH                       4
#define RADAR_CHIRP_DETECT__CHIRP_MAX_DELTA_DIFF__MASK              0x0001e000U
#define RADAR_CHIRP_DETECT__CHIRP_MAX_DELTA_DIFF__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0001e000U) >> 13)
#define RADAR_CHIRP_DETECT__CHIRP_MAX_DELTA_DIFF__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 13) & 0x0001e000U)
#define RADAR_CHIRP_DETECT__CHIRP_MAX_DELTA_DIFF__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0001e000U) | (((u_int32_t)(src) <<\
                    13) & 0x0001e000U)
#define RADAR_CHIRP_DETECT__CHIRP_MAX_DELTA_DIFF__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 13) & ~0x0001e000U)))

/* macros for field srch_fft_str_rssi_thresh */
#define RADAR_CHIRP_DETECT__SRCH_FFT_STR_RSSI_THRESH__SHIFT                  17
#define RADAR_CHIRP_DETECT__SRCH_FFT_STR_RSSI_THRESH__WIDTH                   6
#define RADAR_CHIRP_DETECT__SRCH_FFT_STR_RSSI_THRESH__MASK          0x007e0000U
#define RADAR_CHIRP_DETECT__SRCH_FFT_STR_RSSI_THRESH__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x007e0000U) >> 17)
#define RADAR_CHIRP_DETECT__SRCH_FFT_STR_RSSI_THRESH__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 17) & 0x007e0000U)
#define RADAR_CHIRP_DETECT__SRCH_FFT_STR_RSSI_THRESH__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x007e0000U) | (((u_int32_t)(src) <<\
                    17) & 0x007e0000U)
#define RADAR_CHIRP_DETECT__SRCH_FFT_STR_RSSI_THRESH__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 17) & ~0x007e0000U)))

/* macros for field chirp_max_num_fft_rpt */
#define RADAR_CHIRP_DETECT__CHIRP_MAX_NUM_FFT_RPT__SHIFT                     23
#define RADAR_CHIRP_DETECT__CHIRP_MAX_NUM_FFT_RPT__WIDTH                      5
#define RADAR_CHIRP_DETECT__CHIRP_MAX_NUM_FFT_RPT__MASK             0x0f800000U
#define RADAR_CHIRP_DETECT__CHIRP_MAX_NUM_FFT_RPT__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0f800000U) >> 23)
#define RADAR_CHIRP_DETECT__CHIRP_MAX_NUM_FFT_RPT__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 23) & 0x0f800000U)
#define RADAR_CHIRP_DETECT__CHIRP_MAX_NUM_FFT_RPT__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0f800000U) | (((u_int32_t)(src) <<\
                    23) & 0x0f800000U)
#define RADAR_CHIRP_DETECT__CHIRP_MAX_NUM_FFT_RPT__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 23) & ~0x0f800000U)))

/* macros for field nonlin_vel_check_ena */
#define RADAR_CHIRP_DETECT__NONLIN_VEL_CHECK_ENA__SHIFT                      28
#define RADAR_CHIRP_DETECT__NONLIN_VEL_CHECK_ENA__WIDTH                       1
#define RADAR_CHIRP_DETECT__NONLIN_VEL_CHECK_ENA__MASK              0x10000000U
#define RADAR_CHIRP_DETECT__NONLIN_VEL_CHECK_ENA__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x10000000U) >> 28)
#define RADAR_CHIRP_DETECT__NONLIN_VEL_CHECK_ENA__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 28) & 0x10000000U)
#define RADAR_CHIRP_DETECT__NONLIN_VEL_CHECK_ENA__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x10000000U) | (((u_int32_t)(src) <<\
                    28) & 0x10000000U)
#define RADAR_CHIRP_DETECT__NONLIN_VEL_CHECK_ENA__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 28) & ~0x10000000U)))
#define RADAR_CHIRP_DETECT__NONLIN_VEL_CHECK_ENA__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x10000000U) | ((u_int32_t)(1) << 28)
#define RADAR_CHIRP_DETECT__NONLIN_VEL_CHECK_ENA__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x10000000U) | ((u_int32_t)(0) << 28)

/* macros for field chirp_fft_bw_check_ena */
#define RADAR_CHIRP_DETECT__CHIRP_FFT_BW_CHECK_ENA__SHIFT                    29
#define RADAR_CHIRP_DETECT__CHIRP_FFT_BW_CHECK_ENA__WIDTH                     1
#define RADAR_CHIRP_DETECT__CHIRP_FFT_BW_CHECK_ENA__MASK            0x20000000U
#define RADAR_CHIRP_DETECT__CHIRP_FFT_BW_CHECK_ENA__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x20000000U) >> 29)
#define RADAR_CHIRP_DETECT__CHIRP_FFT_BW_CHECK_ENA__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 29) & 0x20000000U)
#define RADAR_CHIRP_DETECT__CHIRP_FFT_BW_CHECK_ENA__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x20000000U) | (((u_int32_t)(src) <<\
                    29) & 0x20000000U)
#define RADAR_CHIRP_DETECT__CHIRP_FFT_BW_CHECK_ENA__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 29) & ~0x20000000U)))
#define RADAR_CHIRP_DETECT__CHIRP_FFT_BW_CHECK_ENA__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x20000000U) | ((u_int32_t)(1) << 29)
#define RADAR_CHIRP_DETECT__CHIRP_FFT_BW_CHECK_ENA__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x20000000U) | ((u_int32_t)(0) << 29)
#define RADAR_CHIRP_DETECT__TYPE                                      u_int32_t
#define RADAR_CHIRP_DETECT__READ                                    0x3fffffffU
#define RADAR_CHIRP_DETECT__WRITE                                   0x3fffffffU

#endif /* __RADAR_CHIRP_DETECT_MACRO__ */


/* macros for bb_reg_map.bb_agc_reg_map.BB_radar_chirp_detect */
#define INST_BB_REG_MAP__BB_AGC_REG_MAP__BB_RADAR_CHIRP_DETECT__NUM           1

/* macros for BlueprintGlobalNameSpace::spectral_scan_2 */
#ifndef __SPECTRAL_SCAN_2_MACRO__
#define __SPECTRAL_SCAN_2_MACRO__

/* macros for field spectral_scan_noise_floor_ref */
#define SPECTRAL_SCAN_2__SPECTRAL_SCAN_NOISE_FLOOR_REF__SHIFT                 0
#define SPECTRAL_SCAN_2__SPECTRAL_SCAN_NOISE_FLOOR_REF__WIDTH                 8
#define SPECTRAL_SCAN_2__SPECTRAL_SCAN_NOISE_FLOOR_REF__MASK        0x000000ffU
#define SPECTRAL_SCAN_2__SPECTRAL_SCAN_NOISE_FLOOR_REF__READ(src) \
                    (u_int32_t)(src)\
                    & 0x000000ffU
#define SPECTRAL_SCAN_2__SPECTRAL_SCAN_NOISE_FLOOR_REF__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x000000ffU)
#define SPECTRAL_SCAN_2__SPECTRAL_SCAN_NOISE_FLOOR_REF__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000000ffU) | ((u_int32_t)(src) &\
                    0x000000ffU)
#define SPECTRAL_SCAN_2__SPECTRAL_SCAN_NOISE_FLOOR_REF__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x000000ffU)))

/* macros for field spectral_scan_init_delay */
#define SPECTRAL_SCAN_2__SPECTRAL_SCAN_INIT_DELAY__SHIFT                      8
#define SPECTRAL_SCAN_2__SPECTRAL_SCAN_INIT_DELAY__WIDTH                      7
#define SPECTRAL_SCAN_2__SPECTRAL_SCAN_INIT_DELAY__MASK             0x00007f00U
#define SPECTRAL_SCAN_2__SPECTRAL_SCAN_INIT_DELAY__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00007f00U) >> 8)
#define SPECTRAL_SCAN_2__SPECTRAL_SCAN_INIT_DELAY__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 8) & 0x00007f00U)
#define SPECTRAL_SCAN_2__SPECTRAL_SCAN_INIT_DELAY__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00007f00U) | (((u_int32_t)(src) <<\
                    8) & 0x00007f00U)
#define SPECTRAL_SCAN_2__SPECTRAL_SCAN_INIT_DELAY__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 8) & ~0x00007f00U)))

/* macros for field spectral_scan_nb_tone_thr */
#define SPECTRAL_SCAN_2__SPECTRAL_SCAN_NB_TONE_THR__SHIFT                    16
#define SPECTRAL_SCAN_2__SPECTRAL_SCAN_NB_TONE_THR__WIDTH                     8
#define SPECTRAL_SCAN_2__SPECTRAL_SCAN_NB_TONE_THR__MASK            0x00ff0000U
#define SPECTRAL_SCAN_2__SPECTRAL_SCAN_NB_TONE_THR__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00ff0000U) >> 16)
#define SPECTRAL_SCAN_2__SPECTRAL_SCAN_NB_TONE_THR__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 16) & 0x00ff0000U)
#define SPECTRAL_SCAN_2__SPECTRAL_SCAN_NB_TONE_THR__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00ff0000U) | (((u_int32_t)(src) <<\
                    16) & 0x00ff0000U)
#define SPECTRAL_SCAN_2__SPECTRAL_SCAN_NB_TONE_THR__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 16) & ~0x00ff0000U)))

/* macros for field spectral_scan_str_bin_thr */
#define SPECTRAL_SCAN_2__SPECTRAL_SCAN_STR_BIN_THR__SHIFT                    24
#define SPECTRAL_SCAN_2__SPECTRAL_SCAN_STR_BIN_THR__WIDTH                     6
#define SPECTRAL_SCAN_2__SPECTRAL_SCAN_STR_BIN_THR__MASK            0x3f000000U
#define SPECTRAL_SCAN_2__SPECTRAL_SCAN_STR_BIN_THR__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x3f000000U) >> 24)
#define SPECTRAL_SCAN_2__SPECTRAL_SCAN_STR_BIN_THR__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 24) & 0x3f000000U)
#define SPECTRAL_SCAN_2__SPECTRAL_SCAN_STR_BIN_THR__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x3f000000U) | (((u_int32_t)(src) <<\
                    24) & 0x3f000000U)
#define SPECTRAL_SCAN_2__SPECTRAL_SCAN_STR_BIN_THR__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 24) & ~0x3f000000U)))

/* macros for field spectral_scan_wb_rpt_mode */
#define SPECTRAL_SCAN_2__SPECTRAL_SCAN_WB_RPT_MODE__SHIFT                    30
#define SPECTRAL_SCAN_2__SPECTRAL_SCAN_WB_RPT_MODE__WIDTH                     1
#define SPECTRAL_SCAN_2__SPECTRAL_SCAN_WB_RPT_MODE__MASK            0x40000000U
#define SPECTRAL_SCAN_2__SPECTRAL_SCAN_WB_RPT_MODE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x40000000U) >> 30)
#define SPECTRAL_SCAN_2__SPECTRAL_SCAN_WB_RPT_MODE__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 30) & 0x40000000U)
#define SPECTRAL_SCAN_2__SPECTRAL_SCAN_WB_RPT_MODE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x40000000U) | (((u_int32_t)(src) <<\
                    30) & 0x40000000U)
#define SPECTRAL_SCAN_2__SPECTRAL_SCAN_WB_RPT_MODE__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 30) & ~0x40000000U)))
#define SPECTRAL_SCAN_2__SPECTRAL_SCAN_WB_RPT_MODE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x40000000U) | ((u_int32_t)(1) << 30)
#define SPECTRAL_SCAN_2__SPECTRAL_SCAN_WB_RPT_MODE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x40000000U) | ((u_int32_t)(0) << 30)

/* macros for field spectral_scan_rssi_rpt_mode */
#define SPECTRAL_SCAN_2__SPECTRAL_SCAN_RSSI_RPT_MODE__SHIFT                  31
#define SPECTRAL_SCAN_2__SPECTRAL_SCAN_RSSI_RPT_MODE__WIDTH                   1
#define SPECTRAL_SCAN_2__SPECTRAL_SCAN_RSSI_RPT_MODE__MASK          0x80000000U
#define SPECTRAL_SCAN_2__SPECTRAL_SCAN_RSSI_RPT_MODE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x80000000U) >> 31)
#define SPECTRAL_SCAN_2__SPECTRAL_SCAN_RSSI_RPT_MODE__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 31) & 0x80000000U)
#define SPECTRAL_SCAN_2__SPECTRAL_SCAN_RSSI_RPT_MODE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x80000000U) | (((u_int32_t)(src) <<\
                    31) & 0x80000000U)
#define SPECTRAL_SCAN_2__SPECTRAL_SCAN_RSSI_RPT_MODE__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 31) & ~0x80000000U)))
#define SPECTRAL_SCAN_2__SPECTRAL_SCAN_RSSI_RPT_MODE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x80000000U) | ((u_int32_t)(1) << 31)
#define SPECTRAL_SCAN_2__SPECTRAL_SCAN_RSSI_RPT_MODE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x80000000U) | ((u_int32_t)(0) << 31)
#define SPECTRAL_SCAN_2__TYPE                                         u_int32_t
#define SPECTRAL_SCAN_2__READ                                       0xffff7fffU
#define SPECTRAL_SCAN_2__WRITE                                      0xffff7fffU

#endif /* __SPECTRAL_SCAN_2_MACRO__ */


/* macros for bb_reg_map.bb_agc_reg_map.BB_spectral_scan_2 */
#define INST_BB_REG_MAP__BB_AGC_REG_MAP__BB_SPECTRAL_SCAN_2__NUM              1

/* macros for BlueprintGlobalNameSpace::spectral_scan_3 */
#ifndef __SPECTRAL_SCAN_3_MACRO__
#define __SPECTRAL_SCAN_3_MACRO__

/* macros for field spectral_scan_rssi_thr */
#define SPECTRAL_SCAN_3__SPECTRAL_SCAN_RSSI_THR__SHIFT                        0
#define SPECTRAL_SCAN_3__SPECTRAL_SCAN_RSSI_THR__WIDTH                        8
#define SPECTRAL_SCAN_3__SPECTRAL_SCAN_RSSI_THR__MASK               0x000000ffU
#define SPECTRAL_SCAN_3__SPECTRAL_SCAN_RSSI_THR__READ(src) \
                    (u_int32_t)(src)\
                    & 0x000000ffU
#define SPECTRAL_SCAN_3__SPECTRAL_SCAN_RSSI_THR__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x000000ffU)
#define SPECTRAL_SCAN_3__SPECTRAL_SCAN_RSSI_THR__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000000ffU) | ((u_int32_t)(src) &\
                    0x000000ffU)
#define SPECTRAL_SCAN_3__SPECTRAL_SCAN_RSSI_THR__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x000000ffU)))
#define SPECTRAL_SCAN_3__TYPE                                         u_int32_t
#define SPECTRAL_SCAN_3__READ                                       0x000000ffU
#define SPECTRAL_SCAN_3__WRITE                                      0x000000ffU

#endif /* __SPECTRAL_SCAN_3_MACRO__ */


/* macros for bb_reg_map.bb_agc_reg_map.BB_spectral_scan_3 */
#define INST_BB_REG_MAP__BB_AGC_REG_MAP__BB_SPECTRAL_SCAN_3__NUM              1

/* macros for BlueprintGlobalNameSpace::agc_timeout_1 */
#ifndef __AGC_TIMEOUT_1_MACRO__
#define __AGC_TIMEOUT_1_MACRO__

/* macros for field radar_sm_timeout */
#define AGC_TIMEOUT_1__RADAR_SM_TIMEOUT__SHIFT                                0
#define AGC_TIMEOUT_1__RADAR_SM_TIMEOUT__WIDTH                                8
#define AGC_TIMEOUT_1__RADAR_SM_TIMEOUT__MASK                       0x000000ffU
#define AGC_TIMEOUT_1__RADAR_SM_TIMEOUT__READ(src) \
                    (u_int32_t)(src)\
                    & 0x000000ffU
#define AGC_TIMEOUT_1__RADAR_SM_TIMEOUT__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x000000ffU)
#define AGC_TIMEOUT_1__RADAR_SM_TIMEOUT__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000000ffU) | ((u_int32_t)(src) &\
                    0x000000ffU)
#define AGC_TIMEOUT_1__RADAR_SM_TIMEOUT__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x000000ffU)))

/* macros for field sscan_sm_timeout */
#define AGC_TIMEOUT_1__SSCAN_SM_TIMEOUT__SHIFT                                8
#define AGC_TIMEOUT_1__SSCAN_SM_TIMEOUT__WIDTH                                8
#define AGC_TIMEOUT_1__SSCAN_SM_TIMEOUT__MASK                       0x0000ff00U
#define AGC_TIMEOUT_1__SSCAN_SM_TIMEOUT__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0000ff00U) >> 8)
#define AGC_TIMEOUT_1__SSCAN_SM_TIMEOUT__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 8) & 0x0000ff00U)
#define AGC_TIMEOUT_1__SSCAN_SM_TIMEOUT__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000ff00U) | (((u_int32_t)(src) <<\
                    8) & 0x0000ff00U)
#define AGC_TIMEOUT_1__SSCAN_SM_TIMEOUT__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 8) & ~0x0000ff00U)))

/* macros for field agc_ht_stf_sm_timeout */
#define AGC_TIMEOUT_1__AGC_HT_STF_SM_TIMEOUT__SHIFT                          16
#define AGC_TIMEOUT_1__AGC_HT_STF_SM_TIMEOUT__WIDTH                           8
#define AGC_TIMEOUT_1__AGC_HT_STF_SM_TIMEOUT__MASK                  0x00ff0000U
#define AGC_TIMEOUT_1__AGC_HT_STF_SM_TIMEOUT__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00ff0000U) >> 16)
#define AGC_TIMEOUT_1__AGC_HT_STF_SM_TIMEOUT__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 16) & 0x00ff0000U)
#define AGC_TIMEOUT_1__AGC_HT_STF_SM_TIMEOUT__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00ff0000U) | (((u_int32_t)(src) <<\
                    16) & 0x00ff0000U)
#define AGC_TIMEOUT_1__AGC_HT_STF_SM_TIMEOUT__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 16) & ~0x00ff0000U)))
#define AGC_TIMEOUT_1__TYPE                                           u_int32_t
#define AGC_TIMEOUT_1__READ                                         0x00ffffffU
#define AGC_TIMEOUT_1__WRITE                                        0x00ffffffU

#endif /* __AGC_TIMEOUT_1_MACRO__ */


/* macros for bb_reg_map.bb_agc_reg_map.BB_agc_timeout_1 */
#define INST_BB_REG_MAP__BB_AGC_REG_MAP__BB_AGC_TIMEOUT_1__NUM                1

/* macros for BlueprintGlobalNameSpace::adcsat_ctrl_1 */
#ifndef __ADCSAT_CTRL_1_MACRO__
#define __ADCSAT_CTRL_1_MACRO__

/* macros for field adcsat_clip_coarse_thr */
#define ADCSAT_CTRL_1__ADCSAT_CLIP_COARSE_THR__SHIFT                          0
#define ADCSAT_CTRL_1__ADCSAT_CLIP_COARSE_THR__WIDTH                          8
#define ADCSAT_CTRL_1__ADCSAT_CLIP_COARSE_THR__MASK                 0x000000ffU
#define ADCSAT_CTRL_1__ADCSAT_CLIP_COARSE_THR__READ(src) \
                    (u_int32_t)(src)\
                    & 0x000000ffU
#define ADCSAT_CTRL_1__ADCSAT_CLIP_COARSE_THR__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x000000ffU)
#define ADCSAT_CTRL_1__ADCSAT_CLIP_COARSE_THR__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000000ffU) | ((u_int32_t)(src) &\
                    0x000000ffU)
#define ADCSAT_CTRL_1__ADCSAT_CLIP_COARSE_THR__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x000000ffU)))

/* macros for field adcsat_clip_found_thr */
#define ADCSAT_CTRL_1__ADCSAT_CLIP_FOUND_THR__SHIFT                           8
#define ADCSAT_CTRL_1__ADCSAT_CLIP_FOUND_THR__WIDTH                           8
#define ADCSAT_CTRL_1__ADCSAT_CLIP_FOUND_THR__MASK                  0x0000ff00U
#define ADCSAT_CTRL_1__ADCSAT_CLIP_FOUND_THR__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0000ff00U) >> 8)
#define ADCSAT_CTRL_1__ADCSAT_CLIP_FOUND_THR__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 8) & 0x0000ff00U)
#define ADCSAT_CTRL_1__ADCSAT_CLIP_FOUND_THR__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000ff00U) | (((u_int32_t)(src) <<\
                    8) & 0x0000ff00U)
#define ADCSAT_CTRL_1__ADCSAT_CLIP_FOUND_THR__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 8) & ~0x0000ff00U)))

/* macros for field adcsat_win_len */
#define ADCSAT_CTRL_1__ADCSAT_WIN_LEN__SHIFT                                 16
#define ADCSAT_CTRL_1__ADCSAT_WIN_LEN__WIDTH                                  5
#define ADCSAT_CTRL_1__ADCSAT_WIN_LEN__MASK                         0x001f0000U
#define ADCSAT_CTRL_1__ADCSAT_WIN_LEN__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x001f0000U) >> 16)
#define ADCSAT_CTRL_1__ADCSAT_WIN_LEN__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 16) & 0x001f0000U)
#define ADCSAT_CTRL_1__ADCSAT_WIN_LEN__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x001f0000U) | (((u_int32_t)(src) <<\
                    16) & 0x001f0000U)
#define ADCSAT_CTRL_1__ADCSAT_WIN_LEN__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 16) & ~0x001f0000U)))

/* macros for field adcsat_cnt_thr */
#define ADCSAT_CTRL_1__ADCSAT_CNT_THR__SHIFT                                 21
#define ADCSAT_CTRL_1__ADCSAT_CNT_THR__WIDTH                                  5
#define ADCSAT_CTRL_1__ADCSAT_CNT_THR__MASK                         0x03e00000U
#define ADCSAT_CTRL_1__ADCSAT_CNT_THR__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x03e00000U) >> 21)
#define ADCSAT_CTRL_1__ADCSAT_CNT_THR__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 21) & 0x03e00000U)
#define ADCSAT_CTRL_1__ADCSAT_CNT_THR__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x03e00000U) | (((u_int32_t)(src) <<\
                    21) & 0x03e00000U)
#define ADCSAT_CTRL_1__ADCSAT_CNT_THR__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 21) & ~0x03e00000U)))
#define ADCSAT_CTRL_1__TYPE                                           u_int32_t
#define ADCSAT_CTRL_1__READ                                         0x03ffffffU
#define ADCSAT_CTRL_1__WRITE                                        0x03ffffffU

#endif /* __ADCSAT_CTRL_1_MACRO__ */


/* macros for bb_reg_map.bb_agc_reg_map.BB_adcsat_ctrl_1 */
#define INST_BB_REG_MAP__BB_AGC_REG_MAP__BB_ADCSAT_CTRL_1__NUM                1

/* macros for BlueprintGlobalNameSpace::adcsat_ctrl_2 */
#ifndef __ADCSAT_CTRL_2_MACRO__
#define __ADCSAT_CTRL_2_MACRO__

/* macros for field quickdrop_coarse */
#define ADCSAT_CTRL_2__QUICKDROP_COARSE__SHIFT                                0
#define ADCSAT_CTRL_2__QUICKDROP_COARSE__WIDTH                                8
#define ADCSAT_CTRL_2__QUICKDROP_COARSE__MASK                       0x000000ffU
#define ADCSAT_CTRL_2__QUICKDROP_COARSE__READ(src) \
                    (u_int32_t)(src)\
                    & 0x000000ffU
#define ADCSAT_CTRL_2__QUICKDROP_COARSE__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x000000ffU)
#define ADCSAT_CTRL_2__QUICKDROP_COARSE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000000ffU) | ((u_int32_t)(src) &\
                    0x000000ffU)
#define ADCSAT_CTRL_2__QUICKDROP_COARSE__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x000000ffU)))

/* macros for field quickdrop_found */
#define ADCSAT_CTRL_2__QUICKDROP_FOUND__SHIFT                                 8
#define ADCSAT_CTRL_2__QUICKDROP_FOUND__WIDTH                                 8
#define ADCSAT_CTRL_2__QUICKDROP_FOUND__MASK                        0x0000ff00U
#define ADCSAT_CTRL_2__QUICKDROP_FOUND__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0000ff00U) >> 8)
#define ADCSAT_CTRL_2__QUICKDROP_FOUND__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 8) & 0x0000ff00U)
#define ADCSAT_CTRL_2__QUICKDROP_FOUND__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000ff00U) | (((u_int32_t)(src) <<\
                    8) & 0x0000ff00U)
#define ADCSAT_CTRL_2__QUICKDROP_FOUND__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 8) & ~0x0000ff00U)))

/* macros for field quickdrop_other */
#define ADCSAT_CTRL_2__QUICKDROP_OTHER__SHIFT                                16
#define ADCSAT_CTRL_2__QUICKDROP_OTHER__WIDTH                                 8
#define ADCSAT_CTRL_2__QUICKDROP_OTHER__MASK                        0x00ff0000U
#define ADCSAT_CTRL_2__QUICKDROP_OTHER__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00ff0000U) >> 16)
#define ADCSAT_CTRL_2__QUICKDROP_OTHER__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 16) & 0x00ff0000U)
#define ADCSAT_CTRL_2__QUICKDROP_OTHER__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00ff0000U) | (((u_int32_t)(src) <<\
                    16) & 0x00ff0000U)
#define ADCSAT_CTRL_2__QUICKDROP_OTHER__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 16) & ~0x00ff0000U)))

/* macros for field rf_reduce_only_gcmode1_recent_rfsat */
#define ADCSAT_CTRL_2__RF_REDUCE_ONLY_GCMODE1_RECENT_RFSAT__SHIFT            24
#define ADCSAT_CTRL_2__RF_REDUCE_ONLY_GCMODE1_RECENT_RFSAT__WIDTH             1
#define ADCSAT_CTRL_2__RF_REDUCE_ONLY_GCMODE1_RECENT_RFSAT__MASK    0x01000000U
#define ADCSAT_CTRL_2__RF_REDUCE_ONLY_GCMODE1_RECENT_RFSAT__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x01000000U) >> 24)
#define ADCSAT_CTRL_2__RF_REDUCE_ONLY_GCMODE1_RECENT_RFSAT__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 24) & 0x01000000U)
#define ADCSAT_CTRL_2__RF_REDUCE_ONLY_GCMODE1_RECENT_RFSAT__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x01000000U) | (((u_int32_t)(src) <<\
                    24) & 0x01000000U)
#define ADCSAT_CTRL_2__RF_REDUCE_ONLY_GCMODE1_RECENT_RFSAT__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 24) & ~0x01000000U)))
#define ADCSAT_CTRL_2__RF_REDUCE_ONLY_GCMODE1_RECENT_RFSAT__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x01000000U) | ((u_int32_t)(1) << 24)
#define ADCSAT_CTRL_2__RF_REDUCE_ONLY_GCMODE1_RECENT_RFSAT__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x01000000U) | ((u_int32_t)(0) << 24)

/* macros for field use_rf_gain_for_xatten_control */
#define ADCSAT_CTRL_2__USE_RF_GAIN_FOR_XATTEN_CONTROL__SHIFT                 31
#define ADCSAT_CTRL_2__USE_RF_GAIN_FOR_XATTEN_CONTROL__WIDTH                  1
#define ADCSAT_CTRL_2__USE_RF_GAIN_FOR_XATTEN_CONTROL__MASK         0x80000000U
#define ADCSAT_CTRL_2__USE_RF_GAIN_FOR_XATTEN_CONTROL__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x80000000U) >> 31)
#define ADCSAT_CTRL_2__USE_RF_GAIN_FOR_XATTEN_CONTROL__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 31) & 0x80000000U)
#define ADCSAT_CTRL_2__USE_RF_GAIN_FOR_XATTEN_CONTROL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x80000000U) | (((u_int32_t)(src) <<\
                    31) & 0x80000000U)
#define ADCSAT_CTRL_2__USE_RF_GAIN_FOR_XATTEN_CONTROL__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 31) & ~0x80000000U)))
#define ADCSAT_CTRL_2__USE_RF_GAIN_FOR_XATTEN_CONTROL__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x80000000U) | ((u_int32_t)(1) << 31)
#define ADCSAT_CTRL_2__USE_RF_GAIN_FOR_XATTEN_CONTROL__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x80000000U) | ((u_int32_t)(0) << 31)
#define ADCSAT_CTRL_2__TYPE                                           u_int32_t
#define ADCSAT_CTRL_2__READ                                         0x81ffffffU
#define ADCSAT_CTRL_2__WRITE                                        0x81ffffffU

#endif /* __ADCSAT_CTRL_2_MACRO__ */


/* macros for bb_reg_map.bb_agc_reg_map.BB_adcsat_ctrl_2 */
#define INST_BB_REG_MAP__BB_AGC_REG_MAP__BB_ADCSAT_CTRL_2__NUM                1

/* macros for BlueprintGlobalNameSpace::agc_spare_01 */
#ifndef __AGC_SPARE_01_MACRO__
#define __AGC_SPARE_01_MACRO__

/* macros for field agc_eco_ctrl */
#define AGC_SPARE_01__AGC_ECO_CTRL__SHIFT                                     0
#define AGC_SPARE_01__AGC_ECO_CTRL__WIDTH                                    32
#define AGC_SPARE_01__AGC_ECO_CTRL__MASK                            0xffffffffU
#define AGC_SPARE_01__AGC_ECO_CTRL__READ(src)    (u_int32_t)(src) & 0xffffffffU
#define AGC_SPARE_01__AGC_ECO_CTRL__WRITE(src) ((u_int32_t)(src) & 0xffffffffU)
#define AGC_SPARE_01__AGC_ECO_CTRL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xffffffffU) | ((u_int32_t)(src) &\
                    0xffffffffU)
#define AGC_SPARE_01__AGC_ECO_CTRL__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0xffffffffU)))
#define AGC_SPARE_01__TYPE                                            u_int32_t
#define AGC_SPARE_01__READ                                          0xffffffffU
#define AGC_SPARE_01__WRITE                                         0xffffffffU

#endif /* __AGC_SPARE_01_MACRO__ */


/* macros for bb_reg_map.bb_agc_reg_map.BB_agc_spare_01 */
#define INST_BB_REG_MAP__BB_AGC_REG_MAP__BB_AGC_SPARE_01__NUM                 1

/* macros for BlueprintGlobalNameSpace::agc_ht_stf_ctrl_1 */
#ifndef __AGC_HT_STF_CTRL_1_MACRO__
#define __AGC_HT_STF_CTRL_1_MACRO__

/* macros for field agc_ht_stf_ena */
#define AGC_HT_STF_CTRL_1__AGC_HT_STF_ENA__SHIFT                              0
#define AGC_HT_STF_CTRL_1__AGC_HT_STF_ENA__WIDTH                              1
#define AGC_HT_STF_CTRL_1__AGC_HT_STF_ENA__MASK                     0x00000001U
#define AGC_HT_STF_CTRL_1__AGC_HT_STF_ENA__READ(src) \
                    (u_int32_t)(src)\
                    & 0x00000001U
#define AGC_HT_STF_CTRL_1__AGC_HT_STF_ENA__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x00000001U)
#define AGC_HT_STF_CTRL_1__AGC_HT_STF_ENA__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | ((u_int32_t)(src) &\
                    0x00000001U)
#define AGC_HT_STF_CTRL_1__AGC_HT_STF_ENA__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00000001U)))
#define AGC_HT_STF_CTRL_1__AGC_HT_STF_ENA__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(1)
#define AGC_HT_STF_CTRL_1__AGC_HT_STF_ENA__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(0)

/* macros for field agc_ht_stf_allow_gain_incr */
#define AGC_HT_STF_CTRL_1__AGC_HT_STF_ALLOW_GAIN_INCR__SHIFT                  1
#define AGC_HT_STF_CTRL_1__AGC_HT_STF_ALLOW_GAIN_INCR__WIDTH                  1
#define AGC_HT_STF_CTRL_1__AGC_HT_STF_ALLOW_GAIN_INCR__MASK         0x00000002U
#define AGC_HT_STF_CTRL_1__AGC_HT_STF_ALLOW_GAIN_INCR__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000002U) >> 1)
#define AGC_HT_STF_CTRL_1__AGC_HT_STF_ALLOW_GAIN_INCR__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 1) & 0x00000002U)
#define AGC_HT_STF_CTRL_1__AGC_HT_STF_ALLOW_GAIN_INCR__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | (((u_int32_t)(src) <<\
                    1) & 0x00000002U)
#define AGC_HT_STF_CTRL_1__AGC_HT_STF_ALLOW_GAIN_INCR__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 1) & ~0x00000002U)))
#define AGC_HT_STF_CTRL_1__AGC_HT_STF_ALLOW_GAIN_INCR__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | ((u_int32_t)(1) << 1)
#define AGC_HT_STF_CTRL_1__AGC_HT_STF_ALLOW_GAIN_INCR__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | ((u_int32_t)(0) << 1)

/* macros for field agc_ht_stf_pwr_delay */
#define AGC_HT_STF_CTRL_1__AGC_HT_STF_PWR_DELAY__SHIFT                        2
#define AGC_HT_STF_CTRL_1__AGC_HT_STF_PWR_DELAY__WIDTH                        6
#define AGC_HT_STF_CTRL_1__AGC_HT_STF_PWR_DELAY__MASK               0x000000fcU
#define AGC_HT_STF_CTRL_1__AGC_HT_STF_PWR_DELAY__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x000000fcU) >> 2)
#define AGC_HT_STF_CTRL_1__AGC_HT_STF_PWR_DELAY__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 2) & 0x000000fcU)
#define AGC_HT_STF_CTRL_1__AGC_HT_STF_PWR_DELAY__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000000fcU) | (((u_int32_t)(src) <<\
                    2) & 0x000000fcU)
#define AGC_HT_STF_CTRL_1__AGC_HT_STF_PWR_DELAY__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 2) & ~0x000000fcU)))

/* macros for field agc_ht_stf_weak_size_desired */
#define AGC_HT_STF_CTRL_1__AGC_HT_STF_WEAK_SIZE_DESIRED__SHIFT                8
#define AGC_HT_STF_CTRL_1__AGC_HT_STF_WEAK_SIZE_DESIRED__WIDTH                8
#define AGC_HT_STF_CTRL_1__AGC_HT_STF_WEAK_SIZE_DESIRED__MASK       0x0000ff00U
#define AGC_HT_STF_CTRL_1__AGC_HT_STF_WEAK_SIZE_DESIRED__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0000ff00U) >> 8)
#define AGC_HT_STF_CTRL_1__AGC_HT_STF_WEAK_SIZE_DESIRED__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 8) & 0x0000ff00U)
#define AGC_HT_STF_CTRL_1__AGC_HT_STF_WEAK_SIZE_DESIRED__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000ff00U) | (((u_int32_t)(src) <<\
                    8) & 0x0000ff00U)
#define AGC_HT_STF_CTRL_1__AGC_HT_STF_WEAK_SIZE_DESIRED__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 8) & ~0x0000ff00U)))

/* macros for field agc_ht_stf_min_lstf_pwr */
#define AGC_HT_STF_CTRL_1__AGC_HT_STF_MIN_LSTF_PWR__SHIFT                    16
#define AGC_HT_STF_CTRL_1__AGC_HT_STF_MIN_LSTF_PWR__WIDTH                     8
#define AGC_HT_STF_CTRL_1__AGC_HT_STF_MIN_LSTF_PWR__MASK            0x00ff0000U
#define AGC_HT_STF_CTRL_1__AGC_HT_STF_MIN_LSTF_PWR__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00ff0000U) >> 16)
#define AGC_HT_STF_CTRL_1__AGC_HT_STF_MIN_LSTF_PWR__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 16) & 0x00ff0000U)
#define AGC_HT_STF_CTRL_1__AGC_HT_STF_MIN_LSTF_PWR__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00ff0000U) | (((u_int32_t)(src) <<\
                    16) & 0x00ff0000U)
#define AGC_HT_STF_CTRL_1__AGC_HT_STF_MIN_LSTF_PWR__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 16) & ~0x00ff0000U)))

/* macros for field agc_ht_stf_min_adc_pwr */
#define AGC_HT_STF_CTRL_1__AGC_HT_STF_MIN_ADC_PWR__SHIFT                     24
#define AGC_HT_STF_CTRL_1__AGC_HT_STF_MIN_ADC_PWR__WIDTH                      8
#define AGC_HT_STF_CTRL_1__AGC_HT_STF_MIN_ADC_PWR__MASK             0xff000000U
#define AGC_HT_STF_CTRL_1__AGC_HT_STF_MIN_ADC_PWR__READ(src) \
                    (((u_int32_t)(src)\
                    & 0xff000000U) >> 24)
#define AGC_HT_STF_CTRL_1__AGC_HT_STF_MIN_ADC_PWR__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 24) & 0xff000000U)
#define AGC_HT_STF_CTRL_1__AGC_HT_STF_MIN_ADC_PWR__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xff000000U) | (((u_int32_t)(src) <<\
                    24) & 0xff000000U)
#define AGC_HT_STF_CTRL_1__AGC_HT_STF_MIN_ADC_PWR__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 24) & ~0xff000000U)))
#define AGC_HT_STF_CTRL_1__TYPE                                       u_int32_t
#define AGC_HT_STF_CTRL_1__READ                                     0xffffffffU
#define AGC_HT_STF_CTRL_1__WRITE                                    0xffffffffU

#endif /* __AGC_HT_STF_CTRL_1_MACRO__ */


/* macros for bb_reg_map.bb_agc_reg_map.BB_agc_ht_stf_ctrl_1 */
#define INST_BB_REG_MAP__BB_AGC_REG_MAP__BB_AGC_HT_STF_CTRL_1__NUM            1

/* macros for BlueprintGlobalNameSpace::agc_ht_stf_ctrl_2 */
#ifndef __AGC_HT_STF_CTRL_2_MACRO__
#define __AGC_HT_STF_CTRL_2_MACRO__

/* macros for field agc_ht_stf_pwr_high_gc_thr */
#define AGC_HT_STF_CTRL_2__AGC_HT_STF_PWR_HIGH_GC_THR__SHIFT                  0
#define AGC_HT_STF_CTRL_2__AGC_HT_STF_PWR_HIGH_GC_THR__WIDTH                  8
#define AGC_HT_STF_CTRL_2__AGC_HT_STF_PWR_HIGH_GC_THR__MASK         0x000000ffU
#define AGC_HT_STF_CTRL_2__AGC_HT_STF_PWR_HIGH_GC_THR__READ(src) \
                    (u_int32_t)(src)\
                    & 0x000000ffU
#define AGC_HT_STF_CTRL_2__AGC_HT_STF_PWR_HIGH_GC_THR__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x000000ffU)
#define AGC_HT_STF_CTRL_2__AGC_HT_STF_PWR_HIGH_GC_THR__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000000ffU) | ((u_int32_t)(src) &\
                    0x000000ffU)
#define AGC_HT_STF_CTRL_2__AGC_HT_STF_PWR_HIGH_GC_THR__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x000000ffU)))

/* macros for field agc_ht_stf_pwr_low_gc_thr */
#define AGC_HT_STF_CTRL_2__AGC_HT_STF_PWR_LOW_GC_THR__SHIFT                   8
#define AGC_HT_STF_CTRL_2__AGC_HT_STF_PWR_LOW_GC_THR__WIDTH                   8
#define AGC_HT_STF_CTRL_2__AGC_HT_STF_PWR_LOW_GC_THR__MASK          0x0000ff00U
#define AGC_HT_STF_CTRL_2__AGC_HT_STF_PWR_LOW_GC_THR__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0000ff00U) >> 8)
#define AGC_HT_STF_CTRL_2__AGC_HT_STF_PWR_LOW_GC_THR__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 8) & 0x0000ff00U)
#define AGC_HT_STF_CTRL_2__AGC_HT_STF_PWR_LOW_GC_THR__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000ff00U) | (((u_int32_t)(src) <<\
                    8) & 0x0000ff00U)
#define AGC_HT_STF_CTRL_2__AGC_HT_STF_PWR_LOW_GC_THR__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 8) & ~0x0000ff00U)))

/* macros for field vht_sym_det_num_bins */
#define AGC_HT_STF_CTRL_2__VHT_SYM_DET_NUM_BINS__SHIFT                       16
#define AGC_HT_STF_CTRL_2__VHT_SYM_DET_NUM_BINS__WIDTH                        4
#define AGC_HT_STF_CTRL_2__VHT_SYM_DET_NUM_BINS__MASK               0x000f0000U
#define AGC_HT_STF_CTRL_2__VHT_SYM_DET_NUM_BINS__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x000f0000U) >> 16)
#define AGC_HT_STF_CTRL_2__VHT_SYM_DET_NUM_BINS__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 16) & 0x000f0000U)
#define AGC_HT_STF_CTRL_2__VHT_SYM_DET_NUM_BINS__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000f0000U) | (((u_int32_t)(src) <<\
                    16) & 0x000f0000U)
#define AGC_HT_STF_CTRL_2__VHT_SYM_DET_NUM_BINS__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 16) & ~0x000f0000U)))

/* macros for field agc_ht_stf_dc_est_ena */
#define AGC_HT_STF_CTRL_2__AGC_HT_STF_DC_EST_ENA__SHIFT                      20
#define AGC_HT_STF_CTRL_2__AGC_HT_STF_DC_EST_ENA__WIDTH                       1
#define AGC_HT_STF_CTRL_2__AGC_HT_STF_DC_EST_ENA__MASK              0x00100000U
#define AGC_HT_STF_CTRL_2__AGC_HT_STF_DC_EST_ENA__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00100000U) >> 20)
#define AGC_HT_STF_CTRL_2__AGC_HT_STF_DC_EST_ENA__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 20) & 0x00100000U)
#define AGC_HT_STF_CTRL_2__AGC_HT_STF_DC_EST_ENA__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00100000U) | (((u_int32_t)(src) <<\
                    20) & 0x00100000U)
#define AGC_HT_STF_CTRL_2__AGC_HT_STF_DC_EST_ENA__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 20) & ~0x00100000U)))
#define AGC_HT_STF_CTRL_2__AGC_HT_STF_DC_EST_ENA__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00100000U) | ((u_int32_t)(1) << 20)
#define AGC_HT_STF_CTRL_2__AGC_HT_STF_DC_EST_ENA__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00100000U) | ((u_int32_t)(0) << 20)

/* macros for field agc_ht_stf_dc_est_win_sel */
#define AGC_HT_STF_CTRL_2__AGC_HT_STF_DC_EST_WIN_SEL__SHIFT                  21
#define AGC_HT_STF_CTRL_2__AGC_HT_STF_DC_EST_WIN_SEL__WIDTH                   1
#define AGC_HT_STF_CTRL_2__AGC_HT_STF_DC_EST_WIN_SEL__MASK          0x00200000U
#define AGC_HT_STF_CTRL_2__AGC_HT_STF_DC_EST_WIN_SEL__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00200000U) >> 21)
#define AGC_HT_STF_CTRL_2__AGC_HT_STF_DC_EST_WIN_SEL__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 21) & 0x00200000U)
#define AGC_HT_STF_CTRL_2__AGC_HT_STF_DC_EST_WIN_SEL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00200000U) | (((u_int32_t)(src) <<\
                    21) & 0x00200000U)
#define AGC_HT_STF_CTRL_2__AGC_HT_STF_DC_EST_WIN_SEL__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 21) & ~0x00200000U)))
#define AGC_HT_STF_CTRL_2__AGC_HT_STF_DC_EST_WIN_SEL__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00200000U) | ((u_int32_t)(1) << 21)
#define AGC_HT_STF_CTRL_2__AGC_HT_STF_DC_EST_WIN_SEL__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00200000U) | ((u_int32_t)(0) << 21)

/* macros for field agc_ht_stf_allow_rf */
#define AGC_HT_STF_CTRL_2__AGC_HT_STF_ALLOW_RF__SHIFT                        22
#define AGC_HT_STF_CTRL_2__AGC_HT_STF_ALLOW_RF__WIDTH                         1
#define AGC_HT_STF_CTRL_2__AGC_HT_STF_ALLOW_RF__MASK                0x00400000U
#define AGC_HT_STF_CTRL_2__AGC_HT_STF_ALLOW_RF__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00400000U) >> 22)
#define AGC_HT_STF_CTRL_2__AGC_HT_STF_ALLOW_RF__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 22) & 0x00400000U)
#define AGC_HT_STF_CTRL_2__AGC_HT_STF_ALLOW_RF__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00400000U) | (((u_int32_t)(src) <<\
                    22) & 0x00400000U)
#define AGC_HT_STF_CTRL_2__AGC_HT_STF_ALLOW_RF__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 22) & ~0x00400000U)))
#define AGC_HT_STF_CTRL_2__AGC_HT_STF_ALLOW_RF__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00400000U) | ((u_int32_t)(1) << 22)
#define AGC_HT_STF_CTRL_2__AGC_HT_STF_ALLOW_RF__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00400000U) | ((u_int32_t)(0) << 22)

/* macros for field agc_ht_stf_settling */
#define AGC_HT_STF_CTRL_2__AGC_HT_STF_SETTLING__SHIFT                        23
#define AGC_HT_STF_CTRL_2__AGC_HT_STF_SETTLING__WIDTH                         7
#define AGC_HT_STF_CTRL_2__AGC_HT_STF_SETTLING__MASK                0x3f800000U
#define AGC_HT_STF_CTRL_2__AGC_HT_STF_SETTLING__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x3f800000U) >> 23)
#define AGC_HT_STF_CTRL_2__AGC_HT_STF_SETTLING__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 23) & 0x3f800000U)
#define AGC_HT_STF_CTRL_2__AGC_HT_STF_SETTLING__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x3f800000U) | (((u_int32_t)(src) <<\
                    23) & 0x3f800000U)
#define AGC_HT_STF_CTRL_2__AGC_HT_STF_SETTLING__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 23) & ~0x3f800000U)))
#define AGC_HT_STF_CTRL_2__TYPE                                       u_int32_t
#define AGC_HT_STF_CTRL_2__READ                                     0x3fffffffU
#define AGC_HT_STF_CTRL_2__WRITE                                    0x3fffffffU

#endif /* __AGC_HT_STF_CTRL_2_MACRO__ */


/* macros for bb_reg_map.bb_agc_reg_map.BB_agc_ht_stf_ctrl_2 */
#define INST_BB_REG_MAP__BB_AGC_REG_MAP__BB_AGC_HT_STF_CTRL_2__NUM            1

/* macros for BlueprintGlobalNameSpace::agc_ht_stf_ctrl_3 */
#ifndef __AGC_HT_STF_CTRL_3_MACRO__
#define __AGC_HT_STF_CTRL_3_MACRO__

/* macros for field agc_ht_stf_lsig_len_min */
#define AGC_HT_STF_CTRL_3__AGC_HT_STF_LSIG_LEN_MIN__SHIFT                     0
#define AGC_HT_STF_CTRL_3__AGC_HT_STF_LSIG_LEN_MIN__WIDTH                     8
#define AGC_HT_STF_CTRL_3__AGC_HT_STF_LSIG_LEN_MIN__MASK            0x000000ffU
#define AGC_HT_STF_CTRL_3__AGC_HT_STF_LSIG_LEN_MIN__READ(src) \
                    (u_int32_t)(src)\
                    & 0x000000ffU
#define AGC_HT_STF_CTRL_3__AGC_HT_STF_LSIG_LEN_MIN__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x000000ffU)
#define AGC_HT_STF_CTRL_3__AGC_HT_STF_LSIG_LEN_MIN__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000000ffU) | ((u_int32_t)(src) &\
                    0x000000ffU)
#define AGC_HT_STF_CTRL_3__AGC_HT_STF_LSIG_LEN_MIN__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x000000ffU)))
#define AGC_HT_STF_CTRL_3__TYPE                                       u_int32_t
#define AGC_HT_STF_CTRL_3__READ                                     0x000000ffU
#define AGC_HT_STF_CTRL_3__WRITE                                    0x000000ffU

#endif /* __AGC_HT_STF_CTRL_3_MACRO__ */


/* macros for bb_reg_map.bb_agc_reg_map.BB_agc_ht_stf_ctrl_3 */
#define INST_BB_REG_MAP__BB_AGC_REG_MAP__BB_AGC_HT_STF_CTRL_3__NUM            1

/* macros for BlueprintGlobalNameSpace::radar_lb_control */
#ifndef __RADAR_LB_CONTROL_MACRO__
#define __RADAR_LB_CONTROL_MACRO__

/* macros for field radar_lb_mode */
#define RADAR_LB_CONTROL__RADAR_LB_MODE__SHIFT                                0
#define RADAR_LB_CONTROL__RADAR_LB_MODE__WIDTH                                1
#define RADAR_LB_CONTROL__RADAR_LB_MODE__MASK                       0x00000001U
#define RADAR_LB_CONTROL__RADAR_LB_MODE__READ(src) \
                    (u_int32_t)(src)\
                    & 0x00000001U
#define RADAR_LB_CONTROL__RADAR_LB_MODE__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x00000001U)
#define RADAR_LB_CONTROL__RADAR_LB_MODE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | ((u_int32_t)(src) &\
                    0x00000001U)
#define RADAR_LB_CONTROL__RADAR_LB_MODE__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00000001U)))
#define RADAR_LB_CONTROL__RADAR_LB_MODE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(1)
#define RADAR_LB_CONTROL__RADAR_LB_MODE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(0)

/* macros for field radar_lb_dc_cap_at_dc */
#define RADAR_LB_CONTROL__RADAR_LB_DC_CAP_AT_DC__SHIFT                        1
#define RADAR_LB_CONTROL__RADAR_LB_DC_CAP_AT_DC__WIDTH                        9
#define RADAR_LB_CONTROL__RADAR_LB_DC_CAP_AT_DC__MASK               0x000003feU
#define RADAR_LB_CONTROL__RADAR_LB_DC_CAP_AT_DC__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x000003feU) >> 1)
#define RADAR_LB_CONTROL__RADAR_LB_DC_CAP_AT_DC__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 1) & 0x000003feU)
#define RADAR_LB_CONTROL__RADAR_LB_DC_CAP_AT_DC__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000003feU) | (((u_int32_t)(src) <<\
                    1) & 0x000003feU)
#define RADAR_LB_CONTROL__RADAR_LB_DC_CAP_AT_DC__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 1) & ~0x000003feU)))

/* macros for field radar_lb_conv_factor */
#define RADAR_LB_CONTROL__RADAR_LB_CONV_FACTOR__SHIFT                        10
#define RADAR_LB_CONTROL__RADAR_LB_CONV_FACTOR__WIDTH                         8
#define RADAR_LB_CONTROL__RADAR_LB_CONV_FACTOR__MASK                0x0003fc00U
#define RADAR_LB_CONTROL__RADAR_LB_CONV_FACTOR__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0003fc00U) >> 10)
#define RADAR_LB_CONTROL__RADAR_LB_CONV_FACTOR__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 10) & 0x0003fc00U)
#define RADAR_LB_CONTROL__RADAR_LB_CONV_FACTOR__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0003fc00U) | (((u_int32_t)(src) <<\
                    10) & 0x0003fc00U)
#define RADAR_LB_CONTROL__RADAR_LB_CONV_FACTOR__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 10) & ~0x0003fc00U)))

/* macros for field radar_lb_adapt_cmp_thr */
#define RADAR_LB_CONTROL__RADAR_LB_ADAPT_CMP_THR__SHIFT                      18
#define RADAR_LB_CONTROL__RADAR_LB_ADAPT_CMP_THR__WIDTH                       5
#define RADAR_LB_CONTROL__RADAR_LB_ADAPT_CMP_THR__MASK              0x007c0000U
#define RADAR_LB_CONTROL__RADAR_LB_ADAPT_CMP_THR__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x007c0000U) >> 18)
#define RADAR_LB_CONTROL__RADAR_LB_ADAPT_CMP_THR__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 18) & 0x007c0000U)
#define RADAR_LB_CONTROL__RADAR_LB_ADAPT_CMP_THR__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x007c0000U) | (((u_int32_t)(src) <<\
                    18) & 0x007c0000U)
#define RADAR_LB_CONTROL__RADAR_LB_ADAPT_CMP_THR__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 18) & ~0x007c0000U)))

/* macros for field chirp_over_dc_skip_ena */
#define RADAR_LB_CONTROL__CHIRP_OVER_DC_SKIP_ENA__SHIFT                      23
#define RADAR_LB_CONTROL__CHIRP_OVER_DC_SKIP_ENA__WIDTH                       1
#define RADAR_LB_CONTROL__CHIRP_OVER_DC_SKIP_ENA__MASK              0x00800000U
#define RADAR_LB_CONTROL__CHIRP_OVER_DC_SKIP_ENA__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00800000U) >> 23)
#define RADAR_LB_CONTROL__CHIRP_OVER_DC_SKIP_ENA__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 23) & 0x00800000U)
#define RADAR_LB_CONTROL__CHIRP_OVER_DC_SKIP_ENA__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00800000U) | (((u_int32_t)(src) <<\
                    23) & 0x00800000U)
#define RADAR_LB_CONTROL__CHIRP_OVER_DC_SKIP_ENA__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 23) & ~0x00800000U)))
#define RADAR_LB_CONTROL__CHIRP_OVER_DC_SKIP_ENA__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00800000U) | ((u_int32_t)(1) << 23)
#define RADAR_LB_CONTROL__CHIRP_OVER_DC_SKIP_ENA__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00800000U) | ((u_int32_t)(0) << 23)

/* macros for field chirp_over_dc_interval */
#define RADAR_LB_CONTROL__CHIRP_OVER_DC_INTERVAL__SHIFT                      24
#define RADAR_LB_CONTROL__CHIRP_OVER_DC_INTERVAL__WIDTH                       6
#define RADAR_LB_CONTROL__CHIRP_OVER_DC_INTERVAL__MASK              0x3f000000U
#define RADAR_LB_CONTROL__CHIRP_OVER_DC_INTERVAL__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x3f000000U) >> 24)
#define RADAR_LB_CONTROL__CHIRP_OVER_DC_INTERVAL__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 24) & 0x3f000000U)
#define RADAR_LB_CONTROL__CHIRP_OVER_DC_INTERVAL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x3f000000U) | (((u_int32_t)(src) <<\
                    24) & 0x3f000000U)
#define RADAR_LB_CONTROL__CHIRP_OVER_DC_INTERVAL__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 24) & ~0x3f000000U)))

/* macros for field force_pwr_lb_bypass */
#define RADAR_LB_CONTROL__FORCE_PWR_LB_BYPASS__SHIFT                         30
#define RADAR_LB_CONTROL__FORCE_PWR_LB_BYPASS__WIDTH                          1
#define RADAR_LB_CONTROL__FORCE_PWR_LB_BYPASS__MASK                 0x40000000U
#define RADAR_LB_CONTROL__FORCE_PWR_LB_BYPASS__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x40000000U) >> 30)
#define RADAR_LB_CONTROL__FORCE_PWR_LB_BYPASS__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 30) & 0x40000000U)
#define RADAR_LB_CONTROL__FORCE_PWR_LB_BYPASS__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x40000000U) | (((u_int32_t)(src) <<\
                    30) & 0x40000000U)
#define RADAR_LB_CONTROL__FORCE_PWR_LB_BYPASS__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 30) & ~0x40000000U)))
#define RADAR_LB_CONTROL__FORCE_PWR_LB_BYPASS__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x40000000U) | ((u_int32_t)(1) << 30)
#define RADAR_LB_CONTROL__FORCE_PWR_LB_BYPASS__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x40000000U) | ((u_int32_t)(0) << 30)

/* macros for field force_adc_lb_bypass */
#define RADAR_LB_CONTROL__FORCE_ADC_LB_BYPASS__SHIFT                         31
#define RADAR_LB_CONTROL__FORCE_ADC_LB_BYPASS__WIDTH                          1
#define RADAR_LB_CONTROL__FORCE_ADC_LB_BYPASS__MASK                 0x80000000U
#define RADAR_LB_CONTROL__FORCE_ADC_LB_BYPASS__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x80000000U) >> 31)
#define RADAR_LB_CONTROL__FORCE_ADC_LB_BYPASS__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 31) & 0x80000000U)
#define RADAR_LB_CONTROL__FORCE_ADC_LB_BYPASS__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x80000000U) | (((u_int32_t)(src) <<\
                    31) & 0x80000000U)
#define RADAR_LB_CONTROL__FORCE_ADC_LB_BYPASS__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 31) & ~0x80000000U)))
#define RADAR_LB_CONTROL__FORCE_ADC_LB_BYPASS__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x80000000U) | ((u_int32_t)(1) << 31)
#define RADAR_LB_CONTROL__FORCE_ADC_LB_BYPASS__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x80000000U) | ((u_int32_t)(0) << 31)
#define RADAR_LB_CONTROL__TYPE                                        u_int32_t
#define RADAR_LB_CONTROL__READ                                      0xffffffffU
#define RADAR_LB_CONTROL__WRITE                                     0xffffffffU

#endif /* __RADAR_LB_CONTROL_MACRO__ */


/* macros for bb_reg_map.bb_agc_reg_map.BB_radar_lb_control */
#define INST_BB_REG_MAP__BB_AGC_REG_MAP__BB_RADAR_LB_CONTROL__NUM             1

/* macros for BlueprintGlobalNameSpace::radar_pulse_thres1 */
#ifndef __RADAR_PULSE_THRES1_MACRO__
#define __RADAR_PULSE_THRES1_MACRO__

/* macros for field long_pulse_rssi_check_ena */
#define RADAR_PULSE_THRES1__LONG_PULSE_RSSI_CHECK_ENA__SHIFT                  0
#define RADAR_PULSE_THRES1__LONG_PULSE_RSSI_CHECK_ENA__WIDTH                  1
#define RADAR_PULSE_THRES1__LONG_PULSE_RSSI_CHECK_ENA__MASK         0x00000001U
#define RADAR_PULSE_THRES1__LONG_PULSE_RSSI_CHECK_ENA__READ(src) \
                    (u_int32_t)(src)\
                    & 0x00000001U
#define RADAR_PULSE_THRES1__LONG_PULSE_RSSI_CHECK_ENA__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x00000001U)
#define RADAR_PULSE_THRES1__LONG_PULSE_RSSI_CHECK_ENA__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | ((u_int32_t)(src) &\
                    0x00000001U)
#define RADAR_PULSE_THRES1__LONG_PULSE_RSSI_CHECK_ENA__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00000001U)))
#define RADAR_PULSE_THRES1__LONG_PULSE_RSSI_CHECK_ENA__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(1)
#define RADAR_PULSE_THRES1__LONG_PULSE_RSSI_CHECK_ENA__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(0)

/* macros for field long_pulse_at_dc_rssi_thresh */
#define RADAR_PULSE_THRES1__LONG_PULSE_AT_DC_RSSI_THRESH__SHIFT               1
#define RADAR_PULSE_THRES1__LONG_PULSE_AT_DC_RSSI_THRESH__WIDTH               6
#define RADAR_PULSE_THRES1__LONG_PULSE_AT_DC_RSSI_THRESH__MASK      0x0000007eU
#define RADAR_PULSE_THRES1__LONG_PULSE_AT_DC_RSSI_THRESH__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0000007eU) >> 1)
#define RADAR_PULSE_THRES1__LONG_PULSE_AT_DC_RSSI_THRESH__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 1) & 0x0000007eU)
#define RADAR_PULSE_THRES1__LONG_PULSE_AT_DC_RSSI_THRESH__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000007eU) | (((u_int32_t)(src) <<\
                    1) & 0x0000007eU)
#define RADAR_PULSE_THRES1__LONG_PULSE_AT_DC_RSSI_THRESH__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 1) & ~0x0000007eU)))

/* macros for field long_pulse_rssi_thresh */
#define RADAR_PULSE_THRES1__LONG_PULSE_RSSI_THRESH__SHIFT                     7
#define RADAR_PULSE_THRES1__LONG_PULSE_RSSI_THRESH__WIDTH                     6
#define RADAR_PULSE_THRES1__LONG_PULSE_RSSI_THRESH__MASK            0x00001f80U
#define RADAR_PULSE_THRES1__LONG_PULSE_RSSI_THRESH__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00001f80U) >> 7)
#define RADAR_PULSE_THRES1__LONG_PULSE_RSSI_THRESH__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 7) & 0x00001f80U)
#define RADAR_PULSE_THRES1__LONG_PULSE_RSSI_THRESH__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00001f80U) | (((u_int32_t)(src) <<\
                    7) & 0x00001f80U)
#define RADAR_PULSE_THRES1__LONG_PULSE_RSSI_THRESH__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 7) & ~0x00001f80U)))

/* macros for field pulse_at_dc_rssi_thresh */
#define RADAR_PULSE_THRES1__PULSE_AT_DC_RSSI_THRESH__SHIFT                   13
#define RADAR_PULSE_THRES1__PULSE_AT_DC_RSSI_THRESH__WIDTH                    6
#define RADAR_PULSE_THRES1__PULSE_AT_DC_RSSI_THRESH__MASK           0x0007e000U
#define RADAR_PULSE_THRES1__PULSE_AT_DC_RSSI_THRESH__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0007e000U) >> 13)
#define RADAR_PULSE_THRES1__PULSE_AT_DC_RSSI_THRESH__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 13) & 0x0007e000U)
#define RADAR_PULSE_THRES1__PULSE_AT_DC_RSSI_THRESH__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0007e000U) | (((u_int32_t)(src) <<\
                    13) & 0x0007e000U)
#define RADAR_PULSE_THRES1__PULSE_AT_DC_RSSI_THRESH__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 13) & ~0x0007e000U)))

/* macros for field radar_fft_80p80_rel_thrsh */
#define RADAR_PULSE_THRES1__RADAR_FFT_80P80_REL_THRSH__SHIFT                 19
#define RADAR_PULSE_THRES1__RADAR_FFT_80P80_REL_THRSH__WIDTH                  6
#define RADAR_PULSE_THRES1__RADAR_FFT_80P80_REL_THRSH__MASK         0x01f80000U
#define RADAR_PULSE_THRES1__RADAR_FFT_80P80_REL_THRSH__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x01f80000U) >> 19)
#define RADAR_PULSE_THRES1__RADAR_FFT_80P80_REL_THRSH__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 19) & 0x01f80000U)
#define RADAR_PULSE_THRES1__RADAR_FFT_80P80_REL_THRSH__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x01f80000U) | (((u_int32_t)(src) <<\
                    19) & 0x01f80000U)
#define RADAR_PULSE_THRES1__RADAR_FFT_80P80_REL_THRSH__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 19) & ~0x01f80000U)))

/* macros for field pursue_ext80_radar */
#define RADAR_PULSE_THRES1__PURSUE_EXT80_RADAR__SHIFT                        25
#define RADAR_PULSE_THRES1__PURSUE_EXT80_RADAR__WIDTH                         1
#define RADAR_PULSE_THRES1__PURSUE_EXT80_RADAR__MASK                0x02000000U
#define RADAR_PULSE_THRES1__PURSUE_EXT80_RADAR__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x02000000U) >> 25)
#define RADAR_PULSE_THRES1__PURSUE_EXT80_RADAR__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 25) & 0x02000000U)
#define RADAR_PULSE_THRES1__PURSUE_EXT80_RADAR__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x02000000U) | (((u_int32_t)(src) <<\
                    25) & 0x02000000U)
#define RADAR_PULSE_THRES1__PURSUE_EXT80_RADAR__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 25) & ~0x02000000U)))
#define RADAR_PULSE_THRES1__PURSUE_EXT80_RADAR__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x02000000U) | ((u_int32_t)(1) << 25)
#define RADAR_PULSE_THRES1__PURSUE_EXT80_RADAR__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x02000000U) | ((u_int32_t)(0) << 25)

/* macros for field radar_1st_fft_delay */
#define RADAR_PULSE_THRES1__RADAR_1ST_FFT_DELAY__SHIFT                       26
#define RADAR_PULSE_THRES1__RADAR_1ST_FFT_DELAY__WIDTH                        6
#define RADAR_PULSE_THRES1__RADAR_1ST_FFT_DELAY__MASK               0xfc000000U
#define RADAR_PULSE_THRES1__RADAR_1ST_FFT_DELAY__READ(src) \
                    (((u_int32_t)(src)\
                    & 0xfc000000U) >> 26)
#define RADAR_PULSE_THRES1__RADAR_1ST_FFT_DELAY__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 26) & 0xfc000000U)
#define RADAR_PULSE_THRES1__RADAR_1ST_FFT_DELAY__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xfc000000U) | (((u_int32_t)(src) <<\
                    26) & 0xfc000000U)
#define RADAR_PULSE_THRES1__RADAR_1ST_FFT_DELAY__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 26) & ~0xfc000000U)))
#define RADAR_PULSE_THRES1__TYPE                                      u_int32_t
#define RADAR_PULSE_THRES1__READ                                    0xffffffffU
#define RADAR_PULSE_THRES1__WRITE                                   0xffffffffU

#endif /* __RADAR_PULSE_THRES1_MACRO__ */


/* macros for bb_reg_map.bb_agc_reg_map.BB_radar_pulse_thres1 */
#define INST_BB_REG_MAP__BB_AGC_REG_MAP__BB_RADAR_PULSE_THRES1__NUM           1

/* macros for BlueprintGlobalNameSpace::radar_pulse_thres2 */
#ifndef __RADAR_PULSE_THRES2_MACRO__
#define __RADAR_PULSE_THRES2_MACRO__

/* macros for field str_bin_thr_radar_fine */
#define RADAR_PULSE_THRES2__STR_BIN_THR_RADAR_FINE__SHIFT                     0
#define RADAR_PULSE_THRES2__STR_BIN_THR_RADAR_FINE__WIDTH                     6
#define RADAR_PULSE_THRES2__STR_BIN_THR_RADAR_FINE__MASK            0x0000003fU
#define RADAR_PULSE_THRES2__STR_BIN_THR_RADAR_FINE__READ(src) \
                    (u_int32_t)(src)\
                    & 0x0000003fU
#define RADAR_PULSE_THRES2__STR_BIN_THR_RADAR_FINE__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x0000003fU)
#define RADAR_PULSE_THRES2__STR_BIN_THR_RADAR_FINE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000003fU) | ((u_int32_t)(src) &\
                    0x0000003fU)
#define RADAR_PULSE_THRES2__STR_BIN_THR_RADAR_FINE__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x0000003fU)))

/* macros for field str_bin_thr_radar_chirp */
#define RADAR_PULSE_THRES2__STR_BIN_THR_RADAR_CHIRP__SHIFT                    6
#define RADAR_PULSE_THRES2__STR_BIN_THR_RADAR_CHIRP__WIDTH                    6
#define RADAR_PULSE_THRES2__STR_BIN_THR_RADAR_CHIRP__MASK           0x00000fc0U
#define RADAR_PULSE_THRES2__STR_BIN_THR_RADAR_CHIRP__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000fc0U) >> 6)
#define RADAR_PULSE_THRES2__STR_BIN_THR_RADAR_CHIRP__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 6) & 0x00000fc0U)
#define RADAR_PULSE_THRES2__STR_BIN_THR_RADAR_CHIRP__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000fc0U) | (((u_int32_t)(src) <<\
                    6) & 0x00000fc0U)
#define RADAR_PULSE_THRES2__STR_BIN_THR_RADAR_CHIRP__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 6) & ~0x00000fc0U)))

/* macros for field nb_tone_thres_radar_chirp */
#define RADAR_PULSE_THRES2__NB_TONE_THRES_RADAR_CHIRP__SHIFT                 12
#define RADAR_PULSE_THRES2__NB_TONE_THRES_RADAR_CHIRP__WIDTH                  8
#define RADAR_PULSE_THRES2__NB_TONE_THRES_RADAR_CHIRP__MASK         0x000ff000U
#define RADAR_PULSE_THRES2__NB_TONE_THRES_RADAR_CHIRP__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x000ff000U) >> 12)
#define RADAR_PULSE_THRES2__NB_TONE_THRES_RADAR_CHIRP__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 12) & 0x000ff000U)
#define RADAR_PULSE_THRES2__NB_TONE_THRES_RADAR_CHIRP__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000ff000U) | (((u_int32_t)(src) <<\
                    12) & 0x000ff000U)
#define RADAR_PULSE_THRES2__NB_TONE_THRES_RADAR_CHIRP__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 12) & ~0x000ff000U)))

/* macros for field srch_fft_adcsat_peakmag_thr */
#define RADAR_PULSE_THRES2__SRCH_FFT_ADCSAT_PEAKMAG_THR__SHIFT               20
#define RADAR_PULSE_THRES2__SRCH_FFT_ADCSAT_PEAKMAG_THR__WIDTH               10
#define RADAR_PULSE_THRES2__SRCH_FFT_ADCSAT_PEAKMAG_THR__MASK       0x3ff00000U
#define RADAR_PULSE_THRES2__SRCH_FFT_ADCSAT_PEAKMAG_THR__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x3ff00000U) >> 20)
#define RADAR_PULSE_THRES2__SRCH_FFT_ADCSAT_PEAKMAG_THR__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 20) & 0x3ff00000U)
#define RADAR_PULSE_THRES2__SRCH_FFT_ADCSAT_PEAKMAG_THR__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x3ff00000U) | (((u_int32_t)(src) <<\
                    20) & 0x3ff00000U)
#define RADAR_PULSE_THRES2__SRCH_FFT_ADCSAT_PEAKMAG_THR__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 20) & ~0x3ff00000U)))
#define RADAR_PULSE_THRES2__TYPE                                      u_int32_t
#define RADAR_PULSE_THRES2__READ                                    0x3fffffffU
#define RADAR_PULSE_THRES2__WRITE                                   0x3fffffffU

#endif /* __RADAR_PULSE_THRES2_MACRO__ */


/* macros for bb_reg_map.bb_agc_reg_map.BB_radar_pulse_thres2 */
#define INST_BB_REG_MAP__BB_AGC_REG_MAP__BB_RADAR_PULSE_THRES2__NUM           1

/* macros for BlueprintGlobalNameSpace::ss_gain_ctrl_1 */
#ifndef __SS_GAIN_CTRL_1_MACRO__
#define __SS_GAIN_CTRL_1_MACRO__

/* macros for field ss_gain_copy_ena */
#define SS_GAIN_CTRL_1__SS_GAIN_COPY_ENA__SHIFT                               0
#define SS_GAIN_CTRL_1__SS_GAIN_COPY_ENA__WIDTH                               1
#define SS_GAIN_CTRL_1__SS_GAIN_COPY_ENA__MASK                      0x00000001U
#define SS_GAIN_CTRL_1__SS_GAIN_COPY_ENA__READ(src) \
                    (u_int32_t)(src)\
                    & 0x00000001U
#define SS_GAIN_CTRL_1__SS_GAIN_COPY_ENA__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x00000001U)
#define SS_GAIN_CTRL_1__SS_GAIN_COPY_ENA__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | ((u_int32_t)(src) &\
                    0x00000001U)
#define SS_GAIN_CTRL_1__SS_GAIN_COPY_ENA__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00000001U)))
#define SS_GAIN_CTRL_1__SS_GAIN_COPY_ENA__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(1)
#define SS_GAIN_CTRL_1__SS_GAIN_COPY_ENA__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(0)

/* macros for field second_agc_use_16 */
#define SS_GAIN_CTRL_1__SECOND_AGC_USE_16__SHIFT                              1
#define SS_GAIN_CTRL_1__SECOND_AGC_USE_16__WIDTH                              1
#define SS_GAIN_CTRL_1__SECOND_AGC_USE_16__MASK                     0x00000002U
#define SS_GAIN_CTRL_1__SECOND_AGC_USE_16__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000002U) >> 1)
#define SS_GAIN_CTRL_1__SECOND_AGC_USE_16__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 1) & 0x00000002U)
#define SS_GAIN_CTRL_1__SECOND_AGC_USE_16__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | (((u_int32_t)(src) <<\
                    1) & 0x00000002U)
#define SS_GAIN_CTRL_1__SECOND_AGC_USE_16__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 1) & ~0x00000002U)))
#define SS_GAIN_CTRL_1__SECOND_AGC_USE_16__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | ((u_int32_t)(1) << 1)
#define SS_GAIN_CTRL_1__SECOND_AGC_USE_16__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | ((u_int32_t)(0) << 1)

/* macros for field ss_settle_time */
#define SS_GAIN_CTRL_1__SS_SETTLE_TIME__SHIFT                                 8
#define SS_GAIN_CTRL_1__SS_SETTLE_TIME__WIDTH                                 7
#define SS_GAIN_CTRL_1__SS_SETTLE_TIME__MASK                        0x00007f00U
#define SS_GAIN_CTRL_1__SS_SETTLE_TIME__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00007f00U) >> 8)
#define SS_GAIN_CTRL_1__SS_SETTLE_TIME__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 8) & 0x00007f00U)
#define SS_GAIN_CTRL_1__SS_SETTLE_TIME__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00007f00U) | (((u_int32_t)(src) <<\
                    8) & 0x00007f00U)
#define SS_GAIN_CTRL_1__SS_SETTLE_TIME__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 8) & ~0x00007f00U)))

/* macros for field ss_gain_copy_reduce_db2 */
#define SS_GAIN_CTRL_1__SS_GAIN_COPY_REDUCE_DB2__SHIFT                       16
#define SS_GAIN_CTRL_1__SS_GAIN_COPY_REDUCE_DB2__WIDTH                        6
#define SS_GAIN_CTRL_1__SS_GAIN_COPY_REDUCE_DB2__MASK               0x003f0000U
#define SS_GAIN_CTRL_1__SS_GAIN_COPY_REDUCE_DB2__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x003f0000U) >> 16)
#define SS_GAIN_CTRL_1__SS_GAIN_COPY_REDUCE_DB2__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 16) & 0x003f0000U)
#define SS_GAIN_CTRL_1__SS_GAIN_COPY_REDUCE_DB2__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x003f0000U) | (((u_int32_t)(src) <<\
                    16) & 0x003f0000U)
#define SS_GAIN_CTRL_1__SS_GAIN_COPY_REDUCE_DB2__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 16) & ~0x003f0000U)))

/* macros for field ss_copy_target_power */
#define SS_GAIN_CTRL_1__SS_COPY_TARGET_POWER__SHIFT                          24
#define SS_GAIN_CTRL_1__SS_COPY_TARGET_POWER__WIDTH                           1
#define SS_GAIN_CTRL_1__SS_COPY_TARGET_POWER__MASK                  0x01000000U
#define SS_GAIN_CTRL_1__SS_COPY_TARGET_POWER__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x01000000U) >> 24)
#define SS_GAIN_CTRL_1__SS_COPY_TARGET_POWER__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 24) & 0x01000000U)
#define SS_GAIN_CTRL_1__SS_COPY_TARGET_POWER__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x01000000U) | (((u_int32_t)(src) <<\
                    24) & 0x01000000U)
#define SS_GAIN_CTRL_1__SS_COPY_TARGET_POWER__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 24) & ~0x01000000U)))
#define SS_GAIN_CTRL_1__SS_COPY_TARGET_POWER__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x01000000U) | ((u_int32_t)(1) << 24)
#define SS_GAIN_CTRL_1__SS_COPY_TARGET_POWER__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x01000000U) | ((u_int32_t)(0) << 24)
#define SS_GAIN_CTRL_1__TYPE                                          u_int32_t
#define SS_GAIN_CTRL_1__READ                                        0x013f7f03U
#define SS_GAIN_CTRL_1__WRITE                                       0x013f7f03U

#endif /* __SS_GAIN_CTRL_1_MACRO__ */


/* macros for bb_reg_map.bb_agc_reg_map.BB_ss_gain_ctrl_1 */
#define INST_BB_REG_MAP__BB_AGC_REG_MAP__BB_SS_GAIN_CTRL_1__NUM               1

/* macros for BlueprintGlobalNameSpace::agc_rtt_ctrl */
#ifndef __AGC_RTT_CTRL_MACRO__
#define __AGC_RTT_CTRL_MACRO__

/* macros for field rtt_chain_sel_th_4 */
#define AGC_RTT_CTRL__RTT_CHAIN_SEL_TH_4__SHIFT                               0
#define AGC_RTT_CTRL__RTT_CHAIN_SEL_TH_4__WIDTH                              10
#define AGC_RTT_CTRL__RTT_CHAIN_SEL_TH_4__MASK                      0x000003ffU
#define AGC_RTT_CTRL__RTT_CHAIN_SEL_TH_4__READ(src) \
                    (u_int32_t)(src)\
                    & 0x000003ffU
#define AGC_RTT_CTRL__RTT_CHAIN_SEL_TH_4__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x000003ffU)
#define AGC_RTT_CTRL__RTT_CHAIN_SEL_TH_4__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000003ffU) | ((u_int32_t)(src) &\
                    0x000003ffU)
#define AGC_RTT_CTRL__RTT_CHAIN_SEL_TH_4__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x000003ffU)))

/* macros for field fixed_str_chain_rtt */
#define AGC_RTT_CTRL__FIXED_STR_CHAIN_RTT__SHIFT                             16
#define AGC_RTT_CTRL__FIXED_STR_CHAIN_RTT__WIDTH                              2
#define AGC_RTT_CTRL__FIXED_STR_CHAIN_RTT__MASK                     0x00030000U
#define AGC_RTT_CTRL__FIXED_STR_CHAIN_RTT__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00030000U) >> 16)
#define AGC_RTT_CTRL__FIXED_STR_CHAIN_RTT__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 16) & 0x00030000U)
#define AGC_RTT_CTRL__FIXED_STR_CHAIN_RTT__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00030000U) | (((u_int32_t)(src) <<\
                    16) & 0x00030000U)
#define AGC_RTT_CTRL__FIXED_STR_CHAIN_RTT__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 16) & ~0x00030000U)))

/* macros for field fixed_str_chain_rtt_en */
#define AGC_RTT_CTRL__FIXED_STR_CHAIN_RTT_EN__SHIFT                          18
#define AGC_RTT_CTRL__FIXED_STR_CHAIN_RTT_EN__WIDTH                           1
#define AGC_RTT_CTRL__FIXED_STR_CHAIN_RTT_EN__MASK                  0x00040000U
#define AGC_RTT_CTRL__FIXED_STR_CHAIN_RTT_EN__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00040000U) >> 18)
#define AGC_RTT_CTRL__FIXED_STR_CHAIN_RTT_EN__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 18) & 0x00040000U)
#define AGC_RTT_CTRL__FIXED_STR_CHAIN_RTT_EN__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00040000U) | (((u_int32_t)(src) <<\
                    18) & 0x00040000U)
#define AGC_RTT_CTRL__FIXED_STR_CHAIN_RTT_EN__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 18) & ~0x00040000U)))
#define AGC_RTT_CTRL__FIXED_STR_CHAIN_RTT_EN__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00040000U) | ((u_int32_t)(1) << 18)
#define AGC_RTT_CTRL__FIXED_STR_CHAIN_RTT_EN__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00040000U) | ((u_int32_t)(0) << 18)
#define AGC_RTT_CTRL__TYPE                                            u_int32_t
#define AGC_RTT_CTRL__READ                                          0x000703ffU
#define AGC_RTT_CTRL__WRITE                                         0x000703ffU

#endif /* __AGC_RTT_CTRL_MACRO__ */


/* macros for bb_reg_map.bb_agc_reg_map.BB_agc_rtt_ctrl */
#define INST_BB_REG_MAP__BB_AGC_REG_MAP__BB_AGC_RTT_CTRL__NUM                 1

/* macros for BlueprintGlobalNameSpace::rx_gain_nf_en */
#ifndef __RX_GAIN_NF_EN_MACRO__
#define __RX_GAIN_NF_EN_MACRO__

/* macros for field capture_nf_gain */
#define RX_GAIN_NF_EN__CAPTURE_NF_GAIN__SHIFT                                 0
#define RX_GAIN_NF_EN__CAPTURE_NF_GAIN__WIDTH                                 1
#define RX_GAIN_NF_EN__CAPTURE_NF_GAIN__MASK                        0x00000001U
#define RX_GAIN_NF_EN__CAPTURE_NF_GAIN__READ(src) \
                    (u_int32_t)(src)\
                    & 0x00000001U
#define RX_GAIN_NF_EN__CAPTURE_NF_GAIN__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x00000001U)
#define RX_GAIN_NF_EN__CAPTURE_NF_GAIN__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | ((u_int32_t)(src) &\
                    0x00000001U)
#define RX_GAIN_NF_EN__CAPTURE_NF_GAIN__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00000001U)))
#define RX_GAIN_NF_EN__CAPTURE_NF_GAIN__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(1)
#define RX_GAIN_NF_EN__CAPTURE_NF_GAIN__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(0)
#define RX_GAIN_NF_EN__TYPE                                           u_int32_t
#define RX_GAIN_NF_EN__READ                                         0x00000001U
#define RX_GAIN_NF_EN__WRITE                                        0x00000001U

#endif /* __RX_GAIN_NF_EN_MACRO__ */


/* macros for bb_reg_map.bb_agc_reg_map.BB_rx_gain_nf_en */
#define INST_BB_REG_MAP__BB_AGC_REG_MAP__BB_RX_GAIN_NF_EN__NUM                1

/* macros for BlueprintGlobalNameSpace::rssi_b0 */
#ifndef __RSSI_B0_MACRO__
#define __RSSI_B0_MACRO__

/* macros for field rssi_pri20_0 */
#define RSSI_B0__RSSI_PRI20_0__SHIFT                                          0
#define RSSI_B0__RSSI_PRI20_0__WIDTH                                          8
#define RSSI_B0__RSSI_PRI20_0__MASK                                 0x000000ffU
#define RSSI_B0__RSSI_PRI20_0__READ(src)         (u_int32_t)(src) & 0x000000ffU

/* macros for field rssi_ext20_0 */
#define RSSI_B0__RSSI_EXT20_0__SHIFT                                          8
#define RSSI_B0__RSSI_EXT20_0__WIDTH                                          8
#define RSSI_B0__RSSI_EXT20_0__MASK                                 0x0000ff00U
#define RSSI_B0__RSSI_EXT20_0__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0000ff00U) >> 8)

/* macros for field rssi_ext40_0 */
#define RSSI_B0__RSSI_EXT40_0__SHIFT                                         16
#define RSSI_B0__RSSI_EXT40_0__WIDTH                                          8
#define RSSI_B0__RSSI_EXT40_0__MASK                                 0x00ff0000U
#define RSSI_B0__RSSI_EXT40_0__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00ff0000U) >> 16)

/* macros for field rssi_ext80_0 */
#define RSSI_B0__RSSI_EXT80_0__SHIFT                                         24
#define RSSI_B0__RSSI_EXT80_0__WIDTH                                          8
#define RSSI_B0__RSSI_EXT80_0__MASK                                 0xff000000U
#define RSSI_B0__RSSI_EXT80_0__READ(src) \
                    (((u_int32_t)(src)\
                    & 0xff000000U) >> 24)
#define RSSI_B0__TYPE                                                 u_int32_t
#define RSSI_B0__READ                                               0xffffffffU

#endif /* __RSSI_B0_MACRO__ */


/* macros for bb_reg_map.bb_agc_reg_map.BB_rssi_b0 */
#define INST_BB_REG_MAP__BB_AGC_REG_MAP__BB_RSSI_B0__NUM                      1

/* macros for BlueprintGlobalNameSpace::agc_dig_dc_status_b0 */
#ifndef __AGC_DIG_DC_STATUS_B0_MACRO__
#define __AGC_DIG_DC_STATUS_B0_MACRO__

/* macros for field dc_cal_residual_dc_i_0 */
#define AGC_DIG_DC_STATUS_B0__DC_CAL_RESIDUAL_DC_I_0__SHIFT                   0
#define AGC_DIG_DC_STATUS_B0__DC_CAL_RESIDUAL_DC_I_0__WIDTH                  10
#define AGC_DIG_DC_STATUS_B0__DC_CAL_RESIDUAL_DC_I_0__MASK          0x000003ffU
#define AGC_DIG_DC_STATUS_B0__DC_CAL_RESIDUAL_DC_I_0__READ(src) \
                    (u_int32_t)(src)\
                    & 0x000003ffU
#define AGC_DIG_DC_STATUS_B0__DC_CAL_RESIDUAL_DC_I_0__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x000003ffU)
#define AGC_DIG_DC_STATUS_B0__DC_CAL_RESIDUAL_DC_I_0__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000003ffU) | ((u_int32_t)(src) &\
                    0x000003ffU)
#define AGC_DIG_DC_STATUS_B0__DC_CAL_RESIDUAL_DC_I_0__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x000003ffU)))

/* macros for field dc_cal_residual_dc_q_0 */
#define AGC_DIG_DC_STATUS_B0__DC_CAL_RESIDUAL_DC_Q_0__SHIFT                  10
#define AGC_DIG_DC_STATUS_B0__DC_CAL_RESIDUAL_DC_Q_0__WIDTH                  10
#define AGC_DIG_DC_STATUS_B0__DC_CAL_RESIDUAL_DC_Q_0__MASK          0x000ffc00U
#define AGC_DIG_DC_STATUS_B0__DC_CAL_RESIDUAL_DC_Q_0__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x000ffc00U) >> 10)
#define AGC_DIG_DC_STATUS_B0__DC_CAL_RESIDUAL_DC_Q_0__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 10) & 0x000ffc00U)
#define AGC_DIG_DC_STATUS_B0__DC_CAL_RESIDUAL_DC_Q_0__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000ffc00U) | (((u_int32_t)(src) <<\
                    10) & 0x000ffc00U)
#define AGC_DIG_DC_STATUS_B0__DC_CAL_RESIDUAL_DC_Q_0__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 10) & ~0x000ffc00U)))
#define AGC_DIG_DC_STATUS_B0__TYPE                                    u_int32_t
#define AGC_DIG_DC_STATUS_B0__READ                                  0x000fffffU
#define AGC_DIG_DC_STATUS_B0__WRITE                                 0x000fffffU

#endif /* __AGC_DIG_DC_STATUS_B0_MACRO__ */


/* macros for bb_reg_map.bb_agc_reg_map.BB_agc_dig_dc_status_b0 */
#define INST_BB_REG_MAP__BB_AGC_REG_MAP__BB_AGC_DIG_DC_STATUS_B0__NUM         1

/* macros for BlueprintGlobalNameSpace::dc_cal_status_b0 */
#ifndef __DC_CAL_STATUS_B0_MACRO__
#define __DC_CAL_STATUS_B0_MACRO__

/* macros for field offsetC1I_0 */
#define DC_CAL_STATUS_B0__OFFSETC1I_0__SHIFT                                  0
#define DC_CAL_STATUS_B0__OFFSETC1I_0__WIDTH                                  8
#define DC_CAL_STATUS_B0__OFFSETC1I_0__MASK                         0x000000ffU
#define DC_CAL_STATUS_B0__OFFSETC1I_0__READ(src) (u_int32_t)(src) & 0x000000ffU

/* macros for field offsetC1Q_0 */
#define DC_CAL_STATUS_B0__OFFSETC1Q_0__SHIFT                                  8
#define DC_CAL_STATUS_B0__OFFSETC1Q_0__WIDTH                                  8
#define DC_CAL_STATUS_B0__OFFSETC1Q_0__MASK                         0x0000ff00U
#define DC_CAL_STATUS_B0__OFFSETC1Q_0__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0000ff00U) >> 8)

/* macros for field offsetC2I_0 */
#define DC_CAL_STATUS_B0__OFFSETC2I_0__SHIFT                                 16
#define DC_CAL_STATUS_B0__OFFSETC2I_0__WIDTH                                  8
#define DC_CAL_STATUS_B0__OFFSETC2I_0__MASK                         0x00ff0000U
#define DC_CAL_STATUS_B0__OFFSETC2I_0__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00ff0000U) >> 16)

/* macros for field offsetC2Q_0 */
#define DC_CAL_STATUS_B0__OFFSETC2Q_0__SHIFT                                 24
#define DC_CAL_STATUS_B0__OFFSETC2Q_0__WIDTH                                  8
#define DC_CAL_STATUS_B0__OFFSETC2Q_0__MASK                         0xff000000U
#define DC_CAL_STATUS_B0__OFFSETC2Q_0__READ(src) \
                    (((u_int32_t)(src)\
                    & 0xff000000U) >> 24)
#define DC_CAL_STATUS_B0__TYPE                                        u_int32_t
#define DC_CAL_STATUS_B0__READ                                      0xffffffffU

#endif /* __DC_CAL_STATUS_B0_MACRO__ */


/* macros for bb_reg_map.bb_agc_reg_map.BB_dc_cal_status_b0 */
#define INST_BB_REG_MAP__BB_AGC_REG_MAP__BB_DC_CAL_STATUS_B0__NUM             1

/* macros for BlueprintGlobalNameSpace::dc_cal_status_2_b0 */
#ifndef __DC_CAL_STATUS_2_B0_MACRO__
#define __DC_CAL_STATUS_2_B0_MACRO__

/* macros for field offsetC3I_0 */
#define DC_CAL_STATUS_2_B0__OFFSETC3I_0__SHIFT                                0
#define DC_CAL_STATUS_2_B0__OFFSETC3I_0__WIDTH                                8
#define DC_CAL_STATUS_2_B0__OFFSETC3I_0__MASK                       0x000000ffU
#define DC_CAL_STATUS_2_B0__OFFSETC3I_0__READ(src) \
                    (u_int32_t)(src)\
                    & 0x000000ffU

/* macros for field offsetC3Q_0 */
#define DC_CAL_STATUS_2_B0__OFFSETC3Q_0__SHIFT                                8
#define DC_CAL_STATUS_2_B0__OFFSETC3Q_0__WIDTH                                8
#define DC_CAL_STATUS_2_B0__OFFSETC3Q_0__MASK                       0x0000ff00U
#define DC_CAL_STATUS_2_B0__OFFSETC3Q_0__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0000ff00U) >> 8)

/* macros for field offsetC4I_0 */
#define DC_CAL_STATUS_2_B0__OFFSETC4I_0__SHIFT                               16
#define DC_CAL_STATUS_2_B0__OFFSETC4I_0__WIDTH                                8
#define DC_CAL_STATUS_2_B0__OFFSETC4I_0__MASK                       0x00ff0000U
#define DC_CAL_STATUS_2_B0__OFFSETC4I_0__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00ff0000U) >> 16)

/* macros for field offsetC4Q_0 */
#define DC_CAL_STATUS_2_B0__OFFSETC4Q_0__SHIFT                               24
#define DC_CAL_STATUS_2_B0__OFFSETC4Q_0__WIDTH                                8
#define DC_CAL_STATUS_2_B0__OFFSETC4Q_0__MASK                       0xff000000U
#define DC_CAL_STATUS_2_B0__OFFSETC4Q_0__READ(src) \
                    (((u_int32_t)(src)\
                    & 0xff000000U) >> 24)
#define DC_CAL_STATUS_2_B0__TYPE                                      u_int32_t
#define DC_CAL_STATUS_2_B0__READ                                    0xffffffffU

#endif /* __DC_CAL_STATUS_2_B0_MACRO__ */


/* macros for bb_reg_map.bb_agc_reg_map.BB_dc_cal_status_2_b0 */
#define INST_BB_REG_MAP__BB_AGC_REG_MAP__BB_DC_CAL_STATUS_2_B0__NUM           1

/* macros for BlueprintGlobalNameSpace::dc_cal_status_3_b0 */
#ifndef __DC_CAL_STATUS_3_B0_MACRO__
#define __DC_CAL_STATUS_3_B0_MACRO__

/* macros for field offsetC5I_0 */
#define DC_CAL_STATUS_3_B0__OFFSETC5I_0__SHIFT                                0
#define DC_CAL_STATUS_3_B0__OFFSETC5I_0__WIDTH                                8
#define DC_CAL_STATUS_3_B0__OFFSETC5I_0__MASK                       0x000000ffU
#define DC_CAL_STATUS_3_B0__OFFSETC5I_0__READ(src) \
                    (u_int32_t)(src)\
                    & 0x000000ffU

/* macros for field offsetC5Q_0 */
#define DC_CAL_STATUS_3_B0__OFFSETC5Q_0__SHIFT                                8
#define DC_CAL_STATUS_3_B0__OFFSETC5Q_0__WIDTH                                8
#define DC_CAL_STATUS_3_B0__OFFSETC5Q_0__MASK                       0x0000ff00U
#define DC_CAL_STATUS_3_B0__OFFSETC5Q_0__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0000ff00U) >> 8)

/* macros for field offsetC6I_0 */
#define DC_CAL_STATUS_3_B0__OFFSETC6I_0__SHIFT                               16
#define DC_CAL_STATUS_3_B0__OFFSETC6I_0__WIDTH                                8
#define DC_CAL_STATUS_3_B0__OFFSETC6I_0__MASK                       0x00ff0000U
#define DC_CAL_STATUS_3_B0__OFFSETC6I_0__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00ff0000U) >> 16)

/* macros for field offsetC6Q_0 */
#define DC_CAL_STATUS_3_B0__OFFSETC6Q_0__SHIFT                               24
#define DC_CAL_STATUS_3_B0__OFFSETC6Q_0__WIDTH                                8
#define DC_CAL_STATUS_3_B0__OFFSETC6Q_0__MASK                       0xff000000U
#define DC_CAL_STATUS_3_B0__OFFSETC6Q_0__READ(src) \
                    (((u_int32_t)(src)\
                    & 0xff000000U) >> 24)
#define DC_CAL_STATUS_3_B0__TYPE                                      u_int32_t
#define DC_CAL_STATUS_3_B0__READ                                    0xffffffffU

#endif /* __DC_CAL_STATUS_3_B0_MACRO__ */


/* macros for bb_reg_map.bb_agc_reg_map.BB_dc_cal_status_3_b0 */
#define INST_BB_REG_MAP__BB_AGC_REG_MAP__BB_DC_CAL_STATUS_3_B0__NUM           1

/* macros for BlueprintGlobalNameSpace::dc_cal_status_4_b0 */
#ifndef __DC_CAL_STATUS_4_B0_MACRO__
#define __DC_CAL_STATUS_4_B0_MACRO__

/* macros for field offsetC7I_0 */
#define DC_CAL_STATUS_4_B0__OFFSETC7I_0__SHIFT                                0
#define DC_CAL_STATUS_4_B0__OFFSETC7I_0__WIDTH                                8
#define DC_CAL_STATUS_4_B0__OFFSETC7I_0__MASK                       0x000000ffU
#define DC_CAL_STATUS_4_B0__OFFSETC7I_0__READ(src) \
                    (u_int32_t)(src)\
                    & 0x000000ffU

/* macros for field offsetC7Q_0 */
#define DC_CAL_STATUS_4_B0__OFFSETC7Q_0__SHIFT                                8
#define DC_CAL_STATUS_4_B0__OFFSETC7Q_0__WIDTH                                8
#define DC_CAL_STATUS_4_B0__OFFSETC7Q_0__MASK                       0x0000ff00U
#define DC_CAL_STATUS_4_B0__OFFSETC7Q_0__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0000ff00U) >> 8)
#define DC_CAL_STATUS_4_B0__TYPE                                      u_int32_t
#define DC_CAL_STATUS_4_B0__READ                                    0x0000ffffU

#endif /* __DC_CAL_STATUS_4_B0_MACRO__ */


/* macros for bb_reg_map.bb_agc_reg_map.BB_dc_cal_status_4_b0 */
#define INST_BB_REG_MAP__BB_AGC_REG_MAP__BB_DC_CAL_STATUS_4_B0__NUM           1

/* macros for BlueprintGlobalNameSpace::rx_gain_nf_b0 */
#ifndef __RX_GAIN_NF_B0_MACRO__
#define __RX_GAIN_NF_B0_MACRO__

/* macros for field gain_val_after_nf_0 */
#define RX_GAIN_NF_B0__GAIN_VAL_AFTER_NF_0__SHIFT                             0
#define RX_GAIN_NF_B0__GAIN_VAL_AFTER_NF_0__WIDTH                            17
#define RX_GAIN_NF_B0__GAIN_VAL_AFTER_NF_0__MASK                    0x0001ffffU
#define RX_GAIN_NF_B0__GAIN_VAL_AFTER_NF_0__READ(src) \
                    (u_int32_t)(src)\
                    & 0x0001ffffU
#define RX_GAIN_NF_B0__TYPE                                           u_int32_t
#define RX_GAIN_NF_B0__READ                                         0x0001ffffU

#endif /* __RX_GAIN_NF_B0_MACRO__ */


/* macros for bb_reg_map.bb_agc_reg_map.BB_rx_gain_nf_b0 */
#define INST_BB_REG_MAP__BB_AGC_REG_MAP__BB_RX_GAIN_NF_B0__NUM                1

/* macros for BlueprintGlobalNameSpace::bbb_sig_detect */
#ifndef __BBB_SIG_DETECT_MACRO__
#define __BBB_SIG_DETECT_MACRO__

/* macros for field agcreg_channel_freq */
#define BBB_SIG_DETECT__AGCREG_CHANNEL_FREQ__SHIFT                            0
#define BBB_SIG_DETECT__AGCREG_CHANNEL_FREQ__WIDTH                           13
#define BBB_SIG_DETECT__AGCREG_CHANNEL_FREQ__MASK                   0x00001fffU
#define BBB_SIG_DETECT__AGCREG_CHANNEL_FREQ__READ(src) \
                    (u_int32_t)(src)\
                    & 0x00001fffU

/* macros for field ant_switch_time */
#define BBB_SIG_DETECT__ANT_SWITCH_TIME__SHIFT                               13
#define BBB_SIG_DETECT__ANT_SWITCH_TIME__WIDTH                                7
#define BBB_SIG_DETECT__ANT_SWITCH_TIME__MASK                       0x000fe000U
#define BBB_SIG_DETECT__ANT_SWITCH_TIME__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x000fe000U) >> 13)
#define BBB_SIG_DETECT__ANT_SWITCH_TIME__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 13) & 0x000fe000U)
#define BBB_SIG_DETECT__ANT_SWITCH_TIME__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000fe000U) | (((u_int32_t)(src) <<\
                    13) & 0x000fe000U)
#define BBB_SIG_DETECT__ANT_SWITCH_TIME__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 13) & ~0x000fe000U)))

/* macros for field cyc32_coarse_dc_est_cck */
#define BBB_SIG_DETECT__CYC32_COARSE_DC_EST_CCK__SHIFT                       20
#define BBB_SIG_DETECT__CYC32_COARSE_DC_EST_CCK__WIDTH                        1
#define BBB_SIG_DETECT__CYC32_COARSE_DC_EST_CCK__MASK               0x00100000U
#define BBB_SIG_DETECT__CYC32_COARSE_DC_EST_CCK__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00100000U) >> 20)
#define BBB_SIG_DETECT__CYC32_COARSE_DC_EST_CCK__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00100000U) | ((u_int32_t)(1) << 20)
#define BBB_SIG_DETECT__CYC32_COARSE_DC_EST_CCK__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00100000U) | ((u_int32_t)(0) << 20)

/* macros for field cyc64_coarse_dc_est_cck */
#define BBB_SIG_DETECT__CYC64_COARSE_DC_EST_CCK__SHIFT                       21
#define BBB_SIG_DETECT__CYC64_COARSE_DC_EST_CCK__WIDTH                        1
#define BBB_SIG_DETECT__CYC64_COARSE_DC_EST_CCK__MASK               0x00200000U
#define BBB_SIG_DETECT__CYC64_COARSE_DC_EST_CCK__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00200000U) >> 21)
#define BBB_SIG_DETECT__CYC64_COARSE_DC_EST_CCK__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00200000U) | ((u_int32_t)(1) << 21)
#define BBB_SIG_DETECT__CYC64_COARSE_DC_EST_CCK__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00200000U) | ((u_int32_t)(0) << 21)

/* macros for field enable_coarse_dc_cck */
#define BBB_SIG_DETECT__ENABLE_COARSE_DC_CCK__SHIFT                          22
#define BBB_SIG_DETECT__ENABLE_COARSE_DC_CCK__WIDTH                           1
#define BBB_SIG_DETECT__ENABLE_COARSE_DC_CCK__MASK                  0x00400000U
#define BBB_SIG_DETECT__ENABLE_COARSE_DC_CCK__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00400000U) >> 22)
#define BBB_SIG_DETECT__ENABLE_COARSE_DC_CCK__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00400000U) | ((u_int32_t)(1) << 22)
#define BBB_SIG_DETECT__ENABLE_COARSE_DC_CCK__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00400000U) | ((u_int32_t)(0) << 22)

/* macros for field cyc256_fine_dc_est_cck */
#define BBB_SIG_DETECT__CYC256_FINE_DC_EST_CCK__SHIFT                        23
#define BBB_SIG_DETECT__CYC256_FINE_DC_EST_CCK__WIDTH                         1
#define BBB_SIG_DETECT__CYC256_FINE_DC_EST_CCK__MASK                0x00800000U
#define BBB_SIG_DETECT__CYC256_FINE_DC_EST_CCK__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00800000U) >> 23)
#define BBB_SIG_DETECT__CYC256_FINE_DC_EST_CCK__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00800000U) | ((u_int32_t)(1) << 23)
#define BBB_SIG_DETECT__CYC256_FINE_DC_EST_CCK__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00800000U) | ((u_int32_t)(0) << 23)

/* macros for field enable_fine_dc_cck */
#define BBB_SIG_DETECT__ENABLE_FINE_DC_CCK__SHIFT                            24
#define BBB_SIG_DETECT__ENABLE_FINE_DC_CCK__WIDTH                             1
#define BBB_SIG_DETECT__ENABLE_FINE_DC_CCK__MASK                    0x01000000U
#define BBB_SIG_DETECT__ENABLE_FINE_DC_CCK__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x01000000U) >> 24)
#define BBB_SIG_DETECT__ENABLE_FINE_DC_CCK__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x01000000U) | ((u_int32_t)(1) << 24)
#define BBB_SIG_DETECT__ENABLE_FINE_DC_CCK__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x01000000U) | ((u_int32_t)(0) << 24)

/* macros for field delay_start_sync_cck */
#define BBB_SIG_DETECT__DELAY_START_SYNC_CCK__SHIFT                          25
#define BBB_SIG_DETECT__DELAY_START_SYNC_CCK__WIDTH                           1
#define BBB_SIG_DETECT__DELAY_START_SYNC_CCK__MASK                  0x02000000U
#define BBB_SIG_DETECT__DELAY_START_SYNC_CCK__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x02000000U) >> 25)
#define BBB_SIG_DETECT__DELAY_START_SYNC_CCK__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x02000000U) | ((u_int32_t)(1) << 25)
#define BBB_SIG_DETECT__DELAY_START_SYNC_CCK__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x02000000U) | ((u_int32_t)(0) << 25)

/* macros for field use_dc_est_during_srch */
#define BBB_SIG_DETECT__USE_DC_EST_DURING_SRCH__SHIFT                        26
#define BBB_SIG_DETECT__USE_DC_EST_DURING_SRCH__WIDTH                         1
#define BBB_SIG_DETECT__USE_DC_EST_DURING_SRCH__MASK                0x04000000U
#define BBB_SIG_DETECT__USE_DC_EST_DURING_SRCH__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x04000000U) >> 26)
#define BBB_SIG_DETECT__USE_DC_EST_DURING_SRCH__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 26) & 0x04000000U)
#define BBB_SIG_DETECT__USE_DC_EST_DURING_SRCH__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x04000000U) | (((u_int32_t)(src) <<\
                    26) & 0x04000000U)
#define BBB_SIG_DETECT__USE_DC_EST_DURING_SRCH__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 26) & ~0x04000000U)))
#define BBB_SIG_DETECT__USE_DC_EST_DURING_SRCH__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x04000000U) | ((u_int32_t)(1) << 26)
#define BBB_SIG_DETECT__USE_DC_EST_DURING_SRCH__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x04000000U) | ((u_int32_t)(0) << 26)

/* macros for field start_dcoff_priority_cck */
#define BBB_SIG_DETECT__START_DCOFF_PRIORITY_CCK__SHIFT                      27
#define BBB_SIG_DETECT__START_DCOFF_PRIORITY_CCK__WIDTH                       1
#define BBB_SIG_DETECT__START_DCOFF_PRIORITY_CCK__MASK              0x08000000U
#define BBB_SIG_DETECT__START_DCOFF_PRIORITY_CCK__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x08000000U) >> 27)
#define BBB_SIG_DETECT__START_DCOFF_PRIORITY_CCK__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x08000000U) | ((u_int32_t)(1) << 27)
#define BBB_SIG_DETECT__START_DCOFF_PRIORITY_CCK__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x08000000U) | ((u_int32_t)(0) << 27)

/* macros for field delay_start_spur_cck */
#define BBB_SIG_DETECT__DELAY_START_SPUR_CCK__SHIFT                          28
#define BBB_SIG_DETECT__DELAY_START_SPUR_CCK__WIDTH                           1
#define BBB_SIG_DETECT__DELAY_START_SPUR_CCK__MASK                  0x10000000U
#define BBB_SIG_DETECT__DELAY_START_SPUR_CCK__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x10000000U) >> 28)
#define BBB_SIG_DETECT__DELAY_START_SPUR_CCK__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x10000000U) | ((u_int32_t)(1) << 28)
#define BBB_SIG_DETECT__DELAY_START_SPUR_CCK__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x10000000U) | ((u_int32_t)(0) << 28)

/* macros for field delay_start_dcoff_cck */
#define BBB_SIG_DETECT__DELAY_START_DCOFF_CCK__SHIFT                         29
#define BBB_SIG_DETECT__DELAY_START_DCOFF_CCK__WIDTH                          1
#define BBB_SIG_DETECT__DELAY_START_DCOFF_CCK__MASK                 0x20000000U
#define BBB_SIG_DETECT__DELAY_START_DCOFF_CCK__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x20000000U) >> 29)
#define BBB_SIG_DETECT__DELAY_START_DCOFF_CCK__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x20000000U) | ((u_int32_t)(1) << 29)
#define BBB_SIG_DETECT__DELAY_START_DCOFF_CCK__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x20000000U) | ((u_int32_t)(0) << 29)

/* macros for field ena_dc_est_bcorr */
#define BBB_SIG_DETECT__ENA_DC_EST_BCORR__SHIFT                              30
#define BBB_SIG_DETECT__ENA_DC_EST_BCORR__WIDTH                               1
#define BBB_SIG_DETECT__ENA_DC_EST_BCORR__MASK                      0x40000000U
#define BBB_SIG_DETECT__ENA_DC_EST_BCORR__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x40000000U) >> 30)
#define BBB_SIG_DETECT__ENA_DC_EST_BCORR__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x40000000U) | ((u_int32_t)(1) << 30)
#define BBB_SIG_DETECT__ENA_DC_EST_BCORR__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x40000000U) | ((u_int32_t)(0) << 30)

/* macros for field disable_str_chain_sel_cck */
#define BBB_SIG_DETECT__DISABLE_STR_CHAIN_SEL_CCK__SHIFT                     31
#define BBB_SIG_DETECT__DISABLE_STR_CHAIN_SEL_CCK__WIDTH                      1
#define BBB_SIG_DETECT__DISABLE_STR_CHAIN_SEL_CCK__MASK             0x80000000U
#define BBB_SIG_DETECT__DISABLE_STR_CHAIN_SEL_CCK__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x80000000U) >> 31)
#define BBB_SIG_DETECT__DISABLE_STR_CHAIN_SEL_CCK__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x80000000U) | ((u_int32_t)(1) << 31)
#define BBB_SIG_DETECT__DISABLE_STR_CHAIN_SEL_CCK__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x80000000U) | ((u_int32_t)(0) << 31)
#define BBB_SIG_DETECT__TYPE                                          u_int32_t
#define BBB_SIG_DETECT__READ                                        0xffffffffU
#define BBB_SIG_DETECT__WRITE                                       0xffffffffU

#endif /* __BBB_SIG_DETECT_MACRO__ */


/* macros for bb_reg_map.bb_agc_reg_map.BB_bbb_sig_detect */
#define INST_BB_REG_MAP__BB_AGC_REG_MAP__BB_BBB_SIG_DETECT__NUM               1

/* macros for BlueprintGlobalNameSpace::bbb_dagc_ctrl */
#ifndef __BBB_DAGC_CTRL_MACRO__
#define __BBB_DAGC_CTRL_MACRO__

/* macros for field enable_dagc_cck */
#define BBB_DAGC_CTRL__ENABLE_DAGC_CCK__SHIFT                                 0
#define BBB_DAGC_CTRL__ENABLE_DAGC_CCK__WIDTH                                 1
#define BBB_DAGC_CTRL__ENABLE_DAGC_CCK__MASK                        0x00000001U
#define BBB_DAGC_CTRL__ENABLE_DAGC_CCK__READ(src) \
                    (u_int32_t)(src)\
                    & 0x00000001U
#define BBB_DAGC_CTRL__ENABLE_DAGC_CCK__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(1)
#define BBB_DAGC_CTRL__ENABLE_DAGC_CCK__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(0)

/* macros for field dagc_target_pwr_cck */
#define BBB_DAGC_CTRL__DAGC_TARGET_PWR_CCK__SHIFT                             1
#define BBB_DAGC_CTRL__DAGC_TARGET_PWR_CCK__WIDTH                             8
#define BBB_DAGC_CTRL__DAGC_TARGET_PWR_CCK__MASK                    0x000001feU
#define BBB_DAGC_CTRL__DAGC_TARGET_PWR_CCK__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x000001feU) >> 1)

/* macros for field enable_barker_rssi_thr */
#define BBB_DAGC_CTRL__ENABLE_BARKER_RSSI_THR__SHIFT                          9
#define BBB_DAGC_CTRL__ENABLE_BARKER_RSSI_THR__WIDTH                          1
#define BBB_DAGC_CTRL__ENABLE_BARKER_RSSI_THR__MASK                 0x00000200U
#define BBB_DAGC_CTRL__ENABLE_BARKER_RSSI_THR__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000200U) >> 9)
#define BBB_DAGC_CTRL__ENABLE_BARKER_RSSI_THR__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000200U) | ((u_int32_t)(1) << 9)
#define BBB_DAGC_CTRL__ENABLE_BARKER_RSSI_THR__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000200U) | ((u_int32_t)(0) << 9)

/* macros for field barker_rssi_thr */
#define BBB_DAGC_CTRL__BARKER_RSSI_THR__SHIFT                                10
#define BBB_DAGC_CTRL__BARKER_RSSI_THR__WIDTH                                 7
#define BBB_DAGC_CTRL__BARKER_RSSI_THR__MASK                        0x0001fc00U
#define BBB_DAGC_CTRL__BARKER_RSSI_THR__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0001fc00U) >> 10)

/* macros for field enable_firstep_sel */
#define BBB_DAGC_CTRL__ENABLE_FIRSTEP_SEL__SHIFT                             17
#define BBB_DAGC_CTRL__ENABLE_FIRSTEP_SEL__WIDTH                              1
#define BBB_DAGC_CTRL__ENABLE_FIRSTEP_SEL__MASK                     0x00020000U
#define BBB_DAGC_CTRL__ENABLE_FIRSTEP_SEL__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00020000U) >> 17)
#define BBB_DAGC_CTRL__ENABLE_FIRSTEP_SEL__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 17) & 0x00020000U)
#define BBB_DAGC_CTRL__ENABLE_FIRSTEP_SEL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00020000U) | (((u_int32_t)(src) <<\
                    17) & 0x00020000U)
#define BBB_DAGC_CTRL__ENABLE_FIRSTEP_SEL__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 17) & ~0x00020000U)))
#define BBB_DAGC_CTRL__ENABLE_FIRSTEP_SEL__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00020000U) | ((u_int32_t)(1) << 17)
#define BBB_DAGC_CTRL__ENABLE_FIRSTEP_SEL__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00020000U) | ((u_int32_t)(0) << 17)

/* macros for field firstep_2 */
#define BBB_DAGC_CTRL__FIRSTEP_2__SHIFT                                      18
#define BBB_DAGC_CTRL__FIRSTEP_2__WIDTH                                       6
#define BBB_DAGC_CTRL__FIRSTEP_2__MASK                              0x00fc0000U
#define BBB_DAGC_CTRL__FIRSTEP_2__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00fc0000U) >> 18)
#define BBB_DAGC_CTRL__FIRSTEP_2__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 18) & 0x00fc0000U)
#define BBB_DAGC_CTRL__FIRSTEP_2__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00fc0000U) | (((u_int32_t)(src) <<\
                    18) & 0x00fc0000U)
#define BBB_DAGC_CTRL__FIRSTEP_2__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 18) & ~0x00fc0000U)))

/* macros for field firstep_count_lgmax */
#define BBB_DAGC_CTRL__FIRSTEP_COUNT_LGMAX__SHIFT                            24
#define BBB_DAGC_CTRL__FIRSTEP_COUNT_LGMAX__WIDTH                             4
#define BBB_DAGC_CTRL__FIRSTEP_COUNT_LGMAX__MASK                    0x0f000000U
#define BBB_DAGC_CTRL__FIRSTEP_COUNT_LGMAX__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0f000000U) >> 24)
#define BBB_DAGC_CTRL__FIRSTEP_COUNT_LGMAX__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 24) & 0x0f000000U)
#define BBB_DAGC_CTRL__FIRSTEP_COUNT_LGMAX__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0f000000U) | (((u_int32_t)(src) <<\
                    24) & 0x0f000000U)
#define BBB_DAGC_CTRL__FIRSTEP_COUNT_LGMAX__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 24) & ~0x0f000000U)))

/* macros for field rxb_det_strong_chn_default */
#define BBB_DAGC_CTRL__RXB_DET_STRONG_CHN_DEFAULT__SHIFT                     28
#define BBB_DAGC_CTRL__RXB_DET_STRONG_CHN_DEFAULT__WIDTH                      2
#define BBB_DAGC_CTRL__RXB_DET_STRONG_CHN_DEFAULT__MASK             0x30000000U
#define BBB_DAGC_CTRL__RXB_DET_STRONG_CHN_DEFAULT__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x30000000U) >> 28)

/* macros for field bk_in_scale_coarse */
#define BBB_DAGC_CTRL__BK_IN_SCALE_COARSE__SHIFT                             30
#define BBB_DAGC_CTRL__BK_IN_SCALE_COARSE__WIDTH                              2
#define BBB_DAGC_CTRL__BK_IN_SCALE_COARSE__MASK                     0xc0000000U
#define BBB_DAGC_CTRL__BK_IN_SCALE_COARSE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0xc0000000U) >> 30)
#define BBB_DAGC_CTRL__TYPE                                           u_int32_t
#define BBB_DAGC_CTRL__READ                                         0xffffffffU
#define BBB_DAGC_CTRL__WRITE                                        0xffffffffU

#endif /* __BBB_DAGC_CTRL_MACRO__ */


/* macros for bb_reg_map.bb_agc_reg_map.BB_bbb_dagc_ctrl */
#define INST_BB_REG_MAP__BB_AGC_REG_MAP__BB_BBB_DAGC_CTRL__NUM                1

/* macros for BlueprintGlobalNameSpace::iqcorr_ctrl_cck */
#ifndef __IQCORR_CTRL_CCK_MACRO__
#define __IQCORR_CTRL_CCK_MACRO__

/* macros for field rxcal_meas_time_sel */
#define IQCORR_CTRL_CCK__RXCAL_MEAS_TIME_SEL__SHIFT                          12
#define IQCORR_CTRL_CCK__RXCAL_MEAS_TIME_SEL__WIDTH                           2
#define IQCORR_CTRL_CCK__RXCAL_MEAS_TIME_SEL__MASK                  0x00003000U
#define IQCORR_CTRL_CCK__RXCAL_MEAS_TIME_SEL__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00003000U) >> 12)
#define IQCORR_CTRL_CCK__RXCAL_MEAS_TIME_SEL__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 12) & 0x00003000U)
#define IQCORR_CTRL_CCK__RXCAL_MEAS_TIME_SEL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00003000U) | (((u_int32_t)(src) <<\
                    12) & 0x00003000U)
#define IQCORR_CTRL_CCK__RXCAL_MEAS_TIME_SEL__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 12) & ~0x00003000U)))

/* macros for field clcal_meas_time_sel */
#define IQCORR_CTRL_CCK__CLCAL_MEAS_TIME_SEL__SHIFT                          14
#define IQCORR_CTRL_CCK__CLCAL_MEAS_TIME_SEL__WIDTH                           2
#define IQCORR_CTRL_CCK__CLCAL_MEAS_TIME_SEL__MASK                  0x0000c000U
#define IQCORR_CTRL_CCK__CLCAL_MEAS_TIME_SEL__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0000c000U) >> 14)
#define IQCORR_CTRL_CCK__CLCAL_MEAS_TIME_SEL__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 14) & 0x0000c000U)
#define IQCORR_CTRL_CCK__CLCAL_MEAS_TIME_SEL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000c000U) | (((u_int32_t)(src) <<\
                    14) & 0x0000c000U)
#define IQCORR_CTRL_CCK__CLCAL_MEAS_TIME_SEL__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 14) & ~0x0000c000U)))

/* macros for field cf_clc_init_rfgain */
#define IQCORR_CTRL_CCK__CF_CLC_INIT_RFGAIN__SHIFT                           16
#define IQCORR_CTRL_CCK__CF_CLC_INIT_RFGAIN__WIDTH                            5
#define IQCORR_CTRL_CCK__CF_CLC_INIT_RFGAIN__MASK                   0x001f0000U
#define IQCORR_CTRL_CCK__CF_CLC_INIT_RFGAIN__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x001f0000U) >> 16)
#define IQCORR_CTRL_CCK__CF_CLC_INIT_RFGAIN__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 16) & 0x001f0000U)
#define IQCORR_CTRL_CCK__CF_CLC_INIT_RFGAIN__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x001f0000U) | (((u_int32_t)(src) <<\
                    16) & 0x001f0000U)
#define IQCORR_CTRL_CCK__CF_CLC_INIT_RFGAIN__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 16) & ~0x001f0000U)))
#define IQCORR_CTRL_CCK__TYPE                                         u_int32_t
#define IQCORR_CTRL_CCK__READ                                       0x001ff000U
#define IQCORR_CTRL_CCK__WRITE                                      0x001ff000U

#endif /* __IQCORR_CTRL_CCK_MACRO__ */


/* macros for bb_reg_map.bb_agc_reg_map.BB_iqcorr_ctrl_cck */
#define INST_BB_REG_MAP__BB_AGC_REG_MAP__BB_IQCORR_CTRL_CCK__NUM              1

/* macros for BlueprintGlobalNameSpace::cck_spur_mit */
#ifndef __CCK_SPUR_MIT_MACRO__
#define __CCK_SPUR_MIT_MACRO__

/* macros for field use_cck_spur_mit */
#define CCK_SPUR_MIT__USE_CCK_SPUR_MIT__SHIFT                                 0
#define CCK_SPUR_MIT__USE_CCK_SPUR_MIT__WIDTH                                 1
#define CCK_SPUR_MIT__USE_CCK_SPUR_MIT__MASK                        0x00000001U
#define CCK_SPUR_MIT__USE_CCK_SPUR_MIT__READ(src) \
                    (u_int32_t)(src)\
                    & 0x00000001U
#define CCK_SPUR_MIT__USE_CCK_SPUR_MIT__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(1)
#define CCK_SPUR_MIT__USE_CCK_SPUR_MIT__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(0)

/* macros for field spur_rssi_thr */
#define CCK_SPUR_MIT__SPUR_RSSI_THR__SHIFT                                    1
#define CCK_SPUR_MIT__SPUR_RSSI_THR__WIDTH                                    8
#define CCK_SPUR_MIT__SPUR_RSSI_THR__MASK                           0x000001feU
#define CCK_SPUR_MIT__SPUR_RSSI_THR__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x000001feU) >> 1)

/* macros for field cck_spur_freq */
#define CCK_SPUR_MIT__CCK_SPUR_FREQ__SHIFT                                    9
#define CCK_SPUR_MIT__CCK_SPUR_FREQ__WIDTH                                   20
#define CCK_SPUR_MIT__CCK_SPUR_FREQ__MASK                           0x1ffffe00U
#define CCK_SPUR_MIT__CCK_SPUR_FREQ__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x1ffffe00U) >> 9)

/* macros for field spur_filter_type */
#define CCK_SPUR_MIT__SPUR_FILTER_TYPE__SHIFT                                29
#define CCK_SPUR_MIT__SPUR_FILTER_TYPE__WIDTH                                 2
#define CCK_SPUR_MIT__SPUR_FILTER_TYPE__MASK                        0x60000000U
#define CCK_SPUR_MIT__SPUR_FILTER_TYPE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x60000000U) >> 29)
#define CCK_SPUR_MIT__TYPE                                            u_int32_t
#define CCK_SPUR_MIT__READ                                          0x7fffffffU

#endif /* __CCK_SPUR_MIT_MACRO__ */


/* macros for bb_reg_map.bb_agc_reg_map.BB_cck_spur_mit */
#define INST_BB_REG_MAP__BB_AGC_REG_MAP__BB_CCK_SPUR_MIT__NUM                 1

/* macros for BlueprintGlobalNameSpace::mrc_cck_ctrl */
#ifndef __MRC_CCK_CTRL_MACRO__
#define __MRC_CCK_CTRL_MACRO__

/* macros for field agcreg_c11b */
#define MRC_CCK_CTRL__AGCREG_C11B__SHIFT                                      0
#define MRC_CCK_CTRL__AGCREG_C11B__WIDTH                                      8
#define MRC_CCK_CTRL__AGCREG_C11B__MASK                             0x000000ffU
#define MRC_CCK_CTRL__AGCREG_C11B__READ(src)     (u_int32_t)(src) & 0x000000ffU

/* macros for field agcreg_c11bp */
#define MRC_CCK_CTRL__AGCREG_C11BP__SHIFT                                     8
#define MRC_CCK_CTRL__AGCREG_C11BP__WIDTH                                     8
#define MRC_CCK_CTRL__AGCREG_C11BP__MASK                            0x0000ff00U
#define MRC_CCK_CTRL__AGCREG_C11BP__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0000ff00U) >> 8)

/* macros for field agcreg_th_d0_b */
#define MRC_CCK_CTRL__AGCREG_TH_D0_B__SHIFT                                  16
#define MRC_CCK_CTRL__AGCREG_TH_D0_B__WIDTH                                   8
#define MRC_CCK_CTRL__AGCREG_TH_D0_B__MASK                          0x00ff0000U
#define MRC_CCK_CTRL__AGCREG_TH_D0_B__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00ff0000U) >> 16)

/* macros for field agcreg_th_d0_b_tf_est */
#define MRC_CCK_CTRL__AGCREG_TH_D0_B_TF_EST__SHIFT                           24
#define MRC_CCK_CTRL__AGCREG_TH_D0_B_TF_EST__WIDTH                            8
#define MRC_CCK_CTRL__AGCREG_TH_D0_B_TF_EST__MASK                   0xff000000U
#define MRC_CCK_CTRL__AGCREG_TH_D0_B_TF_EST__READ(src) \
                    (((u_int32_t)(src)\
                    & 0xff000000U) >> 24)
#define MRC_CCK_CTRL__TYPE                                            u_int32_t
#define MRC_CCK_CTRL__READ                                          0xffffffffU

#endif /* __MRC_CCK_CTRL_MACRO__ */


/* macros for bb_reg_map.bb_agc_reg_map.BB_mrc_cck_ctrl */
#define INST_BB_REG_MAP__BB_AGC_REG_MAP__BB_MRC_CCK_CTRL__NUM                 1

/* macros for BlueprintGlobalNameSpace::cck_blocker_det */
#ifndef __CCK_BLOCKER_DET_MACRO__
#define __CCK_BLOCKER_DET_MACRO__

/* macros for field cck_freq_shift_blocker_detection */
#define CCK_BLOCKER_DET__CCK_FREQ_SHIFT_BLOCKER_DETECTION__SHIFT              0
#define CCK_BLOCKER_DET__CCK_FREQ_SHIFT_BLOCKER_DETECTION__WIDTH              1
#define CCK_BLOCKER_DET__CCK_FREQ_SHIFT_BLOCKER_DETECTION__MASK     0x00000001U
#define CCK_BLOCKER_DET__CCK_FREQ_SHIFT_BLOCKER_DETECTION__READ(src) \
                    (u_int32_t)(src)\
                    & 0x00000001U
#define CCK_BLOCKER_DET__CCK_FREQ_SHIFT_BLOCKER_DETECTION__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(1)
#define CCK_BLOCKER_DET__CCK_FREQ_SHIFT_BLOCKER_DETECTION__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(0)

/* macros for field cck_blocker_det_restart_weak_sig */
#define CCK_BLOCKER_DET__CCK_BLOCKER_DET_RESTART_WEAK_SIG__SHIFT              1
#define CCK_BLOCKER_DET__CCK_BLOCKER_DET_RESTART_WEAK_SIG__WIDTH              1
#define CCK_BLOCKER_DET__CCK_BLOCKER_DET_RESTART_WEAK_SIG__MASK     0x00000002U
#define CCK_BLOCKER_DET__CCK_BLOCKER_DET_RESTART_WEAK_SIG__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000002U) >> 1)
#define CCK_BLOCKER_DET__CCK_BLOCKER_DET_RESTART_WEAK_SIG__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | ((u_int32_t)(1) << 1)
#define CCK_BLOCKER_DET__CCK_BLOCKER_DET_RESTART_WEAK_SIG__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | ((u_int32_t)(0) << 1)

/* macros for field cck_blocker_det_bksum_num */
#define CCK_BLOCKER_DET__CCK_BLOCKER_DET_BKSUM_NUM__SHIFT                     2
#define CCK_BLOCKER_DET__CCK_BLOCKER_DET_BKSUM_NUM__WIDTH                     4
#define CCK_BLOCKER_DET__CCK_BLOCKER_DET_BKSUM_NUM__MASK            0x0000003cU
#define CCK_BLOCKER_DET__CCK_BLOCKER_DET_BKSUM_NUM__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0000003cU) >> 2)

/* macros for field bk_valid_delay */
#define CCK_BLOCKER_DET__BK_VALID_DELAY__SHIFT                                6
#define CCK_BLOCKER_DET__BK_VALID_DELAY__WIDTH                                3
#define CCK_BLOCKER_DET__BK_VALID_DELAY__MASK                       0x000001c0U
#define CCK_BLOCKER_DET__BK_VALID_DELAY__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x000001c0U) >> 6)

/* macros for field cck_blocker_det_thr */
#define CCK_BLOCKER_DET__CCK_BLOCKER_DET_THR__SHIFT                           9
#define CCK_BLOCKER_DET__CCK_BLOCKER_DET_THR__WIDTH                           5
#define CCK_BLOCKER_DET__CCK_BLOCKER_DET_THR__MASK                  0x00003e00U
#define CCK_BLOCKER_DET__CCK_BLOCKER_DET_THR__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00003e00U) >> 9)

/* macros for field cck_blocker_det_delay_thr */
#define CCK_BLOCKER_DET__CCK_BLOCKER_DET_DELAY_THR__SHIFT                    14
#define CCK_BLOCKER_DET__CCK_BLOCKER_DET_DELAY_THR__WIDTH                     6
#define CCK_BLOCKER_DET__CCK_BLOCKER_DET_DELAY_THR__MASK            0x000fc000U
#define CCK_BLOCKER_DET__CCK_BLOCKER_DET_DELAY_THR__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x000fc000U) >> 14)

/* macros for field cck_blocker_monitor_time */
#define CCK_BLOCKER_DET__CCK_BLOCKER_MONITOR_TIME__SHIFT                     20
#define CCK_BLOCKER_DET__CCK_BLOCKER_MONITOR_TIME__WIDTH                      6
#define CCK_BLOCKER_DET__CCK_BLOCKER_MONITOR_TIME__MASK             0x03f00000U
#define CCK_BLOCKER_DET__CCK_BLOCKER_MONITOR_TIME__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x03f00000U) >> 20)

/* macros for field skip_ramp_enable */
#define CCK_BLOCKER_DET__SKIP_RAMP_ENABLE__SHIFT                             26
#define CCK_BLOCKER_DET__SKIP_RAMP_ENABLE__WIDTH                              1
#define CCK_BLOCKER_DET__SKIP_RAMP_ENABLE__MASK                     0x04000000U
#define CCK_BLOCKER_DET__SKIP_RAMP_ENABLE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x04000000U) >> 26)
#define CCK_BLOCKER_DET__SKIP_RAMP_ENABLE__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 26) & 0x04000000U)
#define CCK_BLOCKER_DET__SKIP_RAMP_ENABLE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x04000000U) | (((u_int32_t)(src) <<\
                    26) & 0x04000000U)
#define CCK_BLOCKER_DET__SKIP_RAMP_ENABLE__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 26) & ~0x04000000U)))
#define CCK_BLOCKER_DET__SKIP_RAMP_ENABLE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x04000000U) | ((u_int32_t)(1) << 26)
#define CCK_BLOCKER_DET__SKIP_RAMP_ENABLE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x04000000U) | ((u_int32_t)(0) << 26)

/* macros for field cck_det_ramp_thr */
#define CCK_BLOCKER_DET__CCK_DET_RAMP_THR__SHIFT                             27
#define CCK_BLOCKER_DET__CCK_DET_RAMP_THR__WIDTH                              5
#define CCK_BLOCKER_DET__CCK_DET_RAMP_THR__MASK                     0xf8000000U
#define CCK_BLOCKER_DET__CCK_DET_RAMP_THR__READ(src) \
                    (((u_int32_t)(src)\
                    & 0xf8000000U) >> 27)
#define CCK_BLOCKER_DET__TYPE                                         u_int32_t
#define CCK_BLOCKER_DET__READ                                       0xffffffffU
#define CCK_BLOCKER_DET__WRITE                                      0xffffffffU

#endif /* __CCK_BLOCKER_DET_MACRO__ */


/* macros for bb_reg_map.bb_agc_reg_map.BB_cck_blocker_det */
#define INST_BB_REG_MAP__BB_AGC_REG_MAP__BB_CCK_BLOCKER_DET__NUM              1

/* macros for BlueprintGlobalNameSpace::bk_corr_settings */
#ifndef __BK_CORR_SETTINGS_MACRO__
#define __BK_CORR_SETTINGS_MACRO__

/* macros for field bk_in_min_backoff */
#define BK_CORR_SETTINGS__BK_IN_MIN_BACKOFF__SHIFT                            0
#define BK_CORR_SETTINGS__BK_IN_MIN_BACKOFF__WIDTH                            8
#define BK_CORR_SETTINGS__BK_IN_MIN_BACKOFF__MASK                   0x000000ffU
#define BK_CORR_SETTINGS__BK_IN_MIN_BACKOFF__READ(src) \
                    (u_int32_t)(src)\
                    & 0x000000ffU
#define BK_CORR_SETTINGS__BK_IN_MIN_BACKOFF__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x000000ffU)
#define BK_CORR_SETTINGS__BK_IN_MIN_BACKOFF__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000000ffU) | ((u_int32_t)(src) &\
                    0x000000ffU)
#define BK_CORR_SETTINGS__BK_IN_MIN_BACKOFF__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x000000ffU)))

/* macros for field bk_in_backoff */
#define BK_CORR_SETTINGS__BK_IN_BACKOFF__SHIFT                                8
#define BK_CORR_SETTINGS__BK_IN_BACKOFF__WIDTH                                8
#define BK_CORR_SETTINGS__BK_IN_BACKOFF__MASK                       0x0000ff00U
#define BK_CORR_SETTINGS__BK_IN_BACKOFF__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0000ff00U) >> 8)
#define BK_CORR_SETTINGS__BK_IN_BACKOFF__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 8) & 0x0000ff00U)
#define BK_CORR_SETTINGS__BK_IN_BACKOFF__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000ff00U) | (((u_int32_t)(src) <<\
                    8) & 0x0000ff00U)
#define BK_CORR_SETTINGS__BK_IN_BACKOFF__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 8) & ~0x0000ff00U)))

/* macros for field bk_in_scale_tf */
#define BK_CORR_SETTINGS__BK_IN_SCALE_TF__SHIFT                              16
#define BK_CORR_SETTINGS__BK_IN_SCALE_TF__WIDTH                               3
#define BK_CORR_SETTINGS__BK_IN_SCALE_TF__MASK                      0x00070000U
#define BK_CORR_SETTINGS__BK_IN_SCALE_TF__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00070000U) >> 16)
#define BK_CORR_SETTINGS__BK_IN_SCALE_TF__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 16) & 0x00070000U)
#define BK_CORR_SETTINGS__BK_IN_SCALE_TF__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00070000U) | (((u_int32_t)(src) <<\
                    16) & 0x00070000U)
#define BK_CORR_SETTINGS__BK_IN_SCALE_TF__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 16) & ~0x00070000U)))
#define BK_CORR_SETTINGS__TYPE                                        u_int32_t
#define BK_CORR_SETTINGS__READ                                      0x0007ffffU
#define BK_CORR_SETTINGS__WRITE                                     0x0007ffffU

#endif /* __BK_CORR_SETTINGS_MACRO__ */


/* macros for bb_reg_map.bb_agc_reg_map.BB_bk_corr_settings */
#define INST_BB_REG_MAP__BB_AGC_REG_MAP__BB_BK_CORR_SETTINGS__NUM             1

/* macros for BlueprintGlobalNameSpace::cck_blocker_det2 */
#ifndef __CCK_BLOCKER_DET2_MACRO__
#define __CCK_BLOCKER_DET2_MACRO__

/* macros for field firpwr_str */
#define CCK_BLOCKER_DET2__FIRPWR_STR__SHIFT                                   0
#define CCK_BLOCKER_DET2__FIRPWR_STR__WIDTH                                   8
#define CCK_BLOCKER_DET2__FIRPWR_STR__MASK                          0x000000ffU
#define CCK_BLOCKER_DET2__FIRPWR_STR__READ(src)  (u_int32_t)(src) & 0x000000ffU
#define CCK_BLOCKER_DET2__FIRPWR_STR__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x000000ffU)
#define CCK_BLOCKER_DET2__FIRPWR_STR__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000000ffU) | ((u_int32_t)(src) &\
                    0x000000ffU)
#define CCK_BLOCKER_DET2__FIRPWR_STR__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x000000ffU)))

/* macros for field cckpdp_valid_thr */
#define CCK_BLOCKER_DET2__CCKPDP_VALID_THR__SHIFT                             8
#define CCK_BLOCKER_DET2__CCKPDP_VALID_THR__WIDTH                             3
#define CCK_BLOCKER_DET2__CCKPDP_VALID_THR__MASK                    0x00000700U
#define CCK_BLOCKER_DET2__CCKPDP_VALID_THR__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000700U) >> 8)

/* macros for field disable_m1ok_11b */
#define CCK_BLOCKER_DET2__DISABLE_M1OK_11B__SHIFT                            12
#define CCK_BLOCKER_DET2__DISABLE_M1OK_11B__WIDTH                             1
#define CCK_BLOCKER_DET2__DISABLE_M1OK_11B__MASK                    0x00001000U
#define CCK_BLOCKER_DET2__DISABLE_M1OK_11B__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00001000U) >> 12)
#define CCK_BLOCKER_DET2__DISABLE_M1OK_11B__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00001000U) | ((u_int32_t)(1) << 12)
#define CCK_BLOCKER_DET2__DISABLE_M1OK_11B__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00001000U) | ((u_int32_t)(0) << 12)
#define CCK_BLOCKER_DET2__TYPE                                        u_int32_t
#define CCK_BLOCKER_DET2__READ                                      0x000017ffU
#define CCK_BLOCKER_DET2__WRITE                                     0x000017ffU

#endif /* __CCK_BLOCKER_DET2_MACRO__ */


/* macros for bb_reg_map.bb_agc_reg_map.BB_cck_blocker_det2 */
#define INST_BB_REG_MAP__BB_AGC_REG_MAP__BB_CCK_BLOCKER_DET2__NUM             1

/* macros for BlueprintGlobalNameSpace::detection_mask_cntl */
#ifndef __DETECTION_MASK_CNTL_MACRO__
#define __DETECTION_MASK_CNTL_MACRO__

/* macros for field adcsat_dm_apply */
#define DETECTION_MASK_CNTL__ADCSAT_DM_APPLY__SHIFT                           0
#define DETECTION_MASK_CNTL__ADCSAT_DM_APPLY__WIDTH                           1
#define DETECTION_MASK_CNTL__ADCSAT_DM_APPLY__MASK                  0x00000001U
#define DETECTION_MASK_CNTL__ADCSAT_DM_APPLY__READ(src) \
                    (u_int32_t)(src)\
                    & 0x00000001U
#define DETECTION_MASK_CNTL__ADCSAT_DM_APPLY__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x00000001U)
#define DETECTION_MASK_CNTL__ADCSAT_DM_APPLY__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | ((u_int32_t)(src) &\
                    0x00000001U)
#define DETECTION_MASK_CNTL__ADCSAT_DM_APPLY__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00000001U)))
#define DETECTION_MASK_CNTL__ADCSAT_DM_APPLY__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(1)
#define DETECTION_MASK_CNTL__ADCSAT_DM_APPLY__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(0)

/* macros for field rfsat_dm_apply */
#define DETECTION_MASK_CNTL__RFSAT_DM_APPLY__SHIFT                            1
#define DETECTION_MASK_CNTL__RFSAT_DM_APPLY__WIDTH                            1
#define DETECTION_MASK_CNTL__RFSAT_DM_APPLY__MASK                   0x00000002U
#define DETECTION_MASK_CNTL__RFSAT_DM_APPLY__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000002U) >> 1)
#define DETECTION_MASK_CNTL__RFSAT_DM_APPLY__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 1) & 0x00000002U)
#define DETECTION_MASK_CNTL__RFSAT_DM_APPLY__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | (((u_int32_t)(src) <<\
                    1) & 0x00000002U)
#define DETECTION_MASK_CNTL__RFSAT_DM_APPLY__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 1) & ~0x00000002U)))
#define DETECTION_MASK_CNTL__RFSAT_DM_APPLY__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | ((u_int32_t)(1) << 1)
#define DETECTION_MASK_CNTL__RFSAT_DM_APPLY__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | ((u_int32_t)(0) << 1)

/* macros for field gain_dropped_dm_apply */
#define DETECTION_MASK_CNTL__GAIN_DROPPED_DM_APPLY__SHIFT                     2
#define DETECTION_MASK_CNTL__GAIN_DROPPED_DM_APPLY__WIDTH                     1
#define DETECTION_MASK_CNTL__GAIN_DROPPED_DM_APPLY__MASK            0x00000004U
#define DETECTION_MASK_CNTL__GAIN_DROPPED_DM_APPLY__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000004U) >> 2)
#define DETECTION_MASK_CNTL__GAIN_DROPPED_DM_APPLY__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 2) & 0x00000004U)
#define DETECTION_MASK_CNTL__GAIN_DROPPED_DM_APPLY__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000004U) | (((u_int32_t)(src) <<\
                    2) & 0x00000004U)
#define DETECTION_MASK_CNTL__GAIN_DROPPED_DM_APPLY__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 2) & ~0x00000004U)))
#define DETECTION_MASK_CNTL__GAIN_DROPPED_DM_APPLY__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000004U) | ((u_int32_t)(1) << 2)
#define DETECTION_MASK_CNTL__GAIN_DROPPED_DM_APPLY__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000004U) | ((u_int32_t)(0) << 2)

/* macros for field in_range_dm_apply */
#define DETECTION_MASK_CNTL__IN_RANGE_DM_APPLY__SHIFT                         3
#define DETECTION_MASK_CNTL__IN_RANGE_DM_APPLY__WIDTH                         1
#define DETECTION_MASK_CNTL__IN_RANGE_DM_APPLY__MASK                0x00000008U
#define DETECTION_MASK_CNTL__IN_RANGE_DM_APPLY__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000008U) >> 3)
#define DETECTION_MASK_CNTL__IN_RANGE_DM_APPLY__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 3) & 0x00000008U)
#define DETECTION_MASK_CNTL__IN_RANGE_DM_APPLY__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000008U) | (((u_int32_t)(src) <<\
                    3) & 0x00000008U)
#define DETECTION_MASK_CNTL__IN_RANGE_DM_APPLY__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 3) & ~0x00000008U)))
#define DETECTION_MASK_CNTL__IN_RANGE_DM_APPLY__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000008U) | ((u_int32_t)(1) << 3)
#define DETECTION_MASK_CNTL__IN_RANGE_DM_APPLY__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000008U) | ((u_int32_t)(0) << 3)

/* macros for field m2flag_dm_apply */
#define DETECTION_MASK_CNTL__M2FLAG_DM_APPLY__SHIFT                           4
#define DETECTION_MASK_CNTL__M2FLAG_DM_APPLY__WIDTH                           1
#define DETECTION_MASK_CNTL__M2FLAG_DM_APPLY__MASK                  0x00000010U
#define DETECTION_MASK_CNTL__M2FLAG_DM_APPLY__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000010U) >> 4)
#define DETECTION_MASK_CNTL__M2FLAG_DM_APPLY__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 4) & 0x00000010U)
#define DETECTION_MASK_CNTL__M2FLAG_DM_APPLY__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000010U) | (((u_int32_t)(src) <<\
                    4) & 0x00000010U)
#define DETECTION_MASK_CNTL__M2FLAG_DM_APPLY__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 4) & ~0x00000010U)))
#define DETECTION_MASK_CNTL__M2FLAG_DM_APPLY__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000010U) | ((u_int32_t)(1) << 4)
#define DETECTION_MASK_CNTL__M2FLAG_DM_APPLY__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000010U) | ((u_int32_t)(0) << 4)

/* macros for field flag_relpwr_dm_apply */
#define DETECTION_MASK_CNTL__FLAG_RELPWR_DM_APPLY__SHIFT                      5
#define DETECTION_MASK_CNTL__FLAG_RELPWR_DM_APPLY__WIDTH                      1
#define DETECTION_MASK_CNTL__FLAG_RELPWR_DM_APPLY__MASK             0x00000020U
#define DETECTION_MASK_CNTL__FLAG_RELPWR_DM_APPLY__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000020U) >> 5)
#define DETECTION_MASK_CNTL__FLAG_RELPWR_DM_APPLY__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 5) & 0x00000020U)
#define DETECTION_MASK_CNTL__FLAG_RELPWR_DM_APPLY__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000020U) | (((u_int32_t)(src) <<\
                    5) & 0x00000020U)
#define DETECTION_MASK_CNTL__FLAG_RELPWR_DM_APPLY__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 5) & ~0x00000020U)))
#define DETECTION_MASK_CNTL__FLAG_RELPWR_DM_APPLY__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000020U) | ((u_int32_t)(1) << 5)
#define DETECTION_MASK_CNTL__FLAG_RELPWR_DM_APPLY__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000020U) | ((u_int32_t)(0) << 5)

/* macros for field flag_firpwr_dm_apply */
#define DETECTION_MASK_CNTL__FLAG_FIRPWR_DM_APPLY__SHIFT                      6
#define DETECTION_MASK_CNTL__FLAG_FIRPWR_DM_APPLY__WIDTH                      1
#define DETECTION_MASK_CNTL__FLAG_FIRPWR_DM_APPLY__MASK             0x00000040U
#define DETECTION_MASK_CNTL__FLAG_FIRPWR_DM_APPLY__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000040U) >> 6)
#define DETECTION_MASK_CNTL__FLAG_FIRPWR_DM_APPLY__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 6) & 0x00000040U)
#define DETECTION_MASK_CNTL__FLAG_FIRPWR_DM_APPLY__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000040U) | (((u_int32_t)(src) <<\
                    6) & 0x00000040U)
#define DETECTION_MASK_CNTL__FLAG_FIRPWR_DM_APPLY__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 6) & ~0x00000040U)))
#define DETECTION_MASK_CNTL__FLAG_FIRPWR_DM_APPLY__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000040U) | ((u_int32_t)(1) << 6)
#define DETECTION_MASK_CNTL__FLAG_FIRPWR_DM_APPLY__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000040U) | ((u_int32_t)(0) << 6)

/* macros for field rssi_comb_dm_apply */
#define DETECTION_MASK_CNTL__RSSI_COMB_DM_APPLY__SHIFT                        7
#define DETECTION_MASK_CNTL__RSSI_COMB_DM_APPLY__WIDTH                        1
#define DETECTION_MASK_CNTL__RSSI_COMB_DM_APPLY__MASK               0x00000080U
#define DETECTION_MASK_CNTL__RSSI_COMB_DM_APPLY__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000080U) >> 7)
#define DETECTION_MASK_CNTL__RSSI_COMB_DM_APPLY__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 7) & 0x00000080U)
#define DETECTION_MASK_CNTL__RSSI_COMB_DM_APPLY__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000080U) | (((u_int32_t)(src) <<\
                    7) & 0x00000080U)
#define DETECTION_MASK_CNTL__RSSI_COMB_DM_APPLY__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 7) & ~0x00000080U)))
#define DETECTION_MASK_CNTL__RSSI_COMB_DM_APPLY__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000080U) | ((u_int32_t)(1) << 7)
#define DETECTION_MASK_CNTL__RSSI_COMB_DM_APPLY__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000080U) | ((u_int32_t)(0) << 7)
#define DETECTION_MASK_CNTL__TYPE                                     u_int32_t
#define DETECTION_MASK_CNTL__READ                                   0x000000ffU
#define DETECTION_MASK_CNTL__WRITE                                  0x000000ffU

#endif /* __DETECTION_MASK_CNTL_MACRO__ */


/* macros for bb_reg_map.bb_agc_reg_map.BB_detection_mask_cntl */
#define INST_BB_REG_MAP__BB_AGC_REG_MAP__BB_DETECTION_MASK_CNTL__NUM          1

/* macros for BlueprintGlobalNameSpace::rx_ocgain */
#ifndef __RX_OCGAIN_MACRO__
#define __RX_OCGAIN_MACRO__

/* macros for field gain_entry */
#define RX_OCGAIN__GAIN_ENTRY__SHIFT                                          0
#define RX_OCGAIN__GAIN_ENTRY__WIDTH                                         32
#define RX_OCGAIN__GAIN_ENTRY__MASK                                 0xffffffffU
#define RX_OCGAIN__GAIN_ENTRY__READ(src)         (u_int32_t)(src) & 0xffffffffU
#define RX_OCGAIN__GAIN_ENTRY__WRITE(src)      ((u_int32_t)(src) & 0xffffffffU)
#define RX_OCGAIN__GAIN_ENTRY__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xffffffffU) | ((u_int32_t)(src) &\
                    0xffffffffU)
#define RX_OCGAIN__GAIN_ENTRY__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0xffffffffU)))
#define RX_OCGAIN__TYPE                                               u_int32_t
#define RX_OCGAIN__READ                                             0xffffffffU
#define RX_OCGAIN__WRITE                                            0xffffffffU

#endif /* __RX_OCGAIN_MACRO__ */


/* macros for bb_reg_map.bb_agc_reg_map.BB_rx_ocgain */
#define INST_BB_REG_MAP__BB_AGC_REG_MAP__BB_RX_OCGAIN__NUM                  128

/* macros for BlueprintGlobalNameSpace::timing_controls_1 */
#ifndef __TIMING_CONTROLS_1_MACRO__
#define __TIMING_CONTROLS_1_MACRO__

/* macros for field ste_thr */
#define TIMING_CONTROLS_1__STE_THR__SHIFT                                     0
#define TIMING_CONTROLS_1__STE_THR__WIDTH                                     7
#define TIMING_CONTROLS_1__STE_THR__MASK                            0x0000007fU
#define TIMING_CONTROLS_1__STE_THR__READ(src)    (u_int32_t)(src) & 0x0000007fU
#define TIMING_CONTROLS_1__STE_THR__WRITE(src) ((u_int32_t)(src) & 0x0000007fU)
#define TIMING_CONTROLS_1__STE_THR__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000007fU) | ((u_int32_t)(src) &\
                    0x0000007fU)
#define TIMING_CONTROLS_1__STE_THR__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x0000007fU)))

/* macros for field ste_to_long1 */
#define TIMING_CONTROLS_1__STE_TO_LONG1__SHIFT                                7
#define TIMING_CONTROLS_1__STE_TO_LONG1__WIDTH                                6
#define TIMING_CONTROLS_1__STE_TO_LONG1__MASK                       0x00001f80U
#define TIMING_CONTROLS_1__STE_TO_LONG1__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00001f80U) >> 7)
#define TIMING_CONTROLS_1__STE_TO_LONG1__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 7) & 0x00001f80U)
#define TIMING_CONTROLS_1__STE_TO_LONG1__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00001f80U) | (((u_int32_t)(src) <<\
                    7) & 0x00001f80U)
#define TIMING_CONTROLS_1__STE_TO_LONG1__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 7) & ~0x00001f80U)))

/* macros for field ht_fine_ppm_stream */
#define TIMING_CONTROLS_1__HT_FINE_PPM_STREAM__SHIFT                         18
#define TIMING_CONTROLS_1__HT_FINE_PPM_STREAM__WIDTH                          2
#define TIMING_CONTROLS_1__HT_FINE_PPM_STREAM__MASK                 0x000c0000U
#define TIMING_CONTROLS_1__HT_FINE_PPM_STREAM__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x000c0000U) >> 18)
#define TIMING_CONTROLS_1__HT_FINE_PPM_STREAM__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 18) & 0x000c0000U)
#define TIMING_CONTROLS_1__HT_FINE_PPM_STREAM__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000c0000U) | (((u_int32_t)(src) <<\
                    18) & 0x000c0000U)
#define TIMING_CONTROLS_1__HT_FINE_PPM_STREAM__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 18) & ~0x000c0000U)))

/* macros for field ht_fine_ppm_qam */
#define TIMING_CONTROLS_1__HT_FINE_PPM_QAM__SHIFT                            20
#define TIMING_CONTROLS_1__HT_FINE_PPM_QAM__WIDTH                             2
#define TIMING_CONTROLS_1__HT_FINE_PPM_QAM__MASK                    0x00300000U
#define TIMING_CONTROLS_1__HT_FINE_PPM_QAM__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00300000U) >> 20)
#define TIMING_CONTROLS_1__HT_FINE_PPM_QAM__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 20) & 0x00300000U)
#define TIMING_CONTROLS_1__HT_FINE_PPM_QAM__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00300000U) | (((u_int32_t)(src) <<\
                    20) & 0x00300000U)
#define TIMING_CONTROLS_1__HT_FINE_PPM_QAM__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 20) & ~0x00300000U)))

/* macros for field enable_long_chanfil */
#define TIMING_CONTROLS_1__ENABLE_LONG_CHANFIL__SHIFT                        22
#define TIMING_CONTROLS_1__ENABLE_LONG_CHANFIL__WIDTH                         1
#define TIMING_CONTROLS_1__ENABLE_LONG_CHANFIL__MASK                0x00400000U
#define TIMING_CONTROLS_1__ENABLE_LONG_CHANFIL__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00400000U) >> 22)
#define TIMING_CONTROLS_1__ENABLE_LONG_CHANFIL__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 22) & 0x00400000U)
#define TIMING_CONTROLS_1__ENABLE_LONG_CHANFIL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00400000U) | (((u_int32_t)(src) <<\
                    22) & 0x00400000U)
#define TIMING_CONTROLS_1__ENABLE_LONG_CHANFIL__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 22) & ~0x00400000U)))
#define TIMING_CONTROLS_1__ENABLE_LONG_CHANFIL__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00400000U) | ((u_int32_t)(1) << 22)
#define TIMING_CONTROLS_1__ENABLE_LONG_CHANFIL__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00400000U) | ((u_int32_t)(0) << 22)

/* macros for field enable_rx_stbc */
#define TIMING_CONTROLS_1__ENABLE_RX_STBC__SHIFT                             23
#define TIMING_CONTROLS_1__ENABLE_RX_STBC__WIDTH                              1
#define TIMING_CONTROLS_1__ENABLE_RX_STBC__MASK                     0x00800000U
#define TIMING_CONTROLS_1__ENABLE_RX_STBC__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00800000U) >> 23)
#define TIMING_CONTROLS_1__ENABLE_RX_STBC__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 23) & 0x00800000U)
#define TIMING_CONTROLS_1__ENABLE_RX_STBC__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00800000U) | (((u_int32_t)(src) <<\
                    23) & 0x00800000U)
#define TIMING_CONTROLS_1__ENABLE_RX_STBC__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 23) & ~0x00800000U)))
#define TIMING_CONTROLS_1__ENABLE_RX_STBC__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00800000U) | ((u_int32_t)(1) << 23)
#define TIMING_CONTROLS_1__ENABLE_RX_STBC__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00800000U) | ((u_int32_t)(0) << 23)

/* macros for field enable_channel_filter */
#define TIMING_CONTROLS_1__ENABLE_CHANNEL_FILTER__SHIFT                      24
#define TIMING_CONTROLS_1__ENABLE_CHANNEL_FILTER__WIDTH                       1
#define TIMING_CONTROLS_1__ENABLE_CHANNEL_FILTER__MASK              0x01000000U
#define TIMING_CONTROLS_1__ENABLE_CHANNEL_FILTER__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x01000000U) >> 24)
#define TIMING_CONTROLS_1__ENABLE_CHANNEL_FILTER__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 24) & 0x01000000U)
#define TIMING_CONTROLS_1__ENABLE_CHANNEL_FILTER__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x01000000U) | (((u_int32_t)(src) <<\
                    24) & 0x01000000U)
#define TIMING_CONTROLS_1__ENABLE_CHANNEL_FILTER__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 24) & ~0x01000000U)))
#define TIMING_CONTROLS_1__ENABLE_CHANNEL_FILTER__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x01000000U) | ((u_int32_t)(1) << 24)
#define TIMING_CONTROLS_1__ENABLE_CHANNEL_FILTER__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x01000000U) | ((u_int32_t)(0) << 24)

/* macros for field false_alarm */
#define TIMING_CONTROLS_1__FALSE_ALARM__SHIFT                                25
#define TIMING_CONTROLS_1__FALSE_ALARM__WIDTH                                 2
#define TIMING_CONTROLS_1__FALSE_ALARM__MASK                        0x06000000U
#define TIMING_CONTROLS_1__FALSE_ALARM__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x06000000U) >> 25)
#define TIMING_CONTROLS_1__FALSE_ALARM__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 25) & 0x06000000U)
#define TIMING_CONTROLS_1__FALSE_ALARM__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x06000000U) | (((u_int32_t)(src) <<\
                    25) & 0x06000000U)
#define TIMING_CONTROLS_1__FALSE_ALARM__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 25) & ~0x06000000U)))

/* macros for field enable_long_rescale */
#define TIMING_CONTROLS_1__ENABLE_LONG_RESCALE__SHIFT                        27
#define TIMING_CONTROLS_1__ENABLE_LONG_RESCALE__WIDTH                         1
#define TIMING_CONTROLS_1__ENABLE_LONG_RESCALE__MASK                0x08000000U
#define TIMING_CONTROLS_1__ENABLE_LONG_RESCALE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x08000000U) >> 27)
#define TIMING_CONTROLS_1__ENABLE_LONG_RESCALE__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 27) & 0x08000000U)
#define TIMING_CONTROLS_1__ENABLE_LONG_RESCALE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x08000000U) | (((u_int32_t)(src) <<\
                    27) & 0x08000000U)
#define TIMING_CONTROLS_1__ENABLE_LONG_RESCALE__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 27) & ~0x08000000U)))
#define TIMING_CONTROLS_1__ENABLE_LONG_RESCALE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x08000000U) | ((u_int32_t)(1) << 27)
#define TIMING_CONTROLS_1__ENABLE_LONG_RESCALE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x08000000U) | ((u_int32_t)(0) << 27)

/* macros for field timing_leak_enable */
#define TIMING_CONTROLS_1__TIMING_LEAK_ENABLE__SHIFT                         28
#define TIMING_CONTROLS_1__TIMING_LEAK_ENABLE__WIDTH                          1
#define TIMING_CONTROLS_1__TIMING_LEAK_ENABLE__MASK                 0x10000000U
#define TIMING_CONTROLS_1__TIMING_LEAK_ENABLE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x10000000U) >> 28)
#define TIMING_CONTROLS_1__TIMING_LEAK_ENABLE__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 28) & 0x10000000U)
#define TIMING_CONTROLS_1__TIMING_LEAK_ENABLE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x10000000U) | (((u_int32_t)(src) <<\
                    28) & 0x10000000U)
#define TIMING_CONTROLS_1__TIMING_LEAK_ENABLE__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 28) & ~0x10000000U)))
#define TIMING_CONTROLS_1__TIMING_LEAK_ENABLE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x10000000U) | ((u_int32_t)(1) << 28)
#define TIMING_CONTROLS_1__TIMING_LEAK_ENABLE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x10000000U) | ((u_int32_t)(0) << 28)

/* macros for field coarse_ppm_select */
#define TIMING_CONTROLS_1__COARSE_PPM_SELECT__SHIFT                          29
#define TIMING_CONTROLS_1__COARSE_PPM_SELECT__WIDTH                           2
#define TIMING_CONTROLS_1__COARSE_PPM_SELECT__MASK                  0x60000000U
#define TIMING_CONTROLS_1__COARSE_PPM_SELECT__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x60000000U) >> 29)
#define TIMING_CONTROLS_1__COARSE_PPM_SELECT__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 29) & 0x60000000U)
#define TIMING_CONTROLS_1__COARSE_PPM_SELECT__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x60000000U) | (((u_int32_t)(src) <<\
                    29) & 0x60000000U)
#define TIMING_CONTROLS_1__COARSE_PPM_SELECT__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 29) & ~0x60000000U)))

/* macros for field fft_scaling */
#define TIMING_CONTROLS_1__FFT_SCALING__SHIFT                                31
#define TIMING_CONTROLS_1__FFT_SCALING__WIDTH                                 1
#define TIMING_CONTROLS_1__FFT_SCALING__MASK                        0x80000000U
#define TIMING_CONTROLS_1__FFT_SCALING__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x80000000U) >> 31)
#define TIMING_CONTROLS_1__FFT_SCALING__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 31) & 0x80000000U)
#define TIMING_CONTROLS_1__FFT_SCALING__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x80000000U) | (((u_int32_t)(src) <<\
                    31) & 0x80000000U)
#define TIMING_CONTROLS_1__FFT_SCALING__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 31) & ~0x80000000U)))
#define TIMING_CONTROLS_1__FFT_SCALING__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x80000000U) | ((u_int32_t)(1) << 31)
#define TIMING_CONTROLS_1__FFT_SCALING__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x80000000U) | ((u_int32_t)(0) << 31)
#define TIMING_CONTROLS_1__TYPE                                       u_int32_t
#define TIMING_CONTROLS_1__READ                                     0xfffc1fffU
#define TIMING_CONTROLS_1__WRITE                                    0xfffc1fffU

#endif /* __TIMING_CONTROLS_1_MACRO__ */


/* macros for bb_reg_map.bb_chn_reg_map.BB_timing_controls_1 */
#define INST_BB_REG_MAP__BB_CHN_REG_MAP__BB_TIMING_CONTROLS_1__NUM            1

/* macros for BlueprintGlobalNameSpace::timing_controls_2 */
#ifndef __TIMING_CONTROLS_2_MACRO__
#define __TIMING_CONTROLS_2_MACRO__

/* macros for field forced_delta_phi_symbol */
#define TIMING_CONTROLS_2__FORCED_DELTA_PHI_SYMBOL__SHIFT                     0
#define TIMING_CONTROLS_2__FORCED_DELTA_PHI_SYMBOL__WIDTH                    12
#define TIMING_CONTROLS_2__FORCED_DELTA_PHI_SYMBOL__MASK            0x00000fffU
#define TIMING_CONTROLS_2__FORCED_DELTA_PHI_SYMBOL__READ(src) \
                    (u_int32_t)(src)\
                    & 0x00000fffU
#define TIMING_CONTROLS_2__FORCED_DELTA_PHI_SYMBOL__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x00000fffU)
#define TIMING_CONTROLS_2__FORCED_DELTA_PHI_SYMBOL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000fffU) | ((u_int32_t)(src) &\
                    0x00000fffU)
#define TIMING_CONTROLS_2__FORCED_DELTA_PHI_SYMBOL__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00000fffU)))

/* macros for field force_delta_phi_symbol */
#define TIMING_CONTROLS_2__FORCE_DELTA_PHI_SYMBOL__SHIFT                     12
#define TIMING_CONTROLS_2__FORCE_DELTA_PHI_SYMBOL__WIDTH                      1
#define TIMING_CONTROLS_2__FORCE_DELTA_PHI_SYMBOL__MASK             0x00001000U
#define TIMING_CONTROLS_2__FORCE_DELTA_PHI_SYMBOL__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00001000U) >> 12)
#define TIMING_CONTROLS_2__FORCE_DELTA_PHI_SYMBOL__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 12) & 0x00001000U)
#define TIMING_CONTROLS_2__FORCE_DELTA_PHI_SYMBOL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00001000U) | (((u_int32_t)(src) <<\
                    12) & 0x00001000U)
#define TIMING_CONTROLS_2__FORCE_DELTA_PHI_SYMBOL__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 12) & ~0x00001000U)))
#define TIMING_CONTROLS_2__FORCE_DELTA_PHI_SYMBOL__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00001000U) | ((u_int32_t)(1) << 12)
#define TIMING_CONTROLS_2__FORCE_DELTA_PHI_SYMBOL__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00001000U) | ((u_int32_t)(0) << 12)

/* macros for field enable_magnitude_track */
#define TIMING_CONTROLS_2__ENABLE_MAGNITUDE_TRACK__SHIFT                     13
#define TIMING_CONTROLS_2__ENABLE_MAGNITUDE_TRACK__WIDTH                      1
#define TIMING_CONTROLS_2__ENABLE_MAGNITUDE_TRACK__MASK             0x00002000U
#define TIMING_CONTROLS_2__ENABLE_MAGNITUDE_TRACK__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00002000U) >> 13)
#define TIMING_CONTROLS_2__ENABLE_MAGNITUDE_TRACK__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 13) & 0x00002000U)
#define TIMING_CONTROLS_2__ENABLE_MAGNITUDE_TRACK__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00002000U) | (((u_int32_t)(src) <<\
                    13) & 0x00002000U)
#define TIMING_CONTROLS_2__ENABLE_MAGNITUDE_TRACK__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 13) & ~0x00002000U)))
#define TIMING_CONTROLS_2__ENABLE_MAGNITUDE_TRACK__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00002000U) | ((u_int32_t)(1) << 13)
#define TIMING_CONTROLS_2__ENABLE_MAGNITUDE_TRACK__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00002000U) | ((u_int32_t)(0) << 13)

/* macros for field enable_magnitude_track_mimo */
#define TIMING_CONTROLS_2__ENABLE_MAGNITUDE_TRACK_MIMO__SHIFT                14
#define TIMING_CONTROLS_2__ENABLE_MAGNITUDE_TRACK_MIMO__WIDTH                 1
#define TIMING_CONTROLS_2__ENABLE_MAGNITUDE_TRACK_MIMO__MASK        0x00004000U
#define TIMING_CONTROLS_2__ENABLE_MAGNITUDE_TRACK_MIMO__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00004000U) >> 14)
#define TIMING_CONTROLS_2__ENABLE_MAGNITUDE_TRACK_MIMO__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 14) & 0x00004000U)
#define TIMING_CONTROLS_2__ENABLE_MAGNITUDE_TRACK_MIMO__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00004000U) | (((u_int32_t)(src) <<\
                    14) & 0x00004000U)
#define TIMING_CONTROLS_2__ENABLE_MAGNITUDE_TRACK_MIMO__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 14) & ~0x00004000U)))
#define TIMING_CONTROLS_2__ENABLE_MAGNITUDE_TRACK_MIMO__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00004000U) | ((u_int32_t)(1) << 14)
#define TIMING_CONTROLS_2__ENABLE_MAGNITUDE_TRACK_MIMO__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00004000U) | ((u_int32_t)(0) << 14)

/* macros for field enable_offset_filter */
#define TIMING_CONTROLS_2__ENABLE_OFFSET_FILTER__SHIFT                       15
#define TIMING_CONTROLS_2__ENABLE_OFFSET_FILTER__WIDTH                        1
#define TIMING_CONTROLS_2__ENABLE_OFFSET_FILTER__MASK               0x00008000U
#define TIMING_CONTROLS_2__ENABLE_OFFSET_FILTER__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00008000U) >> 15)
#define TIMING_CONTROLS_2__ENABLE_OFFSET_FILTER__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 15) & 0x00008000U)
#define TIMING_CONTROLS_2__ENABLE_OFFSET_FILTER__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00008000U) | (((u_int32_t)(src) <<\
                    15) & 0x00008000U)
#define TIMING_CONTROLS_2__ENABLE_OFFSET_FILTER__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 15) & ~0x00008000U)))
#define TIMING_CONTROLS_2__ENABLE_OFFSET_FILTER__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00008000U) | ((u_int32_t)(1) << 15)
#define TIMING_CONTROLS_2__ENABLE_OFFSET_FILTER__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00008000U) | ((u_int32_t)(0) << 15)

/* macros for field dc_off_deltaf_thres */
#define TIMING_CONTROLS_2__DC_OFF_DELTAF_THRES__SHIFT                        16
#define TIMING_CONTROLS_2__DC_OFF_DELTAF_THRES__WIDTH                         7
#define TIMING_CONTROLS_2__DC_OFF_DELTAF_THRES__MASK                0x007f0000U
#define TIMING_CONTROLS_2__DC_OFF_DELTAF_THRES__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x007f0000U) >> 16)
#define TIMING_CONTROLS_2__DC_OFF_DELTAF_THRES__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 16) & 0x007f0000U)
#define TIMING_CONTROLS_2__DC_OFF_DELTAF_THRES__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x007f0000U) | (((u_int32_t)(src) <<\
                    16) & 0x007f0000U)
#define TIMING_CONTROLS_2__DC_OFF_DELTAF_THRES__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 16) & ~0x007f0000U)))

/* macros for field enable_pilot_interpolation */
#define TIMING_CONTROLS_2__ENABLE_PILOT_INTERPOLATION__SHIFT                 23
#define TIMING_CONTROLS_2__ENABLE_PILOT_INTERPOLATION__WIDTH                  1
#define TIMING_CONTROLS_2__ENABLE_PILOT_INTERPOLATION__MASK         0x00800000U
#define TIMING_CONTROLS_2__ENABLE_PILOT_INTERPOLATION__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00800000U) >> 23)
#define TIMING_CONTROLS_2__ENABLE_PILOT_INTERPOLATION__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 23) & 0x00800000U)
#define TIMING_CONTROLS_2__ENABLE_PILOT_INTERPOLATION__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00800000U) | (((u_int32_t)(src) <<\
                    23) & 0x00800000U)
#define TIMING_CONTROLS_2__ENABLE_PILOT_INTERPOLATION__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 23) & ~0x00800000U)))
#define TIMING_CONTROLS_2__ENABLE_PILOT_INTERPOLATION__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00800000U) | ((u_int32_t)(1) << 23)
#define TIMING_CONTROLS_2__ENABLE_PILOT_INTERPOLATION__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00800000U) | ((u_int32_t)(0) << 23)

/* macros for field dc_off_tim_const */
#define TIMING_CONTROLS_2__DC_OFF_TIM_CONST__SHIFT                           24
#define TIMING_CONTROLS_2__DC_OFF_TIM_CONST__WIDTH                            3
#define TIMING_CONTROLS_2__DC_OFF_TIM_CONST__MASK                   0x07000000U
#define TIMING_CONTROLS_2__DC_OFF_TIM_CONST__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x07000000U) >> 24)
#define TIMING_CONTROLS_2__DC_OFF_TIM_CONST__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 24) & 0x07000000U)
#define TIMING_CONTROLS_2__DC_OFF_TIM_CONST__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x07000000U) | (((u_int32_t)(src) <<\
                    24) & 0x07000000U)
#define TIMING_CONTROLS_2__DC_OFF_TIM_CONST__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 24) & ~0x07000000U)))

/* macros for field enable_dc_offset */
#define TIMING_CONTROLS_2__ENABLE_DC_OFFSET__SHIFT                           27
#define TIMING_CONTROLS_2__ENABLE_DC_OFFSET__WIDTH                            1
#define TIMING_CONTROLS_2__ENABLE_DC_OFFSET__MASK                   0x08000000U
#define TIMING_CONTROLS_2__ENABLE_DC_OFFSET__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x08000000U) >> 27)
#define TIMING_CONTROLS_2__ENABLE_DC_OFFSET__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 27) & 0x08000000U)
#define TIMING_CONTROLS_2__ENABLE_DC_OFFSET__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x08000000U) | (((u_int32_t)(src) <<\
                    27) & 0x08000000U)
#define TIMING_CONTROLS_2__ENABLE_DC_OFFSET__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 27) & ~0x08000000U)))
#define TIMING_CONTROLS_2__ENABLE_DC_OFFSET__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x08000000U) | ((u_int32_t)(1) << 27)
#define TIMING_CONTROLS_2__ENABLE_DC_OFFSET__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x08000000U) | ((u_int32_t)(0) << 27)

/* macros for field enable_dc_offset_track */
#define TIMING_CONTROLS_2__ENABLE_DC_OFFSET_TRACK__SHIFT                     28
#define TIMING_CONTROLS_2__ENABLE_DC_OFFSET_TRACK__WIDTH                      1
#define TIMING_CONTROLS_2__ENABLE_DC_OFFSET_TRACK__MASK             0x10000000U
#define TIMING_CONTROLS_2__ENABLE_DC_OFFSET_TRACK__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x10000000U) >> 28)
#define TIMING_CONTROLS_2__ENABLE_DC_OFFSET_TRACK__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 28) & 0x10000000U)
#define TIMING_CONTROLS_2__ENABLE_DC_OFFSET_TRACK__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x10000000U) | (((u_int32_t)(src) <<\
                    28) & 0x10000000U)
#define TIMING_CONTROLS_2__ENABLE_DC_OFFSET_TRACK__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 28) & ~0x10000000U)))
#define TIMING_CONTROLS_2__ENABLE_DC_OFFSET_TRACK__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x10000000U) | ((u_int32_t)(1) << 28)
#define TIMING_CONTROLS_2__ENABLE_DC_OFFSET_TRACK__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x10000000U) | ((u_int32_t)(0) << 28)

/* macros for field enable_weighting */
#define TIMING_CONTROLS_2__ENABLE_WEIGHTING__SHIFT                           29
#define TIMING_CONTROLS_2__ENABLE_WEIGHTING__WIDTH                            1
#define TIMING_CONTROLS_2__ENABLE_WEIGHTING__MASK                   0x20000000U
#define TIMING_CONTROLS_2__ENABLE_WEIGHTING__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x20000000U) >> 29)
#define TIMING_CONTROLS_2__ENABLE_WEIGHTING__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 29) & 0x20000000U)
#define TIMING_CONTROLS_2__ENABLE_WEIGHTING__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x20000000U) | (((u_int32_t)(src) <<\
                    29) & 0x20000000U)
#define TIMING_CONTROLS_2__ENABLE_WEIGHTING__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 29) & ~0x20000000U)))
#define TIMING_CONTROLS_2__ENABLE_WEIGHTING__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x20000000U) | ((u_int32_t)(1) << 29)
#define TIMING_CONTROLS_2__ENABLE_WEIGHTING__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x20000000U) | ((u_int32_t)(0) << 29)

/* macros for field traceback128 */
#define TIMING_CONTROLS_2__TRACEBACK128__SHIFT                               30
#define TIMING_CONTROLS_2__TRACEBACK128__WIDTH                                1
#define TIMING_CONTROLS_2__TRACEBACK128__MASK                       0x40000000U
#define TIMING_CONTROLS_2__TRACEBACK128__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x40000000U) >> 30)
#define TIMING_CONTROLS_2__TRACEBACK128__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 30) & 0x40000000U)
#define TIMING_CONTROLS_2__TRACEBACK128__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x40000000U) | (((u_int32_t)(src) <<\
                    30) & 0x40000000U)
#define TIMING_CONTROLS_2__TRACEBACK128__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 30) & ~0x40000000U)))
#define TIMING_CONTROLS_2__TRACEBACK128__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x40000000U) | ((u_int32_t)(1) << 30)
#define TIMING_CONTROLS_2__TRACEBACK128__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x40000000U) | ((u_int32_t)(0) << 30)

/* macros for field enable_ht_fine_timing */
#define TIMING_CONTROLS_2__ENABLE_HT_FINE_TIMING__SHIFT                      31
#define TIMING_CONTROLS_2__ENABLE_HT_FINE_TIMING__WIDTH                       1
#define TIMING_CONTROLS_2__ENABLE_HT_FINE_TIMING__MASK              0x80000000U
#define TIMING_CONTROLS_2__ENABLE_HT_FINE_TIMING__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x80000000U) >> 31)
#define TIMING_CONTROLS_2__ENABLE_HT_FINE_TIMING__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 31) & 0x80000000U)
#define TIMING_CONTROLS_2__ENABLE_HT_FINE_TIMING__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x80000000U) | (((u_int32_t)(src) <<\
                    31) & 0x80000000U)
#define TIMING_CONTROLS_2__ENABLE_HT_FINE_TIMING__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 31) & ~0x80000000U)))
#define TIMING_CONTROLS_2__ENABLE_HT_FINE_TIMING__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x80000000U) | ((u_int32_t)(1) << 31)
#define TIMING_CONTROLS_2__ENABLE_HT_FINE_TIMING__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x80000000U) | ((u_int32_t)(0) << 31)
#define TIMING_CONTROLS_2__TYPE                                       u_int32_t
#define TIMING_CONTROLS_2__READ                                     0xffffffffU
#define TIMING_CONTROLS_2__WRITE                                    0xffffffffU

#endif /* __TIMING_CONTROLS_2_MACRO__ */


/* macros for bb_reg_map.bb_chn_reg_map.BB_timing_controls_2 */
#define INST_BB_REG_MAP__BB_CHN_REG_MAP__BB_TIMING_CONTROLS_2__NUM            1

/* macros for BlueprintGlobalNameSpace::timing_controls_3 */
#ifndef __TIMING_CONTROLS_3_MACRO__
#define __TIMING_CONTROLS_3_MACRO__

/* macros for field ppm_rescue_interval */
#define TIMING_CONTROLS_3__PPM_RESCUE_INTERVAL__SHIFT                         0
#define TIMING_CONTROLS_3__PPM_RESCUE_INTERVAL__WIDTH                         8
#define TIMING_CONTROLS_3__PPM_RESCUE_INTERVAL__MASK                0x000000ffU
#define TIMING_CONTROLS_3__PPM_RESCUE_INTERVAL__READ(src) \
                    (u_int32_t)(src)\
                    & 0x000000ffU
#define TIMING_CONTROLS_3__PPM_RESCUE_INTERVAL__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x000000ffU)
#define TIMING_CONTROLS_3__PPM_RESCUE_INTERVAL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000000ffU) | ((u_int32_t)(src) &\
                    0x000000ffU)
#define TIMING_CONTROLS_3__PPM_RESCUE_INTERVAL__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x000000ffU)))

/* macros for field enable_ppm_rescue */
#define TIMING_CONTROLS_3__ENABLE_PPM_RESCUE__SHIFT                           8
#define TIMING_CONTROLS_3__ENABLE_PPM_RESCUE__WIDTH                           1
#define TIMING_CONTROLS_3__ENABLE_PPM_RESCUE__MASK                  0x00000100U
#define TIMING_CONTROLS_3__ENABLE_PPM_RESCUE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000100U) >> 8)
#define TIMING_CONTROLS_3__ENABLE_PPM_RESCUE__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 8) & 0x00000100U)
#define TIMING_CONTROLS_3__ENABLE_PPM_RESCUE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000100U) | (((u_int32_t)(src) <<\
                    8) & 0x00000100U)
#define TIMING_CONTROLS_3__ENABLE_PPM_RESCUE__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 8) & ~0x00000100U)))
#define TIMING_CONTROLS_3__ENABLE_PPM_RESCUE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000100U) | ((u_int32_t)(1) << 8)
#define TIMING_CONTROLS_3__ENABLE_PPM_RESCUE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000100U) | ((u_int32_t)(0) << 8)

/* macros for field enable_fine_ppm */
#define TIMING_CONTROLS_3__ENABLE_FINE_PPM__SHIFT                             9
#define TIMING_CONTROLS_3__ENABLE_FINE_PPM__WIDTH                             1
#define TIMING_CONTROLS_3__ENABLE_FINE_PPM__MASK                    0x00000200U
#define TIMING_CONTROLS_3__ENABLE_FINE_PPM__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000200U) >> 9)
#define TIMING_CONTROLS_3__ENABLE_FINE_PPM__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 9) & 0x00000200U)
#define TIMING_CONTROLS_3__ENABLE_FINE_PPM__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000200U) | (((u_int32_t)(src) <<\
                    9) & 0x00000200U)
#define TIMING_CONTROLS_3__ENABLE_FINE_PPM__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 9) & ~0x00000200U)))
#define TIMING_CONTROLS_3__ENABLE_FINE_PPM__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000200U) | ((u_int32_t)(1) << 9)
#define TIMING_CONTROLS_3__ENABLE_FINE_PPM__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000200U) | ((u_int32_t)(0) << 9)

/* macros for field enable_fine_interp */
#define TIMING_CONTROLS_3__ENABLE_FINE_INTERP__SHIFT                         10
#define TIMING_CONTROLS_3__ENABLE_FINE_INTERP__WIDTH                          1
#define TIMING_CONTROLS_3__ENABLE_FINE_INTERP__MASK                 0x00000400U
#define TIMING_CONTROLS_3__ENABLE_FINE_INTERP__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000400U) >> 10)
#define TIMING_CONTROLS_3__ENABLE_FINE_INTERP__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 10) & 0x00000400U)
#define TIMING_CONTROLS_3__ENABLE_FINE_INTERP__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000400U) | (((u_int32_t)(src) <<\
                    10) & 0x00000400U)
#define TIMING_CONTROLS_3__ENABLE_FINE_INTERP__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 10) & ~0x00000400U)))
#define TIMING_CONTROLS_3__ENABLE_FINE_INTERP__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000400U) | ((u_int32_t)(1) << 10)
#define TIMING_CONTROLS_3__ENABLE_FINE_INTERP__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000400U) | ((u_int32_t)(0) << 10)

/* macros for field continuous_ppm_rescue */
#define TIMING_CONTROLS_3__CONTINUOUS_PPM_RESCUE__SHIFT                      11
#define TIMING_CONTROLS_3__CONTINUOUS_PPM_RESCUE__WIDTH                       1
#define TIMING_CONTROLS_3__CONTINUOUS_PPM_RESCUE__MASK              0x00000800U
#define TIMING_CONTROLS_3__CONTINUOUS_PPM_RESCUE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000800U) >> 11)
#define TIMING_CONTROLS_3__CONTINUOUS_PPM_RESCUE__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 11) & 0x00000800U)
#define TIMING_CONTROLS_3__CONTINUOUS_PPM_RESCUE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000800U) | (((u_int32_t)(src) <<\
                    11) & 0x00000800U)
#define TIMING_CONTROLS_3__CONTINUOUS_PPM_RESCUE__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 11) & ~0x00000800U)))
#define TIMING_CONTROLS_3__CONTINUOUS_PPM_RESCUE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000800U) | ((u_int32_t)(1) << 11)
#define TIMING_CONTROLS_3__CONTINUOUS_PPM_RESCUE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000800U) | ((u_int32_t)(0) << 11)

/* macros for field enable_df_chanest */
#define TIMING_CONTROLS_3__ENABLE_DF_CHANEST__SHIFT                          12
#define TIMING_CONTROLS_3__ENABLE_DF_CHANEST__WIDTH                           1
#define TIMING_CONTROLS_3__ENABLE_DF_CHANEST__MASK                  0x00001000U
#define TIMING_CONTROLS_3__ENABLE_DF_CHANEST__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00001000U) >> 12)
#define TIMING_CONTROLS_3__ENABLE_DF_CHANEST__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 12) & 0x00001000U)
#define TIMING_CONTROLS_3__ENABLE_DF_CHANEST__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00001000U) | (((u_int32_t)(src) <<\
                    12) & 0x00001000U)
#define TIMING_CONTROLS_3__ENABLE_DF_CHANEST__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 12) & ~0x00001000U)))
#define TIMING_CONTROLS_3__ENABLE_DF_CHANEST__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00001000U) | ((u_int32_t)(1) << 12)
#define TIMING_CONTROLS_3__ENABLE_DF_CHANEST__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00001000U) | ((u_int32_t)(0) << 12)

/* macros for field delta_slope_coef_exp */
#define TIMING_CONTROLS_3__DELTA_SLOPE_COEF_EXP__SHIFT                       13
#define TIMING_CONTROLS_3__DELTA_SLOPE_COEF_EXP__WIDTH                        4
#define TIMING_CONTROLS_3__DELTA_SLOPE_COEF_EXP__MASK               0x0001e000U
#define TIMING_CONTROLS_3__DELTA_SLOPE_COEF_EXP__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0001e000U) >> 13)
#define TIMING_CONTROLS_3__DELTA_SLOPE_COEF_EXP__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 13) & 0x0001e000U)
#define TIMING_CONTROLS_3__DELTA_SLOPE_COEF_EXP__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0001e000U) | (((u_int32_t)(src) <<\
                    13) & 0x0001e000U)
#define TIMING_CONTROLS_3__DELTA_SLOPE_COEF_EXP__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 13) & ~0x0001e000U)))

/* macros for field delta_slope_coef_man */
#define TIMING_CONTROLS_3__DELTA_SLOPE_COEF_MAN__SHIFT                       17
#define TIMING_CONTROLS_3__DELTA_SLOPE_COEF_MAN__WIDTH                       15
#define TIMING_CONTROLS_3__DELTA_SLOPE_COEF_MAN__MASK               0xfffe0000U
#define TIMING_CONTROLS_3__DELTA_SLOPE_COEF_MAN__READ(src) \
                    (((u_int32_t)(src)\
                    & 0xfffe0000U) >> 17)
#define TIMING_CONTROLS_3__DELTA_SLOPE_COEF_MAN__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 17) & 0xfffe0000U)
#define TIMING_CONTROLS_3__DELTA_SLOPE_COEF_MAN__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xfffe0000U) | (((u_int32_t)(src) <<\
                    17) & 0xfffe0000U)
#define TIMING_CONTROLS_3__DELTA_SLOPE_COEF_MAN__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 17) & ~0xfffe0000U)))
#define TIMING_CONTROLS_3__TYPE                                       u_int32_t
#define TIMING_CONTROLS_3__READ                                     0xffffffffU
#define TIMING_CONTROLS_3__WRITE                                    0xffffffffU

#endif /* __TIMING_CONTROLS_3_MACRO__ */


/* macros for bb_reg_map.bb_chn_reg_map.BB_timing_controls_3 */
#define INST_BB_REG_MAP__BB_CHN_REG_MAP__BB_TIMING_CONTROLS_3__NUM            1

/* macros for BlueprintGlobalNameSpace::timing_control_4 */
#ifndef __TIMING_CONTROL_4_MACRO__
#define __TIMING_CONTROL_4_MACRO__

/* macros for field enable_ht_fine_ppm */
#define TIMING_CONTROL_4__ENABLE_HT_FINE_PPM__SHIFT                           0
#define TIMING_CONTROL_4__ENABLE_HT_FINE_PPM__WIDTH                           1
#define TIMING_CONTROL_4__ENABLE_HT_FINE_PPM__MASK                  0x00000001U
#define TIMING_CONTROL_4__ENABLE_HT_FINE_PPM__READ(src) \
                    (u_int32_t)(src)\
                    & 0x00000001U
#define TIMING_CONTROL_4__ENABLE_HT_FINE_PPM__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x00000001U)
#define TIMING_CONTROL_4__ENABLE_HT_FINE_PPM__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | ((u_int32_t)(src) &\
                    0x00000001U)
#define TIMING_CONTROL_4__ENABLE_HT_FINE_PPM__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00000001U)))
#define TIMING_CONTROL_4__ENABLE_HT_FINE_PPM__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(1)
#define TIMING_CONTROL_4__ENABLE_HT_FINE_PPM__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(0)

/* macros for field enable_magnitude_track_11n_mimo */
#define TIMING_CONTROL_4__ENABLE_MAGNITUDE_TRACK_11N_MIMO__SHIFT              1
#define TIMING_CONTROL_4__ENABLE_MAGNITUDE_TRACK_11N_MIMO__WIDTH              1
#define TIMING_CONTROL_4__ENABLE_MAGNITUDE_TRACK_11N_MIMO__MASK     0x00000002U
#define TIMING_CONTROL_4__ENABLE_MAGNITUDE_TRACK_11N_MIMO__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000002U) >> 1)
#define TIMING_CONTROL_4__ENABLE_MAGNITUDE_TRACK_11N_MIMO__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 1) & 0x00000002U)
#define TIMING_CONTROL_4__ENABLE_MAGNITUDE_TRACK_11N_MIMO__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | (((u_int32_t)(src) <<\
                    1) & 0x00000002U)
#define TIMING_CONTROL_4__ENABLE_MAGNITUDE_TRACK_11N_MIMO__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 1) & ~0x00000002U)))
#define TIMING_CONTROL_4__ENABLE_MAGNITUDE_TRACK_11N_MIMO__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | ((u_int32_t)(1) << 1)
#define TIMING_CONTROL_4__ENABLE_MAGNITUDE_TRACK_11N_MIMO__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | ((u_int32_t)(0) << 1)

/* macros for field use_data_as_pilot_df */
#define TIMING_CONTROL_4__USE_DATA_AS_PILOT_DF__SHIFT                        11
#define TIMING_CONTROL_4__USE_DATA_AS_PILOT_DF__WIDTH                         1
#define TIMING_CONTROL_4__USE_DATA_AS_PILOT_DF__MASK                0x00000800U
#define TIMING_CONTROL_4__USE_DATA_AS_PILOT_DF__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000800U) >> 11)
#define TIMING_CONTROL_4__USE_DATA_AS_PILOT_DF__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 11) & 0x00000800U)
#define TIMING_CONTROL_4__USE_DATA_AS_PILOT_DF__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000800U) | (((u_int32_t)(src) <<\
                    11) & 0x00000800U)
#define TIMING_CONTROL_4__USE_DATA_AS_PILOT_DF__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 11) & ~0x00000800U)))
#define TIMING_CONTROL_4__USE_DATA_AS_PILOT_DF__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000800U) | ((u_int32_t)(1) << 11)
#define TIMING_CONTROL_4__USE_DATA_AS_PILOT_DF__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000800U) | ((u_int32_t)(0) << 11)

/* macros for field cal_lg_count_max */
#define TIMING_CONTROL_4__CAL_LG_COUNT_MAX__SHIFT                            12
#define TIMING_CONTROL_4__CAL_LG_COUNT_MAX__WIDTH                             4
#define TIMING_CONTROL_4__CAL_LG_COUNT_MAX__MASK                    0x0000f000U
#define TIMING_CONTROL_4__CAL_LG_COUNT_MAX__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0000f000U) >> 12)
#define TIMING_CONTROL_4__CAL_LG_COUNT_MAX__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 12) & 0x0000f000U)
#define TIMING_CONTROL_4__CAL_LG_COUNT_MAX__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000f000U) | (((u_int32_t)(src) <<\
                    12) & 0x0000f000U)
#define TIMING_CONTROL_4__CAL_LG_COUNT_MAX__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 12) & ~0x0000f000U)))

/* macros for field do_gain_dc_iq_cal */
#define TIMING_CONTROL_4__DO_GAIN_DC_IQ_CAL__SHIFT                           16
#define TIMING_CONTROL_4__DO_GAIN_DC_IQ_CAL__WIDTH                            1
#define TIMING_CONTROL_4__DO_GAIN_DC_IQ_CAL__MASK                   0x00010000U
#define TIMING_CONTROL_4__DO_GAIN_DC_IQ_CAL__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00010000U) >> 16)
#define TIMING_CONTROL_4__DO_GAIN_DC_IQ_CAL__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 16) & 0x00010000U)
#define TIMING_CONTROL_4__DO_GAIN_DC_IQ_CAL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00010000U) | (((u_int32_t)(src) <<\
                    16) & 0x00010000U)
#define TIMING_CONTROL_4__DO_GAIN_DC_IQ_CAL__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 16) & ~0x00010000U)))
#define TIMING_CONTROL_4__DO_GAIN_DC_IQ_CAL__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00010000U) | ((u_int32_t)(1) << 16)
#define TIMING_CONTROL_4__DO_GAIN_DC_IQ_CAL__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00010000U) | ((u_int32_t)(0) << 16)

/* macros for field use_pilot_track_df */
#define TIMING_CONTROL_4__USE_PILOT_TRACK_DF__SHIFT                          17
#define TIMING_CONTROL_4__USE_PILOT_TRACK_DF__WIDTH                           4
#define TIMING_CONTROL_4__USE_PILOT_TRACK_DF__MASK                  0x001e0000U
#define TIMING_CONTROL_4__USE_PILOT_TRACK_DF__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x001e0000U) >> 17)
#define TIMING_CONTROL_4__USE_PILOT_TRACK_DF__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 17) & 0x001e0000U)
#define TIMING_CONTROL_4__USE_PILOT_TRACK_DF__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x001e0000U) | (((u_int32_t)(src) <<\
                    17) & 0x001e0000U)
#define TIMING_CONTROL_4__USE_PILOT_TRACK_DF__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 17) & ~0x001e0000U)))

/* macros for field early_trigger_thr */
#define TIMING_CONTROL_4__EARLY_TRIGGER_THR__SHIFT                           21
#define TIMING_CONTROL_4__EARLY_TRIGGER_THR__WIDTH                            7
#define TIMING_CONTROL_4__EARLY_TRIGGER_THR__MASK                   0x0fe00000U
#define TIMING_CONTROL_4__EARLY_TRIGGER_THR__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0fe00000U) >> 21)
#define TIMING_CONTROL_4__EARLY_TRIGGER_THR__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 21) & 0x0fe00000U)
#define TIMING_CONTROL_4__EARLY_TRIGGER_THR__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0fe00000U) | (((u_int32_t)(src) <<\
                    21) & 0x0fe00000U)
#define TIMING_CONTROL_4__EARLY_TRIGGER_THR__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 21) & ~0x0fe00000U)))

/* macros for field enable_pilot_mask */
#define TIMING_CONTROL_4__ENABLE_PILOT_MASK__SHIFT                           28
#define TIMING_CONTROL_4__ENABLE_PILOT_MASK__WIDTH                            1
#define TIMING_CONTROL_4__ENABLE_PILOT_MASK__MASK                   0x10000000U
#define TIMING_CONTROL_4__ENABLE_PILOT_MASK__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x10000000U) >> 28)
#define TIMING_CONTROL_4__ENABLE_PILOT_MASK__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 28) & 0x10000000U)
#define TIMING_CONTROL_4__ENABLE_PILOT_MASK__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x10000000U) | (((u_int32_t)(src) <<\
                    28) & 0x10000000U)
#define TIMING_CONTROL_4__ENABLE_PILOT_MASK__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 28) & ~0x10000000U)))
#define TIMING_CONTROL_4__ENABLE_PILOT_MASK__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x10000000U) | ((u_int32_t)(1) << 28)
#define TIMING_CONTROL_4__ENABLE_PILOT_MASK__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x10000000U) | ((u_int32_t)(0) << 28)

/* macros for field enable_chan_mask */
#define TIMING_CONTROL_4__ENABLE_CHAN_MASK__SHIFT                            29
#define TIMING_CONTROL_4__ENABLE_CHAN_MASK__WIDTH                             1
#define TIMING_CONTROL_4__ENABLE_CHAN_MASK__MASK                    0x20000000U
#define TIMING_CONTROL_4__ENABLE_CHAN_MASK__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x20000000U) >> 29)
#define TIMING_CONTROL_4__ENABLE_CHAN_MASK__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 29) & 0x20000000U)
#define TIMING_CONTROL_4__ENABLE_CHAN_MASK__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x20000000U) | (((u_int32_t)(src) <<\
                    29) & 0x20000000U)
#define TIMING_CONTROL_4__ENABLE_CHAN_MASK__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 29) & ~0x20000000U)))
#define TIMING_CONTROL_4__ENABLE_CHAN_MASK__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x20000000U) | ((u_int32_t)(1) << 29)
#define TIMING_CONTROL_4__ENABLE_CHAN_MASK__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x20000000U) | ((u_int32_t)(0) << 29)

/* macros for field enable_spur_rssi */
#define TIMING_CONTROL_4__ENABLE_SPUR_RSSI__SHIFT                            31
#define TIMING_CONTROL_4__ENABLE_SPUR_RSSI__WIDTH                             1
#define TIMING_CONTROL_4__ENABLE_SPUR_RSSI__MASK                    0x80000000U
#define TIMING_CONTROL_4__ENABLE_SPUR_RSSI__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x80000000U) >> 31)
#define TIMING_CONTROL_4__ENABLE_SPUR_RSSI__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 31) & 0x80000000U)
#define TIMING_CONTROL_4__ENABLE_SPUR_RSSI__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x80000000U) | (((u_int32_t)(src) <<\
                    31) & 0x80000000U)
#define TIMING_CONTROL_4__ENABLE_SPUR_RSSI__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 31) & ~0x80000000U)))
#define TIMING_CONTROL_4__ENABLE_SPUR_RSSI__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x80000000U) | ((u_int32_t)(1) << 31)
#define TIMING_CONTROL_4__ENABLE_SPUR_RSSI__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x80000000U) | ((u_int32_t)(0) << 31)
#define TIMING_CONTROL_4__TYPE                                        u_int32_t
#define TIMING_CONTROL_4__READ                                      0xbffff803U
#define TIMING_CONTROL_4__WRITE                                     0xbffff803U

#endif /* __TIMING_CONTROL_4_MACRO__ */


/* macros for bb_reg_map.bb_chn_reg_map.BB_timing_control_4 */
#define INST_BB_REG_MAP__BB_CHN_REG_MAP__BB_TIMING_CONTROL_4__NUM             1

/* macros for BlueprintGlobalNameSpace::timing_control_5 */
#ifndef __TIMING_CONTROL_5_MACRO__
#define __TIMING_CONTROL_5_MACRO__

/* macros for field enable_cycpwr_thr1 */
#define TIMING_CONTROL_5__ENABLE_CYCPWR_THR1__SHIFT                           0
#define TIMING_CONTROL_5__ENABLE_CYCPWR_THR1__WIDTH                           1
#define TIMING_CONTROL_5__ENABLE_CYCPWR_THR1__MASK                  0x00000001U
#define TIMING_CONTROL_5__ENABLE_CYCPWR_THR1__READ(src) \
                    (u_int32_t)(src)\
                    & 0x00000001U
#define TIMING_CONTROL_5__ENABLE_CYCPWR_THR1__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x00000001U)
#define TIMING_CONTROL_5__ENABLE_CYCPWR_THR1__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | ((u_int32_t)(src) &\
                    0x00000001U)
#define TIMING_CONTROL_5__ENABLE_CYCPWR_THR1__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00000001U)))
#define TIMING_CONTROL_5__ENABLE_CYCPWR_THR1__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(1)
#define TIMING_CONTROL_5__ENABLE_CYCPWR_THR1__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(0)

/* macros for field cycpwr_thr1 */
#define TIMING_CONTROL_5__CYCPWR_THR1__SHIFT                                  1
#define TIMING_CONTROL_5__CYCPWR_THR1__WIDTH                                  7
#define TIMING_CONTROL_5__CYCPWR_THR1__MASK                         0x000000feU
#define TIMING_CONTROL_5__CYCPWR_THR1__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x000000feU) >> 1)
#define TIMING_CONTROL_5__CYCPWR_THR1__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 1) & 0x000000feU)
#define TIMING_CONTROL_5__CYCPWR_THR1__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000000feU) | (((u_int32_t)(src) <<\
                    1) & 0x000000feU)
#define TIMING_CONTROL_5__CYCPWR_THR1__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 1) & ~0x000000feU)))

/* macros for field enable_rssi_thr1a */
#define TIMING_CONTROL_5__ENABLE_RSSI_THR1A__SHIFT                           15
#define TIMING_CONTROL_5__ENABLE_RSSI_THR1A__WIDTH                            1
#define TIMING_CONTROL_5__ENABLE_RSSI_THR1A__MASK                   0x00008000U
#define TIMING_CONTROL_5__ENABLE_RSSI_THR1A__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00008000U) >> 15)
#define TIMING_CONTROL_5__ENABLE_RSSI_THR1A__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 15) & 0x00008000U)
#define TIMING_CONTROL_5__ENABLE_RSSI_THR1A__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00008000U) | (((u_int32_t)(src) <<\
                    15) & 0x00008000U)
#define TIMING_CONTROL_5__ENABLE_RSSI_THR1A__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 15) & ~0x00008000U)))
#define TIMING_CONTROL_5__ENABLE_RSSI_THR1A__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00008000U) | ((u_int32_t)(1) << 15)
#define TIMING_CONTROL_5__ENABLE_RSSI_THR1A__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00008000U) | ((u_int32_t)(0) << 15)

/* macros for field rssi_thr1a */
#define TIMING_CONTROL_5__RSSI_THR1A__SHIFT                                  16
#define TIMING_CONTROL_5__RSSI_THR1A__WIDTH                                   7
#define TIMING_CONTROL_5__RSSI_THR1A__MASK                          0x007f0000U
#define TIMING_CONTROL_5__RSSI_THR1A__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x007f0000U) >> 16)
#define TIMING_CONTROL_5__RSSI_THR1A__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 16) & 0x007f0000U)
#define TIMING_CONTROL_5__RSSI_THR1A__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x007f0000U) | (((u_int32_t)(src) <<\
                    16) & 0x007f0000U)
#define TIMING_CONTROL_5__RSSI_THR1A__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 16) & ~0x007f0000U)))

/* macros for field long_sc_thresh_hi_rssi */
#define TIMING_CONTROL_5__LONG_SC_THRESH_HI_RSSI__SHIFT                      23
#define TIMING_CONTROL_5__LONG_SC_THRESH_HI_RSSI__WIDTH                       7
#define TIMING_CONTROL_5__LONG_SC_THRESH_HI_RSSI__MASK              0x3f800000U
#define TIMING_CONTROL_5__LONG_SC_THRESH_HI_RSSI__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x3f800000U) >> 23)
#define TIMING_CONTROL_5__LONG_SC_THRESH_HI_RSSI__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 23) & 0x3f800000U)
#define TIMING_CONTROL_5__LONG_SC_THRESH_HI_RSSI__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x3f800000U) | (((u_int32_t)(src) <<\
                    23) & 0x3f800000U)
#define TIMING_CONTROL_5__LONG_SC_THRESH_HI_RSSI__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 23) & ~0x3f800000U)))
#define TIMING_CONTROL_5__TYPE                                        u_int32_t
#define TIMING_CONTROL_5__READ                                      0x3fff80ffU
#define TIMING_CONTROL_5__WRITE                                     0x3fff80ffU

#endif /* __TIMING_CONTROL_5_MACRO__ */


/* macros for bb_reg_map.bb_chn_reg_map.BB_timing_control_5 */
#define INST_BB_REG_MAP__BB_CHN_REG_MAP__BB_TIMING_CONTROL_5__NUM             1

/* macros for BlueprintGlobalNameSpace::timing_control_6 */
#ifndef __TIMING_CONTROL_6_MACRO__
#define __TIMING_CONTROL_6_MACRO__

/* macros for field hi_rssi_thresh */
#define TIMING_CONTROL_6__HI_RSSI_THRESH__SHIFT                               0
#define TIMING_CONTROL_6__HI_RSSI_THRESH__WIDTH                               8
#define TIMING_CONTROL_6__HI_RSSI_THRESH__MASK                      0x000000ffU
#define TIMING_CONTROL_6__HI_RSSI_THRESH__READ(src) \
                    (u_int32_t)(src)\
                    & 0x000000ffU
#define TIMING_CONTROL_6__HI_RSSI_THRESH__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x000000ffU)
#define TIMING_CONTROL_6__HI_RSSI_THRESH__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000000ffU) | ((u_int32_t)(src) &\
                    0x000000ffU)
#define TIMING_CONTROL_6__HI_RSSI_THRESH__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x000000ffU)))

/* macros for field early_trigger_thr_hi_rssi */
#define TIMING_CONTROL_6__EARLY_TRIGGER_THR_HI_RSSI__SHIFT                    8
#define TIMING_CONTROL_6__EARLY_TRIGGER_THR_HI_RSSI__WIDTH                    7
#define TIMING_CONTROL_6__EARLY_TRIGGER_THR_HI_RSSI__MASK           0x00007f00U
#define TIMING_CONTROL_6__EARLY_TRIGGER_THR_HI_RSSI__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00007f00U) >> 8)
#define TIMING_CONTROL_6__EARLY_TRIGGER_THR_HI_RSSI__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 8) & 0x00007f00U)
#define TIMING_CONTROL_6__EARLY_TRIGGER_THR_HI_RSSI__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00007f00U) | (((u_int32_t)(src) <<\
                    8) & 0x00007f00U)
#define TIMING_CONTROL_6__EARLY_TRIGGER_THR_HI_RSSI__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 8) & ~0x00007f00U)))

/* macros for field ofdm_xcorr_thresh */
#define TIMING_CONTROL_6__OFDM_XCORR_THRESH__SHIFT                           15
#define TIMING_CONTROL_6__OFDM_XCORR_THRESH__WIDTH                            6
#define TIMING_CONTROL_6__OFDM_XCORR_THRESH__MASK                   0x001f8000U
#define TIMING_CONTROL_6__OFDM_XCORR_THRESH__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x001f8000U) >> 15)
#define TIMING_CONTROL_6__OFDM_XCORR_THRESH__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 15) & 0x001f8000U)
#define TIMING_CONTROL_6__OFDM_XCORR_THRESH__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x001f8000U) | (((u_int32_t)(src) <<\
                    15) & 0x001f8000U)
#define TIMING_CONTROL_6__OFDM_XCORR_THRESH__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 15) & ~0x001f8000U)))

/* macros for field ofdm_xcorr_thresh_hi_rssi */
#define TIMING_CONTROL_6__OFDM_XCORR_THRESH_HI_RSSI__SHIFT                   21
#define TIMING_CONTROL_6__OFDM_XCORR_THRESH_HI_RSSI__WIDTH                    7
#define TIMING_CONTROL_6__OFDM_XCORR_THRESH_HI_RSSI__MASK           0x0fe00000U
#define TIMING_CONTROL_6__OFDM_XCORR_THRESH_HI_RSSI__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0fe00000U) >> 21)
#define TIMING_CONTROL_6__OFDM_XCORR_THRESH_HI_RSSI__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 21) & 0x0fe00000U)
#define TIMING_CONTROL_6__OFDM_XCORR_THRESH_HI_RSSI__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0fe00000U) | (((u_int32_t)(src) <<\
                    21) & 0x0fe00000U)
#define TIMING_CONTROL_6__OFDM_XCORR_THRESH_HI_RSSI__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 21) & ~0x0fe00000U)))

/* macros for field add_back_ofdm_dc_cck_bw20 */
#define TIMING_CONTROL_6__ADD_BACK_OFDM_DC_CCK_BW20__SHIFT                   28
#define TIMING_CONTROL_6__ADD_BACK_OFDM_DC_CCK_BW20__WIDTH                    1
#define TIMING_CONTROL_6__ADD_BACK_OFDM_DC_CCK_BW20__MASK           0x10000000U
#define TIMING_CONTROL_6__ADD_BACK_OFDM_DC_CCK_BW20__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x10000000U) >> 28)
#define TIMING_CONTROL_6__ADD_BACK_OFDM_DC_CCK_BW20__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x10000000U) | ((u_int32_t)(1) << 28)
#define TIMING_CONTROL_6__ADD_BACK_OFDM_DC_CCK_BW20__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x10000000U) | ((u_int32_t)(0) << 28)

/* macros for field add_back_ofdm_dc_cck_bw40 */
#define TIMING_CONTROL_6__ADD_BACK_OFDM_DC_CCK_BW40__SHIFT                   29
#define TIMING_CONTROL_6__ADD_BACK_OFDM_DC_CCK_BW40__WIDTH                    1
#define TIMING_CONTROL_6__ADD_BACK_OFDM_DC_CCK_BW40__MASK           0x20000000U
#define TIMING_CONTROL_6__ADD_BACK_OFDM_DC_CCK_BW40__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x20000000U) >> 29)
#define TIMING_CONTROL_6__ADD_BACK_OFDM_DC_CCK_BW40__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x20000000U) | ((u_int32_t)(1) << 29)
#define TIMING_CONTROL_6__ADD_BACK_OFDM_DC_CCK_BW40__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x20000000U) | ((u_int32_t)(0) << 29)
#define TIMING_CONTROL_6__TYPE                                        u_int32_t
#define TIMING_CONTROL_6__READ                                      0x3fffffffU
#define TIMING_CONTROL_6__WRITE                                     0x3fffffffU

#endif /* __TIMING_CONTROL_6_MACRO__ */


/* macros for bb_reg_map.bb_chn_reg_map.BB_timing_control_6 */
#define INST_BB_REG_MAP__BB_CHN_REG_MAP__BB_TIMING_CONTROL_6__NUM             1

/* macros for BlueprintGlobalNameSpace::timing_control_11 */
#ifndef __TIMING_CONTROL_11_MACRO__
#define __TIMING_CONTROL_11_MACRO__

/* macros for field spur_freq_sd */
#define TIMING_CONTROL_11__SPUR_FREQ_SD__SHIFT                               20
#define TIMING_CONTROL_11__SPUR_FREQ_SD__WIDTH                               10
#define TIMING_CONTROL_11__SPUR_FREQ_SD__MASK                       0x3ff00000U
#define TIMING_CONTROL_11__SPUR_FREQ_SD__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x3ff00000U) >> 20)
#define TIMING_CONTROL_11__SPUR_FREQ_SD__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 20) & 0x3ff00000U)
#define TIMING_CONTROL_11__SPUR_FREQ_SD__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x3ff00000U) | (((u_int32_t)(src) <<\
                    20) & 0x3ff00000U)
#define TIMING_CONTROL_11__SPUR_FREQ_SD__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 20) & ~0x3ff00000U)))

/* macros for field use_spur_filter_in_agc */
#define TIMING_CONTROL_11__USE_SPUR_FILTER_IN_AGC__SHIFT                     30
#define TIMING_CONTROL_11__USE_SPUR_FILTER_IN_AGC__WIDTH                      1
#define TIMING_CONTROL_11__USE_SPUR_FILTER_IN_AGC__MASK             0x40000000U
#define TIMING_CONTROL_11__USE_SPUR_FILTER_IN_AGC__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x40000000U) >> 30)
#define TIMING_CONTROL_11__USE_SPUR_FILTER_IN_AGC__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 30) & 0x40000000U)
#define TIMING_CONTROL_11__USE_SPUR_FILTER_IN_AGC__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x40000000U) | (((u_int32_t)(src) <<\
                    30) & 0x40000000U)
#define TIMING_CONTROL_11__USE_SPUR_FILTER_IN_AGC__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 30) & ~0x40000000U)))
#define TIMING_CONTROL_11__USE_SPUR_FILTER_IN_AGC__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x40000000U) | ((u_int32_t)(1) << 30)
#define TIMING_CONTROL_11__USE_SPUR_FILTER_IN_AGC__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x40000000U) | ((u_int32_t)(0) << 30)

/* macros for field use_spur_filter_in_selfcor */
#define TIMING_CONTROL_11__USE_SPUR_FILTER_IN_SELFCOR__SHIFT                 31
#define TIMING_CONTROL_11__USE_SPUR_FILTER_IN_SELFCOR__WIDTH                  1
#define TIMING_CONTROL_11__USE_SPUR_FILTER_IN_SELFCOR__MASK         0x80000000U
#define TIMING_CONTROL_11__USE_SPUR_FILTER_IN_SELFCOR__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x80000000U) >> 31)
#define TIMING_CONTROL_11__USE_SPUR_FILTER_IN_SELFCOR__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 31) & 0x80000000U)
#define TIMING_CONTROL_11__USE_SPUR_FILTER_IN_SELFCOR__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x80000000U) | (((u_int32_t)(src) <<\
                    31) & 0x80000000U)
#define TIMING_CONTROL_11__USE_SPUR_FILTER_IN_SELFCOR__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 31) & ~0x80000000U)))
#define TIMING_CONTROL_11__USE_SPUR_FILTER_IN_SELFCOR__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x80000000U) | ((u_int32_t)(1) << 31)
#define TIMING_CONTROL_11__USE_SPUR_FILTER_IN_SELFCOR__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x80000000U) | ((u_int32_t)(0) << 31)
#define TIMING_CONTROL_11__TYPE                                       u_int32_t
#define TIMING_CONTROL_11__READ                                     0xfff00000U
#define TIMING_CONTROL_11__WRITE                                    0xfff00000U

#endif /* __TIMING_CONTROL_11_MACRO__ */


/* macros for bb_reg_map.bb_chn_reg_map.BB_timing_control_11 */
#define INST_BB_REG_MAP__BB_CHN_REG_MAP__BB_TIMING_CONTROL_11__NUM            1

/* macros for BlueprintGlobalNameSpace::spur_mask_controls */
#ifndef __SPUR_MASK_CONTROLS_MACRO__
#define __SPUR_MASK_CONTROLS_MACRO__

/* macros for field spur_rssi_thresh */
#define SPUR_MASK_CONTROLS__SPUR_RSSI_THRESH__SHIFT                           0
#define SPUR_MASK_CONTROLS__SPUR_RSSI_THRESH__WIDTH                           8
#define SPUR_MASK_CONTROLS__SPUR_RSSI_THRESH__MASK                  0x000000ffU
#define SPUR_MASK_CONTROLS__SPUR_RSSI_THRESH__READ(src) \
                    (u_int32_t)(src)\
                    & 0x000000ffU
#define SPUR_MASK_CONTROLS__SPUR_RSSI_THRESH__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x000000ffU)
#define SPUR_MASK_CONTROLS__SPUR_RSSI_THRESH__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000000ffU) | ((u_int32_t)(src) &\
                    0x000000ffU)
#define SPUR_MASK_CONTROLS__SPUR_RSSI_THRESH__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x000000ffU)))

/* macros for field en_vit_spur_rssi */
#define SPUR_MASK_CONTROLS__EN_VIT_SPUR_RSSI__SHIFT                           8
#define SPUR_MASK_CONTROLS__EN_VIT_SPUR_RSSI__WIDTH                           1
#define SPUR_MASK_CONTROLS__EN_VIT_SPUR_RSSI__MASK                  0x00000100U
#define SPUR_MASK_CONTROLS__EN_VIT_SPUR_RSSI__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000100U) >> 8)
#define SPUR_MASK_CONTROLS__EN_VIT_SPUR_RSSI__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 8) & 0x00000100U)
#define SPUR_MASK_CONTROLS__EN_VIT_SPUR_RSSI__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000100U) | (((u_int32_t)(src) <<\
                    8) & 0x00000100U)
#define SPUR_MASK_CONTROLS__EN_VIT_SPUR_RSSI__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 8) & ~0x00000100U)))
#define SPUR_MASK_CONTROLS__EN_VIT_SPUR_RSSI__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000100U) | ((u_int32_t)(1) << 8)
#define SPUR_MASK_CONTROLS__EN_VIT_SPUR_RSSI__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000100U) | ((u_int32_t)(0) << 8)

/* macros for field enable_mask_ppm */
#define SPUR_MASK_CONTROLS__ENABLE_MASK_PPM__SHIFT                           17
#define SPUR_MASK_CONTROLS__ENABLE_MASK_PPM__WIDTH                            1
#define SPUR_MASK_CONTROLS__ENABLE_MASK_PPM__MASK                   0x00020000U
#define SPUR_MASK_CONTROLS__ENABLE_MASK_PPM__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00020000U) >> 17)
#define SPUR_MASK_CONTROLS__ENABLE_MASK_PPM__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 17) & 0x00020000U)
#define SPUR_MASK_CONTROLS__ENABLE_MASK_PPM__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00020000U) | (((u_int32_t)(src) <<\
                    17) & 0x00020000U)
#define SPUR_MASK_CONTROLS__ENABLE_MASK_PPM__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 17) & ~0x00020000U)))
#define SPUR_MASK_CONTROLS__ENABLE_MASK_PPM__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00020000U) | ((u_int32_t)(1) << 17)
#define SPUR_MASK_CONTROLS__ENABLE_MASK_PPM__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00020000U) | ((u_int32_t)(0) << 17)

/* macros for field mask_rate_cntl */
#define SPUR_MASK_CONTROLS__MASK_RATE_CNTL__SHIFT                            18
#define SPUR_MASK_CONTROLS__MASK_RATE_CNTL__WIDTH                             8
#define SPUR_MASK_CONTROLS__MASK_RATE_CNTL__MASK                    0x03fc0000U
#define SPUR_MASK_CONTROLS__MASK_RATE_CNTL__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x03fc0000U) >> 18)
#define SPUR_MASK_CONTROLS__MASK_RATE_CNTL__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 18) & 0x03fc0000U)
#define SPUR_MASK_CONTROLS__MASK_RATE_CNTL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x03fc0000U) | (((u_int32_t)(src) <<\
                    18) & 0x03fc0000U)
#define SPUR_MASK_CONTROLS__MASK_RATE_CNTL__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 18) & ~0x03fc0000U)))

/* macros for field enable_nf_rssi_spur_mit */
#define SPUR_MASK_CONTROLS__ENABLE_NF_RSSI_SPUR_MIT__SHIFT                   26
#define SPUR_MASK_CONTROLS__ENABLE_NF_RSSI_SPUR_MIT__WIDTH                    1
#define SPUR_MASK_CONTROLS__ENABLE_NF_RSSI_SPUR_MIT__MASK           0x04000000U
#define SPUR_MASK_CONTROLS__ENABLE_NF_RSSI_SPUR_MIT__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x04000000U) >> 26)
#define SPUR_MASK_CONTROLS__ENABLE_NF_RSSI_SPUR_MIT__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 26) & 0x04000000U)
#define SPUR_MASK_CONTROLS__ENABLE_NF_RSSI_SPUR_MIT__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x04000000U) | (((u_int32_t)(src) <<\
                    26) & 0x04000000U)
#define SPUR_MASK_CONTROLS__ENABLE_NF_RSSI_SPUR_MIT__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 26) & ~0x04000000U)))
#define SPUR_MASK_CONTROLS__ENABLE_NF_RSSI_SPUR_MIT__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x04000000U) | ((u_int32_t)(1) << 26)
#define SPUR_MASK_CONTROLS__ENABLE_NF_RSSI_SPUR_MIT__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x04000000U) | ((u_int32_t)(0) << 26)
#define SPUR_MASK_CONTROLS__TYPE                                      u_int32_t
#define SPUR_MASK_CONTROLS__READ                                    0x07fe01ffU
#define SPUR_MASK_CONTROLS__WRITE                                   0x07fe01ffU

#endif /* __SPUR_MASK_CONTROLS_MACRO__ */


/* macros for bb_reg_map.bb_chn_reg_map.BB_spur_mask_controls */
#define INST_BB_REG_MAP__BB_CHN_REG_MAP__BB_SPUR_MASK_CONTROLS__NUM           1

/* macros for BlueprintGlobalNameSpace::find_signal_low */
#ifndef __FIND_SIGNAL_LOW_MACRO__
#define __FIND_SIGNAL_LOW_MACRO__

/* macros for field relstep_low */
#define FIND_SIGNAL_LOW__RELSTEP_LOW__SHIFT                                   0
#define FIND_SIGNAL_LOW__RELSTEP_LOW__WIDTH                                   6
#define FIND_SIGNAL_LOW__RELSTEP_LOW__MASK                          0x0000003fU
#define FIND_SIGNAL_LOW__RELSTEP_LOW__READ(src)  (u_int32_t)(src) & 0x0000003fU
#define FIND_SIGNAL_LOW__RELSTEP_LOW__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x0000003fU)
#define FIND_SIGNAL_LOW__RELSTEP_LOW__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000003fU) | ((u_int32_t)(src) &\
                    0x0000003fU)
#define FIND_SIGNAL_LOW__RELSTEP_LOW__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x0000003fU)))

/* macros for field firstep_low */
#define FIND_SIGNAL_LOW__FIRSTEP_LOW__SHIFT                                   6
#define FIND_SIGNAL_LOW__FIRSTEP_LOW__WIDTH                                   6
#define FIND_SIGNAL_LOW__FIRSTEP_LOW__MASK                          0x00000fc0U
#define FIND_SIGNAL_LOW__FIRSTEP_LOW__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000fc0U) >> 6)
#define FIND_SIGNAL_LOW__FIRSTEP_LOW__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 6) & 0x00000fc0U)
#define FIND_SIGNAL_LOW__FIRSTEP_LOW__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000fc0U) | (((u_int32_t)(src) <<\
                    6) & 0x00000fc0U)
#define FIND_SIGNAL_LOW__FIRSTEP_LOW__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 6) & ~0x00000fc0U)))

/* macros for field firpwr_low */
#define FIND_SIGNAL_LOW__FIRPWR_LOW__SHIFT                                   12
#define FIND_SIGNAL_LOW__FIRPWR_LOW__WIDTH                                    8
#define FIND_SIGNAL_LOW__FIRPWR_LOW__MASK                           0x000ff000U
#define FIND_SIGNAL_LOW__FIRPWR_LOW__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x000ff000U) >> 12)
#define FIND_SIGNAL_LOW__FIRPWR_LOW__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 12) & 0x000ff000U)
#define FIND_SIGNAL_LOW__FIRPWR_LOW__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000ff000U) | (((u_int32_t)(src) <<\
                    12) & 0x000ff000U)
#define FIND_SIGNAL_LOW__FIRPWR_LOW__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 12) & ~0x000ff000U)))

/* macros for field ycok_max_low */
#define FIND_SIGNAL_LOW__YCOK_MAX_LOW__SHIFT                                 20
#define FIND_SIGNAL_LOW__YCOK_MAX_LOW__WIDTH                                  4
#define FIND_SIGNAL_LOW__YCOK_MAX_LOW__MASK                         0x00f00000U
#define FIND_SIGNAL_LOW__YCOK_MAX_LOW__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00f00000U) >> 20)
#define FIND_SIGNAL_LOW__YCOK_MAX_LOW__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 20) & 0x00f00000U)
#define FIND_SIGNAL_LOW__YCOK_MAX_LOW__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00f00000U) | (((u_int32_t)(src) <<\
                    20) & 0x00f00000U)
#define FIND_SIGNAL_LOW__YCOK_MAX_LOW__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 20) & ~0x00f00000U)))

/* macros for field long_sc_thresh */
#define FIND_SIGNAL_LOW__LONG_SC_THRESH__SHIFT                               24
#define FIND_SIGNAL_LOW__LONG_SC_THRESH__WIDTH                                7
#define FIND_SIGNAL_LOW__LONG_SC_THRESH__MASK                       0x7f000000U
#define FIND_SIGNAL_LOW__LONG_SC_THRESH__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x7f000000U) >> 24)
#define FIND_SIGNAL_LOW__LONG_SC_THRESH__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 24) & 0x7f000000U)
#define FIND_SIGNAL_LOW__LONG_SC_THRESH__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x7f000000U) | (((u_int32_t)(src) <<\
                    24) & 0x7f000000U)
#define FIND_SIGNAL_LOW__LONG_SC_THRESH__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 24) & ~0x7f000000U)))
#define FIND_SIGNAL_LOW__TYPE                                         u_int32_t
#define FIND_SIGNAL_LOW__READ                                       0x7fffffffU
#define FIND_SIGNAL_LOW__WRITE                                      0x7fffffffU

#endif /* __FIND_SIGNAL_LOW_MACRO__ */


/* macros for bb_reg_map.bb_chn_reg_map.BB_find_signal_low */
#define INST_BB_REG_MAP__BB_CHN_REG_MAP__BB_FIND_SIGNAL_LOW__NUM              1

/* macros for BlueprintGlobalNameSpace::sfcorr */
#ifndef __SFCORR_MACRO__
#define __SFCORR_MACRO__

/* macros for field m2count_thr */
#define SFCORR__M2COUNT_THR__SHIFT                                            0
#define SFCORR__M2COUNT_THR__WIDTH                                            5
#define SFCORR__M2COUNT_THR__MASK                                   0x0000001fU
#define SFCORR__M2COUNT_THR__READ(src)           (u_int32_t)(src) & 0x0000001fU
#define SFCORR__M2COUNT_THR__WRITE(src)        ((u_int32_t)(src) & 0x0000001fU)
#define SFCORR__M2COUNT_THR__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000001fU) | ((u_int32_t)(src) &\
                    0x0000001fU)
#define SFCORR__M2COUNT_THR__VERIFY(src) (!(((u_int32_t)(src) & ~0x0000001fU)))

/* macros for field m1_thres */
#define SFCORR__M1_THRES__SHIFT                                              17
#define SFCORR__M1_THRES__WIDTH                                               7
#define SFCORR__M1_THRES__MASK                                      0x00fe0000U
#define SFCORR__M1_THRES__READ(src)    (((u_int32_t)(src) & 0x00fe0000U) >> 17)
#define SFCORR__M1_THRES__WRITE(src)   (((u_int32_t)(src) << 17) & 0x00fe0000U)
#define SFCORR__M1_THRES__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00fe0000U) | (((u_int32_t)(src) <<\
                    17) & 0x00fe0000U)
#define SFCORR__M1_THRES__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 17) & ~0x00fe0000U)))

/* macros for field m2_thres */
#define SFCORR__M2_THRES__SHIFT                                              24
#define SFCORR__M2_THRES__WIDTH                                               7
#define SFCORR__M2_THRES__MASK                                      0x7f000000U
#define SFCORR__M2_THRES__READ(src)    (((u_int32_t)(src) & 0x7f000000U) >> 24)
#define SFCORR__M2_THRES__WRITE(src)   (((u_int32_t)(src) << 24) & 0x7f000000U)
#define SFCORR__M2_THRES__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x7f000000U) | (((u_int32_t)(src) <<\
                    24) & 0x7f000000U)
#define SFCORR__M2_THRES__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 24) & ~0x7f000000U)))
#define SFCORR__TYPE                                                  u_int32_t
#define SFCORR__READ                                                0x7ffe001fU
#define SFCORR__WRITE                                               0x7ffe001fU

#endif /* __SFCORR_MACRO__ */


/* macros for bb_reg_map.bb_chn_reg_map.BB_sfcorr */
#define INST_BB_REG_MAP__BB_CHN_REG_MAP__BB_SFCORR__NUM                       1

/* macros for BlueprintGlobalNameSpace::self_corr_low */
#ifndef __SELF_CORR_LOW_MACRO__
#define __SELF_CORR_LOW_MACRO__

/* macros for field use_self_corr_low */
#define SELF_CORR_LOW__USE_SELF_CORR_LOW__SHIFT                               0
#define SELF_CORR_LOW__USE_SELF_CORR_LOW__WIDTH                               1
#define SELF_CORR_LOW__USE_SELF_CORR_LOW__MASK                      0x00000001U
#define SELF_CORR_LOW__USE_SELF_CORR_LOW__READ(src) \
                    (u_int32_t)(src)\
                    & 0x00000001U
#define SELF_CORR_LOW__USE_SELF_CORR_LOW__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x00000001U)
#define SELF_CORR_LOW__USE_SELF_CORR_LOW__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | ((u_int32_t)(src) &\
                    0x00000001U)
#define SELF_CORR_LOW__USE_SELF_CORR_LOW__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00000001U)))
#define SELF_CORR_LOW__USE_SELF_CORR_LOW__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(1)
#define SELF_CORR_LOW__USE_SELF_CORR_LOW__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(0)

/* macros for field m1count_max_low */
#define SELF_CORR_LOW__M1COUNT_MAX_LOW__SHIFT                                 1
#define SELF_CORR_LOW__M1COUNT_MAX_LOW__WIDTH                                 7
#define SELF_CORR_LOW__M1COUNT_MAX_LOW__MASK                        0x000000feU
#define SELF_CORR_LOW__M1COUNT_MAX_LOW__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x000000feU) >> 1)
#define SELF_CORR_LOW__M1COUNT_MAX_LOW__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 1) & 0x000000feU)
#define SELF_CORR_LOW__M1COUNT_MAX_LOW__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000000feU) | (((u_int32_t)(src) <<\
                    1) & 0x000000feU)
#define SELF_CORR_LOW__M1COUNT_MAX_LOW__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 1) & ~0x000000feU)))

/* macros for field m2count_thr_low */
#define SELF_CORR_LOW__M2COUNT_THR_LOW__SHIFT                                 8
#define SELF_CORR_LOW__M2COUNT_THR_LOW__WIDTH                                 6
#define SELF_CORR_LOW__M2COUNT_THR_LOW__MASK                        0x00003f00U
#define SELF_CORR_LOW__M2COUNT_THR_LOW__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00003f00U) >> 8)
#define SELF_CORR_LOW__M2COUNT_THR_LOW__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 8) & 0x00003f00U)
#define SELF_CORR_LOW__M2COUNT_THR_LOW__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00003f00U) | (((u_int32_t)(src) <<\
                    8) & 0x00003f00U)
#define SELF_CORR_LOW__M2COUNT_THR_LOW__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 8) & ~0x00003f00U)))

/* macros for field m1_thresh_low */
#define SELF_CORR_LOW__M1_THRESH_LOW__SHIFT                                  14
#define SELF_CORR_LOW__M1_THRESH_LOW__WIDTH                                   7
#define SELF_CORR_LOW__M1_THRESH_LOW__MASK                          0x001fc000U
#define SELF_CORR_LOW__M1_THRESH_LOW__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x001fc000U) >> 14)
#define SELF_CORR_LOW__M1_THRESH_LOW__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 14) & 0x001fc000U)
#define SELF_CORR_LOW__M1_THRESH_LOW__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x001fc000U) | (((u_int32_t)(src) <<\
                    14) & 0x001fc000U)
#define SELF_CORR_LOW__M1_THRESH_LOW__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 14) & ~0x001fc000U)))

/* macros for field m2_thresh_low */
#define SELF_CORR_LOW__M2_THRESH_LOW__SHIFT                                  21
#define SELF_CORR_LOW__M2_THRESH_LOW__WIDTH                                   7
#define SELF_CORR_LOW__M2_THRESH_LOW__MASK                          0x0fe00000U
#define SELF_CORR_LOW__M2_THRESH_LOW__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0fe00000U) >> 21)
#define SELF_CORR_LOW__M2_THRESH_LOW__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 21) & 0x0fe00000U)
#define SELF_CORR_LOW__M2_THRESH_LOW__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0fe00000U) | (((u_int32_t)(src) <<\
                    21) & 0x0fe00000U)
#define SELF_CORR_LOW__M2_THRESH_LOW__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 21) & ~0x0fe00000U)))
#define SELF_CORR_LOW__TYPE                                           u_int32_t
#define SELF_CORR_LOW__READ                                         0x0fffffffU
#define SELF_CORR_LOW__WRITE                                        0x0fffffffU

#endif /* __SELF_CORR_LOW_MACRO__ */


/* macros for bb_reg_map.bb_chn_reg_map.BB_self_corr_low */
#define INST_BB_REG_MAP__BB_CHN_REG_MAP__BB_SELF_CORR_LOW__NUM                1

/* macros for BlueprintGlobalNameSpace::timing_control_13 */
#ifndef __TIMING_CONTROL_13_MACRO__
#define __TIMING_CONTROL_13_MACRO__

/* macros for field timing_backoff_low_rssi */
#define TIMING_CONTROL_13__TIMING_BACKOFF_LOW_RSSI__SHIFT                     0
#define TIMING_CONTROL_13__TIMING_BACKOFF_LOW_RSSI__WIDTH                     5
#define TIMING_CONTROL_13__TIMING_BACKOFF_LOW_RSSI__MASK            0x0000001fU
#define TIMING_CONTROL_13__TIMING_BACKOFF_LOW_RSSI__READ(src) \
                    (u_int32_t)(src)\
                    & 0x0000001fU
#define TIMING_CONTROL_13__TIMING_BACKOFF_LOW_RSSI__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x0000001fU)
#define TIMING_CONTROL_13__TIMING_BACKOFF_LOW_RSSI__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000001fU) | ((u_int32_t)(src) &\
                    0x0000001fU)
#define TIMING_CONTROL_13__TIMING_BACKOFF_LOW_RSSI__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x0000001fU)))

/* macros for field timing_backoff_mid_rssi */
#define TIMING_CONTROL_13__TIMING_BACKOFF_MID_RSSI__SHIFT                     5
#define TIMING_CONTROL_13__TIMING_BACKOFF_MID_RSSI__WIDTH                     5
#define TIMING_CONTROL_13__TIMING_BACKOFF_MID_RSSI__MASK            0x000003e0U
#define TIMING_CONTROL_13__TIMING_BACKOFF_MID_RSSI__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x000003e0U) >> 5)
#define TIMING_CONTROL_13__TIMING_BACKOFF_MID_RSSI__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 5) & 0x000003e0U)
#define TIMING_CONTROL_13__TIMING_BACKOFF_MID_RSSI__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000003e0U) | (((u_int32_t)(src) <<\
                    5) & 0x000003e0U)
#define TIMING_CONTROL_13__TIMING_BACKOFF_MID_RSSI__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 5) & ~0x000003e0U)))

/* macros for field timing_backoff_high_rssi */
#define TIMING_CONTROL_13__TIMING_BACKOFF_HIGH_RSSI__SHIFT                   10
#define TIMING_CONTROL_13__TIMING_BACKOFF_HIGH_RSSI__WIDTH                    5
#define TIMING_CONTROL_13__TIMING_BACKOFF_HIGH_RSSI__MASK           0x00007c00U
#define TIMING_CONTROL_13__TIMING_BACKOFF_HIGH_RSSI__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00007c00U) >> 10)
#define TIMING_CONTROL_13__TIMING_BACKOFF_HIGH_RSSI__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 10) & 0x00007c00U)
#define TIMING_CONTROL_13__TIMING_BACKOFF_HIGH_RSSI__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00007c00U) | (((u_int32_t)(src) <<\
                    10) & 0x00007c00U)
#define TIMING_CONTROL_13__TIMING_BACKOFF_HIGH_RSSI__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 10) & ~0x00007c00U)))

/* macros for field tb_rssi_th1 */
#define TIMING_CONTROL_13__TB_RSSI_TH1__SHIFT                                15
#define TIMING_CONTROL_13__TB_RSSI_TH1__WIDTH                                 8
#define TIMING_CONTROL_13__TB_RSSI_TH1__MASK                        0x007f8000U
#define TIMING_CONTROL_13__TB_RSSI_TH1__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x007f8000U) >> 15)
#define TIMING_CONTROL_13__TB_RSSI_TH1__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 15) & 0x007f8000U)
#define TIMING_CONTROL_13__TB_RSSI_TH1__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x007f8000U) | (((u_int32_t)(src) <<\
                    15) & 0x007f8000U)
#define TIMING_CONTROL_13__TB_RSSI_TH1__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 15) & ~0x007f8000U)))

/* macros for field tb_rssi_th2 */
#define TIMING_CONTROL_13__TB_RSSI_TH2__SHIFT                                23
#define TIMING_CONTROL_13__TB_RSSI_TH2__WIDTH                                 8
#define TIMING_CONTROL_13__TB_RSSI_TH2__MASK                        0x7f800000U
#define TIMING_CONTROL_13__TB_RSSI_TH2__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x7f800000U) >> 23)
#define TIMING_CONTROL_13__TB_RSSI_TH2__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 23) & 0x7f800000U)
#define TIMING_CONTROL_13__TB_RSSI_TH2__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x7f800000U) | (((u_int32_t)(src) <<\
                    23) & 0x7f800000U)
#define TIMING_CONTROL_13__TB_RSSI_TH2__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 23) & ~0x7f800000U)))
#define TIMING_CONTROL_13__TYPE                                       u_int32_t
#define TIMING_CONTROL_13__READ                                     0x7fffffffU
#define TIMING_CONTROL_13__WRITE                                    0x7fffffffU

#endif /* __TIMING_CONTROL_13_MACRO__ */


/* macros for bb_reg_map.bb_chn_reg_map.BB_timing_control_13 */
#define INST_BB_REG_MAP__BB_CHN_REG_MAP__BB_TIMING_CONTROL_13__NUM            1

/* macros for BlueprintGlobalNameSpace::radar_detection */
#ifndef __RADAR_DETECTION_MACRO__
#define __RADAR_DETECTION_MACRO__

/* macros for field pulse_detect_enable */
#define RADAR_DETECTION__PULSE_DETECT_ENABLE__SHIFT                           0
#define RADAR_DETECTION__PULSE_DETECT_ENABLE__WIDTH                           1
#define RADAR_DETECTION__PULSE_DETECT_ENABLE__MASK                  0x00000001U
#define RADAR_DETECTION__PULSE_DETECT_ENABLE__READ(src) \
                    (u_int32_t)(src)\
                    & 0x00000001U
#define RADAR_DETECTION__PULSE_DETECT_ENABLE__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x00000001U)
#define RADAR_DETECTION__PULSE_DETECT_ENABLE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | ((u_int32_t)(src) &\
                    0x00000001U)
#define RADAR_DETECTION__PULSE_DETECT_ENABLE__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00000001U)))
#define RADAR_DETECTION__PULSE_DETECT_ENABLE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(1)
#define RADAR_DETECTION__PULSE_DETECT_ENABLE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(0)

/* macros for field dfs_pri80_enable */
#define RADAR_DETECTION__DFS_PRI80_ENABLE__SHIFT                              1
#define RADAR_DETECTION__DFS_PRI80_ENABLE__WIDTH                              1
#define RADAR_DETECTION__DFS_PRI80_ENABLE__MASK                     0x00000002U
#define RADAR_DETECTION__DFS_PRI80_ENABLE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000002U) >> 1)
#define RADAR_DETECTION__DFS_PRI80_ENABLE__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 1) & 0x00000002U)
#define RADAR_DETECTION__DFS_PRI80_ENABLE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | (((u_int32_t)(src) <<\
                    1) & 0x00000002U)
#define RADAR_DETECTION__DFS_PRI80_ENABLE__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 1) & ~0x00000002U)))
#define RADAR_DETECTION__DFS_PRI80_ENABLE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | ((u_int32_t)(1) << 1)
#define RADAR_DETECTION__DFS_PRI80_ENABLE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | ((u_int32_t)(0) << 1)

/* macros for field dfs_sec80_enable */
#define RADAR_DETECTION__DFS_SEC80_ENABLE__SHIFT                              2
#define RADAR_DETECTION__DFS_SEC80_ENABLE__WIDTH                              1
#define RADAR_DETECTION__DFS_SEC80_ENABLE__MASK                     0x00000004U
#define RADAR_DETECTION__DFS_SEC80_ENABLE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000004U) >> 2)
#define RADAR_DETECTION__DFS_SEC80_ENABLE__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 2) & 0x00000004U)
#define RADAR_DETECTION__DFS_SEC80_ENABLE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000004U) | (((u_int32_t)(src) <<\
                    2) & 0x00000004U)
#define RADAR_DETECTION__DFS_SEC80_ENABLE__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 2) & ~0x00000004U)))
#define RADAR_DETECTION__DFS_SEC80_ENABLE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000004U) | ((u_int32_t)(1) << 2)
#define RADAR_DETECTION__DFS_SEC80_ENABLE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000004U) | ((u_int32_t)(0) << 2)

/* macros for field dfs_restart_ena_pri */
#define RADAR_DETECTION__DFS_RESTART_ENA_PRI__SHIFT                           3
#define RADAR_DETECTION__DFS_RESTART_ENA_PRI__WIDTH                           1
#define RADAR_DETECTION__DFS_RESTART_ENA_PRI__MASK                  0x00000008U
#define RADAR_DETECTION__DFS_RESTART_ENA_PRI__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000008U) >> 3)
#define RADAR_DETECTION__DFS_RESTART_ENA_PRI__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 3) & 0x00000008U)
#define RADAR_DETECTION__DFS_RESTART_ENA_PRI__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000008U) | (((u_int32_t)(src) <<\
                    3) & 0x00000008U)
#define RADAR_DETECTION__DFS_RESTART_ENA_PRI__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 3) & ~0x00000008U)))
#define RADAR_DETECTION__DFS_RESTART_ENA_PRI__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000008U) | ((u_int32_t)(1) << 3)
#define RADAR_DETECTION__DFS_RESTART_ENA_PRI__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000008U) | ((u_int32_t)(0) << 3)

/* macros for field dfs_restart_ena_sec */
#define RADAR_DETECTION__DFS_RESTART_ENA_SEC__SHIFT                           4
#define RADAR_DETECTION__DFS_RESTART_ENA_SEC__WIDTH                           1
#define RADAR_DETECTION__DFS_RESTART_ENA_SEC__MASK                  0x00000010U
#define RADAR_DETECTION__DFS_RESTART_ENA_SEC__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000010U) >> 4)
#define RADAR_DETECTION__DFS_RESTART_ENA_SEC__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 4) & 0x00000010U)
#define RADAR_DETECTION__DFS_RESTART_ENA_SEC__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000010U) | (((u_int32_t)(src) <<\
                    4) & 0x00000010U)
#define RADAR_DETECTION__DFS_RESTART_ENA_SEC__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 4) & ~0x00000010U)))
#define RADAR_DETECTION__DFS_RESTART_ENA_SEC__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000010U) | ((u_int32_t)(1) << 4)
#define RADAR_DETECTION__DFS_RESTART_ENA_SEC__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000010U) | ((u_int32_t)(0) << 4)

/* macros for field fft_check_coarse_ena */
#define RADAR_DETECTION__FFT_CHECK_COARSE_ENA__SHIFT                          5
#define RADAR_DETECTION__FFT_CHECK_COARSE_ENA__WIDTH                          1
#define RADAR_DETECTION__FFT_CHECK_COARSE_ENA__MASK                 0x00000020U
#define RADAR_DETECTION__FFT_CHECK_COARSE_ENA__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000020U) >> 5)
#define RADAR_DETECTION__FFT_CHECK_COARSE_ENA__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 5) & 0x00000020U)
#define RADAR_DETECTION__FFT_CHECK_COARSE_ENA__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000020U) | (((u_int32_t)(src) <<\
                    5) & 0x00000020U)
#define RADAR_DETECTION__FFT_CHECK_COARSE_ENA__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 5) & ~0x00000020U)))
#define RADAR_DETECTION__FFT_CHECK_COARSE_ENA__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000020U) | ((u_int32_t)(1) << 5)
#define RADAR_DETECTION__FFT_CHECK_COARSE_ENA__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000020U) | ((u_int32_t)(0) << 5)

/* macros for field pulse_rssi_thresh */
#define RADAR_DETECTION__PULSE_RSSI_THRESH__SHIFT                             6
#define RADAR_DETECTION__PULSE_RSSI_THRESH__WIDTH                             6
#define RADAR_DETECTION__PULSE_RSSI_THRESH__MASK                    0x00000fc0U
#define RADAR_DETECTION__PULSE_RSSI_THRESH__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000fc0U) >> 6)
#define RADAR_DETECTION__PULSE_RSSI_THRESH__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 6) & 0x00000fc0U)
#define RADAR_DETECTION__PULSE_RSSI_THRESH__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000fc0U) | (((u_int32_t)(src) <<\
                    6) & 0x00000fc0U)
#define RADAR_DETECTION__PULSE_RSSI_THRESH__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 6) & ~0x00000fc0U)))

/* macros for field pulse_height_thresh */
#define RADAR_DETECTION__PULSE_HEIGHT_THRESH__SHIFT                          12
#define RADAR_DETECTION__PULSE_HEIGHT_THRESH__WIDTH                           6
#define RADAR_DETECTION__PULSE_HEIGHT_THRESH__MASK                  0x0003f000U
#define RADAR_DETECTION__PULSE_HEIGHT_THRESH__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0003f000U) >> 12)
#define RADAR_DETECTION__PULSE_HEIGHT_THRESH__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 12) & 0x0003f000U)
#define RADAR_DETECTION__PULSE_HEIGHT_THRESH__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0003f000U) | (((u_int32_t)(src) <<\
                    12) & 0x0003f000U)
#define RADAR_DETECTION__PULSE_HEIGHT_THRESH__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 12) & ~0x0003f000U)))

/* macros for field pulse_drop_thresh */
#define RADAR_DETECTION__PULSE_DROP_THRESH__SHIFT                            18
#define RADAR_DETECTION__PULSE_DROP_THRESH__WIDTH                             6
#define RADAR_DETECTION__PULSE_DROP_THRESH__MASK                    0x00fc0000U
#define RADAR_DETECTION__PULSE_DROP_THRESH__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00fc0000U) >> 18)
#define RADAR_DETECTION__PULSE_DROP_THRESH__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 18) & 0x00fc0000U)
#define RADAR_DETECTION__PULSE_DROP_THRESH__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00fc0000U) | (((u_int32_t)(src) <<\
                    18) & 0x00fc0000U)
#define RADAR_DETECTION__PULSE_DROP_THRESH__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 18) & ~0x00fc0000U)))

/* macros for field radar_firpwr_thresh */
#define RADAR_DETECTION__RADAR_FIRPWR_THRESH__SHIFT                          24
#define RADAR_DETECTION__RADAR_FIRPWR_THRESH__WIDTH                           7
#define RADAR_DETECTION__RADAR_FIRPWR_THRESH__MASK                  0x7f000000U
#define RADAR_DETECTION__RADAR_FIRPWR_THRESH__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x7f000000U) >> 24)
#define RADAR_DETECTION__RADAR_FIRPWR_THRESH__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 24) & 0x7f000000U)
#define RADAR_DETECTION__RADAR_FIRPWR_THRESH__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x7f000000U) | (((u_int32_t)(src) <<\
                    24) & 0x7f000000U)
#define RADAR_DETECTION__RADAR_FIRPWR_THRESH__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 24) & ~0x7f000000U)))
#define RADAR_DETECTION__TYPE                                         u_int32_t
#define RADAR_DETECTION__READ                                       0x7fffffffU
#define RADAR_DETECTION__WRITE                                      0x7fffffffU

#endif /* __RADAR_DETECTION_MACRO__ */


/* macros for bb_reg_map.bb_chn_reg_map.BB_radar_detection */
#define INST_BB_REG_MAP__BB_CHN_REG_MAP__BB_RADAR_DETECTION__NUM              1

/* macros for BlueprintGlobalNameSpace::radar_detection_2 */
#ifndef __RADAR_DETECTION_2_MACRO__
#define __RADAR_DETECTION_2_MACRO__

/* macros for field pulse_width_max */
#define RADAR_DETECTION_2__PULSE_WIDTH_MAX__SHIFT                             0
#define RADAR_DETECTION_2__PULSE_WIDTH_MAX__WIDTH                             8
#define RADAR_DETECTION_2__PULSE_WIDTH_MAX__MASK                    0x000000ffU
#define RADAR_DETECTION_2__PULSE_WIDTH_MAX__READ(src) \
                    (u_int32_t)(src)\
                    & 0x000000ffU
#define RADAR_DETECTION_2__PULSE_WIDTH_MAX__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x000000ffU)
#define RADAR_DETECTION_2__PULSE_WIDTH_MAX__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000000ffU) | ((u_int32_t)(src) &\
                    0x000000ffU)
#define RADAR_DETECTION_2__PULSE_WIDTH_MAX__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x000000ffU)))

/* macros for field pulse_relstep_thresh */
#define RADAR_DETECTION_2__PULSE_RELSTEP_THRESH__SHIFT                        8
#define RADAR_DETECTION_2__PULSE_RELSTEP_THRESH__WIDTH                        5
#define RADAR_DETECTION_2__PULSE_RELSTEP_THRESH__MASK               0x00001f00U
#define RADAR_DETECTION_2__PULSE_RELSTEP_THRESH__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00001f00U) >> 8)
#define RADAR_DETECTION_2__PULSE_RELSTEP_THRESH__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 8) & 0x00001f00U)
#define RADAR_DETECTION_2__PULSE_RELSTEP_THRESH__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00001f00U) | (((u_int32_t)(src) <<\
                    8) & 0x00001f00U)
#define RADAR_DETECTION_2__PULSE_RELSTEP_THRESH__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 8) & ~0x00001f00U)))

/* macros for field dfs_cont_80p80 */
#define RADAR_DETECTION_2__DFS_CONT_80P80__SHIFT                             13
#define RADAR_DETECTION_2__DFS_CONT_80P80__WIDTH                              1
#define RADAR_DETECTION_2__DFS_CONT_80P80__MASK                     0x00002000U
#define RADAR_DETECTION_2__DFS_CONT_80P80__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00002000U) >> 13)
#define RADAR_DETECTION_2__DFS_CONT_80P80__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 13) & 0x00002000U)
#define RADAR_DETECTION_2__DFS_CONT_80P80__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00002000U) | (((u_int32_t)(src) <<\
                    13) & 0x00002000U)
#define RADAR_DETECTION_2__DFS_CONT_80P80__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 13) & ~0x00002000U)))
#define RADAR_DETECTION_2__DFS_CONT_80P80__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00002000U) | ((u_int32_t)(1) << 13)
#define RADAR_DETECTION_2__DFS_CONT_80P80__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00002000U) | ((u_int32_t)(0) << 13)

/* macros for field pulse_relpwr_thresh */
#define RADAR_DETECTION_2__PULSE_RELPWR_THRESH__SHIFT                        16
#define RADAR_DETECTION_2__PULSE_RELPWR_THRESH__WIDTH                         5
#define RADAR_DETECTION_2__PULSE_RELPWR_THRESH__MASK                0x001f0000U
#define RADAR_DETECTION_2__PULSE_RELPWR_THRESH__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x001f0000U) >> 16)
#define RADAR_DETECTION_2__PULSE_RELPWR_THRESH__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 16) & 0x001f0000U)
#define RADAR_DETECTION_2__PULSE_RELPWR_THRESH__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x001f0000U) | (((u_int32_t)(src) <<\
                    16) & 0x001f0000U)
#define RADAR_DETECTION_2__PULSE_RELPWR_THRESH__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 16) & ~0x001f0000U)))

/* macros for field enable_pulse_gc_count_check */
#define RADAR_DETECTION_2__ENABLE_PULSE_GC_COUNT_CHECK__SHIFT                27
#define RADAR_DETECTION_2__ENABLE_PULSE_GC_COUNT_CHECK__WIDTH                 1
#define RADAR_DETECTION_2__ENABLE_PULSE_GC_COUNT_CHECK__MASK        0x08000000U
#define RADAR_DETECTION_2__ENABLE_PULSE_GC_COUNT_CHECK__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x08000000U) >> 27)
#define RADAR_DETECTION_2__ENABLE_PULSE_GC_COUNT_CHECK__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 27) & 0x08000000U)
#define RADAR_DETECTION_2__ENABLE_PULSE_GC_COUNT_CHECK__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x08000000U) | (((u_int32_t)(src) <<\
                    27) & 0x08000000U)
#define RADAR_DETECTION_2__ENABLE_PULSE_GC_COUNT_CHECK__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 27) & ~0x08000000U)))
#define RADAR_DETECTION_2__ENABLE_PULSE_GC_COUNT_CHECK__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x08000000U) | ((u_int32_t)(1) << 27)
#define RADAR_DETECTION_2__ENABLE_PULSE_GC_COUNT_CHECK__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x08000000U) | ((u_int32_t)(0) << 27)

/* macros for field enable_pulse_relstep_check */
#define RADAR_DETECTION_2__ENABLE_PULSE_RELSTEP_CHECK__SHIFT                 28
#define RADAR_DETECTION_2__ENABLE_PULSE_RELSTEP_CHECK__WIDTH                  1
#define RADAR_DETECTION_2__ENABLE_PULSE_RELSTEP_CHECK__MASK         0x10000000U
#define RADAR_DETECTION_2__ENABLE_PULSE_RELSTEP_CHECK__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x10000000U) >> 28)
#define RADAR_DETECTION_2__ENABLE_PULSE_RELSTEP_CHECK__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 28) & 0x10000000U)
#define RADAR_DETECTION_2__ENABLE_PULSE_RELSTEP_CHECK__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x10000000U) | (((u_int32_t)(src) <<\
                    28) & 0x10000000U)
#define RADAR_DETECTION_2__ENABLE_PULSE_RELSTEP_CHECK__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 28) & ~0x10000000U)))
#define RADAR_DETECTION_2__ENABLE_PULSE_RELSTEP_CHECK__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x10000000U) | ((u_int32_t)(1) << 28)
#define RADAR_DETECTION_2__ENABLE_PULSE_RELSTEP_CHECK__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x10000000U) | ((u_int32_t)(0) << 28)

/* macros for field enable_pulse_relpwr_check */
#define RADAR_DETECTION_2__ENABLE_PULSE_RELPWR_CHECK__SHIFT                  29
#define RADAR_DETECTION_2__ENABLE_PULSE_RELPWR_CHECK__WIDTH                   1
#define RADAR_DETECTION_2__ENABLE_PULSE_RELPWR_CHECK__MASK          0x20000000U
#define RADAR_DETECTION_2__ENABLE_PULSE_RELPWR_CHECK__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x20000000U) >> 29)
#define RADAR_DETECTION_2__ENABLE_PULSE_RELPWR_CHECK__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 29) & 0x20000000U)
#define RADAR_DETECTION_2__ENABLE_PULSE_RELPWR_CHECK__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x20000000U) | (((u_int32_t)(src) <<\
                    29) & 0x20000000U)
#define RADAR_DETECTION_2__ENABLE_PULSE_RELPWR_CHECK__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 29) & ~0x20000000U)))
#define RADAR_DETECTION_2__ENABLE_PULSE_RELPWR_CHECK__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x20000000U) | ((u_int32_t)(1) << 29)
#define RADAR_DETECTION_2__ENABLE_PULSE_RELPWR_CHECK__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x20000000U) | ((u_int32_t)(0) << 29)

/* macros for field enable_pulse_drop_check */
#define RADAR_DETECTION_2__ENABLE_PULSE_DROP_CHECK__SHIFT                    30
#define RADAR_DETECTION_2__ENABLE_PULSE_DROP_CHECK__WIDTH                     1
#define RADAR_DETECTION_2__ENABLE_PULSE_DROP_CHECK__MASK            0x40000000U
#define RADAR_DETECTION_2__ENABLE_PULSE_DROP_CHECK__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x40000000U) >> 30)
#define RADAR_DETECTION_2__ENABLE_PULSE_DROP_CHECK__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 30) & 0x40000000U)
#define RADAR_DETECTION_2__ENABLE_PULSE_DROP_CHECK__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x40000000U) | (((u_int32_t)(src) <<\
                    30) & 0x40000000U)
#define RADAR_DETECTION_2__ENABLE_PULSE_DROP_CHECK__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 30) & ~0x40000000U)))
#define RADAR_DETECTION_2__ENABLE_PULSE_DROP_CHECK__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x40000000U) | ((u_int32_t)(1) << 30)
#define RADAR_DETECTION_2__ENABLE_PULSE_DROP_CHECK__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x40000000U) | ((u_int32_t)(0) << 30)
#define RADAR_DETECTION_2__TYPE                                       u_int32_t
#define RADAR_DETECTION_2__READ                                     0x781f3fffU
#define RADAR_DETECTION_2__WRITE                                    0x781f3fffU

#endif /* __RADAR_DETECTION_2_MACRO__ */


/* macros for bb_reg_map.bb_chn_reg_map.BB_radar_detection_2 */
#define INST_BB_REG_MAP__BB_CHN_REG_MAP__BB_RADAR_DETECTION_2__NUM            1

/* macros for BlueprintGlobalNameSpace::extension_radar */
#ifndef __EXTENSION_RADAR_MACRO__
#define __EXTENSION_RADAR_MACRO__

/* macros for field restart_lgdfspwr_delta */
#define EXTENSION_RADAR__RESTART_LGDFSPWR_DELTA__SHIFT                        0
#define EXTENSION_RADAR__RESTART_LGDFSPWR_DELTA__WIDTH                        6
#define EXTENSION_RADAR__RESTART_LGDFSPWR_DELTA__MASK               0x0000003fU
#define EXTENSION_RADAR__RESTART_LGDFSPWR_DELTA__READ(src) \
                    (u_int32_t)(src)\
                    & 0x0000003fU
#define EXTENSION_RADAR__RESTART_LGDFSPWR_DELTA__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x0000003fU)
#define EXTENSION_RADAR__RESTART_LGDFSPWR_DELTA__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000003fU) | ((u_int32_t)(src) &\
                    0x0000003fU)
#define EXTENSION_RADAR__RESTART_LGDFSPWR_DELTA__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x0000003fU)))

/* macros for field radar_path_sel */
#define EXTENSION_RADAR__RADAR_PATH_SEL__SHIFT                                6
#define EXTENSION_RADAR__RADAR_PATH_SEL__WIDTH                                2
#define EXTENSION_RADAR__RADAR_PATH_SEL__MASK                       0x000000c0U
#define EXTENSION_RADAR__RADAR_PATH_SEL__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x000000c0U) >> 6)
#define EXTENSION_RADAR__RADAR_PATH_SEL__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 6) & 0x000000c0U)
#define EXTENSION_RADAR__RADAR_PATH_SEL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000000c0U) | (((u_int32_t)(src) <<\
                    6) & 0x000000c0U)
#define EXTENSION_RADAR__RADAR_PATH_SEL__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 6) & ~0x000000c0U)))

/* macros for field radar_lb_dc_cap_fine */
#define EXTENSION_RADAR__RADAR_LB_DC_CAP_FINE__SHIFT                          8
#define EXTENSION_RADAR__RADAR_LB_DC_CAP_FINE__WIDTH                          9
#define EXTENSION_RADAR__RADAR_LB_DC_CAP_FINE__MASK                 0x0001ff00U
#define EXTENSION_RADAR__RADAR_LB_DC_CAP_FINE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0001ff00U) >> 8)
#define EXTENSION_RADAR__RADAR_LB_DC_CAP_FINE__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 8) & 0x0001ff00U)
#define EXTENSION_RADAR__RADAR_LB_DC_CAP_FINE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0001ff00U) | (((u_int32_t)(src) <<\
                    8) & 0x0001ff00U)
#define EXTENSION_RADAR__RADAR_LB_DC_CAP_FINE__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 8) & ~0x0001ff00U)))

/* macros for field lb_dc_cap_pulse_dc_mask */
#define EXTENSION_RADAR__LB_DC_CAP_PULSE_DC_MASK__SHIFT                      20
#define EXTENSION_RADAR__LB_DC_CAP_PULSE_DC_MASK__WIDTH                       1
#define EXTENSION_RADAR__LB_DC_CAP_PULSE_DC_MASK__MASK              0x00100000U
#define EXTENSION_RADAR__LB_DC_CAP_PULSE_DC_MASK__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00100000U) >> 20)
#define EXTENSION_RADAR__LB_DC_CAP_PULSE_DC_MASK__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 20) & 0x00100000U)
#define EXTENSION_RADAR__LB_DC_CAP_PULSE_DC_MASK__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00100000U) | (((u_int32_t)(src) <<\
                    20) & 0x00100000U)
#define EXTENSION_RADAR__LB_DC_CAP_PULSE_DC_MASK__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 20) & ~0x00100000U)))
#define EXTENSION_RADAR__LB_DC_CAP_PULSE_DC_MASK__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00100000U) | ((u_int32_t)(1) << 20)
#define EXTENSION_RADAR__LB_DC_CAP_PULSE_DC_MASK__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00100000U) | ((u_int32_t)(0) << 20)

/* macros for field lb_dc_cap_pulse_nb_mask */
#define EXTENSION_RADAR__LB_DC_CAP_PULSE_NB_MASK__SHIFT                      21
#define EXTENSION_RADAR__LB_DC_CAP_PULSE_NB_MASK__WIDTH                       1
#define EXTENSION_RADAR__LB_DC_CAP_PULSE_NB_MASK__MASK              0x00200000U
#define EXTENSION_RADAR__LB_DC_CAP_PULSE_NB_MASK__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00200000U) >> 21)
#define EXTENSION_RADAR__LB_DC_CAP_PULSE_NB_MASK__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 21) & 0x00200000U)
#define EXTENSION_RADAR__LB_DC_CAP_PULSE_NB_MASK__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00200000U) | (((u_int32_t)(src) <<\
                    21) & 0x00200000U)
#define EXTENSION_RADAR__LB_DC_CAP_PULSE_NB_MASK__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 21) & ~0x00200000U)))
#define EXTENSION_RADAR__LB_DC_CAP_PULSE_NB_MASK__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00200000U) | ((u_int32_t)(1) << 21)
#define EXTENSION_RADAR__LB_DC_CAP_PULSE_NB_MASK__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00200000U) | ((u_int32_t)(0) << 21)

/* macros for field radar_fft_datapath_sel */
#define EXTENSION_RADAR__RADAR_FFT_DATAPATH_SEL__SHIFT                       22
#define EXTENSION_RADAR__RADAR_FFT_DATAPATH_SEL__WIDTH                        1
#define EXTENSION_RADAR__RADAR_FFT_DATAPATH_SEL__MASK               0x00400000U
#define EXTENSION_RADAR__RADAR_FFT_DATAPATH_SEL__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00400000U) >> 22)
#define EXTENSION_RADAR__RADAR_FFT_DATAPATH_SEL__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 22) & 0x00400000U)
#define EXTENSION_RADAR__RADAR_FFT_DATAPATH_SEL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00400000U) | (((u_int32_t)(src) <<\
                    22) & 0x00400000U)
#define EXTENSION_RADAR__RADAR_FFT_DATAPATH_SEL__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 22) & ~0x00400000U)))
#define EXTENSION_RADAR__RADAR_FFT_DATAPATH_SEL__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00400000U) | ((u_int32_t)(1) << 22)
#define EXTENSION_RADAR__RADAR_FFT_DATAPATH_SEL__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00400000U) | ((u_int32_t)(0) << 22)

/* macros for field radar_lb_dc_cap */
#define EXTENSION_RADAR__RADAR_LB_DC_CAP__SHIFT                              23
#define EXTENSION_RADAR__RADAR_LB_DC_CAP__WIDTH                               9
#define EXTENSION_RADAR__RADAR_LB_DC_CAP__MASK                      0xff800000U
#define EXTENSION_RADAR__RADAR_LB_DC_CAP__READ(src) \
                    (((u_int32_t)(src)\
                    & 0xff800000U) >> 23)
#define EXTENSION_RADAR__RADAR_LB_DC_CAP__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 23) & 0xff800000U)
#define EXTENSION_RADAR__RADAR_LB_DC_CAP__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xff800000U) | (((u_int32_t)(src) <<\
                    23) & 0xff800000U)
#define EXTENSION_RADAR__RADAR_LB_DC_CAP__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 23) & ~0xff800000U)))
#define EXTENSION_RADAR__TYPE                                         u_int32_t
#define EXTENSION_RADAR__READ                                       0xfff1ffffU
#define EXTENSION_RADAR__WRITE                                      0xfff1ffffU

#endif /* __EXTENSION_RADAR_MACRO__ */


/* macros for bb_reg_map.bb_chn_reg_map.BB_extension_radar */
#define INST_BB_REG_MAP__BB_CHN_REG_MAP__BB_EXTENSION_RADAR__NUM              1

/* macros for BlueprintGlobalNameSpace::ibf_ctrl */
#ifndef __IBF_CTRL_MACRO__
#define __IBF_CTRL_MACRO__

/* macros for field chn_phase_align */
#define IBF_CTRL__CHN_PHASE_ALIGN__SHIFT                                      0
#define IBF_CTRL__CHN_PHASE_ALIGN__WIDTH                                      4
#define IBF_CTRL__CHN_PHASE_ALIGN__MASK                             0x0000000fU
#define IBF_CTRL__CHN_PHASE_ALIGN__READ(src)     (u_int32_t)(src) & 0x0000000fU
#define IBF_CTRL__CHN_PHASE_ALIGN__WRITE(src)  ((u_int32_t)(src) & 0x0000000fU)
#define IBF_CTRL__CHN_PHASE_ALIGN__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000000fU) | ((u_int32_t)(src) &\
                    0x0000000fU)
#define IBF_CTRL__CHN_PHASE_ALIGN__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x0000000fU)))
#define IBF_CTRL__TYPE                                                u_int32_t
#define IBF_CTRL__READ                                              0x0000000fU
#define IBF_CTRL__WRITE                                             0x0000000fU

#endif /* __IBF_CTRL_MACRO__ */


/* macros for bb_reg_map.bb_chn_reg_map.BB_ibf_ctrl */
#define INST_BB_REG_MAP__BB_CHN_REG_MAP__BB_IBF_CTRL__NUM                     1

/* macros for BlueprintGlobalNameSpace::chn_spare_01 */
#ifndef __CHN_SPARE_01_MACRO__
#define __CHN_SPARE_01_MACRO__

/* macros for field chn_eco_ctrl */
#define CHN_SPARE_01__CHN_ECO_CTRL__SHIFT                                     0
#define CHN_SPARE_01__CHN_ECO_CTRL__WIDTH                                    32
#define CHN_SPARE_01__CHN_ECO_CTRL__MASK                            0xffffffffU
#define CHN_SPARE_01__CHN_ECO_CTRL__READ(src)    (u_int32_t)(src) & 0xffffffffU
#define CHN_SPARE_01__CHN_ECO_CTRL__WRITE(src) ((u_int32_t)(src) & 0xffffffffU)
#define CHN_SPARE_01__CHN_ECO_CTRL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xffffffffU) | ((u_int32_t)(src) &\
                    0xffffffffU)
#define CHN_SPARE_01__CHN_ECO_CTRL__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0xffffffffU)))
#define CHN_SPARE_01__TYPE                                            u_int32_t
#define CHN_SPARE_01__READ                                          0xffffffffU
#define CHN_SPARE_01__WRITE                                         0xffffffffU

#endif /* __CHN_SPARE_01_MACRO__ */


/* macros for bb_reg_map.bb_chn_reg_map.BB_chn_spare_01 */
#define INST_BB_REG_MAP__BB_CHN_REG_MAP__BB_CHN_SPARE_01__NUM                 1

/* macros for BlueprintGlobalNameSpace::timing_controls_2a */
#ifndef __TIMING_CONTROLS_2A_MACRO__
#define __TIMING_CONTROLS_2A_MACRO__

/* macros for field coarse_dc_delay */
#define TIMING_CONTROLS_2A__COARSE_DC_DELAY__SHIFT                            0
#define TIMING_CONTROLS_2A__COARSE_DC_DELAY__WIDTH                            5
#define TIMING_CONTROLS_2A__COARSE_DC_DELAY__MASK                   0x0000001fU
#define TIMING_CONTROLS_2A__COARSE_DC_DELAY__READ(src) \
                    (u_int32_t)(src)\
                    & 0x0000001fU
#define TIMING_CONTROLS_2A__COARSE_DC_DELAY__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x0000001fU)
#define TIMING_CONTROLS_2A__COARSE_DC_DELAY__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000001fU) | ((u_int32_t)(src) &\
                    0x0000001fU)
#define TIMING_CONTROLS_2A__COARSE_DC_DELAY__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x0000001fU)))
#define TIMING_CONTROLS_2A__TYPE                                      u_int32_t
#define TIMING_CONTROLS_2A__READ                                    0x0000001fU
#define TIMING_CONTROLS_2A__WRITE                                   0x0000001fU

#endif /* __TIMING_CONTROLS_2A_MACRO__ */


/* macros for bb_reg_map.bb_chn_reg_map.BB_timing_controls_2a */
#define INST_BB_REG_MAP__BB_CHN_REG_MAP__BB_TIMING_CONTROLS_2A__NUM           1

/* macros for BlueprintGlobalNameSpace::rx_notch_cntl_2_pri_b0 */
#ifndef __RX_NOTCH_CNTL_2_PRI_B0_MACRO__
#define __RX_NOTCH_CNTL_2_PRI_B0_MACRO__

/* macros for field notch_corr_spur1_i_pri_b0 */
#define RX_NOTCH_CNTL_2_PRI_B0__NOTCH_CORR_SPUR1_I_PRI_B0__SHIFT              0
#define RX_NOTCH_CNTL_2_PRI_B0__NOTCH_CORR_SPUR1_I_PRI_B0__WIDTH             12
#define RX_NOTCH_CNTL_2_PRI_B0__NOTCH_CORR_SPUR1_I_PRI_B0__MASK     0x00000fffU
#define RX_NOTCH_CNTL_2_PRI_B0__NOTCH_CORR_SPUR1_I_PRI_B0__READ(src) \
                    (u_int32_t)(src)\
                    & 0x00000fffU
#define RX_NOTCH_CNTL_2_PRI_B0__NOTCH_CORR_SPUR1_I_PRI_B0__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x00000fffU)
#define RX_NOTCH_CNTL_2_PRI_B0__NOTCH_CORR_SPUR1_I_PRI_B0__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000fffU) | ((u_int32_t)(src) &\
                    0x00000fffU)
#define RX_NOTCH_CNTL_2_PRI_B0__NOTCH_CORR_SPUR1_I_PRI_B0__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00000fffU)))

/* macros for field notch_corr_spur1_q_pri_b0 */
#define RX_NOTCH_CNTL_2_PRI_B0__NOTCH_CORR_SPUR1_Q_PRI_B0__SHIFT             16
#define RX_NOTCH_CNTL_2_PRI_B0__NOTCH_CORR_SPUR1_Q_PRI_B0__WIDTH             12
#define RX_NOTCH_CNTL_2_PRI_B0__NOTCH_CORR_SPUR1_Q_PRI_B0__MASK     0x0fff0000U
#define RX_NOTCH_CNTL_2_PRI_B0__NOTCH_CORR_SPUR1_Q_PRI_B0__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0fff0000U) >> 16)
#define RX_NOTCH_CNTL_2_PRI_B0__NOTCH_CORR_SPUR1_Q_PRI_B0__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 16) & 0x0fff0000U)
#define RX_NOTCH_CNTL_2_PRI_B0__NOTCH_CORR_SPUR1_Q_PRI_B0__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0fff0000U) | (((u_int32_t)(src) <<\
                    16) & 0x0fff0000U)
#define RX_NOTCH_CNTL_2_PRI_B0__NOTCH_CORR_SPUR1_Q_PRI_B0__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 16) & ~0x0fff0000U)))
#define RX_NOTCH_CNTL_2_PRI_B0__TYPE                                  u_int32_t
#define RX_NOTCH_CNTL_2_PRI_B0__READ                                0x0fff0fffU
#define RX_NOTCH_CNTL_2_PRI_B0__WRITE                               0x0fff0fffU

#endif /* __RX_NOTCH_CNTL_2_PRI_B0_MACRO__ */


/* macros for bb_reg_map.bb_chn_reg_map.BB_rx_notch_cntl_2_pri_b0 */
#define INST_BB_REG_MAP__BB_CHN_REG_MAP__BB_RX_NOTCH_CNTL_2_PRI_B0__NUM       1

/* macros for BlueprintGlobalNameSpace::rx_notch_cntl_3_pri_b0 */
#ifndef __RX_NOTCH_CNTL_3_PRI_B0_MACRO__
#define __RX_NOTCH_CNTL_3_PRI_B0_MACRO__

/* macros for field notch_corr_spur2_i_pri_b0 */
#define RX_NOTCH_CNTL_3_PRI_B0__NOTCH_CORR_SPUR2_I_PRI_B0__SHIFT              0
#define RX_NOTCH_CNTL_3_PRI_B0__NOTCH_CORR_SPUR2_I_PRI_B0__WIDTH             12
#define RX_NOTCH_CNTL_3_PRI_B0__NOTCH_CORR_SPUR2_I_PRI_B0__MASK     0x00000fffU
#define RX_NOTCH_CNTL_3_PRI_B0__NOTCH_CORR_SPUR2_I_PRI_B0__READ(src) \
                    (u_int32_t)(src)\
                    & 0x00000fffU
#define RX_NOTCH_CNTL_3_PRI_B0__NOTCH_CORR_SPUR2_I_PRI_B0__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x00000fffU)
#define RX_NOTCH_CNTL_3_PRI_B0__NOTCH_CORR_SPUR2_I_PRI_B0__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000fffU) | ((u_int32_t)(src) &\
                    0x00000fffU)
#define RX_NOTCH_CNTL_3_PRI_B0__NOTCH_CORR_SPUR2_I_PRI_B0__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00000fffU)))

/* macros for field notch_corr_spur2_q_pri_b0 */
#define RX_NOTCH_CNTL_3_PRI_B0__NOTCH_CORR_SPUR2_Q_PRI_B0__SHIFT             16
#define RX_NOTCH_CNTL_3_PRI_B0__NOTCH_CORR_SPUR2_Q_PRI_B0__WIDTH             12
#define RX_NOTCH_CNTL_3_PRI_B0__NOTCH_CORR_SPUR2_Q_PRI_B0__MASK     0x0fff0000U
#define RX_NOTCH_CNTL_3_PRI_B0__NOTCH_CORR_SPUR2_Q_PRI_B0__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0fff0000U) >> 16)
#define RX_NOTCH_CNTL_3_PRI_B0__NOTCH_CORR_SPUR2_Q_PRI_B0__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 16) & 0x0fff0000U)
#define RX_NOTCH_CNTL_3_PRI_B0__NOTCH_CORR_SPUR2_Q_PRI_B0__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0fff0000U) | (((u_int32_t)(src) <<\
                    16) & 0x0fff0000U)
#define RX_NOTCH_CNTL_3_PRI_B0__NOTCH_CORR_SPUR2_Q_PRI_B0__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 16) & ~0x0fff0000U)))
#define RX_NOTCH_CNTL_3_PRI_B0__TYPE                                  u_int32_t
#define RX_NOTCH_CNTL_3_PRI_B0__READ                                0x0fff0fffU
#define RX_NOTCH_CNTL_3_PRI_B0__WRITE                               0x0fff0fffU

#endif /* __RX_NOTCH_CNTL_3_PRI_B0_MACRO__ */


/* macros for bb_reg_map.bb_chn_reg_map.BB_rx_notch_cntl_3_pri_b0 */
#define INST_BB_REG_MAP__BB_CHN_REG_MAP__BB_RX_NOTCH_CNTL_3_PRI_B0__NUM       1

/* macros for BlueprintGlobalNameSpace::rx_notch_cntl_4_pri_b0 */
#ifndef __RX_NOTCH_CNTL_4_PRI_B0_MACRO__
#define __RX_NOTCH_CNTL_4_PRI_B0_MACRO__

/* macros for field notch_corr_dc_i_pri_b0 */
#define RX_NOTCH_CNTL_4_PRI_B0__NOTCH_CORR_DC_I_PRI_B0__SHIFT                 0
#define RX_NOTCH_CNTL_4_PRI_B0__NOTCH_CORR_DC_I_PRI_B0__WIDTH                12
#define RX_NOTCH_CNTL_4_PRI_B0__NOTCH_CORR_DC_I_PRI_B0__MASK        0x00000fffU
#define RX_NOTCH_CNTL_4_PRI_B0__NOTCH_CORR_DC_I_PRI_B0__READ(src) \
                    (u_int32_t)(src)\
                    & 0x00000fffU
#define RX_NOTCH_CNTL_4_PRI_B0__NOTCH_CORR_DC_I_PRI_B0__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x00000fffU)
#define RX_NOTCH_CNTL_4_PRI_B0__NOTCH_CORR_DC_I_PRI_B0__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000fffU) | ((u_int32_t)(src) &\
                    0x00000fffU)
#define RX_NOTCH_CNTL_4_PRI_B0__NOTCH_CORR_DC_I_PRI_B0__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00000fffU)))

/* macros for field notch_corr_dc_q_pri_b0 */
#define RX_NOTCH_CNTL_4_PRI_B0__NOTCH_CORR_DC_Q_PRI_B0__SHIFT                16
#define RX_NOTCH_CNTL_4_PRI_B0__NOTCH_CORR_DC_Q_PRI_B0__WIDTH                12
#define RX_NOTCH_CNTL_4_PRI_B0__NOTCH_CORR_DC_Q_PRI_B0__MASK        0x0fff0000U
#define RX_NOTCH_CNTL_4_PRI_B0__NOTCH_CORR_DC_Q_PRI_B0__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0fff0000U) >> 16)
#define RX_NOTCH_CNTL_4_PRI_B0__NOTCH_CORR_DC_Q_PRI_B0__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 16) & 0x0fff0000U)
#define RX_NOTCH_CNTL_4_PRI_B0__NOTCH_CORR_DC_Q_PRI_B0__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0fff0000U) | (((u_int32_t)(src) <<\
                    16) & 0x0fff0000U)
#define RX_NOTCH_CNTL_4_PRI_B0__NOTCH_CORR_DC_Q_PRI_B0__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 16) & ~0x0fff0000U)))
#define RX_NOTCH_CNTL_4_PRI_B0__TYPE                                  u_int32_t
#define RX_NOTCH_CNTL_4_PRI_B0__READ                                0x0fff0fffU
#define RX_NOTCH_CNTL_4_PRI_B0__WRITE                               0x0fff0fffU

#endif /* __RX_NOTCH_CNTL_4_PRI_B0_MACRO__ */


/* macros for bb_reg_map.bb_chn_reg_map.BB_rx_notch_cntl_4_pri_b0 */
#define INST_BB_REG_MAP__BB_CHN_REG_MAP__BB_RX_NOTCH_CNTL_4_PRI_B0__NUM       1

/* macros for BlueprintGlobalNameSpace::rx_notch_cntl_5_pri_b0 */
#ifndef __RX_NOTCH_CNTL_5_PRI_B0_MACRO__
#define __RX_NOTCH_CNTL_5_PRI_B0_MACRO__

/* macros for field notch_corr_agg_i_pri_b0 */
#define RX_NOTCH_CNTL_5_PRI_B0__NOTCH_CORR_AGG_I_PRI_B0__SHIFT                0
#define RX_NOTCH_CNTL_5_PRI_B0__NOTCH_CORR_AGG_I_PRI_B0__WIDTH               12
#define RX_NOTCH_CNTL_5_PRI_B0__NOTCH_CORR_AGG_I_PRI_B0__MASK       0x00000fffU
#define RX_NOTCH_CNTL_5_PRI_B0__NOTCH_CORR_AGG_I_PRI_B0__READ(src) \
                    (u_int32_t)(src)\
                    & 0x00000fffU
#define RX_NOTCH_CNTL_5_PRI_B0__NOTCH_CORR_AGG_I_PRI_B0__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x00000fffU)
#define RX_NOTCH_CNTL_5_PRI_B0__NOTCH_CORR_AGG_I_PRI_B0__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000fffU) | ((u_int32_t)(src) &\
                    0x00000fffU)
#define RX_NOTCH_CNTL_5_PRI_B0__NOTCH_CORR_AGG_I_PRI_B0__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00000fffU)))
#define RX_NOTCH_CNTL_5_PRI_B0__TYPE                                  u_int32_t
#define RX_NOTCH_CNTL_5_PRI_B0__READ                                0x00000fffU
#define RX_NOTCH_CNTL_5_PRI_B0__WRITE                               0x00000fffU

#endif /* __RX_NOTCH_CNTL_5_PRI_B0_MACRO__ */


/* macros for bb_reg_map.bb_chn_reg_map.BB_rx_notch_cntl_5_pri_b0 */
#define INST_BB_REG_MAP__BB_CHN_REG_MAP__BB_RX_NOTCH_CNTL_5_PRI_B0__NUM       1

/* macros for BlueprintGlobalNameSpace::rx_notch_cntl_2_ext_b0 */
#ifndef __RX_NOTCH_CNTL_2_EXT_B0_MACRO__
#define __RX_NOTCH_CNTL_2_EXT_B0_MACRO__

/* macros for field notch_corr_spur1_i_ext_b0 */
#define RX_NOTCH_CNTL_2_EXT_B0__NOTCH_CORR_SPUR1_I_EXT_B0__SHIFT              0
#define RX_NOTCH_CNTL_2_EXT_B0__NOTCH_CORR_SPUR1_I_EXT_B0__WIDTH             12
#define RX_NOTCH_CNTL_2_EXT_B0__NOTCH_CORR_SPUR1_I_EXT_B0__MASK     0x00000fffU
#define RX_NOTCH_CNTL_2_EXT_B0__NOTCH_CORR_SPUR1_I_EXT_B0__READ(src) \
                    (u_int32_t)(src)\
                    & 0x00000fffU
#define RX_NOTCH_CNTL_2_EXT_B0__NOTCH_CORR_SPUR1_I_EXT_B0__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x00000fffU)
#define RX_NOTCH_CNTL_2_EXT_B0__NOTCH_CORR_SPUR1_I_EXT_B0__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000fffU) | ((u_int32_t)(src) &\
                    0x00000fffU)
#define RX_NOTCH_CNTL_2_EXT_B0__NOTCH_CORR_SPUR1_I_EXT_B0__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00000fffU)))

/* macros for field notch_corr_spur1_q_ext_b0 */
#define RX_NOTCH_CNTL_2_EXT_B0__NOTCH_CORR_SPUR1_Q_EXT_B0__SHIFT             16
#define RX_NOTCH_CNTL_2_EXT_B0__NOTCH_CORR_SPUR1_Q_EXT_B0__WIDTH             12
#define RX_NOTCH_CNTL_2_EXT_B0__NOTCH_CORR_SPUR1_Q_EXT_B0__MASK     0x0fff0000U
#define RX_NOTCH_CNTL_2_EXT_B0__NOTCH_CORR_SPUR1_Q_EXT_B0__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0fff0000U) >> 16)
#define RX_NOTCH_CNTL_2_EXT_B0__NOTCH_CORR_SPUR1_Q_EXT_B0__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 16) & 0x0fff0000U)
#define RX_NOTCH_CNTL_2_EXT_B0__NOTCH_CORR_SPUR1_Q_EXT_B0__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0fff0000U) | (((u_int32_t)(src) <<\
                    16) & 0x0fff0000U)
#define RX_NOTCH_CNTL_2_EXT_B0__NOTCH_CORR_SPUR1_Q_EXT_B0__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 16) & ~0x0fff0000U)))
#define RX_NOTCH_CNTL_2_EXT_B0__TYPE                                  u_int32_t
#define RX_NOTCH_CNTL_2_EXT_B0__READ                                0x0fff0fffU
#define RX_NOTCH_CNTL_2_EXT_B0__WRITE                               0x0fff0fffU

#endif /* __RX_NOTCH_CNTL_2_EXT_B0_MACRO__ */


/* macros for bb_reg_map.bb_chn_reg_map.BB_rx_notch_cntl_2_ext_b0 */
#define INST_BB_REG_MAP__BB_CHN_REG_MAP__BB_RX_NOTCH_CNTL_2_EXT_B0__NUM       1

/* macros for BlueprintGlobalNameSpace::rx_notch_cntl_3_ext_b0 */
#ifndef __RX_NOTCH_CNTL_3_EXT_B0_MACRO__
#define __RX_NOTCH_CNTL_3_EXT_B0_MACRO__

/* macros for field notch_corr_spur2_i_ext_b0 */
#define RX_NOTCH_CNTL_3_EXT_B0__NOTCH_CORR_SPUR2_I_EXT_B0__SHIFT              0
#define RX_NOTCH_CNTL_3_EXT_B0__NOTCH_CORR_SPUR2_I_EXT_B0__WIDTH             12
#define RX_NOTCH_CNTL_3_EXT_B0__NOTCH_CORR_SPUR2_I_EXT_B0__MASK     0x00000fffU
#define RX_NOTCH_CNTL_3_EXT_B0__NOTCH_CORR_SPUR2_I_EXT_B0__READ(src) \
                    (u_int32_t)(src)\
                    & 0x00000fffU
#define RX_NOTCH_CNTL_3_EXT_B0__NOTCH_CORR_SPUR2_I_EXT_B0__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x00000fffU)
#define RX_NOTCH_CNTL_3_EXT_B0__NOTCH_CORR_SPUR2_I_EXT_B0__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000fffU) | ((u_int32_t)(src) &\
                    0x00000fffU)
#define RX_NOTCH_CNTL_3_EXT_B0__NOTCH_CORR_SPUR2_I_EXT_B0__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00000fffU)))

/* macros for field notch_corr_spur2_q_ext_b0 */
#define RX_NOTCH_CNTL_3_EXT_B0__NOTCH_CORR_SPUR2_Q_EXT_B0__SHIFT             16
#define RX_NOTCH_CNTL_3_EXT_B0__NOTCH_CORR_SPUR2_Q_EXT_B0__WIDTH             12
#define RX_NOTCH_CNTL_3_EXT_B0__NOTCH_CORR_SPUR2_Q_EXT_B0__MASK     0x0fff0000U
#define RX_NOTCH_CNTL_3_EXT_B0__NOTCH_CORR_SPUR2_Q_EXT_B0__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0fff0000U) >> 16)
#define RX_NOTCH_CNTL_3_EXT_B0__NOTCH_CORR_SPUR2_Q_EXT_B0__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 16) & 0x0fff0000U)
#define RX_NOTCH_CNTL_3_EXT_B0__NOTCH_CORR_SPUR2_Q_EXT_B0__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0fff0000U) | (((u_int32_t)(src) <<\
                    16) & 0x0fff0000U)
#define RX_NOTCH_CNTL_3_EXT_B0__NOTCH_CORR_SPUR2_Q_EXT_B0__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 16) & ~0x0fff0000U)))
#define RX_NOTCH_CNTL_3_EXT_B0__TYPE                                  u_int32_t
#define RX_NOTCH_CNTL_3_EXT_B0__READ                                0x0fff0fffU
#define RX_NOTCH_CNTL_3_EXT_B0__WRITE                               0x0fff0fffU

#endif /* __RX_NOTCH_CNTL_3_EXT_B0_MACRO__ */


/* macros for bb_reg_map.bb_chn_reg_map.BB_rx_notch_cntl_3_ext_b0 */
#define INST_BB_REG_MAP__BB_CHN_REG_MAP__BB_RX_NOTCH_CNTL_3_EXT_B0__NUM       1

/* macros for BlueprintGlobalNameSpace::rx_notch_cntl_4_ext_b0 */
#ifndef __RX_NOTCH_CNTL_4_EXT_B0_MACRO__
#define __RX_NOTCH_CNTL_4_EXT_B0_MACRO__

/* macros for field notch_corr_dc_i_ext_b0 */
#define RX_NOTCH_CNTL_4_EXT_B0__NOTCH_CORR_DC_I_EXT_B0__SHIFT                 0
#define RX_NOTCH_CNTL_4_EXT_B0__NOTCH_CORR_DC_I_EXT_B0__WIDTH                12
#define RX_NOTCH_CNTL_4_EXT_B0__NOTCH_CORR_DC_I_EXT_B0__MASK        0x00000fffU
#define RX_NOTCH_CNTL_4_EXT_B0__NOTCH_CORR_DC_I_EXT_B0__READ(src) \
                    (u_int32_t)(src)\
                    & 0x00000fffU
#define RX_NOTCH_CNTL_4_EXT_B0__NOTCH_CORR_DC_I_EXT_B0__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x00000fffU)
#define RX_NOTCH_CNTL_4_EXT_B0__NOTCH_CORR_DC_I_EXT_B0__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000fffU) | ((u_int32_t)(src) &\
                    0x00000fffU)
#define RX_NOTCH_CNTL_4_EXT_B0__NOTCH_CORR_DC_I_EXT_B0__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00000fffU)))

/* macros for field notch_corr_dc_q_ext_b0 */
#define RX_NOTCH_CNTL_4_EXT_B0__NOTCH_CORR_DC_Q_EXT_B0__SHIFT                16
#define RX_NOTCH_CNTL_4_EXT_B0__NOTCH_CORR_DC_Q_EXT_B0__WIDTH                12
#define RX_NOTCH_CNTL_4_EXT_B0__NOTCH_CORR_DC_Q_EXT_B0__MASK        0x0fff0000U
#define RX_NOTCH_CNTL_4_EXT_B0__NOTCH_CORR_DC_Q_EXT_B0__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0fff0000U) >> 16)
#define RX_NOTCH_CNTL_4_EXT_B0__NOTCH_CORR_DC_Q_EXT_B0__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 16) & 0x0fff0000U)
#define RX_NOTCH_CNTL_4_EXT_B0__NOTCH_CORR_DC_Q_EXT_B0__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0fff0000U) | (((u_int32_t)(src) <<\
                    16) & 0x0fff0000U)
#define RX_NOTCH_CNTL_4_EXT_B0__NOTCH_CORR_DC_Q_EXT_B0__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 16) & ~0x0fff0000U)))
#define RX_NOTCH_CNTL_4_EXT_B0__TYPE                                  u_int32_t
#define RX_NOTCH_CNTL_4_EXT_B0__READ                                0x0fff0fffU
#define RX_NOTCH_CNTL_4_EXT_B0__WRITE                               0x0fff0fffU

#endif /* __RX_NOTCH_CNTL_4_EXT_B0_MACRO__ */


/* macros for bb_reg_map.bb_chn_reg_map.BB_rx_notch_cntl_4_ext_b0 */
#define INST_BB_REG_MAP__BB_CHN_REG_MAP__BB_RX_NOTCH_CNTL_4_EXT_B0__NUM       1

/* macros for BlueprintGlobalNameSpace::rx_notch_cntl_5_ext_b0 */
#ifndef __RX_NOTCH_CNTL_5_EXT_B0_MACRO__
#define __RX_NOTCH_CNTL_5_EXT_B0_MACRO__

/* macros for field notch_corr_agg_i_ext_b0 */
#define RX_NOTCH_CNTL_5_EXT_B0__NOTCH_CORR_AGG_I_EXT_B0__SHIFT                0
#define RX_NOTCH_CNTL_5_EXT_B0__NOTCH_CORR_AGG_I_EXT_B0__WIDTH               12
#define RX_NOTCH_CNTL_5_EXT_B0__NOTCH_CORR_AGG_I_EXT_B0__MASK       0x00000fffU
#define RX_NOTCH_CNTL_5_EXT_B0__NOTCH_CORR_AGG_I_EXT_B0__READ(src) \
                    (u_int32_t)(src)\
                    & 0x00000fffU
#define RX_NOTCH_CNTL_5_EXT_B0__NOTCH_CORR_AGG_I_EXT_B0__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x00000fffU)
#define RX_NOTCH_CNTL_5_EXT_B0__NOTCH_CORR_AGG_I_EXT_B0__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000fffU) | ((u_int32_t)(src) &\
                    0x00000fffU)
#define RX_NOTCH_CNTL_5_EXT_B0__NOTCH_CORR_AGG_I_EXT_B0__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00000fffU)))
#define RX_NOTCH_CNTL_5_EXT_B0__TYPE                                  u_int32_t
#define RX_NOTCH_CNTL_5_EXT_B0__READ                                0x00000fffU
#define RX_NOTCH_CNTL_5_EXT_B0__WRITE                               0x00000fffU

#endif /* __RX_NOTCH_CNTL_5_EXT_B0_MACRO__ */


/* macros for bb_reg_map.bb_chn_reg_map.BB_rx_notch_cntl_5_ext_b0 */
#define INST_BB_REG_MAP__BB_CHN_REG_MAP__BB_RX_NOTCH_CNTL_5_EXT_B0__NUM       1

/* macros for BlueprintGlobalNameSpace::multichain_control */
#ifndef __MULTICHAIN_CONTROL_MACRO__
#define __MULTICHAIN_CONTROL_MACRO__

/* macros for field force_analog_gain_diff */
#define MULTICHAIN_CONTROL__FORCE_ANALOG_GAIN_DIFF__SHIFT                     0
#define MULTICHAIN_CONTROL__FORCE_ANALOG_GAIN_DIFF__WIDTH                     1
#define MULTICHAIN_CONTROL__FORCE_ANALOG_GAIN_DIFF__MASK            0x00000001U
#define MULTICHAIN_CONTROL__FORCE_ANALOG_GAIN_DIFF__READ(src) \
                    (u_int32_t)(src)\
                    & 0x00000001U
#define MULTICHAIN_CONTROL__FORCE_ANALOG_GAIN_DIFF__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x00000001U)
#define MULTICHAIN_CONTROL__FORCE_ANALOG_GAIN_DIFF__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | ((u_int32_t)(src) &\
                    0x00000001U)
#define MULTICHAIN_CONTROL__FORCE_ANALOG_GAIN_DIFF__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00000001U)))
#define MULTICHAIN_CONTROL__FORCE_ANALOG_GAIN_DIFF__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(1)
#define MULTICHAIN_CONTROL__FORCE_ANALOG_GAIN_DIFF__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(0)

/* macros for field forced_gain_diff_01 */
#define MULTICHAIN_CONTROL__FORCED_GAIN_DIFF_01__SHIFT                        1
#define MULTICHAIN_CONTROL__FORCED_GAIN_DIFF_01__WIDTH                        7
#define MULTICHAIN_CONTROL__FORCED_GAIN_DIFF_01__MASK               0x000000feU
#define MULTICHAIN_CONTROL__FORCED_GAIN_DIFF_01__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x000000feU) >> 1)
#define MULTICHAIN_CONTROL__FORCED_GAIN_DIFF_01__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 1) & 0x000000feU)
#define MULTICHAIN_CONTROL__FORCED_GAIN_DIFF_01__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000000feU) | (((u_int32_t)(src) <<\
                    1) & 0x000000feU)
#define MULTICHAIN_CONTROL__FORCED_GAIN_DIFF_01__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 1) & ~0x000000feU)))

/* macros for field sync_synthon */
#define MULTICHAIN_CONTROL__SYNC_SYNTHON__SHIFT                               8
#define MULTICHAIN_CONTROL__SYNC_SYNTHON__WIDTH                               1
#define MULTICHAIN_CONTROL__SYNC_SYNTHON__MASK                      0x00000100U
#define MULTICHAIN_CONTROL__SYNC_SYNTHON__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000100U) >> 8)
#define MULTICHAIN_CONTROL__SYNC_SYNTHON__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 8) & 0x00000100U)
#define MULTICHAIN_CONTROL__SYNC_SYNTHON__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000100U) | (((u_int32_t)(src) <<\
                    8) & 0x00000100U)
#define MULTICHAIN_CONTROL__SYNC_SYNTHON__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 8) & ~0x00000100U)))
#define MULTICHAIN_CONTROL__SYNC_SYNTHON__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000100U) | ((u_int32_t)(1) << 8)
#define MULTICHAIN_CONTROL__SYNC_SYNTHON__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000100U) | ((u_int32_t)(0) << 8)

/* macros for field use_posedge_refclk */
#define MULTICHAIN_CONTROL__USE_POSEDGE_REFCLK__SHIFT                         9
#define MULTICHAIN_CONTROL__USE_POSEDGE_REFCLK__WIDTH                         1
#define MULTICHAIN_CONTROL__USE_POSEDGE_REFCLK__MASK                0x00000200U
#define MULTICHAIN_CONTROL__USE_POSEDGE_REFCLK__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000200U) >> 9)
#define MULTICHAIN_CONTROL__USE_POSEDGE_REFCLK__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 9) & 0x00000200U)
#define MULTICHAIN_CONTROL__USE_POSEDGE_REFCLK__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000200U) | (((u_int32_t)(src) <<\
                    9) & 0x00000200U)
#define MULTICHAIN_CONTROL__USE_POSEDGE_REFCLK__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 9) & ~0x00000200U)))
#define MULTICHAIN_CONTROL__USE_POSEDGE_REFCLK__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000200U) | ((u_int32_t)(1) << 9)
#define MULTICHAIN_CONTROL__USE_POSEDGE_REFCLK__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000200U) | ((u_int32_t)(0) << 9)

/* macros for field cf_short_sat */
#define MULTICHAIN_CONTROL__CF_SHORT_SAT__SHIFT                              10
#define MULTICHAIN_CONTROL__CF_SHORT_SAT__WIDTH                              11
#define MULTICHAIN_CONTROL__CF_SHORT_SAT__MASK                      0x001ffc00U
#define MULTICHAIN_CONTROL__CF_SHORT_SAT__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x001ffc00U) >> 10)
#define MULTICHAIN_CONTROL__CF_SHORT_SAT__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 10) & 0x001ffc00U)
#define MULTICHAIN_CONTROL__CF_SHORT_SAT__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x001ffc00U) | (((u_int32_t)(src) <<\
                    10) & 0x001ffc00U)
#define MULTICHAIN_CONTROL__CF_SHORT_SAT__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 10) & ~0x001ffc00U)))

/* macros for field forced_gain_diff_02 */
#define MULTICHAIN_CONTROL__FORCED_GAIN_DIFF_02__SHIFT                       22
#define MULTICHAIN_CONTROL__FORCED_GAIN_DIFF_02__WIDTH                        7
#define MULTICHAIN_CONTROL__FORCED_GAIN_DIFF_02__MASK               0x1fc00000U
#define MULTICHAIN_CONTROL__FORCED_GAIN_DIFF_02__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x1fc00000U) >> 22)
#define MULTICHAIN_CONTROL__FORCED_GAIN_DIFF_02__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 22) & 0x1fc00000U)
#define MULTICHAIN_CONTROL__FORCED_GAIN_DIFF_02__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x1fc00000U) | (((u_int32_t)(src) <<\
                    22) & 0x1fc00000U)
#define MULTICHAIN_CONTROL__FORCED_GAIN_DIFF_02__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 22) & ~0x1fc00000U)))

/* macros for field force_sigma_zero */
#define MULTICHAIN_CONTROL__FORCE_SIGMA_ZERO__SHIFT                          29
#define MULTICHAIN_CONTROL__FORCE_SIGMA_ZERO__WIDTH                           1
#define MULTICHAIN_CONTROL__FORCE_SIGMA_ZERO__MASK                  0x20000000U
#define MULTICHAIN_CONTROL__FORCE_SIGMA_ZERO__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x20000000U) >> 29)
#define MULTICHAIN_CONTROL__FORCE_SIGMA_ZERO__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 29) & 0x20000000U)
#define MULTICHAIN_CONTROL__FORCE_SIGMA_ZERO__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x20000000U) | (((u_int32_t)(src) <<\
                    29) & 0x20000000U)
#define MULTICHAIN_CONTROL__FORCE_SIGMA_ZERO__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 29) & ~0x20000000U)))
#define MULTICHAIN_CONTROL__FORCE_SIGMA_ZERO__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x20000000U) | ((u_int32_t)(1) << 29)
#define MULTICHAIN_CONTROL__FORCE_SIGMA_ZERO__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x20000000U) | ((u_int32_t)(0) << 29)

/* macros for field enable_static_deweight */
#define MULTICHAIN_CONTROL__ENABLE_STATIC_DEWEIGHT__SHIFT                    30
#define MULTICHAIN_CONTROL__ENABLE_STATIC_DEWEIGHT__WIDTH                     1
#define MULTICHAIN_CONTROL__ENABLE_STATIC_DEWEIGHT__MASK            0x40000000U
#define MULTICHAIN_CONTROL__ENABLE_STATIC_DEWEIGHT__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x40000000U) >> 30)
#define MULTICHAIN_CONTROL__ENABLE_STATIC_DEWEIGHT__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 30) & 0x40000000U)
#define MULTICHAIN_CONTROL__ENABLE_STATIC_DEWEIGHT__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x40000000U) | (((u_int32_t)(src) <<\
                    30) & 0x40000000U)
#define MULTICHAIN_CONTROL__ENABLE_STATIC_DEWEIGHT__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 30) & ~0x40000000U)))
#define MULTICHAIN_CONTROL__ENABLE_STATIC_DEWEIGHT__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x40000000U) | ((u_int32_t)(1) << 30)
#define MULTICHAIN_CONTROL__ENABLE_STATIC_DEWEIGHT__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x40000000U) | ((u_int32_t)(0) << 30)

/* macros for field enable_dyn_deweight */
#define MULTICHAIN_CONTROL__ENABLE_DYN_DEWEIGHT__SHIFT                       31
#define MULTICHAIN_CONTROL__ENABLE_DYN_DEWEIGHT__WIDTH                        1
#define MULTICHAIN_CONTROL__ENABLE_DYN_DEWEIGHT__MASK               0x80000000U
#define MULTICHAIN_CONTROL__ENABLE_DYN_DEWEIGHT__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x80000000U) >> 31)
#define MULTICHAIN_CONTROL__ENABLE_DYN_DEWEIGHT__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 31) & 0x80000000U)
#define MULTICHAIN_CONTROL__ENABLE_DYN_DEWEIGHT__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x80000000U) | (((u_int32_t)(src) <<\
                    31) & 0x80000000U)
#define MULTICHAIN_CONTROL__ENABLE_DYN_DEWEIGHT__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 31) & ~0x80000000U)))
#define MULTICHAIN_CONTROL__ENABLE_DYN_DEWEIGHT__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x80000000U) | ((u_int32_t)(1) << 31)
#define MULTICHAIN_CONTROL__ENABLE_DYN_DEWEIGHT__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x80000000U) | ((u_int32_t)(0) << 31)
#define MULTICHAIN_CONTROL__TYPE                                      u_int32_t
#define MULTICHAIN_CONTROL__READ                                    0xffdfffffU
#define MULTICHAIN_CONTROL__WRITE                                   0xffdfffffU

#endif /* __MULTICHAIN_CONTROL_MACRO__ */


/* macros for bb_reg_map.bb_chn_reg_map.BB_multichain_control */
#define INST_BB_REG_MAP__BB_CHN_REG_MAP__BB_MULTICHAIN_CONTROL__NUM           1

/* macros for BlueprintGlobalNameSpace::per_chain_ht_csd */
#ifndef __PER_CHAIN_HT_CSD_MACRO__
#define __PER_CHAIN_HT_CSD_MACRO__

/* macros for field ht_csd_chn1_2chains */
#define PER_CHAIN_HT_CSD__HT_CSD_CHN1_2CHAINS__SHIFT                          0
#define PER_CHAIN_HT_CSD__HT_CSD_CHN1_2CHAINS__WIDTH                          5
#define PER_CHAIN_HT_CSD__HT_CSD_CHN1_2CHAINS__MASK                 0x0000001fU
#define PER_CHAIN_HT_CSD__HT_CSD_CHN1_2CHAINS__READ(src) \
                    (u_int32_t)(src)\
                    & 0x0000001fU
#define PER_CHAIN_HT_CSD__HT_CSD_CHN1_2CHAINS__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x0000001fU)
#define PER_CHAIN_HT_CSD__HT_CSD_CHN1_2CHAINS__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000001fU) | ((u_int32_t)(src) &\
                    0x0000001fU)
#define PER_CHAIN_HT_CSD__HT_CSD_CHN1_2CHAINS__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x0000001fU)))

/* macros for field ht_csd_chn1_3chains */
#define PER_CHAIN_HT_CSD__HT_CSD_CHN1_3CHAINS__SHIFT                          5
#define PER_CHAIN_HT_CSD__HT_CSD_CHN1_3CHAINS__WIDTH                          5
#define PER_CHAIN_HT_CSD__HT_CSD_CHN1_3CHAINS__MASK                 0x000003e0U
#define PER_CHAIN_HT_CSD__HT_CSD_CHN1_3CHAINS__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x000003e0U) >> 5)
#define PER_CHAIN_HT_CSD__HT_CSD_CHN1_3CHAINS__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 5) & 0x000003e0U)
#define PER_CHAIN_HT_CSD__HT_CSD_CHN1_3CHAINS__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000003e0U) | (((u_int32_t)(src) <<\
                    5) & 0x000003e0U)
#define PER_CHAIN_HT_CSD__HT_CSD_CHN1_3CHAINS__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 5) & ~0x000003e0U)))

/* macros for field ht_csd_chn2_3chains */
#define PER_CHAIN_HT_CSD__HT_CSD_CHN2_3CHAINS__SHIFT                         10
#define PER_CHAIN_HT_CSD__HT_CSD_CHN2_3CHAINS__WIDTH                          5
#define PER_CHAIN_HT_CSD__HT_CSD_CHN2_3CHAINS__MASK                 0x00007c00U
#define PER_CHAIN_HT_CSD__HT_CSD_CHN2_3CHAINS__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00007c00U) >> 10)
#define PER_CHAIN_HT_CSD__HT_CSD_CHN2_3CHAINS__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 10) & 0x00007c00U)
#define PER_CHAIN_HT_CSD__HT_CSD_CHN2_3CHAINS__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00007c00U) | (((u_int32_t)(src) <<\
                    10) & 0x00007c00U)
#define PER_CHAIN_HT_CSD__HT_CSD_CHN2_3CHAINS__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 10) & ~0x00007c00U)))

/* macros for field ht_csd_chn1_4chains */
#define PER_CHAIN_HT_CSD__HT_CSD_CHN1_4CHAINS__SHIFT                         15
#define PER_CHAIN_HT_CSD__HT_CSD_CHN1_4CHAINS__WIDTH                          5
#define PER_CHAIN_HT_CSD__HT_CSD_CHN1_4CHAINS__MASK                 0x000f8000U
#define PER_CHAIN_HT_CSD__HT_CSD_CHN1_4CHAINS__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x000f8000U) >> 15)
#define PER_CHAIN_HT_CSD__HT_CSD_CHN1_4CHAINS__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 15) & 0x000f8000U)
#define PER_CHAIN_HT_CSD__HT_CSD_CHN1_4CHAINS__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000f8000U) | (((u_int32_t)(src) <<\
                    15) & 0x000f8000U)
#define PER_CHAIN_HT_CSD__HT_CSD_CHN1_4CHAINS__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 15) & ~0x000f8000U)))

/* macros for field ht_csd_chn2_4chains */
#define PER_CHAIN_HT_CSD__HT_CSD_CHN2_4CHAINS__SHIFT                         20
#define PER_CHAIN_HT_CSD__HT_CSD_CHN2_4CHAINS__WIDTH                          5
#define PER_CHAIN_HT_CSD__HT_CSD_CHN2_4CHAINS__MASK                 0x01f00000U
#define PER_CHAIN_HT_CSD__HT_CSD_CHN2_4CHAINS__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x01f00000U) >> 20)
#define PER_CHAIN_HT_CSD__HT_CSD_CHN2_4CHAINS__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 20) & 0x01f00000U)
#define PER_CHAIN_HT_CSD__HT_CSD_CHN2_4CHAINS__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x01f00000U) | (((u_int32_t)(src) <<\
                    20) & 0x01f00000U)
#define PER_CHAIN_HT_CSD__HT_CSD_CHN2_4CHAINS__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 20) & ~0x01f00000U)))

/* macros for field ht_csd_chn3_4chains */
#define PER_CHAIN_HT_CSD__HT_CSD_CHN3_4CHAINS__SHIFT                         25
#define PER_CHAIN_HT_CSD__HT_CSD_CHN3_4CHAINS__WIDTH                          5
#define PER_CHAIN_HT_CSD__HT_CSD_CHN3_4CHAINS__MASK                 0x3e000000U
#define PER_CHAIN_HT_CSD__HT_CSD_CHN3_4CHAINS__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x3e000000U) >> 25)
#define PER_CHAIN_HT_CSD__HT_CSD_CHN3_4CHAINS__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 25) & 0x3e000000U)
#define PER_CHAIN_HT_CSD__HT_CSD_CHN3_4CHAINS__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x3e000000U) | (((u_int32_t)(src) <<\
                    25) & 0x3e000000U)
#define PER_CHAIN_HT_CSD__HT_CSD_CHN3_4CHAINS__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 25) & ~0x3e000000U)))
#define PER_CHAIN_HT_CSD__TYPE                                        u_int32_t
#define PER_CHAIN_HT_CSD__READ                                      0x3fffffffU
#define PER_CHAIN_HT_CSD__WRITE                                     0x3fffffffU

#endif /* __PER_CHAIN_HT_CSD_MACRO__ */


/* macros for bb_reg_map.bb_chn_reg_map.BB_per_chain_ht_csd */
#define INST_BB_REG_MAP__BB_CHN_REG_MAP__BB_PER_CHAIN_HT_CSD__NUM             1

/* macros for BlueprintGlobalNameSpace::pre_emphasis_bw20_b0 */
#ifndef __PRE_EMPHASIS_BW20_B0_MACRO__
#define __PRE_EMPHASIS_BW20_B0_MACRO__

/* macros for field pre_emp_db_pos_bw20_0 */
#define PRE_EMPHASIS_BW20_B0__PRE_EMP_DB_POS_BW20_0__SHIFT                    0
#define PRE_EMPHASIS_BW20_B0__PRE_EMP_DB_POS_BW20_0__WIDTH                   15
#define PRE_EMPHASIS_BW20_B0__PRE_EMP_DB_POS_BW20_0__MASK           0x00007fffU
#define PRE_EMPHASIS_BW20_B0__PRE_EMP_DB_POS_BW20_0__READ(src) \
                    (u_int32_t)(src)\
                    & 0x00007fffU
#define PRE_EMPHASIS_BW20_B0__PRE_EMP_DB_POS_BW20_0__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x00007fffU)
#define PRE_EMPHASIS_BW20_B0__PRE_EMP_DB_POS_BW20_0__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00007fffU) | ((u_int32_t)(src) &\
                    0x00007fffU)
#define PRE_EMPHASIS_BW20_B0__PRE_EMP_DB_POS_BW20_0__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00007fffU)))

/* macros for field pre_emp_db_neg_bw20_0 */
#define PRE_EMPHASIS_BW20_B0__PRE_EMP_DB_NEG_BW20_0__SHIFT                   15
#define PRE_EMPHASIS_BW20_B0__PRE_EMP_DB_NEG_BW20_0__WIDTH                   15
#define PRE_EMPHASIS_BW20_B0__PRE_EMP_DB_NEG_BW20_0__MASK           0x3fff8000U
#define PRE_EMPHASIS_BW20_B0__PRE_EMP_DB_NEG_BW20_0__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x3fff8000U) >> 15)
#define PRE_EMPHASIS_BW20_B0__PRE_EMP_DB_NEG_BW20_0__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 15) & 0x3fff8000U)
#define PRE_EMPHASIS_BW20_B0__PRE_EMP_DB_NEG_BW20_0__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x3fff8000U) | (((u_int32_t)(src) <<\
                    15) & 0x3fff8000U)
#define PRE_EMPHASIS_BW20_B0__PRE_EMP_DB_NEG_BW20_0__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 15) & ~0x3fff8000U)))
#define PRE_EMPHASIS_BW20_B0__TYPE                                    u_int32_t
#define PRE_EMPHASIS_BW20_B0__READ                                  0x3fffffffU
#define PRE_EMPHASIS_BW20_B0__WRITE                                 0x3fffffffU

#endif /* __PRE_EMPHASIS_BW20_B0_MACRO__ */


/* macros for bb_reg_map.bb_chn_reg_map.BB_pre_emphasis_bw20_b0 */
#define INST_BB_REG_MAP__BB_CHN_REG_MAP__BB_PRE_EMPHASIS_BW20_B0__NUM         1

/* macros for BlueprintGlobalNameSpace::pre_emphasis_bw40_b0 */
#ifndef __PRE_EMPHASIS_BW40_B0_MACRO__
#define __PRE_EMPHASIS_BW40_B0_MACRO__

/* macros for field pre_emp_db_pos_bw40_0 */
#define PRE_EMPHASIS_BW40_B0__PRE_EMP_DB_POS_BW40_0__SHIFT                    0
#define PRE_EMPHASIS_BW40_B0__PRE_EMP_DB_POS_BW40_0__WIDTH                   15
#define PRE_EMPHASIS_BW40_B0__PRE_EMP_DB_POS_BW40_0__MASK           0x00007fffU
#define PRE_EMPHASIS_BW40_B0__PRE_EMP_DB_POS_BW40_0__READ(src) \
                    (u_int32_t)(src)\
                    & 0x00007fffU
#define PRE_EMPHASIS_BW40_B0__PRE_EMP_DB_POS_BW40_0__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x00007fffU)
#define PRE_EMPHASIS_BW40_B0__PRE_EMP_DB_POS_BW40_0__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00007fffU) | ((u_int32_t)(src) &\
                    0x00007fffU)
#define PRE_EMPHASIS_BW40_B0__PRE_EMP_DB_POS_BW40_0__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00007fffU)))

/* macros for field pre_emp_db_neg_bw40_0 */
#define PRE_EMPHASIS_BW40_B0__PRE_EMP_DB_NEG_BW40_0__SHIFT                   15
#define PRE_EMPHASIS_BW40_B0__PRE_EMP_DB_NEG_BW40_0__WIDTH                   15
#define PRE_EMPHASIS_BW40_B0__PRE_EMP_DB_NEG_BW40_0__MASK           0x3fff8000U
#define PRE_EMPHASIS_BW40_B0__PRE_EMP_DB_NEG_BW40_0__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x3fff8000U) >> 15)
#define PRE_EMPHASIS_BW40_B0__PRE_EMP_DB_NEG_BW40_0__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 15) & 0x3fff8000U)
#define PRE_EMPHASIS_BW40_B0__PRE_EMP_DB_NEG_BW40_0__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x3fff8000U) | (((u_int32_t)(src) <<\
                    15) & 0x3fff8000U)
#define PRE_EMPHASIS_BW40_B0__PRE_EMP_DB_NEG_BW40_0__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 15) & ~0x3fff8000U)))
#define PRE_EMPHASIS_BW40_B0__TYPE                                    u_int32_t
#define PRE_EMPHASIS_BW40_B0__READ                                  0x3fffffffU
#define PRE_EMPHASIS_BW40_B0__WRITE                                 0x3fffffffU

#endif /* __PRE_EMPHASIS_BW40_B0_MACRO__ */


/* macros for bb_reg_map.bb_chn_reg_map.BB_pre_emphasis_bw40_b0 */
#define INST_BB_REG_MAP__BB_CHN_REG_MAP__BB_PRE_EMPHASIS_BW40_B0__NUM         1

/* macros for BlueprintGlobalNameSpace::pre_emphasis_bw80_b0 */
#ifndef __PRE_EMPHASIS_BW80_B0_MACRO__
#define __PRE_EMPHASIS_BW80_B0_MACRO__

/* macros for field pre_emp_db_pos_bw80_0 */
#define PRE_EMPHASIS_BW80_B0__PRE_EMP_DB_POS_BW80_0__SHIFT                    0
#define PRE_EMPHASIS_BW80_B0__PRE_EMP_DB_POS_BW80_0__WIDTH                   15
#define PRE_EMPHASIS_BW80_B0__PRE_EMP_DB_POS_BW80_0__MASK           0x00007fffU
#define PRE_EMPHASIS_BW80_B0__PRE_EMP_DB_POS_BW80_0__READ(src) \
                    (u_int32_t)(src)\
                    & 0x00007fffU
#define PRE_EMPHASIS_BW80_B0__PRE_EMP_DB_POS_BW80_0__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x00007fffU)
#define PRE_EMPHASIS_BW80_B0__PRE_EMP_DB_POS_BW80_0__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00007fffU) | ((u_int32_t)(src) &\
                    0x00007fffU)
#define PRE_EMPHASIS_BW80_B0__PRE_EMP_DB_POS_BW80_0__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00007fffU)))

/* macros for field pre_emp_db_neg_bw80_0 */
#define PRE_EMPHASIS_BW80_B0__PRE_EMP_DB_NEG_BW80_0__SHIFT                   15
#define PRE_EMPHASIS_BW80_B0__PRE_EMP_DB_NEG_BW80_0__WIDTH                   15
#define PRE_EMPHASIS_BW80_B0__PRE_EMP_DB_NEG_BW80_0__MASK           0x3fff8000U
#define PRE_EMPHASIS_BW80_B0__PRE_EMP_DB_NEG_BW80_0__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x3fff8000U) >> 15)
#define PRE_EMPHASIS_BW80_B0__PRE_EMP_DB_NEG_BW80_0__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 15) & 0x3fff8000U)
#define PRE_EMPHASIS_BW80_B0__PRE_EMP_DB_NEG_BW80_0__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x3fff8000U) | (((u_int32_t)(src) <<\
                    15) & 0x3fff8000U)
#define PRE_EMPHASIS_BW80_B0__PRE_EMP_DB_NEG_BW80_0__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 15) & ~0x3fff8000U)))
#define PRE_EMPHASIS_BW80_B0__TYPE                                    u_int32_t
#define PRE_EMPHASIS_BW80_B0__READ                                  0x3fffffffU
#define PRE_EMPHASIS_BW80_B0__WRITE                                 0x3fffffffU

#endif /* __PRE_EMPHASIS_BW80_B0_MACRO__ */


/* macros for bb_reg_map.bb_chn_reg_map.BB_pre_emphasis_bw80_b0 */
#define INST_BB_REG_MAP__BB_CHN_REG_MAP__BB_PRE_EMPHASIS_BW80_B0__NUM         1

/* macros for BlueprintGlobalNameSpace::chn_tables_intf_addr */
#ifndef __CHN_TABLES_INTF_ADDR_MACRO__
#define __CHN_TABLES_INTF_ADDR_MACRO__

/* macros for field chn_tables_addr */
#define CHN_TABLES_INTF_ADDR__CHN_TABLES_ADDR__SHIFT                          2
#define CHN_TABLES_INTF_ADDR__CHN_TABLES_ADDR__WIDTH                         16
#define CHN_TABLES_INTF_ADDR__CHN_TABLES_ADDR__MASK                 0x0003fffcU
#define CHN_TABLES_INTF_ADDR__CHN_TABLES_ADDR__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0003fffcU) >> 2)
#define CHN_TABLES_INTF_ADDR__CHN_TABLES_ADDR__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 2) & 0x0003fffcU)
#define CHN_TABLES_INTF_ADDR__CHN_TABLES_ADDR__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0003fffcU) | (((u_int32_t)(src) <<\
                    2) & 0x0003fffcU)
#define CHN_TABLES_INTF_ADDR__CHN_TABLES_ADDR__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 2) & ~0x0003fffcU)))

/* macros for field chn_addr_auto_incr */
#define CHN_TABLES_INTF_ADDR__CHN_ADDR_AUTO_INCR__SHIFT                      31
#define CHN_TABLES_INTF_ADDR__CHN_ADDR_AUTO_INCR__WIDTH                       1
#define CHN_TABLES_INTF_ADDR__CHN_ADDR_AUTO_INCR__MASK              0x80000000U
#define CHN_TABLES_INTF_ADDR__CHN_ADDR_AUTO_INCR__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x80000000U) >> 31)
#define CHN_TABLES_INTF_ADDR__CHN_ADDR_AUTO_INCR__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 31) & 0x80000000U)
#define CHN_TABLES_INTF_ADDR__CHN_ADDR_AUTO_INCR__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x80000000U) | (((u_int32_t)(src) <<\
                    31) & 0x80000000U)
#define CHN_TABLES_INTF_ADDR__CHN_ADDR_AUTO_INCR__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 31) & ~0x80000000U)))
#define CHN_TABLES_INTF_ADDR__CHN_ADDR_AUTO_INCR__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x80000000U) | ((u_int32_t)(1) << 31)
#define CHN_TABLES_INTF_ADDR__CHN_ADDR_AUTO_INCR__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x80000000U) | ((u_int32_t)(0) << 31)
#define CHN_TABLES_INTF_ADDR__TYPE                                    u_int32_t
#define CHN_TABLES_INTF_ADDR__READ                                  0x8003fffcU
#define CHN_TABLES_INTF_ADDR__WRITE                                 0x8003fffcU

#endif /* __CHN_TABLES_INTF_ADDR_MACRO__ */


/* macros for bb_reg_map.bb_chn_reg_map.BB_chn_tables_intf_addr */
#define INST_BB_REG_MAP__BB_CHN_REG_MAP__BB_CHN_TABLES_INTF_ADDR__NUM         1

/* macros for BlueprintGlobalNameSpace::chn_tables_intf_data */
#ifndef __CHN_TABLES_INTF_DATA_MACRO__
#define __CHN_TABLES_INTF_DATA_MACRO__

/* macros for field chn_tables_data */
#define CHN_TABLES_INTF_DATA__CHN_TABLES_DATA__SHIFT                          0
#define CHN_TABLES_INTF_DATA__CHN_TABLES_DATA__WIDTH                         32
#define CHN_TABLES_INTF_DATA__CHN_TABLES_DATA__MASK                 0xffffffffU
#define CHN_TABLES_INTF_DATA__CHN_TABLES_DATA__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define CHN_TABLES_INTF_DATA__CHN_TABLES_DATA__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0xffffffffU)
#define CHN_TABLES_INTF_DATA__CHN_TABLES_DATA__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xffffffffU) | ((u_int32_t)(src) &\
                    0xffffffffU)
#define CHN_TABLES_INTF_DATA__CHN_TABLES_DATA__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0xffffffffU)))
#define CHN_TABLES_INTF_DATA__TYPE                                    u_int32_t
#define CHN_TABLES_INTF_DATA__READ                                  0xffffffffU
#define CHN_TABLES_INTF_DATA__WRITE                                 0xffffffffU

#endif /* __CHN_TABLES_INTF_DATA_MACRO__ */


/* macros for bb_reg_map.bb_chn_reg_map.BB_chn_tables_intf_data */
#define INST_BB_REG_MAP__BB_CHN_REG_MAP__BB_CHN_TABLES_INTF_DATA__NUM         1

/* macros for BlueprintGlobalNameSpace::phydbg_control1 */
#ifndef __PHYDBG_CONTROL1_MACRO__
#define __PHYDBG_CONTROL1_MACRO__

/* macros for field phydbg_cap_pre_store */
#define PHYDBG_CONTROL1__PHYDBG_CAP_PRE_STORE__SHIFT                          0
#define PHYDBG_CONTROL1__PHYDBG_CAP_PRE_STORE__WIDTH                         14
#define PHYDBG_CONTROL1__PHYDBG_CAP_PRE_STORE__MASK                 0x00003fffU
#define PHYDBG_CONTROL1__PHYDBG_CAP_PRE_STORE__READ(src) \
                    (u_int32_t)(src)\
                    & 0x00003fffU
#define PHYDBG_CONTROL1__PHYDBG_CAP_PRE_STORE__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x00003fffU)
#define PHYDBG_CONTROL1__PHYDBG_CAP_PRE_STORE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00003fffU) | ((u_int32_t)(src) &\
                    0x00003fffU)
#define PHYDBG_CONTROL1__PHYDBG_CAP_PRE_STORE__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00003fffU)))

/* macros for field phydbg_plybck_trig_mode */
#define PHYDBG_CONTROL1__PHYDBG_PLYBCK_TRIG_MODE__SHIFT                      14
#define PHYDBG_CONTROL1__PHYDBG_PLYBCK_TRIG_MODE__WIDTH                       1
#define PHYDBG_CONTROL1__PHYDBG_PLYBCK_TRIG_MODE__MASK              0x00004000U
#define PHYDBG_CONTROL1__PHYDBG_PLYBCK_TRIG_MODE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00004000U) >> 14)
#define PHYDBG_CONTROL1__PHYDBG_PLYBCK_TRIG_MODE__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 14) & 0x00004000U)
#define PHYDBG_CONTROL1__PHYDBG_PLYBCK_TRIG_MODE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00004000U) | (((u_int32_t)(src) <<\
                    14) & 0x00004000U)
#define PHYDBG_CONTROL1__PHYDBG_PLYBCK_TRIG_MODE__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 14) & ~0x00004000U)))
#define PHYDBG_CONTROL1__PHYDBG_PLYBCK_TRIG_MODE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00004000U) | ((u_int32_t)(1) << 14)
#define PHYDBG_CONTROL1__PHYDBG_PLYBCK_TRIG_MODE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00004000U) | ((u_int32_t)(0) << 14)

/* macros for field phydbg_cap_trig_mode */
#define PHYDBG_CONTROL1__PHYDBG_CAP_TRIG_MODE__SHIFT                         15
#define PHYDBG_CONTROL1__PHYDBG_CAP_TRIG_MODE__WIDTH                          1
#define PHYDBG_CONTROL1__PHYDBG_CAP_TRIG_MODE__MASK                 0x00008000U
#define PHYDBG_CONTROL1__PHYDBG_CAP_TRIG_MODE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00008000U) >> 15)
#define PHYDBG_CONTROL1__PHYDBG_CAP_TRIG_MODE__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 15) & 0x00008000U)
#define PHYDBG_CONTROL1__PHYDBG_CAP_TRIG_MODE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00008000U) | (((u_int32_t)(src) <<\
                    15) & 0x00008000U)
#define PHYDBG_CONTROL1__PHYDBG_CAP_TRIG_MODE__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 15) & ~0x00008000U)))
#define PHYDBG_CONTROL1__PHYDBG_CAP_TRIG_MODE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00008000U) | ((u_int32_t)(1) << 15)
#define PHYDBG_CONTROL1__PHYDBG_CAP_TRIG_MODE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00008000U) | ((u_int32_t)(0) << 15)

/* macros for field phydbg_plybck_count */
#define PHYDBG_CONTROL1__PHYDBG_PLYBCK_COUNT__SHIFT                          16
#define PHYDBG_CONTROL1__PHYDBG_PLYBCK_COUNT__WIDTH                          14
#define PHYDBG_CONTROL1__PHYDBG_PLYBCK_COUNT__MASK                  0x3fff0000U
#define PHYDBG_CONTROL1__PHYDBG_PLYBCK_COUNT__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x3fff0000U) >> 16)
#define PHYDBG_CONTROL1__PHYDBG_PLYBCK_COUNT__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 16) & 0x3fff0000U)
#define PHYDBG_CONTROL1__PHYDBG_PLYBCK_COUNT__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x3fff0000U) | (((u_int32_t)(src) <<\
                    16) & 0x3fff0000U)
#define PHYDBG_CONTROL1__PHYDBG_PLYBCK_COUNT__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 16) & ~0x3fff0000U)))

/* macros for field phydbg_cap_chn_sel */
#define PHYDBG_CONTROL1__PHYDBG_CAP_CHN_SEL__SHIFT                           30
#define PHYDBG_CONTROL1__PHYDBG_CAP_CHN_SEL__WIDTH                            2
#define PHYDBG_CONTROL1__PHYDBG_CAP_CHN_SEL__MASK                   0xc0000000U
#define PHYDBG_CONTROL1__PHYDBG_CAP_CHN_SEL__READ(src) \
                    (((u_int32_t)(src)\
                    & 0xc0000000U) >> 30)
#define PHYDBG_CONTROL1__PHYDBG_CAP_CHN_SEL__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 30) & 0xc0000000U)
#define PHYDBG_CONTROL1__PHYDBG_CAP_CHN_SEL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xc0000000U) | (((u_int32_t)(src) <<\
                    30) & 0xc0000000U)
#define PHYDBG_CONTROL1__PHYDBG_CAP_CHN_SEL__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 30) & ~0xc0000000U)))
#define PHYDBG_CONTROL1__TYPE                                         u_int32_t
#define PHYDBG_CONTROL1__READ                                       0xffffffffU
#define PHYDBG_CONTROL1__WRITE                                      0xffffffffU

#endif /* __PHYDBG_CONTROL1_MACRO__ */


/* macros for bb_reg_map.bb_chn_reg_map.BB_phydbg_control1 */
#define INST_BB_REG_MAP__BB_CHN_REG_MAP__BB_PHYDBG_CONTROL1__NUM              1

/* macros for BlueprintGlobalNameSpace::phydbg_control2 */
#ifndef __PHYDBG_CONTROL2_MACRO__
#define __PHYDBG_CONTROL2_MACRO__

/* macros for field phydbg_mode */
#define PHYDBG_CONTROL2__PHYDBG_MODE__SHIFT                                   0
#define PHYDBG_CONTROL2__PHYDBG_MODE__WIDTH                                   4
#define PHYDBG_CONTROL2__PHYDBG_MODE__MASK                          0x0000000fU
#define PHYDBG_CONTROL2__PHYDBG_MODE__READ(src)  (u_int32_t)(src) & 0x0000000fU
#define PHYDBG_CONTROL2__PHYDBG_MODE__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x0000000fU)
#define PHYDBG_CONTROL2__PHYDBG_MODE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000000fU) | ((u_int32_t)(src) &\
                    0x0000000fU)
#define PHYDBG_CONTROL2__PHYDBG_MODE__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x0000000fU)))

/* macros for field phydbg_plybck_en */
#define PHYDBG_CONTROL2__PHYDBG_PLYBCK_EN__SHIFT                              4
#define PHYDBG_CONTROL2__PHYDBG_PLYBCK_EN__WIDTH                              1
#define PHYDBG_CONTROL2__PHYDBG_PLYBCK_EN__MASK                     0x00000010U
#define PHYDBG_CONTROL2__PHYDBG_PLYBCK_EN__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000010U) >> 4)
#define PHYDBG_CONTROL2__PHYDBG_PLYBCK_EN__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 4) & 0x00000010U)
#define PHYDBG_CONTROL2__PHYDBG_PLYBCK_EN__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000010U) | (((u_int32_t)(src) <<\
                    4) & 0x00000010U)
#define PHYDBG_CONTROL2__PHYDBG_PLYBCK_EN__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 4) & ~0x00000010U)))
#define PHYDBG_CONTROL2__PHYDBG_PLYBCK_EN__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000010U) | ((u_int32_t)(1) << 4)
#define PHYDBG_CONTROL2__PHYDBG_PLYBCK_EN__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000010U) | ((u_int32_t)(0) << 4)

/* macros for field phydbg_apb_autoincr */
#define PHYDBG_CONTROL2__PHYDBG_APB_AUTOINCR__SHIFT                           5
#define PHYDBG_CONTROL2__PHYDBG_APB_AUTOINCR__WIDTH                           2
#define PHYDBG_CONTROL2__PHYDBG_APB_AUTOINCR__MASK                  0x00000060U
#define PHYDBG_CONTROL2__PHYDBG_APB_AUTOINCR__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000060U) >> 5)
#define PHYDBG_CONTROL2__PHYDBG_APB_AUTOINCR__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 5) & 0x00000060U)
#define PHYDBG_CONTROL2__PHYDBG_APB_AUTOINCR__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000060U) | (((u_int32_t)(src) <<\
                    5) & 0x00000060U)
#define PHYDBG_CONTROL2__PHYDBG_APB_AUTOINCR__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 5) & ~0x00000060U)))

/* macros for field phydbg_fsmstate */
#define PHYDBG_CONTROL2__PHYDBG_FSMSTATE__SHIFT                               7
#define PHYDBG_CONTROL2__PHYDBG_FSMSTATE__WIDTH                               4
#define PHYDBG_CONTROL2__PHYDBG_FSMSTATE__MASK                      0x00000780U
#define PHYDBG_CONTROL2__PHYDBG_FSMSTATE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000780U) >> 7)
#define PHYDBG_CONTROL2__PHYDBG_FSMSTATE__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 7) & 0x00000780U)
#define PHYDBG_CONTROL2__PHYDBG_FSMSTATE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000780U) | (((u_int32_t)(src) <<\
                    7) & 0x00000780U)
#define PHYDBG_CONTROL2__PHYDBG_FSMSTATE__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 7) & ~0x00000780U)))

/* macros for field phydbg_cap_trig_select */
#define PHYDBG_CONTROL2__PHYDBG_CAP_TRIG_SELECT__SHIFT                       11
#define PHYDBG_CONTROL2__PHYDBG_CAP_TRIG_SELECT__WIDTH                        5
#define PHYDBG_CONTROL2__PHYDBG_CAP_TRIG_SELECT__MASK               0x0000f800U
#define PHYDBG_CONTROL2__PHYDBG_CAP_TRIG_SELECT__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0000f800U) >> 11)
#define PHYDBG_CONTROL2__PHYDBG_CAP_TRIG_SELECT__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 11) & 0x0000f800U)
#define PHYDBG_CONTROL2__PHYDBG_CAP_TRIG_SELECT__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000f800U) | (((u_int32_t)(src) <<\
                    11) & 0x0000f800U)
#define PHYDBG_CONTROL2__PHYDBG_CAP_TRIG_SELECT__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 11) & ~0x0000f800U)))

/* macros for field phydbg_cap_trig_addr */
#define PHYDBG_CONTROL2__PHYDBG_CAP_TRIG_ADDR__SHIFT                         16
#define PHYDBG_CONTROL2__PHYDBG_CAP_TRIG_ADDR__WIDTH                         15
#define PHYDBG_CONTROL2__PHYDBG_CAP_TRIG_ADDR__MASK                 0x7fff0000U
#define PHYDBG_CONTROL2__PHYDBG_CAP_TRIG_ADDR__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x7fff0000U) >> 16)

/* macros for field phydbg_cap_en */
#define PHYDBG_CONTROL2__PHYDBG_CAP_EN__SHIFT                                31
#define PHYDBG_CONTROL2__PHYDBG_CAP_EN__WIDTH                                 1
#define PHYDBG_CONTROL2__PHYDBG_CAP_EN__MASK                        0x80000000U
#define PHYDBG_CONTROL2__PHYDBG_CAP_EN__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x80000000U) >> 31)
#define PHYDBG_CONTROL2__PHYDBG_CAP_EN__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 31) & 0x80000000U)
#define PHYDBG_CONTROL2__PHYDBG_CAP_EN__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x80000000U) | (((u_int32_t)(src) <<\
                    31) & 0x80000000U)
#define PHYDBG_CONTROL2__PHYDBG_CAP_EN__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 31) & ~0x80000000U)))
#define PHYDBG_CONTROL2__PHYDBG_CAP_EN__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x80000000U) | ((u_int32_t)(1) << 31)
#define PHYDBG_CONTROL2__PHYDBG_CAP_EN__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x80000000U) | ((u_int32_t)(0) << 31)
#define PHYDBG_CONTROL2__TYPE                                         u_int32_t
#define PHYDBG_CONTROL2__READ                                       0xffffffffU
#define PHYDBG_CONTROL2__WRITE                                      0xffffffffU

#endif /* __PHYDBG_CONTROL2_MACRO__ */


/* macros for bb_reg_map.bb_chn_reg_map.BB_phydbg_control2 */
#define INST_BB_REG_MAP__BB_CHN_REG_MAP__BB_PHYDBG_CONTROL2__NUM              1

/* macros for BlueprintGlobalNameSpace::tstdac_constant */
#ifndef __TSTDAC_CONSTANT_MACRO__
#define __TSTDAC_CONSTANT_MACRO__

/* macros for field cf_tstdac_constant_i */
#define TSTDAC_CONSTANT__CF_TSTDAC_CONSTANT_I__SHIFT                          0
#define TSTDAC_CONSTANT__CF_TSTDAC_CONSTANT_I__WIDTH                         11
#define TSTDAC_CONSTANT__CF_TSTDAC_CONSTANT_I__MASK                 0x000007ffU
#define TSTDAC_CONSTANT__CF_TSTDAC_CONSTANT_I__READ(src) \
                    (u_int32_t)(src)\
                    & 0x000007ffU
#define TSTDAC_CONSTANT__CF_TSTDAC_CONSTANT_I__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x000007ffU)
#define TSTDAC_CONSTANT__CF_TSTDAC_CONSTANT_I__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000007ffU) | ((u_int32_t)(src) &\
                    0x000007ffU)
#define TSTDAC_CONSTANT__CF_TSTDAC_CONSTANT_I__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x000007ffU)))

/* macros for field cf_tstdac_constant_q */
#define TSTDAC_CONSTANT__CF_TSTDAC_CONSTANT_Q__SHIFT                         11
#define TSTDAC_CONSTANT__CF_TSTDAC_CONSTANT_Q__WIDTH                         11
#define TSTDAC_CONSTANT__CF_TSTDAC_CONSTANT_Q__MASK                 0x003ff800U
#define TSTDAC_CONSTANT__CF_TSTDAC_CONSTANT_Q__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x003ff800U) >> 11)
#define TSTDAC_CONSTANT__CF_TSTDAC_CONSTANT_Q__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 11) & 0x003ff800U)
#define TSTDAC_CONSTANT__CF_TSTDAC_CONSTANT_Q__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x003ff800U) | (((u_int32_t)(src) <<\
                    11) & 0x003ff800U)
#define TSTDAC_CONSTANT__CF_TSTDAC_CONSTANT_Q__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 11) & ~0x003ff800U)))
#define TSTDAC_CONSTANT__TYPE                                         u_int32_t
#define TSTDAC_CONSTANT__READ                                       0x003fffffU
#define TSTDAC_CONSTANT__WRITE                                      0x003fffffU

#endif /* __TSTDAC_CONSTANT_MACRO__ */


/* macros for bb_reg_map.bb_chn_reg_map.BB_tstdac_constant */
#define INST_BB_REG_MAP__BB_CHN_REG_MAP__BB_TSTDAC_CONSTANT__NUM              1

/* macros for BlueprintGlobalNameSpace::spur_report_b0 */
#ifndef __SPUR_REPORT_B0_MACRO__
#define __SPUR_REPORT_B0_MACRO__

/* macros for field spur_est_i_0 */
#define SPUR_REPORT_B0__SPUR_EST_I_0__SHIFT                                   0
#define SPUR_REPORT_B0__SPUR_EST_I_0__WIDTH                                   8
#define SPUR_REPORT_B0__SPUR_EST_I_0__MASK                          0x000000ffU
#define SPUR_REPORT_B0__SPUR_EST_I_0__READ(src)  (u_int32_t)(src) & 0x000000ffU

/* macros for field spur_est_q_0 */
#define SPUR_REPORT_B0__SPUR_EST_Q_0__SHIFT                                   8
#define SPUR_REPORT_B0__SPUR_EST_Q_0__WIDTH                                   8
#define SPUR_REPORT_B0__SPUR_EST_Q_0__MASK                          0x0000ff00U
#define SPUR_REPORT_B0__SPUR_EST_Q_0__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0000ff00U) >> 8)

/* macros for field power_with_spur_removed_0 */
#define SPUR_REPORT_B0__POWER_WITH_SPUR_REMOVED_0__SHIFT                     16
#define SPUR_REPORT_B0__POWER_WITH_SPUR_REMOVED_0__WIDTH                     16
#define SPUR_REPORT_B0__POWER_WITH_SPUR_REMOVED_0__MASK             0xffff0000U
#define SPUR_REPORT_B0__POWER_WITH_SPUR_REMOVED_0__READ(src) \
                    (((u_int32_t)(src)\
                    & 0xffff0000U) >> 16)
#define SPUR_REPORT_B0__TYPE                                          u_int32_t
#define SPUR_REPORT_B0__READ                                        0xffffffffU

#endif /* __SPUR_REPORT_B0_MACRO__ */


/* macros for bb_reg_map.bb_chn_reg_map.BB_spur_report_b0 */
#define INST_BB_REG_MAP__BB_CHN_REG_MAP__BB_SPUR_REPORT_B0__NUM               1

/* macros for BlueprintGlobalNameSpace::green_tx_control_1 */
#ifndef __GREEN_TX_CONTROL_1_MACRO__
#define __GREEN_TX_CONTROL_1_MACRO__

/* macros for field green_tx_enable */
#define GREEN_TX_CONTROL_1__GREEN_TX_ENABLE__SHIFT                            0
#define GREEN_TX_CONTROL_1__GREEN_TX_ENABLE__WIDTH                            1
#define GREEN_TX_CONTROL_1__GREEN_TX_ENABLE__MASK                   0x00000001U
#define GREEN_TX_CONTROL_1__GREEN_TX_ENABLE__READ(src) \
                    (u_int32_t)(src)\
                    & 0x00000001U
#define GREEN_TX_CONTROL_1__GREEN_TX_ENABLE__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x00000001U)
#define GREEN_TX_CONTROL_1__GREEN_TX_ENABLE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | ((u_int32_t)(src) &\
                    0x00000001U)
#define GREEN_TX_CONTROL_1__GREEN_TX_ENABLE__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00000001U)))
#define GREEN_TX_CONTROL_1__GREEN_TX_ENABLE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(1)
#define GREEN_TX_CONTROL_1__GREEN_TX_ENABLE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(0)

/* macros for field green_cases */
#define GREEN_TX_CONTROL_1__GREEN_CASES__SHIFT                                1
#define GREEN_TX_CONTROL_1__GREEN_CASES__WIDTH                                1
#define GREEN_TX_CONTROL_1__GREEN_CASES__MASK                       0x00000002U
#define GREEN_TX_CONTROL_1__GREEN_CASES__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000002U) >> 1)
#define GREEN_TX_CONTROL_1__GREEN_CASES__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 1) & 0x00000002U)
#define GREEN_TX_CONTROL_1__GREEN_CASES__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | (((u_int32_t)(src) <<\
                    1) & 0x00000002U)
#define GREEN_TX_CONTROL_1__GREEN_CASES__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 1) & ~0x00000002U)))
#define GREEN_TX_CONTROL_1__GREEN_CASES__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | ((u_int32_t)(1) << 1)
#define GREEN_TX_CONTROL_1__GREEN_CASES__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | ((u_int32_t)(0) << 1)
#define GREEN_TX_CONTROL_1__TYPE                                      u_int32_t
#define GREEN_TX_CONTROL_1__READ                                    0x00000003U
#define GREEN_TX_CONTROL_1__WRITE                                   0x00000003U

#endif /* __GREEN_TX_CONTROL_1_MACRO__ */


/* macros for bb_reg_map.bb_chn_reg_map.BB_green_tx_control_1 */
#define INST_BB_REG_MAP__BB_CHN_REG_MAP__BB_GREEN_TX_CONTROL_1__NUM           1

/* macros for BlueprintGlobalNameSpace::iq_adc_meas_0_b0 */
#ifndef __IQ_ADC_MEAS_0_B0_MACRO__
#define __IQ_ADC_MEAS_0_B0_MACRO__

/* macros for field gain_dc_iq_cal_meas_0_0 */
#define IQ_ADC_MEAS_0_B0__GAIN_DC_IQ_CAL_MEAS_0_0__SHIFT                      0
#define IQ_ADC_MEAS_0_B0__GAIN_DC_IQ_CAL_MEAS_0_0__WIDTH                     32
#define IQ_ADC_MEAS_0_B0__GAIN_DC_IQ_CAL_MEAS_0_0__MASK             0xffffffffU
#define IQ_ADC_MEAS_0_B0__GAIN_DC_IQ_CAL_MEAS_0_0__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define IQ_ADC_MEAS_0_B0__TYPE                                        u_int32_t
#define IQ_ADC_MEAS_0_B0__READ                                      0xffffffffU

#endif /* __IQ_ADC_MEAS_0_B0_MACRO__ */


/* macros for bb_reg_map.bb_chn_reg_map.BB_iq_adc_meas_0_b0 */
#define INST_BB_REG_MAP__BB_CHN_REG_MAP__BB_IQ_ADC_MEAS_0_B0__NUM             1

/* macros for BlueprintGlobalNameSpace::iq_adc_meas_1_b0 */
#ifndef __IQ_ADC_MEAS_1_B0_MACRO__
#define __IQ_ADC_MEAS_1_B0_MACRO__

/* macros for field gain_dc_iq_cal_meas_1_0 */
#define IQ_ADC_MEAS_1_B0__GAIN_DC_IQ_CAL_MEAS_1_0__SHIFT                      0
#define IQ_ADC_MEAS_1_B0__GAIN_DC_IQ_CAL_MEAS_1_0__WIDTH                     32
#define IQ_ADC_MEAS_1_B0__GAIN_DC_IQ_CAL_MEAS_1_0__MASK             0xffffffffU
#define IQ_ADC_MEAS_1_B0__GAIN_DC_IQ_CAL_MEAS_1_0__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define IQ_ADC_MEAS_1_B0__TYPE                                        u_int32_t
#define IQ_ADC_MEAS_1_B0__READ                                      0xffffffffU

#endif /* __IQ_ADC_MEAS_1_B0_MACRO__ */


/* macros for bb_reg_map.bb_chn_reg_map.BB_iq_adc_meas_1_b0 */
#define INST_BB_REG_MAP__BB_CHN_REG_MAP__BB_IQ_ADC_MEAS_1_B0__NUM             1

/* macros for BlueprintGlobalNameSpace::iq_adc_meas_2_b0 */
#ifndef __IQ_ADC_MEAS_2_B0_MACRO__
#define __IQ_ADC_MEAS_2_B0_MACRO__

/* macros for field gain_dc_iq_cal_meas_2_0 */
#define IQ_ADC_MEAS_2_B0__GAIN_DC_IQ_CAL_MEAS_2_0__SHIFT                      0
#define IQ_ADC_MEAS_2_B0__GAIN_DC_IQ_CAL_MEAS_2_0__WIDTH                     32
#define IQ_ADC_MEAS_2_B0__GAIN_DC_IQ_CAL_MEAS_2_0__MASK             0xffffffffU
#define IQ_ADC_MEAS_2_B0__GAIN_DC_IQ_CAL_MEAS_2_0__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define IQ_ADC_MEAS_2_B0__TYPE                                        u_int32_t
#define IQ_ADC_MEAS_2_B0__READ                                      0xffffffffU

#endif /* __IQ_ADC_MEAS_2_B0_MACRO__ */


/* macros for bb_reg_map.bb_chn_reg_map.BB_iq_adc_meas_2_b0 */
#define INST_BB_REG_MAP__BB_CHN_REG_MAP__BB_IQ_ADC_MEAS_2_B0__NUM             1

/* macros for BlueprintGlobalNameSpace::iq_adc_meas_3_b0 */
#ifndef __IQ_ADC_MEAS_3_B0_MACRO__
#define __IQ_ADC_MEAS_3_B0_MACRO__

/* macros for field gain_dc_iq_cal_meas_3_0 */
#define IQ_ADC_MEAS_3_B0__GAIN_DC_IQ_CAL_MEAS_3_0__SHIFT                      0
#define IQ_ADC_MEAS_3_B0__GAIN_DC_IQ_CAL_MEAS_3_0__WIDTH                     32
#define IQ_ADC_MEAS_3_B0__GAIN_DC_IQ_CAL_MEAS_3_0__MASK             0xffffffffU
#define IQ_ADC_MEAS_3_B0__GAIN_DC_IQ_CAL_MEAS_3_0__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define IQ_ADC_MEAS_3_B0__TYPE                                        u_int32_t
#define IQ_ADC_MEAS_3_B0__READ                                      0xffffffffU

#endif /* __IQ_ADC_MEAS_3_B0_MACRO__ */


/* macros for bb_reg_map.bb_chn_reg_map.BB_iq_adc_meas_3_b0 */
#define INST_BB_REG_MAP__BB_CHN_REG_MAP__BB_IQ_ADC_MEAS_3_B0__NUM             1

/* macros for BlueprintGlobalNameSpace::tx_phase_ramp_b0 */
#ifndef __TX_PHASE_RAMP_B0_MACRO__
#define __TX_PHASE_RAMP_B0_MACRO__

/* macros for field cf_phase_ramp_enable_0 */
#define TX_PHASE_RAMP_B0__CF_PHASE_RAMP_ENABLE_0__SHIFT                       0
#define TX_PHASE_RAMP_B0__CF_PHASE_RAMP_ENABLE_0__WIDTH                       1
#define TX_PHASE_RAMP_B0__CF_PHASE_RAMP_ENABLE_0__MASK              0x00000001U
#define TX_PHASE_RAMP_B0__CF_PHASE_RAMP_ENABLE_0__READ(src) \
                    (u_int32_t)(src)\
                    & 0x00000001U
#define TX_PHASE_RAMP_B0__CF_PHASE_RAMP_ENABLE_0__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x00000001U)
#define TX_PHASE_RAMP_B0__CF_PHASE_RAMP_ENABLE_0__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | ((u_int32_t)(src) &\
                    0x00000001U)
#define TX_PHASE_RAMP_B0__CF_PHASE_RAMP_ENABLE_0__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00000001U)))
#define TX_PHASE_RAMP_B0__CF_PHASE_RAMP_ENABLE_0__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(1)
#define TX_PHASE_RAMP_B0__CF_PHASE_RAMP_ENABLE_0__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(0)

/* macros for field cf_phase_ramp_bias_0 */
#define TX_PHASE_RAMP_B0__CF_PHASE_RAMP_BIAS_0__SHIFT                         1
#define TX_PHASE_RAMP_B0__CF_PHASE_RAMP_BIAS_0__WIDTH                         6
#define TX_PHASE_RAMP_B0__CF_PHASE_RAMP_BIAS_0__MASK                0x0000007eU
#define TX_PHASE_RAMP_B0__CF_PHASE_RAMP_BIAS_0__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0000007eU) >> 1)
#define TX_PHASE_RAMP_B0__CF_PHASE_RAMP_BIAS_0__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 1) & 0x0000007eU)
#define TX_PHASE_RAMP_B0__CF_PHASE_RAMP_BIAS_0__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000007eU) | (((u_int32_t)(src) <<\
                    1) & 0x0000007eU)
#define TX_PHASE_RAMP_B0__CF_PHASE_RAMP_BIAS_0__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 1) & ~0x0000007eU)))

/* macros for field cf_phase_ramp_init_0 */
#define TX_PHASE_RAMP_B0__CF_PHASE_RAMP_INIT_0__SHIFT                         7
#define TX_PHASE_RAMP_B0__CF_PHASE_RAMP_INIT_0__WIDTH                        10
#define TX_PHASE_RAMP_B0__CF_PHASE_RAMP_INIT_0__MASK                0x0001ff80U
#define TX_PHASE_RAMP_B0__CF_PHASE_RAMP_INIT_0__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0001ff80U) >> 7)
#define TX_PHASE_RAMP_B0__CF_PHASE_RAMP_INIT_0__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 7) & 0x0001ff80U)
#define TX_PHASE_RAMP_B0__CF_PHASE_RAMP_INIT_0__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0001ff80U) | (((u_int32_t)(src) <<\
                    7) & 0x0001ff80U)
#define TX_PHASE_RAMP_B0__CF_PHASE_RAMP_INIT_0__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 7) & ~0x0001ff80U)))

/* macros for field cf_phase_ramp_alpha_0 */
#define TX_PHASE_RAMP_B0__CF_PHASE_RAMP_ALPHA_0__SHIFT                       17
#define TX_PHASE_RAMP_B0__CF_PHASE_RAMP_ALPHA_0__WIDTH                        8
#define TX_PHASE_RAMP_B0__CF_PHASE_RAMP_ALPHA_0__MASK               0x01fe0000U
#define TX_PHASE_RAMP_B0__CF_PHASE_RAMP_ALPHA_0__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x01fe0000U) >> 17)
#define TX_PHASE_RAMP_B0__CF_PHASE_RAMP_ALPHA_0__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 17) & 0x01fe0000U)
#define TX_PHASE_RAMP_B0__CF_PHASE_RAMP_ALPHA_0__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x01fe0000U) | (((u_int32_t)(src) <<\
                    17) & 0x01fe0000U)
#define TX_PHASE_RAMP_B0__CF_PHASE_RAMP_ALPHA_0__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 17) & ~0x01fe0000U)))
#define TX_PHASE_RAMP_B0__TYPE                                        u_int32_t
#define TX_PHASE_RAMP_B0__READ                                      0x01ffffffU
#define TX_PHASE_RAMP_B0__WRITE                                     0x01ffffffU

#endif /* __TX_PHASE_RAMP_B0_MACRO__ */


/* macros for bb_reg_map.bb_chn_reg_map.BB_tx_phase_ramp_b0 */
#define INST_BB_REG_MAP__BB_CHN_REG_MAP__BB_TX_PHASE_RAMP_B0__NUM             1

/* macros for BlueprintGlobalNameSpace::adc_gain_corr_b0 */
#ifndef __ADC_GAIN_CORR_B0_MACRO__
#define __ADC_GAIN_CORR_B0_MACRO__

/* macros for field adc_gain_corr_q_coeff_0 */
#define ADC_GAIN_CORR_B0__ADC_GAIN_CORR_Q_COEFF_0__SHIFT                      0
#define ADC_GAIN_CORR_B0__ADC_GAIN_CORR_Q_COEFF_0__WIDTH                      9
#define ADC_GAIN_CORR_B0__ADC_GAIN_CORR_Q_COEFF_0__MASK             0x000001ffU
#define ADC_GAIN_CORR_B0__ADC_GAIN_CORR_Q_COEFF_0__READ(src) \
                    (u_int32_t)(src)\
                    & 0x000001ffU
#define ADC_GAIN_CORR_B0__ADC_GAIN_CORR_Q_COEFF_0__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x000001ffU)
#define ADC_GAIN_CORR_B0__ADC_GAIN_CORR_Q_COEFF_0__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000001ffU) | ((u_int32_t)(src) &\
                    0x000001ffU)
#define ADC_GAIN_CORR_B0__ADC_GAIN_CORR_Q_COEFF_0__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x000001ffU)))

/* macros for field adc_gain_corr_i_coeff_0 */
#define ADC_GAIN_CORR_B0__ADC_GAIN_CORR_I_COEFF_0__SHIFT                      9
#define ADC_GAIN_CORR_B0__ADC_GAIN_CORR_I_COEFF_0__WIDTH                      9
#define ADC_GAIN_CORR_B0__ADC_GAIN_CORR_I_COEFF_0__MASK             0x0003fe00U
#define ADC_GAIN_CORR_B0__ADC_GAIN_CORR_I_COEFF_0__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0003fe00U) >> 9)
#define ADC_GAIN_CORR_B0__ADC_GAIN_CORR_I_COEFF_0__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 9) & 0x0003fe00U)
#define ADC_GAIN_CORR_B0__ADC_GAIN_CORR_I_COEFF_0__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0003fe00U) | (((u_int32_t)(src) <<\
                    9) & 0x0003fe00U)
#define ADC_GAIN_CORR_B0__ADC_GAIN_CORR_I_COEFF_0__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 9) & ~0x0003fe00U)))

/* macros for field adc_gain_corr_enable */
#define ADC_GAIN_CORR_B0__ADC_GAIN_CORR_ENABLE__SHIFT                        18
#define ADC_GAIN_CORR_B0__ADC_GAIN_CORR_ENABLE__WIDTH                         1
#define ADC_GAIN_CORR_B0__ADC_GAIN_CORR_ENABLE__MASK                0x00040000U
#define ADC_GAIN_CORR_B0__ADC_GAIN_CORR_ENABLE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00040000U) >> 18)
#define ADC_GAIN_CORR_B0__ADC_GAIN_CORR_ENABLE__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 18) & 0x00040000U)
#define ADC_GAIN_CORR_B0__ADC_GAIN_CORR_ENABLE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00040000U) | (((u_int32_t)(src) <<\
                    18) & 0x00040000U)
#define ADC_GAIN_CORR_B0__ADC_GAIN_CORR_ENABLE__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 18) & ~0x00040000U)))
#define ADC_GAIN_CORR_B0__ADC_GAIN_CORR_ENABLE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00040000U) | ((u_int32_t)(1) << 18)
#define ADC_GAIN_CORR_B0__ADC_GAIN_CORR_ENABLE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00040000U) | ((u_int32_t)(0) << 18)

/* macros for field enable_bw_mode_sel_for_tiadc_corr */
#define ADC_GAIN_CORR_B0__ENABLE_BW_MODE_SEL_FOR_TIADC_CORR__SHIFT           19
#define ADC_GAIN_CORR_B0__ENABLE_BW_MODE_SEL_FOR_TIADC_CORR__WIDTH            1
#define ADC_GAIN_CORR_B0__ENABLE_BW_MODE_SEL_FOR_TIADC_CORR__MASK   0x00080000U
#define ADC_GAIN_CORR_B0__ENABLE_BW_MODE_SEL_FOR_TIADC_CORR__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00080000U) >> 19)
#define ADC_GAIN_CORR_B0__ENABLE_BW_MODE_SEL_FOR_TIADC_CORR__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 19) & 0x00080000U)
#define ADC_GAIN_CORR_B0__ENABLE_BW_MODE_SEL_FOR_TIADC_CORR__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00080000U) | (((u_int32_t)(src) <<\
                    19) & 0x00080000U)
#define ADC_GAIN_CORR_B0__ENABLE_BW_MODE_SEL_FOR_TIADC_CORR__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 19) & ~0x00080000U)))
#define ADC_GAIN_CORR_B0__ENABLE_BW_MODE_SEL_FOR_TIADC_CORR__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00080000U) | ((u_int32_t)(1) << 19)
#define ADC_GAIN_CORR_B0__ENABLE_BW_MODE_SEL_FOR_TIADC_CORR__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00080000U) | ((u_int32_t)(0) << 19)

/* macros for field adc_fixed_gain */
#define ADC_GAIN_CORR_B0__ADC_FIXED_GAIN__SHIFT                              20
#define ADC_GAIN_CORR_B0__ADC_FIXED_GAIN__WIDTH                               9
#define ADC_GAIN_CORR_B0__ADC_FIXED_GAIN__MASK                      0x1ff00000U
#define ADC_GAIN_CORR_B0__ADC_FIXED_GAIN__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x1ff00000U) >> 20)
#define ADC_GAIN_CORR_B0__ADC_FIXED_GAIN__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 20) & 0x1ff00000U)
#define ADC_GAIN_CORR_B0__ADC_FIXED_GAIN__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x1ff00000U) | (((u_int32_t)(src) <<\
                    20) & 0x1ff00000U)
#define ADC_GAIN_CORR_B0__ADC_FIXED_GAIN__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 20) & ~0x1ff00000U)))
#define ADC_GAIN_CORR_B0__TYPE                                        u_int32_t
#define ADC_GAIN_CORR_B0__READ                                      0x1fffffffU
#define ADC_GAIN_CORR_B0__WRITE                                     0x1fffffffU

#endif /* __ADC_GAIN_CORR_B0_MACRO__ */


/* macros for bb_reg_map.bb_chn_reg_map.BB_adc_gain_corr_b0 */
#define INST_BB_REG_MAP__BB_CHN_REG_MAP__BB_ADC_GAIN_CORR_B0__NUM             1

/* macros for BlueprintGlobalNameSpace::adc_dc_corr_b0 */
#ifndef __ADC_DC_CORR_B0_MACRO__
#define __ADC_DC_CORR_B0_MACRO__

/* macros for field adc_dc_corr_q_coeff_0 */
#define ADC_DC_CORR_B0__ADC_DC_CORR_Q_COEFF_0__SHIFT                          0
#define ADC_DC_CORR_B0__ADC_DC_CORR_Q_COEFF_0__WIDTH                          9
#define ADC_DC_CORR_B0__ADC_DC_CORR_Q_COEFF_0__MASK                 0x000001ffU
#define ADC_DC_CORR_B0__ADC_DC_CORR_Q_COEFF_0__READ(src) \
                    (u_int32_t)(src)\
                    & 0x000001ffU
#define ADC_DC_CORR_B0__ADC_DC_CORR_Q_COEFF_0__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x000001ffU)
#define ADC_DC_CORR_B0__ADC_DC_CORR_Q_COEFF_0__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000001ffU) | ((u_int32_t)(src) &\
                    0x000001ffU)
#define ADC_DC_CORR_B0__ADC_DC_CORR_Q_COEFF_0__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x000001ffU)))

/* macros for field adc_dc_corr_i_coeff_0 */
#define ADC_DC_CORR_B0__ADC_DC_CORR_I_COEFF_0__SHIFT                          9
#define ADC_DC_CORR_B0__ADC_DC_CORR_I_COEFF_0__WIDTH                          9
#define ADC_DC_CORR_B0__ADC_DC_CORR_I_COEFF_0__MASK                 0x0003fe00U
#define ADC_DC_CORR_B0__ADC_DC_CORR_I_COEFF_0__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0003fe00U) >> 9)
#define ADC_DC_CORR_B0__ADC_DC_CORR_I_COEFF_0__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 9) & 0x0003fe00U)
#define ADC_DC_CORR_B0__ADC_DC_CORR_I_COEFF_0__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0003fe00U) | (((u_int32_t)(src) <<\
                    9) & 0x0003fe00U)
#define ADC_DC_CORR_B0__ADC_DC_CORR_I_COEFF_0__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 9) & ~0x0003fe00U)))

/* macros for field adc_dc_corr_enable */
#define ADC_DC_CORR_B0__ADC_DC_CORR_ENABLE__SHIFT                            18
#define ADC_DC_CORR_B0__ADC_DC_CORR_ENABLE__WIDTH                             1
#define ADC_DC_CORR_B0__ADC_DC_CORR_ENABLE__MASK                    0x00040000U
#define ADC_DC_CORR_B0__ADC_DC_CORR_ENABLE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00040000U) >> 18)
#define ADC_DC_CORR_B0__ADC_DC_CORR_ENABLE__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 18) & 0x00040000U)
#define ADC_DC_CORR_B0__ADC_DC_CORR_ENABLE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00040000U) | (((u_int32_t)(src) <<\
                    18) & 0x00040000U)
#define ADC_DC_CORR_B0__ADC_DC_CORR_ENABLE__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 18) & ~0x00040000U)))
#define ADC_DC_CORR_B0__ADC_DC_CORR_ENABLE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00040000U) | ((u_int32_t)(1) << 18)
#define ADC_DC_CORR_B0__ADC_DC_CORR_ENABLE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00040000U) | ((u_int32_t)(0) << 18)
#define ADC_DC_CORR_B0__TYPE                                          u_int32_t
#define ADC_DC_CORR_B0__READ                                        0x0007ffffU
#define ADC_DC_CORR_B0__WRITE                                       0x0007ffffU

#endif /* __ADC_DC_CORR_B0_MACRO__ */


/* macros for bb_reg_map.bb_chn_reg_map.BB_adc_dc_corr_b0 */
#define INST_BB_REG_MAP__BB_CHN_REG_MAP__BB_ADC_DC_CORR_B0__NUM               1

/* macros for BlueprintGlobalNameSpace::rx_iq_corr_b0 */
#ifndef __RX_IQ_CORR_B0_MACRO__
#define __RX_IQ_CORR_B0_MACRO__

/* macros for field rx_iqcorr_enable */
#define RX_IQ_CORR_B0__RX_IQCORR_ENABLE__SHIFT                                0
#define RX_IQ_CORR_B0__RX_IQCORR_ENABLE__WIDTH                                1
#define RX_IQ_CORR_B0__RX_IQCORR_ENABLE__MASK                       0x00000001U
#define RX_IQ_CORR_B0__RX_IQCORR_ENABLE__READ(src) \
                    (u_int32_t)(src)\
                    & 0x00000001U
#define RX_IQ_CORR_B0__RX_IQCORR_ENABLE__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x00000001U)
#define RX_IQ_CORR_B0__RX_IQCORR_ENABLE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | ((u_int32_t)(src) &\
                    0x00000001U)
#define RX_IQ_CORR_B0__RX_IQCORR_ENABLE__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00000001U)))
#define RX_IQ_CORR_B0__RX_IQCORR_ENABLE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(1)
#define RX_IQ_CORR_B0__RX_IQCORR_ENABLE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(0)

/* macros for field rx_iqcorr_bypass_in_agc */
#define RX_IQ_CORR_B0__RX_IQCORR_BYPASS_IN_AGC__SHIFT                         1
#define RX_IQ_CORR_B0__RX_IQCORR_BYPASS_IN_AGC__WIDTH                         1
#define RX_IQ_CORR_B0__RX_IQCORR_BYPASS_IN_AGC__MASK                0x00000002U
#define RX_IQ_CORR_B0__RX_IQCORR_BYPASS_IN_AGC__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000002U) >> 1)
#define RX_IQ_CORR_B0__RX_IQCORR_BYPASS_IN_AGC__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 1) & 0x00000002U)
#define RX_IQ_CORR_B0__RX_IQCORR_BYPASS_IN_AGC__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | (((u_int32_t)(src) <<\
                    1) & 0x00000002U)
#define RX_IQ_CORR_B0__RX_IQCORR_BYPASS_IN_AGC__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 1) & ~0x00000002U)))
#define RX_IQ_CORR_B0__RX_IQCORR_BYPASS_IN_AGC__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | ((u_int32_t)(1) << 1)
#define RX_IQ_CORR_B0__RX_IQCORR_BYPASS_IN_AGC__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | ((u_int32_t)(0) << 1)

/* macros for field rx_iqc_use_onetap */
#define RX_IQ_CORR_B0__RX_IQC_USE_ONETAP__SHIFT                               2
#define RX_IQ_CORR_B0__RX_IQC_USE_ONETAP__WIDTH                               1
#define RX_IQ_CORR_B0__RX_IQC_USE_ONETAP__MASK                      0x00000004U
#define RX_IQ_CORR_B0__RX_IQC_USE_ONETAP__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000004U) >> 2)
#define RX_IQ_CORR_B0__RX_IQC_USE_ONETAP__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 2) & 0x00000004U)
#define RX_IQ_CORR_B0__RX_IQC_USE_ONETAP__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000004U) | (((u_int32_t)(src) <<\
                    2) & 0x00000004U)
#define RX_IQ_CORR_B0__RX_IQC_USE_ONETAP__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 2) & ~0x00000004U)))
#define RX_IQ_CORR_B0__RX_IQC_USE_ONETAP__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000004U) | ((u_int32_t)(1) << 2)
#define RX_IQ_CORR_B0__RX_IQC_USE_ONETAP__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000004U) | ((u_int32_t)(0) << 2)

/* macros for field rx_iqcorr_bypass_lb */
#define RX_IQ_CORR_B0__RX_IQCORR_BYPASS_LB__SHIFT                             3
#define RX_IQ_CORR_B0__RX_IQCORR_BYPASS_LB__WIDTH                             1
#define RX_IQ_CORR_B0__RX_IQCORR_BYPASS_LB__MASK                    0x00000008U
#define RX_IQ_CORR_B0__RX_IQCORR_BYPASS_LB__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000008U) >> 3)
#define RX_IQ_CORR_B0__RX_IQCORR_BYPASS_LB__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 3) & 0x00000008U)
#define RX_IQ_CORR_B0__RX_IQCORR_BYPASS_LB__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000008U) | (((u_int32_t)(src) <<\
                    3) & 0x00000008U)
#define RX_IQ_CORR_B0__RX_IQCORR_BYPASS_LB__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 3) & ~0x00000008U)))
#define RX_IQ_CORR_B0__RX_IQCORR_BYPASS_LB__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000008U) | ((u_int32_t)(1) << 3)
#define RX_IQ_CORR_B0__RX_IQCORR_BYPASS_LB__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000008U) | ((u_int32_t)(0) << 3)
#define RX_IQ_CORR_B0__TYPE                                           u_int32_t
#define RX_IQ_CORR_B0__READ                                         0x0000000fU
#define RX_IQ_CORR_B0__WRITE                                        0x0000000fU

#endif /* __RX_IQ_CORR_B0_MACRO__ */


/* macros for bb_reg_map.bb_chn_reg_map.BB_rx_iq_corr_b0 */
#define INST_BB_REG_MAP__BB_CHN_REG_MAP__BB_RX_IQ_CORR_B0__NUM                1

/* macros for BlueprintGlobalNameSpace::rx_iq_corr_loopback_b0 */
#ifndef __RX_IQ_CORR_LOOPBACK_B0_MACRO__
#define __RX_IQ_CORR_LOOPBACK_B0_MACRO__

/* macros for field loopback_iqcorr_q_q_coff_0 */
#define RX_IQ_CORR_LOOPBACK_B0__LOOPBACK_IQCORR_Q_Q_COFF_0__SHIFT             0
#define RX_IQ_CORR_LOOPBACK_B0__LOOPBACK_IQCORR_Q_Q_COFF_0__WIDTH             9
#define RX_IQ_CORR_LOOPBACK_B0__LOOPBACK_IQCORR_Q_Q_COFF_0__MASK    0x000001ffU
#define RX_IQ_CORR_LOOPBACK_B0__LOOPBACK_IQCORR_Q_Q_COFF_0__READ(src) \
                    (u_int32_t)(src)\
                    & 0x000001ffU
#define RX_IQ_CORR_LOOPBACK_B0__LOOPBACK_IQCORR_Q_Q_COFF_0__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x000001ffU)
#define RX_IQ_CORR_LOOPBACK_B0__LOOPBACK_IQCORR_Q_Q_COFF_0__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000001ffU) | ((u_int32_t)(src) &\
                    0x000001ffU)
#define RX_IQ_CORR_LOOPBACK_B0__LOOPBACK_IQCORR_Q_Q_COFF_0__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x000001ffU)))

/* macros for field loopback_iqcorr_q_i_coff_0 */
#define RX_IQ_CORR_LOOPBACK_B0__LOOPBACK_IQCORR_Q_I_COFF_0__SHIFT             9
#define RX_IQ_CORR_LOOPBACK_B0__LOOPBACK_IQCORR_Q_I_COFF_0__WIDTH             9
#define RX_IQ_CORR_LOOPBACK_B0__LOOPBACK_IQCORR_Q_I_COFF_0__MASK    0x0003fe00U
#define RX_IQ_CORR_LOOPBACK_B0__LOOPBACK_IQCORR_Q_I_COFF_0__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0003fe00U) >> 9)
#define RX_IQ_CORR_LOOPBACK_B0__LOOPBACK_IQCORR_Q_I_COFF_0__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 9) & 0x0003fe00U)
#define RX_IQ_CORR_LOOPBACK_B0__LOOPBACK_IQCORR_Q_I_COFF_0__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0003fe00U) | (((u_int32_t)(src) <<\
                    9) & 0x0003fe00U)
#define RX_IQ_CORR_LOOPBACK_B0__LOOPBACK_IQCORR_Q_I_COFF_0__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 9) & ~0x0003fe00U)))

/* macros for field loopback_iqcorr_enable */
#define RX_IQ_CORR_LOOPBACK_B0__LOOPBACK_IQCORR_ENABLE__SHIFT                18
#define RX_IQ_CORR_LOOPBACK_B0__LOOPBACK_IQCORR_ENABLE__WIDTH                 1
#define RX_IQ_CORR_LOOPBACK_B0__LOOPBACK_IQCORR_ENABLE__MASK        0x00040000U
#define RX_IQ_CORR_LOOPBACK_B0__LOOPBACK_IQCORR_ENABLE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00040000U) >> 18)
#define RX_IQ_CORR_LOOPBACK_B0__LOOPBACK_IQCORR_ENABLE__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 18) & 0x00040000U)
#define RX_IQ_CORR_LOOPBACK_B0__LOOPBACK_IQCORR_ENABLE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00040000U) | (((u_int32_t)(src) <<\
                    18) & 0x00040000U)
#define RX_IQ_CORR_LOOPBACK_B0__LOOPBACK_IQCORR_ENABLE__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 18) & ~0x00040000U)))
#define RX_IQ_CORR_LOOPBACK_B0__LOOPBACK_IQCORR_ENABLE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00040000U) | ((u_int32_t)(1) << 18)
#define RX_IQ_CORR_LOOPBACK_B0__LOOPBACK_IQCORR_ENABLE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00040000U) | ((u_int32_t)(0) << 18)
#define RX_IQ_CORR_LOOPBACK_B0__TYPE                                  u_int32_t
#define RX_IQ_CORR_LOOPBACK_B0__READ                                0x0007ffffU
#define RX_IQ_CORR_LOOPBACK_B0__WRITE                               0x0007ffffU

#endif /* __RX_IQ_CORR_LOOPBACK_B0_MACRO__ */


/* macros for bb_reg_map.bb_chn_reg_map.BB_rx_iq_corr_loopback_b0 */
#define INST_BB_REG_MAP__BB_CHN_REG_MAP__BB_RX_IQ_CORR_LOOPBACK_B0__NUM       1

/* macros for BlueprintGlobalNameSpace::paprd_am2am_mask */
#ifndef __PAPRD_AM2AM_MASK_MACRO__
#define __PAPRD_AM2AM_MASK_MACRO__

/* macros for field paprd_am2am_mask */
#define PAPRD_AM2AM_MASK__PAPRD_AM2AM_MASK__SHIFT                             0
#define PAPRD_AM2AM_MASK__PAPRD_AM2AM_MASK__WIDTH                            31
#define PAPRD_AM2AM_MASK__PAPRD_AM2AM_MASK__MASK                    0x7fffffffU
#define PAPRD_AM2AM_MASK__PAPRD_AM2AM_MASK__READ(src) \
                    (u_int32_t)(src)\
                    & 0x7fffffffU
#define PAPRD_AM2AM_MASK__PAPRD_AM2AM_MASK__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x7fffffffU)
#define PAPRD_AM2AM_MASK__PAPRD_AM2AM_MASK__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x7fffffffU) | ((u_int32_t)(src) &\
                    0x7fffffffU)
#define PAPRD_AM2AM_MASK__PAPRD_AM2AM_MASK__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x7fffffffU)))
#define PAPRD_AM2AM_MASK__TYPE                                        u_int32_t
#define PAPRD_AM2AM_MASK__READ                                      0x7fffffffU
#define PAPRD_AM2AM_MASK__WRITE                                     0x7fffffffU

#endif /* __PAPRD_AM2AM_MASK_MACRO__ */


/* macros for bb_reg_map.bb_chn_reg_map.BB_paprd_am2am_mask */
#define INST_BB_REG_MAP__BB_CHN_REG_MAP__BB_PAPRD_AM2AM_MASK__NUM             1

/* macros for BlueprintGlobalNameSpace::paprd_am2pm_mask */
#ifndef __PAPRD_AM2PM_MASK_MACRO__
#define __PAPRD_AM2PM_MASK_MACRO__

/* macros for field paprd_am2pm_mask */
#define PAPRD_AM2PM_MASK__PAPRD_AM2PM_MASK__SHIFT                             0
#define PAPRD_AM2PM_MASK__PAPRD_AM2PM_MASK__WIDTH                            31
#define PAPRD_AM2PM_MASK__PAPRD_AM2PM_MASK__MASK                    0x7fffffffU
#define PAPRD_AM2PM_MASK__PAPRD_AM2PM_MASK__READ(src) \
                    (u_int32_t)(src)\
                    & 0x7fffffffU
#define PAPRD_AM2PM_MASK__PAPRD_AM2PM_MASK__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x7fffffffU)
#define PAPRD_AM2PM_MASK__PAPRD_AM2PM_MASK__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x7fffffffU) | ((u_int32_t)(src) &\
                    0x7fffffffU)
#define PAPRD_AM2PM_MASK__PAPRD_AM2PM_MASK__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x7fffffffU)))
#define PAPRD_AM2PM_MASK__TYPE                                        u_int32_t
#define PAPRD_AM2PM_MASK__READ                                      0x7fffffffU
#define PAPRD_AM2PM_MASK__WRITE                                     0x7fffffffU

#endif /* __PAPRD_AM2PM_MASK_MACRO__ */


/* macros for bb_reg_map.bb_chn_reg_map.BB_paprd_am2pm_mask */
#define INST_BB_REG_MAP__BB_CHN_REG_MAP__BB_PAPRD_AM2PM_MASK__NUM             1

/* macros for BlueprintGlobalNameSpace::paprd_ht40_mask */
#ifndef __PAPRD_HT40_MASK_MACRO__
#define __PAPRD_HT40_MASK_MACRO__

/* macros for field paprd_ht40_mask */
#define PAPRD_HT40_MASK__PAPRD_HT40_MASK__SHIFT                               0
#define PAPRD_HT40_MASK__PAPRD_HT40_MASK__WIDTH                              31
#define PAPRD_HT40_MASK__PAPRD_HT40_MASK__MASK                      0x7fffffffU
#define PAPRD_HT40_MASK__PAPRD_HT40_MASK__READ(src) \
                    (u_int32_t)(src)\
                    & 0x7fffffffU
#define PAPRD_HT40_MASK__PAPRD_HT40_MASK__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x7fffffffU)
#define PAPRD_HT40_MASK__PAPRD_HT40_MASK__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x7fffffffU) | ((u_int32_t)(src) &\
                    0x7fffffffU)
#define PAPRD_HT40_MASK__PAPRD_HT40_MASK__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x7fffffffU)))
#define PAPRD_HT40_MASK__TYPE                                         u_int32_t
#define PAPRD_HT40_MASK__READ                                       0x7fffffffU
#define PAPRD_HT40_MASK__WRITE                                      0x7fffffffU

#endif /* __PAPRD_HT40_MASK_MACRO__ */


/* macros for bb_reg_map.bb_chn_reg_map.BB_paprd_ht40_mask */
#define INST_BB_REG_MAP__BB_CHN_REG_MAP__BB_PAPRD_HT40_MASK__NUM              1

/* macros for BlueprintGlobalNameSpace::paprd_ctrl0_b0 */
#ifndef __PAPRD_CTRL0_B0_MACRO__
#define __PAPRD_CTRL0_B0_MACRO__

/* macros for field paprd_enable_0 */
#define PAPRD_CTRL0_B0__PAPRD_ENABLE_0__SHIFT                                 0
#define PAPRD_CTRL0_B0__PAPRD_ENABLE_0__WIDTH                                 1
#define PAPRD_CTRL0_B0__PAPRD_ENABLE_0__MASK                        0x00000001U
#define PAPRD_CTRL0_B0__PAPRD_ENABLE_0__READ(src) \
                    (u_int32_t)(src)\
                    & 0x00000001U
#define PAPRD_CTRL0_B0__PAPRD_ENABLE_0__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x00000001U)
#define PAPRD_CTRL0_B0__PAPRD_ENABLE_0__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | ((u_int32_t)(src) &\
                    0x00000001U)
#define PAPRD_CTRL0_B0__PAPRD_ENABLE_0__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00000001U)))
#define PAPRD_CTRL0_B0__PAPRD_ENABLE_0__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(1)
#define PAPRD_CTRL0_B0__PAPRD_ENABLE_0__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(0)

/* macros for field paprd_reg_chain_indexed */
#define PAPRD_CTRL0_B0__PAPRD_REG_CHAIN_INDEXED__SHIFT                        1
#define PAPRD_CTRL0_B0__PAPRD_REG_CHAIN_INDEXED__WIDTH                        1
#define PAPRD_CTRL0_B0__PAPRD_REG_CHAIN_INDEXED__MASK               0x00000002U
#define PAPRD_CTRL0_B0__PAPRD_REG_CHAIN_INDEXED__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000002U) >> 1)
#define PAPRD_CTRL0_B0__PAPRD_REG_CHAIN_INDEXED__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 1) & 0x00000002U)
#define PAPRD_CTRL0_B0__PAPRD_REG_CHAIN_INDEXED__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | (((u_int32_t)(src) <<\
                    1) & 0x00000002U)
#define PAPRD_CTRL0_B0__PAPRD_REG_CHAIN_INDEXED__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 1) & ~0x00000002U)))
#define PAPRD_CTRL0_B0__PAPRD_REG_CHAIN_INDEXED__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | ((u_int32_t)(1) << 1)
#define PAPRD_CTRL0_B0__PAPRD_REG_CHAIN_INDEXED__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | ((u_int32_t)(0) << 1)

/* macros for field paprd_valid_gain_5_0_0 */
#define PAPRD_CTRL0_B0__PAPRD_VALID_GAIN_5_0_0__SHIFT                         2
#define PAPRD_CTRL0_B0__PAPRD_VALID_GAIN_5_0_0__WIDTH                        30
#define PAPRD_CTRL0_B0__PAPRD_VALID_GAIN_5_0_0__MASK                0xfffffffcU
#define PAPRD_CTRL0_B0__PAPRD_VALID_GAIN_5_0_0__READ(src) \
                    (((u_int32_t)(src)\
                    & 0xfffffffcU) >> 2)
#define PAPRD_CTRL0_B0__PAPRD_VALID_GAIN_5_0_0__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 2) & 0xfffffffcU)
#define PAPRD_CTRL0_B0__PAPRD_VALID_GAIN_5_0_0__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xfffffffcU) | (((u_int32_t)(src) <<\
                    2) & 0xfffffffcU)
#define PAPRD_CTRL0_B0__PAPRD_VALID_GAIN_5_0_0__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 2) & ~0xfffffffcU)))
#define PAPRD_CTRL0_B0__TYPE                                          u_int32_t
#define PAPRD_CTRL0_B0__READ                                        0xffffffffU
#define PAPRD_CTRL0_B0__WRITE                                       0xffffffffU

#endif /* __PAPRD_CTRL0_B0_MACRO__ */


/* macros for bb_reg_map.bb_chn_reg_map.BB_paprd_ctrl0_b0 */
#define INST_BB_REG_MAP__BB_CHN_REG_MAP__BB_PAPRD_CTRL0_B0__NUM               1

/* macros for BlueprintGlobalNameSpace::paprd_ctrl1_b0 */
#ifndef __PAPRD_CTRL1_B0_MACRO__
#define __PAPRD_CTRL1_B0_MACRO__

/* macros for field paprd_adaptive_am2am_enable_0 */
#define PAPRD_CTRL1_B0__PAPRD_ADAPTIVE_AM2AM_ENABLE_0__SHIFT                  0
#define PAPRD_CTRL1_B0__PAPRD_ADAPTIVE_AM2AM_ENABLE_0__WIDTH                  1
#define PAPRD_CTRL1_B0__PAPRD_ADAPTIVE_AM2AM_ENABLE_0__MASK         0x00000001U
#define PAPRD_CTRL1_B0__PAPRD_ADAPTIVE_AM2AM_ENABLE_0__READ(src) \
                    (u_int32_t)(src)\
                    & 0x00000001U
#define PAPRD_CTRL1_B0__PAPRD_ADAPTIVE_AM2AM_ENABLE_0__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x00000001U)
#define PAPRD_CTRL1_B0__PAPRD_ADAPTIVE_AM2AM_ENABLE_0__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | ((u_int32_t)(src) &\
                    0x00000001U)
#define PAPRD_CTRL1_B0__PAPRD_ADAPTIVE_AM2AM_ENABLE_0__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00000001U)))
#define PAPRD_CTRL1_B0__PAPRD_ADAPTIVE_AM2AM_ENABLE_0__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(1)
#define PAPRD_CTRL1_B0__PAPRD_ADAPTIVE_AM2AM_ENABLE_0__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(0)

/* macros for field paprd_adaptive_am2pm_enable_0 */
#define PAPRD_CTRL1_B0__PAPRD_ADAPTIVE_AM2PM_ENABLE_0__SHIFT                  1
#define PAPRD_CTRL1_B0__PAPRD_ADAPTIVE_AM2PM_ENABLE_0__WIDTH                  1
#define PAPRD_CTRL1_B0__PAPRD_ADAPTIVE_AM2PM_ENABLE_0__MASK         0x00000002U
#define PAPRD_CTRL1_B0__PAPRD_ADAPTIVE_AM2PM_ENABLE_0__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000002U) >> 1)
#define PAPRD_CTRL1_B0__PAPRD_ADAPTIVE_AM2PM_ENABLE_0__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 1) & 0x00000002U)
#define PAPRD_CTRL1_B0__PAPRD_ADAPTIVE_AM2PM_ENABLE_0__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | (((u_int32_t)(src) <<\
                    1) & 0x00000002U)
#define PAPRD_CTRL1_B0__PAPRD_ADAPTIVE_AM2PM_ENABLE_0__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 1) & ~0x00000002U)))
#define PAPRD_CTRL1_B0__PAPRD_ADAPTIVE_AM2PM_ENABLE_0__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | ((u_int32_t)(1) << 1)
#define PAPRD_CTRL1_B0__PAPRD_ADAPTIVE_AM2PM_ENABLE_0__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | ((u_int32_t)(0) << 1)

/* macros for field paprd_target_pwr_max_0 */
#define PAPRD_CTRL1_B0__PAPRD_TARGET_PWR_MAX_0__SHIFT                         2
#define PAPRD_CTRL1_B0__PAPRD_TARGET_PWR_MAX_0__WIDTH                         6
#define PAPRD_CTRL1_B0__PAPRD_TARGET_PWR_MAX_0__MASK                0x000000fcU
#define PAPRD_CTRL1_B0__PAPRD_TARGET_PWR_MAX_0__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x000000fcU) >> 2)
#define PAPRD_CTRL1_B0__PAPRD_TARGET_PWR_MAX_0__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 2) & 0x000000fcU)
#define PAPRD_CTRL1_B0__PAPRD_TARGET_PWR_MAX_0__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000000fcU) | (((u_int32_t)(src) <<\
                    2) & 0x000000fcU)
#define PAPRD_CTRL1_B0__PAPRD_TARGET_PWR_MAX_0__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 2) & ~0x000000fcU)))

/* macros for field paprd_target_pwr_min_0 */
#define PAPRD_CTRL1_B0__PAPRD_TARGET_PWR_MIN_0__SHIFT                         8
#define PAPRD_CTRL1_B0__PAPRD_TARGET_PWR_MIN_0__WIDTH                         6
#define PAPRD_CTRL1_B0__PAPRD_TARGET_PWR_MIN_0__MASK                0x00003f00U
#define PAPRD_CTRL1_B0__PAPRD_TARGET_PWR_MIN_0__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00003f00U) >> 8)
#define PAPRD_CTRL1_B0__PAPRD_TARGET_PWR_MIN_0__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 8) & 0x00003f00U)
#define PAPRD_CTRL1_B0__PAPRD_TARGET_PWR_MIN_0__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00003f00U) | (((u_int32_t)(src) <<\
                    8) & 0x00003f00U)
#define PAPRD_CTRL1_B0__PAPRD_TARGET_PWR_MIN_0__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 8) & ~0x00003f00U)))

/* macros for field paprd_trainer_iandq_sel_0 */
#define PAPRD_CTRL1_B0__PAPRD_TRAINER_IANDQ_SEL_0__SHIFT                     29
#define PAPRD_CTRL1_B0__PAPRD_TRAINER_IANDQ_SEL_0__WIDTH                      1
#define PAPRD_CTRL1_B0__PAPRD_TRAINER_IANDQ_SEL_0__MASK             0x20000000U
#define PAPRD_CTRL1_B0__PAPRD_TRAINER_IANDQ_SEL_0__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x20000000U) >> 29)
#define PAPRD_CTRL1_B0__PAPRD_TRAINER_IANDQ_SEL_0__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 29) & 0x20000000U)
#define PAPRD_CTRL1_B0__PAPRD_TRAINER_IANDQ_SEL_0__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x20000000U) | (((u_int32_t)(src) <<\
                    29) & 0x20000000U)
#define PAPRD_CTRL1_B0__PAPRD_TRAINER_IANDQ_SEL_0__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 29) & ~0x20000000U)))
#define PAPRD_CTRL1_B0__PAPRD_TRAINER_IANDQ_SEL_0__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x20000000U) | ((u_int32_t)(1) << 29)
#define PAPRD_CTRL1_B0__PAPRD_TRAINER_IANDQ_SEL_0__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x20000000U) | ((u_int32_t)(0) << 29)
#define PAPRD_CTRL1_B0__TYPE                                          u_int32_t
#define PAPRD_CTRL1_B0__READ                                        0x20003fffU
#define PAPRD_CTRL1_B0__WRITE                                       0x20003fffU

#endif /* __PAPRD_CTRL1_B0_MACRO__ */


/* macros for bb_reg_map.bb_chn_reg_map.BB_paprd_ctrl1_b0 */
#define INST_BB_REG_MAP__BB_CHN_REG_MAP__BB_PAPRD_CTRL1_B0__NUM               1

/* macros for BlueprintGlobalNameSpace::paprd_ctrl2_b0 */
#ifndef __PAPRD_CTRL2_B0_MACRO__
#define __PAPRD_CTRL2_B0_MACRO__

/* macros for field paprd_valid_pa_setting_0 */
#define PAPRD_CTRL2_B0__PAPRD_VALID_PA_SETTING_0__SHIFT                       0
#define PAPRD_CTRL2_B0__PAPRD_VALID_PA_SETTING_0__WIDTH                      18
#define PAPRD_CTRL2_B0__PAPRD_VALID_PA_SETTING_0__MASK              0x0003ffffU
#define PAPRD_CTRL2_B0__PAPRD_VALID_PA_SETTING_0__READ(src) \
                    (u_int32_t)(src)\
                    & 0x0003ffffU
#define PAPRD_CTRL2_B0__PAPRD_VALID_PA_SETTING_0__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x0003ffffU)
#define PAPRD_CTRL2_B0__PAPRD_VALID_PA_SETTING_0__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0003ffffU) | ((u_int32_t)(src) &\
                    0x0003ffffU)
#define PAPRD_CTRL2_B0__PAPRD_VALID_PA_SETTING_0__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x0003ffffU)))

/* macros for field paprd_adaptive_table_valid_0 */
#define PAPRD_CTRL2_B0__PAPRD_ADAPTIVE_TABLE_VALID_0__SHIFT                  18
#define PAPRD_CTRL2_B0__PAPRD_ADAPTIVE_TABLE_VALID_0__WIDTH                   6
#define PAPRD_CTRL2_B0__PAPRD_ADAPTIVE_TABLE_VALID_0__MASK          0x00fc0000U
#define PAPRD_CTRL2_B0__PAPRD_ADAPTIVE_TABLE_VALID_0__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00fc0000U) >> 18)
#define PAPRD_CTRL2_B0__PAPRD_ADAPTIVE_TABLE_VALID_0__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 18) & 0x00fc0000U)
#define PAPRD_CTRL2_B0__PAPRD_ADAPTIVE_TABLE_VALID_0__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00fc0000U) | (((u_int32_t)(src) <<\
                    18) & 0x00fc0000U)
#define PAPRD_CTRL2_B0__PAPRD_ADAPTIVE_TABLE_VALID_0__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 18) & ~0x00fc0000U)))

/* macros for field paprd_table_rfbmode_0 */
#define PAPRD_CTRL2_B0__PAPRD_TABLE_RFBMODE_0__SHIFT                         24
#define PAPRD_CTRL2_B0__PAPRD_TABLE_RFBMODE_0__WIDTH                          3
#define PAPRD_CTRL2_B0__PAPRD_TABLE_RFBMODE_0__MASK                 0x07000000U
#define PAPRD_CTRL2_B0__PAPRD_TABLE_RFBMODE_0__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x07000000U) >> 24)
#define PAPRD_CTRL2_B0__PAPRD_TABLE_RFBMODE_0__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 24) & 0x07000000U)
#define PAPRD_CTRL2_B0__PAPRD_TABLE_RFBMODE_0__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x07000000U) | (((u_int32_t)(src) <<\
                    24) & 0x07000000U)
#define PAPRD_CTRL2_B0__PAPRD_TABLE_RFBMODE_0__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 24) & ~0x07000000U)))

/* macros for field paprd_mag_thrsh_0 */
#define PAPRD_CTRL2_B0__PAPRD_MAG_THRSH_0__SHIFT                             27
#define PAPRD_CTRL2_B0__PAPRD_MAG_THRSH_0__WIDTH                              5
#define PAPRD_CTRL2_B0__PAPRD_MAG_THRSH_0__MASK                     0xf8000000U
#define PAPRD_CTRL2_B0__PAPRD_MAG_THRSH_0__READ(src) \
                    (((u_int32_t)(src)\
                    & 0xf8000000U) >> 27)
#define PAPRD_CTRL2_B0__PAPRD_MAG_THRSH_0__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 27) & 0xf8000000U)
#define PAPRD_CTRL2_B0__PAPRD_MAG_THRSH_0__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xf8000000U) | (((u_int32_t)(src) <<\
                    27) & 0xf8000000U)
#define PAPRD_CTRL2_B0__PAPRD_MAG_THRSH_0__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 27) & ~0xf8000000U)))
#define PAPRD_CTRL2_B0__TYPE                                          u_int32_t
#define PAPRD_CTRL2_B0__READ                                        0xffffffffU
#define PAPRD_CTRL2_B0__WRITE                                       0xffffffffU

#endif /* __PAPRD_CTRL2_B0_MACRO__ */


/* macros for bb_reg_map.bb_chn_reg_map.BB_paprd_ctrl2_b0 */
#define INST_BB_REG_MAP__BB_CHN_REG_MAP__BB_PAPRD_CTRL2_B0__NUM               1

/* macros for BlueprintGlobalNameSpace::paprd_vht80_mask */
#ifndef __PAPRD_VHT80_MASK_MACRO__
#define __PAPRD_VHT80_MASK_MACRO__

/* macros for field paprd_vht80_mask */
#define PAPRD_VHT80_MASK__PAPRD_VHT80_MASK__SHIFT                             0
#define PAPRD_VHT80_MASK__PAPRD_VHT80_MASK__WIDTH                            31
#define PAPRD_VHT80_MASK__PAPRD_VHT80_MASK__MASK                    0x7fffffffU
#define PAPRD_VHT80_MASK__PAPRD_VHT80_MASK__READ(src) \
                    (u_int32_t)(src)\
                    & 0x7fffffffU
#define PAPRD_VHT80_MASK__PAPRD_VHT80_MASK__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x7fffffffU)
#define PAPRD_VHT80_MASK__PAPRD_VHT80_MASK__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x7fffffffU) | ((u_int32_t)(src) &\
                    0x7fffffffU)
#define PAPRD_VHT80_MASK__PAPRD_VHT80_MASK__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x7fffffffU)))
#define PAPRD_VHT80_MASK__TYPE                                        u_int32_t
#define PAPRD_VHT80_MASK__READ                                      0x7fffffffU
#define PAPRD_VHT80_MASK__WRITE                                     0x7fffffffU

#endif /* __PAPRD_VHT80_MASK_MACRO__ */


/* macros for bb_reg_map.bb_chn_reg_map.BB_paprd_vht80_mask */
#define INST_BB_REG_MAP__BB_CHN_REG_MAP__BB_PAPRD_VHT80_MASK__NUM             1

/* macros for BlueprintGlobalNameSpace::phydbg_mem_addr */
#ifndef __PHYDBG_MEM_ADDR_MACRO__
#define __PHYDBG_MEM_ADDR_MACRO__

/* macros for field phydbg_mem_addr */
#define PHYDBG_MEM_ADDR__PHYDBG_MEM_ADDR__SHIFT                               0
#define PHYDBG_MEM_ADDR__PHYDBG_MEM_ADDR__WIDTH                              15
#define PHYDBG_MEM_ADDR__PHYDBG_MEM_ADDR__MASK                      0x00007fffU
#define PHYDBG_MEM_ADDR__PHYDBG_MEM_ADDR__READ(src) \
                    (u_int32_t)(src)\
                    & 0x00007fffU
#define PHYDBG_MEM_ADDR__PHYDBG_MEM_ADDR__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x00007fffU)
#define PHYDBG_MEM_ADDR__PHYDBG_MEM_ADDR__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00007fffU) | ((u_int32_t)(src) &\
                    0x00007fffU)
#define PHYDBG_MEM_ADDR__PHYDBG_MEM_ADDR__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00007fffU)))
#define PHYDBG_MEM_ADDR__TYPE                                         u_int32_t
#define PHYDBG_MEM_ADDR__READ                                       0x00007fffU
#define PHYDBG_MEM_ADDR__WRITE                                      0x00007fffU

#endif /* __PHYDBG_MEM_ADDR_MACRO__ */


/* macros for bb_reg_map.bb_chn_reg_map.BB_phydbg_mem_addr */
#define INST_BB_REG_MAP__BB_CHN_REG_MAP__BB_PHYDBG_MEM_ADDR__NUM              1

/* macros for BlueprintGlobalNameSpace::phydbg_mem_data */
#ifndef __PHYDBG_MEM_DATA_MACRO__
#define __PHYDBG_MEM_DATA_MACRO__

/* macros for field phydbg_mem_data */
#define PHYDBG_MEM_DATA__PHYDBG_MEM_DATA__SHIFT                               0
#define PHYDBG_MEM_DATA__PHYDBG_MEM_DATA__WIDTH                              32
#define PHYDBG_MEM_DATA__PHYDBG_MEM_DATA__MASK                      0xffffffffU
#define PHYDBG_MEM_DATA__PHYDBG_MEM_DATA__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define PHYDBG_MEM_DATA__PHYDBG_MEM_DATA__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0xffffffffU)
#define PHYDBG_MEM_DATA__PHYDBG_MEM_DATA__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xffffffffU) | ((u_int32_t)(src) &\
                    0xffffffffU)
#define PHYDBG_MEM_DATA__PHYDBG_MEM_DATA__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0xffffffffU)))
#define PHYDBG_MEM_DATA__TYPE                                         u_int32_t
#define PHYDBG_MEM_DATA__READ                                       0xffffffffU
#define PHYDBG_MEM_DATA__WRITE                                      0xffffffffU

#endif /* __PHYDBG_MEM_DATA_MACRO__ */


/* macros for bb_reg_map.bb_chn_reg_map.BB_phydbg_mem_data */
#define INST_BB_REG_MAP__BB_CHN_REG_MAP__BB_PHYDBG_MEM_DATA__NUM              1

/* macros for BlueprintGlobalNameSpace::btcf_config */
#ifndef __BTCF_CONFIG_MACRO__
#define __BTCF_CONFIG_MACRO__

/* macros for field fft_toffset64 */
#define BTCF_CONFIG__FFT_TOFFSET64__SHIFT                                     0
#define BTCF_CONFIG__FFT_TOFFSET64__WIDTH                                     4
#define BTCF_CONFIG__FFT_TOFFSET64__MASK                            0x0000000fU
#define BTCF_CONFIG__FFT_TOFFSET64__READ(src)    (u_int32_t)(src) & 0x0000000fU
#define BTCF_CONFIG__FFT_TOFFSET64__WRITE(src) ((u_int32_t)(src) & 0x0000000fU)
#define BTCF_CONFIG__FFT_TOFFSET64__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000000fU) | ((u_int32_t)(src) &\
                    0x0000000fU)
#define BTCF_CONFIG__FFT_TOFFSET64__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x0000000fU)))

/* macros for field fft_toffset128 */
#define BTCF_CONFIG__FFT_TOFFSET128__SHIFT                                    4
#define BTCF_CONFIG__FFT_TOFFSET128__WIDTH                                    4
#define BTCF_CONFIG__FFT_TOFFSET128__MASK                           0x000000f0U
#define BTCF_CONFIG__FFT_TOFFSET128__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x000000f0U) >> 4)
#define BTCF_CONFIG__FFT_TOFFSET128__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 4) & 0x000000f0U)
#define BTCF_CONFIG__FFT_TOFFSET128__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000000f0U) | (((u_int32_t)(src) <<\
                    4) & 0x000000f0U)
#define BTCF_CONFIG__FFT_TOFFSET128__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 4) & ~0x000000f0U)))

/* macros for field fft_toffset256 */
#define BTCF_CONFIG__FFT_TOFFSET256__SHIFT                                    8
#define BTCF_CONFIG__FFT_TOFFSET256__WIDTH                                    4
#define BTCF_CONFIG__FFT_TOFFSET256__MASK                           0x00000f00U
#define BTCF_CONFIG__FFT_TOFFSET256__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000f00U) >> 8)
#define BTCF_CONFIG__FFT_TOFFSET256__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 8) & 0x00000f00U)
#define BTCF_CONFIG__FFT_TOFFSET256__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000f00U) | (((u_int32_t)(src) <<\
                    8) & 0x00000f00U)
#define BTCF_CONFIG__FFT_TOFFSET256__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 8) & ~0x00000f00U)))

/* macros for field btcf_det_ratio */
#define BTCF_CONFIG__BTCF_DET_RATIO__SHIFT                                   12
#define BTCF_CONFIG__BTCF_DET_RATIO__WIDTH                                    3
#define BTCF_CONFIG__BTCF_DET_RATIO__MASK                           0x00007000U
#define BTCF_CONFIG__BTCF_DET_RATIO__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00007000U) >> 12)
#define BTCF_CONFIG__BTCF_DET_RATIO__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 12) & 0x00007000U)
#define BTCF_CONFIG__BTCF_DET_RATIO__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00007000U) | (((u_int32_t)(src) <<\
                    12) & 0x00007000U)
#define BTCF_CONFIG__BTCF_DET_RATIO__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 12) & ~0x00007000U)))

/* macros for field btcf_det_dshift */
#define BTCF_CONFIG__BTCF_DET_DSHIFT__SHIFT                                  15
#define BTCF_CONFIG__BTCF_DET_DSHIFT__WIDTH                                   3
#define BTCF_CONFIG__BTCF_DET_DSHIFT__MASK                          0x00038000U
#define BTCF_CONFIG__BTCF_DET_DSHIFT__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00038000U) >> 15)
#define BTCF_CONFIG__BTCF_DET_DSHIFT__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 15) & 0x00038000U)
#define BTCF_CONFIG__BTCF_DET_DSHIFT__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00038000U) | (((u_int32_t)(src) <<\
                    15) & 0x00038000U)
#define BTCF_CONFIG__BTCF_DET_DSHIFT__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 15) & ~0x00038000U)))

/* macros for field btcf_lgfirpwr_ideal */
#define BTCF_CONFIG__BTCF_LGFIRPWR_IDEAL__SHIFT                              18
#define BTCF_CONFIG__BTCF_LGFIRPWR_IDEAL__WIDTH                              12
#define BTCF_CONFIG__BTCF_LGFIRPWR_IDEAL__MASK                      0x3ffc0000U
#define BTCF_CONFIG__BTCF_LGFIRPWR_IDEAL__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x3ffc0000U) >> 18)
#define BTCF_CONFIG__BTCF_LGFIRPWR_IDEAL__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 18) & 0x3ffc0000U)
#define BTCF_CONFIG__BTCF_LGFIRPWR_IDEAL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x3ffc0000U) | (((u_int32_t)(src) <<\
                    18) & 0x3ffc0000U)
#define BTCF_CONFIG__BTCF_LGFIRPWR_IDEAL__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 18) & ~0x3ffc0000U)))

/* macros for field btcf_en */
#define BTCF_CONFIG__BTCF_EN__SHIFT                                          30
#define BTCF_CONFIG__BTCF_EN__WIDTH                                           1
#define BTCF_CONFIG__BTCF_EN__MASK                                  0x40000000U
#define BTCF_CONFIG__BTCF_EN__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x40000000U) >> 30)
#define BTCF_CONFIG__BTCF_EN__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 30) & 0x40000000U)
#define BTCF_CONFIG__BTCF_EN__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x40000000U) | (((u_int32_t)(src) <<\
                    30) & 0x40000000U)
#define BTCF_CONFIG__BTCF_EN__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 30) & ~0x40000000U)))
#define BTCF_CONFIG__BTCF_EN__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x40000000U) | ((u_int32_t)(1) << 30)
#define BTCF_CONFIG__BTCF_EN__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x40000000U) | ((u_int32_t)(0) << 30)

/* macros for field btcf_finetim_corr_en */
#define BTCF_CONFIG__BTCF_FINETIM_CORR_EN__SHIFT                             31
#define BTCF_CONFIG__BTCF_FINETIM_CORR_EN__WIDTH                              1
#define BTCF_CONFIG__BTCF_FINETIM_CORR_EN__MASK                     0x80000000U
#define BTCF_CONFIG__BTCF_FINETIM_CORR_EN__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x80000000U) >> 31)
#define BTCF_CONFIG__BTCF_FINETIM_CORR_EN__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 31) & 0x80000000U)
#define BTCF_CONFIG__BTCF_FINETIM_CORR_EN__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x80000000U) | (((u_int32_t)(src) <<\
                    31) & 0x80000000U)
#define BTCF_CONFIG__BTCF_FINETIM_CORR_EN__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 31) & ~0x80000000U)))
#define BTCF_CONFIG__BTCF_FINETIM_CORR_EN__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x80000000U) | ((u_int32_t)(1) << 31)
#define BTCF_CONFIG__BTCF_FINETIM_CORR_EN__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x80000000U) | ((u_int32_t)(0) << 31)
#define BTCF_CONFIG__TYPE                                             u_int32_t
#define BTCF_CONFIG__READ                                           0xffffffffU
#define BTCF_CONFIG__WRITE                                          0xffffffffU

#endif /* __BTCF_CONFIG_MACRO__ */


/* macros for bb_reg_map.bb_chn_reg_map.BB_btcf_config */
#define INST_BB_REG_MAP__BB_CHN_REG_MAP__BB_BTCF_CONFIG__NUM                  1

/* macros for BlueprintGlobalNameSpace::btcf_th_config */
#ifndef __BTCF_TH_CONFIG_MACRO__
#define __BTCF_TH_CONFIG_MACRO__

/* macros for field btcf_th1 */
#define BTCF_TH_CONFIG__BTCF_TH1__SHIFT                                       0
#define BTCF_TH_CONFIG__BTCF_TH1__WIDTH                                       8
#define BTCF_TH_CONFIG__BTCF_TH1__MASK                              0x000000ffU
#define BTCF_TH_CONFIG__BTCF_TH1__READ(src)      (u_int32_t)(src) & 0x000000ffU
#define BTCF_TH_CONFIG__BTCF_TH1__WRITE(src)   ((u_int32_t)(src) & 0x000000ffU)
#define BTCF_TH_CONFIG__BTCF_TH1__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000000ffU) | ((u_int32_t)(src) &\
                    0x000000ffU)
#define BTCF_TH_CONFIG__BTCF_TH1__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x000000ffU)))

/* macros for field btcf_th2 */
#define BTCF_TH_CONFIG__BTCF_TH2__SHIFT                                       8
#define BTCF_TH_CONFIG__BTCF_TH2__WIDTH                                       8
#define BTCF_TH_CONFIG__BTCF_TH2__MASK                              0x0000ff00U
#define BTCF_TH_CONFIG__BTCF_TH2__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0000ff00U) >> 8)
#define BTCF_TH_CONFIG__BTCF_TH2__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 8) & 0x0000ff00U)
#define BTCF_TH_CONFIG__BTCF_TH2__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000ff00U) | (((u_int32_t)(src) <<\
                    8) & 0x0000ff00U)
#define BTCF_TH_CONFIG__BTCF_TH2__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 8) & ~0x0000ff00U)))

/* macros for field btcf_snr_th_db */
#define BTCF_TH_CONFIG__BTCF_SNR_TH_DB__SHIFT                                16
#define BTCF_TH_CONFIG__BTCF_SNR_TH_DB__WIDTH                                 8
#define BTCF_TH_CONFIG__BTCF_SNR_TH_DB__MASK                        0x00ff0000U
#define BTCF_TH_CONFIG__BTCF_SNR_TH_DB__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00ff0000U) >> 16)
#define BTCF_TH_CONFIG__BTCF_SNR_TH_DB__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 16) & 0x00ff0000U)
#define BTCF_TH_CONFIG__BTCF_SNR_TH_DB__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00ff0000U) | (((u_int32_t)(src) <<\
                    16) & 0x00ff0000U)
#define BTCF_TH_CONFIG__BTCF_SNR_TH_DB__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 16) & ~0x00ff0000U)))

/* macros for field btcf_low_snr_branch */
#define BTCF_TH_CONFIG__BTCF_LOW_SNR_BRANCH__SHIFT                           24
#define BTCF_TH_CONFIG__BTCF_LOW_SNR_BRANCH__WIDTH                            1
#define BTCF_TH_CONFIG__BTCF_LOW_SNR_BRANCH__MASK                   0x01000000U
#define BTCF_TH_CONFIG__BTCF_LOW_SNR_BRANCH__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x01000000U) >> 24)
#define BTCF_TH_CONFIG__BTCF_LOW_SNR_BRANCH__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 24) & 0x01000000U)
#define BTCF_TH_CONFIG__BTCF_LOW_SNR_BRANCH__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x01000000U) | (((u_int32_t)(src) <<\
                    24) & 0x01000000U)
#define BTCF_TH_CONFIG__BTCF_LOW_SNR_BRANCH__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 24) & ~0x01000000U)))
#define BTCF_TH_CONFIG__BTCF_LOW_SNR_BRANCH__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x01000000U) | ((u_int32_t)(1) << 24)
#define BTCF_TH_CONFIG__BTCF_LOW_SNR_BRANCH__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x01000000U) | ((u_int32_t)(0) << 24)
#define BTCF_TH_CONFIG__TYPE                                          u_int32_t
#define BTCF_TH_CONFIG__READ                                        0x01ffffffU
#define BTCF_TH_CONFIG__WRITE                                       0x01ffffffU

#endif /* __BTCF_TH_CONFIG_MACRO__ */


/* macros for bb_reg_map.bb_chn_reg_map.BB_btcf_th_config */
#define INST_BB_REG_MAP__BB_CHN_REG_MAP__BB_BTCF_TH_CONFIG__NUM               1

/* macros for BlueprintGlobalNameSpace::btcf_dcn_config */
#ifndef __BTCF_DCN_CONFIG_MACRO__
#define __BTCF_DCN_CONFIG_MACRO__

/* macros for field dcn_alpha1 */
#define BTCF_DCN_CONFIG__DCN_ALPHA1__SHIFT                                    0
#define BTCF_DCN_CONFIG__DCN_ALPHA1__WIDTH                                    9
#define BTCF_DCN_CONFIG__DCN_ALPHA1__MASK                           0x000001ffU
#define BTCF_DCN_CONFIG__DCN_ALPHA1__READ(src)   (u_int32_t)(src) & 0x000001ffU
#define BTCF_DCN_CONFIG__DCN_ALPHA1__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x000001ffU)
#define BTCF_DCN_CONFIG__DCN_ALPHA1__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000001ffU) | ((u_int32_t)(src) &\
                    0x000001ffU)
#define BTCF_DCN_CONFIG__DCN_ALPHA1__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x000001ffU)))

/* macros for field dcn_alpha2 */
#define BTCF_DCN_CONFIG__DCN_ALPHA2__SHIFT                                    9
#define BTCF_DCN_CONFIG__DCN_ALPHA2__WIDTH                                    9
#define BTCF_DCN_CONFIG__DCN_ALPHA2__MASK                           0x0003fe00U
#define BTCF_DCN_CONFIG__DCN_ALPHA2__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0003fe00U) >> 9)
#define BTCF_DCN_CONFIG__DCN_ALPHA2__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 9) & 0x0003fe00U)
#define BTCF_DCN_CONFIG__DCN_ALPHA2__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0003fe00U) | (((u_int32_t)(src) <<\
                    9) & 0x0003fe00U)
#define BTCF_DCN_CONFIG__DCN_ALPHA2__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 9) & ~0x0003fe00U)))

/* macros for field btcf_agc_dly */
#define BTCF_DCN_CONFIG__BTCF_AGC_DLY__SHIFT                                 18
#define BTCF_DCN_CONFIG__BTCF_AGC_DLY__WIDTH                                  9
#define BTCF_DCN_CONFIG__BTCF_AGC_DLY__MASK                         0x07fc0000U
#define BTCF_DCN_CONFIG__BTCF_AGC_DLY__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x07fc0000U) >> 18)
#define BTCF_DCN_CONFIG__BTCF_AGC_DLY__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 18) & 0x07fc0000U)
#define BTCF_DCN_CONFIG__BTCF_AGC_DLY__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x07fc0000U) | (((u_int32_t)(src) <<\
                    18) & 0x07fc0000U)
#define BTCF_DCN_CONFIG__BTCF_AGC_DLY__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 18) & ~0x07fc0000U)))

/* macros for field dcn_alpha_sel */
#define BTCF_DCN_CONFIG__DCN_ALPHA_SEL__SHIFT                                30
#define BTCF_DCN_CONFIG__DCN_ALPHA_SEL__WIDTH                                 1
#define BTCF_DCN_CONFIG__DCN_ALPHA_SEL__MASK                        0x40000000U
#define BTCF_DCN_CONFIG__DCN_ALPHA_SEL__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x40000000U) >> 30)
#define BTCF_DCN_CONFIG__DCN_ALPHA_SEL__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 30) & 0x40000000U)
#define BTCF_DCN_CONFIG__DCN_ALPHA_SEL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x40000000U) | (((u_int32_t)(src) <<\
                    30) & 0x40000000U)
#define BTCF_DCN_CONFIG__DCN_ALPHA_SEL__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 30) & ~0x40000000U)))
#define BTCF_DCN_CONFIG__DCN_ALPHA_SEL__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x40000000U) | ((u_int32_t)(1) << 30)
#define BTCF_DCN_CONFIG__DCN_ALPHA_SEL__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x40000000U) | ((u_int32_t)(0) << 30)

/* macros for field dcn_bypass */
#define BTCF_DCN_CONFIG__DCN_BYPASS__SHIFT                                   31
#define BTCF_DCN_CONFIG__DCN_BYPASS__WIDTH                                    1
#define BTCF_DCN_CONFIG__DCN_BYPASS__MASK                           0x80000000U
#define BTCF_DCN_CONFIG__DCN_BYPASS__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x80000000U) >> 31)
#define BTCF_DCN_CONFIG__DCN_BYPASS__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 31) & 0x80000000U)
#define BTCF_DCN_CONFIG__DCN_BYPASS__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x80000000U) | (((u_int32_t)(src) <<\
                    31) & 0x80000000U)
#define BTCF_DCN_CONFIG__DCN_BYPASS__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 31) & ~0x80000000U)))
#define BTCF_DCN_CONFIG__DCN_BYPASS__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x80000000U) | ((u_int32_t)(1) << 31)
#define BTCF_DCN_CONFIG__DCN_BYPASS__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x80000000U) | ((u_int32_t)(0) << 31)
#define BTCF_DCN_CONFIG__TYPE                                         u_int32_t
#define BTCF_DCN_CONFIG__READ                                       0xc7ffffffU
#define BTCF_DCN_CONFIG__WRITE                                      0xc7ffffffU

#endif /* __BTCF_DCN_CONFIG_MACRO__ */


/* macros for bb_reg_map.bb_chn_reg_map.BB_btcf_dcn_config */
#define INST_BB_REG_MAP__BB_CHN_REG_MAP__BB_BTCF_DCN_CONFIG__NUM              1

/* macros for BlueprintGlobalNameSpace::btcf_tim_capture */
#ifndef __BTCF_TIM_CAPTURE_MACRO__
#define __BTCF_TIM_CAPTURE_MACRO__

/* macros for field btcf_cap_coarse_sb */
#define BTCF_TIM_CAPTURE__BTCF_CAP_COARSE_SB__SHIFT                           0
#define BTCF_TIM_CAPTURE__BTCF_CAP_COARSE_SB__WIDTH                          10
#define BTCF_TIM_CAPTURE__BTCF_CAP_COARSE_SB__MASK                  0x000003ffU
#define BTCF_TIM_CAPTURE__BTCF_CAP_COARSE_SB__READ(src) \
                    (u_int32_t)(src)\
                    & 0x000003ffU

/* macros for field btcf_cap_skip */
#define BTCF_TIM_CAPTURE__BTCF_CAP_SKIP__SHIFT                               10
#define BTCF_TIM_CAPTURE__BTCF_CAP_SKIP__WIDTH                                8
#define BTCF_TIM_CAPTURE__BTCF_CAP_SKIP__MASK                       0x0003fc00U
#define BTCF_TIM_CAPTURE__BTCF_CAP_SKIP__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0003fc00U) >> 10)

/* macros for field btcf_cap_skip_btcf */
#define BTCF_TIM_CAPTURE__BTCF_CAP_SKIP_BTCF__SHIFT                          18
#define BTCF_TIM_CAPTURE__BTCF_CAP_SKIP_BTCF__WIDTH                           8
#define BTCF_TIM_CAPTURE__BTCF_CAP_SKIP_BTCF__MASK                  0x03fc0000U
#define BTCF_TIM_CAPTURE__BTCF_CAP_SKIP_BTCF__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x03fc0000U) >> 18)
#define BTCF_TIM_CAPTURE__TYPE                                        u_int32_t
#define BTCF_TIM_CAPTURE__READ                                      0x03ffffffU

#endif /* __BTCF_TIM_CAPTURE_MACRO__ */


/* macros for bb_reg_map.bb_chn_reg_map.BB_btcf_tim_cpature */
#define INST_BB_REG_MAP__BB_CHN_REG_MAP__BB_BTCF_TIM_CPATURE__NUM             1

/* macros for BlueprintGlobalNameSpace::btcf_idx_capture */
#ifndef __BTCF_IDX_CAPTURE_MACRO__
#define __BTCF_IDX_CAPTURE_MACRO__

/* macros for field btcf_cap_min_idx */
#define BTCF_IDX_CAPTURE__BTCF_CAP_MIN_IDX__SHIFT                             0
#define BTCF_IDX_CAPTURE__BTCF_CAP_MIN_IDX__WIDTH                             3
#define BTCF_IDX_CAPTURE__BTCF_CAP_MIN_IDX__MASK                    0x00000007U
#define BTCF_IDX_CAPTURE__BTCF_CAP_MIN_IDX__READ(src) \
                    (u_int32_t)(src)\
                    & 0x00000007U

/* macros for field btcf_cap_picked_idx */
#define BTCF_IDX_CAPTURE__BTCF_CAP_PICKED_IDX__SHIFT                          3
#define BTCF_IDX_CAPTURE__BTCF_CAP_PICKED_IDX__WIDTH                          3
#define BTCF_IDX_CAPTURE__BTCF_CAP_PICKED_IDX__MASK                 0x00000038U
#define BTCF_IDX_CAPTURE__BTCF_CAP_PICKED_IDX__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000038U) >> 3)
#define BTCF_IDX_CAPTURE__TYPE                                        u_int32_t
#define BTCF_IDX_CAPTURE__READ                                      0x0000003fU

#endif /* __BTCF_IDX_CAPTURE_MACRO__ */


/* macros for bb_reg_map.bb_chn_reg_map.BB_btcf_idx_cpature */
#define INST_BB_REG_MAP__BB_CHN_REG_MAP__BB_BTCF_IDX_CPATURE__NUM             1

/* macros for BlueprintGlobalNameSpace::btcf_fftstartstore */
#ifndef __BTCF_FFTSTARTSTORE_MACRO__
#define __BTCF_FFTSTARTSTORE_MACRO__

/* macros for field btcf_br1_fftstart */
#define BTCF_FFTSTARTSTORE__BTCF_BR1_FFTSTART__SHIFT                          0
#define BTCF_FFTSTARTSTORE__BTCF_BR1_FFTSTART__WIDTH                         10
#define BTCF_FFTSTARTSTORE__BTCF_BR1_FFTSTART__MASK                 0x000003ffU
#define BTCF_FFTSTARTSTORE__BTCF_BR1_FFTSTART__READ(src) \
                    (u_int32_t)(src)\
                    & 0x000003ffU

/* macros for field btcf_br2_fftstart */
#define BTCF_FFTSTARTSTORE__BTCF_BR2_FFTSTART__SHIFT                         10
#define BTCF_FFTSTARTSTORE__BTCF_BR2_FFTSTART__WIDTH                         10
#define BTCF_FFTSTARTSTORE__BTCF_BR2_FFTSTART__MASK                 0x000ffc00U
#define BTCF_FFTSTARTSTORE__BTCF_BR2_FFTSTART__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x000ffc00U) >> 10)

/* macros for field btcf_freeze */
#define BTCF_FFTSTARTSTORE__BTCF_FREEZE__SHIFT                               20
#define BTCF_FFTSTARTSTORE__BTCF_FREEZE__WIDTH                                1
#define BTCF_FFTSTARTSTORE__BTCF_FREEZE__MASK                       0x00100000U
#define BTCF_FFTSTARTSTORE__BTCF_FREEZE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00100000U) >> 20)
#define BTCF_FFTSTARTSTORE__BTCF_FREEZE__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 20) & 0x00100000U)
#define BTCF_FFTSTARTSTORE__BTCF_FREEZE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00100000U) | (((u_int32_t)(src) <<\
                    20) & 0x00100000U)
#define BTCF_FFTSTARTSTORE__BTCF_FREEZE__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 20) & ~0x00100000U)))
#define BTCF_FFTSTARTSTORE__BTCF_FREEZE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00100000U) | ((u_int32_t)(1) << 20)
#define BTCF_FFTSTARTSTORE__BTCF_FREEZE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00100000U) | ((u_int32_t)(0) << 20)
#define BTCF_FFTSTARTSTORE__TYPE                                      u_int32_t
#define BTCF_FFTSTARTSTORE__READ                                    0x001fffffU
#define BTCF_FFTSTARTSTORE__WRITE                                   0x001fffffU

#endif /* __BTCF_FFTSTARTSTORE_MACRO__ */


/* macros for bb_reg_map.bb_chn_reg_map.BB_btcf_fftstartstore */
#define INST_BB_REG_MAP__BB_CHN_REG_MAP__BB_BTCF_FFTSTARTSTORE__NUM           1

/* macros for BlueprintGlobalNameSpace::btcf_pwr_atmin_d169 */
#ifndef __BTCF_PWR_ATMIN_D169_MACRO__
#define __BTCF_PWR_ATMIN_D169_MACRO__

/* macros for field btcf_pwr_atmin_d169_value */
#define BTCF_PWR_ATMIN_D169__BTCF_PWR_ATMIN_D169_VALUE__SHIFT                 0
#define BTCF_PWR_ATMIN_D169__BTCF_PWR_ATMIN_D169_VALUE__WIDTH                16
#define BTCF_PWR_ATMIN_D169__BTCF_PWR_ATMIN_D169_VALUE__MASK        0x0000ffffU
#define BTCF_PWR_ATMIN_D169__BTCF_PWR_ATMIN_D169_VALUE__READ(src) \
                    (u_int32_t)(src)\
                    & 0x0000ffffU
#define BTCF_PWR_ATMIN_D169__TYPE                                     u_int32_t
#define BTCF_PWR_ATMIN_D169__READ                                   0x0000ffffU

#endif /* __BTCF_PWR_ATMIN_D169_MACRO__ */


/* macros for bb_reg_map.bb_chn_reg_map.BB_btcf_pwr_atmin_169 */
#define INST_BB_REG_MAP__BB_CHN_REG_MAP__BB_BTCF_PWR_ATMIN_169__NUM           1

/* macros for BlueprintGlobalNameSpace::btcf_offscnt_atmin_d169 */
#ifndef __BTCF_OFFSCNT_ATMIN_D169_MACRO__
#define __BTCF_OFFSCNT_ATMIN_D169_MACRO__

/* macros for field btcf_offscnt_atmin_d169_value */
#define BTCF_OFFSCNT_ATMIN_D169__BTCF_OFFSCNT_ATMIN_D169_VALUE__SHIFT         0
#define BTCF_OFFSCNT_ATMIN_D169__BTCF_OFFSCNT_ATMIN_D169_VALUE__WIDTH         8
#define BTCF_OFFSCNT_ATMIN_D169__BTCF_OFFSCNT_ATMIN_D169_VALUE__MASK \
                    0x000000ffU
#define BTCF_OFFSCNT_ATMIN_D169__BTCF_OFFSCNT_ATMIN_D169_VALUE__READ(src) \
                    (u_int32_t)(src)\
                    & 0x000000ffU

/* macros for field btcf_delta_pos_lim */
#define BTCF_OFFSCNT_ATMIN_D169__BTCF_DELTA_POS_LIM__SHIFT                    8
#define BTCF_OFFSCNT_ATMIN_D169__BTCF_DELTA_POS_LIM__WIDTH                    9
#define BTCF_OFFSCNT_ATMIN_D169__BTCF_DELTA_POS_LIM__MASK           0x0001ff00U
#define BTCF_OFFSCNT_ATMIN_D169__BTCF_DELTA_POS_LIM__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0001ff00U) >> 8)
#define BTCF_OFFSCNT_ATMIN_D169__BTCF_DELTA_POS_LIM__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 8) & 0x0001ff00U)
#define BTCF_OFFSCNT_ATMIN_D169__BTCF_DELTA_POS_LIM__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0001ff00U) | (((u_int32_t)(src) <<\
                    8) & 0x0001ff00U)
#define BTCF_OFFSCNT_ATMIN_D169__BTCF_DELTA_POS_LIM__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 8) & ~0x0001ff00U)))

/* macros for field btcf_delta_neg_lim */
#define BTCF_OFFSCNT_ATMIN_D169__BTCF_DELTA_NEG_LIM__SHIFT                   17
#define BTCF_OFFSCNT_ATMIN_D169__BTCF_DELTA_NEG_LIM__WIDTH                    9
#define BTCF_OFFSCNT_ATMIN_D169__BTCF_DELTA_NEG_LIM__MASK           0x03fe0000U
#define BTCF_OFFSCNT_ATMIN_D169__BTCF_DELTA_NEG_LIM__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x03fe0000U) >> 17)
#define BTCF_OFFSCNT_ATMIN_D169__BTCF_DELTA_NEG_LIM__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 17) & 0x03fe0000U)
#define BTCF_OFFSCNT_ATMIN_D169__BTCF_DELTA_NEG_LIM__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x03fe0000U) | (((u_int32_t)(src) <<\
                    17) & 0x03fe0000U)
#define BTCF_OFFSCNT_ATMIN_D169__BTCF_DELTA_NEG_LIM__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 17) & ~0x03fe0000U)))
#define BTCF_OFFSCNT_ATMIN_D169__TYPE                                 u_int32_t
#define BTCF_OFFSCNT_ATMIN_D169__READ                               0x03ffffffU
#define BTCF_OFFSCNT_ATMIN_D169__WRITE                              0x03ffffffU

#endif /* __BTCF_OFFSCNT_ATMIN_D169_MACRO__ */


/* macros for bb_reg_map.bb_chn_reg_map.BB_bcf_offscnt_atmin_169 */
#define INST_BB_REG_MAP__BB_CHN_REG_MAP__BB_BCF_OFFSCNT_ATMIN_169__NUM        1

/* macros for BlueprintGlobalNameSpace::btcf_abort */
#ifndef __BTCF_ABORT_MACRO__
#define __BTCF_ABORT_MACRO__

/* macros for field btcf_abort_count */
#define BTCF_ABORT__BTCF_ABORT_COUNT__SHIFT                                   0
#define BTCF_ABORT__BTCF_ABORT_COUNT__WIDTH                                  16
#define BTCF_ABORT__BTCF_ABORT_COUNT__MASK                          0x0000ffffU
#define BTCF_ABORT__BTCF_ABORT_COUNT__READ(src)  (u_int32_t)(src) & 0x0000ffffU
#define BTCF_ABORT__TYPE                                              u_int32_t
#define BTCF_ABORT__READ                                            0x0000ffffU
#define BTCF_ABORT__RCLR                                            0x0000ffffU

#endif /* __BTCF_ABORT_MACRO__ */


/* macros for bb_reg_map.bb_chn_reg_map.BB_btcf_abort_cnt */
#define INST_BB_REG_MAP__BB_CHN_REG_MAP__BB_BTCF_ABORT_CNT__NUM               1

/* macros for BlueprintGlobalNameSpace::btcf_minstore_br1 */
#ifndef __BTCF_MINSTORE_BR1_MACRO__
#define __BTCF_MINSTORE_BR1_MACRO__

/* macros for field btcf_br1_id */
#define BTCF_MINSTORE_BR1__BTCF_BR1_ID__SHIFT                                 0
#define BTCF_MINSTORE_BR1__BTCF_BR1_ID__WIDTH                                 3
#define BTCF_MINSTORE_BR1__BTCF_BR1_ID__MASK                        0x00000007U
#define BTCF_MINSTORE_BR1__BTCF_BR1_ID__READ(src) \
                    (u_int32_t)(src)\
                    & 0x00000007U
#define BTCF_MINSTORE_BR1__BTCF_BR1_ID__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x00000007U)
#define BTCF_MINSTORE_BR1__BTCF_BR1_ID__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000007U) | ((u_int32_t)(src) &\
                    0x00000007U)
#define BTCF_MINSTORE_BR1__BTCF_BR1_ID__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00000007U)))

/* macros for field btcf_br1_postminindx */
#define BTCF_MINSTORE_BR1__BTCF_BR1_POSTMININDX__SHIFT                        3
#define BTCF_MINSTORE_BR1__BTCF_BR1_POSTMININDX__WIDTH                        5
#define BTCF_MINSTORE_BR1__BTCF_BR1_POSTMININDX__MASK               0x000000f8U
#define BTCF_MINSTORE_BR1__BTCF_BR1_POSTMININDX__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x000000f8U) >> 3)
#define BTCF_MINSTORE_BR1__BTCF_BR1_POSTMININDX__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 3) & 0x000000f8U)
#define BTCF_MINSTORE_BR1__BTCF_BR1_POSTMININDX__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000000f8U) | (((u_int32_t)(src) <<\
                    3) & 0x000000f8U)
#define BTCF_MINSTORE_BR1__BTCF_BR1_POSTMININDX__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 3) & ~0x000000f8U)))

/* macros for field btcf_br1_value */
#define BTCF_MINSTORE_BR1__BTCF_BR1_VALUE__SHIFT                              8
#define BTCF_MINSTORE_BR1__BTCF_BR1_VALUE__WIDTH                             21
#define BTCF_MINSTORE_BR1__BTCF_BR1_VALUE__MASK                     0x1fffff00U
#define BTCF_MINSTORE_BR1__BTCF_BR1_VALUE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x1fffff00U) >> 8)
#define BTCF_MINSTORE_BR1__TYPE                                       u_int32_t
#define BTCF_MINSTORE_BR1__READ                                     0x1fffffffU
#define BTCF_MINSTORE_BR1__WRITE                                    0x1fffffffU

#endif /* __BTCF_MINSTORE_BR1_MACRO__ */


/* macros for bb_reg_map.bb_chn_reg_map.BB_bcf_minstore_br1 */
#define INST_BB_REG_MAP__BB_CHN_REG_MAP__BB_BCF_MINSTORE_BR1__NUM             1

/* macros for BlueprintGlobalNameSpace::btcf_minstore_br2 */
#ifndef __BTCF_MINSTORE_BR2_MACRO__
#define __BTCF_MINSTORE_BR2_MACRO__

/* macros for field btcf_br2_id */
#define BTCF_MINSTORE_BR2__BTCF_BR2_ID__SHIFT                                 0
#define BTCF_MINSTORE_BR2__BTCF_BR2_ID__WIDTH                                 3
#define BTCF_MINSTORE_BR2__BTCF_BR2_ID__MASK                        0x00000007U
#define BTCF_MINSTORE_BR2__BTCF_BR2_ID__READ(src) \
                    (u_int32_t)(src)\
                    & 0x00000007U
#define BTCF_MINSTORE_BR2__BTCF_BR2_ID__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x00000007U)
#define BTCF_MINSTORE_BR2__BTCF_BR2_ID__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000007U) | ((u_int32_t)(src) &\
                    0x00000007U)
#define BTCF_MINSTORE_BR2__BTCF_BR2_ID__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00000007U)))

/* macros for field btcf_br2_postminindx */
#define BTCF_MINSTORE_BR2__BTCF_BR2_POSTMININDX__SHIFT                        3
#define BTCF_MINSTORE_BR2__BTCF_BR2_POSTMININDX__WIDTH                        5
#define BTCF_MINSTORE_BR2__BTCF_BR2_POSTMININDX__MASK               0x000000f8U
#define BTCF_MINSTORE_BR2__BTCF_BR2_POSTMININDX__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x000000f8U) >> 3)
#define BTCF_MINSTORE_BR2__BTCF_BR2_POSTMININDX__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 3) & 0x000000f8U)
#define BTCF_MINSTORE_BR2__BTCF_BR2_POSTMININDX__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000000f8U) | (((u_int32_t)(src) <<\
                    3) & 0x000000f8U)
#define BTCF_MINSTORE_BR2__BTCF_BR2_POSTMININDX__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 3) & ~0x000000f8U)))

/* macros for field btcf_br2_value */
#define BTCF_MINSTORE_BR2__BTCF_BR2_VALUE__SHIFT                              8
#define BTCF_MINSTORE_BR2__BTCF_BR2_VALUE__WIDTH                             21
#define BTCF_MINSTORE_BR2__BTCF_BR2_VALUE__MASK                     0x1fffff00U
#define BTCF_MINSTORE_BR2__BTCF_BR2_VALUE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x1fffff00U) >> 8)
#define BTCF_MINSTORE_BR2__TYPE                                       u_int32_t
#define BTCF_MINSTORE_BR2__READ                                     0x1fffffffU
#define BTCF_MINSTORE_BR2__WRITE                                    0x1fffffffU

#endif /* __BTCF_MINSTORE_BR2_MACRO__ */


/* macros for bb_reg_map.bb_chn_reg_map.BB_bcf_minstore_br2 */
#define INST_BB_REG_MAP__BB_CHN_REG_MAP__BB_BCF_MINSTORE_BR2__NUM             1

/* macros for BlueprintGlobalNameSpace::tx_overlap_window */
#ifndef __TX_OVERLAP_WINDOW_MACRO__
#define __TX_OVERLAP_WINDOW_MACRO__

/* macros for field overlap_window_bw20MHz */
#define TX_OVERLAP_WINDOW__OVERLAP_WINDOW_BW20MHZ__SHIFT                      0
#define TX_OVERLAP_WINDOW__OVERLAP_WINDOW_BW20MHZ__WIDTH                      4
#define TX_OVERLAP_WINDOW__OVERLAP_WINDOW_BW20MHZ__MASK             0x0000000fU
#define TX_OVERLAP_WINDOW__OVERLAP_WINDOW_BW20MHZ__READ(src) \
                    (u_int32_t)(src)\
                    & 0x0000000fU
#define TX_OVERLAP_WINDOW__OVERLAP_WINDOW_BW20MHZ__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x0000000fU)
#define TX_OVERLAP_WINDOW__OVERLAP_WINDOW_BW20MHZ__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000000fU) | ((u_int32_t)(src) &\
                    0x0000000fU)
#define TX_OVERLAP_WINDOW__OVERLAP_WINDOW_BW20MHZ__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x0000000fU)))

/* macros for field overlap_window_bw40MHz */
#define TX_OVERLAP_WINDOW__OVERLAP_WINDOW_BW40MHZ__SHIFT                      4
#define TX_OVERLAP_WINDOW__OVERLAP_WINDOW_BW40MHZ__WIDTH                      4
#define TX_OVERLAP_WINDOW__OVERLAP_WINDOW_BW40MHZ__MASK             0x000000f0U
#define TX_OVERLAP_WINDOW__OVERLAP_WINDOW_BW40MHZ__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x000000f0U) >> 4)
#define TX_OVERLAP_WINDOW__OVERLAP_WINDOW_BW40MHZ__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 4) & 0x000000f0U)
#define TX_OVERLAP_WINDOW__OVERLAP_WINDOW_BW40MHZ__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000000f0U) | (((u_int32_t)(src) <<\
                    4) & 0x000000f0U)
#define TX_OVERLAP_WINDOW__OVERLAP_WINDOW_BW40MHZ__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 4) & ~0x000000f0U)))

/* macros for field overlap_window_bw80MHz */
#define TX_OVERLAP_WINDOW__OVERLAP_WINDOW_BW80MHZ__SHIFT                      8
#define TX_OVERLAP_WINDOW__OVERLAP_WINDOW_BW80MHZ__WIDTH                      4
#define TX_OVERLAP_WINDOW__OVERLAP_WINDOW_BW80MHZ__MASK             0x00000f00U
#define TX_OVERLAP_WINDOW__OVERLAP_WINDOW_BW80MHZ__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000f00U) >> 8)
#define TX_OVERLAP_WINDOW__OVERLAP_WINDOW_BW80MHZ__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 8) & 0x00000f00U)
#define TX_OVERLAP_WINDOW__OVERLAP_WINDOW_BW80MHZ__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000f00U) | (((u_int32_t)(src) <<\
                    8) & 0x00000f00U)
#define TX_OVERLAP_WINDOW__OVERLAP_WINDOW_BW80MHZ__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 8) & ~0x00000f00U)))
#define TX_OVERLAP_WINDOW__TYPE                                       u_int32_t
#define TX_OVERLAP_WINDOW__READ                                     0x00000fffU
#define TX_OVERLAP_WINDOW__WRITE                                    0x00000fffU

#endif /* __TX_OVERLAP_WINDOW_MACRO__ */


/* macros for bb_reg_map.bb_chn_reg_map.BB_tx_overlap_window */
#define INST_BB_REG_MAP__BB_CHN_REG_MAP__BB_TX_OVERLAP_WINDOW__NUM            1

/* macros for BlueprintGlobalNameSpace::per_chain_legacy_csd */
#ifndef __PER_CHAIN_LEGACY_CSD_MACRO__
#define __PER_CHAIN_LEGACY_CSD_MACRO__

/* macros for field leg_csd_chn1_2chains */
#define PER_CHAIN_LEGACY_CSD__LEG_CSD_CHN1_2CHAINS__SHIFT                     0
#define PER_CHAIN_LEGACY_CSD__LEG_CSD_CHN1_2CHAINS__WIDTH                     5
#define PER_CHAIN_LEGACY_CSD__LEG_CSD_CHN1_2CHAINS__MASK            0x0000001fU
#define PER_CHAIN_LEGACY_CSD__LEG_CSD_CHN1_2CHAINS__READ(src) \
                    (u_int32_t)(src)\
                    & 0x0000001fU
#define PER_CHAIN_LEGACY_CSD__LEG_CSD_CHN1_2CHAINS__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x0000001fU)
#define PER_CHAIN_LEGACY_CSD__LEG_CSD_CHN1_2CHAINS__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000001fU) | ((u_int32_t)(src) &\
                    0x0000001fU)
#define PER_CHAIN_LEGACY_CSD__LEG_CSD_CHN1_2CHAINS__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x0000001fU)))

/* macros for field leg_csd_chn1_3chains */
#define PER_CHAIN_LEGACY_CSD__LEG_CSD_CHN1_3CHAINS__SHIFT                     5
#define PER_CHAIN_LEGACY_CSD__LEG_CSD_CHN1_3CHAINS__WIDTH                     5
#define PER_CHAIN_LEGACY_CSD__LEG_CSD_CHN1_3CHAINS__MASK            0x000003e0U
#define PER_CHAIN_LEGACY_CSD__LEG_CSD_CHN1_3CHAINS__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x000003e0U) >> 5)
#define PER_CHAIN_LEGACY_CSD__LEG_CSD_CHN1_3CHAINS__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 5) & 0x000003e0U)
#define PER_CHAIN_LEGACY_CSD__LEG_CSD_CHN1_3CHAINS__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000003e0U) | (((u_int32_t)(src) <<\
                    5) & 0x000003e0U)
#define PER_CHAIN_LEGACY_CSD__LEG_CSD_CHN1_3CHAINS__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 5) & ~0x000003e0U)))

/* macros for field leg_csd_chn2_3chains */
#define PER_CHAIN_LEGACY_CSD__LEG_CSD_CHN2_3CHAINS__SHIFT                    10
#define PER_CHAIN_LEGACY_CSD__LEG_CSD_CHN2_3CHAINS__WIDTH                     5
#define PER_CHAIN_LEGACY_CSD__LEG_CSD_CHN2_3CHAINS__MASK            0x00007c00U
#define PER_CHAIN_LEGACY_CSD__LEG_CSD_CHN2_3CHAINS__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00007c00U) >> 10)
#define PER_CHAIN_LEGACY_CSD__LEG_CSD_CHN2_3CHAINS__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 10) & 0x00007c00U)
#define PER_CHAIN_LEGACY_CSD__LEG_CSD_CHN2_3CHAINS__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00007c00U) | (((u_int32_t)(src) <<\
                    10) & 0x00007c00U)
#define PER_CHAIN_LEGACY_CSD__LEG_CSD_CHN2_3CHAINS__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 10) & ~0x00007c00U)))

/* macros for field leg_csd_chn1_4chains */
#define PER_CHAIN_LEGACY_CSD__LEG_CSD_CHN1_4CHAINS__SHIFT                    15
#define PER_CHAIN_LEGACY_CSD__LEG_CSD_CHN1_4CHAINS__WIDTH                     5
#define PER_CHAIN_LEGACY_CSD__LEG_CSD_CHN1_4CHAINS__MASK            0x000f8000U
#define PER_CHAIN_LEGACY_CSD__LEG_CSD_CHN1_4CHAINS__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x000f8000U) >> 15)
#define PER_CHAIN_LEGACY_CSD__LEG_CSD_CHN1_4CHAINS__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 15) & 0x000f8000U)
#define PER_CHAIN_LEGACY_CSD__LEG_CSD_CHN1_4CHAINS__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000f8000U) | (((u_int32_t)(src) <<\
                    15) & 0x000f8000U)
#define PER_CHAIN_LEGACY_CSD__LEG_CSD_CHN1_4CHAINS__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 15) & ~0x000f8000U)))

/* macros for field leg_csd_chn2_4chains */
#define PER_CHAIN_LEGACY_CSD__LEG_CSD_CHN2_4CHAINS__SHIFT                    20
#define PER_CHAIN_LEGACY_CSD__LEG_CSD_CHN2_4CHAINS__WIDTH                     5
#define PER_CHAIN_LEGACY_CSD__LEG_CSD_CHN2_4CHAINS__MASK            0x01f00000U
#define PER_CHAIN_LEGACY_CSD__LEG_CSD_CHN2_4CHAINS__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x01f00000U) >> 20)
#define PER_CHAIN_LEGACY_CSD__LEG_CSD_CHN2_4CHAINS__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 20) & 0x01f00000U)
#define PER_CHAIN_LEGACY_CSD__LEG_CSD_CHN2_4CHAINS__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x01f00000U) | (((u_int32_t)(src) <<\
                    20) & 0x01f00000U)
#define PER_CHAIN_LEGACY_CSD__LEG_CSD_CHN2_4CHAINS__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 20) & ~0x01f00000U)))

/* macros for field leg_csd_chn3_4chains */
#define PER_CHAIN_LEGACY_CSD__LEG_CSD_CHN3_4CHAINS__SHIFT                    25
#define PER_CHAIN_LEGACY_CSD__LEG_CSD_CHN3_4CHAINS__WIDTH                     5
#define PER_CHAIN_LEGACY_CSD__LEG_CSD_CHN3_4CHAINS__MASK            0x3e000000U
#define PER_CHAIN_LEGACY_CSD__LEG_CSD_CHN3_4CHAINS__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x3e000000U) >> 25)
#define PER_CHAIN_LEGACY_CSD__LEG_CSD_CHN3_4CHAINS__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 25) & 0x3e000000U)
#define PER_CHAIN_LEGACY_CSD__LEG_CSD_CHN3_4CHAINS__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x3e000000U) | (((u_int32_t)(src) <<\
                    25) & 0x3e000000U)
#define PER_CHAIN_LEGACY_CSD__LEG_CSD_CHN3_4CHAINS__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 25) & ~0x3e000000U)))
#define PER_CHAIN_LEGACY_CSD__TYPE                                    u_int32_t
#define PER_CHAIN_LEGACY_CSD__READ                                  0x3fffffffU
#define PER_CHAIN_LEGACY_CSD__WRITE                                 0x3fffffffU

#endif /* __PER_CHAIN_LEGACY_CSD_MACRO__ */


/* macros for bb_reg_map.bb_chn_reg_map.BB_per_chain_legacy_csd */
#define INST_BB_REG_MAP__BB_CHN_REG_MAP__BB_PER_CHAIN_LEGACY_CSD__NUM         1

/* macros for BlueprintGlobalNameSpace::fdtg_control0 */
#ifndef __FDTG_CONTROL0_MACRO__
#define __FDTG_CONTROL0_MACRO__

/* macros for field fdtg_enable */
#define FDTG_CONTROL0__FDTG_ENABLE__SHIFT                                     0
#define FDTG_CONTROL0__FDTG_ENABLE__WIDTH                                     1
#define FDTG_CONTROL0__FDTG_ENABLE__MASK                            0x00000001U
#define FDTG_CONTROL0__FDTG_ENABLE__READ(src)    (u_int32_t)(src) & 0x00000001U
#define FDTG_CONTROL0__FDTG_ENABLE__WRITE(src) ((u_int32_t)(src) & 0x00000001U)
#define FDTG_CONTROL0__FDTG_ENABLE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | ((u_int32_t)(src) &\
                    0x00000001U)
#define FDTG_CONTROL0__FDTG_ENABLE__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00000001U)))
#define FDTG_CONTROL0__FDTG_ENABLE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(1)
#define FDTG_CONTROL0__FDTG_ENABLE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(0)

/* macros for field fdtg_ss0_a_addr */
#define FDTG_CONTROL0__FDTG_SS0_A_ADDR__SHIFT                                 1
#define FDTG_CONTROL0__FDTG_SS0_A_ADDR__WIDTH                                 8
#define FDTG_CONTROL0__FDTG_SS0_A_ADDR__MASK                        0x000001feU
#define FDTG_CONTROL0__FDTG_SS0_A_ADDR__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x000001feU) >> 1)
#define FDTG_CONTROL0__FDTG_SS0_A_ADDR__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 1) & 0x000001feU)
#define FDTG_CONTROL0__FDTG_SS0_A_ADDR__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000001feU) | (((u_int32_t)(src) <<\
                    1) & 0x000001feU)
#define FDTG_CONTROL0__FDTG_SS0_A_ADDR__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 1) & ~0x000001feU)))

/* macros for field fdtg_ss0_b_addr */
#define FDTG_CONTROL0__FDTG_SS0_B_ADDR__SHIFT                                 9
#define FDTG_CONTROL0__FDTG_SS0_B_ADDR__WIDTH                                 8
#define FDTG_CONTROL0__FDTG_SS0_B_ADDR__MASK                        0x0001fe00U
#define FDTG_CONTROL0__FDTG_SS0_B_ADDR__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0001fe00U) >> 9)
#define FDTG_CONTROL0__FDTG_SS0_B_ADDR__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 9) & 0x0001fe00U)
#define FDTG_CONTROL0__FDTG_SS0_B_ADDR__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0001fe00U) | (((u_int32_t)(src) <<\
                    9) & 0x0001fe00U)
#define FDTG_CONTROL0__FDTG_SS0_B_ADDR__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 9) & ~0x0001fe00U)))

/* macros for field fdtg_suppress_preamble */
#define FDTG_CONTROL0__FDTG_SUPPRESS_PREAMBLE__SHIFT                         17
#define FDTG_CONTROL0__FDTG_SUPPRESS_PREAMBLE__WIDTH                          1
#define FDTG_CONTROL0__FDTG_SUPPRESS_PREAMBLE__MASK                 0x00020000U
#define FDTG_CONTROL0__FDTG_SUPPRESS_PREAMBLE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00020000U) >> 17)
#define FDTG_CONTROL0__FDTG_SUPPRESS_PREAMBLE__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 17) & 0x00020000U)
#define FDTG_CONTROL0__FDTG_SUPPRESS_PREAMBLE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00020000U) | (((u_int32_t)(src) <<\
                    17) & 0x00020000U)
#define FDTG_CONTROL0__FDTG_SUPPRESS_PREAMBLE__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 17) & ~0x00020000U)))
#define FDTG_CONTROL0__FDTG_SUPPRESS_PREAMBLE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00020000U) | ((u_int32_t)(1) << 17)
#define FDTG_CONTROL0__FDTG_SUPPRESS_PREAMBLE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00020000U) | ((u_int32_t)(0) << 17)
#define FDTG_CONTROL0__TYPE                                           u_int32_t
#define FDTG_CONTROL0__READ                                         0x0003ffffU
#define FDTG_CONTROL0__WRITE                                        0x0003ffffU

#endif /* __FDTG_CONTROL0_MACRO__ */


/* macros for bb_reg_map.bb_chn_reg_map.BB_fdtg_control0 */
#define INST_BB_REG_MAP__BB_CHN_REG_MAP__BB_FDTG_CONTROL0__NUM                1

/* macros for BlueprintGlobalNameSpace::fdtg_control1 */
#ifndef __FDTG_CONTROL1_MACRO__
#define __FDTG_CONTROL1_MACRO__

/* macros for field fdtg_ss1_a_addr */
#define FDTG_CONTROL1__FDTG_SS1_A_ADDR__SHIFT                                 0
#define FDTG_CONTROL1__FDTG_SS1_A_ADDR__WIDTH                                 8
#define FDTG_CONTROL1__FDTG_SS1_A_ADDR__MASK                        0x000000ffU
#define FDTG_CONTROL1__FDTG_SS1_A_ADDR__READ(src) \
                    (u_int32_t)(src)\
                    & 0x000000ffU
#define FDTG_CONTROL1__FDTG_SS1_A_ADDR__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x000000ffU)
#define FDTG_CONTROL1__FDTG_SS1_A_ADDR__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000000ffU) | ((u_int32_t)(src) &\
                    0x000000ffU)
#define FDTG_CONTROL1__FDTG_SS1_A_ADDR__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x000000ffU)))

/* macros for field fdtg_ss1_b_addr */
#define FDTG_CONTROL1__FDTG_SS1_B_ADDR__SHIFT                                 8
#define FDTG_CONTROL1__FDTG_SS1_B_ADDR__WIDTH                                 8
#define FDTG_CONTROL1__FDTG_SS1_B_ADDR__MASK                        0x0000ff00U
#define FDTG_CONTROL1__FDTG_SS1_B_ADDR__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0000ff00U) >> 8)
#define FDTG_CONTROL1__FDTG_SS1_B_ADDR__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 8) & 0x0000ff00U)
#define FDTG_CONTROL1__FDTG_SS1_B_ADDR__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000ff00U) | (((u_int32_t)(src) <<\
                    8) & 0x0000ff00U)
#define FDTG_CONTROL1__FDTG_SS1_B_ADDR__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 8) & ~0x0000ff00U)))

/* macros for field fdtg_ss2_a_addr */
#define FDTG_CONTROL1__FDTG_SS2_A_ADDR__SHIFT                                16
#define FDTG_CONTROL1__FDTG_SS2_A_ADDR__WIDTH                                 8
#define FDTG_CONTROL1__FDTG_SS2_A_ADDR__MASK                        0x00ff0000U
#define FDTG_CONTROL1__FDTG_SS2_A_ADDR__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00ff0000U) >> 16)
#define FDTG_CONTROL1__FDTG_SS2_A_ADDR__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 16) & 0x00ff0000U)
#define FDTG_CONTROL1__FDTG_SS2_A_ADDR__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00ff0000U) | (((u_int32_t)(src) <<\
                    16) & 0x00ff0000U)
#define FDTG_CONTROL1__FDTG_SS2_A_ADDR__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 16) & ~0x00ff0000U)))

/* macros for field fdtg_ss2_b_addr */
#define FDTG_CONTROL1__FDTG_SS2_B_ADDR__SHIFT                                24
#define FDTG_CONTROL1__FDTG_SS2_B_ADDR__WIDTH                                 8
#define FDTG_CONTROL1__FDTG_SS2_B_ADDR__MASK                        0xff000000U
#define FDTG_CONTROL1__FDTG_SS2_B_ADDR__READ(src) \
                    (((u_int32_t)(src)\
                    & 0xff000000U) >> 24)
#define FDTG_CONTROL1__FDTG_SS2_B_ADDR__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 24) & 0xff000000U)
#define FDTG_CONTROL1__FDTG_SS2_B_ADDR__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xff000000U) | (((u_int32_t)(src) <<\
                    24) & 0xff000000U)
#define FDTG_CONTROL1__FDTG_SS2_B_ADDR__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 24) & ~0xff000000U)))
#define FDTG_CONTROL1__TYPE                                           u_int32_t
#define FDTG_CONTROL1__READ                                         0xffffffffU
#define FDTG_CONTROL1__WRITE                                        0xffffffffU

#endif /* __FDTG_CONTROL1_MACRO__ */


/* macros for bb_reg_map.bb_chn_reg_map.BB_fdtg_control1 */
#define INST_BB_REG_MAP__BB_CHN_REG_MAP__BB_FDTG_CONTROL1__NUM                1

/* macros for BlueprintGlobalNameSpace::fdtg_ss0_data_b0 */
#ifndef __FDTG_SS0_DATA_B0_MACRO__
#define __FDTG_SS0_DATA_B0_MACRO__

/* macros for field fdtg_ss0_a_data_re_0 */
#define FDTG_SS0_DATA_B0__FDTG_SS0_A_DATA_RE_0__SHIFT                         0
#define FDTG_SS0_DATA_B0__FDTG_SS0_A_DATA_RE_0__WIDTH                         8
#define FDTG_SS0_DATA_B0__FDTG_SS0_A_DATA_RE_0__MASK                0x000000ffU
#define FDTG_SS0_DATA_B0__FDTG_SS0_A_DATA_RE_0__READ(src) \
                    (u_int32_t)(src)\
                    & 0x000000ffU
#define FDTG_SS0_DATA_B0__FDTG_SS0_A_DATA_RE_0__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x000000ffU)
#define FDTG_SS0_DATA_B0__FDTG_SS0_A_DATA_RE_0__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000000ffU) | ((u_int32_t)(src) &\
                    0x000000ffU)
#define FDTG_SS0_DATA_B0__FDTG_SS0_A_DATA_RE_0__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x000000ffU)))

/* macros for field fdtg_ss0_a_data_im_0 */
#define FDTG_SS0_DATA_B0__FDTG_SS0_A_DATA_IM_0__SHIFT                         8
#define FDTG_SS0_DATA_B0__FDTG_SS0_A_DATA_IM_0__WIDTH                         8
#define FDTG_SS0_DATA_B0__FDTG_SS0_A_DATA_IM_0__MASK                0x0000ff00U
#define FDTG_SS0_DATA_B0__FDTG_SS0_A_DATA_IM_0__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0000ff00U) >> 8)
#define FDTG_SS0_DATA_B0__FDTG_SS0_A_DATA_IM_0__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 8) & 0x0000ff00U)
#define FDTG_SS0_DATA_B0__FDTG_SS0_A_DATA_IM_0__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000ff00U) | (((u_int32_t)(src) <<\
                    8) & 0x0000ff00U)
#define FDTG_SS0_DATA_B0__FDTG_SS0_A_DATA_IM_0__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 8) & ~0x0000ff00U)))

/* macros for field fdtg_ss0_b_data_re_0 */
#define FDTG_SS0_DATA_B0__FDTG_SS0_B_DATA_RE_0__SHIFT                        16
#define FDTG_SS0_DATA_B0__FDTG_SS0_B_DATA_RE_0__WIDTH                         8
#define FDTG_SS0_DATA_B0__FDTG_SS0_B_DATA_RE_0__MASK                0x00ff0000U
#define FDTG_SS0_DATA_B0__FDTG_SS0_B_DATA_RE_0__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00ff0000U) >> 16)
#define FDTG_SS0_DATA_B0__FDTG_SS0_B_DATA_RE_0__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 16) & 0x00ff0000U)
#define FDTG_SS0_DATA_B0__FDTG_SS0_B_DATA_RE_0__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00ff0000U) | (((u_int32_t)(src) <<\
                    16) & 0x00ff0000U)
#define FDTG_SS0_DATA_B0__FDTG_SS0_B_DATA_RE_0__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 16) & ~0x00ff0000U)))

/* macros for field fdtg_ss0_b_data_im_0 */
#define FDTG_SS0_DATA_B0__FDTG_SS0_B_DATA_IM_0__SHIFT                        24
#define FDTG_SS0_DATA_B0__FDTG_SS0_B_DATA_IM_0__WIDTH                         8
#define FDTG_SS0_DATA_B0__FDTG_SS0_B_DATA_IM_0__MASK                0xff000000U
#define FDTG_SS0_DATA_B0__FDTG_SS0_B_DATA_IM_0__READ(src) \
                    (((u_int32_t)(src)\
                    & 0xff000000U) >> 24)
#define FDTG_SS0_DATA_B0__FDTG_SS0_B_DATA_IM_0__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 24) & 0xff000000U)
#define FDTG_SS0_DATA_B0__FDTG_SS0_B_DATA_IM_0__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xff000000U) | (((u_int32_t)(src) <<\
                    24) & 0xff000000U)
#define FDTG_SS0_DATA_B0__FDTG_SS0_B_DATA_IM_0__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 24) & ~0xff000000U)))
#define FDTG_SS0_DATA_B0__TYPE                                        u_int32_t
#define FDTG_SS0_DATA_B0__READ                                      0xffffffffU
#define FDTG_SS0_DATA_B0__WRITE                                     0xffffffffU

#endif /* __FDTG_SS0_DATA_B0_MACRO__ */


/* macros for bb_reg_map.bb_chn_reg_map.BB_fdtg_ss0_data_b0 */
#define INST_BB_REG_MAP__BB_CHN_REG_MAP__BB_FDTG_SS0_DATA_B0__NUM             1

/* macros for BlueprintGlobalNameSpace::fdtg_ss1_data_b0 */
#ifndef __FDTG_SS1_DATA_B0_MACRO__
#define __FDTG_SS1_DATA_B0_MACRO__

/* macros for field fdtg_ss1_a_data_re_0 */
#define FDTG_SS1_DATA_B0__FDTG_SS1_A_DATA_RE_0__SHIFT                         0
#define FDTG_SS1_DATA_B0__FDTG_SS1_A_DATA_RE_0__WIDTH                         8
#define FDTG_SS1_DATA_B0__FDTG_SS1_A_DATA_RE_0__MASK                0x000000ffU
#define FDTG_SS1_DATA_B0__FDTG_SS1_A_DATA_RE_0__READ(src) \
                    (u_int32_t)(src)\
                    & 0x000000ffU
#define FDTG_SS1_DATA_B0__FDTG_SS1_A_DATA_RE_0__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x000000ffU)
#define FDTG_SS1_DATA_B0__FDTG_SS1_A_DATA_RE_0__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000000ffU) | ((u_int32_t)(src) &\
                    0x000000ffU)
#define FDTG_SS1_DATA_B0__FDTG_SS1_A_DATA_RE_0__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x000000ffU)))

/* macros for field fdtg_ss1_a_data_im_0 */
#define FDTG_SS1_DATA_B0__FDTG_SS1_A_DATA_IM_0__SHIFT                         8
#define FDTG_SS1_DATA_B0__FDTG_SS1_A_DATA_IM_0__WIDTH                         8
#define FDTG_SS1_DATA_B0__FDTG_SS1_A_DATA_IM_0__MASK                0x0000ff00U
#define FDTG_SS1_DATA_B0__FDTG_SS1_A_DATA_IM_0__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0000ff00U) >> 8)
#define FDTG_SS1_DATA_B0__FDTG_SS1_A_DATA_IM_0__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 8) & 0x0000ff00U)
#define FDTG_SS1_DATA_B0__FDTG_SS1_A_DATA_IM_0__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000ff00U) | (((u_int32_t)(src) <<\
                    8) & 0x0000ff00U)
#define FDTG_SS1_DATA_B0__FDTG_SS1_A_DATA_IM_0__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 8) & ~0x0000ff00U)))

/* macros for field fdtg_ss1_b_data_re_0 */
#define FDTG_SS1_DATA_B0__FDTG_SS1_B_DATA_RE_0__SHIFT                        16
#define FDTG_SS1_DATA_B0__FDTG_SS1_B_DATA_RE_0__WIDTH                         8
#define FDTG_SS1_DATA_B0__FDTG_SS1_B_DATA_RE_0__MASK                0x00ff0000U
#define FDTG_SS1_DATA_B0__FDTG_SS1_B_DATA_RE_0__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00ff0000U) >> 16)
#define FDTG_SS1_DATA_B0__FDTG_SS1_B_DATA_RE_0__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 16) & 0x00ff0000U)
#define FDTG_SS1_DATA_B0__FDTG_SS1_B_DATA_RE_0__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00ff0000U) | (((u_int32_t)(src) <<\
                    16) & 0x00ff0000U)
#define FDTG_SS1_DATA_B0__FDTG_SS1_B_DATA_RE_0__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 16) & ~0x00ff0000U)))

/* macros for field fdtg_ss1_b_data_im_0 */
#define FDTG_SS1_DATA_B0__FDTG_SS1_B_DATA_IM_0__SHIFT                        24
#define FDTG_SS1_DATA_B0__FDTG_SS1_B_DATA_IM_0__WIDTH                         8
#define FDTG_SS1_DATA_B0__FDTG_SS1_B_DATA_IM_0__MASK                0xff000000U
#define FDTG_SS1_DATA_B0__FDTG_SS1_B_DATA_IM_0__READ(src) \
                    (((u_int32_t)(src)\
                    & 0xff000000U) >> 24)
#define FDTG_SS1_DATA_B0__FDTG_SS1_B_DATA_IM_0__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 24) & 0xff000000U)
#define FDTG_SS1_DATA_B0__FDTG_SS1_B_DATA_IM_0__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xff000000U) | (((u_int32_t)(src) <<\
                    24) & 0xff000000U)
#define FDTG_SS1_DATA_B0__FDTG_SS1_B_DATA_IM_0__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 24) & ~0xff000000U)))
#define FDTG_SS1_DATA_B0__TYPE                                        u_int32_t
#define FDTG_SS1_DATA_B0__READ                                      0xffffffffU
#define FDTG_SS1_DATA_B0__WRITE                                     0xffffffffU

#endif /* __FDTG_SS1_DATA_B0_MACRO__ */


/* macros for bb_reg_map.bb_chn_reg_map.BB_fdtg_ss1_data_b0 */
#define INST_BB_REG_MAP__BB_CHN_REG_MAP__BB_FDTG_SS1_DATA_B0__NUM             1

/* macros for BlueprintGlobalNameSpace::fdtg_ss2_data_b0 */
#ifndef __FDTG_SS2_DATA_B0_MACRO__
#define __FDTG_SS2_DATA_B0_MACRO__

/* macros for field fdtg_ss2_a_data_re_0 */
#define FDTG_SS2_DATA_B0__FDTG_SS2_A_DATA_RE_0__SHIFT                         0
#define FDTG_SS2_DATA_B0__FDTG_SS2_A_DATA_RE_0__WIDTH                         8
#define FDTG_SS2_DATA_B0__FDTG_SS2_A_DATA_RE_0__MASK                0x000000ffU
#define FDTG_SS2_DATA_B0__FDTG_SS2_A_DATA_RE_0__READ(src) \
                    (u_int32_t)(src)\
                    & 0x000000ffU
#define FDTG_SS2_DATA_B0__FDTG_SS2_A_DATA_RE_0__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x000000ffU)
#define FDTG_SS2_DATA_B0__FDTG_SS2_A_DATA_RE_0__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000000ffU) | ((u_int32_t)(src) &\
                    0x000000ffU)
#define FDTG_SS2_DATA_B0__FDTG_SS2_A_DATA_RE_0__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x000000ffU)))

/* macros for field fdtg_ss2_a_data_im_0 */
#define FDTG_SS2_DATA_B0__FDTG_SS2_A_DATA_IM_0__SHIFT                         8
#define FDTG_SS2_DATA_B0__FDTG_SS2_A_DATA_IM_0__WIDTH                         8
#define FDTG_SS2_DATA_B0__FDTG_SS2_A_DATA_IM_0__MASK                0x0000ff00U
#define FDTG_SS2_DATA_B0__FDTG_SS2_A_DATA_IM_0__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0000ff00U) >> 8)
#define FDTG_SS2_DATA_B0__FDTG_SS2_A_DATA_IM_0__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 8) & 0x0000ff00U)
#define FDTG_SS2_DATA_B0__FDTG_SS2_A_DATA_IM_0__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000ff00U) | (((u_int32_t)(src) <<\
                    8) & 0x0000ff00U)
#define FDTG_SS2_DATA_B0__FDTG_SS2_A_DATA_IM_0__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 8) & ~0x0000ff00U)))

/* macros for field fdtg_ss2_b_data_re_0 */
#define FDTG_SS2_DATA_B0__FDTG_SS2_B_DATA_RE_0__SHIFT                        16
#define FDTG_SS2_DATA_B0__FDTG_SS2_B_DATA_RE_0__WIDTH                         8
#define FDTG_SS2_DATA_B0__FDTG_SS2_B_DATA_RE_0__MASK                0x00ff0000U
#define FDTG_SS2_DATA_B0__FDTG_SS2_B_DATA_RE_0__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00ff0000U) >> 16)
#define FDTG_SS2_DATA_B0__FDTG_SS2_B_DATA_RE_0__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 16) & 0x00ff0000U)
#define FDTG_SS2_DATA_B0__FDTG_SS2_B_DATA_RE_0__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00ff0000U) | (((u_int32_t)(src) <<\
                    16) & 0x00ff0000U)
#define FDTG_SS2_DATA_B0__FDTG_SS2_B_DATA_RE_0__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 16) & ~0x00ff0000U)))

/* macros for field fdtg_ss2_b_data_im_0 */
#define FDTG_SS2_DATA_B0__FDTG_SS2_B_DATA_IM_0__SHIFT                        24
#define FDTG_SS2_DATA_B0__FDTG_SS2_B_DATA_IM_0__WIDTH                         8
#define FDTG_SS2_DATA_B0__FDTG_SS2_B_DATA_IM_0__MASK                0xff000000U
#define FDTG_SS2_DATA_B0__FDTG_SS2_B_DATA_IM_0__READ(src) \
                    (((u_int32_t)(src)\
                    & 0xff000000U) >> 24)
#define FDTG_SS2_DATA_B0__FDTG_SS2_B_DATA_IM_0__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 24) & 0xff000000U)
#define FDTG_SS2_DATA_B0__FDTG_SS2_B_DATA_IM_0__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xff000000U) | (((u_int32_t)(src) <<\
                    24) & 0xff000000U)
#define FDTG_SS2_DATA_B0__FDTG_SS2_B_DATA_IM_0__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 24) & ~0xff000000U)))
#define FDTG_SS2_DATA_B0__TYPE                                        u_int32_t
#define FDTG_SS2_DATA_B0__READ                                      0xffffffffU
#define FDTG_SS2_DATA_B0__WRITE                                     0xffffffffU

#endif /* __FDTG_SS2_DATA_B0_MACRO__ */


/* macros for bb_reg_map.bb_chn_reg_map.BB_fdtg_ss2_data_b0 */
#define INST_BB_REG_MAP__BB_CHN_REG_MAP__BB_FDTG_SS2_DATA_B0__NUM             1

/* macros for BlueprintGlobalNameSpace::paprd_am2am_mask2 */
#ifndef __PAPRD_AM2AM_MASK2_MACRO__
#define __PAPRD_AM2AM_MASK2_MACRO__

/* macros for field paprd_am2am_mask2 */
#define PAPRD_AM2AM_MASK2__PAPRD_AM2AM_MASK2__SHIFT                           0
#define PAPRD_AM2AM_MASK2__PAPRD_AM2AM_MASK2__WIDTH                          10
#define PAPRD_AM2AM_MASK2__PAPRD_AM2AM_MASK2__MASK                  0x000003ffU
#define PAPRD_AM2AM_MASK2__PAPRD_AM2AM_MASK2__READ(src) \
                    (u_int32_t)(src)\
                    & 0x000003ffU
#define PAPRD_AM2AM_MASK2__PAPRD_AM2AM_MASK2__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x000003ffU)
#define PAPRD_AM2AM_MASK2__PAPRD_AM2AM_MASK2__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000003ffU) | ((u_int32_t)(src) &\
                    0x000003ffU)
#define PAPRD_AM2AM_MASK2__PAPRD_AM2AM_MASK2__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x000003ffU)))
#define PAPRD_AM2AM_MASK2__TYPE                                       u_int32_t
#define PAPRD_AM2AM_MASK2__READ                                     0x000003ffU
#define PAPRD_AM2AM_MASK2__WRITE                                    0x000003ffU

#endif /* __PAPRD_AM2AM_MASK2_MACRO__ */


/* macros for bb_reg_map.bb_chn_reg_map.BB_paprd_am2am_mask2 */
#define INST_BB_REG_MAP__BB_CHN_REG_MAP__BB_PAPRD_AM2AM_MASK2__NUM            1

/* macros for BlueprintGlobalNameSpace::paprd_am2pm_mask2 */
#ifndef __PAPRD_AM2PM_MASK2_MACRO__
#define __PAPRD_AM2PM_MASK2_MACRO__

/* macros for field paprd_am2pm_mask2 */
#define PAPRD_AM2PM_MASK2__PAPRD_AM2PM_MASK2__SHIFT                           0
#define PAPRD_AM2PM_MASK2__PAPRD_AM2PM_MASK2__WIDTH                          10
#define PAPRD_AM2PM_MASK2__PAPRD_AM2PM_MASK2__MASK                  0x000003ffU
#define PAPRD_AM2PM_MASK2__PAPRD_AM2PM_MASK2__READ(src) \
                    (u_int32_t)(src)\
                    & 0x000003ffU
#define PAPRD_AM2PM_MASK2__PAPRD_AM2PM_MASK2__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x000003ffU)
#define PAPRD_AM2PM_MASK2__PAPRD_AM2PM_MASK2__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000003ffU) | ((u_int32_t)(src) &\
                    0x000003ffU)
#define PAPRD_AM2PM_MASK2__PAPRD_AM2PM_MASK2__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x000003ffU)))
#define PAPRD_AM2PM_MASK2__TYPE                                       u_int32_t
#define PAPRD_AM2PM_MASK2__READ                                     0x000003ffU
#define PAPRD_AM2PM_MASK2__WRITE                                    0x000003ffU

#endif /* __PAPRD_AM2PM_MASK2_MACRO__ */


/* macros for bb_reg_map.bb_chn_reg_map.BB_paprd_am2pm_mask2 */
#define INST_BB_REG_MAP__BB_CHN_REG_MAP__BB_PAPRD_AM2PM_MASK2__NUM            1

/* macros for BlueprintGlobalNameSpace::paprd_ht40_mask2 */
#ifndef __PAPRD_HT40_MASK2_MACRO__
#define __PAPRD_HT40_MASK2_MACRO__

/* macros for field paprd_ht40_mask2 */
#define PAPRD_HT40_MASK2__PAPRD_HT40_MASK2__SHIFT                             0
#define PAPRD_HT40_MASK2__PAPRD_HT40_MASK2__WIDTH                            10
#define PAPRD_HT40_MASK2__PAPRD_HT40_MASK2__MASK                    0x000003ffU
#define PAPRD_HT40_MASK2__PAPRD_HT40_MASK2__READ(src) \
                    (u_int32_t)(src)\
                    & 0x000003ffU
#define PAPRD_HT40_MASK2__PAPRD_HT40_MASK2__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x000003ffU)
#define PAPRD_HT40_MASK2__PAPRD_HT40_MASK2__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000003ffU) | ((u_int32_t)(src) &\
                    0x000003ffU)
#define PAPRD_HT40_MASK2__PAPRD_HT40_MASK2__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x000003ffU)))
#define PAPRD_HT40_MASK2__TYPE                                        u_int32_t
#define PAPRD_HT40_MASK2__READ                                      0x000003ffU
#define PAPRD_HT40_MASK2__WRITE                                     0x000003ffU

#endif /* __PAPRD_HT40_MASK2_MACRO__ */


/* macros for bb_reg_map.bb_chn_reg_map.BB_paprd_ht40_mask2 */
#define INST_BB_REG_MAP__BB_CHN_REG_MAP__BB_PAPRD_HT40_MASK2__NUM             1

/* macros for BlueprintGlobalNameSpace::paprd_vht80_mask2 */
#ifndef __PAPRD_VHT80_MASK2_MACRO__
#define __PAPRD_VHT80_MASK2_MACRO__

/* macros for field paprd_vht80_mask2 */
#define PAPRD_VHT80_MASK2__PAPRD_VHT80_MASK2__SHIFT                           0
#define PAPRD_VHT80_MASK2__PAPRD_VHT80_MASK2__WIDTH                          10
#define PAPRD_VHT80_MASK2__PAPRD_VHT80_MASK2__MASK                  0x000003ffU
#define PAPRD_VHT80_MASK2__PAPRD_VHT80_MASK2__READ(src) \
                    (u_int32_t)(src)\
                    & 0x000003ffU
#define PAPRD_VHT80_MASK2__PAPRD_VHT80_MASK2__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x000003ffU)
#define PAPRD_VHT80_MASK2__PAPRD_VHT80_MASK2__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000003ffU) | ((u_int32_t)(src) &\
                    0x000003ffU)
#define PAPRD_VHT80_MASK2__PAPRD_VHT80_MASK2__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x000003ffU)))
#define PAPRD_VHT80_MASK2__TYPE                                       u_int32_t
#define PAPRD_VHT80_MASK2__READ                                     0x000003ffU
#define PAPRD_VHT80_MASK2__WRITE                                    0x000003ffU

#endif /* __PAPRD_VHT80_MASK2_MACRO__ */


/* macros for bb_reg_map.bb_chn_reg_map.BB_paprd_vht80_mask2 */
#define INST_BB_REG_MAP__BB_CHN_REG_MAP__BB_PAPRD_VHT80_MASK2__NUM            1

/* macros for BlueprintGlobalNameSpace::spur_ctrl1_pri_b0 */
#ifndef __SPUR_CTRL1_PRI_B0_MACRO__
#define __SPUR_CTRL1_PRI_B0_MACRO__

/* macros for field spur_delta_phase_pri_b0 */
#define SPUR_CTRL1_PRI_B0__SPUR_DELTA_PHASE_PRI_B0__SHIFT                     0
#define SPUR_CTRL1_PRI_B0__SPUR_DELTA_PHASE_PRI_B0__WIDTH                    20
#define SPUR_CTRL1_PRI_B0__SPUR_DELTA_PHASE_PRI_B0__MASK            0x000fffffU
#define SPUR_CTRL1_PRI_B0__SPUR_DELTA_PHASE_PRI_B0__READ(src) \
                    (u_int32_t)(src)\
                    & 0x000fffffU
#define SPUR_CTRL1_PRI_B0__SPUR_DELTA_PHASE_PRI_B0__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x000fffffU)
#define SPUR_CTRL1_PRI_B0__SPUR_DELTA_PHASE_PRI_B0__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000fffffU) | ((u_int32_t)(src) &\
                    0x000fffffU)
#define SPUR_CTRL1_PRI_B0__SPUR_DELTA_PHASE_PRI_B0__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x000fffffU)))

/* macros for field agc_ht_stf_spur_filter_ena_pri_b0 */
#define SPUR_CTRL1_PRI_B0__AGC_HT_STF_SPUR_FILTER_ENA_PRI_B0__SHIFT          29
#define SPUR_CTRL1_PRI_B0__AGC_HT_STF_SPUR_FILTER_ENA_PRI_B0__WIDTH           1
#define SPUR_CTRL1_PRI_B0__AGC_HT_STF_SPUR_FILTER_ENA_PRI_B0__MASK  0x20000000U
#define SPUR_CTRL1_PRI_B0__AGC_HT_STF_SPUR_FILTER_ENA_PRI_B0__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x20000000U) >> 29)
#define SPUR_CTRL1_PRI_B0__AGC_HT_STF_SPUR_FILTER_ENA_PRI_B0__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 29) & 0x20000000U)
#define SPUR_CTRL1_PRI_B0__AGC_HT_STF_SPUR_FILTER_ENA_PRI_B0__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x20000000U) | (((u_int32_t)(src) <<\
                    29) & 0x20000000U)
#define SPUR_CTRL1_PRI_B0__AGC_HT_STF_SPUR_FILTER_ENA_PRI_B0__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 29) & ~0x20000000U)))
#define SPUR_CTRL1_PRI_B0__AGC_HT_STF_SPUR_FILTER_ENA_PRI_B0__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x20000000U) | ((u_int32_t)(1) << 29)
#define SPUR_CTRL1_PRI_B0__AGC_HT_STF_SPUR_FILTER_ENA_PRI_B0__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x20000000U) | ((u_int32_t)(0) << 29)

/* macros for field enable_spur_filter_pri_b0 */
#define SPUR_CTRL1_PRI_B0__ENABLE_SPUR_FILTER_PRI_B0__SHIFT                  30
#define SPUR_CTRL1_PRI_B0__ENABLE_SPUR_FILTER_PRI_B0__WIDTH                   2
#define SPUR_CTRL1_PRI_B0__ENABLE_SPUR_FILTER_PRI_B0__MASK          0xc0000000U
#define SPUR_CTRL1_PRI_B0__ENABLE_SPUR_FILTER_PRI_B0__READ(src) \
                    (((u_int32_t)(src)\
                    & 0xc0000000U) >> 30)
#define SPUR_CTRL1_PRI_B0__ENABLE_SPUR_FILTER_PRI_B0__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 30) & 0xc0000000U)
#define SPUR_CTRL1_PRI_B0__ENABLE_SPUR_FILTER_PRI_B0__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xc0000000U) | (((u_int32_t)(src) <<\
                    30) & 0xc0000000U)
#define SPUR_CTRL1_PRI_B0__ENABLE_SPUR_FILTER_PRI_B0__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 30) & ~0xc0000000U)))
#define SPUR_CTRL1_PRI_B0__TYPE                                       u_int32_t
#define SPUR_CTRL1_PRI_B0__READ                                     0xe00fffffU
#define SPUR_CTRL1_PRI_B0__WRITE                                    0xe00fffffU

#endif /* __SPUR_CTRL1_PRI_B0_MACRO__ */


/* macros for bb_reg_map.bb_chn_reg_map.BB_spur_ctrl1_pri_b0 */
#define INST_BB_REG_MAP__BB_CHN_REG_MAP__BB_SPUR_CTRL1_PRI_B0__NUM            1

/* macros for BlueprintGlobalNameSpace::spur_ctrl2_pri_b0 */
#ifndef __SPUR_CTRL2_PRI_B0_MACRO__
#define __SPUR_CTRL2_PRI_B0_MACRO__

/* macros for field spur_delta_phase_2nd_pri_b0 */
#define SPUR_CTRL2_PRI_B0__SPUR_DELTA_PHASE_2ND_PRI_B0__SHIFT                 0
#define SPUR_CTRL2_PRI_B0__SPUR_DELTA_PHASE_2ND_PRI_B0__WIDTH                20
#define SPUR_CTRL2_PRI_B0__SPUR_DELTA_PHASE_2ND_PRI_B0__MASK        0x000fffffU
#define SPUR_CTRL2_PRI_B0__SPUR_DELTA_PHASE_2ND_PRI_B0__READ(src) \
                    (u_int32_t)(src)\
                    & 0x000fffffU
#define SPUR_CTRL2_PRI_B0__SPUR_DELTA_PHASE_2ND_PRI_B0__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x000fffffU)
#define SPUR_CTRL2_PRI_B0__SPUR_DELTA_PHASE_2ND_PRI_B0__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000fffffU) | ((u_int32_t)(src) &\
                    0x000fffffU)
#define SPUR_CTRL2_PRI_B0__SPUR_DELTA_PHASE_2ND_PRI_B0__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x000fffffU)))
#define SPUR_CTRL2_PRI_B0__TYPE                                       u_int32_t
#define SPUR_CTRL2_PRI_B0__READ                                     0x000fffffU
#define SPUR_CTRL2_PRI_B0__WRITE                                    0x000fffffU

#endif /* __SPUR_CTRL2_PRI_B0_MACRO__ */


/* macros for bb_reg_map.bb_chn_reg_map.BB_spur_ctrl2_pri_b0 */
#define INST_BB_REG_MAP__BB_CHN_REG_MAP__BB_SPUR_CTRL2_PRI_B0__NUM            1

/* macros for BlueprintGlobalNameSpace::spur_ctrl1_ext_b0 */
#ifndef __SPUR_CTRL1_EXT_B0_MACRO__
#define __SPUR_CTRL1_EXT_B0_MACRO__

/* macros for field spur_delta_phase_ext_b0 */
#define SPUR_CTRL1_EXT_B0__SPUR_DELTA_PHASE_EXT_B0__SHIFT                     0
#define SPUR_CTRL1_EXT_B0__SPUR_DELTA_PHASE_EXT_B0__WIDTH                    20
#define SPUR_CTRL1_EXT_B0__SPUR_DELTA_PHASE_EXT_B0__MASK            0x000fffffU
#define SPUR_CTRL1_EXT_B0__SPUR_DELTA_PHASE_EXT_B0__READ(src) \
                    (u_int32_t)(src)\
                    & 0x000fffffU
#define SPUR_CTRL1_EXT_B0__SPUR_DELTA_PHASE_EXT_B0__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x000fffffU)
#define SPUR_CTRL1_EXT_B0__SPUR_DELTA_PHASE_EXT_B0__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000fffffU) | ((u_int32_t)(src) &\
                    0x000fffffU)
#define SPUR_CTRL1_EXT_B0__SPUR_DELTA_PHASE_EXT_B0__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x000fffffU)))

/* macros for field agc_ht_stf_spur_filter_ena_ext_b0 */
#define SPUR_CTRL1_EXT_B0__AGC_HT_STF_SPUR_FILTER_ENA_EXT_B0__SHIFT          29
#define SPUR_CTRL1_EXT_B0__AGC_HT_STF_SPUR_FILTER_ENA_EXT_B0__WIDTH           1
#define SPUR_CTRL1_EXT_B0__AGC_HT_STF_SPUR_FILTER_ENA_EXT_B0__MASK  0x20000000U
#define SPUR_CTRL1_EXT_B0__AGC_HT_STF_SPUR_FILTER_ENA_EXT_B0__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x20000000U) >> 29)
#define SPUR_CTRL1_EXT_B0__AGC_HT_STF_SPUR_FILTER_ENA_EXT_B0__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 29) & 0x20000000U)
#define SPUR_CTRL1_EXT_B0__AGC_HT_STF_SPUR_FILTER_ENA_EXT_B0__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x20000000U) | (((u_int32_t)(src) <<\
                    29) & 0x20000000U)
#define SPUR_CTRL1_EXT_B0__AGC_HT_STF_SPUR_FILTER_ENA_EXT_B0__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 29) & ~0x20000000U)))
#define SPUR_CTRL1_EXT_B0__AGC_HT_STF_SPUR_FILTER_ENA_EXT_B0__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x20000000U) | ((u_int32_t)(1) << 29)
#define SPUR_CTRL1_EXT_B0__AGC_HT_STF_SPUR_FILTER_ENA_EXT_B0__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x20000000U) | ((u_int32_t)(0) << 29)

/* macros for field enable_spur_filter_ext_b0 */
#define SPUR_CTRL1_EXT_B0__ENABLE_SPUR_FILTER_EXT_B0__SHIFT                  30
#define SPUR_CTRL1_EXT_B0__ENABLE_SPUR_FILTER_EXT_B0__WIDTH                   2
#define SPUR_CTRL1_EXT_B0__ENABLE_SPUR_FILTER_EXT_B0__MASK          0xc0000000U
#define SPUR_CTRL1_EXT_B0__ENABLE_SPUR_FILTER_EXT_B0__READ(src) \
                    (((u_int32_t)(src)\
                    & 0xc0000000U) >> 30)
#define SPUR_CTRL1_EXT_B0__ENABLE_SPUR_FILTER_EXT_B0__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 30) & 0xc0000000U)
#define SPUR_CTRL1_EXT_B0__ENABLE_SPUR_FILTER_EXT_B0__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xc0000000U) | (((u_int32_t)(src) <<\
                    30) & 0xc0000000U)
#define SPUR_CTRL1_EXT_B0__ENABLE_SPUR_FILTER_EXT_B0__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 30) & ~0xc0000000U)))
#define SPUR_CTRL1_EXT_B0__TYPE                                       u_int32_t
#define SPUR_CTRL1_EXT_B0__READ                                     0xe00fffffU
#define SPUR_CTRL1_EXT_B0__WRITE                                    0xe00fffffU

#endif /* __SPUR_CTRL1_EXT_B0_MACRO__ */


/* macros for bb_reg_map.bb_chn_reg_map.BB_spur_ctrl1_ext_b0 */
#define INST_BB_REG_MAP__BB_CHN_REG_MAP__BB_SPUR_CTRL1_EXT_B0__NUM            1

/* macros for BlueprintGlobalNameSpace::spur_ctrl2_ext_b0 */
#ifndef __SPUR_CTRL2_EXT_B0_MACRO__
#define __SPUR_CTRL2_EXT_B0_MACRO__

/* macros for field spur_delta_phase_2nd_ext_b0 */
#define SPUR_CTRL2_EXT_B0__SPUR_DELTA_PHASE_2ND_EXT_B0__SHIFT                 0
#define SPUR_CTRL2_EXT_B0__SPUR_DELTA_PHASE_2ND_EXT_B0__WIDTH                20
#define SPUR_CTRL2_EXT_B0__SPUR_DELTA_PHASE_2ND_EXT_B0__MASK        0x000fffffU
#define SPUR_CTRL2_EXT_B0__SPUR_DELTA_PHASE_2ND_EXT_B0__READ(src) \
                    (u_int32_t)(src)\
                    & 0x000fffffU
#define SPUR_CTRL2_EXT_B0__SPUR_DELTA_PHASE_2ND_EXT_B0__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x000fffffU)
#define SPUR_CTRL2_EXT_B0__SPUR_DELTA_PHASE_2ND_EXT_B0__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000fffffU) | ((u_int32_t)(src) &\
                    0x000fffffU)
#define SPUR_CTRL2_EXT_B0__SPUR_DELTA_PHASE_2ND_EXT_B0__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x000fffffU)))
#define SPUR_CTRL2_EXT_B0__TYPE                                       u_int32_t
#define SPUR_CTRL2_EXT_B0__READ                                     0x000fffffU
#define SPUR_CTRL2_EXT_B0__WRITE                                    0x000fffffU

#endif /* __SPUR_CTRL2_EXT_B0_MACRO__ */


/* macros for bb_reg_map.bb_chn_reg_map.BB_spur_ctrl2_ext_b0 */
#define INST_BB_REG_MAP__BB_CHN_REG_MAP__BB_SPUR_CTRL2_EXT_B0__NUM            1

/* macros for BlueprintGlobalNameSpace::fdtg_ss3_data_b0 */
#ifndef __FDTG_SS3_DATA_B0_MACRO__
#define __FDTG_SS3_DATA_B0_MACRO__

/* macros for field fdtg_ss3_a_data_re_0 */
#define FDTG_SS3_DATA_B0__FDTG_SS3_A_DATA_RE_0__SHIFT                         0
#define FDTG_SS3_DATA_B0__FDTG_SS3_A_DATA_RE_0__WIDTH                         8
#define FDTG_SS3_DATA_B0__FDTG_SS3_A_DATA_RE_0__MASK                0x000000ffU
#define FDTG_SS3_DATA_B0__FDTG_SS3_A_DATA_RE_0__READ(src) \
                    (u_int32_t)(src)\
                    & 0x000000ffU
#define FDTG_SS3_DATA_B0__FDTG_SS3_A_DATA_RE_0__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x000000ffU)
#define FDTG_SS3_DATA_B0__FDTG_SS3_A_DATA_RE_0__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000000ffU) | ((u_int32_t)(src) &\
                    0x000000ffU)
#define FDTG_SS3_DATA_B0__FDTG_SS3_A_DATA_RE_0__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x000000ffU)))

/* macros for field fdtg_ss3_a_data_im_0 */
#define FDTG_SS3_DATA_B0__FDTG_SS3_A_DATA_IM_0__SHIFT                         8
#define FDTG_SS3_DATA_B0__FDTG_SS3_A_DATA_IM_0__WIDTH                         8
#define FDTG_SS3_DATA_B0__FDTG_SS3_A_DATA_IM_0__MASK                0x0000ff00U
#define FDTG_SS3_DATA_B0__FDTG_SS3_A_DATA_IM_0__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0000ff00U) >> 8)
#define FDTG_SS3_DATA_B0__FDTG_SS3_A_DATA_IM_0__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 8) & 0x0000ff00U)
#define FDTG_SS3_DATA_B0__FDTG_SS3_A_DATA_IM_0__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000ff00U) | (((u_int32_t)(src) <<\
                    8) & 0x0000ff00U)
#define FDTG_SS3_DATA_B0__FDTG_SS3_A_DATA_IM_0__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 8) & ~0x0000ff00U)))

/* macros for field fdtg_ss3_b_data_re_0 */
#define FDTG_SS3_DATA_B0__FDTG_SS3_B_DATA_RE_0__SHIFT                        16
#define FDTG_SS3_DATA_B0__FDTG_SS3_B_DATA_RE_0__WIDTH                         8
#define FDTG_SS3_DATA_B0__FDTG_SS3_B_DATA_RE_0__MASK                0x00ff0000U
#define FDTG_SS3_DATA_B0__FDTG_SS3_B_DATA_RE_0__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00ff0000U) >> 16)
#define FDTG_SS3_DATA_B0__FDTG_SS3_B_DATA_RE_0__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 16) & 0x00ff0000U)
#define FDTG_SS3_DATA_B0__FDTG_SS3_B_DATA_RE_0__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00ff0000U) | (((u_int32_t)(src) <<\
                    16) & 0x00ff0000U)
#define FDTG_SS3_DATA_B0__FDTG_SS3_B_DATA_RE_0__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 16) & ~0x00ff0000U)))

/* macros for field fdtg_ss3_b_data_im_0 */
#define FDTG_SS3_DATA_B0__FDTG_SS3_B_DATA_IM_0__SHIFT                        24
#define FDTG_SS3_DATA_B0__FDTG_SS3_B_DATA_IM_0__WIDTH                         8
#define FDTG_SS3_DATA_B0__FDTG_SS3_B_DATA_IM_0__MASK                0xff000000U
#define FDTG_SS3_DATA_B0__FDTG_SS3_B_DATA_IM_0__READ(src) \
                    (((u_int32_t)(src)\
                    & 0xff000000U) >> 24)
#define FDTG_SS3_DATA_B0__FDTG_SS3_B_DATA_IM_0__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 24) & 0xff000000U)
#define FDTG_SS3_DATA_B0__FDTG_SS3_B_DATA_IM_0__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xff000000U) | (((u_int32_t)(src) <<\
                    24) & 0xff000000U)
#define FDTG_SS3_DATA_B0__FDTG_SS3_B_DATA_IM_0__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 24) & ~0xff000000U)))
#define FDTG_SS3_DATA_B0__TYPE                                        u_int32_t
#define FDTG_SS3_DATA_B0__READ                                      0xffffffffU
#define FDTG_SS3_DATA_B0__WRITE                                     0xffffffffU

#endif /* __FDTG_SS3_DATA_B0_MACRO__ */


/* macros for bb_reg_map.bb_chn_reg_map.BB_fdtg_ss3_data_b0 */
#define INST_BB_REG_MAP__BB_CHN_REG_MAP__BB_FDTG_SS3_DATA_B0__NUM             1

/* macros for BlueprintGlobalNameSpace::fdtg_control2 */
#ifndef __FDTG_CONTROL2_MACRO__
#define __FDTG_CONTROL2_MACRO__

/* macros for field fdtg_ss3_a_addr */
#define FDTG_CONTROL2__FDTG_SS3_A_ADDR__SHIFT                                 0
#define FDTG_CONTROL2__FDTG_SS3_A_ADDR__WIDTH                                 8
#define FDTG_CONTROL2__FDTG_SS3_A_ADDR__MASK                        0x000000ffU
#define FDTG_CONTROL2__FDTG_SS3_A_ADDR__READ(src) \
                    (u_int32_t)(src)\
                    & 0x000000ffU
#define FDTG_CONTROL2__FDTG_SS3_A_ADDR__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x000000ffU)
#define FDTG_CONTROL2__FDTG_SS3_A_ADDR__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000000ffU) | ((u_int32_t)(src) &\
                    0x000000ffU)
#define FDTG_CONTROL2__FDTG_SS3_A_ADDR__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x000000ffU)))

/* macros for field fdtg_ss3_b_addr */
#define FDTG_CONTROL2__FDTG_SS3_B_ADDR__SHIFT                                 8
#define FDTG_CONTROL2__FDTG_SS3_B_ADDR__WIDTH                                 8
#define FDTG_CONTROL2__FDTG_SS3_B_ADDR__MASK                        0x0000ff00U
#define FDTG_CONTROL2__FDTG_SS3_B_ADDR__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0000ff00U) >> 8)
#define FDTG_CONTROL2__FDTG_SS3_B_ADDR__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 8) & 0x0000ff00U)
#define FDTG_CONTROL2__FDTG_SS3_B_ADDR__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000ff00U) | (((u_int32_t)(src) <<\
                    8) & 0x0000ff00U)
#define FDTG_CONTROL2__FDTG_SS3_B_ADDR__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 8) & ~0x0000ff00U)))
#define FDTG_CONTROL2__TYPE                                           u_int32_t
#define FDTG_CONTROL2__READ                                         0x0000ffffU
#define FDTG_CONTROL2__WRITE                                        0x0000ffffU

#endif /* __FDTG_CONTROL2_MACRO__ */


/* macros for bb_reg_map.bb_chn_reg_map.BB_fdtg_control2 */
#define INST_BB_REG_MAP__BB_CHN_REG_MAP__BB_FDTG_CONTROL2__NUM                1

/* macros for BlueprintGlobalNameSpace::pdc_a1_0_m0 */
#ifndef __PDC_A1_0_M0_MACRO__
#define __PDC_A1_0_M0_MACRO__

/* macros for field pdc_a1_0_m0 */
#define PDC_A1_0_M0__PDC_A1_0_M0__SHIFT                                       0
#define PDC_A1_0_M0__PDC_A1_0_M0__WIDTH                                      18
#define PDC_A1_0_M0__PDC_A1_0_M0__MASK                              0x0003ffffU
#define PDC_A1_0_M0__PDC_A1_0_M0__READ(src)      (u_int32_t)(src) & 0x0003ffffU
#define PDC_A1_0_M0__PDC_A1_0_M0__WRITE(src)   ((u_int32_t)(src) & 0x0003ffffU)
#define PDC_A1_0_M0__PDC_A1_0_M0__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0003ffffU) | ((u_int32_t)(src) &\
                    0x0003ffffU)
#define PDC_A1_0_M0__PDC_A1_0_M0__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x0003ffffU)))
#define PDC_A1_0_M0__TYPE                                             u_int32_t
#define PDC_A1_0_M0__READ                                           0x0003ffffU
#define PDC_A1_0_M0__WRITE                                          0x0003ffffU

#endif /* __PDC_A1_0_M0_MACRO__ */


/* macros for bb_reg_map.bb_chn_reg_map.BB_pdc_a1_0_m0 */
#define INST_BB_REG_MAP__BB_CHN_REG_MAP__BB_PDC_A1_0_M0__NUM                  1

/* macros for BlueprintGlobalNameSpace::pdc_b1_0_m0 */
#ifndef __PDC_B1_0_M0_MACRO__
#define __PDC_B1_0_M0_MACRO__

/* macros for field pdc_b1_0_m0 */
#define PDC_B1_0_M0__PDC_B1_0_M0__SHIFT                                       0
#define PDC_B1_0_M0__PDC_B1_0_M0__WIDTH                                      18
#define PDC_B1_0_M0__PDC_B1_0_M0__MASK                              0x0003ffffU
#define PDC_B1_0_M0__PDC_B1_0_M0__READ(src)      (u_int32_t)(src) & 0x0003ffffU
#define PDC_B1_0_M0__PDC_B1_0_M0__WRITE(src)   ((u_int32_t)(src) & 0x0003ffffU)
#define PDC_B1_0_M0__PDC_B1_0_M0__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0003ffffU) | ((u_int32_t)(src) &\
                    0x0003ffffU)
#define PDC_B1_0_M0__PDC_B1_0_M0__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x0003ffffU)))
#define PDC_B1_0_M0__TYPE                                             u_int32_t
#define PDC_B1_0_M0__READ                                           0x0003ffffU
#define PDC_B1_0_M0__WRITE                                          0x0003ffffU

#endif /* __PDC_B1_0_M0_MACRO__ */


/* macros for bb_reg_map.bb_chn_reg_map.BB_pdc_b1_0_m0 */
#define INST_BB_REG_MAP__BB_CHN_REG_MAP__BB_PDC_B1_0_M0__NUM                  1

/* macros for BlueprintGlobalNameSpace::pdc_b2_0_m0 */
#ifndef __PDC_B2_0_M0_MACRO__
#define __PDC_B2_0_M0_MACRO__

/* macros for field pdc_b2_0_m0 */
#define PDC_B2_0_M0__PDC_B2_0_M0__SHIFT                                       0
#define PDC_B2_0_M0__PDC_B2_0_M0__WIDTH                                      18
#define PDC_B2_0_M0__PDC_B2_0_M0__MASK                              0x0003ffffU
#define PDC_B2_0_M0__PDC_B2_0_M0__READ(src)      (u_int32_t)(src) & 0x0003ffffU
#define PDC_B2_0_M0__PDC_B2_0_M0__WRITE(src)   ((u_int32_t)(src) & 0x0003ffffU)
#define PDC_B2_0_M0__PDC_B2_0_M0__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0003ffffU) | ((u_int32_t)(src) &\
                    0x0003ffffU)
#define PDC_B2_0_M0__PDC_B2_0_M0__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x0003ffffU)))
#define PDC_B2_0_M0__TYPE                                             u_int32_t
#define PDC_B2_0_M0__READ                                           0x0003ffffU
#define PDC_B2_0_M0__WRITE                                          0x0003ffffU

#endif /* __PDC_B2_0_M0_MACRO__ */


/* macros for bb_reg_map.bb_chn_reg_map.BB_pdc_b2_0_m0 */
#define INST_BB_REG_MAP__BB_CHN_REG_MAP__BB_PDC_B2_0_M0__NUM                  1

/* macros for BlueprintGlobalNameSpace::pdc_a1_0_m1 */
#ifndef __PDC_A1_0_M1_MACRO__
#define __PDC_A1_0_M1_MACRO__

/* macros for field pdc_a1_0_m1 */
#define PDC_A1_0_M1__PDC_A1_0_M1__SHIFT                                       0
#define PDC_A1_0_M1__PDC_A1_0_M1__WIDTH                                      18
#define PDC_A1_0_M1__PDC_A1_0_M1__MASK                              0x0003ffffU
#define PDC_A1_0_M1__PDC_A1_0_M1__READ(src)      (u_int32_t)(src) & 0x0003ffffU
#define PDC_A1_0_M1__PDC_A1_0_M1__WRITE(src)   ((u_int32_t)(src) & 0x0003ffffU)
#define PDC_A1_0_M1__PDC_A1_0_M1__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0003ffffU) | ((u_int32_t)(src) &\
                    0x0003ffffU)
#define PDC_A1_0_M1__PDC_A1_0_M1__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x0003ffffU)))
#define PDC_A1_0_M1__TYPE                                             u_int32_t
#define PDC_A1_0_M1__READ                                           0x0003ffffU
#define PDC_A1_0_M1__WRITE                                          0x0003ffffU

#endif /* __PDC_A1_0_M1_MACRO__ */


/* macros for bb_reg_map.bb_chn_reg_map.BB_pdc_a1_0_m1 */
#define INST_BB_REG_MAP__BB_CHN_REG_MAP__BB_PDC_A1_0_M1__NUM                  1

/* macros for BlueprintGlobalNameSpace::pdc_b1_0_m1 */
#ifndef __PDC_B1_0_M1_MACRO__
#define __PDC_B1_0_M1_MACRO__

/* macros for field pdc_b1_0_m1 */
#define PDC_B1_0_M1__PDC_B1_0_M1__SHIFT                                       0
#define PDC_B1_0_M1__PDC_B1_0_M1__WIDTH                                      18
#define PDC_B1_0_M1__PDC_B1_0_M1__MASK                              0x0003ffffU
#define PDC_B1_0_M1__PDC_B1_0_M1__READ(src)      (u_int32_t)(src) & 0x0003ffffU
#define PDC_B1_0_M1__PDC_B1_0_M1__WRITE(src)   ((u_int32_t)(src) & 0x0003ffffU)
#define PDC_B1_0_M1__PDC_B1_0_M1__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0003ffffU) | ((u_int32_t)(src) &\
                    0x0003ffffU)
#define PDC_B1_0_M1__PDC_B1_0_M1__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x0003ffffU)))
#define PDC_B1_0_M1__TYPE                                             u_int32_t
#define PDC_B1_0_M1__READ                                           0x0003ffffU
#define PDC_B1_0_M1__WRITE                                          0x0003ffffU

#endif /* __PDC_B1_0_M1_MACRO__ */


/* macros for bb_reg_map.bb_chn_reg_map.BB_pdc_b1_0_m1 */
#define INST_BB_REG_MAP__BB_CHN_REG_MAP__BB_PDC_B1_0_M1__NUM                  1

/* macros for BlueprintGlobalNameSpace::pdc_b2_0_m1 */
#ifndef __PDC_B2_0_M1_MACRO__
#define __PDC_B2_0_M1_MACRO__

/* macros for field pdc_b2_0_m1 */
#define PDC_B2_0_M1__PDC_B2_0_M1__SHIFT                                       0
#define PDC_B2_0_M1__PDC_B2_0_M1__WIDTH                                      18
#define PDC_B2_0_M1__PDC_B2_0_M1__MASK                              0x0003ffffU
#define PDC_B2_0_M1__PDC_B2_0_M1__READ(src)      (u_int32_t)(src) & 0x0003ffffU
#define PDC_B2_0_M1__PDC_B2_0_M1__WRITE(src)   ((u_int32_t)(src) & 0x0003ffffU)
#define PDC_B2_0_M1__PDC_B2_0_M1__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0003ffffU) | ((u_int32_t)(src) &\
                    0x0003ffffU)
#define PDC_B2_0_M1__PDC_B2_0_M1__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x0003ffffU)))
#define PDC_B2_0_M1__TYPE                                             u_int32_t
#define PDC_B2_0_M1__READ                                           0x0003ffffU
#define PDC_B2_0_M1__WRITE                                          0x0003ffffU

#endif /* __PDC_B2_0_M1_MACRO__ */


/* macros for bb_reg_map.bb_chn_reg_map.BB_pdc_b2_0_m1 */
#define INST_BB_REG_MAP__BB_CHN_REG_MAP__BB_PDC_B2_0_M1__NUM                  1

/* macros for BlueprintGlobalNameSpace::pdc_a1_0_m2 */
#ifndef __PDC_A1_0_M2_MACRO__
#define __PDC_A1_0_M2_MACRO__

/* macros for field pdc_a1_0_m2 */
#define PDC_A1_0_M2__PDC_A1_0_M2__SHIFT                                       0
#define PDC_A1_0_M2__PDC_A1_0_M2__WIDTH                                      18
#define PDC_A1_0_M2__PDC_A1_0_M2__MASK                              0x0003ffffU
#define PDC_A1_0_M2__PDC_A1_0_M2__READ(src)      (u_int32_t)(src) & 0x0003ffffU
#define PDC_A1_0_M2__PDC_A1_0_M2__WRITE(src)   ((u_int32_t)(src) & 0x0003ffffU)
#define PDC_A1_0_M2__PDC_A1_0_M2__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0003ffffU) | ((u_int32_t)(src) &\
                    0x0003ffffU)
#define PDC_A1_0_M2__PDC_A1_0_M2__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x0003ffffU)))
#define PDC_A1_0_M2__TYPE                                             u_int32_t
#define PDC_A1_0_M2__READ                                           0x0003ffffU
#define PDC_A1_0_M2__WRITE                                          0x0003ffffU

#endif /* __PDC_A1_0_M2_MACRO__ */


/* macros for bb_reg_map.bb_chn_reg_map.BB_pdc_a1_0_m2 */
#define INST_BB_REG_MAP__BB_CHN_REG_MAP__BB_PDC_A1_0_M2__NUM                  1

/* macros for BlueprintGlobalNameSpace::pdc_b1_0_m2 */
#ifndef __PDC_B1_0_M2_MACRO__
#define __PDC_B1_0_M2_MACRO__

/* macros for field pdc_b1_0_m2 */
#define PDC_B1_0_M2__PDC_B1_0_M2__SHIFT                                       0
#define PDC_B1_0_M2__PDC_B1_0_M2__WIDTH                                      18
#define PDC_B1_0_M2__PDC_B1_0_M2__MASK                              0x0003ffffU
#define PDC_B1_0_M2__PDC_B1_0_M2__READ(src)      (u_int32_t)(src) & 0x0003ffffU
#define PDC_B1_0_M2__PDC_B1_0_M2__WRITE(src)   ((u_int32_t)(src) & 0x0003ffffU)
#define PDC_B1_0_M2__PDC_B1_0_M2__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0003ffffU) | ((u_int32_t)(src) &\
                    0x0003ffffU)
#define PDC_B1_0_M2__PDC_B1_0_M2__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x0003ffffU)))
#define PDC_B1_0_M2__TYPE                                             u_int32_t
#define PDC_B1_0_M2__READ                                           0x0003ffffU
#define PDC_B1_0_M2__WRITE                                          0x0003ffffU

#endif /* __PDC_B1_0_M2_MACRO__ */


/* macros for bb_reg_map.bb_chn_reg_map.BB_pdc_b1_0_m2 */
#define INST_BB_REG_MAP__BB_CHN_REG_MAP__BB_PDC_B1_0_M2__NUM                  1

/* macros for BlueprintGlobalNameSpace::pdc_b2_0_m2 */
#ifndef __PDC_B2_0_M2_MACRO__
#define __PDC_B2_0_M2_MACRO__

/* macros for field pdc_b2_0_m2 */
#define PDC_B2_0_M2__PDC_B2_0_M2__SHIFT                                       0
#define PDC_B2_0_M2__PDC_B2_0_M2__WIDTH                                      18
#define PDC_B2_0_M2__PDC_B2_0_M2__MASK                              0x0003ffffU
#define PDC_B2_0_M2__PDC_B2_0_M2__READ(src)      (u_int32_t)(src) & 0x0003ffffU
#define PDC_B2_0_M2__PDC_B2_0_M2__WRITE(src)   ((u_int32_t)(src) & 0x0003ffffU)
#define PDC_B2_0_M2__PDC_B2_0_M2__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0003ffffU) | ((u_int32_t)(src) &\
                    0x0003ffffU)
#define PDC_B2_0_M2__PDC_B2_0_M2__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x0003ffffU)))
#define PDC_B2_0_M2__TYPE                                             u_int32_t
#define PDC_B2_0_M2__READ                                           0x0003ffffU
#define PDC_B2_0_M2__WRITE                                          0x0003ffffU

#endif /* __PDC_B2_0_M2_MACRO__ */


/* macros for bb_reg_map.bb_chn_reg_map.BB_pdc_b2_0_m2 */
#define INST_BB_REG_MAP__BB_CHN_REG_MAP__BB_PDC_B2_0_M2__NUM                  1

/* macros for BlueprintGlobalNameSpace::pdc_step_p1_0 */
#ifndef __PDC_STEP_P1_0_MACRO__
#define __PDC_STEP_P1_0_MACRO__

/* macros for field pdc_step_p1_0 */
#define PDC_STEP_P1_0__PDC_STEP_P1_0__SHIFT                                   0
#define PDC_STEP_P1_0__PDC_STEP_P1_0__WIDTH                                  32
#define PDC_STEP_P1_0__PDC_STEP_P1_0__MASK                          0xffffffffU
#define PDC_STEP_P1_0__PDC_STEP_P1_0__READ(src)  (u_int32_t)(src) & 0xffffffffU
#define PDC_STEP_P1_0__PDC_STEP_P1_0__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0xffffffffU)
#define PDC_STEP_P1_0__PDC_STEP_P1_0__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xffffffffU) | ((u_int32_t)(src) &\
                    0xffffffffU)
#define PDC_STEP_P1_0__PDC_STEP_P1_0__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0xffffffffU)))
#define PDC_STEP_P1_0__TYPE                                           u_int32_t
#define PDC_STEP_P1_0__READ                                         0xffffffffU
#define PDC_STEP_P1_0__WRITE                                        0xffffffffU

#endif /* __PDC_STEP_P1_0_MACRO__ */


/* macros for bb_reg_map.bb_chn_reg_map.BB_pdc_step_p1_0 */
#define INST_BB_REG_MAP__BB_CHN_REG_MAP__BB_PDC_STEP_P1_0__NUM                1

/* macros for BlueprintGlobalNameSpace::pdc_step_p2_0 */
#ifndef __PDC_STEP_P2_0_MACRO__
#define __PDC_STEP_P2_0_MACRO__

/* macros for field pdc_step_p2_0 */
#define PDC_STEP_P2_0__PDC_STEP_P2_0__SHIFT                                   0
#define PDC_STEP_P2_0__PDC_STEP_P2_0__WIDTH                                  32
#define PDC_STEP_P2_0__PDC_STEP_P2_0__MASK                          0xffffffffU
#define PDC_STEP_P2_0__PDC_STEP_P2_0__READ(src)  (u_int32_t)(src) & 0xffffffffU
#define PDC_STEP_P2_0__PDC_STEP_P2_0__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0xffffffffU)
#define PDC_STEP_P2_0__PDC_STEP_P2_0__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xffffffffU) | ((u_int32_t)(src) &\
                    0xffffffffU)
#define PDC_STEP_P2_0__PDC_STEP_P2_0__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0xffffffffU)))
#define PDC_STEP_P2_0__TYPE                                           u_int32_t
#define PDC_STEP_P2_0__READ                                         0xffffffffU
#define PDC_STEP_P2_0__WRITE                                        0xffffffffU

#endif /* __PDC_STEP_P2_0_MACRO__ */


/* macros for bb_reg_map.bb_chn_reg_map.BB_pdc_step_p2_0 */
#define INST_BB_REG_MAP__BB_CHN_REG_MAP__BB_PDC_STEP_P2_0__NUM                1

/* macros for BlueprintGlobalNameSpace::pdc_gap_time_0 */
#ifndef __PDC_GAP_TIME_0_MACRO__
#define __PDC_GAP_TIME_0_MACRO__

/* macros for field pdc_gap_time_0 */
#define PDC_GAP_TIME_0__PDC_GAP_TIME_0__SHIFT                                 0
#define PDC_GAP_TIME_0__PDC_GAP_TIME_0__WIDTH                                32
#define PDC_GAP_TIME_0__PDC_GAP_TIME_0__MASK                        0xffffffffU
#define PDC_GAP_TIME_0__PDC_GAP_TIME_0__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define PDC_GAP_TIME_0__TYPE                                          u_int32_t
#define PDC_GAP_TIME_0__READ                                        0xffffffffU

#endif /* __PDC_GAP_TIME_0_MACRO__ */


/* macros for bb_reg_map.bb_chn_reg_map.BB_pdc_gap_time_0 */
#define INST_BB_REG_MAP__BB_CHN_REG_MAP__BB_PDC_GAP_TIME_0__NUM               1

/* macros for BlueprintGlobalNameSpace::pdc_time_0 */
#ifndef __PDC_TIME_0_MACRO__
#define __PDC_TIME_0_MACRO__

/* macros for field pdc_time_0 */
#define PDC_TIME_0__PDC_TIME_0__SHIFT                                         0
#define PDC_TIME_0__PDC_TIME_0__WIDTH                                        32
#define PDC_TIME_0__PDC_TIME_0__MASK                                0xffffffffU
#define PDC_TIME_0__PDC_TIME_0__READ(src)        (u_int32_t)(src) & 0xffffffffU
#define PDC_TIME_0__TYPE                                              u_int32_t
#define PDC_TIME_0__READ                                            0xffffffffU

#endif /* __PDC_TIME_0_MACRO__ */


/* macros for bb_reg_map.bb_chn_reg_map.BB_pdc_time_0 */
#define INST_BB_REG_MAP__BB_CHN_REG_MAP__BB_PDC_TIME_0__NUM                   1

/* macros for BlueprintGlobalNameSpace::pdc_disable */
#ifndef __PDC_DISABLE_MACRO__
#define __PDC_DISABLE_MACRO__

/* macros for field pdc_disable */
#define PDC_DISABLE__PDC_DISABLE__SHIFT                                       0
#define PDC_DISABLE__PDC_DISABLE__WIDTH                                       1
#define PDC_DISABLE__PDC_DISABLE__MASK                              0x00000001U
#define PDC_DISABLE__PDC_DISABLE__READ(src)      (u_int32_t)(src) & 0x00000001U
#define PDC_DISABLE__PDC_DISABLE__WRITE(src)   ((u_int32_t)(src) & 0x00000001U)
#define PDC_DISABLE__PDC_DISABLE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | ((u_int32_t)(src) &\
                    0x00000001U)
#define PDC_DISABLE__PDC_DISABLE__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00000001U)))
#define PDC_DISABLE__PDC_DISABLE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(1)
#define PDC_DISABLE__PDC_DISABLE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(0)
#define PDC_DISABLE__TYPE                                             u_int32_t
#define PDC_DISABLE__READ                                           0x00000001U
#define PDC_DISABLE__WRITE                                          0x00000001U

#endif /* __PDC_DISABLE_MACRO__ */


/* macros for bb_reg_map.bb_chn_reg_map.BB_pdc_disable */
#define INST_BB_REG_MAP__BB_CHN_REG_MAP__BB_PDC_DISABLE__NUM                  1

/* macros for BlueprintGlobalNameSpace::pdc_num_p1_max */
#ifndef __PDC_NUM_P1_MAX_MACRO__
#define __PDC_NUM_P1_MAX_MACRO__

/* macros for field pdc_num_p1_max */
#define PDC_NUM_P1_MAX__PDC_NUM_P1_MAX__SHIFT                                 0
#define PDC_NUM_P1_MAX__PDC_NUM_P1_MAX__WIDTH                                 8
#define PDC_NUM_P1_MAX__PDC_NUM_P1_MAX__MASK                        0x000000ffU
#define PDC_NUM_P1_MAX__PDC_NUM_P1_MAX__READ(src) \
                    (u_int32_t)(src)\
                    & 0x000000ffU
#define PDC_NUM_P1_MAX__PDC_NUM_P1_MAX__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x000000ffU)
#define PDC_NUM_P1_MAX__PDC_NUM_P1_MAX__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000000ffU) | ((u_int32_t)(src) &\
                    0x000000ffU)
#define PDC_NUM_P1_MAX__PDC_NUM_P1_MAX__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x000000ffU)))
#define PDC_NUM_P1_MAX__TYPE                                          u_int32_t
#define PDC_NUM_P1_MAX__READ                                        0x000000ffU
#define PDC_NUM_P1_MAX__WRITE                                       0x000000ffU

#endif /* __PDC_NUM_P1_MAX_MACRO__ */


/* macros for bb_reg_map.bb_chn_reg_map.BB_pdc_num_p1_max */
#define INST_BB_REG_MAP__BB_CHN_REG_MAP__BB_PDC_NUM_P1_MAX__NUM               1

/* macros for BlueprintGlobalNameSpace::pdc_num_p2_max */
#ifndef __PDC_NUM_P2_MAX_MACRO__
#define __PDC_NUM_P2_MAX_MACRO__

/* macros for field pdc_num_p2_max */
#define PDC_NUM_P2_MAX__PDC_NUM_P2_MAX__SHIFT                                 0
#define PDC_NUM_P2_MAX__PDC_NUM_P2_MAX__WIDTH                                 8
#define PDC_NUM_P2_MAX__PDC_NUM_P2_MAX__MASK                        0x000000ffU
#define PDC_NUM_P2_MAX__PDC_NUM_P2_MAX__READ(src) \
                    (u_int32_t)(src)\
                    & 0x000000ffU
#define PDC_NUM_P2_MAX__PDC_NUM_P2_MAX__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x000000ffU)
#define PDC_NUM_P2_MAX__PDC_NUM_P2_MAX__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000000ffU) | ((u_int32_t)(src) &\
                    0x000000ffU)
#define PDC_NUM_P2_MAX__PDC_NUM_P2_MAX__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x000000ffU)))
#define PDC_NUM_P2_MAX__TYPE                                          u_int32_t
#define PDC_NUM_P2_MAX__READ                                        0x000000ffU
#define PDC_NUM_P2_MAX__WRITE                                       0x000000ffU

#endif /* __PDC_NUM_P2_MAX_MACRO__ */


/* macros for bb_reg_map.bb_chn_reg_map.BB_pdc_num_p2_max */
#define INST_BB_REG_MAP__BB_CHN_REG_MAP__BB_PDC_NUM_P2_MAX__NUM               1

/* macros for BlueprintGlobalNameSpace::pdc_gap_th1 */
#ifndef __PDC_GAP_TH1_MACRO__
#define __PDC_GAP_TH1_MACRO__

/* macros for field pdc_gap_th1 */
#define PDC_GAP_TH1__PDC_GAP_TH1__SHIFT                                       0
#define PDC_GAP_TH1__PDC_GAP_TH1__WIDTH                                      32
#define PDC_GAP_TH1__PDC_GAP_TH1__MASK                              0xffffffffU
#define PDC_GAP_TH1__PDC_GAP_TH1__READ(src)      (u_int32_t)(src) & 0xffffffffU
#define PDC_GAP_TH1__PDC_GAP_TH1__WRITE(src)   ((u_int32_t)(src) & 0xffffffffU)
#define PDC_GAP_TH1__PDC_GAP_TH1__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xffffffffU) | ((u_int32_t)(src) &\
                    0xffffffffU)
#define PDC_GAP_TH1__PDC_GAP_TH1__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0xffffffffU)))
#define PDC_GAP_TH1__TYPE                                             u_int32_t
#define PDC_GAP_TH1__READ                                           0xffffffffU
#define PDC_GAP_TH1__WRITE                                          0xffffffffU

#endif /* __PDC_GAP_TH1_MACRO__ */


/* macros for bb_reg_map.bb_chn_reg_map.BB_pdc_gap_th1 */
#define INST_BB_REG_MAP__BB_CHN_REG_MAP__BB_PDC_GAP_TH1__NUM                  1

/* macros for BlueprintGlobalNameSpace::pdc_gap_th2 */
#ifndef __PDC_GAP_TH2_MACRO__
#define __PDC_GAP_TH2_MACRO__

/* macros for field pdc_gap_th2 */
#define PDC_GAP_TH2__PDC_GAP_TH2__SHIFT                                       0
#define PDC_GAP_TH2__PDC_GAP_TH2__WIDTH                                      32
#define PDC_GAP_TH2__PDC_GAP_TH2__MASK                              0xffffffffU
#define PDC_GAP_TH2__PDC_GAP_TH2__READ(src)      (u_int32_t)(src) & 0xffffffffU
#define PDC_GAP_TH2__PDC_GAP_TH2__WRITE(src)   ((u_int32_t)(src) & 0xffffffffU)
#define PDC_GAP_TH2__PDC_GAP_TH2__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xffffffffU) | ((u_int32_t)(src) &\
                    0xffffffffU)
#define PDC_GAP_TH2__PDC_GAP_TH2__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0xffffffffU)))
#define PDC_GAP_TH2__TYPE                                             u_int32_t
#define PDC_GAP_TH2__READ                                           0xffffffffU
#define PDC_GAP_TH2__WRITE                                          0xffffffffU

#endif /* __PDC_GAP_TH2_MACRO__ */


/* macros for bb_reg_map.bb_chn_reg_map.BB_pdc_gap_th2 */
#define INST_BB_REG_MAP__BB_CHN_REG_MAP__BB_PDC_GAP_TH2__NUM                  1

/* macros for BlueprintGlobalNameSpace::pdc_dly_tl */
#ifndef __PDC_DLY_TL_MACRO__
#define __PDC_DLY_TL_MACRO__

/* macros for field pdc_dly_tl */
#define PDC_DLY_TL__PDC_DLY_TL__SHIFT                                         0
#define PDC_DLY_TL__PDC_DLY_TL__WIDTH                                        32
#define PDC_DLY_TL__PDC_DLY_TL__MASK                                0xffffffffU
#define PDC_DLY_TL__PDC_DLY_TL__READ(src)        (u_int32_t)(src) & 0xffffffffU
#define PDC_DLY_TL__PDC_DLY_TL__WRITE(src)     ((u_int32_t)(src) & 0xffffffffU)
#define PDC_DLY_TL__PDC_DLY_TL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xffffffffU) | ((u_int32_t)(src) &\
                    0xffffffffU)
#define PDC_DLY_TL__PDC_DLY_TL__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0xffffffffU)))
#define PDC_DLY_TL__TYPE                                              u_int32_t
#define PDC_DLY_TL__READ                                            0xffffffffU
#define PDC_DLY_TL__WRITE                                           0xffffffffU

#endif /* __PDC_DLY_TL_MACRO__ */


/* macros for bb_reg_map.bb_chn_reg_map.BB_pdc_dly_tl */
#define INST_BB_REG_MAP__BB_CHN_REG_MAP__BB_PDC_DLY_TL__NUM                   1

/* macros for BlueprintGlobalNameSpace::pdc_gap_tl */
#ifndef __PDC_GAP_TL_MACRO__
#define __PDC_GAP_TL_MACRO__

/* macros for field pdc_gap_tl */
#define PDC_GAP_TL__PDC_GAP_TL__SHIFT                                         0
#define PDC_GAP_TL__PDC_GAP_TL__WIDTH                                        32
#define PDC_GAP_TL__PDC_GAP_TL__MASK                                0xffffffffU
#define PDC_GAP_TL__PDC_GAP_TL__READ(src)        (u_int32_t)(src) & 0xffffffffU
#define PDC_GAP_TL__PDC_GAP_TL__WRITE(src)     ((u_int32_t)(src) & 0xffffffffU)
#define PDC_GAP_TL__PDC_GAP_TL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xffffffffU) | ((u_int32_t)(src) &\
                    0xffffffffU)
#define PDC_GAP_TL__PDC_GAP_TL__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0xffffffffU)))
#define PDC_GAP_TL__TYPE                                              u_int32_t
#define PDC_GAP_TL__READ                                            0xffffffffU
#define PDC_GAP_TL__WRITE                                           0xffffffffU

#endif /* __PDC_GAP_TL_MACRO__ */


/* macros for bb_reg_map.bb_chn_reg_map.BB_pdc_gap_tl */
#define INST_BB_REG_MAP__BB_CHN_REG_MAP__BB_PDC_GAP_TL__NUM                   1

/* macros for BlueprintGlobalNameSpace::pdc_tl */
#ifndef __PDC_TL_MACRO__
#define __PDC_TL_MACRO__

/* macros for field pdc_tl */
#define PDC_TL__PDC_TL__SHIFT                                                 0
#define PDC_TL__PDC_TL__WIDTH                                                32
#define PDC_TL__PDC_TL__MASK                                        0xffffffffU
#define PDC_TL__PDC_TL__READ(src)                (u_int32_t)(src) & 0xffffffffU
#define PDC_TL__PDC_TL__WRITE(src)             ((u_int32_t)(src) & 0xffffffffU)
#define PDC_TL__PDC_TL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xffffffffU) | ((u_int32_t)(src) &\
                    0xffffffffU)
#define PDC_TL__PDC_TL__VERIFY(src)      (!(((u_int32_t)(src) & ~0xffffffffU)))
#define PDC_TL__TYPE                                                  u_int32_t
#define PDC_TL__READ                                                0xffffffffU
#define PDC_TL__WRITE                                               0xffffffffU

#endif /* __PDC_TL_MACRO__ */


/* macros for bb_reg_map.bb_chn_reg_map.BB_pdc_tl */
#define INST_BB_REG_MAP__BB_CHN_REG_MAP__BB_PDC_TL__NUM                       1

/* macros for BlueprintGlobalNameSpace::pdc_num_step_p1 */
#ifndef __PDC_NUM_STEP_P1_MACRO__
#define __PDC_NUM_STEP_P1_MACRO__

/* macros for field pdc_num_step_p1 */
#define PDC_NUM_STEP_P1__PDC_NUM_STEP_P1__SHIFT                               0
#define PDC_NUM_STEP_P1__PDC_NUM_STEP_P1__WIDTH                               8
#define PDC_NUM_STEP_P1__PDC_NUM_STEP_P1__MASK                      0x000000ffU
#define PDC_NUM_STEP_P1__PDC_NUM_STEP_P1__READ(src) \
                    (u_int32_t)(src)\
                    & 0x000000ffU
#define PDC_NUM_STEP_P1__PDC_NUM_STEP_P1__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x000000ffU)
#define PDC_NUM_STEP_P1__PDC_NUM_STEP_P1__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000000ffU) | ((u_int32_t)(src) &\
                    0x000000ffU)
#define PDC_NUM_STEP_P1__PDC_NUM_STEP_P1__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x000000ffU)))
#define PDC_NUM_STEP_P1__TYPE                                         u_int32_t
#define PDC_NUM_STEP_P1__READ                                       0x000000ffU
#define PDC_NUM_STEP_P1__WRITE                                      0x000000ffU

#endif /* __PDC_NUM_STEP_P1_MACRO__ */


/* macros for bb_reg_map.bb_chn_reg_map.BB_pdc_num_step_p1 */
#define INST_BB_REG_MAP__BB_CHN_REG_MAP__BB_PDC_NUM_STEP_P1__NUM              1

/* macros for BlueprintGlobalNameSpace::gen_controls */
#ifndef __GEN_CONTROLS_MACRO__
#define __GEN_CONTROLS_MACRO__

/* macros for field dyn_bw */
#define GEN_CONTROLS__DYN_BW__SHIFT                                           0
#define GEN_CONTROLS__DYN_BW__WIDTH                                           2
#define GEN_CONTROLS__DYN_BW__MASK                                  0x00000003U
#define GEN_CONTROLS__DYN_BW__READ(src)          (u_int32_t)(src) & 0x00000003U
#define GEN_CONTROLS__DYN_BW__WRITE(src)       ((u_int32_t)(src) & 0x00000003U)
#define GEN_CONTROLS__DYN_BW__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000003U) | ((u_int32_t)(src) &\
                    0x00000003U)
#define GEN_CONTROLS__DYN_BW__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00000003U)))

/* macros for field dyn_pri_chn */
#define GEN_CONTROLS__DYN_PRI_CHN__SHIFT                                      2
#define GEN_CONTROLS__DYN_PRI_CHN__WIDTH                                      3
#define GEN_CONTROLS__DYN_PRI_CHN__MASK                             0x0000001cU
#define GEN_CONTROLS__DYN_PRI_CHN__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0000001cU) >> 2)
#define GEN_CONTROLS__DYN_PRI_CHN__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 2) & 0x0000001cU)
#define GEN_CONTROLS__DYN_PRI_CHN__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000001cU) | (((u_int32_t)(src) <<\
                    2) & 0x0000001cU)
#define GEN_CONTROLS__DYN_PRI_CHN__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 2) & ~0x0000001cU)))

/* macros for field dyn_chn_gap */
#define GEN_CONTROLS__DYN_CHN_GAP__SHIFT                                      5
#define GEN_CONTROLS__DYN_CHN_GAP__WIDTH                                      1
#define GEN_CONTROLS__DYN_CHN_GAP__MASK                             0x00000020U
#define GEN_CONTROLS__DYN_CHN_GAP__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000020U) >> 5)
#define GEN_CONTROLS__DYN_CHN_GAP__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 5) & 0x00000020U)
#define GEN_CONTROLS__DYN_CHN_GAP__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000020U) | (((u_int32_t)(src) <<\
                    5) & 0x00000020U)
#define GEN_CONTROLS__DYN_CHN_GAP__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 5) & ~0x00000020U)))
#define GEN_CONTROLS__DYN_CHN_GAP__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000020U) | ((u_int32_t)(1) << 5)
#define GEN_CONTROLS__DYN_CHN_GAP__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000020U) | ((u_int32_t)(0) << 5)

/* macros for field dyn_non_contig */
#define GEN_CONTROLS__DYN_NON_CONTIG__SHIFT                                   6
#define GEN_CONTROLS__DYN_NON_CONTIG__WIDTH                                   1
#define GEN_CONTROLS__DYN_NON_CONTIG__MASK                          0x00000040U
#define GEN_CONTROLS__DYN_NON_CONTIG__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000040U) >> 6)
#define GEN_CONTROLS__DYN_NON_CONTIG__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 6) & 0x00000040U)
#define GEN_CONTROLS__DYN_NON_CONTIG__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000040U) | (((u_int32_t)(src) <<\
                    6) & 0x00000040U)
#define GEN_CONTROLS__DYN_NON_CONTIG__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 6) & ~0x00000040U)))
#define GEN_CONTROLS__DYN_NON_CONTIG__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000040U) | ((u_int32_t)(1) << 6)
#define GEN_CONTROLS__DYN_NON_CONTIG__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000040U) | ((u_int32_t)(0) << 6)

/* macros for field vht_enable */
#define GEN_CONTROLS__VHT_ENABLE__SHIFT                                       7
#define GEN_CONTROLS__VHT_ENABLE__WIDTH                                       1
#define GEN_CONTROLS__VHT_ENABLE__MASK                              0x00000080U
#define GEN_CONTROLS__VHT_ENABLE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000080U) >> 7)
#define GEN_CONTROLS__VHT_ENABLE__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 7) & 0x00000080U)
#define GEN_CONTROLS__VHT_ENABLE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000080U) | (((u_int32_t)(src) <<\
                    7) & 0x00000080U)
#define GEN_CONTROLS__VHT_ENABLE__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 7) & ~0x00000080U)))
#define GEN_CONTROLS__VHT_ENABLE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000080U) | ((u_int32_t)(1) << 7)
#define GEN_CONTROLS__VHT_ENABLE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000080U) | ((u_int32_t)(0) << 7)

/* macros for field allow_short_gi */
#define GEN_CONTROLS__ALLOW_SHORT_GI__SHIFT                                   8
#define GEN_CONTROLS__ALLOW_SHORT_GI__WIDTH                                   1
#define GEN_CONTROLS__ALLOW_SHORT_GI__MASK                          0x00000100U
#define GEN_CONTROLS__ALLOW_SHORT_GI__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000100U) >> 8)
#define GEN_CONTROLS__ALLOW_SHORT_GI__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 8) & 0x00000100U)
#define GEN_CONTROLS__ALLOW_SHORT_GI__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000100U) | (((u_int32_t)(src) <<\
                    8) & 0x00000100U)
#define GEN_CONTROLS__ALLOW_SHORT_GI__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 8) & ~0x00000100U)))
#define GEN_CONTROLS__ALLOW_SHORT_GI__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000100U) | ((u_int32_t)(1) << 8)
#define GEN_CONTROLS__ALLOW_SHORT_GI__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000100U) | ((u_int32_t)(0) << 8)

/* macros for field use_walsh_for_nsts_eq_ntx */
#define GEN_CONTROLS__USE_WALSH_FOR_NSTS_EQ_NTX__SHIFT                        9
#define GEN_CONTROLS__USE_WALSH_FOR_NSTS_EQ_NTX__WIDTH                        1
#define GEN_CONTROLS__USE_WALSH_FOR_NSTS_EQ_NTX__MASK               0x00000200U
#define GEN_CONTROLS__USE_WALSH_FOR_NSTS_EQ_NTX__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000200U) >> 9)
#define GEN_CONTROLS__USE_WALSH_FOR_NSTS_EQ_NTX__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 9) & 0x00000200U)
#define GEN_CONTROLS__USE_WALSH_FOR_NSTS_EQ_NTX__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000200U) | (((u_int32_t)(src) <<\
                    9) & 0x00000200U)
#define GEN_CONTROLS__USE_WALSH_FOR_NSTS_EQ_NTX__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 9) & ~0x00000200U)))
#define GEN_CONTROLS__USE_WALSH_FOR_NSTS_EQ_NTX__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000200U) | ((u_int32_t)(1) << 9)
#define GEN_CONTROLS__USE_WALSH_FOR_NSTS_EQ_NTX__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000200U) | ((u_int32_t)(0) << 9)

/* macros for field apply_walsh_on_legacy */
#define GEN_CONTROLS__APPLY_WALSH_ON_LEGACY__SHIFT                           10
#define GEN_CONTROLS__APPLY_WALSH_ON_LEGACY__WIDTH                            1
#define GEN_CONTROLS__APPLY_WALSH_ON_LEGACY__MASK                   0x00000400U
#define GEN_CONTROLS__APPLY_WALSH_ON_LEGACY__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000400U) >> 10)
#define GEN_CONTROLS__APPLY_WALSH_ON_LEGACY__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 10) & 0x00000400U)
#define GEN_CONTROLS__APPLY_WALSH_ON_LEGACY__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000400U) | (((u_int32_t)(src) <<\
                    10) & 0x00000400U)
#define GEN_CONTROLS__APPLY_WALSH_ON_LEGACY__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 10) & ~0x00000400U)))
#define GEN_CONTROLS__APPLY_WALSH_ON_LEGACY__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000400U) | ((u_int32_t)(1) << 10)
#define GEN_CONTROLS__APPLY_WALSH_ON_LEGACY__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000400U) | ((u_int32_t)(0) << 10)

/* macros for field gf_enable */
#define GEN_CONTROLS__GF_ENABLE__SHIFT                                       11
#define GEN_CONTROLS__GF_ENABLE__WIDTH                                        1
#define GEN_CONTROLS__GF_ENABLE__MASK                               0x00000800U
#define GEN_CONTROLS__GF_ENABLE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000800U) >> 11)
#define GEN_CONTROLS__GF_ENABLE__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 11) & 0x00000800U)
#define GEN_CONTROLS__GF_ENABLE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000800U) | (((u_int32_t)(src) <<\
                    11) & 0x00000800U)
#define GEN_CONTROLS__GF_ENABLE__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 11) & ~0x00000800U)))
#define GEN_CONTROLS__GF_ENABLE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000800U) | ((u_int32_t)(1) << 11)
#define GEN_CONTROLS__GF_ENABLE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000800U) | ((u_int32_t)(0) << 11)

/* macros for field enable_dac_async_fifo */
#define GEN_CONTROLS__ENABLE_DAC_ASYNC_FIFO__SHIFT                           12
#define GEN_CONTROLS__ENABLE_DAC_ASYNC_FIFO__WIDTH                            1
#define GEN_CONTROLS__ENABLE_DAC_ASYNC_FIFO__MASK                   0x00001000U
#define GEN_CONTROLS__ENABLE_DAC_ASYNC_FIFO__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00001000U) >> 12)
#define GEN_CONTROLS__ENABLE_DAC_ASYNC_FIFO__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 12) & 0x00001000U)
#define GEN_CONTROLS__ENABLE_DAC_ASYNC_FIFO__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00001000U) | (((u_int32_t)(src) <<\
                    12) & 0x00001000U)
#define GEN_CONTROLS__ENABLE_DAC_ASYNC_FIFO__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 12) & ~0x00001000U)))
#define GEN_CONTROLS__ENABLE_DAC_ASYNC_FIFO__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00001000U) | ((u_int32_t)(1) << 12)
#define GEN_CONTROLS__ENABLE_DAC_ASYNC_FIFO__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00001000U) | ((u_int32_t)(0) << 12)

/* macros for field enable_adc_async_fifo */
#define GEN_CONTROLS__ENABLE_ADC_ASYNC_FIFO__SHIFT                           13
#define GEN_CONTROLS__ENABLE_ADC_ASYNC_FIFO__WIDTH                            1
#define GEN_CONTROLS__ENABLE_ADC_ASYNC_FIFO__MASK                   0x00002000U
#define GEN_CONTROLS__ENABLE_ADC_ASYNC_FIFO__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00002000U) >> 13)
#define GEN_CONTROLS__ENABLE_ADC_ASYNC_FIFO__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 13) & 0x00002000U)
#define GEN_CONTROLS__ENABLE_ADC_ASYNC_FIFO__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00002000U) | (((u_int32_t)(src) <<\
                    13) & 0x00002000U)
#define GEN_CONTROLS__ENABLE_ADC_ASYNC_FIFO__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 13) & ~0x00002000U)))
#define GEN_CONTROLS__ENABLE_ADC_ASYNC_FIFO__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00002000U) | ((u_int32_t)(1) << 13)
#define GEN_CONTROLS__ENABLE_ADC_ASYNC_FIFO__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00002000U) | ((u_int32_t)(0) << 13)

/* macros for field static20_mode_ht40_packet_handling */
#define GEN_CONTROLS__STATIC20_MODE_HT40_PACKET_HANDLING__SHIFT              15
#define GEN_CONTROLS__STATIC20_MODE_HT40_PACKET_HANDLING__WIDTH               1
#define GEN_CONTROLS__STATIC20_MODE_HT40_PACKET_HANDLING__MASK      0x00008000U
#define GEN_CONTROLS__STATIC20_MODE_HT40_PACKET_HANDLING__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00008000U) >> 15)
#define GEN_CONTROLS__STATIC20_MODE_HT40_PACKET_HANDLING__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 15) & 0x00008000U)
#define GEN_CONTROLS__STATIC20_MODE_HT40_PACKET_HANDLING__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00008000U) | (((u_int32_t)(src) <<\
                    15) & 0x00008000U)
#define GEN_CONTROLS__STATIC20_MODE_HT40_PACKET_HANDLING__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 15) & ~0x00008000U)))
#define GEN_CONTROLS__STATIC20_MODE_HT40_PACKET_HANDLING__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00008000U) | ((u_int32_t)(1) << 15)
#define GEN_CONTROLS__STATIC20_MODE_HT40_PACKET_HANDLING__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00008000U) | ((u_int32_t)(0) << 15)

/* macros for field static20_mode_ht40_packet_error_rpt */
#define GEN_CONTROLS__STATIC20_MODE_HT40_PACKET_ERROR_RPT__SHIFT             16
#define GEN_CONTROLS__STATIC20_MODE_HT40_PACKET_ERROR_RPT__WIDTH              1
#define GEN_CONTROLS__STATIC20_MODE_HT40_PACKET_ERROR_RPT__MASK     0x00010000U
#define GEN_CONTROLS__STATIC20_MODE_HT40_PACKET_ERROR_RPT__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00010000U) >> 16)
#define GEN_CONTROLS__STATIC20_MODE_HT40_PACKET_ERROR_RPT__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 16) & 0x00010000U)
#define GEN_CONTROLS__STATIC20_MODE_HT40_PACKET_ERROR_RPT__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00010000U) | (((u_int32_t)(src) <<\
                    16) & 0x00010000U)
#define GEN_CONTROLS__STATIC20_MODE_HT40_PACKET_ERROR_RPT__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 16) & ~0x00010000U)))
#define GEN_CONTROLS__STATIC20_MODE_HT40_PACKET_ERROR_RPT__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00010000U) | ((u_int32_t)(1) << 16)
#define GEN_CONTROLS__STATIC20_MODE_HT40_PACKET_ERROR_RPT__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00010000U) | ((u_int32_t)(0) << 16)

/* macros for field chain0_upper_segment */
#define GEN_CONTROLS__CHAIN0_UPPER_SEGMENT__SHIFT                            17
#define GEN_CONTROLS__CHAIN0_UPPER_SEGMENT__WIDTH                             1
#define GEN_CONTROLS__CHAIN0_UPPER_SEGMENT__MASK                    0x00020000U
#define GEN_CONTROLS__CHAIN0_UPPER_SEGMENT__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00020000U) >> 17)
#define GEN_CONTROLS__CHAIN0_UPPER_SEGMENT__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 17) & 0x00020000U)
#define GEN_CONTROLS__CHAIN0_UPPER_SEGMENT__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00020000U) | (((u_int32_t)(src) <<\
                    17) & 0x00020000U)
#define GEN_CONTROLS__CHAIN0_UPPER_SEGMENT__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 17) & ~0x00020000U)))
#define GEN_CONTROLS__CHAIN0_UPPER_SEGMENT__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00020000U) | ((u_int32_t)(1) << 17)
#define GEN_CONTROLS__CHAIN0_UPPER_SEGMENT__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00020000U) | ((u_int32_t)(0) << 17)

/* macros for field unsupp_ht_rate_threshold */
#define GEN_CONTROLS__UNSUPP_HT_RATE_THRESHOLD__SHIFT                        18
#define GEN_CONTROLS__UNSUPP_HT_RATE_THRESHOLD__WIDTH                         7
#define GEN_CONTROLS__UNSUPP_HT_RATE_THRESHOLD__MASK                0x01fc0000U
#define GEN_CONTROLS__UNSUPP_HT_RATE_THRESHOLD__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x01fc0000U) >> 18)
#define GEN_CONTROLS__UNSUPP_HT_RATE_THRESHOLD__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 18) & 0x01fc0000U)
#define GEN_CONTROLS__UNSUPP_HT_RATE_THRESHOLD__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x01fc0000U) | (((u_int32_t)(src) <<\
                    18) & 0x01fc0000U)
#define GEN_CONTROLS__UNSUPP_HT_RATE_THRESHOLD__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 18) & ~0x01fc0000U)))

/* macros for field enable_err_tx_chain_mask_zero */
#define GEN_CONTROLS__ENABLE_ERR_TX_CHAIN_MASK_ZERO__SHIFT                   25
#define GEN_CONTROLS__ENABLE_ERR_TX_CHAIN_MASK_ZERO__WIDTH                    1
#define GEN_CONTROLS__ENABLE_ERR_TX_CHAIN_MASK_ZERO__MASK           0x02000000U
#define GEN_CONTROLS__ENABLE_ERR_TX_CHAIN_MASK_ZERO__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x02000000U) >> 25)
#define GEN_CONTROLS__ENABLE_ERR_TX_CHAIN_MASK_ZERO__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 25) & 0x02000000U)
#define GEN_CONTROLS__ENABLE_ERR_TX_CHAIN_MASK_ZERO__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x02000000U) | (((u_int32_t)(src) <<\
                    25) & 0x02000000U)
#define GEN_CONTROLS__ENABLE_ERR_TX_CHAIN_MASK_ZERO__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 25) & ~0x02000000U)))
#define GEN_CONTROLS__ENABLE_ERR_TX_CHAIN_MASK_ZERO__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x02000000U) | ((u_int32_t)(1) << 25)
#define GEN_CONTROLS__ENABLE_ERR_TX_CHAIN_MASK_ZERO__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x02000000U) | ((u_int32_t)(0) << 25)

/* macros for field enable_err_extra_sym_mismatch */
#define GEN_CONTROLS__ENABLE_ERR_EXTRA_SYM_MISMATCH__SHIFT                   26
#define GEN_CONTROLS__ENABLE_ERR_EXTRA_SYM_MISMATCH__WIDTH                    1
#define GEN_CONTROLS__ENABLE_ERR_EXTRA_SYM_MISMATCH__MASK           0x04000000U
#define GEN_CONTROLS__ENABLE_ERR_EXTRA_SYM_MISMATCH__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x04000000U) >> 26)
#define GEN_CONTROLS__ENABLE_ERR_EXTRA_SYM_MISMATCH__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 26) & 0x04000000U)
#define GEN_CONTROLS__ENABLE_ERR_EXTRA_SYM_MISMATCH__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x04000000U) | (((u_int32_t)(src) <<\
                    26) & 0x04000000U)
#define GEN_CONTROLS__ENABLE_ERR_EXTRA_SYM_MISMATCH__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 26) & ~0x04000000U)))
#define GEN_CONTROLS__ENABLE_ERR_EXTRA_SYM_MISMATCH__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x04000000U) | ((u_int32_t)(1) << 26)
#define GEN_CONTROLS__ENABLE_ERR_EXTRA_SYM_MISMATCH__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x04000000U) | ((u_int32_t)(0) << 26)

/* macros for field enable_err_lsig_length_check */
#define GEN_CONTROLS__ENABLE_ERR_LSIG_LENGTH_CHECK__SHIFT                    27
#define GEN_CONTROLS__ENABLE_ERR_LSIG_LENGTH_CHECK__WIDTH                     1
#define GEN_CONTROLS__ENABLE_ERR_LSIG_LENGTH_CHECK__MASK            0x08000000U
#define GEN_CONTROLS__ENABLE_ERR_LSIG_LENGTH_CHECK__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x08000000U) >> 27)
#define GEN_CONTROLS__ENABLE_ERR_LSIG_LENGTH_CHECK__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 27) & 0x08000000U)
#define GEN_CONTROLS__ENABLE_ERR_LSIG_LENGTH_CHECK__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x08000000U) | (((u_int32_t)(src) <<\
                    27) & 0x08000000U)
#define GEN_CONTROLS__ENABLE_ERR_LSIG_LENGTH_CHECK__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 27) & ~0x08000000U)))
#define GEN_CONTROLS__ENABLE_ERR_LSIG_LENGTH_CHECK__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x08000000U) | ((u_int32_t)(1) << 27)
#define GEN_CONTROLS__ENABLE_ERR_LSIG_LENGTH_CHECK__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x08000000U) | ((u_int32_t)(0) << 27)

/* macros for field enable_err_tx_bw_gt_dyn_bw */
#define GEN_CONTROLS__ENABLE_ERR_TX_BW_GT_DYN_BW__SHIFT                      28
#define GEN_CONTROLS__ENABLE_ERR_TX_BW_GT_DYN_BW__WIDTH                       1
#define GEN_CONTROLS__ENABLE_ERR_TX_BW_GT_DYN_BW__MASK              0x10000000U
#define GEN_CONTROLS__ENABLE_ERR_TX_BW_GT_DYN_BW__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x10000000U) >> 28)
#define GEN_CONTROLS__ENABLE_ERR_TX_BW_GT_DYN_BW__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 28) & 0x10000000U)
#define GEN_CONTROLS__ENABLE_ERR_TX_BW_GT_DYN_BW__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x10000000U) | (((u_int32_t)(src) <<\
                    28) & 0x10000000U)
#define GEN_CONTROLS__ENABLE_ERR_TX_BW_GT_DYN_BW__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 28) & ~0x10000000U)))
#define GEN_CONTROLS__ENABLE_ERR_TX_BW_GT_DYN_BW__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x10000000U) | ((u_int32_t)(1) << 28)
#define GEN_CONTROLS__ENABLE_ERR_TX_BW_GT_DYN_BW__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x10000000U) | ((u_int32_t)(0) << 28)

/* macros for field enable_err_tx_illegal_rate */
#define GEN_CONTROLS__ENABLE_ERR_TX_ILLEGAL_RATE__SHIFT                      29
#define GEN_CONTROLS__ENABLE_ERR_TX_ILLEGAL_RATE__WIDTH                       1
#define GEN_CONTROLS__ENABLE_ERR_TX_ILLEGAL_RATE__MASK              0x20000000U
#define GEN_CONTROLS__ENABLE_ERR_TX_ILLEGAL_RATE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x20000000U) >> 29)
#define GEN_CONTROLS__ENABLE_ERR_TX_ILLEGAL_RATE__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 29) & 0x20000000U)
#define GEN_CONTROLS__ENABLE_ERR_TX_ILLEGAL_RATE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x20000000U) | (((u_int32_t)(src) <<\
                    29) & 0x20000000U)
#define GEN_CONTROLS__ENABLE_ERR_TX_ILLEGAL_RATE__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 29) & ~0x20000000U)))
#define GEN_CONTROLS__ENABLE_ERR_TX_ILLEGAL_RATE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x20000000U) | ((u_int32_t)(1) << 29)
#define GEN_CONTROLS__ENABLE_ERR_TX_ILLEGAL_RATE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x20000000U) | ((u_int32_t)(0) << 29)

/* macros for field enable_err_tpc_miss */
#define GEN_CONTROLS__ENABLE_ERR_TPC_MISS__SHIFT                             30
#define GEN_CONTROLS__ENABLE_ERR_TPC_MISS__WIDTH                              1
#define GEN_CONTROLS__ENABLE_ERR_TPC_MISS__MASK                     0x40000000U
#define GEN_CONTROLS__ENABLE_ERR_TPC_MISS__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x40000000U) >> 30)
#define GEN_CONTROLS__ENABLE_ERR_TPC_MISS__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 30) & 0x40000000U)
#define GEN_CONTROLS__ENABLE_ERR_TPC_MISS__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x40000000U) | (((u_int32_t)(src) <<\
                    30) & 0x40000000U)
#define GEN_CONTROLS__ENABLE_ERR_TPC_MISS__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 30) & ~0x40000000U)))
#define GEN_CONTROLS__ENABLE_ERR_TPC_MISS__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x40000000U) | ((u_int32_t)(1) << 30)
#define GEN_CONTROLS__ENABLE_ERR_TPC_MISS__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x40000000U) | ((u_int32_t)(0) << 30)
#define GEN_CONTROLS__TYPE                                            u_int32_t
#define GEN_CONTROLS__READ                                          0x7fffbfffU
#define GEN_CONTROLS__WRITE                                         0x7fffbfffU

#endif /* __GEN_CONTROLS_MACRO__ */


/* macros for bb_reg_map.bb_sm_reg_map.BB_gen_controls */
#define INST_BB_REG_MAP__BB_SM_REG_MAP__BB_GEN_CONTROLS__NUM                  1

/* macros for BlueprintGlobalNameSpace::modes_select */
#ifndef __MODES_SELECT_MACRO__
#define __MODES_SELECT_MACRO__

/* macros for field cck_mode */
#define MODES_SELECT__CCK_MODE__SHIFT                                         0
#define MODES_SELECT__CCK_MODE__WIDTH                                         1
#define MODES_SELECT__CCK_MODE__MASK                                0x00000001U
#define MODES_SELECT__CCK_MODE__READ(src)        (u_int32_t)(src) & 0x00000001U
#define MODES_SELECT__CCK_MODE__WRITE(src)     ((u_int32_t)(src) & 0x00000001U)
#define MODES_SELECT__CCK_MODE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | ((u_int32_t)(src) &\
                    0x00000001U)
#define MODES_SELECT__CCK_MODE__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00000001U)))
#define MODES_SELECT__CCK_MODE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(1)
#define MODES_SELECT__CCK_MODE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(0)

/* macros for field dyn_ofdm_cck_mode */
#define MODES_SELECT__DYN_OFDM_CCK_MODE__SHIFT                                2
#define MODES_SELECT__DYN_OFDM_CCK_MODE__WIDTH                                1
#define MODES_SELECT__DYN_OFDM_CCK_MODE__MASK                       0x00000004U
#define MODES_SELECT__DYN_OFDM_CCK_MODE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000004U) >> 2)
#define MODES_SELECT__DYN_OFDM_CCK_MODE__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 2) & 0x00000004U)
#define MODES_SELECT__DYN_OFDM_CCK_MODE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000004U) | (((u_int32_t)(src) <<\
                    2) & 0x00000004U)
#define MODES_SELECT__DYN_OFDM_CCK_MODE__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 2) & ~0x00000004U)))
#define MODES_SELECT__DYN_OFDM_CCK_MODE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000004U) | ((u_int32_t)(1) << 2)
#define MODES_SELECT__DYN_OFDM_CCK_MODE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000004U) | ((u_int32_t)(0) << 2)

/* macros for field half_rate_mode */
#define MODES_SELECT__HALF_RATE_MODE__SHIFT                                   5
#define MODES_SELECT__HALF_RATE_MODE__WIDTH                                   1
#define MODES_SELECT__HALF_RATE_MODE__MASK                          0x00000020U
#define MODES_SELECT__HALF_RATE_MODE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000020U) >> 5)
#define MODES_SELECT__HALF_RATE_MODE__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 5) & 0x00000020U)
#define MODES_SELECT__HALF_RATE_MODE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000020U) | (((u_int32_t)(src) <<\
                    5) & 0x00000020U)
#define MODES_SELECT__HALF_RATE_MODE__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 5) & ~0x00000020U)))
#define MODES_SELECT__HALF_RATE_MODE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000020U) | ((u_int32_t)(1) << 5)
#define MODES_SELECT__HALF_RATE_MODE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000020U) | ((u_int32_t)(0) << 5)

/* macros for field quarter_rate_mode */
#define MODES_SELECT__QUARTER_RATE_MODE__SHIFT                                6
#define MODES_SELECT__QUARTER_RATE_MODE__WIDTH                                1
#define MODES_SELECT__QUARTER_RATE_MODE__MASK                       0x00000040U
#define MODES_SELECT__QUARTER_RATE_MODE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000040U) >> 6)
#define MODES_SELECT__QUARTER_RATE_MODE__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 6) & 0x00000040U)
#define MODES_SELECT__QUARTER_RATE_MODE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000040U) | (((u_int32_t)(src) <<\
                    6) & 0x00000040U)
#define MODES_SELECT__QUARTER_RATE_MODE__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 6) & ~0x00000040U)))
#define MODES_SELECT__QUARTER_RATE_MODE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000040U) | ((u_int32_t)(1) << 6)
#define MODES_SELECT__QUARTER_RATE_MODE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000040U) | ((u_int32_t)(0) << 6)

/* macros for field mac_clk_mode */
#define MODES_SELECT__MAC_CLK_MODE__SHIFT                                     7
#define MODES_SELECT__MAC_CLK_MODE__WIDTH                                     1
#define MODES_SELECT__MAC_CLK_MODE__MASK                            0x00000080U
#define MODES_SELECT__MAC_CLK_MODE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000080U) >> 7)
#define MODES_SELECT__MAC_CLK_MODE__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 7) & 0x00000080U)
#define MODES_SELECT__MAC_CLK_MODE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000080U) | (((u_int32_t)(src) <<\
                    7) & 0x00000080U)
#define MODES_SELECT__MAC_CLK_MODE__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 7) & ~0x00000080U)))
#define MODES_SELECT__MAC_CLK_MODE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000080U) | ((u_int32_t)(1) << 7)
#define MODES_SELECT__MAC_CLK_MODE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000080U) | ((u_int32_t)(0) << 7)

/* macros for field disable_dyn_cck_det */
#define MODES_SELECT__DISABLE_DYN_CCK_DET__SHIFT                              8
#define MODES_SELECT__DISABLE_DYN_CCK_DET__WIDTH                              1
#define MODES_SELECT__DISABLE_DYN_CCK_DET__MASK                     0x00000100U
#define MODES_SELECT__DISABLE_DYN_CCK_DET__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000100U) >> 8)
#define MODES_SELECT__DISABLE_DYN_CCK_DET__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 8) & 0x00000100U)
#define MODES_SELECT__DISABLE_DYN_CCK_DET__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000100U) | (((u_int32_t)(src) <<\
                    8) & 0x00000100U)
#define MODES_SELECT__DISABLE_DYN_CCK_DET__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 8) & ~0x00000100U)))
#define MODES_SELECT__DISABLE_DYN_CCK_DET__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000100U) | ((u_int32_t)(1) << 8)
#define MODES_SELECT__DISABLE_DYN_CCK_DET__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000100U) | ((u_int32_t)(0) << 8)

/* macros for field ovsamp_clk_mode */
#define MODES_SELECT__OVSAMP_CLK_MODE__SHIFT                                 10
#define MODES_SELECT__OVSAMP_CLK_MODE__WIDTH                                  1
#define MODES_SELECT__OVSAMP_CLK_MODE__MASK                         0x00000400U
#define MODES_SELECT__OVSAMP_CLK_MODE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000400U) >> 10)
#define MODES_SELECT__OVSAMP_CLK_MODE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000400U) | ((u_int32_t)(1) << 10)
#define MODES_SELECT__OVSAMP_CLK_MODE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000400U) | ((u_int32_t)(0) << 10)

/* macros for field skip_rx_grp_id_0 */
#define MODES_SELECT__SKIP_RX_GRP_ID_0__SHIFT                                11
#define MODES_SELECT__SKIP_RX_GRP_ID_0__WIDTH                                 1
#define MODES_SELECT__SKIP_RX_GRP_ID_0__MASK                        0x00000800U
#define MODES_SELECT__SKIP_RX_GRP_ID_0__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000800U) >> 11)
#define MODES_SELECT__SKIP_RX_GRP_ID_0__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 11) & 0x00000800U)
#define MODES_SELECT__SKIP_RX_GRP_ID_0__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000800U) | (((u_int32_t)(src) <<\
                    11) & 0x00000800U)
#define MODES_SELECT__SKIP_RX_GRP_ID_0__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 11) & ~0x00000800U)))
#define MODES_SELECT__SKIP_RX_GRP_ID_0__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000800U) | ((u_int32_t)(1) << 11)
#define MODES_SELECT__SKIP_RX_GRP_ID_0__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000800U) | ((u_int32_t)(0) << 11)

/* macros for field skip_rx_grp_id_63 */
#define MODES_SELECT__SKIP_RX_GRP_ID_63__SHIFT                               12
#define MODES_SELECT__SKIP_RX_GRP_ID_63__WIDTH                                1
#define MODES_SELECT__SKIP_RX_GRP_ID_63__MASK                       0x00001000U
#define MODES_SELECT__SKIP_RX_GRP_ID_63__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00001000U) >> 12)
#define MODES_SELECT__SKIP_RX_GRP_ID_63__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 12) & 0x00001000U)
#define MODES_SELECT__SKIP_RX_GRP_ID_63__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00001000U) | (((u_int32_t)(src) <<\
                    12) & 0x00001000U)
#define MODES_SELECT__SKIP_RX_GRP_ID_63__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 12) & ~0x00001000U)))
#define MODES_SELECT__SKIP_RX_GRP_ID_63__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00001000U) | ((u_int32_t)(1) << 12)
#define MODES_SELECT__SKIP_RX_GRP_ID_63__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00001000U) | ((u_int32_t)(0) << 12)

/* macros for field en_err_vht_rx_siga_unsup */
#define MODES_SELECT__EN_ERR_VHT_RX_SIGA_UNSUP__SHIFT                        13
#define MODES_SELECT__EN_ERR_VHT_RX_SIGA_UNSUP__WIDTH                         1
#define MODES_SELECT__EN_ERR_VHT_RX_SIGA_UNSUP__MASK                0x00002000U
#define MODES_SELECT__EN_ERR_VHT_RX_SIGA_UNSUP__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00002000U) >> 13)
#define MODES_SELECT__EN_ERR_VHT_RX_SIGA_UNSUP__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 13) & 0x00002000U)
#define MODES_SELECT__EN_ERR_VHT_RX_SIGA_UNSUP__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00002000U) | (((u_int32_t)(src) <<\
                    13) & 0x00002000U)
#define MODES_SELECT__EN_ERR_VHT_RX_SIGA_UNSUP__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 13) & ~0x00002000U)))
#define MODES_SELECT__EN_ERR_VHT_RX_SIGA_UNSUP__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00002000U) | ((u_int32_t)(1) << 13)
#define MODES_SELECT__EN_ERR_VHT_RX_SIGA_UNSUP__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00002000U) | ((u_int32_t)(0) << 13)

/* macros for field en_err_vht_lsig_len_invalid */
#define MODES_SELECT__EN_ERR_VHT_LSIG_LEN_INVALID__SHIFT                     14
#define MODES_SELECT__EN_ERR_VHT_LSIG_LEN_INVALID__WIDTH                      1
#define MODES_SELECT__EN_ERR_VHT_LSIG_LEN_INVALID__MASK             0x00004000U
#define MODES_SELECT__EN_ERR_VHT_LSIG_LEN_INVALID__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00004000U) >> 14)
#define MODES_SELECT__EN_ERR_VHT_LSIG_LEN_INVALID__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 14) & 0x00004000U)
#define MODES_SELECT__EN_ERR_VHT_LSIG_LEN_INVALID__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00004000U) | (((u_int32_t)(src) <<\
                    14) & 0x00004000U)
#define MODES_SELECT__EN_ERR_VHT_LSIG_LEN_INVALID__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 14) & ~0x00004000U)))
#define MODES_SELECT__EN_ERR_VHT_LSIG_LEN_INVALID__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00004000U) | ((u_int32_t)(1) << 14)
#define MODES_SELECT__EN_ERR_VHT_LSIG_LEN_INVALID__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00004000U) | ((u_int32_t)(0) << 14)

/* macros for field en_err_vht_rx_ndp_or_zlf */
#define MODES_SELECT__EN_ERR_VHT_RX_NDP_OR_ZLF__SHIFT                        15
#define MODES_SELECT__EN_ERR_VHT_RX_NDP_OR_ZLF__WIDTH                         1
#define MODES_SELECT__EN_ERR_VHT_RX_NDP_OR_ZLF__MASK                0x00008000U
#define MODES_SELECT__EN_ERR_VHT_RX_NDP_OR_ZLF__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00008000U) >> 15)
#define MODES_SELECT__EN_ERR_VHT_RX_NDP_OR_ZLF__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 15) & 0x00008000U)
#define MODES_SELECT__EN_ERR_VHT_RX_NDP_OR_ZLF__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00008000U) | (((u_int32_t)(src) <<\
                    15) & 0x00008000U)
#define MODES_SELECT__EN_ERR_VHT_RX_NDP_OR_ZLF__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 15) & ~0x00008000U)))
#define MODES_SELECT__EN_ERR_VHT_RX_NDP_OR_ZLF__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00008000U) | ((u_int32_t)(1) << 15)
#define MODES_SELECT__EN_ERR_VHT_RX_NDP_OR_ZLF__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00008000U) | ((u_int32_t)(0) << 15)

/* macros for field en_err_vht_rx_nsym_lt_zero */
#define MODES_SELECT__EN_ERR_VHT_RX_NSYM_LT_ZERO__SHIFT                      16
#define MODES_SELECT__EN_ERR_VHT_RX_NSYM_LT_ZERO__WIDTH                       1
#define MODES_SELECT__EN_ERR_VHT_RX_NSYM_LT_ZERO__MASK              0x00010000U
#define MODES_SELECT__EN_ERR_VHT_RX_NSYM_LT_ZERO__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00010000U) >> 16)
#define MODES_SELECT__EN_ERR_VHT_RX_NSYM_LT_ZERO__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 16) & 0x00010000U)
#define MODES_SELECT__EN_ERR_VHT_RX_NSYM_LT_ZERO__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00010000U) | (((u_int32_t)(src) <<\
                    16) & 0x00010000U)
#define MODES_SELECT__EN_ERR_VHT_RX_NSYM_LT_ZERO__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 16) & ~0x00010000U)))
#define MODES_SELECT__EN_ERR_VHT_RX_NSYM_LT_ZERO__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00010000U) | ((u_int32_t)(1) << 16)
#define MODES_SELECT__EN_ERR_VHT_RX_NSYM_LT_ZERO__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00010000U) | ((u_int32_t)(0) << 16)

/* macros for field en_err_vht_grp1to62 */
#define MODES_SELECT__EN_ERR_VHT_GRP1TO62__SHIFT                             17
#define MODES_SELECT__EN_ERR_VHT_GRP1TO62__WIDTH                              1
#define MODES_SELECT__EN_ERR_VHT_GRP1TO62__MASK                     0x00020000U
#define MODES_SELECT__EN_ERR_VHT_GRP1TO62__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00020000U) >> 17)
#define MODES_SELECT__EN_ERR_VHT_GRP1TO62__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 17) & 0x00020000U)
#define MODES_SELECT__EN_ERR_VHT_GRP1TO62__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00020000U) | (((u_int32_t)(src) <<\
                    17) & 0x00020000U)
#define MODES_SELECT__EN_ERR_VHT_GRP1TO62__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 17) & ~0x00020000U)))
#define MODES_SELECT__EN_ERR_VHT_GRP1TO62__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00020000U) | ((u_int32_t)(1) << 17)
#define MODES_SELECT__EN_ERR_VHT_GRP1TO62__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00020000U) | ((u_int32_t)(0) << 17)

/* macros for field en_err_crc_abort */
#define MODES_SELECT__EN_ERR_CRC_ABORT__SHIFT                                18
#define MODES_SELECT__EN_ERR_CRC_ABORT__WIDTH                                 1
#define MODES_SELECT__EN_ERR_CRC_ABORT__MASK                        0x00040000U
#define MODES_SELECT__EN_ERR_CRC_ABORT__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00040000U) >> 18)
#define MODES_SELECT__EN_ERR_CRC_ABORT__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 18) & 0x00040000U)
#define MODES_SELECT__EN_ERR_CRC_ABORT__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00040000U) | (((u_int32_t)(src) <<\
                    18) & 0x00040000U)
#define MODES_SELECT__EN_ERR_CRC_ABORT__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 18) & ~0x00040000U)))
#define MODES_SELECT__EN_ERR_CRC_ABORT__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00040000U) | ((u_int32_t)(1) << 18)
#define MODES_SELECT__EN_ERR_CRC_ABORT__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00040000U) | ((u_int32_t)(0) << 18)

/* macros for field pmi_fifo_threshold */
#define MODES_SELECT__PMI_FIFO_THRESHOLD__SHIFT                              19
#define MODES_SELECT__PMI_FIFO_THRESHOLD__WIDTH                               5
#define MODES_SELECT__PMI_FIFO_THRESHOLD__MASK                      0x00f80000U
#define MODES_SELECT__PMI_FIFO_THRESHOLD__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00f80000U) >> 19)
#define MODES_SELECT__PMI_FIFO_THRESHOLD__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 19) & 0x00f80000U)
#define MODES_SELECT__PMI_FIFO_THRESHOLD__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00f80000U) | (((u_int32_t)(src) <<\
                    19) & 0x00f80000U)
#define MODES_SELECT__PMI_FIFO_THRESHOLD__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 19) & ~0x00f80000U)))
#define MODES_SELECT__TYPE                                            u_int32_t
#define MODES_SELECT__READ                                          0x00fffde5U
#define MODES_SELECT__WRITE                                         0x00fffde5U

#endif /* __MODES_SELECT_MACRO__ */


/* macros for bb_reg_map.bb_sm_reg_map.BB_modes_select */
#define INST_BB_REG_MAP__BB_SM_REG_MAP__BB_MODES_SELECT__NUM                  1

/* macros for BlueprintGlobalNameSpace::active */
#ifndef __ACTIVE_MACRO__
#define __ACTIVE_MACRO__

/* macros for field cf_active */
#define ACTIVE__CF_ACTIVE__SHIFT                                              0
#define ACTIVE__CF_ACTIVE__WIDTH                                              1
#define ACTIVE__CF_ACTIVE__MASK                                     0x00000001U
#define ACTIVE__CF_ACTIVE__READ(src)             (u_int32_t)(src) & 0x00000001U
#define ACTIVE__CF_ACTIVE__WRITE(src)          ((u_int32_t)(src) & 0x00000001U)
#define ACTIVE__CF_ACTIVE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | ((u_int32_t)(src) &\
                    0x00000001U)
#define ACTIVE__CF_ACTIVE__VERIFY(src)   (!(((u_int32_t)(src) & ~0x00000001U)))
#define ACTIVE__CF_ACTIVE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(1)
#define ACTIVE__CF_ACTIVE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(0)

/* macros for field cf_reset_core */
#define ACTIVE__CF_RESET_CORE__SHIFT                                          1
#define ACTIVE__CF_RESET_CORE__WIDTH                                          1
#define ACTIVE__CF_RESET_CORE__MASK                                 0x00000002U
#define ACTIVE__CF_RESET_CORE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000002U) >> 1)
#define ACTIVE__CF_RESET_CORE__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 1) & 0x00000002U)
#define ACTIVE__CF_RESET_CORE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | (((u_int32_t)(src) <<\
                    1) & 0x00000002U)
#define ACTIVE__CF_RESET_CORE__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 1) & ~0x00000002U)))
#define ACTIVE__CF_RESET_CORE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | ((u_int32_t)(1) << 1)
#define ACTIVE__CF_RESET_CORE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | ((u_int32_t)(0) << 1)
#define ACTIVE__TYPE                                                  u_int32_t
#define ACTIVE__READ                                                0x00000003U
#define ACTIVE__WRITE                                               0x00000003U

#endif /* __ACTIVE_MACRO__ */


/* macros for bb_reg_map.bb_sm_reg_map.BB_active */
#define INST_BB_REG_MAP__BB_SM_REG_MAP__BB_ACTIVE__NUM                        1

/* macros for BlueprintGlobalNameSpace::sm_spare_01 */
#ifndef __SM_SPARE_01_MACRO__
#define __SM_SPARE_01_MACRO__

/* macros for field sm_eco_ctrl */
#define SM_SPARE_01__SM_ECO_CTRL__SHIFT                                       0
#define SM_SPARE_01__SM_ECO_CTRL__WIDTH                                      32
#define SM_SPARE_01__SM_ECO_CTRL__MASK                              0xffffffffU
#define SM_SPARE_01__SM_ECO_CTRL__READ(src)      (u_int32_t)(src) & 0xffffffffU
#define SM_SPARE_01__SM_ECO_CTRL__WRITE(src)   ((u_int32_t)(src) & 0xffffffffU)
#define SM_SPARE_01__SM_ECO_CTRL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xffffffffU) | ((u_int32_t)(src) &\
                    0xffffffffU)
#define SM_SPARE_01__SM_ECO_CTRL__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0xffffffffU)))
#define SM_SPARE_01__TYPE                                             u_int32_t
#define SM_SPARE_01__READ                                           0xffffffffU
#define SM_SPARE_01__WRITE                                          0xffffffffU

#endif /* __SM_SPARE_01_MACRO__ */


/* macros for bb_reg_map.bb_sm_reg_map.BB_spare_01 */
#define INST_BB_REG_MAP__BB_SM_REG_MAP__BB_SPARE_01__NUM                      1

/* macros for BlueprintGlobalNameSpace::spectral_scan */
#ifndef __SPECTRAL_SCAN_MACRO__
#define __SPECTRAL_SCAN_MACRO__

/* macros for field spectral_scan_ena */
#define SPECTRAL_SCAN__SPECTRAL_SCAN_ENA__SHIFT                               0
#define SPECTRAL_SCAN__SPECTRAL_SCAN_ENA__WIDTH                               1
#define SPECTRAL_SCAN__SPECTRAL_SCAN_ENA__MASK                      0x00000001U
#define SPECTRAL_SCAN__SPECTRAL_SCAN_ENA__READ(src) \
                    (u_int32_t)(src)\
                    & 0x00000001U
#define SPECTRAL_SCAN__SPECTRAL_SCAN_ENA__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x00000001U)
#define SPECTRAL_SCAN__SPECTRAL_SCAN_ENA__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | ((u_int32_t)(src) &\
                    0x00000001U)
#define SPECTRAL_SCAN__SPECTRAL_SCAN_ENA__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00000001U)))
#define SPECTRAL_SCAN__SPECTRAL_SCAN_ENA__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(1)
#define SPECTRAL_SCAN__SPECTRAL_SCAN_ENA__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(0)

/* macros for field spectral_scan_active */
#define SPECTRAL_SCAN__SPECTRAL_SCAN_ACTIVE__SHIFT                            1
#define SPECTRAL_SCAN__SPECTRAL_SCAN_ACTIVE__WIDTH                            1
#define SPECTRAL_SCAN__SPECTRAL_SCAN_ACTIVE__MASK                   0x00000002U
#define SPECTRAL_SCAN__SPECTRAL_SCAN_ACTIVE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000002U) >> 1)
#define SPECTRAL_SCAN__SPECTRAL_SCAN_ACTIVE__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 1) & 0x00000002U)
#define SPECTRAL_SCAN__SPECTRAL_SCAN_ACTIVE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | (((u_int32_t)(src) <<\
                    1) & 0x00000002U)
#define SPECTRAL_SCAN__SPECTRAL_SCAN_ACTIVE__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 1) & ~0x00000002U)))
#define SPECTRAL_SCAN__SPECTRAL_SCAN_ACTIVE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | ((u_int32_t)(1) << 1)
#define SPECTRAL_SCAN__SPECTRAL_SCAN_ACTIVE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | ((u_int32_t)(0) << 1)

/* macros for field sscan_path_sel */
#define SPECTRAL_SCAN__SSCAN_PATH_SEL__SHIFT                                  2
#define SPECTRAL_SCAN__SSCAN_PATH_SEL__WIDTH                                  2
#define SPECTRAL_SCAN__SSCAN_PATH_SEL__MASK                         0x0000000cU
#define SPECTRAL_SCAN__SSCAN_PATH_SEL__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0000000cU) >> 2)
#define SPECTRAL_SCAN__SSCAN_PATH_SEL__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 2) & 0x0000000cU)
#define SPECTRAL_SCAN__SSCAN_PATH_SEL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000000cU) | (((u_int32_t)(src) <<\
                    2) & 0x0000000cU)
#define SPECTRAL_SCAN__SSCAN_PATH_SEL__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 2) & ~0x0000000cU)))

/* macros for field spectral_scan_fft_size */
#define SPECTRAL_SCAN__SPECTRAL_SCAN_FFT_SIZE__SHIFT                          4
#define SPECTRAL_SCAN__SPECTRAL_SCAN_FFT_SIZE__WIDTH                          4
#define SPECTRAL_SCAN__SPECTRAL_SCAN_FFT_SIZE__MASK                 0x000000f0U
#define SPECTRAL_SCAN__SPECTRAL_SCAN_FFT_SIZE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x000000f0U) >> 4)
#define SPECTRAL_SCAN__SPECTRAL_SCAN_FFT_SIZE__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 4) & 0x000000f0U)
#define SPECTRAL_SCAN__SPECTRAL_SCAN_FFT_SIZE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000000f0U) | (((u_int32_t)(src) <<\
                    4) & 0x000000f0U)
#define SPECTRAL_SCAN__SPECTRAL_SCAN_FFT_SIZE__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 4) & ~0x000000f0U)))

/* macros for field spectral_scan_period */
#define SPECTRAL_SCAN__SPECTRAL_SCAN_PERIOD__SHIFT                            8
#define SPECTRAL_SCAN__SPECTRAL_SCAN_PERIOD__WIDTH                            8
#define SPECTRAL_SCAN__SPECTRAL_SCAN_PERIOD__MASK                   0x0000ff00U
#define SPECTRAL_SCAN__SPECTRAL_SCAN_PERIOD__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0000ff00U) >> 8)
#define SPECTRAL_SCAN__SPECTRAL_SCAN_PERIOD__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 8) & 0x0000ff00U)
#define SPECTRAL_SCAN__SPECTRAL_SCAN_PERIOD__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000ff00U) | (((u_int32_t)(src) <<\
                    8) & 0x0000ff00U)
#define SPECTRAL_SCAN__SPECTRAL_SCAN_PERIOD__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 8) & ~0x0000ff00U)))

/* macros for field spectral_scan_count */
#define SPECTRAL_SCAN__SPECTRAL_SCAN_COUNT__SHIFT                            16
#define SPECTRAL_SCAN__SPECTRAL_SCAN_COUNT__WIDTH                            12
#define SPECTRAL_SCAN__SPECTRAL_SCAN_COUNT__MASK                    0x0fff0000U
#define SPECTRAL_SCAN__SPECTRAL_SCAN_COUNT__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0fff0000U) >> 16)
#define SPECTRAL_SCAN__SPECTRAL_SCAN_COUNT__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 16) & 0x0fff0000U)
#define SPECTRAL_SCAN__SPECTRAL_SCAN_COUNT__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0fff0000U) | (((u_int32_t)(src) <<\
                    16) & 0x0fff0000U)
#define SPECTRAL_SCAN__SPECTRAL_SCAN_COUNT__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 16) & ~0x0fff0000U)))

/* macros for field spectral_scan_priority */
#define SPECTRAL_SCAN__SPECTRAL_SCAN_PRIORITY__SHIFT                         29
#define SPECTRAL_SCAN__SPECTRAL_SCAN_PRIORITY__WIDTH                          1
#define SPECTRAL_SCAN__SPECTRAL_SCAN_PRIORITY__MASK                 0x20000000U
#define SPECTRAL_SCAN__SPECTRAL_SCAN_PRIORITY__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x20000000U) >> 29)
#define SPECTRAL_SCAN__SPECTRAL_SCAN_PRIORITY__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 29) & 0x20000000U)
#define SPECTRAL_SCAN__SPECTRAL_SCAN_PRIORITY__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x20000000U) | (((u_int32_t)(src) <<\
                    29) & 0x20000000U)
#define SPECTRAL_SCAN__SPECTRAL_SCAN_PRIORITY__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 29) & ~0x20000000U)))
#define SPECTRAL_SCAN__SPECTRAL_SCAN_PRIORITY__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x20000000U) | ((u_int32_t)(1) << 29)
#define SPECTRAL_SCAN__SPECTRAL_SCAN_PRIORITY__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x20000000U) | ((u_int32_t)(0) << 29)

/* macros for field spectral_scan_gc_ena */
#define SPECTRAL_SCAN__SPECTRAL_SCAN_GC_ENA__SHIFT                           30
#define SPECTRAL_SCAN__SPECTRAL_SCAN_GC_ENA__WIDTH                            1
#define SPECTRAL_SCAN__SPECTRAL_SCAN_GC_ENA__MASK                   0x40000000U
#define SPECTRAL_SCAN__SPECTRAL_SCAN_GC_ENA__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x40000000U) >> 30)
#define SPECTRAL_SCAN__SPECTRAL_SCAN_GC_ENA__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 30) & 0x40000000U)
#define SPECTRAL_SCAN__SPECTRAL_SCAN_GC_ENA__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x40000000U) | (((u_int32_t)(src) <<\
                    30) & 0x40000000U)
#define SPECTRAL_SCAN__SPECTRAL_SCAN_GC_ENA__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 30) & ~0x40000000U)))
#define SPECTRAL_SCAN__SPECTRAL_SCAN_GC_ENA__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x40000000U) | ((u_int32_t)(1) << 30)
#define SPECTRAL_SCAN__SPECTRAL_SCAN_GC_ENA__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x40000000U) | ((u_int32_t)(0) << 30)

/* macros for field spectral_scan_restart_ena */
#define SPECTRAL_SCAN__SPECTRAL_SCAN_RESTART_ENA__SHIFT                      31
#define SPECTRAL_SCAN__SPECTRAL_SCAN_RESTART_ENA__WIDTH                       1
#define SPECTRAL_SCAN__SPECTRAL_SCAN_RESTART_ENA__MASK              0x80000000U
#define SPECTRAL_SCAN__SPECTRAL_SCAN_RESTART_ENA__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x80000000U) >> 31)
#define SPECTRAL_SCAN__SPECTRAL_SCAN_RESTART_ENA__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 31) & 0x80000000U)
#define SPECTRAL_SCAN__SPECTRAL_SCAN_RESTART_ENA__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x80000000U) | (((u_int32_t)(src) <<\
                    31) & 0x80000000U)
#define SPECTRAL_SCAN__SPECTRAL_SCAN_RESTART_ENA__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 31) & ~0x80000000U)))
#define SPECTRAL_SCAN__SPECTRAL_SCAN_RESTART_ENA__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x80000000U) | ((u_int32_t)(1) << 31)
#define SPECTRAL_SCAN__SPECTRAL_SCAN_RESTART_ENA__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x80000000U) | ((u_int32_t)(0) << 31)
#define SPECTRAL_SCAN__TYPE                                           u_int32_t
#define SPECTRAL_SCAN__READ                                         0xefffffffU
#define SPECTRAL_SCAN__WRITE                                        0xefffffffU

#endif /* __SPECTRAL_SCAN_MACRO__ */


/* macros for bb_reg_map.bb_sm_reg_map.BB_spectral_scan */
#define INST_BB_REG_MAP__BB_SM_REG_MAP__BB_SPECTRAL_SCAN__NUM                 1

/* macros for BlueprintGlobalNameSpace::search_start_delay */
#ifndef __SEARCH_START_DELAY_MACRO__
#define __SEARCH_START_DELAY_MACRO__

/* macros for field search_start_delay_rifs */
#define SEARCH_START_DELAY__SEARCH_START_DELAY_RIFS__SHIFT                    0
#define SEARCH_START_DELAY__SEARCH_START_DELAY_RIFS__WIDTH                   12
#define SEARCH_START_DELAY__SEARCH_START_DELAY_RIFS__MASK           0x00000fffU
#define SEARCH_START_DELAY__SEARCH_START_DELAY_RIFS__READ(src) \
                    (u_int32_t)(src)\
                    & 0x00000fffU
#define SEARCH_START_DELAY__SEARCH_START_DELAY_RIFS__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x00000fffU)
#define SEARCH_START_DELAY__SEARCH_START_DELAY_RIFS__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000fffU) | ((u_int32_t)(src) &\
                    0x00000fffU)
#define SEARCH_START_DELAY__SEARCH_START_DELAY_RIFS__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00000fffU)))

/* macros for field search_start_delay_sifs */
#define SEARCH_START_DELAY__SEARCH_START_DELAY_SIFS__SHIFT                   16
#define SEARCH_START_DELAY__SEARCH_START_DELAY_SIFS__WIDTH                   12
#define SEARCH_START_DELAY__SEARCH_START_DELAY_SIFS__MASK           0x0fff0000U
#define SEARCH_START_DELAY__SEARCH_START_DELAY_SIFS__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0fff0000U) >> 16)
#define SEARCH_START_DELAY__SEARCH_START_DELAY_SIFS__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 16) & 0x0fff0000U)
#define SEARCH_START_DELAY__SEARCH_START_DELAY_SIFS__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0fff0000U) | (((u_int32_t)(src) <<\
                    16) & 0x0fff0000U)
#define SEARCH_START_DELAY__SEARCH_START_DELAY_SIFS__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 16) & ~0x0fff0000U)))

/* macros for field search_start_mask_sifs */
#define SEARCH_START_DELAY__SEARCH_START_MASK_SIFS__SHIFT                    28
#define SEARCH_START_DELAY__SEARCH_START_MASK_SIFS__WIDTH                     4
#define SEARCH_START_DELAY__SEARCH_START_MASK_SIFS__MASK            0xf0000000U
#define SEARCH_START_DELAY__SEARCH_START_MASK_SIFS__READ(src) \
                    (((u_int32_t)(src)\
                    & 0xf0000000U) >> 28)
#define SEARCH_START_DELAY__SEARCH_START_MASK_SIFS__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 28) & 0xf0000000U)
#define SEARCH_START_DELAY__SEARCH_START_MASK_SIFS__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xf0000000U) | (((u_int32_t)(src) <<\
                    28) & 0xf0000000U)
#define SEARCH_START_DELAY__SEARCH_START_MASK_SIFS__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 28) & ~0xf0000000U)))
#define SEARCH_START_DELAY__TYPE                                      u_int32_t
#define SEARCH_START_DELAY__READ                                    0xffff0fffU
#define SEARCH_START_DELAY__WRITE                                   0xffff0fffU

#endif /* __SEARCH_START_DELAY_MACRO__ */


/* macros for bb_reg_map.bb_sm_reg_map.BB_search_start_delay */
#define INST_BB_REG_MAP__BB_SM_REG_MAP__BB_SEARCH_START_DELAY__NUM            1

/* macros for BlueprintGlobalNameSpace::max_rx_length */
#ifndef __MAX_RX_LENGTH_MACRO__
#define __MAX_RX_LENGTH_MACRO__

/* macros for field max_rx_length */
#define MAX_RX_LENGTH__MAX_RX_LENGTH__SHIFT                                   0
#define MAX_RX_LENGTH__MAX_RX_LENGTH__WIDTH                                  12
#define MAX_RX_LENGTH__MAX_RX_LENGTH__MASK                          0x00000fffU
#define MAX_RX_LENGTH__MAX_RX_LENGTH__READ(src)  (u_int32_t)(src) & 0x00000fffU
#define MAX_RX_LENGTH__MAX_RX_LENGTH__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x00000fffU)
#define MAX_RX_LENGTH__MAX_RX_LENGTH__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000fffU) | ((u_int32_t)(src) &\
                    0x00000fffU)
#define MAX_RX_LENGTH__MAX_RX_LENGTH__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00000fffU)))

/* macros for field max_ht_length */
#define MAX_RX_LENGTH__MAX_HT_LENGTH__SHIFT                                  12
#define MAX_RX_LENGTH__MAX_HT_LENGTH__WIDTH                                  18
#define MAX_RX_LENGTH__MAX_HT_LENGTH__MASK                          0x3ffff000U
#define MAX_RX_LENGTH__MAX_HT_LENGTH__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x3ffff000U) >> 12)
#define MAX_RX_LENGTH__MAX_HT_LENGTH__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 12) & 0x3ffff000U)
#define MAX_RX_LENGTH__MAX_HT_LENGTH__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x3ffff000U) | (((u_int32_t)(src) <<\
                    12) & 0x3ffff000U)
#define MAX_RX_LENGTH__MAX_HT_LENGTH__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 12) & ~0x3ffff000U)))

/* macros for field max_ht_duration */
#define MAX_RX_LENGTH__MAX_HT_DURATION__SHIFT                                30
#define MAX_RX_LENGTH__MAX_HT_DURATION__WIDTH                                 2
#define MAX_RX_LENGTH__MAX_HT_DURATION__MASK                        0xc0000000U
#define MAX_RX_LENGTH__MAX_HT_DURATION__READ(src) \
                    (((u_int32_t)(src)\
                    & 0xc0000000U) >> 30)
#define MAX_RX_LENGTH__MAX_HT_DURATION__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 30) & 0xc0000000U)
#define MAX_RX_LENGTH__MAX_HT_DURATION__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xc0000000U) | (((u_int32_t)(src) <<\
                    30) & 0xc0000000U)
#define MAX_RX_LENGTH__MAX_HT_DURATION__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 30) & ~0xc0000000U)))
#define MAX_RX_LENGTH__TYPE                                           u_int32_t
#define MAX_RX_LENGTH__READ                                         0xffffffffU
#define MAX_RX_LENGTH__WRITE                                        0xffffffffU

#endif /* __MAX_RX_LENGTH_MACRO__ */


/* macros for bb_reg_map.bb_sm_reg_map.BB_max_rx_length */
#define INST_BB_REG_MAP__BB_SM_REG_MAP__BB_MAX_RX_LENGTH__NUM                 1

/* macros for BlueprintGlobalNameSpace::frame_control */
#ifndef __FRAME_CONTROL_MACRO__
#define __FRAME_CONTROL_MACRO__

/* macros for field cf_overlap_window */
#define FRAME_CONTROL__CF_OVERLAP_WINDOW__SHIFT                               0
#define FRAME_CONTROL__CF_OVERLAP_WINDOW__WIDTH                               2
#define FRAME_CONTROL__CF_OVERLAP_WINDOW__MASK                      0x00000003U
#define FRAME_CONTROL__CF_OVERLAP_WINDOW__READ(src) \
                    (u_int32_t)(src)\
                    & 0x00000003U
#define FRAME_CONTROL__CF_OVERLAP_WINDOW__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x00000003U)
#define FRAME_CONTROL__CF_OVERLAP_WINDOW__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000003U) | ((u_int32_t)(src) &\
                    0x00000003U)
#define FRAME_CONTROL__CF_OVERLAP_WINDOW__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00000003U)))

/* macros for field cf_tx_clip */
#define FRAME_CONTROL__CF_TX_CLIP__SHIFT                                      3
#define FRAME_CONTROL__CF_TX_CLIP__WIDTH                                      3
#define FRAME_CONTROL__CF_TX_CLIP__MASK                             0x00000038U
#define FRAME_CONTROL__CF_TX_CLIP__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000038U) >> 3)
#define FRAME_CONTROL__CF_TX_CLIP__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 3) & 0x00000038U)
#define FRAME_CONTROL__CF_TX_CLIP__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000038U) | (((u_int32_t)(src) <<\
                    3) & 0x00000038U)
#define FRAME_CONTROL__CF_TX_CLIP__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 3) & ~0x00000038U)))

/* macros for field cf_tx_doublesamp_dac */
#define FRAME_CONTROL__CF_TX_DOUBLESAMP_DAC__SHIFT                            6
#define FRAME_CONTROL__CF_TX_DOUBLESAMP_DAC__WIDTH                            2
#define FRAME_CONTROL__CF_TX_DOUBLESAMP_DAC__MASK                   0x000000c0U
#define FRAME_CONTROL__CF_TX_DOUBLESAMP_DAC__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x000000c0U) >> 6)
#define FRAME_CONTROL__CF_TX_DOUBLESAMP_DAC__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 6) & 0x000000c0U)
#define FRAME_CONTROL__CF_TX_DOUBLESAMP_DAC__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000000c0U) | (((u_int32_t)(src) <<\
                    6) & 0x000000c0U)
#define FRAME_CONTROL__CF_TX_DOUBLESAMP_DAC__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 6) & ~0x000000c0U)))

/* macros for field tx_end_adjust */
#define FRAME_CONTROL__TX_END_ADJUST__SHIFT                                   8
#define FRAME_CONTROL__TX_END_ADJUST__WIDTH                                   8
#define FRAME_CONTROL__TX_END_ADJUST__MASK                          0x0000ff00U
#define FRAME_CONTROL__TX_END_ADJUST__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0000ff00U) >> 8)
#define FRAME_CONTROL__TX_END_ADJUST__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 8) & 0x0000ff00U)
#define FRAME_CONTROL__TX_END_ADJUST__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000ff00U) | (((u_int32_t)(src) <<\
                    8) & 0x0000ff00U)
#define FRAME_CONTROL__TX_END_ADJUST__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 8) & ~0x0000ff00U)))

/* macros for field prepend_chan_info */
#define FRAME_CONTROL__PREPEND_CHAN_INFO__SHIFT                              16
#define FRAME_CONTROL__PREPEND_CHAN_INFO__WIDTH                               1
#define FRAME_CONTROL__PREPEND_CHAN_INFO__MASK                      0x00010000U
#define FRAME_CONTROL__PREPEND_CHAN_INFO__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00010000U) >> 16)
#define FRAME_CONTROL__PREPEND_CHAN_INFO__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 16) & 0x00010000U)
#define FRAME_CONTROL__PREPEND_CHAN_INFO__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00010000U) | (((u_int32_t)(src) <<\
                    16) & 0x00010000U)
#define FRAME_CONTROL__PREPEND_CHAN_INFO__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 16) & ~0x00010000U)))
#define FRAME_CONTROL__PREPEND_CHAN_INFO__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00010000U) | ((u_int32_t)(1) << 16)
#define FRAME_CONTROL__PREPEND_CHAN_INFO__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00010000U) | ((u_int32_t)(0) << 16)

/* macros for field short_high_par_norm */
#define FRAME_CONTROL__SHORT_HIGH_PAR_NORM__SHIFT                            17
#define FRAME_CONTROL__SHORT_HIGH_PAR_NORM__WIDTH                             1
#define FRAME_CONTROL__SHORT_HIGH_PAR_NORM__MASK                    0x00020000U
#define FRAME_CONTROL__SHORT_HIGH_PAR_NORM__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00020000U) >> 17)
#define FRAME_CONTROL__SHORT_HIGH_PAR_NORM__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 17) & 0x00020000U)
#define FRAME_CONTROL__SHORT_HIGH_PAR_NORM__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00020000U) | (((u_int32_t)(src) <<\
                    17) & 0x00020000U)
#define FRAME_CONTROL__SHORT_HIGH_PAR_NORM__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 17) & ~0x00020000U)))
#define FRAME_CONTROL__SHORT_HIGH_PAR_NORM__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00020000U) | ((u_int32_t)(1) << 17)
#define FRAME_CONTROL__SHORT_HIGH_PAR_NORM__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00020000U) | ((u_int32_t)(0) << 17)

/* macros for field en_err_green_field */
#define FRAME_CONTROL__EN_ERR_GREEN_FIELD__SHIFT                             18
#define FRAME_CONTROL__EN_ERR_GREEN_FIELD__WIDTH                              1
#define FRAME_CONTROL__EN_ERR_GREEN_FIELD__MASK                     0x00040000U
#define FRAME_CONTROL__EN_ERR_GREEN_FIELD__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00040000U) >> 18)
#define FRAME_CONTROL__EN_ERR_GREEN_FIELD__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 18) & 0x00040000U)
#define FRAME_CONTROL__EN_ERR_GREEN_FIELD__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00040000U) | (((u_int32_t)(src) <<\
                    18) & 0x00040000U)
#define FRAME_CONTROL__EN_ERR_GREEN_FIELD__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 18) & ~0x00040000U)))
#define FRAME_CONTROL__EN_ERR_GREEN_FIELD__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00040000U) | ((u_int32_t)(1) << 18)
#define FRAME_CONTROL__EN_ERR_GREEN_FIELD__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00040000U) | ((u_int32_t)(0) << 18)

/* macros for field en_err_static20_mode_ht40_packet */
#define FRAME_CONTROL__EN_ERR_STATIC20_MODE_HT40_PACKET__SHIFT               19
#define FRAME_CONTROL__EN_ERR_STATIC20_MODE_HT40_PACKET__WIDTH                1
#define FRAME_CONTROL__EN_ERR_STATIC20_MODE_HT40_PACKET__MASK       0x00080000U
#define FRAME_CONTROL__EN_ERR_STATIC20_MODE_HT40_PACKET__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00080000U) >> 19)
#define FRAME_CONTROL__EN_ERR_STATIC20_MODE_HT40_PACKET__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 19) & 0x00080000U)
#define FRAME_CONTROL__EN_ERR_STATIC20_MODE_HT40_PACKET__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00080000U) | (((u_int32_t)(src) <<\
                    19) & 0x00080000U)
#define FRAME_CONTROL__EN_ERR_STATIC20_MODE_HT40_PACKET__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 19) & ~0x00080000U)))
#define FRAME_CONTROL__EN_ERR_STATIC20_MODE_HT40_PACKET__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00080000U) | ((u_int32_t)(1) << 19)
#define FRAME_CONTROL__EN_ERR_STATIC20_MODE_HT40_PACKET__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00080000U) | ((u_int32_t)(0) << 19)

/* macros for field en_err_ofdm_xcorr */
#define FRAME_CONTROL__EN_ERR_OFDM_XCORR__SHIFT                              20
#define FRAME_CONTROL__EN_ERR_OFDM_XCORR__WIDTH                               1
#define FRAME_CONTROL__EN_ERR_OFDM_XCORR__MASK                      0x00100000U
#define FRAME_CONTROL__EN_ERR_OFDM_XCORR__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00100000U) >> 20)
#define FRAME_CONTROL__EN_ERR_OFDM_XCORR__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 20) & 0x00100000U)
#define FRAME_CONTROL__EN_ERR_OFDM_XCORR__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00100000U) | (((u_int32_t)(src) <<\
                    20) & 0x00100000U)
#define FRAME_CONTROL__EN_ERR_OFDM_XCORR__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 20) & ~0x00100000U)))
#define FRAME_CONTROL__EN_ERR_OFDM_XCORR__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00100000U) | ((u_int32_t)(1) << 20)
#define FRAME_CONTROL__EN_ERR_OFDM_XCORR__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00100000U) | ((u_int32_t)(0) << 20)

/* macros for field en_err_long_sc_thr */
#define FRAME_CONTROL__EN_ERR_LONG_SC_THR__SHIFT                             21
#define FRAME_CONTROL__EN_ERR_LONG_SC_THR__WIDTH                              1
#define FRAME_CONTROL__EN_ERR_LONG_SC_THR__MASK                     0x00200000U
#define FRAME_CONTROL__EN_ERR_LONG_SC_THR__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00200000U) >> 21)
#define FRAME_CONTROL__EN_ERR_LONG_SC_THR__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 21) & 0x00200000U)
#define FRAME_CONTROL__EN_ERR_LONG_SC_THR__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00200000U) | (((u_int32_t)(src) <<\
                    21) & 0x00200000U)
#define FRAME_CONTROL__EN_ERR_LONG_SC_THR__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 21) & ~0x00200000U)))
#define FRAME_CONTROL__EN_ERR_LONG_SC_THR__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00200000U) | ((u_int32_t)(1) << 21)
#define FRAME_CONTROL__EN_ERR_LONG_SC_THR__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00200000U) | ((u_int32_t)(0) << 21)

/* macros for field en_err_tim_long1 */
#define FRAME_CONTROL__EN_ERR_TIM_LONG1__SHIFT                               22
#define FRAME_CONTROL__EN_ERR_TIM_LONG1__WIDTH                                1
#define FRAME_CONTROL__EN_ERR_TIM_LONG1__MASK                       0x00400000U
#define FRAME_CONTROL__EN_ERR_TIM_LONG1__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00400000U) >> 22)
#define FRAME_CONTROL__EN_ERR_TIM_LONG1__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 22) & 0x00400000U)
#define FRAME_CONTROL__EN_ERR_TIM_LONG1__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00400000U) | (((u_int32_t)(src) <<\
                    22) & 0x00400000U)
#define FRAME_CONTROL__EN_ERR_TIM_LONG1__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 22) & ~0x00400000U)))
#define FRAME_CONTROL__EN_ERR_TIM_LONG1__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00400000U) | ((u_int32_t)(1) << 22)
#define FRAME_CONTROL__EN_ERR_TIM_LONG1__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00400000U) | ((u_int32_t)(0) << 22)

/* macros for field en_err_tim_early_trig */
#define FRAME_CONTROL__EN_ERR_TIM_EARLY_TRIG__SHIFT                          23
#define FRAME_CONTROL__EN_ERR_TIM_EARLY_TRIG__WIDTH                           1
#define FRAME_CONTROL__EN_ERR_TIM_EARLY_TRIG__MASK                  0x00800000U
#define FRAME_CONTROL__EN_ERR_TIM_EARLY_TRIG__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00800000U) >> 23)
#define FRAME_CONTROL__EN_ERR_TIM_EARLY_TRIG__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 23) & 0x00800000U)
#define FRAME_CONTROL__EN_ERR_TIM_EARLY_TRIG__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00800000U) | (((u_int32_t)(src) <<\
                    23) & 0x00800000U)
#define FRAME_CONTROL__EN_ERR_TIM_EARLY_TRIG__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 23) & ~0x00800000U)))
#define FRAME_CONTROL__EN_ERR_TIM_EARLY_TRIG__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00800000U) | ((u_int32_t)(1) << 23)
#define FRAME_CONTROL__EN_ERR_TIM_EARLY_TRIG__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00800000U) | ((u_int32_t)(0) << 23)

/* macros for field en_err_tim_timeout */
#define FRAME_CONTROL__EN_ERR_TIM_TIMEOUT__SHIFT                             24
#define FRAME_CONTROL__EN_ERR_TIM_TIMEOUT__WIDTH                              1
#define FRAME_CONTROL__EN_ERR_TIM_TIMEOUT__MASK                     0x01000000U
#define FRAME_CONTROL__EN_ERR_TIM_TIMEOUT__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x01000000U) >> 24)
#define FRAME_CONTROL__EN_ERR_TIM_TIMEOUT__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 24) & 0x01000000U)
#define FRAME_CONTROL__EN_ERR_TIM_TIMEOUT__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x01000000U) | (((u_int32_t)(src) <<\
                    24) & 0x01000000U)
#define FRAME_CONTROL__EN_ERR_TIM_TIMEOUT__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 24) & ~0x01000000U)))
#define FRAME_CONTROL__EN_ERR_TIM_TIMEOUT__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x01000000U) | ((u_int32_t)(1) << 24)
#define FRAME_CONTROL__EN_ERR_TIM_TIMEOUT__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x01000000U) | ((u_int32_t)(0) << 24)

/* macros for field en_err_signal_parity */
#define FRAME_CONTROL__EN_ERR_SIGNAL_PARITY__SHIFT                           25
#define FRAME_CONTROL__EN_ERR_SIGNAL_PARITY__WIDTH                            1
#define FRAME_CONTROL__EN_ERR_SIGNAL_PARITY__MASK                   0x02000000U
#define FRAME_CONTROL__EN_ERR_SIGNAL_PARITY__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x02000000U) >> 25)
#define FRAME_CONTROL__EN_ERR_SIGNAL_PARITY__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 25) & 0x02000000U)
#define FRAME_CONTROL__EN_ERR_SIGNAL_PARITY__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x02000000U) | (((u_int32_t)(src) <<\
                    25) & 0x02000000U)
#define FRAME_CONTROL__EN_ERR_SIGNAL_PARITY__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 25) & ~0x02000000U)))
#define FRAME_CONTROL__EN_ERR_SIGNAL_PARITY__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x02000000U) | ((u_int32_t)(1) << 25)
#define FRAME_CONTROL__EN_ERR_SIGNAL_PARITY__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x02000000U) | ((u_int32_t)(0) << 25)

/* macros for field en_err_rate_illegal */
#define FRAME_CONTROL__EN_ERR_RATE_ILLEGAL__SHIFT                            26
#define FRAME_CONTROL__EN_ERR_RATE_ILLEGAL__WIDTH                             1
#define FRAME_CONTROL__EN_ERR_RATE_ILLEGAL__MASK                    0x04000000U
#define FRAME_CONTROL__EN_ERR_RATE_ILLEGAL__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x04000000U) >> 26)
#define FRAME_CONTROL__EN_ERR_RATE_ILLEGAL__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 26) & 0x04000000U)
#define FRAME_CONTROL__EN_ERR_RATE_ILLEGAL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x04000000U) | (((u_int32_t)(src) <<\
                    26) & 0x04000000U)
#define FRAME_CONTROL__EN_ERR_RATE_ILLEGAL__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 26) & ~0x04000000U)))
#define FRAME_CONTROL__EN_ERR_RATE_ILLEGAL__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x04000000U) | ((u_int32_t)(1) << 26)
#define FRAME_CONTROL__EN_ERR_RATE_ILLEGAL__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x04000000U) | ((u_int32_t)(0) << 26)

/* macros for field en_err_length_illegal */
#define FRAME_CONTROL__EN_ERR_LENGTH_ILLEGAL__SHIFT                          27
#define FRAME_CONTROL__EN_ERR_LENGTH_ILLEGAL__WIDTH                           1
#define FRAME_CONTROL__EN_ERR_LENGTH_ILLEGAL__MASK                  0x08000000U
#define FRAME_CONTROL__EN_ERR_LENGTH_ILLEGAL__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x08000000U) >> 27)
#define FRAME_CONTROL__EN_ERR_LENGTH_ILLEGAL__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 27) & 0x08000000U)
#define FRAME_CONTROL__EN_ERR_LENGTH_ILLEGAL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x08000000U) | (((u_int32_t)(src) <<\
                    27) & 0x08000000U)
#define FRAME_CONTROL__EN_ERR_LENGTH_ILLEGAL__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 27) & ~0x08000000U)))
#define FRAME_CONTROL__EN_ERR_LENGTH_ILLEGAL__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x08000000U) | ((u_int32_t)(1) << 27)
#define FRAME_CONTROL__EN_ERR_LENGTH_ILLEGAL__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x08000000U) | ((u_int32_t)(0) << 27)

/* macros for field no_6mbps_service_err */
#define FRAME_CONTROL__NO_6MBPS_SERVICE_ERR__SHIFT                           28
#define FRAME_CONTROL__NO_6MBPS_SERVICE_ERR__WIDTH                            1
#define FRAME_CONTROL__NO_6MBPS_SERVICE_ERR__MASK                   0x10000000U
#define FRAME_CONTROL__NO_6MBPS_SERVICE_ERR__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x10000000U) >> 28)
#define FRAME_CONTROL__NO_6MBPS_SERVICE_ERR__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 28) & 0x10000000U)
#define FRAME_CONTROL__NO_6MBPS_SERVICE_ERR__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x10000000U) | (((u_int32_t)(src) <<\
                    28) & 0x10000000U)
#define FRAME_CONTROL__NO_6MBPS_SERVICE_ERR__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 28) & ~0x10000000U)))
#define FRAME_CONTROL__NO_6MBPS_SERVICE_ERR__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x10000000U) | ((u_int32_t)(1) << 28)
#define FRAME_CONTROL__NO_6MBPS_SERVICE_ERR__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x10000000U) | ((u_int32_t)(0) << 28)

/* macros for field en_err_service */
#define FRAME_CONTROL__EN_ERR_SERVICE__SHIFT                                 29
#define FRAME_CONTROL__EN_ERR_SERVICE__WIDTH                                  1
#define FRAME_CONTROL__EN_ERR_SERVICE__MASK                         0x20000000U
#define FRAME_CONTROL__EN_ERR_SERVICE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x20000000U) >> 29)
#define FRAME_CONTROL__EN_ERR_SERVICE__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 29) & 0x20000000U)
#define FRAME_CONTROL__EN_ERR_SERVICE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x20000000U) | (((u_int32_t)(src) <<\
                    29) & 0x20000000U)
#define FRAME_CONTROL__EN_ERR_SERVICE__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 29) & ~0x20000000U)))
#define FRAME_CONTROL__EN_ERR_SERVICE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x20000000U) | ((u_int32_t)(1) << 29)
#define FRAME_CONTROL__EN_ERR_SERVICE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x20000000U) | ((u_int32_t)(0) << 29)

/* macros for field en_err_tx_underrun */
#define FRAME_CONTROL__EN_ERR_TX_UNDERRUN__SHIFT                             30
#define FRAME_CONTROL__EN_ERR_TX_UNDERRUN__WIDTH                              1
#define FRAME_CONTROL__EN_ERR_TX_UNDERRUN__MASK                     0x40000000U
#define FRAME_CONTROL__EN_ERR_TX_UNDERRUN__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x40000000U) >> 30)
#define FRAME_CONTROL__EN_ERR_TX_UNDERRUN__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 30) & 0x40000000U)
#define FRAME_CONTROL__EN_ERR_TX_UNDERRUN__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x40000000U) | (((u_int32_t)(src) <<\
                    30) & 0x40000000U)
#define FRAME_CONTROL__EN_ERR_TX_UNDERRUN__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 30) & ~0x40000000U)))
#define FRAME_CONTROL__EN_ERR_TX_UNDERRUN__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x40000000U) | ((u_int32_t)(1) << 30)
#define FRAME_CONTROL__EN_ERR_TX_UNDERRUN__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x40000000U) | ((u_int32_t)(0) << 30)

/* macros for field en_err_rx_abort */
#define FRAME_CONTROL__EN_ERR_RX_ABORT__SHIFT                                31
#define FRAME_CONTROL__EN_ERR_RX_ABORT__WIDTH                                 1
#define FRAME_CONTROL__EN_ERR_RX_ABORT__MASK                        0x80000000U
#define FRAME_CONTROL__EN_ERR_RX_ABORT__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x80000000U) >> 31)
#define FRAME_CONTROL__EN_ERR_RX_ABORT__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 31) & 0x80000000U)
#define FRAME_CONTROL__EN_ERR_RX_ABORT__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x80000000U) | (((u_int32_t)(src) <<\
                    31) & 0x80000000U)
#define FRAME_CONTROL__EN_ERR_RX_ABORT__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 31) & ~0x80000000U)))
#define FRAME_CONTROL__EN_ERR_RX_ABORT__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x80000000U) | ((u_int32_t)(1) << 31)
#define FRAME_CONTROL__EN_ERR_RX_ABORT__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x80000000U) | ((u_int32_t)(0) << 31)
#define FRAME_CONTROL__TYPE                                           u_int32_t
#define FRAME_CONTROL__READ                                         0xfffffffbU
#define FRAME_CONTROL__WRITE                                        0xfffffffbU

#endif /* __FRAME_CONTROL_MACRO__ */


/* macros for bb_reg_map.bb_sm_reg_map.BB_frame_control */
#define INST_BB_REG_MAP__BB_SM_REG_MAP__BB_FRAME_CONTROL__NUM                 1

/* macros for BlueprintGlobalNameSpace::rfbus_request */
#ifndef __RFBUS_REQUEST_MACRO__
#define __RFBUS_REQUEST_MACRO__

/* macros for field rfbus_request */
#define RFBUS_REQUEST__RFBUS_REQUEST__SHIFT                                   0
#define RFBUS_REQUEST__RFBUS_REQUEST__WIDTH                                   1
#define RFBUS_REQUEST__RFBUS_REQUEST__MASK                          0x00000001U
#define RFBUS_REQUEST__RFBUS_REQUEST__READ(src)  (u_int32_t)(src) & 0x00000001U
#define RFBUS_REQUEST__RFBUS_REQUEST__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x00000001U)
#define RFBUS_REQUEST__RFBUS_REQUEST__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | ((u_int32_t)(src) &\
                    0x00000001U)
#define RFBUS_REQUEST__RFBUS_REQUEST__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00000001U)))
#define RFBUS_REQUEST__RFBUS_REQUEST__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(1)
#define RFBUS_REQUEST__RFBUS_REQUEST__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(0)
#define RFBUS_REQUEST__TYPE                                           u_int32_t
#define RFBUS_REQUEST__READ                                         0x00000001U
#define RFBUS_REQUEST__WRITE                                        0x00000001U

#endif /* __RFBUS_REQUEST_MACRO__ */


/* macros for bb_reg_map.bb_sm_reg_map.BB_rfbus_request */
#define INST_BB_REG_MAP__BB_SM_REG_MAP__BB_RFBUS_REQUEST__NUM                 1

/* macros for BlueprintGlobalNameSpace::rfbus_grant */
#ifndef __RFBUS_GRANT_MACRO__
#define __RFBUS_GRANT_MACRO__

/* macros for field rfbus_grant */
#define RFBUS_GRANT__RFBUS_GRANT__SHIFT                                       0
#define RFBUS_GRANT__RFBUS_GRANT__WIDTH                                       1
#define RFBUS_GRANT__RFBUS_GRANT__MASK                              0x00000001U
#define RFBUS_GRANT__RFBUS_GRANT__READ(src)      (u_int32_t)(src) & 0x00000001U
#define RFBUS_GRANT__RFBUS_GRANT__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(1)
#define RFBUS_GRANT__RFBUS_GRANT__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(0)

/* macros for field bt_ant */
#define RFBUS_GRANT__BT_ANT__SHIFT                                            1
#define RFBUS_GRANT__BT_ANT__WIDTH                                            1
#define RFBUS_GRANT__BT_ANT__MASK                                   0x00000002U
#define RFBUS_GRANT__BT_ANT__READ(src)  (((u_int32_t)(src) & 0x00000002U) >> 1)
#define RFBUS_GRANT__BT_ANT__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | ((u_int32_t)(1) << 1)
#define RFBUS_GRANT__BT_ANT__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | ((u_int32_t)(0) << 1)
#define RFBUS_GRANT__TYPE                                             u_int32_t
#define RFBUS_GRANT__READ                                           0x00000003U

#endif /* __RFBUS_GRANT_MACRO__ */


/* macros for bb_reg_map.bb_sm_reg_map.BB_rfbus_grant */
#define INST_BB_REG_MAP__BB_SM_REG_MAP__BB_RFBUS_GRANT__NUM                   1

/* macros for BlueprintGlobalNameSpace::rifs */
#ifndef __RIFS_MACRO__
#define __RIFS_MACRO__

/* macros for field rifs_eco_disable */
#define RIFS__RIFS_ECO_DISABLE__SHIFT                                         0
#define RIFS__RIFS_ECO_DISABLE__WIDTH                                        24
#define RIFS__RIFS_ECO_DISABLE__MASK                                0x00ffffffU
#define RIFS__RIFS_ECO_DISABLE__READ(src)        (u_int32_t)(src) & 0x00ffffffU
#define RIFS__RIFS_ECO_DISABLE__WRITE(src)     ((u_int32_t)(src) & 0x00ffffffU)
#define RIFS__RIFS_ECO_DISABLE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00ffffffU) | ((u_int32_t)(src) &\
                    0x00ffffffU)
#define RIFS__RIFS_ECO_DISABLE__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00ffffffU)))

/* macros for field enable_reset_tdomain */
#define RIFS__ENABLE_RESET_TDOMAIN__SHIFT                                    26
#define RIFS__ENABLE_RESET_TDOMAIN__WIDTH                                     1
#define RIFS__ENABLE_RESET_TDOMAIN__MASK                            0x04000000U
#define RIFS__ENABLE_RESET_TDOMAIN__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x04000000U) >> 26)
#define RIFS__ENABLE_RESET_TDOMAIN__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 26) & 0x04000000U)
#define RIFS__ENABLE_RESET_TDOMAIN__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x04000000U) | (((u_int32_t)(src) <<\
                    26) & 0x04000000U)
#define RIFS__ENABLE_RESET_TDOMAIN__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 26) & ~0x04000000U)))
#define RIFS__ENABLE_RESET_TDOMAIN__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x04000000U) | ((u_int32_t)(1) << 26)
#define RIFS__ENABLE_RESET_TDOMAIN__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x04000000U) | ((u_int32_t)(0) << 26)

/* macros for field disable_rx_mask_mac_wait */
#define RIFS__DISABLE_RX_MASK_MAC_WAIT__SHIFT                                27
#define RIFS__DISABLE_RX_MASK_MAC_WAIT__WIDTH                                 1
#define RIFS__DISABLE_RX_MASK_MAC_WAIT__MASK                        0x08000000U
#define RIFS__DISABLE_RX_MASK_MAC_WAIT__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x08000000U) >> 27)
#define RIFS__DISABLE_RX_MASK_MAC_WAIT__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 27) & 0x08000000U)
#define RIFS__DISABLE_RX_MASK_MAC_WAIT__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x08000000U) | (((u_int32_t)(src) <<\
                    27) & 0x08000000U)
#define RIFS__DISABLE_RX_MASK_MAC_WAIT__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 27) & ~0x08000000U)))
#define RIFS__DISABLE_RX_MASK_MAC_WAIT__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x08000000U) | ((u_int32_t)(1) << 27)
#define RIFS__DISABLE_RX_MASK_MAC_WAIT__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x08000000U) | ((u_int32_t)(0) << 27)
#define RIFS__TYPE                                                    u_int32_t
#define RIFS__READ                                                  0x0cffffffU
#define RIFS__WRITE                                                 0x0cffffffU

#endif /* __RIFS_MACRO__ */


/* macros for bb_reg_map.bb_sm_reg_map.BB_rifs */
#define INST_BB_REG_MAP__BB_SM_REG_MAP__BB_RIFS__NUM                          1

/* macros for BlueprintGlobalNameSpace::pmi_debug_status */
#ifndef __PMI_DEBUG_STATUS_MACRO__
#define __PMI_DEBUG_STATUS_MACRO__

/* macros for field pmi_debug_status */
#define PMI_DEBUG_STATUS__PMI_DEBUG_STATUS__SHIFT                             0
#define PMI_DEBUG_STATUS__PMI_DEBUG_STATUS__WIDTH                            32
#define PMI_DEBUG_STATUS__PMI_DEBUG_STATUS__MASK                    0xffffffffU
#define PMI_DEBUG_STATUS__PMI_DEBUG_STATUS__READ(src) \
                    (u_int32_t)(src)\
                    & 0xffffffffU
#define PMI_DEBUG_STATUS__TYPE                                        u_int32_t
#define PMI_DEBUG_STATUS__READ                                      0xffffffffU

#endif /* __PMI_DEBUG_STATUS_MACRO__ */


/* macros for bb_reg_map.bb_sm_reg_map.BB_pmi_debug_status */
#define INST_BB_REG_MAP__BB_SM_REG_MAP__BB_PMI_DEBUG_STATUS__NUM              1

/* macros for BlueprintGlobalNameSpace::rx_clear_delay */
#ifndef __RX_CLEAR_DELAY_MACRO__
#define __RX_CLEAR_DELAY_MACRO__

/* macros for field ofdm_rx_clear_delay */
#define RX_CLEAR_DELAY__OFDM_RX_CLEAR_DELAY__SHIFT                            0
#define RX_CLEAR_DELAY__OFDM_RX_CLEAR_DELAY__WIDTH                           10
#define RX_CLEAR_DELAY__OFDM_RX_CLEAR_DELAY__MASK                   0x000003ffU
#define RX_CLEAR_DELAY__OFDM_RX_CLEAR_DELAY__READ(src) \
                    (u_int32_t)(src)\
                    & 0x000003ffU
#define RX_CLEAR_DELAY__OFDM_RX_CLEAR_DELAY__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x000003ffU)
#define RX_CLEAR_DELAY__OFDM_RX_CLEAR_DELAY__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000003ffU) | ((u_int32_t)(src) &\
                    0x000003ffU)
#define RX_CLEAR_DELAY__OFDM_RX_CLEAR_DELAY__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x000003ffU)))

/* macros for field ndp_timeout_fdomain_delay */
#define RX_CLEAR_DELAY__NDP_TIMEOUT_FDOMAIN_DELAY__SHIFT                     10
#define RX_CLEAR_DELAY__NDP_TIMEOUT_FDOMAIN_DELAY__WIDTH                      3
#define RX_CLEAR_DELAY__NDP_TIMEOUT_FDOMAIN_DELAY__MASK             0x00001c00U
#define RX_CLEAR_DELAY__NDP_TIMEOUT_FDOMAIN_DELAY__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00001c00U) >> 10)
#define RX_CLEAR_DELAY__NDP_TIMEOUT_FDOMAIN_DELAY__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 10) & 0x00001c00U)
#define RX_CLEAR_DELAY__NDP_TIMEOUT_FDOMAIN_DELAY__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00001c00U) | (((u_int32_t)(src) <<\
                    10) & 0x00001c00U)
#define RX_CLEAR_DELAY__NDP_TIMEOUT_FDOMAIN_DELAY__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 10) & ~0x00001c00U)))
#define RX_CLEAR_DELAY__TYPE                                          u_int32_t
#define RX_CLEAR_DELAY__READ                                        0x00001fffU
#define RX_CLEAR_DELAY__WRITE                                       0x00001fffU

#endif /* __RX_CLEAR_DELAY_MACRO__ */


/* macros for bb_reg_map.bb_sm_reg_map.BB_rx_clear_delay */
#define INST_BB_REG_MAP__BB_SM_REG_MAP__BB_RX_CLEAR_DELAY__NUM                1

/* macros for BlueprintGlobalNameSpace::analog_power_on_time */
#ifndef __ANALOG_POWER_ON_TIME_MACRO__
#define __ANALOG_POWER_ON_TIME_MACRO__

/* macros for field active_to_receive */
#define ANALOG_POWER_ON_TIME__ACTIVE_TO_RECEIVE__SHIFT                        0
#define ANALOG_POWER_ON_TIME__ACTIVE_TO_RECEIVE__WIDTH                       14
#define ANALOG_POWER_ON_TIME__ACTIVE_TO_RECEIVE__MASK               0x00003fffU
#define ANALOG_POWER_ON_TIME__ACTIVE_TO_RECEIVE__READ(src) \
                    (u_int32_t)(src)\
                    & 0x00003fffU
#define ANALOG_POWER_ON_TIME__ACTIVE_TO_RECEIVE__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x00003fffU)
#define ANALOG_POWER_ON_TIME__ACTIVE_TO_RECEIVE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00003fffU) | ((u_int32_t)(src) &\
                    0x00003fffU)
#define ANALOG_POWER_ON_TIME__ACTIVE_TO_RECEIVE__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00003fffU)))
#define ANALOG_POWER_ON_TIME__TYPE                                    u_int32_t
#define ANALOG_POWER_ON_TIME__READ                                  0x00003fffU
#define ANALOG_POWER_ON_TIME__WRITE                                 0x00003fffU

#endif /* __ANALOG_POWER_ON_TIME_MACRO__ */


/* macros for bb_reg_map.bb_sm_reg_map.BB_analog_power_on_time */
#define INST_BB_REG_MAP__BB_SM_REG_MAP__BB_ANALOG_POWER_ON_TIME__NUM          1

/* macros for BlueprintGlobalNameSpace::tx_timing_1 */
#ifndef __TX_TIMING_1_MACRO__
#define __TX_TIMING_1_MACRO__

/* macros for field tx_frame_to_adc_off */
#define TX_TIMING_1__TX_FRAME_TO_ADC_OFF__SHIFT                               0
#define TX_TIMING_1__TX_FRAME_TO_ADC_OFF__WIDTH                               8
#define TX_TIMING_1__TX_FRAME_TO_ADC_OFF__MASK                      0x000000ffU
#define TX_TIMING_1__TX_FRAME_TO_ADC_OFF__READ(src) \
                    (u_int32_t)(src)\
                    & 0x000000ffU
#define TX_TIMING_1__TX_FRAME_TO_ADC_OFF__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x000000ffU)
#define TX_TIMING_1__TX_FRAME_TO_ADC_OFF__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000000ffU) | ((u_int32_t)(src) &\
                    0x000000ffU)
#define TX_TIMING_1__TX_FRAME_TO_ADC_OFF__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x000000ffU)))

/* macros for field tx_frame_to_a2_rx_off */
#define TX_TIMING_1__TX_FRAME_TO_A2_RX_OFF__SHIFT                             8
#define TX_TIMING_1__TX_FRAME_TO_A2_RX_OFF__WIDTH                             8
#define TX_TIMING_1__TX_FRAME_TO_A2_RX_OFF__MASK                    0x0000ff00U
#define TX_TIMING_1__TX_FRAME_TO_A2_RX_OFF__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0000ff00U) >> 8)
#define TX_TIMING_1__TX_FRAME_TO_A2_RX_OFF__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 8) & 0x0000ff00U)
#define TX_TIMING_1__TX_FRAME_TO_A2_RX_OFF__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000ff00U) | (((u_int32_t)(src) <<\
                    8) & 0x0000ff00U)
#define TX_TIMING_1__TX_FRAME_TO_A2_RX_OFF__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 8) & ~0x0000ff00U)))

/* macros for field tx_frame_to_dac_on */
#define TX_TIMING_1__TX_FRAME_TO_DAC_ON__SHIFT                               16
#define TX_TIMING_1__TX_FRAME_TO_DAC_ON__WIDTH                                8
#define TX_TIMING_1__TX_FRAME_TO_DAC_ON__MASK                       0x00ff0000U
#define TX_TIMING_1__TX_FRAME_TO_DAC_ON__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00ff0000U) >> 16)
#define TX_TIMING_1__TX_FRAME_TO_DAC_ON__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 16) & 0x00ff0000U)
#define TX_TIMING_1__TX_FRAME_TO_DAC_ON__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00ff0000U) | (((u_int32_t)(src) <<\
                    16) & 0x00ff0000U)
#define TX_TIMING_1__TX_FRAME_TO_DAC_ON__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 16) & ~0x00ff0000U)))

/* macros for field tx_frame_to_a2_tx_on */
#define TX_TIMING_1__TX_FRAME_TO_A2_TX_ON__SHIFT                             24
#define TX_TIMING_1__TX_FRAME_TO_A2_TX_ON__WIDTH                              8
#define TX_TIMING_1__TX_FRAME_TO_A2_TX_ON__MASK                     0xff000000U
#define TX_TIMING_1__TX_FRAME_TO_A2_TX_ON__READ(src) \
                    (((u_int32_t)(src)\
                    & 0xff000000U) >> 24)
#define TX_TIMING_1__TX_FRAME_TO_A2_TX_ON__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 24) & 0xff000000U)
#define TX_TIMING_1__TX_FRAME_TO_A2_TX_ON__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xff000000U) | (((u_int32_t)(src) <<\
                    24) & 0xff000000U)
#define TX_TIMING_1__TX_FRAME_TO_A2_TX_ON__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 24) & ~0xff000000U)))
#define TX_TIMING_1__TYPE                                             u_int32_t
#define TX_TIMING_1__READ                                           0xffffffffU
#define TX_TIMING_1__WRITE                                          0xffffffffU

#endif /* __TX_TIMING_1_MACRO__ */


/* macros for bb_reg_map.bb_sm_reg_map.BB_tx_timing_1 */
#define INST_BB_REG_MAP__BB_SM_REG_MAP__BB_TX_TIMING_1__NUM                   1

/* macros for BlueprintGlobalNameSpace::tx_timing_2 */
#ifndef __TX_TIMING_2_MACRO__
#define __TX_TIMING_2_MACRO__

/* macros for field tx_frame_to_tx_d_start */
#define TX_TIMING_2__TX_FRAME_TO_TX_D_START__SHIFT                            0
#define TX_TIMING_2__TX_FRAME_TO_TX_D_START__WIDTH                            8
#define TX_TIMING_2__TX_FRAME_TO_TX_D_START__MASK                   0x000000ffU
#define TX_TIMING_2__TX_FRAME_TO_TX_D_START__READ(src) \
                    (u_int32_t)(src)\
                    & 0x000000ffU
#define TX_TIMING_2__TX_FRAME_TO_TX_D_START__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x000000ffU)
#define TX_TIMING_2__TX_FRAME_TO_TX_D_START__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000000ffU) | ((u_int32_t)(src) &\
                    0x000000ffU)
#define TX_TIMING_2__TX_FRAME_TO_TX_D_START__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x000000ffU)))

/* macros for field tx_frame_to_pa_on */
#define TX_TIMING_2__TX_FRAME_TO_PA_ON__SHIFT                                 8
#define TX_TIMING_2__TX_FRAME_TO_PA_ON__WIDTH                                 8
#define TX_TIMING_2__TX_FRAME_TO_PA_ON__MASK                        0x0000ff00U
#define TX_TIMING_2__TX_FRAME_TO_PA_ON__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0000ff00U) >> 8)
#define TX_TIMING_2__TX_FRAME_TO_PA_ON__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 8) & 0x0000ff00U)
#define TX_TIMING_2__TX_FRAME_TO_PA_ON__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000ff00U) | (((u_int32_t)(src) <<\
                    8) & 0x0000ff00U)
#define TX_TIMING_2__TX_FRAME_TO_PA_ON__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 8) & ~0x0000ff00U)))

/* macros for field tx_end_to_pa_off */
#define TX_TIMING_2__TX_END_TO_PA_OFF__SHIFT                                 16
#define TX_TIMING_2__TX_END_TO_PA_OFF__WIDTH                                  8
#define TX_TIMING_2__TX_END_TO_PA_OFF__MASK                         0x00ff0000U
#define TX_TIMING_2__TX_END_TO_PA_OFF__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00ff0000U) >> 16)
#define TX_TIMING_2__TX_END_TO_PA_OFF__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 16) & 0x00ff0000U)
#define TX_TIMING_2__TX_END_TO_PA_OFF__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00ff0000U) | (((u_int32_t)(src) <<\
                    16) & 0x00ff0000U)
#define TX_TIMING_2__TX_END_TO_PA_OFF__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 16) & ~0x00ff0000U)))

/* macros for field tx_end_to_a2_tx_off */
#define TX_TIMING_2__TX_END_TO_A2_TX_OFF__SHIFT                              24
#define TX_TIMING_2__TX_END_TO_A2_TX_OFF__WIDTH                               8
#define TX_TIMING_2__TX_END_TO_A2_TX_OFF__MASK                      0xff000000U
#define TX_TIMING_2__TX_END_TO_A2_TX_OFF__READ(src) \
                    (((u_int32_t)(src)\
                    & 0xff000000U) >> 24)
#define TX_TIMING_2__TX_END_TO_A2_TX_OFF__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 24) & 0xff000000U)
#define TX_TIMING_2__TX_END_TO_A2_TX_OFF__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xff000000U) | (((u_int32_t)(src) <<\
                    24) & 0xff000000U)
#define TX_TIMING_2__TX_END_TO_A2_TX_OFF__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 24) & ~0xff000000U)))
#define TX_TIMING_2__TYPE                                             u_int32_t
#define TX_TIMING_2__READ                                           0xffffffffU
#define TX_TIMING_2__WRITE                                          0xffffffffU

#endif /* __TX_TIMING_2_MACRO__ */


/* macros for bb_reg_map.bb_sm_reg_map.BB_tx_timing_2 */
#define INST_BB_REG_MAP__BB_SM_REG_MAP__BB_TX_TIMING_2__NUM                   1

/* macros for BlueprintGlobalNameSpace::tx_timing_3 */
#ifndef __TX_TIMING_3_MACRO__
#define __TX_TIMING_3_MACRO__

/* macros for field tx_end_to_dac_off */
#define TX_TIMING_3__TX_END_TO_DAC_OFF__SHIFT                                 0
#define TX_TIMING_3__TX_END_TO_DAC_OFF__WIDTH                                 8
#define TX_TIMING_3__TX_END_TO_DAC_OFF__MASK                        0x000000ffU
#define TX_TIMING_3__TX_END_TO_DAC_OFF__READ(src) \
                    (u_int32_t)(src)\
                    & 0x000000ffU
#define TX_TIMING_3__TX_END_TO_DAC_OFF__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x000000ffU)
#define TX_TIMING_3__TX_END_TO_DAC_OFF__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000000ffU) | ((u_int32_t)(src) &\
                    0x000000ffU)
#define TX_TIMING_3__TX_END_TO_DAC_OFF__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x000000ffU)))

/* macros for field tx_frame_to_therm_chain_on */
#define TX_TIMING_3__TX_FRAME_TO_THERM_CHAIN_ON__SHIFT                        8
#define TX_TIMING_3__TX_FRAME_TO_THERM_CHAIN_ON__WIDTH                        8
#define TX_TIMING_3__TX_FRAME_TO_THERM_CHAIN_ON__MASK               0x0000ff00U
#define TX_TIMING_3__TX_FRAME_TO_THERM_CHAIN_ON__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0000ff00U) >> 8)
#define TX_TIMING_3__TX_FRAME_TO_THERM_CHAIN_ON__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 8) & 0x0000ff00U)
#define TX_TIMING_3__TX_FRAME_TO_THERM_CHAIN_ON__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000ff00U) | (((u_int32_t)(src) <<\
                    8) & 0x0000ff00U)
#define TX_TIMING_3__TX_FRAME_TO_THERM_CHAIN_ON__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 8) & ~0x0000ff00U)))

/* macros for field tx_end_to_a2_rx_on */
#define TX_TIMING_3__TX_END_TO_A2_RX_ON__SHIFT                               16
#define TX_TIMING_3__TX_END_TO_A2_RX_ON__WIDTH                                8
#define TX_TIMING_3__TX_END_TO_A2_RX_ON__MASK                       0x00ff0000U
#define TX_TIMING_3__TX_END_TO_A2_RX_ON__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00ff0000U) >> 16)
#define TX_TIMING_3__TX_END_TO_A2_RX_ON__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 16) & 0x00ff0000U)
#define TX_TIMING_3__TX_END_TO_A2_RX_ON__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00ff0000U) | (((u_int32_t)(src) <<\
                    16) & 0x00ff0000U)
#define TX_TIMING_3__TX_END_TO_A2_RX_ON__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 16) & ~0x00ff0000U)))

/* macros for field tx_end_to_adc_on */
#define TX_TIMING_3__TX_END_TO_ADC_ON__SHIFT                                 24
#define TX_TIMING_3__TX_END_TO_ADC_ON__WIDTH                                  8
#define TX_TIMING_3__TX_END_TO_ADC_ON__MASK                         0xff000000U
#define TX_TIMING_3__TX_END_TO_ADC_ON__READ(src) \
                    (((u_int32_t)(src)\
                    & 0xff000000U) >> 24)
#define TX_TIMING_3__TX_END_TO_ADC_ON__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 24) & 0xff000000U)
#define TX_TIMING_3__TX_END_TO_ADC_ON__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xff000000U) | (((u_int32_t)(src) <<\
                    24) & 0xff000000U)
#define TX_TIMING_3__TX_END_TO_ADC_ON__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 24) & ~0xff000000U)))
#define TX_TIMING_3__TYPE                                             u_int32_t
#define TX_TIMING_3__READ                                           0xffffffffU
#define TX_TIMING_3__WRITE                                          0xffffffffU

#endif /* __TX_TIMING_3_MACRO__ */


/* macros for bb_reg_map.bb_sm_reg_map.BB_tx_timing_3 */
#define INST_BB_REG_MAP__BB_SM_REG_MAP__BB_TX_TIMING_3__NUM                   1

/* macros for BlueprintGlobalNameSpace::xpa_timing_control */
#ifndef __XPA_TIMING_CONTROL_MACRO__
#define __XPA_TIMING_CONTROL_MACRO__

/* macros for field tx_frame_to_xpaa_on */
#define XPA_TIMING_CONTROL__TX_FRAME_TO_XPAA_ON__SHIFT                        0
#define XPA_TIMING_CONTROL__TX_FRAME_TO_XPAA_ON__WIDTH                        8
#define XPA_TIMING_CONTROL__TX_FRAME_TO_XPAA_ON__MASK               0x000000ffU
#define XPA_TIMING_CONTROL__TX_FRAME_TO_XPAA_ON__READ(src) \
                    (u_int32_t)(src)\
                    & 0x000000ffU
#define XPA_TIMING_CONTROL__TX_FRAME_TO_XPAA_ON__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x000000ffU)
#define XPA_TIMING_CONTROL__TX_FRAME_TO_XPAA_ON__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000000ffU) | ((u_int32_t)(src) &\
                    0x000000ffU)
#define XPA_TIMING_CONTROL__TX_FRAME_TO_XPAA_ON__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x000000ffU)))

/* macros for field tx_frame_to_xpab_on */
#define XPA_TIMING_CONTROL__TX_FRAME_TO_XPAB_ON__SHIFT                        8
#define XPA_TIMING_CONTROL__TX_FRAME_TO_XPAB_ON__WIDTH                        8
#define XPA_TIMING_CONTROL__TX_FRAME_TO_XPAB_ON__MASK               0x0000ff00U
#define XPA_TIMING_CONTROL__TX_FRAME_TO_XPAB_ON__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0000ff00U) >> 8)
#define XPA_TIMING_CONTROL__TX_FRAME_TO_XPAB_ON__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 8) & 0x0000ff00U)
#define XPA_TIMING_CONTROL__TX_FRAME_TO_XPAB_ON__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000ff00U) | (((u_int32_t)(src) <<\
                    8) & 0x0000ff00U)
#define XPA_TIMING_CONTROL__TX_FRAME_TO_XPAB_ON__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 8) & ~0x0000ff00U)))

/* macros for field tx_end_to_xpaa_off */
#define XPA_TIMING_CONTROL__TX_END_TO_XPAA_OFF__SHIFT                        16
#define XPA_TIMING_CONTROL__TX_END_TO_XPAA_OFF__WIDTH                         8
#define XPA_TIMING_CONTROL__TX_END_TO_XPAA_OFF__MASK                0x00ff0000U
#define XPA_TIMING_CONTROL__TX_END_TO_XPAA_OFF__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00ff0000U) >> 16)
#define XPA_TIMING_CONTROL__TX_END_TO_XPAA_OFF__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 16) & 0x00ff0000U)
#define XPA_TIMING_CONTROL__TX_END_TO_XPAA_OFF__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00ff0000U) | (((u_int32_t)(src) <<\
                    16) & 0x00ff0000U)
#define XPA_TIMING_CONTROL__TX_END_TO_XPAA_OFF__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 16) & ~0x00ff0000U)))

/* macros for field tx_end_to_xpab_off */
#define XPA_TIMING_CONTROL__TX_END_TO_XPAB_OFF__SHIFT                        24
#define XPA_TIMING_CONTROL__TX_END_TO_XPAB_OFF__WIDTH                         8
#define XPA_TIMING_CONTROL__TX_END_TO_XPAB_OFF__MASK                0xff000000U
#define XPA_TIMING_CONTROL__TX_END_TO_XPAB_OFF__READ(src) \
                    (((u_int32_t)(src)\
                    & 0xff000000U) >> 24)
#define XPA_TIMING_CONTROL__TX_END_TO_XPAB_OFF__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 24) & 0xff000000U)
#define XPA_TIMING_CONTROL__TX_END_TO_XPAB_OFF__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xff000000U) | (((u_int32_t)(src) <<\
                    24) & 0xff000000U)
#define XPA_TIMING_CONTROL__TX_END_TO_XPAB_OFF__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 24) & ~0xff000000U)))
#define XPA_TIMING_CONTROL__TYPE                                      u_int32_t
#define XPA_TIMING_CONTROL__READ                                    0xffffffffU
#define XPA_TIMING_CONTROL__WRITE                                   0xffffffffU

#endif /* __XPA_TIMING_CONTROL_MACRO__ */


/* macros for bb_reg_map.bb_sm_reg_map.BB_xpa_timing_control */
#define INST_BB_REG_MAP__BB_SM_REG_MAP__BB_XPA_TIMING_CONTROL__NUM            1

/* macros for BlueprintGlobalNameSpace::warm_tx */
#ifndef __WARM_TX_MACRO__
#define __WARM_TX_MACRO__

/* macros for field enable_warm_tx */
#define WARM_TX__ENABLE_WARM_TX__SHIFT                                        0
#define WARM_TX__ENABLE_WARM_TX__WIDTH                                        1
#define WARM_TX__ENABLE_WARM_TX__MASK                               0x00000001U
#define WARM_TX__ENABLE_WARM_TX__READ(src)       (u_int32_t)(src) & 0x00000001U
#define WARM_TX__ENABLE_WARM_TX__WRITE(src)    ((u_int32_t)(src) & 0x00000001U)
#define WARM_TX__ENABLE_WARM_TX__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | ((u_int32_t)(src) &\
                    0x00000001U)
#define WARM_TX__ENABLE_WARM_TX__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00000001U)))
#define WARM_TX__ENABLE_WARM_TX__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(1)
#define WARM_TX__ENABLE_WARM_TX__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(0)

/* macros for field num_extra_lstf_samples */
#define WARM_TX__NUM_EXTRA_LSTF_SAMPLES__SHIFT                                1
#define WARM_TX__NUM_EXTRA_LSTF_SAMPLES__WIDTH                                8
#define WARM_TX__NUM_EXTRA_LSTF_SAMPLES__MASK                       0x000001feU
#define WARM_TX__NUM_EXTRA_LSTF_SAMPLES__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x000001feU) >> 1)
#define WARM_TX__NUM_EXTRA_LSTF_SAMPLES__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 1) & 0x000001feU)
#define WARM_TX__NUM_EXTRA_LSTF_SAMPLES__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000001feU) | (((u_int32_t)(src) <<\
                    1) & 0x000001feU)
#define WARM_TX__NUM_EXTRA_LSTF_SAMPLES__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 1) & ~0x000001feU)))
#define WARM_TX__TYPE                                                 u_int32_t
#define WARM_TX__READ                                               0x000001ffU
#define WARM_TX__WRITE                                              0x000001ffU

#endif /* __WARM_TX_MACRO__ */


/* macros for bb_reg_map.bb_sm_reg_map.BB_warm_tx */
#define INST_BB_REG_MAP__BB_SM_REG_MAP__BB_WARM_TX__NUM                       1

/* macros for BlueprintGlobalNameSpace::en_power_optim */
#ifndef __EN_POWER_OPTIM_MACRO__
#define __EN_POWER_OPTIM_MACRO__

/* macros for field enable_power_optim_chn */
#define EN_POWER_OPTIM__ENABLE_POWER_OPTIM_CHN__SHIFT                         0
#define EN_POWER_OPTIM__ENABLE_POWER_OPTIM_CHN__WIDTH                         1
#define EN_POWER_OPTIM__ENABLE_POWER_OPTIM_CHN__MASK                0x00000001U
#define EN_POWER_OPTIM__ENABLE_POWER_OPTIM_CHN__READ(src) \
                    (u_int32_t)(src)\
                    & 0x00000001U
#define EN_POWER_OPTIM__ENABLE_POWER_OPTIM_CHN__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x00000001U)
#define EN_POWER_OPTIM__ENABLE_POWER_OPTIM_CHN__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | ((u_int32_t)(src) &\
                    0x00000001U)
#define EN_POWER_OPTIM__ENABLE_POWER_OPTIM_CHN__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00000001U)))
#define EN_POWER_OPTIM__ENABLE_POWER_OPTIM_CHN__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(1)
#define EN_POWER_OPTIM__ENABLE_POWER_OPTIM_CHN__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(0)

/* macros for field enable_power_optim_mrc */
#define EN_POWER_OPTIM__ENABLE_POWER_OPTIM_MRC__SHIFT                         1
#define EN_POWER_OPTIM__ENABLE_POWER_OPTIM_MRC__WIDTH                         1
#define EN_POWER_OPTIM__ENABLE_POWER_OPTIM_MRC__MASK                0x00000002U
#define EN_POWER_OPTIM__ENABLE_POWER_OPTIM_MRC__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000002U) >> 1)
#define EN_POWER_OPTIM__ENABLE_POWER_OPTIM_MRC__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 1) & 0x00000002U)
#define EN_POWER_OPTIM__ENABLE_POWER_OPTIM_MRC__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | (((u_int32_t)(src) <<\
                    1) & 0x00000002U)
#define EN_POWER_OPTIM__ENABLE_POWER_OPTIM_MRC__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 1) & ~0x00000002U)))
#define EN_POWER_OPTIM__ENABLE_POWER_OPTIM_MRC__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | ((u_int32_t)(1) << 1)
#define EN_POWER_OPTIM__ENABLE_POWER_OPTIM_MRC__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | ((u_int32_t)(0) << 1)

/* macros for field enable_power_optim_sm */
#define EN_POWER_OPTIM__ENABLE_POWER_OPTIM_SM__SHIFT                          2
#define EN_POWER_OPTIM__ENABLE_POWER_OPTIM_SM__WIDTH                          1
#define EN_POWER_OPTIM__ENABLE_POWER_OPTIM_SM__MASK                 0x00000004U
#define EN_POWER_OPTIM__ENABLE_POWER_OPTIM_SM__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000004U) >> 2)
#define EN_POWER_OPTIM__ENABLE_POWER_OPTIM_SM__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 2) & 0x00000004U)
#define EN_POWER_OPTIM__ENABLE_POWER_OPTIM_SM__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000004U) | (((u_int32_t)(src) <<\
                    2) & 0x00000004U)
#define EN_POWER_OPTIM__ENABLE_POWER_OPTIM_SM__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 2) & ~0x00000004U)))
#define EN_POWER_OPTIM__ENABLE_POWER_OPTIM_SM__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000004U) | ((u_int32_t)(1) << 2)
#define EN_POWER_OPTIM__ENABLE_POWER_OPTIM_SM__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000004U) | ((u_int32_t)(0) << 2)

/* macros for field enable_power_optim_paprd */
#define EN_POWER_OPTIM__ENABLE_POWER_OPTIM_PAPRD__SHIFT                       3
#define EN_POWER_OPTIM__ENABLE_POWER_OPTIM_PAPRD__WIDTH                       1
#define EN_POWER_OPTIM__ENABLE_POWER_OPTIM_PAPRD__MASK              0x00000008U
#define EN_POWER_OPTIM__ENABLE_POWER_OPTIM_PAPRD__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000008U) >> 3)
#define EN_POWER_OPTIM__ENABLE_POWER_OPTIM_PAPRD__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 3) & 0x00000008U)
#define EN_POWER_OPTIM__ENABLE_POWER_OPTIM_PAPRD__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000008U) | (((u_int32_t)(src) <<\
                    3) & 0x00000008U)
#define EN_POWER_OPTIM__ENABLE_POWER_OPTIM_PAPRD__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 3) & ~0x00000008U)))
#define EN_POWER_OPTIM__ENABLE_POWER_OPTIM_PAPRD__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000008U) | ((u_int32_t)(1) << 3)
#define EN_POWER_OPTIM__ENABLE_POWER_OPTIM_PAPRD__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000008U) | ((u_int32_t)(0) << 3)

/* macros for field rssi_nap_thr */
#define EN_POWER_OPTIM__RSSI_NAP_THR__SHIFT                                  24
#define EN_POWER_OPTIM__RSSI_NAP_THR__WIDTH                                   8
#define EN_POWER_OPTIM__RSSI_NAP_THR__MASK                          0xff000000U
#define EN_POWER_OPTIM__RSSI_NAP_THR__READ(src) \
                    (((u_int32_t)(src)\
                    & 0xff000000U) >> 24)
#define EN_POWER_OPTIM__RSSI_NAP_THR__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 24) & 0xff000000U)
#define EN_POWER_OPTIM__RSSI_NAP_THR__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xff000000U) | (((u_int32_t)(src) <<\
                    24) & 0xff000000U)
#define EN_POWER_OPTIM__RSSI_NAP_THR__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 24) & ~0xff000000U)))
#define EN_POWER_OPTIM__TYPE                                          u_int32_t
#define EN_POWER_OPTIM__READ                                        0xff00000fU
#define EN_POWER_OPTIM__WRITE                                       0xff00000fU

#endif /* __EN_POWER_OPTIM_MACRO__ */


/* macros for bb_reg_map.bb_sm_reg_map.BB_en_power_optim */
#define INST_BB_REG_MAP__BB_SM_REG_MAP__BB_EN_POWER_OPTIM__NUM                1

/* macros for BlueprintGlobalNameSpace::misc_pa_control */
#ifndef __MISC_PA_CONTROL_MACRO__
#define __MISC_PA_CONTROL_MACRO__

/* macros for field xpaa_active_high */
#define MISC_PA_CONTROL__XPAA_ACTIVE_HIGH__SHIFT                              0
#define MISC_PA_CONTROL__XPAA_ACTIVE_HIGH__WIDTH                              1
#define MISC_PA_CONTROL__XPAA_ACTIVE_HIGH__MASK                     0x00000001U
#define MISC_PA_CONTROL__XPAA_ACTIVE_HIGH__READ(src) \
                    (u_int32_t)(src)\
                    & 0x00000001U
#define MISC_PA_CONTROL__XPAA_ACTIVE_HIGH__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x00000001U)
#define MISC_PA_CONTROL__XPAA_ACTIVE_HIGH__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | ((u_int32_t)(src) &\
                    0x00000001U)
#define MISC_PA_CONTROL__XPAA_ACTIVE_HIGH__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00000001U)))
#define MISC_PA_CONTROL__XPAA_ACTIVE_HIGH__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(1)
#define MISC_PA_CONTROL__XPAA_ACTIVE_HIGH__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(0)

/* macros for field xpab_active_high */
#define MISC_PA_CONTROL__XPAB_ACTIVE_HIGH__SHIFT                              1
#define MISC_PA_CONTROL__XPAB_ACTIVE_HIGH__WIDTH                              1
#define MISC_PA_CONTROL__XPAB_ACTIVE_HIGH__MASK                     0x00000002U
#define MISC_PA_CONTROL__XPAB_ACTIVE_HIGH__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000002U) >> 1)
#define MISC_PA_CONTROL__XPAB_ACTIVE_HIGH__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 1) & 0x00000002U)
#define MISC_PA_CONTROL__XPAB_ACTIVE_HIGH__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | (((u_int32_t)(src) <<\
                    1) & 0x00000002U)
#define MISC_PA_CONTROL__XPAB_ACTIVE_HIGH__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 1) & ~0x00000002U)))
#define MISC_PA_CONTROL__XPAB_ACTIVE_HIGH__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | ((u_int32_t)(1) << 1)
#define MISC_PA_CONTROL__XPAB_ACTIVE_HIGH__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | ((u_int32_t)(0) << 1)

/* macros for field enable_xpaa */
#define MISC_PA_CONTROL__ENABLE_XPAA__SHIFT                                   2
#define MISC_PA_CONTROL__ENABLE_XPAA__WIDTH                                   1
#define MISC_PA_CONTROL__ENABLE_XPAA__MASK                          0x00000004U
#define MISC_PA_CONTROL__ENABLE_XPAA__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000004U) >> 2)
#define MISC_PA_CONTROL__ENABLE_XPAA__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 2) & 0x00000004U)
#define MISC_PA_CONTROL__ENABLE_XPAA__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000004U) | (((u_int32_t)(src) <<\
                    2) & 0x00000004U)
#define MISC_PA_CONTROL__ENABLE_XPAA__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 2) & ~0x00000004U)))
#define MISC_PA_CONTROL__ENABLE_XPAA__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000004U) | ((u_int32_t)(1) << 2)
#define MISC_PA_CONTROL__ENABLE_XPAA__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000004U) | ((u_int32_t)(0) << 2)

/* macros for field enable_xpab */
#define MISC_PA_CONTROL__ENABLE_XPAB__SHIFT                                   3
#define MISC_PA_CONTROL__ENABLE_XPAB__WIDTH                                   1
#define MISC_PA_CONTROL__ENABLE_XPAB__MASK                          0x00000008U
#define MISC_PA_CONTROL__ENABLE_XPAB__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000008U) >> 3)
#define MISC_PA_CONTROL__ENABLE_XPAB__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 3) & 0x00000008U)
#define MISC_PA_CONTROL__ENABLE_XPAB__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000008U) | (((u_int32_t)(src) <<\
                    3) & 0x00000008U)
#define MISC_PA_CONTROL__ENABLE_XPAB__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 3) & ~0x00000008U)))
#define MISC_PA_CONTROL__ENABLE_XPAB__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000008U) | ((u_int32_t)(1) << 3)
#define MISC_PA_CONTROL__ENABLE_XPAB__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000008U) | ((u_int32_t)(0) << 3)
#define MISC_PA_CONTROL__TYPE                                         u_int32_t
#define MISC_PA_CONTROL__READ                                       0x0000000fU
#define MISC_PA_CONTROL__WRITE                                      0x0000000fU

#endif /* __MISC_PA_CONTROL_MACRO__ */


/* macros for bb_reg_map.bb_sm_reg_map.BB_misc_pa_control */
#define INST_BB_REG_MAP__BB_SM_REG_MAP__BB_MISC_PA_CONTROL__NUM               1

/* macros for BlueprintGlobalNameSpace::switch_table_chn_b0 */
#ifndef __SWITCH_TABLE_CHN_B0_MACRO__
#define __SWITCH_TABLE_CHN_B0_MACRO__

/* macros for field switch_table_idle_0 */
#define SWITCH_TABLE_CHN_B0__SWITCH_TABLE_IDLE_0__SHIFT                       0
#define SWITCH_TABLE_CHN_B0__SWITCH_TABLE_IDLE_0__WIDTH                       2
#define SWITCH_TABLE_CHN_B0__SWITCH_TABLE_IDLE_0__MASK              0x00000003U
#define SWITCH_TABLE_CHN_B0__SWITCH_TABLE_IDLE_0__READ(src) \
                    (u_int32_t)(src)\
                    & 0x00000003U
#define SWITCH_TABLE_CHN_B0__SWITCH_TABLE_IDLE_0__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x00000003U)
#define SWITCH_TABLE_CHN_B0__SWITCH_TABLE_IDLE_0__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000003U) | ((u_int32_t)(src) &\
                    0x00000003U)
#define SWITCH_TABLE_CHN_B0__SWITCH_TABLE_IDLE_0__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00000003U)))

/* macros for field switch_table_t_0 */
#define SWITCH_TABLE_CHN_B0__SWITCH_TABLE_T_0__SHIFT                          2
#define SWITCH_TABLE_CHN_B0__SWITCH_TABLE_T_0__WIDTH                          2
#define SWITCH_TABLE_CHN_B0__SWITCH_TABLE_T_0__MASK                 0x0000000cU
#define SWITCH_TABLE_CHN_B0__SWITCH_TABLE_T_0__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0000000cU) >> 2)
#define SWITCH_TABLE_CHN_B0__SWITCH_TABLE_T_0__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 2) & 0x0000000cU)
#define SWITCH_TABLE_CHN_B0__SWITCH_TABLE_T_0__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000000cU) | (((u_int32_t)(src) <<\
                    2) & 0x0000000cU)
#define SWITCH_TABLE_CHN_B0__SWITCH_TABLE_T_0__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 2) & ~0x0000000cU)))

/* macros for field switch_table_r_0 */
#define SWITCH_TABLE_CHN_B0__SWITCH_TABLE_R_0__SHIFT                          4
#define SWITCH_TABLE_CHN_B0__SWITCH_TABLE_R_0__WIDTH                          2
#define SWITCH_TABLE_CHN_B0__SWITCH_TABLE_R_0__MASK                 0x00000030U
#define SWITCH_TABLE_CHN_B0__SWITCH_TABLE_R_0__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000030U) >> 4)
#define SWITCH_TABLE_CHN_B0__SWITCH_TABLE_R_0__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 4) & 0x00000030U)
#define SWITCH_TABLE_CHN_B0__SWITCH_TABLE_R_0__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000030U) | (((u_int32_t)(src) <<\
                    4) & 0x00000030U)
#define SWITCH_TABLE_CHN_B0__SWITCH_TABLE_R_0__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 4) & ~0x00000030U)))

/* macros for field switch_table_rx1_0 */
#define SWITCH_TABLE_CHN_B0__SWITCH_TABLE_RX1_0__SHIFT                        6
#define SWITCH_TABLE_CHN_B0__SWITCH_TABLE_RX1_0__WIDTH                        2
#define SWITCH_TABLE_CHN_B0__SWITCH_TABLE_RX1_0__MASK               0x000000c0U
#define SWITCH_TABLE_CHN_B0__SWITCH_TABLE_RX1_0__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x000000c0U) >> 6)
#define SWITCH_TABLE_CHN_B0__SWITCH_TABLE_RX1_0__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 6) & 0x000000c0U)
#define SWITCH_TABLE_CHN_B0__SWITCH_TABLE_RX1_0__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000000c0U) | (((u_int32_t)(src) <<\
                    6) & 0x000000c0U)
#define SWITCH_TABLE_CHN_B0__SWITCH_TABLE_RX1_0__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 6) & ~0x000000c0U)))

/* macros for field switch_table_rx12_0 */
#define SWITCH_TABLE_CHN_B0__SWITCH_TABLE_RX12_0__SHIFT                       8
#define SWITCH_TABLE_CHN_B0__SWITCH_TABLE_RX12_0__WIDTH                       2
#define SWITCH_TABLE_CHN_B0__SWITCH_TABLE_RX12_0__MASK              0x00000300U
#define SWITCH_TABLE_CHN_B0__SWITCH_TABLE_RX12_0__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000300U) >> 8)
#define SWITCH_TABLE_CHN_B0__SWITCH_TABLE_RX12_0__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 8) & 0x00000300U)
#define SWITCH_TABLE_CHN_B0__SWITCH_TABLE_RX12_0__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000300U) | (((u_int32_t)(src) <<\
                    8) & 0x00000300U)
#define SWITCH_TABLE_CHN_B0__SWITCH_TABLE_RX12_0__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 8) & ~0x00000300U)))

/* macros for field switch_table_b_0 */
#define SWITCH_TABLE_CHN_B0__SWITCH_TABLE_B_0__SHIFT                         10
#define SWITCH_TABLE_CHN_B0__SWITCH_TABLE_B_0__WIDTH                          2
#define SWITCH_TABLE_CHN_B0__SWITCH_TABLE_B_0__MASK                 0x00000c00U
#define SWITCH_TABLE_CHN_B0__SWITCH_TABLE_B_0__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000c00U) >> 10)
#define SWITCH_TABLE_CHN_B0__SWITCH_TABLE_B_0__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 10) & 0x00000c00U)
#define SWITCH_TABLE_CHN_B0__SWITCH_TABLE_B_0__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000c00U) | (((u_int32_t)(src) <<\
                    10) & 0x00000c00U)
#define SWITCH_TABLE_CHN_B0__SWITCH_TABLE_B_0__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 10) & ~0x00000c00U)))

/* macros for field bt_in_tx_xlna_override */
#define SWITCH_TABLE_CHN_B0__BT_IN_TX_XLNA_OVERRIDE__SHIFT                   30
#define SWITCH_TABLE_CHN_B0__BT_IN_TX_XLNA_OVERRIDE__WIDTH                    1
#define SWITCH_TABLE_CHN_B0__BT_IN_TX_XLNA_OVERRIDE__MASK           0x40000000U
#define SWITCH_TABLE_CHN_B0__BT_IN_TX_XLNA_OVERRIDE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x40000000U) >> 30)
#define SWITCH_TABLE_CHN_B0__BT_IN_TX_XLNA_OVERRIDE__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 30) & 0x40000000U)
#define SWITCH_TABLE_CHN_B0__BT_IN_TX_XLNA_OVERRIDE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x40000000U) | (((u_int32_t)(src) <<\
                    30) & 0x40000000U)
#define SWITCH_TABLE_CHN_B0__BT_IN_TX_XLNA_OVERRIDE__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 30) & ~0x40000000U)))
#define SWITCH_TABLE_CHN_B0__BT_IN_TX_XLNA_OVERRIDE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x40000000U) | ((u_int32_t)(1) << 30)
#define SWITCH_TABLE_CHN_B0__BT_IN_TX_XLNA_OVERRIDE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x40000000U) | ((u_int32_t)(0) << 30)

/* macros for field enable_bt_override */
#define SWITCH_TABLE_CHN_B0__ENABLE_BT_OVERRIDE__SHIFT                       31
#define SWITCH_TABLE_CHN_B0__ENABLE_BT_OVERRIDE__WIDTH                        1
#define SWITCH_TABLE_CHN_B0__ENABLE_BT_OVERRIDE__MASK               0x80000000U
#define SWITCH_TABLE_CHN_B0__ENABLE_BT_OVERRIDE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x80000000U) >> 31)
#define SWITCH_TABLE_CHN_B0__ENABLE_BT_OVERRIDE__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 31) & 0x80000000U)
#define SWITCH_TABLE_CHN_B0__ENABLE_BT_OVERRIDE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x80000000U) | (((u_int32_t)(src) <<\
                    31) & 0x80000000U)
#define SWITCH_TABLE_CHN_B0__ENABLE_BT_OVERRIDE__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 31) & ~0x80000000U)))
#define SWITCH_TABLE_CHN_B0__ENABLE_BT_OVERRIDE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x80000000U) | ((u_int32_t)(1) << 31)
#define SWITCH_TABLE_CHN_B0__ENABLE_BT_OVERRIDE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x80000000U) | ((u_int32_t)(0) << 31)
#define SWITCH_TABLE_CHN_B0__TYPE                                     u_int32_t
#define SWITCH_TABLE_CHN_B0__READ                                   0xc0000fffU
#define SWITCH_TABLE_CHN_B0__WRITE                                  0xc0000fffU

#endif /* __SWITCH_TABLE_CHN_B0_MACRO__ */


/* macros for bb_reg_map.bb_sm_reg_map.BB_switch_table_chn_b0 */
#define INST_BB_REG_MAP__BB_SM_REG_MAP__BB_SWITCH_TABLE_CHN_B0__NUM           1

/* macros for BlueprintGlobalNameSpace::switch_table_com1 */
#ifndef __SWITCH_TABLE_COM1_MACRO__
#define __SWITCH_TABLE_COM1_MACRO__

/* macros for field switch_table_com_idle */
#define SWITCH_TABLE_COM1__SWITCH_TABLE_COM_IDLE__SHIFT                       0
#define SWITCH_TABLE_COM1__SWITCH_TABLE_COM_IDLE__WIDTH                       6
#define SWITCH_TABLE_COM1__SWITCH_TABLE_COM_IDLE__MASK              0x0000003fU
#define SWITCH_TABLE_COM1__SWITCH_TABLE_COM_IDLE__READ(src) \
                    (u_int32_t)(src)\
                    & 0x0000003fU
#define SWITCH_TABLE_COM1__SWITCH_TABLE_COM_IDLE__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x0000003fU)
#define SWITCH_TABLE_COM1__SWITCH_TABLE_COM_IDLE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000003fU) | ((u_int32_t)(src) &\
                    0x0000003fU)
#define SWITCH_TABLE_COM1__SWITCH_TABLE_COM_IDLE__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x0000003fU)))

/* macros for field switch_table_com_t1 */
#define SWITCH_TABLE_COM1__SWITCH_TABLE_COM_T1__SHIFT                         6
#define SWITCH_TABLE_COM1__SWITCH_TABLE_COM_T1__WIDTH                         6
#define SWITCH_TABLE_COM1__SWITCH_TABLE_COM_T1__MASK                0x00000fc0U
#define SWITCH_TABLE_COM1__SWITCH_TABLE_COM_T1__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000fc0U) >> 6)
#define SWITCH_TABLE_COM1__SWITCH_TABLE_COM_T1__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 6) & 0x00000fc0U)
#define SWITCH_TABLE_COM1__SWITCH_TABLE_COM_T1__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000fc0U) | (((u_int32_t)(src) <<\
                    6) & 0x00000fc0U)
#define SWITCH_TABLE_COM1__SWITCH_TABLE_COM_T1__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 6) & ~0x00000fc0U)))

/* macros for field switch_table_com_t2 */
#define SWITCH_TABLE_COM1__SWITCH_TABLE_COM_T2__SHIFT                        12
#define SWITCH_TABLE_COM1__SWITCH_TABLE_COM_T2__WIDTH                         4
#define SWITCH_TABLE_COM1__SWITCH_TABLE_COM_T2__MASK                0x0000f000U
#define SWITCH_TABLE_COM1__SWITCH_TABLE_COM_T2__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0000f000U) >> 12)
#define SWITCH_TABLE_COM1__SWITCH_TABLE_COM_T2__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 12) & 0x0000f000U)
#define SWITCH_TABLE_COM1__SWITCH_TABLE_COM_T2__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000f000U) | (((u_int32_t)(src) <<\
                    12) & 0x0000f000U)
#define SWITCH_TABLE_COM1__SWITCH_TABLE_COM_T2__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 12) & ~0x0000f000U)))

/* macros for field switch_table_com_b */
#define SWITCH_TABLE_COM1__SWITCH_TABLE_COM_B__SHIFT                         16
#define SWITCH_TABLE_COM1__SWITCH_TABLE_COM_B__WIDTH                          6
#define SWITCH_TABLE_COM1__SWITCH_TABLE_COM_B__MASK                 0x003f0000U
#define SWITCH_TABLE_COM1__SWITCH_TABLE_COM_B__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x003f0000U) >> 16)
#define SWITCH_TABLE_COM1__SWITCH_TABLE_COM_B__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 16) & 0x003f0000U)
#define SWITCH_TABLE_COM1__SWITCH_TABLE_COM_B__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x003f0000U) | (((u_int32_t)(src) <<\
                    16) & 0x003f0000U)
#define SWITCH_TABLE_COM1__SWITCH_TABLE_COM_B__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 16) & ~0x003f0000U)))

/* macros for field switch_table_com_idle_alt */
#define SWITCH_TABLE_COM1__SWITCH_TABLE_COM_IDLE_ALT__SHIFT                  22
#define SWITCH_TABLE_COM1__SWITCH_TABLE_COM_IDLE_ALT__WIDTH                   6
#define SWITCH_TABLE_COM1__SWITCH_TABLE_COM_IDLE_ALT__MASK          0x0fc00000U
#define SWITCH_TABLE_COM1__SWITCH_TABLE_COM_IDLE_ALT__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0fc00000U) >> 22)
#define SWITCH_TABLE_COM1__SWITCH_TABLE_COM_IDLE_ALT__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 22) & 0x0fc00000U)
#define SWITCH_TABLE_COM1__SWITCH_TABLE_COM_IDLE_ALT__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0fc00000U) | (((u_int32_t)(src) <<\
                    22) & 0x0fc00000U)
#define SWITCH_TABLE_COM1__SWITCH_TABLE_COM_IDLE_ALT__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 22) & ~0x0fc00000U)))

/* macros for field switch_table_com_tx_1chn */
#define SWITCH_TABLE_COM1__SWITCH_TABLE_COM_TX_1CHN__SHIFT                   28
#define SWITCH_TABLE_COM1__SWITCH_TABLE_COM_TX_1CHN__WIDTH                    4
#define SWITCH_TABLE_COM1__SWITCH_TABLE_COM_TX_1CHN__MASK           0xf0000000U
#define SWITCH_TABLE_COM1__SWITCH_TABLE_COM_TX_1CHN__READ(src) \
                    (((u_int32_t)(src)\
                    & 0xf0000000U) >> 28)
#define SWITCH_TABLE_COM1__SWITCH_TABLE_COM_TX_1CHN__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 28) & 0xf0000000U)
#define SWITCH_TABLE_COM1__SWITCH_TABLE_COM_TX_1CHN__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xf0000000U) | (((u_int32_t)(src) <<\
                    28) & 0xf0000000U)
#define SWITCH_TABLE_COM1__SWITCH_TABLE_COM_TX_1CHN__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 28) & ~0xf0000000U)))
#define SWITCH_TABLE_COM1__TYPE                                       u_int32_t
#define SWITCH_TABLE_COM1__READ                                     0xffffffffU
#define SWITCH_TABLE_COM1__WRITE                                    0xffffffffU

#endif /* __SWITCH_TABLE_COM1_MACRO__ */


/* macros for bb_reg_map.bb_sm_reg_map.BB_switch_table_com1 */
#define INST_BB_REG_MAP__BB_SM_REG_MAP__BB_SWITCH_TABLE_COM1__NUM             1

/* macros for BlueprintGlobalNameSpace::switch_table_com2 */
#ifndef __SWITCH_TABLE_COM2_MACRO__
#define __SWITCH_TABLE_COM2_MACRO__

/* macros for field switch_table_com_ra1l1 */
#define SWITCH_TABLE_COM2__SWITCH_TABLE_COM_RA1L1__SHIFT                      0
#define SWITCH_TABLE_COM2__SWITCH_TABLE_COM_RA1L1__WIDTH                      6
#define SWITCH_TABLE_COM2__SWITCH_TABLE_COM_RA1L1__MASK             0x0000003fU
#define SWITCH_TABLE_COM2__SWITCH_TABLE_COM_RA1L1__READ(src) \
                    (u_int32_t)(src)\
                    & 0x0000003fU
#define SWITCH_TABLE_COM2__SWITCH_TABLE_COM_RA1L1__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x0000003fU)
#define SWITCH_TABLE_COM2__SWITCH_TABLE_COM_RA1L1__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000003fU) | ((u_int32_t)(src) &\
                    0x0000003fU)
#define SWITCH_TABLE_COM2__SWITCH_TABLE_COM_RA1L1__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x0000003fU)))

/* macros for field switch_table_com_ra2l1 */
#define SWITCH_TABLE_COM2__SWITCH_TABLE_COM_RA2L1__SHIFT                      6
#define SWITCH_TABLE_COM2__SWITCH_TABLE_COM_RA2L1__WIDTH                      4
#define SWITCH_TABLE_COM2__SWITCH_TABLE_COM_RA2L1__MASK             0x000003c0U
#define SWITCH_TABLE_COM2__SWITCH_TABLE_COM_RA2L1__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x000003c0U) >> 6)
#define SWITCH_TABLE_COM2__SWITCH_TABLE_COM_RA2L1__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 6) & 0x000003c0U)
#define SWITCH_TABLE_COM2__SWITCH_TABLE_COM_RA2L1__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000003c0U) | (((u_int32_t)(src) <<\
                    6) & 0x000003c0U)
#define SWITCH_TABLE_COM2__SWITCH_TABLE_COM_RA2L1__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 6) & ~0x000003c0U)))

/* macros for field switch_table_com_ra1l2 */
#define SWITCH_TABLE_COM2__SWITCH_TABLE_COM_RA1L2__SHIFT                     10
#define SWITCH_TABLE_COM2__SWITCH_TABLE_COM_RA1L2__WIDTH                      4
#define SWITCH_TABLE_COM2__SWITCH_TABLE_COM_RA1L2__MASK             0x00003c00U
#define SWITCH_TABLE_COM2__SWITCH_TABLE_COM_RA1L2__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00003c00U) >> 10)
#define SWITCH_TABLE_COM2__SWITCH_TABLE_COM_RA1L2__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 10) & 0x00003c00U)
#define SWITCH_TABLE_COM2__SWITCH_TABLE_COM_RA1L2__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00003c00U) | (((u_int32_t)(src) <<\
                    10) & 0x00003c00U)
#define SWITCH_TABLE_COM2__SWITCH_TABLE_COM_RA1L2__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 10) & ~0x00003c00U)))

/* macros for field switch_table_com_ra2l2 */
#define SWITCH_TABLE_COM2__SWITCH_TABLE_COM_RA2L2__SHIFT                     14
#define SWITCH_TABLE_COM2__SWITCH_TABLE_COM_RA2L2__WIDTH                      4
#define SWITCH_TABLE_COM2__SWITCH_TABLE_COM_RA2L2__MASK             0x0003c000U
#define SWITCH_TABLE_COM2__SWITCH_TABLE_COM_RA2L2__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0003c000U) >> 14)
#define SWITCH_TABLE_COM2__SWITCH_TABLE_COM_RA2L2__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 14) & 0x0003c000U)
#define SWITCH_TABLE_COM2__SWITCH_TABLE_COM_RA2L2__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0003c000U) | (((u_int32_t)(src) <<\
                    14) & 0x0003c000U)
#define SWITCH_TABLE_COM2__SWITCH_TABLE_COM_RA2L2__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 14) & ~0x0003c000U)))

/* macros for field switch_table_com_ra12 */
#define SWITCH_TABLE_COM2__SWITCH_TABLE_COM_RA12__SHIFT                      18
#define SWITCH_TABLE_COM2__SWITCH_TABLE_COM_RA12__WIDTH                       4
#define SWITCH_TABLE_COM2__SWITCH_TABLE_COM_RA12__MASK              0x003c0000U
#define SWITCH_TABLE_COM2__SWITCH_TABLE_COM_RA12__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x003c0000U) >> 18)
#define SWITCH_TABLE_COM2__SWITCH_TABLE_COM_RA12__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 18) & 0x003c0000U)
#define SWITCH_TABLE_COM2__SWITCH_TABLE_COM_RA12__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x003c0000U) | (((u_int32_t)(src) <<\
                    18) & 0x003c0000U)
#define SWITCH_TABLE_COM2__SWITCH_TABLE_COM_RA12__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 18) & ~0x003c0000U)))
#define SWITCH_TABLE_COM2__TYPE                                       u_int32_t
#define SWITCH_TABLE_COM2__READ                                     0x003fffffU
#define SWITCH_TABLE_COM2__WRITE                                    0x003fffffU

#endif /* __SWITCH_TABLE_COM2_MACRO__ */


/* macros for bb_reg_map.bb_sm_reg_map.BB_switch_table_com2 */
#define INST_BB_REG_MAP__BB_SM_REG_MAP__BB_SWITCH_TABLE_COM2__NUM             1

/* macros for BlueprintGlobalNameSpace::multichain_enable */
#ifndef __MULTICHAIN_ENABLE_MACRO__
#define __MULTICHAIN_ENABLE_MACRO__

/* macros for field rx_chain_mask */
#define MULTICHAIN_ENABLE__RX_CHAIN_MASK__SHIFT                               0
#define MULTICHAIN_ENABLE__RX_CHAIN_MASK__WIDTH                               4
#define MULTICHAIN_ENABLE__RX_CHAIN_MASK__MASK                      0x0000000fU
#define MULTICHAIN_ENABLE__RX_CHAIN_MASK__READ(src) \
                    (u_int32_t)(src)\
                    & 0x0000000fU
#define MULTICHAIN_ENABLE__RX_CHAIN_MASK__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x0000000fU)
#define MULTICHAIN_ENABLE__RX_CHAIN_MASK__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000000fU) | ((u_int32_t)(src) &\
                    0x0000000fU)
#define MULTICHAIN_ENABLE__RX_CHAIN_MASK__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x0000000fU)))

/* macros for field dyn_listen_mask */
#define MULTICHAIN_ENABLE__DYN_LISTEN_MASK__SHIFT                             4
#define MULTICHAIN_ENABLE__DYN_LISTEN_MASK__WIDTH                             4
#define MULTICHAIN_ENABLE__DYN_LISTEN_MASK__MASK                    0x000000f0U
#define MULTICHAIN_ENABLE__DYN_LISTEN_MASK__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x000000f0U) >> 4)
#define MULTICHAIN_ENABLE__DYN_LISTEN_MASK__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 4) & 0x000000f0U)
#define MULTICHAIN_ENABLE__DYN_LISTEN_MASK__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000000f0U) | (((u_int32_t)(src) <<\
                    4) & 0x000000f0U)
#define MULTICHAIN_ENABLE__DYN_LISTEN_MASK__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 4) & ~0x000000f0U)))

/* macros for field ack_response_timeout */
#define MULTICHAIN_ENABLE__ACK_RESPONSE_TIMEOUT__SHIFT                        8
#define MULTICHAIN_ENABLE__ACK_RESPONSE_TIMEOUT__WIDTH                       12
#define MULTICHAIN_ENABLE__ACK_RESPONSE_TIMEOUT__MASK               0x000fff00U
#define MULTICHAIN_ENABLE__ACK_RESPONSE_TIMEOUT__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x000fff00U) >> 8)
#define MULTICHAIN_ENABLE__ACK_RESPONSE_TIMEOUT__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 8) & 0x000fff00U)
#define MULTICHAIN_ENABLE__ACK_RESPONSE_TIMEOUT__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000fff00U) | (((u_int32_t)(src) <<\
                    8) & 0x000fff00U)
#define MULTICHAIN_ENABLE__ACK_RESPONSE_TIMEOUT__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 8) & ~0x000fff00U)))

/* macros for field cf_VHT160_mode_force */
#define MULTICHAIN_ENABLE__CF_VHT160_MODE_FORCE__SHIFT                       20
#define MULTICHAIN_ENABLE__CF_VHT160_MODE_FORCE__WIDTH                        1
#define MULTICHAIN_ENABLE__CF_VHT160_MODE_FORCE__MASK               0x00100000U
#define MULTICHAIN_ENABLE__CF_VHT160_MODE_FORCE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00100000U) >> 20)
#define MULTICHAIN_ENABLE__CF_VHT160_MODE_FORCE__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 20) & 0x00100000U)
#define MULTICHAIN_ENABLE__CF_VHT160_MODE_FORCE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00100000U) | (((u_int32_t)(src) <<\
                    20) & 0x00100000U)
#define MULTICHAIN_ENABLE__CF_VHT160_MODE_FORCE__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 20) & ~0x00100000U)))
#define MULTICHAIN_ENABLE__CF_VHT160_MODE_FORCE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00100000U) | ((u_int32_t)(1) << 20)
#define MULTICHAIN_ENABLE__CF_VHT160_MODE_FORCE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00100000U) | ((u_int32_t)(0) << 20)

/* macros for field cf_VHT160_mode_forced */
#define MULTICHAIN_ENABLE__CF_VHT160_MODE_FORCED__SHIFT                      21
#define MULTICHAIN_ENABLE__CF_VHT160_MODE_FORCED__WIDTH                       2
#define MULTICHAIN_ENABLE__CF_VHT160_MODE_FORCED__MASK              0x00600000U
#define MULTICHAIN_ENABLE__CF_VHT160_MODE_FORCED__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00600000U) >> 21)
#define MULTICHAIN_ENABLE__CF_VHT160_MODE_FORCED__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 21) & 0x00600000U)
#define MULTICHAIN_ENABLE__CF_VHT160_MODE_FORCED__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00600000U) | (((u_int32_t)(src) <<\
                    21) & 0x00600000U)
#define MULTICHAIN_ENABLE__CF_VHT160_MODE_FORCED__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 21) & ~0x00600000U)))

/* macros for field cf_VHT160_pkswitch_use_pbd */
#define MULTICHAIN_ENABLE__CF_VHT160_PKSWITCH_USE_PBD__SHIFT                 23
#define MULTICHAIN_ENABLE__CF_VHT160_PKSWITCH_USE_PBD__WIDTH                  1
#define MULTICHAIN_ENABLE__CF_VHT160_PKSWITCH_USE_PBD__MASK         0x00800000U
#define MULTICHAIN_ENABLE__CF_VHT160_PKSWITCH_USE_PBD__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00800000U) >> 23)
#define MULTICHAIN_ENABLE__CF_VHT160_PKSWITCH_USE_PBD__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 23) & 0x00800000U)
#define MULTICHAIN_ENABLE__CF_VHT160_PKSWITCH_USE_PBD__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00800000U) | (((u_int32_t)(src) <<\
                    23) & 0x00800000U)
#define MULTICHAIN_ENABLE__CF_VHT160_PKSWITCH_USE_PBD__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 23) & ~0x00800000U)))
#define MULTICHAIN_ENABLE__CF_VHT160_PKSWITCH_USE_PBD__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00800000U) | ((u_int32_t)(1) << 23)
#define MULTICHAIN_ENABLE__CF_VHT160_PKSWITCH_USE_PBD__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00800000U) | ((u_int32_t)(0) << 23)

/* macros for field disable_dyn_listen */
#define MULTICHAIN_ENABLE__DISABLE_DYN_LISTEN__SHIFT                         30
#define MULTICHAIN_ENABLE__DISABLE_DYN_LISTEN__WIDTH                          2
#define MULTICHAIN_ENABLE__DISABLE_DYN_LISTEN__MASK                 0xc0000000U
#define MULTICHAIN_ENABLE__DISABLE_DYN_LISTEN__READ(src) \
                    (((u_int32_t)(src)\
                    & 0xc0000000U) >> 30)
#define MULTICHAIN_ENABLE__DISABLE_DYN_LISTEN__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 30) & 0xc0000000U)
#define MULTICHAIN_ENABLE__DISABLE_DYN_LISTEN__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xc0000000U) | (((u_int32_t)(src) <<\
                    30) & 0xc0000000U)
#define MULTICHAIN_ENABLE__DISABLE_DYN_LISTEN__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 30) & ~0xc0000000U)))
#define MULTICHAIN_ENABLE__TYPE                                       u_int32_t
#define MULTICHAIN_ENABLE__READ                                     0xc0ffffffU
#define MULTICHAIN_ENABLE__WRITE                                    0xc0ffffffU

#endif /* __MULTICHAIN_ENABLE_MACRO__ */


/* macros for bb_reg_map.bb_sm_reg_map.BB_multichain_enable */
#define INST_BB_REG_MAP__BB_SM_REG_MAP__BB_MULTICHAIN_ENABLE__NUM             1

/* macros for BlueprintGlobalNameSpace::rx_notch_cntl_0 */
#ifndef __RX_NOTCH_CNTL_0_MACRO__
#define __RX_NOTCH_CNTL_0_MACRO__

/* macros for field enable_dc_notch_filter */
#define RX_NOTCH_CNTL_0__ENABLE_DC_NOTCH_FILTER__SHIFT                        0
#define RX_NOTCH_CNTL_0__ENABLE_DC_NOTCH_FILTER__WIDTH                        1
#define RX_NOTCH_CNTL_0__ENABLE_DC_NOTCH_FILTER__MASK               0x00000001U
#define RX_NOTCH_CNTL_0__ENABLE_DC_NOTCH_FILTER__READ(src) \
                    (u_int32_t)(src)\
                    & 0x00000001U
#define RX_NOTCH_CNTL_0__ENABLE_DC_NOTCH_FILTER__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x00000001U)
#define RX_NOTCH_CNTL_0__ENABLE_DC_NOTCH_FILTER__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | ((u_int32_t)(src) &\
                    0x00000001U)
#define RX_NOTCH_CNTL_0__ENABLE_DC_NOTCH_FILTER__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00000001U)))
#define RX_NOTCH_CNTL_0__ENABLE_DC_NOTCH_FILTER__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(1)
#define RX_NOTCH_CNTL_0__ENABLE_DC_NOTCH_FILTER__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(0)

/* macros for field enable_dc_notch_fd */
#define RX_NOTCH_CNTL_0__ENABLE_DC_NOTCH_FD__SHIFT                            1
#define RX_NOTCH_CNTL_0__ENABLE_DC_NOTCH_FD__WIDTH                            1
#define RX_NOTCH_CNTL_0__ENABLE_DC_NOTCH_FD__MASK                   0x00000002U
#define RX_NOTCH_CNTL_0__ENABLE_DC_NOTCH_FD__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000002U) >> 1)
#define RX_NOTCH_CNTL_0__ENABLE_DC_NOTCH_FD__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 1) & 0x00000002U)
#define RX_NOTCH_CNTL_0__ENABLE_DC_NOTCH_FD__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | (((u_int32_t)(src) <<\
                    1) & 0x00000002U)
#define RX_NOTCH_CNTL_0__ENABLE_DC_NOTCH_FD__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 1) & ~0x00000002U)))
#define RX_NOTCH_CNTL_0__ENABLE_DC_NOTCH_FD__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | ((u_int32_t)(1) << 1)
#define RX_NOTCH_CNTL_0__ENABLE_DC_NOTCH_FD__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | ((u_int32_t)(0) << 1)

/* macros for field enable_dc_notch_fd_ht_only */
#define RX_NOTCH_CNTL_0__ENABLE_DC_NOTCH_FD_HT_ONLY__SHIFT                    2
#define RX_NOTCH_CNTL_0__ENABLE_DC_NOTCH_FD_HT_ONLY__WIDTH                    1
#define RX_NOTCH_CNTL_0__ENABLE_DC_NOTCH_FD_HT_ONLY__MASK           0x00000004U
#define RX_NOTCH_CNTL_0__ENABLE_DC_NOTCH_FD_HT_ONLY__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000004U) >> 2)
#define RX_NOTCH_CNTL_0__ENABLE_DC_NOTCH_FD_HT_ONLY__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 2) & 0x00000004U)
#define RX_NOTCH_CNTL_0__ENABLE_DC_NOTCH_FD_HT_ONLY__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000004U) | (((u_int32_t)(src) <<\
                    2) & 0x00000004U)
#define RX_NOTCH_CNTL_0__ENABLE_DC_NOTCH_FD_HT_ONLY__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 2) & ~0x00000004U)))
#define RX_NOTCH_CNTL_0__ENABLE_DC_NOTCH_FD_HT_ONLY__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000004U) | ((u_int32_t)(1) << 2)
#define RX_NOTCH_CNTL_0__ENABLE_DC_NOTCH_FD_HT_ONLY__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000004U) | ((u_int32_t)(0) << 2)

/* macros for field enable_dc_notch_filter_detect */
#define RX_NOTCH_CNTL_0__ENABLE_DC_NOTCH_FILTER_DETECT__SHIFT                 3
#define RX_NOTCH_CNTL_0__ENABLE_DC_NOTCH_FILTER_DETECT__WIDTH                 1
#define RX_NOTCH_CNTL_0__ENABLE_DC_NOTCH_FILTER_DETECT__MASK        0x00000008U
#define RX_NOTCH_CNTL_0__ENABLE_DC_NOTCH_FILTER_DETECT__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000008U) >> 3)
#define RX_NOTCH_CNTL_0__ENABLE_DC_NOTCH_FILTER_DETECT__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 3) & 0x00000008U)
#define RX_NOTCH_CNTL_0__ENABLE_DC_NOTCH_FILTER_DETECT__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000008U) | (((u_int32_t)(src) <<\
                    3) & 0x00000008U)
#define RX_NOTCH_CNTL_0__ENABLE_DC_NOTCH_FILTER_DETECT__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 3) & ~0x00000008U)))
#define RX_NOTCH_CNTL_0__ENABLE_DC_NOTCH_FILTER_DETECT__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000008U) | ((u_int32_t)(1) << 3)
#define RX_NOTCH_CNTL_0__ENABLE_DC_NOTCH_FILTER_DETECT__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000008U) | ((u_int32_t)(0) << 3)

/* macros for field enable_dc_notch_filter_11b */
#define RX_NOTCH_CNTL_0__ENABLE_DC_NOTCH_FILTER_11B__SHIFT                    4
#define RX_NOTCH_CNTL_0__ENABLE_DC_NOTCH_FILTER_11B__WIDTH                    1
#define RX_NOTCH_CNTL_0__ENABLE_DC_NOTCH_FILTER_11B__MASK           0x00000010U
#define RX_NOTCH_CNTL_0__ENABLE_DC_NOTCH_FILTER_11B__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000010U) >> 4)
#define RX_NOTCH_CNTL_0__ENABLE_DC_NOTCH_FILTER_11B__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 4) & 0x00000010U)
#define RX_NOTCH_CNTL_0__ENABLE_DC_NOTCH_FILTER_11B__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000010U) | (((u_int32_t)(src) <<\
                    4) & 0x00000010U)
#define RX_NOTCH_CNTL_0__ENABLE_DC_NOTCH_FILTER_11B__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 4) & ~0x00000010U)))
#define RX_NOTCH_CNTL_0__ENABLE_DC_NOTCH_FILTER_11B__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000010U) | ((u_int32_t)(1) << 4)
#define RX_NOTCH_CNTL_0__ENABLE_DC_NOTCH_FILTER_11B__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000010U) | ((u_int32_t)(0) << 4)

/* macros for field enable_dc_notch_filter_ofdm */
#define RX_NOTCH_CNTL_0__ENABLE_DC_NOTCH_FILTER_OFDM__SHIFT                   5
#define RX_NOTCH_CNTL_0__ENABLE_DC_NOTCH_FILTER_OFDM__WIDTH                   1
#define RX_NOTCH_CNTL_0__ENABLE_DC_NOTCH_FILTER_OFDM__MASK          0x00000020U
#define RX_NOTCH_CNTL_0__ENABLE_DC_NOTCH_FILTER_OFDM__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000020U) >> 5)
#define RX_NOTCH_CNTL_0__ENABLE_DC_NOTCH_FILTER_OFDM__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 5) & 0x00000020U)
#define RX_NOTCH_CNTL_0__ENABLE_DC_NOTCH_FILTER_OFDM__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000020U) | (((u_int32_t)(src) <<\
                    5) & 0x00000020U)
#define RX_NOTCH_CNTL_0__ENABLE_DC_NOTCH_FILTER_OFDM__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 5) & ~0x00000020U)))
#define RX_NOTCH_CNTL_0__ENABLE_DC_NOTCH_FILTER_OFDM__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000020U) | ((u_int32_t)(1) << 5)
#define RX_NOTCH_CNTL_0__ENABLE_DC_NOTCH_FILTER_OFDM__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000020U) | ((u_int32_t)(0) << 5)

/* macros for field enable_dc_notch_filter_htstf */
#define RX_NOTCH_CNTL_0__ENABLE_DC_NOTCH_FILTER_HTSTF__SHIFT                  6
#define RX_NOTCH_CNTL_0__ENABLE_DC_NOTCH_FILTER_HTSTF__WIDTH                  1
#define RX_NOTCH_CNTL_0__ENABLE_DC_NOTCH_FILTER_HTSTF__MASK         0x00000040U
#define RX_NOTCH_CNTL_0__ENABLE_DC_NOTCH_FILTER_HTSTF__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000040U) >> 6)
#define RX_NOTCH_CNTL_0__ENABLE_DC_NOTCH_FILTER_HTSTF__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 6) & 0x00000040U)
#define RX_NOTCH_CNTL_0__ENABLE_DC_NOTCH_FILTER_HTSTF__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000040U) | (((u_int32_t)(src) <<\
                    6) & 0x00000040U)
#define RX_NOTCH_CNTL_0__ENABLE_DC_NOTCH_FILTER_HTSTF__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 6) & ~0x00000040U)))
#define RX_NOTCH_CNTL_0__ENABLE_DC_NOTCH_FILTER_HTSTF__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000040U) | ((u_int32_t)(1) << 6)
#define RX_NOTCH_CNTL_0__ENABLE_DC_NOTCH_FILTER_HTSTF__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000040U) | ((u_int32_t)(0) << 6)

/* macros for field htstf_end_dc_notch_count */
#define RX_NOTCH_CNTL_0__HTSTF_END_DC_NOTCH_COUNT__SHIFT                     16
#define RX_NOTCH_CNTL_0__HTSTF_END_DC_NOTCH_COUNT__WIDTH                     11
#define RX_NOTCH_CNTL_0__HTSTF_END_DC_NOTCH_COUNT__MASK             0x07ff0000U
#define RX_NOTCH_CNTL_0__HTSTF_END_DC_NOTCH_COUNT__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x07ff0000U) >> 16)
#define RX_NOTCH_CNTL_0__HTSTF_END_DC_NOTCH_COUNT__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 16) & 0x07ff0000U)
#define RX_NOTCH_CNTL_0__HTSTF_END_DC_NOTCH_COUNT__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x07ff0000U) | (((u_int32_t)(src) <<\
                    16) & 0x07ff0000U)
#define RX_NOTCH_CNTL_0__HTSTF_END_DC_NOTCH_COUNT__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 16) & ~0x07ff0000U)))
#define RX_NOTCH_CNTL_0__TYPE                                         u_int32_t
#define RX_NOTCH_CNTL_0__READ                                       0x07ff007fU
#define RX_NOTCH_CNTL_0__WRITE                                      0x07ff007fU

#endif /* __RX_NOTCH_CNTL_0_MACRO__ */


/* macros for bb_reg_map.bb_sm_reg_map.BB_rx_notch_cntl_0 */
#define INST_BB_REG_MAP__BB_SM_REG_MAP__BB_RX_NOTCH_CNTL_0__NUM               1

/* macros for BlueprintGlobalNameSpace::rx_notch_cntl_1 */
#ifndef __RX_NOTCH_CNTL_1_MACRO__
#define __RX_NOTCH_CNTL_1_MACRO__

/* macros for field alpha_spur1 */
#define RX_NOTCH_CNTL_1__ALPHA_SPUR1__SHIFT                                   0
#define RX_NOTCH_CNTL_1__ALPHA_SPUR1__WIDTH                                   3
#define RX_NOTCH_CNTL_1__ALPHA_SPUR1__MASK                          0x00000007U
#define RX_NOTCH_CNTL_1__ALPHA_SPUR1__READ(src)  (u_int32_t)(src) & 0x00000007U
#define RX_NOTCH_CNTL_1__ALPHA_SPUR1__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x00000007U)
#define RX_NOTCH_CNTL_1__ALPHA_SPUR1__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000007U) | ((u_int32_t)(src) &\
                    0x00000007U)
#define RX_NOTCH_CNTL_1__ALPHA_SPUR1__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00000007U)))

/* macros for field alpha_spur2 */
#define RX_NOTCH_CNTL_1__ALPHA_SPUR2__SHIFT                                   4
#define RX_NOTCH_CNTL_1__ALPHA_SPUR2__WIDTH                                   3
#define RX_NOTCH_CNTL_1__ALPHA_SPUR2__MASK                          0x00000070U
#define RX_NOTCH_CNTL_1__ALPHA_SPUR2__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000070U) >> 4)
#define RX_NOTCH_CNTL_1__ALPHA_SPUR2__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 4) & 0x00000070U)
#define RX_NOTCH_CNTL_1__ALPHA_SPUR2__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000070U) | (((u_int32_t)(src) <<\
                    4) & 0x00000070U)
#define RX_NOTCH_CNTL_1__ALPHA_SPUR2__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 4) & ~0x00000070U)))

/* macros for field alpha_dc */
#define RX_NOTCH_CNTL_1__ALPHA_DC__SHIFT                                      8
#define RX_NOTCH_CNTL_1__ALPHA_DC__WIDTH                                      3
#define RX_NOTCH_CNTL_1__ALPHA_DC__MASK                             0x00000700U
#define RX_NOTCH_CNTL_1__ALPHA_DC__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000700U) >> 8)
#define RX_NOTCH_CNTL_1__ALPHA_DC__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 8) & 0x00000700U)
#define RX_NOTCH_CNTL_1__ALPHA_DC__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000700U) | (((u_int32_t)(src) <<\
                    8) & 0x00000700U)
#define RX_NOTCH_CNTL_1__ALPHA_DC__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 8) & ~0x00000700U)))

/* macros for field spur_gain_thr */
#define RX_NOTCH_CNTL_1__SPUR_GAIN_THR__SHIFT                                16
#define RX_NOTCH_CNTL_1__SPUR_GAIN_THR__WIDTH                                10
#define RX_NOTCH_CNTL_1__SPUR_GAIN_THR__MASK                        0x03ff0000U
#define RX_NOTCH_CNTL_1__SPUR_GAIN_THR__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x03ff0000U) >> 16)
#define RX_NOTCH_CNTL_1__SPUR_GAIN_THR__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 16) & 0x03ff0000U)
#define RX_NOTCH_CNTL_1__SPUR_GAIN_THR__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x03ff0000U) | (((u_int32_t)(src) <<\
                    16) & 0x03ff0000U)
#define RX_NOTCH_CNTL_1__SPUR_GAIN_THR__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 16) & ~0x03ff0000U)))

/* macros for field spur_gain_thr_ena */
#define RX_NOTCH_CNTL_1__SPUR_GAIN_THR_ENA__SHIFT                            28
#define RX_NOTCH_CNTL_1__SPUR_GAIN_THR_ENA__WIDTH                             1
#define RX_NOTCH_CNTL_1__SPUR_GAIN_THR_ENA__MASK                    0x10000000U
#define RX_NOTCH_CNTL_1__SPUR_GAIN_THR_ENA__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x10000000U) >> 28)
#define RX_NOTCH_CNTL_1__SPUR_GAIN_THR_ENA__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 28) & 0x10000000U)
#define RX_NOTCH_CNTL_1__SPUR_GAIN_THR_ENA__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x10000000U) | (((u_int32_t)(src) <<\
                    28) & 0x10000000U)
#define RX_NOTCH_CNTL_1__SPUR_GAIN_THR_ENA__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 28) & ~0x10000000U)))
#define RX_NOTCH_CNTL_1__SPUR_GAIN_THR_ENA__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x10000000U) | ((u_int32_t)(1) << 28)
#define RX_NOTCH_CNTL_1__SPUR_GAIN_THR_ENA__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x10000000U) | ((u_int32_t)(0) << 28)
#define RX_NOTCH_CNTL_1__TYPE                                         u_int32_t
#define RX_NOTCH_CNTL_1__READ                                       0x13ff0777U
#define RX_NOTCH_CNTL_1__WRITE                                      0x13ff0777U

#endif /* __RX_NOTCH_CNTL_1_MACRO__ */


/* macros for bb_reg_map.bb_sm_reg_map.BB_rx_notch_cntl_1 */
#define INST_BB_REG_MAP__BB_SM_REG_MAP__BB_RX_NOTCH_CNTL_1__NUM               1

/* macros for BlueprintGlobalNameSpace::vht160mode_debug */
#ifndef __VHT160MODE_DEBUG_MACRO__
#define __VHT160MODE_DEBUG_MACRO__

/* macros for field cf_VHT160_mode_rxtimed */
#define VHT160MODE_DEBUG__CF_VHT160_MODE_RXTIMED__SHIFT                       0
#define VHT160MODE_DEBUG__CF_VHT160_MODE_RXTIMED__WIDTH                       1
#define VHT160MODE_DEBUG__CF_VHT160_MODE_RXTIMED__MASK              0x00000001U
#define VHT160MODE_DEBUG__CF_VHT160_MODE_RXTIMED__READ(src) \
                    (u_int32_t)(src)\
                    & 0x00000001U
#define VHT160MODE_DEBUG__CF_VHT160_MODE_RXTIMED__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x00000001U)
#define VHT160MODE_DEBUG__CF_VHT160_MODE_RXTIMED__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | ((u_int32_t)(src) &\
                    0x00000001U)
#define VHT160MODE_DEBUG__CF_VHT160_MODE_RXTIMED__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00000001U)))
#define VHT160MODE_DEBUG__CF_VHT160_MODE_RXTIMED__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(1)
#define VHT160MODE_DEBUG__CF_VHT160_MODE_RXTIMED__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(0)

/* macros for field cf_force_rxtimed_start_val */
#define VHT160MODE_DEBUG__CF_FORCE_RXTIMED_START_VAL__SHIFT                   4
#define VHT160MODE_DEBUG__CF_FORCE_RXTIMED_START_VAL__WIDTH                   2
#define VHT160MODE_DEBUG__CF_FORCE_RXTIMED_START_VAL__MASK          0x00000030U
#define VHT160MODE_DEBUG__CF_FORCE_RXTIMED_START_VAL__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000030U) >> 4)
#define VHT160MODE_DEBUG__CF_FORCE_RXTIMED_START_VAL__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 4) & 0x00000030U)
#define VHT160MODE_DEBUG__CF_FORCE_RXTIMED_START_VAL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000030U) | (((u_int32_t)(src) <<\
                    4) & 0x00000030U)
#define VHT160MODE_DEBUG__CF_FORCE_RXTIMED_START_VAL__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 4) & ~0x00000030U)))

/* macros for field cf_force_rxtimed_final_val */
#define VHT160MODE_DEBUG__CF_FORCE_RXTIMED_FINAL_VAL__SHIFT                   6
#define VHT160MODE_DEBUG__CF_FORCE_RXTIMED_FINAL_VAL__WIDTH                   2
#define VHT160MODE_DEBUG__CF_FORCE_RXTIMED_FINAL_VAL__MASK          0x000000c0U
#define VHT160MODE_DEBUG__CF_FORCE_RXTIMED_FINAL_VAL__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x000000c0U) >> 6)
#define VHT160MODE_DEBUG__CF_FORCE_RXTIMED_FINAL_VAL__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 6) & 0x000000c0U)
#define VHT160MODE_DEBUG__CF_FORCE_RXTIMED_FINAL_VAL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000000c0U) | (((u_int32_t)(src) <<\
                    6) & 0x000000c0U)
#define VHT160MODE_DEBUG__CF_FORCE_RXTIMED_FINAL_VAL__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 6) & ~0x000000c0U)))

/* macros for field cf_force_rxtimed_switchtime */
#define VHT160MODE_DEBUG__CF_FORCE_RXTIMED_SWITCHTIME__SHIFT                  8
#define VHT160MODE_DEBUG__CF_FORCE_RXTIMED_SWITCHTIME__WIDTH                 14
#define VHT160MODE_DEBUG__CF_FORCE_RXTIMED_SWITCHTIME__MASK         0x003fff00U
#define VHT160MODE_DEBUG__CF_FORCE_RXTIMED_SWITCHTIME__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x003fff00U) >> 8)
#define VHT160MODE_DEBUG__CF_FORCE_RXTIMED_SWITCHTIME__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 8) & 0x003fff00U)
#define VHT160MODE_DEBUG__CF_FORCE_RXTIMED_SWITCHTIME__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x003fff00U) | (((u_int32_t)(src) <<\
                    8) & 0x003fff00U)
#define VHT160MODE_DEBUG__CF_FORCE_RXTIMED_SWITCHTIME__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 8) & ~0x003fff00U)))
#define VHT160MODE_DEBUG__TYPE                                        u_int32_t
#define VHT160MODE_DEBUG__READ                                      0x003ffff1U
#define VHT160MODE_DEBUG__WRITE                                     0x003ffff1U

#endif /* __VHT160MODE_DEBUG_MACRO__ */


/* macros for bb_reg_map.bb_sm_reg_map.BB_vht160mode_debug */
#define INST_BB_REG_MAP__BB_SM_REG_MAP__BB_VHT160MODE_DEBUG__NUM              1

/* macros for BlueprintGlobalNameSpace::cal_chain_mask */
#ifndef __CAL_CHAIN_MASK_MACRO__
#define __CAL_CHAIN_MASK_MACRO__

/* macros for field cal_chain_mask */
#define CAL_CHAIN_MASK__CAL_CHAIN_MASK__SHIFT                                 0
#define CAL_CHAIN_MASK__CAL_CHAIN_MASK__WIDTH                                 4
#define CAL_CHAIN_MASK__CAL_CHAIN_MASK__MASK                        0x0000000fU
#define CAL_CHAIN_MASK__CAL_CHAIN_MASK__READ(src) \
                    (u_int32_t)(src)\
                    & 0x0000000fU
#define CAL_CHAIN_MASK__CAL_CHAIN_MASK__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x0000000fU)
#define CAL_CHAIN_MASK__CAL_CHAIN_MASK__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000000fU) | ((u_int32_t)(src) &\
                    0x0000000fU)
#define CAL_CHAIN_MASK__CAL_CHAIN_MASK__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x0000000fU)))
#define CAL_CHAIN_MASK__TYPE                                          u_int32_t
#define CAL_CHAIN_MASK__READ                                        0x0000000fU
#define CAL_CHAIN_MASK__WRITE                                       0x0000000fU

#endif /* __CAL_CHAIN_MASK_MACRO__ */


/* macros for bb_reg_map.bb_sm_reg_map.BB_cal_chain_mask */
#define INST_BB_REG_MAP__BB_SM_REG_MAP__BB_CAL_CHAIN_MASK__NUM                1

/* macros for BlueprintGlobalNameSpace::agc_control */
#ifndef __AGC_CONTROL_MACRO__
#define __AGC_CONTROL_MACRO__

/* macros for field do_calibrate */
#define AGC_CONTROL__DO_CALIBRATE__SHIFT                                      0
#define AGC_CONTROL__DO_CALIBRATE__WIDTH                                      1
#define AGC_CONTROL__DO_CALIBRATE__MASK                             0x00000001U
#define AGC_CONTROL__DO_CALIBRATE__READ(src)     (u_int32_t)(src) & 0x00000001U
#define AGC_CONTROL__DO_CALIBRATE__WRITE(src)  ((u_int32_t)(src) & 0x00000001U)
#define AGC_CONTROL__DO_CALIBRATE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | ((u_int32_t)(src) &\
                    0x00000001U)
#define AGC_CONTROL__DO_CALIBRATE__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00000001U)))
#define AGC_CONTROL__DO_CALIBRATE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(1)
#define AGC_CONTROL__DO_CALIBRATE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(0)

/* macros for field do_noisefloor */
#define AGC_CONTROL__DO_NOISEFLOOR__SHIFT                                     1
#define AGC_CONTROL__DO_NOISEFLOOR__WIDTH                                     1
#define AGC_CONTROL__DO_NOISEFLOOR__MASK                            0x00000002U
#define AGC_CONTROL__DO_NOISEFLOOR__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000002U) >> 1)
#define AGC_CONTROL__DO_NOISEFLOOR__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 1) & 0x00000002U)
#define AGC_CONTROL__DO_NOISEFLOOR__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | (((u_int32_t)(src) <<\
                    1) & 0x00000002U)
#define AGC_CONTROL__DO_NOISEFLOOR__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 1) & ~0x00000002U)))
#define AGC_CONTROL__DO_NOISEFLOOR__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | ((u_int32_t)(1) << 1)
#define AGC_CONTROL__DO_NOISEFLOOR__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | ((u_int32_t)(0) << 1)

/* macros for field min_num_gain_change */
#define AGC_CONTROL__MIN_NUM_GAIN_CHANGE__SHIFT                               3
#define AGC_CONTROL__MIN_NUM_GAIN_CHANGE__WIDTH                               3
#define AGC_CONTROL__MIN_NUM_GAIN_CHANGE__MASK                      0x00000038U
#define AGC_CONTROL__MIN_NUM_GAIN_CHANGE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000038U) >> 3)
#define AGC_CONTROL__MIN_NUM_GAIN_CHANGE__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 3) & 0x00000038U)
#define AGC_CONTROL__MIN_NUM_GAIN_CHANGE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000038U) | (((u_int32_t)(src) <<\
                    3) & 0x00000038U)
#define AGC_CONTROL__MIN_NUM_GAIN_CHANGE__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 3) & ~0x00000038U)))

/* macros for field ycok_max */
#define AGC_CONTROL__YCOK_MAX__SHIFT                                          6
#define AGC_CONTROL__YCOK_MAX__WIDTH                                          4
#define AGC_CONTROL__YCOK_MAX__MASK                                 0x000003c0U
#define AGC_CONTROL__YCOK_MAX__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x000003c0U) >> 6)
#define AGC_CONTROL__YCOK_MAX__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 6) & 0x000003c0U)
#define AGC_CONTROL__YCOK_MAX__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000003c0U) | (((u_int32_t)(src) <<\
                    6) & 0x000003c0U)
#define AGC_CONTROL__YCOK_MAX__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 6) & ~0x000003c0U)))

/* macros for field leaky_bucket_enable */
#define AGC_CONTROL__LEAKY_BUCKET_ENABLE__SHIFT                              10
#define AGC_CONTROL__LEAKY_BUCKET_ENABLE__WIDTH                               1
#define AGC_CONTROL__LEAKY_BUCKET_ENABLE__MASK                      0x00000400U
#define AGC_CONTROL__LEAKY_BUCKET_ENABLE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000400U) >> 10)
#define AGC_CONTROL__LEAKY_BUCKET_ENABLE__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 10) & 0x00000400U)
#define AGC_CONTROL__LEAKY_BUCKET_ENABLE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000400U) | (((u_int32_t)(src) <<\
                    10) & 0x00000400U)
#define AGC_CONTROL__LEAKY_BUCKET_ENABLE__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 10) & ~0x00000400U)))
#define AGC_CONTROL__LEAKY_BUCKET_ENABLE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000400U) | ((u_int32_t)(1) << 10)
#define AGC_CONTROL__LEAKY_BUCKET_ENABLE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000400U) | ((u_int32_t)(0) << 10)

/* macros for field CAL_enable */
#define AGC_CONTROL__CAL_ENABLE__SHIFT                                       11
#define AGC_CONTROL__CAL_ENABLE__WIDTH                                        1
#define AGC_CONTROL__CAL_ENABLE__MASK                               0x00000800U
#define AGC_CONTROL__CAL_ENABLE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000800U) >> 11)
#define AGC_CONTROL__CAL_ENABLE__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 11) & 0x00000800U)
#define AGC_CONTROL__CAL_ENABLE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000800U) | (((u_int32_t)(src) <<\
                    11) & 0x00000800U)
#define AGC_CONTROL__CAL_ENABLE__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 11) & ~0x00000800U)))
#define AGC_CONTROL__CAL_ENABLE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000800U) | ((u_int32_t)(1) << 11)
#define AGC_CONTROL__CAL_ENABLE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000800U) | ((u_int32_t)(0) << 11)

/* macros for field enable_noisefloor */
#define AGC_CONTROL__ENABLE_NOISEFLOOR__SHIFT                                15
#define AGC_CONTROL__ENABLE_NOISEFLOOR__WIDTH                                 1
#define AGC_CONTROL__ENABLE_NOISEFLOOR__MASK                        0x00008000U
#define AGC_CONTROL__ENABLE_NOISEFLOOR__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00008000U) >> 15)
#define AGC_CONTROL__ENABLE_NOISEFLOOR__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 15) & 0x00008000U)
#define AGC_CONTROL__ENABLE_NOISEFLOOR__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00008000U) | (((u_int32_t)(src) <<\
                    15) & 0x00008000U)
#define AGC_CONTROL__ENABLE_NOISEFLOOR__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 15) & ~0x00008000U)))
#define AGC_CONTROL__ENABLE_NOISEFLOOR__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00008000U) | ((u_int32_t)(1) << 15)
#define AGC_CONTROL__ENABLE_NOISEFLOOR__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00008000U) | ((u_int32_t)(0) << 15)

/* macros for field enable_fltr_cal */
#define AGC_CONTROL__ENABLE_FLTR_CAL__SHIFT                                  16
#define AGC_CONTROL__ENABLE_FLTR_CAL__WIDTH                                   1
#define AGC_CONTROL__ENABLE_FLTR_CAL__MASK                          0x00010000U
#define AGC_CONTROL__ENABLE_FLTR_CAL__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00010000U) >> 16)
#define AGC_CONTROL__ENABLE_FLTR_CAL__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 16) & 0x00010000U)
#define AGC_CONTROL__ENABLE_FLTR_CAL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00010000U) | (((u_int32_t)(src) <<\
                    16) & 0x00010000U)
#define AGC_CONTROL__ENABLE_FLTR_CAL__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 16) & ~0x00010000U)))
#define AGC_CONTROL__ENABLE_FLTR_CAL__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00010000U) | ((u_int32_t)(1) << 16)
#define AGC_CONTROL__ENABLE_FLTR_CAL__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00010000U) | ((u_int32_t)(0) << 16)

/* macros for field no_update_noisefloor */
#define AGC_CONTROL__NO_UPDATE_NOISEFLOOR__SHIFT                             17
#define AGC_CONTROL__NO_UPDATE_NOISEFLOOR__WIDTH                              1
#define AGC_CONTROL__NO_UPDATE_NOISEFLOOR__MASK                     0x00020000U
#define AGC_CONTROL__NO_UPDATE_NOISEFLOOR__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00020000U) >> 17)
#define AGC_CONTROL__NO_UPDATE_NOISEFLOOR__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 17) & 0x00020000U)
#define AGC_CONTROL__NO_UPDATE_NOISEFLOOR__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00020000U) | (((u_int32_t)(src) <<\
                    17) & 0x00020000U)
#define AGC_CONTROL__NO_UPDATE_NOISEFLOOR__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 17) & ~0x00020000U)))
#define AGC_CONTROL__NO_UPDATE_NOISEFLOOR__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00020000U) | ((u_int32_t)(1) << 17)
#define AGC_CONTROL__NO_UPDATE_NOISEFLOOR__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00020000U) | ((u_int32_t)(0) << 17)

/* macros for field extend_NF_pwr_meas */
#define AGC_CONTROL__EXTEND_NF_PWR_MEAS__SHIFT                               18
#define AGC_CONTROL__EXTEND_NF_PWR_MEAS__WIDTH                                1
#define AGC_CONTROL__EXTEND_NF_PWR_MEAS__MASK                       0x00040000U
#define AGC_CONTROL__EXTEND_NF_PWR_MEAS__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00040000U) >> 18)
#define AGC_CONTROL__EXTEND_NF_PWR_MEAS__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 18) & 0x00040000U)
#define AGC_CONTROL__EXTEND_NF_PWR_MEAS__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00040000U) | (((u_int32_t)(src) <<\
                    18) & 0x00040000U)
#define AGC_CONTROL__EXTEND_NF_PWR_MEAS__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 18) & ~0x00040000U)))
#define AGC_CONTROL__EXTEND_NF_PWR_MEAS__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00040000U) | ((u_int32_t)(1) << 18)
#define AGC_CONTROL__EXTEND_NF_PWR_MEAS__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00040000U) | ((u_int32_t)(0) << 18)

/* macros for field clc_success */
#define AGC_CONTROL__CLC_SUCCESS__SHIFT                                      19
#define AGC_CONTROL__CLC_SUCCESS__WIDTH                                       1
#define AGC_CONTROL__CLC_SUCCESS__MASK                              0x00080000U
#define AGC_CONTROL__CLC_SUCCESS__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00080000U) >> 19)
#define AGC_CONTROL__CLC_SUCCESS__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00080000U) | ((u_int32_t)(1) << 19)
#define AGC_CONTROL__CLC_SUCCESS__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00080000U) | ((u_int32_t)(0) << 19)

/* macros for field enable_pkdet_cal */
#define AGC_CONTROL__ENABLE_PKDET_CAL__SHIFT                                 20
#define AGC_CONTROL__ENABLE_PKDET_CAL__WIDTH                                  1
#define AGC_CONTROL__ENABLE_PKDET_CAL__MASK                         0x00100000U
#define AGC_CONTROL__ENABLE_PKDET_CAL__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00100000U) >> 20)
#define AGC_CONTROL__ENABLE_PKDET_CAL__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 20) & 0x00100000U)
#define AGC_CONTROL__ENABLE_PKDET_CAL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00100000U) | (((u_int32_t)(src) <<\
                    20) & 0x00100000U)
#define AGC_CONTROL__ENABLE_PKDET_CAL__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 20) & ~0x00100000U)))
#define AGC_CONTROL__ENABLE_PKDET_CAL__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00100000U) | ((u_int32_t)(1) << 20)
#define AGC_CONTROL__ENABLE_PKDET_CAL__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00100000U) | ((u_int32_t)(0) << 20)

/* macros for field max_gainchanges */
#define AGC_CONTROL__MAX_GAINCHANGES__SHIFT                                  21
#define AGC_CONTROL__MAX_GAINCHANGES__WIDTH                                   4
#define AGC_CONTROL__MAX_GAINCHANGES__MASK                          0x01e00000U
#define AGC_CONTROL__MAX_GAINCHANGES__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x01e00000U) >> 21)
#define AGC_CONTROL__MAX_GAINCHANGES__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 21) & 0x01e00000U)
#define AGC_CONTROL__MAX_GAINCHANGES__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x01e00000U) | (((u_int32_t)(src) <<\
                    21) & 0x01e00000U)
#define AGC_CONTROL__MAX_GAINCHANGES__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 21) & ~0x01e00000U)))
#define AGC_CONTROL__TYPE                                             u_int32_t
#define AGC_CONTROL__READ                                           0x01ff8ffbU
#define AGC_CONTROL__WRITE                                          0x01ff8ffbU

#endif /* __AGC_CONTROL_MACRO__ */


/* macros for bb_reg_map.bb_sm_reg_map.BB_agc_control */
#define INST_BB_REG_MAP__BB_SM_REG_MAP__BB_AGC_CONTROL__NUM                   1

/* macros for BlueprintGlobalNameSpace::iq_adc_cal_mode */
#ifndef __IQ_ADC_CAL_MODE_MACRO__
#define __IQ_ADC_CAL_MODE_MACRO__

/* macros for field gain_dc_iq_cal_mode */
#define IQ_ADC_CAL_MODE__GAIN_DC_IQ_CAL_MODE__SHIFT                           0
#define IQ_ADC_CAL_MODE__GAIN_DC_IQ_CAL_MODE__WIDTH                           2
#define IQ_ADC_CAL_MODE__GAIN_DC_IQ_CAL_MODE__MASK                  0x00000003U
#define IQ_ADC_CAL_MODE__GAIN_DC_IQ_CAL_MODE__READ(src) \
                    (u_int32_t)(src)\
                    & 0x00000003U
#define IQ_ADC_CAL_MODE__GAIN_DC_IQ_CAL_MODE__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x00000003U)
#define IQ_ADC_CAL_MODE__GAIN_DC_IQ_CAL_MODE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000003U) | ((u_int32_t)(src) &\
                    0x00000003U)
#define IQ_ADC_CAL_MODE__GAIN_DC_IQ_CAL_MODE__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00000003U)))

/* macros for field test_caladcoff */
#define IQ_ADC_CAL_MODE__TEST_CALADCOFF__SHIFT                                2
#define IQ_ADC_CAL_MODE__TEST_CALADCOFF__WIDTH                                1
#define IQ_ADC_CAL_MODE__TEST_CALADCOFF__MASK                       0x00000004U
#define IQ_ADC_CAL_MODE__TEST_CALADCOFF__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000004U) >> 2)
#define IQ_ADC_CAL_MODE__TEST_CALADCOFF__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 2) & 0x00000004U)
#define IQ_ADC_CAL_MODE__TEST_CALADCOFF__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000004U) | (((u_int32_t)(src) <<\
                    2) & 0x00000004U)
#define IQ_ADC_CAL_MODE__TEST_CALADCOFF__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 2) & ~0x00000004U)))
#define IQ_ADC_CAL_MODE__TEST_CALADCOFF__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000004U) | ((u_int32_t)(1) << 2)
#define IQ_ADC_CAL_MODE__TEST_CALADCOFF__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000004U) | ((u_int32_t)(0) << 2)
#define IQ_ADC_CAL_MODE__TYPE                                         u_int32_t
#define IQ_ADC_CAL_MODE__READ                                       0x00000007U
#define IQ_ADC_CAL_MODE__WRITE                                      0x00000007U

#endif /* __IQ_ADC_CAL_MODE_MACRO__ */


/* macros for bb_reg_map.bb_sm_reg_map.BB_iq_adc_cal_mode */
#define INST_BB_REG_MAP__BB_SM_REG_MAP__BB_IQ_ADC_CAL_MODE__NUM               1

/* macros for BlueprintGlobalNameSpace::fcal_1 */
#ifndef __FCAL_1_MACRO__
#define __FCAL_1_MACRO__

/* macros for field flc_pb_fstep */
#define FCAL_1__FLC_PB_FSTEP__SHIFT                                           0
#define FCAL_1__FLC_PB_FSTEP__WIDTH                                          10
#define FCAL_1__FLC_PB_FSTEP__MASK                                  0x000003ffU
#define FCAL_1__FLC_PB_FSTEP__READ(src)          (u_int32_t)(src) & 0x000003ffU
#define FCAL_1__FLC_PB_FSTEP__WRITE(src)       ((u_int32_t)(src) & 0x000003ffU)
#define FCAL_1__FLC_PB_FSTEP__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000003ffU) | ((u_int32_t)(src) &\
                    0x000003ffU)
#define FCAL_1__FLC_PB_FSTEP__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x000003ffU)))

/* macros for field flc_sb_fstep */
#define FCAL_1__FLC_SB_FSTEP__SHIFT                                          10
#define FCAL_1__FLC_SB_FSTEP__WIDTH                                          10
#define FCAL_1__FLC_SB_FSTEP__MASK                                  0x000ffc00U
#define FCAL_1__FLC_SB_FSTEP__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x000ffc00U) >> 10)
#define FCAL_1__FLC_SB_FSTEP__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 10) & 0x000ffc00U)
#define FCAL_1__FLC_SB_FSTEP__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000ffc00U) | (((u_int32_t)(src) <<\
                    10) & 0x000ffc00U)
#define FCAL_1__FLC_SB_FSTEP__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 10) & ~0x000ffc00U)))

/* macros for field flc_pb_atten */
#define FCAL_1__FLC_PB_ATTEN__SHIFT                                          20
#define FCAL_1__FLC_PB_ATTEN__WIDTH                                           5
#define FCAL_1__FLC_PB_ATTEN__MASK                                  0x01f00000U
#define FCAL_1__FLC_PB_ATTEN__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x01f00000U) >> 20)
#define FCAL_1__FLC_PB_ATTEN__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 20) & 0x01f00000U)
#define FCAL_1__FLC_PB_ATTEN__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x01f00000U) | (((u_int32_t)(src) <<\
                    20) & 0x01f00000U)
#define FCAL_1__FLC_PB_ATTEN__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 20) & ~0x01f00000U)))

/* macros for field flc_sb_atten */
#define FCAL_1__FLC_SB_ATTEN__SHIFT                                          25
#define FCAL_1__FLC_SB_ATTEN__WIDTH                                           5
#define FCAL_1__FLC_SB_ATTEN__MASK                                  0x3e000000U
#define FCAL_1__FLC_SB_ATTEN__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x3e000000U) >> 25)
#define FCAL_1__FLC_SB_ATTEN__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 25) & 0x3e000000U)
#define FCAL_1__FLC_SB_ATTEN__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x3e000000U) | (((u_int32_t)(src) <<\
                    25) & 0x3e000000U)
#define FCAL_1__FLC_SB_ATTEN__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 25) & ~0x3e000000U)))
#define FCAL_1__TYPE                                                  u_int32_t
#define FCAL_1__READ                                                0x3fffffffU
#define FCAL_1__WRITE                                               0x3fffffffU

#endif /* __FCAL_1_MACRO__ */


/* macros for bb_reg_map.bb_sm_reg_map.BB_fcal_1 */
#define INST_BB_REG_MAP__BB_SM_REG_MAP__BB_FCAL_1__NUM                        1

/* macros for BlueprintGlobalNameSpace::fcal_2_b0 */
#ifndef __FCAL_2_B0_MACRO__
#define __FCAL_2_B0_MACRO__

/* macros for field flc_pwr_thresh */
#define FCAL_2_B0__FLC_PWR_THRESH__SHIFT                                      0
#define FCAL_2_B0__FLC_PWR_THRESH__WIDTH                                      3
#define FCAL_2_B0__FLC_PWR_THRESH__MASK                             0x00000007U
#define FCAL_2_B0__FLC_PWR_THRESH__READ(src)     (u_int32_t)(src) & 0x00000007U
#define FCAL_2_B0__FLC_PWR_THRESH__WRITE(src)  ((u_int32_t)(src) & 0x00000007U)
#define FCAL_2_B0__FLC_PWR_THRESH__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000007U) | ((u_int32_t)(src) &\
                    0x00000007U)
#define FCAL_2_B0__FLC_PWR_THRESH__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00000007U)))

/* macros for field flc_sw_cap_val_0 */
#define FCAL_2_B0__FLC_SW_CAP_VAL_0__SHIFT                                    3
#define FCAL_2_B0__FLC_SW_CAP_VAL_0__WIDTH                                    5
#define FCAL_2_B0__FLC_SW_CAP_VAL_0__MASK                           0x000000f8U
#define FCAL_2_B0__FLC_SW_CAP_VAL_0__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x000000f8U) >> 3)
#define FCAL_2_B0__FLC_SW_CAP_VAL_0__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 3) & 0x000000f8U)
#define FCAL_2_B0__FLC_SW_CAP_VAL_0__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000000f8U) | (((u_int32_t)(src) <<\
                    3) & 0x000000f8U)
#define FCAL_2_B0__FLC_SW_CAP_VAL_0__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 3) & ~0x000000f8U)))

/* macros for field flc_bbmiscgain */
#define FCAL_2_B0__FLC_BBMISCGAIN__SHIFT                                      8
#define FCAL_2_B0__FLC_BBMISCGAIN__WIDTH                                      2
#define FCAL_2_B0__FLC_BBMISCGAIN__MASK                             0x00000300U
#define FCAL_2_B0__FLC_BBMISCGAIN__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000300U) >> 8)
#define FCAL_2_B0__FLC_BBMISCGAIN__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 8) & 0x00000300U)
#define FCAL_2_B0__FLC_BBMISCGAIN__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000300U) | (((u_int32_t)(src) <<\
                    8) & 0x00000300U)
#define FCAL_2_B0__FLC_BBMISCGAIN__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 8) & ~0x00000300U)))

/* macros for field flc_bb1dbgain */
#define FCAL_2_B0__FLC_BB1DBGAIN__SHIFT                                      10
#define FCAL_2_B0__FLC_BB1DBGAIN__WIDTH                                       4
#define FCAL_2_B0__FLC_BB1DBGAIN__MASK                              0x00003c00U
#define FCAL_2_B0__FLC_BB1DBGAIN__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00003c00U) >> 10)
#define FCAL_2_B0__FLC_BB1DBGAIN__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 10) & 0x00003c00U)
#define FCAL_2_B0__FLC_BB1DBGAIN__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00003c00U) | (((u_int32_t)(src) <<\
                    10) & 0x00003c00U)
#define FCAL_2_B0__FLC_BB1DBGAIN__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 10) & ~0x00003c00U)))

/* macros for field flc_bb6dbgain */
#define FCAL_2_B0__FLC_BB6DBGAIN__SHIFT                                      14
#define FCAL_2_B0__FLC_BB6DBGAIN__WIDTH                                       2
#define FCAL_2_B0__FLC_BB6DBGAIN__MASK                              0x0000c000U
#define FCAL_2_B0__FLC_BB6DBGAIN__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0000c000U) >> 14)
#define FCAL_2_B0__FLC_BB6DBGAIN__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 14) & 0x0000c000U)
#define FCAL_2_B0__FLC_BB6DBGAIN__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000c000U) | (((u_int32_t)(src) <<\
                    14) & 0x0000c000U)
#define FCAL_2_B0__FLC_BB6DBGAIN__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 14) & ~0x0000c000U)))

/* macros for field flc_sw_cap_set */
#define FCAL_2_B0__FLC_SW_CAP_SET__SHIFT                                     16
#define FCAL_2_B0__FLC_SW_CAP_SET__WIDTH                                      1
#define FCAL_2_B0__FLC_SW_CAP_SET__MASK                             0x00010000U
#define FCAL_2_B0__FLC_SW_CAP_SET__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00010000U) >> 16)
#define FCAL_2_B0__FLC_SW_CAP_SET__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 16) & 0x00010000U)
#define FCAL_2_B0__FLC_SW_CAP_SET__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00010000U) | (((u_int32_t)(src) <<\
                    16) & 0x00010000U)
#define FCAL_2_B0__FLC_SW_CAP_SET__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 16) & ~0x00010000U)))
#define FCAL_2_B0__FLC_SW_CAP_SET__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00010000U) | ((u_int32_t)(1) << 16)
#define FCAL_2_B0__FLC_SW_CAP_SET__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00010000U) | ((u_int32_t)(0) << 16)

/* macros for field flc_meas_win */
#define FCAL_2_B0__FLC_MEAS_WIN__SHIFT                                       17
#define FCAL_2_B0__FLC_MEAS_WIN__WIDTH                                        3
#define FCAL_2_B0__FLC_MEAS_WIN__MASK                               0x000e0000U
#define FCAL_2_B0__FLC_MEAS_WIN__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x000e0000U) >> 17)
#define FCAL_2_B0__FLC_MEAS_WIN__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 17) & 0x000e0000U)
#define FCAL_2_B0__FLC_MEAS_WIN__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000e0000U) | (((u_int32_t)(src) <<\
                    17) & 0x000e0000U)
#define FCAL_2_B0__FLC_MEAS_WIN__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 17) & ~0x000e0000U)))

/* macros for field flc_cap_val_status_0 */
#define FCAL_2_B0__FLC_CAP_VAL_STATUS_0__SHIFT                               20
#define FCAL_2_B0__FLC_CAP_VAL_STATUS_0__WIDTH                                5
#define FCAL_2_B0__FLC_CAP_VAL_STATUS_0__MASK                       0x01f00000U
#define FCAL_2_B0__FLC_CAP_VAL_STATUS_0__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x01f00000U) >> 20)

/* macros for field flc_txbb1dbgain */
#define FCAL_2_B0__FLC_TXBB1DBGAIN__SHIFT                                    25
#define FCAL_2_B0__FLC_TXBB1DBGAIN__WIDTH                                     4
#define FCAL_2_B0__FLC_TXBB1DBGAIN__MASK                            0x1e000000U
#define FCAL_2_B0__FLC_TXBB1DBGAIN__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x1e000000U) >> 25)
#define FCAL_2_B0__FLC_TXBB1DBGAIN__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 25) & 0x1e000000U)
#define FCAL_2_B0__FLC_TXBB1DBGAIN__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x1e000000U) | (((u_int32_t)(src) <<\
                    25) & 0x1e000000U)
#define FCAL_2_B0__FLC_TXBB1DBGAIN__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 25) & ~0x1e000000U)))

/* macros for field flc_txbb6dbgain */
#define FCAL_2_B0__FLC_TXBB6DBGAIN__SHIFT                                    29
#define FCAL_2_B0__FLC_TXBB6DBGAIN__WIDTH                                     2
#define FCAL_2_B0__FLC_TXBB6DBGAIN__MASK                            0x60000000U
#define FCAL_2_B0__FLC_TXBB6DBGAIN__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x60000000U) >> 29)
#define FCAL_2_B0__FLC_TXBB6DBGAIN__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 29) & 0x60000000U)
#define FCAL_2_B0__FLC_TXBB6DBGAIN__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x60000000U) | (((u_int32_t)(src) <<\
                    29) & 0x60000000U)
#define FCAL_2_B0__FLC_TXBB6DBGAIN__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 29) & ~0x60000000U)))
#define FCAL_2_B0__TYPE                                               u_int32_t
#define FCAL_2_B0__READ                                             0x7fffffffU
#define FCAL_2_B0__WRITE                                            0x7fffffffU

#endif /* __FCAL_2_B0_MACRO__ */


/* macros for bb_reg_map.bb_sm_reg_map.BB_fcal_2_b0 */
#define INST_BB_REG_MAP__BB_SM_REG_MAP__BB_FCAL_2_B0__NUM                     1

/* macros for BlueprintGlobalNameSpace::dft_tone_ctrl_b0 */
#ifndef __DFT_TONE_CTRL_B0_MACRO__
#define __DFT_TONE_CTRL_B0_MACRO__

/* macros for field dft_tone_en_0 */
#define DFT_TONE_CTRL_B0__DFT_TONE_EN_0__SHIFT                                0
#define DFT_TONE_CTRL_B0__DFT_TONE_EN_0__WIDTH                                1
#define DFT_TONE_CTRL_B0__DFT_TONE_EN_0__MASK                       0x00000001U
#define DFT_TONE_CTRL_B0__DFT_TONE_EN_0__READ(src) \
                    (u_int32_t)(src)\
                    & 0x00000001U
#define DFT_TONE_CTRL_B0__DFT_TONE_EN_0__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x00000001U)
#define DFT_TONE_CTRL_B0__DFT_TONE_EN_0__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | ((u_int32_t)(src) &\
                    0x00000001U)
#define DFT_TONE_CTRL_B0__DFT_TONE_EN_0__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00000001U)))
#define DFT_TONE_CTRL_B0__DFT_TONE_EN_0__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(1)
#define DFT_TONE_CTRL_B0__DFT_TONE_EN_0__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(0)

/* macros for field dft_tone_amp_sel_0 */
#define DFT_TONE_CTRL_B0__DFT_TONE_AMP_SEL_0__SHIFT                           2
#define DFT_TONE_CTRL_B0__DFT_TONE_AMP_SEL_0__WIDTH                           2
#define DFT_TONE_CTRL_B0__DFT_TONE_AMP_SEL_0__MASK                  0x0000000cU
#define DFT_TONE_CTRL_B0__DFT_TONE_AMP_SEL_0__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0000000cU) >> 2)
#define DFT_TONE_CTRL_B0__DFT_TONE_AMP_SEL_0__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 2) & 0x0000000cU)
#define DFT_TONE_CTRL_B0__DFT_TONE_AMP_SEL_0__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000000cU) | (((u_int32_t)(src) <<\
                    2) & 0x0000000cU)
#define DFT_TONE_CTRL_B0__DFT_TONE_AMP_SEL_0__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 2) & ~0x0000000cU)))

/* macros for field dft_tone_freq_ang_0 */
#define DFT_TONE_CTRL_B0__DFT_TONE_FREQ_ANG_0__SHIFT                          4
#define DFT_TONE_CTRL_B0__DFT_TONE_FREQ_ANG_0__WIDTH                          9
#define DFT_TONE_CTRL_B0__DFT_TONE_FREQ_ANG_0__MASK                 0x00001ff0U
#define DFT_TONE_CTRL_B0__DFT_TONE_FREQ_ANG_0__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00001ff0U) >> 4)
#define DFT_TONE_CTRL_B0__DFT_TONE_FREQ_ANG_0__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 4) & 0x00001ff0U)
#define DFT_TONE_CTRL_B0__DFT_TONE_FREQ_ANG_0__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00001ff0U) | (((u_int32_t)(src) <<\
                    4) & 0x00001ff0U)
#define DFT_TONE_CTRL_B0__DFT_TONE_FREQ_ANG_0__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 4) & ~0x00001ff0U)))
#define DFT_TONE_CTRL_B0__TYPE                                        u_int32_t
#define DFT_TONE_CTRL_B0__READ                                      0x00001ffdU
#define DFT_TONE_CTRL_B0__WRITE                                     0x00001ffdU

#endif /* __DFT_TONE_CTRL_B0_MACRO__ */


/* macros for bb_reg_map.bb_sm_reg_map.BB_dft_tone_ctrl_b0 */
#define INST_BB_REG_MAP__BB_SM_REG_MAP__BB_DFT_TONE_CTRL_B0__NUM              1

/* macros for BlueprintGlobalNameSpace::cl_cal_ctrl */
#ifndef __CL_CAL_CTRL_MACRO__
#define __CL_CAL_CTRL_MACRO__

/* macros for field enable_parallel_cal */
#define CL_CAL_CTRL__ENABLE_PARALLEL_CAL__SHIFT                               0
#define CL_CAL_CTRL__ENABLE_PARALLEL_CAL__WIDTH                               1
#define CL_CAL_CTRL__ENABLE_PARALLEL_CAL__MASK                      0x00000001U
#define CL_CAL_CTRL__ENABLE_PARALLEL_CAL__READ(src) \
                    (u_int32_t)(src)\
                    & 0x00000001U
#define CL_CAL_CTRL__ENABLE_PARALLEL_CAL__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x00000001U)
#define CL_CAL_CTRL__ENABLE_PARALLEL_CAL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | ((u_int32_t)(src) &\
                    0x00000001U)
#define CL_CAL_CTRL__ENABLE_PARALLEL_CAL__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00000001U)))
#define CL_CAL_CTRL__ENABLE_PARALLEL_CAL__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(1)
#define CL_CAL_CTRL__ENABLE_PARALLEL_CAL__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(0)

/* macros for field enable_cl_calibrate */
#define CL_CAL_CTRL__ENABLE_CL_CALIBRATE__SHIFT                               1
#define CL_CAL_CTRL__ENABLE_CL_CALIBRATE__WIDTH                               1
#define CL_CAL_CTRL__ENABLE_CL_CALIBRATE__MASK                      0x00000002U
#define CL_CAL_CTRL__ENABLE_CL_CALIBRATE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000002U) >> 1)
#define CL_CAL_CTRL__ENABLE_CL_CALIBRATE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | ((u_int32_t)(1) << 1)
#define CL_CAL_CTRL__ENABLE_CL_CALIBRATE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000002U) | ((u_int32_t)(0) << 1)

/* macros for field cf_clc_test_point */
#define CL_CAL_CTRL__CF_CLC_TEST_POINT__SHIFT                                 2
#define CL_CAL_CTRL__CF_CLC_TEST_POINT__WIDTH                                 2
#define CL_CAL_CTRL__CF_CLC_TEST_POINT__MASK                        0x0000000cU
#define CL_CAL_CTRL__CF_CLC_TEST_POINT__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0000000cU) >> 2)
#define CL_CAL_CTRL__CF_CLC_TEST_POINT__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 2) & 0x0000000cU)
#define CL_CAL_CTRL__CF_CLC_TEST_POINT__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000000cU) | (((u_int32_t)(src) <<\
                    2) & 0x0000000cU)
#define CL_CAL_CTRL__CF_CLC_TEST_POINT__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 2) & ~0x0000000cU)))

/* macros for field cf_clc_forced_pagain */
#define CL_CAL_CTRL__CF_CLC_FORCED_PAGAIN__SHIFT                              4
#define CL_CAL_CTRL__CF_CLC_FORCED_PAGAIN__WIDTH                              4
#define CL_CAL_CTRL__CF_CLC_FORCED_PAGAIN__MASK                     0x000000f0U
#define CL_CAL_CTRL__CF_CLC_FORCED_PAGAIN__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x000000f0U) >> 4)
#define CL_CAL_CTRL__CF_CLC_FORCED_PAGAIN__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 4) & 0x000000f0U)
#define CL_CAL_CTRL__CF_CLC_FORCED_PAGAIN__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000000f0U) | (((u_int32_t)(src) <<\
                    4) & 0x000000f0U)
#define CL_CAL_CTRL__CF_CLC_FORCED_PAGAIN__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 4) & ~0x000000f0U)))

/* macros for field carr_leak_max_offset */
#define CL_CAL_CTRL__CARR_LEAK_MAX_OFFSET__SHIFT                              8
#define CL_CAL_CTRL__CARR_LEAK_MAX_OFFSET__WIDTH                              8
#define CL_CAL_CTRL__CARR_LEAK_MAX_OFFSET__MASK                     0x0000ff00U
#define CL_CAL_CTRL__CARR_LEAK_MAX_OFFSET__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0000ff00U) >> 8)
#define CL_CAL_CTRL__CARR_LEAK_MAX_OFFSET__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 8) & 0x0000ff00U)
#define CL_CAL_CTRL__CARR_LEAK_MAX_OFFSET__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000ff00U) | (((u_int32_t)(src) <<\
                    8) & 0x0000ff00U)
#define CL_CAL_CTRL__CARR_LEAK_MAX_OFFSET__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 8) & ~0x0000ff00U)))

/* macros for field cf_clc_init_bbgain */
#define CL_CAL_CTRL__CF_CLC_INIT_BBGAIN__SHIFT                               16
#define CL_CAL_CTRL__CF_CLC_INIT_BBGAIN__WIDTH                                6
#define CL_CAL_CTRL__CF_CLC_INIT_BBGAIN__MASK                       0x003f0000U
#define CL_CAL_CTRL__CF_CLC_INIT_BBGAIN__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x003f0000U) >> 16)
#define CL_CAL_CTRL__CF_CLC_INIT_BBGAIN__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 16) & 0x003f0000U)
#define CL_CAL_CTRL__CF_CLC_INIT_BBGAIN__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x003f0000U) | (((u_int32_t)(src) <<\
                    16) & 0x003f0000U)
#define CL_CAL_CTRL__CF_CLC_INIT_BBGAIN__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 16) & ~0x003f0000U)))

/* macros for field cf_adc_bound */
#define CL_CAL_CTRL__CF_ADC_BOUND__SHIFT                                     22
#define CL_CAL_CTRL__CF_ADC_BOUND__WIDTH                                      8
#define CL_CAL_CTRL__CF_ADC_BOUND__MASK                             0x3fc00000U
#define CL_CAL_CTRL__CF_ADC_BOUND__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x3fc00000U) >> 22)
#define CL_CAL_CTRL__CF_ADC_BOUND__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 22) & 0x3fc00000U)
#define CL_CAL_CTRL__CF_ADC_BOUND__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x3fc00000U) | (((u_int32_t)(src) <<\
                    22) & 0x3fc00000U)
#define CL_CAL_CTRL__CF_ADC_BOUND__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 22) & ~0x3fc00000U)))

/* macros for field use_dac_cl_correction */
#define CL_CAL_CTRL__USE_DAC_CL_CORRECTION__SHIFT                            30
#define CL_CAL_CTRL__USE_DAC_CL_CORRECTION__WIDTH                             1
#define CL_CAL_CTRL__USE_DAC_CL_CORRECTION__MASK                    0x40000000U
#define CL_CAL_CTRL__USE_DAC_CL_CORRECTION__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x40000000U) >> 30)
#define CL_CAL_CTRL__USE_DAC_CL_CORRECTION__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 30) & 0x40000000U)
#define CL_CAL_CTRL__USE_DAC_CL_CORRECTION__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x40000000U) | (((u_int32_t)(src) <<\
                    30) & 0x40000000U)
#define CL_CAL_CTRL__USE_DAC_CL_CORRECTION__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 30) & ~0x40000000U)))
#define CL_CAL_CTRL__USE_DAC_CL_CORRECTION__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x40000000U) | ((u_int32_t)(1) << 30)
#define CL_CAL_CTRL__USE_DAC_CL_CORRECTION__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x40000000U) | ((u_int32_t)(0) << 30)

/* macros for field cl_map_hw_gen */
#define CL_CAL_CTRL__CL_MAP_HW_GEN__SHIFT                                    31
#define CL_CAL_CTRL__CL_MAP_HW_GEN__WIDTH                                     1
#define CL_CAL_CTRL__CL_MAP_HW_GEN__MASK                            0x80000000U
#define CL_CAL_CTRL__CL_MAP_HW_GEN__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x80000000U) >> 31)
#define CL_CAL_CTRL__CL_MAP_HW_GEN__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 31) & 0x80000000U)
#define CL_CAL_CTRL__CL_MAP_HW_GEN__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x80000000U) | (((u_int32_t)(src) <<\
                    31) & 0x80000000U)
#define CL_CAL_CTRL__CL_MAP_HW_GEN__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 31) & ~0x80000000U)))
#define CL_CAL_CTRL__CL_MAP_HW_GEN__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x80000000U) | ((u_int32_t)(1) << 31)
#define CL_CAL_CTRL__CL_MAP_HW_GEN__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x80000000U) | ((u_int32_t)(0) << 31)
#define CL_CAL_CTRL__TYPE                                             u_int32_t
#define CL_CAL_CTRL__READ                                           0xffffffffU
#define CL_CAL_CTRL__WRITE                                          0xffffffffU

#endif /* __CL_CAL_CTRL_MACRO__ */


/* macros for bb_reg_map.bb_sm_reg_map.BB_cl_cal_ctrl */
#define INST_BB_REG_MAP__BB_SM_REG_MAP__BB_CL_CAL_CTRL__NUM                   1

/* macros for BlueprintGlobalNameSpace::cl_map_0 */
#ifndef __CL_MAP_0_MACRO__
#define __CL_MAP_0_MACRO__

/* macros for field cl_map_0 */
#define CL_MAP_0__CL_MAP_0__SHIFT                                             0
#define CL_MAP_0__CL_MAP_0__WIDTH                                            32
#define CL_MAP_0__CL_MAP_0__MASK                                    0xffffffffU
#define CL_MAP_0__CL_MAP_0__READ(src)            (u_int32_t)(src) & 0xffffffffU
#define CL_MAP_0__CL_MAP_0__WRITE(src)         ((u_int32_t)(src) & 0xffffffffU)
#define CL_MAP_0__CL_MAP_0__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xffffffffU) | ((u_int32_t)(src) &\
                    0xffffffffU)
#define CL_MAP_0__CL_MAP_0__VERIFY(src)  (!(((u_int32_t)(src) & ~0xffffffffU)))
#define CL_MAP_0__TYPE                                                u_int32_t
#define CL_MAP_0__READ                                              0xffffffffU
#define CL_MAP_0__WRITE                                             0xffffffffU

#endif /* __CL_MAP_0_MACRO__ */


/* macros for bb_reg_map.bb_sm_reg_map.BB_cl_map_0_b0 */
#define INST_BB_REG_MAP__BB_SM_REG_MAP__BB_CL_MAP_0_B0__NUM                   1

/* macros for BlueprintGlobalNameSpace::cl_map_1 */
#ifndef __CL_MAP_1_MACRO__
#define __CL_MAP_1_MACRO__

/* macros for field cl_map_1 */
#define CL_MAP_1__CL_MAP_1__SHIFT                                             0
#define CL_MAP_1__CL_MAP_1__WIDTH                                            32
#define CL_MAP_1__CL_MAP_1__MASK                                    0xffffffffU
#define CL_MAP_1__CL_MAP_1__READ(src)            (u_int32_t)(src) & 0xffffffffU
#define CL_MAP_1__CL_MAP_1__WRITE(src)         ((u_int32_t)(src) & 0xffffffffU)
#define CL_MAP_1__CL_MAP_1__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xffffffffU) | ((u_int32_t)(src) &\
                    0xffffffffU)
#define CL_MAP_1__CL_MAP_1__VERIFY(src)  (!(((u_int32_t)(src) & ~0xffffffffU)))
#define CL_MAP_1__TYPE                                                u_int32_t
#define CL_MAP_1__READ                                              0xffffffffU
#define CL_MAP_1__WRITE                                             0xffffffffU

#endif /* __CL_MAP_1_MACRO__ */


/* macros for bb_reg_map.bb_sm_reg_map.BB_cl_map_1_b0 */
#define INST_BB_REG_MAP__BB_SM_REG_MAP__BB_CL_MAP_1_B0__NUM                   1

/* macros for BlueprintGlobalNameSpace::cl_map_2 */
#ifndef __CL_MAP_2_MACRO__
#define __CL_MAP_2_MACRO__

/* macros for field cl_map_2 */
#define CL_MAP_2__CL_MAP_2__SHIFT                                             0
#define CL_MAP_2__CL_MAP_2__WIDTH                                            32
#define CL_MAP_2__CL_MAP_2__MASK                                    0xffffffffU
#define CL_MAP_2__CL_MAP_2__READ(src)            (u_int32_t)(src) & 0xffffffffU
#define CL_MAP_2__CL_MAP_2__WRITE(src)         ((u_int32_t)(src) & 0xffffffffU)
#define CL_MAP_2__CL_MAP_2__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xffffffffU) | ((u_int32_t)(src) &\
                    0xffffffffU)
#define CL_MAP_2__CL_MAP_2__VERIFY(src)  (!(((u_int32_t)(src) & ~0xffffffffU)))
#define CL_MAP_2__TYPE                                                u_int32_t
#define CL_MAP_2__READ                                              0xffffffffU
#define CL_MAP_2__WRITE                                             0xffffffffU

#endif /* __CL_MAP_2_MACRO__ */


/* macros for bb_reg_map.bb_sm_reg_map.BB_cl_map_2_b0 */
#define INST_BB_REG_MAP__BB_SM_REG_MAP__BB_CL_MAP_2_B0__NUM                   1

/* macros for BlueprintGlobalNameSpace::cl_map_3 */
#ifndef __CL_MAP_3_MACRO__
#define __CL_MAP_3_MACRO__

/* macros for field cl_map_3 */
#define CL_MAP_3__CL_MAP_3__SHIFT                                             0
#define CL_MAP_3__CL_MAP_3__WIDTH                                            32
#define CL_MAP_3__CL_MAP_3__MASK                                    0xffffffffU
#define CL_MAP_3__CL_MAP_3__READ(src)            (u_int32_t)(src) & 0xffffffffU
#define CL_MAP_3__CL_MAP_3__WRITE(src)         ((u_int32_t)(src) & 0xffffffffU)
#define CL_MAP_3__CL_MAP_3__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0xffffffffU) | ((u_int32_t)(src) &\
                    0xffffffffU)
#define CL_MAP_3__CL_MAP_3__VERIFY(src)  (!(((u_int32_t)(src) & ~0xffffffffU)))
#define CL_MAP_3__TYPE                                                u_int32_t
#define CL_MAP_3__READ                                              0xffffffffU
#define CL_MAP_3__WRITE                                             0xffffffffU

#endif /* __CL_MAP_3_MACRO__ */


/* macros for bb_reg_map.bb_sm_reg_map.BB_cl_map_3_b0 */
#define INST_BB_REG_MAP__BB_SM_REG_MAP__BB_CL_MAP_3_B0__NUM                   1

/* macros for BlueprintGlobalNameSpace::cl_tab */
#ifndef __CL_TAB_MACRO__
#define __CL_TAB_MACRO__

/* macros for field cl_gain_mod */
#define CL_TAB__CL_GAIN_MOD__SHIFT                                            0
#define CL_TAB__CL_GAIN_MOD__WIDTH                                            5
#define CL_TAB__CL_GAIN_MOD__MASK                                   0x0000001fU
#define CL_TAB__CL_GAIN_MOD__READ(src)           (u_int32_t)(src) & 0x0000001fU
#define CL_TAB__CL_GAIN_MOD__WRITE(src)        ((u_int32_t)(src) & 0x0000001fU)
#define CL_TAB__CL_GAIN_MOD__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000001fU) | ((u_int32_t)(src) &\
                    0x0000001fU)
#define CL_TAB__CL_GAIN_MOD__VERIFY(src) (!(((u_int32_t)(src) & ~0x0000001fU)))

/* macros for field carr_lk_dc_add_Q */
#define CL_TAB__CARR_LK_DC_ADD_Q__SHIFT                                       5
#define CL_TAB__CARR_LK_DC_ADD_Q__WIDTH                                      11
#define CL_TAB__CARR_LK_DC_ADD_Q__MASK                              0x0000ffe0U
#define CL_TAB__CARR_LK_DC_ADD_Q__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0000ffe0U) >> 5)
#define CL_TAB__CARR_LK_DC_ADD_Q__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 5) & 0x0000ffe0U)
#define CL_TAB__CARR_LK_DC_ADD_Q__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000ffe0U) | (((u_int32_t)(src) <<\
                    5) & 0x0000ffe0U)
#define CL_TAB__CARR_LK_DC_ADD_Q__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 5) & ~0x0000ffe0U)))

/* macros for field carr_lk_dc_add_I */
#define CL_TAB__CARR_LK_DC_ADD_I__SHIFT                                      16
#define CL_TAB__CARR_LK_DC_ADD_I__WIDTH                                      11
#define CL_TAB__CARR_LK_DC_ADD_I__MASK                              0x07ff0000U
#define CL_TAB__CARR_LK_DC_ADD_I__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x07ff0000U) >> 16)
#define CL_TAB__CARR_LK_DC_ADD_I__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 16) & 0x07ff0000U)
#define CL_TAB__CARR_LK_DC_ADD_I__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x07ff0000U) | (((u_int32_t)(src) <<\
                    16) & 0x07ff0000U)
#define CL_TAB__CARR_LK_DC_ADD_I__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 16) & ~0x07ff0000U)))

/* macros for field bb_gain */
#define CL_TAB__BB_GAIN__SHIFT                                               27
#define CL_TAB__BB_GAIN__WIDTH                                                4
#define CL_TAB__BB_GAIN__MASK                                       0x78000000U
#define CL_TAB__BB_GAIN__READ(src)     (((u_int32_t)(src) & 0x78000000U) >> 27)
#define CL_TAB__BB_GAIN__WRITE(src)    (((u_int32_t)(src) << 27) & 0x78000000U)
#define CL_TAB__BB_GAIN__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x78000000U) | (((u_int32_t)(src) <<\
                    27) & 0x78000000U)
#define CL_TAB__BB_GAIN__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 27) & ~0x78000000U)))
#define CL_TAB__TYPE                                                  u_int32_t
#define CL_TAB__READ                                                0x7fffffffU
#define CL_TAB__WRITE                                               0x7fffffffU

#endif /* __CL_TAB_MACRO__ */


/* macros for bb_reg_map.bb_sm_reg_map.BB_cl_tab_b0 */
#define INST_BB_REG_MAP__BB_SM_REG_MAP__BB_CL_TAB_B0__NUM                    16

/* macros for BlueprintGlobalNameSpace::synth_control */
#ifndef __SYNTH_CONTROL_MACRO__
#define __SYNTH_CONTROL_MACRO__

/* macros for field rfchanFrac */
#define SYNTH_CONTROL__RFCHANFRAC__SHIFT                                      0
#define SYNTH_CONTROL__RFCHANFRAC__WIDTH                                     17
#define SYNTH_CONTROL__RFCHANFRAC__MASK                             0x0001ffffU
#define SYNTH_CONTROL__RFCHANFRAC__READ(src)     (u_int32_t)(src) & 0x0001ffffU
#define SYNTH_CONTROL__RFCHANFRAC__WRITE(src)  ((u_int32_t)(src) & 0x0001ffffU)
#define SYNTH_CONTROL__RFCHANFRAC__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0001ffffU) | ((u_int32_t)(src) &\
                    0x0001ffffU)
#define SYNTH_CONTROL__RFCHANFRAC__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x0001ffffU)))

/* macros for field rfchannel */
#define SYNTH_CONTROL__RFCHANNEL__SHIFT                                      17
#define SYNTH_CONTROL__RFCHANNEL__WIDTH                                       9
#define SYNTH_CONTROL__RFCHANNEL__MASK                              0x03fe0000U
#define SYNTH_CONTROL__RFCHANNEL__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x03fe0000U) >> 17)
#define SYNTH_CONTROL__RFCHANNEL__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 17) & 0x03fe0000U)
#define SYNTH_CONTROL__RFCHANNEL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x03fe0000U) | (((u_int32_t)(src) <<\
                    17) & 0x03fe0000U)
#define SYNTH_CONTROL__RFCHANNEL__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 17) & ~0x03fe0000U)))

/* macros for field rfAmodeRefSel */
#define SYNTH_CONTROL__RFAMODEREFSEL__SHIFT                                  26
#define SYNTH_CONTROL__RFAMODEREFSEL__WIDTH                                   2
#define SYNTH_CONTROL__RFAMODEREFSEL__MASK                          0x0c000000U
#define SYNTH_CONTROL__RFAMODEREFSEL__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0c000000U) >> 26)
#define SYNTH_CONTROL__RFAMODEREFSEL__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 26) & 0x0c000000U)
#define SYNTH_CONTROL__RFAMODEREFSEL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0c000000U) | (((u_int32_t)(src) <<\
                    26) & 0x0c000000U)
#define SYNTH_CONTROL__RFAMODEREFSEL__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 26) & ~0x0c000000U)))

/* macros for field rfFracmode */
#define SYNTH_CONTROL__RFFRACMODE__SHIFT                                     28
#define SYNTH_CONTROL__RFFRACMODE__WIDTH                                      1
#define SYNTH_CONTROL__RFFRACMODE__MASK                             0x10000000U
#define SYNTH_CONTROL__RFFRACMODE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x10000000U) >> 28)
#define SYNTH_CONTROL__RFFRACMODE__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 28) & 0x10000000U)
#define SYNTH_CONTROL__RFFRACMODE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x10000000U) | (((u_int32_t)(src) <<\
                    28) & 0x10000000U)
#define SYNTH_CONTROL__RFFRACMODE__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 28) & ~0x10000000U)))
#define SYNTH_CONTROL__RFFRACMODE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x10000000U) | ((u_int32_t)(1) << 28)
#define SYNTH_CONTROL__RFFRACMODE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x10000000U) | ((u_int32_t)(0) << 28)

/* macros for field rfbmode */
#define SYNTH_CONTROL__RFBMODE__SHIFT                                        29
#define SYNTH_CONTROL__RFBMODE__WIDTH                                         1
#define SYNTH_CONTROL__RFBMODE__MASK                                0x20000000U
#define SYNTH_CONTROL__RFBMODE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x20000000U) >> 29)
#define SYNTH_CONTROL__RFBMODE__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 29) & 0x20000000U)
#define SYNTH_CONTROL__RFBMODE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x20000000U) | (((u_int32_t)(src) <<\
                    29) & 0x20000000U)
#define SYNTH_CONTROL__RFBMODE__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 29) & ~0x20000000U)))
#define SYNTH_CONTROL__RFBMODE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x20000000U) | ((u_int32_t)(1) << 29)
#define SYNTH_CONTROL__RFBMODE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x20000000U) | ((u_int32_t)(0) << 29)

/* macros for field rfsynth_ctrl_sshift */
#define SYNTH_CONTROL__RFSYNTH_CTRL_SSHIFT__SHIFT                            30
#define SYNTH_CONTROL__RFSYNTH_CTRL_SSHIFT__WIDTH                             1
#define SYNTH_CONTROL__RFSYNTH_CTRL_SSHIFT__MASK                    0x40000000U
#define SYNTH_CONTROL__RFSYNTH_CTRL_SSHIFT__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x40000000U) >> 30)
#define SYNTH_CONTROL__RFSYNTH_CTRL_SSHIFT__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 30) & 0x40000000U)
#define SYNTH_CONTROL__RFSYNTH_CTRL_SSHIFT__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x40000000U) | (((u_int32_t)(src) <<\
                    30) & 0x40000000U)
#define SYNTH_CONTROL__RFSYNTH_CTRL_SSHIFT__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 30) & ~0x40000000U)))
#define SYNTH_CONTROL__RFSYNTH_CTRL_SSHIFT__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x40000000U) | ((u_int32_t)(1) << 30)
#define SYNTH_CONTROL__RFSYNTH_CTRL_SSHIFT__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x40000000U) | ((u_int32_t)(0) << 30)

/* macros for field sel_alt_tables */
#define SYNTH_CONTROL__SEL_ALT_TABLES__SHIFT                                 31
#define SYNTH_CONTROL__SEL_ALT_TABLES__WIDTH                                  1
#define SYNTH_CONTROL__SEL_ALT_TABLES__MASK                         0x80000000U
#define SYNTH_CONTROL__SEL_ALT_TABLES__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x80000000U) >> 31)
#define SYNTH_CONTROL__SEL_ALT_TABLES__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 31) & 0x80000000U)
#define SYNTH_CONTROL__SEL_ALT_TABLES__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x80000000U) | (((u_int32_t)(src) <<\
                    31) & 0x80000000U)
#define SYNTH_CONTROL__SEL_ALT_TABLES__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 31) & ~0x80000000U)))
#define SYNTH_CONTROL__SEL_ALT_TABLES__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x80000000U) | ((u_int32_t)(1) << 31)
#define SYNTH_CONTROL__SEL_ALT_TABLES__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x80000000U) | ((u_int32_t)(0) << 31)
#define SYNTH_CONTROL__TYPE                                           u_int32_t
#define SYNTH_CONTROL__READ                                         0xffffffffU
#define SYNTH_CONTROL__WRITE                                        0xffffffffU

#endif /* __SYNTH_CONTROL_MACRO__ */


/* macros for bb_reg_map.bb_sm_reg_map.BB_synth_control */
#define INST_BB_REG_MAP__BB_SM_REG_MAP__BB_SYNTH_CONTROL__NUM                 1

/* macros for BlueprintGlobalNameSpace::addac_clk_select */
#ifndef __ADDAC_CLK_SELECT_MACRO__
#define __ADDAC_CLK_SELECT_MACRO__

/* macros for field bb_dac_clk_select */
#define ADDAC_CLK_SELECT__BB_DAC_CLK_SELECT__SHIFT                            0
#define ADDAC_CLK_SELECT__BB_DAC_CLK_SELECT__WIDTH                            4
#define ADDAC_CLK_SELECT__BB_DAC_CLK_SELECT__MASK                   0x0000000fU
#define ADDAC_CLK_SELECT__BB_DAC_CLK_SELECT__READ(src) \
                    (u_int32_t)(src)\
                    & 0x0000000fU
#define ADDAC_CLK_SELECT__BB_DAC_CLK_SELECT__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x0000000fU)
#define ADDAC_CLK_SELECT__BB_DAC_CLK_SELECT__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000000fU) | ((u_int32_t)(src) &\
                    0x0000000fU)
#define ADDAC_CLK_SELECT__BB_DAC_CLK_SELECT__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x0000000fU)))

/* macros for field bb_adc_clk_select_ch0 */
#define ADDAC_CLK_SELECT__BB_ADC_CLK_SELECT_CH0__SHIFT                        4
#define ADDAC_CLK_SELECT__BB_ADC_CLK_SELECT_CH0__WIDTH                        2
#define ADDAC_CLK_SELECT__BB_ADC_CLK_SELECT_CH0__MASK               0x00000030U
#define ADDAC_CLK_SELECT__BB_ADC_CLK_SELECT_CH0__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000030U) >> 4)
#define ADDAC_CLK_SELECT__BB_ADC_CLK_SELECT_CH0__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 4) & 0x00000030U)
#define ADDAC_CLK_SELECT__BB_ADC_CLK_SELECT_CH0__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000030U) | (((u_int32_t)(src) <<\
                    4) & 0x00000030U)
#define ADDAC_CLK_SELECT__BB_ADC_CLK_SELECT_CH0__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 4) & ~0x00000030U)))

/* macros for field bb_adc_clk_select_ch1 */
#define ADDAC_CLK_SELECT__BB_ADC_CLK_SELECT_CH1__SHIFT                        6
#define ADDAC_CLK_SELECT__BB_ADC_CLK_SELECT_CH1__WIDTH                        2
#define ADDAC_CLK_SELECT__BB_ADC_CLK_SELECT_CH1__MASK               0x000000c0U
#define ADDAC_CLK_SELECT__BB_ADC_CLK_SELECT_CH1__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x000000c0U) >> 6)
#define ADDAC_CLK_SELECT__BB_ADC_CLK_SELECT_CH1__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 6) & 0x000000c0U)
#define ADDAC_CLK_SELECT__BB_ADC_CLK_SELECT_CH1__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000000c0U) | (((u_int32_t)(src) <<\
                    6) & 0x000000c0U)
#define ADDAC_CLK_SELECT__BB_ADC_CLK_SELECT_CH1__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 6) & ~0x000000c0U)))

/* macros for field bb_adc_clk_select_ch2 */
#define ADDAC_CLK_SELECT__BB_ADC_CLK_SELECT_CH2__SHIFT                        8
#define ADDAC_CLK_SELECT__BB_ADC_CLK_SELECT_CH2__WIDTH                        2
#define ADDAC_CLK_SELECT__BB_ADC_CLK_SELECT_CH2__MASK               0x00000300U
#define ADDAC_CLK_SELECT__BB_ADC_CLK_SELECT_CH2__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000300U) >> 8)
#define ADDAC_CLK_SELECT__BB_ADC_CLK_SELECT_CH2__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 8) & 0x00000300U)
#define ADDAC_CLK_SELECT__BB_ADC_CLK_SELECT_CH2__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000300U) | (((u_int32_t)(src) <<\
                    8) & 0x00000300U)
#define ADDAC_CLK_SELECT__BB_ADC_CLK_SELECT_CH2__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 8) & ~0x00000300U)))

/* macros for field bb_adc_clk_select_ch3 */
#define ADDAC_CLK_SELECT__BB_ADC_CLK_SELECT_CH3__SHIFT                       10
#define ADDAC_CLK_SELECT__BB_ADC_CLK_SELECT_CH3__WIDTH                        2
#define ADDAC_CLK_SELECT__BB_ADC_CLK_SELECT_CH3__MASK               0x00000c00U
#define ADDAC_CLK_SELECT__BB_ADC_CLK_SELECT_CH3__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000c00U) >> 10)
#define ADDAC_CLK_SELECT__BB_ADC_CLK_SELECT_CH3__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 10) & 0x00000c00U)
#define ADDAC_CLK_SELECT__BB_ADC_CLK_SELECT_CH3__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000c00U) | (((u_int32_t)(src) <<\
                    10) & 0x00000c00U)
#define ADDAC_CLK_SELECT__BB_ADC_CLK_SELECT_CH3__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 10) & ~0x00000c00U)))
#define ADDAC_CLK_SELECT__TYPE                                        u_int32_t
#define ADDAC_CLK_SELECT__READ                                      0x00000fffU
#define ADDAC_CLK_SELECT__WRITE                                     0x00000fffU

#endif /* __ADDAC_CLK_SELECT_MACRO__ */


/* macros for bb_reg_map.bb_sm_reg_map.BB_addac_clk_select */
#define INST_BB_REG_MAP__BB_SM_REG_MAP__BB_ADDAC_CLK_SELECT__NUM              1

/* macros for BlueprintGlobalNameSpace::pll_cntl */
#ifndef __PLL_CNTL_MACRO__
#define __PLL_CNTL_MACRO__

/* macros for field bb_pll_div */
#define PLL_CNTL__BB_PLL_DIV__SHIFT                                           0
#define PLL_CNTL__BB_PLL_DIV__WIDTH                                          10
#define PLL_CNTL__BB_PLL_DIV__MASK                                  0x000003ffU
#define PLL_CNTL__BB_PLL_DIV__READ(src)          (u_int32_t)(src) & 0x000003ffU
#define PLL_CNTL__BB_PLL_DIV__WRITE(src)       ((u_int32_t)(src) & 0x000003ffU)
#define PLL_CNTL__BB_PLL_DIV__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x000003ffU) | ((u_int32_t)(src) &\
                    0x000003ffU)
#define PLL_CNTL__BB_PLL_DIV__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x000003ffU)))

/* macros for field bb_pll_refdiv */
#define PLL_CNTL__BB_PLL_REFDIV__SHIFT                                       10
#define PLL_CNTL__BB_PLL_REFDIV__WIDTH                                        4
#define PLL_CNTL__BB_PLL_REFDIV__MASK                               0x00003c00U
#define PLL_CNTL__BB_PLL_REFDIV__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00003c00U) >> 10)
#define PLL_CNTL__BB_PLL_REFDIV__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 10) & 0x00003c00U)
#define PLL_CNTL__BB_PLL_REFDIV__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00003c00U) | (((u_int32_t)(src) <<\
                    10) & 0x00003c00U)
#define PLL_CNTL__BB_PLL_REFDIV__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 10) & ~0x00003c00U)))

/* macros for field bb_pll_clk_sel */
#define PLL_CNTL__BB_PLL_CLK_SEL__SHIFT                                      14
#define PLL_CNTL__BB_PLL_CLK_SEL__WIDTH                                       2
#define PLL_CNTL__BB_PLL_CLK_SEL__MASK                              0x0000c000U
#define PLL_CNTL__BB_PLL_CLK_SEL__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0000c000U) >> 14)
#define PLL_CNTL__BB_PLL_CLK_SEL__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 14) & 0x0000c000U)
#define PLL_CNTL__BB_PLL_CLK_SEL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0000c000U) | (((u_int32_t)(src) <<\
                    14) & 0x0000c000U)
#define PLL_CNTL__BB_PLL_CLK_SEL__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 14) & ~0x0000c000U)))

/* macros for field bb_pllbypass */
#define PLL_CNTL__BB_PLLBYPASS__SHIFT                                        16
#define PLL_CNTL__BB_PLLBYPASS__WIDTH                                         1
#define PLL_CNTL__BB_PLLBYPASS__MASK                                0x00010000U
#define PLL_CNTL__BB_PLLBYPASS__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00010000U) >> 16)
#define PLL_CNTL__BB_PLLBYPASS__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 16) & 0x00010000U)
#define PLL_CNTL__BB_PLLBYPASS__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00010000U) | (((u_int32_t)(src) <<\
                    16) & 0x00010000U)
#define PLL_CNTL__BB_PLLBYPASS__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 16) & ~0x00010000U)))
#define PLL_CNTL__BB_PLLBYPASS__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00010000U) | ((u_int32_t)(1) << 16)
#define PLL_CNTL__BB_PLLBYPASS__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00010000U) | ((u_int32_t)(0) << 16)

/* macros for field bb_pll_settle_time */
#define PLL_CNTL__BB_PLL_SETTLE_TIME__SHIFT                                  17
#define PLL_CNTL__BB_PLL_SETTLE_TIME__WIDTH                                  11
#define PLL_CNTL__BB_PLL_SETTLE_TIME__MASK                          0x0ffe0000U
#define PLL_CNTL__BB_PLL_SETTLE_TIME__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x0ffe0000U) >> 17)
#define PLL_CNTL__BB_PLL_SETTLE_TIME__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 17) & 0x0ffe0000U)
#define PLL_CNTL__BB_PLL_SETTLE_TIME__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x0ffe0000U) | (((u_int32_t)(src) <<\
                    17) & 0x0ffe0000U)
#define PLL_CNTL__BB_PLL_SETTLE_TIME__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 17) & ~0x0ffe0000U)))
#define PLL_CNTL__TYPE                                                u_int32_t
#define PLL_CNTL__READ                                              0x0fffffffU
#define PLL_CNTL__WRITE                                             0x0fffffffU

#endif /* __PLL_CNTL_MACRO__ */


/* macros for bb_reg_map.bb_sm_reg_map.BB_pll_cntl */
#define INST_BB_REG_MAP__BB_SM_REG_MAP__BB_PLL_CNTL__NUM                      1

/* macros for BlueprintGlobalNameSpace::analog_swap */
#ifndef __ANALOG_SWAP_MACRO__
#define __ANALOG_SWAP_MACRO__

/* macros for field analog_rx_swap_cntl */
#define ANALOG_SWAP__ANALOG_RX_SWAP_CNTL__SHIFT                               0
#define ANALOG_SWAP__ANALOG_RX_SWAP_CNTL__WIDTH                               3
#define ANALOG_SWAP__ANALOG_RX_SWAP_CNTL__MASK                      0x00000007U
#define ANALOG_SWAP__ANALOG_RX_SWAP_CNTL__READ(src) \
                    (u_int32_t)(src)\
                    & 0x00000007U
#define ANALOG_SWAP__ANALOG_RX_SWAP_CNTL__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x00000007U)
#define ANALOG_SWAP__ANALOG_RX_SWAP_CNTL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000007U) | ((u_int32_t)(src) &\
                    0x00000007U)
#define ANALOG_SWAP__ANALOG_RX_SWAP_CNTL__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00000007U)))

/* macros for field analog_tx_swap_cntl */
#define ANALOG_SWAP__ANALOG_TX_SWAP_CNTL__SHIFT                               3
#define ANALOG_SWAP__ANALOG_TX_SWAP_CNTL__WIDTH                               3
#define ANALOG_SWAP__ANALOG_TX_SWAP_CNTL__MASK                      0x00000038U
#define ANALOG_SWAP__ANALOG_TX_SWAP_CNTL__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000038U) >> 3)
#define ANALOG_SWAP__ANALOG_TX_SWAP_CNTL__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 3) & 0x00000038U)
#define ANALOG_SWAP__ANALOG_TX_SWAP_CNTL__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000038U) | (((u_int32_t)(src) <<\
                    3) & 0x00000038U)
#define ANALOG_SWAP__ANALOG_TX_SWAP_CNTL__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 3) & ~0x00000038U)))

/* macros for field swap_alt_chn */
#define ANALOG_SWAP__SWAP_ALT_CHN__SHIFT                                      6
#define ANALOG_SWAP__SWAP_ALT_CHN__WIDTH                                      1
#define ANALOG_SWAP__SWAP_ALT_CHN__MASK                             0x00000040U
#define ANALOG_SWAP__SWAP_ALT_CHN__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000040U) >> 6)
#define ANALOG_SWAP__SWAP_ALT_CHN__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 6) & 0x00000040U)
#define ANALOG_SWAP__SWAP_ALT_CHN__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000040U) | (((u_int32_t)(src) <<\
                    6) & 0x00000040U)
#define ANALOG_SWAP__SWAP_ALT_CHN__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 6) & ~0x00000040U)))
#define ANALOG_SWAP__SWAP_ALT_CHN__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000040U) | ((u_int32_t)(1) << 6)
#define ANALOG_SWAP__SWAP_ALT_CHN__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000040U) | ((u_int32_t)(0) << 6)

/* macros for field analog_dc_dac_polarity */
#define ANALOG_SWAP__ANALOG_DC_DAC_POLARITY__SHIFT                            7
#define ANALOG_SWAP__ANALOG_DC_DAC_POLARITY__WIDTH                            1
#define ANALOG_SWAP__ANALOG_DC_DAC_POLARITY__MASK                   0x00000080U
#define ANALOG_SWAP__ANALOG_DC_DAC_POLARITY__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000080U) >> 7)
#define ANALOG_SWAP__ANALOG_DC_DAC_POLARITY__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 7) & 0x00000080U)
#define ANALOG_SWAP__ANALOG_DC_DAC_POLARITY__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000080U) | (((u_int32_t)(src) <<\
                    7) & 0x00000080U)
#define ANALOG_SWAP__ANALOG_DC_DAC_POLARITY__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 7) & ~0x00000080U)))
#define ANALOG_SWAP__ANALOG_DC_DAC_POLARITY__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000080U) | ((u_int32_t)(1) << 7)
#define ANALOG_SWAP__ANALOG_DC_DAC_POLARITY__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000080U) | ((u_int32_t)(0) << 7)

/* macros for field analog_pkdet_dac_polarity */
#define ANALOG_SWAP__ANALOG_PKDET_DAC_POLARITY__SHIFT                         8
#define ANALOG_SWAP__ANALOG_PKDET_DAC_POLARITY__WIDTH                         1
#define ANALOG_SWAP__ANALOG_PKDET_DAC_POLARITY__MASK                0x00000100U
#define ANALOG_SWAP__ANALOG_PKDET_DAC_POLARITY__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000100U) >> 8)
#define ANALOG_SWAP__ANALOG_PKDET_DAC_POLARITY__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 8) & 0x00000100U)
#define ANALOG_SWAP__ANALOG_PKDET_DAC_POLARITY__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000100U) | (((u_int32_t)(src) <<\
                    8) & 0x00000100U)
#define ANALOG_SWAP__ANALOG_PKDET_DAC_POLARITY__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 8) & ~0x00000100U)))
#define ANALOG_SWAP__ANALOG_PKDET_DAC_POLARITY__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000100U) | ((u_int32_t)(1) << 8)
#define ANALOG_SWAP__ANALOG_PKDET_DAC_POLARITY__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000100U) | ((u_int32_t)(0) << 8)
#define ANALOG_SWAP__TYPE                                             u_int32_t
#define ANALOG_SWAP__READ                                           0x000001ffU
#define ANALOG_SWAP__WRITE                                          0x000001ffU

#endif /* __ANALOG_SWAP_MACRO__ */


/* macros for bb_reg_map.bb_sm_reg_map.BB_analog_swap */
#define INST_BB_REG_MAP__BB_SM_REG_MAP__BB_ANALOG_SWAP__NUM                   1

/* macros for BlueprintGlobalNameSpace::addac_parallel_control */
#ifndef __ADDAC_PARALLEL_CONTROL_MACRO__
#define __ADDAC_PARALLEL_CONTROL_MACRO__

/* macros for field off_daclpmode */
#define ADDAC_PARALLEL_CONTROL__OFF_DACLPMODE__SHIFT                         12
#define ADDAC_PARALLEL_CONTROL__OFF_DACLPMODE__WIDTH                          1
#define ADDAC_PARALLEL_CONTROL__OFF_DACLPMODE__MASK                 0x00001000U
#define ADDAC_PARALLEL_CONTROL__OFF_DACLPMODE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00001000U) >> 12)
#define ADDAC_PARALLEL_CONTROL__OFF_DACLPMODE__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 12) & 0x00001000U)
#define ADDAC_PARALLEL_CONTROL__OFF_DACLPMODE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00001000U) | (((u_int32_t)(src) <<\
                    12) & 0x00001000U)
#define ADDAC_PARALLEL_CONTROL__OFF_DACLPMODE__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 12) & ~0x00001000U)))
#define ADDAC_PARALLEL_CONTROL__OFF_DACLPMODE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00001000U) | ((u_int32_t)(1) << 12)
#define ADDAC_PARALLEL_CONTROL__OFF_DACLPMODE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00001000U) | ((u_int32_t)(0) << 12)

/* macros for field off_pwdDac */
#define ADDAC_PARALLEL_CONTROL__OFF_PWDDAC__SHIFT                            13
#define ADDAC_PARALLEL_CONTROL__OFF_PWDDAC__WIDTH                             1
#define ADDAC_PARALLEL_CONTROL__OFF_PWDDAC__MASK                    0x00002000U
#define ADDAC_PARALLEL_CONTROL__OFF_PWDDAC__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00002000U) >> 13)
#define ADDAC_PARALLEL_CONTROL__OFF_PWDDAC__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 13) & 0x00002000U)
#define ADDAC_PARALLEL_CONTROL__OFF_PWDDAC__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00002000U) | (((u_int32_t)(src) <<\
                    13) & 0x00002000U)
#define ADDAC_PARALLEL_CONTROL__OFF_PWDDAC__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 13) & ~0x00002000U)))
#define ADDAC_PARALLEL_CONTROL__OFF_PWDDAC__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00002000U) | ((u_int32_t)(1) << 13)
#define ADDAC_PARALLEL_CONTROL__OFF_PWDDAC__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00002000U) | ((u_int32_t)(0) << 13)

/* macros for field off_pwdAdc */
#define ADDAC_PARALLEL_CONTROL__OFF_PWDADC__SHIFT                            15
#define ADDAC_PARALLEL_CONTROL__OFF_PWDADC__WIDTH                             1
#define ADDAC_PARALLEL_CONTROL__OFF_PWDADC__MASK                    0x00008000U
#define ADDAC_PARALLEL_CONTROL__OFF_PWDADC__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00008000U) >> 15)
#define ADDAC_PARALLEL_CONTROL__OFF_PWDADC__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 15) & 0x00008000U)
#define ADDAC_PARALLEL_CONTROL__OFF_PWDADC__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00008000U) | (((u_int32_t)(src) <<\
                    15) & 0x00008000U)
#define ADDAC_PARALLEL_CONTROL__OFF_PWDADC__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 15) & ~0x00008000U)))
#define ADDAC_PARALLEL_CONTROL__OFF_PWDADC__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00008000U) | ((u_int32_t)(1) << 15)
#define ADDAC_PARALLEL_CONTROL__OFF_PWDADC__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00008000U) | ((u_int32_t)(0) << 15)

/* macros for field on_daclpmode */
#define ADDAC_PARALLEL_CONTROL__ON_DACLPMODE__SHIFT                          28
#define ADDAC_PARALLEL_CONTROL__ON_DACLPMODE__WIDTH                           1
#define ADDAC_PARALLEL_CONTROL__ON_DACLPMODE__MASK                  0x10000000U
#define ADDAC_PARALLEL_CONTROL__ON_DACLPMODE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x10000000U) >> 28)
#define ADDAC_PARALLEL_CONTROL__ON_DACLPMODE__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 28) & 0x10000000U)
#define ADDAC_PARALLEL_CONTROL__ON_DACLPMODE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x10000000U) | (((u_int32_t)(src) <<\
                    28) & 0x10000000U)
#define ADDAC_PARALLEL_CONTROL__ON_DACLPMODE__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 28) & ~0x10000000U)))
#define ADDAC_PARALLEL_CONTROL__ON_DACLPMODE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x10000000U) | ((u_int32_t)(1) << 28)
#define ADDAC_PARALLEL_CONTROL__ON_DACLPMODE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x10000000U) | ((u_int32_t)(0) << 28)

/* macros for field on_pwdDac */
#define ADDAC_PARALLEL_CONTROL__ON_PWDDAC__SHIFT                             29
#define ADDAC_PARALLEL_CONTROL__ON_PWDDAC__WIDTH                              1
#define ADDAC_PARALLEL_CONTROL__ON_PWDDAC__MASK                     0x20000000U
#define ADDAC_PARALLEL_CONTROL__ON_PWDDAC__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x20000000U) >> 29)
#define ADDAC_PARALLEL_CONTROL__ON_PWDDAC__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 29) & 0x20000000U)
#define ADDAC_PARALLEL_CONTROL__ON_PWDDAC__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x20000000U) | (((u_int32_t)(src) <<\
                    29) & 0x20000000U)
#define ADDAC_PARALLEL_CONTROL__ON_PWDDAC__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 29) & ~0x20000000U)))
#define ADDAC_PARALLEL_CONTROL__ON_PWDDAC__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x20000000U) | ((u_int32_t)(1) << 29)
#define ADDAC_PARALLEL_CONTROL__ON_PWDDAC__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x20000000U) | ((u_int32_t)(0) << 29)

/* macros for field on_pwdAdc */
#define ADDAC_PARALLEL_CONTROL__ON_PWDADC__SHIFT                             31
#define ADDAC_PARALLEL_CONTROL__ON_PWDADC__WIDTH                              1
#define ADDAC_PARALLEL_CONTROL__ON_PWDADC__MASK                     0x80000000U
#define ADDAC_PARALLEL_CONTROL__ON_PWDADC__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x80000000U) >> 31)
#define ADDAC_PARALLEL_CONTROL__ON_PWDADC__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 31) & 0x80000000U)
#define ADDAC_PARALLEL_CONTROL__ON_PWDADC__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x80000000U) | (((u_int32_t)(src) <<\
                    31) & 0x80000000U)
#define ADDAC_PARALLEL_CONTROL__ON_PWDADC__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 31) & ~0x80000000U)))
#define ADDAC_PARALLEL_CONTROL__ON_PWDADC__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x80000000U) | ((u_int32_t)(1) << 31)
#define ADDAC_PARALLEL_CONTROL__ON_PWDADC__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x80000000U) | ((u_int32_t)(0) << 31)
#define ADDAC_PARALLEL_CONTROL__TYPE                                  u_int32_t
#define ADDAC_PARALLEL_CONTROL__READ                                0xb000b000U
#define ADDAC_PARALLEL_CONTROL__WRITE                               0xb000b000U

#endif /* __ADDAC_PARALLEL_CONTROL_MACRO__ */


/* macros for bb_reg_map.bb_sm_reg_map.BB_addac_parallel_control */
#define INST_BB_REG_MAP__BB_SM_REG_MAP__BB_ADDAC_PARALLEL_CONTROL__NUM        1

/* macros for BlueprintGlobalNameSpace::force_clock */
#ifndef __FORCE_CLOCK_MACRO__
#define __FORCE_CLOCK_MACRO__

/* macros for field cf_force_adc_clk_rate */
#define FORCE_CLOCK__CF_FORCE_ADC_CLK_RATE__SHIFT                             0
#define FORCE_CLOCK__CF_FORCE_ADC_CLK_RATE__WIDTH                             1
#define FORCE_CLOCK__CF_FORCE_ADC_CLK_RATE__MASK                    0x00000001U
#define FORCE_CLOCK__CF_FORCE_ADC_CLK_RATE__READ(src) \
                    (u_int32_t)(src)\
                    & 0x00000001U
#define FORCE_CLOCK__CF_FORCE_ADC_CLK_RATE__WRITE(src) \
                    ((u_int32_t)(src)\
                    & 0x00000001U)
#define FORCE_CLOCK__CF_FORCE_ADC_CLK_RATE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | ((u_int32_t)(src) &\
                    0x00000001U)
#define FORCE_CLOCK__CF_FORCE_ADC_CLK_RATE__VERIFY(src) \
                    (!(((u_int32_t)(src)\
                    & ~0x00000001U)))
#define FORCE_CLOCK__CF_FORCE_ADC_CLK_RATE__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(1)
#define FORCE_CLOCK__CF_FORCE_ADC_CLK_RATE__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000001U) | (u_int32_t)(0)

/* macros for field cf_forced_adc_clk_rate */
#define FORCE_CLOCK__CF_FORCED_ADC_CLK_RATE__SHIFT                            1
#define FORCE_CLOCK__CF_FORCED_ADC_CLK_RATE__WIDTH                            2
#define FORCE_CLOCK__CF_FORCED_ADC_CLK_RATE__MASK                   0x00000006U
#define FORCE_CLOCK__CF_FORCED_ADC_CLK_RATE__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000006U) >> 1)
#define FORCE_CLOCK__CF_FORCED_ADC_CLK_RATE__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 1) & 0x00000006U)
#define FORCE_CLOCK__CF_FORCED_ADC_CLK_RATE__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000006U) | (((u_int32_t)(src) <<\
                    1) & 0x00000006U)
#define FORCE_CLOCK__CF_FORCED_ADC_CLK_RATE__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 1) & ~0x00000006U)))

/* macros for field cf_force_radio_bw */
#define FORCE_CLOCK__CF_FORCE_RADIO_BW__SHIFT                                 5
#define FORCE_CLOCK__CF_FORCE_RADIO_BW__WIDTH                                 1
#define FORCE_CLOCK__CF_FORCE_RADIO_BW__MASK                        0x00000020U
#define FORCE_CLOCK__CF_FORCE_RADIO_BW__READ(src) \
                    (((u_int32_t)(src)\
                    & 0x00000020U) >> 5)
#define FORCE_CLOCK__CF_FORCE_RADIO_BW__WRITE(src) \
                    (((u_int32_t)(src)\
                    << 5) & 0x00000020U)
#define FORCE_CLOCK__CF_FORCE_RADIO_BW__MODIFY(dst, src) \
                    (dst) = ((dst) &\
                    ~0x00000020U) | (((u_int32_t)(src) <<\
                    5) & 0x00000020U)
#define FORCE_CLOCK__CF_FORCE_RADIO_BW__VERIFY(src) \
                    (!((((u_int32_t)(src)\
                    << 5) & ~0x00000020U)))
#define FORCE_CLOCK__CF_FORCE_RADIO_BW__SET(dst) \
                    (dst) = ((dst) &\
                    ~0x00000020U) | ((u_int32_t)(1) << 5)
#define FORCE_CLOCK__CF_FORCE_RADIO_BW__CLR(dst) \
                    (dst) = ((dst) &\
                    ~0x00000020U) | ((u_int32_t)(0) << 5)

/* macros for fi